!     path:      $Source$
!     author:    $Author$
!     revision:  $Revision$
!     created:   $Date$

!----------------------------------------------------------------------------
! Copyright (c) 2002-2016, Atmospheric & Environmental Research, Inc. (AER)
! All rights reserved.
!
! Redistribution and use in source and binary forms, with or without
! modification, are permitted provided that the following conditions are met:
!  * Redistributions of source code must retain the above copyright
!    notice, this list of conditions and the following disclaimer.
!  * Redistributions in binary form must reproduce the above copyright
!    notice, this list of conditions and the following disclaimer in the
!    documentation and/or other materials provided with the distribution.
!  * Neither the name of Atmospheric & Environmental Research, Inc., nor
!    the names of its contributors may be used to endorse or promote products
!    derived from this software without specific prior written permission.
!
! THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
! AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
! IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
! ARE DISCLAIMED. IN NO EVENT SHALL ATMOSPHERIC & ENVIRONMENTAL RESEARCH, INC., 
! BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
! CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
! SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
! INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
! CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
! ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
! THE POSSIBILITY OF SUCH DAMAGE.
!                        (http://www.rtweb.aer.com/)                        
!----------------------------------------------------------------------------

! **************************************************************************
!      subroutine sw_kgbnn
! **************************************************************************
!  RRTM Shortwave Radiative Transfer Model
!  Atmospheric and Environmental Research, Inc., Cambridge, MA
!
!  Original by J.Delamere, Atmospheric & Environmental Research.
!  Reformatted for F90: JJMorcrette, ECMWF
!  Further F90 and GCM revisions:  MJIacono, AER, July 2002
!  Solar variability revisions:  MJIacono, AER, November 2015
!
!  This file contains 14 subroutines that include the 
!  absorption coefficients and other data for each of the 14 shortwave
!  spectral bands used in RRTM_SW.  Here, the data are defined for 16
!  g-points, or sub-intervals, per band.  These data are combined and
!  weighted using a mapping procedure in routine RRTMG_SW_INIT to reduce
!  the total number of g-points from 224 to 112 for use in the GCM.
! **************************************************************************
      subroutine sw_kgb24
! **************************************************************************

      !use parkind, only : im => kind , rb => kind  
      use rrsw_kg24, only : kao, kbo, selfrefo, forrefo, sfluxrefo, &
                            raylao, raylbo, abso3ao, abso3bo, &
                            irradnceo, facbrghto, snsptdrko

      implicit none
      save

! Kurucz solar source function
      sfluxrefo(:,1) = (/ &
        & 34.3610 , 33.1240, 31.3948, 28.7248, &
        & 24.7884 , 21.4892, 17.3972, 13.7928, &
        & 9.54462 , 1.05002,0.867332,0.685753, &
        & 0.504718,0.323112,0.122183, 1.70288e-02 /)
      sfluxrefo(:,2) = (/ &
        & 34.2367 , 32.4327, 30.0863, 28.2085, & 
        & 25.6533 , 22.3412, 18.3112, 13.8521, &
        & 9.51035 , 1.04138,0.863493,0.682790, &
        & 0.504721,0.323102,0.122193, 1.70288e-02 /)
      sfluxrefo(:,3) = (/ &
        & 34.1883 , 32.2479, 30.2650, 28.2914, &
        & 25.6626 , 22.3163, 18.3327, 13.8508, &
        & 9.49190 , 1.03672,0.858272,0.681485, &
        & 0.501363,0.323110,0.122183, 1.70288e-02 /)
      sfluxrefo(:,4) = (/ &
        & 34.1365 , 32.2316, 30.3325, 28.3305, &
        & 25.6420 , 22.3223, 18.3411, 13.8471, &
        & 9.47492 , 1.03376,0.855380,0.679085, &
        & 0.497998,0.323053,0.122183, 1.70288e-02 /)
      sfluxrefo(:,5) = (/ &
        & 34.0460 , 32.2795, 30.4147, 28.3123, &
        & 25.6438 , 22.3238, 18.3441, 13.8528, &
        & 9.45222 , 1.03058,0.854037,0.675554, &
        & 0.498344,0.320072,0.122193, 1.70288e-02 /)
      sfluxrefo(:,6) = (/ &
        & 33.9909 , 32.3127, 30.4854, 28.3005, &
        & 25.6310 , 22.3294, 18.3459, 13.8488, &
        & 9.43336 , 1.02901,0.852728,0.672322, &
        & 0.498056,0.317753,0.122183, 1.70288e-02 /)
      sfluxrefo(:,7) = (/ &
        & 33.9225 , 32.4097, 30.5125, 28.2810, &
        & 25.6387 , 22.3080, 18.3715, 13.8248, &
        & 9.41834 , 1.02735,0.850807,0.671379, &
        & 0.496975,0.317158,0.119297, 1.70207e-02 /)
      sfluxrefo(:,8) = (/ &
        & 33.8940 , 32.4951, 30.5494, 28.2788, &
        & 25.5975 , 22.3225, 18.3358, 13.8199, &
        & 9.40283 , 1.02751,0.850729,0.670152, &
        & 0.494294,0.315829,0.116195, 1.64138e-02 /)
      sfluxrefo(:,9) = (/ &
        & 34.6501 , 32.6690, 30.2872, 28.0955, &
        & 25.4662 , 22.1446, 18.2754, 13.7573, &
        & 9.36645 , 1.02356,0.847154,0.668519, &
        & 0.489186,0.313790,0.117074, 1.60943e-02 /)

! Solar variability components: time-invariant baseline quiet sun irradiance
      irradnceo(:,1) = (/ &
        & 3.38239E+01, 3.27296E+01, 3.11228E+01, 2.82167E+01,&
        & 2.46948E+01, 2.16414E+01, 1.74835E+01, 1.32861E+01,&
        & 9.45231E+00, 1.03668E+00, 8.57301E-01, 6.79586E-01,&
        & 4.99821E-01, 3.23048E-01, 1.21798E-01, 1.70540E-02/)
      irradnceo(:,2) = (/ &
        & 3.35554E+01, 3.22649E+01, 3.01925E+01, 2.81328E+01,&
        & 2.49992E+01, 2.19854E+01, 1.81805E+01, 1.37450E+01,&
        & 9.41060E+00, 1.02791E+00, 8.54156E-01, 6.76306E-01,&
        & 4.99827E-01, 3.23048E-01, 1.21797E-01, 1.70536E-02/)
      irradnceo(:,3) = (/ &
        & 3.34467E+01, 3.23718E+01, 3.01698E+01, 2.78745E+01,&
        & 2.51400E+01, 2.21238E+01, 1.81919E+01, 1.37667E+01,&
        & 9.39403E+00, 1.02425E+00, 8.49685E-01, 6.75455E-01,&
        & 4.95915E-01, 3.23049E-01, 1.21797E-01, 1.70536E-02/)
      irradnceo(:,4) = (/ &
        & 3.34003E+01, 3.23834E+01, 3.01815E+01, 2.76780E+01,&
        & 2.53527E+01, 2.21350E+01, 1.82215E+01, 1.37599E+01,&
        & 9.37564E+00, 1.02444E+00, 8.45988E-01, 6.73624E-01,&
        & 4.92319E-01, 3.23047E-01, 1.21798E-01, 1.70540E-02/)
      irradnceo(:,5) = (/ &
        & 3.33672E+01, 3.24037E+01, 3.00634E+01, 2.77926E+01,&
        & 2.53807E+01, 2.21495E+01, 1.82232E+01, 1.37618E+01,&
        & 9.35660E+00, 1.02194E+00, 8.45650E-01, 6.68806E-01,&
        & 4.93432E-01, 3.18983E-01, 1.21798E-01, 1.70536E-02/)
      irradnceo(:,6) = (/ &
        & 3.33640E+01, 3.24077E+01, 2.99963E+01, 2.78755E+01,&
        & 2.53793E+01, 2.21660E+01, 1.82184E+01, 1.37630E+01,&
        & 9.33929E+00, 1.01814E+00, 8.45425E-01, 6.65897E-01,&
        & 4.92871E-01, 3.15736E-01, 1.21798E-01, 1.70537E-02/)
      irradnceo(:,7) = (/ &
        & 3.34026E+01, 3.23037E+01, 3.00416E+01, 2.79192E+01,&
        & 2.53921E+01, 2.21484E+01, 1.82369E+01, 1.37476E+01,&
        & 9.32780E+00, 1.01552E+00, 8.44236E-01, 6.62810E-01,&
        & 4.93390E-01, 3.14906E-01, 1.18661E-01, 1.70540E-02/)
      irradnceo(:,8) = (/ &
        & 3.34349E+01, 3.22043E+01, 3.01812E+01, 2.79465E+01,&
        & 2.53583E+01, 2.21412E+01, 1.82094E+01, 1.37441E+01,&
        & 9.30754E+00, 1.01515E+00, 8.44497E-01, 6.64404E-01,&
        & 4.90144E-01, 3.13759E-01, 1.14835E-01, 1.59848E-02/)
      irradnceo(:,9) = (/ &
        & 3.42460E+01, 3.21388E+01, 3.01095E+01, 2.78438E+01,&
        & 2.51368E+01, 2.19795E+01, 1.81249E+01, 1.36909E+01,&
        & 9.28218E+00, 1.01157E+00, 8.34889E-01, 6.62795E-01,&
        & 4.82903E-01, 3.10708E-01, 1.15840E-01, 1.53240E-02/)
! Solar variability components: facular brightening
      facbrghto(:,1) = (/ &
        & 2.27755E-02, 2.26285E-02, 2.12830E-02, 1.91126E-02,&
        & 1.67851E-02, 1.44155E-02, 1.19158E-02, 9.11355E-03,&
        & 6.13074E-03, 6.65603E-04, 5.51160E-04, 4.35798E-04,&
        & 3.18203E-04, 2.02405E-04, 7.62470E-05, 1.06905E-05/)
      facbrghto(:,2) = (/ &
        & 2.23790E-02, 2.16948E-02, 2.05743E-02, 1.91817E-02,&
        & 1.72122E-02, 1.50738E-02, 1.24159E-02, 9.33385E-03,&
        & 6.27454E-03, 6.76661E-04, 5.58449E-04, 4.37748E-04,&
        & 3.18201E-04, 2.02405E-04, 7.62472E-05, 1.06903E-05/)
      facbrghto(:,3) = (/ &
        & 2.23205E-02, 2.16964E-02, 2.05153E-02, 1.90960E-02,&
        & 1.73148E-02, 1.51096E-02, 1.24225E-02, 9.34252E-03,&
        & 6.30103E-03, 6.84142E-04, 5.63563E-04, 4.43842E-04,&
        & 3.20746E-04, 2.02405E-04, 7.62472E-05, 1.06903E-05/)
      facbrghto(:,4) = (/ &
        & 2.22812E-02, 2.16786E-02, 2.05018E-02, 1.90906E-02,&
        & 1.73540E-02, 1.51044E-02, 1.24167E-02, 9.35686E-03,&
        & 6.31755E-03, 6.88726E-04, 5.67731E-04, 4.47107E-04,&
        & 3.25740E-04, 2.02405E-04, 7.62470E-05, 1.06905E-05/)
      facbrghto(:,5) = (/ &
        & 2.22603E-02, 2.16691E-02, 2.04730E-02, 1.91155E-02,&
        & 1.73538E-02, 1.51053E-02, 1.24114E-02, 9.35858E-03,&
        & 6.34033E-03, 6.91459E-04, 5.71435E-04, 4.50296E-04,&
        & 3.28452E-04, 2.04401E-04, 7.62466E-05, 1.06903E-05/)
      facbrghto(:,6) = (/ &
        & 2.22503E-02, 2.16603E-02, 2.04609E-02, 1.91224E-02,&
        & 1.73466E-02, 1.50949E-02, 1.24176E-02, 9.35948E-03,&
        & 6.36072E-03, 6.94634E-04, 5.74816E-04, 4.52589E-04,&
        & 3.30669E-04, 2.07385E-04, 7.62464E-05, 1.06902E-05/)
      facbrghto(:,7) = (/ &
        & 2.22404E-02, 2.16460E-02, 2.04721E-02, 1.91049E-02,&
        & 1.73389E-02, 1.50869E-02, 1.24130E-02, 9.37898E-03,&
        & 6.37863E-03, 6.98281E-04, 5.76667E-04, 4.55019E-04,&
        & 3.32114E-04, 2.10190E-04, 7.76838E-05, 1.06905E-05/)
      facbrghto(:,8) = (/ &
        & 2.22271E-02, 2.16444E-02, 2.04889E-02, 1.90545E-02,&
        & 1.73157E-02, 1.50884E-02, 1.24141E-02, 9.40991E-03,&
        & 6.40225E-03, 7.00595E-04, 5.78910E-04, 4.56887E-04,&
        & 3.34204E-04, 2.12237E-04, 8.08640E-05, 1.13871E-05/)
      facbrghto(:,9) = (/ &
        & 2.21786E-02, 2.17062E-02, 2.04904E-02, 1.90487E-02,&
        & 1.72650E-02, 1.50602E-02, 1.24407E-02, 9.42235E-03,&
        & 6.41377E-03, 7.02970E-04, 5.83184E-04, 4.61075E-04,&
        & 3.38668E-04, 2.15750E-04, 8.14294E-05, 1.13965E-05/)
! Solar variability components: sunspot darkening
      snsptdrko(:,1) = (/ &
        &-1.12410E-02,-1.12113E-02,-1.10779E-02,-1.04292E-02,&
        &-8.98961E-03,-8.03572E-03,-6.75787E-03,-5.03467E-03,&
        &-3.17957E-03,-3.38985E-04,-2.81562E-04,-2.23039E-04,&
        &-1.60087E-04,-1.01767E-04,-3.83353E-05,-5.36521E-06/)
      snsptdrko(:,2) = (/ &
        &-1.15334E-02,-1.15873E-02,-1.09714E-02,-1.02601E-02,&
        &-9.40127E-03,-7.93115E-03,-6.35550E-03,-4.74664E-03,&
        &-3.16591E-03,-3.41515E-04,-2.82907E-04,-2.23426E-04,&
        &-1.60087E-04,-1.01767E-04,-3.83353E-05,-5.36519E-06/)
      snsptdrko(:,3) = (/ &
        &-1.16018E-02,-1.15197E-02,-1.10428E-02,-1.04082E-02,&
        &-9.29123E-03,-7.83257E-03,-6.34771E-03,-4.73395E-03,&
        &-3.17002E-03,-3.43867E-04,-2.83776E-04,-2.24084E-04,&
        &-1.60764E-04,-1.01767E-04,-3.83353E-05,-5.36519E-06/)
      snsptdrko(:,4) = (/ &
        &-1.16474E-02,-1.14951E-02,-1.11033E-02,-1.04579E-02,&
        &-9.17511E-03,-7.82181E-03,-6.33620E-03,-4.73236E-03,&
        &-3.17528E-03,-3.45134E-04,-2.84910E-04,-2.23675E-04,&
        &-1.62387E-04,-1.01767E-04,-3.83353E-05,-5.36521E-06/)
      snsptdrko(:,5) = (/ &
        &-1.16739E-02,-1.14817E-02,-1.11986E-02,-1.03868E-02,&
        &-9.13950E-03,-7.82100E-03,-6.32953E-03,-4.72539E-03,&
        &-3.18466E-03,-3.46317E-04,-2.85694E-04,-2.23434E-04,&
        &-1.63185E-04,-1.02484E-04,-3.83352E-05,-5.36519E-06/)
      snsptdrko(:,6) = (/ &
        &-1.16800E-02,-1.14904E-02,-1.12697E-02,-1.03121E-02,&
        &-9.12987E-03,-7.81075E-03,-6.32982E-03,-4.72246E-03,&
        &-3.19329E-03,-3.47036E-04,-2.85401E-04,-2.24107E-04,&
        &-1.63894E-04,-1.03476E-04,-3.83350E-05,-5.36523E-06/)
      snsptdrko(:,7) = (/ &
        &-1.16773E-02,-1.15299E-02,-1.12771E-02,-1.02691E-02,&
        &-9.12264E-03,-7.80854E-03,-6.32243E-03,-4.72944E-03,&
        &-3.19917E-03,-3.46451E-04,-2.85885E-04,-2.25076E-04,&
        &-1.64410E-04,-1.04310E-04,-3.88550E-05,-5.36521E-06/)
      snsptdrko(:,8) = (/ &
        &-1.16665E-02,-1.15865E-02,-1.12398E-02,-1.02548E-02,&
        &-9.10945E-03,-7.80524E-03,-6.32783E-03,-4.73915E-03,&
        &-3.20164E-03,-3.47046E-04,-2.86536E-04,-2.25780E-04,&
        &-1.65140E-04,-1.04907E-04,-3.99159E-05,-5.63205E-06/)
      snsptdrko(:,9) = (/ &
        &-1.11706E-02,-1.16970E-02,-1.13426E-02,-1.03468E-02,&
        &-9.16736E-03,-7.85391E-03,-6.36547E-03,-4.76183E-03,&
        &-3.21544E-03,-3.49450E-04,-2.88904E-04,-2.28050E-04,&
        &-1.66800E-04,-1.06063E-04,-4.00684E-05,-5.63614E-06/)

! Rayleigh extinction coefficient at all v
      raylao(:,1) = (/ &
        & 1.28405e-07,1.45501e-07,1.67272e-07,1.94856e-07, &
        & 2.15248e-07,2.34920e-07,2.48558e-07,1.80004e-07, &
        & 1.46504e-07,1.31355e-07,1.33562e-07,1.35618e-07, &
        & 1.22412e-07,1.19842e-07,1.19924e-07,1.20264e-07 /)
      raylao(:,2) = (/ &
        & 1.41622e-07,1.93436e-07,2.25057e-07,2.01025e-07, &
        & 1.85138e-07,1.72672e-07,1.64771e-07,1.59312e-07, &
        & 1.44961e-07,1.37448e-07,1.37506e-07,1.38081e-07, &
        & 1.22432e-07,1.19844e-07,1.19921e-07,1.20287e-07 /)
      raylao(:,3) = (/ &
        & 1.45382e-07,1.97020e-07,2.22781e-07,1.96062e-07, &
        & 1.83495e-07,1.72495e-07,1.64910e-07,1.58797e-07, &
        & 1.46208e-07,1.42274e-07,1.40445e-07,1.39496e-07, &
        & 1.26940e-07,1.19844e-07,1.19921e-07,1.20287e-07 /)
      raylao(:,4) = (/ &
        & 1.48247e-07,1.99958e-07,2.18048e-07,1.93896e-07, &
        & 1.83125e-07,1.73244e-07,1.64320e-07,1.58298e-07, &
        & 1.48428e-07,1.44769e-07,1.43704e-07,1.38498e-07, &
        & 1.31732e-07,1.22299e-07,1.19921e-07,1.20287e-07 /)
      raylao(:,5) = (/ &
        & 1.51343e-07,1.99621e-07,2.14563e-07,1.93824e-07, &
        & 1.82992e-07,1.73143e-07,1.64587e-07,1.57355e-07, &
        & 1.51198e-07,1.46373e-07,1.45438e-07,1.38095e-07, &
        & 1.35026e-07,1.27504e-07,1.19921e-07,1.20287e-07 /)
      raylao(:,6) = (/ &
        & 1.54462e-07,1.97610e-07,2.11992e-07,1.93831e-07, &
        & 1.83900e-07,1.73125e-07,1.64093e-07,1.57651e-07, &
        & 1.53158e-07,1.46843e-07,1.44733e-07,1.40611e-07, &
        & 1.37320e-07,1.33932e-07,1.20423e-07,1.20287e-07 /)
      raylao(:,7) = (/ &
        & 1.59068e-07,1.92757e-07,2.09865e-07,1.95132e-07, &
        & 1.83641e-07,1.73778e-07,1.63215e-07,1.59462e-07, &
        & 1.54331e-07,1.46177e-07,1.45819e-07,1.43177e-07, &
        & 1.39797e-07,1.36780e-07,1.33385e-07,1.20287e-07 /)
      raylao(:,8) = (/ &
        & 1.62066e-07,1.87529e-07,2.07191e-07,1.97788e-07, &
        & 1.84920e-07,1.72951e-07,1.65450e-07,1.60344e-07, &
        & 1.54403e-07,1.47679e-07,1.47287e-07,1.44951e-07, &
        & 1.42517e-07,1.41107e-07,1.48688e-07,1.51127e-07 /)
      raylao(:,9) = (/ &
        & 1.19177e-07,1.86522e-07,2.20324e-07,2.13543e-07, &
        & 1.92198e-07,1.81641e-07,1.70092e-07,1.65072e-07, &
        & 1.59804e-07,1.56745e-07,1.51235e-07,1.51400e-07, &
        & 1.49635e-07,1.48056e-07,1.49046e-07,1.51010e-07 /)

      raylbo(:) = (/ &
        & 1.23766e-07,1.40524e-07,1.61610e-07,1.83232e-07, &
        & 2.02951e-07,2.21367e-07,2.38367e-07,2.53019e-07, &
        & 2.12202e-07,1.36977e-07,1.39118e-07,1.37097e-07, &
        & 1.33223e-07,1.38695e-07,1.19868e-07,1.20062e-07 /)

      abso3ao(:) = (/ &
        & 8.03067e-02,0.180926   ,0.227484   ,0.168015   , &
        & 0.138284   ,0.114537   ,9.50114e-02,8.06816e-02, &
        & 6.76406e-02,5.69802e-02,5.63283e-02,4.57592e-02, &
        & 4.21862e-02,3.47949e-02,2.65731e-02,2.67628e-02 /)

      abso3bo(:) = (/ &
        & 2.94848e-02,4.33642e-02,6.70197e-02,0.104990   , &
        & 0.156180   ,0.214638   ,0.266281   ,0.317941   , &
        & 0.355327   ,0.371241   ,0.374396   ,0.326847   , &
        & 0.126497   ,6.95264e-02,2.58175e-02,2.52862e-02 /)

!     ------------------------------------------------------------------
!     The array KAO contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels> ~100mb, temperatures, and binary
!     species parameters (see taumol.f for definition).  The first 
!     index in the array, JS, runs from 1 to 9, and corresponds to 
!     different values of the binary species parameter.  For instance, 
!     JS=1 refers to dry air, JS = 2 corresponds to the paramter value 1/8, 
!     JS = 3 corresponds to the parameter value 2/8, etc.  The second index
!     in the array, JT, which runs from 1 to 5, corresponds to different
!     temperatures.  More specifically, JT = 3 means that the data are for
!     the reference temperature TREF for this  pressure level, JT = 2 refers
!     to TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and JT = 5
!     is for TREF+30.  The third index, JP, runs from 1 to 13 and refers
!     to the JPth reference pressure level (see taumol.f for these levels
!     in mb).  The fourth index, IG, goes from 1 to 16, and indicates
!     which g-interval the absorption coefficients are for.
!     -----------------------------------------------------------------

      kao(:, 1, 1, 1) = (/ &
        & 0.73110e-09,0.95257e-08,0.84454e-08,0.69367e-08,0.55267e-08, &
        & 0.41107e-08,0.32800e-08,0.33548e-08,0.22111e-08 /)
      kao(:, 2, 1, 1) = (/ &
        & 0.71850e-09,0.98856e-08,0.88084e-08,0.72442e-08,0.57586e-08, &
        & 0.43475e-08,0.34021e-08,0.32425e-08,0.21911e-08 /)
      kao(:, 3, 1, 1) = (/ &
        & 0.57048e-09,0.11944e-07,0.10693e-07,0.91787e-08,0.75423e-08, &
        & 0.56949e-08,0.43124e-08,0.42335e-08,0.57788e-08 /)
      kao(:, 4, 1, 1) = (/ &
        & 0.45283e-09,0.10517e-07,0.93142e-08,0.77267e-08,0.61927e-08, &
        & 0.47485e-08,0.34557e-08,0.32691e-08,0.21836e-08 /)
      kao(:, 5, 1, 1) = (/ &
        & 0.40037e-09,0.10599e-07,0.93529e-08,0.78411e-08,0.63421e-08, &
        & 0.49082e-08,0.36312e-08,0.32874e-08,0.21861e-08 /)
      kao(:, 1, 2, 1) = (/ &
        & 0.77671e-09,0.11163e-07,0.95032e-08,0.79805e-08,0.60721e-08, &
        & 0.45440e-08,0.31263e-08,0.28631e-08,0.19430e-08 /)
      kao(:, 2, 2, 1) = (/ &
        & 0.85527e-09,0.11271e-07,0.97269e-08,0.82280e-08,0.62706e-08, &
        & 0.47926e-08,0.32802e-08,0.28152e-08,0.19155e-08 /)
      kao(:, 3, 2, 1) = (/ &
        & 0.85773e-09,0.13292e-07,0.11943e-07,0.10177e-07,0.81637e-08, &
        & 0.62054e-08,0.44045e-08,0.35504e-08,0.48274e-08 /)
      kao(:, 4, 2, 1) = (/ &
        & 0.76956e-09,0.13343e-07,0.12140e-07,0.10403e-07,0.83916e-08, &
        & 0.64414e-08,0.46212e-08,0.36611e-08,0.46523e-08 /)
      kao(:, 5, 2, 1) = (/ &
        & 0.53187e-09,0.11759e-07,0.10564e-07,0.89416e-08,0.69566e-08, &
        & 0.54336e-08,0.36797e-08,0.28238e-08,0.18838e-08 /)
      kao(:, 1, 3, 1) = (/ &
        & 0.99065e-09,0.13223e-07,0.11222e-07,0.94282e-08,0.74664e-08, &
        & 0.54084e-08,0.35205e-08,0.24806e-08,0.20205e-08 /)
      kao(:, 2, 3, 1) = (/ &
        & 0.98793e-09,0.13673e-07,0.11444e-07,0.96735e-08,0.76364e-08, &
        & 0.55809e-08,0.37259e-08,0.25419e-08,0.20086e-08 /)
      kao(:, 3, 3, 1) = (/ &
        & 0.10274e-08,0.14243e-07,0.12051e-07,0.10168e-07,0.80110e-08, &
        & 0.59129e-08,0.38720e-08,0.26806e-08,0.19959e-08 /)
      kao(:, 4, 3, 1) = (/ &
        & 0.10879e-08,0.15991e-07,0.14290e-07,0.12193e-07,0.99943e-08, &
        & 0.76411e-08,0.49949e-08,0.32117e-08,0.45196e-08 /)
      kao(:, 5, 3, 1) = (/ &
        & 0.10733e-08,0.14460e-07,0.12483e-07,0.10703e-07,0.84924e-08, &
        & 0.62896e-08,0.42753e-08,0.27408e-08,0.19679e-08 /)
      kao(:, 1, 4, 1) = (/ &
        & 0.11948e-08,0.15804e-07,0.13423e-07,0.10964e-07,0.86345e-08, &
        & 0.61421e-08,0.39130e-08,0.24271e-08,0.26282e-08 /)
      kao(:, 2, 4, 1) = (/ &
        & 0.12796e-08,0.16985e-07,0.14121e-07,0.11784e-07,0.93415e-08, &
        & 0.67310e-08,0.43124e-08,0.25170e-08,0.26033e-08 /)
      kao(:, 3, 4, 1) = (/ &
        & 0.12903e-08,0.17863e-07,0.14703e-07,0.12387e-07,0.99243e-08, &
        & 0.72283e-08,0.46892e-08,0.26092e-08,0.25739e-08 /)
      kao(:, 4, 4, 1) = (/ &
        & 0.13030e-08,0.17982e-07,0.14488e-07,0.12389e-07,0.10284e-07, &
        & 0.76192e-08,0.50049e-08,0.27184e-08,0.25450e-08 /)
      kao(:, 5, 4, 1) = (/ &
        & 0.13295e-08,0.20084e-07,0.17213e-07,0.15086e-07,0.12255e-07, &
        & 0.93192e-08,0.61747e-08,0.34151e-08,0.50409e-08 /)
      kao(:, 1, 5, 1) = (/ &
        & 0.14930e-08,0.19740e-07,0.16353e-07,0.13382e-07,0.10370e-07, &
        & 0.76167e-08,0.46913e-08,0.23740e-08,0.37254e-08 /)
      kao(:, 2, 5, 1) = (/ &
        & 0.15750e-08,0.20826e-07,0.17352e-07,0.14080e-07,0.11109e-07, &
        & 0.82293e-08,0.51142e-08,0.25900e-08,0.36977e-08 /)
      kao(:, 3, 5, 1) = (/ &
        & 0.16427e-08,0.22313e-07,0.18005e-07,0.14545e-07,0.11545e-07, &
        & 0.85987e-08,0.53849e-08,0.27523e-08,0.36628e-08 /)
      kao(:, 4, 5, 1) = (/ &
        & 0.17106e-08,0.23821e-07,0.18882e-07,0.15226e-07,0.12313e-07, &
        & 0.92367e-08,0.58646e-08,0.29020e-08,0.36336e-08 /)
      kao(:, 5, 5, 1) = (/ &
        & 0.17465e-08,0.26750e-07,0.22103e-07,0.18690e-07,0.15320e-07, &
        & 0.11508e-07,0.77281e-08,0.34929e-08,0.69801e-08 /)
      kao(:, 1, 6, 1) = (/ &
        & 0.17561e-08,0.17298e-07,0.18888e-07,0.16164e-07,0.12676e-07, &
        & 0.91128e-08,0.57292e-08,0.25945e-08,0.52718e-08 /)
      kao(:, 2, 6, 1) = (/ &
        & 0.19997e-08,0.20866e-07,0.20612e-07,0.17467e-07,0.13431e-07, &
        & 0.96178e-08,0.60009e-08,0.28959e-08,0.52609e-08 /)
      kao(:, 3, 6, 1) = (/ &
        & 0.21808e-08,0.24689e-07,0.22590e-07,0.18672e-07,0.14573e-07, &
        & 0.10599e-07,0.66802e-08,0.31104e-08,0.52649e-08 /)
      kao(:, 4, 6, 1) = (/ &
        & 0.22321e-08,0.28043e-07,0.23802e-07,0.19473e-07,0.15182e-07, &
        & 0.11372e-07,0.73223e-08,0.34820e-08,0.52977e-08 /)
      kao(:, 5, 6, 1) = (/ &
        & 0.23033e-08,0.30784e-07,0.25188e-07,0.20376e-07,0.16019e-07, &
        & 0.12009e-07,0.77933e-08,0.37322e-08,0.52777e-08 /)
      kao(:, 1, 7, 1) = (/ &
        & 0.22679e-08,0.13507e-07,0.20320e-07,0.19549e-07,0.15905e-07, &
        & 0.11277e-07,0.68710e-08,0.29328e-08,0.79703e-08 /)
      kao(:, 2, 7, 1) = (/ &
        & 0.25718e-08,0.16957e-07,0.24375e-07,0.21175e-07,0.17080e-07, &
        & 0.12233e-07,0.77114e-08,0.34113e-08,0.79963e-08 /)
      kao(:, 3, 7, 1) = (/ &
        & 0.27598e-08,0.19896e-07,0.28092e-07,0.23059e-07,0.18272e-07, &
        & 0.13117e-07,0.84449e-08,0.37817e-08,0.79824e-08 /)
      kao(:, 4, 7, 1) = (/ &
        & 0.28979e-08,0.22997e-07,0.29556e-07,0.24211e-07,0.19134e-07, &
        & 0.13799e-07,0.90980e-08,0.41849e-08,0.79622e-08 /)
      kao(:, 5, 7, 1) = (/ &
        & 0.31158e-08,0.26193e-07,0.32426e-07,0.25685e-07,0.19970e-07, &
        & 0.14504e-07,0.96379e-08,0.45034e-08,0.78914e-08 /)
      kao(:, 1, 8, 1) = (/ &
        & 0.27286e-08,0.10085e-07,0.15014e-07,0.19090e-07,0.19831e-07, &
        & 0.15054e-07,0.91059e-08,0.39324e-08,0.14155e-07 /)
      kao(:, 2, 8, 1) = (/ &
        & 0.30146e-08,0.12680e-07,0.19259e-07,0.23896e-07,0.21584e-07, &
        & 0.16217e-07,0.99712e-08,0.44108e-08,0.14243e-07 /)
      kao(:, 3, 8, 1) = (/ &
        & 0.35571e-08,0.15989e-07,0.23328e-07,0.28003e-07,0.22999e-07, &
        & 0.17316e-07,0.10856e-07,0.49279e-08,0.13770e-07 /)
      kao(:, 4, 8, 1) = (/ &
        & 0.40065e-08,0.19481e-07,0.27247e-07,0.30922e-07,0.24592e-07, &
        & 0.18005e-07,0.11331e-07,0.53242e-08,0.13758e-07 /)
      kao(:, 5, 8, 1) = (/ &
        & 0.44047e-08,0.23368e-07,0.31337e-07,0.33478e-07,0.26467e-07, &
        & 0.19093e-07,0.12194e-07,0.56088e-08,0.13665e-07 /)
      kao(:, 1, 9, 1) = (/ &
        & 0.32692e-08,0.79127e-08,0.11108e-07,0.13962e-07,0.15949e-07, &
        & 0.18125e-07,0.12367e-07,0.53666e-08,0.28048e-07 /)
      kao(:, 2, 9, 1) = (/ &
        & 0.39872e-08,0.10056e-07,0.14185e-07,0.17838e-07,0.20262e-07, &
        & 0.19824e-07,0.13459e-07,0.59111e-08,0.29491e-07 /)
      kao(:, 3, 9, 1) = (/ &
        & 0.46117e-08,0.12472e-07,0.17902e-07,0.22130e-07,0.25362e-07, &
        & 0.21745e-07,0.14226e-07,0.62741e-08,0.30373e-07 /)
      kao(:, 4, 9, 1) = (/ &
        & 0.52024e-08,0.15275e-07,0.21923e-07,0.27295e-07,0.30210e-07, &
        & 0.23240e-07,0.15087e-07,0.66869e-08,0.31196e-07 /)
      kao(:, 5, 9, 1) = (/ &
        & 0.56198e-08,0.17975e-07,0.26684e-07,0.30762e-07,0.34012e-07, &
        & 0.25509e-07,0.16208e-07,0.72951e-08,0.31583e-07 /)
      kao(:, 1,10, 1) = (/ &
        & 0.48178e-08,0.70531e-08,0.93321e-08,0.10834e-07,0.12386e-07, &
        & 0.13718e-07,0.14795e-07,0.73464e-08,0.35934e-07 /)
      kao(:, 2,10, 1) = (/ &
        & 0.55752e-08,0.86985e-08,0.11492e-07,0.13823e-07,0.15291e-07, &
        & 0.17278e-07,0.18153e-07,0.81439e-08,0.37177e-07 /)
      kao(:, 3,10, 1) = (/ &
        & 0.63274e-08,0.10735e-07,0.13985e-07,0.17136e-07,0.19303e-07, &
        & 0.20940e-07,0.20044e-07,0.88008e-08,0.38431e-07 /)
      kao(:, 4,10, 1) = (/ &
        & 0.70007e-08,0.12858e-07,0.17195e-07,0.20946e-07,0.23543e-07, &
        & 0.25732e-07,0.21748e-07,0.95846e-08,0.39768e-07 /)
      kao(:, 5,10, 1) = (/ &
        & 0.75858e-08,0.15576e-07,0.20803e-07,0.25331e-07,0.28222e-07, &
        & 0.30974e-07,0.23346e-07,0.10532e-07,0.41126e-07 /)
      kao(:, 1,11, 1) = (/ &
        & 0.71066e-08,0.91105e-08,0.91823e-08,0.10078e-07,0.11080e-07, &
        & 0.11808e-07,0.12592e-07,0.10585e-07,0.36646e-07 /)
      kao(:, 2,11, 1) = (/ &
        & 0.75651e-08,0.10196e-07,0.11288e-07,0.12341e-07,0.13264e-07, &
        & 0.14635e-07,0.15304e-07,0.12113e-07,0.37821e-07 /)
      kao(:, 3,11, 1) = (/ &
        & 0.84521e-08,0.11641e-07,0.13494e-07,0.15134e-07,0.16494e-07, &
        & 0.17667e-07,0.18637e-07,0.13998e-07,0.39151e-07 /)
      kao(:, 4,11, 1) = (/ &
        & 0.96535e-08,0.13091e-07,0.16210e-07,0.18132e-07,0.20108e-07, &
        & 0.21506e-07,0.22578e-07,0.15372e-07,0.40534e-07 /)
      kao(:, 5,11, 1) = (/ &
        & 0.10866e-07,0.15259e-07,0.19222e-07,0.21816e-07,0.23808e-07, &
        & 0.25779e-07,0.26640e-07,0.16560e-07,0.41783e-07 /)
      kao(:, 1,12, 1) = (/ &
        & 0.80834e-08,0.10420e-07,0.92387e-08,0.95448e-08,0.10004e-07, &
        & 0.10210e-07,0.10715e-07,0.12956e-07,0.37307e-07 /)
      kao(:, 2,12, 1) = (/ &
        & 0.93300e-08,0.11721e-07,0.10935e-07,0.11240e-07,0.12099e-07, &
        & 0.12529e-07,0.12978e-07,0.14968e-07,0.38619e-07 /)
      kao(:, 3,12, 1) = (/ &
        & 0.10509e-07,0.12830e-07,0.12793e-07,0.13649e-07,0.14634e-07, &
        & 0.15024e-07,0.15635e-07,0.17087e-07,0.40001e-07 /)
      kao(:, 4,12, 1) = (/ &
        & 0.11973e-07,0.14173e-07,0.14811e-07,0.16236e-07,0.17652e-07, &
        & 0.18139e-07,0.18897e-07,0.19167e-07,0.41426e-07 /)
      kao(:, 5,12, 1) = (/ &
        & 0.13412e-07,0.16145e-07,0.17438e-07,0.18946e-07,0.20873e-07, &
        & 0.21649e-07,0.22446e-07,0.20222e-07,0.42866e-07 /)
      kao(:, 1,13, 1) = (/ &
        & 0.96752e-08,0.12525e-07,0.10944e-07,0.96402e-08,0.92613e-08, &
        & 0.89183e-08,0.91757e-08,0.10962e-07,0.37700e-07 /)
      kao(:, 2,13, 1) = (/ &
        & 0.10573e-07,0.14013e-07,0.12095e-07,0.11243e-07,0.11108e-07, &
        & 0.10880e-07,0.11099e-07,0.12700e-07,0.39054e-07 /)
      kao(:, 3,13, 1) = (/ &
        & 0.12096e-07,0.15476e-07,0.13719e-07,0.13357e-07,0.13060e-07, &
        & 0.13122e-07,0.13232e-07,0.14320e-07,0.40767e-07 /)
      kao(:, 4,13, 1) = (/ &
        & 0.13461e-07,0.16674e-07,0.15454e-07,0.15611e-07,0.15616e-07, &
        & 0.15505e-07,0.16233e-07,0.16510e-07,0.42192e-07 /)
      kao(:, 5,13, 1) = (/ &
        & 0.14863e-07,0.17307e-07,0.17245e-07,0.18041e-07,0.18314e-07, &
        & 0.18445e-07,0.19222e-07,0.18635e-07,0.43353e-07 /)
      kao(:, 1, 1, 2) = (/ &
        & 0.11698e-08,0.30848e-07,0.36454e-07,0.38710e-07,0.45901e-07, &
        & 0.55227e-07,0.66976e-07,0.88407e-07,0.23422e-07 /)
      kao(:, 2, 1, 2) = (/ &
        & 0.11855e-08,0.31924e-07,0.37139e-07,0.40576e-07,0.48515e-07, &
        & 0.57453e-07,0.68267e-07,0.87661e-07,0.23548e-07 /)
      kao(:, 3, 1, 2) = (/ &
        & 0.14595e-08,0.39594e-07,0.49562e-07,0.62806e-07,0.77187e-07, &
        & 0.93412e-07,0.11204e-06,0.13944e-06,0.36327e-07 /)
      kao(:, 4, 1, 2) = (/ &
        & 0.16033e-08,0.32903e-07,0.39616e-07,0.43600e-07,0.51878e-07, &
        & 0.61189e-07,0.71838e-07,0.88579e-07,0.23754e-07 /)
      kao(:, 5, 1, 2) = (/ &
        & 0.16713e-08,0.33816e-07,0.40271e-07,0.44761e-07,0.53112e-07, &
        & 0.62817e-07,0.73214e-07,0.89918e-07,0.23712e-07 /)
      kao(:, 1, 2, 2) = (/ &
        & 0.14413e-08,0.29542e-07,0.33672e-07,0.38233e-07,0.38429e-07, &
        & 0.45175e-07,0.55138e-07,0.73579e-07,0.25050e-07 /)
      kao(:, 2, 2, 2) = (/ &
        & 0.13819e-08,0.33839e-07,0.35660e-07,0.39637e-07,0.40862e-07, &
        & 0.47496e-07,0.56716e-07,0.72256e-07,0.25722e-07 /)
      kao(:, 3, 2, 2) = (/ &
        & 0.14034e-08,0.38888e-07,0.49224e-07,0.54694e-07,0.64529e-07, &
        & 0.76758e-07,0.91615e-07,0.11521e-06,0.39473e-07 /)
      kao(:, 4, 2, 2) = (/ &
        & 0.15427e-08,0.40736e-07,0.49562e-07,0.55626e-07,0.65520e-07, &
        & 0.77421e-07,0.92434e-07,0.11487e-06,0.39089e-07 /)
      kao(:, 5, 2, 2) = (/ &
        & 0.19146e-08,0.37020e-07,0.37998e-07,0.40828e-07,0.46417e-07, &
        & 0.52511e-07,0.60306e-07,0.73583e-07,0.26882e-07 /)
      kao(:, 1, 3, 2) = (/ &
        & 0.16720e-08,0.23360e-07,0.34106e-07,0.35883e-07,0.37371e-07, &
        & 0.37719e-07,0.44564e-07,0.59521e-07,0.60171e-07 /)
      kao(:, 2, 3, 2) = (/ &
        & 0.17699e-08,0.26546e-07,0.36000e-07,0.36846e-07,0.38381e-07, &
        & 0.39667e-07,0.46368e-07,0.60306e-07,0.60604e-07 /)
      kao(:, 3, 3, 2) = (/ &
        & 0.18009e-08,0.29450e-07,0.37614e-07,0.38630e-07,0.39041e-07, &
        & 0.41600e-07,0.48142e-07,0.59638e-07,0.61274e-07 /)
      kao(:, 4, 3, 2) = (/ &
        & 0.18222e-08,0.39219e-07,0.48109e-07,0.53485e-07,0.57150e-07, &
        & 0.64444e-07,0.75574e-07,0.94813e-07,0.76759e-07 /)
      kao(:, 5, 3, 2) = (/ &
        & 0.18210e-08,0.34020e-07,0.40366e-07,0.41710e-07,0.42164e-07, &
        & 0.45001e-07,0.49878e-07,0.60009e-07,0.61481e-07 /)
      kao(:, 1, 4, 2) = (/ &
        & 0.21152e-08,0.23706e-07,0.29784e-07,0.35302e-07,0.35282e-07, &
        & 0.34361e-07,0.35938e-07,0.47065e-07,0.17050e-06 /)
      kao(:, 2, 4, 2) = (/ &
        & 0.22014e-08,0.24318e-07,0.33239e-07,0.37390e-07,0.36975e-07, &
        & 0.35774e-07,0.38207e-07,0.49025e-07,0.17312e-06 /)
      kao(:, 3, 4, 2) = (/ &
        & 0.21940e-08,0.26005e-07,0.37067e-07,0.38353e-07,0.38894e-07, &
        & 0.37527e-07,0.40105e-07,0.50082e-07,0.17777e-06 /)
      kao(:, 4, 4, 2) = (/ &
        & 0.23140e-08,0.28378e-07,0.41743e-07,0.40523e-07,0.40492e-07, &
        & 0.38652e-07,0.40876e-07,0.49640e-07,0.18336e-06 /)
      kao(:, 5, 4, 2) = (/ &
        & 0.23213e-08,0.34154e-07,0.50461e-07,0.52357e-07,0.54187e-07, &
        & 0.57113e-07,0.62843e-07,0.77605e-07,0.21695e-06 /)
      kao(:, 1, 5, 2) = (/ &
        & 0.26738e-08,0.26329e-07,0.23971e-07,0.31112e-07,0.35671e-07, &
        & 0.34087e-07,0.29799e-07,0.37789e-07,0.52514e-06 /)
      kao(:, 2, 5, 2) = (/ &
        & 0.25455e-08,0.28564e-07,0.26376e-07,0.34876e-07,0.38195e-07, &
        & 0.36126e-07,0.31889e-07,0.38787e-07,0.53894e-06 /)
      kao(:, 3, 5, 2) = (/ &
        & 0.27955e-08,0.30168e-07,0.29598e-07,0.39256e-07,0.39488e-07, &
        & 0.38121e-07,0.34110e-07,0.40225e-07,0.55617e-06 /)
      kao(:, 4, 5, 2) = (/ &
        & 0.30518e-08,0.31696e-07,0.32642e-07,0.43581e-07,0.40810e-07, &
        & 0.38887e-07,0.35568e-07,0.41837e-07,0.57141e-06 /)
      kao(:, 5, 5, 2) = (/ &
        & 0.29545e-08,0.34626e-07,0.42873e-07,0.52742e-07,0.53043e-07, &
        & 0.52428e-07,0.54304e-07,0.64247e-07,0.63906e-06 /)
      kao(:, 1, 6, 2) = (/ &
        & 0.30127e-08,0.42606e-07,0.28980e-07,0.24923e-07,0.29265e-07, &
        & 0.34534e-07,0.31090e-07,0.30814e-07,0.12844e-05 /)
      kao(:, 2, 6, 2) = (/ &
        & 0.33504e-08,0.42102e-07,0.30491e-07,0.27666e-07,0.33477e-07, &
        & 0.35643e-07,0.33324e-07,0.31448e-07,0.13231e-05 /)
      kao(:, 3, 6, 2) = (/ &
        & 0.37714e-08,0.40516e-07,0.32080e-07,0.30623e-07,0.37391e-07, &
        & 0.37255e-07,0.35144e-07,0.32296e-07,0.13598e-05 /)
      kao(:, 4, 6, 2) = (/ &
        & 0.40809e-08,0.41419e-07,0.33638e-07,0.33756e-07,0.41072e-07, &
        & 0.38814e-07,0.36264e-07,0.33664e-07,0.13955e-05 /)
      kao(:, 5, 6, 2) = (/ &
        & 0.38112e-08,0.42764e-07,0.35694e-07,0.36747e-07,0.45193e-07, &
        & 0.40460e-07,0.37371e-07,0.35107e-07,0.14282e-05 /)
      kao(:, 1, 7, 2) = (/ &
        & 0.36577e-08,0.64857e-07,0.37268e-07,0.28977e-07,0.24480e-07, &
        & 0.26864e-07,0.30486e-07,0.25122e-07,0.20521e-05 /)
      kao(:, 2, 7, 2) = (/ &
        & 0.39427e-08,0.65731e-07,0.37248e-07,0.30585e-07,0.26773e-07, &
        & 0.30114e-07,0.31576e-07,0.26187e-07,0.21480e-05 /)
      kao(:, 3, 7, 2) = (/ &
        & 0.43811e-08,0.66809e-07,0.38170e-07,0.32043e-07,0.28837e-07, &
        & 0.34005e-07,0.32765e-07,0.27322e-07,0.22122e-05 /)
      kao(:, 4, 7, 2) = (/ &
        & 0.46591e-08,0.68244e-07,0.41020e-07,0.34183e-07,0.31347e-07, &
        & 0.37946e-07,0.34473e-07,0.28264e-07,0.22876e-05 /)
      kao(:, 5, 7, 2) = (/ &
        & 0.51635e-08,0.69768e-07,0.42241e-07,0.36125e-07,0.34689e-07, &
        & 0.41422e-07,0.36208e-07,0.29319e-07,0.23528e-05 /)
      kao(:, 1, 8, 2) = (/ &
        & 0.48063e-08,0.99492e-07,0.67977e-07,0.40583e-07,0.27462e-07, &
        & 0.23261e-07,0.24790e-07,0.24175e-07,0.34404e-05 /)
      kao(:, 2, 8, 2) = (/ &
        & 0.46794e-08,0.10207e-06,0.68838e-07,0.41170e-07,0.30068e-07, &
        & 0.24536e-07,0.27696e-07,0.25318e-07,0.35579e-05 /)
      kao(:, 3, 8, 2) = (/ &
        & 0.51560e-08,0.10436e-06,0.69782e-07,0.42105e-07,0.32065e-07, &
        & 0.26776e-07,0.30613e-07,0.26859e-07,0.36807e-05 /)
      kao(:, 4, 8, 2) = (/ &
        & 0.59944e-08,0.10484e-06,0.71027e-07,0.44319e-07,0.34843e-07, &
        & 0.29788e-07,0.33876e-07,0.28922e-07,0.37740e-05 /)
      kao(:, 5, 8, 2) = (/ &
        & 0.64682e-08,0.10541e-06,0.71736e-07,0.46124e-07,0.36934e-07, &
        & 0.32173e-07,0.36502e-07,0.30991e-07,0.38805e-05 /)
      kao(:, 1, 9, 2) = (/ &
        & 0.56433e-08,0.13757e-06,0.10641e-06,0.72870e-07,0.43453e-07, &
        & 0.25530e-07,0.19778e-07,0.25383e-07,0.95912e-05 /)
      kao(:, 2, 9, 2) = (/ &
        & 0.61882e-08,0.14041e-06,0.11046e-06,0.75424e-07,0.44204e-07, &
        & 0.28513e-07,0.22344e-07,0.27258e-07,0.98257e-05 /)
      kao(:, 3, 9, 2) = (/ &
        & 0.68724e-08,0.14355e-06,0.11272e-06,0.76977e-07,0.44934e-07, &
        & 0.30972e-07,0.24609e-07,0.29074e-07,0.10035e-04 /)
      kao(:, 4, 9, 2) = (/ &
        & 0.75288e-08,0.14628e-06,0.11397e-06,0.77508e-07,0.45913e-07, &
        & 0.33498e-07,0.27308e-07,0.31237e-07,0.10206e-04 /)
      kao(:, 5, 9, 2) = (/ &
        & 0.82361e-08,0.14989e-06,0.11575e-06,0.78052e-07,0.47282e-07, &
        & 0.34986e-07,0.29571e-07,0.31933e-07,0.10332e-04 /)
      kao(:, 1,10, 2) = (/ &
        & 0.80705e-08,0.18916e-06,0.16332e-06,0.12182e-06,0.80167e-07, &
        & 0.44659e-07,0.24027e-07,0.20514e-07,0.18076e-04 /)
      kao(:, 2,10, 2) = (/ &
        & 0.86522e-08,0.19825e-06,0.16839e-06,0.12817e-06,0.85984e-07, &
        & 0.48117e-07,0.24937e-07,0.22855e-07,0.18392e-04 /)
      kao(:, 3,10, 2) = (/ &
        & 0.93838e-08,0.20474e-06,0.17472e-06,0.13185e-06,0.89897e-07, &
        & 0.50484e-07,0.27069e-07,0.24729e-07,0.18827e-04 /)
      kao(:, 4,10, 2) = (/ &
        & 0.10442e-07,0.21110e-06,0.17958e-06,0.13546e-06,0.92462e-07, &
        & 0.51368e-07,0.29958e-07,0.26382e-07,0.19325e-04 /)
      kao(:, 5,10, 2) = (/ &
        & 0.11203e-07,0.21676e-06,0.18359e-06,0.14012e-06,0.94090e-07, &
        & 0.51431e-07,0.32637e-07,0.27900e-07,0.19654e-04 /)
      kao(:, 1,11, 2) = (/ &
        & 0.10898e-07,0.20490e-06,0.23352e-06,0.18592e-06,0.13108e-06, &
        & 0.82594e-07,0.41478e-07,0.20359e-07,0.24656e-04 /)
      kao(:, 2,11, 2) = (/ &
        & 0.12100e-07,0.21595e-06,0.24259e-06,0.19598e-06,0.14307e-06, &
        & 0.90287e-07,0.44897e-07,0.21400e-07,0.25439e-04 /)
      kao(:, 3,11, 2) = (/ &
        & 0.12997e-07,0.22559e-06,0.25028e-06,0.20624e-06,0.15074e-06, &
        & 0.95763e-07,0.46972e-07,0.22656e-07,0.26128e-04 /)
      kao(:, 4,11, 2) = (/ &
        & 0.12774e-07,0.23494e-06,0.26130e-06,0.21398e-06,0.15730e-06, &
        & 0.98985e-07,0.48309e-07,0.24026e-07,0.26834e-04 /)
      kao(:, 5,11, 2) = (/ &
        & 0.13184e-07,0.24219e-06,0.26811e-06,0.22059e-06,0.16314e-06, &
        & 0.10271e-06,0.49802e-07,0.25441e-07,0.27644e-04 /)
      kao(:, 1,12, 2) = (/ &
        & 0.11394e-07,0.19172e-06,0.27076e-06,0.23579e-06,0.17648e-06, &
        & 0.11366e-06,0.56463e-07,0.20869e-07,0.27151e-04 /)
      kao(:, 2,12, 2) = (/ &
        & 0.12908e-07,0.20309e-06,0.28462e-06,0.24753e-06,0.18719e-06, &
        & 0.12033e-06,0.60157e-07,0.21646e-07,0.27962e-04 /)
      kao(:, 3,12, 2) = (/ &
        & 0.13752e-07,0.21619e-06,0.29476e-06,0.25594e-06,0.19641e-06, &
        & 0.12734e-06,0.64272e-07,0.22557e-07,0.28912e-04 /)
      kao(:, 4,12, 2) = (/ &
        & 0.14906e-07,0.22665e-06,0.30298e-06,0.26272e-06,0.20331e-06, &
        & 0.13316e-06,0.68243e-07,0.23417e-07,0.29816e-04 /)
      kao(:, 5,12, 2) = (/ &
        & 0.15969e-07,0.23477e-06,0.31068e-06,0.27029e-06,0.20850e-06, &
        & 0.13902e-06,0.71857e-07,0.25264e-07,0.30765e-04 /)
      kao(:, 1,13, 2) = (/ &
        & 0.13593e-07,0.19801e-06,0.26490e-06,0.27826e-06,0.22531e-06, &
        & 0.15112e-06,0.78691e-07,0.27273e-07,0.28055e-04 /)
      kao(:, 2,13, 2) = (/ &
        & 0.15426e-07,0.20839e-06,0.27732e-06,0.28785e-06,0.23371e-06, &
        & 0.16027e-06,0.86131e-07,0.29011e-07,0.29165e-04 /)
      kao(:, 3,13, 2) = (/ &
        & 0.16638e-07,0.21808e-06,0.28896e-06,0.29666e-06,0.24201e-06, &
        & 0.16845e-06,0.91791e-07,0.30670e-07,0.30372e-04 /)
      kao(:, 4,13, 2) = (/ &
        & 0.17929e-07,0.22577e-06,0.29798e-06,0.30533e-06,0.24895e-06, &
        & 0.17573e-06,0.96085e-07,0.31360e-07,0.31437e-04 /)
      kao(:, 5,13, 2) = (/ &
        & 0.18861e-07,0.23397e-06,0.30715e-06,0.31382e-06,0.25665e-06, &
        & 0.18246e-06,0.10017e-06,0.32454e-07,0.32266e-04 /)
      kao(:, 1, 1, 3) = (/ &
        & 0.39751e-08,0.10094e-06,0.20247e-06,0.30028e-06,0.39102e-06, &
        & 0.48711e-06,0.59106e-06,0.72709e-06,0.20885e-06 /)
      kao(:, 2, 1, 3) = (/ &
        & 0.43080e-08,0.10546e-06,0.20982e-06,0.31135e-06,0.40303e-06, &
        & 0.49632e-06,0.59855e-06,0.74477e-06,0.21012e-06 /)
      kao(:, 3, 1, 3) = (/ &
        & 0.42986e-08,0.15269e-06,0.29890e-06,0.43493e-06,0.56429e-06, &
        & 0.69336e-06,0.83181e-06,0.10423e-05,0.36557e-06 /)
      kao(:, 4, 1, 3) = (/ &
        & 0.43554e-08,0.11271e-06,0.22069e-06,0.32651e-06,0.42391e-06, &
        & 0.51393e-06,0.61294e-06,0.75229e-06,0.20945e-06 /)
      kao(:, 5, 1, 3) = (/ &
        & 0.45047e-08,0.11576e-06,0.22657e-06,0.33173e-06,0.43142e-06, &
        & 0.52151e-06,0.61871e-06,0.74980e-06,0.20891e-06 /)
      kao(:, 1, 2, 3) = (/ &
        & 0.46065e-08,0.81519e-07,0.15960e-06,0.23610e-06,0.31656e-06, &
        & 0.39839e-06,0.48591e-06,0.60182e-06,0.18230e-06 /)
      kao(:, 2, 2, 3) = (/ &
        & 0.46837e-08,0.82106e-07,0.16429e-06,0.24471e-06,0.32626e-06, &
        & 0.40531e-06,0.49330e-06,0.61810e-06,0.18355e-06 /)
      kao(:, 3, 2, 3) = (/ &
        & 0.50163e-08,0.12328e-06,0.23602e-06,0.35332e-06,0.46387e-06, &
        & 0.57515e-06,0.69445e-06,0.88167e-06,0.30546e-06 /)
      kao(:, 4, 2, 3) = (/ &
        & 0.49809e-08,0.12454e-06,0.23839e-06,0.35429e-06,0.46515e-06, &
        & 0.57491e-06,0.69031e-06,0.86630e-06,0.29807e-06 /)
      kao(:, 5, 2, 3) = (/ &
        & 0.51988e-08,0.91291e-07,0.17869e-06,0.26485e-06,0.34907e-06, &
        & 0.42509e-06,0.50894e-06,0.62361e-06,0.18234e-06 /)
      kao(:, 1, 3, 3) = (/ &
        & 0.51916e-08,0.88867e-07,0.12220e-06,0.18411e-06,0.24720e-06, &
        & 0.32303e-06,0.39526e-06,0.49595e-06,0.27125e-06 /)
      kao(:, 2, 3, 3) = (/ &
        & 0.56319e-08,0.87189e-07,0.12678e-06,0.19176e-06,0.25624e-06, &
        & 0.32740e-06,0.40564e-06,0.50601e-06,0.28010e-06 /)
      kao(:, 3, 3, 3) = (/ &
        & 0.59026e-08,0.86017e-07,0.13043e-06,0.19649e-06,0.26497e-06, &
        & 0.33305e-06,0.40679e-06,0.51963e-06,0.28660e-06 /)
      kao(:, 4, 3, 3) = (/ &
        & 0.59909e-08,0.10759e-06,0.18790e-06,0.28104e-06,0.37702e-06, &
        & 0.47222e-06,0.57322e-06,0.72906e-06,0.37657e-06 /)
      kao(:, 5, 3, 3) = (/ &
        & 0.64422e-08,0.89472e-07,0.13687e-06,0.20453e-06,0.27802e-06, &
        & 0.34266e-06,0.41565e-06,0.51746e-06,0.29675e-06 /)
      kao(:, 1, 4, 3) = (/ &
        & 0.62298e-08,0.99509e-07,0.10306e-06,0.14232e-06,0.19390e-06, &
        & 0.25435e-06,0.31764e-06,0.40578e-06,0.49031e-06 /)
      kao(:, 2, 4, 3) = (/ &
        & 0.68419e-08,0.10415e-06,0.10349e-06,0.14672e-06,0.19860e-06, &
        & 0.26012e-06,0.32720e-06,0.41327e-06,0.51522e-06 /)
      kao(:, 3, 4, 3) = (/ &
        & 0.71418e-08,0.10626e-06,0.10522e-06,0.15175e-06,0.20471e-06, &
        & 0.26435e-06,0.33148e-06,0.42294e-06,0.53456e-06 /)
      kao(:, 4, 4, 3) = (/ &
        & 0.72470e-08,0.10891e-06,0.10648e-06,0.15457e-06,0.21007e-06, &
        & 0.26937e-06,0.33376e-06,0.42939e-06,0.55207e-06 /)
      kao(:, 5, 4, 3) = (/ &
        & 0.77585e-08,0.12954e-06,0.14999e-06,0.22224e-06,0.29994e-06, &
        & 0.38053e-06,0.47027e-06,0.60032e-06,0.76592e-06 /)
      kao(:, 1, 5, 3) = (/ &
        & 0.68852e-08,0.11288e-06,0.11969e-06,0.11689e-06,0.14994e-06, &
        & 0.19637e-06,0.25309e-06,0.33018e-06,0.84551e-06 /)
      kao(:, 2, 5, 3) = (/ &
        & 0.75119e-08,0.11838e-06,0.12255e-06,0.11926e-06,0.15341e-06, &
        & 0.20169e-06,0.26231e-06,0.33745e-06,0.85714e-06 /)
      kao(:, 3, 5, 3) = (/ &
        & 0.84416e-08,0.12128e-06,0.12324e-06,0.12015e-06,0.15812e-06, &
        & 0.20463e-06,0.26808e-06,0.34461e-06,0.86734e-06 /)
      kao(:, 4, 5, 3) = (/ &
        & 0.92293e-08,0.12493e-06,0.12330e-06,0.12093e-06,0.16146e-06, &
        & 0.20899e-06,0.26904e-06,0.35101e-06,0.88204e-06 /)
      kao(:, 5, 5, 3) = (/ &
        & 0.10279e-07,0.14631e-06,0.14078e-06,0.17511e-06,0.23546e-06, &
        & 0.30442e-06,0.38374e-06,0.50000e-06,0.10431e-05 /)
      kao(:, 1, 6, 3) = (/ &
        & 0.51921e-08,0.14437e-06,0.12917e-06,0.11673e-06,0.12444e-06, &
        & 0.14966e-06,0.19338e-06,0.26674e-06,0.16987e-05 /)
      kao(:, 2, 6, 3) = (/ &
        & 0.69052e-08,0.14822e-06,0.13564e-06,0.12080e-06,0.12884e-06, &
        & 0.15616e-06,0.20083e-06,0.27373e-06,0.17147e-05 /)
      kao(:, 3, 6, 3) = (/ &
        & 0.93932e-08,0.15309e-06,0.13785e-06,0.12361e-06,0.12904e-06, &
        & 0.16004e-06,0.20790e-06,0.27928e-06,0.17384e-05 /)
      kao(:, 4, 6, 3) = (/ &
        & 0.10364e-07,0.15577e-06,0.14281e-06,0.12445e-06,0.13032e-06, &
        & 0.16178e-06,0.21225e-06,0.28499e-06,0.17733e-05 /)
      kao(:, 5, 6, 3) = (/ &
        & 0.10950e-07,0.15768e-06,0.14728e-06,0.12674e-06,0.12961e-06, &
        & 0.16455e-06,0.21080e-06,0.28744e-06,0.17869e-05 /)
      kao(:, 1, 7, 3) = (/ &
        & 0.51527e-08,0.13331e-06,0.15220e-06,0.13781e-06,0.11791e-06, &
        & 0.12291e-06,0.14839e-06,0.21430e-06,0.45802e-05 /)
      kao(:, 2, 7, 3) = (/ &
        & 0.52409e-08,0.14109e-06,0.15809e-06,0.14393e-06,0.12362e-06, &
        & 0.12831e-06,0.15572e-06,0.22059e-06,0.46088e-05 /)
      kao(:, 3, 7, 3) = (/ &
        & 0.66901e-08,0.14833e-06,0.16524e-06,0.14893e-06,0.12670e-06, &
        & 0.13152e-06,0.16110e-06,0.22404e-06,0.46200e-05 /)
      kao(:, 4, 7, 3) = (/ &
        & 0.90836e-08,0.15267e-06,0.17113e-06,0.15541e-06,0.12966e-06, &
        & 0.13240e-06,0.16410e-06,0.22868e-06,0.45999e-05 /)
      kao(:, 5, 7, 3) = (/ &
        & 0.11721e-07,0.15605e-06,0.17580e-06,0.16064e-06,0.13194e-06, &
        & 0.13127e-06,0.16676e-06,0.23245e-06,0.46103e-05 /)
      kao(:, 1, 8, 3) = (/ &
        & 0.53770e-08,0.12906e-06,0.19117e-06,0.16928e-06,0.14454e-06, &
        & 0.11318e-06,0.12091e-06,0.16771e-06,0.10838e-04 /)
      kao(:, 2, 8, 3) = (/ &
        & 0.71217e-08,0.13171e-06,0.20115e-06,0.17525e-06,0.15189e-06, &
        & 0.11980e-06,0.12589e-06,0.17247e-06,0.10844e-04 /)
      kao(:, 3, 8, 3) = (/ &
        & 0.76051e-08,0.13463e-06,0.20837e-06,0.18092e-06,0.15831e-06, &
        & 0.12491e-06,0.12782e-06,0.17568e-06,0.10855e-04 /)
      kao(:, 4, 8, 3) = (/ &
        & 0.87276e-08,0.14002e-06,0.21488e-06,0.18616e-06,0.16272e-06, &
        & 0.12991e-06,0.13139e-06,0.17775e-06,0.10873e-04 /)
      kao(:, 5, 8, 3) = (/ &
        & 0.98102e-08,0.14390e-06,0.21715e-06,0.19383e-06,0.16843e-06, &
        & 0.13102e-06,0.13320e-06,0.18001e-06,0.10883e-04 /)
      kao(:, 1, 9, 3) = (/ &
        & 0.78846e-08,0.14921e-06,0.16266e-06,0.21810e-06,0.17257e-06, &
        & 0.13914e-06,0.10621e-06,0.13009e-06,0.22193e-04 /)
      kao(:, 2, 9, 3) = (/ &
        & 0.87670e-08,0.15667e-06,0.17179e-06,0.22870e-06,0.18453e-06, &
        & 0.14806e-06,0.11198e-06,0.13228e-06,0.22470e-04 /)
      kao(:, 3, 9, 3) = (/ &
        & 0.94042e-08,0.16331e-06,0.17929e-06,0.23732e-06,0.19309e-06, &
        & 0.15669e-06,0.11769e-06,0.13462e-06,0.22759e-04 /)
      kao(:, 4, 9, 3) = (/ &
        & 0.10052e-07,0.16738e-06,0.18654e-06,0.24428e-06,0.19714e-06, &
        & 0.16469e-06,0.12194e-06,0.13694e-06,0.23037e-04 /)
      kao(:, 5, 9, 3) = (/ &
        & 0.99609e-08,0.16974e-06,0.19096e-06,0.25212e-06,0.20604e-06, &
        & 0.17005e-06,0.12529e-06,0.13965e-06,0.23331e-04 /)
      kao(:, 1,10, 3) = (/ &
        & 0.10600e-07,0.19194e-06,0.19694e-06,0.19228e-06,0.23306e-06, &
        & 0.18017e-06,0.13563e-06,0.11106e-06,0.57833e-04 /)
      kao(:, 2,10, 3) = (/ &
        & 0.11513e-07,0.19670e-06,0.20600e-06,0.20153e-06,0.24712e-06, &
        & 0.19420e-06,0.14374e-06,0.11223e-06,0.59252e-04 /)
      kao(:, 3,10, 3) = (/ &
        & 0.12267e-07,0.20052e-06,0.21125e-06,0.21502e-06,0.25879e-06, &
        & 0.20809e-06,0.15257e-06,0.11412e-06,0.60474e-04 /)
      kao(:, 4,10, 3) = (/ &
        & 0.11377e-07,0.20485e-06,0.21479e-06,0.22527e-06,0.26884e-06, &
        & 0.21723e-06,0.15872e-06,0.11733e-06,0.61380e-04 /)
      kao(:, 5,10, 3) = (/ &
        & 0.12141e-07,0.20611e-06,0.22439e-06,0.22986e-06,0.27411e-06, &
        & 0.22402e-06,0.16342e-06,0.11916e-06,0.62353e-04 /)
      kao(:, 1,11, 3) = (/ &
        & 0.12251e-07,0.29022e-06,0.24496e-06,0.24059e-06,0.21631e-06, &
        & 0.23923e-06,0.16597e-06,0.10842e-06,0.80074e-04 /)
      kao(:, 2,11, 3) = (/ &
        & 0.12224e-07,0.29680e-06,0.25368e-06,0.24691e-06,0.22294e-06, &
        & 0.24912e-06,0.17747e-06,0.10969e-06,0.81125e-04 /)
      kao(:, 3,11, 3) = (/ &
        & 0.14264e-07,0.29886e-06,0.26040e-06,0.25256e-06,0.23184e-06, &
        & 0.25957e-06,0.18845e-06,0.11123e-06,0.82960e-04 /)
      kao(:, 4,11, 3) = (/ &
        & 0.16608e-07,0.30056e-06,0.26198e-06,0.25724e-06,0.23897e-06, &
        & 0.26977e-06,0.19716e-06,0.11521e-06,0.84911e-04 /)
      kao(:, 5,11, 3) = (/ &
        & 0.18982e-07,0.30200e-06,0.26559e-06,0.26090e-06,0.24427e-06, &
        & 0.27763e-06,0.20825e-06,0.11858e-06,0.86586e-04 /)
      kao(:, 1,12, 3) = (/ &
        & 0.16186e-07,0.36864e-06,0.27735e-06,0.24475e-06,0.23659e-06, &
        & 0.20178e-06,0.20651e-06,0.11504e-06,0.90323e-04 /)
      kao(:, 2,12, 3) = (/ &
        & 0.16900e-07,0.36903e-06,0.27865e-06,0.25015e-06,0.24279e-06, &
        & 0.21379e-06,0.22149e-06,0.12739e-06,0.92788e-04 /)
      kao(:, 3,12, 3) = (/ &
        & 0.18900e-07,0.36546e-06,0.28369e-06,0.25919e-06,0.24650e-06, &
        & 0.22349e-06,0.23741e-06,0.13455e-06,0.94381e-04 /)
      kao(:, 4,12, 3) = (/ &
        & 0.24666e-07,0.36289e-06,0.28992e-06,0.26755e-06,0.25261e-06, &
        & 0.23012e-06,0.24862e-06,0.14012e-06,0.95689e-04 /)
      kao(:, 5,12, 3) = (/ &
        & 0.28047e-07,0.36144e-06,0.29439e-06,0.27280e-06,0.25910e-06, &
        & 0.23527e-06,0.25804e-06,0.14441e-06,0.97273e-04 /)
      kao(:, 1,13, 3) = (/ &
        & 0.27099e-07,0.42452e-06,0.36469e-06,0.28012e-06,0.24206e-06, &
        & 0.21452e-06,0.19737e-06,0.12552e-06,0.93221e-04 /)
      kao(:, 2,13, 3) = (/ &
        & 0.30641e-07,0.42348e-06,0.36821e-06,0.29049e-06,0.25191e-06, &
        & 0.22447e-06,0.20459e-06,0.13174e-06,0.95326e-04 /)
      kao(:, 3,13, 3) = (/ &
        & 0.31538e-07,0.42218e-06,0.36978e-06,0.29801e-06,0.26042e-06, &
        & 0.23413e-06,0.21354e-06,0.13999e-06,0.97244e-04 /)
      kao(:, 4,13, 3) = (/ &
        & 0.33087e-07,0.42233e-06,0.36980e-06,0.30223e-06,0.26697e-06, &
        & 0.24077e-06,0.22289e-06,0.14849e-06,0.99282e-04 /)
      kao(:, 5,13, 3) = (/ &
        & 0.35771e-07,0.42124e-06,0.36949e-06,0.30814e-06,0.27423e-06, &
        & 0.24510e-06,0.22998e-06,0.15431e-06,0.10189e-03 /)
      kao(:, 1, 1, 4) = (/ &
        & 0.60599e-08,0.49839e-06,0.90796e-06,0.12825e-05,0.16387e-05, &
        & 0.20000e-05,0.24097e-05,0.30198e-05,0.14012e-05 /)
      kao(:, 2, 1, 4) = (/ &
        & 0.57361e-08,0.51373e-06,0.93344e-06,0.13150e-05,0.16776e-05, &
        & 0.20412e-05,0.24476e-05,0.30155e-05,0.14079e-05 /)
      kao(:, 3, 1, 4) = (/ &
        & 0.61895e-08,0.64074e-06,0.11706e-05,0.16523e-05,0.21138e-05, &
        & 0.25765e-05,0.30714e-05,0.37148e-05,0.20046e-05 /)
      kao(:, 4, 1, 4) = (/ &
        & 0.63590e-08,0.53918e-06,0.97233e-06,0.13614e-05,0.17274e-05, &
        & 0.21018e-05,0.24992e-05,0.30391e-05,0.14106e-05 /)
      kao(:, 5, 1, 4) = (/ &
        & 0.66907e-08,0.54769e-06,0.98459e-06,0.13756e-05,0.17428e-05, &
        & 0.21216e-05,0.25190e-05,0.30528e-05,0.14057e-05 /)
      kao(:, 1, 2, 4) = (/ &
        & 0.63247e-08,0.40976e-06,0.75743e-06,0.10729e-05,0.13776e-05, &
        & 0.16847e-05,0.20386e-05,0.25923e-05,0.11016e-05 /)
      kao(:, 2, 2, 4) = (/ &
        & 0.71971e-08,0.42277e-06,0.77866e-06,0.11006e-05,0.14075e-05, &
        & 0.17208e-05,0.20689e-05,0.25842e-05,0.11093e-05 /)
      kao(:, 3, 2, 4) = (/ &
        & 0.68862e-08,0.54111e-06,0.99924e-06,0.14135e-05,0.18137e-05, &
        & 0.22190e-05,0.26613e-05,0.32636e-05,0.16377e-05 /)
      kao(:, 4, 2, 4) = (/ &
        & 0.74570e-08,0.54374e-06,0.10016e-05,0.14142e-05,0.18118e-05, &
        & 0.22093e-05,0.26451e-05,0.32306e-05,0.16062e-05 /)
      kao(:, 5, 2, 4) = (/ &
        & 0.76975e-08,0.44890e-06,0.82016e-06,0.11488e-05,0.14591e-05, &
        & 0.17814e-05,0.21241e-05,0.26089e-05,0.11145e-05 /)
      kao(:, 1, 3, 4) = (/ &
        & 0.83656e-08,0.31311e-06,0.61949e-06,0.88176e-06,0.11379e-05, &
        & 0.13977e-05,0.17043e-05,0.22078e-05,0.73836e-06 /)
      kao(:, 2, 3, 4) = (/ &
        & 0.85171e-08,0.32573e-06,0.63573e-06,0.90517e-06,0.11641e-05, &
        & 0.14286e-05,0.17247e-05,0.21938e-05,0.74285e-06 /)
      kao(:, 3, 3, 4) = (/ &
        & 0.78702e-08,0.33673e-06,0.64948e-06,0.92347e-06,0.11844e-05, &
        & 0.14525e-05,0.17473e-05,0.21823e-05,0.74417e-06 /)
      kao(:, 4, 3, 4) = (/ &
        & 0.88135e-08,0.44484e-06,0.84006e-06,0.11924e-05,0.15326e-05, &
        & 0.18766e-05,0.22592e-05,0.27980e-05,0.11629e-05 /)
      kao(:, 5, 3, 4) = (/ &
        & 0.83594e-08,0.34852e-06,0.67171e-06,0.94786e-06,0.12080e-05, &
        & 0.14818e-05,0.17721e-05,0.22017e-05,0.74162e-06 /)
      kao(:, 1, 4, 4) = (/ &
        & 0.82233e-08,0.22714e-06,0.49574e-06,0.71618e-06,0.92897e-06, &
        & 0.11522e-05,0.14150e-05,0.18749e-05,0.10829e-05 /)
      kao(:, 2, 4, 4) = (/ &
        & 0.90906e-08,0.23281e-06,0.51082e-06,0.73615e-06,0.95322e-06, &
        & 0.11749e-05,0.14287e-05,0.18456e-05,0.10964e-05 /)
      kao(:, 3, 4, 4) = (/ &
        & 0.10403e-07,0.23873e-06,0.52083e-06,0.75142e-06,0.97057e-06, &
        & 0.11959e-05,0.14456e-05,0.18299e-05,0.11024e-05 /)
      kao(:, 4, 4, 4) = (/ &
        & 0.11681e-07,0.24287e-06,0.52982e-06,0.76518e-06,0.98418e-06, &
        & 0.12105e-05,0.14593e-05,0.18314e-05,0.11002e-05 /)
      kao(:, 5, 4, 4) = (/ &
        & 0.11781e-07,0.32919e-06,0.69041e-06,0.99008e-06,0.12781e-05, &
        & 0.15684e-05,0.18900e-05,0.23626e-05,0.11507e-05 /)
      kao(:, 1, 5, 4) = (/ &
        & 0.10746e-07,0.16960e-06,0.36271e-06,0.57393e-06,0.75088e-06, &
        & 0.94078e-06,0.11700e-05,0.15610e-05,0.23060e-05 /)
      kao(:, 2, 5, 4) = (/ &
        & 0.12322e-07,0.17145e-06,0.37466e-06,0.58975e-06,0.77156e-06, &
        & 0.96051e-06,0.11773e-05,0.15431e-05,0.23550e-05 /)
      kao(:, 3, 5, 4) = (/ &
        & 0.12362e-07,0.17491e-06,0.38517e-06,0.60273e-06,0.78779e-06, &
        & 0.97831e-06,0.11895e-05,0.15264e-05,0.23946e-05 /)
      kao(:, 4, 5, 4) = (/ &
        & 0.11932e-07,0.17603e-06,0.39310e-06,0.61276e-06,0.80198e-06, &
        & 0.99168e-06,0.12014e-05,0.15209e-05,0.24122e-05 /)
      kao(:, 5, 5, 4) = (/ &
        & 0.12827e-07,0.23797e-06,0.54915e-06,0.81314e-06,0.10605e-05, &
        & 0.13079e-05,0.15848e-05,0.19982e-05,0.26265e-05 /)
      kao(:, 1, 6, 4) = (/ &
        & 0.16887e-07,0.16918e-06,0.26182e-06,0.43955e-06,0.59876e-06, &
        & 0.76220e-06,0.96205e-06,0.12977e-05,0.30196e-05 /)
      kao(:, 2, 6, 4) = (/ &
        & 0.16463e-07,0.17256e-06,0.26723e-06,0.45266e-06,0.61330e-06, &
        & 0.77949e-06,0.96881e-06,0.12938e-05,0.31027e-05 /)
      kao(:, 3, 6, 4) = (/ &
        & 0.14297e-07,0.17174e-06,0.27626e-06,0.46141e-06,0.62873e-06, &
        & 0.79335e-06,0.97523e-06,0.12716e-05,0.31487e-05 /)
      kao(:, 4, 6, 4) = (/ &
        & 0.15984e-07,0.17093e-06,0.27951e-06,0.46972e-06,0.64062e-06, &
        & 0.80616e-06,0.98183e-06,0.12602e-05,0.31591e-05 /)
      kao(:, 5, 6, 4) = (/ &
        & 0.17832e-07,0.17197e-06,0.28124e-06,0.47610e-06,0.64900e-06, &
        & 0.81537e-06,0.99403e-06,0.12613e-05,0.32001e-05 /)
      kao(:, 1, 7, 4) = (/ &
        & 0.19543e-07,0.20424e-06,0.20827e-06,0.30613e-06,0.46038e-06, &
        & 0.61052e-06,0.78796e-06,0.10769e-05,0.53495e-05 /)
      kao(:, 2, 7, 4) = (/ &
        & 0.21943e-07,0.20486e-06,0.21292e-06,0.31650e-06,0.47369e-06, &
        & 0.62546e-06,0.78997e-06,0.10696e-05,0.53612e-05 /)
      kao(:, 3, 7, 4) = (/ &
        & 0.23096e-07,0.20519e-06,0.21260e-06,0.32419e-06,0.48522e-06, &
        & 0.63494e-06,0.79556e-06,0.10562e-05,0.54125e-05 /)
      kao(:, 4, 7, 4) = (/ &
        & 0.23811e-07,0.20761e-06,0.21334e-06,0.32752e-06,0.49467e-06, &
        & 0.64456e-06,0.80411e-06,0.10435e-05,0.54920e-05 /)
      kao(:, 5, 7, 4) = (/ &
        & 0.23502e-07,0.20918e-06,0.21430e-06,0.32878e-06,0.50037e-06, &
        & 0.65413e-06,0.80879e-06,0.10409e-05,0.55076e-05 /)
      kao(:, 1, 8, 4) = (/ &
        & 0.28818e-07,0.26386e-06,0.23322e-06,0.23394e-06,0.31766e-06, &
        & 0.47372e-06,0.64268e-06,0.89272e-06,0.10691e-04 /)
      kao(:, 2, 8, 4) = (/ &
        & 0.30094e-07,0.27235e-06,0.23524e-06,0.24245e-06,0.32636e-06, &
        & 0.48411e-06,0.63773e-06,0.88040e-06,0.10770e-04 /)
      kao(:, 3, 8, 4) = (/ &
        & 0.32474e-07,0.27799e-06,0.23717e-06,0.24789e-06,0.33554e-06, &
        & 0.49304e-06,0.64255e-06,0.87788e-06,0.10799e-04 /)
      kao(:, 4, 8, 4) = (/ &
        & 0.33631e-07,0.28020e-06,0.23819e-06,0.25000e-06,0.34187e-06, &
        & 0.49874e-06,0.64803e-06,0.86373e-06,0.10824e-04 /)
      kao(:, 5, 8, 4) = (/ &
        & 0.34597e-07,0.28107e-06,0.24266e-06,0.24933e-06,0.34607e-06, &
        & 0.50692e-06,0.65081e-06,0.85686e-06,0.10819e-04 /)
      kao(:, 1, 9, 4) = (/ &
        & 0.37049e-07,0.33070e-06,0.32147e-06,0.25828e-06,0.24460e-06, &
        & 0.33057e-06,0.51182e-06,0.72970e-06,0.32667e-04 /)
      kao(:, 2, 9, 4) = (/ &
        & 0.39634e-07,0.34282e-06,0.32875e-06,0.26785e-06,0.25757e-06, &
        & 0.33579e-06,0.50462e-06,0.72240e-06,0.32638e-04 /)
      kao(:, 3, 9, 4) = (/ &
        & 0.42012e-07,0.34998e-06,0.33495e-06,0.27514e-06,0.26581e-06, &
        & 0.33988e-06,0.50360e-06,0.72105e-06,0.32828e-04 /)
      kao(:, 4, 9, 4) = (/ &
        & 0.43216e-07,0.35061e-06,0.33953e-06,0.28140e-06,0.27172e-06, &
        & 0.34266e-06,0.50914e-06,0.70829e-06,0.32970e-04 /)
      kao(:, 5, 9, 4) = (/ &
        & 0.43838e-07,0.35447e-06,0.34674e-06,0.28252e-06,0.27122e-06, &
        & 0.34740e-06,0.51058e-06,0.70194e-06,0.33023e-04 /)
      kao(:, 1,10, 4) = (/ &
        & 0.46492e-07,0.34673e-06,0.43959e-06,0.39620e-06,0.30969e-06, &
        & 0.25359e-06,0.35579e-06,0.58999e-06,0.75308e-04 /)
      kao(:, 2,10, 4) = (/ &
        & 0.51642e-07,0.35814e-06,0.45251e-06,0.40694e-06,0.31643e-06, &
        & 0.25658e-06,0.34700e-06,0.58340e-06,0.75445e-04 /)
      kao(:, 3,10, 4) = (/ &
        & 0.55139e-07,0.36959e-06,0.46273e-06,0.41592e-06,0.32168e-06, &
        & 0.26320e-06,0.34598e-06,0.57972e-06,0.75796e-04 /)
      kao(:, 4,10, 4) = (/ &
        & 0.58094e-07,0.37731e-06,0.47160e-06,0.41969e-06,0.32536e-06, &
        & 0.27186e-06,0.34692e-06,0.57173e-06,0.76680e-04 /)
      kao(:, 5,10, 4) = (/ &
        & 0.62665e-07,0.38529e-06,0.47122e-06,0.42322e-06,0.32990e-06, &
        & 0.28125e-06,0.34920e-06,0.56204e-06,0.77515e-04 /)
      kao(:, 1,11, 4) = (/ &
        & 0.71997e-07,0.39039e-06,0.48930e-06,0.52037e-06,0.44835e-06, &
        & 0.32920e-06,0.25424e-06,0.45719e-06,0.97599e-04 /)
      kao(:, 2,11, 4) = (/ &
        & 0.84174e-07,0.39220e-06,0.49753e-06,0.53466e-06,0.46035e-06, &
        & 0.34028e-06,0.25580e-06,0.44804e-06,0.98017e-04 /)
      kao(:, 3,11, 4) = (/ &
        & 0.88241e-07,0.39809e-06,0.50514e-06,0.54464e-06,0.47069e-06, &
        & 0.34919e-06,0.25830e-06,0.44783e-06,0.97609e-04 /)
      kao(:, 4,11, 4) = (/ &
        & 0.93462e-07,0.40271e-06,0.51216e-06,0.55531e-06,0.48178e-06, &
        & 0.35530e-06,0.26505e-06,0.43524e-06,0.97099e-04 /)
      kao(:, 5,11, 4) = (/ &
        & 0.96966e-07,0.40660e-06,0.51682e-06,0.56367e-06,0.48662e-06, &
        & 0.35706e-06,0.26903e-06,0.42986e-06,0.97653e-04 /)
      kao(:, 1,12, 4) = (/ &
        & 0.99102e-07,0.42179e-06,0.46920e-06,0.54974e-06,0.50699e-06, &
        & 0.41543e-06,0.26692e-06,0.34287e-06,0.10692e-03 /)
      kao(:, 2,12, 4) = (/ &
        & 0.10220e-06,0.42343e-06,0.48263e-06,0.56179e-06,0.52088e-06, &
        & 0.42826e-06,0.27416e-06,0.32165e-06,0.10849e-03 /)
      kao(:, 3,12, 4) = (/ &
        & 0.10736e-06,0.42994e-06,0.49237e-06,0.56848e-06,0.53837e-06, &
        & 0.43862e-06,0.28070e-06,0.31402e-06,0.10890e-03 /)
      kao(:, 4,12, 4) = (/ &
        & 0.10535e-06,0.42853e-06,0.49830e-06,0.57259e-06,0.55337e-06, &
        & 0.45117e-06,0.28964e-06,0.30229e-06,0.11005e-03 /)
      kao(:, 5,12, 4) = (/ &
        & 0.10635e-06,0.42826e-06,0.50038e-06,0.57688e-06,0.56182e-06, &
        & 0.45862e-06,0.29473e-06,0.29904e-06,0.11056e-03 /)
      kao(:, 1,13, 4) = (/ &
        & 0.11521e-06,0.43118e-06,0.49222e-06,0.52624e-06,0.55771e-06, &
        & 0.47186e-06,0.32691e-06,0.24833e-06,0.10886e-03 /)
      kao(:, 2,13, 4) = (/ &
        & 0.11730e-06,0.43904e-06,0.49350e-06,0.54164e-06,0.56845e-06, &
        & 0.49098e-06,0.34261e-06,0.23938e-06,0.11077e-03 /)
      kao(:, 3,13, 4) = (/ &
        & 0.11952e-06,0.44327e-06,0.50284e-06,0.55816e-06,0.58198e-06, &
        & 0.50372e-06,0.35861e-06,0.22850e-06,0.11296e-03 /)
      kao(:, 4,13, 4) = (/ &
        & 0.11965e-06,0.44664e-06,0.51058e-06,0.56661e-06,0.59093e-06, &
        & 0.51146e-06,0.36596e-06,0.22349e-06,0.11560e-03 /)
      kao(:, 5,13, 4) = (/ &
        & 0.12171e-06,0.45566e-06,0.52364e-06,0.57439e-06,0.59010e-06, &
        & 0.52011e-06,0.37200e-06,0.22417e-06,0.11598e-03 /)
      kao(:, 1, 1, 5) = (/ &
        & 0.64393e-08,0.14477e-05,0.26383e-05,0.37578e-05,0.48497e-05, &
        & 0.58771e-05,0.69748e-05,0.83337e-05,0.52972e-05 /)
      kao(:, 2, 1, 5) = (/ &
        & 0.74788e-08,0.14813e-05,0.26820e-05,0.38123e-05,0.49043e-05, &
        & 0.59719e-05,0.70794e-05,0.84777e-05,0.53686e-05 /)
      kao(:, 3, 1, 5) = (/ &
        & 0.70698e-08,0.17381e-05,0.31521e-05,0.44815e-05,0.57370e-05, &
        & 0.69696e-05,0.82426e-05,0.98195e-05,0.67445e-05 /)
      kao(:, 4, 1, 5) = (/ &
        & 0.75728e-08,0.15363e-05,0.27544e-05,0.38956e-05,0.49855e-05, &
        & 0.60556e-05,0.72284e-05,0.86770e-05,0.54442e-05 /)
      kao(:, 5, 1, 5) = (/ &
        & 0.72646e-08,0.15573e-05,0.27840e-05,0.39266e-05,0.50091e-05, &
        & 0.60781e-05,0.72327e-05,0.87344e-05,0.54537e-05 /)
      kao(:, 1, 2, 5) = (/ &
        & 0.91682e-08,0.12471e-05,0.22727e-05,0.32462e-05,0.42007e-05, &
        & 0.51012e-05,0.60761e-05,0.73379e-05,0.44448e-05 /)
      kao(:, 2, 2, 5) = (/ &
        & 0.78841e-08,0.12745e-05,0.23098e-05,0.32938e-05,0.42384e-05, &
        & 0.51817e-05,0.61658e-05,0.74615e-05,0.44925e-05 /)
      kao(:, 3, 2, 5) = (/ &
        & 0.88457e-08,0.15305e-05,0.27824e-05,0.39573e-05,0.50820e-05, &
        & 0.61863e-05,0.73547e-05,0.88186e-05,0.58192e-05 /)
      kao(:, 4, 2, 5) = (/ &
        & 0.81699e-08,0.15379e-05,0.27884e-05,0.39554e-05,0.50640e-05, &
        & 0.61598e-05,0.73260e-05,0.88047e-05,0.57596e-05 /)
      kao(:, 5, 2, 5) = (/ &
        & 0.81267e-08,0.13345e-05,0.23941e-05,0.33760e-05,0.43121e-05, &
        & 0.52406e-05,0.62663e-05,0.76657e-05,0.45393e-05 /)
      kao(:, 1, 3, 5) = (/ &
        & 0.91717e-08,0.10541e-05,0.19313e-05,0.27682e-05,0.35915e-05, &
        & 0.43666e-05,0.52222e-05,0.63759e-05,0.36110e-05 /)
      kao(:, 2, 3, 5) = (/ &
        & 0.10331e-07,0.10789e-05,0.19645e-05,0.28075e-05,0.36240e-05, &
        & 0.44392e-05,0.52990e-05,0.64883e-05,0.36530e-05 /)
      kao(:, 3, 3, 5) = (/ &
        & 0.12324e-07,0.10988e-05,0.19944e-05,0.28363e-05,0.36532e-05, &
        & 0.44650e-05,0.53622e-05,0.65761e-05,0.36791e-05 /)
      kao(:, 4, 3, 5) = (/ &
        & 0.11596e-07,0.13389e-05,0.24365e-05,0.34597e-05,0.44354e-05, &
        & 0.54167e-05,0.64681e-05,0.78697e-05,0.48568e-05 /)
      kao(:, 5, 3, 5) = (/ &
        & 0.11476e-07,0.11282e-05,0.20370e-05,0.28768e-05,0.36785e-05, &
        & 0.44764e-05,0.53828e-05,0.66660e-05,0.36841e-05 /)
      kao(:, 1, 4, 5) = (/ &
        & 0.12942e-07,0.87057e-06,0.16185e-05,0.23328e-05,0.30327e-05, &
        & 0.36939e-05,0.44351e-05,0.54720e-05,0.21271e-05 /)
      kao(:, 2, 4, 5) = (/ &
        & 0.12911e-07,0.89351e-06,0.16491e-05,0.23657e-05,0.30660e-05, &
        & 0.37589e-05,0.45049e-05,0.55808e-05,0.21315e-05 /)
      kao(:, 3, 4, 5) = (/ &
        & 0.11919e-07,0.91285e-06,0.16762e-05,0.23907e-05,0.30911e-05, &
        & 0.37889e-05,0.45584e-05,0.56554e-05,0.21302e-05 /)
      kao(:, 4, 4, 5) = (/ &
        & 0.12644e-07,0.92680e-06,0.16966e-05,0.24115e-05,0.31023e-05, &
        & 0.37973e-05,0.46002e-05,0.57029e-05,0.21090e-05 /)
      kao(:, 5, 4, 5) = (/ &
        & 0.14252e-07,0.11501e-05,0.21042e-05,0.29827e-05,0.38200e-05, &
        & 0.46680e-05,0.55977e-05,0.69211e-05,0.32123e-05 /)
      kao(:, 1, 5, 5) = (/ &
        & 0.14457e-07,0.68848e-06,0.13403e-05,0.19448e-05,0.25364e-05, &
        & 0.30956e-05,0.37236e-05,0.46561e-05,0.23476e-05 /)
      kao(:, 2, 5, 5) = (/ &
        & 0.13664e-07,0.70724e-06,0.13666e-05,0.19744e-05,0.25701e-05, &
        & 0.31515e-05,0.37903e-05,0.47386e-05,0.23292e-05 /)
      kao(:, 3, 5, 5) = (/ &
        & 0.16363e-07,0.72382e-06,0.13894e-05,0.19966e-05,0.25908e-05, &
        & 0.31942e-05,0.38380e-05,0.48063e-05,0.23210e-05 /)
      kao(:, 4, 5, 5) = (/ &
        & 0.18854e-07,0.73645e-06,0.14075e-05,0.20143e-05,0.25995e-05, &
        & 0.31924e-05,0.38751e-05,0.48509e-05,0.23084e-05 /)
      kao(:, 5, 5, 5) = (/ &
        & 0.19502e-07,0.95711e-06,0.17948e-05,0.25536e-05,0.32756e-05, &
        & 0.40127e-05,0.48356e-05,0.60502e-05,0.26522e-05 /)
      kao(:, 1, 6, 5) = (/ &
        & 0.20265e-07,0.45716e-06,0.10840e-05,0.16034e-05,0.20999e-05, &
        & 0.25681e-05,0.30977e-05,0.39107e-05,0.52450e-05 /)
      kao(:, 2, 6, 5) = (/ &
        & 0.21598e-07,0.47132e-06,0.11079e-05,0.16263e-05,0.21396e-05, &
        & 0.26164e-05,0.31577e-05,0.39701e-05,0.52182e-05 /)
      kao(:, 3, 6, 5) = (/ &
        & 0.24575e-07,0.48601e-06,0.11257e-05,0.16486e-05,0.21513e-05, &
        & 0.26585e-05,0.32022e-05,0.40354e-05,0.51968e-05 /)
      kao(:, 4, 6, 5) = (/ &
        & 0.24397e-07,0.49804e-06,0.11416e-05,0.16645e-05,0.21605e-05, &
        & 0.26639e-05,0.32353e-05,0.40822e-05,0.51575e-05 /)
      kao(:, 5, 6, 5) = (/ &
        & 0.24456e-07,0.50499e-06,0.11522e-05,0.16738e-05,0.21632e-05, &
        & 0.26629e-05,0.32463e-05,0.41051e-05,0.51085e-05 /)
      kao(:, 1, 7, 5) = (/ &
        & 0.28039e-07,0.29800e-06,0.81783e-06,0.13008e-05,0.17226e-05, &
        & 0.21163e-05,0.25578e-05,0.32519e-05,0.82307e-05 /)
      kao(:, 2, 7, 5) = (/ &
        & 0.29388e-07,0.30492e-06,0.83771e-06,0.13192e-05,0.17591e-05, &
        & 0.21563e-05,0.26128e-05,0.33130e-05,0.81908e-05 /)
      kao(:, 3, 7, 5) = (/ &
        & 0.29556e-07,0.30866e-06,0.85444e-06,0.13376e-05,0.17722e-05, &
        & 0.21943e-05,0.26541e-05,0.33584e-05,0.81819e-05 /)
      kao(:, 4, 7, 5) = (/ &
        & 0.26709e-07,0.30951e-06,0.86739e-06,0.13505e-05,0.17805e-05, &
        & 0.22093e-05,0.26812e-05,0.34009e-05,0.81017e-05 /)
      kao(:, 5, 7, 5) = (/ &
        & 0.27877e-07,0.31158e-06,0.87645e-06,0.13597e-05,0.17817e-05, &
        & 0.22083e-05,0.26996e-05,0.34240e-05,0.80774e-05 /)
      kao(:, 1, 8, 5) = (/ &
        & 0.34498e-07,0.30504e-06,0.50025e-06,0.99104e-06,0.13907e-05, &
        & 0.17284e-05,0.20950e-05,0.26875e-05,0.12492e-04 /)
      kao(:, 2, 8, 5) = (/ &
        & 0.34468e-07,0.31253e-06,0.51376e-06,0.10029e-05,0.14233e-05, &
        & 0.17665e-05,0.21486e-05,0.27439e-05,0.12811e-04 /)
      kao(:, 3, 8, 5) = (/ &
        & 0.33481e-07,0.31885e-06,0.52532e-06,0.10176e-05,0.14361e-05, &
        & 0.18000e-05,0.21864e-05,0.27713e-05,0.12979e-04 /)
      kao(:, 4, 8, 5) = (/ &
        & 0.35023e-07,0.32212e-06,0.53171e-06,0.10292e-05,0.14414e-05, &
        & 0.18222e-05,0.22113e-05,0.28111e-05,0.13061e-04 /)
      kao(:, 5, 8, 5) = (/ &
        & 0.38480e-07,0.32386e-06,0.53818e-06,0.10355e-05,0.14400e-05, &
        & 0.18162e-05,0.22298e-05,0.28367e-05,0.13100e-04 /)
      kao(:, 1, 9, 5) = (/ &
        & 0.41152e-07,0.31870e-06,0.36402e-06,0.61613e-06,0.10619e-05, &
        & 0.13940e-05,0.17098e-05,0.22173e-05,0.27198e-04 /)
      kao(:, 2, 9, 5) = (/ &
        & 0.47020e-07,0.31765e-06,0.37312e-06,0.61961e-06,0.10763e-05, &
        & 0.14273e-05,0.17555e-05,0.22573e-05,0.28218e-04 /)
      kao(:, 3, 9, 5) = (/ &
        & 0.48171e-07,0.31526e-06,0.38468e-06,0.62540e-06,0.10803e-05, &
        & 0.14543e-05,0.17919e-05,0.22822e-05,0.28600e-04 /)
      kao(:, 4, 9, 5) = (/ &
        & 0.52826e-07,0.32481e-06,0.38733e-06,0.62721e-06,0.10854e-05, &
        & 0.14750e-05,0.18124e-05,0.23140e-05,0.29051e-04 /)
      kao(:, 5, 9, 5) = (/ &
        & 0.56456e-07,0.32727e-06,0.38424e-06,0.63178e-06,0.10853e-05, &
        & 0.14692e-05,0.18309e-05,0.23369e-05,0.29958e-04 /)
      kao(:, 1,10, 5) = (/ &
        & 0.62033e-07,0.45418e-06,0.43247e-06,0.44775e-06,0.62834e-06, &
        & 0.10534e-05,0.13865e-05,0.18301e-05,0.47779e-04 /)
      kao(:, 2,10, 5) = (/ &
        & 0.66259e-07,0.45321e-06,0.43983e-06,0.45223e-06,0.63440e-06, &
        & 0.10746e-05,0.14253e-05,0.18534e-05,0.48468e-04 /)
      kao(:, 3,10, 5) = (/ &
        & 0.78966e-07,0.45246e-06,0.44780e-06,0.45868e-06,0.63026e-06, &
        & 0.10842e-05,0.14519e-05,0.18794e-05,0.49251e-04 /)
      kao(:, 4,10, 5) = (/ &
        & 0.87881e-07,0.44642e-06,0.45426e-06,0.46583e-06,0.63116e-06, &
        & 0.10925e-05,0.14710e-05,0.18965e-05,0.49742e-04 /)
      kao(:, 5,10, 5) = (/ &
        & 0.92572e-07,0.44310e-06,0.45326e-06,0.47005e-06,0.63094e-06, &
        & 0.10763e-05,0.14843e-05,0.19214e-05,0.50457e-04 /)
      kao(:, 1,11, 5) = (/ &
        & 0.10522e-06,0.58600e-06,0.57473e-06,0.52150e-06,0.51202e-06, &
        & 0.62383e-06,0.10987e-05,0.15032e-05,0.50557e-04 /)
      kao(:, 2,11, 5) = (/ &
        & 0.98332e-07,0.58669e-06,0.57910e-06,0.52997e-06,0.52591e-06, &
        & 0.62992e-06,0.11144e-05,0.15271e-05,0.52915e-04 /)
      kao(:, 3,11, 5) = (/ &
        & 0.10383e-06,0.58976e-06,0.58650e-06,0.53573e-06,0.53394e-06, &
        & 0.63743e-06,0.11251e-05,0.15415e-05,0.55206e-04 /)
      kao(:, 4,11, 5) = (/ &
        & 0.10626e-06,0.58622e-06,0.58747e-06,0.53868e-06,0.53891e-06, &
        & 0.62645e-06,0.11296e-05,0.15628e-05,0.58020e-04 /)
      kao(:, 5,11, 5) = (/ &
        & 0.10795e-06,0.57800e-06,0.58664e-06,0.53883e-06,0.54784e-06, &
        & 0.62145e-06,0.11279e-05,0.15782e-05,0.60369e-04 /)
      kao(:, 1,12, 5) = (/ &
        & 0.11905e-06,0.60759e-06,0.68611e-06,0.59318e-06,0.53805e-06, &
        & 0.44962e-06,0.74828e-06,0.12279e-05,0.57098e-04 /)
      kao(:, 2,12, 5) = (/ &
        & 0.12660e-06,0.61695e-06,0.68094e-06,0.60079e-06,0.55064e-06, &
        & 0.44953e-06,0.74858e-06,0.12489e-05,0.55969e-04 /)
      kao(:, 3,12, 5) = (/ &
        & 0.12824e-06,0.61561e-06,0.67586e-06,0.61662e-06,0.55533e-06, &
        & 0.46796e-06,0.74406e-06,0.12615e-05,0.57249e-04 /)
      kao(:, 4,12, 5) = (/ &
        & 0.12834e-06,0.62554e-06,0.67923e-06,0.62343e-06,0.55964e-06, &
        & 0.48091e-06,0.73622e-06,0.12795e-05,0.58462e-04 /)
      kao(:, 5,12, 5) = (/ &
        & 0.13022e-06,0.63206e-06,0.68726e-06,0.62663e-06,0.56231e-06, &
        & 0.48008e-06,0.72942e-06,0.12885e-05,0.57642e-04 /)
      kao(:, 1,13, 5) = (/ &
        & 0.15325e-06,0.60909e-06,0.76952e-06,0.71232e-06,0.57983e-06, &
        & 0.50489e-06,0.48627e-06,0.99183e-06,0.58778e-04 /)
      kao(:, 2,13, 5) = (/ &
        & 0.15519e-06,0.62152e-06,0.78639e-06,0.71888e-06,0.59866e-06, &
        & 0.50930e-06,0.48247e-06,0.10069e-05,0.57959e-04 /)
      kao(:, 3,13, 5) = (/ &
        & 0.17242e-06,0.64099e-06,0.78686e-06,0.71502e-06,0.60678e-06, &
        & 0.51633e-06,0.47220e-06,0.10180e-05,0.56844e-04 /)
      kao(:, 4,13, 5) = (/ &
        & 0.18585e-06,0.65002e-06,0.78368e-06,0.71421e-06,0.61538e-06, &
        & 0.52650e-06,0.46857e-06,0.10263e-05,0.55757e-04 /)
      kao(:, 5,13, 5) = (/ &
        & 0.19235e-06,0.64166e-06,0.76203e-06,0.70622e-06,0.61837e-06, &
        & 0.53042e-06,0.45529e-06,0.10275e-05,0.55475e-04 /)
      kao(:, 1, 1, 6) = (/ &
        & 0.95617e-08,0.36774e-05,0.65849e-05,0.92221e-05,0.11700e-04, &
        & 0.14161e-04,0.16732e-04,0.20350e-04,0.14554e-04 /)
      kao(:, 2, 1, 6) = (/ &
        & 0.93327e-08,0.37537e-05,0.66916e-05,0.93495e-05,0.11842e-04, &
        & 0.14289e-04,0.16848e-04,0.20318e-04,0.14747e-04 /)
      kao(:, 3, 1, 6) = (/ &
        & 0.98298e-08,0.41944e-05,0.75022e-05,0.10503e-04,0.13381e-04, &
        & 0.16104e-04,0.19004e-04,0.22601e-04,0.17337e-04 /)
      kao(:, 4, 1, 6) = (/ &
        & 0.92318e-08,0.38872e-05,0.68816e-05,0.95784e-05,0.12112e-04, &
        & 0.14510e-04,0.17052e-04,0.20522e-04,0.14967e-04 /)
      kao(:, 5, 1, 6) = (/ &
        & 0.98053e-08,0.39438e-05,0.69574e-05,0.96665e-05,0.12218e-04, &
        & 0.14607e-04,0.17135e-04,0.20557e-04,0.15005e-04 /)
      kao(:, 1, 2, 6) = (/ &
        & 0.99669e-08,0.32456e-05,0.58216e-05,0.81575e-05,0.10349e-04, &
        & 0.12573e-04,0.14901e-04,0.18163e-04,0.12615e-04 /)
      kao(:, 2, 2, 6) = (/ &
        & 0.12231e-07,0.33138e-05,0.59221e-05,0.82752e-05,0.10501e-04, &
        & 0.12666e-04,0.15004e-04,0.18147e-04,0.12797e-04 /)
      kao(:, 3, 2, 6) = (/ &
        & 0.10745e-07,0.37581e-05,0.67327e-05,0.94426e-05,0.12044e-04, &
        & 0.14533e-04,0.17181e-04,0.20503e-04,0.15464e-04 /)
      kao(:, 4, 2, 6) = (/ &
        & 0.11723e-07,0.37897e-05,0.67581e-05,0.94584e-05,0.12035e-04, &
        & 0.14508e-04,0.17115e-04,0.20450e-04,0.15378e-04 /)
      kao(:, 5, 2, 6) = (/ &
        & 0.10775e-07,0.34864e-05,0.61478e-05,0.85479e-05,0.10823e-04, &
        & 0.12985e-04,0.15273e-04,0.18381e-04,0.12972e-04 /)
      kao(:, 1, 3, 6) = (/ &
        & 0.12159e-07,0.28311e-05,0.50923e-05,0.71433e-05,0.90735e-05, &
        & 0.11042e-04,0.13160e-04,0.16141e-04,0.10790e-04 /)
      kao(:, 2, 3, 6) = (/ &
        & 0.11403e-07,0.28950e-05,0.51829e-05,0.72481e-05,0.92149e-05, &
        & 0.11135e-04,0.13267e-04,0.16084e-04,0.10912e-04 /)
      kao(:, 3, 3, 6) = (/ &
        & 0.12436e-07,0.29531e-05,0.52642e-05,0.73461e-05,0.93337e-05, &
        & 0.11250e-04,0.13358e-04,0.16208e-04,0.10995e-04 /)
      kao(:, 4, 3, 6) = (/ &
        & 0.14856e-07,0.33723e-05,0.60342e-05,0.84579e-05,0.10776e-04, &
        & 0.13025e-04,0.15434e-04,0.18466e-04,0.13550e-04 /)
      kao(:, 5, 3, 6) = (/ &
        & 0.16537e-07,0.30506e-05,0.53821e-05,0.74897e-05,0.94861e-05, &
        & 0.11421e-04,0.13503e-04,0.16308e-04,0.11045e-04 /)
      kao(:, 1, 4, 6) = (/ &
        & 0.13114e-07,0.24467e-05,0.44159e-05,0.61941e-05,0.78845e-05, &
        & 0.96031e-05,0.11513e-04,0.14234e-04,0.89642e-05 /)
      kao(:, 2, 4, 6) = (/ &
        & 0.15028e-07,0.25040e-05,0.44954e-05,0.62931e-05,0.80050e-05, &
        & 0.97056e-05,0.11618e-04,0.14175e-04,0.90802e-05 /)
      kao(:, 3, 4, 6) = (/ &
        & 0.18213e-07,0.25556e-05,0.45678e-05,0.63789e-05,0.81071e-05, &
        & 0.98077e-05,0.11694e-04,0.14301e-04,0.91538e-05 /)
      kao(:, 4, 4, 6) = (/ &
        & 0.19097e-07,0.26037e-05,0.46288e-05,0.64476e-05,0.81897e-05, &
        & 0.98941e-05,0.11740e-04,0.14344e-04,0.91968e-05 /)
      kao(:, 5, 4, 6) = (/ &
        & 0.18014e-07,0.29993e-05,0.53622e-05,0.75209e-05,0.95686e-05, &
        & 0.11571e-04,0.13783e-04,0.16522e-04,0.11644e-04 /)
      kao(:, 1, 5, 6) = (/ &
        & 0.21237e-07,0.20921e-05,0.37961e-05,0.53264e-05,0.67905e-05, &
        & 0.82846e-05,0.99803e-05,0.12512e-04,0.44075e-05 /)
      kao(:, 2, 5, 6) = (/ &
        & 0.23885e-07,0.21444e-05,0.38676e-05,0.54146e-05,0.68931e-05, &
        & 0.83832e-05,0.10077e-04,0.12417e-04,0.44982e-05 /)
      kao(:, 3, 5, 6) = (/ &
        & 0.20851e-07,0.21906e-05,0.39301e-05,0.54900e-05,0.69833e-05, &
        & 0.84513e-05,0.10145e-04,0.12513e-04,0.45299e-05 /)
      kao(:, 4, 5, 6) = (/ &
        & 0.22487e-07,0.22322e-05,0.39843e-05,0.55506e-05,0.70502e-05, &
        & 0.85357e-05,0.10189e-04,0.12546e-04,0.45220e-05 /)
      kao(:, 5, 5, 6) = (/ &
        & 0.23015e-07,0.26442e-05,0.47363e-05,0.66520e-05,0.84676e-05, &
        & 0.10272e-04,0.12268e-04,0.14801e-04,0.72945e-05 /)
      kao(:, 1, 6, 6) = (/ &
        & 0.22693e-07,0.17592e-05,0.32289e-05,0.45327e-05,0.57876e-05, &
        & 0.70822e-05,0.85643e-05,0.10966e-04,0.53375e-05 /)
      kao(:, 2, 6, 6) = (/ &
        & 0.22407e-07,0.18081e-05,0.32912e-05,0.46136e-05,0.58716e-05, &
        & 0.71710e-05,0.86530e-05,0.10805e-04,0.53845e-05 /)
      kao(:, 3, 6, 6) = (/ &
        & 0.22705e-07,0.18504e-05,0.33475e-05,0.46786e-05,0.59585e-05, &
        & 0.72252e-05,0.87123e-05,0.10876e-04,0.53808e-05 /)
      kao(:, 4, 6, 6) = (/ &
        & 0.23941e-07,0.18862e-05,0.33938e-05,0.47325e-05,0.60159e-05, &
        & 0.72910e-05,0.87573e-05,0.10893e-04,0.53357e-05 /)
      kao(:, 5, 6, 6) = (/ &
        & 0.27004e-07,0.19136e-05,0.34294e-05,0.47766e-05,0.60573e-05, &
        & 0.73309e-05,0.87892e-05,0.10892e-04,0.52484e-05 /)
      kao(:, 1, 7, 6) = (/ &
        & 0.27131e-07,0.14236e-05,0.27128e-05,0.38203e-05,0.48870e-05, &
        & 0.59983e-05,0.72827e-05,0.94729e-05,0.86942e-05 /)
      kao(:, 2, 7, 6) = (/ &
        & 0.26214e-07,0.14673e-05,0.27677e-05,0.38940e-05,0.49627e-05, &
        & 0.60727e-05,0.73587e-05,0.93332e-05,0.87651e-05 /)
      kao(:, 3, 7, 6) = (/ &
        & 0.29249e-07,0.15085e-05,0.28175e-05,0.39503e-05,0.50362e-05, &
        & 0.61230e-05,0.74095e-05,0.93608e-05,0.87497e-05 /)
      kao(:, 4, 7, 6) = (/ &
        & 0.35846e-07,0.15423e-05,0.28570e-05,0.39988e-05,0.50875e-05, &
        & 0.61709e-05,0.74491e-05,0.93691e-05,0.88300e-05 /)
      kao(:, 5, 7, 6) = (/ &
        & 0.36255e-07,0.15665e-05,0.28868e-05,0.40378e-05,0.51248e-05, &
        & 0.62083e-05,0.74689e-05,0.93597e-05,0.88065e-05 /)
      kao(:, 1, 8, 6) = (/ &
        & 0.37619e-07,0.92017e-06,0.22295e-05,0.31821e-05,0.40883e-05, &
        & 0.50331e-05,0.61447e-05,0.80461e-05,0.15512e-04 /)
      kao(:, 2, 8, 6) = (/ &
        & 0.43015e-07,0.95048e-06,0.22782e-05,0.32493e-05,0.41585e-05, &
        & 0.50968e-05,0.61995e-05,0.80232e-05,0.15472e-04 /)
      kao(:, 3, 8, 6) = (/ &
        & 0.47635e-07,0.97934e-06,0.23207e-05,0.33002e-05,0.42181e-05, &
        & 0.51430e-05,0.62468e-05,0.79821e-05,0.15652e-04 /)
      kao(:, 4, 8, 6) = (/ &
        & 0.48140e-07,0.10026e-05,0.23582e-05,0.33416e-05,0.42650e-05, &
        & 0.51734e-05,0.62779e-05,0.79833e-05,0.15762e-04 /)
      kao(:, 5, 8, 6) = (/ &
        & 0.45231e-07,0.10212e-05,0.23819e-05,0.33754e-05,0.42991e-05, &
        & 0.52146e-05,0.62945e-05,0.79701e-05,0.15840e-04 /)
      kao(:, 1, 9, 6) = (/ &
        & 0.48601e-07,0.49350e-06,0.16585e-05,0.26009e-05,0.33796e-05, &
        & 0.41888e-05,0.51434e-05,0.67867e-05,0.26875e-04 /)
      kao(:, 2, 9, 6) = (/ &
        & 0.49825e-07,0.51680e-06,0.16935e-05,0.26607e-05,0.34457e-05, &
        & 0.42434e-05,0.51839e-05,0.68587e-05,0.27475e-04 /)
      kao(:, 3, 9, 6) = (/ &
        & 0.52843e-07,0.53573e-06,0.17199e-05,0.27038e-05,0.35027e-05, &
        & 0.42858e-05,0.52233e-05,0.67410e-05,0.28097e-04 /)
      kao(:, 4, 9, 6) = (/ &
        & 0.49841e-07,0.54248e-06,0.17493e-05,0.27418e-05,0.35427e-05, &
        & 0.43127e-05,0.52517e-05,0.67418e-05,0.28632e-04 /)
      kao(:, 5, 9, 6) = (/ &
        & 0.50649e-07,0.54940e-06,0.17700e-05,0.27695e-05,0.35712e-05, &
        & 0.43482e-05,0.52645e-05,0.67282e-05,0.28662e-04 /)
      kao(:, 1,10, 6) = (/ &
        & 0.82685e-07,0.54022e-06,0.87761e-06,0.18752e-05,0.27293e-05, &
        & 0.34506e-05,0.42821e-05,0.56501e-05,0.44067e-04 /)
      kao(:, 2,10, 6) = (/ &
        & 0.87011e-07,0.54017e-06,0.89732e-06,0.19208e-05,0.27945e-05, &
        & 0.35005e-05,0.43124e-05,0.57881e-05,0.45858e-04 /)
      kao(:, 3,10, 6) = (/ &
        & 0.79909e-07,0.55355e-06,0.90995e-06,0.19451e-05,0.28460e-05, &
        & 0.35425e-05,0.43438e-05,0.56593e-05,0.45805e-04 /)
      kao(:, 4,10, 6) = (/ &
        & 0.75533e-07,0.55705e-06,0.92147e-06,0.19661e-05,0.28785e-05, &
        & 0.35628e-05,0.43635e-05,0.56526e-05,0.46295e-04 /)
      kao(:, 5,10, 6) = (/ &
        & 0.76631e-07,0.55159e-06,0.93362e-06,0.19832e-05,0.29003e-05, &
        & 0.35965e-05,0.43731e-05,0.56385e-05,0.46720e-04 /)
      kao(:, 1,11, 6) = (/ &
        & 0.11164e-06,0.57710e-06,0.71279e-06,0.10003e-05,0.19253e-05, &
        & 0.28027e-05,0.35523e-05,0.47607e-05,0.51144e-04 /)
      kao(:, 2,11, 6) = (/ &
        & 0.11484e-06,0.58649e-06,0.71918e-06,0.10167e-05,0.19538e-05, &
        & 0.28431e-05,0.35713e-05,0.48333e-05,0.49887e-04 /)
      kao(:, 3,11, 6) = (/ &
        & 0.11442e-06,0.58483e-06,0.70503e-06,0.10320e-05,0.19684e-05, &
        & 0.28674e-05,0.35911e-05,0.47191e-05,0.50222e-04 /)
      kao(:, 4,11, 6) = (/ &
        & 0.11737e-06,0.58895e-06,0.70242e-06,0.10442e-05,0.19738e-05, &
        & 0.28962e-05,0.36035e-05,0.47045e-05,0.48754e-04 /)
      kao(:, 5,11, 6) = (/ &
        & 0.12314e-06,0.59299e-06,0.70874e-06,0.10470e-05,0.19736e-05, &
        & 0.29100e-05,0.36075e-05,0.46813e-05,0.45986e-04 /)
      kao(:, 1,12, 6) = (/ &
        & 0.14446e-06,0.57459e-06,0.72800e-06,0.69912e-06,0.11693e-05, &
        & 0.21457e-05,0.29151e-05,0.39683e-05,0.42970e-04 /)
      kao(:, 2,12, 6) = (/ &
        & 0.14738e-06,0.58568e-06,0.75374e-06,0.69814e-06,0.11797e-05, &
        & 0.21759e-05,0.29287e-05,0.39942e-05,0.41434e-04 /)
      kao(:, 3,12, 6) = (/ &
        & 0.15006e-06,0.60144e-06,0.75420e-06,0.70559e-06,0.11849e-05, &
        & 0.21718e-05,0.29383e-05,0.39185e-05,0.42909e-04 /)
      kao(:, 4,12, 6) = (/ &
        & 0.15745e-06,0.60776e-06,0.75984e-06,0.71270e-06,0.11804e-05, &
        & 0.21578e-05,0.29477e-05,0.38939e-05,0.41761e-04 /)
      kao(:, 5,12, 6) = (/ &
        & 0.16583e-06,0.62207e-06,0.74591e-06,0.69746e-06,0.11751e-05, &
        & 0.21552e-05,0.29514e-05,0.38695e-05,0.45252e-04 /)
      kao(:, 1,13, 6) = (/ &
        & 0.18492e-06,0.65841e-06,0.74904e-06,0.82698e-06,0.69790e-06, &
        & 0.13356e-05,0.23333e-05,0.33010e-05,0.43502e-04 /)
      kao(:, 2,13, 6) = (/ &
        & 0.18447e-06,0.66115e-06,0.74200e-06,0.80748e-06,0.68676e-06, &
        & 0.13419e-05,0.23369e-05,0.32873e-05,0.44908e-04 /)
      kao(:, 3,13, 6) = (/ &
        & 0.20107e-06,0.65387e-06,0.73155e-06,0.79291e-06,0.67848e-06, &
        & 0.13368e-05,0.23434e-05,0.32337e-05,0.47417e-04 /)
      kao(:, 4,13, 6) = (/ &
        & 0.20493e-06,0.66191e-06,0.72707e-06,0.79839e-06,0.67208e-06, &
        & 0.13273e-05,0.23466e-05,0.32075e-05,0.48703e-04 /)
      kao(:, 5,13, 6) = (/ &
        & 0.20003e-06,0.66753e-06,0.73390e-06,0.79794e-06,0.66936e-06, &
        & 0.13150e-05,0.23558e-05,0.31828e-05,0.50012e-04 /)
      kao(:, 1, 1, 7) = (/ &
        & 0.45955e-07,0.96988e-05,0.16766e-04,0.23073e-04,0.28829e-04, &
        & 0.34350e-04,0.39744e-04,0.45071e-04,0.36783e-04 /)
      kao(:, 2, 1, 7) = (/ &
        & 0.57268e-07,0.98413e-05,0.16970e-04,0.23311e-04,0.29149e-04, &
        & 0.34726e-04,0.40229e-04,0.45682e-04,0.37190e-04 /)
      kao(:, 3, 1, 7) = (/ &
        & 0.70060e-07,0.10517e-04,0.18168e-04,0.24965e-04,0.31264e-04, &
        & 0.37439e-04,0.43299e-04,0.49335e-04,0.41254e-04 /)
      kao(:, 4, 1, 7) = (/ &
        & 0.84370e-07,0.10120e-04,0.17302e-04,0.23633e-04,0.29544e-04, &
        & 0.35368e-04,0.40885e-04,0.46535e-04,0.37819e-04 /)
      kao(:, 5, 1, 7) = (/ &
        & 0.97346e-07,0.10254e-04,0.17458e-04,0.23773e-04,0.29672e-04, &
        & 0.35542e-04,0.41140e-04,0.46864e-04,0.38054e-04 /)
      kao(:, 1, 2, 7) = (/ &
        & 0.27937e-07,0.87332e-05,0.15102e-04,0.20785e-04,0.26002e-04, &
        & 0.30993e-04,0.35918e-04,0.41124e-04,0.32692e-04 /)
      kao(:, 2, 2, 7) = (/ &
        & 0.34502e-07,0.88655e-05,0.15279e-04,0.20992e-04,0.26281e-04, &
        & 0.31393e-04,0.36363e-04,0.41768e-04,0.33047e-04 /)
      kao(:, 3, 2, 7) = (/ &
        & 0.45243e-07,0.95567e-05,0.16535e-04,0.22740e-04,0.28503e-04, &
        & 0.34161e-04,0.39521e-04,0.45509e-04,0.37184e-04 /)
      kao(:, 4, 2, 7) = (/ &
        & 0.56029e-07,0.96404e-05,0.16599e-04,0.22759e-04,0.28526e-04, &
        & 0.34207e-04,0.39586e-04,0.45601e-04,0.37152e-04 /)
      kao(:, 5, 2, 7) = (/ &
        & 0.67453e-07,0.92372e-05,0.15744e-04,0.21435e-04,0.26769e-04, &
        & 0.32085e-04,0.37228e-04,0.42908e-04,0.33841e-04 /)
      kao(:, 1, 3, 7) = (/ &
        & 0.21909e-07,0.77821e-05,0.13457e-04,0.18525e-04,0.23194e-04, &
        & 0.27662e-04,0.32086e-04,0.37089e-04,0.28700e-04 /)
      kao(:, 2, 3, 7) = (/ &
        & 0.25816e-07,0.78998e-05,0.13627e-04,0.18723e-04,0.23459e-04, &
        & 0.28049e-04,0.32494e-04,0.37775e-04,0.29060e-04 /)
      kao(:, 3, 3, 7) = (/ &
        & 0.28009e-07,0.80177e-05,0.13778e-04,0.18883e-04,0.23652e-04, &
        & 0.28348e-04,0.32831e-04,0.38183e-04,0.29363e-04 /)
      kao(:, 4, 3, 7) = (/ &
        & 0.32250e-07,0.87000e-05,0.14997e-04,0.20591e-04,0.25858e-04, &
        & 0.30984e-04,0.35855e-04,0.41716e-04,0.33352e-04 /)
      kao(:, 5, 3, 7) = (/ &
        & 0.38565e-07,0.82442e-05,0.14048e-04,0.19147e-04,0.23963e-04, &
        & 0.28712e-04,0.33322e-04,0.38841e-04,0.29827e-04 /)
      kao(:, 1, 4, 7) = (/ &
        & 0.27845e-07,0.68782e-05,0.11887e-04,0.16370e-04,0.20522e-04, &
        & 0.24507e-04,0.28445e-04,0.33146e-04,0.25091e-04 /)
      kao(:, 2, 4, 7) = (/ &
        & 0.30162e-07,0.69860e-05,0.12053e-04,0.16569e-04,0.20786e-04, &
        & 0.24863e-04,0.28833e-04,0.33823e-04,0.25439e-04 /)
      kao(:, 3, 4, 7) = (/ &
        & 0.31547e-07,0.70934e-05,0.12196e-04,0.16734e-04,0.20984e-04, &
        & 0.25140e-04,0.29167e-04,0.34188e-04,0.25743e-04 /)
      kao(:, 4, 4, 7) = (/ &
        & 0.30733e-07,0.72009e-05,0.12319e-04,0.16870e-04,0.21150e-04, &
        & 0.25350e-04,0.29432e-04,0.34551e-04,0.26011e-04 /)
      kao(:, 5, 4, 7) = (/ &
        & 0.33104e-07,0.78742e-05,0.13511e-04,0.18536e-04,0.23314e-04, &
        & 0.27934e-04,0.32284e-04,0.37983e-04,0.29911e-04 /)
      kao(:, 1, 5, 7) = (/ &
        & 0.31453e-07,0.60344e-05,0.10431e-04,0.14360e-04,0.18025e-04, &
        & 0.21556e-04,0.25057e-04,0.29352e-04,0.21244e-04 /)
      kao(:, 2, 5, 7) = (/ &
        & 0.32645e-07,0.61373e-05,0.10589e-04,0.14561e-04,0.18288e-04, &
        & 0.21896e-04,0.25427e-04,0.30041e-04,0.21582e-04 /)
      kao(:, 3, 5, 7) = (/ &
        & 0.36285e-07,0.62371e-05,0.10724e-04,0.14730e-04,0.18494e-04, &
        & 0.22175e-04,0.25749e-04,0.30401e-04,0.21875e-04 /)
      kao(:, 4, 5, 7) = (/ &
        & 0.35840e-07,0.63361e-05,0.10841e-04,0.14872e-04,0.18672e-04, &
        & 0.22386e-04,0.26001e-04,0.30772e-04,0.22136e-04 /)
      kao(:, 5, 5, 7) = (/ &
        & 0.34391e-07,0.70384e-05,0.12100e-04,0.16639e-04,0.20967e-04, &
        & 0.25106e-04,0.29033e-04,0.34382e-04,0.26458e-04 /)
      kao(:, 1, 6, 7) = (/ &
        & 0.38317e-07,0.52554e-05,0.90847e-05,0.12506e-04,0.15706e-04, &
        & 0.18802e-04,0.21926e-04,0.25721e-04,0.82786e-05 /)
      kao(:, 2, 6, 7) = (/ &
        & 0.42993e-07,0.53521e-05,0.92425e-05,0.12708e-04,0.15965e-04, &
        & 0.19131e-04,0.22269e-04,0.26449e-04,0.85145e-05 /)
      kao(:, 3, 6, 7) = (/ &
        & 0.43612e-07,0.54474e-05,0.93707e-05,0.12875e-04,0.16176e-04, &
        & 0.19407e-04,0.22575e-04,0.26830e-04,0.87594e-05 /)
      kao(:, 4, 6, 7) = (/ &
        & 0.42757e-07,0.55405e-05,0.94823e-05,0.13019e-04,0.16363e-04, &
        & 0.19625e-04,0.22815e-04,0.27200e-04,0.90170e-05 /)
      kao(:, 5, 6, 7) = (/ &
        & 0.43664e-07,0.56274e-05,0.95923e-05,0.13140e-04,0.16520e-04, &
        & 0.19797e-04,0.22995e-04,0.27528e-04,0.91836e-05 /)
      kao(:, 1, 7, 7) = (/ &
        & 0.39995e-07,0.45414e-05,0.78502e-05,0.10801e-04,0.13562e-04, &
        & 0.16248e-04,0.19009e-04,0.22439e-04,0.93804e-05 /)
      kao(:, 2, 7, 7) = (/ &
        & 0.43614e-07,0.46331e-05,0.80059e-05,0.11000e-04,0.13813e-04, &
        & 0.16577e-04,0.19346e-04,0.23103e-04,0.95334e-05 /)
      kao(:, 3, 7, 7) = (/ &
        & 0.45687e-07,0.47201e-05,0.81316e-05,0.11167e-04,0.14031e-04, &
        & 0.16844e-04,0.19646e-04,0.23513e-04,0.96503e-05 /)
      kao(:, 4, 7, 7) = (/ &
        & 0.48386e-07,0.48081e-05,0.82413e-05,0.11310e-04,0.14223e-04, &
        & 0.17063e-04,0.19885e-04,0.23881e-04,0.95360e-05 /)
      kao(:, 5, 7, 7) = (/ &
        & 0.54287e-07,0.48899e-05,0.83473e-05,0.11434e-04,0.14383e-04, &
        & 0.17240e-04,0.20064e-04,0.24201e-04,0.94267e-05 /)
      kao(:, 1, 8, 7) = (/ &
        & 0.45720e-07,0.38685e-05,0.67269e-05,0.92537e-05,0.11613e-04, &
        & 0.13930e-04,0.16333e-04,0.19500e-04,0.15537e-04 /)
      kao(:, 2, 8, 7) = (/ &
        & 0.46817e-07,0.39568e-05,0.68775e-05,0.94493e-05,0.11857e-04, &
        & 0.14250e-04,0.16679e-04,0.19983e-04,0.15822e-04 /)
      kao(:, 3, 8, 7) = (/ &
        & 0.48700e-07,0.40362e-05,0.70012e-05,0.96148e-05,0.12076e-04, &
        & 0.14508e-04,0.16969e-04,0.20440e-04,0.15878e-04 /)
      kao(:, 4, 8, 7) = (/ &
        & 0.54460e-07,0.41199e-05,0.71098e-05,0.97580e-05,0.12268e-04, &
        & 0.14725e-04,0.17206e-04,0.20805e-04,0.16014e-04 /)
      kao(:, 5, 8, 7) = (/ &
        & 0.59565e-07,0.42000e-05,0.72128e-05,0.98789e-05,0.12424e-04, &
        & 0.14896e-04,0.17382e-04,0.21113e-04,0.15894e-04 /)
      kao(:, 1, 9, 7) = (/ &
        & 0.60502e-07,0.31758e-05,0.57011e-05,0.78602e-05,0.98646e-05, &
        & 0.11842e-04,0.13914e-04,0.16812e-04,0.32738e-04 /)
      kao(:, 2, 9, 7) = (/ &
        & 0.61920e-07,0.32583e-05,0.58474e-05,0.80501e-05,0.10097e-04, &
        & 0.12150e-04,0.14260e-04,0.17128e-04,0.32707e-04 /)
      kao(:, 3, 9, 7) = (/ &
        & 0.66102e-07,0.33410e-05,0.59686e-05,0.82148e-05,0.10310e-04, &
        & 0.12398e-04,0.14542e-04,0.17650e-04,0.33629e-04 /)
      kao(:, 4, 9, 7) = (/ &
        & 0.86168e-07,0.34261e-05,0.60763e-05,0.83539e-05,0.10496e-04, &
        & 0.12604e-04,0.14773e-04,0.17994e-04,0.33878e-04 /)
      kao(:, 5, 9, 7) = (/ &
        & 0.91586e-07,0.35057e-05,0.61764e-05,0.84703e-05,0.10646e-04, &
        & 0.12765e-04,0.14939e-04,0.18282e-04,0.33645e-04 /)
      kao(:, 1,10, 7) = (/ &
        & 0.96997e-07,0.19211e-05,0.47098e-05,0.66155e-05,0.83225e-05, &
        & 0.10005e-04,0.11773e-04,0.14404e-04,0.53631e-04 /)
      kao(:, 2,10, 7) = (/ &
        & 0.96064e-07,0.20141e-05,0.48491e-05,0.67941e-05,0.85382e-05, &
        & 0.10290e-04,0.12102e-04,0.14626e-04,0.54289e-04 /)
      kao(:, 3,10, 7) = (/ &
        & 0.10431e-06,0.20834e-05,0.49690e-05,0.69520e-05,0.87398e-05, &
        & 0.10520e-04,0.12369e-04,0.15124e-04,0.55603e-04 /)
      kao(:, 4,10, 7) = (/ &
        & 0.11432e-06,0.21653e-05,0.50755e-05,0.70852e-05,0.89148e-05, &
        & 0.10714e-04,0.12591e-04,0.15457e-04,0.56630e-04 /)
      kao(:, 5,10, 7) = (/ &
        & 0.11074e-06,0.22480e-05,0.51732e-05,0.71951e-05,0.90530e-05, &
        & 0.10860e-04,0.12745e-04,0.15721e-04,0.54963e-04 /)
      kao(:, 1,11, 7) = (/ &
        & 0.15854e-06,0.91297e-06,0.32555e-05,0.55113e-05,0.70464e-05, &
        & 0.85121e-05,0.10027e-04,0.12303e-04,0.52607e-04 /)
      kao(:, 2,11, 7) = (/ &
        & 0.16751e-06,0.96634e-06,0.33790e-05,0.56722e-05,0.72351e-05, &
        & 0.87519e-05,0.10311e-04,0.12547e-04,0.52883e-04 /)
      kao(:, 3,11, 7) = (/ &
        & 0.16741e-06,0.10318e-05,0.35064e-05,0.58058e-05,0.74099e-05, &
        & 0.89413e-05,0.10546e-04,0.12998e-04,0.52407e-04 /)
      kao(:, 4,11, 7) = (/ &
        & 0.16708e-06,0.10925e-05,0.36064e-05,0.59145e-05,0.75531e-05, &
        & 0.90996e-05,0.10715e-04,0.13285e-04,0.53203e-04 /)
      kao(:, 5,11, 7) = (/ &
        & 0.16578e-06,0.11490e-05,0.36852e-05,0.60104e-05,0.76652e-05, &
        & 0.92182e-05,0.10838e-04,0.13496e-04,0.54467e-04 /)
      kao(:, 1,12, 7) = (/ &
        & 0.17287e-06,0.67222e-06,0.20177e-05,0.42045e-05,0.58863e-05, &
        & 0.71911e-05,0.84904e-05,0.10467e-04,0.53824e-04 /)
      kao(:, 2,12, 7) = (/ &
        & 0.17534e-06,0.66930e-06,0.20902e-05,0.43510e-05,0.60518e-05, &
        & 0.73834e-05,0.87285e-05,0.10723e-04,0.57713e-04 /)
      kao(:, 3,12, 7) = (/ &
        & 0.19862e-06,0.69271e-06,0.21807e-05,0.44473e-05,0.61938e-05, &
        & 0.75395e-05,0.89230e-05,0.11082e-04,0.58727e-04 /)
      kao(:, 4,12, 7) = (/ &
        & 0.20481e-06,0.70155e-06,0.22437e-05,0.45330e-05,0.63072e-05, &
        & 0.76639e-05,0.90515e-05,0.11316e-04,0.62478e-04 /)
      kao(:, 5,12, 7) = (/ &
        & 0.22362e-06,0.66686e-06,0.23107e-05,0.46277e-05,0.64004e-05, &
        & 0.77560e-05,0.91460e-05,0.11480e-04,0.61459e-04 /)
      kao(:, 1,13, 7) = (/ &
        & 0.24394e-06,0.78850e-06,0.10005e-05,0.25869e-05,0.46671e-05, &
        & 0.60110e-05,0.71462e-05,0.88357e-05,0.59707e-04 /)
      kao(:, 2,13, 7) = (/ &
        & 0.25387e-06,0.77656e-06,0.10565e-05,0.27093e-05,0.48105e-05, &
        & 0.61610e-05,0.73436e-05,0.90989e-05,0.60151e-04 /)
      kao(:, 3,13, 7) = (/ &
        & 0.22260e-06,0.76604e-06,0.11188e-05,0.28168e-05,0.49259e-05, &
        & 0.62864e-05,0.74912e-05,0.93777e-05,0.58560e-04 /)
      kao(:, 4,13, 7) = (/ &
        & 0.22499e-06,0.75979e-06,0.11746e-05,0.28869e-05,0.50154e-05, &
        & 0.63819e-05,0.75933e-05,0.95633e-05,0.61656e-04 /)
      kao(:, 5,13, 7) = (/ &
        & 0.22527e-06,0.74699e-06,0.12195e-05,0.29526e-05,0.50915e-05, &
        & 0.64528e-05,0.76669e-05,0.96909e-05,0.60588e-04 /)
      kao(:, 1, 1, 8) = (/ &
        & 0.29788e-05,0.29380e-04,0.47103e-04,0.62484e-04,0.75923e-04, &
        & 0.86945e-04,0.96459e-04,0.10727e-03,0.95715e-04 /)
      kao(:, 2, 1, 8) = (/ &
        & 0.31829e-05,0.29542e-04,0.47406e-04,0.62987e-04,0.76500e-04, &
        & 0.87575e-04,0.97244e-04,0.10847e-03,0.96769e-04 /)
      kao(:, 3, 1, 8) = (/ &
        & 0.34017e-05,0.30451e-04,0.49181e-04,0.65673e-04,0.79848e-04, &
        & 0.91475e-04,0.10206e-03,0.11418e-03,0.10339e-03 /)
      kao(:, 4, 1, 8) = (/ &
        & 0.36204e-05,0.29858e-04,0.47964e-04,0.63849e-04,0.77416e-04, &
        & 0.88495e-04,0.98624e-04,0.11030e-03,0.98665e-04 /)
      kao(:, 5, 1, 8) = (/ &
        & 0.38336e-05,0.30032e-04,0.48176e-04,0.64174e-04,0.77743e-04, &
        & 0.88899e-04,0.99219e-04,0.11117e-03,0.99410e-04 /)
      kao(:, 1, 2, 8) = (/ &
        & 0.24422e-05,0.27039e-04,0.43472e-04,0.57657e-04,0.69985e-04, &
        & 0.80297e-04,0.89716e-04,0.10091e-03,0.87814e-04 /)
      kao(:, 2, 2, 8) = (/ &
        & 0.26194e-05,0.27224e-04,0.43834e-04,0.58227e-04,0.70564e-04, &
        & 0.80899e-04,0.90555e-04,0.10201e-03,0.88900e-04 /)
      kao(:, 3, 2, 8) = (/ &
        & 0.28026e-05,0.28185e-04,0.45675e-04,0.60941e-04,0.73932e-04, &
        & 0.84933e-04,0.95539e-04,0.10795e-03,0.95932e-04 /)
      kao(:, 4, 2, 8) = (/ &
        & 0.29807e-05,0.28297e-04,0.45818e-04,0.61151e-04,0.74119e-04, &
        & 0.85132e-04,0.95905e-04,0.10857e-03,0.96316e-04 /)
      kao(:, 5, 2, 8) = (/ &
        & 0.31559e-05,0.27777e-04,0.44649e-04,0.59431e-04,0.71821e-04, &
        & 0.82324e-04,0.92537e-04,0.10487e-03,0.91446e-04 /)
      kao(:, 1, 3, 8) = (/ &
        & 0.19527e-05,0.24728e-04,0.39864e-04,0.52777e-04,0.63893e-04, &
        & 0.73441e-04,0.82582e-04,0.93968e-04,0.79571e-04 /)
      kao(:, 2, 3, 8) = (/ &
        & 0.21028e-05,0.24948e-04,0.40273e-04,0.53366e-04,0.64472e-04, &
        & 0.74070e-04,0.83496e-04,0.95166e-04,0.80711e-04 /)
      kao(:, 3, 3, 8) = (/ &
        & 0.22571e-05,0.25146e-04,0.40613e-04,0.53873e-04,0.64998e-04, &
        & 0.74638e-04,0.84298e-04,0.96249e-04,0.81670e-04 /)
      kao(:, 4, 3, 8) = (/ &
        & 0.24052e-05,0.26082e-04,0.42367e-04,0.56407e-04,0.68204e-04, &
        & 0.78600e-04,0.89199e-04,0.10217e-03,0.88502e-04 /)
      kao(:, 5, 3, 8) = (/ &
        & 0.25493e-05,0.25521e-04,0.41156e-04,0.54597e-04,0.65795e-04, &
        & 0.75610e-04,0.85600e-04,0.98234e-04,0.83132e-04 /)
      kao(:, 1, 4, 8) = (/ &
        & 0.15249e-05,0.22458e-04,0.36230e-04,0.47832e-04,0.57788e-04, &
        & 0.66572e-04,0.75267e-04,0.86613e-04,0.71765e-04 /)
      kao(:, 2, 4, 8) = (/ &
        & 0.16472e-05,0.22706e-04,0.36674e-04,0.48420e-04,0.58373e-04, &
        & 0.67233e-04,0.76205e-04,0.87918e-04,0.72872e-04 /)
      kao(:, 3, 4, 8) = (/ &
        & 0.17727e-05,0.22924e-04,0.37041e-04,0.48925e-04,0.58917e-04, &
        & 0.67822e-04,0.77056e-04,0.89127e-04,0.73812e-04 /)
      kao(:, 4, 4, 8) = (/ &
        & 0.18979e-05,0.23116e-04,0.37363e-04,0.49353e-04,0.59386e-04, &
        & 0.68373e-04,0.77816e-04,0.90208e-04,0.74597e-04 /)
      kao(:, 5, 4, 8) = (/ &
        & 0.20187e-05,0.24032e-04,0.39090e-04,0.51784e-04,0.62486e-04, &
        & 0.72274e-04,0.82652e-04,0.95944e-04,0.81360e-04 /)
      kao(:, 1, 5, 8) = (/ &
        & 0.11616e-05,0.20230e-04,0.32593e-04,0.43015e-04,0.51913e-04, &
        & 0.59885e-04,0.68041e-04,0.79091e-04,0.64237e-04 /)
      kao(:, 2, 5, 8) = (/ &
        & 0.12634e-05,0.20493e-04,0.33052e-04,0.43575e-04,0.52485e-04, &
        & 0.60579e-04,0.68993e-04,0.80447e-04,0.65308e-04 /)
      kao(:, 3, 5, 8) = (/ &
        & 0.13665e-05,0.20722e-04,0.33449e-04,0.44078e-04,0.53031e-04, &
        & 0.61206e-04,0.69878e-04,0.81712e-04,0.66219e-04 /)
      kao(:, 4, 5, 8) = (/ &
        & 0.14654e-05,0.20926e-04,0.33806e-04,0.44507e-04,0.53511e-04, &
        & 0.61775e-04,0.70644e-04,0.82800e-04,0.67010e-04 /)
      kao(:, 5, 5, 8) = (/ &
        & 0.15654e-05,0.21919e-04,0.35683e-04,0.47135e-04,0.56892e-04, &
        & 0.66014e-04,0.75901e-04,0.88948e-04,0.74367e-04 /)
      kao(:, 1, 6, 8) = (/ &
        & 0.85477e-06,0.18056e-04,0.29058e-04,0.38374e-04,0.46318e-04, &
        & 0.53503e-04,0.60983e-04,0.71567e-04,0.55220e-04 /)
      kao(:, 2, 6, 8) = (/ &
        & 0.93399e-06,0.18333e-04,0.29518e-04,0.38924e-04,0.46903e-04, &
        & 0.54228e-04,0.61990e-04,0.72960e-04,0.56327e-04 /)
      kao(:, 3, 6, 8) = (/ &
        & 0.10173e-05,0.18568e-04,0.29940e-04,0.39430e-04,0.47457e-04, &
        & 0.54891e-04,0.62912e-04,0.74219e-04,0.57262e-04 /)
      kao(:, 4, 6, 8) = (/ &
        & 0.10990e-05,0.18773e-04,0.30321e-04,0.39858e-04,0.47937e-04, &
        & 0.55463e-04,0.63685e-04,0.75339e-04,0.58060e-04 /)
      kao(:, 5, 6, 8) = (/ &
        & 0.11736e-05,0.18980e-04,0.30632e-04,0.40210e-04,0.48338e-04, &
        & 0.55952e-04,0.64349e-04,0.76243e-04,0.58787e-04 /)
      kao(:, 1, 7, 8) = (/ &
        & 0.60315e-06,0.15982e-04,0.25725e-04,0.33991e-04,0.41066e-04, &
        & 0.47516e-04,0.54302e-04,0.64196e-04,0.19175e-04 /)
      kao(:, 2, 7, 8) = (/ &
        & 0.66792e-06,0.16270e-04,0.26184e-04,0.34534e-04,0.41673e-04, &
        & 0.48253e-04,0.55322e-04,0.65617e-04,0.20214e-04 /)
      kao(:, 3, 7, 8) = (/ &
        & 0.72908e-06,0.16517e-04,0.26616e-04,0.35037e-04,0.42229e-04, &
        & 0.48924e-04,0.56239e-04,0.66903e-04,0.21171e-04 /)
      kao(:, 4, 7, 8) = (/ &
        & 0.78570e-06,0.16735e-04,0.27002e-04,0.35463e-04,0.42700e-04, &
        & 0.49504e-04,0.57015e-04,0.68011e-04,0.22118e-04 /)
      kao(:, 5, 7, 8) = (/ &
        & 0.83832e-06,0.16948e-04,0.27325e-04,0.35815e-04,0.43102e-04, &
        & 0.50003e-04,0.57693e-04,0.68917e-04,0.22989e-04 /)
      kao(:, 1, 8, 8) = (/ &
        & 0.37835e-06,0.14042e-04,0.22619e-04,0.29906e-04,0.36184e-04, &
        & 0.41943e-04,0.48058e-04,0.57159e-04,0.15030e-04 /)
      kao(:, 2, 8, 8) = (/ &
        & 0.42400e-06,0.14336e-04,0.23076e-04,0.30441e-04,0.36790e-04, &
        & 0.42677e-04,0.49055e-04,0.58574e-04,0.15267e-04 /)
      kao(:, 3, 8, 8) = (/ &
        & 0.47003e-06,0.14598e-04,0.23503e-04,0.30926e-04,0.37338e-04, &
        & 0.43345e-04,0.49944e-04,0.59871e-04,0.15168e-04 /)
      kao(:, 4, 8, 8) = (/ &
        & 0.50983e-06,0.14832e-04,0.23887e-04,0.31342e-04,0.37806e-04, &
        & 0.43932e-04,0.50714e-04,0.60954e-04,0.15479e-04 /)
      kao(:, 5, 8, 8) = (/ &
        & 0.55238e-06,0.15050e-04,0.24211e-04,0.31698e-04,0.38215e-04, &
        & 0.44447e-04,0.51404e-04,0.61843e-04,0.15864e-04 /)
      kao(:, 1, 9, 8) = (/ &
        & 0.20614e-06,0.12247e-04,0.19755e-04,0.26136e-04,0.31671e-04, &
        & 0.36795e-04,0.42267e-04,0.50480e-04,0.31415e-04 /)
      kao(:, 2, 9, 8) = (/ &
        & 0.22820e-06,0.12543e-04,0.20203e-04,0.26660e-04,0.32273e-04, &
        & 0.37518e-04,0.43228e-04,0.51895e-04,0.32257e-04 /)
      kao(:, 3, 9, 8) = (/ &
        & 0.25381e-06,0.12814e-04,0.20621e-04,0.27129e-04,0.32814e-04, &
        & 0.38186e-04,0.44095e-04,0.53151e-04,0.31766e-04 /)
      kao(:, 4, 9, 8) = (/ &
        & 0.26266e-06,0.13056e-04,0.20991e-04,0.27538e-04,0.33285e-04, &
        & 0.38781e-04,0.44859e-04,0.54214e-04,0.32184e-04 /)
      kao(:, 5, 9, 8) = (/ &
        & 0.28878e-06,0.13277e-04,0.21308e-04,0.27899e-04,0.33704e-04, &
        & 0.39313e-04,0.45556e-04,0.55111e-04,0.32436e-04 /)
      kao(:, 1,10, 8) = (/ &
        & 0.12421e-06,0.10598e-04,0.17170e-04,0.22745e-04,0.27597e-04, &
        & 0.32129e-04,0.37024e-04,0.44410e-04,0.36288e-04 /)
      kao(:, 2,10, 8) = (/ &
        & 0.11833e-06,0.10888e-04,0.17606e-04,0.23251e-04,0.28191e-04, &
        & 0.32843e-04,0.37957e-04,0.45757e-04,0.36706e-04 /)
      kao(:, 3,10, 8) = (/ &
        & 0.11564e-06,0.11153e-04,0.18009e-04,0.23706e-04,0.28726e-04, &
        & 0.33507e-04,0.38804e-04,0.46971e-04,0.39285e-04 /)
      kao(:, 4,10, 8) = (/ &
        & 0.11888e-06,0.11400e-04,0.18364e-04,0.24104e-04,0.29196e-04, &
        & 0.34101e-04,0.39555e-04,0.47996e-04,0.37765e-04 /)
      kao(:, 5,10, 8) = (/ &
        & 0.13250e-06,0.11625e-04,0.18671e-04,0.24463e-04,0.29622e-04, &
        & 0.34646e-04,0.40249e-04,0.48876e-04,0.41184e-04 /)
      kao(:, 1,11, 8) = (/ &
        & 0.17958e-06,0.90757e-05,0.15007e-04,0.19889e-04,0.24154e-04, &
        & 0.28187e-04,0.32636e-04,0.39437e-04,0.34162e-04 /)
      kao(:, 2,11, 8) = (/ &
        & 0.18139e-06,0.93666e-05,0.15418e-04,0.20361e-04,0.24716e-04, &
        & 0.28864e-04,0.33507e-04,0.40680e-04,0.35787e-04 /)
      kao(:, 3,11, 8) = (/ &
        & 0.18275e-06,0.96291e-05,0.15787e-04,0.20786e-04,0.25221e-04, &
        & 0.29495e-04,0.34295e-04,0.41765e-04,0.33878e-04 /)
      kao(:, 4,11, 8) = (/ &
        & 0.18574e-06,0.98743e-05,0.16117e-04,0.21165e-04,0.25673e-04, &
        & 0.30069e-04,0.35015e-04,0.42686e-04,0.32841e-04 /)
      kao(:, 5,11, 8) = (/ &
        & 0.20082e-06,0.10102e-04,0.16409e-04,0.21512e-04,0.26096e-04, &
        & 0.30600e-04,0.35678e-04,0.43526e-04,0.33904e-04 /)
      kao(:, 1,12, 8) = (/ &
        & 0.23860e-06,0.72127e-05,0.13015e-04,0.17297e-04,0.21033e-04, &
        & 0.24600e-04,0.28604e-04,0.34818e-04,0.40933e-04 /)
      kao(:, 2,12, 8) = (/ &
        & 0.23391e-06,0.75352e-05,0.13408e-04,0.17740e-04,0.21564e-04, &
        & 0.25251e-04,0.29426e-04,0.35947e-04,0.39399e-04 /)
      kao(:, 3,12, 8) = (/ &
        & 0.24701e-06,0.78057e-05,0.13760e-04,0.18144e-04,0.22045e-04, &
        & 0.25844e-04,0.30162e-04,0.36924e-04,0.38294e-04 /)
      kao(:, 4,12, 8) = (/ &
        & 0.26761e-06,0.80774e-05,0.14071e-04,0.18509e-04,0.22485e-04, &
        & 0.26399e-04,0.30850e-04,0.37793e-04,0.37310e-04 /)
      kao(:, 5,12, 8) = (/ &
        & 0.23665e-06,0.83711e-05,0.14360e-04,0.18850e-04,0.22903e-04, &
        & 0.26918e-04,0.31485e-04,0.38601e-04,0.34593e-04 /)
      kao(:, 1,13, 8) = (/ &
        & 0.27521e-06,0.50755e-05,0.11059e-04,0.14942e-04,0.18221e-04, &
        & 0.21366e-04,0.24941e-04,0.30569e-04,0.35909e-04 /)
      kao(:, 2,13, 8) = (/ &
        & 0.25317e-06,0.53749e-05,0.11450e-04,0.15364e-04,0.18725e-04, &
        & 0.21982e-04,0.25707e-04,0.31598e-04,0.37411e-04 /)
      kao(:, 3,13, 8) = (/ &
        & 0.23895e-06,0.56684e-05,0.11800e-04,0.15745e-04,0.19182e-04, &
        & 0.22548e-04,0.26403e-04,0.32490e-04,0.35715e-04 /)
      kao(:, 4,13, 8) = (/ &
        & 0.23323e-06,0.59219e-05,0.12110e-04,0.16104e-04,0.19621e-04, &
        & 0.23090e-04,0.27069e-04,0.33309e-04,0.26489e-04 /)
      kao(:, 5,13, 8) = (/ &
        & 0.23115e-06,0.61949e-05,0.12408e-04,0.16438e-04,0.20031e-04, &
        & 0.23602e-04,0.27683e-04,0.34068e-04,0.26612e-04 /)
      kao(:, 1, 1, 9) = (/ &
        & 0.91507e-04,0.14710e-03,0.19128e-03,0.22605e-03,0.25532e-03, &
        & 0.28077e-03,0.30345e-03,0.32646e-03,0.30807e-03 /)
      kao(:, 2, 1, 9) = (/ &
        & 0.91242e-04,0.14642e-03,0.19074e-03,0.22564e-03,0.25500e-03, &
        & 0.28086e-03,0.30369e-03,0.32690e-03,0.30957e-03 /)
      kao(:, 3, 1, 9) = (/ &
        & 0.90877e-04,0.14692e-03,0.19251e-03,0.22869e-03,0.25946e-03, &
        & 0.28682e-03,0.31087e-03,0.33538e-03,0.32011e-03 /)
      kao(:, 4, 1, 9) = (/ &
        & 0.90459e-04,0.14494e-03,0.18943e-03,0.22459e-03,0.25465e-03, &
        & 0.28114e-03,0.30414e-03,0.32755e-03,0.31196e-03 /)
      kao(:, 5, 1, 9) = (/ &
        & 0.89993e-04,0.14416e-03,0.18875e-03,0.22408e-03,0.25453e-03, &
        & 0.28137e-03,0.30449e-03,0.32780e-03,0.31307e-03 /)
      kao(:, 1, 2, 9) = (/ &
        & 0.77262e-04,0.13432e-03,0.17769e-03,0.21240e-03,0.24204e-03, &
        & 0.26866e-03,0.29235e-03,0.31628e-03,0.29582e-03 /)
      kao(:, 2, 2, 9) = (/ &
        & 0.77061e-04,0.13375e-03,0.17727e-03,0.21210e-03,0.24206e-03, &
        & 0.26905e-03,0.29288e-03,0.31707e-03,0.29754e-03 /)
      kao(:, 3, 2, 9) = (/ &
        & 0.76803e-04,0.13443e-03,0.17926e-03,0.21557e-03,0.24713e-03, &
        & 0.27557e-03,0.30072e-03,0.32610e-03,0.30880e-03 /)
      kao(:, 4, 2, 9) = (/ &
        & 0.76502e-04,0.13372e-03,0.17855e-03,0.21503e-03,0.24689e-03, &
        & 0.27560e-03,0.30084e-03,0.32601e-03,0.30963e-03 /)
      kao(:, 5, 2, 9) = (/ &
        & 0.76149e-04,0.13198e-03,0.17568e-03,0.21133e-03,0.24254e-03, &
        & 0.27051e-03,0.29485e-03,0.31890e-03,0.30223e-03 /)
      kao(:, 1, 3, 9) = (/ &
        & 0.65103e-04,0.12258e-03,0.16452e-03,0.19865e-03,0.22866e-03, &
        & 0.25591e-03,0.28055e-03,0.30511e-03,0.28178e-03 /)
      kao(:, 2, 3, 9) = (/ &
        & 0.64961e-04,0.12216e-03,0.16424e-03,0.19863e-03,0.22903e-03, &
        & 0.25664e-03,0.28152e-03,0.30626e-03,0.28379e-03 /)
      kao(:, 3, 3, 9) = (/ &
        & 0.64796e-04,0.12170e-03,0.16393e-03,0.19861e-03,0.22948e-03, &
        & 0.25740e-03,0.28253e-03,0.30727e-03,0.28578e-03 /)
      kao(:, 4, 3, 9) = (/ &
        & 0.64583e-04,0.12248e-03,0.16600e-03,0.20227e-03,0.23481e-03, &
        & 0.26421e-03,0.29055e-03,0.31636e-03,0.29736e-03 /)
      kao(:, 5, 3, 9) = (/ &
        & 0.64341e-04,0.12081e-03,0.16325e-03,0.19869e-03,0.23043e-03, &
        & 0.25903e-03,0.28445e-03,0.30920e-03,0.28976e-03 /)
      kao(:, 1, 4, 9) = (/ &
        & 0.54784e-04,0.11174e-03,0.15188e-03,0.18523e-03,0.21503e-03, &
        & 0.24239e-03,0.26770e-03,0.29311e-03,0.26685e-03 /)
      kao(:, 2, 4, 9) = (/ &
        & 0.54700e-04,0.11144e-03,0.15177e-03,0.18550e-03,0.21578e-03, &
        & 0.24348e-03,0.26903e-03,0.29466e-03,0.26928e-03 /)
      kao(:, 3, 4, 9) = (/ &
        & 0.54592e-04,0.11111e-03,0.15167e-03,0.18578e-03,0.21655e-03, &
        & 0.24456e-03,0.27029e-03,0.29609e-03,0.27162e-03 /)
      kao(:, 4, 4, 9) = (/ &
        & 0.54457e-04,0.11078e-03,0.15152e-03,0.18607e-03,0.21728e-03, &
        & 0.24565e-03,0.27151e-03,0.29746e-03,0.27399e-03 /)
      kao(:, 5, 4, 9) = (/ &
        & 0.54312e-04,0.11162e-03,0.15369e-03,0.18993e-03,0.22281e-03, &
        & 0.25263e-03,0.27972e-03,0.30664e-03,0.28593e-03 /)
      kao(:, 1, 5, 9) = (/ &
        & 0.46088e-04,0.10164e-03,0.13985e-03,0.17192e-03,0.20105e-03, &
        & 0.22810e-03,0.25365e-03,0.28019e-03,0.25169e-03 /)
      kao(:, 2, 5, 9) = (/ &
        & 0.46037e-04,0.10150e-03,0.13996e-03,0.17251e-03,0.20208e-03, &
        & 0.22949e-03,0.25532e-03,0.28211e-03,0.25438e-03 /)
      kao(:, 3, 5, 9) = (/ &
        & 0.45971e-04,0.10129e-03,0.14008e-03,0.17302e-03,0.20310e-03, &
        & 0.23085e-03,0.25690e-03,0.28385e-03,0.25702e-03 /)
      kao(:, 4, 5, 9) = (/ &
        & 0.45890e-04,0.10111e-03,0.14015e-03,0.17355e-03,0.20405e-03, &
        & 0.23221e-03,0.25843e-03,0.28547e-03,0.25970e-03 /)
      kao(:, 5, 5, 9) = (/ &
        & 0.45808e-04,0.10210e-03,0.14263e-03,0.17783e-03,0.21010e-03, &
        & 0.23994e-03,0.26750e-03,0.29545e-03,0.27288e-03 /)
      kao(:, 1, 6, 9) = (/ &
        & 0.38759e-04,0.92287e-04,0.12830e-03,0.15873e-03,0.18673e-03, &
        & 0.21305e-03,0.23858e-03,0.26603e-03,0.23576e-03 /)
      kao(:, 2, 6, 9) = (/ &
        & 0.38742e-04,0.92285e-04,0.12860e-03,0.15956e-03,0.18804e-03, &
        & 0.21479e-03,0.24061e-03,0.26833e-03,0.23876e-03 /)
      kao(:, 3, 6, 9) = (/ &
        & 0.38716e-04,0.92248e-04,0.12890e-03,0.16031e-03,0.18934e-03, &
        & 0.21647e-03,0.24252e-03,0.27042e-03,0.24167e-03 /)
      kao(:, 4, 6, 9) = (/ &
        & 0.38672e-04,0.92189e-04,0.12914e-03,0.16108e-03,0.19055e-03, &
        & 0.21815e-03,0.24441e-03,0.27232e-03,0.24468e-03 /)
      kao(:, 5, 6, 9) = (/ &
        & 0.38631e-04,0.92110e-04,0.12940e-03,0.16181e-03,0.19180e-03, &
        & 0.21982e-03,0.24634e-03,0.27420e-03,0.24778e-03 /)
      kao(:, 1, 7, 9) = (/ &
        & 0.32524e-04,0.83578e-04,0.11715e-03,0.14581e-03,0.17242e-03, &
        & 0.19778e-03,0.22289e-03,0.25099e-03,0.21544e-03 /)
      kao(:, 2, 7, 9) = (/ &
        & 0.32544e-04,0.83724e-04,0.11765e-03,0.14685e-03,0.17402e-03, &
        & 0.19984e-03,0.22531e-03,0.25360e-03,0.21897e-03 /)
      kao(:, 3, 7, 9) = (/ &
        & 0.32541e-04,0.83837e-04,0.11812e-03,0.14785e-03,0.17560e-03, &
        & 0.20184e-03,0.22764e-03,0.25604e-03,0.22234e-03 /)
      kao(:, 4, 7, 9) = (/ &
        & 0.32522e-04,0.83911e-04,0.11855e-03,0.14886e-03,0.17710e-03, &
        & 0.20381e-03,0.22989e-03,0.25831e-03,0.22586e-03 /)
      kao(:, 5, 7, 9) = (/ &
        & 0.32511e-04,0.83972e-04,0.11899e-03,0.14985e-03,0.17863e-03, &
        & 0.20577e-03,0.23212e-03,0.26056e-03,0.22930e-03 /)
      kao(:, 1, 8, 9) = (/ &
        & 0.27162e-04,0.75477e-04,0.10657e-03,0.13337e-03,0.15848e-03, &
        & 0.18267e-03,0.20707e-03,0.23532e-03,0.10685e-03 /)
      kao(:, 2, 8, 9) = (/ &
        & 0.27219e-04,0.75747e-04,0.10724e-03,0.13464e-03,0.16036e-03, &
        & 0.18507e-03,0.20988e-03,0.23834e-03,0.11049e-03 /)
      kao(:, 3, 8, 9) = (/ &
        & 0.27240e-04,0.75981e-04,0.10788e-03,0.13591e-03,0.16217e-03, &
        & 0.18731e-03,0.21250e-03,0.24115e-03,0.11463e-03 /)
      kao(:, 4, 8, 9) = (/ &
        & 0.27241e-04,0.76175e-04,0.10851e-03,0.13715e-03,0.16392e-03, &
        & 0.18952e-03,0.21504e-03,0.24375e-03,0.11830e-03 /)
      kao(:, 5, 8, 9) = (/ &
        & 0.27254e-04,0.76338e-04,0.10913e-03,0.13836e-03,0.16569e-03, &
        & 0.19172e-03,0.21755e-03,0.24638e-03,0.12227e-03 /)
      kao(:, 1, 9, 9) = (/ &
        & 0.22546e-04,0.67903e-04,0.96628e-04,0.12150e-03,0.14489e-03, &
        & 0.16757e-03,0.19095e-03,0.21913e-03,0.25626e-04 /)
      kao(:, 2, 9, 9) = (/ &
        & 0.22635e-04,0.68268e-04,0.97460e-04,0.12301e-03,0.14702e-03, &
        & 0.17028e-03,0.19411e-03,0.22260e-03,0.25839e-04 /)
      kao(:, 3, 9, 9) = (/ &
        & 0.22685e-04,0.68616e-04,0.98277e-04,0.12450e-03,0.14909e-03, &
        & 0.17284e-03,0.19709e-03,0.22578e-03,0.27443e-04 /)
      kao(:, 4, 9, 9) = (/ &
        & 0.22709e-04,0.68929e-04,0.99095e-04,0.12593e-03,0.15108e-03, &
        & 0.17530e-03,0.19995e-03,0.22878e-03,0.28531e-04 /)
      kao(:, 5, 9, 9) = (/ &
        & 0.22740e-04,0.69227e-04,0.99896e-04,0.12734e-03,0.15306e-03, &
        & 0.17777e-03,0.20277e-03,0.23170e-03,0.28894e-04 /)
      kao(:, 1,10, 9) = (/ &
        & 0.18403e-04,0.60856e-04,0.87340e-04,0.11017e-03,0.13174e-03, &
        & 0.15284e-03,0.17492e-03,0.20267e-03,0.31931e-04 /)
      kao(:, 2,10, 9) = (/ &
        & 0.18527e-04,0.61329e-04,0.88371e-04,0.11191e-03,0.13412e-03, &
        & 0.15579e-03,0.17838e-03,0.20650e-03,0.29084e-04 /)
      kao(:, 3,10, 9) = (/ &
        & 0.18600e-04,0.61796e-04,0.89354e-04,0.11363e-03,0.13643e-03, &
        & 0.15861e-03,0.18170e-03,0.21009e-03,0.27893e-04 /)
      kao(:, 4,10, 9) = (/ &
        & 0.18642e-04,0.62226e-04,0.90339e-04,0.11526e-03,0.13867e-03, &
        & 0.16137e-03,0.18486e-03,0.21346e-03,0.33895e-04 /)
      kao(:, 5,10, 9) = (/ &
        & 0.18688e-04,0.62651e-04,0.91302e-04,0.11690e-03,0.14093e-03, &
        & 0.16416e-03,0.18804e-03,0.21676e-03,0.31724e-04 /)
      kao(:, 1,11, 9) = (/ &
        & 0.14636e-04,0.54588e-04,0.79114e-04,0.10030e-03,0.12035e-03, &
        & 0.14003e-03,0.16089e-03,0.18797e-03,0.24886e-04 /)
      kao(:, 2,11, 9) = (/ &
        & 0.14721e-04,0.55182e-04,0.80295e-04,0.10221e-03,0.12288e-03, &
        & 0.14315e-03,0.16455e-03,0.19200e-03,0.28280e-04 /)
      kao(:, 3,11, 9) = (/ &
        & 0.14784e-04,0.55751e-04,0.81465e-04,0.10405e-03,0.12535e-03, &
        & 0.14614e-03,0.16802e-03,0.19578e-03,0.31405e-04 /)
      kao(:, 4,11, 9) = (/ &
        & 0.14831e-04,0.56293e-04,0.82611e-04,0.10589e-03,0.12782e-03, &
        & 0.14918e-03,0.17147e-03,0.19942e-03,0.34684e-04 /)
      kao(:, 5,11, 9) = (/ &
        & 0.14856e-04,0.56829e-04,0.83754e-04,0.10776e-03,0.13034e-03, &
        & 0.15225e-03,0.17499e-03,0.20312e-03,0.30970e-04 /)
      kao(:, 1,12, 9) = (/ &
        & 0.11572e-04,0.48876e-04,0.71553e-04,0.91191e-04,0.10973e-03, &
        & 0.12799e-03,0.14756e-03,0.17351e-03,0.30682e-04 /)
      kao(:, 2,12, 9) = (/ &
        & 0.11642e-04,0.49592e-04,0.72882e-04,0.93233e-04,0.11240e-03, &
        & 0.13124e-03,0.15132e-03,0.17770e-03,0.31240e-04 /)
      kao(:, 3,12, 9) = (/ &
        & 0.11629e-04,0.50261e-04,0.74205e-04,0.95210e-04,0.11505e-03, &
        & 0.13447e-03,0.15502e-03,0.18170e-03,0.31943e-04 /)
      kao(:, 4,12, 9) = (/ &
        & 0.11633e-04,0.50925e-04,0.75501e-04,0.97246e-04,0.11773e-03, &
        & 0.13775e-03,0.15878e-03,0.18567e-03,0.23441e-04 /)
      kao(:, 5,12, 9) = (/ &
        & 0.11677e-04,0.51560e-04,0.76851e-04,0.99310e-04,0.12044e-03, &
        & 0.14103e-03,0.16255e-03,0.18968e-03,0.23249e-04 /)
      kao(:, 1,13, 9) = (/ &
        & 0.88185e-05,0.43709e-04,0.64627e-04,0.82824e-04,0.99889e-04, &
        & 0.11672e-03,0.13488e-03,0.15952e-03,0.30903e-04 /)
      kao(:, 2,13, 9) = (/ &
        & 0.88986e-05,0.44515e-04,0.66093e-04,0.84980e-04,0.10270e-03, &
        & 0.12016e-03,0.13885e-03,0.16386e-03,0.25840e-04 /)
      kao(:, 3,13, 9) = (/ &
        & 0.89568e-05,0.45280e-04,0.67556e-04,0.87134e-04,0.10555e-03, &
        & 0.12361e-03,0.14282e-03,0.16813e-03,0.26878e-04 /)
      kao(:, 4,13, 9) = (/ &
        & 0.89829e-05,0.46045e-04,0.69040e-04,0.89346e-04,0.10842e-03, &
        & 0.12710e-03,0.14682e-03,0.17243e-03,0.28852e-04 /)
      kao(:, 5,13, 9) = (/ &
        & 0.90413e-05,0.46787e-04,0.70568e-04,0.91561e-04,0.11129e-03, &
        & 0.13056e-03,0.15080e-03,0.17669e-03,0.28623e-04 /)
      kao(:, 1, 1,10) = (/ &
        & 0.44112e-03,0.47423e-03,0.54876e-03,0.61567e-03,0.66971e-03, &
        & 0.71699e-03,0.76347e-03,0.77814e-03,0.77298e-03 /)
      kao(:, 2, 1,10) = (/ &
        & 0.43794e-03,0.47285e-03,0.54643e-03,0.61370e-03,0.66959e-03, &
        & 0.71530e-03,0.76226e-03,0.77693e-03,0.76966e-03 /)
      kao(:, 3, 1,10) = (/ &
        & 0.43480e-03,0.47183e-03,0.54721e-03,0.61831e-03,0.67726e-03, &
        & 0.72423e-03,0.77288e-03,0.78901e-03,0.78603e-03 /)
      kao(:, 4, 1,10) = (/ &
        & 0.43220e-03,0.46825e-03,0.54213e-03,0.61349e-03,0.66880e-03, &
        & 0.71215e-03,0.75938e-03,0.77341e-03,0.76775e-03 /)
      kao(:, 5, 1,10) = (/ &
        & 0.42987e-03,0.46597e-03,0.54025e-03,0.61237e-03,0.66800e-03, &
        & 0.70968e-03,0.75599e-03,0.77132e-03,0.76754e-03 /)
      kao(:, 1, 2,10) = (/ &
        & 0.37934e-03,0.43540e-03,0.51852e-03,0.59327e-03,0.65919e-03, &
        & 0.71028e-03,0.75523e-03,0.78660e-03,0.77018e-03 /)
      kao(:, 2, 2,10) = (/ &
        & 0.37616e-03,0.43418e-03,0.51743e-03,0.59232e-03,0.65869e-03, &
        & 0.70879e-03,0.75385e-03,0.78506e-03,0.76914e-03 /)
      kao(:, 3, 2,10) = (/ &
        & 0.37285e-03,0.43338e-03,0.51992e-03,0.59796e-03,0.66588e-03, &
        & 0.71863e-03,0.76525e-03,0.79746e-03,0.78726e-03 /)
      kao(:, 4, 2,10) = (/ &
        & 0.36993e-03,0.43092e-03,0.51858e-03,0.59729e-03,0.66425e-03, &
        & 0.71582e-03,0.76129e-03,0.79428e-03,0.78557e-03 /)
      kao(:, 5, 2,10) = (/ &
        & 0.36795e-03,0.42667e-03,0.51498e-03,0.59125e-03,0.65451e-03, &
        & 0.70295e-03,0.74646e-03,0.77706e-03,0.76846e-03 /)
      kao(:, 1, 3,10) = (/ &
        & 0.32398e-03,0.39840e-03,0.48910e-03,0.57202e-03,0.64247e-03, &
        & 0.69920e-03,0.74272e-03,0.78560e-03,0.76158e-03 /)
      kao(:, 2, 3,10) = (/ &
        & 0.32107e-03,0.39683e-03,0.48877e-03,0.57106e-03,0.64200e-03, &
        & 0.69780e-03,0.74068e-03,0.78389e-03,0.76255e-03 /)
      kao(:, 3, 3,10) = (/ &
        & 0.31808e-03,0.39502e-03,0.48851e-03,0.57104e-03,0.64052e-03, &
        & 0.69677e-03,0.73846e-03,0.78156e-03,0.76341e-03 /)
      kao(:, 4, 3,10) = (/ &
        & 0.31534e-03,0.39419e-03,0.49223e-03,0.57621e-03,0.64746e-03, &
        & 0.70569e-03,0.74986e-03,0.79350e-03,0.78192e-03 /)
      kao(:, 5, 3,10) = (/ &
        & 0.31343e-03,0.39031e-03,0.48789e-03,0.56911e-03,0.63804e-03, &
        & 0.69322e-03,0.73529e-03,0.77554e-03,0.76249e-03 /)
      kao(:, 1, 4,10) = (/ &
        & 0.27516e-03,0.36405e-03,0.46107e-03,0.54790e-03,0.62253e-03, &
        & 0.68384e-03,0.73057e-03,0.77856e-03,0.74793e-03 /)
      kao(:, 2, 4,10) = (/ &
        & 0.27272e-03,0.36262e-03,0.46080e-03,0.54700e-03,0.62201e-03, &
        & 0.68300e-03,0.72976e-03,0.77591e-03,0.74919e-03 /)
      kao(:, 3, 4,10) = (/ &
        & 0.26991e-03,0.36139e-03,0.46064e-03,0.54673e-03,0.62063e-03, &
        & 0.68269e-03,0.72862e-03,0.77298e-03,0.75070e-03 /)
      kao(:, 4, 4,10) = (/ &
        & 0.26757e-03,0.35993e-03,0.46053e-03,0.54625e-03,0.61982e-03, &
        & 0.68167e-03,0.72799e-03,0.77005e-03,0.75046e-03 /)
      kao(:, 5, 4,10) = (/ &
        & 0.26556e-03,0.36025e-03,0.46433e-03,0.55132e-03,0.62683e-03, &
        & 0.69143e-03,0.74137e-03,0.78366e-03,0.76845e-03 /)
      kao(:, 1, 5,10) = (/ &
        & 0.23277e-03,0.33279e-03,0.43313e-03,0.52236e-03,0.59970e-03, &
        & 0.66464e-03,0.71686e-03,0.76626e-03,0.72457e-03 /)
      kao(:, 2, 5,10) = (/ &
        & 0.23078e-03,0.33167e-03,0.43303e-03,0.52181e-03,0.60054e-03, &
        & 0.66529e-03,0.71807e-03,0.76458e-03,0.72852e-03 /)
      kao(:, 3, 5,10) = (/ &
        & 0.22839e-03,0.33111e-03,0.43245e-03,0.52229e-03,0.60068e-03, &
        & 0.66640e-03,0.71880e-03,0.76367e-03,0.73165e-03 /)
      kao(:, 4, 5,10) = (/ &
        & 0.22634e-03,0.33010e-03,0.43234e-03,0.52220e-03,0.60179e-03, &
        & 0.66699e-03,0.71996e-03,0.76305e-03,0.73316e-03 /)
      kao(:, 5, 5,10) = (/ &
        & 0.22442e-03,0.33158e-03,0.43680e-03,0.52864e-03,0.61018e-03, &
        & 0.67770e-03,0.73371e-03,0.78031e-03,0.75138e-03 /)
      kao(:, 1, 6,10) = (/ &
        & 0.19685e-03,0.30442e-03,0.40547e-03,0.49610e-03,0.57453e-03, &
        & 0.64299e-03,0.69899e-03,0.74954e-03,0.69460e-03 /)
      kao(:, 2, 6,10) = (/ &
        & 0.19517e-03,0.30338e-03,0.40585e-03,0.49683e-03,0.57671e-03, &
        & 0.64425e-03,0.70130e-03,0.75004e-03,0.70036e-03 /)
      kao(:, 3, 6,10) = (/ &
        & 0.19324e-03,0.30268e-03,0.40573e-03,0.49834e-03,0.57803e-03, &
        & 0.64627e-03,0.70310e-03,0.75130e-03,0.70596e-03 /)
      kao(:, 4, 6,10) = (/ &
        & 0.19132e-03,0.30224e-03,0.40644e-03,0.49947e-03,0.58014e-03, &
        & 0.64741e-03,0.70472e-03,0.75293e-03,0.70917e-03 /)
      kao(:, 5, 6,10) = (/ &
        & 0.18952e-03,0.30177e-03,0.40672e-03,0.50101e-03,0.58137e-03, &
        & 0.64847e-03,0.70602e-03,0.75537e-03,0.71121e-03 /)
      kao(:, 1, 7,10) = (/ &
        & 0.16684e-03,0.27825e-03,0.37860e-03,0.46883e-03,0.54680e-03, &
        & 0.61510e-03,0.67386e-03,0.72824e-03,0.66391e-03 /)
      kao(:, 2, 7,10) = (/ &
        & 0.16553e-03,0.27719e-03,0.37963e-03,0.47077e-03,0.54985e-03, &
        & 0.61768e-03,0.67717e-03,0.73093e-03,0.67156e-03 /)
      kao(:, 3, 7,10) = (/ &
        & 0.16397e-03,0.27663e-03,0.38054e-03,0.47308e-03,0.55166e-03, &
        & 0.62067e-03,0.67975e-03,0.73342e-03,0.67787e-03 /)
      kao(:, 4, 7,10) = (/ &
        & 0.16246e-03,0.27634e-03,0.38198e-03,0.47489e-03,0.55414e-03, &
        & 0.62280e-03,0.68232e-03,0.73600e-03,0.68175e-03 /)
      kao(:, 5, 7,10) = (/ &
        & 0.16089e-03,0.27624e-03,0.38314e-03,0.47665e-03,0.55585e-03, &
        & 0.62443e-03,0.68436e-03,0.73852e-03,0.68559e-03 /)
      kao(:, 1, 8,10) = (/ &
        & 0.14215e-03,0.25407e-03,0.35215e-03,0.43863e-03,0.51443e-03, &
        & 0.58154e-03,0.64180e-03,0.70004e-03,0.62276e-03 /)
      kao(:, 2, 8,10) = (/ &
        & 0.14104e-03,0.25332e-03,0.35394e-03,0.44179e-03,0.51810e-03, &
        & 0.58508e-03,0.64584e-03,0.70407e-03,0.63285e-03 /)
      kao(:, 3, 8,10) = (/ &
        & 0.13977e-03,0.25313e-03,0.35560e-03,0.44458e-03,0.52101e-03, &
        & 0.58953e-03,0.65037e-03,0.70785e-03,0.64108e-03 /)
      kao(:, 4, 8,10) = (/ &
        & 0.13869e-03,0.25332e-03,0.35744e-03,0.44722e-03,0.52464e-03, &
        & 0.59336e-03,0.65468e-03,0.71201e-03,0.64611e-03 /)
      kao(:, 5, 8,10) = (/ &
        & 0.13742e-03,0.25367e-03,0.35927e-03,0.44959e-03,0.52752e-03, &
        & 0.59656e-03,0.65824e-03,0.71554e-03,0.65066e-03 /)
      kao(:, 1, 9,10) = (/ &
        & 0.12109e-03,0.23210e-03,0.32446e-03,0.40715e-03,0.48065e-03, &
        & 0.54715e-03,0.60775e-03,0.66825e-03,0.18336e-04 /)
      kao(:, 2, 9,10) = (/ &
        & 0.12018e-03,0.23207e-03,0.32699e-03,0.41058e-03,0.48505e-03, &
        & 0.55180e-03,0.61323e-03,0.67309e-03,0.24327e-04 /)
      kao(:, 3, 9,10) = (/ &
        & 0.11917e-03,0.23229e-03,0.32956e-03,0.41390e-03,0.48910e-03, &
        & 0.55710e-03,0.61911e-03,0.67851e-03,0.23065e-04 /)
      kao(:, 4, 9,10) = (/ &
        & 0.11843e-03,0.23292e-03,0.33197e-03,0.41764e-03,0.49354e-03, &
        & 0.56238e-03,0.62497e-03,0.68395e-03,0.23680e-04 /)
      kao(:, 5, 9,10) = (/ &
        & 0.11748e-03,0.23365e-03,0.33458e-03,0.42109e-03,0.49774e-03, &
        & 0.56667e-03,0.62987e-03,0.68909e-03,0.25905e-04 /)
      kao(:, 1,10,10) = (/ &
        & 0.10273e-03,0.21204e-03,0.29794e-03,0.37761e-03,0.44937e-03, &
        & 0.51495e-03,0.57567e-03,0.63761e-03,0.19724e-04 /)
      kao(:, 2,10,10) = (/ &
        & 0.10190e-03,0.21272e-03,0.30059e-03,0.38150e-03,0.45434e-03, &
        & 0.52089e-03,0.58270e-03,0.64346e-03,0.24197e-04 /)
      kao(:, 3,10,10) = (/ &
        & 0.10112e-03,0.21334e-03,0.30377e-03,0.38507e-03,0.45917e-03, &
        & 0.52739e-03,0.58976e-03,0.64941e-03,0.34326e-04 /)
      kao(:, 4,10,10) = (/ &
        & 0.10061e-03,0.21443e-03,0.30659e-03,0.38965e-03,0.46453e-03, &
        & 0.53354e-03,0.59675e-03,0.65639e-03,0.33702e-04 /)
      kao(:, 5,10,10) = (/ &
        & 0.99890e-04,0.21543e-03,0.30998e-03,0.39375e-03,0.46925e-03, &
        & 0.53804e-03,0.60223e-03,0.66255e-03,0.31412e-04 /)
      kao(:, 1,11,10) = (/ &
        & 0.86338e-04,0.19398e-03,0.27516e-03,0.35204e-03,0.42116e-03, &
        & 0.48556e-03,0.54615e-03,0.60927e-03,0.19945e-04 /)
      kao(:, 2,11,10) = (/ &
        & 0.85730e-04,0.19502e-03,0.27834e-03,0.35636e-03,0.42792e-03, &
        & 0.49403e-03,0.55597e-03,0.61737e-03,0.90093e-05 /)
      kao(:, 3,11,10) = (/ &
        & 0.85275e-04,0.19618e-03,0.28168e-03,0.36165e-03,0.43438e-03, &
        & 0.50224e-03,0.56492e-03,0.62614e-03,0.37496e-04 /)
      kao(:, 4,11,10) = (/ &
        & 0.84865e-04,0.19761e-03,0.28526e-03,0.36657e-03,0.44042e-03, &
        & 0.50863e-03,0.57263e-03,0.63413e-03,0.15044e-04 /)
      kao(:, 5,11,10) = (/ &
        & 0.84443e-04,0.19914e-03,0.28886e-03,0.37069e-03,0.44492e-03, &
        & 0.51377e-03,0.57803e-03,0.63993e-03,0.48683e-04 /)
      kao(:, 1,12,10) = (/ &
        & 0.72237e-04,0.17794e-03,0.25491e-03,0.32737e-03,0.39376e-03, &
        & 0.45690e-03,0.51684e-03,0.58057e-03,0.10800e-04 /)
      kao(:, 2,12,10) = (/ &
        & 0.71846e-04,0.17916e-03,0.25896e-03,0.33355e-03,0.40234e-03, &
        & 0.46708e-03,0.52856e-03,0.59174e-03,0.37304e-04 /)
      kao(:, 3,12,10) = (/ &
        & 0.71641e-04,0.18095e-03,0.26291e-03,0.34013e-03,0.41022e-03, &
        & 0.47645e-03,0.53911e-03,0.60240e-03,0.20066e-04 /)
      kao(:, 4,12,10) = (/ &
        & 0.71337e-04,0.18255e-03,0.26698e-03,0.34557e-03,0.41722e-03, &
        & 0.48390e-03,0.54753e-03,0.61134e-03,0.20267e-04 /)
      kao(:, 5,12,10) = (/ &
        & 0.71187e-04,0.18456e-03,0.27032e-03,0.35012e-03,0.42265e-03, &
        & 0.49079e-03,0.55462e-03,0.61760e-03,0.29175e-04 /)
      kao(:, 1,13,10) = (/ &
        & 0.60308e-04,0.16344e-03,0.23674e-03,0.30451e-03,0.36859e-03, &
        & 0.42973e-03,0.48896e-03,0.55265e-03,0.35870e-04 /)
      kao(:, 2,13,10) = (/ &
        & 0.60075e-04,0.16518e-03,0.24182e-03,0.31202e-03,0.37817e-03, &
        & 0.44097e-03,0.50163e-03,0.56563e-03,0.24717e-04 /)
      kao(:, 3,13,10) = (/ &
        & 0.59963e-04,0.16736e-03,0.24636e-03,0.31956e-03,0.38717e-03, &
        & 0.45122e-03,0.51282e-03,0.57786e-03,0.24967e-04 /)
      kao(:, 4,13,10) = (/ &
        & 0.59808e-04,0.16950e-03,0.25081e-03,0.32559e-03,0.39488e-03, &
        & 0.45992e-03,0.52243e-03,0.58716e-03,0.25073e-04 /)
      kao(:, 5,13,10) = (/ &
        & 0.59738e-04,0.17182e-03,0.25430e-03,0.33121e-03,0.40220e-03, &
        & 0.46925e-03,0.53224e-03,0.59573e-03,0.14031e-04 /)
      kao(:, 1, 1,11) = (/ &
        & 0.79109e-03,0.77354e-03,0.84795e-03,0.91837e-03,0.98287e-03, &
        & 0.10467e-02,0.10876e-02,0.10899e-02,0.10918e-02 /)
      kao(:, 2, 1,11) = (/ &
        & 0.79035e-03,0.76999e-03,0.84502e-03,0.91315e-03,0.97569e-03, &
        & 0.10420e-02,0.10843e-02,0.10840e-02,0.10904e-02 /)
      kao(:, 3, 1,11) = (/ &
        & 0.79094e-03,0.76969e-03,0.84501e-03,0.91212e-03,0.97616e-03, &
        & 0.10502e-02,0.10978e-02,0.10968e-02,0.11098e-02 /)
      kao(:, 4, 1,11) = (/ &
        & 0.79012e-03,0.76698e-03,0.84052e-03,0.90224e-03,0.96448e-03, &
        & 0.10367e-02,0.10810e-02,0.10798e-02,0.10838e-02 /)
      kao(:, 5, 1,11) = (/ &
        & 0.78840e-03,0.76416e-03,0.83816e-03,0.89971e-03,0.96199e-03, &
        & 0.10344e-02,0.10796e-02,0.10773e-02,0.10800e-02 /)
      kao(:, 1, 2,11) = (/ &
        & 0.69789e-03,0.72093e-03,0.81475e-03,0.89922e-03,0.96655e-03, &
        & 0.10286e-02,0.10852e-02,0.10968e-02,0.10998e-02 /)
      kao(:, 2, 2,11) = (/ &
        & 0.69799e-03,0.71831e-03,0.81026e-03,0.89390e-03,0.96162e-03, &
        & 0.10278e-02,0.10853e-02,0.10953e-02,0.10980e-02 /)
      kao(:, 3, 2,11) = (/ &
        & 0.69849e-03,0.71872e-03,0.81039e-03,0.89368e-03,0.96713e-03, &
        & 0.10387e-02,0.11003e-02,0.11139e-02,0.11199e-02 /)
      kao(:, 4, 2,11) = (/ &
        & 0.69786e-03,0.71702e-03,0.80831e-03,0.88926e-03,0.96426e-03, &
        & 0.10353e-02,0.10976e-02,0.11107e-02,0.11152e-02 /)
      kao(:, 5, 2,11) = (/ &
        & 0.69639e-03,0.71420e-03,0.80246e-03,0.88289e-03,0.95515e-03, &
        & 0.10226e-02,0.10812e-02,0.10915e-02,0.10904e-02 /)
      kao(:, 1, 3,11) = (/ &
        & 0.60717e-03,0.66595e-03,0.77916e-03,0.87509e-03,0.95372e-03, &
        & 0.10167e-02,0.10820e-02,0.11070e-02,0.11005e-02 /)
      kao(:, 2, 3,11) = (/ &
        & 0.60740e-03,0.66447e-03,0.77425e-03,0.87078e-03,0.95087e-03, &
        & 0.10164e-02,0.10820e-02,0.11070e-02,0.10996e-02 /)
      kao(:, 3, 3,11) = (/ &
        & 0.60743e-03,0.66421e-03,0.77076e-03,0.86668e-03,0.94936e-03, &
        & 0.10146e-02,0.10809e-02,0.11066e-02,0.10979e-02 /)
      kao(:, 4, 3,11) = (/ &
        & 0.60721e-03,0.66487e-03,0.77207e-03,0.87093e-03,0.95679e-03, &
        & 0.10247e-02,0.10950e-02,0.11248e-02,0.11171e-02 /)
      kao(:, 5, 3,11) = (/ &
        & 0.60632e-03,0.66259e-03,0.76645e-03,0.86469e-03,0.94611e-03, &
        & 0.10116e-02,0.10778e-02,0.11040e-02,0.10953e-02 /)
      kao(:, 1, 4,11) = (/ &
        & 0.52196e-03,0.61309e-03,0.74127e-03,0.84825e-03,0.93805e-03, &
        & 0.10078e-02,0.10732e-02,0.11156e-02,0.10964e-02 /)
      kao(:, 2, 4,11) = (/ &
        & 0.52205e-03,0.61209e-03,0.73709e-03,0.84586e-03,0.93585e-03, &
        & 0.10074e-02,0.10727e-02,0.11168e-02,0.10976e-02 /)
      kao(:, 3, 4,11) = (/ &
        & 0.52218e-03,0.61175e-03,0.73426e-03,0.84316e-03,0.93485e-03, &
        & 0.10055e-02,0.10718e-02,0.11162e-02,0.10985e-02 /)
      kao(:, 4, 4,11) = (/ &
        & 0.52176e-03,0.61131e-03,0.73315e-03,0.84162e-03,0.93319e-03, &
        & 0.10035e-02,0.10709e-02,0.11149e-02,0.11000e-02 /)
      kao(:, 5, 4,11) = (/ &
        & 0.52100e-03,0.61215e-03,0.73639e-03,0.84868e-03,0.94102e-03, &
        & 0.10132e-02,0.10822e-02,0.11303e-02,0.11192e-02 /)
      kao(:, 1, 5,11) = (/ &
        & 0.44537e-03,0.56415e-03,0.70334e-03,0.81986e-03,0.91737e-03, &
        & 0.99505e-03,0.10590e-02,0.11155e-02,0.10855e-02 /)
      kao(:, 2, 5,11) = (/ &
        & 0.44499e-03,0.56304e-03,0.70021e-03,0.81824e-03,0.91496e-03, &
        & 0.99465e-03,0.10577e-02,0.11163e-02,0.10886e-02 /)
      kao(:, 3, 5,11) = (/ &
        & 0.44481e-03,0.56231e-03,0.69884e-03,0.81557e-03,0.91387e-03, &
        & 0.99269e-03,0.10566e-02,0.11154e-02,0.10925e-02 /)
      kao(:, 4, 5,11) = (/ &
        & 0.44459e-03,0.56155e-03,0.69827e-03,0.81462e-03,0.91145e-03, &
        & 0.99105e-03,0.10558e-02,0.11141e-02,0.10950e-02 /)
      kao(:, 5, 5,11) = (/ &
        & 0.44401e-03,0.56266e-03,0.70342e-03,0.82262e-03,0.92017e-03, &
        & 0.10017e-02,0.10686e-02,0.11300e-02,0.11166e-02 /)
      kao(:, 1, 6,11) = (/ &
        & 0.37714e-03,0.51787e-03,0.66544e-03,0.78793e-03,0.89178e-03, &
        & 0.97506e-03,0.10421e-02,0.11072e-02,0.10679e-02 /)
      kao(:, 2, 6,11) = (/ &
        & 0.37645e-03,0.51719e-03,0.66329e-03,0.78619e-03,0.88946e-03, &
        & 0.97613e-03,0.10421e-02,0.11076e-02,0.10727e-02 /)
      kao(:, 3, 6,11) = (/ &
        & 0.37621e-03,0.51663e-03,0.66248e-03,0.78421e-03,0.88840e-03, &
        & 0.97530e-03,0.10423e-02,0.11074e-02,0.10773e-02 /)
      kao(:, 4, 6,11) = (/ &
        & 0.37625e-03,0.51591e-03,0.66198e-03,0.78342e-03,0.88665e-03, &
        & 0.97510e-03,0.10427e-02,0.11065e-02,0.10807e-02 /)
      kao(:, 5, 6,11) = (/ &
        & 0.37578e-03,0.51583e-03,0.66231e-03,0.78322e-03,0.88597e-03, &
        & 0.97458e-03,0.10416e-02,0.11045e-02,0.10828e-02 /)
      kao(:, 1, 7,11) = (/ &
        & 0.31849e-03,0.47598e-03,0.62784e-03,0.75245e-03,0.86097e-03, &
        & 0.95037e-03,0.10228e-02,0.10907e-02,0.10381e-02 /)
      kao(:, 2, 7,11) = (/ &
        & 0.31748e-03,0.47565e-03,0.62625e-03,0.75127e-03,0.86016e-03, &
        & 0.95292e-03,0.10249e-02,0.10924e-02,0.10446e-02 /)
      kao(:, 3, 7,11) = (/ &
        & 0.31709e-03,0.47527e-03,0.62527e-03,0.75044e-03,0.86086e-03, &
        & 0.95398e-03,0.10272e-02,0.10943e-02,0.10513e-02 /)
      kao(:, 4, 7,11) = (/ &
        & 0.31690e-03,0.47506e-03,0.62534e-03,0.75023e-03,0.86098e-03, &
        & 0.95576e-03,0.10298e-02,0.10956e-02,0.10570e-02 /)
      kao(:, 5, 7,11) = (/ &
        & 0.31661e-03,0.47556e-03,0.62564e-03,0.75129e-03,0.86194e-03, &
        & 0.95752e-03,0.10312e-02,0.10967e-02,0.10605e-02 /)
      kao(:, 1, 8,11) = (/ &
        & 0.26920e-03,0.43740e-03,0.58907e-03,0.71604e-03,0.82585e-03, &
        & 0.92017e-03,0.99828e-03,0.10677e-02,0.99191e-03 /)
      kao(:, 2, 8,11) = (/ &
        & 0.26802e-03,0.43738e-03,0.58846e-03,0.71590e-03,0.82753e-03, &
        & 0.92484e-03,0.10036e-02,0.10726e-02,0.10010e-02 /)
      kao(:, 3, 8,11) = (/ &
        & 0.26738e-03,0.43742e-03,0.58827e-03,0.71679e-03,0.83051e-03, &
        & 0.92821e-03,0.10079e-02,0.10772e-02,0.10102e-02 /)
      kao(:, 4, 8,11) = (/ &
        & 0.26701e-03,0.43751e-03,0.58933e-03,0.71793e-03,0.83304e-03, &
        & 0.93190e-03,0.10124e-02,0.10810e-02,0.10188e-02 /)
      kao(:, 5, 8,11) = (/ &
        & 0.26686e-03,0.43824e-03,0.58999e-03,0.72050e-03,0.83607e-03, &
        & 0.93581e-03,0.10160e-02,0.10848e-02,0.10263e-02 /)
      kao(:, 1, 9,11) = (/ &
        & 0.22904e-03,0.40123e-03,0.55115e-03,0.67712e-03,0.78732e-03, &
        & 0.88313e-03,0.96568e-03,0.10387e-02,0.14403e-04 /)
      kao(:, 2, 9,11) = (/ &
        & 0.22775e-03,0.40129e-03,0.55155e-03,0.67918e-03,0.79168e-03, &
        & 0.89045e-03,0.97356e-03,0.10468e-02,0.17396e-04 /)
      kao(:, 3, 9,11) = (/ &
        & 0.22691e-03,0.40187e-03,0.55239e-03,0.68238e-03,0.79664e-03, &
        & 0.89641e-03,0.98013e-03,0.10538e-02,0.17983e-04 /)
      kao(:, 4, 9,11) = (/ &
        & 0.22637e-03,0.40220e-03,0.55452e-03,0.68525e-03,0.80145e-03, &
        & 0.90223e-03,0.98673e-03,0.10599e-02,0.14884e-04 /)
      kao(:, 5, 9,11) = (/ &
        & 0.22595e-03,0.40316e-03,0.55613e-03,0.68950e-03,0.80623e-03, &
        & 0.90849e-03,0.99244e-03,0.10655e-02,0.19485e-04 /)
      kao(:, 1,10,11) = (/ &
        & 0.19610e-03,0.36707e-03,0.51305e-03,0.63612e-03,0.74337e-03, &
        & 0.83875e-03,0.92458e-03,0.10007e-02,0.30583e-04 /)
      kao(:, 2,10,11) = (/ &
        & 0.19499e-03,0.36759e-03,0.51501e-03,0.64066e-03,0.75082e-03, &
        & 0.84853e-03,0.93443e-03,0.10117e-02,0.20484e-04 /)
      kao(:, 3,10,11) = (/ &
        & 0.19427e-03,0.36886e-03,0.51745e-03,0.64625e-03,0.75815e-03, &
        & 0.85733e-03,0.94303e-03,0.10217e-02,0.20784e-04 /)
      kao(:, 4,10,11) = (/ &
        & 0.19367e-03,0.36958e-03,0.52106e-03,0.65093e-03,0.76545e-03, &
        & 0.86571e-03,0.95244e-03,0.10301e-02,0.30511e-04 /)
      kao(:, 5,10,11) = (/ &
        & 0.19319e-03,0.37098e-03,0.52409e-03,0.65675e-03,0.77258e-03, &
        & 0.87491e-03,0.96110e-03,0.10378e-02,0.19883e-04 /)
      kao(:, 1,11,11) = (/ &
        & 0.16767e-03,0.33624e-03,0.47635e-03,0.59543e-03,0.70301e-03, &
        & 0.79872e-03,0.88652e-03,0.96550e-03,0.27483e-04 /)
      kao(:, 2,11,11) = (/ &
        & 0.16687e-03,0.33764e-03,0.48055e-03,0.60283e-03,0.71186e-03, &
        & 0.80978e-03,0.89673e-03,0.97758e-03,0.20639e-04 /)
      kao(:, 3,11,11) = (/ &
        & 0.16664e-03,0.33942e-03,0.48524e-03,0.60962e-03,0.72075e-03, &
        & 0.81953e-03,0.90753e-03,0.98729e-03,0.27689e-04 /)
      kao(:, 4,11,11) = (/ &
        & 0.16611e-03,0.34104e-03,0.48994e-03,0.61708e-03,0.72992e-03, &
        & 0.83047e-03,0.91898e-03,0.99769e-03,0.13719e-04 /)
      kao(:, 5,11,11) = (/ &
        & 0.16596e-03,0.34313e-03,0.49467e-03,0.62538e-03,0.73960e-03, &
        & 0.84171e-03,0.92999e-03,0.10075e-02,0.27137e-04 /)
      kao(:, 1,12,11) = (/ &
        & 0.14282e-03,0.30890e-03,0.44183e-03,0.55831e-03,0.66503e-03, &
        & 0.76077e-03,0.84890e-03,0.93128e-03,0.21228e-04 /)
      kao(:, 2,12,11) = (/ &
        & 0.14255e-03,0.31125e-03,0.44731e-03,0.56685e-03,0.67491e-03, &
        & 0.77277e-03,0.86092e-03,0.94274e-03,0.32331e-04 /)
      kao(:, 3,12,11) = (/ &
        & 0.14244e-03,0.31334e-03,0.45354e-03,0.57479e-03,0.68552e-03, &
        & 0.78420e-03,0.87396e-03,0.95434e-03,0.19978e-06 /)
      kao(:, 4,12,11) = (/ &
        & 0.14239e-03,0.31614e-03,0.45984e-03,0.58419e-03,0.69607e-03, &
        & 0.79750e-03,0.88765e-03,0.96637e-03,0.21475e-04 /)
      kao(:, 5,12,11) = (/ &
        & 0.14252e-03,0.31876e-03,0.46658e-03,0.59385e-03,0.70775e-03, &
        & 0.80986e-03,0.90037e-03,0.97814e-03,0.21476e-04 /)
      kao(:, 1,13,11) = (/ &
        & 0.12125e-03,0.28444e-03,0.41080e-03,0.52444e-03,0.62932e-03, &
        & 0.72481e-03,0.81245e-03,0.89716e-03,0.27405e-04 /)
      kao(:, 2,13,11) = (/ &
        & 0.12138e-03,0.28788e-03,0.41712e-03,0.53396e-03,0.64078e-03, &
        & 0.73819e-03,0.82737e-03,0.91020e-03,0.13699e-04 /)
      kao(:, 3,13,11) = (/ &
        & 0.12142e-03,0.29086e-03,0.42441e-03,0.54338e-03,0.65260e-03, &
        & 0.75224e-03,0.84352e-03,0.92398e-03,0.13820e-04 /)
      kao(:, 4,13,11) = (/ &
        & 0.12174e-03,0.29430e-03,0.43176e-03,0.55440e-03,0.66546e-03, &
        & 0.76738e-03,0.85914e-03,0.93821e-03,0.26505e-06 /)
      kao(:, 5,13,11) = (/ &
        & 0.12197e-03,0.29750e-03,0.43989e-03,0.56500e-03,0.67844e-03, &
        & 0.78071e-03,0.87280e-03,0.95108e-03,0.33764e-06 /)
      kao(:, 1, 1,12) = (/ &
        & 0.15537e-02,0.13818e-02,0.14273e-02,0.15055e-02,0.15786e-02, &
        & 0.16339e-02,0.16467e-02,0.15800e-02,0.16050e-02 /)
      kao(:, 2, 1,12) = (/ &
        & 0.15485e-02,0.13765e-02,0.14181e-02,0.14978e-02,0.15727e-02, &
        & 0.16256e-02,0.16371e-02,0.15728e-02,0.16005e-02 /)
      kao(:, 3, 1,12) = (/ &
        & 0.15437e-02,0.13722e-02,0.14122e-02,0.14971e-02,0.15752e-02, &
        & 0.16261e-02,0.16396e-02,0.15797e-02,0.16209e-02 /)
      kao(:, 4, 1,12) = (/ &
        & 0.15424e-02,0.13691e-02,0.14015e-02,0.14839e-02,0.15593e-02, &
        & 0.16040e-02,0.16150e-02,0.15487e-02,0.15957e-02 /)
      kao(:, 5, 1,12) = (/ &
        & 0.15425e-02,0.13681e-02,0.13961e-02,0.14766e-02,0.15502e-02, &
        & 0.15943e-02,0.16046e-02,0.15376e-02,0.15923e-02 /)
      kao(:, 1, 2,12) = (/ &
        & 0.14274e-02,0.13101e-02,0.13901e-02,0.14665e-02,0.15597e-02, &
        & 0.16365e-02,0.16682e-02,0.16286e-02,0.16381e-02 /)
      kao(:, 2, 2,12) = (/ &
        & 0.14223e-02,0.13039e-02,0.13828e-02,0.14629e-02,0.15522e-02, &
        & 0.16256e-02,0.16567e-02,0.16183e-02,0.16362e-02 /)
      kao(:, 3, 2,12) = (/ &
        & 0.14195e-02,0.12999e-02,0.13791e-02,0.14641e-02,0.15538e-02, &
        & 0.16259e-02,0.16605e-02,0.16235e-02,0.16585e-02 /)
      kao(:, 4, 2,12) = (/ &
        & 0.14181e-02,0.12958e-02,0.13726e-02,0.14576e-02,0.15447e-02, &
        & 0.16149e-02,0.16487e-02,0.16101e-02,0.16540e-02 /)
      kao(:, 5, 2,12) = (/ &
        & 0.14191e-02,0.12933e-02,0.13650e-02,0.14448e-02,0.15270e-02, &
        & 0.15959e-02,0.16273e-02,0.15850e-02,0.16279e-02 /)
      kao(:, 1, 3,12) = (/ &
        & 0.12975e-02,0.12495e-02,0.13516e-02,0.14440e-02,0.15390e-02, &
        & 0.16298e-02,0.16807e-02,0.16634e-02,0.16697e-02 /)
      kao(:, 2, 3,12) = (/ &
        & 0.12938e-02,0.12434e-02,0.13457e-02,0.14406e-02,0.15301e-02, &
        & 0.16196e-02,0.16709e-02,0.16534e-02,0.16671e-02 /)
      kao(:, 3, 3,12) = (/ &
        & 0.12920e-02,0.12378e-02,0.13412e-02,0.14340e-02,0.15221e-02, &
        & 0.16094e-02,0.16610e-02,0.16426e-02,0.16655e-02 /)
      kao(:, 4, 3,12) = (/ &
        & 0.12905e-02,0.12343e-02,0.13399e-02,0.14335e-02,0.15224e-02, &
        & 0.16137e-02,0.16692e-02,0.16519e-02,0.16891e-02 /)
      kao(:, 5, 3,12) = (/ &
        & 0.12916e-02,0.12305e-02,0.13333e-02,0.14197e-02,0.15049e-02, &
        & 0.15945e-02,0.16481e-02,0.16282e-02,0.16593e-02 /)
      kao(:, 1, 4,12) = (/ &
        & 0.11586e-02,0.11791e-02,0.13059e-02,0.14246e-02,0.15191e-02, &
        & 0.16155e-02,0.16888e-02,0.16884e-02,0.16900e-02 /)
      kao(:, 2, 4,12) = (/ &
        & 0.11563e-02,0.11735e-02,0.13020e-02,0.14191e-02,0.15117e-02, &
        & 0.16067e-02,0.16804e-02,0.16804e-02,0.16885e-02 /)
      kao(:, 3, 4,12) = (/ &
        & 0.11547e-02,0.11684e-02,0.12989e-02,0.14121e-02,0.15049e-02, &
        & 0.15986e-02,0.16736e-02,0.16742e-02,0.16864e-02 /)
      kao(:, 4, 4,12) = (/ &
        & 0.11549e-02,0.11640e-02,0.12947e-02,0.14053e-02,0.14971e-02, &
        & 0.15940e-02,0.16690e-02,0.16701e-02,0.16826e-02 /)
      kao(:, 5, 4,12) = (/ &
        & 0.11568e-02,0.11629e-02,0.12947e-02,0.14048e-02,0.15017e-02, &
        & 0.16054e-02,0.16836e-02,0.16886e-02,0.17044e-02 /)
      kao(:, 1, 5,12) = (/ &
        & 0.10197e-02,0.11002e-02,0.12563e-02,0.13948e-02,0.15048e-02, &
        & 0.16026e-02,0.16898e-02,0.17082e-02,0.17013e-02 /)
      kao(:, 2, 5,12) = (/ &
        & 0.10187e-02,0.10963e-02,0.12532e-02,0.13909e-02,0.14993e-02, &
        & 0.15953e-02,0.16843e-02,0.17040e-02,0.16991e-02 /)
      kao(:, 3, 5,12) = (/ &
        & 0.10179e-02,0.10925e-02,0.12502e-02,0.13858e-02,0.14932e-02, &
        & 0.15900e-02,0.16803e-02,0.17019e-02,0.16952e-02 /)
      kao(:, 4, 5,12) = (/ &
        & 0.10188e-02,0.10896e-02,0.12461e-02,0.13806e-02,0.14878e-02, &
        & 0.15873e-02,0.16767e-02,0.17001e-02,0.16925e-02 /)
      kao(:, 5, 5,12) = (/ &
        & 0.10211e-02,0.10901e-02,0.12464e-02,0.13834e-02,0.14970e-02, &
        & 0.16026e-02,0.16952e-02,0.17210e-02,0.17180e-02 /)
      kao(:, 1, 6,12) = (/ &
        & 0.88455e-03,0.10185e-02,0.12021e-02,0.13605e-02,0.14894e-02, &
        & 0.15922e-02,0.16870e-02,0.17277e-02,0.17006e-02 /)
      kao(:, 2, 6,12) = (/ &
        & 0.88487e-03,0.10158e-02,0.12001e-02,0.13587e-02,0.14854e-02, &
        & 0.15856e-02,0.16819e-02,0.17253e-02,0.17001e-02 /)
      kao(:, 3, 6,12) = (/ &
        & 0.88512e-03,0.10136e-02,0.11981e-02,0.13544e-02,0.14820e-02, &
        & 0.15811e-02,0.16785e-02,0.17233e-02,0.16989e-02 /)
      kao(:, 4, 6,12) = (/ &
        & 0.88698e-03,0.10127e-02,0.11948e-02,0.13505e-02,0.14784e-02, &
        & 0.15789e-02,0.16749e-02,0.17211e-02,0.16988e-02 /)
      kao(:, 5, 6,12) = (/ &
        & 0.88923e-03,0.10128e-02,0.11919e-02,0.13468e-02,0.14756e-02, &
        & 0.15764e-02,0.16734e-02,0.17190e-02,0.16990e-02 /)
      kao(:, 1, 7,12) = (/ &
        & 0.75937e-03,0.93876e-03,0.11443e-02,0.13228e-02,0.14681e-02, &
        & 0.15807e-02,0.16771e-02,0.17403e-02,0.16920e-02 /)
      kao(:, 2, 7,12) = (/ &
        & 0.75998e-03,0.93770e-03,0.11447e-02,0.13222e-02,0.14656e-02, &
        & 0.15751e-02,0.16722e-02,0.17374e-02,0.16943e-02 /)
      kao(:, 3, 7,12) = (/ &
        & 0.76057e-03,0.93698e-03,0.11442e-02,0.13192e-02,0.14630e-02, &
        & 0.15711e-02,0.16684e-02,0.17351e-02,0.16966e-02 /)
      kao(:, 4, 7,12) = (/ &
        & 0.76306e-03,0.93700e-03,0.11417e-02,0.13175e-02,0.14605e-02, &
        & 0.15679e-02,0.16649e-02,0.17327e-02,0.16998e-02 /)
      kao(:, 5, 7,12) = (/ &
        & 0.76563e-03,0.93740e-03,0.11401e-02,0.13155e-02,0.14583e-02, &
        & 0.15655e-02,0.16637e-02,0.17306e-02,0.17045e-02 /)
      kao(:, 1, 8,12) = (/ &
        & 0.64586e-03,0.86421e-03,0.10884e-02,0.12806e-02,0.14383e-02, &
        & 0.15636e-02,0.16605e-02,0.17434e-02,0.16711e-02 /)
      kao(:, 2, 8,12) = (/ &
        & 0.64665e-03,0.86473e-03,0.10896e-02,0.12820e-02,0.14363e-02, &
        & 0.15592e-02,0.16561e-02,0.17403e-02,0.16771e-02 /)
      kao(:, 3, 8,12) = (/ &
        & 0.64816e-03,0.86506e-03,0.10903e-02,0.12802e-02,0.14357e-02, &
        & 0.15554e-02,0.16529e-02,0.17367e-02,0.16846e-02 /)
      kao(:, 4, 8,12) = (/ &
        & 0.65115e-03,0.86561e-03,0.10893e-02,0.12797e-02,0.14336e-02, &
        & 0.15533e-02,0.16505e-02,0.17349e-02,0.16920e-02 /)
      kao(:, 5, 8,12) = (/ &
        & 0.65335e-03,0.86692e-03,0.10897e-02,0.12788e-02,0.14323e-02, &
        & 0.15519e-02,0.16494e-02,0.17328e-02,0.17005e-02 /)
      kao(:, 1, 9,12) = (/ &
        & 0.54495e-03,0.79374e-03,0.10331e-02,0.12325e-02,0.13999e-02, &
        & 0.15343e-02,0.16359e-02,0.17304e-02,0.88289e-03 /)
      kao(:, 2, 9,12) = (/ &
        & 0.54631e-03,0.79621e-03,0.10351e-02,0.12356e-02,0.13999e-02, &
        & 0.15332e-02,0.16343e-02,0.17287e-02,0.90009e-03 /)
      kao(:, 3, 9,12) = (/ &
        & 0.54838e-03,0.79738e-03,0.10366e-02,0.12358e-02,0.14008e-02, &
        & 0.15312e-02,0.16325e-02,0.17267e-02,0.91715e-03 /)
      kao(:, 4, 9,12) = (/ &
        & 0.55103e-03,0.79925e-03,0.10373e-02,0.12370e-02,0.14003e-02, &
        & 0.15313e-02,0.16317e-02,0.17265e-02,0.93948e-03 /)
      kao(:, 5, 9,12) = (/ &
        & 0.55358e-03,0.80158e-03,0.10391e-02,0.12370e-02,0.14008e-02, &
        & 0.15320e-02,0.16328e-02,0.17271e-02,0.97099e-03 /)
      kao(:, 1,10,12) = (/ &
        & 0.45828e-03,0.73128e-03,0.97725e-03,0.11801e-02,0.13541e-02, &
        & 0.14966e-02,0.16059e-02,0.17081e-02,0.25261e-04 /)
      kao(:, 2,10,12) = (/ &
        & 0.45994e-03,0.73433e-03,0.98047e-03,0.11852e-02,0.13571e-02, &
        & 0.14993e-02,0.16071e-02,0.17093e-02,0.32778e-04 /)
      kao(:, 3,10,12) = (/ &
        & 0.46172e-03,0.73698e-03,0.98332e-03,0.11877e-02,0.13607e-02, &
        & 0.15001e-02,0.16089e-02,0.17098e-02,0.30108e-04 /)
      kao(:, 4,10,12) = (/ &
        & 0.46419e-03,0.73967e-03,0.98568e-03,0.11903e-02,0.13620e-02, &
        & 0.15042e-02,0.16117e-02,0.17131e-02,0.14814e-04 /)
      kao(:, 5,10,12) = (/ &
        & 0.46710e-03,0.74287e-03,0.98852e-03,0.11927e-02,0.13653e-02, &
        & 0.15080e-02,0.16153e-02,0.17174e-02,0.18206e-04 /)
      kao(:, 1,11,12) = (/ &
        & 0.38711e-03,0.67660e-03,0.92352e-03,0.11285e-02,0.13042e-02, &
        & 0.14533e-02,0.15680e-02,0.16768e-02,0.35375e-04 /)
      kao(:, 2,11,12) = (/ &
        & 0.38827e-03,0.68076e-03,0.92811e-03,0.11355e-02,0.13110e-02, &
        & 0.14578e-02,0.15732e-02,0.16802e-02,0.17785e-04 /)
      kao(:, 3,11,12) = (/ &
        & 0.39017e-03,0.68339e-03,0.93243e-03,0.11404e-02,0.13179e-02, &
        & 0.14648e-02,0.15809e-02,0.16870e-02,0.17310e-04 /)
      kao(:, 4,11,12) = (/ &
        & 0.39259e-03,0.68706e-03,0.93609e-03,0.11451e-02,0.13243e-02, &
        & 0.14746e-02,0.15892e-02,0.16958e-02,0.17795e-04 /)
      kao(:, 5,11,12) = (/ &
        & 0.39544e-03,0.69011e-03,0.94016e-03,0.11496e-02,0.13318e-02, &
        & 0.14825e-02,0.15980e-02,0.17052e-02,0.87581e-05 /)
      kao(:, 1,12,12) = (/ &
        & 0.32882e-03,0.62658e-03,0.87124e-03,0.10770e-02,0.12526e-02, &
        & 0.14042e-02,0.15246e-02,0.16367e-02,0.13823e-04 /)
      kao(:, 2,12,12) = (/ &
        & 0.33008e-03,0.63068e-03,0.87790e-03,0.10857e-02,0.12638e-02, &
        & 0.14155e-02,0.15376e-02,0.16473e-02,0.27356e-04 /)
      kao(:, 3,12,12) = (/ &
        & 0.33191e-03,0.63479e-03,0.88401e-03,0.10939e-02,0.12749e-02, &
        & 0.14298e-02,0.15521e-02,0.16615e-02,0.26924e-04 /)
      kao(:, 4,12,12) = (/ &
        & 0.33384e-03,0.63914e-03,0.88945e-03,0.11023e-02,0.12871e-02, &
        & 0.14439e-02,0.15651e-02,0.16755e-02,0.13486e-04 /)
      kao(:, 5,12,12) = (/ &
        & 0.33630e-03,0.64288e-03,0.89554e-03,0.11106e-02,0.12985e-02, &
        & 0.14567e-02,0.15792e-02,0.16910e-02,0.54470e-04 /)
      kao(:, 1,13,12) = (/ &
        & 0.28179e-03,0.58039e-03,0.82131e-03,0.10258e-02,0.12001e-02, &
        & 0.13522e-02,0.14762e-02,0.15892e-02,0.17365e-04 /)
      kao(:, 2,13,12) = (/ &
        & 0.28322e-03,0.58517e-03,0.83048e-03,0.10376e-02,0.12180e-02, &
        & 0.13721e-02,0.14980e-02,0.16092e-02,0.19167e-10 /)
      kao(:, 3,13,12) = (/ &
        & 0.28449e-03,0.59004e-03,0.83867e-03,0.10495e-02,0.12349e-02, &
        & 0.13937e-02,0.15189e-02,0.16302e-02,0.17686e-04 /)
      kao(:, 4,13,12) = (/ &
        & 0.28623e-03,0.59506e-03,0.84661e-03,0.10616e-02,0.12511e-02, &
        & 0.14124e-02,0.15380e-02,0.16505e-02,0.27174e-10 /)
      kao(:, 5,13,12) = (/ &
        & 0.28834e-03,0.60000e-03,0.85510e-03,0.10735e-02,0.12664e-02, &
        & 0.14298e-02,0.15583e-02,0.16724e-02,0.30930e-10 /)
      kao(:, 1, 1,13) = (/ &
        & 0.39229e-02,0.34326e-02,0.30162e-02,0.28699e-02,0.28381e-02, &
        & 0.27734e-02,0.26260e-02,0.23062e-02,0.25522e-02 /)
      kao(:, 2, 1,13) = (/ &
        & 0.39213e-02,0.34310e-02,0.30108e-02,0.28565e-02,0.28216e-02, &
        & 0.27552e-02,0.26075e-02,0.22956e-02,0.25296e-02 /)
      kao(:, 3, 1,13) = (/ &
        & 0.39180e-02,0.34283e-02,0.30095e-02,0.28490e-02,0.28140e-02, &
        & 0.27516e-02,0.26057e-02,0.23031e-02,0.25320e-02 /)
      kao(:, 4, 1,13) = (/ &
        & 0.39161e-02,0.34265e-02,0.30039e-02,0.28320e-02,0.27864e-02, &
        & 0.27263e-02,0.25779e-02,0.22767e-02,0.24834e-02 /)
      kao(:, 5, 1,13) = (/ &
        & 0.39129e-02,0.34239e-02,0.29985e-02,0.28202e-02,0.27725e-02, &
        & 0.27107e-02,0.25647e-02,0.22654e-02,0.24632e-02 /)
      kao(:, 1, 2,13) = (/ &
        & 0.35717e-02,0.31250e-02,0.28583e-02,0.28716e-02,0.28885e-02, &
        & 0.28569e-02,0.27419e-02,0.24528e-02,0.26589e-02 /)
      kao(:, 2, 2,13) = (/ &
        & 0.35704e-02,0.31241e-02,0.28509e-02,0.28521e-02,0.28717e-02, &
        & 0.28411e-02,0.27277e-02,0.24440e-02,0.26352e-02 /)
      kao(:, 3, 2,13) = (/ &
        & 0.35692e-02,0.31228e-02,0.28479e-02,0.28438e-02,0.28636e-02, &
        & 0.28419e-02,0.27327e-02,0.24542e-02,0.26382e-02 /)
      kao(:, 4, 2,13) = (/ &
        & 0.35651e-02,0.31194e-02,0.28382e-02,0.28288e-02,0.28472e-02, &
        & 0.28288e-02,0.27211e-02,0.24428e-02,0.26140e-02 /)
      kao(:, 5, 2,13) = (/ &
        & 0.35614e-02,0.31162e-02,0.28280e-02,0.28080e-02,0.28270e-02, &
        & 0.28018e-02,0.26919e-02,0.24122e-02,0.25721e-02 /)
      kao(:, 1, 3,13) = (/ &
        & 0.32370e-02,0.28408e-02,0.27429e-02,0.28459e-02,0.29107e-02, &
        & 0.29163e-02,0.28452e-02,0.26013e-02,0.27589e-02 /)
      kao(:, 2, 3,13) = (/ &
        & 0.32378e-02,0.28409e-02,0.27346e-02,0.28282e-02,0.28967e-02, &
        & 0.29036e-02,0.28357e-02,0.25912e-02,0.27381e-02 /)
      kao(:, 3, 3,13) = (/ &
        & 0.32344e-02,0.28366e-02,0.27224e-02,0.28159e-02,0.28824e-02, &
        & 0.28940e-02,0.28268e-02,0.25801e-02,0.27164e-02 /)
      kao(:, 4, 3,13) = (/ &
        & 0.32328e-02,0.28349e-02,0.27139e-02,0.28071e-02,0.28820e-02, &
        & 0.28985e-02,0.28328e-02,0.25870e-02,0.27280e-02 /)
      kao(:, 5, 3,13) = (/ &
        & 0.32337e-02,0.28348e-02,0.27027e-02,0.27877e-02,0.28613e-02, &
        & 0.28723e-02,0.28004e-02,0.25498e-02,0.26848e-02 /)
      kao(:, 1, 4,13) = (/ &
        & 0.29442e-02,0.26158e-02,0.26686e-02,0.28002e-02,0.29074e-02, &
        & 0.29569e-02,0.29354e-02,0.27381e-02,0.28491e-02 /)
      kao(:, 2, 4,13) = (/ &
        & 0.29416e-02,0.26110e-02,0.26570e-02,0.27866e-02,0.28959e-02, &
        & 0.29477e-02,0.29295e-02,0.27262e-02,0.28287e-02 /)
      kao(:, 3, 4,13) = (/ &
        & 0.29392e-02,0.26064e-02,0.26421e-02,0.27765e-02,0.28845e-02, &
        & 0.29406e-02,0.29202e-02,0.27107e-02,0.28099e-02 /)
      kao(:, 4, 4,13) = (/ &
        & 0.29406e-02,0.26055e-02,0.26309e-02,0.27645e-02,0.28769e-02, &
        & 0.29312e-02,0.29057e-02,0.26928e-02,0.27972e-02 /)
      kao(:, 5, 4,13) = (/ &
        & 0.29379e-02,0.26016e-02,0.26230e-02,0.27605e-02,0.28772e-02, &
        & 0.29338e-02,0.29114e-02,0.26956e-02,0.28225e-02 /)
      kao(:, 1, 5,13) = (/ &
        & 0.26861e-02,0.24510e-02,0.26014e-02,0.27478e-02,0.28811e-02, &
        & 0.29878e-02,0.30091e-02,0.28610e-02,0.29320e-02 /)
      kao(:, 2, 5,13) = (/ &
        & 0.26822e-02,0.24426e-02,0.25898e-02,0.27369e-02,0.28725e-02, &
        & 0.29815e-02,0.30039e-02,0.28485e-02,0.29157e-02 /)
      kao(:, 3, 5,13) = (/ &
        & 0.26829e-02,0.24377e-02,0.25766e-02,0.27289e-02,0.28648e-02, &
        & 0.29741e-02,0.29940e-02,0.28292e-02,0.29014e-02 /)
      kao(:, 4, 5,13) = (/ &
        & 0.26816e-02,0.24329e-02,0.25674e-02,0.27192e-02,0.28602e-02, &
        & 0.29643e-02,0.29808e-02,0.28105e-02,0.28911e-02 /)
      kao(:, 5, 5,13) = (/ &
        & 0.26776e-02,0.24242e-02,0.25584e-02,0.27174e-02,0.28631e-02, &
        & 0.29690e-02,0.29916e-02,0.28176e-02,0.29253e-02 /)
      kao(:, 1, 6,13) = (/ &
        & 0.24590e-02,0.23376e-02,0.25355e-02,0.26945e-02,0.28553e-02, &
        & 0.29996e-02,0.30574e-02,0.29544e-02,0.30033e-02 /)
      kao(:, 2, 6,13) = (/ &
        & 0.24565e-02,0.23281e-02,0.25242e-02,0.26862e-02,0.28495e-02, &
        & 0.29966e-02,0.30559e-02,0.29459e-02,0.29901e-02 /)
      kao(:, 3, 6,13) = (/ &
        & 0.24594e-02,0.23224e-02,0.25135e-02,0.26796e-02,0.28441e-02, &
        & 0.29914e-02,0.30494e-02,0.29315e-02,0.29796e-02 /)
      kao(:, 4, 6,13) = (/ &
        & 0.24561e-02,0.23120e-02,0.25070e-02,0.26723e-02,0.28398e-02, &
        & 0.29830e-02,0.30431e-02,0.29165e-02,0.29718e-02 /)
      kao(:, 5, 6,13) = (/ &
        & 0.24544e-02,0.23009e-02,0.24971e-02,0.26678e-02,0.28335e-02, &
        & 0.29758e-02,0.30342e-02,0.29019e-02,0.29654e-02 /)
      kao(:, 1, 7,13) = (/ &
        & 0.22277e-02,0.22296e-02,0.24669e-02,0.26497e-02,0.28285e-02, &
        & 0.29885e-02,0.30855e-02,0.30292e-02,0.30616e-02 /)
      kao(:, 2, 7,13) = (/ &
        & 0.22293e-02,0.22219e-02,0.24569e-02,0.26437e-02,0.28247e-02, &
        & 0.29924e-02,0.30879e-02,0.30266e-02,0.30510e-02 /)
      kao(:, 3, 7,13) = (/ &
        & 0.22351e-02,0.22176e-02,0.24495e-02,0.26382e-02,0.28222e-02, &
        & 0.29913e-02,0.30877e-02,0.30175e-02,0.30415e-02 /)
      kao(:, 4, 7,13) = (/ &
        & 0.22344e-02,0.22079e-02,0.24453e-02,0.26324e-02,0.28192e-02, &
        & 0.29887e-02,0.30862e-02,0.30074e-02,0.30342e-02 /)
      kao(:, 5, 7,13) = (/ &
        & 0.22361e-02,0.21982e-02,0.24378e-02,0.26291e-02,0.28143e-02, &
        & 0.29850e-02,0.30822e-02,0.29969e-02,0.30270e-02 /)
      kao(:, 1, 8,13) = (/ &
        & 0.19878e-02,0.21080e-02,0.23886e-02,0.26087e-02,0.27952e-02, &
        & 0.29676e-02,0.31003e-02,0.30904e-02,0.31018e-02 /)
      kao(:, 2, 8,13) = (/ &
        & 0.19936e-02,0.21034e-02,0.23825e-02,0.26049e-02,0.27978e-02, &
        & 0.29755e-02,0.31107e-02,0.30954e-02,0.30940e-02 /)
      kao(:, 3, 8,13) = (/ &
        & 0.20012e-02,0.21016e-02,0.23778e-02,0.26010e-02,0.27982e-02, &
        & 0.29815e-02,0.31166e-02,0.30929e-02,0.30865e-02 /)
      kao(:, 4, 8,13) = (/ &
        & 0.20034e-02,0.20960e-02,0.23764e-02,0.25979e-02,0.27992e-02, &
        & 0.29823e-02,0.31192e-02,0.30868e-02,0.30812e-02 /)
      kao(:, 5, 8,13) = (/ &
        & 0.20095e-02,0.20891e-02,0.23711e-02,0.25960e-02,0.27964e-02, &
        & 0.29828e-02,0.31181e-02,0.30806e-02,0.30733e-02 /)
      kao(:, 1, 9,13) = (/ &
        & 0.17523e-02,0.19789e-02,0.23024e-02,0.25572e-02,0.27629e-02, &
        & 0.29479e-02,0.31085e-02,0.31444e-02,0.30417e-02 /)
      kao(:, 2, 9,13) = (/ &
        & 0.17607e-02,0.19777e-02,0.23013e-02,0.25587e-02,0.27691e-02, &
        & 0.29613e-02,0.31227e-02,0.31535e-02,0.30346e-02 /)
      kao(:, 3, 9,13) = (/ &
        & 0.17693e-02,0.19800e-02,0.23011e-02,0.25605e-02,0.27739e-02, &
        & 0.29714e-02,0.31329e-02,0.31549e-02,0.30299e-02 /)
      kao(:, 4, 9,13) = (/ &
        & 0.17751e-02,0.19773e-02,0.23025e-02,0.25606e-02,0.27770e-02, &
        & 0.29770e-02,0.31405e-02,0.31532e-02,0.30280e-02 /)
      kao(:, 5, 9,13) = (/ &
        & 0.17845e-02,0.19738e-02,0.23006e-02,0.25633e-02,0.27766e-02, &
        & 0.29802e-02,0.31452e-02,0.31517e-02,0.30317e-02 /)
      kao(:, 1,10,13) = (/ &
        & 0.15244e-02,0.18437e-02,0.22100e-02,0.24972e-02,0.27331e-02, &
        & 0.29304e-02,0.31059e-02,0.31844e-02,0.23817e-04 /)
      kao(:, 2,10,13) = (/ &
        & 0.15360e-02,0.18467e-02,0.22145e-02,0.25068e-02,0.27437e-02, &
        & 0.29473e-02,0.31260e-02,0.31986e-02,0.12454e-04 /)
      kao(:, 3,10,13) = (/ &
        & 0.15476e-02,0.18512e-02,0.22181e-02,0.25119e-02,0.27538e-02, &
        & 0.29593e-02,0.31389e-02,0.32042e-02,0.30814e-04 /)
      kao(:, 4,10,13) = (/ &
        & 0.15571e-02,0.18528e-02,0.22235e-02,0.25174e-02,0.27591e-02, &
        & 0.29666e-02,0.31497e-02,0.32063e-02,0.11698e-04 /)
      kao(:, 5,10,13) = (/ &
        & 0.15695e-02,0.18534e-02,0.22262e-02,0.25236e-02,0.27611e-02, &
        & 0.29733e-02,0.31600e-02,0.32093e-02,0.22330e-04 /)
      kao(:, 1,11,13) = (/ &
        & 0.13188e-02,0.17123e-02,0.21150e-02,0.24398e-02,0.27060e-02, &
        & 0.29190e-02,0.31061e-02,0.32197e-02,0.11689e-04 /)
      kao(:, 2,11,13) = (/ &
        & 0.13341e-02,0.17189e-02,0.21240e-02,0.24532e-02,0.27222e-02, &
        & 0.29371e-02,0.31262e-02,0.32338e-02,0.11845e-04 /)
      kao(:, 3,11,13) = (/ &
        & 0.13447e-02,0.17274e-02,0.21339e-02,0.24651e-02,0.27343e-02, &
        & 0.29498e-02,0.31430e-02,0.32440e-02,0.24255e-04 /)
      kao(:, 4,11,13) = (/ &
        & 0.13578e-02,0.17324e-02,0.21454e-02,0.24765e-02,0.27400e-02, &
        & 0.29585e-02,0.31579e-02,0.32502e-02,0.35648e-04 /)
      kao(:, 5,11,13) = (/ &
        & 0.13715e-02,0.17394e-02,0.21518e-02,0.24842e-02,0.27436e-02, &
        & 0.29689e-02,0.31719e-02,0.32570e-02,0.48216e-04 /)
      kao(:, 1,12,13) = (/ &
        & 0.11367e-02,0.15942e-02,0.20255e-02,0.23827e-02,0.26757e-02, &
        & 0.29001e-02,0.30944e-02,0.32386e-02,0.48616e-12 /)
      kao(:, 2,12,13) = (/ &
        & 0.11495e-02,0.16057e-02,0.20405e-02,0.24019e-02,0.26965e-02, &
        & 0.29177e-02,0.31160e-02,0.32553e-02,0.63803e-12 /)
      kao(:, 3,12,13) = (/ &
        & 0.11626e-02,0.16147e-02,0.20558e-02,0.24193e-02,0.27102e-02, &
        & 0.29330e-02,0.31363e-02,0.32673e-02,0.18451e-04 /)
      kao(:, 4,12,13) = (/ &
        & 0.11784e-02,0.16224e-02,0.20681e-02,0.24334e-02,0.27187e-02, &
        & 0.29473e-02,0.31560e-02,0.32789e-02,0.93725e-12 /)
      kao(:, 5,12,13) = (/ &
        & 0.11935e-02,0.16327e-02,0.20790e-02,0.24438e-02,0.27275e-02, &
        & 0.29614e-02,0.31756e-02,0.32901e-02,0.36773e-04 /)
      kao(:, 1,13,13) = (/ &
        & 0.97386e-03,0.14865e-02,0.19422e-02,0.23265e-02,0.26377e-02, &
        & 0.28742e-02,0.30758e-02,0.32440e-02,0.42838e-12 /)
      kao(:, 2,13,13) = (/ &
        & 0.98704e-03,0.15018e-02,0.19617e-02,0.23518e-02,0.26608e-02, &
        & 0.28955e-02,0.31025e-02,0.32660e-02,0.54956e-12 /)
      kao(:, 3,13,13) = (/ &
        & 0.10034e-02,0.15127e-02,0.19822e-02,0.23722e-02,0.26791e-02, &
        & 0.29131e-02,0.31272e-02,0.32827e-02,0.68281e-12 /)
      kao(:, 4,13,13) = (/ &
        & 0.10185e-02,0.15248e-02,0.19990e-02,0.23896e-02,0.26942e-02, &
        & 0.29331e-02,0.31525e-02,0.33003e-02,0.47348e-04 /)
      kao(:, 5,13,13) = (/ &
        & 0.10353e-02,0.15370e-02,0.20122e-02,0.24032e-02,0.27096e-02, &
        & 0.29526e-02,0.31774e-02,0.33154e-02,0.94094e-12 /)
      kao(:, 1, 1,14) = (/ &
        & 0.11127e-01,0.97365e-02,0.83450e-02,0.69546e-02,0.57518e-02, &
        & 0.48972e-02,0.42517e-02,0.34771e-02,0.44616e-02 /)
      kao(:, 2, 1,14) = (/ &
        & 0.11168e-01,0.97719e-02,0.83762e-02,0.69801e-02,0.57613e-02, &
        & 0.48914e-02,0.42324e-02,0.34356e-02,0.44183e-02 /)
      kao(:, 3, 1,14) = (/ &
        & 0.11206e-01,0.98061e-02,0.84051e-02,0.70040e-02,0.57786e-02, &
        & 0.48973e-02,0.42300e-02,0.34167e-02,0.44088e-02 /)
      kao(:, 4, 1,14) = (/ &
        & 0.11230e-01,0.98265e-02,0.84228e-02,0.70190e-02,0.57794e-02, &
        & 0.48702e-02,0.41927e-02,0.33658e-02,0.43365e-02 /)
      kao(:, 5, 1,14) = (/ &
        & 0.11247e-01,0.98411e-02,0.84348e-02,0.70292e-02,0.57800e-02, &
        & 0.48600e-02,0.41735e-02,0.33367e-02,0.43003e-02 /)
      kao(:, 1, 2,14) = (/ &
        & 0.11360e-01,0.99403e-02,0.85204e-02,0.71449e-02,0.60754e-02, &
        & 0.53678e-02,0.47333e-02,0.38804e-02,0.48459e-02 /)
      kao(:, 2, 2,14) = (/ &
        & 0.11402e-01,0.99768e-02,0.85517e-02,0.71687e-02,0.60816e-02, &
        & 0.53522e-02,0.47062e-02,0.38343e-02,0.48034e-02 /)
      kao(:, 3, 2,14) = (/ &
        & 0.11432e-01,0.10003e-01,0.85744e-02,0.71872e-02,0.60934e-02, &
        & 0.53498e-02,0.46968e-02,0.38177e-02,0.48004e-02 /)
      kao(:, 4, 2,14) = (/ &
        & 0.11460e-01,0.10028e-01,0.85956e-02,0.72000e-02,0.60909e-02, &
        & 0.53282e-02,0.46686e-02,0.37852e-02,0.47598e-02 /)
      kao(:, 5, 2,14) = (/ &
        & 0.11484e-01,0.10049e-01,0.86132e-02,0.72108e-02,0.60794e-02, &
        & 0.52951e-02,0.46284e-02,0.37347e-02,0.46895e-02 /)
      kao(:, 1, 3,14) = (/ &
        & 0.11375e-01,0.99535e-02,0.85318e-02,0.72748e-02,0.63965e-02, &
        & 0.58374e-02,0.52215e-02,0.43002e-02,0.52258e-02 /)
      kao(:, 2, 3,14) = (/ &
        & 0.11412e-01,0.99855e-02,0.85592e-02,0.72909e-02,0.63926e-02, &
        & 0.58142e-02,0.51838e-02,0.42530e-02,0.51857e-02 /)
      kao(:, 3, 3,14) = (/ &
        & 0.11451e-01,0.10019e-01,0.85873e-02,0.73027e-02,0.63856e-02, &
        & 0.57886e-02,0.51485e-02,0.42153e-02,0.51479e-02 /)
      kao(:, 4, 3,14) = (/ &
        & 0.11483e-01,0.10047e-01,0.86122e-02,0.73190e-02,0.63840e-02, &
        & 0.57742e-02,0.51342e-02,0.42027e-02,0.51482e-02 /)
      kao(:, 5, 3,14) = (/ &
        & 0.11512e-01,0.10073e-01,0.86339e-02,0.73301e-02,0.63706e-02, &
        & 0.57344e-02,0.50899e-02,0.41496e-02,0.50782e-02 /)
      kao(:, 1, 4,14) = (/ &
        & 0.11149e-01,0.97560e-02,0.83906e-02,0.73568e-02,0.67050e-02, &
        & 0.62789e-02,0.56809e-02,0.47244e-02,0.55742e-02 /)
      kao(:, 2, 4,14) = (/ &
        & 0.11201e-01,0.98016e-02,0.84237e-02,0.73684e-02,0.66927e-02, &
        & 0.62506e-02,0.56398e-02,0.46775e-02,0.55381e-02 /)
      kao(:, 3, 4,14) = (/ &
        & 0.11250e-01,0.98437e-02,0.84576e-02,0.73794e-02,0.66793e-02, &
        & 0.62192e-02,0.56018e-02,0.46402e-02,0.55028e-02 /)
      kao(:, 4, 4,14) = (/ &
        & 0.11293e-01,0.98814e-02,0.84883e-02,0.73928e-02,0.66658e-02, &
        & 0.61879e-02,0.55699e-02,0.46073e-02,0.54669e-02 /)
      kao(:, 5, 4,14) = (/ &
        & 0.11341e-01,0.99237e-02,0.85206e-02,0.74085e-02,0.66636e-02, &
        & 0.61710e-02,0.55548e-02,0.45934e-02,0.54646e-02 /)
      kao(:, 1, 5,14) = (/ &
        & 0.10704e-01,0.93660e-02,0.81568e-02,0.74021e-02,0.69945e-02, &
        & 0.66654e-02,0.61172e-02,0.51470e-02,0.58967e-02 /)
      kao(:, 2, 5,14) = (/ &
        & 0.10771e-01,0.94250e-02,0.81953e-02,0.74101e-02,0.69769e-02, &
        & 0.66347e-02,0.60743e-02,0.50992e-02,0.58616e-02 /)
      kao(:, 3, 5,14) = (/ &
        & 0.10834e-01,0.94795e-02,0.82348e-02,0.74202e-02,0.69586e-02, &
        & 0.66047e-02,0.60376e-02,0.50623e-02,0.58279e-02 /)
      kao(:, 4, 5,14) = (/ &
        & 0.10899e-01,0.95365e-02,0.82726e-02,0.74343e-02,0.69400e-02, &
        & 0.65760e-02,0.60076e-02,0.50289e-02,0.57953e-02 /)
      kao(:, 5, 5,14) = (/ &
        & 0.10965e-01,0.95941e-02,0.83123e-02,0.74464e-02,0.69292e-02, &
        & 0.65626e-02,0.59940e-02,0.50178e-02,0.57938e-02 /)
      kao(:, 1, 6,14) = (/ &
        & 0.10078e-01,0.88178e-02,0.78666e-02,0.74112e-02,0.72308e-02, &
        & 0.70100e-02,0.65312e-02,0.55779e-02,0.62140e-02 /)
      kao(:, 2, 6,14) = (/ &
        & 0.10161e-01,0.88906e-02,0.79113e-02,0.74185e-02,0.72160e-02, &
        & 0.69843e-02,0.64888e-02,0.55247e-02,0.61818e-02 /)
      kao(:, 3, 6,14) = (/ &
        & 0.10243e-01,0.89616e-02,0.79583e-02,0.74318e-02,0.71999e-02, &
        & 0.69579e-02,0.64523e-02,0.54833e-02,0.61492e-02 /)
      kao(:, 4, 6,14) = (/ &
        & 0.10327e-01,0.90374e-02,0.79989e-02,0.74443e-02,0.71832e-02, &
        & 0.69350e-02,0.64210e-02,0.54479e-02,0.61172e-02 /)
      kao(:, 5, 6,14) = (/ &
        & 0.10409e-01,0.91075e-02,0.80421e-02,0.74489e-02,0.71645e-02, &
        & 0.69118e-02,0.63952e-02,0.54129e-02,0.60849e-02 /)
      kao(:, 1, 7,14) = (/ &
        & 0.93799e-02,0.82246e-02,0.75645e-02,0.73983e-02,0.74124e-02, &
        & 0.73054e-02,0.69103e-02,0.59986e-02,0.65205e-02 /)
      kao(:, 2, 7,14) = (/ &
        & 0.94746e-02,0.83048e-02,0.76105e-02,0.74041e-02,0.74008e-02, &
        & 0.72835e-02,0.68745e-02,0.59435e-02,0.64911e-02 /)
      kao(:, 3, 7,14) = (/ &
        & 0.95665e-02,0.83814e-02,0.76560e-02,0.74150e-02,0.73885e-02, &
        & 0.72645e-02,0.68399e-02,0.59000e-02,0.64612e-02 /)
      kao(:, 4, 7,14) = (/ &
        & 0.96610e-02,0.84615e-02,0.76953e-02,0.74218e-02,0.73786e-02, &
        & 0.72467e-02,0.68110e-02,0.58618e-02,0.64309e-02 /)
      kao(:, 5, 7,14) = (/ &
        & 0.97576e-02,0.85445e-02,0.77428e-02,0.74271e-02,0.73666e-02, &
        & 0.72295e-02,0.67856e-02,0.58248e-02,0.64018e-02 /)
      kao(:, 1, 8,14) = (/ &
        & 0.86695e-02,0.76539e-02,0.72832e-02,0.73811e-02,0.75539e-02, &
        & 0.75395e-02,0.72391e-02,0.63979e-02,0.68067e-02 /)
      kao(:, 2, 8,14) = (/ &
        & 0.87714e-02,0.77350e-02,0.73260e-02,0.73889e-02,0.75481e-02, &
        & 0.75307e-02,0.72059e-02,0.63386e-02,0.67797e-02 /)
      kao(:, 3, 8,14) = (/ &
        & 0.88648e-02,0.78065e-02,0.73635e-02,0.73928e-02,0.75428e-02, &
        & 0.75176e-02,0.71786e-02,0.62948e-02,0.67512e-02 /)
      kao(:, 4, 8,14) = (/ &
        & 0.89696e-02,0.78903e-02,0.74008e-02,0.73947e-02,0.75364e-02, &
        & 0.75091e-02,0.71562e-02,0.62573e-02,0.67249e-02 /)
      kao(:, 5, 8,14) = (/ &
        & 0.90827e-02,0.79827e-02,0.74524e-02,0.74004e-02,0.75307e-02, &
        & 0.75004e-02,0.71406e-02,0.62196e-02,0.66995e-02 /)
      kao(:, 1, 9,14) = (/ &
        & 0.79522e-02,0.71197e-02,0.70358e-02,0.73522e-02,0.76328e-02, &
        & 0.77097e-02,0.75175e-02,0.67703e-02,0.70524e-02 /)
      kao(:, 2, 9,14) = (/ &
        & 0.80598e-02,0.71969e-02,0.70715e-02,0.73653e-02,0.76374e-02, &
        & 0.77113e-02,0.74908e-02,0.67151e-02,0.70338e-02 /)
      kao(:, 3, 9,14) = (/ &
        & 0.81632e-02,0.72678e-02,0.71027e-02,0.73712e-02,0.76458e-02, &
        & 0.77123e-02,0.74742e-02,0.66728e-02,0.70182e-02 /)
      kao(:, 4, 9,14) = (/ &
        & 0.82823e-02,0.73561e-02,0.71392e-02,0.73768e-02,0.76576e-02, &
        & 0.77143e-02,0.74622e-02,0.66357e-02,0.69991e-02 /)
      kao(:, 5, 9,14) = (/ &
        & 0.84105e-02,0.74558e-02,0.71910e-02,0.73874e-02,0.76648e-02, &
        & 0.77180e-02,0.74509e-02,0.65977e-02,0.69736e-02 /)
      kao(:, 1,10,14) = (/ &
        & 0.72630e-02,0.66377e-02,0.68373e-02,0.72984e-02,0.76509e-02, &
        & 0.78294e-02,0.77460e-02,0.71207e-02,0.20344e-04 /)
      kao(:, 2,10,14) = (/ &
        & 0.73671e-02,0.67055e-02,0.68587e-02,0.73198e-02,0.76710e-02, &
        & 0.78437e-02,0.77323e-02,0.70655e-02,0.20564e-04 /)
      kao(:, 3,10,14) = (/ &
        & 0.74810e-02,0.67793e-02,0.68858e-02,0.73353e-02,0.76947e-02, &
        & 0.78590e-02,0.77307e-02,0.70272e-02,0.37563e-05 /)
      kao(:, 4,10,14) = (/ &
        & 0.76171e-02,0.68754e-02,0.69230e-02,0.73502e-02,0.77241e-02, &
        & 0.78765e-02,0.77271e-02,0.69915e-02,0.47236e-05 /)
      kao(:, 5,10,14) = (/ &
        & 0.77608e-02,0.69811e-02,0.69732e-02,0.73676e-02,0.77455e-02, &
        & 0.78941e-02,0.77236e-02,0.69531e-02,0.26047e-04 /)
      kao(:, 1,11,14) = (/ &
        & 0.66493e-02,0.62366e-02,0.66807e-02,0.72344e-02,0.76404e-02, &
        & 0.79217e-02,0.79405e-02,0.74097e-02,0.00000e+00 /)
      kao(:, 2,11,14) = (/ &
        & 0.67616e-02,0.63044e-02,0.67053e-02,0.72656e-02,0.76819e-02, &
        & 0.79515e-02,0.79506e-02,0.73718e-02,0.18408e-04 /)
      kao(:, 3,11,14) = (/ &
        & 0.69005e-02,0.63894e-02,0.67349e-02,0.72931e-02,0.77291e-02, &
        & 0.79845e-02,0.79576e-02,0.73388e-02,0.37607e-04 /)
      kao(:, 4,11,14) = (/ &
        & 0.70530e-02,0.64912e-02,0.67712e-02,0.73223e-02,0.77726e-02, &
        & 0.80170e-02,0.79618e-02,0.73054e-02,0.56367e-04 /)
      kao(:, 5,11,14) = (/ &
        & 0.72039e-02,0.65911e-02,0.68118e-02,0.73572e-02,0.78096e-02, &
        & 0.80477e-02,0.79648e-02,0.72708e-02,0.00000e+00 /)
      kao(:, 1,12,14) = (/ &
        & 0.60858e-02,0.58916e-02,0.65335e-02,0.71525e-02,0.76284e-02, &
        & 0.80006e-02,0.81294e-02,0.76675e-02,0.58588e-04 /)
      kao(:, 2,12,14) = (/ &
        & 0.62191e-02,0.59612e-02,0.65675e-02,0.71998e-02,0.76898e-02, &
        & 0.80500e-02,0.81534e-02,0.76479e-02,0.00000e+00 /)
      kao(:, 3,12,14) = (/ &
        & 0.63725e-02,0.60546e-02,0.66095e-02,0.72445e-02,0.77558e-02, &
        & 0.80973e-02,0.81695e-02,0.76255e-02,0.29841e-04 /)
      kao(:, 4,12,14) = (/ &
        & 0.65241e-02,0.61494e-02,0.66519e-02,0.72916e-02,0.78126e-02, &
        & 0.81445e-02,0.81839e-02,0.75955e-02,0.00000e+00 /)
      kao(:, 5,12,14) = (/ &
        & 0.66908e-02,0.62534e-02,0.66904e-02,0.73429e-02,0.78615e-02, &
        & 0.81879e-02,0.81898e-02,0.75652e-02,0.00000e+00 /)
      kao(:, 1,13,14) = (/ &
        & 0.55891e-02,0.56116e-02,0.63936e-02,0.70621e-02,0.76241e-02, &
        & 0.80837e-02,0.82964e-02,0.79007e-02,0.00000e+00 /)
      kao(:, 2,13,14) = (/ &
        & 0.57354e-02,0.56825e-02,0.64439e-02,0.71280e-02,0.77039e-02, &
        & 0.81460e-02,0.83322e-02,0.78896e-02,0.38090e-04 /)
      kao(:, 3,13,14) = (/ &
        & 0.58847e-02,0.57651e-02,0.64971e-02,0.71963e-02,0.77792e-02, &
        & 0.82047e-02,0.83632e-02,0.78746e-02,0.00000e+00 /)
      kao(:, 4,13,14) = (/ &
        & 0.60503e-02,0.58579e-02,0.65448e-02,0.72663e-02,0.78467e-02, &
        & 0.82617e-02,0.83886e-02,0.78555e-02,0.00000e+00 /)
      kao(:, 5,13,14) = (/ &
        & 0.62326e-02,0.59678e-02,0.65939e-02,0.73313e-02,0.79071e-02, &
        & 0.83133e-02,0.83975e-02,0.78294e-02,0.00000e+00 /)
      kao(:, 1, 1,15) = (/ &
        & 0.22784e-01,0.19937e-01,0.17089e-01,0.14240e-01,0.11393e-01, &
        & 0.85439e-02,0.62360e-02,0.50515e-02,0.76952e-02 /)
      kao(:, 2, 1,15) = (/ &
        & 0.22781e-01,0.19933e-01,0.17085e-01,0.14238e-01,0.11390e-01, &
        & 0.85426e-02,0.62118e-02,0.49990e-02,0.75953e-02 /)
      kao(:, 3, 1,15) = (/ &
        & 0.22781e-01,0.19934e-01,0.17086e-01,0.14239e-01,0.11390e-01, &
        & 0.85428e-02,0.62149e-02,0.49913e-02,0.75531e-02 /)
      kao(:, 4, 1,15) = (/ &
        & 0.22807e-01,0.19955e-01,0.17104e-01,0.14253e-01,0.11403e-01, &
        & 0.85521e-02,0.61662e-02,0.48921e-02,0.74213e-02 /)
      kao(:, 5, 1,15) = (/ &
        & 0.22846e-01,0.19991e-01,0.17134e-01,0.14278e-01,0.11422e-01, &
        & 0.85672e-02,0.61477e-02,0.48442e-02,0.73437e-02 /)
      kao(:, 1, 2,15) = (/ &
        & 0.25963e-01,0.22716e-01,0.19471e-01,0.16227e-01,0.12981e-01, &
        & 0.97432e-02,0.72799e-02,0.58913e-02,0.89930e-02 /)
      kao(:, 2, 2,15) = (/ &
        & 0.25957e-01,0.22712e-01,0.19468e-01,0.16223e-01,0.12978e-01, &
        & 0.97376e-02,0.72409e-02,0.58243e-02,0.88738e-02 /)
      kao(:, 3, 2,15) = (/ &
        & 0.25967e-01,0.22721e-01,0.19475e-01,0.16229e-01,0.12984e-01, &
        & 0.97376e-02,0.72294e-02,0.57970e-02,0.88082e-02 /)
      kao(:, 4, 2,15) = (/ &
        & 0.25991e-01,0.22741e-01,0.19493e-01,0.16243e-01,0.12995e-01, &
        & 0.97464e-02,0.71939e-02,0.57194e-02,0.86974e-02 /)
      kao(:, 5, 2,15) = (/ &
        & 0.26012e-01,0.22759e-01,0.19508e-01,0.16256e-01,0.13005e-01, &
        & 0.97539e-02,0.71378e-02,0.56167e-02,0.85506e-02 /)
      kao(:, 1, 3,15) = (/ &
        & 0.29273e-01,0.25614e-01,0.21954e-01,0.18296e-01,0.14638e-01, &
        & 0.11059e-01,0.84536e-02,0.68488e-02,0.10453e-01 /)
      kao(:, 2, 3,15) = (/ &
        & 0.29273e-01,0.25613e-01,0.21954e-01,0.18296e-01,0.14636e-01, &
        & 0.11040e-01,0.84006e-02,0.67671e-02,0.10308e-01 /)
      kao(:, 3, 3,15) = (/ &
        & 0.29281e-01,0.25620e-01,0.21957e-01,0.18299e-01,0.14639e-01, &
        & 0.11029e-01,0.83532e-02,0.66803e-02,0.10170e-01 /)
      kao(:, 4, 3,15) = (/ &
        & 0.29284e-01,0.25622e-01,0.21963e-01,0.18303e-01,0.14642e-01, &
        & 0.11027e-01,0.83265e-02,0.66328e-02,0.10072e-01 /)
      kao(:, 5, 3,15) = (/ &
        & 0.29273e-01,0.25615e-01,0.21955e-01,0.18297e-01,0.14636e-01, &
        & 0.11016e-01,0.82524e-02,0.65141e-02,0.98927e-02 /)
      kao(:, 1, 4,15) = (/ &
        & 0.32689e-01,0.28601e-01,0.24517e-01,0.20431e-01,0.16343e-01, &
        & 0.12498e-01,0.97860e-02,0.79359e-02,0.11964e-01 /)
      kao(:, 2, 4,15) = (/ &
        & 0.32673e-01,0.28590e-01,0.24505e-01,0.20420e-01,0.16336e-01, &
        & 0.12462e-01,0.97090e-02,0.78356e-02,0.11793e-01 /)
      kao(:, 3, 4,15) = (/ &
        & 0.32657e-01,0.28575e-01,0.24494e-01,0.20410e-01,0.16330e-01, &
        & 0.12434e-01,0.96384e-02,0.77321e-02,0.11625e-01 /)
      kao(:, 4, 4,15) = (/ &
        & 0.32631e-01,0.28553e-01,0.24473e-01,0.20396e-01,0.16316e-01, &
        & 0.12404e-01,0.95671e-02,0.76286e-02,0.11457e-01 /)
      kao(:, 5, 4,15) = (/ &
        & 0.32595e-01,0.28521e-01,0.24445e-01,0.20372e-01,0.16297e-01, &
        & 0.12376e-01,0.95137e-02,0.75694e-02,0.11318e-01 /)
      kao(:, 1, 5,15) = (/ &
        & 0.36129e-01,0.31613e-01,0.27097e-01,0.22582e-01,0.18065e-01, &
        & 0.14059e-01,0.11253e-01,0.91497e-02,0.13513e-01 /)
      kao(:, 2, 5,15) = (/ &
        & 0.36091e-01,0.31580e-01,0.27068e-01,0.22557e-01,0.18046e-01, &
        & 0.13996e-01,0.11159e-01,0.90273e-02,0.13314e-01 /)
      kao(:, 3, 5,15) = (/ &
        & 0.36050e-01,0.31543e-01,0.27038e-01,0.22530e-01,0.18025e-01, &
        & 0.13938e-01,0.11057e-01,0.89022e-02,0.13117e-01 /)
      kao(:, 4, 5,15) = (/ &
        & 0.35994e-01,0.31496e-01,0.26994e-01,0.22495e-01,0.17996e-01, &
        & 0.13877e-01,0.10953e-01,0.87755e-02,0.12914e-01 /)
      kao(:, 5, 5,15) = (/ &
        & 0.35944e-01,0.31450e-01,0.26957e-01,0.22466e-01,0.17973e-01, &
        & 0.13819e-01,0.10863e-01,0.86942e-02,0.12744e-01 /)
      kao(:, 1, 6,15) = (/ &
        & 0.39506e-01,0.34566e-01,0.29627e-01,0.24691e-01,0.19819e-01, &
        & 0.15734e-01,0.12852e-01,0.10482e-01,0.15100e-01 /)
      kao(:, 2, 6,15) = (/ &
        & 0.39438e-01,0.34510e-01,0.29581e-01,0.24651e-01,0.19767e-01, &
        & 0.15626e-01,0.12723e-01,0.10339e-01,0.14869e-01 /)
      kao(:, 3, 6,15) = (/ &
        & 0.39363e-01,0.34443e-01,0.29524e-01,0.24601e-01,0.19714e-01, &
        & 0.15531e-01,0.12593e-01,0.10189e-01,0.14636e-01 /)
      kao(:, 4, 6,15) = (/ &
        & 0.39295e-01,0.34380e-01,0.29468e-01,0.24559e-01,0.19663e-01, &
        & 0.15432e-01,0.12453e-01,0.10038e-01,0.14402e-01 /)
      kao(:, 5, 6,15) = (/ &
        & 0.39232e-01,0.34326e-01,0.29423e-01,0.24518e-01,0.19622e-01, &
        & 0.15336e-01,0.12308e-01,0.98939e-02,0.14172e-01 /)
      kao(:, 1, 7,15) = (/ &
        & 0.42642e-01,0.37314e-01,0.31983e-01,0.26652e-01,0.21609e-01, &
        & 0.17542e-01,0.14584e-01,0.11924e-01,0.16714e-01 /)
      kao(:, 2, 7,15) = (/ &
        & 0.42588e-01,0.37267e-01,0.31942e-01,0.26620e-01,0.21537e-01, &
        & 0.17385e-01,0.14405e-01,0.11750e-01,0.16453e-01 /)
      kao(:, 3, 7,15) = (/ &
        & 0.42519e-01,0.37203e-01,0.31888e-01,0.26575e-01,0.21450e-01, &
        & 0.17237e-01,0.14233e-01,0.11569e-01,0.16190e-01 /)
      kao(:, 4, 7,15) = (/ &
        & 0.42450e-01,0.37145e-01,0.31837e-01,0.26531e-01,0.21364e-01, &
        & 0.17089e-01,0.14051e-01,0.11390e-01,0.15924e-01 /)
      kao(:, 5, 7,15) = (/ &
        & 0.42372e-01,0.37075e-01,0.31780e-01,0.26482e-01,0.21293e-01, &
        & 0.16947e-01,0.13866e-01,0.11216e-01,0.15662e-01 /)
      kao(:, 1, 8,15) = (/ &
        & 0.45438e-01,0.39757e-01,0.34077e-01,0.28427e-01,0.23418e-01, &
        & 0.19456e-01,0.16427e-01,0.13456e-01,0.18359e-01 /)
      kao(:, 2, 8,15) = (/ &
        & 0.45420e-01,0.39742e-01,0.34065e-01,0.28396e-01,0.23308e-01, &
        & 0.19242e-01,0.16196e-01,0.13253e-01,0.18076e-01 /)
      kao(:, 3, 8,15) = (/ &
        & 0.45404e-01,0.39728e-01,0.34054e-01,0.28379e-01,0.23190e-01, &
        & 0.19044e-01,0.15968e-01,0.13036e-01,0.17789e-01 /)
      kao(:, 4, 8,15) = (/ &
        & 0.45355e-01,0.39684e-01,0.34015e-01,0.28348e-01,0.23074e-01, &
        & 0.18841e-01,0.15735e-01,0.12818e-01,0.17487e-01 /)
      kao(:, 5, 8,15) = (/ &
        & 0.45268e-01,0.39604e-01,0.33951e-01,0.28294e-01,0.22964e-01, &
        & 0.18639e-01,0.15495e-01,0.12608e-01,0.17187e-01 /)
      kao(:, 1, 9,15) = (/ &
        & 0.47828e-01,0.41848e-01,0.35870e-01,0.30096e-01,0.25238e-01, &
        & 0.21453e-01,0.18348e-01,0.15048e-01,0.20030e-01 /)
      kao(:, 2, 9,15) = (/ &
        & 0.47883e-01,0.41899e-01,0.35911e-01,0.30061e-01,0.25102e-01, &
        & 0.21178e-01,0.18071e-01,0.14812e-01,0.19720e-01 /)
      kao(:, 3, 9,15) = (/ &
        & 0.47917e-01,0.41930e-01,0.35941e-01,0.30033e-01,0.24934e-01, &
        & 0.20917e-01,0.17786e-01,0.14566e-01,0.19396e-01 /)
      kao(:, 4, 9,15) = (/ &
        & 0.47914e-01,0.41927e-01,0.35936e-01,0.29997e-01,0.24771e-01, &
        & 0.20657e-01,0.17491e-01,0.14311e-01,0.19056e-01 /)
      kao(:, 5, 9,15) = (/ &
        & 0.47853e-01,0.41872e-01,0.35889e-01,0.29935e-01,0.24616e-01, &
        & 0.20393e-01,0.17196e-01,0.14061e-01,0.18721e-01 /)
      kao(:, 1,10,15) = (/ &
        & 0.49786e-01,0.43562e-01,0.37346e-01,0.31673e-01,0.27058e-01, &
        & 0.23446e-01,0.20298e-01,0.16634e-01,0.20401e-01 /)
      kao(:, 2,10,15) = (/ &
        & 0.49957e-01,0.43713e-01,0.37470e-01,0.31624e-01,0.26879e-01, &
        & 0.23121e-01,0.19962e-01,0.16379e-01,0.19980e-01 /)
      kao(:, 3,10,15) = (/ &
        & 0.50073e-01,0.43811e-01,0.37553e-01,0.31591e-01,0.26668e-01, &
        & 0.22810e-01,0.19616e-01,0.16101e-01,0.19150e-01 /)
      kao(:, 4,10,15) = (/ &
        & 0.50104e-01,0.43839e-01,0.37576e-01,0.31542e-01,0.26451e-01, &
        & 0.22487e-01,0.19263e-01,0.15810e-01,0.18309e-01 /)
      kao(:, 5,10,15) = (/ &
        & 0.50083e-01,0.43821e-01,0.37560e-01,0.31463e-01,0.26247e-01, &
        & 0.22153e-01,0.18906e-01,0.15516e-01,0.17790e-01 /)
      kao(:, 1,11,15) = (/ &
        & 0.51449e-01,0.45016e-01,0.38642e-01,0.33136e-01,0.28759e-01, &
        & 0.25254e-01,0.22053e-01,0.18120e-01,0.53897e-02 /)
      kao(:, 2,11,15) = (/ &
        & 0.51718e-01,0.45255e-01,0.38815e-01,0.33090e-01,0.28517e-01, &
        & 0.24894e-01,0.21659e-01,0.17825e-01,0.47196e-02 /)
      kao(:, 3,11,15) = (/ &
        & 0.51885e-01,0.45397e-01,0.38919e-01,0.33034e-01,0.28248e-01, &
        & 0.24520e-01,0.21252e-01,0.17499e-01,0.36639e-02 /)
      kao(:, 4,11,15) = (/ &
        & 0.51965e-01,0.45468e-01,0.38969e-01,0.32946e-01,0.27987e-01, &
        & 0.24125e-01,0.20834e-01,0.17164e-01,0.30436e-02 /)
      kao(:, 5,11,15) = (/ &
        & 0.52007e-01,0.45508e-01,0.39008e-01,0.32828e-01,0.27732e-01, &
        & 0.23720e-01,0.20415e-01,0.16822e-01,0.23024e-02 /)
      kao(:, 1,12,15) = (/ &
        & 0.52772e-01,0.46179e-01,0.39786e-01,0.34518e-01,0.30341e-01, &
        & 0.26996e-01,0.23719e-01,0.19625e-01,0.00000e+00 /)
      kao(:, 2,12,15) = (/ &
        & 0.53131e-01,0.46489e-01,0.39976e-01,0.34451e-01,0.30050e-01, &
        & 0.26583e-01,0.23271e-01,0.19259e-01,0.79250e-04 /)
      kao(:, 3,12,15) = (/ &
        & 0.53372e-01,0.46707e-01,0.40090e-01,0.34369e-01,0.29734e-01, &
        & 0.26140e-01,0.22802e-01,0.18870e-01,0.00000e+00 /)
      kao(:, 4,12,15) = (/ &
        & 0.53549e-01,0.46855e-01,0.40175e-01,0.34238e-01,0.29424e-01, &
        & 0.25661e-01,0.22318e-01,0.18486e-01,0.00000e+00 /)
      kao(:, 5,12,15) = (/ &
        & 0.53641e-01,0.46944e-01,0.40238e-01,0.34087e-01,0.29108e-01, &
        & 0.25184e-01,0.21836e-01,0.18091e-01,0.00000e+00 /)
      kao(:, 1,13,15) = (/ &
        & 0.53794e-01,0.47070e-01,0.40802e-01,0.35804e-01,0.31808e-01, &
        & 0.28611e-01,0.25317e-01,0.21103e-01,0.00000e+00 /)
      kao(:, 2,13,15) = (/ &
        & 0.54248e-01,0.47468e-01,0.40994e-01,0.35717e-01,0.31468e-01, &
        & 0.28147e-01,0.24800e-01,0.20666e-01,0.99549e-04 /)
      kao(:, 3,13,15) = (/ &
        & 0.54616e-01,0.47795e-01,0.41127e-01,0.35591e-01,0.31112e-01, &
        & 0.27634e-01,0.24251e-01,0.20223e-01,0.00000e+00 /)
      kao(:, 4,13,15) = (/ &
        & 0.54881e-01,0.48017e-01,0.41234e-01,0.35410e-01,0.30749e-01, &
        & 0.27090e-01,0.23692e-01,0.19766e-01,0.00000e+00 /)
      kao(:, 5,13,15) = (/ &
        & 0.55030e-01,0.48150e-01,0.41295e-01,0.35229e-01,0.30369e-01, &
        & 0.26544e-01,0.23150e-01,0.19313e-01,0.00000e+00 /)
      kao(:, 1, 1,16) = (/ &
        & 0.31412e-01,0.27484e-01,0.23556e-01,0.19630e-01,0.15703e-01, &
        & 0.11777e-01,0.78503e-02,0.63859e-02,0.10546e-01 /)
      kao(:, 2, 1,16) = (/ &
        & 0.31306e-01,0.27393e-01,0.23480e-01,0.19566e-01,0.15652e-01, &
        & 0.11737e-01,0.78244e-02,0.64039e-02,0.10543e-01 /)
      kao(:, 3, 1,16) = (/ &
        & 0.31189e-01,0.27291e-01,0.23390e-01,0.19492e-01,0.15594e-01, &
        & 0.11694e-01,0.77949e-02,0.65607e-02,0.10621e-01 /)
      kao(:, 4, 1,16) = (/ &
        & 0.31060e-01,0.27175e-01,0.23293e-01,0.19412e-01,0.15526e-01, &
        & 0.11645e-01,0.77621e-02,0.64197e-02,0.10470e-01 /)
      kao(:, 5, 1,16) = (/ &
        & 0.30934e-01,0.27069e-01,0.23201e-01,0.19334e-01,0.15466e-01, &
        & 0.11599e-01,0.77309e-02,0.64181e-02,0.10407e-01 /)
      kao(:, 1, 2,16) = (/ &
        & 0.37345e-01,0.32673e-01,0.28007e-01,0.23341e-01,0.18670e-01, &
        & 0.14002e-01,0.93330e-02,0.76035e-02,0.12759e-01 /)
      kao(:, 2, 2,16) = (/ &
        & 0.37160e-01,0.32513e-01,0.27871e-01,0.23225e-01,0.18579e-01, &
        & 0.13933e-01,0.92868e-02,0.75902e-02,0.12702e-01 /)
      kao(:, 3, 2,16) = (/ &
        & 0.36977e-01,0.32353e-01,0.27732e-01,0.23111e-01,0.18487e-01, &
        & 0.13864e-01,0.92415e-02,0.77168e-02,0.12729e-01 /)
      kao(:, 4, 2,16) = (/ &
        & 0.36807e-01,0.32204e-01,0.27602e-01,0.23002e-01,0.18402e-01, &
        & 0.13798e-01,0.91981e-02,0.77023e-02,0.12641e-01 /)
      kao(:, 5, 2,16) = (/ &
        & 0.36620e-01,0.32046e-01,0.27465e-01,0.22887e-01,0.18309e-01, &
        & 0.13731e-01,0.91527e-02,0.75684e-02,0.12457e-01 /)
      kao(:, 1, 3,16) = (/ &
        & 0.44232e-01,0.38700e-01,0.33173e-01,0.27644e-01,0.22114e-01, &
        & 0.16581e-01,0.11054e-01,0.91028e-02,0.15510e-01 /)
      kao(:, 2, 3,16) = (/ &
        & 0.43957e-01,0.38463e-01,0.32969e-01,0.27474e-01,0.21977e-01, &
        & 0.16483e-01,0.10987e-01,0.90298e-02,0.15354e-01 /)
      kao(:, 3, 3,16) = (/ &
        & 0.43680e-01,0.38217e-01,0.32756e-01,0.27297e-01,0.21838e-01, &
        & 0.16376e-01,0.10918e-01,0.89896e-02,0.15195e-01 /)
      kao(:, 4, 3,16) = (/ &
        & 0.43409e-01,0.37982e-01,0.32556e-01,0.27128e-01,0.21703e-01, &
        & 0.16277e-01,0.10849e-01,0.90630e-02,0.15090e-01 /)
      kao(:, 5, 3,16) = (/ &
        & 0.43148e-01,0.37757e-01,0.32362e-01,0.26967e-01,0.21574e-01, &
        & 0.16179e-01,0.10784e-01,0.89323e-02,0.14861e-01 /)
      kao(:, 1, 4,16) = (/ &
        & 0.52173e-01,0.45650e-01,0.39129e-01,0.32609e-01,0.26084e-01, &
        & 0.19564e-01,0.13063e-01,0.10928e-01,0.18665e-01 /)
      kao(:, 2, 4,16) = (/ &
        & 0.51767e-01,0.45298e-01,0.38824e-01,0.32358e-01,0.25882e-01, &
        & 0.19411e-01,0.12948e-01,0.10795e-01,0.18386e-01 /)
      kao(:, 3, 4,16) = (/ &
        & 0.51358e-01,0.44935e-01,0.38514e-01,0.32093e-01,0.25677e-01, &
        & 0.19255e-01,0.12843e-01,0.10694e-01,0.18120e-01 /)
      kao(:, 4, 4,16) = (/ &
        & 0.50955e-01,0.44587e-01,0.38218e-01,0.31847e-01,0.25475e-01, &
        & 0.19107e-01,0.12737e-01,0.10607e-01,0.17851e-01 /)
      kao(:, 5, 4,16) = (/ &
        & 0.50544e-01,0.44227e-01,0.37909e-01,0.31588e-01,0.25270e-01, &
        & 0.18952e-01,0.12634e-01,0.10599e-01,0.17618e-01 /)
      kao(:, 1, 5,16) = (/ &
        & 0.61214e-01,0.53565e-01,0.45917e-01,0.38262e-01,0.30607e-01, &
        & 0.22954e-01,0.15462e-01,0.13125e-01,0.22278e-01 /)
      kao(:, 2, 5,16) = (/ &
        & 0.60651e-01,0.53068e-01,0.45484e-01,0.37903e-01,0.30322e-01, &
        & 0.22741e-01,0.15244e-01,0.12927e-01,0.21870e-01 /)
      kao(:, 3, 5,16) = (/ &
        & 0.60040e-01,0.52533e-01,0.45028e-01,0.37524e-01,0.30019e-01, &
        & 0.22514e-01,0.15074e-01,0.12758e-01,0.21465e-01 /)
      kao(:, 4, 5,16) = (/ &
        & 0.59437e-01,0.52006e-01,0.44573e-01,0.37145e-01,0.29715e-01, &
        & 0.22286e-01,0.14911e-01,0.12602e-01,0.21062e-01 /)
      kao(:, 5, 5,16) = (/ &
        & 0.58809e-01,0.51461e-01,0.44106e-01,0.36755e-01,0.29405e-01, &
        & 0.22053e-01,0.14746e-01,0.12499e-01,0.20685e-01 /)
      kao(:, 1, 6,16) = (/ &
        & 0.71375e-01,0.62451e-01,0.53529e-01,0.44607e-01,0.35687e-01, &
        & 0.26759e-01,0.18273e-01,0.15758e-01,0.26378e-01 /)
      kao(:, 2, 6,16) = (/ &
        & 0.70571e-01,0.61748e-01,0.52933e-01,0.44107e-01,0.35285e-01, &
        & 0.26462e-01,0.17959e-01,0.15470e-01,0.25822e-01 /)
      kao(:, 3, 6,16) = (/ &
        & 0.69734e-01,0.61022e-01,0.52301e-01,0.43583e-01,0.34867e-01, &
        & 0.26147e-01,0.17660e-01,0.15207e-01,0.25265e-01 /)
      kao(:, 4, 6,16) = (/ &
        & 0.68870e-01,0.60256e-01,0.51654e-01,0.43043e-01,0.34432e-01, &
        & 0.25826e-01,0.17391e-01,0.14968e-01,0.24710e-01 /)
      kao(:, 5, 6,16) = (/ &
        & 0.67988e-01,0.59482e-01,0.50988e-01,0.42488e-01,0.33987e-01, &
        & 0.25491e-01,0.17159e-01,0.14740e-01,0.24148e-01 /)
      kao(:, 1, 7,16) = (/ &
        & 0.82705e-01,0.72369e-01,0.62031e-01,0.51694e-01,0.41353e-01, &
        & 0.31012e-01,0.21511e-01,0.18843e-01,0.31008e-01 /)
      kao(:, 2, 7,16) = (/ &
        & 0.81487e-01,0.71304e-01,0.61113e-01,0.50924e-01,0.40740e-01, &
        & 0.30554e-01,0.21074e-01,0.18457e-01,0.30235e-01 /)
      kao(:, 3, 7,16) = (/ &
        & 0.80318e-01,0.70281e-01,0.60235e-01,0.50200e-01,0.40157e-01, &
        & 0.30117e-01,0.20636e-01,0.18102e-01,0.29494e-01 /)
      kao(:, 4, 7,16) = (/ &
        & 0.79154e-01,0.69255e-01,0.59365e-01,0.49470e-01,0.39576e-01, &
        & 0.29680e-01,0.20228e-01,0.17748e-01,0.28759e-01 /)
      kao(:, 5, 7,16) = (/ &
        & 0.77937e-01,0.68190e-01,0.58450e-01,0.48707e-01,0.38965e-01, &
        & 0.29223e-01,0.19858e-01,0.17406e-01,0.28017e-01 /)
      kao(:, 1, 8,16) = (/ &
        & 0.95173e-01,0.83270e-01,0.71377e-01,0.59480e-01,0.47582e-01, &
        & 0.35684e-01,0.25169e-01,0.22449e-01,0.36274e-01 /)
      kao(:, 2, 8,16) = (/ &
        & 0.93409e-01,0.81740e-01,0.70058e-01,0.58384e-01,0.46709e-01, &
        & 0.35028e-01,0.24581e-01,0.21893e-01,0.35207e-01 /)
      kao(:, 3, 8,16) = (/ &
        & 0.91737e-01,0.80263e-01,0.68796e-01,0.57330e-01,0.45863e-01, &
        & 0.34396e-01,0.23987e-01,0.21409e-01,0.34174e-01 /)
      kao(:, 4, 8,16) = (/ &
        & 0.90113e-01,0.78852e-01,0.67585e-01,0.56324e-01,0.45060e-01, &
        & 0.33794e-01,0.23415e-01,0.20940e-01,0.33185e-01 /)
      kao(:, 5, 8,16) = (/ &
        & 0.88500e-01,0.77445e-01,0.66378e-01,0.55317e-01,0.44252e-01, &
        & 0.33190e-01,0.22890e-01,0.20471e-01,0.32236e-01 /)
      kao(:, 1, 9,16) = (/ &
        & 0.10878e+00,0.95186e-01,0.81587e-01,0.67986e-01,0.54386e-01, &
        & 0.40792e-01,0.29314e-01,0.26669e-01,0.42265e-01 /)
      kao(:, 2, 9,16) = (/ &
        & 0.10631e+00,0.93021e-01,0.79732e-01,0.66444e-01,0.53150e-01, &
        & 0.39864e-01,0.28508e-01,0.25873e-01,0.40792e-01 /)
      kao(:, 3, 9,16) = (/ &
        & 0.10400e+00,0.91002e-01,0.78003e-01,0.64997e-01,0.51997e-01, &
        & 0.39001e-01,0.27707e-01,0.25186e-01,0.39383e-01 /)
      kao(:, 4, 9,16) = (/ &
        & 0.10173e+00,0.89018e-01,0.76292e-01,0.63582e-01,0.50863e-01, &
        & 0.38144e-01,0.26926e-01,0.24532e-01,0.38084e-01 /)
      kao(:, 5, 9,16) = (/ &
        & 0.99555e-01,0.87113e-01,0.74666e-01,0.62221e-01,0.49774e-01, &
        & 0.37334e-01,0.26211e-01,0.23902e-01,0.36825e-01 /)
      kao(:, 1,10,16) = (/ &
        & 0.12320e+00,0.10779e+00,0.92400e-01,0.76993e-01,0.61601e-01, &
        & 0.46197e-01,0.33879e-01,0.31475e-01,0.48792e-01 /)
      kao(:, 2,10,16) = (/ &
        & 0.11986e+00,0.10487e+00,0.89890e-01,0.74910e-01,0.59927e-01, &
        & 0.44946e-01,0.32786e-01,0.30373e-01,0.46838e-01 /)
      kao(:, 3,10,16) = (/ &
        & 0.11671e+00,0.10212e+00,0.87531e-01,0.72938e-01,0.58350e-01, &
        & 0.43767e-01,0.31728e-01,0.29415e-01,0.45011e-01 /)
      kao(:, 4,10,16) = (/ &
        & 0.11373e+00,0.99514e-01,0.85291e-01,0.71084e-01,0.56859e-01, &
        & 0.42648e-01,0.30712e-01,0.28518e-01,0.43306e-01 /)
      kao(:, 5,10,16) = (/ &
        & 0.11086e+00,0.97005e-01,0.83130e-01,0.69287e-01,0.55428e-01, &
        & 0.41573e-01,0.29748e-01,0.27669e-01,0.41673e-01 /)
      kao(:, 1,11,16) = (/ &
        & 0.13635e+00,0.11930e+00,0.10226e+00,0.85213e-01,0.68170e-01, &
        & 0.51126e-01,0.38257e-01,0.36212e-01,0.54706e-01 /)
      kao(:, 2,11,16) = (/ &
        & 0.13203e+00,0.11554e+00,0.99030e-01,0.82523e-01,0.66019e-01, &
        & 0.49513e-01,0.36799e-01,0.34833e-01,0.52312e-01 /)
      kao(:, 3,11,16) = (/ &
        & 0.12805e+00,0.11203e+00,0.96022e-01,0.80023e-01,0.64019e-01, &
        & 0.48015e-01,0.35435e-01,0.33591e-01,0.50057e-01 /)
      kao(:, 4,11,16) = (/ &
        & 0.12432e+00,0.10877e+00,0.93237e-01,0.77695e-01,0.62158e-01, &
        & 0.46618e-01,0.34181e-01,0.32427e-01,0.47918e-01 /)
      kao(:, 5,11,16) = (/ &
        & 0.12077e+00,0.10567e+00,0.90572e-01,0.75471e-01,0.60381e-01, &
        & 0.45284e-01,0.32973e-01,0.31331e-01,0.45895e-01 /)
      kao(:, 1,12,16) = (/ &
        & 0.14909e+00,0.13045e+00,0.11182e+00,0.93176e-01,0.74537e-01, &
        & 0.55927e-01,0.42736e-01,0.41194e-01,0.43864e-01 /)
      kao(:, 2,12,16) = (/ &
        & 0.14380e+00,0.12582e+00,0.10785e+00,0.89883e-01,0.71900e-01, &
        & 0.53925e-01,0.40874e-01,0.39509e-01,0.34410e-01 /)
      kao(:, 3,12,16) = (/ &
        & 0.13887e+00,0.12152e+00,0.10414e+00,0.86796e-01,0.69431e-01, &
        & 0.52073e-01,0.39165e-01,0.37950e-01,0.27228e-01 /)
      kao(:, 4,12,16) = (/ &
        & 0.13436e+00,0.11758e+00,0.10078e+00,0.83978e-01,0.67186e-01, &
        & 0.50383e-01,0.37599e-01,0.36473e-01,0.23165e-01 /)
      kao(:, 5,12,16) = (/ &
        & 0.13007e+00,0.11382e+00,0.97560e-01,0.81293e-01,0.65042e-01, &
        & 0.48775e-01,0.36131e-01,0.35083e-01,0.14412e-01 /)
      kao(:, 1,13,16) = (/ &
        & 0.16113e+00,0.14100e+00,0.12085e+00,0.10071e+00,0.80563e-01, &
        & 0.60580e-01,0.47246e-01,0.46365e-01,0.26456e-01 /)
      kao(:, 2,13,16) = (/ &
        & 0.15486e+00,0.13550e+00,0.11616e+00,0.96791e-01,0.77431e-01, &
        & 0.58082e-01,0.44915e-01,0.44314e-01,0.19340e-01 /)
      kao(:, 3,13,16) = (/ &
        & 0.14906e+00,0.13042e+00,0.11179e+00,0.93156e-01,0.74526e-01, &
        & 0.55893e-01,0.42831e-01,0.42380e-01,0.11993e-01 /)
      kao(:, 4,13,16) = (/ &
        & 0.14369e+00,0.12574e+00,0.10777e+00,0.89817e-01,0.71849e-01, &
        & 0.53884e-01,0.40915e-01,0.40556e-01,0.50486e-02 /)
      kao(:, 5,13,16) = (/ &
        & 0.13868e+00,0.12134e+00,0.10400e+00,0.86669e-01,0.69338e-01, &
        & 0.52006e-01,0.39136e-01,0.38851e-01,0.00000e+00 /)
  
!     -----------------------------------------------------------------
!     The array KBO contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels < ~100mb and temperatures. The first 
!     index in the array, JT, which runs from 1 to 5, corresponds to 
!     different temperatures.  More specifically, JT = 3 means that the 
!     data are for the reference temperature TREF for this pressure 
!     level, JT = 2 refers to the temperature TREF-15, JT = 1 is for
!     TREF-30, JT = 4 is for TREF+15, and JT = 5 is for TREF+30.  
!     The second index, JP, runs from 13 to 59 and refers to the JPth
!     reference pressure level (see taumol.f for the value of these
!     pressure levels in mb).  The third index, IG, goes from 1 to 16,
!     and tells us which g-interval the absorption coefficients are for.
!     -----------------------------------------------------------------

      kbo(:,13, 1) = (/ &
        & 0.12158e-08,0.13238e-08,0.15146e-08,0.16862e-08,0.18609e-08 /)
      kbo(:,14, 1) = (/ &
        & 0.16931e-08,0.20047e-08,0.23006e-08,0.25636e-08,0.28912e-08 /)
      kbo(:,15, 1) = (/ &
        & 0.31521e-08,0.36963e-08,0.41550e-08,0.46365e-08,0.50834e-08 /)
      kbo(:,16, 1) = (/ &
        & 0.46152e-08,0.50173e-08,0.55381e-08,0.60748e-08,0.66355e-08 /)
      kbo(:,17, 1) = (/ &
        & 0.62662e-08,0.67518e-08,0.71765e-08,0.80302e-08,0.89056e-08 /)
      kbo(:,18, 1) = (/ &
        & 0.81764e-08,0.91818e-08,0.10385e-07,0.11708e-07,0.12536e-07 /)
      kbo(:,19, 1) = (/ &
        & 0.12946e-07,0.13631e-07,0.14453e-07,0.15133e-07,0.15911e-07 /)
      kbo(:,20, 1) = (/ &
        & 0.15868e-07,0.16654e-07,0.17281e-07,0.17857e-07,0.18383e-07 /)
      kbo(:,21, 1) = (/ &
        & 0.18151e-07,0.19056e-07,0.20057e-07,0.20708e-07,0.21229e-07 /)
      kbo(:,22, 1) = (/ &
        & 0.20234e-07,0.21482e-07,0.22599e-07,0.23778e-07,0.25115e-07 /)
      kbo(:,23, 1) = (/ &
        & 0.23827e-07,0.25405e-07,0.26545e-07,0.27716e-07,0.28422e-07 /)
      kbo(:,24, 1) = (/ &
        & 0.27638e-07,0.28518e-07,0.29101e-07,0.29639e-07,0.30077e-07 /)
      kbo(:,25, 1) = (/ &
        & 0.28942e-07,0.29436e-07,0.29831e-07,0.30066e-07,0.30242e-07 /)
      kbo(:,26, 1) = (/ &
        & 0.28774e-07,0.29004e-07,0.29272e-07,0.29431e-07,0.29616e-07 /)
      kbo(:,27, 1) = (/ &
        & 0.27317e-07,0.27462e-07,0.27698e-07,0.27835e-07,0.27843e-07 /)
      kbo(:,28, 1) = (/ &
        & 0.25463e-07,0.25523e-07,0.25678e-07,0.25658e-07,0.25687e-07 /)
      kbo(:,29, 1) = (/ &
        & 0.22603e-07,0.22672e-07,0.22704e-07,0.22668e-07,0.22698e-07 /)
      kbo(:,30, 1) = (/ &
        & 0.19657e-07,0.19747e-07,0.19687e-07,0.19659e-07,0.19680e-07 /)
      kbo(:,31, 1) = (/ &
        & 0.16553e-07,0.16571e-07,0.16522e-07,0.16545e-07,0.16563e-07 /)
      kbo(:,32, 1) = (/ &
        & 0.13867e-07,0.13795e-07,0.13808e-07,0.13815e-07,0.13799e-07 /)
      kbo(:,33, 1) = (/ &
        & 0.11414e-07,0.11409e-07,0.11395e-07,0.11384e-07,0.11416e-07 /)
      kbo(:,34, 1) = (/ &
        & 0.95639e-08,0.95514e-08,0.95251e-08,0.95607e-08,0.95767e-08 /)
      kbo(:,35, 1) = (/ &
        & 0.80018e-08,0.79882e-08,0.79720e-08,0.79934e-08,0.79942e-08 /)
      kbo(:,36, 1) = (/ &
        & 0.67279e-08,0.67135e-08,0.67089e-08,0.67131e-08,0.67290e-08 /)
      kbo(:,37, 1) = (/ &
        & 0.57292e-08,0.57278e-08,0.57247e-08,0.57298e-08,0.57269e-08 /)
      kbo(:,38, 1) = (/ &
        & 0.48406e-08,0.48461e-08,0.48394e-08,0.48468e-08,0.48401e-08 /)
      kbo(:,39, 1) = (/ &
        & 0.40368e-08,0.40419e-08,0.40353e-08,0.40432e-08,0.40267e-08 /)
      kbo(:,40, 1) = (/ &
        & 0.34875e-08,0.34931e-08,0.34872e-08,0.34940e-08,0.34782e-08 /)
      kbo(:,41, 1) = (/ &
        & 0.30195e-08,0.30243e-08,0.30129e-08,0.30148e-08,0.30016e-08 /)
      kbo(:,42, 1) = (/ &
        & 0.25993e-08,0.25924e-08,0.25861e-08,0.25841e-08,0.25734e-08 /)
      kbo(:,43, 1) = (/ &
        & 0.22290e-08,0.22166e-08,0.22080e-08,0.22067e-08,0.21992e-08 /)
      kbo(:,44, 1) = (/ &
        & 0.18916e-08,0.18847e-08,0.18733e-08,0.18685e-08,0.18685e-08 /)
      kbo(:,45, 1) = (/ &
        & 0.15840e-08,0.15787e-08,0.15719e-08,0.15641e-08,0.15644e-08 /)
      kbo(:,46, 1) = (/ &
        & 0.13197e-08,0.13138e-08,0.13098e-08,0.13024e-08,0.13049e-08 /)
      kbo(:,47, 1) = (/ &
        & 0.11052e-08,0.11003e-08,0.10954e-08,0.10927e-08,0.10941e-08 /)
      kbo(:,48, 1) = (/ &
        & 0.91115e-09,0.90837e-09,0.90520e-09,0.90009e-09,0.90047e-09 /)
      kbo(:,49, 1) = (/ &
        & 0.73101e-09,0.73246e-09,0.73006e-09,0.72687e-09,0.72508e-09 /)
      kbo(:,50, 1) = (/ &
        & 0.60565e-09,0.60526e-09,0.60121e-09,0.60117e-09,0.60056e-09 /)
      kbo(:,51, 1) = (/ &
        & 0.50736e-09,0.50750e-09,0.50421e-09,0.50378e-09,0.50259e-09 /)
      kbo(:,52, 1) = (/ &
        & 0.41843e-09,0.41856e-09,0.41499e-09,0.41535e-09,0.41353e-09 /)
      kbo(:,53, 1) = (/ &
        & 0.33766e-09,0.33794e-09,0.33511e-09,0.33405e-09,0.33405e-09 /)
      kbo(:,54, 1) = (/ &
        & 0.29473e-09,0.29448e-09,0.29284e-09,0.29146e-09,0.29053e-09 /)
      kbo(:,55, 1) = (/ &
        & 0.26948e-09,0.27034e-09,0.27016e-09,0.26799e-09,0.26580e-09 /)
      kbo(:,56, 1) = (/ &
        & 0.24773e-09,0.24784e-09,0.24734e-09,0.24436e-09,0.24377e-09 /)
      kbo(:,57, 1) = (/ &
        & 0.22707e-09,0.22765e-09,0.22683e-09,0.22503e-09,0.22447e-09 /)
      kbo(:,58, 1) = (/ &
        & 0.21180e-09,0.21264e-09,0.21254e-09,0.21338e-09,0.21089e-09 /)
      kbo(:,59, 1) = (/ &
        & 0.22898e-09,0.23089e-09,0.23471e-09,0.23606e-09,0.23388e-09 /)
      kbo(:,13, 2) = (/ &
        & 0.18001e-08,0.19945e-08,0.21612e-08,0.23316e-08,0.25983e-08 /)
      kbo(:,14, 2) = (/ &
        & 0.39853e-08,0.42632e-08,0.44602e-08,0.46784e-08,0.48071e-08 /)
      kbo(:,15, 2) = (/ &
        & 0.60848e-08,0.61494e-08,0.61069e-08,0.61295e-08,0.65707e-08 /)
      kbo(:,16, 2) = (/ &
        & 0.75494e-08,0.85999e-08,0.91057e-08,0.10175e-07,0.10943e-07 /)
      kbo(:,17, 2) = (/ &
        & 0.12037e-07,0.12753e-07,0.13314e-07,0.13239e-07,0.13306e-07 /)
      kbo(:,18, 2) = (/ &
        & 0.15519e-07,0.15517e-07,0.15097e-07,0.14435e-07,0.13983e-07 /)
      kbo(:,19, 2) = (/ &
        & 0.16420e-07,0.17025e-07,0.17639e-07,0.17633e-07,0.17513e-07 /)
      kbo(:,20, 2) = (/ &
        & 0.18021e-07,0.19301e-07,0.20621e-07,0.22238e-07,0.23351e-07 /)
      kbo(:,21, 2) = (/ &
        & 0.22378e-07,0.23582e-07,0.24409e-07,0.24915e-07,0.25516e-07 /)
      kbo(:,22, 2) = (/ &
        & 0.24712e-07,0.24864e-07,0.24556e-07,0.23953e-07,0.23424e-07 /)
      kbo(:,23, 2) = (/ &
        & 0.22545e-07,0.22002e-07,0.21325e-07,0.20492e-07,0.20022e-07 /)
      kbo(:,24, 2) = (/ &
        & 0.18798e-07,0.18566e-07,0.18366e-07,0.18099e-07,0.17971e-07 /)
      kbo(:,25, 2) = (/ &
        & 0.16773e-07,0.16803e-07,0.16541e-07,0.16450e-07,0.16482e-07 /)
      kbo(:,26, 2) = (/ &
        & 0.15222e-07,0.15398e-07,0.15177e-07,0.15147e-07,0.14951e-07 /)
      kbo(:,27, 2) = (/ &
        & 0.13792e-07,0.13944e-07,0.13534e-07,0.13546e-07,0.13516e-07 /)
      kbo(:,28, 2) = (/ &
        & 0.12157e-07,0.12221e-07,0.11930e-07,0.12115e-07,0.12027e-07 /)
      kbo(:,29, 2) = (/ &
        & 0.10487e-07,0.10393e-07,0.10366e-07,0.10455e-07,0.10269e-07 /)
      kbo(:,30, 2) = (/ &
        & 0.90084e-08,0.88590e-08,0.90055e-08,0.88655e-08,0.87392e-08 /)
      kbo(:,31, 2) = (/ &
        & 0.74765e-08,0.74889e-08,0.73915e-08,0.73289e-08,0.72219e-08 /)
      kbo(:,32, 2) = (/ &
        & 0.62311e-08,0.62461e-08,0.61378e-08,0.59795e-08,0.60309e-08 /)
      kbo(:,33, 2) = (/ &
        & 0.51421e-08,0.50519e-08,0.50031e-08,0.49630e-08,0.49489e-08 /)
      kbo(:,34, 2) = (/ &
        & 0.42880e-08,0.42042e-08,0.41366e-08,0.41198e-08,0.41265e-08 /)
      kbo(:,35, 2) = (/ &
        & 0.35718e-08,0.34728e-08,0.34599e-08,0.34385e-08,0.34695e-08 /)
      kbo(:,36, 2) = (/ &
        & 0.29713e-08,0.29023e-08,0.28707e-08,0.28790e-08,0.28873e-08 /)
      kbo(:,37, 2) = (/ &
        & 0.25246e-08,0.24463e-08,0.24323e-08,0.24308e-08,0.24753e-08 /)
      kbo(:,38, 2) = (/ &
        & 0.21159e-08,0.20527e-08,0.20532e-08,0.20325e-08,0.20615e-08 /)
      kbo(:,39, 2) = (/ &
        & 0.17631e-08,0.17097e-08,0.17043e-08,0.16987e-08,0.17298e-08 /)
      kbo(:,40, 2) = (/ &
        & 0.15260e-08,0.14757e-08,0.14566e-08,0.14513e-08,0.14651e-08 /)
      kbo(:,41, 2) = (/ &
        & 0.13009e-08,0.12457e-08,0.12523e-08,0.12490e-08,0.12671e-08 /)
      kbo(:,42, 2) = (/ &
        & 0.10990e-08,0.10789e-08,0.10741e-08,0.10762e-08,0.10873e-08 /)
      kbo(:,43, 2) = (/ &
        & 0.94313e-09,0.92236e-09,0.92369e-09,0.91495e-09,0.92405e-09 /)
      kbo(:,44, 2) = (/ &
        & 0.80746e-09,0.78453e-09,0.77646e-09,0.77477e-09,0.77888e-09 /)
      kbo(:,45, 2) = (/ &
        & 0.67944e-09,0.66381e-09,0.65747e-09,0.65286e-09,0.65668e-09 /)
      kbo(:,46, 2) = (/ &
        & 0.56677e-09,0.55682e-09,0.54825e-09,0.54623e-09,0.54843e-09 /)
      kbo(:,47, 2) = (/ &
        & 0.47375e-09,0.47120e-09,0.45836e-09,0.45709e-09,0.45689e-09 /)
      kbo(:,48, 2) = (/ &
        & 0.39797e-09,0.39204e-09,0.37735e-09,0.37505e-09,0.37687e-09 /)
      kbo(:,49, 2) = (/ &
        & 0.32772e-09,0.31857e-09,0.30808e-09,0.30232e-09,0.30140e-09 /)
      kbo(:,50, 2) = (/ &
        & 0.27300e-09,0.26581e-09,0.26125e-09,0.24922e-09,0.25029e-09 /)
      kbo(:,51, 2) = (/ &
        & 0.23073e-09,0.22159e-09,0.21979e-09,0.20969e-09,0.21117e-09 /)
      kbo(:,52, 2) = (/ &
        & 0.18868e-09,0.18466e-09,0.18517e-09,0.17470e-09,0.17469e-09 /)
      kbo(:,53, 2) = (/ &
        & 0.15290e-09,0.14970e-09,0.15032e-09,0.14201e-09,0.14053e-09 /)
      kbo(:,54, 2) = (/ &
        & 0.13616e-09,0.13340e-09,0.13256e-09,0.12713e-09,0.12621e-09 /)
      kbo(:,55, 2) = (/ &
        & 0.12605e-09,0.12524e-09,0.12106e-09,0.11994e-09,0.11735e-09 /)
      kbo(:,56, 2) = (/ &
        & 0.11625e-09,0.11350e-09,0.11287e-09,0.11534e-09,0.10942e-09 /)
      kbo(:,57, 2) = (/ &
        & 0.10168e-09,0.10628e-09,0.10684e-09,0.10799e-09,0.10313e-09 /)
      kbo(:,58, 2) = (/ &
        & 0.92659e-10,0.10050e-09,0.10168e-09,0.97877e-10,0.97971e-10 /)
      kbo(:,59, 2) = (/ &
        & 0.10198e-09,0.11632e-09,0.11127e-09,0.10947e-09,0.11000e-09 /)
      kbo(:,13, 3) = (/ &
        & 0.33788e-08,0.38685e-08,0.40059e-08,0.41301e-08,0.43316e-08 /)
      kbo(:,14, 3) = (/ &
        & 0.54022e-08,0.55644e-08,0.55814e-08,0.55195e-08,0.57708e-08 /)
      kbo(:,15, 3) = (/ &
        & 0.95769e-08,0.10205e-07,0.12445e-07,0.13419e-07,0.13357e-07 /)
      kbo(:,16, 3) = (/ &
        & 0.17233e-07,0.16177e-07,0.16092e-07,0.15590e-07,0.15068e-07 /)
      kbo(:,17, 3) = (/ &
        & 0.19731e-07,0.19947e-07,0.20278e-07,0.20235e-07,0.20699e-07 /)
      kbo(:,18, 3) = (/ &
        & 0.23168e-07,0.23970e-07,0.25507e-07,0.27034e-07,0.29135e-07 /)
      kbo(:,19, 3) = (/ &
        & 0.33749e-07,0.35374e-07,0.37333e-07,0.38730e-07,0.39816e-07 /)
      kbo(:,20, 3) = (/ &
        & 0.39844e-07,0.39698e-07,0.39651e-07,0.38618e-07,0.37699e-07 /)
      kbo(:,21, 3) = (/ &
        & 0.37013e-07,0.35923e-07,0.35560e-07,0.35217e-07,0.34594e-07 /)
      kbo(:,22, 3) = (/ &
        & 0.32381e-07,0.31844e-07,0.32272e-07,0.32430e-07,0.31922e-07 /)
      kbo(:,23, 3) = (/ &
        & 0.29924e-07,0.29834e-07,0.30537e-07,0.30494e-07,0.30313e-07 /)
      kbo(:,24, 3) = (/ &
        & 0.27849e-07,0.28147e-07,0.29005e-07,0.29081e-07,0.28673e-07 /)
      kbo(:,25, 3) = (/ &
        & 0.25534e-07,0.25854e-07,0.26978e-07,0.27173e-07,0.27116e-07 /)
      kbo(:,26, 3) = (/ &
        & 0.23413e-07,0.24124e-07,0.25341e-07,0.25322e-07,0.25266e-07 /)
      kbo(:,27, 3) = (/ &
        & 0.21218e-07,0.22105e-07,0.23470e-07,0.23280e-07,0.23250e-07 /)
      kbo(:,28, 3) = (/ &
        & 0.19002e-07,0.20309e-07,0.21106e-07,0.20908e-07,0.21199e-07 /)
      kbo(:,29, 3) = (/ &
        & 0.16901e-07,0.18244e-07,0.18426e-07,0.18398e-07,0.18708e-07 /)
      kbo(:,30, 3) = (/ &
        & 0.15065e-07,0.15814e-07,0.15711e-07,0.16012e-07,0.16145e-07 /)
      kbo(:,31, 3) = (/ &
        & 0.13100e-07,0.13194e-07,0.13385e-07,0.13455e-07,0.13435e-07 /)
      kbo(:,32, 3) = (/ &
        & 0.10972e-07,0.10986e-07,0.11085e-07,0.11182e-07,0.11030e-07 /)
      kbo(:,33, 3) = (/ &
        & 0.90750e-08,0.90832e-08,0.91769e-08,0.89877e-08,0.89513e-08 /)
      kbo(:,34, 3) = (/ &
        & 0.75008e-08,0.76569e-08,0.76237e-08,0.74547e-08,0.74719e-08 /)
      kbo(:,35, 3) = (/ &
        & 0.63063e-08,0.64050e-08,0.62067e-08,0.61836e-08,0.61775e-08 /)
      kbo(:,36, 3) = (/ &
        & 0.53250e-08,0.52712e-08,0.52454e-08,0.51153e-08,0.51657e-08 /)
      kbo(:,37, 3) = (/ &
        & 0.45450e-08,0.45358e-08,0.44274e-08,0.43893e-08,0.43616e-08 /)
      kbo(:,38, 3) = (/ &
        & 0.38039e-08,0.38254e-08,0.37172e-08,0.37203e-08,0.37278e-08 /)
      kbo(:,39, 3) = (/ &
        & 0.31821e-08,0.31632e-08,0.30774e-08,0.30626e-08,0.30979e-08 /)
      kbo(:,40, 3) = (/ &
        & 0.27339e-08,0.27443e-08,0.26754e-08,0.26505e-08,0.27022e-08 /)
      kbo(:,41, 3) = (/ &
        & 0.23939e-08,0.24228e-08,0.23415e-08,0.23287e-08,0.23327e-08 /)
      kbo(:,42, 3) = (/ &
        & 0.20895e-08,0.20874e-08,0.20298e-08,0.20180e-08,0.19876e-08 /)
      kbo(:,43, 3) = (/ &
        & 0.17869e-08,0.17800e-08,0.17392e-08,0.17376e-08,0.16927e-08 /)
      kbo(:,44, 3) = (/ &
        & 0.15169e-08,0.15335e-08,0.14778e-08,0.14668e-08,0.14407e-08 /)
      kbo(:,45, 3) = (/ &
        & 0.12692e-08,0.12902e-08,0.12439e-08,0.12324e-08,0.11996e-08 /)
      kbo(:,46, 3) = (/ &
        & 0.10611e-08,0.10656e-08,0.10472e-08,0.10282e-08,0.10015e-08 /)
      kbo(:,47, 3) = (/ &
        & 0.90394e-09,0.88143e-09,0.87958e-09,0.84984e-09,0.85121e-09 /)
      kbo(:,48, 3) = (/ &
        & 0.73451e-09,0.71978e-09,0.73014e-09,0.70436e-09,0.69840e-09 /)
      kbo(:,49, 3) = (/ &
        & 0.58678e-09,0.58259e-09,0.58316e-09,0.55960e-09,0.56079e-09 /)
      kbo(:,50, 3) = (/ &
        & 0.48502e-09,0.47984e-09,0.48693e-09,0.47265e-09,0.46016e-09 /)
      kbo(:,51, 3) = (/ &
        & 0.40704e-09,0.40367e-09,0.41046e-09,0.39764e-09,0.38714e-09 /)
      kbo(:,52, 3) = (/ &
        & 0.33771e-09,0.33070e-09,0.32984e-09,0.33231e-09,0.32299e-09 /)
      kbo(:,53, 3) = (/ &
        & 0.27062e-09,0.27028e-09,0.26516e-09,0.26816e-09,0.25661e-09 /)
      kbo(:,54, 3) = (/ &
        & 0.23501e-09,0.23579e-09,0.23460e-09,0.23532e-09,0.22777e-09 /)
      kbo(:,55, 3) = (/ &
        & 0.20561e-09,0.21843e-09,0.22171e-09,0.22358e-09,0.21702e-09 /)
      kbo(:,56, 3) = (/ &
        & 0.18557e-09,0.20864e-09,0.21196e-09,0.20646e-09,0.20759e-09 /)
      kbo(:,57, 3) = (/ &
        & 0.17099e-09,0.19489e-09,0.19486e-09,0.19102e-09,0.19124e-09 /)
      kbo(:,58, 3) = (/ &
        & 0.16535e-09,0.16955e-09,0.18769e-09,0.18586e-09,0.18358e-09 /)
      kbo(:,59, 3) = (/ &
        & 0.18472e-09,0.17614e-09,0.20835e-09,0.19900e-09,0.17587e-09 /)
      kbo(:,13, 4) = (/ &
        & 0.14276e-07,0.14530e-07,0.14762e-07,0.14823e-07,0.15070e-07 /)
      kbo(:,14, 4) = (/ &
        & 0.22710e-07,0.23419e-07,0.26577e-07,0.28008e-07,0.28298e-07 /)
      kbo(:,15, 4) = (/ &
        & 0.40218e-07,0.40306e-07,0.38786e-07,0.38421e-07,0.37982e-07 /)
      kbo(:,16, 4) = (/ &
        & 0.46010e-07,0.46709e-07,0.48658e-07,0.49166e-07,0.49018e-07 /)
      kbo(:,17, 4) = (/ &
        & 0.57896e-07,0.59606e-07,0.62582e-07,0.65981e-07,0.66467e-07 /)
      kbo(:,18, 4) = (/ &
        & 0.74731e-07,0.75116e-07,0.75181e-07,0.74922e-07,0.73535e-07 /)
      kbo(:,19, 4) = (/ &
        & 0.76222e-07,0.73788e-07,0.71345e-07,0.70864e-07,0.69839e-07 /)
      kbo(:,20, 4) = (/ &
        & 0.69638e-07,0.67680e-07,0.66694e-07,0.67021e-07,0.67066e-07 /)
      kbo(:,21, 4) = (/ &
        & 0.65779e-07,0.64200e-07,0.63508e-07,0.64106e-07,0.64461e-07 /)
      kbo(:,22, 4) = (/ &
        & 0.61488e-07,0.60248e-07,0.59719e-07,0.60704e-07,0.61392e-07 /)
      kbo(:,23, 4) = (/ &
        & 0.56738e-07,0.55143e-07,0.55071e-07,0.56796e-07,0.58031e-07 /)
      kbo(:,24, 4) = (/ &
        & 0.53299e-07,0.52091e-07,0.52308e-07,0.54157e-07,0.55094e-07 /)
      kbo(:,25, 4) = (/ &
        & 0.49763e-07,0.48954e-07,0.49068e-07,0.51533e-07,0.52367e-07 /)
      kbo(:,26, 4) = (/ &
        & 0.46006e-07,0.45410e-07,0.45860e-07,0.48840e-07,0.49788e-07 /)
      kbo(:,27, 4) = (/ &
        & 0.42208e-07,0.41876e-07,0.43006e-07,0.46350e-07,0.47032e-07 /)
      kbo(:,28, 4) = (/ &
        & 0.38508e-07,0.38430e-07,0.40481e-07,0.43465e-07,0.43170e-07 /)
      kbo(:,29, 4) = (/ &
        & 0.33913e-07,0.34466e-07,0.37202e-07,0.38288e-07,0.38327e-07 /)
      kbo(:,30, 4) = (/ &
        & 0.29454e-07,0.30842e-07,0.33204e-07,0.33354e-07,0.33727e-07 /)
      kbo(:,31, 4) = (/ &
        & 0.25253e-07,0.27183e-07,0.28228e-07,0.27946e-07,0.28495e-07 /)
      kbo(:,32, 4) = (/ &
        & 0.21784e-07,0.23351e-07,0.23372e-07,0.23449e-07,0.23246e-07 /)
      kbo(:,33, 4) = (/ &
        & 0.18910e-07,0.19134e-07,0.18984e-07,0.19294e-07,0.18955e-07 /)
      kbo(:,34, 4) = (/ &
        & 0.15933e-07,0.15755e-07,0.16059e-07,0.15913e-07,0.15386e-07 /)
      kbo(:,35, 4) = (/ &
        & 0.13356e-07,0.13247e-07,0.13429e-07,0.13202e-07,0.12675e-07 /)
      kbo(:,36, 4) = (/ &
        & 0.11207e-07,0.11196e-07,0.11048e-07,0.10870e-07,0.10431e-07 /)
      kbo(:,37, 4) = (/ &
        & 0.95811e-08,0.94647e-08,0.93875e-08,0.90968e-08,0.88553e-08 /)
      kbo(:,38, 4) = (/ &
        & 0.81243e-08,0.80255e-08,0.78559e-08,0.75538e-08,0.74057e-08 /)
      kbo(:,39, 4) = (/ &
        & 0.66871e-08,0.66553e-08,0.65003e-08,0.62809e-08,0.60862e-08 /)
      kbo(:,40, 4) = (/ &
        & 0.58254e-08,0.57657e-08,0.56185e-08,0.54242e-08,0.52135e-08 /)
      kbo(:,41, 4) = (/ &
        & 0.50967e-08,0.50027e-08,0.48304e-08,0.46813e-08,0.44864e-08 /)
      kbo(:,42, 4) = (/ &
        & 0.43731e-08,0.43157e-08,0.41432e-08,0.39968e-08,0.38854e-08 /)
      kbo(:,43, 4) = (/ &
        & 0.37430e-08,0.37088e-08,0.35491e-08,0.34012e-08,0.33022e-08 /)
      kbo(:,44, 4) = (/ &
        & 0.32207e-08,0.31034e-08,0.30690e-08,0.29015e-08,0.27644e-08 /)
      kbo(:,45, 4) = (/ &
        & 0.27111e-08,0.25582e-08,0.26092e-08,0.24352e-08,0.23234e-08 /)
      kbo(:,46, 4) = (/ &
        & 0.22675e-08,0.21455e-08,0.21930e-08,0.20490e-08,0.19277e-08 /)
      kbo(:,47, 4) = (/ &
        & 0.18722e-08,0.18163e-08,0.18222e-08,0.17256e-08,0.16025e-08 /)
      kbo(:,48, 4) = (/ &
        & 0.15670e-08,0.15133e-08,0.14751e-08,0.14433e-08,0.13269e-08 /)
      kbo(:,49, 4) = (/ &
        & 0.12576e-08,0.12106e-08,0.11779e-08,0.11664e-08,0.10722e-08 /)
      kbo(:,50, 4) = (/ &
        & 0.10308e-08,0.10019e-08,0.98151e-09,0.96758e-09,0.89739e-09 /)
      kbo(:,51, 4) = (/ &
        & 0.84050e-09,0.85047e-09,0.83131e-09,0.81346e-09,0.77303e-09 /)
      kbo(:,52, 4) = (/ &
        & 0.67669e-09,0.70190e-09,0.68695e-09,0.66858e-09,0.63719e-09 /)
      kbo(:,53, 4) = (/ &
        & 0.52755e-09,0.56097e-09,0.54716e-09,0.53877e-09,0.51047e-09 /)
      kbo(:,54, 4) = (/ &
        & 0.44864e-09,0.48984e-09,0.48831e-09,0.46728e-09,0.45462e-09 /)
      kbo(:,55, 4) = (/ &
        & 0.40938e-09,0.45501e-09,0.45212e-09,0.43586e-09,0.42245e-09 /)
      kbo(:,56, 4) = (/ &
        & 0.38293e-09,0.40217e-09,0.41760e-09,0.39645e-09,0.38652e-09 /)
      kbo(:,57, 4) = (/ &
        & 0.35808e-09,0.34306e-09,0.38440e-09,0.37442e-09,0.33472e-09 /)
      kbo(:,58, 4) = (/ &
        & 0.33278e-09,0.31839e-09,0.35327e-09,0.33061e-09,0.29093e-09 /)
      kbo(:,59, 4) = (/ &
        & 0.32589e-09,0.30766e-09,0.30185e-09,0.35182e-09,0.34474e-09 /)
      kbo(:,13, 5) = (/ &
        & 0.19090e-07,0.19323e-07,0.21491e-07,0.23162e-07,0.23970e-07 /)
      kbo(:,14, 5) = (/ &
        & 0.37888e-07,0.37108e-07,0.33727e-07,0.34146e-07,0.33930e-07 /)
      kbo(:,15, 5) = (/ &
        & 0.46395e-07,0.47265e-07,0.48201e-07,0.50512e-07,0.51101e-07 /)
      kbo(:,16, 5) = (/ &
        & 0.60743e-07,0.64371e-07,0.67862e-07,0.71479e-07,0.74200e-07 /)
      kbo(:,17, 5) = (/ &
        & 0.79052e-07,0.79011e-07,0.77558e-07,0.75900e-07,0.76450e-07 /)
      kbo(:,18, 5) = (/ &
        & 0.75325e-07,0.74009e-07,0.72866e-07,0.72803e-07,0.73869e-07 /)
      kbo(:,19, 5) = (/ &
        & 0.74009e-07,0.74054e-07,0.73970e-07,0.73800e-07,0.75638e-07 /)
      kbo(:,20, 5) = (/ &
        & 0.73077e-07,0.73306e-07,0.72248e-07,0.73120e-07,0.74630e-07 /)
      kbo(:,21, 5) = (/ &
        & 0.68928e-07,0.70100e-07,0.69203e-07,0.69478e-07,0.71860e-07 /)
      kbo(:,22, 5) = (/ &
        & 0.65324e-07,0.66570e-07,0.66457e-07,0.66345e-07,0.68314e-07 /)
      kbo(:,23, 5) = (/ &
        & 0.62411e-07,0.63996e-07,0.63443e-07,0.63576e-07,0.65766e-07 /)
      kbo(:,24, 5) = (/ &
        & 0.60058e-07,0.60956e-07,0.60176e-07,0.60222e-07,0.63287e-07 /)
      kbo(:,25, 5) = (/ &
        & 0.57223e-07,0.58225e-07,0.58348e-07,0.58584e-07,0.61933e-07 /)
      kbo(:,26, 5) = (/ &
        & 0.55089e-07,0.55723e-07,0.55839e-07,0.56337e-07,0.60335e-07 /)
      kbo(:,27, 5) = (/ &
        & 0.52294e-07,0.51745e-07,0.52750e-07,0.52701e-07,0.57676e-07 /)
      kbo(:,28, 5) = (/ &
        & 0.48915e-07,0.48234e-07,0.48708e-07,0.49873e-07,0.54442e-07 /)
      kbo(:,29, 5) = (/ &
        & 0.43357e-07,0.43230e-07,0.43679e-07,0.47285e-07,0.49519e-07 /)
      kbo(:,30, 5) = (/ &
        & 0.37379e-07,0.38427e-07,0.39703e-07,0.43492e-07,0.43278e-07 /)
      kbo(:,31, 5) = (/ &
        & 0.31354e-07,0.32238e-07,0.35376e-07,0.37358e-07,0.37130e-07 /)
      kbo(:,32, 5) = (/ &
        & 0.26553e-07,0.27801e-07,0.30978e-07,0.30698e-07,0.31234e-07 /)
      kbo(:,33, 5) = (/ &
        & 0.21542e-07,0.24274e-07,0.24944e-07,0.25194e-07,0.25415e-07 /)
      kbo(:,34, 5) = (/ &
        & 0.19097e-07,0.20582e-07,0.20324e-07,0.21006e-07,0.20944e-07 /)
      kbo(:,35, 5) = (/ &
        & 0.16377e-07,0.16881e-07,0.16957e-07,0.16743e-07,0.16958e-07 /)
      kbo(:,36, 5) = (/ &
        & 0.13727e-07,0.13834e-07,0.13766e-07,0.13776e-07,0.13546e-07 /)
      kbo(:,37, 5) = (/ &
        & 0.11550e-07,0.11601e-07,0.11757e-07,0.11723e-07,0.11413e-07 /)
      kbo(:,38, 5) = (/ &
        & 0.98076e-08,0.96320e-08,0.10028e-07,0.98197e-08,0.91408e-08 /)
      kbo(:,39, 5) = (/ &
        & 0.80861e-08,0.80113e-08,0.81586e-08,0.80121e-08,0.75021e-08 /)
      kbo(:,40, 5) = (/ &
        & 0.70348e-08,0.69980e-08,0.71058e-08,0.69171e-08,0.64103e-08 /)
      kbo(:,41, 5) = (/ &
        & 0.61395e-08,0.60379e-08,0.61651e-08,0.59006e-08,0.54433e-08 /)
      kbo(:,42, 5) = (/ &
        & 0.51740e-08,0.51391e-08,0.53717e-08,0.50506e-08,0.46901e-08 /)
      kbo(:,43, 5) = (/ &
        & 0.44374e-08,0.44002e-08,0.45405e-08,0.42888e-08,0.39390e-08 /)
      kbo(:,44, 5) = (/ &
        & 0.36635e-08,0.37555e-08,0.37320e-08,0.35598e-08,0.33280e-08 /)
      kbo(:,45, 5) = (/ &
        & 0.30833e-08,0.31320e-08,0.30264e-08,0.29827e-08,0.28298e-08 /)
      kbo(:,46, 5) = (/ &
        & 0.25366e-08,0.26077e-08,0.24905e-08,0.24281e-08,0.22727e-08 /)
      kbo(:,47, 5) = (/ &
        & 0.20576e-08,0.22029e-08,0.20905e-08,0.21040e-08,0.19027e-08 /)
      kbo(:,48, 5) = (/ &
        & 0.16047e-08,0.18190e-08,0.17008e-08,0.17298e-08,0.16059e-08 /)
      kbo(:,49, 5) = (/ &
        & 0.12276e-08,0.14135e-08,0.13565e-08,0.13704e-08,0.13029e-08 /)
      kbo(:,50, 5) = (/ &
        & 0.98291e-09,0.11837e-08,0.11000e-08,0.11342e-08,0.10621e-08 /)
      kbo(:,51, 5) = (/ &
        & 0.79374e-09,0.97756e-09,0.90252e-09,0.90527e-09,0.86815e-09 /)
      kbo(:,52, 5) = (/ &
        & 0.64781e-09,0.78454e-09,0.75690e-09,0.74124e-09,0.73195e-09 /)
      kbo(:,53, 5) = (/ &
        & 0.51536e-09,0.61158e-09,0.60936e-09,0.59007e-09,0.58458e-09 /)
      kbo(:,54, 5) = (/ &
        & 0.46178e-09,0.51944e-09,0.52167e-09,0.53965e-09,0.50524e-09 /)
      kbo(:,55, 5) = (/ &
        & 0.44467e-09,0.42857e-09,0.50799e-09,0.47528e-09,0.43900e-09 /)
      kbo(:,56, 5) = (/ &
        & 0.39667e-09,0.37862e-09,0.45808e-09,0.43270e-09,0.38817e-09 /)
      kbo(:,57, 5) = (/ &
        & 0.35926e-09,0.35410e-09,0.38962e-09,0.37502e-09,0.40935e-09 /)
      kbo(:,58, 5) = (/ &
        & 0.31517e-09,0.32964e-09,0.29323e-09,0.39945e-09,0.40389e-09 /)
      kbo(:,59, 5) = (/ &
        & 0.36198e-09,0.38633e-09,0.41096e-09,0.53914e-09,0.57631e-09 /)
      kbo(:,13, 6) = (/ &
        & 0.23095e-07,0.23025e-07,0.25126e-07,0.25618e-07,0.24969e-07 /)
      kbo(:,14, 6) = (/ &
        & 0.31573e-07,0.32360e-07,0.33220e-07,0.32611e-07,0.32150e-07 /)
      kbo(:,15, 6) = (/ &
        & 0.45219e-07,0.45787e-07,0.47088e-07,0.49543e-07,0.54072e-07 /)
      kbo(:,16, 6) = (/ &
        & 0.65293e-07,0.67448e-07,0.64557e-07,0.63976e-07,0.64905e-07 /)
      kbo(:,17, 6) = (/ &
        & 0.64862e-07,0.63259e-07,0.62851e-07,0.62500e-07,0.63112e-07 /)
      kbo(:,18, 6) = (/ &
        & 0.61849e-07,0.62108e-07,0.60565e-07,0.60920e-07,0.61810e-07 /)
      kbo(:,19, 6) = (/ &
        & 0.63930e-07,0.63195e-07,0.62478e-07,0.62282e-07,0.62250e-07 /)
      kbo(:,20, 6) = (/ &
        & 0.60100e-07,0.60269e-07,0.59919e-07,0.57578e-07,0.57933e-07 /)
      kbo(:,21, 6) = (/ &
        & 0.56465e-07,0.56674e-07,0.56992e-07,0.55969e-07,0.54719e-07 /)
      kbo(:,22, 6) = (/ &
        & 0.54280e-07,0.53760e-07,0.52615e-07,0.52261e-07,0.51523e-07 /)
      kbo(:,23, 6) = (/ &
        & 0.49921e-07,0.49472e-07,0.49168e-07,0.47959e-07,0.47449e-07 /)
      kbo(:,24, 6) = (/ &
        & 0.45803e-07,0.46271e-07,0.46322e-07,0.46536e-07,0.46494e-07 /)
      kbo(:,25, 6) = (/ &
        & 0.43723e-07,0.44225e-07,0.44324e-07,0.43726e-07,0.43579e-07 /)
      kbo(:,26, 6) = (/ &
        & 0.41617e-07,0.42588e-07,0.42306e-07,0.41086e-07,0.41943e-07 /)
      kbo(:,27, 6) = (/ &
        & 0.38855e-07,0.40231e-07,0.39090e-07,0.39461e-07,0.39072e-07 /)
      kbo(:,28, 6) = (/ &
        & 0.35912e-07,0.36691e-07,0.35670e-07,0.35644e-07,0.38295e-07 /)
      kbo(:,29, 6) = (/ &
        & 0.33357e-07,0.33134e-07,0.32394e-07,0.32909e-07,0.36234e-07 /)
      kbo(:,30, 6) = (/ &
        & 0.30529e-07,0.29196e-07,0.29147e-07,0.30292e-07,0.33912e-07 /)
      kbo(:,31, 6) = (/ &
        & 0.27228e-07,0.27081e-07,0.26630e-07,0.30010e-07,0.28781e-07 /)
      kbo(:,32, 6) = (/ &
        & 0.24109e-07,0.24388e-07,0.25546e-07,0.26823e-07,0.26681e-07 /)
      kbo(:,33, 6) = (/ &
        & 0.21402e-07,0.22303e-07,0.24668e-07,0.24556e-07,0.24369e-07 /)
      kbo(:,34, 6) = (/ &
        & 0.18136e-07,0.20944e-07,0.21211e-07,0.21286e-07,0.21648e-07 /)
      kbo(:,35, 6) = (/ &
        & 0.16306e-07,0.17531e-07,0.17744e-07,0.18061e-07,0.18282e-07 /)
      kbo(:,36, 6) = (/ &
        & 0.13873e-07,0.14963e-07,0.15398e-07,0.15527e-07,0.15391e-07 /)
      kbo(:,37, 6) = (/ &
        & 0.11948e-07,0.12614e-07,0.12946e-07,0.12916e-07,0.13085e-07 /)
      kbo(:,38, 6) = (/ &
        & 0.98235e-08,0.10612e-07,0.10029e-07,0.10618e-07,0.10860e-07 /)
      kbo(:,39, 6) = (/ &
        & 0.81514e-08,0.84716e-08,0.81123e-08,0.83644e-08,0.81668e-08 /)
      kbo(:,40, 6) = (/ &
        & 0.68179e-08,0.69030e-08,0.69393e-08,0.69969e-08,0.71027e-08 /)
      kbo(:,41, 6) = (/ &
        & 0.59350e-08,0.60668e-08,0.59026e-08,0.60181e-08,0.60779e-08 /)
      kbo(:,42, 6) = (/ &
        & 0.51181e-08,0.52127e-08,0.48788e-08,0.51397e-08,0.50230e-08 /)
      kbo(:,43, 6) = (/ &
        & 0.42653e-08,0.44600e-08,0.41100e-08,0.44735e-08,0.42607e-08 /)
      kbo(:,44, 6) = (/ &
        & 0.34724e-08,0.37628e-08,0.35340e-08,0.38309e-08,0.36188e-08 /)
      kbo(:,45, 6) = (/ &
        & 0.27994e-08,0.31690e-08,0.28599e-08,0.30290e-08,0.27730e-08 /)
      kbo(:,46, 6) = (/ &
        & 0.22089e-08,0.25761e-08,0.23856e-08,0.24874e-08,0.23603e-08 /)
      kbo(:,47, 6) = (/ &
        & 0.18078e-08,0.20304e-08,0.19457e-08,0.19366e-08,0.19286e-08 /)
      kbo(:,48, 6) = (/ &
        & 0.14716e-08,0.15703e-08,0.17393e-08,0.14836e-08,0.15316e-08 /)
      kbo(:,49, 6) = (/ &
        & 0.11334e-08,0.12901e-08,0.13556e-08,0.11610e-08,0.11617e-08 /)
      kbo(:,50, 6) = (/ &
        & 0.90881e-09,0.10323e-08,0.11378e-08,0.95509e-09,0.96291e-09 /)
      kbo(:,51, 6) = (/ &
        & 0.76751e-09,0.81710e-09,0.97432e-09,0.82408e-09,0.81205e-09 /)
      kbo(:,52, 6) = (/ &
        & 0.62668e-09,0.66223e-09,0.76870e-09,0.68347e-09,0.65771e-09 /)
      kbo(:,53, 6) = (/ &
        & 0.50547e-09,0.49991e-09,0.61494e-09,0.55640e-09,0.52803e-09 /)
      kbo(:,54, 6) = (/ &
        & 0.42841e-09,0.42678e-09,0.51796e-09,0.46340e-09,0.44830e-09 /)
      kbo(:,55, 6) = (/ &
        & 0.40234e-09,0.40065e-09,0.45944e-09,0.42252e-09,0.44365e-09 /)
      kbo(:,56, 6) = (/ &
        & 0.36764e-09,0.35937e-09,0.36570e-09,0.44631e-09,0.45684e-09 /)
      kbo(:,57, 6) = (/ &
        & 0.33321e-09,0.29808e-09,0.31056e-09,0.44585e-09,0.41122e-09 /)
      kbo(:,58, 6) = (/ &
        & 0.31198e-09,0.29542e-09,0.33327e-09,0.43871e-09,0.45291e-09 /)
      kbo(:,59, 6) = (/ &
        & 0.38710e-09,0.42412e-09,0.44197e-09,0.49964e-09,0.70387e-09 /)
      kbo(:,13, 7) = (/ &
        & 0.30377e-07,0.31586e-07,0.27647e-07,0.27937e-07,0.28036e-07 /)
      kbo(:,14, 7) = (/ &
        & 0.37766e-07,0.39819e-07,0.39822e-07,0.40069e-07,0.42091e-07 /)
      kbo(:,15, 7) = (/ &
        & 0.57996e-07,0.64474e-07,0.69368e-07,0.70909e-07,0.70748e-07 /)
      kbo(:,16, 7) = (/ &
        & 0.73220e-07,0.70124e-07,0.69135e-07,0.68058e-07,0.66524e-07 /)
      kbo(:,17, 7) = (/ &
        & 0.66529e-07,0.66306e-07,0.63797e-07,0.63551e-07,0.63462e-07 /)
      kbo(:,18, 7) = (/ &
        & 0.66492e-07,0.65156e-07,0.66323e-07,0.64485e-07,0.63285e-07 /)
      kbo(:,19, 7) = (/ &
        & 0.62980e-07,0.62900e-07,0.62718e-07,0.61114e-07,0.59765e-07 /)
      kbo(:,20, 7) = (/ &
        & 0.59754e-07,0.58066e-07,0.59540e-07,0.58926e-07,0.57835e-07 /)
      kbo(:,21, 7) = (/ &
        & 0.57368e-07,0.55161e-07,0.55685e-07,0.55360e-07,0.53982e-07 /)
      kbo(:,22, 7) = (/ &
        & 0.51435e-07,0.49998e-07,0.50952e-07,0.50442e-07,0.49717e-07 /)
      kbo(:,23, 7) = (/ &
        & 0.47663e-07,0.46845e-07,0.47849e-07,0.48876e-07,0.48885e-07 /)
      kbo(:,24, 7) = (/ &
        & 0.47926e-07,0.45619e-07,0.45793e-07,0.46467e-07,0.45938e-07 /)
      kbo(:,25, 7) = (/ &
        & 0.44687e-07,0.43904e-07,0.44284e-07,0.44176e-07,0.45520e-07 /)
      kbo(:,26, 7) = (/ &
        & 0.42751e-07,0.41938e-07,0.42889e-07,0.42927e-07,0.43868e-07 /)
      kbo(:,27, 7) = (/ &
        & 0.40180e-07,0.40529e-07,0.40621e-07,0.40949e-07,0.41005e-07 /)
      kbo(:,28, 7) = (/ &
        & 0.35890e-07,0.36716e-07,0.37875e-07,0.38308e-07,0.37626e-07 /)
      kbo(:,29, 7) = (/ &
        & 0.31499e-07,0.33284e-07,0.32725e-07,0.32493e-07,0.35018e-07 /)
      kbo(:,30, 7) = (/ &
        & 0.29364e-07,0.28675e-07,0.28942e-07,0.28761e-07,0.33960e-07 /)
      kbo(:,31, 7) = (/ &
        & 0.25558e-07,0.23679e-07,0.24292e-07,0.26053e-07,0.29211e-07 /)
      kbo(:,32, 7) = (/ &
        & 0.20860e-07,0.21491e-07,0.20910e-07,0.25598e-07,0.24209e-07 /)
      kbo(:,33, 7) = (/ &
        & 0.18874e-07,0.18554e-07,0.21206e-07,0.20708e-07,0.21100e-07 /)
      kbo(:,34, 7) = (/ &
        & 0.18632e-07,0.18625e-07,0.20707e-07,0.19570e-07,0.18956e-07 /)
      kbo(:,35, 7) = (/ &
        & 0.15958e-07,0.19141e-07,0.19004e-07,0.19249e-07,0.17793e-07 /)
      kbo(:,36, 7) = (/ &
        & 0.14552e-07,0.16561e-07,0.16607e-07,0.16784e-07,0.16326e-07 /)
      kbo(:,37, 7) = (/ &
        & 0.13127e-07,0.14300e-07,0.14021e-07,0.14385e-07,0.13328e-07 /)
      kbo(:,38, 7) = (/ &
        & 0.11514e-07,0.12356e-07,0.12677e-07,0.12181e-07,0.11774e-07 /)
      kbo(:,39, 7) = (/ &
        & 0.93434e-08,0.10196e-07,0.10605e-07,0.10201e-07,0.10584e-07 /)
      kbo(:,40, 7) = (/ &
        & 0.81790e-08,0.89000e-08,0.85315e-08,0.89663e-08,0.91635e-08 /)
      kbo(:,41, 7) = (/ &
        & 0.65541e-08,0.74884e-08,0.72364e-08,0.72692e-08,0.75649e-08 /)
      kbo(:,42, 7) = (/ &
        & 0.54665e-08,0.61796e-08,0.61564e-08,0.61304e-08,0.64285e-08 /)
      kbo(:,43, 7) = (/ &
        & 0.43531e-08,0.47798e-08,0.51393e-08,0.49135e-08,0.53520e-08 /)
      kbo(:,44, 7) = (/ &
        & 0.35872e-08,0.38233e-08,0.42659e-08,0.39384e-08,0.44541e-08 /)
      kbo(:,45, 7) = (/ &
        & 0.28156e-08,0.32775e-08,0.36262e-08,0.32518e-08,0.36805e-08 /)
      kbo(:,46, 7) = (/ &
        & 0.23879e-08,0.26299e-08,0.28972e-08,0.27379e-08,0.30333e-08 /)
      kbo(:,47, 7) = (/ &
        & 0.19282e-08,0.22066e-08,0.23812e-08,0.23512e-08,0.23794e-08 /)
      kbo(:,48, 7) = (/ &
        & 0.15092e-08,0.18255e-08,0.17414e-08,0.19322e-08,0.19399e-08 /)
      kbo(:,49, 7) = (/ &
        & 0.11905e-08,0.13964e-08,0.14306e-08,0.14791e-08,0.14939e-08 /)
      kbo(:,50, 7) = (/ &
        & 0.98537e-09,0.10687e-08,0.11753e-08,0.11334e-08,0.13178e-08 /)
      kbo(:,51, 7) = (/ &
        & 0.84255e-09,0.88069e-09,0.95073e-09,0.92632e-09,0.10457e-08 /)
      kbo(:,52, 7) = (/ &
        & 0.68238e-09,0.70376e-09,0.74795e-09,0.75152e-09,0.78131e-09 /)
      kbo(:,53, 7) = (/ &
        & 0.56271e-09,0.58527e-09,0.61397e-09,0.56343e-09,0.61138e-09 /)
      kbo(:,54, 7) = (/ &
        & 0.52493e-09,0.46040e-09,0.53769e-09,0.51459e-09,0.52912e-09 /)
      kbo(:,55, 7) = (/ &
        & 0.40372e-09,0.38720e-09,0.40004e-09,0.56294e-09,0.55844e-09 /)
      kbo(:,56, 7) = (/ &
        & 0.37372e-09,0.35358e-09,0.39920e-09,0.52819e-09,0.50147e-09 /)
      kbo(:,57, 7) = (/ &
        & 0.31149e-09,0.39454e-09,0.38951e-09,0.52086e-09,0.54542e-09 /)
      kbo(:,58, 7) = (/ &
        & 0.30564e-09,0.36251e-09,0.38551e-09,0.43845e-09,0.61772e-09 /)
      kbo(:,59, 7) = (/ &
        & 0.46934e-09,0.57639e-09,0.58591e-09,0.63021e-09,0.71158e-09 /)
      kbo(:,13, 8) = (/ &
        & 0.34320e-07,0.31607e-07,0.29840e-07,0.29114e-07,0.28831e-07 /)
      kbo(:,14, 8) = (/ &
        & 0.38157e-07,0.37907e-07,0.40351e-07,0.45015e-07,0.44786e-07 /)
      kbo(:,15, 8) = (/ &
        & 0.71231e-07,0.71647e-07,0.71034e-07,0.71647e-07,0.71755e-07 /)
      kbo(:,16, 8) = (/ &
        & 0.72049e-07,0.69075e-07,0.67707e-07,0.67019e-07,0.66780e-07 /)
      kbo(:,17, 8) = (/ &
        & 0.69751e-07,0.66211e-07,0.66017e-07,0.63095e-07,0.63343e-07 /)
      kbo(:,18, 8) = (/ &
        & 0.67728e-07,0.66581e-07,0.64787e-07,0.62981e-07,0.62245e-07 /)
      kbo(:,19, 8) = (/ &
        & 0.65864e-07,0.63789e-07,0.62712e-07,0.62065e-07,0.61005e-07 /)
      kbo(:,20, 8) = (/ &
        & 0.61816e-07,0.63755e-07,0.63424e-07,0.61945e-07,0.58720e-07 /)
      kbo(:,21, 8) = (/ &
        & 0.59112e-07,0.58061e-07,0.57019e-07,0.54795e-07,0.56069e-07 /)
      kbo(:,22, 8) = (/ &
        & 0.56217e-07,0.53887e-07,0.54812e-07,0.52500e-07,0.53303e-07 /)
      kbo(:,23, 8) = (/ &
        & 0.54428e-07,0.52930e-07,0.53278e-07,0.52797e-07,0.51840e-07 /)
      kbo(:,24, 8) = (/ &
        & 0.51236e-07,0.52532e-07,0.53348e-07,0.51715e-07,0.53224e-07 /)
      kbo(:,25, 8) = (/ &
        & 0.49989e-07,0.50872e-07,0.49932e-07,0.52702e-07,0.51493e-07 /)
      kbo(:,26, 8) = (/ &
        & 0.49845e-07,0.48733e-07,0.48348e-07,0.51346e-07,0.51109e-07 /)
      kbo(:,27, 8) = (/ &
        & 0.43883e-07,0.43853e-07,0.46523e-07,0.47281e-07,0.47292e-07 /)
      kbo(:,28, 8) = (/ &
        & 0.41424e-07,0.42057e-07,0.43773e-07,0.43422e-07,0.41438e-07 /)
      kbo(:,29, 8) = (/ &
        & 0.37736e-07,0.34915e-07,0.37971e-07,0.38437e-07,0.38122e-07 /)
      kbo(:,30, 8) = (/ &
        & 0.30209e-07,0.32936e-07,0.31853e-07,0.30285e-07,0.31746e-07 /)
      kbo(:,31, 8) = (/ &
        & 0.25886e-07,0.26990e-07,0.27039e-07,0.26019e-07,0.34246e-07 /)
      kbo(:,32, 8) = (/ &
        & 0.24750e-07,0.20653e-07,0.21921e-07,0.25087e-07,0.25874e-07 /)
      kbo(:,33, 8) = (/ &
        & 0.19410e-07,0.18820e-07,0.18768e-07,0.23223e-07,0.20942e-07 /)
      kbo(:,34, 8) = (/ &
        & 0.16037e-07,0.16060e-07,0.19012e-07,0.17686e-07,0.18319e-07 /)
      kbo(:,35, 8) = (/ &
        & 0.16085e-07,0.15072e-07,0.16472e-07,0.15719e-07,0.16406e-07 /)
      kbo(:,36, 8) = (/ &
        & 0.15014e-07,0.17144e-07,0.16353e-07,0.15223e-07,0.14884e-07 /)
      kbo(:,37, 8) = (/ &
        & 0.12909e-07,0.15628e-07,0.16086e-07,0.15318e-07,0.15605e-07 /)
      kbo(:,38, 8) = (/ &
        & 0.11803e-07,0.12970e-07,0.13587e-07,0.13257e-07,0.13920e-07 /)
      kbo(:,39, 8) = (/ &
        & 0.10299e-07,0.10951e-07,0.11006e-07,0.11507e-07,0.10553e-07 /)
      kbo(:,40, 8) = (/ &
        & 0.87605e-08,0.10094e-07,0.10641e-07,0.94199e-08,0.97115e-08 /)
      kbo(:,41, 8) = (/ &
        & 0.69747e-08,0.82105e-08,0.93516e-08,0.90234e-08,0.91657e-08 /)
      kbo(:,42, 8) = (/ &
        & 0.60201e-08,0.73523e-08,0.76249e-08,0.76962e-08,0.80489e-08 /)
      kbo(:,43, 8) = (/ &
        & 0.50249e-08,0.64035e-08,0.62997e-08,0.63745e-08,0.65773e-08 /)
      kbo(:,44, 8) = (/ &
        & 0.43021e-08,0.55682e-08,0.52391e-08,0.55432e-08,0.53417e-08 /)
      kbo(:,45, 8) = (/ &
        & 0.34659e-08,0.41011e-08,0.41998e-08,0.45328e-08,0.45452e-08 /)
      kbo(:,46, 8) = (/ &
        & 0.26629e-08,0.30573e-08,0.34050e-08,0.36018e-08,0.38146e-08 /)
      kbo(:,47, 8) = (/ &
        & 0.20352e-08,0.25120e-08,0.29668e-08,0.27818e-08,0.34015e-08 /)
      kbo(:,48, 8) = (/ &
        & 0.16537e-08,0.17568e-08,0.23894e-08,0.22154e-08,0.25802e-08 /)
      kbo(:,49, 8) = (/ &
        & 0.13981e-08,0.14349e-08,0.17246e-08,0.17767e-08,0.19090e-08 /)
      kbo(:,50, 8) = (/ &
        & 0.10918e-08,0.11356e-08,0.12258e-08,0.14996e-08,0.12493e-08 /)
      kbo(:,51, 8) = (/ &
        & 0.96204e-09,0.88786e-09,0.10061e-08,0.12415e-08,0.10774e-08 /)
      kbo(:,52, 8) = (/ &
        & 0.79848e-09,0.70289e-09,0.84515e-09,0.10143e-08,0.85552e-09 /)
      kbo(:,53, 8) = (/ &
        & 0.60435e-09,0.54746e-09,0.63806e-09,0.74615e-09,0.64507e-09 /)
      kbo(:,54, 8) = (/ &
        & 0.47378e-09,0.48059e-09,0.54886e-09,0.73215e-09,0.65721e-09 /)
      kbo(:,55, 8) = (/ &
        & 0.45346e-09,0.46291e-09,0.55380e-09,0.67829e-09,0.56756e-09 /)
      kbo(:,56, 8) = (/ &
        & 0.43938e-09,0.46043e-09,0.50980e-09,0.62685e-09,0.70094e-09 /)
      kbo(:,57, 8) = (/ &
        & 0.42587e-09,0.43184e-09,0.47819e-09,0.57152e-09,0.76528e-09 /)
      kbo(:,58, 8) = (/ &
        & 0.47403e-09,0.46387e-09,0.50904e-09,0.58886e-09,0.70162e-09 /)
      kbo(:,59, 8) = (/ &
        & 0.54448e-09,0.50172e-09,0.65155e-09,0.65748e-09,0.98321e-09 /)
      kbo(:,13, 9) = (/ &
        & 0.10995e-05,0.11095e-05,0.11168e-05,0.11200e-05,0.11274e-05 /)
      kbo(:,14, 9) = (/ &
        & 0.73340e-06,0.73567e-06,0.73740e-06,0.73330e-06,0.73919e-06 /)
      kbo(:,15, 9) = (/ &
        & 0.32510e-06,0.31252e-06,0.30243e-06,0.29146e-06,0.28830e-06 /)
      kbo(:,16, 9) = (/ &
        & 0.61567e-07,0.60590e-07,0.61057e-07,0.58821e-07,0.58536e-07 /)
      kbo(:,17, 9) = (/ &
        & 0.60009e-07,0.60924e-07,0.61205e-07,0.63591e-07,0.59950e-07 /)
      kbo(:,18, 9) = (/ &
        & 0.61458e-07,0.61692e-07,0.60339e-07,0.59878e-07,0.58575e-07 /)
      kbo(:,19, 9) = (/ &
        & 0.57878e-07,0.60299e-07,0.60236e-07,0.59512e-07,0.58126e-07 /)
      kbo(:,20, 9) = (/ &
        & 0.58329e-07,0.57451e-07,0.54760e-07,0.57082e-07,0.56805e-07 /)
      kbo(:,21, 9) = (/ &
        & 0.53092e-07,0.51700e-07,0.51833e-07,0.52853e-07,0.52467e-07 /)
      kbo(:,22, 9) = (/ &
        & 0.47591e-07,0.51357e-07,0.49075e-07,0.53548e-07,0.55924e-07 /)
      kbo(:,23, 9) = (/ &
        & 0.49724e-07,0.51803e-07,0.51793e-07,0.49922e-07,0.52665e-07 /)
      kbo(:,24, 9) = (/ &
        & 0.47737e-07,0.49279e-07,0.51207e-07,0.49000e-07,0.51613e-07 /)
      kbo(:,25, 9) = (/ &
        & 0.49014e-07,0.50174e-07,0.54886e-07,0.47520e-07,0.49798e-07 /)
      kbo(:,26, 9) = (/ &
        & 0.42783e-07,0.51200e-07,0.50600e-07,0.47620e-07,0.43709e-07 /)
      kbo(:,27, 9) = (/ &
        & 0.42685e-07,0.50611e-07,0.42800e-07,0.43026e-07,0.46518e-07 /)
      kbo(:,28, 9) = (/ &
        & 0.40023e-07,0.44433e-07,0.38380e-07,0.40945e-07,0.42005e-07 /)
      kbo(:,29, 9) = (/ &
        & 0.34641e-07,0.38943e-07,0.36153e-07,0.36773e-07,0.32051e-07 /)
      kbo(:,30, 9) = (/ &
        & 0.31936e-07,0.28774e-07,0.32629e-07,0.32074e-07,0.31547e-07 /)
      kbo(:,31, 9) = (/ &
        & 0.25468e-07,0.25946e-07,0.23671e-07,0.23770e-07,0.28704e-07 /)
      kbo(:,32, 9) = (/ &
        & 0.18317e-07,0.22069e-07,0.20055e-07,0.21665e-07,0.25653e-07 /)
      kbo(:,33, 9) = (/ &
        & 0.18319e-07,0.17920e-07,0.16523e-07,0.20049e-07,0.19951e-07 /)
      kbo(:,34, 9) = (/ &
        & 0.15127e-07,0.13546e-07,0.16257e-07,0.16818e-07,0.15661e-07 /)
      kbo(:,35, 9) = (/ &
        & 0.12192e-07,0.13829e-07,0.15792e-07,0.15440e-07,0.14596e-07 /)
      kbo(:,36, 9) = (/ &
        & 0.11593e-07,0.10509e-07,0.13211e-07,0.13026e-07,0.13917e-07 /)
      kbo(:,37, 9) = (/ &
        & 0.12302e-07,0.13196e-07,0.12558e-07,0.11760e-07,0.12490e-07 /)
      kbo(:,38, 9) = (/ &
        & 0.10116e-07,0.12498e-07,0.12546e-07,0.12890e-07,0.12908e-07 /)
      kbo(:,39, 9) = (/ &
        & 0.88258e-08,0.10400e-07,0.11293e-07,0.11361e-07,0.11468e-07 /)
      kbo(:,40, 9) = (/ &
        & 0.70753e-08,0.81481e-08,0.94292e-08,0.10943e-07,0.90300e-08 /)
      kbo(:,41, 9) = (/ &
        & 0.71994e-08,0.84394e-08,0.89108e-08,0.89407e-08,0.87875e-08 /)
      kbo(:,42, 9) = (/ &
        & 0.55536e-08,0.66846e-08,0.83965e-08,0.80560e-08,0.79305e-08 /)
      kbo(:,43, 9) = (/ &
        & 0.50223e-08,0.59958e-08,0.69583e-08,0.70648e-08,0.76990e-08 /)
      kbo(:,44, 9) = (/ &
        & 0.40990e-08,0.43884e-08,0.50706e-08,0.56081e-08,0.62414e-08 /)
      kbo(:,45, 9) = (/ &
        & 0.35590e-08,0.38731e-08,0.41923e-08,0.44278e-08,0.44950e-08 /)
      kbo(:,46, 9) = (/ &
        & 0.26814e-08,0.33691e-08,0.34101e-08,0.34324e-08,0.35321e-08 /)
      kbo(:,47, 9) = (/ &
        & 0.21424e-08,0.21249e-08,0.27532e-08,0.28475e-08,0.25748e-08 /)
      kbo(:,48, 9) = (/ &
        & 0.16514e-08,0.18931e-08,0.22507e-08,0.22575e-08,0.21238e-08 /)
      kbo(:,49, 9) = (/ &
        & 0.12235e-08,0.12503e-08,0.16643e-08,0.16742e-08,0.16438e-08 /)
      kbo(:,50, 9) = (/ &
        & 0.11340e-08,0.11248e-08,0.13120e-08,0.13854e-08,0.13503e-08 /)
      kbo(:,51, 9) = (/ &
        & 0.79176e-09,0.91681e-09,0.99908e-09,0.13532e-08,0.10405e-08 /)
      kbo(:,52, 9) = (/ &
        & 0.64785e-09,0.57185e-09,0.84784e-09,0.90912e-09,0.87721e-09 /)
      kbo(:,53, 9) = (/ &
        & 0.51330e-09,0.43209e-09,0.61659e-09,0.79798e-09,0.65017e-09 /)
      kbo(:,54, 9) = (/ &
        & 0.40227e-09,0.45562e-09,0.54691e-09,0.63160e-09,0.62902e-09 /)
      kbo(:,55, 9) = (/ &
        & 0.44280e-09,0.43833e-09,0.48132e-09,0.55748e-09,0.72672e-09 /)
      kbo(:,56, 9) = (/ &
        & 0.33767e-09,0.43448e-09,0.42774e-09,0.52401e-09,0.66273e-09 /)
      kbo(:,57, 9) = (/ &
        & 0.40113e-09,0.38794e-09,0.46286e-09,0.57261e-09,0.60773e-09 /)
      kbo(:,58, 9) = (/ &
        & 0.36624e-09,0.52965e-09,0.49530e-09,0.54114e-09,0.65708e-09 /)
      kbo(:,59, 9) = (/ &
        & 0.52598e-09,0.55940e-09,0.70094e-09,0.71749e-09,0.81086e-09 /)
      kbo(:,13,10) = (/ &
        & 0.75197e-05,0.74908e-05,0.74768e-05,0.74579e-05,0.74485e-05 /)
      kbo(:,14,10) = (/ &
        & 0.62427e-05,0.62400e-05,0.62314e-05,0.62357e-05,0.62230e-05 /)
      kbo(:,15,10) = (/ &
        & 0.51235e-05,0.51220e-05,0.51270e-05,0.51388e-05,0.51377e-05 /)
      kbo(:,16,10) = (/ &
        & 0.36653e-05,0.36812e-05,0.36844e-05,0.36893e-05,0.37175e-05 /)
      kbo(:,17,10) = (/ &
        & 0.10067e-05,0.10571e-05,0.10948e-05,0.11331e-05,0.11791e-05 /)
      kbo(:,18,10) = (/ &
        & 0.37963e-07,0.35028e-07,0.38085e-07,0.36252e-07,0.39741e-07 /)
      kbo(:,19,10) = (/ &
        & 0.58861e-07,0.39909e-07,0.43872e-07,0.52963e-07,0.37762e-07 /)
      kbo(:,20,10) = (/ &
        & 0.65438e-07,0.43429e-07,0.52709e-07,0.35811e-07,0.59833e-07 /)
      kbo(:,21,10) = (/ &
        & 0.50452e-07,0.50995e-07,0.40371e-07,0.51145e-07,0.52725e-07 /)
      kbo(:,22,10) = (/ &
        & 0.42139e-07,0.45011e-07,0.61867e-07,0.41292e-07,0.37916e-07 /)
      kbo(:,23,10) = (/ &
        & 0.30176e-07,0.29856e-07,0.39637e-07,0.38957e-07,0.64896e-07 /)
      kbo(:,24,10) = (/ &
        & 0.36010e-07,0.42155e-07,0.32787e-07,0.46750e-07,0.46940e-07 /)
      kbo(:,25,10) = (/ &
        & 0.34802e-07,0.41607e-07,0.40854e-07,0.61643e-07,0.53762e-07 /)
      kbo(:,26,10) = (/ &
        & 0.41295e-07,0.39697e-07,0.46005e-07,0.46334e-07,0.53334e-07 /)
      kbo(:,27,10) = (/ &
        & 0.61711e-07,0.29641e-07,0.51823e-07,0.42625e-07,0.36336e-07 /)
      kbo(:,28,10) = (/ &
        & 0.45196e-07,0.56637e-07,0.31716e-07,0.38569e-07,0.45693e-07 /)
      kbo(:,29,10) = (/ &
        & 0.47349e-07,0.38492e-07,0.26330e-07,0.30953e-07,0.33330e-07 /)
      kbo(:,30,10) = (/ &
        & 0.20700e-07,0.24999e-07,0.19626e-07,0.33645e-07,0.21883e-07 /)
      kbo(:,31,10) = (/ &
        & 0.31879e-07,0.26245e-07,0.28697e-07,0.26867e-07,0.26801e-07 /)
      kbo(:,32,10) = (/ &
        & 0.29616e-07,0.18927e-07,0.18903e-07,0.14917e-07,0.25602e-07 /)
      kbo(:,33,10) = (/ &
        & 0.22437e-07,0.26260e-07,0.17262e-07,0.13354e-07,0.18413e-07 /)
      kbo(:,34,10) = (/ &
        & 0.15957e-07,0.11226e-07,0.16852e-07,0.11987e-07,0.14358e-07 /)
      kbo(:,35,10) = (/ &
        & 0.11233e-07,0.90736e-08,0.13960e-07,0.76472e-08,0.11733e-07 /)
      kbo(:,36,10) = (/ &
        & 0.13919e-07,0.10081e-07,0.10035e-07,0.10345e-07,0.10622e-07 /)
      kbo(:,37,10) = (/ &
        & 0.76780e-08,0.12331e-07,0.10794e-07,0.16023e-07,0.11524e-07 /)
      kbo(:,38,10) = (/ &
        & 0.65416e-08,0.97484e-08,0.12132e-07,0.10472e-07,0.11363e-07 /)
      kbo(:,39,10) = (/ &
        & 0.78511e-08,0.70392e-08,0.91444e-08,0.84352e-08,0.95946e-08 /)
      kbo(:,40,10) = (/ &
        & 0.81878e-08,0.94957e-08,0.84996e-08,0.11246e-07,0.13024e-07 /)
      kbo(:,41,10) = (/ &
        & 0.65901e-08,0.80717e-08,0.78357e-08,0.67309e-08,0.85966e-08 /)
      kbo(:,42,10) = (/ &
        & 0.64210e-08,0.59979e-08,0.56936e-08,0.70018e-08,0.70433e-08 /)
      kbo(:,43,10) = (/ &
        & 0.40388e-08,0.71452e-08,0.63548e-08,0.84902e-08,0.75828e-08 /)
      kbo(:,44,10) = (/ &
        & 0.39142e-08,0.55915e-08,0.49863e-08,0.52254e-08,0.62790e-08 /)
      kbo(:,45,10) = (/ &
        & 0.42931e-08,0.31608e-08,0.46572e-08,0.47490e-08,0.59912e-08 /)
      kbo(:,46,10) = (/ &
        & 0.38722e-08,0.16146e-08,0.40010e-08,0.24242e-08,0.45711e-08 /)
      kbo(:,47,10) = (/ &
        & 0.14942e-08,0.28671e-08,0.27168e-08,0.40090e-08,0.42343e-08 /)
      kbo(:,48,10) = (/ &
        & 0.11911e-08,0.13582e-08,0.26580e-08,0.29275e-08,0.17855e-08 /)
      kbo(:,49,10) = (/ &
        & 0.14130e-08,0.10553e-08,0.10543e-08,0.11428e-08,0.14141e-08 /)
      kbo(:,50,10) = (/ &
        & 0.12182e-08,0.14973e-08,0.13182e-08,0.84197e-09,0.12115e-08 /)
      kbo(:,51,10) = (/ &
        & 0.81227e-09,0.90496e-09,0.77903e-09,0.83007e-09,0.86051e-09 /)
      kbo(:,52,10) = (/ &
        & 0.96715e-09,0.52504e-09,0.42702e-09,0.99435e-09,0.91829e-09 /)
      kbo(:,53,10) = (/ &
        & 0.37232e-09,0.22359e-09,0.89279e-09,0.85173e-09,0.51790e-09 /)
      kbo(:,54,10) = (/ &
        & 0.34402e-09,0.40116e-09,0.54696e-09,0.50848e-09,0.53123e-09 /)
      kbo(:,55,10) = (/ &
        & 0.66100e-09,0.65370e-09,0.58427e-09,0.74840e-09,0.49778e-09 /)
      kbo(:,56,10) = (/ &
        & 0.43138e-09,0.39155e-09,0.52944e-09,0.58374e-09,0.77481e-09 /)
      kbo(:,57,10) = (/ &
        & 0.48190e-09,0.37726e-09,0.54783e-09,0.43462e-09,0.46295e-09 /)
      kbo(:,58,10) = (/ &
        & 0.42276e-09,0.62831e-09,0.68493e-09,0.49089e-09,0.43799e-09 /)
      kbo(:,59,10) = (/ &
        & 0.37023e-09,0.90764e-09,0.36527e-09,0.99235e-09,0.10719e-08 /)
      kbo(:,13,11) = (/ &
        & 0.15119e-04,0.15135e-04,0.15140e-04,0.15181e-04,0.15209e-04 /)
      kbo(:,14,11) = (/ &
        & 0.12807e-04,0.12837e-04,0.12873e-04,0.12938e-04,0.12999e-04 /)
      kbo(:,15,11) = (/ &
        & 0.10789e-04,0.10839e-04,0.10921e-04,0.10986e-04,0.11078e-04 /)
      kbo(:,16,11) = (/ &
        & 0.90472e-05,0.91077e-05,0.91930e-05,0.92812e-05,0.93959e-05 /)
      kbo(:,17,11) = (/ &
        & 0.74085e-05,0.75116e-05,0.76103e-05,0.77238e-05,0.78364e-05 /)
      kbo(:,18,11) = (/ &
        & 0.47863e-05,0.49607e-05,0.51634e-05,0.53824e-05,0.55724e-05 /)
      kbo(:,19,11) = (/ &
        & 0.17849e-05,0.19797e-05,0.21641e-05,0.23597e-05,0.26015e-05 /)
      kbo(:,20,11) = (/ &
        & 0.14011e-06,0.26424e-06,0.39902e-06,0.56382e-06,0.75666e-06 /)
      kbo(:,21,11) = (/ &
        & 0.32681e-07,0.30855e-07,0.23688e-07,0.28954e-07,0.30262e-07 /)
      kbo(:,22,11) = (/ &
        & 0.39000e-07,0.34641e-07,0.36220e-07,0.29230e-07,0.25365e-07 /)
      kbo(:,23,11) = (/ &
        & 0.39936e-07,0.40586e-07,0.26460e-07,0.13886e-07,0.18108e-07 /)
      kbo(:,24,11) = (/ &
        & 0.34546e-07,0.30818e-07,0.33243e-07,0.31408e-07,0.37755e-07 /)
      kbo(:,25,11) = (/ &
        & 0.36078e-07,0.45586e-07,0.18117e-07,0.20176e-07,0.46256e-07 /)
      kbo(:,26,11) = (/ &
        & 0.61382e-07,0.31185e-07,0.38578e-07,0.18908e-07,0.43919e-07 /)
      kbo(:,27,11) = (/ &
        & 0.37585e-07,0.28323e-07,0.45638e-07,0.34261e-07,0.26227e-07 /)
      kbo(:,28,11) = (/ &
        & 0.41226e-07,0.24793e-07,0.23296e-07,0.20952e-07,0.27899e-07 /)
      kbo(:,29,11) = (/ &
        & 0.21318e-07,0.23768e-07,0.39220e-07,0.28896e-07,0.15703e-07 /)
      kbo(:,30,11) = (/ &
        & 0.25522e-07,0.29485e-07,0.39326e-07,0.29293e-07,0.36529e-07 /)
      kbo(:,31,11) = (/ &
        & 0.14494e-07,0.25417e-07,0.13732e-07,0.97827e-08,0.20014e-07 /)
      kbo(:,32,11) = (/ &
        & 0.14101e-07,0.26239e-07,0.22312e-07,0.10163e-07,0.17547e-07 /)
      kbo(:,33,11) = (/ &
        & 0.17347e-07,0.17261e-07,0.13014e-07,0.21130e-07,0.31576e-08 /)
      kbo(:,34,11) = (/ &
        & 0.11923e-07,0.13818e-07,0.14692e-07,0.14120e-07,0.12000e-07 /)
      kbo(:,35,11) = (/ &
        & 0.86917e-08,0.10083e-07,0.11872e-07,0.58578e-08,0.13194e-07 /)
      kbo(:,36,11) = (/ &
        & 0.74538e-08,0.94606e-08,0.85633e-08,0.15394e-07,0.81997e-08 /)
      kbo(:,37,11) = (/ &
        & 0.59982e-08,0.58805e-08,0.92255e-08,0.69472e-08,0.63632e-08 /)
      kbo(:,38,11) = (/ &
        & 0.75481e-08,0.82094e-08,0.10405e-07,0.62921e-08,0.70021e-08 /)
      kbo(:,39,11) = (/ &
        & 0.65770e-08,0.73715e-08,0.70899e-08,0.49884e-08,0.73567e-08 /)
      kbo(:,40,11) = (/ &
        & 0.62200e-08,0.79227e-08,0.65710e-08,0.35793e-08,0.48653e-08 /)
      kbo(:,41,11) = (/ &
        & 0.67810e-08,0.64933e-08,0.26651e-08,0.71067e-08,0.42136e-08 /)
      kbo(:,42,11) = (/ &
        & 0.32351e-08,0.79993e-08,0.25727e-08,0.70581e-08,0.58932e-08 /)
      kbo(:,43,11) = (/ &
        & 0.54331e-08,0.21653e-08,0.69372e-08,0.30142e-08,0.23071e-07 /)
      kbo(:,44,11) = (/ &
        & 0.26834e-08,0.43047e-08,0.44246e-08,0.29474e-08,0.52315e-07 /)
      kbo(:,45,11) = (/ &
        & 0.22521e-08,0.21920e-08,0.35952e-08,0.29799e-08,0.81164e-07 /)
      kbo(:,46,11) = (/ &
        & 0.28580e-08,0.12605e-08,0.64390e-09,0.24255e-07,0.96879e-07 /)
      kbo(:,47,11) = (/ &
        & 0.13005e-08,0.17967e-08,0.21618e-08,0.30225e-07,0.10319e-06 /)
      kbo(:,48,11) = (/ &
        & 0.13676e-08,0.96043e-09,0.14275e-08,0.39735e-07,0.11261e-06 /)
      kbo(:,49,11) = (/ &
        & 0.79619e-09,0.85338e-09,0.14300e-08,0.51821e-07,0.12169e-06 /)
      kbo(:,50,11) = (/ &
        & 0.49284e-09,0.21801e-09,0.75017e-08,0.50308e-07,0.11953e-06 /)
      kbo(:,51,11) = (/ &
        & 0.51956e-09,0.59927e-09,0.87276e-08,0.45028e-07,0.11141e-06 /)
      kbo(:,52,11) = (/ &
        & 0.35814e-09,0.78982e-09,0.10205e-07,0.45574e-07,0.10332e-06 /)
      kbo(:,53,11) = (/ &
        & 0.69729e-09,0.23757e-09,0.11741e-07,0.45086e-07,0.98023e-07 /)
      kbo(:,54,11) = (/ &
        & 0.38203e-09,0.28792e-09,0.72239e-08,0.35770e-07,0.80771e-07 /)
      kbo(:,55,11) = (/ &
        & 0.33870e-09,0.39698e-09,0.15883e-08,0.22568e-07,0.61465e-07 /)
      kbo(:,56,11) = (/ &
        & 0.50424e-09,0.25383e-09,0.46226e-09,0.12214e-07,0.43776e-07 /)
      kbo(:,57,11) = (/ &
        & 0.18824e-09,0.14340e-09,0.96547e-10,0.36771e-08,0.28437e-07 /)
      kbo(:,58,11) = (/ &
        & 0.53960e-09,0.71198e-09,0.40290e-09,0.38600e-09,0.14449e-07 /)
      kbo(:,59,11) = (/ &
        & 0.64570e-09,0.80856e-09,0.54439e-09,0.66021e-09,0.28306e-09 /)
      kbo(:,13,12) = (/ &
        & 0.35137e-04,0.35315e-04,0.35473e-04,0.35691e-04,0.35953e-04 /)
      kbo(:,14,12) = (/ &
        & 0.30387e-04,0.30535e-04,0.30693e-04,0.30906e-04,0.31121e-04 /)
      kbo(:,15,12) = (/ &
        & 0.26404e-04,0.26560e-04,0.26776e-04,0.26963e-04,0.27157e-04 /)
      kbo(:,16,12) = (/ &
        & 0.22908e-04,0.23161e-04,0.23420e-04,0.23636e-04,0.23864e-04 /)
      kbo(:,17,12) = (/ &
        & 0.19849e-04,0.20170e-04,0.20453e-04,0.20723e-04,0.21011e-04 /)
      kbo(:,18,12) = (/ &
        & 0.17158e-04,0.17516e-04,0.17820e-04,0.18149e-04,0.18467e-04 /)
      kbo(:,19,12) = (/ &
        & 0.14706e-04,0.15074e-04,0.15426e-04,0.15809e-04,0.16128e-04 /)
      kbo(:,20,12) = (/ &
        & 0.12200e-04,0.12654e-04,0.13122e-04,0.13561e-04,0.13942e-04 /)
      kbo(:,21,12) = (/ &
        & 0.88744e-05,0.95294e-05,0.10194e-04,0.10811e-04,0.11447e-04 /)
      kbo(:,22,12) = (/ &
        & 0.63063e-05,0.69160e-05,0.75170e-05,0.81696e-05,0.87829e-05 /)
      kbo(:,23,12) = (/ &
        & 0.42549e-05,0.48576e-05,0.54224e-05,0.60649e-05,0.65852e-05 /)
      kbo(:,24,12) = (/ &
        & 0.26155e-05,0.31537e-05,0.36816e-05,0.42795e-05,0.47356e-05 /)
      kbo(:,25,12) = (/ &
        & 0.14576e-05,0.18762e-05,0.23875e-05,0.29308e-05,0.33846e-05 /)
      kbo(:,26,12) = (/ &
        & 0.67369e-06,0.10096e-05,0.14730e-05,0.19592e-05,0.24356e-05 /)
      kbo(:,27,12) = (/ &
        & 0.27240e-06,0.59733e-06,0.98553e-06,0.13968e-05,0.18466e-05 /)
      kbo(:,28,12) = (/ &
        & 0.81179e-07,0.35063e-06,0.74692e-06,0.11081e-05,0.15613e-05 /)
      kbo(:,29,12) = (/ &
        & 0.94800e-07,0.40513e-06,0.73547e-06,0.10914e-05,0.16188e-05 /)
      kbo(:,30,12) = (/ &
        & 0.19045e-06,0.51192e-06,0.80594e-06,0.12694e-05,0.16954e-05 /)
      kbo(:,31,12) = (/ &
        & 0.38493e-06,0.71230e-06,0.11392e-05,0.15875e-05,0.20565e-05 /)
      kbo(:,32,12) = (/ &
        & 0.61444e-06,0.97779e-06,0.14257e-05,0.18883e-05,0.26649e-05 /)
      kbo(:,33,12) = (/ &
        & 0.84230e-06,0.12390e-05,0.17304e-05,0.23322e-05,0.32859e-05 /)
      kbo(:,34,12) = (/ &
        & 0.10458e-05,0.14709e-05,0.19634e-05,0.28004e-05,0.37724e-05 /)
      kbo(:,35,12) = (/ &
        & 0.11901e-05,0.16306e-05,0.22411e-05,0.31089e-05,0.41007e-05 /)
      kbo(:,36,12) = (/ &
        & 0.12859e-05,0.17604e-05,0.24414e-05,0.32964e-05,0.43267e-05 /)
      kbo(:,37,12) = (/ &
        & 0.13015e-05,0.17577e-05,0.24562e-05,0.33117e-05,0.43238e-05 /)
      kbo(:,38,12) = (/ &
        & 0.13522e-05,0.18247e-05,0.25116e-05,0.33483e-05,0.43352e-05 /)
      kbo(:,39,12) = (/ &
        & 0.14322e-05,0.19336e-05,0.26107e-05,0.34258e-05,0.44158e-05 /)
      kbo(:,40,12) = (/ &
        & 0.14006e-05,0.18728e-05,0.25304e-05,0.33179e-05,0.42738e-05 /)
      kbo(:,41,12) = (/ &
        & 0.13551e-05,0.18012e-05,0.24357e-05,0.32084e-05,0.41141e-05 /)
      kbo(:,42,12) = (/ &
        & 0.13297e-05,0.17512e-05,0.23561e-05,0.30946e-05,0.39665e-05 /)
      kbo(:,43,12) = (/ &
        & 0.12687e-05,0.16768e-05,0.22464e-05,0.29540e-05,0.37527e-05 /)
      kbo(:,44,12) = (/ &
        & 0.12099e-05,0.15968e-05,0.21385e-05,0.28006e-05,0.35240e-05 /)
      kbo(:,45,12) = (/ &
        & 0.11534e-05,0.15243e-05,0.20279e-05,0.26581e-05,0.33062e-05 /)
      kbo(:,46,12) = (/ &
        & 0.10898e-05,0.14434e-05,0.19097e-05,0.24739e-05,0.30807e-05 /)
      kbo(:,47,12) = (/ &
        & 0.10111e-05,0.13412e-05,0.17607e-05,0.22724e-05,0.28391e-05 /)
      kbo(:,48,12) = (/ &
        & 0.92540e-06,0.12447e-05,0.16295e-05,0.20863e-05,0.26097e-05 /)
      kbo(:,49,12) = (/ &
        & 0.84684e-06,0.11506e-05,0.15141e-05,0.19160e-05,0.23957e-05 /)
      kbo(:,50,12) = (/ &
        & 0.76391e-06,0.10519e-05,0.13910e-05,0.17635e-05,0.22060e-05 /)
      kbo(:,51,12) = (/ &
        & 0.68139e-06,0.95640e-06,0.12771e-05,0.16252e-05,0.20363e-05 /)
      kbo(:,52,12) = (/ &
        & 0.60392e-06,0.86706e-06,0.11671e-05,0.14940e-05,0.18793e-05 /)
      kbo(:,53,12) = (/ &
        & 0.53856e-06,0.78259e-06,0.10620e-05,0.13737e-05,0.17330e-05 /)
      kbo(:,54,12) = (/ &
        & 0.46919e-06,0.69589e-06,0.96582e-06,0.12666e-05,0.16070e-05 /)
      kbo(:,55,12) = (/ &
        & 0.40013e-06,0.61215e-06,0.87450e-06,0.11663e-05,0.14929e-05 /)
      kbo(:,56,12) = (/ &
        & 0.33987e-06,0.53286e-06,0.78520e-06,0.10697e-05,0.13857e-05 /)
      kbo(:,57,12) = (/ &
        & 0.28415e-06,0.45936e-06,0.69784e-06,0.97544e-06,0.12829e-05 /)
      kbo(:,58,12) = (/ &
        & 0.23457e-06,0.39019e-06,0.61528e-06,0.88439e-06,0.11866e-05 /)
      kbo(:,59,12) = (/ &
        & 0.19576e-06,0.34385e-06,0.56055e-06,0.82347e-06,0.11274e-05 /)
      kbo(:,13,13) = (/ &
        & 0.12143e-03,0.12308e-03,0.12512e-03,0.12699e-03,0.12910e-03 /)
      kbo(:,14,13) = (/ &
        & 0.10385e-03,0.10569e-03,0.10770e-03,0.10972e-03,0.11214e-03 /)
      kbo(:,15,13) = (/ &
        & 0.88944e-04,0.90837e-04,0.92688e-04,0.94910e-04,0.97472e-04 /)
      kbo(:,16,13) = (/ &
        & 0.76542e-04,0.78268e-04,0.80179e-04,0.82469e-04,0.84734e-04 /)
      kbo(:,17,13) = (/ &
        & 0.66332e-04,0.67885e-04,0.69742e-04,0.71831e-04,0.74034e-04 /)
      kbo(:,18,13) = (/ &
        & 0.57811e-04,0.59251e-04,0.61096e-04,0.62954e-04,0.65175e-04 /)
      kbo(:,19,13) = (/ &
        & 0.50669e-04,0.52124e-04,0.53790e-04,0.55608e-04,0.57861e-04 /)
      kbo(:,20,13) = (/ &
        & 0.44810e-04,0.46258e-04,0.47774e-04,0.49573e-04,0.51715e-04 /)
      kbo(:,21,13) = (/ &
        & 0.40009e-04,0.41361e-04,0.42755e-04,0.44560e-04,0.46559e-04 /)
      kbo(:,22,13) = (/ &
        & 0.36116e-04,0.37297e-04,0.38718e-04,0.40472e-04,0.42441e-04 /)
      kbo(:,23,13) = (/ &
        & 0.32736e-04,0.33861e-04,0.35361e-04,0.37075e-04,0.39134e-04 /)
      kbo(:,24,13) = (/ &
        & 0.29883e-04,0.31056e-04,0.32552e-04,0.34296e-04,0.36499e-04 /)
      kbo(:,25,13) = (/ &
        & 0.27373e-04,0.28693e-04,0.30179e-04,0.32033e-04,0.34358e-04 /)
      kbo(:,26,13) = (/ &
        & 0.25273e-04,0.26749e-04,0.28306e-04,0.30341e-04,0.32793e-04 /)
      kbo(:,27,13) = (/ &
        & 0.23652e-04,0.25175e-04,0.26905e-04,0.29145e-04,0.31814e-04 /)
      kbo(:,28,13) = (/ &
        & 0.22453e-04,0.24077e-04,0.26031e-04,0.28419e-04,0.31259e-04 /)
      kbo(:,29,13) = (/ &
        & 0.21794e-04,0.23553e-04,0.25672e-04,0.28266e-04,0.31243e-04 /)
      kbo(:,30,13) = (/ &
        & 0.21501e-04,0.23414e-04,0.25687e-04,0.28389e-04,0.31547e-04 /)
      kbo(:,31,13) = (/ &
        & 0.21532e-04,0.23577e-04,0.25947e-04,0.28793e-04,0.32070e-04 /)
      kbo(:,32,13) = (/ &
        & 0.21702e-04,0.23850e-04,0.26365e-04,0.29337e-04,0.32730e-04 /)
      kbo(:,33,13) = (/ &
        & 0.21999e-04,0.24243e-04,0.26895e-04,0.29970e-04,0.33492e-04 /)
      kbo(:,34,13) = (/ &
        & 0.22272e-04,0.24615e-04,0.27365e-04,0.30535e-04,0.34149e-04 /)
      kbo(:,35,13) = (/ &
        & 0.22408e-04,0.24786e-04,0.27609e-04,0.30838e-04,0.34518e-04 /)
      kbo(:,36,13) = (/ &
        & 0.22324e-04,0.24717e-04,0.27535e-04,0.30781e-04,0.34466e-04 /)
      kbo(:,37,13) = (/ &
        & 0.21914e-04,0.24278e-04,0.27037e-04,0.30223e-04,0.33847e-04 /)
      kbo(:,38,13) = (/ &
        & 0.21518e-04,0.23846e-04,0.26529e-04,0.29664e-04,0.33219e-04 /)
      kbo(:,39,13) = (/ &
        & 0.21138e-04,0.23443e-04,0.26064e-04,0.29132e-04,0.32628e-04 /)
      kbo(:,40,13) = (/ &
        & 0.20535e-04,0.22813e-04,0.25328e-04,0.28289e-04,0.31682e-04 /)
      kbo(:,41,13) = (/ &
        & 0.19918e-04,0.22174e-04,0.24598e-04,0.27447e-04,0.30722e-04 /)
      kbo(:,42,13) = (/ &
        & 0.19309e-04,0.21550e-04,0.23909e-04,0.26639e-04,0.29801e-04 /)
      kbo(:,43,13) = (/ &
        & 0.18566e-04,0.20812e-04,0.23112e-04,0.25700e-04,0.28732e-04 /)
      kbo(:,44,13) = (/ &
        & 0.17767e-04,0.20035e-04,0.22299e-04,0.24756e-04,0.27639e-04 /)
      kbo(:,45,13) = (/ &
        & 0.16962e-04,0.19260e-04,0.21500e-04,0.23864e-04,0.26597e-04 /)
      kbo(:,46,13) = (/ &
        & 0.16086e-04,0.18421e-04,0.20671e-04,0.22972e-04,0.25545e-04 /)
      kbo(:,47,13) = (/ &
        & 0.15115e-04,0.17481e-04,0.19766e-04,0.22019e-04,0.24442e-04 /)
      kbo(:,48,13) = (/ &
        & 0.14158e-04,0.16526e-04,0.18843e-04,0.21088e-04,0.23419e-04 /)
      kbo(:,49,13) = (/ &
        & 0.13195e-04,0.15552e-04,0.17911e-04,0.20179e-04,0.22454e-04 /)
      kbo(:,50,13) = (/ &
        & 0.12314e-04,0.14653e-04,0.17032e-04,0.19326e-04,0.21576e-04 /)
      kbo(:,51,13) = (/ &
        & 0.11480e-04,0.13788e-04,0.16154e-04,0.18484e-04,0.20739e-04 /)
      kbo(:,52,13) = (/ &
        & 0.10629e-04,0.12922e-04,0.15279e-04,0.17642e-04,0.19921e-04 /)
      kbo(:,53,13) = (/ &
        & 0.97710e-05,0.12082e-04,0.14410e-04,0.16788e-04,0.19091e-04 /)
      kbo(:,54,13) = (/ &
        & 0.90074e-05,0.11316e-04,0.13617e-04,0.15981e-04,0.18321e-04 /)
      kbo(:,55,13) = (/ &
        & 0.83042e-05,0.10569e-04,0.12859e-04,0.15214e-04,0.17581e-04 /)
      kbo(:,56,13) = (/ &
        & 0.76202e-05,0.98296e-05,0.12125e-04,0.14457e-04,0.16835e-04 /)
      kbo(:,57,13) = (/ &
        & 0.69561e-05,0.91024e-05,0.11398e-04,0.13700e-04,0.16068e-04 /)
      kbo(:,58,13) = (/ &
        & 0.63426e-05,0.84347e-05,0.10695e-04,0.12984e-04,0.15340e-04 /)
      kbo(:,59,13) = (/ &
        & 0.61056e-05,0.81719e-05,0.10410e-04,0.12698e-04,0.15054e-04 /)
      kbo(:,13,14) = (/ &
        & 0.69692e-03,0.71516e-03,0.73378e-03,0.75443e-03,0.77716e-03 /)
      kbo(:,14,14) = (/ &
        & 0.64436e-03,0.66211e-03,0.68199e-03,0.70460e-03,0.72891e-03 /)
      kbo(:,15,14) = (/ &
        & 0.59775e-03,0.61618e-03,0.63785e-03,0.66198e-03,0.68803e-03 /)
      kbo(:,16,14) = (/ &
        & 0.55668e-03,0.57752e-03,0.60052e-03,0.62615e-03,0.65391e-03 /)
      kbo(:,17,14) = (/ &
        & 0.52104e-03,0.54458e-03,0.56934e-03,0.59627e-03,0.62539e-03 /)
      kbo(:,18,14) = (/ &
        & 0.49086e-03,0.51685e-03,0.54337e-03,0.57147e-03,0.60182e-03 /)
      kbo(:,19,14) = (/ &
        & 0.46544e-03,0.49373e-03,0.52192e-03,0.55124e-03,0.58277e-03 /)
      kbo(:,20,14) = (/ &
        & 0.44496e-03,0.47526e-03,0.50494e-03,0.53564e-03,0.56857e-03 /)
      kbo(:,21,14) = (/ &
        & 0.42855e-03,0.46070e-03,0.49202e-03,0.52375e-03,0.55795e-03 /)
      kbo(:,22,14) = (/ &
        & 0.41783e-03,0.45160e-03,0.48421e-03,0.51739e-03,0.55269e-03 /)
      kbo(:,23,14) = (/ &
        & 0.41085e-03,0.44564e-03,0.47947e-03,0.51389e-03,0.55016e-03 /)
      kbo(:,24,14) = (/ &
        & 0.40699e-03,0.44263e-03,0.47766e-03,0.51290e-03,0.55008e-03 /)
      kbo(:,25,14) = (/ &
        & 0.40592e-03,0.44215e-03,0.47812e-03,0.51419e-03,0.55216e-03 /)
      kbo(:,26,14) = (/ &
        & 0.40741e-03,0.44425e-03,0.48085e-03,0.51770e-03,0.55654e-03 /)
      kbo(:,27,14) = (/ &
        & 0.41074e-03,0.44811e-03,0.48506e-03,0.52264e-03,0.56211e-03 /)
      kbo(:,28,14) = (/ &
        & 0.41538e-03,0.45333e-03,0.49042e-03,0.52868e-03,0.56877e-03 /)
      kbo(:,29,14) = (/ &
        & 0.42139e-03,0.45956e-03,0.49700e-03,0.53588e-03,0.57647e-03 /)
      kbo(:,30,14) = (/ &
        & 0.42836e-03,0.46659e-03,0.50435e-03,0.54377e-03,0.58489e-03 /)
      kbo(:,31,14) = (/ &
        & 0.43618e-03,0.47431e-03,0.51248e-03,0.55256e-03,0.59401e-03 /)
      kbo(:,32,14) = (/ &
        & 0.44466e-03,0.48256e-03,0.52138e-03,0.56187e-03,0.60364e-03 /)
      kbo(:,33,14) = (/ &
        & 0.45349e-03,0.49137e-03,0.53076e-03,0.57166e-03,0.61359e-03 /)
      kbo(:,34,14) = (/ &
        & 0.46108e-03,0.49922e-03,0.53902e-03,0.58028e-03,0.62237e-03 /)
      kbo(:,35,14) = (/ &
        & 0.46528e-03,0.50354e-03,0.54368e-03,0.58501e-03,0.62724e-03 /)
      kbo(:,36,14) = (/ &
        & 0.46539e-03,0.50375e-03,0.54391e-03,0.58538e-03,0.62763e-03 /)
      kbo(:,37,14) = (/ &
        & 0.45984e-03,0.49817e-03,0.53806e-03,0.57948e-03,0.62153e-03 /)
      kbo(:,38,14) = (/ &
        & 0.45408e-03,0.49229e-03,0.53205e-03,0.57322e-03,0.61533e-03 /)
      kbo(:,39,14) = (/ &
        & 0.44837e-03,0.48652e-03,0.52604e-03,0.56712e-03,0.60916e-03 /)
      kbo(:,40,14) = (/ &
        & 0.43865e-03,0.47705e-03,0.51607e-03,0.55678e-03,0.59870e-03 /)
      kbo(:,41,14) = (/ &
        & 0.42850e-03,0.46708e-03,0.50578e-03,0.54611e-03,0.58790e-03 /)
      kbo(:,42,14) = (/ &
        & 0.41832e-03,0.45718e-03,0.49552e-03,0.53551e-03,0.57688e-03 /)
      kbo(:,43,14) = (/ &
        & 0.40611e-03,0.44501e-03,0.48328e-03,0.52271e-03,0.56375e-03 /)
      kbo(:,44,14) = (/ &
        & 0.39281e-03,0.43169e-03,0.47025e-03,0.50904e-03,0.54960e-03 /)
      kbo(:,45,14) = (/ &
        & 0.37939e-03,0.41841e-03,0.45722e-03,0.49565e-03,0.53564e-03 /)
      kbo(:,46,14) = (/ &
        & 0.36481e-03,0.40443e-03,0.44334e-03,0.48171e-03,0.52104e-03 /)
      kbo(:,47,14) = (/ &
        & 0.34813e-03,0.38867e-03,0.42754e-03,0.46626e-03,0.50489e-03 /)
      kbo(:,48,14) = (/ &
        & 0.33101e-03,0.37257e-03,0.41188e-03,0.45078e-03,0.48906e-03 /)
      kbo(:,49,14) = (/ &
        & 0.31369e-03,0.35613e-03,0.39621e-03,0.43508e-03,0.47354e-03 /)
      kbo(:,50,14) = (/ &
        & 0.29739e-03,0.34030e-03,0.38132e-03,0.42035e-03,0.45918e-03 /)
      kbo(:,51,14) = (/ &
        & 0.28140e-03,0.32461e-03,0.36662e-03,0.40619e-03,0.44511e-03 /)
      kbo(:,52,14) = (/ &
        & 0.26563e-03,0.30898e-03,0.35161e-03,0.39193e-03,0.43080e-03 /)
      kbo(:,53,14) = (/ &
        & 0.24997e-03,0.29311e-03,0.33618e-03,0.37741e-03,0.41655e-03 /)
      kbo(:,54,14) = (/ &
        & 0.23534e-03,0.27846e-03,0.32175e-03,0.36391e-03,0.40359e-03 /)
      kbo(:,55,14) = (/ &
        & 0.22140e-03,0.26468e-03,0.30799e-03,0.35062e-03,0.39107e-03 /)
      kbo(:,56,14) = (/ &
        & 0.20748e-03,0.25097e-03,0.29409e-03,0.33714e-03,0.37835e-03 /)
      kbo(:,57,14) = (/ &
        & 0.19363e-03,0.23702e-03,0.28013e-03,0.32339e-03,0.36545e-03 /)
      kbo(:,58,14) = (/ &
        & 0.18066e-03,0.22379e-03,0.26710e-03,0.31040e-03,0.35295e-03 /)
      kbo(:,59,14) = (/ &
        & 0.17550e-03,0.21855e-03,0.26188e-03,0.30515e-03,0.34793e-03 /)
      kbo(:,13,15) = (/ &
        & 0.67077e-02,0.67643e-02,0.68102e-02,0.68432e-02,0.68617e-02 /)
      kbo(:,14,15) = (/ &
        & 0.68112e-02,0.68842e-02,0.69413e-02,0.69806e-02,0.70063e-02 /)
      kbo(:,15,15) = (/ &
        & 0.68961e-02,0.69833e-02,0.70488e-02,0.70965e-02,0.71269e-02 /)
      kbo(:,16,15) = (/ &
        & 0.69706e-02,0.70648e-02,0.71387e-02,0.71925e-02,0.72279e-02 /)
      kbo(:,17,15) = (/ &
        & 0.70342e-02,0.71339e-02,0.72130e-02,0.72737e-02,0.73138e-02 /)
      kbo(:,18,15) = (/ &
        & 0.70890e-02,0.71933e-02,0.72776e-02,0.73426e-02,0.73856e-02 /)
      kbo(:,19,15) = (/ &
        & 0.71380e-02,0.72441e-02,0.73326e-02,0.74006e-02,0.74464e-02 /)
      kbo(:,20,15) = (/ &
        & 0.71838e-02,0.72907e-02,0.73816e-02,0.74514e-02,0.74969e-02 /)
      kbo(:,21,15) = (/ &
        & 0.72239e-02,0.73326e-02,0.74235e-02,0.74941e-02,0.75405e-02 /)
      kbo(:,22,15) = (/ &
        & 0.72699e-02,0.73767e-02,0.74650e-02,0.75340e-02,0.75785e-02 /)
      kbo(:,23,15) = (/ &
        & 0.73111e-02,0.74172e-02,0.75033e-02,0.75687e-02,0.76113e-02 /)
      kbo(:,24,15) = (/ &
        & 0.73510e-02,0.74537e-02,0.75371e-02,0.76008e-02,0.76395e-02 /)
      kbo(:,25,15) = (/ &
        & 0.73875e-02,0.74885e-02,0.75684e-02,0.76282e-02,0.76634e-02 /)
      kbo(:,26,15) = (/ &
        & 0.74256e-02,0.75226e-02,0.75985e-02,0.76530e-02,0.76835e-02 /)
      kbo(:,27,15) = (/ &
        & 0.74605e-02,0.75517e-02,0.76248e-02,0.76742e-02,0.77008e-02 /)
      kbo(:,28,15) = (/ &
        & 0.74927e-02,0.75800e-02,0.76483e-02,0.76927e-02,0.77139e-02 /)
      kbo(:,29,15) = (/ &
        & 0.75244e-02,0.76057e-02,0.76690e-02,0.77086e-02,0.77249e-02 /)
      kbo(:,30,15) = (/ &
        & 0.75518e-02,0.76303e-02,0.76877e-02,0.77209e-02,0.77334e-02 /)
      kbo(:,31,15) = (/ &
        & 0.75781e-02,0.76519e-02,0.77036e-02,0.77320e-02,0.77395e-02 /)
      kbo(:,32,15) = (/ &
        & 0.76025e-02,0.76727e-02,0.77178e-02,0.77409e-02,0.77439e-02 /)
      kbo(:,33,15) = (/ &
        & 0.76266e-02,0.76908e-02,0.77289e-02,0.77461e-02,0.77464e-02 /)
      kbo(:,34,15) = (/ &
        & 0.76450e-02,0.77038e-02,0.77387e-02,0.77507e-02,0.77465e-02 /)
      kbo(:,35,15) = (/ &
        & 0.76558e-02,0.77117e-02,0.77433e-02,0.77536e-02,0.77475e-02 /)
      kbo(:,36,15) = (/ &
        & 0.76587e-02,0.77150e-02,0.77452e-02,0.77564e-02,0.77495e-02 /)
      kbo(:,37,15) = (/ &
        & 0.76522e-02,0.77109e-02,0.77439e-02,0.77579e-02,0.77534e-02 /)
      kbo(:,38,15) = (/ &
        & 0.76429e-02,0.77056e-02,0.77426e-02,0.77582e-02,0.77560e-02 /)
      kbo(:,39,15) = (/ &
        & 0.76339e-02,0.76993e-02,0.77402e-02,0.77587e-02,0.77588e-02 /)
      kbo(:,40,15) = (/ &
        & 0.76166e-02,0.76865e-02,0.77335e-02,0.77564e-02,0.77613e-02 /)
      kbo(:,41,15) = (/ &
        & 0.75961e-02,0.76706e-02,0.77239e-02,0.77534e-02,0.77621e-02 /)
      kbo(:,42,15) = (/ &
        & 0.75752e-02,0.76537e-02,0.77143e-02,0.77487e-02,0.77622e-02 /)
      kbo(:,43,15) = (/ &
        & 0.75459e-02,0.76317e-02,0.76988e-02,0.77406e-02,0.77602e-02 /)
      kbo(:,44,15) = (/ &
        & 0.75134e-02,0.76061e-02,0.76788e-02,0.77299e-02,0.77567e-02 /)
      kbo(:,45,15) = (/ &
        & 0.74772e-02,0.75773e-02,0.76562e-02,0.77161e-02,0.77502e-02 /)
      kbo(:,46,15) = (/ &
        & 0.74372e-02,0.75438e-02,0.76298e-02,0.76975e-02,0.77405e-02 /)
      kbo(:,47,15) = (/ &
        & 0.73875e-02,0.75032e-02,0.75980e-02,0.76724e-02,0.77261e-02 /)
      kbo(:,48,15) = (/ &
        & 0.73358e-02,0.74597e-02,0.75632e-02,0.76453e-02,0.77080e-02 /)
      kbo(:,49,15) = (/ &
        & 0.72811e-02,0.74117e-02,0.75238e-02,0.76147e-02,0.76865e-02 /)
      kbo(:,50,15) = (/ &
        & 0.72248e-02,0.73656e-02,0.74842e-02,0.75831e-02,0.76614e-02 /)
      kbo(:,51,15) = (/ &
        & 0.71662e-02,0.73174e-02,0.74427e-02,0.75493e-02,0.76342e-02 /)
      kbo(:,52,15) = (/ &
        & 0.71006e-02,0.72655e-02,0.73997e-02,0.75133e-02,0.76064e-02 /)
      kbo(:,53,15) = (/ &
        & 0.70300e-02,0.72101e-02,0.73531e-02,0.74734e-02,0.75745e-02 /)
      kbo(:,54,15) = (/ &
        & 0.69596e-02,0.71548e-02,0.73082e-02,0.74357e-02,0.75431e-02 /)
      kbo(:,55,15) = (/ &
        & 0.68873e-02,0.70968e-02,0.72620e-02,0.73967e-02,0.75110e-02 /)
      kbo(:,56,15) = (/ &
        & 0.68089e-02,0.70345e-02,0.72141e-02,0.73575e-02,0.74766e-02 /)
      kbo(:,57,15) = (/ &
        & 0.67241e-02,0.69678e-02,0.71623e-02,0.73141e-02,0.74401e-02 /)
      kbo(:,58,15) = (/ &
        & 0.66371e-02,0.69009e-02,0.71063e-02,0.72699e-02,0.74044e-02 /)
      kbo(:,59,15) = (/ &
        & 0.66009e-02,0.68723e-02,0.70852e-02,0.72532e-02,0.73888e-02 /)
      kbo(:,13,16) = (/ &
        & 0.20091e-01,0.19310e-01,0.18586e-01,0.17917e-01,0.17293e-01 /)
      kbo(:,14,16) = (/ &
        & 0.21405e-01,0.20507e-01,0.19679e-01,0.18912e-01,0.18201e-01 /)
      kbo(:,15,16) = (/ &
        & 0.22567e-01,0.21555e-01,0.20633e-01,0.19775e-01,0.18992e-01 /)
      kbo(:,16,16) = (/ &
        & 0.23562e-01,0.22456e-01,0.21445e-01,0.20508e-01,0.19661e-01 /)
      kbo(:,17,16) = (/ &
        & 0.24411e-01,0.23217e-01,0.22126e-01,0.21126e-01,0.20220e-01 /)
      kbo(:,18,16) = (/ &
        & 0.25116e-01,0.23847e-01,0.22688e-01,0.21635e-01,0.20680e-01 /)
      kbo(:,19,16) = (/ &
        & 0.25693e-01,0.24361e-01,0.23149e-01,0.22047e-01,0.21053e-01 /)
      kbo(:,20,16) = (/ &
        & 0.26126e-01,0.24747e-01,0.23489e-01,0.22355e-01,0.21332e-01 /)
      kbo(:,21,16) = (/ &
        & 0.26457e-01,0.25034e-01,0.23751e-01,0.22588e-01,0.21537e-01 /)
      kbo(:,22,16) = (/ &
        & 0.26586e-01,0.25153e-01,0.23857e-01,0.22677e-01,0.21621e-01 /)
      kbo(:,23,16) = (/ &
        & 0.26640e-01,0.25191e-01,0.23890e-01,0.22706e-01,0.21649e-01 /)
      kbo(:,24,16) = (/ &
        & 0.26616e-01,0.25160e-01,0.23861e-01,0.22680e-01,0.21622e-01 /)
      kbo(:,25,16) = (/ &
        & 0.26518e-01,0.25075e-01,0.23777e-01,0.22603e-01,0.21555e-01 /)
      kbo(:,26,16) = (/ &
        & 0.26348e-01,0.24922e-01,0.23637e-01,0.22478e-01,0.21437e-01 /)
      kbo(:,27,16) = (/ &
        & 0.26138e-01,0.24737e-01,0.23465e-01,0.22328e-01,0.21299e-01 /)
      kbo(:,28,16) = (/ &
        & 0.25904e-01,0.24526e-01,0.23272e-01,0.22156e-01,0.21140e-01 /)
      kbo(:,29,16) = (/ &
        & 0.25645e-01,0.24289e-01,0.23059e-01,0.21960e-01,0.20965e-01 /)
      kbo(:,30,16) = (/ &
        & 0.25364e-01,0.24034e-01,0.22831e-01,0.21758e-01,0.20776e-01 /)
      kbo(:,31,16) = (/ &
        & 0.25075e-01,0.23766e-01,0.22595e-01,0.21541e-01,0.20581e-01 /)
      kbo(:,32,16) = (/ &
        & 0.24769e-01,0.23490e-01,0.22348e-01,0.21316e-01,0.20377e-01 /)
      kbo(:,33,16) = (/ &
        & 0.24460e-01,0.23211e-01,0.22098e-01,0.21090e-01,0.20170e-01 /)
      kbo(:,34,16) = (/ &
        & 0.24193e-01,0.22975e-01,0.21887e-01,0.20894e-01,0.19994e-01 /)
      kbo(:,35,16) = (/ &
        & 0.24050e-01,0.22849e-01,0.21770e-01,0.20789e-01,0.19901e-01 /)
      kbo(:,36,16) = (/ &
        & 0.24043e-01,0.22842e-01,0.21764e-01,0.20784e-01,0.19894e-01 /)
      kbo(:,37,16) = (/ &
        & 0.24229e-01,0.23006e-01,0.21915e-01,0.20918e-01,0.20018e-01 /)
      kbo(:,38,16) = (/ &
        & 0.24421e-01,0.23180e-01,0.22070e-01,0.21062e-01,0.20144e-01 /)
      kbo(:,39,16) = (/ &
        & 0.24617e-01,0.23352e-01,0.22226e-01,0.21205e-01,0.20274e-01 /)
      kbo(:,40,16) = (/ &
        & 0.24953e-01,0.23654e-01,0.22496e-01,0.21449e-01,0.20495e-01 /)
      kbo(:,41,16) = (/ &
        & 0.25312e-01,0.23980e-01,0.22786e-01,0.21712e-01,0.20738e-01 /)
      kbo(:,42,16) = (/ &
        & 0.25679e-01,0.24315e-01,0.23082e-01,0.21982e-01,0.20981e-01 /)
      kbo(:,43,16) = (/ &
        & 0.26140e-01,0.24730e-01,0.23454e-01,0.22317e-01,0.21287e-01 /)
      kbo(:,44,16) = (/ &
        & 0.26653e-01,0.25200e-01,0.23871e-01,0.22691e-01,0.21628e-01 /)
      kbo(:,45,16) = (/ &
        & 0.27190e-01,0.25674e-01,0.24311e-01,0.23078e-01,0.21977e-01 /)
      kbo(:,46,16) = (/ &
        & 0.27783e-01,0.26205e-01,0.24787e-01,0.23504e-01,0.22362e-01 /)
      kbo(:,47,16) = (/ &
        & 0.28471e-01,0.26819e-01,0.25343e-01,0.24006e-01,0.22809e-01 /)
      kbo(:,48,16) = (/ &
        & 0.29185e-01,0.27464e-01,0.25918e-01,0.24532e-01,0.23275e-01 /)
      kbo(:,49,16) = (/ &
        & 0.29935e-01,0.28138e-01,0.26520e-01,0.25074e-01,0.23762e-01 /)
      kbo(:,50,16) = (/ &
        & 0.30661e-01,0.28793e-01,0.27111e-01,0.25603e-01,0.24243e-01 /)
      kbo(:,51,16) = (/ &
        & 0.31401e-01,0.29455e-01,0.27706e-01,0.26135e-01,0.24726e-01 /)
      kbo(:,52,16) = (/ &
        & 0.32182e-01,0.30140e-01,0.28322e-01,0.26686e-01,0.25224e-01 /)
      kbo(:,53,16) = (/ &
        & 0.33002e-01,0.30856e-01,0.28966e-01,0.27268e-01,0.25738e-01 /)
      kbo(:,54,16) = (/ &
        & 0.33792e-01,0.31541e-01,0.29577e-01,0.27816e-01,0.26234e-01 /)
      kbo(:,55,16) = (/ &
        & 0.34581e-01,0.32233e-01,0.30182e-01,0.28363e-01,0.26721e-01 /)
      kbo(:,56,16) = (/ &
        & 0.35416e-01,0.32947e-01,0.30807e-01,0.28926e-01,0.27227e-01 /)
      kbo(:,57,16) = (/ &
        & 0.36291e-01,0.33701e-01,0.31460e-01,0.29510e-01,0.27750e-01 /)
      kbo(:,58,16) = (/ &
        & 0.37161e-01,0.34436e-01,0.32106e-01,0.30077e-01,0.28264e-01 /)
      kbo(:,59,16) = (/ &
        & 0.37521e-01,0.34750e-01,0.32373e-01,0.30309e-01,0.28477e-01 /)

!     -----------------------------------------------------------------

      forrefo(:, 1) = (/ 0.515619e-08, 0.131078e-06, 0.349038e-06 /)
      forrefo(:, 2) = (/ 0.329605e-07, 0.430497e-06, 0.458569e-05 /)
      forrefo(:, 3) = (/ 0.188244e-06, 0.792931e-06, 0.267176e-05 /)
      forrefo(:, 4) = (/ 0.611237e-06, 0.798868e-06, 0.411583e-06 /)
      forrefo(:, 5) = (/ 0.111903e-05, 0.914895e-06, 0.444828e-06 /)
      forrefo(:, 6) = (/ 0.235399e-05, 0.269099e-05, 0.739855e-06 /)
      forrefo(:, 7) = (/ 0.400131e-05, 0.378135e-05, 0.231265e-06 /)
      forrefo(:, 8) = (/ 0.464257e-05, 0.371927e-05, 0.460611e-06 /)
      forrefo(:, 9) = (/ 0.476792e-05, 0.311841e-05, 0.934811e-06 /)
      forrefo(:,10) = (/ 0.555683e-05, 0.238129e-05, 0.400334e-07 /)
      forrefo(:,11) = (/ 0.569068e-05, 0.196039e-05, 0.374476e-07 /)
      forrefo(:,12) = (/ 0.554154e-05, 0.131724e-05, 0.399720e-07 /)
      forrefo(:,13) = (/ 0.462684e-05, 0.238826e-07, 0.325793e-07 /)
      forrefo(:,14) = (/ 0.808644e-06, 0.105126e-11, 0.148691e-07 /)
      forrefo(:,15) = (/ 0.865024e-12, 0.822434e-12, 0.825756e-12 /)
      forrefo(:,16) = (/ 0.945747e-12, 0.802065e-12, 0.724732e-12 /)

!     -----------------------------------------------------------------
!     The array SELFREFO contains the coefficient of the water vapor
!     self-continuum (including the energy term).  The first index
!     refers to temperature in 7.2 degree increments.  For instance,
!     JT = 1 refers to a temperature of 245.6, JT = 2 refers to 252.8,
!     etc.  The second index runs over the g-channel (1 to 16).

      selfrefo(:, 1) = (/ &
        &  0.637755e-05, 0.403921e-05, 0.255823e-05, 0.162025e-05, 0.102618e-05, &
        &  0.649930e-06, 0.411632e-06, 0.260707e-06, 0.165118e-06, 0.104577e-06 /)
      selfrefo(:, 2) = (/ &
        &  0.180887e-04, 0.108890e-04, 0.655493e-05, 0.394592e-05, 0.237536e-05, &
        &  0.142991e-05, 0.860774e-06, 0.518167e-06, 0.311925e-06, 0.187772e-06 /)
      selfrefo(:, 3) = (/ &
        &  0.212261e-04, 0.150697e-04, 0.106989e-04, 0.759581e-05, 0.539274e-05, &
        &  0.382864e-05, 0.271819e-05, 0.192981e-05, 0.137009e-05, 0.972711e-06 /)
      selfrefo(:, 4) = (/ &
        &  0.132497e-04, 0.118071e-04, 0.105216e-04, 0.937599e-05, 0.835516e-05, &
        &  0.744547e-05, 0.663482e-05, 0.591243e-05, 0.526870e-05, 0.469506e-05 /)
      selfrefo(:, 5) = (/ &
        &  0.124069e-04, 0.120785e-04, 0.117589e-04, 0.114477e-04, 0.111447e-04, &
        &  0.108498e-04, 0.105626e-04, 0.102831e-04, 0.100109e-04, 0.974601e-05 /)
      selfrefo(:, 6) = (/ &
        &  0.411994e-04, 0.372560e-04, 0.336901e-04, 0.304654e-04, 0.275494e-04, &
        &  0.249126e-04, 0.225281e-04, 0.203718e-04, 0.184219e-04, 0.166587e-04 /)
      selfrefo(:, 7) = (/ &
        &  0.537376e-04, 0.501002e-04, 0.467090e-04, 0.435473e-04, 0.405996e-04, &
        &  0.378515e-04, 0.352893e-04, 0.329006e-04, 0.306736e-04, 0.285974e-04 /)
      selfrefo(:, 8) = (/ &
        &  0.494279e-04, 0.475365e-04, 0.457175e-04, 0.439681e-04, 0.422857e-04, &
        &  0.406676e-04, 0.391114e-04, 0.376148e-04, 0.361755e-04, 0.347912e-04 /)
      selfrefo(:, 9) = (/ &
        &  0.377444e-04, 0.378199e-04, 0.378956e-04, 0.379715e-04, 0.380475e-04, &
        &  0.381236e-04, 0.381999e-04, 0.382763e-04, 0.383529e-04, 0.384297e-04 /)
      selfrefo(:,10) = (/ &
        &  0.245916e-04, 0.267183e-04, 0.290289e-04, 0.315394e-04, 0.342669e-04, &
        &  0.372304e-04, 0.404501e-04, 0.439483e-04, 0.477490e-04, 0.518784e-04 /)
      selfrefo(:,11) = (/ &
        &  0.186528e-04, 0.211417e-04, 0.239628e-04, 0.271603e-04, 0.307845e-04, &
        &  0.348923e-04, 0.395482e-04, 0.448254e-04, 0.508068e-04, 0.575863e-04 /)
      selfrefo(:,12) = (/ &
        &  0.109896e-04, 0.133794e-04, 0.162890e-04, 0.198312e-04, 0.241438e-04, &
        &  0.293942e-04, 0.357864e-04, 0.435686e-04, 0.530432e-04, 0.645781e-04 /)
      selfrefo(:,13) = (/ &
        &  0.183885e-06, 0.391019e-06, 0.831472e-06, 0.176806e-05, 0.375966e-05, &
        &  0.799463e-05, 0.170000e-04, 0.361492e-04, 0.768686e-04, 0.163455e-03 /)
      selfrefo(:,14) = (/ &
        &  0.466057e-07, 0.937419e-07, 0.188551e-06, 0.379248e-06, 0.762813e-06, &
        &  0.153431e-05, 0.308608e-05, 0.620729e-05, 0.124852e-04, 0.251126e-04 /)
      selfrefo(:,15) = (/ &
        &  0.248961e-06, 0.216780e-06, 0.188758e-06, 0.164358e-06, 0.143113e-06, &
        &  0.124613e-06, 0.108505e-06, 0.944795e-07, 0.822667e-07, 0.716326e-07 /)
      selfrefo(:,16) = (/ &
        &  0.252246e-06, 0.220335e-06, 0.192462e-06, 0.168114e-06, 0.146847e-06, &
        &  0.128270e-06, 0.112043e-06, 0.978688e-07, 0.854878e-07, 0.746731e-07 /)
     
      end subroutine sw_kgb24
