!     path:      $Source$
!     author:    $Author$
!     revision:  $Revision$
!     created:   $Date$

!----------------------------------------------------------------------------
! Copyright (c) 2002-2016, Atmospheric & Environmental Research, Inc. (AER)
! All rights reserved.
!
! Redistribution and use in source and binary forms, with or without
! modification, are permitted provided that the following conditions are met:
!  * Redistributions of source code must retain the above copyright
!    notice, this list of conditions and the following disclaimer.
!  * Redistributions in binary form must reproduce the above copyright
!    notice, this list of conditions and the following disclaimer in the
!    documentation and/or other materials provided with the distribution.
!  * Neither the name of Atmospheric & Environmental Research, Inc., nor
!    the names of its contributors may be used to endorse or promote products
!    derived from this software without specific prior written permission.
!
! THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
! AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
! IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
! ARE DISCLAIMED. IN NO EVENT SHALL ATMOSPHERIC & ENVIRONMENTAL RESEARCH, INC., 
! BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
! CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
! SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
! INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
! CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
! ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
! THE POSSIBILITY OF SUCH DAMAGE.
!                        (http://www.rtweb.aer.com/)                        
!----------------------------------------------------------------------------

! **************************************************************************
!      subroutine sw_kgbnn
! **************************************************************************
!  RRTM Shortwave Radiative Transfer Model
!  Atmospheric and Environmental Research, Inc., Cambridge, MA
!
!  Original by J.Delamere, Atmospheric & Environmental Research.
!  Reformatted for F90: JJMorcrette, ECMWF
!  Further F90 and GCM revisions:  MJIacono, AER, July 2002
!  Solar variability revisions:  MJIacono, AER, November 2015
!
!  This file contains 14 subroutines that include the 
!  absorption coefficients and other data for each of the 14 shortwave
!  spectral bands used in RRTM_SW.  Here, the data are defined for 16
!  g-points, or sub-intervals, per band.  These data are combined and
!  weighted using a mapping procedure in routine RRTMG_SW_INIT to reduce
!  the total number of g-points from 224 to 112 for use in the GCM.
! **************************************************************************
      subroutine sw_kgb22
! **************************************************************************

      !use parkind, only : im => kind , rb => kind  
      use rrsw_kg22, only : kao, kbo, selfrefo, forrefo, sfluxrefo, rayl, &
                            irradnceo, facbrghto, snsptdrko

      implicit none
      save

! Kurucz solar source function
      sfluxrefo(:, 1) = (/ &
        & 3.71641    ,3.63190    ,3.44795    ,3.17936    , &
        & 2.86071    ,2.48490    ,2.02471    ,1.52475    , &
        & 1.03811    ,0.113272   ,9.37115e-02,7.38969e-02, &
        & 5.44713e-02,3.45905e-02,1.30293e-02,1.84198e-03 /)
      sfluxrefo(:, 2) = (/ &
        & 3.73933    ,3.60360    ,3.43370    ,3.19749    , & 
        & 2.87747    ,2.47926    ,2.02175    ,1.52010    , &
        & 1.03612    ,0.113265   ,9.37145e-02,7.38951e-02, &
        & 5.44714e-02,3.45906e-02,1.30293e-02,1.84198e-03 /)
      sfluxrefo(:, 3) = (/ &
        & 3.73889    ,3.60279    ,3.43404    ,3.20560    , &
        & 2.87367    ,2.47515    ,2.02412    ,1.52315    , &
        & 1.03146    ,0.113272   ,9.36707e-02,7.39080e-02, &
        & 5.44598e-02,3.45906e-02,1.30293e-02,1.84198e-03 /)
      sfluxrefo(:, 4) = (/ &
        & 3.73801    ,3.60530    ,3.43659    ,3.20640    , &
        & 2.87039    ,2.47330    ,2.02428    ,1.52509    , &
        & 1.03037    ,0.112553   ,9.35352e-02,7.39675e-02, &
        & 5.43951e-02,3.45669e-02,1.30292e-02,1.84198e-03 /)
      sfluxrefo(:, 5) = (/ &
        & 3.73809    ,3.60996    ,3.43602    ,3.20364    , &
        & 2.87005    ,2.47343    ,2.02353    ,1.52617    , &
        & 1.03138    ,0.111172   ,9.29885e-02,7.35034e-02, &
        & 5.42427e-02,3.45732e-02,1.30169e-02,1.84550e-03 /)
      sfluxrefo(:, 6) = (/ &
        & 3.73872    ,3.62054    ,3.42934    ,3.20110    , &
        & 2.86886    ,2.47379    ,2.02237    ,1.52754    , & 
        & 1.03228    ,0.111597   ,9.12252e-02,7.33115e-02, &
        & 5.35600e-02,3.45187e-02,1.30184e-02,1.84551e-03 /)
      sfluxrefo(:, 7) = (/ &
        & 3.73969    ,3.65461    ,3.40646    ,3.19082    , &
        & 2.86919    ,2.47289    ,2.02312    ,1.52629    , &
        & 1.03329    ,0.111611   ,9.16275e-02,7.14731e-02, &
        & 5.31771e-02,3.44980e-02,1.30190e-02,1.84551e-03 /)
      sfluxrefo(:, 8) = (/ &
        & 3.73995    ,3.65348    ,3.43707    ,3.16351    , &
        & 2.87003    ,2.47392    ,2.02114    ,1.52548    , & 
        & 1.03306    ,0.111088   ,9.12422e-02,7.11146e-02, &
        & 5.31333e-02,3.45302e-02,1.30209e-02,1.84554e-03 /)
      sfluxrefo(:, 9) = (/ &
        & 3.73788    ,3.65004    ,3.46938    ,3.15236    , &
        & 2.86381    ,2.47393    ,2.01715    ,1.52134    , &
        & 1.03163    ,0.111259   ,9.12948e-02,7.09999e-02, &
        & 5.31792e-02,3.44955e-02,1.30189e-02,1.84551e-03 /)

! Solar variability components: time-invariant baseline quiet sun irradiance
      irradnceo(:,1) = (/ &
        & 3.74825E+00, 3.69573E+00, 3.44506E+00, 3.26248E+00,&
        & 2.92582E+00, 2.52211E+00, 2.05147E+00, 1.53729E+00,&
        & 1.04802E+00, 1.14541E-01, 9.45399E-02, 7.49495E-02,&
        & 5.49887E-02, 3.49939E-02, 1.31836E-02, 1.86747E-03/)
      irradnceo(:,2) = (/ &
        & 3.76819E+00, 3.67447E+00, 3.45390E+00, 3.26242E+00,&
        & 2.92382E+00, 2.51857E+00, 2.04913E+00, 1.53772E+00,&
        & 1.04801E+00, 1.14539E-01, 9.45409E-02, 7.49501E-02,&
        & 5.49887E-02, 3.49938E-02, 1.31835E-02, 1.86747E-03/)
      irradnceo(:,3) = (/ &
        & 3.77647E+00, 3.64111E+00, 3.48271E+00, 3.26114E+00,&
        & 2.92470E+00, 2.51661E+00, 2.04800E+00, 1.53886E+00,&
        & 1.04670E+00, 1.14480E-01, 9.45306E-02, 7.49520E-02,&
        & 5.49884E-02, 3.49939E-02, 1.31836E-02, 1.86747E-03/)
      irradnceo(:,4) = (/ &
        & 3.76866E+00, 3.64173E+00, 3.48994E+00, 3.26329E+00,&
        & 2.92498E+00, 2.51407E+00, 2.04685E+00, 1.54232E+00,&
        & 1.04460E+00, 1.14378E-01, 9.45986E-02, 7.48813E-02,&
        & 5.49556E-02, 3.49937E-02, 1.31836E-02, 1.86747E-03/)
      irradnceo(:,5) = (/ &
        & 3.77501E+00, 3.63154E+00, 3.50166E+00, 3.25736E+00,&
        & 2.92546E+00, 2.51215E+00, 2.04568E+00, 1.54413E+00,&
        & 1.04357E+00, 1.14321E-01, 9.46608E-02, 7.48648E-02,&
        & 5.49208E-02, 3.49237E-02, 1.31695E-02, 1.86747E-03/)
      irradnceo(:,6) = (/ &
        & 3.77748E+00, 3.63090E+00, 3.50431E+00, 3.25909E+00,&
        & 2.92025E+00, 2.51156E+00, 2.04573E+00, 1.54403E+00,&
        & 1.04524E+00, 1.12340E-01, 9.47541E-02, 7.48366E-02,&
        & 5.49074E-02, 3.48894E-02, 1.31128E-02, 1.85577E-03/)
      irradnceo(:,7) = (/ &
        & 3.77645E+00, 3.63586E+00, 3.50405E+00, 3.25803E+00,&
        & 2.91856E+00, 2.50516E+00, 2.05136E+00, 1.54400E+00,&
        & 1.04708E+00, 1.13365E-01, 9.30810E-02, 7.36350E-02,&
        & 5.48601E-02, 3.48401E-02, 1.31035E-02, 1.85577E-03/)
      irradnceo(:,8) = (/ &
        & 3.76982E+00, 3.64882E+00, 3.50841E+00, 3.25414E+00,&
        & 2.91026E+00, 2.50818E+00, 2.04994E+00, 1.54390E+00,&
        & 1.04867E+00, 1.13272E-01, 9.30307E-02, 7.22413E-02,&
        & 5.48098E-02, 3.48311E-02, 1.31032E-02, 1.85577E-03/)
      irradnceo(:,9) = (/ &
        & 3.77097E+00, 3.67511E+00, 3.51248E+00, 3.21744E+00,&
        & 2.91350E+00, 2.51378E+00, 2.05106E+00, 1.54135E+00,&
        & 1.04687E+00, 1.13081E-01, 9.29498E-02, 7.20771E-02,&
        & 5.48263E-02, 3.48364E-02, 1.31035E-02, 1.85577E-03/)
! Solar variability components: facular brightening
      facbrghto(:,1) = (/ &
        & 1.23435E-03, 1.27308E-03, 1.27390E-03, 1.16609E-03,&
        & 1.02843E-03, 8.81995E-04, 7.22992E-04, 5.42677E-04,&
        & 3.67241E-04, 4.00586E-05, 3.31134E-05, 2.62334E-05,&
        & 1.92658E-05, 1.22462E-05, 4.59989E-06, 6.51470E-07/)
      facbrghto(:,2) = (/ &
        & 1.23717E-03, 1.30700E-03, 1.26178E-03, 1.15296E-03,&
        & 1.02257E-03, 8.80800E-04, 7.21639E-04, 5.40630E-04,&
        & 3.66196E-04, 4.00576E-05, 3.31135E-05, 2.62333E-05,&
        & 1.92659E-05, 1.22461E-05, 4.59990E-06, 6.51470E-07/)
      facbrghto(:,3) = (/ &
        & 1.24727E-03, 1.31956E-03, 1.25386E-03, 1.14907E-03,&
        & 1.01954E-03, 8.79467E-04, 7.20379E-04, 5.37941E-04,&
        & 3.63994E-04, 3.98141E-05, 3.30260E-05, 2.62320E-05,&
        & 1.92656E-05, 1.22461E-05, 4.59990E-06, 6.51470E-07/)
      facbrghto(:,4) = (/ &
        & 1.27729E-03, 1.31099E-03, 1.24809E-03, 1.14197E-03,&
        & 1.01790E-03, 8.79222E-04, 7.18812E-04, 5.35700E-04,&
        & 3.61905E-04, 3.96664E-05, 3.28340E-05, 2.59209E-05,&
        & 1.91117E-05, 1.22460E-05, 4.59990E-06, 6.51470E-07/)
      facbrghto(:,5) = (/ &
        & 1.30740E-03, 1.30489E-03, 1.23975E-03, 1.13691E-03,&
        & 1.01405E-03, 8.78760E-04, 7.17300E-04, 5.33740E-04,&
        & 3.60094E-04, 3.94860E-05, 3.26596E-05, 2.58653E-05,&
        & 1.88853E-05, 1.19345E-05, 4.53370E-06, 6.51470E-07/)
      facbrghto(:,6) = (/ &
        & 1.33509E-03, 1.30694E-03, 1.23053E-03, 1.12959E-03,&
        & 1.01226E-03, 8.76250E-04, 7.13399E-04, 5.32160E-04,&
        & 3.58398E-04, 3.89789E-05, 3.23939E-05, 2.56694E-05,&
        & 1.86330E-05, 1.17714E-05, 4.26703E-06, 5.97492E-07/)
      facbrghto(:,7) = (/ &
        & 1.36743E-03, 1.30050E-03, 1.23001E-03, 1.12354E-03,&
        & 1.00780E-03, 8.75567E-04, 7.05909E-04, 5.29018E-04,&
        & 3.56871E-04, 3.88156E-05, 3.19003E-05, 2.50552E-05,&
        & 1.83330E-05, 1.13433E-05, 4.22452E-06, 5.97493E-07/)
      facbrghto(:,8) = (/ &
        & 1.40451E-03, 1.30969E-03, 1.21029E-03, 1.12622E-03,&
        & 1.01209E-03, 8.62287E-04, 6.96692E-04, 5.23174E-04,&
        & 3.54210E-04, 3.80569E-05, 3.12670E-05, 2.43931E-05,&
        & 1.78913E-05, 1.13039E-05, 4.22293E-06, 5.97493E-07/)
      facbrghto(:,9) = (/ &
        & 1.38675E-03, 1.32870E-03, 1.24066E-03, 1.13516E-03,&
        & 1.00493E-03, 8.54942E-04, 6.86767E-04, 5.14501E-04,&
        & 3.47455E-04, 3.76111E-05, 3.10209E-05, 2.43925E-05,&
        & 1.79017E-05, 1.13072E-05, 4.22452E-06, 5.97493E-07/)
! Solar variability components: sunspot darkening
      snsptdrko(:,1) = (/ &
        &-8.67437E-04,-8.54019E-04,-8.26959E-04,-7.60050E-04,&
        &-6.75252E-04,-5.79568E-04,-4.74609E-04,-3.56715E-04,&
        &-2.41629E-04,-2.63347E-05,-2.17830E-05,-1.72298E-05,&
        &-1.26510E-05,-8.04634E-06,-3.02619E-06,-4.28578E-07/)
      snsptdrko(:,2) = (/ &
        &-8.65958E-04,-8.62535E-04,-8.24344E-04,-7.56709E-04,&
        &-6.74150E-04,-5.79747E-04,-4.74560E-04,-3.56598E-04,&
        &-2.41636E-04,-2.63347E-05,-2.17831E-05,-1.72298E-05,&
        &-1.26511E-05,-8.04630E-06,-3.02620E-06,-4.28578E-07/)
      snsptdrko(:,3) = (/ &
        &-8.66679E-04,-8.65697E-04,-8.22929E-04,-7.55463E-04,&
        &-6.73312E-04,-5.79844E-04,-4.74319E-04,-3.56413E-04,&
        &-2.41578E-04,-2.63364E-05,-2.17851E-05,-1.72294E-05,&
        &-1.26510E-05,-8.04631E-06,-3.02619E-06,-4.28578E-07/)
      snsptdrko(:,4) = (/ &
        &-8.72330E-04,-8.64007E-04,-8.21476E-04,-7.53680E-04,&
        &-6.73042E-04,-5.79883E-04,-4.74063E-04,-3.56290E-04,&
        &-2.41462E-04,-2.63297E-05,-2.17899E-05,-1.72311E-05,&
        &-1.26536E-05,-8.04626E-06,-3.02619E-06,-4.28578E-07/)
      snsptdrko(:,5) = (/ &
        &-8.78329E-04,-8.62672E-04,-8.18686E-04,-7.52629E-04,&
        &-6.72463E-04,-5.80059E-04,-4.73904E-04,-3.56120E-04,&
        &-2.41391E-04,-2.63184E-05,-2.17875E-05,-1.72213E-05,&
        &-1.26494E-05,-8.04997E-06,-3.02855E-06,-4.28578E-07/)
      snsptdrko(:,6) = (/ &
        &-8.84896E-04,-8.62129E-04,-8.15376E-04,-7.50805E-04,&
        &-6.72138E-04,-5.80018E-04,-4.73654E-04,-3.55932E-04,&
        &-2.41357E-04,-2.63050E-05,-2.17745E-05,-1.72152E-05,&
        &-1.26301E-05,-8.04108E-06,-3.03638E-06,-4.30481E-07/)
      snsptdrko(:,7) = (/ &
        &-8.93563E-04,-8.58714E-04,-8.12842E-04,-7.48951E-04,&
        &-6.71893E-04,-5.80162E-04,-4.73152E-04,-3.55808E-04,&
        &-2.41308E-04,-2.62834E-05,-2.17619E-05,-1.71818E-05,&
        &-1.26082E-05,-8.04110E-06,-3.03742E-06,-4.30481E-07/)
      snsptdrko(:,8) = (/ &
        &-9.03170E-04,-8.57974E-04,-8.06780E-04,-7.48006E-04,&
        &-6.71834E-04,-5.79040E-04,-4.72889E-04,-3.55623E-04,&
        &-2.41189E-04,-2.62529E-05,-2.17049E-05,-1.71620E-05,&
        &-1.26030E-05,-8.04153E-06,-3.03790E-06,-4.30481E-07/)
      snsptdrko(:,9) = (/ &
        &-8.94403E-04,-8.62523E-04,-8.13890E-04,-7.48489E-04,&
        &-6.70323E-04,-5.78188E-04,-4.72307E-04,-3.55545E-04,&
        &-2.40869E-04,-2.62300E-05,-2.16988E-05,-1.71625E-05,&
        &-1.25997E-05,-8.04090E-06,-3.03742E-06,-4.30481E-07/)

! Rayleigh extinction coefficient at v = 8000 cm-1.
      rayl = 1.54e-08

!     ------------------------------------------------------------------
!     The array KAO contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels> ~100mb, temperatures, and binary
!     species parameters (see taumol.f for definition).  The first 
!     index in the array, JS, runs from 1 to 9, and corresponds to 
!     different values of the binary species parameter.  For instance, 
!     JS=1 refers to dry air, JS = 2 corresponds to the paramter value 1/8, 
!     JS = 3 corresponds to the parameter value 2/8, etc.  The second index
!     in the array, JT, which runs from 1 to 5, corresponds to different
!     temperatures.  More specifically, JT = 3 means that the data are for
!     the reference temperature TREF for this  pressure level, JT = 2 refers
!     to TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and JT = 5
!     is for TREF+30.  The third index, JP, runs from 1 to 13 and refers
!     to the JPth reference pressure level (see taumol.f for these levels
!     in mb).  The fourth index, IG, goes from 1 to 16, and indicates
!     which g-interval the absorption coefficients are for.
!     -----------------------------------------------------------------

      kao(:, 1, 1, 1) = (/ &
        & 0.14658e-08,0.32044e-07,0.36289e-07,0.38717e-07,0.40590e-07, &
        & 0.43330e-07,0.46916e-07,0.56519e-07,0.42446e-07 /)
      kao(:, 2, 1, 1) = (/ &
        & 0.17883e-08,0.36129e-07,0.40724e-07,0.43498e-07,0.45371e-07, &
        & 0.47093e-07,0.51195e-07,0.58562e-07,0.44474e-07 /)
      kao(:, 3, 1, 1) = (/ &
        & 0.21286e-08,0.46092e-07,0.53991e-07,0.59439e-07,0.63497e-07, &
        & 0.66730e-07,0.70296e-07,0.83990e-07,0.65058e-07 /)
      kao(:, 4, 1, 1) = (/ &
        & 0.24816e-08,0.43399e-07,0.49167e-07,0.52969e-07,0.55586e-07, &
        & 0.57260e-07,0.58809e-07,0.64046e-07,0.48780e-07 /)
      kao(:, 5, 1, 1) = (/ &
        & 0.28409e-08,0.46683e-07,0.53128e-07,0.57526e-07,0.60605e-07, &
        & 0.62715e-07,0.64284e-07,0.67579e-07,0.52346e-07 /)
      kao(:, 1, 2, 1) = (/ &
        & 0.10965e-08,0.24934e-07,0.28268e-07,0.30156e-07,0.31820e-07, &
        & 0.34498e-07,0.36563e-07,0.46609e-07,0.30202e-07 /)
      kao(:, 2, 2, 1) = (/ &
        & 0.13538e-08,0.28338e-07,0.31923e-07,0.34048e-07,0.35529e-07, &
        & 0.37136e-07,0.41583e-07,0.46831e-07,0.32817e-07 /)
      kao(:, 3, 2, 1) = (/ &
        & 0.16260e-08,0.36648e-07,0.42882e-07,0.47128e-07,0.50288e-07, &
        & 0.52851e-07,0.56093e-07,0.70511e-07,0.48182e-07 /)
      kao(:, 4, 2, 1) = (/ &
        & 0.19102e-08,0.39471e-07,0.46225e-07,0.50974e-07,0.54565e-07, &
        & 0.57380e-07,0.60079e-07,0.67707e-07,0.50168e-07 /)
      kao(:, 5, 2, 1) = (/ &
        & 0.22030e-08,0.37203e-07,0.42234e-07,0.45622e-07,0.47990e-07, &
        & 0.49546e-07,0.50777e-07,0.53867e-07,0.39769e-07 /)
      kao(:, 1, 3, 1) = (/ &
        & 0.77844e-09,0.18777e-07,0.21347e-07,0.22946e-07,0.24368e-07, &
        & 0.25870e-07,0.28084e-07,0.39197e-07,0.20196e-07 /)
      kao(:, 2, 3, 1) = (/ &
        & 0.97891e-09,0.21591e-07,0.24379e-07,0.25974e-07,0.27213e-07, &
        & 0.29039e-07,0.31487e-07,0.37725e-07,0.23228e-07 /)
      kao(:, 3, 3, 1) = (/ &
        & 0.11949e-08,0.24305e-07,0.27342e-07,0.29177e-07,0.30428e-07, &
        & 0.31562e-07,0.34299e-07,0.39267e-07,0.23943e-07 /)
      kao(:, 4, 3, 1) = (/ &
        & 0.14225e-08,0.30991e-07,0.36244e-07,0.39880e-07,0.42596e-07, &
        & 0.44752e-07,0.47132e-07,0.56253e-07,0.37250e-07 /)
      kao(:, 5, 3, 1) = (/ &
        & 0.16586e-08,0.29152e-07,0.32988e-07,0.35508e-07,0.37264e-07, &
        & 0.38387e-07,0.39417e-07,0.42936e-07,0.29439e-07 /)
      kao(:, 1, 4, 1) = (/ &
        & 0.53935e-09,0.13922e-07,0.15779e-07,0.16979e-07,0.18157e-07, &
        & 0.19199e-07,0.22168e-07,0.31060e-07,0.13772e-07 /)
      kao(:, 2, 4, 1) = (/ &
        & 0.69404e-09,0.16220e-07,0.18381e-07,0.19646e-07,0.20841e-07, &
        & 0.22407e-07,0.23846e-07,0.31992e-07,0.15532e-07 /)
      kao(:, 3, 4, 1) = (/ &
        & 0.86327e-09,0.18514e-07,0.20845e-07,0.22209e-07,0.23196e-07, &
        & 0.24396e-07,0.27026e-07,0.31067e-07,0.17116e-07 /)
      kao(:, 4, 4, 1) = (/ &
        & 0.10436e-08,0.20666e-07,0.23248e-07,0.24835e-07,0.25904e-07, &
        & 0.26757e-07,0.28384e-07,0.33085e-07,0.19320e-07 /)
      kao(:, 5, 4, 1) = (/ &
        & 0.12327e-08,0.26056e-07,0.30481e-07,0.33580e-07,0.35908e-07, &
        & 0.37744e-07,0.39586e-07,0.45434e-07,0.29787e-07 /)
      kao(:, 1, 5, 1) = (/ &
        & 0.36905e-09,0.10245e-07,0.11596e-07,0.12576e-07,0.13293e-07, &
        & 0.14477e-07,0.18355e-07,0.25395e-07,0.95950e-08 /)
      kao(:, 2, 5, 1) = (/ &
        & 0.48708e-09,0.12119e-07,0.13746e-07,0.14791e-07,0.15718e-07, &
        & 0.16646e-07,0.18396e-07,0.25737e-07,0.10793e-07 /)
      kao(:, 3, 5, 1) = (/ &
        & 0.61847e-09,0.13998e-07,0.15813e-07,0.16851e-07,0.17722e-07, &
        & 0.19232e-07,0.20414e-07,0.25223e-07,0.12354e-07 /)
      kao(:, 4, 5, 1) = (/ &
        & 0.76052e-09,0.15846e-07,0.17816e-07,0.18991e-07,0.19806e-07, &
        & 0.20628e-07,0.23016e-07,0.25874e-07,0.14269e-07 /)
      kao(:, 5, 5, 1) = (/ &
        & 0.91109e-09,0.20382e-07,0.23823e-07,0.26180e-07,0.27929e-07, &
        & 0.29345e-07,0.31039e-07,0.38471e-07,0.22626e-07 /)
      kao(:, 1, 6, 1) = (/ &
        & 0.24637e-09,0.74144e-08,0.83997e-08,0.90789e-08,0.97769e-08, &
        & 0.11308e-07,0.14223e-07,0.20837e-07,0.66398e-08 /)
      kao(:, 2, 6, 1) = (/ &
        & 0.33527e-09,0.89450e-08,0.10119e-07,0.10892e-07,0.11613e-07, &
        & 0.12382e-07,0.14900e-07,0.20638e-07,0.76422e-08 /)
      kao(:, 3, 6, 1) = (/ &
        & 0.43587e-09,0.10479e-07,0.11902e-07,0.12737e-07,0.13564e-07, &
        & 0.14416e-07,0.15545e-07,0.21677e-07,0.89455e-08 /)
      kao(:, 4, 6, 1) = (/ &
        & 0.54672e-09,0.12017e-07,0.13540e-07,0.14423e-07,0.15090e-07, &
        & 0.16030e-07,0.17496e-07,0.20678e-07,0.10490e-07 /)
      kao(:, 5, 6, 1) = (/ &
        & 0.66579e-09,0.13493e-07,0.15163e-07,0.16178e-07,0.16873e-07, &
        & 0.17474e-07,0.18852e-07,0.21699e-07,0.12216e-07 /)
      kao(:, 1, 7, 1) = (/ &
        & 0.16149e-09,0.53201e-08,0.60079e-08,0.65349e-08,0.72837e-08, &
        & 0.90792e-08,0.11028e-07,0.15917e-07,0.45574e-08 /)
      kao(:, 2, 7, 1) = (/ &
        & 0.22765e-09,0.65457e-08,0.74143e-08,0.80126e-08,0.85152e-08, &
        & 0.94934e-08,0.12210e-07,0.16917e-07,0.54301e-08 /)
      kao(:, 3, 7, 1) = (/ &
        & 0.30418e-09,0.77971e-08,0.88287e-08,0.94927e-08,0.10154e-07, &
        & 0.10712e-07,0.12099e-07,0.16996e-07,0.64594e-08 /)
      kao(:, 4, 7, 1) = (/ &
        & 0.38990e-09,0.90563e-08,0.10243e-07,0.10928e-07,0.11554e-07, &
        & 0.12512e-07,0.13254e-07,0.17320e-07,0.76835e-08 /)
      kao(:, 5, 7, 1) = (/ &
        & 0.48334e-09,0.10307e-07,0.11588e-07,0.12345e-07,0.12884e-07, &
        & 0.13512e-07,0.15051e-07,0.17108e-07,0.90662e-08 /)
      kao(:, 1, 8, 1) = (/ &
        & 0.10442e-09,0.37895e-08,0.42781e-08,0.47285e-08,0.55672e-08, &
        & 0.67246e-08,0.87615e-08,0.12496e-07,0.31063e-08 /)
      kao(:, 2, 8, 1) = (/ &
        & 0.15294e-09,0.47545e-08,0.53771e-08,0.58176e-08,0.63249e-08, &
        & 0.74935e-08,0.93024e-08,0.13484e-07,0.38514e-08 /)
      kao(:, 3, 8, 1) = (/ &
        & 0.21056e-09,0.57727e-08,0.65270e-08,0.70416e-08,0.74786e-08, &
        & 0.80475e-08,0.10012e-07,0.13784e-07,0.46496e-08 /)
      kao(:, 4, 8, 1) = (/ &
        & 0.27636e-09,0.67987e-08,0.77111e-08,0.82983e-08,0.87947e-08, &
        & 0.93313e-08,0.10204e-07,0.14244e-07,0.56141e-08 /)
      kao(:, 5, 8, 1) = (/ &
        & 0.34924e-09,0.78297e-08,0.88319e-08,0.94055e-08,0.98667e-08, &
        & 0.10620e-07,0.11396e-07,0.13825e-07,0.67139e-08 /)
      kao(:, 1, 9, 1) = (/ &
        & 0.66385e-10,0.26743e-08,0.30313e-08,0.34595e-08,0.42156e-08, &
        & 0.50940e-08,0.66728e-08,0.10021e-07,0.20965e-08 /)
      kao(:, 2, 9, 1) = (/ &
        & 0.10109e-09,0.34278e-08,0.38685e-08,0.42217e-08,0.47673e-08, &
        & 0.59120e-08,0.72992e-08,0.10438e-07,0.27321e-08 /)
      kao(:, 3, 9, 1) = (/ &
        & 0.14405e-09,0.42386e-08,0.48029e-08,0.51840e-08,0.55416e-08, &
        & 0.62759e-08,0.79851e-08,0.11314e-07,0.33332e-08 /)
      kao(:, 4, 9, 1) = (/ &
        & 0.19414e-09,0.50774e-08,0.57440e-08,0.61764e-08,0.66005e-08, &
        & 0.69887e-08,0.81552e-08,0.11319e-07,0.40828e-08 /)
      kao(:, 5, 9, 1) = (/ &
        & 0.25056e-09,0.59198e-08,0.67025e-08,0.71627e-08,0.76155e-08, &
        & 0.81557e-08,0.87035e-08,0.11788e-07,0.49512e-08 /)
      kao(:, 1,10, 1) = (/ &
        & 0.43147e-10,0.19136e-08,0.21883e-08,0.26153e-08,0.31055e-08, &
        & 0.39720e-08,0.51107e-08,0.84498e-08,0.15100e-08 /)
      kao(:, 2,10, 1) = (/ &
        & 0.68069e-10,0.25012e-08,0.28230e-08,0.31278e-08,0.37084e-08, &
        & 0.44577e-08,0.58316e-08,0.82732e-08,0.20294e-08 /)
      kao(:, 3,10, 1) = (/ &
        & 0.10013e-09,0.31445e-08,0.35530e-08,0.38466e-08,0.41961e-08, &
        & 0.50063e-08,0.61960e-08,0.89421e-08,0.24447e-08 /)
      kao(:, 4,10, 1) = (/ &
        & 0.13837e-09,0.38258e-08,0.43236e-08,0.46732e-08,0.49545e-08, &
        & 0.53447e-08,0.67172e-08,0.92217e-08,0.30274e-08 /)
      kao(:, 5,10, 1) = (/ &
        & 0.18212e-09,0.45123e-08,0.51146e-08,0.55026e-08,0.58368e-08, &
        & 0.61896e-08,0.67974e-08,0.94910e-08,0.36975e-08 /)
      kao(:, 1,11, 1) = (/ &
        & 0.35238e-10,0.15650e-08,0.17900e-08,0.21398e-08,0.25395e-08, &
        & 0.32442e-08,0.41684e-08,0.68456e-08,0.12890e-08 /)
      kao(:, 2,11, 1) = (/ &
        & 0.55588e-10,0.20451e-08,0.23079e-08,0.25570e-08,0.30342e-08, &
        & 0.36465e-08,0.47717e-08,0.67353e-08,0.16499e-08 /)
      kao(:, 3,11, 1) = (/ &
        & 0.81825e-10,0.25719e-08,0.29058e-08,0.31458e-08,0.34324e-08, &
        & 0.40982e-08,0.50669e-08,0.73083e-08,0.20031e-08 /)
      kao(:, 4,11, 1) = (/ &
        & 0.11311e-09,0.31293e-08,0.35365e-08,0.38229e-08,0.40518e-08, &
        & 0.43730e-08,0.54993e-08,0.75470e-08,0.24754e-08 /)
      kao(:, 5,11, 1) = (/ &
        & 0.14891e-09,0.36915e-08,0.41839e-08,0.45010e-08,0.47744e-08, &
        & 0.50622e-08,0.55621e-08,0.77689e-08,0.30237e-08 /)
      kao(:, 1,12, 1) = (/ &
        & 0.28851e-10,0.12816e-08,0.14656e-08,0.17508e-08,0.20791e-08, &
        & 0.26542e-08,0.34061e-08,0.55940e-08,0.10876e-08 /)
      kao(:, 2,12, 1) = (/ &
        & 0.45511e-10,0.16747e-08,0.18898e-08,0.20935e-08,0.24841e-08, &
        & 0.29844e-08,0.39040e-08,0.54988e-08,0.13569e-08 /)
      kao(:, 3,12, 1) = (/ &
        & 0.66972e-10,0.21053e-08,0.23788e-08,0.25750e-08,0.28091e-08, &
        & 0.33541e-08,0.41474e-08,0.59783e-08,0.16488e-08 /)
      kao(:, 4,12, 1) = (/ &
        & 0.92606e-10,0.25620e-08,0.28952e-08,0.31304e-08,0.33162e-08, &
        & 0.35801e-08,0.45003e-08,0.61789e-08,0.20293e-08 /)
      kao(:, 5,12, 1) = (/ &
        & 0.12192e-09,0.30226e-08,0.34255e-08,0.36843e-08,0.39084e-08, &
        & 0.41445e-08,0.45524e-08,0.63605e-08,0.24756e-08 /)
      kao(:, 1,13, 1) = (/ &
        & 0.23621e-10,0.10494e-08,0.11996e-08,0.14331e-08,0.17023e-08, &
        & 0.21711e-08,0.27844e-08,0.45532e-08,0.89489e-09 /)
      kao(:, 2,13, 1) = (/ &
        & 0.37261e-10,0.13712e-08,0.15471e-08,0.17138e-08,0.20333e-08, &
        & 0.24433e-08,0.31958e-08,0.44925e-08,0.11124e-08 /)
      kao(:, 3,13, 1) = (/ &
        & 0.54831e-10,0.17238e-08,0.19475e-08,0.21082e-08,0.23003e-08, &
        & 0.27446e-08,0.33959e-08,0.48947e-08,0.13514e-08 /)
      kao(:, 4,13, 1) = (/ &
        & 0.75799e-10,0.20971e-08,0.23698e-08,0.25624e-08,0.27143e-08, &
        & 0.29304e-08,0.36822e-08,0.50589e-08,0.16628e-08 /)
      kao(:, 5,13, 1) = (/ &
        & 0.99820e-10,0.24745e-08,0.28041e-08,0.30159e-08,0.31995e-08, &
        & 0.33924e-08,0.37279e-08,0.52074e-08,0.20270e-08 /)
      kao(:, 1, 1, 2) = (/ &
        & 0.13785e-07,0.24738e-06,0.32984e-06,0.38970e-06,0.43737e-06, &
        & 0.50889e-06,0.56985e-06,0.52821e-06,0.22857e-06 /)
      kao(:, 2, 1, 2) = (/ &
        & 0.15768e-07,0.27583e-06,0.36371e-06,0.42333e-06,0.46175e-06, &
        & 0.50608e-06,0.57108e-06,0.57199e-06,0.21992e-06 /)
      kao(:, 3, 1, 2) = (/ &
        & 0.17740e-07,0.31295e-06,0.41668e-06,0.48111e-06,0.52105e-06, &
        & 0.56257e-06,0.61638e-06,0.64253e-06,0.25630e-06 /)
      kao(:, 4, 1, 2) = (/ &
        & 0.19676e-07,0.33378e-06,0.43874e-06,0.50021e-06,0.53506e-06, &
        & 0.56909e-06,0.60800e-06,0.63155e-06,0.24206e-06 /)
      kao(:, 5, 1, 2) = (/ &
        & 0.21537e-07,0.36160e-06,0.47596e-06,0.54056e-06,0.57557e-06, &
        & 0.60002e-06,0.61606e-06,0.61827e-06,0.25207e-06 /)
      kao(:, 1, 2, 2) = (/ &
        & 0.10621e-07,0.19636e-06,0.26336e-06,0.31062e-06,0.35012e-06, &
        & 0.41219e-06,0.46827e-06,0.42345e-06,0.16044e-06 /)
      kao(:, 2, 2, 2) = (/ &
        & 0.12238e-07,0.21970e-06,0.28920e-06,0.33755e-06,0.37073e-06, &
        & 0.41004e-06,0.46315e-06,0.45777e-06,0.15877e-06 /)
      kao(:, 3, 2, 2) = (/ &
        & 0.13863e-07,0.24955e-06,0.33252e-06,0.38359e-06,0.41679e-06, &
        & 0.45237e-06,0.50277e-06,0.51752e-06,0.18617e-06 /)
      kao(:, 4, 2, 2) = (/ &
        & 0.15467e-07,0.27294e-06,0.36292e-06,0.41560e-06,0.44818e-06, &
        & 0.47909e-06,0.51811e-06,0.54528e-06,0.19311e-06 /)
      kao(:, 5, 2, 2) = (/ &
        & 0.17013e-07,0.28946e-06,0.38040e-06,0.43177e-06,0.46055e-06, &
        & 0.48627e-06,0.50036e-06,0.50711e-06,0.19056e-06 /)
      kao(:, 1, 3, 2) = (/ &
        & 0.79041e-08,0.15193e-06,0.20367e-06,0.24255e-06,0.27584e-06, &
        & 0.33106e-06,0.39018e-06,0.33367e-06,0.10147e-06 /)
      kao(:, 2, 3, 2) = (/ &
        & 0.92256e-08,0.17005e-06,0.22457e-06,0.26442e-06,0.29755e-06, &
        & 0.33937e-06,0.38659e-06,0.36019e-06,0.10982e-06 /)
      kao(:, 3, 3, 2) = (/ &
        & 0.10548e-07,0.18874e-06,0.24827e-06,0.28648e-06,0.31109e-06, &
        & 0.33996e-06,0.38319e-06,0.38934e-06,0.11953e-06 /)
      kao(:, 4, 3, 2) = (/ &
        & 0.11869e-07,0.21314e-06,0.28402e-06,0.32565e-06,0.35249e-06, &
        & 0.38039e-06,0.41637e-06,0.43423e-06,0.13779e-06 /)
      kao(:, 5, 3, 2) = (/ &
        & 0.13170e-07,0.22682e-06,0.29805e-06,0.33849e-06,0.36193e-06, &
        & 0.38387e-06,0.41078e-06,0.42298e-06,0.13819e-06 /)
      kao(:, 1, 4, 2) = (/ &
        & 0.57872e-08,0.11704e-06,0.15599e-06,0.19092e-06,0.22043e-06, &
        & 0.26778e-06,0.30128e-06,0.25769e-06,0.68111e-07 /)
      kao(:, 2, 4, 2) = (/ &
        & 0.68505e-08,0.13037e-06,0.17389e-06,0.20556e-06,0.23194e-06, &
        & 0.27485e-06,0.31447e-06,0.28139e-06,0.78259e-07 /)
      kao(:, 3, 4, 2) = (/ &
        & 0.79353e-08,0.14574e-06,0.19135e-06,0.22328e-06,0.24623e-06, &
        & 0.27497e-06,0.31125e-06,0.30440e-06,0.85397e-07 /)
      kao(:, 4, 4, 2) = (/ &
        & 0.90207e-08,0.16075e-06,0.21140e-06,0.24210e-06,0.26199e-06, &
        & 0.28412e-06,0.31832e-06,0.32424e-06,0.93374e-07 /)
      kao(:, 5, 4, 2) = (/ &
        & 0.10099e-07,0.18068e-06,0.24072e-06,0.27515e-06,0.29704e-06, &
        & 0.31830e-06,0.34575e-06,0.36301e-06,0.10959e-06 /)
      kao(:, 1, 5, 2) = (/ &
        & 0.42071e-08,0.88799e-07,0.11974e-06,0.15503e-06,0.18473e-06, &
        & 0.21750e-06,0.23111e-06,0.19568e-06,0.47645e-07 /)
      kao(:, 2, 5, 2) = (/ &
        & 0.50589e-08,0.10003e-06,0.13353e-06,0.15994e-06,0.18265e-06, &
        & 0.22030e-06,0.25851e-06,0.22196e-06,0.56400e-07 /)
      kao(:, 3, 5, 2) = (/ &
        & 0.59363e-08,0.11183e-06,0.14743e-06,0.17446e-06,0.19617e-06, &
        & 0.22887e-06,0.25813e-06,0.23893e-06,0.62471e-07 /)
      kao(:, 4, 5, 2) = (/ &
        & 0.68265e-08,0.12408e-06,0.16316e-06,0.18879e-06,0.20540e-06, &
        & 0.22681e-06,0.25640e-06,0.25817e-06,0.69233e-07 /)
      kao(:, 5, 5, 2) = (/ &
        & 0.77164e-08,0.14022e-06,0.18715e-06,0.21470e-06,0.23265e-06, &
        & 0.25223e-06,0.27783e-06,0.28837e-06,0.82855e-07 /)
      kao(:, 1, 6, 2) = (/ &
        & 0.30108e-08,0.66997e-07,0.92811e-07,0.12074e-06,0.15295e-06, &
        & 0.17839e-06,0.17246e-06,0.14892e-06,0.33739e-07 /)
      kao(:, 2, 6, 2) = (/ &
        & 0.36900e-08,0.76605e-07,0.10196e-06,0.12672e-06,0.14857e-06, &
        & 0.17805e-06,0.19825e-06,0.16899e-06,0.40438e-07 /)
      kao(:, 3, 6, 2) = (/ &
        & 0.43974e-08,0.85358e-07,0.11411e-06,0.13507e-06,0.15283e-06, &
        & 0.18257e-06,0.21172e-06,0.18597e-06,0.46134e-07 /)
      kao(:, 4, 6, 2) = (/ &
        & 0.51213e-08,0.95538e-07,0.12544e-06,0.14691e-06,0.16455e-06, &
        & 0.18481e-06,0.20979e-06,0.20070e-06,0.51618e-07 /)
      kao(:, 5, 6, 2) = (/ &
        & 0.58500e-08,0.10543e-06,0.13870e-06,0.15918e-06,0.17259e-06, &
        & 0.18830e-06,0.21165e-06,0.21507e-06,0.58184e-07 /)
      kao(:, 1, 7, 2) = (/ &
        & 0.21343e-08,0.50731e-07,0.73677e-07,0.95876e-07,0.12180e-06, &
        & 0.14539e-06,0.12792e-06,0.11548e-06,0.24049e-07 /)
      kao(:, 2, 7, 2) = (/ &
        & 0.26695e-08,0.57886e-07,0.78431e-07,0.10179e-06,0.12404e-06, &
        & 0.14498e-06,0.15075e-06,0.12789e-06,0.28929e-07 /)
      kao(:, 3, 7, 2) = (/ &
        & 0.32350e-08,0.65356e-07,0.87120e-07,0.10537e-06,0.12108e-06, &
        & 0.14722e-06,0.16980e-06,0.14529e-06,0.34426e-07 /)
      kao(:, 4, 7, 2) = (/ &
        & 0.38202e-08,0.73009e-07,0.96634e-07,0.11454e-06,0.12893e-06, &
        & 0.15239e-06,0.17280e-06,0.15699e-06,0.38936e-07 /)
      kao(:, 5, 7, 2) = (/ &
        & 0.44151e-08,0.81203e-07,0.10676e-06,0.12425e-06,0.13576e-06, &
        & 0.15119e-06,0.17122e-06,0.16974e-06,0.43692e-07 /)
      kao(:, 1, 8, 2) = (/ &
        & 0.15010e-08,0.38595e-07,0.58295e-07,0.77729e-07,0.98683e-07, &
        & 0.10992e-06,0.95145e-07,0.92252e-07,0.17319e-07 /)
      kao(:, 2, 8, 2) = (/ &
        & 0.19201e-08,0.43791e-07,0.61750e-07,0.79921e-07,0.10136e-06, &
        & 0.11894e-06,0.11276e-06,0.97846e-07,0.20720e-07 /)
      kao(:, 3, 8, 2) = (/ &
        & 0.23693e-08,0.50071e-07,0.66873e-07,0.85063e-07,0.10052e-06, &
        & 0.11892e-06,0.13009e-06,0.11045e-06,0.25527e-07 /)
      kao(:, 4, 8, 2) = (/ &
        & 0.28395e-08,0.55947e-07,0.74757e-07,0.88934e-07,0.10114e-06, &
        & 0.12142e-06,0.14341e-06,0.12281e-06,0.28938e-07 /)
      kao(:, 5, 8, 2) = (/ &
        & 0.33227e-08,0.62620e-07,0.82343e-07,0.96807e-07,0.10922e-06, &
        & 0.12542e-06,0.14247e-06,0.13252e-06,0.32804e-07 /)
      kao(:, 1, 9, 2) = (/ &
        & 0.10437e-08,0.30107e-07,0.47694e-07,0.63218e-07,0.80199e-07, &
        & 0.81465e-07,0.70748e-07,0.72461e-07,0.12620e-07 /)
      kao(:, 2, 9, 2) = (/ &
        & 0.13691e-08,0.33315e-07,0.48674e-07,0.63756e-07,0.81165e-07, &
        & 0.96892e-07,0.83814e-07,0.76311e-07,0.14799e-07 /)
      kao(:, 3, 9, 2) = (/ &
        & 0.17229e-08,0.37985e-07,0.51777e-07,0.67272e-07,0.83770e-07, &
        & 0.97220e-07,0.98951e-07,0.84136e-07,0.18369e-07 /)
      kao(:, 4, 9, 2) = (/ &
        & 0.20990e-08,0.43091e-07,0.57320e-07,0.69933e-07,0.81214e-07, &
        & 0.98518e-07,0.11188e-06,0.95453e-07,0.21724e-07 /)
      kao(:, 5, 9, 2) = (/ &
        & 0.24895e-08,0.48030e-07,0.63808e-07,0.75595e-07,0.85237e-07, &
        & 0.10122e-06,0.11598e-06,0.10350e-06,0.24792e-07 /)
      kao(:, 1,10, 2) = (/ &
        & 0.73565e-09,0.23201e-07,0.38192e-07,0.51890e-07,0.66677e-07, &
        & 0.60941e-07,0.53794e-07,0.57060e-07,0.95538e-08 /)
      kao(:, 2,10, 2) = (/ &
        & 0.98838e-09,0.25706e-07,0.38945e-07,0.51950e-07,0.65881e-07, &
        & 0.73501e-07,0.63459e-07,0.61276e-07,0.10909e-07 /)
      kao(:, 3,10, 2) = (/ &
        & 0.12675e-08,0.29153e-07,0.41180e-07,0.53354e-07,0.67729e-07, &
        & 0.79616e-07,0.75117e-07,0.65122e-07,0.13531e-07 /)
      kao(:, 4,10, 2) = (/ &
        & 0.15675e-08,0.33329e-07,0.44560e-07,0.57066e-07,0.67627e-07, &
        & 0.79638e-07,0.86678e-07,0.73448e-07,0.16804e-07 /)
      kao(:, 5,10, 2) = (/ &
        & 0.18817e-08,0.37257e-07,0.49746e-07,0.59306e-07,0.67554e-07, &
        & 0.81218e-07,0.96337e-07,0.82154e-07,0.18958e-07 /)
      kao(:, 1,11, 2) = (/ &
        & 0.60140e-09,0.19007e-07,0.31253e-07,0.42433e-07,0.54566e-07, &
        & 0.50044e-07,0.44177e-07,0.46695e-07,0.77009e-08 /)
      kao(:, 2,11, 2) = (/ &
        & 0.80782e-09,0.21033e-07,0.31865e-07,0.42505e-07,0.53930e-07, &
        & 0.60271e-07,0.51969e-07,0.49836e-07,0.88971e-08 /)
      kao(:, 3,11, 2) = (/ &
        & 0.10365e-08,0.23860e-07,0.33711e-07,0.43668e-07,0.55447e-07, &
        & 0.65129e-07,0.61514e-07,0.53242e-07,0.11044e-07 /)
      kao(:, 4,11, 2) = (/ &
        & 0.12819e-08,0.27278e-07,0.36477e-07,0.46671e-07,0.55334e-07, &
        & 0.65191e-07,0.70955e-07,0.60123e-07,0.13732e-07 /)
      kao(:, 5,11, 2) = (/ &
        & 0.15394e-08,0.30488e-07,0.40723e-07,0.48551e-07,0.55301e-07, &
        & 0.66490e-07,0.78877e-07,0.67264e-07,0.15488e-07 /)
      kao(:, 1,12, 2) = (/ &
        & 0.49234e-09,0.15554e-07,0.25575e-07,0.34616e-07,0.44615e-07, &
        & 0.41056e-07,0.36097e-07,0.38091e-07,0.62448e-08 /)
      kao(:, 2,12, 2) = (/ &
        & 0.66141e-09,0.17225e-07,0.26080e-07,0.34787e-07,0.44118e-07, &
        & 0.49432e-07,0.42531e-07,0.40718e-07,0.72624e-08 /)
      kao(:, 3,12, 2) = (/ &
        & 0.84839e-09,0.19539e-07,0.27604e-07,0.35754e-07,0.45370e-07, &
        & 0.53306e-07,0.50418e-07,0.43565e-07,0.90256e-08 /)
      kao(:, 4,12, 2) = (/ &
        & 0.10495e-08,0.22342e-07,0.29867e-07,0.38196e-07,0.45322e-07, &
        & 0.53368e-07,0.58112e-07,0.49244e-07,0.11197e-07 /)
      kao(:, 5,12, 2) = (/ &
        & 0.12604e-08,0.24969e-07,0.33348e-07,0.39742e-07,0.45269e-07, &
        & 0.54454e-07,0.64580e-07,0.55079e-07,0.12657e-07 /)
      kao(:, 1,13, 2) = (/ &
        & 0.40306e-09,0.12738e-07,0.20936e-07,0.28312e-07,0.36505e-07, &
        & 0.33674e-07,0.29525e-07,0.31139e-07,0.51040e-08 /)
      kao(:, 2,13, 2) = (/ &
        & 0.54151e-09,0.14106e-07,0.21346e-07,0.28471e-07,0.36139e-07, &
        & 0.40516e-07,0.34830e-07,0.33325e-07,0.59425e-08 /)
      kao(:, 3,13, 2) = (/ &
        & 0.69468e-09,0.15999e-07,0.22600e-07,0.29268e-07,0.37150e-07, &
        & 0.43635e-07,0.41297e-07,0.35646e-07,0.73862e-08 /)
      kao(:, 4,13, 2) = (/ &
        & 0.85913e-09,0.18290e-07,0.24452e-07,0.31282e-07,0.37096e-07, &
        & 0.43709e-07,0.47585e-07,0.40319e-07,0.91581e-08 /)
      kao(:, 5,13, 2) = (/ &
        & 0.10319e-08,0.20440e-07,0.27299e-07,0.32532e-07,0.37047e-07, &
        & 0.44575e-07,0.52880e-07,0.45086e-07,0.10367e-07 /)
      kao(:, 1, 1, 3) = (/ &
        & 0.77542e-07,0.72331e-06,0.98561e-06,0.11860e-05,0.13497e-05, &
        & 0.13448e-05,0.13214e-05,0.14401e-05,0.51217e-06 /)
      kao(:, 2, 1, 3) = (/ &
        & 0.83965e-07,0.81202e-06,0.11096e-05,0.13150e-05,0.14966e-05, &
        & 0.14837e-05,0.13715e-05,0.14446e-05,0.53558e-06 /)
      kao(:, 3, 1, 3) = (/ &
        & 0.89893e-07,0.91147e-06,0.12494e-05,0.14817e-05,0.16581e-05, &
        & 0.16379e-05,0.14913e-05,0.13540e-05,0.57527e-06 /)
      kao(:, 4, 1, 3) = (/ &
        & 0.95336e-07,0.98977e-06,0.13580e-05,0.16044e-05,0.17602e-05, &
        & 0.17289e-05,0.15601e-05,0.13435e-05,0.60153e-06 /)
      kao(:, 5, 1, 3) = (/ &
        & 0.10024e-06,0.10817e-05,0.14820e-05,0.17354e-05,0.18806e-05, &
        & 0.18468e-05,0.16817e-05,0.14550e-05,0.63092e-06 /)
      kao(:, 1, 2, 3) = (/ &
        & 0.61222e-07,0.57382e-06,0.78272e-06,0.94950e-06,0.10796e-05, &
        & 0.10829e-05,0.10794e-05,0.12292e-05,0.35440e-06 /)
      kao(:, 2, 2, 3) = (/ &
        & 0.66652e-07,0.64604e-06,0.88511e-06,0.10523e-05,0.12028e-05, &
        & 0.11924e-05,0.11103e-05,0.11987e-05,0.38232e-06 /)
      kao(:, 3, 2, 3) = (/ &
        & 0.71672e-07,0.73084e-06,0.10012e-05,0.11880e-05,0.13384e-05, &
        & 0.13220e-05,0.12030e-05,0.11381e-05,0.43262e-06 /)
      kao(:, 4, 2, 3) = (/ &
        & 0.76301e-07,0.80259e-06,0.11033e-05,0.13071e-05,0.14343e-05, &
        & 0.14171e-05,0.12785e-05,0.11080e-05,0.46030e-06 /)
      kao(:, 5, 2, 3) = (/ &
        & 0.80500e-07,0.87105e-06,0.11939e-05,0.14005e-05,0.15153e-05, &
        & 0.14864e-05,0.13529e-05,0.11688e-05,0.48117e-06 /)
      kao(:, 1, 3, 3) = (/ &
        & 0.47304e-07,0.44051e-06,0.60584e-06,0.74769e-06,0.84468e-06, &
        & 0.85077e-06,0.85665e-06,0.10494e-05,0.24668e-06 /)
      kao(:, 2, 3, 3) = (/ &
        & 0.51943e-07,0.50181e-06,0.68762e-06,0.82034e-06,0.93657e-06, &
        & 0.92789e-06,0.88766e-06,0.99297e-06,0.26836e-06 /)
      kao(:, 3, 3, 3) = (/ &
        & 0.56252e-07,0.56363e-06,0.77259e-06,0.91469e-06,0.10403e-05, &
        & 0.10243e-05,0.93713e-06,0.99098e-06,0.29882e-06 /)
      kao(:, 4, 3, 3) = (/ &
        & 0.60224e-07,0.63130e-06,0.86724e-06,0.10288e-05,0.11344e-05, &
        & 0.11222e-05,0.10162e-05,0.91320e-06,0.33854e-06 /)
      kao(:, 5, 3, 3) = (/ &
        & 0.63868e-07,0.68673e-06,0.94084e-06,0.11069e-05,0.12001e-05, &
        & 0.11819e-05,0.10625e-05,0.91639e-06,0.36042e-06 /)
      kao(:, 1, 4, 3) = (/ &
        & 0.36151e-07,0.33292e-06,0.46957e-06,0.57176e-06,0.64965e-06, &
        & 0.66578e-06,0.71030e-06,0.90686e-06,0.17407e-06 /)
      kao(:, 2, 4, 3) = (/ &
        & 0.40107e-07,0.38424e-06,0.52571e-06,0.63554e-06,0.72553e-06, &
        & 0.72856e-06,0.72697e-06,0.84339e-06,0.19253e-06 /)
      kao(:, 3, 4, 3) = (/ &
        & 0.43816e-07,0.43401e-06,0.59546e-06,0.70644e-06,0.80752e-06, &
        & 0.79519e-06,0.74520e-06,0.81506e-06,0.21830e-06 /)
      kao(:, 4, 4, 3) = (/ &
        & 0.47242e-07,0.48695e-06,0.66577e-06,0.78531e-06,0.87970e-06, &
        & 0.86799e-06,0.78705e-06,0.76812e-06,0.24161e-06 /)
      kao(:, 5, 4, 3) = (/ &
        & 0.50394e-07,0.54183e-06,0.74240e-06,0.87572e-06,0.95669e-06, &
        & 0.94640e-06,0.85379e-06,0.74722e-06,0.28102e-06 /)
      kao(:, 1, 5, 3) = (/ &
        & 0.27462e-07,0.25134e-06,0.35698e-06,0.43146e-06,0.48552e-06, &
        & 0.53177e-06,0.62976e-06,0.75904e-06,0.12452e-06 /)
      kao(:, 2, 5, 3) = (/ &
        & 0.30835e-07,0.29261e-06,0.40164e-06,0.49701e-06,0.56250e-06, &
        & 0.56722e-06,0.57761e-06,0.72004e-06,0.13996e-06 /)
      kao(:, 3, 5, 3) = (/ &
        & 0.33997e-07,0.33394e-06,0.45684e-06,0.54380e-06,0.62140e-06, &
        & 0.61241e-06,0.60037e-06,0.67265e-06,0.16106e-06 /)
      kao(:, 4, 5, 3) = (/ &
        & 0.36946e-07,0.37590e-06,0.51390e-06,0.60628e-06,0.69027e-06, &
        & 0.67692e-06,0.62237e-06,0.67035e-06,0.18128e-06 /)
      kao(:, 5, 5, 3) = (/ &
        & 0.39670e-07,0.42211e-06,0.57710e-06,0.68190e-06,0.75209e-06, &
        & 0.74450e-06,0.67496e-06,0.61709e-06,0.21416e-06 /)
      kao(:, 1, 6, 3) = (/ &
        & 0.20602e-07,0.18703e-06,0.26972e-06,0.33456e-06,0.36532e-06, &
        & 0.42767e-06,0.56721e-06,0.66482e-06,0.87936e-07 /)
      kao(:, 2, 6, 3) = (/ &
        & 0.23484e-07,0.21971e-06,0.30953e-06,0.37643e-06,0.42627e-06, &
        & 0.44517e-06,0.48560e-06,0.61604e-06,0.10185e-06 /)
      kao(:, 3, 6, 3) = (/ &
        & 0.26181e-07,0.25382e-06,0.34607e-06,0.41971e-06,0.47851e-06, &
        & 0.48129e-06,0.48156e-06,0.56916e-06,0.11864e-06 /)
      kao(:, 4, 6, 3) = (/ &
        & 0.28705e-07,0.28735e-06,0.39181e-06,0.46499e-06,0.52971e-06, &
        & 0.52262e-06,0.49397e-06,0.54792e-06,0.13605e-06 /)
      kao(:, 5, 6, 3) = (/ &
        & 0.31065e-07,0.32265e-06,0.43948e-06,0.51712e-06,0.58131e-06, &
        & 0.57275e-06,0.52154e-06,0.53300e-06,0.15326e-06 /)
      kao(:, 1, 7, 3) = (/ &
        & 0.15315e-07,0.13867e-06,0.20497e-06,0.25791e-06,0.28251e-06, &
        & 0.36209e-06,0.48615e-06,0.57617e-06,0.62083e-07 /)
      kao(:, 2, 7, 3) = (/ &
        & 0.17770e-07,0.16467e-06,0.23430e-06,0.28445e-06,0.31749e-06, &
        & 0.35373e-06,0.43530e-06,0.51750e-06,0.74598e-07 /)
      kao(:, 3, 7, 3) = (/ &
        & 0.20071e-07,0.19194e-06,0.26349e-06,0.32575e-06,0.37090e-06, &
        & 0.37391e-06,0.38838e-06,0.49613e-06,0.88392e-07 /)
      kao(:, 4, 7, 3) = (/ &
        & 0.22230e-07,0.21953e-06,0.29840e-06,0.35680e-06,0.40841e-06, &
        & 0.40516e-06,0.40513e-06,0.45518e-06,0.10149e-06 /)
      kao(:, 5, 7, 3) = (/ &
        & 0.24244e-07,0.24730e-06,0.33583e-06,0.39740e-06,0.45364e-06, &
        & 0.44496e-06,0.41471e-06,0.45022e-06,0.11554e-06 /)
      kao(:, 1, 8, 3) = (/ &
        & 0.11318e-07,0.10309e-06,0.15679e-06,0.19765e-06,0.22300e-06, &
        & 0.30242e-06,0.40824e-06,0.49442e-06,0.44061e-07 /)
      kao(:, 2, 8, 3) = (/ &
        & 0.13358e-07,0.12273e-06,0.17705e-06,0.22062e-06,0.24115e-06, &
        & 0.28999e-06,0.39012e-06,0.45451e-06,0.54847e-07 /)
      kao(:, 3, 8, 3) = (/ &
        & 0.15323e-07,0.14448e-06,0.20316e-06,0.24566e-06,0.27787e-06, &
        & 0.29655e-06,0.33237e-06,0.41480e-06,0.64157e-07 /)
      kao(:, 4, 8, 3) = (/ &
        & 0.17158e-07,0.16673e-06,0.22673e-06,0.27760e-06,0.31491e-06, &
        & 0.31778e-06,0.31818e-06,0.38422e-06,0.75698e-07 /)
      kao(:, 5, 8, 3) = (/ &
        & 0.18880e-07,0.18905e-06,0.25711e-06,0.30558e-06,0.34820e-06, &
        & 0.34226e-06,0.32757e-06,0.36903e-06,0.87559e-07 /)
      kao(:, 1, 9, 3) = (/ &
        & 0.83060e-08,0.76710e-07,0.11565e-06,0.14764e-06,0.17329e-06, &
        & 0.25783e-06,0.35957e-06,0.41243e-06,0.31797e-07 /)
      kao(:, 2, 9, 3) = (/ &
        & 0.99651e-08,0.91242e-07,0.13632e-06,0.17065e-06,0.18967e-06, &
        & 0.24393e-06,0.32914e-06,0.39160e-06,0.39225e-07 /)
      kao(:, 3, 9, 3) = (/ &
        & 0.11621e-07,0.10845e-06,0.15426e-06,0.18813e-06,0.20803e-06, &
        & 0.23565e-06,0.29600e-06,0.35083e-06,0.47417e-07 /)
      kao(:, 4, 9, 3) = (/ &
        & 0.13182e-07,0.12617e-06,0.17363e-06,0.21434e-06,0.24338e-06, &
        & 0.24767e-06,0.26174e-06,0.33967e-06,0.56851e-07 /)
      kao(:, 5, 9, 3) = (/ &
        & 0.14647e-07,0.14462e-06,0.19609e-06,0.23554e-06,0.26966e-06, &
        & 0.27000e-06,0.26860e-06,0.30941e-06,0.65848e-07 /)
      kao(:, 1,10, 3) = (/ &
        & 0.61513e-08,0.59201e-07,0.89564e-07,0.11096e-06,0.13963e-06, &
        & 0.22868e-06,0.30519e-06,0.34949e-06,0.23910e-07 /)
      kao(:, 2,10, 3) = (/ &
        & 0.74969e-08,0.68921e-07,0.10513e-06,0.13256e-06,0.14959e-06, &
        & 0.20339e-06,0.27500e-06,0.33281e-06,0.28611e-07 /)
      kao(:, 3,10, 3) = (/ &
        & 0.88625e-08,0.82016e-07,0.11818e-06,0.14725e-06,0.16097e-06, &
        & 0.19608e-06,0.26185e-06,0.30530e-06,0.35935e-07 /)
      kao(:, 4,10, 3) = (/ &
        & 0.10184e-07,0.96432e-07,0.13542e-06,0.16348e-06,0.18477e-06, &
        & 0.19886e-06,0.22449e-06,0.27787e-06,0.42133e-07 /)
      kao(:, 5,10, 3) = (/ &
        & 0.11421e-07,0.11117e-06,0.15107e-06,0.18528e-06,0.21005e-06, &
        & 0.21209e-06,0.21257e-06,0.25796e-06,0.49988e-07 /)
      kao(:, 1,11, 3) = (/ &
        & 0.50310e-08,0.48563e-07,0.73473e-07,0.91094e-07,0.11455e-06, &
        & 0.18734e-06,0.24995e-06,0.28620e-06,0.19440e-07 /)
      kao(:, 2,11, 3) = (/ &
        & 0.61304e-08,0.56532e-07,0.86340e-07,0.10878e-06,0.12244e-06, &
        & 0.16646e-06,0.22541e-06,0.27316e-06,0.23338e-07 /)
      kao(:, 3,11, 3) = (/ &
        & 0.72491e-08,0.67226e-07,0.96798e-07,0.12061e-06,0.13181e-06, &
        & 0.16043e-06,0.21436e-06,0.24928e-06,0.29352e-07 /)
      kao(:, 4,11, 3) = (/ &
        & 0.83326e-08,0.78998e-07,0.11085e-06,0.13391e-06,0.15135e-06, &
        & 0.16281e-06,0.18360e-06,0.22741e-06,0.34425e-07 /)
      kao(:, 5,11, 3) = (/ &
        & 0.93458e-08,0.91055e-07,0.12364e-06,0.15181e-06,0.17196e-06, &
        & 0.17367e-06,0.17400e-06,0.21108e-06,0.40855e-07 /)
      kao(:, 1,12, 3) = (/ &
        & 0.41189e-08,0.39856e-07,0.60140e-07,0.74963e-07,0.94012e-07, &
        & 0.15333e-06,0.20441e-06,0.23474e-06,0.15853e-07 /)
      kao(:, 2,12, 3) = (/ &
        & 0.50193e-08,0.46348e-07,0.70855e-07,0.89301e-07,0.10040e-06, &
        & 0.13626e-06,0.18429e-06,0.22399e-06,0.19078e-07 /)
      kao(:, 3,12, 3) = (/ &
        & 0.59344e-08,0.55100e-07,0.79255e-07,0.98783e-07,0.10799e-06, &
        & 0.13125e-06,0.17544e-06,0.20357e-06,0.24013e-07 /)
      kao(:, 4,12, 3) = (/ &
        & 0.68228e-08,0.64743e-07,0.90843e-07,0.10971e-06,0.12396e-06, &
        & 0.13321e-06,0.15026e-06,0.18611e-06,0.28198e-07 /)
      kao(:, 5,12, 3) = (/ &
        & 0.76512e-08,0.74591e-07,0.10123e-06,0.12433e-06,0.14085e-06, &
        & 0.14222e-06,0.14246e-06,0.17276e-06,0.33441e-07 /)
      kao(:, 1,13, 3) = (/ &
        & 0.33724e-08,0.32680e-07,0.49222e-07,0.61513e-07,0.77133e-07, &
        & 0.12555e-06,0.16713e-06,0.19233e-06,0.12966e-07 /)
      kao(:, 2,13, 3) = (/ &
        & 0.41100e-08,0.37987e-07,0.58121e-07,0.73233e-07,0.82218e-07, &
        & 0.11156e-06,0.15077e-06,0.18269e-06,0.15614e-07 /)
      kao(:, 3,13, 3) = (/ &
        & 0.48589e-08,0.45157e-07,0.64912e-07,0.80902e-07,0.88466e-07, &
        & 0.10747e-06,0.14360e-06,0.16616e-06,0.19653e-07 /)
      kao(:, 4,13, 3) = (/ &
        & 0.55845e-08,0.53032e-07,0.74357e-07,0.89835e-07,0.10150e-06, &
        & 0.10902e-06,0.12309e-06,0.15231e-06,0.23083e-07 /)
      kao(:, 5,13, 3) = (/ &
        & 0.62642e-08,0.61086e-07,0.82886e-07,0.10172e-06,0.11529e-06, &
        & 0.11645e-06,0.11667e-06,0.14140e-06,0.27368e-07 /)
      kao(:, 1, 1, 4) = (/ &
        & 0.38523e-06,0.18405e-05,0.24561e-05,0.26688e-05,0.26627e-05, &
        & 0.26678e-05,0.26221e-05,0.23434e-05,0.10243e-05 /)
      kao(:, 2, 1, 4) = (/ &
        & 0.41258e-06,0.20340e-05,0.26799e-05,0.29289e-05,0.29138e-05, &
        & 0.29293e-05,0.29106e-05,0.25138e-05,0.11179e-05 /)
      kao(:, 3, 1, 4) = (/ &
        & 0.43826e-06,0.22391e-05,0.29055e-05,0.31733e-05,0.31848e-05, &
        & 0.32210e-05,0.31726e-05,0.29277e-05,0.13122e-05 /)
      kao(:, 4, 1, 4) = (/ &
        & 0.46214e-06,0.24098e-05,0.30735e-05,0.33543e-05,0.34157e-05, &
        & 0.34436e-05,0.34008e-05,0.32157e-05,0.14111e-05 /)
      kao(:, 5, 1, 4) = (/ &
        & 0.48360e-06,0.25684e-05,0.32470e-05,0.35527e-05,0.36650e-05, &
        & 0.37054e-05,0.36463e-05,0.35130e-05,0.16128e-05 /)
      kao(:, 1, 2, 4) = (/ &
        & 0.30632e-06,0.14811e-05,0.19813e-05,0.21525e-05,0.21480e-05, &
        & 0.21651e-05,0.21352e-05,0.19097e-05,0.76078e-06 /)
      kao(:, 2, 2, 4) = (/ &
        & 0.32924e-06,0.16454e-05,0.21736e-05,0.23701e-05,0.23496e-05, &
        & 0.23721e-05,0.23664e-05,0.20501e-05,0.85884e-06 /)
      kao(:, 3, 2, 4) = (/ &
        & 0.35084e-06,0.18164e-05,0.23625e-05,0.25754e-05,0.25799e-05, &
        & 0.26089e-05,0.25758e-05,0.23569e-05,0.98156e-06 /)
      kao(:, 4, 2, 4) = (/ &
        & 0.37092e-06,0.19724e-05,0.25182e-05,0.27461e-05,0.27987e-05, &
        & 0.28122e-05,0.27766e-05,0.26535e-05,0.11297e-05 /)
      kao(:, 5, 2, 4) = (/ &
        & 0.38936e-06,0.20952e-05,0.26519e-05,0.29005e-05,0.29889e-05, &
        & 0.30120e-05,0.29564e-05,0.28641e-05,0.12488e-05 /)
      kao(:, 1, 3, 4) = (/ &
        & 0.23924e-06,0.11590e-05,0.15536e-05,0.16834e-05,0.16891e-05, &
        & 0.17668e-05,0.16904e-05,0.15951e-05,0.52632e-06 /)
      kao(:, 2, 3, 4) = (/ &
        & 0.25864e-06,0.12971e-05,0.17221e-05,0.18731e-05,0.18563e-05, &
        & 0.18804e-05,0.18628e-05,0.16576e-05,0.62738e-06 /)
      kao(:, 3, 3, 4) = (/ &
        & 0.27696e-06,0.14325e-05,0.18710e-05,0.20345e-05,0.20276e-05, &
        & 0.20548e-05,0.20259e-05,0.17837e-05,0.70461e-06 /)
      kao(:, 4, 3, 4) = (/ &
        & 0.29413e-06,0.15757e-05,0.20191e-05,0.22050e-05,0.22319e-05, &
        & 0.22354e-05,0.22195e-05,0.20885e-05,0.84521e-06 /)
      kao(:, 5, 3, 4) = (/ &
        & 0.31013e-06,0.16829e-05,0.21333e-05,0.23274e-05,0.23871e-05, &
        & 0.23939e-05,0.23475e-05,0.22805e-05,0.93762e-06 /)
      kao(:, 1, 4, 4) = (/ &
        & 0.18537e-06,0.89469e-06,0.11953e-05,0.13099e-05,0.13271e-05, &
        & 0.13910e-05,0.13233e-05,0.12842e-05,0.37595e-06 /)
      kao(:, 2, 4, 4) = (/ &
        & 0.20178e-06,0.10096e-05,0.13476e-05,0.14636e-05,0.14567e-05, &
        & 0.14730e-05,0.14642e-05,0.13131e-05,0.45273e-06 /)
      kao(:, 3, 4, 4) = (/ &
        & 0.21732e-06,0.11251e-05,0.14779e-05,0.16107e-05,0.15945e-05, &
        & 0.16194e-05,0.16016e-05,0.14026e-05,0.52023e-06 /)
      kao(:, 4, 4, 4) = (/ &
        & 0.23198e-06,0.12348e-05,0.15955e-05,0.17391e-05,0.17432e-05, &
        & 0.17515e-05,0.17226e-05,0.15707e-05,0.60921e-06 /)
      kao(:, 5, 4, 4) = (/ &
        & 0.24566e-06,0.13471e-05,0.17138e-05,0.18677e-05,0.19071e-05, &
        & 0.19021e-05,0.18647e-05,0.18054e-05,0.72437e-06 /)
      kao(:, 1, 5, 4) = (/ &
        & 0.14315e-06,0.68654e-06,0.91703e-06,0.10136e-05,0.10640e-05, &
        & 0.10899e-05,0.10066e-05,0.10387e-05,0.27115e-06 /)
      kao(:, 2, 5, 4) = (/ &
        & 0.15693e-06,0.78124e-06,0.10460e-05,0.11319e-05,0.11350e-05, &
        & 0.11836e-05,0.11463e-05,0.10954e-05,0.33462e-06 /)
      kao(:, 3, 5, 4) = (/ &
        & 0.17013e-06,0.87619e-06,0.11607e-05,0.12633e-05,0.12502e-05, &
        & 0.12683e-05,0.12476e-05,0.11184e-05,0.38421e-06 /)
      kao(:, 4, 5, 4) = (/ &
        & 0.18255e-06,0.96990e-06,0.12617e-05,0.13726e-05,0.13641e-05, &
        & 0.13787e-05,0.13521e-05,0.11952e-05,0.45446e-06 /)
      kao(:, 5, 5, 4) = (/ &
        & 0.19427e-06,0.10668e-05,0.13642e-05,0.14869e-05,0.15021e-05, &
        & 0.14945e-05,0.14801e-05,0.13920e-05,0.54371e-06 /)
      kao(:, 1, 6, 4) = (/ &
        & 0.10978e-06,0.52395e-06,0.69476e-06,0.76850e-06,0.83675e-06, &
        & 0.86491e-06,0.77625e-06,0.85871e-06,0.19533e-06 /)
      kao(:, 2, 6, 4) = (/ &
        & 0.12132e-06,0.59825e-06,0.79672e-06,0.87685e-06,0.88945e-06, &
        & 0.93176e-06,0.88241e-06,0.87959e-06,0.24185e-06 /)
      kao(:, 3, 6, 4) = (/ &
        & 0.13245e-06,0.67730e-06,0.90458e-06,0.97978e-06,0.97457e-06, &
        & 0.98659e-06,0.98199e-06,0.88654e-06,0.28188e-06 /)
      kao(:, 4, 6, 4) = (/ &
        & 0.14304e-06,0.75520e-06,0.99285e-06,0.10803e-05,0.10647e-05, &
        & 0.10764e-05,0.10623e-05,0.93315e-06,0.33738e-06 /)
      kao(:, 5, 6, 4) = (/ &
        & 0.15298e-06,0.83133e-06,0.10714e-05,0.11654e-05,0.11612e-05, &
        & 0.11628e-05,0.11409e-05,0.10211e-05,0.39343e-06 /)
      kao(:, 1, 7, 4) = (/ &
        & 0.83795e-07,0.39583e-06,0.52221e-06,0.57623e-06,0.66801e-06, &
        & 0.68350e-06,0.61427e-06,0.74508e-06,0.14027e-06 /)
      kao(:, 2, 7, 4) = (/ &
        & 0.93456e-07,0.45651e-06,0.60707e-06,0.67267e-06,0.70886e-06, &
        & 0.72875e-06,0.66655e-06,0.70837e-06,0.17333e-06 /)
      kao(:, 3, 7, 4) = (/ &
        & 0.10278e-06,0.52065e-06,0.69548e-06,0.75346e-06,0.75243e-06, &
        & 0.79752e-06,0.76130e-06,0.73768e-06,0.20746e-06 /)
      kao(:, 4, 7, 4) = (/ &
        & 0.11172e-06,0.58539e-06,0.77614e-06,0.84147e-06,0.82956e-06, &
        & 0.83892e-06,0.81830e-06,0.74649e-06,0.24711e-06 /)
      kao(:, 5, 7, 4) = (/ &
        & 0.12020e-06,0.64890e-06,0.84430e-06,0.91375e-06,0.90365e-06, &
        & 0.91211e-06,0.89073e-06,0.78796e-06,0.29290e-06 /)
      kao(:, 1, 8, 4) = (/ &
        & 0.63771e-07,0.29724e-06,0.38901e-06,0.42952e-06,0.53569e-06, &
        & 0.52739e-06,0.51421e-06,0.65416e-06,0.10106e-06 /)
      kao(:, 2, 8, 4) = (/ &
        & 0.71835e-07,0.34855e-06,0.45895e-06,0.50927e-06,0.55878e-06, &
        & 0.57413e-06,0.51386e-06,0.58703e-06,0.12396e-06 /)
      kao(:, 3, 8, 4) = (/ &
        & 0.79626e-07,0.39836e-06,0.52930e-06,0.58238e-06,0.59321e-06, &
        & 0.61917e-06,0.58275e-06,0.59574e-06,0.15556e-06 /)
      kao(:, 4, 8, 4) = (/ &
        & 0.87141e-07,0.45236e-06,0.60287e-06,0.64978e-06,0.64621e-06, &
        & 0.65548e-06,0.65037e-06,0.59243e-06,0.18170e-06 /)
      kao(:, 5, 8, 4) = (/ &
        & 0.94308e-07,0.50478e-06,0.66216e-06,0.71791e-06,0.70542e-06, &
        & 0.71265e-06,0.70440e-06,0.61750e-06,0.21806e-06 /)
      kao(:, 1, 9, 4) = (/ &
        & 0.48334e-07,0.22150e-06,0.29066e-06,0.32650e-06,0.41774e-06, &
        & 0.40737e-06,0.44502e-06,0.56524e-06,0.72879e-07 /)
      kao(:, 2, 9, 4) = (/ &
        & 0.54994e-07,0.26340e-06,0.34441e-06,0.38160e-06,0.44410e-06, &
        & 0.45746e-06,0.41390e-06,0.50482e-06,0.89924e-07 /)
      kao(:, 3, 9, 4) = (/ &
        & 0.61501e-07,0.30416e-06,0.40299e-06,0.44693e-06,0.47253e-06, &
        & 0.48623e-06,0.44624e-06,0.47646e-06,0.11220e-06 /)
      kao(:, 4, 9, 4) = (/ &
        & 0.67792e-07,0.34758e-06,0.46191e-06,0.50102e-06,0.50055e-06, &
        & 0.52975e-06,0.50335e-06,0.48665e-06,0.13456e-06 /)
      kao(:, 5, 9, 4) = (/ &
        & 0.73830e-07,0.39095e-06,0.51738e-06,0.55894e-06,0.55048e-06, &
        & 0.55492e-06,0.54317e-06,0.49144e-06,0.16088e-06 /)
      kao(:, 1,10, 4) = (/ &
        & 0.36931e-07,0.16614e-06,0.21895e-06,0.26116e-06,0.33023e-06, &
        & 0.31438e-06,0.35810e-06,0.46819e-06,0.53649e-07 /)
      kao(:, 2,10, 4) = (/ &
        & 0.42386e-07,0.20028e-06,0.26120e-06,0.28858e-06,0.36090e-06, &
        & 0.35506e-06,0.34639e-06,0.43640e-06,0.66551e-07 /)
      kao(:, 3,10, 4) = (/ &
        & 0.47801e-07,0.23474e-06,0.30842e-06,0.34242e-06,0.37552e-06, &
        & 0.38348e-06,0.34637e-06,0.39519e-06,0.81897e-07 /)
      kao(:, 4,10, 4) = (/ &
        & 0.53030e-07,0.26856e-06,0.35532e-06,0.39019e-06,0.39727e-06, &
        & 0.41391e-06,0.38815e-06,0.39845e-06,0.10316e-06 /)
      kao(:, 5,10, 4) = (/ &
        & 0.58073e-07,0.30468e-06,0.40415e-06,0.43508e-06,0.43212e-06, &
        & 0.43860e-06,0.43462e-06,0.39513e-06,0.12065e-06 /)
      kao(:, 1,11, 4) = (/ &
        & 0.30210e-07,0.13672e-06,0.18028e-06,0.21388e-06,0.27067e-06, &
        & 0.25748e-06,0.29347e-06,0.38486e-06,0.43992e-07 /)
      kao(:, 2,11, 4) = (/ &
        & 0.34676e-07,0.16480e-06,0.21447e-06,0.23703e-06,0.29658e-06, &
        & 0.29189e-06,0.28346e-06,0.35425e-06,0.54558e-07 /)
      kao(:, 3,11, 4) = (/ &
        & 0.39112e-07,0.19301e-06,0.25343e-06,0.28112e-06,0.30767e-06, &
        & 0.31424e-06,0.28354e-06,0.32323e-06,0.67060e-07 /)
      kao(:, 4,11, 4) = (/ &
        & 0.43392e-07,0.22069e-06,0.29158e-06,0.31987e-06,0.32514e-06, &
        & 0.33920e-06,0.31782e-06,0.32572e-06,0.84444e-07 /)
      kao(:, 5,11, 4) = (/ &
        & 0.47520e-07,0.25011e-06,0.33134e-06,0.35641e-06,0.35390e-06, &
        & 0.35921e-06,0.35594e-06,0.32298e-06,0.98845e-07 /)
      kao(:, 1,12, 4) = (/ &
        & 0.24733e-07,0.11230e-06,0.14856e-06,0.17472e-06,0.22197e-06, &
        & 0.21118e-06,0.24122e-06,0.31477e-06,0.36119e-07 /)
      kao(:, 2,12, 4) = (/ &
        & 0.28389e-07,0.13551e-06,0.17612e-06,0.19468e-06,0.24363e-06, &
        & 0.23963e-06,0.23290e-06,0.28830e-06,0.44709e-07 /)
      kao(:, 3,12, 4) = (/ &
        & 0.32017e-07,0.15859e-06,0.20791e-06,0.23074e-06,0.25230e-06, &
        & 0.25771e-06,0.23238e-06,0.26334e-06,0.54941e-07 /)
      kao(:, 4,12, 4) = (/ &
        & 0.35526e-07,0.18123e-06,0.23912e-06,0.26228e-06,0.26637e-06, &
        & 0.27804e-06,0.26039e-06,0.26652e-06,0.69162e-07 /)
      kao(:, 5,12, 4) = (/ &
        & 0.38912e-07,0.20524e-06,0.27165e-06,0.29207e-06,0.28991e-06, &
        & 0.29419e-06,0.29154e-06,0.26412e-06,0.80995e-07 /)
      kao(:, 1,13, 4) = (/ &
        & 0.20250e-07,0.92231e-07,0.12203e-06,0.14275e-06,0.18179e-06, &
        & 0.17279e-06,0.19796e-06,0.25817e-06,0.29574e-07 /)
      kao(:, 2,13, 4) = (/ &
        & 0.23243e-07,0.11133e-06,0.14442e-06,0.15980e-06,0.20001e-06, &
        & 0.19638e-06,0.19075e-06,0.23541e-06,0.36618e-07 /)
      kao(:, 3,13, 4) = (/ &
        & 0.26215e-07,0.13018e-06,0.17053e-06,0.18925e-06,0.20654e-06, &
        & 0.21104e-06,0.19040e-06,0.21495e-06,0.44987e-07 /)
      kao(:, 4,13, 4) = (/ &
        & 0.29082e-07,0.14865e-06,0.19601e-06,0.21490e-06,0.21820e-06, &
        & 0.22779e-06,0.21313e-06,0.21809e-06,0.56635e-07 /)
      kao(:, 5,13, 4) = (/ &
        & 0.31856e-07,0.16826e-06,0.22260e-06,0.23930e-06,0.23753e-06, &
        & 0.24098e-06,0.23875e-06,0.21605e-06,0.66316e-07 /)
      kao(:, 1, 1, 5) = (/ &
        & 0.17059e-05,0.38862e-05,0.46330e-05,0.51258e-05,0.53516e-05, &
        & 0.52890e-05,0.49050e-05,0.49561e-05,0.24914e-05 /)
      kao(:, 2, 1, 5) = (/ &
        & 0.17702e-05,0.41613e-05,0.49979e-05,0.55352e-05,0.58535e-05, &
        & 0.58620e-05,0.55540e-05,0.53944e-05,0.30111e-05 /)
      kao(:, 3, 1, 5) = (/ &
        & 0.18268e-05,0.44218e-05,0.53631e-05,0.59894e-05,0.63892e-05, &
        & 0.64888e-05,0.63488e-05,0.59957e-05,0.35253e-05 /)
      kao(:, 4, 1, 5) = (/ &
        & 0.18763e-05,0.46467e-05,0.56969e-05,0.64112e-05,0.68701e-05, &
        & 0.70687e-05,0.69575e-05,0.65330e-05,0.40117e-05 /)
      kao(:, 5, 1, 5) = (/ &
        & 0.19168e-05,0.48702e-05,0.60413e-05,0.68595e-05,0.73828e-05, &
        & 0.76555e-05,0.76620e-05,0.72236e-05,0.44814e-05 /)
      kao(:, 1, 2, 5) = (/ &
        & 0.13807e-05,0.32052e-05,0.37981e-05,0.41868e-05,0.43666e-05, &
        & 0.42966e-05,0.39397e-05,0.40523e-05,0.19972e-05 /)
      kao(:, 2, 2, 5) = (/ &
        & 0.14355e-05,0.34375e-05,0.40968e-05,0.45345e-05,0.47869e-05, &
        & 0.47900e-05,0.45121e-05,0.44176e-05,0.23759e-05 /)
      kao(:, 3, 2, 5) = (/ &
        & 0.14839e-05,0.36628e-05,0.44128e-05,0.49223e-05,0.52399e-05, &
        & 0.53302e-05,0.51982e-05,0.49130e-05,0.28052e-05 /)
      kao(:, 4, 2, 5) = (/ &
        & 0.15261e-05,0.38551e-05,0.47116e-05,0.52947e-05,0.56758e-05, &
        & 0.58601e-05,0.57606e-05,0.54224e-05,0.31665e-05 /)
      kao(:, 5, 2, 5) = (/ &
        & 0.15621e-05,0.40345e-05,0.49797e-05,0.56344e-05,0.60672e-05, &
        & 0.63079e-05,0.63076e-05,0.59671e-05,0.35368e-05 /)
      kao(:, 1, 3, 5) = (/ &
        & 0.11048e-05,0.25908e-05,0.30458e-05,0.33480e-05,0.34767e-05, &
        & 0.33444e-05,0.30982e-05,0.31520e-05,0.14943e-05 /)
      kao(:, 2, 3, 5) = (/ &
        & 0.11526e-05,0.27857e-05,0.32915e-05,0.36364e-05,0.38272e-05, &
        & 0.38169e-05,0.35492e-05,0.35141e-05,0.17575e-05 /)
      kao(:, 3, 3, 5) = (/ &
        & 0.11948e-05,0.29688e-05,0.35427e-05,0.39401e-05,0.41747e-05, &
        & 0.42239e-05,0.40766e-05,0.39111e-05,0.20688e-05 /)
      kao(:, 4, 3, 5) = (/ &
        & 0.12319e-05,0.31426e-05,0.38135e-05,0.42625e-05,0.45635e-05, &
        & 0.47062e-05,0.46027e-05,0.43389e-05,0.23873e-05 /)
      kao(:, 5, 3, 5) = (/ &
        & 0.12642e-05,0.32923e-05,0.40402e-05,0.45497e-05,0.48934e-05, &
        & 0.50814e-05,0.50577e-05,0.47614e-05,0.26860e-05 /)
      kao(:, 1, 4, 5) = (/ &
        & 0.87810e-06,0.20726e-05,0.24188e-05,0.26498e-05,0.27201e-05, &
        & 0.25966e-05,0.24215e-05,0.25596e-05,0.10910e-05 /)
      kao(:, 2, 4, 5) = (/ &
        & 0.92113e-06,0.22378e-05,0.26243e-05,0.28859e-05,0.30228e-05, &
        & 0.29855e-05,0.27257e-05,0.28497e-05,0.12952e-05 /)
      kao(:, 3, 4, 5) = (/ &
        & 0.95847e-06,0.23927e-05,0.28323e-05,0.31308e-05,0.33238e-05, &
        & 0.33287e-05,0.31597e-05,0.31032e-05,0.15368e-05 /)
      kao(:, 4, 4, 5) = (/ &
        & 0.99115e-06,0.25350e-05,0.30423e-05,0.33883e-05,0.36085e-05, &
        & 0.36829e-05,0.35850e-05,0.33993e-05,0.17502e-05 /)
      kao(:, 5, 4, 5) = (/ &
        & 0.10199e-05,0.26768e-05,0.32656e-05,0.36641e-05,0.39303e-05, &
        & 0.40820e-05,0.40444e-05,0.38038e-05,0.20588e-05 /)
      kao(:, 1, 5, 5) = (/ &
        & 0.69521e-06,0.16480e-05,0.19136e-05,0.20758e-05,0.21053e-05, &
        & 0.19983e-05,0.19384e-05,0.21119e-05,0.79759e-06 /)
      kao(:, 2, 5, 5) = (/ &
        & 0.73399e-06,0.17885e-05,0.20863e-05,0.22802e-05,0.23681e-05, &
        & 0.23078e-05,0.21093e-05,0.21684e-05,0.95048e-06 /)
      kao(:, 3, 5, 5) = (/ &
        & 0.76704e-06,0.19210e-05,0.22551e-05,0.24823e-05,0.26201e-05, &
        & 0.26181e-05,0.24369e-05,0.24387e-05,0.11396e-05 /)
      kao(:, 4, 5, 5) = (/ &
        & 0.79598e-06,0.20422e-05,0.24305e-05,0.26936e-05,0.28610e-05, &
        & 0.28938e-05,0.28032e-05,0.26848e-05,0.13054e-05 /)
      kao(:, 5, 5, 5) = (/ &
        & 0.82146e-06,0.21630e-05,0.26149e-05,0.29202e-05,0.31281e-05, &
        & 0.32364e-05,0.31639e-05,0.29903e-05,0.15503e-05 /)
      kao(:, 1, 6, 5) = (/ &
        & 0.54790e-06,0.12968e-05,0.14998e-05,0.16199e-05,0.16168e-05, &
        & 0.15151e-05,0.14932e-05,0.16380e-05,0.58437e-06 /)
      kao(:, 2, 6, 5) = (/ &
        & 0.58180e-06,0.14204e-05,0.16474e-05,0.17877e-05,0.18382e-05, &
        & 0.17645e-05,0.16359e-05,0.17414e-05,0.70191e-06 /)
      kao(:, 3, 6, 5) = (/ &
        & 0.61169e-06,0.15332e-05,0.17837e-05,0.19554e-05,0.20462e-05, &
        & 0.20343e-05,0.18483e-05,0.19670e-05,0.83824e-06 /)
      kao(:, 4, 6, 5) = (/ &
        & 0.63729e-06,0.16375e-05,0.19280e-05,0.21247e-05,0.22559e-05, &
        & 0.22588e-05,0.21468e-05,0.21190e-05,0.96829e-06 /)
      kao(:, 5, 6, 5) = (/ &
        & 0.65987e-06,0.17326e-05,0.20710e-05,0.23017e-05,0.24525e-05, &
        & 0.25042e-05,0.24377e-05,0.23029e-05,0.11330e-05 /)
      kao(:, 1, 7, 5) = (/ &
        & 0.43067e-06,0.10147e-05,0.11663e-05,0.12622e-05,0.12316e-05, &
        & 0.11186e-05,0.12227e-05,0.12153e-05,0.41960e-06 /)
      kao(:, 2, 7, 5) = (/ &
        & 0.45965e-06,0.11216e-05,0.12929e-05,0.13935e-05,0.14129e-05, &
        & 0.13426e-05,0.12944e-05,0.14463e-05,0.51416e-06 /)
      kao(:, 3, 7, 5) = (/ &
        & 0.48636e-06,0.12186e-05,0.14109e-05,0.15331e-05,0.15936e-05, &
        & 0.15473e-05,0.14164e-05,0.14707e-05,0.61314e-06 /)
      kao(:, 4, 7, 5) = (/ &
        & 0.50928e-06,0.13071e-05,0.15237e-05,0.16740e-05,0.17644e-05, &
        & 0.17562e-05,0.16373e-05,0.16431e-05,0.72862e-06 /)
      kao(:, 5, 7, 5) = (/ &
        & 0.52919e-06,0.13890e-05,0.16443e-05,0.18186e-05,0.19296e-05, &
        & 0.19451e-05,0.18786e-05,0.17942e-05,0.84235e-06 /)
      kao(:, 1, 8, 5) = (/ &
        & 0.33792e-06,0.78856e-06,0.90464e-06,0.98317e-06,0.92848e-06, &
        & 0.86387e-06,0.95438e-06,0.90887e-06,0.29529e-06 /)
      kao(:, 2, 8, 5) = (/ &
        & 0.36263e-06,0.88071e-06,0.10121e-05,0.10878e-05,0.10817e-05, &
        & 0.10133e-05,0.10031e-05,0.11161e-05,0.37413e-06 /)
      kao(:, 3, 8, 5) = (/ &
        & 0.38563e-06,0.96560e-06,0.11116e-05,0.12011e-05,0.12324e-05, &
        & 0.11848e-05,0.10927e-05,0.11776e-05,0.44987e-06 /)
      kao(:, 4, 8, 5) = (/ &
        & 0.40622e-06,0.10407e-05,0.12047e-05,0.13138e-05,0.13745e-05, &
        & 0.13598e-05,0.12356e-05,0.13203e-05,0.54288e-06 /)
      kao(:, 5, 8, 5) = (/ &
        & 0.42386e-06,0.11111e-05,0.13019e-05,0.14302e-05,0.15146e-05, &
        & 0.15112e-05,0.14255e-05,0.14090e-05,0.62729e-06 /)
      kao(:, 1, 9, 5) = (/ &
        & 0.26432e-06,0.60726e-06,0.70036e-06,0.76229e-06,0.71577e-06, &
        & 0.69749e-06,0.70164e-06,0.72668e-06,0.20659e-06 /)
      kao(:, 2, 9, 5) = (/ &
        & 0.28549e-06,0.68848e-06,0.78705e-06,0.84862e-06,0.82241e-06, &
        & 0.74707e-06,0.82519e-06,0.82938e-06,0.27449e-06 /)
      kao(:, 3, 9, 5) = (/ &
        & 0.30511e-06,0.76168e-06,0.87199e-06,0.93359e-06,0.94531e-06, &
        & 0.89794e-06,0.85947e-06,0.97111e-06,0.33410e-06 /)
      kao(:, 4, 9, 5) = (/ &
        & 0.32329e-06,0.82660e-06,0.95163e-06,0.10287e-05,0.10680e-05, &
        & 0.10381e-05,0.94558e-06,0.98374e-06,0.39896e-06 /)
      kao(:, 5, 9, 5) = (/ &
        & 0.33897e-06,0.88614e-06,0.10276e-05,0.11239e-05,0.11817e-05, &
        & 0.11723e-05,0.10892e-05,0.10943e-05,0.47438e-06 /)
      kao(:, 1,10, 5) = (/ &
        & 0.20748e-06,0.47023e-06,0.54165e-06,0.58159e-06,0.54422e-06, &
        & 0.55116e-06,0.57712e-06,0.60571e-06,0.14752e-06 /)
      kao(:, 2,10, 5) = (/ &
        & 0.22561e-06,0.54027e-06,0.61555e-06,0.66550e-06,0.62550e-06, &
        & 0.58306e-06,0.64781e-06,0.63365e-06,0.19821e-06 /)
      kao(:, 3,10, 5) = (/ &
        & 0.24219e-06,0.60251e-06,0.68703e-06,0.73412e-06,0.72965e-06, &
        & 0.68255e-06,0.67291e-06,0.76422e-06,0.24874e-06 /)
      kao(:, 4,10, 5) = (/ &
        & 0.25766e-06,0.65861e-06,0.75375e-06,0.81214e-06,0.83171e-06, &
        & 0.80129e-06,0.73385e-06,0.78864e-06,0.29867e-06 /)
      kao(:, 5,10, 5) = (/ &
        & 0.27157e-06,0.70870e-06,0.81638e-06,0.88593e-06,0.92651e-06, &
        & 0.91449e-06,0.83048e-06,0.88651e-06,0.36087e-06 /)
      kao(:, 1,11, 5) = (/ &
        & 0.16984e-06,0.38981e-06,0.44742e-06,0.48022e-06,0.44950e-06, &
        & 0.45173e-06,0.47333e-06,0.50203e-06,0.12166e-06 /)
      kao(:, 2,11, 5) = (/ &
        & 0.18466e-06,0.44753e-06,0.50754e-06,0.54744e-06,0.51342e-06, &
        & 0.47893e-06,0.53296e-06,0.51992e-06,0.16283e-06 /)
      kao(:, 3,11, 5) = (/ &
        & 0.19826e-06,0.49803e-06,0.56578e-06,0.60333e-06,0.60031e-06, &
        & 0.56085e-06,0.55152e-06,0.63442e-06,0.20412e-06 /)
      kao(:, 4,11, 5) = (/ &
        & 0.21087e-06,0.54349e-06,0.62058e-06,0.66722e-06,0.68339e-06, &
        & 0.65819e-06,0.60140e-06,0.64555e-06,0.24501e-06 /)
      kao(:, 5,11, 5) = (/ &
        & 0.22228e-06,0.58430e-06,0.67139e-06,0.72733e-06,0.76067e-06, &
        & 0.75025e-06,0.68133e-06,0.72307e-06,0.29566e-06 /)
      kao(:, 1,12, 5) = (/ &
        & 0.13908e-06,0.32322e-06,0.36926e-06,0.39668e-06,0.37094e-06, &
        & 0.37104e-06,0.38736e-06,0.41059e-06,0.10018e-06 /)
      kao(:, 2,12, 5) = (/ &
        & 0.15119e-06,0.37037e-06,0.41804e-06,0.44988e-06,0.42138e-06, &
        & 0.39334e-06,0.43800e-06,0.42649e-06,0.13384e-06 /)
      kao(:, 3,12, 5) = (/ &
        & 0.16232e-06,0.41107e-06,0.46554e-06,0.49568e-06,0.49349e-06, &
        & 0.46062e-06,0.45205e-06,0.52165e-06,0.16749e-06 /)
      kao(:, 4,12, 5) = (/ &
        & 0.17268e-06,0.44802e-06,0.51028e-06,0.54757e-06,0.56096e-06, &
        & 0.54041e-06,0.49303e-06,0.52723e-06,0.20095e-06 /)
      kao(:, 5,12, 5) = (/ &
        & 0.18199e-06,0.48092e-06,0.55149e-06,0.59694e-06,0.62405e-06, &
        & 0.61534e-06,0.55851e-06,0.58926e-06,0.24228e-06 /)
      kao(:, 1,13, 5) = (/ &
        & 0.11387e-06,0.26741e-06,0.30441e-06,0.32687e-06,0.30479e-06, &
        & 0.30477e-06,0.31768e-06,0.33316e-06,0.82090e-07 /)
      kao(:, 2,13, 5) = (/ &
        & 0.12381e-06,0.30579e-06,0.34391e-06,0.36935e-06,0.34578e-06, &
        & 0.32317e-06,0.35995e-06,0.35099e-06,0.10981e-06 /)
      kao(:, 3,13, 5) = (/ &
        & 0.13290e-06,0.33871e-06,0.38265e-06,0.40672e-06,0.40511e-06, &
        & 0.37796e-06,0.36986e-06,0.42813e-06,0.13721e-06 /)
      kao(:, 4,13, 5) = (/ &
        & 0.14135e-06,0.36878e-06,0.41898e-06,0.44916e-06,0.46012e-06, &
        & 0.44348e-06,0.40383e-06,0.43087e-06,0.16460e-06 /)
      kao(:, 5,13, 5) = (/ &
        & 0.14898e-06,0.39524e-06,0.45245e-06,0.48939e-06,0.51148e-06, &
        & 0.50420e-06,0.45753e-06,0.48088e-06,0.19843e-06 /)
      kao(:, 1, 1, 6) = (/ &
        & 0.49835e-05,0.73512e-05,0.88016e-05,0.97115e-05,0.10342e-04, &
        & 0.10688e-04,0.10747e-04,0.97587e-05,0.57353e-05 /)
      kao(:, 2, 1, 6) = (/ &
        & 0.49823e-05,0.77944e-05,0.95403e-05,0.10739e-04,0.11522e-04, &
        & 0.11974e-04,0.12019e-04,0.11200e-04,0.69362e-05 /)
      kao(:, 3, 1, 6) = (/ &
        & 0.49638e-05,0.82513e-05,0.10343e-04,0.11836e-04,0.12804e-04, &
        & 0.13375e-04,0.13427e-04,0.12807e-04,0.83325e-05 /)
      kao(:, 4, 1, 6) = (/ &
        & 0.49300e-05,0.87230e-05,0.11131e-04,0.12834e-04,0.13980e-04, &
        & 0.14660e-04,0.14790e-04,0.14186e-04,0.94893e-05 /)
      kao(:, 5, 1, 6) = (/ &
        & 0.48886e-05,0.92046e-05,0.11933e-04,0.13885e-04,0.15255e-04, &
        & 0.16071e-04,0.16239e-04,0.15605e-04,0.10917e-04 /)
      kao(:, 1, 2, 6) = (/ &
        & 0.41174e-05,0.62362e-05,0.73897e-05,0.81161e-05,0.86061e-05, &
        & 0.88364e-05,0.89272e-05,0.81534e-05,0.45187e-05 /)
      kao(:, 2, 2, 6) = (/ &
        & 0.41154e-05,0.66112e-05,0.80274e-05,0.90030e-05,0.96264e-05, &
        & 0.99529e-05,0.10004e-04,0.93836e-05,0.55300e-05 /)
      kao(:, 3, 2, 6) = (/ &
        & 0.40999e-05,0.69972e-05,0.87232e-05,0.99464e-05,0.10738e-04, &
        & 0.11186e-04,0.11235e-04,0.10760e-04,0.66656e-05 /)
      kao(:, 4, 2, 6) = (/ &
        & 0.40728e-05,0.73933e-05,0.94032e-05,0.10842e-04,0.11807e-04, &
        & 0.12371e-04,0.12495e-04,0.12016e-04,0.78073e-05 /)
      kao(:, 5, 2, 6) = (/ &
        & 0.40371e-05,0.77954e-05,0.10060e-04,0.11710e-04,0.12855e-04, &
        & 0.13529e-04,0.13658e-04,0.13169e-04,0.88462e-05 /)
      kao(:, 1, 3, 6) = (/ &
        & 0.33911e-05,0.51807e-05,0.60524e-05,0.65745e-05,0.69209e-05, &
        & 0.70496e-05,0.71376e-05,0.64864e-05,0.34232e-05 /)
      kao(:, 2, 3, 6) = (/ &
        & 0.33916e-05,0.54910e-05,0.65875e-05,0.73243e-05,0.77878e-05, &
        & 0.79847e-05,0.80332e-05,0.75309e-05,0.42228e-05 /)
      kao(:, 3, 3, 6) = (/ &
        & 0.33813e-05,0.58057e-05,0.71503e-05,0.80869e-05,0.86798e-05, &
        & 0.89845e-05,0.90042e-05,0.85938e-05,0.50519e-05 /)
      kao(:, 4, 3, 6) = (/ &
        & 0.33618e-05,0.61503e-05,0.77470e-05,0.88947e-05,0.96421e-05, &
        & 0.10056e-04,0.10131e-04,0.97836e-05,0.60817e-05 /)
      kao(:, 5, 3, 6) = (/ &
        & 0.33346e-05,0.64834e-05,0.82992e-05,0.96266e-05,0.10527e-04, &
        & 0.11042e-04,0.11154e-04,0.10788e-04,0.69208e-05 /)
      kao(:, 1, 4, 6) = (/ &
        & 0.27862e-05,0.42534e-05,0.48987e-05,0.52435e-05,0.54733e-05, &
        & 0.55364e-05,0.55872e-05,0.49226e-05,0.25436e-05 /)
      kao(:, 2, 4, 6) = (/ &
        & 0.27893e-05,0.45093e-05,0.53394e-05,0.58691e-05,0.61855e-05, &
        & 0.63070e-05,0.63399e-05,0.58599e-05,0.31726e-05 /)
      kao(:, 3, 4, 6) = (/ &
        & 0.27843e-05,0.47714e-05,0.58075e-05,0.65048e-05,0.69158e-05, &
        & 0.71341e-05,0.71529e-05,0.67578e-05,0.38485e-05 /)
      kao(:, 4, 4, 6) = (/ &
        & 0.27713e-05,0.50491e-05,0.62824e-05,0.71451e-05,0.76931e-05, &
        & 0.79968e-05,0.80403e-05,0.77391e-05,0.46093e-05 /)
      kao(:, 5, 4, 6) = (/ &
        & 0.27517e-05,0.53526e-05,0.67897e-05,0.78357e-05,0.85357e-05, &
        & 0.89260e-05,0.90160e-05,0.87287e-05,0.54226e-05 /)
      kao(:, 1, 5, 6) = (/ &
        & 0.22852e-05,0.34704e-05,0.39351e-05,0.41626e-05,0.42797e-05, &
        & 0.43078e-05,0.42289e-05,0.36572e-05,0.18725e-05 /)
      kao(:, 2, 5, 6) = (/ &
        & 0.22904e-05,0.36828e-05,0.42969e-05,0.46636e-05,0.48818e-05, &
        & 0.49227e-05,0.49640e-05,0.45776e-05,0.23620e-05 /)
      kao(:, 3, 5, 6) = (/ &
        & 0.22883e-05,0.38995e-05,0.46830e-05,0.51887e-05,0.54814e-05, &
        & 0.56039e-05,0.56350e-05,0.52624e-05,0.29139e-05 /)
      kao(:, 4, 5, 6) = (/ &
        & 0.22808e-05,0.41317e-05,0.50763e-05,0.57196e-05,0.61208e-05, &
        & 0.63389e-05,0.63549e-05,0.60859e-05,0.35219e-05 /)
      kao(:, 5, 5, 6) = (/ &
        & 0.22671e-05,0.43851e-05,0.54991e-05,0.62948e-05,0.68249e-05, &
        & 0.71098e-05,0.71755e-05,0.69558e-05,0.41900e-05 /)
      kao(:, 1, 6, 6) = (/ &
        & 0.18699e-05,0.28114e-05,0.31400e-05,0.32683e-05,0.33153e-05, &
        & 0.33008e-05,0.31920e-05,0.27860e-05,0.13420e-05 /)
      kao(:, 2, 6, 6) = (/ &
        & 0.18773e-05,0.29859e-05,0.34309e-05,0.36695e-05,0.38007e-05, &
        & 0.38091e-05,0.38180e-05,0.34314e-05,0.17179e-05 /)
      kao(:, 3, 6, 6) = (/ &
        & 0.18783e-05,0.31642e-05,0.37448e-05,0.40997e-05,0.43019e-05, &
        & 0.43546e-05,0.43740e-05,0.40084e-05,0.21605e-05 /)
      kao(:, 4, 6, 6) = (/ &
        & 0.18743e-05,0.33566e-05,0.40684e-05,0.45371e-05,0.48151e-05, &
        & 0.49624e-05,0.49624e-05,0.47228e-05,0.26431e-05 /)
      kao(:, 5, 6, 6) = (/ &
        & 0.18657e-05,0.35541e-05,0.43955e-05,0.49826e-05,0.53649e-05, &
        & 0.55694e-05,0.55990e-05,0.54328e-05,0.31359e-05 /)
      kao(:, 1, 7, 6) = (/ &
        & 0.15270e-05,0.22681e-05,0.24953e-05,0.25538e-05,0.25397e-05, &
        & 0.25315e-05,0.23299e-05,0.21035e-05,0.95748e-06 /)
      kao(:, 2, 7, 6) = (/ &
        & 0.15365e-05,0.24113e-05,0.27304e-05,0.28767e-05,0.29339e-05, &
        & 0.29290e-05,0.28728e-05,0.24852e-05,0.12383e-05 /)
      kao(:, 3, 7, 6) = (/ &
        & 0.15398e-05,0.25576e-05,0.29821e-05,0.32226e-05,0.33508e-05, &
        & 0.33584e-05,0.33733e-05,0.31044e-05,0.15900e-05 /)
      kao(:, 4, 7, 6) = (/ &
        & 0.15385e-05,0.27150e-05,0.32458e-05,0.35802e-05,0.37697e-05, &
        & 0.38500e-05,0.38510e-05,0.36169e-05,0.19605e-05 /)
      kao(:, 5, 7, 6) = (/ &
        & 0.15336e-05,0.28792e-05,0.35139e-05,0.39460e-05,0.42149e-05, &
        & 0.43622e-05,0.43664e-05,0.42187e-05,0.23523e-05 /)
      kao(:, 1, 8, 6) = (/ &
        & 0.12444e-05,0.18266e-05,0.19784e-05,0.19900e-05,0.19390e-05, &
        & 0.19235e-05,0.17231e-05,0.16995e-05,0.68590e-06 /)
      kao(:, 2, 8, 6) = (/ &
        & 0.12557e-05,0.19427e-05,0.21667e-05,0.22465e-05,0.22625e-05, &
        & 0.22377e-05,0.21596e-05,0.18759e-05,0.89490e-06 /)
      kao(:, 3, 8, 6) = (/ &
        & 0.12608e-05,0.20627e-05,0.23694e-05,0.25224e-05,0.25961e-05, &
        & 0.25892e-05,0.25887e-05,0.23400e-05,0.11490e-05 /)
      kao(:, 4, 8, 6) = (/ &
        & 0.12616e-05,0.21916e-05,0.25816e-05,0.28156e-05,0.29418e-05, &
        & 0.29759e-05,0.29788e-05,0.27379e-05,0.14416e-05 /)
      kao(:, 5, 8, 6) = (/ &
        & 0.12590e-05,0.23261e-05,0.28013e-05,0.31131e-05,0.32990e-05, &
        & 0.33976e-05,0.33946e-05,0.32600e-05,0.17529e-05 /)
      kao(:, 1, 9, 6) = (/ &
        & 0.10123e-05,0.14681e-05,0.15612e-05,0.15411e-05,0.14778e-05, &
        & 0.14343e-05,0.12992e-05,0.13172e-05,0.49290e-06 /)
      kao(:, 2, 9, 6) = (/ &
        & 0.10245e-05,0.15617e-05,0.17149e-05,0.17499e-05,0.17312e-05, &
        & 0.17144e-05,0.15772e-05,0.14382e-05,0.63132e-06 /)
      kao(:, 3, 9, 6) = (/ &
        & 0.10311e-05,0.16600e-05,0.18786e-05,0.19738e-05,0.20017e-05, &
        & 0.19859e-05,0.19416e-05,0.17139e-05,0.82278e-06 /)
      kao(:, 4, 9, 6) = (/ &
        & 0.10334e-05,0.17639e-05,0.20493e-05,0.22069e-05,0.22845e-05, &
        & 0.22769e-05,0.22855e-05,0.21115e-05,0.10531e-05 /)
      kao(:, 5, 9, 6) = (/ &
        & 0.10328e-05,0.18738e-05,0.22265e-05,0.24495e-05,0.25737e-05, &
        & 0.26232e-05,0.26173e-05,0.24699e-05,0.12950e-05 /)
      kao(:, 1,10, 6) = (/ &
        & 0.82261e-06,0.11811e-05,0.12403e-05,0.12060e-05,0.11493e-05, &
        & 0.10907e-05,0.98035e-06,0.10980e-05,0.37316e-06 /)
      kao(:, 2,10, 6) = (/ &
        & 0.83528e-06,0.12595e-05,0.13646e-05,0.13745e-05,0.13365e-05, &
        & 0.13172e-05,0.11846e-05,0.11491e-05,0.46158e-06 /)
      kao(:, 3,10, 6) = (/ &
        & 0.84255e-06,0.13392e-05,0.14968e-05,0.15528e-05,0.15573e-05, &
        & 0.15339e-05,0.14802e-05,0.12811e-05,0.60300e-06 /)
      kao(:, 4,10, 6) = (/ &
        & 0.84587e-06,0.14245e-05,0.16355e-05,0.17381e-05,0.17835e-05, &
        & 0.17693e-05,0.17683e-05,0.16097e-05,0.77730e-06 /)
      kao(:, 5,10, 6) = (/ &
        & 0.84627e-06,0.15137e-05,0.17779e-05,0.19378e-05,0.20192e-05, &
        & 0.20387e-05,0.20340e-05,0.18636e-05,0.96863e-06 /)
      kao(:, 1,11, 6) = (/ &
        & 0.67388e-06,0.97942e-06,0.10286e-05,0.10023e-05,0.95317e-06, &
        & 0.90847e-06,0.81776e-06,0.89345e-06,0.30408e-06 /)
      kao(:, 2,11, 6) = (/ &
        & 0.68407e-06,0.10438e-05,0.11334e-05,0.11425e-05,0.11096e-05, &
        & 0.10886e-05,0.98240e-06,0.94798e-06,0.38086e-06 /)
      kao(:, 3,11, 6) = (/ &
        & 0.69000e-06,0.11106e-05,0.12435e-05,0.12890e-05,0.12895e-05, &
        & 0.12679e-05,0.12202e-05,0.10522e-05,0.49623e-06 /)
      kao(:, 4,11, 6) = (/ &
        & 0.69276e-06,0.11824e-05,0.13564e-05,0.14402e-05,0.14763e-05, &
        & 0.14628e-05,0.14599e-05,0.13328e-05,0.63979e-06 /)
      kao(:, 5,11, 6) = (/ &
        & 0.69302e-06,0.12555e-05,0.14740e-05,0.16049e-05,0.16694e-05, &
        & 0.16839e-05,0.16772e-05,0.15421e-05,0.79514e-06 /)
      kao(:, 1,12, 6) = (/ &
        & 0.55214e-06,0.81079e-06,0.85249e-06,0.83175e-06,0.78783e-06, &
        & 0.75281e-06,0.67567e-06,0.74075e-06,0.24910e-06 /)
      kao(:, 2,12, 6) = (/ &
        & 0.56029e-06,0.86391e-06,0.94032e-06,0.94758e-06,0.91883e-06, &
        & 0.89834e-06,0.81189e-06,0.77883e-06,0.31399e-06 /)
      kao(:, 3,12, 6) = (/ &
        & 0.56504e-06,0.92066e-06,0.10308e-05,0.10667e-05,0.10655e-05, &
        & 0.10460e-05,0.10067e-05,0.87150e-06,0.40815e-06 /)
      kao(:, 4,12, 6) = (/ &
        & 0.56721e-06,0.97985e-06,0.11224e-05,0.11915e-05,0.12197e-05, &
        & 0.12063e-05,0.12014e-05,0.10950e-05,0.52630e-06 /)
      kao(:, 5,12, 6) = (/ &
        & 0.56742e-06,0.10399e-05,0.12195e-05,0.13255e-05,0.13771e-05, &
        & 0.13876e-05,0.13807e-05,0.12724e-05,0.65264e-06 /)
      kao(:, 1,13, 6) = (/ &
        & 0.45223e-06,0.67006e-06,0.70582e-06,0.68873e-06,0.65038e-06, &
        & 0.62084e-06,0.55442e-06,0.60996e-06,0.20428e-06 /)
      kao(:, 2,13, 6) = (/ &
        & 0.45880e-06,0.71490e-06,0.77859e-06,0.78376e-06,0.75834e-06, &
        & 0.73987e-06,0.66959e-06,0.63711e-06,0.25817e-06 /)
      kao(:, 3,13, 6) = (/ &
        & 0.46276e-06,0.76231e-06,0.85214e-06,0.88098e-06,0.87867e-06, &
        & 0.86188e-06,0.83033e-06,0.72166e-06,0.33548e-06 /)
      kao(:, 4,13, 6) = (/ &
        & 0.46442e-06,0.81043e-06,0.92714e-06,0.98329e-06,0.10050e-05, &
        & 0.99247e-06,0.98770e-06,0.89931e-06,0.43220e-06 /)
      kao(:, 5,13, 6) = (/ &
        & 0.46456e-06,0.86048e-06,0.10065e-05,0.10920e-05,0.11333e-05, &
        & 0.11411e-05,0.11342e-05,0.10473e-05,0.53527e-06 /)
      kao(:, 1, 1, 7) = (/ &
        & 0.12335e-04,0.15987e-04,0.18565e-04,0.20406e-04,0.21636e-04, &
        & 0.22077e-04,0.21364e-04,0.19544e-04,0.14733e-04 /)
      kao(:, 2, 1, 7) = (/ &
        & 0.12351e-04,0.17014e-04,0.20216e-04,0.22480e-04,0.24098e-04, &
        & 0.24791e-04,0.24379e-04,0.22600e-04,0.17292e-04 /)
      kao(:, 3, 1, 7) = (/ &
        & 0.12364e-04,0.18152e-04,0.21907e-04,0.24643e-04,0.26659e-04, &
        & 0.27630e-04,0.27512e-04,0.25730e-04,0.20236e-04 /)
      kao(:, 4, 1, 7) = (/ &
        & 0.12365e-04,0.19320e-04,0.23679e-04,0.26885e-04,0.29225e-04, &
        & 0.30430e-04,0.30461e-04,0.28726e-04,0.23208e-04 /)
      kao(:, 5, 1, 7) = (/ &
        & 0.12355e-04,0.20495e-04,0.25505e-04,0.29189e-04,0.31816e-04, &
        & 0.33308e-04,0.33478e-04,0.31898e-04,0.26469e-04 /)
      kao(:, 1, 2, 7) = (/ &
        & 0.10350e-04,0.13753e-04,0.16101e-04,0.17726e-04,0.18733e-04, &
        & 0.19034e-04,0.18319e-04,0.16594e-04,0.11961e-04 /)
      kao(:, 2, 2, 7) = (/ &
        & 0.10365e-04,0.14706e-04,0.17542e-04,0.19561e-04,0.20895e-04, &
        & 0.21420e-04,0.21012e-04,0.19409e-04,0.14130e-04 /)
      kao(:, 3, 2, 7) = (/ &
        & 0.10364e-04,0.15733e-04,0.19081e-04,0.21505e-04,0.23181e-04, &
        & 0.23958e-04,0.23844e-04,0.22334e-04,0.16750e-04 /)
      kao(:, 4, 2, 7) = (/ &
        & 0.10354e-04,0.16759e-04,0.20670e-04,0.23471e-04,0.25440e-04, &
        & 0.26474e-04,0.26560e-04,0.25188e-04,0.19386e-04 /)
      kao(:, 5, 2, 7) = (/ &
        & 0.10329e-04,0.17823e-04,0.22292e-04,0.25488e-04,0.27703e-04, &
        & 0.28957e-04,0.29205e-04,0.27936e-04,0.22026e-04 /)
      kao(:, 1, 3, 7) = (/ &
        & 0.86408e-05,0.11607e-04,0.13624e-04,0.14928e-04,0.15622e-04, &
        & 0.15768e-04,0.15034e-04,0.13540e-04,0.91950e-05 /)
      kao(:, 2, 3, 7) = (/ &
        & 0.86478e-05,0.12463e-04,0.14889e-04,0.16508e-04,0.17482e-04, &
        & 0.17819e-04,0.17439e-04,0.15994e-04,0.11026e-04 /)
      kao(:, 3, 3, 7) = (/ &
        & 0.86444e-05,0.13354e-04,0.16234e-04,0.18159e-04,0.19394e-04, &
        & 0.19962e-04,0.19837e-04,0.18485e-04,0.13087e-04 /)
      kao(:, 4, 3, 7) = (/ &
        & 0.86273e-05,0.14262e-04,0.17647e-04,0.19921e-04,0.21457e-04, &
        & 0.22290e-04,0.22338e-04,0.21203e-04,0.15397e-04 /)
      kao(:, 5, 3, 7) = (/ &
        & 0.85960e-05,0.15200e-04,0.19031e-04,0.21649e-04,0.23415e-04, &
        & 0.24453e-04,0.24660e-04,0.23666e-04,0.17582e-04 /)
      kao(:, 1, 4, 7) = (/ &
        & 0.71803e-05,0.97101e-05,0.11373e-04,0.12321e-04,0.12789e-04, &
        & 0.12803e-04,0.12062e-04,0.10784e-04,0.69624e-05 /)
      kao(:, 2, 4, 7) = (/ &
        & 0.71855e-05,0.10459e-04,0.12456e-04,0.13673e-04,0.14371e-04, &
        & 0.14569e-04,0.14153e-04,0.12788e-04,0.84564e-05 /)
      kao(:, 3, 4, 7) = (/ &
        & 0.71795e-05,0.11229e-04,0.13608e-04,0.15091e-04,0.16013e-04, &
        & 0.16409e-04,0.16232e-04,0.15085e-04,0.10120e-04 /)
      kao(:, 4, 4, 7) = (/ &
        & 0.71584e-05,0.12023e-04,0.14800e-04,0.16568e-04,0.17732e-04, &
        & 0.18336e-04,0.18317e-04,0.17347e-04,0.11917e-04 /)
      kao(:, 5, 4, 7) = (/ &
        & 0.71267e-05,0.12845e-04,0.16058e-04,0.18162e-04,0.19580e-04, &
        & 0.20399e-04,0.20543e-04,0.19767e-04,0.13958e-04 /)
      kao(:, 1, 5, 7) = (/ &
        & 0.59442e-05,0.80861e-05,0.93878e-05,0.10066e-04,0.10362e-04, &
        & 0.10281e-04,0.95734e-05,0.84778e-05,0.52204e-05 /)
      kao(:, 2, 5, 7) = (/ &
        & 0.59498e-05,0.87281e-05,0.10301e-04,0.11210e-04,0.11702e-04, &
        & 0.11782e-04,0.11315e-04,0.10068e-04,0.64302e-05 /)
      kao(:, 3, 5, 7) = (/ &
        & 0.59430e-05,0.93925e-05,0.11277e-04,0.12419e-04,0.13099e-04, &
        & 0.13351e-04,0.13104e-04,0.12095e-04,0.77633e-05 /)
      kao(:, 4, 5, 7) = (/ &
        & 0.59217e-05,0.10078e-04,0.12288e-04,0.13686e-04,0.14573e-04, &
        & 0.14994e-04,0.14908e-04,0.14023e-04,0.92337e-05 /)
      kao(:, 5, 5, 7) = (/ &
        & 0.58935e-05,0.10789e-04,0.13390e-04,0.15066e-04,0.16172e-04, &
        & 0.16788e-04,0.16832e-04,0.16140e-04,0.10913e-04 /)
      kao(:, 1, 6, 7) = (/ &
        & 0.49077e-05,0.66672e-05,0.76412e-05,0.81181e-05,0.82831e-05, &
        & 0.81137e-05,0.74381e-05,0.64600e-05,0.38540e-05 /)
      kao(:, 2, 6, 7) = (/ &
        & 0.49136e-05,0.72093e-05,0.84100e-05,0.90761e-05,0.94026e-05, &
        & 0.93849e-05,0.88761e-05,0.77852e-05,0.48097e-05 /)
      kao(:, 3, 6, 7) = (/ &
        & 0.49088e-05,0.77732e-05,0.92304e-05,0.10089e-04,0.10581e-04, &
        & 0.10707e-04,0.10412e-04,0.94217e-05,0.58741e-05 /)
      kao(:, 4, 6, 7) = (/ &
        & 0.48919e-05,0.83551e-05,0.10086e-04,0.11166e-04,0.11831e-04, &
        & 0.12095e-04,0.11941e-04,0.11106e-04,0.70559e-05 /)
      kao(:, 5, 6, 7) = (/ &
        & 0.48652e-05,0.89412e-05,0.10983e-04,0.12289e-04,0.13118e-04, &
        & 0.13538e-04,0.13477e-04,0.12811e-04,0.83378e-05 /)
      kao(:, 1, 7, 7) = (/ &
        & 0.40428e-05,0.54588e-05,0.61687e-05,0.64926e-05,0.65568e-05, &
        & 0.63259e-05,0.56948e-05,0.49607e-05,0.28237e-05 /)
      kao(:, 2, 7, 7) = (/ &
        & 0.40484e-05,0.59019e-05,0.68052e-05,0.72891e-05,0.74881e-05, &
        & 0.73951e-05,0.68736e-05,0.59771e-05,0.35700e-05 /)
      kao(:, 3, 7, 7) = (/ &
        & 0.40443e-05,0.63719e-05,0.74936e-05,0.81309e-05,0.84699e-05, &
        & 0.84975e-05,0.81643e-05,0.72224e-05,0.43995e-05 /)
      kao(:, 4, 7, 7) = (/ &
        & 0.40304e-05,0.68636e-05,0.82100e-05,0.90329e-05,0.95142e-05, &
        & 0.96616e-05,0.94576e-05,0.86932e-05,0.53385e-05 /)
      kao(:, 5, 7, 7) = (/ &
        & 0.40097e-05,0.73587e-05,0.89665e-05,0.99825e-05,0.10592e-04, &
        & 0.10860e-04,0.10751e-04,0.10114e-04,0.63905e-05 /)
      kao(:, 1, 8, 7) = (/ &
        & 0.33247e-05,0.44437e-05,0.49476e-05,0.51623e-05,0.51521e-05, &
        & 0.48927e-05,0.43130e-05,0.36508e-05,0.20433e-05 /)
      kao(:, 2, 8, 7) = (/ &
        & 0.33302e-05,0.48035e-05,0.54757e-05,0.58129e-05,0.59219e-05, &
        & 0.57796e-05,0.52788e-05,0.45081e-05,0.26233e-05 /)
      kao(:, 3, 8, 7) = (/ &
        & 0.33275e-05,0.51944e-05,0.60436e-05,0.65119e-05,0.67329e-05, &
        & 0.66992e-05,0.63336e-05,0.54989e-05,0.32839e-05 /)
      kao(:, 4, 8, 7) = (/ &
        & 0.33167e-05,0.56042e-05,0.66425e-05,0.72606e-05,0.75965e-05, &
        & 0.76619e-05,0.74319e-05,0.66922e-05,0.40228e-05 /)
      kao(:, 5, 8, 7) = (/ &
        & 0.33014e-05,0.60212e-05,0.72748e-05,0.80496e-05,0.84940e-05, &
        & 0.86532e-05,0.85181e-05,0.78992e-05,0.48672e-05 /)
      kao(:, 1, 9, 7) = (/ &
        & 0.27310e-05,0.35992e-05,0.39468e-05,0.40831e-05,0.40161e-05, &
        & 0.37266e-05,0.32070e-05,0.27591e-05,0.14628e-05 /)
      kao(:, 2, 9, 7) = (/ &
        & 0.27361e-05,0.38904e-05,0.43781e-05,0.46075e-05,0.46475e-05, &
        & 0.44710e-05,0.39993e-05,0.33922e-05,0.19203e-05 /)
      kao(:, 3, 9, 7) = (/ &
        & 0.27349e-05,0.42103e-05,0.48448e-05,0.51814e-05,0.53150e-05, &
        & 0.52403e-05,0.48712e-05,0.41669e-05,0.24268e-05 /)
      kao(:, 4, 9, 7) = (/ &
        & 0.27270e-05,0.45504e-05,0.53414e-05,0.57970e-05,0.60255e-05, &
        & 0.60359e-05,0.57915e-05,0.51016e-05,0.30070e-05 /)
      kao(:, 5, 9, 7) = (/ &
        & 0.27146e-05,0.48994e-05,0.58660e-05,0.64467e-05,0.67684e-05, &
        & 0.68529e-05,0.66981e-05,0.61431e-05,0.36677e-05 /)
      kao(:, 1,10, 7) = (/ &
        & 0.22419e-05,0.29237e-05,0.31619e-05,0.32419e-05,0.31445e-05, &
        & 0.28618e-05,0.23945e-05,0.20454e-05,0.10493e-05 /)
      kao(:, 2,10, 7) = (/ &
        & 0.22458e-05,0.31578e-05,0.35134e-05,0.36703e-05,0.36665e-05, &
        & 0.34835e-05,0.30593e-05,0.25559e-05,0.14125e-05 /)
      kao(:, 3,10, 7) = (/ &
        & 0.22450e-05,0.34192e-05,0.38967e-05,0.41378e-05,0.42160e-05, &
        & 0.41184e-05,0.37724e-05,0.31954e-05,0.18099e-05 /)
      kao(:, 4,10, 7) = (/ &
        & 0.22393e-05,0.36988e-05,0.43039e-05,0.46449e-05,0.48027e-05, &
        & 0.47756e-05,0.45281e-05,0.39284e-05,0.22652e-05 /)
      kao(:, 5,10, 7) = (/ &
        & 0.22295e-05,0.39888e-05,0.47391e-05,0.51827e-05,0.54135e-05, &
        & 0.54517e-05,0.52919e-05,0.47894e-05,0.27859e-05 /)
      kao(:, 1,11, 7) = (/ &
        & 0.18412e-05,0.24512e-05,0.26550e-05,0.27210e-05,0.26438e-05, &
        & 0.24068e-05,0.20134e-05,0.16980e-05,0.87310e-06 /)
      kao(:, 2,11, 7) = (/ &
        & 0.18429e-05,0.26525e-05,0.29507e-05,0.30835e-05,0.30829e-05, &
        & 0.29354e-05,0.25810e-05,0.21539e-05,0.11715e-05 /)
      kao(:, 3,11, 7) = (/ &
        & 0.18405e-05,0.28725e-05,0.32735e-05,0.34815e-05,0.35507e-05, &
        & 0.34733e-05,0.31901e-05,0.26957e-05,0.15018e-05 /)
      kao(:, 4,11, 7) = (/ &
        & 0.18348e-05,0.31060e-05,0.36191e-05,0.39123e-05,0.40426e-05, &
        & 0.40206e-05,0.38184e-05,0.33125e-05,0.18804e-05 /)
      kao(:, 5,11, 7) = (/ &
        & 0.18263e-05,0.33539e-05,0.39862e-05,0.43590e-05,0.45516e-05, &
        & 0.45841e-05,0.44525e-05,0.40371e-05,0.23130e-05 /)
      kao(:, 1,12, 7) = (/ &
        & 0.15111e-05,0.20512e-05,0.22220e-05,0.22783e-05,0.22181e-05, &
        & 0.20219e-05,0.16992e-05,0.14085e-05,0.72438e-06 /)
      kao(:, 2,12, 7) = (/ &
        & 0.15111e-05,0.22209e-05,0.24719e-05,0.25841e-05,0.25877e-05, &
        & 0.24700e-05,0.21742e-05,0.18087e-05,0.96963e-06 /)
      kao(:, 3,12, 7) = (/ &
        & 0.15082e-05,0.24051e-05,0.27419e-05,0.29223e-05,0.29832e-05, &
        & 0.29201e-05,0.26833e-05,0.22609e-05,0.12444e-05 /)
      kao(:, 4,12, 7) = (/ &
        & 0.15029e-05,0.26018e-05,0.30364e-05,0.32843e-05,0.33933e-05, &
        & 0.33730e-05,0.32057e-05,0.27875e-05,0.15571e-05 /)
      kao(:, 5,12, 7) = (/ &
        & 0.14954e-05,0.28127e-05,0.33443e-05,0.36551e-05,0.38145e-05, &
        & 0.38425e-05,0.37317e-05,0.33866e-05,0.19133e-05 /)
      kao(:, 1,13, 7) = (/ &
        & 0.12390e-05,0.17127e-05,0.18553e-05,0.19025e-05,0.18568e-05, &
        & 0.16968e-05,0.14297e-05,0.11813e-05,0.59950e-06 /)
      kao(:, 2,13, 7) = (/ &
        & 0.12381e-05,0.18537e-05,0.20641e-05,0.21603e-05,0.21689e-05, &
        & 0.20712e-05,0.18216e-05,0.15132e-05,0.80096e-06 /)
      kao(:, 3,13, 7) = (/ &
        & 0.12352e-05,0.20080e-05,0.22929e-05,0.24467e-05,0.24992e-05, &
        & 0.24434e-05,0.22447e-05,0.18839e-05,0.10290e-05 /)
      kao(:, 4,13, 7) = (/ &
        & 0.12307e-05,0.21754e-05,0.25409e-05,0.27489e-05,0.28366e-05, &
        & 0.28171e-05,0.26776e-05,0.23303e-05,0.12853e-05 /)
      kao(:, 5,13, 7) = (/ &
        & 0.12246e-05,0.23532e-05,0.27977e-05,0.30556e-05,0.31857e-05, &
        & 0.32077e-05,0.31127e-05,0.28260e-05,0.15788e-05 /)
      kao(:, 1, 1, 8) = (/ &
        & 0.43566e-04,0.45402e-04,0.48829e-04,0.50194e-04,0.49978e-04, &
        & 0.48581e-04,0.45902e-04,0.40781e-04,0.34170e-04 /)
      kao(:, 2, 1, 8) = (/ &
        & 0.43974e-04,0.47415e-04,0.52012e-04,0.54325e-04,0.54921e-04, &
        & 0.53975e-04,0.51279e-04,0.46650e-04,0.40945e-04 /)
      kao(:, 3, 1, 8) = (/ &
        & 0.44333e-04,0.49545e-04,0.55453e-04,0.58909e-04,0.60094e-04, &
        & 0.59376e-04,0.56940e-04,0.52843e-04,0.48266e-04 /)
      kao(:, 4, 1, 8) = (/ &
        & 0.44647e-04,0.51771e-04,0.59155e-04,0.63607e-04,0.65306e-04, &
        & 0.64935e-04,0.62961e-04,0.59262e-04,0.55812e-04 /)
      kao(:, 5, 1, 8) = (/ &
        & 0.44938e-04,0.54202e-04,0.63063e-04,0.68229e-04,0.70615e-04, &
        & 0.70683e-04,0.69315e-04,0.65992e-04,0.63855e-04 /)
      kao(:, 1, 2, 8) = (/ &
        & 0.37849e-04,0.40606e-04,0.43836e-04,0.45171e-04,0.45318e-04, &
        & 0.44251e-04,0.41853e-04,0.37247e-04,0.29303e-04 /)
      kao(:, 2, 2, 8) = (/ &
        & 0.38202e-04,0.42545e-04,0.46901e-04,0.49156e-04,0.50002e-04, &
        & 0.49256e-04,0.46845e-04,0.42755e-04,0.35187e-04 /)
      kao(:, 3, 2, 8) = (/ &
        & 0.38525e-04,0.44570e-04,0.50219e-04,0.53465e-04,0.54833e-04, &
        & 0.54348e-04,0.52176e-04,0.48578e-04,0.41697e-04 /)
      kao(:, 4, 2, 8) = (/ &
        & 0.38828e-04,0.46787e-04,0.53767e-04,0.57818e-04,0.59705e-04, &
        & 0.59611e-04,0.57787e-04,0.54523e-04,0.48350e-04 /)
      kao(:, 5, 2, 8) = (/ &
        & 0.39076e-04,0.49105e-04,0.57380e-04,0.62144e-04,0.64743e-04, &
        & 0.65049e-04,0.63700e-04,0.60747e-04,0.55348e-04 /)
      kao(:, 1, 3, 8) = (/ &
        & 0.32392e-04,0.35504e-04,0.38232e-04,0.39483e-04,0.39809e-04, &
        & 0.39031e-04,0.36901e-04,0.32585e-04,0.23735e-04 /)
      kao(:, 2, 3, 8) = (/ &
        & 0.32715e-04,0.37303e-04,0.41039e-04,0.43202e-04,0.44102e-04, &
        & 0.43582e-04,0.41484e-04,0.37593e-04,0.28689e-04 /)
      kao(:, 3, 3, 8) = (/ &
        & 0.33011e-04,0.39216e-04,0.44127e-04,0.47180e-04,0.48515e-04, &
        & 0.48269e-04,0.46352e-04,0.42866e-04,0.34062e-04 /)
      kao(:, 4, 3, 8) = (/ &
        & 0.33271e-04,0.41283e-04,0.47451e-04,0.51158e-04,0.53031e-04, &
        & 0.53191e-04,0.51599e-04,0.48489e-04,0.40122e-04 /)
      kao(:, 5, 3, 8) = (/ &
        & 0.33495e-04,0.43439e-04,0.50779e-04,0.55143e-04,0.57687e-04, &
        & 0.58208e-04,0.56935e-04,0.54138e-04,0.46109e-04 /)
      kao(:, 1, 4, 8) = (/ &
        & 0.27415e-04,0.30543e-04,0.32764e-04,0.33940e-04,0.34340e-04, &
        & 0.33775e-04,0.31812e-04,0.27722e-04,0.18770e-04 /)
      kao(:, 2, 4, 8) = (/ &
        & 0.27715e-04,0.32169e-04,0.35304e-04,0.37332e-04,0.38224e-04, &
        & 0.37868e-04,0.35986e-04,0.32265e-04,0.22928e-04 /)
      kao(:, 3, 4, 8) = (/ &
        & 0.27982e-04,0.33932e-04,0.38141e-04,0.40925e-04,0.42223e-04, &
        & 0.42122e-04,0.40409e-04,0.37026e-04,0.27474e-04 /)
      kao(:, 4, 4, 8) = (/ &
        & 0.28215e-04,0.35808e-04,0.41184e-04,0.44532e-04,0.46320e-04, &
        & 0.46554e-04,0.45091e-04,0.41998e-04,0.32462e-04 /)
      kao(:, 5, 4, 8) = (/ &
        & 0.28437e-04,0.37809e-04,0.44202e-04,0.48199e-04,0.50577e-04, &
        & 0.51211e-04,0.50186e-04,0.47427e-04,0.38088e-04 /)
      kao(:, 1, 5, 8) = (/ &
        & 0.23010e-04,0.25978e-04,0.27838e-04,0.28899e-04,0.29286e-04, &
        & 0.28721e-04,0.26945e-04,0.23196e-04,0.14687e-04 /)
      kao(:, 2, 5, 8) = (/ &
        & 0.23283e-04,0.27434e-04,0.30115e-04,0.31931e-04,0.32743e-04, &
        & 0.32398e-04,0.30674e-04,0.27269e-04,0.18140e-04 /)
      kao(:, 3, 5, 8) = (/ &
        & 0.23522e-04,0.29002e-04,0.32686e-04,0.35125e-04,0.36325e-04, &
        & 0.36232e-04,0.34626e-04,0.31511e-04,0.21987e-04 /)
      kao(:, 4, 5, 8) = (/ &
        & 0.23738e-04,0.30687e-04,0.35404e-04,0.38366e-04,0.40013e-04, &
        & 0.40198e-04,0.38830e-04,0.35973e-04,0.26236e-04 /)
      kao(:, 5, 5, 8) = (/ &
        & 0.23936e-04,0.32534e-04,0.38093e-04,0.41748e-04,0.43875e-04, &
        & 0.44440e-04,0.43519e-04,0.40954e-04,0.31086e-04 /)
      kao(:, 1, 6, 8) = (/ &
        & 0.19172e-04,0.21867e-04,0.23409e-04,0.24321e-04,0.24529e-04, &
        & 0.23927e-04,0.22333e-04,0.18955e-04,0.11218e-04 /)
      kao(:, 2, 6, 8) = (/ &
        & 0.19419e-04,0.23150e-04,0.25412e-04,0.26974e-04,0.27574e-04, &
        & 0.27129e-04,0.25625e-04,0.22590e-04,0.14082e-04 /)
      kao(:, 3, 6, 8) = (/ &
        & 0.19636e-04,0.24533e-04,0.27708e-04,0.29785e-04,0.30733e-04, &
        & 0.30517e-04,0.29114e-04,0.26329e-04,0.17293e-04 /)
      kao(:, 4, 6, 8) = (/ &
        & 0.19836e-04,0.26054e-04,0.30093e-04,0.32660e-04,0.34002e-04, &
        & 0.34049e-04,0.32819e-04,0.30271e-04,0.20869e-04 /)
      kao(:, 5, 6, 8) = (/ &
        & 0.20002e-04,0.27734e-04,0.32461e-04,0.35638e-04,0.37355e-04, &
        & 0.37686e-04,0.36788e-04,0.34519e-04,0.24769e-04 /)
      kao(:, 1, 7, 8) = (/ &
        & 0.15886e-04,0.18280e-04,0.19557e-04,0.20235e-04,0.20297e-04, &
        & 0.19642e-04,0.18202e-04,0.15130e-04,0.84335e-05 /)
      kao(:, 2, 7, 8) = (/ &
        & 0.16105e-04,0.19408e-04,0.21322e-04,0.22532e-04,0.22888e-04, &
        & 0.22409e-04,0.21064e-04,0.18396e-04,0.10766e-04 /)
      kao(:, 3, 7, 8) = (/ &
        & 0.16304e-04,0.20629e-04,0.23329e-04,0.24999e-04,0.25612e-04, &
        & 0.25350e-04,0.24115e-04,0.21685e-04,0.13408e-04 /)
      kao(:, 4, 7, 8) = (/ &
        & 0.16482e-04,0.21985e-04,0.25409e-04,0.27506e-04,0.28475e-04, &
        & 0.28447e-04,0.27347e-04,0.25116e-04,0.16377e-04 /)
      kao(:, 5, 7, 8) = (/ &
        & 0.16621e-04,0.23483e-04,0.27507e-04,0.30111e-04,0.31449e-04, &
        & 0.31651e-04,0.30823e-04,0.28853e-04,0.19647e-04 /)
      kao(:, 1, 8, 8) = (/ &
        & 0.13104e-04,0.15202e-04,0.16227e-04,0.16675e-04,0.16618e-04, &
        & 0.15949e-04,0.14642e-04,0.11862e-04,0.62741e-05 /)
      kao(:, 2, 8, 8) = (/ &
        & 0.13296e-04,0.16183e-04,0.17762e-04,0.18645e-04,0.18799e-04, &
        & 0.18302e-04,0.17108e-04,0.14749e-04,0.81431e-05 /)
      kao(:, 3, 8, 8) = (/ &
        & 0.13475e-04,0.17250e-04,0.19501e-04,0.20748e-04,0.21144e-04, &
        & 0.20825e-04,0.19726e-04,0.17623e-04,0.10291e-04 /)
      kao(:, 4, 8, 8) = (/ &
        & 0.13631e-04,0.18462e-04,0.21319e-04,0.22916e-04,0.23622e-04, &
        & 0.23509e-04,0.22509e-04,0.20604e-04,0.12727e-04 /)
      kao(:, 5, 8, 8) = (/ &
        & 0.13752e-04,0.19773e-04,0.23162e-04,0.25182e-04,0.26210e-04, &
        & 0.26298e-04,0.25526e-04,0.23837e-04,0.15433e-04 /)
      kao(:, 1, 9, 8) = (/ &
        & 0.10771e-04,0.12580e-04,0.13349e-04,0.13617e-04,0.13459e-04, &
        & 0.12816e-04,0.11635e-04,0.90636e-05,0.45849e-05 /)
      kao(:, 2, 9, 8) = (/ &
        & 0.10937e-04,0.13431e-04,0.14667e-04,0.15270e-04,0.15289e-04, &
        & 0.14786e-04,0.13720e-04,0.11614e-04,0.60707e-05 /)
      kao(:, 3, 9, 8) = (/ &
        & 0.11095e-04,0.14367e-04,0.16153e-04,0.17055e-04,0.17287e-04, &
        & 0.16925e-04,0.15948e-04,0.14098e-04,0.78037e-05 /)
      kao(:, 4, 9, 8) = (/ &
        & 0.11230e-04,0.15436e-04,0.17715e-04,0.18921e-04,0.19404e-04, &
        & 0.19208e-04,0.18318e-04,0.16668e-04,0.97810e-05 /)
      kao(:, 5, 9, 8) = (/ &
        & 0.11337e-04,0.16572e-04,0.19310e-04,0.20882e-04,0.21623e-04, &
        & 0.21621e-04,0.20902e-04,0.19439e-04,0.11994e-04 /)
      kao(:, 1,10, 8) = (/ &
        & 0.88397e-05,0.10407e-04,0.10992e-04,0.11130e-04,0.10914e-04, &
        & 0.10319e-04,0.92746e-05,0.69230e-05,0.33878e-05 /)
      kao(:, 2,10, 8) = (/ &
        & 0.89820e-05,0.11148e-04,0.12114e-04,0.12509e-04,0.12455e-04, &
        & 0.11973e-04,0.11026e-04,0.91303e-05,0.45777e-05 /)
      kao(:, 3,10, 8) = (/ &
        & 0.91201e-05,0.11975e-04,0.13369e-04,0.14032e-04,0.14150e-04, &
        & 0.13774e-04,0.12899e-04,0.11289e-04,0.59718e-05 /)
      kao(:, 4,10, 8) = (/ &
        & 0.92338e-05,0.12910e-04,0.14708e-04,0.15633e-04,0.15947e-04, &
        & 0.15711e-04,0.14916e-04,0.13483e-04,0.75778e-05 /)
      kao(:, 5,10, 8) = (/ &
        & 0.93270e-05,0.13899e-04,0.16089e-04,0.17313e-04,0.17838e-04, &
        & 0.17779e-04,0.17126e-04,0.15852e-04,0.93849e-05 /)
      kao(:, 1,11, 8) = (/ &
        & 0.72957e-05,0.88518e-05,0.94180e-05,0.95477e-05,0.93627e-05, &
        & 0.88681e-05,0.79846e-05,0.60665e-05,0.28938e-05 /)
      kao(:, 2,11, 8) = (/ &
        & 0.74164e-05,0.95244e-05,0.10413e-04,0.10760e-04,0.10725e-04, &
        & 0.10300e-04,0.94914e-05,0.79265e-05,0.39145e-05 /)
      kao(:, 3,11, 8) = (/ &
        & 0.75267e-05,0.10290e-04,0.11516e-04,0.12091e-04,0.12186e-04, &
        & 0.11866e-04,0.11116e-04,0.97843e-05,0.51152e-05 /)
      kao(:, 4,11, 8) = (/ &
        & 0.76165e-05,0.11127e-04,0.12682e-04,0.13483e-04,0.13746e-04, &
        & 0.13546e-04,0.12885e-04,0.11704e-04,0.64876e-05 /)
      kao(:, 5,11, 8) = (/ &
        & 0.76866e-05,0.11972e-04,0.13896e-04,0.14938e-04,0.15405e-04, &
        & 0.15374e-04,0.14838e-04,0.13790e-04,0.80319e-05 /)
      kao(:, 1,12, 8) = (/ &
        & 0.60137e-05,0.75193e-05,0.80348e-05,0.81538e-05,0.80064e-05, &
        & 0.75822e-05,0.68354e-05,0.52502e-05,0.24674e-05 /)
      kao(:, 2,12, 8) = (/ &
        & 0.61150e-05,0.81325e-05,0.89089e-05,0.92208e-05,0.91831e-05, &
        & 0.88171e-05,0.81283e-05,0.68396e-05,0.33429e-05 /)
      kao(:, 3,12, 8) = (/ &
        & 0.62020e-05,0.88113e-05,0.98818e-05,0.10369e-04,0.10440e-04, &
        & 0.10164e-04,0.95355e-05,0.84372e-05,0.43683e-05 /)
      kao(:, 4,12, 8) = (/ &
        & 0.62729e-05,0.95382e-05,0.10890e-04,0.11569e-04,0.11793e-04, &
        & 0.11630e-04,0.11082e-04,0.10108e-04,0.55358e-05 /)
      kao(:, 5,12, 8) = (/ &
        & 0.63199e-05,0.10271e-04,0.11934e-04,0.12838e-04,0.13254e-04, &
        & 0.13231e-04,0.12796e-04,0.11934e-04,0.68492e-05 /)
      kao(:, 1,13, 8) = (/ &
        & 0.49517e-05,0.63774e-05,0.68261e-05,0.69411e-05,0.68151e-05, &
        & 0.64513e-05,0.58220e-05,0.45056e-05,0.20980e-05 /)
      kao(:, 2,13, 8) = (/ &
        & 0.50331e-05,0.69207e-05,0.75990e-05,0.78660e-05,0.78231e-05, &
        & 0.75119e-05,0.69333e-05,0.58688e-05,0.28426e-05 /)
      kao(:, 3,13, 8) = (/ &
        & 0.51036e-05,0.75155e-05,0.84393e-05,0.88490e-05,0.89047e-05, &
        & 0.86720e-05,0.81449e-05,0.72410e-05,0.37114e-05 /)
      kao(:, 4,13, 8) = (/ &
        & 0.51548e-05,0.81445e-05,0.93105e-05,0.98793e-05,0.10078e-04, &
        & 0.99535e-05,0.94951e-05,0.86973e-05,0.47002e-05 /)
      kao(:, 5,13, 8) = (/ &
        & 0.51867e-05,0.87857e-05,0.10211e-04,0.10992e-04,0.11352e-04, &
        & 0.11351e-04,0.10990e-04,0.10277e-04,0.58153e-05 /)
      kao(:, 1, 1, 9) = (/ &
        & 0.18292e-03,0.16357e-03,0.15341e-03,0.14585e-03,0.13797e-03, &
        & 0.12826e-03,0.11477e-03,0.99322e-04,0.99311e-04 /)
      kao(:, 2, 1, 9) = (/ &
        & 0.18277e-03,0.16502e-03,0.15805e-03,0.15290e-03,0.14696e-03, &
        & 0.13850e-03,0.12664e-03,0.11419e-03,0.11887e-03 /)
      kao(:, 3, 1, 9) = (/ &
        & 0.18261e-03,0.16694e-03,0.16322e-03,0.16061e-03,0.15658e-03, &
        & 0.14997e-03,0.14010e-03,0.13154e-03,0.14123e-03 /)
      kao(:, 4, 1, 9) = (/ &
        & 0.18244e-03,0.16952e-03,0.16897e-03,0.16909e-03,0.16740e-03, &
        & 0.16268e-03,0.15556e-03,0.15163e-03,0.16610e-03 /)
      kao(:, 5, 1, 9) = (/ &
        & 0.18218e-03,0.17247e-03,0.17521e-03,0.17844e-03,0.17911e-03, &
        & 0.17696e-03,0.17241e-03,0.17370e-03,0.19290e-03 /)
      kao(:, 1, 2, 9) = (/ &
        & 0.17473e-03,0.15735e-03,0.14910e-03,0.14227e-03,0.13471e-03, &
        & 0.12515e-03,0.11200e-03,0.94986e-04,0.89520e-04 /)
      kao(:, 2, 2, 9) = (/ &
        & 0.17467e-03,0.15907e-03,0.15401e-03,0.14953e-03,0.14402e-03, &
        & 0.13581e-03,0.12401e-03,0.10893e-03,0.10811e-03 /)
      kao(:, 3, 2, 9) = (/ &
        & 0.17463e-03,0.16142e-03,0.15942e-03,0.15773e-03,0.15417e-03, &
        & 0.14769e-03,0.13747e-03,0.12528e-03,0.12924e-03 /)
      kao(:, 4, 2, 9) = (/ &
        & 0.17449e-03,0.16426e-03,0.16549e-03,0.16671e-03,0.16541e-03, &
        & 0.16085e-03,0.15263e-03,0.14389e-03,0.15270e-03 /)
      kao(:, 5, 2, 9) = (/ &
        & 0.17439e-03,0.16753e-03,0.17238e-03,0.17658e-03,0.17759e-03, &
        & 0.17537e-03,0.16910e-03,0.16442e-03,0.17796e-03 /)
      kao(:, 1, 3, 9) = (/ &
        & 0.16429e-03,0.14895e-03,0.14201e-03,0.13557e-03,0.12797e-03, &
        & 0.11829e-03,0.10548e-03,0.88188e-04,0.77280e-04 /)
      kao(:, 2, 3, 9) = (/ &
        & 0.16436e-03,0.15092e-03,0.14708e-03,0.14277e-03,0.13731e-03, &
        & 0.12899e-03,0.11719e-03,0.10108e-03,0.94071e-04 /)
      kao(:, 3, 3, 9) = (/ &
        & 0.16438e-03,0.15344e-03,0.15259e-03,0.15105e-03,0.14760e-03, &
        & 0.14078e-03,0.13037e-03,0.11602e-03,0.11331e-03 /)
      kao(:, 4, 3, 9) = (/ &
        & 0.16440e-03,0.15651e-03,0.15877e-03,0.16021e-03,0.15883e-03, &
        & 0.15394e-03,0.14519e-03,0.13303e-03,0.13463e-03 /)
      kao(:, 5, 3, 9) = (/ &
        & 0.16444e-03,0.16001e-03,0.16595e-03,0.17023e-03,0.17105e-03, &
        & 0.16855e-03,0.16116e-03,0.15159e-03,0.15764e-03 /)
      kao(:, 1, 4, 9) = (/ &
        & 0.15195e-03,0.13883e-03,0.13294e-03,0.12699e-03,0.11928e-03, &
        & 0.10948e-03,0.97355e-04,0.80985e-04,0.65303e-04 /)
      kao(:, 2, 4, 9) = (/ &
        & 0.15212e-03,0.14097e-03,0.13802e-03,0.13404e-03,0.12836e-03, &
        & 0.11996e-03,0.10855e-03,0.92884e-04,0.80285e-04 /)
      kao(:, 3, 4, 9) = (/ &
        & 0.15229e-03,0.14364e-03,0.14356e-03,0.14222e-03,0.13844e-03, &
        & 0.13147e-03,0.12124e-03,0.10661e-03,0.97473e-04 /)
      kao(:, 4, 4, 9) = (/ &
        & 0.15247e-03,0.14694e-03,0.14987e-03,0.15132e-03,0.14947e-03, &
        & 0.14428e-03,0.13562e-03,0.12218e-03,0.11647e-03 /)
      kao(:, 5, 4, 9) = (/ &
        & 0.15268e-03,0.15064e-03,0.15719e-03,0.16126e-03,0.16162e-03, &
        & 0.15869e-03,0.15101e-03,0.13904e-03,0.13733e-03 /)
      kao(:, 1, 5, 9) = (/ &
        & 0.13846e-03,0.12761e-03,0.12265e-03,0.11713e-03,0.10945e-03, &
        & 0.10011e-03,0.88713e-04,0.73647e-04,0.54834e-04 /)
      kao(:, 2, 5, 9) = (/ &
        & 0.13872e-03,0.12987e-03,0.12766e-03,0.12392e-03,0.11814e-03, &
        & 0.11013e-03,0.99375e-04,0.84759e-04,0.68007e-04 /)
      kao(:, 3, 5, 9) = (/ &
        & 0.13899e-03,0.13272e-03,0.13319e-03,0.13187e-03,0.12795e-03, &
        & 0.12108e-03,0.11145e-03,0.97499e-04,0.83096e-04 /)
      kao(:, 4, 5, 9) = (/ &
        & 0.13930e-03,0.13617e-03,0.13955e-03,0.14081e-03,0.13862e-03, &
        & 0.13340e-03,0.12522e-03,0.11183e-03,0.99891e-04 /)
      kao(:, 5, 5, 9) = (/ &
        & 0.13961e-03,0.13997e-03,0.14692e-03,0.15049e-03,0.15045e-03, &
        & 0.14736e-03,0.14024e-03,0.12733e-03,0.11865e-03 /)
      kao(:, 1, 6, 9) = (/ &
        & 0.12419e-03,0.11551e-03,0.11132e-03,0.10604e-03,0.98912e-04, &
        & 0.90174e-04,0.79553e-04,0.65781e-04,0.45228e-04 /)
      kao(:, 2, 6, 9) = (/ &
        & 0.12454e-03,0.11786e-03,0.11619e-03,0.11259e-03,0.10704e-03, &
        & 0.99552e-04,0.89546e-04,0.76061e-04,0.56748e-04 /)
      kao(:, 3, 6, 9) = (/ &
        & 0.12490e-03,0.12081e-03,0.12161e-03,0.12024e-03,0.11632e-03, &
        & 0.10988e-03,0.10081e-03,0.87950e-04,0.69901e-04 /)
      kao(:, 4, 6, 9) = (/ &
        & 0.12528e-03,0.12425e-03,0.12796e-03,0.12887e-03,0.12649e-03, &
        & 0.12150e-03,0.11381e-03,0.10130e-03,0.84575e-04 /)
      kao(:, 5, 6, 9) = (/ &
        & 0.12568e-03,0.12811e-03,0.13519e-03,0.13816e-03,0.13780e-03, &
        & 0.13476e-03,0.12819e-03,0.11553e-03,0.10091e-03 /)
      kao(:, 1, 7, 9) = (/ &
        & 0.10978e-03,0.10308e-03,0.99508e-04,0.94571e-04,0.88120e-04, &
        & 0.80226e-04,0.70492e-04,0.57993e-04,0.36699e-04 /)
      kao(:, 2, 7, 9) = (/ &
        & 0.11018e-03,0.10544e-03,0.10415e-03,0.10080e-03,0.95769e-04, &
        & 0.88865e-04,0.79698e-04,0.67450e-04,0.46683e-04 /)
      kao(:, 3, 7, 9) = (/ &
        & 0.11058e-03,0.10837e-03,0.10936e-03,0.10807e-03,0.10453e-03, &
        & 0.98497e-04,0.90104e-04,0.78443e-04,0.58212e-04 /)
      kao(:, 4, 7, 9) = (/ &
        & 0.11104e-03,0.11179e-03,0.11551e-03,0.11629e-03,0.11409e-03, &
        & 0.10934e-03,0.10217e-03,0.90913e-04,0.71131e-04 /)
      kao(:, 5, 7, 9) = (/ &
        & 0.11149e-03,0.11560e-03,0.12257e-03,0.12521e-03,0.12472e-03, &
        & 0.12180e-03,0.11572e-03,0.10421e-03,0.85542e-04 /)
      kao(:, 1, 8, 9) = (/ &
        & 0.95759e-04,0.90773e-04,0.87806e-04,0.83290e-04,0.77515e-04, &
        & 0.70528e-04,0.61795e-04,0.50465e-04,0.29380e-04 /)
      kao(:, 2, 8, 9) = (/ &
        & 0.96189e-04,0.93120e-04,0.92132e-04,0.89103e-04,0.84653e-04, &
        & 0.78456e-04,0.70159e-04,0.59177e-04,0.37867e-04 /)
      kao(:, 3, 8, 9) = (/ &
        & 0.96665e-04,0.96018e-04,0.97008e-04,0.95975e-04,0.92760e-04, &
        & 0.87379e-04,0.79687e-04,0.69248e-04,0.47855e-04 /)
      kao(:, 4, 8, 9) = (/ &
        & 0.97168e-04,0.99322e-04,0.10289e-03,0.10373e-03,0.10169e-03, &
        & 0.97397e-04,0.90796e-04,0.80805e-04,0.59240e-04 /)
      kao(:, 5, 8, 9) = (/ &
        & 0.97641e-04,0.10302e-03,0.10967e-03,0.11218e-03,0.11166e-03, &
        & 0.10896e-03,0.10343e-03,0.93210e-04,0.71998e-04 /)
      kao(:, 1, 9, 9) = (/ &
        & 0.82482e-04,0.78941e-04,0.76398e-04,0.72429e-04,0.67369e-04, &
        & 0.61188e-04,0.53486e-04,0.43219e-04,0.23144e-04 /)
      kao(:, 2, 9, 9) = (/ &
        & 0.82941e-04,0.81194e-04,0.80391e-04,0.77783e-04,0.73924e-04, &
        & 0.68383e-04,0.61055e-04,0.51145e-04,0.30235e-04 /)
      kao(:, 3, 9, 9) = (/ &
        & 0.83462e-04,0.83998e-04,0.84977e-04,0.84161e-04,0.81323e-04, &
        & 0.76538e-04,0.69739e-04,0.60350e-04,0.38714e-04 /)
      kao(:, 4, 9, 9) = (/ &
        & 0.83976e-04,0.87153e-04,0.90583e-04,0.91413e-04,0.89589e-04, &
        & 0.85741e-04,0.79900e-04,0.70947e-04,0.48553e-04 /)
      kao(:, 5, 9, 9) = (/ &
        & 0.84461e-04,0.90734e-04,0.96938e-04,0.99296e-04,0.98864e-04, &
        & 0.96399e-04,0.91511e-04,0.82490e-04,0.59777e-04 /)
      kao(:, 1,10, 9) = (/ &
        & 0.70371e-04,0.68110e-04,0.65986e-04,0.62636e-04,0.58303e-04, &
        & 0.52961e-04,0.46122e-04,0.37036e-04,0.18341e-04 /)
      kao(:, 2,10, 9) = (/ &
        & 0.70853e-04,0.70288e-04,0.69669e-04,0.67543e-04,0.64271e-04, &
        & 0.59496e-04,0.53052e-04,0.44224e-04,0.24306e-04 /)
      kao(:, 3,10, 9) = (/ &
        & 0.71373e-04,0.72956e-04,0.74034e-04,0.73423e-04,0.71076e-04, &
        & 0.66934e-04,0.61048e-04,0.52623e-04,0.31537e-04 /)
      kao(:, 4,10, 9) = (/ &
        & 0.71862e-04,0.75946e-04,0.79283e-04,0.80149e-04,0.78712e-04, &
        & 0.75412e-04,0.70399e-04,0.62323e-04,0.40041e-04 /)
      kao(:, 5,10, 9) = (/ &
        & 0.72376e-04,0.79405e-04,0.85220e-04,0.87544e-04,0.87332e-04, &
        & 0.85268e-04,0.81104e-04,0.73085e-04,0.49845e-04 /)
      kao(:, 1,11, 9) = (/ &
        & 0.59776e-04,0.59155e-04,0.57996e-04,0.55642e-04,0.52323e-04, &
        & 0.47930e-04,0.42036e-04,0.34179e-04,0.16514e-04 /)
      kao(:, 2,11, 9) = (/ &
        & 0.60275e-04,0.61436e-04,0.61654e-04,0.60490e-04,0.58055e-04, &
        & 0.54242e-04,0.48750e-04,0.41144e-04,0.21987e-04 /)
      kao(:, 3,11, 9) = (/ &
        & 0.60746e-04,0.64075e-04,0.66078e-04,0.66233e-04,0.64629e-04, &
        & 0.61455e-04,0.56611e-04,0.49290e-04,0.28648e-04 /)
      kao(:, 4,11, 9) = (/ &
        & 0.61244e-04,0.67066e-04,0.71217e-04,0.72696e-04,0.72050e-04, &
        & 0.69816e-04,0.65797e-04,0.58590e-04,0.36515e-04 /)
      kao(:, 5,11, 9) = (/ &
        & 0.61769e-04,0.70693e-04,0.76979e-04,0.79872e-04,0.80561e-04, &
        & 0.79478e-04,0.76089e-04,0.68898e-04,0.45628e-04 /)
      kao(:, 1,12, 9) = (/ &
        & 0.50518e-04,0.51187e-04,0.50822e-04,0.49284e-04,0.46769e-04, &
        & 0.43097e-04,0.38110e-04,0.31379e-04,0.14783e-04 /)
      kao(:, 2,12, 9) = (/ &
        & 0.50964e-04,0.53463e-04,0.54457e-04,0.54020e-04,0.52266e-04, &
        & 0.49174e-04,0.44595e-04,0.38042e-04,0.19796e-04 /)
      kao(:, 3,12, 9) = (/ &
        & 0.51421e-04,0.56033e-04,0.58762e-04,0.59481e-04,0.58578e-04, &
        & 0.56207e-04,0.52260e-04,0.45820e-04,0.25919e-04 /)
      kao(:, 4,12, 9) = (/ &
        & 0.51920e-04,0.59121e-04,0.63731e-04,0.65674e-04,0.65806e-04, &
        & 0.64464e-04,0.61120e-04,0.54677e-04,0.33164e-04 /)
      kao(:, 5,12, 9) = (/ &
        & 0.52396e-04,0.62780e-04,0.69274e-04,0.72637e-04,0.74145e-04, &
        & 0.73831e-04,0.71039e-04,0.64514e-04,0.41597e-04 /)
      kao(:, 1,13, 9) = (/ &
        & 0.42486e-04,0.44174e-04,0.44463e-04,0.43555e-04,0.41568e-04, &
        & 0.38563e-04,0.34384e-04,0.28625e-04,0.13171e-04 /)
      kao(:, 2,13, 9) = (/ &
        & 0.42904e-04,0.46376e-04,0.47979e-04,0.48065e-04,0.46867e-04, &
        & 0.44391e-04,0.40615e-04,0.34938e-04,0.17746e-04 /)
      kao(:, 3,13, 9) = (/ &
        & 0.43349e-04,0.48965e-04,0.52137e-04,0.53262e-04,0.52962e-04, &
        & 0.51246e-04,0.47996e-04,0.42282e-04,0.23342e-04 /)
      kao(:, 4,13, 9) = (/ &
        & 0.43790e-04,0.52076e-04,0.56889e-04,0.59186e-04,0.60002e-04, &
        & 0.59254e-04,0.56460e-04,0.50705e-04,0.29999e-04 /)
      kao(:, 5,13, 9) = (/ &
        & 0.44254e-04,0.55629e-04,0.62209e-04,0.65993e-04,0.68105e-04, &
        & 0.68270e-04,0.65941e-04,0.60145e-04,0.37728e-04 /)
      kao(:, 1, 1,10) = (/ &
        & 0.42864e-03,0.37538e-03,0.32907e-03,0.29701e-03,0.26399e-03, &
        & 0.23587e-03,0.21519e-03,0.20736e-03,0.23690e-03 /)
      kao(:, 2, 1,10) = (/ &
        & 0.42770e-03,0.37463e-03,0.33468e-03,0.30443e-03,0.27635e-03, &
        & 0.25424e-03,0.24068e-03,0.24289e-03,0.27885e-03 /)
      kao(:, 3, 1,10) = (/ &
        & 0.42742e-03,0.37444e-03,0.34109e-03,0.31378e-03,0.29265e-03, &
        & 0.27618e-03,0.26729e-03,0.27967e-03,0.32090e-03 /)
      kao(:, 4, 1,10) = (/ &
        & 0.42756e-03,0.37461e-03,0.34714e-03,0.32647e-03,0.30721e-03, &
        & 0.29888e-03,0.29503e-03,0.31853e-03,0.36629e-03 /)
      kao(:, 5, 1,10) = (/ &
        & 0.42817e-03,0.37676e-03,0.35506e-03,0.34027e-03,0.32593e-03, &
        & 0.32117e-03,0.33159e-03,0.36650e-03,0.42307e-03 /)
      kao(:, 1, 2,10) = (/ &
        & 0.44647e-03,0.39099e-03,0.34399e-03,0.31315e-03,0.27681e-03, &
        & 0.24757e-03,0.21977e-03,0.20260e-03,0.22465e-03 /)
      kao(:, 2, 2,10) = (/ &
        & 0.44675e-03,0.39126e-03,0.35094e-03,0.32069e-03,0.29009e-03, &
        & 0.26696e-03,0.24338e-03,0.23431e-03,0.26448e-03 /)
      kao(:, 3, 2,10) = (/ &
        & 0.44728e-03,0.39176e-03,0.35848e-03,0.33002e-03,0.30752e-03, &
        & 0.28763e-03,0.26835e-03,0.26923e-03,0.30805e-03 /)
      kao(:, 4, 2,10) = (/ &
        & 0.44805e-03,0.39321e-03,0.36547e-03,0.34473e-03,0.32431e-03, &
        & 0.30833e-03,0.29659e-03,0.31021e-03,0.35789e-03 /)
      kao(:, 5, 2,10) = (/ &
        & 0.44833e-03,0.39641e-03,0.37373e-03,0.35955e-03,0.34286e-03, &
        & 0.33059e-03,0.33253e-03,0.36056e-03,0.41785e-03 /)
      kao(:, 1, 3,10) = (/ &
        & 0.45575e-03,0.39903e-03,0.35239e-03,0.32061e-03,0.28610e-03, &
        & 0.25358e-03,0.22160e-03,0.19044e-03,0.19754e-03 /)
      kao(:, 2, 3,10) = (/ &
        & 0.45658e-03,0.39983e-03,0.35980e-03,0.32984e-03,0.29898e-03, &
        & 0.27505e-03,0.24328e-03,0.21905e-03,0.23515e-03 /)
      kao(:, 3, 3,10) = (/ &
        & 0.45737e-03,0.40126e-03,0.36866e-03,0.34025e-03,0.31808e-03, &
        & 0.29648e-03,0.26565e-03,0.25100e-03,0.27824e-03 /)
      kao(:, 4, 3,10) = (/ &
        & 0.45822e-03,0.40344e-03,0.37727e-03,0.35639e-03,0.33753e-03, &
        & 0.31544e-03,0.29107e-03,0.29011e-03,0.33040e-03 /)
      kao(:, 5, 3,10) = (/ &
        & 0.45803e-03,0.40724e-03,0.38685e-03,0.37303e-03,0.35804e-03, &
        & 0.33477e-03,0.32542e-03,0.34063e-03,0.39188e-03 /)
      kao(:, 1, 4,10) = (/ &
        & 0.45696e-03,0.40009e-03,0.35533e-03,0.32134e-03,0.28977e-03, &
        & 0.25642e-03,0.22005e-03,0.17825e-03,0.16960e-03 /)
      kao(:, 2, 4,10) = (/ &
        & 0.45799e-03,0.40164e-03,0.36303e-03,0.33235e-03,0.30343e-03, &
        & 0.27796e-03,0.24341e-03,0.20303e-03,0.20347e-03 /)
      kao(:, 3, 4,10) = (/ &
        & 0.45889e-03,0.40391e-03,0.37251e-03,0.34409e-03,0.32396e-03, &
        & 0.30068e-03,0.26403e-03,0.23112e-03,0.24434e-03 /)
      kao(:, 4, 4,10) = (/ &
        & 0.45955e-03,0.40640e-03,0.38203e-03,0.36158e-03,0.34561e-03, &
        & 0.32162e-03,0.28613e-03,0.26715e-03,0.29513e-03 /)
      kao(:, 5, 4,10) = (/ &
        & 0.45899e-03,0.41016e-03,0.39290e-03,0.38024e-03,0.36719e-03, &
        & 0.34183e-03,0.31736e-03,0.31348e-03,0.35430e-03 /)
      kao(:, 1, 5,10) = (/ &
        & 0.44860e-03,0.39309e-03,0.35143e-03,0.31765e-03,0.28887e-03, &
        & 0.25439e-03,0.21652e-03,0.16876e-03,0.14333e-03 /)
      kao(:, 2, 5,10) = (/ &
        & 0.45003e-03,0.39579e-03,0.35959e-03,0.33075e-03,0.30371e-03, &
        & 0.27559e-03,0.24058e-03,0.19058e-03,0.17442e-03 /)
      kao(:, 3, 5,10) = (/ &
        & 0.45146e-03,0.39890e-03,0.36951e-03,0.34437e-03,0.32442e-03, &
        & 0.30040e-03,0.26223e-03,0.21520e-03,0.21295e-03 /)
      kao(:, 4, 5,10) = (/ &
        & 0.45218e-03,0.40151e-03,0.38022e-03,0.36228e-03,0.34802e-03, &
        & 0.32336e-03,0.28327e-03,0.24766e-03,0.26132e-03 /)
      kao(:, 5, 5,10) = (/ &
        & 0.45207e-03,0.40582e-03,0.39175e-03,0.38293e-03,0.37072e-03, &
        & 0.34500e-03,0.31037e-03,0.29012e-03,0.31661e-03 /)
      kao(:, 1, 6,10) = (/ &
        & 0.43374e-03,0.38081e-03,0.34182e-03,0.31060e-03,0.28045e-03, &
        & 0.24697e-03,0.20889e-03,0.16055e-03,0.12036e-03 /)
      kao(:, 2, 6,10) = (/ &
        & 0.43531e-03,0.38407e-03,0.35000e-03,0.32358e-03,0.29721e-03, &
        & 0.26821e-03,0.23298e-03,0.18104e-03,0.14668e-03 /)
      kao(:, 3, 6,10) = (/ &
        & 0.43706e-03,0.38738e-03,0.35982e-03,0.33840e-03,0.31879e-03, &
        & 0.29390e-03,0.25605e-03,0.20200e-03,0.18191e-03 /)
      kao(:, 4, 6,10) = (/ &
        & 0.43807e-03,0.39050e-03,0.37037e-03,0.35740e-03,0.34372e-03, &
        & 0.31863e-03,0.27734e-03,0.23003e-03,0.22665e-03 /)
      kao(:, 5, 6,10) = (/ &
        & 0.43877e-03,0.39551e-03,0.38302e-03,0.38004e-03,0.36796e-03, &
        & 0.34140e-03,0.30328e-03,0.26832e-03,0.27676e-03 /)
      kao(:, 1, 7,10) = (/ &
        & 0.41256e-03,0.36341e-03,0.32806e-03,0.30023e-03,0.26855e-03, &
        & 0.23444e-03,0.19788e-03,0.15062e-03,0.10262e-03 /)
      kao(:, 2, 7,10) = (/ &
        & 0.41482e-03,0.36772e-03,0.33624e-03,0.31297e-03,0.28556e-03, &
        & 0.25627e-03,0.22127e-03,0.17072e-03,0.12601e-03 /)
      kao(:, 3, 7,10) = (/ &
        & 0.41718e-03,0.37142e-03,0.34661e-03,0.32744e-03,0.30719e-03, &
        & 0.28254e-03,0.24553e-03,0.19044e-03,0.15628e-03 /)
      kao(:, 4, 7,10) = (/ &
        & 0.41872e-03,0.37555e-03,0.35755e-03,0.34713e-03,0.33306e-03, &
        & 0.30832e-03,0.26791e-03,0.21481e-03,0.19464e-03 /)
      kao(:, 5, 7,10) = (/ &
        & 0.42048e-03,0.38195e-03,0.37042e-03,0.37076e-03,0.35893e-03, &
        & 0.33177e-03,0.29351e-03,0.24858e-03,0.23890e-03 /)
      kao(:, 1, 8,10) = (/ &
        & 0.38528e-03,0.34132e-03,0.30950e-03,0.28435e-03,0.25387e-03, &
        & 0.21998e-03,0.18381e-03,0.13995e-03,0.86291e-04 /)
      kao(:, 2, 8,10) = (/ &
        & 0.38813e-03,0.34604e-03,0.31840e-03,0.29716e-03,0.26994e-03, &
        & 0.24125e-03,0.20696e-03,0.15919e-03,0.10863e-03 /)
      kao(:, 3, 8,10) = (/ &
        & 0.39073e-03,0.35038e-03,0.33010e-03,0.31128e-03,0.29227e-03, &
        & 0.26641e-03,0.23195e-03,0.17813e-03,0.13616e-03 /)
      kao(:, 4, 8,10) = (/ &
        & 0.39281e-03,0.35556e-03,0.34140e-03,0.33132e-03,0.31814e-03, &
        & 0.29308e-03,0.25493e-03,0.20064e-03,0.16931e-03 /)
      kao(:, 5, 8,10) = (/ &
        & 0.39565e-03,0.36362e-03,0.35480e-03,0.35632e-03,0.34483e-03, &
        & 0.31779e-03,0.27994e-03,0.23183e-03,0.20721e-03 /)
      kao(:, 1, 9,10) = (/ &
        & 0.35353e-03,0.31534e-03,0.28844e-03,0.26382e-03,0.23534e-03, &
        & 0.20347e-03,0.16850e-03,0.12923e-03,0.71856e-04 /)
      kao(:, 2, 9,10) = (/ &
        & 0.35704e-03,0.32078e-03,0.29797e-03,0.27689e-03,0.25047e-03, &
        & 0.22397e-03,0.19066e-03,0.14773e-03,0.92561e-04 /)
      kao(:, 3, 9,10) = (/ &
        & 0.36000e-03,0.32561e-03,0.31012e-03,0.29082e-03,0.27253e-03, &
        & 0.24851e-03,0.21457e-03,0.16607e-03,0.11811e-03 /)
      kao(:, 4, 9,10) = (/ &
        & 0.36298e-03,0.33189e-03,0.32100e-03,0.31077e-03,0.29911e-03, &
        & 0.27480e-03,0.23785e-03,0.18730e-03,0.14849e-03 /)
      kao(:, 5, 9,10) = (/ &
        & 0.36645e-03,0.34041e-03,0.33535e-03,0.33583e-03,0.32646e-03, &
        & 0.29975e-03,0.26277e-03,0.21618e-03,0.18220e-03 /)
      kao(:, 1,10,10) = (/ &
        & 0.31882e-03,0.28657e-03,0.26462e-03,0.24132e-03,0.21534e-03, &
        & 0.18636e-03,0.15549e-03,0.11817e-03,0.60706e-04 /)
      kao(:, 2,10,10) = (/ &
        & 0.32301e-03,0.29267e-03,0.27519e-03,0.25478e-03,0.23046e-03, &
        & 0.20560e-03,0.17582e-03,0.13638e-03,0.79531e-04 /)
      kao(:, 3,10,10) = (/ &
        & 0.32639e-03,0.29816e-03,0.28709e-03,0.26927e-03,0.25170e-03, &
        & 0.23027e-03,0.19794e-03,0.15520e-03,0.10253e-03 /)
      kao(:, 4,10,10) = (/ &
        & 0.33008e-03,0.30559e-03,0.29823e-03,0.28948e-03,0.27786e-03, &
        & 0.25639e-03,0.22020e-03,0.17621e-03,0.13035e-03 /)
      kao(:, 5,10,10) = (/ &
        & 0.33429e-03,0.31481e-03,0.31383e-03,0.31396e-03,0.30544e-03, &
        & 0.28143e-03,0.24487e-03,0.20336e-03,0.16246e-03 /)
      kao(:, 1,11,10) = (/ &
        & 0.28433e-03,0.25922e-03,0.24227e-03,0.22327e-03,0.20067e-03, &
        & 0.17618e-03,0.15050e-03,0.11425e-03,0.57921e-04 /)
      kao(:, 2,11,10) = (/ &
        & 0.28828e-03,0.26532e-03,0.25425e-03,0.23723e-03,0.21797e-03, &
        & 0.19695e-03,0.17056e-03,0.13252e-03,0.76361e-04 /)
      kao(:, 3,11,10) = (/ &
        & 0.29236e-03,0.27228e-03,0.26588e-03,0.25415e-03,0.24099e-03, &
        & 0.22135e-03,0.19174e-03,0.15232e-03,0.98360e-04 /)
      kao(:, 4,11,10) = (/ &
        & 0.29717e-03,0.28209e-03,0.27970e-03,0.27650e-03,0.26714e-03, &
        & 0.24681e-03,0.21371e-03,0.17631e-03,0.12518e-03 /)
      kao(:, 5,11,10) = (/ &
        & 0.30177e-03,0.29180e-03,0.29905e-03,0.30274e-03,0.29362e-03, &
        & 0.27208e-03,0.24087e-03,0.20461e-03,0.15616e-03 /)
      kao(:, 1,12,10) = (/ &
        & 0.24998e-03,0.23220e-03,0.21962e-03,0.20418e-03,0.18598e-03, &
        & 0.16635e-03,0.14319e-03,0.11002e-03,0.54657e-04 /)
      kao(:, 2,12,10) = (/ &
        & 0.25422e-03,0.23880e-03,0.23171e-03,0.21907e-03,0.20484e-03, &
        & 0.18724e-03,0.16371e-03,0.12837e-03,0.72183e-04 /)
      kao(:, 3,12,10) = (/ &
        & 0.25909e-03,0.24827e-03,0.24443e-03,0.23867e-03,0.22868e-03, &
        & 0.21084e-03,0.18482e-03,0.14974e-03,0.93395e-04 /)
      kao(:, 4,12,10) = (/ &
        & 0.26399e-03,0.25851e-03,0.26208e-03,0.26298e-03,0.25438e-03, &
        & 0.23482e-03,0.20834e-03,0.17589e-03,0.11924e-03 /)
      kao(:, 5,12,10) = (/ &
        & 0.26914e-03,0.26866e-03,0.28401e-03,0.28945e-03,0.28022e-03, &
        & 0.26150e-03,0.23750e-03,0.20542e-03,0.14923e-03 /)
      kao(:, 1,13,10) = (/ &
        & 0.21751e-03,0.20608e-03,0.19731e-03,0.18540e-03,0.17208e-03, &
        & 0.15624e-03,0.13474e-03,0.10527e-03,0.50953e-04 /)
      kao(:, 2,13,10) = (/ &
        & 0.22228e-03,0.21439e-03,0.20968e-03,0.20158e-03,0.19151e-03, &
        & 0.17720e-03,0.15564e-03,0.12461e-03,0.67516e-04 /)
      kao(:, 3,13,10) = (/ &
        & 0.22727e-03,0.22462e-03,0.22474e-03,0.22318e-03,0.21469e-03, &
        & 0.19989e-03,0.17790e-03,0.14782e-03,0.88180e-04 /)
      kao(:, 4,13,10) = (/ &
        & 0.23242e-03,0.23488e-03,0.24462e-03,0.24805e-03,0.24003e-03, &
        & 0.22364e-03,0.20382e-03,0.17470e-03,0.11335e-03 /)
      kao(:, 5,13,10) = (/ &
        & 0.23819e-03,0.24692e-03,0.26797e-03,0.27413e-03,0.26611e-03, &
        & 0.25207e-03,0.23456e-03,0.20493e-03,0.14302e-03 /)
      kao(:, 1, 1,11) = (/ &
        & 0.54188e-03,0.47438e-03,0.41220e-03,0.36319e-03,0.32177e-03, &
        & 0.28178e-03,0.26195e-03,0.26768e-03,0.30988e-03 /)
      kao(:, 2, 1,11) = (/ &
        & 0.53863e-03,0.47157e-03,0.41235e-03,0.37142e-03,0.33314e-03, &
        & 0.30667e-03,0.29622e-03,0.31573e-03,0.36594e-03 /)
      kao(:, 3, 1,11) = (/ &
        & 0.53537e-03,0.46873e-03,0.41881e-03,0.37881e-03,0.35190e-03, &
        & 0.33275e-03,0.33720e-03,0.36928e-03,0.42810e-03 /)
      kao(:, 4, 1,11) = (/ &
        & 0.53255e-03,0.46630e-03,0.42443e-03,0.38945e-03,0.37640e-03, &
        & 0.36424e-03,0.38086e-03,0.42782e-03,0.49486e-03 /)
      kao(:, 5, 1,11) = (/ &
        & 0.53016e-03,0.46423e-03,0.43029e-03,0.40524e-03,0.39835e-03, &
        & 0.40134e-03,0.42785e-03,0.48998e-03,0.56469e-03 /)
      kao(:, 1, 2,11) = (/ &
        & 0.58031e-03,0.50799e-03,0.44209e-03,0.39038e-03,0.34592e-03, &
        & 0.30091e-03,0.27060e-03,0.26179e-03,0.30262e-03 /)
      kao(:, 2, 2,11) = (/ &
        & 0.57783e-03,0.50583e-03,0.44303e-03,0.40158e-03,0.35771e-03, &
        & 0.32458e-03,0.30412e-03,0.31051e-03,0.36041e-03 /)
      kao(:, 3, 2,11) = (/ &
        & 0.57540e-03,0.50373e-03,0.45070e-03,0.41078e-03,0.37604e-03, &
        & 0.34973e-03,0.34205e-03,0.36376e-03,0.42111e-03 /)
      kao(:, 4, 2,11) = (/ &
        & 0.57390e-03,0.50246e-03,0.45850e-03,0.42273e-03,0.40005e-03, &
        & 0.37925e-03,0.38380e-03,0.42075e-03,0.48570e-03 /)
      kao(:, 5, 2,11) = (/ &
        & 0.57251e-03,0.50128e-03,0.46686e-03,0.44000e-03,0.42177e-03, &
        & 0.41338e-03,0.42764e-03,0.47996e-03,0.55489e-03 /)
      kao(:, 1, 3,11) = (/ &
        & 0.61606e-03,0.53921e-03,0.46963e-03,0.41409e-03,0.36561e-03, &
        & 0.31888e-03,0.27397e-03,0.24837e-03,0.28056e-03 /)
      kao(:, 2, 3,11) = (/ &
        & 0.61406e-03,0.53752e-03,0.47091e-03,0.42713e-03,0.37975e-03, &
        & 0.33844e-03,0.30659e-03,0.29320e-03,0.33782e-03 /)
      kao(:, 3, 3,11) = (/ &
        & 0.61257e-03,0.53626e-03,0.47829e-03,0.43902e-03,0.39761e-03, &
        & 0.36364e-03,0.34206e-03,0.34371e-03,0.39648e-03 /)
      kao(:, 4, 3,11) = (/ &
        & 0.61154e-03,0.53538e-03,0.48822e-03,0.45223e-03,0.42130e-03, &
        & 0.39347e-03,0.37907e-03,0.39708e-03,0.45765e-03 /)
      kao(:, 5, 3,11) = (/ &
        & 0.61140e-03,0.53529e-03,0.49797e-03,0.47117e-03,0.44115e-03, &
        & 0.42497e-03,0.41979e-03,0.45564e-03,0.52659e-03 /)
      kao(:, 1, 4,11) = (/ &
        & 0.64443e-03,0.56411e-03,0.49232e-03,0.43467e-03,0.38190e-03, &
        & 0.33277e-03,0.27825e-03,0.23501e-03,0.25182e-03 /)
      kao(:, 2, 4,11) = (/ &
        & 0.64292e-03,0.56277e-03,0.49409e-03,0.44787e-03,0.39817e-03, &
        & 0.35161e-03,0.30747e-03,0.27717e-03,0.30629e-03 /)
      kao(:, 3, 4,11) = (/ &
        & 0.64243e-03,0.56236e-03,0.50119e-03,0.46200e-03,0.41580e-03, &
        & 0.37809e-03,0.34162e-03,0.32168e-03,0.36251e-03 /)
      kao(:, 4, 4,11) = (/ &
        & 0.64248e-03,0.56245e-03,0.51257e-03,0.47612e-03,0.44107e-03, &
        & 0.40610e-03,0.37659e-03,0.36992e-03,0.42339e-03 /)
      kao(:, 5, 4,11) = (/ &
        & 0.64345e-03,0.56414e-03,0.52333e-03,0.49621e-03,0.46345e-03, &
        & 0.43530e-03,0.41388e-03,0.42704e-03,0.49356e-03 /)
      kao(:, 1, 5,11) = (/ &
        & 0.66205e-03,0.57941e-03,0.50732e-03,0.44788e-03,0.39504e-03, &
        & 0.34261e-03,0.28274e-03,0.22440e-03,0.22048e-03 /)
      kao(:, 2, 5,11) = (/ &
        & 0.66163e-03,0.57912e-03,0.51033e-03,0.46104e-03,0.41289e-03, &
        & 0.36220e-03,0.30969e-03,0.26291e-03,0.27073e-03 /)
      kao(:, 3, 5,11) = (/ &
        & 0.66197e-03,0.57946e-03,0.51799e-03,0.47594e-03,0.43132e-03, &
        & 0.39012e-03,0.34192e-03,0.30335e-03,0.32369e-03 /)
      kao(:, 4, 5,11) = (/ &
        & 0.66310e-03,0.58124e-03,0.52962e-03,0.49191e-03,0.45677e-03, &
        & 0.42022e-03,0.37529e-03,0.34603e-03,0.38247e-03 /)
      kao(:, 5, 5,11) = (/ &
        & 0.66411e-03,0.58365e-03,0.54225e-03,0.51373e-03,0.48391e-03, &
        & 0.44802e-03,0.41016e-03,0.39855e-03,0.45388e-03 /)
      kao(:, 1, 6,11) = (/ &
        & 0.66761e-03,0.58431e-03,0.51405e-03,0.45280e-03,0.40155e-03, &
        & 0.34610e-03,0.28249e-03,0.21395e-03,0.18888e-03 /)
      kao(:, 2, 6,11) = (/ &
        & 0.66804e-03,0.58472e-03,0.51807e-03,0.46619e-03,0.41922e-03, &
        & 0.36797e-03,0.30908e-03,0.24851e-03,0.23408e-03 /)
      kao(:, 3, 6,11) = (/ &
        & 0.66946e-03,0.58664e-03,0.52673e-03,0.48103e-03,0.43940e-03, &
        & 0.39605e-03,0.34204e-03,0.28507e-03,0.28224e-03 /)
      kao(:, 4, 6,11) = (/ &
        & 0.67150e-03,0.59004e-03,0.53959e-03,0.49825e-03,0.46612e-03, &
        & 0.42814e-03,0.37432e-03,0.32325e-03,0.33817e-03 /)
      kao(:, 5, 6,11) = (/ &
        & 0.67315e-03,0.59352e-03,0.55351e-03,0.52125e-03,0.49748e-03, &
        & 0.45943e-03,0.40603e-03,0.37064e-03,0.40786e-03 /)
      kao(:, 1, 7,11) = (/ &
        & 0.65825e-03,0.57610e-03,0.50973e-03,0.44919e-03,0.40091e-03, &
        & 0.34393e-03,0.27863e-03,0.20584e-03,0.15896e-03 /)
      kao(:, 2, 7,11) = (/ &
        & 0.66067e-03,0.57854e-03,0.51604e-03,0.46345e-03,0.41921e-03, &
        & 0.36628e-03,0.30597e-03,0.23625e-03,0.19866e-03 /)
      kao(:, 3, 7,11) = (/ &
        & 0.66419e-03,0.58318e-03,0.52599e-03,0.48043e-03,0.43994e-03, &
        & 0.39562e-03,0.33865e-03,0.26970e-03,0.24286e-03 /)
      kao(:, 4, 7,11) = (/ &
        & 0.66717e-03,0.58792e-03,0.54016e-03,0.49893e-03,0.46857e-03, &
        & 0.43005e-03,0.37266e-03,0.30411e-03,0.29541e-03 /)
      kao(:, 5, 7,11) = (/ &
        & 0.67024e-03,0.59309e-03,0.55482e-03,0.52246e-03,0.50380e-03, &
        & 0.46446e-03,0.40297e-03,0.34641e-03,0.36121e-03 /)
      kao(:, 1, 8,11) = (/ &
        & 0.63858e-03,0.55888e-03,0.49736e-03,0.43942e-03,0.39082e-03, &
        & 0.33512e-03,0.27058e-03,0.19736e-03,0.13589e-03 /)
      kao(:, 2, 8,11) = (/ &
        & 0.64324e-03,0.56410e-03,0.50530e-03,0.45504e-03,0.41149e-03, &
        & 0.35701e-03,0.29879e-03,0.22618e-03,0.16884e-03 /)
      kao(:, 3, 8,11) = (/ &
        & 0.64790e-03,0.57033e-03,0.51640e-03,0.47474e-03,0.43226e-03, &
        & 0.38846e-03,0.33154e-03,0.25769e-03,0.20679e-03 /)
      kao(:, 4, 8,11) = (/ &
        & 0.65242e-03,0.57688e-03,0.53191e-03,0.49447e-03,0.46234e-03, &
        & 0.42468e-03,0.36669e-03,0.28907e-03,0.25449e-03 /)
      kao(:, 5, 8,11) = (/ &
        & 0.65716e-03,0.58346e-03,0.54799e-03,0.51859e-03,0.49982e-03, &
        & 0.46218e-03,0.39875e-03,0.32573e-03,0.31655e-03 /)
      kao(:, 1, 9,11) = (/ &
        & 0.61155e-03,0.53549e-03,0.47878e-03,0.42579e-03,0.37499e-03, &
        & 0.31961e-03,0.25793e-03,0.18655e-03,0.11490e-03 /)
      kao(:, 2, 9,11) = (/ &
        & 0.61794e-03,0.54314e-03,0.48878e-03,0.44250e-03,0.39687e-03, &
        & 0.34151e-03,0.28569e-03,0.21436e-03,0.14511e-03 /)
      kao(:, 3, 9,11) = (/ &
        & 0.62338e-03,0.55078e-03,0.50083e-03,0.46354e-03,0.41796e-03, &
        & 0.37306e-03,0.31954e-03,0.24508e-03,0.17854e-03 /)
      kao(:, 4, 9,11) = (/ &
        & 0.62936e-03,0.55894e-03,0.51722e-03,0.48335e-03,0.44775e-03, &
        & 0.41130e-03,0.35579e-03,0.27533e-03,0.21988e-03 /)
      kao(:, 5, 9,11) = (/ &
        & 0.63545e-03,0.56698e-03,0.53473e-03,0.50887e-03,0.48603e-03, &
        & 0.45259e-03,0.39001e-03,0.30792e-03,0.27464e-03 /)
      kao(:, 1,10,11) = (/ &
        & 0.57726e-03,0.50676e-03,0.45606e-03,0.40779e-03,0.35629e-03, &
        & 0.30220e-03,0.24273e-03,0.17731e-03,0.97262e-04 /)
      kao(:, 2,10,11) = (/ &
        & 0.58382e-03,0.51548e-03,0.46729e-03,0.42570e-03,0.37915e-03, &
        & 0.32497e-03,0.26965e-03,0.20381e-03,0.12529e-03 /)
      kao(:, 3,10,11) = (/ &
        & 0.59071e-03,0.52512e-03,0.48044e-03,0.44753e-03,0.40142e-03, &
        & 0.35504e-03,0.30526e-03,0.23284e-03,0.15783e-03 /)
      kao(:, 4,10,11) = (/ &
        & 0.59829e-03,0.53444e-03,0.49886e-03,0.46810e-03,0.43172e-03, &
        & 0.39380e-03,0.34313e-03,0.26284e-03,0.19647e-03 /)
      kao(:, 5,10,11) = (/ &
        & 0.60558e-03,0.54444e-03,0.51788e-03,0.49497e-03,0.47022e-03, &
        & 0.43733e-03,0.37954e-03,0.29404e-03,0.24439e-03 /)
      kao(:, 1,11,11) = (/ &
        & 0.53880e-03,0.47669e-03,0.43422e-03,0.39066e-03,0.34441e-03, &
        & 0.29300e-03,0.23722e-03,0.17846e-03,0.93053e-04 /)
      kao(:, 2,11,11) = (/ &
        & 0.54672e-03,0.48762e-03,0.44694e-03,0.41155e-03,0.36791e-03, &
        & 0.31854e-03,0.26663e-03,0.20551e-03,0.12100e-03 /)
      kao(:, 3,11,11) = (/ &
        & 0.55543e-03,0.49853e-03,0.46450e-03,0.43411e-03,0.39364e-03, &
        & 0.35233e-03,0.30378e-03,0.23442e-03,0.15474e-03 /)
      kao(:, 4,11,11) = (/ &
        & 0.56418e-03,0.50955e-03,0.48543e-03,0.45785e-03,0.42947e-03, &
        & 0.39274e-03,0.34329e-03,0.26304e-03,0.19545e-03 /)
      kao(:, 5,11,11) = (/ &
        & 0.57281e-03,0.52221e-03,0.50507e-03,0.49044e-03,0.47093e-03, &
        & 0.43647e-03,0.38057e-03,0.29685e-03,0.24345e-03 /)
      kao(:, 1,12,11) = (/ &
        & 0.49534e-03,0.44336e-03,0.40843e-03,0.37029e-03,0.32924e-03, &
        & 0.28268e-03,0.23204e-03,0.17692e-03,0.89557e-04 /)
      kao(:, 2,12,11) = (/ &
        & 0.50529e-03,0.45586e-03,0.42428e-03,0.39360e-03,0.35384e-03, &
        & 0.31099e-03,0.26296e-03,0.20575e-03,0.11779e-03 /)
      kao(:, 3,12,11) = (/ &
        & 0.51591e-03,0.46841e-03,0.44557e-03,0.41710e-03,0.38396e-03, &
        & 0.34779e-03,0.29981e-03,0.23475e-03,0.15231e-03 /)
      kao(:, 4,12,11) = (/ &
        & 0.52638e-03,0.48189e-03,0.46689e-03,0.44567e-03,0.42354e-03, &
        & 0.38951e-03,0.33959e-03,0.26406e-03,0.19354e-03 /)
      kao(:, 5,12,11) = (/ &
        & 0.53740e-03,0.49847e-03,0.48961e-03,0.48352e-03,0.46848e-03, &
        & 0.43322e-03,0.37807e-03,0.30031e-03,0.24179e-03 /)
      kao(:, 1,13,11) = (/ &
        & 0.44967e-03,0.40765e-03,0.37964e-03,0.34767e-03,0.31190e-03, &
        & 0.27110e-03,0.22687e-03,0.17331e-03,0.86456e-04 /)
      kao(:, 2,13,11) = (/ &
        & 0.46197e-03,0.42196e-03,0.40010e-03,0.37282e-03,0.33881e-03, &
        & 0.30170e-03,0.25812e-03,0.20314e-03,0.11471e-03 /)
      kao(:, 3,13,11) = (/ &
        & 0.47416e-03,0.43662e-03,0.42347e-03,0.39902e-03,0.37341e-03, &
        & 0.34073e-03,0.29426e-03,0.23321e-03,0.14921e-03 /)
      kao(:, 4,13,11) = (/ &
        & 0.48670e-03,0.45348e-03,0.44656e-03,0.43321e-03,0.41603e-03, &
        & 0.38366e-03,0.33328e-03,0.26489e-03,0.19032e-03 /)
      kao(:, 5,13,11) = (/ &
        & 0.49941e-03,0.47298e-03,0.47361e-03,0.47457e-03,0.46263e-03, &
        & 0.42791e-03,0.37404e-03,0.30319e-03,0.23864e-03 /)
      kao(:, 1, 1,12) = (/ &
        & 0.67194e-03,0.58821e-03,0.50483e-03,0.44022e-03,0.39428e-03, &
        & 0.35001e-03,0.32802e-03,0.34712e-03,0.40424e-03 /)
      kao(:, 2, 1,12) = (/ &
        & 0.66779e-03,0.58462e-03,0.50560e-03,0.45370e-03,0.41018e-03, &
        & 0.37788e-03,0.37804e-03,0.41641e-03,0.48433e-03 /)
      kao(:, 3, 1,12) = (/ &
        & 0.66375e-03,0.58112e-03,0.50831e-03,0.46547e-03,0.43045e-03, &
        & 0.42028e-03,0.43766e-03,0.49681e-03,0.57585e-03 /)
      kao(:, 4, 1,12) = (/ &
        & 0.65976e-03,0.57768e-03,0.51951e-03,0.47941e-03,0.45883e-03, &
        & 0.47280e-03,0.50926e-03,0.58385e-03,0.67578e-03 /)
      kao(:, 5, 1,12) = (/ &
        & 0.65493e-03,0.57349e-03,0.52976e-03,0.49649e-03,0.49872e-03, &
        & 0.52477e-03,0.58910e-03,0.67477e-03,0.78177e-03 /)
      kao(:, 1, 2,12) = (/ &
        & 0.74429e-03,0.65147e-03,0.55958e-03,0.48439e-03,0.43163e-03, &
        & 0.37450e-03,0.34047e-03,0.34702e-03,0.40780e-03 /)
      kao(:, 2, 2,12) = (/ &
        & 0.73897e-03,0.64685e-03,0.56004e-03,0.49710e-03,0.44831e-03, &
        & 0.39986e-03,0.38897e-03,0.41601e-03,0.48800e-03 /)
      kao(:, 3, 2,12) = (/ &
        & 0.73423e-03,0.64274e-03,0.56120e-03,0.51084e-03,0.46668e-03, &
        & 0.44211e-03,0.44391e-03,0.49187e-03,0.57573e-03 /)
      kao(:, 4, 2,12) = (/ &
        & 0.72906e-03,0.63825e-03,0.57090e-03,0.52414e-03,0.49429e-03, &
        & 0.48962e-03,0.50615e-03,0.57487e-03,0.67078e-03 /)
      kao(:, 5, 2,12) = (/ &
        & 0.72487e-03,0.63461e-03,0.58043e-03,0.54078e-03,0.53373e-03, &
        & 0.54010e-03,0.58187e-03,0.66737e-03,0.77655e-03 /)
      kao(:, 1, 3,12) = (/ &
        & 0.81958e-03,0.71735e-03,0.61664e-03,0.53266e-03,0.46619e-03, &
        & 0.39818e-03,0.35035e-03,0.33455e-03,0.39417e-03 /)
      kao(:, 2, 3,12) = (/ &
        & 0.81517e-03,0.71349e-03,0.61778e-03,0.54292e-03,0.48245e-03, &
        & 0.42187e-03,0.39187e-03,0.40203e-03,0.47500e-03 /)
      kao(:, 3, 3,12) = (/ &
        & 0.81131e-03,0.71014e-03,0.61887e-03,0.55563e-03,0.49928e-03, &
        & 0.45852e-03,0.44599e-03,0.47656e-03,0.56304e-03 /)
      kao(:, 4, 3,12) = (/ &
        & 0.80684e-03,0.70624e-03,0.62502e-03,0.56854e-03,0.52516e-03, &
        & 0.50282e-03,0.50405e-03,0.55674e-03,0.65701e-03 /)
      kao(:, 5, 3,12) = (/ &
        & 0.80277e-03,0.70271e-03,0.63387e-03,0.58439e-03,0.56394e-03, &
        & 0.54984e-03,0.57036e-03,0.64435e-03,0.75883e-03 /)
      kao(:, 1, 4,12) = (/ &
        & 0.88962e-03,0.77859e-03,0.66931e-03,0.57740e-03,0.50138e-03, &
        & 0.42396e-03,0.36076e-03,0.31901e-03,0.36723e-03 /)
      kao(:, 2, 4,12) = (/ &
        & 0.88665e-03,0.77601e-03,0.67190e-03,0.58651e-03,0.51766e-03, &
        & 0.44641e-03,0.39755e-03,0.38137e-03,0.44921e-03 /)
      kao(:, 3, 4,12) = (/ &
        & 0.88362e-03,0.77338e-03,0.67394e-03,0.60034e-03,0.53406e-03, &
        & 0.47716e-03,0.44855e-03,0.45695e-03,0.53953e-03 /)
      kao(:, 4, 4,12) = (/ &
        & 0.87936e-03,0.76967e-03,0.67789e-03,0.61530e-03,0.55605e-03, &
        & 0.52026e-03,0.50535e-03,0.53746e-03,0.63432e-03 /)
      kao(:, 5, 4,12) = (/ &
        & 0.87542e-03,0.76625e-03,0.68901e-03,0.63085e-03,0.59283e-03, &
        & 0.56499e-03,0.56855e-03,0.62330e-03,0.73477e-03 /)
      kao(:, 1, 5,12) = (/ &
        & 0.95206e-03,0.83319e-03,0.71670e-03,0.61887e-03,0.53098e-03, &
        & 0.45065e-03,0.37161e-03,0.30790e-03,0.33661e-03 /)
      kao(:, 2, 5,12) = (/ &
        & 0.95024e-03,0.83163e-03,0.72052e-03,0.62686e-03,0.54899e-03, &
        & 0.47363e-03,0.40570e-03,0.36303e-03,0.41611e-03 /)
      kao(:, 3, 5,12) = (/ &
        & 0.94830e-03,0.82995e-03,0.72350e-03,0.64294e-03,0.56882e-03, &
        & 0.49923e-03,0.45370e-03,0.43446e-03,0.50740e-03 /)
      kao(:, 4, 5,12) = (/ &
        & 0.94590e-03,0.82788e-03,0.72796e-03,0.66075e-03,0.59106e-03, &
        & 0.53960e-03,0.50922e-03,0.51449e-03,0.60347e-03 /)
      kao(:, 5, 5,12) = (/ &
        & 0.94431e-03,0.82652e-03,0.73985e-03,0.67685e-03,0.62406e-03, &
        & 0.58535e-03,0.56960e-03,0.60003e-03,0.70205e-03 /)
      kao(:, 1, 6,12) = (/ &
        & 0.10063e-02,0.88067e-03,0.75816e-03,0.65590e-03,0.55704e-03, &
        & 0.47312e-03,0.38218e-03,0.29812e-03,0.29923e-03 /)
      kao(:, 2, 6,12) = (/ &
        & 0.10075e-02,0.88171e-03,0.76490e-03,0.66447e-03,0.57639e-03, &
        & 0.49685e-03,0.41345e-03,0.34724e-03,0.37557e-03 /)
      kao(:, 3, 6,12) = (/ &
        & 0.10072e-02,0.88152e-03,0.76915e-03,0.68176e-03,0.59750e-03, &
        & 0.52339e-03,0.45689e-03,0.41130e-03,0.46505e-03 /)
      kao(:, 4, 6,12) = (/ &
        & 0.10060e-02,0.88049e-03,0.77394e-03,0.69974e-03,0.62189e-03, &
        & 0.55958e-03,0.51188e-03,0.48580e-03,0.55924e-03 /)
      kao(:, 5, 6,12) = (/ &
        & 0.10051e-02,0.87967e-03,0.78569e-03,0.71720e-03,0.65527e-03, &
        & 0.60501e-03,0.57082e-03,0.56756e-03,0.65737e-03 /)
      kao(:, 1, 7,12) = (/ &
        & 0.10487e-02,0.91773e-03,0.79062e-03,0.68516e-03,0.57878e-03, &
        & 0.49035e-03,0.39066e-03,0.28990e-03,0.26192e-03 /)
      kao(:, 2, 7,12) = (/ &
        & 0.10509e-02,0.91972e-03,0.79894e-03,0.69452e-03,0.59953e-03, &
        & 0.51487e-03,0.42128e-03,0.33451e-03,0.33284e-03 /)
      kao(:, 3, 7,12) = (/ &
        & 0.10507e-02,0.91957e-03,0.80398e-03,0.71157e-03,0.62221e-03, &
        & 0.54150e-03,0.46197e-03,0.39208e-03,0.41685e-03 /)
      kao(:, 4, 7,12) = (/ &
        & 0.10509e-02,0.91973e-03,0.80950e-03,0.73042e-03,0.64659e-03, &
        & 0.57916e-03,0.51360e-03,0.46065e-03,0.50813e-03 /)
      kao(:, 5, 7,12) = (/ &
        & 0.10509e-02,0.91978e-03,0.82196e-03,0.75027e-03,0.67740e-03, &
        & 0.62606e-03,0.57168e-03,0.53418e-03,0.60461e-03 /)
      kao(:, 1, 8,12) = (/ &
        & 0.10710e-02,0.93729e-03,0.80929e-03,0.70366e-03,0.59621e-03, &
        & 0.50074e-03,0.39602e-03,0.28309e-03,0.22630e-03 /)
      kao(:, 2, 8,12) = (/ &
        & 0.10749e-02,0.94069e-03,0.82032e-03,0.71447e-03,0.61694e-03, &
        & 0.52833e-03,0.42406e-03,0.32400e-03,0.29100e-03 /)
      kao(:, 3, 8,12) = (/ &
        & 0.10773e-02,0.94281e-03,0.82736e-03,0.73051e-03,0.64296e-03, &
        & 0.55298e-03,0.46605e-03,0.37591e-03,0.36869e-03 /)
      kao(:, 4, 8,12) = (/ &
        & 0.10796e-02,0.94487e-03,0.83459e-03,0.75111e-03,0.66786e-03, &
        & 0.59048e-03,0.51603e-03,0.43920e-03,0.45502e-03 /)
      kao(:, 5, 8,12) = (/ &
        & 0.10814e-02,0.94726e-03,0.84809e-03,0.77185e-03,0.69811e-03, &
        & 0.64090e-03,0.57338e-03,0.50692e-03,0.54643e-03 /)
      kao(:, 1, 9,12) = (/ &
        & 0.10730e-02,0.93903e-03,0.81373e-03,0.70878e-03,0.60523e-03, &
        & 0.50463e-03,0.39690e-03,0.27640e-03,0.19492e-03 /)
      kao(:, 2, 9,12) = (/ &
        & 0.10796e-02,0.94482e-03,0.82740e-03,0.72216e-03,0.62667e-03, &
        & 0.53533e-03,0.42406e-03,0.31368e-03,0.25100e-03 /)
      kao(:, 3, 9,12) = (/ &
        & 0.10853e-02,0.94982e-03,0.83742e-03,0.73904e-03,0.65592e-03, &
        & 0.56092e-03,0.46365e-03,0.36183e-03,0.32022e-03 /)
      kao(:, 4, 9,12) = (/ &
        & 0.10900e-02,0.95441e-03,0.84774e-03,0.76272e-03,0.68162e-03, &
        & 0.59735e-03,0.51414e-03,0.41927e-03,0.39972e-03 /)
      kao(:, 5, 9,12) = (/ &
        & 0.10952e-02,0.96081e-03,0.86364e-03,0.78596e-03,0.71341e-03, &
        & 0.64539e-03,0.57286e-03,0.48249e-03,0.48653e-03 /)
      kao(:, 1,10,12) = (/ &
        & 0.10558e-02,0.92391e-03,0.80426e-03,0.70294e-03,0.60555e-03, &
        & 0.50218e-03,0.39384e-03,0.27052e-03,0.17175e-03 /)
      kao(:, 2,10,12) = (/ &
        & 0.10672e-02,0.93391e-03,0.82187e-03,0.72055e-03,0.62861e-03, &
        & 0.53517e-03,0.42394e-03,0.30520e-03,0.22066e-03 /)
      kao(:, 3,10,12) = (/ &
        & 0.10767e-02,0.94234e-03,0.83636e-03,0.73971e-03,0.66074e-03, &
        & 0.56459e-03,0.46058e-03,0.35232e-03,0.28101e-03 /)
      kao(:, 4,10,12) = (/ &
        & 0.10858e-02,0.95208e-03,0.85075e-03,0.76653e-03,0.68963e-03, &
        & 0.60125e-03,0.51089e-03,0.40664e-03,0.35284e-03 /)
      kao(:, 5,10,12) = (/ &
        & 0.10953e-02,0.96285e-03,0.86971e-03,0.79369e-03,0.72347e-03, &
        & 0.65043e-03,0.57028e-03,0.46529e-03,0.43428e-03 /)
      kao(:, 1,11,12) = (/ &
        & 0.10314e-02,0.90258e-03,0.79467e-03,0.69943e-03,0.60546e-03, &
        & 0.50625e-03,0.39977e-03,0.27736e-03,0.16855e-03 /)
      kao(:, 2,11,12) = (/ &
        & 0.10451e-02,0.91471e-03,0.81404e-03,0.71994e-03,0.63569e-03, &
        & 0.54231e-03,0.43348e-03,0.31480e-03,0.21751e-03 /)
      kao(:, 3,11,12) = (/ &
        & 0.10591e-02,0.92888e-03,0.83171e-03,0.74582e-03,0.67129e-03, &
        & 0.57545e-03,0.47649e-03,0.36327e-03,0.27482e-03 /)
      kao(:, 4,11,12) = (/ &
        & 0.10732e-02,0.94400e-03,0.85133e-03,0.77904e-03,0.70324e-03, &
        & 0.62021e-03,0.53030e-03,0.41771e-03,0.34284e-03 /)
      kao(:, 5,11,12) = (/ &
        & 0.10880e-02,0.96010e-03,0.87843e-03,0.80902e-03,0.74479e-03, &
        & 0.67711e-03,0.59146e-03,0.47518e-03,0.42405e-03 /)
      kao(:, 1,12,12) = (/ &
        & 0.99800e-03,0.87344e-03,0.77838e-03,0.69077e-03,0.60021e-03, &
        & 0.50540e-03,0.40237e-03,0.28326e-03,0.16340e-03 /)
      kao(:, 2,12,12) = (/ &
        & 0.10163e-02,0.89149e-03,0.80050e-03,0.71513e-03,0.63616e-03, &
        & 0.54455e-03,0.44056e-03,0.32235e-03,0.21276e-03 /)
      kao(:, 3,12,12) = (/ &
        & 0.10345e-02,0.91067e-03,0.82237e-03,0.74899e-03,0.67503e-03, &
        & 0.58381e-03,0.48916e-03,0.37171e-03,0.26817e-03 /)
      kao(:, 4,12,12) = (/ &
        & 0.10541e-02,0.93146e-03,0.84943e-03,0.78581e-03,0.71327e-03, &
        & 0.63724e-03,0.54703e-03,0.42621e-03,0.33361e-03 /)
      kao(:, 5,12,12) = (/ &
        & 0.10724e-02,0.95127e-03,0.88178e-03,0.82065e-03,0.76248e-03, &
        & 0.70028e-03,0.60892e-03,0.48179e-03,0.41458e-03 /)
      kao(:, 1,13,12) = (/ &
        & 0.95912e-03,0.84178e-03,0.75778e-03,0.67765e-03,0.59123e-03, &
        & 0.50112e-03,0.40170e-03,0.28784e-03,0.15761e-03 /)
      kao(:, 2,13,12) = (/ &
        & 0.98187e-03,0.86541e-03,0.78344e-03,0.70851e-03,0.63200e-03, &
        & 0.54351e-03,0.44541e-03,0.32864e-03,0.20682e-03 /)
      kao(:, 3,13,12) = (/ &
        & 0.10063e-02,0.89078e-03,0.81111e-03,0.74766e-03,0.67473e-03, &
        & 0.58963e-03,0.49872e-03,0.37736e-03,0.26208e-03 /)
      kao(:, 4,13,12) = (/ &
        & 0.10299e-02,0.91565e-03,0.84455e-03,0.78769e-03,0.71894e-03, &
        & 0.65012e-03,0.55995e-03,0.43170e-03,0.32660e-03 /)
      kao(:, 5,13,12) = (/ &
        & 0.10525e-02,0.93912e-03,0.88061e-03,0.82863e-03,0.77810e-03, &
        & 0.71766e-03,0.62330e-03,0.48589e-03,0.40661e-03 /)
      kao(:, 1, 1,13) = (/ &
        & 0.84224e-03,0.73740e-03,0.63257e-03,0.54853e-03,0.48911e-03, &
        & 0.46139e-03,0.45309e-03,0.51018e-03,0.59300e-03 /)
      kao(:, 2, 1,13) = (/ &
        & 0.83841e-03,0.73411e-03,0.62983e-03,0.55802e-03,0.51855e-03, &
        & 0.50261e-03,0.52209e-03,0.59394e-03,0.69158e-03 /)
      kao(:, 3, 1,13) = (/ &
        & 0.83593e-03,0.73202e-03,0.62914e-03,0.58596e-03,0.54957e-03, &
        & 0.55151e-03,0.60969e-03,0.69097e-03,0.80707e-03 /)
      kao(:, 4, 1,13) = (/ &
        & 0.83246e-03,0.72902e-03,0.63274e-03,0.60961e-03,0.59022e-03, &
        & 0.61063e-03,0.70961e-03,0.80207e-03,0.93855e-03 /)
      kao(:, 5, 1,13) = (/ &
        & 0.82958e-03,0.72654e-03,0.65011e-03,0.63711e-03,0.63941e-03, &
        & 0.69313e-03,0.82070e-03,0.92941e-03,0.10860e-02 /)
      kao(:, 1, 2,13) = (/ &
        & 0.94737e-03,0.82928e-03,0.71121e-03,0.61292e-03,0.53888e-03, &
        & 0.49608e-03,0.46449e-03,0.50895e-03,0.59638e-03 /)
      kao(:, 2, 2,13) = (/ &
        & 0.94309e-03,0.82559e-03,0.70809e-03,0.61981e-03,0.56880e-03, &
        & 0.53738e-03,0.52906e-03,0.59714e-03,0.70098e-03 /)
      kao(:, 3, 2,13) = (/ &
        & 0.93813e-03,0.82131e-03,0.70667e-03,0.64442e-03,0.60095e-03, &
        & 0.58581e-03,0.62140e-03,0.70455e-03,0.83109e-03 /)
      kao(:, 4, 2,13) = (/ &
        & 0.93357e-03,0.81735e-03,0.70879e-03,0.66885e-03,0.63704e-03, &
        & 0.64975e-03,0.73250e-03,0.82836e-03,0.97995e-03 /)
      kao(:, 5, 2,13) = (/ &
        & 0.92926e-03,0.81362e-03,0.72487e-03,0.69759e-03,0.68443e-03, &
        & 0.72989e-03,0.85114e-03,0.96045e-03,0.11390e-02 /)
      kao(:, 1, 3,13) = (/ &
        & 0.10589e-02,0.92685e-03,0.79478e-03,0.68185e-03,0.58961e-03, &
        & 0.52592e-03,0.47382e-03,0.49304e-03,0.58474e-03 /)
      kao(:, 2, 3,13) = (/ &
        & 0.10532e-02,0.92189e-03,0.79057e-03,0.68536e-03,0.61794e-03, &
        & 0.56535e-03,0.53040e-03,0.57934e-03,0.68761e-03 /)
      kao(:, 3, 3,13) = (/ &
        & 0.10466e-02,0.91613e-03,0.78805e-03,0.70517e-03,0.65240e-03, &
        & 0.61071e-03,0.61067e-03,0.68776e-03,0.81827e-03 /)
      kao(:, 4, 3,13) = (/ &
        & 0.10406e-02,0.91088e-03,0.78949e-03,0.73011e-03,0.68643e-03, &
        & 0.67486e-03,0.72316e-03,0.82048e-03,0.97591e-03 /)
      kao(:, 5, 3,13) = (/ &
        & 0.10350e-02,0.90609e-03,0.80184e-03,0.75651e-03,0.73102e-03, &
        & 0.75672e-03,0.85035e-03,0.96398e-03,0.11483e-02 /)
      kao(:, 1, 4,13) = (/ &
        & 0.11788e-02,0.10317e-02,0.88462e-03,0.75562e-03,0.64370e-03, &
        & 0.55868e-03,0.48899e-03,0.48008e-03,0.57112e-03 /)
      kao(:, 2, 4,13) = (/ &
        & 0.11725e-02,0.10263e-02,0.87998e-03,0.75781e-03,0.66989e-03, &
        & 0.59814e-03,0.54177e-03,0.56164e-03,0.66999e-03 /)
      kao(:, 3, 4,13) = (/ &
        & 0.11654e-02,0.10201e-02,0.87720e-03,0.76990e-03,0.70381e-03, &
        & 0.63928e-03,0.60787e-03,0.66447e-03,0.79300e-03 /)
      kao(:, 4, 4,13) = (/ &
        & 0.11592e-02,0.10147e-02,0.87854e-03,0.79340e-03,0.73787e-03, &
        & 0.69602e-03,0.70539e-03,0.79266e-03,0.94522e-03 /)
      kao(:, 5, 4,13) = (/ &
        & 0.11532e-02,0.10094e-02,0.88452e-03,0.81797e-03,0.78065e-03, &
        & 0.77762e-03,0.82734e-03,0.94053e-03,0.11199e-02 /)
      kao(:, 1, 5,13) = (/ &
        & 0.13090e-02,0.11455e-02,0.98213e-03,0.83571e-03,0.70447e-03, &
        & 0.59736e-03,0.51100e-03,0.46541e-03,0.54756e-03 /)
      kao(:, 2, 5,13) = (/ &
        & 0.13011e-02,0.11387e-02,0.97633e-03,0.83818e-03,0.72563e-03, &
        & 0.63146e-03,0.56040e-03,0.54671e-03,0.65045e-03 /)
      kao(:, 3, 5,13) = (/ &
        & 0.12919e-02,0.11307e-02,0.97249e-03,0.84355e-03,0.75615e-03, &
        & 0.67456e-03,0.62106e-03,0.64503e-03,0.77294e-03 /)
      kao(:, 4, 5,13) = (/ &
        & 0.12834e-02,0.11233e-02,0.97228e-03,0.86290e-03,0.79001e-03, &
        & 0.72644e-03,0.70406e-03,0.76742e-03,0.92034e-03 /)
      kao(:, 5, 5,13) = (/ &
        & 0.12754e-02,0.11163e-02,0.97447e-03,0.88787e-03,0.82956e-03, &
        & 0.80041e-03,0.81433e-03,0.91302e-03,0.10923e-02 /)
      kao(:, 1, 6,13) = (/ &
        & 0.14384e-02,0.12588e-02,0.10791e-02,0.91745e-03,0.77222e-03, &
        & 0.63777e-03,0.53552e-03,0.44917e-03,0.50804e-03 /)
      kao(:, 2, 6,13) = (/ &
        & 0.14296e-02,0.12511e-02,0.10726e-02,0.92106e-03,0.78721e-03, &
        & 0.67056e-03,0.58135e-03,0.52600e-03,0.61657e-03 /)
      kao(:, 3, 6,13) = (/ &
        & 0.14197e-02,0.12425e-02,0.10687e-02,0.92311e-03,0.81466e-03, &
        & 0.70925e-03,0.63651e-03,0.62263e-03,0.74116e-03 /)
      kao(:, 4, 6,13) = (/ &
        & 0.14113e-02,0.12351e-02,0.10686e-02,0.93888e-03,0.84557e-03, &
        & 0.75721e-03,0.71295e-03,0.74435e-03,0.88914e-03 /)
      kao(:, 5, 6,13) = (/ &
        & 0.14033e-02,0.12282e-02,0.10694e-02,0.96147e-03,0.87768e-03, &
        & 0.82519e-03,0.81219e-03,0.88552e-03,0.10599e-02 /)
      kao(:, 1, 7,13) = (/ &
        & 0.15646e-02,0.13692e-02,0.11737e-02,0.99670e-03,0.83910e-03, &
        & 0.68337e-03,0.56133e-03,0.43784e-03,0.46053e-03 /)
      kao(:, 2, 7,13) = (/ &
        & 0.15575e-02,0.13630e-02,0.11685e-02,0.10035e-02,0.85062e-03, &
        & 0.71436e-03,0.60284e-03,0.50378e-03,0.56665e-03 /)
      kao(:, 3, 7,13) = (/ &
        & 0.15495e-02,0.13560e-02,0.11666e-02,0.10059e-02,0.87670e-03, &
        & 0.74963e-03,0.65339e-03,0.59583e-03,0.69467e-03 /)
      kao(:, 4, 7,13) = (/ &
        & 0.15420e-02,0.13494e-02,0.11678e-02,0.10189e-02,0.90417e-03, &
        & 0.79237e-03,0.72265e-03,0.71412e-03,0.84581e-03 /)
      kao(:, 5, 7,13) = (/ &
        & 0.15345e-02,0.13429e-02,0.11695e-02,0.10414e-02,0.93588e-03, &
        & 0.84978e-03,0.81799e-03,0.85682e-03,0.10184e-02 /)
      kao(:, 1, 8,13) = (/ &
        & 0.16856e-02,0.14750e-02,0.12645e-02,0.10725e-02,0.90201e-03, &
        & 0.73159e-03,0.58478e-03,0.43268e-03,0.41101e-03 /)
      kao(:, 2, 8,13) = (/ &
        & 0.16806e-02,0.14706e-02,0.12609e-02,0.10836e-02,0.91363e-03, &
        & 0.76033e-03,0.62810e-03,0.48786e-03,0.51346e-03 /)
      kao(:, 3, 8,13) = (/ &
        & 0.16744e-02,0.14652e-02,0.12612e-02,0.10887e-02,0.93599e-03, &
        & 0.79815e-03,0.66916e-03,0.56926e-03,0.63978e-03 /)
      kao(:, 4, 8,13) = (/ &
        & 0.16684e-02,0.14601e-02,0.12641e-02,0.11000e-02,0.96490e-03, &
        & 0.83543e-03,0.73243e-03,0.67845e-03,0.78892e-03 /)
      kao(:, 5, 8,13) = (/ &
        & 0.16618e-02,0.14543e-02,0.12671e-02,0.11238e-02,0.99451e-03, &
        & 0.88426e-03,0.81935e-03,0.81741e-03,0.96330e-03 /)
      kao(:, 1, 9,13) = (/ &
        & 0.17934e-02,0.15694e-02,0.13453e-02,0.11410e-02,0.95885e-03, &
        & 0.77818e-03,0.60653e-03,0.43079e-03,0.36156e-03 /)
      kao(:, 2, 9,13) = (/ &
        & 0.17902e-02,0.15666e-02,0.13435e-02,0.11557e-02,0.97291e-03, &
        & 0.80328e-03,0.65101e-03,0.47930e-03,0.45791e-03 /)
      kao(:, 3, 9,13) = (/ &
        & 0.17870e-02,0.15637e-02,0.13465e-02,0.11644e-02,0.99290e-03, &
        & 0.84365e-03,0.69043e-03,0.54887e-03,0.58027e-03 /)
      kao(:, 4, 9,13) = (/ &
        & 0.17836e-02,0.15608e-02,0.13520e-02,0.11761e-02,0.10245e-02, &
        & 0.87956e-03,0.74487e-03,0.64626e-03,0.72649e-03 /)
      kao(:, 5, 9,13) = (/ &
        & 0.17784e-02,0.15563e-02,0.13567e-02,0.11994e-02,0.10543e-02, &
        & 0.92517e-03,0.82194e-03,0.77306e-03,0.89652e-03 /)
      kao(:, 1,10,13) = (/ &
        & 0.18870e-02,0.16513e-02,0.14155e-02,0.12026e-02,0.10094e-02, &
        & 0.82157e-03,0.62812e-03,0.43279e-03,0.32100e-03 /)
      kao(:, 2,10,13) = (/ &
        & 0.18874e-02,0.16516e-02,0.14168e-02,0.12199e-02,0.10267e-02, &
        & 0.84527e-03,0.67192e-03,0.47951e-03,0.41207e-03 /)
      kao(:, 3,10,13) = (/ &
        & 0.18869e-02,0.16512e-02,0.14226e-02,0.12326e-02,0.10456e-02, &
        & 0.88603e-03,0.71450e-03,0.53998e-03,0.52708e-03 /)
      kao(:, 4,10,13) = (/ &
        & 0.18844e-02,0.16490e-02,0.14297e-02,0.12452e-02,0.10784e-02, &
        & 0.92565e-03,0.76291e-03,0.62910e-03,0.66842e-03 /)
      kao(:, 5,10,13) = (/ &
        & 0.18812e-02,0.16463e-02,0.14369e-02,0.12677e-02,0.11133e-02, &
        & 0.96733e-03,0.83676e-03,0.74378e-03,0.83514e-03 /)
      kao(:, 1,11,13) = (/ &
        & 0.19652e-02,0.17197e-02,0.14741e-02,0.12638e-02,0.10628e-02, &
        & 0.86832e-03,0.66314e-03,0.45418e-03,0.32052e-03 /)
      kao(:, 2,11,13) = (/ &
        & 0.19706e-02,0.17244e-02,0.14828e-02,0.12836e-02,0.10826e-02, &
        & 0.89693e-03,0.71120e-03,0.50274e-03,0.41269e-03 /)
      kao(:, 3,11,13) = (/ &
        & 0.19727e-02,0.17263e-02,0.14935e-02,0.12979e-02,0.11060e-02, &
        & 0.94341e-03,0.75411e-03,0.56772e-03,0.53374e-03 /)
      kao(:, 4,11,13) = (/ &
        & 0.19726e-02,0.17262e-02,0.15047e-02,0.13132e-02,0.11439e-02, &
        & 0.98450e-03,0.80814e-03,0.66163e-03,0.68012e-03 /)
      kao(:, 5,11,13) = (/ &
        & 0.19717e-02,0.17254e-02,0.15111e-02,0.13415e-02,0.11812e-02, &
        & 0.10302e-02,0.88976e-03,0.77856e-03,0.85217e-03 /)
      kao(:, 1,12,13) = (/ &
        & 0.20238e-02,0.17709e-02,0.15209e-02,0.13140e-02,0.11103e-02, &
        & 0.90805e-03,0.69487e-03,0.47365e-03,0.32170e-03 /)
      kao(:, 2,12,13) = (/ &
        & 0.20339e-02,0.17798e-02,0.15376e-02,0.13369e-02,0.11339e-02, &
        & 0.94414e-03,0.74487e-03,0.52470e-03,0.41340e-03 /)
      kao(:, 3,12,13) = (/ &
        & 0.20400e-02,0.17851e-02,0.15537e-02,0.13538e-02,0.11634e-02, &
        & 0.99316e-03,0.79139e-03,0.59483e-03,0.53800e-03 /)
      kao(:, 4,12,13) = (/ &
        & 0.20440e-02,0.17887e-02,0.15672e-02,0.13751e-02,0.12054e-02, &
        & 0.10358e-02,0.85239e-03,0.69118e-03,0.69062e-03 /)
      kao(:, 5,12,13) = (/ &
        & 0.20478e-02,0.17920e-02,0.15770e-02,0.14084e-02,0.12434e-02, &
        & 0.10883e-02,0.94102e-03,0.81111e-03,0.86624e-03 /)
      kao(:, 1,13,13) = (/ &
        & 0.20618e-02,0.18042e-02,0.15564e-02,0.13520e-02,0.11495e-02, &
        & 0.94146e-03,0.72197e-03,0.49143e-03,0.32080e-03 /)
      kao(:, 2,13,13) = (/ &
        & 0.20769e-02,0.18174e-02,0.15793e-02,0.13781e-02,0.11781e-02, &
        & 0.98504e-03,0.77410e-03,0.54584e-03,0.41409e-03 /)
      kao(:, 3,13,13) = (/ &
        & 0.20884e-02,0.18274e-02,0.16007e-02,0.14008e-02,0.12152e-02, &
        & 0.10359e-02,0.82528e-03,0.62085e-03,0.53970e-03 /)
      kao(:, 4,13,13) = (/ &
        & 0.21000e-02,0.18376e-02,0.16180e-02,0.14292e-02,0.12615e-02, &
        & 0.10817e-02,0.89457e-03,0.71909e-03,0.69474e-03 /)
      kao(:, 5,13,13) = (/ &
        & 0.21077e-02,0.18456e-02,0.16335e-02,0.14673e-02,0.12995e-02, &
        & 0.11413e-02,0.98821e-03,0.84127e-03,0.87402e-03 /)
      kao(:, 1, 1,14) = (/ &
        & 0.11199e-02,0.98039e-03,0.84084e-03,0.70943e-03,0.63603e-03, &
        & 0.60649e-03,0.68312e-03,0.76350e-03,0.90110e-03 /)
      kao(:, 2, 1,14) = (/ &
        & 0.11157e-02,0.97670e-03,0.83773e-03,0.72395e-03,0.68641e-03, &
        & 0.69858e-03,0.81907e-03,0.92056e-03,0.10823e-02 /)
      kao(:, 3, 1,14) = (/ &
        & 0.11108e-02,0.97243e-03,0.83426e-03,0.74791e-03,0.75340e-03, &
        & 0.82026e-03,0.97233e-03,0.10968e-02,0.12857e-02 /)
      kao(:, 4, 1,14) = (/ &
        & 0.11077e-02,0.96981e-03,0.83196e-03,0.80006e-03,0.82593e-03, &
        & 0.96481e-03,0.11451e-02,0.12942e-02,0.15153e-02 /)
      kao(:, 5, 1,14) = (/ &
        & 0.11057e-02,0.96811e-03,0.83287e-03,0.85771e-03,0.92243e-03, &
        & 0.11291e-02,0.13401e-02,0.15139e-02,0.17730e-02 /)
      kao(:, 1, 2,14) = (/ &
        & 0.12618e-02,0.11045e-02,0.94731e-03,0.80059e-03,0.70460e-03, &
        & 0.66164e-03,0.71798e-03,0.80280e-03,0.96182e-03 /)
      kao(:, 2, 2,14) = (/ &
        & 0.12573e-02,0.11007e-02,0.94415e-03,0.81463e-03,0.74844e-03, &
        & 0.74157e-03,0.85097e-03,0.95625e-03,0.11395e-02 /)
      kao(:, 3, 2,14) = (/ &
        & 0.12537e-02,0.10976e-02,0.94166e-03,0.83421e-03,0.81760e-03, &
        & 0.85124e-03,0.10029e-02,0.11319e-02,0.13421e-02 /)
      kao(:, 4, 2,14) = (/ &
        & 0.12517e-02,0.10959e-02,0.94019e-03,0.88029e-03,0.88890e-03, &
        & 0.98937e-03,0.11747e-02,0.13301e-02,0.15715e-02 /)
      kao(:, 5, 2,14) = (/ &
        & 0.12484e-02,0.10932e-02,0.93873e-03,0.93946e-03,0.97784e-03, &
        & 0.11555e-02,0.13735e-02,0.15606e-02,0.18367e-02 /)
      kao(:, 1, 3,14) = (/ &
        & 0.14334e-02,0.12547e-02,0.10760e-02,0.90369e-03,0.78163e-03, &
        & 0.71064e-03,0.72074e-03,0.81006e-03,0.97636e-03 /)
      kao(:, 2, 3,14) = (/ &
        & 0.14266e-02,0.12488e-02,0.10711e-02,0.91657e-03,0.81392e-03, &
        & 0.78379e-03,0.85758e-03,0.96540e-03,0.11622e-02 /)
      kao(:, 3, 3,14) = (/ &
        & 0.14223e-02,0.12452e-02,0.10680e-02,0.93146e-03,0.87510e-03, &
        & 0.87756e-03,0.10059e-02,0.11359e-02,0.13619e-02 /)
      kao(:, 4, 3,14) = (/ &
        & 0.14175e-02,0.12411e-02,0.10646e-02,0.96483e-03,0.94572e-03, &
        & 0.99384e-03,0.11710e-02,0.13256e-02,0.15838e-02 /)
      kao(:, 5, 3,14) = (/ &
        & 0.14120e-02,0.12363e-02,0.10614e-02,0.10223e-02,0.10225e-02, &
        & 0.11461e-02,0.13616e-02,0.15455e-02,0.18394e-02 /)
      kao(:, 1, 4,14) = (/ &
        & 0.16334e-02,0.14296e-02,0.12259e-02,0.10262e-02,0.87529e-03, &
        & 0.76396e-03,0.72119e-03,0.79306e-03,0.95651e-03 /)
      kao(:, 2, 4,14) = (/ &
        & 0.16232e-02,0.14208e-02,0.12185e-02,0.10348e-02,0.89367e-03, &
        & 0.83199e-03,0.84657e-03,0.95561e-03,0.11474e-02 /)
      kao(:, 3, 4,14) = (/ &
        & 0.16152e-02,0.14140e-02,0.12127e-02,0.10485e-02,0.94236e-03, &
        & 0.91572e-03,0.99902e-03,0.11299e-02,0.13583e-02 /)
      kao(:, 4, 4,14) = (/ &
        & 0.16069e-02,0.14067e-02,0.12065e-02,0.10685e-02,0.10126e-02, &
        & 0.10172e-02,0.11639e-02,0.13179e-02,0.15822e-02 /)
      kao(:, 5, 4,14) = (/ &
        & 0.15986e-02,0.13996e-02,0.12009e-02,0.11161e-02,0.10822e-02, &
        & 0.11448e-02,0.13482e-02,0.15289e-02,0.18307e-02 /)
      kao(:, 1, 5,14) = (/ &
        & 0.18523e-02,0.16211e-02,0.13900e-02,0.11617e-02,0.98609e-03, &
        & 0.83071e-03,0.73506e-03,0.77421e-03,0.93359e-03 /)
      kao(:, 2, 5,14) = (/ &
        & 0.18399e-02,0.16104e-02,0.13808e-02,0.11680e-02,0.99824e-03, &
        & 0.89112e-03,0.84383e-03,0.93250e-03,0.11210e-02 /)
      kao(:, 3, 5,14) = (/ &
        & 0.18296e-02,0.16015e-02,0.13734e-02,0.11806e-02,0.10315e-02, &
        & 0.96812e-03,0.98130e-03,0.11095e-02,0.13275e-02 /)
      kao(:, 4, 5,14) = (/ &
        & 0.18179e-02,0.15913e-02,0.13647e-02,0.11924e-02,0.10905e-02, &
        & 0.10578e-02,0.11513e-02,0.13088e-02,0.15638e-02 /)
      kao(:, 5, 5,14) = (/ &
        & 0.18067e-02,0.15816e-02,0.13575e-02,0.12252e-02,0.11627e-02, &
        & 0.11690e-02,0.13357e-02,0.15168e-02,0.18162e-02 /)
      kao(:, 1, 6,14) = (/ &
        & 0.20925e-02,0.18312e-02,0.15700e-02,0.13095e-02,0.11041e-02, &
        & 0.91669e-03,0.76437e-03,0.75155e-03,0.90862e-03 /)
      kao(:, 2, 6,14) = (/ &
        & 0.20749e-02,0.18159e-02,0.15569e-02,0.13117e-02,0.11170e-02, &
        & 0.95740e-03,0.85349e-03,0.90211e-03,0.10843e-02 /)
      kao(:, 3, 6,14) = (/ &
        & 0.20605e-02,0.18034e-02,0.15463e-02,0.13221e-02,0.11384e-02, &
        & 0.10293e-02,0.97333e-03,0.10765e-02,0.12853e-02 /)
      kao(:, 4, 6,14) = (/ &
        & 0.20459e-02,0.17907e-02,0.15355e-02,0.13321e-02,0.11878e-02, &
        & 0.11138e-02,0.11236e-02,0.12716e-02,0.15170e-02 /)
      kao(:, 5, 6,14) = (/ &
        & 0.20310e-02,0.17778e-02,0.15259e-02,0.13542e-02,0.12517e-02, &
        & 0.12095e-02,0.13081e-02,0.14898e-02,0.17755e-02 /)
      kao(:, 1, 7,14) = (/ &
        & 0.23595e-02,0.20648e-02,0.17701e-02,0.14754e-02,0.12323e-02, &
        & 0.10132e-02,0.80835e-03,0.73377e-03,0.88458e-03 /)
      kao(:, 2, 7,14) = (/ &
        & 0.23333e-02,0.20420e-02,0.17506e-02,0.14700e-02,0.12449e-02, &
        & 0.10427e-02,0.88482e-03,0.87865e-03,0.10548e-02 /)
      kao(:, 3, 7,14) = (/ &
        & 0.23118e-02,0.20232e-02,0.17345e-02,0.14754e-02,0.12581e-02, &
        & 0.11040e-02,0.98425e-03,0.10425e-02,0.12451e-02 /)
      kao(:, 4, 7,14) = (/ &
        & 0.22911e-02,0.20052e-02,0.17193e-02,0.14831e-02,0.12996e-02, &
        & 0.11778e-02,0.11137e-02,0.12310e-02,0.14656e-02 /)
      kao(:, 5, 7,14) = (/ &
        & 0.22715e-02,0.19881e-02,0.17061e-02,0.14949e-02,0.13595e-02, &
        & 0.12702e-02,0.12792e-02,0.14480e-02,0.17220e-02 /)
      kao(:, 1, 8,14) = (/ &
        & 0.26465e-02,0.23159e-02,0.19853e-02,0.16547e-02,0.13704e-02, &
        & 0.11161e-02,0.87227e-03,0.72579e-03,0.85316e-03 /)
      kao(:, 2, 8,14) = (/ &
        & 0.26139e-02,0.22874e-02,0.19609e-02,0.16420e-02,0.13837e-02, &
        & 0.11377e-02,0.93183e-03,0.85926e-03,0.10245e-02 /)
      kao(:, 3, 8,14) = (/ &
        & 0.25857e-02,0.22628e-02,0.19400e-02,0.16425e-02,0.13917e-02, &
        & 0.11859e-02,0.10228e-02,0.10157e-02,0.12103e-02 /)
      kao(:, 4, 8,14) = (/ &
        & 0.25573e-02,0.22380e-02,0.19187e-02,0.16463e-02,0.14196e-02, &
        & 0.12582e-02,0.11286e-02,0.11958e-02,0.14229e-02 /)
      kao(:, 5, 8,14) = (/ &
        & 0.25310e-02,0.22151e-02,0.19006e-02,0.16478e-02,0.14771e-02, &
        & 0.13382e-02,0.12711e-02,0.14043e-02,0.16688e-02 /)
      kao(:, 1, 9,14) = (/ &
        & 0.29437e-02,0.25759e-02,0.22081e-02,0.18403e-02,0.15126e-02, &
        & 0.12266e-02,0.94502e-03,0.72553e-03,0.80872e-03 /)
      kao(:, 2, 9,14) = (/ &
        & 0.29059e-02,0.25428e-02,0.21798e-02,0.18221e-02,0.15299e-02, &
        & 0.12446e-02,0.99114e-03,0.84495e-03,0.98123e-03 /)
      kao(:, 3, 9,14) = (/ &
        & 0.28735e-02,0.25146e-02,0.21557e-02,0.18193e-02,0.15373e-02, &
        & 0.12770e-02,0.10730e-02,0.99151e-03,0.11701e-02 /)
      kao(:, 4, 9,14) = (/ &
        & 0.28399e-02,0.24853e-02,0.21306e-02,0.18209e-02,0.15526e-02, &
        & 0.13434e-02,0.11682e-02,0.11617e-02,0.13773e-02 /)
      kao(:, 5, 9,14) = (/ &
        & 0.28070e-02,0.24565e-02,0.21073e-02,0.18175e-02,0.15973e-02, &
        & 0.14179e-02,0.12830e-02,0.13638e-02,0.16173e-02 /)
      kao(:, 1,10,14) = (/ &
        & 0.32399e-02,0.28350e-02,0.24302e-02,0.20252e-02,0.16589e-02, &
        & 0.13407e-02,0.10274e-02,0.73986e-03,0.76203e-03 /)
      kao(:, 2,10,14) = (/ &
        & 0.31965e-02,0.27971e-02,0.23977e-02,0.20029e-02,0.16776e-02, &
        & 0.13600e-02,0.10652e-02,0.84551e-03,0.93841e-03 /)
      kao(:, 3,10,14) = (/ &
        & 0.31601e-02,0.27653e-02,0.23707e-02,0.19975e-02,0.16883e-02, &
        & 0.13843e-02,0.11385e-02,0.98230e-03,0.11352e-02 /)
      kao(:, 4,10,14) = (/ &
        & 0.31230e-02,0.27329e-02,0.23428e-02,0.19986e-02,0.16986e-02, &
        & 0.14381e-02,0.12318e-02,0.11431e-02,0.13466e-02 /)
      kao(:, 5,10,14) = (/ &
        & 0.30838e-02,0.26986e-02,0.23157e-02,0.19957e-02,0.17285e-02, &
        & 0.15111e-02,0.13270e-02,0.13396e-02,0.15853e-02 /)
      kao(:, 1,11,14) = (/ &
        & 0.35110e-02,0.30722e-02,0.26335e-02,0.21948e-02,0.18129e-02, &
        & 0.14641e-02,0.11256e-02,0.79561e-03,0.78300e-03 /)
      kao(:, 2,11,14) = (/ &
        & 0.34682e-02,0.30349e-02,0.26015e-02,0.21788e-02,0.18300e-02, &
        & 0.14846e-02,0.11655e-02,0.90541e-03,0.97352e-03 /)
      kao(:, 3,11,14) = (/ &
        & 0.34263e-02,0.29982e-02,0.25700e-02,0.21750e-02,0.18411e-02, &
        & 0.15104e-02,0.12444e-02,0.10462e-02,0.11863e-02 /)
      kao(:, 4,11,14) = (/ &
        & 0.33817e-02,0.29592e-02,0.25369e-02,0.21760e-02,0.18525e-02, &
        & 0.15666e-02,0.13382e-02,0.12088e-02,0.14124e-02 /)
      kao(:, 5,11,14) = (/ &
        & 0.33351e-02,0.29184e-02,0.25088e-02,0.21673e-02,0.18858e-02, &
        & 0.16404e-02,0.14339e-02,0.14160e-02,0.16713e-02 /)
      kao(:, 1,12,14) = (/ &
        & 0.37813e-02,0.33087e-02,0.28362e-02,0.23654e-02,0.19642e-02, &
        & 0.15868e-02,0.12220e-02,0.85134e-03,0.79810e-03 /)
      kao(:, 2,12,14) = (/ &
        & 0.37337e-02,0.32671e-02,0.28006e-02,0.23535e-02,0.19812e-02, &
        & 0.16073e-02,0.12646e-02,0.96230e-03,0.10021e-02 /)
      kao(:, 3,12,14) = (/ &
        & 0.36838e-02,0.32235e-02,0.27633e-02,0.23494e-02,0.19898e-02, &
        & 0.16363e-02,0.13472e-02,0.11056e-02,0.12297e-02 /)
      kao(:, 4,12,14) = (/ &
        & 0.36315e-02,0.31778e-02,0.27268e-02,0.23457e-02,0.20010e-02, &
        & 0.16953e-02,0.14396e-02,0.12736e-02,0.14737e-02 /)
      kao(:, 5,12,14) = (/ &
        & 0.35780e-02,0.31310e-02,0.26962e-02,0.23324e-02,0.20383e-02, &
        & 0.17680e-02,0.15379e-02,0.14913e-02,0.17515e-02 /)
      kao(:, 1,13,14) = (/ &
        & 0.40401e-02,0.35352e-02,0.30303e-02,0.25331e-02,0.21125e-02, &
        & 0.17061e-02,0.13144e-02,0.90469e-03,0.81129e-03 /)
      kao(:, 2,13,14) = (/ &
        & 0.39897e-02,0.34912e-02,0.29926e-02,0.25245e-02,0.21272e-02, &
        & 0.17273e-02,0.13608e-02,0.10148e-02,0.10248e-02 /)
      kao(:, 3,13,14) = (/ &
        & 0.39313e-02,0.34401e-02,0.29487e-02,0.25178e-02,0.21303e-02, &
        & 0.17587e-02,0.14454e-02,0.11592e-02,0.12656e-02 /)
      kao(:, 4,13,14) = (/ &
        & 0.38694e-02,0.33859e-02,0.29093e-02,0.25068e-02,0.21412e-02, &
        & 0.18203e-02,0.15361e-02,0.13357e-02,0.15298e-02 /)
      kao(:, 5,13,14) = (/ &
        & 0.38109e-02,0.33347e-02,0.28761e-02,0.24907e-02,0.21821e-02, &
        & 0.18916e-02,0.16371e-02,0.15629e-02,0.18275e-02 /)
      kao(:, 1, 1,15) = (/ &
        & 0.15071e-02,0.13191e-02,0.11311e-02,0.94313e-03,0.82178e-03, &
        & 0.90230e-03,0.10652e-02,0.11879e-02,0.14045e-02 /)
      kao(:, 2, 1,15) = (/ &
        & 0.15053e-02,0.13176e-02,0.11298e-02,0.94210e-03,0.87562e-03, &
        & 0.10432e-02,0.12302e-02,0.13664e-02,0.16201e-02 /)
      kao(:, 3, 1,15) = (/ &
        & 0.15019e-02,0.13147e-02,0.11275e-02,0.94187e-03,0.97652e-03, &
        & 0.12093e-02,0.14252e-02,0.15816e-02,0.18766e-02 /)
      kao(:, 4, 1,15) = (/ &
        & 0.14976e-02,0.13109e-02,0.11243e-02,0.96063e-03,0.11391e-02, &
        & 0.14106e-02,0.16622e-02,0.18446e-02,0.21889e-02 /)
      kao(:, 5, 1,15) = (/ &
        & 0.14918e-02,0.13060e-02,0.11201e-02,0.10256e-02,0.13135e-02, &
        & 0.16256e-02,0.19138e-02,0.21174e-02,0.25177e-02 /)
      kao(:, 1, 2,15) = (/ &
        & 0.17368e-02,0.15199e-02,0.13031e-02,0.10865e-02,0.93589e-03, &
        & 0.95913e-03,0.11327e-02,0.12643e-02,0.15179e-02 /)
      kao(:, 2, 2,15) = (/ &
        & 0.17347e-02,0.15183e-02,0.13018e-02,0.10853e-02,0.98162e-03, &
        & 0.11204e-02,0.13214e-02,0.14695e-02,0.17719e-02 /)
      kao(:, 3, 2,15) = (/ &
        & 0.17301e-02,0.15143e-02,0.12982e-02,0.10867e-02,0.10624e-02, &
        & 0.13058e-02,0.15388e-02,0.17088e-02,0.20640e-02 /)
      kao(:, 4, 2,15) = (/ &
        & 0.17235e-02,0.15085e-02,0.12935e-02,0.11059e-02,0.12337e-02, &
        & 0.15285e-02,0.18009e-02,0.19982e-02,0.24152e-02 /)
      kao(:, 5, 2,15) = (/ &
        & 0.17181e-02,0.15038e-02,0.12895e-02,0.11598e-02,0.14379e-02, &
        & 0.17807e-02,0.20976e-02,0.23230e-02,0.28132e-02 /)
      kao(:, 1, 3,15) = (/ &
        & 0.19949e-02,0.17458e-02,0.14967e-02,0.12475e-02,0.10641e-02, &
        & 0.10100e-02,0.11774e-02,0.13116e-02,0.16051e-02 /)
      kao(:, 2, 3,15) = (/ &
        & 0.19910e-02,0.17424e-02,0.14939e-02,0.12453e-02,0.11049e-02, &
        & 0.11564e-02,0.13657e-02,0.15222e-02,0.18601e-02 /)
      kao(:, 3, 3,15) = (/ &
        & 0.19848e-02,0.17370e-02,0.14892e-02,0.12476e-02,0.11571e-02, &
        & 0.13573e-02,0.16014e-02,0.17817e-02,0.21839e-02 /)
      kao(:, 4, 3,15) = (/ &
        & 0.19813e-02,0.17340e-02,0.14867e-02,0.12671e-02,0.12941e-02, &
        & 0.15954e-02,0.18821e-02,0.20919e-02,0.25670e-02 /)
      kao(:, 5, 3,15) = (/ &
        & 0.19771e-02,0.17304e-02,0.14836e-02,0.13013e-02,0.15091e-02, &
        & 0.18697e-02,0.22058e-02,0.24525e-02,0.30084e-02 /)
      kao(:, 1, 4,15) = (/ &
        & 0.23002e-02,0.20126e-02,0.17253e-02,0.14382e-02,0.12005e-02, &
        & 0.10932e-02,0.12228e-02,0.13639e-02,0.16798e-02 /)
      kao(:, 2, 4,15) = (/ &
        & 0.22929e-02,0.20065e-02,0.17201e-02,0.14337e-02,0.12491e-02, &
        & 0.11967e-02,0.14046e-02,0.15632e-02,0.19322e-02 /)
      kao(:, 3, 4,15) = (/ &
        & 0.22828e-02,0.19977e-02,0.17127e-02,0.14287e-02,0.12914e-02, &
        & 0.13860e-02,0.16360e-02,0.18240e-02,0.22487e-02 /)
      kao(:, 4, 4,15) = (/ &
        & 0.22757e-02,0.19915e-02,0.17074e-02,0.14457e-02,0.13800e-02, &
        & 0.16339e-02,0.19297e-02,0.21519e-02,0.26493e-02 /)
      kao(:, 5, 4,15) = (/ &
        & 0.22684e-02,0.19852e-02,0.17019e-02,0.14754e-02,0.15614e-02, &
        & 0.19242e-02,0.22727e-02,0.25341e-02,0.31196e-02 /)
      kao(:, 1, 5,15) = (/ &
        & 0.26562e-02,0.23246e-02,0.19929e-02,0.16611e-02,0.13598e-02, &
        & 0.11996e-02,0.12698e-02,0.14174e-02,0.17501e-02 /)
      kao(:, 2, 5,15) = (/ &
        & 0.26415e-02,0.23116e-02,0.19818e-02,0.16521e-02,0.14129e-02, &
        & 0.12866e-02,0.14524e-02,0.16197e-02,0.20022e-02 /)
      kao(:, 3, 5,15) = (/ &
        & 0.26277e-02,0.22994e-02,0.19710e-02,0.16428e-02,0.14513e-02, &
        & 0.14339e-02,0.16856e-02,0.18777e-02,0.23236e-02 /)
      kao(:, 4, 5,15) = (/ &
        & 0.26179e-02,0.22909e-02,0.19639e-02,0.16526e-02,0.15154e-02, &
        & 0.16607e-02,0.19618e-02,0.21909e-02,0.27021e-02 /)
      kao(:, 5, 5,15) = (/ &
        & 0.26074e-02,0.22818e-02,0.19561e-02,0.16780e-02,0.16497e-02, &
        & 0.19592e-02,0.23163e-02,0.25915e-02,0.31846e-02 /)
      kao(:, 1, 6,15) = (/ &
        & 0.30676e-02,0.26845e-02,0.23014e-02,0.19182e-02,0.15508e-02, &
        & 0.13265e-02,0.13165e-02,0.14712e-02,0.18123e-02 /)
      kao(:, 2, 6,15) = (/ &
        & 0.30472e-02,0.26667e-02,0.22862e-02,0.19057e-02,0.15947e-02, &
        & 0.14067e-02,0.15004e-02,0.16750e-02,0.20695e-02 /)
      kao(:, 3, 6,15) = (/ &
        & 0.30255e-02,0.26477e-02,0.22705e-02,0.18926e-02,0.16408e-02, &
        & 0.15149e-02,0.17276e-02,0.19275e-02,0.23847e-02 /)
      kao(:, 4, 6,15) = (/ &
        & 0.30083e-02,0.26326e-02,0.22569e-02,0.18906e-02,0.16765e-02, &
        & 0.17066e-02,0.20035e-02,0.22386e-02,0.27616e-02 /)
      kao(:, 5, 6,15) = (/ &
        & 0.29915e-02,0.26179e-02,0.22443e-02,0.19114e-02,0.17836e-02, &
        & 0.19800e-02,0.23411e-02,0.26194e-02,0.32234e-02 /)
      kao(:, 1, 7,15) = (/ &
        & 0.35311e-02,0.30900e-02,0.26490e-02,0.22082e-02,0.17722e-02, &
        & 0.14850e-02,0.13781e-02,0.15158e-02,0.18578e-02 /)
      kao(:, 2, 7,15) = (/ &
        & 0.35031e-02,0.30656e-02,0.26281e-02,0.21907e-02,0.18048e-02, &
        & 0.15528e-02,0.15481e-02,0.17322e-02,0.21307e-02 /)
      kao(:, 3, 7,15) = (/ &
        & 0.34762e-02,0.30421e-02,0.26077e-02,0.21737e-02,0.18550e-02, &
        & 0.16362e-02,0.17771e-02,0.19863e-02,0.24506e-02 /)
      kao(:, 4, 7,15) = (/ &
        & 0.34506e-02,0.30197e-02,0.25888e-02,0.21628e-02,0.18864e-02, &
        & 0.17891e-02,0.20527e-02,0.22948e-02,0.28308e-02 /)
      kao(:, 5, 7,15) = (/ &
        & 0.34242e-02,0.29966e-02,0.25690e-02,0.21752e-02,0.19463e-02, &
        & 0.20224e-02,0.23798e-02,0.26659e-02,0.32785e-02 /)
      kao(:, 1, 8,15) = (/ &
        & 0.40545e-02,0.35480e-02,0.30415e-02,0.25348e-02,0.20284e-02, &
        & 0.16698e-02,0.14585e-02,0.15473e-02,0.18938e-02 /)
      kao(:, 2, 8,15) = (/ &
        & 0.40094e-02,0.35086e-02,0.30078e-02,0.25070e-02,0.20421e-02, &
        & 0.17325e-02,0.16159e-02,0.17783e-02,0.21732e-02 /)
      kao(:, 3, 8,15) = (/ &
        & 0.39679e-02,0.34723e-02,0.29772e-02,0.24816e-02,0.20882e-02, &
        & 0.17972e-02,0.18217e-02,0.20430e-02,0.25042e-02 /)
      kao(:, 4, 8,15) = (/ &
        & 0.39321e-02,0.34411e-02,0.29500e-02,0.24630e-02,0.21284e-02, &
        & 0.19080e-02,0.21043e-02,0.23586e-02,0.28966e-02 /)
      kao(:, 5, 8,15) = (/ &
        & 0.38953e-02,0.34088e-02,0.29224e-02,0.24683e-02,0.21576e-02, &
        & 0.21070e-02,0.24382e-02,0.27335e-02,0.33549e-02 /)
      kao(:, 1, 9,15) = (/ &
        & 0.46508e-02,0.40697e-02,0.34886e-02,0.29075e-02,0.23264e-02, &
        & 0.18591e-02,0.15578e-02,0.15738e-02,0.19224e-02 /)
      kao(:, 2, 9,15) = (/ &
        & 0.45823e-02,0.40098e-02,0.34374e-02,0.28649e-02,0.23092e-02, &
        & 0.19366e-02,0.17051e-02,0.18133e-02,0.22104e-02 /)
      kao(:, 3, 9,15) = (/ &
        & 0.45166e-02,0.39524e-02,0.33880e-02,0.28238e-02,0.23394e-02, &
        & 0.19917e-02,0.18843e-02,0.20815e-02,0.25365e-02 /)
      kao(:, 4, 9,15) = (/ &
        & 0.44602e-02,0.39031e-02,0.33460e-02,0.27890e-02,0.23856e-02, &
        & 0.20682e-02,0.21419e-02,0.24093e-02,0.29396e-02 /)
      kao(:, 5, 9,15) = (/ &
        & 0.44050e-02,0.38549e-02,0.33047e-02,0.27817e-02,0.24123e-02, &
        & 0.22258e-02,0.24850e-02,0.27956e-02,0.34119e-02 /)
      kao(:, 1,10,15) = (/ &
        & 0.53098e-02,0.46463e-02,0.39828e-02,0.33194e-02,0.26559e-02, &
        & 0.20766e-02,0.16840e-02,0.16129e-02,0.19635e-02 /)
      kao(:, 2,10,15) = (/ &
        & 0.52134e-02,0.45620e-02,0.39106e-02,0.32592e-02,0.26145e-02, &
        & 0.21601e-02,0.18269e-02,0.18690e-02,0.22681e-02 /)
      kao(:, 3,10,15) = (/ &
        & 0.51182e-02,0.44788e-02,0.38392e-02,0.31998e-02,0.26226e-02, &
        & 0.22138e-02,0.19824e-02,0.21416e-02,0.25956e-02 /)
      kao(:, 4,10,15) = (/ &
        & 0.50344e-02,0.44054e-02,0.37765e-02,0.31477e-02,0.26616e-02, &
        & 0.22709e-02,0.22099e-02,0.24682e-02,0.29962e-02 /)
      kao(:, 5,10,15) = (/ &
        & 0.49550e-02,0.43361e-02,0.37172e-02,0.31183e-02,0.26883e-02, &
        & 0.23873e-02,0.25425e-02,0.28708e-02,0.34790e-02 /)
      kao(:, 1,11,15) = (/ &
        & 0.59619e-02,0.52169e-02,0.44719e-02,0.37267e-02,0.29817e-02, &
        & 0.23525e-02,0.18854e-02,0.17723e-02,0.21445e-02 /)
      kao(:, 2,11,15) = (/ &
        & 0.58318e-02,0.51031e-02,0.43744e-02,0.36457e-02,0.29351e-02, &
        & 0.24253e-02,0.20278e-02,0.20449e-02,0.24715e-02 /)
      kao(:, 3,11,15) = (/ &
        & 0.57112e-02,0.49976e-02,0.42840e-02,0.35704e-02,0.29381e-02, &
        & 0.24724e-02,0.21871e-02,0.23372e-02,0.28231e-02 /)
      kao(:, 4,11,15) = (/ &
        & 0.56008e-02,0.49010e-02,0.42013e-02,0.35025e-02,0.29677e-02, &
        & 0.25269e-02,0.24222e-02,0.27009e-02,0.32614e-02 /)
      kao(:, 5,11,15) = (/ &
        & 0.54961e-02,0.48096e-02,0.41230e-02,0.34666e-02,0.29811e-02, &
        & 0.26438e-02,0.27691e-02,0.31324e-02,0.37747e-02 /)
      kao(:, 1,12,15) = (/ &
        & 0.66218e-02,0.57942e-02,0.49667e-02,0.41391e-02,0.33116e-02, &
        & 0.26382e-02,0.20922e-02,0.19344e-02,0.23267e-02 /)
      kao(:, 2,12,15) = (/ &
        & 0.64584e-02,0.56513e-02,0.48443e-02,0.40372e-02,0.32618e-02, &
        & 0.26974e-02,0.22343e-02,0.22270e-02,0.26783e-02 /)
      kao(:, 3,12,15) = (/ &
        & 0.63097e-02,0.55213e-02,0.47331e-02,0.39445e-02,0.32599e-02, &
        & 0.27357e-02,0.23983e-02,0.25418e-02,0.30577e-02 /)
      kao(:, 4,12,15) = (/ &
        & 0.61694e-02,0.53986e-02,0.46278e-02,0.38631e-02,0.32772e-02, &
        & 0.27857e-02,0.26412e-02,0.29352e-02,0.35233e-02 /)
      kao(:, 5,12,15) = (/ &
        & 0.60360e-02,0.52820e-02,0.45279e-02,0.38177e-02,0.32735e-02, &
        & 0.29011e-02,0.29998e-02,0.33948e-02,0.40685e-02 /)
      kao(:, 1,13,15) = (/ &
        & 0.72856e-02,0.63751e-02,0.54646e-02,0.45539e-02,0.36434e-02, &
        & 0.29246e-02,0.23024e-02,0.20968e-02,0.25004e-02 /)
      kao(:, 2,13,15) = (/ &
        & 0.70792e-02,0.61945e-02,0.53099e-02,0.44252e-02,0.35875e-02, &
        & 0.29681e-02,0.24397e-02,0.24073e-02,0.28787e-02 /)
      kao(:, 3,13,15) = (/ &
        & 0.68966e-02,0.60348e-02,0.51733e-02,0.43112e-02,0.35811e-02, &
        & 0.29976e-02,0.26071e-02,0.27479e-02,0.32886e-02 /)
      kao(:, 4,13,15) = (/ &
        & 0.67258e-02,0.58855e-02,0.50451e-02,0.42204e-02,0.35830e-02, &
        & 0.30400e-02,0.28573e-02,0.31625e-02,0.37791e-02 /)
      kao(:, 5,13,15) = (/ &
        & 0.65607e-02,0.57411e-02,0.49214e-02,0.41617e-02,0.35593e-02, &
        & 0.31530e-02,0.32258e-02,0.36487e-02,0.43508e-02 /)
      kao(:, 1, 1,16) = (/ &
        & 0.16712e-02,0.14631e-02,0.12550e-02,0.10468e-02,0.92082e-03, &
        & 0.11371e-02,0.13321e-02,0.14544e-02,0.17472e-02 /)
      kao(:, 2, 1,16) = (/ &
        & 0.16787e-02,0.14701e-02,0.12615e-02,0.10530e-02,0.10440e-02, &
        & 0.12893e-02,0.15114e-02,0.16524e-02,0.19826e-02 /)
      kao(:, 3, 1,16) = (/ &
        & 0.16875e-02,0.14779e-02,0.12683e-02,0.10588e-02,0.11676e-02, &
        & 0.14424e-02,0.16914e-02,0.18523e-02,0.22202e-02 /)
      kao(:, 4, 1,16) = (/ &
        & 0.16926e-02,0.14826e-02,0.12725e-02,0.10626e-02,0.12909e-02, &
        & 0.15950e-02,0.18720e-02,0.20532e-02,0.24579e-02 /)
      kao(:, 5, 1,16) = (/ &
        & 0.16942e-02,0.14841e-02,0.12739e-02,0.11419e-02,0.15149e-02, &
        & 0.18796e-02,0.22246e-02,0.24968e-02,0.29379e-02 /)
      kao(:, 1, 2,16) = (/ &
        & 0.19607e-02,0.17158e-02,0.14714e-02,0.12274e-02,0.10440e-02, &
        & 0.12890e-02,0.15097e-02,0.16471e-02,0.20285e-02 /)
      kao(:, 2, 2,16) = (/ &
        & 0.19666e-02,0.17216e-02,0.14767e-02,0.12314e-02,0.11872e-02, &
        & 0.14659e-02,0.17177e-02,0.18761e-02,0.23077e-02 /)
      kao(:, 3, 2,16) = (/ &
        & 0.19740e-02,0.17284e-02,0.14830e-02,0.12374e-02,0.13301e-02, &
        & 0.16429e-02,0.19255e-02,0.21058e-02,0.25866e-02 /)
      kao(:, 4, 2,16) = (/ &
        & 0.19796e-02,0.17334e-02,0.14872e-02,0.12416e-02,0.14717e-02, &
        & 0.18182e-02,0.21321e-02,0.23342e-02,0.28637e-02 /)
      kao(:, 5, 2,16) = (/ &
        & 0.19818e-02,0.17354e-02,0.14891e-02,0.12544e-02,0.16318e-02, &
        & 0.20217e-02,0.23832e-02,0.26470e-02,0.31951e-02 /)
      kao(:, 1, 3,16) = (/ &
        & 0.23039e-02,0.20168e-02,0.17292e-02,0.14410e-02,0.11614e-02, &
        & 0.14213e-02,0.16646e-02,0.18149e-02,0.22923e-02 /)
      kao(:, 2, 3,16) = (/ &
        & 0.23064e-02,0.20187e-02,0.17311e-02,0.14440e-02,0.13190e-02, &
        & 0.16288e-02,0.19083e-02,0.20825e-02,0.26267e-02 /)
      kao(:, 3, 3,16) = (/ &
        & 0.23119e-02,0.20237e-02,0.17351e-02,0.14470e-02,0.14864e-02, &
        & 0.18354e-02,0.21515e-02,0.23501e-02,0.29596e-02 /)
      kao(:, 4, 3,16) = (/ &
        & 0.23154e-02,0.20269e-02,0.17385e-02,0.14496e-02,0.16513e-02, &
        & 0.20395e-02,0.23915e-02,0.26154e-02,0.32883e-02 /)
      kao(:, 5, 3,16) = (/ &
        & 0.23212e-02,0.20321e-02,0.17430e-02,0.14536e-02,0.18129e-02, &
        & 0.22398e-02,0.26272e-02,0.28760e-02,0.36101e-02 /)
      kao(:, 1, 4,16) = (/ &
        & 0.27129e-02,0.23736e-02,0.20348e-02,0.16965e-02,0.13577e-02, &
        & 0.15487e-02,0.18138e-02,0.19776e-02,0.25289e-02 /)
      kao(:, 2, 4,16) = (/ &
        & 0.27133e-02,0.23745e-02,0.20358e-02,0.16966e-02,0.14516e-02, &
        & 0.17925e-02,0.21002e-02,0.22917e-02,0.29262e-02 /)
      kao(:, 3, 4,16) = (/ &
        & 0.27155e-02,0.23766e-02,0.20379e-02,0.16990e-02,0.16483e-02, &
        & 0.20360e-02,0.23858e-02,0.26061e-02,0.33224e-02 /)
      kao(:, 4, 4,16) = (/ &
        & 0.27175e-02,0.23784e-02,0.20394e-02,0.17007e-02,0.18426e-02, &
        & 0.22757e-02,0.26681e-02,0.29171e-02,0.37132e-02 /)
      kao(:, 5, 4,16) = (/ &
        & 0.27186e-02,0.23796e-02,0.20406e-02,0.17019e-02,0.20320e-02, &
        & 0.25101e-02,0.29443e-02,0.32220e-02,0.40947e-02 /)
      kao(:, 1, 5,16) = (/ &
        & 0.32119e-02,0.28114e-02,0.24099e-02,0.20078e-02,0.16065e-02, &
        & 0.16767e-02,0.19643e-02,0.21431e-02,0.27523e-02 /)
      kao(:, 2, 5,16) = (/ &
        & 0.32085e-02,0.28077e-02,0.24069e-02,0.20064e-02,0.16195e-02, &
        & 0.19633e-02,0.23007e-02,0.25120e-02,0.32215e-02 /)
      kao(:, 3, 5,16) = (/ &
        & 0.32085e-02,0.28078e-02,0.24068e-02,0.20061e-02,0.18214e-02, &
        & 0.22501e-02,0.26375e-02,0.28827e-02,0.36897e-02 /)
      kao(:, 4, 5,16) = (/ &
        & 0.32059e-02,0.28056e-02,0.24053e-02,0.20050e-02,0.20501e-02, &
        & 0.25321e-02,0.29699e-02,0.32491e-02,0.41521e-02 /)
      kao(:, 5, 5,16) = (/ &
        & 0.31984e-02,0.27990e-02,0.23997e-02,0.20000e-02,0.22727e-02, &
        & 0.28084e-02,0.32949e-02,0.36079e-02,0.46028e-02 /)
      kao(:, 1, 6,16) = (/ &
        & 0.38076e-02,0.33317e-02,0.28559e-02,0.23799e-02,0.19041e-02, &
        & 0.17889e-02,0.20969e-02,0.22903e-02,0.29420e-02 /)
      kao(:, 2, 6,16) = (/ &
        & 0.37964e-02,0.33220e-02,0.28476e-02,0.23732e-02,0.18989e-02, &
        & 0.21234e-02,0.24900e-02,0.27226e-02,0.34908e-02 /)
      kao(:, 3, 6,16) = (/ &
        & 0.37877e-02,0.33145e-02,0.28416e-02,0.23683e-02,0.19985e-02, &
        & 0.24600e-02,0.28851e-02,0.31576e-02,0.40421e-02 /)
      kao(:, 4, 6,16) = (/ &
        & 0.37785e-02,0.33065e-02,0.28344e-02,0.23627e-02,0.22594e-02, &
        & 0.27919e-02,0.32761e-02,0.35889e-02,0.45855e-02 /)
      kao(:, 5, 6,16) = (/ &
        & 0.37630e-02,0.32929e-02,0.28229e-02,0.23532e-02,0.25213e-02, &
        & 0.31161e-02,0.36579e-02,0.40115e-02,0.51155e-02 /)
      kao(:, 1, 7,16) = (/ &
        & 0.45014e-02,0.39388e-02,0.33762e-02,0.28135e-02,0.22509e-02, &
        & 0.18859e-02,0.22117e-02,0.24208e-02,0.31038e-02 /)
      kao(:, 2, 7,16) = (/ &
        & 0.44788e-02,0.39190e-02,0.33593e-02,0.27996e-02,0.22399e-02, &
        & 0.22735e-02,0.26677e-02,0.29222e-02,0.37394e-02 /)
      kao(:, 3, 7,16) = (/ &
        & 0.44593e-02,0.39020e-02,0.33439e-02,0.27867e-02,0.22518e-02, &
        & 0.26648e-02,0.31283e-02,0.34304e-02,0.43806e-02 /)
      kao(:, 4, 7,16) = (/ &
        & 0.44374e-02,0.38829e-02,0.33284e-02,0.27732e-02,0.24705e-02, &
        & 0.30533e-02,0.35850e-02,0.39361e-02,0.50160e-02 /)
      kao(:, 5, 7,16) = (/ &
        & 0.44113e-02,0.38601e-02,0.33089e-02,0.27567e-02,0.27756e-02, &
        & 0.34321e-02,0.40324e-02,0.44314e-02,0.56359e-02 /)
      kao(:, 1, 8,16) = (/ &
        & 0.53031e-02,0.46403e-02,0.39774e-02,0.33149e-02,0.26520e-02, &
        & 0.20316e-02,0.23080e-02,0.25314e-02,0.32334e-02 /)
      kao(:, 2, 8,16) = (/ &
        & 0.52648e-02,0.46067e-02,0.39487e-02,0.32907e-02,0.26325e-02, &
        & 0.24096e-02,0.28298e-02,0.31081e-02,0.39611e-02 /)
      kao(:, 3, 8,16) = (/ &
        & 0.52246e-02,0.45716e-02,0.39189e-02,0.32659e-02,0.26125e-02, &
        & 0.28611e-02,0.33614e-02,0.36958e-02,0.47006e-02 /)
      kao(:, 4, 8,16) = (/ &
        & 0.51821e-02,0.45344e-02,0.38868e-02,0.32390e-02,0.27289e-02, &
        & 0.33103e-02,0.38912e-02,0.42829e-02,0.54355e-02 /)
      kao(:, 5, 8,16) = (/ &
        & 0.51356e-02,0.44938e-02,0.38520e-02,0.32108e-02,0.30299e-02, &
        & 0.37493e-02,0.44090e-02,0.48604e-02,0.61537e-02 /)
      kao(:, 1, 9,16) = (/ &
        & 0.62116e-02,0.54352e-02,0.46587e-02,0.38825e-02,0.31060e-02, &
        & 0.23296e-02,0.23830e-02,0.26152e-02,0.33400e-02 /)
      kao(:, 2, 9,16) = (/ &
        & 0.61510e-02,0.53822e-02,0.46134e-02,0.38445e-02,0.30756e-02, &
        & 0.25421e-02,0.29622e-02,0.32625e-02,0.41372e-02 /)
      kao(:, 3, 9,16) = (/ &
        & 0.60862e-02,0.53255e-02,0.45651e-02,0.38044e-02,0.30427e-02, &
        & 0.30332e-02,0.35680e-02,0.39355e-02,0.49777e-02 /)
      kao(:, 4, 9,16) = (/ &
        & 0.60169e-02,0.52649e-02,0.45129e-02,0.37608e-02,0.30629e-02, &
        & 0.35468e-02,0.41747e-02,0.46107e-02,0.58172e-02 /)
      kao(:, 5, 9,16) = (/ &
        & 0.59428e-02,0.52001e-02,0.44573e-02,0.37148e-02,0.33039e-02, &
        & 0.40510e-02,0.47683e-02,0.52747e-02,0.66403e-02 /)
      kao(:, 1,10,16) = (/ &
        & 0.72226e-02,0.63198e-02,0.54170e-02,0.45138e-02,0.36111e-02, &
        & 0.27087e-02,0.25246e-02,0.27733e-02,0.35348e-02 /)
      kao(:, 2,10,16) = (/ &
        & 0.71308e-02,0.62395e-02,0.53482e-02,0.44569e-02,0.35656e-02, &
        & 0.27737e-02,0.31148e-02,0.34380e-02,0.43453e-02 /)
      kao(:, 3,10,16) = (/ &
        & 0.70337e-02,0.61546e-02,0.52755e-02,0.43963e-02,0.35178e-02, &
        & 0.32195e-02,0.37898e-02,0.41956e-02,0.52718e-02 /)
      kao(:, 4,10,16) = (/ &
        & 0.69308e-02,0.60645e-02,0.51982e-02,0.43312e-02,0.34725e-02, &
        & 0.37977e-02,0.44773e-02,0.49627e-02,0.62190e-02 /)
      kao(:, 5,10,16) = (/ &
        & 0.68213e-02,0.59687e-02,0.51162e-02,0.42630e-02,0.36577e-02, &
        & 0.43690e-02,0.51523e-02,0.57195e-02,0.71486e-02 /)
      kao(:, 1,11,16) = (/ &
        & 0.82729e-02,0.72388e-02,0.62047e-02,0.51704e-02,0.41364e-02, &
        & 0.31022e-02,0.29450e-02,0.32481e-02,0.41092e-02 /)
      kao(:, 2,11,16) = (/ &
        & 0.81377e-02,0.71207e-02,0.61034e-02,0.50862e-02,0.40694e-02, &
        & 0.32023e-02,0.35972e-02,0.39817e-02,0.50045e-02 /)
      kao(:, 3,11,16) = (/ &
        & 0.79927e-02,0.69937e-02,0.59945e-02,0.49955e-02,0.39980e-02, &
        & 0.36849e-02,0.43305e-02,0.48162e-02,0.60016e-02 /)
      kao(:, 4,11,16) = (/ &
        & 0.78435e-02,0.68631e-02,0.58827e-02,0.49014e-02,0.39530e-02, &
        & 0.43152e-02,0.50942e-02,0.56750e-02,0.70494e-02 /)
      kao(:, 5,11,16) = (/ &
        & 0.76868e-02,0.67260e-02,0.57653e-02,0.48045e-02,0.41698e-02, &
        & 0.49442e-02,0.58408e-02,0.65151e-02,0.80731e-02 /)
      kao(:, 1,12,16) = (/ &
        & 0.93677e-02,0.81967e-02,0.70258e-02,0.58546e-02,0.46837e-02, &
        & 0.35124e-02,0.33991e-02,0.37659e-02,0.47255e-02 /)
      kao(:, 2,12,16) = (/ &
        & 0.91725e-02,0.80259e-02,0.68794e-02,0.57329e-02,0.45871e-02, &
        & 0.36555e-02,0.41158e-02,0.45739e-02,0.57058e-02 /)
      kao(:, 3,12,16) = (/ &
        & 0.89743e-02,0.78526e-02,0.67312e-02,0.56083e-02,0.44874e-02, &
        & 0.41738e-02,0.49000e-02,0.54681e-02,0.67707e-02 /)
      kao(:, 4,12,16) = (/ &
        & 0.87651e-02,0.76695e-02,0.65740e-02,0.54780e-02,0.44541e-02, &
        & 0.48422e-02,0.57276e-02,0.64103e-02,0.78928e-02 /)
      kao(:, 5,12,16) = (/ &
        & 0.85557e-02,0.74863e-02,0.64169e-02,0.53471e-02,0.46965e-02, &
        & 0.55261e-02,0.65398e-02,0.73300e-02,0.90026e-02 /)
      kao(:, 1,13,16) = (/ &
        & 0.10484e-01,0.91737e-02,0.78632e-02,0.65525e-02,0.52420e-02, &
        & 0.39330e-02,0.38753e-02,0.43130e-02,0.53655e-02 /)
      kao(:, 2,13,16) = (/ &
        & 0.10212e-01,0.89352e-02,0.76588e-02,0.63823e-02,0.51063e-02, &
        & 0.41214e-02,0.46538e-02,0.51962e-02,0.64287e-02 /)
      kao(:, 3,13,16) = (/ &
        & 0.99472e-02,0.87039e-02,0.74620e-02,0.62164e-02,0.49733e-02, &
        & 0.46683e-02,0.54886e-02,0.61482e-02,0.75590e-02 /)
      kao(:, 4,13,16) = (/ &
        & 0.96776e-02,0.84679e-02,0.72583e-02,0.60495e-02,0.49611e-02, &
        & 0.53643e-02,0.63558e-02,0.71458e-02,0.87290e-02 /)
      kao(:, 5,13,16) = (/ &
        & 0.94084e-02,0.82324e-02,0.70564e-02,0.58807e-02,0.52210e-02, &
        & 0.60971e-02,0.72271e-02,0.81397e-02,0.99102e-02 /)
  
!     -----------------------------------------------------------------
!     The array KBO contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels < ~100mb and temperatures. The first 
!     index in the array, JT, which runs from 1 to 5, corresponds to 
!     different temperatures.  More specifically, JT = 3 means that the 
!     data are for the reference temperature TREF for this pressure 
!     level, JT = 2 refers to the temperature TREF-15, JT = 1 is for
!     TREF-30, JT = 4 is for TREF+15, and JT = 5 is for TREF+30.  
!     The second index, JP, runs from 13 to 59 and refers to the JPth
!     reference pressure level (see taumol.f for the value of these
!     pressure levels in mb).  The third index, IG, goes from 1 to 16,
!     and tells us which g-interval the absorption coefficients are for.
!     -----------------------------------------------------------------

      kbo(:,13, 1) = (/ &
        & 0.33062e-11,0.42306e-11,0.53172e-11,0.65673e-11,0.78335e-11 /)
      kbo(:,14, 1) = (/ &
        & 0.27467e-11,0.35252e-11,0.44160e-11,0.54171e-11,0.64630e-11 /)
      kbo(:,15, 1) = (/ &
        & 0.23431e-11,0.29962e-11,0.37507e-11,0.46179e-11,0.54790e-11 /)
      kbo(:,16, 1) = (/ &
        & 0.20178e-11,0.25698e-11,0.32330e-11,0.40024e-11,0.46899e-11 /)
      kbo(:,17, 1) = (/ &
        & 0.17389e-11,0.22126e-11,0.27864e-11,0.34615e-11,0.40184e-11 /)
      kbo(:,18, 1) = (/ &
        & 0.15164e-11,0.19304e-11,0.24263e-11,0.29918e-11,0.34734e-11 /)
      kbo(:,19, 1) = (/ &
        & 0.13194e-11,0.16684e-11,0.20851e-11,0.25471e-11,0.29992e-11 /)
      kbo(:,20, 1) = (/ &
        & 0.11345e-11,0.14317e-11,0.17813e-11,0.21686e-11,0.25523e-11 /)
      kbo(:,21, 1) = (/ &
        & 0.97614e-12,0.12233e-11,0.15124e-11,0.18436e-11,0.21624e-11 /)
      kbo(:,22, 1) = (/ &
        & 0.84972e-12,0.10604e-11,0.13001e-11,0.15853e-11,0.18511e-11 /)
      kbo(:,23, 1) = (/ &
        & 0.73919e-12,0.91863e-12,0.11179e-11,0.13612e-11,0.15791e-11 /)
      kbo(:,24, 1) = (/ &
        & 0.63952e-12,0.79203e-12,0.96272e-12,0.11643e-11,0.13384e-11 /)
      kbo(:,25, 1) = (/ &
        & 0.55198e-12,0.68176e-12,0.82782e-12,0.99347e-12,0.11342e-11 /)
      kbo(:,26, 1) = (/ &
        & 0.47648e-12,0.58395e-12,0.71214e-12,0.84565e-12,0.96146e-12 /)
      kbo(:,27, 1) = (/ &
        & 0.41185e-12,0.50403e-12,0.61156e-12,0.71539e-12,0.81410e-12 /)
      kbo(:,28, 1) = (/ &
        & 0.35568e-12,0.43404e-12,0.52441e-12,0.60652e-12,0.68860e-12 /)
      kbo(:,29, 1) = (/ &
        & 0.30863e-12,0.37487e-12,0.45120e-12,0.51591e-12,0.58367e-12 /)
      kbo(:,30, 1) = (/ &
        & 0.26804e-12,0.32390e-12,0.38615e-12,0.43956e-12,0.49890e-12 /)
      kbo(:,31, 1) = (/ &
        & 0.23316e-12,0.28106e-12,0.33068e-12,0.37478e-12,0.42377e-12 /)
      kbo(:,32, 1) = (/ &
        & 0.20255e-12,0.24397e-12,0.28293e-12,0.31878e-12,0.36224e-12 /)
      kbo(:,33, 1) = (/ &
        & 0.17541e-12,0.21018e-12,0.24052e-12,0.27083e-12,0.30963e-12 /)
      kbo(:,34, 1) = (/ &
        & 0.15014e-12,0.17890e-12,0.20293e-12,0.23058e-12,0.26131e-12 /)
      kbo(:,35, 1) = (/ &
        & 0.12610e-12,0.14972e-12,0.16906e-12,0.19250e-12,0.21752e-12 /)
      kbo(:,36, 1) = (/ &
        & 0.10365e-12,0.12301e-12,0.13878e-12,0.15810e-12,0.17856e-12 /)
      kbo(:,37, 1) = (/ &
        & 0.82572e-13,0.98388e-13,0.11143e-12,0.12645e-12,0.14343e-12 /)
      kbo(:,38, 1) = (/ &
        & 0.65632e-13,0.78531e-13,0.89359e-13,0.10135e-12,0.11495e-12 /)
      kbo(:,39, 1) = (/ &
        & 0.52174e-13,0.62607e-13,0.71650e-13,0.80738e-13,0.92112e-13 /)
      kbo(:,40, 1) = (/ &
        & 0.40434e-13,0.48683e-13,0.56479e-13,0.63806e-13,0.72155e-13 /)
      kbo(:,41, 1) = (/ &
        & 0.31179e-13,0.37691e-13,0.44339e-13,0.50247e-13,0.56982e-13 /)
      kbo(:,42, 1) = (/ &
        & 0.24040e-13,0.29161e-13,0.34731e-13,0.39467e-13,0.44922e-13 /)
      kbo(:,43, 1) = (/ &
        & 0.18259e-13,0.22185e-13,0.26753e-13,0.30617e-13,0.34721e-13 /)
      kbo(:,44, 1) = (/ &
        & 0.13667e-13,0.16662e-13,0.20308e-13,0.23577e-13,0.26865e-13 /)
      kbo(:,45, 1) = (/ &
        & 0.10182e-13,0.12571e-13,0.15345e-13,0.18028e-13,0.20725e-13 /)
      kbo(:,46, 1) = (/ &
        & 0.75196e-14,0.94092e-14,0.11475e-13,0.13704e-13,0.15878e-13 /)
      kbo(:,47, 1) = (/ &
        & 0.54721e-14,0.69523e-14,0.85280e-14,0.10311e-13,0.11952e-13 /)
      kbo(:,48, 1) = (/ &
        & 0.39619e-14,0.50439e-14,0.62896e-14,0.77193e-14,0.89282e-14 /)
      kbo(:,49, 1) = (/ &
        & 0.28508e-14,0.36419e-14,0.46044e-14,0.57276e-14,0.66866e-14 /)
      kbo(:,50, 1) = (/ &
        & 0.20973e-14,0.26588e-14,0.33754e-14,0.42404e-14,0.50338e-14 /)
      kbo(:,51, 1) = (/ &
        & 0.15010e-14,0.19461e-14,0.24807e-14,0.31095e-14,0.37789e-14 /)
      kbo(:,52, 1) = (/ &
        & 0.10686e-14,0.14205e-14,0.18164e-14,0.22651e-14,0.27790e-14 /)
      kbo(:,53, 1) = (/ &
        & 0.75469e-15,0.10279e-14,0.13211e-14,0.16657e-14,0.20344e-14 /)
      kbo(:,54, 1) = (/ &
        & 0.53837e-15,0.75440e-15,0.97064e-15,0.12260e-14,0.15156e-14 /)
      kbo(:,55, 1) = (/ &
        & 0.38620e-15,0.54750e-15,0.71223e-15,0.90921e-15,0.11265e-14 /)
      kbo(:,56, 1) = (/ &
        & 0.27852e-15,0.39135e-15,0.51858e-15,0.66760e-15,0.83486e-15 /)
      kbo(:,57, 1) = (/ &
        & 0.20280e-15,0.27940e-15,0.37558e-15,0.48656e-15,0.61658e-15 /)
      kbo(:,58, 1) = (/ &
        & 0.14586e-15,0.19788e-15,0.27273e-15,0.35391e-15,0.45250e-15 /)
      kbo(:,59, 1) = (/ &
        & 0.11164e-15,0.15082e-15,0.20804e-15,0.27081e-15,0.49339e-15 /)
      kbo(:,13, 2) = (/ &
        & 0.15800e-10,0.20781e-10,0.26154e-10,0.31936e-10,0.38062e-10 /)
      kbo(:,14, 2) = (/ &
        & 0.13333e-10,0.17459e-10,0.21881e-10,0.26666e-10,0.31696e-10 /)
      kbo(:,15, 2) = (/ &
        & 0.11381e-10,0.14784e-10,0.18449e-10,0.22397e-10,0.26533e-10 /)
      kbo(:,16, 2) = (/ &
        & 0.97593e-11,0.12591e-10,0.15641e-10,0.18845e-10,0.22503e-10 /)
      kbo(:,17, 2) = (/ &
        & 0.83473e-11,0.10709e-10,0.13261e-10,0.15857e-10,0.19052e-10 /)
      kbo(:,18, 2) = (/ &
        & 0.71523e-11,0.91255e-11,0.11229e-10,0.13436e-10,0.16145e-10 /)
      kbo(:,19, 2) = (/ &
        & 0.60777e-11,0.77489e-11,0.94796e-11,0.11415e-10,0.13591e-10 /)
      kbo(:,20, 2) = (/ &
        & 0.51693e-11,0.65609e-11,0.80124e-11,0.96944e-11,0.11427e-10 /)
      kbo(:,21, 2) = (/ &
        & 0.43931e-11,0.55492e-11,0.67698e-11,0.81825e-11,0.95836e-11 /)
      kbo(:,22, 2) = (/ &
        & 0.37967e-11,0.47515e-11,0.57759e-11,0.69676e-11,0.81090e-11 /)
      kbo(:,23, 2) = (/ &
        & 0.32747e-11,0.40830e-11,0.49616e-11,0.59280e-11,0.68614e-11 /)
      kbo(:,24, 2) = (/ &
        & 0.28215e-11,0.34976e-11,0.42532e-11,0.50228e-11,0.57971e-11 /)
      kbo(:,25, 2) = (/ &
        & 0.24334e-11,0.29960e-11,0.36396e-11,0.42606e-11,0.49056e-11 /)
      kbo(:,26, 2) = (/ &
        & 0.21117e-11,0.25752e-11,0.31134e-11,0.36244e-11,0.41489e-11 /)
      kbo(:,27, 2) = (/ &
        & 0.18253e-11,0.22243e-11,0.26576e-11,0.30793e-11,0.35048e-11 /)
      kbo(:,28, 2) = (/ &
        & 0.15682e-11,0.19141e-11,0.22636e-11,0.26109e-11,0.29589e-11 /)
      kbo(:,29, 2) = (/ &
        & 0.13535e-11,0.16466e-11,0.19296e-11,0.22145e-11,0.25005e-11 /)
      kbo(:,30, 2) = (/ &
        & 0.11709e-11,0.14136e-11,0.16432e-11,0.18792e-11,0.21240e-11 /)
      kbo(:,31, 2) = (/ &
        & 0.10216e-11,0.12142e-11,0.14045e-11,0.15978e-11,0.18001e-11 /)
      kbo(:,32, 2) = (/ &
        & 0.88417e-12,0.10400e-11,0.11973e-11,0.13566e-11,0.15303e-11 /)
      kbo(:,33, 2) = (/ &
        & 0.76210e-12,0.89004e-12,0.10199e-11,0.11509e-11,0.12984e-11 /)
      kbo(:,34, 2) = (/ &
        & 0.64910e-12,0.75460e-12,0.86122e-12,0.97227e-12,0.10908e-11 /)
      kbo(:,35, 2) = (/ &
        & 0.54374e-12,0.63015e-12,0.71745e-12,0.80944e-12,0.90628e-12 /)
      kbo(:,36, 2) = (/ &
        & 0.44718e-12,0.51791e-12,0.58946e-12,0.66527e-12,0.74411e-12 /)
      kbo(:,37, 2) = (/ &
        & 0.35793e-12,0.41591e-12,0.47443e-12,0.53549e-12,0.60041e-12 /)
      kbo(:,38, 2) = (/ &
        & 0.28618e-12,0.33345e-12,0.38124e-12,0.43139e-12,0.48394e-12 /)
      kbo(:,39, 2) = (/ &
        & 0.22858e-12,0.26729e-12,0.30628e-12,0.34554e-12,0.38998e-12 /)
      kbo(:,40, 2) = (/ &
        & 0.17867e-12,0.21032e-12,0.24207e-12,0.27407e-12,0.30925e-12 /)
      kbo(:,41, 2) = (/ &
        & 0.13875e-12,0.16498e-12,0.19072e-12,0.21688e-12,0.24410e-12 /)
      kbo(:,42, 2) = (/ &
        & 0.10714e-12,0.12915e-12,0.14999e-12,0.17156e-12,0.19364e-12 /)
      kbo(:,43, 2) = (/ &
        & 0.81856e-13,0.99592e-13,0.11661e-12,0.13414e-12,0.15145e-12 /)
      kbo(:,44, 2) = (/ &
        & 0.62221e-13,0.75886e-13,0.90106e-13,0.10425e-12,0.11838e-12 /)
      kbo(:,45, 2) = (/ &
        & 0.47139e-13,0.57421e-13,0.69401e-13,0.80830e-13,0.92462e-13 /)
      kbo(:,46, 2) = (/ &
        & 0.35469e-13,0.43603e-13,0.52913e-13,0.62345e-13,0.71769e-13 /)
      kbo(:,47, 2) = (/ &
        & 0.26308e-13,0.32606e-13,0.39610e-13,0.47505e-13,0.55354e-13 /)
      kbo(:,48, 2) = (/ &
        & 0.19388e-13,0.24430e-13,0.29903e-13,0.35902e-13,0.42540e-13 /)
      kbo(:,49, 2) = (/ &
        & 0.14144e-13,0.18180e-13,0.22467e-13,0.26985e-13,0.32471e-13 /)
      kbo(:,50, 2) = (/ &
        & 0.10280e-13,0.13471e-13,0.16900e-13,0.20465e-13,0.24665e-13 /)
      kbo(:,51, 2) = (/ &
        & 0.74898e-14,0.99392e-14,0.12674e-13,0.15571e-13,0.18663e-13 /)
      kbo(:,52, 2) = (/ &
        & 0.54214e-14,0.72917e-14,0.94517e-14,0.11816e-13,0.14256e-13 /)
      kbo(:,53, 2) = (/ &
        & 0.38970e-14,0.53165e-14,0.69989e-14,0.88828e-14,0.10862e-13 /)
      kbo(:,54, 2) = (/ &
        & 0.27972e-14,0.38775e-14,0.51927e-14,0.66775e-14,0.82659e-14 /)
      kbo(:,55, 2) = (/ &
        & 0.19962e-14,0.28257e-14,0.38491e-14,0.50059e-14,0.62864e-14 /)
      kbo(:,56, 2) = (/ &
        & 0.14049e-14,0.20447e-14,0.28389e-14,0.37444e-14,0.47474e-14 /)
      kbo(:,57, 2) = (/ &
        & 0.97467e-15,0.14635e-14,0.20787e-14,0.27878e-14,0.35737e-14 /)
      kbo(:,58, 2) = (/ &
        & 0.67770e-15,0.10398e-14,0.15169e-14,0.20739e-14,0.26951e-14 /)
      kbo(:,59, 2) = (/ &
        & 0.50857e-15,0.79496e-15,0.11749e-14,0.16262e-14,0.21270e-14 /)
      kbo(:,13, 3) = (/ &
        & 0.93671e-10,0.11591e-09,0.13715e-09,0.15779e-09,0.17870e-09 /)
      kbo(:,14, 3) = (/ &
        & 0.78883e-10,0.96971e-10,0.11437e-09,0.13160e-09,0.14863e-09 /)
      kbo(:,15, 3) = (/ &
        & 0.66900e-10,0.81568e-10,0.96052e-10,0.11028e-09,0.12439e-09 /)
      kbo(:,16, 3) = (/ &
        & 0.56737e-10,0.68853e-10,0.80870e-10,0.92769e-10,0.10422e-09 /)
      kbo(:,17, 3) = (/ &
        & 0.48148e-10,0.58209e-10,0.68168e-10,0.78006e-10,0.87308e-10 /)
      kbo(:,18, 3) = (/ &
        & 0.40874e-10,0.49268e-10,0.57591e-10,0.65627e-10,0.73296e-10 /)
      kbo(:,19, 3) = (/ &
        & 0.34619e-10,0.41578e-10,0.48414e-10,0.55049e-10,0.61235e-10 /)
      kbo(:,20, 3) = (/ &
        & 0.29370e-10,0.35034e-10,0.40682e-10,0.46014e-10,0.51115e-10 /)
      kbo(:,21, 3) = (/ &
        & 0.24821e-10,0.29490e-10,0.34141e-10,0.38423e-10,0.42621e-10 /)
      kbo(:,22, 3) = (/ &
        & 0.21204e-10,0.25041e-10,0.28846e-10,0.32305e-10,0.35757e-10 /)
      kbo(:,23, 3) = (/ &
        & 0.18107e-10,0.21244e-10,0.24304e-10,0.27144e-10,0.30005e-10 /)
      kbo(:,24, 3) = (/ &
        & 0.15432e-10,0.18015e-10,0.20470e-10,0.22803e-10,0.25180e-10 /)
      kbo(:,25, 3) = (/ &
        & 0.13155e-10,0.15266e-10,0.17234e-10,0.19170e-10,0.21096e-10 /)
      kbo(:,26, 3) = (/ &
        & 0.11220e-10,0.12944e-10,0.14527e-10,0.16132e-10,0.17690e-10 /)
      kbo(:,27, 3) = (/ &
        & 0.95562e-11,0.10942e-10,0.12242e-10,0.13560e-10,0.14820e-10 /)
      kbo(:,28, 3) = (/ &
        & 0.81359e-11,0.92394e-11,0.10309e-10,0.11386e-10,0.12407e-10 /)
      kbo(:,29, 3) = (/ &
        & 0.69193e-11,0.78077e-11,0.87009e-11,0.95682e-11,0.10386e-10 /)
      kbo(:,30, 3) = (/ &
        & 0.58737e-11,0.65956e-11,0.73381e-11,0.80325e-11,0.87147e-11 /)
      kbo(:,31, 3) = (/ &
        & 0.49782e-11,0.55816e-11,0.61826e-11,0.67463e-11,0.73000e-11 /)
      kbo(:,32, 3) = (/ &
        & 0.42202e-11,0.47232e-11,0.52043e-11,0.56623e-11,0.61016e-11 /)
      kbo(:,33, 3) = (/ &
        & 0.35744e-11,0.39897e-11,0.43757e-11,0.47465e-11,0.50931e-11 /)
      kbo(:,34, 3) = (/ &
        & 0.30127e-11,0.33496e-11,0.36630e-11,0.39738e-11,0.42413e-11 /)
      kbo(:,35, 3) = (/ &
        & 0.25098e-11,0.27837e-11,0.30393e-11,0.32916e-11,0.35093e-11 /)
      kbo(:,36, 3) = (/ &
        & 0.20644e-11,0.22886e-11,0.24982e-11,0.27043e-11,0.28833e-11 /)
      kbo(:,37, 3) = (/ &
        & 0.16684e-11,0.18536e-11,0.20259e-11,0.21979e-11,0.23456e-11 /)
      kbo(:,38, 3) = (/ &
        & 0.13466e-11,0.14996e-11,0.16425e-11,0.17834e-11,0.19065e-11 /)
      kbo(:,39, 3) = (/ &
        & 0.10861e-11,0.12130e-11,0.13309e-11,0.14440e-11,0.15498e-11 /)
      kbo(:,40, 3) = (/ &
        & 0.86498e-12,0.96921e-12,0.10678e-11,0.11601e-11,0.12509e-11 /)
      kbo(:,41, 3) = (/ &
        & 0.68788e-12,0.77191e-12,0.85472e-12,0.93133e-12,0.10084e-11 /)
      kbo(:,42, 3) = (/ &
        & 0.54661e-12,0.61437e-12,0.68360e-12,0.74699e-12,0.81088e-12 /)
      kbo(:,43, 3) = (/ &
        & 0.42920e-12,0.48515e-12,0.54174e-12,0.59564e-12,0.64658e-12 /)
      kbo(:,44, 3) = (/ &
        & 0.33491e-12,0.38198e-12,0.42756e-12,0.47274e-12,0.51490e-12 /)
      kbo(:,45, 3) = (/ &
        & 0.26072e-12,0.29981e-12,0.33699e-12,0.37442e-12,0.40968e-12 /)
      kbo(:,46, 3) = (/ &
        & 0.20167e-12,0.23370e-12,0.26473e-12,0.29535e-12,0.32495e-12 /)
      kbo(:,47, 3) = (/ &
        & 0.15427e-12,0.18070e-12,0.20644e-12,0.23129e-12,0.25612e-12 /)
      kbo(:,48, 3) = (/ &
        & 0.11746e-12,0.13905e-12,0.16032e-12,0.18088e-12,0.20125e-12 /)
      kbo(:,49, 3) = (/ &
        & 0.88976e-13,0.10661e-12,0.12415e-12,0.14128e-12,0.15777e-12 /)
      kbo(:,50, 3) = (/ &
        & 0.67378e-13,0.81791e-13,0.96162e-13,0.11029e-12,0.12384e-12 /)
      kbo(:,51, 3) = (/ &
        & 0.50786e-13,0.62576e-13,0.74348e-13,0.85995e-13,0.97345e-13 /)
      kbo(:,52, 3) = (/ &
        & 0.37951e-13,0.47645e-13,0.57250e-13,0.66805e-13,0.76257e-13 /)
      kbo(:,53, 3) = (/ &
        & 0.28159e-13,0.36102e-13,0.43964e-13,0.51774e-13,0.59583e-13 /)
      kbo(:,54, 3) = (/ &
        & 0.21004e-13,0.27366e-13,0.33776e-13,0.40177e-13,0.46583e-13 /)
      kbo(:,55, 3) = (/ &
        & 0.15637e-13,0.20632e-13,0.25941e-13,0.31184e-13,0.36409e-13 /)
      kbo(:,56, 3) = (/ &
        & 0.11581e-13,0.15522e-13,0.19844e-13,0.24130e-13,0.28399e-13 /)
      kbo(:,57, 3) = (/ &
        & 0.85125e-14,0.11631e-13,0.15093e-13,0.18610e-13,0.22102e-13 /)
      kbo(:,58, 3) = (/ &
        & 0.62435e-14,0.87193e-14,0.11437e-13,0.14347e-13,0.17208e-13 /)
      kbo(:,59, 3) = (/ &
        & 0.48886e-14,0.68810e-14,0.90777e-14,0.11450e-13,0.13800e-13 /)
      kbo(:,13, 4) = (/ &
        & 0.49769e-09,0.57573e-09,0.65456e-09,0.73233e-09,0.81030e-09 /)
      kbo(:,14, 4) = (/ &
        & 0.41687e-09,0.48070e-09,0.54629e-09,0.61156e-09,0.67509e-09 /)
      kbo(:,15, 4) = (/ &
        & 0.35004e-09,0.40346e-09,0.45778e-09,0.51155e-09,0.56442e-09 /)
      kbo(:,16, 4) = (/ &
        & 0.29428e-09,0.33893e-09,0.38370e-09,0.42831e-09,0.47172e-09 /)
      kbo(:,17, 4) = (/ &
        & 0.24736e-09,0.28447e-09,0.32184e-09,0.35882e-09,0.39576e-09 /)
      kbo(:,18, 4) = (/ &
        & 0.20799e-09,0.23913e-09,0.26980e-09,0.30118e-09,0.33239e-09 /)
      kbo(:,19, 4) = (/ &
        & 0.17474e-09,0.20037e-09,0.22650e-09,0.25275e-09,0.27848e-09 /)
      kbo(:,20, 4) = (/ &
        & 0.14678e-09,0.16826e-09,0.19015e-09,0.21182e-09,0.23321e-09 /)
      kbo(:,21, 4) = (/ &
        & 0.12329e-09,0.14137e-09,0.15951e-09,0.17762e-09,0.19539e-09 /)
      kbo(:,22, 4) = (/ &
        & 0.10475e-09,0.11989e-09,0.13488e-09,0.14993e-09,0.16481e-09 /)
      kbo(:,23, 4) = (/ &
        & 0.89090e-10,0.10156e-09,0.11416e-09,0.12661e-09,0.13928e-09 /)
      kbo(:,24, 4) = (/ &
        & 0.75648e-10,0.86094e-10,0.96530e-10,0.10692e-09,0.11716e-09 /)
      kbo(:,25, 4) = (/ &
        & 0.64419e-10,0.73036e-10,0.81659e-10,0.90142e-10,0.98524e-10 /)
      kbo(:,26, 4) = (/ &
        & 0.54857e-10,0.61972e-10,0.69147e-10,0.76125e-10,0.82778e-10 /)
      kbo(:,27, 4) = (/ &
        & 0.46656e-10,0.52591e-10,0.58413e-10,0.64168e-10,0.69451e-10 /)
      kbo(:,28, 4) = (/ &
        & 0.39665e-10,0.44561e-10,0.49317e-10,0.53971e-10,0.58228e-10 /)
      kbo(:,29, 4) = (/ &
        & 0.33755e-10,0.37736e-10,0.41652e-10,0.45382e-10,0.48825e-10 /)
      kbo(:,30, 4) = (/ &
        & 0.28671e-10,0.31949e-10,0.35144e-10,0.38141e-10,0.41003e-10 /)
      kbo(:,31, 4) = (/ &
        & 0.24360e-10,0.27027e-10,0.29632e-10,0.32038e-10,0.34391e-10 /)
      kbo(:,32, 4) = (/ &
        & 0.20671e-10,0.22852e-10,0.24963e-10,0.26903e-10,0.28818e-10 /)
      kbo(:,33, 4) = (/ &
        & 0.17515e-10,0.19306e-10,0.20998e-10,0.22562e-10,0.24113e-10 /)
      kbo(:,34, 4) = (/ &
        & 0.14755e-10,0.16223e-10,0.17588e-10,0.18905e-10,0.20105e-10 /)
      kbo(:,35, 4) = (/ &
        & 0.12305e-10,0.13505e-10,0.14616e-10,0.15703e-10,0.16661e-10 /)
      kbo(:,36, 4) = (/ &
        & 0.10152e-10,0.11132e-10,0.12046e-10,0.12938e-10,0.13718e-10 /)
      kbo(:,37, 4) = (/ &
        & 0.82437e-11,0.90546e-11,0.98101e-11,0.10549e-10,0.11200e-10 /)
      kbo(:,38, 4) = (/ &
        & 0.66891e-11,0.73572e-11,0.79832e-11,0.85923e-11,0.91388e-11 /)
      kbo(:,39, 4) = (/ &
        & 0.54271e-11,0.59789e-11,0.64946e-11,0.69804e-11,0.74536e-11 /)
      kbo(:,40, 4) = (/ &
        & 0.43504e-11,0.48077e-11,0.52359e-11,0.56420e-11,0.60390e-11 /)
      kbo(:,41, 4) = (/ &
        & 0.34805e-11,0.38570e-11,0.42158e-11,0.45532e-11,0.48856e-11 /)
      kbo(:,42, 4) = (/ &
        & 0.27817e-11,0.30896e-11,0.33906e-11,0.36712e-11,0.39504e-11 /)
      kbo(:,43, 4) = (/ &
        & 0.22059e-11,0.24603e-11,0.27112e-11,0.29449e-11,0.31673e-11 /)
      kbo(:,44, 4) = (/ &
        & 0.17407e-11,0.19508e-11,0.21593e-11,0.23549e-11,0.25394e-11 /)
      kbo(:,45, 4) = (/ &
        & 0.13717e-11,0.15444e-11,0.17149e-11,0.18808e-11,0.20349e-11 /)
      kbo(:,46, 4) = (/ &
        & 0.10758e-11,0.12178e-11,0.13582e-11,0.14973e-11,0.16264e-11 /)
      kbo(:,47, 4) = (/ &
        & 0.83623e-12,0.95326e-12,0.10692e-11,0.11850e-11,0.12934e-11 /)
      kbo(:,48, 4) = (/ &
        & 0.64811e-12,0.74426e-12,0.84002e-12,0.93446e-12,0.10270e-11 /)
      kbo(:,49, 4) = (/ &
        & 0.50093e-12,0.57976e-12,0.65824e-12,0.73652e-12,0.81364e-12 /)
      kbo(:,50, 4) = (/ &
        & 0.38740e-12,0.45167e-12,0.51620e-12,0.58084e-12,0.64495e-12 /)
      kbo(:,51, 4) = (/ &
        & 0.29910e-12,0.35149e-12,0.40454e-12,0.45768e-12,0.51010e-12 /)
      kbo(:,52, 4) = (/ &
        & 0.23004e-12,0.27291e-12,0.31637e-12,0.35993e-12,0.40313e-12 /)
      kbo(:,53, 4) = (/ &
        & 0.17654e-12,0.21129e-12,0.24667e-12,0.28251e-12,0.31798e-12 /)
      kbo(:,54, 4) = (/ &
        & 0.13566e-12,0.16388e-12,0.19277e-12,0.22203e-12,0.25140e-12 /)
      kbo(:,55, 4) = (/ &
        & 0.10414e-12,0.12705e-12,0.15062e-12,0.17458e-12,0.19863e-12 /)
      kbo(:,56, 4) = (/ &
        & 0.79695e-13,0.98154e-13,0.11737e-12,0.13696e-12,0.15674e-12 /)
      kbo(:,57, 4) = (/ &
        & 0.60735e-13,0.75667e-13,0.91265e-13,0.10718e-12,0.12346e-12 /)
      kbo(:,58, 4) = (/ &
        & 0.46331e-13,0.58316e-13,0.71018e-13,0.83950e-13,0.97215e-13 /)
      kbo(:,59, 4) = (/ &
        & 0.36896e-13,0.46643e-13,0.57036e-13,0.67613e-13,0.78545e-13 /)
      kbo(:,13, 5) = (/ &
        & 0.26254e-08,0.28627e-08,0.30909e-08,0.33000e-08,0.34892e-08 /)
      kbo(:,14, 5) = (/ &
        & 0.21830e-08,0.23794e-08,0.25635e-08,0.27354e-08,0.28987e-08 /)
      kbo(:,15, 5) = (/ &
        & 0.18164e-08,0.19772e-08,0.21299e-08,0.22819e-08,0.24177e-08 /)
      kbo(:,16, 5) = (/ &
        & 0.15141e-08,0.16500e-08,0.17819e-08,0.19057e-08,0.20139e-08 /)
      kbo(:,17, 5) = (/ &
        & 0.12644e-08,0.13791e-08,0.14854e-08,0.15868e-08,0.16779e-08 /)
      kbo(:,18, 5) = (/ &
        & 0.10569e-08,0.11490e-08,0.12387e-08,0.13249e-08,0.14004e-08 /)
      kbo(:,19, 5) = (/ &
        & 0.88077e-09,0.95771e-09,0.10342e-08,0.11045e-08,0.11654e-08 /)
      kbo(:,20, 5) = (/ &
        & 0.73433e-09,0.79954e-09,0.86343e-09,0.92049e-09,0.97111e-09 /)
      kbo(:,21, 5) = (/ &
        & 0.61317e-09,0.66751e-09,0.72065e-09,0.76613e-09,0.80891e-09 /)
      kbo(:,22, 5) = (/ &
        & 0.51519e-09,0.56066e-09,0.60290e-09,0.64113e-09,0.67719e-09 /)
      kbo(:,23, 5) = (/ &
        & 0.43331e-09,0.47103e-09,0.50532e-09,0.53747e-09,0.56589e-09 /)
      kbo(:,24, 5) = (/ &
        & 0.36478e-09,0.39531e-09,0.42421e-09,0.45023e-09,0.47333e-09 /)
      kbo(:,25, 5) = (/ &
        & 0.30661e-09,0.33249e-09,0.35642e-09,0.37711e-09,0.39645e-09 /)
      kbo(:,26, 5) = (/ &
        & 0.25851e-09,0.28030e-09,0.29893e-09,0.31621e-09,0.33249e-09 /)
      kbo(:,27, 5) = (/ &
        & 0.21849e-09,0.23581e-09,0.25124e-09,0.26548e-09,0.27889e-09 /)
      kbo(:,28, 5) = (/ &
        & 0.18476e-09,0.19866e-09,0.21115e-09,0.22285e-09,0.23419e-09 /)
      kbo(:,29, 5) = (/ &
        & 0.15608e-09,0.16725e-09,0.17764e-09,0.18744e-09,0.19627e-09 /)
      kbo(:,30, 5) = (/ &
        & 0.13180e-09,0.14084e-09,0.14944e-09,0.15734e-09,0.16419e-09 /)
      kbo(:,31, 5) = (/ &
        & 0.11122e-09,0.11878e-09,0.12548e-09,0.13183e-09,0.13690e-09 /)
      kbo(:,32, 5) = (/ &
        & 0.93806e-10,0.99909e-10,0.10547e-09,0.11013e-09,0.11393e-09 /)
      kbo(:,33, 5) = (/ &
        & 0.79057e-10,0.83869e-10,0.88337e-10,0.91833e-10,0.94728e-10 /)
      kbo(:,34, 5) = (/ &
        & 0.66383e-10,0.70216e-10,0.73644e-10,0.76467e-10,0.78589e-10 /)
      kbo(:,35, 5) = (/ &
        & 0.55303e-10,0.58435e-10,0.61122e-10,0.63317e-10,0.64984e-10 /)
      kbo(:,36, 5) = (/ &
        & 0.45788e-10,0.48318e-10,0.50463e-10,0.52237e-10,0.53589e-10 /)
      kbo(:,37, 5) = (/ &
        & 0.37517e-10,0.39593e-10,0.41407e-10,0.42883e-10,0.44012e-10 /)
      kbo(:,38, 5) = (/ &
        & 0.30717e-10,0.32436e-10,0.33950e-10,0.35197e-10,0.36146e-10 /)
      kbo(:,39, 5) = (/ &
        & 0.25129e-10,0.26560e-10,0.27827e-10,0.28835e-10,0.29676e-10 /)
      kbo(:,40, 5) = (/ &
        & 0.20420e-10,0.21620e-10,0.22699e-10,0.23564e-10,0.24290e-10 /)
      kbo(:,41, 5) = (/ &
        & 0.16561e-10,0.17583e-10,0.18496e-10,0.19245e-10,0.19868e-10 /)
      kbo(:,42, 5) = (/ &
        & 0.13418e-10,0.14291e-10,0.15059e-10,0.15706e-10,0.16243e-10 /)
      kbo(:,43, 5) = (/ &
        & 0.10810e-10,0.11562e-10,0.12210e-10,0.12774e-10,0.13223e-10 /)
      kbo(:,44, 5) = (/ &
        & 0.86843e-11,0.93265e-11,0.98789e-11,0.10369e-10,0.10770e-10 /)
      kbo(:,45, 5) = (/ &
        & 0.69593e-11,0.75111e-11,0.79891e-11,0.84084e-11,0.87638e-11 /)
      kbo(:,46, 5) = (/ &
        & 0.55576e-11,0.60308e-11,0.64400e-11,0.68030e-11,0.71149e-11 /)
      kbo(:,47, 5) = (/ &
        & 0.44097e-11,0.48155e-11,0.51709e-11,0.54794e-11,0.57570e-11 /)
      kbo(:,48, 5) = (/ &
        & 0.34877e-11,0.38384e-11,0.41433e-11,0.44120e-11,0.46521e-11 /)
      kbo(:,49, 5) = (/ &
        & 0.27512e-11,0.30491e-11,0.33123e-11,0.35456e-11,0.37509e-11 /)
      kbo(:,50, 5) = (/ &
        & 0.21734e-11,0.24185e-11,0.26481e-11,0.28485e-11,0.30236e-11 /)
      kbo(:,51, 5) = (/ &
        & 0.17150e-11,0.19185e-11,0.21147e-11,0.22857e-11,0.24371e-11 /)
      kbo(:,52, 5) = (/ &
        & 0.13499e-11,0.15196e-11,0.16853e-11,0.18315e-11,0.19613e-11 /)
      kbo(:,53, 5) = (/ &
        & 0.10590e-11,0.11989e-11,0.13374e-11,0.14641e-11,0.15756e-11 /)
      kbo(:,54, 5) = (/ &
        & 0.83182e-12,0.94832e-12,0.10625e-11,0.11713e-11,0.12669e-11 /)
      kbo(:,55, 5) = (/ &
        & 0.65257e-12,0.74992e-12,0.84445e-12,0.93664e-12,0.10175e-11 /)
      kbo(:,56, 5) = (/ &
        & 0.51109e-12,0.59162e-12,0.67030e-12,0.74706e-12,0.81634e-12 /)
      kbo(:,57, 5) = (/ &
        & 0.39868e-12,0.46532e-12,0.53042e-12,0.59449e-12,0.65374e-12 /)
      kbo(:,58, 5) = (/ &
        & 0.31062e-12,0.36629e-12,0.42009e-12,0.47298e-12,0.52357e-12 /)
      kbo(:,59, 5) = (/ &
        & 0.24996e-12,0.29597e-12,0.34052e-12,0.38403e-12,0.42584e-12 /)
      kbo(:,13, 6) = (/ &
        & 0.10275e-07,0.10425e-07,0.10505e-07,0.10571e-07,0.10619e-07 /)
      kbo(:,14, 6) = (/ &
        & 0.84309e-08,0.85528e-08,0.86280e-08,0.86935e-08,0.87236e-08 /)
      kbo(:,15, 6) = (/ &
        & 0.69259e-08,0.70218e-08,0.71031e-08,0.71419e-08,0.71430e-08 /)
      kbo(:,16, 6) = (/ &
        & 0.56933e-08,0.57765e-08,0.58298e-08,0.58527e-08,0.58704e-08 /)
      kbo(:,17, 6) = (/ &
        & 0.46880e-08,0.47555e-08,0.47985e-08,0.48270e-08,0.48471e-08 /)
      kbo(:,18, 6) = (/ &
        & 0.38628e-08,0.39183e-08,0.39591e-08,0.39923e-08,0.40106e-08 /)
      kbo(:,19, 6) = (/ &
        & 0.31833e-08,0.32370e-08,0.32750e-08,0.32992e-08,0.33139e-08 /)
      kbo(:,20, 6) = (/ &
        & 0.26315e-08,0.26765e-08,0.27033e-08,0.27208e-08,0.27412e-08 /)
      kbo(:,21, 6) = (/ &
        & 0.21768e-08,0.22074e-08,0.22281e-08,0.22492e-08,0.22648e-08 /)
      kbo(:,22, 6) = (/ &
        & 0.17970e-08,0.18204e-08,0.18421e-08,0.18603e-08,0.18697e-08 /)
      kbo(:,23, 6) = (/ &
        & 0.14828e-08,0.15043e-08,0.15235e-08,0.15373e-08,0.15469e-08 /)
      kbo(:,24, 6) = (/ &
        & 0.12265e-08,0.12457e-08,0.12602e-08,0.12704e-08,0.12795e-08 /)
      kbo(:,25, 6) = (/ &
        & 0.10153e-08,0.10303e-08,0.10406e-08,0.10511e-08,0.10591e-08 /)
      kbo(:,26, 6) = (/ &
        & 0.84067e-09,0.85220e-09,0.86139e-09,0.87145e-09,0.87606e-09 /)
      kbo(:,27, 6) = (/ &
        & 0.69556e-09,0.70441e-09,0.71396e-09,0.72098e-09,0.72486e-09 /)
      kbo(:,28, 6) = (/ &
        & 0.57505e-09,0.58326e-09,0.59186e-09,0.59662e-09,0.60056e-09 /)
      kbo(:,29, 6) = (/ &
        & 0.47621e-09,0.48459e-09,0.49079e-09,0.49432e-09,0.49717e-09 /)
      kbo(:,30, 6) = (/ &
        & 0.39513e-09,0.40232e-09,0.40640e-09,0.40995e-09,0.41263e-09 /)
      kbo(:,31, 6) = (/ &
        & 0.32890e-09,0.33390e-09,0.33797e-09,0.34036e-09,0.34440e-09 /)
      kbo(:,32, 6) = (/ &
        & 0.27372e-09,0.27757e-09,0.28057e-09,0.28360e-09,0.28668e-09 /)
      kbo(:,33, 6) = (/ &
        & 0.22771e-09,0.23074e-09,0.23349e-09,0.23595e-09,0.23797e-09 /)
      kbo(:,34, 6) = (/ &
        & 0.18899e-09,0.19179e-09,0.19391e-09,0.19591e-09,0.19720e-09 /)
      kbo(:,35, 6) = (/ &
        & 0.15677e-09,0.15897e-09,0.16075e-09,0.16219e-09,0.16318e-09 /)
      kbo(:,36, 6) = (/ &
        & 0.12972e-09,0.13147e-09,0.13291e-09,0.13412e-09,0.13484e-09 /)
      kbo(:,37, 6) = (/ &
        & 0.10704e-09,0.10855e-09,0.10970e-09,0.11065e-09,0.11129e-09 /)
      kbo(:,38, 6) = (/ &
        & 0.88219e-10,0.89571e-10,0.90489e-10,0.91263e-10,0.91821e-10 /)
      kbo(:,39, 6) = (/ &
        & 0.72709e-10,0.73884e-10,0.74615e-10,0.75144e-10,0.75719e-10 /)
      kbo(:,40, 6) = (/ &
        & 0.59779e-10,0.60793e-10,0.61424e-10,0.61873e-10,0.62379e-10 /)
      kbo(:,41, 6) = (/ &
        & 0.49104e-10,0.49999e-10,0.50541e-10,0.50924e-10,0.51369e-10 /)
      kbo(:,42, 6) = (/ &
        & 0.40324e-10,0.41079e-10,0.41584e-10,0.41914e-10,0.42279e-10 /)
      kbo(:,43, 6) = (/ &
        & 0.33050e-10,0.33695e-10,0.34173e-10,0.34462e-10,0.34716e-10 /)
      kbo(:,44, 6) = (/ &
        & 0.27054e-10,0.27604e-10,0.28056e-10,0.28313e-10,0.28542e-10 /)
      kbo(:,45, 6) = (/ &
        & 0.22112e-10,0.22613e-10,0.23018e-10,0.23255e-10,0.23441e-10 /)
      kbo(:,46, 6) = (/ &
        & 0.18060e-10,0.18501e-10,0.18867e-10,0.19082e-10,0.19252e-10 /)
      kbo(:,47, 6) = (/ &
        & 0.14722e-10,0.15111e-10,0.15432e-10,0.15658e-10,0.15802e-10 /)
      kbo(:,48, 6) = (/ &
        & 0.11985e-10,0.12318e-10,0.12624e-10,0.12826e-10,0.12965e-10 /)
      kbo(:,49, 6) = (/ &
        & 0.97421e-11,0.10040e-10,0.10306e-10,0.10499e-10,0.10630e-10 /)
      kbo(:,50, 6) = (/ &
        & 0.79055e-11,0.81823e-11,0.84121e-11,0.85902e-11,0.87163e-11 /)
      kbo(:,51, 6) = (/ &
        & 0.64164e-11,0.66612e-11,0.68621e-11,0.70240e-11,0.71428e-11 /)
      kbo(:,52, 6) = (/ &
        & 0.51935e-11,0.54159e-11,0.55861e-11,0.57406e-11,0.58465e-11 /)
      kbo(:,53, 6) = (/ &
        & 0.42017e-11,0.43985e-11,0.45525e-11,0.46862e-11,0.47817e-11 /)
      kbo(:,54, 6) = (/ &
        & 0.33953e-11,0.35701e-11,0.37080e-11,0.38204e-11,0.39118e-11 /)
      kbo(:,55, 6) = (/ &
        & 0.27420e-11,0.28948e-11,0.30166e-11,0.31148e-11,0.31981e-11 /)
      kbo(:,56, 6) = (/ &
        & 0.22097e-11,0.23440e-11,0.24518e-11,0.25378e-11,0.26122e-11 /)
      kbo(:,57, 6) = (/ &
        & 0.17765e-11,0.18968e-11,0.19913e-11,0.20659e-11,0.21319e-11 /)
      kbo(:,58, 6) = (/ &
        & 0.14264e-11,0.15324e-11,0.16166e-11,0.16816e-11,0.17374e-11 /)
      kbo(:,59, 6) = (/ &
        & 0.11621e-11,0.12515e-11,0.13230e-11,0.13773e-11,0.14240e-11 /)
      kbo(:,13, 7) = (/ &
        & 0.28079e-07,0.28035e-07,0.27949e-07,0.27835e-07,0.27661e-07 /)
      kbo(:,14, 7) = (/ &
        & 0.23041e-07,0.22982e-07,0.22914e-07,0.22814e-07,0.22653e-07 /)
      kbo(:,15, 7) = (/ &
        & 0.18899e-07,0.18860e-07,0.18790e-07,0.18675e-07,0.18596e-07 /)
      kbo(:,16, 7) = (/ &
        & 0.15489e-07,0.15457e-07,0.15389e-07,0.15337e-07,0.15329e-07 /)
      kbo(:,17, 7) = (/ &
        & 0.12699e-07,0.12665e-07,0.12634e-07,0.12640e-07,0.12612e-07 /)
      kbo(:,18, 7) = (/ &
        & 0.10409e-07,0.10397e-07,0.10401e-07,0.10391e-07,0.10368e-07 /)
      kbo(:,19, 7) = (/ &
        & 0.85482e-08,0.85403e-08,0.85408e-08,0.85379e-08,0.85325e-08 /)
      kbo(:,20, 7) = (/ &
        & 0.70183e-08,0.70212e-08,0.70225e-08,0.70232e-08,0.70243e-08 /)
      kbo(:,21, 7) = (/ &
        & 0.57704e-08,0.57836e-08,0.57919e-08,0.57990e-08,0.58135e-08 /)
      kbo(:,22, 7) = (/ &
        & 0.47522e-08,0.47673e-08,0.47834e-08,0.48084e-08,0.48239e-08 /)
      kbo(:,23, 7) = (/ &
        & 0.39186e-08,0.39439e-08,0.39679e-08,0.39863e-08,0.40063e-08 /)
      kbo(:,24, 7) = (/ &
        & 0.32407e-08,0.32645e-08,0.32840e-08,0.33039e-08,0.33353e-08 /)
      kbo(:,25, 7) = (/ &
        & 0.26846e-08,0.27012e-08,0.27199e-08,0.27477e-08,0.27761e-08 /)
      kbo(:,26, 7) = (/ &
        & 0.22196e-08,0.22367e-08,0.22646e-08,0.22896e-08,0.23141e-08 /)
      kbo(:,27, 7) = (/ &
        & 0.18370e-08,0.18616e-08,0.18864e-08,0.19087e-08,0.19319e-08 /)
      kbo(:,28, 7) = (/ &
        & 0.15259e-08,0.15495e-08,0.15695e-08,0.15912e-08,0.16152e-08 /)
      kbo(:,29, 7) = (/ &
        & 0.12717e-08,0.12907e-08,0.13087e-08,0.13304e-08,0.13523e-08 /)
      kbo(:,30, 7) = (/ &
        & 0.10599e-08,0.10765e-08,0.10939e-08,0.11139e-08,0.11374e-08 /)
      kbo(:,31, 7) = (/ &
        & 0.88411e-09,0.89833e-09,0.91628e-09,0.93662e-09,0.95540e-09 /)
      kbo(:,32, 7) = (/ &
        & 0.73723e-09,0.75198e-09,0.77042e-09,0.78608e-09,0.80601e-09 /)
      kbo(:,33, 7) = (/ &
        & 0.61511e-09,0.63161e-09,0.64646e-09,0.66232e-09,0.68095e-09 /)
      kbo(:,34, 7) = (/ &
        & 0.51621e-09,0.53001e-09,0.54332e-09,0.55986e-09,0.57326e-09 /)
      kbo(:,35, 7) = (/ &
        & 0.43217e-09,0.44439e-09,0.45713e-09,0.47103e-09,0.48242e-09 /)
      kbo(:,36, 7) = (/ &
        & 0.36090e-09,0.37166e-09,0.38311e-09,0.39461e-09,0.40545e-09 /)
      kbo(:,37, 7) = (/ &
        & 0.29990e-09,0.30916e-09,0.31937e-09,0.32943e-09,0.34038e-09 /)
      kbo(:,38, 7) = (/ &
        & 0.24927e-09,0.25737e-09,0.26638e-09,0.27543e-09,0.28596e-09 /)
      kbo(:,39, 7) = (/ &
        & 0.20718e-09,0.21434e-09,0.22203e-09,0.23026e-09,0.23966e-09 /)
      kbo(:,40, 7) = (/ &
        & 0.17122e-09,0.17745e-09,0.18425e-09,0.19138e-09,0.19937e-09 /)
      kbo(:,41, 7) = (/ &
        & 0.14145e-09,0.14673e-09,0.15273e-09,0.15885e-09,0.16544e-09 /)
      kbo(:,42, 7) = (/ &
        & 0.11673e-09,0.12130e-09,0.12626e-09,0.13156e-09,0.13718e-09 /)
      kbo(:,43, 7) = (/ &
        & 0.95979e-10,0.99773e-10,0.10407e-09,0.10848e-09,0.11289e-09 /)
      kbo(:,44, 7) = (/ &
        & 0.78684e-10,0.81894e-10,0.85476e-10,0.89249e-10,0.92971e-10 /)
      kbo(:,45, 7) = (/ &
        & 0.64482e-10,0.67161e-10,0.70163e-10,0.73315e-10,0.76486e-10 /)
      kbo(:,46, 7) = (/ &
        & 0.52720e-10,0.54998e-10,0.57509e-10,0.60128e-10,0.62787e-10 /)
      kbo(:,47, 7) = (/ &
        & 0.42902e-10,0.44887e-10,0.46948e-10,0.49098e-10,0.51392e-10 /)
      kbo(:,48, 7) = (/ &
        & 0.34914e-10,0.36612e-10,0.38268e-10,0.40114e-10,0.41998e-10 /)
      kbo(:,49, 7) = (/ &
        & 0.28363e-10,0.29830e-10,0.31160e-10,0.32712e-10,0.34278e-10 /)
      kbo(:,50, 7) = (/ &
        & 0.23044e-10,0.24298e-10,0.25411e-10,0.26663e-10,0.27956e-10 /)
      kbo(:,51, 7) = (/ &
        & 0.18719e-10,0.19762e-10,0.20717e-10,0.21748e-10,0.22834e-10 /)
      kbo(:,52, 7) = (/ &
        & 0.15214e-10,0.16060e-10,0.16882e-10,0.17722e-10,0.18609e-10 /)
      kbo(:,53, 7) = (/ &
        & 0.12339e-10,0.13039e-10,0.13738e-10,0.14413e-10,0.15144e-10 /)
      kbo(:,54, 7) = (/ &
        & 0.10028e-10,0.10589e-10,0.11176e-10,0.11743e-10,0.12340e-10 /)
      kbo(:,55, 7) = (/ &
        & 0.81332e-11,0.85988e-11,0.90904e-11,0.95545e-11,0.10057e-10 /)
      kbo(:,56, 7) = (/ &
        & 0.66047e-11,0.69777e-11,0.73796e-11,0.77755e-11,0.81880e-11 /)
      kbo(:,57, 7) = (/ &
        & 0.53536e-11,0.56554e-11,0.59940e-11,0.63232e-11,0.66612e-11 /)
      kbo(:,58, 7) = (/ &
        & 0.43329e-11,0.45903e-11,0.48661e-11,0.51412e-11,0.54200e-11 /)
      kbo(:,59, 7) = (/ &
        & 0.35522e-11,0.37646e-11,0.39940e-11,0.42211e-11,0.44525e-11 /)
      kbo(:,13, 8) = (/ &
        & 0.11230e-06,0.11409e-06,0.11566e-06,0.11672e-06,0.11734e-06 /)
      kbo(:,14, 8) = (/ &
        & 0.92428e-07,0.93878e-07,0.95014e-07,0.95711e-07,0.96110e-07 /)
      kbo(:,15, 8) = (/ &
        & 0.76021e-07,0.77148e-07,0.77913e-07,0.78505e-07,0.78756e-07 /)
      kbo(:,16, 8) = (/ &
        & 0.62512e-07,0.63402e-07,0.63979e-07,0.64292e-07,0.64352e-07 /)
      kbo(:,17, 8) = (/ &
        & 0.51480e-07,0.52099e-07,0.52465e-07,0.52634e-07,0.52753e-07 /)
      kbo(:,18, 8) = (/ &
        & 0.42336e-07,0.42773e-07,0.43015e-07,0.43145e-07,0.43290e-07 /)
      kbo(:,19, 8) = (/ &
        & 0.34820e-07,0.35138e-07,0.35326e-07,0.35465e-07,0.35546e-07 /)
      kbo(:,20, 8) = (/ &
        & 0.28634e-07,0.28882e-07,0.29099e-07,0.29190e-07,0.29248e-07 /)
      kbo(:,21, 8) = (/ &
        & 0.23527e-07,0.23767e-07,0.23879e-07,0.24001e-07,0.24136e-07 /)
      kbo(:,22, 8) = (/ &
        & 0.19380e-07,0.19526e-07,0.19668e-07,0.19823e-07,0.20000e-07 /)
      kbo(:,23, 8) = (/ &
        & 0.15955e-07,0.16103e-07,0.16252e-07,0.16425e-07,0.16561e-07 /)
      kbo(:,24, 8) = (/ &
        & 0.13163e-07,0.13294e-07,0.13466e-07,0.13609e-07,0.13701e-07 /)
      kbo(:,25, 8) = (/ &
        & 0.10863e-07,0.11029e-07,0.11155e-07,0.11256e-07,0.11368e-07 /)
      kbo(:,26, 8) = (/ &
        & 0.90043e-08,0.91173e-08,0.92226e-08,0.93261e-08,0.94322e-08 /)
      kbo(:,27, 8) = (/ &
        & 0.74604e-08,0.75548e-08,0.76410e-08,0.77390e-08,0.78488e-08 /)
      kbo(:,28, 8) = (/ &
        & 0.61944e-08,0.62754e-08,0.63658e-08,0.64728e-08,0.65523e-08 /)
      kbo(:,29, 8) = (/ &
        & 0.51553e-08,0.52390e-08,0.53444e-08,0.54244e-08,0.55104e-08 /)
      kbo(:,30, 8) = (/ &
        & 0.43022e-08,0.44056e-08,0.44906e-08,0.45753e-08,0.46815e-08 /)
      kbo(:,31, 8) = (/ &
        & 0.36260e-08,0.37147e-08,0.37854e-08,0.38857e-08,0.39725e-08 /)
      kbo(:,32, 8) = (/ &
        & 0.30574e-08,0.31222e-08,0.32149e-08,0.32959e-08,0.33679e-08 /)
      kbo(:,33, 8) = (/ &
        & 0.25690e-08,0.26475e-08,0.27306e-08,0.27942e-08,0.28607e-08 /)
      kbo(:,34, 8) = (/ &
        & 0.21739e-08,0.22522e-08,0.23131e-08,0.23724e-08,0.24398e-08 /)
      kbo(:,35, 8) = (/ &
        & 0.18403e-08,0.19033e-08,0.19580e-08,0.20191e-08,0.20792e-08 /)
      kbo(:,36, 8) = (/ &
        & 0.15538e-08,0.16068e-08,0.16535e-08,0.17159e-08,0.17681e-08 /)
      kbo(:,37, 8) = (/ &
        & 0.13002e-08,0.13483e-08,0.13923e-08,0.14493e-08,0.14927e-08 /)
      kbo(:,38, 8) = (/ &
        & 0.10893e-08,0.11319e-08,0.11765e-08,0.12253e-08,0.12624e-08 /)
      kbo(:,39, 8) = (/ &
        & 0.91348e-09,0.95067e-09,0.99134e-09,0.10293e-08,0.10668e-08 /)
      kbo(:,40, 8) = (/ &
        & 0.76170e-09,0.79404e-09,0.82953e-09,0.86548e-09,0.90041e-09 /)
      kbo(:,41, 8) = (/ &
        & 0.63292e-09,0.66170e-09,0.69363e-09,0.72573e-09,0.75710e-09 /)
      kbo(:,42, 8) = (/ &
        & 0.52609e-09,0.55120e-09,0.57974e-09,0.60803e-09,0.63636e-09 /)
      kbo(:,43, 8) = (/ &
        & 0.43444e-09,0.45674e-09,0.48206e-09,0.50747e-09,0.53053e-09 /)
      kbo(:,44, 8) = (/ &
        & 0.35755e-09,0.37758e-09,0.39965e-09,0.42169e-09,0.44276e-09 /)
      kbo(:,45, 8) = (/ &
        & 0.29410e-09,0.31126e-09,0.33079e-09,0.35014e-09,0.36874e-09 /)
      kbo(:,46, 8) = (/ &
        & 0.24113e-09,0.25605e-09,0.27273e-09,0.28962e-09,0.30646e-09 /)
      kbo(:,47, 8) = (/ &
        & 0.19675e-09,0.20937e-09,0.22390e-09,0.23865e-09,0.25330e-09 /)
      kbo(:,48, 8) = (/ &
        & 0.16029e-09,0.17125e-09,0.18339e-09,0.19620e-09,0.20918e-09 /)
      kbo(:,49, 8) = (/ &
        & 0.13018e-09,0.13961e-09,0.15020e-09,0.16108e-09,0.17231e-09 /)
      kbo(:,50, 8) = (/ &
        & 0.10559e-09,0.11394e-09,0.12271e-09,0.13208e-09,0.14200e-09 /)
      kbo(:,51, 8) = (/ &
        & 0.85569e-10,0.92775e-10,0.10011e-09,0.10818e-09,0.11665e-09 /)
      kbo(:,52, 8) = (/ &
        & 0.69342e-10,0.75341e-10,0.81596e-10,0.88527e-10,0.95876e-10 /)
      kbo(:,53, 8) = (/ &
        & 0.56003e-10,0.61203e-10,0.66389e-10,0.72376e-10,0.78642e-10 /)
      kbo(:,54, 8) = (/ &
        & 0.45380e-10,0.49599e-10,0.54006e-10,0.59069e-10,0.64380e-10 /)
      kbo(:,55, 8) = (/ &
        & 0.36637e-10,0.40078e-10,0.43990e-10,0.48279e-10,0.52815e-10 /)
      kbo(:,56, 8) = (/ &
        & 0.29596e-10,0.32455e-10,0.35694e-10,0.39315e-10,0.43169e-10 /)
      kbo(:,57, 8) = (/ &
        & 0.23911e-10,0.26268e-10,0.28916e-10,0.31929e-10,0.35182e-10 /)
      kbo(:,58, 8) = (/ &
        & 0.19299e-10,0.21198e-10,0.23407e-10,0.25936e-10,0.28689e-10 /)
      kbo(:,59, 8) = (/ &
        & 0.15839e-10,0.17448e-10,0.19334e-10,0.21469e-10,0.23829e-10 /)
      kbo(:,13, 9) = (/ &
        & 0.96471e-06,0.97408e-06,0.98436e-06,0.99439e-06,0.10050e-05 /)
      kbo(:,14, 9) = (/ &
        & 0.80904e-06,0.81838e-06,0.82742e-06,0.83703e-06,0.84742e-06 /)
      kbo(:,15, 9) = (/ &
        & 0.67733e-06,0.68563e-06,0.69403e-06,0.70345e-06,0.71287e-06 /)
      kbo(:,16, 9) = (/ &
        & 0.56582e-06,0.57313e-06,0.58159e-06,0.59012e-06,0.59880e-06 /)
      kbo(:,17, 9) = (/ &
        & 0.47164e-06,0.47892e-06,0.48671e-06,0.49436e-06,0.50258e-06 /)
      kbo(:,18, 9) = (/ &
        & 0.39308e-06,0.39992e-06,0.40685e-06,0.41415e-06,0.42143e-06 /)
      kbo(:,19, 9) = (/ &
        & 0.32764e-06,0.33370e-06,0.34000e-06,0.34660e-06,0.35294e-06 /)
      kbo(:,20, 9) = (/ &
        & 0.27304e-06,0.27855e-06,0.28433e-06,0.29002e-06,0.29550e-06 /)
      kbo(:,21, 9) = (/ &
        & 0.22762e-06,0.23263e-06,0.23776e-06,0.24264e-06,0.24751e-06 /)
      kbo(:,22, 9) = (/ &
        & 0.19016e-06,0.19467e-06,0.19902e-06,0.20331e-06,0.20743e-06 /)
      kbo(:,23, 9) = (/ &
        & 0.15902e-06,0.16285e-06,0.16664e-06,0.17032e-06,0.17381e-06 /)
      kbo(:,24, 9) = (/ &
        & 0.13300e-06,0.13639e-06,0.13965e-06,0.14271e-06,0.14575e-06 /)
      kbo(:,25, 9) = (/ &
        & 0.11136e-06,0.11428e-06,0.11705e-06,0.11966e-06,0.12234e-06 /)
      kbo(:,26, 9) = (/ &
        & 0.93355e-07,0.95870e-07,0.98179e-07,0.10046e-06,0.10295e-06 /)
      kbo(:,27, 9) = (/ &
        & 0.78546e-07,0.80656e-07,0.82694e-07,0.84793e-07,0.87129e-07 /)
      kbo(:,28, 9) = (/ &
        & 0.65991e-07,0.67786e-07,0.69602e-07,0.71624e-07,0.74063e-07 /)
      kbo(:,29, 9) = (/ &
        & 0.55459e-07,0.56995e-07,0.58695e-07,0.60741e-07,0.63281e-07 /)
      kbo(:,30, 9) = (/ &
        & 0.46750e-07,0.48054e-07,0.49703e-07,0.51793e-07,0.54403e-07 /)
      kbo(:,31, 9) = (/ &
        & 0.39452e-07,0.40727e-07,0.42319e-07,0.44486e-07,0.47323e-07 /)
      kbo(:,32, 9) = (/ &
        & 0.33473e-07,0.34884e-07,0.36502e-07,0.38781e-07,0.41735e-07 /)
      kbo(:,33, 9) = (/ &
        & 0.28581e-07,0.30008e-07,0.31748e-07,0.34217e-07,0.37511e-07 /)
      kbo(:,34, 9) = (/ &
        & 0.24450e-07,0.25951e-07,0.27867e-07,0.30565e-07,0.34125e-07 /)
      kbo(:,35, 9) = (/ &
        & 0.20942e-07,0.22554e-07,0.24574e-07,0.27409e-07,0.31159e-07 /)
      kbo(:,36, 9) = (/ &
        & 0.18081e-07,0.19648e-07,0.21657e-07,0.24573e-07,0.28429e-07 /)
      kbo(:,37, 9) = (/ &
        & 0.15436e-07,0.16978e-07,0.19037e-07,0.21710e-07,0.25509e-07 /)
      kbo(:,38, 9) = (/ &
        & 0.13187e-07,0.14690e-07,0.16738e-07,0.19257e-07,0.22992e-07 /)
      kbo(:,39, 9) = (/ &
        & 0.11282e-07,0.12751e-07,0.14794e-07,0.17292e-07,0.20852e-07 /)
      kbo(:,40, 9) = (/ &
        & 0.96293e-08,0.10973e-07,0.12917e-07,0.15272e-07,0.18582e-07 /)
      kbo(:,41, 9) = (/ &
        & 0.81770e-08,0.94352e-08,0.11220e-07,0.13516e-07,0.16546e-07 /)
      kbo(:,42, 9) = (/ &
        & 0.69323e-08,0.80750e-08,0.97479e-08,0.11964e-07,0.14736e-07 /)
      kbo(:,43, 9) = (/ &
        & 0.58312e-08,0.68571e-08,0.83595e-08,0.10414e-07,0.12928e-07 /)
      kbo(:,44, 9) = (/ &
        & 0.48754e-08,0.58128e-08,0.71504e-08,0.90270e-08,0.11362e-07 /)
      kbo(:,45, 9) = (/ &
        & 0.40522e-08,0.48841e-08,0.60765e-08,0.77697e-08,0.99439e-08 /)
      kbo(:,46, 9) = (/ &
        & 0.33429e-08,0.40820e-08,0.51038e-08,0.66237e-08,0.86427e-08 /)
      kbo(:,47, 9) = (/ &
        & 0.27297e-08,0.33571e-08,0.42806e-08,0.55863e-08,0.73605e-08 /)
      kbo(:,48, 9) = (/ &
        & 0.22143e-08,0.27445e-08,0.35414e-08,0.46711e-08,0.62204e-08 /)
      kbo(:,49, 9) = (/ &
        & 0.18030e-08,0.22208e-08,0.28995e-08,0.38639e-08,0.52216e-08 /)
      kbo(:,50, 9) = (/ &
        & 0.14670e-08,0.18085e-08,0.23853e-08,0.32522e-08,0.44284e-08 /)
      kbo(:,51, 9) = (/ &
        & 0.11873e-08,0.14637e-08,0.19592e-08,0.27073e-08,0.37306e-08 /)
      kbo(:,52, 9) = (/ &
        & 0.96876e-09,0.11883e-08,0.15881e-08,0.22316e-08,0.31252e-08 /)
      kbo(:,53, 9) = (/ &
        & 0.79526e-09,0.95443e-09,0.12843e-08,0.18180e-08,0.25992e-08 /)
      kbo(:,54, 9) = (/ &
        & 0.65045e-09,0.77197e-09,0.10500e-08,0.14963e-08,0.21953e-08 /)
      kbo(:,55, 9) = (/ &
        & 0.53001e-09,0.62144e-09,0.84441e-09,0.12265e-08,0.18415e-08 /)
      kbo(:,56, 9) = (/ &
        & 0.43274e-09,0.50433e-09,0.67633e-09,0.10051e-08,0.15294e-08 /)
      kbo(:,57, 9) = (/ &
        & 0.35151e-09,0.40652e-09,0.53819e-09,0.80840e-09,0.12530e-08 /)
      kbo(:,58, 9) = (/ &
        & 0.28511e-09,0.33047e-09,0.42809e-09,0.65584e-09,0.10383e-08 /)
      kbo(:,59, 9) = (/ &
        & 0.23557e-09,0.27695e-09,0.36588e-09,0.57468e-09,0.92796e-09 /)
      kbo(:,13,10) = (/ &
        & 0.49379e-05,0.50469e-05,0.51595e-05,0.52778e-05,0.54099e-05 /)
      kbo(:,14,10) = (/ &
        & 0.42812e-05,0.43888e-05,0.45022e-05,0.46302e-05,0.47669e-05 /)
      kbo(:,15,10) = (/ &
        & 0.36929e-05,0.37965e-05,0.39164e-05,0.40454e-05,0.41827e-05 /)
      kbo(:,16,10) = (/ &
        & 0.31721e-05,0.32791e-05,0.33975e-05,0.35246e-05,0.36634e-05 /)
      kbo(:,17,10) = (/ &
        & 0.27212e-05,0.28264e-05,0.29414e-05,0.30666e-05,0.32085e-05 /)
      kbo(:,18,10) = (/ &
        & 0.23339e-05,0.24330e-05,0.25438e-05,0.26711e-05,0.28184e-05 /)
      kbo(:,19,10) = (/ &
        & 0.19987e-05,0.20932e-05,0.22036e-05,0.23332e-05,0.24834e-05 /)
      kbo(:,20,10) = (/ &
        & 0.17132e-05,0.18061e-05,0.19176e-05,0.20491e-05,0.21989e-05 /)
      kbo(:,21,10) = (/ &
        & 0.14710e-05,0.15640e-05,0.16759e-05,0.18061e-05,0.19600e-05 /)
      kbo(:,22,10) = (/ &
        & 0.12737e-05,0.13668e-05,0.14788e-05,0.16132e-05,0.17763e-05 /)
      kbo(:,23,10) = (/ &
        & 0.11088e-05,0.12015e-05,0.13166e-05,0.14583e-05,0.16304e-05 /)
      kbo(:,24,10) = (/ &
        & 0.97145e-06,0.10662e-05,0.11867e-05,0.13370e-05,0.15170e-05 /)
      kbo(:,25,10) = (/ &
        & 0.85857e-06,0.95791e-06,0.10855e-05,0.12438e-05,0.14327e-05 /)
      kbo(:,26,10) = (/ &
        & 0.76914e-06,0.87488e-06,0.10107e-05,0.11782e-05,0.13762e-05 /)
      kbo(:,27,10) = (/ &
        & 0.69709e-06,0.81000e-06,0.95427e-06,0.11311e-05,0.13395e-05 /)
      kbo(:,28,10) = (/ &
        & 0.64352e-06,0.76453e-06,0.91846e-06,0.11047e-05,0.13225e-05 /)
      kbo(:,29,10) = (/ &
        & 0.60601e-06,0.73668e-06,0.90033e-06,0.10967e-05,0.13241e-05 /)
      kbo(:,30,10) = (/ &
        & 0.58144e-06,0.72277e-06,0.89681e-06,0.11031e-05,0.13400e-05 /)
      kbo(:,31,10) = (/ &
        & 0.57013e-06,0.72161e-06,0.90691e-06,0.11230e-05,0.13684e-05 /)
      kbo(:,32,10) = (/ &
        & 0.57021e-06,0.73098e-06,0.92629e-06,0.11521e-05,0.14071e-05 /)
      kbo(:,33,10) = (/ &
        & 0.58025e-06,0.75106e-06,0.95601e-06,0.11909e-05,0.14530e-05 /)
      kbo(:,34,10) = (/ &
        & 0.59352e-06,0.77298e-06,0.98581e-06,0.12280e-05,0.14964e-05 /)
      kbo(:,35,10) = (/ &
        & 0.59731e-06,0.78147e-06,0.99919e-06,0.12457e-05,0.15176e-05 /)
      kbo(:,36,10) = (/ &
        & 0.58516e-06,0.77138e-06,0.99076e-06,0.12378e-05,0.15105e-05 /)
      kbo(:,37,10) = (/ &
        & 0.55140e-06,0.73346e-06,0.94817e-06,0.11937e-05,0.14631e-05 /)
      kbo(:,38,10) = (/ &
        & 0.51916e-06,0.69705e-06,0.90723e-06,0.11496e-05,0.14156e-05 /)
      kbo(:,39,10) = (/ &
        & 0.48960e-06,0.66318e-06,0.86863e-06,0.11068e-05,0.13701e-05 /)
      kbo(:,40,10) = (/ &
        & 0.44595e-06,0.61209e-06,0.81011e-06,0.10412e-05,0.12987e-05 /)
      kbo(:,41,10) = (/ &
        & 0.40399e-06,0.56185e-06,0.75199e-06,0.97449e-06,0.12265e-05 /)
      kbo(:,42,10) = (/ &
        & 0.36503e-06,0.51494e-06,0.69685e-06,0.91108e-06,0.11565e-05 /)
      kbo(:,43,10) = (/ &
        & 0.32174e-06,0.46170e-06,0.63377e-06,0.83820e-06,0.10749e-05 /)
      kbo(:,44,10) = (/ &
        & 0.27930e-06,0.40829e-06,0.56968e-06,0.76331e-06,0.98961e-06 /)
      kbo(:,45,10) = (/ &
        & 0.24096e-06,0.35938e-06,0.50997e-06,0.69291e-06,0.90837e-06 /)
      kbo(:,46,10) = (/ &
        & 0.20431e-06,0.31166e-06,0.45096e-06,0.62224e-06,0.82595e-06 /)
      kbo(:,47,10) = (/ &
        & 0.16816e-06,0.26359e-06,0.38972e-06,0.54827e-06,0.73938e-06 /)
      kbo(:,48,10) = (/ &
        & 0.13670e-06,0.22070e-06,0.33435e-06,0.47996e-06,0.65830e-06 /)
      kbo(:,49,10) = (/ &
        & 0.10953e-06,0.18282e-06,0.28430e-06,0.41725e-06,0.58243e-06 /)
      kbo(:,50,10) = (/ &
        & 0.88267e-07,0.15143e-06,0.24199e-06,0.36271e-06,0.51595e-06 /)
      kbo(:,51,10) = (/ &
        & 0.70298e-07,0.12484e-06,0.20511e-06,0.31462e-06,0.45605e-06 /)
      kbo(:,52,10) = (/ &
        & 0.55131e-07,0.10217e-06,0.17234e-06,0.27088e-06,0.40072e-06 /)
      kbo(:,53,10) = (/ &
        & 0.43153e-07,0.82195e-07,0.14318e-06,0.23139e-06,0.34955e-06 /)
      kbo(:,54,10) = (/ &
        & 0.33903e-07,0.66466e-07,0.12020e-06,0.19856e-06,0.30630e-06 /)
      kbo(:,55,10) = (/ &
        & 0.26416e-07,0.53605e-07,0.10034e-06,0.17017e-06,0.26833e-06 /)
      kbo(:,56,10) = (/ &
        & 0.20206e-07,0.42611e-07,0.82928e-07,0.14532e-06,0.23365e-06 /)
      kbo(:,57,10) = (/ &
        & 0.15310e-07,0.33413e-07,0.67820e-07,0.12262e-06,0.20213e-06 /)
      kbo(:,58,10) = (/ &
        & 0.11722e-07,0.26420e-07,0.55414e-07,0.10347e-06,0.17567e-06 /)
      kbo(:,59,10) = (/ &
        & 0.10312e-07,0.23851e-07,0.50918e-07,0.96421e-07,0.16547e-06 /)
      kbo(:,13,11) = (/ &
        & 0.10213e-04,0.10492e-04,0.10768e-04,0.11052e-04,0.11341e-04 /)
      kbo(:,14,11) = (/ &
        & 0.92065e-05,0.95170e-05,0.98374e-05,0.10166e-04,0.10515e-04 /)
      kbo(:,15,11) = (/ &
        & 0.82447e-05,0.85845e-05,0.89388e-05,0.93243e-05,0.97313e-05 /)
      kbo(:,16,11) = (/ &
        & 0.73562e-05,0.77204e-05,0.81177e-05,0.85472e-05,0.89941e-05 /)
      kbo(:,17,11) = (/ &
        & 0.65534e-05,0.69440e-05,0.73753e-05,0.78408e-05,0.83202e-05 /)
      kbo(:,18,11) = (/ &
        & 0.58421e-05,0.62603e-05,0.67231e-05,0.72105e-05,0.77276e-05 /)
      kbo(:,19,11) = (/ &
        & 0.52249e-05,0.56681e-05,0.61484e-05,0.66668e-05,0.72285e-05 /)
      kbo(:,20,11) = (/ &
        & 0.47032e-05,0.51617e-05,0.56660e-05,0.62226e-05,0.68302e-05 /)
      kbo(:,21,11) = (/ &
        & 0.42601e-05,0.47338e-05,0.52698e-05,0.58670e-05,0.65065e-05 /)
      kbo(:,22,11) = (/ &
        & 0.39167e-05,0.44205e-05,0.49953e-05,0.56267e-05,0.62956e-05 /)
      kbo(:,23,11) = (/ &
        & 0.36499e-05,0.41883e-05,0.47965e-05,0.54568e-05,0.61529e-05 /)
      kbo(:,24,11) = (/ &
        & 0.34565e-05,0.40283e-05,0.46653e-05,0.53526e-05,0.60723e-05 /)
      kbo(:,25,11) = (/ &
        & 0.33292e-05,0.39315e-05,0.45958e-05,0.53082e-05,0.60473e-05 /)
      kbo(:,26,11) = (/ &
        & 0.32653e-05,0.38970e-05,0.45879e-05,0.53204e-05,0.60776e-05 /)
      kbo(:,27,11) = (/ &
        & 0.32497e-05,0.39083e-05,0.46221e-05,0.53722e-05,0.61437e-05 /)
      kbo(:,28,11) = (/ &
        & 0.32741e-05,0.39580e-05,0.46902e-05,0.54541e-05,0.62354e-05 /)
      kbo(:,29,11) = (/ &
        & 0.33369e-05,0.40429e-05,0.47902e-05,0.55664e-05,0.63553e-05 /)
      kbo(:,30,11) = (/ &
        & 0.34283e-05,0.41504e-05,0.49124e-05,0.56972e-05,0.64922e-05 /)
      kbo(:,31,11) = (/ &
        & 0.35444e-05,0.42823e-05,0.50547e-05,0.58477e-05,0.66477e-05 /)
      kbo(:,32,11) = (/ &
        & 0.36801e-05,0.44317e-05,0.52138e-05,0.60136e-05,0.68176e-05 /)
      kbo(:,33,11) = (/ &
        & 0.38318e-05,0.45951e-05,0.53855e-05,0.61901e-05,0.69963e-05 /)
      kbo(:,34,11) = (/ &
        & 0.39692e-05,0.47416e-05,0.55387e-05,0.63463e-05,0.71529e-05 /)
      kbo(:,35,11) = (/ &
        & 0.40413e-05,0.48197e-05,0.56200e-05,0.64302e-05,0.72378e-05 /)
      kbo(:,36,11) = (/ &
        & 0.40356e-05,0.48162e-05,0.56178e-05,0.64290e-05,0.72385e-05 /)
      kbo(:,37,11) = (/ &
        & 0.39181e-05,0.46953e-05,0.54967e-05,0.63083e-05,0.71198e-05 /)
      kbo(:,38,11) = (/ &
        & 0.37977e-05,0.45715e-05,0.53704e-05,0.61820e-05,0.69964e-05 /)
      kbo(:,39,11) = (/ &
        & 0.36811e-05,0.44507e-05,0.52481e-05,0.60593e-05,0.68739e-05 /)
      kbo(:,40,11) = (/ &
        & 0.34909e-05,0.42522e-05,0.50444e-05,0.58543e-05,0.66697e-05 /)
      kbo(:,41,11) = (/ &
        & 0.32953e-05,0.40465e-05,0.48326e-05,0.56401e-05,0.64551e-05 /)
      kbo(:,42,11) = (/ &
        & 0.31040e-05,0.38444e-05,0.46230e-05,0.54267e-05,0.62419e-05 /)
      kbo(:,43,11) = (/ &
        & 0.28773e-05,0.36028e-05,0.43716e-05,0.51693e-05,0.59825e-05 /)
      kbo(:,44,11) = (/ &
        & 0.26404e-05,0.33480e-05,0.41036e-05,0.48939e-05,0.57034e-05 /)
      kbo(:,45,11) = (/ &
        & 0.24120e-05,0.30991e-05,0.38405e-05,0.46208e-05,0.54260e-05 /)
      kbo(:,46,11) = (/ &
        & 0.21786e-05,0.28418e-05,0.35659e-05,0.43343e-05,0.51318e-05 /)
      kbo(:,47,11) = (/ &
        & 0.19311e-05,0.25641e-05,0.32660e-05,0.40180e-05,0.48060e-05 /)
      kbo(:,48,11) = (/ &
        & 0.16967e-05,0.22980e-05,0.29746e-05,0.37093e-05,0.44842e-05 /)
      kbo(:,49,11) = (/ &
        & 0.14774e-05,0.20448e-05,0.26926e-05,0.34064e-05,0.41668e-05 /)
      kbo(:,50,11) = (/ &
        & 0.12873e-05,0.18193e-05,0.24384e-05,0.31296e-05,0.38742e-05 /)
      kbo(:,51,11) = (/ &
        & 0.11146e-05,0.16126e-05,0.22020e-05,0.28686e-05,0.35959e-05 /)
      kbo(:,52,11) = (/ &
        & 0.95604e-06,0.14200e-05,0.19761e-05,0.26163e-05,0.33236e-05 /)
      kbo(:,53,11) = (/ &
        & 0.80966e-06,0.12381e-05,0.17610e-05,0.23732e-05,0.30580e-05 /)
      kbo(:,54,11) = (/ &
        & 0.68766e-06,0.10830e-05,0.15763e-05,0.21583e-05,0.28207e-05 /)
      kbo(:,55,11) = (/ &
        & 0.58212e-06,0.94518e-06,0.14071e-05,0.19616e-05,0.26001e-05 /)
      kbo(:,56,11) = (/ &
        & 0.48769e-06,0.81784e-06,0.12480e-05,0.17754e-05,0.23872e-05 /)
      kbo(:,57,11) = (/ &
        & 0.40334e-06,0.70099e-06,0.10993e-05,0.15960e-05,0.21818e-05 /)
      kbo(:,58,11) = (/ &
        & 0.33254e-06,0.59979e-06,0.96749e-06,0.14348e-05,0.19961e-05 /)
      kbo(:,59,11) = (/ &
        & 0.30667e-06,0.56182e-06,0.91722e-06,0.13728e-05,0.19233e-05 /)
      kbo(:,13,12) = (/ &
        & 0.21780e-04,0.22297e-04,0.22851e-04,0.23387e-04,0.23897e-04 /)
      kbo(:,14,12) = (/ &
        & 0.20875e-04,0.21531e-04,0.22189e-04,0.22823e-04,0.23424e-04 /)
      kbo(:,15,12) = (/ &
        & 0.19941e-04,0.20728e-04,0.21492e-04,0.22225e-04,0.22948e-04 /)
      kbo(:,16,12) = (/ &
        & 0.19013e-04,0.19918e-04,0.20796e-04,0.21654e-04,0.22503e-04 /)
      kbo(:,17,12) = (/ &
        & 0.18129e-04,0.19150e-04,0.20149e-04,0.21144e-04,0.22094e-04 /)
      kbo(:,18,12) = (/ &
        & 0.17308e-04,0.18451e-04,0.19578e-04,0.20689e-04,0.21728e-04 /)
      kbo(:,19,12) = (/ &
        & 0.16581e-04,0.17835e-04,0.19087e-04,0.20285e-04,0.21402e-04 /)
      kbo(:,20,12) = (/ &
        & 0.15978e-04,0.17349e-04,0.18704e-04,0.19972e-04,0.21143e-04 /)
      kbo(:,21,12) = (/ &
        & 0.15496e-04,0.16976e-04,0.18403e-04,0.19724e-04,0.20952e-04 /)
      kbo(:,22,12) = (/ &
        & 0.15240e-04,0.16798e-04,0.18272e-04,0.19635e-04,0.20901e-04 /)
      kbo(:,23,12) = (/ &
        & 0.15105e-04,0.16716e-04,0.18220e-04,0.19617e-04,0.20916e-04 /)
      kbo(:,24,12) = (/ &
        & 0.15076e-04,0.16719e-04,0.18249e-04,0.19672e-04,0.20991e-04 /)
      kbo(:,25,12) = (/ &
        & 0.15141e-04,0.16802e-04,0.18352e-04,0.19786e-04,0.21116e-04 /)
      kbo(:,26,12) = (/ &
        & 0.15306e-04,0.16974e-04,0.18529e-04,0.19965e-04,0.21296e-04 /)
      kbo(:,27,12) = (/ &
        & 0.15522e-04,0.17192e-04,0.18747e-04,0.20182e-04,0.21501e-04 /)
      kbo(:,28,12) = (/ &
        & 0.15784e-04,0.17449e-04,0.18996e-04,0.20419e-04,0.21733e-04 /)
      kbo(:,29,12) = (/ &
        & 0.16090e-04,0.17744e-04,0.19276e-04,0.20687e-04,0.21987e-04 /)
      kbo(:,30,12) = (/ &
        & 0.16419e-04,0.18062e-04,0.19575e-04,0.20970e-04,0.22248e-04 /)
      kbo(:,31,12) = (/ &
        & 0.16777e-04,0.18399e-04,0.19892e-04,0.21268e-04,0.22521e-04 /)
      kbo(:,32,12) = (/ &
        & 0.17152e-04,0.18750e-04,0.20222e-04,0.21573e-04,0.22802e-04 /)
      kbo(:,33,12) = (/ &
        & 0.17537e-04,0.19109e-04,0.20556e-04,0.21883e-04,0.23082e-04 /)
      kbo(:,34,12) = (/ &
        & 0.17871e-04,0.19418e-04,0.20844e-04,0.22147e-04,0.23322e-04 /)
      kbo(:,35,12) = (/ &
        & 0.18052e-04,0.19587e-04,0.21002e-04,0.22291e-04,0.23455e-04 /)
      kbo(:,36,12) = (/ &
        & 0.18063e-04,0.19601e-04,0.21016e-04,0.22306e-04,0.23468e-04 /)
      kbo(:,37,12) = (/ &
        & 0.17833e-04,0.19389e-04,0.20824e-04,0.22132e-04,0.23314e-04 /)
      kbo(:,38,12) = (/ &
        & 0.17587e-04,0.19167e-04,0.20623e-04,0.21950e-04,0.23152e-04 /)
      kbo(:,39,12) = (/ &
        & 0.17343e-04,0.18945e-04,0.20418e-04,0.21765e-04,0.22984e-04 /)
      kbo(:,40,12) = (/ &
        & 0.16926e-04,0.18563e-04,0.20065e-04,0.21446e-04,0.22697e-04 /)
      kbo(:,41,12) = (/ &
        & 0.16478e-04,0.18152e-04,0.19687e-04,0.21101e-04,0.22388e-04 /)
      kbo(:,42,12) = (/ &
        & 0.16023e-04,0.17729e-04,0.19301e-04,0.20748e-04,0.22068e-04 /)
      kbo(:,43,12) = (/ &
        & 0.15458e-04,0.17203e-04,0.18821e-04,0.20305e-04,0.21667e-04 /)
      kbo(:,44,12) = (/ &
        & 0.14831e-04,0.16623e-04,0.18287e-04,0.19814e-04,0.21219e-04 /)
      kbo(:,45,12) = (/ &
        & 0.14192e-04,0.16029e-04,0.17735e-04,0.19308e-04,0.20757e-04 /)
      kbo(:,46,12) = (/ &
        & 0.13493e-04,0.15380e-04,0.17134e-04,0.18756e-04,0.20247e-04 /)
      kbo(:,47,12) = (/ &
        & 0.12693e-04,0.14634e-04,0.16440e-04,0.18118e-04,0.19661e-04 /)
      kbo(:,48,12) = (/ &
        & 0.11878e-04,0.13868e-04,0.15729e-04,0.17458e-04,0.19054e-04 /)
      kbo(:,49,12) = (/ &
        & 0.11052e-04,0.13077e-04,0.14993e-04,0.16776e-04,0.18429e-04 /)
      kbo(:,50,12) = (/ &
        & 0.10274e-04,0.12322e-04,0.14286e-04,0.16119e-04,0.17820e-04 /)
      kbo(:,51,12) = (/ &
        & 0.95165e-05,0.11577e-04,0.13581e-04,0.15463e-04,0.17211e-04 /)
      kbo(:,52,12) = (/ &
        & 0.87654e-05,0.10825e-04,0.12859e-04,0.14791e-04,0.16589e-04 /)
      kbo(:,53,12) = (/ &
        & 0.80213e-05,0.10071e-04,0.12124e-04,0.14102e-04,0.15949e-04 /)
      kbo(:,54,12) = (/ &
        & 0.73473e-05,0.93776e-05,0.11439e-04,0.13452e-04,0.15344e-04 /)
      kbo(:,55,12) = (/ &
        & 0.67127e-05,0.87188e-05,0.10780e-04,0.12816e-04,0.14751e-04 /)
      kbo(:,56,12) = (/ &
        & 0.60935e-05,0.80668e-05,0.10118e-04,0.12169e-04,0.14148e-04 /)
      kbo(:,57,12) = (/ &
        & 0.54908e-05,0.74223e-05,0.94571e-05,0.11517e-04,0.13528e-04 /)
      kbo(:,58,12) = (/ &
        & 0.49372e-05,0.68201e-05,0.88324e-05,0.10894e-04,0.12926e-04 /)
      kbo(:,59,12) = (/ &
        & 0.47213e-05,0.65842e-05,0.85835e-05,0.10644e-04,0.12683e-04 /)
      kbo(:,13,13) = (/ &
        & 0.46820e-04,0.47158e-04,0.47420e-04,0.47688e-04,0.47860e-04 /)
      kbo(:,14,13) = (/ &
        & 0.47343e-04,0.47824e-04,0.48275e-04,0.48677e-04,0.48937e-04 /)
      kbo(:,15,13) = (/ &
        & 0.47643e-04,0.48345e-04,0.48980e-04,0.49469e-04,0.49813e-04 /)
      kbo(:,16,13) = (/ &
        & 0.47844e-04,0.48762e-04,0.49536e-04,0.50120e-04,0.50548e-04 /)
      kbo(:,17,13) = (/ &
        & 0.47956e-04,0.49079e-04,0.49982e-04,0.50640e-04,0.51155e-04 /)
      kbo(:,18,13) = (/ &
        & 0.48046e-04,0.49334e-04,0.50343e-04,0.51068e-04,0.51673e-04 /)
      kbo(:,19,13) = (/ &
        & 0.48132e-04,0.49550e-04,0.50630e-04,0.51453e-04,0.52124e-04 /)
      kbo(:,20,13) = (/ &
        & 0.48262e-04,0.49765e-04,0.50907e-04,0.51808e-04,0.52533e-04 /)
      kbo(:,21,13) = (/ &
        & 0.48402e-04,0.49959e-04,0.51170e-04,0.52136e-04,0.52894e-04 /)
      kbo(:,22,13) = (/ &
        & 0.48671e-04,0.50243e-04,0.51485e-04,0.52481e-04,0.53256e-04 /)
      kbo(:,23,13) = (/ &
        & 0.48954e-04,0.50544e-04,0.51806e-04,0.52811e-04,0.53587e-04 /)
      kbo(:,24,13) = (/ &
        & 0.49272e-04,0.50858e-04,0.52128e-04,0.53125e-04,0.53892e-04 /)
      kbo(:,25,13) = (/ &
        & 0.49616e-04,0.51186e-04,0.52450e-04,0.53425e-04,0.54174e-04 /)
      kbo(:,26,13) = (/ &
        & 0.50001e-04,0.51551e-04,0.52773e-04,0.53723e-04,0.54445e-04 /)
      kbo(:,27,13) = (/ &
        & 0.50406e-04,0.51904e-04,0.53086e-04,0.54001e-04,0.54687e-04 /)
      kbo(:,28,13) = (/ &
        & 0.50802e-04,0.52248e-04,0.53391e-04,0.54260e-04,0.54906e-04 /)
      kbo(:,29,13) = (/ &
        & 0.51204e-04,0.52593e-04,0.53683e-04,0.54507e-04,0.55109e-04 /)
      kbo(:,30,13) = (/ &
        & 0.51608e-04,0.52928e-04,0.53956e-04,0.54730e-04,0.55285e-04 /)
      kbo(:,31,13) = (/ &
        & 0.51993e-04,0.53249e-04,0.54213e-04,0.54939e-04,0.55442e-04 /)
      kbo(:,32,13) = (/ &
        & 0.52364e-04,0.53549e-04,0.54461e-04,0.55127e-04,0.55583e-04 /)
      kbo(:,33,13) = (/ &
        & 0.52722e-04,0.53841e-04,0.54688e-04,0.55301e-04,0.55705e-04 /)
      kbo(:,34,13) = (/ &
        & 0.53018e-04,0.54074e-04,0.54867e-04,0.55434e-04,0.55799e-04 /)
      kbo(:,35,13) = (/ &
        & 0.53187e-04,0.54211e-04,0.54980e-04,0.55515e-04,0.55855e-04 /)
      kbo(:,36,13) = (/ &
        & 0.53222e-04,0.54242e-04,0.55009e-04,0.55544e-04,0.55878e-04 /)
      kbo(:,37,13) = (/ &
        & 0.53077e-04,0.54137e-04,0.54934e-04,0.55495e-04,0.55862e-04 /)
      kbo(:,38,13) = (/ &
        & 0.52907e-04,0.54013e-04,0.54850e-04,0.55445e-04,0.55837e-04 /)
      kbo(:,39,13) = (/ &
        & 0.52736e-04,0.53884e-04,0.54754e-04,0.55383e-04,0.55805e-04 /)
      kbo(:,40,13) = (/ &
        & 0.52415e-04,0.53638e-04,0.54576e-04,0.55258e-04,0.55727e-04 /)
      kbo(:,41,13) = (/ &
        & 0.52053e-04,0.53364e-04,0.54368e-04,0.55117e-04,0.55636e-04 /)
      kbo(:,42,13) = (/ &
        & 0.51661e-04,0.53061e-04,0.54142e-04,0.54952e-04,0.55527e-04 /)
      kbo(:,43,13) = (/ &
        & 0.51150e-04,0.52667e-04,0.53836e-04,0.54732e-04,0.55377e-04 /)
      kbo(:,44,13) = (/ &
        & 0.50559e-04,0.52194e-04,0.53480e-04,0.54465e-04,0.55186e-04 /)
      kbo(:,45,13) = (/ &
        & 0.49921e-04,0.51684e-04,0.53086e-04,0.54162e-04,0.54971e-04 /)
      kbo(:,46,13) = (/ &
        & 0.49197e-04,0.51093e-04,0.52628e-04,0.53809e-04,0.54714e-04 /)
      kbo(:,47,13) = (/ &
        & 0.48328e-04,0.50372e-04,0.52058e-04,0.53374e-04,0.54380e-04 /)
      kbo(:,48,13) = (/ &
        & 0.47381e-04,0.49603e-04,0.51420e-04,0.52887e-04,0.54013e-04 /)
      kbo(:,49,13) = (/ &
        & 0.46342e-04,0.48755e-04,0.50735e-04,0.52347e-04,0.53594e-04 /)
      kbo(:,50,13) = (/ &
        & 0.45266e-04,0.47911e-04,0.50033e-04,0.51782e-04,0.53163e-04 /)
      kbo(:,51,13) = (/ &
        & 0.44139e-04,0.47021e-04,0.49310e-04,0.51184e-04,0.52699e-04 /)
      kbo(:,52,13) = (/ &
        & 0.42930e-04,0.46044e-04,0.48523e-04,0.50540e-04,0.52191e-04 /)
      kbo(:,53,13) = (/ &
        & 0.41632e-04,0.44983e-04,0.47688e-04,0.49847e-04,0.51629e-04 /)
      kbo(:,54,13) = (/ &
        & 0.40359e-04,0.43928e-04,0.46843e-04,0.49172e-04,0.51075e-04 /)
      kbo(:,55,13) = (/ &
        & 0.39074e-04,0.42858e-04,0.45984e-04,0.48480e-04,0.50508e-04 /)
      kbo(:,56,13) = (/ &
        & 0.37728e-04,0.41722e-04,0.45056e-04,0.47740e-04,0.49900e-04 /)
      kbo(:,57,13) = (/ &
        & 0.36320e-04,0.40515e-04,0.44055e-04,0.46942e-04,0.49258e-04 /)
      kbo(:,58,13) = (/ &
        & 0.34927e-04,0.39308e-04,0.43052e-04,0.46141e-04,0.48596e-04 /)
      kbo(:,59,13) = (/ &
        & 0.34349e-04,0.38808e-04,0.42631e-04,0.45802e-04,0.48325e-04 /)
      kbo(:,13,14) = (/ &
        & 0.91739e-04,0.90588e-04,0.89270e-04,0.87862e-04,0.86541e-04 /)
      kbo(:,14,14) = (/ &
        & 0.97111e-04,0.95879e-04,0.94382e-04,0.92799e-04,0.91344e-04 /)
      kbo(:,15,14) = (/ &
        & 0.10201e-03,0.10059e-03,0.98963e-04,0.97297e-04,0.95661e-04 /)
      kbo(:,16,14) = (/ &
        & 0.10632e-03,0.10477e-03,0.10303e-03,0.10127e-03,0.99489e-04 /)
      kbo(:,17,14) = (/ &
        & 0.11011e-03,0.10842e-03,0.10659e-03,0.10474e-03,0.10285e-03 /)
      kbo(:,18,14) = (/ &
        & 0.11338e-03,0.11158e-03,0.10968e-03,0.10773e-03,0.10569e-03 /)
      kbo(:,19,14) = (/ &
        & 0.11615e-03,0.11428e-03,0.11231e-03,0.11026e-03,0.10810e-03 /)
      kbo(:,20,14) = (/ &
        & 0.11847e-03,0.11653e-03,0.11450e-03,0.11235e-03,0.11005e-03 /)
      kbo(:,21,14) = (/ &
        & 0.12039e-03,0.11839e-03,0.11628e-03,0.11404e-03,0.11166e-03 /)
      kbo(:,22,14) = (/ &
        & 0.12185e-03,0.11978e-03,0.11759e-03,0.11525e-03,0.11275e-03 /)
      kbo(:,23,14) = (/ &
        & 0.12298e-03,0.12085e-03,0.11858e-03,0.11615e-03,0.11356e-03 /)
      kbo(:,24,14) = (/ &
        & 0.12384e-03,0.12163e-03,0.11927e-03,0.11676e-03,0.11410e-03 /)
      kbo(:,25,14) = (/ &
        & 0.12445e-03,0.12216e-03,0.11972e-03,0.11712e-03,0.11440e-03 /)
      kbo(:,26,14) = (/ &
        & 0.12480e-03,0.12244e-03,0.11993e-03,0.11725e-03,0.11449e-03 /)
      kbo(:,27,14) = (/ &
        & 0.12497e-03,0.12254e-03,0.11997e-03,0.11723e-03,0.11442e-03 /)
      kbo(:,28,14) = (/ &
        & 0.12498e-03,0.12249e-03,0.11986e-03,0.11707e-03,0.11425e-03 /)
      kbo(:,29,14) = (/ &
        & 0.12486e-03,0.12231e-03,0.11961e-03,0.11677e-03,0.11393e-03 /)
      kbo(:,30,14) = (/ &
        & 0.12462e-03,0.12202e-03,0.11925e-03,0.11640e-03,0.11355e-03 /)
      kbo(:,31,14) = (/ &
        & 0.12428e-03,0.12163e-03,0.11882e-03,0.11594e-03,0.11310e-03 /)
      kbo(:,32,14) = (/ &
        & 0.12387e-03,0.12116e-03,0.11831e-03,0.11542e-03,0.11260e-03 /)
      kbo(:,33,14) = (/ &
        & 0.12338e-03,0.12061e-03,0.11773e-03,0.11485e-03,0.11205e-03 /)
      kbo(:,34,14) = (/ &
        & 0.12293e-03,0.12013e-03,0.11722e-03,0.11434e-03,0.11156e-03 /)
      kbo(:,35,14) = (/ &
        & 0.12271e-03,0.11987e-03,0.11696e-03,0.11408e-03,0.11132e-03 /)
      kbo(:,36,14) = (/ &
        & 0.12276e-03,0.11992e-03,0.11700e-03,0.11412e-03,0.11135e-03 /)
      kbo(:,37,14) = (/ &
        & 0.12321e-03,0.12039e-03,0.11748e-03,0.11457e-03,0.11178e-03 /)
      kbo(:,38,14) = (/ &
        & 0.12368e-03,0.12086e-03,0.11795e-03,0.11504e-03,0.11223e-03 /)
      kbo(:,39,14) = (/ &
        & 0.12412e-03,0.12132e-03,0.11841e-03,0.11549e-03,0.11266e-03 /)
      kbo(:,40,14) = (/ &
        & 0.12481e-03,0.12205e-03,0.11917e-03,0.11624e-03,0.11338e-03 /)
      kbo(:,41,14) = (/ &
        & 0.12552e-03,0.12282e-03,0.11995e-03,0.11701e-03,0.11413e-03 /)
      kbo(:,42,14) = (/ &
        & 0.12624e-03,0.12356e-03,0.12073e-03,0.11779e-03,0.11489e-03 /)
      kbo(:,43,14) = (/ &
        & 0.12708e-03,0.12444e-03,0.12166e-03,0.11873e-03,0.11581e-03 /)
      kbo(:,44,14) = (/ &
        & 0.12796e-03,0.12537e-03,0.12263e-03,0.11974e-03,0.11681e-03 /)
      kbo(:,45,14) = (/ &
        & 0.12882e-03,0.12627e-03,0.12360e-03,0.12075e-03,0.11782e-03 /)
      kbo(:,46,14) = (/ &
        & 0.12968e-03,0.12723e-03,0.12459e-03,0.12181e-03,0.11889e-03 /)
      kbo(:,47,14) = (/ &
        & 0.13062e-03,0.12827e-03,0.12567e-03,0.12295e-03,0.12008e-03 /)
      kbo(:,48,14) = (/ &
        & 0.13150e-03,0.12926e-03,0.12675e-03,0.12408e-03,0.12126e-03 /)
      kbo(:,49,14) = (/ &
        & 0.13233e-03,0.13021e-03,0.12780e-03,0.12517e-03,0.12242e-03 /)
      kbo(:,50,14) = (/ &
        & 0.13307e-03,0.13105e-03,0.12874e-03,0.12618e-03,0.12349e-03 /)
      kbo(:,51,14) = (/ &
        & 0.13374e-03,0.13183e-03,0.12963e-03,0.12715e-03,0.12449e-03 /)
      kbo(:,52,14) = (/ &
        & 0.13431e-03,0.13255e-03,0.13046e-03,0.12807e-03,0.12548e-03 /)
      kbo(:,53,14) = (/ &
        & 0.13479e-03,0.13325e-03,0.13127e-03,0.12898e-03,0.12645e-03 /)
      kbo(:,54,14) = (/ &
        & 0.13511e-03,0.13385e-03,0.13196e-03,0.12979e-03,0.12732e-03 /)
      kbo(:,55,14) = (/ &
        & 0.13533e-03,0.13436e-03,0.13261e-03,0.13052e-03,0.12814e-03 /)
      kbo(:,56,14) = (/ &
        & 0.13543e-03,0.13477e-03,0.13321e-03,0.13121e-03,0.12893e-03 /)
      kbo(:,57,14) = (/ &
        & 0.13540e-03,0.13509e-03,0.13379e-03,0.13190e-03,0.12969e-03 /)
      kbo(:,58,14) = (/ &
        & 0.13520e-03,0.13532e-03,0.13428e-03,0.13250e-03,0.13039e-03 /)
      kbo(:,59,14) = (/ &
        & 0.13510e-03,0.13536e-03,0.13445e-03,0.13273e-03,0.13066e-03 /)
      kbo(:,13,15) = (/ &
        & 0.16545e-03,0.16076e-03,0.15662e-03,0.15273e-03,0.14899e-03 /)
      kbo(:,14,15) = (/ &
        & 0.17968e-03,0.17402e-03,0.16899e-03,0.16434e-03,0.15984e-03 /)
      kbo(:,15,15) = (/ &
        & 0.19299e-03,0.18634e-03,0.18041e-03,0.17491e-03,0.16965e-03 /)
      kbo(:,16,15) = (/ &
        & 0.20519e-03,0.19756e-03,0.19072e-03,0.18435e-03,0.17834e-03 /)
      kbo(:,17,15) = (/ &
        & 0.21616e-03,0.20753e-03,0.19981e-03,0.19268e-03,0.18599e-03 /)
      kbo(:,18,15) = (/ &
        & 0.22578e-03,0.21627e-03,0.20768e-03,0.19983e-03,0.19254e-03 /)
      kbo(:,19,15) = (/ &
        & 0.23404e-03,0.22371e-03,0.21439e-03,0.20593e-03,0.19813e-03 /)
      kbo(:,20,15) = (/ &
        & 0.24079e-03,0.22975e-03,0.21986e-03,0.21084e-03,0.20261e-03 /)
      kbo(:,21,15) = (/ &
        & 0.24629e-03,0.23467e-03,0.22423e-03,0.21475e-03,0.20622e-03 /)
      kbo(:,22,15) = (/ &
        & 0.24979e-03,0.23775e-03,0.22702e-03,0.21724e-03,0.20849e-03 /)
      kbo(:,23,15) = (/ &
        & 0.25216e-03,0.23989e-03,0.22890e-03,0.21892e-03,0.21005e-03 /)
      kbo(:,24,15) = (/ &
        & 0.25355e-03,0.24109e-03,0.22997e-03,0.21990e-03,0.21094e-03 /)
      kbo(:,25,15) = (/ &
        & 0.25401e-03,0.24151e-03,0.23030e-03,0.22024e-03,0.21125e-03 /)
      kbo(:,26,15) = (/ &
        & 0.25359e-03,0.24114e-03,0.22993e-03,0.21995e-03,0.21097e-03 /)
      kbo(:,27,15) = (/ &
        & 0.25262e-03,0.24030e-03,0.22913e-03,0.21926e-03,0.21037e-03 /)
      kbo(:,28,15) = (/ &
        & 0.25126e-03,0.23904e-03,0.22801e-03,0.21831e-03,0.20948e-03 /)
      kbo(:,29,15) = (/ &
        & 0.24948e-03,0.23745e-03,0.22663e-03,0.21704e-03,0.20834e-03 /)
      kbo(:,30,15) = (/ &
        & 0.24748e-03,0.23558e-03,0.22502e-03,0.21558e-03,0.20699e-03 /)
      kbo(:,31,15) = (/ &
        & 0.24521e-03,0.23353e-03,0.22323e-03,0.21394e-03,0.20549e-03 /)
      kbo(:,32,15) = (/ &
        & 0.24273e-03,0.23132e-03,0.22129e-03,0.21221e-03,0.20387e-03 /)
      kbo(:,33,15) = (/ &
        & 0.24020e-03,0.22911e-03,0.21929e-03,0.21039e-03,0.20217e-03 /)
      kbo(:,34,15) = (/ &
        & 0.23799e-03,0.22719e-03,0.21754e-03,0.20880e-03,0.20071e-03 /)
      kbo(:,35,15) = (/ &
        & 0.23687e-03,0.22619e-03,0.21668e-03,0.20798e-03,0.19994e-03 /)
      kbo(:,36,15) = (/ &
        & 0.23693e-03,0.22624e-03,0.21673e-03,0.20802e-03,0.19997e-03 /)
      kbo(:,37,15) = (/ &
        & 0.23866e-03,0.22780e-03,0.21810e-03,0.20930e-03,0.20116e-03 /)
      kbo(:,38,15) = (/ &
        & 0.24049e-03,0.22941e-03,0.21958e-03,0.21064e-03,0.20240e-03 /)
      kbo(:,39,15) = (/ &
        & 0.24235e-03,0.23100e-03,0.22101e-03,0.21195e-03,0.20362e-03 /)
      kbo(:,40,15) = (/ &
        & 0.24544e-03,0.23374e-03,0.22344e-03,0.21416e-03,0.20567e-03 /)
      kbo(:,41,15) = (/ &
        & 0.24874e-03,0.23671e-03,0.22606e-03,0.21653e-03,0.20786e-03 /)
      kbo(:,42,15) = (/ &
        & 0.25214e-03,0.23974e-03,0.22874e-03,0.21892e-03,0.21007e-03 /)
      kbo(:,43,15) = (/ &
        & 0.25633e-03,0.24355e-03,0.23207e-03,0.22195e-03,0.21281e-03 /)
      kbo(:,44,15) = (/ &
        & 0.26108e-03,0.24779e-03,0.23584e-03,0.22529e-03,0.21581e-03 /)
      kbo(:,45,15) = (/ &
        & 0.26596e-03,0.25216e-03,0.23977e-03,0.22875e-03,0.21897e-03 /)
      kbo(:,46,15) = (/ &
        & 0.27137e-03,0.25699e-03,0.24413e-03,0.23258e-03,0.22240e-03 /)
      kbo(:,47,15) = (/ &
        & 0.27767e-03,0.26264e-03,0.24919e-03,0.23707e-03,0.22639e-03 /)
      kbo(:,48,15) = (/ &
        & 0.28422e-03,0.26851e-03,0.25443e-03,0.24179e-03,0.23054e-03 /)
      kbo(:,49,15) = (/ &
        & 0.29109e-03,0.27465e-03,0.25993e-03,0.24676e-03,0.23489e-03 /)
      kbo(:,50,15) = (/ &
        & 0.29784e-03,0.28066e-03,0.26532e-03,0.25156e-03,0.23921e-03 /)
      kbo(:,51,15) = (/ &
        & 0.30464e-03,0.28674e-03,0.27072e-03,0.25642e-03,0.24358e-03 /)
      kbo(:,52,15) = (/ &
        & 0.31175e-03,0.29305e-03,0.27640e-03,0.26149e-03,0.24813e-03 /)
      kbo(:,53,15) = (/ &
        & 0.31921e-03,0.29964e-03,0.28229e-03,0.26674e-03,0.25282e-03 /)
      kbo(:,54,15) = (/ &
        & 0.32632e-03,0.30596e-03,0.28789e-03,0.27174e-03,0.25731e-03 /)
      kbo(:,55,15) = (/ &
        & 0.33342e-03,0.31218e-03,0.29344e-03,0.27674e-03,0.26179e-03 /)
      kbo(:,56,15) = (/ &
        & 0.34053e-03,0.31870e-03,0.29920e-03,0.28191e-03,0.26637e-03 /)
      kbo(:,57,15) = (/ &
        & 0.34801e-03,0.32554e-03,0.30518e-03,0.28726e-03,0.27114e-03 /)
      kbo(:,58,15) = (/ &
        & 0.35537e-03,0.33214e-03,0.31109e-03,0.29248e-03,0.27588e-03 /)
      kbo(:,59,15) = (/ &
        & 0.35841e-03,0.33487e-03,0.31352e-03,0.29463e-03,0.27781e-03 /)
      kbo(:,13,16) = (/ &
        & 0.23817e-03,0.23193e-03,0.22589e-03,0.21979e-03,0.21365e-03 /)
      kbo(:,14,16) = (/ &
        & 0.26266e-03,0.25442e-03,0.24663e-03,0.23897e-03,0.23152e-03 /)
      kbo(:,15,16) = (/ &
        & 0.28586e-03,0.27559e-03,0.26587e-03,0.25663e-03,0.24800e-03 /)
      kbo(:,16,16) = (/ &
        & 0.30726e-03,0.29496e-03,0.28337e-03,0.27251e-03,0.26278e-03 /)
      kbo(:,17,16) = (/ &
        & 0.32665e-03,0.31224e-03,0.29895e-03,0.28665e-03,0.27581e-03 /)
      kbo(:,18,16) = (/ &
        & 0.34367e-03,0.32749e-03,0.31249e-03,0.29896e-03,0.28707e-03 /)
      kbo(:,19,16) = (/ &
        & 0.35833e-03,0.34046e-03,0.32413e-03,0.30949e-03,0.29662e-03 /)
      kbo(:,20,16) = (/ &
        & 0.37032e-03,0.35107e-03,0.33355e-03,0.31795e-03,0.30443e-03 /)
      kbo(:,21,16) = (/ &
        & 0.38004e-03,0.35962e-03,0.34106e-03,0.32482e-03,0.31071e-03 /)
      kbo(:,22,16) = (/ &
        & 0.38628e-03,0.36502e-03,0.34582e-03,0.32929e-03,0.31473e-03 /)
      kbo(:,23,16) = (/ &
        & 0.39046e-03,0.36870e-03,0.34902e-03,0.33239e-03,0.31753e-03 /)
      kbo(:,24,16) = (/ &
        & 0.39290e-03,0.37079e-03,0.35085e-03,0.33417e-03,0.31909e-03 /)
      kbo(:,25,16) = (/ &
        & 0.39368e-03,0.37132e-03,0.35155e-03,0.33489e-03,0.31974e-03 /)
      kbo(:,26,16) = (/ &
        & 0.39288e-03,0.37052e-03,0.35111e-03,0.33452e-03,0.31938e-03 /)
      kbo(:,27,16) = (/ &
        & 0.39120e-03,0.36896e-03,0.34999e-03,0.33347e-03,0.31836e-03 /)
      kbo(:,28,16) = (/ &
        & 0.38862e-03,0.36669e-03,0.34828e-03,0.33189e-03,0.31693e-03 /)
      kbo(:,29,16) = (/ &
        & 0.38540e-03,0.36396e-03,0.34596e-03,0.32975e-03,0.31502e-03 /)
      kbo(:,30,16) = (/ &
        & 0.38165e-03,0.36095e-03,0.34333e-03,0.32738e-03,0.31277e-03 /)
      kbo(:,31,16) = (/ &
        & 0.37756e-03,0.35762e-03,0.34034e-03,0.32467e-03,0.31030e-03 /)
      kbo(:,32,16) = (/ &
        & 0.37323e-03,0.35410e-03,0.33709e-03,0.32164e-03,0.30764e-03 /)
      kbo(:,33,16) = (/ &
        & 0.36881e-03,0.35033e-03,0.33368e-03,0.31855e-03,0.30481e-03 /)
      kbo(:,34,16) = (/ &
        & 0.36518e-03,0.34710e-03,0.33080e-03,0.31589e-03,0.30241e-03 /)
      kbo(:,35,16) = (/ &
        & 0.36331e-03,0.34548e-03,0.32924e-03,0.31455e-03,0.30119e-03 /)
      kbo(:,36,16) = (/ &
        & 0.36345e-03,0.34559e-03,0.32934e-03,0.31463e-03,0.30125e-03 /)
      kbo(:,37,16) = (/ &
        & 0.36636e-03,0.34821e-03,0.33175e-03,0.31676e-03,0.30324e-03 /)
      kbo(:,38,16) = (/ &
        & 0.36948e-03,0.35092e-03,0.33423e-03,0.31902e-03,0.30527e-03 /)
      kbo(:,39,16) = (/ &
        & 0.37259e-03,0.35368e-03,0.33668e-03,0.32128e-03,0.30727e-03 /)
      kbo(:,40,16) = (/ &
        & 0.37795e-03,0.35829e-03,0.34085e-03,0.32505e-03,0.31069e-03 /)
      kbo(:,41,16) = (/ &
        & 0.38379e-03,0.36312e-03,0.34529e-03,0.32908e-03,0.31437e-03 /)
      kbo(:,42,16) = (/ &
        & 0.38990e-03,0.36819e-03,0.34980e-03,0.33322e-03,0.31806e-03 /)
      kbo(:,43,16) = (/ &
        & 0.39755e-03,0.37469e-03,0.35548e-03,0.33833e-03,0.32274e-03 /)
      kbo(:,44,16) = (/ &
        & 0.40604e-03,0.38206e-03,0.36178e-03,0.34404e-03,0.32793e-03 /)
      kbo(:,45,16) = (/ &
        & 0.41497e-03,0.38998e-03,0.36828e-03,0.34986e-03,0.33329e-03 /)
      kbo(:,46,16) = (/ &
        & 0.42497e-03,0.39871e-03,0.37566e-03,0.35633e-03,0.33909e-03 /)
      kbo(:,47,16) = (/ &
        & 0.43684e-03,0.40880e-03,0.38451e-03,0.36380e-03,0.34586e-03 /)
      kbo(:,48,16) = (/ &
        & 0.44932e-03,0.41960e-03,0.39404e-03,0.37171e-03,0.35286e-03 /)
      kbo(:,49,16) = (/ &
        & 0.46270e-03,0.43113e-03,0.40397e-03,0.38027e-03,0.36021e-03 /)
      kbo(:,50,16) = (/ &
        & 0.47605e-03,0.44249e-03,0.41370e-03,0.38887e-03,0.36733e-03 /)
      kbo(:,51,16) = (/ &
        & 0.48981e-03,0.45414e-03,0.42376e-03,0.39765e-03,0.37477e-03 /)
      kbo(:,52,16) = (/ &
        & 0.50430e-03,0.46661e-03,0.43437e-03,0.40673e-03,0.38268e-03 /)
      kbo(:,53,16) = (/ &
        & 0.51980e-03,0.47970e-03,0.44558e-03,0.41639e-03,0.39115e-03 /)
      kbo(:,54,16) = (/ &
        & 0.53506e-03,0.49244e-03,0.45647e-03,0.42564e-03,0.39926e-03 /)
      kbo(:,55,16) = (/ &
        & 0.55131e-03,0.50528e-03,0.46739e-03,0.43505e-03,0.40730e-03 /)
      kbo(:,56,16) = (/ &
        & 0.56909e-03,0.51883e-03,0.47884e-03,0.44497e-03,0.41571e-03 /)
      kbo(:,57,16) = (/ &
        & 0.58824e-03,0.53334e-03,0.49097e-03,0.45523e-03,0.42457e-03 /)
      kbo(:,58,16) = (/ &
        & 0.60745e-03,0.54837e-03,0.50301e-03,0.46546e-03,0.43352e-03 /)
      kbo(:,59,16) = (/ &
        & 0.61557e-03,0.55493e-03,0.50805e-03,0.46962e-03,0.43716e-03 /)

!     -----------------------------------------------------------------

      forrefo(:, 1) = (/ 0.351362e-07, 0.341136e-07, 0.181317e-06 /)
      forrefo(:, 2) = (/ 0.109648e-06, 0.344240e-06, 0.139709e-05 /)
      forrefo(:, 3) = (/ 0.374823e-06, 0.103424e-05, 0.188717e-05 /)
      forrefo(:, 4) = (/ 0.580041e-06, 0.116876e-05, 0.121183e-05 /)
      forrefo(:, 5) = (/ 0.115608e-05, 0.148110e-05, 0.836083e-06 /)
      forrefo(:, 6) = (/ 0.181460e-05, 0.133313e-05, 0.500167e-06 /)
      forrefo(:, 7) = (/ 0.199096e-05, 0.115276e-05, 0.432994e-06 /)
      forrefo(:, 8) = (/ 0.183730e-05, 0.122260e-05, 0.433248e-06 /)
      forrefo(:, 9) = (/ 0.198386e-05, 0.100130e-05, 0.269712e-06 /)
      forrefo(:,10) = (/ 0.276382e-05, 0.749215e-06, 0.236919e-06 /)
      forrefo(:,11) = (/ 0.298202e-05, 0.629688e-06, 0.228388e-06 /)
      forrefo(:,12) = (/ 0.364604e-05, 0.455336e-06, 0.206130e-06 /)
      forrefo(:,13) = (/ 0.373339e-05, 0.245210e-06, 0.201987e-06 /)
      forrefo(:,14) = (/ 0.480378e-05, 0.177591e-06, 0.171458e-06 /)
      forrefo(:,15) = (/ 0.521700e-05, 0.203358e-06, 0.189559e-06 /)
      forrefo(:,16) = (/ 0.542717e-05, 0.219022e-06, 0.218271e-06 /)

!     -----------------------------------------------------------------
!     The array SELFREFO contains the coefficient of the water vapor
!     self-continuum (including the energy term).  The first index
!     refers to temperature in 7.2 degree increments.  For instance,
!     JT = 1 refers to a temperature of 245.6, JT = 2 refers to 252.8,
!     etc.  The second index runs over the g-channel (1 to 16).

      selfrefo(:, 1) = (/ &
        &  0.538526e-04, 0.464603e-04, 0.400828e-04, 0.345807e-04, 0.298339e-04, &
        &  0.257386e-04, 0.222055e-04, 0.191574e-04, 0.165277e-04, 0.142590e-04 /)
      selfrefo(:, 2) = (/ &
        &  0.162409e-03, 0.128347e-03, 0.101430e-03, 0.801571e-04, 0.633460e-04, &
        &  0.500607e-04, 0.395616e-04, 0.312645e-04, 0.247075e-04, 0.195257e-04 /)
      selfrefo(:, 3) = (/ &
        &  0.262882e-03, 0.212793e-03, 0.172247e-03, 0.139427e-03, 0.112860e-03, &
        &  0.913557e-04, 0.739487e-04, 0.598584e-04, 0.484529e-04, 0.392206e-04 /)
      selfrefo(:, 4) = (/ &
        &  0.242873e-03, 0.204225e-03, 0.171726e-03, 0.144399e-03, 0.121421e-03, &
        &  0.102099e-03, 0.858516e-04, 0.721899e-04, 0.607022e-04, 0.510426e-04 /)
      selfrefo(:, 5) = (/ &
        &  0.235614e-03, 0.207814e-03, 0.183293e-03, 0.161666e-03, 0.142591e-03, &
        &  0.125766e-03, 0.110927e-03, 0.978381e-04, 0.862939e-04, 0.761119e-04 /)
      selfrefo(:, 6) = (/ &
        &  0.205508e-03, 0.190174e-03, 0.175985e-03, 0.162854e-03, 0.150702e-03, &
        &  0.139458e-03, 0.129052e-03, 0.119423e-03, 0.110513e-03, 0.102267e-03 /)
      selfrefo(:, 7) = (/ &
        &  0.185027e-03, 0.175148e-03, 0.165796e-03, 0.156944e-03, 0.148565e-03, &
        &  0.140633e-03, 0.133124e-03, 0.126016e-03, 0.119288e-03, 0.112919e-03 /)
      selfrefo(:, 8) = (/ &
        &  0.192634e-03, 0.180192e-03, 0.168554e-03, 0.157668e-03, 0.147484e-03, &
        &  0.137959e-03, 0.129048e-03, 0.120713e-03, 0.112917e-03, 0.105624e-03 /)
      selfrefo(:, 9) = (/ &
        &  0.161632e-03, 0.155919e-03, 0.150408e-03, 0.145092e-03, 0.139963e-03, &
        &  0.135016e-03, 0.130244e-03, 0.125640e-03, 0.121199e-03, 0.116915e-03 /)
      selfrefo(:,10) = (/ &
        &  0.120880e-03, 0.125265e-03, 0.129810e-03, 0.134520e-03, 0.139400e-03, &
        &  0.144458e-03, 0.149699e-03, 0.155130e-03, 0.160758e-03, 0.166591e-03 /)
      selfrefo(:,11) = (/ &
        &  0.104705e-03, 0.111761e-03, 0.119291e-03, 0.127330e-03, 0.135910e-03, &
        &  0.145068e-03, 0.154843e-03, 0.165277e-03, 0.176414e-03, 0.188302e-03 /)
      selfrefo(:,12) = (/ &
        &  0.846335e-04, 0.951236e-04, 0.106914e-03, 0.120166e-03, 0.135060e-03, &
        &  0.151800e-03, 0.170616e-03, 0.191763e-03, 0.215532e-03, 0.242246e-03 /)
      selfrefo(:,13) = (/ &
        &  0.669754e-04, 0.781902e-04, 0.912829e-04, 0.106568e-03, 0.124413e-03, &
        &  0.145245e-03, 0.169566e-03, 0.197959e-03, 0.231107e-03, 0.269805e-03 /)
      selfrefo(:,14) = (/ &
        &  0.597091e-04, 0.722265e-04, 0.873679e-04, 0.105684e-03, 0.127839e-03, &
        &  0.154639e-03, 0.187057e-03, 0.226272e-03, 0.273707e-03, 0.331087e-03 /)
      selfrefo(:,15) = (/ &
        &  0.640410e-04, 0.771879e-04, 0.930338e-04, 0.112133e-03, 0.135152e-03, &
        &  0.162897e-03, 0.196338e-03, 0.236644e-03, 0.285225e-03, 0.343778e-03 /)
      selfrefo(:,16) = (/ &
        &  0.666420e-04, 0.801056e-04, 0.962892e-04, 0.115742e-03, 0.139126e-03, &
        &  0.167233e-03, 0.201019e-03, 0.241630e-03, 0.290446e-03, 0.349125e-03 /)
     
      end subroutine sw_kgb22
