!     path:      $Source$
!     author:    $Author$
!     revision:  $Revision$
!     created:   $Date$

!----------------------------------------------------------------------------
! Copyright (c) 2002-2016, Atmospheric & Environmental Research, Inc. (AER)
! All rights reserved.
!
! Redistribution and use in source and binary forms, with or without
! modification, are permitted provided that the following conditions are met:
!  * Redistributions of source code must retain the above copyright
!    notice, this list of conditions and the following disclaimer.
!  * Redistributions in binary form must reproduce the above copyright
!    notice, this list of conditions and the following disclaimer in the
!    documentation and/or other materials provided with the distribution.
!  * Neither the name of Atmospheric & Environmental Research, Inc., nor
!    the names of its contributors may be used to endorse or promote products
!    derived from this software without specific prior written permission.
!
! THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
! AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
! IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
! ARE DISCLAIMED. IN NO EVENT SHALL ATMOSPHERIC & ENVIRONMENTAL RESEARCH, INC., 
! BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
! CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
! SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
! INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
! CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
! ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
! THE POSSIBILITY OF SUCH DAMAGE.
!                        (http://www.rtweb.aer.com/)                        
!----------------------------------------------------------------------------

! **************************************************************************
!      subroutine sw_kgbnn
! **************************************************************************
!  RRTM Shortwave Radiative Transfer Model
!  Atmospheric and Environmental Research, Inc., Cambridge, MA
!
!  Original by J.Delamere, Atmospheric & Environmental Research.
!  Reformatted for F90: JJMorcrette, ECMWF
!  Further F90 and GCM revisions:  MJIacono, AER, July 2002
!  Solar variability revisions:  MJIacono, AER, November 2015
!
!  This file contains 14 subroutines that include the 
!  absorption coefficients and other data for each of the 14 shortwave
!  spectral bands used in RRTM_SW.  Here, the data are defined for 16
!  g-points, or sub-intervals, per band.  These data are combined and
!  weighted using a mapping procedure in routine RRTMG_SW_INIT to reduce
!  the total number of g-points from 224 to 112 for use in the GCM.
! **************************************************************************
      subroutine sw_kgb19
! **************************************************************************

      !use parkind, only : im => kind , rb => kind  
      use rrsw_kg19, only : kao, kbo, selfrefo, forrefo, sfluxrefo, rayl, &
                            irradnceo, facbrghto, snsptdrko

      implicit none
      save

! Kurucz solar source function
      sfluxrefo(:,1) = (/ &
        & 3.25791    , 3.29697    , 3.16031    , 2.96115    , &
        & 2.69238    , 2.33819    , 1.92760    , 1.44918    , &
        & 0.979764   , 0.107336   , 8.94523e-02, 6.98325e-02, &
        & 5.12051e-02, 3.23645e-02, 1.23401e-02, 1.71339e-03 /)
      sfluxrefo(:,2) = (/ &
        & 3.22769    , 3.28817    , 3.16687    , 2.97662    , &
        & 2.69495    , 2.34392    , 1.92900    , 1.45391    , &
        & 0.982522   , 0.107638   , 8.92458e-02, 6.99885e-02, &
        & 5.09679e-02, 3.23789e-02, 1.22673e-02, 1.56040e-03 /)
      sfluxrefo(:,3) = (/ &
        & 3.22294    , 3.27780    , 3.17424    , 2.97143    , &
        & 2.69785    , 2.34993    , 1.93155    , 1.45196    , &
        & 0.985329   , 0.108027   , 8.93552e-02, 6.99937e-02, &
        & 5.11678e-02, 3.24846e-02, 1.20636e-02, 1.56040e-03 /)
      sfluxrefo(:,4) = (/ &
        & 3.22445    , 3.26113    , 3.18438    , 2.96921    , &
        & 2.69579    , 2.35586    , 1.93454    , 1.44949    , &
        & 0.987347   , 0.108611   , 8.91643e-02, 7.02236e-02, &
        & 5.12980e-02, 3.25282e-02, 1.21189e-02, 1.56040e-03 /)
      sfluxrefo(:,5) = (/ &
        & 3.22497    , 3.25109    , 3.18741    , 2.96970    , &
        & 2.69460    , 2.36020    , 1.93301    , 1.45224    , &
        & 0.988564   , 0.108255   , 8.93830e-02, 7.03655e-02, &
        & 5.13017e-02, 3.29414e-02, 1.21189e-02, 1.56040e-03 /)
      sfluxrefo(:,6) = (/ &
        & 3.22632    , 3.24174    , 3.18524    , 2.97402    , &
        & 2.69807    , 2.35742    , 1.93377    , 1.45621    , &
        & 0.988132   , 0.108344   , 8.93188e-02, 7.04907e-02, &
        & 5.17938e-02, 3.31465e-02, 1.21155e-02, 1.56040e-03 /)
      sfluxrefo(:,7) = (/ &
        & 3.22793    , 3.23589    , 3.17720    , 2.97869    , &
        & 2.70293    , 2.35436    , 1.93557    , 1.45868    , &
        & 0.988654   , 0.108198   , 8.93375e-02, 7.09790e-02, &
        & 5.24733e-02, 3.31298e-02, 1.21126e-02, 1.56040e-03 /)
      sfluxrefo(:,8) = (/ &
        & 3.22966    , 3.24087    , 3.15676    , 2.98171    , &
        & 2.70894    , 2.34975    , 1.93855    , 1.46354    , &
        & 0.988544   , 0.108574   , 9.02522e-02, 7.12908e-02, &
        & 5.24844e-02, 3.31084e-02, 1.21060e-02, 1.56040e-03 /)
      sfluxrefo(:,9) = (/ &
        & 3.27240    , 3.24666    , 3.13886    , 2.95238    , &
        & 2.70190    , 2.34460    , 1.93948    , 1.47111    , &
        & 0.990821   , 0.108730   , 9.01625e-02, 7.13261e-02, &
        & 5.24813e-02, 3.31083e-02, 1.21126e-02, 1.56040e-03 /)

! Solar variability components: time-invariant baseline quiet sun irradiance
      irradnceo(:,1) = (/ &
        & 3.29286E+00, 3.24885E+00, 3.15900E+00, 2.96040E+00,&
        & 2.69977E+00, 2.35850E+00, 1.94159E+00, 1.45874E+00,&
        & 9.87699E-01, 1.08954E-01, 9.04621E-02, 7.04124E-02,&
        & 5.15416E-02, 3.26988E-02, 1.24435E-02, 1.76133E-03/)
      irradnceo(:,2) = (/ &
        & 3.22496E+00, 3.26018E+00, 3.16804E+00, 2.96961E+00,&
        & 2.70793E+00, 2.36729E+00, 1.94928E+00, 1.46784E+00,&
        & 9.91843E-01, 1.09396E-01, 9.04612E-02, 7.05080E-02,&
        & 5.15188E-02, 3.27539E-02, 1.24115E-02, 1.65981E-03/)
      irradnceo(:,3) = (/ &
        & 3.21236E+00, 3.25198E+00, 3.17586E+00, 2.96576E+00,&
        & 2.70824E+00, 2.37391E+00, 1.95462E+00, 1.46684E+00,&
        & 9.96719E-01, 1.09657E-01, 9.03525E-02, 7.06845E-02,&
        & 5.16394E-02, 3.28856E-02, 1.25086E-02, 1.65981E-03/)
      irradnceo(:,4) = (/ &
        & 3.21237E+00, 3.23846E+00, 3.17989E+00, 2.96225E+00,&
        & 2.70974E+00, 2.37787E+00, 1.95632E+00, 1.46783E+00,&
        & 1.00020E+00, 1.10287E-01, 9.04245E-02, 7.08427E-02,&
        & 5.18418E-02, 3.31583E-02, 1.25482E-02, 1.65981E-03/)
      irradnceo(:,5) = (/ &
        & 3.21234E+00, 3.22907E+00, 3.17922E+00, 2.96430E+00,&
        & 2.70945E+00, 2.37906E+00, 1.95595E+00, 1.47248E+00,&
        & 1.00200E+00, 1.09940E-01, 9.06673E-02, 7.13884E-02,&
        & 5.19400E-02, 3.36558E-02, 1.25436E-02, 1.65981E-03/)
      irradnceo(:,6) = (/ &
        & 3.21276E+00, 3.21675E+00, 3.17737E+00, 2.97201E+00,&
        & 2.70985E+00, 2.37666E+00, 1.95587E+00, 1.47760E+00,&
        & 1.00387E+00, 1.09480E-01, 9.08326E-02, 7.15717E-02,&
        & 5.31111E-02, 3.37363E-02, 1.25449E-02, 1.65981E-03/)
      irradnceo(:,7) = (/ &
        & 3.21323E+00, 3.21715E+00, 3.16001E+00, 2.97836E+00,&
        & 2.71309E+00, 2.37377E+00, 1.95927E+00, 1.48015E+00,&
        & 1.00588E+00, 1.09771E-01, 9.06271E-02, 7.29082E-02,&
        & 5.35345E-02, 3.37265E-02, 1.25427E-02, 1.65981E-03/)
      irradnceo(:,8) = (/ &
        & 3.21454E+00, 3.22206E+00, 3.13704E+00, 2.98088E+00,&
        & 2.72350E+00, 2.36766E+00, 1.95828E+00, 1.48829E+00,&
        & 1.00641E+00, 1.10868E-01, 9.16997E-02, 7.30508E-02,&
        & 5.34875E-02, 3.37286E-02, 1.25323E-02, 1.65984E-03/)
      irradnceo(:,9) = (/ &
        & 3.27853E+00, 3.22066E+00, 3.11487E+00, 2.94851E+00,&
        & 2.71736E+00, 2.35175E+00, 1.96182E+00, 1.49385E+00,&
        & 1.01121E+00, 1.10865E-01, 9.17954E-02, 7.30072E-02,&
        & 5.35235E-02, 3.37278E-02, 1.25406E-02, 1.65981E-03/)
! Solar variability components: facular brightening
      facbrghto(:,1) = (/ &
        & 2.65541E-04, 2.69664E-04, 2.64272E-04, 2.39897E-04,&
        & 2.08576E-04, 1.73816E-04, 1.27187E-04, 9.35832E-05,&
        & 6.51644E-05, 6.95323E-06, 5.65076E-06, 3.93261E-06,&
        & 2.80501E-06, 1.74715E-06, 6.82905E-07, 1.04621E-07/)
      facbrghto(:,2) = (/ &
        & 2.62055E-04, 2.69019E-04, 2.56732E-04, 2.36500E-04,&
        & 2.10621E-04, 1.72377E-04, 1.33173E-04, 9.89652E-05,&
        & 6.76075E-05, 7.04834E-06, 5.69313E-06, 4.07868E-06,&
        & 2.97458E-06, 1.80882E-06, 7.43632E-07, 1.78658E-07/)
      facbrghto(:,3) = (/ &
        & 2.61651E-04, 2.68249E-04, 2.55386E-04, 2.34114E-04,&
        & 2.08670E-04, 1.70007E-04, 1.35598E-04, 1.02934E-04,&
        & 6.93774E-05, 7.32597E-06, 5.95116E-06, 4.25768E-06,&
        & 2.90881E-06, 1.88603E-06, 1.08060E-06, 1.78658E-07/)
      facbrghto(:,4) = (/ &
        & 2.61872E-04, 2.67128E-04, 2.54409E-04, 2.31214E-04,&
        & 2.08367E-04, 1.68601E-04, 1.36659E-04, 1.05614E-04,&
        & 7.11289E-05, 7.49937E-06, 5.90873E-06, 4.45262E-06,&
        & 3.32674E-06, 2.08252E-06, 1.13294E-06, 1.78658E-07/)
      facbrghto(:,5) = (/ &
        & 2.61996E-04, 2.66348E-04, 2.53227E-04, 2.30506E-04,&
        & 2.05240E-04, 1.67036E-04, 1.39007E-04, 1.07716E-04,&
        & 7.27332E-05, 7.60283E-06, 6.13186E-06, 4.63423E-06,&
        & 3.27597E-06, 2.80885E-06, 1.13379E-06, 1.78658E-07/)
      facbrghto(:,6) = (/ &
        & 2.62227E-04, 2.65325E-04, 2.51577E-04, 2.30266E-04,&
        & 1.99545E-04, 1.69132E-04, 1.40762E-04, 1.09359E-04,&
        & 7.42886E-05, 7.67481E-06, 6.29675E-06, 4.84250E-06,&
        & 4.01851E-06, 2.94948E-06, 1.13386E-06, 1.78658E-07/)
      facbrghto(:,7) = (/ &
        & 2.62454E-04, 2.64243E-04, 2.48983E-04, 2.29993E-04,&
        & 1.95203E-04, 1.69307E-04, 1.43596E-04, 1.11033E-04,&
        & 7.57847E-05, 8.09006E-06, 6.46175E-06, 5.82815E-06,&
        & 4.33021E-06, 2.95548E-06, 1.13447E-06, 1.78658E-07/)
      facbrghto(:,8) = (/ &
        & 2.62554E-04, 2.62449E-04, 2.43949E-04, 2.28673E-04,&
        & 1.94817E-04, 1.68699E-04, 1.45781E-04, 1.13515E-04,&
        & 7.80069E-05, 9.06515E-06, 7.51718E-06, 5.93589E-06,&
        & 4.34552E-06, 2.95218E-06, 1.13716E-06, 1.78659E-07/)
      facbrghto(:,9) = (/ &
        & 2.59937E-04, 2.55765E-04, 2.36349E-04, 2.13143E-04,&
        & 2.01578E-04, 1.77978E-04, 1.51533E-04, 1.18811E-04,&
        & 8.32132E-05, 9.11293E-06, 7.60989E-06, 5.94609E-06,&
        & 4.33140E-06, 2.95526E-06, 1.13507E-06, 1.78658E-07/)
! Solar variability components: sunspot darkening
      snsptdrko(:,1) = (/ &
        &-3.82079E-04,-3.80434E-04,-3.68787E-04,-3.44649E-04,&
        &-3.13303E-04,-2.73575E-04,-2.25103E-04,-1.69770E-04,&
        &-1.15124E-04,-1.27085E-05,-1.05676E-05,-8.20294E-06,&
        &-6.00478E-06,-3.82368E-06,-1.44417E-06,-2.03820E-07/)
      snsptdrko(:,2) = (/ &
        &-3.71376E-04,-3.82583E-04,-3.71780E-04,-3.47103E-04,&
        &-3.14745E-04,-2.74199E-04,-2.25693E-04,-1.70142E-04,&
        &-1.15255E-04,-1.27481E-05,-1.05434E-05,-8.17755E-06,&
        &-5.98639E-06,-3.82133E-06,-1.43787E-06,-1.88080E-07/)
      snsptdrko(:,3) = (/ &
        &-3.69376E-04,-3.81303E-04,-3.72509E-04,-3.47756E-04,&
        &-3.15608E-04,-2.74721E-04,-2.26076E-04,-1.70068E-04,&
        &-1.15578E-04,-1.27548E-05,-1.04313E-05,-8.18666E-06,&
        &-5.99652E-06,-3.82001E-06,-1.40763E-06,-1.88080E-07/)
      snsptdrko(:,4) = (/ &
        &-3.69424E-04,-3.78824E-04,-3.73271E-04,-3.47598E-04,&
        &-3.16553E-04,-2.75211E-04,-2.26141E-04,-1.70157E-04,&
        &-1.15790E-04,-1.27903E-05,-1.04810E-05,-8.17061E-06,&
        &-5.95800E-06,-3.82068E-06,-1.40301E-06,-1.88080E-07/)
      snsptdrko(:,5) = (/ &
        &-3.69544E-04,-3.76205E-04,-3.74015E-04,-3.47781E-04,&
        &-3.17146E-04,-2.75999E-04,-2.25983E-04,-1.70364E-04,&
        &-1.15998E-04,-1.26938E-05,-1.04424E-05,-8.26345E-06,&
        &-5.99245E-06,-3.76211E-06,-1.40262E-06,-1.88080E-07/)
      snsptdrko(:,6) = (/ &
        &-3.69743E-04,-3.73997E-04,-3.73491E-04,-3.48983E-04,&
        &-3.17850E-04,-2.76183E-04,-2.26053E-04,-1.70571E-04,&
        &-1.16159E-04,-1.26384E-05,-1.04454E-05,-8.24584E-06,&
        &-6.07922E-06,-3.74953E-06,-1.40255E-06,-1.88080E-07/)
      snsptdrko(:,7) = (/ &
        &-3.70028E-04,-3.73495E-04,-3.70853E-04,-3.49824E-04,&
        &-3.18455E-04,-2.76790E-04,-2.26560E-04,-1.70613E-04,&
        &-1.16363E-04,-1.26311E-05,-1.04368E-05,-8.29029E-06,&
        &-6.10521E-06,-3.74572E-06,-1.40221E-06,-1.88080E-07/)
      snsptdrko(:,8) = (/ &
        &-3.70491E-04,-3.73645E-04,-3.65425E-04,-3.51625E-04,&
        &-3.19853E-04,-2.77340E-04,-2.27148E-04,-1.71242E-04,&
        &-1.16115E-04,-1.27154E-05,-1.04544E-05,-8.29784E-06,&
        &-6.09114E-06,-3.74735E-06,-1.40078E-06,-1.88080E-07/)
      snsptdrko(:,9) = (/ &
        &-3.79132E-04,-3.72764E-04,-3.61234E-04,-3.44057E-04,&
        &-3.20647E-04,-2.78048E-04,-2.29213E-04,-1.71594E-04,&
        &-1.16202E-04,-1.27089E-05,-1.04521E-05,-8.29095E-06,&
        &-6.09989E-06,-3.74608E-06,-1.40188E-06,-1.88080E-07/)

! Rayleigh extinction coefficient at v = 4900 cm-1.
      rayl = 2.29e-09

!     ------------------------------------------------------------------
!     The array KAO contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels> ~100mb, temperatures, and binary
!     species parameters (see taumol.f for definition).  The first 
!     index in the array, JS, runs from 1 to 9, and corresponds to 
!     different values of the binary species parameter.  For instance, 
!     JS=1 refers to dry air, JS = 2 corresponds to the paramter value 1/8, 
!     JS = 3 corresponds to the parameter value 2/8, etc.  The second index
!     in the array, JT, which runs from 1 to 5, corresponds to different
!     temperatures.  More specifically, JT = 3 means that the data are for
!     the reference temperature TREF for this  pressure level, JT = 2 refers
!     to TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and JT = 5
!     is for TREF+30.  The third index, JP, runs from 1 to 13 and refers
!     to the JPth reference pressure level (see taumol.f for these levels
!     in mb).  The fourth index, IG, goes from 1 to 16, and indicates
!     which g-interval the absorption coefficients are for.
!     -----------------------------------------------------------------

      kao(:, 1, 1, 1) = (/ &
        & 0.14981e-05,0.26659e-05,0.31874e-05,0.35509e-05,0.37593e-05, &
        & 0.38514e-05,0.37369e-05,0.35011e-05,0.23894e-05 /)
      kao(:, 2, 1, 1) = (/ &
        & 0.15103e-05,0.27348e-05,0.32692e-05,0.36558e-05,0.38926e-05, &
        & 0.39737e-05,0.38798e-05,0.36565e-05,0.24072e-05 /)
      kao(:, 3, 1, 1) = (/ &
        & 0.15233e-05,0.28090e-05,0.33744e-05,0.37729e-05,0.40258e-05, &
        & 0.41107e-05,0.40389e-05,0.38226e-05,0.24704e-05 /)
      kao(:, 4, 1, 1) = (/ &
        & 0.15219e-05,0.28978e-05,0.35015e-05,0.38984e-05,0.41569e-05, &
        & 0.42771e-05,0.42110e-05,0.39963e-05,0.25504e-05 /)
      kao(:, 5, 1, 1) = (/ &
        & 0.15254e-05,0.29633e-05,0.36224e-05,0.40435e-05,0.42975e-05, &
        & 0.44410e-05,0.43849e-05,0.41847e-05,0.26420e-05 /)
      kao(:, 1, 2, 1) = (/ &
        & 0.13024e-05,0.23699e-05,0.28370e-05,0.31443e-05,0.33326e-05, &
        & 0.33798e-05,0.32797e-05,0.30078e-05,0.18819e-05 /)
      kao(:, 2, 2, 1) = (/ &
        & 0.13249e-05,0.24299e-05,0.29103e-05,0.32336e-05,0.34308e-05, &
        & 0.35019e-05,0.34046e-05,0.31323e-05,0.19511e-05 /)
      kao(:, 3, 2, 1) = (/ &
        & 0.13241e-05,0.25059e-05,0.30019e-05,0.33317e-05,0.35516e-05, &
        & 0.36333e-05,0.35372e-05,0.32615e-05,0.20254e-05 /)
      kao(:, 4, 2, 1) = (/ &
        & 0.13325e-05,0.25840e-05,0.31009e-05,0.34399e-05,0.36699e-05, &
        & 0.37727e-05,0.36811e-05,0.34016e-05,0.20611e-05 /)
      kao(:, 5, 2, 1) = (/ &
        & 0.13321e-05,0.26601e-05,0.32189e-05,0.35640e-05,0.38012e-05, &
        & 0.39113e-05,0.38271e-05,0.35499e-05,0.21368e-05 /)
      kao(:, 1, 3, 1) = (/ &
        & 0.11079e-05,0.20757e-05,0.24846e-05,0.27511e-05,0.28883e-05, &
        & 0.29142e-05,0.28203e-05,0.25706e-05,0.15124e-05 /)
      kao(:, 2, 3, 1) = (/ &
        & 0.11298e-05,0.21278e-05,0.25551e-05,0.28306e-05,0.29814e-05, &
        & 0.30126e-05,0.29328e-05,0.26721e-05,0.15784e-05 /)
      kao(:, 3, 3, 1) = (/ &
        & 0.11405e-05,0.21812e-05,0.26237e-05,0.29130e-05,0.30816e-05, &
        & 0.31265e-05,0.30480e-05,0.27784e-05,0.16468e-05 /)
      kao(:, 4, 3, 1) = (/ &
        & 0.11347e-05,0.22472e-05,0.27094e-05,0.30057e-05,0.31821e-05, &
        & 0.32536e-05,0.31714e-05,0.28837e-05,0.17189e-05 /)
      kao(:, 5, 3, 1) = (/ &
        & 0.11383e-05,0.23152e-05,0.28016e-05,0.31126e-05,0.33051e-05, &
        & 0.33759e-05,0.32961e-05,0.29993e-05,0.17919e-05 /)
      kao(:, 1, 4, 1) = (/ &
        & 0.93104e-06,0.18005e-05,0.21693e-05,0.23819e-05,0.24829e-05, &
        & 0.24860e-05,0.23860e-05,0.21586e-05,0.12198e-05 /)
      kao(:, 2, 4, 1) = (/ &
        & 0.94591e-06,0.18309e-05,0.22153e-05,0.24487e-05,0.25574e-05, &
        & 0.25721e-05,0.24802e-05,0.22458e-05,0.13105e-05 /)
      kao(:, 3, 4, 1) = (/ &
        & 0.95638e-06,0.18753e-05,0.22788e-05,0.25149e-05,0.26499e-05, &
        & 0.26671e-05,0.25797e-05,0.23335e-05,0.14017e-05 /)
      kao(:, 4, 4, 1) = (/ &
        & 0.95763e-06,0.19379e-05,0.23271e-05,0.25858e-05,0.27437e-05, &
        & 0.27792e-05,0.26790e-05,0.24268e-05,0.14872e-05 /)
      kao(:, 5, 4, 1) = (/ &
        & 0.95668e-06,0.19877e-05,0.23997e-05,0.26721e-05,0.28382e-05, &
        & 0.28806e-05,0.27857e-05,0.25225e-05,0.15698e-05 /)
      kao(:, 1, 5, 1) = (/ &
        & 0.77329e-06,0.15354e-05,0.18723e-05,0.20411e-05,0.21095e-05, &
        & 0.21017e-05,0.19998e-05,0.18017e-05,0.97629e-06 /)
      kao(:, 2, 5, 1) = (/ &
        & 0.78241e-06,0.15660e-05,0.19091e-05,0.20970e-05,0.21786e-05, &
        & 0.21730e-05,0.20794e-05,0.18731e-05,0.10645e-05 /)
      kao(:, 3, 5, 1) = (/ &
        & 0.79463e-06,0.15948e-05,0.19458e-05,0.21529e-05,0.22557e-05, &
        & 0.22576e-05,0.21631e-05,0.19462e-05,0.11507e-05 /)
      kao(:, 4, 5, 1) = (/ &
        & 0.79779e-06,0.16389e-05,0.19877e-05,0.22087e-05,0.23274e-05, &
        & 0.23462e-05,0.22501e-05,0.20204e-05,0.12366e-05 /)
      kao(:, 5, 5, 1) = (/ &
        & 0.79875e-06,0.16865e-05,0.20410e-05,0.22789e-05,0.24049e-05, &
        & 0.24283e-05,0.23388e-05,0.21006e-05,0.13155e-05 /)
      kao(:, 1, 6, 1) = (/ &
        & 0.63799e-06,0.13079e-05,0.15873e-05,0.17187e-05,0.17689e-05, &
        & 0.17509e-05,0.16625e-05,0.14950e-05,0.77624e-06 /)
      kao(:, 2, 6, 1) = (/ &
        & 0.64423e-06,0.13180e-05,0.16173e-05,0.17648e-05,0.18253e-05, &
        & 0.18152e-05,0.17299e-05,0.15482e-05,0.85457e-06 /)
      kao(:, 3, 6, 1) = (/ &
        & 0.65214e-06,0.13481e-05,0.16476e-05,0.18158e-05,0.18867e-05, &
        & 0.18859e-05,0.17999e-05,0.16080e-05,0.93968e-06 /)
      kao(:, 4, 6, 1) = (/ &
        & 0.65949e-06,0.13728e-05,0.16795e-05,0.18618e-05,0.19507e-05, &
        & 0.19568e-05,0.18693e-05,0.16710e-05,0.10256e-05 /)
      kao(:, 5, 6, 1) = (/ &
        & 0.66012e-06,0.14051e-05,0.17174e-05,0.19154e-05,0.20111e-05, &
        & 0.20230e-05,0.19421e-05,0.17361e-05,0.11072e-05 /)
      kao(:, 1, 7, 1) = (/ &
        & 0.52652e-06,0.10995e-05,0.13221e-05,0.14282e-05,0.14627e-05, &
        & 0.14494e-05,0.13754e-05,0.12359e-05,0.62399e-06 /)
      kao(:, 2, 7, 1) = (/ &
        & 0.52631e-06,0.11047e-05,0.13498e-05,0.14646e-05,0.15094e-05, &
        & 0.14961e-05,0.14272e-05,0.12791e-05,0.69692e-06 /)
      kao(:, 3, 7, 1) = (/ &
        & 0.53263e-06,0.11231e-05,0.13763e-05,0.15059e-05,0.15602e-05, &
        & 0.15533e-05,0.14827e-05,0.13257e-05,0.76959e-06 /)
      kao(:, 4, 7, 1) = (/ &
        & 0.53788e-06,0.11448e-05,0.14026e-05,0.15478e-05,0.16122e-05, &
        & 0.16137e-05,0.15398e-05,0.13748e-05,0.84488e-06 /)
      kao(:, 5, 7, 1) = (/ &
        & 0.54243e-06,0.11660e-05,0.14288e-05,0.15891e-05,0.16619e-05, &
        & 0.16672e-05,0.15978e-05,0.14265e-05,0.92439e-06 /)
      kao(:, 1, 8, 1) = (/ &
        & 0.42860e-06,0.91208e-06,0.10887e-05,0.11732e-05,0.12000e-05, &
        & 0.11901e-05,0.11300e-05,0.10181e-05,0.51360e-06 /)
      kao(:, 2, 8, 1) = (/ &
        & 0.42605e-06,0.91355e-06,0.11105e-05,0.12004e-05,0.12359e-05, &
        & 0.12238e-05,0.11674e-05,0.10496e-05,0.58593e-06 /)
      kao(:, 3, 8, 1) = (/ &
        & 0.42910e-06,0.92458e-06,0.11341e-05,0.12355e-05,0.12754e-05, &
        & 0.12667e-05,0.12100e-05,0.10877e-05,0.65209e-06 /)
      kao(:, 4, 8, 1) = (/ &
        & 0.43345e-06,0.94024e-06,0.11540e-05,0.12669e-05,0.13186e-05, &
        & 0.13163e-05,0.12567e-05,0.11280e-05,0.72051e-06 /)
      kao(:, 5, 8, 1) = (/ &
        & 0.43744e-06,0.95845e-06,0.11764e-05,0.13022e-05,0.13595e-05, &
        & 0.13618e-05,0.13034e-05,0.11671e-05,0.79373e-06 /)
      kao(:, 1, 9, 1) = (/ &
        & 0.34458e-06,0.74844e-06,0.89217e-06,0.95875e-06,0.98243e-06, &
        & 0.97566e-06,0.92936e-06,0.83611e-06,0.44181e-06 /)
      kao(:, 2, 9, 1) = (/ &
        & 0.34797e-06,0.75304e-06,0.90816e-06,0.98264e-06,0.10080e-05, &
        & 0.99889e-06,0.95318e-06,0.86041e-06,0.51013e-06 /)
      kao(:, 3, 9, 1) = (/ &
        & 0.34593e-06,0.76020e-06,0.92707e-06,0.10062e-05,0.10391e-05, &
        & 0.10296e-05,0.98530e-06,0.89011e-06,0.58070e-06 /)
      kao(:, 4, 9, 1) = (/ &
        & 0.34971e-06,0.77088e-06,0.94623e-06,0.10342e-05,0.10726e-05, &
        & 0.10689e-05,0.10210e-05,0.92020e-06,0.65697e-06 /)
      kao(:, 5, 9, 1) = (/ &
        & 0.35282e-06,0.78517e-06,0.96245e-06,0.10609e-05,0.11071e-05, &
        & 0.11073e-05,0.10583e-05,0.95054e-06,0.72956e-06 /)
      kao(:, 1,10, 1) = (/ &
        & 0.27840e-06,0.61035e-06,0.72930e-06,0.78415e-06,0.80451e-06, &
        & 0.79924e-06,0.76231e-06,0.68727e-06,0.40208e-06 /)
      kao(:, 2,10, 1) = (/ &
        & 0.28171e-06,0.61798e-06,0.74197e-06,0.80115e-06,0.82183e-06, &
        & 0.81621e-06,0.78030e-06,0.70425e-06,0.46700e-06 /)
      kao(:, 3,10, 1) = (/ &
        & 0.28023e-06,0.62269e-06,0.75685e-06,0.82101e-06,0.84538e-06, &
        & 0.83821e-06,0.80301e-06,0.72663e-06,0.53781e-06 /)
      kao(:, 4,10, 1) = (/ &
        & 0.28163e-06,0.63156e-06,0.77214e-06,0.84244e-06,0.87184e-06, &
        & 0.86752e-06,0.83024e-06,0.75000e-06,0.60478e-06 /)
      kao(:, 5,10, 1) = (/ &
        & 0.28518e-06,0.64070e-06,0.78628e-06,0.86439e-06,0.89969e-06, &
        & 0.89910e-06,0.85933e-06,0.77376e-06,0.67016e-06 /)
      kao(:, 1,11, 1) = (/ &
        & 0.22555e-06,0.50042e-06,0.59960e-06,0.64537e-06,0.66324e-06, &
        & 0.65924e-06,0.63003e-06,0.56890e-06,0.34466e-06 /)
      kao(:, 2,11, 1) = (/ &
        & 0.22858e-06,0.50705e-06,0.60997e-06,0.65948e-06,0.67688e-06, &
        & 0.67311e-06,0.64462e-06,0.58333e-06,0.40300e-06 /)
      kao(:, 3,11, 1) = (/ &
        & 0.22677e-06,0.51178e-06,0.62299e-06,0.67572e-06,0.69624e-06, &
        & 0.69126e-06,0.66285e-06,0.60090e-06,0.46066e-06 /)
      kao(:, 4,11, 1) = (/ &
        & 0.22825e-06,0.51907e-06,0.63500e-06,0.69311e-06,0.71796e-06, &
        & 0.71484e-06,0.68416e-06,0.61859e-06,0.51966e-06 /)
      kao(:, 5,11, 1) = (/ &
        & 0.23122e-06,0.52598e-06,0.64574e-06,0.71116e-06,0.74046e-06, &
        & 0.73979e-06,0.70672e-06,0.63708e-06,0.58196e-06 /)
      kao(:, 1,12, 1) = (/ &
        & 0.18149e-06,0.40829e-06,0.49022e-06,0.52910e-06,0.54408e-06, &
        & 0.54163e-06,0.51867e-06,0.46933e-06,0.28496e-06 /)
      kao(:, 2,12, 1) = (/ &
        & 0.18433e-06,0.41378e-06,0.49908e-06,0.54027e-06,0.55522e-06, &
        & 0.55286e-06,0.53038e-06,0.48103e-06,0.33336e-06 /)
      kao(:, 3,12, 1) = (/ &
        & 0.18246e-06,0.41799e-06,0.50965e-06,0.55347e-06,0.57134e-06, &
        & 0.56787e-06,0.54477e-06,0.49462e-06,0.38023e-06 /)
      kao(:, 4,12, 1) = (/ &
        & 0.18409e-06,0.42347e-06,0.51936e-06,0.56749e-06,0.58877e-06, &
        & 0.58648e-06,0.56149e-06,0.50825e-06,0.43081e-06 /)
      kao(:, 5,12, 1) = (/ &
        & 0.18582e-06,0.42888e-06,0.52830e-06,0.58240e-06,0.60647e-06, &
        & 0.60598e-06,0.57933e-06,0.52277e-06,0.48565e-06 /)
      kao(:, 1,13, 1) = (/ &
        & 0.14345e-06,0.32927e-06,0.39750e-06,0.43000e-06,0.44318e-06, &
        & 0.44201e-06,0.42469e-06,0.38538e-06,0.23377e-06 /)
      kao(:, 2,13, 1) = (/ &
        & 0.14571e-06,0.33355e-06,0.40430e-06,0.43954e-06,0.45256e-06, &
        & 0.45159e-06,0.43399e-06,0.39467e-06,0.27338e-06 /)
      kao(:, 3,13, 1) = (/ &
        & 0.14442e-06,0.33719e-06,0.41316e-06,0.44996e-06,0.46575e-06, &
        & 0.46364e-06,0.44528e-06,0.40510e-06,0.31154e-06 /)
      kao(:, 4,13, 1) = (/ &
        & 0.14600e-06,0.34141e-06,0.42136e-06,0.46096e-06,0.47937e-06, &
        & 0.47817e-06,0.45850e-06,0.41598e-06,0.35289e-06 /)
      kao(:, 5,13, 1) = (/ &
        & 0.14667e-06,0.34608e-06,0.42853e-06,0.47296e-06,0.49300e-06, &
        & 0.49352e-06,0.47280e-06,0.42757e-06,0.39752e-06 /)
      kao(:, 1, 1, 2) = (/ &
        & 0.16288e-04,0.25817e-04,0.29597e-04,0.31319e-04,0.31220e-04, &
        & 0.29539e-04,0.25627e-04,0.19758e-04,0.72944e-05 /)
      kao(:, 2, 1, 2) = (/ &
        & 0.18123e-04,0.28565e-04,0.32633e-04,0.34427e-04,0.34219e-04, &
        & 0.32223e-04,0.27987e-04,0.21485e-04,0.79554e-05 /)
      kao(:, 3, 1, 2) = (/ &
        & 0.19957e-04,0.31607e-04,0.36033e-04,0.37887e-04,0.37694e-04, &
        & 0.35399e-04,0.30718e-04,0.23412e-04,0.85293e-05 /)
      kao(:, 4, 1, 2) = (/ &
        & 0.22005e-04,0.35064e-04,0.39763e-04,0.41694e-04,0.41490e-04, &
        & 0.38891e-04,0.33715e-04,0.25512e-04,0.91232e-05 /)
      kao(:, 5, 1, 2) = (/ &
        & 0.24240e-04,0.38906e-04,0.43899e-04,0.45870e-04,0.45580e-04, &
        & 0.42616e-04,0.36912e-04,0.27728e-04,0.97792e-05 /)
      kao(:, 1, 2, 2) = (/ &
        & 0.14944e-04,0.23223e-04,0.25792e-04,0.27019e-04,0.26963e-04, &
        & 0.25431e-04,0.22069e-04,0.16933e-04,0.59071e-05 /)
      kao(:, 2, 2, 2) = (/ &
        & 0.16615e-04,0.25452e-04,0.28322e-04,0.29800e-04,0.29593e-04, &
        & 0.27776e-04,0.24123e-04,0.18444e-04,0.63142e-05 /)
      kao(:, 3, 2, 2) = (/ &
        & 0.18355e-04,0.27996e-04,0.31338e-04,0.32892e-04,0.32575e-04, &
        & 0.30478e-04,0.26504e-04,0.20132e-04,0.67898e-05 /)
      kao(:, 4, 2, 2) = (/ &
        & 0.20092e-04,0.30938e-04,0.34680e-04,0.36255e-04,0.35836e-04, &
        & 0.33500e-04,0.29106e-04,0.21950e-04,0.73343e-05 /)
      kao(:, 5, 2, 2) = (/ &
        & 0.21897e-04,0.34150e-04,0.38274e-04,0.39931e-04,0.39337e-04, &
        & 0.36752e-04,0.31831e-04,0.23882e-04,0.78705e-05 /)
      kao(:, 1, 3, 2) = (/ &
        & 0.13130e-04,0.20363e-04,0.22377e-04,0.23003e-04,0.22683e-04, &
        & 0.21429e-04,0.18621e-04,0.14177e-04,0.47892e-05 /)
      kao(:, 2, 3, 2) = (/ &
        & 0.14610e-04,0.22299e-04,0.24486e-04,0.25140e-04,0.24842e-04, &
        & 0.23413e-04,0.20361e-04,0.15469e-04,0.52250e-05 /)
      kao(:, 3, 3, 2) = (/ &
        & 0.16133e-04,0.24482e-04,0.26876e-04,0.27653e-04,0.27357e-04, &
        & 0.25669e-04,0.22341e-04,0.16897e-04,0.56647e-05 /)
      kao(:, 4, 3, 2) = (/ &
        & 0.17708e-04,0.26887e-04,0.29522e-04,0.30577e-04,0.30151e-04, &
        & 0.28221e-04,0.24545e-04,0.18455e-04,0.60735e-05 /)
      kao(:, 5, 3, 2) = (/ &
        & 0.19305e-04,0.29364e-04,0.32520e-04,0.33741e-04,0.33162e-04, &
        & 0.30976e-04,0.26800e-04,0.20103e-04,0.64864e-05 /)
      kao(:, 1, 4, 2) = (/ &
        & 0.11163e-04,0.17498e-04,0.19069e-04,0.19561e-04,0.19154e-04, &
        & 0.17906e-04,0.15522e-04,0.11778e-04,0.40461e-05 /)
      kao(:, 2, 4, 2) = (/ &
        & 0.12505e-04,0.19238e-04,0.20917e-04,0.21365e-04,0.20913e-04, &
        & 0.19471e-04,0.16986e-04,0.12856e-04,0.43935e-05 /)
      kao(:, 3, 4, 2) = (/ &
        & 0.13848e-04,0.21132e-04,0.22975e-04,0.23433e-04,0.22893e-04, &
        & 0.21327e-04,0.18662e-04,0.14056e-04,0.47015e-05 /)
      kao(:, 4, 4, 2) = (/ &
        & 0.15219e-04,0.23159e-04,0.25250e-04,0.25753e-04,0.25088e-04, &
        & 0.23437e-04,0.20455e-04,0.15366e-04,0.50239e-05 /)
      kao(:, 5, 4, 2) = (/ &
        & 0.16631e-04,0.25311e-04,0.27651e-04,0.28243e-04,0.27566e-04, &
        & 0.25775e-04,0.22344e-04,0.16758e-04,0.53594e-05 /)
      kao(:, 1, 5, 2) = (/ &
        & 0.92688e-05,0.14829e-04,0.16036e-04,0.16388e-04,0.16087e-04, &
        & 0.15049e-04,0.12939e-04,0.97243e-05,0.35064e-05 /)
      kao(:, 2, 5, 2) = (/ &
        & 0.10428e-04,0.16289e-04,0.17596e-04,0.17928e-04,0.17547e-04, &
        & 0.16347e-04,0.14108e-04,0.10621e-04,0.37893e-05 /)
      kao(:, 3, 5, 2) = (/ &
        & 0.11600e-04,0.17922e-04,0.19403e-04,0.19701e-04,0.19227e-04, &
        & 0.17835e-04,0.15439e-04,0.11627e-04,0.40426e-05 /)
      kao(:, 4, 5, 2) = (/ &
        & 0.12795e-04,0.19672e-04,0.21360e-04,0.21677e-04,0.21078e-04, &
        & 0.19535e-04,0.16919e-04,0.12746e-04,0.43015e-05 /)
      kao(:, 5, 5, 2) = (/ &
        & 0.14029e-04,0.21551e-04,0.23410e-04,0.23746e-04,0.23106e-04, &
        & 0.21397e-04,0.18500e-04,0.13918e-04,0.45663e-05 /)
      kao(:, 1, 6, 2) = (/ &
        & 0.75358e-05,0.12284e-04,0.13321e-04,0.13580e-04,0.13322e-04, &
        & 0.12459e-04,0.10757e-04,0.80012e-05,0.28595e-05 /)
      kao(:, 2, 6, 2) = (/ &
        & 0.84801e-05,0.13541e-04,0.14600e-04,0.14857e-04,0.14519e-04, &
        & 0.13528e-04,0.11747e-04,0.87199e-05,0.31250e-05 /)
      kao(:, 3, 6, 2) = (/ &
        & 0.94797e-05,0.14898e-04,0.16088e-04,0.16329e-04,0.15922e-04, &
        & 0.14786e-04,0.12839e-04,0.95406e-05,0.33925e-05 /)
      kao(:, 4, 6, 2) = (/ &
        & 0.10510e-04,0.16387e-04,0.17709e-04,0.17968e-04,0.17465e-04, &
        & 0.16205e-04,0.13999e-04,0.10465e-04,0.36786e-05 /)
      kao(:, 5, 6, 2) = (/ &
        & 0.11554e-04,0.17973e-04,0.19442e-04,0.19736e-04,0.19170e-04, &
        & 0.17751e-04,0.15288e-04,0.11441e-04,0.39618e-05 /)
      kao(:, 1, 7, 2) = (/ &
        & 0.59994e-05,0.10068e-04,0.10903e-04,0.11100e-04,0.10910e-04, &
        & 0.10207e-04,0.88301e-05,0.65755e-05,0.23537e-05 /)
      kao(:, 2, 7, 2) = (/ &
        & 0.67911e-05,0.11098e-04,0.11964e-04,0.12161e-04,0.11910e-04, &
        & 0.11113e-04,0.96475e-05,0.71733e-05,0.26021e-05 /)
      kao(:, 3, 7, 2) = (/ &
        & 0.76012e-05,0.12205e-04,0.13167e-04,0.13368e-04,0.13058e-04, &
        & 0.12136e-04,0.10571e-04,0.78452e-05,0.28416e-05 /)
      kao(:, 4, 7, 2) = (/ &
        & 0.84582e-05,0.13412e-04,0.14518e-04,0.14721e-04,0.14328e-04, &
        & 0.13323e-04,0.11527e-04,0.85995e-05,0.30925e-05 /)
      kao(:, 5, 7, 2) = (/ &
        & 0.93346e-05,0.14749e-04,0.15973e-04,0.16180e-04,0.15730e-04, &
        & 0.14597e-04,0.12601e-04,0.93973e-05,0.33285e-05 /)
      kao(:, 1, 8, 2) = (/ &
        & 0.47174e-05,0.81367e-05,0.88184e-05,0.90007e-05,0.88363e-05, &
        & 0.83059e-05,0.72101e-05,0.53496e-05,0.18862e-05 /)
      kao(:, 2, 8, 2) = (/ &
        & 0.53543e-05,0.89852e-05,0.96904e-05,0.98666e-05,0.96509e-05, &
        & 0.90368e-05,0.78700e-05,0.58341e-05,0.21147e-05 /)
      kao(:, 3, 8, 2) = (/ &
        & 0.60088e-05,0.98855e-05,0.10666e-04,0.10849e-04,0.10597e-04, &
        & 0.98826e-05,0.86243e-05,0.63949e-05,0.23672e-05 /)
      kao(:, 4, 8, 2) = (/ &
        & 0.66958e-05,0.10873e-04,0.11751e-04,0.11945e-04,0.11636e-04, &
        & 0.10852e-04,0.94101e-05,0.70262e-05,0.26329e-05 /)
      kao(:, 5, 8, 2) = (/ &
        & 0.74191e-05,0.11960e-04,0.12943e-04,0.13152e-04,0.12788e-04, &
        & 0.11889e-04,0.10297e-04,0.76977e-05,0.29019e-05 /)
      kao(:, 1, 9, 2) = (/ &
        & 0.36886e-05,0.65140e-05,0.70684e-05,0.72377e-05,0.71080e-05, &
        & 0.67076e-05,0.58353e-05,0.43297e-05,0.16419e-05 /)
      kao(:, 2, 9, 2) = (/ &
        & 0.41772e-05,0.72104e-05,0.77793e-05,0.79335e-05,0.77682e-05, &
        & 0.72903e-05,0.63640e-05,0.47210e-05,0.18721e-05 /)
      kao(:, 3, 9, 2) = (/ &
        & 0.47123e-05,0.79471e-05,0.85662e-05,0.87396e-05,0.85319e-05, &
        & 0.79769e-05,0.69694e-05,0.51793e-05,0.21015e-05 /)
      kao(:, 4, 9, 2) = (/ &
        & 0.52612e-05,0.87319e-05,0.94365e-05,0.96191e-05,0.93783e-05, &
        & 0.87581e-05,0.76277e-05,0.56974e-05,0.23505e-05 /)
      kao(:, 5, 9, 2) = (/ &
        & 0.58401e-05,0.96106e-05,0.10404e-04,0.10594e-04,0.10308e-04, &
        & 0.96030e-05,0.83402e-05,0.62627e-05,0.26170e-05 /)
      kao(:, 1,10, 2) = (/ &
        & 0.29023e-05,0.52230e-05,0.56669e-05,0.58158e-05,0.57137e-05, &
        & 0.54241e-05,0.47416e-05,0.35098e-05,0.14223e-05 /)
      kao(:, 2,10, 2) = (/ &
        & 0.32752e-05,0.57903e-05,0.62548e-05,0.63859e-05,0.62528e-05, &
        & 0.58881e-05,0.51542e-05,0.38257e-05,0.16559e-05 /)
      kao(:, 3,10, 2) = (/ &
        & 0.37047e-05,0.63892e-05,0.68928e-05,0.70312e-05,0.68734e-05, &
        & 0.64357e-05,0.56361e-05,0.42003e-05,0.19248e-05 /)
      kao(:, 4,10, 2) = (/ &
        & 0.41471e-05,0.70179e-05,0.75920e-05,0.77496e-05,0.75508e-05, &
        & 0.70624e-05,0.61778e-05,0.46271e-05,0.22074e-05 /)
      kao(:, 5,10, 2) = (/ &
        & 0.46061e-05,0.77215e-05,0.83699e-05,0.85300e-05,0.83121e-05, &
        & 0.77493e-05,0.67551e-05,0.50931e-05,0.25043e-05 /)
      kao(:, 1,11, 2) = (/ &
        & 0.24060e-05,0.43752e-05,0.47372e-05,0.48598e-05,0.47689e-05, &
        & 0.45290e-05,0.39653e-05,0.29444e-05,0.12255e-05 /)
      kao(:, 2,11, 2) = (/ &
        & 0.27123e-05,0.48479e-05,0.52339e-05,0.53482e-05,0.52342e-05, &
        & 0.49275e-05,0.43239e-05,0.32196e-05,0.14282e-05 /)
      kao(:, 3,11, 2) = (/ &
        & 0.30632e-05,0.53402e-05,0.57660e-05,0.58936e-05,0.57515e-05, &
        & 0.53873e-05,0.47344e-05,0.35410e-05,0.16636e-05 /)
      kao(:, 4,11, 2) = (/ &
        & 0.34245e-05,0.58653e-05,0.63554e-05,0.64878e-05,0.63244e-05, &
        & 0.59147e-05,0.51855e-05,0.39068e-05,0.18858e-05 /)
      kao(:, 5,11, 2) = (/ &
        & 0.37984e-05,0.64557e-05,0.70032e-05,0.71432e-05,0.69591e-05, &
        & 0.64936e-05,0.56748e-05,0.42889e-05,0.21529e-05 /)
      kao(:, 1,12, 2) = (/ &
        & 0.19822e-05,0.36438e-05,0.39439e-05,0.40428e-05,0.39656e-05, &
        & 0.37627e-05,0.33048e-05,0.24620e-05,0.10349e-05 /)
      kao(:, 2,12, 2) = (/ &
        & 0.22347e-05,0.40329e-05,0.43559e-05,0.44535e-05,0.43556e-05, &
        & 0.41018e-05,0.36156e-05,0.26976e-05,0.12078e-05 /)
      kao(:, 3,12, 2) = (/ &
        & 0.25196e-05,0.44405e-05,0.47965e-05,0.49025e-05,0.47850e-05, &
        & 0.44854e-05,0.39542e-05,0.29734e-05,0.13908e-05 /)
      kao(:, 4,12, 2) = (/ &
        & 0.28142e-05,0.48792e-05,0.52882e-05,0.53962e-05,0.52646e-05, &
        & 0.49202e-05,0.43229e-05,0.32817e-05,0.15895e-05 /)
      kao(:, 5,12, 2) = (/ &
        & 0.31182e-05,0.53684e-05,0.58256e-05,0.59413e-05,0.57855e-05, &
        & 0.54043e-05,0.47298e-05,0.35925e-05,0.18050e-05 /)
      kao(:, 1,13, 2) = (/ &
        & 0.16206e-05,0.30122e-05,0.32612e-05,0.33451e-05,0.32794e-05, &
        & 0.31144e-05,0.27430e-05,0.20488e-05,0.85267e-06 /)
      kao(:, 2,13, 2) = (/ &
        & 0.18267e-05,0.33331e-05,0.36002e-05,0.36816e-05,0.36054e-05, &
        & 0.33950e-05,0.30021e-05,0.22487e-05,0.99490e-06 /)
      kao(:, 3,13, 2) = (/ &
        & 0.20587e-05,0.36681e-05,0.39651e-05,0.40531e-05,0.39564e-05, &
        & 0.37127e-05,0.32815e-05,0.24795e-05,0.11422e-05 /)
      kao(:, 4,13, 2) = (/ &
        & 0.22973e-05,0.40325e-05,0.43728e-05,0.44600e-05,0.43540e-05, &
        & 0.40718e-05,0.35848e-05,0.27366e-05,0.13051e-05 /)
      kao(:, 5,13, 2) = (/ &
        & 0.25452e-05,0.44379e-05,0.48164e-05,0.49100e-05,0.47833e-05, &
        & 0.44674e-05,0.39194e-05,0.29904e-05,0.14817e-05 /)
      kao(:, 1, 1, 3) = (/ &
        & 0.66641e-04,0.92990e-04,0.96277e-04,0.95182e-04,0.91424e-04, &
        & 0.85445e-04,0.77014e-04,0.62091e-04,0.18284e-04 /)
      kao(:, 2, 1, 3) = (/ &
        & 0.75350e-04,0.10391e-03,0.10751e-03,0.10606e-03,0.10174e-03, &
        & 0.94756e-04,0.84487e-04,0.67267e-04,0.20037e-04 /)
      kao(:, 3, 1, 3) = (/ &
        & 0.85286e-04,0.11563e-03,0.11966e-03,0.11777e-03,0.11259e-03, &
        & 0.10435e-03,0.92076e-04,0.72492e-04,0.22229e-04 /)
      kao(:, 4, 1, 3) = (/ &
        & 0.96137e-04,0.12836e-03,0.13265e-03,0.13031e-03,0.12404e-03, &
        & 0.11409e-03,0.99756e-04,0.77897e-04,0.24656e-04 /)
      kao(:, 5, 1, 3) = (/ &
        & 0.10739e-03,0.14209e-03,0.14652e-03,0.14363e-03,0.13579e-03, &
        & 0.12408e-03,0.10749e-03,0.83273e-04,0.26998e-04 /)
      kao(:, 1, 2, 3) = (/ &
        & 0.57005e-04,0.80688e-04,0.84199e-04,0.83067e-04,0.79480e-04, &
        & 0.74096e-04,0.66328e-04,0.53532e-04,0.14534e-04 /)
      kao(:, 2, 2, 3) = (/ &
        & 0.64518e-04,0.90274e-04,0.94149e-04,0.92496e-04,0.88374e-04, &
        & 0.82048e-04,0.72698e-04,0.57871e-04,0.16202e-04 /)
      kao(:, 3, 2, 3) = (/ &
        & 0.73014e-04,0.10065e-03,0.10466e-03,0.10271e-03,0.97880e-04, &
        & 0.90372e-04,0.79361e-04,0.62357e-04,0.18056e-04 /)
      kao(:, 4, 2, 3) = (/ &
        & 0.82297e-04,0.11195e-03,0.11586e-03,0.11365e-03,0.10799e-03, &
        & 0.98829e-04,0.85923e-04,0.66891e-04,0.19890e-04 /)
      kao(:, 5, 2, 3) = (/ &
        & 0.92175e-04,0.12399e-03,0.12794e-03,0.12531e-03,0.11825e-03, &
        & 0.10764e-03,0.92744e-04,0.71608e-04,0.21968e-04 /)
      kao(:, 1, 3, 3) = (/ &
        & 0.47324e-04,0.68167e-04,0.71069e-04,0.70293e-04,0.67313e-04, &
        & 0.62456e-04,0.55646e-04,0.44933e-04,0.11374e-04 /)
      kao(:, 2, 3, 3) = (/ &
        & 0.53658e-04,0.76342e-04,0.79560e-04,0.78547e-04,0.74997e-04, &
        & 0.69264e-04,0.61119e-04,0.48587e-04,0.12639e-04 /)
      kao(:, 3, 3, 3) = (/ &
        & 0.60905e-04,0.85247e-04,0.88738e-04,0.87387e-04,0.83098e-04, &
        & 0.76432e-04,0.66733e-04,0.52275e-04,0.13871e-04 /)
      kao(:, 4, 3, 3) = (/ &
        & 0.68831e-04,0.94960e-04,0.98638e-04,0.96778e-04,0.91816e-04, &
        & 0.83747e-04,0.72403e-04,0.56165e-04,0.15423e-04 /)
      kao(:, 5, 3, 3) = (/ &
        & 0.77259e-04,0.10549e-03,0.10909e-03,0.10672e-03,0.10065e-03, &
        & 0.91320e-04,0.78406e-04,0.60157e-04,0.17141e-04 /)
      kao(:, 1, 4, 3) = (/ &
        & 0.40102e-04,0.56990e-04,0.59444e-04,0.58732e-04,0.56091e-04, &
        & 0.51902e-04,0.46247e-04,0.37442e-04,0.94022e-05 /)
      kao(:, 2, 4, 3) = (/ &
        & 0.44930e-04,0.63893e-04,0.66629e-04,0.65694e-04,0.62627e-04, &
        & 0.57822e-04,0.50819e-04,0.40421e-04,0.10475e-04 /)
      kao(:, 3, 4, 3) = (/ &
        & 0.50532e-04,0.71424e-04,0.74352e-04,0.73221e-04,0.69651e-04, &
        & 0.64034e-04,0.55430e-04,0.43529e-04,0.11728e-04 /)
      kao(:, 4, 4, 3) = (/ &
        & 0.56953e-04,0.79740e-04,0.82769e-04,0.81314e-04,0.77278e-04, &
        & 0.70324e-04,0.60396e-04,0.46747e-04,0.13063e-04 /)
      kao(:, 5, 4, 3) = (/ &
        & 0.64019e-04,0.88647e-04,0.91768e-04,0.89926e-04,0.84958e-04, &
        & 0.76740e-04,0.65561e-04,0.50066e-04,0.14435e-04 /)
      kao(:, 1, 5, 3) = (/ &
        & 0.33806e-04,0.47826e-04,0.49443e-04,0.48775e-04,0.46477e-04, &
        & 0.42791e-04,0.38155e-04,0.31175e-04,0.77886e-05 /)
      kao(:, 2, 5, 3) = (/ &
        & 0.37973e-04,0.53392e-04,0.55526e-04,0.54719e-04,0.52062e-04, &
        & 0.47763e-04,0.42021e-04,0.33510e-04,0.87404e-05 /)
      kao(:, 3, 5, 3) = (/ &
        & 0.42758e-04,0.59666e-04,0.62058e-04,0.61127e-04,0.58012e-04, &
        & 0.53071e-04,0.45971e-04,0.36114e-04,0.98499e-05 /)
      kao(:, 4, 5, 3) = (/ &
        & 0.48006e-04,0.66679e-04,0.69230e-04,0.67989e-04,0.64400e-04, &
        & 0.58521e-04,0.50196e-04,0.38710e-04,0.11022e-04 /)
      kao(:, 5, 5, 3) = (/ &
        & 0.53657e-04,0.74244e-04,0.76813e-04,0.75303e-04,0.71011e-04, &
        & 0.64092e-04,0.54599e-04,0.41481e-04,0.12225e-04 /)
      kao(:, 1, 6, 3) = (/ &
        & 0.27953e-04,0.40223e-04,0.41331e-04,0.40332e-04,0.38114e-04, &
        & 0.34967e-04,0.31158e-04,0.25701e-04,0.67604e-05 /)
      kao(:, 2, 6, 3) = (/ &
        & 0.31595e-04,0.44975e-04,0.46374e-04,0.45229e-04,0.42775e-04, &
        & 0.39162e-04,0.34373e-04,0.27616e-04,0.75558e-05 /)
      kao(:, 3, 6, 3) = (/ &
        & 0.35649e-04,0.50263e-04,0.51713e-04,0.50516e-04,0.47855e-04, &
        & 0.43605e-04,0.37705e-04,0.29800e-04,0.84063e-05 /)
      kao(:, 4, 6, 3) = (/ &
        & 0.40086e-04,0.55905e-04,0.57584e-04,0.56348e-04,0.53200e-04, &
        & 0.48283e-04,0.41331e-04,0.31936e-04,0.92686e-05 /)
      kao(:, 5, 6, 3) = (/ &
        & 0.44931e-04,0.62025e-04,0.63942e-04,0.62498e-04,0.58788e-04, &
        & 0.53032e-04,0.45085e-04,0.34229e-04,0.10175e-04 /)
      kao(:, 1, 7, 3) = (/ &
        & 0.22829e-04,0.33278e-04,0.34196e-04,0.33381e-04,0.31444e-04, &
        & 0.28615e-04,0.25331e-04,0.21096e-04,0.60732e-05 /)
      kao(:, 2, 7, 3) = (/ &
        & 0.25917e-04,0.37424e-04,0.38527e-04,0.37580e-04,0.35302e-04, &
        & 0.32020e-04,0.27957e-04,0.22660e-04,0.68180e-05 /)
      kao(:, 3, 7, 3) = (/ &
        & 0.29386e-04,0.41933e-04,0.43213e-04,0.42039e-04,0.39445e-04, &
        & 0.35659e-04,0.30780e-04,0.24432e-04,0.76296e-05 /)
      kao(:, 4, 7, 3) = (/ &
        & 0.33186e-04,0.46811e-04,0.48218e-04,0.46849e-04,0.43848e-04, &
        & 0.39567e-04,0.33858e-04,0.26257e-04,0.82634e-05 /)
      kao(:, 5, 7, 3) = (/ &
        & 0.37227e-04,0.52060e-04,0.53592e-04,0.51948e-04,0.48471e-04, &
        & 0.43595e-04,0.37022e-04,0.28130e-04,0.90053e-05 /)
      kao(:, 1, 8, 3) = (/ &
        & 0.18333e-04,0.27259e-04,0.27929e-04,0.27230e-04,0.25672e-04, &
        & 0.23374e-04,0.20571e-04,0.17333e-04,0.54157e-05 /)
      kao(:, 2, 8, 3) = (/ &
        & 0.20948e-04,0.30774e-04,0.31604e-04,0.30823e-04,0.29002e-04, &
        & 0.26292e-04,0.22734e-04,0.18593e-04,0.61669e-05 /)
      kao(:, 3, 8, 3) = (/ &
        & 0.23883e-04,0.34642e-04,0.35656e-04,0.34670e-04,0.32507e-04, &
        & 0.29303e-04,0.25111e-04,0.19985e-04,0.69048e-05 /)
      kao(:, 4, 8, 3) = (/ &
        & 0.27098e-04,0.38802e-04,0.40013e-04,0.38777e-04,0.36214e-04, &
        & 0.32542e-04,0.27674e-04,0.21526e-04,0.76591e-05 /)
      kao(:, 5, 8, 3) = (/ &
        & 0.30462e-04,0.43307e-04,0.44596e-04,0.43127e-04,0.40142e-04, &
        & 0.35890e-04,0.30276e-04,0.23065e-04,0.84480e-05 /)
      kao(:, 1, 9, 3) = (/ &
        & 0.14510e-04,0.22049e-04,0.22596e-04,0.22021e-04,0.20750e-04, &
        & 0.18895e-04,0.16685e-04,0.14158e-04,0.50284e-05 /)
      kao(:, 2, 9, 3) = (/ &
        & 0.16710e-04,0.25012e-04,0.25686e-04,0.25017e-04,0.23537e-04, &
        & 0.21350e-04,0.18517e-04,0.15170e-04,0.59016e-05 /)
      kao(:, 3, 9, 3) = (/ &
        & 0.19138e-04,0.28271e-04,0.29104e-04,0.28272e-04,0.26493e-04, &
        & 0.23916e-04,0.20530e-04,0.16297e-04,0.68413e-05 /)
      kao(:, 4, 9, 3) = (/ &
        & 0.21798e-04,0.31859e-04,0.32802e-04,0.31762e-04,0.29603e-04, &
        & 0.26643e-04,0.22650e-04,0.17559e-04,0.78093e-05 /)
      kao(:, 5, 9, 3) = (/ &
        & 0.24599e-04,0.35618e-04,0.36736e-04,0.35456e-04,0.32981e-04, &
        & 0.29459e-04,0.24877e-04,0.18821e-04,0.88149e-05 /)
      kao(:, 1,10, 3) = (/ &
        & 0.11455e-04,0.17796e-04,0.18282e-04,0.17833e-04,0.16814e-04, &
        & 0.15305e-04,0.13526e-04,0.11628e-04,0.47637e-05 /)
      kao(:, 2,10, 3) = (/ &
        & 0.13295e-04,0.20290e-04,0.20862e-04,0.20316e-04,0.19125e-04, &
        & 0.17348e-04,0.15042e-04,0.12455e-04,0.56495e-05 /)
      kao(:, 3,10, 3) = (/ &
        & 0.15297e-04,0.22994e-04,0.23740e-04,0.23076e-04,0.21626e-04, &
        & 0.19529e-04,0.16766e-04,0.13399e-04,0.65988e-05 /)
      kao(:, 4,10, 3) = (/ &
        & 0.17488e-04,0.25986e-04,0.26882e-04,0.26021e-04,0.24246e-04, &
        & 0.21820e-04,0.18554e-04,0.14427e-04,0.74644e-05 /)
      kao(:, 5,10, 3) = (/ &
        & 0.19800e-04,0.29160e-04,0.30208e-04,0.29161e-04,0.27086e-04, &
        & 0.24189e-04,0.20462e-04,0.15474e-04,0.84395e-05 /)
      kao(:, 1,11, 3) = (/ &
        & 0.96366e-05,0.15168e-04,0.15611e-04,0.15230e-04,0.14381e-04, &
        & 0.13058e-04,0.11457e-04,0.98195e-05,0.43210e-05 /)
      kao(:, 2,11, 3) = (/ &
        & 0.11221e-04,0.17304e-04,0.17859e-04,0.17390e-04,0.16383e-04, &
        & 0.14837e-04,0.12820e-04,0.10541e-04,0.50915e-05 /)
      kao(:, 3,11, 3) = (/ &
        & 0.12922e-04,0.19611e-04,0.20376e-04,0.19769e-04,0.18510e-04, &
        & 0.16733e-04,0.14297e-04,0.11375e-04,0.59349e-05 /)
      kao(:, 4,11, 3) = (/ &
        & 0.14759e-04,0.22226e-04,0.23087e-04,0.22319e-04,0.20789e-04, &
        & 0.18677e-04,0.15854e-04,0.12233e-04,0.68646e-05 /)
      kao(:, 5,11, 3) = (/ &
        & 0.16687e-04,0.24901e-04,0.25894e-04,0.25020e-04,0.23234e-04, &
        & 0.20746e-04,0.17450e-04,0.13143e-04,0.77945e-05 /)
      kao(:, 1,12, 3) = (/ &
        & 0.80728e-05,0.12833e-04,0.13241e-04,0.12930e-04,0.12209e-04, &
        & 0.11077e-04,0.96874e-05,0.82518e-05,0.36987e-05 /)
      kao(:, 2,12, 3) = (/ &
        & 0.94096e-05,0.14647e-04,0.15179e-04,0.14789e-04,0.13929e-04, &
        & 0.12614e-04,0.10863e-04,0.88839e-05,0.43642e-05 /)
      kao(:, 3,12, 3) = (/ &
        & 0.10827e-04,0.16625e-04,0.17336e-04,0.16825e-04,0.15757e-04, &
        & 0.14215e-04,0.12135e-04,0.95702e-05,0.51276e-05 /)
      kao(:, 4,12, 3) = (/ &
        & 0.12346e-04,0.18823e-04,0.19626e-04,0.19011e-04,0.17715e-04, &
        & 0.15891e-04,0.13472e-04,0.10297e-04,0.58818e-05 /)
      kao(:, 5,12, 3) = (/ &
        & 0.13954e-04,0.21071e-04,0.21985e-04,0.21278e-04,0.19773e-04, &
        & 0.17642e-04,0.14813e-04,0.11109e-04,0.66485e-05 /)
      kao(:, 1,13, 3) = (/ &
        & 0.67198e-05,0.10777e-04,0.11153e-04,0.10900e-04,0.10301e-04, &
        & 0.93345e-05,0.81433e-05,0.69156e-05,0.30498e-05 /)
      kao(:, 2,13, 3) = (/ &
        & 0.78283e-05,0.12283e-04,0.12805e-04,0.12492e-04,0.11757e-04, &
        & 0.10649e-04,0.91519e-05,0.74495e-05,0.36028e-05 /)
      kao(:, 3,13, 3) = (/ &
        & 0.89966e-05,0.13983e-04,0.14629e-04,0.14218e-04,0.13315e-04, &
        & 0.11990e-04,0.10230e-04,0.80237e-05,0.42382e-05 /)
      kao(:, 4,13, 3) = (/ &
        & 0.10250e-04,0.15794e-04,0.16536e-04,0.16055e-04,0.14979e-04, &
        & 0.13421e-04,0.11355e-04,0.86371e-05,0.48511e-05 /)
      kao(:, 5,13, 3) = (/ &
        & 0.11575e-04,0.17689e-04,0.18502e-04,0.17950e-04,0.16689e-04, &
        & 0.14883e-04,0.12476e-04,0.93537e-05,0.54799e-05 /)
      kao(:, 1, 1, 4) = (/ &
        & 0.20313e-03,0.26410e-03,0.27054e-03,0.25842e-03,0.23794e-03, &
        & 0.21033e-03,0.17730e-03,0.13831e-03,0.52995e-04 /)
      kao(:, 2, 1, 4) = (/ &
        & 0.22722e-03,0.29058e-03,0.29572e-03,0.28200e-03,0.25898e-03, &
        & 0.22814e-03,0.19209e-03,0.14957e-03,0.59096e-04 /)
      kao(:, 3, 1, 4) = (/ &
        & 0.25054e-03,0.31580e-03,0.31991e-03,0.30486e-03,0.27955e-03, &
        & 0.24634e-03,0.20787e-03,0.16179e-03,0.65118e-04 /)
      kao(:, 4, 1, 4) = (/ &
        & 0.27197e-03,0.33971e-03,0.34310e-03,0.32677e-03,0.30002e-03, &
        & 0.26574e-03,0.22502e-03,0.17520e-03,0.71711e-04 /)
      kao(:, 5, 1, 4) = (/ &
        & 0.29178e-03,0.36213e-03,0.36503e-03,0.34815e-03,0.32114e-03, &
        & 0.28599e-03,0.24328e-03,0.18958e-03,0.78523e-04 /)
      kao(:, 1, 2, 4) = (/ &
        & 0.17547e-03,0.23012e-03,0.23639e-03,0.22606e-03,0.20799e-03, &
        & 0.18326e-03,0.15385e-03,0.11888e-03,0.43633e-04 /)
      kao(:, 2, 2, 4) = (/ &
        & 0.19601e-03,0.25269e-03,0.25751e-03,0.24629e-03,0.22623e-03, &
        & 0.19926e-03,0.16712e-03,0.12877e-03,0.48382e-04 /)
      kao(:, 3, 2, 4) = (/ &
        & 0.21598e-03,0.27423e-03,0.27812e-03,0.26576e-03,0.24403e-03, &
        & 0.21552e-03,0.18141e-03,0.13982e-03,0.53560e-04 /)
      kao(:, 4, 2, 4) = (/ &
        & 0.23449e-03,0.29482e-03,0.29820e-03,0.28454e-03,0.26171e-03, &
        & 0.23254e-03,0.19681e-03,0.15192e-03,0.59054e-04 /)
      kao(:, 5, 2, 4) = (/ &
        & 0.25198e-03,0.31408e-03,0.31723e-03,0.30341e-03,0.28040e-03, &
        & 0.25022e-03,0.21333e-03,0.16487e-03,0.64779e-04 /)
      kao(:, 1, 3, 4) = (/ &
        & 0.14736e-03,0.19483e-03,0.20065e-03,0.19242e-03,0.17728e-03, &
        & 0.15627e-03,0.13078e-03,0.10037e-03,0.34217e-04 /)
      kao(:, 2, 3, 4) = (/ &
        & 0.16492e-03,0.21441e-03,0.21892e-03,0.20980e-03,0.19289e-03, &
        & 0.17000e-03,0.14249e-03,0.10902e-03,0.38352e-04 /)
      kao(:, 3, 3, 4) = (/ &
        & 0.18200e-03,0.23294e-03,0.23658e-03,0.22658e-03,0.20822e-03, &
        & 0.18391e-03,0.15484e-03,0.11888e-03,0.42700e-04 /)
      kao(:, 4, 3, 4) = (/ &
        & 0.19811e-03,0.25094e-03,0.25385e-03,0.24276e-03,0.22338e-03, &
        & 0.19841e-03,0.16822e-03,0.12943e-03,0.47257e-04 /)
      kao(:, 5, 3, 4) = (/ &
        & 0.21352e-03,0.26784e-03,0.27027e-03,0.25917e-03,0.23966e-03, &
        & 0.21399e-03,0.18239e-03,0.14058e-03,0.51997e-04 /)
      kao(:, 1, 4, 4) = (/ &
        & 0.12070e-03,0.16282e-03,0.16870e-03,0.16215e-03,0.14966e-03, &
        & 0.13195e-03,0.11003e-03,0.83743e-04,0.26841e-04 /)
      kao(:, 2, 4, 4) = (/ &
        & 0.13616e-03,0.17979e-03,0.18420e-03,0.17692e-03,0.16288e-03, &
        & 0.14351e-03,0.12000e-03,0.91324e-04,0.29956e-04 /)
      kao(:, 3, 4, 4) = (/ &
        & 0.15142e-03,0.19606e-03,0.19933e-03,0.19132e-03,0.17582e-03, &
        & 0.15506e-03,0.13061e-03,0.99881e-04,0.33175e-04 /)
      kao(:, 4, 4, 4) = (/ &
        & 0.16591e-03,0.21170e-03,0.21421e-03,0.20525e-03,0.18888e-03, &
        & 0.16747e-03,0.14192e-03,0.10907e-03,0.36625e-04 /)
      kao(:, 5, 4, 4) = (/ &
        & 0.17956e-03,0.22655e-03,0.22833e-03,0.21949e-03,0.20283e-03, &
        & 0.18086e-03,0.15393e-03,0.11865e-03,0.40513e-04 /)
      kao(:, 1, 5, 4) = (/ &
        & 0.98625e-04,0.13480e-03,0.14099e-03,0.13653e-03,0.12600e-03, &
        & 0.11107e-03,0.92102e-04,0.69414e-04,0.22597e-04 /)
      kao(:, 2, 5, 4) = (/ &
        & 0.11165e-03,0.14975e-03,0.15429e-03,0.14886e-03,0.13710e-03, &
        & 0.12076e-03,0.10051e-03,0.76046e-04,0.25265e-04 /)
      kao(:, 3, 5, 4) = (/ &
        & 0.12461e-03,0.16391e-03,0.16725e-03,0.16091e-03,0.14796e-03, &
        & 0.13047e-03,0.10941e-03,0.83193e-04,0.27962e-04 /)
      kao(:, 4, 5, 4) = (/ &
        & 0.13738e-03,0.17761e-03,0.17982e-03,0.17281e-03,0.15916e-03, &
        & 0.14087e-03,0.11892e-03,0.90972e-04,0.30855e-04 /)
      kao(:, 5, 5, 4) = (/ &
        & 0.14967e-03,0.19066e-03,0.19231e-03,0.18509e-03,0.17109e-03, &
        & 0.15227e-03,0.12906e-03,0.99136e-04,0.34017e-04 /)
      kao(:, 1, 6, 4) = (/ &
        & 0.79863e-04,0.11034e-03,0.11622e-03,0.11400e-03,0.10532e-03, &
        & 0.92978e-04,0.76661e-04,0.57287e-04,0.18664e-04 /)
      kao(:, 2, 6, 4) = (/ &
        & 0.90753e-04,0.12318e-03,0.12766e-03,0.12440e-03,0.11482e-03, &
        & 0.10110e-03,0.83697e-04,0.62663e-04,0.20928e-04 /)
      kao(:, 3, 6, 4) = (/ &
        & 0.10183e-03,0.13532e-03,0.13907e-03,0.13464e-03,0.12396e-03, &
        & 0.10925e-03,0.90984e-04,0.68513e-04,0.23264e-04 /)
      kao(:, 4, 6, 4) = (/ &
        & 0.11293e-03,0.14742e-03,0.14995e-03,0.14481e-03,0.13354e-03, &
        & 0.11797e-03,0.98845e-04,0.74965e-04,0.25850e-04 /)
      kao(:, 5, 6, 4) = (/ &
        & 0.12360e-03,0.15914e-03,0.16090e-03,0.15521e-03,0.14361e-03, &
        & 0.12755e-03,0.10739e-03,0.81915e-04,0.28635e-04 /)
      kao(:, 1, 7, 4) = (/ &
        & 0.65679e-04,0.90084e-04,0.95681e-04,0.94567e-04,0.87338e-04, &
        & 0.77275e-04,0.63642e-04,0.47097e-04,0.15508e-04 /)
      kao(:, 2, 7, 4) = (/ &
        & 0.74551e-04,0.10089e-03,0.10531e-03,0.10327e-03,0.95364e-04, &
        & 0.84154e-04,0.69569e-04,0.51426e-04,0.17234e-04 /)
      kao(:, 3, 7, 4) = (/ &
        & 0.83584e-04,0.11137e-03,0.11469e-03,0.11193e-03,0.10325e-03, &
        & 0.91075e-04,0.75479e-04,0.56228e-04,0.19127e-04 /)
      kao(:, 4, 7, 4) = (/ &
        & 0.92762e-04,0.12171e-03,0.12420e-03,0.12060e-03,0.11147e-03, &
        & 0.98465e-04,0.81969e-04,0.61529e-04,0.21452e-04 /)
      kao(:, 5, 7, 4) = (/ &
        & 0.10189e-03,0.13182e-03,0.13364e-03,0.12960e-03,0.12008e-03, &
        & 0.10652e-03,0.89045e-04,0.67334e-04,0.23711e-04 /)
      kao(:, 1, 8, 4) = (/ &
        & 0.53656e-04,0.74109e-04,0.78629e-04,0.78245e-04,0.72322e-04, &
        & 0.63915e-04,0.52625e-04,0.38591e-04,0.14416e-04 /)
      kao(:, 2, 8, 4) = (/ &
        & 0.61163e-04,0.83104e-04,0.86832e-04,0.85562e-04,0.78992e-04, &
        & 0.69666e-04,0.57574e-04,0.42098e-04,0.15921e-04 /)
      kao(:, 3, 8, 4) = (/ &
        & 0.68914e-04,0.91909e-04,0.94594e-04,0.92816e-04,0.85590e-04, &
        & 0.75491e-04,0.62445e-04,0.46109e-04,0.17209e-04 /)
      kao(:, 4, 8, 4) = (/ &
        & 0.76847e-04,0.10059e-03,0.10256e-03,0.10019e-03,0.92496e-04, &
        & 0.81729e-04,0.67763e-04,0.50445e-04,0.18589e-04 /)
      kao(:, 5, 8, 4) = (/ &
        & 0.84847e-04,0.10902e-03,0.11071e-03,0.10784e-03,0.99812e-04, &
        & 0.88516e-04,0.73718e-04,0.55250e-04,0.20194e-04 /)
      kao(:, 1, 9, 4) = (/ &
        & 0.43346e-04,0.60608e-04,0.64818e-04,0.64681e-04,0.59655e-04, &
        & 0.52617e-04,0.43206e-04,0.31573e-04,0.14696e-04 /)
      kao(:, 2, 9, 4) = (/ &
        & 0.49669e-04,0.68380e-04,0.71800e-04,0.70860e-04,0.65260e-04, &
        & 0.57496e-04,0.47313e-04,0.34405e-04,0.16164e-04 /)
      kao(:, 3, 9, 4) = (/ &
        & 0.56274e-04,0.76040e-04,0.78454e-04,0.76944e-04,0.70665e-04, &
        & 0.62347e-04,0.51383e-04,0.37665e-04,0.17841e-04 /)
      kao(:, 4, 9, 4) = (/ &
        & 0.63127e-04,0.83451e-04,0.85178e-04,0.83082e-04,0.76437e-04, &
        & 0.67538e-04,0.55797e-04,0.41264e-04,0.19504e-04 /)
      kao(:, 5, 9, 4) = (/ &
        & 0.70124e-04,0.90807e-04,0.91960e-04,0.89432e-04,0.82527e-04, &
        & 0.73176e-04,0.60668e-04,0.45179e-04,0.20992e-04 /)
      kao(:, 1,10, 4) = (/ &
        & 0.35059e-04,0.49531e-04,0.53376e-04,0.53665e-04,0.49644e-04, &
        & 0.43592e-04,0.35609e-04,0.25845e-04,0.13231e-04 /)
      kao(:, 2,10, 4) = (/ &
        & 0.40376e-04,0.56174e-04,0.59502e-04,0.59040e-04,0.54399e-04, &
        & 0.47687e-04,0.39007e-04,0.28189e-04,0.15223e-04 /)
      kao(:, 3,10, 4) = (/ &
        & 0.46006e-04,0.62899e-04,0.65214e-04,0.64178e-04,0.58976e-04, &
        & 0.51726e-04,0.42386e-04,0.30843e-04,0.17241e-04 /)
      kao(:, 4,10, 4) = (/ &
        & 0.51905e-04,0.69395e-04,0.70988e-04,0.69461e-04,0.63801e-04, &
        & 0.56040e-04,0.46059e-04,0.33831e-04,0.19714e-04 /)
      kao(:, 5,10, 4) = (/ &
        & 0.57990e-04,0.75737e-04,0.76826e-04,0.74718e-04,0.68839e-04, &
        & 0.60664e-04,0.50105e-04,0.37049e-04,0.22308e-04 /)
      kao(:, 1,11, 4) = (/ &
        & 0.30150e-04,0.42738e-04,0.46011e-04,0.46330e-04,0.42907e-04, &
        & 0.37605e-04,0.30702e-04,0.21962e-04,0.11791e-04 /)
      kao(:, 2,11, 4) = (/ &
        & 0.34714e-04,0.48516e-04,0.51120e-04,0.50726e-04,0.46912e-04, &
        & 0.41033e-04,0.33505e-04,0.23952e-04,0.13242e-04 /)
      kao(:, 3,11, 4) = (/ &
        & 0.39649e-04,0.54325e-04,0.56146e-04,0.55270e-04,0.50902e-04, &
        & 0.44559e-04,0.36351e-04,0.26266e-04,0.15075e-04 /)
      kao(:, 4,11, 4) = (/ &
        & 0.44779e-04,0.59893e-04,0.61166e-04,0.59766e-04,0.55070e-04, &
        & 0.48303e-04,0.39491e-04,0.28847e-04,0.17164e-04 /)
      kao(:, 5,11, 4) = (/ &
        & 0.49946e-04,0.65411e-04,0.66256e-04,0.64345e-04,0.59474e-04, &
        & 0.52287e-04,0.43003e-04,0.31612e-04,0.19542e-04 /)
      kao(:, 1,12, 4) = (/ &
        & 0.25681e-04,0.36622e-04,0.39428e-04,0.39582e-04,0.36786e-04, &
        & 0.32210e-04,0.26270e-04,0.18629e-04,0.10035e-04 /)
      kao(:, 2,12, 4) = (/ &
        & 0.29636e-04,0.41620e-04,0.43701e-04,0.43425e-04,0.40150e-04, &
        & 0.35105e-04,0.28637e-04,0.20365e-04,0.11416e-04 /)
      kao(:, 3,12, 4) = (/ &
        & 0.33921e-04,0.46628e-04,0.48062e-04,0.47301e-04,0.43633e-04, &
        & 0.38189e-04,0.31133e-04,0.22405e-04,0.12946e-04 /)
      kao(:, 4,12, 4) = (/ &
        & 0.38341e-04,0.51401e-04,0.52457e-04,0.51129e-04,0.47238e-04, &
        & 0.41429e-04,0.33905e-04,0.24546e-04,0.14770e-04 /)
      kao(:, 5,12, 4) = (/ &
        & 0.42576e-04,0.56153e-04,0.56863e-04,0.55182e-04,0.51113e-04, &
        & 0.44940e-04,0.36987e-04,0.26898e-04,0.16865e-04 /)
      kao(:, 1,13, 4) = (/ &
        & 0.21707e-04,0.31142e-04,0.33487e-04,0.33650e-04,0.31301e-04, &
        & 0.27396e-04,0.22352e-04,0.15744e-04,0.83005e-05 /)
      kao(:, 2,13, 4) = (/ &
        & 0.25112e-04,0.35474e-04,0.37158e-04,0.36970e-04,0.34170e-04, &
        & 0.29871e-04,0.24361e-04,0.17312e-04,0.93559e-05 /)
      kao(:, 3,13, 4) = (/ &
        & 0.28762e-04,0.39712e-04,0.40924e-04,0.40199e-04,0.37169e-04, &
        & 0.32565e-04,0.26566e-04,0.19074e-04,0.10670e-04 /)
      kao(:, 4,13, 4) = (/ &
        & 0.32448e-04,0.43808e-04,0.44734e-04,0.43534e-04,0.40323e-04, &
        & 0.35367e-04,0.29011e-04,0.20897e-04,0.12240e-04 /)
      kao(:, 5,13, 4) = (/ &
        & 0.35905e-04,0.47771e-04,0.48482e-04,0.47094e-04,0.43703e-04, &
        & 0.38474e-04,0.31715e-04,0.22899e-04,0.13958e-04 /)
      kao(:, 1, 1, 5) = (/ &
        & 0.50328e-03,0.59028e-03,0.59973e-03,0.58955e-03,0.56685e-03, &
        & 0.50893e-03,0.43098e-03,0.31518e-03,0.12599e-03 /)
      kao(:, 2, 1, 5) = (/ &
        & 0.53454e-03,0.62581e-03,0.63729e-03,0.62588e-03,0.59902e-03, &
        & 0.54179e-03,0.45928e-03,0.33824e-03,0.13937e-03 /)
      kao(:, 3, 1, 5) = (/ &
        & 0.56216e-03,0.66315e-03,0.67707e-03,0.66553e-03,0.63545e-03, &
        & 0.57719e-03,0.48913e-03,0.36332e-03,0.15548e-03 /)
      kao(:, 4, 1, 5) = (/ &
        & 0.58821e-03,0.70231e-03,0.71934e-03,0.70828e-03,0.67637e-03, &
        & 0.61438e-03,0.52042e-03,0.38978e-03,0.17254e-03 /)
      kao(:, 5, 1, 5) = (/ &
        & 0.61349e-03,0.74309e-03,0.76503e-03,0.75486e-03,0.71943e-03, &
        & 0.65213e-03,0.55331e-03,0.41818e-03,0.19176e-03 /)
      kao(:, 1, 2, 5) = (/ &
        & 0.43720e-03,0.51117e-03,0.51919e-03,0.50988e-03,0.48875e-03, &
        & 0.44138e-03,0.37418e-03,0.27478e-03,0.10374e-03 /)
      kao(:, 2, 2, 5) = (/ &
        & 0.46400e-03,0.54460e-03,0.55429e-03,0.54395e-03,0.52067e-03, &
        & 0.47118e-03,0.39949e-03,0.29546e-03,0.11585e-03 /)
      kao(:, 3, 2, 5) = (/ &
        & 0.48798e-03,0.57940e-03,0.59177e-03,0.58113e-03,0.55553e-03, &
        & 0.50290e-03,0.42588e-03,0.31727e-03,0.12872e-03 /)
      kao(:, 4, 2, 5) = (/ &
        & 0.51088e-03,0.61529e-03,0.63115e-03,0.62163e-03,0.59296e-03, &
        & 0.53614e-03,0.45317e-03,0.34070e-03,0.14334e-03 /)
      kao(:, 5, 2, 5) = (/ &
        & 0.53331e-03,0.65233e-03,0.67270e-03,0.66363e-03,0.63091e-03, &
        & 0.57023e-03,0.48253e-03,0.36597e-03,0.15947e-03 /)
      kao(:, 1, 3, 5) = (/ &
        & 0.37168e-03,0.43544e-03,0.44351e-03,0.43496e-03,0.41418e-03, &
        & 0.37673e-03,0.31849e-03,0.23373e-03,0.83035e-04 /)
      kao(:, 2, 3, 5) = (/ &
        & 0.39476e-03,0.46532e-03,0.47527e-03,0.46587e-03,0.44394e-03, &
        & 0.40288e-03,0.34052e-03,0.25172e-03,0.92363e-04 /)
      kao(:, 3, 3, 5) = (/ &
        & 0.41559e-03,0.49597e-03,0.50880e-03,0.49944e-03,0.47605e-03, &
        & 0.43138e-03,0.36384e-03,0.27063e-03,0.10327e-03 /)
      kao(:, 4, 3, 5) = (/ &
        & 0.43551e-03,0.52738e-03,0.54357e-03,0.53553e-03,0.50924e-03, &
        & 0.46069e-03,0.38844e-03,0.29089e-03,0.11548e-03 /)
      kao(:, 5, 3, 5) = (/ &
        & 0.45509e-03,0.56036e-03,0.58045e-03,0.57279e-03,0.54320e-03, &
        & 0.49088e-03,0.41461e-03,0.31304e-03,0.12901e-03 /)
      kao(:, 1, 4, 5) = (/ &
        & 0.31353e-03,0.36800e-03,0.37478e-03,0.36628e-03,0.34818e-03, &
        & 0.31938e-03,0.26882e-03,0.19725e-03,0.65143e-04 /)
      kao(:, 2, 4, 5) = (/ &
        & 0.33327e-03,0.39347e-03,0.40240e-03,0.39421e-03,0.37500e-03, &
        & 0.34245e-03,0.28782e-03,0.21247e-03,0.72911e-04 /)
      kao(:, 3, 4, 5) = (/ &
        & 0.35116e-03,0.41935e-03,0.43125e-03,0.42396e-03,0.40374e-03, &
        & 0.36745e-03,0.30851e-03,0.22861e-03,0.82223e-04 /)
      kao(:, 4, 4, 5) = (/ &
        & 0.36817e-03,0.44654e-03,0.46141e-03,0.45505e-03,0.43257e-03, &
        & 0.39339e-03,0.33051e-03,0.24594e-03,0.92524e-04 /)
      kao(:, 5, 4, 5) = (/ &
        & 0.38502e-03,0.47537e-03,0.49387e-03,0.48730e-03,0.46233e-03, &
        & 0.42007e-03,0.35374e-03,0.26504e-03,0.10363e-03 /)
      kao(:, 1, 5, 5) = (/ &
        & 0.26371e-03,0.30958e-03,0.31480e-03,0.30643e-03,0.29119e-03, &
        & 0.26781e-03,0.22601e-03,0.16580e-03,0.51526e-04 /)
      kao(:, 2, 5, 5) = (/ &
        & 0.28046e-03,0.33149e-03,0.33831e-03,0.33074e-03,0.31455e-03, &
        & 0.28912e-03,0.24254e-03,0.17884e-03,0.57544e-04 /)
      kao(:, 3, 5, 5) = (/ &
        & 0.29571e-03,0.35368e-03,0.36281e-03,0.35630e-03,0.33882e-03, &
        & 0.31097e-03,0.26070e-03,0.19272e-03,0.64519e-04 /)
      kao(:, 4, 5, 5) = (/ &
        & 0.31016e-03,0.37666e-03,0.38893e-03,0.38273e-03,0.36412e-03, &
        & 0.33364e-03,0.28016e-03,0.20757e-03,0.72363e-04 /)
      kao(:, 5, 5, 5) = (/ &
        & 0.32452e-03,0.40122e-03,0.41666e-03,0.41046e-03,0.39013e-03, &
        & 0.35668e-03,0.30056e-03,0.22388e-03,0.80981e-04 /)
      kao(:, 1, 6, 5) = (/ &
        & 0.22069e-03,0.25888e-03,0.26323e-03,0.25479e-03,0.24246e-03, &
        & 0.22303e-03,0.18865e-03,0.13826e-03,0.42586e-04 /)
      kao(:, 2, 6, 5) = (/ &
        & 0.23505e-03,0.27730e-03,0.28289e-03,0.27510e-03,0.26179e-03, &
        & 0.24147e-03,0.20303e-03,0.14956e-03,0.47728e-04 /)
      kao(:, 3, 6, 5) = (/ &
        & 0.24799e-03,0.29644e-03,0.30324e-03,0.29696e-03,0.28190e-03, &
        & 0.26059e-03,0.21889e-03,0.16173e-03,0.53804e-04 /)
      kao(:, 4, 6, 5) = (/ &
        & 0.26027e-03,0.31607e-03,0.32548e-03,0.31928e-03,0.30338e-03, &
        & 0.27984e-03,0.23536e-03,0.17457e-03,0.60579e-04 /)
      kao(:, 5, 6, 5) = (/ &
        & 0.27261e-03,0.33682e-03,0.34889e-03,0.34299e-03,0.32589e-03, &
        & 0.29875e-03,0.25286e-03,0.18852e-03,0.67802e-04 /)
      kao(:, 1, 7, 5) = (/ &
        & 0.18284e-03,0.21563e-03,0.21874e-03,0.21147e-03,0.20158e-03, &
        & 0.18535e-03,0.15699e-03,0.11455e-03,0.35095e-04 /)
      kao(:, 2, 7, 5) = (/ &
        & 0.19537e-03,0.23122e-03,0.23571e-03,0.22829e-03,0.21760e-03, &
        & 0.20013e-03,0.16934e-03,0.12429e-03,0.39853e-04 /)
      kao(:, 3, 7, 5) = (/ &
        & 0.20672e-03,0.24731e-03,0.25313e-03,0.24636e-03,0.23401e-03, &
        & 0.21622e-03,0.18276e-03,0.13469e-03,0.45173e-04 /)
      kao(:, 4, 7, 5) = (/ &
        & 0.21741e-03,0.26399e-03,0.27153e-03,0.26539e-03,0.25198e-03, &
        & 0.23212e-03,0.19655e-03,0.14593e-03,0.50910e-04 /)
      kao(:, 5, 7, 5) = (/ &
        & 0.22822e-03,0.28170e-03,0.29118e-03,0.28544e-03,0.27112e-03, &
        & 0.24842e-03,0.21129e-03,0.15803e-03,0.57288e-04 /)
      kao(:, 1, 8, 5) = (/ &
        & 0.15136e-03,0.17854e-03,0.18119e-03,0.17535e-03,0.16721e-03, &
        & 0.15392e-03,0.13041e-03,0.94463e-04,0.29176e-04 /)
      kao(:, 2, 8, 5) = (/ &
        & 0.16197e-03,0.19183e-03,0.19544e-03,0.18940e-03,0.18045e-03, &
        & 0.16606e-03,0.14094e-03,0.10292e-03,0.33234e-04 /)
      kao(:, 3, 8, 5) = (/ &
        & 0.17149e-03,0.20540e-03,0.21055e-03,0.20432e-03,0.19421e-03, &
        & 0.17914e-03,0.15214e-03,0.11170e-03,0.37987e-04 /)
      kao(:, 4, 8, 5) = (/ &
        & 0.18048e-03,0.21966e-03,0.22618e-03,0.22017e-03,0.20926e-03, &
        & 0.19215e-03,0.16364e-03,0.12118e-03,0.43249e-04 /)
      kao(:, 5, 8, 5) = (/ &
        & 0.18968e-03,0.23496e-03,0.24258e-03,0.23712e-03,0.22524e-03, &
        & 0.20589e-03,0.17598e-03,0.13139e-03,0.48772e-04 /)
      kao(:, 1, 9, 5) = (/ &
        & 0.12535e-03,0.14733e-03,0.14911e-03,0.14464e-03,0.13810e-03, &
        & 0.12766e-03,0.10804e-03,0.77667e-04,0.31607e-04 /)
      kao(:, 2, 9, 5) = (/ &
        & 0.13428e-03,0.15826e-03,0.16122e-03,0.15658e-03,0.14914e-03, &
        & 0.13752e-03,0.11655e-03,0.84956e-04,0.35832e-04 /)
      kao(:, 3, 9, 5) = (/ &
        & 0.14212e-03,0.16949e-03,0.17392e-03,0.16905e-03,0.16073e-03, &
        & 0.14802e-03,0.12582e-03,0.92269e-04,0.39990e-04 /)
      kao(:, 4, 9, 5) = (/ &
        & 0.14955e-03,0.18151e-03,0.18720e-03,0.18233e-03,0.17343e-03, &
        & 0.15845e-03,0.13559e-03,0.99998e-04,0.44405e-04 /)
      kao(:, 5, 9, 5) = (/ &
        & 0.15720e-03,0.19441e-03,0.20115e-03,0.19658e-03,0.18679e-03, &
        & 0.17045e-03,0.14597e-03,0.10853e-03,0.48354e-04 /)
      kao(:, 1,10, 5) = (/ &
        & 0.10518e-03,0.12283e-03,0.12342e-03,0.11933e-03,0.11376e-03, &
        & 0.10615e-03,0.89610e-04,0.64322e-04,0.38897e-04 /)
      kao(:, 2,10, 5) = (/ &
        & 0.11277e-03,0.13167e-03,0.13319e-03,0.12937e-03,0.12328e-03, &
        & 0.11434e-03,0.96637e-04,0.70434e-04,0.44697e-04 /)
      kao(:, 3,10, 5) = (/ &
        & 0.11946e-03,0.14071e-03,0.14389e-03,0.14002e-03,0.13292e-03, &
        & 0.12246e-03,0.10436e-03,0.76473e-04,0.50672e-04 /)
      kao(:, 4,10, 5) = (/ &
        & 0.12573e-03,0.15045e-03,0.15515e-03,0.15121e-03,0.14368e-03, &
        & 0.13136e-03,0.11260e-03,0.82864e-04,0.56090e-04 /)
      kao(:, 5,10, 5) = (/ &
        & 0.13210e-03,0.16128e-03,0.16701e-03,0.16339e-03,0.15508e-03, &
        & 0.14154e-03,0.12132e-03,0.89973e-04,0.61017e-04 /)
      kao(:, 1,11, 5) = (/ &
        & 0.90693e-04,0.10606e-03,0.10639e-03,0.10214e-03,0.97041e-04, &
        & 0.90929e-04,0.76654e-04,0.55448e-04,0.34971e-04 /)
      kao(:, 2,11, 5) = (/ &
        & 0.96878e-04,0.11346e-03,0.11478e-03,0.11094e-03,0.10496e-03, &
        & 0.97427e-04,0.82680e-04,0.60468e-04,0.41599e-04 /)
      kao(:, 3,11, 5) = (/ &
        & 0.10232e-03,0.12125e-03,0.12365e-03,0.11979e-03,0.11346e-03, &
        & 0.10430e-03,0.89390e-04,0.65549e-04,0.48186e-04 /)
      kao(:, 4,11, 5) = (/ &
        & 0.10772e-03,0.12969e-03,0.13316e-03,0.12963e-03,0.12290e-03, &
        & 0.11234e-03,0.96526e-04,0.71097e-04,0.54537e-04 /)
      kao(:, 5,11, 5) = (/ &
        & 0.11345e-03,0.13912e-03,0.14339e-03,0.14025e-03,0.13275e-03, &
        & 0.12106e-03,0.10412e-03,0.77240e-04,0.60238e-04 /)
      kao(:, 1,12, 5) = (/ &
        & 0.77577e-04,0.91005e-04,0.91202e-04,0.87618e-04,0.82974e-04, &
        & 0.77488e-04,0.65261e-04,0.47539e-04,0.30516e-04 /)
      kao(:, 2,12, 5) = (/ &
        & 0.82612e-04,0.97349e-04,0.98497e-04,0.95069e-04,0.89699e-04, &
        & 0.82714e-04,0.70478e-04,0.51645e-04,0.35968e-04 /)
      kao(:, 3,12, 5) = (/ &
        & 0.87206e-04,0.10402e-03,0.10625e-03,0.10294e-03,0.97013e-04, &
        & 0.88723e-04,0.76259e-04,0.55960e-04,0.41899e-04 /)
      kao(:, 4,12, 5) = (/ &
        & 0.91929e-04,0.11153e-03,0.11462e-03,0.11153e-03,0.10500e-03, &
        & 0.95633e-04,0.82267e-04,0.60868e-04,0.48100e-04 /)
      kao(:, 5,12, 5) = (/ &
        & 0.97101e-04,0.11996e-03,0.12377e-03,0.12058e-03,0.11342e-03, &
        & 0.10316e-03,0.88884e-04,0.66077e-04,0.53563e-04 /)
      kao(:, 1,13, 5) = (/ &
        & 0.65838e-04,0.77620e-04,0.77829e-04,0.74661e-04,0.70473e-04, &
        & 0.65575e-04,0.55474e-04,0.40441e-04,0.25521e-04 /)
      kao(:, 2,13, 5) = (/ &
        & 0.69998e-04,0.83015e-04,0.84103e-04,0.81066e-04,0.76507e-04, &
        & 0.70172e-04,0.59914e-04,0.43882e-04,0.30126e-04 /)
      kao(:, 3,13, 5) = (/ &
        & 0.74003e-04,0.88878e-04,0.90840e-04,0.88139e-04,0.82951e-04, &
        & 0.75471e-04,0.64689e-04,0.47652e-04,0.35171e-04 /)
      kao(:, 4,13, 5) = (/ &
        & 0.78234e-04,0.95561e-04,0.98237e-04,0.95653e-04,0.89770e-04, &
        & 0.81434e-04,0.69913e-04,0.51882e-04,0.40221e-04 /)
      kao(:, 5,13, 5) = (/ &
        & 0.82825e-04,0.10313e-03,0.10644e-03,0.10352e-03,0.97040e-04, &
        & 0.87602e-04,0.75532e-04,0.56387e-04,0.44675e-04 /)
      kao(:, 1, 1, 6) = (/ &
        & 0.10615e-02,0.12529e-02,0.13083e-02,0.12764e-02,0.11881e-02, &
        & 0.10853e-02,0.93421e-03,0.71644e-03,0.30757e-03 /)
      kao(:, 2, 1, 6) = (/ &
        & 0.10918e-02,0.13136e-02,0.13677e-02,0.13350e-02,0.12522e-02, &
        & 0.11402e-02,0.98392e-03,0.76040e-03,0.35125e-03 /)
      kao(:, 3, 1, 6) = (/ &
        & 0.11297e-02,0.13742e-02,0.14266e-02,0.13956e-02,0.13143e-02, &
        & 0.11951e-02,0.10359e-02,0.81032e-03,0.39829e-03 /)
      kao(:, 4, 1, 6) = (/ &
        & 0.11716e-02,0.14330e-02,0.14865e-02,0.14580e-02,0.13738e-02, &
        & 0.12536e-02,0.10931e-02,0.86605e-03,0.44907e-03 /)
      kao(:, 5, 1, 6) = (/ &
        & 0.12137e-02,0.14919e-02,0.15477e-02,0.15196e-02,0.14358e-02, &
        & 0.13166e-02,0.11546e-02,0.92748e-03,0.50593e-03 /)
      kao(:, 1, 2, 6) = (/ &
        & 0.92435e-03,0.10874e-02,0.11275e-02,0.11015e-02,0.10311e-02, &
        & 0.94231e-03,0.80960e-03,0.63033e-03,0.26663e-03 /)
      kao(:, 2, 2, 6) = (/ &
        & 0.95885e-03,0.11428e-02,0.11829e-02,0.11541e-02,0.10849e-02, &
        & 0.98930e-03,0.85567e-03,0.67200e-03,0.30230e-03 /)
      kao(:, 3, 2, 6) = (/ &
        & 0.99776e-03,0.11978e-02,0.12376e-02,0.12093e-02,0.11390e-02, &
        & 0.10392e-02,0.90558e-03,0.71833e-03,0.34245e-03 /)
      kao(:, 4, 2, 6) = (/ &
        & 0.10380e-02,0.12537e-02,0.12935e-02,0.12652e-02,0.11933e-02, &
        & 0.10921e-02,0.95939e-03,0.76948e-03,0.38641e-03 /)
      kao(:, 5, 2, 6) = (/ &
        & 0.10779e-02,0.13105e-02,0.13515e-02,0.13214e-02,0.12497e-02, &
        & 0.11514e-02,0.10182e-02,0.82552e-03,0.43428e-03 /)
      kao(:, 1, 3, 6) = (/ &
        & 0.79958e-03,0.93053e-03,0.95669e-03,0.93720e-03,0.88165e-03, &
        & 0.80178e-03,0.69131e-03,0.54027e-03,0.22082e-03 /)
      kao(:, 2, 3, 6) = (/ &
        & 0.83354e-03,0.98064e-03,0.10079e-02,0.98484e-03,0.92834e-03, &
        & 0.84387e-03,0.73304e-03,0.57932e-03,0.25149e-03 /)
      kao(:, 3, 3, 6) = (/ &
        & 0.87012e-03,0.10320e-02,0.10600e-02,0.10346e-02,0.97491e-03, &
        & 0.88683e-03,0.77649e-03,0.62208e-03,0.28527e-03 /)
      kao(:, 4, 3, 6) = (/ &
        & 0.90759e-03,0.10841e-02,0.11129e-02,0.10858e-02,0.10238e-02, &
        & 0.93520e-03,0.82494e-03,0.66854e-03,0.32199e-03 /)
      kao(:, 5, 3, 6) = (/ &
        & 0.94443e-03,0.11378e-02,0.11668e-02,0.11369e-02,0.10746e-02, &
        & 0.98835e-03,0.87764e-03,0.71868e-03,0.36165e-03 /)
      kao(:, 1, 4, 6) = (/ &
        & 0.68628e-03,0.79104e-03,0.80863e-03,0.79421e-03,0.74681e-03, &
        & 0.67391e-03,0.58210e-03,0.45790e-03,0.18137e-03 /)
      kao(:, 2, 4, 6) = (/ &
        & 0.71790e-03,0.83686e-03,0.85591e-03,0.83705e-03,0.78808e-03, &
        & 0.71172e-03,0.61822e-03,0.49245e-03,0.20729e-03 /)
      kao(:, 3, 4, 6) = (/ &
        & 0.75117e-03,0.88426e-03,0.90462e-03,0.88167e-03,0.82945e-03, &
        & 0.75050e-03,0.65652e-03,0.53019e-03,0.23455e-03 /)
      kao(:, 4, 4, 6) = (/ &
        & 0.78430e-03,0.93252e-03,0.95418e-03,0.92872e-03,0.87301e-03, &
        & 0.79337e-03,0.69871e-03,0.57160e-03,0.26520e-03 /)
      kao(:, 5, 4, 6) = (/ &
        & 0.81683e-03,0.98168e-03,0.10045e-02,0.97638e-03,0.92000e-03, &
        & 0.84034e-03,0.74480e-03,0.61518e-03,0.29808e-03 /)
      kao(:, 1, 5, 6) = (/ &
        & 0.58497e-03,0.66935e-03,0.68301e-03,0.66951e-03,0.62962e-03, &
        & 0.56579e-03,0.48826e-03,0.38379e-03,0.14576e-03 /)
      kao(:, 2, 5, 6) = (/ &
        & 0.61310e-03,0.71031e-03,0.72592e-03,0.70978e-03,0.66652e-03, &
        & 0.59753e-03,0.51826e-03,0.41385e-03,0.16772e-03 /)
      kao(:, 3, 5, 6) = (/ &
        & 0.64179e-03,0.75306e-03,0.77095e-03,0.75074e-03,0.70458e-03, &
        & 0.63276e-03,0.55157e-03,0.44695e-03,0.19067e-03 /)
      kao(:, 4, 5, 6) = (/ &
        & 0.67039e-03,0.79634e-03,0.81655e-03,0.79420e-03,0.74416e-03, &
        & 0.67043e-03,0.58781e-03,0.48223e-03,0.21651e-03 /)
      kao(:, 5, 5, 6) = (/ &
        & 0.69870e-03,0.83972e-03,0.86240e-03,0.83794e-03,0.78674e-03, &
        & 0.71204e-03,0.62768e-03,0.51780e-03,0.24414e-03 /)
      kao(:, 1, 6, 6) = (/ &
        & 0.49594e-03,0.56319e-03,0.57248e-03,0.55950e-03,0.52657e-03, &
        & 0.47274e-03,0.40631e-03,0.31914e-03,0.11737e-03 /)
      kao(:, 2, 6, 6) = (/ &
        & 0.51946e-03,0.59932e-03,0.61091e-03,0.59626e-03,0.56011e-03, &
        & 0.50076e-03,0.43158e-03,0.34422e-03,0.13452e-03 /)
      kao(:, 3, 6, 6) = (/ &
        & 0.54355e-03,0.63601e-03,0.65111e-03,0.63466e-03,0.59552e-03, &
        & 0.53122e-03,0.45996e-03,0.37172e-03,0.15179e-03 /)
      kao(:, 4, 6, 6) = (/ &
        & 0.56762e-03,0.67321e-03,0.69130e-03,0.67433e-03,0.63164e-03, &
        & 0.56508e-03,0.49145e-03,0.39979e-03,0.17118e-03 /)
      kao(:, 5, 6, 6) = (/ &
        & 0.59180e-03,0.71065e-03,0.73195e-03,0.71355e-03,0.66898e-03, &
        & 0.60268e-03,0.52617e-03,0.43141e-03,0.19263e-03 /)
      kao(:, 1, 7, 6) = (/ &
        & 0.41932e-03,0.47346e-03,0.47850e-03,0.46519e-03,0.43628e-03, &
        & 0.39132e-03,0.33641e-03,0.26485e-03,0.10000e-03 /)
      kao(:, 2, 7, 6) = (/ &
        & 0.43848e-03,0.50411e-03,0.51171e-03,0.49803e-03,0.46737e-03, &
        & 0.41801e-03,0.35878e-03,0.28532e-03,0.11408e-03 /)
      kao(:, 3, 7, 6) = (/ &
        & 0.45836e-03,0.53506e-03,0.54578e-03,0.53230e-03,0.49970e-03, &
        & 0.44506e-03,0.38306e-03,0.30828e-03,0.13001e-03 /)
      kao(:, 4, 7, 6) = (/ &
        & 0.47855e-03,0.56639e-03,0.58020e-03,0.56722e-03,0.53202e-03, &
        & 0.47546e-03,0.41064e-03,0.33104e-03,0.14676e-03 /)
      kao(:, 5, 7, 6) = (/ &
        & 0.49885e-03,0.59805e-03,0.61555e-03,0.60152e-03,0.56466e-03, &
        & 0.50884e-03,0.44071e-03,0.35766e-03,0.16471e-03 /)
      kao(:, 1, 8, 6) = (/ &
        & 0.35434e-03,0.39784e-03,0.40003e-03,0.38643e-03,0.36029e-03, &
        & 0.32228e-03,0.27705e-03,0.21936e-03,0.85304e-04 /)
      kao(:, 2, 8, 6) = (/ &
        & 0.36972e-03,0.42325e-03,0.42802e-03,0.41467e-03,0.38745e-03, &
        & 0.34637e-03,0.29590e-03,0.23622e-03,0.97535e-04 /)
      kao(:, 3, 8, 6) = (/ &
        & 0.38589e-03,0.44905e-03,0.45611e-03,0.44402e-03,0.41681e-03, &
        & 0.37125e-03,0.31793e-03,0.25523e-03,0.11156e-03 /)
      kao(:, 4, 8, 6) = (/ &
        & 0.40282e-03,0.47505e-03,0.48489e-03,0.47391e-03,0.44440e-03, &
        & 0.39797e-03,0.34220e-03,0.27395e-03,0.12650e-03 /)
      kao(:, 5, 8, 6) = (/ &
        & 0.41971e-03,0.50175e-03,0.51511e-03,0.50365e-03,0.47246e-03, &
        & 0.42646e-03,0.36852e-03,0.29705e-03,0.14272e-03 /)
      kao(:, 1, 9, 6) = (/ &
        & 0.29829e-03,0.33364e-03,0.33392e-03,0.32092e-03,0.29738e-03, &
        & 0.26469e-03,0.22642e-03,0.18017e-03,0.77064e-04 /)
      kao(:, 2, 9, 6) = (/ &
        & 0.31054e-03,0.35463e-03,0.35704e-03,0.34432e-03,0.32083e-03, &
        & 0.28575e-03,0.24402e-03,0.19441e-03,0.87743e-04 /)
      kao(:, 3, 9, 6) = (/ &
        & 0.32389e-03,0.37581e-03,0.38023e-03,0.36873e-03,0.34562e-03, &
        & 0.30799e-03,0.26274e-03,0.21037e-03,0.99662e-04 /)
      kao(:, 4, 9, 6) = (/ &
        & 0.33808e-03,0.39748e-03,0.40404e-03,0.39387e-03,0.36968e-03, &
        & 0.33141e-03,0.28405e-03,0.22647e-03,0.11282e-03 /)
      kao(:, 5, 9, 6) = (/ &
        & 0.35231e-03,0.41983e-03,0.42961e-03,0.41951e-03,0.39352e-03, &
        & 0.35528e-03,0.30599e-03,0.24648e-03,0.12841e-03 /)
      kao(:, 1,10, 6) = (/ &
        & 0.25036e-03,0.27999e-03,0.27949e-03,0.26793e-03,0.24735e-03, &
        & 0.21800e-03,0.18604e-03,0.14807e-03,0.93146e-04 /)
      kao(:, 2,10, 6) = (/ &
        & 0.26009e-03,0.29745e-03,0.29870e-03,0.28727e-03,0.26656e-03, &
        & 0.23674e-03,0.20160e-03,0.16012e-03,0.10408e-03 /)
      kao(:, 3,10, 6) = (/ &
        & 0.27084e-03,0.31508e-03,0.31779e-03,0.30720e-03,0.28751e-03, &
        & 0.25636e-03,0.21818e-03,0.17357e-03,0.11611e-03 /)
      kao(:, 4,10, 6) = (/ &
        & 0.28251e-03,0.33335e-03,0.33759e-03,0.32814e-03,0.30785e-03, &
        & 0.27625e-03,0.23573e-03,0.18761e-03,0.12959e-03 /)
      kao(:, 5,10, 6) = (/ &
        & 0.29455e-03,0.35211e-03,0.35903e-03,0.34997e-03,0.32871e-03, &
        & 0.29658e-03,0.25454e-03,0.20476e-03,0.14404e-03 /)
      kao(:, 1,11, 6) = (/ &
        & 0.21327e-03,0.24042e-03,0.24026e-03,0.23068e-03,0.21276e-03, &
        & 0.18665e-03,0.15901e-03,0.12570e-03,0.94295e-04 /)
      kao(:, 2,11, 6) = (/ &
        & 0.22127e-03,0.25493e-03,0.25609e-03,0.24693e-03,0.22931e-03, &
        & 0.20329e-03,0.17265e-03,0.13686e-03,0.10535e-03 /)
      kao(:, 3,11, 6) = (/ &
        & 0.23042e-03,0.26962e-03,0.27233e-03,0.26383e-03,0.24677e-03, &
        & 0.22030e-03,0.18718e-03,0.14788e-03,0.11369e-03 /)
      kao(:, 4,11, 6) = (/ &
        & 0.24025e-03,0.28500e-03,0.28961e-03,0.28171e-03,0.26402e-03, &
        & 0.23726e-03,0.20232e-03,0.16110e-03,0.12526e-03 /)
      kao(:, 5,11, 6) = (/ &
        & 0.25035e-03,0.30139e-03,0.30818e-03,0.30033e-03,0.28246e-03, &
        & 0.25541e-03,0.21869e-03,0.17592e-03,0.13806e-03 /)
      kao(:, 1,12, 6) = (/ &
        & 0.18213e-03,0.20563e-03,0.20558e-03,0.19744e-03,0.18197e-03, &
        & 0.15967e-03,0.13562e-03,0.10709e-03,0.84300e-04 /)
      kao(:, 2,12, 6) = (/ &
        & 0.18873e-03,0.21755e-03,0.21877e-03,0.21098e-03,0.19617e-03, &
        & 0.17419e-03,0.14735e-03,0.11726e-03,0.96090e-04 /)
      kao(:, 3,12, 6) = (/ &
        & 0.19633e-03,0.22994e-03,0.23250e-03,0.22538e-03,0.21092e-03, &
        & 0.18881e-03,0.15987e-03,0.12650e-03,0.10477e-03 /)
      kao(:, 4,12, 6) = (/ &
        & 0.20445e-03,0.24309e-03,0.24729e-03,0.24084e-03,0.22613e-03, &
        & 0.20371e-03,0.17330e-03,0.13785e-03,0.11268e-03 /)
      kao(:, 5,12, 6) = (/ &
        & 0.21299e-03,0.25719e-03,0.26315e-03,0.25711e-03,0.24260e-03, &
        & 0.21944e-03,0.18764e-03,0.15038e-03,0.12367e-03 /)
      kao(:, 1,13, 6) = (/ &
        & 0.15527e-03,0.17641e-03,0.17566e-03,0.16836e-03,0.15534e-03, &
        & 0.13636e-03,0.11530e-03,0.91307e-04,0.70205e-04 /)
      kao(:, 2,13, 6) = (/ &
        & 0.16096e-03,0.18612e-03,0.18657e-03,0.17973e-03,0.16702e-03, &
        & 0.14851e-03,0.12550e-03,0.99145e-04,0.79984e-04 /)
      kao(:, 3,13, 6) = (/ &
        & 0.16748e-03,0.19648e-03,0.19822e-03,0.19209e-03,0.17957e-03, &
        & 0.16107e-03,0.13652e-03,0.10753e-03,0.86067e-04 /)
      kao(:, 4,13, 6) = (/ &
        & 0.17450e-03,0.20751e-03,0.21098e-03,0.20534e-03,0.19295e-03, &
        & 0.17420e-03,0.14816e-03,0.11772e-03,0.93252e-04 /)
      kao(:, 5,13, 6) = (/ &
        & 0.18233e-03,0.21950e-03,0.22442e-03,0.21958e-03,0.20754e-03, &
        & 0.18842e-03,0.16097e-03,0.12851e-03,0.10278e-03 /)
      kao(:, 1, 1, 7) = (/ &
        & 0.23852e-02,0.24955e-02,0.25247e-02,0.24784e-02,0.23525e-02, &
        & 0.21437e-02,0.18704e-02,0.15353e-02,0.99116e-03 /)
      kao(:, 2, 1, 7) = (/ &
        & 0.23950e-02,0.25560e-02,0.26150e-02,0.25851e-02,0.24612e-02, &
        & 0.22632e-02,0.20004e-02,0.16585e-02,0.11087e-02 /)
      kao(:, 3, 1, 7) = (/ &
        & 0.24020e-02,0.26226e-02,0.27112e-02,0.26940e-02,0.25772e-02, &
        & 0.23915e-02,0.21332e-02,0.17859e-02,0.12435e-02 /)
      kao(:, 4, 1, 7) = (/ &
        & 0.24093e-02,0.26930e-02,0.28096e-02,0.28038e-02,0.27017e-02, &
        & 0.25227e-02,0.22696e-02,0.19198e-02,0.13912e-02 /)
      kao(:, 5, 1, 7) = (/ &
        & 0.24224e-02,0.27647e-02,0.29093e-02,0.29173e-02,0.28299e-02, &
        & 0.26579e-02,0.24103e-02,0.20612e-02,0.15535e-02 /)
      kao(:, 1, 2, 7) = (/ &
        & 0.20974e-02,0.22118e-02,0.22296e-02,0.21778e-02,0.20625e-02, &
        & 0.18815e-02,0.16530e-02,0.13562e-02,0.82141e-03 /)
      kao(:, 2, 2, 7) = (/ &
        & 0.21046e-02,0.22702e-02,0.23143e-02,0.22813e-02,0.21720e-02, &
        & 0.19971e-02,0.17712e-02,0.14678e-02,0.93003e-03 /)
      kao(:, 3, 2, 7) = (/ &
        & 0.21127e-02,0.23326e-02,0.24062e-02,0.23885e-02,0.22861e-02, &
        & 0.21193e-02,0.18939e-02,0.15834e-02,0.10463e-02 /)
      kao(:, 4, 2, 7) = (/ &
        & 0.21272e-02,0.23971e-02,0.25002e-02,0.24977e-02,0.24074e-02, &
        & 0.22461e-02,0.20177e-02,0.17030e-02,0.11732e-02 /)
      kao(:, 5, 2, 7) = (/ &
        & 0.21483e-02,0.24652e-02,0.25947e-02,0.26138e-02,0.25341e-02, &
        & 0.23755e-02,0.21449e-02,0.18299e-02,0.13107e-02 /)
      kao(:, 1, 3, 7) = (/ &
        & 0.18244e-02,0.19320e-02,0.19387e-02,0.18795e-02,0.17712e-02, &
        & 0.16188e-02,0.14258e-02,0.11664e-02,0.66404e-03 /)
      kao(:, 2, 3, 7) = (/ &
        & 0.18322e-02,0.19846e-02,0.20150e-02,0.19741e-02,0.18746e-02, &
        & 0.17292e-02,0.15311e-02,0.12668e-02,0.75772e-03 /)
      kao(:, 3, 3, 7) = (/ &
        & 0.18451e-02,0.20412e-02,0.20960e-02,0.20746e-02,0.19871e-02, &
        & 0.18444e-02,0.16430e-02,0.13711e-02,0.85470e-03 /)
      kao(:, 4, 3, 7) = (/ &
        & 0.18657e-02,0.21020e-02,0.21815e-02,0.21798e-02,0.21034e-02, &
        & 0.19629e-02,0.17571e-02,0.14786e-02,0.95834e-03 /)
      kao(:, 5, 3, 7) = (/ &
        & 0.18943e-02,0.21674e-02,0.22717e-02,0.22915e-02,0.22239e-02, &
        & 0.20844e-02,0.18739e-02,0.15906e-02,0.10775e-02 /)
      kao(:, 1, 4, 7) = (/ &
        & 0.15758e-02,0.16711e-02,0.16675e-02,0.16043e-02,0.15088e-02, &
        & 0.13785e-02,0.12140e-02,0.98780e-03,0.53258e-03 /)
      kao(:, 2, 4, 7) = (/ &
        & 0.15867e-02,0.17169e-02,0.17338e-02,0.16891e-02,0.16022e-02, &
        & 0.14807e-02,0.13108e-02,0.10774e-02,0.61127e-03 /)
      kao(:, 3, 4, 7) = (/ &
        & 0.16043e-02,0.17687e-02,0.18047e-02,0.17788e-02,0.17054e-02, &
        & 0.15869e-02,0.14121e-02,0.11700e-02,0.69092e-03 /)
      kao(:, 4, 4, 7) = (/ &
        & 0.16308e-02,0.18263e-02,0.18817e-02,0.18741e-02,0.18139e-02, &
        & 0.16955e-02,0.15162e-02,0.12673e-02,0.77859e-03 /)
      kao(:, 5, 4, 7) = (/ &
        & 0.16631e-02,0.18894e-02,0.19653e-02,0.19764e-02,0.19240e-02, &
        & 0.18069e-02,0.16237e-02,0.13697e-02,0.87657e-03 /)
      kao(:, 1, 5, 7) = (/ &
        & 0.13575e-02,0.14376e-02,0.14238e-02,0.13660e-02,0.12806e-02, &
        & 0.11664e-02,0.10231e-02,0.82794e-03,0.42595e-03 /)
      kao(:, 2, 5, 7) = (/ &
        & 0.13711e-02,0.14787e-02,0.14807e-02,0.14369e-02,0.13637e-02, &
        & 0.12570e-02,0.11125e-02,0.90729e-03,0.48990e-03 /)
      kao(:, 3, 5, 7) = (/ &
        & 0.13932e-02,0.15262e-02,0.15434e-02,0.15158e-02,0.14536e-02, &
        & 0.13534e-02,0.12033e-02,0.99132e-03,0.55848e-03 /)
      kao(:, 4, 5, 7) = (/ &
        & 0.14217e-02,0.15804e-02,0.16130e-02,0.16009e-02,0.15482e-02, &
        & 0.14537e-02,0.12991e-02,0.10796e-02,0.63246e-03 /)
      kao(:, 5, 5, 7) = (/ &
        & 0.14548e-02,0.16406e-02,0.16899e-02,0.16924e-02,0.16473e-02, &
        & 0.15538e-02,0.13988e-02,0.11736e-02,0.71422e-03 /)
      kao(:, 1, 6, 7) = (/ &
        & 0.11657e-02,0.12310e-02,0.12114e-02,0.11593e-02,0.10807e-02, &
        & 0.97870e-03,0.85220e-03,0.68679e-03,0.33278e-03 /)
      kao(:, 2, 6, 7) = (/ &
        & 0.11817e-02,0.12689e-02,0.12606e-02,0.12200e-02,0.11515e-02, &
        & 0.10575e-02,0.93300e-03,0.75653e-03,0.38390e-03 /)
      kao(:, 3, 6, 7) = (/ &
        & 0.12052e-02,0.13132e-02,0.13166e-02,0.12868e-02,0.12281e-02, &
        & 0.11419e-02,0.10150e-02,0.83054e-03,0.44291e-03 /)
      kao(:, 4, 6, 7) = (/ &
        & 0.12337e-02,0.13638e-02,0.13800e-02,0.13608e-02,0.13105e-02, &
        & 0.12294e-02,0.11010e-02,0.91218e-03,0.50714e-03 /)
      kao(:, 5, 6, 7) = (/ &
        & 0.12657e-02,0.14200e-02,0.14498e-02,0.14421e-02,0.13994e-02, &
        & 0.13201e-02,0.11915e-02,0.99447e-03,0.57759e-03 /)
      kao(:, 1, 7, 7) = (/ &
        & 0.99495e-03,0.10489e-02,0.10293e-02,0.98184e-03,0.91156e-03, &
        & 0.82083e-03,0.70758e-03,0.56387e-03,0.26025e-03 /)
      kao(:, 2, 7, 7) = (/ &
        & 0.10122e-02,0.10837e-02,0.10724e-02,0.10344e-02,0.96982e-03, &
        & 0.88589e-03,0.77530e-03,0.62605e-03,0.29914e-03 /)
      kao(:, 3, 7, 7) = (/ &
        & 0.10351e-02,0.11253e-02,0.11236e-02,0.10922e-02,0.10352e-02, &
        & 0.95724e-03,0.84889e-03,0.69076e-03,0.34305e-03 /)
      kao(:, 4, 7, 7) = (/ &
        & 0.10622e-02,0.11721e-02,0.11813e-02,0.11564e-02,0.11065e-02, &
        & 0.10331e-02,0.92494e-03,0.76297e-03,0.39175e-03 /)
      kao(:, 5, 7, 7) = (/ &
        & 0.10903e-02,0.12244e-02,0.12441e-02,0.12287e-02,0.11845e-02, &
        & 0.11129e-02,0.10035e-02,0.83648e-03,0.44712e-03 /)
      kao(:, 1, 8, 7) = (/ &
        & 0.84532e-03,0.88892e-03,0.86965e-03,0.82727e-03,0.76674e-03, &
        & 0.68807e-03,0.58679e-03,0.46179e-03,0.21931e-03 /)
      kao(:, 2, 8, 7) = (/ &
        & 0.86227e-03,0.92051e-03,0.90826e-03,0.87315e-03,0.81675e-03, &
        & 0.74173e-03,0.64502e-03,0.51436e-03,0.25538e-03 /)
      kao(:, 3, 8, 7) = (/ &
        & 0.88387e-03,0.95827e-03,0.95473e-03,0.92480e-03,0.87135e-03, &
        & 0.80090e-03,0.70594e-03,0.57141e-03,0.29275e-03 /)
      kao(:, 4, 8, 7) = (/ &
        & 0.90659e-03,0.10014e-02,0.10072e-02,0.98186e-03,0.93348e-03, &
        & 0.86582e-03,0.77148e-03,0.63431e-03,0.33522e-03 /)
      kao(:, 5, 8, 7) = (/ &
        & 0.93066e-03,0.10477e-02,0.10640e-02,0.10456e-02,0.10022e-02, &
        & 0.93597e-03,0.84005e-03,0.69831e-03,0.38214e-03 /)
      kao(:, 1, 9, 7) = (/ &
        & 0.71681e-03,0.75151e-03,0.73165e-03,0.69303e-03,0.64106e-03, &
        & 0.57326e-03,0.48762e-03,0.37724e-03,0.19963e-03 /)
      kao(:, 2, 9, 7) = (/ &
        & 0.73278e-03,0.77936e-03,0.76580e-03,0.73272e-03,0.68369e-03, &
        & 0.61851e-03,0.53463e-03,0.42190e-03,0.23258e-03 /)
      kao(:, 3, 9, 7) = (/ &
        & 0.75147e-03,0.81327e-03,0.80692e-03,0.77827e-03,0.73101e-03, &
        & 0.66869e-03,0.58582e-03,0.47030e-03,0.26770e-03 /)
      kao(:, 4, 9, 7) = (/ &
        & 0.77011e-03,0.85035e-03,0.85331e-03,0.82912e-03,0.78414e-03, &
        & 0.72425e-03,0.64047e-03,0.52434e-03,0.30603e-03 /)
      kao(:, 5, 9, 7) = (/ &
        & 0.79031e-03,0.89033e-03,0.90223e-03,0.88462e-03,0.84489e-03, &
        & 0.78478e-03,0.70032e-03,0.57826e-03,0.34848e-03 /)
      kao(:, 1,10, 7) = (/ &
        & 0.60860e-03,0.63631e-03,0.61722e-03,0.58182e-03,0.53631e-03, &
        & 0.47875e-03,0.40598e-03,0.31001e-03,0.21716e-03 /)
      kao(:, 2,10, 7) = (/ &
        & 0.62300e-03,0.66096e-03,0.64723e-03,0.61624e-03,0.57283e-03, &
        & 0.51614e-03,0.44515e-03,0.34783e-03,0.24030e-03 /)
      kao(:, 3,10, 7) = (/ &
        & 0.63811e-03,0.69041e-03,0.68320e-03,0.65609e-03,0.61386e-03, &
        & 0.55902e-03,0.48770e-03,0.38933e-03,0.26729e-03 /)
      kao(:, 4,10, 7) = (/ &
        & 0.65360e-03,0.72213e-03,0.72254e-03,0.70011e-03,0.66034e-03, &
        & 0.60659e-03,0.53507e-03,0.43477e-03,0.29849e-03 /)
      kao(:, 5,10, 7) = (/ &
        & 0.67038e-03,0.75665e-03,0.76418e-03,0.74727e-03,0.71207e-03, &
        & 0.65924e-03,0.58660e-03,0.48108e-03,0.33464e-03 /)
      kao(:, 1,11, 7) = (/ &
        & 0.52185e-03,0.54797e-03,0.53190e-03,0.50128e-03,0.46230e-03, &
        & 0.41291e-03,0.35086e-03,0.26843e-03,0.22407e-03 /)
      kao(:, 2,11, 7) = (/ &
        & 0.53416e-03,0.57111e-03,0.56029e-03,0.53286e-03,0.49524e-03, &
        & 0.44633e-03,0.38530e-03,0.30138e-03,0.24793e-03 /)
      kao(:, 3,11, 7) = (/ &
        & 0.54635e-03,0.59685e-03,0.59183e-03,0.56852e-03,0.53236e-03, &
        & 0.48455e-03,0.42287e-03,0.33910e-03,0.27073e-03 /)
      kao(:, 4,11, 7) = (/ &
        & 0.55941e-03,0.62493e-03,0.62582e-03,0.60673e-03,0.57348e-03, &
        & 0.52713e-03,0.46523e-03,0.37861e-03,0.29520e-03 /)
      kao(:, 5,11, 7) = (/ &
        & 0.57459e-03,0.65537e-03,0.66217e-03,0.64854e-03,0.61857e-03, &
        & 0.57343e-03,0.51159e-03,0.41997e-03,0.32408e-03 /)
      kao(:, 1,12, 7) = (/ &
        & 0.44547e-03,0.47205e-03,0.45856e-03,0.43259e-03,0.39885e-03, &
        & 0.35629e-03,0.30273e-03,0.23099e-03,0.20507e-03 /)
      kao(:, 2,12, 7) = (/ &
        & 0.45530e-03,0.49200e-03,0.48355e-03,0.46058e-03,0.42831e-03, &
        & 0.38615e-03,0.33301e-03,0.25970e-03,0.22582e-03 /)
      kao(:, 3,12, 7) = (/ &
        & 0.46565e-03,0.51443e-03,0.51077e-03,0.49108e-03,0.46067e-03, &
        & 0.41962e-03,0.36657e-03,0.29355e-03,0.24853e-03 /)
      kao(:, 4,12, 7) = (/ &
        & 0.47732e-03,0.53905e-03,0.54027e-03,0.52415e-03,0.49634e-03, &
        & 0.45650e-03,0.40422e-03,0.32887e-03,0.26943e-03 /)
      kao(:, 5,12, 7) = (/ &
        & 0.49131e-03,0.56624e-03,0.57259e-03,0.56091e-03,0.53532e-03, &
        & 0.49724e-03,0.44494e-03,0.36671e-03,0.29370e-03 /)
      kao(:, 1,13, 7) = (/ &
        & 0.37861e-03,0.40433e-03,0.39425e-03,0.37277e-03,0.34384e-03, &
        & 0.30718e-03,0.26082e-03,0.19813e-03,0.17021e-03 /)
      kao(:, 2,13, 7) = (/ &
        & 0.38646e-03,0.42180e-03,0.41569e-03,0.39676e-03,0.36941e-03, &
        & 0.33370e-03,0.28746e-03,0.22445e-03,0.18768e-03 /)
      kao(:, 3,13, 7) = (/ &
        & 0.39522e-03,0.44150e-03,0.43928e-03,0.42293e-03,0.39746e-03, &
        & 0.36268e-03,0.31709e-03,0.25391e-03,0.20463e-03 /)
      kao(:, 4,13, 7) = (/ &
        & 0.40576e-03,0.46362e-03,0.46497e-03,0.45178e-03,0.42852e-03, &
        & 0.39486e-03,0.34992e-03,0.28472e-03,0.22430e-03 /)
      kao(:, 5,13, 7) = (/ &
        & 0.41810e-03,0.48813e-03,0.49424e-03,0.48434e-03,0.46280e-03, &
        & 0.43027e-03,0.38540e-03,0.31863e-03,0.24541e-03 /)
      kao(:, 1, 1, 8) = (/ &
        & 0.52571e-02,0.51649e-02,0.50998e-02,0.49978e-02,0.48299e-02, &
        & 0.45478e-02,0.41071e-02,0.34884e-02,0.27402e-02 /)
      kao(:, 2, 1, 8) = (/ &
        & 0.51967e-02,0.52277e-02,0.52437e-02,0.52099e-02,0.50894e-02, &
        & 0.48424e-02,0.44165e-02,0.38421e-02,0.31643e-02 /)
      kao(:, 3, 1, 8) = (/ &
        & 0.51548e-02,0.53047e-02,0.54023e-02,0.54271e-02,0.53544e-02, &
        & 0.51370e-02,0.47457e-02,0.42178e-02,0.36142e-02 /)
      kao(:, 4, 1, 8) = (/ &
        & 0.51293e-02,0.53942e-02,0.55672e-02,0.56512e-02,0.56201e-02, &
        & 0.54409e-02,0.50927e-02,0.46186e-02,0.40998e-02 /)
      kao(:, 5, 1, 8) = (/ &
        & 0.51178e-02,0.54996e-02,0.57406e-02,0.58798e-02,0.58932e-02, &
        & 0.57606e-02,0.54613e-02,0.50399e-02,0.46100e-02 /)
      kao(:, 1, 2, 8) = (/ &
        & 0.47778e-02,0.47398e-02,0.47115e-02,0.46169e-02,0.44426e-02, &
        & 0.41630e-02,0.37511e-02,0.31426e-02,0.23122e-02 /)
      kao(:, 2, 2, 8) = (/ &
        & 0.47384e-02,0.48111e-02,0.48532e-02,0.48144e-02,0.46755e-02, &
        & 0.44342e-02,0.40397e-02,0.34599e-02,0.26698e-02 /)
      kao(:, 3, 2, 8) = (/ &
        & 0.47181e-02,0.49025e-02,0.50071e-02,0.50151e-02,0.49194e-02, &
        & 0.47085e-02,0.43402e-02,0.37956e-02,0.30630e-02 /)
      kao(:, 4, 2, 8) = (/ &
        & 0.47137e-02,0.50070e-02,0.51691e-02,0.52245e-02,0.51706e-02, &
        & 0.49959e-02,0.46583e-02,0.41574e-02,0.34865e-02 /)
      kao(:, 5, 2, 8) = (/ &
        & 0.47212e-02,0.51234e-02,0.53397e-02,0.54379e-02,0.54276e-02, &
        & 0.52983e-02,0.49978e-02,0.45412e-02,0.39357e-02 /)
      kao(:, 1, 3, 8) = (/ &
        & 0.42971e-02,0.42851e-02,0.42729e-02,0.41707e-02,0.39926e-02, &
        & 0.37146e-02,0.33264e-02,0.27717e-02,0.18852e-02 /)
      kao(:, 2, 3, 8) = (/ &
        & 0.42740e-02,0.43647e-02,0.44079e-02,0.43562e-02,0.42040e-02, &
        & 0.39559e-02,0.35908e-02,0.30443e-02,0.21816e-02 /)
      kao(:, 3, 3, 8) = (/ &
        & 0.42703e-02,0.44650e-02,0.45616e-02,0.45425e-02,0.44233e-02, &
        & 0.42066e-02,0.38676e-02,0.33396e-02,0.25126e-02 /)
      kao(:, 4, 3, 8) = (/ &
        & 0.42812e-02,0.45806e-02,0.47230e-02,0.47371e-02,0.46519e-02, &
        & 0.44691e-02,0.41620e-02,0.36586e-02,0.28704e-02 /)
      kao(:, 5, 3, 8) = (/ &
        & 0.43030e-02,0.47042e-02,0.48922e-02,0.49377e-02,0.48939e-02, &
        & 0.47477e-02,0.44742e-02,0.39985e-02,0.32501e-02 /)
      kao(:, 1, 4, 8) = (/ &
        & 0.38233e-02,0.38279e-02,0.38143e-02,0.37097e-02,0.35270e-02, &
        & 0.32658e-02,0.29019e-02,0.24142e-02,0.15291e-02 /)
      kao(:, 2, 4, 8) = (/ &
        & 0.38114e-02,0.39122e-02,0.39475e-02,0.38778e-02,0.37194e-02, &
        & 0.34777e-02,0.31357e-02,0.26541e-02,0.17758e-02 /)
      kao(:, 3, 4, 8) = (/ &
        & 0.38202e-02,0.40186e-02,0.40970e-02,0.40542e-02,0.39201e-02, &
        & 0.37024e-02,0.33826e-02,0.29146e-02,0.20543e-02 /)
      kao(:, 4, 4, 8) = (/ &
        & 0.38442e-02,0.41385e-02,0.42569e-02,0.42394e-02,0.41310e-02, &
        & 0.39403e-02,0.36479e-02,0.31917e-02,0.23538e-02 /)
      kao(:, 5, 4, 8) = (/ &
        & 0.38788e-02,0.42695e-02,0.44229e-02,0.44328e-02,0.43540e-02, &
        & 0.41948e-02,0.39317e-02,0.34895e-02,0.26724e-02 /)
      kao(:, 1, 5, 8) = (/ &
        & 0.33660e-02,0.33879e-02,0.33669e-02,0.32570e-02,0.30787e-02, &
        & 0.28362e-02,0.25094e-02,0.20819e-02,0.12376e-02 /)
      kao(:, 2, 5, 8) = (/ &
        & 0.33649e-02,0.34740e-02,0.34949e-02,0.34119e-02,0.32508e-02, &
        & 0.30247e-02,0.27121e-02,0.22949e-02,0.14462e-02 /)
      kao(:, 3, 5, 8) = (/ &
        & 0.33839e-02,0.35821e-02,0.36398e-02,0.35762e-02,0.34359e-02, &
        & 0.32230e-02,0.29317e-02,0.25218e-02,0.16788e-02 /)
      kao(:, 4, 5, 8) = (/ &
        & 0.34188e-02,0.37047e-02,0.37932e-02,0.37524e-02,0.36321e-02, &
        & 0.34359e-02,0.31677e-02,0.27663e-02,0.19299e-02 /)
      kao(:, 5, 5, 8) = (/ &
        & 0.34572e-02,0.38382e-02,0.39563e-02,0.39381e-02,0.38416e-02, &
        & 0.36710e-02,0.34185e-02,0.30298e-02,0.21985e-02 /)
      kao(:, 1, 6, 8) = (/ &
        & 0.29383e-02,0.29689e-02,0.29375e-02,0.28254e-02,0.26571e-02, &
        & 0.24356e-02,0.21491e-02,0.17706e-02,0.99284e-03 /)
      kao(:, 2, 6, 8) = (/ &
        & 0.29460e-02,0.30526e-02,0.30576e-02,0.29676e-02,0.28114e-02, &
        & 0.25995e-02,0.23244e-02,0.19573e-02,0.11692e-02 /)
      kao(:, 3, 6, 8) = (/ &
        & 0.29740e-02,0.31582e-02,0.31942e-02,0.31202e-02,0.29785e-02, &
        & 0.27771e-02,0.25160e-02,0.21565e-02,0.13616e-02 /)
      kao(:, 4, 6, 8) = (/ &
        & 0.30101e-02,0.32807e-02,0.33417e-02,0.32855e-02,0.31583e-02, &
        & 0.29708e-02,0.27234e-02,0.23688e-02,0.15696e-02 /)
      kao(:, 5, 6, 8) = (/ &
        & 0.30525e-02,0.34071e-02,0.34999e-02,0.34618e-02,0.33518e-02, &
        & 0.31829e-02,0.29437e-02,0.25986e-02,0.17941e-02 /)
      kao(:, 1, 7, 8) = (/ &
        & 0.25527e-02,0.25837e-02,0.25415e-02,0.24332e-02,0.22747e-02, &
        & 0.20758e-02,0.18231e-02,0.14951e-02,0.78066e-03 /)
      kao(:, 2, 7, 8) = (/ &
        & 0.25661e-02,0.26638e-02,0.26497e-02,0.25583e-02,0.24134e-02, &
        & 0.22212e-02,0.19774e-02,0.16540e-02,0.92809e-03 /)
      kao(:, 3, 7, 8) = (/ &
        & 0.25966e-02,0.27642e-02,0.27764e-02,0.26998e-02,0.25630e-02, &
        & 0.23812e-02,0.21449e-02,0.18264e-02,0.10893e-02 /)
      kao(:, 4, 7, 8) = (/ &
        & 0.26340e-02,0.28771e-02,0.29165e-02,0.28538e-02,0.27279e-02, &
        & 0.25553e-02,0.23260e-02,0.20107e-02,0.12665e-02 /)
      kao(:, 5, 7, 8) = (/ &
        & 0.26829e-02,0.29939e-02,0.30639e-02,0.30192e-02,0.29089e-02, &
        & 0.27450e-02,0.25219e-02,0.22101e-02,0.14584e-02 /)
      kao(:, 1, 8, 8) = (/ &
        & 0.22109e-02,0.22392e-02,0.21909e-02,0.20870e-02,0.19391e-02, &
        & 0.17569e-02,0.15368e-02,0.12514e-02,0.62879e-03 /)
      kao(:, 2, 8, 8) = (/ &
        & 0.22276e-02,0.23140e-02,0.22874e-02,0.21965e-02,0.20609e-02, &
        & 0.18868e-02,0.16711e-02,0.13887e-02,0.73533e-03 /)
      kao(:, 3, 8, 8) = (/ &
        & 0.22565e-02,0.24065e-02,0.24031e-02,0.23233e-02,0.21969e-02, &
        & 0.20302e-02,0.18188e-02,0.15365e-02,0.85609e-03 /)
      kao(:, 4, 8, 8) = (/ &
        & 0.22974e-02,0.25072e-02,0.25290e-02,0.24653e-02,0.23482e-02, &
        & 0.21882e-02,0.19777e-02,0.16966e-02,0.98553e-03 /)
      kao(:, 5, 8, 8) = (/ &
        & 0.23517e-02,0.26173e-02,0.26619e-02,0.26145e-02,0.25139e-02, &
        & 0.23587e-02,0.21497e-02,0.18671e-02,0.11277e-02 /)
      kao(:, 1, 9, 8) = (/ &
        & 0.19109e-02,0.19351e-02,0.18847e-02,0.17853e-02,0.16484e-02, &
        & 0.14828e-02,0.12861e-02,0.10403e-02,0.59847e-03 /)
      kao(:, 2, 9, 8) = (/ &
        & 0.19272e-02,0.20031e-02,0.19691e-02,0.18817e-02,0.17540e-02, &
        & 0.15965e-02,0.14036e-02,0.11571e-02,0.69475e-03 /)
      kao(:, 3, 9, 8) = (/ &
        & 0.19559e-02,0.20842e-02,0.20709e-02,0.19954e-02,0.18765e-02, &
        & 0.17233e-02,0.15331e-02,0.12839e-02,0.80150e-03 /)
      kao(:, 4, 9, 8) = (/ &
        & 0.19994e-02,0.21761e-02,0.21815e-02,0.21203e-02,0.20143e-02, &
        & 0.18645e-02,0.16732e-02,0.14206e-02,0.91777e-03 /)
      kao(:, 5, 9, 8) = (/ &
        & 0.20550e-02,0.22788e-02,0.23027e-02,0.22546e-02,0.21605e-02, &
        & 0.20175e-02,0.18247e-02,0.15687e-02,0.10450e-02 /)
      kao(:, 1,10, 8) = (/ &
        & 0.16445e-02,0.16716e-02,0.16238e-02,0.15300e-02,0.14061e-02, &
        & 0.12566e-02,0.10807e-02,0.86738e-03,0.60827e-03 /)
      kao(:, 2,10, 8) = (/ &
        & 0.16600e-02,0.17327e-02,0.16984e-02,0.16154e-02,0.14994e-02, &
        & 0.13556e-02,0.11827e-02,0.96695e-03,0.70548e-03 /)
      kao(:, 3,10, 8) = (/ &
        & 0.16905e-02,0.18053e-02,0.17869e-02,0.17163e-02,0.16090e-02, &
        & 0.14689e-02,0.12961e-02,0.10754e-02,0.80786e-03 /)
      kao(:, 4,10, 8) = (/ &
        & 0.17354e-02,0.18905e-02,0.18865e-02,0.18272e-02,0.17299e-02, &
        & 0.15951e-02,0.14192e-02,0.11936e-02,0.91620e-03 /)
      kao(:, 5,10, 8) = (/ &
        & 0.17884e-02,0.19860e-02,0.19977e-02,0.19501e-02,0.18596e-02, &
        & 0.17298e-02,0.15525e-02,0.13217e-02,0.10338e-02 /)
      kao(:, 1,11, 8) = (/ &
        & 0.14133e-02,0.14603e-02,0.14202e-02,0.13407e-02,0.12334e-02, &
        & 0.11026e-02,0.94643e-03,0.75979e-03,0.57405e-03 /)
      kao(:, 2,11, 8) = (/ &
        & 0.14357e-02,0.15193e-02,0.14916e-02,0.14232e-02,0.13232e-02, &
        & 0.11950e-02,0.10392e-02,0.84686e-03,0.65471e-03 /)
      kao(:, 3,11, 8) = (/ &
        & 0.14730e-02,0.15907e-02,0.15765e-02,0.15172e-02,0.14237e-02, &
        & 0.12997e-02,0.11424e-02,0.94298e-03,0.75212e-03 /)
      kao(:, 4,11, 8) = (/ &
        & 0.15188e-02,0.16737e-02,0.16734e-02,0.16227e-02,0.15348e-02, &
        & 0.14132e-02,0.12544e-02,0.10476e-02,0.85445e-03 /)
      kao(:, 5,11, 8) = (/ &
        & 0.15705e-02,0.17634e-02,0.17799e-02,0.17387e-02,0.16551e-02, &
        & 0.15344e-02,0.13744e-02,0.11635e-02,0.96358e-03 /)
      kao(:, 1,12, 8) = (/ &
        & 0.12145e-02,0.12721e-02,0.12387e-02,0.11722e-02,0.10815e-02, &
        & 0.96748e-03,0.83052e-03,0.66461e-03,0.51952e-03 /)
      kao(:, 2,12, 8) = (/ &
        & 0.12432e-02,0.13303e-02,0.13076e-02,0.12500e-02,0.11644e-02, &
        & 0.10531e-02,0.91410e-03,0.74198e-03,0.58718e-03 /)
      kao(:, 3,12, 8) = (/ &
        & 0.12811e-02,0.13998e-02,0.13897e-02,0.13394e-02,0.12574e-02, &
        & 0.11474e-02,0.10067e-02,0.82675e-03,0.66821e-03 /)
      kao(:, 4,12, 8) = (/ &
        & 0.13251e-02,0.14771e-02,0.14813e-02,0.14393e-02,0.13610e-02, &
        & 0.12504e-02,0.11057e-02,0.91975e-03,0.76078e-03 /)
      kao(:, 5,12, 8) = (/ &
        & 0.13700e-02,0.15597e-02,0.15807e-02,0.15467e-02,0.14716e-02, &
        & 0.13608e-02,0.12138e-02,0.10232e-02,0.85832e-03 /)
      kao(:, 1,13, 8) = (/ &
        & 0.10471e-02,0.11076e-02,0.10790e-02,0.10231e-02,0.94527e-03, &
        & 0.84789e-03,0.72861e-03,0.58068e-03,0.44361e-03 /)
      kao(:, 2,13, 8) = (/ &
        & 0.10765e-02,0.11637e-02,0.11461e-02,0.10966e-02,0.10221e-02, &
        & 0.92418e-03,0.80364e-03,0.64949e-03,0.50409e-03 /)
      kao(:, 3,13, 8) = (/ &
        & 0.11121e-02,0.12288e-02,0.12232e-02,0.11802e-02,0.11084e-02, &
        & 0.10099e-02,0.88562e-03,0.72467e-03,0.57688e-03 /)
      kao(:, 4,13, 8) = (/ &
        & 0.11491e-02,0.12989e-02,0.13080e-02,0.12720e-02,0.12030e-02, &
        & 0.11037e-02,0.97404e-03,0.80781e-03,0.65303e-03 /)
      kao(:, 5,13, 8) = (/ &
        & 0.11880e-02,0.13724e-02,0.13975e-02,0.13701e-02,0.13034e-02, &
        & 0.12049e-02,0.10715e-02,0.89944e-03,0.73687e-03 /)
      kao(:, 1, 1, 9) = (/ &
        & 0.14418e-01,0.13406e-01,0.12605e-01,0.11857e-01,0.11091e-01, &
        & 0.10336e-01,0.95691e-02,0.87036e-02,0.88524e-02 /)
      kao(:, 2, 1, 9) = (/ &
        & 0.14296e-01,0.13450e-01,0.12870e-01,0.12297e-01,0.11684e-01, &
        & 0.11070e-01,0.10452e-01,0.97477e-02,0.10154e-01 /)
      kao(:, 3, 1, 9) = (/ &
        & 0.14166e-01,0.13524e-01,0.13158e-01,0.12768e-01,0.12317e-01, &
        & 0.11876e-01,0.11397e-01,0.10864e-01,0.11523e-01 /)
      kao(:, 4, 1, 9) = (/ &
        & 0.14022e-01,0.13622e-01,0.13487e-01,0.13264e-01,0.13003e-01, &
        & 0.12732e-01,0.12371e-01,0.12050e-01,0.12968e-01 /)
      kao(:, 5, 1, 9) = (/ &
        & 0.13872e-01,0.13730e-01,0.13820e-01,0.13802e-01,0.13718e-01, &
        & 0.13604e-01,0.13373e-01,0.13315e-01,0.14498e-01 /)
      kao(:, 1, 2, 9) = (/ &
        & 0.14547e-01,0.13535e-01,0.12726e-01,0.11955e-01,0.11121e-01, &
        & 0.10242e-01,0.92998e-02,0.82716e-02,0.79571e-02 /)
      kao(:, 2, 2, 9) = (/ &
        & 0.14415e-01,0.13577e-01,0.12984e-01,0.12377e-01,0.11698e-01, &
        & 0.10932e-01,0.10129e-01,0.92199e-02,0.91565e-02 /)
      kao(:, 3, 2, 9) = (/ &
        & 0.14274e-01,0.13649e-01,0.13264e-01,0.12845e-01,0.12290e-01, &
        & 0.11686e-01,0.11026e-01,0.10231e-01,0.10415e-01 /)
      kao(:, 4, 2, 9) = (/ &
        & 0.14122e-01,0.13744e-01,0.13589e-01,0.13325e-01,0.12935e-01, &
        & 0.12484e-01,0.11950e-01,0.11311e-01,0.11744e-01 /)
      kao(:, 5, 2, 9) = (/ &
        & 0.13965e-01,0.13855e-01,0.13924e-01,0.13828e-01,0.13608e-01, &
        & 0.13305e-01,0.12905e-01,0.12457e-01,0.13151e-01 /)
      kao(:, 1, 3, 9) = (/ &
        & 0.14475e-01,0.13482e-01,0.12654e-01,0.11861e-01,0.10971e-01, &
        & 0.99930e-02,0.88735e-02,0.76595e-02,0.68509e-02 /)
      kao(:, 2, 3, 9) = (/ &
        & 0.14335e-01,0.13514e-01,0.12906e-01,0.12263e-01,0.11533e-01, &
        & 0.10637e-01,0.96386e-02,0.85394e-02,0.79297e-02 /)
      kao(:, 3, 3, 9) = (/ &
        & 0.14181e-01,0.13576e-01,0.13177e-01,0.12719e-01,0.12099e-01, &
        & 0.11329e-01,0.10466e-01,0.94601e-02,0.90731e-02 /)
      kao(:, 4, 3, 9) = (/ &
        & 0.14024e-01,0.13665e-01,0.13491e-01,0.13188e-01,0.12703e-01, &
        & 0.12072e-01,0.11323e-01,0.10433e-01,0.10295e-01 /)
      kao(:, 5, 3, 9) = (/ &
        & 0.13862e-01,0.13772e-01,0.13824e-01,0.13679e-01,0.13333e-01, &
        & 0.12836e-01,0.12214e-01,0.11468e-01,0.11588e-01 /)
      kao(:, 1, 4, 9) = (/ &
        & 0.14153e-01,0.13216e-01,0.12406e-01,0.11612e-01,0.10690e-01, &
        & 0.96495e-02,0.84088e-02,0.70121e-02,0.57874e-02 /)
      kao(:, 2, 4, 9) = (/ &
        & 0.14005e-01,0.13241e-01,0.12647e-01,0.11995e-01,0.11231e-01, &
        & 0.10266e-01,0.91127e-02,0.78123e-02,0.67372e-02 /)
      kao(:, 3, 4, 9) = (/ &
        & 0.13845e-01,0.13290e-01,0.12907e-01,0.12438e-01,0.11783e-01, &
        & 0.10918e-01,0.98730e-02,0.86646e-02,0.77601e-02 /)
      kao(:, 4, 4, 9) = (/ &
        & 0.13685e-01,0.13375e-01,0.13206e-01,0.12899e-01,0.12360e-01, &
        & 0.11608e-01,0.10665e-01,0.95624e-02,0.88628e-02 /)
      kao(:, 5, 4, 9) = (/ &
        & 0.13529e-01,0.13472e-01,0.13531e-01,0.13371e-01,0.12964e-01, &
        & 0.12311e-01,0.11491e-01,0.10508e-01,0.10039e-01 /)
      kao(:, 1, 5, 9) = (/ &
        & 0.13587e-01,0.12730e-01,0.11973e-01,0.11204e-01,0.10282e-01, &
        & 0.92218e-02,0.79316e-02,0.64044e-02,0.48583e-02 /)
      kao(:, 2, 5, 9) = (/ &
        & 0.13430e-01,0.12751e-01,0.12205e-01,0.11567e-01,0.10798e-01, &
        & 0.98163e-02,0.85810e-02,0.71221e-02,0.56837e-02 /)
      kao(:, 3, 5, 9) = (/ &
        & 0.13271e-01,0.12793e-01,0.12448e-01,0.11993e-01,0.11338e-01, &
        & 0.10437e-01,0.92786e-02,0.78957e-02,0.65802e-02 /)
      kao(:, 4, 5, 9) = (/ &
        & 0.13115e-01,0.12874e-01,0.12735e-01,0.12440e-01,0.11897e-01, &
        & 0.11094e-01,0.10003e-01,0.87146e-02,0.75565e-02 /)
      kao(:, 5, 5, 9) = (/ &
        & 0.12984e-01,0.12973e-01,0.13053e-01,0.12899e-01,0.12481e-01, &
        & 0.11759e-01,0.10765e-01,0.95850e-02,0.86117e-02 /)
      kao(:, 1, 6, 9) = (/ &
        & 0.12817e-01,0.12050e-01,0.11369e-01,0.10622e-01,0.97180e-02, &
        & 0.86745e-02,0.73942e-02,0.58154e-02,0.40318e-02 /)
      kao(:, 2, 6, 9) = (/ &
        & 0.12656e-01,0.12077e-01,0.11582e-01,0.10960e-01,0.10205e-01, &
        & 0.92477e-02,0.80000e-02,0.64500e-02,0.47452e-02 /)
      kao(:, 3, 6, 9) = (/ &
        & 0.12499e-01,0.12115e-01,0.11810e-01,0.11361e-01,0.10734e-01, &
        & 0.98374e-02,0.86412e-02,0.71467e-02,0.55214e-02 /)
      kao(:, 4, 6, 9) = (/ &
        & 0.12364e-01,0.12194e-01,0.12081e-01,0.11798e-01,0.11270e-01, &
        & 0.10459e-01,0.93144e-02,0.78844e-02,0.63718e-02 /)
      kao(:, 5, 6, 9) = (/ &
        & 0.12255e-01,0.12311e-01,0.12390e-01,0.12242e-01,0.11833e-01, &
        & 0.11093e-01,0.10016e-01,0.86730e-02,0.72984e-02 /)
      kao(:, 1, 7, 9) = (/ &
        & 0.11891e-01,0.11226e-01,0.10633e-01,0.99134e-02,0.90439e-02, &
        & 0.80297e-02,0.68136e-02,0.52756e-02,0.33216e-02 /)
      kao(:, 2, 7, 9) = (/ &
        & 0.11730e-01,0.11250e-01,0.10822e-01,0.10230e-01,0.94903e-02, &
        & 0.85683e-02,0.73765e-02,0.58347e-02,0.39310e-02 /)
      kao(:, 3, 7, 9) = (/ &
        & 0.11586e-01,0.11299e-01,0.11036e-01,0.10599e-01,0.99917e-02, &
        & 0.91260e-02,0.79645e-02,0.64502e-02,0.46031e-02 /)
      kao(:, 4, 7, 9) = (/ &
        & 0.11473e-01,0.11391e-01,0.11290e-01,0.11015e-01,0.10500e-01, &
        & 0.97132e-02,0.85920e-02,0.71112e-02,0.53403e-02 /)
      kao(:, 5, 7, 9) = (/ &
        & 0.11384e-01,0.11524e-01,0.11598e-01,0.11442e-01,0.11036e-01, &
        & 0.10317e-01,0.92441e-02,0.78209e-02,0.61457e-02 /)
      kao(:, 1, 8, 9) = (/ &
        & 0.10852e-01,0.10302e-01,0.97896e-02,0.91138e-02,0.83000e-02, &
        & 0.73373e-02,0.61956e-02,0.47644e-02,0.26652e-02 /)
      kao(:, 2, 8, 9) = (/ &
        & 0.10699e-01,0.10325e-01,0.99631e-02,0.94045e-02,0.87025e-02, &
        & 0.78255e-02,0.67137e-02,0.52638e-02,0.31922e-02 /)
      kao(:, 3, 8, 9) = (/ &
        & 0.10574e-01,0.10385e-01,0.10163e-01,0.97460e-02,0.91609e-02, &
        & 0.83418e-02,0.72560e-02,0.58143e-02,0.37766e-02 /)
      kao(:, 4, 8, 9) = (/ &
        & 0.10480e-01,0.10499e-01,0.10413e-01,0.10139e-01,0.96342e-02, &
        & 0.88826e-02,0.78405e-02,0.64037e-02,0.44295e-02 /)
      kao(:, 5, 8, 9) = (/ &
        & 0.10415e-01,0.10646e-01,0.10720e-01,0.10553e-01,0.10134e-01, &
        & 0.94529e-02,0.84471e-02,0.70384e-02,0.51485e-02 /)
      kao(:, 1, 9, 9) = (/ &
        & 0.97587e-02,0.93185e-02,0.88694e-02,0.82517e-02,0.75094e-02, &
        & 0.66177e-02,0.55658e-02,0.42591e-02,0.21931e-02 /)
      kao(:, 2, 9, 9) = (/ &
        & 0.96183e-02,0.93436e-02,0.90329e-02,0.85198e-02,0.78654e-02, &
        & 0.70507e-02,0.60316e-02,0.47067e-02,0.25691e-02 /)
      kao(:, 3, 9, 9) = (/ &
        & 0.95112e-02,0.94166e-02,0.92325e-02,0.88355e-02,0.82791e-02, &
        & 0.75194e-02,0.65208e-02,0.52003e-02,0.29789e-02 /)
      kao(:, 4, 9, 9) = (/ &
        & 0.94373e-02,0.95446e-02,0.94815e-02,0.92092e-02,0.87140e-02, &
        & 0.80091e-02,0.70556e-02,0.57344e-02,0.34284e-02 /)
      kao(:, 5, 9, 9) = (/ &
        & 0.93945e-02,0.97041e-02,0.97866e-02,0.96055e-02,0.91834e-02, &
        & 0.85358e-02,0.76199e-02,0.63067e-02,0.39360e-02 /)
      kao(:, 1,10, 9) = (/ &
        & 0.86571e-02,0.83282e-02,0.79327e-02,0.73862e-02,0.67217e-02, &
        & 0.59210e-02,0.49777e-02,0.37950e-02,0.25161e-02 /)
      kao(:, 2,10, 9) = (/ &
        & 0.85351e-02,0.83629e-02,0.80910e-02,0.76400e-02,0.70398e-02, &
        & 0.63068e-02,0.53903e-02,0.41966e-02,0.29067e-02 /)
      kao(:, 3,10, 9) = (/ &
        & 0.84483e-02,0.84483e-02,0.82944e-02,0.79338e-02,0.74159e-02, &
        & 0.67272e-02,0.58285e-02,0.46411e-02,0.33599e-02 /)
      kao(:, 4,10, 9) = (/ &
        & 0.83941e-02,0.85821e-02,0.85440e-02,0.82866e-02,0.78214e-02, &
        & 0.71692e-02,0.63103e-02,0.51290e-02,0.38620e-02 /)
      kao(:, 5,10, 9) = (/ &
        & 0.83806e-02,0.87510e-02,0.88459e-02,0.86620e-02,0.82607e-02, &
        & 0.76554e-02,0.68267e-02,0.56504e-02,0.44001e-02 /)
      kao(:, 1,11, 9) = (/ &
        & 0.75570e-02,0.73902e-02,0.70826e-02,0.66405e-02,0.60731e-02, &
        & 0.53892e-02,0.45656e-02,0.35050e-02,0.26164e-02 /)
      kao(:, 2,11, 9) = (/ &
        & 0.74683e-02,0.74501e-02,0.72578e-02,0.68886e-02,0.63823e-02, &
        & 0.57485e-02,0.49402e-02,0.38790e-02,0.30097e-02 /)
      kao(:, 3,11, 9) = (/ &
        & 0.74153e-02,0.75630e-02,0.74762e-02,0.71912e-02,0.67425e-02, &
        & 0.61326e-02,0.53447e-02,0.42990e-02,0.34771e-02 /)
      kao(:, 4,11, 9) = (/ &
        & 0.74057e-02,0.77202e-02,0.77477e-02,0.75330e-02,0.71268e-02, &
        & 0.65549e-02,0.57951e-02,0.47555e-02,0.39884e-02 /)
      kao(:, 5,11, 9) = (/ &
        & 0.74391e-02,0.79220e-02,0.80561e-02,0.79014e-02,0.75514e-02, &
        & 0.70214e-02,0.62779e-02,0.52483e-02,0.45376e-02 /)
      kao(:, 1,12, 9) = (/ &
        & 0.65546e-02,0.65200e-02,0.62910e-02,0.59243e-02,0.54454e-02, &
        & 0.48623e-02,0.41386e-02,0.32013e-02,0.25137e-02 /)
      kao(:, 2,12, 9) = (/ &
        & 0.64987e-02,0.66047e-02,0.64774e-02,0.61754e-02,0.57483e-02, &
        & 0.51910e-02,0.44799e-02,0.35500e-02,0.28998e-02 /)
      kao(:, 3,12, 9) = (/ &
        & 0.64867e-02,0.67439e-02,0.67077e-02,0.64758e-02,0.60840e-02, &
        & 0.55472e-02,0.48582e-02,0.39433e-02,0.33472e-02 /)
      kao(:, 4,12, 9) = (/ &
        & 0.65214e-02,0.69269e-02,0.69913e-02,0.68034e-02,0.64480e-02, &
        & 0.59497e-02,0.52811e-02,0.43712e-02,0.38283e-02 /)
      kao(:, 5,12, 9) = (/ &
        & 0.66068e-02,0.71634e-02,0.73032e-02,0.71670e-02,0.68605e-02, &
        & 0.63896e-02,0.57387e-02,0.48340e-02,0.43614e-02 /)
      kao(:, 1,13, 9) = (/ &
        & 0.56598e-02,0.57241e-02,0.55653e-02,0.52616e-02,0.48615e-02, &
        & 0.43534e-02,0.37143e-02,0.28975e-02,0.22483e-02 /)
      kao(:, 2,13, 9) = (/ &
        & 0.56408e-02,0.58364e-02,0.57539e-02,0.55120e-02,0.51475e-02, &
        & 0.46559e-02,0.40284e-02,0.32222e-02,0.26111e-02 /)
      kao(:, 3,13, 9) = (/ &
        & 0.56697e-02,0.59982e-02,0.59981e-02,0.58053e-02,0.54583e-02, &
        & 0.49917e-02,0.43867e-02,0.35862e-02,0.30268e-02 /)
      kao(:, 4,13, 9) = (/ &
        & 0.57519e-02,0.62108e-02,0.62874e-02,0.61219e-02,0.58111e-02, &
        & 0.53715e-02,0.47851e-02,0.39858e-02,0.34700e-02 /)
      kao(:, 5,13, 9) = (/ &
        & 0.58830e-02,0.64813e-02,0.66064e-02,0.64830e-02,0.62068e-02, &
        & 0.57872e-02,0.52185e-02,0.44205e-02,0.39619e-02 /)
      kao(:, 1, 1,10) = (/ &
        & 0.28544e-01,0.26155e-01,0.24149e-01,0.22667e-01,0.21632e-01, &
        & 0.20279e-01,0.18489e-01,0.17580e-01,0.19616e-01 /)
      kao(:, 2, 1,10) = (/ &
        & 0.28363e-01,0.26242e-01,0.24669e-01,0.23473e-01,0.22995e-01, &
        & 0.21803e-01,0.19985e-01,0.19915e-01,0.22325e-01 /)
      kao(:, 3, 1,10) = (/ &
        & 0.28168e-01,0.26278e-01,0.25280e-01,0.24624e-01,0.24316e-01, &
        & 0.23197e-01,0.21657e-01,0.22779e-01,0.25626e-01 /)
      kao(:, 4, 1,10) = (/ &
        & 0.27980e-01,0.26431e-01,0.25828e-01,0.25920e-01,0.25669e-01, &
        & 0.24755e-01,0.23686e-01,0.25934e-01,0.29281e-01 /)
      kao(:, 5, 1,10) = (/ &
        & 0.27732e-01,0.26646e-01,0.26660e-01,0.27009e-01,0.27233e-01, &
        & 0.26525e-01,0.25997e-01,0.29201e-01,0.33040e-01 /)
      kao(:, 1, 2,10) = (/ &
        & 0.30271e-01,0.27672e-01,0.25272e-01,0.23430e-01,0.22043e-01, &
        & 0.20727e-01,0.19083e-01,0.16913e-01,0.18728e-01 /)
      kao(:, 2, 2,10) = (/ &
        & 0.30091e-01,0.27720e-01,0.25820e-01,0.24222e-01,0.23409e-01, &
        & 0.22468e-01,0.20609e-01,0.19148e-01,0.21375e-01 /)
      kao(:, 3, 2,10) = (/ &
        & 0.29914e-01,0.27750e-01,0.26375e-01,0.25267e-01,0.24987e-01, &
        & 0.23926e-01,0.22306e-01,0.21932e-01,0.24591e-01 /)
      kao(:, 4, 2,10) = (/ &
        & 0.29701e-01,0.27873e-01,0.26877e-01,0.26535e-01,0.26327e-01, &
        & 0.25568e-01,0.24303e-01,0.24920e-01,0.28049e-01 /)
      kao(:, 5, 2,10) = (/ &
        & 0.29422e-01,0.28052e-01,0.27653e-01,0.27818e-01,0.27831e-01, &
        & 0.27375e-01,0.26338e-01,0.28129e-01,0.31777e-01 /)
      kao(:, 1, 3,10) = (/ &
        & 0.32089e-01,0.29221e-01,0.26504e-01,0.24372e-01,0.22322e-01, &
        & 0.20541e-01,0.19063e-01,0.16413e-01,0.17368e-01 /)
      kao(:, 2, 3,10) = (/ &
        & 0.31950e-01,0.29299e-01,0.26979e-01,0.25078e-01,0.23422e-01, &
        & 0.22454e-01,0.20735e-01,0.18244e-01,0.19956e-01 /)
      kao(:, 3, 3,10) = (/ &
        & 0.31786e-01,0.29316e-01,0.27496e-01,0.25889e-01,0.24965e-01, &
        & 0.24089e-01,0.22376e-01,0.20693e-01,0.22993e-01 /)
      kao(:, 4, 3,10) = (/ &
        & 0.31564e-01,0.29393e-01,0.27942e-01,0.27000e-01,0.26402e-01, &
        & 0.25715e-01,0.24406e-01,0.23371e-01,0.26093e-01 /)
      kao(:, 5, 3,10) = (/ &
        & 0.31295e-01,0.29526e-01,0.28627e-01,0.28150e-01,0.27951e-01, &
        & 0.27569e-01,0.26423e-01,0.26332e-01,0.29505e-01 /)
      kao(:, 1, 4,10) = (/ &
        & 0.33998e-01,0.30694e-01,0.27710e-01,0.25291e-01,0.22809e-01, &
        & 0.20329e-01,0.18660e-01,0.16131e-01,0.15800e-01 /)
      kao(:, 2, 4,10) = (/ &
        & 0.33852e-01,0.30861e-01,0.28097e-01,0.25930e-01,0.23654e-01, &
        & 0.22029e-01,0.20474e-01,0.17896e-01,0.18339e-01 /)
      kao(:, 3, 4,10) = (/ &
        & 0.33685e-01,0.30889e-01,0.28668e-01,0.26585e-01,0.25018e-01, &
        & 0.23681e-01,0.22215e-01,0.19897e-01,0.21224e-01 /)
      kao(:, 4, 4,10) = (/ &
        & 0.33431e-01,0.30933e-01,0.29107e-01,0.27570e-01,0.26341e-01, &
        & 0.25360e-01,0.24234e-01,0.22138e-01,0.24217e-01 /)
      kao(:, 5, 4,10) = (/ &
        & 0.33153e-01,0.31115e-01,0.29708e-01,0.28626e-01,0.27757e-01, &
        & 0.27318e-01,0.26191e-01,0.24666e-01,0.27426e-01 /)
      kao(:, 1, 5,10) = (/ &
        & 0.35630e-01,0.31962e-01,0.28969e-01,0.26191e-01,0.23359e-01, &
        & 0.20419e-01,0.18025e-01,0.15529e-01,0.14046e-01 /)
      kao(:, 2, 5,10) = (/ &
        & 0.35465e-01,0.32227e-01,0.29248e-01,0.26845e-01,0.24076e-01, &
        & 0.21854e-01,0.19842e-01,0.17371e-01,0.16514e-01 /)
      kao(:, 3, 5,10) = (/ &
        & 0.35239e-01,0.32283e-01,0.29869e-01,0.27436e-01,0.25256e-01, &
        & 0.23352e-01,0.21638e-01,0.19381e-01,0.19322e-01 /)
      kao(:, 4, 5,10) = (/ &
        & 0.34959e-01,0.32275e-01,0.30321e-01,0.28325e-01,0.26494e-01, &
        & 0.24825e-01,0.23722e-01,0.21526e-01,0.22221e-01 /)
      kao(:, 5, 5,10) = (/ &
        & 0.34633e-01,0.32463e-01,0.30867e-01,0.29345e-01,0.27730e-01, &
        & 0.26661e-01,0.25760e-01,0.23698e-01,0.25325e-01 /)
      kao(:, 1, 6,10) = (/ &
        & 0.36611e-01,0.32766e-01,0.29862e-01,0.26964e-01,0.23985e-01, &
        & 0.20572e-01,0.17499e-01,0.14612e-01,0.12200e-01 /)
      kao(:, 2, 6,10) = (/ &
        & 0.36404e-01,0.32931e-01,0.30135e-01,0.27680e-01,0.24618e-01, &
        & 0.21792e-01,0.19087e-01,0.16488e-01,0.14408e-01 /)
      kao(:, 3, 6,10) = (/ &
        & 0.36151e-01,0.33151e-01,0.30783e-01,0.28229e-01,0.25608e-01, &
        & 0.23215e-01,0.20762e-01,0.18415e-01,0.17025e-01 /)
      kao(:, 4, 6,10) = (/ &
        & 0.35835e-01,0.33169e-01,0.31261e-01,0.29020e-01,0.26813e-01, &
        & 0.24559e-01,0.22662e-01,0.20622e-01,0.19846e-01 /)
      kao(:, 5, 6,10) = (/ &
        & 0.35491e-01,0.33330e-01,0.31756e-01,0.30047e-01,0.27916e-01, &
        & 0.26189e-01,0.24713e-01,0.22859e-01,0.22839e-01 /)
      kao(:, 1, 7,10) = (/ &
        & 0.36793e-01,0.32943e-01,0.30074e-01,0.27299e-01,0.24319e-01, &
        & 0.20802e-01,0.17113e-01,0.13465e-01,0.10508e-01 /)
      kao(:, 2, 7,10) = (/ &
        & 0.36572e-01,0.33074e-01,0.30511e-01,0.28032e-01,0.24986e-01, &
        & 0.21844e-01,0.18570e-01,0.15283e-01,0.12467e-01 /)
      kao(:, 3, 7,10) = (/ &
        & 0.36275e-01,0.33234e-01,0.31161e-01,0.28602e-01,0.25904e-01, &
        & 0.23164e-01,0.20091e-01,0.17151e-01,0.14775e-01 /)
      kao(:, 4, 7,10) = (/ &
        & 0.35925e-01,0.33332e-01,0.31658e-01,0.29367e-01,0.27125e-01, &
        & 0.24431e-01,0.21734e-01,0.19261e-01,0.17350e-01 /)
      kao(:, 5, 7,10) = (/ &
        & 0.35558e-01,0.33506e-01,0.32097e-01,0.30412e-01,0.28219e-01, &
        & 0.25923e-01,0.23598e-01,0.21456e-01,0.20114e-01 /)
      kao(:, 1, 8,10) = (/ &
        & 0.36293e-01,0.32550e-01,0.29721e-01,0.27154e-01,0.24076e-01, &
        & 0.20693e-01,0.16829e-01,0.12555e-01,0.89579e-02 /)
      kao(:, 2, 8,10) = (/ &
        & 0.35985e-01,0.32624e-01,0.30270e-01,0.27879e-01,0.24830e-01, &
        & 0.21669e-01,0.18126e-01,0.14126e-01,0.10649e-01 /)
      kao(:, 3, 8,10) = (/ &
        & 0.35646e-01,0.32730e-01,0.30946e-01,0.28474e-01,0.25750e-01, &
        & 0.23017e-01,0.19564e-01,0.15741e-01,0.12721e-01 /)
      kao(:, 4, 8,10) = (/ &
        & 0.35279e-01,0.32754e-01,0.31424e-01,0.29187e-01,0.27070e-01, &
        & 0.24316e-01,0.21018e-01,0.17682e-01,0.15011e-01 /)
      kao(:, 5, 8,10) = (/ &
        & 0.34858e-01,0.32947e-01,0.31835e-01,0.30265e-01,0.28236e-01, &
        & 0.25710e-01,0.22721e-01,0.19777e-01,0.17474e-01 /)
      kao(:, 1, 9,10) = (/ &
        & 0.35060e-01,0.31556e-01,0.29012e-01,0.26469e-01,0.23391e-01, &
        & 0.20141e-01,0.16295e-01,0.11885e-01,0.58937e-02 /)
      kao(:, 2, 9,10) = (/ &
        & 0.34721e-01,0.31589e-01,0.29506e-01,0.27211e-01,0.24267e-01, &
        & 0.21055e-01,0.17547e-01,0.13263e-01,0.69908e-02 /)
      kao(:, 3, 9,10) = (/ &
        & 0.34339e-01,0.31609e-01,0.30075e-01,0.27841e-01,0.25163e-01, &
        & 0.22398e-01,0.18997e-01,0.14640e-01,0.92447e-02 /)
      kao(:, 4, 9,10) = (/ &
        & 0.33936e-01,0.31619e-01,0.30603e-01,0.28503e-01,0.26490e-01, &
        & 0.23804e-01,0.20342e-01,0.16280e-01,0.11993e-01 /)
      kao(:, 5, 9,10) = (/ &
        & 0.33530e-01,0.31821e-01,0.30991e-01,0.29578e-01,0.27714e-01, &
        & 0.25218e-01,0.21886e-01,0.18137e-01,0.14941e-01 /)
      kao(:, 1,10,10) = (/ &
        & 0.33129e-01,0.29964e-01,0.27856e-01,0.25331e-01,0.22401e-01, &
        & 0.19295e-01,0.15555e-01,0.11348e-01,0.74286e-02 /)
      kao(:, 2,10,10) = (/ &
        & 0.32749e-01,0.29950e-01,0.28249e-01,0.25998e-01,0.23402e-01, &
        & 0.20209e-01,0.16757e-01,0.12616e-01,0.86653e-02 /)
      kao(:, 3,10,10) = (/ &
        & 0.32344e-01,0.29933e-01,0.28722e-01,0.26736e-01,0.24275e-01, &
        & 0.21508e-01,0.18229e-01,0.13852e-01,0.98082e-02 /)
      kao(:, 4,10,10) = (/ &
        & 0.31944e-01,0.30002e-01,0.29235e-01,0.27435e-01,0.25548e-01, &
        & 0.22964e-01,0.19579e-01,0.15278e-01,0.11352e-01 /)
      kao(:, 5,10,10) = (/ &
        & 0.31533e-01,0.30276e-01,0.29685e-01,0.28539e-01,0.26795e-01, &
        & 0.24358e-01,0.21106e-01,0.16900e-01,0.12858e-01 /)
      kao(:, 1,11,10) = (/ &
        & 0.30476e-01,0.27848e-01,0.26383e-01,0.23991e-01,0.21505e-01, &
        & 0.18546e-01,0.15127e-01,0.11242e-01,0.84064e-02 /)
      kao(:, 2,11,10) = (/ &
        & 0.30069e-01,0.27873e-01,0.26695e-01,0.24743e-01,0.22441e-01, &
        & 0.19591e-01,0.16445e-01,0.12465e-01,0.99520e-02 /)
      kao(:, 3,11,10) = (/ &
        & 0.29683e-01,0.27938e-01,0.27199e-01,0.25464e-01,0.23474e-01, &
        & 0.21008e-01,0.17841e-01,0.13636e-01,0.11012e-01 /)
      kao(:, 4,11,10) = (/ &
        & 0.29281e-01,0.28147e-01,0.27612e-01,0.26457e-01,0.24810e-01, &
        & 0.22367e-01,0.19198e-01,0.15026e-01,0.12764e-01 /)
      kao(:, 5,11,10) = (/ &
        & 0.28878e-01,0.28450e-01,0.28275e-01,0.27607e-01,0.26039e-01, &
        & 0.23769e-01,0.20798e-01,0.16479e-01,0.14486e-01 /)
      kao(:, 1,12,10) = (/ &
        & 0.27483e-01,0.25515e-01,0.24398e-01,0.22423e-01,0.20204e-01, &
        & 0.17532e-01,0.14597e-01,0.10977e-01,0.89256e-02 /)
      kao(:, 2,12,10) = (/ &
        & 0.27095e-01,0.25634e-01,0.24782e-01,0.23175e-01,0.21102e-01, &
        & 0.18740e-01,0.15902e-01,0.12114e-01,0.10252e-01 /)
      kao(:, 3,12,10) = (/ &
        & 0.26727e-01,0.25761e-01,0.25266e-01,0.23974e-01,0.22361e-01, &
        & 0.20171e-01,0.17193e-01,0.13275e-01,0.11451e-01 /)
      kao(:, 4,12,10) = (/ &
        & 0.26341e-01,0.26039e-01,0.25768e-01,0.25146e-01,0.23693e-01, &
        & 0.21452e-01,0.18566e-01,0.14626e-01,0.13159e-01 /)
      kao(:, 5,12,10) = (/ &
        & 0.25958e-01,0.26232e-01,0.26607e-01,0.26277e-01,0.24926e-01, &
        & 0.22906e-01,0.20118e-01,0.16018e-01,0.14784e-01 /)
      kao(:, 1,13,10) = (/ &
        & 0.24404e-01,0.23195e-01,0.22191e-01,0.20664e-01,0.18645e-01, &
        & 0.16397e-01,0.13889e-01,0.10532e-01,0.85762e-02 /)
      kao(:, 2,13,10) = (/ &
        & 0.24045e-01,0.23274e-01,0.22704e-01,0.21382e-01,0.19651e-01, &
        & 0.17693e-01,0.15133e-01,0.11576e-01,0.96068e-02 /)
      kao(:, 3,13,10) = (/ &
        & 0.23688e-01,0.23458e-01,0.23185e-01,0.22281e-01,0.21010e-01, &
        & 0.19021e-01,0.16312e-01,0.12755e-01,0.10813e-01 /)
      kao(:, 4,13,10) = (/ &
        & 0.23340e-01,0.23719e-01,0.23835e-01,0.23529e-01,0.22269e-01, &
        & 0.20297e-01,0.17677e-01,0.14063e-01,0.12469e-01 /)
      kao(:, 5,13,10) = (/ &
        & 0.23007e-01,0.23887e-01,0.24745e-01,0.24636e-01,0.23538e-01, &
        & 0.21795e-01,0.19163e-01,0.15452e-01,0.13866e-01 /)
      kao(:, 1, 1,11) = (/ &
        & 0.38207e-01,0.35023e-01,0.31764e-01,0.29513e-01,0.27148e-01, &
        & 0.25121e-01,0.22678e-01,0.23928e-01,0.26899e-01 /)
      kao(:, 2, 1,11) = (/ &
        & 0.37930e-01,0.35272e-01,0.32250e-01,0.30760e-01,0.28557e-01, &
        & 0.27105e-01,0.25089e-01,0.27604e-01,0.31070e-01 /)
      kao(:, 3, 1,11) = (/ &
        & 0.37611e-01,0.35491e-01,0.32949e-01,0.31869e-01,0.30632e-01, &
        & 0.29068e-01,0.27897e-01,0.31369e-01,0.35419e-01 /)
      kao(:, 4, 1,11) = (/ &
        & 0.37244e-01,0.35566e-01,0.33874e-01,0.33253e-01,0.32466e-01, &
        & 0.31095e-01,0.31358e-01,0.35716e-01,0.40368e-01 /)
      kao(:, 5, 1,11) = (/ &
        & 0.36895e-01,0.35750e-01,0.34817e-01,0.35038e-01,0.34265e-01, &
        & 0.33428e-01,0.35709e-01,0.40899e-01,0.46337e-01 /)
      kao(:, 1, 2,11) = (/ &
        & 0.39640e-01,0.36208e-01,0.33140e-01,0.30731e-01,0.28621e-01, &
        & 0.26451e-01,0.23824e-01,0.23418e-01,0.26401e-01 /)
      kao(:, 2, 2,11) = (/ &
        & 0.39384e-01,0.36543e-01,0.33542e-01,0.32043e-01,0.30032e-01, &
        & 0.28484e-01,0.26191e-01,0.27027e-01,0.30540e-01 /)
      kao(:, 3, 2,11) = (/ &
        & 0.39069e-01,0.36650e-01,0.34340e-01,0.33119e-01,0.32037e-01, &
        & 0.30787e-01,0.28410e-01,0.30659e-01,0.34733e-01 /)
      kao(:, 4, 2,11) = (/ &
        & 0.38756e-01,0.36738e-01,0.35220e-01,0.34547e-01,0.34264e-01, &
        & 0.32872e-01,0.31204e-01,0.34827e-01,0.39529e-01 /)
      kao(:, 5, 2,11) = (/ &
        & 0.38432e-01,0.36958e-01,0.36077e-01,0.36343e-01,0.36389e-01, &
        & 0.35222e-01,0.34916e-01,0.39622e-01,0.45018e-01 /)
      kao(:, 1, 3,11) = (/ &
        & 0.41762e-01,0.37801e-01,0.34598e-01,0.31385e-01,0.29542e-01, &
        & 0.27120e-01,0.24296e-01,0.22163e-01,0.24873e-01 /)
      kao(:, 2, 3,11) = (/ &
        & 0.41521e-01,0.38107e-01,0.34885e-01,0.32740e-01,0.30892e-01, &
        & 0.28927e-01,0.26874e-01,0.25608e-01,0.28828e-01 /)
      kao(:, 3, 3,11) = (/ &
        & 0.41284e-01,0.38250e-01,0.35590e-01,0.33929e-01,0.32637e-01, &
        & 0.31412e-01,0.29268e-01,0.29038e-01,0.32851e-01 /)
      kao(:, 4, 3,11) = (/ &
        & 0.40996e-01,0.38286e-01,0.36402e-01,0.35356e-01,0.34868e-01, &
        & 0.33799e-01,0.31619e-01,0.33158e-01,0.37659e-01 /)
      kao(:, 5, 3,11) = (/ &
        & 0.40710e-01,0.38497e-01,0.37108e-01,0.37161e-01,0.37098e-01, &
        & 0.36226e-01,0.34568e-01,0.37733e-01,0.42953e-01 /)
      kao(:, 1, 4,11) = (/ &
        & 0.44432e-01,0.39911e-01,0.36533e-01,0.32358e-01,0.30116e-01, &
        & 0.27425e-01,0.24391e-01,0.21003e-01,0.22873e-01 /)
      kao(:, 2, 4,11) = (/ &
        & 0.44241e-01,0.40248e-01,0.36750e-01,0.33734e-01,0.31371e-01, &
        & 0.29050e-01,0.26929e-01,0.23993e-01,0.26696e-01 /)
      kao(:, 3, 4,11) = (/ &
        & 0.43986e-01,0.40474e-01,0.37358e-01,0.34847e-01,0.32894e-01, &
        & 0.31475e-01,0.29486e-01,0.27256e-01,0.30632e-01 /)
      kao(:, 4, 4,11) = (/ &
        & 0.43750e-01,0.40487e-01,0.38107e-01,0.36115e-01,0.35063e-01, &
        & 0.33924e-01,0.31967e-01,0.31144e-01,0.35198e-01 /)
      kao(:, 5, 4,11) = (/ &
        & 0.43427e-01,0.40610e-01,0.38702e-01,0.37867e-01,0.37251e-01, &
        & 0.36357e-01,0.34995e-01,0.35502e-01,0.40197e-01 /)
      kao(:, 1, 5,11) = (/ &
        & 0.47176e-01,0.42142e-01,0.38550e-01,0.33884e-01,0.30889e-01, &
        & 0.27516e-01,0.24267e-01,0.20680e-01,0.20851e-01 /)
      kao(:, 2, 5,11) = (/ &
        & 0.47021e-01,0.42363e-01,0.38770e-01,0.35164e-01,0.32104e-01, &
        & 0.29005e-01,0.26645e-01,0.23247e-01,0.24505e-01 /)
      kao(:, 3, 5,11) = (/ &
        & 0.46797e-01,0.42763e-01,0.39235e-01,0.36269e-01,0.33395e-01, &
        & 0.31307e-01,0.29249e-01,0.25924e-01,0.28324e-01 /)
      kao(:, 4, 5,11) = (/ &
        & 0.46572e-01,0.42912e-01,0.40018e-01,0.37361e-01,0.35308e-01, &
        & 0.33789e-01,0.31702e-01,0.29304e-01,0.32735e-01 /)
      kao(:, 5, 5,11) = (/ &
        & 0.46255e-01,0.42923e-01,0.40617e-01,0.38829e-01,0.37399e-01, &
        & 0.36167e-01,0.34686e-01,0.33312e-01,0.37380e-01 /)
      kao(:, 1, 6,11) = (/ &
        & 0.49975e-01,0.44361e-01,0.40341e-01,0.35539e-01,0.31829e-01, &
        & 0.27816e-01,0.23845e-01,0.20093e-01,0.18543e-01 /)
      kao(:, 2, 6,11) = (/ &
        & 0.49828e-01,0.44558e-01,0.40763e-01,0.36628e-01,0.33050e-01, &
        & 0.29095e-01,0.26117e-01,0.22673e-01,0.22099e-01 /)
      kao(:, 3, 6,11) = (/ &
        & 0.49608e-01,0.44841e-01,0.41085e-01,0.37793e-01,0.34135e-01, &
        & 0.31097e-01,0.28755e-01,0.25283e-01,0.25831e-01 /)
      kao(:, 4, 6,11) = (/ &
        & 0.49365e-01,0.45144e-01,0.41922e-01,0.38723e-01,0.35845e-01, &
        & 0.33431e-01,0.31237e-01,0.28118e-01,0.29954e-01 /)
      kao(:, 5, 6,11) = (/ &
        & 0.49026e-01,0.45249e-01,0.42535e-01,0.39993e-01,0.37821e-01, &
        & 0.35671e-01,0.34099e-01,0.31399e-01,0.34366e-01 /)
      kao(:, 1, 7,11) = (/ &
        & 0.52410e-01,0.46362e-01,0.41901e-01,0.37210e-01,0.32800e-01, &
        & 0.28263e-01,0.23499e-01,0.19230e-01,0.16237e-01 /)
      kao(:, 2, 7,11) = (/ &
        & 0.52214e-01,0.46505e-01,0.42451e-01,0.38113e-01,0.34021e-01, &
        & 0.29480e-01,0.25464e-01,0.21812e-01,0.19595e-01 /)
      kao(:, 3, 7,11) = (/ &
        & 0.51982e-01,0.46700e-01,0.42867e-01,0.39292e-01,0.35048e-01, &
        & 0.31222e-01,0.27987e-01,0.24489e-01,0.23138e-01 /)
      kao(:, 4, 7,11) = (/ &
        & 0.51660e-01,0.46904e-01,0.43697e-01,0.40172e-01,0.36555e-01, &
        & 0.33390e-01,0.30506e-01,0.27287e-01,0.27036e-01 /)
      kao(:, 5, 7,11) = (/ &
        & 0.51284e-01,0.47053e-01,0.44408e-01,0.41338e-01,0.38429e-01, &
        & 0.35446e-01,0.33297e-01,0.30383e-01,0.31263e-01 /)
      kao(:, 1, 8,11) = (/ &
        & 0.53849e-01,0.47597e-01,0.43012e-01,0.38373e-01,0.33860e-01, &
        & 0.28679e-01,0.23391e-01,0.18151e-01,0.14106e-01 /)
      kao(:, 2, 8,11) = (/ &
        & 0.53641e-01,0.47671e-01,0.43475e-01,0.39445e-01,0.35042e-01, &
        & 0.29924e-01,0.25055e-01,0.20655e-01,0.17171e-01 /)
      kao(:, 3, 8,11) = (/ &
        & 0.53375e-01,0.47826e-01,0.44020e-01,0.40653e-01,0.36059e-01, &
        & 0.31447e-01,0.27345e-01,0.23357e-01,0.20383e-01 /)
      kao(:, 4, 8,11) = (/ &
        & 0.53001e-01,0.48011e-01,0.44999e-01,0.41558e-01,0.37354e-01, &
        & 0.33601e-01,0.29695e-01,0.26106e-01,0.24004e-01 /)
      kao(:, 5, 8,11) = (/ &
        & 0.52592e-01,0.48152e-01,0.45845e-01,0.42585e-01,0.39198e-01, &
        & 0.35588e-01,0.32287e-01,0.29155e-01,0.27991e-01 /)
      kao(:, 1, 9,11) = (/ &
        & 0.54223e-01,0.47973e-01,0.43289e-01,0.38882e-01,0.34299e-01, &
        & 0.28946e-01,0.23303e-01,0.17068e-01,0.11192e-01 /)
      kao(:, 2, 9,11) = (/ &
        & 0.53940e-01,0.47929e-01,0.43759e-01,0.39916e-01,0.35622e-01, &
        & 0.30345e-01,0.24752e-01,0.19298e-01,0.14778e-01 /)
      kao(:, 3, 9,11) = (/ &
        & 0.53642e-01,0.48095e-01,0.44399e-01,0.41241e-01,0.36768e-01, &
        & 0.31745e-01,0.26845e-01,0.21914e-01,0.17754e-01 /)
      kao(:, 4, 9,11) = (/ &
        & 0.53257e-01,0.48243e-01,0.45322e-01,0.42327e-01,0.37988e-01, &
        & 0.33799e-01,0.29109e-01,0.24533e-01,0.21056e-01 /)
      kao(:, 5, 9,11) = (/ &
        & 0.52778e-01,0.48340e-01,0.46365e-01,0.43326e-01,0.39837e-01, &
        & 0.35758e-01,0.31465e-01,0.27467e-01,0.24721e-01 /)
      kao(:, 1,10,11) = (/ &
        & 0.53564e-01,0.47520e-01,0.42897e-01,0.38870e-01,0.34096e-01, &
        & 0.28762e-01,0.23161e-01,0.16420e-01,0.10403e-01 /)
      kao(:, 2,10,11) = (/ &
        & 0.53200e-01,0.47370e-01,0.43390e-01,0.39812e-01,0.35374e-01, &
        & 0.30449e-01,0.24605e-01,0.18329e-01,0.12727e-01 /)
      kao(:, 3,10,11) = (/ &
        & 0.52804e-01,0.47486e-01,0.44077e-01,0.41029e-01,0.36828e-01, &
        & 0.31909e-01,0.26518e-01,0.20700e-01,0.14792e-01 /)
      kao(:, 4,10,11) = (/ &
        & 0.52379e-01,0.47585e-01,0.44997e-01,0.42270e-01,0.38168e-01, &
        & 0.33930e-01,0.28762e-01,0.23052e-01,0.16495e-01 /)
      kao(:, 5,10,11) = (/ &
        & 0.51859e-01,0.47629e-01,0.45989e-01,0.43387e-01,0.40080e-01, &
        & 0.36007e-01,0.30957e-01,0.25773e-01,0.18898e-01 /)
      kao(:, 1,11,11) = (/ &
        & 0.51622e-01,0.46074e-01,0.42057e-01,0.38618e-01,0.33808e-01, &
        & 0.28847e-01,0.23288e-01,0.16620e-01,0.11907e-01 /)
      kao(:, 2,11,11) = (/ &
        & 0.51193e-01,0.45980e-01,0.42719e-01,0.39541e-01,0.35253e-01, &
        & 0.30566e-01,0.24931e-01,0.18565e-01,0.13988e-01 /)
      kao(:, 3,11,11) = (/ &
        & 0.50740e-01,0.46089e-01,0.43457e-01,0.40804e-01,0.36736e-01, &
        & 0.32310e-01,0.27095e-01,0.20684e-01,0.16681e-01 /)
      kao(:, 4,11,11) = (/ &
        & 0.50228e-01,0.46105e-01,0.44454e-01,0.41838e-01,0.38478e-01, &
        & 0.34580e-01,0.29293e-01,0.22846e-01,0.18301e-01 /)
      kao(:, 5,11,11) = (/ &
        & 0.49697e-01,0.46259e-01,0.45191e-01,0.43198e-01,0.40635e-01, &
        & 0.36709e-01,0.31434e-01,0.25478e-01,0.20947e-01 /)
      kao(:, 1,12,11) = (/ &
        & 0.48647e-01,0.43752e-01,0.40707e-01,0.37500e-01,0.33089e-01, &
        & 0.28489e-01,0.23000e-01,0.16785e-01,0.12627e-01 /)
      kao(:, 2,12,11) = (/ &
        & 0.48181e-01,0.43711e-01,0.41312e-01,0.38500e-01,0.34693e-01, &
        & 0.30128e-01,0.24939e-01,0.18673e-01,0.15167e-01 /)
      kao(:, 3,12,11) = (/ &
        & 0.47678e-01,0.43812e-01,0.42104e-01,0.39699e-01,0.36175e-01, &
        & 0.32199e-01,0.27269e-01,0.20637e-01,0.17826e-01 /)
      kao(:, 4,12,11) = (/ &
        & 0.47181e-01,0.43914e-01,0.43002e-01,0.40767e-01,0.38218e-01, &
        & 0.34662e-01,0.29455e-01,0.22728e-01,0.19785e-01 /)
      kao(:, 5,12,11) = (/ &
        & 0.46685e-01,0.44343e-01,0.43686e-01,0.42426e-01,0.40422e-01, &
        & 0.36842e-01,0.31692e-01,0.25217e-01,0.22679e-01 /)
      kao(:, 1,13,11) = (/ &
        & 0.44854e-01,0.40724e-01,0.38672e-01,0.35614e-01,0.31949e-01, &
        & 0.27602e-01,0.22498e-01,0.16720e-01,0.12798e-01 /)
      kao(:, 2,13,11) = (/ &
        & 0.44381e-01,0.40833e-01,0.39190e-01,0.36792e-01,0.33534e-01, &
        & 0.29330e-01,0.24604e-01,0.18629e-01,0.15661e-01 /)
      kao(:, 3,13,11) = (/ &
        & 0.43916e-01,0.40995e-01,0.40051e-01,0.37975e-01,0.35149e-01, &
        & 0.31642e-01,0.27046e-01,0.20453e-01,0.17792e-01 /)
      kao(:, 4,13,11) = (/ &
        & 0.43441e-01,0.41288e-01,0.40871e-01,0.39278e-01,0.37365e-01, &
        & 0.34126e-01,0.29213e-01,0.22513e-01,0.19591e-01 /)
      kao(:, 5,13,11) = (/ &
        & 0.42963e-01,0.41916e-01,0.41758e-01,0.41144e-01,0.39580e-01, &
        & 0.36327e-01,0.31558e-01,0.24885e-01,0.22715e-01 /)
      kao(:, 1, 1,12) = (/ &
        & 0.52315e-01,0.47505e-01,0.42884e-01,0.38287e-01,0.34721e-01, &
        & 0.30888e-01,0.29687e-01,0.33559e-01,0.37791e-01 /)
      kao(:, 2, 1,12) = (/ &
        & 0.52132e-01,0.47869e-01,0.43358e-01,0.39519e-01,0.36490e-01, &
        & 0.33059e-01,0.34560e-01,0.39434e-01,0.44537e-01 /)
      kao(:, 3, 1,12) = (/ &
        & 0.51859e-01,0.48259e-01,0.44108e-01,0.41053e-01,0.38159e-01, &
        & 0.36325e-01,0.40345e-01,0.46345e-01,0.52382e-01 /)
      kao(:, 4, 1,12) = (/ &
        & 0.51556e-01,0.48650e-01,0.44992e-01,0.42544e-01,0.40704e-01, &
        & 0.40160e-01,0.46427e-01,0.53431e-01,0.60544e-01 /)
      kao(:, 5, 1,12) = (/ &
        & 0.51137e-01,0.48860e-01,0.46168e-01,0.44111e-01,0.43209e-01, &
        & 0.44827e-01,0.52800e-01,0.60972e-01,0.69216e-01 /)
      kao(:, 1, 2,12) = (/ &
        & 0.56434e-01,0.51118e-01,0.46217e-01,0.41561e-01,0.37505e-01, &
        & 0.33646e-01,0.30189e-01,0.33085e-01,0.37424e-01 /)
      kao(:, 2, 2,12) = (/ &
        & 0.56174e-01,0.51590e-01,0.46758e-01,0.42838e-01,0.39459e-01, &
        & 0.35755e-01,0.34261e-01,0.38732e-01,0.43938e-01 /)
      kao(:, 3, 2,12) = (/ &
        & 0.55870e-01,0.52113e-01,0.47459e-01,0.44557e-01,0.41223e-01, &
        & 0.38732e-01,0.39807e-01,0.45508e-01,0.51693e-01 /)
      kao(:, 4, 2,12) = (/ &
        & 0.55457e-01,0.52524e-01,0.48507e-01,0.46112e-01,0.43732e-01, &
        & 0.42045e-01,0.45811e-01,0.52732e-01,0.60004e-01 /)
      kao(:, 5, 2,12) = (/ &
        & 0.54996e-01,0.52680e-01,0.49849e-01,0.47721e-01,0.46514e-01, &
        & 0.45961e-01,0.52270e-01,0.60294e-01,0.68714e-01 /)
      kao(:, 1, 3,12) = (/ &
        & 0.59831e-01,0.53764e-01,0.48883e-01,0.44361e-01,0.39553e-01, &
        & 0.35958e-01,0.31293e-01,0.31467e-01,0.35795e-01 /)
      kao(:, 2, 3,12) = (/ &
        & 0.59532e-01,0.54423e-01,0.49485e-01,0.45554e-01,0.41889e-01, &
        & 0.38044e-01,0.34149e-01,0.36846e-01,0.42078e-01 /)
      kao(:, 3, 3,12) = (/ &
        & 0.59134e-01,0.55152e-01,0.50116e-01,0.47410e-01,0.43907e-01, &
        & 0.40732e-01,0.38444e-01,0.43145e-01,0.49218e-01 /)
      kao(:, 4, 3,12) = (/ &
        & 0.58672e-01,0.55655e-01,0.51271e-01,0.49059e-01,0.46360e-01, &
        & 0.44063e-01,0.43633e-01,0.49781e-01,0.56746e-01 /)
      kao(:, 5, 3,12) = (/ &
        & 0.58134e-01,0.55813e-01,0.52716e-01,0.50709e-01,0.49278e-01, &
        & 0.47427e-01,0.49630e-01,0.57031e-01,0.65034e-01 /)
      kao(:, 1, 4,12) = (/ &
        & 0.62624e-01,0.55864e-01,0.50884e-01,0.46641e-01,0.41202e-01, &
        & 0.37808e-01,0.32728e-01,0.29634e-01,0.33571e-01 /)
      kao(:, 2, 4,12) = (/ &
        & 0.62339e-01,0.56365e-01,0.51618e-01,0.47600e-01,0.43888e-01, &
        & 0.40000e-01,0.35145e-01,0.34591e-01,0.39469e-01 /)
      kao(:, 3, 4,12) = (/ &
        & 0.61969e-01,0.57107e-01,0.52103e-01,0.49599e-01,0.46112e-01, &
        & 0.42482e-01,0.38680e-01,0.40578e-01,0.46387e-01 /)
      kao(:, 4, 4,12) = (/ &
        & 0.61515e-01,0.57939e-01,0.53160e-01,0.51347e-01,0.48544e-01, &
        & 0.45843e-01,0.42689e-01,0.46767e-01,0.53378e-01 /)
      kao(:, 5, 4,12) = (/ &
        & 0.60986e-01,0.58238e-01,0.54658e-01,0.53027e-01,0.51696e-01, &
        & 0.49388e-01,0.47217e-01,0.53278e-01,0.60785e-01 /)
      kao(:, 1, 5,12) = (/ &
        & 0.65795e-01,0.58347e-01,0.52585e-01,0.48437e-01,0.42714e-01, &
        & 0.39265e-01,0.34039e-01,0.28235e-01,0.31421e-01 /)
      kao(:, 2, 5,12) = (/ &
        & 0.65486e-01,0.58633e-01,0.53696e-01,0.49213e-01,0.45420e-01, &
        & 0.41668e-01,0.36378e-01,0.32647e-01,0.37055e-01 /)
      kao(:, 3, 5,12) = (/ &
        & 0.65183e-01,0.59134e-01,0.54134e-01,0.51097e-01,0.47829e-01, &
        & 0.44052e-01,0.39727e-01,0.38129e-01,0.43417e-01 /)
      kao(:, 4, 5,12) = (/ &
        & 0.64717e-01,0.59894e-01,0.54954e-01,0.53041e-01,0.50294e-01, &
        & 0.47344e-01,0.43654e-01,0.43889e-01,0.49916e-01 /)
      kao(:, 5, 5,12) = (/ &
        & 0.64255e-01,0.60489e-01,0.56373e-01,0.54824e-01,0.53472e-01, &
        & 0.51112e-01,0.47282e-01,0.50031e-01,0.57102e-01 /)
      kao(:, 1, 6,12) = (/ &
        & 0.69615e-01,0.61594e-01,0.54882e-01,0.50187e-01,0.44074e-01, &
        & 0.39997e-01,0.34871e-01,0.27743e-01,0.29013e-01 /)
      kao(:, 2, 6,12) = (/ &
        & 0.69442e-01,0.61757e-01,0.55910e-01,0.50997e-01,0.46497e-01, &
        & 0.42613e-01,0.37188e-01,0.31216e-01,0.34347e-01 /)
      kao(:, 3, 6,12) = (/ &
        & 0.69156e-01,0.62106e-01,0.56750e-01,0.52515e-01,0.49101e-01, &
        & 0.44986e-01,0.40395e-01,0.35961e-01,0.40369e-01 /)
      kao(:, 4, 6,12) = (/ &
        & 0.68816e-01,0.62627e-01,0.57231e-01,0.54601e-01,0.51362e-01, &
        & 0.48280e-01,0.44442e-01,0.41156e-01,0.46554e-01 /)
      kao(:, 5, 6,12) = (/ &
        & 0.68355e-01,0.63113e-01,0.58516e-01,0.56347e-01,0.54360e-01, &
        & 0.52199e-01,0.48222e-01,0.46871e-01,0.53241e-01 /)
      kao(:, 1, 7,12) = (/ &
        & 0.74032e-01,0.65393e-01,0.58013e-01,0.51965e-01,0.45915e-01, &
        & 0.40526e-01,0.35125e-01,0.27883e-01,0.26586e-01 /)
      kao(:, 2, 7,12) = (/ &
        & 0.73937e-01,0.65493e-01,0.58738e-01,0.53263e-01,0.47941e-01, &
        & 0.43149e-01,0.37585e-01,0.30874e-01,0.31614e-01 /)
      kao(:, 3, 7,12) = (/ &
        & 0.73662e-01,0.65759e-01,0.59591e-01,0.54630e-01,0.50354e-01, &
        & 0.45514e-01,0.40708e-01,0.34889e-01,0.37383e-01 /)
      kao(:, 4, 7,12) = (/ &
        & 0.73359e-01,0.66187e-01,0.60275e-01,0.56599e-01,0.52392e-01, &
        & 0.48574e-01,0.44791e-01,0.39333e-01,0.43356e-01 /)
      kao(:, 5, 7,12) = (/ &
        & 0.72923e-01,0.66589e-01,0.61432e-01,0.58168e-01,0.55043e-01, &
        & 0.52561e-01,0.48755e-01,0.44300e-01,0.49765e-01 /)
      kao(:, 1, 8,12) = (/ &
        & 0.78458e-01,0.69177e-01,0.61142e-01,0.54247e-01,0.47727e-01, &
        & 0.41456e-01,0.34819e-01,0.27717e-01,0.23941e-01 /)
      kao(:, 2, 8,12) = (/ &
        & 0.78410e-01,0.69294e-01,0.61857e-01,0.55492e-01,0.49764e-01, &
        & 0.43844e-01,0.37501e-01,0.30644e-01,0.28737e-01 /)
      kao(:, 3, 8,12) = (/ &
        & 0.78162e-01,0.69463e-01,0.62578e-01,0.57026e-01,0.52068e-01, &
        & 0.46044e-01,0.40472e-01,0.34561e-01,0.34380e-01 /)
      kao(:, 4, 8,12) = (/ &
        & 0.77871e-01,0.69834e-01,0.63268e-01,0.59074e-01,0.53918e-01, &
        & 0.48672e-01,0.44601e-01,0.38671e-01,0.40158e-01 /)
      kao(:, 5, 8,12) = (/ &
        & 0.77487e-01,0.70209e-01,0.64405e-01,0.60632e-01,0.56120e-01, &
        & 0.52504e-01,0.48787e-01,0.42980e-01,0.46410e-01 /)
      kao(:, 1, 9,12) = (/ &
        & 0.82666e-01,0.72734e-01,0.64105e-01,0.56594e-01,0.49561e-01, &
        & 0.42281e-01,0.34472e-01,0.27105e-01,0.21191e-01 /)
      kao(:, 2, 9,12) = (/ &
        & 0.82602e-01,0.72866e-01,0.64825e-01,0.57780e-01,0.51415e-01, &
        & 0.44682e-01,0.37233e-01,0.30003e-01,0.25697e-01 /)
      kao(:, 3, 9,12) = (/ &
        & 0.82349e-01,0.72898e-01,0.65478e-01,0.59213e-01,0.53844e-01, &
        & 0.46925e-01,0.39994e-01,0.33830e-01,0.31116e-01 /)
      kao(:, 4, 9,12) = (/ &
        & 0.82004e-01,0.73222e-01,0.66214e-01,0.61303e-01,0.55771e-01, &
        & 0.49206e-01,0.43963e-01,0.38199e-01,0.36759e-01 /)
      kao(:, 5, 9,12) = (/ &
        & 0.81608e-01,0.73612e-01,0.67180e-01,0.63056e-01,0.57653e-01, &
        & 0.52653e-01,0.48283e-01,0.42441e-01,0.42846e-01 /)
      kao(:, 1,10,12) = (/ &
        & 0.85880e-01,0.75430e-01,0.66656e-01,0.58773e-01,0.51658e-01, &
        & 0.43336e-01,0.34393e-01,0.26157e-01,0.14663e-01 /)
      kao(:, 2,10,12) = (/ &
        & 0.85756e-01,0.75590e-01,0.67337e-01,0.60049e-01,0.53266e-01, &
        & 0.45473e-01,0.37278e-01,0.29125e-01,0.16193e-01 /)
      kao(:, 3,10,12) = (/ &
        & 0.85530e-01,0.75588e-01,0.67995e-01,0.61462e-01,0.55345e-01, &
        & 0.48001e-01,0.39939e-01,0.32883e-01,0.20331e-01 /)
      kao(:, 4,10,12) = (/ &
        & 0.85095e-01,0.75810e-01,0.68684e-01,0.63320e-01,0.57485e-01, &
        & 0.50257e-01,0.43559e-01,0.37443e-01,0.23682e-01 /)
      kao(:, 5,10,12) = (/ &
        & 0.84667e-01,0.76211e-01,0.69733e-01,0.65095e-01,0.59445e-01, &
        & 0.53380e-01,0.47785e-01,0.41863e-01,0.26616e-01 /)
      kao(:, 1,11,12) = (/ &
        & 0.87471e-01,0.76929e-01,0.68322e-01,0.60781e-01,0.53951e-01, &
        & 0.45056e-01,0.35758e-01,0.26371e-01,0.18858e-01 /)
      kao(:, 2,11,12) = (/ &
        & 0.87208e-01,0.76940e-01,0.68996e-01,0.62212e-01,0.55582e-01, &
        & 0.47319e-01,0.38590e-01,0.29478e-01,0.21575e-01 /)
      kao(:, 3,11,12) = (/ &
        & 0.86835e-01,0.76905e-01,0.69723e-01,0.63816e-01,0.57699e-01, &
        & 0.49745e-01,0.41432e-01,0.33605e-01,0.25460e-01 /)
      kao(:, 4,11,12) = (/ &
        & 0.86430e-01,0.77295e-01,0.70629e-01,0.65834e-01,0.59545e-01, &
        & 0.52341e-01,0.45178e-01,0.38243e-01,0.30364e-01 /)
      kao(:, 5,11,12) = (/ &
        & 0.85874e-01,0.77597e-01,0.72138e-01,0.67497e-01,0.61709e-01, &
        & 0.55855e-01,0.49191e-01,0.42789e-01,0.33235e-01 /)
      kao(:, 1,12,12) = (/ &
        & 0.87248e-01,0.76929e-01,0.68689e-01,0.62001e-01,0.55189e-01, &
        & 0.46282e-01,0.37018e-01,0.26535e-01,0.20617e-01 /)
      kao(:, 2,12,12) = (/ &
        & 0.86938e-01,0.76894e-01,0.69591e-01,0.63473e-01,0.56879e-01, &
        & 0.48866e-01,0.39681e-01,0.29869e-01,0.23753e-01 /)
      kao(:, 3,12,12) = (/ &
        & 0.86505e-01,0.76936e-01,0.70473e-01,0.65213e-01,0.59161e-01, &
        & 0.51227e-01,0.42751e-01,0.34068e-01,0.28028e-01 /)
      kao(:, 4,12,12) = (/ &
        & 0.86014e-01,0.77389e-01,0.71734e-01,0.67391e-01,0.61041e-01, &
        & 0.54172e-01,0.46740e-01,0.38524e-01,0.33947e-01 /)
      kao(:, 5,12,12) = (/ &
        & 0.85424e-01,0.77682e-01,0.73622e-01,0.69056e-01,0.63676e-01, &
        & 0.57877e-01,0.50578e-01,0.43087e-01,0.36933e-01 /)
      kao(:, 1,13,12) = (/ &
        & 0.85419e-01,0.75627e-01,0.68076e-01,0.62306e-01,0.55288e-01, &
        & 0.46939e-01,0.37782e-01,0.26869e-01,0.20535e-01 /)
      kao(:, 2,13,12) = (/ &
        & 0.84985e-01,0.75524e-01,0.69213e-01,0.63729e-01,0.57271e-01, &
        & 0.49714e-01,0.40473e-01,0.30181e-01,0.22959e-01 /)
      kao(:, 3,13,12) = (/ &
        & 0.84529e-01,0.75748e-01,0.70315e-01,0.65749e-01,0.59660e-01, &
        & 0.52260e-01,0.43766e-01,0.34359e-01,0.28707e-01 /)
      kao(:, 4,13,12) = (/ &
        & 0.84038e-01,0.76252e-01,0.71947e-01,0.67890e-01,0.61874e-01, &
        & 0.55511e-01,0.47935e-01,0.38594e-01,0.34330e-01 /)
      kao(:, 5,13,12) = (/ &
        & 0.83450e-01,0.76542e-01,0.73924e-01,0.69752e-01,0.64960e-01, &
        & 0.59356e-01,0.51789e-01,0.43079e-01,0.38051e-01 /)
      kao(:, 1, 1,13) = (/ &
        & 0.68561e-01,0.61393e-01,0.55377e-01,0.48367e-01,0.42682e-01, &
        & 0.39908e-01,0.45275e-01,0.51909e-01,0.58629e-01 /)
      kao(:, 2, 1,13) = (/ &
        & 0.68429e-01,0.62258e-01,0.56444e-01,0.49529e-01,0.45167e-01, &
        & 0.45643e-01,0.53469e-01,0.61626e-01,0.69870e-01 /)
      kao(:, 3, 1,13) = (/ &
        & 0.68224e-01,0.62810e-01,0.57169e-01,0.51186e-01,0.48224e-01, &
        & 0.52899e-01,0.62764e-01,0.72521e-01,0.82353e-01 /)
      kao(:, 4, 1,13) = (/ &
        & 0.67917e-01,0.63314e-01,0.58187e-01,0.53334e-01,0.52038e-01, &
        & 0.61434e-01,0.73273e-01,0.84850e-01,0.96479e-01 /)
      kao(:, 5, 1,13) = (/ &
        & 0.67553e-01,0.63903e-01,0.59193e-01,0.55737e-01,0.58351e-01, &
        & 0.71682e-01,0.85665e-01,0.99285e-01,0.11295e+00 /)
      kao(:, 1, 2,13) = (/ &
        & 0.77509e-01,0.69079e-01,0.62486e-01,0.54626e-01,0.48075e-01, &
        & 0.42537e-01,0.44950e-01,0.51477e-01,0.58558e-01 /)
      kao(:, 2, 2,13) = (/ &
        & 0.77430e-01,0.69950e-01,0.63742e-01,0.55764e-01,0.50627e-01, &
        & 0.46853e-01,0.52532e-01,0.60374e-01,0.68733e-01 /)
      kao(:, 3, 2,13) = (/ &
        & 0.77189e-01,0.70882e-01,0.64573e-01,0.57536e-01,0.53311e-01, &
        & 0.52406e-01,0.61244e-01,0.70634e-01,0.80523e-01 /)
      kao(:, 4, 2,13) = (/ &
        & 0.76847e-01,0.71588e-01,0.65635e-01,0.59928e-01,0.56064e-01, &
        & 0.60283e-01,0.71500e-01,0.82577e-01,0.94220e-01 /)
      kao(:, 5, 2,13) = (/ &
        & 0.76386e-01,0.72289e-01,0.66796e-01,0.62420e-01,0.60016e-01, &
        & 0.69350e-01,0.82634e-01,0.95798e-01,0.10925e+00 /)
      kao(:, 1, 3,13) = (/ &
        & 0.86533e-01,0.76872e-01,0.69252e-01,0.60999e-01,0.53444e-01, &
        & 0.46117e-01,0.43982e-01,0.49772e-01,0.56991e-01 /)
      kao(:, 2, 3,13) = (/ &
        & 0.86412e-01,0.77388e-01,0.71047e-01,0.62031e-01,0.55847e-01, &
        & 0.49560e-01,0.50601e-01,0.57831e-01,0.66136e-01 /)
      kao(:, 3, 3,13) = (/ &
        & 0.86175e-01,0.78253e-01,0.72126e-01,0.63678e-01,0.58875e-01, &
        & 0.53556e-01,0.58645e-01,0.67397e-01,0.77181e-01 /)
      kao(:, 4, 3,13) = (/ &
        & 0.85802e-01,0.79483e-01,0.72991e-01,0.66186e-01,0.61530e-01, &
        & 0.59229e-01,0.68328e-01,0.78749e-01,0.90335e-01 /)
      kao(:, 5, 3,13) = (/ &
        & 0.85328e-01,0.80671e-01,0.74346e-01,0.68871e-01,0.64555e-01, &
        & 0.67267e-01,0.79478e-01,0.91684e-01,0.10533e+00 /)
      kao(:, 1, 4,13) = (/ &
        & 0.95394e-01,0.84557e-01,0.75442e-01,0.67038e-01,0.59073e-01, &
        & 0.49886e-01,0.44642e-01,0.48508e-01,0.55658e-01 /)
      kao(:, 2, 4,13) = (/ &
        & 0.95223e-01,0.84873e-01,0.77588e-01,0.68316e-01,0.60993e-01, &
        & 0.53907e-01,0.49824e-01,0.55820e-01,0.64074e-01 /)
      kao(:, 3, 4,13) = (/ &
        & 0.94965e-01,0.85575e-01,0.79290e-01,0.69694e-01,0.64420e-01, &
        & 0.57295e-01,0.56440e-01,0.64306e-01,0.73964e-01 /)
      kao(:, 4, 4,13) = (/ &
        & 0.94509e-01,0.86370e-01,0.80294e-01,0.72257e-01,0.67415e-01, &
        & 0.61388e-01,0.65357e-01,0.74991e-01,0.86332e-01 /)
      kao(:, 5, 4,13) = (/ &
        & 0.94009e-01,0.87806e-01,0.81595e-01,0.75171e-01,0.70245e-01, &
        & 0.67536e-01,0.76274e-01,0.87845e-01,0.10132e+00 /)
      kao(:, 1, 5,13) = (/ &
        & 0.10343e+00,0.91525e-01,0.80861e-01,0.72378e-01,0.64406e-01, &
        & 0.53983e-01,0.47036e-01,0.47125e-01,0.54095e-01 /)
      kao(:, 2, 5,13) = (/ &
        & 0.10334e+00,0.91907e-01,0.82762e-01,0.74349e-01,0.66049e-01, &
        & 0.58213e-01,0.51290e-01,0.53990e-01,0.61913e-01 /)
      kao(:, 3, 5,13) = (/ &
        & 0.10297e+00,0.92357e-01,0.85393e-01,0.75564e-01,0.69527e-01, &
        & 0.62165e-01,0.56265e-01,0.62011e-01,0.71236e-01 /)
      kao(:, 4, 5,13) = (/ &
        & 0.10256e+00,0.93114e-01,0.87093e-01,0.77935e-01,0.73042e-01, &
        & 0.65986e-01,0.63498e-01,0.72109e-01,0.83127e-01 /)
      kao(:, 5, 5,13) = (/ &
        & 0.10189e+00,0.94299e-01,0.88282e-01,0.81218e-01,0.76035e-01, &
        & 0.70876e-01,0.73640e-01,0.84406e-01,0.97393e-01 /)
      kao(:, 1, 6,13) = (/ &
        & 0.11045e+00,0.97454e-01,0.85408e-01,0.76244e-01,0.68972e-01, &
        & 0.58251e-01,0.49930e-01,0.45374e-01,0.51875e-01 /)
      kao(:, 2, 6,13) = (/ &
        & 0.11019e+00,0.97819e-01,0.87148e-01,0.79069e-01,0.71021e-01, &
        & 0.62071e-01,0.54179e-01,0.52124e-01,0.59618e-01 /)
      kao(:, 3, 6,13) = (/ &
        & 0.10981e+00,0.98088e-01,0.89384e-01,0.81156e-01,0.73973e-01, &
        & 0.66762e-01,0.58141e-01,0.59499e-01,0.68391e-01 /)
      kao(:, 4, 6,13) = (/ &
        & 0.10923e+00,0.98741e-01,0.91856e-01,0.83093e-01,0.78121e-01, &
        & 0.70717e-01,0.63590e-01,0.68985e-01,0.79490e-01 /)
      kao(:, 5, 6,13) = (/ &
        & 0.10855e+00,0.99728e-01,0.93768e-01,0.86485e-01,0.81499e-01, &
        & 0.75384e-01,0.71738e-01,0.80634e-01,0.92951e-01 /)
      kao(:, 1, 7,13) = (/ &
        & 0.11652e+00,0.10245e+00,0.89345e-01,0.79831e-01,0.71546e-01, &
        & 0.62110e-01,0.52889e-01,0.43937e-01,0.49094e-01 /)
      kao(:, 2, 7,13) = (/ &
        & 0.11624e+00,0.10291e+00,0.90769e-01,0.82143e-01,0.74705e-01, &
        & 0.65752e-01,0.57383e-01,0.50125e-01,0.56751e-01 /)
      kao(:, 3, 7,13) = (/ &
        & 0.11594e+00,0.10317e+00,0.92734e-01,0.84722e-01,0.77935e-01, &
        & 0.70772e-01,0.61416e-01,0.57153e-01,0.65344e-01 /)
      kao(:, 4, 7,13) = (/ &
        & 0.11535e+00,0.10356e+00,0.95024e-01,0.87242e-01,0.82357e-01, &
        & 0.75212e-01,0.65866e-01,0.66110e-01,0.76048e-01 /)
      kao(:, 5, 7,13) = (/ &
        & 0.11474e+00,0.10447e+00,0.97059e-01,0.90869e-01,0.86343e-01, &
        & 0.79806e-01,0.72467e-01,0.77014e-01,0.88751e-01 /)
      kao(:, 1, 8,13) = (/ &
        & 0.12265e+00,0.10756e+00,0.93593e-01,0.82964e-01,0.73576e-01, &
        & 0.64374e-01,0.55605e-01,0.43559e-01,0.46060e-01 /)
      kao(:, 2, 8,13) = (/ &
        & 0.12249e+00,0.10812e+00,0.94575e-01,0.84973e-01,0.76683e-01, &
        & 0.68823e-01,0.60052e-01,0.49117e-01,0.53798e-01 /)
      kao(:, 3, 8,13) = (/ &
        & 0.12216e+00,0.10834e+00,0.96338e-01,0.87360e-01,0.80349e-01, &
        & 0.74206e-01,0.64654e-01,0.55074e-01,0.62031e-01 /)
      kao(:, 4, 8,13) = (/ &
        & 0.12168e+00,0.10860e+00,0.98251e-01,0.89888e-01,0.85251e-01, &
        & 0.79126e-01,0.69120e-01,0.63252e-01,0.72334e-01 /)
      kao(:, 5, 8,13) = (/ &
        & 0.12099e+00,0.10931e+00,0.10017e+00,0.93685e-01,0.90048e-01, &
        & 0.83711e-01,0.75096e-01,0.73779e-01,0.84712e-01 /)
      kao(:, 1, 9,13) = (/ &
        & 0.12914e+00,0.11313e+00,0.98462e-01,0.86441e-01,0.75875e-01, &
        & 0.66332e-01,0.57013e-01,0.43839e-01,0.42411e-01 /)
      kao(:, 2, 9,13) = (/ &
        & 0.12911e+00,0.11365e+00,0.99113e-01,0.88386e-01,0.78651e-01, &
        & 0.70676e-01,0.61767e-01,0.49076e-01,0.50412e-01 /)
      kao(:, 3, 9,13) = (/ &
        & 0.12886e+00,0.11401e+00,0.10056e+00,0.90400e-01,0.82030e-01, &
        & 0.75969e-01,0.67212e-01,0.54346e-01,0.58598e-01 /)
      kao(:, 4, 9,13) = (/ &
        & 0.12844e+00,0.11410e+00,0.10221e+00,0.92662e-01,0.86791e-01, &
        & 0.81685e-01,0.71813e-01,0.61251e-01,0.68599e-01 /)
      kao(:, 5, 9,13) = (/ &
        & 0.12781e+00,0.11455e+00,0.10390e+00,0.96184e-01,0.92217e-01, &
        & 0.86557e-01,0.77640e-01,0.70636e-01,0.80447e-01 /)
      kao(:, 1,10,13) = (/ &
        & 0.13661e+00,0.11963e+00,0.10401e+00,0.90612e-01,0.78552e-01, &
        & 0.68665e-01,0.58042e-01,0.44182e-01,0.20623e-01 /)
      kao(:, 2,10,13) = (/ &
        & 0.13663e+00,0.12000e+00,0.10449e+00,0.92427e-01,0.81459e-01, &
        & 0.72606e-01,0.62588e-01,0.49634e-01,0.27517e-01 /)
      kao(:, 3,10,13) = (/ &
        & 0.13648e+00,0.12048e+00,0.10572e+00,0.94344e-01,0.84635e-01, &
        & 0.77264e-01,0.68466e-01,0.54964e-01,0.37460e-01 /)
      kao(:, 4,10,13) = (/ &
        & 0.13615e+00,0.12055e+00,0.10724e+00,0.96538e-01,0.88921e-01, &
        & 0.82919e-01,0.73837e-01,0.61121e-01,0.51408e-01 /)
      kao(:, 5,10,13) = (/ &
        & 0.13560e+00,0.12083e+00,0.10867e+00,0.99719e-01,0.94157e-01, &
        & 0.88097e-01,0.79982e-01,0.69630e-01,0.68524e-01 /)
      kao(:, 1,11,13) = (/ &
        & 0.14486e+00,0.12685e+00,0.11053e+00,0.96215e-01,0.83198e-01, &
        & 0.72790e-01,0.60483e-01,0.46368e-01,0.23123e-01 /)
      kao(:, 2,11,13) = (/ &
        & 0.14497e+00,0.12740e+00,0.11115e+00,0.98058e-01,0.86138e-01, &
        & 0.76317e-01,0.65283e-01,0.52226e-01,0.29160e-01 /)
      kao(:, 3,11,13) = (/ &
        & 0.14473e+00,0.12775e+00,0.11243e+00,0.99891e-01,0.89493e-01, &
        & 0.80996e-01,0.71303e-01,0.57950e-01,0.32977e-01 /)
      kao(:, 4,11,13) = (/ &
        & 0.14430e+00,0.12774e+00,0.11386e+00,0.10223e+00,0.94098e-01, &
        & 0.86252e-01,0.77087e-01,0.64785e-01,0.38714e-01 /)
      kao(:, 5,11,13) = (/ &
        & 0.14365e+00,0.12806e+00,0.11504e+00,0.10578e+00,0.98766e-01, &
        & 0.91283e-01,0.84242e-01,0.73581e-01,0.47497e-01 /)
      kao(:, 1,12,13) = (/ &
        & 0.15269e+00,0.13372e+00,0.11691e+00,0.10167e+00,0.88459e-01, &
        & 0.76634e-01,0.62620e-01,0.48153e-01,0.27858e-01 /)
      kao(:, 2,12,13) = (/ &
        & 0.15257e+00,0.13415e+00,0.11750e+00,0.10380e+00,0.91589e-01, &
        & 0.79898e-01,0.67862e-01,0.54271e-01,0.35587e-01 /)
      kao(:, 3,12,13) = (/ &
        & 0.15233e+00,0.13449e+00,0.11899e+00,0.10589e+00,0.94966e-01, &
        & 0.84666e-01,0.73653e-01,0.60551e-01,0.39809e-01 /)
      kao(:, 4,12,13) = (/ &
        & 0.15175e+00,0.13439e+00,0.12031e+00,0.10854e+00,0.99506e-01, &
        & 0.89389e-01,0.79517e-01,0.68401e-01,0.45578e-01 /)
      kao(:, 5,12,13) = (/ &
        & 0.15105e+00,0.13484e+00,0.12149e+00,0.11242e+00,0.10353e+00, &
        & 0.94548e-01,0.87485e-01,0.77323e-01,0.55990e-01 /)
      kao(:, 1,13,13) = (/ &
        & 0.15929e+00,0.13953e+00,0.12252e+00,0.10682e+00,0.93710e-01, &
        & 0.80318e-01,0.64679e-01,0.49483e-01,0.31231e-01 /)
      kao(:, 2,13,13) = (/ &
        & 0.15914e+00,0.14001e+00,0.12322e+00,0.10931e+00,0.96798e-01, &
        & 0.83533e-01,0.70039e-01,0.55928e-01,0.39440e-01 /)
      kao(:, 3,13,13) = (/ &
        & 0.15875e+00,0.14019e+00,0.12484e+00,0.11161e+00,0.10034e+00, &
        & 0.88309e-01,0.75681e-01,0.62757e-01,0.43280e-01 /)
      kao(:, 4,13,13) = (/ &
        & 0.15815e+00,0.14019e+00,0.12619e+00,0.11467e+00,0.10492e+00, &
        & 0.92849e-01,0.81796e-01,0.71221e-01,0.50343e-01 /)
      kao(:, 5,13,13) = (/ &
        & 0.15737e+00,0.14077e+00,0.12756e+00,0.11888e+00,0.10868e+00, &
        & 0.98192e-01,0.90106e-01,0.80417e-01,0.60332e-01 /)
      kao(:, 1, 1,14) = (/ &
        & 0.83965e-01,0.74725e-01,0.67262e-01,0.61439e-01,0.63569e-01, &
        & 0.76568e-01,0.91505e-01,0.10604e+00,0.12066e+00 /)
      kao(:, 2, 1,14) = (/ &
        & 0.84124e-01,0.75639e-01,0.69121e-01,0.66761e-01,0.75177e-01, &
        & 0.93190e-01,0.11140e+00,0.12912e+00,0.14697e+00 /)
      kao(:, 3, 1,14) = (/ &
        & 0.84208e-01,0.76821e-01,0.71401e-01,0.74638e-01,0.90938e-01, &
        & 0.11330e+00,0.13555e+00,0.15732e+00,0.17919e+00 /)
      kao(:, 4, 1,14) = (/ &
        & 0.84082e-01,0.77722e-01,0.74753e-01,0.85505e-01,0.11037e+00, &
        & 0.13754e+00,0.16460e+00,0.19114e+00,0.21779e+00 /)
      kao(:, 5, 1,14) = (/ &
        & 0.83810e-01,0.78431e-01,0.79767e-01,0.99722e-01,0.13195e+00, &
        & 0.16448e+00,0.19691e+00,0.22867e+00,0.26057e+00 /)
      kao(:, 1, 2,14) = (/ &
        & 0.98728e-01,0.87584e-01,0.78635e-01,0.69559e-01,0.65625e-01, &
        & 0.74022e-01,0.88098e-01,0.10177e+00,0.11620e+00 /)
      kao(:, 2, 2,14) = (/ &
        & 0.98895e-01,0.88195e-01,0.80583e-01,0.73010e-01,0.73981e-01, &
        & 0.89007e-01,0.10638e+00,0.12319e+00,0.14079e+00 /)
      kao(:, 3, 2,14) = (/ &
        & 0.98911e-01,0.89265e-01,0.82581e-01,0.78421e-01,0.87111e-01, &
        & 0.10783e+00,0.12893e+00,0.14951e+00,0.17084e+00 /)
      kao(:, 4, 2,14) = (/ &
        & 0.98795e-01,0.90737e-01,0.84451e-01,0.86623e-01,0.10466e+00, &
        & 0.13034e+00,0.15592e+00,0.18094e+00,0.20669e+00 /)
      kao(:, 5, 2,14) = (/ &
        & 0.98517e-01,0.92027e-01,0.87783e-01,0.98306e-01,0.12592e+00, &
        & 0.15706e+00,0.18794e+00,0.21816e+00,0.24934e+00 /)
      kao(:, 1, 3,14) = (/ &
        & 0.11536e+00,0.10204e+00,0.91076e-01,0.79879e-01,0.70411e-01, &
        & 0.71590e-01,0.83610e-01,0.96241e-01,0.11049e+00 /)
      kao(:, 2, 3,14) = (/ &
        & 0.11565e+00,0.10277e+00,0.93049e-01,0.82303e-01,0.75267e-01, &
        & 0.83499e-01,0.99323e-01,0.11472e+00,0.13181e+00 /)
      kao(:, 3, 3,14) = (/ &
        & 0.11566e+00,0.10353e+00,0.95697e-01,0.85227e-01,0.84157e-01, &
        & 0.99917e-01,0.11933e+00,0.13815e+00,0.15865e+00 /)
      kao(:, 4, 3,14) = (/ &
        & 0.11554e+00,0.10447e+00,0.97554e-01,0.90504e-01,0.97960e-01, &
        & 0.12029e+00,0.14386e+00,0.16671e+00,0.19135e+00 /)
      kao(:, 5, 3,14) = (/ &
        & 0.11515e+00,0.10586e+00,0.99141e-01,0.99110e-01,0.11626e+00, &
        & 0.14432e+00,0.17265e+00,0.20040e+00,0.22976e+00 /)
      kao(:, 1, 4,14) = (/ &
        & 0.13374e+00,0.11777e+00,0.10356e+00,0.90948e-01,0.79121e-01, &
        & 0.73845e-01,0.80790e-01,0.92777e-01,0.10713e+00 /)
      kao(:, 2, 4,14) = (/ &
        & 0.13413e+00,0.11892e+00,0.10607e+00,0.94460e-01,0.81628e-01, &
        & 0.80960e-01,0.93972e-01,0.10817e+00,0.12489e+00 /)
      kao(:, 3, 4,14) = (/ &
        & 0.13429e+00,0.11957e+00,0.10936e+00,0.96737e-01,0.86452e-01, &
        & 0.93977e-01,0.11135e+00,0.12854e+00,0.14815e+00 /)
      kao(:, 4, 4,14) = (/ &
        & 0.13415e+00,0.12054e+00,0.11264e+00,0.99496e-01,0.96100e-01, &
        & 0.11145e+00,0.13299e+00,0.15385e+00,0.17718e+00 /)
      kao(:, 5, 4,14) = (/ &
        & 0.13374e+00,0.12142e+00,0.11440e+00,0.10500e+00,0.11046e+00, &
        & 0.13295e+00,0.15886e+00,0.18424e+00,0.21188e+00 /)
      kao(:, 1, 5,14) = (/ &
        & 0.15386e+00,0.13491e+00,0.11798e+00,0.10225e+00,0.89703e-01, &
        & 0.79220e-01,0.79340e-01,0.90595e-01,0.10482e+00 /)
      kao(:, 2, 5,14) = (/ &
        & 0.15427e+00,0.13635e+00,0.12030e+00,0.10668e+00,0.92323e-01, &
        & 0.84157e-01,0.91777e-01,0.10537e+00,0.12216e+00 /)
      kao(:, 3, 5,14) = (/ &
        & 0.15452e+00,0.13729e+00,0.12299e+00,0.11079e+00,0.94730e-01, &
        & 0.92840e-01,0.10677e+00,0.12287e+00,0.14246e+00 /)
      kao(:, 4, 5,14) = (/ &
        & 0.15437e+00,0.13801e+00,0.12683e+00,0.11313e+00,0.10059e+00, &
        & 0.10648e+00,0.12562e+00,0.14488e+00,0.16770e+00 /)
      kao(:, 5, 5,14) = (/ &
        & 0.15403e+00,0.13896e+00,0.13053e+00,0.11647e+00,0.11129e+00, &
        & 0.12495e+00,0.14877e+00,0.17193e+00,0.19866e+00 /)
      kao(:, 1, 6,14) = (/ &
        & 0.17516e+00,0.15332e+00,0.13386e+00,0.11461e+00,0.98998e-01, &
        & 0.86199e-01,0.78839e-01,0.88239e-01,0.10212e+00 /)
      kao(:, 2, 6,14) = (/ &
        & 0.17578e+00,0.15465e+00,0.13554e+00,0.11810e+00,0.10372e+00, &
        & 0.90966e-01,0.90397e-01,0.10318e+00,0.11979e+00 /)
      kao(:, 3, 6,14) = (/ &
        & 0.17603e+00,0.15606e+00,0.13830e+00,0.12297e+00,0.10694e+00, &
        & 0.96886e-01,0.10455e+00,0.12004e+00,0.13936e+00 /)
      kao(:, 4, 6,14) = (/ &
        & 0.17594e+00,0.15671e+00,0.14175e+00,0.12765e+00,0.11049e+00, &
        & 0.10701e+00,0.12142e+00,0.13971e+00,0.16228e+00 /)
      kao(:, 5, 6,14) = (/ &
        & 0.17559e+00,0.15762e+00,0.14567e+00,0.13124e+00,0.11784e+00, &
        & 0.12121e+00,0.14182e+00,0.16360e+00,0.18966e+00 /)
      kao(:, 1, 7,14) = (/ &
        & 0.19714e+00,0.17254e+00,0.15016e+00,0.12718e+00,0.10949e+00, &
        & 0.93814e-01,0.79465e-01,0.85103e-01,0.98359e-01 /)
      kao(:, 2, 7,14) = (/ &
        & 0.19796e+00,0.17362e+00,0.15183e+00,0.13102e+00,0.11370e+00, &
        & 0.99479e-01,0.90483e-01,0.10125e+00,0.11726e+00 /)
      kao(:, 3, 7,14) = (/ &
        & 0.19829e+00,0.17522e+00,0.15424e+00,0.13545e+00,0.11863e+00, &
        & 0.10457e+00,0.10363e+00,0.11810e+00,0.13724e+00 /)
      kao(:, 4, 7,14) = (/ &
        & 0.19826e+00,0.17625e+00,0.15748e+00,0.14049e+00,0.12307e+00, &
        & 0.11254e+00,0.11942e+00,0.13698e+00,0.15920e+00 /)
      kao(:, 5, 7,14) = (/ &
        & 0.19780e+00,0.17685e+00,0.16171e+00,0.14510e+00,0.12933e+00, &
        & 0.12368e+00,0.13790e+00,0.15875e+00,0.18443e+00 /)
      kao(:, 1, 8,14) = (/ &
        & 0.21950e+00,0.19210e+00,0.16641e+00,0.14074e+00,0.12030e+00, &
        & 0.10245e+00,0.82539e-01,0.82181e-01,0.95126e-01 /)
      kao(:, 2, 8,14) = (/ &
        & 0.22029e+00,0.19287e+00,0.16845e+00,0.14392e+00,0.12476e+00, &
        & 0.10750e+00,0.92052e-01,0.97622e-01,0.11306e+00 /)
      kao(:, 3, 8,14) = (/ &
        & 0.22070e+00,0.19423e+00,0.17032e+00,0.14847e+00,0.12971e+00, &
        & 0.11297e+00,0.10375e+00,0.11522e+00,0.13338e+00 /)
      kao(:, 4, 8,14) = (/ &
        & 0.22058e+00,0.19569e+00,0.17355e+00,0.15354e+00,0.13473e+00, &
        & 0.12044e+00,0.11859e+00,0.13469e+00,0.15609e+00 /)
      kao(:, 5, 8,14) = (/ &
        & 0.22021e+00,0.19640e+00,0.17762e+00,0.15857e+00,0.14102e+00, &
        & 0.13035e+00,0.13566e+00,0.15573e+00,0.18054e+00 /)
      kao(:, 1, 9,14) = (/ &
        & 0.24109e+00,0.21099e+00,0.18179e+00,0.15454e+00,0.13112e+00, &
        & 0.11092e+00,0.89296e-01,0.80506e-01,0.93157e-01 /)
      kao(:, 2, 9,14) = (/ &
        & 0.24188e+00,0.21170e+00,0.18440e+00,0.15693e+00,0.13589e+00, &
        & 0.11596e+00,0.96808e-01,0.94330e-01,0.10941e+00 /)
      kao(:, 3, 9,14) = (/ &
        & 0.24228e+00,0.21270e+00,0.18618e+00,0.16137e+00,0.14099e+00, &
        & 0.12182e+00,0.10601e+00,0.11139e+00,0.12901e+00 /)
      kao(:, 4, 9,14) = (/ &
        & 0.24222e+00,0.21416e+00,0.18881e+00,0.16653e+00,0.14643e+00, &
        & 0.12886e+00,0.11898e+00,0.13037e+00,0.15086e+00 /)
      kao(:, 5, 9,14) = (/ &
        & 0.24175e+00,0.21527e+00,0.19303e+00,0.17188e+00,0.15251e+00, &
        & 0.13886e+00,0.13479e+00,0.15182e+00,0.17551e+00 /)
      kao(:, 1,10,14) = (/ &
        & 0.26096e+00,0.22837e+00,0.19625e+00,0.16743e+00,0.14218e+00, &
        & 0.11905e+00,0.97365e-01,0.81466e-01,0.86743e-01 /)
      kao(:, 2,10,14) = (/ &
        & 0.26197e+00,0.22928e+00,0.19902e+00,0.16970e+00,0.14641e+00, &
        & 0.12483e+00,0.10472e+00,0.93843e-01,0.10806e+00 /)
      kao(:, 3,10,14) = (/ &
        & 0.26221e+00,0.22989e+00,0.20102e+00,0.17345e+00,0.15221e+00, &
        & 0.13116e+00,0.11273e+00,0.10943e+00,0.12658e+00 /)
      kao(:, 4,10,14) = (/ &
        & 0.26216e+00,0.23120e+00,0.20343e+00,0.17903e+00,0.15795e+00, &
        & 0.13876e+00,0.12342e+00,0.12756e+00,0.14743e+00 /)
      kao(:, 5,10,14) = (/ &
        & 0.26155e+00,0.23254e+00,0.20744e+00,0.18479e+00,0.16453e+00, &
        & 0.14894e+00,0.13716e+00,0.14827e+00,0.17117e+00 /)
      kao(:, 1,11,14) = (/ &
        & 0.28000e+00,0.24504e+00,0.21069e+00,0.18024e+00,0.15374e+00, &
        & 0.12937e+00,0.10819e+00,0.88668e-01,0.55926e-01 /)
      kao(:, 2,11,14) = (/ &
        & 0.28047e+00,0.24546e+00,0.21318e+00,0.18272e+00,0.15865e+00, &
        & 0.13663e+00,0.11594e+00,0.10024e+00,0.74129e-01 /)
      kao(:, 3,11,14) = (/ &
        & 0.28078e+00,0.24627e+00,0.21537e+00,0.18699e+00,0.16514e+00, &
        & 0.14391e+00,0.12463e+00,0.11566e+00,0.10008e+00 /)
      kao(:, 4,11,14) = (/ &
        & 0.28041e+00,0.24739e+00,0.21799e+00,0.19316e+00,0.17153e+00, &
        & 0.15296e+00,0.13573e+00,0.13384e+00,0.12903e+00 /)
      kao(:, 5,11,14) = (/ &
        & 0.27974e+00,0.24878e+00,0.22235e+00,0.19924e+00,0.17976e+00, &
        & 0.16447e+00,0.14857e+00,0.15437e+00,0.16255e+00 /)
      kao(:, 1,12,14) = (/ &
        & 0.29848e+00,0.26121e+00,0.22470e+00,0.19300e+00,0.16476e+00, &
        & 0.13979e+00,0.11858e+00,0.95361e-01,0.54706e-01 /)
      kao(:, 2,12,14) = (/ &
        & 0.29901e+00,0.26167e+00,0.22733e+00,0.19555e+00,0.17000e+00, &
        & 0.14834e+00,0.12686e+00,0.10640e+00,0.56924e-01 /)
      kao(:, 3,12,14) = (/ &
        & 0.29886e+00,0.26222e+00,0.22932e+00,0.20008e+00,0.17736e+00, &
        & 0.15653e+00,0.13669e+00,0.12173e+00,0.76097e-01 /)
      kao(:, 4,12,14) = (/ &
        & 0.29840e+00,0.26333e+00,0.23210e+00,0.20641e+00,0.18472e+00, &
        & 0.16716e+00,0.14883e+00,0.13980e+00,0.10268e+00 /)
      kao(:, 5,12,14) = (/ &
        & 0.29738e+00,0.26451e+00,0.23656e+00,0.21275e+00,0.19460e+00, &
        & 0.18005e+00,0.16102e+00,0.16046e+00,0.13219e+00 /)
      kao(:, 1,13,14) = (/ &
        & 0.31629e+00,0.27681e+00,0.23838e+00,0.20550e+00,0.17561e+00, &
        & 0.15005e+00,0.12855e+00,0.10141e+00,0.58394e-01 /)
      kao(:, 2,13,14) = (/ &
        & 0.31664e+00,0.27713e+00,0.24100e+00,0.20827e+00,0.18155e+00, &
        & 0.15952e+00,0.13765e+00,0.11247e+00,0.60995e-01 /)
      kao(:, 3,13,14) = (/ &
        & 0.31646e+00,0.27774e+00,0.24298e+00,0.21292e+00,0.18963e+00, &
        & 0.16861e+00,0.14853e+00,0.12785e+00,0.75808e-01 /)
      kao(:, 4,13,14) = (/ &
        & 0.31577e+00,0.27872e+00,0.24590e+00,0.21953e+00,0.19753e+00, &
        & 0.18064e+00,0.16179e+00,0.14607e+00,0.10217e+00 /)
      kao(:, 5,13,14) = (/ &
        & 0.31458e+00,0.27978e+00,0.25030e+00,0.22598e+00,0.20858e+00, &
        & 0.19488e+00,0.17415e+00,0.16696e+00,0.13138e+00 /)
      kao(:, 1, 1,15) = (/ &
        & 0.94898e-01,0.85055e-01,0.10490e+00,0.15201e+00,0.20225e+00, &
        & 0.25227e+00,0.30184e+00,0.34935e+00,0.39726e+00 /)
      kao(:, 2, 1,15) = (/ &
        & 0.95143e-01,0.87211e-01,0.12685e+00,0.18956e+00,0.25226e+00, &
        & 0.31465e+00,0.37635e+00,0.43547e+00,0.49508e+00 /)
      kao(:, 3, 1,15) = (/ &
        & 0.95189e-01,0.92182e-01,0.15432e+00,0.23093e+00,0.30732e+00, &
        & 0.38333e+00,0.45850e+00,0.53039e+00,0.60271e+00 /)
      kao(:, 4, 1,15) = (/ &
        & 0.95231e-01,0.10069e+00,0.18420e+00,0.27567e+00,0.36689e+00, &
        & 0.45778e+00,0.54750e+00,0.63309e+00,0.71941e+00 /)
      kao(:, 5, 1,15) = (/ &
        & 0.95218e-01,0.11224e+00,0.21607e+00,0.32340e+00,0.43052e+00, &
        & 0.53710e+00,0.64228e+00,0.74267e+00,0.84389e+00 /)
      kao(:, 1, 2,15) = (/ &
        & 0.11396e+00,0.10141e+00,0.10674e+00,0.14459e+00,0.19233e+00, &
        & 0.23999e+00,0.28714e+00,0.33260e+00,0.38043e+00 /)
      kao(:, 2, 2,15) = (/ &
        & 0.11432e+00,0.10261e+00,0.12520e+00,0.18276e+00,0.24324e+00, &
        & 0.30342e+00,0.36297e+00,0.42016e+00,0.48074e+00 /)
      kao(:, 3, 2,15) = (/ &
        & 0.11451e+00,0.10490e+00,0.15054e+00,0.22514e+00,0.29969e+00, &
        & 0.37388e+00,0.44723e+00,0.51774e+00,0.59231e+00 /)
      kao(:, 4, 2,15) = (/ &
        & 0.11456e+00,0.10971e+00,0.18129e+00,0.27136e+00,0.36114e+00, &
        & 0.45069e+00,0.53922e+00,0.62384e+00,0.71399e+00 /)
      kao(:, 5, 2,15) = (/ &
        & 0.11453e+00,0.11800e+00,0.21439e+00,0.32093e+00,0.42721e+00, &
        & 0.53302e+00,0.63780e+00,0.73784e+00,0.84437e+00 /)
      kao(:, 1, 3,15) = (/ &
        & 0.13655e+00,0.12054e+00,0.11124e+00,0.13153e+00,0.17207e+00, &
        & 0.21470e+00,0.25693e+00,0.29779e+00,0.34231e+00 /)
      kao(:, 2, 3,15) = (/ &
        & 0.13707e+00,0.12216e+00,0.12413e+00,0.16670e+00,0.22186e+00, &
        & 0.27683e+00,0.33137e+00,0.38384e+00,0.44145e+00 /)
      kao(:, 3, 3,15) = (/ &
        & 0.13747e+00,0.12319e+00,0.14360e+00,0.20888e+00,0.27797e+00, &
        & 0.34687e+00,0.41517e+00,0.48101e+00,0.55322e+00 /)
      kao(:, 4, 3,15) = (/ &
        & 0.13768e+00,0.12546e+00,0.17113e+00,0.25534e+00,0.33989e+00, &
        & 0.42417e+00,0.50744e+00,0.58796e+00,0.67649e+00 /)
      kao(:, 5, 3,15) = (/ &
        & 0.13772e+00,0.12983e+00,0.20407e+00,0.30559e+00,0.40688e+00, &
        & 0.50779e+00,0.60773e+00,0.70383e+00,0.80998e+00 /)
      kao(:, 1, 4,15) = (/ &
        & 0.16353e+00,0.14321e+00,0.12667e+00,0.12562e+00,0.14945e+00, &
        & 0.18589e+00,0.22262e+00,0.25813e+00,0.29728e+00 /)
      kao(:, 2, 4,15) = (/ &
        & 0.16418e+00,0.14525e+00,0.13251e+00,0.15131e+00,0.19654e+00, &
        & 0.24525e+00,0.29354e+00,0.34060e+00,0.39212e+00 /)
      kao(:, 3, 4,15) = (/ &
        & 0.16461e+00,0.14670e+00,0.14414e+00,0.18897e+00,0.25116e+00, &
        & 0.31348e+00,0.37525e+00,0.43507e+00,0.50121e+00 /)
      kao(:, 4, 4,15) = (/ &
        & 0.16491e+00,0.14777e+00,0.16361e+00,0.23441e+00,0.31211e+00, &
        & 0.38952e+00,0.46648e+00,0.54097e+00,0.62321e+00 /)
      kao(:, 5, 4,15) = (/ &
        & 0.16511e+00,0.15008e+00,0.19240e+00,0.28461e+00,0.37902e+00, &
        & 0.47310e+00,0.56644e+00,0.65651e+00,0.75672e+00 /)
      kao(:, 1, 5,15) = (/ &
        & 0.19509e+00,0.17082e+00,0.14980e+00,0.13204e+00,0.13395e+00, &
        & 0.16269e+00,0.19465e+00,0.22562e+00,0.26041e+00 /)
      kao(:, 2, 5,15) = (/ &
        & 0.19619e+00,0.17214e+00,0.15205e+00,0.14710e+00,0.17263e+00, &
        & 0.21401e+00,0.25633e+00,0.29729e+00,0.34247e+00 /)
      kao(:, 3, 5,15) = (/ &
        & 0.19681e+00,0.17444e+00,0.15815e+00,0.17421e+00,0.22342e+00, &
        & 0.27889e+00,0.33405e+00,0.38778e+00,0.44627e+00 /)
      kao(:, 4, 5,15) = (/ &
        & 0.19721e+00,0.17581e+00,0.16979e+00,0.21414e+00,0.28278e+00, &
        & 0.35302e+00,0.42274e+00,0.49080e+00,0.56501e+00 /)
      kao(:, 5, 5,15) = (/ &
        & 0.19732e+00,0.17699e+00,0.18956e+00,0.26168e+00,0.34842e+00, &
        & 0.43503e+00,0.52113e+00,0.60494e+00,0.69634e+00 /)
      kao(:, 1, 6,15) = (/ &
        & 0.23167e+00,0.20281e+00,0.17680e+00,0.14997e+00,0.13324e+00, &
        & 0.14585e+00,0.17450e+00,0.20194e+00,0.23383e+00 /)
      kao(:, 2, 6,15) = (/ &
        & 0.23317e+00,0.20416e+00,0.17934e+00,0.15819e+00,0.15707e+00, &
        & 0.18679e+00,0.22357e+00,0.25924e+00,0.29921e+00 /)
      kao(:, 3, 6,15) = (/ &
        & 0.23428e+00,0.20631e+00,0.18228e+00,0.17432e+00,0.19753e+00, &
        & 0.24343e+00,0.29156e+00,0.33836e+00,0.38981e+00 /)
      kao(:, 4, 6,15) = (/ &
        & 0.23494e+00,0.20857e+00,0.18851e+00,0.20211e+00,0.25104e+00, &
        & 0.31278e+00,0.37475e+00,0.43549e+00,0.50069e+00 /)
      kao(:, 5, 6,15) = (/ &
        & 0.23514e+00,0.20988e+00,0.20063e+00,0.24116e+00,0.31413e+00, &
        & 0.39227e+00,0.47006e+00,0.54611e+00,0.62816e+00 /)
      kao(:, 1, 7,15) = (/ &
        & 0.27443e+00,0.24019e+00,0.20758e+00,0.17610e+00,0.14566e+00, &
        & 0.14000e+00,0.16506e+00,0.19019e+00,0.22128e+00 /)
      kao(:, 2, 7,15) = (/ &
        & 0.27620e+00,0.24179e+00,0.21121e+00,0.17965e+00,0.15984e+00, &
        & 0.16864e+00,0.20104e+00,0.23213e+00,0.26949e+00 /)
      kao(:, 3, 7,15) = (/ &
        & 0.27747e+00,0.24292e+00,0.21364e+00,0.18907e+00,0.18625e+00, &
        & 0.21432e+00,0.25652e+00,0.29760e+00,0.34338e+00 /)
      kao(:, 4, 7,15) = (/ &
        & 0.27840e+00,0.24591e+00,0.21750e+00,0.20704e+00,0.22722e+00, &
        & 0.27512e+00,0.32963e+00,0.38304e+00,0.44058e+00 /)
      kao(:, 5, 7,15) = (/ &
        & 0.27872e+00,0.24790e+00,0.22377e+00,0.23568e+00,0.28140e+00, &
        & 0.34919e+00,0.41848e+00,0.48672e+00,0.55917e+00 /)
      kao(:, 1, 8,15) = (/ &
        & 0.32341e+00,0.28305e+00,0.24270e+00,0.20626e+00,0.16778e+00, &
        & 0.14644e+00,0.16206e+00,0.18656e+00,0.21702e+00 /)
      kao(:, 2, 8,15) = (/ &
        & 0.32568e+00,0.28506e+00,0.24756e+00,0.20963e+00,0.17522e+00, &
        & 0.16516e+00,0.19045e+00,0.21956e+00,0.25530e+00 /)
      kao(:, 3, 8,15) = (/ &
        & 0.32734e+00,0.28654e+00,0.25088e+00,0.21479e+00,0.19195e+00, &
        & 0.19819e+00,0.23472e+00,0.27107e+00,0.31461e+00 /)
      kao(:, 4, 8,15) = (/ &
        & 0.32837e+00,0.28793e+00,0.25332e+00,0.22544e+00,0.22100e+00, &
        & 0.24722e+00,0.29529e+00,0.34210e+00,0.39526e+00 /)
      kao(:, 5, 8,15) = (/ &
        & 0.32863e+00,0.29096e+00,0.25794e+00,0.24543e+00,0.26342e+00, &
        & 0.31218e+00,0.37382e+00,0.43401e+00,0.50027e+00 /)
      kao(:, 1, 9,15) = (/ &
        & 0.37878e+00,0.33149e+00,0.28420e+00,0.23973e+00,0.19541e+00, &
        & 0.16103e+00,0.16029e+00,0.18365e+00,0.21308e+00 /)
      kao(:, 2, 9,15) = (/ &
        & 0.38160e+00,0.33397e+00,0.28731e+00,0.24432e+00,0.19953e+00, &
        & 0.17386e+00,0.18539e+00,0.21378e+00,0.24833e+00 /)
      kao(:, 3, 9,15) = (/ &
        & 0.38370e+00,0.33584e+00,0.29267e+00,0.24777e+00,0.20961e+00, &
        & 0.19622e+00,0.22137e+00,0.25542e+00,0.29676e+00 /)
      kao(:, 4, 9,15) = (/ &
        & 0.38483e+00,0.33686e+00,0.29593e+00,0.25505e+00,0.22908e+00, &
        & 0.23318e+00,0.27287e+00,0.31549e+00,0.36559e+00 /)
      kao(:, 5, 9,15) = (/ &
        & 0.38520e+00,0.33870e+00,0.29863e+00,0.26759e+00,0.26094e+00, &
        & 0.28563e+00,0.34036e+00,0.39396e+00,0.45596e+00 /)
      kao(:, 1,10,15) = (/ &
        & 0.44139e+00,0.38627e+00,0.33114e+00,0.27661e+00,0.22671e+00, &
        & 0.18314e+00,0.16439e+00,0.18365e+00,0.21302e+00 /)
      kao(:, 2,10,15) = (/ &
        & 0.44442e+00,0.38894e+00,0.33346e+00,0.28317e+00,0.23077e+00, &
        & 0.19173e+00,0.18540e+00,0.21159e+00,0.24601e+00 /)
      kao(:, 3,10,15) = (/ &
        & 0.44688e+00,0.39111e+00,0.33884e+00,0.28735e+00,0.23759e+00, &
        & 0.20864e+00,0.21693e+00,0.24969e+00,0.29058e+00 /)
      kao(:, 4,10,15) = (/ &
        & 0.44794e+00,0.39207e+00,0.34326e+00,0.29193e+00,0.25105e+00, &
        & 0.23562e+00,0.26192e+00,0.30247e+00,0.35138e+00 /)
      kao(:, 5,10,15) = (/ &
        & 0.44820e+00,0.39253e+00,0.34576e+00,0.30181e+00,0.27401e+00, &
        & 0.27758e+00,0.32230e+00,0.37259e+00,0.43225e+00 /)
      kao(:, 1,11,15) = (/ &
        & 0.51225e+00,0.44827e+00,0.38430e+00,0.32096e+00,0.26380e+00, &
        & 0.21204e+00,0.18122e+00,0.19575e+00,0.22762e+00 /)
      kao(:, 2,11,15) = (/ &
        & 0.51551e+00,0.45114e+00,0.38677e+00,0.32842e+00,0.26803e+00, &
        & 0.22031e+00,0.20295e+00,0.22783e+00,0.26563e+00 /)
      kao(:, 3,11,15) = (/ &
        & 0.51720e+00,0.45265e+00,0.39154e+00,0.33278e+00,0.27451e+00, &
        & 0.23732e+00,0.23493e+00,0.26904e+00,0.31377e+00 /)
      kao(:, 4,11,15) = (/ &
        & 0.51766e+00,0.45307e+00,0.39664e+00,0.33683e+00,0.28805e+00, &
        & 0.26198e+00,0.27963e+00,0.32252e+00,0.37505e+00 /)
      kao(:, 5,11,15) = (/ &
        & 0.51687e+00,0.45253e+00,0.39906e+00,0.34713e+00,0.30874e+00, &
        & 0.30122e+00,0.34231e+00,0.39543e+00,0.45934e+00 /)
      kao(:, 1,12,15) = (/ &
        & 0.58922e+00,0.51562e+00,0.44203e+00,0.36905e+00,0.30406e+00, &
        & 0.24465e+00,0.20183e+00,0.21102e+00,0.20343e+00 /)
      kao(:, 2,12,15) = (/ &
        & 0.59167e+00,0.51780e+00,0.44391e+00,0.37709e+00,0.30888e+00, &
        & 0.25236e+00,0.22396e+00,0.24700e+00,0.27515e+00 /)
      kao(:, 3,12,15) = (/ &
        & 0.59289e+00,0.51887e+00,0.44833e+00,0.38190e+00,0.31478e+00, &
        & 0.26966e+00,0.25708e+00,0.29183e+00,0.34036e+00 /)
      kao(:, 4,12,15) = (/ &
        & 0.59238e+00,0.51846e+00,0.45409e+00,0.38554e+00,0.32896e+00, &
        & 0.29236e+00,0.30023e+00,0.34558e+00,0.40217e+00 /)
      kao(:, 5,12,15) = (/ &
        & 0.59040e+00,0.51681e+00,0.45607e+00,0.39582e+00,0.34740e+00, &
        & 0.32863e+00,0.36471e+00,0.42134e+00,0.48947e+00 /)
      kao(:, 1,13,15) = (/ &
        & 0.67101e+00,0.58718e+00,0.50336e+00,0.42031e+00,0.34716e+00, &
        & 0.27980e+00,0.22553e+00,0.22887e+00,0.21243e+00 /)
      kao(:, 2,13,15) = (/ &
        & 0.67268e+00,0.58864e+00,0.50464e+00,0.42832e+00,0.35207e+00, &
        & 0.28740e+00,0.24801e+00,0.26765e+00,0.28879e+00 /)
      kao(:, 3,13,15) = (/ &
        & 0.67256e+00,0.58859e+00,0.50813e+00,0.43372e+00,0.35764e+00, &
        & 0.30459e+00,0.28195e+00,0.31558e+00,0.36763e+00 /)
      kao(:, 4,13,15) = (/ &
        & 0.67050e+00,0.58682e+00,0.51379e+00,0.43676e+00,0.37243e+00, &
        & 0.32590e+00,0.32370e+00,0.37117e+00,0.43203e+00 /)
      kao(:, 5,13,15) = (/ &
        & 0.66719e+00,0.58400e+00,0.51581e+00,0.44632e+00,0.38956e+00, &
        & 0.35928e+00,0.38845e+00,0.44876e+00,0.52114e+00 /)
      kao(:, 1, 1,16) = (/ &
        & 0.10138e+00,0.11271e+00,0.22512e+00,0.33705e+00,0.44854e+00, &
        & 0.55854e+00,0.66519e+00,0.75942e+00,0.85612e+00 /)
      kao(:, 2, 1,16) = (/ &
        & 0.10145e+00,0.13913e+00,0.27783e+00,0.41606e+00,0.55341e+00, &
        & 0.68935e+00,0.82123e+00,0.93793e+00,0.10573e+01 /)
      kao(:, 3, 1,16) = (/ &
        & 0.10144e+00,0.16758e+00,0.33464e+00,0.50118e+00,0.66683e+00, &
        & 0.83041e+00,0.98914e+00,0.11301e+01,0.12744e+01 /)
      kao(:, 4, 1,16) = (/ &
        & 0.10142e+00,0.19759e+00,0.39475e+00,0.59125e+00,0.78644e+00, &
        & 0.97913e+00,0.11666e+01,0.13327e+01,0.15036e+01 /)
      kao(:, 5, 1,16) = (/ &
        & 0.10117e+00,0.22893e+00,0.45719e+00,0.68491e+00,0.91083e+00, &
        & 0.11348e+01,0.13522e+01,0.15448e+01,0.17423e+01 /)
      kao(:, 1, 2,16) = (/ &
        & 0.12283e+00,0.11939e+00,0.23586e+00,0.35344e+00,0.46995e+00, &
        & 0.58562e+00,0.69771e+00,0.79719e+00,0.91456e+00 /)
      kao(:, 2, 2,16) = (/ &
        & 0.12300e+00,0.14726e+00,0.29424e+00,0.44061e+00,0.58626e+00, &
        & 0.73031e+00,0.87019e+00,0.99468e+00,0.11413e+01 /)
      kao(:, 3, 2,16) = (/ &
        & 0.12308e+00,0.17880e+00,0.35729e+00,0.53471e+00,0.71190e+00, &
        & 0.88678e+00,0.10560e+01,0.12083e+01,0.13858e+01 /)
      kao(:, 4, 2,16) = (/ &
        & 0.12303e+00,0.21231e+00,0.42408e+00,0.63552e+00,0.84482e+00, &
        & 0.10530e+01,0.12550e+01,0.14355e+01,0.16461e+01 /)
      kao(:, 5, 2,16) = (/ &
        & 0.12277e+00,0.24738e+00,0.49418e+00,0.74021e+00,0.98480e+00, &
        & 0.12263e+01,0.14622e+01,0.16712e+01,0.19192e+01 /)
      kao(:, 1, 3,16) = (/ &
        & 0.14866e+00,0.13122e+00,0.23281e+00,0.34894e+00,0.46454e+00, &
        & 0.57840e+00,0.68947e+00,0.78868e+00,0.91936e+00 /)
      kao(:, 2, 3,16) = (/ &
        & 0.14909e+00,0.15020e+00,0.29535e+00,0.44246e+00,0.58879e+00, &
        & 0.73298e+00,0.87446e+00,0.10004e+01,0.11652e+01 /)
      kao(:, 3, 3,16) = (/ &
        & 0.14932e+00,0.18193e+00,0.36339e+00,0.54464e+00,0.72472e+00, &
        & 0.90302e+00,0.10769e+01,0.12326e+01,0.14351e+01 /)
      kao(:, 4, 3,16) = (/ &
        & 0.14936e+00,0.21850e+00,0.43638e+00,0.65369e+00,0.87034e+00, &
        & 0.10842e+01,0.12925e+01,0.14807e+01,0.17238e+01 /)
      kao(:, 5, 3,16) = (/ &
        & 0.14913e+00,0.25689e+00,0.51319e+00,0.76884e+00,0.10226e+01, &
        & 0.12750e+01,0.15205e+01,0.17418e+01,0.20260e+01 /)
      kao(:, 1, 4,16) = (/ &
        & 0.17957e+00,0.15775e+00,0.22276e+00,0.33390e+00,0.44423e+00, &
        & 0.55367e+00,0.66019e+00,0.75611e+00,0.88680e+00 /)
      kao(:, 2, 4,16) = (/ &
        & 0.18040e+00,0.16246e+00,0.28812e+00,0.43146e+00,0.57438e+00, &
        & 0.71573e+00,0.85374e+00,0.97839e+00,0.11468e+01 /)
      kao(:, 3, 4,16) = (/ &
        & 0.18097e+00,0.18562e+00,0.36044e+00,0.53994e+00,0.71844e+00, &
        & 0.89550e+00,0.10683e+01,0.12247e+01,0.14347e+01 /)
      kao(:, 4, 4,16) = (/ &
        & 0.18121e+00,0.21975e+00,0.43861e+00,0.65714e+00,0.87443e+00, &
        & 0.10900e+01,0.13008e+01,0.14906e+01,0.17458e+01 /)
      kao(:, 5, 4,16) = (/ &
        & 0.18106e+00,0.26092e+00,0.52133e+00,0.78101e+00,0.10395e+01, &
        & 0.12958e+01,0.15460e+01,0.17735e+01,0.20757e+01 /)
      kao(:, 1, 5,16) = (/ &
        & 0.21697e+00,0.19036e+00,0.21215e+00,0.31312e+00,0.41669e+00, &
        & 0.51939e+00,0.61996e+00,0.71133e+00,0.83486e+00 /)
      kao(:, 2, 5,16) = (/ &
        & 0.21794e+00,0.19137e+00,0.27611e+00,0.41368e+00,0.55071e+00, &
        & 0.68646e+00,0.81902e+00,0.94006e+00,0.11028e+01 /)
      kao(:, 3, 5,16) = (/ &
        & 0.21886e+00,0.20114e+00,0.35159e+00,0.52668e+00,0.70100e+00, &
        & 0.87403e+00,0.10428e+01,0.11973e+01,0.14036e+01 /)
      kao(:, 4, 5,16) = (/ &
        & 0.21947e+00,0.22776e+00,0.43385e+00,0.64994e+00,0.86545e+00, &
        & 0.10790e+01,0.12882e+01,0.14795e+01,0.17328e+01 /)
      kao(:, 5, 5,16) = (/ &
        & 0.21950e+00,0.26410e+00,0.52266e+00,0.78311e+00,0.10422e+01, &
        & 0.12993e+01,0.15508e+01,0.17813e+01,0.20867e+01 /)
      kao(:, 1, 6,16) = (/ &
        & 0.26192e+00,0.22964e+00,0.21396e+00,0.28442e+00,0.37859e+00, &
        & 0.47209e+00,0.56361e+00,0.64772e+00,0.75904e+00 /)
      kao(:, 2, 6,16) = (/ &
        & 0.26327e+00,0.23094e+00,0.26427e+00,0.38535e+00,0.51302e+00, &
        & 0.63961e+00,0.76380e+00,0.87816e+00,0.10282e+01 /)
      kao(:, 3, 6,16) = (/ &
        & 0.26410e+00,0.23177e+00,0.33446e+00,0.50065e+00,0.66671e+00, &
        & 0.83097e+00,0.99257e+00,0.11416e+01,0.13361e+01 /)
      kao(:, 4, 6,16) = (/ &
        & 0.26501e+00,0.24670e+00,0.42047e+00,0.62999e+00,0.83846e+00, &
        & 0.10456e+01,0.12484e+01,0.14350e+01,0.16802e+01 /)
      kao(:, 5, 6,16) = (/ &
        & 0.26533e+00,0.27595e+00,0.51477e+00,0.77155e+00,0.10272e+01, &
        & 0.12802e+01,0.15288e+01,0.17573e+01,0.20585e+01 /)
      kao(:, 1, 7,16) = (/ &
        & 0.31548e+00,0.27644e+00,0.23749e+00,0.26350e+00,0.33563e+00, &
        & 0.41860e+00,0.50000e+00,0.57557e+00,0.67307e+00 /)
      kao(:, 2, 7,16) = (/ &
        & 0.31747e+00,0.27830e+00,0.26813e+00,0.35238e+00,0.46780e+00, &
        & 0.58337e+00,0.69695e+00,0.80281e+00,0.93825e+00 /)
      kao(:, 3, 7,16) = (/ &
        & 0.31845e+00,0.27929e+00,0.32577e+00,0.46831e+00,0.62377e+00, &
        & 0.77768e+00,0.92868e+00,0.10691e+01,0.12510e+01 /)
      kao(:, 4, 7,16) = (/ &
        & 0.31933e+00,0.28093e+00,0.40219e+00,0.60218e+00,0.80124e+00, &
        & 0.99953e+00,0.11938e+01,0.13738e+01,0.16072e+01 /)
      kao(:, 5, 7,16) = (/ &
        & 0.31962e+00,0.30041e+00,0.50060e+00,0.75020e+00,0.99895e+00, &
        & 0.12457e+01,0.14877e+01,0.17119e+01,0.20030e+01 /)
      kao(:, 1, 8,16) = (/ &
        & 0.37865e+00,0.33167e+00,0.28471e+00,0.26304e+00,0.29883e+00, &
        & 0.36478e+00,0.43575e+00,0.50177e+00,0.58698e+00 /)
      kao(:, 2, 8,16) = (/ &
        & 0.38151e+00,0.33434e+00,0.29226e+00,0.33286e+00,0.42010e+00, &
        & 0.52397e+00,0.62612e+00,0.72153e+00,0.84257e+00 /)
      kao(:, 3, 8,16) = (/ &
        & 0.38305e+00,0.33575e+00,0.33335e+00,0.43312e+00,0.57580e+00, &
        & 0.71815e+00,0.85781e+00,0.98826e+00,0.11549e+01 /)
      kao(:, 4, 8,16) = (/ &
        & 0.38418e+00,0.33683e+00,0.39821e+00,0.56836e+00,0.75670e+00, &
        & 0.94382e+00,0.11276e+01,0.12990e+01,0.15179e+01 /)
      kao(:, 5, 8,16) = (/ &
        & 0.38435e+00,0.34032e+00,0.48169e+00,0.72105e+00,0.95979e+00, &
        & 0.11976e+01,0.14311e+01,0.16484e+01,0.19256e+01 /)
      kao(:, 1, 9,16) = (/ &
        & 0.45391e+00,0.39745e+00,0.34100e+00,0.28597e+00,0.28236e+00, &
        & 0.32683e+00,0.39003e+00,0.44780e+00,0.52646e+00 /)
      kao(:, 2, 9,16) = (/ &
        & 0.45720e+00,0.40042e+00,0.34369e+00,0.33249e+00,0.37993e+00, &
        & 0.46180e+00,0.55195e+00,0.63669e+00,0.74252e+00 /)
      kao(:, 3, 9,16) = (/ &
        & 0.45930e+00,0.40241e+00,0.35995e+00,0.41477e+00,0.52224e+00, &
        & 0.65162e+00,0.77908e+00,0.89846e+00,0.10481e+01 /)
      kao(:, 4, 9,16) = (/ &
        & 0.46056e+00,0.40360e+00,0.40974e+00,0.52851e+00,0.70308e+00, &
        & 0.87703e+00,0.10485e+01,0.12091e+01,0.14102e+01 /)
      kao(:, 5, 9,16) = (/ &
        & 0.46097e+00,0.40408e+00,0.48083e+00,0.68278e+00,0.90959e+00, &
        & 0.11347e+01,0.13562e+01,0.15644e+01,0.18239e+01 /)
      kao(:, 1,10,16) = (/ &
        & 0.54348e+00,0.47578e+00,0.40808e+00,0.34039e+00,0.29202e+00, &
        & 0.31463e+00,0.37530e+00,0.43003e+00,0.50713e+00 /)
      kao(:, 2,10,16) = (/ &
        & 0.54726e+00,0.47923e+00,0.41116e+00,0.35738e+00,0.36873e+00, &
        & 0.42815e+00,0.51125e+00,0.58827e+00,0.68902e+00 /)
      kao(:, 3,10,16) = (/ &
        & 0.54904e+00,0.48087e+00,0.41270e+00,0.42187e+00,0.48592e+00, &
        & 0.59834e+00,0.71541e+00,0.82550e+00,0.96166e+00 /)
      kao(:, 4,10,16) = (/ &
        & 0.55066e+00,0.48237e+00,0.44342e+00,0.51829e+00,0.65846e+00, &
        & 0.82163e+00,0.98259e+00,0.11344e+01,0.13209e+01 /)
      kao(:, 5,10,16) = (/ &
        & 0.55078e+00,0.48256e+00,0.50243e+00,0.65112e+00,0.86662e+00, &
        & 0.10813e+01,0.12932e+01,0.14933e+01,0.17377e+01 /)
      kao(:, 1,11,16) = (/ &
        & 0.65114e+00,0.56997e+00,0.48880e+00,0.40765e+00,0.34114e+00, &
        & 0.35299e+00,0.42114e+00,0.48311e+00,0.56879e+00 /)
      kao(:, 2,11,16) = (/ &
        & 0.65409e+00,0.57269e+00,0.49126e+00,0.41893e+00,0.41551e+00, &
        & 0.46863e+00,0.55986e+00,0.64427e+00,0.75415e+00 /)
      kao(:, 3,11,16) = (/ &
        & 0.65488e+00,0.57345e+00,0.49197e+00,0.47947e+00,0.53169e+00, &
        & 0.64034e+00,0.76581e+00,0.88450e+00,0.10287e+01 /)
      kao(:, 4,11,16) = (/ &
        & 0.65537e+00,0.57398e+00,0.51344e+00,0.57405e+00,0.70306e+00, &
        & 0.87735e+00,0.10495e+01,0.12127e+01,0.14094e+01 /)
      kao(:, 5,11,16) = (/ &
        & 0.65395e+00,0.57279e+00,0.56858e+00,0.69997e+00,0.92273e+00, &
        & 0.11516e+01,0.13780e+01,0.15930e+01,0.18499e+01 /)
      kao(:, 1,12,16) = (/ &
        & 0.77619e+00,0.67938e+00,0.58258e+00,0.48578e+00,0.39872e+00, &
        & 0.39471e+00,0.47009e+00,0.53992e+00,0.63430e+00 /)
      kao(:, 2,12,16) = (/ &
        & 0.77753e+00,0.68052e+00,0.58367e+00,0.49090e+00,0.46899e+00, &
        & 0.51194e+00,0.61162e+00,0.70447e+00,0.82357e+00 /)
      kao(:, 3,12,16) = (/ &
        & 0.77638e+00,0.67972e+00,0.58318e+00,0.54530e+00,0.58387e+00, &
        & 0.68245e+00,0.81638e+00,0.94341e+00,0.10965e+01 /)
      kao(:, 4,12,16) = (/ &
        & 0.77440e+00,0.67810e+00,0.59462e+00,0.63695e+00,0.74739e+00, &
        & 0.93197e+00,0.11153e+01,0.12903e+01,0.14970e+01 /)
      kao(:, 5,12,16) = (/ &
        & 0.77021e+00,0.67464e+00,0.64357e+00,0.75637e+00,0.97798e+00, &
        & 0.12207e+01,0.14609e+01,0.16904e+01,0.19598e+01 /)
      kao(:, 1,13,16) = (/ &
        & 0.91895e+00,0.80429e+00,0.68964e+00,0.57498e+00,0.46528e+00, &
        & 0.44199e+00,0.52028e+00,0.59834e+00,0.70141e+00 /)
      kao(:, 2,13,16) = (/ &
        & 0.91759e+00,0.80320e+00,0.68881e+00,0.57463e+00,0.52956e+00, &
        & 0.55768e+00,0.66492e+00,0.76644e+00,0.89471e+00 /)
      kao(:, 3,13,16) = (/ &
        & 0.91361e+00,0.79979e+00,0.68598e+00,0.61940e+00,0.64101e+00, &
        & 0.72712e+00,0.86969e+00,0.10053e+01,0.11679e+01 /)
      kao(:, 4,13,16) = (/ &
        & 0.90733e+00,0.79439e+00,0.68655e+00,0.70603e+00,0.79560e+00, &
        & 0.98356e+00,0.11773e+01,0.13631e+01,0.15788e+01 /)
      kao(:, 5,13,16) = (/ &
        & 0.89862e+00,0.78697e+00,0.72670e+00,0.82187e+00,0.10292e+01, &
        & 0.12848e+01,0.15381e+01,0.17818e+01,0.20623e+01 /)
  
!     -----------------------------------------------------------------
!     The array KBO contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels < ~100mb and temperatures. The first 
!     index in the array, JT, which runs from 1 to 5, corresponds to 
!     different temperatures.  More specifically, JT = 3 means that the 
!     data are for the reference temperature TREF for this pressure 
!     level, JT = 2 refers to the temperature TREF-15, JT = 1 is for
!     TREF-30, JT = 4 is for TREF+15, and JT = 5 is for TREF+30.  
!     The second index, JP, runs from 13 to 59 and refers to the JPth
!     reference pressure level (see taumol.f for the value of these
!     pressure levels in mb).  The third index, IG, goes from 1 to 16,
!     and tells us which g-interval the absorption coefficients are for.
!     -----------------------------------------------------------------

      kbo(:,13, 1) = (/ &
        & 0.80849e-06,0.81362e-06,0.81391e-06,0.81832e-06,0.81000e-06 /)
      kbo(:,14, 1) = (/ &
        & 0.62593e-06,0.63090e-06,0.63158e-06,0.62821e-06,0.62502e-06 /)
      kbo(:,15, 1) = (/ &
        & 0.47825e-06,0.47852e-06,0.47713e-06,0.47688e-06,0.47989e-06 /)
      kbo(:,16, 1) = (/ &
        & 0.36039e-06,0.35905e-06,0.36064e-06,0.36298e-06,0.36860e-06 /)
      kbo(:,17, 1) = (/ &
        & 0.27679e-06,0.27608e-06,0.27742e-06,0.28112e-06,0.28759e-06 /)
      kbo(:,18, 1) = (/ &
        & 0.21771e-06,0.21826e-06,0.22019e-06,0.22429e-06,0.22996e-06 /)
      kbo(:,19, 1) = (/ &
        & 0.17334e-06,0.17441e-06,0.17681e-06,0.18055e-06,0.18537e-06 /)
      kbo(:,20, 1) = (/ &
        & 0.13974e-06,0.14076e-06,0.14326e-06,0.14694e-06,0.15070e-06 /)
      kbo(:,21, 1) = (/ &
        & 0.11289e-06,0.11394e-06,0.11631e-06,0.11963e-06,0.12284e-06 /)
      kbo(:,22, 1) = (/ &
        & 0.90574e-07,0.91914e-07,0.94046e-07,0.96998e-07,0.99841e-07 /)
      kbo(:,23, 1) = (/ &
        & 0.72483e-07,0.74069e-07,0.76186e-07,0.78482e-07,0.80964e-07 /)
      kbo(:,24, 1) = (/ &
        & 0.57463e-07,0.59130e-07,0.60802e-07,0.62903e-07,0.65218e-07 /)
      kbo(:,25, 1) = (/ &
        & 0.45767e-07,0.47184e-07,0.48696e-07,0.50494e-07,0.52527e-07 /)
      kbo(:,26, 1) = (/ &
        & 0.36636e-07,0.37794e-07,0.39217e-07,0.40768e-07,0.42465e-07 /)
      kbo(:,27, 1) = (/ &
        & 0.29173e-07,0.30183e-07,0.31469e-07,0.32834e-07,0.34213e-07 /)
      kbo(:,28, 1) = (/ &
        & 0.23225e-07,0.24137e-07,0.25167e-07,0.26378e-07,0.27534e-07 /)
      kbo(:,29, 1) = (/ &
        & 0.18675e-07,0.19472e-07,0.20340e-07,0.21340e-07,0.22286e-07 /)
      kbo(:,30, 1) = (/ &
        & 0.15020e-07,0.15690e-07,0.16468e-07,0.17258e-07,0.18060e-07 /)
      kbo(:,31, 1) = (/ &
        & 0.12149e-07,0.12728e-07,0.13375e-07,0.14035e-07,0.14711e-07 /)
      kbo(:,32, 1) = (/ &
        & 0.98596e-08,0.10344e-07,0.10879e-07,0.11427e-07,0.12003e-07 /)
      kbo(:,33, 1) = (/ &
        & 0.80127e-08,0.84199e-08,0.88610e-08,0.93188e-08,0.98102e-08 /)
      kbo(:,34, 1) = (/ &
        & 0.65473e-08,0.68850e-08,0.72470e-08,0.76379e-08,0.80329e-08 /)
      kbo(:,35, 1) = (/ &
        & 0.53107e-08,0.55930e-08,0.58984e-08,0.62161e-08,0.65511e-08 /)
      kbo(:,36, 1) = (/ &
        & 0.42749e-08,0.45072e-08,0.47592e-08,0.50244e-08,0.53034e-08 /)
      kbo(:,37, 1) = (/ &
        & 0.34593e-08,0.36479e-08,0.38557e-08,0.40714e-08,0.43031e-08 /)
      kbo(:,38, 1) = (/ &
        & 0.27981e-08,0.29525e-08,0.31212e-08,0.32984e-08,0.34890e-08 /)
      kbo(:,39, 1) = (/ &
        & 0.22616e-08,0.23879e-08,0.25266e-08,0.26716e-08,0.28295e-08 /)
      kbo(:,40, 1) = (/ &
        & 0.18232e-08,0.19245e-08,0.20362e-08,0.21554e-08,0.22831e-08 /)
      kbo(:,41, 1) = (/ &
        & 0.14679e-08,0.15511e-08,0.16402e-08,0.17376e-08,0.18413e-08 /)
      kbo(:,42, 1) = (/ &
        & 0.11828e-08,0.12488e-08,0.13200e-08,0.14008e-08,0.14841e-08 /)
      kbo(:,43, 1) = (/ &
        & 0.94970e-09,0.10028e-08,0.10610e-08,0.11254e-08,0.11933e-08 /)
      kbo(:,44, 1) = (/ &
        & 0.76210e-09,0.80401e-09,0.85098e-09,0.90203e-09,0.95794e-09 /)
      kbo(:,45, 1) = (/ &
        & 0.61242e-09,0.64471e-09,0.68205e-09,0.72336e-09,0.76846e-09 /)
      kbo(:,46, 1) = (/ &
        & 0.49214e-09,0.51642e-09,0.54633e-09,0.57916e-09,0.61506e-09 /)
      kbo(:,47, 1) = (/ &
        & 0.39552e-09,0.41343e-09,0.43658e-09,0.46266e-09,0.49121e-09 /)
      kbo(:,48, 1) = (/ &
        & 0.31773e-09,0.33161e-09,0.34878e-09,0.36970e-09,0.39231e-09 /)
      kbo(:,49, 1) = (/ &
        & 0.25526e-09,0.26613e-09,0.27906e-09,0.29510e-09,0.31346e-09 /)
      kbo(:,50, 1) = (/ &
        & 0.20571e-09,0.21419e-09,0.22379e-09,0.23622e-09,0.25076e-09 /)
      kbo(:,51, 1) = (/ &
        & 0.16573e-09,0.17251e-09,0.18002e-09,0.18925e-09,0.20074e-09 /)
      kbo(:,52, 1) = (/ &
        & 0.13312e-09,0.13888e-09,0.14480e-09,0.15170e-09,0.16067e-09 /)
      kbo(:,53, 1) = (/ &
        & 0.10717e-09,0.11200e-09,0.11653e-09,0.12187e-09,0.12864e-09 /)
      kbo(:,54, 1) = (/ &
        & 0.85395e-10,0.90190e-10,0.93978e-10,0.98115e-10,0.10324e-09 /)
      kbo(:,55, 1) = (/ &
        & 0.67933e-10,0.72682e-10,0.75857e-10,0.79079e-10,0.82942e-10 /)
      kbo(:,56, 1) = (/ &
        & 0.53572e-10,0.58095e-10,0.61231e-10,0.63738e-10,0.66738e-10 /)
      kbo(:,57, 1) = (/ &
        & 0.41729e-10,0.46380e-10,0.49357e-10,0.51409e-10,0.53743e-10 /)
      kbo(:,58, 1) = (/ &
        & 0.32319e-10,0.36737e-10,0.39572e-10,0.41487e-10,0.43327e-10 /)
      kbo(:,59, 1) = (/ &
        & 0.25820e-10,0.29541e-10,0.32107e-10,0.33762e-10,0.35250e-10 /)
      kbo(:,13, 2) = (/ &
        & 0.93809e-05,0.10536e-04,0.11777e-04,0.13098e-04,0.14486e-04 /)
      kbo(:,14, 2) = (/ &
        & 0.77050e-05,0.86520e-05,0.96745e-05,0.10759e-04,0.11891e-04 /)
      kbo(:,15, 2) = (/ &
        & 0.63112e-05,0.70914e-05,0.79320e-05,0.88179e-05,0.97344e-05 /)
      kbo(:,16, 2) = (/ &
        & 0.51672e-05,0.58172e-05,0.64961e-05,0.72133e-05,0.79595e-05 /)
      kbo(:,17, 2) = (/ &
        & 0.42470e-05,0.47817e-05,0.53396e-05,0.59229e-05,0.65385e-05 /)
      kbo(:,18, 2) = (/ &
        & 0.35105e-05,0.39513e-05,0.44042e-05,0.48865e-05,0.53983e-05 /)
      kbo(:,19, 2) = (/ &
        & 0.29057e-05,0.32680e-05,0.36409e-05,0.40419e-05,0.44646e-05 /)
      kbo(:,20, 2) = (/ &
        & 0.24132e-05,0.27111e-05,0.30192e-05,0.33498e-05,0.36985e-05 /)
      kbo(:,21, 2) = (/ &
        & 0.20041e-05,0.22484e-05,0.25052e-05,0.27770e-05,0.30661e-05 /)
      kbo(:,22, 2) = (/ &
        & 0.16762e-05,0.18775e-05,0.20900e-05,0.23158e-05,0.25543e-05 /)
      kbo(:,23, 2) = (/ &
        & 0.14013e-05,0.15665e-05,0.17433e-05,0.19308e-05,0.21290e-05 /)
      kbo(:,24, 2) = (/ &
        & 0.11680e-05,0.13039e-05,0.14515e-05,0.16085e-05,0.17733e-05 /)
      kbo(:,25, 2) = (/ &
        & 0.97491e-06,0.10886e-05,0.12114e-05,0.13428e-05,0.14806e-05 /)
      kbo(:,26, 2) = (/ &
        & 0.81608e-06,0.91198e-06,0.10148e-05,0.11244e-05,0.12392e-05 /)
      kbo(:,27, 2) = (/ &
        & 0.68407e-06,0.76432e-06,0.85048e-06,0.94210e-06,0.10393e-05 /)
      kbo(:,28, 2) = (/ &
        & 0.57340e-06,0.64071e-06,0.71311e-06,0.78988e-06,0.87304e-06 /)
      kbo(:,29, 2) = (/ &
        & 0.48234e-06,0.53886e-06,0.59992e-06,0.66557e-06,0.73565e-06 /)
      kbo(:,30, 2) = (/ &
        & 0.40628e-06,0.45384e-06,0.50638e-06,0.56175e-06,0.62086e-06 /)
      kbo(:,31, 2) = (/ &
        & 0.34276e-06,0.38409e-06,0.42817e-06,0.47551e-06,0.52508e-06 /)
      kbo(:,32, 2) = (/ &
        & 0.29024e-06,0.32548e-06,0.36291e-06,0.40263e-06,0.44423e-06 /)
      kbo(:,33, 2) = (/ &
        & 0.24623e-06,0.27596e-06,0.30748e-06,0.34104e-06,0.37571e-06 /)
      kbo(:,34, 2) = (/ &
        & 0.20814e-06,0.23318e-06,0.25975e-06,0.28746e-06,0.31674e-06 /)
      kbo(:,35, 2) = (/ &
        & 0.17399e-06,0.19476e-06,0.21698e-06,0.24021e-06,0.26463e-06 /)
      kbo(:,36, 2) = (/ &
        & 0.14352e-06,0.16079e-06,0.17920e-06,0.19838e-06,0.21852e-06 /)
      kbo(:,37, 2) = (/ &
        & 0.11644e-06,0.13061e-06,0.14569e-06,0.16148e-06,0.17794e-06 /)
      kbo(:,38, 2) = (/ &
        & 0.94327e-07,0.10597e-06,0.11827e-06,0.13121e-06,0.14471e-06 /)
      kbo(:,39, 2) = (/ &
        & 0.76386e-07,0.85932e-07,0.96004e-07,0.10675e-06,0.11785e-06 /)
      kbo(:,40, 2) = (/ &
        & 0.61093e-07,0.68856e-07,0.77088e-07,0.85831e-07,0.94878e-07 /)
      kbo(:,41, 2) = (/ &
        & 0.48781e-07,0.55058e-07,0.61725e-07,0.68852e-07,0.76234e-07 /)
      kbo(:,42, 2) = (/ &
        & 0.38909e-07,0.43987e-07,0.49391e-07,0.55161e-07,0.61197e-07 /)
      kbo(:,43, 2) = (/ &
        & 0.30779e-07,0.34866e-07,0.39222e-07,0.43870e-07,0.48785e-07 /)
      kbo(:,44, 2) = (/ &
        & 0.24249e-07,0.27514e-07,0.31014e-07,0.34774e-07,0.38772e-07 /)
      kbo(:,45, 2) = (/ &
        & 0.19076e-07,0.21693e-07,0.24514e-07,0.27522e-07,0.30756e-07 /)
      kbo(:,46, 2) = (/ &
        & 0.14949e-07,0.17046e-07,0.19303e-07,0.21721e-07,0.24320e-07 /)
      kbo(:,47, 2) = (/ &
        & 0.11627e-07,0.13294e-07,0.15102e-07,0.17040e-07,0.19115e-07 /)
      kbo(:,48, 2) = (/ &
        & 0.90208e-08,0.10359e-07,0.11803e-07,0.13349e-07,0.15003e-07 /)
      kbo(:,49, 2) = (/ &
        & 0.69979e-08,0.80625e-08,0.92075e-08,0.10445e-07,0.11768e-07 /)
      kbo(:,50, 2) = (/ &
        & 0.54507e-08,0.62777e-08,0.72004e-08,0.81899e-08,0.92488e-08 /)
      kbo(:,51, 2) = (/ &
        & 0.42541e-08,0.48933e-08,0.56304e-08,0.64214e-08,0.72725e-08 /)
      kbo(:,52, 2) = (/ &
        & 0.33161e-08,0.38121e-08,0.43976e-08,0.50301e-08,0.57140e-08 /)
      kbo(:,53, 2) = (/ &
        & 0.25817e-08,0.29691e-08,0.34291e-08,0.39368e-08,0.44836e-08 /)
      kbo(:,54, 2) = (/ &
        & 0.20203e-08,0.23228e-08,0.26823e-08,0.30900e-08,0.35285e-08 /)
      kbo(:,55, 2) = (/ &
        & 0.15833e-08,0.18196e-08,0.21023e-08,0.24276e-08,0.27787e-08 /)
      kbo(:,56, 2) = (/ &
        & 0.12403e-08,0.14250e-08,0.16461e-08,0.19045e-08,0.21855e-08 /)
      kbo(:,57, 2) = (/ &
        & 0.97249e-09,0.11164e-08,0.12881e-08,0.14923e-08,0.17175e-08 /)
      kbo(:,58, 2) = (/ &
        & 0.76431e-09,0.87699e-09,0.10108e-08,0.11709e-08,0.13516e-08 /)
      kbo(:,59, 2) = (/ &
        & 0.61553e-09,0.70649e-09,0.81463e-09,0.94315e-09,0.10907e-08 /)
      kbo(:,13, 3) = (/ &
        & 0.37708e-04,0.43942e-04,0.50586e-04,0.57656e-04,0.65139e-04 /)
      kbo(:,14, 3) = (/ &
        & 0.31694e-04,0.36862e-04,0.42350e-04,0.48197e-04,0.54341e-04 /)
      kbo(:,15, 3) = (/ &
        & 0.26564e-04,0.30824e-04,0.35372e-04,0.40180e-04,0.45231e-04 /)
      kbo(:,16, 3) = (/ &
        & 0.22232e-04,0.25740e-04,0.29512e-04,0.33447e-04,0.37588e-04 /)
      kbo(:,17, 3) = (/ &
        & 0.18578e-04,0.21467e-04,0.24582e-04,0.27832e-04,0.31221e-04 /)
      kbo(:,18, 3) = (/ &
        & 0.15530e-04,0.17922e-04,0.20498e-04,0.23170e-04,0.25973e-04 /)
      kbo(:,19, 3) = (/ &
        & 0.12972e-04,0.14952e-04,0.17059e-04,0.19270e-04,0.21580e-04 /)
      kbo(:,20, 3) = (/ &
        & 0.10858e-04,0.12498e-04,0.14228e-04,0.16061e-04,0.17958e-04 /)
      kbo(:,21, 3) = (/ &
        & 0.90819e-05,0.10446e-04,0.11880e-04,0.13394e-04,0.14951e-04 /)
      kbo(:,22, 3) = (/ &
        & 0.76648e-05,0.87979e-05,0.99931e-05,0.11255e-04,0.12542e-04 /)
      kbo(:,23, 3) = (/ &
        & 0.64634e-05,0.74140e-05,0.84086e-05,0.94546e-05,0.10527e-04 /)
      kbo(:,24, 3) = (/ &
        & 0.54523e-05,0.62464e-05,0.70809e-05,0.79508e-05,0.88446e-05 /)
      kbo(:,25, 3) = (/ &
        & 0.46110e-05,0.52716e-05,0.59693e-05,0.66904e-05,0.74322e-05 /)
      kbo(:,26, 3) = (/ &
        & 0.39134e-05,0.44620e-05,0.50425e-05,0.56439e-05,0.62577e-05 /)
      kbo(:,27, 3) = (/ &
        & 0.33208e-05,0.37777e-05,0.42629e-05,0.47607e-05,0.52714e-05 /)
      kbo(:,28, 3) = (/ &
        & 0.28177e-05,0.32008e-05,0.36031e-05,0.40187e-05,0.44358e-05 /)
      kbo(:,29, 3) = (/ &
        & 0.23932e-05,0.27158e-05,0.30516e-05,0.33945e-05,0.37416e-05 /)
      kbo(:,30, 3) = (/ &
        & 0.20340e-05,0.23035e-05,0.25827e-05,0.28672e-05,0.31559e-05 /)
      kbo(:,31, 3) = (/ &
        & 0.17308e-05,0.19547e-05,0.21869e-05,0.24243e-05,0.26649e-05 /)
      kbo(:,32, 3) = (/ &
        & 0.14734e-05,0.16593e-05,0.18536e-05,0.20518e-05,0.22514e-05 /)
      kbo(:,33, 3) = (/ &
        & 0.12538e-05,0.14097e-05,0.15718e-05,0.17369e-05,0.19013e-05 /)
      kbo(:,34, 3) = (/ &
        & 0.10626e-05,0.11932e-05,0.13290e-05,0.14662e-05,0.16025e-05 /)
      kbo(:,35, 3) = (/ &
        & 0.88990e-06,0.99878e-06,0.11122e-05,0.12266e-05,0.13395e-05 /)
      kbo(:,36, 3) = (/ &
        & 0.73535e-06,0.82690e-06,0.92099e-06,0.10159e-05,0.11099e-05 /)
      kbo(:,37, 3) = (/ &
        & 0.59728e-06,0.67301e-06,0.75127e-06,0.83021e-06,0.90845e-06 /)
      kbo(:,38, 3) = (/ &
        & 0.48484e-06,0.54737e-06,0.61229e-06,0.67762e-06,0.74258e-06 /)
      kbo(:,39, 3) = (/ &
        & 0.39347e-06,0.44485e-06,0.49886e-06,0.55290e-06,0.60674e-06 /)
      kbo(:,40, 3) = (/ &
        & 0.31488e-06,0.35703e-06,0.40148e-06,0.44640e-06,0.49091e-06 /)
      kbo(:,41, 3) = (/ &
        & 0.25130e-06,0.28561e-06,0.32224e-06,0.35953e-06,0.39618e-06 /)
      kbo(:,42, 3) = (/ &
        & 0.20030e-06,0.22840e-06,0.25834e-06,0.28930e-06,0.31965e-06 /)
      kbo(:,43, 3) = (/ &
        & 0.15807e-06,0.18109e-06,0.20542e-06,0.23094e-06,0.25635e-06 /)
      kbo(:,44, 3) = (/ &
        & 0.12418e-06,0.14282e-06,0.16261e-06,0.18364e-06,0.20465e-06 /)
      kbo(:,45, 3) = (/ &
        & 0.97383e-07,0.11245e-06,0.12855e-06,0.14572e-06,0.16307e-06 /)
      kbo(:,46, 3) = (/ &
        & 0.76015e-07,0.88067e-07,0.10120e-06,0.11510e-06,0.12935e-06 /)
      kbo(:,47, 3) = (/ &
        & 0.58813e-07,0.68493e-07,0.79102e-07,0.90273e-07,0.10200e-06 /)
      kbo(:,48, 3) = (/ &
        & 0.45440e-07,0.53144e-07,0.61597e-07,0.70639e-07,0.80255e-07 /)
      kbo(:,49, 3) = (/ &
        & 0.35015e-07,0.41136e-07,0.47869e-07,0.55216e-07,0.62994e-07 /)
      kbo(:,50, 3) = (/ &
        & 0.27056e-07,0.31910e-07,0.37267e-07,0.43210e-07,0.49522e-07 /)
      kbo(:,51, 3) = (/ &
        & 0.20908e-07,0.24756e-07,0.29044e-07,0.33791e-07,0.38904e-07 /)
      kbo(:,52, 3) = (/ &
        & 0.16131e-07,0.19181e-07,0.22589e-07,0.26378e-07,0.30504e-07 /)
      kbo(:,53, 3) = (/ &
        & 0.12418e-07,0.14835e-07,0.17537e-07,0.20547e-07,0.23860e-07 /)
      kbo(:,54, 3) = (/ &
        & 0.95994e-08,0.11514e-07,0.13662e-07,0.16065e-07,0.18717e-07 /)
      kbo(:,55, 3) = (/ &
        & 0.74239e-08,0.89453e-08,0.10656e-07,0.12569e-07,0.14693e-07 /)
      kbo(:,56, 3) = (/ &
        & 0.57300e-08,0.69441e-08,0.83030e-08,0.98193e-08,0.11523e-07 /)
      kbo(:,57, 3) = (/ &
        & 0.44152e-08,0.53811e-08,0.64581e-08,0.76610e-08,0.90201e-08 /)
      kbo(:,58, 3) = (/ &
        & 0.34072e-08,0.41708e-08,0.50297e-08,0.59876e-08,0.70684e-08 /)
      kbo(:,59, 3) = (/ &
        & 0.27302e-08,0.33492e-08,0.40481e-08,0.48266e-08,0.57046e-08 /)
      kbo(:,13, 4) = (/ &
        & 0.12015e-03,0.13920e-03,0.15937e-03,0.18001e-03,0.19929e-03 /)
      kbo(:,14, 4) = (/ &
        & 0.10256e-03,0.11883e-03,0.13587e-03,0.15259e-03,0.16812e-03 /)
      kbo(:,15, 4) = (/ &
        & 0.87203e-04,0.10099e-03,0.11498e-03,0.12847e-03,0.14114e-03 /)
      kbo(:,16, 4) = (/ &
        & 0.73859e-04,0.85304e-04,0.96816e-04,0.10774e-03,0.11805e-03 /)
      kbo(:,17, 4) = (/ &
        & 0.62334e-04,0.71786e-04,0.81225e-04,0.90091e-04,0.98454e-04 /)
      kbo(:,18, 4) = (/ &
        & 0.52581e-04,0.60344e-04,0.68018e-04,0.75237e-04,0.81903e-04 /)
      kbo(:,19, 4) = (/ &
        & 0.44197e-04,0.50573e-04,0.56840e-04,0.62656e-04,0.67968e-04 /)
      kbo(:,20, 4) = (/ &
        & 0.37151e-04,0.42384e-04,0.47494e-04,0.52193e-04,0.56467e-04 /)
      kbo(:,21, 4) = (/ &
        & 0.31193e-04,0.35480e-04,0.39600e-04,0.43427e-04,0.46870e-04 /)
      kbo(:,22, 4) = (/ &
        & 0.26374e-04,0.29925e-04,0.33224e-04,0.36261e-04,0.39040e-04 /)
      kbo(:,23, 4) = (/ &
        & 0.22315e-04,0.25198e-04,0.27833e-04,0.30290e-04,0.32509e-04 /)
      kbo(:,24, 4) = (/ &
        & 0.18883e-04,0.21184e-04,0.23291e-04,0.25268e-04,0.27046e-04 /)
      kbo(:,25, 4) = (/ &
        & 0.15977e-04,0.17808e-04,0.19529e-04,0.21106e-04,0.22533e-04 /)
      kbo(:,26, 4) = (/ &
        & 0.13524e-04,0.14996e-04,0.16391e-04,0.17658e-04,0.18796e-04 /)
      kbo(:,27, 4) = (/ &
        & 0.11433e-04,0.12631e-04,0.13757e-04,0.14769e-04,0.15677e-04 /)
      kbo(:,28, 4) = (/ &
        & 0.96558e-05,0.10640e-04,0.11537e-04,0.12357e-04,0.13086e-04 /)
      kbo(:,29, 4) = (/ &
        & 0.81632e-05,0.89560e-05,0.96801e-05,0.10339e-04,0.10919e-04 /)
      kbo(:,30, 4) = (/ &
        & 0.68972e-05,0.75321e-05,0.81189e-05,0.86418e-05,0.91120e-05 /)
      kbo(:,31, 4) = (/ &
        & 0.58255e-05,0.63427e-05,0.68115e-05,0.72291e-05,0.76088e-05 /)
      kbo(:,32, 4) = (/ &
        & 0.49235e-05,0.53404e-05,0.57128e-05,0.60450e-05,0.63540e-05 /)
      kbo(:,33, 4) = (/ &
        & 0.41602e-05,0.44904e-05,0.47873e-05,0.50567e-05,0.53085e-05 /)
      kbo(:,34, 4) = (/ &
        & 0.34993e-05,0.37640e-05,0.40033e-05,0.42217e-05,0.44321e-05 /)
      kbo(:,35, 4) = (/ &
        & 0.29168e-05,0.31331e-05,0.33264e-05,0.35072e-05,0.36808e-05 /)
      kbo(:,36, 4) = (/ &
        & 0.24105e-05,0.25863e-05,0.27459e-05,0.28969e-05,0.30433e-05 /)
      kbo(:,37, 4) = (/ &
        & 0.19699e-05,0.21167e-05,0.22499e-05,0.23751e-05,0.24984e-05 /)
      kbo(:,38, 4) = (/ &
        & 0.16085e-05,0.17316e-05,0.18431e-05,0.19482e-05,0.20520e-05 /)
      kbo(:,39, 4) = (/ &
        & 0.13140e-05,0.14172e-05,0.15102e-05,0.15989e-05,0.16862e-05 /)
      kbo(:,40, 4) = (/ &
        & 0.10643e-05,0.11518e-05,0.12300e-05,0.13052e-05,0.13789e-05 /)
      kbo(:,41, 4) = (/ &
        & 0.86103e-06,0.93494e-06,0.10013e-05,0.10648e-05,0.11275e-05 /)
      kbo(:,42, 4) = (/ &
        & 0.69566e-06,0.75803e-06,0.81468e-06,0.86817e-06,0.92113e-06 /)
      kbo(:,43, 4) = (/ &
        & 0.55856e-06,0.61135e-06,0.65992e-06,0.70501e-06,0.74915e-06 /)
      kbo(:,44, 4) = (/ &
        & 0.44644e-06,0.49113e-06,0.53284e-06,0.57066e-06,0.60776e-06 /)
      kbo(:,45, 4) = (/ &
        & 0.35638e-06,0.39386e-06,0.42947e-06,0.46192e-06,0.49295e-06 /)
      kbo(:,46, 4) = (/ &
        & 0.28317e-06,0.31490e-06,0.34503e-06,0.37276e-06,0.39894e-06 /)
      kbo(:,47, 4) = (/ &
        & 0.22341e-06,0.25002e-06,0.27560e-06,0.29957e-06,0.32144e-06 /)
      kbo(:,48, 4) = (/ &
        & 0.17554e-06,0.19798e-06,0.21962e-06,0.24010e-06,0.25876e-06 /)
      kbo(:,49, 4) = (/ &
        & 0.13737e-06,0.15642e-06,0.17451e-06,0.19192e-06,0.20795e-06 /)
      kbo(:,50, 4) = (/ &
        & 0.10754e-06,0.12357e-06,0.13879e-06,0.15343e-06,0.16712e-06 /)
      kbo(:,51, 4) = (/ &
        & 0.84121e-07,0.97441e-07,0.11018e-06,0.12256e-06,0.13419e-06 /)
      kbo(:,52, 4) = (/ &
        & 0.65604e-07,0.76564e-07,0.87356e-07,0.97703e-07,0.10745e-06 /)
      kbo(:,53, 4) = (/ &
        & 0.50943e-07,0.59988e-07,0.69048e-07,0.77629e-07,0.85933e-07 /)
      kbo(:,54, 4) = (/ &
        & 0.39679e-07,0.47121e-07,0.54614e-07,0.61766e-07,0.68783e-07 /)
      kbo(:,55, 4) = (/ &
        & 0.30934e-07,0.36980e-07,0.43113e-07,0.49142e-07,0.55005e-07 /)
      kbo(:,56, 4) = (/ &
        & 0.24050e-07,0.28923e-07,0.33993e-07,0.39047e-07,0.43928e-07 /)
      kbo(:,57, 4) = (/ &
        & 0.18660e-07,0.22557e-07,0.26748e-07,0.30951e-07,0.35000e-07 /)
      kbo(:,58, 4) = (/ &
        & 0.14488e-07,0.17625e-07,0.21043e-07,0.24511e-07,0.27884e-07 /)
      kbo(:,59, 4) = (/ &
        & 0.11674e-07,0.14234e-07,0.17044e-07,0.19902e-07,0.22702e-07 /)
      kbo(:,13, 5) = (/ &
        & 0.36288e-03,0.38577e-03,0.40824e-03,0.43207e-03,0.45772e-03 /)
      kbo(:,14, 5) = (/ &
        & 0.30781e-03,0.32754e-03,0.34745e-03,0.36873e-03,0.39050e-03 /)
      kbo(:,15, 5) = (/ &
        & 0.26023e-03,0.27734e-03,0.29481e-03,0.31288e-03,0.33087e-03 /)
      kbo(:,16, 5) = (/ &
        & 0.21963e-03,0.23414e-03,0.24882e-03,0.26383e-03,0.27866e-03 /)
      kbo(:,17, 5) = (/ &
        & 0.18486e-03,0.19716e-03,0.20932e-03,0.22139e-03,0.23350e-03 /)
      kbo(:,18, 5) = (/ &
        & 0.15516e-03,0.16534e-03,0.17526e-03,0.18520e-03,0.19528e-03 /)
      kbo(:,19, 5) = (/ &
        & 0.12986e-03,0.13820e-03,0.14634e-03,0.15465e-03,0.16304e-03 /)
      kbo(:,20, 5) = (/ &
        & 0.10854e-03,0.11542e-03,0.12213e-03,0.12898e-03,0.13583e-03 /)
      kbo(:,21, 5) = (/ &
        & 0.90628e-04,0.96255e-04,0.10177e-03,0.10738e-03,0.11299e-03 /)
      kbo(:,22, 5) = (/ &
        & 0.75891e-04,0.80410e-04,0.85018e-04,0.89561e-04,0.94064e-04 /)
      kbo(:,23, 5) = (/ &
        & 0.63476e-04,0.67177e-04,0.70959e-04,0.74590e-04,0.78334e-04 /)
      kbo(:,24, 5) = (/ &
        & 0.52999e-04,0.56057e-04,0.59157e-04,0.62167e-04,0.65272e-04 /)
      kbo(:,25, 5) = (/ &
        & 0.44256e-04,0.46783e-04,0.49281e-04,0.51789e-04,0.54376e-04 /)
      kbo(:,26, 5) = (/ &
        & 0.37011e-04,0.39100e-04,0.41098e-04,0.43198e-04,0.45322e-04 /)
      kbo(:,27, 5) = (/ &
        & 0.30966e-04,0.32635e-04,0.34289e-04,0.36026e-04,0.37776e-04 /)
      kbo(:,28, 5) = (/ &
        & 0.25866e-04,0.27210e-04,0.28616e-04,0.30009e-04,0.31487e-04 /)
      kbo(:,29, 5) = (/ &
        & 0.21609e-04,0.22715e-04,0.23863e-04,0.25052e-04,0.26299e-04 /)
      kbo(:,30, 5) = (/ &
        & 0.18055e-04,0.18981e-04,0.19946e-04,0.20948e-04,0.21978e-04 /)
      kbo(:,31, 5) = (/ &
        & 0.15103e-04,0.15890e-04,0.16699e-04,0.17556e-04,0.18410e-04 /)
      kbo(:,32, 5) = (/ &
        & 0.12647e-04,0.13313e-04,0.14001e-04,0.14715e-04,0.15427e-04 /)
      kbo(:,33, 5) = (/ &
        & 0.10601e-04,0.11164e-04,0.11755e-04,0.12351e-04,0.12931e-04 /)
      kbo(:,34, 5) = (/ &
        & 0.88699e-05,0.93482e-05,0.98481e-05,0.10351e-04,0.10829e-04 /)
      kbo(:,35, 5) = (/ &
        & 0.73864e-05,0.77932e-05,0.82148e-05,0.86289e-05,0.90270e-05 /)
      kbo(:,36, 5) = (/ &
        & 0.61189e-05,0.64631e-05,0.68137e-05,0.71535e-05,0.74761e-05 /)
      kbo(:,37, 5) = (/ &
        & 0.50349e-05,0.53216e-05,0.56110e-05,0.58984e-05,0.61738e-05 /)
      kbo(:,38, 5) = (/ &
        & 0.41408e-05,0.43804e-05,0.46209e-05,0.48585e-05,0.50962e-05 /)
      kbo(:,39, 5) = (/ &
        & 0.34100e-05,0.36097e-05,0.38105e-05,0.40114e-05,0.42081e-05 /)
      kbo(:,40, 5) = (/ &
        & 0.27924e-05,0.29567e-05,0.31274e-05,0.32925e-05,0.34580e-05 /)
      kbo(:,41, 5) = (/ &
        & 0.22821e-05,0.24196e-05,0.25613e-05,0.27009e-05,0.28413e-05 /)
      kbo(:,42, 5) = (/ &
        & 0.18665e-05,0.19799e-05,0.20975e-05,0.22150e-05,0.23326e-05 /)
      kbo(:,43, 5) = (/ &
        & 0.15195e-05,0.16130e-05,0.17109e-05,0.18095e-05,0.19094e-05 /)
      kbo(:,44, 5) = (/ &
        & 0.12351e-05,0.13129e-05,0.13926e-05,0.14756e-05,0.15593e-05 /)
      kbo(:,45, 5) = (/ &
        & 0.10023e-05,0.10671e-05,0.11334e-05,0.12033e-05,0.12728e-05 /)
      kbo(:,46, 5) = (/ &
        & 0.81269e-06,0.86595e-06,0.92094e-06,0.97875e-06,0.10378e-05 /)
      kbo(:,47, 5) = (/ &
        & 0.65647e-06,0.70081e-06,0.74604e-06,0.79395e-06,0.84339e-06 /)
      kbo(:,48, 5) = (/ &
        & 0.53019e-06,0.56638e-06,0.60399e-06,0.64368e-06,0.68472e-06 /)
      kbo(:,49, 5) = (/ &
        & 0.42776e-06,0.45739e-06,0.48880e-06,0.52108e-06,0.55567e-06 /)
      kbo(:,50, 5) = (/ &
        & 0.34556e-06,0.36989e-06,0.39599e-06,0.42284e-06,0.45123e-06 /)
      kbo(:,51, 5) = (/ &
        & 0.27905e-06,0.29932e-06,0.32065e-06,0.34295e-06,0.36646e-06 /)
      kbo(:,52, 5) = (/ &
        & 0.22522e-06,0.24196e-06,0.25940e-06,0.27788e-06,0.29753e-06 /)
      kbo(:,53, 5) = (/ &
        & 0.18137e-06,0.19527e-06,0.20965e-06,0.22512e-06,0.24112e-06 /)
      kbo(:,54, 5) = (/ &
        & 0.14606e-06,0.15795e-06,0.16971e-06,0.18256e-06,0.19571e-06 /)
      kbo(:,55, 5) = (/ &
        & 0.11745e-06,0.12764e-06,0.13751e-06,0.14796e-06,0.15891e-06 /)
      kbo(:,56, 5) = (/ &
        & 0.94319e-07,0.10301e-06,0.11131e-06,0.11979e-06,0.12892e-06 /)
      kbo(:,57, 5) = (/ &
        & 0.75512e-07,0.83064e-07,0.90010e-07,0.96928e-07,0.10441e-06 /)
      kbo(:,58, 5) = (/ &
        & 0.60409e-07,0.66900e-07,0.72712e-07,0.78451e-07,0.84657e-07 /)
      kbo(:,59, 5) = (/ &
        & 0.49299e-07,0.54731e-07,0.59628e-07,0.64415e-07,0.69585e-07 /)
      kbo(:,13, 6) = (/ &
        & 0.85498e-03,0.88654e-03,0.92216e-03,0.96018e-03,0.10038e-02 /)
      kbo(:,14, 6) = (/ &
        & 0.72755e-03,0.75503e-03,0.78615e-03,0.82104e-03,0.86252e-03 /)
      kbo(:,15, 6) = (/ &
        & 0.61644e-03,0.64130e-03,0.66934e-03,0.70298e-03,0.74077e-03 /)
      kbo(:,16, 6) = (/ &
        & 0.52100e-03,0.54364e-03,0.57046e-03,0.60137e-03,0.63388e-03 /)
      kbo(:,17, 6) = (/ &
        & 0.43945e-03,0.46060e-03,0.48533e-03,0.51276e-03,0.54036e-03 /)
      kbo(:,18, 6) = (/ &
        & 0.37082e-03,0.39025e-03,0.41242e-03,0.43532e-03,0.45905e-03 /)
      kbo(:,19, 6) = (/ &
        & 0.31280e-03,0.33005e-03,0.34867e-03,0.36806e-03,0.38776e-03 /)
      kbo(:,20, 6) = (/ &
        & 0.26373e-03,0.27881e-03,0.29445e-03,0.31046e-03,0.32667e-03 /)
      kbo(:,21, 6) = (/ &
        & 0.22211e-03,0.23470e-03,0.24766e-03,0.26115e-03,0.27459e-03 /)
      kbo(:,22, 6) = (/ &
        & 0.18729e-03,0.19773e-03,0.20869e-03,0.22010e-03,0.23102e-03 /)
      kbo(:,23, 6) = (/ &
        & 0.15755e-03,0.16634e-03,0.17574e-03,0.18527e-03,0.19396e-03 /)
      kbo(:,24, 6) = (/ &
        & 0.13244e-03,0.14003e-03,0.14791e-03,0.15556e-03,0.16235e-03 /)
      kbo(:,25, 6) = (/ &
        & 0.11137e-03,0.11779e-03,0.12437e-03,0.13036e-03,0.13579e-03 /)
      kbo(:,26, 6) = (/ &
        & 0.93817e-04,0.99206e-04,0.10452e-03,0.10918e-03,0.11356e-03 /)
      kbo(:,27, 6) = (/ &
        & 0.79006e-04,0.83531e-04,0.87717e-04,0.91355e-04,0.95066e-04 /)
      kbo(:,28, 6) = (/ &
        & 0.66464e-04,0.70180e-04,0.73412e-04,0.76548e-04,0.79673e-04 /)
      kbo(:,29, 6) = (/ &
        & 0.55955e-04,0.58876e-04,0.61539e-04,0.64161e-04,0.66744e-04 /)
      kbo(:,30, 6) = (/ &
        & 0.47057e-04,0.49392e-04,0.51539e-04,0.53762e-04,0.55883e-04 /)
      kbo(:,31, 6) = (/ &
        & 0.39571e-04,0.41398e-04,0.43230e-04,0.45052e-04,0.46859e-04 /)
      kbo(:,32, 6) = (/ &
        & 0.33232e-04,0.34753e-04,0.36306e-04,0.37802e-04,0.39368e-04 /)
      kbo(:,33, 6) = (/ &
        & 0.27886e-04,0.29183e-04,0.30428e-04,0.31753e-04,0.33114e-04 /)
      kbo(:,34, 6) = (/ &
        & 0.23408e-04,0.24477e-04,0.25555e-04,0.26683e-04,0.27811e-04 /)
      kbo(:,35, 6) = (/ &
        & 0.19576e-04,0.20476e-04,0.21380e-04,0.22323e-04,0.23289e-04 /)
      kbo(:,36, 6) = (/ &
        & 0.16284e-04,0.17049e-04,0.17816e-04,0.18626e-04,0.19444e-04 /)
      kbo(:,37, 6) = (/ &
        & 0.13488e-04,0.14134e-04,0.14781e-04,0.15488e-04,0.16173e-04 /)
      kbo(:,38, 6) = (/ &
        & 0.11176e-04,0.11721e-04,0.12278e-04,0.12866e-04,0.13450e-04 /)
      kbo(:,39, 6) = (/ &
        & 0.92494e-05,0.97155e-05,0.10200e-04,0.10699e-04,0.11199e-04 /)
      kbo(:,40, 6) = (/ &
        & 0.76168e-05,0.80109e-05,0.84197e-05,0.88496e-05,0.92853e-05 /)
      kbo(:,41, 6) = (/ &
        & 0.62645e-05,0.66003e-05,0.69472e-05,0.73123e-05,0.76881e-05 /)
      kbo(:,42, 6) = (/ &
        & 0.51581e-05,0.54373e-05,0.57325e-05,0.60421e-05,0.63612e-05 /)
      kbo(:,43, 6) = (/ &
        & 0.42336e-05,0.44705e-05,0.47241e-05,0.49790e-05,0.52554e-05 /)
      kbo(:,44, 6) = (/ &
        & 0.34635e-05,0.36643e-05,0.38777e-05,0.40942e-05,0.43335e-05 /)
      kbo(:,45, 6) = (/ &
        & 0.28355e-05,0.30041e-05,0.31829e-05,0.33678e-05,0.35664e-05 /)
      kbo(:,46, 6) = (/ &
        & 0.23151e-05,0.24589e-05,0.26085e-05,0.27655e-05,0.29287e-05 /)
      kbo(:,47, 6) = (/ &
        & 0.18832e-05,0.20045e-05,0.21306e-05,0.22633e-05,0.24025e-05 /)
      kbo(:,48, 6) = (/ &
        & 0.15291e-05,0.16326e-05,0.17368e-05,0.18516e-05,0.19681e-05 /)
      kbo(:,49, 6) = (/ &
        & 0.12403e-05,0.13270e-05,0.14154e-05,0.15108e-05,0.16100e-05 /)
      kbo(:,50, 6) = (/ &
        & 0.10056e-05,0.10792e-05,0.11542e-05,0.12335e-05,0.13173e-05 /)
      kbo(:,51, 6) = (/ &
        & 0.81549e-06,0.87791e-06,0.94116e-06,0.10080e-05,0.10781e-05 /)
      kbo(:,52, 6) = (/ &
        & 0.66029e-06,0.71307e-06,0.76617e-06,0.82179e-06,0.88107e-06 /)
      kbo(:,53, 6) = (/ &
        & 0.53353e-06,0.57858e-06,0.62276e-06,0.66919e-06,0.71931e-06 /)
      kbo(:,54, 6) = (/ &
        & 0.43199e-06,0.46970e-06,0.50695e-06,0.54584e-06,0.58793e-06 /)
      kbo(:,55, 6) = (/ &
        & 0.34966e-06,0.38119e-06,0.41298e-06,0.44530e-06,0.48058e-06 /)
      kbo(:,56, 6) = (/ &
        & 0.28227e-06,0.30903e-06,0.33563e-06,0.36285e-06,0.39216e-06 /)
      kbo(:,57, 6) = (/ &
        & 0.22764e-06,0.25006e-06,0.27265e-06,0.29503e-06,0.31940e-06 /)
      kbo(:,58, 6) = (/ &
        & 0.18380e-06,0.20248e-06,0.22144e-06,0.24002e-06,0.25999e-06 /)
      kbo(:,59, 6) = (/ &
        & 0.15102e-06,0.16680e-06,0.18267e-06,0.19825e-06,0.21512e-06 /)
      kbo(:,13, 7) = (/ &
        & 0.20763e-02,0.21202e-02,0.21697e-02,0.22297e-02,0.22985e-02 /)
      kbo(:,14, 7) = (/ &
        & 0.17631e-02,0.18004e-02,0.18452e-02,0.18998e-02,0.19604e-02 /)
      kbo(:,15, 7) = (/ &
        & 0.14970e-02,0.15286e-02,0.15695e-02,0.16172e-02,0.16748e-02 /)
      kbo(:,16, 7) = (/ &
        & 0.12672e-02,0.12965e-02,0.13340e-02,0.13795e-02,0.14367e-02 /)
      kbo(:,17, 7) = (/ &
        & 0.10695e-02,0.10974e-02,0.11329e-02,0.11783e-02,0.12365e-02 /)
      kbo(:,18, 7) = (/ &
        & 0.90477e-03,0.93070e-03,0.96470e-03,0.10105e-02,0.10654e-02 /)
      kbo(:,19, 7) = (/ &
        & 0.76431e-03,0.79078e-03,0.82660e-03,0.86991e-03,0.91843e-03 /)
      kbo(:,20, 7) = (/ &
        & 0.64676e-03,0.67404e-03,0.70901e-03,0.74996e-03,0.79243e-03 /)
      kbo(:,21, 7) = (/ &
        & 0.54776e-03,0.57523e-03,0.60880e-03,0.64511e-03,0.68243e-03 /)
      kbo(:,22, 7) = (/ &
        & 0.46614e-03,0.49254e-03,0.52330e-03,0.55502e-03,0.58894e-03 /)
      kbo(:,23, 7) = (/ &
        & 0.39726e-03,0.42201e-03,0.44841e-03,0.47653e-03,0.50717e-03 /)
      kbo(:,24, 7) = (/ &
        & 0.33898e-03,0.36121e-03,0.38421e-03,0.40924e-03,0.43694e-03 /)
      kbo(:,25, 7) = (/ &
        & 0.28981e-03,0.30891e-03,0.32925e-03,0.35185e-03,0.37616e-03 /)
      kbo(:,26, 7) = (/ &
        & 0.24765e-03,0.26436e-03,0.28268e-03,0.30306e-03,0.32381e-03 /)
      kbo(:,27, 7) = (/ &
        & 0.21161e-03,0.22639e-03,0.24293e-03,0.26080e-03,0.27811e-03 /)
      kbo(:,28, 7) = (/ &
        & 0.18103e-03,0.19425e-03,0.20911e-03,0.22426e-03,0.23882e-03 /)
      kbo(:,29, 7) = (/ &
        & 0.15524e-03,0.16726e-03,0.18025e-03,0.19313e-03,0.20539e-03 /)
      kbo(:,30, 7) = (/ &
        & 0.13346e-03,0.14432e-03,0.15555e-03,0.16625e-03,0.17682e-03 /)
      kbo(:,31, 7) = (/ &
        & 0.11513e-03,0.12466e-03,0.13417e-03,0.14329e-03,0.15286e-03 /)
      kbo(:,32, 7) = (/ &
        & 0.99437e-04,0.10768e-03,0.11569e-03,0.12397e-03,0.13224e-03 /)
      kbo(:,33, 7) = (/ &
        & 0.85975e-04,0.92901e-04,0.10007e-03,0.10742e-03,0.11487e-03 /)
      kbo(:,34, 7) = (/ &
        & 0.74186e-04,0.80283e-04,0.86524e-04,0.92965e-04,0.99720e-04 /)
      kbo(:,35, 7) = (/ &
        & 0.63518e-04,0.68833e-04,0.74348e-04,0.80205e-04,0.86286e-04 /)
      kbo(:,36, 7) = (/ &
        & 0.53971e-04,0.58710e-04,0.63581e-04,0.68731e-04,0.74066e-04 /)
      kbo(:,37, 7) = (/ &
        & 0.45287e-04,0.49433e-04,0.53695e-04,0.58207e-04,0.62933e-04 /)
      kbo(:,38, 7) = (/ &
        & 0.37993e-04,0.41562e-04,0.45327e-04,0.49315e-04,0.53437e-04 /)
      kbo(:,39, 7) = (/ &
        & 0.31889e-04,0.34954e-04,0.38268e-04,0.41760e-04,0.45472e-04 /)
      kbo(:,40, 7) = (/ &
        & 0.26490e-04,0.29130e-04,0.31995e-04,0.35094e-04,0.38302e-04 /)
      kbo(:,41, 7) = (/ &
        & 0.21977e-04,0.24258e-04,0.26702e-04,0.29405e-04,0.32254e-04 /)
      kbo(:,42, 7) = (/ &
        & 0.18218e-04,0.20180e-04,0.22299e-04,0.24616e-04,0.27154e-04 /)
      kbo(:,43, 7) = (/ &
        & 0.15034e-04,0.16668e-04,0.18493e-04,0.20514e-04,0.22747e-04 /)
      kbo(:,44, 7) = (/ &
        & 0.12376e-04,0.13730e-04,0.15276e-04,0.16983e-04,0.18913e-04 /)
      kbo(:,45, 7) = (/ &
        & 0.10149e-04,0.11314e-04,0.12590e-04,0.14099e-04,0.15742e-04 /)
      kbo(:,46, 7) = (/ &
        & 0.82889e-05,0.92859e-05,0.10354e-04,0.11603e-04,0.13042e-04 /)
      kbo(:,47, 7) = (/ &
        & 0.67264e-05,0.75707e-05,0.84748e-05,0.95081e-05,0.10721e-04 /)
      kbo(:,48, 7) = (/ &
        & 0.54454e-05,0.61678e-05,0.69329e-05,0.77845e-05,0.87984e-05 /)
      kbo(:,49, 7) = (/ &
        & 0.43942e-05,0.50075e-05,0.56558e-05,0.63802e-05,0.72168e-05 /)
      kbo(:,50, 7) = (/ &
        & 0.35518e-05,0.40682e-05,0.46246e-05,0.52318e-05,0.59289e-05 /)
      kbo(:,51, 7) = (/ &
        & 0.28695e-05,0.33032e-05,0.37766e-05,0.42938e-05,0.48871e-05 /)
      kbo(:,52, 7) = (/ &
        & 0.23151e-05,0.26733e-05,0.30760e-05,0.35184e-05,0.40216e-05 /)
      kbo(:,53, 7) = (/ &
        & 0.18635e-05,0.21569e-05,0.24979e-05,0.28705e-05,0.33004e-05 /)
      kbo(:,54, 7) = (/ &
        & 0.15043e-05,0.17492e-05,0.20309e-05,0.23469e-05,0.27129e-05 /)
      kbo(:,55, 7) = (/ &
        & 0.12156e-05,0.14170e-05,0.16506e-05,0.19188e-05,0.22303e-05 /)
      kbo(:,56, 7) = (/ &
        & 0.98090e-06,0.11440e-05,0.13395e-05,0.15647e-05,0.18280e-05 /)
      kbo(:,57, 7) = (/ &
        & 0.79029e-06,0.92216e-06,0.10880e-05,0.12732e-05,0.14934e-05 /)
      kbo(:,58, 7) = (/ &
        & 0.63691e-06,0.74365e-06,0.88187e-06,0.10375e-05,0.12193e-05 /)
      kbo(:,59, 7) = (/ &
        & 0.52696e-06,0.61783e-06,0.73672e-06,0.87054e-06,0.10284e-05 /)
      kbo(:,13, 8) = (/ &
        & 0.57453e-02,0.59077e-02,0.61032e-02,0.63038e-02,0.65156e-02 /)
      kbo(:,14, 8) = (/ &
        & 0.49738e-02,0.51301e-02,0.52927e-02,0.54623e-02,0.56575e-02 /)
      kbo(:,15, 8) = (/ &
        & 0.43017e-02,0.44326e-02,0.45703e-02,0.47292e-02,0.49039e-02 /)
      kbo(:,16, 8) = (/ &
        & 0.37082e-02,0.38170e-02,0.39427e-02,0.40844e-02,0.42438e-02 /)
      kbo(:,17, 8) = (/ &
        & 0.31847e-02,0.32833e-02,0.33960e-02,0.35252e-02,0.36740e-02 /)
      kbo(:,18, 8) = (/ &
        & 0.27225e-02,0.28155e-02,0.29216e-02,0.30449e-02,0.31911e-02 /)
      kbo(:,19, 8) = (/ &
        & 0.23309e-02,0.24127e-02,0.25113e-02,0.26325e-02,0.27748e-02 /)
      kbo(:,20, 8) = (/ &
        & 0.19939e-02,0.20703e-02,0.21659e-02,0.22816e-02,0.24232e-02 /)
      kbo(:,21, 8) = (/ &
        & 0.17051e-02,0.17809e-02,0.18754e-02,0.19919e-02,0.21299e-02 /)
      kbo(:,22, 8) = (/ &
        & 0.14632e-02,0.15412e-02,0.16376e-02,0.17554e-02,0.18936e-02 /)
      kbo(:,23, 8) = (/ &
        & 0.12639e-02,0.13422e-02,0.14407e-02,0.15575e-02,0.16941e-02 /)
      kbo(:,24, 8) = (/ &
        & 0.10971e-02,0.11767e-02,0.12764e-02,0.13939e-02,0.15238e-02 /)
      kbo(:,25, 8) = (/ &
        & 0.95870e-03,0.10413e-02,0.11414e-02,0.12556e-02,0.13798e-02 /)
      kbo(:,26, 8) = (/ &
        & 0.84686e-03,0.93021e-03,0.10287e-02,0.11374e-02,0.12572e-02 /)
      kbo(:,27, 8) = (/ &
        & 0.75447e-03,0.83724e-03,0.93234e-03,0.10369e-02,0.11513e-02 /)
      kbo(:,28, 8) = (/ &
        & 0.67798e-03,0.75937e-03,0.85009e-03,0.95072e-03,0.10606e-02 /)
      kbo(:,29, 8) = (/ &
        & 0.61364e-03,0.69262e-03,0.77994e-03,0.87674e-03,0.98252e-03 /)
      kbo(:,30, 8) = (/ &
        & 0.55903e-03,0.63520e-03,0.71974e-03,0.81322e-03,0.91554e-03 /)
      kbo(:,31, 8) = (/ &
        & 0.51301e-03,0.58698e-03,0.66923e-03,0.75972e-03,0.85851e-03 /)
      kbo(:,32, 8) = (/ &
        & 0.47350e-03,0.54617e-03,0.62663e-03,0.71470e-03,0.81105e-03 /)
      kbo(:,33, 8) = (/ &
        & 0.44016e-03,0.51136e-03,0.58994e-03,0.67638e-03,0.77061e-03 /)
      kbo(:,34, 8) = (/ &
        & 0.40944e-03,0.47900e-03,0.55611e-03,0.64143e-03,0.73316e-03 /)
      kbo(:,35, 8) = (/ &
        & 0.37741e-03,0.44487e-03,0.52031e-03,0.60323e-03,0.69243e-03 /)
      kbo(:,36, 8) = (/ &
        & 0.34297e-03,0.40766e-03,0.48086e-03,0.56132e-03,0.64787e-03 /)
      kbo(:,37, 8) = (/ &
        & 0.30431e-03,0.36499e-03,0.43465e-03,0.51167e-03,0.59496e-03 /)
      kbo(:,38, 8) = (/ &
        & 0.26970e-03,0.32665e-03,0.39267e-03,0.46706e-03,0.54760e-03 /)
      kbo(:,39, 8) = (/ &
        & 0.23923e-03,0.29254e-03,0.35537e-03,0.42706e-03,0.50543e-03 /)
      kbo(:,40, 8) = (/ &
        & 0.20758e-03,0.25688e-03,0.31519e-03,0.38349e-03,0.45925e-03 /)
      kbo(:,41, 8) = (/ &
        & 0.17937e-03,0.22435e-03,0.27886e-03,0.34337e-03,0.41641e-03 /)
      kbo(:,42, 8) = (/ &
        & 0.15469e-03,0.19589e-03,0.24606e-03,0.30674e-03,0.37723e-03 /)
      kbo(:,43, 8) = (/ &
        & 0.13101e-03,0.16796e-03,0.21371e-03,0.26992e-03,0.33751e-03 /)
      kbo(:,44, 8) = (/ &
        & 0.10980e-03,0.14260e-03,0.18396e-03,0.23557e-03,0.29905e-03 /)
      kbo(:,45, 8) = (/ &
        & 0.91682e-04,0.12045e-03,0.15770e-03,0.20472e-03,0.26370e-03 /)
      kbo(:,46, 8) = (/ &
        & 0.75628e-04,0.10059e-03,0.13347e-03,0.17595e-03,0.22995e-03 /)
      kbo(:,47, 8) = (/ &
        & 0.61269e-04,0.82597e-04,0.11115e-03,0.14863e-03,0.19734e-03 /)
      kbo(:,48, 8) = (/ &
        & 0.49295e-04,0.67304e-04,0.91698e-04,0.12475e-03,0.16838e-03 /)
      kbo(:,49, 8) = (/ &
        & 0.39400e-04,0.54424e-04,0.75252e-04,0.10388e-03,0.14254e-03 /)
      kbo(:,50, 8) = (/ &
        & 0.31621e-04,0.44130e-04,0.61905e-04,0.86583e-04,0.12082e-03 /)
      kbo(:,51, 8) = (/ &
        & 0.25214e-04,0.35613e-04,0.50609e-04,0.71998e-04,0.10219e-03 /)
      kbo(:,52, 8) = (/ &
        & 0.20045e-04,0.28626e-04,0.41171e-04,0.59458e-04,0.85829e-04 /)
      kbo(:,53, 8) = (/ &
        & 0.15795e-04,0.22859e-04,0.33218e-04,0.48810e-04,0.71516e-04 /)
      kbo(:,54, 8) = (/ &
        & 0.12537e-04,0.18343e-04,0.26979e-04,0.40183e-04,0.59926e-04 /)
      kbo(:,55, 8) = (/ &
        & 0.99418e-05,0.14675e-04,0.21893e-04,0.33017e-04,0.50138e-04 /)
      kbo(:,56, 8) = (/ &
        & 0.78293e-05,0.11672e-04,0.17663e-04,0.26975e-04,0.41690e-04 /)
      kbo(:,57, 8) = (/ &
        & 0.61519e-05,0.92383e-05,0.14184e-04,0.21901e-04,0.34420e-04 /)
      kbo(:,58, 8) = (/ &
        & 0.48509e-05,0.73119e-05,0.11341e-04,0.17783e-04,0.28416e-04 /)
      kbo(:,59, 8) = (/ &
        & 0.41003e-05,0.62461e-05,0.98307e-05,0.15678e-04,0.25521e-04 /)
      kbo(:,13, 9) = (/ &
        & 0.31088e-01,0.30978e-01,0.31134e-01,0.31580e-01,0.32297e-01 /)
      kbo(:,14, 9) = (/ &
        & 0.26804e-01,0.26913e-01,0.27323e-01,0.28019e-01,0.28853e-01 /)
      kbo(:,15, 9) = (/ &
        & 0.23192e-01,0.23530e-01,0.24156e-01,0.24918e-01,0.25770e-01 /)
      kbo(:,16, 9) = (/ &
        & 0.20205e-01,0.20738e-01,0.21411e-01,0.22189e-01,0.23073e-01 /)
      kbo(:,17, 9) = (/ &
        & 0.17721e-01,0.18309e-01,0.19005e-01,0.19816e-01,0.20712e-01 /)
      kbo(:,18, 9) = (/ &
        & 0.15569e-01,0.16175e-01,0.16902e-01,0.17717e-01,0.18588e-01 /)
      kbo(:,19, 9) = (/ &
        & 0.13679e-01,0.14314e-01,0.15046e-01,0.15840e-01,0.16695e-01 /)
      kbo(:,20, 9) = (/ &
        & 0.12060e-01,0.12704e-01,0.13416e-01,0.14184e-01,0.14994e-01 /)
      kbo(:,21, 9) = (/ &
        & 0.10678e-01,0.11296e-01,0.11975e-01,0.12694e-01,0.13474e-01 /)
      kbo(:,22, 9) = (/ &
        & 0.95206e-02,0.10114e-01,0.10744e-01,0.11429e-01,0.12190e-01 /)
      kbo(:,23, 9) = (/ &
        & 0.85244e-02,0.90705e-02,0.96690e-02,0.10334e-01,0.11084e-01 /)
      kbo(:,24, 9) = (/ &
        & 0.76472e-02,0.81682e-02,0.87428e-02,0.93948e-02,0.10155e-01 /)
      kbo(:,25, 9) = (/ &
        & 0.68906e-02,0.73887e-02,0.79555e-02,0.86116e-02,0.93920e-02 /)
      kbo(:,26, 9) = (/ &
        & 0.62406e-02,0.67330e-02,0.73033e-02,0.79807e-02,0.87803e-02 /)
      kbo(:,27, 9) = (/ &
        & 0.56879e-02,0.61818e-02,0.67732e-02,0.74721e-02,0.82924e-02 /)
      kbo(:,28, 9) = (/ &
        & 0.52214e-02,0.57290e-02,0.63416e-02,0.70614e-02,0.79109e-02 /)
      kbo(:,29, 9) = (/ &
        & 0.48396e-02,0.53718e-02,0.60023e-02,0.67493e-02,0.76290e-02 /)
      kbo(:,30, 9) = (/ &
        & 0.45394e-02,0.50868e-02,0.57419e-02,0.65213e-02,0.74390e-02 /)
      kbo(:,31, 9) = (/ &
        & 0.42997e-02,0.48721e-02,0.55579e-02,0.63736e-02,0.73370e-02 /)
      kbo(:,32, 9) = (/ &
        & 0.41212e-02,0.47209e-02,0.54422e-02,0.62987e-02,0.73128e-02 /)
      kbo(:,33, 9) = (/ &
        & 0.39976e-02,0.46295e-02,0.53893e-02,0.62949e-02,0.73658e-02 /)
      kbo(:,34, 9) = (/ &
        & 0.39007e-02,0.45672e-02,0.53672e-02,0.63167e-02,0.74374e-02 /)
      kbo(:,35, 9) = (/ &
        & 0.37869e-02,0.44770e-02,0.53019e-02,0.62849e-02,0.74424e-02 /)
      kbo(:,36, 9) = (/ &
        & 0.36393e-02,0.43376e-02,0.51746e-02,0.61726e-02,0.73435e-02 /)
      kbo(:,37, 9) = (/ &
        & 0.34235e-02,0.41098e-02,0.49353e-02,0.59226e-02,0.70781e-02 /)
      kbo(:,38, 9) = (/ &
        & 0.32247e-02,0.38981e-02,0.47125e-02,0.56849e-02,0.68251e-02 /)
      kbo(:,39, 9) = (/ &
        & 0.30456e-02,0.37107e-02,0.45116e-02,0.54683e-02,0.65906e-02 /)
      kbo(:,40, 9) = (/ &
        & 0.28232e-02,0.34654e-02,0.42389e-02,0.51610e-02,0.62484e-02 /)
      kbo(:,41, 9) = (/ &
        & 0.26119e-02,0.32290e-02,0.39730e-02,0.48613e-02,0.59121e-02 /)
      kbo(:,42, 9) = (/ &
        & 0.24180e-02,0.30088e-02,0.37246e-02,0.45813e-02,0.55929e-02 /)
      kbo(:,43, 9) = (/ &
        & 0.22093e-02,0.27691e-02,0.34494e-02,0.42630e-02,0.52317e-02 /)
      kbo(:,44, 9) = (/ &
        & 0.20033e-02,0.25304e-02,0.31741e-02,0.39439e-02,0.48637e-02 /)
      kbo(:,45, 9) = (/ &
        & 0.18130e-02,0.23086e-02,0.29181e-02,0.36487e-02,0.45175e-02 /)
      kbo(:,46, 9) = (/ &
        & 0.16283e-02,0.20910e-02,0.26646e-02,0.33526e-02,0.41695e-02 /)
      kbo(:,47, 9) = (/ &
        & 0.14435e-02,0.18702e-02,0.24020e-02,0.30439e-02,0.38103e-02 /)
      kbo(:,48, 9) = (/ &
        & 0.12773e-02,0.16671e-02,0.21576e-02,0.27587e-02,0.34731e-02 /)
      kbo(:,49, 9) = (/ &
        & 0.11238e-02,0.14806e-02,0.19320e-02,0.24920e-02,0.31602e-02 /)
      kbo(:,50, 9) = (/ &
        & 0.99065e-03,0.13211e-02,0.17354e-02,0.22582e-02,0.28857e-02 /)
      kbo(:,51, 9) = (/ &
        & 0.87220e-03,0.11790e-02,0.15607e-02,0.20453e-02,0.26367e-02 /)
      kbo(:,52, 9) = (/ &
        & 0.76443e-03,0.10482e-02,0.13992e-02,0.18469e-02,0.24023e-02 /)
      kbo(:,53, 9) = (/ &
        & 0.66506e-03,0.92645e-03,0.12548e-02,0.16624e-02,0.21789e-02 /)
      kbo(:,54, 9) = (/ &
        & 0.58147e-03,0.82449e-03,0.11302e-02,0.15093e-02,0.19886e-02 /)
      kbo(:,55, 9) = (/ &
        & 0.50762e-03,0.73235e-03,0.10182e-02,0.13732e-02,0.18200e-02 /)
      kbo(:,56, 9) = (/ &
        & 0.44063e-03,0.64710e-03,0.91345e-03,0.12471e-02,0.16632e-02 /)
      kbo(:,57, 9) = (/ &
        & 0.37891e-03,0.56859e-03,0.81680e-03,0.11290e-02,0.15165e-02 /)
      kbo(:,58, 9) = (/ &
        & 0.32563e-03,0.50022e-03,0.73037e-03,0.10236e-02,0.13873e-02 /)
      kbo(:,59, 9) = (/ &
        & 0.30307e-03,0.47208e-03,0.69548e-03,0.98198e-03,0.13371e-02 /)
      kbo(:,13,10) = (/ &
        & 0.13405e+00,0.13208e+00,0.13012e+00,0.12819e+00,0.12637e+00 /)
      kbo(:,14,10) = (/ &
        & 0.11726e+00,0.11549e+00,0.11376e+00,0.11219e+00,0.11171e+00 /)
      kbo(:,15,10) = (/ &
        & 0.10125e+00,0.99749e-01,0.98394e-01,0.98385e-01,0.99981e-01 /)
      kbo(:,16,10) = (/ &
        & 0.86553e-01,0.85383e-01,0.85602e-01,0.87440e-01,0.89929e-01 /)
      kbo(:,17,10) = (/ &
        & 0.73963e-01,0.74028e-01,0.75744e-01,0.77969e-01,0.80306e-01 /)
      kbo(:,18,10) = (/ &
        & 0.64249e-01,0.65620e-01,0.67504e-01,0.69584e-01,0.72235e-01 /)
      kbo(:,19,10) = (/ &
        & 0.56934e-01,0.58613e-01,0.60462e-01,0.62855e-01,0.65899e-01 /)
      kbo(:,20,10) = (/ &
        & 0.50721e-01,0.52418e-01,0.54615e-01,0.57565e-01,0.61049e-01 /)
      kbo(:,21,10) = (/ &
        & 0.45027e-01,0.47161e-01,0.49911e-01,0.53249e-01,0.56950e-01 /)
      kbo(:,22,10) = (/ &
        & 0.40301e-01,0.42891e-01,0.46164e-01,0.49801e-01,0.53839e-01 /)
      kbo(:,23,10) = (/ &
        & 0.36438e-01,0.39487e-01,0.43011e-01,0.46965e-01,0.50969e-01 /)
      kbo(:,24,10) = (/ &
        & 0.33455e-01,0.36675e-01,0.40451e-01,0.44369e-01,0.48399e-01 /)
      kbo(:,25,10) = (/ &
        & 0.31038e-01,0.34461e-01,0.38146e-01,0.42075e-01,0.46138e-01 /)
      kbo(:,26,10) = (/ &
        & 0.29184e-01,0.32533e-01,0.36194e-01,0.40134e-01,0.44371e-01 /)
      kbo(:,27,10) = (/ &
        & 0.27607e-01,0.30907e-01,0.34540e-01,0.38584e-01,0.43101e-01 /)
      kbo(:,28,10) = (/ &
        & 0.26262e-01,0.29536e-01,0.33259e-01,0.37529e-01,0.42311e-01 /)
      kbo(:,29,10) = (/ &
        & 0.25199e-01,0.28472e-01,0.32405e-01,0.36927e-01,0.42052e-01 /)
      kbo(:,30,10) = (/ &
        & 0.24317e-01,0.27783e-01,0.31948e-01,0.36772e-01,0.42176e-01 /)
      kbo(:,31,10) = (/ &
        & 0.23777e-01,0.27457e-01,0.31879e-01,0.37001e-01,0.42663e-01 /)
      kbo(:,32,10) = (/ &
        & 0.23540e-01,0.27481e-01,0.32177e-01,0.37596e-01,0.43567e-01 /)
      kbo(:,33,10) = (/ &
        & 0.23597e-01,0.27797e-01,0.32792e-01,0.38465e-01,0.44641e-01 /)
      kbo(:,34,10) = (/ &
        & 0.23769e-01,0.28231e-01,0.33430e-01,0.39373e-01,0.45740e-01 /)
      kbo(:,35,10) = (/ &
        & 0.23751e-01,0.28376e-01,0.33764e-01,0.39814e-01,0.46255e-01 /)
      kbo(:,36,10) = (/ &
        & 0.23409e-01,0.28117e-01,0.33564e-01,0.39651e-01,0.46138e-01 /)
      kbo(:,37,10) = (/ &
        & 0.22508e-01,0.27169e-01,0.32556e-01,0.38592e-01,0.45071e-01 /)
      kbo(:,38,10) = (/ &
        & 0.21655e-01,0.26262e-01,0.31543e-01,0.37540e-01,0.43984e-01 /)
      kbo(:,39,10) = (/ &
        & 0.20895e-01,0.25391e-01,0.30600e-01,0.36519e-01,0.42890e-01 /)
      kbo(:,40,10) = (/ &
        & 0.19794e-01,0.24108e-01,0.29157e-01,0.34891e-01,0.41215e-01 /)
      kbo(:,41,10) = (/ &
        & 0.18688e-01,0.22822e-01,0.27713e-01,0.33302e-01,0.39460e-01 /)
      kbo(:,42,10) = (/ &
        & 0.17627e-01,0.21623e-01,0.26302e-01,0.31747e-01,0.37731e-01 /)
      kbo(:,43,10) = (/ &
        & 0.16446e-01,0.20270e-01,0.24738e-01,0.29940e-01,0.35800e-01 /)
      kbo(:,44,10) = (/ &
        & 0.15234e-01,0.18876e-01,0.23100e-01,0.28072e-01,0.33725e-01 /)
      kbo(:,45,10) = (/ &
        & 0.14095e-01,0.17542e-01,0.21553e-01,0.26276e-01,0.31735e-01 /)
      kbo(:,46,10) = (/ &
        & 0.12980e-01,0.16215e-01,0.20030e-01,0.24474e-01,0.29695e-01 /)
      kbo(:,47,10) = (/ &
        & 0.11800e-01,0.14839e-01,0.18423e-01,0.22582e-01,0.27493e-01 /)
      kbo(:,48,10) = (/ &
        & 0.10669e-01,0.13547e-01,0.16901e-01,0.20822e-01,0.25431e-01 /)
      kbo(:,49,10) = (/ &
        & 0.96515e-02,0.12347e-01,0.15476e-01,0.19181e-01,0.23474e-01 /)
      kbo(:,50,10) = (/ &
        & 0.87302e-02,0.11282e-01,0.14230e-01,0.17719e-01,0.21773e-01 /)
      kbo(:,51,10) = (/ &
        & 0.78879e-02,0.10297e-01,0.13106e-01,0.16387e-01,0.20218e-01 /)
      kbo(:,52,10) = (/ &
        & 0.71141e-02,0.93631e-02,0.12059e-01,0.15140e-01,0.18761e-01 /)
      kbo(:,53,10) = (/ &
        & 0.64033e-02,0.84706e-02,0.11019e-01,0.13962e-01,0.17391e-01 /)
      kbo(:,54,10) = (/ &
        & 0.58003e-02,0.77325e-02,0.10121e-01,0.12913e-01,0.16185e-01 /)
      kbo(:,55,10) = (/ &
        & 0.52567e-02,0.70672e-02,0.93006e-02,0.11949e-01,0.15064e-01 /)
      kbo(:,56,10) = (/ &
        & 0.47304e-02,0.64466e-02,0.85460e-02,0.11037e-01,0.13988e-01 /)
      kbo(:,57,10) = (/ &
        & 0.42280e-02,0.58745e-02,0.78453e-02,0.10192e-01,0.12992e-01 /)
      kbo(:,58,10) = (/ &
        & 0.37744e-02,0.53584e-02,0.72089e-02,0.94309e-02,0.12101e-01 /)
      kbo(:,59,10) = (/ &
        & 0.36027e-02,0.51588e-02,0.69694e-02,0.91382e-02,0.11759e-01 /)
      kbo(:,13,11) = (/ &
        & 0.24636e+00,0.24379e+00,0.24122e+00,0.23863e+00,0.23598e+00 /)
      kbo(:,14,11) = (/ &
        & 0.22272e+00,0.22032e+00,0.21794e+00,0.21559e+00,0.21334e+00 /)
      kbo(:,15,11) = (/ &
        & 0.19844e+00,0.19619e+00,0.19411e+00,0.19222e+00,0.19047e+00 /)
      kbo(:,16,11) = (/ &
        & 0.17439e+00,0.17254e+00,0.17092e+00,0.16946e+00,0.16916e+00 /)
      kbo(:,17,11) = (/ &
        & 0.15164e+00,0.15027e+00,0.14912e+00,0.14939e+00,0.15176e+00 /)
      kbo(:,18,11) = (/ &
        & 0.13063e+00,0.12971e+00,0.13029e+00,0.13302e+00,0.13748e+00 /)
      kbo(:,19,11) = (/ &
        & 0.11203e+00,0.11247e+00,0.11508e+00,0.11959e+00,0.12521e+00 /)
      kbo(:,20,11) = (/ &
        & 0.96916e-01,0.99041e-01,0.10318e+00,0.10837e+00,0.11414e+00 /)
      kbo(:,21,11) = (/ &
        & 0.85382e-01,0.88824e-01,0.93367e-01,0.98603e-01,0.10483e+00 /)
      kbo(:,22,11) = (/ &
        & 0.76943e-01,0.80844e-01,0.85377e-01,0.90964e-01,0.97503e-01 /)
      kbo(:,23,11) = (/ &
        & 0.70041e-01,0.74136e-01,0.79065e-01,0.84905e-01,0.92247e-01 /)
      kbo(:,24,11) = (/ &
        & 0.64133e-01,0.68708e-01,0.74135e-01,0.80762e-01,0.88658e-01 /)
      kbo(:,25,11) = (/ &
        & 0.59352e-01,0.64474e-01,0.70718e-01,0.78064e-01,0.86394e-01 /)
      kbo(:,26,11) = (/ &
        & 0.55652e-01,0.61613e-01,0.68607e-01,0.76451e-01,0.85230e-01 /)
      kbo(:,27,11) = (/ &
        & 0.53058e-01,0.59792e-01,0.67298e-01,0.75623e-01,0.84830e-01 /)
      kbo(:,28,11) = (/ &
        & 0.51454e-01,0.58747e-01,0.66709e-01,0.75478e-01,0.85111e-01 /)
      kbo(:,29,11) = (/ &
        & 0.50601e-01,0.58412e-01,0.66813e-01,0.76014e-01,0.86051e-01 /)
      kbo(:,30,11) = (/ &
        & 0.50412e-01,0.58677e-01,0.67503e-01,0.77079e-01,0.87490e-01 /)
      kbo(:,31,11) = (/ &
        & 0.50833e-01,0.59491e-01,0.68713e-01,0.78659e-01,0.89405e-01 /)
      kbo(:,32,11) = (/ &
        & 0.51770e-01,0.60792e-01,0.70497e-01,0.80769e-01,0.91778e-01 /)
      kbo(:,33,11) = (/ &
        & 0.53128e-01,0.62590e-01,0.72506e-01,0.83033e-01,0.94354e-01 /)
      kbo(:,34,11) = (/ &
        & 0.54518e-01,0.64238e-01,0.74390e-01,0.85011e-01,0.96530e-01 /)
      kbo(:,35,11) = (/ &
        & 0.55323e-01,0.65129e-01,0.75324e-01,0.86085e-01,0.97742e-01 /)
      kbo(:,36,11) = (/ &
        & 0.55103e-01,0.64989e-01,0.75282e-01,0.86060e-01,0.97722e-01 /)
      kbo(:,37,11) = (/ &
        & 0.53513e-01,0.63398e-01,0.73617e-01,0.84326e-01,0.95934e-01 /)
      kbo(:,38,11) = (/ &
        & 0.51839e-01,0.61729e-01,0.71975e-01,0.82585e-01,0.94078e-01 /)
      kbo(:,39,11) = (/ &
        & 0.50239e-01,0.60161e-01,0.70354e-01,0.80923e-01,0.92345e-01 /)
      kbo(:,40,11) = (/ &
        & 0.47749e-01,0.57519e-01,0.67663e-01,0.78238e-01,0.89341e-01 /)
      kbo(:,41,11) = (/ &
        & 0.45220e-01,0.54835e-01,0.64881e-01,0.75369e-01,0.86308e-01 /)
      kbo(:,42,11) = (/ &
        & 0.42768e-01,0.52225e-01,0.62107e-01,0.72467e-01,0.83297e-01 /)
      kbo(:,43,11) = (/ &
        & 0.39884e-01,0.49090e-01,0.58932e-01,0.69072e-01,0.79690e-01 /)
      kbo(:,44,11) = (/ &
        & 0.36935e-01,0.45822e-01,0.55523e-01,0.65525e-01,0.76019e-01 /)
      kbo(:,45,11) = (/ &
        & 0.34132e-01,0.42684e-01,0.52151e-01,0.62095e-01,0.72392e-01 /)
      kbo(:,46,11) = (/ &
        & 0.31296e-01,0.39456e-01,0.48596e-01,0.58446e-01,0.68612e-01 /)
      kbo(:,47,11) = (/ &
        & 0.28352e-01,0.35994e-01,0.44764e-01,0.54432e-01,0.64443e-01 /)
      kbo(:,48,11) = (/ &
        & 0.25659e-01,0.32738e-01,0.41113e-01,0.50437e-01,0.60364e-01 /)
      kbo(:,49,11) = (/ &
        & 0.23119e-01,0.29700e-01,0.37617e-01,0.46554e-01,0.56334e-01 /)
      kbo(:,50,11) = (/ &
        & 0.20913e-01,0.27063e-01,0.34504e-01,0.43055e-01,0.52582e-01 /)
      kbo(:,51,11) = (/ &
        & 0.18909e-01,0.24701e-01,0.31626e-01,0.39797e-01,0.48997e-01 /)
      kbo(:,52,11) = (/ &
        & 0.17085e-01,0.22478e-01,0.28924e-01,0.36689e-01,0.45522e-01 /)
      kbo(:,53,11) = (/ &
        & 0.15363e-01,0.20405e-01,0.26432e-01,0.33725e-01,0.42180e-01 /)
      kbo(:,54,11) = (/ &
        & 0.13901e-01,0.18604e-01,0.24309e-01,0.31149e-01,0.39236e-01 /)
      kbo(:,55,11) = (/ &
        & 0.12627e-01,0.16988e-01,0.22381e-01,0.28834e-01,0.36535e-01 /)
      kbo(:,56,11) = (/ &
        & 0.11410e-01,0.15484e-01,0.20536e-01,0.26668e-01,0.33955e-01 /)
      kbo(:,57,11) = (/ &
        & 0.10296e-01,0.14074e-01,0.18805e-01,0.24610e-01,0.31477e-01 /)
      kbo(:,58,11) = (/ &
        & 0.93246e-02,0.12835e-01,0.17266e-01,0.22752e-01,0.29238e-01 /)
      kbo(:,59,11) = (/ &
        & 0.89562e-02,0.12359e-01,0.16676e-01,0.22030e-01,0.28380e-01 /)
      kbo(:,13,12) = (/ &
        & 0.46920e+00,0.46679e+00,0.46431e+00,0.46162e+00,0.45841e+00 /)
      kbo(:,14,12) = (/ &
        & 0.44978e+00,0.44747e+00,0.44532e+00,0.44273e+00,0.44032e+00 /)
      kbo(:,15,12) = (/ &
        & 0.42273e+00,0.42112e+00,0.41952e+00,0.41793e+00,0.41621e+00 /)
      kbo(:,16,12) = (/ &
        & 0.39050e+00,0.38973e+00,0.38909e+00,0.38861e+00,0.38845e+00 /)
      kbo(:,17,12) = (/ &
        & 0.35567e+00,0.35584e+00,0.35648e+00,0.35743e+00,0.35846e+00 /)
      kbo(:,18,12) = (/ &
        & 0.32023e+00,0.32164e+00,0.32356e+00,0.32582e+00,0.32854e+00 /)
      kbo(:,19,12) = (/ &
        & 0.28599e+00,0.28851e+00,0.29173e+00,0.29552e+00,0.30048e+00 /)
      kbo(:,20,12) = (/ &
        & 0.25381e+00,0.25750e+00,0.26208e+00,0.26822e+00,0.27683e+00 /)
      kbo(:,21,12) = (/ &
        & 0.22440e+00,0.22938e+00,0.23617e+00,0.24559e+00,0.25713e+00 /)
      kbo(:,22,12) = (/ &
        & 0.19852e+00,0.20554e+00,0.21550e+00,0.22788e+00,0.24207e+00 /)
      kbo(:,23,12) = (/ &
        & 0.17693e+00,0.18660e+00,0.19922e+00,0.21410e+00,0.23064e+00 /)
      kbo(:,24,12) = (/ &
        & 0.16009e+00,0.17209e+00,0.18673e+00,0.20389e+00,0.22257e+00 /)
      kbo(:,25,12) = (/ &
        & 0.14745e+00,0.16127e+00,0.17793e+00,0.19685e+00,0.21752e+00 /)
      kbo(:,26,12) = (/ &
        & 0.13842e+00,0.15401e+00,0.17237e+00,0.19313e+00,0.21550e+00 /)
      kbo(:,27,12) = (/ &
        & 0.13240e+00,0.14962e+00,0.16961e+00,0.19199e+00,0.21568e+00 /)
      kbo(:,28,12) = (/ &
        & 0.12889e+00,0.14761e+00,0.16917e+00,0.19286e+00,0.21743e+00 /)
      kbo(:,29,12) = (/ &
        & 0.12765e+00,0.14781e+00,0.17068e+00,0.19527e+00,0.22046e+00 /)
      kbo(:,30,12) = (/ &
        & 0.12821e+00,0.14964e+00,0.17352e+00,0.19873e+00,0.22436e+00 /)
      kbo(:,31,12) = (/ &
        & 0.13031e+00,0.15282e+00,0.17742e+00,0.20308e+00,0.22902e+00 /)
      kbo(:,32,12) = (/ &
        & 0.13354e+00,0.15691e+00,0.18189e+00,0.20791e+00,0.23394e+00 /)
      kbo(:,33,12) = (/ &
        & 0.13759e+00,0.16158e+00,0.18710e+00,0.21336e+00,0.23934e+00 /)
      kbo(:,34,12) = (/ &
        & 0.14143e+00,0.16592e+00,0.19181e+00,0.21830e+00,0.24425e+00 /)
      kbo(:,35,12) = (/ &
        & 0.14328e+00,0.16813e+00,0.19433e+00,0.22092e+00,0.24688e+00 /)
      kbo(:,36,12) = (/ &
        & 0.14288e+00,0.16783e+00,0.19405e+00,0.22076e+00,0.24684e+00 /)
      kbo(:,37,12) = (/ &
        & 0.13900e+00,0.16377e+00,0.19000e+00,0.21677e+00,0.24302e+00 /)
      kbo(:,38,12) = (/ &
        & 0.13517e+00,0.15969e+00,0.18575e+00,0.21259e+00,0.23902e+00 /)
      kbo(:,39,12) = (/ &
        & 0.13148e+00,0.15568e+00,0.18162e+00,0.20849e+00,0.23507e+00 /)
      kbo(:,40,12) = (/ &
        & 0.12553e+00,0.14932e+00,0.17494e+00,0.20171e+00,0.22853e+00 /)
      kbo(:,41,12) = (/ &
        & 0.11952e+00,0.14280e+00,0.16803e+00,0.19459e+00,0.22156e+00 /)
      kbo(:,42,12) = (/ &
        & 0.11373e+00,0.13636e+00,0.16129e+00,0.18763e+00,0.21464e+00 /)
      kbo(:,43,12) = (/ &
        & 0.10701e+00,0.12880e+00,0.15312e+00,0.17916e+00,0.20617e+00 /)
      kbo(:,44,12) = (/ &
        & 0.10010e+00,0.12097e+00,0.14449e+00,0.17006e+00,0.19689e+00 /)
      kbo(:,45,12) = (/ &
        & 0.93559e-01,0.11347e+00,0.13614e+00,0.16117e+00,0.18764e+00 /)
      kbo(:,46,12) = (/ &
        & 0.86985e-01,0.10587e+00,0.12759e+00,0.15183e+00,0.17790e+00 /)
      kbo(:,47,12) = (/ &
        & 0.79918e-01,0.97829e-01,0.11842e+00,0.14172e+00,0.16718e+00 /)
      kbo(:,48,12) = (/ &
        & 0.73127e-01,0.90284e-01,0.10972e+00,0.13198e+00,0.15666e+00 /)
      kbo(:,49,12) = (/ &
        & 0.66713e-01,0.83137e-01,0.10149e+00,0.12264e+00,0.14642e+00 /)
      kbo(:,50,12) = (/ &
        & 0.61017e-01,0.76653e-01,0.94210e-01,0.11429e+00,0.13713e+00 /)
      kbo(:,51,12) = (/ &
        & 0.55806e-01,0.70628e-01,0.87552e-01,0.10658e+00,0.12844e+00 /)
      kbo(:,52,12) = (/ &
        & 0.50954e-01,0.64939e-01,0.81159e-01,0.99264e-01,0.12011e+00 /)
      kbo(:,53,12) = (/ &
        & 0.46354e-01,0.59512e-01,0.74951e-01,0.92338e-01,0.11214e+00 /)
      kbo(:,54,12) = (/ &
        & 0.42433e-01,0.54851e-01,0.69504e-01,0.86317e-01,0.10517e+00 /)
      kbo(:,55,12) = (/ &
        & 0.38912e-01,0.50588e-01,0.64547e-01,0.80719e-01,0.98779e-01 /)
      kbo(:,56,12) = (/ &
        & 0.35756e-01,0.46572e-01,0.59794e-01,0.75289e-01,0.92719e-01 /)
      kbo(:,57,12) = (/ &
        & 0.32896e-01,0.42811e-01,0.55328e-01,0.70070e-01,0.86950e-01 /)
      kbo(:,58,12) = (/ &
        & 0.30447e-01,0.39485e-01,0.51269e-01,0.65351e-01,0.81643e-01 /)
      kbo(:,59,12) = (/ &
        & 0.29531e-01,0.38222e-01,0.49696e-01,0.63514e-01,0.79546e-01 /)
      kbo(:,13,13) = (/ &
        & 0.87498e+00,0.87414e+00,0.87195e+00,0.86869e+00,0.86437e+00 /)
      kbo(:,14,13) = (/ &
        & 0.90060e+00,0.89974e+00,0.89734e+00,0.89423e+00,0.88971e+00 /)
      kbo(:,15,13) = (/ &
        & 0.91305e+00,0.91211e+00,0.91072e+00,0.90792e+00,0.90457e+00 /)
      kbo(:,16,13) = (/ &
        & 0.91218e+00,0.91265e+00,0.91216e+00,0.91150e+00,0.90908e+00 /)
      kbo(:,17,13) = (/ &
        & 0.89877e+00,0.90187e+00,0.90414e+00,0.90531e+00,0.90588e+00 /)
      kbo(:,18,13) = (/ &
        & 0.87718e+00,0.88256e+00,0.88815e+00,0.89271e+00,0.89636e+00 /)
      kbo(:,19,13) = (/ &
        & 0.84784e+00,0.85815e+00,0.86718e+00,0.87552e+00,0.88267e+00 /)
      kbo(:,20,13) = (/ &
        & 0.81552e+00,0.83012e+00,0.84379e+00,0.85649e+00,0.86736e+00 /)
      kbo(:,21,13) = (/ &
        & 0.78216e+00,0.80141e+00,0.82018e+00,0.83708e+00,0.85197e+00 /)
      kbo(:,22,13) = (/ &
        & 0.75119e+00,0.77590e+00,0.79904e+00,0.81994e+00,0.83870e+00 /)
      kbo(:,23,13) = (/ &
        & 0.72390e+00,0.75373e+00,0.78079e+00,0.80579e+00,0.82760e+00 /)
      kbo(:,24,13) = (/ &
        & 0.70145e+00,0.73523e+00,0.76640e+00,0.79456e+00,0.81899e+00 /)
      kbo(:,25,13) = (/ &
        & 0.68406e+00,0.72159e+00,0.75604e+00,0.78669e+00,0.81321e+00 /)
      kbo(:,26,13) = (/ &
        & 0.67200e+00,0.71253e+00,0.74968e+00,0.78214e+00,0.81015e+00 /)
      kbo(:,27,13) = (/ &
        & 0.66447e+00,0.70740e+00,0.74639e+00,0.77996e+00,0.80903e+00 /)
      kbo(:,28,13) = (/ &
        & 0.66095e+00,0.70586e+00,0.74565e+00,0.77995e+00,0.80973e+00 /)
      kbo(:,29,13) = (/ &
        & 0.66138e+00,0.70727e+00,0.74725e+00,0.78204e+00,0.81205e+00 /)
      kbo(:,30,13) = (/ &
        & 0.66437e+00,0.71055e+00,0.75066e+00,0.78572e+00,0.81538e+00 /)
      kbo(:,31,13) = (/ &
        & 0.66969e+00,0.71558e+00,0.75561e+00,0.79049e+00,0.81954e+00 /)
      kbo(:,32,13) = (/ &
        & 0.67664e+00,0.72206e+00,0.76182e+00,0.79609e+00,0.82431e+00 /)
      kbo(:,33,13) = (/ &
        & 0.68486e+00,0.72960e+00,0.76872e+00,0.80214e+00,0.82949e+00 /)
      kbo(:,34,13) = (/ &
        & 0.69234e+00,0.73624e+00,0.77485e+00,0.80729e+00,0.83397e+00 /)
      kbo(:,35,13) = (/ &
        & 0.69580e+00,0.73958e+00,0.77791e+00,0.80990e+00,0.83618e+00 /)
      kbo(:,36,13) = (/ &
        & 0.69461e+00,0.73878e+00,0.77738e+00,0.80959e+00,0.83608e+00 /)
      kbo(:,37,13) = (/ &
        & 0.68652e+00,0.73194e+00,0.77165e+00,0.80500e+00,0.83229e+00 /)
      kbo(:,38,13) = (/ &
        & 0.67804e+00,0.72484e+00,0.76560e+00,0.80009e+00,0.82834e+00 /)
      kbo(:,39,13) = (/ &
        & 0.66970e+00,0.71778e+00,0.75963e+00,0.79504e+00,0.82429e+00 /)
      kbo(:,40,13) = (/ &
        & 0.65605e+00,0.70590e+00,0.74946e+00,0.78658e+00,0.81742e+00 /)
      kbo(:,41,13) = (/ &
        & 0.64137e+00,0.69306e+00,0.73837e+00,0.77717e+00,0.80985e+00 /)
      kbo(:,42,13) = (/ &
        & 0.62638e+00,0.67987e+00,0.72699e+00,0.76756e+00,0.80186e+00 /)
      kbo(:,43,13) = (/ &
        & 0.60761e+00,0.66320e+00,0.71239e+00,0.75526e+00,0.79130e+00 /)
      kbo(:,44,13) = (/ &
        & 0.58682e+00,0.64468e+00,0.69616e+00,0.74131e+00,0.77948e+00 /)
      kbo(:,45,13) = (/ &
        & 0.56554e+00,0.62545e+00,0.67917e+00,0.72630e+00,0.76697e+00 /)
      kbo(:,46,13) = (/ &
        & 0.54212e+00,0.60419e+00,0.66020e+00,0.70997e+00,0.75300e+00 /)
      kbo(:,47,13) = (/ &
        & 0.51537e+00,0.57955e+00,0.63814e+00,0.69060e+00,0.73632e+00 /)
      kbo(:,48,13) = (/ &
        & 0.48823e+00,0.55406e+00,0.61515e+00,0.67007e+00,0.71851e+00 /)
      kbo(:,49,13) = (/ &
        & 0.46082e+00,0.52769e+00,0.59101e+00,0.64854e+00,0.69978e+00 /)
      kbo(:,50,13) = (/ &
        & 0.43478e+00,0.50249e+00,0.56761e+00,0.62745e+00,0.68113e+00 /)
      kbo(:,51,13) = (/ &
        & 0.40951e+00,0.47777e+00,0.54418e+00,0.60613e+00,0.66212e+00 /)
      kbo(:,52,13) = (/ &
        & 0.38439e+00,0.45288e+00,0.52007e+00,0.58405e+00,0.64238e+00 /)
      kbo(:,53,13) = (/ &
        & 0.35936e+00,0.42773e+00,0.49564e+00,0.56121e+00,0.62177e+00 /)
      kbo(:,54,13) = (/ &
        & 0.33659e+00,0.40461e+00,0.47296e+00,0.53959e+00,0.60208e+00 /)
      kbo(:,55,13) = (/ &
        & 0.31505e+00,0.38259e+00,0.45108e+00,0.51845e+00,0.58256e+00 /)
      kbo(:,56,13) = (/ &
        & 0.29381e+00,0.36074e+00,0.42910e+00,0.49702e+00,0.56263e+00 /)
      kbo(:,57,13) = (/ &
        & 0.27284e+00,0.33897e+00,0.40701e+00,0.47542e+00,0.54206e+00 /)
      kbo(:,58,13) = (/ &
        & 0.25321e+00,0.31859e+00,0.38622e+00,0.45477e+00,0.52205e+00 /)
      kbo(:,59,13) = (/ &
        & 0.24543e+00,0.31049e+00,0.37793e+00,0.44646e+00,0.51396e+00 /)
      kbo(:,13,14) = (/ &
        & 0.17373e+01,0.17393e+01,0.17383e+01,0.17344e+01,0.17279e+01 /)
      kbo(:,14,14) = (/ &
        & 0.18339e+01,0.18343e+01,0.18325e+01,0.18267e+01,0.18189e+01 /)
      kbo(:,15,14) = (/ &
        & 0.19299e+01,0.19296e+01,0.19248e+01,0.19184e+01,0.19080e+01 /)
      kbo(:,16,14) = (/ &
        & 0.20259e+01,0.20224e+01,0.20169e+01,0.20066e+01,0.19945e+01 /)
      kbo(:,17,14) = (/ &
        & 0.21175e+01,0.21127e+01,0.21039e+01,0.20921e+01,0.20768e+01 /)
      kbo(:,18,14) = (/ &
        & 0.22042e+01,0.21972e+01,0.21859e+01,0.21721e+01,0.21537e+01 /)
      kbo(:,19,14) = (/ &
        & 0.22848e+01,0.22747e+01,0.22622e+01,0.22448e+01,0.22240e+01 /)
      kbo(:,20,14) = (/ &
        & 0.23560e+01,0.23462e+01,0.23302e+01,0.23098e+01,0.22867e+01 /)
      kbo(:,21,14) = (/ &
        & 0.24183e+01,0.24082e+01,0.23905e+01,0.23680e+01,0.23418e+01 /)
      kbo(:,22,14) = (/ &
        & 0.24717e+01,0.24598e+01,0.24413e+01,0.24169e+01,0.23867e+01 /)
      kbo(:,23,14) = (/ &
        & 0.25171e+01,0.25034e+01,0.24840e+01,0.24570e+01,0.24242e+01 /)
      kbo(:,24,14) = (/ &
        & 0.25547e+01,0.25403e+01,0.25194e+01,0.24898e+01,0.24547e+01 /)
      kbo(:,25,14) = (/ &
        & 0.25855e+01,0.25703e+01,0.25468e+01,0.25156e+01,0.24784e+01 /)
      kbo(:,26,14) = (/ &
        & 0.26110e+01,0.25944e+01,0.25683e+01,0.25352e+01,0.24957e+01 /)
      kbo(:,27,14) = (/ &
        & 0.26319e+01,0.26130e+01,0.25843e+01,0.25495e+01,0.25077e+01 /)
      kbo(:,28,14) = (/ &
        & 0.26480e+01,0.26264e+01,0.25959e+01,0.25590e+01,0.25150e+01 /)
      kbo(:,29,14) = (/ &
        & 0.26603e+01,0.26355e+01,0.26036e+01,0.25644e+01,0.25186e+01 /)
      kbo(:,30,14) = (/ &
        & 0.26690e+01,0.26417e+01,0.26076e+01,0.25661e+01,0.25188e+01 /)
      kbo(:,31,14) = (/ &
        & 0.26742e+01,0.26446e+01,0.26086e+01,0.25648e+01,0.25163e+01 /)
      kbo(:,32,14) = (/ &
        & 0.26768e+01,0.26452e+01,0.26068e+01,0.25609e+01,0.25113e+01 /)
      kbo(:,33,14) = (/ &
        & 0.26771e+01,0.26434e+01,0.26028e+01,0.25551e+01,0.25044e+01 /)
      kbo(:,34,14) = (/ &
        & 0.26762e+01,0.26409e+01,0.25981e+01,0.25494e+01,0.24981e+01 /)
      kbo(:,35,14) = (/ &
        & 0.26773e+01,0.26407e+01,0.25970e+01,0.25475e+01,0.24957e+01 /)
      kbo(:,36,14) = (/ &
        & 0.26808e+01,0.26440e+01,0.25999e+01,0.25501e+01,0.24981e+01 /)
      kbo(:,37,14) = (/ &
        & 0.26888e+01,0.26526e+01,0.26095e+01,0.25599e+01,0.25079e+01 /)
      kbo(:,38,14) = (/ &
        & 0.26963e+01,0.26609e+01,0.26186e+01,0.25695e+01,0.25177e+01 /)
      kbo(:,39,14) = (/ &
        & 0.27030e+01,0.26686e+01,0.26272e+01,0.25787e+01,0.25269e+01 /)
      kbo(:,40,14) = (/ &
        & 0.27118e+01,0.26792e+01,0.26399e+01,0.25927e+01,0.25414e+01 /)
      kbo(:,41,14) = (/ &
        & 0.27201e+01,0.26898e+01,0.26520e+01,0.26068e+01,0.25561e+01 /)
      kbo(:,42,14) = (/ &
        & 0.27274e+01,0.27000e+01,0.26636e+01,0.26203e+01,0.25704e+01 /)
      kbo(:,43,14) = (/ &
        & 0.27341e+01,0.27108e+01,0.26767e+01,0.26357e+01,0.25871e+01 /)
      kbo(:,44,14) = (/ &
        & 0.27398e+01,0.27209e+01,0.26898e+01,0.26513e+01,0.26050e+01 /)
      kbo(:,45,14) = (/ &
        & 0.27435e+01,0.27298e+01,0.27021e+01,0.26655e+01,0.26220e+01 /)
      kbo(:,46,14) = (/ &
        & 0.27454e+01,0.27371e+01,0.27139e+01,0.26799e+01,0.26391e+01 /)
      kbo(:,47,14) = (/ &
        & 0.27460e+01,0.27424e+01,0.27253e+01,0.26950e+01,0.26569e+01 /)
      kbo(:,48,14) = (/ &
        & 0.27436e+01,0.27457e+01,0.27342e+01,0.27088e+01,0.26736e+01 /)
      kbo(:,49,14) = (/ &
        & 0.27370e+01,0.27470e+01,0.27411e+01,0.27207e+01,0.26888e+01 /)
      kbo(:,50,14) = (/ &
        & 0.27269e+01,0.27459e+01,0.27451e+01,0.27305e+01,0.27022e+01 /)
      kbo(:,51,14) = (/ &
        & 0.27139e+01,0.27424e+01,0.27470e+01,0.27377e+01,0.27140e+01 /)
      kbo(:,52,14) = (/ &
        & 0.26965e+01,0.27350e+01,0.27474e+01,0.27429e+01,0.27243e+01 /)
      kbo(:,53,14) = (/ &
        & 0.26758e+01,0.27241e+01,0.27457e+01,0.27461e+01,0.27331e+01 /)
      kbo(:,54,14) = (/ &
        & 0.26529e+01,0.27108e+01,0.27417e+01,0.27475e+01,0.27393e+01 /)
      kbo(:,55,14) = (/ &
        & 0.26271e+01,0.26955e+01,0.27349e+01,0.27476e+01,0.27437e+01 /)
      kbo(:,56,14) = (/ &
        & 0.25970e+01,0.26775e+01,0.27251e+01,0.27462e+01,0.27464e+01 /)
      kbo(:,57,14) = (/ &
        & 0.25617e+01,0.26559e+01,0.27125e+01,0.27426e+01,0.27477e+01 /)
      kbo(:,58,14) = (/ &
        & 0.25247e+01,0.26320e+01,0.26988e+01,0.27363e+01,0.27482e+01 /)
      kbo(:,59,14) = (/ &
        & 0.25089e+01,0.26212e+01,0.26923e+01,0.27333e+01,0.27480e+01 /)
      kbo(:,13,15) = (/ &
        & 0.36859e+01,0.36950e+01,0.36942e+01,0.36830e+01,0.36649e+01 /)
      kbo(:,14,15) = (/ &
        & 0.41563e+01,0.41556e+01,0.41430e+01,0.41233e+01,0.40913e+01 /)
      kbo(:,15,15) = (/ &
        & 0.46342e+01,0.46206e+01,0.45970e+01,0.45604e+01,0.45153e+01 /)
      kbo(:,16,15) = (/ &
        & 0.51044e+01,0.50788e+01,0.50384e+01,0.49882e+01,0.49250e+01 /)
      kbo(:,17,15) = (/ &
        & 0.55612e+01,0.55175e+01,0.54618e+01,0.53932e+01,0.53123e+01 /)
      kbo(:,18,15) = (/ &
        & 0.59883e+01,0.59323e+01,0.58578e+01,0.57682e+01,0.56700e+01 /)
      kbo(:,19,15) = (/ &
        & 0.63852e+01,0.63106e+01,0.62177e+01,0.61123e+01,0.59947e+01 /)
      kbo(:,20,15) = (/ &
        & 0.67473e+01,0.66496e+01,0.65407e+01,0.64159e+01,0.62789e+01 /)
      kbo(:,21,15) = (/ &
        & 0.70720e+01,0.69522e+01,0.68220e+01,0.66792e+01,0.65258e+01 /)
      kbo(:,22,15) = (/ &
        & 0.73512e+01,0.72082e+01,0.70565e+01,0.68942e+01,0.67258e+01 /)
      kbo(:,23,15) = (/ &
        & 0.75866e+01,0.74239e+01,0.72515e+01,0.70718e+01,0.68886e+01 /)
      kbo(:,24,15) = (/ &
        & 0.77818e+01,0.75993e+01,0.74076e+01,0.72128e+01,0.70154e+01 /)
      kbo(:,25,15) = (/ &
        & 0.79381e+01,0.77379e+01,0.75298e+01,0.73205e+01,0.71111e+01 /)
      kbo(:,26,15) = (/ &
        & 0.80556e+01,0.78384e+01,0.76185e+01,0.73961e+01,0.71755e+01 /)
      kbo(:,27,15) = (/ &
        & 0.81409e+01,0.79095e+01,0.76795e+01,0.74472e+01,0.72174e+01 /)
      kbo(:,28,15) = (/ &
        & 0.81987e+01,0.79569e+01,0.77176e+01,0.74766e+01,0.72412e+01 /)
      kbo(:,29,15) = (/ &
        & 0.82302e+01,0.79809e+01,0.77337e+01,0.74875e+01,0.72468e+01 /)
      kbo(:,30,15) = (/ &
        & 0.82419e+01,0.79875e+01,0.77343e+01,0.74825e+01,0.72390e+01 /)
      kbo(:,31,15) = (/ &
        & 0.82369e+01,0.79780e+01,0.77201e+01,0.74661e+01,0.72183e+01 /)
      kbo(:,32,15) = (/ &
        & 0.82187e+01,0.79550e+01,0.76944e+01,0.74386e+01,0.71874e+01 /)
      kbo(:,33,15) = (/ &
        & 0.81889e+01,0.79220e+01,0.76592e+01,0.74026e+01,0.71493e+01 /)
      kbo(:,34,15) = (/ &
        & 0.81602e+01,0.78912e+01,0.76262e+01,0.73693e+01,0.71134e+01 /)
      kbo(:,35,15) = (/ &
        & 0.81506e+01,0.78799e+01,0.76144e+01,0.73562e+01,0.70988e+01 /)
      kbo(:,36,15) = (/ &
        & 0.81664e+01,0.78930e+01,0.76263e+01,0.73664e+01,0.71072e+01 /)
      kbo(:,37,15) = (/ &
        & 0.82200e+01,0.79452e+01,0.76751e+01,0.74132e+01,0.71537e+01 /)
      kbo(:,38,15) = (/ &
        & 0.82730e+01,0.79962e+01,0.77251e+01,0.74606e+01,0.72002e+01 /)
      kbo(:,39,15) = (/ &
        & 0.83243e+01,0.80459e+01,0.77713e+01,0.75063e+01,0.72452e+01 /)
      kbo(:,40,15) = (/ &
        & 0.84027e+01,0.81225e+01,0.78456e+01,0.75775e+01,0.73152e+01 /)
      kbo(:,41,15) = (/ &
        & 0.84834e+01,0.82013e+01,0.79233e+01,0.76507e+01,0.73874e+01 /)
      kbo(:,42,15) = (/ &
        & 0.85638e+01,0.82794e+01,0.79999e+01,0.77248e+01,0.74594e+01 /)
      kbo(:,43,15) = (/ &
        & 0.86608e+01,0.83728e+01,0.80910e+01,0.78137e+01,0.75464e+01 /)
      kbo(:,44,15) = (/ &
        & 0.87658e+01,0.84741e+01,0.81903e+01,0.79102e+01,0.76390e+01 /)
      kbo(:,45,15) = (/ &
        & 0.88709e+01,0.85747e+01,0.82886e+01,0.80079e+01,0.77318e+01 /)
      kbo(:,46,15) = (/ &
        & 0.89828e+01,0.86839e+01,0.83945e+01,0.81115e+01,0.78321e+01 /)
      kbo(:,47,15) = (/ &
        & 0.91067e+01,0.88066e+01,0.85118e+01,0.82270e+01,0.79459e+01 /)
      kbo(:,48,15) = (/ &
        & 0.92318e+01,0.89292e+01,0.86312e+01,0.83427e+01,0.80595e+01 /)
      kbo(:,49,15) = (/ &
        & 0.93597e+01,0.90533e+01,0.87516e+01,0.84602e+01,0.81749e+01 /)
      kbo(:,50,15) = (/ &
        & 0.94828e+01,0.91681e+01,0.88667e+01,0.85700e+01,0.82833e+01 /)
      kbo(:,51,15) = (/ &
        & 0.96031e+01,0.92821e+01,0.89785e+01,0.86778e+01,0.83878e+01 /)
      kbo(:,52,15) = (/ &
        & 0.97227e+01,0.93978e+01,0.90892e+01,0.87879e+01,0.84938e+01 /)
      kbo(:,53,15) = (/ &
        & 0.98436e+01,0.95182e+01,0.92014e+01,0.88988e+01,0.86011e+01 /)
      kbo(:,54,15) = (/ &
        & 0.99573e+01,0.96274e+01,0.93049e+01,0.90008e+01,0.87001e+01 /)
      kbo(:,55,15) = (/ &
        & 0.10066e+02,0.97327e+01,0.94075e+01,0.90983e+01,0.87962e+01 /)
      kbo(:,56,15) = (/ &
        & 0.10177e+02,0.98378e+01,0.95127e+01,0.91960e+01,0.88926e+01 /)
      kbo(:,57,15) = (/ &
        & 0.10293e+02,0.99462e+01,0.96173e+01,0.92949e+01,0.89909e+01 /)
      kbo(:,58,15) = (/ &
        & 0.10405e+02,0.10049e+02,0.97160e+01,0.93909e+01,0.90821e+01 /)
      kbo(:,59,15) = (/ &
        & 0.10450e+02,0.10090e+02,0.97556e+01,0.94305e+01,0.91193e+01 /)
      kbo(:,13,16) = (/ &
        & 0.50473e+01,0.50398e+01,0.50183e+01,0.49834e+01,0.49369e+01 /)
      kbo(:,14,16) = (/ &
        & 0.59220e+01,0.58911e+01,0.58423e+01,0.57748e+01,0.56924e+01 /)
      kbo(:,15,16) = (/ &
        & 0.68737e+01,0.68078e+01,0.67189e+01,0.66072e+01,0.64839e+01 /)
      kbo(:,16,16) = (/ &
        & 0.78824e+01,0.77694e+01,0.76268e+01,0.74643e+01,0.72894e+01 /)
      kbo(:,17,16) = (/ &
        & 0.89270e+01,0.87413e+01,0.85370e+01,0.83130e+01,0.80798e+01 /)
      kbo(:,18,16) = (/ &
        & 0.99711e+01,0.97011e+01,0.94250e+01,0.91345e+01,0.88363e+01 /)
      kbo(:,19,16) = (/ &
        & 0.10989e+02,0.10627e+02,0.10268e+02,0.99076e+01,0.95430e+01 /)
      kbo(:,20,16) = (/ &
        & 0.11944e+02,0.11487e+02,0.11042e+02,0.10609e+02,0.10177e+02 /)
      kbo(:,21,16) = (/ &
        & 0.12817e+02,0.12265e+02,0.11737e+02,0.11232e+02,0.10736e+02 /)
      kbo(:,22,16) = (/ &
        & 0.13548e+02,0.12914e+02,0.12305e+02,0.11734e+02,0.11183e+02 /)
      kbo(:,23,16) = (/ &
        & 0.14162e+02,0.13448e+02,0.12773e+02,0.12143e+02,0.11545e+02 /)
      kbo(:,24,16) = (/ &
        & 0.14655e+02,0.13870e+02,0.13141e+02,0.12464e+02,0.11822e+02 /)
      kbo(:,25,16) = (/ &
        & 0.15031e+02,0.14189e+02,0.13415e+02,0.12699e+02,0.12023e+02 /)
      kbo(:,26,16) = (/ &
        & 0.15288e+02,0.14405e+02,0.13595e+02,0.12850e+02,0.12149e+02 /)
      kbo(:,27,16) = (/ &
        & 0.15452e+02,0.14541e+02,0.13705e+02,0.12937e+02,0.12216e+02 /)
      kbo(:,28,16) = (/ &
        & 0.15538e+02,0.14608e+02,0.13754e+02,0.12971e+02,0.12237e+02 /)
      kbo(:,29,16) = (/ &
        & 0.15553e+02,0.14613e+02,0.13748e+02,0.12957e+02,0.12214e+02 /)
      kbo(:,30,16) = (/ &
        & 0.15516e+02,0.14571e+02,0.13703e+02,0.12907e+02,0.12159e+02 /)
      kbo(:,31,16) = (/ &
        & 0.15433e+02,0.14488e+02,0.13621e+02,0.12822e+02,0.12076e+02 /)
      kbo(:,32,16) = (/ &
        & 0.15312e+02,0.14373e+02,0.13511e+02,0.12712e+02,0.11970e+02 /)
      kbo(:,33,16) = (/ &
        & 0.15164e+02,0.14234e+02,0.13378e+02,0.12584e+02,0.11848e+02 /)
      kbo(:,34,16) = (/ &
        & 0.15029e+02,0.14108e+02,0.13258e+02,0.12470e+02,0.11741e+02 /)
      kbo(:,35,16) = (/ &
        & 0.14974e+02,0.14055e+02,0.13205e+02,0.12418e+02,0.11691e+02 /)
      kbo(:,36,16) = (/ &
        & 0.15011e+02,0.14086e+02,0.13232e+02,0.12441e+02,0.11710e+02 /)
      kbo(:,37,16) = (/ &
        & 0.15186e+02,0.14243e+02,0.13376e+02,0.12573e+02,0.11831e+02 /)
      kbo(:,38,16) = (/ &
        & 0.15364e+02,0.14405e+02,0.13523e+02,0.12708e+02,0.11955e+02 /)
      kbo(:,39,16) = (/ &
        & 0.15541e+02,0.14562e+02,0.13666e+02,0.12840e+02,0.12075e+02 /)
      kbo(:,40,16) = (/ &
        & 0.15818e+02,0.14814e+02,0.13896e+02,0.13052e+02,0.12271e+02 /)
      kbo(:,41,16) = (/ &
        & 0.16115e+02,0.15082e+02,0.14138e+02,0.13278e+02,0.12478e+02 /)
      kbo(:,42,16) = (/ &
        & 0.16420e+02,0.15352e+02,0.14384e+02,0.13504e+02,0.12687e+02 /)
      kbo(:,43,16) = (/ &
        & 0.16793e+02,0.15690e+02,0.14694e+02,0.13784e+02,0.12952e+02 /)
      kbo(:,44,16) = (/ &
        & 0.17211e+02,0.16062e+02,0.15031e+02,0.14091e+02,0.13236e+02 /)
      kbo(:,45,16) = (/ &
        & 0.17640e+02,0.16447e+02,0.15376e+02,0.14411e+02,0.13526e+02 /)
      kbo(:,46,16) = (/ &
        & 0.18112e+02,0.16870e+02,0.15758e+02,0.14754e+02,0.13842e+02 /)
      kbo(:,47,16) = (/ &
        & 0.18658e+02,0.17363e+02,0.16197e+02,0.15151e+02,0.14204e+02 /)
      kbo(:,48,16) = (/ &
        & 0.19225e+02,0.17876e+02,0.16658e+02,0.15564e+02,0.14577e+02 /)
      kbo(:,49,16) = (/ &
        & 0.19824e+02,0.18409e+02,0.17136e+02,0.15993e+02,0.14967e+02 /)
      kbo(:,50,16) = (/ &
        & 0.20411e+02,0.18926e+02,0.17606e+02,0.16414e+02,0.15344e+02 /)
      kbo(:,51,16) = (/ &
        & 0.21005e+02,0.19452e+02,0.18077e+02,0.16838e+02,0.15725e+02 /)
      kbo(:,52,16) = (/ &
        & 0.21646e+02,0.20001e+02,0.18565e+02,0.17278e+02,0.16117e+02 /)
      kbo(:,53,16) = (/ &
        & 0.22315e+02,0.20576e+02,0.19072e+02,0.17736e+02,0.16529e+02 /)
      kbo(:,54,16) = (/ &
        & 0.22958e+02,0.21134e+02,0.19557e+02,0.18172e+02,0.16919e+02 /)
      kbo(:,55,16) = (/ &
        & 0.23603e+02,0.21694e+02,0.20042e+02,0.18600e+02,0.17305e+02 /)
      kbo(:,56,16) = (/ &
        & 0.24285e+02,0.22278e+02,0.20543e+02,0.19044e+02,0.17707e+02 /)
      kbo(:,57,16) = (/ &
        & 0.24997e+02,0.22887e+02,0.21074e+02,0.19504e+02,0.18121e+02 /)
      kbo(:,58,16) = (/ &
        & 0.25697e+02,0.23494e+02,0.21600e+02,0.19961e+02,0.18525e+02 /)
      kbo(:,59,16) = (/ &
        & 0.25984e+02,0.23748e+02,0.21819e+02,0.20147e+02,0.18689e+02 /)
  
!     -----------------------------------------------------------------

      forrefo(:, 1) = (/ 0.106275e-05, 0.104185e-05, 0.420154e-05 /)
      forrefo(:, 2) = (/ 0.154343e-05, 0.653193e-05, 0.174596e-04 /)
      forrefo(:, 3) = (/ 0.348917e-05, 0.108420e-04, 0.540849e-04 /)
      forrefo(:, 4) = (/ 0.145822e-04, 0.156027e-04, 0.881263e-04 /)
      forrefo(:, 5) = (/ 0.220204e-04, 0.819892e-04, 0.817937e-04 /)
      forrefo(:, 6) = (/ 0.447840e-04, 0.121116e-03, 0.932635e-04 /)
      forrefo(:, 7) = (/ 0.166516e-03, 0.147640e-03, 0.754029e-04 /)
      forrefo(:, 8) = (/ 0.234756e-03, 0.145934e-03, 0.771734e-04 /)
      forrefo(:, 9) = (/ 0.289207e-03, 0.146768e-03, 0.677806e-04 /)
      forrefo(:,10) = (/ 0.334959e-03, 0.125513e-03, 0.636648e-04 /)
      forrefo(:,11) = (/ 0.333755e-03, 0.136575e-03, 0.593651e-04 /)
      forrefo(:,12) = (/ 0.340042e-03, 0.116259e-03, 0.595192e-04 /)
      forrefo(:,13) = (/ 0.422470e-03, 0.148691e-03, 0.630266e-04 /)
      forrefo(:,14) = (/ 0.440655e-03, 0.461917e-04, 0.108222e-04 /)
      forrefo(:,15) = (/ 0.486207e-03, 0.428458e-03, 0.108086e-04 /)
      forrefo(:,16) = (/ 0.657463e-03, 0.657446e-03, 0.126190e-04 /)

!     -----------------------------------------------------------------
!     The array SELFREFO contains the coefficient of the water vapor
!     self-continuum (including the energy term).  The first index
!     refers to temperature in 7.2 degree increments.  For instance,
!     JT = 1 refers to a temperature of 245.6, JT = 2 refers to 252.8,
!     etc.  The second index runs over the g-channel (1 to 16).
     
      selfrefo(:, 1) = (/ &
        &  0.331728e-03, 0.287480e-03, 0.249135e-03, 0.215904e-03, 0.187106e-03, &
        &  0.162149e-03, 0.140520e-03, 0.121777e-03, 0.105534e-03, 0.914573e-04 /)
      selfrefo(:, 2) = (/ &
        &  0.882628e-03, 0.698914e-03, 0.553439e-03, 0.438244e-03, 0.347026e-03, &
        &  0.274795e-03, 0.217598e-03, 0.172306e-03, 0.136442e-03, 0.108042e-03 /)
      selfrefo(:, 3) = (/ &
        &  0.115461e-02, 0.937203e-03, 0.760730e-03, 0.617486e-03, 0.501215e-03, &
        &  0.406837e-03, 0.330231e-03, 0.268049e-03, 0.217576e-03, 0.176607e-03 /)
      selfrefo(:, 4) = (/ &
        &  0.103450e-02, 0.960268e-03, 0.891360e-03, 0.827397e-03, 0.768024e-03, &
        &  0.712911e-03, 0.661754e-03, 0.614267e-03, 0.570188e-03, 0.529272e-03 /)
      selfrefo(:, 5) = (/ &
        &  0.289040e-02, 0.240129e-02, 0.199495e-02, 0.165737e-02, 0.137692e-02, &
        &  0.114392e-02, 0.950351e-03, 0.789535e-03, 0.655933e-03, 0.544938e-03 /)
      selfrefo(:, 6) = (/ &
        &  0.361772e-02, 0.306611e-02, 0.259861e-02, 0.220239e-02, 0.186659e-02, &
        &  0.158198e-02, 0.134077e-02, 0.113634e-02, 0.963078e-03, 0.816234e-03 /)
      selfrefo(:, 7) = (/ &
        &  0.329878e-02, 0.318245e-02, 0.307021e-02, 0.296194e-02, 0.285749e-02, &
        &  0.275671e-02, 0.265950e-02, 0.256571e-02, 0.247522e-02, 0.238793e-02 /)
      selfrefo(:, 8) = (/ &
        &  0.293562e-02, 0.300077e-02, 0.306737e-02, 0.313544e-02, 0.320503e-02, &
        &  0.327615e-02, 0.334886e-02, 0.342318e-02, 0.349915e-02, 0.357680e-02 /)
      selfrefo(:, 9) = (/ &
        &  0.281453e-02, 0.295894e-02, 0.311076e-02, 0.327038e-02, 0.343818e-02, &
        &  0.361459e-02, 0.380006e-02, 0.399504e-02, 0.420002e-02, 0.441553e-02 /)
      selfrefo(:,10) = (/ &
        &  0.239488e-02, 0.262487e-02, 0.287696e-02, 0.315325e-02, 0.345607e-02, &
        &  0.378798e-02, 0.415176e-02, 0.455048e-02, 0.498749e-02, 0.546647e-02 /)
      selfrefo(:,11) = (/ &
        &  0.271001e-02, 0.292235e-02, 0.315134e-02, 0.339826e-02, 0.366453e-02, &
        &  0.395167e-02, 0.426131e-02, 0.459521e-02, 0.495527e-02, 0.534354e-02 /)
      selfrefo(:,12) = (/ &
        &  0.206702e-02, 0.232254e-02, 0.260966e-02, 0.293226e-02, 0.329475e-02, &
        &  0.370204e-02, 0.415969e-02, 0.467391e-02, 0.525169e-02, 0.590090e-02 /)
      selfrefo(:,13) = (/ &
        &  0.227023e-02, 0.257331e-02, 0.291685e-02, 0.330626e-02, 0.374766e-02, &
        &  0.424799e-02, 0.481511e-02, 0.545794e-02, 0.618660e-02, 0.701253e-02 /)
      selfrefo(:,14) = (/ &
        &  0.851078e-03, 0.111512e-02, 0.146109e-02, 0.191439e-02, 0.250832e-02, &
        &  0.328653e-02, 0.430617e-02, 0.564215e-02, 0.739261e-02, 0.968616e-02 /)
      selfrefo(:,15) = (/ &
        &  0.742711e-02, 0.721347e-02, 0.700598e-02, 0.680446e-02, 0.660873e-02, &
        &  0.641863e-02, 0.623400e-02, 0.605468e-02, 0.588052e-02, 0.571137e-02 /)
      selfrefo(:,16) = (/ &
        &  0.107170e-01, 0.101913e-01, 0.969138e-02, 0.921599e-02, 0.876392e-02, &
        &  0.833402e-02, 0.792521e-02, 0.753646e-02, 0.716677e-02, 0.681522e-02 /)
  
      end subroutine sw_kgb19
