!     path:      $Source$
!     author:    $Author$
!     revision:  $Revision$
!     created:   $Date$

!----------------------------------------------------------------------------
! Copyright (c) 2002-2016, Atmospheric & Environmental Research, Inc. (AER)
! All rights reserved.
!
! Redistribution and use in source and binary forms, with or without
! modification, are permitted provided that the following conditions are met:
!  * Redistributions of source code must retain the above copyright
!    notice, this list of conditions and the following disclaimer.
!  * Redistributions in binary form must reproduce the above copyright
!    notice, this list of conditions and the following disclaimer in the
!    documentation and/or other materials provided with the distribution.
!  * Neither the name of Atmospheric & Environmental Research, Inc., nor
!    the names of its contributors may be used to endorse or promote products
!    derived from this software without specific prior written permission.
!
! THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
! AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
! IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
! ARE DISCLAIMED. IN NO EVENT SHALL ATMOSPHERIC & ENVIRONMENTAL RESEARCH, INC., 
! BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
! CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
! SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
! INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
! CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
! ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
! THE POSSIBILITY OF SUCH DAMAGE.
!                        (http://www.rtweb.aer.com/)                        
!----------------------------------------------------------------------------

! **************************************************************************
!      subroutine sw_kgbnn
! **************************************************************************
!  RRTM Shortwave Radiative Transfer Model
!  Atmospheric and Environmental Research, Inc., Cambridge, MA
!
!  Original by J.Delamere, Atmospheric & Environmental Research.
!  Reformatted for F90: JJMorcrette, ECMWF
!  Further F90 and GCM revisions:  MJIacono, AER, July 2002
!  Solar variability revisions:  MJIacono, AER, November 2015
!
!  This file contains 14 subroutines that include the 
!  absorption coefficients and other data for each of the 14 shortwave
!  spectral bands used in RRTM_SW.  Here, the data are defined for 16
!  g-points, or sub-intervals, per band.  These data are combined and
!  weighted using a mapping procedure in routine RRTMG_SW_INIT to reduce
!  the total number of g-points from 224 to 112 for use in the GCM.
! **************************************************************************
      subroutine sw_kgb18
! **************************************************************************

      !use parkind, only : im => kind , rb => kind  
      use rrsw_kg18, only : kao, kbo, selfrefo, forrefo, sfluxrefo, rayl, &
                            irradnceo, facbrghto, snsptdrko

      implicit none
      save

! Kurucz solar source function
      sfluxrefo(:,1) = (/ &
        & 3.65840    , 3.54375    , 3.34481    , 3.10534    , &
        & 2.79879    , 2.42841    , 1.98748    , 1.49377    , &
        & 1.00196    , 0.108342   , 8.95099e-02, 7.05199e-02, &
        & 5.16432e-02, 3.27635e-02, 1.25133e-02, 1.73001e-03 /)  
      sfluxrefo(:,2) = (/ &
        & 3.86372    , 3.48521    , 3.30790    , 3.08103    , &
        & 2.77552    , 2.40722    , 1.97307    , 1.48023    , &
        & 0.993055   , 0.107691   , 8.84430e-02, 6.99354e-02, &
        & 5.07881e-02, 3.24121e-02, 1.19442e-02, 1.57612e-03 /)
      sfluxrefo(:,3) = (/ &
        & 3.90370    , 3.50657    , 3.30629    , 3.06046    , &
        & 2.76982    , 2.39907    , 1.96358    , 1.47458    , &
        & 0.988475   , 0.106698   , 8.75242e-02, 6.85898e-02, &
        & 5.04798e-02, 3.13718e-02, 1.09533e-02, 1.57612e-03 /)
      sfluxrefo(:,4) = (/ &
        & 3.93165    , 3.52058    , 3.31346    , 3.04944    , &
        & 2.76074    , 2.39433    , 1.95556    , 1.46712    , &
        & 0.984056   , 0.105885   , 8.73062e-02, 6.84054e-02, &
        & 4.87443e-02, 2.99295e-02, 1.09533e-02, 1.57612e-03 /)
      sfluxrefo(:,5) = (/ &
        & 3.94082    , 3.55221    , 3.31863    , 3.04730    , &
        & 2.74918    , 2.38328    , 1.95212    , 1.45889    , &
        & 0.978888   , 0.105102   , 8.65732e-02, 6.74563e-02, &
        & 4.76592e-02, 2.91017e-02, 1.09533e-02, 1.57612e-03 /)
      sfluxrefo(:,6) = (/ &
        & 3.94198    , 3.58743    , 3.32106    , 3.05866    , &
        & 2.74115    , 2.36939    , 1.94305    , 1.45180    , &
        & 0.971784   , 1.04045e-01, 8.53731e-02, 6.60654e-02, &
        & 4.63228e-02, 2.91016e-02, 1.09552e-02, 1.57612e-03 /)
      sfluxrefo(:,7) = (/ &
        & 3.93596    , 3.63366    , 3.33144    , 3.06252    , &
        & 2.74054    , 2.35492    , 1.92769    , 1.44300    , &
        & 0.961809   , 1.02867e-01, 8.34164e-02, 6.41005e-02, &
        & 4.61826e-02, 2.91006e-02, 1.09553e-02, 1.57612e-03 /)
      sfluxrefo(:,8) = (/ &
        & 3.92520    , 3.69078    , 3.35656    , 3.07055    , &
        & 2.73862    , 2.34430    , 1.90187    , 1.42242    , &
        & 0.946676   , 9.96302e-02, 8.14421e-02, 6.38622e-02, &
        & 4.61794e-02, 2.91017e-02, 1.09553e-02, 1.57612e-03 /)
      sfluxrefo(:,9) = (/ &
        & 3.80721    , 3.74437    , 3.50205    , 3.18009    , &
        & 2.75757    , 2.29188    , 1.84382    , 1.35694    , &
        & 0.914040   , 9.86811e-02, 8.14321e-02, 6.38541e-02, &
        & 4.61795e-02, 2.90960e-02, 1.09613e-02, 1.57612e-03 /)

! Solar variability components: time-invariant baseline quiet sun irradiance
      irradnceo(:,1) = (/ &
        & 3.49440E+00, 3.57650E+00, 3.41488E+00, 3.14413E+00,&
        & 2.81877E+00, 2.43443E+00, 1.99233E+00, 1.49600E+00,&
        & 1.00377E+00, 1.08483E-01, 8.95901E-02, 7.04863E-02,&
        & 5.17070E-02, 3.26854E-02, 1.24569E-02, 1.72274E-03/)
      irradnceo(:,2) = (/ &
        & 3.68553E+00, 3.56505E+00, 3.35418E+00, 3.11289E+00,&
        & 2.79208E+00, 2.41416E+00, 1.97742E+00, 1.48270E+00,&
        & 9.95111E-01, 1.07772E-01, 8.86279E-02, 6.98929E-02,&
        & 5.10621E-02, 3.23227E-02, 1.19330E-02, 1.60968E-03/)
      irradnceo(:,3) = (/ &
        & 3.75860E+00, 3.57346E+00, 3.33478E+00, 3.09398E+00,&
        & 2.78402E+00, 2.40611E+00, 1.96708E+00, 1.47636E+00,&
        & 9.90253E-01, 1.06549E-01, 8.75229E-02, 6.89197E-02,&
        & 5.05164E-02, 3.14200E-02, 1.11817E-02, 1.58850E-03/)
      irradnceo(:,4) = (/ &
        & 3.81767E+00, 3.57466E+00, 3.32940E+00, 3.08251E+00,&
        & 2.77077E+00, 2.40182E+00, 1.95824E+00, 1.46906E+00,&
        & 9.84809E-01, 1.05919E-01, 8.72473E-02, 6.83740E-02,&
        & 4.89285E-02, 3.01940E-02, 1.11449E-02, 1.58850E-03/)
      irradnceo(:,5) = (/ &
        & 3.87128E+00, 3.57646E+00, 3.33718E+00, 3.06566E+00,&
        & 2.75945E+00, 2.38977E+00, 1.95417E+00, 1.46006E+00,&
        & 9.79580E-01, 1.05017E-01, 8.65276E-02, 6.73472E-02,&
        & 4.78356E-02, 2.92746E-02, 1.11449E-02, 1.58850E-03/)
      irradnceo(:,6) = (/ &
        & 3.90742E+00, 3.59616E+00, 3.33608E+00, 3.06693E+00,&
        & 2.74816E+00, 2.37539E+00, 1.94331E+00, 1.45351E+00,&
        & 9.71722E-01, 1.03829E-01, 8.53982E-02, 6.59824E-02,&
        & 4.64343E-02, 2.92747E-02, 1.11449E-02, 1.58850E-03/)
      irradnceo(:,7) = (/ &
        & 3.92574E+00, 3.64369E+00, 3.33733E+00, 3.06377E+00,&
        & 2.74380E+00, 2.35857E+00, 1.92632E+00, 1.44340E+00,&
        & 9.61341E-01, 1.02784E-01, 8.33603E-02, 6.39926E-02,&
        & 4.62416E-02, 2.92746E-02, 1.11449E-02, 1.58850E-03/)
      irradnceo(:,8) = (/ &
        & 3.92268E+00, 3.71504E+00, 3.37141E+00, 3.05973E+00,&
        & 2.73287E+00, 2.34241E+00, 1.90068E+00, 1.41996E+00,&
        & 9.44915E-01, 9.93891E-02, 8.13306E-02, 6.36746E-02,&
        & 4.62467E-02, 2.92746E-02, 1.11449E-02, 1.58850E-03/)
      irradnceo(:,9) = (/ &
        & 3.82674E+00, 3.70356E+00, 3.53205E+00, 3.21082E+00,&
        & 2.75496E+00, 2.28523E+00, 1.83335E+00, 1.35206E+00,&
        & 9.11881E-01, 9.84346E-02, 8.13206E-02, 6.36749E-02,&
        & 4.62421E-02, 2.92738E-02, 1.11449E-02, 1.58850E-03/)
! Solar variability components: facular brightening
      facbrghto(:,1) = (/ &
        & 7.58999E-04, 6.55830E-04, 6.20804E-04, 6.12259E-04,&
        & 5.54428E-04, 4.79876E-04, 3.89163E-04, 3.01726E-04,&
        & 2.12719E-04, 2.39117E-05, 2.02305E-05, 1.64707E-05,&
        & 1.21059E-05, 8.13734E-06, 2.81665E-06, 5.39623E-07/)
      facbrghto(:,2) = (/ &
        & 6.36794E-04, 6.57247E-04, 6.67170E-04, 6.31953E-04,&
        & 5.70430E-04, 4.94028E-04, 3.98611E-04, 3.10582E-04,&
        & 2.17379E-04, 2.42843E-05, 2.07745E-05, 1.67557E-05,&
        & 1.23009E-05, 8.09594E-06, 3.16603E-06, 4.44158E-07/)
      facbrghto(:,3) = (/ &
        & 5.87600E-04, 6.50301E-04, 6.86813E-04, 6.39318E-04,&
        & 5.76886E-04, 4.99174E-04, 4.06306E-04, 3.14503E-04,&
        & 2.20859E-04, 2.51296E-05, 2.13220E-05, 1.70147E-05,&
        & 1.28933E-05, 8.11242E-06, 3.34674E-06, 4.36119E-07/)
      facbrghto(:,4) = (/ &
        & 5.46975E-04, 6.49450E-04, 6.92184E-04, 6.48755E-04,&
        & 5.84166E-04, 5.01298E-04, 4.14016E-04, 3.18445E-04,&
        & 2.24422E-04, 2.55811E-05, 2.17482E-05, 1.73672E-05,&
        & 1.31428E-05, 8.70580E-06, 3.32525E-06, 4.36119E-07/)
      facbrghto(:,5) = (/ &
        & 5.08232E-04, 6.48741E-04, 6.91036E-04, 6.61654E-04,&
        & 5.89889E-04, 5.07646E-04, 4.18691E-04, 3.23911E-04,&
        & 2.27748E-04, 2.62553E-05, 2.19886E-05, 1.80693E-05,&
        & 1.35550E-05, 8.83925E-06, 3.32525E-06, 4.36119E-07/)
      facbrghto(:,6) = (/ &
        & 4.76940E-04, 6.39693E-04, 6.93532E-04, 6.63608E-04,&
        & 5.99297E-04, 5.14808E-04, 4.25655E-04, 3.28971E-04,&
        & 2.32714E-04, 2.71686E-05, 2.25696E-05, 1.82517E-05,&
        & 1.42076E-05, 8.83924E-06, 3.32525E-06, 4.36119E-07/)
      facbrghto(:,7) = (/ &
        & 4.57140E-04, 6.09182E-04, 6.96958E-04, 6.69137E-04,&
        & 6.04079E-04, 5.25112E-04, 4.36423E-04, 3.35550E-04,&
        & 2.39276E-04, 2.78692E-05, 2.32621E-05, 1.92758E-05,&
        & 1.41543E-05, 8.83830E-06, 3.32525E-06, 4.36119E-07/)
      facbrghto(:,8) = (/ &
        & 4.52565E-04, 5.50855E-04, 6.84333E-04, 6.76955E-04,&
        & 6.15651E-04, 5.39009E-04, 4.52801E-04, 3.48779E-04,&
        & 2.49515E-04, 2.92096E-05, 2.43576E-05, 1.92334E-05,&
        & 1.41526E-05, 8.84028E-06, 3.32525E-06, 4.36119E-07/)
      facbrghto(:,9) = (/ &
        & 4.91883E-04, 5.60107E-04, 5.57685E-04, 5.96261E-04,&
        & 6.31358E-04, 5.93500E-04, 4.90937E-04, 3.83419E-04,&
        & 2.64987E-04, 2.95723E-05, 2.43196E-05, 1.92312E-05,&
        & 1.41532E-05, 8.84046E-06, 3.32525E-06, 4.36119E-07/)
! Solar variability components: sunspot darkening
      snsptdrko(:,1) = (/ &
        &-4.51300E-04,-4.45609E-04,-4.24720E-04,-3.99722E-04,&
        &-3.60952E-04,-3.12628E-04,-2.56030E-04,-1.94296E-04,&
        &-1.32174E-04,-1.43956E-05,-1.19486E-05,-9.47930E-06,&
        &-6.94662E-06,-4.48228E-06,-1.65440E-06,-2.51503E-07/)
      snsptdrko(:,2) = (/ &
        &-4.55729E-04,-4.43042E-04,-4.26015E-04,-3.99035E-04,&
        &-3.60091E-04,-3.12410E-04,-2.55602E-04,-1.94059E-04,&
        &-1.31762E-04,-1.43450E-05,-1.19028E-05,-9.43882E-06,&
        &-6.91015E-06,-4.40578E-06,-1.62750E-06,-2.15621E-07/)
      snsptdrko(:,3) = (/ &
        &-4.56549E-04,-4.43019E-04,-4.27191E-04,-3.98183E-04,&
        &-3.60119E-04,-3.12019E-04,-2.55511E-04,-1.93908E-04,&
        &-1.31579E-04,-1.43209E-05,-1.18561E-05,-9.35705E-06,&
        &-6.92644E-06,-4.29189E-06,-1.54851E-06,-2.10351E-07/)
      snsptdrko(:,4) = (/ &
        &-4.56684E-04,-4.43572E-04,-4.27672E-04,-3.98699E-04,&
        &-3.59420E-04,-3.11860E-04,-2.55447E-04,-1.93638E-04,&
        &-1.31347E-04,-1.42991E-05,-1.18693E-05,-9.33361E-06,&
        &-6.78764E-06,-4.20873E-06,-1.54183E-06,-2.10351E-07/)
      snsptdrko(:,5) = (/ &
        &-4.56270E-04,-4.44762E-04,-4.28429E-04,-3.98934E-04,&
        &-3.58924E-04,-3.11262E-04,-2.55667E-04,-1.93279E-04,&
        &-1.31122E-04,-1.42714E-05,-1.17983E-05,-9.31874E-06,&
        &-6.67579E-06,-4.12466E-06,-1.54183E-06,-2.10351E-07/)
      snsptdrko(:,6) = (/ &
        &-4.55193E-04,-4.46168E-04,-4.29248E-04,-3.99450E-04,&
        &-3.58992E-04,-3.10587E-04,-2.55473E-04,-1.93094E-04,&
        &-1.30784E-04,-1.42502E-05,-1.17328E-05,-9.14896E-06,&
        &-6.59212E-06,-4.12465E-06,-1.54183E-06,-2.10351E-07/)
      snsptdrko(:,7) = (/ &
        &-4.54045E-04,-4.47013E-04,-4.31032E-04,-3.99936E-04,&
        &-3.59117E-04,-3.10327E-04,-2.54888E-04,-1.92799E-04,&
        &-1.30214E-04,-1.42080E-05,-1.15499E-05,-9.02467E-06,&
        &-6.55881E-06,-4.12446E-06,-1.54183E-06,-2.10351E-07/)
      snsptdrko(:,8) = (/ &
        &-4.52992E-04,-4.46009E-04,-4.34048E-04,-4.01532E-04,&
        &-3.59657E-04,-3.10308E-04,-2.54431E-04,-1.91476E-04,&
        &-1.29373E-04,-1.39204E-05,-1.14329E-05,-8.97348E-06,&
        &-6.55862E-06,-4.12468E-06,-1.54183E-06,-2.10351E-07/)
      snsptdrko(:,9) = (/ &
        &-4.54391E-04,-4.52912E-04,-4.28976E-04,-4.03420E-04,&
        &-3.64644E-04,-3.11647E-04,-2.50240E-04,-1.86827E-04,&
        &-1.26855E-04,-1.38507E-05,-1.14187E-05,-8.97252E-06,&
        &-6.55863E-06,-4.12466E-06,-1.54183E-06,-2.10351E-07/)

! Rayleigh extinction coefficient at v = 4325 cm-1.
      rayl = 1.39e-09

!     ------------------------------------------------------------------
!     The array KAO contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels> ~100mb, temperatures, and binary
!     species parameters (see taumol.f for definition).  The first 
!     index in the array, JS, runs from 1 to 9, and corresponds to 
!     different values of the binary species parameter.  For instance, 
!     JS=1 refers to dry air, JS = 2 corresponds to the paramter value 1/8, 
!     JS = 3 corresponds to the parameter value 2/8, etc.  The second index
!     in the array, JT, which runs from 1 to 5, corresponds to different
!     temperatures.  More specifically, JT = 3 means that the data are for
!     the reference temperature TREF for this  pressure level, JT = 2 refers
!     to TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and JT = 5
!     is for TREF+30.  The third index, JP, runs from 1 to 13 and refers
!     to the JPth reference pressure level (see taumol.f for these levels
!     in mb).  The fourth index, IG, goes from 1 to 16, and indicates
!     which g-interval the absorption coefficients are for.
!     -----------------------------------------------------------------

      kao(:, 1, 1, 1) = (/ &
        & 0.14813e-04,0.39842e-04,0.43362e-04,0.43095e-04,0.39811e-04, &
        & 0.34994e-04,0.28984e-04,0.20609e-04,0.18845e-05 /)
      kao(:, 2, 1, 1) = (/ &
        & 0.14432e-04,0.38749e-04,0.42119e-04,0.41834e-04,0.38900e-04, &
        & 0.34365e-04,0.28571e-04,0.20503e-04,0.14715e-05 /)
      kao(:, 3, 1, 1) = (/ &
        & 0.13969e-04,0.37666e-04,0.40942e-04,0.40703e-04,0.37982e-04, &
        & 0.33731e-04,0.28158e-04,0.20351e-04,0.10842e-05 /)
      kao(:, 4, 1, 1) = (/ &
        & 0.13367e-04,0.36605e-04,0.39729e-04,0.39529e-04,0.37033e-04, &
        & 0.33096e-04,0.27690e-04,0.20154e-04,0.78702e-06 /)
      kao(:, 5, 1, 1) = (/ &
        & 0.12765e-04,0.35584e-04,0.38536e-04,0.38361e-04,0.36073e-04, &
        & 0.32384e-04,0.27242e-04,0.19932e-04,0.58296e-06 /)
      kao(:, 1, 2, 1) = (/ &
        & 0.12299e-04,0.34179e-04,0.37405e-04,0.37535e-04,0.34714e-04, &
        & 0.30335e-04,0.24892e-04,0.17524e-04,0.13301e-05 /)
      kao(:, 2, 2, 1) = (/ &
        & 0.12064e-04,0.33225e-04,0.36357e-04,0.36512e-04,0.33870e-04, &
        & 0.29789e-04,0.24578e-04,0.17435e-04,0.10217e-05 /)
      kao(:, 3, 2, 1) = (/ &
        & 0.11697e-04,0.32301e-04,0.35316e-04,0.35481e-04,0.33049e-04, &
        & 0.29226e-04,0.24233e-04,0.17304e-04,0.72152e-06 /)
      kao(:, 4, 2, 1) = (/ &
        & 0.11209e-04,0.31395e-04,0.34263e-04,0.34436e-04,0.32173e-04, &
        & 0.28610e-04,0.23847e-04,0.17161e-04,0.51787e-06 /)
      kao(:, 5, 2, 1) = (/ &
        & 0.10706e-04,0.30496e-04,0.33311e-04,0.33396e-04,0.31295e-04, &
        & 0.28002e-04,0.23445e-04,0.16971e-04,0.40230e-06 /)
      kao(:, 1, 3, 1) = (/ &
        & 0.10271e-04,0.29273e-04,0.32049e-04,0.32365e-04,0.29857e-04, &
        & 0.26171e-04,0.21352e-04,0.14814e-04,0.80470e-06 /)
      kao(:, 2, 3, 1) = (/ &
        & 0.10058e-04,0.28458e-04,0.31196e-04,0.31440e-04,0.29133e-04, &
        & 0.25640e-04,0.21056e-04,0.14756e-04,0.53010e-06 /)
      kao(:, 3, 3, 1) = (/ &
        & 0.98172e-05,0.27651e-04,0.30352e-04,0.30609e-04,0.28396e-04, &
        & 0.25110e-04,0.20730e-04,0.14655e-04,0.38652e-06 /)
      kao(:, 4, 3, 1) = (/ &
        & 0.94577e-05,0.26874e-04,0.29475e-04,0.29749e-04,0.27669e-04, &
        & 0.24553e-04,0.20400e-04,0.14536e-04,0.33236e-06 /)
      kao(:, 5, 3, 1) = (/ &
        & 0.90508e-05,0.26128e-04,0.28631e-04,0.28834e-04,0.26952e-04, &
        & 0.24015e-04,0.20045e-04,0.14382e-04,0.30659e-06 /)
      kao(:, 1, 4, 1) = (/ &
        & 0.86081e-05,0.24897e-04,0.27317e-04,0.27632e-04,0.25465e-04, &
        & 0.22328e-04,0.18112e-04,0.12468e-04,0.39286e-06 /)
      kao(:, 2, 4, 1) = (/ &
        & 0.83793e-05,0.24273e-04,0.26590e-04,0.26865e-04,0.24876e-04, &
        & 0.21867e-04,0.17849e-04,0.12420e-04,0.32266e-06 /)
      kao(:, 3, 4, 1) = (/ &
        & 0.82296e-05,0.23584e-04,0.25869e-04,0.26155e-04,0.24255e-04, &
        & 0.21403e-04,0.17579e-04,0.12338e-04,0.30775e-06 /)
      kao(:, 4, 4, 1) = (/ &
        & 0.79731e-05,0.22915e-04,0.25166e-04,0.25435e-04,0.23627e-04, &
        & 0.20917e-04,0.17282e-04,0.12242e-04,0.30418e-06 /)
      kao(:, 5, 4, 1) = (/ &
        & 0.76553e-05,0.22259e-04,0.24440e-04,0.24673e-04,0.23003e-04, &
        & 0.20437e-04,0.16984e-04,0.12112e-04,0.30638e-06 /)
      kao(:, 1, 5, 1) = (/ &
        & 0.72259e-05,0.21089e-04,0.23177e-04,0.23419e-04,0.21584e-04, &
        & 0.18926e-04,0.15251e-04,0.10417e-04,0.25170e-06 /)
      kao(:, 2, 5, 1) = (/ &
        & 0.70215e-05,0.20567e-04,0.22541e-04,0.22788e-04,0.21102e-04, &
        & 0.18526e-04,0.15049e-04,0.10379e-04,0.25958e-06 /)
      kao(:, 3, 5, 1) = (/ &
        & 0.68490e-05,0.20018e-04,0.21938e-04,0.22206e-04,0.20579e-04, &
        & 0.18139e-04,0.14806e-04,0.10313e-04,0.26666e-06 /)
      kao(:, 4, 5, 1) = (/ &
        & 0.66973e-05,0.19444e-04,0.21340e-04,0.21615e-04,0.20070e-04, &
        & 0.17728e-04,0.14554e-04,0.10239e-04,0.28589e-06 /)
      kao(:, 5, 5, 1) = (/ &
        & 0.64808e-05,0.18883e-04,0.20738e-04,0.20994e-04,0.19546e-04, &
        & 0.17304e-04,0.14306e-04,0.10148e-04,0.30886e-06 /)
      kao(:, 1, 6, 1) = (/ &
        & 0.60727e-05,0.17794e-04,0.19609e-04,0.19769e-04,0.18228e-04, &
        & 0.15946e-04,0.12793e-04,0.86559e-05,0.18559e-06 /)
      kao(:, 2, 6, 1) = (/ &
        & 0.58949e-05,0.17390e-04,0.19059e-04,0.19244e-04,0.17820e-04, &
        & 0.15647e-04,0.12626e-04,0.86354e-05,0.19544e-06 /)
      kao(:, 3, 6, 1) = (/ &
        & 0.57268e-05,0.16935e-04,0.18564e-04,0.18724e-04,0.17402e-04, &
        & 0.15304e-04,0.12433e-04,0.85882e-05,0.22033e-06 /)
      kao(:, 4, 6, 1) = (/ &
        & 0.56243e-05,0.16459e-04,0.18054e-04,0.18263e-04,0.16984e-04, &
        & 0.14971e-04,0.12215e-04,0.85268e-05,0.25072e-06 /)
      kao(:, 5, 6, 1) = (/ &
        & 0.54584e-05,0.15984e-04,0.17548e-04,0.17773e-04,0.16551e-04, &
        & 0.14601e-04,0.12004e-04,0.84568e-05,0.28110e-06 /)
      kao(:, 1, 7, 1) = (/ &
        & 0.50624e-05,0.14963e-04,0.16482e-04,0.16611e-04,0.15339e-04, &
        & 0.13333e-04,0.10656e-04,0.71570e-05,0.13453e-06 /)
      kao(:, 2, 7, 1) = (/ &
        & 0.49428e-05,0.14636e-04,0.16040e-04,0.16181e-04,0.14992e-04, &
        & 0.13144e-04,0.10533e-04,0.71532e-05,0.15620e-06 /)
      kao(:, 3, 7, 1) = (/ &
        & 0.47955e-05,0.14256e-04,0.15611e-04,0.15735e-04,0.14643e-04, &
        & 0.12865e-04,0.10390e-04,0.71248e-05,0.18571e-06 /)
      kao(:, 4, 7, 1) = (/ &
        & 0.46743e-05,0.13876e-04,0.15213e-04,0.15342e-04,0.14293e-04, &
        & 0.12576e-04,0.10215e-04,0.70735e-05,0.21382e-06 /)
      kao(:, 5, 7, 1) = (/ &
        & 0.45708e-05,0.13473e-04,0.14782e-04,0.14947e-04,0.13933e-04, &
        & 0.12274e-04,0.10036e-04,0.70177e-05,0.24419e-06 /)
      kao(:, 1, 8, 1) = (/ &
        & 0.42289e-05,0.12528e-04,0.13817e-04,0.13922e-04,0.12867e-04, &
        & 0.11126e-04,0.88468e-05,0.59010e-05,0.10600e-06 /)
      kao(:, 2, 8, 1) = (/ &
        & 0.41319e-05,0.12286e-04,0.13480e-04,0.13582e-04,0.12584e-04, &
        & 0.10973e-04,0.87644e-05,0.59049e-05,0.12951e-06 /)
      kao(:, 3, 8, 1) = (/ &
        & 0.40317e-05,0.11996e-04,0.13116e-04,0.13206e-04,0.12295e-04, &
        & 0.10786e-04,0.86537e-05,0.58898e-05,0.15731e-06 /)
      kao(:, 4, 8, 1) = (/ &
        & 0.39107e-05,0.11666e-04,0.12771e-04,0.12870e-04,0.12010e-04, &
        & 0.10546e-04,0.85244e-05,0.58536e-05,0.18716e-06 /)
      kao(:, 5, 8, 1) = (/ &
        & 0.38384e-05,0.11346e-04,0.12435e-04,0.12549e-04,0.11706e-04, &
        & 0.10289e-04,0.83756e-05,0.58104e-05,0.21679e-06 /)
      kao(:, 1, 9, 1) = (/ &
        & 0.35240e-05,0.10418e-04,0.11558e-04,0.11687e-04,0.10748e-04, &
        & 0.92305e-05,0.73198e-05,0.48514e-05,0.10176e-06 /)
      kao(:, 2, 9, 1) = (/ &
        & 0.34478e-05,0.10296e-04,0.11296e-04,0.11369e-04,0.10532e-04, &
        & 0.91375e-05,0.72737e-05,0.48639e-05,0.12695e-06 /)
      kao(:, 3, 9, 1) = (/ &
        & 0.33718e-05,0.10068e-04,0.10996e-04,0.11063e-04,0.10290e-04, &
        & 0.89957e-05,0.71844e-05,0.48583e-05,0.15482e-06 /)
      kao(:, 4, 9, 1) = (/ &
        & 0.32801e-05,0.97990e-05,0.10712e-04,0.10762e-04,0.10056e-04, &
        & 0.88255e-05,0.70907e-05,0.48364e-05,0.18123e-06 /)
      kao(:, 5, 9, 1) = (/ &
        & 0.31960e-05,0.95350e-05,0.10427e-04,0.10501e-04,0.98056e-05, &
        & 0.86157e-05,0.69723e-05,0.48010e-05,0.20738e-06 /)
      kao(:, 1,10, 1) = (/ &
        & 0.29197e-05,0.86183e-05,0.96100e-05,0.97448e-05,0.89187e-05, &
        & 0.76354e-05,0.60318e-05,0.39733e-05,0.10310e-06 /)
      kao(:, 2,10, 1) = (/ &
        & 0.28677e-05,0.85565e-05,0.94191e-05,0.94682e-05,0.87653e-05, &
        & 0.75725e-05,0.60089e-05,0.39956e-05,0.12951e-06 /)
      kao(:, 3,10, 1) = (/ &
        & 0.28036e-05,0.84121e-05,0.91902e-05,0.92251e-05,0.85811e-05, &
        & 0.74653e-05,0.59452e-05,0.39967e-05,0.15684e-06 /)
      kao(:, 4,10, 1) = (/ &
        & 0.27420e-05,0.82035e-05,0.89440e-05,0.89748e-05,0.83817e-05, &
        & 0.73422e-05,0.58725e-05,0.39844e-05,0.18564e-06 /)
      kao(:, 5,10, 1) = (/ &
        & 0.26596e-05,0.79739e-05,0.87074e-05,0.87508e-05,0.81784e-05, &
        & 0.71781e-05,0.57815e-05,0.39569e-05,0.21476e-06 /)
      kao(:, 1,11, 1) = (/ &
        & 0.23988e-05,0.71135e-05,0.79121e-05,0.80118e-05,0.73370e-05, &
        & 0.62844e-05,0.49610e-05,0.32641e-05,0.91697e-07 /)
      kao(:, 2,11, 1) = (/ &
        & 0.23552e-05,0.70587e-05,0.77519e-05,0.77821e-05,0.72113e-05, &
        & 0.62297e-05,0.49407e-05,0.32815e-05,0.11307e-06 /)
      kao(:, 3,11, 1) = (/ &
        & 0.23046e-05,0.69367e-05,0.75662e-05,0.75790e-05,0.70631e-05, &
        & 0.61409e-05,0.48867e-05,0.32812e-05,0.13715e-06 /)
      kao(:, 4,11, 1) = (/ &
        & 0.22557e-05,0.67632e-05,0.73640e-05,0.73772e-05,0.68972e-05, &
        & 0.60381e-05,0.48254e-05,0.32705e-05,0.16436e-06 /)
      kao(:, 5,11, 1) = (/ &
        & 0.21899e-05,0.65748e-05,0.71695e-05,0.71946e-05,0.67295e-05, &
        & 0.59022e-05,0.47488e-05,0.32476e-05,0.19025e-06 /)
      kao(:, 1,12, 1) = (/ &
        & 0.19699e-05,0.58670e-05,0.65075e-05,0.65808e-05,0.60300e-05, &
        & 0.51665e-05,0.40749e-05,0.26788e-05,0.77100e-07 /)
      kao(:, 2,12, 1) = (/ &
        & 0.19348e-05,0.58146e-05,0.63730e-05,0.63891e-05,0.59260e-05, &
        & 0.51196e-05,0.40577e-05,0.26926e-05,0.95693e-07 /)
      kao(:, 3,12, 1) = (/ &
        & 0.18947e-05,0.57134e-05,0.62207e-05,0.62238e-05,0.58090e-05, &
        & 0.50459e-05,0.40113e-05,0.26916e-05,0.11572e-06 /)
      kao(:, 4,12, 1) = (/ &
        & 0.18552e-05,0.55709e-05,0.60522e-05,0.60611e-05,0.56693e-05, &
        & 0.49594e-05,0.39606e-05,0.26824e-05,0.13797e-06 /)
      kao(:, 5,12, 1) = (/ &
        & 0.18040e-05,0.54137e-05,0.58935e-05,0.59096e-05,0.55294e-05, &
        & 0.48443e-05,0.38977e-05,0.26633e-05,0.15884e-06 /)
      kao(:, 1,13, 1) = (/ &
        & 0.16167e-05,0.48272e-05,0.53475e-05,0.53983e-05,0.49503e-05, &
        & 0.42413e-05,0.33431e-05,0.21956e-05,0.61381e-07 /)
      kao(:, 2,13, 1) = (/ &
        & 0.15895e-05,0.47809e-05,0.52342e-05,0.52409e-05,0.48652e-05, &
        & 0.42021e-05,0.33263e-05,0.22072e-05,0.76382e-07 /)
      kao(:, 3,13, 1) = (/ &
        & 0.15582e-05,0.46982e-05,0.51055e-05,0.51058e-05,0.47716e-05, &
        & 0.41406e-05,0.32886e-05,0.22058e-05,0.93083e-07 /)
      kao(:, 4,13, 1) = (/ &
        & 0.15242e-05,0.45831e-05,0.49696e-05,0.49735e-05,0.46534e-05, &
        & 0.40678e-05,0.32469e-05,0.21969e-05,0.11211e-06 /)
      kao(:, 5,13, 1) = (/ &
        & 0.14859e-05,0.44492e-05,0.48392e-05,0.48479e-05,0.45378e-05, &
        & 0.39689e-05,0.31933e-05,0.21813e-05,0.12970e-06 /)
      kao(:, 1, 1, 2) = (/ &
        & 0.10138e-03,0.20456e-03,0.22117e-03,0.21948e-03,0.20805e-03, &
        & 0.18373e-03,0.14999e-03,0.95382e-04,0.33213e-05 /)
      kao(:, 2, 1, 2) = (/ &
        & 0.10141e-03,0.20889e-03,0.22456e-03,0.22223e-03,0.20912e-03, &
        & 0.18467e-03,0.15060e-03,0.95713e-04,0.28479e-05 /)
      kao(:, 3, 1, 2) = (/ &
        & 0.10125e-03,0.21223e-03,0.22712e-03,0.22388e-03,0.20983e-03, &
        & 0.18513e-03,0.15100e-03,0.95881e-04,0.26338e-05 /)
      kao(:, 4, 1, 2) = (/ &
        & 0.10105e-03,0.21442e-03,0.22863e-03,0.22421e-03,0.21046e-03, &
        & 0.18540e-03,0.15060e-03,0.95798e-04,0.27638e-05 /)
      kao(:, 5, 1, 2) = (/ &
        & 0.10040e-03,0.21612e-03,0.22899e-03,0.22416e-03,0.21046e-03, &
        & 0.18570e-03,0.15001e-03,0.95569e-04,0.29313e-05 /)
      kao(:, 1, 2, 2) = (/ &
        & 0.89639e-04,0.17797e-03,0.19284e-03,0.18986e-03,0.17824e-03, &
        & 0.15789e-03,0.12906e-03,0.83524e-04,0.23926e-05 /)
      kao(:, 2, 2, 2) = (/ &
        & 0.89499e-04,0.18144e-03,0.19563e-03,0.19227e-03,0.17941e-03, &
        & 0.15844e-03,0.12961e-03,0.83632e-04,0.21969e-05 /)
      kao(:, 3, 2, 2) = (/ &
        & 0.89411e-04,0.18401e-03,0.19753e-03,0.19350e-03,0.17999e-03, &
        & 0.15883e-03,0.12989e-03,0.83577e-04,0.23158e-05 /)
      kao(:, 4, 2, 2) = (/ &
        & 0.88841e-04,0.18541e-03,0.19872e-03,0.19398e-03,0.18053e-03, &
        & 0.15907e-03,0.12972e-03,0.83396e-04,0.23760e-05 /)
      kao(:, 5, 2, 2) = (/ &
        & 0.87949e-04,0.18659e-03,0.19902e-03,0.19407e-03,0.18073e-03, &
        & 0.15910e-03,0.12937e-03,0.83120e-04,0.25247e-05 /)
      kao(:, 1, 3, 2) = (/ &
        & 0.77466e-04,0.15264e-03,0.16704e-03,0.16342e-03,0.15300e-03, &
        & 0.13499e-03,0.11007e-03,0.71881e-04,0.17839e-05 /)
      kao(:, 2, 3, 2) = (/ &
        & 0.77483e-04,0.15611e-03,0.16950e-03,0.16551e-03,0.15408e-03, &
        & 0.13580e-03,0.11055e-03,0.72020e-04,0.18564e-05 /)
      kao(:, 3, 3, 2) = (/ &
        & 0.77142e-04,0.15867e-03,0.17112e-03,0.16672e-03,0.15481e-03, &
        & 0.13616e-03,0.11077e-03,0.71922e-04,0.20228e-05 /)
      kao(:, 4, 3, 2) = (/ &
        & 0.76460e-04,0.16058e-03,0.17186e-03,0.16717e-03,0.15519e-03, &
        & 0.13641e-03,0.11060e-03,0.71775e-04,0.21717e-05 /)
      kao(:, 5, 3, 2) = (/ &
        & 0.75510e-04,0.16158e-03,0.17210e-03,0.16730e-03,0.15521e-03, &
        & 0.13649e-03,0.11022e-03,0.71516e-04,0.23140e-05 /)
      kao(:, 1, 4, 2) = (/ &
        & 0.65931e-04,0.12940e-03,0.14295e-03,0.14005e-03,0.13095e-03, &
        & 0.11494e-03,0.93656e-04,0.61167e-04,0.17094e-05 /)
      kao(:, 2, 4, 2) = (/ &
        & 0.66090e-04,0.13269e-03,0.14542e-03,0.14233e-03,0.13201e-03, &
        & 0.11558e-03,0.93975e-04,0.61436e-04,0.18527e-05 /)
      kao(:, 3, 4, 2) = (/ &
        & 0.65630e-04,0.13532e-03,0.14717e-03,0.14364e-03,0.13266e-03, &
        & 0.11604e-03,0.94126e-04,0.61467e-04,0.19576e-05 /)
      kao(:, 4, 4, 2) = (/ &
        & 0.64971e-04,0.13708e-03,0.14818e-03,0.14427e-03,0.13304e-03, &
        & 0.11616e-03,0.94152e-04,0.61334e-04,0.20614e-05 /)
      kao(:, 5, 4, 2) = (/ &
        & 0.64122e-04,0.13834e-03,0.14864e-03,0.14451e-03,0.13312e-03, &
        & 0.11638e-03,0.93955e-04,0.61162e-04,0.21640e-05 /)
      kao(:, 1, 5, 2) = (/ &
        & 0.55594e-04,0.10830e-03,0.12068e-03,0.11865e-03,0.11127e-03, &
        & 0.97925e-04,0.79208e-04,0.51842e-04,0.15954e-05 /)
      kao(:, 2, 5, 2) = (/ &
        & 0.55669e-04,0.11117e-03,0.12299e-03,0.12091e-03,0.11248e-03, &
        & 0.98643e-04,0.79433e-04,0.52127e-04,0.16966e-05 /)
      kao(:, 3, 5, 2) = (/ &
        & 0.55430e-04,0.11345e-03,0.12478e-03,0.12235e-03,0.11332e-03, &
        & 0.99117e-04,0.79823e-04,0.52286e-04,0.18304e-05 /)
      kao(:, 4, 5, 2) = (/ &
        & 0.54800e-04,0.11543e-03,0.12601e-03,0.12304e-03,0.11389e-03, &
        & 0.99346e-04,0.79935e-04,0.52275e-04,0.19479e-05 /)
      kao(:, 5, 5, 2) = (/ &
        & 0.54027e-04,0.11665e-03,0.12660e-03,0.12339e-03,0.11410e-03, &
        & 0.99535e-04,0.79840e-04,0.52168e-04,0.20583e-05 /)
      kao(:, 1, 6, 2) = (/ &
        & 0.46500e-04,0.89887e-04,0.10048e-03,0.99161e-04,0.93136e-04, &
        & 0.82279e-04,0.66872e-04,0.43617e-04,0.14730e-05 /)
      kao(:, 2, 6, 2) = (/ &
        & 0.46632e-04,0.92444e-04,0.10271e-03,0.10123e-03,0.94559e-04, &
        & 0.83135e-04,0.67204e-04,0.44046e-04,0.16215e-05 /)
      kao(:, 3, 6, 2) = (/ &
        & 0.46490e-04,0.94415e-04,0.10446e-03,0.10269e-03,0.95387e-04, &
        & 0.83676e-04,0.67579e-04,0.44279e-04,0.17358e-05 /)
      kao(:, 4, 6, 2) = (/ &
        & 0.46004e-04,0.96190e-04,0.10570e-03,0.10346e-03,0.95883e-04, &
        & 0.84038e-04,0.67753e-04,0.44348e-04,0.18096e-05 /)
      kao(:, 5, 6, 2) = (/ &
        & 0.45362e-04,0.97511e-04,0.10645e-03,0.10384e-03,0.96197e-04, &
        & 0.84347e-04,0.67758e-04,0.44305e-04,0.18882e-05 /)
      kao(:, 1, 7, 2) = (/ &
        & 0.38597e-04,0.74019e-04,0.82882e-04,0.81807e-04,0.76936e-04, &
        & 0.68278e-04,0.55744e-04,0.36507e-04,0.13400e-05 /)
      kao(:, 2, 7, 2) = (/ &
        & 0.38728e-04,0.76353e-04,0.85030e-04,0.83822e-04,0.78523e-04, &
        & 0.69221e-04,0.56199e-04,0.36932e-04,0.14766e-05 /)
      kao(:, 3, 7, 2) = (/ &
        & 0.38688e-04,0.78164e-04,0.86691e-04,0.85269e-04,0.79424e-04, &
        & 0.69849e-04,0.56507e-04,0.37211e-04,0.16077e-05 /)
      kao(:, 4, 7, 2) = (/ &
        & 0.38399e-04,0.79654e-04,0.87882e-04,0.86145e-04,0.79917e-04, &
        & 0.70214e-04,0.56698e-04,0.37302e-04,0.17365e-05 /)
      kao(:, 5, 7, 2) = (/ &
        & 0.37899e-04,0.81012e-04,0.88706e-04,0.86589e-04,0.80259e-04, &
        & 0.70429e-04,0.56810e-04,0.37287e-04,0.18595e-05 /)
      kao(:, 1, 8, 2) = (/ &
        & 0.31959e-04,0.60671e-04,0.67963e-04,0.67053e-04,0.63057e-04, &
        & 0.56287e-04,0.46187e-04,0.30298e-04,0.12071e-05 /)
      kao(:, 2, 8, 2) = (/ &
        & 0.32062e-04,0.62753e-04,0.69892e-04,0.68941e-04,0.64624e-04, &
        & 0.57187e-04,0.46566e-04,0.30687e-04,0.13582e-05 /)
      kao(:, 3, 8, 2) = (/ &
        & 0.32098e-04,0.64435e-04,0.71423e-04,0.70359e-04,0.65646e-04, &
        & 0.57882e-04,0.46897e-04,0.30993e-04,0.15217e-05 /)
      kao(:, 4, 8, 2) = (/ &
        & 0.31956e-04,0.65758e-04,0.72650e-04,0.71275e-04,0.66275e-04, &
        & 0.58298e-04,0.47100e-04,0.31079e-04,0.16794e-05 /)
      kao(:, 5, 8, 2) = (/ &
        & 0.31584e-04,0.66916e-04,0.73502e-04,0.71819e-04,0.66611e-04, &
        & 0.58505e-04,0.47243e-04,0.31088e-04,0.18250e-05 /)
      kao(:, 1, 9, 2) = (/ &
        & 0.26355e-04,0.49472e-04,0.55415e-04,0.54584e-04,0.51361e-04, &
        & 0.46135e-04,0.38027e-04,0.24983e-04,0.13549e-05 /)
      kao(:, 2, 9, 2) = (/ &
        & 0.26472e-04,0.51302e-04,0.57165e-04,0.56417e-04,0.52936e-04, &
        & 0.47048e-04,0.38417e-04,0.25347e-04,0.14941e-05 /)
      kao(:, 3, 9, 2) = (/ &
        & 0.26545e-04,0.52866e-04,0.58563e-04,0.57776e-04,0.53988e-04, &
        & 0.47706e-04,0.38739e-04,0.25638e-04,0.16563e-05 /)
      kao(:, 4, 9, 2) = (/ &
        & 0.26469e-04,0.54105e-04,0.59749e-04,0.58746e-04,0.54668e-04, &
        & 0.48161e-04,0.38970e-04,0.25744e-04,0.18262e-05 /)
      kao(:, 5, 9, 2) = (/ &
        & 0.26248e-04,0.55079e-04,0.60619e-04,0.59317e-04,0.55099e-04, &
        & 0.48435e-04,0.39115e-04,0.25778e-04,0.20238e-05 /)
      kao(:, 1,10, 2) = (/ &
        & 0.21631e-04,0.40297e-04,0.45170e-04,0.44298e-04,0.41876e-04, &
        & 0.37690e-04,0.31212e-04,0.20552e-04,0.16328e-05 /)
      kao(:, 2,10, 2) = (/ &
        & 0.21814e-04,0.41896e-04,0.46681e-04,0.46065e-04,0.43227e-04, &
        & 0.38608e-04,0.31614e-04,0.20857e-04,0.18610e-05 /)
      kao(:, 3,10, 2) = (/ &
        & 0.21864e-04,0.43247e-04,0.47945e-04,0.47327e-04,0.44273e-04, &
        & 0.39201e-04,0.31894e-04,0.21119e-04,0.20775e-05 /)
      kao(:, 4,10, 2) = (/ &
        & 0.21835e-04,0.44386e-04,0.48986e-04,0.48228e-04,0.44916e-04, &
        & 0.39637e-04,0.32093e-04,0.21228e-04,0.22541e-05 /)
      kao(:, 5,10, 2) = (/ &
        & 0.21728e-04,0.45263e-04,0.49804e-04,0.48818e-04,0.45409e-04, &
        & 0.39950e-04,0.32269e-04,0.21290e-04,0.24525e-05 /)
      kao(:, 1,11, 2) = (/ &
        & 0.17823e-04,0.33378e-04,0.37337e-04,0.36619e-04,0.34598e-04, &
        & 0.31113e-04,0.25761e-04,0.16956e-04,0.15042e-05 /)
      kao(:, 2,11, 2) = (/ &
        & 0.17970e-04,0.34679e-04,0.38589e-04,0.38065e-04,0.35695e-04, &
        & 0.31869e-04,0.26044e-04,0.17214e-04,0.16847e-05 /)
      kao(:, 3,11, 2) = (/ &
        & 0.17997e-04,0.35791e-04,0.39619e-04,0.39097e-04,0.36539e-04, &
        & 0.32374e-04,0.26298e-04,0.17428e-04,0.18887e-05 /)
      kao(:, 4,11, 2) = (/ &
        & 0.17967e-04,0.36717e-04,0.40463e-04,0.39821e-04,0.37071e-04, &
        & 0.32716e-04,0.26461e-04,0.17496e-04,0.20546e-05 /)
      kao(:, 5,11, 2) = (/ &
        & 0.17868e-04,0.37423e-04,0.41124e-04,0.40304e-04,0.37473e-04, &
        & 0.32971e-04,0.26612e-04,0.17532e-04,0.22240e-05 /)
      kao(:, 1,12, 2) = (/ &
        & 0.14665e-04,0.27605e-04,0.30811e-04,0.30250e-04,0.28525e-04, &
        & 0.25644e-04,0.21186e-04,0.13955e-04,0.12588e-05 /)
      kao(:, 2,12, 2) = (/ &
        & 0.14775e-04,0.28655e-04,0.31851e-04,0.31408e-04,0.29418e-04, &
        & 0.26261e-04,0.21430e-04,0.14172e-04,0.14181e-05 /)
      kao(:, 3,12, 2) = (/ &
        & 0.14799e-04,0.29571e-04,0.32687e-04,0.32242e-04,0.30093e-04, &
        & 0.26683e-04,0.21636e-04,0.14338e-04,0.15619e-05 /)
      kao(:, 4,12, 2) = (/ &
        & 0.14777e-04,0.30325e-04,0.33371e-04,0.32826e-04,0.30553e-04, &
        & 0.26945e-04,0.21775e-04,0.14380e-04,0.16917e-05 /)
      kao(:, 5,12, 2) = (/ &
        & 0.14685e-04,0.30904e-04,0.33907e-04,0.33214e-04,0.30875e-04, &
        & 0.27158e-04,0.21883e-04,0.14414e-04,0.18423e-05 /)
      kao(:, 1,13, 2) = (/ &
        & 0.12044e-04,0.22772e-04,0.25375e-04,0.24926e-04,0.23458e-04, &
        & 0.21059e-04,0.17387e-04,0.11457e-04,0.99122e-06 /)
      kao(:, 2,13, 2) = (/ &
        & 0.12128e-04,0.23637e-04,0.26249e-04,0.25842e-04,0.24187e-04, &
        & 0.21582e-04,0.17590e-04,0.11636e-04,0.11037e-05 /)
      kao(:, 3,13, 2) = (/ &
        & 0.12152e-04,0.24386e-04,0.26910e-04,0.26531e-04,0.24731e-04, &
        & 0.21923e-04,0.17760e-04,0.11755e-04,0.12026e-05 /)
      kao(:, 4,13, 2) = (/ &
        & 0.12130e-04,0.24996e-04,0.27464e-04,0.27006e-04,0.25113e-04, &
        & 0.22138e-04,0.17874e-04,0.11797e-04,0.13028e-05 /)
      kao(:, 5,13, 2) = (/ &
        & 0.12050e-04,0.25474e-04,0.27895e-04,0.27297e-04,0.25373e-04, &
        & 0.22302e-04,0.17948e-04,0.11817e-04,0.14010e-05 /)
      kao(:, 1, 1, 3) = (/ &
        & 0.36823e-03,0.49613e-03,0.51817e-03,0.50538e-03,0.45711e-03, &
        & 0.39605e-03,0.31486e-03,0.21474e-03,0.10932e-04 /)
      kao(:, 2, 1, 3) = (/ &
        & 0.37008e-03,0.50778e-03,0.53361e-03,0.51778e-03,0.46995e-03, &
        & 0.40629e-03,0.32309e-03,0.21878e-03,0.11421e-04 /)
      kao(:, 3, 1, 3) = (/ &
        & 0.36989e-03,0.51812e-03,0.54699e-03,0.52922e-03,0.48036e-03, &
        & 0.41559e-03,0.32965e-03,0.22226e-03,0.12395e-04 /)
      kao(:, 4, 1, 3) = (/ &
        & 0.36721e-03,0.52763e-03,0.55746e-03,0.53957e-03,0.48891e-03, &
        & 0.42313e-03,0.33545e-03,0.22588e-03,0.13515e-04 /)
      kao(:, 5, 1, 3) = (/ &
        & 0.36313e-03,0.53652e-03,0.56680e-03,0.54791e-03,0.49664e-03, &
        & 0.42907e-03,0.34043e-03,0.22916e-03,0.14734e-04 /)
      kao(:, 1, 2, 3) = (/ &
        & 0.32411e-03,0.42815e-03,0.44725e-03,0.43813e-03,0.40150e-03, &
        & 0.34871e-03,0.27912e-03,0.18929e-03,0.80741e-05 /)
      kao(:, 2, 2, 3) = (/ &
        & 0.32567e-03,0.43786e-03,0.46069e-03,0.45027e-03,0.41319e-03, &
        & 0.35819e-03,0.28635e-03,0.19325e-03,0.87340e-05 /)
      kao(:, 3, 2, 3) = (/ &
        & 0.32429e-03,0.44638e-03,0.47228e-03,0.46074e-03,0.42272e-03, &
        & 0.36602e-03,0.29201e-03,0.19653e-03,0.96110e-05 /)
      kao(:, 4, 2, 3) = (/ &
        & 0.32137e-03,0.45531e-03,0.48142e-03,0.46951e-03,0.42996e-03, &
        & 0.37250e-03,0.29709e-03,0.19974e-03,0.10697e-04 /)
      kao(:, 5, 2, 3) = (/ &
        & 0.31776e-03,0.46207e-03,0.48880e-03,0.47659e-03,0.43551e-03, &
        & 0.37776e-03,0.30138e-03,0.20274e-03,0.11704e-04 /)
      kao(:, 1, 3, 3) = (/ &
        & 0.28488e-03,0.36767e-03,0.38081e-03,0.37438e-03,0.34525e-03, &
        & 0.30150e-03,0.24332e-03,0.16415e-03,0.63970e-05 /)
      kao(:, 2, 3, 3) = (/ &
        & 0.28539e-03,0.37509e-03,0.39196e-03,0.38510e-03,0.35566e-03, &
        & 0.30998e-03,0.24963e-03,0.16766e-03,0.72006e-05 /)
      kao(:, 3, 3, 3) = (/ &
        & 0.28397e-03,0.38215e-03,0.40156e-03,0.39428e-03,0.36418e-03, &
        & 0.31727e-03,0.25446e-03,0.17107e-03,0.79574e-05 /)
      kao(:, 4, 3, 3) = (/ &
        & 0.28134e-03,0.38867e-03,0.40959e-03,0.40230e-03,0.37093e-03, &
        & 0.32301e-03,0.25898e-03,0.17447e-03,0.87131e-05 /)
      kao(:, 5, 3, 3) = (/ &
        & 0.27886e-03,0.39360e-03,0.41642e-03,0.40852e-03,0.37609e-03, &
        & 0.32740e-03,0.26312e-03,0.17737e-03,0.94704e-05 /)
      kao(:, 1, 4, 3) = (/ &
        & 0.24923e-03,0.31555e-03,0.32423e-03,0.31731e-03,0.29410e-03, &
        & 0.25671e-03,0.20762e-03,0.14074e-03,0.55877e-05 /)
      kao(:, 2, 4, 3) = (/ &
        & 0.24977e-03,0.32120e-03,0.33372e-03,0.32657e-03,0.30295e-03, &
        & 0.26472e-03,0.21303e-03,0.14396e-03,0.61575e-05 /)
      kao(:, 3, 4, 3) = (/ &
        & 0.24865e-03,0.32668e-03,0.34180e-03,0.33446e-03,0.31033e-03, &
        & 0.27144e-03,0.21777e-03,0.14714e-03,0.67916e-05 /)
      kao(:, 4, 4, 3) = (/ &
        & 0.24709e-03,0.33133e-03,0.34841e-03,0.34134e-03,0.31600e-03, &
        & 0.27647e-03,0.22179e-03,0.15016e-03,0.74653e-05 /)
      kao(:, 5, 4, 3) = (/ &
        & 0.24455e-03,0.33491e-03,0.35388e-03,0.34708e-03,0.32069e-03, &
        & 0.28005e-03,0.22522e-03,0.15242e-03,0.81619e-05 /)
      kao(:, 1, 5, 3) = (/ &
        & 0.21526e-03,0.27115e-03,0.27505e-03,0.26802e-03,0.24968e-03, &
        & 0.21690e-03,0.17481e-03,0.11906e-03,0.50850e-05 /)
      kao(:, 2, 5, 3) = (/ &
        & 0.21611e-03,0.27621e-03,0.28298e-03,0.27620e-03,0.25722e-03, &
        & 0.22411e-03,0.18004e-03,0.12197e-03,0.55738e-05 /)
      kao(:, 3, 5, 3) = (/ &
        & 0.21583e-03,0.28060e-03,0.28955e-03,0.28282e-03,0.26346e-03, &
        & 0.23005e-03,0.18415e-03,0.12451e-03,0.60864e-05 /)
      kao(:, 4, 5, 3) = (/ &
        & 0.21446e-03,0.28363e-03,0.29469e-03,0.28896e-03,0.26860e-03, &
        & 0.23435e-03,0.18768e-03,0.12690e-03,0.66417e-05 /)
      kao(:, 5, 5, 3) = (/ &
        & 0.21217e-03,0.28626e-03,0.29929e-03,0.29370e-03,0.27250e-03, &
        & 0.23763e-03,0.19073e-03,0.12909e-03,0.72122e-05 /)
      kao(:, 1, 6, 3) = (/ &
        & 0.18262e-03,0.23112e-03,0.23388e-03,0.22681e-03,0.21062e-03, &
        & 0.18196e-03,0.14634e-03,0.99707e-04,0.48078e-05 /)
      kao(:, 2, 6, 3) = (/ &
        & 0.18393e-03,0.23591e-03,0.24094e-03,0.23364e-03,0.21663e-03, &
        & 0.18814e-03,0.15114e-03,0.10205e-03,0.52252e-05 /)
      kao(:, 3, 6, 3) = (/ &
        & 0.18379e-03,0.23984e-03,0.24676e-03,0.23956e-03,0.22221e-03, &
        & 0.19356e-03,0.15489e-03,0.10434e-03,0.56405e-05 /)
      kao(:, 4, 6, 3) = (/ &
        & 0.18270e-03,0.24258e-03,0.25102e-03,0.24458e-03,0.22685e-03, &
        & 0.19771e-03,0.15805e-03,0.10655e-03,0.60728e-05 /)
      kao(:, 5, 6, 3) = (/ &
        & 0.18067e-03,0.24446e-03,0.25467e-03,0.24894e-03,0.23051e-03, &
        & 0.20056e-03,0.16088e-03,0.10844e-03,0.65160e-05 /)
      kao(:, 1, 7, 3) = (/ &
        & 0.15269e-03,0.19407e-03,0.19640e-03,0.19073e-03,0.17715e-03, &
        & 0.15224e-03,0.12181e-03,0.83302e-04,0.45185e-05 /)
      kao(:, 2, 7, 3) = (/ &
        & 0.15450e-03,0.19834e-03,0.20246e-03,0.19675e-03,0.18242e-03, &
        & 0.15776e-03,0.12610e-03,0.85306e-04,0.49315e-05 /)
      kao(:, 3, 7, 3) = (/ &
        & 0.15459e-03,0.20178e-03,0.20759e-03,0.20176e-03,0.18737e-03, &
        & 0.16233e-03,0.12951e-03,0.87417e-04,0.53491e-05 /)
      kao(:, 4, 7, 3) = (/ &
        & 0.15368e-03,0.20410e-03,0.21160e-03,0.20623e-03,0.19161e-03, &
        & 0.16603e-03,0.13246e-03,0.89237e-04,0.57562e-05 /)
      kao(:, 5, 7, 3) = (/ &
        & 0.15207e-03,0.20567e-03,0.21458e-03,0.20991e-03,0.19525e-03, &
        & 0.16906e-03,0.13481e-03,0.90932e-04,0.61659e-05 /)
      kao(:, 1, 8, 3) = (/ &
        & 0.12672e-03,0.16159e-03,0.16329e-03,0.15821e-03,0.14746e-03, &
        & 0.12624e-03,0.10116e-03,0.69306e-04,0.46652e-05 /)
      kao(:, 2, 8, 3) = (/ &
        & 0.12853e-03,0.16539e-03,0.16859e-03,0.16359e-03,0.15208e-03, &
        & 0.13120e-03,0.10513e-03,0.71005e-04,0.51392e-05 /)
      kao(:, 3, 8, 3) = (/ &
        & 0.12901e-03,0.16841e-03,0.17301e-03,0.16813e-03,0.15614e-03, &
        & 0.13532e-03,0.10829e-03,0.72863e-04,0.55244e-05 /)
      kao(:, 4, 8, 3) = (/ &
        & 0.12833e-03,0.17058e-03,0.17652e-03,0.17184e-03,0.15971e-03, &
        & 0.13867e-03,0.11087e-03,0.74475e-04,0.58193e-05 /)
      kao(:, 5, 8, 3) = (/ &
        & 0.12715e-03,0.17197e-03,0.17918e-03,0.17513e-03,0.16292e-03, &
        & 0.14144e-03,0.11301e-03,0.75965e-04,0.61705e-05 /)
      kao(:, 1, 9, 3) = (/ &
        & 0.10428e-03,0.13348e-03,0.13462e-03,0.12995e-03,0.12158e-03, &
        & 0.10379e-03,0.83005e-04,0.57371e-04,0.55965e-05 /)
      kao(:, 2, 9, 3) = (/ &
        & 0.10619e-03,0.13710e-03,0.13932e-03,0.13469e-03,0.12538e-03, &
        & 0.10800e-03,0.86632e-04,0.58954e-04,0.61961e-05 /)
      kao(:, 3, 9, 3) = (/ &
        & 0.10690e-03,0.13978e-03,0.14315e-03,0.13877e-03,0.12885e-03, &
        & 0.11169e-03,0.89643e-04,0.60568e-04,0.68526e-05 /)
      kao(:, 4, 9, 3) = (/ &
        & 0.10668e-03,0.14178e-03,0.14626e-03,0.14213e-03,0.13207e-03, &
        & 0.11468e-03,0.91984e-04,0.62070e-04,0.75122e-05 /)
      kao(:, 5, 9, 3) = (/ &
        & 0.10582e-03,0.14316e-03,0.14873e-03,0.14501e-03,0.13471e-03, &
        & 0.11704e-03,0.93876e-04,0.63388e-04,0.80761e-05 /)
      kao(:, 1,10, 3) = (/ &
        & 0.85476e-04,0.10982e-03,0.11034e-03,0.10643e-03,0.99702e-04, &
        & 0.84967e-04,0.68008e-04,0.47229e-04,0.66145e-05 /)
      kao(:, 2,10, 3) = (/ &
        & 0.87242e-04,0.11322e-03,0.11463e-03,0.11045e-03,0.10293e-03, &
        & 0.88580e-04,0.71113e-04,0.48631e-04,0.75452e-05 /)
      kao(:, 3,10, 3) = (/ &
        & 0.88111e-04,0.11563e-03,0.11792e-03,0.11404e-03,0.10587e-03, &
        & 0.91877e-04,0.73790e-04,0.50044e-04,0.84881e-05 /)
      kao(:, 4,10, 3) = (/ &
        & 0.88200e-04,0.11743e-03,0.12065e-03,0.11708e-03,0.10870e-03, &
        & 0.94480e-04,0.75897e-04,0.51384e-04,0.95136e-05 /)
      kao(:, 5,10, 3) = (/ &
        & 0.87583e-04,0.11871e-03,0.12292e-03,0.11954e-03,0.11103e-03, &
        & 0.96523e-04,0.77526e-04,0.52518e-04,0.10532e-04 /)
      kao(:, 1,11, 3) = (/ &
        & 0.70556e-04,0.91428e-04,0.91867e-04,0.88463e-04,0.82846e-04, &
        & 0.70774e-04,0.56632e-04,0.39167e-04,0.61872e-05 /)
      kao(:, 2,11, 3) = (/ &
        & 0.71933e-04,0.94182e-04,0.95269e-04,0.91646e-04,0.85383e-04, &
        & 0.73738e-04,0.59219e-04,0.40474e-04,0.69965e-05 /)
      kao(:, 3,11, 3) = (/ &
        & 0.72567e-04,0.96098e-04,0.97927e-04,0.94606e-04,0.87837e-04, &
        & 0.76370e-04,0.61326e-04,0.41633e-04,0.78235e-05 /)
      kao(:, 4,11, 3) = (/ &
        & 0.72529e-04,0.97532e-04,0.10011e-03,0.97076e-04,0.90134e-04, &
        & 0.78428e-04,0.63016e-04,0.42754e-04,0.87904e-05 /)
      kao(:, 5,11, 3) = (/ &
        & 0.71990e-04,0.98552e-04,0.10193e-03,0.99080e-04,0.92091e-04, &
        & 0.80068e-04,0.64349e-04,0.43674e-04,0.98011e-05 /)
      kao(:, 1,12, 3) = (/ &
        & 0.58072e-04,0.75815e-04,0.76168e-04,0.73252e-04,0.68521e-04, &
        & 0.58748e-04,0.47029e-04,0.32430e-04,0.51838e-05 /)
      kao(:, 2,12, 3) = (/ &
        & 0.59149e-04,0.78005e-04,0.78889e-04,0.75853e-04,0.70691e-04, &
        & 0.61160e-04,0.49105e-04,0.33572e-04,0.58669e-05 /)
      kao(:, 3,12, 3) = (/ &
        & 0.59615e-04,0.79572e-04,0.81043e-04,0.78301e-04,0.72716e-04, &
        & 0.63265e-04,0.50777e-04,0.34506e-04,0.66464e-05 /)
      kao(:, 4,12, 3) = (/ &
        & 0.59506e-04,0.80712e-04,0.82811e-04,0.80321e-04,0.74571e-04, &
        & 0.64935e-04,0.52165e-04,0.35447e-04,0.74412e-05 /)
      kao(:, 5,12, 3) = (/ &
        & 0.59067e-04,0.81520e-04,0.84288e-04,0.81977e-04,0.76172e-04, &
        & 0.66259e-04,0.53281e-04,0.36178e-04,0.82465e-05 /)
      kao(:, 1,13, 3) = (/ &
        & 0.47640e-04,0.62583e-04,0.62887e-04,0.60485e-04,0.56559e-04, &
        & 0.48624e-04,0.38904e-04,0.26773e-04,0.40582e-05 /)
      kao(:, 2,13, 3) = (/ &
        & 0.48498e-04,0.64379e-04,0.65087e-04,0.62641e-04,0.58377e-04, &
        & 0.50572e-04,0.40566e-04,0.27717e-04,0.46616e-05 /)
      kao(:, 3,13, 3) = (/ &
        & 0.48844e-04,0.65656e-04,0.66851e-04,0.64628e-04,0.60042e-04, &
        & 0.52254e-04,0.41917e-04,0.28510e-04,0.53204e-05 /)
      kao(:, 4,13, 3) = (/ &
        & 0.48722e-04,0.66574e-04,0.68303e-04,0.66300e-04,0.61547e-04, &
        & 0.53614e-04,0.43058e-04,0.29254e-04,0.59442e-05 /)
      kao(:, 5,13, 3) = (/ &
        & 0.48355e-04,0.67217e-04,0.69511e-04,0.67651e-04,0.62864e-04, &
        & 0.54712e-04,0.43998e-04,0.29875e-04,0.66436e-05 /)
      kao(:, 1, 1, 4) = (/ &
        & 0.85387e-03,0.97268e-03,0.95201e-03,0.89226e-03,0.81465e-03, &
        & 0.69707e-03,0.54829e-03,0.35882e-03,0.37920e-04 /)
      kao(:, 2, 1, 4) = (/ &
        & 0.85496e-03,0.98746e-03,0.97188e-03,0.91775e-03,0.83529e-03, &
        & 0.71649e-03,0.56376e-03,0.37061e-03,0.43155e-04 /)
      kao(:, 3, 1, 4) = (/ &
        & 0.85154e-03,0.99908e-03,0.98969e-03,0.94014e-03,0.85604e-03, &
        & 0.73379e-03,0.57832e-03,0.38183e-03,0.48702e-04 /)
      kao(:, 4, 1, 4) = (/ &
        & 0.84606e-03,0.10090e-02,0.10068e-02,0.95944e-03,0.87434e-03, &
        & 0.74975e-03,0.59243e-03,0.39188e-03,0.54022e-04 /)
      kao(:, 5, 1, 4) = (/ &
        & 0.84061e-03,0.10171e-02,0.10218e-02,0.97684e-03,0.88906e-03, &
        & 0.76345e-03,0.60471e-03,0.40180e-03,0.59778e-04 /)
      kao(:, 1, 2, 4) = (/ &
        & 0.76106e-03,0.86763e-03,0.84620e-03,0.79337e-03,0.72368e-03, &
        & 0.62633e-03,0.49168e-03,0.32346e-03,0.31322e-04 /)
      kao(:, 2, 2, 4) = (/ &
        & 0.76153e-03,0.88148e-03,0.86349e-03,0.81559e-03,0.74480e-03, &
        & 0.64448e-03,0.50635e-03,0.33430e-03,0.35566e-04 /)
      kao(:, 3, 2, 4) = (/ &
        & 0.75977e-03,0.89195e-03,0.87871e-03,0.83605e-03,0.76286e-03, &
        & 0.66127e-03,0.51959e-03,0.34472e-03,0.39705e-04 /)
      kao(:, 4, 2, 4) = (/ &
        & 0.75771e-03,0.89987e-03,0.89406e-03,0.85530e-03,0.78123e-03, &
        & 0.67612e-03,0.53221e-03,0.35447e-03,0.44266e-04 /)
      kao(:, 5, 2, 4) = (/ &
        & 0.75289e-03,0.90657e-03,0.90771e-03,0.87200e-03,0.79715e-03, &
        & 0.68926e-03,0.54382e-03,0.36372e-03,0.48708e-04 /)
      kao(:, 1, 3, 4) = (/ &
        & 0.66893e-03,0.76246e-03,0.74334e-03,0.69752e-03,0.63501e-03, &
        & 0.55362e-03,0.43455e-03,0.28843e-03,0.24260e-04 /)
      kao(:, 2, 3, 4) = (/ &
        & 0.67118e-03,0.77588e-03,0.75944e-03,0.71710e-03,0.65461e-03, &
        & 0.57122e-03,0.44991e-03,0.29906e-03,0.27434e-04 /)
      kao(:, 3, 3, 4) = (/ &
        & 0.67218e-03,0.78505e-03,0.77328e-03,0.73497e-03,0.67286e-03, &
        & 0.58718e-03,0.46375e-03,0.30933e-03,0.30808e-04 /)
      kao(:, 4, 3, 4) = (/ &
        & 0.67058e-03,0.79242e-03,0.78627e-03,0.75181e-03,0.68946e-03, &
        & 0.60183e-03,0.47532e-03,0.31743e-03,0.34324e-04 /)
      kao(:, 5, 3, 4) = (/ &
        & 0.66467e-03,0.79822e-03,0.79776e-03,0.76779e-03,0.70481e-03, &
        & 0.61510e-03,0.48553e-03,0.32526e-03,0.37905e-04 /)
      kao(:, 1, 4, 4) = (/ &
        & 0.58297e-03,0.66020e-03,0.64337e-03,0.60610e-03,0.55222e-03, &
        & 0.48338e-03,0.38154e-03,0.25537e-03,0.20054e-04 /)
      kao(:, 2, 4, 4) = (/ &
        & 0.58616e-03,0.67311e-03,0.65764e-03,0.62362e-03,0.56996e-03, &
        & 0.49939e-03,0.39657e-03,0.26418e-03,0.22457e-04 /)
      kao(:, 3, 4, 4) = (/ &
        & 0.58719e-03,0.68291e-03,0.67014e-03,0.63926e-03,0.58703e-03, &
        & 0.51453e-03,0.40976e-03,0.27280e-03,0.24974e-04 /)
      kao(:, 4, 4, 4) = (/ &
        & 0.58451e-03,0.68925e-03,0.68144e-03,0.65410e-03,0.60312e-03, &
        & 0.52903e-03,0.42147e-03,0.28096e-03,0.27613e-04 /)
      kao(:, 5, 4, 4) = (/ &
        & 0.57885e-03,0.69369e-03,0.69153e-03,0.66725e-03,0.61666e-03, &
        & 0.54114e-03,0.43123e-03,0.28907e-03,0.30243e-04 /)
      kao(:, 1, 5, 4) = (/ &
        & 0.50639e-03,0.56897e-03,0.55412e-03,0.52127e-03,0.47341e-03, &
        & 0.41669e-03,0.33293e-03,0.22215e-03,0.17057e-04 /)
      kao(:, 2, 5, 4) = (/ &
        & 0.51065e-03,0.58111e-03,0.56740e-03,0.53642e-03,0.48970e-03, &
        & 0.43166e-03,0.34671e-03,0.23111e-03,0.19191e-04 /)
      kao(:, 3, 5, 4) = (/ &
        & 0.51131e-03,0.58923e-03,0.57802e-03,0.54989e-03,0.50519e-03, &
        & 0.44520e-03,0.35867e-03,0.23955e-03,0.21238e-04 /)
      kao(:, 4, 5, 4) = (/ &
        & 0.50888e-03,0.59432e-03,0.58700e-03,0.56238e-03,0.51899e-03, &
        & 0.45787e-03,0.36960e-03,0.24733e-03,0.23442e-04 /)
      kao(:, 5, 5, 4) = (/ &
        & 0.50411e-03,0.59804e-03,0.59497e-03,0.57342e-03,0.53158e-03, &
        & 0.46924e-03,0.37886e-03,0.25450e-03,0.25756e-04 /)
      kao(:, 1, 6, 4) = (/ &
        & 0.43673e-03,0.48782e-03,0.47499e-03,0.44629e-03,0.40354e-03, &
        & 0.35457e-03,0.28605e-03,0.19086e-03,0.14702e-04 /)
      kao(:, 2, 6, 4) = (/ &
        & 0.44102e-03,0.49831e-03,0.48639e-03,0.45943e-03,0.41879e-03, &
        & 0.36808e-03,0.29802e-03,0.19985e-03,0.16471e-04 /)
      kao(:, 3, 6, 4) = (/ &
        & 0.44221e-03,0.50518e-03,0.49538e-03,0.47075e-03,0.43183e-03, &
        & 0.37995e-03,0.30882e-03,0.20763e-03,0.18420e-04 /)
      kao(:, 4, 6, 4) = (/ &
        & 0.44017e-03,0.50994e-03,0.50323e-03,0.48141e-03,0.44360e-03, &
        & 0.39116e-03,0.31844e-03,0.21460e-03,0.20473e-04 /)
      kao(:, 5, 6, 4) = (/ &
        & 0.43656e-03,0.51249e-03,0.51000e-03,0.49068e-03,0.45425e-03, &
        & 0.40107e-03,0.32653e-03,0.22109e-03,0.22600e-04 /)
      kao(:, 1, 7, 4) = (/ &
        & 0.37627e-03,0.41525e-03,0.40365e-03,0.37923e-03,0.34257e-03, &
        & 0.30147e-03,0.24324e-03,0.16094e-03,0.13400e-04 /)
      kao(:, 2, 7, 4) = (/ &
        & 0.38051e-03,0.42489e-03,0.41400e-03,0.39067e-03,0.35555e-03, &
        & 0.31257e-03,0.25353e-03,0.16947e-03,0.14905e-04 /)
      kao(:, 3, 7, 4) = (/ &
        & 0.38196e-03,0.43154e-03,0.42169e-03,0.40035e-03,0.36703e-03, &
        & 0.32311e-03,0.26291e-03,0.17672e-03,0.16566e-04 /)
      kao(:, 4, 7, 4) = (/ &
        & 0.38108e-03,0.43587e-03,0.42809e-03,0.40890e-03,0.37694e-03, &
        & 0.33246e-03,0.27094e-03,0.18305e-03,0.18352e-04 /)
      kao(:, 5, 7, 4) = (/ &
        & 0.37854e-03,0.43889e-03,0.43402e-03,0.41697e-03,0.38532e-03, &
        & 0.34074e-03,0.27816e-03,0.18873e-03,0.20220e-04 /)
      kao(:, 1, 8, 4) = (/ &
        & 0.31968e-03,0.35301e-03,0.34310e-03,0.32206e-03,0.28904e-03, &
        & 0.25356e-03,0.20523e-03,0.13432e-03,0.13548e-04 /)
      kao(:, 2, 8, 4) = (/ &
        & 0.32386e-03,0.36229e-03,0.35288e-03,0.33214e-03,0.30033e-03, &
        & 0.26345e-03,0.21374e-03,0.14198e-03,0.14966e-04 /)
      kao(:, 3, 8, 4) = (/ &
        & 0.32521e-03,0.36848e-03,0.35986e-03,0.34056e-03,0.31042e-03, &
        & 0.27222e-03,0.22115e-03,0.14841e-03,0.16278e-04 /)
      kao(:, 4, 8, 4) = (/ &
        & 0.32527e-03,0.37258e-03,0.36553e-03,0.34811e-03,0.31916e-03, &
        & 0.28034e-03,0.22837e-03,0.15443e-03,0.17614e-04 /)
      kao(:, 5, 8, 4) = (/ &
        & 0.32272e-03,0.37533e-03,0.37025e-03,0.35438e-03,0.32632e-03, &
        & 0.28740e-03,0.23484e-03,0.15952e-03,0.19075e-04 /)
      kao(:, 1, 9, 4) = (/ &
        & 0.26794e-03,0.29655e-03,0.28851e-03,0.27155e-03,0.24290e-03, &
        & 0.21182e-03,0.17187e-03,0.11158e-03,0.16893e-04 /)
      kao(:, 2, 9, 4) = (/ &
        & 0.27215e-03,0.30477e-03,0.29765e-03,0.28075e-03,0.25336e-03, &
        & 0.22120e-03,0.17858e-03,0.11794e-03,0.18576e-04 /)
      kao(:, 3, 9, 4) = (/ &
        & 0.27400e-03,0.31061e-03,0.30447e-03,0.28836e-03,0.26224e-03, &
        & 0.22886e-03,0.18474e-03,0.12372e-03,0.20056e-04 /)
      kao(:, 4, 9, 4) = (/ &
        & 0.27385e-03,0.31424e-03,0.30923e-03,0.29477e-03,0.26977e-03, &
        & 0.23554e-03,0.19093e-03,0.12884e-03,0.21321e-04 /)
      kao(:, 5, 9, 4) = (/ &
        & 0.27196e-03,0.31647e-03,0.31308e-03,0.30006e-03,0.27604e-03, &
        & 0.24191e-03,0.19649e-03,0.13352e-03,0.22611e-04 /)
      kao(:, 1,10, 4) = (/ &
        & 0.22255e-03,0.24716e-03,0.24087e-03,0.22672e-03,0.20216e-03, &
        & 0.17582e-03,0.14339e-03,0.92528e-04,0.22471e-04 /)
      kao(:, 2,10, 4) = (/ &
        & 0.22663e-03,0.25429e-03,0.24908e-03,0.23506e-03,0.21167e-03, &
        & 0.18377e-03,0.14910e-03,0.97972e-04,0.24536e-04 /)
      kao(:, 3,10, 4) = (/ &
        & 0.22867e-03,0.25963e-03,0.25532e-03,0.24169e-03,0.21923e-03, &
        & 0.19067e-03,0.15458e-03,0.10293e-03,0.26453e-04 /)
      kao(:, 4,10, 4) = (/ &
        & 0.22853e-03,0.26273e-03,0.25960e-03,0.24704e-03,0.22549e-03, &
        & 0.19679e-03,0.15968e-03,0.10728e-03,0.28383e-04 /)
      kao(:, 5,10, 4) = (/ &
        & 0.22704e-03,0.26469e-03,0.26259e-03,0.25141e-03,0.23080e-03, &
        & 0.20216e-03,0.16433e-03,0.11116e-03,0.30111e-04 /)
      kao(:, 1,11, 4) = (/ &
        & 0.18570e-03,0.20791e-03,0.20310e-03,0.19106e-03,0.17066e-03, &
        & 0.14797e-03,0.12097e-03,0.78704e-04,0.20720e-04 /)
      kao(:, 2,11, 4) = (/ &
        & 0.18868e-03,0.21356e-03,0.20969e-03,0.19807e-03,0.17821e-03, &
        & 0.15434e-03,0.12584e-03,0.83179e-04,0.23268e-04 /)
      kao(:, 3,11, 4) = (/ &
        & 0.18972e-03,0.21732e-03,0.21447e-03,0.20305e-03,0.18416e-03, &
        & 0.15993e-03,0.13006e-03,0.87134e-04,0.25781e-04 /)
      kao(:, 4,11, 4) = (/ &
        & 0.18929e-03,0.21955e-03,0.21771e-03,0.20711e-03,0.18907e-03, &
        & 0.16493e-03,0.13420e-03,0.90699e-04,0.28181e-04 /)
      kao(:, 5,11, 4) = (/ &
        & 0.18766e-03,0.22095e-03,0.21987e-03,0.21045e-03,0.19312e-03, &
        & 0.16934e-03,0.13812e-03,0.93840e-04,0.30489e-04 /)
      kao(:, 1,12, 4) = (/ &
        & 0.15409e-03,0.17399e-03,0.17010e-03,0.16002e-03,0.14311e-03, &
        & 0.12376e-03,0.10121e-03,0.66428e-04,0.17813e-04 /)
      kao(:, 2,12, 4) = (/ &
        & 0.15599e-03,0.17831e-03,0.17521e-03,0.16554e-03,0.14890e-03, &
        & 0.12881e-03,0.10527e-03,0.69964e-04,0.19918e-04 /)
      kao(:, 3,12, 4) = (/ &
        & 0.15661e-03,0.18119e-03,0.17892e-03,0.16934e-03,0.15365e-03, &
        & 0.13338e-03,0.10864e-03,0.73142e-04,0.22121e-04 /)
      kao(:, 4,12, 4) = (/ &
        & 0.15608e-03,0.18293e-03,0.18145e-03,0.17254e-03,0.15743e-03, &
        & 0.13747e-03,0.11209e-03,0.75971e-04,0.24425e-04 /)
      kao(:, 5,12, 4) = (/ &
        & 0.15453e-03,0.18383e-03,0.18309e-03,0.17510e-03,0.16067e-03, &
        & 0.14102e-03,0.11529e-03,0.78607e-04,0.26791e-04 /)
      kao(:, 1,13, 4) = (/ &
        & 0.12705e-03,0.14485e-03,0.14155e-03,0.13312e-03,0.11914e-03, &
        & 0.10299e-03,0.84416e-04,0.55598e-04,0.14429e-04 /)
      kao(:, 2,13, 4) = (/ &
        & 0.12843e-03,0.14822e-03,0.14555e-03,0.13748e-03,0.12377e-03, &
        & 0.10702e-03,0.87520e-04,0.58405e-04,0.16147e-04 /)
      kao(:, 3,13, 4) = (/ &
        & 0.12875e-03,0.15043e-03,0.14850e-03,0.14053e-03,0.12752e-03, &
        & 0.11081e-03,0.90348e-04,0.60934e-04,0.17992e-04 /)
      kao(:, 4,13, 4) = (/ &
        & 0.12822e-03,0.15175e-03,0.15049e-03,0.14301e-03,0.13059e-03, &
        & 0.11413e-03,0.93171e-04,0.63296e-04,0.19888e-04 /)
      kao(:, 5,13, 4) = (/ &
        & 0.12684e-03,0.15239e-03,0.15179e-03,0.14511e-03,0.13320e-03, &
        & 0.11702e-03,0.95786e-04,0.65468e-04,0.21706e-04 /)
      kao(:, 1, 1, 5) = (/ &
        & 0.16451e-02,0.17375e-02,0.16665e-02,0.15396e-02,0.13696e-02, &
        & 0.11731e-02,0.92753e-03,0.61159e-03,0.14680e-03 /)
      kao(:, 2, 1, 5) = (/ &
        & 0.16450e-02,0.17591e-02,0.16954e-02,0.15711e-02,0.14087e-02, &
        & 0.12092e-02,0.95859e-03,0.63308e-03,0.16131e-03 /)
      kao(:, 3, 1, 5) = (/ &
        & 0.16396e-02,0.17762e-02,0.17200e-02,0.16012e-02,0.14448e-02, &
        & 0.12424e-02,0.98862e-03,0.65400e-03,0.17365e-03 /)
      kao(:, 4, 1, 5) = (/ &
        & 0.16299e-02,0.17875e-02,0.17415e-02,0.16313e-02,0.14788e-02, &
        & 0.12751e-02,0.10161e-02,0.67524e-03,0.18499e-03 /)
      kao(:, 5, 1, 5) = (/ &
        & 0.16127e-02,0.17946e-02,0.17629e-02,0.16594e-02,0.15119e-02, &
        & 0.13059e-02,0.10419e-02,0.69511e-03,0.19999e-03 /)
      kao(:, 1, 2, 5) = (/ &
        & 0.15084e-02,0.15931e-02,0.15186e-02,0.13958e-02,0.12369e-02, &
        & 0.10500e-02,0.83688e-03,0.55465e-03,0.11914e-03 /)
      kao(:, 2, 2, 5) = (/ &
        & 0.15115e-02,0.16146e-02,0.15457e-02,0.14241e-02,0.12724e-02, &
        & 0.10844e-02,0.86669e-03,0.57603e-03,0.13037e-03 /)
      kao(:, 3, 2, 5) = (/ &
        & 0.15084e-02,0.16309e-02,0.15669e-02,0.14522e-02,0.13074e-02, &
        & 0.11181e-02,0.89787e-03,0.59657e-03,0.13918e-03 /)
      kao(:, 4, 2, 5) = (/ &
        & 0.14965e-02,0.16419e-02,0.15861e-02,0.14781e-02,0.13385e-02, &
        & 0.11507e-02,0.92569e-03,0.61596e-03,0.15053e-03 /)
      kao(:, 5, 2, 5) = (/ &
        & 0.14804e-02,0.16493e-02,0.16042e-02,0.15021e-02,0.13704e-02, &
        & 0.11804e-02,0.95044e-03,0.63472e-03,0.16410e-03 /)
      kao(:, 1, 3, 5) = (/ &
        & 0.13707e-02,0.14436e-02,0.13706e-02,0.12561e-02,0.11093e-02, &
        & 0.93534e-03,0.74505e-03,0.49303e-03,0.93388e-04 /)
      kao(:, 2, 3, 5) = (/ &
        & 0.13760e-02,0.14666e-02,0.13986e-02,0.12850e-02,0.11416e-02, &
        & 0.96700e-03,0.77192e-03,0.51430e-03,0.10062e-03 /)
      kao(:, 3, 3, 5) = (/ &
        & 0.13732e-02,0.14839e-02,0.14208e-02,0.13112e-02,0.11718e-02, &
        & 0.99814e-03,0.79899e-03,0.53404e-03,0.10964e-03 /)
      kao(:, 4, 3, 5) = (/ &
        & 0.13644e-02,0.14939e-02,0.14404e-02,0.13346e-02,0.12002e-02, &
        & 0.10295e-02,0.82532e-03,0.55285e-03,0.12023e-03 /)
      kao(:, 5, 3, 5) = (/ &
        & 0.13512e-02,0.15024e-02,0.14568e-02,0.13559e-02,0.12266e-02, &
        & 0.10592e-02,0.85085e-03,0.57058e-03,0.13064e-03 /)
      kao(:, 1, 4, 5) = (/ &
        & 0.12336e-02,0.12968e-02,0.12255e-02,0.11189e-02,0.98785e-03, &
        & 0.83184e-03,0.66033e-03,0.43467e-03,0.70047e-04 /)
      kao(:, 2, 4, 5) = (/ &
        & 0.12419e-02,0.13192e-02,0.12543e-02,0.11482e-02,0.10189e-02, &
        & 0.86315e-03,0.68559e-03,0.45559e-03,0.76629e-04 /)
      kao(:, 3, 4, 5) = (/ &
        & 0.12416e-02,0.13349e-02,0.12771e-02,0.11745e-02,0.10469e-02, &
        & 0.89182e-03,0.71110e-03,0.47551e-03,0.84761e-04 /)
      kao(:, 4, 4, 5) = (/ &
        & 0.12342e-02,0.13470e-02,0.12958e-02,0.11964e-02,0.10726e-02, &
        & 0.91965e-03,0.73487e-03,0.49419e-03,0.93979e-04 /)
      kao(:, 5, 4, 5) = (/ &
        & 0.12238e-02,0.13566e-02,0.13110e-02,0.12168e-02,0.10976e-02, &
        & 0.94731e-03,0.75866e-03,0.51080e-03,0.10249e-03 /)
      kao(:, 1, 5, 5) = (/ &
        & 0.10970e-02,0.11491e-02,0.10850e-02,0.99037e-03,0.87478e-03, &
        & 0.73644e-03,0.58168e-03,0.38673e-03,0.55328e-04 /)
      kao(:, 2, 5, 5) = (/ &
        & 0.11051e-02,0.11716e-02,0.11129e-02,0.10196e-02,0.90431e-03, &
        & 0.76445e-03,0.60553e-03,0.40600e-03,0.61413e-04 /)
      kao(:, 3, 5, 5) = (/ &
        & 0.11053e-02,0.11877e-02,0.11365e-02,0.10446e-02,0.92981e-03, &
        & 0.79114e-03,0.62919e-03,0.42419e-03,0.68340e-04 /)
      kao(:, 4, 5, 5) = (/ &
        & 0.11000e-02,0.12008e-02,0.11557e-02,0.10648e-02,0.95310e-03, &
        & 0.81721e-03,0.65273e-03,0.44128e-03,0.75425e-04 /)
      kao(:, 5, 5, 5) = (/ &
        & 0.10930e-02,0.12101e-02,0.11704e-02,0.10855e-02,0.97521e-03, &
        & 0.84232e-03,0.67516e-03,0.45733e-03,0.82112e-04 /)
      kao(:, 1, 6, 5) = (/ &
        & 0.96254e-03,0.10041e-02,0.94496e-03,0.86305e-03,0.76515e-03, &
        & 0.64666e-03,0.50949e-03,0.34237e-03,0.45743e-04 /)
      kao(:, 2, 6, 5) = (/ &
        & 0.97168e-03,0.10257e-02,0.97306e-03,0.89241e-03,0.79300e-03, &
        & 0.67315e-03,0.53212e-03,0.35953e-03,0.50936e-04 /)
      kao(:, 3, 6, 5) = (/ &
        & 0.97307e-03,0.10417e-02,0.99540e-03,0.91663e-03,0.81739e-03, &
        & 0.69764e-03,0.55388e-03,0.37625e-03,0.56704e-04 /)
      kao(:, 4, 6, 5) = (/ &
        & 0.97112e-03,0.10538e-02,0.10130e-02,0.93600e-03,0.83875e-03, &
        & 0.72048e-03,0.57540e-03,0.39219e-03,0.62214e-04 /)
      kao(:, 5, 6, 5) = (/ &
        & 0.96524e-03,0.10634e-02,0.10272e-02,0.95339e-03,0.85814e-03, &
        & 0.74256e-03,0.59649e-03,0.40723e-03,0.68154e-04 /)
      kao(:, 1, 7, 5) = (/ &
        & 0.83977e-03,0.87150e-03,0.81798e-03,0.74510e-03,0.66073e-03, &
        & 0.55889e-03,0.44038e-03,0.30023e-03,0.39438e-04 /)
      kao(:, 2, 7, 5) = (/ &
        & 0.84860e-03,0.89183e-03,0.84311e-03,0.77202e-03,0.68677e-03, &
        & 0.58412e-03,0.46261e-03,0.31513e-03,0.44026e-04 /)
      kao(:, 3, 7, 5) = (/ &
        & 0.85156e-03,0.90640e-03,0.86357e-03,0.79472e-03,0.70843e-03, &
        & 0.60616e-03,0.48333e-03,0.32962e-03,0.48169e-04 /)
      kao(:, 4, 7, 5) = (/ &
        & 0.84996e-03,0.91804e-03,0.88000e-03,0.81332e-03,0.72741e-03, &
        & 0.62668e-03,0.50295e-03,0.34425e-03,0.52632e-04 /)
      kao(:, 5, 7, 5) = (/ &
        & 0.84411e-03,0.92502e-03,0.89195e-03,0.82771e-03,0.74479e-03, &
        & 0.64630e-03,0.52177e-03,0.35838e-03,0.57490e-04 /)
      kao(:, 1, 8, 5) = (/ &
        & 0.72566e-03,0.75029e-03,0.70410e-03,0.64085e-03,0.56881e-03, &
        & 0.48163e-03,0.37585e-03,0.26029e-03,0.35173e-04 /)
      kao(:, 2, 8, 5) = (/ &
        & 0.73526e-03,0.76878e-03,0.72724e-03,0.66569e-03,0.59239e-03, &
        & 0.50357e-03,0.39670e-03,0.27234e-03,0.38442e-04 /)
      kao(:, 3, 8, 5) = (/ &
        & 0.73942e-03,0.78240e-03,0.74617e-03,0.68580e-03,0.61175e-03, &
        & 0.52308e-03,0.41633e-03,0.28548e-03,0.42620e-04 /)
      kao(:, 4, 8, 5) = (/ &
        & 0.73787e-03,0.79331e-03,0.76108e-03,0.70193e-03,0.62821e-03, &
        & 0.54092e-03,0.43381e-03,0.29821e-03,0.47013e-04 /)
      kao(:, 5, 8, 5) = (/ &
        & 0.73365e-03,0.79895e-03,0.77125e-03,0.71463e-03,0.64295e-03, &
        & 0.55753e-03,0.45033e-03,0.31091e-03,0.51519e-04 /)
      kao(:, 1, 9, 5) = (/ &
        & 0.62112e-03,0.63900e-03,0.60071e-03,0.54641e-03,0.48585e-03, &
        & 0.41219e-03,0.31988e-03,0.22088e-03,0.39225e-04 /)
      kao(:, 2, 9, 5) = (/ &
        & 0.63089e-03,0.65678e-03,0.62144e-03,0.56855e-03,0.50663e-03, &
        & 0.43158e-03,0.33912e-03,0.23261e-03,0.43145e-04 /)
      kao(:, 3, 9, 5) = (/ &
        & 0.63630e-03,0.67023e-03,0.63841e-03,0.58635e-03,0.52398e-03, &
        & 0.44876e-03,0.35619e-03,0.24341e-03,0.47182e-04 /)
      kao(:, 4, 9, 5) = (/ &
        & 0.63678e-03,0.68001e-03,0.65143e-03,0.60045e-03,0.53807e-03, &
        & 0.46446e-03,0.37160e-03,0.25517e-03,0.51310e-04 /)
      kao(:, 5, 9, 5) = (/ &
        & 0.63384e-03,0.68558e-03,0.66049e-03,0.61133e-03,0.55067e-03, &
        & 0.47828e-03,0.38622e-03,0.26607e-03,0.55652e-04 /)
      kao(:, 1,10, 5) = (/ &
        & 0.52818e-03,0.54302e-03,0.51109e-03,0.46524e-03,0.41303e-03, &
        & 0.35089e-03,0.27050e-03,0.18719e-03,0.51897e-04 /)
      kao(:, 2,10, 5) = (/ &
        & 0.53874e-03,0.56000e-03,0.52974e-03,0.48429e-03,0.43151e-03, &
        & 0.36826e-03,0.28749e-03,0.19624e-03,0.57480e-04 /)
      kao(:, 3,10, 5) = (/ &
        & 0.54407e-03,0.57298e-03,0.54499e-03,0.50007e-03,0.44685e-03, &
        & 0.38282e-03,0.30218e-03,0.20623e-03,0.63250e-04 /)
      kao(:, 4,10, 5) = (/ &
        & 0.54510e-03,0.58221e-03,0.55605e-03,0.51259e-03,0.45923e-03, &
        & 0.39550e-03,0.31547e-03,0.21632e-03,0.68339e-04 /)
      kao(:, 5,10, 5) = (/ &
        & 0.54335e-03,0.58744e-03,0.56412e-03,0.52185e-03,0.47008e-03, &
        & 0.40728e-03,0.32798e-03,0.22618e-03,0.72964e-04 /)
      kao(:, 1,11, 5) = (/ &
        & 0.44901e-03,0.46427e-03,0.43915e-03,0.40187e-03,0.35719e-03, &
        & 0.30380e-03,0.23427e-03,0.15956e-03,0.52228e-04 /)
      kao(:, 2,11, 5) = (/ &
        & 0.45685e-03,0.47845e-03,0.45475e-03,0.41772e-03,0.37275e-03, &
        & 0.31798e-03,0.24772e-03,0.16817e-03,0.56979e-04 /)
      kao(:, 3,11, 5) = (/ &
        & 0.46005e-03,0.48879e-03,0.46665e-03,0.43038e-03,0.38526e-03, &
        & 0.32982e-03,0.25983e-03,0.17707e-03,0.61788e-04 /)
      kao(:, 4,11, 5) = (/ &
        & 0.46029e-03,0.49540e-03,0.47547e-03,0.44015e-03,0.39539e-03, &
        & 0.34025e-03,0.27087e-03,0.18596e-03,0.66537e-04 /)
      kao(:, 5,11, 5) = (/ &
        & 0.45760e-03,0.49879e-03,0.48175e-03,0.44812e-03,0.40429e-03, &
        & 0.34971e-03,0.28105e-03,0.19422e-03,0.70982e-04 /)
      kao(:, 1,12, 5) = (/ &
        & 0.37789e-03,0.39359e-03,0.37439e-03,0.34335e-03,0.30516e-03, &
        & 0.25987e-03,0.20136e-03,0.13616e-03,0.47471e-04 /)
      kao(:, 2,12, 5) = (/ &
        & 0.38345e-03,0.40460e-03,0.38678e-03,0.35616e-03,0.31793e-03, &
        & 0.27155e-03,0.21219e-03,0.14366e-03,0.51576e-04 /)
      kao(:, 3,12, 5) = (/ &
        & 0.38556e-03,0.41241e-03,0.39583e-03,0.36622e-03,0.32808e-03, &
        & 0.28132e-03,0.22259e-03,0.15133e-03,0.55529e-04 /)
      kao(:, 4,12, 5) = (/ &
        & 0.38464e-03,0.41687e-03,0.40247e-03,0.37394e-03,0.33650e-03, &
        & 0.28994e-03,0.23157e-03,0.15870e-03,0.59557e-04 /)
      kao(:, 5,12, 5) = (/ &
        & 0.38119e-03,0.41880e-03,0.40725e-03,0.38009e-03,0.34354e-03, &
        & 0.29781e-03,0.23974e-03,0.16572e-03,0.63195e-04 /)
      kao(:, 1,13, 5) = (/ &
        & 0.31518e-03,0.33080e-03,0.31644e-03,0.29051e-03,0.25824e-03, &
        & 0.21997e-03,0.17074e-03,0.11585e-03,0.39419e-04 /)
      kao(:, 2,13, 5) = (/ &
        & 0.31945e-03,0.33947e-03,0.32620e-03,0.30064e-03,0.26839e-03, &
        & 0.22968e-03,0.17999e-03,0.12241e-03,0.42717e-04 /)
      kao(:, 3,13, 5) = (/ &
        & 0.32042e-03,0.34518e-03,0.33311e-03,0.30844e-03,0.27653e-03, &
        & 0.23733e-03,0.18840e-03,0.12892e-03,0.45799e-04 /)
      kao(:, 4,13, 5) = (/ &
        & 0.31877e-03,0.34829e-03,0.33813e-03,0.31466e-03,0.28316e-03, &
        & 0.24429e-03,0.19577e-03,0.13500e-03,0.49095e-04 /)
      kao(:, 5,13, 5) = (/ &
        & 0.31533e-03,0.34943e-03,0.34164e-03,0.31953e-03,0.28883e-03, &
        & 0.25064e-03,0.20247e-03,0.14079e-03,0.52225e-04 /)
      kao(:, 1, 1, 6) = (/ &
        & 0.30073e-02,0.30215e-02,0.28549e-02,0.26145e-02,0.23223e-02, &
        & 0.19698e-02,0.15631e-02,0.10671e-02,0.34349e-03 /)
      kao(:, 2, 1, 6) = (/ &
        & 0.30045e-02,0.30464e-02,0.29000e-02,0.26682e-02,0.23795e-02, &
        & 0.20320e-02,0.16241e-02,0.11180e-02,0.37241e-03 /)
      kao(:, 3, 1, 6) = (/ &
        & 0.29924e-02,0.30694e-02,0.29376e-02,0.27170e-02,0.24327e-02, &
        & 0.20955e-02,0.16828e-02,0.11692e-02,0.41183e-03 /)
      kao(:, 4, 1, 6) = (/ &
        & 0.29732e-02,0.30875e-02,0.29723e-02,0.27617e-02,0.24862e-02, &
        & 0.21555e-02,0.17426e-02,0.12186e-02,0.45672e-03 /)
      kao(:, 5, 1, 6) = (/ &
        & 0.29511e-02,0.31004e-02,0.30014e-02,0.28043e-02,0.25375e-02, &
        & 0.22174e-02,0.18018e-02,0.12656e-02,0.49848e-03 /)
      kao(:, 1, 2, 6) = (/ &
        & 0.28011e-02,0.28061e-02,0.26513e-02,0.24171e-02,0.21391e-02, &
        & 0.18145e-02,0.14290e-02,0.97808e-03,0.28283e-03 /)
      kao(:, 2, 2, 6) = (/ &
        & 0.28038e-02,0.28333e-02,0.26971e-02,0.24708e-02,0.21906e-02, &
        & 0.18715e-02,0.14859e-02,0.10236e-02,0.31088e-03 /)
      kao(:, 3, 2, 6) = (/ &
        & 0.27978e-02,0.28587e-02,0.27386e-02,0.25159e-02,0.22406e-02, &
        & 0.19256e-02,0.15398e-02,0.10695e-02,0.34605e-03 /)
      kao(:, 4, 2, 6) = (/ &
        & 0.27864e-02,0.28782e-02,0.27737e-02,0.25561e-02,0.22888e-02, &
        & 0.19778e-02,0.15963e-02,0.11144e-02,0.38043e-03 /)
      kao(:, 5, 2, 6) = (/ &
        & 0.27682e-02,0.28941e-02,0.28027e-02,0.25952e-02,0.23337e-02, &
        & 0.20308e-02,0.16518e-02,0.11583e-02,0.41249e-03 /)
      kao(:, 1, 3, 6) = (/ &
        & 0.26013e-02,0.25925e-02,0.24368e-02,0.22059e-02,0.19447e-02, &
        & 0.16443e-02,0.12895e-02,0.88356e-03,0.22980e-03 /)
      kao(:, 2, 3, 6) = (/ &
        & 0.26118e-02,0.26228e-02,0.24826e-02,0.22596e-02,0.19971e-02, &
        & 0.16971e-02,0.13425e-02,0.92292e-03,0.25666e-03 /)
      kao(:, 3, 3, 6) = (/ &
        & 0.26121e-02,0.26511e-02,0.25221e-02,0.23045e-02,0.20442e-02, &
        & 0.17465e-02,0.13937e-02,0.96423e-03,0.28307e-03 /)
      kao(:, 4, 3, 6) = (/ &
        & 0.26050e-02,0.26757e-02,0.25536e-02,0.23446e-02,0.20883e-02, &
        & 0.17925e-02,0.14453e-02,0.10074e-02,0.30818e-03 /)
      kao(:, 5, 3, 6) = (/ &
        & 0.25933e-02,0.26944e-02,0.25823e-02,0.23794e-02,0.21318e-02, &
        & 0.18378e-02,0.14965e-02,0.10492e-02,0.33812e-03 /)
      kao(:, 1, 4, 6) = (/ &
        & 0.24078e-02,0.23894e-02,0.22370e-02,0.20125e-02,0.17599e-02, &
        & 0.14763e-02,0.11554e-02,0.78494e-03,0.18813e-03 /)
      kao(:, 2, 4, 6) = (/ &
        & 0.24225e-02,0.24253e-02,0.22813e-02,0.20638e-02,0.18093e-02, &
        & 0.15251e-02,0.12031e-02,0.82373e-03,0.21030e-03 /)
      kao(:, 3, 4, 6) = (/ &
        & 0.24294e-02,0.24564e-02,0.23198e-02,0.21085e-02,0.18532e-02, &
        & 0.15708e-02,0.12482e-02,0.86229e-03,0.23129e-03 /)
      kao(:, 4, 4, 6) = (/ &
        & 0.24309e-02,0.24808e-02,0.23546e-02,0.21467e-02,0.18923e-02, &
        & 0.16129e-02,0.12944e-02,0.90119e-03,0.25224e-03 /)
      kao(:, 5, 4, 6) = (/ &
        & 0.24223e-02,0.24983e-02,0.23839e-02,0.21783e-02,0.19305e-02, &
        & 0.16540e-02,0.13401e-02,0.94049e-03,0.27779e-03 /)
      kao(:, 1, 5, 6) = (/ &
        & 0.22071e-02,0.21851e-02,0.20436e-02,0.18357e-02,0.15952e-02, &
        & 0.13304e-02,0.10307e-02,0.69163e-03,0.14983e-03 /)
      kao(:, 2, 5, 6) = (/ &
        & 0.22284e-02,0.22243e-02,0.20887e-02,0.18839e-02,0.16450e-02, &
        & 0.13762e-02,0.10736e-02,0.72602e-03,0.16732e-03 /)
      kao(:, 3, 5, 6) = (/ &
        & 0.22426e-02,0.22593e-02,0.21270e-02,0.19281e-02,0.16889e-02, &
        & 0.14169e-02,0.11148e-02,0.76201e-03,0.18420e-03 /)
      kao(:, 4, 5, 6) = (/ &
        & 0.22476e-02,0.22863e-02,0.21609e-02,0.19676e-02,0.17258e-02, &
        & 0.14525e-02,0.11537e-02,0.79815e-03,0.20325e-03 /)
      kao(:, 5, 5, 6) = (/ &
        & 0.22399e-02,0.23048e-02,0.21912e-02,0.19974e-02,0.17586e-02, &
        & 0.14880e-02,0.11934e-02,0.83564e-03,0.22470e-03 /)
      kao(:, 1, 6, 6) = (/ &
        & 0.20075e-02,0.19795e-02,0.18447e-02,0.16541e-02,0.14341e-02, &
        & 0.11951e-02,0.92238e-03,0.60660e-03,0.12381e-03 /)
      kao(:, 2, 6, 6) = (/ &
        & 0.20344e-02,0.20227e-02,0.18912e-02,0.17028e-02,0.14828e-02, &
        & 0.12404e-02,0.96234e-03,0.63833e-03,0.13822e-03 /)
      kao(:, 3, 6, 6) = (/ &
        & 0.20513e-02,0.20598e-02,0.19311e-02,0.17466e-02,0.15267e-02, &
        & 0.12805e-02,0.99815e-03,0.66987e-03,0.15138e-03 /)
      kao(:, 4, 6, 6) = (/ &
        & 0.20576e-02,0.20878e-02,0.19661e-02,0.17857e-02,0.15647e-02, &
        & 0.13147e-02,0.10319e-02,0.70266e-03,0.16753e-03 /)
      kao(:, 5, 6, 6) = (/ &
        & 0.20521e-02,0.21067e-02,0.19938e-02,0.18157e-02,0.15969e-02, &
        & 0.13475e-02,0.10644e-02,0.73524e-03,0.18430e-03 /)
      kao(:, 1, 7, 6) = (/ &
        & 0.17951e-02,0.17708e-02,0.16476e-02,0.14764e-02,0.12769e-02, &
        & 0.10613e-02,0.82141e-03,0.53387e-03,0.10356e-03 /)
      kao(:, 2, 7, 6) = (/ &
        & 0.18257e-02,0.18161e-02,0.16970e-02,0.15264e-02,0.13250e-02, &
        & 0.11052e-02,0.85771e-03,0.56341e-03,0.11419e-03 /)
      kao(:, 3, 7, 6) = (/ &
        & 0.18457e-02,0.18541e-02,0.17382e-02,0.15700e-02,0.13685e-02, &
        & 0.11444e-02,0.89062e-03,0.59265e-03,0.12737e-03 /)
      kao(:, 4, 7, 6) = (/ &
        & 0.18534e-02,0.18833e-02,0.17713e-02,0.16066e-02,0.14063e-02, &
        & 0.11787e-02,0.92220e-03,0.62067e-03,0.14148e-03 /)
      kao(:, 5, 7, 6) = (/ &
        & 0.18508e-02,0.19025e-02,0.17986e-02,0.16377e-02,0.14382e-02, &
        & 0.12095e-02,0.95313e-03,0.64883e-03,0.15624e-03 /)
      kao(:, 1, 8, 6) = (/ &
        & 0.15853e-02,0.15606e-02,0.14491e-02,0.13005e-02,0.11253e-02, &
        & 0.93388e-03,0.72631e-03,0.46832e-03,0.90402e-04 /)
      kao(:, 2, 8, 6) = (/ &
        & 0.16191e-02,0.16074e-02,0.14980e-02,0.13497e-02,0.11730e-02, &
        & 0.97691e-03,0.76027e-03,0.49835e-03,0.10124e-03 /)
      kao(:, 3, 8, 6) = (/ &
        & 0.16393e-02,0.16464e-02,0.15392e-02,0.13927e-02,0.12147e-02, &
        & 0.10153e-02,0.79129e-03,0.52537e-03,0.11276e-03 /)
      kao(:, 4, 8, 6) = (/ &
        & 0.16487e-02,0.16729e-02,0.15721e-02,0.14286e-02,0.12504e-02, &
        & 0.10480e-02,0.82072e-03,0.55187e-03,0.12515e-03 /)
      kao(:, 5, 8, 6) = (/ &
        & 0.16472e-02,0.16924e-02,0.15977e-02,0.14588e-02,0.12817e-02, &
        & 0.10777e-02,0.84873e-03,0.57800e-03,0.13784e-03 /)
      kao(:, 1, 9, 6) = (/ &
        & 0.13936e-02,0.13674e-02,0.12635e-02,0.11331e-02,0.97871e-03, &
        & 0.81331e-03,0.63480e-03,0.40910e-03,0.92222e-04 /)
      kao(:, 2, 9, 6) = (/ &
        & 0.14271e-02,0.14126e-02,0.13114e-02,0.11804e-02,0.10248e-02, &
        & 0.85405e-03,0.66828e-03,0.43677e-03,0.10207e-03 /)
      kao(:, 3, 9, 6) = (/ &
        & 0.14461e-02,0.14478e-02,0.13500e-02,0.12219e-02,0.10647e-02, &
        & 0.89058e-03,0.69816e-03,0.46305e-03,0.11262e-03 /)
      kao(:, 4, 9, 6) = (/ &
        & 0.14547e-02,0.14726e-02,0.13807e-02,0.12557e-02,0.10996e-02, &
        & 0.92247e-03,0.72520e-03,0.48654e-03,0.12376e-03 /)
      kao(:, 5, 9, 6) = (/ &
        & 0.14563e-02,0.14902e-02,0.14046e-02,0.12841e-02,0.11288e-02, &
        & 0.95105e-03,0.75065e-03,0.51065e-03,0.13556e-03 /)
      kao(:, 1,10, 6) = (/ &
        & 0.12161e-02,0.11928e-02,0.11004e-02,0.98725e-03,0.85318e-03, &
        & 0.70775e-03,0.55081e-03,0.35481e-03,0.12422e-03 /)
      kao(:, 2,10, 6) = (/ &
        & 0.12463e-02,0.12352e-02,0.11444e-02,0.10316e-02,0.89480e-03, &
        & 0.74560e-03,0.58282e-03,0.38195e-03,0.13273e-03 /)
      kao(:, 3,10, 6) = (/ &
        & 0.12646e-02,0.12662e-02,0.11796e-02,0.10687e-02,0.93096e-03, &
        & 0.77883e-03,0.61138e-03,0.40526e-03,0.14193e-03 /)
      kao(:, 4,10, 6) = (/ &
        & 0.12733e-02,0.12880e-02,0.12074e-02,0.10979e-02,0.96169e-03, &
        & 0.80809e-03,0.63689e-03,0.42724e-03,0.15291e-03 /)
      kao(:, 5,10, 6) = (/ &
        & 0.12740e-02,0.13044e-02,0.12293e-02,0.11231e-02,0.98752e-03, &
        & 0.83380e-03,0.66030e-03,0.44847e-03,0.16460e-03 /)
      kao(:, 1,11, 6) = (/ &
        & 0.10656e-02,0.10497e-02,0.96881e-03,0.87108e-03,0.75627e-03, &
        & 0.62893e-03,0.48955e-03,0.31741e-03,0.13016e-03 /)
      kao(:, 2,11, 6) = (/ &
        & 0.10879e-02,0.10821e-02,0.10046e-02,0.90804e-03,0.79130e-03, &
        & 0.66235e-03,0.51807e-03,0.34003e-03,0.13779e-03 /)
      kao(:, 3,11, 6) = (/ &
        & 0.11001e-02,0.11057e-02,0.10327e-02,0.93770e-03,0.82120e-03, &
        & 0.69087e-03,0.54346e-03,0.36047e-03,0.14411e-03 /)
      kao(:, 4,11, 6) = (/ &
        & 0.11047e-02,0.11226e-02,0.10548e-02,0.96212e-03,0.84667e-03, &
        & 0.71575e-03,0.56548e-03,0.37954e-03,0.15311e-03 /)
      kao(:, 5,11, 6) = (/ &
        & 0.11028e-02,0.11345e-02,0.10715e-02,0.98143e-03,0.86845e-03, &
        & 0.73791e-03,0.58600e-03,0.39874e-03,0.16257e-03 /)
      kao(:, 1,12, 6) = (/ &
        & 0.92541e-03,0.91485e-03,0.84575e-03,0.76287e-03,0.66530e-03, &
        & 0.55435e-03,0.43055e-03,0.28106e-03,0.11779e-03 /)
      kao(:, 2,12, 6) = (/ &
        & 0.94153e-03,0.94015e-03,0.87425e-03,0.79221e-03,0.69422e-03, &
        & 0.58249e-03,0.45555e-03,0.30043e-03,0.12541e-03 /)
      kao(:, 3,12, 6) = (/ &
        & 0.95043e-03,0.95859e-03,0.89645e-03,0.81618e-03,0.71892e-03, &
        & 0.60660e-03,0.47691e-03,0.31810e-03,0.13086e-03 /)
      kao(:, 4,12, 6) = (/ &
        & 0.95300e-03,0.97180e-03,0.91414e-03,0.83540e-03,0.73965e-03, &
        & 0.62755e-03,0.49627e-03,0.33494e-03,0.13792e-03 /)
      kao(:, 5,12, 6) = (/ &
        & 0.94924e-03,0.98033e-03,0.92629e-03,0.85073e-03,0.75722e-03, &
        & 0.64562e-03,0.51410e-03,0.35114e-03,0.14650e-03 /)
      kao(:, 1,13, 6) = (/ &
        & 0.79344e-03,0.78971e-03,0.73267e-03,0.66405e-03,0.58083e-03, &
        & 0.48392e-03,0.37549e-03,0.24569e-03,0.97034e-04 /)
      kao(:, 2,13, 6) = (/ &
        & 0.80574e-03,0.81004e-03,0.75547e-03,0.68809e-03,0.60484e-03, &
        & 0.50707e-03,0.39618e-03,0.26227e-03,0.10267e-03 /)
      kao(:, 3,13, 6) = (/ &
        & 0.81227e-03,0.82486e-03,0.77408e-03,0.70758e-03,0.62511e-03, &
        & 0.52731e-03,0.41439e-03,0.27759e-03,0.10742e-03 /)
      kao(:, 4,13, 6) = (/ &
        & 0.81298e-03,0.83538e-03,0.78743e-03,0.72262e-03,0.64193e-03, &
        & 0.54449e-03,0.43080e-03,0.29211e-03,0.11325e-03 /)
      kao(:, 5,13, 6) = (/ &
        & 0.80893e-03,0.84184e-03,0.79706e-03,0.73516e-03,0.65638e-03, &
        & 0.55984e-03,0.44607e-03,0.30621e-03,0.12059e-03 /)
      kao(:, 1, 1, 7) = (/ &
        & 0.54732e-02,0.53034e-02,0.49969e-02,0.45431e-02,0.40134e-02, &
        & 0.34010e-02,0.26972e-02,0.18637e-02,0.96692e-03 /)
      kao(:, 2, 1, 7) = (/ &
        & 0.54607e-02,0.53367e-02,0.50546e-02,0.46321e-02,0.41099e-02, &
        & 0.34970e-02,0.27999e-02,0.19729e-02,0.11063e-02 /)
      kao(:, 3, 1, 7) = (/ &
        & 0.54405e-02,0.53637e-02,0.51145e-02,0.47117e-02,0.41981e-02, &
        & 0.35927e-02,0.29070e-02,0.20850e-02,0.12360e-02 /)
      kao(:, 4, 1, 7) = (/ &
        & 0.54052e-02,0.53858e-02,0.51679e-02,0.47829e-02,0.42844e-02, &
        & 0.36942e-02,0.30161e-02,0.22030e-02,0.13785e-02 /)
      kao(:, 5, 1, 7) = (/ &
        & 0.53549e-02,0.54029e-02,0.52131e-02,0.48529e-02,0.43733e-02, &
        & 0.37946e-02,0.31262e-02,0.23268e-02,0.15336e-02 /)
      kao(:, 1, 2, 7) = (/ &
        & 0.52482e-02,0.50940e-02,0.47786e-02,0.43454e-02,0.38186e-02, &
        & 0.32129e-02,0.25325e-02,0.17227e-02,0.80430e-03 /)
      kao(:, 2, 2, 7) = (/ &
        & 0.52403e-02,0.51313e-02,0.48370e-02,0.44315e-02,0.39109e-02, &
        & 0.33052e-02,0.26254e-02,0.18226e-02,0.90614e-03 /)
      kao(:, 3, 2, 7) = (/ &
        & 0.52188e-02,0.51614e-02,0.48948e-02,0.45073e-02,0.39963e-02, &
        & 0.33961e-02,0.27198e-02,0.19222e-02,0.10146e-02 /)
      kao(:, 4, 2, 7) = (/ &
        & 0.51826e-02,0.51837e-02,0.49460e-02,0.45770e-02,0.40791e-02, &
        & 0.34891e-02,0.28146e-02,0.20278e-02,0.11325e-02 /)
      kao(:, 5, 2, 7) = (/ &
        & 0.51359e-02,0.51960e-02,0.49902e-02,0.46430e-02,0.41602e-02, &
        & 0.35811e-02,0.29127e-02,0.21431e-02,0.12633e-02 /)
      kao(:, 1, 3, 7) = (/ &
        & 0.49876e-02,0.48388e-02,0.45133e-02,0.40992e-02,0.35901e-02, &
        & 0.30030e-02,0.23527e-02,0.15765e-02,0.64714e-03 /)
      kao(:, 2, 3, 7) = (/ &
        & 0.49850e-02,0.48808e-02,0.45736e-02,0.41821e-02,0.36790e-02, &
        & 0.30941e-02,0.24388e-02,0.16655e-02,0.72927e-03 /)
      kao(:, 3, 3, 7) = (/ &
        & 0.49660e-02,0.49117e-02,0.46346e-02,0.42593e-02,0.37631e-02, &
        & 0.31820e-02,0.25243e-02,0.17543e-02,0.81771e-03 /)
      kao(:, 4, 3, 7) = (/ &
        & 0.49361e-02,0.49307e-02,0.46909e-02,0.43285e-02,0.38459e-02, &
        & 0.32679e-02,0.26083e-02,0.18450e-02,0.91578e-03 /)
      kao(:, 5, 3, 7) = (/ &
        & 0.48943e-02,0.49413e-02,0.47366e-02,0.43959e-02,0.39239e-02, &
        & 0.33496e-02,0.26941e-02,0.19416e-02,0.10197e-02 /)
      kao(:, 1, 4, 7) = (/ &
        & 0.46848e-02,0.45423e-02,0.42109e-02,0.38147e-02,0.33318e-02, &
        & 0.27806e-02,0.21628e-02,0.14435e-02,0.52019e-03 /)
      kao(:, 2, 4, 7) = (/ &
        & 0.46885e-02,0.45846e-02,0.42767e-02,0.38967e-02,0.34228e-02, &
        & 0.28698e-02,0.22469e-02,0.15180e-02,0.58537e-03 /)
      kao(:, 3, 4, 7) = (/ &
        & 0.46784e-02,0.46158e-02,0.43389e-02,0.39718e-02,0.35088e-02, &
        & 0.29561e-02,0.23285e-02,0.15932e-02,0.65783e-03 /)
      kao(:, 4, 4, 7) = (/ &
        & 0.46546e-02,0.46379e-02,0.43907e-02,0.40421e-02,0.35928e-02, &
        & 0.30394e-02,0.24053e-02,0.16703e-02,0.73788e-03 /)
      kao(:, 5, 4, 7) = (/ &
        & 0.46218e-02,0.46560e-02,0.44359e-02,0.41109e-02,0.36691e-02, &
        & 0.31156e-02,0.24821e-02,0.17515e-02,0.82261e-03 /)
      kao(:, 1, 5, 7) = (/ &
        & 0.43680e-02,0.42271e-02,0.38928e-02,0.35080e-02,0.30576e-02, &
        & 0.25405e-02,0.19725e-02,0.13117e-02,0.42455e-03 /)
      kao(:, 2, 5, 7) = (/ &
        & 0.43836e-02,0.42742e-02,0.39603e-02,0.35901e-02,0.31440e-02, &
        & 0.26294e-02,0.20540e-02,0.13812e-02,0.47676e-03 /)
      kao(:, 3, 5, 7) = (/ &
        & 0.43831e-02,0.43074e-02,0.40201e-02,0.36636e-02,0.32261e-02, &
        & 0.27164e-02,0.21330e-02,0.14464e-02,0.53568e-03 /)
      kao(:, 4, 5, 7) = (/ &
        & 0.43690e-02,0.43343e-02,0.40742e-02,0.37289e-02,0.33089e-02, &
        & 0.28017e-02,0.22054e-02,0.15130e-02,0.59880e-03 /)
      kao(:, 5, 5, 7) = (/ &
        & 0.43473e-02,0.43575e-02,0.41195e-02,0.37951e-02,0.33885e-02, &
        & 0.28774e-02,0.22767e-02,0.15816e-02,0.66710e-03 /)
      kao(:, 1, 6, 7) = (/ &
        & 0.40714e-02,0.39122e-02,0.35777e-02,0.32091e-02,0.27872e-02, &
        & 0.22994e-02,0.17735e-02,0.11790e-02,0.33561e-03 /)
      kao(:, 2, 6, 7) = (/ &
        & 0.40973e-02,0.39625e-02,0.36472e-02,0.32877e-02,0.28694e-02, &
        & 0.23826e-02,0.18515e-02,0.12426e-02,0.37756e-03 /)
      kao(:, 3, 6, 7) = (/ &
        & 0.41108e-02,0.40033e-02,0.37116e-02,0.33595e-02,0.29464e-02, &
        & 0.24646e-02,0.19290e-02,0.13037e-02,0.42584e-03 /)
      kao(:, 4, 6, 7) = (/ &
        & 0.41078e-02,0.40382e-02,0.37677e-02,0.34232e-02,0.30216e-02, &
        & 0.25463e-02,0.20016e-02,0.13624e-02,0.47733e-03 /)
      kao(:, 5, 6, 7) = (/ &
        & 0.40964e-02,0.40666e-02,0.38151e-02,0.34890e-02,0.30973e-02, &
        & 0.26200e-02,0.20705e-02,0.14239e-02,0.53330e-03 /)
      kao(:, 1, 7, 7) = (/ &
        & 0.37806e-02,0.36256e-02,0.32982e-02,0.29389e-02,0.25345e-02, &
        & 0.20760e-02,0.15879e-02,0.10489e-02,0.28018e-03 /)
      kao(:, 2, 7, 7) = (/ &
        & 0.38204e-02,0.36872e-02,0.33713e-02,0.30154e-02,0.26103e-02, &
        & 0.21557e-02,0.16619e-02,0.11071e-02,0.31519e-03 /)
      kao(:, 3, 7, 7) = (/ &
        & 0.38460e-02,0.37374e-02,0.34369e-02,0.30817e-02,0.26834e-02, &
        & 0.22319e-02,0.17344e-02,0.11636e-02,0.35270e-03 /)
      kao(:, 4, 7, 7) = (/ &
        & 0.38578e-02,0.37771e-02,0.34946e-02,0.31444e-02,0.27541e-02, &
        & 0.23067e-02,0.18034e-02,0.12192e-02,0.39298e-03 /)
      kao(:, 5, 7, 7) = (/ &
        & 0.38608e-02,0.38134e-02,0.35421e-02,0.32035e-02,0.28239e-02, &
        & 0.23777e-02,0.18670e-02,0.12748e-02,0.43632e-03 /)
      kao(:, 1, 8, 7) = (/ &
        & 0.34769e-02,0.33291e-02,0.30196e-02,0.26781e-02,0.23024e-02, &
        & 0.18824e-02,0.14244e-02,0.92897e-03,0.24101e-03 /)
      kao(:, 2, 8, 7) = (/ &
        & 0.35239e-02,0.33972e-02,0.30964e-02,0.27587e-02,0.23816e-02, &
        & 0.19578e-02,0.14914e-02,0.98181e-03,0.27130e-03 /)
      kao(:, 3, 8, 7) = (/ &
        & 0.35607e-02,0.34526e-02,0.31656e-02,0.28309e-02,0.24544e-02, &
        & 0.20284e-02,0.15562e-02,0.10333e-02,0.30255e-03 /)
      kao(:, 4, 8, 7) = (/ &
        & 0.35844e-02,0.35023e-02,0.32271e-02,0.28968e-02,0.25226e-02, &
        & 0.20957e-02,0.16188e-02,0.10830e-02,0.33737e-03 /)
      kao(:, 5, 8, 7) = (/ &
        & 0.35961e-02,0.35446e-02,0.32825e-02,0.29568e-02,0.25866e-02, &
        & 0.21594e-02,0.16782e-02,0.11324e-02,0.37448e-03 /)
      kao(:, 1, 9, 7) = (/ &
        & 0.31490e-02,0.30162e-02,0.27350e-02,0.24183e-02,0.20753e-02, &
        & 0.16954e-02,0.12750e-02,0.82561e-03,0.24776e-03 /)
      kao(:, 2, 9, 7) = (/ &
        & 0.32098e-02,0.30913e-02,0.28147e-02,0.25006e-02,0.21544e-02, &
        & 0.17699e-02,0.13387e-02,0.87243e-03,0.27735e-03 /)
      kao(:, 3, 9, 7) = (/ &
        & 0.32582e-02,0.31563e-02,0.28883e-02,0.25742e-02,0.22278e-02, &
        & 0.18394e-02,0.14003e-02,0.91830e-03,0.30712e-03 /)
      kao(:, 4, 9, 7) = (/ &
        & 0.32928e-02,0.32146e-02,0.29543e-02,0.26421e-02,0.22954e-02, &
        & 0.19038e-02,0.14592e-02,0.96296e-03,0.33982e-03 /)
      kao(:, 5, 9, 7) = (/ &
        & 0.33113e-02,0.32637e-02,0.30129e-02,0.27034e-02,0.23582e-02, &
        & 0.19652e-02,0.15140e-02,0.10071e-02,0.37422e-03 /)
      kao(:, 1,10, 7) = (/ &
        & 0.28236e-02,0.26993e-02,0.24463e-02,0.21584e-02,0.18515e-02, &
        & 0.15144e-02,0.11396e-02,0.73456e-03,0.30599e-03 /)
      kao(:, 2,10, 7) = (/ &
        & 0.28929e-02,0.27796e-02,0.25302e-02,0.22416e-02,0.19311e-02, &
        & 0.15864e-02,0.12002e-02,0.77955e-03,0.32947e-03 /)
      kao(:, 3,10, 7) = (/ &
        & 0.29497e-02,0.28523e-02,0.26078e-02,0.23174e-02,0.20043e-02, &
        & 0.16542e-02,0.12577e-02,0.82291e-03,0.35529e-03 /)
      kao(:, 4,10, 7) = (/ &
        & 0.29901e-02,0.29165e-02,0.26763e-02,0.23877e-02,0.20731e-02, &
        & 0.17177e-02,0.13124e-02,0.86431e-03,0.38167e-03 /)
      kao(:, 5,10, 7) = (/ &
        & 0.30139e-02,0.29672e-02,0.27348e-02,0.24509e-02,0.21349e-02, &
        & 0.17760e-02,0.13646e-02,0.90496e-03,0.40993e-03 /)
      kao(:, 1,11, 7) = (/ &
        & 0.25422e-02,0.24347e-02,0.22108e-02,0.19505e-02,0.16727e-02, &
        & 0.13714e-02,0.10368e-02,0.66936e-03,0.31350e-03 /)
      kao(:, 2,11, 7) = (/ &
        & 0.26126e-02,0.25184e-02,0.22944e-02,0.20307e-02,0.17483e-02, &
        & 0.14377e-02,0.10928e-02,0.71181e-03,0.33782e-03 /)
      kao(:, 3,11, 7) = (/ &
        & 0.26690e-02,0.25901e-02,0.23690e-02,0.21043e-02,0.18188e-02, &
        & 0.15016e-02,0.11462e-02,0.75188e-03,0.35774e-03 /)
      kao(:, 4,11, 7) = (/ &
        & 0.27048e-02,0.26504e-02,0.24329e-02,0.21704e-02,0.18832e-02, &
        & 0.15599e-02,0.11973e-02,0.79054e-03,0.37720e-03 /)
      kao(:, 5,11, 7) = (/ &
        & 0.27241e-02,0.26964e-02,0.24876e-02,0.22289e-02,0.19396e-02, &
        & 0.16131e-02,0.12459e-02,0.82843e-03,0.39980e-03 /)
      kao(:, 1,12, 7) = (/ &
        & 0.22863e-02,0.21916e-02,0.19903e-02,0.17560e-02,0.15053e-02, &
        & 0.12361e-02,0.93929e-03,0.60469e-03,0.28176e-03 /)
      kao(:, 2,12, 7) = (/ &
        & 0.23519e-02,0.22705e-02,0.20691e-02,0.18315e-02,0.15760e-02, &
        & 0.12985e-02,0.99139e-03,0.64462e-03,0.30471e-03 /)
      kao(:, 3,12, 7) = (/ &
        & 0.23974e-02,0.23352e-02,0.21377e-02,0.19000e-02,0.16408e-02, &
        & 0.13574e-02,0.10412e-02,0.68214e-03,0.32553e-03 /)
      kao(:, 4,12, 7) = (/ &
        & 0.24260e-02,0.23879e-02,0.21943e-02,0.19602e-02,0.16992e-02, &
        & 0.14109e-02,0.10885e-02,0.71852e-03,0.34169e-03 /)
      kao(:, 5,12, 7) = (/ &
        & 0.24412e-02,0.24274e-02,0.22422e-02,0.20116e-02,0.17502e-02, &
        & 0.14591e-02,0.11336e-02,0.75474e-03,0.36020e-03 /)
      kao(:, 1,13, 7) = (/ &
        & 0.20393e-02,0.19603e-02,0.17821e-02,0.15739e-02,0.13509e-02, &
        & 0.11133e-02,0.84826e-03,0.54289e-03,0.23248e-03 /)
      kao(:, 2,13, 7) = (/ &
        & 0.20953e-02,0.20307e-02,0.18542e-02,0.16433e-02,0.14162e-02, &
        & 0.11712e-02,0.89683e-03,0.57958e-03,0.25095e-03 /)
      kao(:, 3,13, 7) = (/ &
        & 0.21323e-02,0.20881e-02,0.19144e-02,0.17046e-02,0.14742e-02, &
        & 0.12241e-02,0.94271e-03,0.61480e-03,0.26566e-03 /)
      kao(:, 4,13, 7) = (/ &
        & 0.21562e-02,0.21324e-02,0.19654e-02,0.17578e-02,0.15256e-02, &
        & 0.12715e-02,0.98599e-03,0.64941e-03,0.28144e-03 /)
      kao(:, 5,13, 7) = (/ &
        & 0.21687e-02,0.21674e-02,0.20081e-02,0.18029e-02,0.15712e-02, &
        & 0.13148e-02,0.10270e-02,0.68370e-03,0.29755e-03 /)
      kao(:, 1, 1, 8) = (/ &
        & 0.10084e-01,0.95278e-02,0.88730e-02,0.81189e-02,0.71873e-02, &
        & 0.61505e-02,0.50159e-02,0.37383e-02,0.30410e-02 /)
      kao(:, 2, 1, 8) = (/ &
        & 0.10011e-01,0.95195e-02,0.89419e-02,0.82272e-02,0.73508e-02, &
        & 0.63699e-02,0.52392e-02,0.39784e-02,0.34237e-02 /)
      kao(:, 3, 1, 8) = (/ &
        & 0.99285e-02,0.95060e-02,0.90107e-02,0.83435e-02,0.75299e-02, &
        & 0.65814e-02,0.54661e-02,0.42490e-02,0.38569e-02 /)
      kao(:, 4, 1, 8) = (/ &
        & 0.98396e-02,0.95039e-02,0.90786e-02,0.84657e-02,0.77142e-02, &
        & 0.67908e-02,0.57132e-02,0.45510e-02,0.43277e-02 /)
      kao(:, 5, 1, 8) = (/ &
        & 0.97470e-02,0.95073e-02,0.91451e-02,0.85961e-02,0.78983e-02, &
        & 0.70134e-02,0.59878e-02,0.48898e-02,0.48367e-02 /)
      kao(:, 1, 2, 8) = (/ &
        & 0.10032e-01,0.95001e-02,0.88015e-02,0.80012e-02,0.70675e-02, &
        & 0.59994e-02,0.48088e-02,0.34803e-02,0.24973e-02 /)
      kao(:, 2, 2, 8) = (/ &
        & 0.99727e-02,0.94952e-02,0.88708e-02,0.81052e-02,0.72227e-02, &
        & 0.61975e-02,0.50149e-02,0.36876e-02,0.28262e-02 /)
      kao(:, 3, 2, 8) = (/ &
        & 0.99020e-02,0.94876e-02,0.89395e-02,0.82200e-02,0.73884e-02, &
        & 0.63917e-02,0.52241e-02,0.39189e-02,0.31881e-02 /)
      kao(:, 4, 2, 8) = (/ &
        & 0.98208e-02,0.94907e-02,0.90072e-02,0.83409e-02,0.75534e-02, &
        & 0.65848e-02,0.54476e-02,0.41701e-02,0.35802e-02 /)
      kao(:, 5, 2, 8) = (/ &
        & 0.97350e-02,0.95036e-02,0.90758e-02,0.84664e-02,0.77179e-02, &
        & 0.67885e-02,0.56906e-02,0.44399e-02,0.40032e-02 /)
      kao(:, 1, 3, 8) = (/ &
        & 0.99249e-02,0.94002e-02,0.86731e-02,0.78226e-02,0.68627e-02, &
        & 0.57870e-02,0.45641e-02,0.32036e-02,0.20068e-02 /)
      kao(:, 2, 3, 8) = (/ &
        & 0.98781e-02,0.94039e-02,0.87415e-02,0.79225e-02,0.70078e-02, &
        & 0.59682e-02,0.47504e-02,0.33906e-02,0.22741e-02 /)
      kao(:, 3, 3, 8) = (/ &
        & 0.98245e-02,0.94056e-02,0.88077e-02,0.80290e-02,0.71634e-02, &
        & 0.61455e-02,0.49439e-02,0.35923e-02,0.25675e-02 /)
      kao(:, 4, 3, 8) = (/ &
        & 0.97585e-02,0.94181e-02,0.88723e-02,0.81452e-02,0.73134e-02, &
        & 0.63196e-02,0.51498e-02,0.38082e-02,0.28828e-02 /)
      kao(:, 5, 3, 8) = (/ &
        & 0.96800e-02,0.94346e-02,0.89400e-02,0.82650e-02,0.74596e-02, &
        & 0.65093e-02,0.53613e-02,0.40378e-02,0.32210e-02 /)
      kao(:, 1, 4, 8) = (/ &
        & 0.97390e-02,0.92223e-02,0.84805e-02,0.75962e-02,0.66183e-02, &
        & 0.55421e-02,0.43153e-02,0.29439e-02,0.16096e-02 /)
      kao(:, 2, 4, 8) = (/ &
        & 0.97149e-02,0.92440e-02,0.85515e-02,0.76965e-02,0.67525e-02, &
        & 0.57037e-02,0.44852e-02,0.31152e-02,0.18298e-02 /)
      kao(:, 3, 4, 8) = (/ &
        & 0.96772e-02,0.92607e-02,0.86210e-02,0.78004e-02,0.68947e-02, &
        & 0.58626e-02,0.46601e-02,0.32973e-02,0.20675e-02 /)
      kao(:, 4, 4, 8) = (/ &
        & 0.96222e-02,0.92823e-02,0.86884e-02,0.79077e-02,0.70317e-02, &
        & 0.60213e-02,0.48471e-02,0.34874e-02,0.23199e-02 /)
      kao(:, 5, 4, 8) = (/ &
        & 0.95548e-02,0.93032e-02,0.87544e-02,0.80177e-02,0.71673e-02, &
        & 0.61924e-02,0.50398e-02,0.36845e-02,0.25914e-02 /)
      kao(:, 1, 5, 8) = (/ &
        & 0.94682e-02,0.89654e-02,0.82210e-02,0.73222e-02,0.63403e-02, &
        & 0.52735e-02,0.40692e-02,0.27114e-02,0.12929e-02 /)
      kao(:, 2, 5, 8) = (/ &
        & 0.94609e-02,0.90053e-02,0.83016e-02,0.74278e-02,0.64685e-02, &
        & 0.54213e-02,0.42231e-02,0.28638e-02,0.14728e-02 /)
      kao(:, 3, 5, 8) = (/ &
        & 0.94353e-02,0.90391e-02,0.83802e-02,0.75305e-02,0.66027e-02, &
        & 0.55646e-02,0.43790e-02,0.30279e-02,0.16663e-02 /)
      kao(:, 4, 5, 8) = (/ &
        & 0.93989e-02,0.90684e-02,0.84481e-02,0.76404e-02,0.67294e-02, &
        & 0.57082e-02,0.45495e-02,0.31980e-02,0.18711e-02 /)
      kao(:, 5, 5, 8) = (/ &
        & 0.93472e-02,0.90926e-02,0.85136e-02,0.77442e-02,0.68542e-02, &
        & 0.58646e-02,0.47259e-02,0.33701e-02,0.20921e-02 /)
      kao(:, 1, 6, 8) = (/ &
        & 0.90687e-02,0.86083e-02,0.78842e-02,0.69920e-02,0.60171e-02, &
        & 0.49784e-02,0.38163e-02,0.24892e-02,0.10375e-02 /)
      kao(:, 2, 6, 8) = (/ &
        & 0.90845e-02,0.86742e-02,0.79759e-02,0.71037e-02,0.61494e-02, &
        & 0.51176e-02,0.39577e-02,0.26285e-02,0.11848e-02 /)
      kao(:, 3, 6, 8) = (/ &
        & 0.90836e-02,0.87225e-02,0.80580e-02,0.72119e-02,0.62799e-02, &
        & 0.52546e-02,0.41006e-02,0.27750e-02,0.13422e-02 /)
      kao(:, 4, 6, 8) = (/ &
        & 0.90655e-02,0.87611e-02,0.81305e-02,0.73221e-02,0.64054e-02, &
        & 0.53892e-02,0.42503e-02,0.29301e-02,0.15078e-02 /)
      kao(:, 5, 6, 8) = (/ &
        & 0.90286e-02,0.87944e-02,0.82022e-02,0.74247e-02,0.65248e-02, &
        & 0.55305e-02,0.44113e-02,0.30838e-02,0.16859e-02 /)
      kao(:, 1, 7, 8) = (/ &
        & 0.85850e-02,0.81350e-02,0.74326e-02,0.65794e-02,0.56482e-02, &
        & 0.46582e-02,0.35544e-02,0.22844e-02,0.80765e-03 /)
      kao(:, 2, 7, 8) = (/ &
        & 0.86250e-02,0.82179e-02,0.75359e-02,0.67022e-02,0.57899e-02, &
        & 0.47962e-02,0.36869e-02,0.24122e-02,0.92682e-03 /)
      kao(:, 3, 7, 8) = (/ &
        & 0.86440e-02,0.82839e-02,0.76315e-02,0.68246e-02,0.59218e-02, &
        & 0.49298e-02,0.38219e-02,0.25431e-02,0.10538e-02 /)
      kao(:, 4, 7, 8) = (/ &
        & 0.86410e-02,0.83371e-02,0.77195e-02,0.69421e-02,0.60483e-02, &
        & 0.50620e-02,0.39587e-02,0.26818e-02,0.11890e-02 /)
      kao(:, 5, 7, 8) = (/ &
        & 0.86213e-02,0.83816e-02,0.78035e-02,0.70537e-02,0.61695e-02, &
        & 0.51947e-02,0.41038e-02,0.28206e-02,0.13358e-02 /)
      kao(:, 1, 8, 8) = (/ &
        & 0.80690e-02,0.76260e-02,0.69398e-02,0.61270e-02,0.52372e-02, &
        & 0.42965e-02,0.32695e-02,0.20922e-02,0.69791e-03 /)
      kao(:, 2, 8, 8) = (/ &
        & 0.81346e-02,0.77325e-02,0.70609e-02,0.62554e-02,0.53744e-02, &
        & 0.44362e-02,0.34019e-02,0.22104e-02,0.78609e-03 /)
      kao(:, 3, 8, 8) = (/ &
        & 0.81749e-02,0.78188e-02,0.71688e-02,0.63791e-02,0.55086e-02, &
        & 0.45702e-02,0.35360e-02,0.23302e-02,0.88068e-03 /)
      kao(:, 4, 8, 8) = (/ &
        & 0.81959e-02,0.78839e-02,0.72650e-02,0.64997e-02,0.56387e-02, &
        & 0.47059e-02,0.36681e-02,0.24532e-02,0.97840e-03 /)
      kao(:, 5, 8, 8) = (/ &
        & 0.81937e-02,0.79411e-02,0.73546e-02,0.66134e-02,0.57649e-02, &
        & 0.48383e-02,0.38022e-02,0.25773e-02,0.10847e-02 /)
      kao(:, 1, 9, 8) = (/ &
        & 0.75182e-02,0.70907e-02,0.64287e-02,0.56605e-02,0.48216e-02, &
        & 0.39323e-02,0.29776e-02,0.18987e-02,0.67472e-03 /)
      kao(:, 2, 9, 8) = (/ &
        & 0.76076e-02,0.72195e-02,0.65653e-02,0.58009e-02,0.49640e-02, &
        & 0.40692e-02,0.31049e-02,0.20098e-02,0.74914e-03 /)
      kao(:, 3, 9, 8) = (/ &
        & 0.76735e-02,0.73227e-02,0.66862e-02,0.59346e-02,0.51012e-02, &
        & 0.42015e-02,0.32328e-02,0.21222e-02,0.83367e-03 /)
      kao(:, 4, 9, 8) = (/ &
        & 0.77132e-02,0.74045e-02,0.67969e-02,0.60620e-02,0.52309e-02, &
        & 0.43347e-02,0.33599e-02,0.22355e-02,0.91964e-03 /)
      kao(:, 5, 9, 8) = (/ &
        & 0.77286e-02,0.74752e-02,0.68965e-02,0.61793e-02,0.53584e-02, &
        & 0.44621e-02,0.34884e-02,0.23497e-02,0.10114e-02 /)
      kao(:, 1,10, 8) = (/ &
        & 0.70149e-02,0.65825e-02,0.59329e-02,0.52017e-02,0.44219e-02, &
        & 0.35899e-02,0.27069e-02,0.17187e-02,0.74519e-03 /)
      kao(:, 2,10, 8) = (/ &
        & 0.71248e-02,0.67269e-02,0.60810e-02,0.53515e-02,0.45670e-02, &
        & 0.37282e-02,0.28313e-02,0.18204e-02,0.83494e-03 /)
      kao(:, 3,10, 8) = (/ &
        & 0.72044e-02,0.68394e-02,0.62076e-02,0.54929e-02,0.47097e-02, &
        & 0.38613e-02,0.29540e-02,0.19235e-02,0.93279e-03 /)
      kao(:, 4,10, 8) = (/ &
        & 0.72597e-02,0.69309e-02,0.63267e-02,0.56269e-02,0.48423e-02, &
        & 0.39913e-02,0.30764e-02,0.20273e-02,0.10348e-02 /)
      kao(:, 5,10, 8) = (/ &
        & 0.72955e-02,0.70104e-02,0.64378e-02,0.57479e-02,0.49695e-02, &
        & 0.41180e-02,0.31960e-02,0.21324e-02,0.11387e-02 /)
      kao(:, 1,11, 8) = (/ &
        & 0.65628e-02,0.61735e-02,0.55551e-02,0.48677e-02,0.41265e-02, &
        & 0.33334e-02,0.25028e-02,0.15938e-02,0.74406e-03 /)
      kao(:, 2,11, 8) = (/ &
        & 0.66786e-02,0.63151e-02,0.57025e-02,0.50172e-02,0.42702e-02, &
        & 0.34674e-02,0.26229e-02,0.16875e-02,0.82711e-03 /)
      kao(:, 3,11, 8) = (/ &
        & 0.67664e-02,0.64350e-02,0.58347e-02,0.51562e-02,0.44059e-02, &
        & 0.35945e-02,0.27422e-02,0.17822e-02,0.92379e-03 /)
      kao(:, 4,11, 8) = (/ &
        & 0.68381e-02,0.65357e-02,0.59597e-02,0.52850e-02,0.45292e-02, &
        & 0.37195e-02,0.28585e-02,0.18773e-02,0.10214e-02 /)
      kao(:, 5,11, 8) = (/ &
        & 0.68910e-02,0.66274e-02,0.60702e-02,0.54014e-02,0.46503e-02, &
        & 0.38396e-02,0.29707e-02,0.19733e-02,0.11179e-02 /)
      kao(:, 1,12, 8) = (/ &
        & 0.60794e-02,0.57316e-02,0.51563e-02,0.45236e-02,0.38371e-02, &
        & 0.31013e-02,0.23239e-02,0.14745e-02,0.70212e-03 /)
      kao(:, 2,12, 8) = (/ &
        & 0.62026e-02,0.58782e-02,0.53110e-02,0.46778e-02,0.39838e-02, &
        & 0.32334e-02,0.24368e-02,0.15615e-02,0.77146e-03 /)
      kao(:, 3,12, 8) = (/ &
        & 0.63087e-02,0.60102e-02,0.54544e-02,0.48220e-02,0.41191e-02, &
        & 0.33562e-02,0.25462e-02,0.16493e-02,0.85116e-03 /)
      kao(:, 4,12, 8) = (/ &
        & 0.63948e-02,0.61265e-02,0.55863e-02,0.49541e-02,0.42453e-02, &
        & 0.34753e-02,0.26508e-02,0.17372e-02,0.93862e-03 /)
      kao(:, 5,12, 8) = (/ &
        & 0.64607e-02,0.62309e-02,0.57052e-02,0.50757e-02,0.43660e-02, &
        & 0.35907e-02,0.27548e-02,0.18249e-02,0.10221e-02 /)
      kao(:, 1,13, 8) = (/ &
        & 0.55937e-02,0.52793e-02,0.47517e-02,0.41692e-02,0.35394e-02, &
        & 0.28625e-02,0.21454e-02,0.13668e-02,0.61956e-03 /)
      kao(:, 2,13, 8) = (/ &
        & 0.57319e-02,0.54374e-02,0.49129e-02,0.43258e-02,0.36843e-02, &
        & 0.29907e-02,0.22551e-02,0.14474e-02,0.68007e-03 /)
      kao(:, 3,13, 8) = (/ &
        & 0.58515e-02,0.55788e-02,0.50622e-02,0.44734e-02,0.38194e-02, &
        & 0.31146e-02,0.23600e-02,0.15267e-02,0.75016e-03 /)
      kao(:, 4,13, 8) = (/ &
        & 0.59483e-02,0.57068e-02,0.51995e-02,0.46068e-02,0.39501e-02, &
        & 0.32357e-02,0.24610e-02,0.16061e-02,0.82038e-03 /)
      kao(:, 5,13, 8) = (/ &
        & 0.60233e-02,0.58195e-02,0.53236e-02,0.47349e-02,0.40732e-02, &
        & 0.33509e-02,0.25596e-02,0.16868e-02,0.89122e-03 /)
      kao(:, 1, 1, 9) = (/ &
        & 0.19771e-01,0.18370e-01,0.17356e-01,0.16079e-01,0.14680e-01, &
        & 0.13282e-01,0.11980e-01,0.11582e-01,0.12985e-01 /)
      kao(:, 2, 1, 9) = (/ &
        & 0.19636e-01,0.18337e-01,0.17425e-01,0.16276e-01,0.15036e-01, &
        & 0.13800e-01,0.12788e-01,0.12799e-01,0.14491e-01 /)
      kao(:, 3, 1, 9) = (/ &
        & 0.19487e-01,0.18291e-01,0.17516e-01,0.16543e-01,0.15458e-01, &
        & 0.14398e-01,0.13717e-01,0.14121e-01,0.16094e-01 /)
      kao(:, 4, 1, 9) = (/ &
        & 0.19329e-01,0.18244e-01,0.17665e-01,0.16858e-01,0.15921e-01, &
        & 0.15082e-01,0.14738e-01,0.15534e-01,0.17796e-01 /)
      kao(:, 5, 1, 9) = (/ &
        & 0.19162e-01,0.18208e-01,0.17862e-01,0.17203e-01,0.16407e-01, &
        & 0.15804e-01,0.15831e-01,0.17016e-01,0.19554e-01 /)
      kao(:, 1, 2, 9) = (/ &
        & 0.20491e-01,0.19041e-01,0.17931e-01,0.16490e-01,0.14871e-01, &
        & 0.13204e-01,0.11551e-01,0.10493e-01,0.11370e-01 /)
      kao(:, 2, 2, 9) = (/ &
        & 0.20351e-01,0.19021e-01,0.18003e-01,0.16688e-01,0.15207e-01, &
        & 0.13674e-01,0.12228e-01,0.11542e-01,0.12722e-01 /)
      kao(:, 3, 2, 9) = (/ &
        & 0.20205e-01,0.18987e-01,0.18097e-01,0.16946e-01,0.15590e-01, &
        & 0.14204e-01,0.13003e-01,0.12703e-01,0.14170e-01 /)
      kao(:, 4, 2, 9) = (/ &
        & 0.20054e-01,0.18946e-01,0.18241e-01,0.17244e-01,0.16012e-01, &
        & 0.14800e-01,0.13862e-01,0.13953e-01,0.15702e-01 /)
      kao(:, 5, 2, 9) = (/ &
        & 0.19890e-01,0.18914e-01,0.18431e-01,0.17568e-01,0.16464e-01, &
        & 0.15445e-01,0.14813e-01,0.15302e-01,0.17318e-01 /)
      kao(:, 1, 3, 9) = (/ &
        & 0.21143e-01,0.19662e-01,0.18419e-01,0.16811e-01,0.15005e-01, &
        & 0.13075e-01,0.11094e-01,0.93893e-02,0.95682e-02 /)
      kao(:, 2, 3, 9) = (/ &
        & 0.21021e-01,0.19658e-01,0.18498e-01,0.17007e-01,0.15312e-01, &
        & 0.13491e-01,0.11661e-01,0.10256e-01,0.10742e-01 /)
      kao(:, 3, 3, 9) = (/ &
        & 0.20887e-01,0.19635e-01,0.18594e-01,0.17251e-01,0.15669e-01, &
        & 0.13959e-01,0.12304e-01,0.11227e-01,0.12012e-01 /)
      kao(:, 4, 3, 9) = (/ &
        & 0.20742e-01,0.19603e-01,0.18727e-01,0.17530e-01,0.16058e-01, &
        & 0.14485e-01,0.13015e-01,0.12294e-01,0.13375e-01 /)
      kao(:, 5, 3, 9) = (/ &
        & 0.20582e-01,0.19578e-01,0.18903e-01,0.17831e-01,0.16483e-01, &
        & 0.15047e-01,0.13818e-01,0.13471e-01,0.14836e-01 /)
      kao(:, 1, 4, 9) = (/ &
        & 0.21726e-01,0.20199e-01,0.18812e-01,0.17047e-01,0.15080e-01, &
        & 0.12938e-01,0.10693e-01,0.84650e-02,0.79270e-02 /)
      kao(:, 2, 4, 9) = (/ &
        & 0.21624e-01,0.20213e-01,0.18897e-01,0.17238e-01,0.15368e-01, &
        & 0.13326e-01,0.11175e-01,0.91656e-02,0.89409e-02 /)
      kao(:, 3, 4, 9) = (/ &
        & 0.21502e-01,0.20207e-01,0.18990e-01,0.17468e-01,0.15708e-01, &
        & 0.13755e-01,0.11721e-01,0.99561e-02,0.10044e-01 /)
      kao(:, 4, 4, 9) = (/ &
        & 0.21364e-01,0.20186e-01,0.19114e-01,0.17747e-01,0.16075e-01, &
        & 0.14230e-01,0.12327e-01,0.10844e-01,0.11238e-01 /)
      kao(:, 5, 4, 9) = (/ &
        & 0.21208e-01,0.20165e-01,0.19280e-01,0.18035e-01,0.16477e-01, &
        & 0.14734e-01,0.13004e-01,0.11837e-01,0.12527e-01 /)
      kao(:, 1, 5, 9) = (/ &
        & 0.22212e-01,0.20643e-01,0.19101e-01,0.17193e-01,0.15094e-01, &
        & 0.12790e-01,0.10344e-01,0.77661e-02,0.65292e-02 /)
      kao(:, 2, 5, 9) = (/ &
        & 0.22131e-01,0.20679e-01,0.19192e-01,0.17388e-01,0.15373e-01, &
        & 0.13156e-01,0.10779e-01,0.83326e-02,0.74004e-02 /)
      kao(:, 3, 5, 9) = (/ &
        & 0.22024e-01,0.20689e-01,0.19289e-01,0.17614e-01,0.15701e-01, &
        & 0.13560e-01,0.11259e-01,0.89716e-02,0.83509e-02 /)
      kao(:, 4, 5, 9) = (/ &
        & 0.21891e-01,0.20674e-01,0.19419e-01,0.17880e-01,0.16055e-01, &
        & 0.14002e-01,0.11784e-01,0.96942e-02,0.93863e-02 /)
      kao(:, 5, 5, 9) = (/ &
        & 0.21733e-01,0.20659e-01,0.19581e-01,0.18166e-01,0.16436e-01, &
        & 0.14467e-01,0.12356e-01,0.10508e-01,0.10499e-01 /)
      kao(:, 1, 6, 9) = (/ &
        & 0.22561e-01,0.20963e-01,0.19278e-01,0.17248e-01,0.15027e-01, &
        & 0.12605e-01,0.99913e-02,0.71998e-02,0.53191e-02 /)
      kao(:, 2, 6, 9) = (/ &
        & 0.22505e-01,0.21027e-01,0.19391e-01,0.17451e-01,0.15296e-01, &
        & 0.12947e-01,0.10394e-01,0.76719e-02,0.60628e-02 /)
      kao(:, 3, 6, 9) = (/ &
        & 0.22407e-01,0.21057e-01,0.19505e-01,0.17673e-01,0.15617e-01, &
        & 0.13330e-01,0.10834e-01,0.82004e-02,0.68698e-02 /)
      kao(:, 4, 6, 9) = (/ &
        & 0.22287e-01,0.21061e-01,0.19636e-01,0.17933e-01,0.15963e-01, &
        & 0.13742e-01,0.11312e-01,0.87854e-02,0.77488e-02 /)
      kao(:, 5, 6, 9) = (/ &
        & 0.22148e-01,0.21053e-01,0.19794e-01,0.18212e-01,0.16329e-01, &
        & 0.14180e-01,0.11816e-01,0.94417e-02,0.86993e-02 /)
      kao(:, 1, 7, 9) = (/ &
        & 0.22745e-01,0.21135e-01,0.19327e-01,0.17197e-01,0.14893e-01, &
        & 0.12374e-01,0.96536e-02,0.67256e-02,0.43127e-02 /)
      kao(:, 2, 7, 9) = (/ &
        & 0.22707e-01,0.21230e-01,0.19474e-01,0.17423e-01,0.15162e-01, &
        & 0.12700e-01,0.10030e-01,0.71370e-02,0.49389e-02 /)
      kao(:, 3, 7, 9) = (/ &
        & 0.22632e-01,0.21281e-01,0.19608e-01,0.17649e-01,0.15471e-01, &
        & 0.13070e-01,0.10436e-01,0.75822e-02,0.56174e-02 /)
      kao(:, 4, 7, 9) = (/ &
        & 0.22537e-01,0.21307e-01,0.19744e-01,0.17903e-01,0.15813e-01, &
        & 0.13461e-01,0.10872e-01,0.80682e-02,0.63562e-02 /)
      kao(:, 5, 7, 9) = (/ &
        & 0.22420e-01,0.21314e-01,0.19904e-01,0.18182e-01,0.16160e-01, &
        & 0.13874e-01,0.11331e-01,0.86088e-02,0.71565e-02 /)
      kao(:, 1, 8, 9) = (/ &
        & 0.22742e-01,0.21141e-01,0.19244e-01,0.17036e-01,0.14667e-01, &
        & 0.12093e-01,0.93194e-02,0.63016e-02,0.33604e-02 /)
      kao(:, 2, 8, 9) = (/ &
        & 0.22738e-01,0.21267e-01,0.19420e-01,0.17289e-01,0.14951e-01, &
        & 0.12414e-01,0.96717e-02,0.66654e-02,0.38903e-02 /)
      kao(:, 3, 8, 9) = (/ &
        & 0.22699e-01,0.21347e-01,0.19574e-01,0.17525e-01,0.15260e-01, &
        & 0.12775e-01,0.10048e-01,0.70608e-02,0.44626e-02 /)
      kao(:, 4, 8, 9) = (/ &
        & 0.22634e-01,0.21402e-01,0.19725e-01,0.17775e-01,0.15596e-01, &
        & 0.13150e-01,0.10455e-01,0.74847e-02,0.50904e-02 /)
      kao(:, 5, 8, 9) = (/ &
        & 0.22550e-01,0.21432e-01,0.19888e-01,0.18059e-01,0.15936e-01, &
        & 0.13540e-01,0.10879e-01,0.79454e-02,0.57754e-02 /)
      kao(:, 1, 9, 9) = (/ &
        & 0.22571e-01,0.20980e-01,0.19017e-01,0.16764e-01,0.14350e-01, &
        & 0.11743e-01,0.89583e-02,0.59107e-02,0.27753e-02 /)
      kao(:, 2, 9, 9) = (/ &
        & 0.22607e-01,0.21147e-01,0.19231e-01,0.17040e-01,0.14648e-01, &
        & 0.12069e-01,0.92988e-02,0.62425e-02,0.31527e-02 /)
      kao(:, 3, 9, 9) = (/ &
        & 0.22609e-01,0.21268e-01,0.19413e-01,0.17284e-01,0.14954e-01, &
        & 0.12424e-01,0.96568e-02,0.66010e-02,0.35387e-02 /)
      kao(:, 4, 9, 9) = (/ &
        & 0.22589e-01,0.21355e-01,0.19582e-01,0.17535e-01,0.15285e-01, &
        & 0.12790e-01,0.10038e-01,0.69765e-02,0.39766e-02 /)
      kao(:, 5, 9, 9) = (/ &
        & 0.22546e-01,0.21413e-01,0.19758e-01,0.17821e-01,0.15622e-01, &
        & 0.13166e-01,0.10432e-01,0.73821e-02,0.44450e-02 /)
      kao(:, 1,10, 9) = (/ &
        & 0.22137e-01,0.20618e-01,0.18650e-01,0.16403e-01,0.13972e-01, &
        & 0.11364e-01,0.85848e-02,0.55632e-02,0.31593e-02 /)
      kao(:, 2,10, 9) = (/ &
        & 0.22231e-01,0.20835e-01,0.18905e-01,0.16706e-01,0.14289e-01, &
        & 0.11695e-01,0.89167e-02,0.58739e-02,0.35325e-02 /)
      kao(:, 3,10, 9) = (/ &
        & 0.22295e-01,0.21010e-01,0.19131e-01,0.16972e-01,0.14595e-01, &
        & 0.12040e-01,0.92665e-02,0.62059e-02,0.39315e-02 /)
      kao(:, 4,10, 9) = (/ &
        & 0.22331e-01,0.21144e-01,0.19334e-01,0.17233e-01,0.14916e-01, &
        & 0.12396e-01,0.96355e-02,0.65507e-02,0.43409e-02 /)
      kao(:, 5,10, 9) = (/ &
        & 0.22332e-01,0.21248e-01,0.19527e-01,0.17517e-01,0.15252e-01, &
        & 0.12765e-01,0.10012e-01,0.69176e-02,0.47851e-02 /)
      kao(:, 1,11, 9) = (/ &
        & 0.21611e-01,0.20177e-01,0.18220e-01,0.16014e-01,0.13625e-01, &
        & 0.11072e-01,0.83376e-02,0.53526e-02,0.32967e-02 /)
      kao(:, 2,11, 9) = (/ &
        & 0.21754e-01,0.20431e-01,0.18507e-01,0.16333e-01,0.13954e-01, &
        & 0.11415e-01,0.86702e-02,0.56558e-02,0.36779e-02 /)
      kao(:, 3,11, 9) = (/ &
        & 0.21862e-01,0.20634e-01,0.18769e-01,0.16624e-01,0.14280e-01, &
        & 0.11762e-01,0.90145e-02,0.59759e-02,0.40891e-02 /)
      kao(:, 4,11, 9) = (/ &
        & 0.21929e-01,0.20796e-01,0.18995e-01,0.16914e-01,0.14621e-01, &
        & 0.12122e-01,0.93752e-02,0.63026e-02,0.45492e-02 /)
      kao(:, 5,11, 9) = (/ &
        & 0.21956e-01,0.20925e-01,0.19222e-01,0.17218e-01,0.14974e-01, &
        & 0.12492e-01,0.97406e-02,0.66508e-02,0.50324e-02 /)
      kao(:, 1,12, 9) = (/ &
        & 0.20989e-01,0.19649e-01,0.17719e-01,0.15554e-01,0.13207e-01, &
        & 0.10709e-01,0.80423e-02,0.51308e-02,0.32152e-02 /)
      kao(:, 2,12, 9) = (/ &
        & 0.21187e-01,0.19941e-01,0.18042e-01,0.15892e-01,0.13549e-01, &
        & 0.11055e-01,0.83766e-02,0.54250e-02,0.35851e-02 /)
      kao(:, 3,12, 9) = (/ &
        & 0.21336e-01,0.20173e-01,0.18327e-01,0.16203e-01,0.13894e-01, &
        & 0.11411e-01,0.87228e-02,0.57329e-02,0.40006e-02 /)
      kao(:, 4,12, 9) = (/ &
        & 0.21440e-01,0.20364e-01,0.18584e-01,0.16516e-01,0.14243e-01, &
        & 0.11781e-01,0.90825e-02,0.60483e-02,0.44327e-02 /)
      kao(:, 5,12, 9) = (/ &
        & 0.21509e-01,0.20531e-01,0.18841e-01,0.16838e-01,0.14607e-01, &
        & 0.12155e-01,0.94413e-02,0.63798e-02,0.48628e-02 /)
      kao(:, 1,13, 9) = (/ &
        & 0.20300e-01,0.19036e-01,0.17142e-01,0.15033e-01,0.12745e-01, &
        & 0.10318e-01,0.77330e-02,0.48977e-02,0.29186e-02 /)
      kao(:, 2,13, 9) = (/ &
        & 0.20539e-01,0.19361e-01,0.17504e-01,0.15398e-01,0.13114e-01, &
        & 0.10679e-01,0.80651e-02,0.51844e-02,0.32743e-02 /)
      kao(:, 3,13, 9) = (/ &
        & 0.20734e-01,0.19633e-01,0.17821e-01,0.15739e-01,0.13481e-01, &
        & 0.11044e-01,0.84099e-02,0.54812e-02,0.36601e-02 /)
      kao(:, 4,13, 9) = (/ &
        & 0.20892e-01,0.19871e-01,0.18120e-01,0.16090e-01,0.13847e-01, &
        & 0.11415e-01,0.87615e-02,0.57863e-02,0.40403e-02 /)
      kao(:, 5,13, 9) = (/ &
        & 0.21016e-01,0.20092e-01,0.18420e-01,0.16433e-01,0.14220e-01, &
        & 0.11787e-01,0.91177e-02,0.61020e-02,0.44775e-02 /)
      kao(:, 1, 1,10) = (/ &
        & 0.32077e-01,0.29717e-01,0.27957e-01,0.27088e-01,0.26148e-01, &
        & 0.25463e-01,0.27887e-01,0.32409e-01,0.37623e-01 /)
      kao(:, 2, 1,10) = (/ &
        & 0.31656e-01,0.29512e-01,0.28047e-01,0.27317e-01,0.26667e-01, &
        & 0.26788e-01,0.30344e-01,0.35248e-01,0.40533e-01 /)
      kao(:, 3, 1,10) = (/ &
        & 0.31222e-01,0.29398e-01,0.28183e-01,0.27633e-01,0.27598e-01, &
        & 0.28788e-01,0.33344e-01,0.38694e-01,0.44458e-01 /)
      kao(:, 4, 1,10) = (/ &
        & 0.30838e-01,0.29185e-01,0.28219e-01,0.28269e-01,0.28900e-01, &
        & 0.31215e-01,0.36765e-01,0.42659e-01,0.48710e-01 /)
      kao(:, 5, 1,10) = (/ &
        & 0.30476e-01,0.28982e-01,0.28435e-01,0.29011e-01,0.30822e-01, &
        & 0.34422e-01,0.40770e-01,0.47309e-01,0.54027e-01 /)
      kao(:, 1, 2,10) = (/ &
        & 0.34215e-01,0.31859e-01,0.30015e-01,0.28551e-01,0.26684e-01, &
        & 0.25243e-01,0.25874e-01,0.29803e-01,0.34327e-01 /)
      kao(:, 2, 2,10) = (/ &
        & 0.33819e-01,0.31701e-01,0.30099e-01,0.28712e-01,0.27156e-01, &
        & 0.26446e-01,0.28380e-01,0.32886e-01,0.37685e-01 /)
      kao(:, 3, 2,10) = (/ &
        & 0.33393e-01,0.31477e-01,0.30146e-01,0.28931e-01,0.28112e-01, &
        & 0.28308e-01,0.31383e-01,0.36360e-01,0.41605e-01 /)
      kao(:, 4, 2,10) = (/ &
        & 0.33012e-01,0.31222e-01,0.30110e-01,0.29460e-01,0.29343e-01, &
        & 0.30463e-01,0.34829e-01,0.40350e-01,0.46115e-01 /)
      kao(:, 5, 2,10) = (/ &
        & 0.32618e-01,0.30977e-01,0.30249e-01,0.30140e-01,0.31029e-01, &
        & 0.33086e-01,0.38518e-01,0.44611e-01,0.51063e-01 /)
      kao(:, 1, 3,10) = (/ &
        & 0.36609e-01,0.34016e-01,0.32008e-01,0.30013e-01,0.27528e-01, &
        & 0.25143e-01,0.24092e-01,0.26746e-01,0.30590e-01 /)
      kao(:, 2, 3,10) = (/ &
        & 0.36187e-01,0.33816e-01,0.32068e-01,0.30121e-01,0.27943e-01, &
        & 0.26137e-01,0.26190e-01,0.29769e-01,0.34003e-01 /)
      kao(:, 3, 3,10) = (/ &
        & 0.35755e-01,0.33555e-01,0.32022e-01,0.30354e-01,0.28696e-01, &
        & 0.27732e-01,0.28744e-01,0.33056e-01,0.37754e-01 /)
      kao(:, 4, 3,10) = (/ &
        & 0.35304e-01,0.33277e-01,0.31985e-01,0.30856e-01,0.29759e-01, &
        & 0.29582e-01,0.31793e-01,0.36769e-01,0.41965e-01 /)
      kao(:, 5, 3,10) = (/ &
        & 0.34895e-01,0.32987e-01,0.32094e-01,0.31490e-01,0.31100e-01, &
        & 0.31735e-01,0.35104e-01,0.40646e-01,0.46442e-01 /)
      kao(:, 1, 4,10) = (/ &
        & 0.38977e-01,0.36120e-01,0.33897e-01,0.31410e-01,0.28525e-01, &
        & 0.25373e-01,0.22918e-01,0.23596e-01,0.26905e-01 /)
      kao(:, 2, 4,10) = (/ &
        & 0.38508e-01,0.35924e-01,0.33917e-01,0.31530e-01,0.28933e-01, &
        & 0.26161e-01,0.24652e-01,0.26430e-01,0.30108e-01 /)
      kao(:, 3, 4,10) = (/ &
        & 0.38014e-01,0.35658e-01,0.33872e-01,0.31757e-01,0.29547e-01, &
        & 0.27436e-01,0.26616e-01,0.29450e-01,0.33541e-01 /)
      kao(:, 4, 4,10) = (/ &
        & 0.37555e-01,0.35363e-01,0.33895e-01,0.32125e-01,0.30540e-01, &
        & 0.28878e-01,0.28956e-01,0.32793e-01,0.37351e-01 /)
      kao(:, 5, 4,10) = (/ &
        & 0.37151e-01,0.35088e-01,0.33984e-01,0.32788e-01,0.31573e-01, &
        & 0.30633e-01,0.31627e-01,0.36308e-01,0.41371e-01 /)
      kao(:, 1, 5,10) = (/ &
        & 0.41153e-01,0.38034e-01,0.35706e-01,0.32805e-01,0.29387e-01, &
        & 0.25927e-01,0.22231e-01,0.20561e-01,0.23186e-01 /)
      kao(:, 2, 5,10) = (/ &
        & 0.40611e-01,0.37835e-01,0.35759e-01,0.32923e-01,0.29781e-01, &
        & 0.26577e-01,0.23565e-01,0.23003e-01,0.26110e-01 /)
      kao(:, 3, 5,10) = (/ &
        & 0.40174e-01,0.37589e-01,0.35747e-01,0.33131e-01,0.30334e-01, &
        & 0.27648e-01,0.25145e-01,0.25696e-01,0.29208e-01 /)
      kao(:, 4, 5,10) = (/ &
        & 0.39802e-01,0.37389e-01,0.35760e-01,0.33447e-01,0.31294e-01, &
        & 0.28785e-01,0.27005e-01,0.28729e-01,0.32665e-01 /)
      kao(:, 5, 5,10) = (/ &
        & 0.39471e-01,0.37195e-01,0.35872e-01,0.34084e-01,0.32227e-01, &
        & 0.30087e-01,0.29177e-01,0.32029e-01,0.36449e-01 /)
      kao(:, 1, 6,10) = (/ &
        & 0.43370e-01,0.39997e-01,0.37440e-01,0.34118e-01,0.30345e-01, &
        & 0.26246e-01,0.21955e-01,0.18231e-01,0.19573e-01 /)
      kao(:, 2, 6,10) = (/ &
        & 0.42801e-01,0.39763e-01,0.37480e-01,0.34252e-01,0.30723e-01, &
        & 0.26892e-01,0.22943e-01,0.20080e-01,0.22108e-01 /)
      kao(:, 3, 6,10) = (/ &
        & 0.42453e-01,0.39592e-01,0.37449e-01,0.34486e-01,0.31160e-01, &
        & 0.27853e-01,0.24129e-01,0.22254e-01,0.24945e-01 /)
      kao(:, 4, 6,10) = (/ &
        & 0.42151e-01,0.39446e-01,0.37500e-01,0.34777e-01,0.31970e-01, &
        & 0.28872e-01,0.25539e-01,0.24809e-01,0.28086e-01 /)
      kao(:, 5, 6,10) = (/ &
        & 0.41833e-01,0.39344e-01,0.37631e-01,0.35392e-01,0.32810e-01, &
        & 0.29983e-01,0.27309e-01,0.27744e-01,0.31535e-01 /)
      kao(:, 1, 7,10) = (/ &
        & 0.45445e-01,0.41961e-01,0.39238e-01,0.35426e-01,0.31192e-01, &
        & 0.26649e-01,0.21695e-01,0.16623e-01,0.16293e-01 /)
      kao(:, 2, 7,10) = (/ &
        & 0.45078e-01,0.41797e-01,0.39225e-01,0.35507e-01,0.31562e-01, &
        & 0.27229e-01,0.22532e-01,0.18019e-01,0.18534e-01 /)
      kao(:, 3, 7,10) = (/ &
        & 0.44870e-01,0.41785e-01,0.39209e-01,0.35749e-01,0.31958e-01, &
        & 0.27976e-01,0.23572e-01,0.19783e-01,0.21105e-01 /)
      kao(:, 4, 7,10) = (/ &
        & 0.44638e-01,0.41726e-01,0.39301e-01,0.35989e-01,0.32614e-01, &
        & 0.28887e-01,0.24743e-01,0.21842e-01,0.23947e-01 /)
      kao(:, 5, 7,10) = (/ &
        & 0.44319e-01,0.41703e-01,0.39403e-01,0.36491e-01,0.33461e-01, &
        & 0.29864e-01,0.26133e-01,0.24238e-01,0.27063e-01 /)
      kao(:, 1, 8,10) = (/ &
        & 0.47338e-01,0.43694e-01,0.40795e-01,0.36657e-01,0.31991e-01, &
        & 0.26976e-01,0.21436e-01,0.15589e-01,0.13371e-01 /)
      kao(:, 2, 8,10) = (/ &
        & 0.47172e-01,0.43681e-01,0.40850e-01,0.36728e-01,0.32341e-01, &
        & 0.27474e-01,0.22184e-01,0.16691e-01,0.15337e-01 /)
      kao(:, 3, 8,10) = (/ &
        & 0.47077e-01,0.43885e-01,0.40965e-01,0.37016e-01,0.32654e-01, &
        & 0.28038e-01,0.23084e-01,0.18052e-01,0.17670e-01 /)
      kao(:, 4, 8,10) = (/ &
        & 0.46877e-01,0.43984e-01,0.41138e-01,0.37264e-01,0.33142e-01, &
        & 0.28868e-01,0.24126e-01,0.19696e-01,0.20174e-01 /)
      kao(:, 5, 8,10) = (/ &
        & 0.46627e-01,0.44042e-01,0.41218e-01,0.37582e-01,0.33931e-01, &
        & 0.29818e-01,0.25367e-01,0.21590e-01,0.22899e-01 /)
      kao(:, 1, 9,10) = (/ &
        & 0.49069e-01,0.45230e-01,0.41949e-01,0.37482e-01,0.32547e-01, &
        & 0.27221e-01,0.21190e-01,0.14771e-01,0.82104e-02 /)
      kao(:, 2, 9,10) = (/ &
        & 0.48982e-01,0.45358e-01,0.42113e-01,0.37642e-01,0.32970e-01, &
        & 0.27650e-01,0.21850e-01,0.15738e-01,0.94586e-02 /)
      kao(:, 3, 9,10) = (/ &
        & 0.48934e-01,0.45677e-01,0.42390e-01,0.38084e-01,0.33301e-01, &
        & 0.28097e-01,0.22664e-01,0.16844e-01,0.11686e-01 /)
      kao(:, 4, 9,10) = (/ &
        & 0.48760e-01,0.45876e-01,0.42614e-01,0.38405e-01,0.33732e-01, &
        & 0.28793e-01,0.23625e-01,0.18186e-01,0.14417e-01 /)
      kao(:, 5, 9,10) = (/ &
        & 0.48535e-01,0.45946e-01,0.42722e-01,0.38669e-01,0.34439e-01, &
        & 0.29718e-01,0.24746e-01,0.19636e-01,0.17490e-01 /)
      kao(:, 1,10,10) = (/ &
        & 0.50581e-01,0.46588e-01,0.42861e-01,0.37978e-01,0.32756e-01, &
        & 0.27218e-01,0.20963e-01,0.14152e-01,0.94977e-02 /)
      kao(:, 2,10,10) = (/ &
        & 0.50552e-01,0.46832e-01,0.43092e-01,0.38231e-01,0.33230e-01, &
        & 0.27672e-01,0.21597e-01,0.15000e-01,0.11069e-01 /)
      kao(:, 3,10,10) = (/ &
        & 0.50470e-01,0.47126e-01,0.43390e-01,0.38763e-01,0.33692e-01, &
        & 0.28191e-01,0.22303e-01,0.15932e-01,0.12529e-01 /)
      kao(:, 4,10,10) = (/ &
        & 0.50251e-01,0.47290e-01,0.43621e-01,0.39150e-01,0.34250e-01, &
        & 0.28907e-01,0.23153e-01,0.17091e-01,0.14647e-01 /)
      kao(:, 5,10,10) = (/ &
        & 0.50025e-01,0.47335e-01,0.43789e-01,0.39526e-01,0.34961e-01, &
        & 0.29783e-01,0.24207e-01,0.18303e-01,0.16505e-01 /)
      kao(:, 1,11,10) = (/ &
        & 0.51775e-01,0.47733e-01,0.43604e-01,0.38377e-01,0.33010e-01, &
        & 0.27211e-01,0.20853e-01,0.13952e-01,0.10099e-01 /)
      kao(:, 2,11,10) = (/ &
        & 0.51722e-01,0.48082e-01,0.43912e-01,0.38859e-01,0.33550e-01, &
        & 0.27720e-01,0.21535e-01,0.14746e-01,0.11460e-01 /)
      kao(:, 3,11,10) = (/ &
        & 0.51577e-01,0.48309e-01,0.44107e-01,0.39371e-01,0.34132e-01, &
        & 0.28431e-01,0.22288e-01,0.15640e-01,0.12761e-01 /)
      kao(:, 4,11,10) = (/ &
        & 0.51367e-01,0.48474e-01,0.44409e-01,0.39819e-01,0.34807e-01, &
        & 0.29240e-01,0.23192e-01,0.16707e-01,0.14096e-01 /)
      kao(:, 5,11,10) = (/ &
        & 0.51186e-01,0.48565e-01,0.44658e-01,0.40350e-01,0.35545e-01, &
        & 0.30221e-01,0.24214e-01,0.17744e-01,0.15290e-01 /)
      kao(:, 1,12,10) = (/ &
        & 0.52731e-01,0.48681e-01,0.44186e-01,0.38733e-01,0.33169e-01, &
        & 0.27108e-01,0.20634e-01,0.13723e-01,0.97949e-02 /)
      kao(:, 2,12,10) = (/ &
        & 0.52654e-01,0.49001e-01,0.44433e-01,0.39315e-01,0.33776e-01, &
        & 0.27772e-01,0.21363e-01,0.14506e-01,0.11186e-01 /)
      kao(:, 3,12,10) = (/ &
        & 0.52581e-01,0.49321e-01,0.44768e-01,0.39827e-01,0.34382e-01, &
        & 0.28565e-01,0.22205e-01,0.15366e-01,0.12310e-01 /)
      kao(:, 4,12,10) = (/ &
        & 0.52474e-01,0.49527e-01,0.45170e-01,0.40364e-01,0.35120e-01, &
        & 0.29376e-01,0.23174e-01,0.16305e-01,0.14325e-01 /)
      kao(:, 5,12,10) = (/ &
        & 0.52313e-01,0.49659e-01,0.45526e-01,0.41026e-01,0.35905e-01, &
        & 0.30399e-01,0.24222e-01,0.17291e-01,0.16045e-01 /)
      kao(:, 1,13,10) = (/ &
        & 0.53347e-01,0.49460e-01,0.44667e-01,0.39102e-01,0.33300e-01, &
        & 0.27005e-01,0.20373e-01,0.13403e-01,0.88882e-02 /)
      kao(:, 2,13,10) = (/ &
        & 0.53473e-01,0.49893e-01,0.44992e-01,0.39672e-01,0.33886e-01, &
        & 0.27737e-01,0.21157e-01,0.14194e-01,0.99472e-02 /)
      kao(:, 3,13,10) = (/ &
        & 0.53543e-01,0.50285e-01,0.45484e-01,0.40250e-01,0.34541e-01, &
        & 0.28510e-01,0.22035e-01,0.15061e-01,0.11235e-01 /)
      kao(:, 4,13,10) = (/ &
        & 0.53461e-01,0.50524e-01,0.45912e-01,0.40827e-01,0.35322e-01, &
        & 0.29374e-01,0.23048e-01,0.15925e-01,0.12822e-01 /)
      kao(:, 5,13,10) = (/ &
        & 0.53278e-01,0.50624e-01,0.46303e-01,0.41556e-01,0.36186e-01, &
        & 0.30414e-01,0.24058e-01,0.16868e-01,0.14203e-01 /)
      kao(:, 1, 1,11) = (/ &
        & 0.37171e-01,0.34434e-01,0.32644e-01,0.32703e-01,0.33235e-01, &
        & 0.36611e-01,0.43526e-01,0.50696e-01,0.58297e-01 /)
      kao(:, 2, 1,11) = (/ &
        & 0.36741e-01,0.34071e-01,0.32455e-01,0.33094e-01,0.34229e-01, &
        & 0.38792e-01,0.46364e-01,0.53998e-01,0.61977e-01 /)
      kao(:, 3, 1,11) = (/ &
        & 0.36310e-01,0.33795e-01,0.32514e-01,0.33548e-01,0.35414e-01, &
        & 0.41445e-01,0.49627e-01,0.57817e-01,0.66049e-01 /)
      kao(:, 4, 1,11) = (/ &
        & 0.35845e-01,0.33632e-01,0.32631e-01,0.34397e-01,0.37428e-01, &
        & 0.44985e-01,0.53868e-01,0.62763e-01,0.71579e-01 /)
      kao(:, 5, 1,11) = (/ &
        & 0.35331e-01,0.33379e-01,0.32910e-01,0.35528e-01,0.39783e-01, &
        & 0.48705e-01,0.58316e-01,0.67942e-01,0.77160e-01 /)
      kao(:, 1, 2,11) = (/ &
        & 0.40448e-01,0.37395e-01,0.35029e-01,0.34305e-01,0.33991e-01, &
        & 0.35316e-01,0.40968e-01,0.47712e-01,0.54932e-01 /)
      kao(:, 2, 2,11) = (/ &
        & 0.39920e-01,0.36968e-01,0.34927e-01,0.34599e-01,0.34841e-01, &
        & 0.37250e-01,0.43923e-01,0.51161e-01,0.58827e-01 /)
      kao(:, 3, 2,11) = (/ &
        & 0.39405e-01,0.36691e-01,0.34999e-01,0.35076e-01,0.35924e-01, &
        & 0.39772e-01,0.47443e-01,0.55253e-01,0.63303e-01 /)
      kao(:, 4, 2,11) = (/ &
        & 0.38792e-01,0.36414e-01,0.35121e-01,0.35787e-01,0.37790e-01, &
        & 0.43290e-01,0.51773e-01,0.60284e-01,0.68983e-01 /)
      kao(:, 5, 2,11) = (/ &
        & 0.38190e-01,0.36098e-01,0.35328e-01,0.36844e-01,0.39952e-01, &
        & 0.47291e-01,0.56573e-01,0.65870e-01,0.75177e-01 /)
      kao(:, 1, 3,11) = (/ &
        & 0.43810e-01,0.40500e-01,0.37754e-01,0.36293e-01,0.34676e-01, &
        & 0.34367e-01,0.37493e-01,0.43650e-01,0.50087e-01 /)
      kao(:, 2, 3,11) = (/ &
        & 0.43199e-01,0.40018e-01,0.37716e-01,0.36450e-01,0.35395e-01, &
        & 0.35866e-01,0.40426e-01,0.47076e-01,0.53958e-01 /)
      kao(:, 3, 3,11) = (/ &
        & 0.42538e-01,0.39757e-01,0.37868e-01,0.36772e-01,0.36302e-01, &
        & 0.37914e-01,0.44070e-01,0.51299e-01,0.58670e-01 /)
      kao(:, 4, 3,11) = (/ &
        & 0.41856e-01,0.39457e-01,0.37979e-01,0.37163e-01,0.37947e-01, &
        & 0.40970e-01,0.48419e-01,0.56334e-01,0.64404e-01 /)
      kao(:, 5, 3,11) = (/ &
        & 0.41250e-01,0.39154e-01,0.38065e-01,0.38049e-01,0.39929e-01, &
        & 0.44658e-01,0.53223e-01,0.61909e-01,0.70665e-01 /)
      kao(:, 1, 4,11) = (/ &
        & 0.47088e-01,0.43589e-01,0.40605e-01,0.38686e-01,0.35713e-01, &
        & 0.33942e-01,0.34171e-01,0.39143e-01,0.44787e-01 /)
      kao(:, 2, 4,11) = (/ &
        & 0.46380e-01,0.43081e-01,0.40678e-01,0.38772e-01,0.36271e-01, &
        & 0.35115e-01,0.36728e-01,0.42523e-01,0.48625e-01 /)
      kao(:, 3, 4,11) = (/ &
        & 0.45787e-01,0.42889e-01,0.40853e-01,0.39000e-01,0.36901e-01, &
        & 0.36794e-01,0.40276e-01,0.46812e-01,0.53448e-01 /)
      kao(:, 4, 4,11) = (/ &
        & 0.45216e-01,0.42628e-01,0.40916e-01,0.39286e-01,0.38129e-01, &
        & 0.39329e-01,0.44499e-01,0.51734e-01,0.59041e-01 /)
      kao(:, 5, 4,11) = (/ &
        & 0.44698e-01,0.42312e-01,0.40992e-01,0.39909e-01,0.39896e-01, &
        & 0.42322e-01,0.49157e-01,0.57134e-01,0.65206e-01 /)
      kao(:, 1, 5,11) = (/ &
        & 0.50564e-01,0.46864e-01,0.43550e-01,0.41145e-01,0.37282e-01, &
        & 0.33847e-01,0.31921e-01,0.34655e-01,0.39581e-01 /)
      kao(:, 2, 5,11) = (/ &
        & 0.49853e-01,0.46324e-01,0.43735e-01,0.41212e-01,0.37826e-01, &
        & 0.34760e-01,0.33939e-01,0.37988e-01,0.43340e-01 /)
      kao(:, 3, 5,11) = (/ &
        & 0.49277e-01,0.46142e-01,0.43937e-01,0.41409e-01,0.38245e-01, &
        & 0.36079e-01,0.36891e-01,0.42172e-01,0.48104e-01 /)
      kao(:, 4, 5,11) = (/ &
        & 0.48731e-01,0.45921e-01,0.43964e-01,0.41658e-01,0.39073e-01, &
        & 0.38270e-01,0.40535e-01,0.46833e-01,0.53415e-01 /)
      kao(:, 5, 5,11) = (/ &
        & 0.48265e-01,0.45648e-01,0.43993e-01,0.42096e-01,0.40473e-01, &
        & 0.40846e-01,0.44703e-01,0.51860e-01,0.59120e-01 /)
      kao(:, 1, 6,11) = (/ &
        & 0.54155e-01,0.50312e-01,0.46699e-01,0.43479e-01,0.38935e-01, &
        & 0.34460e-01,0.30470e-01,0.30214e-01,0.34389e-01 /)
      kao(:, 2, 6,11) = (/ &
        & 0.53396e-01,0.49741e-01,0.46925e-01,0.43573e-01,0.39485e-01, &
        & 0.35160e-01,0.32122e-01,0.33415e-01,0.38087e-01 /)
      kao(:, 3, 6,11) = (/ &
        & 0.52823e-01,0.49548e-01,0.47130e-01,0.43740e-01,0.39828e-01, &
        & 0.36044e-01,0.34474e-01,0.37304e-01,0.42510e-01 /)
      kao(:, 4, 6,11) = (/ &
        & 0.52327e-01,0.49384e-01,0.47097e-01,0.43937e-01,0.40452e-01, &
        & 0.37736e-01,0.37393e-01,0.41655e-01,0.47452e-01 /)
      kao(:, 5, 6,11) = (/ &
        & 0.51903e-01,0.49131e-01,0.47026e-01,0.44222e-01,0.41687e-01, &
        & 0.39818e-01,0.40660e-01,0.46275e-01,0.52724e-01 /)
      kao(:, 1, 7,11) = (/ &
        & 0.58007e-01,0.53733e-01,0.49779e-01,0.45887e-01,0.40462e-01, &
        & 0.35176e-01,0.29765e-01,0.26441e-01,0.29320e-01 /)
      kao(:, 2, 7,11) = (/ &
        & 0.57151e-01,0.53110e-01,0.50041e-01,0.45960e-01,0.40973e-01, &
        & 0.35887e-01,0.31026e-01,0.29123e-01,0.32803e-01 /)
      kao(:, 3, 7,11) = (/ &
        & 0.56502e-01,0.52846e-01,0.50182e-01,0.46056e-01,0.41337e-01, &
        & 0.36666e-01,0.32781e-01,0.32480e-01,0.36858e-01 /)
      kao(:, 4, 7,11) = (/ &
        & 0.55999e-01,0.52671e-01,0.50072e-01,0.46217e-01,0.41835e-01, &
        & 0.38000e-01,0.35109e-01,0.36308e-01,0.41318e-01 /)
      kao(:, 5, 7,11) = (/ &
        & 0.55573e-01,0.52382e-01,0.49967e-01,0.46401e-01,0.42955e-01, &
        & 0.39677e-01,0.37716e-01,0.40481e-01,0.46095e-01 /)
      kao(:, 1, 8,11) = (/ &
        & 0.61929e-01,0.57176e-01,0.52730e-01,0.48103e-01,0.42015e-01, &
        & 0.35869e-01,0.29499e-01,0.23665e-01,0.24549e-01 /)
      kao(:, 2, 8,11) = (/ &
        & 0.61013e-01,0.56553e-01,0.52930e-01,0.48080e-01,0.42522e-01, &
        & 0.36573e-01,0.30581e-01,0.25834e-01,0.27791e-01 /)
      kao(:, 3, 8,11) = (/ &
        & 0.60303e-01,0.56131e-01,0.52872e-01,0.48123e-01,0.42911e-01, &
        & 0.37343e-01,0.31938e-01,0.28446e-01,0.31375e-01 /)
      kao(:, 4, 8,11) = (/ &
        & 0.59783e-01,0.55843e-01,0.52678e-01,0.48331e-01,0.43398e-01, &
        & 0.38468e-01,0.33698e-01,0.31535e-01,0.35398e-01 /)
      kao(:, 5, 8,11) = (/ &
        & 0.59221e-01,0.55525e-01,0.52626e-01,0.48547e-01,0.44309e-01, &
        & 0.39969e-01,0.35748e-01,0.35119e-01,0.39791e-01 /)
      kao(:, 1, 9,11) = (/ &
        & 0.65420e-01,0.60290e-01,0.55521e-01,0.50117e-01,0.43421e-01, &
        & 0.36608e-01,0.29349e-01,0.21841e-01,0.18774e-01 /)
      kao(:, 2, 9,11) = (/ &
        & 0.64534e-01,0.59710e-01,0.55627e-01,0.50054e-01,0.43842e-01, &
        & 0.37357e-01,0.30337e-01,0.23525e-01,0.22756e-01 /)
      kao(:, 3, 9,11) = (/ &
        & 0.63805e-01,0.59237e-01,0.55452e-01,0.50019e-01,0.44319e-01, &
        & 0.38089e-01,0.31491e-01,0.25524e-01,0.26401e-01 /)
      kao(:, 4, 9,11) = (/ &
        & 0.63315e-01,0.59001e-01,0.55252e-01,0.50261e-01,0.44802e-01, &
        & 0.39006e-01,0.32915e-01,0.27972e-01,0.30021e-01 /)
      kao(:, 5, 9,11) = (/ &
        & 0.62781e-01,0.58825e-01,0.55257e-01,0.50524e-01,0.45567e-01, &
        & 0.40297e-01,0.34643e-01,0.30888e-01,0.34021e-01 /)
      kao(:, 1,10,11) = (/ &
        & 0.68132e-01,0.62682e-01,0.57743e-01,0.51836e-01,0.44670e-01, &
        & 0.37300e-01,0.29365e-01,0.20724e-01,0.15957e-01 /)
      kao(:, 2,10,11) = (/ &
        & 0.67210e-01,0.62151e-01,0.57960e-01,0.51867e-01,0.45128e-01, &
        & 0.38064e-01,0.30245e-01,0.22146e-01,0.17704e-01 /)
      kao(:, 3,10,11) = (/ &
        & 0.66632e-01,0.61949e-01,0.57882e-01,0.51878e-01,0.45637e-01, &
        & 0.38758e-01,0.31283e-01,0.23744e-01,0.20098e-01 /)
      kao(:, 4,10,11) = (/ &
        & 0.66350e-01,0.62044e-01,0.57835e-01,0.52180e-01,0.46090e-01, &
        & 0.39573e-01,0.32509e-01,0.25642e-01,0.22076e-01 /)
      kao(:, 5,10,11) = (/ &
        & 0.65965e-01,0.62105e-01,0.57959e-01,0.52489e-01,0.46765e-01, &
        & 0.40717e-01,0.34057e-01,0.28015e-01,0.24829e-01 /)
      kao(:, 1,11,11) = (/ &
        & 0.69905e-01,0.64410e-01,0.59589e-01,0.53150e-01,0.45760e-01, &
        & 0.38179e-01,0.29785e-01,0.20444e-01,0.16092e-01 /)
      kao(:, 2,11,11) = (/ &
        & 0.69271e-01,0.64175e-01,0.59782e-01,0.53281e-01,0.46486e-01, &
        & 0.38949e-01,0.30645e-01,0.21725e-01,0.17857e-01 /)
      kao(:, 3,11,11) = (/ &
        & 0.69073e-01,0.64491e-01,0.59955e-01,0.53684e-01,0.46981e-01, &
        & 0.39609e-01,0.31674e-01,0.23165e-01,0.20394e-01 /)
      kao(:, 4,11,11) = (/ &
        & 0.68904e-01,0.64793e-01,0.60179e-01,0.54162e-01,0.47530e-01, &
        & 0.40495e-01,0.32809e-01,0.24930e-01,0.23016e-01 /)
      kao(:, 5,11,11) = (/ &
        & 0.68639e-01,0.65010e-01,0.60484e-01,0.54605e-01,0.48370e-01, &
        & 0.41561e-01,0.34350e-01,0.26933e-01,0.26488e-01 /)
      kao(:, 1,12,11) = (/ &
        & 0.71529e-01,0.66044e-01,0.61072e-01,0.54140e-01,0.46654e-01, &
        & 0.38794e-01,0.29996e-01,0.20236e-01,0.16124e-01 /)
      kao(:, 2,12,11) = (/ &
        & 0.71291e-01,0.66315e-01,0.61418e-01,0.54500e-01,0.47446e-01, &
        & 0.39590e-01,0.30905e-01,0.21401e-01,0.17542e-01 /)
      kao(:, 3,12,11) = (/ &
        & 0.71222e-01,0.66826e-01,0.61770e-01,0.55219e-01,0.48148e-01, &
        & 0.40334e-01,0.31908e-01,0.22727e-01,0.19804e-01 /)
      kao(:, 4,12,11) = (/ &
        & 0.71079e-01,0.67236e-01,0.62161e-01,0.55849e-01,0.48917e-01, &
        & 0.41311e-01,0.33042e-01,0.24356e-01,0.21082e-01 /)
      kao(:, 5,12,11) = (/ &
        & 0.70901e-01,0.67518e-01,0.62549e-01,0.56439e-01,0.49900e-01, &
        & 0.42406e-01,0.34548e-01,0.26106e-01,0.23666e-01 /)
      kao(:, 1,13,11) = (/ &
        & 0.73149e-01,0.67708e-01,0.62294e-01,0.54947e-01,0.47337e-01, &
        & 0.39165e-01,0.30053e-01,0.20069e-01,0.15304e-01 /)
      kao(:, 2,13,11) = (/ &
        & 0.73122e-01,0.68287e-01,0.62803e-01,0.55664e-01,0.48241e-01, &
        & 0.39986e-01,0.31044e-01,0.21133e-01,0.17384e-01 /)
      kao(:, 3,13,11) = (/ &
        & 0.73057e-01,0.68826e-01,0.63303e-01,0.56536e-01,0.49104e-01, &
        & 0.40926e-01,0.32050e-01,0.22349e-01,0.18964e-01 /)
      kao(:, 4,13,11) = (/ &
        & 0.73037e-01,0.69286e-01,0.63846e-01,0.57252e-01,0.50018e-01, &
        & 0.42025e-01,0.33217e-01,0.23850e-01,0.20572e-01 /)
      kao(:, 5,13,11) = (/ &
        & 0.73013e-01,0.69604e-01,0.64290e-01,0.57954e-01,0.51076e-01, &
        & 0.43212e-01,0.34653e-01,0.25391e-01,0.23448e-01 /)
      kao(:, 1, 1,12) = (/ &
        & 0.43248e-01,0.41017e-01,0.40213e-01,0.39821e-01,0.45256e-01, &
        & 0.55821e-01,0.66932e-01,0.78037e-01,0.88086e-01 /)
      kao(:, 2, 1,12) = (/ &
        & 0.42407e-01,0.40307e-01,0.40078e-01,0.40681e-01,0.47543e-01, &
        & 0.59099e-01,0.70845e-01,0.82585e-01,0.93228e-01 /)
      kao(:, 3, 1,12) = (/ &
        & 0.41692e-01,0.39727e-01,0.39865e-01,0.41830e-01,0.50093e-01, &
        & 0.62450e-01,0.74841e-01,0.87232e-01,0.98476e-01 /)
      kao(:, 4, 1,12) = (/ &
        & 0.41002e-01,0.39248e-01,0.39945e-01,0.42942e-01,0.52768e-01, &
        & 0.65829e-01,0.78890e-01,0.91937e-01,0.10362e+00 /)
      kao(:, 5, 1,12) = (/ &
        & 0.40428e-01,0.39045e-01,0.40116e-01,0.44981e-01,0.56655e-01, &
        & 0.70681e-01,0.84705e-01,0.98731e-01,0.11111e+00 /)
      kao(:, 1, 2,12) = (/ &
        & 0.47227e-01,0.44198e-01,0.42698e-01,0.42511e-01,0.46394e-01, &
        & 0.55784e-01,0.66888e-01,0.77989e-01,0.88812e-01 /)
      kao(:, 2, 2,12) = (/ &
        & 0.46375e-01,0.43473e-01,0.42428e-01,0.43299e-01,0.48252e-01, &
        & 0.59000e-01,0.70708e-01,0.82423e-01,0.93885e-01 /)
      kao(:, 3, 2,12) = (/ &
        & 0.45650e-01,0.42988e-01,0.42307e-01,0.44252e-01,0.50414e-01, &
        & 0.62373e-01,0.74750e-01,0.87127e-01,0.99197e-01 /)
      kao(:, 4, 2,12) = (/ &
        & 0.44980e-01,0.42686e-01,0.42476e-01,0.45355e-01,0.53027e-01, &
        & 0.66067e-01,0.79179e-01,0.92288e-01,0.10480e+00 /)
      kao(:, 5, 2,12) = (/ &
        & 0.44383e-01,0.42475e-01,0.42723e-01,0.47155e-01,0.57007e-01, &
        & 0.71138e-01,0.85276e-01,0.99396e-01,0.11272e+00 /)
      kao(:, 1, 3,12) = (/ &
        & 0.51829e-01,0.48303e-01,0.45805e-01,0.45348e-01,0.47474e-01, &
        & 0.53773e-01,0.64381e-01,0.75065e-01,0.85879e-01 /)
      kao(:, 2, 3,12) = (/ &
        & 0.50945e-01,0.47626e-01,0.45531e-01,0.46104e-01,0.48805e-01, &
        & 0.57008e-01,0.68342e-01,0.79675e-01,0.91103e-01 /)
      kao(:, 3, 3,12) = (/ &
        & 0.50329e-01,0.47163e-01,0.45393e-01,0.46795e-01,0.50514e-01, &
        & 0.60488e-01,0.72503e-01,0.84519e-01,0.96625e-01 /)
      kao(:, 4, 3,12) = (/ &
        & 0.49725e-01,0.46894e-01,0.45600e-01,0.47784e-01,0.52670e-01, &
        & 0.64382e-01,0.77172e-01,0.89966e-01,0.10271e+00 /)
      kao(:, 5, 3,12) = (/ &
        & 0.49109e-01,0.46633e-01,0.45896e-01,0.49191e-01,0.56129e-01, &
        & 0.69438e-01,0.83245e-01,0.97061e-01,0.11071e+00 /)
      kao(:, 1, 4,12) = (/ &
        & 0.57082e-01,0.53110e-01,0.49763e-01,0.48460e-01,0.48719e-01, &
        & 0.51181e-01,0.59984e-01,0.69952e-01,0.80045e-01 /)
      kao(:, 2, 4,12) = (/ &
        & 0.56133e-01,0.52450e-01,0.49568e-01,0.49064e-01,0.49725e-01, &
        & 0.54041e-01,0.64091e-01,0.74728e-01,0.85496e-01 /)
      kao(:, 3, 4,12) = (/ &
        & 0.55439e-01,0.51866e-01,0.49497e-01,0.49475e-01,0.51076e-01, &
        & 0.57243e-01,0.68327e-01,0.79652e-01,0.91098e-01 /)
      kao(:, 4, 4,12) = (/ &
        & 0.54777e-01,0.51575e-01,0.49681e-01,0.50221e-01,0.52765e-01, &
        & 0.61084e-01,0.73197e-01,0.85337e-01,0.97552e-01 /)
      kao(:, 5, 4,12) = (/ &
        & 0.54098e-01,0.51233e-01,0.49878e-01,0.51295e-01,0.55484e-01, &
        & 0.66162e-01,0.79298e-01,0.92434e-01,0.10558e+00 /)
      kao(:, 1, 5,12) = (/ &
        & 0.62544e-01,0.58281e-01,0.54351e-01,0.52107e-01,0.50211e-01, &
        & 0.49416e-01,0.54519e-01,0.63528e-01,0.72634e-01 /)
      kao(:, 2, 5,12) = (/ &
        & 0.61658e-01,0.57644e-01,0.54210e-01,0.52563e-01,0.50949e-01, &
        & 0.51794e-01,0.58802e-01,0.68560e-01,0.78383e-01 /)
      kao(:, 3, 5,12) = (/ &
        & 0.60918e-01,0.57016e-01,0.54117e-01,0.52719e-01,0.52074e-01, &
        & 0.54457e-01,0.63161e-01,0.73629e-01,0.84158e-01 /)
      kao(:, 4, 5,12) = (/ &
        & 0.60164e-01,0.56692e-01,0.54302e-01,0.53086e-01,0.53404e-01, &
        & 0.57689e-01,0.68126e-01,0.79422e-01,0.90757e-01 /)
      kao(:, 5, 5,12) = (/ &
        & 0.59366e-01,0.56267e-01,0.54377e-01,0.53811e-01,0.55627e-01, &
        & 0.62331e-01,0.74295e-01,0.86596e-01,0.98923e-01 /)
      kao(:, 1, 6,12) = (/ &
        & 0.68500e-01,0.63504e-01,0.59102e-01,0.56112e-01,0.52198e-01, &
        & 0.48725e-01,0.49458e-01,0.56540e-01,0.64611e-01 /)
      kao(:, 2, 6,12) = (/ &
        & 0.67642e-01,0.62951e-01,0.59010e-01,0.56509e-01,0.52640e-01, &
        & 0.50781e-01,0.53492e-01,0.61845e-01,0.70650e-01 /)
      kao(:, 3, 6,12) = (/ &
        & 0.66730e-01,0.62270e-01,0.58880e-01,0.56541e-01,0.53578e-01, &
        & 0.52912e-01,0.57553e-01,0.66900e-01,0.76420e-01 /)
      kao(:, 4, 6,12) = (/ &
        & 0.65853e-01,0.61851e-01,0.59079e-01,0.56674e-01,0.54628e-01, &
        & 0.55405e-01,0.62327e-01,0.72621e-01,0.82946e-01 /)
      kao(:, 5, 6,12) = (/ &
        & 0.64917e-01,0.61395e-01,0.59088e-01,0.57140e-01,0.56317e-01, &
        & 0.59242e-01,0.68519e-01,0.79819e-01,0.91147e-01 /)
      kao(:, 1, 7,12) = (/ &
        & 0.74814e-01,0.69115e-01,0.63783e-01,0.59970e-01,0.54833e-01, &
        & 0.49011e-01,0.46051e-01,0.49756e-01,0.56816e-01 /)
      kao(:, 2, 7,12) = (/ &
        & 0.73755e-01,0.68509e-01,0.63672e-01,0.60441e-01,0.55205e-01, &
        & 0.50759e-01,0.49447e-01,0.55044e-01,0.62843e-01 /)
      kao(:, 3, 7,12) = (/ &
        & 0.72664e-01,0.67698e-01,0.63630e-01,0.60499e-01,0.55993e-01, &
        & 0.52467e-01,0.52809e-01,0.59966e-01,0.68463e-01 /)
      kao(:, 4, 7,12) = (/ &
        & 0.71633e-01,0.67174e-01,0.63866e-01,0.60581e-01,0.56744e-01, &
        & 0.54377e-01,0.56941e-01,0.65640e-01,0.74923e-01 /)
      kao(:, 5, 7,12) = (/ &
        & 0.70621e-01,0.66745e-01,0.63972e-01,0.60930e-01,0.57801e-01, &
        & 0.57488e-01,0.62631e-01,0.72711e-01,0.82984e-01 /)
      kao(:, 1, 8,12) = (/ &
        & 0.81108e-01,0.74731e-01,0.68669e-01,0.63699e-01,0.57482e-01, &
        & 0.50207e-01,0.44226e-01,0.43565e-01,0.49479e-01 /)
      kao(:, 2, 8,12) = (/ &
        & 0.79714e-01,0.73898e-01,0.68659e-01,0.64276e-01,0.57881e-01, &
        & 0.51786e-01,0.46974e-01,0.48378e-01,0.55162e-01 /)
      kao(:, 3, 8,12) = (/ &
        & 0.78456e-01,0.73135e-01,0.68758e-01,0.64370e-01,0.58662e-01, &
        & 0.53164e-01,0.49684e-01,0.53168e-01,0.60666e-01 /)
      kao(:, 4, 8,12) = (/ &
        & 0.77309e-01,0.72680e-01,0.69000e-01,0.64433e-01,0.59353e-01, &
        & 0.54540e-01,0.53042e-01,0.58717e-01,0.66992e-01 /)
      kao(:, 5, 8,12) = (/ &
        & 0.76406e-01,0.72288e-01,0.69084e-01,0.64775e-01,0.60105e-01, &
        & 0.56876e-01,0.57740e-01,0.65467e-01,0.74695e-01 /)
      kao(:, 1, 9,12) = (/ &
        & 0.87281e-01,0.80336e-01,0.73586e-01,0.67589e-01,0.60164e-01, &
        & 0.51553e-01,0.43512e-01,0.38366e-01,0.42260e-01 /)
      kao(:, 2, 9,12) = (/ &
        & 0.85638e-01,0.79229e-01,0.73710e-01,0.68169e-01,0.60640e-01, &
        & 0.53028e-01,0.45744e-01,0.42413e-01,0.47570e-01 /)
      kao(:, 3, 9,12) = (/ &
        & 0.84292e-01,0.78481e-01,0.73900e-01,0.68269e-01,0.61342e-01, &
        & 0.54381e-01,0.47902e-01,0.46760e-01,0.52980e-01 /)
      kao(:, 4, 9,12) = (/ &
        & 0.83115e-01,0.77996e-01,0.74142e-01,0.68304e-01,0.62073e-01, &
        & 0.55597e-01,0.50525e-01,0.51779e-01,0.58954e-01 /)
      kao(:, 5, 9,12) = (/ &
        & 0.82186e-01,0.77706e-01,0.74161e-01,0.68663e-01,0.62685e-01, &
        & 0.57315e-01,0.54189e-01,0.58003e-01,0.66142e-01 /)
      kao(:, 1,10,12) = (/ &
        & 0.93285e-01,0.85813e-01,0.78575e-01,0.71552e-01,0.62937e-01, &
        & 0.53130e-01,0.43544e-01,0.34852e-01,0.25971e-01 /)
      kao(:, 2,10,12) = (/ &
        & 0.91673e-01,0.84652e-01,0.78625e-01,0.72093e-01,0.63376e-01, &
        & 0.54541e-01,0.45576e-01,0.38102e-01,0.28356e-01 /)
      kao(:, 3,10,12) = (/ &
        & 0.90273e-01,0.83828e-01,0.78840e-01,0.72190e-01,0.64026e-01, &
        & 0.55889e-01,0.47404e-01,0.41695e-01,0.31456e-01 /)
      kao(:, 4,10,12) = (/ &
        & 0.88982e-01,0.83233e-01,0.79026e-01,0.72231e-01,0.64765e-01, &
        & 0.57025e-01,0.49463e-01,0.46003e-01,0.35501e-01 /)
      kao(:, 5,10,12) = (/ &
        & 0.88015e-01,0.82954e-01,0.78987e-01,0.72605e-01,0.65378e-01, &
        & 0.58432e-01,0.52293e-01,0.51371e-01,0.39951e-01 /)
      kao(:, 1,11,12) = (/ &
        & 0.98224e-01,0.90470e-01,0.83283e-01,0.75729e-01,0.65953e-01, &
        & 0.55333e-01,0.44607e-01,0.33712e-01,0.29825e-01 /)
      kao(:, 2,11,12) = (/ &
        & 0.96868e-01,0.89565e-01,0.83537e-01,0.76001e-01,0.66302e-01, &
        & 0.56711e-01,0.46387e-01,0.36339e-01,0.33228e-01 /)
      kao(:, 3,11,12) = (/ &
        & 0.95464e-01,0.88759e-01,0.83774e-01,0.75894e-01,0.67115e-01, &
        & 0.57847e-01,0.48034e-01,0.39456e-01,0.36088e-01 /)
      kao(:, 4,11,12) = (/ &
        & 0.94340e-01,0.88366e-01,0.83721e-01,0.76044e-01,0.67766e-01, &
        & 0.58947e-01,0.50010e-01,0.43247e-01,0.40125e-01 /)
      kao(:, 5,11,12) = (/ &
        & 0.93518e-01,0.88039e-01,0.83475e-01,0.76422e-01,0.68414e-01, &
        & 0.60495e-01,0.52431e-01,0.48069e-01,0.44798e-01 /)
      kao(:, 1,12,12) = (/ &
        & 0.10275e+00,0.94729e-01,0.87688e-01,0.79394e-01,0.68734e-01, &
        & 0.57476e-01,0.45697e-01,0.32943e-01,0.29614e-01 /)
      kao(:, 2,12,12) = (/ &
        & 0.10159e+00,0.94167e-01,0.88202e-01,0.79488e-01,0.69232e-01, &
        & 0.58694e-01,0.47208e-01,0.35215e-01,0.33437e-01 /)
      kao(:, 3,12,12) = (/ &
        & 0.10046e+00,0.93671e-01,0.88347e-01,0.79409e-01,0.69985e-01, &
        & 0.59703e-01,0.48739e-01,0.37920e-01,0.36670e-01 /)
      kao(:, 4,12,12) = (/ &
        & 0.99712e-01,0.93473e-01,0.88135e-01,0.79671e-01,0.70541e-01, &
        & 0.60786e-01,0.50658e-01,0.41158e-01,0.41155e-01 /)
      kao(:, 5,12,12) = (/ &
        & 0.99052e-01,0.93236e-01,0.87897e-01,0.79933e-01,0.71310e-01, &
        & 0.62364e-01,0.52850e-01,0.45390e-01,0.47055e-01 /)
      kao(:, 1,13,12) = (/ &
        & 0.10693e+00,0.98594e-01,0.91730e-01,0.82575e-01,0.71131e-01, &
        & 0.59390e-01,0.46621e-01,0.32428e-01,0.26794e-01 /)
      kao(:, 2,13,12) = (/ &
        & 0.10593e+00,0.98329e-01,0.92368e-01,0.82651e-01,0.71827e-01, &
        & 0.60538e-01,0.47868e-01,0.34468e-01,0.29114e-01 /)
      kao(:, 3,13,12) = (/ &
        & 0.10521e+00,0.98305e-01,0.92444e-01,0.82725e-01,0.72549e-01, &
        & 0.61456e-01,0.49349e-01,0.36800e-01,0.32781e-01 /)
      kao(:, 4,13,12) = (/ &
        & 0.10471e+00,0.98393e-01,0.92240e-01,0.83082e-01,0.73117e-01, &
        & 0.62504e-01,0.51152e-01,0.39616e-01,0.37780e-01 /)
      kao(:, 5,13,12) = (/ &
        & 0.10409e+00,0.98364e-01,0.92131e-01,0.83350e-01,0.73995e-01, &
        & 0.64047e-01,0.53327e-01,0.43375e-01,0.42285e-01 /)
      kao(:, 1, 1,13) = (/ &
        & 0.52810e-01,0.49450e-01,0.49647e-01,0.57104e-01,0.73433e-01, &
        & 0.91743e-01,0.11005e+00,0.12834e+00,0.14491e+00 /)
      kao(:, 2, 1,13) = (/ &
        & 0.51653e-01,0.48971e-01,0.50186e-01,0.59440e-01,0.77723e-01, &
        & 0.97098e-01,0.11647e+00,0.13583e+00,0.15375e+00 /)
      kao(:, 3, 1,13) = (/ &
        & 0.50696e-01,0.48582e-01,0.50737e-01,0.61667e-01,0.81568e-01, &
        & 0.10190e+00,0.12223e+00,0.14254e+00,0.16133e+00 /)
      kao(:, 4, 1,13) = (/ &
        & 0.49759e-01,0.48321e-01,0.51484e-01,0.64441e-01,0.85673e-01, &
        & 0.10703e+00,0.12837e+00,0.14971e+00,0.16936e+00 /)
      kao(:, 5, 1,13) = (/ &
        & 0.48804e-01,0.48067e-01,0.52560e-01,0.67354e-01,0.89656e-01, &
        & 0.11200e+00,0.13434e+00,0.15666e+00,0.17718e+00 /)
      kao(:, 1, 2,13) = (/ &
        & 0.57042e-01,0.54069e-01,0.53905e-01,0.58729e-01,0.73592e-01, &
        & 0.91941e-01,0.11029e+00,0.12863e+00,0.14602e+00 /)
      kao(:, 2, 2,13) = (/ &
        & 0.55841e-01,0.53550e-01,0.54566e-01,0.60781e-01,0.78168e-01, &
        & 0.97652e-01,0.11714e+00,0.13661e+00,0.15506e+00 /)
      kao(:, 3, 2,13) = (/ &
        & 0.54920e-01,0.52981e-01,0.54943e-01,0.62919e-01,0.82379e-01, &
        & 0.10292e+00,0.12345e+00,0.14397e+00,0.16344e+00 /)
      kao(:, 4, 2,13) = (/ &
        & 0.54055e-01,0.52591e-01,0.55488e-01,0.65511e-01,0.86681e-01, &
        & 0.10829e+00,0.12990e+00,0.15147e+00,0.17196e+00 /)
      kao(:, 5, 2,13) = (/ &
        & 0.53226e-01,0.52334e-01,0.56238e-01,0.68429e-01,0.90830e-01, &
        & 0.11345e+00,0.13607e+00,0.15868e+00,0.17998e+00 /)
      kao(:, 1, 3,13) = (/ &
        & 0.62670e-01,0.59309e-01,0.58772e-01,0.61122e-01,0.72960e-01, &
        & 0.91113e-01,0.10930e+00,0.12747e+00,0.14514e+00 /)
      kao(:, 2, 3,13) = (/ &
        & 0.61411e-01,0.58632e-01,0.59230e-01,0.62688e-01,0.77748e-01, &
        & 0.97139e-01,0.11652e+00,0.13590e+00,0.15479e+00 /)
      kao(:, 3, 3,13) = (/ &
        & 0.60334e-01,0.57923e-01,0.59411e-01,0.64539e-01,0.82093e-01, &
        & 0.10257e+00,0.12305e+00,0.14350e+00,0.16343e+00 /)
      kao(:, 4, 3,13) = (/ &
        & 0.59451e-01,0.57416e-01,0.59633e-01,0.66820e-01,0.86494e-01, &
        & 0.10804e+00,0.12960e+00,0.15112e+00,0.17209e+00 /)
      kao(:, 5, 3,13) = (/ &
        & 0.58597e-01,0.57143e-01,0.60240e-01,0.69594e-01,0.91059e-01, &
        & 0.11373e+00,0.13640e+00,0.15905e+00,0.18103e+00 /)
      kao(:, 1, 4,13) = (/ &
        & 0.69822e-01,0.65601e-01,0.63945e-01,0.64755e-01,0.73038e-01, &
        & 0.90165e-01,0.10817e+00,0.12616e+00,0.14389e+00 /)
      kao(:, 2, 4,13) = (/ &
        & 0.68507e-01,0.64727e-01,0.64234e-01,0.66213e-01,0.77749e-01, &
        & 0.96668e-01,0.11597e+00,0.13524e+00,0.15427e+00 /)
      kao(:, 3, 4,13) = (/ &
        & 0.67276e-01,0.63962e-01,0.64238e-01,0.67909e-01,0.82185e-01, &
        & 0.10254e+00,0.12301e+00,0.14345e+00,0.16365e+00 /)
      kao(:, 4, 4,13) = (/ &
        & 0.66381e-01,0.63334e-01,0.64220e-01,0.69770e-01,0.86724e-01, &
        & 0.10832e+00,0.12994e+00,0.15151e+00,0.17282e+00 /)
      kao(:, 5, 4,13) = (/ &
        & 0.65437e-01,0.62972e-01,0.64673e-01,0.72222e-01,0.91630e-01, &
        & 0.11445e+00,0.13728e+00,0.16006e+00,0.18257e+00 /)
      kao(:, 1, 5,13) = (/ &
        & 0.78344e-01,0.73091e-01,0.69713e-01,0.69214e-01,0.74668e-01, &
        & 0.88915e-01,0.10667e+00,0.12441e+00,0.14209e+00 /)
      kao(:, 2, 5,13) = (/ &
        & 0.76773e-01,0.71981e-01,0.69752e-01,0.70736e-01,0.78904e-01, &
        & 0.95797e-01,0.11493e+00,0.13406e+00,0.15311e+00 /)
      kao(:, 3, 5,13) = (/ &
        & 0.75310e-01,0.71068e-01,0.69651e-01,0.72503e-01,0.83070e-01, &
        & 0.10214e+00,0.12251e+00,0.14289e+00,0.16320e+00 /)
      kao(:, 4, 5,13) = (/ &
        & 0.74250e-01,0.70202e-01,0.69499e-01,0.74333e-01,0.87301e-01, &
        & 0.10818e+00,0.12976e+00,0.15132e+00,0.17281e+00 /)
      kao(:, 5, 5,13) = (/ &
        & 0.73209e-01,0.69739e-01,0.69847e-01,0.76315e-01,0.91870e-01, &
        & 0.11438e+00,0.13720e+00,0.16000e+00,0.18274e+00 /)
      kao(:, 1, 6,13) = (/ &
        & 0.87696e-01,0.81522e-01,0.76509e-01,0.74345e-01,0.77107e-01, &
        & 0.86456e-01,0.10266e+00,0.11975e+00,0.13684e+00 /)
      kao(:, 2, 6,13) = (/ &
        & 0.85834e-01,0.80104e-01,0.76319e-01,0.75879e-01,0.80970e-01, &
        & 0.93234e-01,0.11135e+00,0.12988e+00,0.14843e+00 /)
      kao(:, 3, 6,13) = (/ &
        & 0.84103e-01,0.79034e-01,0.76204e-01,0.77685e-01,0.84459e-01, &
        & 0.99600e-01,0.11936e+00,0.13921e+00,0.15907e+00 /)
      kao(:, 4, 6,13) = (/ &
        & 0.82699e-01,0.78102e-01,0.75915e-01,0.79277e-01,0.87923e-01, &
        & 0.10572e+00,0.12681e+00,0.14791e+00,0.16901e+00 /)
      kao(:, 5, 6,13) = (/ &
        & 0.81604e-01,0.77529e-01,0.76175e-01,0.80727e-01,0.91640e-01, &
        & 0.11182e+00,0.13414e+00,0.15644e+00,0.17875e+00 /)
      kao(:, 1, 7,13) = (/ &
        & 0.97322e-01,0.90329e-01,0.84313e-01,0.80452e-01,0.80118e-01, &
        & 0.84204e-01,0.96138e-01,0.11212e+00,0.12812e+00 /)
      kao(:, 2, 7,13) = (/ &
        & 0.95378e-01,0.88856e-01,0.83999e-01,0.81744e-01,0.83529e-01, &
        & 0.90072e-01,0.10504e+00,0.12254e+00,0.14003e+00 /)
      kao(:, 3, 7,13) = (/ &
        & 0.93471e-01,0.87725e-01,0.83968e-01,0.83424e-01,0.86362e-01, &
        & 0.95913e-01,0.11338e+00,0.13227e+00,0.15114e+00 /)
      kao(:, 4, 7,13) = (/ &
        & 0.91861e-01,0.86679e-01,0.83638e-01,0.84829e-01,0.89126e-01, &
        & 0.10167e+00,0.12111e+00,0.14127e+00,0.16142e+00 /)
      kao(:, 5, 7,13) = (/ &
        & 0.90669e-01,0.86079e-01,0.83677e-01,0.85955e-01,0.92165e-01, &
        & 0.10751e+00,0.12862e+00,0.15005e+00,0.17145e+00 /)
      kao(:, 1, 8,13) = (/ &
        & 0.10748e+00,0.99760e-01,0.92641e-01,0.87386e-01,0.83918e-01, &
        & 0.82807e-01,0.88461e-01,0.10199e+00,0.11655e+00 /)
      kao(:, 2, 8,13) = (/ &
        & 0.10548e+00,0.98347e-01,0.92153e-01,0.88724e-01,0.86807e-01, &
        & 0.87435e-01,0.96918e-01,0.11262e+00,0.12866e+00 /)
      kao(:, 3, 8,13) = (/ &
        & 0.10345e+00,0.96941e-01,0.92269e-01,0.90148e-01,0.89023e-01, &
        & 0.92390e-01,0.10517e+00,0.12260e+00,0.14006e+00 /)
      kao(:, 4, 8,13) = (/ &
        & 0.10168e+00,0.95648e-01,0.92050e-01,0.91217e-01,0.91169e-01, &
        & 0.97530e-01,0.11302e+00,0.13185e+00,0.15061e+00 /)
      kao(:, 5, 8,13) = (/ &
        & 0.10031e+00,0.94918e-01,0.92030e-01,0.91944e-01,0.93599e-01, &
        & 0.10280e+00,0.12083e+00,0.14095e+00,0.16101e+00 /)
      kao(:, 1, 9,13) = (/ &
        & 0.11850e+00,0.10963e+00,0.10118e+00,0.94592e-01,0.88496e-01, &
        & 0.82777e-01,0.81368e-01,0.90482e-01,0.10334e+00 /)
      kao(:, 2, 9,13) = (/ &
        & 0.11636e+00,0.10836e+00,0.10080e+00,0.96151e-01,0.90961e-01, &
        & 0.86437e-01,0.88759e-01,0.10103e+00,0.11540e+00 /)
      kao(:, 3, 9,13) = (/ &
        & 0.11416e+00,0.10675e+00,0.10109e+00,0.97591e-01,0.92676e-01, &
        & 0.90148e-01,0.96288e-01,0.11094e+00,0.12669e+00 /)
      kao(:, 4, 9,13) = (/ &
        & 0.11214e+00,0.10527e+00,0.10096e+00,0.98437e-01,0.94256e-01, &
        & 0.94326e-01,0.10386e+00,0.12050e+00,0.13763e+00 /)
      kao(:, 5, 9,13) = (/ &
        & 0.11054e+00,0.10425e+00,0.10085e+00,0.98717e-01,0.96200e-01, &
        & 0.98935e-01,0.11173e+00,0.13010e+00,0.14859e+00 /)
      kao(:, 1,10,13) = (/ &
        & 0.13016e+00,0.11986e+00,0.10995e+00,0.10196e+00,0.93774e-01, &
        & 0.84360e-01,0.76878e-01,0.79680e-01,0.67359e-01 /)
      kao(:, 2,10,13) = (/ &
        & 0.12774e+00,0.11853e+00,0.10979e+00,0.10367e+00,0.96160e-01, &
        & 0.87173e-01,0.82710e-01,0.89689e-01,0.82456e-01 /)
      kao(:, 3,10,13) = (/ &
        & 0.12531e+00,0.11685e+00,0.11022e+00,0.10509e+00,0.97450e-01, &
        & 0.90061e-01,0.89222e-01,0.99588e-01,0.96338e-01 /)
      kao(:, 4,10,13) = (/ &
        & 0.12312e+00,0.11523e+00,0.11015e+00,0.10584e+00,0.98534e-01, &
        & 0.93531e-01,0.96262e-01,0.10942e+00,0.11043e+00 /)
      kao(:, 5,10,13) = (/ &
        & 0.12128e+00,0.11400e+00,0.10998e+00,0.10588e+00,0.10008e+00, &
        & 0.97359e-01,0.10364e+00,0.11932e+00,0.12582e+00 /)
      kao(:, 1,11,13) = (/ &
        & 0.14105e+00,0.12987e+00,0.11910e+00,0.11026e+00,0.10035e+00, &
        & 0.88081e-01,0.76687e-01,0.74205e-01,0.50899e-01 /)
      kao(:, 2,11,13) = (/ &
        & 0.13825e+00,0.12810e+00,0.11908e+00,0.11198e+00,0.10215e+00, &
        & 0.90197e-01,0.81650e-01,0.83605e-01,0.56975e-01 /)
      kao(:, 3,11,13) = (/ &
        & 0.13566e+00,0.12624e+00,0.11939e+00,0.11316e+00,0.10299e+00, &
        & 0.92874e-01,0.87279e-01,0.93203e-01,0.64736e-01 /)
      kao(:, 4,11,13) = (/ &
        & 0.13334e+00,0.12460e+00,0.11935e+00,0.11337e+00,0.10395e+00, &
        & 0.95956e-01,0.93410e-01,0.10293e+00,0.71284e-01 /)
      kao(:, 5,11,13) = (/ &
        & 0.13131e+00,0.12363e+00,0.11937e+00,0.11314e+00,0.10517e+00, &
        & 0.98969e-01,0.10016e+00,0.11304e+00,0.78587e-01 /)
      kao(:, 1,12,13) = (/ &
        & 0.15212e+00,0.13991e+00,0.12851e+00,0.11872e+00,0.10663e+00, &
        & 0.91867e-01,0.77350e-01,0.69757e-01,0.57657e-01 /)
      kao(:, 2,12,13) = (/ &
        & 0.14895e+00,0.13760e+00,0.12846e+00,0.12032e+00,0.10790e+00, &
        & 0.93798e-01,0.81816e-01,0.78361e-01,0.63811e-01 /)
      kao(:, 3,12,13) = (/ &
        & 0.14609e+00,0.13558e+00,0.12854e+00,0.12100e+00,0.10856e+00, &
        & 0.96260e-01,0.86684e-01,0.87192e-01,0.72200e-01 /)
      kao(:, 4,12,13) = (/ &
        & 0.14343e+00,0.13400e+00,0.12849e+00,0.12073e+00,0.10951e+00, &
        & 0.98753e-01,0.91530e-01,0.96391e-01,0.79517e-01 /)
      kao(:, 5,12,13) = (/ &
        & 0.14120e+00,0.13303e+00,0.12833e+00,0.12041e+00,0.11038e+00, &
        & 0.10129e+00,0.97562e-01,0.10658e+00,0.84371e-01 /)
      kao(:, 1,13,13) = (/ &
        & 0.16284e+00,0.14976e+00,0.13792e+00,0.12684e+00,0.11275e+00, &
        & 0.95645e-01,0.78767e-01,0.66366e-01,0.59038e-01 /)
      kao(:, 2,13,13) = (/ &
        & 0.15947e+00,0.14721e+00,0.13779e+00,0.12800e+00,0.11359e+00, &
        & 0.97597e-01,0.82782e-01,0.73753e-01,0.67374e-01 /)
      kao(:, 3,13,13) = (/ &
        & 0.15626e+00,0.14498e+00,0.13763e+00,0.12811e+00,0.11414e+00, &
        & 0.99826e-01,0.86643e-01,0.81525e-01,0.75874e-01 /)
      kao(:, 4,13,13) = (/ &
        & 0.15335e+00,0.14330e+00,0.13746e+00,0.12758e+00,0.11501e+00, &
        & 0.10172e+00,0.90750e-01,0.90246e-01,0.81744e-01 /)
      kao(:, 5,13,13) = (/ &
        & 0.15088e+00,0.14217e+00,0.13690e+00,0.12723e+00,0.11557e+00, &
        & 0.10388e+00,0.96218e-01,0.10042e+00,0.88529e-01 /)
      kao(:, 1, 1,14) = (/ &
        & 0.62837e-01,0.60695e-01,0.77720e-01,0.11279e+00,0.15033e+00, &
        & 0.18788e+00,0.22539e+00,0.26284e+00,0.29421e+00 /)
      kao(:, 2, 1,14) = (/ &
        & 0.61599e-01,0.60148e-01,0.79591e-01,0.11750e+00,0.15661e+00, &
        & 0.19570e+00,0.23478e+00,0.27378e+00,0.30578e+00 /)
      kao(:, 3, 1,14) = (/ &
        & 0.60827e-01,0.59792e-01,0.82175e-01,0.12253e+00,0.16330e+00, &
        & 0.20407e+00,0.24482e+00,0.28548e+00,0.31829e+00 /)
      kao(:, 4, 1,14) = (/ &
        & 0.60773e-01,0.59852e-01,0.85295e-01,0.12765e+00,0.17012e+00, &
        & 0.21258e+00,0.25502e+00,0.29736e+00,0.33114e+00 /)
      kao(:, 5, 1,14) = (/ &
        & 0.60579e-01,0.60436e-01,0.88993e-01,0.13334e+00,0.17771e+00, &
        & 0.22206e+00,0.26642e+00,0.31066e+00,0.34557e+00 /)
      kao(:, 1, 2,14) = (/ &
        & 0.70150e-01,0.67933e-01,0.82763e-01,0.11770e+00,0.15687e+00, &
        & 0.19605e+00,0.23520e+00,0.27426e+00,0.30923e+00 /)
      kao(:, 2, 2,14) = (/ &
        & 0.68737e-01,0.67168e-01,0.84453e-01,0.12329e+00,0.16434e+00, &
        & 0.20537e+00,0.24638e+00,0.28735e+00,0.32358e+00 /)
      kao(:, 3, 2,14) = (/ &
        & 0.67693e-01,0.66713e-01,0.87076e-01,0.12893e+00,0.17184e+00, &
        & 0.21474e+00,0.25764e+00,0.30044e+00,0.33811e+00 /)
      kao(:, 4, 2,14) = (/ &
        & 0.67352e-01,0.66652e-01,0.90088e-01,0.13441e+00,0.17914e+00, &
        & 0.22388e+00,0.26860e+00,0.31321e+00,0.35245e+00 /)
      kao(:, 5, 2,14) = (/ &
        & 0.66923e-01,0.67069e-01,0.93870e-01,0.14034e+00,0.18704e+00, &
        & 0.23374e+00,0.28042e+00,0.32702e+00,0.36794e+00 /)
      kao(:, 1, 3,14) = (/ &
        & 0.79385e-01,0.76263e-01,0.87808e-01,0.12001e+00,0.15997e+00, &
        & 0.19992e+00,0.23984e+00,0.27971e+00,0.31814e+00 /)
      kao(:, 2, 3,14) = (/ &
        & 0.77666e-01,0.75357e-01,0.89439e-01,0.12673e+00,0.16892e+00, &
        & 0.21110e+00,0.25327e+00,0.29539e+00,0.33569e+00 /)
      kao(:, 3, 3,14) = (/ &
        & 0.76193e-01,0.74694e-01,0.92082e-01,0.13335e+00,0.17774e+00, &
        & 0.22213e+00,0.26651e+00,0.31084e+00,0.35313e+00 /)
      kao(:, 4, 3,14) = (/ &
        & 0.75335e-01,0.74405e-01,0.95067e-01,0.13953e+00,0.18597e+00, &
        & 0.23241e+00,0.27884e+00,0.32518e+00,0.36942e+00 /)
      kao(:, 5, 3,14) = (/ &
        & 0.74635e-01,0.74698e-01,0.98457e-01,0.14565e+00,0.19414e+00, &
        & 0.24262e+00,0.29108e+00,0.33947e+00,0.38555e+00 /)
      kao(:, 1, 4,14) = (/ &
        & 0.89595e-01,0.85781e-01,0.93997e-01,0.12072e+00,0.16001e+00, &
        & 0.19998e+00,0.23994e+00,0.27984e+00,0.31934e+00 /)
      kao(:, 2, 4,14) = (/ &
        & 0.87421e-01,0.84747e-01,0.95233e-01,0.12788e+00,0.17024e+00, &
        & 0.21274e+00,0.25525e+00,0.29772e+00,0.33967e+00 /)
      kao(:, 3, 4,14) = (/ &
        & 0.85503e-01,0.83808e-01,0.97531e-01,0.13512e+00,0.18009e+00, &
        & 0.22508e+00,0.27005e+00,0.31493e+00,0.35929e+00 /)
      kao(:, 4, 4,14) = (/ &
        & 0.84061e-01,0.83216e-01,0.10039e+00,0.14194e+00,0.18919e+00, &
        & 0.23644e+00,0.28372e+00,0.33088e+00,0.37743e+00 /)
      kao(:, 5, 4,14) = (/ &
        & 0.83141e-01,0.83249e-01,0.10352e+00,0.14853e+00,0.19798e+00, &
        & 0.24744e+00,0.29688e+00,0.34622e+00,0.39491e+00 /)
      kao(:, 1, 5,14) = (/ &
        & 0.10093e+00,0.96180e-01,0.10202e+00,0.12191e+00,0.15810e+00, &
        & 0.19761e+00,0.23710e+00,0.27651e+00,0.31584e+00 /)
      kao(:, 2, 5,14) = (/ &
        & 0.98348e-01,0.95154e-01,0.10279e+00,0.12897e+00,0.16954e+00, &
        & 0.21190e+00,0.25425e+00,0.29655e+00,0.33869e+00 /)
      kao(:, 3, 5,14) = (/ &
        & 0.96078e-01,0.94065e-01,0.10459e+00,0.13623e+00,0.18035e+00, &
        & 0.22539e+00,0.27041e+00,0.31537e+00,0.36019e+00 /)
      kao(:, 4, 5,14) = (/ &
        & 0.94202e-01,0.93296e-01,0.10703e+00,0.14326e+00,0.19057e+00, &
        & 0.23817e+00,0.28575e+00,0.33330e+00,0.38060e+00 /)
      kao(:, 5, 5,14) = (/ &
        & 0.93055e-01,0.92935e-01,0.10982e+00,0.15042e+00,0.20048e+00, &
        & 0.25056e+00,0.30061e+00,0.35061e+00,0.40035e+00 /)
      kao(:, 1, 6,14) = (/ &
        & 0.11421e+00,0.10796e+00,0.11173e+00,0.12476e+00,0.15549e+00, &
        & 0.19408e+00,0.23286e+00,0.27161e+00,0.31032e+00 /)
      kao(:, 2, 6,14) = (/ &
        & 0.11123e+00,0.10718e+00,0.11218e+00,0.13121e+00,0.16775e+00, &
        & 0.20966e+00,0.25155e+00,0.29340e+00,0.33523e+00 /)
      kao(:, 3, 6,14) = (/ &
        & 0.10875e+00,0.10588e+00,0.11334e+00,0.13798e+00,0.17972e+00, &
        & 0.22462e+00,0.26950e+00,0.31433e+00,0.35914e+00 /)
      kao(:, 4, 6,14) = (/ &
        & 0.10666e+00,0.10458e+00,0.11529e+00,0.14519e+00,0.19132e+00, &
        & 0.23911e+00,0.28688e+00,0.33463e+00,0.38232e+00 /)
      kao(:, 5, 6,14) = (/ &
        & 0.10502e+00,0.10381e+00,0.11770e+00,0.15287e+00,0.20267e+00, &
        & 0.25329e+00,0.30392e+00,0.35446e+00,0.40496e+00 /)
      kao(:, 1, 7,14) = (/ &
        & 0.12988e+00,0.12138e+00,0.12291e+00,0.12930e+00,0.15315e+00, &
        & 0.18907e+00,0.22686e+00,0.26460e+00,0.30239e+00 /)
      kao(:, 2, 7,14) = (/ &
        & 0.12649e+00,0.12054e+00,0.12314e+00,0.13530e+00,0.16601e+00, &
        & 0.20667e+00,0.24798e+00,0.28925e+00,0.33056e+00 /)
      kao(:, 3, 7,14) = (/ &
        & 0.12370e+00,0.11924e+00,0.12400e+00,0.14174e+00,0.17907e+00, &
        & 0.22369e+00,0.26838e+00,0.31304e+00,0.35775e+00 /)
      kao(:, 4, 7,14) = (/ &
        & 0.12121e+00,0.11770e+00,0.12551e+00,0.14889e+00,0.19207e+00, &
        & 0.24005e+00,0.28802e+00,0.33592e+00,0.38391e+00 /)
      kao(:, 5, 7,14) = (/ &
        & 0.11892e+00,0.11635e+00,0.12739e+00,0.15666e+00,0.20470e+00, &
        & 0.25583e+00,0.30694e+00,0.35802e+00,0.40917e+00 /)
      kao(:, 1, 8,14) = (/ &
        & 0.14795e+00,0.13669e+00,0.13564e+00,0.13646e+00,0.15231e+00, &
        & 0.18310e+00,0.21966e+00,0.25622e+00,0.29284e+00 /)
      kao(:, 2, 8,14) = (/ &
        & 0.14430e+00,0.13540e+00,0.13550e+00,0.14118e+00,0.16490e+00, &
        & 0.20238e+00,0.24284e+00,0.28324e+00,0.32374e+00 /)
      kao(:, 3, 8,14) = (/ &
        & 0.14109e+00,0.13403e+00,0.13585e+00,0.14713e+00,0.17836e+00, &
        & 0.22126e+00,0.26548e+00,0.30963e+00,0.35392e+00 /)
      kao(:, 4, 8,14) = (/ &
        & 0.13807e+00,0.13250e+00,0.13707e+00,0.15422e+00,0.19232e+00, &
        & 0.23967e+00,0.28757e+00,0.33540e+00,0.38338e+00 /)
      kao(:, 5, 8,14) = (/ &
        & 0.13514e+00,0.13080e+00,0.13878e+00,0.16197e+00,0.20594e+00, &
        & 0.25719e+00,0.30860e+00,0.35994e+00,0.41142e+00 /)
      kao(:, 1, 9,14) = (/ &
        & 0.16812e+00,0.15406e+00,0.15051e+00,0.14632e+00,0.15371e+00, &
        & 0.17730e+00,0.21108e+00,0.24622e+00,0.28143e+00 /)
      kao(:, 2, 9,14) = (/ &
        & 0.16420e+00,0.15230e+00,0.14950e+00,0.14998e+00,0.16549e+00, &
        & 0.19706e+00,0.23609e+00,0.27539e+00,0.31477e+00 /)
      kao(:, 3, 9,14) = (/ &
        & 0.16053e+00,0.15077e+00,0.14903e+00,0.15488e+00,0.17883e+00, &
        & 0.21740e+00,0.26082e+00,0.30423e+00,0.34775e+00 /)
      kao(:, 4, 9,14) = (/ &
        & 0.15694e+00,0.14891e+00,0.14991e+00,0.16140e+00,0.19301e+00, &
        & 0.23753e+00,0.28500e+00,0.33244e+00,0.37999e+00 /)
      kao(:, 5, 9,14) = (/ &
        & 0.15342e+00,0.14670e+00,0.15145e+00,0.16838e+00,0.20634e+00, &
        & 0.25567e+00,0.30677e+00,0.35784e+00,0.40903e+00 /)
      kao(:, 1,10,14) = (/ &
        & 0.18962e+00,0.17319e+00,0.16709e+00,0.15817e+00,0.15908e+00, &
        & 0.17425e+00,0.20287e+00,0.23665e+00,0.27049e+00 /)
      kao(:, 2,10,14) = (/ &
        & 0.18536e+00,0.17110e+00,0.16526e+00,0.16124e+00,0.16946e+00, &
        & 0.19394e+00,0.22959e+00,0.26781e+00,0.30611e+00 /)
      kao(:, 3,10,14) = (/ &
        & 0.18117e+00,0.16910e+00,0.16400e+00,0.16579e+00,0.18236e+00, &
        & 0.21466e+00,0.25610e+00,0.29874e+00,0.34146e+00 /)
      kao(:, 4,10,14) = (/ &
        & 0.17697e+00,0.16677e+00,0.16446e+00,0.17161e+00,0.19589e+00, &
        & 0.23479e+00,0.28114e+00,0.32796e+00,0.37484e+00 /)
      kao(:, 5,10,14) = (/ &
        & 0.17281e+00,0.16399e+00,0.16565e+00,0.17716e+00,0.20808e+00, &
        & 0.25277e+00,0.30323e+00,0.35372e+00,0.40429e+00 /)
      kao(:, 1,11,14) = (/ &
        & 0.21055e+00,0.19254e+00,0.18359e+00,0.17274e+00,0.17137e+00, &
        & 0.18167e+00,0.20669e+00,0.24044e+00,0.24447e+00 /)
      kao(:, 2,11,14) = (/ &
        & 0.20570e+00,0.19011e+00,0.18168e+00,0.17577e+00,0.18167e+00, &
        & 0.20144e+00,0.23412e+00,0.27305e+00,0.28987e+00 /)
      kao(:, 3,11,14) = (/ &
        & 0.20088e+00,0.18755e+00,0.18057e+00,0.18058e+00,0.19347e+00, &
        & 0.22124e+00,0.26062e+00,0.30406e+00,0.33203e+00 /)
      kao(:, 4,11,14) = (/ &
        & 0.19608e+00,0.18439e+00,0.18082e+00,0.18569e+00,0.20488e+00, &
        & 0.23927e+00,0.28460e+00,0.33201e+00,0.37191e+00 /)
      kao(:, 5,11,14) = (/ &
        & 0.19134e+00,0.18083e+00,0.18137e+00,0.19023e+00,0.21563e+00, &
        & 0.25670e+00,0.30697e+00,0.35809e+00,0.40924e+00 /)
      kao(:, 1,12,14) = (/ &
        & 0.23222e+00,0.21282e+00,0.20059e+00,0.18856e+00,0.18455e+00, &
        & 0.18954e+00,0.20921e+00,0.24116e+00,0.20678e+00 /)
      kao(:, 2,12,14) = (/ &
        & 0.22666e+00,0.20982e+00,0.19853e+00,0.19166e+00,0.19460e+00, &
        & 0.20805e+00,0.23602e+00,0.27405e+00,0.24947e+00 /)
      kao(:, 3,12,14) = (/ &
        & 0.22121e+00,0.20649e+00,0.19756e+00,0.19621e+00,0.20452e+00, &
        & 0.22597e+00,0.26146e+00,0.30478e+00,0.28725e+00 /)
      kao(:, 4,12,14) = (/ &
        & 0.21578e+00,0.20240e+00,0.19746e+00,0.20035e+00,0.21392e+00, &
        & 0.24302e+00,0.28559e+00,0.33317e+00,0.32415e+00 /)
      kao(:, 5,12,14) = (/ &
        & 0.21026e+00,0.19816e+00,0.19729e+00,0.20402e+00,0.22339e+00, &
        & 0.25983e+00,0.30840e+00,0.35980e+00,0.36272e+00 /)
      kao(:, 1,13,14) = (/ &
        & 0.25447e+00,0.23356e+00,0.21785e+00,0.20504e+00,0.19797e+00, &
        & 0.19705e+00,0.20967e+00,0.23794e+00,0.19657e+00 /)
      kao(:, 2,13,14) = (/ &
        & 0.24820e+00,0.22981e+00,0.21561e+00,0.20828e+00,0.20711e+00, &
        & 0.21347e+00,0.23520e+00,0.27088e+00,0.23547e+00 /)
      kao(:, 3,13,14) = (/ &
        & 0.24206e+00,0.22556e+00,0.21467e+00,0.21216e+00,0.21525e+00, &
        & 0.22938e+00,0.25994e+00,0.30180e+00,0.27108e+00 /)
      kao(:, 4,13,14) = (/ &
        & 0.23572e+00,0.22056e+00,0.21408e+00,0.21517e+00,0.22293e+00, &
        & 0.24576e+00,0.28399e+00,0.33091e+00,0.30909e+00 /)
      kao(:, 5,13,14) = (/ &
        & 0.22932e+00,0.21557e+00,0.21287e+00,0.21778e+00,0.23130e+00, &
        & 0.26208e+00,0.30701e+00,0.35815e+00,0.34602e+00 /)
      kao(:, 1, 1,15) = (/ &
        & 0.79223e-01,0.75104e-01,0.13846e+00,0.20766e+00,0.27685e+00, &
        & 0.34601e+00,0.41512e+00,0.48397e+00,0.52564e+00 /)
      kao(:, 2, 1,15) = (/ &
        & 0.76682e-01,0.76450e-01,0.14571e+00,0.21854e+00,0.29137e+00, &
        & 0.36417e+00,0.43689e+00,0.50929e+00,0.55383e+00 /)
      kao(:, 3, 1,15) = (/ &
        & 0.74345e-01,0.78213e-01,0.15207e+00,0.22808e+00,0.30407e+00, &
        & 0.38004e+00,0.45593e+00,0.53155e+00,0.57851e+00 /)
      kao(:, 4, 1,15) = (/ &
        & 0.72607e-01,0.80130e-01,0.15758e+00,0.23638e+00,0.31513e+00, &
        & 0.39385e+00,0.47252e+00,0.55092e+00,0.60005e+00 /)
      kao(:, 5, 1,15) = (/ &
        & 0.72847e-01,0.82433e-01,0.16249e+00,0.24371e+00,0.32491e+00, &
        & 0.40606e+00,0.48713e+00,0.56790e+00,0.61880e+00 /)
      kao(:, 1, 2,15) = (/ &
        & 0.89010e-01,0.84748e-01,0.15528e+00,0.23291e+00,0.31052e+00, &
        & 0.38812e+00,0.46559e+00,0.54282e+00,0.60189e+00 /)
      kao(:, 2, 2,15) = (/ &
        & 0.86286e-01,0.86390e-01,0.16350e+00,0.24523e+00,0.32694e+00, &
        & 0.40865e+00,0.49029e+00,0.57166e+00,0.63436e+00 /)
      kao(:, 3, 2,15) = (/ &
        & 0.83865e-01,0.88469e-01,0.17076e+00,0.25611e+00,0.34145e+00, &
        & 0.42675e+00,0.51202e+00,0.59693e+00,0.66276e+00 /)
      kao(:, 4, 2,15) = (/ &
        & 0.81971e-01,0.90581e-01,0.17733e+00,0.26595e+00,0.35459e+00, &
        & 0.44319e+00,0.53165e+00,0.61981e+00,0.68802e+00 /)
      kao(:, 5, 2,15) = (/ &
        & 0.81826e-01,0.93085e-01,0.18319e+00,0.27476e+00,0.36629e+00, &
        & 0.45781e+00,0.54921e+00,0.64033e+00,0.71080e+00 /)
      kao(:, 1, 3,15) = (/ &
        & 0.10078e+00,0.96469e-01,0.17126e+00,0.25687e+00,0.34247e+00, &
        & 0.42804e+00,0.51357e+00,0.59868e+00,0.67473e+00 /)
      kao(:, 2, 3,15) = (/ &
        & 0.97698e-01,0.98193e-01,0.18058e+00,0.27084e+00,0.36108e+00, &
        & 0.45128e+00,0.54134e+00,0.63128e+00,0.71182e+00 /)
      kao(:, 3, 3,15) = (/ &
        & 0.95186e-01,0.10027e+00,0.18871e+00,0.28303e+00,0.37733e+00, &
        & 0.47160e+00,0.56577e+00,0.65972e+00,0.74408e+00 /)
      kao(:, 4, 3,15) = (/ &
        & 0.93223e-01,0.10231e+00,0.19621e+00,0.29427e+00,0.39234e+00, &
        & 0.49035e+00,0.58829e+00,0.68586e+00,0.77383e+00 /)
      kao(:, 5, 3,15) = (/ &
        & 0.93003e-01,0.10431e+00,0.20302e+00,0.30448e+00,0.40592e+00, &
        & 0.50734e+00,0.60870e+00,0.70970e+00,0.80084e+00 /)
      kao(:, 1, 4,15) = (/ &
        & 0.11556e+00,0.11007e+00,0.18689e+00,0.28032e+00,0.37373e+00, &
        & 0.46710e+00,0.56044e+00,0.65346e+00,0.74264e+00 /)
      kao(:, 2, 4,15) = (/ &
        & 0.11235e+00,0.11167e+00,0.19754e+00,0.29630e+00,0.39502e+00, &
        & 0.49371e+00,0.59235e+00,0.69064e+00,0.78516e+00 /)
      kao(:, 3, 4,15) = (/ &
        & 0.10972e+00,0.11355e+00,0.20696e+00,0.31040e+00,0.41383e+00, &
        & 0.51721e+00,0.62053e+00,0.72352e+00,0.82248e+00 /)
      kao(:, 4, 4,15) = (/ &
        & 0.10741e+00,0.11554e+00,0.21557e+00,0.32331e+00,0.43105e+00, &
        & 0.53874e+00,0.64632e+00,0.75359e+00,0.85679e+00 /)
      kao(:, 5, 4,15) = (/ &
        & 0.10619e+00,0.11745e+00,0.22327e+00,0.33487e+00,0.44646e+00, &
        & 0.55799e+00,0.66944e+00,0.78056e+00,0.88741e+00 /)
      kao(:, 1, 5,15) = (/ &
        & 0.13422e+00,0.12619e+00,0.20125e+00,0.30186e+00,0.40245e+00, &
        & 0.50302e+00,0.60348e+00,0.70372e+00,0.80253e+00 /)
      kao(:, 2, 5,15) = (/ &
        & 0.13052e+00,0.12743e+00,0.21345e+00,0.32016e+00,0.42685e+00, &
        & 0.53351e+00,0.64011e+00,0.74634e+00,0.85136e+00 /)
      kao(:, 3, 5,15) = (/ &
        & 0.12741e+00,0.12876e+00,0.22450e+00,0.33672e+00,0.44894e+00, &
        & 0.56113e+00,0.67322e+00,0.78494e+00,0.89542e+00 /)
      kao(:, 4, 5,15) = (/ &
        & 0.12456e+00,0.13045e+00,0.23454e+00,0.35177e+00,0.46901e+00, &
        & 0.58622e+00,0.70332e+00,0.82004e+00,0.93535e+00 /)
      kao(:, 5, 5,15) = (/ &
        & 0.12240e+00,0.13234e+00,0.24346e+00,0.36515e+00,0.48682e+00, &
        & 0.60842e+00,0.72992e+00,0.85105e+00,0.97074e+00 /)
      kao(:, 1, 6,15) = (/ &
        & 0.15641e+00,0.14549e+00,0.21406e+00,0.31903e+00,0.42534e+00, &
        & 0.53165e+00,0.63788e+00,0.74385e+00,0.84964e+00 /)
      kao(:, 2, 6,15) = (/ &
        & 0.15207e+00,0.14574e+00,0.22708e+00,0.34022e+00,0.45360e+00, &
        & 0.56697e+00,0.68027e+00,0.79322e+00,0.90603e+00 /)
      kao(:, 3, 6,15) = (/ &
        & 0.14825e+00,0.14665e+00,0.23979e+00,0.35965e+00,0.47950e+00, &
        & 0.59932e+00,0.71907e+00,0.83857e+00,0.95773e+00 /)
      kao(:, 4, 6,15) = (/ &
        & 0.14482e+00,0.14790e+00,0.25144e+00,0.37711e+00,0.50278e+00, &
        & 0.62841e+00,0.75400e+00,0.87926e+00,0.10043e+01 /)
      kao(:, 5, 6,15) = (/ &
        & 0.14196e+00,0.14929e+00,0.26158e+00,0.39235e+00,0.52312e+00, &
        & 0.65390e+00,0.78460e+00,0.91489e+00,0.10450e+01 /)
      kao(:, 1, 7,15) = (/ &
        & 0.18245e+00,0.16813e+00,0.22831e+00,0.33360e+00,0.44476e+00, &
        & 0.55591e+00,0.66702e+00,0.77783e+00,0.88903e+00 /)
      kao(:, 2, 7,15) = (/ &
        & 0.17706e+00,0.16763e+00,0.24144e+00,0.35719e+00,0.47625e+00, &
        & 0.59524e+00,0.71422e+00,0.83295e+00,0.95194e+00 /)
      kao(:, 3, 7,15) = (/ &
        & 0.17236e+00,0.16756e+00,0.25360e+00,0.37892e+00,0.50520e+00, &
        & 0.63143e+00,0.75766e+00,0.88351e+00,0.10099e+01 /)
      kao(:, 4, 7,15) = (/ &
        & 0.16823e+00,0.16816e+00,0.26586e+00,0.39858e+00,0.53141e+00, &
        & 0.66420e+00,0.79692e+00,0.92941e+00,0.10623e+01 /)
      kao(:, 5, 7,15) = (/ &
        & 0.16468e+00,0.16894e+00,0.27725e+00,0.41585e+00,0.55445e+00, &
        & 0.69298e+00,0.83146e+00,0.96971e+00,0.11082e+01 /)
      kao(:, 1, 8,15) = (/ &
        & 0.21221e+00,0.19366e+00,0.24501e+00,0.34518e+00,0.46022e+00, &
        & 0.57522e+00,0.69013e+00,0.80500e+00,0.92024e+00 /)
      kao(:, 2, 8,15) = (/ &
        & 0.20558e+00,0.19344e+00,0.25798e+00,0.37195e+00,0.49597e+00, &
        & 0.61989e+00,0.74379e+00,0.86737e+00,0.99166e+00 /)
      kao(:, 3, 8,15) = (/ &
        & 0.19977e+00,0.19260e+00,0.26963e+00,0.39624e+00,0.52829e+00, &
        & 0.66032e+00,0.79227e+00,0.92396e+00,0.10564e+01 /)
      kao(:, 4, 8,15) = (/ &
        & 0.19471e+00,0.19196e+00,0.28135e+00,0.41773e+00,0.55693e+00, &
        & 0.69614e+00,0.83525e+00,0.97412e+00,0.11137e+01 /)
      kao(:, 5, 8,15) = (/ &
        & 0.19023e+00,0.19149e+00,0.29229e+00,0.43683e+00,0.58243e+00, &
        & 0.72800e+00,0.87352e+00,0.10186e+01,0.11647e+01 /)
      kao(:, 1, 9,15) = (/ &
        & 0.24675e+00,0.22274e+00,0.26456e+00,0.35496e+00,0.47007e+00, &
        & 0.58755e+00,0.70496e+00,0.82216e+00,0.94015e+00 /)
      kao(:, 2, 9,15) = (/ &
        & 0.23844e+00,0.22223e+00,0.27692e+00,0.38304e+00,0.51028e+00, &
        & 0.63780e+00,0.76534e+00,0.89259e+00,0.10206e+01 /)
      kao(:, 3, 9,15) = (/ &
        & 0.23115e+00,0.22076e+00,0.28808e+00,0.40973e+00,0.54629e+00, &
        & 0.68281e+00,0.81930e+00,0.95554e+00,0.10926e+01 /)
      kao(:, 4, 9,15) = (/ &
        & 0.22487e+00,0.21935e+00,0.29872e+00,0.43339e+00,0.57783e+00, &
        & 0.72230e+00,0.86661e+00,0.10108e+01,0.11557e+01 /)
      kao(:, 5, 9,15) = (/ &
        & 0.21911e+00,0.21807e+00,0.30914e+00,0.45602e+00,0.60799e+00, &
        & 0.75991e+00,0.91189e+00,0.10634e+01,0.12161e+01 /)
      kao(:, 1,10,15) = (/ &
        & 0.28580e+00,0.25610e+00,0.28839e+00,0.36810e+00,0.47645e+00, &
        & 0.59554e+00,0.71455e+00,0.83348e+00,0.95290e+00 /)
      kao(:, 2,10,15) = (/ &
        & 0.27554e+00,0.25438e+00,0.29985e+00,0.39603e+00,0.52141e+00, &
        & 0.65175e+00,0.78205e+00,0.91212e+00,0.10429e+01 /)
      kao(:, 3,10,15) = (/ &
        & 0.26639e+00,0.25230e+00,0.31000e+00,0.42263e+00,0.56074e+00, &
        & 0.70092e+00,0.84101e+00,0.98094e+00,0.11215e+01 /)
      kao(:, 4,10,15) = (/ &
        & 0.25840e+00,0.24961e+00,0.31933e+00,0.44762e+00,0.59663e+00, &
        & 0.74572e+00,0.89477e+00,0.10436e+01,0.11932e+01 /)
      kao(:, 5,10,15) = (/ &
        & 0.25110e+00,0.24738e+00,0.32882e+00,0.47409e+00,0.63208e+00, &
        & 0.79011e+00,0.94801e+00,0.11055e+01,0.12642e+01 /)
      kao(:, 1,11,15) = (/ &
        & 0.32402e+00,0.29231e+00,0.32114e+00,0.39449e+00,0.49965e+00, &
        & 0.62359e+00,0.74830e+00,0.87279e+00,0.99780e+00 /)
      kao(:, 2,11,15) = (/ &
        & 0.31203e+00,0.28940e+00,0.33009e+00,0.42179e+00,0.54573e+00, &
        & 0.68214e+00,0.81856e+00,0.95481e+00,0.10916e+01 /)
      kao(:, 3,11,15) = (/ &
        & 0.30125e+00,0.28556e+00,0.33820e+00,0.44749e+00,0.58870e+00, &
        & 0.73583e+00,0.88295e+00,0.10298e+01,0.11773e+01 /)
      kao(:, 4,11,15) = (/ &
        & 0.29153e+00,0.28159e+00,0.34632e+00,0.47427e+00,0.63035e+00, &
        & 0.78788e+00,0.94537e+00,0.11027e+01,0.12607e+01 /)
      kao(:, 5,11,15) = (/ &
        & 0.28247e+00,0.27799e+00,0.35496e+00,0.50259e+00,0.66996e+00, &
        & 0.83740e+00,0.10047e+01,0.11720e+01,0.13400e+01 /)
      kao(:, 1,12,15) = (/ &
        & 0.36545e+00,0.33140e+00,0.35636e+00,0.42085e+00,0.52250e+00, &
        & 0.64898e+00,0.77872e+00,0.90834e+00,0.10384e+01 /)
      kao(:, 2,12,15) = (/ &
        & 0.35131e+00,0.32685e+00,0.36231e+00,0.44658e+00,0.56903e+00, &
        & 0.71087e+00,0.85304e+00,0.99503e+00,0.11374e+01 /)
      kao(:, 3,12,15) = (/ &
        & 0.33841e+00,0.32098e+00,0.36825e+00,0.47208e+00,0.61613e+00, &
        & 0.77016e+00,0.92410e+00,0.10779e+01,0.12323e+01 /)
      kao(:, 4,12,15) = (/ &
        & 0.32642e+00,0.31543e+00,0.37504e+00,0.50058e+00,0.66195e+00, &
        & 0.82736e+00,0.99279e+00,0.11580e+01,0.13239e+01 /)
      kao(:, 5,12,15) = (/ &
        & 0.31541e+00,0.31006e+00,0.38358e+00,0.53015e+00,0.70512e+00, &
        & 0.88131e+00,0.10574e+01,0.12335e+01,0.14101e+01 /)
      kao(:, 1,13,15) = (/ &
        & 0.40964e+00,0.37314e+00,0.39372e+00,0.44813e+00,0.54521e+00, &
        & 0.67332e+00,0.80793e+00,0.94247e+00,0.10773e+01 /)
      kao(:, 2,13,15) = (/ &
        & 0.39277e+00,0.36624e+00,0.39629e+00,0.47194e+00,0.59295e+00, &
        & 0.73949e+00,0.88734e+00,0.10350e+01,0.11832e+01 /)
      kao(:, 3,13,15) = (/ &
        & 0.37714e+00,0.35816e+00,0.39962e+00,0.49769e+00,0.64296e+00, &
        & 0.80367e+00,0.96435e+00,0.11249e+01,0.12860e+01 /)
      kao(:, 4,13,15) = (/ &
        & 0.36268e+00,0.35049e+00,0.40459e+00,0.52725e+00,0.69174e+00, &
        & 0.86463e+00,0.10374e+01,0.12101e+01,0.13834e+01 /)
      kao(:, 5,13,15) = (/ &
        & 0.34948e+00,0.34295e+00,0.41358e+00,0.55736e+00,0.73767e+00, &
        & 0.92205e+00,0.11064e+01,0.12905e+01,0.14753e+01 /)
      kao(:, 1, 1,16) = (/ &
        & 0.90320e-01,0.86361e-01,0.17271e+00,0.25905e+00,0.34536e+00, &
        & 0.43163e+00,0.51777e+00,0.60344e+00,0.64541e+00 /)
      kao(:, 2, 1,16) = (/ &
        & 0.88026e-01,0.92415e-01,0.18482e+00,0.27721e+00,0.36957e+00, &
        & 0.46188e+00,0.55406e+00,0.64572e+00,0.69076e+00 /)
      kao(:, 3, 1,16) = (/ &
        & 0.85829e-01,0.97954e-01,0.19590e+00,0.29382e+00,0.39172e+00, &
        & 0.48957e+00,0.58728e+00,0.68449e+00,0.73223e+00 /)
      kao(:, 4, 1,16) = (/ &
        & 0.83674e-01,0.10298e+00,0.20595e+00,0.30890e+00,0.41183e+00, &
        & 0.51469e+00,0.61741e+00,0.71956e+00,0.77014e+00 /)
      kao(:, 5, 1,16) = (/ &
        & 0.84304e-01,0.10756e+00,0.21511e+00,0.32264e+00,0.43014e+00, &
        & 0.53758e+00,0.64487e+00,0.75164e+00,0.80439e+00 /)
      kao(:, 1, 2,16) = (/ &
        & 0.99611e-01,0.10121e+00,0.20241e+00,0.30359e+00,0.40479e+00, &
        & 0.50590e+00,0.60686e+00,0.70732e+00,0.77453e+00 /)
      kao(:, 2, 2,16) = (/ &
        & 0.97224e-01,0.10870e+00,0.21739e+00,0.32607e+00,0.43471e+00, &
        & 0.54336e+00,0.65181e+00,0.75967e+00,0.83199e+00 /)
      kao(:, 3, 2,16) = (/ &
        & 0.94894e-01,0.11558e+00,0.23114e+00,0.34669e+00,0.46220e+00, &
        & 0.57772e+00,0.69302e+00,0.80771e+00,0.88476e+00 /)
      kao(:, 4, 2,16) = (/ &
        & 0.92656e-01,0.12184e+00,0.24366e+00,0.36546e+00,0.48723e+00, &
        & 0.60893e+00,0.73046e+00,0.85132e+00,0.93269e+00 /)
      kao(:, 5, 2,16) = (/ &
        & 0.93593e-01,0.12749e+00,0.25497e+00,0.38243e+00,0.50985e+00, &
        & 0.63721e+00,0.76438e+00,0.89083e+00,0.97622e+00 /)
      kao(:, 1, 3,16) = (/ &
        & 0.11521e+00,0.11614e+00,0.23226e+00,0.34836e+00,0.46443e+00, &
        & 0.58044e+00,0.69629e+00,0.81149e+00,0.90951e+00 /)
      kao(:, 2, 3,16) = (/ &
        & 0.11222e+00,0.12555e+00,0.25108e+00,0.37659e+00,0.50206e+00, &
        & 0.62747e+00,0.75258e+00,0.87709e+00,0.98316e+00 /)
      kao(:, 3, 3,16) = (/ &
        & 0.10948e+00,0.13410e+00,0.26819e+00,0.40226e+00,0.53629e+00, &
        & 0.67035e+00,0.80421e+00,0.93726e+00,0.10505e+01 /)
      kao(:, 4, 3,16) = (/ &
        & 0.10697e+00,0.14195e+00,0.28389e+00,0.42580e+00,0.56768e+00, &
        & 0.70947e+00,0.85107e+00,0.99187e+00,0.11120e+01 /)
      kao(:, 5, 3,16) = (/ &
        & 0.10462e+00,0.14901e+00,0.29800e+00,0.44697e+00,0.59590e+00, &
        & 0.74474e+00,0.89338e+00,0.10415e+01,0.11678e+01 /)
      kao(:, 1, 4,16) = (/ &
        & 0.13825e+00,0.13238e+00,0.26314e+00,0.39468e+00,0.52618e+00, &
        & 0.65761e+00,0.78893e+00,0.91946e+00,0.10423e+01 /)
      kao(:, 2, 4,16) = (/ &
        & 0.13437e+00,0.14320e+00,0.28638e+00,0.42954e+00,0.57266e+00, &
        & 0.71574e+00,0.85868e+00,0.10008e+01,0.11347e+01 /)
      kao(:, 3, 4,16) = (/ &
        & 0.13067e+00,0.15392e+00,0.30782e+00,0.46170e+00,0.61554e+00, &
        & 0.76929e+00,0.92283e+00,0.10757e+01,0.12195e+01 /)
      kao(:, 4, 4,16) = (/ &
        & 0.12733e+00,0.16364e+00,0.32725e+00,0.49085e+00,0.65439e+00, &
        & 0.81785e+00,0.98125e+00,0.11437e+01,0.12968e+01 /)
      kao(:, 5, 4,16) = (/ &
        & 0.12429e+00,0.17242e+00,0.34483e+00,0.51721e+00,0.68954e+00, &
        & 0.86178e+00,0.10339e+01,0.12053e+01,0.13667e+01 /)
      kao(:, 1, 5,16) = (/ &
        & 0.16714e+00,0.15294e+00,0.29770e+00,0.44651e+00,0.59528e+00, &
        & 0.74397e+00,0.89246e+00,0.10402e+01,0.11846e+01 /)
      kao(:, 2, 5,16) = (/ &
        & 0.16248e+00,0.16289e+00,0.32569e+00,0.48850e+00,0.65127e+00, &
        & 0.81396e+00,0.97625e+00,0.11381e+01,0.12962e+01 /)
      kao(:, 3, 5,16) = (/ &
        & 0.15803e+00,0.17580e+00,0.35158e+00,0.52733e+00,0.70303e+00, &
        & 0.87864e+00,0.10540e+01,0.12284e+01,0.13993e+01 /)
      kao(:, 4, 5,16) = (/ &
        & 0.15368e+00,0.18757e+00,0.37512e+00,0.56264e+00,0.75011e+00, &
        & 0.93747e+00,0.11247e+01,0.13108e+01,0.14933e+01 /)
      kao(:, 5, 5,16) = (/ &
        & 0.14943e+00,0.19824e+00,0.39645e+00,0.59477e+00,0.79303e+00, &
        & 0.99112e+00,0.11890e+01,0.13858e+01,0.15783e+01 /)
      kao(:, 1, 6,16) = (/ &
        & 0.20217e+00,0.17926e+00,0.33507e+00,0.50257e+00,0.67002e+00, &
        & 0.83741e+00,0.10046e+01,0.11708e+01,0.13365e+01 /)
      kao(:, 2, 6,16) = (/ &
        & 0.19655e+00,0.18668e+00,0.36910e+00,0.55360e+00,0.73806e+00, &
        & 0.92245e+00,0.11065e+01,0.12896e+01,0.14724e+01 /)
      kao(:, 3, 6,16) = (/ &
        & 0.19100e+00,0.20029e+00,0.40054e+00,0.60077e+00,0.80095e+00, &
        & 0.10010e+01,0.12008e+01,0.13997e+01,0.15979e+01 /)
      kao(:, 4, 6,16) = (/ &
        & 0.18556e+00,0.21465e+00,0.42926e+00,0.64385e+00,0.85838e+00, &
        & 0.10728e+01,0.12869e+01,0.15000e+01,0.17126e+01 /)
      kao(:, 5, 6,16) = (/ &
        & 0.18024e+00,0.22760e+00,0.45517e+00,0.68271e+00,0.91019e+00, &
        & 0.11375e+01,0.13647e+01,0.15907e+01,0.18161e+01 /)
      kao(:, 1, 7,16) = (/ &
        & 0.24417e+00,0.21368e+00,0.37507e+00,0.56256e+00,0.75006e+00, &
        & 0.93742e+00,0.11245e+01,0.13107e+01,0.14982e+01 /)
      kao(:, 2, 7,16) = (/ &
        & 0.23715e+00,0.21661e+00,0.41650e+00,0.62470e+00,0.83285e+00, &
        & 0.10409e+01,0.12487e+01,0.14555e+01,0.16638e+01 /)
      kao(:, 3, 7,16) = (/ &
        & 0.23022e+00,0.22856e+00,0.45485e+00,0.68222e+00,0.90954e+00, &
        & 0.11367e+01,0.13637e+01,0.15896e+01,0.18170e+01 /)
      kao(:, 4, 7,16) = (/ &
        & 0.22335e+00,0.24491e+00,0.48979e+00,0.73464e+00,0.97947e+00, &
        & 0.12241e+01,0.14686e+01,0.17118e+01,0.19566e+01 /)
      kao(:, 5, 7,16) = (/ &
        & 0.21655e+00,0.26068e+00,0.52133e+00,0.78194e+00,0.10425e+01, &
        & 0.13029e+01,0.15630e+01,0.18220e+01,0.20827e+01 /)
      kao(:, 1, 8,16) = (/ &
        & 0.29541e+00,0.25848e+00,0.41687e+00,0.62527e+00,0.83361e+00, &
        & 0.10419e+01,0.12499e+01,0.14571e+01,0.16668e+01 /)
      kao(:, 2, 8,16) = (/ &
        & 0.28549e+00,0.25449e+00,0.46724e+00,0.70082e+00,0.93434e+00, &
        & 0.11678e+01,0.14009e+01,0.16328e+01,0.18680e+01 /)
      kao(:, 3, 8,16) = (/ &
        & 0.27625e+00,0.26285e+00,0.51364e+00,0.77040e+00,0.10271e+01, &
        & 0.12838e+01,0.15402e+01,0.17956e+01,0.20538e+01 /)
      kao(:, 4, 8,16) = (/ &
        & 0.26742e+00,0.27883e+00,0.55601e+00,0.83395e+00,0.11118e+01, &
        & 0.13896e+01,0.16670e+01,0.19436e+01,0.22230e+01 /)
      kao(:, 5, 8,16) = (/ &
        & 0.25873e+00,0.29706e+00,0.59410e+00,0.89109e+00,0.11880e+01, &
        & 0.14848e+01,0.17812e+01,0.20764e+01,0.23753e+01 /)
      kao(:, 1, 9,16) = (/ &
        & 0.35727e+00,0.31262e+00,0.45859e+00,0.68783e+00,0.91710e+00, &
        & 0.11462e+01,0.13749e+01,0.16027e+01,0.18342e+01 /)
      kao(:, 2, 9,16) = (/ &
        & 0.34378e+00,0.30157e+00,0.51912e+00,0.77863e+00,0.10382e+01, &
        & 0.12975e+01,0.15566e+01,0.18147e+01,0.20764e+01 /)
      kao(:, 3, 9,16) = (/ &
        & 0.33111e+00,0.30494e+00,0.57506e+00,0.86254e+00,0.11500e+01, &
        & 0.14374e+01,0.17244e+01,0.20104e+01,0.23002e+01 /)
      kao(:, 4, 9,16) = (/ &
        & 0.31901e+00,0.31860e+00,0.62597e+00,0.93889e+00,0.12519e+01, &
        & 0.15648e+01,0.18772e+01,0.21885e+01,0.25042e+01 /)
      kao(:, 5, 9,16) = (/ &
        & 0.30738e+00,0.33686e+00,0.67173e+00,0.10075e+01,0.13433e+01, &
        & 0.16788e+01,0.20142e+01,0.23482e+01,0.26866e+01 /)
      kao(:, 1,10,16) = (/ &
        & 0.42900e+00,0.37537e+00,0.50742e+00,0.76107e+00,0.10147e+01, &
        & 0.12682e+01,0.15216e+01,0.17737e+01,0.20298e+01 /)
      kao(:, 2,10,16) = (/ &
        & 0.41120e+00,0.35980e+00,0.57626e+00,0.86440e+00,0.11524e+01, &
        & 0.14403e+01,0.17281e+01,0.20148e+01,0.23052e+01 /)
      kao(:, 3,10,16) = (/ &
        & 0.39435e+00,0.35582e+00,0.64201e+00,0.96295e+00,0.12838e+01, &
        & 0.16046e+01,0.19250e+01,0.22444e+01,0.25680e+01 /)
      kao(:, 4,10,16) = (/ &
        & 0.37835e+00,0.36721e+00,0.70220e+00,0.10532e+01,0.14042e+01, &
        & 0.17550e+01,0.21055e+01,0.24551e+01,0.28089e+01 /)
      kao(:, 5,10,16) = (/ &
        & 0.36302e+00,0.38402e+00,0.75599e+00,0.11339e+01,0.15118e+01, &
        & 0.18894e+01,0.22669e+01,0.26429e+01,0.30243e+01 /)
      kao(:, 1,11,16) = (/ &
        & 0.50130e+00,0.43864e+00,0.59754e+00,0.89626e+00,0.11949e+01, &
        & 0.14934e+01,0.17919e+01,0.20890e+01,0.23902e+01 /)
      kao(:, 2,11,16) = (/ &
        & 0.47862e+00,0.41971e+00,0.67375e+00,0.10106e+01,0.13473e+01, &
        & 0.16840e+01,0.20203e+01,0.23553e+01,0.26950e+01 /)
      kao(:, 3,11,16) = (/ &
        & 0.45729e+00,0.41739e+00,0.74475e+00,0.11171e+01,0.14893e+01, &
        & 0.18615e+01,0.22335e+01,0.26038e+01,0.29786e+01 /)
      kao(:, 4,11,16) = (/ &
        & 0.43691e+00,0.42957e+00,0.80967e+00,0.12144e+01,0.16191e+01, &
        & 0.20236e+01,0.24280e+01,0.28308e+01,0.32389e+01 /)
      kao(:, 5,11,16) = (/ &
        & 0.41748e+00,0.44621e+00,0.86800e+00,0.13019e+01,0.17360e+01, &
        & 0.21698e+01,0.26031e+01,0.30355e+01,0.34723e+01 /)
      kao(:, 1,12,16) = (/ &
        & 0.58052e+00,0.50796e+00,0.69775e+00,0.10466e+01,0.13954e+01, &
        & 0.17440e+01,0.20924e+01,0.24394e+01,0.27908e+01 /)
      kao(:, 2,12,16) = (/ &
        & 0.55207e+00,0.48627e+00,0.78177e+00,0.11726e+01,0.15635e+01, &
        & 0.19543e+01,0.23447e+01,0.27336e+01,0.31273e+01 /)
      kao(:, 3,12,16) = (/ &
        & 0.52503e+00,0.48543e+00,0.85881e+00,0.12881e+01,0.17174e+01, &
        & 0.21467e+01,0.25754e+01,0.30027e+01,0.34355e+01 /)
      kao(:, 4,12,16) = (/ &
        & 0.49945e+00,0.49746e+00,0.92780e+00,0.13917e+01,0.18554e+01, &
        & 0.23191e+01,0.27823e+01,0.32446e+01,0.37108e+01 /)
      kao(:, 5,12,16) = (/ &
        & 0.47536e+00,0.51344e+00,0.98885e+00,0.14832e+01,0.19776e+01, &
        & 0.24717e+01,0.29655e+01,0.34576e+01,0.39563e+01 /)
      kao(:, 1,13,16) = (/ &
        & 0.66560e+00,0.58240e+00,0.80598e+00,0.12089e+01,0.16118e+01, &
        & 0.20145e+01,0.24172e+01,0.28183e+01,0.32240e+01 /)
      kao(:, 2,13,16) = (/ &
        & 0.62986e+00,0.55885e+00,0.89794e+00,0.13468e+01,0.17957e+01, &
        & 0.22443e+01,0.26925e+01,0.31396e+01,0.35914e+01 /)
      kao(:, 3,13,16) = (/ &
        & 0.59613e+00,0.55868e+00,0.98065e+00,0.14709e+01,0.19611e+01, &
        & 0.24513e+01,0.29409e+01,0.34293e+01,0.39230e+01 /)
      kao(:, 4,13,16) = (/ &
        & 0.56427e+00,0.56950e+00,0.10539e+01,0.15808e+01,0.21076e+01, &
        & 0.26342e+01,0.31605e+01,0.36850e+01,0.42159e+01 /)
      kao(:, 5,13,16) = (/ &
        & 0.53530e+00,0.58425e+00,0.11174e+01,0.16761e+01,0.22346e+01, &
        & 0.27933e+01,0.33512e+01,0.39078e+01,0.44703e+01 /)
  
!     -----------------------------------------------------------------
!     The array KBO contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels < ~100mb and temperatures. The first 
!     index in the array, JT, which runs from 1 to 5, corresponds to 
!     different temperatures.  More specifically, JT = 3 means that the 
!     data are for the reference temperature TREF for this pressure 
!     level, JT = 2 refers to the temperature TREF-15, JT = 1 is for
!     TREF-30, JT = 4 is for TREF+15, and JT = 5 is for TREF+30.  
!     The second index, JP, runs from 13 to 59 and refers to the JPth
!     reference pressure level (see taumol.f for the value of these
!     pressure levels in mb).  The third index, IG, goes from 1 to 16,
!     and tells us which g-interval the absorption coefficients are for.
!     -----------------------------------------------------------------

      kbo(:,13, 1) = (/ &
        & 0.12810e-03,0.12891e-03,0.12890e-03,0.12713e-03,0.12477e-03 /)
      kbo(:,14, 1) = (/ &
        & 0.10653e-03,0.10667e-03,0.10648e-03,0.10473e-03,0.10293e-03 /)
      kbo(:,15, 1) = (/ &
        & 0.90176e-04,0.90077e-04,0.89286e-04,0.87879e-04,0.85987e-04 /)
      kbo(:,16, 1) = (/ &
        & 0.77704e-04,0.77304e-04,0.75879e-04,0.74246e-04,0.72070e-04 /)
      kbo(:,17, 1) = (/ &
        & 0.67183e-04,0.65906e-04,0.64619e-04,0.63000e-04,0.61056e-04 /)
      kbo(:,18, 1) = (/ &
        & 0.58741e-04,0.57649e-04,0.56028e-04,0.54293e-04,0.52506e-04 /)
      kbo(:,19, 1) = (/ &
        & 0.51839e-04,0.50715e-04,0.49053e-04,0.47195e-04,0.45368e-04 /)
      kbo(:,20, 1) = (/ &
        & 0.44321e-04,0.43297e-04,0.41923e-04,0.40298e-04,0.38744e-04 /)
      kbo(:,21, 1) = (/ &
        & 0.37527e-04,0.36516e-04,0.35380e-04,0.34037e-04,0.32951e-04 /)
      kbo(:,22, 1) = (/ &
        & 0.31752e-04,0.30703e-04,0.29586e-04,0.28499e-04,0.27519e-04 /)
      kbo(:,23, 1) = (/ &
        & 0.26638e-04,0.25643e-04,0.24693e-04,0.23832e-04,0.22913e-04 /)
      kbo(:,24, 1) = (/ &
        & 0.22325e-04,0.21480e-04,0.20621e-04,0.19867e-04,0.19066e-04 /)
      kbo(:,25, 1) = (/ &
        & 0.18764e-04,0.17998e-04,0.17269e-04,0.16527e-04,0.15821e-04 /)
      kbo(:,26, 1) = (/ &
        & 0.15650e-04,0.14992e-04,0.14356e-04,0.13710e-04,0.13119e-04 /)
      kbo(:,27, 1) = (/ &
        & 0.13054e-04,0.12477e-04,0.11929e-04,0.11393e-04,0.10948e-04 /)
      kbo(:,28, 1) = (/ &
        & 0.10852e-04,0.10390e-04,0.99195e-05,0.95020e-05,0.91993e-05 /)
      kbo(:,29, 1) = (/ &
        & 0.90990e-05,0.87209e-05,0.83384e-05,0.80029e-05,0.77245e-05 /)
      kbo(:,30, 1) = (/ &
        & 0.77169e-05,0.73662e-05,0.70552e-05,0.68029e-05,0.65749e-05 /)
      kbo(:,31, 1) = (/ &
        & 0.65250e-05,0.62364e-05,0.60172e-05,0.57804e-05,0.55504e-05 /)
      kbo(:,32, 1) = (/ &
        & 0.55167e-05,0.53021e-05,0.51088e-05,0.49113e-05,0.47150e-05 /)
      kbo(:,33, 1) = (/ &
        & 0.47261e-05,0.45530e-05,0.43641e-05,0.41725e-05,0.40077e-05 /)
      kbo(:,34, 1) = (/ &
        & 0.40646e-05,0.39062e-05,0.37472e-05,0.36009e-05,0.34549e-05 /)
      kbo(:,35, 1) = (/ &
        & 0.35479e-05,0.34057e-05,0.32704e-05,0.31420e-05,0.30219e-05 /)
      kbo(:,36, 1) = (/ &
        & 0.31353e-05,0.30270e-05,0.29024e-05,0.27776e-05,0.26600e-05 /)
      kbo(:,37, 1) = (/ &
        & 0.26595e-05,0.25621e-05,0.24646e-05,0.23582e-05,0.22563e-05 /)
      kbo(:,38, 1) = (/ &
        & 0.22468e-05,0.21651e-05,0.20812e-05,0.20043e-05,0.19221e-05 /)
      kbo(:,39, 1) = (/ &
        & 0.19009e-05,0.18335e-05,0.17685e-05,0.17039e-05,0.16406e-05 /)
      kbo(:,40, 1) = (/ &
        & 0.15746e-05,0.15188e-05,0.14669e-05,0.14148e-05,0.13668e-05 /)
      kbo(:,41, 1) = (/ &
        & 0.13001e-05,0.12561e-05,0.12122e-05,0.11718e-05,0.11306e-05 /)
      kbo(:,42, 1) = (/ &
        & 0.10716e-05,0.10380e-05,0.10018e-05,0.96745e-06,0.93475e-06 /)
      kbo(:,43, 1) = (/ &
        & 0.87651e-06,0.85172e-06,0.82453e-06,0.79560e-06,0.77011e-06 /)
      kbo(:,44, 1) = (/ &
        & 0.71565e-06,0.69699e-06,0.67699e-06,0.65403e-06,0.63202e-06 /)
      kbo(:,45, 1) = (/ &
        & 0.58391e-06,0.56946e-06,0.55318e-06,0.53575e-06,0.51774e-06 /)
      kbo(:,46, 1) = (/ &
        & 0.47490e-06,0.46531e-06,0.45175e-06,0.43686e-06,0.42260e-06 /)
      kbo(:,47, 1) = (/ &
        & 0.38718e-06,0.37610e-06,0.36650e-06,0.35580e-06,0.34417e-06 /)
      kbo(:,48, 1) = (/ &
        & 0.31464e-06,0.30494e-06,0.29872e-06,0.29096e-06,0.28230e-06 /)
      kbo(:,49, 1) = (/ &
        & 0.25542e-06,0.24885e-06,0.24314e-06,0.23745e-06,0.23092e-06 /)
      kbo(:,50, 1) = (/ &
        & 0.20741e-06,0.20175e-06,0.19699e-06,0.19305e-06,0.18791e-06 /)
      kbo(:,51, 1) = (/ &
        & 0.16760e-06,0.16406e-06,0.15993e-06,0.15631e-06,0.15327e-06 /)
      kbo(:,52, 1) = (/ &
        & 0.13579e-06,0.13287e-06,0.12985e-06,0.12725e-06,0.12470e-06 /)
      kbo(:,53, 1) = (/ &
        & 0.11006e-06,0.10757e-06,0.10568e-06,0.10314e-06,0.10101e-06 /)
      kbo(:,54, 1) = (/ &
        & 0.88711e-07,0.87131e-07,0.85162e-07,0.83405e-07,0.81585e-07 /)
      kbo(:,55, 1) = (/ &
        & 0.70889e-07,0.69917e-07,0.68692e-07,0.67463e-07,0.66047e-07 /)
      kbo(:,56, 1) = (/ &
        & 0.56659e-07,0.56077e-07,0.55518e-07,0.54462e-07,0.53563e-07 /)
      kbo(:,57, 1) = (/ &
        & 0.45380e-07,0.45159e-07,0.44718e-07,0.44063e-07,0.43116e-07 /)
      kbo(:,58, 1) = (/ &
        & 0.35962e-07,0.36177e-07,0.35997e-07,0.35600e-07,0.34340e-07 /)
      kbo(:,59, 1) = (/ &
        & 0.28578e-07,0.28924e-07,0.28901e-07,0.28176e-07,0.27246e-07 /)
      kbo(:,13, 2) = (/ &
        & 0.63215e-03,0.64756e-03,0.65734e-03,0.66515e-03,0.67077e-03 /)
      kbo(:,14, 2) = (/ &
        & 0.52378e-03,0.53631e-03,0.54485e-03,0.55071e-03,0.55605e-03 /)
      kbo(:,15, 2) = (/ &
        & 0.43777e-03,0.44814e-03,0.45521e-03,0.46124e-03,0.46700e-03 /)
      kbo(:,16, 2) = (/ &
        & 0.37023e-03,0.37869e-03,0.38568e-03,0.39070e-03,0.39760e-03 /)
      kbo(:,17, 2) = (/ &
        & 0.31753e-03,0.32632e-03,0.33254e-03,0.33817e-03,0.34312e-03 /)
      kbo(:,18, 2) = (/ &
        & 0.27580e-03,0.28310e-03,0.28915e-03,0.29488e-03,0.29855e-03 /)
      kbo(:,19, 2) = (/ &
        & 0.24129e-03,0.24697e-03,0.25302e-03,0.25785e-03,0.26137e-03 /)
      kbo(:,20, 2) = (/ &
        & 0.20470e-03,0.21040e-03,0.21552e-03,0.21963e-03,0.22260e-03 /)
      kbo(:,21, 2) = (/ &
        & 0.17290e-03,0.17782e-03,0.18188e-03,0.18513e-03,0.18794e-03 /)
      kbo(:,22, 2) = (/ &
        & 0.14599e-03,0.15063e-03,0.15389e-03,0.15682e-03,0.15965e-03 /)
      kbo(:,23, 2) = (/ &
        & 0.12390e-03,0.12797e-03,0.13071e-03,0.13347e-03,0.13571e-03 /)
      kbo(:,24, 2) = (/ &
        & 0.10553e-03,0.10875e-03,0.11134e-03,0.11351e-03,0.11513e-03 /)
      kbo(:,25, 2) = (/ &
        & 0.90263e-04,0.92560e-04,0.94667e-04,0.96225e-04,0.97041e-04 /)
      kbo(:,26, 2) = (/ &
        & 0.76542e-04,0.78227e-04,0.79755e-04,0.80768e-04,0.81412e-04 /)
      kbo(:,27, 2) = (/ &
        & 0.64562e-04,0.66024e-04,0.67121e-04,0.67878e-04,0.67992e-04 /)
      kbo(:,28, 2) = (/ &
        & 0.54587e-04,0.55668e-04,0.56439e-04,0.56778e-04,0.56649e-04 /)
      kbo(:,29, 2) = (/ &
        & 0.46248e-04,0.46885e-04,0.47469e-04,0.47476e-04,0.47464e-04 /)
      kbo(:,30, 2) = (/ &
        & 0.39084e-04,0.39701e-04,0.39836e-04,0.39919e-04,0.39762e-04 /)
      kbo(:,31, 2) = (/ &
        & 0.33297e-04,0.33670e-04,0.33781e-04,0.33571e-04,0.33418e-04 /)
      kbo(:,32, 2) = (/ &
        & 0.28475e-04,0.28479e-04,0.28352e-04,0.28202e-04,0.28107e-04 /)
      kbo(:,33, 2) = (/ &
        & 0.24023e-04,0.23977e-04,0.23874e-04,0.23858e-04,0.23729e-04 /)
      kbo(:,34, 2) = (/ &
        & 0.20276e-04,0.20314e-04,0.20262e-04,0.20205e-04,0.20013e-04 /)
      kbo(:,35, 2) = (/ &
        & 0.17177e-04,0.17179e-04,0.17181e-04,0.17048e-04,0.16915e-04 /)
      kbo(:,36, 2) = (/ &
        & 0.14586e-04,0.14632e-04,0.14569e-04,0.14465e-04,0.14404e-04 /)
      kbo(:,37, 2) = (/ &
        & 0.12165e-04,0.12220e-04,0.12164e-04,0.12099e-04,0.12036e-04 /)
      kbo(:,38, 2) = (/ &
        & 0.10178e-04,0.10224e-04,0.10201e-04,0.10134e-04,0.10060e-04 /)
      kbo(:,39, 2) = (/ &
        & 0.85622e-05,0.85826e-05,0.85520e-05,0.85109e-05,0.84378e-05 /)
      kbo(:,40, 2) = (/ &
        & 0.70263e-05,0.70549e-05,0.70334e-05,0.70000e-05,0.69500e-05 /)
      kbo(:,41, 2) = (/ &
        & 0.57510e-05,0.57749e-05,0.57692e-05,0.57384e-05,0.57121e-05 /)
      kbo(:,42, 2) = (/ &
        & 0.47038e-05,0.47261e-05,0.47278e-05,0.47023e-05,0.46867e-05 /)
      kbo(:,43, 2) = (/ &
        & 0.38249e-05,0.38339e-05,0.38498e-05,0.38364e-05,0.38125e-05 /)
      kbo(:,44, 2) = (/ &
        & 0.30973e-05,0.31120e-05,0.31166e-05,0.31203e-05,0.31022e-05 /)
      kbo(:,45, 2) = (/ &
        & 0.25085e-05,0.25263e-05,0.25293e-05,0.25328e-05,0.25249e-05 /)
      kbo(:,46, 2) = (/ &
        & 0.20261e-05,0.20479e-05,0.20565e-05,0.20575e-05,0.20588e-05 /)
      kbo(:,47, 2) = (/ &
        & 0.16319e-05,0.16639e-05,0.16745e-05,0.16740e-05,0.16759e-05 /)
      kbo(:,48, 2) = (/ &
        & 0.13097e-05,0.13449e-05,0.13611e-05,0.13624e-05,0.13589e-05 /)
      kbo(:,49, 2) = (/ &
        & 0.10521e-05,0.10847e-05,0.11052e-05,0.11102e-05,0.11085e-05 /)
      kbo(:,50, 2) = (/ &
        & 0.84668e-06,0.87235e-06,0.89544e-06,0.90607e-06,0.90616e-06 /)
      kbo(:,51, 2) = (/ &
        & 0.68060e-06,0.70180e-06,0.72187e-06,0.73562e-06,0.73800e-06 /)
      kbo(:,52, 2) = (/ &
        & 0.54634e-06,0.56481e-06,0.58256e-06,0.59543e-06,0.60122e-06 /)
      kbo(:,53, 2) = (/ &
        & 0.43866e-06,0.45577e-06,0.46957e-06,0.48176e-06,0.48940e-06 /)
      kbo(:,54, 2) = (/ &
        & 0.35062e-06,0.36647e-06,0.37935e-06,0.38978e-06,0.39697e-06 /)
      kbo(:,55, 2) = (/ &
        & 0.27883e-06,0.29514e-06,0.30397e-06,0.31251e-06,0.32004e-06 /)
      kbo(:,56, 2) = (/ &
        & 0.22098e-06,0.23550e-06,0.24289e-06,0.25018e-06,0.25708e-06 /)
      kbo(:,57, 2) = (/ &
        & 0.17295e-06,0.18624e-06,0.19332e-06,0.19934e-06,0.20587e-06 /)
      kbo(:,58, 2) = (/ &
        & 0.13623e-06,0.14680e-06,0.15403e-06,0.15912e-06,0.16499e-06 /)
      kbo(:,59, 2) = (/ &
        & 0.10864e-06,0.11680e-06,0.12353e-06,0.12840e-06,0.13352e-06 /)
      kbo(:,13, 3) = (/ &
        & 0.21069e-02,0.21571e-02,0.21943e-02,0.22061e-02,0.22124e-02 /)
      kbo(:,14, 3) = (/ &
        & 0.17411e-02,0.17833e-02,0.18097e-02,0.18225e-02,0.18251e-02 /)
      kbo(:,15, 3) = (/ &
        & 0.14440e-02,0.14790e-02,0.14963e-02,0.15066e-02,0.15066e-02 /)
      kbo(:,16, 3) = (/ &
        & 0.11998e-02,0.12261e-02,0.12398e-02,0.12500e-02,0.12487e-02 /)
      kbo(:,17, 3) = (/ &
        & 0.99980e-03,0.10202e-02,0.10332e-02,0.10399e-02,0.10392e-02 /)
      kbo(:,18, 3) = (/ &
        & 0.83805e-03,0.85629e-03,0.86827e-03,0.87303e-03,0.87540e-03 /)
      kbo(:,19, 3) = (/ &
        & 0.70743e-03,0.72381e-03,0.73251e-03,0.73550e-03,0.73931e-03 /)
      kbo(:,20, 3) = (/ &
        & 0.59348e-03,0.60572e-03,0.61137e-03,0.61496e-03,0.61761e-03 /)
      kbo(:,21, 3) = (/ &
        & 0.49556e-03,0.50488e-03,0.50987e-03,0.51421e-03,0.51581e-03 /)
      kbo(:,22, 3) = (/ &
        & 0.41461e-03,0.42145e-03,0.42584e-03,0.42969e-03,0.43055e-03 /)
      kbo(:,23, 3) = (/ &
        & 0.34683e-03,0.35181e-03,0.35660e-03,0.35911e-03,0.35958e-03 /)
      kbo(:,24, 3) = (/ &
        & 0.29004e-03,0.29383e-03,0.29787e-03,0.29964e-03,0.30042e-03 /)
      kbo(:,25, 3) = (/ &
        & 0.24146e-03,0.24561e-03,0.24879e-03,0.25053e-03,0.25134e-03 /)
      kbo(:,26, 3) = (/ &
        & 0.20160e-03,0.20537e-03,0.20774e-03,0.20928e-03,0.21023e-03 /)
      kbo(:,27, 3) = (/ &
        & 0.16916e-03,0.17226e-03,0.17386e-03,0.17529e-03,0.17634e-03 /)
      kbo(:,28, 3) = (/ &
        & 0.14183e-03,0.14414e-03,0.14604e-03,0.14741e-03,0.14844e-03 /)
      kbo(:,29, 3) = (/ &
        & 0.11954e-03,0.12161e-03,0.12286e-03,0.12386e-03,0.12448e-03 /)
      kbo(:,30, 3) = (/ &
        & 0.10067e-03,0.10205e-03,0.10331e-03,0.10409e-03,0.10476e-03 /)
      kbo(:,31, 3) = (/ &
        & 0.85014e-04,0.86248e-04,0.87024e-04,0.87958e-04,0.88579e-04 /)
      kbo(:,32, 3) = (/ &
        & 0.71930e-04,0.73074e-04,0.73985e-04,0.74934e-04,0.74848e-04 /)
      kbo(:,33, 3) = (/ &
        & 0.61205e-04,0.62259e-04,0.63209e-04,0.63383e-04,0.63466e-04 /)
      kbo(:,34, 3) = (/ &
        & 0.52046e-04,0.52896e-04,0.53420e-04,0.53516e-04,0.53755e-04 /)
      kbo(:,35, 3) = (/ &
        & 0.44380e-04,0.45121e-04,0.45277e-04,0.45604e-04,0.45761e-04 /)
      kbo(:,36, 3) = (/ &
        & 0.38058e-04,0.38409e-04,0.38657e-04,0.38813e-04,0.38628e-04 /)
      kbo(:,37, 3) = (/ &
        & 0.31735e-04,0.31990e-04,0.32199e-04,0.32288e-04,0.32179e-04 /)
      kbo(:,38, 3) = (/ &
        & 0.26378e-04,0.26667e-04,0.26778e-04,0.26840e-04,0.26760e-04 /)
      kbo(:,39, 3) = (/ &
        & 0.21949e-04,0.22195e-04,0.22340e-04,0.22330e-04,0.22281e-04 /)
      kbo(:,40, 3) = (/ &
        & 0.18001e-04,0.18209e-04,0.18338e-04,0.18376e-04,0.18309e-04 /)
      kbo(:,41, 3) = (/ &
        & 0.14715e-04,0.14906e-04,0.15025e-04,0.15098e-04,0.15026e-04 /)
      kbo(:,42, 3) = (/ &
        & 0.12019e-04,0.12197e-04,0.12312e-04,0.12380e-04,0.12346e-04 /)
      kbo(:,43, 3) = (/ &
        & 0.97566e-05,0.99318e-05,0.10036e-04,0.10096e-04,0.10118e-04 /)
      kbo(:,44, 3) = (/ &
        & 0.78810e-05,0.80716e-05,0.81637e-05,0.82202e-05,0.82608e-05 /)
      kbo(:,45, 3) = (/ &
        & 0.63541e-05,0.65171e-05,0.66330e-05,0.66977e-05,0.67239e-05 /)
      kbo(:,46, 3) = (/ &
        & 0.51077e-05,0.52428e-05,0.53636e-05,0.54363e-05,0.54693e-05 /)
      kbo(:,47, 3) = (/ &
        & 0.40883e-05,0.42196e-05,0.43199e-05,0.44074e-05,0.44462e-05 /)
      kbo(:,48, 3) = (/ &
        & 0.32909e-05,0.33941e-05,0.34746e-05,0.35546e-05,0.36089e-05 /)
      kbo(:,49, 3) = (/ &
        & 0.26401e-05,0.27269e-05,0.28003e-05,0.28616e-05,0.29188e-05 /)
      kbo(:,50, 3) = (/ &
        & 0.21222e-05,0.22032e-05,0.22638e-05,0.23127e-05,0.23603e-05 /)
      kbo(:,51, 3) = (/ &
        & 0.17056e-05,0.17838e-05,0.18386e-05,0.18804e-05,0.19134e-05 /)
      kbo(:,52, 3) = (/ &
        & 0.13662e-05,0.14333e-05,0.14855e-05,0.15238e-05,0.15521e-05 /)
      kbo(:,53, 3) = (/ &
        & 0.10889e-05,0.11445e-05,0.11955e-05,0.12300e-05,0.12560e-05 /)
      kbo(:,54, 3) = (/ &
        & 0.86251e-06,0.91556e-06,0.95999e-06,0.99454e-06,0.10171e-05 /)
      kbo(:,55, 3) = (/ &
        & 0.68640e-06,0.72868e-06,0.77389e-06,0.80627e-06,0.82696e-06 /)
      kbo(:,56, 3) = (/ &
        & 0.54334e-06,0.58339e-06,0.61953e-06,0.65190e-06,0.67285e-06 /)
      kbo(:,57, 3) = (/ &
        & 0.43336e-06,0.46511e-06,0.49561e-06,0.52337e-06,0.54491e-06 /)
      kbo(:,58, 3) = (/ &
        & 0.34428e-06,0.37236e-06,0.39687e-06,0.42017e-06,0.43790e-06 /)
      kbo(:,59, 3) = (/ &
        & 0.27883e-06,0.30237e-06,0.32096e-06,0.33978e-06,0.35485e-06 /)
      kbo(:,13, 4) = (/ &
        & 0.52806e-02,0.53551e-02,0.53836e-02,0.53810e-02,0.53413e-02 /)
      kbo(:,14, 4) = (/ &
        & 0.43594e-02,0.44114e-02,0.44268e-02,0.44183e-02,0.43877e-02 /)
      kbo(:,15, 4) = (/ &
        & 0.36080e-02,0.36421e-02,0.36603e-02,0.36540e-02,0.36307e-02 /)
      kbo(:,16, 4) = (/ &
        & 0.30007e-02,0.30324e-02,0.30479e-02,0.30377e-02,0.30175e-02 /)
      kbo(:,17, 4) = (/ &
        & 0.25113e-02,0.25415e-02,0.25489e-02,0.25428e-02,0.25281e-02 /)
      kbo(:,18, 4) = (/ &
        & 0.21119e-02,0.21340e-02,0.21396e-02,0.21381e-02,0.21232e-02 /)
      kbo(:,19, 4) = (/ &
        & 0.17705e-02,0.17884e-02,0.17942e-02,0.17931e-02,0.17819e-02 /)
      kbo(:,20, 4) = (/ &
        & 0.14714e-02,0.14854e-02,0.14921e-02,0.14920e-02,0.14874e-02 /)
      kbo(:,21, 4) = (/ &
        & 0.12224e-02,0.12349e-02,0.12432e-02,0.12411e-02,0.12395e-02 /)
      kbo(:,22, 4) = (/ &
        & 0.10170e-02,0.10281e-02,0.10319e-02,0.10310e-02,0.10286e-02 /)
      kbo(:,23, 4) = (/ &
        & 0.84681e-03,0.85484e-03,0.85517e-03,0.85545e-03,0.85571e-03 /)
      kbo(:,24, 4) = (/ &
        & 0.70330e-03,0.70875e-03,0.71078e-03,0.71261e-03,0.71112e-03 /)
      kbo(:,25, 4) = (/ &
        & 0.58481e-03,0.58870e-03,0.59157e-03,0.59305e-03,0.59234e-03 /)
      kbo(:,26, 4) = (/ &
        & 0.48640e-03,0.49044e-03,0.49395e-03,0.49468e-03,0.49466e-03 /)
      kbo(:,27, 4) = (/ &
        & 0.40472e-03,0.40915e-03,0.41235e-03,0.41278e-03,0.41345e-03 /)
      kbo(:,28, 4) = (/ &
        & 0.33826e-03,0.34205e-03,0.34364e-03,0.34480e-03,0.34528e-03 /)
      kbo(:,29, 4) = (/ &
        & 0.28308e-03,0.28627e-03,0.28792e-03,0.28910e-03,0.28958e-03 /)
      kbo(:,30, 4) = (/ &
        & 0.23759e-03,0.23994e-03,0.24196e-03,0.24295e-03,0.24270e-03 /)
      kbo(:,31, 4) = (/ &
        & 0.19993e-03,0.20202e-03,0.20390e-03,0.20456e-03,0.20411e-03 /)
      kbo(:,32, 4) = (/ &
        & 0.16851e-03,0.17060e-03,0.17151e-03,0.17169e-03,0.17133e-03 /)
      kbo(:,33, 4) = (/ &
        & 0.14275e-03,0.14392e-03,0.14445e-03,0.14452e-03,0.14399e-03 /)
      kbo(:,34, 4) = (/ &
        & 0.12060e-03,0.12142e-03,0.12181e-03,0.12165e-03,0.12105e-03 /)
      kbo(:,35, 4) = (/ &
        & 0.10168e-03,0.10240e-03,0.10276e-03,0.10261e-03,0.10202e-03 /)
      kbo(:,36, 4) = (/ &
        & 0.85780e-04,0.86636e-04,0.86815e-04,0.86780e-04,0.86722e-04 /)
      kbo(:,37, 4) = (/ &
        & 0.71540e-04,0.72201e-04,0.72422e-04,0.72501e-04,0.72398e-04 /)
      kbo(:,38, 4) = (/ &
        & 0.59609e-04,0.60152e-04,0.60443e-04,0.60540e-04,0.60534e-04 /)
      kbo(:,39, 4) = (/ &
        & 0.49681e-04,0.50194e-04,0.50481e-04,0.50649e-04,0.50643e-04 /)
      kbo(:,40, 4) = (/ &
        & 0.40815e-04,0.41335e-04,0.41565e-04,0.41729e-04,0.41776e-04 /)
      kbo(:,41, 4) = (/ &
        & 0.33476e-04,0.33932e-04,0.34171e-04,0.34301e-04,0.34397e-04 /)
      kbo(:,42, 4) = (/ &
        & 0.27419e-04,0.27824e-04,0.28083e-04,0.28221e-04,0.28296e-04 /)
      kbo(:,43, 4) = (/ &
        & 0.22349e-04,0.22753e-04,0.22975e-04,0.23100e-04,0.23164e-04 /)
      kbo(:,44, 4) = (/ &
        & 0.18197e-04,0.18488e-04,0.18747e-04,0.18878e-04,0.18943e-04 /)
      kbo(:,45, 4) = (/ &
        & 0.14815e-04,0.15081e-04,0.15284e-04,0.15408e-04,0.15493e-04 /)
      kbo(:,46, 4) = (/ &
        & 0.12046e-04,0.12304e-04,0.12476e-04,0.12590e-04,0.12654e-04 /)
      kbo(:,47, 4) = (/ &
        & 0.97834e-05,0.10018e-04,0.10187e-04,0.10295e-04,0.10365e-04 /)
      kbo(:,48, 4) = (/ &
        & 0.79058e-05,0.81583e-05,0.83158e-05,0.84259e-05,0.84791e-05 /)
      kbo(:,49, 4) = (/ &
        & 0.63847e-05,0.66212e-05,0.67735e-05,0.68818e-05,0.69382e-05 /)
      kbo(:,50, 4) = (/ &
        & 0.51619e-05,0.53698e-05,0.55239e-05,0.56230e-05,0.56931e-05 /)
      kbo(:,51, 4) = (/ &
        & 0.41764e-05,0.43546e-05,0.45018e-05,0.45927e-05,0.46609e-05 /)
      kbo(:,52, 4) = (/ &
        & 0.33696e-05,0.35302e-05,0.36585e-05,0.37548e-05,0.38091e-05 /)
      kbo(:,53, 4) = (/ &
        & 0.27142e-05,0.28585e-05,0.29700e-05,0.30632e-05,0.31163e-05 /)
      kbo(:,54, 4) = (/ &
        & 0.21974e-05,0.23176e-05,0.24169e-05,0.24980e-05,0.25555e-05 /)
      kbo(:,55, 4) = (/ &
        & 0.17820e-05,0.18827e-05,0.19647e-05,0.20347e-05,0.20895e-05 /)
      kbo(:,56, 4) = (/ &
        & 0.14445e-05,0.15274e-05,0.15999e-05,0.16558e-05,0.17004e-05 /)
      kbo(:,57, 4) = (/ &
        & 0.11612e-05,0.12390e-05,0.13020e-05,0.13508e-05,0.13881e-05 /)
      kbo(:,58, 4) = (/ &
        & 0.93606e-06,0.10017e-05,0.10598e-05,0.11016e-05,0.11367e-05 /)
      kbo(:,59, 4) = (/ &
        & 0.76682e-06,0.82318e-06,0.87281e-06,0.91208e-06,0.94037e-06 /)
      kbo(:,13, 5) = (/ &
        & 0.12856e-01,0.13079e-01,0.13167e-01,0.13177e-01,0.13097e-01 /)
      kbo(:,14, 5) = (/ &
        & 0.10708e-01,0.10853e-01,0.10911e-01,0.10898e-01,0.10814e-01 /)
      kbo(:,15, 5) = (/ &
        & 0.88690e-02,0.89759e-02,0.90116e-02,0.89730e-02,0.88895e-02 /)
      kbo(:,16, 5) = (/ &
        & 0.73377e-02,0.74116e-02,0.74224e-02,0.73845e-02,0.73097e-02 /)
      kbo(:,17, 5) = (/ &
        & 0.61050e-02,0.61465e-02,0.61522e-02,0.61190e-02,0.60607e-02 /)
      kbo(:,18, 5) = (/ &
        & 0.51170e-02,0.51524e-02,0.51567e-02,0.51299e-02,0.50853e-02 /)
      kbo(:,19, 5) = (/ &
        & 0.42872e-02,0.43210e-02,0.43249e-02,0.43090e-02,0.42772e-02 /)
      kbo(:,20, 5) = (/ &
        & 0.35726e-02,0.35987e-02,0.36030e-02,0.35888e-02,0.35606e-02 /)
      kbo(:,21, 5) = (/ &
        & 0.29687e-02,0.29865e-02,0.29887e-02,0.29805e-02,0.29536e-02 /)
      kbo(:,22, 5) = (/ &
        & 0.24631e-02,0.24766e-02,0.24818e-02,0.24706e-02,0.24511e-02 /)
      kbo(:,23, 5) = (/ &
        & 0.20423e-02,0.20574e-02,0.20622e-02,0.20550e-02,0.20390e-02 /)
      kbo(:,24, 5) = (/ &
        & 0.17009e-02,0.17137e-02,0.17151e-02,0.17066e-02,0.16944e-02 /)
      kbo(:,25, 5) = (/ &
        & 0.14175e-02,0.14281e-02,0.14264e-02,0.14202e-02,0.14101e-02 /)
      kbo(:,26, 5) = (/ &
        & 0.11824e-02,0.11879e-02,0.11852e-02,0.11799e-02,0.11727e-02 /)
      kbo(:,27, 5) = (/ &
        & 0.98538e-03,0.98799e-03,0.98648e-03,0.98258e-03,0.97798e-03 /)
      kbo(:,28, 5) = (/ &
        & 0.82156e-03,0.82317e-03,0.82299e-03,0.82154e-03,0.81913e-03 /)
      kbo(:,29, 5) = (/ &
        & 0.68689e-03,0.68935e-03,0.68992e-03,0.69010e-03,0.68854e-03 /)
      kbo(:,30, 5) = (/ &
        & 0.57658e-03,0.57999e-03,0.58178e-03,0.58209e-03,0.58220e-03 /)
      kbo(:,31, 5) = (/ &
        & 0.48638e-03,0.49049e-03,0.49261e-03,0.49405e-03,0.49565e-03 /)
      kbo(:,32, 5) = (/ &
        & 0.41128e-03,0.41527e-03,0.41847e-03,0.42111e-03,0.42278e-03 /)
      kbo(:,33, 5) = (/ &
        & 0.34942e-03,0.35347e-03,0.35669e-03,0.35970e-03,0.36033e-03 /)
      kbo(:,34, 5) = (/ &
        & 0.29778e-03,0.30183e-03,0.30543e-03,0.30722e-03,0.30756e-03 /)
      kbo(:,35, 5) = (/ &
        & 0.25439e-03,0.25855e-03,0.26145e-03,0.26279e-03,0.26328e-03 /)
      kbo(:,36, 5) = (/ &
        & 0.21688e-03,0.22055e-03,0.22366e-03,0.22472e-03,0.22545e-03 /)
      kbo(:,37, 5) = (/ &
        & 0.18184e-03,0.18525e-03,0.18789e-03,0.18888e-03,0.18981e-03 /)
      kbo(:,38, 5) = (/ &
        & 0.15217e-03,0.15529e-03,0.15752e-03,0.15878e-03,0.15947e-03 /)
      kbo(:,39, 5) = (/ &
        & 0.12738e-03,0.13010e-03,0.13202e-03,0.13325e-03,0.13405e-03 /)
      kbo(:,40, 5) = (/ &
        & 0.10533e-03,0.10771e-03,0.10944e-03,0.11063e-03,0.11132e-03 /)
      kbo(:,41, 5) = (/ &
        & 0.86935e-04,0.89079e-04,0.90576e-04,0.91599e-04,0.92136e-04 /)
      kbo(:,42, 5) = (/ &
        & 0.71757e-04,0.73600e-04,0.74913e-04,0.75823e-04,0.76332e-04 /)
      kbo(:,43, 5) = (/ &
        & 0.58933e-04,0.60448e-04,0.61689e-04,0.62502e-04,0.62968e-04 /)
      kbo(:,44, 5) = (/ &
        & 0.48240e-04,0.49626e-04,0.50671e-04,0.51353e-04,0.51808e-04 /)
      kbo(:,45, 5) = (/ &
        & 0.39365e-04,0.40603e-04,0.41556e-04,0.42201e-04,0.42661e-04 /)
      kbo(:,46, 5) = (/ &
        & 0.32140e-04,0.33199e-04,0.34102e-04,0.34681e-04,0.35122e-04 /)
      kbo(:,47, 5) = (/ &
        & 0.26212e-04,0.27122e-04,0.27914e-04,0.28482e-04,0.28883e-04 /)
      kbo(:,48, 5) = (/ &
        & 0.21367e-04,0.22132e-04,0.22808e-04,0.23366e-04,0.23750e-04 /)
      kbo(:,49, 5) = (/ &
        & 0.17366e-04,0.18036e-04,0.18610e-04,0.19128e-04,0.19501e-04 /)
      kbo(:,50, 5) = (/ &
        & 0.14166e-04,0.14744e-04,0.15227e-04,0.15695e-04,0.16033e-04 /)
      kbo(:,51, 5) = (/ &
        & 0.11520e-04,0.12036e-04,0.12466e-04,0.12850e-04,0.13177e-04 /)
      kbo(:,52, 5) = (/ &
        & 0.93545e-05,0.97967e-05,0.10185e-04,0.10504e-04,0.10808e-04 /)
      kbo(:,53, 5) = (/ &
        & 0.75900e-05,0.79775e-05,0.83066e-05,0.85876e-05,0.88446e-05 /)
      kbo(:,54, 5) = (/ &
        & 0.61841e-05,0.65213e-05,0.67983e-05,0.70299e-05,0.72479e-05 /)
      kbo(:,55, 5) = (/ &
        & 0.50267e-05,0.53142e-05,0.55644e-05,0.57696e-05,0.59449e-05 /)
      kbo(:,56, 5) = (/ &
        & 0.40664e-05,0.43169e-05,0.45344e-05,0.47274e-05,0.48783e-05 /)
      kbo(:,57, 5) = (/ &
        & 0.32881e-05,0.34993e-05,0.36900e-05,0.38580e-05,0.39983e-05 /)
      kbo(:,58, 5) = (/ &
        & 0.26562e-05,0.28386e-05,0.30033e-05,0.31435e-05,0.32655e-05 /)
      kbo(:,59, 5) = (/ &
        & 0.21842e-05,0.23355e-05,0.24742e-05,0.25918e-05,0.26979e-05 /)
      kbo(:,13, 6) = (/ &
        & 0.31802e-01,0.32385e-01,0.32761e-01,0.32924e-01,0.32887e-01 /)
      kbo(:,14, 6) = (/ &
        & 0.27075e-01,0.27526e-01,0.27777e-01,0.27825e-01,0.27714e-01 /)
      kbo(:,15, 6) = (/ &
        & 0.22867e-01,0.23213e-01,0.23346e-01,0.23326e-01,0.23192e-01 /)
      kbo(:,16, 6) = (/ &
        & 0.19243e-01,0.19469e-01,0.19534e-01,0.19508e-01,0.19374e-01 /)
      kbo(:,17, 6) = (/ &
        & 0.16143e-01,0.16291e-01,0.16340e-01,0.16286e-01,0.16140e-01 /)
      kbo(:,18, 6) = (/ &
        & 0.13508e-01,0.13619e-01,0.13632e-01,0.13563e-01,0.13444e-01 /)
      kbo(:,19, 6) = (/ &
        & 0.11360e-01,0.11423e-01,0.11418e-01,0.11354e-01,0.11254e-01 /)
      kbo(:,20, 6) = (/ &
        & 0.95257e-02,0.95677e-02,0.95569e-02,0.94993e-02,0.94147e-02 /)
      kbo(:,21, 6) = (/ &
        & 0.79688e-02,0.80079e-02,0.79930e-02,0.79576e-02,0.78976e-02 /)
      kbo(:,22, 6) = (/ &
        & 0.66527e-02,0.66824e-02,0.66717e-02,0.66442e-02,0.65988e-02 /)
      kbo(:,23, 6) = (/ &
        & 0.55583e-02,0.55741e-02,0.55685e-02,0.55458e-02,0.55136e-02 /)
      kbo(:,24, 6) = (/ &
        & 0.46281e-02,0.46404e-02,0.46354e-02,0.46240e-02,0.46070e-02 /)
      kbo(:,25, 6) = (/ &
        & 0.38479e-02,0.38586e-02,0.38647e-02,0.38587e-02,0.38482e-02 /)
      kbo(:,26, 6) = (/ &
        & 0.31996e-02,0.32113e-02,0.32185e-02,0.32206e-02,0.32221e-02 /)
      kbo(:,27, 6) = (/ &
        & 0.26655e-02,0.26804e-02,0.26909e-02,0.27001e-02,0.27000e-02 /)
      kbo(:,28, 6) = (/ &
        & 0.22269e-02,0.22430e-02,0.22546e-02,0.22636e-02,0.22685e-02 /)
      kbo(:,29, 6) = (/ &
        & 0.18711e-02,0.18853e-02,0.19010e-02,0.19079e-02,0.19146e-02 /)
      kbo(:,30, 6) = (/ &
        & 0.15792e-02,0.15950e-02,0.16049e-02,0.16149e-02,0.16250e-02 /)
      kbo(:,31, 6) = (/ &
        & 0.13390e-02,0.13523e-02,0.13631e-02,0.13762e-02,0.13899e-02 /)
      kbo(:,32, 6) = (/ &
        & 0.11423e-02,0.11552e-02,0.11689e-02,0.11828e-02,0.12002e-02 /)
      kbo(:,33, 6) = (/ &
        & 0.97837e-03,0.99414e-03,0.10078e-02,0.10254e-02,0.10445e-02 /)
      kbo(:,34, 6) = (/ &
        & 0.84508e-03,0.85961e-03,0.87553e-03,0.89474e-03,0.91454e-03 /)
      kbo(:,35, 6) = (/ &
        & 0.73067e-03,0.74643e-03,0.76522e-03,0.78433e-03,0.80547e-03 /)
      kbo(:,36, 6) = (/ &
        & 0.63501e-03,0.65286e-03,0.67124e-03,0.69177e-03,0.71245e-03 /)
      kbo(:,37, 6) = (/ &
        & 0.54302e-03,0.56011e-03,0.57838e-03,0.59932e-03,0.61930e-03 /)
      kbo(:,38, 6) = (/ &
        & 0.46413e-03,0.48141e-03,0.49888e-03,0.51888e-03,0.53851e-03 /)
      kbo(:,39, 6) = (/ &
        & 0.39787e-03,0.41416e-03,0.43137e-03,0.45076e-03,0.46884e-03 /)
      kbo(:,40, 6) = (/ &
        & 0.33542e-03,0.35026e-03,0.36640e-03,0.38421e-03,0.40074e-03 /)
      kbo(:,41, 6) = (/ &
        & 0.28198e-03,0.29533e-03,0.31033e-03,0.32658e-03,0.34246e-03 /)
      kbo(:,42, 6) = (/ &
        & 0.23644e-03,0.24877e-03,0.26248e-03,0.27695e-03,0.29184e-03 /)
      kbo(:,43, 6) = (/ &
        & 0.19698e-03,0.20826e-03,0.22042e-03,0.23357e-03,0.24697e-03 /)
      kbo(:,44, 6) = (/ &
        & 0.16338e-03,0.17334e-03,0.18409e-03,0.19557e-03,0.20792e-03 /)
      kbo(:,45, 6) = (/ &
        & 0.13558e-03,0.14397e-03,0.15333e-03,0.16359e-03,0.17463e-03 /)
      kbo(:,46, 6) = (/ &
        & 0.11191e-03,0.11919e-03,0.12729e-03,0.13624e-03,0.14629e-03 /)
      kbo(:,47, 6) = (/ &
        & 0.91906e-04,0.98189e-04,0.10520e-03,0.11302e-03,0.12177e-03 /)
      kbo(:,48, 6) = (/ &
        & 0.75087e-04,0.80743e-04,0.86708e-04,0.93427e-04,0.10110e-03 /)
      kbo(:,49, 6) = (/ &
        & 0.61186e-04,0.66125e-04,0.71313e-04,0.77107e-04,0.83777e-04 /)
      kbo(:,50, 6) = (/ &
        & 0.49938e-04,0.54303e-04,0.58807e-04,0.63705e-04,0.69474e-04 /)
      kbo(:,51, 6) = (/ &
        & 0.40809e-04,0.44513e-04,0.48369e-04,0.52594e-04,0.57525e-04 /)
      kbo(:,52, 6) = (/ &
        & 0.33309e-04,0.36401e-04,0.39694e-04,0.43295e-04,0.47517e-04 /)
      kbo(:,53, 6) = (/ &
        & 0.27001e-04,0.29637e-04,0.32443e-04,0.35515e-04,0.39073e-04 /)
      kbo(:,54, 6) = (/ &
        & 0.21920e-04,0.24176e-04,0.26587e-04,0.29204e-04,0.32173e-04 /)
      kbo(:,55, 6) = (/ &
        & 0.17840e-04,0.19707e-04,0.21784e-04,0.24000e-04,0.26498e-04 /)
      kbo(:,56, 6) = (/ &
        & 0.14500e-04,0.16042e-04,0.17779e-04,0.19655e-04,0.21743e-04 /)
      kbo(:,57, 6) = (/ &
        & 0.11756e-04,0.13018e-04,0.14458e-04,0.16053e-04,0.17779e-04 /)
      kbo(:,58, 6) = (/ &
        & 0.95229e-05,0.10574e-04,0.11760e-04,0.13107e-04,0.14585e-04 /)
      kbo(:,59, 6) = (/ &
        & 0.78970e-05,0.87821e-05,0.97860e-05,0.10919e-04,0.12187e-04 /)
      kbo(:,13, 7) = (/ &
        & 0.81347e-01,0.83688e-01,0.85307e-01,0.86283e-01,0.87010e-01 /)
      kbo(:,14, 7) = (/ &
        & 0.72041e-01,0.73994e-01,0.75287e-01,0.76180e-01,0.76714e-01 /)
      kbo(:,15, 7) = (/ &
        & 0.63278e-01,0.64818e-01,0.65954e-01,0.66651e-01,0.67143e-01 /)
      kbo(:,16, 7) = (/ &
        & 0.55139e-01,0.56478e-01,0.57384e-01,0.58076e-01,0.58539e-01 /)
      kbo(:,17, 7) = (/ &
        & 0.47894e-01,0.48966e-01,0.49829e-01,0.50447e-01,0.50916e-01 /)
      kbo(:,18, 7) = (/ &
        & 0.41499e-01,0.42507e-01,0.43240e-01,0.43755e-01,0.44135e-01 /)
      kbo(:,19, 7) = (/ &
        & 0.35885e-01,0.36754e-01,0.37403e-01,0.37954e-01,0.38313e-01 /)
      kbo(:,20, 7) = (/ &
        & 0.30699e-01,0.31463e-01,0.32108e-01,0.32586e-01,0.32972e-01 /)
      kbo(:,21, 7) = (/ &
        & 0.26192e-01,0.26846e-01,0.27409e-01,0.27839e-01,0.28217e-01 /)
      kbo(:,22, 7) = (/ &
        & 0.22340e-01,0.22929e-01,0.23404e-01,0.23811e-01,0.24187e-01 /)
      kbo(:,23, 7) = (/ &
        & 0.19095e-01,0.19575e-01,0.20007e-01,0.20410e-01,0.20766e-01 /)
      kbo(:,24, 7) = (/ &
        & 0.16366e-01,0.16771e-01,0.17186e-01,0.17542e-01,0.17949e-01 /)
      kbo(:,25, 7) = (/ &
        & 0.14069e-01,0.14481e-01,0.14832e-01,0.15200e-01,0.15580e-01 /)
      kbo(:,26, 7) = (/ &
        & 0.12162e-01,0.12539e-01,0.12888e-01,0.13247e-01,0.13615e-01 /)
      kbo(:,27, 7) = (/ &
        & 0.10528e-01,0.10892e-01,0.11265e-01,0.11631e-01,0.12012e-01 /)
      kbo(:,28, 7) = (/ &
        & 0.91441e-02,0.95086e-02,0.98896e-02,0.10282e-01,0.10687e-01 /)
      kbo(:,29, 7) = (/ &
        & 0.79938e-02,0.83641e-02,0.87511e-02,0.91674e-02,0.96121e-02 /)
      kbo(:,30, 7) = (/ &
        & 0.70400e-02,0.74172e-02,0.78125e-02,0.82611e-02,0.87532e-02 /)
      kbo(:,31, 7) = (/ &
        & 0.62612e-02,0.66491e-02,0.70836e-02,0.75546e-02,0.80730e-02 /)
      kbo(:,32, 7) = (/ &
        & 0.56090e-02,0.60373e-02,0.65021e-02,0.70140e-02,0.75729e-02 /)
      kbo(:,33, 7) = (/ &
        & 0.51011e-02,0.55473e-02,0.60429e-02,0.66026e-02,0.72780e-02 /)
      kbo(:,34, 7) = (/ &
        & 0.46990e-02,0.51673e-02,0.57072e-02,0.63464e-02,0.71159e-02 /)
      kbo(:,35, 7) = (/ &
        & 0.43314e-02,0.48384e-02,0.54243e-02,0.61639e-02,0.69924e-02 /)
      kbo(:,36, 7) = (/ &
        & 0.39886e-02,0.45262e-02,0.51941e-02,0.59985e-02,0.68708e-02 /)
      kbo(:,37, 7) = (/ &
        & 0.36017e-02,0.41399e-02,0.48219e-02,0.56481e-02,0.65560e-02 /)
      kbo(:,38, 7) = (/ &
        & 0.32617e-02,0.38037e-02,0.45057e-02,0.53485e-02,0.62708e-02 /)
      kbo(:,39, 7) = (/ &
        & 0.29777e-02,0.35364e-02,0.42387e-02,0.50890e-02,0.60544e-02 /)
      kbo(:,40, 7) = (/ &
        & 0.26397e-02,0.31715e-02,0.38573e-02,0.46880e-02,0.56335e-02 /)
      kbo(:,41, 7) = (/ &
        & 0.23227e-02,0.28385e-02,0.34927e-02,0.42880e-02,0.52154e-02 /)
      kbo(:,42, 7) = (/ &
        & 0.20486e-02,0.25378e-02,0.31647e-02,0.39312e-02,0.48261e-02 /)
      kbo(:,43, 7) = (/ &
        & 0.17755e-02,0.22226e-02,0.28140e-02,0.35274e-02,0.43895e-02 /)
      kbo(:,44, 7) = (/ &
        & 0.15269e-02,0.19274e-02,0.24688e-02,0.31407e-02,0.39517e-02 /)
      kbo(:,45, 7) = (/ &
        & 0.13050e-02,0.16697e-02,0.21647e-02,0.27916e-02,0.35423e-02 /)
      kbo(:,46, 7) = (/ &
        & 0.11057e-02,0.14327e-02,0.18777e-02,0.24513e-02,0.31448e-02 /)
      kbo(:,47, 7) = (/ &
        & 0.92448e-03,0.12134e-02,0.16064e-02,0.21237e-02,0.27575e-02 /)
      kbo(:,48, 7) = (/ &
        & 0.76618e-03,0.10179e-02,0.13627e-02,0.18254e-02,0.24067e-02 /)
      kbo(:,49, 7) = (/ &
        & 0.62940e-03,0.85036e-03,0.11489e-02,0.15623e-02,0.20896e-02 /)
      kbo(:,50, 7) = (/ &
        & 0.51855e-03,0.71067e-03,0.97602e-03,0.13414e-02,0.18179e-02 /)
      kbo(:,51, 7) = (/ &
        & 0.42590e-03,0.59305e-03,0.82548e-03,0.11486e-02,0.15798e-02 /)
      kbo(:,52, 7) = (/ &
        & 0.34697e-03,0.49059e-03,0.69535e-03,0.97532e-03,0.13630e-02 /)
      kbo(:,53, 7) = (/ &
        & 0.28092e-03,0.40191e-03,0.57931e-03,0.82673e-03,0.11685e-02 /)
      kbo(:,54, 7) = (/ &
        & 0.22883e-03,0.33102e-03,0.48584e-03,0.70577e-03,0.10069e-02 /)
      kbo(:,55, 7) = (/ &
        & 0.18567e-03,0.27212e-03,0.40629e-03,0.59966e-03,0.86643e-03 /)
      kbo(:,56, 7) = (/ &
        & 0.14981e-03,0.22158e-03,0.33702e-03,0.50672e-03,0.74022e-03 /)
      kbo(:,57, 7) = (/ &
        & 0.11956e-03,0.17899e-03,0.27717e-03,0.42406e-03,0.63003e-03 /)
      kbo(:,58, 7) = (/ &
        & 0.95581e-04,0.14413e-03,0.22637e-03,0.35457e-03,0.53700e-03 /)
      kbo(:,59, 7) = (/ &
        & 0.81967e-04,0.12578e-03,0.20146e-03,0.32061e-03,0.49099e-03 /)
      kbo(:,13, 8) = (/ &
        & 0.22107e+00,0.22673e+00,0.23188e+00,0.23626e+00,0.23937e+00 /)
      kbo(:,14, 8) = (/ &
        & 0.20348e+00,0.20983e+00,0.21521e+00,0.21960e+00,0.22328e+00 /)
      kbo(:,15, 8) = (/ &
        & 0.18724e+00,0.19358e+00,0.19903e+00,0.20382e+00,0.20780e+00 /)
      kbo(:,16, 8) = (/ &
        & 0.17271e+00,0.17902e+00,0.18466e+00,0.18949e+00,0.19358e+00 /)
      kbo(:,17, 8) = (/ &
        & 0.15881e+00,0.16550e+00,0.17139e+00,0.17656e+00,0.18127e+00 /)
      kbo(:,18, 8) = (/ &
        & 0.14632e+00,0.15311e+00,0.15937e+00,0.16532e+00,0.17049e+00 /)
      kbo(:,19, 8) = (/ &
        & 0.13481e+00,0.14215e+00,0.14899e+00,0.15502e+00,0.16068e+00 /)
      kbo(:,20, 8) = (/ &
        & 0.12437e+00,0.13191e+00,0.13890e+00,0.14560e+00,0.15188e+00 /)
      kbo(:,21, 8) = (/ &
        & 0.11481e+00,0.12252e+00,0.12982e+00,0.13710e+00,0.14374e+00 /)
      kbo(:,22, 8) = (/ &
        & 0.10661e+00,0.11453e+00,0.12244e+00,0.12996e+00,0.13720e+00 /)
      kbo(:,23, 8) = (/ &
        & 0.99573e-01,0.10782e+00,0.11598e+00,0.12384e+00,0.13154e+00 /)
      kbo(:,24, 8) = (/ &
        & 0.93585e-01,0.10212e+00,0.11044e+00,0.11870e+00,0.12683e+00 /)
      kbo(:,25, 8) = (/ &
        & 0.88642e-01,0.97342e-01,0.10600e+00,0.11474e+00,0.12338e+00 /)
      kbo(:,26, 8) = (/ &
        & 0.84783e-01,0.93706e-01,0.10275e+00,0.11190e+00,0.12089e+00 /)
      kbo(:,27, 8) = (/ &
        & 0.81924e-01,0.91085e-01,0.10043e+00,0.11011e+00,0.11942e+00 /)
      kbo(:,28, 8) = (/ &
        & 0.79898e-01,0.89495e-01,0.99246e-01,0.10903e+00,0.11866e+00 /)
      kbo(:,29, 8) = (/ &
        & 0.78843e-01,0.88816e-01,0.99112e-01,0.10908e+00,0.11873e+00 /)
      kbo(:,30, 8) = (/ &
        & 0.78672e-01,0.89175e-01,0.99763e-01,0.10991e+00,0.11974e+00 /)
      kbo(:,31, 8) = (/ &
        & 0.79471e-01,0.90393e-01,0.10090e+00,0.11134e+00,0.12148e+00 /)
      kbo(:,32, 8) = (/ &
        & 0.81097e-01,0.92118e-01,0.10299e+00,0.11352e+00,0.12362e+00 /)
      kbo(:,33, 8) = (/ &
        & 0.83219e-01,0.94430e-01,0.10536e+00,0.11619e+00,0.12656e+00 /)
      kbo(:,34, 8) = (/ &
        & 0.85363e-01,0.96707e-01,0.10798e+00,0.11904e+00,0.12986e+00 /)
      kbo(:,35, 8) = (/ &
        & 0.86741e-01,0.98297e-01,0.11004e+00,0.12158e+00,0.13234e+00 /)
      kbo(:,36, 8) = (/ &
        & 0.87017e-01,0.99113e-01,0.11121e+00,0.12302e+00,0.13390e+00 /)
      kbo(:,37, 8) = (/ &
        & 0.85258e-01,0.97671e-01,0.10985e+00,0.12188e+00,0.13289e+00 /)
      kbo(:,38, 8) = (/ &
        & 0.83622e-01,0.96133e-01,0.10847e+00,0.12060e+00,0.13189e+00 /)
      kbo(:,39, 8) = (/ &
        & 0.82148e-01,0.94689e-01,0.10723e+00,0.11944e+00,0.13102e+00 /)
      kbo(:,40, 8) = (/ &
        & 0.78933e-01,0.91494e-01,0.10410e+00,0.11650e+00,0.12816e+00 /)
      kbo(:,41, 8) = (/ &
        & 0.75553e-01,0.88087e-01,0.10066e+00,0.11319e+00,0.12513e+00 /)
      kbo(:,42, 8) = (/ &
        & 0.72215e-01,0.84600e-01,0.97314e-01,0.10990e+00,0.12202e+00 /)
      kbo(:,43, 8) = (/ &
        & 0.68050e-01,0.80392e-01,0.93038e-01,0.10568e+00,0.11811e+00 /)
      kbo(:,44, 8) = (/ &
        & 0.63504e-01,0.75885e-01,0.88427e-01,0.10109e+00,0.11352e+00 /)
      kbo(:,45, 8) = (/ &
        & 0.59117e-01,0.71359e-01,0.83835e-01,0.96461e-01,0.10897e+00 /)
      kbo(:,46, 8) = (/ &
        & 0.54516e-01,0.66547e-01,0.79117e-01,0.91745e-01,0.10426e+00 /)
      kbo(:,47, 8) = (/ &
        & 0.49520e-01,0.61408e-01,0.73788e-01,0.86383e-01,0.98886e-01 /)
      kbo(:,48, 8) = (/ &
        & 0.44727e-01,0.56224e-01,0.68415e-01,0.81094e-01,0.93621e-01 /)
      kbo(:,49, 8) = (/ &
        & 0.40177e-01,0.51146e-01,0.63191e-01,0.75749e-01,0.88249e-01 /)
      kbo(:,50, 8) = (/ &
        & 0.36081e-01,0.46596e-01,0.58341e-01,0.70769e-01,0.83353e-01 /)
      kbo(:,51, 8) = (/ &
        & 0.32278e-01,0.42393e-01,0.53717e-01,0.65898e-01,0.78578e-01 /)
      kbo(:,52, 8) = (/ &
        & 0.28586e-01,0.38352e-01,0.49175e-01,0.61145e-01,0.73682e-01 /)
      kbo(:,53, 8) = (/ &
        & 0.25090e-01,0.34439e-01,0.44807e-01,0.56352e-01,0.68823e-01 /)
      kbo(:,54, 8) = (/ &
        & 0.22080e-01,0.30938e-01,0.40952e-01,0.52101e-01,0.64364e-01 /)
      kbo(:,55, 8) = (/ &
        & 0.19382e-01,0.27719e-01,0.37405e-01,0.48197e-01,0.60044e-01 /)
      kbo(:,56, 8) = (/ &
        & 0.16835e-01,0.24689e-01,0.33908e-01,0.44390e-01,0.55911e-01 /)
      kbo(:,57, 8) = (/ &
        & 0.14459e-01,0.21799e-01,0.30531e-01,0.40642e-01,0.51808e-01 /)
      kbo(:,58, 8) = (/ &
        & 0.12380e-01,0.19213e-01,0.27475e-01,0.37204e-01,0.48065e-01 /)
      kbo(:,59, 8) = (/ &
        & 0.11536e-01,0.18115e-01,0.26160e-01,0.35756e-01,0.46501e-01 /)
      kbo(:,13, 9) = (/ &
        & 0.79231e+00,0.80247e+00,0.81169e+00,0.81859e+00,0.82469e+00 /)
      kbo(:,14, 9) = (/ &
        & 0.76567e+00,0.77861e+00,0.78976e+00,0.79966e+00,0.80754e+00 /)
      kbo(:,15, 9) = (/ &
        & 0.73926e+00,0.75515e+00,0.76982e+00,0.78244e+00,0.79228e+00 /)
      kbo(:,16, 9) = (/ &
        & 0.71308e+00,0.73273e+00,0.74955e+00,0.76355e+00,0.77553e+00 /)
      kbo(:,17, 9) = (/ &
        & 0.68845e+00,0.70973e+00,0.72813e+00,0.74466e+00,0.75909e+00 /)
      kbo(:,18, 9) = (/ &
        & 0.66397e+00,0.68720e+00,0.70872e+00,0.72756e+00,0.74467e+00 /)
      kbo(:,19, 9) = (/ &
        & 0.64097e+00,0.66723e+00,0.69155e+00,0.71362e+00,0.73339e+00 /)
      kbo(:,20, 9) = (/ &
        & 0.62162e+00,0.65070e+00,0.67764e+00,0.70183e+00,0.72348e+00 /)
      kbo(:,21, 9) = (/ &
        & 0.60571e+00,0.63800e+00,0.66649e+00,0.69291e+00,0.71712e+00 /)
      kbo(:,22, 9) = (/ &
        & 0.59651e+00,0.62972e+00,0.66058e+00,0.68832e+00,0.71517e+00 /)
      kbo(:,23, 9) = (/ &
        & 0.58974e+00,0.62545e+00,0.65753e+00,0.68785e+00,0.71519e+00 /)
      kbo(:,24, 9) = (/ &
        & 0.58721e+00,0.62395e+00,0.65801e+00,0.68952e+00,0.71705e+00 /)
      kbo(:,25, 9) = (/ &
        & 0.58931e+00,0.62554e+00,0.66080e+00,0.69275e+00,0.72212e+00 /)
      kbo(:,26, 9) = (/ &
        & 0.59392e+00,0.63108e+00,0.66576e+00,0.69831e+00,0.72831e+00 /)
      kbo(:,27, 9) = (/ &
        & 0.60088e+00,0.63911e+00,0.67310e+00,0.70594e+00,0.73492e+00 /)
      kbo(:,28, 9) = (/ &
        & 0.61058e+00,0.64827e+00,0.68351e+00,0.71436e+00,0.74248e+00 /)
      kbo(:,29, 9) = (/ &
        & 0.62259e+00,0.66086e+00,0.69462e+00,0.72450e+00,0.75205e+00 /)
      kbo(:,30, 9) = (/ &
        & 0.63547e+00,0.67373e+00,0.70715e+00,0.73642e+00,0.76277e+00 /)
      kbo(:,31, 9) = (/ &
        & 0.65060e+00,0.68811e+00,0.72216e+00,0.75104e+00,0.77730e+00 /)
      kbo(:,32, 9) = (/ &
        & 0.66635e+00,0.70367e+00,0.73703e+00,0.76712e+00,0.79450e+00 /)
      kbo(:,33, 9) = (/ &
        & 0.68330e+00,0.72114e+00,0.75529e+00,0.78560e+00,0.81251e+00 /)
      kbo(:,34, 9) = (/ &
        & 0.69895e+00,0.73787e+00,0.77209e+00,0.80355e+00,0.82948e+00 /)
      kbo(:,35, 9) = (/ &
        & 0.71249e+00,0.75244e+00,0.78786e+00,0.82021e+00,0.84807e+00 /)
      kbo(:,36, 9) = (/ &
        & 0.72352e+00,0.76491e+00,0.80192e+00,0.83419e+00,0.86330e+00 /)
      kbo(:,37, 9) = (/ &
        & 0.72315e+00,0.76487e+00,0.80310e+00,0.83637e+00,0.86732e+00 /)
      kbo(:,38, 9) = (/ &
        & 0.72144e+00,0.76571e+00,0.80444e+00,0.83852e+00,0.86991e+00 /)
      kbo(:,39, 9) = (/ &
        & 0.72061e+00,0.76655e+00,0.80661e+00,0.84238e+00,0.87357e+00 /)
      kbo(:,40, 9) = (/ &
        & 0.71071e+00,0.75799e+00,0.79882e+00,0.83566e+00,0.86813e+00 /)
      kbo(:,41, 9) = (/ &
        & 0.69960e+00,0.74652e+00,0.79034e+00,0.82858e+00,0.86201e+00 /)
      kbo(:,42, 9) = (/ &
        & 0.68767e+00,0.73584e+00,0.78080e+00,0.82018e+00,0.85505e+00 /)
      kbo(:,43, 9) = (/ &
        & 0.67181e+00,0.72136e+00,0.76709e+00,0.80803e+00,0.84449e+00 /)
      kbo(:,44, 9) = (/ &
        & 0.65485e+00,0.70505e+00,0.75190e+00,0.79482e+00,0.83260e+00 /)
      kbo(:,45, 9) = (/ &
        & 0.63639e+00,0.68756e+00,0.73541e+00,0.78029e+00,0.82060e+00 /)
      kbo(:,46, 9) = (/ &
        & 0.61610e+00,0.67008e+00,0.71893e+00,0.76424e+00,0.80647e+00 /)
      kbo(:,47, 9) = (/ &
        & 0.59373e+00,0.64972e+00,0.69969e+00,0.74707e+00,0.79068e+00 /)
      kbo(:,48, 9) = (/ &
        & 0.56865e+00,0.62791e+00,0.68069e+00,0.72878e+00,0.77390e+00 /)
      kbo(:,49, 9) = (/ &
        & 0.54350e+00,0.60516e+00,0.66027e+00,0.71007e+00,0.75592e+00 /)
      kbo(:,50, 9) = (/ &
        & 0.51991e+00,0.58375e+00,0.64136e+00,0.69342e+00,0.74093e+00 /)
      kbo(:,51, 9) = (/ &
        & 0.49673e+00,0.56229e+00,0.62200e+00,0.67685e+00,0.72556e+00 /)
      kbo(:,52, 9) = (/ &
        & 0.47256e+00,0.53950e+00,0.60133e+00,0.65838e+00,0.70926e+00 /)
      kbo(:,53, 9) = (/ &
        & 0.44771e+00,0.51552e+00,0.57980e+00,0.63854e+00,0.69202e+00 /)
      kbo(:,54, 9) = (/ &
        & 0.42506e+00,0.49358e+00,0.56009e+00,0.62090e+00,0.67547e+00 /)
      kbo(:,55, 9) = (/ &
        & 0.40218e+00,0.47240e+00,0.53999e+00,0.60216e+00,0.65925e+00 /)
      kbo(:,56, 9) = (/ &
        & 0.37888e+00,0.45101e+00,0.51913e+00,0.58357e+00,0.64216e+00 /)
      kbo(:,57, 9) = (/ &
        & 0.35513e+00,0.42824e+00,0.49765e+00,0.56376e+00,0.62409e+00 /)
      kbo(:,58, 9) = (/ &
        & 0.33174e+00,0.40632e+00,0.47713e+00,0.54453e+00,0.60605e+00 /)
      kbo(:,59, 9) = (/ &
        & 0.32315e+00,0.39758e+00,0.46935e+00,0.53732e+00,0.59942e+00 /)
      kbo(:,13,10) = (/ &
        & 0.20814e+01,0.20759e+01,0.20660e+01,0.20703e+01,0.20598e+01 /)
      kbo(:,14,10) = (/ &
        & 0.20861e+01,0.20862e+01,0.20902e+01,0.20921e+01,0.20850e+01 /)
      kbo(:,15,10) = (/ &
        & 0.20793e+01,0.20969e+01,0.21057e+01,0.21014e+01,0.21089e+01 /)
      kbo(:,16,10) = (/ &
        & 0.20801e+01,0.20948e+01,0.21151e+01,0.21351e+01,0.21560e+01 /)
      kbo(:,17,10) = (/ &
        & 0.20802e+01,0.21249e+01,0.21608e+01,0.21842e+01,0.21924e+01 /)
      kbo(:,18,10) = (/ &
        & 0.20972e+01,0.21483e+01,0.21814e+01,0.21999e+01,0.22088e+01 /)
      kbo(:,19,10) = (/ &
        & 0.21086e+01,0.21513e+01,0.21845e+01,0.22099e+01,0.22261e+01 /)
      kbo(:,20,10) = (/ &
        & 0.21001e+01,0.21488e+01,0.21917e+01,0.22212e+01,0.22394e+01 /)
      kbo(:,21,10) = (/ &
        & 0.20945e+01,0.21494e+01,0.22004e+01,0.22330e+01,0.22537e+01 /)
      kbo(:,22,10) = (/ &
        & 0.20951e+01,0.21635e+01,0.22151e+01,0.22483e+01,0.22658e+01 /)
      kbo(:,23,10) = (/ &
        & 0.21106e+01,0.21802e+01,0.22288e+01,0.22593e+01,0.22769e+01 /)
      kbo(:,24,10) = (/ &
        & 0.21251e+01,0.21978e+01,0.22479e+01,0.22750e+01,0.23069e+01 /)
      kbo(:,25,10) = (/ &
        & 0.21350e+01,0.22127e+01,0.22620e+01,0.22919e+01,0.23205e+01 /)
      kbo(:,26,10) = (/ &
        & 0.21397e+01,0.22248e+01,0.22778e+01,0.23148e+01,0.23338e+01 /)
      kbo(:,27,10) = (/ &
        & 0.21476e+01,0.22244e+01,0.22911e+01,0.23271e+01,0.23529e+01 /)
      kbo(:,28,10) = (/ &
        & 0.21502e+01,0.22263e+01,0.22854e+01,0.23382e+01,0.23803e+01 /)
      kbo(:,29,10) = (/ &
        & 0.21444e+01,0.22159e+01,0.22839e+01,0.23447e+01,0.24026e+01 /)
      kbo(:,30,10) = (/ &
        & 0.21459e+01,0.22135e+01,0.22803e+01,0.23564e+01,0.24114e+01 /)
      kbo(:,31,10) = (/ &
        & 0.21548e+01,0.22131e+01,0.22785e+01,0.23559e+01,0.23993e+01 /)
      kbo(:,32,10) = (/ &
        & 0.21820e+01,0.22366e+01,0.23010e+01,0.23445e+01,0.23808e+01 /)
      kbo(:,33,10) = (/ &
        & 0.22356e+01,0.22739e+01,0.22923e+01,0.23386e+01,0.23842e+01 /)
      kbo(:,34,10) = (/ &
        & 0.22861e+01,0.23162e+01,0.23352e+01,0.23408e+01,0.23839e+01 /)
      kbo(:,35,10) = (/ &
        & 0.23385e+01,0.23680e+01,0.23728e+01,0.23741e+01,0.23938e+01 /)
      kbo(:,36,10) = (/ &
        & 0.23851e+01,0.24072e+01,0.24258e+01,0.24337e+01,0.24446e+01 /)
      kbo(:,37,10) = (/ &
        & 0.23954e+01,0.24271e+01,0.24525e+01,0.24638e+01,0.24744e+01 /)
      kbo(:,38,10) = (/ &
        & 0.24138e+01,0.24360e+01,0.24658e+01,0.24931e+01,0.25112e+01 /)
      kbo(:,39,10) = (/ &
        & 0.24207e+01,0.24415e+01,0.24747e+01,0.25054e+01,0.25446e+01 /)
      kbo(:,40,10) = (/ &
        & 0.24183e+01,0.24401e+01,0.24836e+01,0.25135e+01,0.25532e+01 /)
      kbo(:,41,10) = (/ &
        & 0.24046e+01,0.24486e+01,0.24788e+01,0.25037e+01,0.25503e+01 /)
      kbo(:,42,10) = (/ &
        & 0.23965e+01,0.24448e+01,0.24659e+01,0.25035e+01,0.25440e+01 /)
      kbo(:,43,10) = (/ &
        & 0.23757e+01,0.24456e+01,0.24672e+01,0.25043e+01,0.25340e+01 /)
      kbo(:,44,10) = (/ &
        & 0.23417e+01,0.24271e+01,0.24708e+01,0.24891e+01,0.25157e+01 /)
      kbo(:,45,10) = (/ &
        & 0.23140e+01,0.24224e+01,0.24648e+01,0.24895e+01,0.25109e+01 /)
      kbo(:,46,10) = (/ &
        & 0.22839e+01,0.23815e+01,0.24548e+01,0.24874e+01,0.24983e+01 /)
      kbo(:,47,10) = (/ &
        & 0.22509e+01,0.23585e+01,0.24548e+01,0.24976e+01,0.25158e+01 /)
      kbo(:,48,10) = (/ &
        & 0.22243e+01,0.23182e+01,0.24167e+01,0.24851e+01,0.25144e+01 /)
      kbo(:,49,10) = (/ &
        & 0.21934e+01,0.22838e+01,0.23882e+01,0.24694e+01,0.25145e+01 /)
      kbo(:,50,10) = (/ &
        & 0.21637e+01,0.22591e+01,0.23593e+01,0.24450e+01,0.25097e+01 /)
      kbo(:,51,10) = (/ &
        & 0.21256e+01,0.22383e+01,0.23340e+01,0.24239e+01,0.25025e+01 /)
      kbo(:,52,10) = (/ &
        & 0.20804e+01,0.22090e+01,0.23144e+01,0.24005e+01,0.24803e+01 /)
      kbo(:,53,10) = (/ &
        & 0.20229e+01,0.21712e+01,0.22790e+01,0.23709e+01,0.24497e+01 /)
      kbo(:,54,10) = (/ &
        & 0.19647e+01,0.21430e+01,0.22514e+01,0.23430e+01,0.24343e+01 /)
      kbo(:,55,10) = (/ &
        & 0.19094e+01,0.20990e+01,0.22287e+01,0.23283e+01,0.24126e+01 /)
      kbo(:,56,10) = (/ &
        & 0.18499e+01,0.20432e+01,0.21961e+01,0.22965e+01,0.23921e+01 /)
      kbo(:,57,10) = (/ &
        & 0.17845e+01,0.19868e+01,0.21557e+01,0.22661e+01,0.23666e+01 /)
      kbo(:,58,10) = (/ &
        & 0.17304e+01,0.19324e+01,0.21130e+01,0.22379e+01,0.23344e+01 /)
      kbo(:,59,10) = (/ &
        & 0.17036e+01,0.19129e+01,0.20925e+01,0.22299e+01,0.23291e+01 /)
      kbo(:,13,11) = (/ &
        & 0.28487e+01,0.28532e+01,0.28392e+01,0.28113e+01,0.28077e+01 /)
      kbo(:,14,11) = (/ &
        & 0.29217e+01,0.29135e+01,0.28970e+01,0.28895e+01,0.29104e+01 /)
      kbo(:,15,11) = (/ &
        & 0.29720e+01,0.29567e+01,0.29515e+01,0.29771e+01,0.29749e+01 /)
      kbo(:,16,11) = (/ &
        & 0.29934e+01,0.30029e+01,0.30226e+01,0.30339e+01,0.30204e+01 /)
      kbo(:,17,11) = (/ &
        & 0.30408e+01,0.30652e+01,0.30797e+01,0.30959e+01,0.31120e+01 /)
      kbo(:,18,11) = (/ &
        & 0.31059e+01,0.31457e+01,0.31893e+01,0.32154e+01,0.32284e+01 /)
      kbo(:,19,11) = (/ &
        & 0.31895e+01,0.32505e+01,0.32863e+01,0.32994e+01,0.32949e+01 /)
      kbo(:,20,11) = (/ &
        & 0.32605e+01,0.33203e+01,0.33389e+01,0.33469e+01,0.33350e+01 /)
      kbo(:,21,11) = (/ &
        & 0.33097e+01,0.33567e+01,0.33762e+01,0.33842e+01,0.33798e+01 /)
      kbo(:,22,11) = (/ &
        & 0.33482e+01,0.33901e+01,0.34068e+01,0.34227e+01,0.34010e+01 /)
      kbo(:,23,11) = (/ &
        & 0.33722e+01,0.34154e+01,0.34438e+01,0.34434e+01,0.34235e+01 /)
      kbo(:,24,11) = (/ &
        & 0.33951e+01,0.34377e+01,0.34659e+01,0.34658e+01,0.34557e+01 /)
      kbo(:,25,11) = (/ &
        & 0.34209e+01,0.34720e+01,0.34904e+01,0.34950e+01,0.34725e+01 /)
      kbo(:,26,11) = (/ &
        & 0.34497e+01,0.34967e+01,0.35233e+01,0.35072e+01,0.34967e+01 /)
      kbo(:,27,11) = (/ &
        & 0.34791e+01,0.35327e+01,0.35370e+01,0.35122e+01,0.35139e+01 /)
      kbo(:,28,11) = (/ &
        & 0.35134e+01,0.35471e+01,0.35465e+01,0.35405e+01,0.35525e+01 /)
      kbo(:,29,11) = (/ &
        & 0.35424e+01,0.35704e+01,0.35632e+01,0.35824e+01,0.35567e+01 /)
      kbo(:,30,11) = (/ &
        & 0.35629e+01,0.35947e+01,0.35992e+01,0.36011e+01,0.36027e+01 /)
      kbo(:,31,11) = (/ &
        & 0.35753e+01,0.36045e+01,0.36365e+01,0.36213e+01,0.36310e+01 /)
      kbo(:,32,11) = (/ &
        & 0.35596e+01,0.36100e+01,0.36333e+01,0.36490e+01,0.36651e+01 /)
      kbo(:,33,11) = (/ &
        & 0.35241e+01,0.35883e+01,0.36383e+01,0.36740e+01,0.36685e+01 /)
      kbo(:,34,11) = (/ &
        & 0.35027e+01,0.35491e+01,0.36249e+01,0.36739e+01,0.36810e+01 /)
      kbo(:,35,11) = (/ &
        & 0.34699e+01,0.35289e+01,0.35926e+01,0.36193e+01,0.36411e+01 /)
      kbo(:,36,11) = (/ &
        & 0.35153e+01,0.35225e+01,0.35498e+01,0.35989e+01,0.36429e+01 /)
      kbo(:,37,11) = (/ &
        & 0.35644e+01,0.35488e+01,0.35358e+01,0.35755e+01,0.36247e+01 /)
      kbo(:,38,11) = (/ &
        & 0.35952e+01,0.35902e+01,0.35685e+01,0.35598e+01,0.35995e+01 /)
      kbo(:,39,11) = (/ &
        & 0.36371e+01,0.36388e+01,0.36159e+01,0.35751e+01,0.35930e+01 /)
      kbo(:,40,11) = (/ &
        & 0.36530e+01,0.36611e+01,0.36495e+01,0.35923e+01,0.35985e+01 /)
      kbo(:,41,11) = (/ &
        & 0.36431e+01,0.36852e+01,0.36606e+01,0.36324e+01,0.35949e+01 /)
      kbo(:,42,11) = (/ &
        & 0.36510e+01,0.36940e+01,0.36905e+01,0.36729e+01,0.36122e+01 /)
      kbo(:,43,11) = (/ &
        & 0.36633e+01,0.36955e+01,0.37103e+01,0.36924e+01,0.36526e+01 /)
      kbo(:,44,11) = (/ &
        & 0.36584e+01,0.36852e+01,0.37131e+01,0.37219e+01,0.36946e+01 /)
      kbo(:,45,11) = (/ &
        & 0.36636e+01,0.36530e+01,0.37160e+01,0.37197e+01,0.37150e+01 /)
      kbo(:,46,11) = (/ &
        & 0.36713e+01,0.36779e+01,0.37130e+01,0.37408e+01,0.37431e+01 /)
      kbo(:,47,11) = (/ &
        & 0.36885e+01,0.36889e+01,0.37012e+01,0.37377e+01,0.37538e+01 /)
      kbo(:,48,11) = (/ &
        & 0.36735e+01,0.37253e+01,0.37092e+01,0.37311e+01,0.37444e+01 /)
      kbo(:,49,11) = (/ &
        & 0.36543e+01,0.37300e+01,0.37306e+01,0.37311e+01,0.37688e+01 /)
      kbo(:,50,11) = (/ &
        & 0.36397e+01,0.37435e+01,0.37659e+01,0.37491e+01,0.37600e+01 /)
      kbo(:,51,11) = (/ &
        & 0.36124e+01,0.37293e+01,0.37963e+01,0.37839e+01,0.37789e+01 /)
      kbo(:,52,11) = (/ &
        & 0.35636e+01,0.37078e+01,0.37818e+01,0.38114e+01,0.37775e+01 /)
      kbo(:,53,11) = (/ &
        & 0.34978e+01,0.36691e+01,0.37922e+01,0.38152e+01,0.38092e+01 /)
      kbo(:,54,11) = (/ &
        & 0.34749e+01,0.36230e+01,0.37686e+01,0.38328e+01,0.38292e+01 /)
      kbo(:,55,11) = (/ &
        & 0.34238e+01,0.35883e+01,0.37261e+01,0.38299e+01,0.38488e+01 /)
      kbo(:,56,11) = (/ &
        & 0.33568e+01,0.35597e+01,0.37073e+01,0.38247e+01,0.38591e+01 /)
      kbo(:,57,11) = (/ &
        & 0.32794e+01,0.35193e+01,0.36712e+01,0.37875e+01,0.38581e+01 /)
      kbo(:,58,11) = (/ &
        & 0.31971e+01,0.34544e+01,0.36268e+01,0.37609e+01,0.38393e+01 /)
      kbo(:,59,11) = (/ &
        & 0.31680e+01,0.34441e+01,0.36338e+01,0.37596e+01,0.38510e+01 /)
      kbo(:,13,12) = (/ &
        & 0.40944e+01,0.40706e+01,0.40738e+01,0.40615e+01,0.40255e+01 /)
      kbo(:,14,12) = (/ &
        & 0.42568e+01,0.42640e+01,0.42578e+01,0.42281e+01,0.41677e+01 /)
      kbo(:,15,12) = (/ &
        & 0.44471e+01,0.44460e+01,0.44235e+01,0.43647e+01,0.43107e+01 /)
      kbo(:,16,12) = (/ &
        & 0.45971e+01,0.45776e+01,0.45277e+01,0.44905e+01,0.45101e+01 /)
      kbo(:,17,12) = (/ &
        & 0.46780e+01,0.46358e+01,0.46311e+01,0.46380e+01,0.46103e+01 /)
      kbo(:,18,12) = (/ &
        & 0.47294e+01,0.47444e+01,0.47418e+01,0.47299e+01,0.47059e+01 /)
      kbo(:,19,12) = (/ &
        & 0.48604e+01,0.48842e+01,0.48819e+01,0.49000e+01,0.48969e+01 /)
      kbo(:,20,12) = (/ &
        & 0.49979e+01,0.50271e+01,0.50614e+01,0.50783e+01,0.50637e+01 /)
      kbo(:,21,12) = (/ &
        & 0.51216e+01,0.51841e+01,0.52155e+01,0.52098e+01,0.51706e+01 /)
      kbo(:,22,12) = (/ &
        & 0.52796e+01,0.53177e+01,0.53275e+01,0.53003e+01,0.52540e+01 /)
      kbo(:,23,12) = (/ &
        & 0.54021e+01,0.54214e+01,0.54107e+01,0.53770e+01,0.53308e+01 /)
      kbo(:,24,12) = (/ &
        & 0.54951e+01,0.54954e+01,0.54655e+01,0.54275e+01,0.53548e+01 /)
      kbo(:,25,12) = (/ &
        & 0.55606e+01,0.55401e+01,0.55126e+01,0.54611e+01,0.53900e+01 /)
      kbo(:,26,12) = (/ &
        & 0.56084e+01,0.55775e+01,0.55344e+01,0.54935e+01,0.53765e+01 /)
      kbo(:,27,12) = (/ &
        & 0.56424e+01,0.55975e+01,0.55674e+01,0.55057e+01,0.54137e+01 /)
      kbo(:,28,12) = (/ &
        & 0.56582e+01,0.56350e+01,0.55811e+01,0.55009e+01,0.54160e+01 /)
      kbo(:,29,12) = (/ &
        & 0.56833e+01,0.56401e+01,0.55975e+01,0.55109e+01,0.54249e+01 /)
      kbo(:,30,12) = (/ &
        & 0.57003e+01,0.56620e+01,0.55904e+01,0.55121e+01,0.54542e+01 /)
      kbo(:,31,12) = (/ &
        & 0.57132e+01,0.56848e+01,0.56091e+01,0.55447e+01,0.55236e+01 /)
      kbo(:,32,12) = (/ &
        & 0.57800e+01,0.57027e+01,0.56220e+01,0.56024e+01,0.55523e+01 /)
      kbo(:,33,12) = (/ &
        & 0.57668e+01,0.57069e+01,0.56826e+01,0.56406e+01,0.56224e+01 /)
      kbo(:,34,12) = (/ &
        & 0.57877e+01,0.57628e+01,0.57465e+01,0.57131e+01,0.56752e+01 /)
      kbo(:,35,12) = (/ &
        & 0.58053e+01,0.58032e+01,0.57814e+01,0.58008e+01,0.57412e+01 /)
      kbo(:,36,12) = (/ &
        & 0.57386e+01,0.58034e+01,0.57934e+01,0.57973e+01,0.57760e+01 /)
      kbo(:,37,12) = (/ &
        & 0.56650e+01,0.57400e+01,0.57795e+01,0.58096e+01,0.57723e+01 /)
      kbo(:,38,12) = (/ &
        & 0.56068e+01,0.56512e+01,0.57137e+01,0.58154e+01,0.57795e+01 /)
      kbo(:,39,12) = (/ &
        & 0.55712e+01,0.56156e+01,0.56456e+01,0.57952e+01,0.57768e+01 /)
      kbo(:,40,12) = (/ &
        & 0.55331e+01,0.55774e+01,0.56049e+01,0.57462e+01,0.57382e+01 /)
      kbo(:,41,12) = (/ &
        & 0.55579e+01,0.55330e+01,0.55754e+01,0.56805e+01,0.57245e+01 /)
      kbo(:,42,12) = (/ &
        & 0.55684e+01,0.55372e+01,0.55455e+01,0.56019e+01,0.57291e+01 /)
      kbo(:,43,12) = (/ &
        & 0.56282e+01,0.55547e+01,0.55863e+01,0.55852e+01,0.56892e+01 /)
      kbo(:,44,12) = (/ &
        & 0.56429e+01,0.55998e+01,0.55663e+01,0.55662e+01,0.56522e+01 /)
      kbo(:,45,12) = (/ &
        & 0.56488e+01,0.56642e+01,0.55915e+01,0.56136e+01,0.56176e+01 /)
      kbo(:,46,12) = (/ &
        & 0.57246e+01,0.57165e+01,0.56557e+01,0.56271e+01,0.56227e+01 /)
      kbo(:,47,12) = (/ &
        & 0.57406e+01,0.57550e+01,0.57336e+01,0.56616e+01,0.56928e+01 /)
      kbo(:,48,12) = (/ &
        & 0.57616e+01,0.57715e+01,0.57765e+01,0.57429e+01,0.57151e+01 /)
      kbo(:,49,12) = (/ &
        & 0.58013e+01,0.57807e+01,0.58014e+01,0.57796e+01,0.57022e+01 /)
      kbo(:,50,12) = (/ &
        & 0.58611e+01,0.58307e+01,0.58954e+01,0.58904e+01,0.58254e+01 /)
      kbo(:,51,12) = (/ &
        & 0.59182e+01,0.59013e+01,0.59353e+01,0.59746e+01,0.59215e+01 /)
      kbo(:,52,12) = (/ &
        & 0.59636e+01,0.59631e+01,0.59638e+01,0.60147e+01,0.60288e+01 /)
      kbo(:,53,12) = (/ &
        & 0.60261e+01,0.59972e+01,0.59771e+01,0.60154e+01,0.60632e+01 /)
      kbo(:,54,12) = (/ &
        & 0.60204e+01,0.60805e+01,0.60002e+01,0.60580e+01,0.60854e+01 /)
      kbo(:,55,12) = (/ &
        & 0.60584e+01,0.61138e+01,0.60917e+01,0.60710e+01,0.61237e+01 /)
      kbo(:,56,12) = (/ &
        & 0.60402e+01,0.61059e+01,0.61154e+01,0.61008e+01,0.61463e+01 /)
      kbo(:,57,12) = (/ &
        & 0.60080e+01,0.61076e+01,0.61306e+01,0.61548e+01,0.61892e+01 /)
      kbo(:,58,12) = (/ &
        & 0.59781e+01,0.61168e+01,0.61621e+01,0.61680e+01,0.62246e+01 /)
      kbo(:,59,12) = (/ &
        & 0.59824e+01,0.60878e+01,0.61825e+01,0.62179e+01,0.62658e+01 /)
      kbo(:,13,13) = (/ &
        & 0.62252e+01,0.61003e+01,0.59711e+01,0.58641e+01,0.57820e+01 /)
      kbo(:,14,13) = (/ &
        & 0.66429e+01,0.64784e+01,0.63526e+01,0.62330e+01,0.61644e+01 /)
      kbo(:,15,13) = (/ &
        & 0.69743e+01,0.68232e+01,0.67077e+01,0.66230e+01,0.65438e+01 /)
      kbo(:,16,13) = (/ &
        & 0.72971e+01,0.72050e+01,0.71016e+01,0.69747e+01,0.67726e+01 /)
      kbo(:,17,13) = (/ &
        & 0.77109e+01,0.75892e+01,0.74253e+01,0.72127e+01,0.70341e+01 /)
      kbo(:,18,13) = (/ &
        & 0.80450e+01,0.78275e+01,0.75988e+01,0.74227e+01,0.73977e+01 /)
      kbo(:,19,13) = (/ &
        & 0.81727e+01,0.79248e+01,0.78355e+01,0.77125e+01,0.75391e+01 /)
      kbo(:,20,13) = (/ &
        & 0.82796e+01,0.81265e+01,0.80271e+01,0.78599e+01,0.77204e+01 /)
      kbo(:,21,13) = (/ &
        & 0.84685e+01,0.83415e+01,0.82106e+01,0.80317e+01,0.78896e+01 /)
      kbo(:,22,13) = (/ &
        & 0.86169e+01,0.85255e+01,0.83779e+01,0.82528e+01,0.81573e+01 /)
      kbo(:,23,13) = (/ &
        & 0.88276e+01,0.86892e+01,0.86001e+01,0.84644e+01,0.83125e+01 /)
      kbo(:,24,13) = (/ &
        & 0.89834e+01,0.88963e+01,0.87866e+01,0.86675e+01,0.84751e+01 /)
      kbo(:,25,13) = (/ &
        & 0.91971e+01,0.90977e+01,0.89941e+01,0.88254e+01,0.85750e+01 /)
      kbo(:,26,13) = (/ &
        & 0.93611e+01,0.92762e+01,0.91306e+01,0.88795e+01,0.86828e+01 /)
      kbo(:,27,13) = (/ &
        & 0.95231e+01,0.94096e+01,0.91709e+01,0.89786e+01,0.86968e+01 /)
      kbo(:,28,13) = (/ &
        & 0.96495e+01,0.94564e+01,0.92347e+01,0.89785e+01,0.86180e+01 /)
      kbo(:,29,13) = (/ &
        & 0.97336e+01,0.94935e+01,0.92561e+01,0.89137e+01,0.86661e+01 /)
      kbo(:,30,13) = (/ &
        & 0.97605e+01,0.95111e+01,0.92200e+01,0.89355e+01,0.85920e+01 /)
      kbo(:,31,13) = (/ &
        & 0.97562e+01,0.95167e+01,0.91771e+01,0.88618e+01,0.85414e+01 /)
      kbo(:,32,13) = (/ &
        & 0.97192e+01,0.94434e+01,0.91403e+01,0.87870e+01,0.85159e+01 /)
      kbo(:,33,13) = (/ &
        & 0.97162e+01,0.94370e+01,0.90971e+01,0.88239e+01,0.85528e+01 /)
      kbo(:,34,13) = (/ &
        & 0.96997e+01,0.93448e+01,0.90783e+01,0.87958e+01,0.87225e+01 /)
      kbo(:,35,13) = (/ &
        & 0.97261e+01,0.93769e+01,0.90457e+01,0.89061e+01,0.87695e+01 /)
      kbo(:,36,13) = (/ &
        & 0.97573e+01,0.94639e+01,0.92105e+01,0.90277e+01,0.88187e+01 /)
      kbo(:,37,13) = (/ &
        & 0.98297e+01,0.95424e+01,0.93169e+01,0.90796e+01,0.89104e+01 /)
      kbo(:,38,13) = (/ &
        & 0.99015e+01,0.96432e+01,0.94039e+01,0.91616e+01,0.89941e+01 /)
      kbo(:,39,13) = (/ &
        & 0.99137e+01,0.96714e+01,0.94790e+01,0.92092e+01,0.90352e+01 /)
      kbo(:,40,13) = (/ &
        & 0.99728e+01,0.96872e+01,0.94263e+01,0.92759e+01,0.90690e+01 /)
      kbo(:,41,13) = (/ &
        & 0.10009e+02,0.96720e+01,0.94529e+01,0.92520e+01,0.90775e+01 /)
      kbo(:,42,13) = (/ &
        & 0.99394e+01,0.96947e+01,0.94735e+01,0.92670e+01,0.90312e+01 /)
      kbo(:,43,13) = (/ &
        & 0.98412e+01,0.96685e+01,0.93802e+01,0.91747e+01,0.90019e+01 /)
      kbo(:,44,13) = (/ &
        & 0.98284e+01,0.96419e+01,0.93576e+01,0.91166e+01,0.88968e+01 /)
      kbo(:,45,13) = (/ &
        & 0.98765e+01,0.96737e+01,0.94176e+01,0.90811e+01,0.88300e+01 /)
      kbo(:,46,13) = (/ &
        & 0.99370e+01,0.96739e+01,0.94534e+01,0.91692e+01,0.88574e+01 /)
      kbo(:,47,13) = (/ &
        & 0.10145e+02,0.99712e+01,0.96675e+01,0.93530e+01,0.89895e+01 /)
      kbo(:,48,13) = (/ &
        & 0.10395e+02,0.10167e+02,0.99330e+01,0.95943e+01,0.92927e+01 /)
      kbo(:,49,13) = (/ &
        & 0.10580e+02,0.10365e+02,0.10114e+02,0.98197e+01,0.95303e+01 /)
      kbo(:,50,13) = (/ &
        & 0.10794e+02,0.10715e+02,0.10421e+02,0.10154e+02,0.98629e+01 /)
      kbo(:,51,13) = (/ &
        & 0.10946e+02,0.10939e+02,0.10689e+02,0.10427e+02,0.10145e+02 /)
      kbo(:,52,13) = (/ &
        & 0.11156e+02,0.11126e+02,0.10973e+02,0.10622e+02,0.10371e+02 /)
      kbo(:,53,13) = (/ &
        & 0.11165e+02,0.11308e+02,0.11212e+02,0.10985e+02,0.10624e+02 /)
      kbo(:,54,13) = (/ &
        & 0.11221e+02,0.11354e+02,0.11431e+02,0.11243e+02,0.10959e+02 /)
      kbo(:,55,13) = (/ &
        & 0.11238e+02,0.11406e+02,0.11591e+02,0.11479e+02,0.11275e+02 /)
      kbo(:,56,13) = (/ &
        & 0.11335e+02,0.11405e+02,0.11662e+02,0.11637e+02,0.11480e+02 /)
      kbo(:,57,13) = (/ &
        & 0.11355e+02,0.11451e+02,0.11592e+02,0.11670e+02,0.11515e+02 /)
      kbo(:,58,13) = (/ &
        & 0.11389e+02,0.11476e+02,0.11586e+02,0.11657e+02,0.11618e+02 /)
      kbo(:,59,13) = (/ &
        & 0.11480e+02,0.11599e+02,0.11673e+02,0.11677e+02,0.11653e+02 /)
      kbo(:,13,14) = (/ &
        & 0.97590e+01,0.94275e+01,0.91020e+01,0.89149e+01,0.87289e+01 /)
      kbo(:,14,14) = (/ &
        & 0.10505e+02,0.10164e+02,0.99232e+01,0.97321e+01,0.94201e+01 /)
      kbo(:,15,14) = (/ &
        & 0.11237e+02,0.10955e+02,0.10714e+02,0.10370e+02,0.10019e+02 /)
      kbo(:,16,14) = (/ &
        & 0.12124e+02,0.11740e+02,0.11352e+02,0.10992e+02,0.10632e+02 /)
      kbo(:,17,14) = (/ &
        & 0.12886e+02,0.12429e+02,0.12001e+02,0.11642e+02,0.11273e+02 /)
      kbo(:,18,14) = (/ &
        & 0.13556e+02,0.13047e+02,0.12733e+02,0.12297e+02,0.11616e+02 /)
      kbo(:,19,14) = (/ &
        & 0.14349e+02,0.13901e+02,0.13193e+02,0.12562e+02,0.12015e+02 /)
      kbo(:,20,14) = (/ &
        & 0.15084e+02,0.14361e+02,0.13567e+02,0.12903e+02,0.12393e+02 /)
      kbo(:,21,14) = (/ &
        & 0.15509e+02,0.14641e+02,0.13824e+02,0.13136e+02,0.12832e+02 /)
      kbo(:,22,14) = (/ &
        & 0.15737e+02,0.14756e+02,0.13944e+02,0.13493e+02,0.13014e+02 /)
      kbo(:,23,14) = (/ &
        & 0.15733e+02,0.14806e+02,0.14130e+02,0.13708e+02,0.13129e+02 /)
      kbo(:,24,14) = (/ &
        & 0.15735e+02,0.14832e+02,0.14382e+02,0.13702e+02,0.13090e+02 /)
      kbo(:,25,14) = (/ &
        & 0.15596e+02,0.15046e+02,0.14369e+02,0.13676e+02,0.13207e+02 /)
      kbo(:,26,14) = (/ &
        & 0.15679e+02,0.15085e+02,0.14382e+02,0.13864e+02,0.13243e+02 /)
      kbo(:,27,14) = (/ &
        & 0.15773e+02,0.15051e+02,0.14458e+02,0.13792e+02,0.13309e+02 /)
      kbo(:,28,14) = (/ &
        & 0.15791e+02,0.15118e+02,0.14520e+02,0.13908e+02,0.13506e+02 /)
      kbo(:,29,14) = (/ &
        & 0.15907e+02,0.15282e+02,0.14696e+02,0.14168e+02,0.13591e+02 /)
      kbo(:,30,14) = (/ &
        & 0.15997e+02,0.15426e+02,0.14908e+02,0.14325e+02,0.13655e+02 /)
      kbo(:,31,14) = (/ &
        & 0.16254e+02,0.15640e+02,0.15053e+02,0.14410e+02,0.13542e+02 /)
      kbo(:,32,14) = (/ &
        & 0.16522e+02,0.15885e+02,0.15194e+02,0.14363e+02,0.13365e+02 /)
      kbo(:,33,14) = (/ &
        & 0.16844e+02,0.16068e+02,0.15151e+02,0.14109e+02,0.13003e+02 /)
      kbo(:,34,14) = (/ &
        & 0.16915e+02,0.16003e+02,0.14953e+02,0.13814e+02,0.12608e+02 /)
      kbo(:,35,14) = (/ &
        & 0.16922e+02,0.15890e+02,0.14756e+02,0.13405e+02,0.12281e+02 /)
      kbo(:,36,14) = (/ &
        & 0.16966e+02,0.15773e+02,0.14522e+02,0.13240e+02,0.11917e+02 /)
      kbo(:,37,14) = (/ &
        & 0.17142e+02,0.15897e+02,0.14564e+02,0.13378e+02,0.11953e+02 /)
      kbo(:,38,14) = (/ &
        & 0.17346e+02,0.16051e+02,0.14752e+02,0.13439e+02,0.11971e+02 /)
      kbo(:,39,14) = (/ &
        & 0.17475e+02,0.16210e+02,0.14948e+02,0.13510e+02,0.12056e+02 /)
      kbo(:,40,14) = (/ &
        & 0.17754e+02,0.16503e+02,0.15328e+02,0.13801e+02,0.12328e+02 /)
      kbo(:,41,14) = (/ &
        & 0.18031e+02,0.16909e+02,0.15619e+02,0.14276e+02,0.12740e+02 /)
      kbo(:,42,14) = (/ &
        & 0.18386e+02,0.17235e+02,0.15966e+02,0.14652e+02,0.13194e+02 /)
      kbo(:,43,14) = (/ &
        & 0.18710e+02,0.17591e+02,0.16361e+02,0.15070e+02,0.13707e+02 /)
      kbo(:,44,14) = (/ &
        & 0.19098e+02,0.17898e+02,0.16845e+02,0.15582e+02,0.14265e+02 /)
      kbo(:,45,14) = (/ &
        & 0.19252e+02,0.18167e+02,0.17135e+02,0.15969e+02,0.14652e+02 /)
      kbo(:,46,14) = (/ &
        & 0.19041e+02,0.18357e+02,0.17265e+02,0.16200e+02,0.15002e+02 /)
      kbo(:,47,14) = (/ &
        & 0.18766e+02,0.18032e+02,0.17152e+02,0.16208e+02,0.15088e+02 /)
      kbo(:,48,14) = (/ &
        & 0.18411e+02,0.17740e+02,0.16984e+02,0.16085e+02,0.15089e+02 /)
      kbo(:,49,14) = (/ &
        & 0.18291e+02,0.17667e+02,0.16941e+02,0.16014e+02,0.14979e+02 /)
      kbo(:,50,14) = (/ &
        & 0.18624e+02,0.17786e+02,0.17174e+02,0.16136e+02,0.15128e+02 /)
      kbo(:,51,14) = (/ &
        & 0.19430e+02,0.18470e+02,0.17722e+02,0.16775e+02,0.15711e+02 /)
      kbo(:,52,14) = (/ &
        & 0.20123e+02,0.18895e+02,0.18060e+02,0.17255e+02,0.16173e+02 /)
      kbo(:,53,14) = (/ &
        & 0.20744e+02,0.19415e+02,0.18626e+02,0.17397e+02,0.16465e+02 /)
      kbo(:,54,14) = (/ &
        & 0.21714e+02,0.20093e+02,0.19173e+02,0.18078e+02,0.16884e+02 /)
      kbo(:,55,14) = (/ &
        & 0.22731e+02,0.21068e+02,0.19674e+02,0.18569e+02,0.17315e+02 /)
      kbo(:,56,14) = (/ &
        & 0.23924e+02,0.22190e+02,0.20317e+02,0.18891e+02,0.17603e+02 /)
      kbo(:,57,14) = (/ &
        & 0.24940e+02,0.23270e+02,0.21498e+02,0.19833e+02,0.18265e+02 /)
      kbo(:,58,14) = (/ &
        & 0.25828e+02,0.24271e+02,0.22518e+02,0.20827e+02,0.19003e+02 /)
      kbo(:,59,14) = (/ &
        & 0.26483e+02,0.24983e+02,0.23453e+02,0.21676e+02,0.19755e+02 /)
      kbo(:,13,15) = (/ &
        & 0.15960e+02,0.15303e+02,0.14694e+02,0.13842e+02,0.13008e+02 /)
      kbo(:,14,15) = (/ &
        & 0.17675e+02,0.16896e+02,0.15925e+02,0.14915e+02,0.14133e+02 /)
      kbo(:,15,15) = (/ &
        & 0.19385e+02,0.18234e+02,0.16959e+02,0.15987e+02,0.15180e+02 /)
      kbo(:,16,15) = (/ &
        & 0.20552e+02,0.19165e+02,0.17982e+02,0.16927e+02,0.16368e+02 /)
      kbo(:,17,15) = (/ &
        & 0.21349e+02,0.19954e+02,0.19023e+02,0.18091e+02,0.17398e+02 /)
      kbo(:,18,15) = (/ &
        & 0.22160e+02,0.21597e+02,0.20213e+02,0.19055e+02,0.18102e+02 /)
      kbo(:,19,15) = (/ &
        & 0.23816e+02,0.22303e+02,0.21008e+02,0.19912e+02,0.18903e+02 /)
      kbo(:,20,15) = (/ &
        & 0.24810e+02,0.23381e+02,0.21933e+02,0.20846e+02,0.19540e+02 /)
      kbo(:,21,15) = (/ &
        & 0.25893e+02,0.24250e+02,0.22750e+02,0.21616e+02,0.19627e+02 /)
      kbo(:,22,15) = (/ &
        & 0.26542e+02,0.24773e+02,0.23600e+02,0.21309e+02,0.19278e+02 /)
      kbo(:,23,15) = (/ &
        & 0.27270e+02,0.25621e+02,0.23587e+02,0.21255e+02,0.19478e+02 /)
      kbo(:,24,15) = (/ &
        & 0.27744e+02,0.26088e+02,0.23254e+02,0.21242e+02,0.19100e+02 /)
      kbo(:,25,15) = (/ &
        & 0.28557e+02,0.25575e+02,0.23098e+02,0.20631e+02,0.18206e+02 /)
      kbo(:,26,15) = (/ &
        & 0.28140e+02,0.25135e+02,0.22210e+02,0.19496e+02,0.17366e+02 /)
      kbo(:,27,15) = (/ &
        & 0.27284e+02,0.24232e+02,0.21249e+02,0.18720e+02,0.16279e+02 /)
      kbo(:,28,15) = (/ &
        & 0.26494e+02,0.23076e+02,0.20060e+02,0.17566e+02,0.14956e+02 /)
      kbo(:,29,15) = (/ &
        & 0.24773e+02,0.21460e+02,0.18370e+02,0.15793e+02,0.13302e+02 /)
      kbo(:,30,15) = (/ &
        & 0.23157e+02,0.19587e+02,0.16563e+02,0.13805e+02,0.11647e+02 /)
      kbo(:,31,15) = (/ &
        & 0.20881e+02,0.17370e+02,0.14460e+02,0.11958e+02,0.99808e+01 /)
      kbo(:,32,15) = (/ &
        & 0.18247e+02,0.15035e+02,0.12296e+02,0.10101e+02,0.83032e+01 /)
      kbo(:,33,15) = (/ &
        & 0.15492e+02,0.12470e+02,0.10235e+02,0.81131e+01,0.64390e+01 /)
      kbo(:,34,15) = (/ &
        & 0.13284e+02,0.10782e+02,0.82553e+01,0.64597e+01,0.42402e+01 /)
      kbo(:,35,15) = (/ &
        & 0.11520e+02,0.89534e+01,0.69691e+01,0.48753e+01,0.27443e+01 /)
      kbo(:,36,15) = (/ &
        & 0.10067e+02,0.75650e+01,0.54572e+01,0.31866e+01,0.14626e+01 /)
      kbo(:,37,15) = (/ &
        & 0.97744e+01,0.73767e+01,0.52433e+01,0.27509e+01,0.10380e+01 /)
      kbo(:,38,15) = (/ &
        & 0.94733e+01,0.70859e+01,0.47807e+01,0.23954e+01,0.74468e+00 /)
      kbo(:,39,15) = (/ &
        & 0.94041e+01,0.67286e+01,0.41966e+01,0.20683e+01,0.27939e+00 /)
      kbo(:,40,15) = (/ &
        & 0.10076e+02,0.74414e+01,0.47964e+01,0.25258e+01,0.87689e+00 /)
      kbo(:,41,15) = (/ &
        & 0.10878e+02,0.81759e+01,0.56173e+01,0.30416e+01,0.13231e+01 /)
      kbo(:,42,15) = (/ &
        & 0.11858e+02,0.88284e+01,0.63009e+01,0.37211e+01,0.17214e+01 /)
      kbo(:,43,15) = (/ &
        & 0.13284e+02,0.99847e+01,0.73905e+01,0.50291e+01,0.24940e+01 /)
      kbo(:,44,15) = (/ &
        & 0.14796e+02,0.11545e+02,0.85671e+01,0.61687e+01,0.37136e+01 /)
      kbo(:,45,15) = (/ &
        & 0.16662e+02,0.12949e+02,0.98033e+01,0.73353e+01,0.52329e+01 /)
      kbo(:,46,15) = (/ &
        & 0.19200e+02,0.14684e+02,0.11434e+02,0.85867e+01,0.64428e+01 /)
      kbo(:,47,15) = (/ &
        & 0.21780e+02,0.16837e+02,0.13158e+02,0.10165e+02,0.76608e+01 /)
      kbo(:,48,15) = (/ &
        & 0.24689e+02,0.19487e+02,0.15145e+02,0.11845e+02,0.89940e+01 /)
      kbo(:,49,15) = (/ &
        & 0.27130e+02,0.21775e+02,0.17116e+02,0.13679e+02,0.10905e+02 /)
      kbo(:,50,15) = (/ &
        & 0.27854e+02,0.22306e+02,0.17103e+02,0.13783e+02,0.10863e+02 /)
      kbo(:,51,15) = (/ &
        & 0.27653e+02,0.21825e+02,0.16692e+02,0.12707e+02,0.98148e+01 /)
      kbo(:,52,15) = (/ &
        & 0.27815e+02,0.22411e+02,0.17151e+02,0.12787e+02,0.95823e+01 /)
      kbo(:,53,15) = (/ &
        & 0.29119e+02,0.23144e+02,0.17252e+02,0.13594e+02,0.99767e+01 /)
      kbo(:,54,15) = (/ &
        & 0.29129e+02,0.23469e+02,0.17342e+02,0.12745e+02,0.95359e+01 /)
      kbo(:,55,15) = (/ &
        & 0.29058e+02,0.23190e+02,0.17458e+02,0.12690e+02,0.90099e+01 /)
      kbo(:,56,15) = (/ &
        & 0.28657e+02,0.23001e+02,0.17896e+02,0.13433e+02,0.94907e+01 /)
      kbo(:,57,15) = (/ &
        & 0.29240e+02,0.22830e+02,0.17734e+02,0.13185e+02,0.97411e+01 /)
      kbo(:,58,15) = (/ &
        & 0.29947e+02,0.22946e+02,0.17582e+02,0.13008e+02,0.96489e+01 /)
      kbo(:,59,15) = (/ &
        & 0.28976e+02,0.21746e+02,0.15522e+02,0.11254e+02,0.80222e+01 /)
      kbo(:,13,16) = (/ &
        & 0.25931e+02,0.24537e+02,0.23224e+02,0.21983e+02,0.20855e+02 /)
      kbo(:,14,16) = (/ &
        & 0.29220e+02,0.27507e+02,0.25899e+02,0.24431e+02,0.23088e+02 /)
      kbo(:,15,16) = (/ &
        & 0.32471e+02,0.30409e+02,0.28502e+02,0.26794e+02,0.25226e+02 /)
      kbo(:,16,16) = (/ &
        & 0.35624e+02,0.33186e+02,0.30989e+02,0.28748e+02,0.24479e+02 /)
      kbo(:,17,16) = (/ &
        & 0.38605e+02,0.35797e+02,0.30613e+02,0.25949e+02,0.21171e+02 /)
      kbo(:,18,16) = (/ &
        & 0.41350e+02,0.31676e+02,0.25965e+02,0.21818e+02,0.18145e+02 /)
      kbo(:,19,16) = (/ &
        & 0.34377e+02,0.28144e+02,0.23342e+02,0.17735e+02,0.13818e+02 /)
      kbo(:,20,16) = (/ &
        & 0.31245e+02,0.24408e+02,0.19618e+02,0.13984e+02,0.93171e+01 /)
      kbo(:,21,16) = (/ &
        & 0.28216e+02,0.21711e+02,0.16938e+02,0.11225e+02,0.60954e+01 /)
      kbo(:,22,16) = (/ &
        & 0.25410e+02,0.20320e+02,0.12451e+02,0.80509e+01,0.41742e+01 /)
      kbo(:,23,16) = (/ &
        & 0.22191e+02,0.15284e+02,0.84334e+01,0.32443e+01,0.10236e-04 /)
      kbo(:,24,16) = (/ &
        & 0.19170e+02,0.98429e+01,0.40822e+01,0.90070e-05,0.84964e-05 /)
      kbo(:,25,16) = (/ &
        & 0.11441e+02,0.50508e+01,0.77316e-05,0.71796e-05,0.66473e-05 /)
      kbo(:,26,16) = (/ &
        & 0.73617e+01,0.56953e+00,0.62155e-05,0.57759e-05,0.53447e-05 /)
      kbo(:,27,16) = (/ &
        & 0.37038e+01,0.54098e-05,0.49933e-05,0.45180e-05,0.42997e-05 /)
      kbo(:,28,16) = (/ &
        & 0.47094e-05,0.43472e-05,0.40149e-05,0.36332e-05,0.34550e-05 /)
      kbo(:,29,16) = (/ &
        & 0.37812e-05,0.34885e-05,0.32238e-05,0.29187e-05,0.27779e-05 /)
      kbo(:,30,16) = (/ &
        & 0.30339e-05,0.28004e-05,0.25314e-05,0.23451e-05,0.22313e-05 /)
      kbo(:,31,16) = (/ &
        & 0.24328e-05,0.22460e-05,0.20326e-05,0.18813e-05,0.17930e-05 /)
      kbo(:,32,16) = (/ &
        & 0.18939e-05,0.18012e-05,0.16316e-05,0.15109e-05,0.14395e-05 /)
      kbo(:,33,16) = (/ &
        & 0.15657e-05,0.14309e-05,0.13083e-05,0.12124e-05,0.15795e-05 /)
      kbo(:,34,16) = (/ &
        & 0.12582e-05,0.11508e-05,0.10527e-05,0.97625e-06,0.19757e-05 /)
      kbo(:,35,16) = (/ &
        & 0.10197e-05,0.93275e-06,0.85375e-06,0.79153e-06,0.21668e-05 /)
      kbo(:,36,16) = (/ &
        & 0.83336e-06,0.76274e-06,0.69805e-06,0.64735e-06,0.17739e-05 /)
      kbo(:,37,16) = (/ &
        & 0.68945e-06,0.63022e-06,0.57702e-06,0.53486e-06,0.10843e-05 /)
      kbo(:,38,16) = (/ &
        & 0.55406e-06,0.52180e-06,0.47760e-06,0.44282e-06,0.89395e-06 /)
      kbo(:,39,16) = (/ &
        & 0.45861e-06,0.43223e-06,0.39548e-06,0.36639e-06,0.47718e-06 /)
      kbo(:,40,16) = (/ &
        & 0.38297e-06,0.36441e-06,0.32989e-06,0.30551e-06,0.28352e-06 /)
      kbo(:,41,16) = (/ &
        & 0.31987e-06,0.30430e-06,0.27838e-06,0.25513e-06,0.23647e-06 /)
      kbo(:,42,16) = (/ &
        & 0.26734e-06,0.24677e-06,0.23264e-06,0.21290e-06,0.19743e-06 /)
      kbo(:,43,16) = (/ &
        & 0.22458e-06,0.20712e-06,0.19517e-06,0.17853e-06,0.16551e-06 /)
      kbo(:,44,16) = (/ &
        & 0.18898e-06,0.17429e-06,0.16587e-06,0.15173e-06,0.13895e-06 /)
      kbo(:,45,16) = (/ &
        & 0.15450e-06,0.14658e-06,0.13533e-06,0.12759e-06,0.11679e-06 /)
      kbo(:,46,16) = (/ &
        & 0.13028e-06,0.12362e-06,0.11400e-06,0.10744e-06,0.98279e-07 /)
      kbo(:,47,16) = (/ &
        & 0.11024e-06,0.10159e-06,0.96435e-07,0.91711e-07,0.83972e-07 /)
      kbo(:,48,16) = (/ &
        & 0.93198e-07,0.85906e-07,0.81590e-07,0.75279e-07,0.70931e-07 /)
      kbo(:,49,16) = (/ &
        & 0.76236e-07,0.72626e-07,0.68995e-07,0.63641e-07,0.60530e-07 /)
      kbo(:,50,16) = (/ &
        & 0.64328e-07,0.61369e-07,0.56594e-07,0.53672e-07,0.49555e-07 /)
      kbo(:,51,16) = (/ &
        & 0.54169e-07,0.51722e-07,0.47685e-07,0.45298e-07,0.41770e-07 /)
      kbo(:,52,16) = (/ &
        & 0.46180e-07,0.42221e-07,0.40251e-07,0.37120e-07,0.35204e-07 /)
      kbo(:,53,16) = (/ &
        & 0.33194e-01,0.35538e-07,0.33930e-07,0.31297e-07,0.29712e-07 /)
      kbo(:,54,16) = (/ &
        & 0.63212e-01,0.54132e-01,0.36437e-01,0.71353e-02,0.24978e-07 /)
      kbo(:,55,16) = (/ &
        & 0.62321e-01,0.69163e-01,0.76899e-01,0.64692e-01,0.42869e-01 /)
      kbo(:,56,16) = (/ &
        & 0.73050e-01,0.83118e-01,0.74962e-01,0.82540e-01,0.91058e-01 /)
      kbo(:,57,16) = (/ &
        & 0.71162e-01,0.79898e-01,0.89953e-01,0.10014e+00,0.10382e+00 /)
      kbo(:,58,16) = (/ &
        & 0.67770e-01,0.78960e-01,0.86882e-01,0.97002e-01,0.10740e+00 /)
      kbo(:,59,16) = (/ &
        & 0.66421e-01,0.77608e-01,0.10426e+00,0.10063e+00,0.10735e+00 /)
  
!     -----------------------------------------------------------------

      forrefo(:, 1) = (/ 0.860560e-06, 0.130439e-05, 0.382378e-05 /)
      forrefo(:, 2) = (/ 0.817926e-06, 0.158599e-05, 0.658771e-04 /)
      forrefo(:, 3) = (/ 0.129369e-05, 0.824406e-05, 0.952778e-04 /)
      forrefo(:, 4) = (/ 0.438918e-05, 0.375356e-04, 0.119111e-03 /)
      forrefo(:, 5) = (/ 0.306057e-04, 0.622798e-04, 0.100740e-03 /)
      forrefo(:, 6) = (/ 0.891934e-04, 0.856393e-04, 0.635583e-04 /)
      forrefo(:, 7) = (/ 0.171959e-03, 0.173431e-03, 0.611721e-04 /)
      forrefo(:, 8) = (/ 0.357795e-03, 0.247261e-03, 0.488864e-04 /)
      forrefo(:, 9) = (/ 0.326623e-03, 0.289471e-03, 0.548834e-04 /)
      forrefo(:,10) = (/ 0.345103e-03, 0.320898e-03, 0.633214e-04 /)
      forrefo(:,11) = (/ 0.392567e-03, 0.325153e-03, 0.744479e-04 /)
      forrefo(:,12) = (/ 0.349277e-03, 0.345610e-03, 0.916479e-04 /)
      forrefo(:,13) = (/ 0.425161e-03, 0.348452e-03, 0.125788e-03 /)
      forrefo(:,14) = (/ 0.407594e-03, 0.435836e-03, 0.287583e-03 /)
      forrefo(:,15) = (/ 0.521605e-03, 0.486596e-03, 0.483511e-03 /)
      forrefo(:,16) = (/ 0.773790e-03, 0.737247e-03, 0.665939e-03 /)

!     -----------------------------------------------------------------
!     The array SELFREFO contains the coefficient of the water vapor
!     self-continuum (including the energy term).  The first index
!     refers to temperature in 7.2 degree increments.  For instance,
!     JT = 1 refers to a temperature of 245.6, JT = 2 refers to 252.8,
!     etc.  The second index runs over the g-channel (1 to 16).
           
      selfrefo(:, 1) = (/ &
        &  0.750370e-03, 0.644938e-03, 0.554321e-03, 0.476436e-03, 0.409494e-03, &
        &  0.351957e-03, 0.302505e-03, 0.260002e-03, 0.223470e-03, 0.192071e-03 /)
      selfrefo(:, 2) = (/ &
        &  0.136135e-02, 0.113187e-02, 0.941076e-03, 0.782440e-03, 0.650546e-03, &
        &  0.540885e-03, 0.449709e-03, 0.373902e-03, 0.310874e-03, 0.258471e-03 /)
      selfrefo(:, 3) = (/ &
        &  0.333950e-02, 0.256391e-02, 0.196845e-02, 0.151129e-02, 0.116030e-02, &
        &  0.890824e-03, 0.683934e-03, 0.525093e-03, 0.403143e-03, 0.309515e-03 /)
      selfrefo(:, 4) = (/ &
        &  0.793392e-02, 0.589865e-02, 0.438548e-02, 0.326048e-02, 0.242408e-02, &
        &  0.180223e-02, 0.133991e-02, 0.996186e-03, 0.740636e-03, 0.550642e-03 /)
      selfrefo(:, 5) = (/ &
        &  0.828169e-02, 0.703139e-02, 0.596984e-02, 0.506856e-02, 0.430335e-02, &
        &  0.365366e-02, 0.310206e-02, 0.263374e-02, 0.223612e-02, 0.189852e-02 /)
      selfrefo(:, 6) = (/ &
        &  0.834190e-02, 0.780225e-02, 0.729750e-02, 0.682541e-02, 0.638386e-02, &
        &  0.597087e-02, 0.558460e-02, 0.522332e-02, 0.488541e-02, 0.456936e-02 /)
      selfrefo(:, 7) = (/ &
        &  0.119082e-01, 0.112566e-01, 0.106406e-01, 0.100583e-01, 0.950785e-02, &
        &  0.898755e-02, 0.849571e-02, 0.803080e-02, 0.759132e-02, 0.717590e-02 /)
      selfrefo(:, 8) = (/ &
        &  0.144004e-01, 0.141762e-01, 0.139554e-01, 0.137381e-01, 0.135241e-01, &
        &  0.133135e-01, 0.131062e-01, 0.129021e-01, 0.127011e-01, 0.125033e-01 /)
      selfrefo(:, 9) = (/ &
        &  0.186171e-01, 0.175281e-01, 0.165027e-01, 0.155373e-01, 0.146284e-01, &
        &  0.137726e-01, 0.129670e-01, 0.122084e-01, 0.114942e-01, 0.108218e-01 /)
      selfrefo(:,10) = (/ &
        &  0.209396e-01, 0.195077e-01, 0.181737e-01, 0.169309e-01, 0.157731e-01, &
        &  0.146945e-01, 0.136897e-01, 0.127535e-01, 0.118814e-01, 0.110689e-01 /)
      selfrefo(:,11) = (/ &
        &  0.203661e-01, 0.193311e-01, 0.183487e-01, 0.174163e-01, 0.165312e-01, &
        &  0.156911e-01, 0.148937e-01, 0.141368e-01, 0.134184e-01, 0.127365e-01 /)
      selfrefo(:,12) = (/ &
        &  0.226784e-01, 0.210210e-01, 0.194848e-01, 0.180608e-01, 0.167409e-01, &
        &  0.155174e-01, 0.143834e-01, 0.133322e-01, 0.123579e-01, 0.114547e-01 /)
      selfrefo(:,13) = (/ &
        &  0.221773e-01, 0.210306e-01, 0.199433e-01, 0.189122e-01, 0.179344e-01, &
        &  0.170071e-01, 0.161278e-01, 0.152939e-01, 0.145032e-01, 0.137533e-01 /)
      selfrefo(:,14) = (/ &
        &  0.275920e-01, 0.252595e-01, 0.231241e-01, 0.211693e-01, 0.193797e-01, &
        &  0.177415e-01, 0.162417e-01, 0.148687e-01, 0.136117e-01, 0.124610e-01 /)
      selfrefo(:,15) = (/ &
        &  0.288687e-01, 0.269968e-01, 0.252462e-01, 0.236092e-01, 0.220783e-01, &
        &  0.206466e-01, 0.193078e-01, 0.180559e-01, 0.168851e-01, 0.157902e-01 /)
      selfrefo(:,16) = (/ &
        &  0.371842e-01, 0.347595e-01, 0.324929e-01, 0.303741e-01, 0.283934e-01, &
        &  0.265419e-01, 0.248112e-01, 0.231933e-01, 0.216809e-01, 0.202671e-01 /)
  
      end subroutine sw_kgb18
