!     path:      $Source$
!     author:    $Author$
!     revision:  $Revision$
!     created:   $Date$

!----------------------------------------------------------------------------
! Copyright (c) 2002-2016, Atmospheric & Environmental Research, Inc. (AER)
! All rights reserved.
!
! Redistribution and use in source and binary forms, with or without
! modification, are permitted provided that the following conditions are met:
!  * Redistributions of source code must retain the above copyright
!    notice, this list of conditions and the following disclaimer.
!  * Redistributions in binary form must reproduce the above copyright
!    notice, this list of conditions and the following disclaimer in the
!    documentation and/or other materials provided with the distribution.
!  * Neither the name of Atmospheric & Environmental Research, Inc., nor
!    the names of its contributors may be used to endorse or promote products
!    derived from this software without specific prior written permission.
!
! THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
! AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
! IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
! ARE DISCLAIMED. IN NO EVENT SHALL ATMOSPHERIC & ENVIRONMENTAL RESEARCH, INC., 
! BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
! CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
! SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
! INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
! CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
! ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
! THE POSSIBILITY OF SUCH DAMAGE.
!                        (http://www.rtweb.aer.com/)                        
!----------------------------------------------------------------------------

! **************************************************************************
!      subroutine sw_kgbnn
! **************************************************************************
!  RRTM Shortwave Radiative Transfer Model
!  Atmospheric and Environmental Research, Inc., Cambridge, MA
!
!  Original by J.Delamere, Atmospheric & Environmental Research.
!  Reformatted for F90: JJMorcrette, ECMWF
!  Further F90 and GCM revisions:  MJIacono, AER, July 2002
!  Solar variability revisions:  MJIacono, AER, November 2015
!
!  This file contains 14 subroutines that include the 
!  absorption coefficients and other data for each of the 14 shortwave
!  spectral bands used in RRTM_SW.  Here, the data are defined for 16
!  g-points, or sub-intervals, per band.  These data are combined and
!  weighted using a mapping procedure in routine RRTMG_SW_INIT to reduce
!  the total number of g-points from 224 to 112 for use in the GCM.
! **************************************************************************
      subroutine sw_kgb17
! **************************************************************************

      !use parkind, only : im => kind , rb => kind  
      use rrsw_kg17, only : kao, kbo, selfrefo, forrefo, sfluxrefo, rayl, &
                            irradnceo, facbrghto, snsptdrko

      implicit none
      save

! Kurucz solar source function
      sfluxrefo(:,1) = (/ &
        & 3.15613  ,  3.03449  ,  2.92069  ,  2.63874   , &
        & 2.34581  ,  2.06999  ,  1.70906  ,  1.29085   , &
        & 0.874851 ,  0.0955392,  0.0787813,  0.0621951 , &
        & 0.0459076,  0.0294129,  0.0110387,  0.00159668 /)
      sfluxrefo(:,2) = (/ &
        & 2.83147  ,  2.95919  ,  2.96674  ,  2.77677   , &
        & 2.46826  ,  2.11481  ,  1.73243  ,  1.30279   , &
        & 0.882714 ,  0.0962350,  0.0802122,  0.0636194 , &
        & 0.0472620,  0.0299051,  0.0110785,  0.00159668 /)
      sfluxrefo(:,3) = (/ &
        & 2.82300  ,  2.94845  ,  2.95887  ,  2.77593   , &
        & 2.47096  ,  2.12596  ,  1.73847  ,  1.30796   , &
        & 0.884395 ,  0.0966936,  0.0801996,  0.0640199 , &
        & 0.0472803,  0.0300515,  0.0112366,  0.00160814 /)
      sfluxrefo(:,4) = (/ &
        & 2.81715  ,  2.93789  ,  2.95091  ,  2.77046   , &
        & 2.47716  ,  2.13591  ,  1.74365  ,  1.31277   , &
        & 0.887443 ,  0.0967016,  0.0803391,  0.0642442 , &
        & 0.0472909,  0.0300720,  0.0114817,  0.00161875 /)
      sfluxrefo(:,5) = (/ &
        & 2.82335  ,  2.93168  ,  2.91455  ,  2.75213   , &
        & 2.49168  ,  2.14408  ,  1.75726  ,  1.32401   , &
        & 0.893644 ,  0.0969523,  0.0805197,  0.0639936 , &
        & 0.0475099,  0.0305667,  0.0115372,  0.00161875 /)

! Solar variability components: time-invariant baseline quiet sun irradiance
      irradnceo(:,1) = (/ &
        & 3.00380E+00, 3.01499E+00, 2.88453E+00, 2.66215E+00,&
        & 2.41145E+00, 2.07054E+00, 1.69908E+00, 1.28167E+00,&
        & 8.67239E-01, 9.46462E-02, 7.80535E-02, 6.16168E-02,&
        & 4.54819E-02, 2.91472E-02, 1.09384E-02, 1.58227E-03/)
      irradnceo(:,2) = (/ &
        & 2.78291E+00, 2.95184E+00, 2.94616E+00, 2.75630E+00,&
        & 2.45861E+00, 2.10312E+00, 1.72152E+00, 1.29314E+00,&
        & 8.76016E-01, 9.54462E-02, 7.95557E-02, 6.31187E-02,&
        & 4.69116E-02, 2.97081E-02, 1.09937E-02, 1.58227E-03/)
      irradnceo(:,3) = (/ &
        & 2.77881E+00, 2.92869E+00, 2.94671E+00, 2.75619E+00,&
        & 2.46125E+00, 2.11314E+00, 1.72657E+00, 1.29878E+00,&
        & 8.78235E-01, 9.59533E-02, 7.95652E-02, 6.34930E-02,&
        & 4.69402E-02, 2.98560E-02, 1.11600E-02, 1.60267E-03/)
      irradnceo(:,4) = (/ &
        & 2.77427E+00, 2.92613E+00, 2.92863E+00, 2.75471E+00,&
        & 2.46413E+00, 2.12275E+00, 1.73162E+00, 1.30408E+00,&
        & 8.81320E-01, 9.59524E-02, 7.97535E-02, 6.37490E-02,&
        & 4.69216E-02, 2.98679E-02, 1.14332E-02, 1.61722E-03/)
      irradnceo(:,5) = (/ &
        & 2.75976E+00, 2.93480E+00, 2.89604E+00, 2.72071E+00,&
        & 2.46217E+00, 2.14116E+00, 1.75435E+00, 1.32404E+00,&
        & 8.93287E-01, 9.64493E-02, 7.99754E-02, 6.35176E-02,&
        & 4.71787E-02, 3.03769E-02, 1.14846E-02, 1.61722E-03/)
! Solar variability components: facular brightening
      facbrghto(:,1) = (/ &
        & 7.92679E-04, 7.90259E-04, 7.50265E-04, 6.86566E-04,&
        & 6.13488E-04, 5.12914E-04, 4.13317E-04, 3.10175E-04,&
        & 2.10234E-04, 2.29639E-05, 1.89746E-05, 1.49935E-05,&
        & 1.10311E-05, 7.04437E-06, 2.64054E-06, 3.76806E-07/)
      facbrghto(:,2) = (/ &
        & 7.24729E-04, 7.68724E-04, 7.64896E-04, 7.08831E-04,&
        & 6.23760E-04, 5.23886E-04, 4.25169E-04, 3.19603E-04,&
        & 2.17156E-04, 2.36660E-05, 1.97404E-05, 1.56597E-05,&
        & 1.16608E-05, 7.39474E-06, 2.67023E-06, 3.76806E-07/)
      facbrghto(:,3) = (/ &
        & 7.22453E-04, 7.59373E-04, 7.64513E-04, 7.07591E-04,&
        & 6.22956E-04, 5.28244E-04, 4.28829E-04, 3.23029E-04,&
        & 2.19000E-04, 2.39727E-05, 1.98054E-05, 1.57951E-05,&
        & 1.17384E-05, 7.46055E-06, 2.76650E-06, 3.94737E-07/)
      facbrghto(:,4) = (/ &
        & 7.19944E-04, 7.57664E-04, 7.55804E-04, 7.06804E-04,&
        & 6.21975E-04, 5.33055E-04, 4.32950E-04, 3.26216E-04,&
        & 2.21019E-04, 2.40765E-05, 1.99104E-05, 1.59777E-05,&
        & 1.17605E-05, 7.46496E-06, 2.88424E-06, 4.17580E-07/)
      facbrghto(:,5) = (/ &
        & 7.10164E-04, 7.49716E-04, 7.35392E-04, 6.93190E-04,&
        & 6.27365E-04, 5.47220E-04, 4.47370E-04, 3.36835E-04,&
        & 2.26764E-04, 2.45333E-05, 2.03053E-05, 1.60363E-05,&
        & 1.19581E-05, 7.72650E-06, 2.93031E-06, 4.17580E-07/)
! Solar variability components: sunspot darkening
      snsptdrko(:,1) = (/ &
        &-3.59484E-04,-3.65300E-04,-3.48916E-04,-3.20756E-04,&
        &-2.90556E-04,-2.45378E-04,-2.00296E-04,-1.50935E-04,&
        &-1.02160E-04,-1.11770E-05,-9.21224E-06,-7.26637E-06,&
        &-5.35918E-06,-3.44009E-06,-1.29143E-06,-1.88663E-07/)
      snsptdrko(:,2) = (/ &
        &-3.21006E-04,-3.55162E-04,-3.59974E-04,-3.35589E-04,&
        &-2.96374E-04,-2.51058E-04,-2.05001E-04,-1.53920E-04,&
        &-1.04476E-04,-1.13950E-05,-9.51824E-06,-7.55462E-06,&
        &-5.64173E-06,-3.55839E-06,-1.30018E-06,-1.88663E-07/)
      snsptdrko(:,3) = (/ &
        &-3.20043E-04,-3.50843E-04,-3.60160E-04,-3.35247E-04,&
        &-2.96458E-04,-2.53066E-04,-2.06254E-04,-1.55161E-04,&
        &-1.05030E-04,-1.15221E-05,-9.52632E-06,-7.62653E-06,&
        &-5.65949E-06,-3.59072E-06,-1.33606E-06,-1.91522E-07/)
      snsptdrko(:,4) = (/ &
        &-3.18913E-04,-3.50362E-04,-3.56389E-04,-3.35108E-04,&
        &-2.96722E-04,-2.54950E-04,-2.07581E-04,-1.56352E-04,&
        &-1.05703E-04,-1.15254E-05,-9.57868E-06,-7.69098E-06,&
        &-5.66733E-06,-3.59649E-06,-1.38271E-06,-1.95898E-07/)
      snsptdrko(:,5) = (/ &
        &-3.14466E-04,-3.48952E-04,-3.47912E-04,-3.28476E-04,&
        &-2.98297E-04,-2.60496E-04,-2.13593E-04,-1.61075E-04,&
        &-1.08403E-04,-1.16544E-05,-9.68748E-06,-7.68153E-06,&
        &-5.73245E-06,-3.70217E-06,-1.39400E-06,-1.95898E-07/)

! Rayleigh extinction coefficient at v = 3625 cm-1.
      rayl = 6.86e-10

!     ------------------------------------------------------------------
!     The array KAO contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels> ~100mb, temperatures, and binary
!     species parameters (see taumol.f for definition).  The first 
!     index in the array, JS, runs from 1 to 9, and corresponds to 
!     different values of the binary species parameter.  For instance, 
!     JS=1 refers to dry air, JS = 2 corresponds to the paramter value 1/8, 
!     JS = 3 corresponds to the parameter value 2/8, etc.  The second index
!     in the array, JT, which runs from 1 to 5, corresponds to different
!     temperatures.  More specifically, JT = 3 means that the data are for
!     the reference temperature TREF for this  pressure level, JT = 2 refers
!     to TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and JT = 5
!     is for TREF+30.  The third index, JP, runs from 1 to 13 and refers
!     to the JPth reference pressure level (see taumol.f for these levels
!     in mb).  The fourth index, IG, goes from 1 to 16, and indicates
!     which g-interval the absorption coefficients are for.
!     -----------------------------------------------------------------

      kao(:, 1, 1, 1) = (/ &
        & 0.11134e-05,0.32092e-03,0.55663e-03,0.78227e-03,0.99421e-03, &
        & 0.12045e-02,0.14116e-02,0.16069e-02,0.19330e-02 /)
      kao(:, 2, 1, 1) = (/ &
        & 0.10544e-05,0.35434e-03,0.61480e-03,0.86424e-03,0.11055e-02, &
        & 0.13431e-02,0.15754e-02,0.17951e-02,0.21280e-02 /)
      kao(:, 3, 1, 1) = (/ &
        & 0.98345e-06,0.38989e-03,0.67747e-03,0.95289e-03,0.12196e-02, &
        & 0.14864e-02,0.17449e-02,0.19897e-02,0.23564e-02 /)
      kao(:, 4, 1, 1) = (/ &
        & 0.95017e-06,0.42582e-03,0.74419e-03,0.10463e-02,0.13424e-02, &
        & 0.16353e-02,0.19215e-02,0.21939e-02,0.25993e-02 /)
      kao(:, 5, 1, 1) = (/ &
        & 0.91870e-06,0.46371e-03,0.81394e-03,0.11464e-02,0.14715e-02, &
        & 0.17937e-02,0.21072e-02,0.24077e-02,0.28540e-02 /)
      kao(:, 1, 2, 1) = (/ &
        & 0.94184e-06,0.26532e-03,0.46157e-03,0.63776e-03,0.81087e-03, &
        & 0.97728e-03,0.11419e-02,0.12991e-02,0.15121e-02 /)
      kao(:, 2, 2, 1) = (/ &
        & 0.89060e-06,0.29417e-03,0.50967e-03,0.70759e-03,0.90203e-03, &
        & 0.10920e-02,0.12764e-02,0.14544e-02,0.16795e-02 /)
      kao(:, 3, 2, 1) = (/ &
        & 0.82720e-06,0.32361e-03,0.56124e-03,0.78299e-03,0.99718e-03, &
        & 0.12094e-02,0.14172e-02,0.16165e-02,0.18637e-02 /)
      kao(:, 4, 2, 1) = (/ &
        & 0.78842e-06,0.35495e-03,0.61684e-03,0.86176e-03,0.10995e-02, &
        & 0.13345e-02,0.15652e-02,0.17856e-02,0.20621e-02 /)
      kao(:, 5, 2, 1) = (/ &
        & 0.76610e-06,0.38728e-03,0.67538e-03,0.94613e-03,0.12082e-02, &
        & 0.14675e-02,0.17206e-02,0.19640e-02,0.22720e-02 /)
      kao(:, 1, 3, 1) = (/ &
        & 0.79663e-06,0.21369e-03,0.37088e-03,0.51222e-03,0.64549e-03, &
        & 0.77322e-03,0.89939e-03,0.10205e-02,0.11568e-02 /)
      kao(:, 2, 3, 1) = (/ &
        & 0.75955e-06,0.23780e-03,0.41153e-03,0.56901e-03,0.72009e-03, &
        & 0.86735e-03,0.10092e-02,0.11476e-02,0.12913e-02 /)
      kao(:, 3, 3, 1) = (/ &
        & 0.71692e-06,0.26276e-03,0.45488e-03,0.62922e-03,0.79836e-03, &
        & 0.96259e-03,0.11236e-02,0.12796e-02,0.14398e-02 /)
      kao(:, 4, 3, 1) = (/ &
        & 0.66348e-06,0.28896e-03,0.50221e-03,0.69411e-03,0.88226e-03, &
        & 0.10658e-02,0.12456e-02,0.14191e-02,0.15991e-02 /)
      kao(:, 5, 3, 1) = (/ &
        & 0.64013e-06,0.31643e-03,0.55166e-03,0.76434e-03,0.97216e-03, &
        & 0.11745e-02,0.13731e-02,0.15657e-02,0.17671e-02 /)
      kao(:, 1, 4, 1) = (/ &
        & 0.66217e-06,0.16966e-03,0.29358e-03,0.40688e-03,0.51114e-03, &
        & 0.60739e-03,0.70191e-03,0.79446e-03,0.88832e-03 /)
      kao(:, 2, 4, 1) = (/ &
        & 0.64111e-06,0.18902e-03,0.32742e-03,0.45364e-03,0.57086e-03, &
        & 0.68401e-03,0.79116e-03,0.89507e-03,0.99655e-03 /)
      kao(:, 3, 4, 1) = (/ &
        & 0.60729e-06,0.21007e-03,0.36354e-03,0.50354e-03,0.63459e-03, &
        & 0.76113e-03,0.88473e-03,0.10035e-02,0.11163e-02 /)
      kao(:, 4, 4, 1) = (/ &
        & 0.57250e-06,0.23203e-03,0.40245e-03,0.55758e-03,0.70295e-03, &
        & 0.84515e-03,0.98379e-03,0.11165e-02,0.12444e-02 /)
      kao(:, 5, 4, 1) = (/ &
        & 0.53524e-06,0.25529e-03,0.44399e-03,0.61564e-03,0.77626e-03, &
        & 0.93405e-03,0.10892e-02,0.12369e-02,0.13795e-02 /)
      kao(:, 1, 5, 1) = (/ &
        & 0.55112e-06,0.13422e-03,0.23166e-03,0.32119e-03,0.40265e-03, &
        & 0.47812e-03,0.54797e-03,0.61873e-03,0.68912e-03 /)
      kao(:, 2, 5, 1) = (/ &
        & 0.53669e-06,0.14990e-03,0.25949e-03,0.35886e-03,0.45239e-03, &
        & 0.53936e-03,0.61894e-03,0.69718e-03,0.77732e-03 /)
      kao(:, 3, 5, 1) = (/ &
        & 0.51495e-06,0.16706e-03,0.28960e-03,0.40020e-03,0.50461e-03, &
        & 0.60249e-03,0.69677e-03,0.78464e-03,0.87334e-03 /)
      kao(:, 4, 5, 1) = (/ &
        & 0.48633e-06,0.18543e-03,0.32159e-03,0.44499e-03,0.56095e-03, &
        & 0.67055e-03,0.77575e-03,0.87717e-03,0.97694e-03 /)
      kao(:, 5, 5, 1) = (/ &
        & 0.45162e-06,0.20472e-03,0.35591e-03,0.49350e-03,0.62163e-03, &
        & 0.74253e-03,0.86247e-03,0.97518e-03,0.10864e-02 /)
      kao(:, 1, 6, 1) = (/ &
        & 0.45055e-06,0.10556e-03,0.18176e-03,0.25137e-03,0.31438e-03, &
        & 0.37363e-03,0.42759e-03,0.47883e-03,0.53437e-03 /)
      kao(:, 2, 6, 1) = (/ &
        & 0.44502e-06,0.11814e-03,0.20383e-03,0.28162e-03,0.35547e-03, &
        & 0.42261e-03,0.48340e-03,0.54066e-03,0.60352e-03 /)
      kao(:, 3, 6, 1) = (/ &
        & 0.43066e-06,0.13217e-03,0.22836e-03,0.31552e-03,0.39762e-03, &
        & 0.47493e-03,0.54543e-03,0.61066e-03,0.68176e-03 /)
      kao(:, 4, 6, 1) = (/ &
        & 0.41116e-06,0.14733e-03,0.25472e-03,0.35204e-03,0.44334e-03, &
        & 0.52997e-03,0.60966e-03,0.68622e-03,0.76607e-03 /)
      kao(:, 5, 6, 1) = (/ &
        & 0.38748e-06,0.16344e-03,0.28281e-03,0.39173e-03,0.49305e-03, &
        & 0.58880e-03,0.67954e-03,0.76485e-03,0.85401e-03 /)
      kao(:, 1, 7, 1) = (/ &
        & 0.36582e-06,0.82958e-04,0.14210e-03,0.19574e-03,0.24440e-03, &
        & 0.29039e-03,0.33281e-03,0.37177e-03,0.42178e-03 /)
      kao(:, 2, 7, 1) = (/ &
        & 0.36707e-06,0.92909e-04,0.15977e-03,0.22034e-03,0.27742e-03, &
        & 0.32955e-03,0.37727e-03,0.41956e-03,0.47859e-03 /)
      kao(:, 3, 7, 1) = (/ &
        & 0.35787e-06,0.10432e-03,0.17930e-03,0.24769e-03,0.31155e-03, &
        & 0.37242e-03,0.42699e-03,0.47474e-03,0.54083e-03 /)
      kao(:, 4, 7, 1) = (/ &
        & 0.34482e-06,0.11685e-03,0.20055e-03,0.27725e-03,0.34866e-03, &
        & 0.41677e-03,0.47903e-03,0.53518e-03,0.60812e-03 /)
      kao(:, 5, 7, 1) = (/ &
        & 0.32598e-06,0.13001e-03,0.22341e-03,0.30900e-03,0.38919e-03, &
        & 0.46465e-03,0.53467e-03,0.59926e-03,0.67733e-03 /)
      kao(:, 1, 8, 1) = (/ &
        & 0.29834e-06,0.65009e-04,0.11183e-03,0.15200e-03,0.18969e-03, &
        & 0.22517e-03,0.25832e-03,0.28730e-03,0.33955e-03 /)
      kao(:, 2, 8, 1) = (/ &
        & 0.29745e-06,0.72872e-04,0.12482e-03,0.17221e-03,0.21583e-03, &
        & 0.25596e-03,0.29328e-03,0.32520e-03,0.38620e-03 /)
      kao(:, 3, 8, 1) = (/ &
        & 0.29421e-06,0.82036e-04,0.14010e-03,0.19344e-03,0.24362e-03, &
        & 0.29071e-03,0.33308e-03,0.36867e-03,0.43901e-03 /)
      kao(:, 4, 8, 1) = (/ &
        & 0.28596e-06,0.92256e-04,0.15738e-03,0.21752e-03,0.27325e-03, &
        & 0.32643e-03,0.37578e-03,0.41710e-03,0.49358e-03 /)
      kao(:, 5, 8, 1) = (/ &
        & 0.27296e-06,0.10320e-03,0.17598e-03,0.24339e-03,0.30591e-03, &
        & 0.36505e-03,0.42061e-03,0.46872e-03,0.54993e-03 /)
      kao(:, 1, 9, 1) = (/ &
        & 0.24259e-06,0.50626e-04,0.86945e-04,0.11778e-03,0.14692e-03, &
        & 0.17431e-03,0.20057e-03,0.22131e-03,0.29919e-03 /)
      kao(:, 2, 9, 1) = (/ &
        & 0.24058e-06,0.56966e-04,0.97467e-04,0.13405e-03,0.16750e-03, &
        & 0.19814e-03,0.22739e-03,0.25281e-03,0.34022e-03 /)
      kao(:, 3, 9, 1) = (/ &
        & 0.24091e-06,0.64324e-04,0.10971e-03,0.15061e-03,0.18996e-03, &
        & 0.22580e-03,0.25885e-03,0.28694e-03,0.38045e-03 /)
      kao(:, 4, 9, 1) = (/ &
        & 0.23550e-06,0.72451e-04,0.12345e-03,0.16991e-03,0.21362e-03, &
        & 0.25484e-03,0.29341e-03,0.32523e-03,0.42836e-03 /)
      kao(:, 5, 9, 1) = (/ &
        & 0.22696e-06,0.81351e-04,0.13839e-03,0.19090e-03,0.23986e-03, &
        & 0.28608e-03,0.32910e-03,0.36639e-03,0.47925e-03 /)
      kao(:, 1,10, 1) = (/ &
        & 0.19679e-06,0.39760e-04,0.68052e-04,0.92295e-04,0.11498e-03, &
        & 0.13656e-03,0.15604e-03,0.17171e-03,0.29679e-03 /)
      kao(:, 2,10, 1) = (/ &
        & 0.19567e-06,0.44847e-04,0.76829e-04,0.10518e-03,0.13102e-03, &
        & 0.15509e-03,0.17764e-03,0.19843e-03,0.32863e-03 /)
      kao(:, 3,10, 1) = (/ &
        & 0.19574e-06,0.50565e-04,0.86466e-04,0.11878e-03,0.14920e-03, &
        & 0.17698e-03,0.20258e-03,0.22526e-03,0.36959e-03 /)
      kao(:, 4,10, 1) = (/ &
        & 0.19262e-06,0.57124e-04,0.97546e-04,0.13398e-03,0.16803e-03, &
        & 0.20046e-03,0.23022e-03,0.25578e-03,0.41543e-03 /)
      kao(:, 5,10, 1) = (/ &
        & 0.18747e-06,0.64264e-04,0.10971e-03,0.15086e-03,0.18923e-03, &
        & 0.22565e-03,0.25934e-03,0.28921e-03,0.46463e-03 /)
      kao(:, 1,11, 1) = (/ &
        & 0.16015e-06,0.33025e-04,0.56562e-04,0.76625e-04,0.95645e-04, &
        & 0.11358e-03,0.12955e-03,0.14269e-03,0.27545e-03 /)
      kao(:, 2,11, 1) = (/ &
        & 0.15918e-06,0.37148e-04,0.63775e-04,0.87600e-04,0.10897e-03, &
        & 0.12893e-03,0.14756e-03,0.16465e-03,0.30799e-03 /)
      kao(:, 3,11, 1) = (/ &
        & 0.15897e-06,0.41993e-04,0.72040e-04,0.98928e-04,0.12433e-03, &
        & 0.14733e-03,0.16824e-03,0.18694e-03,0.34340e-03 /)
      kao(:, 4,11, 1) = (/ &
        & 0.15578e-06,0.47441e-04,0.81426e-04,0.11165e-03,0.13985e-03, &
        & 0.16673e-03,0.19156e-03,0.21268e-03,0.38176e-03 /)
      kao(:, 5,11, 1) = (/ &
        & 0.15210e-06,0.53398e-04,0.91657e-04,0.12592e-03,0.15769e-03, &
        & 0.18781e-03,0.21569e-03,0.24069e-03,0.42228e-03 /)
      kao(:, 1,12, 1) = (/ &
        & 0.13021e-06,0.27272e-04,0.46832e-04,0.63511e-04,0.79205e-04, &
        & 0.93949e-04,0.10719e-03,0.11827e-03,0.23944e-03 /)
      kao(:, 2,12, 1) = (/ &
        & 0.12930e-06,0.30686e-04,0.52925e-04,0.72782e-04,0.90527e-04, &
        & 0.10708e-03,0.12236e-03,0.13620e-03,0.27121e-03 /)
      kao(:, 3,12, 1) = (/ &
        & 0.12900e-06,0.34723e-04,0.59867e-04,0.82205e-04,0.10326e-03, &
        & 0.12238e-03,0.13958e-03,0.15498e-03,0.29930e-03 /)
      kao(:, 4,12, 1) = (/ &
        & 0.12648e-06,0.39252e-04,0.67618e-04,0.92949e-04,0.11636e-03, &
        & 0.13835e-03,0.15924e-03,0.17653e-03,0.33050e-03 /)
      kao(:, 5,12, 1) = (/ &
        & 0.12299e-06,0.44213e-04,0.76244e-04,0.10488e-03,0.13135e-03, &
        & 0.15601e-03,0.17902e-03,0.19976e-03,0.36579e-03 /)
      kao(:, 1,13, 1) = (/ &
        & 0.10554e-06,0.22388e-04,0.38597e-04,0.52378e-04,0.65404e-04, &
        & 0.77567e-04,0.88543e-04,0.97801e-04,0.19599e-03 /)
      kao(:, 2,13, 1) = (/ &
        & 0.10480e-06,0.25181e-04,0.43670e-04,0.60205e-04,0.74883e-04, &
        & 0.88605e-04,0.10117e-03,0.11242e-03,0.22146e-03 /)
      kao(:, 3,13, 1) = (/ &
        & 0.10429e-06,0.28530e-04,0.49422e-04,0.68039e-04,0.85435e-04, &
        & 0.10136e-03,0.11557e-03,0.12828e-03,0.24447e-03 /)
      kao(:, 4,13, 1) = (/ &
        & 0.10232e-06,0.32301e-04,0.55797e-04,0.76948e-04,0.96447e-04, &
        & 0.11462e-03,0.13166e-03,0.14616e-03,0.26999e-03 /)
      kao(:, 5,13, 1) = (/ &
        & 0.99014e-07,0.36394e-04,0.62994e-04,0.86946e-04,0.10900e-03, &
        & 0.12937e-03,0.14833e-03,0.16540e-03,0.29916e-03 /)
      kao(:, 1, 1, 2) = (/ &
        & 0.23488e-04,0.16684e-02,0.29575e-02,0.40083e-02,0.49953e-02, &
        & 0.59021e-02,0.67446e-02,0.76008e-02,0.87032e-02 /)
      kao(:, 2, 1, 2) = (/ &
        & 0.25156e-04,0.18462e-02,0.32711e-02,0.45008e-02,0.56182e-02, &
        & 0.66287e-02,0.75909e-02,0.85558e-02,0.97543e-02 /)
      kao(:, 3, 1, 2) = (/ &
        & 0.27084e-04,0.20325e-02,0.36034e-02,0.49992e-02,0.62796e-02, &
        & 0.74134e-02,0.84994e-02,0.95694e-02,0.10847e-01 /)
      kao(:, 4, 1, 2) = (/ &
        & 0.28147e-04,0.22347e-02,0.39628e-02,0.55005e-02,0.69453e-02, &
        & 0.82429e-02,0.94699e-02,0.10660e-01,0.11991e-01 /)
      kao(:, 5, 1, 2) = (/ &
        & 0.28719e-04,0.24475e-02,0.43369e-02,0.60360e-02,0.76183e-02, &
        & 0.90878e-02,0.10493e-01,0.11805e-01,0.13204e-01 /)
      kao(:, 1, 2, 2) = (/ &
        & 0.20947e-04,0.14015e-02,0.24728e-02,0.33676e-02,0.41801e-02, &
        & 0.49244e-02,0.55787e-02,0.62206e-02,0.69741e-02 /)
      kao(:, 2, 2, 2) = (/ &
        & 0.22352e-04,0.15535e-02,0.27396e-02,0.37870e-02,0.47121e-02, &
        & 0.55571e-02,0.62892e-02,0.70132e-02,0.78092e-02 /)
      kao(:, 3, 2, 2) = (/ &
        & 0.23882e-04,0.17213e-02,0.30345e-02,0.42020e-02,0.52782e-02, &
        & 0.62285e-02,0.70556e-02,0.78819e-02,0.87330e-02 /)
      kao(:, 4, 2, 2) = (/ &
        & 0.24650e-04,0.18954e-02,0.33384e-02,0.46336e-02,0.58333e-02, &
        & 0.69311e-02,0.78751e-02,0.88149e-02,0.96911e-02 /)
      kao(:, 5, 2, 2) = (/ &
        & 0.25136e-04,0.20806e-02,0.36641e-02,0.50966e-02,0.64193e-02, &
        & 0.76281e-02,0.87403e-02,0.97943e-02,0.10704e-01 /)
      kao(:, 1, 3, 2) = (/ &
        & 0.17720e-04,0.11414e-02,0.20045e-02,0.27288e-02,0.33891e-02, &
        & 0.39755e-02,0.44967e-02,0.49389e-02,0.53858e-02 /)
      kao(:, 2, 3, 2) = (/ &
        & 0.19087e-04,0.12745e-02,0.22336e-02,0.30841e-02,0.38333e-02, &
        & 0.44983e-02,0.50895e-02,0.55930e-02,0.60666e-02 /)
      kao(:, 3, 3, 2) = (/ &
        & 0.20125e-04,0.14178e-02,0.24795e-02,0.34278e-02,0.43106e-02, &
        & 0.50607e-02,0.57280e-02,0.63092e-02,0.68285e-02 /)
      kao(:, 4, 3, 2) = (/ &
        & 0.20895e-04,0.15666e-02,0.27348e-02,0.37934e-02,0.47769e-02, &
        & 0.56621e-02,0.64046e-02,0.70864e-02,0.76026e-02 /)
      kao(:, 5, 3, 2) = (/ &
        & 0.21508e-04,0.17251e-02,0.30153e-02,0.41809e-02,0.52689e-02, &
        & 0.62462e-02,0.71125e-02,0.79104e-02,0.84389e-02 /)
      kao(:, 1, 4, 2) = (/ &
        & 0.14661e-04,0.92261e-03,0.16088e-02,0.21788e-02,0.26956e-02, &
        & 0.31612e-02,0.35626e-02,0.38878e-02,0.41525e-02 /)
      kao(:, 2, 4, 2) = (/ &
        & 0.15607e-04,0.10329e-02,0.17973e-02,0.24735e-02,0.30696e-02, &
        & 0.35953e-02,0.40511e-02,0.44162e-02,0.46990e-02 /)
      kao(:, 3, 4, 2) = (/ &
        & 0.16559e-04,0.11550e-02,0.20019e-02,0.27577e-02,0.34625e-02, &
        & 0.40662e-02,0.45831e-02,0.49995e-02,0.53073e-02 /)
      kao(:, 4, 4, 2) = (/ &
        & 0.17263e-04,0.12794e-02,0.22184e-02,0.30614e-02,0.38510e-02, &
        & 0.45664e-02,0.51532e-02,0.56290e-02,0.59436e-02 /)
      kao(:, 5, 4, 2) = (/ &
        & 0.17895e-04,0.14130e-02,0.24526e-02,0.33805e-02,0.42622e-02, &
        & 0.50556e-02,0.57489e-02,0.63094e-02,0.66256e-02 /)
      kao(:, 1, 5, 2) = (/ &
        & 0.11885e-04,0.74888e-03,0.12826e-02,0.17258e-02,0.21346e-02, &
        & 0.24972e-02,0.28046e-02,0.30606e-02,0.32323e-02 /)
      kao(:, 2, 5, 2) = (/ &
        & 0.12452e-04,0.84084e-03,0.14380e-02,0.19698e-02,0.24386e-02, &
        & 0.28536e-02,0.32075e-02,0.34937e-02,0.36562e-02 /)
      kao(:, 3, 5, 2) = (/ &
        & 0.13439e-04,0.94272e-03,0.16065e-02,0.22079e-02,0.27660e-02, &
        & 0.32389e-02,0.36440e-02,0.39673e-02,0.41393e-02 /)
      kao(:, 4, 5, 2) = (/ &
        & 0.14053e-04,0.10473e-02,0.17899e-02,0.24603e-02,0.30861e-02, &
        & 0.36521e-02,0.41156e-02,0.44825e-02,0.46529e-02 /)
      kao(:, 5, 5, 2) = (/ &
        & 0.14586e-04,0.11585e-02,0.19886e-02,0.27257e-02,0.34272e-02, &
        & 0.40599e-02,0.46115e-02,0.50286e-02,0.52085e-02 /)
      kao(:, 1, 6, 2) = (/ &
        & 0.94872e-05,0.59793e-03,0.10210e-02,0.13572e-02,0.16716e-02, &
        & 0.19512e-02,0.21890e-02,0.23827e-02,0.25347e-02 /)
      kao(:, 2, 6, 2) = (/ &
        & 0.10060e-04,0.67400e-03,0.11432e-02,0.15564e-02,0.19188e-02, &
        & 0.22389e-02,0.25161e-02,0.27308e-02,0.28770e-02 /)
      kao(:, 3, 6, 2) = (/ &
        & 0.10743e-04,0.75948e-03,0.12806e-02,0.17551e-02,0.21862e-02, &
        & 0.25545e-02,0.28729e-02,0.31149e-02,0.32716e-02 /)
      kao(:, 4, 6, 2) = (/ &
        & 0.11322e-04,0.85134e-03,0.14320e-02,0.19630e-02,0.24514e-02, &
        & 0.28930e-02,0.32578e-02,0.35375e-02,0.36912e-02 /)
      kao(:, 5, 6, 2) = (/ &
        & 0.11755e-04,0.94611e-03,0.15986e-02,0.21804e-02,0.27291e-02, &
        & 0.32306e-02,0.36695e-02,0.39913e-02,0.41439e-02 /)
      kao(:, 1, 7, 2) = (/ &
        & 0.75931e-05,0.47130e-03,0.81211e-03,0.10658e-02,0.13004e-02, &
        & 0.15175e-02,0.17002e-02,0.18473e-02,0.19861e-02 /)
      kao(:, 2, 7, 2) = (/ &
        & 0.80724e-05,0.53358e-03,0.91163e-03,0.12261e-02,0.15014e-02, &
        & 0.17483e-02,0.19612e-02,0.21201e-02,0.22591e-02 /)
      kao(:, 3, 7, 2) = (/ &
        & 0.84404e-05,0.60517e-03,0.10236e-02,0.13887e-02,0.17204e-02, &
        & 0.20031e-02,0.22497e-02,0.24321e-02,0.25823e-02 /)
      kao(:, 4, 7, 2) = (/ &
        & 0.90511e-05,0.68037e-03,0.11475e-02,0.15596e-02,0.19402e-02, &
        & 0.22789e-02,0.25633e-02,0.27753e-02,0.29247e-02 /)
      kao(:, 5, 7, 2) = (/ &
        & 0.94405e-05,0.76103e-03,0.12836e-02,0.17422e-02,0.21698e-02, &
        & 0.25585e-02,0.28989e-02,0.31444e-02,0.33016e-02 /)
      kao(:, 1, 8, 2) = (/ &
        & 0.58080e-05,0.36782e-03,0.63516e-03,0.83799e-03,0.10119e-02, &
        & 0.11754e-02,0.13161e-02,0.14382e-02,0.15837e-02 /)
      kao(:, 2, 8, 2) = (/ &
        & 0.63156e-05,0.41909e-03,0.71974e-03,0.96952e-03,0.11711e-02, &
        & 0.13617e-02,0.15234e-02,0.16441e-02,0.18118e-02 /)
      kao(:, 3, 8, 2) = (/ &
        & 0.66776e-05,0.47829e-03,0.81150e-03,0.11056e-02,0.13493e-02, &
        & 0.15646e-02,0.17524e-02,0.18937e-02,0.20698e-02 /)
      kao(:, 4, 8, 2) = (/ &
        & 0.70582e-05,0.54017e-03,0.91330e-03,0.12434e-02,0.15411e-02, &
        & 0.17884e-02,0.20057e-02,0.21704e-02,0.23548e-02 /)
      kao(:, 5, 8, 2) = (/ &
        & 0.74902e-05,0.60717e-03,0.10267e-02,0.13908e-02,0.17231e-02, &
        & 0.20285e-02,0.22810e-02,0.24710e-02,0.26631e-02 /)
      kao(:, 1, 9, 2) = (/ &
        & 0.45061e-05,0.28626e-03,0.49448e-03,0.65317e-03,0.79081e-03, &
        & 0.91066e-03,0.10182e-02,0.11107e-02,0.14592e-02 /)
      kao(:, 2, 9, 2) = (/ &
        & 0.49392e-05,0.32734e-03,0.56558e-03,0.76077e-03,0.91846e-03, &
        & 0.10578e-02,0.11776e-02,0.12720e-02,0.16778e-02 /)
      kao(:, 3, 9, 2) = (/ &
        & 0.52580e-05,0.37522e-03,0.63845e-03,0.87805e-03,0.10619e-02, &
        & 0.12194e-02,0.13606e-02,0.14680e-02,0.19259e-02 /)
      kao(:, 4, 9, 2) = (/ &
        & 0.54991e-05,0.42659e-03,0.72103e-03,0.98756e-03,0.12163e-02, &
        & 0.14007e-02,0.15647e-02,0.16900e-02,0.21772e-02 /)
      kao(:, 5, 9, 2) = (/ &
        & 0.58769e-05,0.48199e-03,0.81466e-03,0.11072e-02,0.13684e-02, &
        & 0.15984e-02,0.17887e-02,0.19333e-02,0.24331e-02 /)
      kao(:, 1,10, 2) = (/ &
        & 0.34154e-05,0.22534e-03,0.38788e-03,0.51113e-03,0.62194e-03, &
        & 0.71432e-03,0.79743e-03,0.86289e-03,0.14758e-02 /)
      kao(:, 2,10, 2) = (/ &
        & 0.38085e-05,0.25832e-03,0.44748e-03,0.59835e-03,0.72514e-03, &
        & 0.83284e-03,0.91941e-03,0.99583e-03,0.17358e-02 /)
      kao(:, 3,10, 2) = (/ &
        & 0.41578e-05,0.29655e-03,0.50553e-03,0.69511e-03,0.84107e-03, &
        & 0.96374e-03,0.10666e-02,0.11478e-02,0.19625e-02 /)
      kao(:, 4,10, 2) = (/ &
        & 0.43917e-05,0.33908e-03,0.57351e-03,0.78640e-03,0.96862e-03, &
        & 0.11109e-02,0.12309e-02,0.13266e-02,0.22103e-02 /)
      kao(:, 5,10, 2) = (/ &
        & 0.45446e-05,0.38548e-03,0.64883e-03,0.88401e-03,0.10952e-02, &
        & 0.12706e-02,0.14136e-02,0.15239e-02,0.24754e-02 /)
      kao(:, 1,11, 2) = (/ &
        & 0.27604e-05,0.18848e-03,0.32532e-03,0.42949e-03,0.52350e-03, &
        & 0.60084e-03,0.66640e-03,0.72070e-03,0.13692e-02 /)
      kao(:, 2,11, 2) = (/ &
        & 0.30908e-05,0.21679e-03,0.37259e-03,0.50366e-03,0.61074e-03, &
        & 0.70158e-03,0.77271e-03,0.83037e-03,0.15689e-02 /)
      kao(:, 3,11, 2) = (/ &
        & 0.33674e-05,0.24965e-03,0.42244e-03,0.58353e-03,0.70923e-03, &
        & 0.81330e-03,0.89750e-03,0.96131e-03,0.17971e-02 /)
      kao(:, 4,11, 2) = (/ &
        & 0.35568e-05,0.28602e-03,0.48044e-03,0.65868e-03,0.81816e-03, &
        & 0.93857e-03,0.10357e-02,0.11119e-02,0.20509e-02 /)
      kao(:, 5,11, 2) = (/ &
        & 0.36921e-05,0.32484e-03,0.54623e-03,0.74475e-03,0.92307e-03, &
        & 0.10758e-02,0.11895e-02,0.12777e-02,0.23253e-02 /)
      kao(:, 1,12, 2) = (/ &
        & 0.22272e-05,0.15807e-03,0.27163e-03,0.35935e-03,0.43781e-03, &
        & 0.50321e-03,0.55776e-03,0.60046e-03,0.11852e-02 /)
      kao(:, 2,12, 2) = (/ &
        & 0.24898e-05,0.18201e-03,0.31004e-03,0.42206e-03,0.51226e-03, &
        & 0.58824e-03,0.64919e-03,0.69291e-03,0.13623e-02 /)
      kao(:, 3,12, 2) = (/ &
        & 0.27021e-05,0.20958e-03,0.35322e-03,0.48676e-03,0.59587e-03, &
        & 0.68364e-03,0.75527e-03,0.80436e-03,0.15654e-02 /)
      kao(:, 4,12, 2) = (/ &
        & 0.28526e-05,0.24038e-03,0.40262e-03,0.55096e-03,0.68671e-03, &
        & 0.79103e-03,0.87211e-03,0.93124e-03,0.17898e-02 /)
      kao(:, 5,12, 2) = (/ &
        & 0.29899e-05,0.27289e-03,0.45904e-03,0.62448e-03,0.77496e-03, &
        & 0.90212e-03,0.10018e-02,0.10706e-02,0.20265e-02 /)
      kao(:, 1,13, 2) = (/ &
        & 0.17576e-05,0.13151e-03,0.22518e-03,0.29890e-03,0.36398e-03, &
        & 0.41884e-03,0.46505e-03,0.50086e-03,0.97916e-03 /)
      kao(:, 2,13, 2) = (/ &
        & 0.19524e-05,0.15189e-03,0.25686e-03,0.35123e-03,0.42723e-03, &
        & 0.49061e-03,0.54293e-03,0.57815e-03,0.11260e-02 /)
      kao(:, 3,13, 2) = (/ &
        & 0.21134e-05,0.17558e-03,0.29382e-03,0.40457e-03,0.49777e-03, &
        & 0.57153e-03,0.63185e-03,0.67213e-03,0.12960e-02 /)
      kao(:, 4,13, 2) = (/ &
        & 0.22681e-05,0.20106e-03,0.33583e-03,0.45977e-03,0.57094e-03, &
        & 0.66275e-03,0.73149e-03,0.77799e-03,0.14856e-02 /)
      kao(:, 5,13, 2) = (/ &
        & 0.23940e-05,0.22853e-03,0.38323e-03,0.52126e-03,0.64684e-03, &
        & 0.75455e-03,0.84115e-03,0.89575e-03,0.16816e-02 /)
      kao(:, 1, 1, 3) = (/ &
        & 0.87154e-04,0.70456e-02,0.11624e-01,0.16007e-01,0.20277e-01, &
        & 0.24349e-01,0.27902e-01,0.30956e-01,0.33159e-01 /)
      kao(:, 2, 1, 3) = (/ &
        & 0.92678e-04,0.75324e-02,0.12552e-01,0.17444e-01,0.21967e-01, &
        & 0.26250e-01,0.30241e-01,0.33348e-01,0.36164e-01 /)
      kao(:, 3, 1, 3) = (/ &
        & 0.97955e-04,0.80153e-02,0.13502e-01,0.18812e-01,0.23862e-01, &
        & 0.28480e-01,0.32511e-01,0.35713e-01,0.38349e-01 /)
      kao(:, 4, 1, 3) = (/ &
        & 0.10404e-03,0.84724e-02,0.14429e-01,0.20136e-01,0.25672e-01, &
        & 0.30688e-01,0.35011e-01,0.38379e-01,0.40673e-01 /)
      kao(:, 5, 1, 3) = (/ &
        & 0.11110e-03,0.89123e-02,0.15343e-01,0.21479e-01,0.27290e-01, &
        & 0.32751e-01,0.37455e-01,0.40931e-01,0.42463e-01 /)
      kao(:, 1, 2, 3) = (/ &
        & 0.73214e-04,0.61410e-02,0.10125e-01,0.13650e-01,0.17158e-01, &
        & 0.20627e-01,0.23628e-01,0.26251e-01,0.27481e-01 /)
      kao(:, 2, 2, 3) = (/ &
        & 0.77936e-04,0.65751e-02,0.10966e-01,0.14877e-01,0.18693e-01, &
        & 0.22272e-01,0.25630e-01,0.28395e-01,0.29894e-01 /)
      kao(:, 3, 2, 3) = (/ &
        & 0.83061e-04,0.69828e-02,0.11774e-01,0.16068e-01,0.20317e-01, &
        & 0.24244e-01,0.27748e-01,0.30432e-01,0.31851e-01 /)
      kao(:, 4, 2, 3) = (/ &
        & 0.88564e-04,0.73985e-02,0.12581e-01,0.17226e-01,0.21842e-01, &
        & 0.26177e-01,0.29969e-01,0.32748e-01,0.33805e-01 /)
      kao(:, 5, 2, 3) = (/ &
        & 0.94933e-04,0.77988e-02,0.13372e-01,0.18367e-01,0.23323e-01, &
        & 0.27928e-01,0.31964e-01,0.35013e-01,0.35327e-01 /)
      kao(:, 1, 3, 3) = (/ &
        & 0.60947e-04,0.52436e-02,0.86174e-02,0.11520e-01,0.14231e-01, &
        & 0.17027e-01,0.19469e-01,0.21634e-01,0.21981e-01 /)
      kao(:, 2, 3, 3) = (/ &
        & 0.64921e-04,0.55975e-02,0.93512e-02,0.12526e-01,0.15516e-01, &
        & 0.18471e-01,0.21270e-01,0.23512e-01,0.24114e-01 /)
      kao(:, 3, 3, 3) = (/ &
        & 0.69521e-04,0.59648e-02,0.10060e-01,0.13582e-01,0.16903e-01, &
        & 0.20177e-01,0.23055e-01,0.25380e-01,0.25822e-01 /)
      kao(:, 4, 3, 3) = (/ &
        & 0.74348e-04,0.63104e-02,0.10767e-01,0.14599e-01,0.18273e-01, &
        & 0.21836e-01,0.24984e-01,0.27358e-01,0.27450e-01 /)
      kao(:, 5, 3, 3) = (/ &
        & 0.79780e-04,0.66671e-02,0.11458e-01,0.15590e-01,0.19579e-01, &
        & 0.23358e-01,0.26806e-01,0.29335e-01,0.28786e-01 /)
      kao(:, 1, 4, 3) = (/ &
        & 0.50799e-04,0.44148e-02,0.72225e-02,0.96483e-02,0.11767e-01, &
        & 0.13828e-01,0.15844e-01,0.17588e-01,0.17391e-01 /)
      kao(:, 2, 4, 3) = (/ &
        & 0.54227e-04,0.47231e-02,0.78527e-02,0.10493e-01,0.12835e-01, &
        & 0.15126e-01,0.17466e-01,0.19219e-01,0.19351e-01 /)
      kao(:, 3, 4, 3) = (/ &
        & 0.58151e-04,0.50277e-02,0.84823e-02,0.11418e-01,0.13969e-01, &
        & 0.16576e-01,0.18903e-01,0.20840e-01,0.20853e-01 /)
      kao(:, 4, 4, 3) = (/ &
        & 0.62433e-04,0.53372e-02,0.90813e-02,0.12325e-01,0.15163e-01, &
        & 0.17971e-01,0.20590e-01,0.22529e-01,0.22273e-01 /)
      kao(:, 5, 4, 3) = (/ &
        & 0.66852e-04,0.56429e-02,0.96836e-02,0.13189e-01,0.16280e-01, &
        & 0.19312e-01,0.22136e-01,0.24263e-01,0.23466e-01 /)
      kao(:, 1, 5, 3) = (/ &
        & 0.42593e-04,0.36760e-02,0.59913e-02,0.79812e-02,0.97729e-02, &
        & 0.11265e-01,0.12874e-01,0.14150e-01,0.13651e-01 /)
      kao(:, 2, 5, 3) = (/ &
        & 0.45779e-04,0.39344e-02,0.65401e-02,0.87030e-02,0.10650e-01, &
        & 0.12374e-01,0.14135e-01,0.15529e-01,0.15507e-01 /)
      kao(:, 3, 5, 3) = (/ &
        & 0.48868e-04,0.42013e-02,0.70859e-02,0.94912e-02,0.11609e-01, &
        & 0.13557e-01,0.15381e-01,0.16993e-01,0.16785e-01 /)
      kao(:, 4, 5, 3) = (/ &
        & 0.52509e-04,0.44674e-02,0.76022e-02,0.10271e-01,0.12630e-01, &
        & 0.14736e-01,0.16830e-01,0.18387e-01,0.18040e-01 /)
      kao(:, 5, 5, 3) = (/ &
        & 0.56196e-04,0.47381e-02,0.81005e-02,0.11026e-01,0.13586e-01, &
        & 0.15940e-01,0.18160e-01,0.19920e-01,0.19092e-01 /)
      kao(:, 1, 6, 3) = (/ &
        & 0.36112e-04,0.30316e-02,0.49038e-02,0.65325e-02,0.79606e-02, &
        & 0.91706e-02,0.10285e-01,0.11252e-01,0.10556e-01 /)
      kao(:, 2, 6, 3) = (/ &
        & 0.38502e-04,0.32575e-02,0.53855e-02,0.71302e-02,0.87200e-02, &
        & 0.10138e-01,0.11319e-01,0.12504e-01,0.12109e-01 /)
      kao(:, 3, 6, 3) = (/ &
        & 0.41070e-04,0.34869e-02,0.58643e-02,0.78020e-02,0.95232e-02, &
        & 0.11081e-01,0.12413e-01,0.13700e-01,0.13350e-01 /)
      kao(:, 4, 6, 3) = (/ &
        & 0.44034e-04,0.37142e-02,0.62924e-02,0.84867e-02,0.10400e-01, &
        & 0.12091e-01,0.13614e-01,0.14850e-01,0.14396e-01 /)
      kao(:, 5, 6, 3) = (/ &
        & 0.47021e-04,0.39387e-02,0.67171e-02,0.91319e-02,0.11231e-01, &
        & 0.13129e-01,0.14745e-01,0.16155e-01,0.15392e-01 /)
      kao(:, 1, 7, 3) = (/ &
        & 0.30001e-04,0.24884e-02,0.39787e-02,0.53262e-02,0.64254e-02, &
        & 0.74422e-02,0.82418e-02,0.87651e-02,0.83241e-02 /)
      kao(:, 2, 7, 3) = (/ &
        & 0.32067e-04,0.26831e-02,0.43873e-02,0.58009e-02,0.70881e-02, &
        & 0.82303e-02,0.91115e-02,0.99530e-02,0.95843e-02 /)
      kao(:, 3, 7, 3) = (/ &
        & 0.34414e-04,0.28762e-02,0.47981e-02,0.63650e-02,0.77555e-02, &
        & 0.90130e-02,0.10051e-01,0.10944e-01,0.10687e-01 /)
      kao(:, 4, 7, 3) = (/ &
        & 0.36543e-04,0.30749e-02,0.51697e-02,0.69549e-02,0.84939e-02, &
        & 0.98621e-02,0.11012e-01,0.11950e-01,0.11596e-01 /)
      kao(:, 5, 7, 3) = (/ &
        & 0.38986e-04,0.32672e-02,0.55268e-02,0.74950e-02,0.92206e-02, &
        & 0.10750e-01,0.11970e-01,0.13029e-01,0.12461e-01 /)
      kao(:, 1, 8, 3) = (/ &
        & 0.24718e-04,0.20304e-02,0.32253e-02,0.42957e-02,0.51621e-02, &
        & 0.59477e-02,0.65543e-02,0.67901e-02,0.66578e-02 /)
      kao(:, 2, 8, 3) = (/ &
        & 0.26226e-04,0.22027e-02,0.35528e-02,0.46844e-02,0.57463e-02, &
        & 0.66070e-02,0.73566e-02,0.79086e-02,0.76807e-02 /)
      kao(:, 3, 8, 3) = (/ &
        & 0.28095e-04,0.23614e-02,0.38960e-02,0.51529e-02,0.62773e-02, &
        & 0.72919e-02,0.81475e-02,0.87344e-02,0.86509e-02 /)
      kao(:, 4, 8, 3) = (/ &
        & 0.29856e-04,0.25346e-02,0.42180e-02,0.56507e-02,0.68867e-02, &
        & 0.79948e-02,0.89169e-02,0.96226e-02,0.94212e-02 /)
      kao(:, 5, 8, 3) = (/ &
        & 0.31432e-04,0.26989e-02,0.45288e-02,0.61158e-02,0.75231e-02, &
        & 0.87319e-02,0.97447e-02,0.10470e-01,0.10172e-01 /)
      kao(:, 1, 9, 3) = (/ &
        & 0.20151e-04,0.16622e-02,0.26102e-02,0.34345e-02,0.41518e-02, &
        & 0.47356e-02,0.51198e-02,0.52901e-02,0.55608e-02 /)
      kao(:, 2, 9, 3) = (/ &
        & 0.21290e-04,0.18112e-02,0.28622e-02,0.37770e-02,0.46098e-02, &
        & 0.52825e-02,0.58719e-02,0.62115e-02,0.64287e-02 /)
      kao(:, 3, 9, 3) = (/ &
        & 0.22604e-04,0.19483e-02,0.31536e-02,0.41418e-02,0.50513e-02, &
        & 0.58883e-02,0.65199e-02,0.70000e-02,0.71641e-02 /)
      kao(:, 4, 9, 3) = (/ &
        & 0.24039e-04,0.20909e-02,0.34321e-02,0.45633e-02,0.55575e-02, &
        & 0.64453e-02,0.71800e-02,0.77062e-02,0.77821e-02 /)
      kao(:, 5, 9, 3) = (/ &
        & 0.25275e-04,0.22325e-02,0.36976e-02,0.49727e-02,0.60945e-02, &
        & 0.70632e-02,0.78696e-02,0.84048e-02,0.84571e-02 /)
      kao(:, 1,10, 3) = (/ &
        & 0.16520e-04,0.13579e-02,0.21217e-02,0.27650e-02,0.33209e-02, &
        & 0.37657e-02,0.40263e-02,0.41632e-02,0.59019e-02 /)
      kao(:, 2,10, 3) = (/ &
        & 0.17307e-04,0.14868e-02,0.23230e-02,0.30616e-02,0.37000e-02, &
        & 0.42629e-02,0.46958e-02,0.48956e-02,0.64729e-02 /)
      kao(:, 3,10, 3) = (/ &
        & 0.18210e-04,0.16086e-02,0.25635e-02,0.33480e-02,0.40827e-02, &
        & 0.47590e-02,0.52424e-02,0.56088e-02,0.71072e-02 /)
      kao(:, 4,10, 3) = (/ &
        & 0.19263e-04,0.17308e-02,0.28038e-02,0.37016e-02,0.44933e-02, &
        & 0.52114e-02,0.58224e-02,0.62053e-02,0.76445e-02 /)
      kao(:, 5,10, 3) = (/ &
        & 0.20450e-04,0.18514e-02,0.30286e-02,0.40569e-02,0.49417e-02, &
        & 0.57292e-02,0.63809e-02,0.68162e-02,0.81800e-02 /)
      kao(:, 1,11, 3) = (/ &
        & 0.13743e-04,0.11544e-02,0.18005e-02,0.23380e-02,0.28127e-02, &
        & 0.32019e-02,0.34184e-02,0.35137e-02,0.55132e-02 /)
      kao(:, 2,11, 3) = (/ &
        & 0.14314e-04,0.12648e-02,0.19811e-02,0.25794e-02,0.31283e-02, &
        & 0.35835e-02,0.39635e-02,0.41524e-02,0.60640e-02 /)
      kao(:, 3,11, 3) = (/ &
        & 0.14980e-04,0.13667e-02,0.21846e-02,0.28316e-02,0.34390e-02, &
        & 0.40069e-02,0.44283e-02,0.47282e-02,0.65662e-02 /)
      kao(:, 4,11, 3) = (/ &
        & 0.15843e-04,0.14691e-02,0.23844e-02,0.31346e-02,0.37915e-02, &
        & 0.43926e-02,0.49108e-02,0.52431e-02,0.70521e-02 /)
      kao(:, 5,11, 3) = (/ &
        & 0.16801e-04,0.15709e-02,0.25738e-02,0.34250e-02,0.41781e-02, &
        & 0.48258e-02,0.53776e-02,0.57400e-02,0.74913e-02 /)
      kao(:, 1,12, 3) = (/ &
        & 0.11265e-04,0.97473e-03,0.15190e-02,0.19779e-02,0.23708e-02, &
        & 0.27002e-02,0.28954e-02,0.29689e-02,0.49052e-02 /)
      kao(:, 2,12, 3) = (/ &
        & 0.11703e-04,0.10660e-02,0.16806e-02,0.21742e-02,0.26370e-02, &
        & 0.30184e-02,0.33461e-02,0.35081e-02,0.53515e-02 /)
      kao(:, 3,12, 3) = (/ &
        & 0.12275e-04,0.11524e-02,0.18532e-02,0.24014e-02,0.28932e-02, &
        & 0.33615e-02,0.37332e-02,0.39759e-02,0.57806e-02 /)
      kao(:, 4,12, 3) = (/ &
        & 0.12963e-04,0.12405e-02,0.20200e-02,0.26573e-02,0.31978e-02, &
        & 0.36904e-02,0.41225e-02,0.44151e-02,0.61956e-02 /)
      kao(:, 5,12, 3) = (/ &
        & 0.13696e-04,0.13266e-02,0.21814e-02,0.28939e-02,0.35284e-02, &
        & 0.40629e-02,0.45191e-02,0.48283e-02,0.65800e-02 /)
      kao(:, 1,13, 3) = (/ &
        & 0.91179e-05,0.81531e-03,0.12754e-02,0.16598e-02,0.19900e-02, &
        & 0.22634e-02,0.24441e-02,0.24984e-02,0.40576e-02 /)
      kao(:, 2,13, 3) = (/ &
        & 0.95039e-05,0.89093e-03,0.14150e-02,0.18287e-02,0.22143e-02, &
        & 0.25329e-02,0.28092e-02,0.29546e-02,0.44374e-02 /)
      kao(:, 3,13, 3) = (/ &
        & 0.99762e-05,0.96494e-03,0.15625e-02,0.20288e-02,0.24319e-02, &
        & 0.28108e-02,0.31373e-02,0.33177e-02,0.48094e-02 /)
      kao(:, 4,13, 3) = (/ &
        & 0.10509e-04,0.10398e-02,0.16996e-02,0.22443e-02,0.26925e-02, &
        & 0.30942e-02,0.34481e-02,0.37003e-02,0.51550e-02 /)
      kao(:, 5,13, 3) = (/ &
        & 0.11033e-04,0.11134e-02,0.18372e-02,0.24408e-02,0.29682e-02, &
        & 0.34114e-02,0.37859e-02,0.40424e-02,0.54893e-02 /)
      kao(:, 1, 1, 4) = (/ &
        & 0.25564e-03,0.23940e-01,0.41535e-01,0.56276e-01,0.68561e-01, &
        & 0.78630e-01,0.86993e-01,0.91794e-01,0.84229e-01 /)
      kao(:, 2, 1, 4) = (/ &
        & 0.29194e-03,0.25170e-01,0.43659e-01,0.59016e-01,0.72302e-01, &
        & 0.83167e-01,0.91739e-01,0.96774e-01,0.86838e-01 /)
      kao(:, 3, 1, 4) = (/ &
        & 0.33934e-03,0.26430e-01,0.45835e-01,0.61922e-01,0.75614e-01, &
        & 0.87285e-01,0.96606e-01,0.10156e+00,0.90084e-01 /)
      kao(:, 4, 1, 4) = (/ &
        & 0.38871e-03,0.27733e-01,0.48058e-01,0.64973e-01,0.79090e-01, &
        & 0.91156e-01,0.10084e+00,0.10589e+00,0.92583e-01 /)
      kao(:, 5, 1, 4) = (/ &
        & 0.44473e-03,0.29028e-01,0.50287e-01,0.68010e-01,0.82805e-01, &
        & 0.95193e-01,0.10492e+00,0.10995e+00,0.95419e-01 /)
      kao(:, 1, 2, 4) = (/ &
        & 0.23400e-03,0.20753e-01,0.35742e-01,0.48709e-01,0.59548e-01, &
        & 0.68206e-01,0.75045e-01,0.78915e-01,0.70180e-01 /)
      kao(:, 2, 2, 4) = (/ &
        & 0.26775e-03,0.21832e-01,0.37611e-01,0.51156e-01,0.62768e-01, &
        & 0.72267e-01,0.79422e-01,0.83262e-01,0.72735e-01 /)
      kao(:, 3, 2, 4) = (/ &
        & 0.30033e-03,0.22961e-01,0.39618e-01,0.53774e-01,0.65773e-01, &
        & 0.75819e-01,0.83532e-01,0.87496e-01,0.75459e-01 /)
      kao(:, 4, 2, 4) = (/ &
        & 0.34366e-03,0.24116e-01,0.41597e-01,0.56506e-01,0.68944e-01, &
        & 0.79231e-01,0.87245e-01,0.91336e-01,0.77669e-01 /)
      kao(:, 5, 2, 4) = (/ &
        & 0.39179e-03,0.25289e-01,0.43575e-01,0.59282e-01,0.72132e-01, &
        & 0.82956e-01,0.91038e-01,0.94937e-01,0.80272e-01 /)
      kao(:, 1, 3, 4) = (/ &
        & 0.20730e-03,0.18044e-01,0.30227e-01,0.41206e-01,0.50626e-01, &
        & 0.58095e-01,0.63725e-01,0.66721e-01,0.57780e-01 /)
      kao(:, 2, 3, 4) = (/ &
        & 0.24007e-03,0.18972e-01,0.31883e-01,0.43486e-01,0.53572e-01, &
        & 0.61742e-01,0.67489e-01,0.70552e-01,0.60009e-01 /)
      kao(:, 3, 3, 4) = (/ &
        & 0.26931e-03,0.19934e-01,0.33681e-01,0.45775e-01,0.56255e-01, &
        & 0.64869e-01,0.71254e-01,0.74232e-01,0.62350e-01 /)
      kao(:, 4, 3, 4) = (/ &
        & 0.30064e-03,0.20965e-01,0.35448e-01,0.48199e-01,0.59036e-01, &
        & 0.67921e-01,0.74594e-01,0.77689e-01,0.64410e-01 /)
      kao(:, 5, 3, 4) = (/ &
        & 0.33967e-03,0.21972e-01,0.37192e-01,0.50676e-01,0.61884e-01, &
        & 0.71207e-01,0.77888e-01,0.80947e-01,0.66667e-01 /)
      kao(:, 1, 4, 4) = (/ &
        & 0.18201e-03,0.15595e-01,0.25372e-01,0.34431e-01,0.42401e-01, &
        & 0.48915e-01,0.53613e-01,0.55953e-01,0.47727e-01 /)
      kao(:, 2, 4, 4) = (/ &
        & 0.20883e-03,0.16422e-01,0.26851e-01,0.36481e-01,0.45074e-01, &
        & 0.52078e-01,0.56860e-01,0.59287e-01,0.49553e-01 /)
      kao(:, 3, 4, 4) = (/ &
        & 0.23874e-03,0.17285e-01,0.28425e-01,0.38514e-01,0.47542e-01, &
        & 0.54904e-01,0.60284e-01,0.62561e-01,0.51595e-01 /)
      kao(:, 4, 4, 4) = (/ &
        & 0.26707e-03,0.18200e-01,0.30007e-01,0.40613e-01,0.49982e-01, &
        & 0.57662e-01,0.63231e-01,0.65666e-01,0.53450e-01 /)
      kao(:, 5, 4, 4) = (/ &
        & 0.30102e-03,0.19113e-01,0.31552e-01,0.42805e-01,0.52535e-01, &
        & 0.60559e-01,0.66195e-01,0.68549e-01,0.55415e-01 /)
      kao(:, 1, 5, 4) = (/ &
        & 0.15801e-03,0.13295e-01,0.21524e-01,0.28666e-01,0.35142e-01, &
        & 0.40757e-01,0.44715e-01,0.46740e-01,0.39384e-01 /)
      kao(:, 2, 5, 4) = (/ &
        & 0.17994e-03,0.14057e-01,0.22786e-01,0.30487e-01,0.37563e-01, &
        & 0.43509e-01,0.47676e-01,0.49638e-01,0.40849e-01 /)
      kao(:, 3, 5, 4) = (/ &
        & 0.20535e-03,0.14811e-01,0.24116e-01,0.32266e-01,0.39764e-01, &
        & 0.46122e-01,0.50669e-01,0.52413e-01,0.42683e-01 /)
      kao(:, 4, 5, 4) = (/ &
        & 0.23511e-03,0.15598e-01,0.25481e-01,0.34103e-01,0.41924e-01, &
        & 0.48592e-01,0.53283e-01,0.55235e-01,0.44335e-01 /)
      kao(:, 5, 5, 4) = (/ &
        & 0.26640e-03,0.16402e-01,0.26844e-01,0.36000e-01,0.44180e-01, &
        & 0.51086e-01,0.55918e-01,0.57796e-01,0.45991e-01 /)
      kao(:, 1, 6, 4) = (/ &
        & 0.13805e-03,0.11222e-01,0.18125e-01,0.23877e-01,0.28939e-01, &
        & 0.33506e-01,0.36944e-01,0.38672e-01,0.32335e-01 /)
      kao(:, 2, 6, 4) = (/ &
        & 0.15439e-03,0.11883e-01,0.19262e-01,0.25521e-01,0.31068e-01, &
        & 0.35882e-01,0.39589e-01,0.41132e-01,0.33684e-01 /)
      kao(:, 3, 6, 4) = (/ &
        & 0.17561e-03,0.12558e-01,0.20409e-01,0.27033e-01,0.33056e-01, &
        & 0.38260e-01,0.42155e-01,0.43639e-01,0.35175e-01 /)
      kao(:, 4, 6, 4) = (/ &
        & 0.19967e-03,0.13236e-01,0.21628e-01,0.28554e-01,0.34939e-01, &
        & 0.40459e-01,0.44550e-01,0.46147e-01,0.36643e-01 /)
      kao(:, 5, 6, 4) = (/ &
        & 0.23117e-03,0.13936e-01,0.22836e-01,0.30183e-01,0.36909e-01, &
        & 0.42652e-01,0.46864e-01,0.48440e-01,0.37992e-01 /)
      kao(:, 1, 7, 4) = (/ &
        & 0.11987e-03,0.93983e-02,0.15130e-01,0.19808e-01,0.23796e-01, &
        & 0.27285e-01,0.30176e-01,0.31906e-01,0.26193e-01 /)
      kao(:, 2, 7, 4) = (/ &
        & 0.13164e-03,0.99743e-02,0.16118e-01,0.21319e-01,0.25600e-01, &
        & 0.29404e-01,0.32485e-01,0.33909e-01,0.27439e-01 /)
      kao(:, 3, 7, 4) = (/ &
        & 0.14862e-03,0.10559e-01,0.17124e-01,0.22674e-01,0.27373e-01, &
        & 0.31501e-01,0.34705e-01,0.36112e-01,0.28667e-01 /)
      kao(:, 4, 7, 4) = (/ &
        & 0.16941e-03,0.11142e-01,0.18163e-01,0.23992e-01,0.29023e-01, &
        & 0.33461e-01,0.36882e-01,0.38288e-01,0.29990e-01 /)
      kao(:, 5, 7, 4) = (/ &
        & 0.19444e-03,0.11740e-01,0.19231e-01,0.25410e-01,0.30702e-01, &
        & 0.35380e-01,0.38933e-01,0.40325e-01,0.31163e-01 /)
      kao(:, 1, 8, 4) = (/ &
        & 0.10266e-03,0.78132e-02,0.12495e-01,0.16294e-01,0.19552e-01, &
        & 0.22203e-01,0.24522e-01,0.26158e-01,0.21477e-01 /)
      kao(:, 2, 8, 4) = (/ &
        & 0.11308e-03,0.82996e-02,0.13385e-01,0.17650e-01,0.21113e-01, &
        & 0.24026e-01,0.26424e-01,0.27779e-01,0.22661e-01 /)
      kao(:, 3, 8, 4) = (/ &
        & 0.12431e-03,0.88118e-02,0.14254e-01,0.18852e-01,0.22717e-01, &
        & 0.25822e-01,0.28352e-01,0.29667e-01,0.23674e-01 /)
      kao(:, 4, 8, 4) = (/ &
        & 0.14146e-03,0.93080e-02,0.15152e-01,0.20013e-01,0.24158e-01, &
        & 0.27569e-01,0.30306e-01,0.31495e-01,0.24838e-01 /)
      kao(:, 5, 8, 4) = (/ &
        & 0.16275e-03,0.98287e-02,0.16080e-01,0.21227e-01,0.25592e-01, &
        & 0.29226e-01,0.32075e-01,0.33357e-01,0.25887e-01 /)
      kao(:, 1, 9, 4) = (/ &
        & 0.85797e-04,0.64412e-02,0.10231e-01,0.13327e-01,0.15923e-01, &
        & 0.18103e-01,0.19903e-01,0.21189e-01,0.17975e-01 /)
      kao(:, 2, 9, 4) = (/ &
        & 0.94370e-04,0.68514e-02,0.11041e-01,0.14472e-01,0.17298e-01, &
        & 0.19661e-01,0.21421e-01,0.22631e-01,0.18990e-01 /)
      kao(:, 3, 9, 4) = (/ &
        & 0.10603e-03,0.72870e-02,0.11786e-01,0.15570e-01,0.18710e-01, &
        & 0.21195e-01,0.23092e-01,0.24157e-01,0.19934e-01 /)
      kao(:, 4, 9, 4) = (/ &
        & 0.11819e-03,0.77217e-02,0.12559e-01,0.16589e-01,0.19991e-01, &
        & 0.22738e-01,0.24769e-01,0.25771e-01,0.20946e-01 /)
      kao(:, 5, 9, 4) = (/ &
        & 0.13500e-03,0.81624e-02,0.13346e-01,0.17610e-01,0.21227e-01, &
        & 0.24140e-01,0.26339e-01,0.27388e-01,0.21819e-01 /)
      kao(:, 1,10, 4) = (/ &
        & 0.73275e-04,0.53147e-02,0.83832e-02,0.10890e-01,0.12998e-01, &
        & 0.14772e-01,0.16237e-01,0.17165e-01,0.15972e-01 /)
      kao(:, 2,10, 4) = (/ &
        & 0.80303e-04,0.56594e-02,0.90964e-02,0.11869e-01,0.14181e-01, &
        & 0.16065e-01,0.17493e-01,0.18447e-01,0.17075e-01 /)
      kao(:, 3,10, 4) = (/ &
        & 0.88821e-04,0.60286e-02,0.97491e-02,0.12852e-01,0.15387e-01, &
        & 0.17394e-01,0.18909e-01,0.19708e-01,0.18078e-01 /)
      kao(:, 4,10, 4) = (/ &
        & 0.10142e-03,0.63962e-02,0.10392e-01,0.13730e-01,0.16522e-01, &
        & 0.18771e-01,0.20308e-01,0.21096e-01,0.19037e-01 /)
      kao(:, 5,10, 4) = (/ &
        & 0.11405e-03,0.67754e-02,0.11065e-01,0.14605e-01,0.17581e-01, &
        & 0.19991e-01,0.21687e-01,0.22458e-01,0.19875e-01 /)
      kao(:, 1,11, 4) = (/ &
        & 0.64517e-04,0.45135e-02,0.71165e-02,0.92384e-02,0.10998e-01, &
        & 0.12474e-01,0.13700e-01,0.14388e-01,0.14631e-01 /)
      kao(:, 2,11, 4) = (/ &
        & 0.71535e-04,0.48070e-02,0.77137e-02,0.10092e-01,0.12023e-01, &
        & 0.13623e-01,0.14792e-01,0.15449e-01,0.15481e-01 /)
      kao(:, 3,11, 4) = (/ &
        & 0.79504e-04,0.51199e-02,0.82600e-02,0.10911e-01,0.13076e-01, &
        & 0.14755e-01,0.16002e-01,0.16546e-01,0.16298e-01 /)
      kao(:, 4,11, 4) = (/ &
        & 0.90433e-04,0.54351e-02,0.88101e-02,0.11647e-01,0.14018e-01, &
        & 0.15922e-01,0.17206e-01,0.17715e-01,0.16991e-01 /)
      kao(:, 5,11, 4) = (/ &
        & 0.10146e-03,0.57596e-02,0.93865e-02,0.12407e-01,0.14922e-01, &
        & 0.16951e-01,0.18384e-01,0.18893e-01,0.17666e-01 /)
      kao(:, 1,12, 4) = (/ &
        & 0.56913e-04,0.38361e-02,0.60238e-02,0.78101e-02,0.92943e-02, &
        & 0.10515e-01,0.11514e-01,0.12051e-01,0.12708e-01 /)
      kao(:, 2,12, 4) = (/ &
        & 0.62984e-04,0.40886e-02,0.65153e-02,0.85464e-02,0.10168e-01, &
        & 0.11498e-01,0.12452e-01,0.12938e-01,0.13473e-01 /)
      kao(:, 3,12, 4) = (/ &
        & 0.70588e-04,0.43561e-02,0.69761e-02,0.92137e-02,0.11068e-01, &
        & 0.12482e-01,0.13497e-01,0.13892e-01,0.14090e-01 /)
      kao(:, 4,12, 4) = (/ &
        & 0.79556e-04,0.46222e-02,0.74472e-02,0.98382e-02,0.11852e-01, &
        & 0.13461e-01,0.14539e-01,0.14868e-01,0.14684e-01 /)
      kao(:, 5,12, 4) = (/ &
        & 0.89330e-04,0.49037e-02,0.79332e-02,0.10492e-01,0.12613e-01, &
        & 0.14331e-01,0.15523e-01,0.15867e-01,0.15266e-01 /)
      kao(:, 1,13, 4) = (/ &
        & 0.49040e-04,0.32470e-02,0.50782e-02,0.65813e-02,0.78254e-02, &
        & 0.88398e-02,0.96483e-02,0.10090e-01,0.10614e-01 /)
      kao(:, 2,13, 4) = (/ &
        & 0.54225e-04,0.34616e-02,0.54906e-02,0.71951e-02,0.85711e-02, &
        & 0.96781e-02,0.10460e-01,0.10840e-01,0.11206e-01 /)
      kao(:, 3,13, 4) = (/ &
        & 0.61136e-04,0.36878e-02,0.58777e-02,0.77458e-02,0.93183e-02, &
        & 0.10528e-01,0.11347e-01,0.11684e-01,0.11730e-01 /)
      kao(:, 4,13, 4) = (/ &
        & 0.68788e-04,0.39213e-02,0.62791e-02,0.82774e-02,0.99761e-02, &
        & 0.11332e-01,0.12247e-01,0.12495e-01,0.12250e-01 /)
      kao(:, 5,13, 4) = (/ &
        & 0.77427e-04,0.41640e-02,0.66890e-02,0.88358e-02,0.10624e-01, &
        & 0.12069e-01,0.13064e-01,0.13341e-01,0.12730e-01 /)
      kao(:, 1, 1, 5) = (/ &
        & 0.69098e-02,0.84650e-01,0.13006e+00,0.16652e+00,0.19608e+00, &
        & 0.21975e+00,0.23496e+00,0.23277e+00,0.18007e+00 /)
      kao(:, 2, 1, 5) = (/ &
        & 0.78200e-02,0.89279e-01,0.13630e+00,0.17409e+00,0.20398e+00, &
        & 0.22718e+00,0.24129e+00,0.23750e+00,0.18438e+00 /)
      kao(:, 3, 1, 5) = (/ &
        & 0.89787e-02,0.94428e-01,0.14296e+00,0.18170e+00,0.21205e+00, &
        & 0.23450e+00,0.24726e+00,0.24172e+00,0.18878e+00 /)
      kao(:, 4, 1, 5) = (/ &
        & 0.10426e-01,0.10003e+00,0.15009e+00,0.18943e+00,0.22015e+00, &
        & 0.24206e+00,0.25341e+00,0.24571e+00,0.19325e+00 /)
      kao(:, 5, 1, 5) = (/ &
        & 0.12209e-01,0.10603e+00,0.15781e+00,0.19756e+00,0.22832e+00, &
        & 0.24963e+00,0.25957e+00,0.24958e+00,0.19748e+00 /)
      kao(:, 1, 2, 5) = (/ &
        & 0.64020e-02,0.74597e-01,0.11458e+00,0.14581e+00,0.17103e+00, &
        & 0.19105e+00,0.20412e+00,0.20133e+00,0.15242e+00 /)
      kao(:, 2, 2, 5) = (/ &
        & 0.72586e-02,0.78857e-01,0.12024e+00,0.15257e+00,0.17796e+00, &
        & 0.19765e+00,0.20972e+00,0.20548e+00,0.15620e+00 /)
      kao(:, 3, 2, 5) = (/ &
        & 0.82903e-02,0.83602e-01,0.12623e+00,0.15931e+00,0.18512e+00, &
        & 0.20423e+00,0.21503e+00,0.20937e+00,0.15993e+00 /)
      kao(:, 4, 2, 5) = (/ &
        & 0.94578e-02,0.88668e-01,0.13277e+00,0.16635e+00,0.19233e+00, &
        & 0.21098e+00,0.22050e+00,0.21294e+00,0.16397e+00 /)
      kao(:, 5, 2, 5) = (/ &
        & 0.10865e-01,0.94113e-01,0.13987e+00,0.17375e+00,0.19975e+00, &
        & 0.21771e+00,0.22592e+00,0.21639e+00,0.16745e+00 /)
      kao(:, 1, 3, 5) = (/ &
        & 0.56943e-02,0.64084e-01,0.99294e-01,0.12614e+00,0.14746e+00, &
        & 0.16414e+00,0.17503e+00,0.17255e+00,0.12738e+00 /)
      kao(:, 2, 3, 5) = (/ &
        & 0.64702e-02,0.67967e-01,0.10427e+00,0.13197e+00,0.15350e+00, &
        & 0.16985e+00,0.18008e+00,0.17631e+00,0.13087e+00 /)
      kao(:, 3, 3, 5) = (/ &
        & 0.74200e-02,0.72252e-01,0.10956e+00,0.13801e+00,0.15978e+00, &
        & 0.17567e+00,0.18476e+00,0.17977e+00,0.13421e+00 /)
      kao(:, 4, 3, 5) = (/ &
        & 0.84907e-02,0.76772e-01,0.11539e+00,0.14427e+00,0.16615e+00, &
        & 0.18168e+00,0.18947e+00,0.18300e+00,0.13761e+00 /)
      kao(:, 5, 3, 5) = (/ &
        & 0.97078e-02,0.81671e-01,0.12172e+00,0.15082e+00,0.17277e+00, &
        & 0.18769e+00,0.19427e+00,0.18608e+00,0.14067e+00 /)
      kao(:, 1, 4, 5) = (/ &
        & 0.48829e-02,0.54383e-01,0.85075e-01,0.10815e+00,0.12638e+00, &
        & 0.14020e+00,0.14903e+00,0.14670e+00,0.10614e+00 /)
      kao(:, 2, 4, 5) = (/ &
        & 0.55740e-02,0.57779e-01,0.89436e-01,0.11323e+00,0.13160e+00, &
        & 0.14514e+00,0.15349e+00,0.15027e+00,0.10949e+00 /)
      kao(:, 3, 4, 5) = (/ &
        & 0.64015e-02,0.61546e-01,0.94139e-01,0.11850e+00,0.13701e+00, &
        & 0.15017e+00,0.15757e+00,0.15344e+00,0.11257e+00 /)
      kao(:, 4, 4, 5) = (/ &
        & 0.73719e-02,0.65521e-01,0.99232e-01,0.12403e+00,0.14259e+00, &
        & 0.15541e+00,0.16175e+00,0.15634e+00,0.11557e+00 /)
      kao(:, 5, 4, 5) = (/ &
        & 0.84789e-02,0.69810e-01,0.10478e+00,0.12985e+00,0.14840e+00, &
        & 0.16071e+00,0.16597e+00,0.15910e+00,0.11833e+00 /)
      kao(:, 1, 5, 5) = (/ &
        & 0.41357e-02,0.45878e-01,0.71866e-01,0.92130e-01,0.10772e+00, &
        & 0.11935e+00,0.12627e+00,0.12382e+00,0.88490e-01 /)
      kao(:, 2, 5, 5) = (/ &
        & 0.47278e-02,0.48809e-01,0.75724e-01,0.96485e-01,0.11218e+00, &
        & 0.12363e+00,0.13023e+00,0.12723e+00,0.91646e-01 /)
      kao(:, 3, 5, 5) = (/ &
        & 0.54234e-02,0.52108e-01,0.79925e-01,0.10105e+00,0.11684e+00, &
        & 0.12795e+00,0.13389e+00,0.13024e+00,0.94384e-01 /)
      kao(:, 4, 5, 5) = (/ &
        & 0.62672e-02,0.55647e-01,0.84438e-01,0.10591e+00,0.12167e+00, &
        & 0.13255e+00,0.13759e+00,0.13288e+00,0.97037e-01 /)
      kao(:, 5, 5, 5) = (/ &
        & 0.72387e-02,0.59393e-01,0.89326e-01,0.11102e+00,0.12680e+00, &
        & 0.13723e+00,0.14128e+00,0.13530e+00,0.99585e-01 /)
      kao(:, 1, 6, 5) = (/ &
        & 0.34820e-02,0.38455e-01,0.60106e-01,0.77515e-01,0.91143e-01, &
        & 0.10094e+00,0.10649e+00,0.10403e+00,0.73509e-01 /)
      kao(:, 2, 6, 5) = (/ &
        & 0.39507e-02,0.40927e-01,0.63402e-01,0.81240e-01,0.94968e-01, &
        & 0.10469e+00,0.11001e+00,0.10717e+00,0.76426e-01 /)
      kao(:, 3, 6, 5) = (/ &
        & 0.45266e-02,0.43726e-01,0.67041e-01,0.85234e-01,0.98911e-01, &
        & 0.10845e+00,0.11329e+00,0.10996e+00,0.78861e-01 /)
      kao(:, 4, 6, 5) = (/ &
        & 0.52242e-02,0.46807e-01,0.70939e-01,0.89547e-01,0.10312e+00, &
        & 0.11247e+00,0.11653e+00,0.11237e+00,0.81250e-01 /)
      kao(:, 5, 6, 5) = (/ &
        & 0.60449e-02,0.50083e-01,0.75175e-01,0.94041e-01,0.10760e+00, &
        & 0.11657e+00,0.11980e+00,0.11449e+00,0.83549e-01 /)
      kao(:, 1, 7, 5) = (/ &
        & 0.28711e-02,0.32523e-01,0.49971e-01,0.64597e-01,0.76360e-01, &
        & 0.84918e-01,0.89523e-01,0.87200e-01,0.60618e-01 /)
      kao(:, 2, 7, 5) = (/ &
        & 0.32550e-02,0.34614e-01,0.52803e-01,0.67740e-01,0.79713e-01, &
        & 0.88207e-01,0.92681e-01,0.90060e-01,0.63331e-01 /)
      kao(:, 3, 7, 5) = (/ &
        & 0.37263e-02,0.36968e-01,0.55904e-01,0.71153e-01,0.83143e-01, &
        & 0.91509e-01,0.95607e-01,0.92564e-01,0.65595e-01 /)
      kao(:, 4, 7, 5) = (/ &
        & 0.42953e-02,0.39538e-01,0.59281e-01,0.74912e-01,0.86822e-01, &
        & 0.94956e-01,0.98438e-01,0.94728e-01,0.67680e-01 /)
      kao(:, 5, 7, 5) = (/ &
        & 0.49788e-02,0.42264e-01,0.62953e-01,0.78842e-01,0.90742e-01, &
        & 0.98510e-01,0.10129e+00,0.96641e-01,0.69746e-01 /)
      kao(:, 1, 8, 5) = (/ &
        & 0.23480e-02,0.27230e-01,0.41671e-01,0.53565e-01,0.63436e-01, &
        & 0.70999e-01,0.75020e-01,0.72906e-01,0.49386e-01 /)
      kao(:, 2, 8, 5) = (/ &
        & 0.26517e-02,0.29065e-01,0.44017e-01,0.56225e-01,0.66341e-01, &
        & 0.73935e-01,0.77879e-01,0.75468e-01,0.51750e-01 /)
      kao(:, 3, 8, 5) = (/ &
        & 0.30285e-02,0.31112e-01,0.46598e-01,0.59161e-01,0.69302e-01, &
        & 0.76809e-01,0.80439e-01,0.77729e-01,0.53904e-01 /)
      kao(:, 4, 8, 5) = (/ &
        & 0.34816e-02,0.33348e-01,0.49448e-01,0.62380e-01,0.72502e-01, &
        & 0.79786e-01,0.82887e-01,0.79683e-01,0.55731e-01 /)
      kao(:, 5, 8, 5) = (/ &
        & 0.40444e-02,0.35730e-01,0.52545e-01,0.65794e-01,0.75878e-01, &
        & 0.82889e-01,0.85379e-01,0.81391e-01,0.57509e-01 /)
      kao(:, 1, 9, 5) = (/ &
        & 0.19247e-02,0.22630e-01,0.34752e-01,0.44387e-01,0.52455e-01, &
        & 0.58833e-01,0.62468e-01,0.60719e-01,0.41880e-01 /)
      kao(:, 2, 9, 5) = (/ &
        & 0.21557e-02,0.24204e-01,0.36750e-01,0.46636e-01,0.54976e-01, &
        & 0.61421e-01,0.65052e-01,0.62994e-01,0.44010e-01 /)
      kao(:, 3, 9, 5) = (/ &
        & 0.24477e-02,0.25958e-01,0.38981e-01,0.49108e-01,0.57526e-01, &
        & 0.63907e-01,0.67351e-01,0.65038e-01,0.45929e-01 /)
      kao(:, 4, 9, 5) = (/ &
        & 0.28196e-02,0.27882e-01,0.41431e-01,0.51802e-01,0.60249e-01, &
        & 0.66480e-01,0.69467e-01,0.66788e-01,0.47555e-01 /)
      kao(:, 5, 9, 5) = (/ &
        & 0.32654e-02,0.29939e-01,0.44072e-01,0.54714e-01,0.63163e-01, &
        & 0.69207e-01,0.71600e-01,0.68328e-01,0.49077e-01 /)
      kao(:, 1,10, 5) = (/ &
        & 0.16200e-02,0.18814e-01,0.28911e-01,0.37025e-01,0.43479e-01, &
        & 0.48691e-01,0.51767e-01,0.50517e-01,0.36565e-01 /)
      kao(:, 2,10, 5) = (/ &
        & 0.18031e-02,0.20150e-01,0.30632e-01,0.38967e-01,0.45609e-01, &
        & 0.50940e-01,0.54046e-01,0.52515e-01,0.38425e-01 /)
      kao(:, 3,10, 5) = (/ &
        & 0.20232e-02,0.21640e-01,0.32572e-01,0.41079e-01,0.47788e-01, &
        & 0.53101e-01,0.56114e-01,0.54338e-01,0.40162e-01 /)
      kao(:, 4,10, 5) = (/ &
        & 0.23038e-02,0.23298e-01,0.34703e-01,0.43393e-01,0.50110e-01, &
        & 0.55298e-01,0.57982e-01,0.55873e-01,0.41782e-01 /)
      kao(:, 5,10, 5) = (/ &
        & 0.26649e-02,0.25073e-01,0.36983e-01,0.45868e-01,0.52617e-01, &
        & 0.57641e-01,0.59833e-01,0.57222e-01,0.43243e-01 /)
      kao(:, 1,11, 5) = (/ &
        & 0.14241e-02,0.16065e-01,0.24586e-01,0.31465e-01,0.36963e-01, &
        & 0.41093e-01,0.43617e-01,0.42673e-01,0.32343e-01 /)
      kao(:, 2,11, 5) = (/ &
        & 0.15878e-02,0.17268e-01,0.26144e-01,0.33169e-01,0.38816e-01, &
        & 0.42988e-01,0.45546e-01,0.44327e-01,0.34054e-01 /)
      kao(:, 3,11, 5) = (/ &
        & 0.18003e-02,0.18609e-01,0.27888e-01,0.35066e-01,0.40717e-01, &
        & 0.44861e-01,0.47277e-01,0.45845e-01,0.35562e-01 /)
      kao(:, 4,11, 5) = (/ &
        & 0.20513e-02,0.20069e-01,0.29794e-01,0.37147e-01,0.42781e-01, &
        & 0.46774e-01,0.48869e-01,0.47106e-01,0.36881e-01 /)
      kao(:, 5,11, 5) = (/ &
        & 0.23610e-02,0.21636e-01,0.31786e-01,0.39341e-01,0.44964e-01, &
        & 0.48832e-01,0.50478e-01,0.48237e-01,0.38136e-01 /)
      kao(:, 1,12, 5) = (/ &
        & 0.12367e-02,0.13664e-01,0.20841e-01,0.26619e-01,0.31258e-01, &
        & 0.34766e-01,0.36665e-01,0.35873e-01,0.27811e-01 /)
      kao(:, 2,12, 5) = (/ &
        & 0.13898e-02,0.14747e-01,0.22238e-01,0.28134e-01,0.32876e-01, &
        & 0.36392e-01,0.38286e-01,0.37257e-01,0.29212e-01 /)
      kao(:, 3,12, 5) = (/ &
        & 0.15822e-02,0.15920e-01,0.23808e-01,0.29830e-01,0.34558e-01, &
        & 0.38014e-01,0.39728e-01,0.38493e-01,0.30517e-01 /)
      kao(:, 4,12, 5) = (/ &
        & 0.18117e-02,0.17195e-01,0.25479e-01,0.31664e-01,0.36378e-01, &
        & 0.39675e-01,0.41098e-01,0.39553e-01,0.31705e-01 /)
      kao(:, 5,12, 5) = (/ &
        & 0.20996e-02,0.18567e-01,0.27225e-01,0.33571e-01,0.38302e-01, &
        & 0.41437e-01,0.42501e-01,0.40525e-01,0.32748e-01 /)
      kao(:, 1,13, 5) = (/ &
        & 0.10606e-02,0.11594e-01,0.17616e-01,0.22456e-01,0.26337e-01, &
        & 0.29282e-01,0.30831e-01,0.30037e-01,0.23251e-01 /)
      kao(:, 2,13, 5) = (/ &
        & 0.11975e-02,0.12541e-01,0.18850e-01,0.23795e-01,0.27745e-01, &
        & 0.30676e-01,0.32191e-01,0.31186e-01,0.24461e-01 /)
      kao(:, 3,13, 5) = (/ &
        & 0.13686e-02,0.13557e-01,0.20236e-01,0.25287e-01,0.29224e-01, &
        & 0.32085e-01,0.33411e-01,0.32190e-01,0.25539e-01 /)
      kao(:, 4,13, 5) = (/ &
        & 0.15787e-02,0.14655e-01,0.21685e-01,0.26887e-01,0.30821e-01, &
        & 0.33533e-01,0.34581e-01,0.33091e-01,0.26483e-01 /)
      kao(:, 5,13, 5) = (/ &
        & 0.18422e-02,0.15847e-01,0.23201e-01,0.28535e-01,0.32486e-01, &
        & 0.35059e-01,0.35791e-01,0.33942e-01,0.27340e-01 /)
      kao(:, 1, 1, 6) = (/ &
        & 0.11257e+00,0.31731e+00,0.42139e+00,0.49121e+00,0.53179e+00, &
        & 0.54416e+00,0.52879e+00,0.48565e+00,0.38185e+00 /)
      kao(:, 2, 1, 6) = (/ &
        & 0.12995e+00,0.33757e+00,0.44079e+00,0.50693e+00,0.54374e+00, &
        & 0.55231e+00,0.53411e+00,0.48973e+00,0.38664e+00 /)
      kao(:, 3, 1, 6) = (/ &
        & 0.14899e+00,0.35787e+00,0.45940e+00,0.52235e+00,0.55490e+00, &
        & 0.56009e+00,0.53945e+00,0.49411e+00,0.39028e+00 /)
      kao(:, 4, 1, 6) = (/ &
        & 0.16946e+00,0.37848e+00,0.47747e+00,0.53692e+00,0.56497e+00, &
        & 0.56760e+00,0.54484e+00,0.49832e+00,0.39391e+00 /)
      kao(:, 5, 1, 6) = (/ &
        & 0.19143e+00,0.39915e+00,0.49476e+00,0.55039e+00,0.57468e+00, &
        & 0.57486e+00,0.55036e+00,0.50307e+00,0.39756e+00 /)
      kao(:, 1, 2, 6) = (/ &
        & 0.97091e-01,0.28037e+00,0.37054e+00,0.43162e+00,0.46715e+00, &
        & 0.47740e+00,0.46327e+00,0.42557e+00,0.32833e+00 /)
      kao(:, 2, 2, 6) = (/ &
        & 0.11208e+00,0.29815e+00,0.38764e+00,0.44615e+00,0.47841e+00, &
        & 0.48513e+00,0.46886e+00,0.42998e+00,0.33260e+00 /)
      kao(:, 3, 2, 6) = (/ &
        & 0.12856e+00,0.31599e+00,0.40420e+00,0.45996e+00,0.48848e+00, &
        & 0.49285e+00,0.47441e+00,0.43431e+00,0.33632e+00 /)
      kao(:, 4, 2, 6) = (/ &
        & 0.14648e+00,0.33425e+00,0.42020e+00,0.47262e+00,0.49778e+00, &
        & 0.50015e+00,0.47996e+00,0.43890e+00,0.33965e+00 /)
      kao(:, 5, 2, 6) = (/ &
        & 0.16579e+00,0.35250e+00,0.43554e+00,0.48445e+00,0.50655e+00, &
        & 0.50702e+00,0.48572e+00,0.44375e+00,0.34330e+00 /)
      kao(:, 1, 3, 6) = (/ &
        & 0.80654e-01,0.24334e+00,0.32145e+00,0.37485e+00,0.40615e+00, &
        & 0.41488e+00,0.40284e+00,0.37005e+00,0.27897e+00 /)
      kao(:, 2, 3, 6) = (/ &
        & 0.93334e-01,0.25889e+00,0.33665e+00,0.38799e+00,0.41628e+00, &
        & 0.42254e+00,0.40845e+00,0.37420e+00,0.28281e+00 /)
      kao(:, 3, 3, 6) = (/ &
        & 0.10735e+00,0.27449e+00,0.35143e+00,0.40015e+00,0.42551e+00, &
        & 0.42981e+00,0.41382e+00,0.37871e+00,0.28619e+00 /)
      kao(:, 4, 3, 6) = (/ &
        & 0.12265e+00,0.29043e+00,0.36548e+00,0.41153e+00,0.43393e+00, &
        & 0.43649e+00,0.41932e+00,0.38340e+00,0.28955e+00 /)
      kao(:, 5, 3, 6) = (/ &
        & 0.13925e+00,0.30659e+00,0.37895e+00,0.42211e+00,0.44187e+00, &
        & 0.44276e+00,0.42490e+00,0.38830e+00,0.29282e+00 /)
      kao(:, 1, 4, 6) = (/ &
        & 0.65986e-01,0.20968e+00,0.27746e+00,0.32321e+00,0.35021e+00, &
        & 0.35817e+00,0.34816e+00,0.31914e+00,0.23714e+00 /)
      kao(:, 2, 4, 6) = (/ &
        & 0.76550e-01,0.22318e+00,0.29094e+00,0.33486e+00,0.35941e+00, &
        & 0.36546e+00,0.35341e+00,0.32318e+00,0.24040e+00 /)
      kao(:, 3, 4, 6) = (/ &
        & 0.88349e-01,0.23676e+00,0.30387e+00,0.34562e+00,0.36786e+00, &
        & 0.37204e+00,0.35871e+00,0.32765e+00,0.24343e+00 /)
      kao(:, 4, 4, 6) = (/ &
        & 0.10129e+00,0.25065e+00,0.31610e+00,0.35574e+00,0.37546e+00, &
        & 0.37811e+00,0.36390e+00,0.33220e+00,0.24649e+00 /)
      kao(:, 5, 4, 6) = (/ &
        & 0.11540e+00,0.26489e+00,0.32784e+00,0.36504e+00,0.38250e+00, &
        & 0.38387e+00,0.36919e+00,0.33697e+00,0.24943e+00 /)
      kao(:, 1, 5, 6) = (/ &
        & 0.53393e-01,0.18000e+00,0.23883e+00,0.27751e+00,0.30053e+00, &
        & 0.30742e+00,0.29898e+00,0.27383e+00,0.20106e+00 /)
      kao(:, 2, 5, 6) = (/ &
        & 0.62233e-01,0.19175e+00,0.25050e+00,0.28777e+00,0.30898e+00, &
        & 0.31400e+00,0.30389e+00,0.27769e+00,0.20390e+00 /)
      kao(:, 3, 5, 6) = (/ &
        & 0.72177e-01,0.20364e+00,0.26165e+00,0.29741e+00,0.31640e+00, &
        & 0.31996e+00,0.30876e+00,0.28174e+00,0.20671e+00 /)
      kao(:, 4, 5, 6) = (/ &
        & 0.83134e-01,0.21576e+00,0.27227e+00,0.30617e+00,0.32319e+00, &
        & 0.32542e+00,0.31353e+00,0.28599e+00,0.20956e+00 /)
      kao(:, 5, 5, 6) = (/ &
        & 0.95090e-01,0.22815e+00,0.28259e+00,0.31429e+00,0.32943e+00, &
        & 0.33059e+00,0.31837e+00,0.29043e+00,0.21220e+00 /)
      kao(:, 1, 6, 6) = (/ &
        & 0.42433e-01,0.15317e+00,0.20425e+00,0.23740e+00,0.25663e+00, &
        & 0.26234e+00,0.25512e+00,0.23364e+00,0.16949e+00 /)
      kao(:, 2, 6, 6) = (/ &
        & 0.49749e-01,0.16341e+00,0.21435e+00,0.24646e+00,0.26413e+00, &
        & 0.26825e+00,0.25968e+00,0.23716e+00,0.17204e+00 /)
      kao(:, 3, 6, 6) = (/ &
        & 0.58017e-01,0.17381e+00,0.22409e+00,0.25485e+00,0.27073e+00, &
        & 0.27356e+00,0.26405e+00,0.24070e+00,0.17477e+00 /)
      kao(:, 4, 6, 6) = (/ &
        & 0.67231e-01,0.18439e+00,0.23345e+00,0.26240e+00,0.27677e+00, &
        & 0.27839e+00,0.26819e+00,0.24459e+00,0.17741e+00 /)
      kao(:, 5, 6, 6) = (/ &
        & 0.77316e-01,0.19517e+00,0.24253e+00,0.26953e+00,0.28221e+00, &
        & 0.28296e+00,0.27246e+00,0.24867e+00,0.17984e+00 /)
      kao(:, 1, 7, 6) = (/ &
        & 0.33835e-01,0.12894e+00,0.17377e+00,0.20223e+00,0.21858e+00, &
        & 0.22305e+00,0.21661e+00,0.19799e+00,0.14234e+00 /)
      kao(:, 2, 7, 6) = (/ &
        & 0.39495e-01,0.13775e+00,0.18255e+00,0.21017e+00,0.22506e+00, &
        & 0.22828e+00,0.22063e+00,0.20115e+00,0.14469e+00 /)
      kao(:, 3, 7, 6) = (/ &
        & 0.46213e-01,0.14677e+00,0.19104e+00,0.21747e+00,0.23085e+00, &
        & 0.23293e+00,0.22444e+00,0.20438e+00,0.14721e+00 /)
      kao(:, 4, 7, 6) = (/ &
        & 0.53881e-01,0.15604e+00,0.19912e+00,0.22407e+00,0.23606e+00, &
        & 0.23711e+00,0.22803e+00,0.20793e+00,0.14967e+00 /)
      kao(:, 5, 7, 6) = (/ &
        & 0.62313e-01,0.16559e+00,0.20703e+00,0.23032e+00,0.24086e+00, &
        & 0.24109e+00,0.23183e+00,0.21164e+00,0.15187e+00 /)
      kao(:, 1, 8, 6) = (/ &
        & 0.27294e-01,0.10784e+00,0.14673e+00,0.17152e+00,0.18541e+00, &
        & 0.18896e+00,0.18302e+00,0.16686e+00,0.11892e+00 /)
      kao(:, 2, 8, 6) = (/ &
        & 0.31945e-01,0.11533e+00,0.15437e+00,0.17841e+00,0.19097e+00, &
        & 0.19348e+00,0.18650e+00,0.16969e+00,0.12123e+00 /)
      kao(:, 3, 8, 6) = (/ &
        & 0.37290e-01,0.12309e+00,0.16174e+00,0.18467e+00,0.19597e+00, &
        & 0.19753e+00,0.18983e+00,0.17262e+00,0.12344e+00 /)
      kao(:, 4, 8, 6) = (/ &
        & 0.43331e-01,0.13110e+00,0.16878e+00,0.19044e+00,0.20053e+00, &
        & 0.20117e+00,0.19304e+00,0.17581e+00,0.12571e+00 /)
      kao(:, 5, 8, 6) = (/ &
        & 0.50086e-01,0.13937e+00,0.17577e+00,0.19586e+00,0.20476e+00, &
        & 0.20472e+00,0.19647e+00,0.17915e+00,0.12770e+00 /)
      kao(:, 1, 9, 6) = (/ &
        & 0.21763e-01,0.89580e-01,0.12270e+00,0.14431e+00,0.15639e+00, &
        & 0.15936e+00,0.15421e+00,0.14030e+00,0.10042e+00 /)
      kao(:, 2, 9, 6) = (/ &
        & 0.25609e-01,0.95974e-01,0.12925e+00,0.15030e+00,0.16119e+00, &
        & 0.16326e+00,0.15719e+00,0.14283e+00,0.10252e+00 /)
      kao(:, 3, 9, 6) = (/ &
        & 0.30067e-01,0.10261e+00,0.13551e+00,0.15572e+00,0.16552e+00, &
        & 0.16675e+00,0.16007e+00,0.14539e+00,0.10448e+00 /)
      kao(:, 4, 9, 6) = (/ &
        & 0.35097e-01,0.10949e+00,0.14161e+00,0.16075e+00,0.16947e+00, &
        & 0.16997e+00,0.16297e+00,0.14823e+00,0.10645e+00 /)
      kao(:, 5, 9, 6) = (/ &
        & 0.40711e-01,0.11658e+00,0.14773e+00,0.16552e+00,0.17324e+00, &
        & 0.17317e+00,0.16604e+00,0.15112e+00,0.10826e+00 /)
      kao(:, 1,10, 6) = (/ &
        & 0.17370e-01,0.74466e-01,0.10240e+00,0.12053e+00,0.13126e+00, &
        & 0.13417e+00,0.12989e+00,0.11790e+00,0.87103e-01 /)
      kao(:, 2,10, 6) = (/ &
        & 0.20536e-01,0.79866e-01,0.10796e+00,0.12568e+00,0.13547e+00, &
        & 0.13755e+00,0.13244e+00,0.12017e+00,0.88680e-01 /)
      kao(:, 3,10, 6) = (/ &
        & 0.24274e-01,0.85524e-01,0.11324e+00,0.13036e+00,0.13925e+00, &
        & 0.14055e+00,0.13491e+00,0.12243e+00,0.90062e-01 /)
      kao(:, 4,10, 6) = (/ &
        & 0.28508e-01,0.91420e-01,0.11852e+00,0.13467e+00,0.14267e+00, &
        & 0.14339e+00,0.13748e+00,0.12487e+00,0.91240e-01 /)
      kao(:, 5,10, 6) = (/ &
        & 0.33217e-01,0.97522e-01,0.12382e+00,0.13886e+00,0.14603e+00, &
        & 0.14625e+00,0.14015e+00,0.12740e+00,0.92631e-01 /)
      kao(:, 1,11, 6) = (/ &
        & 0.14918e-01,0.64249e-01,0.87193e-01,0.10225e+00,0.11107e+00, &
        & 0.11380e+00,0.11017e+00,0.99775e-01,0.75883e-01 /)
      kao(:, 2,11, 6) = (/ &
        & 0.17707e-01,0.68887e-01,0.91783e-01,0.10653e+00,0.11454e+00, &
        & 0.11659e+00,0.11231e+00,0.10178e+00,0.77400e-01 /)
      kao(:, 3,11, 6) = (/ &
        & 0.20985e-01,0.73723e-01,0.96290e-01,0.11038e+00,0.11765e+00, &
        & 0.11911e+00,0.11446e+00,0.10377e+00,0.78827e-01 /)
      kao(:, 4,11, 6) = (/ &
        & 0.24698e-01,0.78820e-01,0.10085e+00,0.11403e+00,0.12064e+00, &
        & 0.12159e+00,0.11674e+00,0.10593e+00,0.80678e-01 /)
      kao(:, 5,11, 6) = (/ &
        & 0.28798e-01,0.84087e-01,0.10545e+00,0.11772e+00,0.12367e+00, &
        & 0.12416e+00,0.11916e+00,0.10818e+00,0.82090e-01 /)
      kao(:, 1,12, 6) = (/ &
        & 0.12778e-01,0.55028e-01,0.74326e-01,0.86458e-01,0.93690e-01, &
        & 0.95887e-01,0.92996e-01,0.84239e-01,0.65531e-01 /)
      kao(:, 2,12, 6) = (/ &
        & 0.15226e-01,0.59056e-01,0.78180e-01,0.90004e-01,0.96562e-01, &
        & 0.98210e-01,0.94824e-01,0.85996e-01,0.67232e-01 /)
      kao(:, 3,12, 6) = (/ &
        & 0.18073e-01,0.63328e-01,0.81993e-01,0.93245e-01,0.99175e-01, &
        & 0.10034e+00,0.96751e-01,0.87779e-01,0.68728e-01 /)
      kao(:, 4,12, 6) = (/ &
        & 0.21287e-01,0.67814e-01,0.85944e-01,0.96446e-01,0.10181e+00, &
        & 0.10253e+00,0.98787e-01,0.89700e-01,0.70024e-01 /)
      kao(:, 5,12, 6) = (/ &
        & 0.24810e-01,0.72405e-01,0.89913e-01,0.99700e-01,0.10454e+00, &
        & 0.10492e+00,0.10099e+00,0.91662e-01,0.71222e-01 /)
      kao(:, 1,13, 6) = (/ &
        & 0.10897e-01,0.46824e-01,0.63070e-01,0.73198e-01,0.78826e-01, &
        & 0.80547e-01,0.78087e-01,0.70945e-01,0.55427e-01 /)
      kao(:, 2,13, 6) = (/ &
        & 0.13037e-01,0.50331e-01,0.66369e-01,0.76169e-01,0.81229e-01, &
        & 0.82485e-01,0.79688e-01,0.72492e-01,0.56776e-01 /)
      kao(:, 3,13, 6) = (/ &
        & 0.15498e-01,0.54103e-01,0.69687e-01,0.78968e-01,0.83486e-01, &
        & 0.84334e-01,0.81403e-01,0.74109e-01,0.57973e-01 /)
      kao(:, 4,13, 6) = (/ &
        & 0.18239e-01,0.58007e-01,0.73146e-01,0.81751e-01,0.85842e-01, &
        & 0.86346e-01,0.83244e-01,0.75789e-01,0.59123e-01 /)
      kao(:, 5,13, 6) = (/ &
        & 0.21231e-01,0.61947e-01,0.76584e-01,0.84579e-01,0.88268e-01, &
        & 0.88508e-01,0.85245e-01,0.77486e-01,0.60191e-01 /)
      kao(:, 1, 1, 7) = (/ &
        & 0.71609e+00,0.10081e+01,0.11118e+01,0.11603e+01,0.11765e+01, &
        & 0.11643e+01,0.11202e+01,0.10296e+01,0.82502e+00 /)
      kao(:, 2, 1, 7) = (/ &
        & 0.75920e+00,0.10292e+01,0.11252e+01,0.11685e+01,0.11822e+01, &
        & 0.11684e+01,0.11228e+01,0.10318e+01,0.83157e+00 /)
      kao(:, 3, 1, 7) = (/ &
        & 0.79807e+00,0.10500e+01,0.11397e+01,0.11794e+01,0.11904e+01, &
        & 0.11740e+01,0.11264e+01,0.10343e+01,0.83726e+00 /)
      kao(:, 4, 1, 7) = (/ &
        & 0.83183e+00,0.10700e+01,0.11548e+01,0.11918e+01,0.12010e+01, &
        & 0.11815e+01,0.11313e+01,0.10364e+01,0.84249e+00 /)
      kao(:, 5, 1, 7) = (/ &
        & 0.86161e+00,0.10887e+01,0.11706e+01,0.12061e+01,0.12126e+01, &
        & 0.11904e+01,0.11363e+01,0.10383e+01,0.84713e+00 /)
      kao(:, 1, 2, 7) = (/ &
        & 0.62079e+00,0.89078e+00,0.98349e+00,0.10275e+01,0.10413e+01, &
        & 0.10318e+01,0.99528e+00,0.92037e+00,0.72464e+00 /)
      kao(:, 2, 2, 7) = (/ &
        & 0.65800e+00,0.91114e+00,0.99789e+00,0.10381e+01,0.10488e+01, &
        & 0.10378e+01,0.99952e+00,0.92364e+00,0.73140e+00 /)
      kao(:, 3, 2, 7) = (/ &
        & 0.69092e+00,0.93058e+00,0.10122e+01,0.10502e+01,0.10590e+01, &
        & 0.10454e+01,0.10054e+01,0.92699e+00,0.73764e+00 /)
      kao(:, 4, 2, 7) = (/ &
        & 0.71970e+00,0.94840e+00,0.10270e+01,0.10636e+01,0.10709e+01, &
        & 0.10547e+01,0.10116e+01,0.93021e+00,0.74329e+00 /)
      kao(:, 5, 2, 7) = (/ &
        & 0.74579e+00,0.96581e+00,0.10421e+01,0.10781e+01,0.10844e+01, &
        & 0.10644e+01,0.10185e+01,0.93369e+00,0.74789e+00 /)
      kao(:, 1, 3, 7) = (/ &
        & 0.52823e+00,0.77783e+00,0.86297e+00,0.90265e+00,0.91464e+00, &
        & 0.90839e+00,0.87923e+00,0.81632e+00,0.63067e+00 /)
      kao(:, 2, 3, 7) = (/ &
        & 0.56021e+00,0.79652e+00,0.87677e+00,0.91375e+00,0.92363e+00, &
        & 0.91571e+00,0.88529e+00,0.82096e+00,0.63740e+00 /)
      kao(:, 3, 3, 7) = (/ &
        & 0.58848e+00,0.81389e+00,0.89039e+00,0.92584e+00,0.93460e+00, &
        & 0.92486e+00,0.89232e+00,0.82527e+00,0.64377e+00 /)
      kao(:, 4, 3, 7) = (/ &
        & 0.61369e+00,0.83008e+00,0.90459e+00,0.93860e+00,0.94727e+00, &
        & 0.93485e+00,0.89989e+00,0.82959e+00,0.64921e+00 /)
      kao(:, 5, 3, 7) = (/ &
        & 0.63687e+00,0.84580e+00,0.91897e+00,0.95268e+00,0.96085e+00, &
        & 0.94565e+00,0.90780e+00,0.83380e+00,0.65367e+00 /)
      kao(:, 1, 4, 7) = (/ &
        & 0.44508e+00,0.67351e+00,0.75154e+00,0.78756e+00,0.79977e+00, &
        & 0.79563e+00,0.77123e+00,0.71868e+00,0.54794e+00 /)
      kao(:, 2, 4, 7) = (/ &
        & 0.47271e+00,0.69026e+00,0.76424e+00,0.79840e+00,0.80928e+00, &
        & 0.80400e+00,0.77859e+00,0.72416e+00,0.55496e+00 /)
      kao(:, 3, 4, 7) = (/ &
        & 0.49708e+00,0.70580e+00,0.77670e+00,0.80989e+00,0.82043e+00, &
        & 0.81421e+00,0.78653e+00,0.72918e+00,0.56105e+00 /)
      kao(:, 4, 4, 7) = (/ &
        & 0.51921e+00,0.72040e+00,0.78970e+00,0.82209e+00,0.83296e+00, &
        & 0.82477e+00,0.79492e+00,0.73435e+00,0.56612e+00 /)
      kao(:, 5, 4, 7) = (/ &
        & 0.53991e+00,0.73468e+00,0.80284e+00,0.83540e+00,0.84599e+00, &
        & 0.83588e+00,0.80349e+00,0.73920e+00,0.57048e+00 /)
      kao(:, 1, 5, 7) = (/ &
        & 0.37413e+00,0.58022e+00,0.65026e+00,0.68370e+00,0.69632e+00, &
        & 0.69319e+00,0.67239e+00,0.62755e+00,0.47517e+00 /)
      kao(:, 2, 5, 7) = (/ &
        & 0.39785e+00,0.59500e+00,0.66160e+00,0.69388e+00,0.70581e+00, &
        & 0.70224e+00,0.68037e+00,0.63372e+00,0.48187e+00 /)
      kao(:, 3, 5, 7) = (/ &
        & 0.41894e+00,0.60858e+00,0.67282e+00,0.70454e+00,0.71693e+00, &
        & 0.71249e+00,0.68889e+00,0.63962e+00,0.48765e+00 /)
      kao(:, 4, 5, 7) = (/ &
        & 0.43810e+00,0.62138e+00,0.68416e+00,0.71639e+00,0.72873e+00, &
        & 0.72302e+00,0.69785e+00,0.64510e+00,0.49243e+00 /)
      kao(:, 5, 5, 7) = (/ &
        & 0.45627e+00,0.63437e+00,0.69610e+00,0.72855e+00,0.74096e+00, &
        & 0.73385e+00,0.70672e+00,0.65052e+00,0.49657e+00 /)
      kao(:, 1, 6, 7) = (/ &
        & 0.31382e+00,0.49799e+00,0.55977e+00,0.58971e+00,0.60230e+00, &
        & 0.60065e+00,0.58267e+00,0.54392e+00,0.40911e+00 /)
      kao(:, 2, 6, 7) = (/ &
        & 0.33427e+00,0.51077e+00,0.56976e+00,0.59903e+00,0.61148e+00, &
        & 0.60961e+00,0.59093e+00,0.55057e+00,0.41554e+00 /)
      kao(:, 3, 6, 7) = (/ &
        & 0.35247e+00,0.52249e+00,0.57948e+00,0.60895e+00,0.62185e+00, &
        & 0.61942e+00,0.59984e+00,0.55707e+00,0.42096e+00 /)
      kao(:, 4, 6, 7) = (/ &
        & 0.36909e+00,0.53360e+00,0.58950e+00,0.61977e+00,0.63265e+00, &
        & 0.62957e+00,0.60872e+00,0.56306e+00,0.42549e+00 /)
      kao(:, 5, 6, 7) = (/ &
        & 0.38489e+00,0.54511e+00,0.60025e+00,0.63086e+00,0.64395e+00, &
        & 0.63979e+00,0.61739e+00,0.56897e+00,0.42951e+00 /)
      kao(:, 1, 7, 7) = (/ &
        & 0.26224e+00,0.42663e+00,0.48031e+00,0.50651e+00,0.51797e+00, &
        & 0.51738e+00,0.50230e+00,0.46824e+00,0.34967e+00 /)
      kao(:, 2, 7, 7) = (/ &
        & 0.28013e+00,0.43764e+00,0.48906e+00,0.51485e+00,0.52656e+00, &
        & 0.52602e+00,0.51065e+00,0.47517e+00,0.35569e+00 /)
      kao(:, 3, 7, 7) = (/ &
        & 0.29592e+00,0.44770e+00,0.49758e+00,0.52367e+00,0.53583e+00, &
        & 0.53525e+00,0.51944e+00,0.48175e+00,0.36089e+00 /)
      kao(:, 4, 7, 7) = (/ &
        & 0.31035e+00,0.45721e+00,0.50658e+00,0.53311e+00,0.54562e+00, &
        & 0.54468e+00,0.52799e+00,0.48800e+00,0.36523e+00 /)
      kao(:, 5, 7, 7) = (/ &
        & 0.32410e+00,0.46702e+00,0.51628e+00,0.54315e+00,0.55572e+00, &
        & 0.55402e+00,0.53619e+00,0.49402e+00,0.36906e+00 /)
      kao(:, 1, 8, 7) = (/ &
        & 0.21802e+00,0.36523e+00,0.41109e+00,0.43388e+00,0.44363e+00, &
        & 0.44316e+00,0.43058e+00,0.40065e+00,0.29668e+00 /)
      kao(:, 2, 8, 7) = (/ &
        & 0.23315e+00,0.37455e+00,0.41894e+00,0.44116e+00,0.45154e+00, &
        & 0.45134e+00,0.43880e+00,0.40751e+00,0.30231e+00 /)
      kao(:, 3, 8, 7) = (/ &
        & 0.24686e+00,0.38301e+00,0.42637e+00,0.44889e+00,0.45978e+00, &
        & 0.45969e+00,0.44700e+00,0.41408e+00,0.30721e+00 /)
      kao(:, 4, 8, 7) = (/ &
        & 0.25967e+00,0.39102e+00,0.43427e+00,0.45708e+00,0.46833e+00, &
        & 0.46819e+00,0.45488e+00,0.42031e+00,0.31131e+00 /)
      kao(:, 5, 8, 7) = (/ &
        & 0.27188e+00,0.39949e+00,0.44272e+00,0.46608e+00,0.47706e+00, &
        & 0.47653e+00,0.46230e+00,0.42618e+00,0.31504e+00 /)
      kao(:, 1, 9, 7) = (/ &
        & 0.18022e+00,0.31183e+00,0.35120e+00,0.37079e+00,0.37884e+00, &
        & 0.37804e+00,0.36693e+00,0.34063e+00,0.24612e+00 /)
      kao(:, 2, 9, 7) = (/ &
        & 0.19307e+00,0.31966e+00,0.35801e+00,0.37712e+00,0.38585e+00, &
        & 0.38558e+00,0.37468e+00,0.34716e+00,0.25138e+00 /)
      kao(:, 3, 9, 7) = (/ &
        & 0.20463e+00,0.32683e+00,0.36444e+00,0.38387e+00,0.39308e+00, &
        & 0.39294e+00,0.38210e+00,0.35364e+00,0.25593e+00 /)
      kao(:, 4, 9, 7) = (/ &
        & 0.21550e+00,0.33367e+00,0.37119e+00,0.39103e+00,0.40042e+00, &
        & 0.40039e+00,0.38916e+00,0.35964e+00,0.25996e+00 /)
      kao(:, 5, 9, 7) = (/ &
        & 0.22607e+00,0.34108e+00,0.37860e+00,0.39875e+00,0.40805e+00, &
        & 0.40762e+00,0.39578e+00,0.36518e+00,0.26360e+00 /)
      kao(:, 1,10, 7) = (/ &
        & 0.14867e+00,0.26554e+00,0.29985e+00,0.31657e+00,0.32318e+00, &
        & 0.32201e+00,0.31162e+00,0.28815e+00,0.21732e+00 /)
      kao(:, 2,10, 7) = (/ &
        & 0.15961e+00,0.27217e+00,0.30555e+00,0.32206e+00,0.32938e+00, &
        & 0.32864e+00,0.31877e+00,0.29424e+00,0.22230e+00 /)
      kao(:, 3,10, 7) = (/ &
        & 0.16940e+00,0.27829e+00,0.31116e+00,0.32786e+00,0.33559e+00, &
        & 0.33509e+00,0.32534e+00,0.30046e+00,0.22643e+00 /)
      kao(:, 4,10, 7) = (/ &
        & 0.17863e+00,0.28410e+00,0.31692e+00,0.33409e+00,0.34189e+00, &
        & 0.34154e+00,0.33152e+00,0.30607e+00,0.23022e+00 /)
      kao(:, 5,10, 7) = (/ &
        & 0.18774e+00,0.29050e+00,0.32341e+00,0.34075e+00,0.34846e+00, &
        & 0.34771e+00,0.33731e+00,0.31120e+00,0.23340e+00 /)
      kao(:, 1,11, 7) = (/ &
        & 0.12627e+00,0.22669e+00,0.25719e+00,0.27172e+00,0.27732e+00, &
        & 0.27601e+00,0.26659e+00,0.24512e+00,0.18584e+00 /)
      kao(:, 2,11, 7) = (/ &
        & 0.13516e+00,0.23214e+00,0.26193e+00,0.27653e+00,0.28265e+00, &
        & 0.28160e+00,0.27265e+00,0.25095e+00,0.18968e+00 /)
      kao(:, 3,11, 7) = (/ &
        & 0.14321e+00,0.23722e+00,0.26679e+00,0.28162e+00,0.28797e+00, &
        & 0.28724e+00,0.27822e+00,0.25645e+00,0.19293e+00 /)
      kao(:, 4,11, 7) = (/ &
        & 0.15107e+00,0.24247e+00,0.27199e+00,0.28706e+00,0.29346e+00, &
        & 0.29269e+00,0.28343e+00,0.26131e+00,0.19541e+00 /)
      kao(:, 5,11, 7) = (/ &
        & 0.15896e+00,0.24837e+00,0.27786e+00,0.29309e+00,0.29929e+00, &
        & 0.29804e+00,0.28838e+00,0.26594e+00,0.19802e+00 /)
      kao(:, 1,12, 7) = (/ &
        & 0.10682e+00,0.19256e+00,0.21863e+00,0.23192e+00,0.23695e+00, &
        & 0.23560e+00,0.22744e+00,0.20844e+00,0.16014e+00 /)
      kao(:, 2,12, 7) = (/ &
        & 0.11409e+00,0.19699e+00,0.22274e+00,0.23606e+00,0.24149e+00, &
        & 0.24040e+00,0.23256e+00,0.21367e+00,0.16300e+00 /)
      kao(:, 3,12, 7) = (/ &
        & 0.12093e+00,0.20128e+00,0.22702e+00,0.24050e+00,0.24609e+00, &
        & 0.24521e+00,0.23721e+00,0.21831e+00,0.16579e+00 /)
      kao(:, 4,12, 7) = (/ &
        & 0.12767e+00,0.20601e+00,0.23174e+00,0.24542e+00,0.25091e+00, &
        & 0.24990e+00,0.24163e+00,0.22258e+00,0.16866e+00 /)
      kao(:, 5,12, 7) = (/ &
        & 0.13446e+00,0.21151e+00,0.23730e+00,0.25089e+00,0.25608e+00, &
        & 0.25469e+00,0.24607e+00,0.22668e+00,0.17141e+00 /)
      kao(:, 1,13, 7) = (/ &
        & 0.90556e-01,0.16301e+00,0.18506e+00,0.19633e+00,0.20124e+00, &
        & 0.20042e+00,0.19353e+00,0.17713e+00,0.13589e+00 /)
      kao(:, 2,13, 7) = (/ &
        & 0.96629e-01,0.16667e+00,0.18855e+00,0.19991e+00,0.20512e+00, &
        & 0.20458e+00,0.19781e+00,0.18150e+00,0.13866e+00 /)
      kao(:, 3,13, 7) = (/ &
        & 0.10246e+00,0.17045e+00,0.19232e+00,0.20386e+00,0.20916e+00, &
        & 0.20868e+00,0.20175e+00,0.18546e+00,0.14157e+00 /)
      kao(:, 4,13, 7) = (/ &
        & 0.10831e+00,0.17481e+00,0.19664e+00,0.20827e+00,0.21340e+00, &
        & 0.21278e+00,0.20565e+00,0.18920e+00,0.14421e+00 /)
      kao(:, 5,13, 7) = (/ &
        & 0.11418e+00,0.17993e+00,0.20190e+00,0.21347e+00,0.21830e+00, &
        & 0.21718e+00,0.20964e+00,0.19280e+00,0.14715e+00 /)
      kao(:, 1, 1, 8) = (/ &
        & 0.20844e+01,0.23344e+01,0.25576e+01,0.26701e+01,0.27010e+01, &
        & 0.26681e+01,0.25683e+01,0.23655e+01,0.20810e+01 /)
      kao(:, 2, 1, 8) = (/ &
        & 0.20807e+01,0.23304e+01,0.25489e+01,0.26611e+01,0.26920e+01, &
        & 0.26609e+01,0.25647e+01,0.23645e+01,0.20859e+01 /)
      kao(:, 3, 1, 8) = (/ &
        & 0.20877e+01,0.23342e+01,0.25477e+01,0.26548e+01,0.26843e+01, &
        & 0.26541e+01,0.25605e+01,0.23637e+01,0.20903e+01 /)
      kao(:, 4, 1, 8) = (/ &
        & 0.21052e+01,0.23454e+01,0.25520e+01,0.26529e+01,0.26778e+01, &
        & 0.26478e+01,0.25565e+01,0.23630e+01,0.20935e+01 /)
      kao(:, 5, 1, 8) = (/ &
        & 0.21303e+01,0.23633e+01,0.25619e+01,0.26546e+01,0.26749e+01, &
        & 0.26429e+01,0.25542e+01,0.23619e+01,0.20958e+01 /)
      kao(:, 1, 2, 8) = (/ &
        & 0.18120e+01,0.21101e+01,0.23204e+01,0.24266e+01,0.24657e+01, &
        & 0.24469e+01,0.23702e+01,0.21931e+01,0.18669e+01 /)
      kao(:, 2, 2, 8) = (/ &
        & 0.18187e+01,0.21137e+01,0.23188e+01,0.24223e+01,0.24620e+01, &
        & 0.24436e+01,0.23687e+01,0.21944e+01,0.18726e+01 /)
      kao(:, 3, 2, 8) = (/ &
        & 0.18356e+01,0.21255e+01,0.23256e+01,0.24232e+01,0.24590e+01, &
        & 0.24407e+01,0.23674e+01,0.21960e+01,0.18776e+01 /)
      kao(:, 4, 2, 8) = (/ &
        & 0.18614e+01,0.21447e+01,0.23386e+01,0.24287e+01,0.24595e+01, &
        & 0.24387e+01,0.23672e+01,0.21970e+01,0.18816e+01 /)
      kao(:, 5, 2, 8) = (/ &
        & 0.18927e+01,0.21683e+01,0.23579e+01,0.24392e+01,0.24636e+01, &
        & 0.24407e+01,0.23665e+01,0.21974e+01,0.18864e+01 /)
      kao(:, 1, 3, 8) = (/ &
        & 0.15702e+01,0.18942e+01,0.20837e+01,0.21854e+01,0.22324e+01, &
        & 0.22266e+01,0.21649e+01,0.20134e+01,0.16617e+01 /)
      kao(:, 2, 3, 8) = (/ &
        & 0.15827e+01,0.19038e+01,0.20886e+01,0.21865e+01,0.22329e+01, &
        & 0.22266e+01,0.21649e+01,0.20167e+01,0.16695e+01 /)
      kao(:, 3, 3, 8) = (/ &
        & 0.16046e+01,0.19213e+01,0.21019e+01,0.21942e+01,0.22360e+01, &
        & 0.22271e+01,0.21665e+01,0.20195e+01,0.16762e+01 /)
      kao(:, 4, 3, 8) = (/ &
        & 0.16329e+01,0.19443e+01,0.21213e+01,0.22070e+01,0.22424e+01, &
        & 0.22311e+01,0.21683e+01,0.20214e+01,0.16830e+01 /)
      kao(:, 5, 3, 8) = (/ &
        & 0.16658e+01,0.19717e+01,0.21452e+01,0.22251e+01,0.22530e+01, &
        & 0.22371e+01,0.21708e+01,0.20238e+01,0.16904e+01 /)
      kao(:, 1, 4, 8) = (/ &
        & 0.13564e+01,0.16869e+01,0.18550e+01,0.19537e+01,0.20049e+01, &
        & 0.20085e+01,0.19601e+01,0.18287e+01,0.14756e+01 /)
      kao(:, 2, 4, 8) = (/ &
        & 0.13720e+01,0.17000e+01,0.18655e+01,0.19607e+01,0.20100e+01, &
        & 0.20105e+01,0.19622e+01,0.18339e+01,0.14854e+01 /)
      kao(:, 3, 4, 8) = (/ &
        & 0.13952e+01,0.17204e+01,0.18837e+01,0.19740e+01,0.20182e+01, &
        & 0.20154e+01,0.19654e+01,0.18384e+01,0.14948e+01 /)
      kao(:, 4, 4, 8) = (/ &
        & 0.14229e+01,0.17461e+01,0.19072e+01,0.19926e+01,0.20303e+01, &
        & 0.20234e+01,0.19691e+01,0.18420e+01,0.15040e+01 /)
      kao(:, 5, 4, 8) = (/ &
        & 0.14534e+01,0.17751e+01,0.19345e+01,0.20154e+01,0.20467e+01, &
        & 0.20337e+01,0.19742e+01,0.18465e+01,0.15131e+01 /)
      kao(:, 1, 5, 8) = (/ &
        & 0.11675e+01,0.14906e+01,0.16422e+01,0.17364e+01,0.17875e+01, &
        & 0.17970e+01,0.17582e+01,0.16459e+01,0.13057e+01 /)
      kao(:, 2, 5, 8) = (/ &
        & 0.11839e+01,0.15062e+01,0.16573e+01,0.17483e+01,0.17956e+01, &
        & 0.18020e+01,0.17623e+01,0.16529e+01,0.13176e+01 /)
      kao(:, 3, 5, 8) = (/ &
        & 0.12061e+01,0.15281e+01,0.16790e+01,0.17660e+01,0.18082e+01, &
        & 0.18106e+01,0.17678e+01,0.16587e+01,0.13289e+01 /)
      kao(:, 4, 5, 8) = (/ &
        & 0.12311e+01,0.15549e+01,0.17048e+01,0.17877e+01,0.18250e+01, &
        & 0.18222e+01,0.17742e+01,0.16644e+01,0.13398e+01 /)
      kao(:, 5, 5, 8) = (/ &
        & 0.12582e+01,0.15836e+01,0.17338e+01,0.18131e+01,0.18457e+01, &
        & 0.18359e+01,0.17826e+01,0.16710e+01,0.13507e+01 /)
      kao(:, 1, 6, 8) = (/ &
        & 0.99981e+00,0.13080e+01,0.14477e+01,0.15356e+01,0.15829e+01, &
        & 0.15936e+01,0.15636e+01,0.14683e+01,0.11482e+01 /)
      kao(:, 2, 6, 8) = (/ &
        & 0.10151e+01,0.13251e+01,0.14655e+01,0.15504e+01,0.15941e+01, &
        & 0.16015e+01,0.15698e+01,0.14767e+01,0.11619e+01 /)
      kao(:, 3, 6, 8) = (/ &
        & 0.10344e+01,0.13476e+01,0.14887e+01,0.15702e+01,0.16097e+01, &
        & 0.16130e+01,0.15772e+01,0.14847e+01,0.11743e+01 /)
      kao(:, 4, 6, 8) = (/ &
        & 0.10560e+01,0.13735e+01,0.15155e+01,0.15939e+01,0.16293e+01, &
        & 0.16276e+01,0.15870e+01,0.14924e+01,0.11864e+01 /)
      kao(:, 5, 6, 8) = (/ &
        & 0.10794e+01,0.13996e+01,0.15438e+01,0.16205e+01,0.16521e+01, &
        & 0.16451e+01,0.15991e+01,0.15003e+01,0.11982e+01 /)
      kao(:, 1, 7, 8) = (/ &
        & 0.85239e+00,0.11419e+01,0.12714e+01,0.13507e+01,0.13930e+01, &
        & 0.14039e+01,0.13790e+01,0.12971e+01,0.10034e+01 /)
      kao(:, 2, 7, 8) = (/ &
        & 0.86542e+00,0.11591e+01,0.12898e+01,0.13670e+01,0.14062e+01, &
        & 0.14139e+01,0.13871e+01,0.13072e+01,0.10179e+01 /)
      kao(:, 3, 7, 8) = (/ &
        & 0.88108e+00,0.11809e+01,0.13130e+01,0.13880e+01,0.14241e+01, &
        & 0.14278e+01,0.13975e+01,0.13172e+01,0.10310e+01 /)
      kao(:, 4, 7, 8) = (/ &
        & 0.89900e+00,0.12041e+01,0.13390e+01,0.14123e+01,0.14455e+01, &
        & 0.14453e+01,0.14105e+01,0.13266e+01,0.10434e+01 /)
      kao(:, 5, 7, 8) = (/ &
        & 0.91862e+00,0.12279e+01,0.13649e+01,0.14386e+01,0.14692e+01, &
        & 0.14664e+01,0.14254e+01,0.13367e+01,0.10558e+01 /)
      kao(:, 1, 8, 8) = (/ &
        & 0.72497e+00,0.99201e+00,0.11107e+01,0.11813e+01,0.12195e+01, &
        & 0.12285e+01,0.12058e+01,0.11359e+01,0.87110e+00 /)
      kao(:, 2, 8, 8) = (/ &
        & 0.73517e+00,0.10086e+01,0.11285e+01,0.11988e+01,0.12342e+01, &
        & 0.12405e+01,0.12160e+01,0.11479e+01,0.88568e+00 /)
      kao(:, 3, 8, 8) = (/ &
        & 0.74752e+00,0.10285e+01,0.11507e+01,0.12198e+01,0.12532e+01, &
        & 0.12570e+01,0.12289e+01,0.11589e+01,0.89927e+00 /)
      kao(:, 4, 8, 8) = (/ &
        & 0.76213e+00,0.10489e+01,0.11747e+01,0.12436e+01,0.12757e+01, &
        & 0.12769e+01,0.12445e+01,0.11700e+01,0.91203e+00 /)
      kao(:, 5, 8, 8) = (/ &
        & 0.77854e+00,0.10697e+01,0.11980e+01,0.12679e+01,0.13002e+01, &
        & 0.12994e+01,0.12621e+01,0.11816e+01,0.92392e+00 /)
      kao(:, 1, 9, 8) = (/ &
        & 0.61682e+00,0.85841e+00,0.96403e+00,0.10272e+01,0.10606e+01, &
        & 0.10679e+01,0.10472e+01,0.98715e+00,0.74825e+00 /)
      kao(:, 2, 9, 8) = (/ &
        & 0.62415e+00,0.87401e+00,0.98140e+00,0.10446e+01,0.10763e+01, &
        & 0.10811e+01,0.10593e+01,0.10003e+01,0.76294e+00 /)
      kao(:, 3, 9, 8) = (/ &
        & 0.63387e+00,0.89104e+00,0.10022e+01,0.10651e+01,0.10962e+01, &
        & 0.10997e+01,0.10740e+01,0.10120e+01,0.77659e+00 /)
      kao(:, 4, 9, 8) = (/ &
        & 0.64542e+00,0.90872e+00,0.10230e+01,0.10878e+01,0.11188e+01, &
        & 0.11207e+01,0.10911e+01,0.10243e+01,0.78905e+00 /)
      kao(:, 5, 9, 8) = (/ &
        & 0.65900e+00,0.92674e+00,0.10436e+01,0.11103e+01,0.11424e+01, &
        & 0.11435e+01,0.11102e+01,0.10375e+01,0.80034e+00 /)
      kao(:, 1,10, 8) = (/ &
        & 0.52547e+00,0.74220e+00,0.83433e+00,0.88890e+00,0.91741e+00, &
        & 0.92336e+00,0.90538e+00,0.85311e+00,0.64696e+00 /)
      kao(:, 2,10, 8) = (/ &
        & 0.53064e+00,0.75604e+00,0.85107e+00,0.90584e+00,0.93361e+00, &
        & 0.93836e+00,0.91861e+00,0.86626e+00,0.66062e+00 /)
      kao(:, 3,10, 8) = (/ &
        & 0.53809e+00,0.77037e+00,0.86942e+00,0.92562e+00,0.95409e+00, &
        & 0.95774e+00,0.93423e+00,0.87871e+00,0.67391e+00 /)
      kao(:, 4,10, 8) = (/ &
        & 0.54734e+00,0.78576e+00,0.88734e+00,0.94634e+00,0.97611e+00, &
        & 0.97890e+00,0.95253e+00,0.89191e+00,0.68526e+00 /)
      kao(:, 5,10, 8) = (/ &
        & 0.55842e+00,0.80129e+00,0.90542e+00,0.96675e+00,0.99781e+00, &
        & 0.10013e+01,0.97253e+00,0.90597e+00,0.69583e+00 /)
      kao(:, 1,11, 8) = (/ &
        & 0.44902e+00,0.64641e+00,0.72682e+00,0.77295e+00,0.79679e+00, &
        & 0.80095e+00,0.78478e+00,0.73880e+00,0.57500e+00 /)
      kao(:, 2,11, 8) = (/ &
        & 0.45343e+00,0.65819e+00,0.74259e+00,0.79030e+00,0.81509e+00, &
        & 0.81866e+00,0.79960e+00,0.75137e+00,0.58784e+00 /)
      kao(:, 3,11, 8) = (/ &
        & 0.45968e+00,0.67094e+00,0.75812e+00,0.80898e+00,0.83522e+00, &
        & 0.83854e+00,0.81711e+00,0.76461e+00,0.59939e+00 /)
      kao(:, 4,11, 8) = (/ &
        & 0.46764e+00,0.68418e+00,0.77402e+00,0.82711e+00,0.85518e+00, &
        & 0.85968e+00,0.83634e+00,0.77859e+00,0.60954e+00 /)
      kao(:, 5,11, 8) = (/ &
        & 0.47750e+00,0.69798e+00,0.79021e+00,0.84534e+00,0.87480e+00, &
        & 0.88011e+00,0.85595e+00,0.79269e+00,0.61896e+00 /)
      kao(:, 1,12, 8) = (/ &
        & 0.38252e+00,0.56123e+00,0.63221e+00,0.67207e+00,0.69191e+00, &
        & 0.69451e+00,0.67853e+00,0.63671e+00,0.49624e+00 /)
      kao(:, 2,12, 8) = (/ &
        & 0.38610e+00,0.57152e+00,0.64559e+00,0.68857e+00,0.70992e+00, &
        & 0.71250e+00,0.69440e+00,0.64948e+00,0.50772e+00 /)
      kao(:, 3,12, 8) = (/ &
        & 0.39135e+00,0.58251e+00,0.65953e+00,0.70459e+00,0.72793e+00, &
        & 0.73188e+00,0.71251e+00,0.66314e+00,0.51771e+00 /)
      kao(:, 4,12, 8) = (/ &
        & 0.39838e+00,0.59406e+00,0.67357e+00,0.72066e+00,0.74570e+00, &
        & 0.75075e+00,0.73108e+00,0.67696e+00,0.52680e+00 /)
      kao(:, 5,12, 8) = (/ &
        & 0.40785e+00,0.60628e+00,0.68802e+00,0.73685e+00,0.76342e+00, &
        & 0.76842e+00,0.74857e+00,0.69135e+00,0.53408e+00 /)
      kao(:, 1,13, 8) = (/ &
        & 0.32297e+00,0.48556e+00,0.54760e+00,0.58350e+00,0.60079e+00, &
        & 0.60116e+00,0.58518e+00,0.54699e+00,0.42276e+00 /)
      kao(:, 2,13, 8) = (/ &
        & 0.32591e+00,0.49445e+00,0.55963e+00,0.59764e+00,0.61654e+00, &
        & 0.61844e+00,0.60149e+00,0.55973e+00,0.43280e+00 /)
      kao(:, 3,13, 8) = (/ &
        & 0.33057e+00,0.50405e+00,0.57184e+00,0.61186e+00,0.63239e+00, &
        & 0.63557e+00,0.61864e+00,0.57305e+00,0.44151e+00 /)
      kao(:, 4,13, 8) = (/ &
        & 0.33705e+00,0.51427e+00,0.58428e+00,0.62614e+00,0.64825e+00, &
        & 0.65175e+00,0.63492e+00,0.58689e+00,0.44893e+00 /)
      kao(:, 5,13, 8) = (/ &
        & 0.34636e+00,0.52544e+00,0.59740e+00,0.64055e+00,0.66342e+00, &
        & 0.66736e+00,0.65002e+00,0.60055e+00,0.45487e+00 /)
      kao(:, 1, 1, 9) = (/ &
        & 0.72991e+01,0.69722e+01,0.72863e+01,0.75002e+01,0.75688e+01, &
        & 0.74622e+01,0.71020e+01,0.65825e+01,0.69144e+01 /)
      kao(:, 2, 1, 9) = (/ &
        & 0.72210e+01,0.69084e+01,0.72319e+01,0.74567e+01,0.75409e+01, &
        & 0.74459e+01,0.71001e+01,0.65930e+01,0.69213e+01 /)
      kao(:, 3, 1, 9) = (/ &
        & 0.71481e+01,0.68475e+01,0.71760e+01,0.74130e+01,0.75097e+01, &
        & 0.74266e+01,0.70905e+01,0.65992e+01,0.69258e+01 /)
      kao(:, 4, 1, 9) = (/ &
        & 0.70810e+01,0.67891e+01,0.71222e+01,0.73713e+01,0.74785e+01, &
        & 0.74023e+01,0.70766e+01,0.66037e+01,0.69303e+01 /)
      kao(:, 5, 1, 9) = (/ &
        & 0.70205e+01,0.67342e+01,0.70686e+01,0.73258e+01,0.74436e+01, &
        & 0.73740e+01,0.70585e+01,0.66060e+01,0.69339e+01 /)
      kao(:, 1, 2, 9) = (/ &
        & 0.68023e+01,0.66845e+01,0.71435e+01,0.74293e+01,0.75528e+01, &
        & 0.74805e+01,0.71383e+01,0.65087e+01,0.66425e+01 /)
      kao(:, 2, 2, 9) = (/ &
        & 0.67309e+01,0.66228e+01,0.70899e+01,0.73862e+01,0.75243e+01, &
        & 0.74671e+01,0.71358e+01,0.65240e+01,0.66588e+01 /)
      kao(:, 3, 2, 9) = (/ &
        & 0.66680e+01,0.65659e+01,0.70365e+01,0.73443e+01,0.74954e+01, &
        & 0.74486e+01,0.71260e+01,0.65367e+01,0.66745e+01 /)
      kao(:, 4, 2, 9) = (/ &
        & 0.66136e+01,0.65139e+01,0.69841e+01,0.73016e+01,0.74627e+01, &
        & 0.74252e+01,0.71129e+01,0.65455e+01,0.66889e+01 /)
      kao(:, 5, 2, 9) = (/ &
        & 0.65687e+01,0.64706e+01,0.69322e+01,0.72576e+01,0.74266e+01, &
        & 0.73967e+01,0.70986e+01,0.65510e+01,0.67011e+01 /)
      kao(:, 1, 3, 9) = (/ &
        & 0.62554e+01,0.63717e+01,0.69259e+01,0.72750e+01,0.74339e+01, &
        & 0.73812e+01,0.70638e+01,0.63830e+01,0.62738e+01 /)
      kao(:, 2, 3, 9) = (/ &
        & 0.61935e+01,0.63130e+01,0.68741e+01,0.72340e+01,0.74081e+01, &
        & 0.73723e+01,0.70661e+01,0.64055e+01,0.63017e+01 /)
      kao(:, 3, 3, 9) = (/ &
        & 0.61417e+01,0.62609e+01,0.68234e+01,0.71924e+01,0.73793e+01, &
        & 0.73559e+01,0.70613e+01,0.64217e+01,0.63259e+01 /)
      kao(:, 4, 3, 9) = (/ &
        & 0.61027e+01,0.62184e+01,0.67754e+01,0.71518e+01,0.73493e+01, &
        & 0.73341e+01,0.70537e+01,0.64352e+01,0.63471e+01 /)
      kao(:, 5, 3, 9) = (/ &
        & 0.60751e+01,0.61846e+01,0.67335e+01,0.71090e+01,0.73143e+01, &
        & 0.73100e+01,0.70431e+01,0.64459e+01,0.63674e+01 /)
      kao(:, 1, 4, 9) = (/ &
        & 0.56712e+01,0.60174e+01,0.66407e+01,0.70308e+01,0.72054e+01, &
        & 0.71700e+01,0.68768e+01,0.62076e+01,0.58601e+01 /)
      kao(:, 2, 4, 9) = (/ &
        & 0.56177e+01,0.59637e+01,0.65912e+01,0.69914e+01,0.71823e+01, &
        & 0.71644e+01,0.68840e+01,0.62360e+01,0.58965e+01 /)
      kao(:, 3, 4, 9) = (/ &
        & 0.55798e+01,0.59204e+01,0.65459e+01,0.69532e+01,0.71589e+01, &
        & 0.71503e+01,0.68872e+01,0.62571e+01,0.59275e+01 /)
      kao(:, 4, 4, 9) = (/ &
        & 0.55576e+01,0.58874e+01,0.65057e+01,0.69160e+01,0.71305e+01, &
        & 0.71327e+01,0.68860e+01,0.62738e+01,0.59560e+01 /)
      kao(:, 5, 4, 9) = (/ &
        & 0.55509e+01,0.58664e+01,0.64735e+01,0.68799e+01,0.70989e+01, &
        & 0.71129e+01,0.68803e+01,0.62864e+01,0.59817e+01 /)
      kao(:, 1, 5, 9) = (/ &
        & 0.50748e+01,0.56236e+01,0.62897e+01,0.66937e+01,0.68773e+01, &
        & 0.68583e+01,0.65966e+01,0.59739e+01,0.54247e+01 /)
      kao(:, 2, 5, 9) = (/ &
        & 0.50332e+01,0.55772e+01,0.62435e+01,0.66588e+01,0.68602e+01, &
        & 0.68553e+01,0.66099e+01,0.60056e+01,0.54668e+01 /)
      kao(:, 3, 5, 9) = (/ &
        & 0.50094e+01,0.55429e+01,0.62032e+01,0.66264e+01,0.68392e+01, &
        & 0.68457e+01,0.66198e+01,0.60291e+01,0.55024e+01 /)
      kao(:, 4, 5, 9) = (/ &
        & 0.50054e+01,0.55221e+01,0.61728e+01,0.65959e+01,0.68138e+01, &
        & 0.68347e+01,0.66239e+01,0.60504e+01,0.55378e+01 /)
      kao(:, 5, 5, 9) = (/ &
        & 0.50196e+01,0.55140e+01,0.61502e+01,0.65696e+01,0.67880e+01, &
        & 0.68224e+01,0.66232e+01,0.60661e+01,0.55660e+01 /)
      kao(:, 1, 6, 9) = (/ &
        & 0.44929e+01,0.51985e+01,0.58791e+01,0.62757e+01,0.64716e+01, &
        & 0.64669e+01,0.62368e+01,0.56853e+01,0.49792e+01 /)
      kao(:, 2, 6, 9) = (/ &
        & 0.44612e+01,0.51596e+01,0.58385e+01,0.62487e+01,0.64570e+01, &
        & 0.64678e+01,0.62575e+01,0.57196e+01,0.50244e+01 /)
      kao(:, 3, 6, 9) = (/ &
        & 0.44521e+01,0.51348e+01,0.58071e+01,0.62248e+01,0.64383e+01, &
        & 0.64639e+01,0.62747e+01,0.57459e+01,0.50676e+01 /)
      kao(:, 4, 6, 9) = (/ &
        & 0.44651e+01,0.51248e+01,0.57862e+01,0.62029e+01,0.64206e+01, &
        & 0.64594e+01,0.62829e+01,0.57703e+01,0.51061e+01 /)
      kao(:, 5, 6, 9) = (/ &
        & 0.44974e+01,0.51321e+01,0.57769e+01,0.61847e+01,0.64045e+01, &
        & 0.64518e+01,0.62850e+01,0.57880e+01,0.51383e+01 /)
      kao(:, 1, 7, 9) = (/ &
        & 0.39405e+01,0.47599e+01,0.54183e+01,0.58070e+01,0.60002e+01, &
        & 0.60137e+01,0.58231e+01,0.53430e+01,0.45395e+01 /)
      kao(:, 2, 7, 9) = (/ &
        & 0.39200e+01,0.47279e+01,0.53865e+01,0.57866e+01,0.59900e+01, &
        & 0.60178e+01,0.58493e+01,0.53803e+01,0.45897e+01 /)
      kao(:, 3, 7, 9) = (/ &
        & 0.39243e+01,0.47128e+01,0.53651e+01,0.57689e+01,0.59779e+01, &
        & 0.60210e+01,0.58689e+01,0.54093e+01,0.46370e+01 /)
      kao(:, 4, 7, 9) = (/ &
        & 0.39509e+01,0.47158e+01,0.53566e+01,0.57541e+01,0.59686e+01, &
        & 0.60221e+01,0.58794e+01,0.54360e+01,0.46801e+01 /)
      kao(:, 5, 7, 9) = (/ &
        & 0.39997e+01,0.47365e+01,0.53625e+01,0.57480e+01,0.59641e+01, &
        & 0.60191e+01,0.58864e+01,0.54567e+01,0.47154e+01 /)
      kao(:, 1, 8, 9) = (/ &
        & 0.34277e+01,0.43224e+01,0.49312e+01,0.53036e+01,0.54930e+01, &
        & 0.55228e+01,0.53766e+01,0.49651e+01,0.41155e+01 /)
      kao(:, 2, 8, 9) = (/ &
        & 0.34174e+01,0.42976e+01,0.49104e+01,0.52883e+01,0.54862e+01, &
        & 0.55322e+01,0.54048e+01,0.50049e+01,0.41706e+01 /)
      kao(:, 3, 8, 9) = (/ &
        & 0.34328e+01,0.42901e+01,0.49000e+01,0.52782e+01,0.54821e+01, &
        & 0.55409e+01,0.54257e+01,0.50383e+01,0.42218e+01 /)
      kao(:, 4, 8, 9) = (/ &
        & 0.34724e+01,0.43054e+01,0.49030e+01,0.52739e+01,0.54825e+01, &
        & 0.55468e+01,0.54402e+01,0.50678e+01,0.42656e+01 /)
      kao(:, 5, 8, 9) = (/ &
        & 0.35331e+01,0.43394e+01,0.49199e+01,0.52816e+01,0.54871e+01, &
        & 0.55512e+01,0.54505e+01,0.50918e+01,0.43035e+01 /)
      kao(:, 1, 9, 9) = (/ &
        & 0.29643e+01,0.38841e+01,0.44459e+01,0.47885e+01,0.49734e+01, &
        & 0.50221e+01,0.49131e+01,0.45659e+01,0.37057e+01 /)
      kao(:, 2, 9, 9) = (/ &
        & 0.29616e+01,0.38662e+01,0.44298e+01,0.47788e+01,0.49743e+01, &
        & 0.50365e+01,0.49428e+01,0.46088e+01,0.37656e+01 /)
      kao(:, 3, 9, 9) = (/ &
        & 0.29848e+01,0.38693e+01,0.44274e+01,0.47752e+01,0.49768e+01, &
        & 0.50477e+01,0.49663e+01,0.46464e+01,0.38194e+01 /)
      kao(:, 4, 9, 9) = (/ &
        & 0.30329e+01,0.38944e+01,0.44404e+01,0.47824e+01,0.49850e+01, &
        & 0.50582e+01,0.49851e+01,0.46790e+01,0.38645e+01 /)
      kao(:, 5, 9, 9) = (/ &
        & 0.31033e+01,0.39395e+01,0.44689e+01,0.48029e+01,0.49990e+01, &
        & 0.50689e+01,0.50004e+01,0.47030e+01,0.39063e+01 /)
      kao(:, 1,10, 9) = (/ &
        & 0.25528e+01,0.34541e+01,0.39652e+01,0.42831e+01,0.44659e+01, &
        & 0.45285e+01,0.44509e+01,0.41587e+01,0.32612e+01 /)
      kao(:, 2,10, 9) = (/ &
        & 0.25575e+01,0.34458e+01,0.39558e+01,0.42802e+01,0.44723e+01, &
        & 0.45451e+01,0.44820e+01,0.42051e+01,0.33240e+01 /)
      kao(:, 3,10, 9) = (/ &
        & 0.25883e+01,0.34607e+01,0.39625e+01,0.42854e+01,0.44811e+01, &
        & 0.45602e+01,0.45090e+01,0.42460e+01,0.33785e+01 /)
      kao(:, 4,10, 9) = (/ &
        & 0.26435e+01,0.34963e+01,0.39867e+01,0.43038e+01,0.44956e+01, &
        & 0.45761e+01,0.45312e+01,0.42799e+01,0.34270e+01 /)
      kao(:, 5,10, 9) = (/ &
        & 0.27203e+01,0.35517e+01,0.40270e+01,0.43344e+01,0.45189e+01, &
        & 0.45941e+01,0.45504e+01,0.43065e+01,0.34705e+01 /)
      kao(:, 1,11, 9) = (/ &
        & 0.21958e+01,0.30498e+01,0.35059e+01,0.38049e+01,0.39876e+01, &
        & 0.40622e+01,0.40123e+01,0.37729e+01,0.28786e+01 /)
      kao(:, 2,11, 9) = (/ &
        & 0.22177e+01,0.30598e+01,0.35116e+01,0.38116e+01,0.39989e+01, &
        & 0.40819e+01,0.40442e+01,0.38191e+01,0.29389e+01 /)
      kao(:, 3,11, 9) = (/ &
        & 0.22647e+01,0.30907e+01,0.35359e+01,0.38306e+01,0.40167e+01, &
        & 0.41020e+01,0.40724e+01,0.38578e+01,0.29915e+01 /)
      kao(:, 4,11, 9) = (/ &
        & 0.23337e+01,0.31425e+01,0.35763e+01,0.38632e+01,0.40437e+01, &
        & 0.41245e+01,0.40973e+01,0.38902e+01,0.30386e+01 /)
      kao(:, 5,11, 9) = (/ &
        & 0.24135e+01,0.32120e+01,0.36330e+01,0.39077e+01,0.40797e+01, &
        & 0.41526e+01,0.41204e+01,0.39195e+01,0.30818e+01 /)
      kao(:, 1,12, 9) = (/ &
        & 0.18956e+01,0.26861e+01,0.30931e+01,0.33674e+01,0.35425e+01, &
        & 0.36210e+01,0.35899e+01,0.33921e+01,0.25824e+01 /)
      kao(:, 2,12, 9) = (/ &
        & 0.19314e+01,0.27108e+01,0.31141e+01,0.33855e+01,0.35620e+01, &
        & 0.36450e+01,0.36224e+01,0.34362e+01,0.26351e+01 /)
      kao(:, 3,12, 9) = (/ &
        & 0.19899e+01,0.27565e+01,0.31515e+01,0.34177e+01,0.35909e+01, &
        & 0.36718e+01,0.36517e+01,0.34743e+01,0.26837e+01 /)
      kao(:, 4,12, 9) = (/ &
        & 0.20599e+01,0.28211e+01,0.32055e+01,0.34628e+01,0.36291e+01, &
        & 0.37038e+01,0.36800e+01,0.35081e+01,0.27286e+01 /)
      kao(:, 5,12, 9) = (/ &
        & 0.21342e+01,0.28994e+01,0.32752e+01,0.35201e+01,0.36745e+01, &
        & 0.37420e+01,0.37112e+01,0.35392e+01,0.27703e+01 /)
      kao(:, 1,13, 9) = (/ &
        & 0.16403e+01,0.23651e+01,0.27290e+01,0.29746e+01,0.31326e+01, &
        & 0.32080e+01,0.31891e+01,0.30274e+01,0.23307e+01 /)
      kao(:, 2,13, 9) = (/ &
        & 0.16863e+01,0.24025e+01,0.27611e+01,0.30044e+01,0.31618e+01, &
        & 0.32369e+01,0.32226e+01,0.30700e+01,0.23815e+01 /)
      kao(:, 3,13, 9) = (/ &
        & 0.17455e+01,0.24598e+01,0.28102e+01,0.30475e+01,0.32007e+01, &
        & 0.32722e+01,0.32554e+01,0.31073e+01,0.24291e+01 /)
      kao(:, 4,13, 9) = (/ &
        & 0.18100e+01,0.25311e+01,0.28759e+01,0.31035e+01,0.32472e+01, &
        & 0.33131e+01,0.32901e+01,0.31417e+01,0.24730e+01 /)
      kao(:, 5,13, 9) = (/ &
        & 0.18736e+01,0.26085e+01,0.29527e+01,0.31711e+01,0.33027e+01, &
        & 0.33589e+01,0.33290e+01,0.31763e+01,0.25126e+01 /)
      kao(:, 1, 1,10) = (/ &
        & 0.19065e+02,0.16899e+02,0.15643e+02,0.15578e+02,0.15043e+02, &
        & 0.14288e+02,0.13684e+02,0.14703e+02,0.16312e+02 /)
      kao(:, 2, 1,10) = (/ &
        & 0.18912e+02,0.16761e+02,0.15514e+02,0.15480e+02,0.14973e+02, &
        & 0.14273e+02,0.13717e+02,0.14749e+02,0.16352e+02 /)
      kao(:, 3, 1,10) = (/ &
        & 0.18728e+02,0.16596e+02,0.15380e+02,0.15367e+02,0.14915e+02, &
        & 0.14240e+02,0.13761e+02,0.14772e+02,0.16373e+02 /)
      kao(:, 4, 1,10) = (/ &
        & 0.18544e+02,0.16434e+02,0.15250e+02,0.15223e+02,0.14839e+02, &
        & 0.14214e+02,0.13761e+02,0.14749e+02,0.16351e+02 /)
      kao(:, 5, 1,10) = (/ &
        & 0.18333e+02,0.16256e+02,0.15122e+02,0.15098e+02,0.14749e+02, &
        & 0.14176e+02,0.13735e+02,0.14720e+02,0.16309e+02 /)
      kao(:, 1, 2,10) = (/ &
        & 0.19359e+02,0.17148e+02,0.16419e+02,0.16424e+02,0.16006e+02, &
        & 0.15375e+02,0.14545e+02,0.15202e+02,0.16997e+02 /)
      kao(:, 2, 2,10) = (/ &
        & 0.19172e+02,0.16980e+02,0.16267e+02,0.16317e+02,0.15911e+02, &
        & 0.15334e+02,0.14618e+02,0.15283e+02,0.17084e+02 /)
      kao(:, 3, 2,10) = (/ &
        & 0.18973e+02,0.16804e+02,0.16126e+02,0.16185e+02,0.15827e+02, &
        & 0.15302e+02,0.14664e+02,0.15280e+02,0.17092e+02 /)
      kao(:, 4, 2,10) = (/ &
        & 0.18751e+02,0.16617e+02,0.15988e+02,0.16055e+02,0.15738e+02, &
        & 0.15272e+02,0.14654e+02,0.15237e+02,0.17035e+02 /)
      kao(:, 5, 2,10) = (/ &
        & 0.18520e+02,0.16417e+02,0.15855e+02,0.15950e+02,0.15639e+02, &
        & 0.15219e+02,0.14617e+02,0.15192e+02,0.16961e+02 /)
      kao(:, 1, 3,10) = (/ &
        & 0.19263e+02,0.17075e+02,0.17060e+02,0.17120e+02,0.16883e+02, &
        & 0.16381e+02,0.15414e+02,0.15455e+02,0.17398e+02 /)
      kao(:, 2, 3,10) = (/ &
        & 0.19059e+02,0.16894e+02,0.16898e+02,0.17000e+02,0.16773e+02, &
        & 0.16323e+02,0.15500e+02,0.15491e+02,0.17437e+02 /)
      kao(:, 3, 3,10) = (/ &
        & 0.18835e+02,0.16708e+02,0.16745e+02,0.16865e+02,0.16669e+02, &
        & 0.16285e+02,0.15530e+02,0.15496e+02,0.17423e+02 /)
      kao(:, 4, 3,10) = (/ &
        & 0.18600e+02,0.16513e+02,0.16588e+02,0.16744e+02,0.16560e+02, &
        & 0.16244e+02,0.15515e+02,0.15476e+02,0.17372e+02 /)
      kao(:, 5, 3,10) = (/ &
        & 0.18358e+02,0.16312e+02,0.16416e+02,0.16627e+02,0.16462e+02, &
        & 0.16172e+02,0.15490e+02,0.15433e+02,0.17293e+02 /)
      kao(:, 1, 4,10) = (/ &
        & 0.18801e+02,0.16888e+02,0.17351e+02,0.17638e+02,0.17654e+02, &
        & 0.17241e+02,0.16305e+02,0.15458e+02,0.17321e+02 /)
      kao(:, 2, 4,10) = (/ &
        & 0.18579e+02,0.16692e+02,0.17197e+02,0.17496e+02,0.17520e+02, &
        & 0.17188e+02,0.16384e+02,0.15486e+02,0.17346e+02 /)
      kao(:, 3, 4,10) = (/ &
        & 0.18342e+02,0.16488e+02,0.17035e+02,0.17349e+02,0.17380e+02, &
        & 0.17158e+02,0.16385e+02,0.15526e+02,0.17367e+02 /)
      kao(:, 4, 4,10) = (/ &
        & 0.18091e+02,0.16279e+02,0.16863e+02,0.17208e+02,0.17266e+02, &
        & 0.17103e+02,0.16355e+02,0.15560e+02,0.17358e+02 /)
      kao(:, 5, 4,10) = (/ &
        & 0.17836e+02,0.16059e+02,0.16677e+02,0.17068e+02,0.17166e+02, &
        & 0.17011e+02,0.16312e+02,0.15578e+02,0.17344e+02 /)
      kao(:, 1, 5,10) = (/ &
        & 0.17961e+02,0.16659e+02,0.17334e+02,0.17976e+02,0.18171e+02, &
        & 0.17832e+02,0.16966e+02,0.15432e+02,0.16855e+02 /)
      kao(:, 2, 5,10) = (/ &
        & 0.17714e+02,0.16442e+02,0.17178e+02,0.17800e+02,0.18030e+02, &
        & 0.17804e+02,0.17004e+02,0.15487e+02,0.16904e+02 /)
      kao(:, 3, 5,10) = (/ &
        & 0.17470e+02,0.16231e+02,0.17012e+02,0.17636e+02,0.17902e+02, &
        & 0.17774e+02,0.16959e+02,0.15590e+02,0.16987e+02 /)
      kao(:, 4, 5,10) = (/ &
        & 0.17221e+02,0.16002e+02,0.16835e+02,0.17477e+02,0.17804e+02, &
        & 0.17680e+02,0.16923e+02,0.15646e+02,0.17004e+02 /)
      kao(:, 5, 5,10) = (/ &
        & 0.16955e+02,0.15778e+02,0.16648e+02,0.17325e+02,0.17709e+02, &
        & 0.17576e+02,0.16895e+02,0.15664e+02,0.17027e+02 /)
      kao(:, 1, 6,10) = (/ &
        & 0.16796e+02,0.16241e+02,0.17123e+02,0.18098e+02,0.18345e+02, &
        & 0.18145e+02,0.17297e+02,0.15317e+02,0.16076e+02 /)
      kao(:, 2, 6,10) = (/ &
        & 0.16561e+02,0.16019e+02,0.16973e+02,0.17901e+02,0.18253e+02, &
        & 0.18123e+02,0.17284e+02,0.15411e+02,0.16194e+02 /)
      kao(:, 3, 6,10) = (/ &
        & 0.16307e+02,0.15790e+02,0.16801e+02,0.17722e+02,0.18189e+02, &
        & 0.18068e+02,0.17217e+02,0.15556e+02,0.16309e+02 /)
      kao(:, 4, 6,10) = (/ &
        & 0.16045e+02,0.15571e+02,0.16615e+02,0.17565e+02,0.18113e+02, &
        & 0.17968e+02,0.17201e+02,0.15625e+02,0.16374e+02 /)
      kao(:, 5, 6,10) = (/ &
        & 0.15792e+02,0.15350e+02,0.16424e+02,0.17437e+02,0.17997e+02, &
        & 0.17869e+02,0.17203e+02,0.15664e+02,0.16420e+02 /)
      kao(:, 1, 7,10) = (/ &
        & 0.15441e+02,0.15555e+02,0.16836e+02,0.17857e+02,0.18265e+02, &
        & 0.18114e+02,0.17249e+02,0.15143e+02,0.15078e+02 /)
      kao(:, 2, 7,10) = (/ &
        & 0.15190e+02,0.15341e+02,0.16649e+02,0.17679e+02,0.18211e+02, &
        & 0.18098e+02,0.17215e+02,0.15278e+02,0.15251e+02 /)
      kao(:, 3, 7,10) = (/ &
        & 0.14946e+02,0.15122e+02,0.16458e+02,0.17534e+02,0.18165e+02, &
        & 0.18029e+02,0.17165e+02,0.15443e+02,0.15389e+02 /)
      kao(:, 4, 7,10) = (/ &
        & 0.14700e+02,0.14908e+02,0.16252e+02,0.17424e+02,0.18072e+02, &
        & 0.17929e+02,0.17187e+02,0.15518e+02,0.15458e+02 /)
      kao(:, 5, 7,10) = (/ &
        & 0.14445e+02,0.14710e+02,0.16048e+02,0.17304e+02,0.17932e+02, &
        & 0.17873e+02,0.17206e+02,0.15573e+02,0.15541e+02 /)
      kao(:, 1, 8,10) = (/ &
        & 0.13963e+02,0.14641e+02,0.16339e+02,0.17287e+02,0.17853e+02, &
        & 0.17712e+02,0.16836e+02,0.14867e+02,0.13958e+02 /)
      kao(:, 2, 8,10) = (/ &
        & 0.13720e+02,0.14441e+02,0.16121e+02,0.17175e+02,0.17806e+02, &
        & 0.17701e+02,0.16817e+02,0.15013e+02,0.14139e+02 /)
      kao(:, 3, 8,10) = (/ &
        & 0.13475e+02,0.14253e+02,0.15918e+02,0.17071e+02,0.17741e+02, &
        & 0.17634e+02,0.16820e+02,0.15155e+02,0.14269e+02 /)
      kao(:, 4, 8,10) = (/ &
        & 0.13235e+02,0.14056e+02,0.15727e+02,0.16983e+02,0.17630e+02, &
        & 0.17564e+02,0.16869e+02,0.15238e+02,0.14383e+02 /)
      kao(:, 5, 8,10) = (/ &
        & 0.13009e+02,0.13855e+02,0.15556e+02,0.16857e+02,0.17508e+02, &
        & 0.17529e+02,0.16912e+02,0.15302e+02,0.14496e+02 /)
      kao(:, 1, 9,10) = (/ &
        & 0.12422e+02,0.13743e+02,0.15496e+02,0.16530e+02,0.17068e+02, &
        & 0.16944e+02,0.16119e+02,0.14360e+02,0.12852e+02 /)
      kao(:, 2, 9,10) = (/ &
        & 0.12195e+02,0.13543e+02,0.15328e+02,0.16447e+02,0.17000e+02, &
        & 0.16934e+02,0.16148e+02,0.14484e+02,0.13012e+02 /)
      kao(:, 3, 9,10) = (/ &
        & 0.11972e+02,0.13354e+02,0.15163e+02,0.16359e+02,0.16940e+02, &
        & 0.16900e+02,0.16191e+02,0.14599e+02,0.13152e+02 /)
      kao(:, 4, 9,10) = (/ &
        & 0.11752e+02,0.13166e+02,0.15011e+02,0.16249e+02,0.16842e+02, &
        & 0.16880e+02,0.16254e+02,0.14688e+02,0.13295e+02 /)
      kao(:, 5, 9,10) = (/ &
        & 0.11542e+02,0.12972e+02,0.14878e+02,0.16107e+02,0.16750e+02, &
        & 0.16884e+02,0.16301e+02,0.14790e+02,0.13417e+02 /)
      kao(:, 1,10,10) = (/ &
        & 0.10883e+02,0.12799e+02,0.14471e+02,0.15523e+02,0.15963e+02, &
        & 0.15867e+02,0.15188e+02,0.13687e+02,0.11830e+02 /)
      kao(:, 2,10,10) = (/ &
        & 0.10669e+02,0.12615e+02,0.14351e+02,0.15423e+02,0.15920e+02, &
        & 0.15883e+02,0.15251e+02,0.13796e+02,0.11997e+02 /)
      kao(:, 3,10,10) = (/ &
        & 0.10461e+02,0.12417e+02,0.14235e+02,0.15340e+02,0.15857e+02, &
        & 0.15885e+02,0.15315e+02,0.13895e+02,0.12154e+02 /)
      kao(:, 4,10,10) = (/ &
        & 0.10271e+02,0.12218e+02,0.14109e+02,0.15234e+02,0.15808e+02, &
        & 0.15905e+02,0.15383e+02,0.14000e+02,0.12311e+02 /)
      kao(:, 5,10,10) = (/ &
        & 0.10108e+02,0.12035e+02,0.13977e+02,0.15117e+02,0.15764e+02, &
        & 0.15927e+02,0.15450e+02,0.14121e+02,0.12430e+02 /)
      kao(:, 1,11,10) = (/ &
        & 0.93334e+01,0.11625e+02,0.13302e+02,0.14226e+02,0.14663e+02, &
        & 0.14671e+02,0.14179e+02,0.12958e+02,0.10939e+02 /)
      kao(:, 2,11,10) = (/ &
        & 0.91435e+01,0.11452e+02,0.13192e+02,0.14163e+02,0.14640e+02, &
        & 0.14697e+02,0.14256e+02,0.13072e+02,0.11104e+02 /)
      kao(:, 3,11,10) = (/ &
        & 0.89744e+01,0.11286e+02,0.13068e+02,0.14085e+02,0.14619e+02, &
        & 0.14728e+02,0.14326e+02,0.13192e+02,0.11276e+02 /)
      kao(:, 4,11,10) = (/ &
        & 0.88386e+01,0.11134e+02,0.12957e+02,0.14008e+02,0.14602e+02, &
        & 0.14761e+02,0.14404e+02,0.13322e+02,0.11423e+02 /)
      kao(:, 5,11,10) = (/ &
        & 0.88280e+01,0.11011e+02,0.12844e+02,0.13942e+02,0.14584e+02, &
        & 0.14790e+02,0.14494e+02,0.13437e+02,0.11537e+02 /)
      kao(:, 1,12,10) = (/ &
        & 0.79516e+01,0.10418e+02,0.11985e+02,0.12856e+02,0.13326e+02, &
        & 0.13448e+02,0.13142e+02,0.12163e+02,0.97408e+01 /)
      kao(:, 2,12,10) = (/ &
        & 0.78004e+01,0.10286e+02,0.11886e+02,0.12812e+02,0.13327e+02, &
        & 0.13488e+02,0.13229e+02,0.12301e+02,0.99474e+01 /)
      kao(:, 3,12,10) = (/ &
        & 0.76847e+01,0.10169e+02,0.11799e+02,0.12768e+02,0.13325e+02, &
        & 0.13529e+02,0.13323e+02,0.12442e+02,0.10130e+02 /)
      kao(:, 4,12,10) = (/ &
        & 0.76979e+01,0.10072e+02,0.11716e+02,0.12735e+02,0.13318e+02, &
        & 0.13569e+02,0.13422e+02,0.12581e+02,0.10272e+02 /)
      kao(:, 5,12,10) = (/ &
        & 0.78582e+01,0.10030e+02,0.11643e+02,0.12707e+02,0.13325e+02, &
        & 0.13613e+02,0.13505e+02,0.12682e+02,0.10410e+02 /)
      kao(:, 1,13,10) = (/ &
        & 0.68077e+01,0.92695e+01,0.10647e+02,0.11513e+02,0.12044e+02, &
        & 0.12269e+02,0.12092e+02,0.11295e+02,0.85103e+01 /)
      kao(:, 2,13,10) = (/ &
        & 0.67020e+01,0.91675e+01,0.10585e+02,0.11489e+02,0.12056e+02, &
        & 0.12329e+02,0.12198e+02,0.11449e+02,0.87111e+01 /)
      kao(:, 3,13,10) = (/ &
        & 0.67136e+01,0.90765e+01,0.10537e+02,0.11473e+02,0.12065e+02, &
        & 0.12379e+02,0.12312e+02,0.11602e+02,0.88718e+01 /)
      kao(:, 4,13,10) = (/ &
        & 0.68715e+01,0.90508e+01,0.10490e+02,0.11454e+02,0.12087e+02, &
        & 0.12433e+02,0.12413e+02,0.11728e+02,0.90172e+01 /)
      kao(:, 5,13,10) = (/ &
        & 0.71183e+01,0.91466e+01,0.10479e+02,0.11436e+02,0.12120e+02, &
        & 0.12489e+02,0.12478e+02,0.11826e+02,0.91846e+01 /)
      kao(:, 1, 1,11) = (/ &
        & 0.25290e+02,0.22378e+02,0.19682e+02,0.19092e+02,0.18401e+02, &
        & 0.17330e+02,0.17194e+02,0.19513e+02,0.21546e+02 /)
      kao(:, 2, 1,11) = (/ &
        & 0.25153e+02,0.22251e+02,0.19574e+02,0.19002e+02,0.18309e+02, &
        & 0.17346e+02,0.17168e+02,0.19469e+02,0.21516e+02 /)
      kao(:, 3, 1,11) = (/ &
        & 0.24990e+02,0.22108e+02,0.19457e+02,0.18891e+02,0.18197e+02, &
        & 0.17344e+02,0.17153e+02,0.19435e+02,0.21516e+02 /)
      kao(:, 4, 1,11) = (/ &
        & 0.24785e+02,0.21926e+02,0.19312e+02,0.18774e+02,0.18111e+02, &
        & 0.17300e+02,0.17168e+02,0.19426e+02,0.21524e+02 /)
      kao(:, 5, 1,11) = (/ &
        & 0.24562e+02,0.21729e+02,0.19145e+02,0.18657e+02,0.18043e+02, &
        & 0.17239e+02,0.17190e+02,0.19400e+02,0.21517e+02 /)
      kao(:, 1, 2,11) = (/ &
        & 0.26738e+02,0.23635e+02,0.21164e+02,0.20882e+02,0.20133e+02, &
        & 0.18952e+02,0.18391e+02,0.20397e+02,0.22752e+02 /)
      kao(:, 2, 2,11) = (/ &
        & 0.26579e+02,0.23493e+02,0.21026e+02,0.20770e+02,0.20046e+02, &
        & 0.18924e+02,0.18351e+02,0.20302e+02,0.22673e+02 /)
      kao(:, 3, 2,11) = (/ &
        & 0.26369e+02,0.23304e+02,0.20847e+02,0.20634e+02,0.19955e+02, &
        & 0.18867e+02,0.18355e+02,0.20274e+02,0.22643e+02 /)
      kao(:, 4, 2,11) = (/ &
        & 0.26147e+02,0.23108e+02,0.20663e+02,0.20491e+02,0.19870e+02, &
        & 0.18790e+02,0.18365e+02,0.20271e+02,0.22638e+02 /)
      kao(:, 5, 2,11) = (/ &
        & 0.25876e+02,0.22867e+02,0.20457e+02,0.20308e+02,0.19788e+02, &
        & 0.18723e+02,0.18359e+02,0.20242e+02,0.22612e+02 /)
      kao(:, 1, 3,11) = (/ &
        & 0.27801e+02,0.24558e+02,0.22625e+02,0.22456e+02,0.21766e+02, &
        & 0.20723e+02,0.19785e+02,0.21193e+02,0.23811e+02 /)
      kao(:, 2, 3,11) = (/ &
        & 0.27586e+02,0.24366e+02,0.22444e+02,0.22341e+02,0.21670e+02, &
        & 0.20651e+02,0.19732e+02,0.21163e+02,0.23778e+02 /)
      kao(:, 3, 3,11) = (/ &
        & 0.27362e+02,0.24166e+02,0.22236e+02,0.22200e+02,0.21575e+02, &
        & 0.20557e+02,0.19718e+02,0.21155e+02,0.23783e+02 /)
      kao(:, 4, 3,11) = (/ &
        & 0.27084e+02,0.23919e+02,0.22013e+02,0.22018e+02,0.21471e+02, &
        & 0.20457e+02,0.19708e+02,0.21136e+02,0.23769e+02 /)
      kao(:, 5, 3,11) = (/ &
        & 0.26795e+02,0.23666e+02,0.21794e+02,0.21827e+02,0.21355e+02, &
        & 0.20374e+02,0.19655e+02,0.21092e+02,0.23724e+02 /)
      kao(:, 1, 4,11) = (/ &
        & 0.28327e+02,0.25026e+02,0.23910e+02,0.23720e+02,0.23265e+02, &
        & 0.22396e+02,0.21086e+02,0.21859e+02,0.24649e+02 /)
      kao(:, 2, 4,11) = (/ &
        & 0.28095e+02,0.24816e+02,0.23683e+02,0.23594e+02,0.23156e+02, &
        & 0.22304e+02,0.21023e+02,0.21873e+02,0.24674e+02 /)
      kao(:, 3, 4,11) = (/ &
        & 0.27817e+02,0.24569e+02,0.23454e+02,0.23446e+02,0.23031e+02, &
        & 0.22182e+02,0.21022e+02,0.21878e+02,0.24680e+02 /)
      kao(:, 4, 4,11) = (/ &
        & 0.27525e+02,0.24310e+02,0.23220e+02,0.23268e+02,0.22908e+02, &
        & 0.22090e+02,0.21022e+02,0.21824e+02,0.24620e+02 /)
      kao(:, 5, 4,11) = (/ &
        & 0.27191e+02,0.24023e+02,0.22996e+02,0.23072e+02,0.22769e+02, &
        & 0.22022e+02,0.20982e+02,0.21737e+02,0.24514e+02 /)
      kao(:, 1, 5,11) = (/ &
        & 0.28259e+02,0.25014e+02,0.24907e+02,0.24706e+02,0.24642e+02, &
        & 0.23918e+02,0.22330e+02,0.22219e+02,0.25091e+02 /)
      kao(:, 2, 5,11) = (/ &
        & 0.27993e+02,0.24771e+02,0.24666e+02,0.24596e+02,0.24487e+02, &
        & 0.23818e+02,0.22348e+02,0.22269e+02,0.25149e+02 /)
      kao(:, 3, 5,11) = (/ &
        & 0.27691e+02,0.24499e+02,0.24421e+02,0.24432e+02,0.24340e+02, &
        & 0.23705e+02,0.22420e+02,0.22242e+02,0.25109e+02 /)
      kao(:, 4, 5,11) = (/ &
        & 0.27357e+02,0.24214e+02,0.24178e+02,0.24253e+02,0.24191e+02, &
        & 0.23642e+02,0.22422e+02,0.22174e+02,0.25030e+02 /)
      kao(:, 5, 5,11) = (/ &
        & 0.27008e+02,0.23916e+02,0.23935e+02,0.24063e+02,0.24020e+02, &
        & 0.23572e+02,0.22355e+02,0.22132e+02,0.24957e+02 /)
      kao(:, 1, 6,11) = (/ &
        & 0.27627e+02,0.24841e+02,0.25414e+02,0.25513e+02,0.25788e+02, &
        & 0.25161e+02,0.23567e+02,0.22384e+02,0.25091e+02 /)
      kao(:, 2, 6,11) = (/ &
        & 0.27317e+02,0.24550e+02,0.25165e+02,0.25384e+02,0.25578e+02, &
        & 0.25083e+02,0.23662e+02,0.22423e+02,0.25102e+02 /)
      kao(:, 3, 6,11) = (/ &
        & 0.26994e+02,0.24259e+02,0.24926e+02,0.25206e+02,0.25391e+02, &
        & 0.25015e+02,0.23758e+02,0.22363e+02,0.25025e+02 /)
      kao(:, 4, 6,11) = (/ &
        & 0.26640e+02,0.23945e+02,0.24692e+02,0.25002e+02,0.25193e+02, &
        & 0.24973e+02,0.23733e+02,0.22328e+02,0.24965e+02 /)
      kao(:, 5, 6,11) = (/ &
        & 0.26265e+02,0.23625e+02,0.24446e+02,0.24785e+02,0.25037e+02, &
        & 0.24906e+02,0.23659e+02,0.22352e+02,0.24965e+02 /)
      kao(:, 1, 7,11) = (/ &
        & 0.26430e+02,0.24581e+02,0.25439e+02,0.26140e+02,0.26524e+02, &
        & 0.25974e+02,0.24552e+02,0.22441e+02,0.24498e+02 /)
      kao(:, 2, 7,11) = (/ &
        & 0.26105e+02,0.24263e+02,0.25225e+02,0.25974e+02,0.26315e+02, &
        & 0.25946e+02,0.24677e+02,0.22471e+02,0.24490e+02 /)
      kao(:, 3, 7,11) = (/ &
        & 0.25752e+02,0.23938e+02,0.24996e+02,0.25749e+02,0.26113e+02, &
        & 0.25925e+02,0.24758e+02,0.22442e+02,0.24454e+02 /)
      kao(:, 4, 7,11) = (/ &
        & 0.25389e+02,0.23609e+02,0.24761e+02,0.25499e+02,0.25940e+02, &
        & 0.25913e+02,0.24720e+02,0.22473e+02,0.24475e+02 /)
      kao(:, 5, 7,11) = (/ &
        & 0.25010e+02,0.23260e+02,0.24510e+02,0.25262e+02,0.25804e+02, &
        & 0.25811e+02,0.24640e+02,0.22547e+02,0.24534e+02 /)
      kao(:, 1, 8,11) = (/ &
        & 0.24762e+02,0.23997e+02,0.25209e+02,0.26467e+02,0.26748e+02, &
        & 0.26365e+02,0.25094e+02,0.22357e+02,0.23406e+02 /)
      kao(:, 2, 8,11) = (/ &
        & 0.24421e+02,0.23672e+02,0.24981e+02,0.26217e+02,0.26595e+02, &
        & 0.26375e+02,0.25195e+02,0.22435e+02,0.23453e+02 /)
      kao(:, 3, 8,11) = (/ &
        & 0.24067e+02,0.23336e+02,0.24754e+02,0.25956e+02,0.26455e+02, &
        & 0.26361e+02,0.25241e+02,0.22458e+02,0.23475e+02 /)
      kao(:, 4, 8,11) = (/ &
        & 0.23691e+02,0.22996e+02,0.24502e+02,0.25698e+02,0.26330e+02, &
        & 0.26343e+02,0.25197e+02,0.22533e+02,0.23575e+02 /)
      kao(:, 5, 8,11) = (/ &
        & 0.23311e+02,0.22660e+02,0.24234e+02,0.25450e+02,0.26215e+02, &
        & 0.26209e+02,0.25123e+02,0.22642e+02,0.23709e+02 /)
      kao(:, 1, 9,11) = (/ &
        & 0.22800e+02,0.23011e+02,0.24799e+02,0.26181e+02,0.26533e+02, &
        & 0.26301e+02,0.25044e+02,0.22077e+02,0.21907e+02 /)
      kao(:, 2, 9,11) = (/ &
        & 0.22436e+02,0.22697e+02,0.24546e+02,0.25945e+02,0.26460e+02, &
        & 0.26314e+02,0.25122e+02,0.22204e+02,0.22029e+02 /)
      kao(:, 3, 9,11) = (/ &
        & 0.22079e+02,0.22367e+02,0.24295e+02,0.25706e+02,0.26370e+02, &
        & 0.26288e+02,0.25162e+02,0.22314e+02,0.22151e+02 /)
      kao(:, 4, 9,11) = (/ &
        & 0.21719e+02,0.22029e+02,0.24017e+02,0.25487e+02,0.26273e+02, &
        & 0.26217e+02,0.25110e+02,0.22435e+02,0.22334e+02 /)
      kao(:, 5, 9,11) = (/ &
        & 0.21341e+02,0.21707e+02,0.23702e+02,0.25282e+02,0.26159e+02, &
        & 0.26086e+02,0.25065e+02,0.22578e+02,0.22506e+02 /)
      kao(:, 1,10,11) = (/ &
        & 0.20601e+02,0.21678e+02,0.24058e+02,0.25352e+02,0.25931e+02, &
        & 0.25718e+02,0.24432e+02,0.21607e+02,0.20262e+02 /)
      kao(:, 2,10,11) = (/ &
        & 0.20254e+02,0.21345e+02,0.23796e+02,0.25183e+02,0.25875e+02, &
        & 0.25691e+02,0.24508e+02,0.21774e+02,0.20445e+02 /)
      kao(:, 3,10,11) = (/ &
        & 0.19899e+02,0.21048e+02,0.23494e+02,0.25000e+02,0.25800e+02, &
        & 0.25662e+02,0.24533e+02,0.21922e+02,0.20638e+02 /)
      kao(:, 4,10,11) = (/ &
        & 0.19544e+02,0.20766e+02,0.23207e+02,0.24826e+02,0.25686e+02, &
        & 0.25593e+02,0.24527e+02,0.22085e+02,0.20832e+02 /)
      kao(:, 5,10,11) = (/ &
        & 0.19193e+02,0.20470e+02,0.22936e+02,0.24673e+02,0.25544e+02, &
        & 0.25480e+02,0.24537e+02,0.22218e+02,0.21044e+02 /)
      kao(:, 1,11,11) = (/ &
        & 0.18170e+02,0.20155e+02,0.22721e+02,0.24145e+02,0.24798e+02, &
        & 0.24559e+02,0.23403e+02,0.20895e+02,0.18740e+02 /)
      kao(:, 2,11,11) = (/ &
        & 0.17830e+02,0.19860e+02,0.22479e+02,0.24018e+02,0.24721e+02, &
        & 0.24556e+02,0.23466e+02,0.21069e+02,0.18949e+02 /)
      kao(:, 3,11,11) = (/ &
        & 0.17496e+02,0.19576e+02,0.22242e+02,0.23886e+02,0.24621e+02, &
        & 0.24529e+02,0.23525e+02,0.21231e+02,0.19147e+02 /)
      kao(:, 4,11,11) = (/ &
        & 0.17168e+02,0.19292e+02,0.22005e+02,0.23734e+02,0.24514e+02, &
        & 0.24476e+02,0.23580e+02,0.21376e+02,0.19368e+02 /)
      kao(:, 5,11,11) = (/ &
        & 0.16844e+02,0.19013e+02,0.21771e+02,0.23570e+02,0.24390e+02, &
        & 0.24440e+02,0.23651e+02,0.21517e+02,0.19612e+02 /)
      kao(:, 1,12,11) = (/ &
        & 0.15762e+02,0.18615e+02,0.21133e+02,0.22639e+02,0.23214e+02, &
        & 0.23022e+02,0.22060e+02,0.19958e+02,0.17314e+02 /)
      kao(:, 2,12,11) = (/ &
        & 0.15455e+02,0.18341e+02,0.20944e+02,0.22510e+02,0.23148e+02, &
        & 0.23042e+02,0.22164e+02,0.20127e+02,0.17543e+02 /)
      kao(:, 3,12,11) = (/ &
        & 0.15156e+02,0.18068e+02,0.20768e+02,0.22374e+02,0.23084e+02, &
        & 0.23060e+02,0.22257e+02,0.20275e+02,0.17770e+02 /)
      kao(:, 4,12,11) = (/ &
        & 0.14865e+02,0.17794e+02,0.20582e+02,0.22237e+02,0.23018e+02, &
        & 0.23079e+02,0.22350e+02,0.20427e+02,0.18026e+02 /)
      kao(:, 5,12,11) = (/ &
        & 0.14612e+02,0.17534e+02,0.20399e+02,0.22086e+02,0.22956e+02, &
        & 0.23112e+02,0.22443e+02,0.20607e+02,0.18280e+02 /)
      kao(:, 1,13,11) = (/ &
        & 0.13517e+02,0.16914e+02,0.19425e+02,0.20790e+02,0.21367e+02, &
        & 0.21315e+02,0.20607e+02,0.18871e+02,0.15967e+02 /)
      kao(:, 2,13,11) = (/ &
        & 0.13249e+02,0.16688e+02,0.19279e+02,0.20693e+02,0.21344e+02, &
        & 0.21372e+02,0.20725e+02,0.19043e+02,0.16217e+02 /)
      kao(:, 3,13,11) = (/ &
        & 0.12994e+02,0.16467e+02,0.19108e+02,0.20602e+02,0.21343e+02, &
        & 0.21436e+02,0.20839e+02,0.19212e+02,0.16494e+02 /)
      kao(:, 4,13,11) = (/ &
        & 0.12784e+02,0.16250e+02,0.18951e+02,0.20506e+02,0.21335e+02, &
        & 0.21503e+02,0.20961e+02,0.19415e+02,0.16770e+02 /)
      kao(:, 5,13,11) = (/ &
        & 0.12734e+02,0.16049e+02,0.18819e+02,0.20438e+02,0.21329e+02, &
        & 0.21573e+02,0.21104e+02,0.19623e+02,0.16983e+02 /)
      kao(:, 1, 1,12) = (/ &
        & 0.32549e+02,0.28774e+02,0.25031e+02,0.22926e+02,0.22117e+02, &
        & 0.21695e+02,0.23417e+02,0.26761e+02,0.29694e+02 /)
      kao(:, 2, 1,12) = (/ &
        & 0.32499e+02,0.28739e+02,0.25006e+02,0.22835e+02,0.22088e+02, &
        & 0.21560e+02,0.23253e+02,0.26542e+02,0.29377e+02 /)
      kao(:, 3, 1,12) = (/ &
        & 0.32407e+02,0.28660e+02,0.24923e+02,0.22714e+02,0.22014e+02, &
        & 0.21461e+02,0.23148e+02,0.26398e+02,0.29117e+02 /)
      kao(:, 4, 1,12) = (/ &
        & 0.32260e+02,0.28512e+02,0.24788e+02,0.22590e+02,0.21881e+02, &
        & 0.21430e+02,0.23071e+02,0.26295e+02,0.28961e+02 /)
      kao(:, 5, 1,12) = (/ &
        & 0.32039e+02,0.28307e+02,0.24614e+02,0.22444e+02,0.21715e+02, &
        & 0.21428e+02,0.22979e+02,0.26201e+02,0.28821e+02 /)
      kao(:, 1, 2,12) = (/ &
        & 0.35951e+02,0.31737e+02,0.27558e+02,0.25749e+02,0.24746e+02, &
        & 0.23905e+02,0.24887e+02,0.28459e+02,0.31791e+02 /)
      kao(:, 2, 2,12) = (/ &
        & 0.35862e+02,0.31672e+02,0.27501e+02,0.25642e+02,0.24725e+02, &
        & 0.23810e+02,0.24734e+02,0.28277e+02,0.31526e+02 /)
      kao(:, 3, 2,12) = (/ &
        & 0.35737e+02,0.31562e+02,0.27401e+02,0.25522e+02,0.24641e+02, &
        & 0.23751e+02,0.24591e+02,0.28127e+02,0.31321e+02 /)
      kao(:, 4, 2,12) = (/ &
        & 0.35534e+02,0.31380e+02,0.27248e+02,0.25379e+02,0.24498e+02, &
        & 0.23724e+02,0.24485e+02,0.28006e+02,0.31168e+02 /)
      kao(:, 5, 2,12) = (/ &
        & 0.35285e+02,0.31161e+02,0.27065e+02,0.25222e+02,0.24328e+02, &
        & 0.23689e+02,0.24406e+02,0.27908e+02,0.31060e+02 /)
      kao(:, 1, 3,12) = (/ &
        & 0.39089e+02,0.34457e+02,0.30041e+02,0.28724e+02,0.27574e+02, &
        & 0.26213e+02,0.26498e+02,0.30215e+02,0.33960e+02 /)
      kao(:, 2, 3,12) = (/ &
        & 0.38998e+02,0.34382e+02,0.29952e+02,0.28581e+02,0.27562e+02, &
        & 0.26150e+02,0.26309e+02,0.29980e+02,0.33662e+02 /)
      kao(:, 3, 3,12) = (/ &
        & 0.38820e+02,0.34217e+02,0.29804e+02,0.28424e+02,0.27473e+02, &
        & 0.26126e+02,0.26176e+02,0.29817e+02,0.33458e+02 /)
      kao(:, 4, 3,12) = (/ &
        & 0.38594e+02,0.34019e+02,0.29631e+02,0.28264e+02,0.27343e+02, &
        & 0.26103e+02,0.26063e+02,0.29657e+02,0.33303e+02 /)
      kao(:, 5, 3,12) = (/ &
        & 0.38290e+02,0.33755e+02,0.29411e+02,0.28094e+02,0.27189e+02, &
        & 0.26048e+02,0.25993e+02,0.29534e+02,0.33212e+02 /)
      kao(:, 1, 4,12) = (/ &
        & 0.41846e+02,0.36848e+02,0.32642e+02,0.31752e+02,0.30348e+02, &
        & 0.28783e+02,0.28429e+02,0.31940e+02,0.36003e+02 /)
      kao(:, 2, 4,12) = (/ &
        & 0.41706e+02,0.36722e+02,0.32481e+02,0.31589e+02,0.30346e+02, &
        & 0.28731e+02,0.28275e+02,0.31704e+02,0.35716e+02 /)
      kao(:, 3, 4,12) = (/ &
        & 0.41502e+02,0.36539e+02,0.32269e+02,0.31417e+02,0.30279e+02, &
        & 0.28696e+02,0.28151e+02,0.31470e+02,0.35494e+02 /)
      kao(:, 4, 4,12) = (/ &
        & 0.41217e+02,0.36286e+02,0.32033e+02,0.31226e+02,0.30155e+02, &
        & 0.28647e+02,0.28039e+02,0.31307e+02,0.35368e+02 /)
      kao(:, 5, 4,12) = (/ &
        & 0.40876e+02,0.35985e+02,0.31743e+02,0.31019e+02,0.30013e+02, &
        & 0.28553e+02,0.27986e+02,0.31205e+02,0.35294e+02 /)
      kao(:, 1, 5,12) = (/ &
        & 0.43995e+02,0.38706e+02,0.35200e+02,0.34595e+02,0.33005e+02, &
        & 0.31594e+02,0.30727e+02,0.33547e+02,0.37840e+02 /)
      kao(:, 2, 5,12) = (/ &
        & 0.43792e+02,0.38521e+02,0.34965e+02,0.34413e+02,0.33017e+02, &
        & 0.31523e+02,0.30579e+02,0.33292e+02,0.37593e+02 /)
      kao(:, 3, 5,12) = (/ &
        & 0.43530e+02,0.38288e+02,0.34710e+02,0.34215e+02,0.32953e+02, &
        & 0.31452e+02,0.30422e+02,0.33082e+02,0.37437e+02 /)
      kao(:, 4, 5,12) = (/ &
        & 0.43192e+02,0.37991e+02,0.34400e+02,0.33987e+02,0.32832e+02, &
        & 0.31362e+02,0.30341e+02,0.32970e+02,0.37357e+02 /)
      kao(:, 5, 5,12) = (/ &
        & 0.42817e+02,0.37661e+02,0.34079e+02,0.33725e+02,0.32688e+02, &
        & 0.31220e+02,0.30292e+02,0.32861e+02,0.37270e+02 /)
      kao(:, 1, 6,12) = (/ &
        & 0.45371e+02,0.39886e+02,0.37563e+02,0.36985e+02,0.35582e+02, &
        & 0.34395e+02,0.32997e+02,0.34724e+02,0.39202e+02 /)
      kao(:, 2, 6,12) = (/ &
        & 0.45116e+02,0.39656e+02,0.37269e+02,0.36794e+02,0.35596e+02, &
        & 0.34289e+02,0.32827e+02,0.34552e+02,0.39098e+02 /)
      kao(:, 3, 6,12) = (/ &
        & 0.44794e+02,0.39373e+02,0.36959e+02,0.36575e+02,0.35485e+02, &
        & 0.34189e+02,0.32665e+02,0.34424e+02,0.39024e+02 /)
      kao(:, 4, 6,12) = (/ &
        & 0.44425e+02,0.39049e+02,0.36596e+02,0.36352e+02,0.35337e+02, &
        & 0.34032e+02,0.32591e+02,0.34348e+02,0.38980e+02 /)
      kao(:, 5, 6,12) = (/ &
        & 0.43987e+02,0.38666e+02,0.36218e+02,0.36087e+02,0.35122e+02, &
        & 0.33853e+02,0.32536e+02,0.34232e+02,0.38883e+02 /)
      kao(:, 1, 7,12) = (/ &
        & 0.45829e+02,0.40296e+02,0.39507e+02,0.38911e+02,0.38052e+02, &
        & 0.37051e+02,0.34926e+02,0.35286e+02,0.39874e+02 /)
      kao(:, 2, 7,12) = (/ &
        & 0.45523e+02,0.40015e+02,0.39164e+02,0.38712e+02,0.37995e+02, &
        & 0.36879e+02,0.34780e+02,0.35237e+02,0.39916e+02 /)
      kao(:, 3, 7,12) = (/ &
        & 0.45143e+02,0.39672e+02,0.38788e+02,0.38484e+02,0.37843e+02, &
        & 0.36693e+02,0.34674e+02,0.35202e+02,0.39935e+02 /)
      kao(:, 4, 7,12) = (/ &
        & 0.44711e+02,0.39294e+02,0.38380e+02,0.38261e+02,0.37608e+02, &
        & 0.36475e+02,0.34639e+02,0.35181e+02,0.39952e+02 /)
      kao(:, 5, 7,12) = (/ &
        & 0.44229e+02,0.38875e+02,0.37956e+02,0.37973e+02,0.37347e+02, &
        & 0.36293e+02,0.34620e+02,0.35062e+02,0.39846e+02 /)
      kao(:, 1, 8,12) = (/ &
        & 0.45335e+02,0.40267e+02,0.40744e+02,0.40443e+02,0.40247e+02, &
        & 0.39223e+02,0.36584e+02,0.35367e+02,0.39844e+02 /)
      kao(:, 2, 8,12) = (/ &
        & 0.44955e+02,0.39893e+02,0.40398e+02,0.40216e+02,0.40115e+02, &
        & 0.39023e+02,0.36582e+02,0.35440e+02,0.40008e+02 /)
      kao(:, 3, 8,12) = (/ &
        & 0.44529e+02,0.39492e+02,0.39985e+02,0.39979e+02,0.39873e+02, &
        & 0.38831e+02,0.36587e+02,0.35498e+02,0.40121e+02 /)
      kao(:, 4, 8,12) = (/ &
        & 0.44061e+02,0.39061e+02,0.39564e+02,0.39715e+02,0.39565e+02, &
        & 0.38623e+02,0.36619e+02,0.35513e+02,0.40138e+02 /)
      kao(:, 5, 8,12) = (/ &
        & 0.43543e+02,0.38605e+02,0.39136e+02,0.39437e+02,0.39265e+02, &
        & 0.38474e+02,0.36637e+02,0.35396e+02,0.40011e+02 /)
      kao(:, 1, 9,12) = (/ &
        & 0.43909e+02,0.39954e+02,0.41167e+02,0.41626e+02,0.41945e+02, &
        & 0.40736e+02,0.38077e+02,0.35393e+02,0.39221e+02 /)
      kao(:, 2, 9,12) = (/ &
        & 0.43480e+02,0.39498e+02,0.40786e+02,0.41338e+02,0.41733e+02, &
        & 0.40609e+02,0.38181e+02,0.35523e+02,0.39397e+02 /)
      kao(:, 3, 9,12) = (/ &
        & 0.43002e+02,0.39038e+02,0.40373e+02,0.41094e+02,0.41410e+02, &
        & 0.40471e+02,0.38255e+02,0.35563e+02,0.39462e+02 /)
      kao(:, 4, 9,12) = (/ &
        & 0.42479e+02,0.38560e+02,0.39995e+02,0.40806e+02,0.41101e+02, &
        & 0.40341e+02,0.38344e+02,0.35573e+02,0.39457e+02 /)
      kao(:, 5, 9,12) = (/ &
        & 0.41942e+02,0.38060e+02,0.39621e+02,0.40473e+02,0.40785e+02, &
        & 0.40226e+02,0.38369e+02,0.35494e+02,0.39400e+02 /)
      kao(:, 1,10,12) = (/ &
        & 0.41598e+02,0.39277e+02,0.40964e+02,0.42358e+02,0.42727e+02, &
        & 0.41605e+02,0.39147e+02,0.35243e+02,0.37755e+02 /)
      kao(:, 2,10,12) = (/ &
        & 0.41110e+02,0.38804e+02,0.40573e+02,0.42061e+02,0.42547e+02, &
        & 0.41580e+02,0.39298e+02,0.35367e+02,0.37893e+02 /)
      kao(:, 3,10,12) = (/ &
        & 0.40607e+02,0.38301e+02,0.40218e+02,0.41774e+02,0.42273e+02, &
        & 0.41520e+02,0.39406e+02,0.35478e+02,0.38009e+02 /)
      kao(:, 4,10,12) = (/ &
        & 0.40087e+02,0.37793e+02,0.39835e+02,0.41418e+02,0.42009e+02, &
        & 0.41467e+02,0.39471e+02,0.35532e+02,0.38110e+02 /)
      kao(:, 5,10,12) = (/ &
        & 0.39528e+02,0.37276e+02,0.39445e+02,0.41009e+02,0.41755e+02, &
        & 0.41409e+02,0.39460e+02,0.35536e+02,0.38153e+02 /)
      kao(:, 1,11,12) = (/ &
        & 0.38423e+02,0.37785e+02,0.40246e+02,0.42229e+02,0.42700e+02, &
        & 0.41861e+02,0.39594e+02,0.34991e+02,0.35642e+02 /)
      kao(:, 2,11,12) = (/ &
        & 0.37903e+02,0.37296e+02,0.39841e+02,0.41927e+02,0.42539e+02, &
        & 0.41882e+02,0.39751e+02,0.35170e+02,0.35883e+02 /)
      kao(:, 3,11,12) = (/ &
        & 0.37383e+02,0.36809e+02,0.39442e+02,0.41575e+02,0.42342e+02, &
        & 0.41911e+02,0.39809e+02,0.35335e+02,0.36101e+02 /)
      kao(:, 4,11,12) = (/ &
        & 0.36841e+02,0.36301e+02,0.39055e+02,0.41199e+02,0.42145e+02, &
        & 0.41876e+02,0.39854e+02,0.35442e+02,0.36276e+02 /)
      kao(:, 5,11,12) = (/ &
        & 0.36274e+02,0.35783e+02,0.38676e+02,0.40833e+02,0.41945e+02, &
        & 0.41808e+02,0.39839e+02,0.35539e+02,0.36455e+02 /)
      kao(:, 1,12,12) = (/ &
        & 0.34828e+02,0.35770e+02,0.39099e+02,0.41221e+02,0.41958e+02, &
        & 0.41456e+02,0.39253e+02,0.34461e+02,0.33246e+02 /)
      kao(:, 2,12,12) = (/ &
        & 0.34304e+02,0.35295e+02,0.38700e+02,0.40987e+02,0.41846e+02, &
        & 0.41525e+02,0.39359e+02,0.34698e+02,0.33560e+02 /)
      kao(:, 3,12,12) = (/ &
        & 0.33784e+02,0.34798e+02,0.38311e+02,0.40707e+02,0.41743e+02, &
        & 0.41505e+02,0.39465e+02,0.34925e+02,0.33882e+02 /)
      kao(:, 4,12,12) = (/ &
        & 0.33241e+02,0.34324e+02,0.37917e+02,0.40393e+02,0.41632e+02, &
        & 0.41461e+02,0.39554e+02,0.35117e+02,0.34172e+02 /)
      kao(:, 5,12,12) = (/ &
        & 0.32710e+02,0.33867e+02,0.37489e+02,0.40112e+02,0.41490e+02, &
        & 0.41392e+02,0.39590e+02,0.35312e+02,0.34501e+02 /)
      kao(:, 1,13,12) = (/ &
        & 0.30997e+02,0.33431e+02,0.37385e+02,0.39653e+02,0.40610e+02, &
        & 0.40222e+02,0.38101e+02,0.33638e+02,0.30845e+02 /)
      kao(:, 2,13,12) = (/ &
        & 0.30492e+02,0.32952e+02,0.37042e+02,0.39451e+02,0.40583e+02, &
        & 0.40257e+02,0.38272e+02,0.33940e+02,0.31245e+02 /)
      kao(:, 3,13,12) = (/ &
        & 0.29985e+02,0.32520e+02,0.36699e+02,0.39235e+02,0.40521e+02, &
        & 0.40274e+02,0.38447e+02,0.34242e+02,0.31622e+02 /)
      kao(:, 4,13,12) = (/ &
        & 0.29485e+02,0.32102e+02,0.36327e+02,0.39047e+02,0.40416e+02, &
        & 0.40299e+02,0.38596e+02,0.34522e+02,0.32000e+02 /)
      kao(:, 5,13,12) = (/ &
        & 0.29016e+02,0.31685e+02,0.35962e+02,0.38852e+02,0.40311e+02, &
        & 0.40331e+02,0.38749e+02,0.34802e+02,0.32433e+02 /)
      kao(:, 1, 1,13) = (/ &
        & 0.40414e+02,0.35530e+02,0.30727e+02,0.26813e+02,0.26498e+02, &
        & 0.27724e+02,0.32451e+02,0.37296e+02,0.40920e+02 /)
      kao(:, 2, 1,13) = (/ &
        & 0.40378e+02,0.35506e+02,0.30718e+02,0.26787e+02,0.26360e+02, &
        & 0.27557e+02,0.32109e+02,0.36904e+02,0.40512e+02 /)
      kao(:, 3, 1,13) = (/ &
        & 0.40288e+02,0.35435e+02,0.30689e+02,0.26758e+02,0.26294e+02, &
        & 0.27365e+02,0.31721e+02,0.36448e+02,0.40077e+02 /)
      kao(:, 4, 1,13) = (/ &
        & 0.40152e+02,0.35337e+02,0.30607e+02,0.26666e+02,0.26235e+02, &
        & 0.27137e+02,0.31350e+02,0.36026e+02,0.39605e+02 /)
      kao(:, 5, 1,13) = (/ &
        & 0.39996e+02,0.35209e+02,0.30500e+02,0.26544e+02,0.26176e+02, &
        & 0.26906e+02,0.31054e+02,0.35676e+02,0.39227e+02 /)
      kao(:, 1, 2,13) = (/ &
        & 0.46201e+02,0.40631e+02,0.35149e+02,0.31004e+02,0.30338e+02, &
        & 0.30975e+02,0.35648e+02,0.41032e+02,0.45728e+02 /)
      kao(:, 2, 2,13) = (/ &
        & 0.46189e+02,0.40616e+02,0.35151e+02,0.30920e+02,0.30181e+02, &
        & 0.30854e+02,0.35321e+02,0.40601e+02,0.45258e+02 /)
      kao(:, 3, 2,13) = (/ &
        & 0.46107e+02,0.40548e+02,0.35109e+02,0.30814e+02,0.30060e+02, &
        & 0.30665e+02,0.34964e+02,0.40159e+02,0.44756e+02 /)
      kao(:, 4, 2,13) = (/ &
        & 0.45964e+02,0.40421e+02,0.35002e+02,0.30664e+02,0.29967e+02, &
        & 0.30436e+02,0.34636e+02,0.39757e+02,0.44299e+02 /)
      kao(:, 5, 2,13) = (/ &
        & 0.45779e+02,0.40257e+02,0.34861e+02,0.30500e+02,0.29866e+02, &
        & 0.30215e+02,0.34343e+02,0.39421e+02,0.43898e+02 /)
      kao(:, 1, 3,13) = (/ &
        & 0.52493e+02,0.46184e+02,0.39933e+02,0.35707e+02,0.34547e+02, &
        & 0.34524e+02,0.38680e+02,0.44581e+02,0.50362e+02 /)
      kao(:, 2, 3,13) = (/ &
        & 0.52499e+02,0.46190e+02,0.39958e+02,0.35613e+02,0.34342e+02, &
        & 0.34438e+02,0.38422e+02,0.44213e+02,0.49916e+02 /)
      kao(:, 3, 3,13) = (/ &
        & 0.52430e+02,0.46141e+02,0.39924e+02,0.35477e+02,0.34202e+02, &
        & 0.34294e+02,0.38128e+02,0.43804e+02,0.49438e+02 /)
      kao(:, 4, 3,13) = (/ &
        & 0.52296e+02,0.46021e+02,0.39821e+02,0.35288e+02,0.34063e+02, &
        & 0.34077e+02,0.37857e+02,0.43466e+02,0.49020e+02 /)
      kao(:, 5, 3,13) = (/ &
        & 0.52087e+02,0.45828e+02,0.39654e+02,0.35060e+02,0.33889e+02, &
        & 0.33876e+02,0.37613e+02,0.43182e+02,0.48640e+02 /)
      kao(:, 1, 4,13) = (/ &
        & 0.58998e+02,0.51894e+02,0.44809e+02,0.40767e+02,0.39196e+02, &
        & 0.38349e+02,0.41490e+02,0.47820e+02,0.54353e+02 /)
      kao(:, 2, 4,13) = (/ &
        & 0.58998e+02,0.51911e+02,0.44850e+02,0.40692e+02,0.38973e+02, &
        & 0.38281e+02,0.41275e+02,0.47479e+02,0.53941e+02 /)
      kao(:, 3, 4,13) = (/ &
        & 0.58946e+02,0.51872e+02,0.44826e+02,0.40545e+02,0.38818e+02, &
        & 0.38152e+02,0.41007e+02,0.47151e+02,0.53507e+02 /)
      kao(:, 4, 4,13) = (/ &
        & 0.58797e+02,0.51741e+02,0.44719e+02,0.40328e+02,0.38647e+02, &
        & 0.37950e+02,0.40768e+02,0.46871e+02,0.53108e+02 /)
      kao(:, 5, 4,13) = (/ &
        & 0.58578e+02,0.51549e+02,0.44555e+02,0.40074e+02,0.38419e+02, &
        & 0.37769e+02,0.40542e+02,0.46625e+02,0.52790e+02 /)
      kao(:, 1, 5,13) = (/ &
        & 0.65454e+02,0.57537e+02,0.49631e+02,0.46171e+02,0.44093e+02, &
        & 0.42375e+02,0.44216e+02,0.50929e+02,0.58021e+02 /)
      kao(:, 2, 5,13) = (/ &
        & 0.65480e+02,0.57591e+02,0.49679e+02,0.46047e+02,0.43916e+02, &
        & 0.42317e+02,0.44023e+02,0.50643e+02,0.57621e+02 /)
      kao(:, 3, 5,13) = (/ &
        & 0.65404e+02,0.57534e+02,0.49633e+02,0.45875e+02,0.43765e+02, &
        & 0.42200e+02,0.43791e+02,0.50364e+02,0.57215e+02 /)
      kao(:, 4, 5,13) = (/ &
        & 0.65236e+02,0.57393e+02,0.49518e+02,0.45648e+02,0.43596e+02, &
        & 0.42013e+02,0.43533e+02,0.50076e+02,0.56838e+02 /)
      kao(:, 5, 5,13) = (/ &
        & 0.64960e+02,0.57155e+02,0.49326e+02,0.45390e+02,0.43392e+02, &
        & 0.41855e+02,0.43285e+02,0.49832e+02,0.56537e+02 /)
      kao(:, 1, 6,13) = (/ &
        & 0.71553e+02,0.62830e+02,0.54580e+02,0.51897e+02,0.49249e+02, &
        & 0.46670e+02,0.47221e+02,0.54164e+02,0.61741e+02 /)
      kao(:, 2, 6,13) = (/ &
        & 0.71559e+02,0.62858e+02,0.54547e+02,0.51727e+02,0.49114e+02, &
        & 0.46626e+02,0.47093e+02,0.53907e+02,0.61336e+02 /)
      kao(:, 3, 6,13) = (/ &
        & 0.71474e+02,0.62796e+02,0.54422e+02,0.51491e+02,0.49001e+02, &
        & 0.46518e+02,0.46873e+02,0.53599e+02,0.60908e+02 /)
      kao(:, 4, 6,13) = (/ &
        & 0.71253e+02,0.62620e+02,0.54248e+02,0.51208e+02,0.48873e+02, &
        & 0.46377e+02,0.46595e+02,0.53243e+02,0.60469e+02 /)
      kao(:, 5, 6,13) = (/ &
        & 0.70931e+02,0.62354e+02,0.53993e+02,0.50888e+02,0.48719e+02, &
        & 0.46222e+02,0.46318e+02,0.52946e+02,0.60113e+02 /)
      kao(:, 1, 7,13) = (/ &
        & 0.76995e+02,0.67566e+02,0.59542e+02,0.57607e+02,0.54461e+02, &
        & 0.51316e+02,0.50984e+02,0.57643e+02,0.65674e+02 /)
      kao(:, 2, 7,13) = (/ &
        & 0.76958e+02,0.67548e+02,0.59397e+02,0.57376e+02,0.54369e+02, &
        & 0.51326e+02,0.50889e+02,0.57330e+02,0.65196e+02 /)
      kao(:, 3, 7,13) = (/ &
        & 0.76815e+02,0.67433e+02,0.59207e+02,0.57127e+02,0.54289e+02, &
        & 0.51287e+02,0.50622e+02,0.56904e+02,0.64662e+02 /)
      kao(:, 4, 7,13) = (/ &
        & 0.76535e+02,0.67198e+02,0.58948e+02,0.56779e+02,0.54224e+02, &
        & 0.51158e+02,0.50286e+02,0.56459e+02,0.64124e+02 /)
      kao(:, 5, 7,13) = (/ &
        & 0.76156e+02,0.66876e+02,0.58634e+02,0.56401e+02,0.54096e+02, &
        & 0.50976e+02,0.49973e+02,0.56129e+02,0.63785e+02 /)
      kao(:, 1, 8,13) = (/ &
        & 0.81421e+02,0.71418e+02,0.64455e+02,0.62977e+02,0.59643e+02, &
        & 0.56434e+02,0.55164e+02,0.60758e+02,0.69127e+02 /)
      kao(:, 2, 8,13) = (/ &
        & 0.81348e+02,0.71366e+02,0.64215e+02,0.62779e+02,0.59582e+02, &
        & 0.56462e+02,0.55001e+02,0.60346e+02,0.68584e+02 /)
      kao(:, 3, 8,13) = (/ &
        & 0.81121e+02,0.71177e+02,0.63909e+02,0.62467e+02,0.59508e+02, &
        & 0.56437e+02,0.54668e+02,0.59898e+02,0.68043e+02 /)
      kao(:, 4, 8,13) = (/ &
        & 0.80795e+02,0.70901e+02,0.63558e+02,0.62070e+02,0.59450e+02, &
        & 0.56283e+02,0.54317e+02,0.59470e+02,0.67583e+02 /)
      kao(:, 5, 8,13) = (/ &
        & 0.80315e+02,0.70489e+02,0.63126e+02,0.61649e+02,0.59298e+02, &
        & 0.56050e+02,0.54007e+02,0.59179e+02,0.67330e+02 /)
      kao(:, 1, 9,13) = (/ &
        & 0.84526e+02,0.74114e+02,0.69139e+02,0.67766e+02,0.64700e+02, &
        & 0.61791e+02,0.59295e+02,0.62885e+02,0.71468e+02 /)
      kao(:, 2, 9,13) = (/ &
        & 0.84370e+02,0.73989e+02,0.68856e+02,0.67565e+02,0.64593e+02, &
        & 0.61811e+02,0.59181e+02,0.62666e+02,0.71181e+02 /)
      kao(:, 3, 9,13) = (/ &
        & 0.84053e+02,0.73721e+02,0.68457e+02,0.67233e+02,0.64524e+02, &
        & 0.61778e+02,0.58870e+02,0.62384e+02,0.70849e+02 /)
      kao(:, 4, 9,13) = (/ &
        & 0.83638e+02,0.73367e+02,0.67980e+02,0.66820e+02,0.64408e+02, &
        & 0.61582e+02,0.58561e+02,0.62049e+02,0.70550e+02 /)
      kao(:, 5, 9,13) = (/ &
        & 0.83125e+02,0.72897e+02,0.67415e+02,0.66418e+02,0.64238e+02, &
        & 0.61304e+02,0.58306e+02,0.61805e+02,0.70366e+02 /)
      kao(:, 1,10,13) = (/ &
        & 0.86099e+02,0.75664e+02,0.73052e+02,0.71784e+02,0.69581e+02, &
        & 0.67013e+02,0.63079e+02,0.64019e+02,0.72668e+02 /)
      kao(:, 2,10,13) = (/ &
        & 0.85793e+02,0.75364e+02,0.72621e+02,0.71506e+02,0.69364e+02, &
        & 0.66992e+02,0.63098e+02,0.64105e+02,0.72738e+02 /)
      kao(:, 3,10,13) = (/ &
        & 0.85391e+02,0.74983e+02,0.72119e+02,0.71136e+02,0.69201e+02, &
        & 0.66897e+02,0.62939e+02,0.63964e+02,0.72620e+02 /)
      kao(:, 4,10,13) = (/ &
        & 0.84829e+02,0.74472e+02,0.71563e+02,0.70768e+02,0.69027e+02, &
        & 0.66600e+02,0.62760e+02,0.63750e+02,0.72497e+02 /)
      kao(:, 5,10,13) = (/ &
        & 0.84210e+02,0.73923e+02,0.70963e+02,0.70409e+02,0.68788e+02, &
        & 0.66285e+02,0.62604e+02,0.63643e+02,0.72460e+02 /)
      kao(:, 1,11,13) = (/ &
        & 0.85661e+02,0.75976e+02,0.75616e+02,0.74895e+02,0.73796e+02, &
        & 0.71450e+02,0.66595e+02,0.64723e+02,0.72988e+02 /)
      kao(:, 2,11,13) = (/ &
        & 0.85212e+02,0.75487e+02,0.75133e+02,0.74528e+02,0.73552e+02, &
        & 0.71413e+02,0.66688e+02,0.64835e+02,0.73147e+02 /)
      kao(:, 3,11,13) = (/ &
        & 0.84633e+02,0.74907e+02,0.74581e+02,0.74183e+02,0.73356e+02, &
        & 0.71194e+02,0.66687e+02,0.64831e+02,0.73292e+02 /)
      kao(:, 4,11,13) = (/ &
        & 0.83975e+02,0.74286e+02,0.73943e+02,0.73830e+02,0.73088e+02, &
        & 0.70916e+02,0.66610e+02,0.64920e+02,0.73470e+02 /)
      kao(:, 5,11,13) = (/ &
        & 0.83246e+02,0.73605e+02,0.73209e+02,0.73386e+02,0.72735e+02, &
        & 0.70587e+02,0.66523e+02,0.64950e+02,0.73537e+02 /)
      kao(:, 1,12,13) = (/ &
        & 0.83352e+02,0.75282e+02,0.76925e+02,0.77365e+02,0.77206e+02, &
        & 0.74850e+02,0.69716e+02,0.65048e+02,0.72181e+02 /)
      kao(:, 2,12,13) = (/ &
        & 0.82736e+02,0.74597e+02,0.76403e+02,0.76949e+02,0.76971e+02, &
        & 0.74863e+02,0.69929e+02,0.65330e+02,0.72664e+02 /)
      kao(:, 3,12,13) = (/ &
        & 0.82054e+02,0.73916e+02,0.75743e+02,0.76528e+02,0.76666e+02, &
        & 0.74738e+02,0.70022e+02,0.65629e+02,0.73075e+02 /)
      kao(:, 4,12,13) = (/ &
        & 0.81316e+02,0.73173e+02,0.75030e+02,0.76061e+02,0.76286e+02, &
        & 0.74512e+02,0.70083e+02,0.65825e+02,0.73345e+02 /)
      kao(:, 5,12,13) = (/ &
        & 0.80516e+02,0.72378e+02,0.74331e+02,0.75554e+02,0.75785e+02, &
        & 0.74233e+02,0.70124e+02,0.65929e+02,0.73501e+02 /)
      kao(:, 1,13,13) = (/ &
        & 0.79408e+02,0.73858e+02,0.76980e+02,0.78869e+02,0.79397e+02, &
        & 0.77263e+02,0.72263e+02,0.65338e+02,0.70604e+02 /)
      kao(:, 2,13,13) = (/ &
        & 0.78716e+02,0.73093e+02,0.76326e+02,0.78426e+02,0.79146e+02, &
        & 0.77408e+02,0.72561e+02,0.65807e+02,0.71230e+02 /)
      kao(:, 3,13,13) = (/ &
        & 0.77962e+02,0.72251e+02,0.75686e+02,0.77926e+02,0.78867e+02, &
        & 0.77356e+02,0.72810e+02,0.66137e+02,0.71698e+02 /)
      kao(:, 4,13,13) = (/ &
        & 0.77177e+02,0.71385e+02,0.75042e+02,0.77408e+02,0.78464e+02, &
        & 0.77172e+02,0.73006e+02,0.66333e+02,0.72067e+02 /)
      kao(:, 5,13,13) = (/ &
        & 0.76340e+02,0.70519e+02,0.74355e+02,0.76889e+02,0.78015e+02, &
        & 0.76988e+02,0.73079e+02,0.66485e+02,0.72407e+02 /)
      kao(:, 1, 1,14) = (/ &
        & 0.51404e+02,0.45212e+02,0.39078e+02,0.32978e+02,0.31213e+02, &
        & 0.35689e+02,0.42239e+02,0.49109e+02,0.53555e+02 /)
      kao(:, 2, 1,14) = (/ &
        & 0.51456e+02,0.45263e+02,0.39085e+02,0.32975e+02,0.31034e+02, &
        & 0.35237e+02,0.41756e+02,0.48531e+02,0.52877e+02 /)
      kao(:, 3, 1,14) = (/ &
        & 0.51419e+02,0.45226e+02,0.39013e+02,0.32932e+02,0.30826e+02, &
        & 0.34871e+02,0.41372e+02,0.48070e+02,0.52319e+02 /)
      kao(:, 4, 1,14) = (/ &
        & 0.51315e+02,0.45122e+02,0.38925e+02,0.32886e+02,0.30643e+02, &
        & 0.34565e+02,0.41054e+02,0.47690e+02,0.51853e+02 /)
      kao(:, 5, 1,14) = (/ &
        & 0.51134e+02,0.44958e+02,0.38787e+02,0.32819e+02,0.30476e+02, &
        & 0.34330e+02,0.40799e+02,0.47384e+02,0.51513e+02 /)
      kao(:, 1, 2,14) = (/ &
        & 0.59575e+02,0.52343e+02,0.45168e+02,0.38156e+02,0.36549e+02, &
        & 0.40798e+02,0.48433e+02,0.56320e+02,0.62499e+02 /)
      kao(:, 2, 2,14) = (/ &
        & 0.59656e+02,0.52415e+02,0.45196e+02,0.38159e+02,0.36356e+02, &
        & 0.40232e+02,0.47806e+02,0.55603e+02,0.61692e+02 /)
      kao(:, 3, 2,14) = (/ &
        & 0.59635e+02,0.52395e+02,0.45146e+02,0.38116e+02,0.36139e+02, &
        & 0.39805e+02,0.47339e+02,0.55046e+02,0.61068e+02 /)
      kao(:, 4, 2,14) = (/ &
        & 0.59522e+02,0.52285e+02,0.45051e+02,0.38066e+02,0.35889e+02, &
        & 0.39470e+02,0.46981e+02,0.54621e+02,0.60592e+02 /)
      kao(:, 5, 2,14) = (/ &
        & 0.59307e+02,0.52094e+02,0.44889e+02,0.37960e+02,0.35677e+02, &
        & 0.39216e+02,0.46687e+02,0.54268e+02,0.60193e+02 /)
      kao(:, 1, 3,14) = (/ &
        & 0.68809e+02,0.60397e+02,0.52025e+02,0.44161e+02,0.42701e+02, &
        & 0.46667e+02,0.55520e+02,0.64493e+02,0.72669e+02 /)
      kao(:, 2, 3,14) = (/ &
        & 0.68924e+02,0.60499e+02,0.52098e+02,0.44133e+02,0.42521e+02, &
        & 0.45966e+02,0.54732e+02,0.63594e+02,0.71705e+02 /)
      kao(:, 3, 3,14) = (/ &
        & 0.68950e+02,0.60531e+02,0.52101e+02,0.44100e+02,0.42285e+02, &
        & 0.45418e+02,0.54095e+02,0.62883e+02,0.70919e+02 /)
      kao(:, 4, 3,14) = (/ &
        & 0.68857e+02,0.60434e+02,0.52014e+02,0.44041e+02,0.42031e+02, &
        & 0.45005e+02,0.53564e+02,0.62291e+02,0.70247e+02 /)
      kao(:, 5, 3,14) = (/ &
        & 0.68666e+02,0.60265e+02,0.51871e+02,0.43942e+02,0.41842e+02, &
        & 0.44690e+02,0.53134e+02,0.61806e+02,0.69686e+02 /)
      kao(:, 1, 4,14) = (/ &
        & 0.79311e+02,0.69561e+02,0.59881e+02,0.51276e+02,0.49761e+02, &
        & 0.53193e+02,0.63396e+02,0.73656e+02,0.83652e+02 /)
      kao(:, 2, 4,14) = (/ &
        & 0.79511e+02,0.69736e+02,0.60019e+02,0.51173e+02,0.49594e+02, &
        & 0.52466e+02,0.62461e+02,0.72578e+02,0.82426e+02 /)
      kao(:, 3, 4,14) = (/ &
        & 0.79562e+02,0.69789e+02,0.60043e+02,0.51075e+02,0.49346e+02, &
        & 0.51847e+02,0.61639e+02,0.71632e+02,0.81369e+02 /)
      kao(:, 4, 4,14) = (/ &
        & 0.79512e+02,0.69733e+02,0.59989e+02,0.50979e+02,0.49088e+02, &
        & 0.51360e+02,0.60947e+02,0.70836e+02,0.80468e+02 /)
      kao(:, 5, 4,14) = (/ &
        & 0.79325e+02,0.69569e+02,0.59854e+02,0.50871e+02,0.48882e+02, &
        & 0.50991e+02,0.60362e+02,0.70161e+02,0.79701e+02 /)
      kao(:, 1, 5,14) = (/ &
        & 0.91112e+02,0.79892e+02,0.68781e+02,0.59496e+02,0.57988e+02, &
        & 0.60415e+02,0.71595e+02,0.83227e+02,0.94854e+02 /)
      kao(:, 2, 5,14) = (/ &
        & 0.91447e+02,0.80173e+02,0.69023e+02,0.59416e+02,0.57743e+02, &
        & 0.59673e+02,0.70483e+02,0.81942e+02,0.93394e+02 /)
      kao(:, 3, 5,14) = (/ &
        & 0.91583e+02,0.80288e+02,0.69106e+02,0.59276e+02,0.57416e+02, &
        & 0.59035e+02,0.69528e+02,0.80829e+02,0.92131e+02 /)
      kao(:, 4, 5,14) = (/ &
        & 0.91566e+02,0.80257e+02,0.69073e+02,0.59136e+02,0.57092e+02, &
        & 0.58527e+02,0.68724e+02,0.79885e+02,0.91053e+02 /)
      kao(:, 5, 5,14) = (/ &
        & 0.91390e+02,0.80104e+02,0.68937e+02,0.58973e+02,0.56776e+02, &
        & 0.58107e+02,0.68079e+02,0.79072e+02,0.90122e+02 /)
      kao(:, 1, 6,14) = (/ &
        & 0.10419e+03,0.91394e+02,0.78656e+02,0.68916e+02,0.67128e+02, &
        & 0.68461e+02,0.79894e+02,0.92926e+02,0.10607e+03 /)
      kao(:, 2, 6,14) = (/ &
        & 0.10463e+03,0.91782e+02,0.79002e+02,0.68819e+02,0.66845e+02, &
        & 0.67738e+02,0.78628e+02,0.91458e+02,0.10440e+03 /)
      kao(:, 3, 6,14) = (/ &
        & 0.10486e+03,0.91970e+02,0.79156e+02,0.68698e+02,0.66470e+02, &
        & 0.67066e+02,0.77628e+02,0.90242e+02,0.10302e+03 /)
      kao(:, 4, 6,14) = (/ &
        & 0.10494e+03,0.92025e+02,0.79207e+02,0.68555e+02,0.66081e+02, &
        & 0.66543e+02,0.76843e+02,0.89253e+02,0.10189e+03 /)
      kao(:, 5, 6,14) = (/ &
        & 0.10481e+03,0.91892e+02,0.79105e+02,0.68344e+02,0.65668e+02, &
        & 0.66109e+02,0.76190e+02,0.88386e+02,0.10090e+03 /)
      kao(:, 1, 7,14) = (/ &
        & 0.11850e+03,0.10394e+03,0.89423e+02,0.79509e+02,0.77207e+02, &
        & 0.77196e+02,0.87943e+02,0.10236e+03,0.11694e+03 /)
      kao(:, 2, 7,14) = (/ &
        & 0.11905e+03,0.10443e+03,0.89864e+02,0.79528e+02,0.76905e+02, &
        & 0.76494e+02,0.86650e+02,0.10078e+03,0.11515e+03 /)
      kao(:, 3, 7,14) = (/ &
        & 0.11939e+03,0.10473e+03,0.90115e+02,0.79401e+02,0.76523e+02, &
        & 0.75853e+02,0.85715e+02,0.99595e+02,0.11380e+03 /)
      kao(:, 4, 7,14) = (/ &
        & 0.11951e+03,0.10484e+03,0.90222e+02,0.79220e+02,0.76090e+02, &
        & 0.75405e+02,0.85022e+02,0.98653e+02,0.11271e+03 /)
      kao(:, 5, 7,14) = (/ &
        & 0.11942e+03,0.10476e+03,0.90169e+02,0.78976e+02,0.75607e+02, &
        & 0.75018e+02,0.84352e+02,0.97783e+02,0.11167e+03 /)
      kao(:, 1, 8,14) = (/ &
        & 0.13381e+03,0.11735e+03,0.10095e+03,0.91226e+02,0.88188e+02, &
        & 0.86379e+02,0.95828e+02,0.11155e+03,0.12755e+03 /)
      kao(:, 2, 8,14) = (/ &
        & 0.13446e+03,0.11794e+03,0.10145e+03,0.91271e+02,0.87947e+02, &
        & 0.85766e+02,0.94652e+02,0.11006e+03,0.12583e+03 /)
      kao(:, 3, 8,14) = (/ &
        & 0.13492e+03,0.11834e+03,0.10180e+03,0.91233e+02,0.87619e+02, &
        & 0.85228e+02,0.93811e+02,0.10892e+03,0.12452e+03 /)
      kao(:, 4, 8,14) = (/ &
        & 0.13505e+03,0.11846e+03,0.10192e+03,0.91090e+02,0.87150e+02, &
        & 0.84887e+02,0.93111e+02,0.10797e+03,0.12337e+03 /)
      kao(:, 5, 8,14) = (/ &
        & 0.13500e+03,0.11844e+03,0.10192e+03,0.90797e+02,0.86626e+02, &
        & 0.84570e+02,0.92421e+02,0.10710e+03,0.12226e+03 /)
      kao(:, 1, 9,14) = (/ &
        & 0.14952e+03,0.13110e+03,0.11316e+03,0.10410e+03,0.99927e+02, &
        & 0.96074e+02,0.10374e+03,0.12067e+03,0.13801e+03 /)
      kao(:, 2, 9,14) = (/ &
        & 0.15028e+03,0.13179e+03,0.11360e+03,0.10415e+03,0.99870e+02, &
        & 0.95589e+02,0.10257e+03,0.11912e+03,0.13623e+03 /)
      kao(:, 3, 9,14) = (/ &
        & 0.15082e+03,0.13227e+03,0.11392e+03,0.10405e+03,0.99571e+02, &
        & 0.95189e+02,0.10182e+03,0.11803e+03,0.13496e+03 /)
      kao(:, 4, 9,14) = (/ &
        & 0.15103e+03,0.13247e+03,0.11403e+03,0.10385e+03,0.99126e+02, &
        & 0.94980e+02,0.10122e+03,0.11720e+03,0.13388e+03 /)
      kao(:, 5, 9,14) = (/ &
        & 0.15094e+03,0.13245e+03,0.11401e+03,0.10348e+03,0.98550e+02, &
        & 0.94746e+02,0.10055e+03,0.11636e+03,0.13276e+03 /)
      kao(:, 1,10,14) = (/ &
        & 0.16524e+03,0.14486e+03,0.12594e+03,0.11785e+03,0.11225e+03, &
        & 0.10654e+03,0.11202e+03,0.12965e+03,0.14829e+03 /)
      kao(:, 2,10,14) = (/ &
        & 0.16610e+03,0.14564e+03,0.12636e+03,0.11787e+03,0.11233e+03, &
        & 0.10630e+03,0.11093e+03,0.12811e+03,0.14653e+03 /)
      kao(:, 3,10,14) = (/ &
        & 0.16659e+03,0.14608e+03,0.12656e+03,0.11769e+03,0.11214e+03, &
        & 0.10609e+03,0.11032e+03,0.12713e+03,0.14532e+03 /)
      kao(:, 4,10,14) = (/ &
        & 0.16681e+03,0.14630e+03,0.12659e+03,0.11736e+03,0.11169e+03, &
        & 0.10597e+03,0.10973e+03,0.12629e+03,0.14416e+03 /)
      kao(:, 5,10,14) = (/ &
        & 0.16671e+03,0.14623e+03,0.12639e+03,0.11688e+03,0.11111e+03, &
        & 0.10576e+03,0.10909e+03,0.12542e+03,0.14303e+03 /)
      kao(:, 1,11,14) = (/ &
        & 0.18065e+03,0.15832e+03,0.13903e+03,0.13201e+03,0.12519e+03, &
        & 0.11820e+03,0.12047e+03,0.13760e+03,0.15739e+03 /)
      kao(:, 2,11,14) = (/ &
        & 0.18131e+03,0.15893e+03,0.13916e+03,0.13183e+03,0.12520e+03, &
        & 0.11800e+03,0.11979e+03,0.13660e+03,0.15612e+03 /)
      kao(:, 3,11,14) = (/ &
        & 0.18162e+03,0.15925e+03,0.13912e+03,0.13145e+03,0.12487e+03, &
        & 0.11789e+03,0.11922e+03,0.13566e+03,0.15481e+03 /)
      kao(:, 4,11,14) = (/ &
        & 0.18161e+03,0.15927e+03,0.13888e+03,0.13091e+03,0.12432e+03, &
        & 0.11770e+03,0.11858e+03,0.13462e+03,0.15350e+03 /)
      kao(:, 5,11,14) = (/ &
        & 0.18129e+03,0.15901e+03,0.13849e+03,0.13027e+03,0.12371e+03, &
        & 0.11738e+03,0.11800e+03,0.13378e+03,0.15248e+03 /)
      kao(:, 1,12,14) = (/ &
        & 0.19439e+03,0.17031e+03,0.15181e+03,0.14577e+03,0.13828e+03, &
        & 0.13070e+03,0.12972e+03,0.14546e+03,0.16618e+03 /)
      kao(:, 2,12,14) = (/ &
        & 0.19483e+03,0.17073e+03,0.15156e+03,0.14543e+03,0.13812e+03, &
        & 0.13043e+03,0.12913e+03,0.14443e+03,0.16476e+03 /)
      kao(:, 3,12,14) = (/ &
        & 0.19494e+03,0.17087e+03,0.15124e+03,0.14493e+03,0.13771e+03, &
        & 0.13020e+03,0.12847e+03,0.14330e+03,0.16335e+03 /)
      kao(:, 4,12,14) = (/ &
        & 0.19474e+03,0.17073e+03,0.15078e+03,0.14425e+03,0.13718e+03, &
        & 0.12986e+03,0.12779e+03,0.14240e+03,0.16229e+03 /)
      kao(:, 5,12,14) = (/ &
        & 0.19420e+03,0.17029e+03,0.15011e+03,0.14337e+03,0.13666e+03, &
        & 0.12942e+03,0.12725e+03,0.14171e+03,0.16147e+03 /)
      kao(:, 1,13,14) = (/ &
        & 0.20562e+03,0.18014e+03,0.16395e+03,0.15885e+03,0.15131e+03, &
        & 0.14344e+03,0.13928e+03,0.15201e+03,0.17336e+03 /)
      kao(:, 2,13,14) = (/ &
        & 0.20583e+03,0.18034e+03,0.16346e+03,0.15844e+03,0.15102e+03, &
        & 0.14310e+03,0.13867e+03,0.15101e+03,0.17210e+03 /)
      kao(:, 3,13,14) = (/ &
        & 0.20579e+03,0.18034e+03,0.16282e+03,0.15782e+03,0.15051e+03, &
        & 0.14271e+03,0.13803e+03,0.15026e+03,0.17119e+03 /)
      kao(:, 4,13,14) = (/ &
        & 0.20539e+03,0.18002e+03,0.16199e+03,0.15696e+03,0.15005e+03, &
        & 0.14226e+03,0.13746e+03,0.14977e+03,0.17061e+03 /)
      kao(:, 5,13,14) = (/ &
        & 0.20471e+03,0.17946e+03,0.16101e+03,0.15580e+03,0.14942e+03, &
        & 0.14163e+03,0.13685e+03,0.14922e+03,0.16998e+03 /)
      kao(:, 1, 1,15) = (/ &
        & 0.61110e+02,0.53539e+02,0.46005e+02,0.38902e+02,0.35970e+02, &
        & 0.43986e+02,0.52608e+02,0.61157e+02,0.65911e+02 /)
      kao(:, 2, 1,15) = (/ &
        & 0.61315e+02,0.53717e+02,0.46235e+02,0.39083e+02,0.35687e+02, &
        & 0.43381e+02,0.51871e+02,0.60290e+02,0.64963e+02 /)
      kao(:, 3, 1,15) = (/ &
        & 0.61422e+02,0.53821e+02,0.46411e+02,0.39188e+02,0.35438e+02, &
        & 0.42839e+02,0.51205e+02,0.59514e+02,0.64157e+02 /)
      kao(:, 4, 1,15) = (/ &
        & 0.61394e+02,0.53877e+02,0.46504e+02,0.39222e+02,0.35189e+02, &
        & 0.42365e+02,0.50625e+02,0.58813e+02,0.63464e+02 /)
      kao(:, 5, 1,15) = (/ &
        & 0.61322e+02,0.53865e+02,0.46511e+02,0.39177e+02,0.34939e+02, &
        & 0.41926e+02,0.50070e+02,0.58152e+02,0.62761e+02 /)
      kao(:, 1, 2,15) = (/ &
        & 0.73139e+02,0.64054e+02,0.54971e+02,0.46172e+02,0.42554e+02, &
        & 0.52369e+02,0.62683e+02,0.72904e+02,0.80226e+02 /)
      kao(:, 2, 2,15) = (/ &
        & 0.73363e+02,0.64250e+02,0.55203e+02,0.46423e+02,0.42168e+02, &
        & 0.51668e+02,0.61839e+02,0.71917e+02,0.79110e+02 /)
      kao(:, 3, 2,15) = (/ &
        & 0.73487e+02,0.64383e+02,0.55429e+02,0.46632e+02,0.41828e+02, &
        & 0.50986e+02,0.61016e+02,0.70950e+02,0.78048e+02 /)
      kao(:, 4, 2,15) = (/ &
        & 0.73536e+02,0.64501e+02,0.55558e+02,0.46729e+02,0.41557e+02, &
        & 0.50314e+02,0.60204e+02,0.70005e+02,0.77009e+02 /)
      kao(:, 5, 2,15) = (/ &
        & 0.73500e+02,0.64509e+02,0.55582e+02,0.46709e+02,0.41283e+02, &
        & 0.49695e+02,0.59450e+02,0.69119e+02,0.76024e+02 /)
      kao(:, 1, 3,15) = (/ &
        & 0.87361e+02,0.76491e+02,0.65621e+02,0.54890e+02,0.50598e+02, &
        & 0.62297e+02,0.74612e+02,0.86825e+02,0.97550e+02 /)
      kao(:, 2, 3,15) = (/ &
        & 0.87685e+02,0.76774e+02,0.65885e+02,0.55188e+02,0.50206e+02, &
        & 0.61585e+02,0.73754e+02,0.85807e+02,0.96409e+02 /)
      kao(:, 3, 3,15) = (/ &
        & 0.87844e+02,0.76919e+02,0.66106e+02,0.55413e+02,0.49812e+02, &
        & 0.60785e+02,0.72789e+02,0.84689e+02,0.95141e+02 /)
      kao(:, 4, 3,15) = (/ &
        & 0.87889e+02,0.77037e+02,0.66247e+02,0.55541e+02,0.49446e+02, &
        & 0.60010e+02,0.71857e+02,0.83593e+02,0.93898e+02 /)
      kao(:, 5, 3,15) = (/ &
        & 0.87858e+02,0.77051e+02,0.66285e+02,0.55583e+02,0.49097e+02, &
        & 0.59241e+02,0.70929e+02,0.82513e+02,0.92686e+02 /)
      kao(:, 1, 4,15) = (/ &
        & 0.10387e+03,0.90929e+02,0.77989e+02,0.65095e+02,0.60436e+02, &
        & 0.74039e+02,0.88717e+02,0.10327e+03,0.11725e+03 /)
      kao(:, 2, 4,15) = (/ &
        & 0.10441e+03,0.91405e+02,0.78408e+02,0.65545e+02,0.59926e+02, &
        & 0.73070e+02,0.87549e+02,0.10190e+03,0.11570e+03 /)
      kao(:, 3, 4,15) = (/ &
        & 0.10471e+03,0.91680e+02,0.78722e+02,0.65845e+02,0.59509e+02, &
        & 0.72264e+02,0.86581e+02,0.10076e+03,0.11440e+03 /)
      kao(:, 4, 4,15) = (/ &
        & 0.10486e+03,0.91873e+02,0.78926e+02,0.66032e+02,0.59086e+02, &
        & 0.71381e+02,0.85514e+02,0.99526e+02,0.11299e+03 /)
      kao(:, 5, 4,15) = (/ &
        & 0.10483e+03,0.91879e+02,0.78952e+02,0.66063e+02,0.58651e+02, &
        & 0.70432e+02,0.84377e+02,0.98185e+02,0.11148e+03 /)
      kao(:, 1, 5,15) = (/ &
        & 0.12314e+03,0.10778e+03,0.92429e+02,0.77074e+02,0.72086e+02, &
        & 0.87688e+02,0.10511e+03,0.12238e+03,0.13959e+03 /)
      kao(:, 2, 5,15) = (/ &
        & 0.12380e+03,0.10836e+03,0.92922e+02,0.77571e+02,0.71572e+02, &
        & 0.86586e+02,0.10378e+03,0.12082e+03,0.13782e+03 /)
      kao(:, 3, 5,15) = (/ &
        & 0.12423e+03,0.10877e+03,0.93351e+02,0.77983e+02,0.71097e+02, &
        & 0.85507e+02,0.10249e+03,0.11931e+03,0.13609e+03 /)
      kao(:, 4, 5,15) = (/ &
        & 0.12450e+03,0.10905e+03,0.93631e+02,0.78238e+02,0.70653e+02, &
        & 0.84488e+02,0.10126e+03,0.11788e+03,0.13445e+03 /)
      kao(:, 5, 5,15) = (/ &
        & 0.12453e+03,0.10910e+03,0.93684e+02,0.78289e+02,0.70179e+02, &
        & 0.83403e+02,0.99954e+02,0.11636e+03,0.13271e+03 /)
      kao(:, 1, 6,15) = (/ &
        & 0.14538e+03,0.12724e+03,0.10910e+03,0.90962e+02,0.85931e+02, &
        & 0.10354e+03,0.12413e+03,0.14456e+03,0.16524e+03 /)
      kao(:, 2, 6,15) = (/ &
        & 0.14625e+03,0.12800e+03,0.10975e+03,0.91547e+02,0.85303e+02, &
        & 0.10223e+03,0.12256e+03,0.14271e+03,0.16313e+03 /)
      kao(:, 3, 6,15) = (/ &
        & 0.14683e+03,0.12855e+03,0.11028e+03,0.92053e+02,0.84796e+02, &
        & 0.10095e+03,0.12102e+03,0.14092e+03,0.16108e+03 /)
      kao(:, 4, 6,15) = (/ &
        & 0.14716e+03,0.12887e+03,0.11059e+03,0.92330e+02,0.84296e+02, &
        & 0.99657e+02,0.11947e+03,0.13910e+03,0.15900e+03 /)
      kao(:, 5, 6,15) = (/ &
        & 0.14726e+03,0.12897e+03,0.11069e+03,0.92414e+02,0.83857e+02, &
        & 0.98384e+02,0.11794e+03,0.13732e+03,0.15696e+03 /)
      kao(:, 1, 7,15) = (/ &
        & 0.17053e+03,0.14925e+03,0.12796e+03,0.10716e+03,0.10213e+03, &
        & 0.12188e+03,0.14615e+03,0.17020e+03,0.19480e+03 /)
      kao(:, 2, 7,15) = (/ &
        & 0.17172e+03,0.15029e+03,0.12885e+03,0.10758e+03,0.10144e+03, &
        & 0.12029e+03,0.14423e+03,0.16798e+03,0.19224e+03 /)
      kao(:, 3, 7,15) = (/ &
        & 0.17251e+03,0.15103e+03,0.12955e+03,0.10811e+03,0.10086e+03, &
        & 0.11869e+03,0.14231e+03,0.16572e+03,0.18967e+03 /)
      kao(:, 4, 7,15) = (/ &
        & 0.17303e+03,0.15150e+03,0.12997e+03,0.10845e+03,0.10032e+03, &
        & 0.11701e+03,0.14029e+03,0.16338e+03,0.18697e+03 /)
      kao(:, 5, 7,15) = (/ &
        & 0.17326e+03,0.15170e+03,0.13015e+03,0.10860e+03,0.99828e+02, &
        & 0.11540e+03,0.13837e+03,0.16114e+03,0.18440e+03 /)
      kao(:, 1, 8,15) = (/ &
        & 0.19897e+03,0.17412e+03,0.14927e+03,0.12609e+03,0.12102e+03, &
        & 0.14307e+03,0.17149e+03,0.19971e+03,0.22868e+03 /)
      kao(:, 2, 8,15) = (/ &
        & 0.20045e+03,0.17541e+03,0.15039e+03,0.12643e+03,0.12014e+03, &
        & 0.14095e+03,0.16896e+03,0.19679e+03,0.22532e+03 /)
      kao(:, 3, 8,15) = (/ &
        & 0.20144e+03,0.17633e+03,0.15122e+03,0.12673e+03,0.11946e+03, &
        & 0.13885e+03,0.16646e+03,0.19386e+03,0.22200e+03 /)
      kao(:, 4, 8,15) = (/ &
        & 0.20212e+03,0.17694e+03,0.15175e+03,0.12692e+03,0.11890e+03, &
        & 0.13670e+03,0.16392e+03,0.19092e+03,0.21864e+03 /)
      kao(:, 5, 8,15) = (/ &
        & 0.20244e+03,0.17722e+03,0.15200e+03,0.12703e+03,0.11832e+03, &
        & 0.13474e+03,0.16157e+03,0.18819e+03,0.21551e+03 /)
      kao(:, 1, 9,15) = (/ &
        & 0.23120e+03,0.20232e+03,0.17344e+03,0.14797e+03,0.14299e+03, &
        & 0.16694e+03,0.20011e+03,0.23304e+03,0.26690e+03 /)
      kao(:, 2, 9,15) = (/ &
        & 0.23311e+03,0.20399e+03,0.17488e+03,0.14825e+03,0.14181e+03, &
        & 0.16424e+03,0.19689e+03,0.22930e+03,0.26259e+03 /)
      kao(:, 3, 9,15) = (/ &
        & 0.23434e+03,0.20510e+03,0.17587e+03,0.14844e+03,0.14100e+03, &
        & 0.16150e+03,0.19359e+03,0.22546e+03,0.25821e+03 /)
      kao(:, 4, 9,15) = (/ &
        & 0.23518e+03,0.20584e+03,0.17651e+03,0.14849e+03,0.14028e+03, &
        & 0.15873e+03,0.19031e+03,0.22162e+03,0.25383e+03 /)
      kao(:, 5, 9,15) = (/ &
        & 0.23553e+03,0.20616e+03,0.17678e+03,0.14839e+03,0.13959e+03, &
        & 0.15626e+03,0.18736e+03,0.21823e+03,0.24993e+03 /)
      kao(:, 1,10,15) = (/ &
        & 0.26766e+03,0.23422e+03,0.20086e+03,0.17305e+03,0.16820e+03, &
        & 0.19275e+03,0.23109e+03,0.26916e+03,0.30826e+03 /)
      kao(:, 2,10,15) = (/ &
        & 0.26991e+03,0.23619e+03,0.20254e+03,0.17334e+03,0.16673e+03, &
        & 0.18936e+03,0.22702e+03,0.26442e+03,0.30283e+03 /)
      kao(:, 3,10,15) = (/ &
        & 0.27155e+03,0.23766e+03,0.20381e+03,0.17344e+03,0.16570e+03, &
        & 0.18588e+03,0.22280e+03,0.25950e+03,0.29719e+03 /)
      kao(:, 4,10,15) = (/ &
        & 0.27254e+03,0.23853e+03,0.20456e+03,0.17332e+03,0.16480e+03, &
        & 0.18267e+03,0.21887e+03,0.25495e+03,0.29197e+03 /)
      kao(:, 5,10,15) = (/ &
        & 0.27304e+03,0.23896e+03,0.20491e+03,0.17301e+03,0.16390e+03, &
        & 0.17979e+03,0.21534e+03,0.25082e+03,0.28725e+03 /)
      kao(:, 1,11,15) = (/ &
        & 0.31010e+03,0.27147e+03,0.23291e+03,0.20181e+03,0.19592e+03, &
        & 0.21861e+03,0.26152e+03,0.30466e+03,0.34889e+03 /)
      kao(:, 2,11,15) = (/ &
        & 0.31237e+03,0.27343e+03,0.23463e+03,0.20183e+03,0.19444e+03, &
        & 0.21467e+03,0.25634e+03,0.29864e+03,0.34194e+03 /)
      kao(:, 3,11,15) = (/ &
        & 0.31396e+03,0.27478e+03,0.23578e+03,0.20169e+03,0.19320e+03, &
        & 0.21082e+03,0.25169e+03,0.29321e+03,0.33575e+03 /)
      kao(:, 4,11,15) = (/ &
        & 0.31491e+03,0.27559e+03,0.23646e+03,0.20134e+03,0.19199e+03, &
        & 0.20744e+03,0.24738e+03,0.28820e+03,0.33002e+03 /)
      kao(:, 5,11,15) = (/ &
        & 0.31516e+03,0.27581e+03,0.23662e+03,0.20063e+03,0.19065e+03, &
        & 0.20428e+03,0.24308e+03,0.28319e+03,0.32426e+03 /)
      kao(:, 1,12,15) = (/ &
        & 0.35746e+03,0.31300e+03,0.26858e+03,0.23433e+03,0.22701e+03, &
        & 0.24649e+03,0.29230e+03,0.34058e+03,0.38993e+03 /)
      kao(:, 2,12,15) = (/ &
        & 0.35965e+03,0.31492e+03,0.27026e+03,0.23392e+03,0.22536e+03, &
        & 0.24218e+03,0.28684e+03,0.33421e+03,0.38264e+03 /)
      kao(:, 3,12,15) = (/ &
        & 0.36096e+03,0.31606e+03,0.27127e+03,0.23331e+03,0.22367e+03, &
        & 0.23821e+03,0.28173e+03,0.32828e+03,0.37584e+03 /)
      kao(:, 4,12,15) = (/ &
        & 0.36159e+03,0.31657e+03,0.27171e+03,0.23251e+03,0.22182e+03, &
        & 0.23456e+03,0.27669e+03,0.32238e+03,0.36910e+03 /)
      kao(:, 5,12,15) = (/ &
        & 0.36141e+03,0.31636e+03,0.27153e+03,0.23134e+03,0.21976e+03, &
        & 0.23095e+03,0.27160e+03,0.31644e+03,0.36227e+03 /)
      kao(:, 1,13,15) = (/ &
        & 0.40931e+03,0.35842e+03,0.30758e+03,0.27041e+03,0.26133e+03, &
        & 0.27679e+03,0.32393e+03,0.37751e+03,0.43213e+03 /)
      kao(:, 2,13,15) = (/ &
        & 0.41124e+03,0.36013e+03,0.30908e+03,0.26935e+03,0.25923e+03, &
        & 0.27218e+03,0.31806e+03,0.37065e+03,0.42432e+03 /)
      kao(:, 3,13,15) = (/ &
        & 0.41214e+03,0.36093e+03,0.30979e+03,0.26811e+03,0.25684e+03, &
        & 0.26794e+03,0.31214e+03,0.36375e+03,0.41639e+03 /)
      kao(:, 4,13,15) = (/ &
        & 0.41225e+03,0.36102e+03,0.30989e+03,0.26655e+03,0.25418e+03, &
        & 0.26378e+03,0.30615e+03,0.35676e+03,0.40836e+03 /)
      kao(:, 5,13,15) = (/ &
        & 0.41130e+03,0.36017e+03,0.30917e+03,0.26471e+03,0.25127e+03, &
        & 0.25962e+03,0.30054e+03,0.35018e+03,0.40087e+03 /)
      kao(:, 1, 1,16) = (/ &
        & 0.66783e+02,0.58494e+02,0.50207e+02,0.41922e+02,0.39207e+02, &
        & 0.48837e+02,0.58441e+02,0.67973e+02,0.73684e+02 /)
      kao(:, 2, 1,16) = (/ &
        & 0.66987e+02,0.58663e+02,0.50340e+02,0.42083e+02,0.39992e+02, &
        & 0.49756e+02,0.59507e+02,0.69167e+02,0.75232e+02 /)
      kao(:, 3, 1,16) = (/ &
        & 0.67128e+02,0.58776e+02,0.50426e+02,0.42412e+02,0.40738e+02, &
        & 0.50635e+02,0.60514e+02,0.70320e+02,0.76487e+02 /)
      kao(:, 4, 1,16) = (/ &
        & 0.67159e+02,0.58797e+02,0.50435e+02,0.42709e+02,0.41336e+02, &
        & 0.51345e+02,0.61329e+02,0.71239e+02,0.77474e+02 /)
      kao(:, 5, 1,16) = (/ &
        & 0.67048e+02,0.58698e+02,0.50349e+02,0.42916e+02,0.41806e+02, &
        & 0.51893e+02,0.61955e+02,0.71939e+02,0.78212e+02 /)
      kao(:, 1, 2,16) = (/ &
        & 0.80817e+02,0.70771e+02,0.60724e+02,0.50680e+02,0.46121e+02, &
        & 0.57561e+02,0.68978e+02,0.80276e+02,0.88125e+02 /)
      kao(:, 2, 2,16) = (/ &
        & 0.81120e+02,0.71031e+02,0.60942e+02,0.50856e+02,0.46531e+02, &
        & 0.58009e+02,0.69466e+02,0.80811e+02,0.88902e+02 /)
      kao(:, 3, 2,16) = (/ &
        & 0.81295e+02,0.71179e+02,0.61065e+02,0.50952e+02,0.47046e+02, &
        & 0.58603e+02,0.70144e+02,0.81568e+02,0.89842e+02 /)
      kao(:, 4, 2,16) = (/ &
        & 0.81302e+02,0.71181e+02,0.61061e+02,0.50998e+02,0.47535e+02, &
        & 0.59172e+02,0.70788e+02,0.82285e+02,0.90723e+02 /)
      kao(:, 5, 2,16) = (/ &
        & 0.81254e+02,0.71123e+02,0.60992e+02,0.51150e+02,0.47959e+02, &
        & 0.59657e+02,0.71327e+02,0.82908e+02,0.91460e+02 /)
      kao(:, 1, 3,16) = (/ &
        & 0.97635e+02,0.85483e+02,0.73330e+02,0.61179e+02,0.56207e+02, &
        & 0.70215e+02,0.84188e+02,0.98014e+02,0.10988e+03 /)
      kao(:, 2, 3,16) = (/ &
        & 0.98163e+02,0.85943e+02,0.73724e+02,0.61504e+02,0.55633e+02, &
        & 0.69472e+02,0.83276e+02,0.96935e+02,0.10869e+03 /)
      kao(:, 3, 3,16) = (/ &
        & 0.98472e+02,0.86211e+02,0.73951e+02,0.61693e+02,0.55697e+02, &
        & 0.69495e+02,0.83260e+02,0.96885e+02,0.10871e+03 /)
      kao(:, 4, 3,16) = (/ &
        & 0.98535e+02,0.86265e+02,0.73995e+02,0.61728e+02,0.55937e+02, &
        & 0.69749e+02,0.83530e+02,0.97171e+02,0.10906e+03 /)
      kao(:, 5, 3,16) = (/ &
        & 0.98433e+02,0.86165e+02,0.73899e+02,0.61635e+02,0.56204e+02, &
        & 0.70040e+02,0.83840e+02,0.97500e+02,0.10946e+03 /)
      kao(:, 1, 4,16) = (/ &
        & 0.11801e+03,0.10331e+03,0.88600e+02,0.73894e+02,0.68841e+02, &
        & 0.86008e+02,0.10313e+03,0.12007e+03,0.13623e+03 /)
      kao(:, 2, 4,16) = (/ &
        & 0.11855e+03,0.10378e+03,0.89007e+02,0.74235e+02,0.68009e+02, &
        & 0.84957e+02,0.10186e+03,0.11859e+03,0.13456e+03 /)
      kao(:, 3, 4,16) = (/ &
        & 0.11911e+03,0.10427e+03,0.89430e+02,0.74590e+02,0.67220e+02, &
        & 0.83955e+02,0.10065e+03,0.11716e+03,0.13292e+03 /)
      kao(:, 4, 4,16) = (/ &
        & 0.11932e+03,0.10446e+03,0.89591e+02,0.74725e+02,0.66996e+02, &
        & 0.83620e+02,0.10020e+03,0.11661e+03,0.13231e+03 /)
      kao(:, 5, 4,16) = (/ &
        & 0.11933e+03,0.10445e+03,0.89579e+02,0.74708e+02,0.67016e+02, &
        & 0.83607e+02,0.10016e+03,0.11655e+03,0.13223e+03 /)
      kao(:, 1, 5,16) = (/ &
        & 0.14253e+03,0.12475e+03,0.10698e+03,0.89200e+02,0.84755e+02, &
        & 0.10590e+03,0.12699e+03,0.14785e+03,0.16865e+03 /)
      kao(:, 2, 5,16) = (/ &
        & 0.14325e+03,0.12539e+03,0.10752e+03,0.89655e+02,0.83145e+02, &
        & 0.10388e+03,0.12456e+03,0.14501e+03,0.16542e+03 /)
      kao(:, 3, 5,16) = (/ &
        & 0.14383e+03,0.12589e+03,0.10795e+03,0.90019e+02,0.82092e+02, &
        & 0.10255e+03,0.12296e+03,0.14315e+03,0.16327e+03 /)
      kao(:, 4, 5,16) = (/ &
        & 0.14418e+03,0.12620e+03,0.10822e+03,0.90248e+02,0.81037e+02, &
        & 0.10121e+03,0.12133e+03,0.14124e+03,0.16108e+03 /)
      kao(:, 5, 5,16) = (/ &
        & 0.14437e+03,0.12637e+03,0.10836e+03,0.90358e+02,0.80556e+02, &
        & 0.10057e+03,0.12052e+03,0.14027e+03,0.15994e+03 /)
      kao(:, 1, 6,16) = (/ &
        & 0.17174e+03,0.15031e+03,0.12887e+03,0.10744e+03,0.10459e+03, &
        & 0.13069e+03,0.15672e+03,0.18250e+03,0.20866e+03 /)
      kao(:, 2, 6,16) = (/ &
        & 0.17281e+03,0.15124e+03,0.12968e+03,0.10811e+03,0.10205e+03, &
        & 0.12751e+03,0.15290e+03,0.17802e+03,0.20356e+03 /)
      kao(:, 3, 6,16) = (/ &
        & 0.17366e+03,0.15199e+03,0.13032e+03,0.10865e+03,0.10020e+03, &
        & 0.12519e+03,0.15010e+03,0.17475e+03,0.19982e+03 /)
      kao(:, 4, 6,16) = (/ &
        & 0.17410e+03,0.15237e+03,0.13065e+03,0.10893e+03,0.98757e+02, &
        & 0.12337e+03,0.14792e+03,0.17221e+03,0.19689e+03 /)
      kao(:, 5, 6,16) = (/ &
        & 0.17426e+03,0.15251e+03,0.13077e+03,0.10903e+03,0.97456e+02, &
        & 0.12171e+03,0.14591e+03,0.16984e+03,0.19419e+03 /)
      kao(:, 1, 7,16) = (/ &
        & 0.20639e+03,0.18062e+03,0.15485e+03,0.12907e+03,0.12889e+03, &
        & 0.16105e+03,0.19314e+03,0.22488e+03,0.25751e+03 /)
      kao(:, 2, 7,16) = (/ &
        & 0.20793e+03,0.18197e+03,0.15600e+03,0.13004e+03,0.12536e+03, &
        & 0.15664e+03,0.18784e+03,0.21870e+03,0.25043e+03 /)
      kao(:, 3, 7,16) = (/ &
        & 0.20918e+03,0.18307e+03,0.15695e+03,0.13084e+03,0.12258e+03, &
        & 0.15317e+03,0.18368e+03,0.21386e+03,0.24487e+03 /)
      kao(:, 4, 7,16) = (/ &
        & 0.20994e+03,0.18373e+03,0.15753e+03,0.13132e+03,0.12024e+03, &
        & 0.15023e+03,0.18014e+03,0.20974e+03,0.24016e+03 /)
      kao(:, 5, 7,16) = (/ &
        & 0.21017e+03,0.18393e+03,0.15770e+03,0.13147e+03,0.11817e+03, &
        & 0.14763e+03,0.17700e+03,0.20610e+03,0.23592e+03 /)
      kao(:, 1, 8,16) = (/ &
        & 0.24808e+03,0.21709e+03,0.18610e+03,0.15511e+03,0.15824e+03, &
        & 0.19773e+03,0.23715e+03,0.27617e+03,0.31647e+03 /)
      kao(:, 2, 8,16) = (/ &
        & 0.24976e+03,0.21856e+03,0.18737e+03,0.15617e+03,0.15364e+03, &
        & 0.19198e+03,0.23024e+03,0.26808e+03,0.30723e+03 /)
      kao(:, 3, 8,16) = (/ &
        & 0.25153e+03,0.22011e+03,0.18870e+03,0.15729e+03,0.14986e+03, &
        & 0.18726e+03,0.22456e+03,0.26146e+03,0.29964e+03 /)
      kao(:, 4, 8,16) = (/ &
        & 0.25266e+03,0.22111e+03,0.18956e+03,0.15801e+03,0.14651e+03, &
        & 0.18308e+03,0.21955e+03,0.25564e+03,0.29297e+03 /)
      kao(:, 5, 8,16) = (/ &
        & 0.25306e+03,0.22146e+03,0.18986e+03,0.15826e+03,0.14346e+03, &
        & 0.17924e+03,0.21492e+03,0.25024e+03,0.28677e+03 /)
      kao(:, 1, 9,16) = (/ &
        & 0.29758e+03,0.26040e+03,0.22322e+03,0.18603e+03,0.19348e+03, &
        & 0.24177e+03,0.28996e+03,0.33765e+03,0.38707e+03 /)
      kao(:, 2, 9,16) = (/ &
        & 0.29980e+03,0.26234e+03,0.22489e+03,0.18744e+03,0.18763e+03, &
        & 0.23446e+03,0.28116e+03,0.32742e+03,0.37536e+03 /)
      kao(:, 3, 9,16) = (/ &
        & 0.30182e+03,0.26412e+03,0.22641e+03,0.18871e+03,0.18264e+03, &
        & 0.22823e+03,0.27370e+03,0.31874e+03,0.36539e+03 /)
      kao(:, 4, 9,16) = (/ &
        & 0.30335e+03,0.26546e+03,0.22757e+03,0.18968e+03,0.17814e+03, &
        & 0.22260e+03,0.26695e+03,0.31086e+03,0.35637e+03 /)
      kao(:, 5, 9,16) = (/ &
        & 0.30399e+03,0.26602e+03,0.22805e+03,0.19008e+03,0.17393e+03, &
        & 0.21734e+03,0.26062e+03,0.30347e+03,0.34789e+03 /)
      kao(:, 1,10,16) = (/ &
        & 0.35657e+03,0.31201e+03,0.26745e+03,0.22289e+03,0.23471e+03, &
        & 0.29329e+03,0.35175e+03,0.40960e+03,0.46960e+03 /)
      kao(:, 2,10,16) = (/ &
        & 0.35941e+03,0.31450e+03,0.26959e+03,0.22468e+03,0.22747e+03, &
        & 0.28425e+03,0.34089e+03,0.39700e+03,0.45514e+03 /)
      kao(:, 3,10,16) = (/ &
        & 0.36173e+03,0.31654e+03,0.27134e+03,0.22614e+03,0.22110e+03, &
        & 0.27628e+03,0.33132e+03,0.38584e+03,0.44234e+03 /)
      kao(:, 4,10,16) = (/ &
        & 0.36337e+03,0.31797e+03,0.27257e+03,0.22717e+03,0.21518e+03, &
        & 0.26889e+03,0.32246e+03,0.37553e+03,0.43052e+03 /)
      kao(:, 5,10,16) = (/ &
        & 0.36404e+03,0.31855e+03,0.27307e+03,0.22759e+03,0.20959e+03, &
        & 0.26189e+03,0.31406e+03,0.36572e+03,0.41925e+03 /)
      kao(:, 1,11,16) = (/ &
        & 0.42778e+03,0.37432e+03,0.32086e+03,0.26740e+03,0.27872e+03, &
        & 0.34830e+03,0.41771e+03,0.48646e+03,0.55765e+03 /)
      kao(:, 2,11,16) = (/ &
        & 0.43110e+03,0.37723e+03,0.32336e+03,0.26948e+03,0.27023e+03, &
        & 0.33769e+03,0.40499e+03,0.47168e+03,0.54065e+03 /)
      kao(:, 3,11,16) = (/ &
        & 0.43351e+03,0.37933e+03,0.32516e+03,0.27099e+03,0.26235e+03, &
        & 0.32784e+03,0.39315e+03,0.45790e+03,0.52488e+03 /)
      kao(:, 4,11,16) = (/ &
        & 0.43444e+03,0.38015e+03,0.32587e+03,0.27158e+03,0.25502e+03, &
        & 0.31866e+03,0.38217e+03,0.44507e+03,0.51019e+03 /)
      kao(:, 5,11,16) = (/ &
        & 0.43455e+03,0.38025e+03,0.32595e+03,0.27165e+03,0.24835e+03, &
        & 0.31008e+03,0.37185e+03,0.43305e+03,0.49635e+03 /)
      kao(:, 1,12,16) = (/ &
        & 0.51115e+03,0.44727e+03,0.38338e+03,0.31950e+03,0.32868e+03, &
        & 0.41075e+03,0.49264e+03,0.57375e+03,0.65765e+03 /)
      kao(:, 2,12,16) = (/ &
        & 0.51481e+03,0.45047e+03,0.38614e+03,0.32180e+03,0.31846e+03, &
        & 0.39795e+03,0.47726e+03,0.55589e+03,0.63715e+03 /)
      kao(:, 3,12,16) = (/ &
        & 0.51667e+03,0.45210e+03,0.38753e+03,0.32296e+03,0.30906e+03, &
        & 0.38614e+03,0.46310e+03,0.53942e+03,0.61825e+03 /)
      kao(:, 4,12,16) = (/ &
        & 0.51678e+03,0.45219e+03,0.38761e+03,0.32303e+03,0.30046e+03, &
        & 0.37494e+03,0.44968e+03,0.52372e+03,0.60018e+03 /)
      kao(:, 5,12,16) = (/ &
        & 0.51600e+03,0.45151e+03,0.38702e+03,0.32254e+03,0.29255e+03, &
        & 0.36403e+03,0.43655e+03,0.50852e+03,0.58277e+03 /)
      kao(:, 1,13,16) = (/ &
        & 0.60779e+03,0.53183e+03,0.45587e+03,0.37990e+03,0.38498e+03, &
        & 0.48109e+03,0.57702e+03,0.67207e+03,0.77032e+03 /)
      kao(:, 2,13,16) = (/ &
        & 0.61089e+03,0.53454e+03,0.45819e+03,0.38184e+03,0.37288e+03, &
        & 0.46566e+03,0.55850e+03,0.65053e+03,0.74557e+03 /)
      kao(:, 3,13,16) = (/ &
        & 0.61168e+03,0.53523e+03,0.45878e+03,0.38233e+03,0.36190e+03, &
        & 0.45112e+03,0.54103e+03,0.63023e+03,0.72223e+03 /)
      kao(:, 4,13,16) = (/ &
        & 0.61073e+03,0.53440e+03,0.45807e+03,0.38174e+03,0.35168e+03, &
        & 0.43693e+03,0.52405e+03,0.61044e+03,0.69951e+03 /)
      kao(:, 5,13,16) = (/ &
        & 0.60852e+03,0.53247e+03,0.45641e+03,0.38036e+03,0.34198e+03, &
        & 0.42302e+03,0.50734e+03,0.59097e+03,0.67714e+03 /)

!     -----------------------------------------------------------------
!     The array KBO contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels < ~100mb and temperatures. The first 
!     index in the array, JT, which runs from 1 to 5, corresponds to 
!     different temperatures.  More specifically, JT = 3 means that the 
!     data are for the reference temperature TREF for this pressure 
!     level, JT = 2 refers to the temperature TREF-15, JT = 1 is for
!     TREF-30, JT = 4 is for TREF+15, and JT = 5 is for TREF+30.  
!     The second index, JP, runs from 13 to 59 and refers to the JPth
!     reference pressure level (see taumol.f for the value of these
!     pressure levels in mb).  The third index, IG, goes from 1 to 16,
!     and tells us which g-interval the absorption coefficients are for.
!     -----------------------------------------------------------------

      kbo(:, 1,13, 1) = (/ &
        & 0.10554e-06,0.38596e-04,0.65402e-04,0.88540e-04,0.19601e-03 /)
      kbo(:, 2,13, 1) = (/ &
        & 0.10479e-06,0.43672e-04,0.74889e-04,0.10118e-03,0.22146e-03 /)
      kbo(:, 3,13, 1) = (/ &
        & 0.10429e-06,0.49418e-04,0.85429e-04,0.11557e-03,0.24448e-03 /)
      kbo(:, 4,13, 1) = (/ &
        & 0.10232e-06,0.55802e-04,0.96459e-04,0.13167e-03,0.27001e-03 /)
      kbo(:, 5,13, 1) = (/ &
        & 0.99013e-07,0.62996e-04,0.10900e-03,0.14834e-03,0.29917e-03 /)
      kbo(:, 1,14, 1) = (/ &
        & 0.85136e-07,0.31943e-04,0.54402e-04,0.73887e-04,0.15895e-03 /)
      kbo(:, 2,14, 1) = (/ &
        & 0.84597e-07,0.36196e-04,0.62429e-04,0.84479e-04,0.17749e-03 /)
      kbo(:, 3,14, 1) = (/ &
        & 0.83629e-07,0.40982e-04,0.71126e-04,0.96573e-04,0.19740e-03 /)
      kbo(:, 4,14, 1) = (/ &
        & 0.82310e-07,0.46344e-04,0.80458e-04,0.10984e-03,0.21847e-03 /)
      kbo(:, 5,14, 1) = (/ &
        & 0.78709e-07,0.52252e-04,0.90989e-04,0.12394e-03,0.24281e-03 /)
      kbo(:, 1,15, 1) = (/ &
        & 0.68497e-07,0.26393e-04,0.45164e-04,0.61570e-04,0.12493e-03 /)
      kbo(:, 2,15, 1) = (/ &
        & 0.68062e-07,0.29936e-04,0.51919e-04,0.70387e-04,0.13953e-03 /)
      kbo(:, 3,15, 1) = (/ &
        & 0.66766e-07,0.33863e-04,0.59056e-04,0.80693e-04,0.15653e-03 /)
      kbo(:, 4,15, 1) = (/ &
        & 0.65636e-07,0.38294e-04,0.66885e-04,0.91555e-04,0.17510e-03 /)
      kbo(:, 5,15, 1) = (/ &
        & 0.62711e-07,0.43189e-04,0.75756e-04,0.10355e-03,0.19439e-03 /)
      kbo(:, 1,16, 1) = (/ &
        & 0.55083e-07,0.21761e-04,0.37484e-04,0.51301e-04,0.97875e-04 /)
      kbo(:, 2,16, 1) = (/ &
        & 0.54095e-07,0.24670e-04,0.43084e-04,0.58639e-04,0.10996e-03 /)
      kbo(:, 3,16, 1) = (/ &
        & 0.53340e-07,0.27925e-04,0.48976e-04,0.67234e-04,0.12415e-03 /)
      kbo(:, 4,16, 1) = (/ &
        & 0.51412e-07,0.31588e-04,0.55576e-04,0.76352e-04,0.13939e-03 /)
      kbo(:, 5,16, 1) = (/ &
        & 0.49341e-07,0.35677e-04,0.62937e-04,0.86363e-04,0.15543e-03 /)
      kbo(:, 1,17, 1) = (/ &
        & 0.44022e-07,0.17963e-04,0.31102e-04,0.42604e-04,0.78290e-04 /)
      kbo(:, 2,17, 1) = (/ &
        & 0.43167e-07,0.20382e-04,0.35754e-04,0.48875e-04,0.87941e-04 /)
      kbo(:, 3,17, 1) = (/ &
        & 0.42210e-07,0.23091e-04,0.40674e-04,0.56059e-04,0.99257e-04 /)
      kbo(:, 4,17, 1) = (/ &
        & 0.40402e-07,0.26125e-04,0.46162e-04,0.63586e-04,0.11166e-03 /)
      kbo(:, 5,17, 1) = (/ &
        & 0.38532e-07,0.29494e-04,0.52327e-04,0.71960e-04,0.12480e-03 /)
      kbo(:, 1,18, 1) = (/ &
        & 0.34937e-07,0.14903e-04,0.25868e-04,0.35503e-04,0.63368e-04 /)
      kbo(:, 2,18, 1) = (/ &
        & 0.34308e-07,0.16923e-04,0.29781e-04,0.40789e-04,0.71115e-04 /)
      kbo(:, 3,18, 1) = (/ &
        & 0.32995e-07,0.19171e-04,0.33872e-04,0.46810e-04,0.80302e-04 /)
      kbo(:, 4,18, 1) = (/ &
        & 0.31654e-07,0.21679e-04,0.38468e-04,0.53048e-04,0.90431e-04 /)
      kbo(:, 5,18, 1) = (/ &
        & 0.30282e-07,0.24491e-04,0.43596e-04,0.60078e-04,0.10133e-03 /)
      kbo(:, 1,19, 1) = (/ &
        & 0.27971e-07,0.12385e-04,0.21549e-04,0.29618e-04,0.51732e-04 /)
      kbo(:, 2,19, 1) = (/ &
        & 0.27128e-07,0.14042e-04,0.24826e-04,0.34047e-04,0.58064e-04 /)
      kbo(:, 3,19, 1) = (/ &
        & 0.26018e-07,0.15920e-04,0.28221e-04,0.39072e-04,0.65495e-04 /)
      kbo(:, 4,19, 1) = (/ &
        & 0.24717e-07,0.18017e-04,0.32056e-04,0.44285e-04,0.73859e-04 /)
      kbo(:, 5,19, 1) = (/ &
        & 0.23859e-07,0.20360e-04,0.36341e-04,0.50170e-04,0.82944e-04 /)
      kbo(:, 1,20, 1) = (/ &
        & 0.22529e-07,0.10336e-04,0.17999e-04,0.24776e-04,0.42602e-04 /)
      kbo(:, 2,20, 1) = (/ &
        & 0.21733e-07,0.11685e-04,0.20769e-04,0.28503e-04,0.47833e-04 /)
      kbo(:, 3,20, 1) = (/ &
        & 0.20791e-07,0.13280e-04,0.23571e-04,0.32654e-04,0.53995e-04 /)
      kbo(:, 4,20, 1) = (/ &
        & 0.19663e-07,0.15029e-04,0.26788e-04,0.37066e-04,0.60944e-04 /)
      kbo(:, 5,20, 1) = (/ &
        & 0.19169e-07,0.16975e-04,0.30353e-04,0.41996e-04,0.68344e-04 /)
      kbo(:, 1,21, 1) = (/ &
        & 0.18148e-07,0.86039e-05,0.15041e-04,0.20717e-04,0.35143e-04 /)
      kbo(:, 2,21, 1) = (/ &
        & 0.17465e-07,0.97287e-05,0.17348e-04,0.23862e-04,0.39508e-04 /)
      kbo(:, 3,21, 1) = (/ &
        & 0.16537e-07,0.11073e-04,0.19687e-04,0.27271e-04,0.44652e-04 /)
      kbo(:, 4,21, 1) = (/ &
        & 0.15860e-07,0.12526e-04,0.22388e-04,0.31015e-04,0.50269e-04 /)
      kbo(:, 5,21, 1) = (/ &
        & 0.15452e-07,0.14158e-04,0.25339e-04,0.35141e-04,0.56327e-04 /)
      kbo(:, 1,22, 1) = (/ &
        & 0.14542e-07,0.71807e-05,0.12682e-04,0.17473e-04,0.29179e-04 /)
      kbo(:, 2,22, 1) = (/ &
        & 0.13967e-07,0.81574e-05,0.14550e-04,0.20147e-04,0.32795e-04 /)
      kbo(:, 3,22, 1) = (/ &
        & 0.13241e-07,0.92839e-05,0.16547e-04,0.22971e-04,0.37036e-04 /)
      kbo(:, 4,22, 1) = (/ &
        & 0.12746e-07,0.10522e-04,0.18840e-04,0.26114e-04,0.41617e-04 /)
      kbo(:, 5,22, 1) = (/ &
        & 0.12426e-07,0.11886e-04,0.21313e-04,0.29604e-04,0.46709e-04 /)
      kbo(:, 1,23, 1) = (/ &
        & 0.11724e-07,0.60196e-05,0.10703e-04,0.14753e-04,0.24143e-04 /)
      kbo(:, 2,23, 1) = (/ &
        & 0.11124e-07,0.68499e-05,0.12233e-04,0.17009e-04,0.27147e-04 /)
      kbo(:, 3,23, 1) = (/ &
        & 0.10552e-07,0.77897e-05,0.13927e-04,0.19362e-04,0.30661e-04 /)
      kbo(:, 4,23, 1) = (/ &
        & 0.10213e-07,0.88398e-05,0.15850e-04,0.22024e-04,0.34519e-04 /)
      kbo(:, 5,23, 1) = (/ &
        & 0.99627e-08,0.99755e-05,0.17919e-04,0.24944e-04,0.38730e-04 /)
      kbo(:, 1,24, 1) = (/ &
        & 0.93835e-08,0.50505e-05,0.90298e-05,0.12450e-04,0.19940e-04 /)
      kbo(:, 2,24, 1) = (/ &
        & 0.88722e-08,0.57494e-05,0.10287e-04,0.14351e-04,0.22450e-04 /)
      kbo(:, 3,24, 1) = (/ &
        & 0.84719e-08,0.65374e-05,0.11727e-04,0.16329e-04,0.25378e-04 /)
      kbo(:, 4,24, 1) = (/ &
        & 0.81924e-08,0.74186e-05,0.13334e-04,0.18567e-04,0.28560e-04 /)
      kbo(:, 5,24, 1) = (/ &
        & 0.79194e-08,0.83719e-05,0.15056e-04,0.21003e-04,0.31990e-04 /)
      kbo(:, 1,25, 1) = (/ &
        & 0.74535e-08,0.42437e-05,0.76220e-05,0.10523e-04,0.16531e-04 /)
      kbo(:, 2,25, 1) = (/ &
        & 0.70516e-08,0.48300e-05,0.86667e-05,0.12089e-04,0.18616e-04 /)
      kbo(:, 3,25, 1) = (/ &
        & 0.67746e-08,0.54941e-05,0.98927e-05,0.13790e-04,0.21024e-04 /)
      kbo(:, 4,25, 1) = (/ &
        & 0.65375e-08,0.62357e-05,0.11233e-04,0.15662e-04,0.23642e-04 /)
      kbo(:, 5,25, 1) = (/ &
        & 0.63001e-08,0.70282e-05,0.12669e-04,0.17695e-04,0.26478e-04 /)
      kbo(:, 1,26, 1) = (/ &
        & 0.59520e-08,0.35739e-05,0.64350e-05,0.89330e-05,0.13754e-04 /)
      kbo(:, 2,26, 1) = (/ &
        & 0.56644e-08,0.40797e-05,0.73291e-05,0.10228e-04,0.15489e-04 /)
      kbo(:, 3,26, 1) = (/ &
        & 0.54229e-08,0.46366e-05,0.83664e-05,0.11659e-04,0.17486e-04 /)
      kbo(:, 4,26, 1) = (/ &
        & 0.52155e-08,0.52546e-05,0.94829e-05,0.13246e-04,0.19643e-04 /)
      kbo(:, 5,26, 1) = (/ &
        & 0.50026e-08,0.59134e-05,0.10676e-04,0.14933e-04,0.21979e-04 /)
      kbo(:, 1,27, 1) = (/ &
        & 0.47347e-08,0.30117e-05,0.54223e-05,0.75810e-05,0.11424e-04 /)
      kbo(:, 2,27, 1) = (/ &
        & 0.45215e-08,0.34421e-05,0.61959e-05,0.86619e-05,0.12884e-04 /)
      kbo(:, 3,27, 1) = (/ &
        & 0.43334e-08,0.39143e-05,0.70702e-05,0.98761e-05,0.14543e-04 /)
      kbo(:, 4,27, 1) = (/ &
        & 0.41350e-08,0.44275e-05,0.80005e-05,0.11195e-04,0.16319e-04 /)
      kbo(:, 5,27, 1) = (/ &
        & 0.39653e-08,0.49769e-05,0.89931e-05,0.12598e-04,0.18160e-04 /)
      kbo(:, 1,28, 1) = (/ &
        & 0.37948e-08,0.25415e-05,0.45819e-05,0.64336e-05,0.94956e-05 /)
      kbo(:, 2,28, 1) = (/ &
        & 0.36083e-08,0.29038e-05,0.52426e-05,0.73400e-05,0.10719e-04 /)
      kbo(:, 3,28, 1) = (/ &
        & 0.34418e-08,0.33017e-05,0.59733e-05,0.83575e-05,0.12066e-04 /)
      kbo(:, 4,28, 1) = (/ &
        & 0.32636e-08,0.37297e-05,0.67493e-05,0.94558e-05,0.13468e-04 /)
      kbo(:, 5,28, 1) = (/ &
        & 0.31340e-08,0.41873e-05,0.75759e-05,0.10620e-04,0.14953e-04 /)
      kbo(:, 1,29, 1) = (/ &
        & 0.30121e-08,0.21536e-05,0.38841e-05,0.54491e-05,0.79090e-05 /)
      kbo(:, 2,29, 1) = (/ &
        & 0.28775e-08,0.24557e-05,0.44467e-05,0.62247e-05,0.89148e-05 /)
      kbo(:, 3,29, 1) = (/ &
        & 0.27196e-08,0.27900e-05,0.50543e-05,0.70782e-05,0.99943e-05 /)
      kbo(:, 4,29, 1) = (/ &
        & 0.25798e-08,0.31473e-05,0.57011e-05,0.79936e-05,0.11135e-04 /)
      kbo(:, 5,29, 1) = (/ &
        & 0.24785e-08,0.35287e-05,0.63894e-05,0.89624e-05,0.12357e-04 /)
      kbo(:, 1,30, 1) = (/ &
        & 0.24034e-08,0.18231e-05,0.32945e-05,0.46183e-05,0.65837e-05 /)
      kbo(:, 2,30, 1) = (/ &
        & 0.22702e-08,0.20766e-05,0.37671e-05,0.52735e-05,0.73875e-05 /)
      kbo(:, 3,30, 1) = (/ &
        & 0.21551e-08,0.23559e-05,0.42744e-05,0.59932e-05,0.82665e-05 /)
      kbo(:, 4,30, 1) = (/ &
        & 0.20397e-08,0.26541e-05,0.48137e-05,0.67549e-05,0.92071e-05 /)
      kbo(:, 5,30, 1) = (/ &
        & 0.19208e-08,0.29711e-05,0.53880e-05,0.75598e-05,0.10211e-04 /)
      kbo(:, 1,31, 1) = (/ &
        & 0.19116e-08,0.15454e-05,0.27957e-05,0.39228e-05,0.54664e-05 /)
      kbo(:, 2,31, 1) = (/ &
        & 0.18045e-08,0.17579e-05,0.31938e-05,0.44780e-05,0.61205e-05 /)
      kbo(:, 3,31, 1) = (/ &
        & 0.17015e-08,0.19911e-05,0.36167e-05,0.50753e-05,0.68523e-05 /)
      kbo(:, 4,31, 1) = (/ &
        & 0.16042e-08,0.22393e-05,0.40666e-05,0.57094e-05,0.76260e-05 /)
      kbo(:, 5,31, 1) = (/ &
        & 0.15189e-08,0.25035e-05,0.45439e-05,0.63785e-05,0.84562e-05 /)
      kbo(:, 1,32, 1) = (/ &
        & 0.15134e-08,0.13080e-05,0.23763e-05,0.33360e-05,0.45382e-05 /)
      kbo(:, 2,32, 1) = (/ &
        & 0.14254e-08,0.14886e-05,0.27086e-05,0.37995e-05,0.50938e-05 /)
      kbo(:, 3,32, 1) = (/ &
        & 0.13478e-08,0.16831e-05,0.30605e-05,0.42971e-05,0.56933e-05 /)
      kbo(:, 4,32, 1) = (/ &
        & 0.12726e-08,0.18904e-05,0.34353e-05,0.48247e-05,0.63353e-05 /)
      kbo(:, 5,32, 1) = (/ &
        & 0.12027e-08,0.21098e-05,0.38318e-05,0.53809e-05,0.70302e-05 /)
      kbo(:, 1,33, 1) = (/ &
        & 0.12024e-08,0.11084e-05,0.20193e-05,0.28310e-05,0.37849e-05 /)
      kbo(:, 2,33, 1) = (/ &
        & 0.11338e-08,0.12605e-05,0.22949e-05,0.32221e-05,0.42458e-05 /)
      kbo(:, 3,33, 1) = (/ &
        & 0.10678e-08,0.14231e-05,0.25881e-05,0.36365e-05,0.47460e-05 /)
      kbo(:, 4,33, 1) = (/ &
        & 0.10052e-08,0.15963e-05,0.29010e-05,0.40728e-05,0.52804e-05 /)
      kbo(:, 5,33, 1) = (/ &
        & 0.95946e-09,0.17779e-05,0.32301e-05,0.45381e-05,0.58547e-05 /)
      kbo(:, 1,34, 1) = (/ &
        & 0.95750e-09,0.93665e-06,0.17068e-05,0.23954e-05,0.31611e-05 /)
      kbo(:, 2,34, 1) = (/ &
        & 0.89991e-09,0.10636e-05,0.19366e-05,0.27209e-05,0.35440e-05 /)
      kbo(:, 3,34, 1) = (/ &
        & 0.84944e-09,0.11994e-05,0.21804e-05,0.30651e-05,0.39600e-05 /)
      kbo(:, 4,34, 1) = (/ &
        & 0.80863e-09,0.13431e-05,0.24406e-05,0.34285e-05,0.44045e-05 /)
      kbo(:, 5,34, 1) = (/ &
        & 0.76697e-09,0.14937e-05,0.27138e-05,0.38153e-05,0.48739e-05 /)
      kbo(:, 1,35, 1) = (/ &
        & 0.76931e-09,0.78145e-06,0.14243e-05,0.20004e-05,0.26088e-05 /)
      kbo(:, 2,35, 1) = (/ &
        & 0.72554e-09,0.88652e-06,0.16140e-05,0.22684e-05,0.29255e-05 /)
      kbo(:, 3,35, 1) = (/ &
        & 0.68677e-09,0.99872e-06,0.18159e-05,0.25537e-05,0.32672e-05 /)
      kbo(:, 4,35, 1) = (/ &
        & 0.64986e-09,0.11178e-05,0.20312e-05,0.28542e-05,0.36304e-05 /)
      kbo(:, 5,35, 1) = (/ &
        & 0.62177e-09,0.12420e-05,0.22566e-05,0.31737e-05,0.40187e-05 /)
      kbo(:, 1,36, 1) = (/ &
        & 0.62245e-09,0.64235e-06,0.11709e-05,0.16445e-05,0.21213e-05 /)
      kbo(:, 2,36, 1) = (/ &
        & 0.58696e-09,0.72876e-06,0.13266e-05,0.18646e-05,0.23798e-05 /)
      kbo(:, 3,36, 1) = (/ &
        & 0.55693e-09,0.82089e-06,0.14927e-05,0.20991e-05,0.26600e-05 /)
      kbo(:, 4,36, 1) = (/ &
        & 0.52934e-09,0.91874e-06,0.16695e-05,0.23457e-05,0.29575e-05 /)
      kbo(:, 5,36, 1) = (/ &
        & 0.50585e-09,0.10210e-05,0.18549e-05,0.26085e-05,0.32758e-05 /)
      kbo(:, 1,37, 1) = (/ &
        & 0.51156e-09,0.51872e-06,0.94550e-06,0.13287e-05,0.17089e-05 /)
      kbo(:, 2,37, 1) = (/ &
        & 0.48258e-09,0.58908e-06,0.10722e-05,0.15079e-05,0.19187e-05 /)
      kbo(:, 3,37, 1) = (/ &
        & 0.45694e-09,0.66421e-06,0.12078e-05,0.16992e-05,0.21456e-05 /)
      kbo(:, 4,37, 1) = (/ &
        & 0.43502e-09,0.74408e-06,0.13520e-05,0.19000e-05,0.23876e-05 /)
      kbo(:, 5,37, 1) = (/ &
        & 0.41517e-09,0.82758e-06,0.15034e-05,0.21146e-05,0.26473e-05 /)
      kbo(:, 1,38, 1) = (/ &
        & 0.42094e-09,0.41837e-06,0.76260e-06,0.10719e-05,0.13756e-05 /)
      kbo(:, 2,38, 1) = (/ &
        & 0.39700e-09,0.47557e-06,0.86572e-06,0.12180e-05,0.15462e-05 /)
      kbo(:, 3,38, 1) = (/ &
        & 0.37563e-09,0.53684e-06,0.97613e-06,0.13738e-05,0.17289e-05 /)
      kbo(:, 4,38, 1) = (/ &
        & 0.35783e-09,0.60193e-06,0.10936e-05,0.15374e-05,0.19252e-05 /)
      kbo(:, 5,38, 1) = (/ &
        & 0.34107e-09,0.67014e-06,0.12173e-05,0.17127e-05,0.21369e-05 /)
      kbo(:, 1,39, 1) = (/ &
        & 0.34635e-09,0.33732e-06,0.61492e-06,0.86447e-06,0.11055e-05 /)
      kbo(:, 2,39, 1) = (/ &
        & 0.32654e-09,0.38383e-06,0.69869e-06,0.98355e-06,0.12440e-05 /)
      kbo(:, 3,39, 1) = (/ &
        & 0.30909e-09,0.43371e-06,0.78869e-06,0.11105e-05,0.13924e-05 /)
      kbo(:, 4,39, 1) = (/ &
        & 0.29425e-09,0.48681e-06,0.88446e-06,0.12433e-05,0.15526e-05 /)
      kbo(:, 5,39, 1) = (/ &
        & 0.28000e-09,0.54256e-06,0.98550e-06,0.13868e-05,0.17238e-05 /)
      kbo(:, 1,40, 1) = (/ &
        & 0.28731e-09,0.26843e-06,0.48915e-06,0.68810e-06,0.87867e-06 /)
      kbo(:, 2,40, 1) = (/ &
        & 0.27089e-09,0.30600e-06,0.55698e-06,0.78430e-06,0.99075e-06 /)
      kbo(:, 3,40, 1) = (/ &
        & 0.25607e-09,0.34624e-06,0.62966e-06,0.88677e-06,0.11107e-05 /)
      kbo(:, 4,40, 1) = (/ &
        & 0.24372e-09,0.38926e-06,0.70732e-06,0.99430e-06,0.12402e-05 /)
      kbo(:, 5,40, 1) = (/ &
        & 0.23176e-09,0.43465e-06,0.78943e-06,0.11107e-05,0.13787e-05 /)
      kbo(:, 1,41, 1) = (/ &
        & 0.23903e-09,0.21323e-06,0.38855e-06,0.54701e-06,0.69781e-06 /)
      kbo(:, 2,41, 1) = (/ &
        & 0.22487e-09,0.24332e-06,0.44328e-06,0.62397e-06,0.78774e-06 /)
      kbo(:, 3,41, 1) = (/ &
        & 0.21236e-09,0.27581e-06,0.50170e-06,0.70664e-06,0.88427e-06 /)
      kbo(:, 4,41, 1) = (/ &
        & 0.20204e-09,0.31066e-06,0.56435e-06,0.79384e-06,0.98899e-06 /)
      kbo(:, 5,41, 1) = (/ &
        & 0.19209e-09,0.34753e-06,0.63119e-06,0.88787e-06,0.11007e-05 /)
      kbo(:, 1,42, 1) = (/ &
        & 0.19868e-09,0.16950e-06,0.30885e-06,0.43426e-06,0.55336e-06 /)
      kbo(:, 2,42, 1) = (/ &
        & 0.18681e-09,0.19338e-06,0.35250e-06,0.49622e-06,0.62628e-06 /)
      kbo(:, 3,42, 1) = (/ &
        & 0.17649e-09,0.21963e-06,0.39950e-06,0.56269e-06,0.70396e-06 /)
      kbo(:, 4,42, 1) = (/ &
        & 0.16753e-09,0.24778e-06,0.45013e-06,0.63342e-06,0.78770e-06 /)
      kbo(:, 5,42, 1) = (/ &
        & 0.15930e-09,0.27772e-06,0.50439e-06,0.70945e-06,0.87783e-06 /)
      kbo(:, 1,43, 1) = (/ &
        & 0.16577e-09,0.13332e-06,0.24323e-06,0.34184e-06,0.43594e-06 /)
      kbo(:, 2,43, 1) = (/ &
        & 0.15597e-09,0.15245e-06,0.27801e-06,0.39130e-06,0.49460e-06 /)
      kbo(:, 3,43, 1) = (/ &
        & 0.14721e-09,0.17354e-06,0.31584e-06,0.44499e-06,0.55705e-06 /)
      kbo(:, 4,43, 1) = (/ &
        & 0.13936e-09,0.19625e-06,0.35661e-06,0.50189e-06,0.62398e-06 /)
      kbo(:, 5,43, 1) = (/ &
        & 0.13255e-09,0.22044e-06,0.40034e-06,0.56308e-06,0.69634e-06 /)
      kbo(:, 1,44, 1) = (/ &
        & 0.13861e-09,0.10445e-06,0.19058e-06,0.26841e-06,0.34233e-06 /)
      kbo(:, 2,44, 1) = (/ &
        & 0.13027e-09,0.11974e-06,0.21836e-06,0.30744e-06,0.38897e-06 /)
      kbo(:, 3,44, 1) = (/ &
        & 0.12290e-09,0.13662e-06,0.24864e-06,0.35065e-06,0.43916e-06 /)
      kbo(:, 4,44, 1) = (/ &
        & 0.11611e-09,0.15484e-06,0.28155e-06,0.39627e-06,0.49273e-06 /)
      kbo(:, 5,44, 1) = (/ &
        & 0.11042e-09,0.17431e-06,0.31666e-06,0.44540e-06,0.55087e-06 /)
      kbo(:, 1,45, 1) = (/ &
        & 0.11581e-09,0.81915e-07,0.14915e-06,0.21140e-06,0.26987e-06 /)
      kbo(:, 2,45, 1) = (/ &
        & 0.10906e-09,0.94077e-07,0.17143e-06,0.24173e-06,0.30586e-06 /)
      kbo(:, 3,45, 1) = (/ &
        & 0.10254e-09,0.10745e-06,0.19582e-06,0.27606e-06,0.34593e-06 /)
      kbo(:, 4,45, 1) = (/ &
        & 0.96757e-10,0.12205e-06,0.22201e-06,0.31271e-06,0.38876e-06 /)
      kbo(:, 5,45, 1) = (/ &
        & 0.91979e-10,0.13772e-06,0.25015e-06,0.35208e-06,0.43561e-06 /)
      kbo(:, 1,46, 1) = (/ &
        & 0.96889e-10,0.64116e-07,0.11708e-06,0.16455e-06,0.21036e-06 /)
      kbo(:, 2,46, 1) = (/ &
        & 0.91281e-10,0.73641e-07,0.13436e-06,0.18895e-06,0.23951e-06 /)
      kbo(:, 3,46, 1) = (/ &
        & 0.85830e-10,0.84161e-07,0.15360e-06,0.21643e-06,0.27176e-06 /)
      kbo(:, 4,46, 1) = (/ &
        & 0.81048e-10,0.95867e-07,0.17447e-06,0.24582e-06,0.30613e-06 /)
      kbo(:, 5,46, 1) = (/ &
        & 0.76712e-10,0.10844e-06,0.19706e-06,0.27743e-06,0.34329e-06 /)
      kbo(:, 1,47, 1) = (/ &
        & 0.81516e-10,0.49698e-07,0.90596e-07,0.12727e-06,0.16313e-06 /)
      kbo(:, 2,47, 1) = (/ &
        & 0.76609e-10,0.57132e-07,0.10433e-06,0.14694e-06,0.18672e-06 /)
      kbo(:, 3,47, 1) = (/ &
        & 0.71975e-10,0.65534e-07,0.11955e-06,0.16850e-06,0.21215e-06 /)
      kbo(:, 4,47, 1) = (/ &
        & 0.67908e-10,0.74829e-07,0.13619e-06,0.19209e-06,0.23959e-06 /)
      kbo(:, 5,47, 1) = (/ &
        & 0.64117e-10,0.84872e-07,0.15433e-06,0.21733e-06,0.26915e-06 /)
      kbo(:, 1,48, 1) = (/ &
        & 0.68429e-10,0.38715e-07,0.69854e-07,0.98377e-07,0.12619e-06 /)
      kbo(:, 2,48, 1) = (/ &
        & 0.64236e-10,0.44375e-07,0.80895e-07,0.11471e-06,0.14604e-06 /)
      kbo(:, 3,48, 1) = (/ &
        & 0.60510e-10,0.51025e-07,0.92977e-07,0.13123e-06,0.16542e-06 /)
      kbo(:, 4,48, 1) = (/ &
        & 0.56851e-10,0.58345e-07,0.10633e-06,0.14991e-06,0.18745e-06 /)
      kbo(:, 5,48, 1) = (/ &
        & 0.53674e-10,0.66346e-07,0.12070e-06,0.17001e-06,0.21095e-06 /)
      kbo(:, 1,49, 1) = (/ &
        & 0.57387e-10,0.29800e-07,0.53817e-07,0.75906e-07,0.97710e-07 /)
      kbo(:, 2,49, 1) = (/ &
        & 0.53960e-10,0.34500e-07,0.63205e-07,0.88655e-07,0.11310e-06 /)
      kbo(:, 3,49, 1) = (/ &
        & 0.50740e-10,0.39684e-07,0.72502e-07,0.10193e-06,0.12892e-06 /)
      kbo(:, 4,49, 1) = (/ &
        & 0.47710e-10,0.45418e-07,0.82941e-07,0.11692e-06,0.14649e-06 /)
      kbo(:, 5,49, 1) = (/ &
        & 0.45050e-10,0.51797e-07,0.94320e-07,0.13296e-06,0.16526e-06 /)
      kbo(:, 1,50, 1) = (/ &
        & 0.48010e-10,0.22999e-07,0.41682e-07,0.58975e-07,0.75898e-07 /)
      kbo(:, 2,50, 1) = (/ &
        & 0.45282e-10,0.26917e-07,0.48929e-07,0.68765e-07,0.87983e-07 /)
      kbo(:, 3,50, 1) = (/ &
        & 0.42531e-10,0.30879e-07,0.56406e-07,0.79593e-07,0.10109e-06 /)
      kbo(:, 4,50, 1) = (/ &
        & 0.40002e-10,0.35470e-07,0.64706e-07,0.91312e-07,0.11473e-06 /)
      kbo(:, 5,50, 1) = (/ &
        & 0.37674e-10,0.40542e-07,0.73834e-07,0.10412e-06,0.12967e-06 /)
      kbo(:, 1,51, 1) = (/ &
        & 0.40094e-10,0.17810e-07,0.32412e-07,0.45985e-07,0.59041e-07 /)
      kbo(:, 2,51, 1) = (/ &
        & 0.37901e-10,0.21013e-07,0.37921e-07,0.53479e-07,0.68479e-07 /)
      kbo(:, 3,51, 1) = (/ &
        & 0.35584e-10,0.24100e-07,0.43988e-07,0.62409e-07,0.79311e-07 /)
      kbo(:, 4,51, 1) = (/ &
        & 0.33516e-10,0.27737e-07,0.50544e-07,0.71436e-07,0.89912e-07 /)
      kbo(:, 5,51, 1) = (/ &
        & 0.31503e-10,0.31738e-07,0.57889e-07,0.81591e-07,0.10195e-06 /)
      kbo(:, 1,52, 1) = (/ &
        & 0.33462e-10,0.13829e-07,0.25227e-07,0.35498e-07,0.45793e-07 /)
      kbo(:, 2,52, 1) = (/ &
        & 0.31703e-10,0.16272e-07,0.29393e-07,0.41476e-07,0.53340e-07 /)
      kbo(:, 3,52, 1) = (/ &
        & 0.29856e-10,0.18836e-07,0.34537e-07,0.48490e-07,0.61791e-07 /)
      kbo(:, 4,52, 1) = (/ &
        & 0.28038e-10,0.21684e-07,0.39578e-07,0.55751e-07,0.70422e-07 /)
      kbo(:, 5,52, 1) = (/ &
        & 0.26375e-10,0.24824e-07,0.45389e-07,0.63898e-07,0.80071e-07 /)
      kbo(:, 1,53, 1) = (/ &
        & 0.27859e-10,0.10757e-07,0.19436e-07,0.27368e-07,0.35401e-07 /)
      kbo(:, 2,53, 1) = (/ &
        & 0.26482e-10,0.12575e-07,0.22786e-07,0.32275e-07,0.41504e-07 /)
      kbo(:, 3,53, 1) = (/ &
        & 0.25013e-10,0.14718e-07,0.26786e-07,0.37657e-07,0.48150e-07 /)
      kbo(:, 4,53, 1) = (/ &
        & 0.23481e-10,0.16890e-07,0.30875e-07,0.43561e-07,0.55284e-07 /)
      kbo(:, 5,53, 1) = (/ &
        & 0.22103e-10,0.19405e-07,0.35435e-07,0.50046e-07,0.62824e-07 /)
      kbo(:, 1,54, 1) = (/ &
        & 0.23262e-10,0.83534e-08,0.15033e-07,0.21142e-07,0.27491e-07 /)
      kbo(:, 2,54, 1) = (/ &
        & 0.22075e-10,0.97821e-08,0.17791e-07,0.25298e-07,0.32447e-07 /)
      kbo(:, 3,54, 1) = (/ &
        & 0.20887e-10,0.11541e-07,0.20852e-07,0.29392e-07,0.37643e-07 /)
      kbo(:, 4,54, 1) = (/ &
        & 0.19629e-10,0.13228e-07,0.24164e-07,0.34330e-07,0.43622e-07 /)
      kbo(:, 5,54, 1) = (/ &
        & 0.18475e-10,0.15233e-07,0.27779e-07,0.39304e-07,0.49432e-07 /)
      kbo(:, 1,55, 1) = (/ &
        & 0.19360e-10,0.64888e-08,0.11644e-07,0.16387e-07,0.21340e-07 /)
      kbo(:, 2,55, 1) = (/ &
        & 0.18372e-10,0.76367e-08,0.13947e-07,0.19672e-07,0.25401e-07 /)
      kbo(:, 3,55, 1) = (/ &
        & 0.17421e-10,0.90083e-08,0.16275e-07,0.22971e-07,0.29522e-07 /)
      kbo(:, 4,55, 1) = (/ &
        & 0.16413e-10,0.10402e-07,0.19081e-07,0.26854e-07,0.34233e-07 /)
      kbo(:, 5,55, 1) = (/ &
        & 0.15417e-10,0.11984e-07,0.21835e-07,0.30856e-07,0.38954e-07 /)
      kbo(:, 1,56, 1) = (/ &
        & 0.16094e-10,0.50174e-08,0.90283e-08,0.12718e-07,0.16576e-07 /)
      kbo(:, 2,56, 1) = (/ &
        & 0.15265e-10,0.59747e-08,0.10850e-07,0.15297e-07,0.19783e-07 /)
      kbo(:, 3,56, 1) = (/ &
        & 0.14515e-10,0.70142e-08,0.12699e-07,0.17960e-07,0.23171e-07 /)
      kbo(:, 4,56, 1) = (/ &
        & 0.13715e-10,0.81626e-08,0.14940e-07,0.20994e-07,0.26865e-07 /)
      kbo(:, 5,56, 1) = (/ &
        & 0.12880e-10,0.94054e-08,0.17206e-07,0.24221e-07,0.30739e-07 /)
      kbo(:, 1,57, 1) = (/ &
        & 0.13368e-10,0.38838e-08,0.69991e-08,0.98372e-08,0.12821e-07 /)
      kbo(:, 2,57, 1) = (/ &
        & 0.12743e-10,0.46751e-08,0.84243e-08,0.11856e-07,0.15406e-07 /)
      kbo(:, 3,57, 1) = (/ &
        & 0.12087e-10,0.54642e-08,0.99295e-08,0.14069e-07,0.18144e-07 /)
      kbo(:, 4,57, 1) = (/ &
        & 0.11442e-10,0.64461e-08,0.11657e-07,0.16407e-07,0.21072e-07 /)
      kbo(:, 5,57, 1) = (/ &
        & 0.10759e-10,0.73711e-08,0.13478e-07,0.19106e-07,0.24314e-07 /)
      kbo(:, 1,58, 1) = (/ &
        & 0.11081e-10,0.30148e-08,0.54165e-08,0.76421e-08,0.99496e-08 /)
      kbo(:, 2,58, 1) = (/ &
        & 0.10598e-10,0.36337e-08,0.65375e-08,0.92041e-08,0.12025e-07 /)
      kbo(:, 3,58, 1) = (/ &
        & 0.10052e-10,0.42712e-08,0.77841e-08,0.11053e-07,0.14306e-07 /)
      kbo(:, 4,58, 1) = (/ &
        & 0.95308e-11,0.50429e-08,0.91133e-08,0.12865e-07,0.16554e-07 /)
      kbo(:, 5,58, 1) = (/ &
        & 0.89795e-11,0.57979e-08,0.10615e-07,0.15051e-07,0.19216e-07 /)
      kbo(:, 1,59, 1) = (/ &
        & 0.91194e-11,0.24214e-08,0.43496e-08,0.61531e-08,0.80136e-08 /)
      kbo(:, 2,59, 1) = (/ &
        & 0.87287e-11,0.29232e-08,0.52535e-08,0.73966e-08,0.96830e-08 /)
      kbo(:, 3,59, 1) = (/ &
        & 0.82765e-11,0.34412e-08,0.62788e-08,0.88992e-08,0.11534e-07 /)
      kbo(:, 4,59, 1) = (/ &
        & 0.78605e-11,0.40632e-08,0.73454e-08,0.10382e-07,0.13372e-07 /)
      kbo(:, 5,59, 1) = (/ &
        & 0.74127e-11,0.46801e-08,0.85910e-08,0.12137e-07,0.15530e-07 /)
      kbo(:, 1,13, 2) = (/ &
        & 0.17576e-05,0.22518e-03,0.36398e-03,0.46505e-03,0.97920e-03 /)
      kbo(:, 2,13, 2) = (/ &
        & 0.19522e-05,0.25688e-03,0.42724e-03,0.54293e-03,0.11261e-02 /)
      kbo(:, 3,13, 2) = (/ &
        & 0.21134e-05,0.29382e-03,0.49778e-03,0.63186e-03,0.12961e-02 /)
      kbo(:, 4,13, 2) = (/ &
        & 0.22680e-05,0.33585e-03,0.57095e-03,0.73149e-03,0.14857e-02 /)
      kbo(:, 5,13, 2) = (/ &
        & 0.23939e-05,0.38326e-03,0.64688e-03,0.84120e-03,0.16815e-02 /)
      kbo(:, 1,14, 2) = (/ &
        & 0.13866e-05,0.18816e-03,0.30541e-03,0.39082e-03,0.80614e-03 /)
      kbo(:, 2,14, 2) = (/ &
        & 0.14825e-05,0.21525e-03,0.35906e-03,0.45772e-03,0.92976e-03 /)
      kbo(:, 3,14, 2) = (/ &
        & 0.16428e-05,0.24664e-03,0.41891e-03,0.53341e-03,0.10689e-02 /)
      kbo(:, 4,14, 2) = (/ &
        & 0.17807e-05,0.28218e-03,0.48021e-03,0.61861e-03,0.12236e-02 /)
      kbo(:, 5,14, 2) = (/ &
        & 0.18685e-05,0.32204e-03,0.54385e-03,0.71223e-03,0.13844e-02 /)
      kbo(:, 1,15, 2) = (/ &
        & 0.10483e-05,0.15699e-03,0.25571e-03,0.32803e-03,0.65873e-03 /)
      kbo(:, 2,15, 2) = (/ &
        & 0.11310e-05,0.18016e-03,0.30071e-03,0.38534e-03,0.75916e-03 /)
      kbo(:, 3,15, 2) = (/ &
        & 0.12330e-05,0.20672e-03,0.35181e-03,0.44940e-03,0.87041e-03 /)
      kbo(:, 4,15, 2) = (/ &
        & 0.13426e-05,0.23650e-03,0.40292e-03,0.52246e-03,0.99445e-03 /)
      kbo(:, 5,15, 2) = (/ &
        & 0.14514e-05,0.26979e-03,0.45684e-03,0.60195e-03,0.11173e-02 /)
      kbo(:, 1,16, 2) = (/ &
        & 0.80663e-06,0.13098e-03,0.21382e-03,0.27539e-03,0.53727e-03 /)
      kbo(:, 2,16, 2) = (/ &
        & 0.85747e-06,0.15058e-03,0.25201e-03,0.32406e-03,0.61573e-03 /)
      kbo(:, 3,16, 2) = (/ &
        & 0.92435e-06,0.17283e-03,0.29542e-03,0.37879e-03,0.70140e-03 /)
      kbo(:, 4,16, 2) = (/ &
        & 0.99747e-06,0.19793e-03,0.33807e-03,0.44076e-03,0.79468e-03 /)
      kbo(:, 5,16, 2) = (/ &
        & 0.10819e-05,0.22582e-03,0.38354e-03,0.50663e-03,0.88980e-03 /)
      kbo(:, 1,17, 2) = (/ &
        & 0.61772e-06,0.10941e-03,0.17926e-03,0.23144e-03,0.43554e-03 /)
      kbo(:, 2,17, 2) = (/ &
        & 0.65718e-06,0.12576e-03,0.21174e-03,0.27275e-03,0.49750e-03 /)
      kbo(:, 3,17, 2) = (/ &
        & 0.69949e-06,0.14461e-03,0.24852e-03,0.31937e-03,0.56462e-03 /)
      kbo(:, 4,17, 2) = (/ &
        & 0.75387e-06,0.16580e-03,0.28374e-03,0.37213e-03,0.63507e-03 /)
      kbo(:, 5,17, 2) = (/ &
        & 0.79715e-06,0.18926e-03,0.32236e-03,0.42588e-03,0.70728e-03 /)
      kbo(:, 1,18, 2) = (/ &
        & 0.47188e-06,0.91952e-04,0.15100e-03,0.19495e-03,0.35543e-03 /)
      kbo(:, 2,18, 2) = (/ &
        & 0.50937e-06,0.10513e-03,0.17852e-03,0.22999e-03,0.40250e-03 /)
      kbo(:, 3,18, 2) = (/ &
        & 0.54206e-06,0.12130e-03,0.20959e-03,0.26979e-03,0.45662e-03 /)
      kbo(:, 4,18, 2) = (/ &
        & 0.57328e-06,0.13936e-03,0.23815e-03,0.31451e-03,0.51113e-03 /)
      kbo(:, 5,18, 2) = (/ &
        & 0.61077e-06,0.15916e-03,0.27075e-03,0.35967e-03,0.57076e-03 /)
      kbo(:, 1,19, 2) = (/ &
        & 0.36005e-06,0.76984e-04,0.12743e-03,0.16422e-03,0.28885e-03 /)
      kbo(:, 2,19, 2) = (/ &
        & 0.38988e-06,0.88029e-04,0.15067e-03,0.19396e-03,0.32854e-03 /)
      kbo(:, 3,19, 2) = (/ &
        & 0.41989e-06,0.10172e-03,0.17539e-03,0.22784e-03,0.37045e-03 /)
      kbo(:, 4,19, 2) = (/ &
        & 0.44092e-06,0.11727e-03,0.20004e-03,0.26592e-03,0.41598e-03 /)
      kbo(:, 5,19, 2) = (/ &
        & 0.46883e-06,0.13386e-03,0.22769e-03,0.30285e-03,0.46550e-03 /)
      kbo(:, 1,20, 2) = (/ &
        & 0.27908e-06,0.64450e-04,0.10795e-03,0.13889e-03,0.23878e-03 /)
      kbo(:, 2,20, 2) = (/ &
        & 0.30934e-06,0.74187e-04,0.12773e-03,0.16417e-03,0.27017e-03 /)
      kbo(:, 3,20, 2) = (/ &
        & 0.33086e-06,0.85801e-04,0.14782e-03,0.19307e-03,0.30508e-03 /)
      kbo(:, 4,20, 2) = (/ &
        & 0.35058e-06,0.98861e-04,0.16868e-03,0.22508e-03,0.34249e-03 /)
      kbo(:, 5,20, 2) = (/ &
        & 0.37069e-06,0.11306e-03,0.19188e-03,0.25601e-03,0.38519e-03 /)
      kbo(:, 1,21, 2) = (/ &
        & 0.22418e-06,0.54095e-04,0.91414e-04,0.11757e-03,0.19697e-03 /)
      kbo(:, 2,21, 2) = (/ &
        & 0.24559e-06,0.62567e-04,0.10819e-03,0.13908e-03,0.22284e-03 /)
      kbo(:, 3,21, 2) = (/ &
        & 0.26169e-06,0.72383e-04,0.12481e-03,0.16368e-03,0.25205e-03 /)
      kbo(:, 4,21, 2) = (/ &
        & 0.27885e-06,0.83446e-04,0.14258e-03,0.18910e-03,0.28386e-03 /)
      kbo(:, 5,21, 2) = (/ &
        & 0.29344e-06,0.95540e-04,0.16198e-03,0.21609e-03,0.31947e-03 /)
      kbo(:, 1,22, 2) = (/ &
        & 0.17941e-06,0.45830e-04,0.78176e-04,0.10061e-03,0.16313e-03 /)
      kbo(:, 2,22, 2) = (/ &
        & 0.19397e-06,0.53139e-04,0.92556e-04,0.11901e-03,0.18482e-03 /)
      kbo(:, 3,22, 2) = (/ &
        & 0.20707e-06,0.61593e-04,0.10579e-03,0.14008e-03,0.20965e-03 /)
      kbo(:, 4,22, 2) = (/ &
        & 0.22071e-06,0.71016e-04,0.12100e-03,0.16128e-03,0.23661e-03 /)
      kbo(:, 5,22, 2) = (/ &
        & 0.23148e-06,0.81286e-04,0.13795e-03,0.18401e-03,0.26580e-03 /)
      kbo(:, 1,23, 2) = (/ &
        & 0.14291e-06,0.38825e-04,0.66866e-04,0.86140e-04,0.13511e-03 /)
      kbo(:, 2,23, 2) = (/ &
        & 0.15179e-06,0.45135e-04,0.78450e-04,0.10194e-03,0.15369e-03 /)
      kbo(:, 3,23, 2) = (/ &
        & 0.16326e-06,0.52399e-04,0.89919e-04,0.12001e-03,0.17441e-03 /)
      kbo(:, 4,23, 2) = (/ &
        & 0.17307e-06,0.60440e-04,0.10293e-03,0.13735e-03,0.19668e-03 /)
      kbo(:, 5,23, 2) = (/ &
        & 0.18137e-06,0.69189e-04,0.11759e-03,0.15651e-03,0.21998e-03 /)
      kbo(:, 1,24, 2) = (/ &
        & 0.11245e-06,0.32862e-04,0.57166e-04,0.73828e-04,0.11185e-03 /)
      kbo(:, 2,24, 2) = (/ &
        & 0.11958e-06,0.38281e-04,0.66635e-04,0.87390e-04,0.12740e-03 /)
      kbo(:, 3,24, 2) = (/ &
        & 0.12702e-06,0.44519e-04,0.76606e-04,0.10190e-03,0.14418e-03 /)
      kbo(:, 4,24, 2) = (/ &
        & 0.13467e-06,0.51373e-04,0.87622e-04,0.11700e-03,0.16205e-03 /)
      kbo(:, 5,24, 2) = (/ &
        & 0.14120e-06,0.58874e-04,0.10019e-03,0.13348e-03,0.18188e-03 /)
      kbo(:, 1,25, 2) = (/ &
        & 0.88242e-07,0.27950e-04,0.49010e-04,0.63434e-04,0.92877e-04 /)
      kbo(:, 2,25, 2) = (/ &
        & 0.94383e-07,0.32610e-04,0.56690e-04,0.75114e-04,0.10531e-03 /)
      kbo(:, 3,25, 2) = (/ &
        & 0.99712e-07,0.37929e-04,0.65204e-04,0.87113e-04,0.11931e-03 /)
      kbo(:, 4,25, 2) = (/ &
        & 0.10473e-06,0.43778e-04,0.74805e-04,0.99950e-04,0.13427e-03 /)
      kbo(:, 5,25, 2) = (/ &
        & 0.10988e-06,0.50229e-04,0.85598e-04,0.11406e-03,0.15050e-03 /)
      kbo(:, 1,26, 2) = (/ &
        & 0.69696e-07,0.23895e-04,0.42166e-04,0.54733e-04,0.77146e-04 /)
      kbo(:, 2,26, 2) = (/ &
        & 0.74390e-07,0.27921e-04,0.48387e-04,0.64817e-04,0.87607e-04 /)
      kbo(:, 3,26, 2) = (/ &
        & 0.78856e-07,0.32497e-04,0.55692e-04,0.74691e-04,0.99387e-04 /)
      kbo(:, 4,26, 2) = (/ &
        & 0.83253e-07,0.37491e-04,0.64130e-04,0.85609e-04,0.11193e-03 /)
      kbo(:, 5,26, 2) = (/ &
        & 0.87675e-07,0.43011e-04,0.73398e-04,0.97828e-04,0.12574e-03 /)
      kbo(:, 1,27, 2) = (/ &
        & 0.54619e-07,0.20469e-04,0.35869e-04,0.47259e-04,0.64151e-04 /)
      kbo(:, 2,27, 2) = (/ &
        & 0.58657e-07,0.23925e-04,0.41468e-04,0.55499e-04,0.72911e-04 /)
      kbo(:, 3,27, 2) = (/ &
        & 0.62532e-07,0.27839e-04,0.47735e-04,0.63985e-04,0.82955e-04 /)
      kbo(:, 4,27, 2) = (/ &
        & 0.66184e-07,0.32141e-04,0.55001e-04,0.73456e-04,0.93567e-04 /)
      kbo(:, 5,27, 2) = (/ &
        & 0.69305e-07,0.36605e-04,0.62968e-04,0.83938e-04,0.10517e-03 /)
      kbo(:, 1,28, 2) = (/ &
        & 0.43348e-07,0.17476e-04,0.30692e-04,0.40803e-04,0.53271e-04 /)
      kbo(:, 2,28, 2) = (/ &
        & 0.46348e-07,0.20496e-04,0.35498e-04,0.47629e-04,0.60809e-04 /)
      kbo(:, 3,28, 2) = (/ &
        & 0.49507e-07,0.23857e-04,0.40974e-04,0.54947e-04,0.69222e-04 /)
      kbo(:, 4,28, 2) = (/ &
        & 0.52419e-07,0.27560e-04,0.47205e-04,0.63044e-04,0.78123e-04 /)
      kbo(:, 5,28, 2) = (/ &
        & 0.54842e-07,0.31094e-04,0.54028e-04,0.72116e-04,0.87834e-04 /)
      kbo(:, 1,29, 2) = (/ &
        & 0.34480e-07,0.15027e-04,0.26268e-04,0.35358e-04,0.44711e-04 /)
      kbo(:, 2,29, 2) = (/ &
        & 0.36985e-07,0.17638e-04,0.30405e-04,0.40938e-04,0.51054e-04 /)
      kbo(:, 3,29, 2) = (/ &
        & 0.39476e-07,0.20512e-04,0.35237e-04,0.47207e-04,0.58034e-04 /)
      kbo(:, 4,29, 2) = (/ &
        & 0.41650e-07,0.23694e-04,0.40586e-04,0.54286e-04,0.65708e-04 /)
      kbo(:, 5,29, 2) = (/ &
        & 0.43693e-07,0.26438e-04,0.46467e-04,0.62035e-04,0.73872e-04 /)
      kbo(:, 1,30, 2) = (/ &
        & 0.27402e-07,0.12932e-04,0.22585e-04,0.30365e-04,0.37471e-04 /)
      kbo(:, 2,30, 2) = (/ &
        & 0.29377e-07,0.15183e-04,0.26158e-04,0.35195e-04,0.42867e-04 /)
      kbo(:, 3,30, 2) = (/ &
        & 0.31353e-07,0.17658e-04,0.30343e-04,0.40606e-04,0.48858e-04 /)
      kbo(:, 4,30, 2) = (/ &
        & 0.33056e-07,0.20286e-04,0.34924e-04,0.46735e-04,0.55329e-04 /)
      kbo(:, 5,30, 2) = (/ &
        & 0.34673e-07,0.22451e-04,0.39717e-04,0.53329e-04,0.62151e-04 /)
      kbo(:, 1,31, 2) = (/ &
        & 0.21716e-07,0.11156e-04,0.19427e-04,0.26169e-04,0.31512e-04 /)
      kbo(:, 2,31, 2) = (/ &
        & 0.23313e-07,0.13091e-04,0.22568e-04,0.30377e-04,0.36216e-04 /)
      kbo(:, 3,31, 2) = (/ &
        & 0.24803e-07,0.15221e-04,0.26157e-04,0.35050e-04,0.41256e-04 /)
      kbo(:, 4,31, 2) = (/ &
        & 0.26260e-07,0.17277e-04,0.30091e-04,0.40288e-04,0.46693e-04 /)
      kbo(:, 5,31, 2) = (/ &
        & 0.27334e-07,0.19159e-04,0.33773e-04,0.45892e-04,0.52314e-04 /)
      kbo(:, 1,32, 2) = (/ &
        & 0.17123e-07,0.96453e-05,0.16688e-04,0.22528e-04,0.26648e-04 /)
      kbo(:, 2,32, 2) = (/ &
        & 0.18489e-07,0.11305e-04,0.19464e-04,0.26137e-04,0.30617e-04 /)
      kbo(:, 3,32, 2) = (/ &
        & 0.19621e-07,0.13143e-04,0.22554e-04,0.30238e-04,0.34876e-04 /)
      kbo(:, 4,32, 2) = (/ &
        & 0.20653e-07,0.14698e-04,0.25928e-04,0.34712e-04,0.39398e-04 /)
      kbo(:, 5,32, 2) = (/ &
        & 0.21500e-07,0.16315e-04,0.28651e-04,0.39302e-04,0.44097e-04 /)
      kbo(:, 1,33, 2) = (/ &
        & 0.13414e-07,0.83355e-05,0.14409e-04,0.19461e-04,0.22582e-04 /)
      kbo(:, 2,33, 2) = (/ &
        & 0.14456e-07,0.97647e-05,0.16818e-04,0.22578e-04,0.25923e-04 /)
      kbo(:, 3,33, 2) = (/ &
        & 0.15416e-07,0.11250e-04,0.19451e-04,0.26119e-04,0.29482e-04 /)
      kbo(:, 4,33, 2) = (/ &
        & 0.16184e-07,0.12520e-04,0.22064e-04,0.29911e-04,0.33230e-04 /)
      kbo(:, 5,33, 2) = (/ &
        & 0.16861e-07,0.13810e-04,0.24332e-04,0.33363e-04,0.37135e-04 /)
      kbo(:, 1,34, 2) = (/ &
        & 0.10575e-07,0.71786e-05,0.12407e-04,0.16719e-04,0.19158e-04 /)
      kbo(:, 2,34, 2) = (/ &
        & 0.11328e-07,0.84093e-05,0.14457e-04,0.19433e-04,0.21940e-04 /)
      kbo(:, 3,34, 2) = (/ &
        & 0.12049e-07,0.95860e-05,0.16718e-04,0.22425e-04,0.24932e-04 /)
      kbo(:, 4,34, 2) = (/ &
        & 0.12689e-07,0.10655e-04,0.18771e-04,0.25647e-04,0.28065e-04 /)
      kbo(:, 5,34, 2) = (/ &
        & 0.13241e-07,0.11703e-04,0.20628e-04,0.28184e-04,0.31323e-04 /)
      kbo(:, 1,35, 2) = (/ &
        & 0.82489e-08,0.60850e-05,0.10505e-04,0.14140e-04,0.16004e-04 /)
      kbo(:, 2,35, 2) = (/ &
        & 0.88532e-08,0.71306e-05,0.12250e-04,0.16463e-04,0.18333e-04 /)
      kbo(:, 3,35, 2) = (/ &
        & 0.93468e-08,0.80269e-05,0.14158e-04,0.18989e-04,0.20835e-04 /)
      kbo(:, 4,35, 2) = (/ &
        & 0.98478e-08,0.89450e-05,0.15691e-04,0.21576e-04,0.23428e-04 /)
      kbo(:, 5,35, 2) = (/ &
        & 0.10332e-07,0.98354e-05,0.17293e-04,0.23618e-04,0.26128e-04 /)
      kbo(:, 1,36, 2) = (/ &
        & 0.63951e-08,0.50545e-05,0.87378e-05,0.11778e-04,0.13176e-04 /)
      kbo(:, 2,36, 2) = (/ &
        & 0.68252e-08,0.59348e-05,0.10193e-04,0.13730e-04,0.15104e-04 /)
      kbo(:, 3,36, 2) = (/ &
        & 0.72445e-08,0.66480e-05,0.11783e-04,0.15832e-04,0.17160e-04 /)
      kbo(:, 4,36, 2) = (/ &
        & 0.75871e-08,0.73960e-05,0.13005e-04,0.17866e-04,0.19295e-04 /)
      kbo(:, 5,36, 2) = (/ &
        & 0.79075e-08,0.81558e-05,0.14306e-04,0.19617e-04,0.21532e-04 /)
      kbo(:, 1,37, 2) = (/ &
        & 0.50574e-08,0.41215e-05,0.71249e-05,0.95923e-05,0.10686e-04 /)
      kbo(:, 2,37, 2) = (/ &
        & 0.53967e-08,0.48518e-05,0.83286e-05,0.11206e-04,0.12269e-04 /)
      kbo(:, 3,37, 2) = (/ &
        & 0.57517e-08,0.54411e-05,0.96383e-05,0.12942e-04,0.13958e-04 /)
      kbo(:, 4,37, 2) = (/ &
        & 0.60273e-08,0.60590e-05,0.10644e-04,0.14619e-04,0.15714e-04 /)
      kbo(:, 5,37, 2) = (/ &
        & 0.62775e-08,0.66900e-05,0.11723e-04,0.16077e-04,0.17560e-04 /)
      kbo(:, 1,38, 2) = (/ &
        & 0.39948e-08,0.33535e-05,0.57976e-05,0.77989e-05,0.86548e-05 /)
      kbo(:, 2,38, 2) = (/ &
        & 0.42642e-08,0.39584e-05,0.67932e-05,0.91290e-05,0.99507e-05 /)
      kbo(:, 3,38, 2) = (/ &
        & 0.45529e-08,0.44478e-05,0.78746e-05,0.10563e-04,0.11338e-04 /)
      kbo(:, 4,38, 2) = (/ &
        & 0.47911e-08,0.49592e-05,0.87019e-05,0.11950e-04,0.12783e-04 /)
      kbo(:, 5,38, 2) = (/ &
        & 0.49959e-08,0.54820e-05,0.95964e-05,0.13155e-04,0.14308e-04 /)
      kbo(:, 1,39, 2) = (/ &
        & 0.31607e-08,0.27260e-05,0.47143e-05,0.63381e-05,0.70094e-05 /)
      kbo(:, 2,39, 2) = (/ &
        & 0.33771e-08,0.32263e-05,0.55352e-05,0.74322e-05,0.80695e-05 /)
      kbo(:, 3,39, 2) = (/ &
        & 0.35907e-08,0.36316e-05,0.64256e-05,0.86133e-05,0.92019e-05 /)
      kbo(:, 4,39, 2) = (/ &
        & 0.37920e-08,0.40555e-05,0.71128e-05,0.97677e-05,0.10392e-04 /)
      kbo(:, 5,39, 2) = (/ &
        & 0.39687e-08,0.44882e-05,0.78499e-05,0.10753e-04,0.11647e-04 /)
      kbo(:, 1,40, 2) = (/ &
        & 0.25137e-08,0.21782e-05,0.37700e-05,0.50636e-05,0.55872e-05 /)
      kbo(:, 2,40, 2) = (/ &
        & 0.26953e-08,0.25872e-05,0.44411e-05,0.59538e-05,0.64693e-05 /)
      kbo(:, 3,40, 2) = (/ &
        & 0.28738e-08,0.29415e-05,0.51697e-05,0.69217e-05,0.73806e-05 /)
      kbo(:, 4,40, 2) = (/ &
        & 0.30365e-08,0.32887e-05,0.57574e-05,0.79115e-05,0.83547e-05 /)
      kbo(:, 5,40, 2) = (/ &
        & 0.31827e-08,0.36391e-05,0.63730e-05,0.87114e-05,0.93854e-05 /)
      kbo(:, 1,41, 2) = (/ &
        & 0.20049e-08,0.17350e-05,0.30089e-05,0.40342e-05,0.44437e-05 /)
      kbo(:, 2,41, 2) = (/ &
        & 0.21522e-08,0.20685e-05,0.35532e-05,0.47542e-05,0.51577e-05 /)
      kbo(:, 3,41, 2) = (/ &
        & 0.22978e-08,0.23716e-05,0.41490e-05,0.55459e-05,0.59029e-05 /)
      kbo(:, 4,41, 2) = (/ &
        & 0.24277e-08,0.26608e-05,0.46585e-05,0.63928e-05,0.67015e-05 /)
      kbo(:, 5,41, 2) = (/ &
        & 0.25592e-08,0.29434e-05,0.51614e-05,0.70376e-05,0.75472e-05 /)
      kbo(:, 1,42, 2) = (/ &
        & 0.16007e-08,0.13793e-05,0.23939e-05,0.32203e-05,0.35347e-05 /)
      kbo(:, 2,42, 2) = (/ &
        & 0.17182e-08,0.16509e-05,0.28388e-05,0.37950e-05,0.41069e-05 /)
      kbo(:, 3,42, 2) = (/ &
        & 0.18364e-08,0.19058e-05,0.33250e-05,0.44386e-05,0.47169e-05 /)
      kbo(:, 4,42, 2) = (/ &
        & 0.19459e-08,0.21436e-05,0.37676e-05,0.51389e-05,0.53710e-05 /)
      kbo(:, 5,42, 2) = (/ &
        & 0.20555e-08,0.23781e-05,0.41722e-05,0.56915e-05,0.60613e-05 /)
      kbo(:, 1,43, 2) = (/ &
        & 0.12763e-08,0.10855e-05,0.18842e-05,0.25355e-05,0.27894e-05 /)
      kbo(:, 2,43, 2) = (/ &
        & 0.13693e-08,0.13038e-05,0.22434e-05,0.29991e-05,0.32452e-05 /)
      kbo(:, 3,43, 2) = (/ &
        & 0.14669e-08,0.15227e-05,0.26394e-05,0.35195e-05,0.37403e-05 /)
      kbo(:, 4,43, 2) = (/ &
        & 0.15621e-08,0.17145e-05,0.30188e-05,0.40881e-05,0.42757e-05 /)
      kbo(:, 5,43, 2) = (/ &
        & 0.16467e-08,0.19093e-05,0.33481e-05,0.45768e-05,0.48357e-05 /)
      kbo(:, 1,44, 2) = (/ &
        & 0.10164e-08,0.84908e-06,0.14741e-05,0.19864e-05,0.21744e-05 /)
      kbo(:, 2,44, 2) = (/ &
        & 0.10926e-08,0.10232e-05,0.17642e-05,0.23536e-05,0.25562e-05 /)
      kbo(:, 3,44, 2) = (/ &
        & 0.11717e-08,0.12156e-05,0.20836e-05,0.27750e-05,0.29547e-05 /)
      kbo(:, 4,44, 2) = (/ &
        & 0.12502e-08,0.13671e-05,0.24149e-05,0.32374e-05,0.33856e-05 /)
      kbo(:, 5,44, 2) = (/ &
        & 0.13204e-08,0.15290e-05,0.26801e-05,0.36631e-05,0.38430e-05 /)
      kbo(:, 1,45, 2) = (/ &
        & 0.80967e-09,0.66247e-06,0.11525e-05,0.15557e-05,0.16911e-05 /)
      kbo(:, 2,45, 2) = (/ &
        & 0.87091e-09,0.80114e-06,0.13838e-05,0.18457e-05,0.20071e-05 /)
      kbo(:, 3,45, 2) = (/ &
        & 0.93471e-09,0.96063e-06,0.16414e-05,0.21862e-05,0.23357e-05 /)
      kbo(:, 4,45, 2) = (/ &
        & 0.99996e-09,0.10898e-05,0.19287e-05,0.25587e-05,0.26765e-05 /)
      kbo(:, 5,45, 2) = (/ &
        & 0.10594e-08,0.12255e-05,0.21437e-05,0.29239e-05,0.30491e-05 /)
      kbo(:, 1,46, 2) = (/ &
        & 0.64438e-09,0.51408e-06,0.89692e-06,0.12176e-05,0.13094e-05 /)
      kbo(:, 2,46, 2) = (/ &
        & 0.69338e-09,0.62335e-06,0.10783e-05,0.14408e-05,0.15697e-05 /)
      kbo(:, 3,46, 2) = (/ &
        & 0.74249e-09,0.75197e-06,0.12859e-05,0.17116e-05,0.18286e-05 /)
      kbo(:, 4,46, 2) = (/ &
        & 0.79710e-09,0.86785e-06,0.15182e-05,0.20117e-05,0.21072e-05 /)
      kbo(:, 5,46, 2) = (/ &
        & 0.84966e-09,0.97923e-06,0.17156e-05,0.23354e-05,0.24096e-05 /)
      kbo(:, 1,47, 2) = (/ &
        & 0.51236e-09,0.39483e-06,0.69100e-06,0.94871e-06,0.10050e-05 /)
      kbo(:, 2,47, 2) = (/ &
        & 0.55075e-09,0.48075e-06,0.83326e-06,0.11171e-05,0.12169e-05 /)
      kbo(:, 3,47, 2) = (/ &
        & 0.59153e-09,0.58279e-06,0.99922e-06,0.13307e-05,0.14227e-05 /)
      kbo(:, 4,47, 2) = (/ &
        & 0.63485e-09,0.68347e-06,0.11845e-05,0.15696e-05,0.16474e-05 /)
      kbo(:, 5,47, 2) = (/ &
        & 0.67833e-09,0.77359e-06,0.13593e-05,0.18329e-05,0.18933e-05 /)
      kbo(:, 1,48, 2) = (/ &
        & 0.40749e-09,0.30162e-06,0.53408e-06,0.72777e-06,0.76768e-06 /)
      kbo(:, 2,48, 2) = (/ &
        & 0.43682e-09,0.36975e-06,0.64201e-06,0.86174e-06,0.93334e-06 /)
      kbo(:, 3,48, 2) = (/ &
        & 0.46981e-09,0.45015e-06,0.77460e-06,0.10306e-05,0.11092e-05 /)
      kbo(:, 4,48, 2) = (/ &
        & 0.50302e-09,0.53912e-06,0.92171e-06,0.12225e-05,0.12874e-05 /)
      kbo(:, 5,48, 2) = (/ &
        & 0.53999e-09,0.61013e-06,0.10790e-05,0.14334e-05,0.14828e-05 /)
      kbo(:, 1,49, 2) = (/ &
        & 0.32288e-09,0.23115e-06,0.41625e-06,0.55318e-06,0.58476e-06 /)
      kbo(:, 2,49, 2) = (/ &
        & 0.34731e-09,0.28355e-06,0.49493e-06,0.66850e-06,0.71600e-06 /)
      kbo(:, 3,49, 2) = (/ &
        & 0.37310e-09,0.34682e-06,0.59820e-06,0.79617e-06,0.85985e-06 /)
      kbo(:, 4,49, 2) = (/ &
        & 0.39975e-09,0.42034e-06,0.71527e-06,0.95046e-06,0.10041e-05 /)
      kbo(:, 5,49, 2) = (/ &
        & 0.42970e-09,0.48341e-06,0.84829e-06,0.11191e-05,0.11582e-05 /)
      kbo(:, 1,50, 2) = (/ &
        & 0.25646e-09,0.17743e-06,0.32423e-06,0.42175e-06,0.44754e-06 /)
      kbo(:, 2,50, 2) = (/ &
        & 0.27669e-09,0.21856e-06,0.38220e-06,0.52102e-06,0.55141e-06 /)
      kbo(:, 3,50, 2) = (/ &
        & 0.29654e-09,0.26808e-06,0.46375e-06,0.61921e-06,0.67025e-06 /)
      kbo(:, 4,50, 2) = (/ &
        & 0.31872e-09,0.32662e-06,0.55687e-06,0.73985e-06,0.78291e-06 /)
      kbo(:, 5,50, 2) = (/ &
        & 0.34198e-09,0.38136e-06,0.66385e-06,0.87591e-06,0.90771e-06 /)
      kbo(:, 1,51, 2) = (/ &
        & 0.20472e-09,0.13694e-06,0.24726e-06,0.32216e-06,0.34229e-06 /)
      kbo(:, 2,51, 2) = (/ &
        & 0.22054e-09,0.16842e-06,0.29646e-06,0.40635e-06,0.42402e-06 /)
      kbo(:, 3,51, 2) = (/ &
        & 0.23653e-09,0.20731e-06,0.35913e-06,0.48027e-06,0.51714e-06 /)
      kbo(:, 4,51, 2) = (/ &
        & 0.25402e-09,0.25379e-06,0.43377e-06,0.57689e-06,0.61228e-06 /)
      kbo(:, 5,51, 2) = (/ &
        & 0.27233e-09,0.30202e-06,0.51940e-06,0.68626e-06,0.71146e-06 /)
      kbo(:, 1,52, 2) = (/ &
        & 0.16428e-09,0.10687e-06,0.18803e-06,0.24517e-06,0.26090e-06 /)
      kbo(:, 2,52, 2) = (/ &
        & 0.17520e-09,0.12978e-06,0.23025e-06,0.31106e-06,0.32512e-06 /)
      kbo(:, 3,52, 2) = (/ &
        & 0.18865e-09,0.15994e-06,0.27726e-06,0.37261e-06,0.39888e-06 /)
      kbo(:, 4,52, 2) = (/ &
        & 0.20265e-09,0.19670e-06,0.33708e-06,0.44845e-06,0.47779e-06 /)
      kbo(:, 5,52, 2) = (/ &
        & 0.21711e-09,0.23739e-06,0.40528e-06,0.53668e-06,0.55828e-06 /)
      kbo(:, 1,53, 2) = (/ &
        & 0.13206e-09,0.82677e-07,0.14284e-06,0.18640e-06,0.19898e-06 /)
      kbo(:, 2,53, 2) = (/ &
        & 0.13938e-09,0.99597e-07,0.18095e-06,0.23725e-06,0.24911e-06 /)
      kbo(:, 3,53, 2) = (/ &
        & 0.15056e-09,0.12309e-06,0.21494e-06,0.29026e-06,0.30720e-06 /)
      kbo(:, 4,53, 2) = (/ &
        & 0.16136e-09,0.15205e-06,0.26147e-06,0.34774e-06,0.37331e-06 /)
      kbo(:, 5,53, 2) = (/ &
        & 0.17318e-09,0.18547e-06,0.31566e-06,0.41857e-06,0.43649e-06 /)
      kbo(:, 1,54, 2) = (/ &
        & 0.10628e-09,0.63529e-07,0.10938e-06,0.14285e-06,0.15281e-06 /)
      kbo(:, 2,54, 2) = (/ &
        & 0.11181e-09,0.77068e-07,0.14036e-06,0.18201e-06,0.19163e-06 /)
      kbo(:, 3,54, 2) = (/ &
        & 0.11992e-09,0.95387e-07,0.16692e-06,0.22878e-06,0.23824e-06 /)
      kbo(:, 4,54, 2) = (/ &
        & 0.12900e-09,0.11809e-06,0.20406e-06,0.27163e-06,0.29078e-06 /)
      kbo(:, 5,54, 2) = (/ &
        & 0.13828e-09,0.14510e-06,0.24678e-06,0.32753e-06,0.34217e-06 /)
      kbo(:, 1,55, 2) = (/ &
        & 0.85664e-10,0.48444e-07,0.83932e-07,0.10950e-06,0.11785e-06 /)
      kbo(:, 2,55, 2) = (/ &
        & 0.89999e-10,0.59885e-07,0.10776e-06,0.14023e-06,0.14763e-06 /)
      kbo(:, 3,55, 2) = (/ &
        & 0.95836e-10,0.73941e-07,0.13023e-06,0.17876e-06,0.18426e-06 /)
      kbo(:, 4,55, 2) = (/ &
        & 0.10323e-09,0.91791e-07,0.15882e-06,0.21202e-06,0.22611e-06 /)
      kbo(:, 5,55, 2) = (/ &
        & 0.11081e-09,0.11336e-06,0.19316e-06,0.25647e-06,0.26918e-06 /)
      kbo(:, 1,56, 2) = (/ &
        & 0.69093e-10,0.36832e-07,0.64123e-07,0.84030e-07,0.90974e-07 /)
      kbo(:, 2,56, 2) = (/ &
        & 0.72433e-10,0.47084e-07,0.82613e-07,0.10758e-06,0.11346e-06 /)
      kbo(:, 3,56, 2) = (/ &
        & 0.76616e-10,0.57388e-07,0.10182e-06,0.13768e-06,0.14224e-06 /)
      kbo(:, 4,56, 2) = (/ &
        & 0.82709e-10,0.71294e-07,0.12355e-06,0.16530e-06,0.17549e-06 /)
      kbo(:, 5,56, 2) = (/ &
        & 0.88636e-10,0.88445e-07,0.15094e-06,0.20067e-06,0.21118e-06 /)
      kbo(:, 1,57, 2) = (/ &
        & 0.55980e-10,0.28018e-07,0.48867e-07,0.64857e-07,0.70055e-07 /)
      kbo(:, 2,57, 2) = (/ &
        & 0.58397e-10,0.36620e-07,0.63232e-07,0.82428e-07,0.87457e-07 /)
      kbo(:, 3,57, 2) = (/ &
        & 0.61509e-10,0.44446e-07,0.80512e-07,0.10580e-06,0.10988e-06 /)
      kbo(:, 4,57, 2) = (/ &
        & 0.66015e-10,0.55222e-07,0.96401e-07,0.12935e-06,0.13614e-06 /)
      kbo(:, 5,57, 2) = (/ &
        & 0.70976e-10,0.68821e-07,0.11780e-06,0.15632e-06,0.16586e-06 /)
      kbo(:, 1,58, 2) = (/ &
        & 0.45722e-10,0.21506e-07,0.37326e-07,0.50333e-07,0.54855e-07 /)
      kbo(:, 2,58, 2) = (/ &
        & 0.47090e-10,0.28249e-07,0.48612e-07,0.63442e-07,0.67550e-07 /)
      kbo(:, 3,58, 2) = (/ &
        & 0.49550e-10,0.34430e-07,0.62769e-07,0.81509e-07,0.84917e-07 /)
      kbo(:, 4,58, 2) = (/ &
        & 0.52817e-10,0.42958e-07,0.75173e-07,0.10204e-06,0.10603e-06 /)
      kbo(:, 5,58, 2) = (/ &
        & 0.56864e-10,0.53637e-07,0.92044e-07,0.12229e-06,0.13011e-06 /)
      kbo(:, 1,59, 2) = (/ &
        & 0.37496e-10,0.17255e-07,0.29967e-07,0.40394e-07,0.44059e-07 /)
      kbo(:, 2,59, 2) = (/ &
        & 0.38367e-10,0.22782e-07,0.39144e-07,0.51019e-07,0.54404e-07 /)
      kbo(:, 3,59, 2) = (/ &
        & 0.40346e-10,0.27842e-07,0.50692e-07,0.65716e-07,0.68440e-07 /)
      kbo(:, 4,59, 2) = (/ &
        & 0.42908e-10,0.34761e-07,0.60846e-07,0.82834e-07,0.85713e-07 /)
      kbo(:, 5,59, 2) = (/ &
        & 0.46213e-10,0.43467e-07,0.74626e-07,0.99144e-07,0.10518e-06 /)
      kbo(:, 1,13, 3) = (/ &
        & 0.91180e-05,0.12754e-02,0.19900e-02,0.24440e-02,0.40576e-02 /)
      kbo(:, 2,13, 3) = (/ &
        & 0.95037e-05,0.14150e-02,0.22145e-02,0.28094e-02,0.44375e-02 /)
      kbo(:, 3,13, 3) = (/ &
        & 0.99757e-05,0.15626e-02,0.24320e-02,0.31375e-02,0.48097e-02 /)
      kbo(:, 4,13, 3) = (/ &
        & 0.10508e-04,0.16997e-02,0.26926e-02,0.34483e-02,0.51554e-02 /)
      kbo(:, 5,13, 3) = (/ &
        & 0.11033e-04,0.18373e-02,0.29684e-02,0.37861e-02,0.54896e-02 /)
      kbo(:, 1,14, 3) = (/ &
        & 0.73209e-05,0.10727e-02,0.16787e-02,0.20881e-02,0.33041e-02 /)
      kbo(:, 2,14, 3) = (/ &
        & 0.76795e-05,0.11937e-02,0.18683e-02,0.23616e-02,0.36246e-02 /)
      kbo(:, 3,14, 3) = (/ &
        & 0.80417e-05,0.13177e-02,0.20567e-02,0.26465e-02,0.39438e-02 /)
      kbo(:, 4,14, 3) = (/ &
        & 0.84296e-05,0.14317e-02,0.22826e-02,0.29022e-02,0.42368e-02 /)
      kbo(:, 5,14, 3) = (/ &
        & 0.88950e-05,0.15495e-02,0.25084e-02,0.31901e-02,0.44992e-02 /)
      kbo(:, 1,15, 3) = (/ &
        & 0.58275e-05,0.89895e-03,0.14161e-02,0.17760e-02,0.26508e-02 /)
      kbo(:, 2,15, 3) = (/ &
        & 0.61166e-05,0.10025e-02,0.15706e-02,0.19893e-02,0.29219e-02 /)
      kbo(:, 3,15, 3) = (/ &
        & 0.64340e-05,0.11055e-02,0.17375e-02,0.22237e-02,0.31718e-02 /)
      kbo(:, 4,15, 3) = (/ &
        & 0.67501e-05,0.12028e-02,0.19291e-02,0.24433e-02,0.34015e-02 /)
      kbo(:, 5,15, 3) = (/ &
        & 0.70843e-05,0.13034e-02,0.21152e-02,0.26892e-02,0.36350e-02 /)
      kbo(:, 1,16, 3) = (/ &
        & 0.45776e-05,0.75233e-03,0.11906e-02,0.14957e-02,0.21076e-02 /)
      kbo(:, 2,16, 3) = (/ &
        & 0.48262e-05,0.84051e-03,0.13192e-02,0.16780e-02,0.23267e-02 /)
      kbo(:, 3,16, 3) = (/ &
        & 0.51024e-05,0.92603e-03,0.14653e-02,0.18671e-02,0.25242e-02 /)
      kbo(:, 4,16, 3) = (/ &
        & 0.53856e-05,0.10093e-02,0.16288e-02,0.20599e-02,0.27134e-02 /)
      kbo(:, 5,16, 3) = (/ &
        & 0.56625e-05,0.10939e-02,0.17834e-02,0.22693e-02,0.29092e-02 /)
      kbo(:, 1,17, 3) = (/ &
        & 0.35978e-05,0.63055e-03,0.10001e-02,0.12618e-02,0.16759e-02 /)
      kbo(:, 2,17, 3) = (/ &
        & 0.38090e-05,0.70519e-03,0.11080e-02,0.14142e-02,0.18563e-02 /)
      kbo(:, 3,17, 3) = (/ &
        & 0.40365e-05,0.77593e-03,0.12352e-02,0.15692e-02,0.20215e-02 /)
      kbo(:, 4,17, 3) = (/ &
        & 0.42692e-05,0.84648e-03,0.13753e-02,0.17361e-02,0.21882e-02 /)
      kbo(:, 5,17, 3) = (/ &
        & 0.45325e-05,0.91815e-03,0.15031e-02,0.19156e-02,0.23511e-02 /)
      kbo(:, 1,18, 3) = (/ &
        & 0.28577e-05,0.52923e-03,0.84060e-03,0.10641e-02,0.13524e-02 /)
      kbo(:, 2,18, 3) = (/ &
        & 0.30189e-05,0.59275e-03,0.93264e-03,0.11925e-02,0.15051e-02 /)
      kbo(:, 3,18, 3) = (/ &
        & 0.31971e-05,0.65140e-03,0.10422e-02,0.13174e-02,0.16413e-02 /)
      kbo(:, 4,18, 3) = (/ &
        & 0.33981e-05,0.71144e-03,0.11594e-02,0.14613e-02,0.17851e-02 /)
      kbo(:, 5,18, 3) = (/ &
        & 0.36127e-05,0.77200e-03,0.12685e-02,0.16164e-02,0.19166e-02 /)
      kbo(:, 1,19, 3) = (/ &
        & 0.22832e-05,0.44489e-03,0.70523e-03,0.89150e-03,0.11054e-02 /)
      kbo(:, 2,19, 3) = (/ &
        & 0.24005e-05,0.49860e-03,0.78596e-03,0.10033e-02,0.12310e-02 /)
      kbo(:, 3,19, 3) = (/ &
        & 0.25465e-05,0.54746e-03,0.88096e-03,0.11084e-02,0.13479e-02 /)
      kbo(:, 4,19, 3) = (/ &
        & 0.27167e-05,0.59760e-03,0.97685e-03,0.12305e-02,0.14668e-02 /)
      kbo(:, 5,19, 3) = (/ &
        & 0.28927e-05,0.64844e-03,0.10695e-02,0.13632e-02,0.15746e-02 /)
      kbo(:, 1,20, 3) = (/ &
        & 0.18426e-05,0.37567e-03,0.59276e-03,0.75002e-03,0.91159e-03 /)
      kbo(:, 2,20, 3) = (/ &
        & 0.19324e-05,0.42049e-03,0.66376e-03,0.84304e-03,0.10175e-02 /)
      kbo(:, 3,20, 3) = (/ &
        & 0.20563e-05,0.46104e-03,0.74561e-03,0.93568e-03,0.11153e-02 /)
      kbo(:, 4,20, 3) = (/ &
        & 0.21952e-05,0.50302e-03,0.82491e-03,0.10410e-02,0.12131e-02 /)
      kbo(:, 5,20, 3) = (/ &
        & 0.23429e-05,0.54570e-03,0.90324e-03,0.11512e-02,0.13002e-02 /)
      kbo(:, 1,21, 3) = (/ &
        & 0.14914e-05,0.31727e-03,0.49879e-03,0.63141e-03,0.75480e-03 /)
      kbo(:, 2,21, 3) = (/ &
        & 0.15711e-05,0.35367e-03,0.56105e-03,0.70859e-03,0.84278e-03 /)
      kbo(:, 3,21, 3) = (/ &
        & 0.16720e-05,0.38776e-03,0.63122e-03,0.79066e-03,0.92492e-03 /)
      kbo(:, 4,21, 3) = (/ &
        & 0.17830e-05,0.42327e-03,0.69655e-03,0.88311e-03,0.10041e-02 /)
      kbo(:, 5,21, 3) = (/ &
        & 0.19065e-05,0.45905e-03,0.76238e-03,0.97320e-03,0.10767e-02 /)
      kbo(:, 1,22, 3) = (/ &
        & 0.12007e-05,0.26976e-03,0.42316e-03,0.53750e-03,0.62747e-03 /)
      kbo(:, 2,22, 3) = (/ &
        & 0.12744e-05,0.29880e-03,0.47840e-03,0.60094e-03,0.70134e-03 /)
      kbo(:, 3,22, 3) = (/ &
        & 0.13572e-05,0.32813e-03,0.53672e-03,0.67341e-03,0.76916e-03 /)
      kbo(:, 4,22, 3) = (/ &
        & 0.14459e-05,0.35761e-03,0.59154e-03,0.75421e-03,0.83371e-03 /)
      kbo(:, 5,22, 3) = (/ &
        & 0.15538e-05,0.38792e-03,0.64663e-03,0.82877e-03,0.89529e-03 /)
      kbo(:, 1,23, 3) = (/ &
        & 0.96861e-06,0.22918e-03,0.36015e-03,0.45719e-03,0.52404e-03 /)
      kbo(:, 2,23, 3) = (/ &
        & 0.10336e-05,0.25321e-03,0.40834e-03,0.51161e-03,0.58351e-03 /)
      kbo(:, 3,23, 3) = (/ &
        & 0.10985e-05,0.27767e-03,0.45571e-03,0.57459e-03,0.63985e-03 /)
      kbo(:, 4,23, 3) = (/ &
        & 0.11768e-05,0.30252e-03,0.50195e-03,0.64190e-03,0.69303e-03 /)
      kbo(:, 5,23, 3) = (/ &
        & 0.12615e-05,0.32794e-03,0.54831e-03,0.70579e-03,0.74540e-03 /)
      kbo(:, 1,24, 3) = (/ &
        & 0.77560e-06,0.19437e-03,0.30748e-03,0.38828e-03,0.43529e-03 /)
      kbo(:, 2,24, 3) = (/ &
        & 0.82580e-06,0.21438e-03,0.34835e-03,0.43617e-03,0.48373e-03 /)
      kbo(:, 3,24, 3) = (/ &
        & 0.88200e-06,0.23492e-03,0.38680e-03,0.49169e-03,0.53189e-03 /)
      kbo(:, 4,24, 3) = (/ &
        & 0.94947e-06,0.25573e-03,0.42635e-03,0.54641e-03,0.57637e-03 /)
      kbo(:, 5,24, 3) = (/ &
        & 0.10182e-05,0.27745e-03,0.46607e-03,0.60046e-03,0.61998e-03 /)
      kbo(:, 1,25, 3) = (/ &
        & 0.61963e-06,0.16454e-03,0.26284e-03,0.33016e-03,0.36284e-03 /)
      kbo(:, 2,25, 3) = (/ &
        & 0.66146e-06,0.18162e-03,0.29714e-03,0.37315e-03,0.40370e-03 /)
      kbo(:, 3,25, 3) = (/ &
        & 0.71111e-06,0.19882e-03,0.32942e-03,0.42130e-03,0.44382e-03 /)
      kbo(:, 4,25, 3) = (/ &
        & 0.76573e-06,0.21663e-03,0.36228e-03,0.46640e-03,0.48052e-03 /)
      kbo(:, 5,25, 3) = (/ &
        & 0.82100e-06,0.23503e-03,0.39627e-03,0.51132e-03,0.51776e-03 /)
      kbo(:, 1,26, 3) = (/ &
        & 0.49718e-06,0.13982e-03,0.22523e-03,0.28275e-03,0.30558e-03 /)
      kbo(:, 2,26, 3) = (/ &
        & 0.53365e-06,0.15431e-03,0.25368e-03,0.32044e-03,0.33895e-03 /)
      kbo(:, 3,26, 3) = (/ &
        & 0.57705e-06,0.16884e-03,0.28082e-03,0.36019e-03,0.37173e-03 /)
      kbo(:, 4,26, 3) = (/ &
        & 0.62061e-06,0.18393e-03,0.30865e-03,0.39866e-03,0.40243e-03 /)
      kbo(:, 5,26, 3) = (/ &
        & 0.66427e-06,0.19968e-03,0.33757e-03,0.43663e-03,0.43309e-03 /)
      kbo(:, 1,27, 3) = (/ &
        & 0.39961e-06,0.11889e-03,0.19361e-03,0.24270e-03,0.25693e-03 /)
      kbo(:, 2,27, 3) = (/ &
        & 0.43136e-06,0.13100e-03,0.21632e-03,0.27591e-03,0.28463e-03 /)
      kbo(:, 3,27, 3) = (/ &
        & 0.46490e-06,0.14333e-03,0.23966e-03,0.30849e-03,0.31106e-03 /)
      kbo(:, 4,27, 3) = (/ &
        & 0.50009e-06,0.15630e-03,0.26346e-03,0.34083e-03,0.33713e-03 /)
      kbo(:, 5,27, 3) = (/ &
        & 0.53808e-06,0.16999e-03,0.28768e-03,0.37323e-03,0.36279e-03 /)
      kbo(:, 1,28, 3) = (/ &
        & 0.31986e-06,0.10106e-03,0.16585e-03,0.20891e-03,0.21558e-03 /)
      kbo(:, 2,28, 3) = (/ &
        & 0.34540e-06,0.11119e-03,0.18500e-03,0.23760e-03,0.23854e-03 /)
      kbo(:, 3,28, 3) = (/ &
        & 0.37226e-06,0.12183e-03,0.20456e-03,0.26419e-03,0.26053e-03 /)
      kbo(:, 4,28, 3) = (/ &
        & 0.40317e-06,0.13290e-03,0.22487e-03,0.29156e-03,0.28262e-03 /)
      kbo(:, 5,28, 3) = (/ &
        & 0.43271e-06,0.14482e-03,0.24541e-03,0.31934e-03,0.30419e-03 /)
      kbo(:, 1,29, 3) = (/ &
        & 0.25677e-06,0.86060e-04,0.14206e-03,0.18023e-03,0.18141e-03 /)
      kbo(:, 2,29, 3) = (/ &
        & 0.27736e-06,0.94677e-04,0.15841e-03,0.20378e-03,0.20088e-03 /)
      kbo(:, 3,29, 3) = (/ &
        & 0.30104e-06,0.10372e-03,0.17515e-03,0.22663e-03,0.21921e-03 /)
      kbo(:, 4,29, 3) = (/ &
        & 0.32584e-06,0.11340e-03,0.19232e-03,0.24953e-03,0.23789e-03 /)
      kbo(:, 5,29, 3) = (/ &
        & 0.34891e-06,0.12368e-03,0.20976e-03,0.27364e-03,0.25570e-03 /)
      kbo(:, 1,30, 3) = (/ &
        & 0.20556e-06,0.73274e-04,0.12170e-03,0.15588e-03,0.15312e-03 /)
      kbo(:, 2,30, 3) = (/ &
        & 0.22376e-06,0.80651e-04,0.13568e-03,0.17524e-03,0.16948e-03 /)
      kbo(:, 3,30, 3) = (/ &
        & 0.24313e-06,0.88481e-04,0.14992e-03,0.19447e-03,0.18477e-03 /)
      kbo(:, 4,30, 3) = (/ &
        & 0.26233e-06,0.96824e-04,0.16458e-03,0.21409e-03,0.20027e-03 /)
      kbo(:, 5,30, 3) = (/ &
        & 0.28249e-06,0.10580e-03,0.17987e-03,0.23435e-03,0.21532e-03 /)
      kbo(:, 1,31, 3) = (/ &
        & 0.16553e-06,0.62536e-04,0.10457e-03,0.13443e-03,0.12968e-03 /)
      kbo(:, 2,31, 3) = (/ &
        & 0.18078e-06,0.68863e-04,0.11643e-03,0.15060e-03,0.14304e-03 /)
      kbo(:, 3,31, 3) = (/ &
        & 0.19619e-06,0.75670e-04,0.12864e-03,0.16681e-03,0.15615e-03 /)
      kbo(:, 4,31, 3) = (/ &
        & 0.21158e-06,0.82899e-04,0.14114e-03,0.18385e-03,0.16911e-03 /)
      kbo(:, 5,31, 3) = (/ &
        & 0.22915e-06,0.90629e-04,0.15456e-03,0.20099e-03,0.18146e-03 /)
      kbo(:, 1,32, 3) = (/ &
        & 0.13380e-06,0.53407e-04,0.89930e-04,0.11591e-03,0.11005e-03 /)
      kbo(:, 2,32, 3) = (/ &
        & 0.14604e-06,0.58887e-04,0.10001e-03,0.12963e-03,0.12107e-03 /)
      kbo(:, 3,32, 3) = (/ &
        & 0.15848e-06,0.64790e-04,0.11040e-03,0.14349e-03,0.13230e-03 /)
      kbo(:, 4,32, 3) = (/ &
        & 0.17190e-06,0.71169e-04,0.12125e-03,0.15792e-03,0.14297e-03 /)
      kbo(:, 5,32, 3) = (/ &
        & 0.18587e-06,0.77792e-04,0.13292e-03,0.17265e-03,0.15308e-03 /)
      kbo(:, 1,33, 3) = (/ &
        & 0.10830e-06,0.45686e-04,0.77339e-04,0.99867e-04,0.93562e-04 /)
      kbo(:, 2,33, 3) = (/ &
        & 0.11765e-06,0.50526e-04,0.85959e-04,0.11153e-03,0.10269e-03 /)
      kbo(:, 3,33, 3) = (/ &
        & 0.12824e-06,0.55627e-04,0.94900e-04,0.12354e-03,0.11205e-03 /)
      kbo(:, 4,33, 3) = (/ &
        & 0.13958e-06,0.61158e-04,0.10440e-03,0.13573e-03,0.12099e-03 /)
      kbo(:, 5,33, 3) = (/ &
        & 0.15078e-06,0.66909e-04,0.11431e-03,0.14861e-03,0.12918e-03 /)
      kbo(:, 1,34, 3) = (/ &
        & 0.87537e-07,0.39073e-04,0.66330e-04,0.85860e-04,0.79296e-04 /)
      kbo(:, 2,34, 3) = (/ &
        & 0.95270e-07,0.43282e-04,0.73743e-04,0.95733e-04,0.87082e-04 /)
      kbo(:, 3,34, 3) = (/ &
        & 0.10423e-06,0.47701e-04,0.81447e-04,0.10609e-03,0.94857e-04 /)
      kbo(:, 4,34, 3) = (/ &
        & 0.11348e-06,0.52484e-04,0.89624e-04,0.11638e-03,0.10211e-03 /)
      kbo(:, 5,34, 3) = (/ &
        & 0.12289e-06,0.57431e-04,0.98122e-04,0.12760e-03,0.10866e-03 /)
      kbo(:, 1,35, 3) = (/ &
        & 0.69891e-07,0.33129e-04,0.56323e-04,0.73036e-04,0.66568e-04 /)
      kbo(:, 2,35, 3) = (/ &
        & 0.76465e-07,0.36724e-04,0.62627e-04,0.81520e-04,0.73176e-04 /)
      kbo(:, 3,35, 3) = (/ &
        & 0.83833e-07,0.40619e-04,0.69293e-04,0.90161e-04,0.79548e-04 /)
      kbo(:, 4,35, 3) = (/ &
        & 0.91436e-07,0.44671e-04,0.76362e-04,0.99075e-04,0.85497e-04 /)
      kbo(:, 5,35, 3) = (/ &
        & 0.99263e-07,0.48886e-04,0.83550e-04,0.10849e-03,0.90720e-04 /)
      kbo(:, 1,36, 3) = (/ &
        & 0.55080e-07,0.27796e-04,0.47261e-04,0.61299e-04,0.55237e-04 /)
      kbo(:, 2,36, 3) = (/ &
        & 0.60562e-07,0.30850e-04,0.52635e-04,0.68515e-04,0.60794e-04 /)
      kbo(:, 3,36, 3) = (/ &
        & 0.66440e-07,0.34200e-04,0.58298e-04,0.75847e-04,0.66097e-04 /)
      kbo(:, 4,36, 3) = (/ &
        & 0.72913e-07,0.37650e-04,0.64310e-04,0.83530e-04,0.71032e-04 /)
      kbo(:, 5,36, 3) = (/ &
        & 0.79545e-07,0.41216e-04,0.70397e-04,0.91304e-04,0.75193e-04 /)
      kbo(:, 1,37, 3) = (/ &
        & 0.43644e-07,0.22997e-04,0.39088e-04,0.50714e-04,0.45374e-04 /)
      kbo(:, 2,37, 3) = (/ &
        & 0.48182e-07,0.25585e-04,0.43661e-04,0.56813e-04,0.50057e-04 /)
      kbo(:, 3,37, 3) = (/ &
        & 0.53067e-07,0.28429e-04,0.48465e-04,0.63020e-04,0.54490e-04 /)
      kbo(:, 4,37, 3) = (/ &
        & 0.58349e-07,0.31365e-04,0.53603e-04,0.69516e-04,0.58585e-04 /)
      kbo(:, 5,37, 3) = (/ &
        & 0.63727e-07,0.34398e-04,0.58710e-04,0.76032e-04,0.62046e-04 /)
      kbo(:, 1,38, 3) = (/ &
        & 0.34661e-07,0.19003e-04,0.32295e-04,0.41898e-04,0.37207e-04 /)
      kbo(:, 2,38, 3) = (/ &
        & 0.38414e-07,0.21200e-04,0.36170e-04,0.47045e-04,0.41150e-04 /)
      kbo(:, 3,38, 3) = (/ &
        & 0.42378e-07,0.23605e-04,0.40247e-04,0.52306e-04,0.44872e-04 /)
      kbo(:, 4,38, 3) = (/ &
        & 0.46598e-07,0.26110e-04,0.44620e-04,0.57800e-04,0.48293e-04 /)
      kbo(:, 5,38, 3) = (/ &
        & 0.50995e-07,0.28683e-04,0.48935e-04,0.63250e-04,0.51155e-04 /)
      kbo(:, 1,39, 3) = (/ &
        & 0.27545e-07,0.15700e-04,0.26661e-04,0.34603e-04,0.30487e-04 /)
      kbo(:, 2,39, 3) = (/ &
        & 0.30553e-07,0.17568e-04,0.29948e-04,0.38935e-04,0.33813e-04 /)
      kbo(:, 3,39, 3) = (/ &
        & 0.33772e-07,0.19601e-04,0.33411e-04,0.43403e-04,0.36922e-04 /)
      kbo(:, 4,39, 3) = (/ &
        & 0.37164e-07,0.21726e-04,0.37113e-04,0.48030e-04,0.39771e-04 /)
      kbo(:, 5,39, 3) = (/ &
        & 0.40795e-07,0.23901e-04,0.40765e-04,0.52607e-04,0.42152e-04 /)
      kbo(:, 1,40, 3) = (/ &
        & 0.21852e-07,0.12819e-04,0.21757e-04,0.28221e-04,0.24745e-04 /)
      kbo(:, 2,40, 3) = (/ &
        & 0.24207e-07,0.14395e-04,0.24527e-04,0.31867e-04,0.27502e-04 /)
      kbo(:, 3,40, 3) = (/ &
        & 0.26806e-07,0.16092e-04,0.27462e-04,0.35646e-04,0.30145e-04 /)
      kbo(:, 4,40, 3) = (/ &
        & 0.29612e-07,0.17894e-04,0.30572e-04,0.39527e-04,0.32543e-04 /)
      kbo(:, 5,40, 3) = (/ &
        & 0.32577e-07,0.19746e-04,0.33672e-04,0.43399e-04,0.34556e-04 /)
      kbo(:, 1,41, 3) = (/ &
        & 0.17336e-07,0.10441e-04,0.17695e-04,0.22954e-04,0.20042e-04 /)
      kbo(:, 2,41, 3) = (/ &
        & 0.19187e-07,0.11771e-04,0.20025e-04,0.26029e-04,0.22346e-04 /)
      kbo(:, 3,41, 3) = (/ &
        & 0.21311e-07,0.13190e-04,0.22516e-04,0.29201e-04,0.24577e-04 /)
      kbo(:, 4,41, 3) = (/ &
        & 0.23597e-07,0.14712e-04,0.25122e-04,0.32466e-04,0.26584e-04 /)
      kbo(:, 5,41, 3) = (/ &
        & 0.25958e-07,0.16280e-04,0.27744e-04,0.35762e-04,0.28295e-04 /)
      kbo(:, 1,42, 3) = (/ &
        & 0.13752e-07,0.84970e-05,0.14379e-04,0.18640e-04,0.16205e-04 /)
      kbo(:, 2,42, 3) = (/ &
        & 0.15240e-07,0.96082e-05,0.16325e-04,0.21225e-04,0.18124e-04 /)
      kbo(:, 3,42, 3) = (/ &
        & 0.16924e-07,0.10802e-04,0.18430e-04,0.23896e-04,0.20024e-04 /)
      kbo(:, 4,42, 3) = (/ &
        & 0.18767e-07,0.12087e-04,0.20609e-04,0.26651e-04,0.21698e-04 /)
      kbo(:, 5,42, 3) = (/ &
        & 0.20666e-07,0.13409e-04,0.22837e-04,0.29427e-04,0.23153e-04 /)
      kbo(:, 1,43, 3) = (/ &
        & 0.10827e-07,0.68624e-05,0.11586e-04,0.14999e-04,0.12975e-04 /)
      kbo(:, 2,43, 3) = (/ &
        & 0.12030e-07,0.77847e-05,0.13205e-04,0.17164e-04,0.14605e-04 /)
      kbo(:, 3,43, 3) = (/ &
        & 0.13352e-07,0.87779e-05,0.14974e-04,0.19410e-04,0.16231e-04 /)
      kbo(:, 4,43, 3) = (/ &
        & 0.14829e-07,0.98620e-05,0.16795e-04,0.21751e-04,0.17634e-04 /)
      kbo(:, 5,43, 3) = (/ &
        & 0.16396e-07,0.10975e-04,0.18682e-04,0.24066e-04,0.18879e-04 /)
      kbo(:, 1,44, 3) = (/ &
        & 0.85731e-08,0.55132e-05,0.92862e-05,0.12000e-04,0.10347e-04 /)
      kbo(:, 2,44, 3) = (/ &
        & 0.95033e-08,0.62816e-05,0.10629e-04,0.13817e-04,0.11712e-04 /)
      kbo(:, 3,44, 3) = (/ &
        & 0.10537e-07,0.70964e-05,0.12108e-04,0.15700e-04,0.13095e-04 /)
      kbo(:, 4,44, 3) = (/ &
        & 0.11722e-07,0.80120e-05,0.13621e-04,0.17679e-04,0.14296e-04 /)
      kbo(:, 5,44, 3) = (/ &
        & 0.12991e-07,0.89457e-05,0.15220e-04,0.19614e-04,0.15350e-04 /)
      kbo(:, 1,45, 3) = (/ &
        & 0.67515e-08,0.44212e-05,0.74244e-05,0.95776e-05,0.82429e-05 /)
      kbo(:, 2,45, 3) = (/ &
        & 0.74999e-08,0.50603e-05,0.85360e-05,0.11095e-04,0.93791e-05 /)
      kbo(:, 3,45, 3) = (/ &
        & 0.83182e-08,0.57411e-05,0.97686e-05,0.12667e-04,0.10528e-04 /)
      kbo(:, 4,45, 3) = (/ &
        & 0.92526e-08,0.64942e-05,0.11028e-04,0.14328e-04,0.11566e-04 /)
      kbo(:, 5,45, 3) = (/ &
        & 0.10269e-07,0.72769e-05,0.12375e-04,0.15964e-04,0.12472e-04 /)
      kbo(:, 1,46, 3) = (/ &
        & 0.53031e-08,0.35301e-05,0.59050e-05,0.75965e-05,0.65452e-05 /)
      kbo(:, 2,46, 3) = (/ &
        & 0.58907e-08,0.40561e-05,0.68233e-05,0.88621e-05,0.74771e-05 /)
      kbo(:, 3,46, 3) = (/ &
        & 0.65422e-08,0.46270e-05,0.78393e-05,0.10169e-04,0.84370e-05 /)
      kbo(:, 4,46, 3) = (/ &
        & 0.72669e-08,0.52433e-05,0.89061e-05,0.11563e-04,0.93268e-05 /)
      kbo(:, 5,46, 3) = (/ &
        & 0.80880e-08,0.58967e-05,0.10016e-04,0.12930e-04,0.10106e-04 /)
      kbo(:, 1,47, 3) = (/ &
        & 0.41459e-08,0.27965e-05,0.46529e-05,0.59648e-05,0.51552e-05 /)
      kbo(:, 2,47, 3) = (/ &
        & 0.46324e-08,0.32253e-05,0.54100e-05,0.70094e-05,0.59110e-05 /)
      kbo(:, 3,47, 3) = (/ &
        & 0.51433e-08,0.37014e-05,0.62395e-05,0.80976e-05,0.67100e-05 /)
      kbo(:, 4,47, 3) = (/ &
        & 0.57045e-08,0.42091e-05,0.71381e-05,0.92537e-05,0.74896e-05 /)
      kbo(:, 5,47, 3) = (/ &
        & 0.63526e-08,0.47541e-05,0.80573e-05,0.10428e-04,0.81540e-05 /)
      kbo(:, 1,48, 3) = (/ &
        & 0.32549e-08,0.22089e-05,0.36571e-05,0.46663e-05,0.40387e-05 /)
      kbo(:, 2,48, 3) = (/ &
        & 0.36192e-08,0.25581e-05,0.42752e-05,0.55265e-05,0.46582e-05 /)
      kbo(:, 3,48, 3) = (/ &
        & 0.40215e-08,0.29515e-05,0.49553e-05,0.64327e-05,0.53236e-05 /)
      kbo(:, 4,48, 3) = (/ &
        & 0.44736e-08,0.33690e-05,0.57015e-05,0.73859e-05,0.59960e-05 /)
      kbo(:, 5,48, 3) = (/ &
        & 0.49760e-08,0.38276e-05,0.64596e-05,0.83844e-05,0.65647e-05 /)
      kbo(:, 1,49, 3) = (/ &
        & 0.25432e-08,0.17390e-05,0.28607e-05,0.36438e-05,0.31425e-05 /)
      kbo(:, 2,49, 3) = (/ &
        & 0.28364e-08,0.20219e-05,0.33698e-05,0.43412e-05,0.36654e-05 /)
      kbo(:, 3,49, 3) = (/ &
        & 0.31601e-08,0.23472e-05,0.39232e-05,0.50964e-05,0.42142e-05 /)
      kbo(:, 4,49, 3) = (/ &
        & 0.35101e-08,0.26948e-05,0.45429e-05,0.58797e-05,0.47715e-05 /)
      kbo(:, 5,49, 3) = (/ &
        & 0.38989e-08,0.30718e-05,0.51731e-05,0.67190e-05,0.52720e-05 /)
      kbo(:, 1,50, 3) = (/ &
        & 0.20093e-08,0.13704e-05,0.22373e-05,0.28375e-05,0.24550e-05 /)
      kbo(:, 2,50, 3) = (/ &
        & 0.22270e-08,0.16020e-05,0.26626e-05,0.34144e-05,0.28963e-05 /)
      kbo(:, 3,50, 3) = (/ &
        & 0.24797e-08,0.18686e-05,0.31131e-05,0.40348e-05,0.33398e-05 /)
      kbo(:, 4,50, 3) = (/ &
        & 0.27614e-08,0.21593e-05,0.36199e-05,0.46856e-05,0.38019e-05 /)
      kbo(:, 5,50, 3) = (/ &
        & 0.30674e-08,0.24699e-05,0.41517e-05,0.53844e-05,0.42322e-05 /)
      kbo(:, 1,51, 3) = (/ &
        & 0.15907e-08,0.10803e-05,0.17518e-05,0.22064e-05,0.19254e-05 /)
      kbo(:, 2,51, 3) = (/ &
        & 0.17509e-08,0.12691e-05,0.21000e-05,0.26794e-05,0.22832e-05 /)
      kbo(:, 3,51, 3) = (/ &
        & 0.19509e-08,0.14861e-05,0.24726e-05,0.31957e-05,0.26418e-05 /)
      kbo(:, 4,51, 3) = (/ &
        & 0.21703e-08,0.17284e-05,0.28838e-05,0.37325e-05,0.30257e-05 /)
      kbo(:, 5,51, 3) = (/ &
        & 0.24124e-08,0.19844e-05,0.33305e-05,0.43128e-05,0.34015e-05 /)
      kbo(:, 1,52, 3) = (/ &
        & 0.12564e-08,0.84669e-06,0.13717e-05,0.17147e-05,0.14947e-05 /)
      kbo(:, 2,52, 3) = (/ &
        & 0.13794e-08,0.10024e-05,0.16523e-05,0.20993e-05,0.17870e-05 /)
      kbo(:, 3,52, 3) = (/ &
        & 0.15320e-08,0.11790e-05,0.19577e-05,0.25220e-05,0.20845e-05 /)
      kbo(:, 4,52, 3) = (/ &
        & 0.17130e-08,0.13791e-05,0.22952e-05,0.29677e-05,0.24040e-05 /)
      kbo(:, 5,52, 3) = (/ &
        & 0.19041e-08,0.15914e-05,0.26635e-05,0.34439e-05,0.27247e-05 /)
      kbo(:, 1,53, 3) = (/ &
        & 0.99523e-09,0.66219e-06,0.10632e-05,0.13341e-05,0.11550e-05 /)
      kbo(:, 2,53, 3) = (/ &
        & 0.10903e-08,0.79022e-06,0.12914e-05,0.16401e-05,0.13929e-05 /)
      kbo(:, 3,53, 3) = (/ &
        & 0.12082e-08,0.93266e-06,0.15445e-05,0.19841e-05,0.16452e-05 /)
      kbo(:, 4,53, 3) = (/ &
        & 0.13437e-08,0.10969e-05,0.18212e-05,0.23517e-05,0.19029e-05 /)
      kbo(:, 5,53, 3) = (/ &
        & 0.14972e-08,0.12734e-05,0.21276e-05,0.27431e-05,0.21722e-05 /)
      kbo(:, 1,54, 3) = (/ &
        & 0.78782e-09,0.51993e-06,0.82752e-06,0.10421e-05,0.88632e-06 /)
      kbo(:, 2,54, 3) = (/ &
        & 0.86642e-09,0.62440e-06,0.10138e-05,0.12820e-05,0.10958e-05 /)
      kbo(:, 3,54, 3) = (/ &
        & 0.95141e-09,0.74051e-06,0.12221e-05,0.15626e-05,0.13014e-05 /)
      kbo(:, 4,54, 3) = (/ &
        & 0.10622e-08,0.87438e-06,0.14481e-05,0.18675e-05,0.15138e-05 /)
      kbo(:, 5,54, 3) = (/ &
        & 0.11829e-08,0.10217e-05,0.17025e-05,0.21900e-05,0.17349e-05 /)
      kbo(:, 1,55, 3) = (/ &
        & 0.62734e-09,0.40844e-06,0.64675e-06,0.81168e-06,0.68015e-06 /)
      kbo(:, 2,55, 3) = (/ &
        & 0.68670e-09,0.49437e-06,0.79822e-06,0.10031e-05,0.85955e-06 /)
      kbo(:, 3,55, 3) = (/ &
        & 0.75551e-09,0.58813e-06,0.96640e-06,0.12305e-05,0.10290e-05 /)
      kbo(:, 4,55, 3) = (/ &
        & 0.83896e-09,0.69762e-06,0.11529e-05,0.14845e-05,0.12025e-05 /)
      kbo(:, 5,55, 3) = (/ &
        & 0.93727e-09,0.81992e-06,0.13618e-05,0.17489e-05,0.13856e-05 /)
      kbo(:, 1,56, 3) = (/ &
        & 0.50214e-09,0.32028e-06,0.50524e-06,0.63147e-06,0.51903e-06 /)
      kbo(:, 2,56, 3) = (/ &
        & 0.54775e-09,0.38841e-06,0.62589e-06,0.78445e-06,0.67099e-06 /)
      kbo(:, 3,56, 3) = (/ &
        & 0.59971e-09,0.46602e-06,0.76356e-06,0.96978e-06,0.80912e-06 /)
      kbo(:, 4,56, 3) = (/ &
        & 0.66466e-09,0.55509e-06,0.91533e-06,0.11766e-05,0.95284e-06 /)
      kbo(:, 5,56, 3) = (/ &
        & 0.73931e-09,0.65625e-06,0.10864e-05,0.13946e-05,0.11055e-05 /)
      kbo(:, 1,57, 3) = (/ &
        & 0.40171e-09,0.25009e-06,0.39211e-06,0.49250e-06,0.39332e-06 /)
      kbo(:, 2,57, 3) = (/ &
        & 0.43379e-09,0.30473e-06,0.48932e-06,0.61342e-06,0.52076e-06 /)
      kbo(:, 3,57, 3) = (/ &
        & 0.47729e-09,0.36874e-06,0.59978e-06,0.76246e-06,0.63556e-06 /)
      kbo(:, 4,57, 3) = (/ &
        & 0.52454e-09,0.44075e-06,0.72488e-06,0.93079e-06,0.75448e-06 /)
      kbo(:, 5,57, 3) = (/ &
        & 0.58546e-09,0.52389e-06,0.86565e-06,0.11107e-05,0.87858e-06 /)
      kbo(:, 1,58, 3) = (/ &
        & 0.32222e-09,0.19536e-06,0.30484e-06,0.38123e-06,0.29798e-06 /)
      kbo(:, 2,58, 3) = (/ &
        & 0.34550e-09,0.24003e-06,0.38206e-06,0.48033e-06,0.40193e-06 /)
      kbo(:, 3,58, 3) = (/ &
        & 0.37930e-09,0.29179e-06,0.47226e-06,0.59938e-06,0.50056e-06 /)
      kbo(:, 4,58, 3) = (/ &
        & 0.41675e-09,0.35035e-06,0.57500e-06,0.73642e-06,0.59836e-06 /)
      kbo(:, 5,58, 3) = (/ &
        & 0.46320e-09,0.41854e-06,0.69041e-06,0.88548e-06,0.70003e-06 /)
      kbo(:, 1,59, 3) = (/ &
        & 0.26166e-09,0.15868e-06,0.24697e-06,0.30892e-06,0.23964e-06 /)
      kbo(:, 2,59, 3) = (/ &
        & 0.28095e-09,0.19552e-06,0.31068e-06,0.39037e-06,0.32469e-06 /)
      kbo(:, 3,59, 3) = (/ &
        & 0.30730e-09,0.23856e-06,0.38554e-06,0.48902e-06,0.40738e-06 /)
      kbo(:, 4,59, 3) = (/ &
        & 0.33781e-09,0.28749e-06,0.47157e-06,0.60286e-06,0.48803e-06 /)
      kbo(:, 5,59, 3) = (/ &
        & 0.37526e-09,0.34439e-06,0.56789e-06,0.72742e-06,0.57238e-06 /)
      kbo(:, 1,13, 4) = (/ &
        & 0.49038e-04,0.50781e-02,0.78254e-02,0.96484e-02,0.10614e-01 /)
      kbo(:, 2,13, 4) = (/ &
        & 0.54225e-04,0.54905e-02,0.85710e-02,0.10460e-01,0.11206e-01 /)
      kbo(:, 3,13, 4) = (/ &
        & 0.61134e-04,0.58773e-02,0.93183e-02,0.11347e-01,0.11729e-01 /)
      kbo(:, 4,13, 4) = (/ &
        & 0.68793e-04,0.62794e-02,0.99768e-02,0.12248e-01,0.12250e-01 /)
      kbo(:, 5,13, 4) = (/ &
        & 0.77429e-04,0.66893e-02,0.10624e-01,0.13064e-01,0.12730e-01 /)
      kbo(:, 1,14, 4) = (/ &
        & 0.40706e-04,0.43045e-02,0.66240e-02,0.81227e-02,0.87105e-02 /)
      kbo(:, 2,14, 4) = (/ &
        & 0.45789e-04,0.46404e-02,0.72547e-02,0.88508e-02,0.92183e-02 /)
      kbo(:, 3,14, 4) = (/ &
        & 0.51359e-04,0.49670e-02,0.78649e-02,0.95928e-02,0.96590e-02 /)
      kbo(:, 4,14, 4) = (/ &
        & 0.58448e-04,0.53112e-02,0.84165e-02,0.10356e-01,0.10085e-01 /)
      kbo(:, 5,14, 4) = (/ &
        & 0.66585e-04,0.56590e-02,0.89770e-02,0.11022e-01,0.10540e-01 /)
      kbo(:, 1,15, 4) = (/ &
        & 0.33161e-04,0.36374e-02,0.56007e-02,0.68408e-02,0.70399e-02 /)
      kbo(:, 2,15, 4) = (/ &
        & 0.37316e-04,0.39145e-02,0.61318e-02,0.74812e-02,0.74533e-02 /)
      kbo(:, 3,15, 4) = (/ &
        & 0.42184e-04,0.41949e-02,0.66272e-02,0.81097e-02,0.78393e-02 /)
      kbo(:, 4,15, 4) = (/ &
        & 0.48249e-04,0.44861e-02,0.70934e-02,0.87330e-02,0.82262e-02 /)
      kbo(:, 5,15, 4) = (/ &
        & 0.54912e-04,0.47829e-02,0.75688e-02,0.92830e-02,0.86058e-02 /)
      kbo(:, 1,16, 4) = (/ &
        & 0.26598e-04,0.30649e-02,0.47323e-02,0.57742e-02,0.56644e-02 /)
      kbo(:, 2,16, 4) = (/ &
        & 0.30096e-04,0.32950e-02,0.51778e-02,0.63145e-02,0.60193e-02 /)
      kbo(:, 3,16, 4) = (/ &
        & 0.34085e-04,0.35350e-02,0.55806e-02,0.68447e-02,0.63708e-02 /)
      kbo(:, 4,16, 4) = (/ &
        & 0.38919e-04,0.37831e-02,0.59719e-02,0.73465e-02,0.67088e-02 /)
      kbo(:, 5,16, 4) = (/ &
        & 0.44492e-04,0.40393e-02,0.63750e-02,0.78120e-02,0.70249e-02 /)
      kbo(:, 1,17, 4) = (/ &
        & 0.21449e-04,0.25756e-02,0.39936e-02,0.48662e-02,0.46205e-02 /)
      kbo(:, 2,17, 4) = (/ &
        & 0.24103e-04,0.27706e-02,0.43619e-02,0.53164e-02,0.49202e-02 /)
      kbo(:, 3,17, 4) = (/ &
        & 0.27451e-04,0.29765e-02,0.46959e-02,0.57632e-02,0.52122e-02 /)
      kbo(:, 4,17, 4) = (/ &
        & 0.31381e-04,0.31884e-02,0.50222e-02,0.61735e-02,0.54790e-02 /)
      kbo(:, 5,17, 4) = (/ &
        & 0.35953e-04,0.34099e-02,0.53645e-02,0.65659e-02,0.57419e-02 /)
      kbo(:, 1,18, 4) = (/ &
        & 0.17468e-04,0.21642e-02,0.33642e-02,0.40972e-02,0.37921e-02 /)
      kbo(:, 2,18, 4) = (/ &
        & 0.19506e-04,0.23308e-02,0.36683e-02,0.44696e-02,0.40385e-02 /)
      kbo(:, 3,18, 4) = (/ &
        & 0.22326e-04,0.25072e-02,0.39454e-02,0.48507e-02,0.42773e-02 /)
      kbo(:, 4,18, 4) = (/ &
        & 0.25558e-04,0.26901e-02,0.42240e-02,0.51855e-02,0.45000e-02 /)
      kbo(:, 5,18, 4) = (/ &
        & 0.29519e-04,0.28816e-02,0.45135e-02,0.55168e-02,0.47259e-02 /)
      kbo(:, 1,19, 4) = (/ &
        & 0.14162e-04,0.18165e-02,0.28311e-02,0.34491e-02,0.31263e-02 /)
      kbo(:, 2,19, 4) = (/ &
        & 0.15880e-04,0.19594e-02,0.30792e-02,0.37577e-02,0.33277e-02 /)
      kbo(:, 3,19, 4) = (/ &
        & 0.18250e-04,0.21124e-02,0.33110e-02,0.40717e-02,0.35255e-02 /)
      kbo(:, 4,19, 4) = (/ &
        & 0.20948e-04,0.22711e-02,0.35512e-02,0.43541e-02,0.37114e-02 /)
      kbo(:, 5,19, 4) = (/ &
        & 0.24279e-04,0.24360e-02,0.37972e-02,0.46336e-02,0.39063e-02 /)
      kbo(:, 1,20, 4) = (/ &
        & 0.11677e-04,0.15268e-02,0.23854e-02,0.29054e-02,0.25927e-02 /)
      kbo(:, 2,20, 4) = (/ &
        & 0.13127e-04,0.16502e-02,0.25884e-02,0.31642e-02,0.27584e-02 /)
      kbo(:, 3,20, 4) = (/ &
        & 0.15145e-04,0.17827e-02,0.27854e-02,0.34198e-02,0.29228e-02 /)
      kbo(:, 4,20, 4) = (/ &
        & 0.17426e-04,0.19208e-02,0.29919e-02,0.36563e-02,0.30836e-02 /)
      kbo(:, 5,20, 4) = (/ &
        & 0.20187e-04,0.20638e-02,0.32027e-02,0.38955e-02,0.32517e-02 /)
      kbo(:, 1,21, 4) = (/ &
        & 0.96248e-05,0.12839e-02,0.20069e-02,0.24439e-02,0.21521e-02 /)
      kbo(:, 2,21, 4) = (/ &
        & 0.10884e-04,0.13905e-02,0.21753e-02,0.26634e-02,0.22901e-02 /)
      kbo(:, 3,21, 4) = (/ &
        & 0.12576e-04,0.15057e-02,0.23430e-02,0.28714e-02,0.24271e-02 /)
      kbo(:, 4,21, 4) = (/ &
        & 0.14492e-04,0.16245e-02,0.25229e-02,0.30709e-02,0.25653e-02 /)
      kbo(:, 5,21, 4) = (/ &
        & 0.16785e-04,0.17487e-02,0.27053e-02,0.32769e-02,0.27041e-02 /)
      kbo(:, 1,22, 4) = (/ &
        & 0.78987e-05,0.10841e-02,0.16963e-02,0.20646e-02,0.17920e-02 /)
      kbo(:, 2,22, 4) = (/ &
        & 0.90688e-05,0.11783e-02,0.18364e-02,0.22523e-02,0.19054e-02 /)
      kbo(:, 3,22, 4) = (/ &
        & 0.10436e-04,0.12776e-02,0.19832e-02,0.24220e-02,0.20200e-02 /)
      kbo(:, 4,22, 4) = (/ &
        & 0.12051e-04,0.13800e-02,0.21391e-02,0.25904e-02,0.21364e-02 /)
      kbo(:, 5,22, 4) = (/ &
        & 0.13992e-04,0.14877e-02,0.22983e-02,0.27690e-02,0.22519e-02 /)
      kbo(:, 1,23, 4) = (/ &
        & 0.65143e-05,0.91629e-03,0.14337e-02,0.17468e-02,0.14890e-02 /)
      kbo(:, 2,23, 4) = (/ &
        & 0.75295e-05,0.99880e-03,0.15532e-02,0.19017e-02,0.15844e-02 /)
      kbo(:, 3,23, 4) = (/ &
        & 0.86172e-05,0.10843e-02,0.16828e-02,0.20454e-02,0.16822e-02 /)
      kbo(:, 4,23, 4) = (/ &
        & 0.10017e-04,0.11729e-02,0.18176e-02,0.21912e-02,0.17800e-02 /)
      kbo(:, 5,23, 4) = (/ &
        & 0.11640e-04,0.12668e-02,0.19549e-02,0.23447e-02,0.18765e-02 /)
      kbo(:, 1,24, 4) = (/ &
        & 0.53432e-05,0.77571e-03,0.12114e-02,0.14805e-02,0.12372e-02 /)
      kbo(:, 2,24, 4) = (/ &
        & 0.61515e-05,0.84718e-03,0.13153e-02,0.16078e-02,0.13181e-02 /)
      kbo(:, 3,24, 4) = (/ &
        & 0.70923e-05,0.92024e-03,0.14293e-02,0.17300e-02,0.13989e-02 /)
      kbo(:, 4,24, 4) = (/ &
        & 0.82684e-05,0.99740e-03,0.15447e-02,0.18573e-02,0.14811e-02 /)
      kbo(:, 5,24, 4) = (/ &
        & 0.96268e-05,0.10789e-02,0.16627e-02,0.19892e-02,0.15621e-02 /)
      kbo(:, 1,25, 4) = (/ &
        & 0.43932e-05,0.65898e-03,0.10259e-02,0.12568e-02,0.10287e-02 /)
      kbo(:, 2,25, 4) = (/ &
        & 0.50483e-05,0.71973e-03,0.11174e-02,0.13610e-02,0.10973e-02 /)
      kbo(:, 3,25, 4) = (/ &
        & 0.58527e-05,0.78269e-03,0.12157e-02,0.14658e-02,0.11648e-02 /)
      kbo(:, 4,25, 4) = (/ &
        & 0.68258e-05,0.84968e-03,0.13158e-02,0.15774e-02,0.12354e-02 /)
      kbo(:, 5,25, 4) = (/ &
        & 0.79780e-05,0.92093e-03,0.14171e-02,0.16917e-02,0.13029e-02 /)
      kbo(:, 1,26, 4) = (/ &
        & 0.36349e-05,0.56139e-03,0.87232e-03,0.10671e-02,0.85747e-03 /)
      kbo(:, 2,26, 4) = (/ &
        & 0.41763e-05,0.61307e-03,0.95284e-03,0.11559e-02,0.91640e-03 /)
      kbo(:, 3,26, 4) = (/ &
        & 0.48643e-05,0.66769e-03,0.10377e-02,0.12480e-02,0.97417e-03 /)
      kbo(:, 4,26, 4) = (/ &
        & 0.56806e-05,0.72618e-03,0.11238e-02,0.13443e-02,0.10341e-02 /)
      kbo(:, 5,26, 4) = (/ &
        & 0.66574e-05,0.78791e-03,0.12118e-02,0.14426e-02,0.10908e-02 /)
      kbo(:, 1,27, 4) = (/ &
        & 0.29849e-05,0.47845e-03,0.74324e-03,0.90695e-03,0.71654e-03 /)
      kbo(:, 2,27, 4) = (/ &
        & 0.34528e-05,0.52305e-03,0.81407e-03,0.98348e-03,0.76622e-03 /)
      kbo(:, 3,27, 4) = (/ &
        & 0.40386e-05,0.57067e-03,0.88635e-03,0.10643e-02,0.81617e-03 /)
      kbo(:, 4,27, 4) = (/ &
        & 0.47349e-05,0.62159e-03,0.96045e-03,0.11476e-02,0.86667e-03 /)
      kbo(:, 5,27, 4) = (/ &
        & 0.55504e-05,0.67486e-03,0.10373e-02,0.12327e-02,0.91437e-03 /)
      kbo(:, 1,28, 4) = (/ &
        & 0.24474e-05,0.40819e-03,0.63469e-03,0.77184e-03,0.59959e-03 /)
      kbo(:, 2,28, 4) = (/ &
        & 0.28527e-05,0.44694e-03,0.69550e-03,0.83809e-03,0.64151e-03 /)
      kbo(:, 3,28, 4) = (/ &
        & 0.33444e-05,0.48804e-03,0.75797e-03,0.90921e-03,0.68464e-03 /)
      kbo(:, 4,28, 4) = (/ &
        & 0.39332e-05,0.53229e-03,0.82174e-03,0.98103e-03,0.72680e-03 /)
      kbo(:, 5,28, 4) = (/ &
        & 0.46245e-05,0.57864e-03,0.88872e-03,0.10544e-02,0.76723e-03 /)
      kbo(:, 1,29, 4) = (/ &
        & 0.20253e-05,0.34921e-03,0.54365e-03,0.65865e-03,0.50331e-03 /)
      kbo(:, 2,29, 4) = (/ &
        & 0.23720e-05,0.38278e-03,0.59577e-03,0.71729e-03,0.53864e-03 /)
      kbo(:, 3,29, 4) = (/ &
        & 0.27945e-05,0.41887e-03,0.64907e-03,0.77823e-03,0.57581e-03 /)
      kbo(:, 4,29, 4) = (/ &
        & 0.32936e-05,0.45699e-03,0.70481e-03,0.84074e-03,0.61089e-03 /)
      kbo(:, 5,29, 4) = (/ &
        & 0.38881e-05,0.49757e-03,0.76325e-03,0.90356e-03,0.64564e-03 /)
      kbo(:, 1,30, 4) = (/ &
        & 0.16797e-05,0.29918e-03,0.46598e-03,0.56316e-03,0.42270e-03 /)
      kbo(:, 2,30, 4) = (/ &
        & 0.19764e-05,0.32839e-03,0.51076e-03,0.61439e-03,0.45306e-03 /)
      kbo(:, 3,30, 4) = (/ &
        & 0.23384e-05,0.35985e-03,0.55686e-03,0.66712e-03,0.48445e-03 /)
      kbo(:, 4,30, 4) = (/ &
        & 0.27662e-05,0.39302e-03,0.60525e-03,0.72092e-03,0.51425e-03 /)
      kbo(:, 5,30, 4) = (/ &
        & 0.32687e-05,0.42837e-03,0.65610e-03,0.77570e-03,0.54396e-03 /)
      kbo(:, 1,31, 4) = (/ &
        & 0.13991e-05,0.25687e-03,0.39996e-03,0.48307e-03,0.35570e-03 /)
      kbo(:, 2,31, 4) = (/ &
        & 0.16564e-05,0.28246e-03,0.43858e-03,0.52743e-03,0.38211e-03 /)
      kbo(:, 3,31, 4) = (/ &
        & 0.19660e-05,0.30971e-03,0.47856e-03,0.57309e-03,0.40826e-03 /)
      kbo(:, 4,31, 4) = (/ &
        & 0.23334e-05,0.33881e-03,0.52066e-03,0.61919e-03,0.43367e-03 /)
      kbo(:, 5,31, 4) = (/ &
        & 0.27587e-05,0.36964e-03,0.56499e-03,0.66660e-03,0.45969e-03 /)
      kbo(:, 1,32, 4) = (/ &
        & 0.11711e-05,0.22102e-03,0.34394e-03,0.41512e-03,0.29980e-03 /)
      kbo(:, 2,32, 4) = (/ &
        & 0.13928e-05,0.24337e-03,0.37713e-03,0.45351e-03,0.32253e-03 /)
      kbo(:, 3,32, 4) = (/ &
        & 0.16589e-05,0.26704e-03,0.41202e-03,0.49272e-03,0.34442e-03 /)
      kbo(:, 4,32, 4) = (/ &
        & 0.19740e-05,0.29261e-03,0.44855e-03,0.53274e-03,0.36633e-03 /)
      kbo(:, 5,32, 4) = (/ &
        & 0.23323e-05,0.31973e-03,0.48726e-03,0.57383e-03,0.38915e-03 /)
      kbo(:, 1,33, 4) = (/ &
        & 0.98300e-06,0.19047e-03,0.29592e-03,0.35739e-03,0.25303e-03 /)
      kbo(:, 2,33, 4) = (/ &
        & 0.11751e-05,0.20983e-03,0.32474e-03,0.39043e-03,0.27259e-03 /)
      kbo(:, 3,33, 4) = (/ &
        & 0.14027e-05,0.23065e-03,0.35505e-03,0.42405e-03,0.29120e-03 /)
      kbo(:, 4,33, 4) = (/ &
        & 0.16692e-05,0.25302e-03,0.38699e-03,0.45888e-03,0.31018e-03 /)
      kbo(:, 5,33, 4) = (/ &
        & 0.19716e-05,0.27715e-03,0.42119e-03,0.49468e-03,0.32989e-03 /)
      kbo(:, 1,34, 4) = (/ &
        & 0.82915e-06,0.16396e-03,0.25433e-03,0.30700e-03,0.21406e-03 /)
      kbo(:, 2,34, 4) = (/ &
        & 0.99352e-06,0.18083e-03,0.27935e-03,0.33552e-03,0.23048e-03 /)
      kbo(:, 3,34, 4) = (/ &
        & 0.11877e-05,0.19915e-03,0.30578e-03,0.36455e-03,0.24659e-03 /)
      kbo(:, 4,34, 4) = (/ &
        & 0.14139e-05,0.21886e-03,0.33384e-03,0.39476e-03,0.26317e-03 /)
      kbo(:, 5,34, 4) = (/ &
        & 0.16670e-05,0.24021e-03,0.36390e-03,0.42603e-03,0.28005e-03 /)
      kbo(:, 1,35, 4) = (/ &
        & 0.68670e-06,0.13979e-03,0.21673e-03,0.26161e-03,0.17974e-03 /)
      kbo(:, 2,35, 4) = (/ &
        & 0.82437e-06,0.15448e-03,0.23846e-03,0.28611e-03,0.19377e-03 /)
      kbo(:, 3,35, 4) = (/ &
        & 0.98649e-06,0.17044e-03,0.26139e-03,0.31132e-03,0.20765e-03 /)
      kbo(:, 4,35, 4) = (/ &
        & 0.11740e-05,0.18773e-03,0.28609e-03,0.33740e-03,0.22197e-03 /)
      kbo(:, 5,35, 4) = (/ &
        & 0.13833e-05,0.20652e-03,0.31233e-03,0.36449e-03,0.23658e-03 /)
      kbo(:, 1,36, 4) = (/ &
        & 0.55564e-06,0.11786e-03,0.18283e-03,0.22089e-03,0.14951e-03 /)
      kbo(:, 2,36, 4) = (/ &
        & 0.66731e-06,0.13053e-03,0.20151e-03,0.24189e-03,0.16146e-03 /)
      kbo(:, 3,36, 4) = (/ &
        & 0.80048e-06,0.14432e-03,0.22154e-03,0.26364e-03,0.17348e-03 /)
      kbo(:, 4,36, 4) = (/ &
        & 0.95195e-06,0.15937e-03,0.24310e-03,0.28609e-03,0.18577e-03 /)
      kbo(:, 5,36, 4) = (/ &
        & 0.11217e-05,0.17580e-03,0.26601e-03,0.30949e-03,0.19850e-03 /)
      kbo(:, 1,37, 4) = (/ &
        & 0.44526e-06,0.98334e-04,0.15236e-03,0.18395e-03,0.12369e-03 /)
      kbo(:, 2,37, 4) = (/ &
        & 0.53551e-06,0.10927e-03,0.16837e-03,0.20194e-03,0.13387e-03 /)
      kbo(:, 3,37, 4) = (/ &
        & 0.64307e-06,0.12110e-03,0.18556e-03,0.22059e-03,0.14418e-03 /)
      kbo(:, 4,37, 4) = (/ &
        & 0.76688e-06,0.13411e-03,0.20414e-03,0.23985e-03,0.15477e-03 /)
      kbo(:, 5,37, 4) = (/ &
        & 0.90591e-06,0.14842e-03,0.22405e-03,0.25996e-03,0.16566e-03 /)
      kbo(:, 1,38, 4) = (/ &
        & 0.35630e-06,0.81991e-04,0.12690e-03,0.15312e-03,0.10226e-03 /)
      kbo(:, 2,38, 4) = (/ &
        & 0.42911e-06,0.91391e-04,0.14064e-03,0.16849e-03,0.11095e-03 /)
      kbo(:, 3,38, 4) = (/ &
        & 0.51583e-06,0.10163e-03,0.15538e-03,0.18448e-03,0.11977e-03 /)
      kbo(:, 4,38, 4) = (/ &
        & 0.61654e-06,0.11287e-03,0.17138e-03,0.20101e-03,0.12884e-03 /)
      kbo(:, 5,38, 4) = (/ &
        & 0.73028e-06,0.12530e-03,0.18862e-03,0.21826e-03,0.13816e-03 /)
      kbo(:, 1,39, 4) = (/ &
        & 0.28455e-06,0.68362e-04,0.10572e-03,0.12747e-03,0.84494e-04 /)
      kbo(:, 2,39, 4) = (/ &
        & 0.34313e-06,0.76413e-04,0.11751e-03,0.14060e-03,0.91905e-04 /)
      kbo(:, 3,39, 4) = (/ &
        & 0.41305e-06,0.85299e-04,0.13016e-03,0.15431e-03,0.99463e-04 /)
      kbo(:, 4,39, 4) = (/ &
        & 0.49466e-06,0.95047e-04,0.14396e-03,0.16851e-03,0.10725e-03 /)
      kbo(:, 5,39, 4) = (/ &
        & 0.58721e-06,0.10583e-03,0.15886e-03,0.18332e-03,0.11516e-03 /)
      kbo(:, 1,40, 4) = (/ &
        & 0.22416e-06,0.56451e-04,0.87192e-04,0.10503e-03,0.69299e-04 /)
      kbo(:, 2,40, 4) = (/ &
        & 0.27058e-06,0.63325e-04,0.97241e-04,0.11625e-03,0.75635e-04 /)
      kbo(:, 3,40, 4) = (/ &
        & 0.32640e-06,0.70942e-04,0.10801e-03,0.12792e-03,0.82061e-04 /)
      kbo(:, 4,40, 4) = (/ &
        & 0.39178e-06,0.79381e-04,0.11985e-03,0.14005e-03,0.88722e-04 /)
      kbo(:, 5,40, 4) = (/ &
        & 0.46694e-06,0.88673e-04,0.13261e-03,0.15274e-03,0.95437e-04 /)
      kbo(:, 1,41, 4) = (/ &
        & 0.17620e-06,0.46495e-04,0.71829e-04,0.86351e-04,0.56701e-04 /)
      kbo(:, 2,41, 4) = (/ &
        & 0.21295e-06,0.52383e-04,0.80380e-04,0.95937e-04,0.62100e-04 /)
      kbo(:, 3,41, 4) = (/ &
        & 0.25720e-06,0.58900e-04,0.89548e-04,0.10594e-03,0.67568e-04 /)
      kbo(:, 4,41, 4) = (/ &
        & 0.30957e-06,0.66136e-04,0.99643e-04,0.11623e-03,0.73280e-04 /)
      kbo(:, 5,41, 4) = (/ &
        & 0.37003e-06,0.74203e-04,0.11061e-03,0.12707e-03,0.78979e-04 /)
      kbo(:, 1,42, 4) = (/ &
        & 0.13843e-06,0.38238e-04,0.59124e-04,0.70982e-04,0.46331e-04 /)
      kbo(:, 2,42, 4) = (/ &
        & 0.16726e-06,0.43269e-04,0.66424e-04,0.79125e-04,0.50956e-04 /)
      kbo(:, 3,42, 4) = (/ &
        & 0.20232e-06,0.48870e-04,0.74247e-04,0.87661e-04,0.55561e-04 /)
      kbo(:, 4,42, 4) = (/ &
        & 0.24408e-06,0.55119e-04,0.82827e-04,0.96453e-04,0.60447e-04 /)
      kbo(:, 5,42, 4) = (/ &
        & 0.29276e-06,0.62028e-04,0.92221e-04,0.10570e-03,0.65281e-04 /)
      kbo(:, 1,43, 4) = (/ &
        & 0.10793e-06,0.31191e-04,0.48305e-04,0.57948e-04,0.37666e-04 /)
      kbo(:, 2,43, 4) = (/ &
        & 0.13017e-06,0.35465e-04,0.54489e-04,0.64841e-04,0.41556e-04 /)
      kbo(:, 3,43, 4) = (/ &
        & 0.15771e-06,0.40235e-04,0.61176e-04,0.72082e-04,0.45452e-04 /)
      kbo(:, 4,43, 4) = (/ &
        & 0.19064e-06,0.45599e-04,0.68488e-04,0.79576e-04,0.49593e-04 /)
      kbo(:, 5,43, 4) = (/ &
        & 0.22944e-06,0.51552e-04,0.76431e-04,0.87462e-04,0.53715e-04 /)
      kbo(:, 1,44, 4) = (/ &
        & 0.83879e-07,0.25325e-04,0.39297e-04,0.47118e-04,0.30510e-04 /)
      kbo(:, 2,44, 4) = (/ &
        & 0.10087e-06,0.28920e-04,0.44532e-04,0.52929e-04,0.33772e-04 /)
      kbo(:, 3,44, 4) = (/ &
        & 0.12238e-06,0.32977e-04,0.50189e-04,0.59075e-04,0.37069e-04 /)
      kbo(:, 4,44, 4) = (/ &
        & 0.14813e-06,0.37556e-04,0.56451e-04,0.65448e-04,0.40567e-04 /)
      kbo(:, 5,44, 4) = (/ &
        & 0.17874e-06,0.42672e-04,0.63196e-04,0.72159e-04,0.44085e-04 /)
      kbo(:, 1,45, 4) = (/ &
        & 0.65261e-07,0.20516e-04,0.31895e-04,0.38279e-04,0.24650e-04 /)
      kbo(:, 2,45, 4) = (/ &
        & 0.78145e-07,0.23540e-04,0.36319e-04,0.43161e-04,0.27390e-04 /)
      kbo(:, 3,45, 4) = (/ &
        & 0.94805e-07,0.26962e-04,0.41134e-04,0.48357e-04,0.30190e-04 /)
      kbo(:, 4,45, 4) = (/ &
        & 0.11490e-06,0.30858e-04,0.46429e-04,0.53785e-04,0.33136e-04 /)
      kbo(:, 5,45, 4) = (/ &
        & 0.13905e-06,0.35210e-04,0.52216e-04,0.59482e-04,0.36122e-04 /)
      kbo(:, 1,46, 4) = (/ &
        & 0.50668e-07,0.16526e-04,0.25752e-04,0.30954e-04,0.19817e-04 /)
      kbo(:, 2,46, 4) = (/ &
        & 0.60361e-07,0.19058e-04,0.29471e-04,0.35060e-04,0.22123e-04 /)
      kbo(:, 3,46, 4) = (/ &
        & 0.73101e-07,0.21937e-04,0.33569e-04,0.39461e-04,0.24498e-04 /)
      kbo(:, 4,46, 4) = (/ &
        & 0.88747e-07,0.25222e-04,0.38048e-04,0.44039e-04,0.26973e-04 /)
      kbo(:, 5,46, 4) = (/ &
        & 0.10762e-06,0.28932e-04,0.42964e-04,0.48871e-04,0.29499e-04 /)
      kbo(:, 1,47, 4) = (/ &
        & 0.39185e-07,0.13207e-04,0.20626e-04,0.24835e-04,0.15826e-04 /)
      kbo(:, 2,47, 4) = (/ &
        & 0.46335e-07,0.15303e-04,0.23722e-04,0.28277e-04,0.17762e-04 /)
      kbo(:, 3,47, 4) = (/ &
        & 0.55896e-07,0.17703e-04,0.27162e-04,0.31976e-04,0.19780e-04 /)
      kbo(:, 4,47, 4) = (/ &
        & 0.67962e-07,0.20451e-04,0.30940e-04,0.35867e-04,0.21834e-04 /)
      kbo(:, 5,47, 4) = (/ &
        & 0.82535e-07,0.23583e-04,0.35128e-04,0.39933e-04,0.23972e-04 /)
      kbo(:, 1,48, 4) = (/ &
        & 0.30435e-07,0.10528e-04,0.16458e-04,0.19871e-04,0.12630e-04 /)
      kbo(:, 2,48, 4) = (/ &
        & 0.35657e-07,0.12255e-04,0.19034e-04,0.22757e-04,0.14230e-04 /)
      kbo(:, 3,48, 4) = (/ &
        & 0.42777e-07,0.14241e-04,0.21916e-04,0.25856e-04,0.15916e-04 /)
      kbo(:, 4,48, 4) = (/ &
        & 0.51977e-07,0.16531e-04,0.25094e-04,0.29142e-04,0.17632e-04 /)
      kbo(:, 5,48, 4) = (/ &
        & 0.63246e-07,0.19162e-04,0.28631e-04,0.32586e-04,0.19447e-04 /)
      kbo(:, 1,49, 4) = (/ &
        & 0.23722e-07,0.83656e-05,0.13088e-04,0.15834e-04,0.10060e-04 /)
      kbo(:, 2,49, 4) = (/ &
        & 0.27509e-07,0.97869e-05,0.15227e-04,0.18252e-04,0.11363e-04 /)
      kbo(:, 3,49, 4) = (/ &
        & 0.32769e-07,0.11426e-04,0.17628e-04,0.20853e-04,0.12767e-04 /)
      kbo(:, 4,49, 4) = (/ &
        & 0.39719e-07,0.13326e-04,0.20285e-04,0.23637e-04,0.14223e-04 /)
      kbo(:, 5,49, 4) = (/ &
        & 0.48415e-07,0.15524e-04,0.23268e-04,0.26530e-04,0.15739e-04 /)
      kbo(:, 1,50, 4) = (/ &
        & 0.18623e-07,0.66620e-05,0.10425e-04,0.12634e-04,0.80132e-05 /)
      kbo(:, 2,50, 4) = (/ &
        & 0.21393e-07,0.78264e-05,0.12188e-04,0.14643e-04,0.90757e-05 /)
      kbo(:, 3,50, 4) = (/ &
        & 0.25281e-07,0.91787e-05,0.14186e-04,0.16825e-04,0.10247e-04 /)
      kbo(:, 4,50, 4) = (/ &
        & 0.30530e-07,0.10758e-04,0.16419e-04,0.19178e-04,0.11482e-04 /)
      kbo(:, 5,50, 4) = (/ &
        & 0.37213e-07,0.12593e-04,0.18920e-04,0.21643e-04,0.12749e-04 /)
      kbo(:, 1,51, 4) = (/ &
        & 0.14681e-07,0.53043e-05,0.82956e-05,0.10064e-04,0.63669e-05 /)
      kbo(:, 2,51, 4) = (/ &
        & 0.16717e-07,0.62508e-05,0.97501e-05,0.11737e-04,0.72473e-05 /)
      kbo(:, 3,51, 4) = (/ &
        & 0.19587e-07,0.73643e-05,0.11400e-04,0.13558e-04,0.82290e-05 /)
      kbo(:, 4,51, 4) = (/ &
        & 0.23555e-07,0.86748e-05,0.13268e-04,0.15537e-04,0.92634e-05 /)
      kbo(:, 5,51, 4) = (/ &
        & 0.28671e-07,0.10209e-04,0.15379e-04,0.17635e-04,0.10316e-04 /)
      kbo(:, 1,52, 4) = (/ &
        & 0.11626e-07,0.42149e-05,0.65740e-05,0.79835e-05,0.50595e-05 /)
      kbo(:, 2,52, 4) = (/ &
        & 0.13102e-07,0.49884e-05,0.77758e-05,0.93846e-05,0.57856e-05 /)
      kbo(:, 3,52, 4) = (/ &
        & 0.15208e-07,0.58955e-05,0.91392e-05,0.10898e-04,0.65937e-05 /)
      kbo(:, 4,52, 4) = (/ &
        & 0.18174e-07,0.69758e-05,0.10692e-04,0.12554e-04,0.74564e-05 /)
      kbo(:, 5,52, 4) = (/ &
        & 0.22057e-07,0.82505e-05,0.12462e-04,0.14331e-04,0.83301e-05 /)
      kbo(:, 1,53, 4) = (/ &
        & 0.92130e-08,0.33378e-05,0.51998e-05,0.63006e-05,0.40097e-05 /)
      kbo(:, 2,53, 4) = (/ &
        & 0.10298e-07,0.39704e-05,0.61839e-05,0.74775e-05,0.46077e-05 /)
      kbo(:, 3,53, 4) = (/ &
        & 0.11831e-07,0.47088e-05,0.73062e-05,0.87345e-05,0.52620e-05 /)
      kbo(:, 4,53, 4) = (/ &
        & 0.14030e-07,0.55942e-05,0.85921e-05,0.10119e-04,0.59838e-05 /)
      kbo(:, 5,53, 4) = (/ &
        & 0.16970e-07,0.66447e-05,0.10063e-04,0.11620e-04,0.67208e-05 /)
      kbo(:, 1,54, 4) = (/ &
        & 0.73443e-08,0.26498e-05,0.41229e-05,0.49788e-05,0.31929e-05 /)
      kbo(:, 2,54, 4) = (/ &
        & 0.81453e-08,0.31689e-05,0.49320e-05,0.59701e-05,0.36706e-05 /)
      kbo(:, 3,54, 4) = (/ &
        & 0.92853e-08,0.37746e-05,0.58561e-05,0.70139e-05,0.42105e-05 /)
      kbo(:, 4,54, 4) = (/ &
        & 0.10913e-07,0.44986e-05,0.69192e-05,0.81733e-05,0.48081e-05 /)
      kbo(:, 5,54, 4) = (/ &
        & 0.13151e-07,0.53689e-05,0.81469e-05,0.94377e-05,0.54320e-05 /)
      kbo(:, 1,55, 4) = (/ &
        & 0.58690e-08,0.21056e-05,0.32710e-05,0.39362e-05,0.25357e-05 /)
      kbo(:, 2,55, 4) = (/ &
        & 0.64824e-08,0.25292e-05,0.39335e-05,0.47652e-05,0.29266e-05 /)
      kbo(:, 3,55, 4) = (/ &
        & 0.73195e-08,0.30260e-05,0.46942e-05,0.56346e-05,0.33700e-05 /)
      kbo(:, 4,55, 4) = (/ &
        & 0.85298e-08,0.36216e-05,0.55727e-05,0.65990e-05,0.38662e-05 /)
      kbo(:, 5,55, 4) = (/ &
        & 0.10227e-07,0.43366e-05,0.65935e-05,0.76627e-05,0.43889e-05 /)
      kbo(:, 1,56, 4) = (/ &
        & 0.46879e-08,0.16674e-05,0.25848e-05,0.30992e-05,0.20097e-05 /)
      kbo(:, 2,56, 4) = (/ &
        & 0.51579e-08,0.20145e-05,0.31307e-05,0.37875e-05,0.23304e-05 /)
      kbo(:, 3,56, 4) = (/ &
        & 0.57829e-08,0.24199e-05,0.37529e-05,0.45119e-05,0.26962e-05 /)
      kbo(:, 4,56, 4) = (/ &
        & 0.66817e-08,0.29092e-05,0.44788e-05,0.53142e-05,0.31037e-05 /)
      kbo(:, 5,56, 4) = (/ &
        & 0.79548e-08,0.34985e-05,0.53248e-05,0.62066e-05,0.35387e-05 /)
      kbo(:, 1,57, 4) = (/ &
        & 0.37487e-08,0.13177e-05,0.20362e-05,0.24278e-05,0.15888e-05 /)
      kbo(:, 2,57, 4) = (/ &
        & 0.41132e-08,0.16006e-05,0.24863e-05,0.30001e-05,0.18530e-05 /)
      kbo(:, 3,57, 4) = (/ &
        & 0.45796e-08,0.19301e-05,0.29957e-05,0.36053e-05,0.21515e-05 /)
      kbo(:, 4,57, 4) = (/ &
        & 0.52447e-08,0.23301e-05,0.35902e-05,0.42690e-05,0.24844e-05 /)
      kbo(:, 5,57, 4) = (/ &
        & 0.61952e-08,0.28175e-05,0.42894e-05,0.50133e-05,0.28503e-05 /)
      kbo(:, 1,58, 4) = (/ &
        & 0.30053e-08,0.10419e-05,0.16034e-05,0.19071e-05,0.12550e-05 /)
      kbo(:, 2,58, 4) = (/ &
        & 0.32906e-08,0.12717e-05,0.19750e-05,0.23751e-05,0.14761e-05 /)
      kbo(:, 3,58, 4) = (/ &
        & 0.36412e-08,0.15413e-05,0.23950e-05,0.28817e-05,0.17173e-05 /)
      kbo(:, 4,58, 4) = (/ &
        & 0.41327e-08,0.18673e-05,0.28800e-05,0.34301e-05,0.19893e-05 /)
      kbo(:, 5,58, 4) = (/ &
        & 0.48448e-08,0.22699e-05,0.34559e-05,0.40496e-05,0.22938e-05 /)
      kbo(:, 1,59, 4) = (/ &
        & 0.24517e-08,0.85367e-06,0.13121e-05,0.15587e-05,0.10209e-05 /)
      kbo(:, 2,59, 4) = (/ &
        & 0.26814e-08,0.10459e-05,0.16241e-05,0.19505e-05,0.12067e-05 /)
      kbo(:, 3,59, 4) = (/ &
        & 0.29604e-08,0.12726e-05,0.19786e-05,0.23765e-05,0.14071e-05 /)
      kbo(:, 4,59, 4) = (/ &
        & 0.33490e-08,0.15486e-05,0.23884e-05,0.28393e-05,0.16353e-05 /)
      kbo(:, 5,59, 4) = (/ &
        & 0.39177e-08,0.18923e-05,0.28751e-05,0.33648e-05,0.18896e-05 /)
      kbo(:, 1,13, 5) = (/ &
        & 0.10606e-02,0.17616e-01,0.26337e-01,0.30832e-01,0.23250e-01 /)
      kbo(:, 2,13, 5) = (/ &
        & 0.11975e-02,0.18851e-01,0.27746e-01,0.32191e-01,0.24461e-01 /)
      kbo(:, 3,13, 5) = (/ &
        & 0.13686e-02,0.20236e-01,0.29224e-01,0.33409e-01,0.25538e-01 /)
      kbo(:, 4,13, 5) = (/ &
        & 0.15788e-02,0.21686e-01,0.30822e-01,0.34581e-01,0.26483e-01 /)
      kbo(:, 5,13, 5) = (/ &
        & 0.18422e-02,0.23201e-01,0.32485e-01,0.35791e-01,0.27339e-01 /)
      kbo(:, 1,14, 5) = (/ &
        & 0.90299e-03,0.14939e-01,0.22235e-01,0.25969e-01,0.19459e-01 /)
      kbo(:, 2,14, 5) = (/ &
        & 0.10276e-02,0.16043e-01,0.23464e-01,0.27102e-01,0.20418e-01 /)
      kbo(:, 3,14, 5) = (/ &
        & 0.11848e-02,0.17244e-01,0.24766e-01,0.28137e-01,0.21279e-01 /)
      kbo(:, 4,14, 5) = (/ &
        & 0.13763e-02,0.18494e-01,0.26159e-01,0.29141e-01,0.22035e-01 /)
      kbo(:, 5,14, 5) = (/ &
        & 0.16087e-02,0.19801e-01,0.27586e-01,0.30208e-01,0.22712e-01 /)
      kbo(:, 1,15, 5) = (/ &
        & 0.76169e-03,0.12657e-01,0.18744e-01,0.21807e-01,0.16155e-01 /)
      kbo(:, 2,15, 5) = (/ &
        & 0.87429e-03,0.13622e-01,0.19820e-01,0.22753e-01,0.16908e-01 /)
      kbo(:, 3,15, 5) = (/ &
        & 0.10153e-02,0.14650e-01,0.20967e-01,0.23637e-01,0.17597e-01 /)
      kbo(:, 4,15, 5) = (/ &
        & 0.11860e-02,0.15728e-01,0.22159e-01,0.24521e-01,0.18236e-01 /)
      kbo(:, 5,15, 5) = (/ &
        & 0.13940e-02,0.16855e-01,0.23377e-01,0.25442e-01,0.18800e-01 /)
      kbo(:, 1,16, 5) = (/ &
        & 0.63979e-03,0.10716e-01,0.15782e-01,0.18280e-01,0.13330e-01 /)
      kbo(:, 2,16, 5) = (/ &
        & 0.73992e-03,0.11550e-01,0.16721e-01,0.19074e-01,0.13955e-01 /)
      kbo(:, 3,16, 5) = (/ &
        & 0.86535e-03,0.12432e-01,0.17715e-01,0.19835e-01,0.14519e-01 /)
      kbo(:, 4,16, 5) = (/ &
        & 0.10180e-02,0.13358e-01,0.18733e-01,0.20612e-01,0.15053e-01 /)
      kbo(:, 5,16, 5) = (/ &
        & 0.12020e-02,0.14330e-01,0.19780e-01,0.21390e-01,0.15523e-01 /)
      kbo(:, 1,17, 5) = (/ &
        & 0.53827e-03,0.90675e-02,0.13282e-01,0.15310e-01,0.11002e-01 /)
      kbo(:, 2,17, 5) = (/ &
        & 0.62733e-03,0.97818e-02,0.14093e-01,0.15985e-01,0.11517e-01 /)
      kbo(:, 3,17, 5) = (/ &
        & 0.73894e-03,0.10536e-01,0.14937e-01,0.16642e-01,0.11982e-01 /)
      kbo(:, 4,17, 5) = (/ &
        & 0.87471e-03,0.11329e-01,0.15813e-01,0.17308e-01,0.12431e-01 /)
      kbo(:, 5,17, 5) = (/ &
        & 0.10369e-02,0.12167e-01,0.16717e-01,0.17966e-01,0.12833e-01 /)
      kbo(:, 1,18, 5) = (/ &
        & 0.45632e-03,0.76631e-02,0.11175e-01,0.12821e-01,0.91007e-02 /)
      kbo(:, 2,18, 5) = (/ &
        & 0.53618e-03,0.82741e-02,0.11867e-01,0.13402e-01,0.95284e-02 /)
      kbo(:, 3,18, 5) = (/ &
        & 0.63520e-03,0.89179e-02,0.12591e-01,0.13960e-01,0.99227e-02 /)
      kbo(:, 4,18, 5) = (/ &
        & 0.75513e-03,0.95966e-02,0.13345e-01,0.14529e-01,0.10294e-01 /)
      kbo(:, 5,18, 5) = (/ &
        & 0.89828e-03,0.10325e-01,0.14127e-01,0.15082e-01,0.10637e-01 /)
      kbo(:, 1,19, 5) = (/ &
        & 0.38782e-03,0.64686e-02,0.93947e-02,0.10738e-01,0.75366e-02 /)
      kbo(:, 2,19, 5) = (/ &
        & 0.45826e-03,0.69872e-02,0.99878e-02,0.11230e-01,0.78920e-02 /)
      kbo(:, 3,19, 5) = (/ &
        & 0.54544e-03,0.75386e-02,0.10613e-01,0.11706e-01,0.82219e-02 /)
      kbo(:, 4,19, 5) = (/ &
        & 0.65085e-03,0.81243e-02,0.11261e-01,0.12183e-01,0.85447e-02 /)
      kbo(:, 5,19, 5) = (/ &
        & 0.77601e-03,0.87598e-02,0.11933e-01,0.12660e-01,0.88388e-02 /)
      kbo(:, 1,20, 5) = (/ &
        & 0.33304e-03,0.54623e-02,0.79028e-02,0.89960e-02,0.62635e-02 /)
      kbo(:, 2,20, 5) = (/ &
        & 0.39553e-03,0.59055e-02,0.84155e-02,0.94111e-02,0.65613e-02 /)
      kbo(:, 3,20, 5) = (/ &
        & 0.47180e-03,0.63779e-02,0.89500e-02,0.98172e-02,0.68459e-02 /)
      kbo(:, 4,20, 5) = (/ &
        & 0.56453e-03,0.68862e-02,0.95048e-02,0.10225e-01,0.71246e-02 /)
      kbo(:, 5,20, 5) = (/ &
        & 0.67486e-03,0.74411e-02,0.10082e-01,0.10637e-01,0.73786e-02 /)
      kbo(:, 1,21, 5) = (/ &
        & 0.28693e-03,0.46180e-02,0.66504e-02,0.75379e-02,0.52071e-02 /)
      kbo(:, 2,21, 5) = (/ &
        & 0.34180e-03,0.49948e-02,0.70898e-02,0.78866e-02,0.54645e-02 /)
      kbo(:, 3,21, 5) = (/ &
        & 0.40811e-03,0.54006e-02,0.75474e-02,0.82331e-02,0.57127e-02 /)
      kbo(:, 4,21, 5) = (/ &
        & 0.48873e-03,0.58434e-02,0.80212e-02,0.85844e-02,0.59470e-02 /)
      kbo(:, 5,21, 5) = (/ &
        & 0.58593e-03,0.63260e-02,0.85182e-02,0.89408e-02,0.61662e-02 /)
      kbo(:, 1,22, 5) = (/ &
        & 0.24974e-03,0.39240e-02,0.56208e-02,0.63345e-02,0.43431e-02 /)
      kbo(:, 2,22, 5) = (/ &
        & 0.29749e-03,0.42526e-02,0.59996e-02,0.66266e-02,0.45624e-02 /)
      kbo(:, 3,22, 5) = (/ &
        & 0.35608e-03,0.46047e-02,0.63919e-02,0.69259e-02,0.47738e-02 /)
      kbo(:, 4,22, 5) = (/ &
        & 0.42699e-03,0.49920e-02,0.67993e-02,0.72276e-02,0.49714e-02 /)
      kbo(:, 5,22, 5) = (/ &
        & 0.51198e-03,0.54166e-02,0.72302e-02,0.75387e-02,0.51660e-02 /)
      kbo(:, 1,23, 5) = (/ &
        & 0.21716e-03,0.33375e-02,0.47528e-02,0.53238e-02,0.36258e-02 /)
      kbo(:, 2,23, 5) = (/ &
        & 0.25886e-03,0.36243e-02,0.50797e-02,0.55740e-02,0.38107e-02 /)
      kbo(:, 3,23, 5) = (/ &
        & 0.31026e-03,0.39353e-02,0.54169e-02,0.58309e-02,0.39876e-02 /)
      kbo(:, 4,23, 5) = (/ &
        & 0.37235e-03,0.42757e-02,0.57711e-02,0.60911e-02,0.41586e-02 /)
      kbo(:, 5,23, 5) = (/ &
        & 0.44568e-03,0.46463e-02,0.61476e-02,0.63633e-02,0.43277e-02 /)
      kbo(:, 1,24, 5) = (/ &
        & 0.18738e-03,0.28412e-02,0.40251e-02,0.44754e-02,0.30232e-02 /)
      kbo(:, 2,24, 5) = (/ &
        & 0.22422e-03,0.30930e-02,0.43062e-02,0.46921e-02,0.31788e-02 /)
      kbo(:, 3,24, 5) = (/ &
        & 0.26942e-03,0.33694e-02,0.45983e-02,0.49126e-02,0.33287e-02 /)
      kbo(:, 4,24, 5) = (/ &
        & 0.32317e-03,0.36702e-02,0.49092e-02,0.51393e-02,0.34771e-02 /)
      kbo(:, 5,24, 5) = (/ &
        & 0.38638e-03,0.39951e-02,0.52385e-02,0.53815e-02,0.36232e-02 /)
      kbo(:, 1,25, 5) = (/ &
        & 0.16224e-03,0.24232e-02,0.34141e-02,0.37661e-02,0.25262e-02 /)
      kbo(:, 2,25, 5) = (/ &
        & 0.19465e-03,0.26463e-02,0.36575e-02,0.39541e-02,0.26577e-02 /)
      kbo(:, 3,25, 5) = (/ &
        & 0.23391e-03,0.28936e-02,0.39130e-02,0.41446e-02,0.27841e-02 /)
      kbo(:, 4,25, 5) = (/ &
        & 0.28044e-03,0.31598e-02,0.41853e-02,0.43442e-02,0.29098e-02 /)
      kbo(:, 5,25, 5) = (/ &
        & 0.33483e-03,0.34437e-02,0.44735e-02,0.45625e-02,0.30351e-02 /)
      kbo(:, 1,26, 5) = (/ &
        & 0.14132e-03,0.20737e-02,0.29036e-02,0.31762e-02,0.21157e-02 /)
      kbo(:, 2,26, 5) = (/ &
        & 0.16977e-03,0.22743e-02,0.31152e-02,0.33382e-02,0.22258e-02 /)
      kbo(:, 3,26, 5) = (/ &
        & 0.20409e-03,0.24947e-02,0.33401e-02,0.35048e-02,0.23338e-02 /)
      kbo(:, 4,26, 5) = (/ &
        & 0.24472e-03,0.27297e-02,0.35798e-02,0.36835e-02,0.24421e-02 /)
      kbo(:, 5,26, 5) = (/ &
        & 0.29131e-03,0.29804e-02,0.38308e-02,0.38797e-02,0.25500e-02 /)
      kbo(:, 1,27, 5) = (/ &
        & 0.12293e-03,0.17797e-02,0.24725e-02,0.26822e-02,0.17718e-02 /)
      kbo(:, 2,27, 5) = (/ &
        & 0.14789e-03,0.19595e-02,0.26584e-02,0.28222e-02,0.18655e-02 /)
      kbo(:, 3,27, 5) = (/ &
        & 0.17790e-03,0.21552e-02,0.28584e-02,0.29695e-02,0.19589e-02 /)
      kbo(:, 4,27, 5) = (/ &
        & 0.21315e-03,0.23624e-02,0.30688e-02,0.31309e-02,0.20520e-02 /)
      kbo(:, 5,27, 5) = (/ &
        & 0.25285e-03,0.25825e-02,0.32876e-02,0.33068e-02,0.21445e-02 /)
      kbo(:, 1,28, 5) = (/ &
        & 0.10657e-03,0.15319e-02,0.21096e-02,0.22678e-02,0.14844e-02 /)
      kbo(:, 2,28, 5) = (/ &
        & 0.12856e-03,0.16920e-02,0.22743e-02,0.23899e-02,0.15639e-02 /)
      kbo(:, 3,28, 5) = (/ &
        & 0.15471e-03,0.18636e-02,0.24511e-02,0.25221e-02,0.16436e-02 /)
      kbo(:, 4,28, 5) = (/ &
        & 0.18512e-03,0.20472e-02,0.26364e-02,0.26681e-02,0.17238e-02 /)
      kbo(:, 5,28, 5) = (/ &
        & 0.21872e-03,0.22411e-02,0.28270e-02,0.28260e-02,0.18048e-02 /)
      kbo(:, 1,29, 5) = (/ &
        & 0.92876e-04,0.13237e-02,0.18049e-02,0.19214e-02,0.12471e-02 /)
      kbo(:, 2,29, 5) = (/ &
        & 0.11226e-03,0.14659e-02,0.19518e-02,0.20295e-02,0.13143e-02 /)
      kbo(:, 3,29, 5) = (/ &
        & 0.13519e-03,0.16171e-02,0.21089e-02,0.21498e-02,0.13833e-02 /)
      kbo(:, 4,29, 5) = (/ &
        & 0.16102e-03,0.17778e-02,0.22703e-02,0.22810e-02,0.14528e-02 /)
      kbo(:, 5,29, 5) = (/ &
        & 0.18981e-03,0.19484e-02,0.24374e-02,0.24249e-02,0.15236e-02 /)
      kbo(:, 1,30, 5) = (/ &
        & 0.80828e-04,0.11471e-02,0.15486e-02,0.16307e-02,0.10482e-02 /)
      kbo(:, 2,30, 5) = (/ &
        & 0.98063e-04,0.12718e-02,0.16797e-02,0.17287e-02,0.11053e-02 /)
      kbo(:, 3,30, 5) = (/ &
        & 0.11772e-03,0.14050e-02,0.18177e-02,0.18379e-02,0.11648e-02 /)
      kbo(:, 4,30, 5) = (/ &
        & 0.13981e-03,0.15469e-02,0.19589e-02,0.19565e-02,0.12258e-02 /)
      kbo(:, 5,30, 5) = (/ &
        & 0.16446e-03,0.16947e-02,0.21055e-02,0.20874e-02,0.12885e-02 /)
      kbo(:, 1,31, 5) = (/ &
        & 0.70539e-04,0.99621e-03,0.13325e-02,0.13879e-02,0.88220e-03 /)
      kbo(:, 2,31, 5) = (/ &
        & 0.85589e-04,0.11063e-02,0.14492e-02,0.14776e-02,0.93113e-03 /)
      kbo(:, 3,31, 5) = (/ &
        & 0.10244e-03,0.12240e-02,0.15701e-02,0.15764e-02,0.98237e-03 /)
      kbo(:, 4,31, 5) = (/ &
        & 0.12151e-03,0.13488e-02,0.16942e-02,0.16846e-02,0.10364e-02 /)
      kbo(:, 5,31, 5) = (/ &
        & 0.14245e-03,0.14753e-02,0.18229e-02,0.18042e-02,0.10910e-02 /)
      kbo(:, 1,32, 5) = (/ &
        & 0.61598e-04,0.86708e-03,0.11506e-02,0.11857e-02,0.74396e-03 /)
      kbo(:, 2,32, 5) = (/ &
        & 0.74698e-04,0.96443e-03,0.12533e-02,0.12673e-02,0.78590e-03 /)
      kbo(:, 3,32, 5) = (/ &
        & 0.89092e-04,0.10684e-02,0.13590e-02,0.13571e-02,0.83090e-03 /)
      kbo(:, 4,32, 5) = (/ &
        & 0.10537e-03,0.11766e-02,0.14682e-02,0.14560e-02,0.87827e-03 /)
      kbo(:, 5,32, 5) = (/ &
        & 0.12327e-03,0.12850e-02,0.15813e-02,0.15643e-02,0.92599e-03 /)
      kbo(:, 1,33, 5) = (/ &
        & 0.53748e-04,0.75629e-03,0.99595e-03,0.10163e-02,0.62809e-03 /)
      kbo(:, 2,33, 5) = (/ &
        & 0.64972e-04,0.84265e-03,0.10856e-02,0.10908e-02,0.66416e-03 /)
      kbo(:, 3,33, 5) = (/ &
        & 0.77386e-04,0.93397e-03,0.11787e-02,0.11727e-02,0.70387e-03 /)
      kbo(:, 4,33, 5) = (/ &
        & 0.91138e-04,0.10266e-02,0.12749e-02,0.12630e-02,0.74507e-03 /)
      kbo(:, 5,33, 5) = (/ &
        & 0.10640e-03,0.11189e-02,0.13738e-02,0.13608e-02,0.78830e-03 /)
      kbo(:, 1,34, 5) = (/ &
        & 0.46667e-04,0.65884e-03,0.86049e-03,0.87214e-03,0.53099e-03 /)
      kbo(:, 2,34, 5) = (/ &
        & 0.56263e-04,0.73490e-03,0.93900e-03,0.93946e-03,0.56278e-03 /)
      kbo(:, 3,34, 5) = (/ &
        & 0.66853e-04,0.81383e-03,0.10209e-02,0.10142e-02,0.59776e-03 /)
      kbo(:, 4,34, 5) = (/ &
        & 0.78598e-04,0.89314e-03,0.11054e-02,0.10963e-02,0.63419e-03 /)
      kbo(:, 5,34, 5) = (/ &
        & 0.91503e-04,0.97193e-03,0.11927e-02,0.11840e-02,0.67320e-03 /)
      kbo(:, 1,35, 5) = (/ &
        & 0.39599e-04,0.56866e-03,0.73803e-03,0.74491e-03,0.44688e-03 /)
      kbo(:, 2,35, 5) = (/ &
        & 0.47677e-04,0.63490e-03,0.80685e-03,0.80540e-03,0.47466e-03 /)
      kbo(:, 3,35, 5) = (/ &
        & 0.56630e-04,0.70279e-03,0.87860e-03,0.87332e-03,0.50476e-03 /)
      kbo(:, 4,35, 5) = (/ &
        & 0.66506e-04,0.77061e-03,0.95262e-03,0.94676e-03,0.53730e-03 /)
      kbo(:, 5,35, 5) = (/ &
        & 0.77343e-04,0.83870e-03,0.10295e-02,0.10250e-02,0.57200e-03 /)
      kbo(:, 1,36, 5) = (/ &
        & 0.32767e-04,0.48523e-03,0.62751e-03,0.63183e-03,0.37353e-03 /)
      kbo(:, 2,36, 5) = (/ &
        & 0.39450e-04,0.54261e-03,0.68744e-03,0.68587e-03,0.39744e-03 /)
      kbo(:, 3,36, 5) = (/ &
        & 0.46861e-04,0.60093e-03,0.74977e-03,0.74623e-03,0.42315e-03 /)
      kbo(:, 4,36, 5) = (/ &
        & 0.54956e-04,0.65916e-03,0.81469e-03,0.81158e-03,0.45144e-03 /)
      kbo(:, 5,36, 5) = (/ &
        & 0.63908e-04,0.71820e-03,0.88212e-03,0.88103e-03,0.48165e-03 /)
      kbo(:, 1,37, 5) = (/ &
        & 0.26734e-04,0.40754e-03,0.52645e-03,0.53014e-03,0.31118e-03 /)
      kbo(:, 2,37, 5) = (/ &
        & 0.32273e-04,0.45661e-03,0.57825e-03,0.57766e-03,0.33206e-03 /)
      kbo(:, 3,37, 5) = (/ &
        & 0.38488e-04,0.50697e-03,0.63245e-03,0.63058e-03,0.35476e-03 /)
      kbo(:, 4,37, 5) = (/ &
        & 0.45228e-04,0.55706e-03,0.68918e-03,0.68809e-03,0.37944e-03 /)
      kbo(:, 5,37, 5) = (/ &
        & 0.52675e-04,0.60808e-03,0.74794e-03,0.74934e-03,0.40598e-03 /)
      kbo(:, 1,38, 5) = (/ &
        & 0.21751e-04,0.34209e-03,0.44146e-03,0.44458e-03,0.25920e-03 /)
      kbo(:, 2,38, 5) = (/ &
        & 0.26326e-04,0.38415e-03,0.48603e-03,0.48632e-03,0.27730e-03 /)
      kbo(:, 3,38, 5) = (/ &
        & 0.31515e-04,0.42736e-03,0.53325e-03,0.53262e-03,0.29714e-03 /)
      kbo(:, 4,38, 5) = (/ &
        & 0.37219e-04,0.47064e-03,0.58263e-03,0.58321e-03,0.31890e-03 /)
      kbo(:, 5,38, 5) = (/ &
        & 0.43344e-04,0.51493e-03,0.63402e-03,0.63729e-03,0.34212e-03 /)
      kbo(:, 1,39, 5) = (/ &
        & 0.17643e-04,0.28717e-03,0.37020e-03,0.37288e-03,0.21580e-03 /)
      kbo(:, 2,39, 5) = (/ &
        & 0.21418e-04,0.32343e-03,0.40871e-03,0.40953e-03,0.23151e-03 /)
      kbo(:, 3,39, 5) = (/ &
        & 0.25725e-04,0.36044e-03,0.44966e-03,0.45005e-03,0.24880e-03 /)
      kbo(:, 4,39, 5) = (/ &
        & 0.30479e-04,0.39785e-03,0.49263e-03,0.49445e-03,0.26783e-03 /)
      kbo(:, 5,39, 5) = (/ &
        & 0.35653e-04,0.43646e-03,0.53771e-03,0.54230e-03,0.28822e-03 /)
      kbo(:, 1,40, 5) = (/ &
        & 0.14102e-04,0.23814e-03,0.30730e-03,0.30981e-03,0.17864e-03 /)
      kbo(:, 2,40, 5) = (/ &
        & 0.17187e-04,0.26934e-03,0.34039e-03,0.34146e-03,0.19234e-03 /)
      kbo(:, 3,40, 5) = (/ &
        & 0.20739e-04,0.30130e-03,0.37571e-03,0.37672e-03,0.20737e-03 /)
      kbo(:, 4,40, 5) = (/ &
        & 0.24670e-04,0.33333e-03,0.41283e-03,0.41538e-03,0.22408e-03 /)
      kbo(:, 5,40, 5) = (/ &
        & 0.29046e-04,0.36694e-03,0.45216e-03,0.45729e-03,0.24187e-03 /)
      kbo(:, 1,41, 5) = (/ &
        & 0.11221e-04,0.19710e-03,0.25465e-03,0.25696e-03,0.14773e-03 /)
      kbo(:, 2,41, 5) = (/ &
        & 0.13747e-04,0.22390e-03,0.28305e-03,0.28413e-03,0.15955e-03 /)
      kbo(:, 3,41, 5) = (/ &
        & 0.16649e-04,0.25145e-03,0.31346e-03,0.31467e-03,0.17269e-03 /)
      kbo(:, 4,41, 5) = (/ &
        & 0.19899e-04,0.27935e-03,0.34563e-03,0.34845e-03,0.18718e-03 /)
      kbo(:, 5,41, 5) = (/ &
        & 0.23568e-04,0.30830e-03,0.37974e-03,0.38512e-03,0.20281e-03 /)
      kbo(:, 1,42, 5) = (/ &
        & 0.89147e-05,0.16314e-03,0.21088e-03,0.21294e-03,0.12205e-03 /)
      kbo(:, 2,42, 5) = (/ &
        & 0.10957e-04,0.18596e-03,0.23523e-03,0.23628e-03,0.13225e-03 /)
      kbo(:, 3,42, 5) = (/ &
        & 0.13327e-04,0.20974e-03,0.26134e-03,0.26263e-03,0.14356e-03 /)
      kbo(:, 4,42, 5) = (/ &
        & 0.16005e-04,0.23378e-03,0.28925e-03,0.29202e-03,0.15621e-03 /)
      kbo(:, 5,42, 5) = (/ &
        & 0.19038e-04,0.25914e-03,0.31897e-03,0.32415e-03,0.16982e-03 /)
      kbo(:, 1,43, 5) = (/ &
        & 0.69995e-05,0.13405e-03,0.17338e-03,0.17535e-03,0.10036e-03 /)
      kbo(:, 2,43, 5) = (/ &
        & 0.86406e-05,0.15345e-03,0.19416e-03,0.19514e-03,0.10910e-03 /)
      kbo(:, 3,43, 5) = (/ &
        & 0.10556e-04,0.17373e-03,0.21659e-03,0.21767e-03,0.11887e-03 /)
      kbo(:, 4,43, 5) = (/ &
        & 0.12739e-04,0.19445e-03,0.24053e-03,0.24311e-03,0.12980e-03 /)
      kbo(:, 5,43, 5) = (/ &
        & 0.15232e-04,0.21640e-03,0.26645e-03,0.27107e-03,0.14169e-03 /)
      kbo(:, 1,44, 5) = (/ &
        & 0.54712e-05,0.10970e-03,0.14195e-03,0.14386e-03,0.82260e-04 /)
      kbo(:, 2,44, 5) = (/ &
        & 0.67644e-05,0.12612e-03,0.15963e-03,0.16061e-03,0.89727e-04 /)
      kbo(:, 3,44, 5) = (/ &
        & 0.82973e-05,0.14348e-03,0.17878e-03,0.17975e-03,0.98122e-04 /)
      kbo(:, 4,44, 5) = (/ &
        & 0.10082e-04,0.16132e-03,0.19952e-03,0.20155e-03,0.10755e-03 /)
      kbo(:, 5,44, 5) = (/ &
        & 0.12107e-04,0.18008e-03,0.22179e-03,0.22576e-03,0.11787e-03 /)
      kbo(:, 1,45, 5) = (/ &
        & 0.42767e-05,0.89680e-04,0.11611e-03,0.11781e-03,0.67338e-04 /)
      kbo(:, 2,45, 5) = (/ &
        & 0.52860e-05,0.10360e-03,0.13107e-03,0.13203e-03,0.73722e-04 /)
      kbo(:, 3,45, 5) = (/ &
        & 0.65107e-05,0.11838e-03,0.14735e-03,0.14829e-03,0.80852e-04 /)
      kbo(:, 4,45, 5) = (/ &
        & 0.79501e-05,0.13374e-03,0.16520e-03,0.16693e-03,0.88969e-04 /)
      kbo(:, 5,45, 5) = (/ &
        & 0.95937e-05,0.14993e-03,0.18456e-03,0.18781e-03,0.97897e-04 /)
      kbo(:, 1,46, 5) = (/ &
        & 0.33226e-05,0.72918e-04,0.94635e-04,0.96069e-04,0.54912e-04 /)
      kbo(:, 2,46, 5) = (/ &
        & 0.41185e-05,0.84705e-04,0.10726e-03,0.10809e-03,0.60325e-04 /)
      kbo(:, 3,46, 5) = (/ &
        & 0.50796e-05,0.97414e-04,0.12106e-03,0.12184e-03,0.66415e-04 /)
      kbo(:, 4,46, 5) = (/ &
        & 0.62311e-05,0.11055e-03,0.13625e-03,0.13772e-03,0.73354e-04 /)
      kbo(:, 5,46, 5) = (/ &
        & 0.75594e-05,0.12439e-03,0.15297e-03,0.15569e-03,0.80972e-04 /)
      kbo(:, 1,47, 5) = (/ &
        & 0.25507e-05,0.58753e-04,0.76599e-04,0.77798e-04,0.44508e-04 /)
      kbo(:, 2,47, 5) = (/ &
        & 0.31800e-05,0.68679e-04,0.87240e-04,0.87843e-04,0.49115e-04 /)
      kbo(:, 3,47, 5) = (/ &
        & 0.39273e-05,0.79497e-04,0.98871e-04,0.99421e-04,0.54249e-04 /)
      kbo(:, 4,47, 5) = (/ &
        & 0.48346e-05,0.90782e-04,0.11173e-03,0.11282e-03,0.60113e-04 /)
      kbo(:, 5,47, 5) = (/ &
        & 0.58995e-05,0.10267e-03,0.12592e-03,0.12815e-03,0.66656e-04 /)
      kbo(:, 1,48, 5) = (/ &
        & 0.19539e-05,0.47174e-04,0.61874e-04,0.62916e-04,0.35973e-04 /)
      kbo(:, 2,48, 5) = (/ &
        & 0.24452e-05,0.55575e-04,0.70853e-04,0.71238e-04,0.39898e-04 /)
      kbo(:, 3,48, 5) = (/ &
        & 0.30402e-05,0.64783e-04,0.80633e-04,0.80921e-04,0.44214e-04 /)
      kbo(:, 4,48, 5) = (/ &
        & 0.37390e-05,0.74439e-04,0.91498e-04,0.92208e-04,0.49162e-04 /)
      kbo(:, 5,48, 5) = (/ &
        & 0.45836e-05,0.84608e-04,0.10358e-03,0.10531e-03,0.54702e-04 /)
      kbo(:, 1,49, 5) = (/ &
        & 0.14940e-05,0.37716e-04,0.49829e-04,0.50804e-04,0.28987e-04 /)
      kbo(:, 2,49, 5) = (/ &
        & 0.18758e-05,0.44777e-04,0.57392e-04,0.57697e-04,0.32317e-04 /)
      kbo(:, 3,49, 5) = (/ &
        & 0.23413e-05,0.52604e-04,0.65608e-04,0.65748e-04,0.35946e-04 /)
      kbo(:, 4,49, 5) = (/ &
        & 0.28961e-05,0.60891e-04,0.74824e-04,0.75182e-04,0.40099e-04 /)
      kbo(:, 5,49, 5) = (/ &
        & 0.35524e-05,0.69587e-04,0.85068e-04,0.86295e-04,0.44804e-04 /)
      kbo(:, 1,50, 5) = (/ &
        & 0.11500e-05,0.30169e-04,0.40157e-04,0.41069e-04,0.23362e-04 /)
      kbo(:, 2,50, 5) = (/ &
        & 0.14453e-05,0.36089e-04,0.46549e-04,0.46799e-04,0.26193e-04 /)
      kbo(:, 3,50, 5) = (/ &
        & 0.18129e-05,0.42735e-04,0.53474e-04,0.53514e-04,0.29249e-04 /)
      kbo(:, 4,50, 5) = (/ &
        & 0.22529e-05,0.49843e-04,0.61234e-04,0.61404e-04,0.32748e-04 /)
      kbo(:, 5,50, 5) = (/ &
        & 0.27762e-05,0.57328e-04,0.70027e-04,0.70783e-04,0.36712e-04 /)
      kbo(:, 1,51, 5) = (/ &
        & 0.88851e-06,0.24095e-04,0.32303e-04,0.33210e-04,0.18805e-04 /)
      kbo(:, 2,51, 5) = (/ &
        & 0.11177e-05,0.29082e-04,0.37705e-04,0.37944e-04,0.21209e-04 /)
      kbo(:, 3,51, 5) = (/ &
        & 0.14060e-05,0.34667e-04,0.43578e-04,0.43570e-04,0.23792e-04 /)
      kbo(:, 4,51, 5) = (/ &
        & 0.17539e-05,0.40739e-04,0.50114e-04,0.50172e-04,0.26720e-04 /)
      kbo(:, 5,51, 5) = (/ &
        & 0.21729e-05,0.47224e-04,0.57598e-04,0.58070e-04,0.30079e-04 /)
      kbo(:, 1,52, 5) = (/ &
        & 0.68525e-06,0.19178e-04,0.25896e-04,0.26809e-04,0.15097e-04 /)
      kbo(:, 2,52, 5) = (/ &
        & 0.86301e-06,0.23336e-04,0.30434e-04,0.30713e-04,0.17120e-04 /)
      kbo(:, 3,52, 5) = (/ &
        & 0.10889e-05,0.28028e-04,0.35422e-04,0.35397e-04,0.19301e-04 /)
      kbo(:, 4,52, 5) = (/ &
        & 0.13649e-05,0.33187e-04,0.40954e-04,0.40921e-04,0.21752e-04 /)
      kbo(:, 5,52, 5) = (/ &
        & 0.16982e-05,0.38747e-04,0.47260e-04,0.47557e-04,0.24588e-04 /)
      kbo(:, 1,53, 5) = (/ &
        & 0.52809e-06,0.15206e-04,0.20688e-04,0.21592e-04,0.12084e-04 /)
      kbo(:, 2,53, 5) = (/ &
        & 0.66493e-06,0.18647e-04,0.24479e-04,0.24819e-04,0.13781e-04 /)
      kbo(:, 3,53, 5) = (/ &
        & 0.84102e-06,0.22574e-04,0.28683e-04,0.28690e-04,0.15621e-04 /)
      kbo(:, 4,53, 5) = (/ &
        & 0.10585e-05,0.26955e-04,0.33364e-04,0.33298e-04,0.17677e-04 /)
      kbo(:, 5,53, 5) = (/ &
        & 0.13239e-05,0.31710e-04,0.38733e-04,0.38864e-04,0.20049e-04 /)
      kbo(:, 1,54, 5) = (/ &
        & 0.40969e-06,0.12093e-04,0.16564e-04,0.17421e-04,0.96882e-05 /)
      kbo(:, 2,54, 5) = (/ &
        & 0.51569e-06,0.14937e-04,0.19734e-04,0.20094e-04,0.11112e-04 /)
      kbo(:, 3,54, 5) = (/ &
        & 0.65296e-06,0.18229e-04,0.23282e-04,0.23321e-04,0.12664e-04 /)
      kbo(:, 4,54, 5) = (/ &
        & 0.82573e-06,0.21950e-04,0.27231e-04,0.27150e-04,0.14393e-04 /)
      kbo(:, 5,54, 5) = (/ &
        & 0.10373e-05,0.26013e-04,0.31791e-04,0.31828e-04,0.16379e-04 /)
      kbo(:, 1,55, 5) = (/ &
        & 0.31928e-06,0.96162e-05,0.13257e-04,0.14053e-04,0.77741e-05 /)
      kbo(:, 2,55, 5) = (/ &
        & 0.40112e-06,0.11963e-04,0.15906e-04,0.16257e-04,0.89578e-05 /)
      kbo(:, 3,55, 5) = (/ &
        & 0.50816e-06,0.14717e-04,0.18886e-04,0.18947e-04,0.10262e-04 /)
      kbo(:, 4,55, 5) = (/ &
        & 0.64465e-06,0.17864e-04,0.22207e-04,0.22155e-04,0.11715e-04 /)
      kbo(:, 5,55, 5) = (/ &
        & 0.81328e-06,0.21326e-04,0.26076e-04,0.26061e-04,0.13376e-04 /)
      kbo(:, 1,56, 5) = (/ &
        & 0.24829e-06,0.76204e-05,0.10578e-04,0.11309e-04,0.62208e-05 /)
      kbo(:, 2,56, 5) = (/ &
        & 0.31176e-06,0.95488e-05,0.12780e-04,0.13125e-04,0.72013e-05 /)
      kbo(:, 3,56, 5) = (/ &
        & 0.39506e-06,0.11850e-04,0.15279e-04,0.15348e-04,0.82947e-05 /)
      kbo(:, 4,56, 5) = (/ &
        & 0.50266e-06,0.14492e-04,0.18074e-04,0.18040e-04,0.95153e-05 /)
      kbo(:, 5,56, 5) = (/ &
        & 0.63638e-06,0.17442e-04,0.21336e-04,0.21310e-04,0.10904e-04 /)
      kbo(:, 1,57, 5) = (/ &
        & 0.19302e-06,0.60187e-05,0.84162e-05,0.90799e-05,0.49649e-05 /)
      kbo(:, 2,57, 5) = (/ &
        & 0.24222e-06,0.75959e-05,0.10233e-04,0.10570e-04,0.57701e-05 /)
      kbo(:, 3,57, 5) = (/ &
        & 0.30688e-06,0.95080e-05,0.12318e-04,0.12403e-04,0.66913e-05 /)
      kbo(:, 4,57, 5) = (/ &
        & 0.39089e-06,0.11719e-04,0.14670e-04,0.14644e-04,0.77166e-05 /)
      kbo(:, 5,57, 5) = (/ &
        & 0.49674e-06,0.14214e-04,0.17402e-04,0.17382e-04,0.88727e-05 /)
      kbo(:, 1,58, 5) = (/ &
        & 0.15046e-06,0.47663e-05,0.66998e-05,0.72908e-05,0.39631e-05 /)
      kbo(:, 2,58, 5) = (/ &
        & 0.18856e-06,0.60459e-05,0.81908e-05,0.85206e-05,0.46270e-05 /)
      kbo(:, 3,58, 5) = (/ &
        & 0.23869e-06,0.76302e-05,0.99245e-05,0.10023e-04,0.53977e-05 /)
      kbo(:, 4,58, 5) = (/ &
        & 0.30459e-06,0.94767e-05,0.11911e-04,0.11894e-04,0.62579e-05 /)
      kbo(:, 5,58, 5) = (/ &
        & 0.38820e-06,0.11588e-04,0.14205e-04,0.14182e-04,0.72226e-05 /)
      kbo(:, 1,59, 5) = (/ &
        & 0.12212e-06,0.39332e-05,0.55230e-05,0.60094e-05,0.32499e-05 /)
      kbo(:, 2,59, 5) = (/ &
        & 0.15324e-06,0.50178e-05,0.67879e-05,0.70566e-05,0.38108e-05 /)
      kbo(:, 3,59, 5) = (/ &
        & 0.19418e-06,0.63678e-05,0.82647e-05,0.83443e-05,0.44672e-05 /)
      kbo(:, 4,59, 5) = (/ &
        & 0.24820e-06,0.79543e-05,0.99670e-05,0.99518e-05,0.52027e-05 /)
      kbo(:, 5,59, 5) = (/ &
        & 0.31740e-06,0.97704e-05,0.11964e-04,0.11938e-04,0.60278e-05 /)
      kbo(:, 1,13, 6) = (/ &
        & 0.10896e-01,0.63076e-01,0.78831e-01,0.78091e-01,0.55428e-01 /)
      kbo(:, 2,13, 6) = (/ &
        & 0.13036e-01,0.66370e-01,0.81226e-01,0.79692e-01,0.56778e-01 /)
      kbo(:, 3,13, 6) = (/ &
        & 0.15498e-01,0.69685e-01,0.83483e-01,0.81400e-01,0.57975e-01 /)
      kbo(:, 4,13, 6) = (/ &
        & 0.18239e-01,0.73147e-01,0.85845e-01,0.83249e-01,0.59127e-01 /)
      kbo(:, 5,13, 6) = (/ &
        & 0.21232e-01,0.76581e-01,0.88266e-01,0.85245e-01,0.60192e-01 /)
      kbo(:, 1,14, 6) = (/ &
        & 0.94274e-02,0.53526e-01,0.66496e-01,0.65527e-01,0.46374e-01 /)
      kbo(:, 2,14, 6) = (/ &
        & 0.11284e-01,0.56390e-01,0.68527e-01,0.66955e-01,0.47524e-01 /)
      kbo(:, 3,14, 6) = (/ &
        & 0.13394e-01,0.59305e-01,0.70546e-01,0.68479e-01,0.48560e-01 /)
      kbo(:, 4,14, 6) = (/ &
        & 0.15751e-01,0.62293e-01,0.72634e-01,0.70165e-01,0.49587e-01 /)
      kbo(:, 5,14, 6) = (/ &
        & 0.18326e-01,0.65240e-01,0.74773e-01,0.71967e-01,0.50492e-01 /)
      kbo(:, 1,15, 6) = (/ &
        & 0.81352e-02,0.45294e-01,0.55939e-01,0.54933e-01,0.38471e-01 /)
      kbo(:, 2,15, 6) = (/ &
        & 0.97406e-02,0.47797e-01,0.57705e-01,0.56201e-01,0.39475e-01 /)
      kbo(:, 3,15, 6) = (/ &
        & 0.11542e-01,0.50349e-01,0.59500e-01,0.57588e-01,0.40391e-01 /)
      kbo(:, 4,15, 6) = (/ &
        & 0.13568e-01,0.52924e-01,0.61342e-01,0.59116e-01,0.41250e-01 /)
      kbo(:, 5,15, 6) = (/ &
        & 0.15789e-01,0.55427e-01,0.63250e-01,0.60727e-01,0.42016e-01 /)
      kbo(:, 1,16, 6) = (/ &
        & 0.70159e-02,0.38272e-01,0.46984e-01,0.46002e-01,0.31818e-01 /)
      kbo(:, 2,16, 6) = (/ &
        & 0.83846e-02,0.40476e-01,0.48519e-01,0.47148e-01,0.32640e-01 /)
      kbo(:, 3,16, 6) = (/ &
        & 0.99392e-02,0.42699e-01,0.50118e-01,0.48421e-01,0.33435e-01 /)
      kbo(:, 4,16, 6) = (/ &
        & 0.11675e-01,0.44875e-01,0.51760e-01,0.49780e-01,0.34161e-01 /)
      kbo(:, 5,16, 6) = (/ &
        & 0.13584e-01,0.46992e-01,0.53405e-01,0.51224e-01,0.34855e-01 /)
      kbo(:, 1,17, 6) = (/ &
        & 0.60402e-02,0.32343e-01,0.39419e-01,0.38482e-01,0.26323e-01 /)
      kbo(:, 2,17, 6) = (/ &
        & 0.72134e-02,0.34265e-01,0.40783e-01,0.39523e-01,0.27045e-01 /)
      kbo(:, 3,17, 6) = (/ &
        & 0.85415e-02,0.36157e-01,0.42200e-01,0.40657e-01,0.27733e-01 /)
      kbo(:, 4,17, 6) = (/ &
        & 0.10023e-01,0.37979e-01,0.43620e-01,0.41877e-01,0.28354e-01 /)
      kbo(:, 5,17, 6) = (/ &
        & 0.11662e-01,0.39775e-01,0.45034e-01,0.43161e-01,0.28989e-01 /)
      kbo(:, 1,18, 6) = (/ &
        & 0.51905e-02,0.27334e-01,0.33081e-01,0.32183e-01,0.21845e-01 /)
      kbo(:, 2,18, 6) = (/ &
        & 0.61907e-02,0.28996e-01,0.34295e-01,0.33127e-01,0.22456e-01 /)
      kbo(:, 3,18, 6) = (/ &
        & 0.73283e-02,0.30572e-01,0.35522e-01,0.34131e-01,0.23047e-01 /)
      kbo(:, 4,18, 6) = (/ &
        & 0.85960e-02,0.32113e-01,0.36725e-01,0.35202e-01,0.23589e-01 /)
      kbo(:, 5,18, 6) = (/ &
        & 0.10011e-01,0.33654e-01,0.37950e-01,0.36339e-01,0.24154e-01 /)
      kbo(:, 1,19, 6) = (/ &
        & 0.44474e-02,0.23093e-01,0.27758e-01,0.26913e-01,0.18159e-01 /)
      kbo(:, 2,19, 6) = (/ &
        & 0.53019e-02,0.24497e-01,0.28826e-01,0.27764e-01,0.18694e-01 /)
      kbo(:, 3,19, 6) = (/ &
        & 0.62735e-02,0.25825e-01,0.29864e-01,0.28669e-01,0.19187e-01 /)
      kbo(:, 4,19, 6) = (/ &
        & 0.73683e-02,0.27139e-01,0.30890e-01,0.29627e-01,0.19650e-01 /)
      kbo(:, 5,19, 6) = (/ &
        & 0.85933e-02,0.28467e-01,0.31975e-01,0.30634e-01,0.20138e-01 /)
      kbo(:, 1,20, 6) = (/ &
        & 0.38215e-02,0.19522e-01,0.23307e-01,0.22532e-01,0.15180e-01 /)
      kbo(:, 2,20, 6) = (/ &
        & 0.45489e-02,0.20697e-01,0.24217e-01,0.23292e-01,0.15626e-01 /)
      kbo(:, 3,20, 6) = (/ &
        & 0.53838e-02,0.21827e-01,0.25099e-01,0.24107e-01,0.16039e-01 /)
      kbo(:, 4,20, 6) = (/ &
        & 0.63294e-02,0.22947e-01,0.25996e-01,0.24951e-01,0.16431e-01 /)
      kbo(:, 5,20, 6) = (/ &
        & 0.73910e-02,0.24098e-01,0.26969e-01,0.25840e-01,0.16861e-01 /)
      kbo(:, 1,21, 6) = (/ &
        & 0.32849e-02,0.16485e-01,0.19564e-01,0.18873e-01,0.12724e-01 /)
      kbo(:, 2,21, 6) = (/ &
        & 0.39093e-02,0.17476e-01,0.20333e-01,0.19553e-01,0.13080e-01 /)
      kbo(:, 3,21, 6) = (/ &
        & 0.46257e-02,0.18440e-01,0.21099e-01,0.20272e-01,0.13424e-01 /)
      kbo(:, 4,21, 6) = (/ &
        & 0.54436e-02,0.19400e-01,0.21897e-01,0.21018e-01,0.13774e-01 /)
      kbo(:, 5,21, 6) = (/ &
        & 0.63568e-02,0.20406e-01,0.22777e-01,0.21806e-01,0.14153e-01 /)
      kbo(:, 1,22, 6) = (/ &
        & 0.28524e-02,0.13970e-01,0.16464e-01,0.15855e-01,0.10647e-01 /)
      kbo(:, 2,22, 6) = (/ &
        & 0.33998e-02,0.14799e-01,0.17121e-01,0.16464e-01,0.10957e-01 /)
      kbo(:, 3,22, 6) = (/ &
        & 0.40218e-02,0.15618e-01,0.17789e-01,0.17098e-01,0.11264e-01 /)
      kbo(:, 4,22, 6) = (/ &
        & 0.47350e-02,0.16459e-01,0.18512e-01,0.17761e-01,0.11585e-01 /)
      kbo(:, 5,22, 6) = (/ &
        & 0.55269e-02,0.17342e-01,0.19306e-01,0.18466e-01,0.11905e-01 /)
      kbo(:, 1,23, 6) = (/ &
        & 0.24776e-02,0.11832e-01,0.13862e-01,0.13338e-01,0.89101e-02 /)
      kbo(:, 2,23, 6) = (/ &
        & 0.29594e-02,0.12532e-01,0.14430e-01,0.13874e-01,0.91836e-02 /)
      kbo(:, 3,23, 6) = (/ &
        & 0.35060e-02,0.13237e-01,0.15025e-01,0.14435e-01,0.94582e-02 /)
      kbo(:, 4,23, 6) = (/ &
        & 0.41276e-02,0.13976e-01,0.15673e-01,0.15028e-01,0.97462e-02 /)
      kbo(:, 5,23, 6) = (/ &
        & 0.48108e-02,0.14761e-01,0.16387e-01,0.15666e-01,0.10041e-01 /)
      kbo(:, 1,24, 6) = (/ &
        & 0.21553e-02,0.10022e-01,0.11681e-01,0.11233e-01,0.74484e-02 /)
      kbo(:, 2,24, 6) = (/ &
        & 0.25764e-02,0.10621e-01,0.12176e-01,0.11709e-01,0.76914e-02 /)
      kbo(:, 3,24, 6) = (/ &
        & 0.30587e-02,0.11236e-01,0.12711e-01,0.12208e-01,0.79451e-02 /)
      kbo(:, 4,24, 6) = (/ &
        & 0.36022e-02,0.11891e-01,0.13293e-01,0.12744e-01,0.82033e-02 /)
      kbo(:, 5,24, 6) = (/ &
        & 0.41914e-02,0.12593e-01,0.13939e-01,0.13324e-01,0.84674e-02 /)
      kbo(:, 1,25, 6) = (/ &
        & 0.18796e-02,0.85000e-02,0.98543e-02,0.94788e-02,0.62281e-02 /)
      kbo(:, 2,25, 6) = (/ &
        & 0.22512e-02,0.90173e-02,0.10293e-01,0.99015e-02,0.64465e-02 /)
      kbo(:, 3,25, 6) = (/ &
        & 0.26761e-02,0.95606e-02,0.10772e-01,0.10351e-01,0.66771e-02 /)
      kbo(:, 4,25, 6) = (/ &
        & 0.31512e-02,0.10144e-01,0.11303e-01,0.10838e-01,0.69100e-02 /)
      kbo(:, 5,25, 6) = (/ &
        & 0.36575e-02,0.10772e-01,0.11893e-01,0.11363e-01,0.71526e-02 /)
      kbo(:, 1,26, 6) = (/ &
        & 0.16486e-02,0.72263e-02,0.83293e-02,0.80207e-02,0.52267e-02 /)
      kbo(:, 2,26, 6) = (/ &
        & 0.19790e-02,0.76783e-02,0.87239e-02,0.83966e-02,0.54266e-02 /)
      kbo(:, 3,26, 6) = (/ &
        & 0.23552e-02,0.81632e-02,0.91606e-02,0.88030e-02,0.56340e-02 /)
      kbo(:, 4,26, 6) = (/ &
        & 0.27655e-02,0.86841e-02,0.96465e-02,0.92463e-02,0.58421e-02 /)
      kbo(:, 5,26, 6) = (/ &
        & 0.32014e-02,0.92461e-02,0.10190e-01,0.97263e-02,0.60618e-02 /)
      kbo(:, 1,27, 6) = (/ &
        & 0.14479e-02,0.61551e-02,0.70548e-02,0.67980e-02,0.43916e-02 /)
      kbo(:, 2,27, 6) = (/ &
        & 0.17422e-02,0.65560e-02,0.74109e-02,0.71369e-02,0.45703e-02 /)
      kbo(:, 3,27, 6) = (/ &
        & 0.20711e-02,0.69878e-02,0.78116e-02,0.75081e-02,0.47565e-02 /)
      kbo(:, 4,27, 6) = (/ &
        & 0.24273e-02,0.74543e-02,0.82596e-02,0.79125e-02,0.49414e-02 /)
      kbo(:, 5,27, 6) = (/ &
        & 0.28006e-02,0.79622e-02,0.87633e-02,0.83523e-02,0.51438e-02 /)
      kbo(:, 1,28, 6) = (/ &
        & 0.12757e-02,0.52552e-02,0.59880e-02,0.57731e-02,0.36940e-02 /)
      kbo(:, 2,28, 6) = (/ &
        & 0.15355e-02,0.56117e-02,0.63148e-02,0.60828e-02,0.38537e-02 /)
      kbo(:, 3,28, 6) = (/ &
        & 0.18209e-02,0.60000e-02,0.66831e-02,0.64236e-02,0.40153e-02 /)
      kbo(:, 4,28, 6) = (/ &
        & 0.21272e-02,0.64202e-02,0.70979e-02,0.67923e-02,0.41811e-02 /)
      kbo(:, 5,28, 6) = (/ &
        & 0.24474e-02,0.68778e-02,0.75643e-02,0.71983e-02,0.43640e-02 /)
      kbo(:, 1,29, 6) = (/ &
        & 0.11295e-02,0.45004e-02,0.50997e-02,0.49184e-02,0.31153e-02 /)
      kbo(:, 2,29, 6) = (/ &
        & 0.13559e-02,0.48180e-02,0.54010e-02,0.52034e-02,0.32572e-02 /)
      kbo(:, 3,29, 6) = (/ &
        & 0.16033e-02,0.51685e-02,0.57423e-02,0.55151e-02,0.33997e-02 /)
      kbo(:, 4,29, 6) = (/ &
        & 0.18647e-02,0.55488e-02,0.61280e-02,0.58545e-02,0.35531e-02 /)
      kbo(:, 5,29, 6) = (/ &
        & 0.21368e-02,0.59683e-02,0.65578e-02,0.62309e-02,0.37192e-02 /)
      kbo(:, 1,30, 6) = (/ &
        & 0.10010e-02,0.38621e-02,0.43580e-02,0.42036e-02,0.26325e-02 /)
      kbo(:, 2,30, 6) = (/ &
        & 0.11967e-02,0.41511e-02,0.46366e-02,0.44656e-02,0.27570e-02 /)
      kbo(:, 3,30, 6) = (/ &
        & 0.14096e-02,0.44678e-02,0.49534e-02,0.47515e-02,0.28856e-02 /)
      kbo(:, 4,30, 6) = (/ &
        & 0.16325e-02,0.48140e-02,0.53117e-02,0.50685e-02,0.30242e-02 /)
      kbo(:, 5,30, 6) = (/ &
        & 0.18599e-02,0.52016e-02,0.57103e-02,0.54169e-02,0.31738e-02 /)
      kbo(:, 1,31, 6) = (/ &
        & 0.88685e-03,0.33266e-02,0.37394e-02,0.36064e-02,0.22280e-02 /)
      kbo(:, 2,31, 6) = (/ &
        & 0.10569e-02,0.35897e-02,0.39964e-02,0.38465e-02,0.23389e-02 /)
      kbo(:, 3,31, 6) = (/ &
        & 0.12382e-02,0.38779e-02,0.42920e-02,0.41135e-02,0.24573e-02 /)
      kbo(:, 4,31, 6) = (/ &
        & 0.14278e-02,0.41961e-02,0.46258e-02,0.44080e-02,0.25818e-02 /)
      kbo(:, 5,31, 6) = (/ &
        & 0.16136e-02,0.45547e-02,0.50001e-02,0.47313e-02,0.27214e-02 /)
      kbo(:, 1,32, 6) = (/ &
        & 0.78559e-03,0.28763e-02,0.32195e-02,0.31059e-02,0.18911e-02 /)
      kbo(:, 2,32, 6) = (/ &
        & 0.93178e-03,0.31157e-02,0.34609e-02,0.33287e-02,0.19930e-02 /)
      kbo(:, 3,32, 6) = (/ &
        & 0.10867e-02,0.33798e-02,0.37377e-02,0.35772e-02,0.21006e-02 /)
      kbo(:, 4,32, 6) = (/ &
        & 0.12446e-02,0.36754e-02,0.40497e-02,0.38517e-02,0.22158e-02 /)
      kbo(:, 5,32, 6) = (/ &
        & 0.13936e-02,0.40072e-02,0.44007e-02,0.41538e-02,0.23413e-02 /)
      kbo(:, 1,33, 6) = (/ &
        & 0.69486e-03,0.24959e-02,0.27846e-02,0.26858e-02,0.16103e-02 /)
      kbo(:, 2,33, 6) = (/ &
        & 0.82037e-03,0.27142e-02,0.30117e-02,0.28933e-02,0.17041e-02 /)
      kbo(:, 3,33, 6) = (/ &
        & 0.95137e-03,0.29589e-02,0.32703e-02,0.31258e-02,0.18033e-02 /)
      kbo(:, 4,33, 6) = (/ &
        & 0.10800e-02,0.32345e-02,0.35641e-02,0.33810e-02,0.19089e-02 /)
      kbo(:, 5,33, 6) = (/ &
        & 0.11986e-02,0.35406e-02,0.38943e-02,0.36682e-02,0.20234e-02 /)
      kbo(:, 1,34, 6) = (/ &
        & 0.61032e-03,0.21671e-02,0.24134e-02,0.23268e-02,0.13754e-02 /)
      kbo(:, 2,34, 6) = (/ &
        & 0.71748e-03,0.23678e-02,0.26264e-02,0.25207e-02,0.14624e-02 /)
      kbo(:, 3,34, 6) = (/ &
        & 0.82600e-03,0.25947e-02,0.28697e-02,0.27368e-02,0.15523e-02 /)
      kbo(:, 4,34, 6) = (/ &
        & 0.92939e-03,0.28495e-02,0.31449e-02,0.29773e-02,0.16488e-02 /)
      kbo(:, 5,34, 6) = (/ &
        & 0.10239e-02,0.31299e-02,0.34552e-02,0.32520e-02,0.17543e-02 /)
      kbo(:, 1,35, 6) = (/ &
        & 0.52678e-03,0.18713e-02,0.20838e-02,0.20082e-02,0.11717e-02 /)
      kbo(:, 2,35, 6) = (/ &
        & 0.61674e-03,0.20541e-02,0.22811e-02,0.21873e-02,0.12500e-02 /)
      kbo(:, 3,35, 6) = (/ &
        & 0.70570e-03,0.22625e-02,0.25066e-02,0.23870e-02,0.13326e-02 /)
      kbo(:, 4,35, 6) = (/ &
        & 0.78855e-03,0.24971e-02,0.27629e-02,0.26134e-02,0.14204e-02 /)
      kbo(:, 5,35, 6) = (/ &
        & 0.86492e-03,0.27499e-02,0.30514e-02,0.28766e-02,0.15154e-02 /)
      kbo(:, 1,36, 6) = (/ &
        & 0.44569e-03,0.16031e-02,0.17868e-02,0.17221e-02,0.99240e-03 /)
      kbo(:, 2,36, 6) = (/ &
        & 0.52055e-03,0.17679e-02,0.19674e-02,0.18854e-02,0.10623e-02 /)
      kbo(:, 3,36, 6) = (/ &
        & 0.59380e-03,0.19567e-02,0.21742e-02,0.20700e-02,0.11368e-02 /)
      kbo(:, 4,36, 6) = (/ &
        & 0.66114e-03,0.21690e-02,0.24093e-02,0.22827e-02,0.12171e-02 /)
      kbo(:, 5,36, 6) = (/ &
        & 0.72347e-03,0.23953e-02,0.26735e-02,0.25294e-02,0.13028e-02 /)
      kbo(:, 1,37, 6) = (/ &
        & 0.36881e-03,0.13558e-02,0.15140e-02,0.14605e-02,0.83527e-03 /)
      kbo(:, 2,37, 6) = (/ &
        & 0.43070e-03,0.15018e-02,0.16759e-02,0.16073e-02,0.89749e-03 /)
      kbo(:, 3,37, 6) = (/ &
        & 0.49122e-03,0.16697e-02,0.18620e-02,0.17747e-02,0.96428e-03 /)
      kbo(:, 4,37, 6) = (/ &
        & 0.54687e-03,0.18590e-02,0.20742e-02,0.19690e-02,0.10365e-02 /)
      kbo(:, 5,37, 6) = (/ &
        & 0.59826e-03,0.20615e-02,0.23143e-02,0.21948e-02,0.11140e-02 /)
      kbo(:, 1,38, 6) = (/ &
        & 0.30472e-03,0.11463e-02,0.12827e-02,0.12387e-02,0.70293e-03 /)
      kbo(:, 2,38, 6) = (/ &
        & 0.35606e-03,0.12755e-02,0.14277e-02,0.13705e-02,0.75844e-03 /)
      kbo(:, 3,38, 6) = (/ &
        & 0.40587e-03,0.14248e-02,0.15948e-02,0.15225e-02,0.81832e-03 /)
      kbo(:, 4,38, 6) = (/ &
        & 0.45170e-03,0.15929e-02,0.17869e-02,0.16996e-02,0.88272e-03 /)
      kbo(:, 5,38, 6) = (/ &
        & 0.49447e-03,0.17743e-02,0.20049e-02,0.19060e-02,0.95296e-03 /)
      kbo(:, 1,39, 6) = (/ &
        & 0.25159e-03,0.96943e-03,0.10877e-02,0.10513e-02,0.59159e-03 /)
      kbo(:, 2,39, 6) = (/ &
        & 0.29433e-03,0.10839e-02,0.12173e-02,0.11700e-02,0.64088e-03 /)
      kbo(:, 3,39, 6) = (/ &
        & 0.33554e-03,0.12164e-02,0.13675e-02,0.13079e-02,0.69454e-03 /)
      kbo(:, 4,39, 6) = (/ &
        & 0.37315e-03,0.13660e-02,0.15416e-02,0.14697e-02,0.75241e-03 /)
      kbo(:, 5,39, 6) = (/ &
        & 0.40840e-03,0.15291e-02,0.17396e-02,0.16583e-02,0.81566e-03 /)
      kbo(:, 1,40, 6) = (/ &
        & 0.20445e-03,0.81104e-03,0.91201e-03,0.88303e-03,0.49462e-03 /)
      kbo(:, 2,40, 6) = (/ &
        & 0.24013e-03,0.91062e-03,0.10259e-02,0.98834e-03,0.53806e-03 /)
      kbo(:, 3,40, 6) = (/ &
        & 0.27454e-03,0.10267e-02,0.11591e-02,0.11112e-02,0.58582e-03 /)
      kbo(:, 4,40, 6) = (/ &
        & 0.30609e-03,0.11586e-02,0.13148e-02,0.12564e-02,0.63733e-03 /)
      kbo(:, 5,40, 6) = (/ &
        & 0.33521e-03,0.13038e-02,0.14932e-02,0.14267e-02,0.69406e-03 /)
      kbo(:, 1,41, 6) = (/ &
        & 0.16568e-03,0.67706e-03,0.76339e-03,0.74014e-03,0.41311e-03 /)
      kbo(:, 2,41, 6) = (/ &
        & 0.19545e-03,0.76370e-03,0.86317e-03,0.83349e-03,0.45126e-03 /)
      kbo(:, 3,41, 6) = (/ &
        & 0.22429e-03,0.86513e-03,0.98057e-03,0.94284e-03,0.49336e-03 /)
      kbo(:, 4,41, 6) = (/ &
        & 0.25075e-03,0.98100e-03,0.11192e-02,0.10723e-02,0.53916e-03 /)
      kbo(:, 5,41, 6) = (/ &
        & 0.27523e-03,0.11101e-02,0.12797e-02,0.12259e-02,0.58980e-03 /)
      kbo(:, 1,42, 6) = (/ &
        & 0.13464e-03,0.56478e-03,0.63846e-03,0.61972e-03,0.34485e-03 /)
      kbo(:, 2,42, 6) = (/ &
        & 0.15918e-03,0.64002e-03,0.72573e-03,0.70212e-03,0.37807e-03 /)
      kbo(:, 3,42, 6) = (/ &
        & 0.18309e-03,0.72866e-03,0.82914e-03,0.79959e-03,0.41541e-03 /)
      kbo(:, 4,42, 6) = (/ &
        & 0.20534e-03,0.83063e-03,0.95224e-03,0.91510e-03,0.45609e-03 /)
      kbo(:, 5,42, 6) = (/ &
        & 0.22591e-03,0.94536e-03,0.10960e-02,0.10535e-02,0.50132e-03 /)
      kbo(:, 1,43, 6) = (/ &
        & 0.10834e-03,0.46763e-03,0.52964e-03,0.51479e-03,0.28641e-03 /)
      kbo(:, 2,43, 6) = (/ &
        & 0.12878e-03,0.53191e-03,0.60529e-03,0.58655e-03,0.31538e-03 /)
      kbo(:, 3,43, 6) = (/ &
        & 0.14877e-03,0.60848e-03,0.69517e-03,0.67233e-03,0.34781e-03 /)
      kbo(:, 4,43, 6) = (/ &
        & 0.16739e-03,0.69818e-03,0.80315e-03,0.77433e-03,0.38376e-03 /)
      kbo(:, 5,43, 6) = (/ &
        & 0.18458e-03,0.79951e-03,0.93071e-03,0.89755e-03,0.42371e-03 /)
      kbo(:, 1,44, 6) = (/ &
        & 0.86770e-04,0.38551e-03,0.43712e-03,0.42544e-03,0.23710e-03 /)
      kbo(:, 2,44, 6) = (/ &
        & 0.10382e-03,0.44040e-03,0.50222e-03,0.48753e-03,0.26235e-03 /)
      kbo(:, 3,44, 6) = (/ &
        & 0.12059e-03,0.50571e-03,0.58013e-03,0.56233e-03,0.29036e-03 /)
      kbo(:, 4,44, 6) = (/ &
        & 0.13632e-03,0.58391e-03,0.67429e-03,0.65221e-03,0.32192e-03 /)
      kbo(:, 5,44, 6) = (/ &
        & 0.15073e-03,0.67339e-03,0.78624e-03,0.76086e-03,0.35732e-03 /)
      kbo(:, 1,45, 6) = (/ &
        & 0.69317e-04,0.31724e-03,0.36001e-03,0.35090e-03,0.19579e-03 /)
      kbo(:, 2,45, 6) = (/ &
        & 0.83569e-04,0.36417e-03,0.41579e-03,0.40435e-03,0.21781e-03 /)
      kbo(:, 3,45, 6) = (/ &
        & 0.97725e-04,0.42014e-03,0.48329e-03,0.46938e-03,0.24226e-03 /)
      kbo(:, 4,45, 6) = (/ &
        & 0.11101e-03,0.48745e-03,0.56520e-03,0.54804e-03,0.26965e-03 /)
      kbo(:, 5,45, 6) = (/ &
        & 0.12310e-03,0.56606e-03,0.66327e-03,0.64374e-03,0.30080e-03 /)
      kbo(:, 1,46, 6) = (/ &
        & 0.55030e-04,0.26007e-03,0.29522e-03,0.28798e-03,0.16098e-03 /)
      kbo(:, 2,46, 6) = (/ &
        & 0.66908e-04,0.29981e-03,0.34235e-03,0.33361e-03,0.18009e-03 /)
      kbo(:, 3,46, 6) = (/ &
        & 0.78894e-04,0.34737e-03,0.40028e-03,0.38969e-03,0.20138e-03 /)
      kbo(:, 4,46, 6) = (/ &
        & 0.90228e-04,0.40507e-03,0.47110e-03,0.45796e-03,0.22525e-03 /)
      kbo(:, 5,46, 6) = (/ &
        & 0.10044e-03,0.47380e-03,0.55673e-03,0.54149e-03,0.25231e-03 /)
      kbo(:, 1,47, 6) = (/ &
        & 0.43131e-04,0.21132e-03,0.23992e-03,0.23430e-03,0.13147e-03 /)
      kbo(:, 2,47, 6) = (/ &
        & 0.53026e-04,0.24489e-03,0.27966e-03,0.27282e-03,0.14794e-03 /)
      kbo(:, 3,47, 6) = (/ &
        & 0.63179e-04,0.28502e-03,0.32837e-03,0.32046e-03,0.16642e-03 /)
      kbo(:, 4,47, 6) = (/ &
        & 0.72849e-04,0.33391e-03,0.38868e-03,0.37909e-03,0.18727e-03 /)
      kbo(:, 5,47, 6) = (/ &
        & 0.81641e-04,0.39308e-03,0.46293e-03,0.45114e-03,0.21071e-03 /)
      kbo(:, 1,48, 6) = (/ &
        & 0.33560e-04,0.17139e-03,0.19468e-03,0.19001e-03,0.10710e-03 /)
      kbo(:, 2,48, 6) = (/ &
        & 0.41736e-04,0.19942e-03,0.22765e-03,0.22235e-03,0.12121e-03 /)
      kbo(:, 3,48, 6) = (/ &
        & 0.50371e-04,0.23319e-03,0.26893e-03,0.26280e-03,0.13718e-03 /)
      kbo(:, 4,48, 6) = (/ &
        & 0.58779e-04,0.27466e-03,0.31973e-03,0.31295e-03,0.15543e-03 /)
      kbo(:, 5,48, 6) = (/ &
        & 0.66247e-04,0.32531e-03,0.38347e-03,0.37465e-03,0.17582e-03 /)
      kbo(:, 1,49, 6) = (/ &
        & 0.25958e-04,0.13895e-03,0.15751e-03,0.15378e-03,0.86997e-04 /)
      kbo(:, 2,49, 6) = (/ &
        & 0.32663e-04,0.16210e-03,0.18496e-03,0.18058e-03,0.99003e-04 /)
      kbo(:, 3,49, 6) = (/ &
        & 0.39912e-04,0.19033e-03,0.21954e-03,0.21463e-03,0.11278e-03 /)
      kbo(:, 4,49, 6) = (/ &
        & 0.47146e-04,0.22536e-03,0.26252e-03,0.25743e-03,0.12854e-03 /)
      kbo(:, 5,49, 6) = (/ &
        & 0.53714e-04,0.26879e-03,0.31652e-03,0.31040e-03,0.14638e-03 /)
      kbo(:, 1,50, 6) = (/ &
        & 0.20123e-04,0.11283e-03,0.12763e-03,0.12462e-03,0.70722e-04 /)
      kbo(:, 2,50, 6) = (/ &
        & 0.25601e-04,0.13215e-03,0.15042e-03,0.14697e-03,0.80931e-04 /)
      kbo(:, 3,50, 6) = (/ &
        & 0.31614e-04,0.15574e-03,0.17957e-03,0.17552e-03,0.92734e-04 /)
      kbo(:, 4,50, 6) = (/ &
        & 0.37764e-04,0.18520e-03,0.21596e-03,0.21200e-03,0.10641e-03 /)
      kbo(:, 5,50, 6) = (/ &
        & 0.43463e-04,0.22248e-03,0.26195e-03,0.25758e-03,0.12203e-03 /)
      kbo(:, 1,51, 6) = (/ &
        & 0.15566e-04,0.91692e-04,0.10348e-03,0.10093e-03,0.57420e-04 /)
      kbo(:, 2,51, 6) = (/ &
        & 0.20041e-04,0.10771e-03,0.12230e-03,0.11952e-03,0.66019e-04 /)
      kbo(:, 3,51, 6) = (/ &
        & 0.25022e-04,0.12757e-03,0.14670e-03,0.14349e-03,0.76182e-04 /)
      kbo(:, 4,51, 6) = (/ &
        & 0.30196e-04,0.15226e-03,0.17772e-03,0.17429e-03,0.87954e-04 /)
      kbo(:, 5,51, 6) = (/ &
        & 0.35140e-04,0.18405e-03,0.21697e-03,0.21356e-03,0.10162e-03 /)
      kbo(:, 1,52, 6) = (/ &
        & 0.11977e-04,0.74321e-04,0.83777e-04,0.81525e-04,0.46492e-04 /)
      kbo(:, 2,52, 6) = (/ &
        & 0.15618e-04,0.87662e-04,0.99315e-04,0.96995e-04,0.53744e-04 /)
      kbo(:, 3,52, 6) = (/ &
        & 0.19731e-04,0.10434e-03,0.11957e-03,0.11696e-03,0.62355e-04 /)
      kbo(:, 4,52, 6) = (/ &
        & 0.24071e-04,0.12514e-03,0.14574e-03,0.14300e-03,0.72491e-04 /)
      kbo(:, 5,52, 6) = (/ &
        & 0.28292e-04,0.15185e-03,0.17919e-03,0.17642e-03,0.84356e-04 /)
      kbo(:, 1,53, 6) = (/ &
        & 0.91836e-05,0.60131e-04,0.67720e-04,0.65649e-04,0.37522e-04 /)
      kbo(:, 2,53, 6) = (/ &
        & 0.12113e-04,0.71192e-04,0.80457e-04,0.78425e-04,0.43599e-04 /)
      kbo(:, 3,53, 6) = (/ &
        & 0.15471e-04,0.85141e-04,0.97276e-04,0.95110e-04,0.50903e-04 /)
      kbo(:, 4,53, 6) = (/ &
        & 0.19102e-04,0.10263e-03,0.11918e-03,0.11694e-03,0.59553e-04 /)
      kbo(:, 5,53, 6) = (/ &
        & 0.22693e-04,0.12514e-03,0.14755e-03,0.14527e-03,0.69812e-04 /)
      kbo(:, 1,54, 6) = (/ &
        & 0.70721e-05,0.48764e-04,0.54926e-04,0.53041e-04,0.30337e-04 /)
      kbo(:, 2,54, 6) = (/ &
        & 0.94270e-05,0.57982e-04,0.65461e-04,0.63579e-04,0.35439e-04 /)
      kbo(:, 3,54, 6) = (/ &
        & 0.12173e-04,0.69671e-04,0.79433e-04,0.77530e-04,0.41618e-04 /)
      kbo(:, 4,54, 6) = (/ &
        & 0.15195e-04,0.84502e-04,0.97826e-04,0.96029e-04,0.49017e-04 /)
      kbo(:, 5,54, 6) = (/ &
        & 0.18243e-04,0.10358e-03,0.12196e-03,0.12023e-03,0.57880e-04 /)
      kbo(:, 1,55, 6) = (/ &
        & 0.54549e-05,0.39521e-04,0.44580e-04,0.42901e-04,0.24523e-04 /)
      kbo(:, 2,55, 6) = (/ &
        & 0.73474e-05,0.47258e-04,0.53311e-04,0.51627e-04,0.28799e-04 /)
      kbo(:, 3,55, 6) = (/ &
        & 0.95818e-05,0.57041e-04,0.64957e-04,0.63210e-04,0.34015e-04 /)
      kbo(:, 4,55, 6) = (/ &
        & 0.12078e-04,0.69528e-04,0.80422e-04,0.78845e-04,0.40325e-04 /)
      kbo(:, 5,55, 6) = (/ &
        & 0.14658e-04,0.85891e-04,0.10087e-03,0.99485e-04,0.47973e-04 /)
      kbo(:, 1,56, 6) = (/ &
        & 0.41972e-05,0.31935e-04,0.36125e-04,0.34628e-04,0.19758e-04 /)
      kbo(:, 2,56, 6) = (/ &
        & 0.56951e-05,0.38357e-04,0.43303e-04,0.41823e-04,0.23341e-04 /)
      kbo(:, 3,56, 6) = (/ &
        & 0.75109e-05,0.46586e-04,0.52984e-04,0.51438e-04,0.27705e-04 /)
      kbo(:, 4,56, 6) = (/ &
        & 0.95701e-05,0.57135e-04,0.66020e-04,0.64513e-04,0.33090e-04 /)
      kbo(:, 5,56, 6) = (/ &
        & 0.11741e-04,0.70996e-04,0.83348e-04,0.82172e-04,0.39639e-04 /)
      kbo(:, 1,57, 6) = (/ &
        & 0.32187e-05,0.25710e-04,0.29175e-04,0.27903e-04,0.15874e-04 /)
      kbo(:, 2,57, 6) = (/ &
        & 0.44067e-05,0.31037e-04,0.35094e-04,0.33812e-04,0.18857e-04 /)
      kbo(:, 3,57, 6) = (/ &
        & 0.58663e-05,0.37889e-04,0.43100e-04,0.41766e-04,0.22502e-04 /)
      kbo(:, 4,57, 6) = (/ &
        & 0.75519e-05,0.46817e-04,0.54053e-04,0.52634e-04,0.27030e-04 /)
      kbo(:, 5,57, 6) = (/ &
        & 0.93649e-05,0.58529e-04,0.68705e-04,0.67601e-04,0.32661e-04 /)
      kbo(:, 1,58, 6) = (/ &
        & 0.24696e-05,0.20698e-04,0.23574e-04,0.22507e-04,0.12764e-04 /)
      kbo(:, 2,58, 6) = (/ &
        & 0.34175e-05,0.25141e-04,0.28438e-04,0.27351e-04,0.15243e-04 /)
      kbo(:, 3,58, 6) = (/ &
        & 0.45825e-05,0.30855e-04,0.35092e-04,0.33951e-04,0.18275e-04 /)
      kbo(:, 4,58, 6) = (/ &
        & 0.59665e-05,0.38392e-04,0.44239e-04,0.43055e-04,0.22112e-04 /)
      kbo(:, 5,58, 6) = (/ &
        & 0.74784e-05,0.48383e-04,0.56772e-04,0.55657e-04,0.26900e-04 /)
      kbo(:, 1,59, 6) = (/ &
        & 0.20113e-05,0.17223e-04,0.19628e-04,0.18772e-04,0.10576e-04 /)
      kbo(:, 2,59, 6) = (/ &
        & 0.27973e-05,0.21075e-04,0.23849e-04,0.22960e-04,0.12702e-04 /)
      kbo(:, 3,59, 6) = (/ &
        & 0.37714e-05,0.26064e-04,0.29696e-04,0.28726e-04,0.15326e-04 /)
      kbo(:, 4,59, 6) = (/ &
        & 0.49189e-05,0.32724e-04,0.37808e-04,0.36791e-04,0.18710e-04 /)
      kbo(:, 5,59, 6) = (/ &
        & 0.61850e-05,0.41676e-04,0.49043e-04,0.48051e-04,0.22936e-04 /)
      kbo(:, 1,13, 7) = (/ &
        & 0.90574e-01,0.18508e+00,0.20125e+00,0.19353e+00,0.13590e+00 /)
      kbo(:, 2,13, 7) = (/ &
        & 0.96633e-01,0.18856e+00,0.20514e+00,0.19781e+00,0.13867e+00 /)
      kbo(:, 3,13, 7) = (/ &
        & 0.10246e+00,0.19231e+00,0.20916e+00,0.20175e+00,0.14157e+00 /)
      kbo(:, 4,13, 7) = (/ &
        & 0.10831e+00,0.19664e+00,0.21340e+00,0.20566e+00,0.14422e+00 /)
      kbo(:, 5,13, 7) = (/ &
        & 0.11418e+00,0.20190e+00,0.21829e+00,0.20964e+00,0.14715e+00 /)
      kbo(:, 1,14, 7) = (/ &
        & 0.76731e-01,0.15637e+00,0.17031e+00,0.16454e+00,0.11471e+00 /)
      kbo(:, 2,14, 7) = (/ &
        & 0.81853e-01,0.15935e+00,0.17367e+00,0.16809e+00,0.11738e+00 /)
      kbo(:, 3,14, 7) = (/ &
        & 0.86939e-01,0.16284e+00,0.17719e+00,0.17151e+00,0.11993e+00 /)
      kbo(:, 4,14, 7) = (/ &
        & 0.91985e-01,0.16698e+00,0.18115e+00,0.17500e+00,0.12254e+00 /)
      kbo(:, 5,14, 7) = (/ &
        & 0.97005e-01,0.17199e+00,0.18590e+00,0.17860e+00,0.12524e+00 /)
      kbo(:, 1,15, 7) = (/ &
        & 0.64796e-01,0.13180e+00,0.14379e+00,0.13927e+00,0.96282e-01 /)
      kbo(:, 2,15, 7) = (/ &
        & 0.69175e-01,0.13451e+00,0.14669e+00,0.14230e+00,0.98702e-01 /)
      kbo(:, 3,15, 7) = (/ &
        & 0.73574e-01,0.13779e+00,0.14991e+00,0.14533e+00,0.10111e+00 /)
      kbo(:, 4,15, 7) = (/ &
        & 0.77907e-01,0.14175e+00,0.15375e+00,0.14848e+00,0.10336e+00 /)
      kbo(:, 5,15, 7) = (/ &
        & 0.82082e-01,0.14644e+00,0.15826e+00,0.15192e+00,0.10558e+00 /)
      kbo(:, 1,16, 7) = (/ &
        & 0.54603e-01,0.11092e+00,0.12113e+00,0.11747e+00,0.80564e-01 /)
      kbo(:, 2,16, 7) = (/ &
        & 0.58392e-01,0.11343e+00,0.12376e+00,0.12011e+00,0.82662e-01 /)
      kbo(:, 3,16, 7) = (/ &
        & 0.62149e-01,0.11652e+00,0.12680e+00,0.12283e+00,0.84744e-01 /)
      kbo(:, 4,16, 7) = (/ &
        & 0.65779e-01,0.12031e+00,0.13049e+00,0.12576e+00,0.86806e-01 /)
      kbo(:, 5,16, 7) = (/ &
        & 0.69275e-01,0.12462e+00,0.13474e+00,0.12909e+00,0.88592e-01 /)
      kbo(:, 1,17, 7) = (/ &
        & 0.46019e-01,0.93276e-01,0.10182e+00,0.98886e-01,0.67386e-01 /)
      kbo(:, 2,17, 7) = (/ &
        & 0.49257e-01,0.95617e-01,0.10427e+00,0.10122e+00,0.69214e-01 /)
      kbo(:, 3,17, 7) = (/ &
        & 0.52438e-01,0.98544e-01,0.10723e+00,0.10369e+00,0.71047e-01 /)
      kbo(:, 4,17, 7) = (/ &
        & 0.55444e-01,0.10204e+00,0.11074e+00,0.10647e+00,0.72809e-01 /)
      kbo(:, 5,17, 7) = (/ &
        & 0.58360e-01,0.10585e+00,0.11469e+00,0.10967e+00,0.74297e-01 /)
      kbo(:, 1,18, 7) = (/ &
        & 0.38789e-01,0.78385e-01,0.85426e-01,0.83127e-01,0.56424e-01 /)
      kbo(:, 2,18, 7) = (/ &
        & 0.41550e-01,0.80626e-01,0.87775e-01,0.85216e-01,0.58103e-01 /)
      kbo(:, 3,18, 7) = (/ &
        & 0.44172e-01,0.83391e-01,0.90633e-01,0.87547e-01,0.59665e-01 /)
      kbo(:, 4,18, 7) = (/ &
        & 0.46672e-01,0.86541e-01,0.93910e-01,0.90224e-01,0.61155e-01 /)
      kbo(:, 5,18, 7) = (/ &
        & 0.49119e-01,0.89890e-01,0.97478e-01,0.93171e-01,0.62440e-01 /)
      kbo(:, 1,19, 7) = (/ &
        & 0.32688e-01,0.65866e-01,0.71699e-01,0.69831e-01,0.47341e-01 /)
      kbo(:, 2,19, 7) = (/ &
        & 0.34993e-01,0.67987e-01,0.73938e-01,0.71758e-01,0.48787e-01 /)
      kbo(:, 3,19, 7) = (/ &
        & 0.37158e-01,0.70566e-01,0.76608e-01,0.73972e-01,0.50204e-01 /)
      kbo(:, 4,19, 7) = (/ &
        & 0.39257e-01,0.73365e-01,0.79594e-01,0.76458e-01,0.51459e-01 /)
      kbo(:, 5,19, 7) = (/ &
        & 0.41326e-01,0.76343e-01,0.82757e-01,0.79138e-01,0.52598e-01 /)
      kbo(:, 1,20, 7) = (/ &
        & 0.27557e-01,0.55396e-01,0.60366e-01,0.58674e-01,0.39775e-01 /)
      kbo(:, 2,20, 7) = (/ &
        & 0.29458e-01,0.57423e-01,0.62478e-01,0.60497e-01,0.41091e-01 /)
      kbo(:, 3,20, 7) = (/ &
        & 0.31261e-01,0.59745e-01,0.64927e-01,0.62579e-01,0.42317e-01 /)
      kbo(:, 4,20, 7) = (/ &
        & 0.33046e-01,0.62240e-01,0.67549e-01,0.64853e-01,0.43439e-01 /)
      kbo(:, 5,20, 7) = (/ &
        & 0.34818e-01,0.64890e-01,0.70320e-01,0.67290e-01,0.44513e-01 /)
      kbo(:, 1,21, 7) = (/ &
        & 0.23194e-01,0.46662e-01,0.50879e-01,0.49331e-01,0.33429e-01 /)
      kbo(:, 2,21, 7) = (/ &
        & 0.24776e-01,0.48529e-01,0.52871e-01,0.51054e-01,0.34590e-01 /)
      kbo(:, 3,21, 7) = (/ &
        & 0.26303e-01,0.50578e-01,0.55098e-01,0.52980e-01,0.35684e-01 /)
      kbo(:, 4,21, 7) = (/ &
        & 0.27810e-01,0.52793e-01,0.57429e-01,0.55052e-01,0.36688e-01 /)
      kbo(:, 5,21, 7) = (/ &
        & 0.29323e-01,0.55187e-01,0.59853e-01,0.57245e-01,0.37657e-01 /)
      kbo(:, 1,22, 7) = (/ &
        & 0.19600e-01,0.39448e-01,0.43057e-01,0.41623e-01,0.28169e-01 /)
      kbo(:, 2,22, 7) = (/ &
        & 0.20910e-01,0.41135e-01,0.44924e-01,0.43250e-01,0.29188e-01 /)
      kbo(:, 3,22, 7) = (/ &
        & 0.22195e-01,0.42970e-01,0.46916e-01,0.45021e-01,0.30138e-01 /)
      kbo(:, 4,22, 7) = (/ &
        & 0.23466e-01,0.44963e-01,0.48978e-01,0.46906e-01,0.31021e-01 /)
      kbo(:, 5,22, 7) = (/ &
        & 0.24791e-01,0.47151e-01,0.51143e-01,0.48901e-01,0.31919e-01 /)
      kbo(:, 1,23, 7) = (/ &
        & 0.16563e-01,0.33405e-01,0.36517e-01,0.35235e-01,0.23758e-01 /)
      kbo(:, 2,23, 7) = (/ &
        & 0.17634e-01,0.34920e-01,0.38215e-01,0.36726e-01,0.24656e-01 /)
      kbo(:, 3,23, 7) = (/ &
        & 0.18715e-01,0.36571e-01,0.39976e-01,0.38337e-01,0.25473e-01 /)
      kbo(:, 4,23, 7) = (/ &
        & 0.19810e-01,0.38397e-01,0.41828e-01,0.40046e-01,0.26273e-01 /)
      kbo(:, 5,23, 7) = (/ &
        & 0.20990e-01,0.40406e-01,0.43840e-01,0.41881e-01,0.27068e-01 /)
      kbo(:, 1,24, 7) = (/ &
        & 0.13980e-01,0.28346e-01,0.31027e-01,0.29909e-01,0.20058e-01 /)
      kbo(:, 2,24, 7) = (/ &
        & 0.14874e-01,0.29707e-01,0.32546e-01,0.31266e-01,0.20839e-01 /)
      kbo(:, 3,24, 7) = (/ &
        & 0.15797e-01,0.31204e-01,0.34123e-01,0.32728e-01,0.21557e-01 /)
      kbo(:, 4,24, 7) = (/ &
        & 0.16758e-01,0.32875e-01,0.35824e-01,0.34296e-01,0.22274e-01 /)
      kbo(:, 5,24, 7) = (/ &
        & 0.17809e-01,0.34737e-01,0.37711e-01,0.35981e-01,0.22992e-01 /)
      kbo(:, 1,25, 7) = (/ &
        & 0.11798e-01,0.24110e-01,0.26426e-01,0.25457e-01,0.16985e-01 /)
      kbo(:, 2,25, 7) = (/ &
        & 0.12561e-01,0.25347e-01,0.27781e-01,0.26691e-01,0.17655e-01 /)
      kbo(:, 3,25, 7) = (/ &
        & 0.13359e-01,0.26711e-01,0.29222e-01,0.28026e-01,0.18302e-01 /)
      kbo(:, 4,25, 7) = (/ &
        & 0.14208e-01,0.28241e-01,0.30806e-01,0.29472e-01,0.18949e-01 /)
      kbo(:, 5,25, 7) = (/ &
        & 0.15157e-01,0.29980e-01,0.32597e-01,0.31029e-01,0.19596e-01 /)
      kbo(:, 1,26, 7) = (/ &
        & 0.99745e-02,0.20581e-01,0.22580e-01,0.21746e-01,0.14432e-01 /)
      kbo(:, 2,26, 7) = (/ &
        & 0.10633e-01,0.21703e-01,0.23807e-01,0.22873e-01,0.15014e-01 /)
      kbo(:, 3,26, 7) = (/ &
        & 0.11328e-01,0.22948e-01,0.25141e-01,0.24108e-01,0.15588e-01 /)
      kbo(:, 4,26, 7) = (/ &
        & 0.12091e-01,0.24380e-01,0.26636e-01,0.25439e-01,0.16180e-01 /)
      kbo(:, 5,26, 7) = (/ &
        & 0.12943e-01,0.26016e-01,0.28335e-01,0.26899e-01,0.16787e-01 /)
      kbo(:, 1,27, 7) = (/ &
        & 0.84424e-02,0.17603e-01,0.19348e-01,0.18632e-01,0.12275e-01 /)
      kbo(:, 2,27, 7) = (/ &
        & 0.90172e-02,0.18627e-01,0.20475e-01,0.19670e-01,0.12796e-01 /)
      kbo(:, 3,27, 7) = (/ &
        & 0.96344e-02,0.19791e-01,0.21724e-01,0.20817e-01,0.13316e-01 /)
      kbo(:, 4,27, 7) = (/ &
        & 0.10319e-01,0.21143e-01,0.23141e-01,0.22059e-01,0.13859e-01 /)
      kbo(:, 5,27, 7) = (/ &
        & 0.11083e-01,0.22688e-01,0.24742e-01,0.23449e-01,0.14418e-01 /)
      kbo(:, 1,28, 7) = (/ &
        & 0.71594e-02,0.15094e-01,0.16638e-01,0.16016e-01,0.10452e-01 /)
      kbo(:, 2,28, 7) = (/ &
        & 0.76603e-02,0.16043e-01,0.17678e-01,0.16989e-01,0.10928e-01 /)
      kbo(:, 3,28, 7) = (/ &
        & 0.82161e-02,0.17148e-01,0.18856e-01,0.18055e-01,0.11409e-01 /)
      kbo(:, 4,28, 7) = (/ &
        & 0.88297e-02,0.18429e-01,0.20193e-01,0.19234e-01,0.11908e-01 /)
      kbo(:, 5,28, 7) = (/ &
        & 0.95210e-02,0.19896e-01,0.21697e-01,0.20565e-01,0.12423e-01 /)
      kbo(:, 1,29, 7) = (/ &
        & 0.60865e-02,0.12992e-01,0.14367e-01,0.13830e-01,0.89337e-02 /)
      kbo(:, 2,29, 7) = (/ &
        & 0.65273e-02,0.13894e-01,0.15342e-01,0.14741e-01,0.93649e-02 /)
      kbo(:, 3,29, 7) = (/ &
        & 0.70278e-02,0.14949e-01,0.16457e-01,0.15746e-01,0.98158e-02 /)
      kbo(:, 4,29, 7) = (/ &
        & 0.75858e-02,0.16169e-01,0.17720e-01,0.16877e-01,0.10273e-01 /)
      kbo(:, 5,29, 7) = (/ &
        & 0.82154e-02,0.17564e-01,0.19150e-01,0.18159e-01,0.10745e-01 /)
      kbo(:, 1,30, 7) = (/ &
        & 0.51820e-02,0.11236e-01,0.12459e-01,0.12000e-01,0.76507e-02 /)
      kbo(:, 2,30, 7) = (/ &
        & 0.55811e-02,0.12098e-01,0.13380e-01,0.12854e-01,0.80497e-02 /)
      kbo(:, 3,30, 7) = (/ &
        & 0.60310e-02,0.13108e-01,0.14440e-01,0.13813e-01,0.84648e-02 /)
      kbo(:, 4,30, 7) = (/ &
        & 0.65404e-02,0.14273e-01,0.15644e-01,0.14905e-01,0.88882e-02 /)
      kbo(:, 5,30, 7) = (/ &
        & 0.71170e-02,0.15597e-01,0.17012e-01,0.16134e-01,0.93248e-02 /)
      kbo(:, 1,31, 7) = (/ &
        & 0.44272e-02,0.97757e-02,0.10859e-01,0.10467e-01,0.65734e-02 /)
      kbo(:, 2,31, 7) = (/ &
        & 0.47878e-02,0.10603e-01,0.11740e-01,0.11277e-01,0.69415e-02 /)
      kbo(:, 3,31, 7) = (/ &
        & 0.51963e-02,0.11572e-01,0.12753e-01,0.12201e-01,0.73188e-02 /)
      kbo(:, 4,31, 7) = (/ &
        & 0.56609e-02,0.12684e-01,0.13904e-01,0.13252e-01,0.77091e-02 /)
      kbo(:, 5,31, 7) = (/ &
        & 0.61977e-02,0.13944e-01,0.15244e-01,0.14424e-01,0.81161e-02 /)
      kbo(:, 1,32, 7) = (/ &
        & 0.37962e-02,0.85614e-02,0.95233e-02,0.91812e-02,0.56658e-02 /)
      kbo(:, 2,32, 7) = (/ &
        & 0.41228e-02,0.93595e-02,0.10368e-01,0.99574e-02,0.60000e-02 /)
      kbo(:, 3,32, 7) = (/ &
        & 0.44947e-02,0.10287e-01,0.11338e-01,0.10850e-01,0.63462e-02 /)
      kbo(:, 4,32, 7) = (/ &
        & 0.49244e-02,0.11349e-01,0.12467e-01,0.11857e-01,0.67069e-02 /)
      kbo(:, 5,32, 7) = (/ &
        & 0.54252e-02,0.12554e-01,0.13767e-01,0.12983e-01,0.70910e-02 /)
      kbo(:, 1,33, 7) = (/ &
        & 0.32656e-02,0.75519e-02,0.84026e-02,0.81028e-02,0.48937e-02 /)
      kbo(:, 2,33, 7) = (/ &
        & 0.35630e-02,0.83178e-02,0.92157e-02,0.88531e-02,0.52004e-02 /)
      kbo(:, 3,33, 7) = (/ &
        & 0.39050e-02,0.92063e-02,0.10168e-01,0.97125e-02,0.55156e-02 /)
      kbo(:, 4,33, 7) = (/ &
        & 0.43055e-02,0.10227e-01,0.11270e-01,0.10682e-01,0.58516e-02 /)
      kbo(:, 5,33, 7) = (/ &
        & 0.47651e-02,0.11396e-01,0.12524e-01,0.11769e-01,0.62091e-02 /)
      kbo(:, 1,34, 7) = (/ &
        & 0.28105e-02,0.66873e-02,0.74405e-02,0.71742e-02,0.42413e-02 /)
      kbo(:, 2,34, 7) = (/ &
        & 0.30819e-02,0.74197e-02,0.82328e-02,0.78962e-02,0.45189e-02 /)
      kbo(:, 3,34, 7) = (/ &
        & 0.33974e-02,0.82731e-02,0.91582e-02,0.87214e-02,0.48133e-02 /)
      kbo(:, 4,34, 7) = (/ &
        & 0.37682e-02,0.92558e-02,0.10225e-01,0.96550e-02,0.51300e-02 /)
      kbo(:, 5,34, 7) = (/ &
        & 0.41836e-02,0.10408e-01,0.11429e-01,0.10709e-01,0.54671e-02 /)
      kbo(:, 1,35, 7) = (/ &
        & 0.24038e-02,0.58948e-02,0.65709e-02,0.63304e-02,0.36544e-02 /)
      kbo(:, 2,35, 7) = (/ &
        & 0.26483e-02,0.65885e-02,0.73295e-02,0.70175e-02,0.39080e-02 /)
      kbo(:, 3,35, 7) = (/ &
        & 0.29372e-02,0.74016e-02,0.82197e-02,0.78032e-02,0.41855e-02 /)
      kbo(:, 4,35, 7) = (/ &
        & 0.32728e-02,0.83531e-02,0.92365e-02,0.86973e-02,0.44777e-02 /)
      kbo(:, 5,35, 7) = (/ &
        & 0.36421e-02,0.94681e-02,0.10387e-01,0.97145e-02,0.47967e-02 /)
      kbo(:, 1,36, 7) = (/ &
        & 0.20373e-02,0.51550e-02,0.57662e-02,0.55498e-02,0.31231e-02 /)
      kbo(:, 2,36, 7) = (/ &
        & 0.22554e-02,0.58057e-02,0.64818e-02,0.61953e-02,0.33549e-02 /)
      kbo(:, 3,36, 7) = (/ &
        & 0.25127e-02,0.65796e-02,0.73228e-02,0.69361e-02,0.36112e-02 /)
      kbo(:, 4,36, 7) = (/ &
        & 0.28104e-02,0.74827e-02,0.82833e-02,0.77843e-02,0.38823e-02 /)
      kbo(:, 5,36, 7) = (/ &
        & 0.31359e-02,0.85467e-02,0.93763e-02,0.87575e-02,0.41812e-02 /)
      kbo(:, 1,37, 7) = (/ &
        & 0.17035e-02,0.44466e-02,0.49856e-02,0.47970e-02,0.26734e-02 /)
      kbo(:, 2,37, 7) = (/ &
        & 0.18934e-02,0.50433e-02,0.56462e-02,0.53907e-02,0.28873e-02 /)
      kbo(:, 3,37, 7) = (/ &
        & 0.21171e-02,0.57558e-02,0.64223e-02,0.60783e-02,0.31233e-02 /)
      kbo(:, 4,37, 7) = (/ &
        & 0.23767e-02,0.65938e-02,0.73141e-02,0.68717e-02,0.33760e-02 /)
      kbo(:, 5,37, 7) = (/ &
        & 0.26616e-02,0.75860e-02,0.83359e-02,0.77859e-02,0.36530e-02 /)
      kbo(:, 1,38, 7) = (/ &
        & 0.14234e-02,0.38379e-02,0.43139e-02,0.41486e-02,0.22904e-02 /)
      kbo(:, 2,38, 7) = (/ &
        & 0.15875e-02,0.43850e-02,0.49236e-02,0.46956e-02,0.24873e-02 /)
      kbo(:, 3,38, 7) = (/ &
        & 0.17824e-02,0.50419e-02,0.56400e-02,0.53338e-02,0.27024e-02 /)
      kbo(:, 4,38, 7) = (/ &
        & 0.20080e-02,0.58195e-02,0.64682e-02,0.60767e-02,0.29386e-02 /)
      kbo(:, 5,38, 7) = (/ &
        & 0.22567e-02,0.67445e-02,0.74253e-02,0.69357e-02,0.31979e-02 /)
      kbo(:, 1,39, 7) = (/ &
        & 0.11890e-02,0.33180e-02,0.37396e-02,0.35935e-02,0.19623e-02 /)
      kbo(:, 2,39, 7) = (/ &
        & 0.13309e-02,0.38204e-02,0.43017e-02,0.40980e-02,0.21427e-02 /)
      kbo(:, 3,39, 7) = (/ &
        & 0.14997e-02,0.44279e-02,0.49653e-02,0.46926e-02,0.23415e-02 /)
      kbo(:, 4,39, 7) = (/ &
        & 0.16956e-02,0.51508e-02,0.57361e-02,0.53891e-02,0.25595e-02 /)
      kbo(:, 5,39, 7) = (/ &
        & 0.19128e-02,0.60136e-02,0.66353e-02,0.61975e-02,0.28034e-02 /)
      kbo(:, 1,40, 7) = (/ &
        & 0.98185e-03,0.28304e-02,0.31989e-02,0.30741e-02,0.16759e-02 /)
      kbo(:, 2,40, 7) = (/ &
        & 0.11018e-02,0.32825e-02,0.37073e-02,0.35318e-02,0.18412e-02 /)
      kbo(:, 3,40, 7) = (/ &
        & 0.12459e-02,0.38338e-02,0.43125e-02,0.40771e-02,0.20230e-02 /)
      kbo(:, 4,40, 7) = (/ &
        & 0.14138e-02,0.44950e-02,0.50204e-02,0.47198e-02,0.22264e-02 /)
      kbo(:, 5,40, 7) = (/ &
        & 0.16015e-02,0.52867e-02,0.58524e-02,0.54701e-02,0.24538e-02 /)
      kbo(:, 1,41, 7) = (/ &
        & 0.80888e-03,0.24101e-02,0.27302e-02,0.26250e-02,0.14285e-02 /)
      kbo(:, 2,41, 7) = (/ &
        & 0.91042e-03,0.28166e-02,0.31895e-02,0.30396e-02,0.15812e-02 /)
      kbo(:, 3,41, 7) = (/ &
        & 0.10323e-02,0.33144e-02,0.37392e-02,0.35375e-02,0.17482e-02 /)
      kbo(:, 4,41, 7) = (/ &
        & 0.11757e-02,0.39172e-02,0.43885e-02,0.41290e-02,0.19366e-02 /)
      kbo(:, 5,41, 7) = (/ &
        & 0.13368e-02,0.46417e-02,0.51571e-02,0.48237e-02,0.21455e-02 /)
      kbo(:, 1,42, 7) = (/ &
        & 0.66584e-03,0.20506e-02,0.23294e-02,0.22418e-02,0.12147e-02 /)
      kbo(:, 2,42, 7) = (/ &
        & 0.75117e-03,0.24164e-02,0.27427e-02,0.26163e-02,0.13552e-02 /)
      kbo(:, 3,42, 7) = (/ &
        & 0.85464e-03,0.28657e-02,0.32419e-02,0.30702e-02,0.15103e-02 /)
      kbo(:, 4,42, 7) = (/ &
        & 0.97690e-03,0.34148e-02,0.38374e-02,0.36136e-02,0.16836e-02 /)
      kbo(:, 5,42, 7) = (/ &
        & 0.11154e-02,0.40777e-02,0.45486e-02,0.42564e-02,0.18765e-02 /)
      kbo(:, 1,43, 7) = (/ &
        & 0.54468e-03,0.17260e-02,0.19662e-02,0.18963e-02,0.10278e-02 /)
      kbo(:, 2,43, 7) = (/ &
        & 0.61495e-03,0.20517e-02,0.23339e-02,0.22307e-02,0.11544e-02 /)
      kbo(:, 3,43, 7) = (/ &
        & 0.70090e-03,0.24526e-02,0.27821e-02,0.26393e-02,0.12972e-02 /)
      kbo(:, 4,43, 7) = (/ &
        & 0.80460e-03,0.29460e-02,0.33228e-02,0.31329e-02,0.14583e-02 /)
      kbo(:, 5,43, 7) = (/ &
        & 0.92296e-03,0.35462e-02,0.39738e-02,0.37220e-02,0.16369e-02 /)
      kbo(:, 1,44, 7) = (/ &
        & 0.44364e-03,0.14437e-02,0.16496e-02,0.15952e-02,0.86540e-03 /)
      kbo(:, 2,44, 7) = (/ &
        & 0.50199e-03,0.17304e-02,0.19739e-02,0.18912e-02,0.97937e-03 /)
      kbo(:, 3,44, 7) = (/ &
        & 0.57242e-03,0.20860e-02,0.23731e-02,0.22565e-02,0.11106e-02 /)
      kbo(:, 4,44, 7) = (/ &
        & 0.65930e-03,0.25283e-02,0.28613e-02,0.27024e-02,0.12573e-02 /)
      kbo(:, 5,44, 7) = (/ &
        & 0.75974e-03,0.30673e-02,0.34531e-02,0.32379e-02,0.14238e-02 /)
      kbo(:, 1,45, 7) = (/ &
        & 0.36129e-03,0.12055e-02,0.13811e-02,0.13394e-02,0.72668e-03 /)
      kbo(:, 2,45, 7) = (/ &
        & 0.40925e-03,0.14558e-02,0.16660e-02,0.16003e-02,0.82937e-03 /)
      kbo(:, 3,45, 7) = (/ &
        & 0.46755e-03,0.17705e-02,0.20201e-02,0.19260e-02,0.94755e-03 /)
      kbo(:, 4,45, 7) = (/ &
        & 0.53937e-03,0.21654e-02,0.24593e-02,0.23275e-02,0.10822e-02 /)
      kbo(:, 5,45, 7) = (/ &
        & 0.62400e-03,0.26505e-02,0.29965e-02,0.28141e-02,0.12345e-02 /)
      kbo(:, 1,46, 7) = (/ &
        & 0.29308e-03,0.99917e-03,0.11483e-02,0.11175e-02,0.60699e-03 /)
      kbo(:, 2,46, 7) = (/ &
        & 0.33256e-03,0.12167e-02,0.13963e-02,0.13454e-02,0.69810e-03 /)
      kbo(:, 3,46, 7) = (/ &
        & 0.38031e-03,0.14933e-02,0.17091e-02,0.16341e-02,0.80431e-03 /)
      kbo(:, 4,46, 7) = (/ &
        & 0.43974e-03,0.18423e-02,0.21003e-02,0.19926e-02,0.92607e-03 /)
      kbo(:, 5,46, 7) = (/ &
        & 0.51042e-03,0.22760e-02,0.25842e-02,0.24318e-02,0.10656e-02 /)
      kbo(:, 1,47, 7) = (/ &
        & 0.23621e-03,0.81920e-03,0.94415e-03,0.92230e-03,0.50239e-03 /)
      kbo(:, 2,47, 7) = (/ &
        & 0.26847e-03,0.10045e-02,0.11560e-02,0.11182e-02,0.58268e-03 /)
      kbo(:, 3,47, 7) = (/ &
        & 0.30727e-03,0.12442e-02,0.14284e-02,0.13701e-02,0.67654e-03 /)
      kbo(:, 4,47, 7) = (/ &
        & 0.35565e-03,0.15479e-02,0.17727e-02,0.16866e-02,0.78602e-03 /)
      kbo(:, 5,47, 7) = (/ &
        & 0.41455e-03,0.19320e-02,0.22031e-02,0.20787e-02,0.91297e-03 /)
      kbo(:, 1,48, 7) = (/ &
        & 0.19056e-03,0.66912e-03,0.77329e-03,0.75810e-03,0.41434e-03 /)
      kbo(:, 2,48, 7) = (/ &
        & 0.21662e-03,0.82638e-03,0.95404e-03,0.92602e-03,0.48448e-03 /)
      kbo(:, 3,48, 7) = (/ &
        & 0.24805e-03,0.10324e-02,0.11883e-02,0.11443e-02,0.56714e-03 /)
      kbo(:, 4,48, 7) = (/ &
        & 0.28732e-03,0.12967e-02,0.14909e-02,0.14226e-02,0.66465e-03 /)
      kbo(:, 5,48, 7) = (/ &
        & 0.33598e-03,0.16339e-02,0.18720e-02,0.17712e-02,0.77925e-03 /)
      kbo(:, 1,49, 7) = (/ &
        & 0.15370e-03,0.54435e-03,0.63072e-03,0.62031e-03,0.34039e-03 /)
      kbo(:, 2,49, 7) = (/ &
        & 0.17493e-03,0.67703e-03,0.78385e-03,0.76375e-03,0.40110e-03 /)
      kbo(:, 3,49, 7) = (/ &
        & 0.20006e-03,0.85331e-03,0.98454e-03,0.95185e-03,0.47334e-03 /)
      kbo(:, 4,49, 7) = (/ &
        & 0.23184e-03,0.10822e-02,0.12482e-02,0.11953e-02,0.56021e-03 /)
      kbo(:, 5,49, 7) = (/ &
        & 0.27201e-03,0.13761e-02,0.15848e-02,0.15038e-02,0.66336e-03 /)
      kbo(:, 1,50, 7) = (/ &
        & 0.12445e-03,0.44363e-03,0.51558e-03,0.50858e-03,0.27983e-03 /)
      kbo(:, 2,50, 7) = (/ &
        & 0.14173e-03,0.55572e-03,0.64516e-03,0.63048e-03,0.33240e-03 /)
      kbo(:, 3,50, 7) = (/ &
        & 0.16225e-03,0.70658e-03,0.81789e-03,0.79296e-03,0.39601e-03 /)
      kbo(:, 4,50, 7) = (/ &
        & 0.18768e-03,0.90539e-03,0.10468e-02,0.10060e-02,0.47285e-03 /)
      kbo(:, 5,50, 7) = (/ &
        & 0.22071e-03,0.11624e-02,0.13446e-02,0.12795e-02,0.56523e-03 /)
      kbo(:, 1,51, 7) = (/ &
        & 0.10079e-03,0.36142e-03,0.42089e-03,0.41617e-03,0.23042e-03 /)
      kbo(:, 2,51, 7) = (/ &
        & 0.11508e-03,0.45540e-03,0.53023e-03,0.51983e-03,0.27489e-03 /)
      kbo(:, 3,51, 7) = (/ &
        & 0.13183e-03,0.58426e-03,0.67873e-03,0.65942e-03,0.33073e-03 /)
      kbo(:, 4,51, 7) = (/ &
        & 0.15243e-03,0.75694e-03,0.87652e-03,0.84573e-03,0.39869e-03 /)
      kbo(:, 5,51, 7) = (/ &
        & 0.17921e-03,0.98295e-03,0.11402e-02,0.10885e-02,0.48140e-03 /)
      kbo(:, 1,52, 7) = (/ &
        & 0.81556e-04,0.29363e-03,0.34244e-03,0.33921e-03,0.18905e-03 /)
      kbo(:, 2,52, 7) = (/ &
        & 0.93358e-04,0.37204e-03,0.43415e-03,0.42707e-03,0.22730e-03 /)
      kbo(:, 3,52, 7) = (/ &
        & 0.10711e-03,0.48125e-03,0.56095e-03,0.54625e-03,0.27517e-03 /)
      kbo(:, 4,52, 7) = (/ &
        & 0.12382e-03,0.62999e-03,0.73195e-03,0.70815e-03,0.33506e-03 /)
      kbo(:, 5,52, 7) = (/ &
        & 0.14564e-03,0.82786e-03,0.96258e-03,0.92197e-03,0.40847e-03 /)
      kbo(:, 1,53, 7) = (/ &
        & 0.65849e-04,0.23779e-03,0.27734e-03,0.27519e-03,0.15433e-03 /)
      kbo(:, 2,53, 7) = (/ &
        & 0.75546e-04,0.30303e-03,0.35410e-03,0.34952e-03,0.18741e-03 /)
      kbo(:, 3,53, 7) = (/ &
        & 0.86880e-04,0.39464e-03,0.46133e-03,0.45049e-03,0.22844e-03 /)
      kbo(:, 4,53, 7) = (/ &
        & 0.10061e-03,0.52205e-03,0.60866e-03,0.59002e-03,0.28045e-03 /)
      kbo(:, 5,53, 7) = (/ &
        & 0.11837e-03,0.69424e-03,0.80911e-03,0.77763e-03,0.34549e-03 /)
      kbo(:, 1,54, 7) = (/ &
        & 0.53194e-04,0.19358e-03,0.22554e-03,0.22386e-03,0.12634e-03 /)
      kbo(:, 2,54, 7) = (/ &
        & 0.61356e-04,0.24774e-03,0.28991e-03,0.28698e-03,0.15485e-03 /)
      kbo(:, 3,54, 7) = (/ &
        & 0.70732e-04,0.32546e-03,0.38104e-03,0.37325e-03,0.19067e-03 /)
      kbo(:, 4,54, 7) = (/ &
        & 0.81989e-04,0.43475e-03,0.50842e-03,0.49348e-03,0.23573e-03 /)
      kbo(:, 5,54, 7) = (/ &
        & 0.96606e-04,0.58491e-03,0.68358e-03,0.65848e-03,0.29331e-03 /)
      kbo(:, 1,55, 7) = (/ &
        & 0.42968e-04,0.15774e-03,0.18351e-03,0.18209e-03,0.10325e-03 /)
      kbo(:, 2,55, 7) = (/ &
        & 0.49757e-04,0.20300e-03,0.23752e-03,0.23563e-03,0.12786e-03 /)
      kbo(:, 3,55, 7) = (/ &
        & 0.57602e-04,0.26853e-03,0.31476e-03,0.30938e-03,0.15908e-03 /)
      kbo(:, 4,55, 7) = (/ &
        & 0.66944e-04,0.36215e-03,0.42458e-03,0.41285e-03,0.19867e-03 /)
      kbo(:, 5,55, 7) = (/ &
        & 0.78909e-04,0.49332e-03,0.57794e-03,0.55775e-03,0.24929e-03 /)
      kbo(:, 1,56, 7) = (/ &
        & 0.34572e-04,0.12819e-03,0.14868e-03,0.14747e-03,0.84103e-04 /)
      kbo(:, 2,56, 7) = (/ &
        & 0.40234e-04,0.16586e-03,0.19409e-03,0.19266e-03,0.10511e-03 /)
      kbo(:, 3,56, 7) = (/ &
        & 0.46756e-04,0.22079e-03,0.25905e-03,0.25536e-03,0.13228e-03 /)
      kbo(:, 4,56, 7) = (/ &
        & 0.54583e-04,0.30103e-03,0.35315e-03,0.34421e-03,0.16708e-03 /)
      kbo(:, 5,56, 7) = (/ &
        & 0.64414e-04,0.41471e-03,0.48701e-03,0.47045e-03,0.21139e-03 /)
      kbo(:, 1,57, 7) = (/ &
        & 0.27768e-04,0.10391e-03,0.12029e-03,0.11888e-03,0.68178e-04 /)
      kbo(:, 2,57, 7) = (/ &
        & 0.32463e-04,0.13502e-03,0.15785e-03,0.15684e-03,0.86073e-04 /)
      kbo(:, 3,57, 7) = (/ &
        & 0.37880e-04,0.18114e-03,0.21255e-03,0.20984e-03,0.10949e-03 /)
      kbo(:, 4,57, 7) = (/ &
        & 0.44374e-04,0.24914e-03,0.29262e-03,0.28609e-03,0.14004e-03 /)
      kbo(:, 5,57, 7) = (/ &
        & 0.52560e-04,0.34723e-03,0.40853e-03,0.39531e-03,0.17907e-03 /)
      kbo(:, 1,58, 7) = (/ &
        & 0.22293e-04,0.84410e-04,0.97318e-04,0.95954e-04,0.55246e-04 /)
      kbo(:, 2,58, 7) = (/ &
        & 0.26200e-04,0.11013e-03,0.12878e-03,0.12778e-03,0.70434e-04 /)
      kbo(:, 3,58, 7) = (/ &
        & 0.30694e-04,0.14878e-03,0.17475e-03,0.17269e-03,0.90681e-04 /)
      kbo(:, 4,58, 7) = (/ &
        & 0.36071e-04,0.20666e-03,0.24284e-03,0.23795e-03,0.11731e-03 /)
      kbo(:, 5,58, 7) = (/ &
        & 0.42845e-04,0.29161e-03,0.34322e-03,0.33267e-03,0.15208e-03 /)
      kbo(:, 1,59, 7) = (/ &
        & 0.18430e-04,0.71706e-04,0.82601e-04,0.81289e-04,0.46584e-04 /)
      kbo(:, 2,59, 7) = (/ &
        & 0.21734e-04,0.94599e-04,0.11060e-03,0.10958e-03,0.60168e-04 /)
      kbo(:, 3,59, 7) = (/ &
        & 0.25561e-04,0.12924e-03,0.15196e-03,0.15008e-03,0.78430e-04 /)
      kbo(:, 4,59, 7) = (/ &
        & 0.30185e-04,0.18220e-03,0.21420e-03,0.20980e-03,0.10280e-03 /)
      kbo(:, 5,59, 7) = (/ &
        & 0.36067e-04,0.26061e-03,0.30710e-03,0.29739e-03,0.13531e-03 /)
      kbo(:, 1,13, 8) = (/ &
        & 0.32299e+00,0.54760e+00,0.60079e+00,0.58517e+00,0.42276e+00 /)
      kbo(:, 2,13, 8) = (/ &
        & 0.32594e+00,0.55963e+00,0.61653e+00,0.60147e+00,0.43281e+00 /)
      kbo(:, 3,13, 8) = (/ &
        & 0.33056e+00,0.57182e+00,0.63236e+00,0.61863e+00,0.44149e+00 /)
      kbo(:, 4,13, 8) = (/ &
        & 0.33706e+00,0.58426e+00,0.64822e+00,0.63489e+00,0.44893e+00 /)
      kbo(:, 5,13, 8) = (/ &
        & 0.34635e+00,0.59739e+00,0.66343e+00,0.65003e+00,0.45486e+00 /)
      kbo(:, 1,14, 8) = (/ &
        & 0.27185e+00,0.47396e+00,0.52087e+00,0.50518e+00,0.35898e+00 /)
      kbo(:, 2,14, 8) = (/ &
        & 0.27455e+00,0.48454e+00,0.53473e+00,0.52058e+00,0.36725e+00 /)
      kbo(:, 3,14, 8) = (/ &
        & 0.27878e+00,0.49523e+00,0.54876e+00,0.53556e+00,0.37477e+00 /)
      kbo(:, 4,14, 8) = (/ &
        & 0.28540e+00,0.50660e+00,0.56244e+00,0.54948e+00,0.38095e+00 /)
      kbo(:, 5,14, 8) = (/ &
        & 0.29474e+00,0.51876e+00,0.57592e+00,0.56255e+00,0.38660e+00 /)
      kbo(:, 1,15, 8) = (/ &
        & 0.22818e+00,0.40825e+00,0.45003e+00,0.43582e+00,0.30350e+00 /)
      kbo(:, 2,15, 8) = (/ &
        & 0.23074e+00,0.41749e+00,0.46220e+00,0.44930e+00,0.31064e+00 /)
      kbo(:, 3,15, 8) = (/ &
        & 0.23510e+00,0.42737e+00,0.47434e+00,0.46202e+00,0.31696e+00 /)
      kbo(:, 4,15, 8) = (/ &
        & 0.24186e+00,0.43783e+00,0.48637e+00,0.47387e+00,0.32265e+00 /)
      kbo(:, 5,15, 8) = (/ &
        & 0.25121e+00,0.44943e+00,0.49855e+00,0.48519e+00,0.32816e+00 /)
      kbo(:, 1,16, 8) = (/ &
        & 0.19120e+00,0.34975e+00,0.38732e+00,0.37509e+00,0.25617e+00 /)
      kbo(:, 2,16, 8) = (/ &
        & 0.19385e+00,0.35826e+00,0.39799e+00,0.38666e+00,0.26259e+00 /)
      kbo(:, 3,16, 8) = (/ &
        & 0.19846e+00,0.36727e+00,0.40872e+00,0.39750e+00,0.26815e+00 /)
      kbo(:, 4,16, 8) = (/ &
        & 0.20537e+00,0.37712e+00,0.41954e+00,0.40777e+00,0.27330e+00 /)
      kbo(:, 5,16, 8) = (/ &
        & 0.21427e+00,0.38868e+00,0.43071e+00,0.41784e+00,0.27853e+00 /)
      kbo(:, 1,17, 8) = (/ &
        & 0.15988e+00,0.29854e+00,0.33180e+00,0.32201e+00,0.21611e+00 /)
      kbo(:, 2,17, 8) = (/ &
        & 0.16279e+00,0.30628e+00,0.34129e+00,0.33188e+00,0.22162e+00 /)
      kbo(:, 3,17, 8) = (/ &
        & 0.16763e+00,0.31463e+00,0.35085e+00,0.34122e+00,0.22664e+00 /)
      kbo(:, 4,17, 8) = (/ &
        & 0.17444e+00,0.32432e+00,0.36068e+00,0.35032e+00,0.23161e+00 /)
      kbo(:, 5,17, 8) = (/ &
        & 0.18274e+00,0.33609e+00,0.37140e+00,0.35944e+00,0.23665e+00 /)
      kbo(:, 1,18, 8) = (/ &
        & 0.13352e+00,0.25404e+00,0.28330e+00,0.27577e+00,0.18225e+00 /)
      kbo(:, 2,18, 8) = (/ &
        & 0.13667e+00,0.26103e+00,0.29171e+00,0.28431e+00,0.18712e+00 /)
      kbo(:, 3,18, 8) = (/ &
        & 0.14164e+00,0.26910e+00,0.30030e+00,0.29254e+00,0.19176e+00 /)
      kbo(:, 4,18, 8) = (/ &
        & 0.14809e+00,0.27886e+00,0.30959e+00,0.30073e+00,0.19637e+00 /)
      kbo(:, 5,18, 8) = (/ &
        & 0.15551e+00,0.29050e+00,0.32020e+00,0.30930e+00,0.20115e+00 /)
      kbo(:, 1,19, 8) = (/ &
        & 0.11177e+00,0.21580e+00,0.24136e+00,0.23552e+00,0.15392e+00 /)
      kbo(:, 2,19, 8) = (/ &
        & 0.11504e+00,0.22243e+00,0.24890e+00,0.24304e+00,0.15833e+00 /)
      kbo(:, 3,19, 8) = (/ &
        & 0.11975e+00,0.23031e+00,0.25687e+00,0.25048e+00,0.16244e+00 /)
      kbo(:, 4,19, 8) = (/ &
        & 0.12553e+00,0.23994e+00,0.26588e+00,0.25812e+00,0.16671e+00 /)
      kbo(:, 5,19, 8) = (/ &
        & 0.13204e+00,0.25107e+00,0.27639e+00,0.26629e+00,0.17110e+00 /)
      kbo(:, 1,20, 8) = (/ &
        & 0.93818e-01,0.18336e+00,0.20533e+00,0.20083e+00,0.13063e+00 /)
      kbo(:, 2,20, 8) = (/ &
        & 0.97153e-01,0.18975e+00,0.21222e+00,0.20754e+00,0.13445e+00 /)
      kbo(:, 3,20, 8) = (/ &
        & 0.10157e+00,0.19759e+00,0.21989e+00,0.21439e+00,0.13819e+00 /)
      kbo(:, 4,20, 8) = (/ &
        & 0.10656e+00,0.20692e+00,0.22885e+00,0.22170e+00,0.14200e+00 /)
      kbo(:, 5,20, 8) = (/ &
        & 0.11217e+00,0.21741e+00,0.23914e+00,0.22972e+00,0.14595e+00 /)
      kbo(:, 1,21, 8) = (/ &
        & 0.78864e-01,0.15581e+00,0.17467e+00,0.17111e+00,0.11093e+00 /)
      kbo(:, 2,21, 8) = (/ &
        & 0.82115e-01,0.16213e+00,0.18114e+00,0.17722e+00,0.11448e+00 /)
      kbo(:, 3,21, 8) = (/ &
        & 0.86091e-01,0.16989e+00,0.18858e+00,0.18368e+00,0.11795e+00 /)
      kbo(:, 4,21, 8) = (/ &
        & 0.90544e-01,0.17883e+00,0.19740e+00,0.19075e+00,0.12140e+00 /)
      kbo(:, 5,21, 8) = (/ &
        & 0.95531e-01,0.18857e+00,0.20719e+00,0.19872e+00,0.12494e+00 /)
      kbo(:, 1,22, 8) = (/ &
        & 0.66536e-01,0.13293e+00,0.14913e+00,0.14618e+00,0.94429e-01 /)
      kbo(:, 2,22, 8) = (/ &
        & 0.69639e-01,0.13931e+00,0.15537e+00,0.15187e+00,0.97680e-01 /)
      kbo(:, 3,22, 8) = (/ &
        & 0.73194e-01,0.14688e+00,0.16282e+00,0.15805e+00,0.10087e+00 /)
      kbo(:, 4,22, 8) = (/ &
        & 0.77205e-01,0.15536e+00,0.17135e+00,0.16503e+00,0.10414e+00 /)
      kbo(:, 5,22, 8) = (/ &
        & 0.81667e-01,0.16427e+00,0.18066e+00,0.17291e+00,0.10744e+00 /)
      kbo(:, 1,23, 8) = (/ &
        & 0.56261e-01,0.11383e+00,0.12760e+00,0.12512e+00,0.80559e-01 /)
      kbo(:, 2,23, 8) = (/ &
        & 0.59086e-01,0.12014e+00,0.13384e+00,0.13048e+00,0.83485e-01 /)
      kbo(:, 3,23, 8) = (/ &
        & 0.62281e-01,0.12738e+00,0.14121e+00,0.13648e+00,0.86460e-01 /)
      kbo(:, 4,23, 8) = (/ &
        & 0.65906e-01,0.13517e+00,0.14937e+00,0.14336e+00,0.89462e-01 /)
      kbo(:, 5,23, 8) = (/ &
        & 0.69998e-01,0.14335e+00,0.15807e+00,0.15098e+00,0.92588e-01 /)
      kbo(:, 1,24, 8) = (/ &
        & 0.47642e-01,0.97933e-01,0.10963e+00,0.10742e+00,0.68750e-01 /)
      kbo(:, 2,24, 8) = (/ &
        & 0.50193e-01,0.10399e+00,0.11587e+00,0.11258e+00,0.71432e-01 /)
      kbo(:, 3,24, 8) = (/ &
        & 0.53085e-01,0.11077e+00,0.12298e+00,0.11845e+00,0.74194e-01 /)
      kbo(:, 4,24, 8) = (/ &
        & 0.56384e-01,0.11795e+00,0.13070e+00,0.12512e+00,0.76973e-01 /)
      kbo(:, 5,24, 8) = (/ &
        & 0.60174e-01,0.12555e+00,0.13879e+00,0.13237e+00,0.79920e-01 /)
      kbo(:, 1,25, 8) = (/ &
        & 0.40432e-01,0.84645e-01,0.94724e-01,0.92637e-01,0.58805e-01 /)
      kbo(:, 2,25, 8) = (/ &
        & 0.42748e-01,0.90409e-01,0.10079e+00,0.97654e-01,0.61289e-01 /)
      kbo(:, 3,25, 8) = (/ &
        & 0.45392e-01,0.96682e-01,0.10756e+00,0.10341e+00,0.63818e-01 /)
      kbo(:, 4,25, 8) = (/ &
        & 0.48438e-01,0.10335e+00,0.11478e+00,0.10978e+00,0.66481e-01 /)
      kbo(:, 5,25, 8) = (/ &
        & 0.52019e-01,0.11050e+00,0.12234e+00,0.11664e+00,0.69209e-01 /)
      kbo(:, 1,26, 8) = (/ &
        & 0.34430e-01,0.73567e-01,0.82349e-01,0.80341e-01,0.50485e-01 /)
      kbo(:, 2,26, 8) = (/ &
        & 0.36558e-01,0.78997e-01,0.88163e-01,0.85293e-01,0.52835e-01 /)
      kbo(:, 3,26, 8) = (/ &
        & 0.39009e-01,0.84818e-01,0.94521e-01,0.90851e-01,0.55181e-01 /)
      kbo(:, 4,26, 8) = (/ &
        & 0.41876e-01,0.91074e-01,0.10127e+00,0.96922e-01,0.57644e-01 /)
      kbo(:, 5,26, 8) = (/ &
        & 0.45294e-01,0.97874e-01,0.10841e+00,0.10340e+00,0.60258e-01 /)
      kbo(:, 1,27, 8) = (/ &
        & 0.29418e-01,0.64289e-01,0.71984e-01,0.70112e-01,0.43514e-01 /)
      kbo(:, 2,27, 8) = (/ &
        & 0.31367e-01,0.69333e-01,0.77500e-01,0.74945e-01,0.45654e-01 /)
      kbo(:, 3,27, 8) = (/ &
        & 0.33650e-01,0.74779e-01,0.83451e-01,0.80284e-01,0.47838e-01 /)
      kbo(:, 4,27, 8) = (/ &
        & 0.36373e-01,0.80698e-01,0.89803e-01,0.86035e-01,0.50188e-01 /)
      kbo(:, 5,27, 8) = (/ &
        & 0.39625e-01,0.87227e-01,0.96605e-01,0.92163e-01,0.52661e-01 /)
      kbo(:, 1,28, 8) = (/ &
        & 0.25206e-01,0.56436e-01,0.63282e-01,0.61571e-01,0.37602e-01 /)
      kbo(:, 2,28, 8) = (/ &
        & 0.27009e-01,0.61147e-01,0.68481e-01,0.66237e-01,0.39562e-01 /)
      kbo(:, 3,28, 8) = (/ &
        & 0.29150e-01,0.66302e-01,0.74074e-01,0.71341e-01,0.41601e-01 /)
      kbo(:, 4,28, 8) = (/ &
        & 0.31750e-01,0.71955e-01,0.80104e-01,0.76785e-01,0.43794e-01 /)
      kbo(:, 5,28, 8) = (/ &
        & 0.34834e-01,0.78268e-01,0.86662e-01,0.82632e-01,0.46193e-01 /)
      kbo(:, 1,29, 8) = (/ &
        & 0.21672e-01,0.49821e-01,0.55985e-01,0.54431e-01,0.32677e-01 /)
      kbo(:, 2,29, 8) = (/ &
        & 0.23360e-01,0.54257e-01,0.60871e-01,0.58918e-01,0.34453e-01 /)
      kbo(:, 3,29, 8) = (/ &
        & 0.25420e-01,0.59159e-01,0.66168e-01,0.63765e-01,0.36398e-01 /)
      kbo(:, 4,29, 8) = (/ &
        & 0.27908e-01,0.64629e-01,0.71935e-01,0.68977e-01,0.38490e-01 /)
      kbo(:, 5,29, 8) = (/ &
        & 0.30843e-01,0.70791e-01,0.78323e-01,0.74610e-01,0.40747e-01 /)
      kbo(:, 1,30, 8) = (/ &
        & 0.18703e-01,0.44236e-01,0.49819e-01,0.48423e-01,0.28503e-01 /)
      kbo(:, 2,30, 8) = (/ &
        & 0.20315e-01,0.48445e-01,0.54425e-01,0.52720e-01,0.30174e-01 /)
      kbo(:, 3,30, 8) = (/ &
        & 0.22307e-01,0.53163e-01,0.59481e-01,0.57359e-01,0.32018e-01 /)
      kbo(:, 4,30, 8) = (/ &
        & 0.24687e-01,0.58495e-01,0.65064e-01,0.62368e-01,0.34022e-01 /)
      kbo(:, 5,30, 8) = (/ &
        & 0.27510e-01,0.64597e-01,0.71352e-01,0.67860e-01,0.36243e-01 /)
      kbo(:, 1,31, 8) = (/ &
        & 0.16227e-01,0.39546e-01,0.44613e-01,0.43384e-01,0.24947e-01 /)
      kbo(:, 2,31, 8) = (/ &
        & 0.17791e-01,0.43576e-01,0.49010e-01,0.47501e-01,0.26577e-01 /)
      kbo(:, 3,31, 8) = (/ &
        & 0.19720e-01,0.48163e-01,0.53877e-01,0.51962e-01,0.28347e-01 /)
      kbo(:, 4,31, 8) = (/ &
        & 0.22010e-01,0.53419e-01,0.59368e-01,0.56842e-01,0.30326e-01 /)
      kbo(:, 5,31, 8) = (/ &
        & 0.24778e-01,0.59533e-01,0.65582e-01,0.62279e-01,0.32464e-01 /)
      kbo(:, 1,32, 8) = (/ &
        & 0.14168e-01,0.35610e-01,0.40228e-01,0.39145e-01,0.21998e-01 /)
      kbo(:, 2,32, 8) = (/ &
        & 0.15701e-01,0.39518e-01,0.44455e-01,0.43108e-01,0.23551e-01 /)
      kbo(:, 3,32, 8) = (/ &
        & 0.17568e-01,0.44028e-01,0.49228e-01,0.47442e-01,0.25303e-01 /)
      kbo(:, 4,32, 8) = (/ &
        & 0.19822e-01,0.49274e-01,0.54644e-01,0.52269e-01,0.27219e-01 /)
      kbo(:, 5,32, 8) = (/ &
        & 0.22492e-01,0.55429e-01,0.60878e-01,0.57696e-01,0.29289e-01 /)
      kbo(:, 1,33, 8) = (/ &
        & 0.12469e-01,0.32321e-01,0.36548e-01,0.35586e-01,0.19535e-01 /)
      kbo(:, 2,33, 8) = (/ &
        & 0.13967e-01,0.36160e-01,0.40670e-01,0.39414e-01,0.21057e-01 /)
      kbo(:, 3,33, 8) = (/ &
        & 0.15804e-01,0.40646e-01,0.45371e-01,0.43697e-01,0.22748e-01 /)
      kbo(:, 4,33, 8) = (/ &
        & 0.18007e-01,0.45935e-01,0.50790e-01,0.48504e-01,0.24589e-01 /)
      kbo(:, 5,33, 8) = (/ &
        & 0.20583e-01,0.52117e-01,0.57083e-01,0.53949e-01,0.26612e-01 /)
      kbo(:, 1,34, 8) = (/ &
        & 0.11030e-01,0.29462e-01,0.33333e-01,0.32457e-01,0.17441e-01 /)
      kbo(:, 2,34, 8) = (/ &
        & 0.12485e-01,0.33252e-01,0.37374e-01,0.36203e-01,0.18902e-01 /)
      kbo(:, 3,34, 8) = (/ &
        & 0.14284e-01,0.37735e-01,0.42039e-01,0.40449e-01,0.20533e-01 /)
      kbo(:, 4,34, 8) = (/ &
        & 0.16406e-01,0.43050e-01,0.47473e-01,0.45250e-01,0.22315e-01 /)
      kbo(:, 5,34, 8) = (/ &
        & 0.18889e-01,0.49221e-01,0.53838e-01,0.50709e-01,0.24295e-01 /)
      kbo(:, 1,35, 8) = (/ &
        & 0.97045e-02,0.26765e-01,0.30294e-01,0.29494e-01,0.15527e-01 /)
      kbo(:, 2,35, 8) = (/ &
        & 0.11116e-01,0.30471e-01,0.34237e-01,0.33156e-01,0.16936e-01 /)
      kbo(:, 3,35, 8) = (/ &
        & 0.12833e-01,0.34908e-01,0.38827e-01,0.37335e-01,0.18494e-01 /)
      kbo(:, 4,35, 8) = (/ &
        & 0.14851e-01,0.40160e-01,0.44228e-01,0.42095e-01,0.20230e-01 /)
      kbo(:, 5,35, 8) = (/ &
        & 0.17220e-01,0.46275e-01,0.50600e-01,0.47524e-01,0.22137e-01 /)
      kbo(:, 1,36, 8) = (/ &
        & 0.84787e-02,0.24131e-01,0.27339e-01,0.26619e-01,0.13756e-01 /)
      kbo(:, 2,36, 8) = (/ &
        & 0.98033e-02,0.27706e-01,0.31147e-01,0.30166e-01,0.15106e-01 /)
      kbo(:, 3,36, 8) = (/ &
        & 0.11407e-01,0.32015e-01,0.35610e-01,0.34239e-01,0.16593e-01 /)
      kbo(:, 4,36, 8) = (/ &
        & 0.13302e-01,0.37140e-01,0.40907e-01,0.38904e-01,0.18257e-01 /)
      kbo(:, 5,36, 8) = (/ &
        & 0.15537e-01,0.43129e-01,0.47182e-01,0.44236e-01,0.20074e-01 /)
      kbo(:, 1,37, 8) = (/ &
        & 0.72685e-02,0.21392e-01,0.24301e-01,0.23679e-01,0.12087e-01 /)
      kbo(:, 2,37, 8) = (/ &
        & 0.84733e-02,0.24759e-01,0.27898e-01,0.27046e-01,0.13342e-01 /)
      kbo(:, 3,37, 8) = (/ &
        & 0.99353e-02,0.28848e-01,0.32152e-01,0.30940e-01,0.14748e-01 /)
      kbo(:, 4,37, 8) = (/ &
        & 0.11673e-01,0.33734e-01,0.37224e-01,0.35422e-01,0.16319e-01 /)
      kbo(:, 5,37, 8) = (/ &
        & 0.13740e-01,0.39481e-01,0.43256e-01,0.40566e-01,0.18049e-01 /)
      kbo(:, 1,38, 8) = (/ &
        & 0.62326e-02,0.18999e-01,0.21644e-01,0.21103e-01,0.10629e-01 /)
      kbo(:, 2,38, 8) = (/ &
        & 0.73269e-02,0.22170e-01,0.25042e-01,0.24299e-01,0.11807e-01 /)
      kbo(:, 3,38, 8) = (/ &
        & 0.86586e-02,0.26045e-01,0.29098e-01,0.28019e-01,0.13138e-01 /)
      kbo(:, 4,38, 8) = (/ &
        & 0.10254e-01,0.30699e-01,0.33952e-01,0.32316e-01,0.14621e-01 /)
      kbo(:, 5,38, 8) = (/ &
        & 0.12168e-01,0.36211e-01,0.39748e-01,0.37288e-01,0.16263e-01 /)
      kbo(:, 1,39, 8) = (/ &
        & 0.53522e-02,0.16925e-01,0.19337e-01,0.18863e-01,0.93697e-02 /)
      kbo(:, 2,39, 8) = (/ &
        & 0.63437e-02,0.19916e-01,0.22555e-01,0.21900e-01,0.10477e-01 /)
      kbo(:, 3,39, 8) = (/ &
        & 0.75600e-02,0.23590e-01,0.26428e-01,0.25453e-01,0.11732e-01 /)
      kbo(:, 4,39, 8) = (/ &
        & 0.90277e-02,0.28027e-01,0.31081e-01,0.29581e-01,0.13140e-01 /)
      kbo(:, 5,39, 8) = (/ &
        & 0.10804e-01,0.33325e-01,0.36655e-01,0.34396e-01,0.14714e-01 /)
      kbo(:, 1,40, 8) = (/ &
        & 0.45183e-02,0.14862e-01,0.17043e-01,0.16640e-01,0.81906e-02 /)
      kbo(:, 2,40, 8) = (/ &
        & 0.53964e-02,0.17630e-01,0.20043e-01,0.19482e-01,0.92335e-02 /)
      kbo(:, 3,40, 8) = (/ &
        & 0.64835e-02,0.21041e-01,0.23674e-01,0.22821e-01,0.10400e-01 /)
      kbo(:, 4,40, 8) = (/ &
        & 0.78100e-02,0.25197e-01,0.28056e-01,0.26733e-01,0.11718e-01 /)
      kbo(:, 5,40, 8) = (/ &
        & 0.94310e-02,0.30203e-01,0.33322e-01,0.31321e-01,0.13209e-01 /)
      kbo(:, 1,41, 8) = (/ &
        & 0.38020e-02,0.13035e-01,0.15007e-01,0.14665e-01,0.71645e-02 /)
      kbo(:, 2,41, 8) = (/ &
        & 0.45796e-02,0.15592e-01,0.17802e-01,0.17320e-01,0.81332e-02 /)
      kbo(:, 3,41, 8) = (/ &
        & 0.55464e-02,0.18749e-01,0.21191e-01,0.20448e-01,0.92312e-02 /)
      kbo(:, 4,41, 8) = (/ &
        & 0.67408e-02,0.22629e-01,0.25309e-01,0.24143e-01,0.10458e-01 /)
      kbo(:, 5,41, 8) = (/ &
        & 0.82155e-02,0.27347e-01,0.30277e-01,0.28506e-01,0.11871e-01 /)
      kbo(:, 1,42, 8) = (/ &
        & 0.31962e-02,0.11444e-01,0.13229e-01,0.12937e-01,0.62788e-02 /)
      kbo(:, 2,42, 8) = (/ &
        & 0.38815e-02,0.13798e-01,0.15822e-01,0.15407e-01,0.71774e-02 /)
      kbo(:, 3,42, 8) = (/ &
        & 0.47422e-02,0.16722e-01,0.18990e-01,0.18339e-01,0.81986e-02 /)
      kbo(:, 4,42, 8) = (/ &
        & 0.58154e-02,0.20342e-01,0.22857e-01,0.21830e-01,0.93594e-02 /)
      kbo(:, 5,42, 8) = (/ &
        & 0.71546e-02,0.24787e-01,0.27545e-01,0.25973e-01,0.10684e-01 /)
      kbo(:, 1,43, 8) = (/ &
        & 0.26542e-02,0.99421e-02,0.11545e-01,0.11297e-01,0.54681e-02 /)
      kbo(:, 2,43, 8) = (/ &
        & 0.32467e-02,0.12085e-01,0.13926e-01,0.13575e-01,0.63017e-02 /)
      kbo(:, 3,43, 8) = (/ &
        & 0.40037e-02,0.14758e-01,0.16848e-01,0.16296e-01,0.72434e-02 /)
      kbo(:, 4,43, 8) = (/ &
        & 0.49534e-02,0.18094e-01,0.20438e-01,0.19556e-01,0.83354e-02 /)
      kbo(:, 5,43, 8) = (/ &
        & 0.61525e-02,0.22230e-01,0.24817e-01,0.23450e-01,0.95751e-02 /)
      kbo(:, 1,44, 8) = (/ &
        & 0.21881e-02,0.85857e-02,0.10019e-01,0.98043e-02,0.47456e-02 /)
      kbo(:, 2,44, 8) = (/ &
        & 0.26937e-02,0.10525e-01,0.12192e-01,0.11898e-01,0.55168e-02 /)
      kbo(:, 3,44, 8) = (/ &
        & 0.33531e-02,0.12952e-01,0.14870e-01,0.14408e-01,0.63938e-02 /)
      kbo(:, 4,44, 8) = (/ &
        & 0.41916e-02,0.16016e-01,0.18187e-01,0.17441e-01,0.73995e-02 /)
      kbo(:, 5,44, 8) = (/ &
        & 0.52529e-02,0.19825e-01,0.22245e-01,0.21074e-01,0.85693e-02 /)
      kbo(:, 1,45, 8) = (/ &
        & 0.17974e-02,0.74036e-02,0.86819e-02,0.84949e-02,0.41100e-02 /)
      kbo(:, 2,45, 8) = (/ &
        & 0.22283e-02,0.91556e-02,0.10664e-01,0.10414e-01,0.48257e-02 /)
      kbo(:, 3,45, 8) = (/ &
        & 0.27993e-02,0.11360e-01,0.13115e-01,0.12731e-01,0.56423e-02 /)
      kbo(:, 4,45, 8) = (/ &
        & 0.35358e-02,0.14164e-01,0.16170e-01,0.15543e-01,0.65867e-02 /)
      kbo(:, 5,45, 8) = (/ &
        & 0.44762e-02,0.17671e-01,0.19928e-01,0.18931e-01,0.76725e-02 /)
      kbo(:, 1,46, 8) = (/ &
        & 0.14666e-02,0.63443e-02,0.74710e-02,0.73099e-02,0.35540e-02 /)
      kbo(:, 2,46, 8) = (/ &
        & 0.18286e-02,0.79140e-02,0.92719e-02,0.90588e-02,0.41981e-02 /)
      kbo(:, 3,46, 8) = (/ &
        & 0.23196e-02,0.99089e-02,0.11508e-01,0.11192e-01,0.49656e-02 /)
      kbo(:, 4,46, 8) = (/ &
        & 0.29575e-02,0.12451e-01,0.14296e-01,0.13779e-01,0.58441e-02 /)
      kbo(:, 5,46, 8) = (/ &
        & 0.37842e-02,0.15662e-01,0.17758e-01,0.16921e-01,0.68660e-02 /)
      kbo(:, 1,47, 8) = (/ &
        & 0.11822e-02,0.53700e-02,0.63483e-02,0.62090e-02,0.30500e-02 /)
      kbo(:, 2,47, 8) = (/ &
        & 0.14817e-02,0.67616e-02,0.79678e-02,0.77874e-02,0.36317e-02 /)
      kbo(:, 3,47, 8) = (/ &
        & 0.18918e-02,0.85392e-02,0.99818e-02,0.97254e-02,0.43248e-02 /)
      kbo(:, 4,47, 8) = (/ &
        & 0.24382e-02,0.10820e-01,0.12503e-01,0.12088e-01,0.51477e-02 /)
      kbo(:, 5,47, 8) = (/ &
        & 0.31533e-02,0.13725e-01,0.15656e-01,0.14970e-01,0.61000e-02 /)
      kbo(:, 1,48, 8) = (/ &
        & 0.94906e-03,0.45298e-02,0.53706e-02,0.52506e-02,0.26162e-02 /)
      kbo(:, 2,48, 8) = (/ &
        & 0.11965e-02,0.57597e-02,0.68213e-02,0.66698e-02,0.31403e-02 /)
      kbo(:, 3,48, 8) = (/ &
        & 0.15369e-02,0.73380e-02,0.86368e-02,0.84246e-02,0.37687e-02 /)
      kbo(:, 4,48, 8) = (/ &
        & 0.20008e-02,0.93814e-02,0.10911e-01,0.10580e-01,0.45213e-02 /)
      kbo(:, 5,48, 8) = (/ &
        & 0.26159e-02,0.12002e-01,0.13774e-01,0.13221e-01,0.54142e-02 /)
      kbo(:, 1,49, 8) = (/ &
        & 0.75913e-03,0.38043e-02,0.45203e-02,0.44181e-02,0.22379e-02 /)
      kbo(:, 2,49, 8) = (/ &
        & 0.96097e-03,0.48899e-02,0.58138e-02,0.56878e-02,0.27098e-02 /)
      kbo(:, 3,49, 8) = (/ &
        & 0.12447e-02,0.62895e-02,0.74501e-02,0.72727e-02,0.32859e-02 /)
      kbo(:, 4,49, 8) = (/ &
        & 0.16322e-02,0.81122e-02,0.94989e-02,0.92349e-02,0.39720e-02 /)
      kbo(:, 5,49, 8) = (/ &
        & 0.21597e-02,0.10470e-01,0.12092e-01,0.11650e-01,0.47938e-02 /)
      kbo(:, 1,50, 8) = (/ &
        & 0.60949e-03,0.32009e-02,0.38080e-02,0.37204e-02,0.19148e-02 /)
      kbo(:, 2,50, 8) = (/ &
        & 0.77332e-03,0.41637e-02,0.49658e-02,0.48588e-02,0.23498e-02 /)
      kbo(:, 3,50, 8) = (/ &
        & 0.10099e-02,0.54095e-02,0.64416e-02,0.62938e-02,0.28713e-02 /)
      kbo(:, 4,50, 8) = (/ &
        & 0.13353e-02,0.70417e-02,0.83004e-02,0.80844e-02,0.35114e-02 /)
      kbo(:, 5,50, 8) = (/ &
        & 0.17873e-02,0.91691e-02,0.10658e-01,0.10303e-01,0.42641e-02 /)
      kbo(:, 1,51, 8) = (/ &
        & 0.48960e-03,0.26873e-02,0.32008e-02,0.31259e-02,0.16378e-02 /)
      kbo(:, 2,51, 8) = (/ &
        & 0.62187e-03,0.35423e-02,0.42349e-02,0.41443e-02,0.20325e-02 /)
      kbo(:, 3,51, 8) = (/ &
        & 0.81788e-03,0.46529e-02,0.55656e-02,0.54424e-02,0.25164e-02 /)
      kbo(:, 4,51, 8) = (/ &
        & 0.10935e-02,0.61155e-02,0.72565e-02,0.70765e-02,0.31007e-02 /)
      kbo(:, 5,51, 8) = (/ &
        & 0.14776e-02,0.80416e-02,0.94087e-02,0.91197e-02,0.38085e-02 /)
      kbo(:, 1,52, 8) = (/ &
        & 0.39302e-03,0.22435e-02,0.26754e-02,0.26122e-02,0.13898e-02 /)
      kbo(:, 2,52, 8) = (/ &
        & 0.49889e-03,0.30006e-02,0.35943e-02,0.35172e-02,0.17532e-02 /)
      kbo(:, 3,52, 8) = (/ &
        & 0.65922e-03,0.39906e-02,0.47901e-02,0.46880e-02,0.21980e-02 /)
      kbo(:, 4,52, 8) = (/ &
        & 0.89075e-03,0.52980e-02,0.63237e-02,0.61748e-02,0.27412e-02 /)
      kbo(:, 5,52, 8) = (/ &
        & 0.12150e-02,0.70312e-02,0.82837e-02,0.80497e-02,0.33956e-02 /)
      kbo(:, 1,53, 8) = (/ &
        & 0.31533e-03,0.18598e-02,0.22216e-02,0.21690e-02,0.11705e-02 /)
      kbo(:, 2,53, 8) = (/ &
        & 0.39919e-03,0.25290e-02,0.30338e-02,0.29679e-02,0.15051e-02 /)
      kbo(:, 3,53, 8) = (/ &
        & 0.52958e-03,0.34096e-02,0.41030e-02,0.40189e-02,0.19137e-02 /)
      kbo(:, 4,53, 8) = (/ &
        & 0.72147e-03,0.45756e-02,0.54894e-02,0.53678e-02,0.24147e-02 /)
      kbo(:, 5,53, 8) = (/ &
        & 0.99563e-03,0.61321e-02,0.72739e-02,0.70826e-02,0.30286e-02 /)
      kbo(:, 1,54, 8) = (/ &
        & 0.25434e-03,0.15477e-02,0.18502e-02,0.18075e-02,0.98891e-03 /)
      kbo(:, 2,54, 8) = (/ &
        & 0.32221e-03,0.21398e-02,0.25708e-02,0.25148e-02,0.12935e-02 /)
      kbo(:, 3,54, 8) = (/ &
        & 0.42775e-03,0.29272e-02,0.35315e-02,0.34599e-02,0.16741e-02 /)
      kbo(:, 4,54, 8) = (/ &
        & 0.58762e-03,0.39761e-02,0.47907e-02,0.46896e-02,0.21376e-02 /)
      kbo(:, 5,54, 8) = (/ &
        & 0.82053e-03,0.53824e-02,0.64244e-02,0.62664e-02,0.27173e-02 /)
      kbo(:, 1,55, 8) = (/ &
        & 0.20618e-03,0.12866e-02,0.15400e-02,0.15055e-02,0.83572e-03 /)
      kbo(:, 2,55, 8) = (/ &
        & 0.26059e-03,0.18094e-02,0.21787e-02,0.21302e-02,0.11090e-02 /)
      kbo(:, 3,55, 8) = (/ &
        & 0.34651e-03,0.25140e-02,0.30392e-02,0.29780e-02,0.14628e-02 /)
      kbo(:, 4,55, 8) = (/ &
        & 0.47882e-03,0.34608e-02,0.41831e-02,0.41003e-02,0.18992e-02 /)
      kbo(:, 5,55, 8) = (/ &
        & 0.67671e-03,0.47331e-02,0.56817e-02,0.55503e-02,0.24360e-02 /)
      kbo(:, 1,56, 8) = (/ &
        & 0.16681e-03,0.10621e-02,0.12728e-02,0.12461e-02,0.70162e-03 /)
      kbo(:, 2,56, 8) = (/ &
        & 0.21064e-03,0.15213e-02,0.18350e-02,0.17945e-02,0.94828e-03 /)
      kbo(:, 3,56, 8) = (/ &
        & 0.28028e-03,0.21500e-02,0.26045e-02,0.25521e-02,0.12721e-02 /)
      kbo(:, 4,56, 8) = (/ &
        & 0.38906e-03,0.30029e-02,0.36387e-02,0.35710e-02,0.16833e-02 /)
      kbo(:, 5,56, 8) = (/ &
        & 0.55568e-03,0.41534e-02,0.50111e-02,0.49027e-02,0.21849e-02 /)
      kbo(:, 1,57, 8) = (/ &
        & 0.13484e-03,0.87168e-03,0.10444e-02,0.10248e-02,0.58516e-03 /)
      kbo(:, 2,57, 8) = (/ &
        & 0.17007e-03,0.12717e-02,0.15360e-02,0.15024e-02,0.80805e-03 /)
      kbo(:, 3,57, 8) = (/ &
        & 0.22603e-03,0.18296e-02,0.22211e-02,0.21757e-02,0.11006e-02 /)
      kbo(:, 4,57, 8) = (/ &
        & 0.31565e-03,0.25963e-02,0.31531e-02,0.30959e-02,0.14851e-02 /)
      kbo(:, 5,57, 8) = (/ &
        & 0.45417e-03,0.36365e-02,0.44058e-02,0.43157e-02,0.19625e-02 /)
      kbo(:, 1,58, 8) = (/ &
        & 0.10938e-03,0.71449e-03,0.85655e-03,0.84240e-03,0.48772e-03 /)
      kbo(:, 2,58, 8) = (/ &
        & 0.13752e-03,0.10624e-02,0.12849e-02,0.12583e-02,0.68689e-03 /)
      kbo(:, 3,58, 8) = (/ &
        & 0.18307e-03,0.15572e-02,0.18954e-02,0.18566e-02,0.95344e-03 /)
      kbo(:, 4,58, 8) = (/ &
        & 0.25673e-03,0.22481e-02,0.27363e-02,0.26877e-02,0.13079e-02 /)
      kbo(:, 5,58, 8) = (/ &
        & 0.37230e-03,0.31921e-02,0.38812e-02,0.38070e-02,0.17570e-02 /)
      kbo(:, 1,59, 8) = (/ &
        & 0.92153e-04,0.62798e-03,0.75374e-03,0.74243e-03,0.43161e-03 /)
      kbo(:, 2,59, 8) = (/ &
        & 0.11676e-03,0.95019e-03,0.11525e-02,0.11296e-02,0.61959e-03 /)
      kbo(:, 3,59, 8) = (/ &
        & 0.15687e-03,0.14168e-02,0.17285e-02,0.16938e-02,0.87468e-03 /)
      kbo(:, 4,59, 8) = (/ &
        & 0.22278e-03,0.20743e-02,0.25302e-02,0.24863e-02,0.12161e-02 /)
      kbo(:, 5,59, 8) = (/ &
        & 0.32724e-03,0.29797e-02,0.36313e-02,0.35664e-02,0.16577e-02 /)
      kbo(:, 1,13, 9) = (/ &
        & 0.16403e+01,0.27290e+01,0.31326e+01,0.31890e+01,0.23307e+01 /)
      kbo(:, 2,13, 9) = (/ &
        & 0.16862e+01,0.27611e+01,0.31617e+01,0.32226e+01,0.23816e+01 /)
      kbo(:, 3,13, 9) = (/ &
        & 0.17455e+01,0.28101e+01,0.32005e+01,0.32552e+01,0.24291e+01 /)
      kbo(:, 4,13, 9) = (/ &
        & 0.18100e+01,0.28758e+01,0.32471e+01,0.32901e+01,0.24729e+01 /)
      kbo(:, 5,13, 9) = (/ &
        & 0.18736e+01,0.29528e+01,0.33027e+01,0.33291e+01,0.25126e+01 /)
      kbo(:, 1,14, 9) = (/ &
        & 0.14276e+01,0.24116e+01,0.27645e+01,0.28207e+01,0.20786e+01 /)
      kbo(:, 2,14, 9) = (/ &
        & 0.14761e+01,0.24553e+01,0.28027e+01,0.28564e+01,0.21275e+01 /)
      kbo(:, 3,14, 9) = (/ &
        & 0.15303e+01,0.25161e+01,0.28501e+01,0.28940e+01,0.21750e+01 /)
      kbo(:, 4,14, 9) = (/ &
        & 0.15845e+01,0.25879e+01,0.29061e+01,0.29354e+01,0.22167e+01 /)
      kbo(:, 5,14, 9) = (/ &
        & 0.16378e+01,0.26632e+01,0.29707e+01,0.29827e+01,0.22552e+01 /)
      kbo(:, 1,15, 9) = (/ &
        & 0.12454e+01,0.21329e+01,0.24382e+01,0.24839e+01,0.18332e+01 /)
      kbo(:, 2,15, 9) = (/ &
        & 0.12895e+01,0.21869e+01,0.24841e+01,0.25234e+01,0.18816e+01 /)
      kbo(:, 3,15, 9) = (/ &
        & 0.13344e+01,0.22528e+01,0.25385e+01,0.25663e+01,0.19251e+01 /)
      kbo(:, 4,15, 9) = (/ &
        & 0.13794e+01,0.23234e+01,0.26021e+01,0.26153e+01,0.19652e+01 /)
      kbo(:, 5,15, 9) = (/ &
        & 0.14250e+01,0.23931e+01,0.26727e+01,0.26688e+01,0.20043e+01 /)
      kbo(:, 1,16, 9) = (/ &
        & 0.10848e+01,0.18880e+01,0.21511e+01,0.21813e+01,0.16071e+01 /)
      kbo(:, 2,16, 9) = (/ &
        & 0.11214e+01,0.19471e+01,0.22027e+01,0.22246e+01,0.16520e+01 /)
      kbo(:, 3,16, 9) = (/ &
        & 0.11587e+01,0.20122e+01,0.22636e+01,0.22737e+01,0.16924e+01 /)
      kbo(:, 4,16, 9) = (/ &
        & 0.11968e+01,0.20768e+01,0.23313e+01,0.23282e+01,0.17327e+01 /)
      kbo(:, 5,16, 9) = (/ &
        & 0.12369e+01,0.21393e+01,0.24028e+01,0.23861e+01,0.17713e+01 /)
      kbo(:, 1,17, 9) = (/ &
        & 0.94054e+00,0.16727e+01,0.18972e+01,0.19128e+01,0.14046e+01 /)
      kbo(:, 2,17, 9) = (/ &
        & 0.97101e+00,0.17314e+01,0.19542e+01,0.19610e+01,0.14464e+01 /)
      kbo(:, 3,17, 9) = (/ &
        & 0.10024e+01,0.17905e+01,0.20183e+01,0.20147e+01,0.14867e+01 /)
      kbo(:, 4,17, 9) = (/ &
        & 0.10357e+01,0.18485e+01,0.20868e+01,0.20722e+01,0.15247e+01 /)
      kbo(:, 5,17, 9) = (/ &
        & 0.10722e+01,0.19059e+01,0.21551e+01,0.21344e+01,0.15620e+01 /)
      kbo(:, 1,18, 9) = (/ &
        & 0.81293e+00,0.14815e+01,0.16736e+01,0.16776e+01,0.12272e+01 /)
      kbo(:, 2,18, 9) = (/ &
        & 0.83847e+00,0.15352e+01,0.17337e+01,0.17293e+01,0.12665e+01 /)
      kbo(:, 3,18, 9) = (/ &
        & 0.86557e+00,0.15883e+01,0.17983e+01,0.17854e+01,0.13052e+01 /)
      kbo(:, 4,18, 9) = (/ &
        & 0.89549e+00,0.16413e+01,0.18633e+01,0.18465e+01,0.13420e+01 /)
      kbo(:, 5,18, 9) = (/ &
        & 0.92973e+00,0.16952e+01,0.19268e+01,0.19102e+01,0.13778e+01 /)
      kbo(:, 1,19, 9) = (/ &
        & 0.70038e+00,0.13093e+01,0.14779e+01,0.14733e+01,0.10709e+01 /)
      kbo(:, 2,19, 9) = (/ &
        & 0.72263e+00,0.13577e+01,0.15381e+01,0.15268e+01,0.11090e+01 /)
      kbo(:, 3,19, 9) = (/ &
        & 0.74709e+00,0.14065e+01,0.15995e+01,0.15853e+01,0.11457e+01 /)
      kbo(:, 4,19, 9) = (/ &
        & 0.77505e+00,0.14562e+01,0.16599e+01,0.16467e+01,0.11819e+01 /)
      kbo(:, 5,19, 9) = (/ &
        & 0.80778e+00,0.15082e+01,0.17205e+01,0.17095e+01,0.12170e+01 /)
      kbo(:, 1,20, 9) = (/ &
        & 0.60096e+00,0.11549e+01,0.13070e+01,0.12966e+01,0.93504e+00 /)
      kbo(:, 2,20, 9) = (/ &
        & 0.62117e+00,0.11996e+01,0.13644e+01,0.13518e+01,0.97145e+00 /)
      kbo(:, 3,20, 9) = (/ &
        & 0.64437e+00,0.12456e+01,0.14215e+01,0.14105e+01,0.10075e+01 /)
      kbo(:, 4,20, 9) = (/ &
        & 0.67172e+00,0.12935e+01,0.14792e+01,0.14711e+01,0.10425e+01 /)
      kbo(:, 5,20, 9) = (/ &
        & 0.70425e+00,0.13447e+01,0.15379e+01,0.15320e+01,0.10771e+01 /)
      kbo(:, 1,21, 9) = (/ &
        & 0.51409e+00,0.10184e+01,0.11562e+01,0.11440e+01,0.81589e+00 /)
      kbo(:, 2,21, 9) = (/ &
        & 0.53296e+00,0.10604e+01,0.12096e+01,0.11991e+01,0.85095e+00 /)
      kbo(:, 3,21, 9) = (/ &
        & 0.55527e+00,0.11043e+01,0.12638e+01,0.12567e+01,0.88570e+00 /)
      kbo(:, 4,21, 9) = (/ &
        & 0.58243e+00,0.11512e+01,0.13194e+01,0.13151e+01,0.92023e+00 /)
      kbo(:, 5,21, 9) = (/ &
        & 0.61501e+00,0.12017e+01,0.13771e+01,0.13737e+01,0.95470e+00 /)
      kbo(:, 1,22, 9) = (/ &
        & 0.44038e+00,0.90186e+00,0.10262e+01,0.10153e+01,0.71382e+00 /)
      kbo(:, 2,22, 9) = (/ &
        & 0.45853e+00,0.94198e+00,0.10770e+01,0.10695e+01,0.74736e+00 /)
      kbo(:, 3,22, 9) = (/ &
        & 0.48068e+00,0.98449e+00,0.11290e+01,0.11248e+01,0.78150e+00 /)
      kbo(:, 4,22, 9) = (/ &
        & 0.50812e+00,0.10306e+01,0.11833e+01,0.11809e+01,0.81518e+00 /)
      kbo(:, 5,22, 9) = (/ &
        & 0.54141e+00,0.10817e+01,0.12405e+01,0.12383e+01,0.84849e+00 /)
      kbo(:, 1,23, 9) = (/ &
        & 0.37767e+00,0.80078e+00,0.91306e+00,0.90433e+00,0.62612e+00 /)
      kbo(:, 2,23, 9) = (/ &
        & 0.39558e+00,0.83957e+00,0.96154e+00,0.95658e+00,0.65837e+00 /)
      kbo(:, 3,23, 9) = (/ &
        & 0.41794e+00,0.88149e+00,0.10123e+01,0.10097e+01,0.69117e+00 /)
      kbo(:, 4,23, 9) = (/ &
        & 0.44579e+00,0.92784e+00,0.10657e+01,0.10643e+01,0.72352e+00 /)
      kbo(:, 5,23, 9) = (/ &
        & 0.47930e+00,0.97981e+00,0.11229e+01,0.11209e+01,0.75697e+00 /)
      kbo(:, 1,24, 9) = (/ &
        & 0.32501e+00,0.71314e+00,0.81551e+00,0.80817e+00,0.55055e+00 /)
      kbo(:, 2,24, 9) = (/ &
        & 0.34301e+00,0.75171e+00,0.86229e+00,0.85830e+00,0.58144e+00 /)
      kbo(:, 3,24, 9) = (/ &
        & 0.36572e+00,0.79385e+00,0.91196e+00,0.91014e+00,0.61242e+00 /)
      kbo(:, 4,24, 9) = (/ &
        & 0.39391e+00,0.84084e+00,0.96525e+00,0.96386e+00,0.64468e+00 /)
      kbo(:, 5,24, 9) = (/ &
        & 0.42682e+00,0.89378e+00,0.10230e+01,0.10202e+01,0.67755e+00 /)
      kbo(:, 1,25, 9) = (/ &
        & 0.28120e+00,0.63782e+00,0.73197e+00,0.72532e+00,0.48624e+00 /)
      kbo(:, 2,25, 9) = (/ &
        & 0.29939e+00,0.67672e+00,0.77772e+00,0.77395e+00,0.51566e+00 /)
      kbo(:, 3,25, 9) = (/ &
        & 0.32259e+00,0.71969e+00,0.82682e+00,0.82484e+00,0.54562e+00 /)
      kbo(:, 4,25, 9) = (/ &
        & 0.35054e+00,0.76785e+00,0.88040e+00,0.87836e+00,0.57709e+00 /)
      kbo(:, 5,25, 9) = (/ &
        & 0.38231e+00,0.82200e+00,0.93896e+00,0.93503e+00,0.60997e+00 /)
      kbo(:, 1,26, 9) = (/ &
        & 0.24516e+00,0.57415e+00,0.66146e+00,0.65501e+00,0.43198e+00 /)
      kbo(:, 2,26, 9) = (/ &
        & 0.26380e+00,0.61364e+00,0.70651e+00,0.70261e+00,0.46025e+00 /)
      kbo(:, 3,26, 9) = (/ &
        & 0.28716e+00,0.65790e+00,0.75577e+00,0.75300e+00,0.48987e+00 /)
      kbo(:, 4,26, 9) = (/ &
        & 0.31438e+00,0.70747e+00,0.80990e+00,0.80672e+00,0.52086e+00 /)
      kbo(:, 5,26, 9) = (/ &
        & 0.34509e+00,0.76331e+00,0.86957e+00,0.86437e+00,0.55315e+00 /)
      kbo(:, 1,27, 9) = (/ &
        & 0.21544e+00,0.52037e+00,0.60144e+00,0.59535e+00,0.38600e+00 /)
      kbo(:, 2,27, 9) = (/ &
        & 0.23456e+00,0.56067e+00,0.64661e+00,0.64229e+00,0.41342e+00 /)
      kbo(:, 3,27, 9) = (/ &
        & 0.25766e+00,0.60633e+00,0.69633e+00,0.69257e+00,0.44235e+00 /)
      kbo(:, 4,27, 9) = (/ &
        & 0.28405e+00,0.65751e+00,0.75133e+00,0.74692e+00,0.47298e+00 /)
      kbo(:, 5,27, 9) = (/ &
        & 0.31370e+00,0.71529e+00,0.81234e+00,0.80601e+00,0.50534e+00 /)
      kbo(:, 1,28, 9) = (/ &
        & 0.19107e+00,0.47529e+00,0.55077e+00,0.54503e+00,0.34666e+00 /)
      kbo(:, 2,28, 9) = (/ &
        & 0.21041e+00,0.51675e+00,0.59653e+00,0.59172e+00,0.37350e+00 /)
      kbo(:, 3,28, 9) = (/ &
        & 0.23301e+00,0.56364e+00,0.64698e+00,0.64221e+00,0.40186e+00 /)
      kbo(:, 4,28, 9) = (/ &
        & 0.25866e+00,0.61667e+00,0.70320e+00,0.69763e+00,0.43205e+00 /)
      kbo(:, 5,28, 9) = (/ &
        & 0.28710e+00,0.67650e+00,0.76586e+00,0.75834e+00,0.46367e+00 /)
      kbo(:, 1,29, 9) = (/ &
        & 0.17112e+00,0.43830e+00,0.50881e+00,0.50311e+00,0.31371e+00 /)
      kbo(:, 2,29, 9) = (/ &
        & 0.19046e+00,0.48081e+00,0.55535e+00,0.54996e+00,0.34018e+00 /)
      kbo(:, 3,29, 9) = (/ &
        & 0.21264e+00,0.52926e+00,0.60692e+00,0.60125e+00,0.36829e+00 /)
      kbo(:, 4,29, 9) = (/ &
        & 0.23734e+00,0.58428e+00,0.66473e+00,0.65816e+00,0.39807e+00 /)
      kbo(:, 5,29, 9) = (/ &
        & 0.26483e+00,0.64604e+00,0.72961e+00,0.72085e+00,0.42916e+00 /)
      kbo(:, 1,30, 9) = (/ &
        & 0.15474e+00,0.40804e+00,0.47416e+00,0.46844e+00,0.28591e+00 /)
      kbo(:, 2,30, 9) = (/ &
        & 0.17385e+00,0.45175e+00,0.52179e+00,0.51582e+00,0.31208e+00 /)
      kbo(:, 3,30, 9) = (/ &
        & 0.19550e+00,0.50197e+00,0.57484e+00,0.56852e+00,0.33963e+00 /)
      kbo(:, 4,30, 9) = (/ &
        & 0.21942e+00,0.55897e+00,0.63459e+00,0.62718e+00,0.36926e+00 /)
      kbo(:, 5,30, 9) = (/ &
        & 0.24626e+00,0.62254e+00,0.70206e+00,0.69222e+00,0.40317e+00 /)
      kbo(:, 1,31, 9) = (/ &
        & 0.14123e+00,0.38383e+00,0.44627e+00,0.44042e+00,0.26282e+00 /)
      kbo(:, 2,31, 9) = (/ &
        & 0.16008e+00,0.42905e+00,0.49523e+00,0.48891e+00,0.28832e+00 /)
      kbo(:, 3,31, 9) = (/ &
        & 0.18115e+00,0.48120e+00,0.55018e+00,0.54338e+00,0.31669e+00 /)
      kbo(:, 4,31, 9) = (/ &
        & 0.20456e+00,0.54014e+00,0.61227e+00,0.60422e+00,0.34861e+00 /)
      kbo(:, 5,31, 9) = (/ &
        & 0.23090e+00,0.60549e+00,0.68253e+00,0.67193e+00,0.38334e+00 /)
      kbo(:, 1,32, 9) = (/ &
        & 0.13011e+00,0.36494e+00,0.42434e+00,0.41840e+00,0.24343e+00 /)
      kbo(:, 2,32, 9) = (/ &
        & 0.14859e+00,0.41192e+00,0.47502e+00,0.46846e+00,0.27034e+00 /)
      kbo(:, 3,32, 9) = (/ &
        & 0.16925e+00,0.46604e+00,0.53210e+00,0.52502e+00,0.30012e+00 /)
      kbo(:, 4,32, 9) = (/ &
        & 0.19229e+00,0.52692e+00,0.59693e+00,0.58841e+00,0.33258e+00 /)
      kbo(:, 5,32, 9) = (/ &
        & 0.21839e+00,0.59419e+00,0.67028e+00,0.65920e+00,0.36819e+00 /)
      kbo(:, 1,33, 9) = (/ &
        & 0.12092e+00,0.35074e+00,0.40776e+00,0.40175e+00,0.22934e+00 /)
      kbo(:, 2,33, 9) = (/ &
        & 0.13904e+00,0.39967e+00,0.46044e+00,0.45383e+00,0.25698e+00 /)
      kbo(:, 3,33, 9) = (/ &
        & 0.15944e+00,0.45574e+00,0.51998e+00,0.51285e+00,0.28727e+00 /)
      kbo(:, 4,33, 9) = (/ &
        & 0.18230e+00,0.51859e+00,0.58782e+00,0.57914e+00,0.32052e+00 /)
      kbo(:, 5,33, 9) = (/ &
        & 0.20843e+00,0.58793e+00,0.66452e+00,0.65307e+00,0.35723e+00 /)
      kbo(:, 1,34, 9) = (/ &
        & 0.11270e+00,0.33906e+00,0.39419e+00,0.38828e+00,0.21761e+00 /)
      kbo(:, 2,34, 9) = (/ &
        & 0.13054e+00,0.38970e+00,0.44887e+00,0.44251e+00,0.24563e+00 /)
      kbo(:, 3,34, 9) = (/ &
        & 0.15070e+00,0.44751e+00,0.51092e+00,0.50399e+00,0.27652e+00 /)
      kbo(:, 4,34, 9) = (/ &
        & 0.17349e+00,0.51224e+00,0.58169e+00,0.57301e+00,0.31064e+00 /)
      kbo(:, 5,34, 9) = (/ &
        & 0.19973e+00,0.58363e+00,0.66163e+00,0.64989e+00,0.34860e+00 /)
      kbo(:, 1,35, 9) = (/ &
        & 0.10431e+00,0.32621e+00,0.37969e+00,0.37421e+00,0.20589e+00 /)
      kbo(:, 2,35, 9) = (/ &
        & 0.12172e+00,0.37794e+00,0.43594e+00,0.43005e+00,0.23415e+00 /)
      kbo(:, 3,35, 9) = (/ &
        & 0.14155e+00,0.43696e+00,0.49993e+00,0.49338e+00,0.26546e+00 /)
      kbo(:, 4,35, 9) = (/ &
        & 0.16416e+00,0.50303e+00,0.57285e+00,0.56442e+00,0.30031e+00 /)
      kbo(:, 5,35, 9) = (/ &
        & 0.19033e+00,0.57592e+00,0.65509e+00,0.64342e+00,0.33926e+00 /)
      kbo(:, 1,36, 9) = (/ &
        & 0.95441e-01,0.31093e+00,0.36283e+00,0.35795e+00,0.19348e+00 /)
      kbo(:, 2,36, 9) = (/ &
        & 0.11226e+00,0.36299e+00,0.41996e+00,0.41468e+00,0.22173e+00 /)
      kbo(:, 3,36, 9) = (/ &
        & 0.13160e+00,0.42251e+00,0.48508e+00,0.47906e+00,0.25327e+00 /)
      kbo(:, 4,36, 9) = (/ &
        & 0.15379e+00,0.48924e+00,0.55909e+00,0.55119e+00,0.28853e+00 /)
      kbo(:, 5,36, 9) = (/ &
        & 0.17959e+00,0.56298e+00,0.64257e+00,0.63136e+00,0.32808e+00 /)
      kbo(:, 1,37, 9) = (/ &
        & 0.85477e-01,0.29072e+00,0.34067e+00,0.33658e+00,0.17886e+00 /)
      kbo(:, 2,37, 9) = (/ &
        & 0.10144e+00,0.34200e+00,0.39763e+00,0.39300e+00,0.20669e+00 /)
      kbo(:, 3,37, 9) = (/ &
        & 0.11996e+00,0.40095e+00,0.46252e+00,0.45719e+00,0.23796e+00 /)
      kbo(:, 4,37, 9) = (/ &
        & 0.14137e+00,0.46732e+00,0.53621e+00,0.52913e+00,0.27304e+00 /)
      kbo(:, 5,37, 9) = (/ &
        & 0.16629e+00,0.54086e+00,0.61939e+00,0.60918e+00,0.31246e+00 /)
      kbo(:, 1,38, 9) = (/ &
        & 0.76626e-01,0.27223e+00,0.32047e+00,0.31724e+00,0.16576e+00 /)
      kbo(:, 2,38, 9) = (/ &
        & 0.91774e-01,0.32273e+00,0.37721e+00,0.37319e+00,0.19315e+00 /)
      kbo(:, 3,38, 9) = (/ &
        & 0.10950e+00,0.38104e+00,0.44177e+00,0.43708e+00,0.22413e+00 /)
      kbo(:, 4,38, 9) = (/ &
        & 0.13015e+00,0.44697e+00,0.51498e+00,0.50870e+00,0.25903e+00 /)
      kbo(:, 5,38, 9) = (/ &
        & 0.15424e+00,0.52018e+00,0.59766e+00,0.58842e+00,0.29827e+00 /)
      kbo(:, 1,39, 9) = (/ &
        & 0.68857e-01,0.25564e+00,0.30247e+00,0.30005e+00,0.15419e+00 /)
      kbo(:, 2,39, 9) = (/ &
        & 0.83231e-01,0.30541e+00,0.35891e+00,0.35551e+00,0.18117e+00 /)
      kbo(:, 3,39, 9) = (/ &
        & 0.10022e+00,0.36305e+00,0.42306e+00,0.41901e+00,0.21190e+00 /)
      kbo(:, 4,39, 9) = (/ &
        & 0.12015e+00,0.42854e+00,0.49574e+00,0.49023e+00,0.24662e+00 /)
      kbo(:, 5,39, 9) = (/ &
        & 0.14353e+00,0.50140e+00,0.57784e+00,0.56950e+00,0.28564e+00 /)
      kbo(:, 1,40, 9) = (/ &
        & 0.60721e-01,0.23607e+00,0.28098e+00,0.27949e+00,0.14134e+00 /)
      kbo(:, 2,40, 9) = (/ &
        & 0.74142e-01,0.28436e+00,0.33629e+00,0.33356e+00,0.16758e+00 /)
      kbo(:, 3,40, 9) = (/ &
        & 0.90161e-01,0.34051e+00,0.39918e+00,0.39576e+00,0.19765e+00 /)
      kbo(:, 4,40, 9) = (/ &
        & 0.10909e+00,0.40469e+00,0.47035e+00,0.46571e+00,0.23173e+00 /)
      kbo(:, 5,40, 9) = (/ &
        & 0.13146e+00,0.47643e+00,0.55083e+00,0.54364e+00,0.27006e+00 /)
      kbo(:, 1,41, 9) = (/ &
        & 0.53403e-01,0.21760e+00,0.26060e+00,0.26004e+00,0.12944e+00 /)
      kbo(:, 2,41, 9) = (/ &
        & 0.65918e-01,0.26438e+00,0.31466e+00,0.31265e+00,0.15490e+00 /)
      kbo(:, 3,41, 9) = (/ &
        & 0.80936e-01,0.31888e+00,0.37609e+00,0.37327e+00,0.18421e+00 /)
      kbo(:, 4,41, 9) = (/ &
        & 0.98889e-01,0.38155e+00,0.44565e+00,0.44176e+00,0.21756e+00 /)
      kbo(:, 5,41, 9) = (/ &
        & 0.12024e+00,0.45195e+00,0.52424e+00,0.51812e+00,0.25511e+00 /)
      kbo(:, 1,42, 9) = (/ &
        & 0.46980e-01,0.20072e+00,0.24188e+00,0.24222e+00,0.11863e+00 /)
      kbo(:, 2,42, 9) = (/ &
        & 0.58572e-01,0.24586e+00,0.29443e+00,0.29314e+00,0.14330e+00 /)
      kbo(:, 3,42, 9) = (/ &
        & 0.72653e-01,0.29875e+00,0.35445e+00,0.35212e+00,0.17184e+00 /)
      kbo(:, 4,42, 9) = (/ &
        & 0.89663e-01,0.35979e+00,0.42236e+00,0.41911e+00,0.20443e+00 /)
      kbo(:, 5,42, 9) = (/ &
        & 0.11004e+00,0.42873e+00,0.49904e+00,0.49389e+00,0.24118e+00 /)
      kbo(:, 1,43, 9) = (/ &
        & 0.40748e-01,0.18301e+00,0.22189e+00,0.22309e+00,0.10752e+00 /)
      kbo(:, 2,43, 9) = (/ &
        & 0.51357e-01,0.22603e+00,0.27246e+00,0.27198e+00,0.13119e+00 /)
      kbo(:, 3,43, 9) = (/ &
        & 0.64381e-01,0.27684e+00,0.33058e+00,0.32881e+00,0.15875e+00 /)
      kbo(:, 4,43, 9) = (/ &
        & 0.80299e-01,0.33572e+00,0.39639e+00,0.39376e+00,0.19029e+00 /)
      kbo(:, 5,43, 9) = (/ &
        & 0.99551e-01,0.40267e+00,0.47065e+00,0.46647e+00,0.22598e+00 /)
      kbo(:, 1,44, 9) = (/ &
        & 0.35065e-01,0.16586e+00,0.20221e+00,0.20417e+00,0.96831e-01 /)
      kbo(:, 2,44, 9) = (/ &
        & 0.44686e-01,0.20650e+00,0.25055e+00,0.25097e+00,0.11942e+00 /)
      kbo(:, 3,44, 9) = (/ &
        & 0.56631e-01,0.25500e+00,0.30652e+00,0.30540e+00,0.14585e+00 /)
      kbo(:, 4,44, 9) = (/ &
        & 0.71442e-01,0.31160e+00,0.37021e+00,0.36812e+00,0.17630e+00 /)
      kbo(:, 5,44, 9) = (/ &
        & 0.89487e-01,0.37611e+00,0.44177e+00,0.43843e+00,0.21076e+00 /)
      kbo(:, 1,45, 9) = (/ &
        & 0.30099e-01,0.15014e+00,0.18399e+00,0.18651e+00,0.87081e-01 /)
      kbo(:, 2,45, 9) = (/ &
        & 0.38792e-01,0.18842e+00,0.23006e+00,0.23134e+00,0.10857e+00 /)
      kbo(:, 3,45, 9) = (/ &
        & 0.49706e-01,0.23455e+00,0.28377e+00,0.28337e+00,0.13385e+00 /)
      kbo(:, 4,45, 9) = (/ &
        & 0.63416e-01,0.28880e+00,0.34526e+00,0.34365e+00,0.16313e+00 /)
      kbo(:, 5,45, 9) = (/ &
        & 0.80320e-01,0.35087e+00,0.41430e+00,0.41165e+00,0.19641e+00 /)
      kbo(:, 1,46, 9) = (/ &
        & 0.25615e-01,0.13501e+00,0.16621e+00,0.16909e+00,0.77761e-01 /)
      kbo(:, 2,46, 9) = (/ &
        & 0.33396e-01,0.17087e+00,0.20986e+00,0.21193e+00,0.98069e-01 /)
      kbo(:, 3,46, 9) = (/ &
        & 0.43320e-01,0.21451e+00,0.26120e+00,0.26156e+00,0.12212e+00 /)
      kbo(:, 4,46, 9) = (/ &
        & 0.55857e-01,0.26606e+00,0.32018e+00,0.31908e+00,0.15012e+00 /)
      kbo(:, 5,46, 9) = (/ &
        & 0.71564e-01,0.32546e+00,0.38657e+00,0.38454e+00,0.18211e+00 /)
      kbo(:, 1,47, 9) = (/ &
        & 0.21470e-01,0.11984e+00,0.14813e+00,0.15126e+00,0.68564e-01 /)
      kbo(:, 2,47, 9) = (/ &
        & 0.28327e-01,0.15313e+00,0.18908e+00,0.19182e+00,0.87445e-01 /)
      kbo(:, 3,47, 9) = (/ &
        & 0.37186e-01,0.19381e+00,0.23756e+00,0.23882e+00,0.11016e+00 /)
      kbo(:, 4,47, 9) = (/ &
        & 0.48514e-01,0.24239e+00,0.29373e+00,0.29331e+00,0.13670e+00 /)
      kbo(:, 5,47, 9) = (/ &
        & 0.62915e-01,0.29879e+00,0.35729e+00,0.35580e+00,0.16718e+00 /)
      kbo(:, 1,48, 9) = (/ &
        & 0.17915e-01,0.10594e+00,0.13153e+00,0.13471e+00,0.60247e-01 /)
      kbo(:, 2,48, 9) = (/ &
        & 0.23922e-01,0.13687e+00,0.16982e+00,0.17297e+00,0.77702e-01 /)
      kbo(:, 3,48, 9) = (/ &
        & 0.31789e-01,0.17464e+00,0.21543e+00,0.21754e+00,0.99032e-01 /)
      kbo(:, 4,48, 9) = (/ &
        & 0.41975e-01,0.22024e+00,0.26872e+00,0.26906e+00,0.12414e+00 /)
      kbo(:, 5,48, 9) = (/ &
        & 0.55099e-01,0.27366e+00,0.32950e+00,0.32848e+00,0.15313e+00 /)
      kbo(:, 1,49, 9) = (/ &
        & 0.14883e-01,0.93224e-01,0.11635e+00,0.11939e+00,0.52749e-01 /)
      kbo(:, 2,49, 9) = (/ &
        & 0.20112e-01,0.12194e+00,0.15191e+00,0.15532e+00,0.68811e-01 /)
      kbo(:, 3,49, 9) = (/ &
        & 0.27052e-01,0.15700e+00,0.19473e+00,0.19754e+00,0.88692e-01 /)
      kbo(:, 4,49, 9) = (/ &
        & 0.36170e-01,0.19958e+00,0.24512e+00,0.24626e+00,0.11239e+00 /)
      kbo(:, 5,49, 9) = (/ &
        & 0.48053e-01,0.24998e+00,0.30305e+00,0.30260e+00,0.13992e+00 /)
      kbo(:, 1,50, 9) = (/ &
        & 0.12401e-01,0.82224e-01,0.10323e+00,0.10603e+00,0.46388e-01 /)
      kbo(:, 2,50, 9) = (/ &
        & 0.16961e-01,0.10896e+00,0.13629e+00,0.13978e+00,0.61130e-01 /)
      kbo(:, 3,50, 9) = (/ &
        & 0.23097e-01,0.14168e+00,0.17654e+00,0.17982e+00,0.79649e-01 /)
      kbo(:, 4,50, 9) = (/ &
        & 0.31266e-01,0.18143e+00,0.22418e+00,0.22611e+00,0.10201e+00 /)
      kbo(:, 5,50, 9) = (/ &
        & 0.42049e-01,0.22900e+00,0.27939e+00,0.27959e+00,0.12818e+00 /)
      kbo(:, 1,51, 9) = (/ &
        & 0.10311e-01,0.72407e-01,0.91543e-01,0.94015e-01,0.40739e-01 /)
      kbo(:, 2,51, 9) = (/ &
        & 0.14299e-01,0.97301e-01,0.12223e+00,0.12566e+00,0.54336e-01 /)
      kbo(:, 3,51, 9) = (/ &
        & 0.19709e-01,0.12788e+00,0.16001e+00,0.16354e+00,0.71514e-01 /)
      kbo(:, 4,51, 9) = (/ &
        & 0.27010e-01,0.16504e+00,0.20502e+00,0.20766e+00,0.92576e-01 /)
      kbo(:, 5,51, 9) = (/ &
        & 0.36820e-01,0.20996e+00,0.25769e+00,0.25854e+00,0.11743e+00 /)
      kbo(:, 1,52, 9) = (/ &
        & 0.85238e-02,0.63439e-01,0.80796e-01,0.82950e-01,0.35726e-01 /)
      kbo(:, 2,52, 9) = (/ &
        & 0.12004e-01,0.86535e-01,0.10929e+00,0.11252e+00,0.48201e-01 /)
      kbo(:, 3,52, 9) = (/ &
        & 0.16756e-01,0.11511e+00,0.14456e+00,0.14824e+00,0.64036e-01 /)
      kbo(:, 4,52, 9) = (/ &
        & 0.23247e-01,0.14984e+00,0.18701e+00,0.19020e+00,0.83745e-01 /)
      kbo(:, 5,52, 9) = (/ &
        & 0.32110e-01,0.19199e+00,0.23699e+00,0.23857e+00,0.10729e+00 /)
      kbo(:, 1,53, 9) = (/ &
        & 0.70021e-02,0.55279e-01,0.70908e-01,0.72826e-01,0.31267e-01 /)
      kbo(:, 2,53, 9) = (/ &
        & 0.10022e-01,0.76605e-01,0.97337e-01,0.10026e+00,0.42555e-01 /)
      kbo(:, 3,53, 9) = (/ &
        & 0.14186e-01,0.10324e+00,0.13015e+00,0.13384e+00,0.57176e-01 /)
      kbo(:, 4,53, 9) = (/ &
        & 0.19924e-01,0.13568e+00,0.17006e+00,0.17360e+00,0.75508e-01 /)
      kbo(:, 5,53, 9) = (/ &
        & 0.27873e-01,0.17508e+00,0.21734e+00,0.21965e+00,0.97730e-01 /)
      kbo(:, 1,54, 9) = (/ &
        & 0.57827e-02,0.48416e-01,0.62508e-01,0.64310e-01,0.27618e-01 /)
      kbo(:, 2,54, 9) = (/ &
        & 0.84043e-02,0.68151e-01,0.87167e-01,0.89761e-01,0.37874e-01 /)
      kbo(:, 3,54, 9) = (/ &
        & 0.12088e-01,0.93069e-01,0.11782e+00,0.12138e+00,0.51418e-01 /)
      kbo(:, 4,54, 9) = (/ &
        & 0.17188e-01,0.12356e+00,0.15542e+00,0.15914e+00,0.68446e-01 /)
      kbo(:, 5,54, 9) = (/ &
        & 0.24356e-01,0.16057e+00,0.20027e+00,0.20317e+00,0.89427e-01 /)
      kbo(:, 1,55, 9) = (/ &
        & 0.47829e-02,0.42445e-01,0.55108e-01,0.56879e-01,0.24415e-01 /)
      kbo(:, 2,55, 9) = (/ &
        & 0.70515e-02,0.60688e-01,0.78130e-01,0.80430e-01,0.33849e-01 /)
      kbo(:, 3,55, 9) = (/ &
        & 0.10307e-01,0.83954e-01,0.10678e+00,0.11014e+00,0.46263e-01 /)
      kbo(:, 4,55, 9) = (/ &
        & 0.14854e-01,0.11267e+00,0.14216e+00,0.14598e+00,0.62158e-01 /)
      kbo(:, 5,55, 9) = (/ &
        & 0.21317e-01,0.14754e+00,0.18474e+00,0.18809e+00,0.81914e-01 /)
      kbo(:, 1,56, 9) = (/ &
        & 0.39349e-02,0.37013e-01,0.48295e-01,0.50091e-01,0.21529e-01 /)
      kbo(:, 2,56, 9) = (/ &
        & 0.58808e-02,0.53785e-01,0.69695e-01,0.71776e-01,0.30144e-01 /)
      kbo(:, 3,56, 9) = (/ &
        & 0.87470e-02,0.75476e-01,0.96519e-01,0.99590e-01,0.41605e-01 /)
      kbo(:, 4,56, 9) = (/ &
        & 0.12799e-01,0.10247e+00,0.12972e+00,0.13354e+00,0.56396e-01 /)
      kbo(:, 5,56, 9) = (/ &
        & 0.18597e-01,0.13533e+00,0.17007e+00,0.17370e+00,0.74854e-01 /)
      kbo(:, 1,57, 9) = (/ &
        & 0.32237e-02,0.32103e-01,0.42068e-01,0.43893e-01,0.18889e-01 /)
      kbo(:, 2,57, 9) = (/ &
        & 0.48776e-02,0.47453e-01,0.61873e-01,0.63812e-01,0.26899e-01 /)
      kbo(:, 3,57, 9) = (/ &
        & 0.73816e-02,0.67586e-01,0.86956e-01,0.89701e-01,0.37405e-01 /)
      kbo(:, 4,57, 9) = (/ &
        & 0.10984e-01,0.92907e-01,0.11806e+00,0.12175e+00,0.51002e-01 /)
      kbo(:, 5,57, 9) = (/ &
        & 0.16168e-01,0.12385e+00,0.15617e+00,0.15996e+00,0.68253e-01 /)
      kbo(:, 1,58, 9) = (/ &
        & 0.26462e-02,0.27879e-01,0.36685e-01,0.38484e-01,0.16601e-01 /)
      kbo(:, 2,58, 9) = (/ &
        & 0.40522e-02,0.41929e-01,0.54967e-01,0.56858e-01,0.24050e-01 /)
      kbo(:, 3,58, 9) = (/ &
        & 0.62364e-02,0.60609e-01,0.78458e-01,0.80919e-01,0.33657e-01 /)
      kbo(:, 4,58, 9) = (/ &
        & 0.94512e-02,0.84383e-01,0.10769e+00,0.11117e+00,0.46338e-01 /)
      kbo(:, 5,58, 9) = (/ &
        & 0.14101e-01,0.11363e+00,0.14367e+00,0.14755e+00,0.62487e-01 /)
      kbo(:, 1,59, 9) = (/ &
        & 0.23375e-02,0.26104e-01,0.34483e-01,0.36273e-01,0.15643e-01 /)
      kbo(:, 2,59, 9) = (/ &
        & 0.36353e-02,0.39676e-01,0.52191e-01,0.54098e-01,0.22879e-01 /)
      kbo(:, 3,59, 9) = (/ &
        & 0.56781e-02,0.57810e-01,0.75085e-01,0.77452e-01,0.32253e-01 /)
      kbo(:, 4,59, 9) = (/ &
        & 0.87345e-02,0.80998e-01,0.10362e+00,0.10701e+00,0.44587e-01 /)
      kbo(:, 5,59, 9) = (/ &
        & 0.13202e-01,0.10960e+00,0.13878e+00,0.14268e+00,0.60173e-01 /)
      kbo(:, 1,13,10) = (/ &
        & 0.68082e+01,0.10647e+02,0.12044e+02,0.12092e+02,0.85097e+01 /)
      kbo(:, 2,13,10) = (/ &
        & 0.67019e+01,0.10585e+02,0.12055e+02,0.12198e+02,0.87119e+01 /)
      kbo(:, 3,13,10) = (/ &
        & 0.67137e+01,0.10536e+02,0.12063e+02,0.12312e+02,0.88714e+01 /)
      kbo(:, 4,13,10) = (/ &
        & 0.68713e+01,0.10489e+02,0.12087e+02,0.12413e+02,0.90170e+01 /)
      kbo(:, 5,13,10) = (/ &
        & 0.71185e+01,0.10479e+02,0.12121e+02,0.12479e+02,0.91853e+01 /)
      kbo(:, 1,14,10) = (/ &
        & 0.58410e+01,0.94018e+01,0.10846e+02,0.11035e+02,0.76674e+01 /)
      kbo(:, 2,14,10) = (/ &
        & 0.58467e+01,0.93735e+01,0.10875e+02,0.11156e+02,0.78256e+01 /)
      kbo(:, 3,14,10) = (/ &
        & 0.59984e+01,0.93438e+01,0.10908e+02,0.11271e+02,0.79426e+01 /)
      kbo(:, 4,14,10) = (/ &
        & 0.62373e+01,0.93563e+01,0.10953e+02,0.11364e+02,0.81071e+01 /)
      kbo(:, 5,14,10) = (/ &
        & 0.65135e+01,0.94809e+01,0.10997e+02,0.11429e+02,0.82861e+01 /)
      kbo(:, 1,15,10) = (/ &
        & 0.50343e+01,0.83265e+01,0.97137e+01,0.99946e+01,0.69930e+01 /)
      kbo(:, 2,15,10) = (/ &
        & 0.51660e+01,0.83107e+01,0.97594e+01,0.10123e+02,0.71240e+01 /)
      kbo(:, 3,15,10) = (/ &
        & 0.53903e+01,0.83316e+01,0.98216e+01,0.10239e+02,0.72628e+01 /)
      kbo(:, 4,15,10) = (/ &
        & 0.56415e+01,0.84645e+01,0.98856e+01,0.10324e+02,0.74229e+01 /)
      kbo(:, 5,15,10) = (/ &
        & 0.58842e+01,0.87055e+01,0.99631e+01,0.10400e+02,0.75908e+01 /)
      kbo(:, 1,16,10) = (/ &
        & 0.44015e+01,0.74103e+01,0.86530e+01,0.90071e+01,0.63301e+01 /)
      kbo(:, 2,16,10) = (/ &
        & 0.45955e+01,0.74391e+01,0.87237e+01,0.91359e+01,0.64715e+01 /)
      kbo(:, 3,16,10) = (/ &
        & 0.48140e+01,0.75662e+01,0.88065e+01,0.92379e+01,0.66426e+01 /)
      kbo(:, 4,16,10) = (/ &
        & 0.50318e+01,0.77981e+01,0.89101e+01,0.93283e+01,0.68095e+01 /)
      kbo(:, 5,16,10) = (/ &
        & 0.52436e+01,0.80914e+01,0.90522e+01,0.94292e+01,0.69717e+01 /)
      kbo(:, 1,17,10) = (/ &
        & 0.38938e+01,0.65976e+01,0.77151e+01,0.80672e+01,0.57119e+01 /)
      kbo(:, 2,17,10) = (/ &
        & 0.40781e+01,0.67171e+01,0.78068e+01,0.81879e+01,0.58706e+01 /)
      kbo(:, 3,17,10) = (/ &
        & 0.42641e+01,0.69435e+01,0.79191e+01,0.82934e+01,0.60296e+01 /)
      kbo(:, 4,17,10) = (/ &
        & 0.44480e+01,0.72305e+01,0.80762e+01,0.84106e+01,0.62012e+01 /)
      kbo(:, 5,17,10) = (/ &
        & 0.46308e+01,0.75237e+01,0.83037e+01,0.85418e+01,0.63775e+01 /)
      kbo(:, 1,18,10) = (/ &
        & 0.34407e+01,0.58963e+01,0.69001e+01,0.71891e+01,0.51366e+01 /)
      kbo(:, 2,18,10) = (/ &
        & 0.35988e+01,0.61068e+01,0.70120e+01,0.73051e+01,0.52912e+01 /)
      kbo(:, 3,18,10) = (/ &
        & 0.37577e+01,0.63853e+01,0.71752e+01,0.74336e+01,0.54376e+01 /)
      kbo(:, 4,18,10) = (/ &
        & 0.39161e+01,0.66726e+01,0.74020e+01,0.75773e+01,0.56097e+01 /)
      kbo(:, 5,18,10) = (/ &
        & 0.40711e+01,0.69480e+01,0.76793e+01,0.77395e+01,0.57994e+01 /)
      kbo(:, 1,19,10) = (/ &
        & 0.30222e+01,0.53136e+01,0.61695e+01,0.63815e+01,0.46248e+01 /)
      kbo(:, 2,19,10) = (/ &
        & 0.31568e+01,0.55745e+01,0.63303e+01,0.65186e+01,0.47653e+01 /)
      kbo(:, 3,19,10) = (/ &
        & 0.32936e+01,0.58515e+01,0.65536e+01,0.66691e+01,0.49110e+01 /)
      kbo(:, 4,19,10) = (/ &
        & 0.34320e+01,0.61200e+01,0.68298e+01,0.68431e+01,0.50671e+01 /)
      kbo(:, 5,19,10) = (/ &
        & 0.35717e+01,0.63810e+01,0.71341e+01,0.70485e+01,0.52482e+01 /)
      kbo(:, 1,20,10) = (/ &
        & 0.26646e+01,0.48341e+01,0.55294e+01,0.56818e+01,0.41697e+01 /)
      kbo(:, 2,20,10) = (/ &
        & 0.27751e+01,0.50933e+01,0.57470e+01,0.58376e+01,0.43064e+01 /)
      kbo(:, 3,20,10) = (/ &
        & 0.28895e+01,0.53454e+01,0.60203e+01,0.60166e+01,0.44569e+01 /)
      kbo(:, 4,20,10) = (/ &
        & 0.30071e+01,0.55962e+01,0.63194e+01,0.62235e+01,0.46038e+01 /)
      kbo(:, 5,20,10) = (/ &
        & 0.31278e+01,0.58505e+01,0.66184e+01,0.64780e+01,0.47569e+01 /)
      kbo(:, 1,21,10) = (/ &
        & 0.23601e+01,0.44020e+01,0.49905e+01,0.50776e+01,0.37561e+01 /)
      kbo(:, 2,21,10) = (/ &
        & 0.24527e+01,0.46408e+01,0.52514e+01,0.52563e+01,0.39021e+01 /)
      kbo(:, 3,21,10) = (/ &
        & 0.25482e+01,0.48775e+01,0.55424e+01,0.54642e+01,0.40531e+01 /)
      kbo(:, 4,21,10) = (/ &
        & 0.26469e+01,0.51183e+01,0.58389e+01,0.57185e+01,0.42025e+01 /)
      kbo(:, 5,21,10) = (/ &
        & 0.27509e+01,0.53673e+01,0.61341e+01,0.60025e+01,0.43477e+01 /)
      kbo(:, 1,22,10) = (/ &
        & 0.20933e+01,0.40130e+01,0.45530e+01,0.45722e+01,0.33997e+01 /)
      kbo(:, 2,22,10) = (/ &
        & 0.21774e+01,0.42389e+01,0.48339e+01,0.47801e+01,0.35503e+01 /)
      kbo(:, 3,22,10) = (/ &
        & 0.22636e+01,0.44688e+01,0.51214e+01,0.50286e+01,0.36916e+01 /)
      kbo(:, 4,22,10) = (/ &
        & 0.23497e+01,0.47085e+01,0.54112e+01,0.53109e+01,0.38464e+01 /)
      kbo(:, 5,22,10) = (/ &
        & 0.24400e+01,0.49544e+01,0.57104e+01,0.56159e+01,0.40026e+01 /)
      kbo(:, 1,23,10) = (/ &
        & 0.18483e+01,0.36572e+01,0.41816e+01,0.41476e+01,0.30773e+01 /)
      kbo(:, 2,23,10) = (/ &
        & 0.19296e+01,0.38779e+01,0.44582e+01,0.43906e+01,0.32324e+01 /)
      kbo(:, 3,23,10) = (/ &
        & 0.20105e+01,0.41090e+01,0.47398e+01,0.46676e+01,0.33790e+01 /)
      kbo(:, 4,23,10) = (/ &
        & 0.20922e+01,0.43460e+01,0.50319e+01,0.49689e+01,0.35381e+01 /)
      kbo(:, 5,23,10) = (/ &
        & 0.21812e+01,0.45942e+01,0.53379e+01,0.52907e+01,0.36872e+01 /)
      kbo(:, 1,24,10) = (/ &
        & 0.16291e+01,0.33480e+01,0.38514e+01,0.38051e+01,0.27880e+01 /)
      kbo(:, 2,24,10) = (/ &
        & 0.17053e+01,0.35635e+01,0.41240e+01,0.40716e+01,0.29407e+01 /)
      kbo(:, 3,24,10) = (/ &
        & 0.17841e+01,0.37930e+01,0.44076e+01,0.43668e+01,0.31035e+01 /)
      kbo(:, 4,24,10) = (/ &
        & 0.18670e+01,0.40349e+01,0.47044e+01,0.46831e+01,0.32549e+01 /)
      kbo(:, 5,24,10) = (/ &
        & 0.19687e+01,0.42837e+01,0.50178e+01,0.50123e+01,0.34093e+01 /)
      kbo(:, 1,25,10) = (/ &
        & 0.14342e+01,0.30870e+01,0.35616e+01,0.35262e+01,0.25309e+01 /)
      kbo(:, 2,25,10) = (/ &
        & 0.15073e+01,0.32988e+01,0.38348e+01,0.38083e+01,0.26935e+01 /)
      kbo(:, 3,25,10) = (/ &
        & 0.15855e+01,0.35267e+01,0.41227e+01,0.41156e+01,0.28544e+01 /)
      kbo(:, 4,25,10) = (/ &
        & 0.16765e+01,0.37674e+01,0.44270e+01,0.44387e+01,0.30112e+01 /)
      kbo(:, 5,25,10) = (/ &
        & 0.17969e+01,0.40179e+01,0.47482e+01,0.47807e+01,0.31986e+01 /)
      kbo(:, 1,26,10) = (/ &
        & 0.12644e+01,0.28734e+01,0.33145e+01,0.33023e+01,0.23207e+01 /)
      kbo(:, 2,26,10) = (/ &
        & 0.13357e+01,0.30796e+01,0.35932e+01,0.35956e+01,0.24777e+01 /)
      kbo(:, 3,26,10) = (/ &
        & 0.14174e+01,0.33035e+01,0.38863e+01,0.39081e+01,0.26420e+01 /)
      kbo(:, 4,26,10) = (/ &
        & 0.15234e+01,0.35430e+01,0.41997e+01,0.42431e+01,0.28241e+01 /)
      kbo(:, 5,26,10) = (/ &
        & 0.16603e+01,0.37959e+01,0.45341e+01,0.45996e+01,0.30401e+01 /)
      kbo(:, 1,27,10) = (/ &
        & 0.11180e+01,0.26923e+01,0.31092e+01,0.31181e+01,0.21320e+01 /)
      kbo(:, 2,27,10) = (/ &
        & 0.11893e+01,0.28981e+01,0.33903e+01,0.34176e+01,0.22961e+01 /)
      kbo(:, 3,27,10) = (/ &
        & 0.12805e+01,0.31184e+01,0.36930e+01,0.37398e+01,0.24775e+01 /)
      kbo(:, 4,27,10) = (/ &
        & 0.14017e+01,0.33577e+01,0.40190e+01,0.40909e+01,0.26920e+01 /)
      kbo(:, 5,27,10) = (/ &
        & 0.15494e+01,0.36148e+01,0.43685e+01,0.44626e+01,0.29161e+01 /)
      kbo(:, 1,28,10) = (/ &
        & 0.99411e+00,0.25422e+01,0.29403e+01,0.29678e+01,0.19736e+01 /)
      kbo(:, 2,28,10) = (/ &
        & 0.10693e+01,0.27468e+01,0.32278e+01,0.32747e+01,0.21580e+01 /)
      kbo(:, 3,28,10) = (/ &
        & 0.11727e+01,0.29677e+01,0.35410e+01,0.36136e+01,0.23718e+01 /)
      kbo(:, 4,28,10) = (/ &
        & 0.13040e+01,0.32092e+01,0.38816e+01,0.39808e+01,0.25959e+01 /)
      kbo(:, 5,28,10) = (/ &
        & 0.14604e+01,0.34721e+01,0.42472e+01,0.43708e+01,0.28373e+01 /)
      kbo(:, 1,29,10) = (/ &
        & 0.89294e+00,0.24188e+01,0.28058e+01,0.28515e+01,0.18636e+01 /)
      kbo(:, 2,29,10) = (/ &
        & 0.97544e+00,0.26259e+01,0.31039e+01,0.31712e+01,0.20699e+01 /)
      kbo(:, 3,29,10) = (/ &
        & 0.10880e+01,0.28493e+01,0.34305e+01,0.35278e+01,0.22886e+01 /)
      kbo(:, 4,29,10) = (/ &
        & 0.12277e+01,0.30947e+01,0.37862e+01,0.39124e+01,0.25256e+01 /)
      kbo(:, 5,29,10) = (/ &
        & 0.13896e+01,0.33676e+01,0.41685e+01,0.43225e+01,0.27864e+01 /)
      kbo(:, 1,30,10) = (/ &
        & 0.81230e+00,0.23190e+01,0.27059e+01,0.27666e+01,0.17929e+01 /)
      kbo(:, 2,30,10) = (/ &
        & 0.90285e+00,0.25306e+01,0.30146e+01,0.31051e+01,0.20049e+01 /)
      kbo(:, 3,30,10) = (/ &
        & 0.10223e+01,0.27572e+01,0.33560e+01,0.34779e+01,0.22359e+01 /)
      kbo(:, 4,30,10) = (/ &
        & 0.11675e+01,0.30101e+01,0.37284e+01,0.38827e+01,0.24866e+01 /)
      kbo(:, 5,30,10) = (/ &
        & 0.13337e+01,0.32968e+01,0.41265e+01,0.43099e+01,0.27369e+01 /)
      kbo(:, 1,31,10) = (/ &
        & 0.75110e+00,0.22419e+01,0.26379e+01,0.27157e+01,0.17433e+01 /)
      kbo(:, 2,31,10) = (/ &
        & 0.84809e+00,0.24579e+01,0.29592e+01,0.30730e+01,0.19665e+01 /)
      kbo(:, 3,31,10) = (/ &
        & 0.97252e+00,0.26914e+01,0.33168e+01,0.34645e+01,0.22008e+01 /)
      kbo(:, 4,31,10) = (/ &
        & 0.11219e+01,0.29550e+01,0.37069e+01,0.38878e+01,0.24456e+01 /)
      kbo(:, 5,31,10) = (/ &
        & 0.12926e+01,0.32597e+01,0.41224e+01,0.43304e+01,0.27059e+01 /)
      kbo(:, 1,32,10) = (/ &
        & 0.70499e+00,0.21846e+01,0.25985e+01,0.26966e+01,0.17143e+01 /)
      kbo(:, 2,32,10) = (/ &
        & 0.80768e+00,0.24067e+01,0.29356e+01,0.30726e+01,0.19337e+01 /)
      kbo(:, 3,32,10) = (/ &
        & 0.93561e+00,0.26499e+01,0.33107e+01,0.34825e+01,0.21698e+01 /)
      kbo(:, 4,32,10) = (/ &
        & 0.10894e+01,0.29281e+01,0.37179e+01,0.39220e+01,0.24264e+01 /)
      kbo(:, 5,32,10) = (/ &
        & 0.12637e+01,0.32525e+01,0.41500e+01,0.43764e+01,0.26992e+01 /)
      kbo(:, 1,33,10) = (/ &
        & 0.67118e+00,0.21457e+01,0.25854e+01,0.27057e+01,0.16861e+01 /)
      kbo(:, 2,33,10) = (/ &
        & 0.77795e+00,0.23758e+01,0.29404e+01,0.30997e+01,0.19111e+01 /)
      kbo(:, 3,33,10) = (/ &
        & 0.91001e+00,0.26325e+01,0.33337e+01,0.35269e+01,0.21600e+01 /)
      kbo(:, 4,33,10) = (/ &
        & 0.10674e+01,0.29280e+01,0.37566e+01,0.39787e+01,0.24291e+01 /)
      kbo(:, 5,33,10) = (/ &
        & 0.12452e+01,0.32737e+01,0.42022e+01,0.44428e+01,0.27130e+01 /)
      kbo(:, 1,34,10) = (/ &
        & 0.64347e+00,0.21163e+01,0.25854e+01,0.27260e+01,0.16632e+01 /)
      kbo(:, 2,34,10) = (/ &
        & 0.75313e+00,0.23563e+01,0.29579e+01,0.31342e+01,0.18999e+01 /)
      kbo(:, 3,34,10) = (/ &
        & 0.88833e+00,0.26269e+01,0.33662e+01,0.35749e+01,0.21605e+01 /)
      kbo(:, 4,34,10) = (/ &
        & 0.10487e+01,0.29401e+01,0.38003e+01,0.40358e+01,0.24405e+01 /)
      kbo(:, 5,34,10) = (/ &
        & 0.12301e+01,0.33056e+01,0.42553e+01,0.45073e+01,0.27333e+01 /)
      kbo(:, 1,35,10) = (/ &
        & 0.61333e+00,0.20804e+01,0.25725e+01,0.27255e+01,0.16337e+01 /)
      kbo(:, 2,35,10) = (/ &
        & 0.72416e+00,0.23301e+01,0.29566e+01,0.31440e+01,0.18805e+01 /)
      kbo(:, 3,35,10) = (/ &
        & 0.85987e+00,0.26111e+01,0.33740e+01,0.35934e+01,0.21502e+01 /)
      kbo(:, 4,35,10) = (/ &
        & 0.10212e+01,0.29378e+01,0.38159e+01,0.40603e+01,0.24378e+01 /)
      kbo(:, 5,35,10) = (/ &
        & 0.12063e+01,0.33167e+01,0.42768e+01,0.45362e+01,0.27369e+01 /)
      kbo(:, 1,36,10) = (/ &
        & 0.57858e+00,0.20318e+01,0.25343e+01,0.26932e+01,0.15911e+01 /)
      kbo(:, 2,36,10) = (/ &
        & 0.68823e+00,0.22888e+01,0.29242e+01,0.31171e+01,0.18445e+01 /)
      kbo(:, 3,36,10) = (/ &
        & 0.82172e+00,0.25765e+01,0.33460e+01,0.35706e+01,0.21205e+01 /)
      kbo(:, 4,36,10) = (/ &
        & 0.98227e+00,0.29099e+01,0.37920e+01,0.40410e+01,0.24128e+01 /)
      kbo(:, 5,36,10) = (/ &
        & 0.11693e+01,0.32947e+01,0.42558e+01,0.45198e+01,0.27160e+01 /)
      kbo(:, 1,37,10) = (/ &
        & 0.53405e+00,0.19558e+01,0.24506e+01,0.26071e+01,0.15218e+01 /)
      kbo(:, 2,37,10) = (/ &
        & 0.63968e+00,0.22170e+01,0.28388e+01,0.30310e+01,0.17770e+01 /)
      kbo(:, 3,37,10) = (/ &
        & 0.76779e+00,0.25049e+01,0.32599e+01,0.34842e+01,0.20552e+01 /)
      kbo(:, 4,37,10) = (/ &
        & 0.92384e+00,0.28358e+01,0.37058e+01,0.39557e+01,0.23490e+01 /)
      kbo(:, 5,37,10) = (/ &
        & 0.11094e+01,0.32175e+01,0.41691e+01,0.44348e+01,0.26544e+01 /)
      kbo(:, 1,38,10) = (/ &
        & 0.49328e+00,0.18861e+01,0.23724e+01,0.25236e+01,0.14577e+01 /)
      kbo(:, 2,38,10) = (/ &
        & 0.59575e+00,0.21506e+01,0.27570e+01,0.29471e+01,0.17138e+01 /)
      kbo(:, 3,38,10) = (/ &
        & 0.71877e+00,0.24381e+01,0.31760e+01,0.33985e+01,0.19934e+01 /)
      kbo(:, 4,38,10) = (/ &
        & 0.87044e+00,0.27651e+01,0.36203e+01,0.38701e+01,0.22879e+01 /)
      kbo(:, 5,38,10) = (/ &
        & 0.10541e+01,0.31424e+01,0.40835e+01,0.43497e+01,0.25942e+01 /)
      kbo(:, 1,39,10) = (/ &
        & 0.45633e+00,0.18232e+01,0.23004e+01,0.24453e+01,0.13998e+01 /)
      kbo(:, 2,39,10) = (/ &
        & 0.55664e+00,0.20902e+01,0.26810e+01,0.28682e+01,0.16563e+01 /)
      kbo(:, 3,39,10) = (/ &
        & 0.67511e+00,0.23775e+01,0.30973e+01,0.33174e+01,0.19363e+01 /)
      kbo(:, 4,39,10) = (/ &
        & 0.82312e+00,0.27002e+01,0.35399e+01,0.37881e+01,0.22310e+01 /)
      kbo(:, 5,39,10) = (/ &
        & 0.10047e+01,0.30719e+01,0.40016e+01,0.42681e+01,0.25376e+01 /)
      kbo(:, 1,40,10) = (/ &
        & 0.41369e+00,0.17392e+01,0.21979e+01,0.23287e+01,0.13226e+01 /)
      kbo(:, 2,40,10) = (/ &
        & 0.51051e+00,0.20064e+01,0.25693e+01,0.27492e+01,0.15756e+01 /)
      kbo(:, 3,40,10) = (/ &
        & 0.62337e+00,0.22909e+01,0.29791e+01,0.31928e+01,0.18532e+01 /)
      kbo(:, 4,40,10) = (/ &
        & 0.76463e+00,0.26052e+01,0.34168e+01,0.36603e+01,0.21464e+01 /)
      kbo(:, 5,40,10) = (/ &
        & 0.94032e+00,0.29656e+01,0.38751e+01,0.41396e+01,0.24517e+01 /)
      kbo(:, 1,41,10) = (/ &
        & 0.37354e+00,0.16561e+01,0.20963e+01,0.22111e+01,0.12469e+01 /)
      kbo(:, 2,41,10) = (/ &
        & 0.46665e+00,0.19239e+01,0.24587e+01,0.26289e+01,0.14959e+01 /)
      kbo(:, 3,41,10) = (/ &
        & 0.57545e+00,0.22047e+01,0.28597e+01,0.30659e+01,0.17694e+01 /)
      kbo(:, 4,41,10) = (/ &
        & 0.70985e+00,0.25106e+01,0.32912e+01,0.35291e+01,0.20606e+01 /)
      kbo(:, 5,41,10) = (/ &
        & 0.87840e+00,0.28591e+01,0.37457e+01,0.40073e+01,0.23640e+01 /)
      kbo(:, 1,42,10) = (/ &
        & 0.33676e+00,0.15772e+01,0.19999e+01,0.20973e+01,0.11755e+01 /)
      kbo(:, 2,42,10) = (/ &
        & 0.42603e+00,0.18429e+01,0.23518e+01,0.25105e+01,0.14196e+01 /)
      kbo(:, 3,42,10) = (/ &
        & 0.53169e+00,0.21211e+01,0.27440e+01,0.29424e+01,0.16886e+01 /)
      kbo(:, 4,42,10) = (/ &
        & 0.65992e+00,0.24200e+01,0.31691e+01,0.34004e+01,0.19770e+01 /)
      kbo(:, 5,42,10) = (/ &
        & 0.82123e+00,0.27572e+01,0.36189e+01,0.38764e+01,0.22780e+01 /)
      kbo(:, 1,43,10) = (/ &
        & 0.29880e+00,0.14855e+01,0.18883e+01,0.19649e+01,0.10947e+01 /)
      kbo(:, 2,43,10) = (/ &
        & 0.38323e+00,0.17495e+01,0.22289e+01,0.23704e+01,0.13324e+01 /)
      kbo(:, 3,43,10) = (/ &
        & 0.48519e+00,0.20243e+01,0.26093e+01,0.27970e+01,0.15948e+01 /)
      kbo(:, 4,43,10) = (/ &
        & 0.60690e+00,0.23164e+01,0.30260e+01,0.32477e+01,0.18788e+01 /)
      kbo(:, 5,43,10) = (/ &
        & 0.75876e+00,0.26404e+01,0.34692e+01,0.37199e+01,0.21767e+01 /)
      kbo(:, 1,44,10) = (/ &
        & 0.26234e+00,0.13896e+01,0.17735e+01,0.18283e+01,0.10125e+01 /)
      kbo(:, 2,44,10) = (/ &
        & 0.34133e+00,0.16516e+01,0.21029e+01,0.22231e+01,0.12426e+01 /)
      kbo(:, 3,44,10) = (/ &
        & 0.43896e+00,0.19234e+01,0.24698e+01,0.26446e+01,0.14975e+01 /)
      kbo(:, 4,44,10) = (/ &
        & 0.55556e+00,0.22104e+01,0.28764e+01,0.30872e+01,0.17758e+01 /)
      kbo(:, 5,44,10) = (/ &
        & 0.69720e+00,0.25211e+01,0.33108e+01,0.35530e+01,0.20699e+01 /)
      kbo(:, 1,45,10) = (/ &
        & 0.22932e+00,0.12967e+01,0.16617e+01,0.16976e+01,0.93402e+00 /)
      kbo(:, 2,45,10) = (/ &
        & 0.30290e+00,0.15560e+01,0.19824e+01,0.20804e+01,0.11566e+01 /)
      kbo(:, 3,45,10) = (/ &
        & 0.39581e+00,0.18251e+01,0.23356e+01,0.24949e+01,0.14039e+01 /)
      kbo(:, 4,45,10) = (/ &
        & 0.50777e+00,0.21068e+01,0.27305e+01,0.29300e+01,0.16755e+01 /)
      kbo(:, 5,45,10) = (/ &
        & 0.64060e+00,0.24073e+01,0.31565e+01,0.33892e+01,0.19653e+01 /)
      kbo(:, 1,46,10) = (/ &
        & 0.19825e+00,0.12020e+01,0.15457e+01,0.15662e+01,0.85464e+00 /)
      kbo(:, 2,46,10) = (/ &
        & 0.26591e+00,0.14563e+01,0.18595e+01,0.19337e+01,0.10694e+01 /)
      kbo(:, 3,46,10) = (/ &
        & 0.35343e+00,0.17232e+01,0.22000e+01,0.23390e+01,0.13083e+01 /)
      kbo(:, 4,46,10) = (/ &
        & 0.46053e+00,0.19999e+01,0.25801e+01,0.27669e+01,0.15716e+01 /)
      kbo(:, 5,46,10) = (/ &
        & 0.58556e+00,0.22922e+01,0.29962e+01,0.32174e+01,0.18560e+01 /)
      kbo(:, 1,47,10) = (/ &
        & 0.16836e+00,0.11008e+01,0.14194e+01,0.14270e+01,0.77061e+00 /)
      kbo(:, 2,47,10) = (/ &
        & 0.22922e+00,0.13473e+01,0.17277e+01,0.17767e+01,0.97668e+00 /)
      kbo(:, 3,47,10) = (/ &
        & 0.31004e+00,0.16106e+01,0.20551e+01,0.21688e+01,0.12060e+01 /)
      kbo(:, 4,47,10) = (/ &
        & 0.41110e+00,0.18840e+01,0.24189e+01,0.25893e+01,0.14598e+01 /)
      kbo(:, 5,47,10) = (/ &
        & 0.52932e+00,0.21690e+01,0.28216e+01,0.30298e+01,0.17368e+01 /)
      kbo(:, 1,48,10) = (/ &
        & 0.14220e+00,0.10041e+01,0.12957e+01,0.12963e+01,0.69114e+00 /)
      kbo(:, 2,48,10) = (/ &
        & 0.19626e+00,0.12419e+01,0.15985e+01,0.16273e+01,0.88794e+00 /)
      kbo(:, 3,48,10) = (/ &
        & 0.27002e+00,0.15006e+01,0.19169e+01,0.20039e+01,0.11083e+01 /)
      kbo(:, 4,48,10) = (/ &
        & 0.36488e+00,0.17700e+01,0.22644e+01,0.24151e+01,0.13523e+01 /)
      kbo(:, 5,48,10) = (/ &
        & 0.47701e+00,0.20494e+01,0.26525e+01,0.28466e+01,0.16205e+01 /)
      kbo(:, 1,49,10) = (/ &
        & 0.11950e+00,0.91234e+00,0.11755e+01,0.11741e+01,0.61611e+00 /)
      kbo(:, 2,49,10) = (/ &
        & 0.16698e+00,0.11406e+01,0.14723e+01,0.14860e+01,0.80337e+00 /)
      kbo(:, 3,49,10) = (/ &
        & 0.23352e+00,0.13921e+01,0.17842e+01,0.18450e+01,0.10147e+01 /)
      kbo(:, 4,49,10) = (/ &
        & 0.32154e+00,0.16580e+01,0.21177e+01,0.22439e+01,0.12490e+01 /)
      kbo(:, 5,49,10) = (/ &
        & 0.42774e+00,0.19330e+01,0.24891e+01,0.26683e+01,0.15078e+01 /)
      kbo(:, 1,50,10) = (/ &
        & 0.10087e+00,0.83065e+00,0.10669e+01,0.10674e+01,0.54936e+00 /)
      kbo(:, 2,50,10) = (/ &
        & 0.14237e+00,0.10490e+01,0.13561e+01,0.13605e+01,0.72778e+00 /)
      kbo(:, 3,50,10) = (/ &
        & 0.20234e+00,0.12926e+01,0.16630e+01,0.17021e+01,0.93055e+00 /)
      kbo(:, 4,50,10) = (/ &
        & 0.28362e+00,0.15546e+01,0.19861e+01,0.20879e+01,0.11563e+01 /)
      kbo(:, 5,50,10) = (/ &
        & 0.38392e+00,0.18265e+01,0.23423e+01,0.25044e+01,0.14058e+01 /)
      kbo(:, 1,51,10) = (/ &
        & 0.85305e-01,0.75516e+00,0.96600e+00,0.96989e+00,0.48900e+00 /)
      kbo(:, 2,51,10) = (/ &
        & 0.12119e+00,0.96396e+00,0.12458e+01,0.12458e+01,0.65803e+00 /)
      kbo(:, 3,51,10) = (/ &
        & 0.17492e+00,0.11993e+01,0.15474e+01,0.15706e+01,0.85222e+00 /)
      kbo(:, 4,51,10) = (/ &
        & 0.24953e+00,0.14559e+01,0.18635e+01,0.19410e+01,0.10697e+01 /)
      kbo(:, 5,51,10) = (/ &
        & 0.34420e+00,0.17250e+01,0.22062e+01,0.23483e+01,0.13105e+01 /)
      kbo(:, 1,52,10) = (/ &
        & 0.72122e-01,0.68398e+00,0.87088e+00,0.87737e+00,0.43154e+00 /)
      kbo(:, 2,52,10) = (/ &
        & 0.10277e+00,0.88315e+00,0.11388e+01,0.11383e+01,0.59136e+00 /)
      kbo(:, 3,52,10) = (/ &
        & 0.15043e+00,0.11094e+01,0.14345e+01,0.14453e+01,0.77736e+00 /)
      kbo(:, 4,52,10) = (/ &
        & 0.21816e+00,0.13587e+01,0.17451e+01,0.17993e+01,0.98663e+00 /)
      kbo(:, 5,52,10) = (/ &
        & 0.30639e+00,0.16242e+01,0.20759e+01,0.21951e+01,0.12188e+01 /)
      kbo(:, 1,53,10) = (/ &
        & 0.60992e-01,0.61681e+00,0.78096e+00,0.78801e+00,0.37771e+00 /)
      kbo(:, 2,53,10) = (/ &
        & 0.86893e-01,0.80591e+00,0.10354e+01,0.10374e+01,0.52892e+00 /)
      kbo(:, 3,53,10) = (/ &
        & 0.12844e+00,0.10223e+01,0.13228e+01,0.13263e+01,0.70557e+00 /)
      kbo(:, 4,53,10) = (/ &
        & 0.18962e+00,0.12639e+01,0.16288e+01,0.16633e+01,0.90648e+00 /)
      kbo(:, 5,53,10) = (/ &
        & 0.27104e+00,0.15253e+01,0.19505e+01,0.20457e+01,0.11304e+01 /)
      kbo(:, 1,54,10) = (/ &
        & 0.52146e-01,0.55862e+00,0.70341e+00,0.70953e+00,0.33141e+00 /)
      kbo(:, 2,54,10) = (/ &
        & 0.74252e-01,0.73817e+00,0.94468e+00,0.94968e+00,0.47420e+00 /)
      kbo(:, 3,54,10) = (/ &
        & 0.11046e+00,0.94583e+00,0.12229e+01,0.12232e+01,0.64224e+00 /)
      kbo(:, 4,54,10) = (/ &
        & 0.16584e+00,0.11796e+01,0.15239e+01,0.15447e+01,0.83594e+00 /)
      kbo(:, 5,54,10) = (/ &
        & 0.24084e+00,0.14356e+01,0.18395e+01,0.19125e+01,0.10521e+01 /)
      kbo(:, 1,55,10) = (/ &
        & 0.44769e-01,0.50580e+00,0.63367e+00,0.63830e+00,0.29171e+00 /)
      kbo(:, 2,55,10) = (/ &
        & 0.63801e-01,0.67695e+00,0.86251e+00,0.86950e+00,0.42385e+00 /)
      kbo(:, 3,55,10) = (/ &
        & 0.95281e-01,0.87561e+00,0.11296e+01,0.11298e+01,0.58465e+00 /)
      kbo(:, 4,55,10) = (/ &
        & 0.14509e+00,0.11012e+01,0.14250e+01,0.14355e+01,0.77056e+00 /)
      kbo(:, 5,55,10) = (/ &
        & 0.21402e+00,0.13506e+01,0.17360e+01,0.17888e+01,0.97966e+00 /)
      kbo(:, 1,56,10) = (/ &
        & 0.38303e-01,0.45495e+00,0.56826e+00,0.57046e+00,0.25591e+00 /)
      kbo(:, 2,56,10) = (/ &
        & 0.54762e-01,0.61846e+00,0.78411e+00,0.79150e+00,0.37700e+00 /)
      kbo(:, 3,56,10) = (/ &
        & 0.82009e-01,0.80830e+00,0.10394e+01,0.10417e+01,0.52950e+00 /)
      kbo(:, 4,56,10) = (/ &
        & 0.12621e+00,0.10253e+01,0.13275e+01,0.13316e+01,0.70721e+00 /)
      kbo(:, 5,56,10) = (/ &
        & 0.18937e+00,0.12680e+01,0.16344e+01,0.16700e+01,0.90979e+00 /)
      kbo(:, 1,57,10) = (/ &
        & 0.32632e-01,0.40611e+00,0.50731e+00,0.50659e+00,0.22496e+00 /)
      kbo(:, 2,57,10) = (/ &
        & 0.47019e-01,0.56304e+00,0.71002e+00,0.71651e+00,0.33305e+00 /)
      kbo(:, 3,57,10) = (/ &
        & 0.70456e-01,0.74361e+00,0.95266e+00,0.95775e+00,0.47635e+00 /)
      kbo(:, 4,57,10) = (/ &
        & 0.10937e+00,0.95229e+00,0.12322e+01,0.12329e+01,0.64711e+00 /)
      kbo(:, 5,57,10) = (/ &
        & 0.16675e+00,0.11875e+01,0.15342e+01,0.15565e+01,0.84216e+00 /)
      kbo(:, 1,58,10) = (/ &
        & 0.27856e-01,0.36188e+00,0.45369e+00,0.45016e+00,0.19835e+00 /)
      kbo(:, 2,58,10) = (/ &
        & 0.40581e-01,0.51273e+00,0.64353e+00,0.64865e+00,0.29546e+00 /)
      kbo(:, 3,58,10) = (/ &
        & 0.60914e-01,0.68524e+00,0.87436e+00,0.88146e+00,0.42903e+00 /)
      kbo(:, 4,58,10) = (/ &
        & 0.95154e-01,0.88582e+00,0.11439e+01,0.11441e+01,0.59161e+00 /)
      kbo(:, 5,58,10) = (/ &
        & 0.14715e+00,0.11133e+01,0.14407e+01,0.14528e+01,0.77938e+00 /)
      kbo(:, 1,59,10) = (/ &
        & 0.25371e-01,0.34461e+00,0.43295e+00,0.42860e+00,0.18805e+00 /)
      kbo(:, 2,59,10) = (/ &
        & 0.37551e-01,0.49296e+00,0.61778e+00,0.62208e+00,0.28092e+00 /)
      kbo(:, 3,59,10) = (/ &
        & 0.57031e-01,0.66239e+00,0.84380e+00,0.85137e+00,0.40984e+00 /)
      kbo(:, 4,59,10) = (/ &
        & 0.89730e-01,0.85967e+00,0.11090e+01,0.11096e+01,0.56882e+00 /)
      kbo(:, 5,59,10) = (/ &
        & 0.13959e+00,0.10839e+01,0.14035e+01,0.14125e+01,0.75487e+00 /)
      kbo(:, 1,13,11) = (/ &
        & 0.13518e+02,0.19426e+02,0.21368e+02,0.20607e+02,0.15967e+02 /)
      kbo(:, 2,13,11) = (/ &
        & 0.13249e+02,0.19278e+02,0.21345e+02,0.20725e+02,0.16218e+02 /)
      kbo(:, 3,13,11) = (/ &
        & 0.12991e+02,0.19106e+02,0.21344e+02,0.20838e+02,0.16493e+02 /)
      kbo(:, 4,13,11) = (/ &
        & 0.12783e+02,0.18953e+02,0.21337e+02,0.20959e+02,0.16769e+02 /)
      kbo(:, 5,13,11) = (/ &
        & 0.12735e+02,0.18820e+02,0.21328e+02,0.21104e+02,0.16982e+02 /)
      kbo(:, 1,14,11) = (/ &
        & 0.11504e+02,0.17534e+02,0.19457e+02,0.19131e+02,0.14625e+02 /)
      kbo(:, 2,14,11) = (/ &
        & 0.11281e+02,0.17396e+02,0.19491e+02,0.19271e+02,0.14939e+02 /)
      kbo(:, 3,14,11) = (/ &
        & 0.11112e+02,0.17290e+02,0.19527e+02,0.19415e+02,0.15255e+02 /)
      kbo(:, 4,14,11) = (/ &
        & 0.11115e+02,0.17213e+02,0.19560e+02,0.19580e+02,0.15504e+02 /)
      kbo(:, 5,14,11) = (/ &
        & 0.11342e+02,0.17139e+02,0.19615e+02,0.19759e+02,0.15706e+02 /)
      kbo(:, 1,15,11) = (/ &
        & 0.98170e+01,0.15599e+02,0.17627e+02,0.17666e+02,0.13354e+02 /)
      kbo(:, 2,15,11) = (/ &
        & 0.96747e+01,0.15533e+02,0.17695e+02,0.17842e+02,0.13687e+02 /)
      kbo(:, 3,15,11) = (/ &
        & 0.96984e+01,0.15502e+02,0.17755e+02,0.18036e+02,0.14004e+02 /)
      kbo(:, 4,15,11) = (/ &
        & 0.99522e+01,0.15480e+02,0.17829e+02,0.18235e+02,0.14263e+02 /)
      kbo(:, 5,15,11) = (/ &
        & 0.10344e+02,0.15525e+02,0.17929e+02,0.18418e+02,0.14475e+02 /)
      kbo(:, 1,16,11) = (/ &
        & 0.84332e+01,0.13806e+02,0.15926e+02,0.16215e+02,0.12224e+02 /)
      kbo(:, 2,16,11) = (/ &
        & 0.84583e+01,0.13805e+02,0.16021e+02,0.16437e+02,0.12556e+02 /)
      kbo(:, 3,16,11) = (/ &
        & 0.87066e+01,0.13823e+02,0.16108e+02,0.16660e+02,0.12834e+02 /)
      kbo(:, 4,16,11) = (/ &
        & 0.90827e+01,0.13924e+02,0.16226e+02,0.16883e+02,0.13078e+02 /)
      kbo(:, 5,16,11) = (/ &
        & 0.95263e+01,0.14156e+02,0.16382e+02,0.17079e+02,0.13334e+02 /)
      kbo(:, 1,17,11) = (/ &
        & 0.73068e+01,0.12252e+02,0.14341e+02,0.14810e+02,0.11129e+02 /)
      kbo(:, 2,17,11) = (/ &
        & 0.75295e+01,0.12291e+02,0.14463e+02,0.15052e+02,0.11439e+02 /)
      kbo(:, 3,17,11) = (/ &
        & 0.78853e+01,0.12405e+02,0.14606e+02,0.15309e+02,0.11729e+02 /)
      kbo(:, 4,17,11) = (/ &
        & 0.83040e+01,0.12643e+02,0.14776e+02,0.15548e+02,0.12006e+02 /)
      kbo(:, 5,17,11) = (/ &
        & 0.87123e+01,0.13039e+02,0.14982e+02,0.15762e+02,0.12286e+02 /)
      kbo(:, 1,18,11) = (/ &
        & 0.64287e+01,0.10933e+02,0.12879e+02,0.13451e+02,0.10053e+02 /)
      kbo(:, 2,18,11) = (/ &
        & 0.67446e+01,0.11039e+02,0.13041e+02,0.13740e+02,0.10377e+02 /)
      kbo(:, 3,18,11) = (/ &
        & 0.71271e+01,0.11266e+02,0.13222e+02,0.14018e+02,0.10699e+02 /)
      kbo(:, 4,18,11) = (/ &
        & 0.75067e+01,0.11650e+02,0.13455e+02,0.14263e+02,0.11011e+02 /)
      kbo(:, 5,18,11) = (/ &
        & 0.78797e+01,0.12144e+02,0.13766e+02,0.14517e+02,0.11323e+02 /)
      kbo(:, 1,19,11) = (/ &
        & 0.57165e+01,0.98198e+01,0.11563e+02,0.12210e+02,0.90287e+01 /)
      kbo(:, 2,19,11) = (/ &
        & 0.60504e+01,0.10030e+02,0.11759e+02,0.12511e+02,0.93771e+01 /)
      kbo(:, 3,19,11) = (/ &
        & 0.63872e+01,0.10390e+02,0.12004e+02,0.12787e+02,0.97382e+01 /)
      kbo(:, 4,19,11) = (/ &
        & 0.67262e+01,0.10858e+02,0.12325e+02,0.13071e+02,0.10100e+02 /)
      kbo(:, 5,19,11) = (/ &
        & 0.70630e+01,0.11396e+02,0.12720e+02,0.13371e+02,0.10433e+02 /)
      kbo(:, 1,20,11) = (/ &
        & 0.51077e+01,0.88680e+01,0.10415e+02,0.11053e+02,0.80963e+01 /)
      kbo(:, 2,20,11) = (/ &
        & 0.54017e+01,0.92107e+01,0.10662e+02,0.11361e+02,0.84758e+01 /)
      kbo(:, 3,20,11) = (/ &
        & 0.57015e+01,0.96698e+01,0.10982e+02,0.11668e+02,0.88481e+01 /)
      kbo(:, 4,20,11) = (/ &
        & 0.60041e+01,0.10196e+02,0.11384e+02,0.12000e+02,0.92376e+01 /)
      kbo(:, 5,20,11) = (/ &
        & 0.63106e+01,0.10732e+02,0.11884e+02,0.12349e+02,0.96255e+01 /)
      kbo(:, 1,21,11) = (/ &
        & 0.45414e+01,0.80841e+01,0.94333e+01,0.10001e+02,0.72987e+01 /)
      kbo(:, 2,21,11) = (/ &
        & 0.48060e+01,0.85169e+01,0.97399e+01,0.10324e+02,0.76799e+01 /)
      kbo(:, 3,21,11) = (/ &
        & 0.50754e+01,0.90311e+01,0.10134e+02,0.10673e+02,0.80692e+01 /)
      kbo(:, 4,21,11) = (/ &
        & 0.53489e+01,0.95660e+01,0.10626e+02,0.11046e+02,0.84671e+01 /)
      kbo(:, 5,21,11) = (/ &
        & 0.56226e+01,0.10100e+02,0.11188e+02,0.11467e+02,0.88878e+01 /)
      kbo(:, 1,22,11) = (/ &
        & 0.40512e+01,0.74537e+01,0.86113e+01,0.90760e+01,0.66406e+01 /)
      kbo(:, 2,22,11) = (/ &
        & 0.42861e+01,0.79455e+01,0.89988e+01,0.94326e+01,0.70298e+01 /)
      kbo(:, 3,22,11) = (/ &
        & 0.45284e+01,0.84723e+01,0.94806e+01,0.98282e+01,0.74365e+01 /)
      kbo(:, 4,22,11) = (/ &
        & 0.47765e+01,0.90022e+01,0.10036e+02,0.10267e+02,0.78530e+01 /)
      kbo(:, 5,22,11) = (/ &
        & 0.50273e+01,0.95375e+01,0.10644e+02,0.10762e+02,0.82925e+01 /)
      kbo(:, 1,23,11) = (/ &
        & 0.36272e+01,0.69345e+01,0.79292e+01,0.82821e+01,0.60862e+01 /)
      kbo(:, 2,23,11) = (/ &
        & 0.38324e+01,0.74412e+01,0.84058e+01,0.86779e+01,0.64814e+01 /)
      kbo(:, 3,23,11) = (/ &
        & 0.40496e+01,0.79556e+01,0.89497e+01,0.91277e+01,0.69031e+01 /)
      kbo(:, 4,23,11) = (/ &
        & 0.42736e+01,0.84881e+01,0.95512e+01,0.96353e+01,0.73423e+01 /)
      kbo(:, 5,23,11) = (/ &
        & 0.45008e+01,0.90231e+01,0.10199e+02,0.10196e+02,0.78107e+01 /)
      kbo(:, 1,24,11) = (/ &
        & 0.32617e+01,0.64927e+01,0.73814e+01,0.76204e+01,0.56351e+01 /)
      kbo(:, 2,24,11) = (/ &
        & 0.34455e+01,0.69864e+01,0.79146e+01,0.80668e+01,0.60482e+01 /)
      kbo(:, 3,24,11) = (/ &
        & 0.36375e+01,0.74982e+01,0.85124e+01,0.85688e+01,0.64793e+01 /)
      kbo(:, 4,24,11) = (/ &
        & 0.38361e+01,0.80253e+01,0.91530e+01,0.91384e+01,0.69488e+01 /)
      kbo(:, 5,24,11) = (/ &
        & 0.40434e+01,0.85770e+01,0.98249e+01,0.97701e+01,0.74392e+01 /)
      kbo(:, 1,25,11) = (/ &
        & 0.29504e+01,0.60996e+01,0.69378e+01,0.70933e+01,0.52696e+01 /)
      kbo(:, 2,25,11) = (/ &
        & 0.31134e+01,0.65859e+01,0.75193e+01,0.75874e+01,0.56908e+01 /)
      kbo(:, 3,25,11) = (/ &
        & 0.32850e+01,0.70991e+01,0.81583e+01,0.81455e+01,0.61504e+01 /)
      kbo(:, 4,25,11) = (/ &
        & 0.34639e+01,0.76357e+01,0.88289e+01,0.87766e+01,0.66391e+01 /)
      kbo(:, 5,25,11) = (/ &
        & 0.36575e+01,0.82031e+01,0.95335e+01,0.94728e+01,0.71181e+01 /)
      kbo(:, 1,26,11) = (/ &
        & 0.26785e+01,0.57592e+01,0.65944e+01,0.66793e+01,0.49659e+01 /)
      kbo(:, 2,26,11) = (/ &
        & 0.28303e+01,0.62512e+01,0.72180e+01,0.72292e+01,0.54158e+01 /)
      kbo(:, 3,26,11) = (/ &
        & 0.29845e+01,0.67700e+01,0.78853e+01,0.78517e+01,0.58929e+01 /)
      kbo(:, 4,26,11) = (/ &
        & 0.31498e+01,0.73218e+01,0.85892e+01,0.85405e+01,0.63779e+01 /)
      kbo(:, 5,26,11) = (/ &
        & 0.33365e+01,0.79095e+01,0.93260e+01,0.92876e+01,0.68593e+01 /)
      kbo(:, 1,27,11) = (/ &
        & 0.24381e+01,0.54719e+01,0.63296e+01,0.63699e+01,0.47378e+01 /)
      kbo(:, 2,27,11) = (/ &
        & 0.25833e+01,0.59706e+01,0.69839e+01,0.69809e+01,0.52024e+01 /)
      kbo(:, 3,27,11) = (/ &
        & 0.27276e+01,0.65032e+01,0.76823e+01,0.76623e+01,0.56849e+01 /)
      kbo(:, 4,27,11) = (/ &
        & 0.28843e+01,0.70768e+01,0.84223e+01,0.83973e+01,0.61613e+01 /)
      kbo(:, 5,27,11) = (/ &
        & 0.30776e+01,0.76837e+01,0.91929e+01,0.91871e+01,0.66697e+01 /)
      kbo(:, 1,28,11) = (/ &
        & 0.22238e+01,0.52366e+01,0.61335e+01,0.61574e+01,0.45705e+01 /)
      kbo(:, 2,28,11) = (/ &
        & 0.23648e+01,0.57451e+01,0.68151e+01,0.68266e+01,0.50347e+01 /)
      kbo(:, 3,28,11) = (/ &
        & 0.25067e+01,0.62980e+01,0.75460e+01,0.75548e+01,0.55064e+01 /)
      kbo(:, 4,28,11) = (/ &
        & 0.26680e+01,0.68930e+01,0.83223e+01,0.83308e+01,0.60103e+01 /)
      kbo(:, 5,28,11) = (/ &
        & 0.28763e+01,0.75234e+01,0.91269e+01,0.91547e+01,0.65443e+01 /)
      kbo(:, 1,29,11) = (/ &
        & 0.20343e+01,0.50540e+01,0.60021e+01,0.60360e+01,0.44306e+01 /)
      kbo(:, 2,29,11) = (/ &
        & 0.21732e+01,0.55785e+01,0.67134e+01,0.67544e+01,0.48924e+01 /)
      kbo(:, 3,29,11) = (/ &
        & 0.23217e+01,0.61554e+01,0.74828e+01,0.75217e+01,0.53899e+01 /)
      kbo(:, 4,29,11) = (/ &
        & 0.24991e+01,0.67727e+01,0.82943e+01,0.83341e+01,0.59211e+01 /)
      kbo(:, 5,29,11) = (/ &
        & 0.27298e+01,0.74309e+01,0.91294e+01,0.91877e+01,0.64776e+01 /)
      kbo(:, 1,30,11) = (/ &
        & 0.18678e+01,0.49203e+01,0.59291e+01,0.59875e+01,0.43204e+01 /)
      kbo(:, 2,30,11) = (/ &
        & 0.20102e+01,0.54667e+01,0.66747e+01,0.67430e+01,0.48026e+01 /)
      kbo(:, 3,30,11) = (/ &
        & 0.21719e+01,0.60682e+01,0.74827e+01,0.75477e+01,0.53281e+01 /)
      kbo(:, 4,30,11) = (/ &
        & 0.23720e+01,0.67126e+01,0.83252e+01,0.83910e+01,0.58826e+01 /)
      kbo(:, 5,30,11) = (/ &
        & 0.26264e+01,0.73977e+01,0.91870e+01,0.92723e+01,0.64598e+01 /)
      kbo(:, 1,31,11) = (/ &
        & 0.17244e+01,0.48370e+01,0.59156e+01,0.60001e+01,0.42555e+01 /)
      kbo(:, 2,31,11) = (/ &
        & 0.18755e+01,0.54107e+01,0.66999e+01,0.67904e+01,0.47644e+01 /)
      kbo(:, 3,31,11) = (/ &
        & 0.20573e+01,0.60363e+01,0.75402e+01,0.76274e+01,0.53155e+01 /)
      kbo(:, 4,31,11) = (/ &
        & 0.22829e+01,0.67094e+01,0.84079e+01,0.84962e+01,0.58901e+01 /)
      kbo(:, 5,31,11) = (/ &
        & 0.25590e+01,0.74195e+01,0.92909e+01,0.93994e+01,0.64871e+01 /)
      kbo(:, 1,32,11) = (/ &
        & 0.16069e+01,0.48030e+01,0.59579e+01,0.60639e+01,0.42356e+01 /)
      kbo(:, 2,32,11) = (/ &
        & 0.17705e+01,0.54037e+01,0.67788e+01,0.68874e+01,0.47712e+01 /)
      kbo(:, 3,32,11) = (/ &
        & 0.19742e+01,0.60574e+01,0.76448e+01,0.77491e+01,0.53434e+01 /)
      kbo(:, 4,32,11) = (/ &
        & 0.22247e+01,0.67560e+01,0.85310e+01,0.86385e+01,0.59381e+01 /)
      kbo(:, 5,32,11) = (/ &
        & 0.25238e+01,0.74880e+01,0.94292e+01,0.95570e+01,0.65497e+01 /)
      kbo(:, 1,33,11) = (/ &
        & 0.15128e+01,0.48140e+01,0.60501e+01,0.61714e+01,0.42550e+01 /)
      kbo(:, 2,33,11) = (/ &
        & 0.16946e+01,0.54417e+01,0.69000e+01,0.70212e+01,0.48155e+01 /)
      kbo(:, 3,33,11) = (/ &
        & 0.19206e+01,0.61213e+01,0.77839e+01,0.79020e+01,0.54069e+01 /)
      kbo(:, 4,33,11) = (/ &
        & 0.21946e+01,0.68422e+01,0.86827e+01,0.88075e+01,0.60169e+01 /)
      kbo(:, 5,33,11) = (/ &
        & 0.25173e+01,0.75913e+01,0.95924e+01,0.97373e+01,0.66398e+01 /)
      kbo(:, 1,34,11) = (/ &
        & 0.14356e+01,0.48418e+01,0.61495e+01,0.62828e+01,0.42896e+01 /)
      kbo(:, 2,34,11) = (/ &
        & 0.16357e+01,0.54935e+01,0.70184e+01,0.71516e+01,0.48691e+01 /)
      kbo(:, 3,34,11) = (/ &
        & 0.18838e+01,0.61957e+01,0.79151e+01,0.80457e+01,0.54742e+01 /)
      kbo(:, 4,34,11) = (/ &
        & 0.21788e+01,0.69325e+01,0.88256e+01,0.89643e+01,0.60956e+01 /)
      kbo(:, 5,34,11) = (/ &
        & 0.25238e+01,0.76930e+01,0.97439e+01,0.99021e+01,0.67264e+01 /)
      kbo(:, 1,35,11) = (/ &
        & 0.13620e+01,0.48400e+01,0.61911e+01,0.63341e+01,0.42950e+01 /)
      kbo(:, 2,35,11) = (/ &
        & 0.15765e+01,0.55077e+01,0.70717e+01,0.72149e+01,0.48872e+01 /)
      kbo(:, 3,35,11) = (/ &
        & 0.18416e+01,0.62238e+01,0.79778e+01,0.81173e+01,0.55014e+01 /)
      kbo(:, 4,35,11) = (/ &
        & 0.21528e+01,0.69694e+01,0.88951e+01,0.90430e+01,0.61304e+01 /)
      kbo(:, 5,35,11) = (/ &
        & 0.25135e+01,0.77370e+01,0.98191e+01,0.99865e+01,0.67662e+01 /)
      kbo(:, 1,36,11) = (/ &
        & 0.12836e+01,0.47892e+01,0.61549e+01,0.63050e+01,0.42540e+01 /)
      kbo(:, 2,36,11) = (/ &
        & 0.15070e+01,0.54649e+01,0.70416e+01,0.71923e+01,0.48536e+01 /)
      kbo(:, 3,36,11) = (/ &
        & 0.17830e+01,0.61872e+01,0.79531e+01,0.80994e+01,0.54734e+01 /)
      kbo(:, 4,36,11) = (/ &
        & 0.21055e+01,0.69369e+01,0.88745e+01,0.90288e+01,0.61066e+01 /)
      kbo(:, 5,36,11) = (/ &
        & 0.24754e+01,0.77090e+01,0.98023e+01,0.99759e+01,0.67459e+01 /)
      kbo(:, 1,37,11) = (/ &
        & 0.11878e+01,0.46541e+01,0.59975e+01,0.61531e+01,0.41357e+01 /)
      kbo(:, 2,37,11) = (/ &
        & 0.14114e+01,0.53279e+01,0.68836e+01,0.70407e+01,0.47366e+01 /)
      kbo(:, 3,37,11) = (/ &
        & 0.16907e+01,0.60488e+01,0.77961e+01,0.79492e+01,0.53587e+01 /)
      kbo(:, 4,37,11) = (/ &
        & 0.20171e+01,0.67987e+01,0.87214e+01,0.88782e+01,0.59931e+01 /)
      kbo(:, 5,37,11) = (/ &
        & 0.23879e+01,0.75721e+01,0.96505e+01,0.98263e+01,0.66346e+01 /)
      kbo(:, 1,38,11) = (/ &
        & 0.11019e+01,0.45241e+01,0.58411e+01,0.60015e+01,0.40206e+01 /)
      kbo(:, 2,38,11) = (/ &
        & 0.13240e+01,0.51938e+01,0.67248e+01,0.68881e+01,0.46215e+01 /)
      kbo(:, 3,38,11) = (/ &
        & 0.16050e+01,0.59127e+01,0.76377e+01,0.77969e+01,0.52444e+01 /)
      kbo(:, 4,38,11) = (/ &
        & 0.19344e+01,0.66614e+01,0.85656e+01,0.87241e+01,0.58797e+01 /)
      kbo(:, 5,38,11) = (/ &
        & 0.23053e+01,0.74352e+01,0.94961e+01,0.96730e+01,0.65232e+01 /)
      kbo(:, 1,39,11) = (/ &
        & 0.10261e+01,0.44035e+01,0.56925e+01,0.58571e+01,0.39130e+01 /)
      kbo(:, 2,39,11) = (/ &
        & 0.12458e+01,0.50694e+01,0.65735e+01,0.67411e+01,0.45130e+01 /)
      kbo(:, 3,39,11) = (/ &
        & 0.15281e+01,0.57844e+01,0.74853e+01,0.76497e+01,0.51353e+01 /)
      kbo(:, 4,39,11) = (/ &
        & 0.18590e+01,0.65310e+01,0.84139e+01,0.85752e+01,0.57711e+01 /)
      kbo(:, 5,39,11) = (/ &
        & 0.22296e+01,0.73031e+01,0.93461e+01,0.95233e+01,0.64155e+01 /)
      kbo(:, 1,40,11) = (/ &
        & 0.94020e+00,0.42252e+01,0.54618e+01,0.56305e+01,0.37514e+01 /)
      kbo(:, 2,40,11) = (/ &
        & 0.11510e+01,0.48808e+01,0.63359e+01,0.65051e+01,0.43464e+01 /)
      kbo(:, 3,40,11) = (/ &
        & 0.14267e+01,0.55865e+01,0.72429e+01,0.74116e+01,0.49659e+01 /)
      kbo(:, 4,40,11) = (/ &
        & 0.17534e+01,0.63284e+01,0.81706e+01,0.83346e+01,0.56004e+01 /)
      kbo(:, 5,40,11) = (/ &
        & 0.21196e+01,0.70954e+01,0.91038e+01,0.92790e+01,0.62443e+01 /)
      kbo(:, 1,41,11) = (/ &
        & 0.86129e+00,0.40457e+01,0.52264e+01,0.53976e+01,0.35879e+01 /)
      kbo(:, 2,41,11) = (/ &
        & 0.10633e+01,0.46915e+01,0.60924e+01,0.62635e+01,0.41768e+01 /)
      kbo(:, 3,41,11) = (/ &
        & 0.13283e+01,0.53845e+01,0.69926e+01,0.71649e+01,0.47921e+01 /)
      kbo(:, 4,41,11) = (/ &
        & 0.16485e+01,0.61201e+01,0.79175e+01,0.80844e+01,0.54240e+01 /)
      kbo(:, 5,41,11) = (/ &
        & 0.20093e+01,0.68812e+01,0.88522e+01,0.90249e+01,0.60668e+01 /)
      kbo(:, 1,42,11) = (/ &
        & 0.79123e+00,0.38735e+01,0.49960e+01,0.51699e+01,0.34287e+01 /)
      kbo(:, 2,42,11) = (/ &
        & 0.98295e+00,0.45072e+01,0.58533e+01,0.60254e+01,0.40109e+01 /)
      kbo(:, 3,42,11) = (/ &
        & 0.12364e+01,0.51876e+01,0.67459e+01,0.69214e+01,0.46212e+01 /)
      kbo(:, 4,42,11) = (/ &
        & 0.15484e+01,0.59150e+01,0.76665e+01,0.78373e+01,0.52503e+01 /)
      kbo(:, 5,42,11) = (/ &
        & 0.19026e+01,0.66716e+01,0.86018e+01,0.87728e+01,0.58915e+01 /)
      kbo(:, 1,43,11) = (/ &
        & 0.71984e+00,0.36729e+01,0.47235e+01,0.48975e+01,0.32397e+01 /)
      kbo(:, 2,43,11) = (/ &
        & 0.89808e+00,0.42916e+01,0.55697e+01,0.57443e+01,0.38153e+01 /)
      kbo(:, 3,43,11) = (/ &
        & 0.11360e+01,0.49574e+01,0.64519e+01,0.66289e+01,0.44184e+01 /)
      kbo(:, 4,43,11) = (/ &
        & 0.14345e+01,0.56728e+01,0.73660e+01,0.75410e+01,0.50437e+01 /)
      kbo(:, 5,43,11) = (/ &
        & 0.17793e+01,0.64228e+01,0.82999e+01,0.84705e+01,0.56823e+01 /)
      kbo(:, 1,44,11) = (/ &
        & 0.65285e+00,0.34667e+01,0.44372e+01,0.46082e+01,0.30399e+01 /)
      kbo(:, 2,44,11) = (/ &
        & 0.81657e+00,0.40674e+01,0.52701e+01,0.54466e+01,0.36094e+01 /)
      kbo(:, 3,44,11) = (/ &
        & 0.10370e+01,0.47171e+01,0.61405e+01,0.63175e+01,0.42038e+01 /)
      kbo(:, 4,44,11) = (/ &
        & 0.13194e+01,0.54184e+01,0.70473e+01,0.72248e+01,0.48237e+01 /)
      kbo(:, 5,44,11) = (/ &
        & 0.16514e+01,0.61584e+01,0.79760e+01,0.81477e+01,0.54581e+01 /)
      kbo(:, 1,45,11) = (/ &
        & 0.59324e+00,0.32687e+01,0.41610e+01,0.43270e+01,0.28437e+01 /)
      kbo(:, 2,45,11) = (/ &
        & 0.74292e+00,0.38502e+01,0.49754e+01,0.51525e+01,0.34081e+01 /)
      kbo(:, 3,45,11) = (/ &
        & 0.94606e+00,0.44838e+01,0.58347e+01,0.60112e+01,0.39932e+01 /)
      kbo(:, 4,45,11) = (/ &
        & 0.12103e+01,0.51691e+01,0.67312e+01,0.69113e+01,0.46063e+01 /)
      kbo(:, 5,45,11) = (/ &
        & 0.15283e+01,0.58970e+01,0.76529e+01,0.78283e+01,0.52365e+01 /)
      kbo(:, 1,46,11) = (/ &
        & 0.53665e+00,0.30665e+01,0.38788e+01,0.40344e+01,0.26396e+01 /)
      kbo(:, 2,46,11) = (/ &
        & 0.67326e+00,0.36275e+01,0.46685e+01,0.48445e+01,0.31970e+01 /)
      kbo(:, 3,46,11) = (/ &
        & 0.85964e+00,0.42450e+01,0.55161e+01,0.56940e+01,0.37742e+01 /)
      kbo(:, 4,46,11) = (/ &
        & 0.11026e+01,0.49112e+01,0.63992e+01,0.65795e+01,0.43785e+01 /)
      kbo(:, 5,46,11) = (/ &
        & 0.14030e+01,0.56247e+01,0.73128e+01,0.74918e+01,0.50037e+01 /)
      kbo(:, 1,47,11) = (/ &
        & 0.47965e+00,0.28512e+01,0.35773e+01,0.37190e+01,0.24179e+01 /)
      kbo(:, 2,47,11) = (/ &
        & 0.60499e+00,0.33895e+01,0.43353e+01,0.45070e+01,0.29653e+01 /)
      kbo(:, 3,47,11) = (/ &
        & 0.77211e+00,0.39857e+01,0.51656e+01,0.53439e+01,0.35346e+01 /)
      kbo(:, 4,47,11) = (/ &
        & 0.99280e+00,0.46320e+01,0.60346e+01,0.62138e+01,0.41278e+01 /)
      kbo(:, 5,47,11) = (/ &
        & 0.12711e+01,0.53272e+01,0.69377e+01,0.71189e+01,0.47464e+01 /)
      kbo(:, 1,48,11) = (/ &
        & 0.42651e+00,0.26445e+01,0.32894e+01,0.34148e+01,0.22033e+01 /)
      kbo(:, 2,48,11) = (/ &
        & 0.54388e+00,0.31611e+01,0.40161e+01,0.41791e+01,0.27373e+01 /)
      kbo(:, 3,48,11) = (/ &
        & 0.69368e+00,0.37347e+01,0.48206e+01,0.49989e+01,0.32997e+01 /)
      kbo(:, 4,48,11) = (/ &
        & 0.89279e+00,0.43620e+01,0.56767e+01,0.58554e+01,0.38822e+01 /)
      kbo(:, 5,48,11) = (/ &
        & 0.11484e+01,0.50369e+01,0.65668e+01,0.67495e+01,0.44918e+01 /)
      kbo(:, 1,49,11) = (/ &
        & 0.37713e+00,0.24439e+01,0.30160e+01,0.31206e+01,0.19976e+01 /)
      kbo(:, 2,49,11) = (/ &
        & 0.48766e+00,0.29434e+01,0.37104e+01,0.38599e+01,0.25143e+01 /)
      kbo(:, 3,49,11) = (/ &
        & 0.62407e+00,0.34939e+01,0.44847e+01,0.46596e+01,0.30680e+01 /)
      kbo(:, 4,49,11) = (/ &
        & 0.80298e+00,0.41006e+01,0.53255e+01,0.55049e+01,0.36413e+01 /)
      kbo(:, 5,49,11) = (/ &
        & 0.10353e+01,0.47554e+01,0.62010e+01,0.63820e+01,0.42407e+01 /)
      kbo(:, 1,50,11) = (/ &
        & 0.33334e+00,0.22573e+01,0.27730e+01,0.28537e+01,0.18141e+01 /)
      kbo(:, 2,50,11) = (/ &
        & 0.43824e+00,0.27477e+01,0.34359e+01,0.35712e+01,0.23112e+01 /)
      kbo(:, 3,50,11) = (/ &
        & 0.56555e+00,0.32767e+01,0.41807e+01,0.43497e+01,0.28540e+01 /)
      kbo(:, 4,50,11) = (/ &
        & 0.72662e+00,0.38631e+01,0.50003e+01,0.51798e+01,0.34206e+01 /)
      kbo(:, 5,50,11) = (/ &
        & 0.93811e+00,0.44998e+01,0.58635e+01,0.60433e+01,0.40092e+01 /)
      kbo(:, 1,51,11) = (/ &
        & 0.29344e+00,0.20792e+01,0.25493e+01,0.26045e+01,0.16447e+01 /)
      kbo(:, 2,51,11) = (/ &
        & 0.39320e+00,0.25633e+01,0.31811e+01,0.32996e+01,0.21202e+01 /)
      kbo(:, 3,51,11) = (/ &
        & 0.51335e+00,0.30739e+01,0.38968e+01,0.40554e+01,0.26493e+01 /)
      kbo(:, 4,51,11) = (/ &
        & 0.65991e+00,0.36396e+01,0.46910e+01,0.48692e+01,0.32095e+01 /)
      kbo(:, 5,51,11) = (/ &
        & 0.85305e+00,0.42602e+01,0.55428e+01,0.57227e+01,0.37890e+01 /)
      kbo(:, 1,52,11) = (/ &
        & 0.25634e+00,0.19065e+01,0.23373e+01,0.23675e+01,0.14849e+01 /)
      kbo(:, 2,52,11) = (/ &
        & 0.35085e+00,0.23832e+01,0.29380e+01,0.30363e+01,0.19379e+01 /)
      kbo(:, 3,52,11) = (/ &
        & 0.46463e+00,0.28806e+01,0.36245e+01,0.37705e+01,0.24499e+01 /)
      kbo(:, 4,52,11) = (/ &
        & 0.60014e+00,0.34247e+01,0.43901e+01,0.45644e+01,0.30013e+01 /)
      kbo(:, 5,52,11) = (/ &
        & 0.77502e+00,0.40268e+01,0.52264e+01,0.54064e+01,0.35729e+01 /)
      kbo(:, 1,53,11) = (/ &
        & 0.22198e+00,0.17382e+01,0.21355e+01,0.21443e+01,0.13321e+01 /)
      kbo(:, 2,53,11) = (/ &
        & 0.31088e+00,0.22037e+01,0.27070e+01,0.27809e+01,0.17631e+01 /)
      kbo(:, 3,53,11) = (/ &
        & 0.41868e+00,0.26937e+01,0.33628e+01,0.34937e+01,0.22551e+01 /)
      kbo(:, 4,53,11) = (/ &
        & 0.54590e+00,0.32172e+01,0.40994e+01,0.42669e+01,0.27950e+01 /)
      kbo(:, 5,53,11) = (/ &
        & 0.70382e+00,0.37993e+01,0.49134e+01,0.50934e+01,0.33609e+01 /)
      kbo(:, 1,54,11) = (/ &
        & 0.19279e+00,0.15884e+01,0.19576e+01,0.19516e+01,0.11991e+01 /)
      kbo(:, 2,54,11) = (/ &
        & 0.27614e+00,0.20423e+01,0.25053e+01,0.25559e+01,0.16106e+01 /)
      kbo(:, 3,54,11) = (/ &
        & 0.37900e+00,0.25264e+01,0.31323e+01,0.32473e+01,0.20825e+01 /)
      kbo(:, 4,54,11) = (/ &
        & 0.49954e+00,0.30344e+01,0.38425e+01,0.39994e+01,0.26090e+01 /)
      kbo(:, 5,54,11) = (/ &
        & 0.64483e+00,0.35967e+01,0.46320e+01,0.48104e+01,0.31683e+01 /)
      kbo(:, 1,55,11) = (/ &
        & 0.16752e+00,0.14506e+01,0.17924e+01,0.17780e+01,0.10766e+01 /)
      kbo(:, 2,55,11) = (/ &
        & 0.24546e+00,0.18924e+01,0.23215e+01,0.23502e+01,0.14718e+01 /)
      kbo(:, 3,55,11) = (/ &
        & 0.34282e+00,0.23686e+01,0.29203e+01,0.30171e+01,0.19238e+01 /)
      kbo(:, 4,55,11) = (/ &
        & 0.45751e+00,0.28657e+01,0.36048e+01,0.37504e+01,0.24347e+01 /)
      kbo(:, 5,55,11) = (/ &
        & 0.59345e+00,0.34091e+01,0.43692e+01,0.45436e+01,0.29860e+01 /)
      kbo(:, 1,56,11) = (/ &
        & 0.14442e+00,0.13191e+01,0.16307e+01,0.16158e+01,0.95966e+00 /)
      kbo(:, 2,56,11) = (/ &
        & 0.21629e+00,0.17456e+01,0.21454e+01,0.21553e+01,0.13384e+01 /)
      kbo(:, 3,56,11) = (/ &
        & 0.30838e+00,0.22117e+01,0.27184e+01,0.27939e+01,0.17710e+01 /)
      kbo(:, 4,56,11) = (/ &
        & 0.41780e+00,0.27024e+01,0.33761e+01,0.35083e+01,0.22647e+01 /)
      kbo(:, 5,56,11) = (/ &
        & 0.54633e+00,0.32277e+01,0.41153e+01,0.42835e+01,0.28057e+01 /)
      kbo(:, 1,57,11) = (/ &
        & 0.12369e+00,0.11942e+01,0.14751e+01,0.14660e+01,0.84794e+00 /)
      kbo(:, 2,57,11) = (/ &
        & 0.18943e+00,0.16025e+01,0.19752e+01,0.19706e+01,0.12104e+01 /)
      kbo(:, 3,57,11) = (/ &
        & 0.27580e+00,0.20577e+01,0.25253e+01,0.25785e+01,0.16249e+01 /)
      kbo(:, 4,57,11) = (/ &
        & 0.38015e+00,0.25425e+01,0.31554e+01,0.32724e+01,0.20995e+01 /)
      kbo(:, 5,57,11) = (/ &
        & 0.50220e+00,0.30528e+01,0.38694e+01,0.40275e+01,0.26279e+01 /)
      kbo(:, 1,58,11) = (/ &
        & 0.10619e+00,0.10815e+01,0.13338e+01,0.13340e+01,0.74924e+00 /)
      kbo(:, 2,58,11) = (/ &
        & 0.16586e+00,0.14713e+01,0.18183e+01,0.18047e+01,0.10933e+01 /)
      kbo(:, 3,58,11) = (/ &
        & 0.24668e+00,0.19150e+01,0.23498e+01,0.23824e+01,0.14931e+01 /)
      kbo(:, 4,58,11) = (/ &
        & 0.34613e+00,0.23936e+01,0.29542e+01,0.30545e+01,0.19489e+01 /)
      kbo(:, 5,58,11) = (/ &
        & 0.46251e+00,0.28928e+01,0.36439e+01,0.37914e+01,0.24628e+01 /)
      kbo(:, 1,59,11) = (/ &
        & 0.98781e-01,0.10374e+01,0.12790e+01,0.12834e+01,0.71091e+00 /)
      kbo(:, 2,59,11) = (/ &
        & 0.15643e+00,0.14199e+01,0.17560e+01,0.17406e+01,0.10475e+01 /)
      kbo(:, 3,59,11) = (/ &
        & 0.23512e+00,0.18585e+01,0.22815e+01,0.23061e+01,0.14408e+01 /)
      kbo(:, 4,59,11) = (/ &
        & 0.33250e+00,0.23338e+01,0.28755e+01,0.29686e+01,0.18898e+01 /)
      kbo(:, 5,59,11) = (/ &
        & 0.44697e+00,0.28298e+01,0.35555e+01,0.36984e+01,0.23975e+01 /)
      kbo(:, 1,13,12) = (/ &
        & 0.30998e+02,0.37385e+02,0.40609e+02,0.38100e+02,0.30845e+02 /)
      kbo(:, 2,13,12) = (/ &
        & 0.30490e+02,0.37042e+02,0.40582e+02,0.38272e+02,0.31245e+02 /)
      kbo(:, 3,13,12) = (/ &
        & 0.29985e+02,0.36701e+02,0.40520e+02,0.38445e+02,0.31621e+02 /)
      kbo(:, 4,13,12) = (/ &
        & 0.29490e+02,0.36329e+02,0.40415e+02,0.38594e+02,0.32000e+02 /)
      kbo(:, 5,13,12) = (/ &
        & 0.29015e+02,0.35959e+02,0.40312e+02,0.38750e+02,0.32433e+02 /)
      kbo(:, 1,14,12) = (/ &
        & 0.27110e+02,0.35184e+02,0.38617e+02,0.36399e+02,0.28635e+02 /)
      kbo(:, 2,14,12) = (/ &
        & 0.26641e+02,0.34930e+02,0.38606e+02,0.36649e+02,0.29079e+02 /)
      kbo(:, 3,14,12) = (/ &
        & 0.26184e+02,0.34642e+02,0.38568e+02,0.36926e+02,0.29498e+02 /)
      kbo(:, 4,14,12) = (/ &
        & 0.25751e+02,0.34348e+02,0.38555e+02,0.37188e+02,0.29949e+02 /)
      kbo(:, 5,14,12) = (/ &
        & 0.25340e+02,0.34077e+02,0.38568e+02,0.37453e+02,0.30433e+02 /)
      kbo(:, 1,15,12) = (/ &
        & 0.23379e+02,0.32658e+02,0.36083e+02,0.34396e+02,0.26632e+02 /)
      kbo(:, 2,15,12) = (/ &
        & 0.22961e+02,0.32462e+02,0.36143e+02,0.34739e+02,0.27099e+02 /)
      kbo(:, 3,15,12) = (/ &
        & 0.22574e+02,0.32277e+02,0.36234e+02,0.35089e+02,0.27554e+02 /)
      kbo(:, 4,15,12) = (/ &
        & 0.22226e+02,0.32107e+02,0.36368e+02,0.35457e+02,0.28061e+02 /)
      kbo(:, 5,15,12) = (/ &
        & 0.22052e+02,0.31945e+02,0.36473e+02,0.35860e+02,0.28623e+02 /)
      kbo(:, 1,16,12) = (/ &
        & 0.19977e+02,0.29953e+02,0.33281e+02,0.32282e+02,0.24730e+02 /)
      kbo(:, 2,16,12) = (/ &
        & 0.19633e+02,0.29859e+02,0.33454e+02,0.32701e+02,0.25245e+02 /)
      kbo(:, 3,16,12) = (/ &
        & 0.19340e+02,0.29766e+02,0.33693e+02,0.33152e+02,0.25800e+02 /)
      kbo(:, 4,16,12) = (/ &
        & 0.19247e+02,0.29689e+02,0.33933e+02,0.33616e+02,0.26378e+02 /)
      kbo(:, 5,16,12) = (/ &
        & 0.19403e+02,0.29623e+02,0.34160e+02,0.34111e+02,0.26924e+02 /)
      kbo(:, 1,17,12) = (/ &
        & 0.17051e+02,0.27143e+02,0.30473e+02,0.30161e+02,0.22931e+02 /)
      kbo(:, 2,17,12) = (/ &
        & 0.16797e+02,0.27123e+02,0.30776e+02,0.30670e+02,0.23518e+02 /)
      kbo(:, 3,17,12) = (/ &
        & 0.16741e+02,0.27141e+02,0.31121e+02,0.31186e+02,0.24127e+02 /)
      kbo(:, 4,17,12) = (/ &
        & 0.16948e+02,0.27189e+02,0.31472e+02,0.31736e+02,0.24729e+02 /)
      kbo(:, 5,17,12) = (/ &
        & 0.17485e+02,0.27288e+02,0.31858e+02,0.32324e+02,0.25297e+02 /)
      kbo(:, 1,18,12) = (/ &
        & 0.14597e+02,0.24342e+02,0.27826e+02,0.28130e+02,0.21245e+02 /)
      kbo(:, 2,18,12) = (/ &
        & 0.14547e+02,0.24446e+02,0.28237e+02,0.28704e+02,0.21885e+02 /)
      kbo(:, 3,18,12) = (/ &
        & 0.14765e+02,0.24583e+02,0.28672e+02,0.29288e+02,0.22535e+02 /)
      kbo(:, 4,18,12) = (/ &
        & 0.15315e+02,0.24794e+02,0.29147e+02,0.29934e+02,0.23159e+02 /)
      kbo(:, 5,18,12) = (/ &
        & 0.16067e+02,0.25143e+02,0.29634e+02,0.30628e+02,0.23749e+02 /)
      kbo(:, 1,19,12) = (/ &
        & 0.12640e+02,0.21753e+02,0.25384e+02,0.26151e+02,0.19661e+02 /)
      kbo(:, 2,19,12) = (/ &
        & 0.12835e+02,0.21949e+02,0.25878e+02,0.26810e+02,0.20358e+02 /)
      kbo(:, 3,19,12) = (/ &
        & 0.13356e+02,0.22229e+02,0.26410e+02,0.27515e+02,0.21037e+02 /)
      kbo(:, 4,19,12) = (/ &
        & 0.14056e+02,0.22664e+02,0.26964e+02,0.28265e+02,0.21685e+02 /)
      kbo(:, 5,19,12) = (/ &
        & 0.14855e+02,0.23244e+02,0.27571e+02,0.29046e+02,0.22336e+02 /)
      kbo(:, 1,20,12) = (/ &
        & 0.11082e+02,0.19491e+02,0.23194e+02,0.24313e+02,0.18232e+02 /)
      kbo(:, 2,20,12) = (/ &
        & 0.11562e+02,0.19787e+02,0.23755e+02,0.25073e+02,0.18946e+02 /)
      kbo(:, 3,20,12) = (/ &
        & 0.12224e+02,0.20238e+02,0.24350e+02,0.25880e+02,0.19650e+02 /)
      kbo(:, 4,20,12) = (/ &
        & 0.12987e+02,0.20868e+02,0.25012e+02,0.26726e+02,0.20347e+02 /)
      kbo(:, 5,20,12) = (/ &
        & 0.13788e+02,0.21712e+02,0.25741e+02,0.27588e+02,0.21074e+02 /)
      kbo(:, 1,21,12) = (/ &
        & 0.98833e+01,0.17574e+02,0.21209e+02,0.22623e+02,0.16925e+02 /)
      kbo(:, 2,21,12) = (/ &
        & 0.10489e+02,0.18010e+02,0.21858e+02,0.23471e+02,0.17666e+02 /)
      kbo(:, 3,21,12) = (/ &
        & 0.11209e+02,0.18622e+02,0.22555e+02,0.24382e+02,0.18394e+02 /)
      kbo(:, 4,21,12) = (/ &
        & 0.11974e+02,0.19474e+02,0.23320e+02,0.25315e+02,0.19156e+02 /)
      kbo(:, 5,21,12) = (/ &
        & 0.12743e+02,0.20530e+02,0.24213e+02,0.26280e+02,0.19957e+02 /)
      kbo(:, 1,22,12) = (/ &
        & 0.89432e+01,0.16023e+02,0.19521e+02,0.21142e+02,0.15785e+02 /)
      kbo(:, 2,22,12) = (/ &
        & 0.96012e+01,0.16615e+02,0.20251e+02,0.22105e+02,0.16565e+02 /)
      kbo(:, 3,22,12) = (/ &
        & 0.10308e+02,0.17429e+02,0.21053e+02,0.23102e+02,0.17352e+02 /)
      kbo(:, 4,22,12) = (/ &
        & 0.11034e+02,0.18474e+02,0.21986e+02,0.24140e+02,0.18184e+02 /)
      kbo(:, 5,22,12) = (/ &
        & 0.11779e+02,0.19675e+02,0.23025e+02,0.25198e+02,0.19053e+02 /)
      kbo(:, 1,23,12) = (/ &
        & 0.81558e+01,0.14793e+02,0.18088e+02,0.19855e+02,0.14800e+02 /)
      kbo(:, 2,23,12) = (/ &
        & 0.87957e+01,0.15543e+02,0.18895e+02,0.20923e+02,0.15621e+02 /)
      kbo(:, 3,23,12) = (/ &
        & 0.94593e+01,0.16540e+02,0.19849e+02,0.22025e+02,0.16480e+02 /)
      kbo(:, 4,23,12) = (/ &
        & 0.10153e+02,0.17706e+02,0.20923e+02,0.23160e+02,0.17388e+02 /)
      kbo(:, 5,23,12) = (/ &
        & 0.10876e+02,0.18993e+02,0.22113e+02,0.24310e+02,0.18322e+02 /)
      kbo(:, 1,24,12) = (/ &
        & 0.74526e+01,0.13830e+02,0.16894e+02,0.18769e+02,0.13959e+02 /)
      kbo(:, 2,24,12) = (/ &
        & 0.80517e+01,0.14766e+02,0.17833e+02,0.19936e+02,0.14836e+02 /)
      kbo(:, 3,24,12) = (/ &
        & 0.86841e+01,0.15873e+02,0.18916e+02,0.21150e+02,0.15773e+02 /)
      kbo(:, 4,24,12) = (/ &
        & 0.93535e+01,0.17122e+02,0.20131e+02,0.22383e+02,0.16742e+02 /)
      kbo(:, 5,24,12) = (/ &
        & 0.10068e+02,0.18482e+02,0.21482e+02,0.23634e+02,0.17753e+02 /)
      kbo(:, 1,25,12) = (/ &
        & 0.68105e+01,0.13122e+02,0.15953e+02,0.17890e+02,0.13264e+02 /)
      kbo(:, 2,25,12) = (/ &
        & 0.73796e+01,0.14193e+02,0.17028e+02,0.19160e+02,0.14211e+02 /)
      kbo(:, 3,25,12) = (/ &
        & 0.79883e+01,0.15386e+02,0.18237e+02,0.20473e+02,0.15219e+02 /)
      kbo(:, 4,25,12) = (/ &
        & 0.86473e+01,0.16702e+02,0.19605e+02,0.21810e+02,0.16257e+02 /)
      kbo(:, 5,25,12) = (/ &
        & 0.93513e+01,0.18139e+02,0.21087e+02,0.23158e+02,0.17339e+02 /)
      kbo(:, 1,26,12) = (/ &
        & 0.62530e+01,0.12619e+02,0.15260e+02,0.17241e+02,0.12729e+02 /)
      kbo(:, 2,26,12) = (/ &
        & 0.67955e+01,0.13786e+02,0.16460e+02,0.18602e+02,0.13751e+02 /)
      kbo(:, 3,26,12) = (/ &
        & 0.73876e+01,0.15061e+02,0.17816e+02,0.20014e+02,0.14821e+02 /)
      kbo(:, 4,26,12) = (/ &
        & 0.80374e+01,0.16453e+02,0.19314e+02,0.21444e+02,0.15933e+02 /)
      kbo(:, 5,26,12) = (/ &
        & 0.87427e+01,0.17956e+02,0.20909e+02,0.22878e+02,0.17080e+02 /)
      kbo(:, 1,27,12) = (/ &
        & 0.57700e+01,0.12257e+02,0.14782e+02,0.16780e+02,0.12335e+02 /)
      kbo(:, 2,27,12) = (/ &
        & 0.62864e+01,0.13513e+02,0.16114e+02,0.18231e+02,0.13431e+02 /)
      kbo(:, 3,27,12) = (/ &
        & 0.68675e+01,0.14868e+02,0.17601e+02,0.19730e+02,0.14565e+02 /)
      kbo(:, 4,27,12) = (/ &
        & 0.75138e+01,0.16329e+02,0.19199e+02,0.21244e+02,0.15742e+02 /)
      kbo(:, 5,27,12) = (/ &
        & 0.82289e+01,0.17883e+02,0.20886e+02,0.22748e+02,0.16940e+02 /)
      kbo(:, 1,28,12) = (/ &
        & 0.53548e+01,0.12024e+02,0.14494e+02,0.16490e+02,0.12074e+02 /)
      kbo(:, 2,28,12) = (/ &
        & 0.58567e+01,0.13364e+02,0.15954e+02,0.18023e+02,0.13231e+02 /)
      kbo(:, 3,28,12) = (/ &
        & 0.64249e+01,0.14793e+02,0.17548e+02,0.19599e+02,0.14431e+02 /)
      kbo(:, 4,28,12) = (/ &
        & 0.70763e+01,0.16306e+02,0.19232e+02,0.21185e+02,0.15664e+02 /)
      kbo(:, 5,28,12) = (/ &
        & 0.78108e+01,0.17913e+02,0.20999e+02,0.22748e+02,0.16904e+02 /)
      kbo(:, 1,29,12) = (/ &
        & 0.50045e+01,0.11918e+02,0.14389e+02,0.16363e+02,0.11938e+02 /)
      kbo(:, 2,29,12) = (/ &
        & 0.55030e+01,0.13334e+02,0.15959e+02,0.17970e+02,0.13155e+02 /)
      kbo(:, 3,29,12) = (/ &
        & 0.60662e+01,0.14820e+02,0.17638e+02,0.19611e+02,0.14408e+02 /)
      kbo(:, 4,29,12) = (/ &
        & 0.67325e+01,0.16392e+02,0.19392e+02,0.21253e+02,0.15686e+02 /)
      kbo(:, 5,29,12) = (/ &
        & 0.74925e+01,0.18044e+02,0.21206e+02,0.22856e+02,0.16965e+02 /)
      kbo(:, 1,30,12) = (/ &
        & 0.47172e+01,0.11917e+02,0.14428e+02,0.16368e+02,0.11903e+02 /)
      kbo(:, 2,30,12) = (/ &
        & 0.52125e+01,0.13400e+02,0.16089e+02,0.18040e+02,0.13179e+02 /)
      kbo(:, 3,30,12) = (/ &
        & 0.57884e+01,0.14940e+02,0.17829e+02,0.19728e+02,0.14475e+02 /)
      kbo(:, 4,30,12) = (/ &
        & 0.64722e+01,0.16556e+02,0.19636e+02,0.21408e+02,0.15787e+02 /)
      kbo(:, 5,30,12) = (/ &
        & 0.72704e+01,0.18251e+02,0.21479e+02,0.23035e+02,0.17093e+02 /)
      kbo(:, 1,31,12) = (/ &
        & 0.44858e+01,0.12017e+02,0.14590e+02,0.16495e+02,0.11969e+02 /)
      kbo(:, 2,31,12) = (/ &
        & 0.49908e+01,0.13550e+02,0.16315e+02,0.18215e+02,0.13287e+02 /)
      kbo(:, 3,31,12) = (/ &
        & 0.55864e+01,0.15140e+02,0.18101e+02,0.19933e+02,0.14620e+02 /)
      kbo(:, 4,31,12) = (/ &
        & 0.63024e+01,0.16801e+02,0.19948e+02,0.21636e+02,0.15956e+02 /)
      kbo(:, 5,31,12) = (/ &
        & 0.71504e+01,0.18530e+02,0.21815e+02,0.23280e+02,0.17277e+02 /)
      kbo(:, 1,32,12) = (/ &
        & 0.43064e+01,0.12199e+02,0.14841e+02,0.16712e+02,0.12112e+02 /)
      kbo(:, 2,32,12) = (/ &
        & 0.48346e+01,0.13779e+02,0.16613e+02,0.18463e+02,0.13462e+02 /)
      kbo(:, 3,32,12) = (/ &
        & 0.54614e+01,0.15404e+02,0.18438e+02,0.20209e+02,0.14821e+02 /)
      kbo(:, 4,32,12) = (/ &
        & 0.62177e+01,0.17102e+02,0.20311e+02,0.21920e+02,0.16172e+02 /)
      kbo(:, 5,32,12) = (/ &
        & 0.71259e+01,0.18855e+02,0.22195e+02,0.23574e+02,0.17506e+02 /)
      kbo(:, 1,33,12) = (/ &
        & 0.41801e+01,0.12450e+02,0.15154e+02,0.16994e+02,0.12315e+02 /)
      kbo(:, 2,33,12) = (/ &
        & 0.47391e+01,0.14064e+02,0.16963e+02,0.18765e+02,0.13689e+02 /)
      kbo(:, 3,33,12) = (/ &
        & 0.54061e+01,0.15717e+02,0.18820e+02,0.20527e+02,0.15064e+02 /)
      kbo(:, 4,33,12) = (/ &
        & 0.62146e+01,0.17442e+02,0.20711e+02,0.22242e+02,0.16420e+02 /)
      kbo(:, 5,33,12) = (/ &
        & 0.71827e+01,0.19219e+02,0.22608e+02,0.23903e+02,0.17762e+02 /)
      kbo(:, 1,34,12) = (/ &
        & 0.40887e+01,0.12691e+02,0.15451e+02,0.17259e+02,0.12512e+02 /)
      kbo(:, 2,34,12) = (/ &
        & 0.46819e+01,0.14330e+02,0.17288e+02,0.19046e+02,0.13902e+02 /)
      kbo(:, 3,34,12) = (/ &
        & 0.53890e+01,0.16007e+02,0.19166e+02,0.20816e+02,0.15287e+02 /)
      kbo(:, 4,34,12) = (/ &
        & 0.62486e+01,0.17752e+02,0.21067e+02,0.22532e+02,0.16650e+02 /)
      kbo(:, 5,34,12) = (/ &
        & 0.72682e+01,0.19545e+02,0.22972e+02,0.24194e+02,0.17995e+02 /)
      kbo(:, 1,35,12) = (/ &
        & 0.39916e+01,0.12809e+02,0.15601e+02,0.17383e+02,0.12605e+02 /)
      kbo(:, 2,35,12) = (/ &
        & 0.46112e+01,0.14460e+02,0.17457e+02,0.19181e+02,0.14005e+02 /)
      kbo(:, 3,35,12) = (/ &
        & 0.53474e+01,0.16154e+02,0.19347e+02,0.20958e+02,0.15398e+02 /)
      kbo(:, 4,35,12) = (/ &
        & 0.62430e+01,0.17913e+02,0.21258e+02,0.22679e+02,0.16764e+02 /)
      kbo(:, 5,35,12) = (/ &
        & 0.72953e+01,0.19716e+02,0.23169e+02,0.24345e+02,0.18113e+02 /)
      kbo(:, 1,36,12) = (/ &
        & 0.38696e+01,0.12768e+02,0.15571e+02,0.17332e+02,0.12565e+02 /)
      kbo(:, 2,36,12) = (/ &
        & 0.45034e+01,0.14429e+02,0.17436e+02,0.19141e+02,0.13973e+02 /)
      kbo(:, 3,36,12) = (/ &
        & 0.52555e+01,0.16128e+02,0.19333e+02,0.20927e+02,0.15372e+02 /)
      kbo(:, 4,36,12) = (/ &
        & 0.61640e+01,0.17893e+02,0.21249e+02,0.22656e+02,0.16743e+02 /)
      kbo(:, 5,36,12) = (/ &
        & 0.72295e+01,0.19702e+02,0.23168e+02,0.24329e+02,0.18096e+02 /)
      kbo(:, 1,37,12) = (/ &
        & 0.36883e+01,0.12493e+02,0.15274e+02,0.17021e+02,0.12322e+02 /)
      kbo(:, 2,37,12) = (/ &
        & 0.43193e+01,0.14156e+02,0.17140e+02,0.18841e+02,0.13739e+02 /)
      kbo(:, 3,37,12) = (/ &
        & 0.50636e+01,0.15852e+02,0.19039e+02,0.20638e+02,0.15145e+02 /)
      kbo(:, 4,37,12) = (/ &
        & 0.59573e+01,0.17616e+02,0.20958e+02,0.22386e+02,0.16525e+02 /)
      kbo(:, 5,37,12) = (/ &
        & 0.70089e+01,0.19421e+02,0.22881e+02,0.24071e+02,0.17883e+02 /)
      kbo(:, 1,38,12) = (/ &
        & 0.35253e+01,0.12215e+02,0.14971e+02,0.16706e+02,0.12079e+02 /)
      kbo(:, 2,38,12) = (/ &
        & 0.41507e+01,0.13877e+02,0.16837e+02,0.18535e+02,0.13501e+02 /)
      kbo(:, 3,38,12) = (/ &
        & 0.48852e+01,0.15572e+02,0.18736e+02,0.20342e+02,0.14913e+02 /)
      kbo(:, 4,38,12) = (/ &
        & 0.57613e+01,0.17329e+02,0.20656e+02,0.22106e+02,0.16300e+02 /)
      kbo(:, 5,38,12) = (/ &
        & 0.67957e+01,0.19130e+02,0.22581e+02,0.23804e+02,0.17665e+02 /)
      kbo(:, 1,39,12) = (/ &
        & 0.33825e+01,0.11947e+02,0.14676e+02,0.16402e+02,0.11843e+02 /)
      kbo(:, 2,39,12) = (/ &
        & 0.39997e+01,0.13607e+02,0.16542e+02,0.18237e+02,0.13271e+02 /)
      kbo(:, 3,39,12) = (/ &
        & 0.47242e+01,0.15300e+02,0.18440e+02,0.20053e+02,0.14687e+02 /)
      kbo(:, 4,39,12) = (/ &
        & 0.55821e+01,0.17050e+02,0.20362e+02,0.21831e+02,0.16081e+02 /)
      kbo(:, 5,39,12) = (/ &
        & 0.65965e+01,0.18849e+02,0.22289e+02,0.23541e+02,0.17452e+02 /)
      kbo(:, 1,40,12) = (/ &
        & 0.31990e+01,0.11518e+02,0.14197e+02,0.15916e+02,0.11466e+02 /)
      kbo(:, 2,40,12) = (/ &
        & 0.37954e+01,0.13171e+02,0.16060e+02,0.17759e+02,0.12898e+02 /)
      kbo(:, 3,40,12) = (/ &
        & 0.44984e+01,0.14859e+02,0.17955e+02,0.19586e+02,0.14321e+02 /)
      kbo(:, 4,40,12) = (/ &
        & 0.53220e+01,0.16595e+02,0.19875e+02,0.21381e+02,0.15725e+02 /)
      kbo(:, 5,40,12) = (/ &
        & 0.62999e+01,0.18387e+02,0.21803e+02,0.23109e+02,0.17102e+02 /)
      kbo(:, 1,41,12) = (/ &
        & 0.30240e+01,0.11079e+02,0.13703e+02,0.15411e+02,0.11075e+02 /)
      kbo(:, 2,41,12) = (/ &
        & 0.35998e+01,0.12722e+02,0.15561e+02,0.17259e+02,0.12509e+02 /)
      kbo(:, 3,41,12) = (/ &
        & 0.42766e+01,0.14402e+02,0.17450e+02,0.19096e+02,0.13938e+02 /)
      kbo(:, 4,41,12) = (/ &
        & 0.50663e+01,0.16123e+02,0.19365e+02,0.20905e+02,0.15352e+02 /)
      kbo(:, 5,41,12) = (/ &
        & 0.60051e+01,0.17908e+02,0.21295e+02,0.22653e+02,0.16735e+02 /)
      kbo(:, 1,42,12) = (/ &
        & 0.28652e+01,0.10648e+02,0.13219e+02,0.14913e+02,0.10689e+02 /)
      kbo(:, 2,42,12) = (/ &
        & 0.34153e+01,0.12278e+02,0.15063e+02,0.16761e+02,0.12121e+02 /)
      kbo(:, 3,42,12) = (/ &
        & 0.40672e+01,0.13952e+02,0.16947e+02,0.18606e+02,0.13557e+02 /)
      kbo(:, 4,42,12) = (/ &
        & 0.48264e+01,0.15661e+02,0.18858e+02,0.20426e+02,0.14977e+02 /)
      kbo(:, 5,42,12) = (/ &
        & 0.57266e+01,0.17431e+02,0.20787e+02,0.22197e+02,0.16370e+02 /)
      kbo(:, 1,43,12) = (/ &
        & 0.26870e+01,0.10134e+02,0.12642e+02,0.14316e+02,0.10228e+02 /)
      kbo(:, 2,43,12) = (/ &
        & 0.32108e+01,0.11745e+02,0.14465e+02,0.16161e+02,0.11657e+02 /)
      kbo(:, 3,43,12) = (/ &
        & 0.38308e+01,0.13408e+02,0.16340e+02,0.18012e+02,0.13095e+02 /)
      kbo(:, 4,43,12) = (/ &
        & 0.45569e+01,0.15107e+02,0.18246e+02,0.19843e+02,0.14521e+02 /)
      kbo(:, 5,43,12) = (/ &
        & 0.54100e+01,0.16859e+02,0.20173e+02,0.21637e+02,0.15927e+02 /)
      kbo(:, 1,44,12) = (/ &
        & 0.25051e+01,0.95885e+01,0.12032e+02,0.13682e+02,0.97372e+01 /)
      kbo(:, 2,44,12) = (/ &
        & 0.30054e+01,0.11180e+02,0.13825e+02,0.15517e+02,0.11159e+02 /)
      kbo(:, 3,44,12) = (/ &
        & 0.35923e+01,0.12828e+02,0.15690e+02,0.17372e+02,0.12597e+02 /)
      kbo(:, 4,44,12) = (/ &
        & 0.42861e+01,0.14518e+02,0.17591e+02,0.19215e+02,0.14031e+02 /)
      kbo(:, 5,44,12) = (/ &
        & 0.50891e+01,0.16248e+02,0.19511e+02,0.21026e+02,0.15447e+02 /)
      kbo(:, 1,45,12) = (/ &
        & 0.23284e+01,0.90519e+01,0.11435e+02,0.13049e+02,0.92487e+01 /)
      kbo(:, 2,45,12) = (/ &
        & 0.28153e+01,0.10623e+02,0.13197e+02,0.14880e+02,0.10666e+02 /)
      kbo(:, 3,45,12) = (/ &
        & 0.33686e+01,0.12254e+02,0.15046e+02,0.16733e+02,0.12101e+02 /)
      kbo(:, 4,45,12) = (/ &
        & 0.40279e+01,0.13936e+02,0.16938e+02,0.18583e+02,0.13540e+02 /)
      kbo(:, 5,45,12) = (/ &
        & 0.47894e+01,0.15648e+02,0.18852e+02,0.20408e+02,0.14963e+02 /)
      kbo(:, 1,46,12) = (/ &
        & 0.21477e+01,0.84947e+01,0.10808e+02,0.12382e+02,0.87316e+01 /)
      kbo(:, 2,46,12) = (/ &
        & 0.26237e+01,0.10040e+02,0.12543e+02,0.14206e+02,0.10145e+02 /)
      kbo(:, 3,46,12) = (/ &
        & 0.31493e+01,0.11653e+02,0.14367e+02,0.16054e+02,0.11575e+02 /)
      kbo(:, 4,46,12) = (/ &
        & 0.37687e+01,0.13319e+02,0.16247e+02,0.17910e+02,0.13015e+02 /)
      kbo(:, 5,46,12) = (/ &
        & 0.44919e+01,0.15018e+02,0.18154e+02,0.19746e+02,0.14446e+02 /)
      kbo(:, 1,47,12) = (/ &
        & 0.19539e+01,0.78866e+01,0.10121e+02,0.11642e+02,0.81629e+01 /)
      kbo(:, 2,47,12) = (/ &
        & 0.24188e+01,0.94011e+01,0.11827e+02,0.13461e+02,0.95671e+01 /)
      kbo(:, 3,47,12) = (/ &
        & 0.29183e+01,0.10990e+02,0.13614e+02,0.15297e+02,0.10990e+02 /)
      kbo(:, 4,47,12) = (/ &
        & 0.34981e+01,0.12636e+02,0.15480e+02,0.17155e+02,0.12429e+02 /)
      kbo(:, 5,47,12) = (/ &
        & 0.41787e+01,0.14323e+02,0.17378e+02,0.19005e+02,0.13866e+02 /)
      kbo(:, 1,48,12) = (/ &
        & 0.17686e+01,0.73016e+01,0.94471e+01,0.10908e+02,0.76062e+01 /)
      kbo(:, 2,48,12) = (/ &
        & 0.22191e+01,0.87750e+01,0.11125e+02,0.12718e+02,0.89921e+01 /)
      kbo(:, 3,48,12) = (/ &
        & 0.27045e+01,0.10336e+02,0.12878e+02,0.14548e+02,0.10409e+02 /)
      kbo(:, 4,48,12) = (/ &
        & 0.32460e+01,0.11962e+02,0.14721e+02,0.16399e+02,0.11843e+02 /)
      kbo(:, 5,48,12) = (/ &
        & 0.38847e+01,0.13635e+02,0.16605e+02,0.18256e+02,0.13285e+02 /)
      kbo(:, 1,49,12) = (/ &
        & 0.15926e+01,0.67448e+01,0.87885e+01,0.10183e+02,0.70558e+01 /)
      kbo(:, 2,49,12) = (/ &
        & 0.20265e+01,0.81616e+01,0.10434e+02,0.11978e+02,0.84210e+01 /)
      kbo(:, 3,49,12) = (/ &
        & 0.24995e+01,0.96943e+01,0.12158e+02,0.13804e+02,0.98335e+01 /)
      kbo(:, 4,49,12) = (/ &
        & 0.30106e+01,0.11296e+02,0.13964e+02,0.15645e+02,0.11261e+02 /)
      kbo(:, 5,49,12) = (/ &
        & 0.36091e+01,0.12953e+02,0.15838e+02,0.17505e+02,0.12701e+02 /)
      kbo(:, 1,50,12) = (/ &
        & 0.14367e+01,0.62503e+01,0.81839e+01,0.95114e+01,0.65470e+01 /)
      kbo(:, 2,50,12) = (/ &
        & 0.18513e+01,0.76037e+01,0.97986e+01,0.11290e+02,0.78962e+01 /)
      kbo(:, 3,50,12) = (/ &
        & 0.23123e+01,0.91032e+01,0.11496e+02,0.13108e+02,0.92947e+01 /)
      kbo(:, 4,50,12) = (/ &
        & 0.28056e+01,0.10680e+02,0.13267e+02,0.14942e+02,0.10716e+02 /)
      kbo(:, 5,50,12) = (/ &
        & 0.33664e+01,0.12318e+02,0.15124e+02,0.16800e+02,0.12153e+02 /)
      kbo(:, 1,51,12) = (/ &
        & 0.12944e+01,0.57936e+01,0.76117e+01,0.88742e+01,0.60642e+01 /)
      kbo(:, 2,51,12) = (/ &
        & 0.16888e+01,0.70852e+01,0.91933e+01,0.10628e+02,0.73944e+01 /)
      kbo(:, 3,51,12) = (/ &
        & 0.21353e+01,0.85416e+01,0.10863e+02,0.12436e+02,0.87735e+01 /)
      kbo(:, 4,51,12) = (/ &
        & 0.26169e+01,0.10093e+02,0.12607e+02,0.14266e+02,0.10192e+02 /)
      kbo(:, 5,51,12) = (/ &
        & 0.31479e+01,0.11711e+02,0.14438e+02,0.16116e+02,0.11624e+02 /)
      kbo(:, 1,52,12) = (/ &
        & 0.11616e+01,0.53570e+01,0.70533e+01,0.82560e+01,0.55953e+01 /)
      kbo(:, 2,52,12) = (/ &
        & 0.15340e+01,0.65899e+01,0.86019e+01,0.99750e+01,0.68982e+01 /)
      kbo(:, 3,52,12) = (/ &
        & 0.19643e+01,0.79903e+01,0.10241e+02,0.11768e+02,0.82604e+01 /)
      kbo(:, 4,52,12) = (/ &
        & 0.24347e+01,0.95157e+01,0.11958e+02,0.13593e+02,0.96707e+01 /)
      kbo(:, 5,52,12) = (/ &
        & 0.29410e+01,0.11112e+02,0.13756e+02,0.15434e+02,0.11097e+02 /)
      kbo(:, 1,53,12) = (/ &
        & 0.10377e+01,0.49398e+01,0.65141e+01,0.76518e+01,0.51386e+01 /)
      kbo(:, 2,53,12) = (/ &
        & 0.13876e+01,0.61188e+01,0.80207e+01,0.93291e+01,0.64095e+01 /)
      kbo(:, 3,53,12) = (/ &
        & 0.17987e+01,0.74567e+01,0.96292e+01,0.11104e+02,0.77562e+01 /)
      kbo(:, 4,53,12) = (/ &
        & 0.22559e+01,0.89467e+01,0.11320e+02,0.12921e+02,0.91504e+01 /)
      kbo(:, 5,53,12) = (/ &
        & 0.27477e+01,0.10518e+02,0.13086e+02,0.14756e+02,0.10571e+02 /)
      kbo(:, 1,54,12) = (/ &
        & 0.93266e+00,0.45754e+01,0.60420e+01,0.71108e+01,0.47321e+01 /)
      kbo(:, 2,54,12) = (/ &
        & 0.12608e+01,0.57055e+01,0.75003e+01,0.87512e+01,0.59717e+01 /)
      kbo(:, 3,54,12) = (/ &
        & 0.16525e+01,0.69875e+01,0.90782e+01,0.10501e+02,0.72982e+01 /)
      kbo(:, 4,54,12) = (/ &
        & 0.20962e+01,0.84351e+01,0.10744e+02,0.12308e+02,0.86747e+01 /)
      kbo(:, 5,54,12) = (/ &
        & 0.25775e+01,0.99827e+01,0.12485e+02,0.14138e+02,0.10092e+02 /)
      kbo(:, 1,55,12) = (/ &
        & 0.84048e+00,0.42428e+01,0.56145e+01,0.66054e+01,0.43544e+01 /)
      kbo(:, 2,55,12) = (/ &
        & 0.11472e+01,0.53270e+01,0.70144e+01,0.82122e+01,0.55615e+01 /)
      kbo(:, 3,55,12) = (/ &
        & 0.15181e+01,0.65556e+01,0.85601e+01,0.99280e+01,0.68631e+01 /)
      kbo(:, 4,55,12) = (/ &
        & 0.19474e+01,0.79524e+01,0.10198e+02,0.11721e+02,0.82252e+01 /)
      kbo(:, 5,55,12) = (/ &
        & 0.24188e+01,0.94776e+01,0.11916e+02,0.13548e+02,0.96351e+01 /)
      kbo(:, 1,56,12) = (/ &
        & 0.75447e+00,0.39270e+01,0.52064e+01,0.61093e+01,0.39870e+01 /)
      kbo(:, 2,56,12) = (/ &
        & 0.10395e+01,0.49623e+01,0.65429e+01,0.76840e+01,0.51623e+01 /)
      kbo(:, 3,56,12) = (/ &
        & 0.13908e+01,0.61440e+01,0.80522e+01,0.93640e+01,0.64360e+01 /)
      kbo(:, 4,56,12) = (/ &
        & 0.18031e+01,0.74859e+01,0.96627e+01,0.11140e+02,0.77842e+01 /)
      kbo(:, 5,56,12) = (/ &
        & 0.22626e+01,0.89798e+01,0.11358e+02,0.12960e+02,0.91800e+01 /)
      kbo(:, 1,57,12) = (/ &
        & 0.67513e+00,0.36336e+01,0.48180e+01,0.56247e+01,0.36284e+01 /)
      kbo(:, 2,57,12) = (/ &
        & 0.93951e+00,0.46135e+01,0.60910e+01,0.71671e+01,0.47736e+01 /)
      kbo(:, 3,57,12) = (/ &
        & 0.12699e+01,0.57481e+01,0.75541e+01,0.88107e+01,0.60168e+01 /)
      kbo(:, 4,57,12) = (/ &
        & 0.16637e+01,0.70362e+01,0.91351e+01,0.10564e+02,0.73465e+01 /)
      kbo(:, 5,57,12) = (/ &
        & 0.21102e+01,0.84904e+01,0.10807e+02,0.12374e+02,0.87256e+01 /)
      kbo(:, 1,58,12) = (/ &
        & 0.60371e+00,0.33725e+01,0.44640e+01,0.51801e+01,0.32968e+01 /)
      kbo(:, 2,58,12) = (/ &
        & 0.85131e+00,0.42951e+01,0.56822e+01,0.66873e+01,0.44155e+01 /)
      kbo(:, 3,58,12) = (/ &
        & 0.11611e+01,0.53867e+01,0.70919e+01,0.82985e+01,0.56282e+01 /)
      kbo(:, 4,58,12) = (/ &
        & 0.15366e+01,0.66258e+01,0.86445e+01,0.10022e+02,0.69358e+01 /)
      kbo(:, 5,58,12) = (/ &
        & 0.19698e+01,0.80329e+01,0.10290e+02,0.11819e+02,0.83004e+01 /)
      kbo(:, 1,59,12) = (/ &
        & 0.57552e+00,0.32717e+01,0.43250e+01,0.50045e+01,0.31668e+01 /)
      kbo(:, 2,59,12) = (/ &
        & 0.81716e+00,0.41713e+01,0.55225e+01,0.64964e+01,0.42740e+01 /)
      kbo(:, 3,59,12) = (/ &
        & 0.11190e+01,0.52446e+01,0.69091e+01,0.80966e+01,0.54744e+01 /)
      kbo(:, 4,59,12) = (/ &
        & 0.14869e+01,0.64659e+01,0.84502e+01,0.98065e+01,0.67716e+01 /)
      kbo(:, 5,59,12) = (/ &
        & 0.19139e+01,0.78535e+01,0.10085e+02,0.11598e+02,0.81311e+01 /)
      kbo(:, 1,13,13) = (/ &
        & 0.79406e+02,0.76977e+02,0.79398e+02,0.72265e+02,0.70608e+02 /)
      kbo(:, 2,13,13) = (/ &
        & 0.78716e+02,0.76325e+02,0.79145e+02,0.72561e+02,0.71233e+02 /)
      kbo(:, 3,13,13) = (/ &
        & 0.77960e+02,0.75684e+02,0.78864e+02,0.72811e+02,0.71703e+02 /)
      kbo(:, 4,13,13) = (/ &
        & 0.77172e+02,0.75038e+02,0.78462e+02,0.73003e+02,0.72067e+02 /)
      kbo(:, 5,13,13) = (/ &
        & 0.76342e+02,0.74357e+02,0.78015e+02,0.73077e+02,0.72406e+02 /)
      kbo(:, 1,14,13) = (/ &
        & 0.74002e+02,0.75964e+02,0.80244e+02,0.73931e+02,0.67973e+02 /)
      kbo(:, 2,14,13) = (/ &
        & 0.73259e+02,0.75350e+02,0.80187e+02,0.74373e+02,0.68671e+02 /)
      kbo(:, 3,14,13) = (/ &
        & 0.72511e+02,0.74741e+02,0.79998e+02,0.74718e+02,0.69297e+02 /)
      kbo(:, 4,14,13) = (/ &
        & 0.71760e+02,0.74129e+02,0.79694e+02,0.74933e+02,0.69925e+02 /)
      kbo(:, 5,14,13) = (/ &
        & 0.70963e+02,0.73482e+02,0.79282e+02,0.75062e+02,0.70592e+02 /)
      kbo(:, 1,15,13) = (/ &
        & 0.67727e+02,0.74204e+02,0.79973e+02,0.74524e+02,0.64503e+02 /)
      kbo(:, 2,15,13) = (/ &
        & 0.66995e+02,0.73663e+02,0.80067e+02,0.75070e+02,0.65404e+02 /)
      kbo(:, 3,15,13) = (/ &
        & 0.66299e+02,0.73080e+02,0.80001e+02,0.75489e+02,0.66341e+02 /)
      kbo(:, 4,15,13) = (/ &
        & 0.65584e+02,0.72498e+02,0.79808e+02,0.75814e+02,0.67293e+02 /)
      kbo(:, 5,15,13) = (/ &
        & 0.64881e+02,0.71894e+02,0.79644e+02,0.76073e+02,0.68159e+02 /)
      kbo(:, 1,16,13) = (/ &
        & 0.60910e+02,0.71706e+02,0.78658e+02,0.73971e+02,0.60740e+02 /)
      kbo(:, 2,16,13) = (/ &
        & 0.60264e+02,0.71204e+02,0.78897e+02,0.74647e+02,0.61882e+02 /)
      kbo(:, 3,16,13) = (/ &
        & 0.59646e+02,0.70743e+02,0.78998e+02,0.75253e+02,0.63062e+02 /)
      kbo(:, 4,16,13) = (/ &
        & 0.59033e+02,0.70274e+02,0.79093e+02,0.75819e+02,0.64263e+02 /)
      kbo(:, 5,16,13) = (/ &
        & 0.58482e+02,0.69838e+02,0.79175e+02,0.76359e+02,0.65453e+02 /)
      kbo(:, 1,17,13) = (/ &
        & 0.53962e+02,0.68666e+02,0.76384e+02,0.72467e+02,0.57058e+02 /)
      kbo(:, 2,17,13) = (/ &
        & 0.53430e+02,0.68393e+02,0.76843e+02,0.73413e+02,0.58438e+02 /)
      kbo(:, 3,17,13) = (/ &
        & 0.52920e+02,0.68105e+02,0.77273e+02,0.74323e+02,0.59869e+02 /)
      kbo(:, 4,17,13) = (/ &
        & 0.52483e+02,0.67847e+02,0.77698e+02,0.75214e+02,0.61307e+02 /)
      kbo(:, 5,17,13) = (/ &
        & 0.52082e+02,0.67535e+02,0.78034e+02,0.76077e+02,0.62785e+02 /)
      kbo(:, 1,18,13) = (/ &
        & 0.47235e+02,0.65232e+02,0.73440e+02,0.70305e+02,0.53676e+02 /)
      kbo(:, 2,18,13) = (/ &
        & 0.46798e+02,0.65205e+02,0.74239e+02,0.71589e+02,0.55262e+02 /)
      kbo(:, 3,18,13) = (/ &
        & 0.46439e+02,0.65179e+02,0.75037e+02,0.72870e+02,0.56922e+02 /)
      kbo(:, 4,18,13) = (/ &
        & 0.46165e+02,0.65077e+02,0.75787e+02,0.74113e+02,0.58606e+02 /)
      kbo(:, 5,18,13) = (/ &
        & 0.46076e+02,0.64950e+02,0.76497e+02,0.75319e+02,0.60364e+02 /)
      kbo(:, 1,19,13) = (/ &
        & 0.40875e+02,0.61443e+02,0.70167e+02,0.67815e+02,0.50666e+02 /)
      kbo(:, 2,19,13) = (/ &
        & 0.40599e+02,0.61754e+02,0.71348e+02,0.69451e+02,0.52443e+02 /)
      kbo(:, 3,19,13) = (/ &
        & 0.40423e+02,0.61971e+02,0.72494e+02,0.71103e+02,0.54265e+02 /)
      kbo(:, 4,19,13) = (/ &
        & 0.40489e+02,0.62135e+02,0.73624e+02,0.72723e+02,0.56176e+02 /)
      kbo(:, 5,19,13) = (/ &
        & 0.40909e+02,0.62251e+02,0.74691e+02,0.74287e+02,0.58151e+02 /)
      kbo(:, 1,20,13) = (/ &
        & 0.35203e+02,0.57554e+02,0.66740e+02,0.65266e+02,0.47986e+02 /)
      kbo(:, 2,20,13) = (/ &
        & 0.35059e+02,0.58164e+02,0.68281e+02,0.67270e+02,0.49928e+02 /)
      kbo(:, 3,20,13) = (/ &
        & 0.35179e+02,0.58679e+02,0.69865e+02,0.69298e+02,0.51957e+02 /)
      kbo(:, 4,20,13) = (/ &
        & 0.35687e+02,0.59136e+02,0.71375e+02,0.71295e+02,0.54068e+02 /)
      kbo(:, 5,20,13) = (/ &
        & 0.36572e+02,0.59563e+02,0.72814e+02,0.73197e+02,0.56184e+02 /)
      kbo(:, 1,21,13) = (/ &
        & 0.30294e+02,0.53730e+02,0.63335e+02,0.62843e+02,0.45639e+02 /)
      kbo(:, 2,21,13) = (/ &
        & 0.30407e+02,0.54622e+02,0.65309e+02,0.65230e+02,0.47736e+02 /)
      kbo(:, 3,21,13) = (/ &
        & 0.30898e+02,0.55470e+02,0.67283e+02,0.67630e+02,0.49955e+02 /)
      kbo(:, 4,21,13) = (/ &
        & 0.31814e+02,0.56234e+02,0.69205e+02,0.69979e+02,0.52223e+02 /)
      kbo(:, 5,21,13) = (/ &
        & 0.33171e+02,0.57002e+02,0.70988e+02,0.72170e+02,0.54507e+02 /)
      kbo(:, 1,22,13) = (/ &
        & 0.26203e+02,0.50178e+02,0.60369e+02,0.60883e+02,0.43752e+02 /)
      kbo(:, 2,22,13) = (/ &
        & 0.26668e+02,0.51399e+02,0.62731e+02,0.63628e+02,0.46055e+02 /)
      kbo(:, 3,22,13) = (/ &
        & 0.27573e+02,0.52567e+02,0.65094e+02,0.66337e+02,0.48427e+02 /)
      kbo(:, 4,22,13) = (/ &
        & 0.28933e+02,0.53710e+02,0.67379e+02,0.68992e+02,0.50840e+02 /)
      kbo(:, 5,22,13) = (/ &
        & 0.30713e+02,0.54842e+02,0.69500e+02,0.71453e+02,0.53313e+02 /)
      kbo(:, 1,23,13) = (/ &
        & 0.22949e+02,0.47062e+02,0.57786e+02,0.59287e+02,0.42207e+02 /)
      kbo(:, 2,23,13) = (/ &
        & 0.23779e+02,0.48563e+02,0.60567e+02,0.62337e+02,0.44709e+02 /)
      kbo(:, 3,23,13) = (/ &
        & 0.25087e+02,0.50088e+02,0.63282e+02,0.65361e+02,0.47224e+02 /)
      kbo(:, 4,23,13) = (/ &
        & 0.26833e+02,0.51601e+02,0.65861e+02,0.68253e+02,0.49790e+02 /)
      kbo(:, 5,23,13) = (/ &
        & 0.28975e+02,0.53148e+02,0.68312e+02,0.70979e+02,0.52442e+02 /)
      kbo(:, 1,24,13) = (/ &
        & 0.20450e+02,0.44418e+02,0.55719e+02,0.58070e+02,0.41028e+02 /)
      kbo(:, 2,24,13) = (/ &
        & 0.21647e+02,0.46218e+02,0.58860e+02,0.61413e+02,0.43697e+02 /)
      kbo(:, 3,24,13) = (/ &
        & 0.23313e+02,0.48082e+02,0.61856e+02,0.64696e+02,0.46357e+02 /)
      kbo(:, 4,24,13) = (/ &
        & 0.25383e+02,0.49987e+02,0.64735e+02,0.67792e+02,0.49079e+02 /)
      kbo(:, 5,24,13) = (/ &
        & 0.27788e+02,0.51882e+02,0.67449e+02,0.70725e+02,0.51885e+02 /)
      kbo(:, 1,25,13) = (/ &
        & 0.18632e+02,0.42267e+02,0.54194e+02,0.57249e+02,0.40189e+02 /)
      kbo(:, 2,25,13) = (/ &
        & 0.20151e+02,0.44393e+02,0.57583e+02,0.60858e+02,0.43004e+02 /)
      kbo(:, 3,25,13) = (/ &
        & 0.22101e+02,0.46593e+02,0.60865e+02,0.64337e+02,0.45809e+02 /)
      kbo(:, 4,25,13) = (/ &
        & 0.24391e+02,0.48836e+02,0.63984e+02,0.67613e+02,0.48696e+02 /)
      kbo(:, 5,25,13) = (/ &
        & 0.26959e+02,0.50995e+02,0.66882e+02,0.70682e+02,0.51602e+02 /)
      kbo(:, 1,26,13) = (/ &
        & 0.17370e+02,0.40657e+02,0.53173e+02,0.56858e+02,0.39692e+02 /)
      kbo(:, 2,26,13) = (/ &
        & 0.19155e+02,0.43087e+02,0.56801e+02,0.60671e+02,0.42632e+02 /)
      kbo(:, 3,26,13) = (/ &
        & 0.21292e+02,0.45598e+02,0.60302e+02,0.64290e+02,0.45592e+02 /)
      kbo(:, 4,26,13) = (/ &
        & 0.23727e+02,0.48098e+02,0.63591e+02,0.67690e+02,0.48603e+02 /)
      kbo(:, 5,26,13) = (/ &
        & 0.26455e+02,0.50493e+02,0.66616e+02,0.70861e+02,0.51588e+02 /)
      kbo(:, 1,27,13) = (/ &
        & 0.16499e+02,0.39533e+02,0.52563e+02,0.56787e+02,0.39461e+02 /)
      kbo(:, 2,27,13) = (/ &
        & 0.18462e+02,0.42240e+02,0.56391e+02,0.60738e+02,0.42525e+02 /)
      kbo(:, 3,27,13) = (/ &
        & 0.20737e+02,0.45009e+02,0.60060e+02,0.64459e+02,0.45612e+02 /)
      kbo(:, 4,27,13) = (/ &
        & 0.23336e+02,0.47712e+02,0.63452e+02,0.67944e+02,0.48705e+02 /)
      kbo(:, 5,27,13) = (/ &
        & 0.26215e+02,0.50322e+02,0.66583e+02,0.71174e+02,0.51756e+02 /)
      kbo(:, 1,28,13) = (/ &
        & 0.15882e+02,0.38845e+02,0.52318e+02,0.56965e+02,0.39468e+02 /)
      kbo(:, 2,28,13) = (/ &
        & 0.17994e+02,0.41785e+02,0.56289e+02,0.61007e+02,0.42649e+02 /)
      kbo(:, 3,28,13) = (/ &
        & 0.20424e+02,0.44749e+02,0.60052e+02,0.64808e+02,0.45826e+02 /)
      kbo(:, 4,28,13) = (/ &
        & 0.23178e+02,0.47630e+02,0.63526e+02,0.68347e+02,0.48967e+02 /)
      kbo(:, 5,28,13) = (/ &
        & 0.26217e+02,0.50385e+02,0.66714e+02,0.71584e+02,0.52071e+02 /)
      kbo(:, 1,29,13) = (/ &
        & 0.15496e+02,0.38533e+02,0.52388e+02,0.57377e+02,0.39687e+02 /)
      kbo(:, 2,29,13) = (/ &
        & 0.17758e+02,0.41667e+02,0.56458e+02,0.61470e+02,0.42963e+02 /)
      kbo(:, 3,29,13) = (/ &
        & 0.20345e+02,0.44782e+02,0.60267e+02,0.65320e+02,0.46203e+02 /)
      kbo(:, 4,29,13) = (/ &
        & 0.23257e+02,0.47788e+02,0.63789e+02,0.68865e+02,0.49378e+02 /)
      kbo(:, 5,29,13) = (/ &
        & 0.26442e+02,0.50623e+02,0.67004e+02,0.72085e+02,0.52513e+02 /)
      kbo(:, 1,30,13) = (/ &
        & 0.15305e+02,0.38520e+02,0.52687e+02,0.57942e+02,0.40075e+02 /)
      kbo(:, 2,30,13) = (/ &
        & 0.17725e+02,0.41787e+02,0.56809e+02,0.62069e+02,0.43408e+02 /)
      kbo(:, 3,30,13) = (/ &
        & 0.20471e+02,0.45011e+02,0.60646e+02,0.65935e+02,0.46678e+02 /)
      kbo(:, 4,30,13) = (/ &
        & 0.23532e+02,0.48109e+02,0.64191e+02,0.69457e+02,0.49879e+02 /)
      kbo(:, 5,30,13) = (/ &
        & 0.26835e+02,0.50980e+02,0.67409e+02,0.72648e+02,0.53041e+02 /)
      kbo(:, 1,31,13) = (/ &
        & 0.15319e+02,0.38759e+02,0.53187e+02,0.58637e+02,0.40597e+02 /)
      kbo(:, 2,31,13) = (/ &
        & 0.17890e+02,0.42121e+02,0.57326e+02,0.62778e+02,0.43969e+02 /)
      kbo(:, 3,31,13) = (/ &
        & 0.20784e+02,0.45419e+02,0.61174e+02,0.66627e+02,0.47246e+02 /)
      kbo(:, 4,31,13) = (/ &
        & 0.23963e+02,0.48555e+02,0.64709e+02,0.70119e+02,0.50470e+02 /)
      kbo(:, 5,31,13) = (/ &
        & 0.27377e+02,0.51448e+02,0.67912e+02,0.73265e+02,0.53642e+02 /)
      kbo(:, 1,32,13) = (/ &
        & 0.15518e+02,0.39176e+02,0.53833e+02,0.59441e+02,0.41231e+02 /)
      kbo(:, 2,32,13) = (/ &
        & 0.18219e+02,0.42608e+02,0.57967e+02,0.63575e+02,0.44614e+02 /)
      kbo(:, 3,32,13) = (/ &
        & 0.21240e+02,0.45958e+02,0.61807e+02,0.67376e+02,0.47899e+02 /)
      kbo(:, 4,32,13) = (/ &
        & 0.24535e+02,0.49103e+02,0.65323e+02,0.70819e+02,0.51129e+02 /)
      kbo(:, 5,32,13) = (/ &
        & 0.28030e+02,0.51991e+02,0.68477e+02,0.73912e+02,0.54297e+02 /)
      kbo(:, 1,33,13) = (/ &
        & 0.15857e+02,0.39728e+02,0.54587e+02,0.60326e+02,0.41934e+02 /)
      kbo(:, 2,33,13) = (/ &
        & 0.18681e+02,0.43207e+02,0.58700e+02,0.64428e+02,0.45312e+02 /)
      kbo(:, 3,33,13) = (/ &
        & 0.21817e+02,0.46584e+02,0.62510e+02,0.68164e+02,0.48601e+02 /)
      kbo(:, 4,33,13) = (/ &
        & 0.25208e+02,0.49716e+02,0.65986e+02,0.71546e+02,0.51832e+02 /)
      kbo(:, 5,33,13) = (/ &
        & 0.28769e+02,0.52588e+02,0.69085e+02,0.74576e+02,0.54996e+02 /)
      kbo(:, 1,34,13) = (/ &
        & 0.16218e+02,0.40255e+02,0.55264e+02,0.61104e+02,0.42563e+02 /)
      kbo(:, 2,34,13) = (/ &
        & 0.19136e+02,0.43775e+02,0.59363e+02,0.65173e+02,0.45933e+02 /)
      kbo(:, 3,34,13) = (/ &
        & 0.22367e+02,0.47148e+02,0.63138e+02,0.68848e+02,0.49223e+02 /)
      kbo(:, 4,34,13) = (/ &
        & 0.25824e+02,0.50264e+02,0.66569e+02,0.72180e+02,0.52454e+02 /)
      kbo(:, 5,34,13) = (/ &
        & 0.29432e+02,0.53119e+02,0.69617e+02,0.75149e+02,0.55607e+02 /)
      kbo(:, 1,35,13) = (/ &
        & 0.16382e+02,0.40509e+02,0.55591e+02,0.61512e+02,0.42891e+02 /)
      kbo(:, 2,35,13) = (/ &
        & 0.19362e+02,0.44056e+02,0.59682e+02,0.65556e+02,0.46259e+02 /)
      kbo(:, 3,35,13) = (/ &
        & 0.22646e+02,0.47437e+02,0.63450e+02,0.69212e+02,0.49551e+02 /)
      kbo(:, 4,35,13) = (/ &
        & 0.26140e+02,0.50553e+02,0.66864e+02,0.72519e+02,0.52785e+02 /)
      kbo(:, 5,35,13) = (/ &
        & 0.29778e+02,0.53403e+02,0.69889e+02,0.75460e+02,0.55937e+02 /)
      kbo(:, 1,36,13) = (/ &
        & 0.16282e+02,0.40412e+02,0.55499e+02,0.61489e+02,0.42866e+02 /)
      kbo(:, 2,36,13) = (/ &
        & 0.19286e+02,0.43996e+02,0.59618e+02,0.65550e+02,0.46244e+02 /)
      kbo(:, 3,36,13) = (/ &
        & 0.22586e+02,0.47399e+02,0.63406e+02,0.69212e+02,0.49542e+02 /)
      kbo(:, 4,36,13) = (/ &
        & 0.26096e+02,0.50533e+02,0.66829e+02,0.72526e+02,0.52781e+02 /)
      kbo(:, 5,36,13) = (/ &
        & 0.29750e+02,0.53407e+02,0.69875e+02,0.75478e+02,0.55943e+02 /)
      kbo(:, 1,37,13) = (/ &
        & 0.15776e+02,0.39797e+02,0.54788e+02,0.60844e+02,0.42332e+02 /)
      kbo(:, 2,37,13) = (/ &
        & 0.18757e+02,0.43418e+02,0.58970e+02,0.64965e+02,0.45736e+02 /)
      kbo(:, 3,37,13) = (/ &
        & 0.22032e+02,0.46879e+02,0.62830e+02,0.68697e+02,0.49053e+02 /)
      kbo(:, 4,37,13) = (/ &
        & 0.25533e+02,0.50076e+02,0.66324e+02,0.72072e+02,0.52311e+02 /)
      kbo(:, 5,37,13) = (/ &
        & 0.29180e+02,0.52997e+02,0.69437e+02,0.75080e+02,0.55481e+02 /)
      kbo(:, 1,38,13) = (/ &
        & 0.15271e+02,0.39166e+02,0.54054e+02,0.60165e+02,0.41777e+02 /)
      kbo(:, 2,38,13) = (/ &
        & 0.18227e+02,0.42823e+02,0.58302e+02,0.64350e+02,0.45207e+02 /)
      kbo(:, 3,38,13) = (/ &
        & 0.21473e+02,0.46333e+02,0.62224e+02,0.68144e+02,0.48540e+02 /)
      kbo(:, 4,38,13) = (/ &
        & 0.24954e+02,0.49588e+02,0.65790e+02,0.71578e+02,0.51811e+02 /)
      kbo(:, 5,38,13) = (/ &
        & 0.28592e+02,0.52564e+02,0.68973e+02,0.74653e+02,0.55000e+02 /)
      kbo(:, 1,39,13) = (/ &
        & 0.14788e+02,0.38557e+02,0.53339e+02,0.59493e+02,0.41232e+02 /)
      kbo(:, 2,39,13) = (/ &
        & 0.17725e+02,0.42239e+02,0.57643e+02,0.63735e+02,0.44689e+02 /)
      kbo(:, 3,39,13) = (/ &
        & 0.20936e+02,0.45800e+02,0.61629e+02,0.67599e+02,0.48036e+02 /)
      kbo(:, 4,39,13) = (/ &
        & 0.24393e+02,0.49102e+02,0.65258e+02,0.71089e+02,0.51322e+02 /)
      kbo(:, 5,39,13) = (/ &
        & 0.28020e+02,0.52130e+02,0.68507e+02,0.74225e+02,0.54528e+02 /)
      kbo(:, 1,40,13) = (/ &
        & 0.14035e+02,0.37576e+02,0.52178e+02,0.58374e+02,0.40328e+02 /)
      kbo(:, 2,40,13) = (/ &
        & 0.16933e+02,0.41290e+02,0.56557e+02,0.62694e+02,0.43829e+02 /)
      kbo(:, 3,40,13) = (/ &
        & 0.20073e+02,0.44909e+02,0.60638e+02,0.66668e+02,0.47203e+02 /)
      kbo(:, 4,40,13) = (/ &
        & 0.23486e+02,0.48287e+02,0.64365e+02,0.70250e+02,0.50504e+02 /)
      kbo(:, 5,40,13) = (/ &
        & 0.27084e+02,0.51393e+02,0.67719e+02,0.73485e+02,0.53736e+02 /)
      kbo(:, 1,41,13) = (/ &
        & 0.13270e+02,0.36551e+02,0.50952e+02,0.57187e+02,0.39381e+02 /)
      kbo(:, 2,41,13) = (/ &
        & 0.16132e+02,0.40293e+02,0.55396e+02,0.61573e+02,0.42921e+02 /)
      kbo(:, 3,41,13) = (/ &
        & 0.19195e+02,0.43957e+02,0.59575e+02,0.65658e+02,0.46320e+02 /)
      kbo(:, 4,41,13) = (/ &
        & 0.22552e+02,0.47415e+02,0.63413e+02,0.69340e+02,0.49639e+02 /)
      kbo(:, 5,41,13) = (/ &
        & 0.26115e+02,0.50603e+02,0.66868e+02,0.72675e+02,0.52897e+02 /)
      kbo(:, 1,42,13) = (/ &
        & 0.12533e+02,0.35537e+02,0.49715e+02,0.55979e+02,0.38430e+02 /)
      kbo(:, 2,42,13) = (/ &
        & 0.15340e+02,0.39292e+02,0.54229e+02,0.60445e+02,0.42004e+02 /)
      kbo(:, 3,42,13) = (/ &
        & 0.18342e+02,0.42991e+02,0.58494e+02,0.64631e+02,0.45437e+02 /)
      kbo(:, 4,42,13) = (/ &
        & 0.21634e+02,0.46527e+02,0.62435e+02,0.68417e+02,0.48777e+02 /)
      kbo(:, 5,42,13) = (/ &
        & 0.25154e+02,0.49791e+02,0.65989e+02,0.71836e+02,0.52054e+02 /)
      kbo(:, 1,43,13) = (/ &
        & 0.11668e+02,0.34309e+02,0.48203e+02,0.54498e+02,0.37270e+02 /)
      kbo(:, 2,43,13) = (/ &
        & 0.14402e+02,0.38082e+02,0.52797e+02,0.59048e+02,0.40873e+02 /)
      kbo(:, 3,43,13) = (/ &
        & 0.17344e+02,0.41812e+02,0.57160e+02,0.63341e+02,0.44355e+02 /)
      kbo(:, 4,43,13) = (/ &
        & 0.20545e+02,0.45427e+02,0.61209e+02,0.67260e+02,0.47724e+02 /)
      kbo(:, 5,43,13) = (/ &
        & 0.24007e+02,0.48779e+02,0.64893e+02,0.70794e+02,0.51019e+02 /)
      kbo(:, 1,44,13) = (/ &
        & 0.10777e+02,0.32982e+02,0.46555e+02,0.52865e+02,0.36017e+02 /)
      kbo(:, 2,44,13) = (/ &
        & 0.13422e+02,0.36774e+02,0.51234e+02,0.57518e+02,0.39647e+02 /)
      kbo(:, 3,44,13) = (/ &
        & 0.16301e+02,0.40529e+02,0.55688e+02,0.61909e+02,0.43184e+02 /)
      kbo(:, 4,44,13) = (/ &
        & 0.19410e+02,0.44205e+02,0.59841e+02,0.65956e+02,0.46575e+02 /)
      kbo(:, 5,44,13) = (/ &
        & 0.22792e+02,0.47657e+02,0.63668e+02,0.69623e+02,0.49898e+02 /)
      kbo(:, 1,45,13) = (/ &
        & 0.99376e+01,0.31658e+02,0.44891e+02,0.51201e+02,0.34758e+02 /)
      kbo(:, 2,45,13) = (/ &
        & 0.12468e+02,0.35468e+02,0.49648e+02,0.55955e+02,0.38412e+02 /)
      kbo(:, 3,45,13) = (/ &
        & 0.15282e+02,0.39240e+02,0.54182e+02,0.60441e+02,0.41991e+02 /)
      kbo(:, 4,45,13) = (/ &
        & 0.18307e+02,0.42958e+02,0.58447e+02,0.64617e+02,0.45427e+02 /)
      kbo(:, 5,45,13) = (/ &
        & 0.21602e+02,0.46508e+02,0.62404e+02,0.68417e+02,0.48775e+02 /)
      kbo(:, 1,46,13) = (/ &
        & 0.90997e+01,0.30250e+02,0.43114e+02,0.49420e+02,0.33417e+02 /)
      kbo(:, 2,46,13) = (/ &
        & 0.11497e+02,0.34076e+02,0.47932e+02,0.54263e+02,0.37087e+02 /)
      kbo(:, 3,46,13) = (/ &
        & 0.14229e+02,0.37865e+02,0.52547e+02,0.58836e+02,0.40705e+02 /)
      kbo(:, 4,46,13) = (/ &
        & 0.17178e+02,0.41613e+02,0.56930e+02,0.63142e+02,0.44193e+02 /)
      kbo(:, 5,46,13) = (/ &
        & 0.20366e+02,0.45251e+02,0.61008e+02,0.67091e+02,0.47569e+02 /)
      kbo(:, 1,47,13) = (/ &
        & 0.82326e+01,0.28698e+02,0.41131e+02,0.47406e+02,0.31895e+02 /)
      kbo(:, 2,47,13) = (/ &
        & 0.10467e+02,0.32516e+02,0.45987e+02,0.52322e+02,0.35605e+02 /)
      kbo(:, 3,47,13) = (/ &
        & 0.13084e+02,0.36324e+02,0.50700e+02,0.57015e+02,0.39250e+02 /)
      kbo(:, 4,47,13) = (/ &
        & 0.15956e+02,0.40097e+02,0.55181e+02,0.61437e+02,0.42802e+02 /)
      kbo(:, 5,47,13) = (/ &
        & 0.19031e+02,0.43799e+02,0.59396e+02,0.65543e+02,0.46212e+02 /)
      kbo(:, 1,48,13) = (/ &
        & 0.74393e+01,0.27161e+02,0.39157e+02,0.45343e+02,0.30350e+02 /)
      kbo(:, 2,48,13) = (/ &
        & 0.95049e+01,0.30953e+02,0.44020e+02,0.50347e+02,0.34113e+02 /)
      kbo(:, 3,48,13) = (/ &
        & 0.11978e+02,0.34782e+02,0.48813e+02,0.55151e+02,0.37782e+02 /)
      kbo(:, 4,48,13) = (/ &
        & 0.14764e+02,0.38570e+02,0.53387e+02,0.59681e+02,0.41384e+02 /)
      kbo(:, 5,48,13) = (/ &
        & 0.17748e+02,0.42312e+02,0.57728e+02,0.63933e+02,0.44844e+02 /)
      kbo(:, 1,49,13) = (/ &
        & 0.67167e+01,0.25650e+02,0.37197e+02,0.43247e+02,0.28796e+02 /)
      kbo(:, 2,49,13) = (/ &
        & 0.86101e+01,0.29402e+02,0.42045e+02,0.48354e+02,0.32610e+02 /)
      kbo(:, 3,49,13) = (/ &
        & 0.10926e+02,0.33234e+02,0.46891e+02,0.53243e+02,0.36305e+02 /)
      kbo(:, 4,49,13) = (/ &
        & 0.13605e+02,0.37035e+02,0.51562e+02,0.57884e+02,0.39936e+02 /)
      kbo(:, 5,49,13) = (/ &
        & 0.16513e+02,0.40804e+02,0.56010e+02,0.62260e+02,0.43466e+02 /)
      kbo(:, 1,50,13) = (/ &
        & 0.60927e+01,0.24264e+02,0.35366e+02,0.41271e+02,0.27331e+02 /)
      kbo(:, 2,50,13) = (/ &
        & 0.78376e+01,0.27958e+02,0.40194e+02,0.46451e+02,0.31176e+02 /)
      kbo(:, 3,50,13) = (/ &
        & 0.99975e+01,0.31777e+02,0.45061e+02,0.51408e+02,0.34914e+02 /)
      kbo(:, 4,50,13) = (/ &
        & 0.12552e+02,0.35595e+02,0.49816e+02,0.56159e+02,0.38569e+02 /)
      kbo(:, 5,50,13) = (/ &
        & 0.15384e+02,0.39379e+02,0.54352e+02,0.60637e+02,0.42153e+02 /)
      kbo(:, 1,51,13) = (/ &
        & 0.55303e+01,0.22951e+02,0.33599e+02,0.39341e+02,0.25901e+02 /)
      kbo(:, 2,51,13) = (/ &
        & 0.71468e+01,0.26574e+02,0.38412e+02,0.44565e+02,0.29771e+02 /)
      kbo(:, 3,51,13) = (/ &
        & 0.91530e+01,0.30360e+02,0.43274e+02,0.49608e+02,0.33559e+02 /)
      kbo(:, 4,51,13) = (/ &
        & 0.11570e+02,0.34196e+02,0.48091e+02,0.54457e+02,0.37233e+02 /)
      kbo(:, 5,51,13) = (/ &
        & 0.14322e+02,0.37996e+02,0.52708e+02,0.59018e+02,0.40851e+02 /)
      kbo(:, 1,52,13) = (/ &
        & 0.50134e+01,0.21673e+02,0.31833e+02,0.37382e+02,0.24463e+02 /)
      kbo(:, 2,52,13) = (/ &
        & 0.65135e+01,0.25216e+02,0.36639e+02,0.42658e+02,0.28359e+02 /)
      kbo(:, 3,52,13) = (/ &
        & 0.83642e+01,0.28959e+02,0.41485e+02,0.47797e+02,0.32187e+02 /)
      kbo(:, 4,52,13) = (/ &
        & 0.10636e+02,0.32789e+02,0.46344e+02,0.52709e+02,0.35895e+02 /)
      kbo(:, 5,52,13) = (/ &
        & 0.13285e+02,0.36604e+02,0.51047e+02,0.57380e+02,0.39540e+02 /)
      kbo(:, 1,53,13) = (/ &
        & 0.45376e+01,0.20438e+02,0.30067e+02,0.35396e+02,0.23001e+02 /)
      kbo(:, 2,53,13) = (/ &
        & 0.59241e+01,0.23884e+02,0.34872e+02,0.40744e+02,0.26941e+02 /)
      kbo(:, 3,53,13) = (/ &
        & 0.76354e+01,0.27568e+02,0.39698e+02,0.45939e+02,0.30794e+02 /)
      kbo(:, 4,53,13) = (/ &
        & 0.97536e+01,0.31378e+02,0.44569e+02,0.50924e+02,0.34545e+02 /)
      kbo(:, 5,53,13) = (/ &
        & 0.12275e+02,0.35210e+02,0.49348e+02,0.55701e+02,0.38212e+02 /)
      kbo(:, 1,54,13) = (/ &
        & 0.41389e+01,0.19353e+02,0.28454e+02,0.33563e+02,0.21647e+02 /)
      kbo(:, 2,54,13) = (/ &
        & 0.54194e+01,0.22692e+02,0.33259e+02,0.38976e+02,0.25632e+02 /)
      kbo(:, 3,54,13) = (/ &
        & 0.70164e+01,0.26307e+02,0.38072e+02,0.44208e+02,0.29508e+02 /)
      kbo(:, 4,54,13) = (/ &
        & 0.89936e+01,0.30086e+02,0.42934e+02,0.49276e+02,0.33306e+02 /)
      kbo(:, 5,54,13) = (/ &
        & 0.11387e+02,0.33931e+02,0.47765e+02,0.54132e+02,0.36987e+02 /)
      kbo(:, 1,55,13) = (/ &
        & 0.37927e+01,0.18358e+02,0.26927e+02,0.31801e+02,0.20350e+02 /)
      kbo(:, 2,55,13) = (/ &
        & 0.49755e+01,0.21582e+02,0.31711e+02,0.37250e+02,0.24368e+02 /)
      kbo(:, 3,55,13) = (/ &
        & 0.64669e+01,0.25119e+02,0.36517e+02,0.42532e+02,0.28268e+02 /)
      kbo(:, 4,55,13) = (/ &
        & 0.83082e+01,0.28857e+02,0.41362e+02,0.47679e+02,0.32095e+02 /)
      kbo(:, 5,55,13) = (/ &
        & 0.10573e+02,0.32695e+02,0.46225e+02,0.52593e+02,0.35810e+02 /)
      kbo(:, 1,56,13) = (/ &
        & 0.34680e+01,0.17374e+02,0.25413e+02,0.30039e+02,0.19069e+02 /)
      kbo(:, 2,56,13) = (/ &
        & 0.45601e+01,0.20503e+02,0.30163e+02,0.35509e+02,0.23088e+02 /)
      kbo(:, 3,56,13) = (/ &
        & 0.59518e+01,0.23956e+02,0.34971e+02,0.40858e+02,0.27027e+02 /)
      kbo(:, 4,56,13) = (/ &
        & 0.76711e+01,0.27642e+02,0.39801e+02,0.46057e+02,0.30878e+02 /)
      kbo(:, 5,56,13) = (/ &
        & 0.98017e+01,0.31462e+02,0.44674e+02,0.51031e+02,0.34630e+02 /)
      kbo(:, 1,57,13) = (/ &
        & 0.31571e+01,0.16389e+02,0.23903e+02,0.28270e+02,0.17802e+02 /)
      kbo(:, 2,57,13) = (/ &
        & 0.41775e+01,0.19466e+02,0.28628e+02,0.33765e+02,0.21796e+02 /)
      kbo(:, 3,57,13) = (/ &
        & 0.54676e+01,0.22817e+02,0.33433e+02,0.39170e+02,0.25777e+02 /)
      kbo(:, 4,57,13) = (/ &
        & 0.70767e+01,0.26436e+02,0.38248e+02,0.44404e+02,0.29650e+02 /)
      kbo(:, 5,57,13) = (/ &
        & 0.90728e+01,0.30224e+02,0.43110e+02,0.49455e+02,0.33445e+02 /)
      kbo(:, 1,58,13) = (/ &
        & 0.28749e+01,0.15464e+02,0.22485e+02,0.26596e+02,0.16612e+02 /)
      kbo(:, 2,58,13) = (/ &
        & 0.38438e+01,0.18517e+02,0.27179e+02,0.32099e+02,0.20568e+02 /)
      kbo(:, 3,58,13) = (/ &
        & 0.50410e+01,0.21758e+02,0.31967e+02,0.37546e+02,0.24584e+02 /)
      kbo(:, 4,58,13) = (/ &
        & 0.65535e+01,0.25311e+02,0.36779e+02,0.42823e+02,0.28478e+02 /)
      kbo(:, 5,58,13) = (/ &
        & 0.84187e+01,0.29065e+02,0.41628e+02,0.47951e+02,0.32304e+02 /)
      kbo(:, 1,59,13) = (/ &
        & 0.27657e+01,0.15098e+02,0.21927e+02,0.25930e+02,0.16137e+02 /)
      kbo(:, 2,59,13) = (/ &
        & 0.37163e+01,0.18141e+02,0.26603e+02,0.31433e+02,0.20078e+02 /)
      kbo(:, 3,59,13) = (/ &
        & 0.48770e+01,0.21342e+02,0.31379e+02,0.36884e+02,0.24100e+02 /)
      kbo(:, 4,59,13) = (/ &
        & 0.63518e+01,0.24865e+02,0.36188e+02,0.42182e+02,0.28007e+02 /)
      kbo(:, 5,59,13) = (/ &
        & 0.81684e+01,0.28600e+02,0.41035e+02,0.47343e+02,0.31847e+02 /)
      kbo(:, 1,13,14) = (/ &
        & 0.20563e+03,0.16395e+03,0.15131e+03,0.13928e+03,0.17336e+03 /)
      kbo(:, 2,13,14) = (/ &
        & 0.20583e+03,0.16346e+03,0.15102e+03,0.13867e+03,0.17209e+03 /)
      kbo(:, 3,13,14) = (/ &
        & 0.20579e+03,0.16282e+03,0.15051e+03,0.13803e+03,0.17119e+03 /)
      kbo(:, 4,13,14) = (/ &
        & 0.20538e+03,0.16198e+03,0.15005e+03,0.13746e+03,0.17062e+03 /)
      kbo(:, 5,13,14) = (/ &
        & 0.20471e+03,0.16100e+03,0.14942e+03,0.13685e+03,0.16998e+03 /)
      kbo(:, 1,14,14) = (/ &
        & 0.21387e+03,0.17486e+03,0.16410e+03,0.14896e+03,0.17926e+03 /)
      kbo(:, 2,14,14) = (/ &
        & 0.21398e+03,0.17407e+03,0.16354e+03,0.14849e+03,0.17872e+03 /)
      kbo(:, 3,14,14) = (/ &
        & 0.21371e+03,0.17306e+03,0.16300e+03,0.14796e+03,0.17838e+03 /)
      kbo(:, 4,14,14) = (/ &
        & 0.21320e+03,0.17193e+03,0.16238e+03,0.14748e+03,0.17807e+03 /)
      kbo(:, 5,14,14) = (/ &
        & 0.21239e+03,0.17062e+03,0.16158e+03,0.14661e+03,0.17726e+03 /)
      kbo(:, 1,15,14) = (/ &
        & 0.21868e+03,0.18392e+03,0.17597e+03,0.15877e+03,0.18409e+03 /)
      kbo(:, 2,15,14) = (/ &
        & 0.21861e+03,0.18285e+03,0.17533e+03,0.15845e+03,0.18413e+03 /)
      kbo(:, 3,15,14) = (/ &
        & 0.21838e+03,0.18168e+03,0.17469e+03,0.15814e+03,0.18423e+03 /)
      kbo(:, 4,15,14) = (/ &
        & 0.21785e+03,0.18028e+03,0.17392e+03,0.15747e+03,0.18391e+03 /)
      kbo(:, 5,15,14) = (/ &
        & 0.21714e+03,0.17881e+03,0.17281e+03,0.15644e+03,0.18337e+03 /)
      kbo(:, 1,16,14) = (/ &
        & 0.21989e+03,0.19090e+03,0.18666e+03,0.16823e+03,0.18717e+03 /)
      kbo(:, 2,16,14) = (/ &
        & 0.22000e+03,0.18989e+03,0.18604e+03,0.16822e+03,0.18797e+03 /)
      kbo(:, 3,16,14) = (/ &
        & 0.21982e+03,0.18856e+03,0.18533e+03,0.16794e+03,0.18851e+03 /)
      kbo(:, 4,16,14) = (/ &
        & 0.21954e+03,0.18709e+03,0.18432e+03,0.16715e+03,0.18854e+03 /)
      kbo(:, 5,16,14) = (/ &
        & 0.21898e+03,0.18542e+03,0.18303e+03,0.16600e+03,0.18839e+03 /)
      kbo(:, 1,17,14) = (/ &
        & 0.21793e+03,0.19596e+03,0.19603e+03,0.17703e+03,0.18857e+03 /)
      kbo(:, 2,17,14) = (/ &
        & 0.21821e+03,0.19492e+03,0.19548e+03,0.17725e+03,0.19023e+03 /)
      kbo(:, 3,17,14) = (/ &
        & 0.21850e+03,0.19369e+03,0.19462e+03,0.17701e+03,0.19133e+03 /)
      kbo(:, 4,17,14) = (/ &
        & 0.21855e+03,0.19221e+03,0.19343e+03,0.17616e+03,0.19194e+03 /)
      kbo(:, 5,17,14) = (/ &
        & 0.21839e+03,0.19057e+03,0.19206e+03,0.17490e+03,0.19225e+03 /)
      kbo(:, 1,18,14) = (/ &
        & 0.21311e+03,0.19935e+03,0.20385e+03,0.18492e+03,0.18864e+03 /)
      kbo(:, 2,18,14) = (/ &
        & 0.21399e+03,0.19838e+03,0.20339e+03,0.18536e+03,0.19117e+03 /)
      kbo(:, 3,18,14) = (/ &
        & 0.21477e+03,0.19727e+03,0.20251e+03,0.18517e+03,0.19296e+03 /)
      kbo(:, 4,18,14) = (/ &
        & 0.21537e+03,0.19602e+03,0.20131e+03,0.18433e+03,0.19426e+03 /)
      kbo(:, 5,18,14) = (/ &
        & 0.21594e+03,0.19460e+03,0.19989e+03,0.18299e+03,0.19511e+03 /)
      kbo(:, 1,19,14) = (/ &
        & 0.20628e+03,0.20131e+03,0.21018e+03,0.19181e+03,0.18780e+03 /)
      kbo(:, 2,19,14) = (/ &
        & 0.20786e+03,0.20061e+03,0.20985e+03,0.19249e+03,0.19117e+03 /)
      kbo(:, 3,19,14) = (/ &
        & 0.20939e+03,0.19978e+03,0.20915e+03,0.19245e+03,0.19379e+03 /)
      kbo(:, 4,19,14) = (/ &
        & 0.21078e+03,0.19876e+03,0.20808e+03,0.19159e+03,0.19578e+03 /)
      kbo(:, 5,19,14) = (/ &
        & 0.21196e+03,0.19762e+03,0.20666e+03,0.19020e+03,0.19726e+03 /)
      kbo(:, 1,20,14) = (/ &
        & 0.19806e+03,0.20215e+03,0.21525e+03,0.19781e+03,0.18646e+03 /)
      kbo(:, 2,20,14) = (/ &
        & 0.20054e+03,0.20180e+03,0.21527e+03,0.19874e+03,0.19072e+03 /)
      kbo(:, 3,20,14) = (/ &
        & 0.20298e+03,0.20132e+03,0.21478e+03,0.19877e+03,0.19413e+03 /)
      kbo(:, 4,20,14) = (/ &
        & 0.20522e+03,0.20070e+03,0.21384e+03,0.19793e+03,0.19681e+03 /)
      kbo(:, 5,20,14) = (/ &
        & 0.20725e+03,0.19975e+03,0.21249e+03,0.19659e+03,0.19899e+03 /)
      kbo(:, 1,21,14) = (/ &
        & 0.18919e+03,0.20217e+03,0.21942e+03,0.20291e+03,0.18499e+03 /)
      kbo(:, 2,21,14) = (/ &
        & 0.19268e+03,0.20239e+03,0.21974e+03,0.20415e+03,0.19012e+03 /)
      kbo(:, 3,21,14) = (/ &
        & 0.19609e+03,0.20231e+03,0.21947e+03,0.20425e+03,0.19432e+03 /)
      kbo(:, 4,21,14) = (/ &
        & 0.19926e+03,0.20201e+03,0.21866e+03,0.20346e+03,0.19770e+03 /)
      kbo(:, 5,21,14) = (/ &
        & 0.20224e+03,0.20136e+03,0.21742e+03,0.20212e+03,0.20044e+03 /)
      kbo(:, 1,22,14) = (/ &
        & 0.18064e+03,0.20182e+03,0.22276e+03,0.20740e+03,0.18409e+03 /)
      kbo(:, 2,22,14) = (/ &
        & 0.18513e+03,0.20253e+03,0.22341e+03,0.20876e+03,0.18988e+03 /)
      kbo(:, 3,22,14) = (/ &
        & 0.18951e+03,0.20287e+03,0.22329e+03,0.20890e+03,0.19474e+03 /)
      kbo(:, 4,22,14) = (/ &
        & 0.19368e+03,0.20283e+03,0.22259e+03,0.20812e+03,0.19869e+03 /)
      kbo(:, 5,22,14) = (/ &
        & 0.19752e+03,0.20248e+03,0.22143e+03,0.20676e+03,0.20185e+03 /)
      kbo(:, 1,23,14) = (/ &
        & 0.17261e+03,0.20129e+03,0.22560e+03,0.21126e+03,0.18360e+03 /)
      kbo(:, 2,23,14) = (/ &
        & 0.17813e+03,0.20255e+03,0.22645e+03,0.21277e+03,0.18993e+03 /)
      kbo(:, 3,23,14) = (/ &
        & 0.18347e+03,0.20322e+03,0.22649e+03,0.21288e+03,0.19534e+03 /)
      kbo(:, 4,23,14) = (/ &
        & 0.18858e+03,0.20345e+03,0.22593e+03,0.21211e+03,0.19972e+03 /)
      kbo(:, 5,23,14) = (/ &
        & 0.19325e+03,0.20330e+03,0.22470e+03,0.21066e+03,0.20314e+03 /)
      kbo(:, 1,24,14) = (/ &
        & 0.16550e+03,0.20079e+03,0.22797e+03,0.21459e+03,0.18352e+03 /)
      kbo(:, 2,24,14) = (/ &
        & 0.17199e+03,0.20247e+03,0.22899e+03,0.21614e+03,0.19031e+03 /)
      kbo(:, 3,24,14) = (/ &
        & 0.17829e+03,0.20349e+03,0.22920e+03,0.21621e+03,0.19610e+03 /)
      kbo(:, 4,24,14) = (/ &
        & 0.18424e+03,0.20395e+03,0.22865e+03,0.21544e+03,0.20080e+03 /)
      kbo(:, 5,24,14) = (/ &
        & 0.18966e+03,0.20393e+03,0.22735e+03,0.21388e+03,0.20437e+03 /)
      kbo(:, 1,25,14) = (/ &
        & 0.15949e+03,0.20048e+03,0.22999e+03,0.21758e+03,0.18395e+03 /)
      kbo(:, 2,25,14) = (/ &
        & 0.16698e+03,0.20247e+03,0.23119e+03,0.21903e+03,0.19108e+03 /)
      kbo(:, 3,25,14) = (/ &
        & 0.17411e+03,0.20370e+03,0.23144e+03,0.21904e+03,0.19711e+03 /)
      kbo(:, 4,25,14) = (/ &
        & 0.18088e+03,0.20435e+03,0.23082e+03,0.21817e+03,0.20192e+03 /)
      kbo(:, 5,25,14) = (/ &
        & 0.18710e+03,0.20450e+03,0.22950e+03,0.21648e+03,0.20559e+03 /)
      kbo(:, 1,26,14) = (/ &
        & 0.15479e+03,0.20038e+03,0.23181e+03,0.22016e+03,0.18490e+03 /)
      kbo(:, 2,26,14) = (/ &
        & 0.16322e+03,0.20258e+03,0.23307e+03,0.22145e+03,0.19222e+03 /)
      kbo(:, 3,26,14) = (/ &
        & 0.17119e+03,0.20401e+03,0.23326e+03,0.22140e+03,0.19831e+03 /)
      kbo(:, 4,26,14) = (/ &
        & 0.17866e+03,0.20478e+03,0.23259e+03,0.22038e+03,0.20315e+03 /)
      kbo(:, 5,26,14) = (/ &
        & 0.18553e+03,0.20498e+03,0.23122e+03,0.21854e+03,0.20685e+03 /)
      kbo(:, 1,27,14) = (/ &
        & 0.15143e+03,0.20049e+03,0.23344e+03,0.22241e+03,0.18615e+03 /)
      kbo(:, 2,27,14) = (/ &
        & 0.16070e+03,0.20279e+03,0.23465e+03,0.22352e+03,0.19353e+03 /)
      kbo(:, 3,27,14) = (/ &
        & 0.16932e+03,0.20430e+03,0.23473e+03,0.22331e+03,0.19960e+03 /)
      kbo(:, 4,27,14) = (/ &
        & 0.17737e+03,0.20518e+03,0.23402e+03,0.22212e+03,0.20440e+03 /)
      kbo(:, 5,27,14) = (/ &
        & 0.18472e+03,0.20537e+03,0.23257e+03,0.22015e+03,0.20807e+03 /)
      kbo(:, 1,28,14) = (/ &
        & 0.14935e+03,0.20078e+03,0.23487e+03,0.22436e+03,0.18762e+03 /)
      kbo(:, 2,28,14) = (/ &
        & 0.15926e+03,0.20312e+03,0.23597e+03,0.22523e+03,0.19491e+03 /)
      kbo(:, 3,28,14) = (/ &
        & 0.16839e+03,0.20467e+03,0.23597e+03,0.22484e+03,0.20092e+03 /)
      kbo(:, 4,28,14) = (/ &
        & 0.17687e+03,0.20554e+03,0.23516e+03,0.22345e+03,0.20562e+03 /)
      kbo(:, 5,28,14) = (/ &
        & 0.18453e+03,0.20570e+03,0.23357e+03,0.22135e+03,0.20921e+03 /)
      kbo(:, 1,29,14) = (/ &
        & 0.14844e+03,0.20117e+03,0.23614e+03,0.22601e+03,0.18927e+03 /)
      kbo(:, 2,29,14) = (/ &
        & 0.15878e+03,0.20350e+03,0.23707e+03,0.22664e+03,0.19642e+03 /)
      kbo(:, 3,29,14) = (/ &
        & 0.16829e+03,0.20505e+03,0.23696e+03,0.22601e+03,0.20229e+03 /)
      kbo(:, 4,29,14) = (/ &
        & 0.17702e+03,0.20585e+03,0.23602e+03,0.22445e+03,0.20685e+03 /)
      kbo(:, 5,29,14) = (/ &
        & 0.18487e+03,0.20599e+03,0.23430e+03,0.22220e+03,0.21031e+03 /)
      kbo(:, 1,30,14) = (/ &
        & 0.14841e+03,0.20165e+03,0.23724e+03,0.22742e+03,0.19101e+03 /)
      kbo(:, 2,30,14) = (/ &
        & 0.15903e+03,0.20395e+03,0.23798e+03,0.22774e+03,0.19796e+03 /)
      kbo(:, 3,30,14) = (/ &
        & 0.16878e+03,0.20543e+03,0.23774e+03,0.22689e+03,0.20367e+03 /)
      kbo(:, 4,30,14) = (/ &
        & 0.17765e+03,0.20614e+03,0.23662e+03,0.22515e+03,0.20804e+03 /)
      kbo(:, 5,30,14) = (/ &
        & 0.18556e+03,0.20626e+03,0.23478e+03,0.22274e+03,0.21133e+03 /)
      kbo(:, 1,31,14) = (/ &
        & 0.14910e+03,0.20219e+03,0.23816e+03,0.22857e+03,0.19280e+03 /)
      kbo(:, 2,31,14) = (/ &
        & 0.15987e+03,0.20442e+03,0.23873e+03,0.22860e+03,0.19955e+03 /)
      kbo(:, 3,31,14) = (/ &
        & 0.16974e+03,0.20578e+03,0.23830e+03,0.22751e+03,0.20503e+03 /)
      kbo(:, 4,31,14) = (/ &
        & 0.17870e+03,0.20640e+03,0.23703e+03,0.22559e+03,0.20917e+03 /)
      kbo(:, 5,31,14) = (/ &
        & 0.18656e+03,0.20647e+03,0.23504e+03,0.22303e+03,0.21232e+03 /)
      kbo(:, 1,32,14) = (/ &
        & 0.15031e+03,0.20279e+03,0.23897e+03,0.22949e+03,0.19459e+03 /)
      kbo(:, 2,32,14) = (/ &
        & 0.16119e+03,0.20489e+03,0.23931e+03,0.22922e+03,0.20113e+03 /)
      kbo(:, 3,32,14) = (/ &
        & 0.17110e+03,0.20610e+03,0.23869e+03,0.22791e+03,0.20634e+03 /)
      kbo(:, 4,32,14) = (/ &
        & 0.18002e+03,0.20662e+03,0.23723e+03,0.22582e+03,0.21029e+03 /)
      kbo(:, 5,32,14) = (/ &
        & 0.18777e+03,0.20659e+03,0.23510e+03,0.22308e+03,0.21322e+03 /)
      kbo(:, 1,33,14) = (/ &
        & 0.15197e+03,0.20341e+03,0.23965e+03,0.23019e+03,0.19639e+03 /)
      kbo(:, 2,33,14) = (/ &
        & 0.16285e+03,0.20534e+03,0.23976e+03,0.22964e+03,0.20267e+03 /)
      kbo(:, 3,33,14) = (/ &
        & 0.17270e+03,0.20638e+03,0.23893e+03,0.22811e+03,0.20758e+03 /)
      kbo(:, 4,33,14) = (/ &
        & 0.18151e+03,0.20680e+03,0.23727e+03,0.22584e+03,0.21132e+03 /)
      kbo(:, 5,33,14) = (/ &
        & 0.18912e+03,0.20665e+03,0.23500e+03,0.22296e+03,0.21406e+03 /)
      kbo(:, 1,34,14) = (/ &
        & 0.15352e+03,0.20391e+03,0.24014e+03,0.23069e+03,0.19790e+03 /)
      kbo(:, 2,34,14) = (/ &
        & 0.16437e+03,0.20566e+03,0.24006e+03,0.22992e+03,0.20396e+03 /)
      kbo(:, 3,34,14) = (/ &
        & 0.17416e+03,0.20662e+03,0.23907e+03,0.22823e+03,0.20863e+03 /)
      kbo(:, 4,34,14) = (/ &
        & 0.18285e+03,0.20695e+03,0.23728e+03,0.22580e+03,0.21218e+03 /)
      kbo(:, 5,34,14) = (/ &
        & 0.19033e+03,0.20667e+03,0.23487e+03,0.22280e+03,0.21474e+03 /)
      kbo(:, 1,35,14) = (/ &
        & 0.15421e+03,0.20418e+03,0.24052e+03,0.23110e+03,0.19876e+03 /)
      kbo(:, 2,35,14) = (/ &
        & 0.16507e+03,0.20586e+03,0.24033e+03,0.23020e+03,0.20468e+03 /)
      kbo(:, 3,35,14) = (/ &
        & 0.17486e+03,0.20677e+03,0.23924e+03,0.22841e+03,0.20923e+03 /)
      kbo(:, 4,35,14) = (/ &
        & 0.18350e+03,0.20705e+03,0.23737e+03,0.22589e+03,0.21269e+03 /)
      kbo(:, 5,35,14) = (/ &
        & 0.19094e+03,0.20669e+03,0.23489e+03,0.22281e+03,0.21514e+03 /)
      kbo(:, 1,36,14) = (/ &
        & 0.15381e+03,0.20424e+03,0.24080e+03,0.23145e+03,0.19888e+03 /)
      kbo(:, 2,36,14) = (/ &
        & 0.16478e+03,0.20592e+03,0.24060e+03,0.23055e+03,0.20484e+03 /)
      kbo(:, 3,36,14) = (/ &
        & 0.17464e+03,0.20684e+03,0.23950e+03,0.22874e+03,0.20938e+03 /)
      kbo(:, 4,36,14) = (/ &
        & 0.18336e+03,0.20715e+03,0.23762e+03,0.22618e+03,0.21284e+03 /)
      kbo(:, 5,36,14) = (/ &
        & 0.19086e+03,0.20678e+03,0.23514e+03,0.22311e+03,0.21532e+03 /)
      kbo(:, 1,37,14) = (/ &
        & 0.15177e+03,0.20394e+03,0.24096e+03,0.23178e+03,0.19802e+03 /)
      kbo(:, 2,37,14) = (/ &
        & 0.16298e+03,0.20578e+03,0.24091e+03,0.23102e+03,0.20416e+03 /)
      kbo(:, 3,37,14) = (/ &
        & 0.17307e+03,0.20681e+03,0.23994e+03,0.22934e+03,0.20893e+03 /)
      kbo(:, 4,37,14) = (/ &
        & 0.18204e+03,0.20721e+03,0.23818e+03,0.22688e+03,0.21255e+03 /)
      kbo(:, 5,37,14) = (/ &
        & 0.18973e+03,0.20695e+03,0.23573e+03,0.22383e+03,0.21516e+03 /)
      kbo(:, 1,38,14) = (/ &
        & 0.14968e+03,0.20359e+03,0.24104e+03,0.23202e+03,0.19703e+03 /)
      kbo(:, 2,38,14) = (/ &
        & 0.16113e+03,0.20560e+03,0.24116e+03,0.23143e+03,0.20341e+03 /)
      kbo(:, 3,38,14) = (/ &
        & 0.17144e+03,0.20674e+03,0.24033e+03,0.22988e+03,0.20838e+03 /)
      kbo(:, 4,38,14) = (/ &
        & 0.18063e+03,0.20724e+03,0.23866e+03,0.22752e+03,0.21216e+03 /)
      kbo(:, 5,38,14) = (/ &
        & 0.18855e+03,0.20710e+03,0.23632e+03,0.22453e+03,0.21493e+03 /)
      kbo(:, 1,39,14) = (/ &
        & 0.14764e+03,0.20322e+03,0.24106e+03,0.23220e+03,0.19604e+03 /)
      kbo(:, 2,39,14) = (/ &
        & 0.15932e+03,0.20540e+03,0.24137e+03,0.23180e+03,0.20262e+03 /)
      kbo(:, 3,39,14) = (/ &
        & 0.16984e+03,0.20665e+03,0.24065e+03,0.23036e+03,0.20781e+03 /)
      kbo(:, 4,39,14) = (/ &
        & 0.17923e+03,0.20725e+03,0.23910e+03,0.22810e+03,0.21175e+03 /)
      kbo(:, 5,39,14) = (/ &
        & 0.18737e+03,0.20722e+03,0.23684e+03,0.22517e+03,0.21467e+03 /)
      kbo(:, 1,40,14) = (/ &
        & 0.14438e+03,0.20254e+03,0.24092e+03,0.23225e+03,0.19425e+03 /)
      kbo(:, 2,40,14) = (/ &
        & 0.15633e+03,0.20498e+03,0.24152e+03,0.23217e+03,0.20115e+03 /)
      kbo(:, 3,40,14) = (/ &
        & 0.16718e+03,0.20642e+03,0.24105e+03,0.23096e+03,0.20672e+03 /)
      kbo(:, 4,40,14) = (/ &
        & 0.17690e+03,0.20720e+03,0.23969e+03,0.22887e+03,0.21093e+03 /)
      kbo(:, 5,40,14) = (/ &
        & 0.18539e+03,0.20733e+03,0.23758e+03,0.22609e+03,0.21411e+03 /)
      kbo(:, 1,41,14) = (/ &
        & 0.14093e+03,0.20170e+03,0.24062e+03,0.23214e+03,0.19226e+03 /)
      kbo(:, 2,41,14) = (/ &
        & 0.15309e+03,0.20441e+03,0.24155e+03,0.23243e+03,0.19951e+03 /)
      kbo(:, 3,41,14) = (/ &
        & 0.16434e+03,0.20613e+03,0.24136e+03,0.23149e+03,0.20545e+03 /)
      kbo(:, 4,41,14) = (/ &
        & 0.17439e+03,0.20709e+03,0.24022e+03,0.22963e+03,0.21000e+03 /)
      kbo(:, 5,41,14) = (/ &
        & 0.18325e+03,0.20739e+03,0.23829e+03,0.22700e+03,0.21344e+03 /)
      kbo(:, 1,42,14) = (/ &
        & 0.13742e+03,0.20072e+03,0.24018e+03,0.23188e+03,0.19017e+03 /)
      kbo(:, 2,42,14) = (/ &
        & 0.14987e+03,0.20381e+03,0.24151e+03,0.23260e+03,0.19778e+03 /)
      kbo(:, 3,42,14) = (/ &
        & 0.16144e+03,0.20580e+03,0.24159e+03,0.23194e+03,0.20408e+03 /)
      kbo(:, 4,42,14) = (/ &
        & 0.17182e+03,0.20693e+03,0.24068e+03,0.23030e+03,0.20897e+03 /)
      kbo(:, 5,42,14) = (/ &
        & 0.18101e+03,0.20739e+03,0.23894e+03,0.22785e+03,0.21269e+03 /)
      kbo(:, 1,43,14) = (/ &
        & 0.13316e+03,0.19946e+03,0.23952e+03,0.23134e+03,0.18746e+03 /)
      kbo(:, 2,43,14) = (/ &
        & 0.14590e+03,0.20299e+03,0.24131e+03,0.23265e+03,0.19555e+03 /)
      kbo(:, 3,43,14) = (/ &
        & 0.15782e+03,0.20531e+03,0.24176e+03,0.23237e+03,0.20228e+03 /)
      kbo(:, 4,43,14) = (/ &
        & 0.16860e+03,0.20666e+03,0.24113e+03,0.23099e+03,0.20761e+03 /)
      kbo(:, 5,43,14) = (/ &
        & 0.17818e+03,0.20733e+03,0.23964e+03,0.22878e+03,0.21166e+03 /)
      kbo(:, 1,44,14) = (/ &
        & 0.12851e+03,0.19793e+03,0.23860e+03,0.23051e+03,0.18440e+03 /)
      kbo(:, 2,44,14) = (/ &
        & 0.14156e+03,0.20195e+03,0.24092e+03,0.23249e+03,0.19298e+03 /)
      kbo(:, 3,44,14) = (/ &
        & 0.15381e+03,0.20468e+03,0.24182e+03,0.23268e+03,0.20015e+03 /)
      kbo(:, 4,44,14) = (/ &
        & 0.16494e+03,0.20625e+03,0.24148e+03,0.23163e+03,0.20597e+03 /)
      kbo(:, 5,44,14) = (/ &
        & 0.17499e+03,0.20719e+03,0.24029e+03,0.22969e+03,0.21043e+03 /)
      kbo(:, 1,45,14) = (/ &
        & 0.12377e+03,0.19622e+03,0.23745e+03,0.22938e+03,0.18114e+03 /)
      kbo(:, 2,45,14) = (/ &
        & 0.13713e+03,0.20074e+03,0.24035e+03,0.23210e+03,0.19024e+03 /)
      kbo(:, 3,45,14) = (/ &
        & 0.14969e+03,0.20389e+03,0.24171e+03,0.23283e+03,0.19787e+03 /)
      kbo(:, 4,45,14) = (/ &
        & 0.16122e+03,0.20580e+03,0.24172e+03,0.23215e+03,0.20417e+03 /)
      kbo(:, 5,45,14) = (/ &
        & 0.17169e+03,0.20697e+03,0.24085e+03,0.23051e+03,0.20907e+03 /)
      kbo(:, 1,46,14) = (/ &
        & 0.11871e+03,0.19418e+03,0.23600e+03,0.22790e+03,0.17747e+03 /)
      kbo(:, 2,46,14) = (/ &
        & 0.13231e+03,0.19929e+03,0.23954e+03,0.23143e+03,0.18712e+03 /)
      kbo(:, 3,46,14) = (/ &
        & 0.14514e+03,0.20288e+03,0.24138e+03,0.23280e+03,0.19526e+03 /)
      kbo(:, 4,46,14) = (/ &
        & 0.15711e+03,0.20523e+03,0.24187e+03,0.23257e+03,0.20207e+03 /)
      kbo(:, 5,46,14) = (/ &
        & 0.16802e+03,0.20664e+03,0.24132e+03,0.23126e+03,0.20749e+03 /)
      kbo(:, 1,47,14) = (/ &
        & 0.11295e+03,0.19159e+03,0.23398e+03,0.22588e+03,0.17313e+03 /)
      kbo(:, 2,47,14) = (/ &
        & 0.12683e+03,0.19741e+03,0.23835e+03,0.23031e+03,0.18342e+03 /)
      kbo(:, 3,47,14) = (/ &
        & 0.13999e+03,0.20159e+03,0.24085e+03,0.23253e+03,0.19217e+03 /)
      kbo(:, 4,47,14) = (/ &
        & 0.15234e+03,0.20442e+03,0.24186e+03,0.23286e+03,0.19949e+03 /)
      kbo(:, 5,47,14) = (/ &
        & 0.16373e+03,0.20618e+03,0.24169e+03,0.23194e+03,0.20549e+03 /)
      kbo(:, 1,48,14) = (/ &
        & 0.10712e+03,0.18871e+03,0.23159e+03,0.22347e+03,0.16850e+03 /)
      kbo(:, 2,48,14) = (/ &
        & 0.12124e+03,0.19529e+03,0.23687e+03,0.22882e+03,0.17946e+03 /)
      kbo(:, 3,48,14) = (/ &
        & 0.13473e+03,0.20007e+03,0.24005e+03,0.23191e+03,0.18883e+03 /)
      kbo(:, 4,48,14) = (/ &
        & 0.14742e+03,0.20342e+03,0.24164e+03,0.23294e+03,0.19670e+03 /)
      kbo(:, 5,48,14) = (/ &
        & 0.15928e+03,0.20562e+03,0.24192e+03,0.23247e+03,0.20325e+03 /)
      kbo(:, 1,49,14) = (/ &
        & 0.10120e+03,0.18550e+03,0.22880e+03,0.22071e+03,0.16363e+03 /)
      kbo(:, 2,49,14) = (/ &
        & 0.11556e+03,0.19285e+03,0.23504e+03,0.22697e+03,0.17524e+03 /)
      kbo(:, 3,49,14) = (/ &
        & 0.12932e+03,0.19832e+03,0.23901e+03,0.23097e+03,0.18524e+03 /)
      kbo(:, 4,49,14) = (/ &
        & 0.14238e+03,0.20226e+03,0.24120e+03,0.23278e+03,0.19370e+03 /)
      kbo(:, 5,49,14) = (/ &
        & 0.15460e+03,0.20488e+03,0.24199e+03,0.23283e+03,0.20078e+03 /)
      kbo(:, 1,50,14) = (/ &
        & 0.95603e+02,0.18216e+03,0.22576e+03,0.21768e+03,0.15878e+03 /)
      kbo(:, 2,50,14) = (/ &
        & 0.11015e+03,0.19031e+03,0.23298e+03,0.22490e+03,0.17105e+03 /)
      kbo(:, 3,50,14) = (/ &
        & 0.12415e+03,0.19646e+03,0.23775e+03,0.22975e+03,0.18166e+03 /)
      kbo(:, 4,50,14) = (/ &
        & 0.13752e+03,0.20094e+03,0.24058e+03,0.23236e+03,0.19069e+03 /)
      kbo(:, 5,50,14) = (/ &
        & 0.15007e+03,0.20403e+03,0.24187e+03,0.23299e+03,0.19826e+03 /)
      kbo(:, 1,51,14) = (/ &
        & 0.90137e+02,0.17868e+03,0.22240e+03,0.21442e+03,0.15384e+03 /)
      kbo(:, 2,51,14) = (/ &
        & 0.10484e+03,0.18757e+03,0.23066e+03,0.22258e+03,0.16677e+03 /)
      kbo(:, 3,51,14) = (/ &
        & 0.11907e+03,0.19442e+03,0.23628e+03,0.22824e+03,0.17796e+03 /)
      kbo(:, 4,51,14) = (/ &
        & 0.13269e+03,0.19948e+03,0.23976e+03,0.23167e+03,0.18756e+03 /)
      kbo(:, 5,51,14) = (/ &
        & 0.14552e+03,0.20302e+03,0.24154e+03,0.23296e+03,0.19565e+03 /)
      kbo(:, 1,52,14) = (/ &
        & 0.84690e+02,0.17496e+03,0.21864e+03,0.21080e+03,0.14862e+03 /)
      kbo(:, 2,52,14) = (/ &
        & 0.99471e+02,0.18453e+03,0.22798e+03,0.21992e+03,0.16225e+03 /)
      kbo(:, 3,52,14) = (/ &
        & 0.11391e+03,0.19213e+03,0.23451e+03,0.22644e+03,0.17406e+03 /)
      kbo(:, 4,52,14) = (/ &
        & 0.12777e+03,0.19781e+03,0.23872e+03,0.23070e+03,0.18424e+03 /)
      kbo(:, 5,52,14) = (/ &
        & 0.14091e+03,0.20189e+03,0.24107e+03,0.23273e+03,0.19286e+03 /)
      kbo(:, 1,53,14) = (/ &
        & 0.79262e+02,0.17095e+03,0.21436e+03,0.20681e+03,0.14317e+03 /)
      kbo(:, 2,53,14) = (/ &
        & 0.94047e+02,0.18126e+03,0.22494e+03,0.21690e+03,0.15748e+03 /)
      kbo(:, 3,53,14) = (/ &
        & 0.10865e+03,0.18958e+03,0.23241e+03,0.22434e+03,0.16994e+03 /)
      kbo(:, 4,53,14) = (/ &
        & 0.12274e+03,0.19595e+03,0.23742e+03,0.22941e+03,0.18070e+03 /)
      kbo(:, 5,53,14) = (/ &
        & 0.13618e+03,0.20056e+03,0.24040e+03,0.23224e+03,0.18988e+03 /)
      kbo(:, 1,54,14) = (/ &
        & 0.74312e+02,0.16701e+03,0.21000e+03,0.20283e+03,0.13801e+03 /)
      kbo(:, 2,54,14) = (/ &
        & 0.89059e+02,0.17802e+03,0.22177e+03,0.21381e+03,0.15289e+03 /)
      kbo(:, 3,54,14) = (/ &
        & 0.10379e+03,0.18701e+03,0.23021e+03,0.22214e+03,0.16595e+03 /)
      kbo(:, 4,54,14) = (/ &
        & 0.11808e+03,0.19403e+03,0.23602e+03,0.22797e+03,0.17728e+03 /)
      kbo(:, 5,54,14) = (/ &
        & 0.13174e+03,0.19918e+03,0.23961e+03,0.23155e+03,0.18697e+03 /)
      kbo(:, 1,55,14) = (/ &
        & 0.69615e+02,0.16296e+03,0.20540e+03,0.19866e+03,0.13288e+03 /)
      kbo(:, 2,55,14) = (/ &
        & 0.84276e+02,0.17466e+03,0.21835e+03,0.21056e+03,0.14828e+03 /)
      kbo(:, 3,55,14) = (/ &
        & 0.99066e+02,0.18433e+03,0.22782e+03,0.21977e+03,0.16197e+03 /)
      kbo(:, 4,55,14) = (/ &
        & 0.11354e+03,0.19199e+03,0.23442e+03,0.22636e+03,0.17383e+03 /)
      kbo(:, 5,55,14) = (/ &
        & 0.12741e+03,0.19770e+03,0.23866e+03,0.23065e+03,0.18403e+03 /)
      kbo(:, 1,56,14) = (/ &
        & 0.64944e+02,0.15877e+03,0.20044e+03,0.19421e+03,0.12762e+03 /)
      kbo(:, 2,56,14) = (/ &
        & 0.79524e+02,0.17114e+03,0.21461e+03,0.20707e+03,0.14351e+03 /)
      kbo(:, 3,56,14) = (/ &
        & 0.94323e+02,0.18144e+03,0.22514e+03,0.21711e+03,0.15778e+03 /)
      kbo(:, 4,56,14) = (/ &
        & 0.10894e+03,0.18976e+03,0.23257e+03,0.22452e+03,0.17022e+03 /)
      kbo(:, 5,56,14) = (/ &
        & 0.12301e+03,0.19605e+03,0.23752e+03,0.22954e+03,0.18094e+03 /)
      kbo(:, 1,57,14) = (/ &
        & 0.60353e+02,0.15431e+03,0.19514e+03,0.18945e+03,0.12225e+03 /)
      kbo(:, 2,57,14) = (/ &
        & 0.74815e+02,0.16742e+03,0.21049e+03,0.20329e+03,0.13860e+03 /)
      kbo(:, 3,57,14) = (/ &
        & 0.89567e+02,0.17837e+03,0.22214e+03,0.21419e+03,0.15343e+03 /)
      kbo(:, 4,57,14) = (/ &
        & 0.10431e+03,0.18733e+03,0.23050e+03,0.22244e+03,0.16644e+03 /)
      kbo(:, 5,57,14) = (/ &
        & 0.11856e+03,0.19423e+03,0.23618e+03,0.22816e+03,0.17767e+03 /)
      kbo(:, 1,58,14) = (/ &
        & 0.56098e+02,0.14991e+03,0.18980e+03,0.18465e+03,0.11706e+03 /)
      kbo(:, 2,58,14) = (/ &
        & 0.70377e+02,0.16367e+03,0.20622e+03,0.19942e+03,0.13378e+03 /)
      kbo(:, 3,58,14) = (/ &
        & 0.85049e+02,0.17528e+03,0.21902e+03,0.21119e+03,0.14910e+03 /)
      kbo(:, 4,58,14) = (/ &
        & 0.99857e+02,0.18482e+03,0.22827e+03,0.22022e+03,0.16268e+03 /)
      kbo(:, 5,58,14) = (/ &
        & 0.11428e+03,0.19233e+03,0.23470e+03,0.22666e+03,0.17444e+03 /)
      kbo(:, 1,59,14) = (/ &
        & 0.54418e+02,0.14809e+03,0.18754e+03,0.18261e+03,0.11495e+03 /)
      kbo(:, 2,59,14) = (/ &
        & 0.68598e+02,0.16210e+03,0.20441e+03,0.19778e+03,0.13180e+03 /)
      kbo(:, 3,59,14) = (/ &
        & 0.83246e+02,0.17398e+03,0.21768e+03,0.20993e+03,0.14733e+03 /)
      kbo(:, 4,59,14) = (/ &
        & 0.98055e+02,0.18375e+03,0.22732e+03,0.21927e+03,0.16113e+03 /)
      kbo(:, 5,59,14) = (/ &
        & 0.11255e+03,0.19153e+03,0.23406e+03,0.22601e+03,0.17310e+03 /)
      kbo(:, 1,13,15) = (/ &
        & 0.40932e+03,0.30758e+03,0.26133e+03,0.32395e+03,0.43211e+03 /)
      kbo(:, 2,13,15) = (/ &
        & 0.41123e+03,0.30908e+03,0.25921e+03,0.31805e+03,0.42431e+03 /)
      kbo(:, 3,13,15) = (/ &
        & 0.41219e+03,0.30983e+03,0.25685e+03,0.31214e+03,0.41639e+03 /)
      kbo(:, 4,13,15) = (/ &
        & 0.41228e+03,0.30991e+03,0.25419e+03,0.30614e+03,0.40836e+03 /)
      kbo(:, 5,13,15) = (/ &
        & 0.41130e+03,0.30917e+03,0.25126e+03,0.30055e+03,0.40088e+03 /)
      kbo(:, 1,14,15) = (/ &
        & 0.46527e+03,0.34966e+03,0.29823e+03,0.35533e+03,0.47402e+03 /)
      kbo(:, 2,14,15) = (/ &
        & 0.46656e+03,0.35065e+03,0.29540e+03,0.34864e+03,0.46510e+03 /)
      kbo(:, 3,14,15) = (/ &
        & 0.46685e+03,0.35090e+03,0.29209e+03,0.34189e+03,0.45610e+03 /)
      kbo(:, 4,14,15) = (/ &
        & 0.46575e+03,0.35012e+03,0.28845e+03,0.33526e+03,0.44716e+03 /)
      kbo(:, 5,14,15) = (/ &
        & 0.46388e+03,0.34873e+03,0.28457e+03,0.32965e+03,0.43950e+03 /)
      kbo(:, 1,15,15) = (/ &
        & 0.52376e+03,0.39388e+03,0.33756e+03,0.38636e+03,0.51543e+03 /)
      kbo(:, 2,15,15) = (/ &
        & 0.52445e+03,0.39416e+03,0.33368e+03,0.37892e+03,0.50548e+03 /)
      kbo(:, 3,15,15) = (/ &
        & 0.52345e+03,0.39343e+03,0.32922e+03,0.37141e+03,0.49535e+03 /)
      kbo(:, 4,15,15) = (/ &
        & 0.52134e+03,0.39188e+03,0.32434e+03,0.36468e+03,0.48621e+03 /)
      kbo(:, 5,15,15) = (/ &
        & 0.51791e+03,0.38933e+03,0.31931e+03,0.35855e+03,0.47766e+03 /)
      kbo(:, 1,16,15) = (/ &
        & 0.58401e+03,0.43962e+03,0.37845e+03,0.41772e+03,0.55681e+03 /)
      kbo(:, 2,16,15) = (/ &
        & 0.58308e+03,0.43844e+03,0.37324e+03,0.40927e+03,0.54538e+03 /)
      kbo(:, 3,16,15) = (/ &
        & 0.58094e+03,0.43662e+03,0.36730e+03,0.40107e+03,0.53429e+03 /)
      kbo(:, 4,16,15) = (/ &
        & 0.57721e+03,0.43385e+03,0.36102e+03,0.39367e+03,0.52421e+03 /)
      kbo(:, 5,16,15) = (/ &
        & 0.57218e+03,0.43010e+03,0.35444e+03,0.38654e+03,0.51433e+03 /)
      kbo(:, 1,17,15) = (/ &
        & 0.64407e+03,0.48569e+03,0.41994e+03,0.44912e+03,0.59692e+03 /)
      kbo(:, 2,17,15) = (/ &
        & 0.64180e+03,0.48304e+03,0.41300e+03,0.43957e+03,0.58409e+03 /)
      kbo(:, 3,17,15) = (/ &
        & 0.63774e+03,0.47951e+03,0.40543e+03,0.43048e+03,0.57188e+03 /)
      kbo(:, 4,17,15) = (/ &
        & 0.63221e+03,0.47511e+03,0.39752e+03,0.42195e+03,0.56041e+03 /)
      kbo(:, 5,17,15) = (/ &
        & 0.62531e+03,0.46997e+03,0.38917e+03,0.41353e+03,0.54901e+03 /)
      kbo(:, 1,18,15) = (/ &
        & 0.70302e+03,0.53125e+03,0.46110e+03,0.48015e+03,0.63499e+03 /)
      kbo(:, 2,18,15) = (/ &
        & 0.69876e+03,0.52681e+03,0.45218e+03,0.46935e+03,0.62082e+03 /)
      kbo(:, 3,18,15) = (/ &
        & 0.69273e+03,0.52130e+03,0.44272e+03,0.45897e+03,0.60731e+03 /)
      kbo(:, 4,18,15) = (/ &
        & 0.68529e+03,0.51514e+03,0.43287e+03,0.44907e+03,0.59416e+03 /)
      kbo(:, 5,18,15) = (/ &
        & 0.67604e+03,0.50804e+03,0.42255e+03,0.43929e+03,0.58117e+03 /)
      kbo(:, 1,19,15) = (/ &
        & 0.75927e+03,0.57536e+03,0.50097e+03,0.51007e+03,0.67027e+03 /)
      kbo(:, 2,19,15) = (/ &
        & 0.75290e+03,0.56864e+03,0.48996e+03,0.49791e+03,0.65476e+03 /)
      kbo(:, 3,19,15) = (/ &
        & 0.74466e+03,0.56117e+03,0.47832e+03,0.48599e+03,0.63995e+03 /)
      kbo(:, 4,19,15) = (/ &
        & 0.73483e+03,0.55286e+03,0.46627e+03,0.47459e+03,0.62519e+03 /)
      kbo(:, 5,19,15) = (/ &
        & 0.72353e+03,0.54375e+03,0.45395e+03,0.46331e+03,0.61054e+03 /)
      kbo(:, 1,20,15) = (/ &
        & 0.81171e+03,0.61670e+03,0.53858e+03,0.53802e+03,0.70226e+03 /)
      kbo(:, 2,20,15) = (/ &
        & 0.80307e+03,0.60788e+03,0.52517e+03,0.52417e+03,0.68550e+03 /)
      kbo(:, 3,20,15) = (/ &
        & 0.79257e+03,0.59823e+03,0.51114e+03,0.51080e+03,0.66917e+03 /)
      kbo(:, 4,20,15) = (/ &
        & 0.78036e+03,0.58759e+03,0.49687e+03,0.49775e+03,0.65285e+03 /)
      kbo(:, 5,20,15) = (/ &
        & 0.76671e+03,0.57649e+03,0.48237e+03,0.48486e+03,0.63647e+03 /)
      kbo(:, 1,21,15) = (/ &
        & 0.85929e+03,0.65464e+03,0.57309e+03,0.56354e+03,0.73074e+03 /)
      kbo(:, 2,21,15) = (/ &
        & 0.84853e+03,0.64350e+03,0.55721e+03,0.54790e+03,0.71267e+03 /)
      kbo(:, 3,21,15) = (/ &
        & 0.83578e+03,0.63172e+03,0.54090e+03,0.53299e+03,0.69483e+03 /)
      kbo(:, 4,21,15) = (/ &
        & 0.82132e+03,0.61900e+03,0.52438e+03,0.51831e+03,0.67689e+03 /)
      kbo(:, 5,21,15) = (/ &
        & 0.80511e+03,0.60568e+03,0.50774e+03,0.50398e+03,0.65894e+03 /)
      kbo(:, 1,22,15) = (/ &
        & 0.90088e+03,0.68794e+03,0.60297e+03,0.58517e+03,0.75429e+03 /)
      kbo(:, 2,22,15) = (/ &
        & 0.88795e+03,0.67453e+03,0.58458e+03,0.56794e+03,0.73512e+03 /)
      kbo(:, 3,22,15) = (/ &
        & 0.87296e+03,0.66047e+03,0.56607e+03,0.55151e+03,0.71573e+03 /)
      kbo(:, 4,22,15) = (/ &
        & 0.85602e+03,0.64569e+03,0.54736e+03,0.53534e+03,0.69633e+03 /)
      kbo(:, 5,22,15) = (/ &
        & 0.83763e+03,0.63042e+03,0.52879e+03,0.51959e+03,0.67694e+03 /)
      kbo(:, 1,23,15) = (/ &
        & 0.93708e+03,0.71670e+03,0.62868e+03,0.60370e+03,0.77407e+03 /)
      kbo(:, 2,23,15) = (/ &
        & 0.92204e+03,0.70111e+03,0.60797e+03,0.58479e+03,0.75367e+03 /)
      kbo(:, 3,23,15) = (/ &
        & 0.90485e+03,0.68501e+03,0.58723e+03,0.56696e+03,0.73284e+03 /)
      kbo(:, 4,23,15) = (/ &
        & 0.88551e+03,0.66835e+03,0.56656e+03,0.54939e+03,0.71207e+03 /)
      kbo(:, 5,23,15) = (/ &
        & 0.86499e+03,0.65129e+03,0.54624e+03,0.53240e+03,0.69156e+03 /)
      kbo(:, 1,24,15) = (/ &
        & 0.96776e+03,0.74092e+03,0.64997e+03,0.61898e+03,0.79010e+03 /)
      kbo(:, 2,24,15) = (/ &
        & 0.95072e+03,0.72338e+03,0.62717e+03,0.59867e+03,0.76855e+03 /)
      kbo(:, 3,24,15) = (/ &
        & 0.93122e+03,0.70539e+03,0.60446e+03,0.57944e+03,0.74652e+03 /)
      kbo(:, 4,24,15) = (/ &
        & 0.90993e+03,0.68704e+03,0.58213e+03,0.56067e+03,0.72451e+03 /)
      kbo(:, 5,24,15) = (/ &
        & 0.88757e+03,0.66845e+03,0.56030e+03,0.54254e+03,0.70312e+03 /)
      kbo(:, 1,25,15) = (/ &
        & 0.99329e+03,0.76073e+03,0.66706e+03,0.63101e+03,0.80276e+03 /)
      kbo(:, 2,25,15) = (/ &
        & 0.97397e+03,0.74138e+03,0.64231e+03,0.60949e+03,0.78003e+03 /)
      kbo(:, 3,25,15) = (/ &
        & 0.95257e+03,0.72186e+03,0.61798e+03,0.58904e+03,0.75681e+03 /)
      kbo(:, 4,25,15) = (/ &
        & 0.92942e+03,0.70193e+03,0.59417e+03,0.56923e+03,0.73392e+03 /)
      kbo(:, 5,25,15) = (/ &
        & 0.90532e+03,0.68191e+03,0.57100e+03,0.55015e+03,0.71169e+03 /)
      kbo(:, 1,26,15) = (/ &
        & 0.10136e+04,0.77623e+03,0.67983e+03,0.63982e+03,0.81189e+03 /)
      kbo(:, 2,26,15) = (/ &
        & 0.99212e+03,0.75536e+03,0.65345e+03,0.61726e+03,0.78804e+03 /)
      kbo(:, 3,26,15) = (/ &
        & 0.96906e+03,0.73441e+03,0.62784e+03,0.59585e+03,0.76400e+03 /)
      kbo(:, 4,26,15) = (/ &
        & 0.94442e+03,0.71314e+03,0.60278e+03,0.57514e+03,0.74031e+03 /)
      kbo(:, 5,26,15) = (/ &
        & 0.91870e+03,0.69199e+03,0.57850e+03,0.55532e+03,0.71748e+03 /)
      kbo(:, 1,27,15) = (/ &
        & 0.10295e+04,0.78816e+03,0.68910e+03,0.64601e+03,0.81822e+03 /)
      kbo(:, 2,27,15) = (/ &
        & 0.10061e+04,0.76604e+03,0.66144e+03,0.62260e+03,0.79343e+03 /)
      kbo(:, 3,27,15) = (/ &
        & 0.98153e+03,0.74373e+03,0.63470e+03,0.60041e+03,0.76875e+03 /)
      kbo(:, 4,27,15) = (/ &
        & 0.95548e+03,0.72130e+03,0.60866e+03,0.57907e+03,0.74456e+03 /)
      kbo(:, 5,27,15) = (/ &
        & 0.92838e+03,0.69916e+03,0.58347e+03,0.55864e+03,0.72113e+03 /)
      kbo(:, 1,28,15) = (/ &
        & 0.10413e+04,0.79681e+03,0.69534e+03,0.64995e+03,0.82220e+03 /)
      kbo(:, 2,28,15) = (/ &
        & 0.10164e+04,0.77357e+03,0.66667e+03,0.62595e+03,0.79680e+03 /)
      kbo(:, 3,28,15) = (/ &
        & 0.99062e+03,0.75026e+03,0.63903e+03,0.60314e+03,0.77147e+03 /)
      kbo(:, 4,28,15) = (/ &
        & 0.96323e+03,0.72694e+03,0.61220e+03,0.58130e+03,0.74687e+03 /)
      kbo(:, 5,28,15) = (/ &
        & 0.93489e+03,0.70393e+03,0.58636e+03,0.56041e+03,0.72308e+03 /)
      kbo(:, 1,29,15) = (/ &
        & 0.10495e+04,0.80260e+03,0.69878e+03,0.65184e+03,0.82409e+03 /)
      kbo(:, 2,29,15) = (/ &
        & 0.10235e+04,0.77841e+03,0.66934e+03,0.62739e+03,0.79811e+03 /)
      kbo(:, 3,29,15) = (/ &
        & 0.99642e+03,0.75425e+03,0.64103e+03,0.60412e+03,0.77230e+03 /)
      kbo(:, 4,29,15) = (/ &
        & 0.96796e+03,0.73025e+03,0.61357e+03,0.58189e+03,0.74741e+03 /)
      kbo(:, 5,29,15) = (/ &
        & 0.93857e+03,0.70654e+03,0.58732e+03,0.56077e+03,0.72335e+03 /)
      kbo(:, 1,30,15) = (/ &
        & 0.10549e+04,0.80614e+03,0.70001e+03,0.65202e+03,0.82418e+03 /)
      kbo(:, 2,30,15) = (/ &
        & 0.10278e+04,0.78108e+03,0.67004e+03,0.62730e+03,0.79771e+03 /)
      kbo(:, 3,30,15) = (/ &
        & 0.99966e+03,0.75628e+03,0.64121e+03,0.60374e+03,0.77172e+03 /)
      kbo(:, 4,30,15) = (/ &
        & 0.97021e+03,0.73170e+03,0.61335e+03,0.58130e+03,0.74664e+03 /)
      kbo(:, 5,30,15) = (/ &
        & 0.94007e+03,0.70743e+03,0.58676e+03,0.55999e+03,0.72234e+03 /)
      kbo(:, 1,31,15) = (/ &
        & 0.10577e+04,0.80741e+03,0.69925e+03,0.65081e+03,0.82281e+03 /)
      kbo(:, 2,31,15) = (/ &
        & 0.10297e+04,0.78182e+03,0.66894e+03,0.62588e+03,0.79605e+03 /)
      kbo(:, 3,31,15) = (/ &
        & 0.10005e+04,0.75649e+03,0.63976e+03,0.60219e+03,0.76987e+03 /)
      kbo(:, 4,31,15) = (/ &
        & 0.97028e+03,0.73149e+03,0.61167e+03,0.57962e+03,0.74468e+03 /)
      kbo(:, 5,31,15) = (/ &
        & 0.93951e+03,0.70673e+03,0.58494e+03,0.55830e+03,0.72033e+03 /)
      kbo(:, 1,32,15) = (/ &
        & 0.10585e+04,0.80706e+03,0.69697e+03,0.64853e+03,0.82034e+03 /)
      kbo(:, 2,32,15) = (/ &
        & 0.10295e+04,0.78094e+03,0.66639e+03,0.62348e+03,0.79329e+03 /)
      kbo(:, 3,32,15) = (/ &
        & 0.99955e+03,0.75528e+03,0.63700e+03,0.59969e+03,0.76700e+03 /)
      kbo(:, 4,32,15) = (/ &
        & 0.96864e+03,0.72996e+03,0.60885e+03,0.57712e+03,0.74178e+03 /)
      kbo(:, 5,32,15) = (/ &
        & 0.93737e+03,0.70488e+03,0.58204e+03,0.55579e+03,0.71738e+03 /)
      kbo(:, 1,33,15) = (/ &
        & 0.10575e+04,0.80530e+03,0.69345e+03,0.64529e+03,0.81678e+03 /)
      kbo(:, 2,33,15) = (/ &
        & 0.10278e+04,0.77890e+03,0.66278e+03,0.62027e+03,0.78965e+03 /)
      kbo(:, 3,33,15) = (/ &
        & 0.99704e+03,0.75290e+03,0.63324e+03,0.59645e+03,0.76337e+03 /)
      kbo(:, 4,33,15) = (/ &
        & 0.96555e+03,0.72726e+03,0.60509e+03,0.57394e+03,0.73813e+03 /)
      kbo(:, 5,33,15) = (/ &
        & 0.93393e+03,0.70207e+03,0.57839e+03,0.55267e+03,0.71377e+03 /)
      kbo(:, 1,34,15) = (/ &
        & 0.10561e+04,0.80340e+03,0.69012e+03,0.64228e+03,0.81344e+03 /)
      kbo(:, 2,34,15) = (/ &
        & 0.10257e+04,0.77677e+03,0.65936e+03,0.61726e+03,0.78628e+03 /)
      kbo(:, 3,34,15) = (/ &
        & 0.99442e+03,0.75053e+03,0.62978e+03,0.59351e+03,0.76009e+03 /)
      kbo(:, 4,34,15) = (/ &
        & 0.96258e+03,0.72472e+03,0.60168e+03,0.57104e+03,0.73478e+03 /)
      kbo(:, 5,34,15) = (/ &
        & 0.93053e+03,0.69938e+03,0.57499e+03,0.54984e+03,0.71051e+03 /)
      kbo(:, 1,35,15) = (/ &
        & 0.10564e+04,0.80326e+03,0.68907e+03,0.64121e+03,0.81221e+03 /)
      kbo(:, 2,35,15) = (/ &
        & 0.10257e+04,0.77646e+03,0.65819e+03,0.61612e+03,0.78498e+03 /)
      kbo(:, 3,35,15) = (/ &
        & 0.99396e+03,0.74998e+03,0.62850e+03,0.59231e+03,0.75874e+03 /)
      kbo(:, 4,35,15) = (/ &
        & 0.96182e+03,0.72398e+03,0.60037e+03,0.56987e+03,0.73339e+03 /)
      kbo(:, 5,35,15) = (/ &
        & 0.92945e+03,0.69852e+03,0.57362e+03,0.54864e+03,0.70910e+03 /)
      kbo(:, 1,36,15) = (/ &
        & 0.10593e+04,0.80545e+03,0.69086e+03,0.64252e+03,0.81357e+03 /)
      kbo(:, 2,36,15) = (/ &
        & 0.10283e+04,0.77842e+03,0.65978e+03,0.61726e+03,0.78619e+03 /)
      kbo(:, 3,36,15) = (/ &
        & 0.99627e+03,0.75174e+03,0.62993e+03,0.59335e+03,0.75988e+03 /)
      kbo(:, 4,36,15) = (/ &
        & 0.96386e+03,0.72553e+03,0.60161e+03,0.57080e+03,0.73443e+03 /)
      kbo(:, 5,36,15) = (/ &
        & 0.93134e+03,0.69996e+03,0.57477e+03,0.54947e+03,0.71003e+03 /)
      kbo(:, 1,37,15) = (/ &
        & 0.10662e+04,0.81134e+03,0.69713e+03,0.64751e+03,0.81885e+03 /)
      kbo(:, 2,37,15) = (/ &
        & 0.10351e+04,0.78402e+03,0.66565e+03,0.62189e+03,0.79122e+03 /)
      kbo(:, 3,37,15) = (/ &
        & 0.10030e+04,0.75714e+03,0.63542e+03,0.59764e+03,0.76460e+03 /)
      kbo(:, 4,37,15) = (/ &
        & 0.97042e+03,0.73071e+03,0.60674e+03,0.57477e+03,0.73895e+03 /)
      kbo(:, 5,37,15) = (/ &
        & 0.93771e+03,0.70485e+03,0.57959e+03,0.55322e+03,0.71431e+03 /)
      kbo(:, 1,38,15) = (/ &
        & 0.10729e+04,0.81713e+03,0.70342e+03,0.65252e+03,0.82415e+03 /)
      kbo(:, 2,38,15) = (/ &
        & 0.10416e+04,0.78952e+03,0.67152e+03,0.62655e+03,0.79626e+03 /)
      kbo(:, 3,38,15) = (/ &
        & 0.10096e+04,0.76249e+03,0.64098e+03,0.60198e+03,0.76937e+03 /)
      kbo(:, 4,38,15) = (/ &
        & 0.97695e+03,0.73588e+03,0.61197e+03,0.57883e+03,0.74352e+03 /)
      kbo(:, 5,38,15) = (/ &
        & 0.94411e+03,0.70978e+03,0.58447e+03,0.55704e+03,0.71866e+03 /)
      kbo(:, 1,39,15) = (/ &
        & 0.10791e+04,0.82257e+03,0.70938e+03,0.65729e+03,0.82913e+03 /)
      kbo(:, 2,39,15) = (/ &
        & 0.10479e+04,0.79481e+03,0.67717e+03,0.63099e+03,0.80105e+03 /)
      kbo(:, 3,39,15) = (/ &
        & 0.10158e+04,0.76754e+03,0.64630e+03,0.60614e+03,0.77394e+03 /)
      kbo(:, 4,39,15) = (/ &
        & 0.98307e+03,0.74076e+03,0.61694e+03,0.58271e+03,0.74789e+03 /)
      kbo(:, 5,39,15) = (/ &
        & 0.95013e+03,0.71446e+03,0.58917e+03,0.56072e+03,0.72285e+03 /)
      kbo(:, 1,40,15) = (/ &
        & 0.10882e+04,0.83071e+03,0.71862e+03,0.66478e+03,0.83689e+03 /)
      kbo(:, 2,40,15) = (/ &
        & 0.10571e+04,0.80265e+03,0.68589e+03,0.63804e+03,0.80862e+03 /)
      kbo(:, 3,40,15) = (/ &
        & 0.10251e+04,0.77527e+03,0.65462e+03,0.61278e+03,0.78119e+03 /)
      kbo(:, 4,40,15) = (/ &
        & 0.99232e+03,0.74818e+03,0.62475e+03,0.58893e+03,0.75487e+03 /)
      kbo(:, 5,40,15) = (/ &
        & 0.95932e+03,0.72168e+03,0.59655e+03,0.56653e+03,0.72946e+03 /)
      kbo(:, 1,41,15) = (/ &
        & 0.10971e+04,0.83901e+03,0.72823e+03,0.67265e+03,0.84493e+03 /)
      kbo(:, 2,41,15) = (/ &
        & 0.10663e+04,0.81071e+03,0.69500e+03,0.64543e+03,0.81648e+03 /)
      kbo(:, 3,41,15) = (/ &
        & 0.10345e+04,0.78315e+03,0.66331e+03,0.61971e+03,0.78878e+03 /)
      kbo(:, 4,41,15) = (/ &
        & 0.10019e+04,0.75590e+03,0.63295e+03,0.59541e+03,0.76210e+03 /)
      kbo(:, 5,41,15) = (/ &
        & 0.96878e+03,0.72921e+03,0.60428e+03,0.57260e+03,0.73637e+03 /)
      kbo(:, 1,42,15) = (/ &
        & 0.11058e+04,0.84736e+03,0.73795e+03,0.68059e+03,0.85278e+03 /)
      kbo(:, 2,42,15) = (/ &
        & 0.10754e+04,0.81879e+03,0.70412e+03,0.65281e+03,0.82432e+03 /)
      kbo(:, 3,42,15) = (/ &
        & 0.10438e+04,0.79093e+03,0.67198e+03,0.62664e+03,0.79629e+03 /)
      kbo(:, 4,42,15) = (/ &
        & 0.10112e+04,0.76353e+03,0.64116e+03,0.60189e+03,0.76925e+03 /)
      kbo(:, 5,42,15) = (/ &
        & 0.97804e+03,0.73660e+03,0.61202e+03,0.57870e+03,0.74332e+03 /)
      kbo(:, 1,43,15) = (/ &
        & 0.11158e+04,0.85717e+03,0.74955e+03,0.69024e+03,0.86217e+03 /)
      kbo(:, 2,43,15) = (/ &
        & 0.10861e+04,0.82836e+03,0.71518e+03,0.66177e+03,0.83370e+03 /)
      kbo(:, 3,43,15) = (/ &
        & 0.10546e+04,0.80021e+03,0.68243e+03,0.63507e+03,0.80541e+03 /)
      kbo(:, 4,43,15) = (/ &
        & 0.10222e+04,0.77261e+03,0.65115e+03,0.60984e+03,0.77795e+03 /)
      kbo(:, 5,43,15) = (/ &
        & 0.98916e+03,0.74551e+03,0.62143e+03,0.58614e+03,0.75171e+03 /)
      kbo(:, 1,44,15) = (/ &
        & 0.11264e+04,0.86786e+03,0.76217e+03,0.70088e+03,0.87207e+03 /)
      kbo(:, 2,44,15) = (/ &
        & 0.10970e+04,0.83855e+03,0.72711e+03,0.67158e+03,0.84381e+03 /)
      kbo(:, 3,44,15) = (/ &
        & 0.10660e+04,0.81015e+03,0.69375e+03,0.64429e+03,0.81530e+03 /)
      kbo(:, 4,44,15) = (/ &
        & 0.10339e+04,0.78245e+03,0.66207e+03,0.61859e+03,0.78750e+03 /)
      kbo(:, 5,44,15) = (/ &
        & 0.10010e+04,0.75506e+03,0.63169e+03,0.59432e+03,0.76086e+03 /)
      kbo(:, 1,45,15) = (/ &
        & 0.11364e+04,0.87855e+03,0.77494e+03,0.71181e+03,0.88191e+03 /)
      kbo(:, 2,45,15) = (/ &
        & 0.11078e+04,0.84885e+03,0.73921e+03,0.68154e+03,0.85373e+03 /)
      kbo(:, 3,45,15) = (/ &
        & 0.10773e+04,0.82021e+03,0.70525e+03,0.65361e+03,0.82516e+03 /)
      kbo(:, 4,45,15) = (/ &
        & 0.10454e+04,0.79218e+03,0.67305e+03,0.62740e+03,0.79708e+03 /)
      kbo(:, 5,45,15) = (/ &
        & 0.10127e+04,0.76466e+03,0.64208e+03,0.60256e+03,0.76997e+03 /)
      kbo(:, 1,46,15) = (/ &
        & 0.11465e+04,0.88995e+03,0.78864e+03,0.72357e+03,0.89218e+03 /)
      kbo(:, 2,46,15) = (/ &
        & 0.11189e+04,0.85981e+03,0.75227e+03,0.69242e+03,0.86430e+03 /)
      kbo(:, 3,46,15) = (/ &
        & 0.10889e+04,0.83077e+03,0.71764e+03,0.66370e+03,0.83569e+03 /)
      kbo(:, 4,46,15) = (/ &
        & 0.10574e+04,0.80253e+03,0.68479e+03,0.63689e+03,0.80730e+03 /)
      kbo(:, 5,46,15) = (/ &
        & 0.10249e+04,0.77483e+03,0.65332e+03,0.61153e+03,0.77982e+03 /)
      kbo(:, 1,47,15) = (/ &
        & 0.11573e+04,0.90286e+03,0.80421e+03,0.73669e+03,0.90313e+03 /)
      kbo(:, 2,47,15) = (/ &
        & 0.11308e+04,0.87219e+03,0.76703e+03,0.70495e+03,0.87583e+03 /)
      kbo(:, 3,47,15) = (/ &
        & 0.11017e+04,0.84272e+03,0.73168e+03,0.67524e+03,0.84747e+03 /)
      kbo(:, 4,47,15) = (/ &
        & 0.10706e+04,0.81413e+03,0.69808e+03,0.64772e+03,0.81886e+03 /)
      kbo(:, 5,47,15) = (/ &
        & 0.10385e+04,0.78623e+03,0.66606e+03,0.62176e+03,0.79095e+03 /)
      kbo(:, 1,48,15) = (/ &
        & 0.11675e+04,0.91580e+03,0.81991e+03,0.74998e+03,0.91375e+03 /)
      kbo(:, 2,48,15) = (/ &
        & 0.11421e+04,0.88462e+03,0.78203e+03,0.71783e+03,0.88726e+03 /)
      kbo(:, 3,48,15) = (/ &
        & 0.11139e+04,0.85471e+03,0.74597e+03,0.68710e+03,0.85917e+03 /)
      kbo(:, 4,48,15) = (/ &
        & 0.10836e+04,0.82582e+03,0.71165e+03,0.65875e+03,0.83052e+03 /)
      kbo(:, 5,48,15) = (/ &
        & 0.10518e+04,0.79762e+03,0.67897e+03,0.63216e+03,0.80224e+03 /)
      kbo(:, 1,49,15) = (/ &
        & 0.11770e+04,0.92887e+03,0.83589e+03,0.76347e+03,0.92401e+03 /)
      kbo(:, 2,49,15) = (/ &
        & 0.11531e+04,0.89735e+03,0.79736e+03,0.73085e+03,0.89839e+03 /)
      kbo(:, 3,49,15) = (/ &
        & 0.11259e+04,0.86690e+03,0.76049e+03,0.69928e+03,0.87069e+03 /)
      kbo(:, 4,49,15) = (/ &
        & 0.10963e+04,0.83754e+03,0.72543e+03,0.67003e+03,0.84223e+03 /)
      kbo(:, 5,49,15) = (/ &
        & 0.10650e+04,0.80903e+03,0.69202e+03,0.64278e+03,0.81363e+03 /)
      kbo(:, 1,50,15) = (/ &
        & 0.11850e+04,0.94106e+03,0.85114e+03,0.77623e+03,0.93320e+03 /)
      kbo(:, 2,50,15) = (/ &
        & 0.11628e+04,0.90935e+03,0.81191e+03,0.74315e+03,0.90846e+03 /)
      kbo(:, 3,50,15) = (/ &
        & 0.11368e+04,0.87848e+03,0.77441e+03,0.71118e+03,0.88145e+03 /)
      kbo(:, 4,50,15) = (/ &
        & 0.11080e+04,0.84872e+03,0.73862e+03,0.68089e+03,0.85311e+03 /)
      kbo(:, 5,50,15) = (/ &
        & 0.10771e+04,0.81987e+03,0.70453e+03,0.65297e+03,0.82446e+03 /)
      kbo(:, 1,51,15) = (/ &
        & 0.11923e+04,0.95283e+03,0.86626e+03,0.78865e+03,0.94170e+03 /)
      kbo(:, 2,51,15) = (/ &
        & 0.11717e+04,0.92110e+03,0.82616e+03,0.75525e+03,0.91794e+03 /)
      kbo(:, 3,51,15) = (/ &
        & 0.11468e+04,0.88978e+03,0.78804e+03,0.72292e+03,0.89168e+03 /)
      kbo(:, 4,51,15) = (/ &
        & 0.11189e+04,0.85951e+03,0.75159e+03,0.69174e+03,0.86368e+03 /)
      kbo(:, 5,51,15) = (/ &
        & 0.10888e+04,0.83043e+03,0.71698e+03,0.66309e+03,0.83504e+03 /)
      kbo(:, 1,52,15) = (/ &
        & 0.11987e+04,0.96448e+03,0.88155e+03,0.80101e+03,0.94976e+03 /)
      kbo(:, 2,52,15) = (/ &
        & 0.11799e+04,0.93288e+03,0.84067e+03,0.76742e+03,0.92694e+03 /)
      kbo(:, 3,52,15) = (/ &
        & 0.11564e+04,0.90125e+03,0.80189e+03,0.73467e+03,0.90155e+03 /)
      kbo(:, 4,52,15) = (/ &
        & 0.11296e+04,0.87065e+03,0.76482e+03,0.70289e+03,0.87401e+03 /)
      kbo(:, 5,52,15) = (/ &
        & 0.11001e+04,0.84107e+03,0.72948e+03,0.67337e+03,0.84559e+03 /)
      kbo(:, 1,53,15) = (/ &
        & 0.12042e+04,0.97597e+03,0.89729e+03,0.81334e+03,0.95716e+03 /)
      kbo(:, 2,53,15) = (/ &
        & 0.11876e+04,0.94467e+03,0.85557e+03,0.77990e+03,0.93591e+03 /)
      kbo(:, 3,53,15) = (/ &
        & 0.11657e+04,0.91285e+03,0.81605e+03,0.74663e+03,0.91125e+03 /)
      kbo(:, 4,53,15) = (/ &
        & 0.11399e+04,0.88179e+03,0.77830e+03,0.71447e+03,0.88437e+03 /)
      kbo(:, 5,53,15) = (/ &
        & 0.11113e+04,0.85189e+03,0.74233e+03,0.68396e+03,0.85611e+03 /)
      kbo(:, 1,54,15) = (/ &
        & 0.12085e+04,0.98643e+03,0.91208e+03,0.82462e+03,0.96332e+03 /)
      kbo(:, 2,54,15) = (/ &
        & 0.11940e+04,0.95533e+03,0.86934e+03,0.79114e+03,0.94342e+03 /)
      kbo(:, 3,54,15) = (/ &
        & 0.11737e+04,0.92362e+03,0.82909e+03,0.75767e+03,0.91977e+03 /)
      kbo(:, 4,54,15) = (/ &
        & 0.11490e+04,0.89214e+03,0.79079e+03,0.72522e+03,0.89369e+03 /)
      kbo(:, 5,54,15) = (/ &
        & 0.11212e+04,0.86180e+03,0.75420e+03,0.69390e+03,0.86571e+03 /)
      kbo(:, 1,55,15) = (/ &
        & 0.12111e+04,0.99597e+03,0.92635e+03,0.83534e+03,0.96856e+03 /)
      kbo(:, 2,55,15) = (/ &
        & 0.11993e+04,0.96550e+03,0.88281e+03,0.80196e+03,0.95029e+03 /)
      kbo(:, 3,55,15) = (/ &
        & 0.11808e+04,0.93390e+03,0.84185e+03,0.76841e+03,0.92774e+03 /)
      kbo(:, 4,55,15) = (/ &
        & 0.11574e+04,0.90226e+03,0.80305e+03,0.73557e+03,0.90236e+03 /)
      kbo(:, 5,55,15) = (/ &
        & 0.11305e+04,0.87151e+03,0.76581e+03,0.70377e+03,0.87482e+03 /)
      kbo(:, 1,56,15) = (/ &
        & 0.12133e+04,0.10055e+04,0.94091e+03,0.84599e+03,0.97308e+03 /)
      kbo(:, 2,56,15) = (/ &
        & 0.12041e+04,0.97555e+03,0.89660e+03,0.81280e+03,0.95684e+03 /)
      kbo(:, 3,56,15) = (/ &
        & 0.11875e+04,0.94422e+03,0.85482e+03,0.77921e+03,0.93538e+03 /)
      kbo(:, 4,56,15) = (/ &
        & 0.11654e+04,0.91235e+03,0.81536e+03,0.74599e+03,0.91077e+03 /)
      kbo(:, 5,56,15) = (/ &
        & 0.11395e+04,0.88125e+03,0.77756e+03,0.71383e+03,0.88381e+03 /)
      kbo(:, 1,57,15) = (/ &
        & 0.12144e+04,0.10149e+04,0.95530e+03,0.85635e+03,0.97654e+03 /)
      kbo(:, 2,57,15) = (/ &
        & 0.12082e+04,0.98553e+03,0.91069e+03,0.82360e+03,0.96286e+03 /)
      kbo(:, 3,57,15) = (/ &
        & 0.11936e+04,0.95436e+03,0.86797e+03,0.78997e+03,0.94263e+03 /)
      kbo(:, 4,57,15) = (/ &
        & 0.11730e+04,0.92261e+03,0.82779e+03,0.75653e+03,0.91896e+03 /)
      kbo(:, 5,57,15) = (/ &
        & 0.11481e+04,0.89107e+03,0.78949e+03,0.72412e+03,0.89274e+03 /)
      kbo(:, 1,58,15) = (/ &
        & 0.12146e+04,0.10236e+04,0.96889e+03,0.86606e+03,0.97897e+03 /)
      kbo(:, 2,58,15) = (/ &
        & 0.12111e+04,0.99468e+03,0.92419e+03,0.83372e+03,0.96790e+03 /)
      kbo(:, 3,58,15) = (/ &
        & 0.11988e+04,0.96400e+03,0.88060e+03,0.80022e+03,0.94932e+03 /)
      kbo(:, 4,58,15) = (/ &
        & 0.11798e+04,0.93230e+03,0.83979e+03,0.76663e+03,0.92647e+03 /)
      kbo(:, 5,58,15) = (/ &
        & 0.11561e+04,0.90059e+03,0.80102e+03,0.73388e+03,0.90094e+03 /)
      kbo(:, 1,59,15) = (/ &
        & 0.12143e+04,0.10270e+04,0.97431e+03,0.86988e+03,0.97963e+03 /)
      kbo(:, 2,59,15) = (/ &
        & 0.12120e+04,0.99826e+03,0.92964e+03,0.83774e+03,0.96974e+03 /)
      kbo(:, 3,59,15) = (/ &
        & 0.12008e+04,0.96785e+03,0.88575e+03,0.80426e+03,0.95182e+03 /)
      kbo(:, 4,59,15) = (/ &
        & 0.11824e+04,0.93625e+03,0.84468e+03,0.77075e+03,0.92946e+03 /)
      kbo(:, 5,59,15) = (/ &
        & 0.11592e+04,0.90444e+03,0.80567e+03,0.73781e+03,0.90417e+03 /)
      kbo(:, 1,13,16) = (/ &
        & 0.60786e+03,0.45592e+03,0.38499e+03,0.57704e+03,0.77025e+03 /)
      kbo(:, 2,13,16) = (/ &
        & 0.61089e+03,0.45819e+03,0.37289e+03,0.55854e+03,0.74550e+03 /)
      kbo(:, 3,13,16) = (/ &
        & 0.61169e+03,0.45879e+03,0.36189e+03,0.54102e+03,0.72223e+03 /)
      kbo(:, 4,13,16) = (/ &
        & 0.61079e+03,0.45811e+03,0.35169e+03,0.52404e+03,0.69950e+03 /)
      kbo(:, 5,13,16) = (/ &
        & 0.60850e+03,0.45639e+03,0.34199e+03,0.50729e+03,0.67716e+03 /)
      kbo(:, 1,14,16) = (/ &
        & 0.71905e+03,0.53931e+03,0.44704e+03,0.66948e+03,0.89363e+03 /)
      kbo(:, 2,14,16) = (/ &
        & 0.71950e+03,0.53965e+03,0.43274e+03,0.64598e+03,0.86230e+03 /)
      kbo(:, 3,14,16) = (/ &
        & 0.71818e+03,0.53865e+03,0.41969e+03,0.62353e+03,0.83220e+03 /)
      kbo(:, 4,14,16) = (/ &
        & 0.71532e+03,0.53651e+03,0.40717e+03,0.60193e+03,0.80343e+03 /)
      kbo(:, 5,14,16) = (/ &
        & 0.71008e+03,0.53258e+03,0.39527e+03,0.58080e+03,0.77521e+03 /)
      kbo(:, 1,15,16) = (/ &
        & 0.84339e+03,0.63256e+03,0.51534e+03,0.76897e+03,0.10264e+04 /)
      kbo(:, 2,15,16) = (/ &
        & 0.84056e+03,0.63042e+03,0.49783e+03,0.73927e+03,0.98670e+03 /)
      kbo(:, 3,15,16) = (/ &
        & 0.83549e+03,0.62663e+03,0.48183e+03,0.71056e+03,0.94836e+03 /)
      kbo(:, 4,15,16) = (/ &
        & 0.82865e+03,0.62150e+03,0.46649e+03,0.68266e+03,0.91115e+03 /)
      kbo(:, 5,15,16) = (/ &
        & 0.81975e+03,0.61483e+03,0.45195e+03,0.65670e+03,0.87636e+03 /)
      kbo(:, 1,16,16) = (/ &
        & 0.97910e+03,0.73434e+03,0.58857e+03,0.87272e+03,0.11648e+04 /)
      kbo(:, 2,16,16) = (/ &
        & 0.97153e+03,0.72866e+03,0.56721e+03,0.83540e+03,0.11150e+04 /)
      kbo(:, 3,16,16) = (/ &
        & 0.96129e+03,0.72098e+03,0.54742e+03,0.79937e+03,0.10667e+04 /)
      kbo(:, 4,16,16) = (/ &
        & 0.94880e+03,0.71161e+03,0.52876e+03,0.76497e+03,0.10209e+04 /)
      kbo(:, 5,16,16) = (/ &
        & 0.93421e+03,0.70067e+03,0.51082e+03,0.73352e+03,0.97881e+03 /)
      kbo(:, 1,17,16) = (/ &
        & 0.11229e+04,0.84221e+03,0.66547e+03,0.97911e+03,0.13066e+04 /)
      kbo(:, 2,17,16) = (/ &
        & 0.11091e+04,0.83187e+03,0.63930e+03,0.93226e+03,0.12440e+04 /)
      kbo(:, 3,17,16) = (/ &
        & 0.10923e+04,0.81922e+03,0.61539e+03,0.88802e+03,0.11849e+04 /)
      kbo(:, 4,17,16) = (/ &
        & 0.10728e+04,0.80459e+03,0.59256e+03,0.84691e+03,0.11301e+04 /)
      kbo(:, 5,17,16) = (/ &
        & 0.10515e+04,0.78865e+03,0.57044e+03,0.80936e+03,0.10799e+04 /)
      kbo(:, 1,18,16) = (/ &
        & 0.12716e+04,0.95370e+03,0.74447e+03,0.10843e+04,0.14469e+04 /)
      kbo(:, 2,18,16) = (/ &
        & 0.12500e+04,0.93749e+03,0.71274e+03,0.10272e+04,0.13706e+04 /)
      kbo(:, 3,18,16) = (/ &
        & 0.12251e+04,0.91883e+03,0.68394e+03,0.97432e+03,0.13000e+04 /)
      kbo(:, 4,18,16) = (/ &
        & 0.11973e+04,0.89795e+03,0.65609e+03,0.92626e+03,0.12359e+04 /)
      kbo(:, 5,18,16) = (/ &
        & 0.11679e+04,0.87596e+03,0.62959e+03,0.88232e+03,0.11772e+04 /)
      kbo(:, 1,19,16) = (/ &
        & 0.14213e+04,0.10659e+04,0.82299e+03,0.11854e+04,0.15817e+04 /)
      kbo(:, 2,19,16) = (/ &
        & 0.13899e+04,0.10424e+04,0.78536e+03,0.11181e+04,0.14919e+04 /)
      kbo(:, 3,19,16) = (/ &
        & 0.13555e+04,0.10166e+04,0.75067e+03,0.10563e+04,0.14093e+04 /)
      kbo(:, 4,19,16) = (/ &
        & 0.13187e+04,0.98902e+03,0.71751e+03,0.10008e+04,0.13351e+04 /)
      kbo(:, 5,19,16) = (/ &
        & 0.12809e+04,0.96067e+03,0.68653e+03,0.95065e+03,0.12682e+04 /)
      kbo(:, 1,20,16) = (/ &
        & 0.15671e+04,0.11753e+04,0.89787e+03,0.12782e+04,0.17052e+04 /)
      kbo(:, 2,20,16) = (/ &
        & 0.15245e+04,0.11434e+04,0.85373e+03,0.12013e+04,0.16026e+04 /)
      kbo(:, 3,20,16) = (/ &
        & 0.14795e+04,0.11097e+04,0.81323e+03,0.11307e+04,0.15085e+04 /)
      kbo(:, 4,20,16) = (/ &
        & 0.14333e+04,0.10750e+04,0.77488e+03,0.10684e+04,0.14252e+04 /)
      kbo(:, 5,20,16) = (/ &
        & 0.13861e+04,0.10396e+04,0.73891e+03,0.10119e+04,0.13498e+04 /)
      kbo(:, 1,21,16) = (/ &
        & 0.17057e+04,0.12793e+04,0.96840e+03,0.13620e+04,0.18170e+04 /)
      kbo(:, 2,21,16) = (/ &
        & 0.16509e+04,0.12382e+04,0.91726e+03,0.12758e+04,0.17018e+04 /)
      kbo(:, 3,21,16) = (/ &
        & 0.15947e+04,0.11960e+04,0.87064e+03,0.11975e+04,0.15973e+04 /)
      kbo(:, 4,21,16) = (/ &
        & 0.15386e+04,0.11540e+04,0.82723e+03,0.11286e+04,0.15054e+04 /)
      kbo(:, 5,21,16) = (/ &
        & 0.14823e+04,0.11117e+04,0.78614e+03,0.10661e+04,0.14220e+04 /)
      kbo(:, 1,22,16) = (/ &
        & 0.18293e+04,0.13720e+04,0.10288e+04,0.14300e+04,0.19074e+04 /)
      kbo(:, 2,22,16) = (/ &
        & 0.17617e+04,0.13213e+04,0.97120e+03,0.13351e+04,0.17808e+04 /)
      kbo(:, 3,22,16) = (/ &
        & 0.16944e+04,0.12708e+04,0.91894e+03,0.12506e+04,0.16681e+04 /)
      kbo(:, 4,22,16) = (/ &
        & 0.16287e+04,0.12215e+04,0.87041e+03,0.11757e+04,0.15681e+04 /)
      kbo(:, 5,22,16) = (/ &
        & 0.15635e+04,0.11726e+04,0.82499e+03,0.11083e+04,0.14783e+04 /)
      kbo(:, 1,23,16) = (/ &
        & 0.19373e+04,0.14530e+04,0.10803e+04,0.14855e+04,0.19814e+04 /)
      kbo(:, 2,23,16) = (/ &
        & 0.18577e+04,0.13933e+04,0.10171e+04,0.13836e+04,0.18455e+04 /)
      kbo(:, 3,23,16) = (/ &
        & 0.17799e+04,0.13350e+04,0.95955e+03,0.12936e+04,0.17253e+04 /)
      kbo(:, 4,23,16) = (/ &
        & 0.17053e+04,0.12790e+04,0.90643e+03,0.12138e+04,0.16189e+04 /)
      kbo(:, 5,23,16) = (/ &
        & 0.16318e+04,0.12239e+04,0.85742e+03,0.11422e+04,0.15233e+04 /)
      kbo(:, 1,24,16) = (/ &
        & 0.20285e+04,0.15214e+04,0.11229e+04,0.15287e+04,0.20389e+04 /)
      kbo(:, 2,24,16) = (/ &
        & 0.19379e+04,0.14534e+04,0.10546e+04,0.14215e+04,0.18958e+04 /)
      kbo(:, 3,24,16) = (/ &
        & 0.18509e+04,0.13882e+04,0.99252e+03,0.13268e+04,0.17696e+04 /)
      kbo(:, 4,24,16) = (/ &
        & 0.17680e+04,0.13260e+04,0.93542e+03,0.12431e+04,0.16579e+04 /)
      kbo(:, 5,24,16) = (/ &
        & 0.16872e+04,0.12654e+04,0.88318e+03,0.11679e+04,0.15576e+04 /)
      kbo(:, 1,25,16) = (/ &
        & 0.21022e+04,0.15767e+04,0.11562e+04,0.15596e+04,0.20800e+04 /)
      kbo(:, 2,25,16) = (/ &
        & 0.20021e+04,0.15016e+04,0.10837e+04,0.14483e+04,0.19315e+04 /)
      kbo(:, 3,25,16) = (/ &
        & 0.19072e+04,0.14304e+04,0.10177e+04,0.13507e+04,0.18013e+04 /)
      kbo(:, 4,25,16) = (/ &
        & 0.18172e+04,0.13629e+04,0.95761e+03,0.12639e+04,0.16854e+04 /)
      kbo(:, 5,25,16) = (/ &
        & 0.17302e+04,0.12976e+04,0.90262e+03,0.11861e+04,0.15818e+04 /)
      kbo(:, 1,26,16) = (/ &
        & 0.21584e+04,0.16188e+04,0.11798e+04,0.15785e+04,0.21051e+04 /)
      kbo(:, 2,26,16) = (/ &
        & 0.20504e+04,0.15378e+04,0.11040e+04,0.14649e+04,0.19536e+04 /)
      kbo(:, 3,26,16) = (/ &
        & 0.19488e+04,0.14616e+04,0.10351e+04,0.13650e+04,0.18204e+04 /)
      kbo(:, 4,26,16) = (/ &
        & 0.18527e+04,0.13896e+04,0.97267e+03,0.12762e+04,0.17019e+04 /)
      kbo(:, 5,26,16) = (/ &
        & 0.17609e+04,0.13206e+04,0.91583e+03,0.11969e+04,0.15961e+04 /)
      kbo(:, 1,27,16) = (/ &
        & 0.21995e+04,0.16496e+04,0.11960e+04,0.15887e+04,0.21185e+04 /)
      kbo(:, 2,27,16) = (/ &
        & 0.20852e+04,0.15639e+04,0.11175e+04,0.14736e+04,0.19651e+04 /)
      kbo(:, 3,27,16) = (/ &
        & 0.19784e+04,0.14838e+04,0.10466e+04,0.13723e+04,0.18300e+04 /)
      kbo(:, 4,27,16) = (/ &
        & 0.18776e+04,0.14082e+04,0.98231e+03,0.12823e+04,0.17101e+04 /)
      kbo(:, 5,27,16) = (/ &
        & 0.17820e+04,0.13365e+04,0.92416e+03,0.12022e+04,0.16031e+04 /)
      kbo(:, 1,28,16) = (/ &
        & 0.22274e+04,0.16706e+04,0.12052e+04,0.15913e+04,0.21220e+04 /)
      kbo(:, 2,28,16) = (/ &
        & 0.21084e+04,0.15813e+04,0.11251e+04,0.14757e+04,0.19679e+04 /)
      kbo(:, 3,28,16) = (/ &
        & 0.19974e+04,0.14981e+04,0.10528e+04,0.13738e+04,0.18320e+04 /)
      kbo(:, 4,28,16) = (/ &
        & 0.18930e+04,0.14198e+04,0.98736e+03,0.12834e+04,0.17114e+04 /)
      kbo(:, 5,28,16) = (/ &
        & 0.17945e+04,0.13459e+04,0.92826e+03,0.12029e+04,0.16040e+04 /)
      kbo(:, 1,29,16) = (/ &
        & 0.22434e+04,0.16825e+04,0.12082e+04,0.15868e+04,0.21160e+04 /)
      kbo(:, 2,29,16) = (/ &
        & 0.21209e+04,0.15907e+04,0.11272e+04,0.14716e+04,0.19623e+04 /)
      kbo(:, 3,29,16) = (/ &
        & 0.20069e+04,0.15052e+04,0.10541e+04,0.13700e+04,0.18268e+04 /)
      kbo(:, 4,29,16) = (/ &
        & 0.18999e+04,0.14249e+04,0.98819e+03,0.12798e+04,0.17065e+04 /)
      kbo(:, 5,29,16) = (/ &
        & 0.17996e+04,0.13497e+04,0.92869e+03,0.11992e+04,0.15991e+04 /)
      kbo(:, 1,30,16) = (/ &
        & 0.22495e+04,0.16871e+04,0.12065e+04,0.15776e+04,0.21036e+04 /)
      kbo(:, 2,30,16) = (/ &
        & 0.21251e+04,0.15938e+04,0.11251e+04,0.14633e+04,0.19512e+04 /)
      kbo(:, 3,30,16) = (/ &
        & 0.20091e+04,0.15068e+04,0.10517e+04,0.13621e+04,0.18163e+04 /)
      kbo(:, 4,30,16) = (/ &
        & 0.19004e+04,0.14253e+04,0.98584e+03,0.12727e+04,0.16970e+04 /)
      kbo(:, 5,30,16) = (/ &
        & 0.17984e+04,0.13488e+04,0.92610e+03,0.11928e+04,0.15905e+04 /)
      kbo(:, 1,31,16) = (/ &
        & 0.22474e+04,0.16855e+04,0.12005e+04,0.15635e+04,0.20848e+04 /)
      kbo(:, 2,31,16) = (/ &
        & 0.21214e+04,0.15910e+04,0.11192e+04,0.14507e+04,0.19344e+04 /)
      kbo(:, 3,31,16) = (/ &
        & 0.20043e+04,0.15033e+04,0.10461e+04,0.13510e+04,0.18015e+04 /)
      kbo(:, 4,31,16) = (/ &
        & 0.18948e+04,0.14211e+04,0.98049e+03,0.12625e+04,0.16835e+04 /)
      kbo(:, 5,31,16) = (/ &
        & 0.17922e+04,0.13441e+04,0.92102e+03,0.11837e+04,0.15784e+04 /)
      kbo(:, 1,32,16) = (/ &
        & 0.22387e+04,0.16790e+04,0.11913e+04,0.15463e+04,0.20617e+04 /)
      kbo(:, 2,32,16) = (/ &
        & 0.21117e+04,0.15838e+04,0.11104e+04,0.14353e+04,0.19138e+04 /)
      kbo(:, 3,32,16) = (/ &
        & 0.19944e+04,0.14958e+04,0.10381e+04,0.13373e+04,0.17831e+04 /)
      kbo(:, 4,32,16) = (/ &
        & 0.18846e+04,0.14135e+04,0.97304e+03,0.12502e+04,0.16670e+04 /)
      kbo(:, 5,32,16) = (/ &
        & 0.17818e+04,0.13363e+04,0.91392e+03,0.11724e+04,0.15633e+04 /)
      kbo(:, 1,33,16) = (/ &
        & 0.22243e+04,0.16682e+04,0.11793e+04,0.15266e+04,0.20355e+04 /)
      kbo(:, 2,33,16) = (/ &
        & 0.20975e+04,0.15731e+04,0.10994e+04,0.14177e+04,0.18903e+04 /)
      kbo(:, 3,33,16) = (/ &
        & 0.19805e+04,0.14854e+04,0.10282e+04,0.13217e+04,0.17623e+04 /)
      kbo(:, 4,33,16) = (/ &
        & 0.18707e+04,0.14030e+04,0.96384e+03,0.12361e+04,0.16482e+04 /)
      kbo(:, 5,33,16) = (/ &
        & 0.17684e+04,0.13263e+04,0.90541e+03,0.11600e+04,0.15467e+04 /)
      kbo(:, 1,34,16) = (/ &
        & 0.22110e+04,0.16582e+04,0.11687e+04,0.15094e+04,0.20126e+04 /)
      kbo(:, 2,34,16) = (/ &
        & 0.20843e+04,0.15632e+04,0.10894e+04,0.14021e+04,0.18696e+04 /)
      kbo(:, 3,34,16) = (/ &
        & 0.19675e+04,0.14756e+04,0.10193e+04,0.13079e+04,0.17439e+04 /)
      kbo(:, 4,34,16) = (/ &
        & 0.18579e+04,0.13934e+04,0.95559e+03,0.12238e+04,0.16318e+04 /)
      kbo(:, 5,34,16) = (/ &
        & 0.17560e+04,0.13170e+04,0.89776e+03,0.11489e+04,0.15318e+04 /)
      kbo(:, 1,35,16) = (/ &
        & 0.22070e+04,0.16552e+04,0.11645e+04,0.15017e+04,0.20024e+04 /)
      kbo(:, 2,35,16) = (/ &
        & 0.20800e+04,0.15600e+04,0.10855e+04,0.13953e+04,0.18605e+04 /)
      kbo(:, 3,35,16) = (/ &
        & 0.19630e+04,0.14722e+04,0.10157e+04,0.13017e+04,0.17356e+04 /)
      kbo(:, 4,35,16) = (/ &
        & 0.18532e+04,0.13899e+04,0.95221e+03,0.12182e+04,0.16243e+04 /)
      kbo(:, 5,35,16) = (/ &
        & 0.17512e+04,0.13134e+04,0.89456e+03,0.11438e+04,0.15251e+04 /)
      kbo(:, 1,36,16) = (/ &
        & 0.22146e+04,0.16609e+04,0.11681e+04,0.15050e+04,0.20067e+04 /)
      kbo(:, 2,36,16) = (/ &
        & 0.20867e+04,0.15651e+04,0.10887e+04,0.13982e+04,0.18642e+04 /)
      kbo(:, 3,36,16) = (/ &
        & 0.19689e+04,0.14767e+04,0.10184e+04,0.13041e+04,0.17389e+04 /)
      kbo(:, 4,36,16) = (/ &
        & 0.18582e+04,0.13937e+04,0.95458e+03,0.12204e+04,0.16272e+04 /)
      kbo(:, 5,36,16) = (/ &
        & 0.17557e+04,0.13168e+04,0.89664e+03,0.11458e+04,0.15277e+04 /)
      kbo(:, 1,37,16) = (/ &
        & 0.22411e+04,0.16809e+04,0.11837e+04,0.15248e+04,0.20331e+04 /)
      kbo(:, 2,37,16) = (/ &
        & 0.21106e+04,0.15830e+04,0.11025e+04,0.14155e+04,0.18873e+04 /)
      kbo(:, 3,37,16) = (/ &
        & 0.19909e+04,0.14932e+04,0.10307e+04,0.13195e+04,0.17594e+04 /)
      kbo(:, 4,37,16) = (/ &
        & 0.18783e+04,0.14088e+04,0.96559e+03,0.12340e+04,0.16453e+04 /)
      kbo(:, 5,37,16) = (/ &
        & 0.17743e+04,0.13307e+04,0.90666e+03,0.11578e+04,0.15438e+04 /)
      kbo(:, 1,38,16) = (/ &
        & 0.22677e+04,0.17008e+04,0.11995e+04,0.15451e+04,0.20601e+04 /)
      kbo(:, 2,38,16) = (/ &
        & 0.21347e+04,0.16010e+04,0.11166e+04,0.14334e+04,0.19112e+04 /)
      kbo(:, 3,38,16) = (/ &
        & 0.20130e+04,0.15097e+04,0.10432e+04,0.13353e+04,0.17805e+04 /)
      kbo(:, 4,38,16) = (/ &
        & 0.18989e+04,0.14242e+04,0.97692e+03,0.12480e+04,0.16640e+04 /)
      kbo(:, 5,38,16) = (/ &
        & 0.17929e+04,0.13447e+04,0.91684e+03,0.11704e+04,0.15605e+04 /)
      kbo(:, 1,39,16) = (/ &
        & 0.22932e+04,0.17199e+04,0.12149e+04,0.15649e+04,0.20865e+04 /)
      kbo(:, 2,39,16) = (/ &
        & 0.21580e+04,0.16185e+04,0.11304e+04,0.14510e+04,0.19346e+04 /)
      kbo(:, 3,39,16) = (/ &
        & 0.20342e+04,0.15257e+04,0.10554e+04,0.13508e+04,0.18011e+04 /)
      kbo(:, 4,39,16) = (/ &
        & 0.19186e+04,0.14389e+04,0.98789e+03,0.12618e+04,0.16825e+04 /)
      kbo(:, 5,39,16) = (/ &
        & 0.18110e+04,0.13582e+04,0.92676e+03,0.11826e+04,0.15768e+04 /)
      kbo(:, 1,40,16) = (/ &
        & 0.23330e+04,0.17497e+04,0.12394e+04,0.15975e+04,0.21300e+04 /)
      kbo(:, 2,40,16) = (/ &
        & 0.21946e+04,0.16460e+04,0.11524e+04,0.14797e+04,0.19730e+04 /)
      kbo(:, 3,40,16) = (/ &
        & 0.20673e+04,0.15505e+04,0.10747e+04,0.13759e+04,0.18346e+04 /)
      kbo(:, 4,40,16) = (/ &
        & 0.19494e+04,0.14621e+04,0.10054e+04,0.12842e+04,0.17123e+04 /)
      kbo(:, 5,40,16) = (/ &
        & 0.18395e+04,0.13796e+04,0.94264e+03,0.12026e+04,0.16034e+04 /)
      kbo(:, 1,41,16) = (/ &
        & 0.23748e+04,0.17811e+04,0.12653e+04,0.16323e+04,0.21765e+04 /)
      kbo(:, 2,41,16) = (/ &
        & 0.22335e+04,0.16751e+04,0.11760e+04,0.15106e+04,0.20142e+04 /)
      kbo(:, 3,41,16) = (/ &
        & 0.21020e+04,0.15765e+04,0.10953e+04,0.14029e+04,0.18706e+04 /)
      kbo(:, 4,41,16) = (/ &
        & 0.19818e+04,0.14863e+04,0.10239e+04,0.13082e+04,0.17443e+04 /)
      kbo(:, 5,41,16) = (/ &
        & 0.18696e+04,0.14022e+04,0.95944e+03,0.12238e+04,0.16317e+04 /)
      kbo(:, 1,42,16) = (/ &
        & 0.24183e+04,0.18137e+04,0.12922e+04,0.16686e+04,0.22248e+04 /)
      kbo(:, 2,42,16) = (/ &
        & 0.22718e+04,0.17039e+04,0.11997e+04,0.15420e+04,0.20561e+04 /)
      kbo(:, 3,42,16) = (/ &
        & 0.21373e+04,0.16030e+04,0.11164e+04,0.14305e+04,0.19073e+04 /)
      kbo(:, 4,42,16) = (/ &
        & 0.20143e+04,0.15107e+04,0.10428e+04,0.13327e+04,0.17770e+04 /)
      kbo(:, 5,42,16) = (/ &
        & 0.18998e+04,0.14249e+04,0.97647e+03,0.12457e+04,0.16610e+04 /)
      kbo(:, 1,43,16) = (/ &
        & 0.24703e+04,0.18528e+04,0.13249e+04,0.17136e+04,0.22848e+04 /)
      kbo(:, 2,43,16) = (/ &
        & 0.23188e+04,0.17391e+04,0.12289e+04,0.15811e+04,0.21082e+04 /)
      kbo(:, 3,43,16) = (/ &
        & 0.21803e+04,0.16352e+04,0.11426e+04,0.14651e+04,0.19535e+04 /)
      kbo(:, 4,43,16) = (/ &
        & 0.20539e+04,0.15404e+04,0.10659e+04,0.13633e+04,0.18177e+04 /)
      kbo(:, 5,43,16) = (/ &
        & 0.19367e+04,0.14525e+04,0.99744e+03,0.12728e+04,0.16970e+04 /)
      kbo(:, 1,44,16) = (/ &
        & 0.25274e+04,0.18956e+04,0.13612e+04,0.17642e+04,0.23522e+04 /)
      kbo(:, 2,44,16) = (/ &
        & 0.23706e+04,0.17780e+04,0.12614e+04,0.16248e+04,0.21664e+04 /)
      kbo(:, 3,44,16) = (/ &
        & 0.22278e+04,0.16708e+04,0.11717e+04,0.15040e+04,0.20053e+04 /)
      kbo(:, 4,44,16) = (/ &
        & 0.20979e+04,0.15734e+04,0.10920e+04,0.13972e+04,0.18630e+04 /)
      kbo(:, 5,44,16) = (/ &
        & 0.19771e+04,0.14828e+04,0.10207e+04,0.13030e+04,0.17374e+04 /)
      kbo(:, 1,45,16) = (/ &
        & 0.25859e+04,0.19394e+04,0.13990e+04,0.18173e+04,0.24231e+04 /)
      kbo(:, 2,45,16) = (/ &
        & 0.24239e+04,0.18179e+04,0.12948e+04,0.16708e+04,0.22278e+04 /)
      kbo(:, 3,45,16) = (/ &
        & 0.22761e+04,0.17071e+04,0.12017e+04,0.15441e+04,0.20588e+04 /)
      kbo(:, 4,45,16) = (/ &
        & 0.21421e+04,0.16066e+04,0.11186e+04,0.14324e+04,0.19099e+04 /)
      kbo(:, 5,45,16) = (/ &
        & 0.20183e+04,0.15137e+04,0.10446e+04,0.13343e+04,0.17791e+04 /)
      kbo(:, 1,46,16) = (/ &
        & 0.26504e+04,0.19878e+04,0.14409e+04,0.18767e+04,0.25023e+04 /)
      kbo(:, 2,46,16) = (/ &
        & 0.24823e+04,0.18617e+04,0.13316e+04,0.17220e+04,0.22960e+04 /)
      kbo(:, 3,46,16) = (/ &
        & 0.23297e+04,0.17473e+04,0.12351e+04,0.15885e+04,0.21180e+04 /)
      kbo(:, 4,46,16) = (/ &
        & 0.21905e+04,0.16429e+04,0.11482e+04,0.14718e+04,0.19624e+04 /)
      kbo(:, 5,46,16) = (/ &
        & 0.20627e+04,0.15470e+04,0.10708e+04,0.13689e+04,0.18252e+04 /)
      kbo(:, 1,47,16) = (/ &
        & 0.27247e+04,0.20435e+04,0.14902e+04,0.19477e+04,0.25969e+04 /)
      kbo(:, 2,47,16) = (/ &
        & 0.25493e+04,0.19120e+04,0.13747e+04,0.17822e+04,0.23763e+04 /)
      kbo(:, 3,47,16) = (/ &
        & 0.23907e+04,0.17930e+04,0.12733e+04,0.16405e+04,0.21874e+04 /)
      kbo(:, 4,47,16) = (/ &
        & 0.22466e+04,0.16850e+04,0.11827e+04,0.15177e+04,0.20235e+04 /)
      kbo(:, 5,47,16) = (/ &
        & 0.21136e+04,0.15852e+04,0.11012e+04,0.14091e+04,0.18788e+04 /)
      kbo(:, 1,48,16) = (/ &
        & 0.28012e+04,0.21009e+04,0.15426e+04,0.20233e+04,0.26978e+04 /)
      kbo(:, 2,48,16) = (/ &
        & 0.26190e+04,0.19642e+04,0.14199e+04,0.18460e+04,0.24614e+04 /)
      kbo(:, 3,48,16) = (/ &
        & 0.24541e+04,0.18406e+04,0.13132e+04,0.16956e+04,0.22609e+04 /)
      kbo(:, 4,48,16) = (/ &
        & 0.23037e+04,0.17278e+04,0.12184e+04,0.15658e+04,0.20877e+04 /)
      kbo(:, 5,48,16) = (/ &
        & 0.21661e+04,0.16246e+04,0.11331e+04,0.14514e+04,0.19352e+04 /)
      kbo(:, 1,49,16) = (/ &
        & 0.28818e+04,0.21613e+04,0.15982e+04,0.21038e+04,0.28050e+04 /)
      kbo(:, 2,49,16) = (/ &
        & 0.26914e+04,0.20185e+04,0.14674e+04,0.19143e+04,0.25524e+04 /)
      kbo(:, 3,49,16) = (/ &
        & 0.25196e+04,0.18897e+04,0.13550e+04,0.17541e+04,0.23389e+04 /)
      kbo(:, 4,49,16) = (/ &
        & 0.23632e+04,0.17724e+04,0.12557e+04,0.16163e+04,0.21550e+04 /)
      kbo(:, 5,49,16) = (/ &
        & 0.22208e+04,0.16656e+04,0.11666e+04,0.14961e+04,0.19948e+04 /)
      kbo(:, 1,50,16) = (/ &
        & 0.29612e+04,0.22209e+04,0.16532e+04,0.21839e+04,0.29118e+04 /)
      kbo(:, 2,50,16) = (/ &
        & 0.27615e+04,0.20712e+04,0.15149e+04,0.19827e+04,0.26437e+04 /)
      kbo(:, 3,50,16) = (/ &
        & 0.25830e+04,0.19373e+04,0.13961e+04,0.18120e+04,0.24160e+04 /)
      kbo(:, 4,50,16) = (/ &
        & 0.24210e+04,0.18157e+04,0.12921e+04,0.16664e+04,0.22218e+04 /)
      kbo(:, 5,50,16) = (/ &
        & 0.22734e+04,0.17051e+04,0.11994e+04,0.15401e+04,0.20534e+04 /)
      kbo(:, 1,51,16) = (/ &
        & 0.30414e+04,0.22810e+04,0.17098e+04,0.22662e+04,0.30216e+04 /)
      kbo(:, 2,51,16) = (/ &
        & 0.28321e+04,0.21241e+04,0.15635e+04,0.20530e+04,0.27374e+04 /)
      kbo(:, 3,51,16) = (/ &
        & 0.26473e+04,0.19855e+04,0.14379e+04,0.18712e+04,0.24950e+04 /)
      kbo(:, 4,51,16) = (/ &
        & 0.24793e+04,0.18595e+04,0.13289e+04,0.17174e+04,0.22898e+04 /)
      kbo(:, 5,51,16) = (/ &
        & 0.23268e+04,0.17451e+04,0.12327e+04,0.15846e+04,0.21128e+04 /)
      kbo(:, 1,52,16) = (/ &
        & 0.31248e+04,0.23436e+04,0.17703e+04,0.23534e+04,0.31379e+04 /)
      kbo(:, 2,52,16) = (/ &
        & 0.29063e+04,0.21797e+04,0.16147e+04,0.21274e+04,0.28366e+04 /)
      kbo(:, 3,52,16) = (/ &
        & 0.27134e+04,0.20351e+04,0.14818e+04,0.19344e+04,0.25793e+04 /)
      kbo(:, 4,52,16) = (/ &
        & 0.25389e+04,0.19042e+04,0.13672e+04,0.17712e+04,0.23616e+04 /)
      kbo(:, 5,52,16) = (/ &
        & 0.23814e+04,0.17860e+04,0.12669e+04,0.16310e+04,0.21746e+04 /)
      kbo(:, 1,53,16) = (/ &
        & 0.32126e+04,0.24095e+04,0.18346e+04,0.24459e+04,0.32612e+04 /)
      kbo(:, 2,53,16) = (/ &
        & 0.29838e+04,0.22378e+04,0.16687e+04,0.22061e+04,0.29415e+04 /)
      kbo(:, 3,53,16) = (/ &
        & 0.27817e+04,0.20863e+04,0.15283e+04,0.20017e+04,0.26689e+04 /)
      kbo(:, 4,53,16) = (/ &
        & 0.26009e+04,0.19507e+04,0.14074e+04,0.18280e+04,0.24374e+04 /)
      kbo(:, 5,53,16) = (/ &
        & 0.24377e+04,0.18283e+04,0.13025e+04,0.16802e+04,0.22403e+04 /)
      kbo(:, 1,54,16) = (/ &
        & 0.32965e+04,0.24725e+04,0.18972e+04,0.25356e+04,0.33807e+04 /)
      kbo(:, 2,54,16) = (/ &
        & 0.30576e+04,0.22932e+04,0.17211e+04,0.22822e+04,0.30430e+04 /)
      kbo(:, 3,54,16) = (/ &
        & 0.28468e+04,0.21351e+04,0.15733e+04,0.20668e+04,0.27558e+04 /)
      kbo(:, 4,54,16) = (/ &
        & 0.26600e+04,0.19950e+04,0.14459e+04,0.18829e+04,0.25105e+04 /)
      kbo(:, 5,54,16) = (/ &
        & 0.24912e+04,0.18684e+04,0.13364e+04,0.17275e+04,0.23034e+04 /)
      kbo(:, 1,55,16) = (/ &
        & 0.33833e+04,0.25376e+04,0.19611e+04,0.26264e+04,0.35019e+04 /)
      kbo(:, 2,55,16) = (/ &
        & 0.31321e+04,0.23491e+04,0.17750e+04,0.23596e+04,0.31462e+04 /)
      kbo(:, 3,55,16) = (/ &
        & 0.29119e+04,0.21839e+04,0.16184e+04,0.21327e+04,0.28435e+04 /)
      kbo(:, 4,55,16) = (/ &
        & 0.27182e+04,0.20386e+04,0.14848e+04,0.19390e+04,0.25853e+04 /)
      kbo(:, 5,55,16) = (/ &
        & 0.25438e+04,0.19078e+04,0.13702e+04,0.17749e+04,0.23665e+04 /)
      kbo(:, 1,56,16) = (/ &
        & 0.34732e+04,0.26050e+04,0.20286e+04,0.27221e+04,0.36294e+04 /)
      kbo(:, 2,56,16) = (/ &
        & 0.32087e+04,0.24066e+04,0.18312e+04,0.24406e+04,0.32540e+04 /)
      kbo(:, 3,56,16) = (/ &
        & 0.29798e+04,0.22348e+04,0.16657e+04,0.22014e+04,0.29353e+04 /)
      kbo(:, 4,56,16) = (/ &
        & 0.27779e+04,0.20834e+04,0.15255e+04,0.19978e+04,0.26637e+04 /)
      kbo(:, 5,56,16) = (/ &
        & 0.25980e+04,0.19485e+04,0.14055e+04,0.18247e+04,0.24330e+04 /)
      kbo(:, 1,57,16) = (/ &
        & 0.35673e+04,0.26755e+04,0.21006e+04,0.28229e+04,0.37639e+04 /)
      kbo(:, 2,57,16) = (/ &
        & 0.32883e+04,0.24663e+04,0.18907e+04,0.25257e+04,0.33676e+04 /)
      kbo(:, 3,57,16) = (/ &
        & 0.30500e+04,0.22875e+04,0.17155e+04,0.22739e+04,0.30319e+04 /)
      kbo(:, 4,57,16) = (/ &
        & 0.28394e+04,0.21295e+04,0.15682e+04,0.20597e+04,0.27463e+04 /)
      kbo(:, 5,57,16) = (/ &
        & 0.26543e+04,0.19907e+04,0.14421e+04,0.18768e+04,0.25025e+04 /)
      kbo(:, 1,58,16) = (/ &
        & 0.36607e+04,0.27457e+04,0.21738e+04,0.29233e+04,0.38978e+04 /)
      kbo(:, 2,58,16) = (/ &
        & 0.33686e+04,0.25266e+04,0.19501e+04,0.26108e+04,0.34810e+04 /)
      kbo(:, 3,58,16) = (/ &
        & 0.31191e+04,0.23393e+04,0.17656e+04,0.23462e+04,0.31282e+04 /)
      kbo(:, 4,58,16) = (/ &
        & 0.29009e+04,0.21757e+04,0.16107e+04,0.21213e+04,0.28285e+04 /)
      kbo(:, 5,58,16) = (/ &
        & 0.27090e+04,0.20318e+04,0.14784e+04,0.19292e+04,0.25722e+04 /)
      kbo(:, 1,59,16) = (/ &
        & 0.36992e+04,0.27745e+04,0.22044e+04,0.29651e+04,0.39534e+04 /)
      kbo(:, 2,59,16) = (/ &
        & 0.34022e+04,0.25517e+04,0.19749e+04,0.26461e+04,0.35281e+04 /)
      kbo(:, 3,59,16) = (/ &
        & 0.31476e+04,0.23607e+04,0.17864e+04,0.23762e+04,0.31682e+04 /)
      kbo(:, 4,59,16) = (/ &
        & 0.29259e+04,0.21945e+04,0.16281e+04,0.21469e+04,0.28626e+04 /)
      kbo(:, 5,59,16) = (/ &
        & 0.27315e+04,0.20486e+04,0.14936e+04,0.19510e+04,0.26013e+04 /)

!     -----------------------------------------------------------------

      forrefo(:, 1) = (/ 0.553258e-03, 0.555486e-03, 0.601339e-03, 0.708280e-03 /)
      forrefo(:, 2) = (/ 0.158558e-02, 0.162957e-02, 0.204991e-02, 0.475881e-02 /)
      forrefo(:, 3) = (/ 0.772542e-02, 0.784562e-02, 0.111979e-01, 0.229016e-01 /)
      forrefo(:, 4) = (/ 0.255097e-01, 0.256272e-01, 0.270691e-01, 0.259505e-01 /)
      forrefo(:, 5) = (/ 0.323263e-01, 0.324495e-01, 0.305535e-01, 0.263993e-01 /)
      forrefo(:, 6) = (/ 0.346920e-01, 0.348255e-01, 0.323586e-01, 0.276357e-01 /)
      forrefo(:, 7) = (/ 0.366509e-01, 0.366412e-01, 0.344434e-01, 0.319223e-01 /)
      forrefo(:, 8) = (/ 0.378451e-01, 0.375341e-01, 0.374369e-01, 0.320334e-01 /)
      forrefo(:, 9) = (/ 0.407348e-01, 0.396203e-01, 0.393988e-01, 0.318343e-01 /)
      forrefo(:,10) = (/ 0.433035e-01, 0.426488e-01, 0.408085e-01, 0.332749e-01 /)
      forrefo(:,11) = (/ 0.428254e-01, 0.441151e-01, 0.408887e-01, 0.327077e-01 /)
      forrefo(:,12) = (/ 0.443226e-01, 0.446690e-01, 0.404676e-01, 0.350492e-01 /)
      forrefo(:,13) = (/ 0.466103e-01, 0.460809e-01, 0.401286e-01, 0.370427e-01 /)
      forrefo(:,14) = (/ 0.483928e-01, 0.477284e-01, 0.380684e-01, 0.387940e-01 /)
      forrefo(:,15) = (/ 0.506987e-01, 0.490016e-01, 0.467069e-01, 0.368998e-01 /)
      forrefo(:,16) = (/ 0.510836e-01, 0.522771e-01, 0.500130e-01, 0.483406e-01 /)

!     -----------------------------------------------------------------
!     The array SELFREFO contains the coefficient of the water vapor
!     self-continuum (including the energy term).  The first index
!     refers to temperature in 7.2 degree increments.  For instance,
!     JT = 1 refers to a temperature of 245.6, JT = 2 refers to 252.8,
!     etc.  The second index runs over the g-channel (1 to 16).

      selfrefo(:, 1) = (/ &
        &  0.160537e-01, 0.149038e-01, 0.138363e-01, 0.128452e-01, 0.119251e-01, &
        &  0.110709e-01, 0.102779e-01, 0.954175e-02, 0.885829e-02, 0.822379e-02 /)
      selfrefo(:, 2) = (/ &
        &  0.365753e-01, 0.342267e-01, 0.320288e-01, 0.299720e-01, 0.280474e-01, &
        &  0.262463e-01, 0.245609e-01, 0.229837e-01, 0.215078e-01, 0.201267e-01 /)
      selfrefo(:, 3) = (/ &
        &  0.127419e+00, 0.118553e+00, 0.110304e+00, 0.102629e+00, 0.954883e-01, &
        &  0.888442e-01, 0.826624e-01, 0.769107e-01, 0.715593e-01, 0.665802e-01 /)
      selfrefo(:, 4) = (/ &
        &  0.378687e+00, 0.348961e+00, 0.321568e+00, 0.296325e+00, 0.273064e+00, &
        &  0.251629e+00, 0.231876e+00, 0.213674e+00, 0.196901e+00, 0.181444e+00 /)
      selfrefo(:, 5) = (/ &
        &  0.472822e+00, 0.435018e+00, 0.400236e+00, 0.368236e+00, 0.338794e+00, &
        &  0.311706e+00, 0.286783e+00, 0.263854e+00, 0.242757e+00, 0.223348e+00 /)
      selfrefo(:, 6) = (/ &
        &  0.505620e+00, 0.465050e+00, 0.427736e+00, 0.393416e+00, 0.361849e+00, &
        &  0.332815e+00, 0.306111e+00, 0.281550e+00, 0.258959e+00, 0.238181e+00 /)
      selfrefo(:, 7) = (/ &
        &  0.530488e+00, 0.487993e+00, 0.448902e+00, 0.412943e+00, 0.379864e+00, &
        &  0.349434e+00, 0.321443e+00, 0.295694e+00, 0.272007e+00, 0.250218e+00 /)
      selfrefo(:, 8) = (/ &
        &  0.540222e+00, 0.497746e+00, 0.458610e+00, 0.422551e+00, 0.389327e+00, &
        &  0.358716e+00, 0.330511e+00, 0.304524e+00, 0.280580e+00, 0.258519e+00 /)
      selfrefo(:, 9) = (/ &
        &  0.565727e+00, 0.522899e+00, 0.483313e+00, 0.446724e+00, 0.412905e+00, &
        &  0.381646e+00, 0.352753e+00, 0.326048e+00, 0.301365e+00, 0.278550e+00 /)
      selfrefo(:,10) = (/ &
        &  0.610122e+00, 0.562337e+00, 0.518295e+00, 0.477702e+00, 0.440289e+00, &
        &  0.405806e+00, 0.374023e+00, 0.344730e+00, 0.317730e+00, 0.292846e+00 /)
      selfrefo(:,11) = (/ &
        &  0.645176e+00, 0.588957e+00, 0.537636e+00, 0.490788e+00, 0.448022e+00, &
        &  0.408982e+00, 0.373344e+00, 0.340812e+00, 0.311114e+00, 0.284004e+00 /)
      selfrefo(:,12) = (/ &
        &  0.651737e+00, 0.596547e+00, 0.546031e+00, 0.499792e+00, 0.457469e+00, &
        &  0.418730e+00, 0.383272e+00, 0.350816e+00, 0.321108e+00, 0.293916e+00 /)
      selfrefo(:,13) = (/ &
        &  0.661086e+00, 0.607954e+00, 0.559093e+00, 0.514159e+00, 0.472836e+00, &
        &  0.434834e+00, 0.399886e+00, 0.367747e+00, 0.338191e+00, 0.311011e+00 /)
      selfrefo(:,14) = (/ &
        &  0.692554e+00, 0.635574e+00, 0.583282e+00, 0.535293e+00, 0.491251e+00, &
        &  0.450834e+00, 0.413741e+00, 0.379701e+00, 0.348461e+00, 0.319791e+00 /)
      selfrefo(:,15) = (/ &
        &  0.714646e+00, 0.657179e+00, 0.604334e+00, 0.555737e+00, 0.511049e+00, &
        &  0.469954e+00, 0.432164e+00, 0.397412e+00, 0.365455e+00, 0.336068e+00 /)
      selfrefo(:,16) = (/ &
        &  0.782126e+00, 0.710682e+00, 0.645764e+00, 0.586776e+00, 0.533177e+00, &
        &  0.484473e+00, 0.440219e+00, 0.400007e+00, 0.363468e+00, 0.330266e+00 /)
     
      end subroutine sw_kgb17
