!     path:      $Source$
!     author:    $Author$
!     revision:  $Revision$
!     created:   $Date$

!----------------------------------------------------------------------------
! Copyright (c) 2002-2016, Atmospheric & Environmental Research, Inc. (AER)
! All rights reserved.
!
! Redistribution and use in source and binary forms, with or without
! modification, are permitted provided that the following conditions are met:
!  * Redistributions of source code must retain the above copyright
!    notice, this list of conditions and the following disclaimer.
!  * Redistributions in binary form must reproduce the above copyright
!    notice, this list of conditions and the following disclaimer in the
!    documentation and/or other materials provided with the distribution.
!  * Neither the name of Atmospheric & Environmental Research, Inc., nor
!    the names of its contributors may be used to endorse or promote products
!    derived from this software without specific prior written permission.
!
! THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
! AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
! IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
! ARE DISCLAIMED. IN NO EVENT SHALL ATMOSPHERIC & ENVIRONMENTAL RESEARCH, INC., 
! BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
! CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
! SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
! INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
! CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
! ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
! THE POSSIBILITY OF SUCH DAMAGE.
!                        (http://www.rtweb.aer.com/)                        
!----------------------------------------------------------------------------

! **************************************************************************
!      subroutine sw_kgbnn
! **************************************************************************
!  RRTM Shortwave Radiative Transfer Model
!  Atmospheric and Environmental Research, Inc., Cambridge, MA
!
!  Original by J.Delamere, Atmospheric & Environmental Research.
!  Reformatted for F90: JJMorcrette, ECMWF
!  Further F90 and GCM revisions:  MJIacono, AER, July 2002
!  Solar variability revisions:  MJIacono, AER, November 2015
!
!  This file contains 14 subroutines that include the 
!  absorption coefficients and other data for each of the 14 shortwave
!  spectral bands used in RRTM_SW.  Here, the data are defined for 16
!  g-points, or sub-intervals, per band.  These data are combined and
!  weighted using a mapping procedure in routine RRTMG_SW_INIT to reduce
!  the total number of g-points from 224 to 112 for use in the GCM.
! **************************************************************************
      subroutine sw_kgb16
! **************************************************************************

      !use parkind, only : im => kind , rb => kind  
      use rrsw_kg16, only : kao, kbo, selfrefo, forrefo, sfluxrefo, rayl, &
                            irradnceo, facbrghto, snsptdrko
      use rrsw_vsn, only: hvrkg, hnamkg

      implicit none
      save

      hvrkg = '$Revision$'

! Kurucz solar source function
      sfluxrefo(:) = (/ &
        &  1.92269    , 1.72844    , 1.64326    , 1.58451     &
        &, 1.44031    , 1.25108    , 1.02724    , 0.776759    &
        &, 0.534444   , 5.87755e-02, 4.86706e-02, 3.87989e-02 &
        &, 2.84532e-02, 1.82431e-02, 6.92320e-03, 9.70770e-04 /)

! Solar variability components: time-invariant baseline quiet sun irradiance
      irradnceo(:) = (/ &
        & 1.80482E+00, 1.71619E+00, 1.68994E+00, 1.58561E+00,&
        & 1.43214E+00, 1.24420E+00, 1.02231E+00, 7.68091E-01,&
        & 5.28826E-01, 5.82363E-02, 4.82582E-02, 3.84759E-02,&
        & 2.81846E-02, 1.80770E-02, 6.85363E-03, 9.61125E-04/)
! Solar variability components: facular brightening
      facbrghto(:) = (/ &
        & 5.90515E-04, 5.75575E-04, 5.51485E-04, 5.11499E-04,&
        & 4.59121E-04, 3.95691E-04, 3.23581E-04, 2.43651E-04,&
        & 1.66062E-04, 1.81173E-05, 1.50358E-05, 1.19376E-05,&
        & 8.78046E-06, 5.59093E-06, 2.08811E-06, 2.94021E-07/)
! Solar variability components: sunspot darkening
      snsptdrko(:) = (/ &
        &-2.00878E-04,-1.90918E-04,-1.88460E-04,-1.76835E-04,&
        &-1.59524E-04,-1.38415E-04,-1.13577E-04,-8.52281E-05,&
        &-5.86712E-05,-6.47215E-06,-5.37923E-06,-4.28842E-06,&
        &-3.14297E-06,-2.01052E-06,-7.61203E-07,-1.08060E-07/)

! Rayleigh extinction coefficient at v = 2925 cm-1.
      rayl = 2.91e-10

!     -----------------------------------------------------------------
!     The array KAO contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels> ~100mb, temperatures, and binary
!     species parameters (see taumol.f for definition).  The first 
!     index in the array, JS, runs from 1 to 9, and corresponds to 
!     different values of the binary species parameter.  For instance, 
!     JS=1 refers to dry air, JS = 2 corresponds to the paramter value 1/8, 
!     JS = 3 corresponds to the parameter value 2/8, etc.  The second index
!     in the array, JT, which runs from 1 to 5, corresponds to different
!     temperatures.  More specifically, JT = 3 means that the data are for
!     the reference temperature TREF for this  pressure level, JT = 2 refers
!     to TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and JT = 5
!     is for TREF+30.  The third index, JP, runs from 1 to 13 and refers
!     to the JPth reference pressure level (see taumol.f for these levels
!     in mb).  The fourth index, IG, goes from 1 to 16, and indicates
!     which g-interval the absorption coefficients are for.
!     -----------------------------------------------------------------

      kao(:, 1, 1, 1) = (/ &
        & 0.15349e-04,0.89162e-04,0.97706e-04,0.96973e-04,0.90703e-04, &
        & 0.80393e-04,0.67242e-04,0.50804e-04,0.23334e-04 /)
      kao(:, 2, 1, 1) = (/ &
        & 0.16138e-04,0.89235e-04,0.97696e-04,0.96116e-04,0.89625e-04, &
        & 0.79382e-04,0.66587e-04,0.50583e-04,0.24342e-04 /)
      kao(:, 3, 1, 1) = (/ &
        & 0.16801e-04,0.89390e-04,0.97492e-04,0.95146e-04,0.88483e-04, &
        & 0.78325e-04,0.65873e-04,0.50342e-04,0.25245e-04 /)
      kao(:, 4, 1, 1) = (/ &
        & 0.17584e-04,0.89321e-04,0.97141e-04,0.93952e-04,0.87141e-04, &
        & 0.77126e-04,0.65068e-04,0.49985e-04,0.26046e-04 /)
      kao(:, 5, 1, 1) = (/ &
        & 0.18258e-04,0.89204e-04,0.96602e-04,0.92773e-04,0.85832e-04, &
        & 0.76015e-04,0.64318e-04,0.49612e-04,0.26697e-04 /)
      kao(:, 1, 2, 1) = (/ &
        & 0.12783e-04,0.77013e-04,0.85056e-04,0.84160e-04,0.79021e-04, &
        & 0.70101e-04,0.58520e-04,0.44007e-04,0.19895e-04 /)
      kao(:, 2, 2, 1) = (/ &
        & 0.13452e-04,0.77084e-04,0.84929e-04,0.83386e-04,0.78122e-04, &
        & 0.69293e-04,0.57974e-04,0.43855e-04,0.20713e-04 /)
      kao(:, 3, 2, 1) = (/ &
        & 0.14066e-04,0.77185e-04,0.84612e-04,0.82498e-04,0.77177e-04, &
        & 0.68443e-04,0.57444e-04,0.43722e-04,0.21494e-04 /)
      kao(:, 4, 2, 1) = (/ &
        & 0.14678e-04,0.76996e-04,0.83962e-04,0.81526e-04,0.76049e-04, &
        & 0.67485e-04,0.56822e-04,0.43530e-04,0.22200e-04 /)
      kao(:, 5, 2, 1) = (/ &
        & 0.15258e-04,0.76788e-04,0.82821e-04,0.80320e-04,0.74845e-04, &
        & 0.66487e-04,0.56144e-04,0.43262e-04,0.22757e-04 /)
      kao(:, 1, 3, 1) = (/ &
        & 0.10474e-04,0.66144e-04,0.73703e-04,0.72701e-04,0.68638e-04, &
        & 0.60826e-04,0.50854e-04,0.37989e-04,0.17743e-04 /)
      kao(:, 2, 3, 1) = (/ &
        & 0.11024e-04,0.66096e-04,0.73447e-04,0.72029e-04,0.67858e-04, &
        & 0.60163e-04,0.50424e-04,0.37886e-04,0.18519e-04 /)
      kao(:, 3, 3, 1) = (/ &
        & 0.11534e-04,0.65974e-04,0.72795e-04,0.71229e-04,0.67005e-04, &
        & 0.59442e-04,0.49950e-04,0.37779e-04,0.19184e-04 /)
      kao(:, 4, 3, 1) = (/ &
        & 0.12091e-04,0.65752e-04,0.72003e-04,0.70357e-04,0.66129e-04, &
        & 0.58718e-04,0.49503e-04,0.37690e-04,0.19788e-04 /)
      kao(:, 5, 3, 1) = (/ &
        & 0.12560e-04,0.65678e-04,0.71013e-04,0.69266e-04,0.65076e-04, &
        & 0.57873e-04,0.48947e-04,0.37519e-04,0.20290e-04 /)
      kao(:, 1, 4, 1) = (/ &
        & 0.85236e-05,0.56692e-04,0.63625e-04,0.62567e-04,0.59412e-04, &
        & 0.52601e-04,0.43957e-04,0.32602e-04,0.16862e-04 /)
      kao(:, 2, 4, 1) = (/ &
        & 0.89886e-05,0.56512e-04,0.63288e-04,0.61902e-04,0.58733e-04, &
        & 0.52036e-04,0.43629e-04,0.32592e-04,0.17543e-04 /)
      kao(:, 3, 4, 1) = (/ &
        & 0.94085e-05,0.56287e-04,0.62588e-04,0.61197e-04,0.58020e-04, &
        & 0.51469e-04,0.43247e-04,0.32567e-04,0.18199e-04 /)
      kao(:, 4, 4, 1) = (/ &
        & 0.98830e-05,0.55998e-04,0.61716e-04,0.60485e-04,0.57250e-04, &
        & 0.50840e-04,0.42842e-04,0.32520e-04,0.18771e-04 /)
      kao(:, 5, 4, 1) = (/ &
        & 0.10278e-04,0.55929e-04,0.61011e-04,0.59745e-04,0.56462e-04, &
        & 0.50254e-04,0.42468e-04,0.32457e-04,0.19296e-04 /)
      kao(:, 1, 5, 1) = (/ &
        & 0.68852e-05,0.48282e-04,0.54761e-04,0.53543e-04,0.51345e-04, &
        & 0.45380e-04,0.37794e-04,0.27880e-04,0.14959e-04 /)
      kao(:, 2, 5, 1) = (/ &
        & 0.72830e-05,0.48206e-04,0.54379e-04,0.52923e-04,0.50723e-04, &
        & 0.44903e-04,0.37536e-04,0.27938e-04,0.15841e-04 /)
      kao(:, 3, 5, 1) = (/ &
        & 0.76436e-05,0.47928e-04,0.53597e-04,0.52299e-04,0.50061e-04, &
        & 0.44426e-04,0.37240e-04,0.27962e-04,0.16760e-04 /)
      kao(:, 4, 5, 1) = (/ &
        & 0.80055e-05,0.47625e-04,0.52896e-04,0.51678e-04,0.49302e-04, &
        & 0.43902e-04,0.36930e-04,0.27968e-04,0.17586e-04 /)
      kao(:, 5, 5, 1) = (/ &
        & 0.83555e-05,0.47486e-04,0.52258e-04,0.51112e-04,0.48444e-04, &
        & 0.43409e-04,0.36652e-04,0.27966e-04,0.18270e-04 /)
      kao(:, 1, 6, 1) = (/ &
        & 0.55363e-05,0.40995e-04,0.46991e-04,0.45840e-04,0.44200e-04, &
        & 0.38984e-04,0.32341e-04,0.23743e-04,0.12825e-04 /)
      kao(:, 2, 6, 1) = (/ &
        & 0.58741e-05,0.40851e-04,0.46490e-04,0.45277e-04,0.43651e-04, &
        & 0.38565e-04,0.32141e-04,0.23813e-04,0.13671e-04 /)
      kao(:, 3, 6, 1) = (/ &
        & 0.61821e-05,0.40643e-04,0.45850e-04,0.44728e-04,0.42924e-04, &
        & 0.38164e-04,0.31920e-04,0.23858e-04,0.14647e-04 /)
      kao(:, 4, 6, 1) = (/ &
        & 0.64614e-05,0.40329e-04,0.45202e-04,0.44163e-04,0.42054e-04, &
        & 0.37723e-04,0.31679e-04,0.23886e-04,0.15533e-04 /)
      kao(:, 5, 6, 1) = (/ &
        & 0.67675e-05,0.40137e-04,0.44578e-04,0.43574e-04,0.41267e-04, &
        & 0.37271e-04,0.31420e-04,0.23883e-04,0.16436e-04 /)
      kao(:, 1, 7, 1) = (/ &
        & 0.44217e-05,0.34626e-04,0.39970e-04,0.39080e-04,0.37744e-04, &
        & 0.33237e-04,0.27507e-04,0.20074e-04,0.11007e-04 /)
      kao(:, 2, 7, 1) = (/ &
        & 0.47104e-05,0.34494e-04,0.39592e-04,0.38568e-04,0.37283e-04, &
        & 0.32875e-04,0.27342e-04,0.20149e-04,0.11834e-04 /)
      kao(:, 3, 7, 1) = (/ &
        & 0.49764e-05,0.34300e-04,0.39007e-04,0.38074e-04,0.36415e-04, &
        & 0.32528e-04,0.27158e-04,0.20213e-04,0.12801e-04 /)
      kao(:, 4, 7, 1) = (/ &
        & 0.52135e-05,0.34067e-04,0.38449e-04,0.37591e-04,0.35661e-04, &
        & 0.32173e-04,0.26959e-04,0.20265e-04,0.13763e-04 /)
      kao(:, 5, 7, 1) = (/ &
        & 0.54275e-05,0.33832e-04,0.37875e-04,0.37057e-04,0.35065e-04, &
        & 0.31800e-04,0.26760e-04,0.20278e-04,0.14677e-04 /)
      kao(:, 1, 8, 1) = (/ &
        & 0.35317e-05,0.29115e-04,0.33824e-04,0.33370e-04,0.32237e-04, &
        & 0.28331e-04,0.23362e-04,0.16932e-04,0.96086e-05 /)
      kao(:, 2, 8, 1) = (/ &
        & 0.37854e-05,0.29084e-04,0.33632e-04,0.32929e-04,0.31805e-04, &
        & 0.28018e-04,0.23236e-04,0.17006e-04,0.10621e-04 /)
      kao(:, 3, 8, 1) = (/ &
        & 0.40127e-05,0.28935e-04,0.33190e-04,0.32483e-04,0.30936e-04, &
        & 0.27716e-04,0.23074e-04,0.17087e-04,0.11657e-04 /)
      kao(:, 4, 8, 1) = (/ &
        & 0.42184e-05,0.28732e-04,0.32711e-04,0.32042e-04,0.30351e-04, &
        & 0.27404e-04,0.22906e-04,0.17140e-04,0.12504e-04 /)
      kao(:, 5, 8, 1) = (/ &
        & 0.44040e-05,0.28488e-04,0.32207e-04,0.31581e-04,0.29852e-04, &
        & 0.27086e-04,0.22740e-04,0.17166e-04,0.13401e-04 /)
      kao(:, 1, 9, 1) = (/ &
        & 0.28004e-05,0.24421e-04,0.28507e-04,0.28270e-04,0.27415e-04, &
        & 0.24038e-04,0.19759e-04,0.14209e-04,0.88498e-05 /)
      kao(:, 2, 9, 1) = (/ &
        & 0.30342e-05,0.24385e-04,0.28391e-04,0.27999e-04,0.26969e-04, &
        & 0.23770e-04,0.19651e-04,0.14288e-04,0.10048e-04 /)
      kao(:, 3, 9, 1) = (/ &
        & 0.32304e-05,0.24304e-04,0.28136e-04,0.27602e-04,0.26246e-04, &
        & 0.23508e-04,0.19517e-04,0.14360e-04,0.11188e-04 /)
      kao(:, 4, 9, 1) = (/ &
        & 0.34049e-05,0.24160e-04,0.27731e-04,0.27211e-04,0.25756e-04, &
        & 0.23246e-04,0.19380e-04,0.14426e-04,0.12319e-04 /)
      kao(:, 5, 9, 1) = (/ &
        & 0.35648e-05,0.23940e-04,0.27283e-04,0.26806e-04,0.25320e-04, &
        & 0.22960e-04,0.19234e-04,0.14451e-04,0.13506e-04 /)
      kao(:, 1,10, 1) = (/ &
        & 0.22115e-05,0.20358e-04,0.23898e-04,0.23781e-04,0.23142e-04, &
        & 0.20260e-04,0.16593e-04,0.11876e-04,0.77665e-05 /)
      kao(:, 2,10, 1) = (/ &
        & 0.24264e-05,0.20362e-04,0.23820e-04,0.23569e-04,0.22708e-04, &
        & 0.20037e-04,0.16524e-04,0.11954e-04,0.90216e-05 /)
      kao(:, 3,10, 1) = (/ &
        & 0.26002e-05,0.20303e-04,0.23663e-04,0.23295e-04,0.22132e-04, &
        & 0.19806e-04,0.16414e-04,0.12011e-04,0.10379e-04 /)
      kao(:, 4,10, 1) = (/ &
        & 0.27486e-05,0.20198e-04,0.23357e-04,0.22943e-04,0.21707e-04, &
        & 0.19580e-04,0.16298e-04,0.12060e-04,0.11771e-04 /)
      kao(:, 5,10, 1) = (/ &
        & 0.28881e-05,0.20019e-04,0.22982e-04,0.22584e-04,0.21296e-04, &
        & 0.19341e-04,0.16164e-04,0.12088e-04,0.13279e-04 /)
      kao(:, 1,11, 1) = (/ &
        & 0.18320e-05,0.16927e-04,0.19968e-04,0.19856e-04,0.19352e-04, &
        & 0.16934e-04,0.13866e-04,0.99116e-05,0.67134e-05 /)
      kao(:, 2,11, 1) = (/ &
        & 0.20049e-05,0.16927e-04,0.19853e-04,0.19674e-04,0.18853e-04, &
        & 0.16739e-04,0.13797e-04,0.99757e-05,0.78968e-05 /)
      kao(:, 3,11, 1) = (/ &
        & 0.21502e-05,0.16866e-04,0.19704e-04,0.19448e-04,0.18441e-04, &
        & 0.16541e-04,0.13705e-04,0.10023e-04,0.91593e-05 /)
      kao(:, 4,11, 1) = (/ &
        & 0.22714e-05,0.16777e-04,0.19465e-04,0.19143e-04,0.18062e-04, &
        & 0.16347e-04,0.13601e-04,0.10057e-04,0.10536e-04 /)
      kao(:, 5,11, 1) = (/ &
        & 0.23867e-05,0.16634e-04,0.19123e-04,0.18829e-04,0.17732e-04, &
        & 0.16132e-04,0.13484e-04,0.10082e-04,0.12018e-04 /)
      kao(:, 1,12, 1) = (/ &
        & 0.15169e-05,0.14042e-04,0.16626e-04,0.16552e-04,0.16148e-04, &
        & 0.14121e-04,0.11557e-04,0.82558e-05,0.56116e-05 /)
      kao(:, 2,12, 1) = (/ &
        & 0.16576e-05,0.14051e-04,0.16515e-04,0.16389e-04,0.15651e-04, &
        & 0.13956e-04,0.11498e-04,0.83065e-05,0.66756e-05 /)
      kao(:, 3,12, 1) = (/ &
        & 0.17786e-05,0.13996e-04,0.16382e-04,0.16200e-04,0.15335e-04, &
        & 0.13791e-04,0.11414e-04,0.83396e-05,0.78609e-05 /)
      kao(:, 4,12, 1) = (/ &
        & 0.18784e-05,0.13920e-04,0.16173e-04,0.15944e-04,0.15016e-04, &
        & 0.13612e-04,0.11321e-04,0.83696e-05,0.90657e-05 /)
      kao(:, 5,12, 1) = (/ &
        & 0.19730e-05,0.13808e-04,0.15876e-04,0.15671e-04,0.14704e-04, &
        & 0.13425e-04,0.11218e-04,0.83846e-05,0.10342e-04 /)
      kao(:, 1,13, 1) = (/ &
        & 0.12548e-05,0.11622e-04,0.13817e-04,0.13765e-04,0.13366e-04, &
        & 0.11761e-04,0.96214e-05,0.68586e-05,0.46815e-05 /)
      kao(:, 2,13, 1) = (/ &
        & 0.13720e-05,0.11638e-04,0.13707e-04,0.13640e-04,0.13007e-04, &
        & 0.11624e-04,0.95672e-05,0.68978e-05,0.55831e-05 /)
      kao(:, 3,13, 1) = (/ &
        & 0.14716e-05,0.11595e-04,0.13603e-04,0.13476e-04,0.12728e-04, &
        & 0.11474e-04,0.94883e-05,0.69284e-05,0.65694e-05 /)
      kao(:, 4,13, 1) = (/ &
        & 0.15544e-05,0.11533e-04,0.13432e-04,0.13265e-04,0.12450e-04, &
        & 0.11320e-04,0.94054e-05,0.69510e-05,0.75699e-05 /)
      kao(:, 5,13, 1) = (/ &
        & 0.16324e-05,0.11450e-04,0.13177e-04,0.13030e-04,0.12193e-04, &
        & 0.11159e-04,0.93157e-05,0.69543e-05,0.86449e-05 /)
      kao(:, 1, 1, 2) = (/ &
        & 0.10905e-03,0.19084e-03,0.20069e-03,0.19832e-03,0.18610e-03, &
        & 0.17089e-03,0.14990e-03,0.11759e-03,0.64675e-04 /)
      kao(:, 2, 1, 2) = (/ &
        & 0.11105e-03,0.18952e-03,0.19885e-03,0.19823e-03,0.18675e-03, &
        & 0.17126e-03,0.15098e-03,0.11929e-03,0.67071e-04 /)
      kao(:, 3, 1, 2) = (/ &
        & 0.11276e-03,0.18853e-03,0.19769e-03,0.19892e-03,0.18804e-03, &
        & 0.17228e-03,0.15234e-03,0.12104e-03,0.69562e-04 /)
      kao(:, 4, 1, 2) = (/ &
        & 0.11331e-03,0.18716e-03,0.19673e-03,0.19862e-03,0.18922e-03, &
        & 0.17345e-03,0.15364e-03,0.12287e-03,0.72145e-04 /)
      kao(:, 5, 1, 2) = (/ &
        & 0.11374e-03,0.18626e-03,0.19656e-03,0.19857e-03,0.19062e-03, &
        & 0.17445e-03,0.15373e-03,0.12483e-03,0.74697e-04 /)
      kao(:, 1, 2, 2) = (/ &
        & 0.94458e-04,0.16650e-03,0.17483e-03,0.17491e-03,0.16501e-03, &
        & 0.15069e-03,0.13359e-03,0.10498e-03,0.55352e-04 /)
      kao(:, 2, 2, 2) = (/ &
        & 0.96121e-04,0.16557e-03,0.17383e-03,0.17514e-03,0.16597e-03, &
        & 0.15082e-03,0.13480e-03,0.10677e-03,0.57531e-04 /)
      kao(:, 3, 2, 2) = (/ &
        & 0.97581e-04,0.16494e-03,0.17349e-03,0.17480e-03,0.16726e-03, &
        & 0.15206e-03,0.13520e-03,0.10844e-03,0.59621e-04 /)
      kao(:, 4, 2, 2) = (/ &
        & 0.98152e-04,0.16427e-03,0.17323e-03,0.17471e-03,0.16812e-03, &
        & 0.15352e-03,0.13523e-03,0.11008e-03,0.61894e-04 /)
      kao(:, 5, 2, 2) = (/ &
        & 0.98081e-04,0.16346e-03,0.17334e-03,0.17481e-03,0.16845e-03, &
        & 0.15496e-03,0.13612e-03,0.11175e-03,0.64159e-04 /)
      kao(:, 1, 3, 2) = (/ &
        & 0.80988e-04,0.14444e-03,0.15236e-03,0.15355e-03,0.14515e-03, &
        & 0.13201e-03,0.11827e-03,0.92843e-04,0.47818e-04 /)
      kao(:, 2, 3, 2) = (/ &
        & 0.82627e-04,0.14399e-03,0.15198e-03,0.15308e-03,0.14622e-03, &
        & 0.13285e-03,0.11829e-03,0.94579e-04,0.49498e-04 /)
      kao(:, 3, 3, 2) = (/ &
        & 0.83666e-04,0.14365e-03,0.15183e-03,0.15300e-03,0.14704e-03, &
        & 0.13418e-03,0.11832e-03,0.96259e-04,0.51225e-04 /)
      kao(:, 4, 3, 2) = (/ &
        & 0.84164e-04,0.14362e-03,0.15205e-03,0.15285e-03,0.14764e-03, &
        & 0.13590e-03,0.11954e-03,0.97885e-04,0.52990e-04 /)
      kao(:, 5, 3, 2) = (/ &
        & 0.84014e-04,0.14269e-03,0.15214e-03,0.15331e-03,0.14865e-03, &
        & 0.13747e-03,0.12089e-03,0.99389e-04,0.54936e-04 /)
      kao(:, 1, 4, 2) = (/ &
        & 0.69055e-04,0.12498e-03,0.13260e-03,0.13427e-03,0.12748e-03, &
        & 0.11593e-03,0.10318e-03,0.81535e-04,0.43344e-04 /)
      kao(:, 2, 4, 2) = (/ &
        & 0.70374e-04,0.12479e-03,0.13217e-03,0.13387e-03,0.12823e-03, &
        & 0.11702e-03,0.10316e-03,0.83059e-04,0.44577e-04 /)
      kao(:, 3, 4, 2) = (/ &
        & 0.71321e-04,0.12483e-03,0.13205e-03,0.13371e-03,0.12866e-03, &
        & 0.11820e-03,0.10422e-03,0.84648e-04,0.45880e-04 /)
      kao(:, 4, 4, 2) = (/ &
        & 0.71712e-04,0.12475e-03,0.13249e-03,0.13379e-03,0.12934e-03, &
        & 0.11960e-03,0.10551e-03,0.86238e-04,0.47243e-04 /)
      kao(:, 5, 4, 2) = (/ &
        & 0.71917e-04,0.12433e-03,0.13275e-03,0.13434e-03,0.13049e-03, &
        & 0.12131e-03,0.10676e-03,0.87830e-04,0.48641e-04 /)
      kao(:, 1, 5, 2) = (/ &
        & 0.58527e-04,0.10840e-03,0.11507e-03,0.11730e-03,0.11099e-03, &
        & 0.10118e-03,0.89566e-04,0.71122e-04,0.43658e-04 /)
      kao(:, 2, 5, 2) = (/ &
        & 0.59798e-04,0.10799e-03,0.11447e-03,0.11692e-03,0.11189e-03, &
        & 0.10224e-03,0.90255e-04,0.72476e-04,0.44361e-04 /)
      kao(:, 3, 5, 2) = (/ &
        & 0.60601e-04,0.10799e-03,0.11464e-03,0.11677e-03,0.11225e-03, &
        & 0.10358e-03,0.91122e-04,0.73922e-04,0.45004e-04 /)
      kao(:, 4, 5, 2) = (/ &
        & 0.60971e-04,0.10798e-03,0.11486e-03,0.11681e-03,0.11304e-03, &
        & 0.10512e-03,0.91981e-04,0.75441e-04,0.45782e-04 /)
      kao(:, 5, 5, 2) = (/ &
        & 0.61166e-04,0.10769e-03,0.11529e-03,0.11740e-03,0.11428e-03, &
        & 0.10674e-03,0.93329e-04,0.76963e-04,0.46781e-04 /)
      kao(:, 1, 6, 2) = (/ &
        & 0.49298e-04,0.93665e-04,0.99302e-04,0.10166e-03,0.96125e-04, &
        & 0.87991e-04,0.77830e-04,0.61651e-04,0.45761e-04 /)
      kao(:, 2, 6, 2) = (/ &
        & 0.50498e-04,0.93479e-04,0.98966e-04,0.10139e-03,0.96705e-04, &
        & 0.89173e-04,0.78227e-04,0.62850e-04,0.46039e-04 /)
      kao(:, 3, 6, 2) = (/ &
        & 0.51269e-04,0.93203e-04,0.98973e-04,0.10127e-03,0.97298e-04, &
        & 0.90362e-04,0.78802e-04,0.64157e-04,0.46346e-04 /)
      kao(:, 4, 6, 2) = (/ &
        & 0.51588e-04,0.93137e-04,0.99162e-04,0.10129e-03,0.98592e-04, &
        & 0.91554e-04,0.79929e-04,0.65574e-04,0.46727e-04 /)
      kao(:, 5, 6, 2) = (/ &
        & 0.51597e-04,0.92792e-04,0.99458e-04,0.10170e-03,0.99448e-04, &
        & 0.92834e-04,0.81330e-04,0.66366e-04,0.47183e-04 /)
      kao(:, 1, 7, 2) = (/ &
        & 0.41246e-04,0.80496e-04,0.85316e-04,0.87435e-04,0.82542e-04, &
        & 0.75819e-04,0.67022e-04,0.53111e-04,0.48352e-04 /)
      kao(:, 2, 7, 2) = (/ &
        & 0.42332e-04,0.80236e-04,0.84984e-04,0.87173e-04,0.83192e-04, &
        & 0.76872e-04,0.67154e-04,0.54235e-04,0.49203e-04 /)
      kao(:, 3, 7, 2) = (/ &
        & 0.43069e-04,0.79969e-04,0.85117e-04,0.87191e-04,0.83963e-04, &
        & 0.78027e-04,0.67911e-04,0.55423e-04,0.50036e-04 /)
      kao(:, 4, 7, 2) = (/ &
        & 0.43347e-04,0.79762e-04,0.85176e-04,0.87282e-04,0.84970e-04, &
        & 0.78971e-04,0.69097e-04,0.56659e-04,0.50699e-04 /)
      kao(:, 5, 7, 2) = (/ &
        & 0.43381e-04,0.79473e-04,0.85320e-04,0.87550e-04,0.85526e-04, &
        & 0.80111e-04,0.70399e-04,0.56992e-04,0.51218e-04 /)
      kao(:, 1, 8, 2) = (/ &
        & 0.34402e-04,0.69256e-04,0.73264e-04,0.74907e-04,0.70733e-04, &
        & 0.65058e-04,0.57123e-04,0.45547e-04,0.49061e-04 /)
      kao(:, 2, 8, 2) = (/ &
        & 0.35394e-04,0.68938e-04,0.72891e-04,0.74693e-04,0.71198e-04, &
        & 0.66010e-04,0.57419e-04,0.46585e-04,0.51368e-04 /)
      kao(:, 3, 8, 2) = (/ &
        & 0.36086e-04,0.68637e-04,0.72875e-04,0.74679e-04,0.72090e-04, &
        & 0.66902e-04,0.58282e-04,0.47622e-04,0.51837e-04 /)
      kao(:, 4, 8, 2) = (/ &
        & 0.36445e-04,0.68326e-04,0.72869e-04,0.74856e-04,0.72765e-04, &
        & 0.67827e-04,0.59362e-04,0.48483e-04,0.52297e-04 /)
      kao(:, 5, 8, 2) = (/ &
        & 0.36483e-04,0.68010e-04,0.72961e-04,0.75096e-04,0.73241e-04, &
        & 0.68587e-04,0.60512e-04,0.48784e-04,0.53745e-04 /)
      kao(:, 1, 9, 2) = (/ &
        & 0.28433e-04,0.59232e-04,0.62701e-04,0.63901e-04,0.60103e-04, &
        & 0.55141e-04,0.48531e-04,0.38847e-04,0.54662e-04 /)
      kao(:, 2, 9, 2) = (/ &
        & 0.29405e-04,0.58918e-04,0.62216e-04,0.63604e-04,0.60633e-04, &
        & 0.55830e-04,0.48918e-04,0.39795e-04,0.56459e-04 /)
      kao(:, 3, 9, 2) = (/ &
        & 0.30040e-04,0.58597e-04,0.61986e-04,0.63627e-04,0.61357e-04, &
        & 0.56779e-04,0.49706e-04,0.40729e-04,0.58698e-04 /)
      kao(:, 4, 9, 2) = (/ &
        & 0.30412e-04,0.58268e-04,0.61940e-04,0.63690e-04,0.61916e-04, &
        & 0.57700e-04,0.50677e-04,0.41137e-04,0.60426e-04 /)
      kao(:, 5, 9, 2) = (/ &
        & 0.30517e-04,0.57913e-04,0.61982e-04,0.63808e-04,0.62307e-04, &
        & 0.58353e-04,0.51602e-04,0.41668e-04,0.61933e-04 /)
      kao(:, 1,10, 2) = (/ &
        & 0.23291e-04,0.50308e-04,0.53243e-04,0.54258e-04,0.50787e-04, &
        & 0.46509e-04,0.41036e-04,0.32969e-04,0.63749e-04 /)
      kao(:, 2,10, 2) = (/ &
        & 0.24304e-04,0.50027e-04,0.52858e-04,0.54035e-04,0.51457e-04, &
        & 0.47117e-04,0.41427e-04,0.33795e-04,0.67891e-04 /)
      kao(:, 3,10, 2) = (/ &
        & 0.24884e-04,0.49658e-04,0.52484e-04,0.53877e-04,0.52001e-04, &
        & 0.47908e-04,0.42080e-04,0.34652e-04,0.71374e-04 /)
      kao(:, 4,10, 2) = (/ &
        & 0.25245e-04,0.49329e-04,0.52369e-04,0.53861e-04,0.52353e-04, &
        & 0.48763e-04,0.42918e-04,0.34903e-04,0.73983e-04 /)
      kao(:, 5,10, 2) = (/ &
        & 0.25399e-04,0.49019e-04,0.52344e-04,0.53920e-04,0.52702e-04, &
        & 0.49354e-04,0.43795e-04,0.35336e-04,0.76874e-04 /)
      kao(:, 1,11, 2) = (/ &
        & 0.19464e-04,0.42428e-04,0.44774e-04,0.45764e-04,0.43065e-04, &
        & 0.39257e-04,0.34681e-04,0.28149e-04,0.56538e-04 /)
      kao(:, 2,11, 2) = (/ &
        & 0.20274e-04,0.42118e-04,0.44484e-04,0.45525e-04,0.43594e-04, &
        & 0.39908e-04,0.35109e-04,0.28880e-04,0.61143e-04 /)
      kao(:, 3,11, 2) = (/ &
        & 0.20723e-04,0.41781e-04,0.44183e-04,0.45345e-04,0.43968e-04, &
        & 0.40542e-04,0.35722e-04,0.29427e-04,0.66428e-04 /)
      kao(:, 4,11, 2) = (/ &
        & 0.20986e-04,0.41469e-04,0.44005e-04,0.45299e-04,0.44240e-04, &
        & 0.41204e-04,0.36501e-04,0.29565e-04,0.70536e-04 /)
      kao(:, 5,11, 2) = (/ &
        & 0.21088e-04,0.41122e-04,0.44008e-04,0.45344e-04,0.44427e-04, &
        & 0.41695e-04,0.37345e-04,0.29974e-04,0.74164e-04 /)
      kao(:, 1,12, 2) = (/ &
        & 0.16205e-04,0.35661e-04,0.37585e-04,0.38332e-04,0.36196e-04, &
        & 0.33054e-04,0.29216e-04,0.23917e-04,0.49111e-04 /)
      kao(:, 2,12, 2) = (/ &
        & 0.16873e-04,0.35314e-04,0.37290e-04,0.38165e-04,0.36667e-04, &
        & 0.33618e-04,0.29598e-04,0.24536e-04,0.53408e-04 /)
      kao(:, 3,12, 2) = (/ &
        & 0.17216e-04,0.35012e-04,0.37013e-04,0.37971e-04,0.36937e-04, &
        & 0.34200e-04,0.30188e-04,0.24727e-04,0.56692e-04 /)
      kao(:, 4,12, 2) = (/ &
        & 0.17409e-04,0.34711e-04,0.36851e-04,0.37885e-04,0.37053e-04, &
        & 0.34609e-04,0.30881e-04,0.24937e-04,0.60809e-04 /)
      kao(:, 5,12, 2) = (/ &
        & 0.17480e-04,0.34362e-04,0.36830e-04,0.37891e-04,0.37213e-04, &
        & 0.35045e-04,0.31524e-04,0.25269e-04,0.65163e-04 /)
      kao(:, 1,13, 2) = (/ &
        & 0.13457e-04,0.29884e-04,0.31446e-04,0.32052e-04,0.30374e-04, &
        & 0.27733e-04,0.24511e-04,0.20198e-04,0.41009e-04 /)
      kao(:, 2,13, 2) = (/ &
        & 0.14007e-04,0.29560e-04,0.31187e-04,0.31882e-04,0.30716e-04, &
        & 0.28181e-04,0.24877e-04,0.20737e-04,0.44661e-04 /)
      kao(:, 3,13, 2) = (/ &
        & 0.14280e-04,0.29273e-04,0.30932e-04,0.31685e-04,0.30856e-04, &
        & 0.28687e-04,0.25310e-04,0.20664e-04,0.47397e-04 /)
      kao(:, 4,13, 2) = (/ &
        & 0.14434e-04,0.28982e-04,0.30751e-04,0.31601e-04,0.30957e-04, &
        & 0.28945e-04,0.25864e-04,0.20868e-04,0.50575e-04 /)
      kao(:, 5,13, 2) = (/ &
        & 0.14483e-04,0.28660e-04,0.30711e-04,0.31533e-04,0.31075e-04, &
        & 0.29320e-04,0.26408e-04,0.21257e-04,0.54097e-04 /)
      kao(:, 1, 1, 3) = (/ &
        & 0.22536e-03,0.32037e-03,0.33781e-03,0.34273e-03,0.33729e-03, &
        & 0.32075e-03,0.29153e-03,0.24856e-03,0.16410e-03 /)
      kao(:, 2, 1, 3) = (/ &
        & 0.22342e-03,0.32281e-03,0.34293e-03,0.34673e-03,0.34167e-03, &
        & 0.32688e-03,0.29787e-03,0.25566e-03,0.17029e-03 /)
      kao(:, 3, 1, 3) = (/ &
        & 0.22157e-03,0.32559e-03,0.34865e-03,0.35164e-03,0.34805e-03, &
        & 0.33353e-03,0.30505e-03,0.26380e-03,0.17749e-03 /)
      kao(:, 4, 1, 3) = (/ &
        & 0.21986e-03,0.32894e-03,0.35375e-03,0.35845e-03,0.35514e-03, &
        & 0.33992e-03,0.31266e-03,0.27259e-03,0.18209e-03 /)
      kao(:, 5, 1, 3) = (/ &
        & 0.21815e-03,0.33282e-03,0.35982e-03,0.36699e-03,0.36319e-03, &
        & 0.34849e-03,0.32265e-03,0.28174e-03,0.18630e-03 /)
      kao(:, 1, 2, 3) = (/ &
        & 0.19541e-03,0.28383e-03,0.30057e-03,0.30208e-03,0.29811e-03, &
        & 0.28614e-03,0.25813e-03,0.22172e-03,0.14533e-03 /)
      kao(:, 2, 2, 3) = (/ &
        & 0.19410e-03,0.28606e-03,0.30502e-03,0.30638e-03,0.30342e-03, &
        & 0.29123e-03,0.26438e-03,0.22759e-03,0.15063e-03 /)
      kao(:, 3, 2, 3) = (/ &
        & 0.19280e-03,0.28892e-03,0.31031e-03,0.31345e-03,0.30930e-03, &
        & 0.29708e-03,0.27075e-03,0.23476e-03,0.15387e-03 /)
      kao(:, 4, 2, 3) = (/ &
        & 0.19169e-03,0.29226e-03,0.31596e-03,0.32060e-03,0.31687e-03, &
        & 0.30282e-03,0.27961e-03,0.24147e-03,0.15653e-03 /)
      kao(:, 5, 2, 3) = (/ &
        & 0.19047e-03,0.29594e-03,0.32186e-03,0.32831e-03,0.32510e-03, &
        & 0.31022e-03,0.28786e-03,0.24847e-03,0.16195e-03 /)
      kao(:, 1, 3, 3) = (/ &
        & 0.16871e-03,0.24969e-03,0.26468e-03,0.26465e-03,0.26214e-03, &
        & 0.25247e-03,0.22732e-03,0.19530e-03,0.12777e-03 /)
      kao(:, 2, 3, 3) = (/ &
        & 0.16793e-03,0.25161e-03,0.26876e-03,0.26973e-03,0.26695e-03, &
        & 0.25688e-03,0.23244e-03,0.20054e-03,0.12972e-03 /)
      kao(:, 3, 3, 3) = (/ &
        & 0.16733e-03,0.25378e-03,0.27385e-03,0.27612e-03,0.27305e-03, &
        & 0.26119e-03,0.23922e-03,0.20542e-03,0.13061e-03 /)
      kao(:, 4, 3, 3) = (/ &
        & 0.16706e-03,0.25676e-03,0.27970e-03,0.28379e-03,0.28013e-03, &
        & 0.26708e-03,0.24668e-03,0.21081e-03,0.13394e-03 /)
      kao(:, 5, 3, 3) = (/ &
        & 0.16637e-03,0.26037e-03,0.28504e-03,0.29050e-03,0.28611e-03, &
        & 0.27355e-03,0.25260e-03,0.21670e-03,0.13844e-03 /)
      kao(:, 1, 4, 3) = (/ &
        & 0.14579e-03,0.21908e-03,0.23187e-03,0.23162e-03,0.22921e-03, &
        & 0.22070e-03,0.19997e-03,0.17094e-03,0.11198e-03 /)
      kao(:, 2, 4, 3) = (/ &
        & 0.14542e-03,0.22095e-03,0.23576e-03,0.23659e-03,0.23393e-03, &
        & 0.22421e-03,0.20413e-03,0.17485e-03,0.11080e-03 /)
      kao(:, 3, 4, 3) = (/ &
        & 0.14519e-03,0.22277e-03,0.24039e-03,0.24264e-03,0.23941e-03, &
        & 0.22826e-03,0.20957e-03,0.17862e-03,0.11236e-03 /)
      kao(:, 4, 4, 3) = (/ &
        & 0.14504e-03,0.22526e-03,0.24523e-03,0.24877e-03,0.24473e-03, &
        & 0.23381e-03,0.21512e-03,0.18339e-03,0.11577e-03 /)
      kao(:, 5, 4, 3) = (/ &
        & 0.14497e-03,0.22869e-03,0.25070e-03,0.25513e-03,0.25076e-03, &
        & 0.23990e-03,0.22117e-03,0.18804e-03,0.11947e-03 /)
      kao(:, 1, 5, 3) = (/ &
        & 0.12609e-03,0.19125e-03,0.20302e-03,0.20235e-03,0.20038e-03, &
        & 0.19210e-03,0.17493e-03,0.14918e-03,0.95914e-04 /)
      kao(:, 2, 5, 3) = (/ &
        & 0.12575e-03,0.19304e-03,0.20668e-03,0.20708e-03,0.20395e-03, &
        & 0.19513e-03,0.17862e-03,0.15191e-03,0.95952e-04 /)
      kao(:, 3, 5, 3) = (/ &
        & 0.12572e-03,0.19504e-03,0.21070e-03,0.21227e-03,0.20862e-03, &
        & 0.19877e-03,0.18323e-03,0.15540e-03,0.98040e-04 /)
      kao(:, 4, 5, 3) = (/ &
        & 0.12578e-03,0.19736e-03,0.21498e-03,0.21770e-03,0.21305e-03, &
        & 0.20380e-03,0.18766e-03,0.15949e-03,0.10020e-03 /)
      kao(:, 5, 5, 3) = (/ &
        & 0.12588e-03,0.20051e-03,0.21971e-03,0.22313e-03,0.21848e-03, &
        & 0.20915e-03,0.19284e-03,0.16321e-03,0.10267e-03 /)
      kao(:, 1, 6, 3) = (/ &
        & 0.10863e-03,0.16576e-03,0.17695e-03,0.17678e-03,0.17469e-03, &
        & 0.16678e-03,0.15163e-03,0.12940e-03,0.89550e-04 /)
      kao(:, 2, 6, 3) = (/ &
        & 0.10863e-03,0.16706e-03,0.18030e-03,0.18081e-03,0.17775e-03, &
        & 0.16938e-03,0.15534e-03,0.13148e-03,0.89670e-04 /)
      kao(:, 3, 6, 3) = (/ &
        & 0.10855e-03,0.16916e-03,0.18384e-03,0.18538e-03,0.18134e-03, &
        & 0.17272e-03,0.15912e-03,0.13459e-03,0.90520e-04 /)
      kao(:, 4, 6, 3) = (/ &
        & 0.10855e-03,0.17152e-03,0.18761e-03,0.18997e-03,0.18510e-03, &
        & 0.17711e-03,0.16286e-03,0.13757e-03,0.91792e-04 /)
      kao(:, 5, 6, 3) = (/ &
        & 0.10853e-03,0.17415e-03,0.19152e-03,0.19450e-03,0.18955e-03, &
        & 0.18160e-03,0.16658e-03,0.14151e-03,0.94030e-04 /)
      kao(:, 1, 7, 3) = (/ &
        & 0.92930e-04,0.14283e-03,0.15332e-03,0.15365e-03,0.15192e-03, &
        & 0.14476e-03,0.13092e-03,0.11095e-03,0.91877e-04 /)
      kao(:, 2, 7, 3) = (/ &
        & 0.92984e-04,0.14401e-03,0.15614e-03,0.15721e-03,0.15413e-03, &
        & 0.14688e-03,0.13443e-03,0.11315e-03,0.90405e-04 /)
      kao(:, 3, 7, 3) = (/ &
        & 0.92945e-04,0.14573e-03,0.15905e-03,0.16110e-03,0.15737e-03, &
        & 0.14983e-03,0.13738e-03,0.11591e-03,0.89977e-04 /)
      kao(:, 4, 7, 3) = (/ &
        & 0.93035e-04,0.14787e-03,0.16239e-03,0.16472e-03,0.16084e-03, &
        & 0.15371e-03,0.14051e-03,0.11827e-03,0.90955e-04 /)
      kao(:, 5, 7, 3) = (/ &
        & 0.92985e-04,0.15023e-03,0.16593e-03,0.16877e-03,0.16496e-03, &
        & 0.15743e-03,0.14348e-03,0.12221e-03,0.92269e-04 /)
      kao(:, 1, 8, 3) = (/ &
        & 0.79600e-04,0.12290e-03,0.13269e-03,0.13322e-03,0.13145e-03, &
        & 0.12540e-03,0.11354e-03,0.94559e-04,0.10796e-03 /)
      kao(:, 2, 8, 3) = (/ &
        & 0.79683e-04,0.12390e-03,0.13495e-03,0.13633e-03,0.13351e-03, &
        & 0.12708e-03,0.11620e-03,0.96898e-04,0.10854e-03 /)
      kao(:, 3, 8, 3) = (/ &
        & 0.79630e-04,0.12537e-03,0.13745e-03,0.13937e-03,0.13626e-03, &
        & 0.12970e-03,0.11867e-03,0.99068e-04,0.10974e-03 /)
      kao(:, 4, 8, 3) = (/ &
        & 0.79625e-04,0.12719e-03,0.14027e-03,0.14234e-03,0.13941e-03, &
        & 0.13283e-03,0.12113e-03,0.10155e-03,0.11075e-03 /)
      kao(:, 5, 8, 3) = (/ &
        & 0.79589e-04,0.12914e-03,0.14322e-03,0.14575e-03,0.14305e-03, &
        & 0.13597e-03,0.12361e-03,0.10505e-03,0.11038e-03 /)
      kao(:, 1, 9, 3) = (/ &
        & 0.67917e-04,0.10525e-03,0.11421e-03,0.11510e-03,0.11341e-03, &
        & 0.10850e-03,0.97945e-04,0.80197e-04,0.13259e-03 /)
      kao(:, 2, 9, 3) = (/ &
        & 0.67928e-04,0.10625e-03,0.11606e-03,0.11762e-03,0.11532e-03, &
        & 0.11035e-03,0.10017e-03,0.82394e-04,0.13427e-03 /)
      kao(:, 3, 9, 3) = (/ &
        & 0.67856e-04,0.10744e-03,0.11824e-03,0.11998e-03,0.11756e-03, &
        & 0.11235e-03,0.10203e-03,0.84408e-04,0.13461e-03 /)
      kao(:, 4, 9, 3) = (/ &
        & 0.67768e-04,0.10890e-03,0.12070e-03,0.12262e-03,0.12012e-03, &
        & 0.11456e-03,0.10420e-03,0.86916e-04,0.13504e-03 /)
      kao(:, 5, 9, 3) = (/ &
        & 0.67707e-04,0.11054e-03,0.12323e-03,0.12567e-03,0.12318e-03, &
        & 0.11694e-03,0.10644e-03,0.89648e-04,0.13829e-03 /)
      kao(:, 1,10, 3) = (/ &
        & 0.57658e-04,0.89812e-04,0.97774e-04,0.98825e-04,0.97412e-04, &
        & 0.93433e-04,0.84119e-04,0.68026e-04,0.20137e-03 /)
      kao(:, 2,10, 3) = (/ &
        & 0.57461e-04,0.90575e-04,0.99228e-04,0.10076e-03,0.98930e-04, &
        & 0.94984e-04,0.86081e-04,0.70085e-04,0.20178e-03 /)
      kao(:, 3,10, 3) = (/ &
        & 0.57397e-04,0.91666e-04,0.10122e-03,0.10281e-03,0.10088e-03, &
        & 0.96688e-04,0.87695e-04,0.72010e-04,0.20052e-03 /)
      kao(:, 4,10, 3) = (/ &
        & 0.57291e-04,0.92869e-04,0.10334e-03,0.10517e-03,0.10317e-03, &
        & 0.98293e-04,0.89394e-04,0.74251e-04,0.20103e-03 /)
      kao(:, 5,10, 3) = (/ &
        & 0.57126e-04,0.94072e-04,0.10545e-03,0.10789e-03,0.10579e-03, &
        & 0.10034e-03,0.91420e-04,0.76761e-04,0.20035e-03 /)
      kao(:, 1,11, 3) = (/ &
        & 0.48600e-04,0.76535e-04,0.83721e-04,0.84782e-04,0.83379e-04, &
        & 0.80481e-04,0.72441e-04,0.58503e-04,0.20926e-03 /)
      kao(:, 2,11, 3) = (/ &
        & 0.48356e-04,0.77272e-04,0.85067e-04,0.86588e-04,0.84928e-04, &
        & 0.81803e-04,0.74015e-04,0.60222e-04,0.21110e-03 /)
      kao(:, 3,11, 3) = (/ &
        & 0.48180e-04,0.78198e-04,0.86939e-04,0.88416e-04,0.86712e-04, &
        & 0.83176e-04,0.75535e-04,0.61973e-04,0.20823e-03 /)
      kao(:, 4,11, 3) = (/ &
        & 0.48042e-04,0.79160e-04,0.88776e-04,0.90704e-04,0.88934e-04, &
        & 0.84522e-04,0.76983e-04,0.64264e-04,0.20745e-03 /)
      kao(:, 5,11, 3) = (/ &
        & 0.47901e-04,0.80171e-04,0.90395e-04,0.92950e-04,0.91253e-04, &
        & 0.86364e-04,0.78675e-04,0.66159e-04,0.20642e-03 /)
      kao(:, 1,12, 3) = (/ &
        & 0.40769e-04,0.64775e-04,0.71240e-04,0.72409e-04,0.71085e-04, &
        & 0.68679e-04,0.61925e-04,0.50009e-04,0.19056e-03 /)
      kao(:, 2,12, 3) = (/ &
        & 0.40486e-04,0.65479e-04,0.72574e-04,0.73906e-04,0.72438e-04, &
        & 0.69693e-04,0.63286e-04,0.51717e-04,0.19000e-03 /)
      kao(:, 3,12, 3) = (/ &
        & 0.40313e-04,0.66212e-04,0.74137e-04,0.75686e-04,0.74201e-04, &
        & 0.70781e-04,0.64554e-04,0.53372e-04,0.19242e-03 /)
      kao(:, 4,12, 3) = (/ &
        & 0.40107e-04,0.66938e-04,0.75524e-04,0.77664e-04,0.76142e-04, &
        & 0.72280e-04,0.65894e-04,0.55174e-04,0.19382e-03 /)
      kao(:, 5,12, 3) = (/ &
        & 0.39910e-04,0.67782e-04,0.76780e-04,0.79463e-04,0.78210e-04, &
        & 0.73902e-04,0.67292e-04,0.56789e-04,0.19106e-03 /)
      kao(:, 1,13, 3) = (/ &
        & 0.34103e-04,0.54622e-04,0.60315e-04,0.61417e-04,0.60332e-04, &
        & 0.58110e-04,0.52537e-04,0.42612e-04,0.15955e-03 /)
      kao(:, 2,13, 3) = (/ &
        & 0.33853e-04,0.55148e-04,0.61492e-04,0.62745e-04,0.61577e-04, &
        & 0.59061e-04,0.53702e-04,0.43873e-04,0.15892e-03 /)
      kao(:, 3,13, 3) = (/ &
        & 0.33647e-04,0.55699e-04,0.62687e-04,0.64355e-04,0.63160e-04, &
        & 0.60072e-04,0.54954e-04,0.45643e-04,0.16047e-03 /)
      kao(:, 4,13, 3) = (/ &
        & 0.33430e-04,0.56291e-04,0.63770e-04,0.65844e-04,0.64844e-04, &
        & 0.61457e-04,0.56064e-04,0.47101e-04,0.16125e-03 /)
      kao(:, 5,13, 3) = (/ &
        & 0.33186e-04,0.56947e-04,0.64747e-04,0.67352e-04,0.66508e-04, &
        & 0.62903e-04,0.57307e-04,0.48379e-04,0.16021e-03 /)
      kao(:, 1, 1, 4) = (/ &
        & 0.36602e-03,0.52858e-03,0.59251e-03,0.61027e-03,0.60893e-03, &
        & 0.58987e-03,0.55560e-03,0.49855e-03,0.38105e-03 /)
      kao(:, 2, 1, 4) = (/ &
        & 0.36935e-03,0.53570e-03,0.60138e-03,0.62341e-03,0.62297e-03, &
        & 0.60228e-03,0.56872e-03,0.51035e-03,0.39106e-03 /)
      kao(:, 3, 1, 4) = (/ &
        & 0.37348e-03,0.54590e-03,0.61238e-03,0.63855e-03,0.63820e-03, &
        & 0.61734e-03,0.58475e-03,0.52206e-03,0.40317e-03 /)
      kao(:, 4, 1, 4) = (/ &
        & 0.37665e-03,0.55373e-03,0.62261e-03,0.65120e-03,0.65250e-03, &
        & 0.63373e-03,0.59840e-03,0.53517e-03,0.41639e-03 /)
      kao(:, 5, 1, 4) = (/ &
        & 0.38076e-03,0.56302e-03,0.63456e-03,0.66611e-03,0.66857e-03, &
        & 0.65240e-03,0.61521e-03,0.55178e-03,0.43702e-03 /)
      kao(:, 1, 2, 4) = (/ &
        & 0.32225e-03,0.47151e-03,0.53262e-03,0.55192e-03,0.54706e-03, &
        & 0.52658e-03,0.49569e-03,0.43958e-03,0.31739e-03 /)
      kao(:, 2, 2, 4) = (/ &
        & 0.32532e-03,0.47816e-03,0.54076e-03,0.56222e-03,0.55834e-03, &
        & 0.53879e-03,0.50612e-03,0.44777e-03,0.32763e-03 /)
      kao(:, 3, 2, 4) = (/ &
        & 0.32941e-03,0.48729e-03,0.55083e-03,0.57497e-03,0.57312e-03, &
        & 0.55394e-03,0.51991e-03,0.45969e-03,0.33942e-03 /)
      kao(:, 4, 2, 4) = (/ &
        & 0.33303e-03,0.49510e-03,0.56036e-03,0.58720e-03,0.58669e-03, &
        & 0.56974e-03,0.53255e-03,0.47385e-03,0.35453e-03 /)
      kao(:, 5, 2, 4) = (/ &
        & 0.33657e-03,0.50290e-03,0.57014e-03,0.59917e-03,0.59997e-03, &
        & 0.58475e-03,0.54777e-03,0.48909e-03,0.36980e-03 /)
      kao(:, 1, 3, 4) = (/ &
        & 0.28263e-03,0.41968e-03,0.47376e-03,0.49297e-03,0.48633e-03, &
        & 0.46530e-03,0.43654e-03,0.38496e-03,0.26217e-03 /)
      kao(:, 2, 3, 4) = (/ &
        & 0.28517e-03,0.42528e-03,0.48017e-03,0.50148e-03,0.49564e-03, &
        & 0.47634e-03,0.44517e-03,0.39228e-03,0.27386e-03 /)
      kao(:, 3, 3, 4) = (/ &
        & 0.28805e-03,0.43254e-03,0.48769e-03,0.51075e-03,0.50628e-03, &
        & 0.48940e-03,0.45557e-03,0.40274e-03,0.28527e-03 /)
      kao(:, 4, 3, 4) = (/ &
        & 0.29156e-03,0.44130e-03,0.49824e-03,0.52245e-03,0.52001e-03, &
        & 0.50355e-03,0.46711e-03,0.41540e-03,0.29729e-03 /)
      kao(:, 5, 3, 4) = (/ &
        & 0.29453e-03,0.44828e-03,0.50753e-03,0.53257e-03,0.53321e-03, &
        & 0.51645e-03,0.48189e-03,0.42882e-03,0.30960e-03 /)
      kao(:, 1, 4, 4) = (/ &
        & 0.24709e-03,0.37040e-03,0.41811e-03,0.43692e-03,0.42924e-03, &
        & 0.40974e-03,0.38217e-03,0.33504e-03,0.21956e-03 /)
      kao(:, 2, 4, 4) = (/ &
        & 0.24935e-03,0.37531e-03,0.42359e-03,0.44356e-03,0.43669e-03, &
        & 0.41955e-03,0.39063e-03,0.34337e-03,0.23257e-03 /)
      kao(:, 3, 4, 4) = (/ &
        & 0.25192e-03,0.38183e-03,0.43049e-03,0.45130e-03,0.44572e-03, &
        & 0.43016e-03,0.39919e-03,0.35274e-03,0.24051e-03 /)
      kao(:, 4, 4, 4) = (/ &
        & 0.25420e-03,0.38887e-03,0.43864e-03,0.46020e-03,0.45692e-03, &
        & 0.44111e-03,0.40882e-03,0.36219e-03,0.24966e-03 /)
      kao(:, 5, 4, 4) = (/ &
        & 0.25772e-03,0.39769e-03,0.44993e-03,0.47213e-03,0.47068e-03, &
        & 0.45426e-03,0.42157e-03,0.37400e-03,0.25930e-03 /)
      kao(:, 1, 5, 4) = (/ &
        & 0.21574e-03,0.32603e-03,0.36644e-03,0.38307e-03,0.37721e-03, &
        & 0.36018e-03,0.33363e-03,0.29143e-03,0.18896e-03 /)
      kao(:, 2, 5, 4) = (/ &
        & 0.21778e-03,0.33044e-03,0.37107e-03,0.38833e-03,0.38426e-03, &
        & 0.36797e-03,0.34054e-03,0.29920e-03,0.19816e-03 /)
      kao(:, 3, 5, 4) = (/ &
        & 0.22015e-03,0.33584e-03,0.37735e-03,0.39513e-03,0.39228e-03, &
        & 0.37720e-03,0.34842e-03,0.30654e-03,0.20383e-03 /)
      kao(:, 4, 5, 4) = (/ &
        & 0.22252e-03,0.34167e-03,0.38484e-03,0.40343e-03,0.40251e-03, &
        & 0.38567e-03,0.35760e-03,0.31401e-03,0.21178e-03 /)
      kao(:, 5, 5, 4) = (/ &
        & 0.22604e-03,0.34964e-03,0.39509e-03,0.41443e-03,0.41465e-03, &
        & 0.39685e-03,0.36847e-03,0.32400e-03,0.21929e-03 /)
      kao(:, 1, 6, 4) = (/ &
        & 0.18783e-03,0.28666e-03,0.32037e-03,0.33351e-03,0.32945e-03, &
        & 0.31516e-03,0.29066e-03,0.25263e-03,0.16238e-03 /)
      kao(:, 2, 6, 4) = (/ &
        & 0.18921e-03,0.29078e-03,0.32423e-03,0.33799e-03,0.33536e-03, &
        & 0.32156e-03,0.29643e-03,0.25941e-03,0.16831e-03 /)
      kao(:, 3, 6, 4) = (/ &
        & 0.19117e-03,0.29487e-03,0.32978e-03,0.34375e-03,0.34274e-03, &
        & 0.32907e-03,0.30344e-03,0.26560e-03,0.17389e-03 /)
      kao(:, 4, 6, 4) = (/ &
        & 0.19356e-03,0.29979e-03,0.33631e-03,0.35135e-03,0.35098e-03, &
        & 0.33648e-03,0.31108e-03,0.27199e-03,0.18056e-03 /)
      kao(:, 5, 6, 4) = (/ &
        & 0.19643e-03,0.30567e-03,0.34396e-03,0.35996e-03,0.36067e-03, &
        & 0.34559e-03,0.32056e-03,0.28009e-03,0.18507e-03 /)
      kao(:, 1, 7, 4) = (/ &
        & 0.16233e-03,0.25159e-03,0.28051e-03,0.29071e-03,0.28724e-03, &
        & 0.27399e-03,0.25257e-03,0.21995e-03,0.15053e-03 /)
      kao(:, 2, 7, 4) = (/ &
        & 0.16394e-03,0.25497e-03,0.28374e-03,0.29454e-03,0.29203e-03, &
        & 0.28002e-03,0.25781e-03,0.22523e-03,0.15467e-03 /)
      kao(:, 3, 7, 4) = (/ &
        & 0.16554e-03,0.25862e-03,0.28837e-03,0.29946e-03,0.29804e-03, &
        & 0.28580e-03,0.26386e-03,0.23003e-03,0.15858e-03 /)
      kao(:, 4, 7, 4) = (/ &
        & 0.16755e-03,0.26275e-03,0.29380e-03,0.30624e-03,0.30499e-03, &
        & 0.29233e-03,0.27029e-03,0.23539e-03,0.16161e-03 /)
      kao(:, 5, 7, 4) = (/ &
        & 0.17007e-03,0.26765e-03,0.30035e-03,0.31353e-03,0.31332e-03, &
        & 0.30019e-03,0.27871e-03,0.24192e-03,0.16587e-03 /)
      kao(:, 1, 8, 4) = (/ &
        & 0.14021e-03,0.21983e-03,0.24557e-03,0.25394e-03,0.25027e-03, &
        & 0.23769e-03,0.21853e-03,0.19056e-03,0.17210e-03 /)
      kao(:, 2, 8, 4) = (/ &
        & 0.14181e-03,0.22244e-03,0.24837e-03,0.25730e-03,0.25433e-03, &
        & 0.24284e-03,0.22361e-03,0.19448e-03,0.16707e-03 /)
      kao(:, 3, 8, 4) = (/ &
        & 0.14344e-03,0.22578e-03,0.25216e-03,0.26169e-03,0.25950e-03, &
        & 0.24760e-03,0.22868e-03,0.19861e-03,0.16518e-03 /)
      kao(:, 4, 8, 4) = (/ &
        & 0.14524e-03,0.22935e-03,0.25652e-03,0.26715e-03,0.26554e-03, &
        & 0.25327e-03,0.23470e-03,0.20360e-03,0.16514e-03 /)
      kao(:, 5, 8, 4) = (/ &
        & 0.14752e-03,0.23348e-03,0.26209e-03,0.27316e-03,0.27225e-03, &
        & 0.26056e-03,0.24203e-03,0.20916e-03,0.16671e-03 /)
      kao(:, 1, 9, 4) = (/ &
        & 0.12008e-03,0.19084e-03,0.21359e-03,0.22137e-03,0.21826e-03, &
        & 0.20646e-03,0.18855e-03,0.16443e-03,0.31379e-03 /)
      kao(:, 2, 9, 4) = (/ &
        & 0.12170e-03,0.19281e-03,0.21619e-03,0.22414e-03,0.22156e-03, &
        & 0.21036e-03,0.19272e-03,0.16751e-03,0.30810e-03 /)
      kao(:, 3, 9, 4) = (/ &
        & 0.12341e-03,0.19553e-03,0.21930e-03,0.22810e-03,0.22604e-03, &
        & 0.21457e-03,0.19724e-03,0.17093e-03,0.30579e-03 /)
      kao(:, 4, 9, 4) = (/ &
        & 0.12515e-03,0.19866e-03,0.22306e-03,0.23273e-03,0.23128e-03, &
        & 0.22000e-03,0.20255e-03,0.17520e-03,0.30468e-03 /)
      kao(:, 5, 9, 4) = (/ &
        & 0.12711e-03,0.20244e-03,0.22780e-03,0.23779e-03,0.23723e-03, &
        & 0.22672e-03,0.20873e-03,0.18006e-03,0.30071e-03 /)
      kao(:, 1,10, 4) = (/ &
        & 0.10239e-03,0.16495e-03,0.18568e-03,0.19287e-03,0.19038e-03, &
        & 0.17962e-03,0.16274e-03,0.14112e-03,0.46281e-03 /)
      kao(:, 2,10, 4) = (/ &
        & 0.10386e-03,0.16652e-03,0.18791e-03,0.19539e-03,0.19307e-03, &
        & 0.18291e-03,0.16628e-03,0.14354e-03,0.46032e-03 /)
      kao(:, 3,10, 4) = (/ &
        & 0.10550e-03,0.16884e-03,0.19060e-03,0.19863e-03,0.19685e-03, &
        & 0.18669e-03,0.17045e-03,0.14674e-03,0.45882e-03 /)
      kao(:, 4,10, 4) = (/ &
        & 0.10710e-03,0.17185e-03,0.19377e-03,0.20238e-03,0.20140e-03, &
        & 0.19164e-03,0.17544e-03,0.15076e-03,0.45556e-03 /)
      kao(:, 5,10, 4) = (/ &
        & 0.10887e-03,0.17528e-03,0.19755e-03,0.20663e-03,0.20650e-03, &
        & 0.19756e-03,0.18068e-03,0.15495e-03,0.45295e-03 /)
      kao(:, 1,11, 4) = (/ &
        & 0.87454e-04,0.14214e-03,0.16093e-03,0.16784e-03,0.16634e-03, &
        & 0.15750e-03,0.14233e-03,0.12157e-03,0.50227e-03 /)
      kao(:, 2,11, 4) = (/ &
        & 0.89026e-04,0.14363e-03,0.16297e-03,0.17024e-03,0.16905e-03, &
        & 0.16052e-03,0.14560e-03,0.12384e-03,0.48800e-03 /)
      kao(:, 3,11, 4) = (/ &
        & 0.90456e-04,0.14595e-03,0.16534e-03,0.17342e-03,0.17281e-03, &
        & 0.16441e-03,0.14965e-03,0.12699e-03,0.48638e-03 /)
      kao(:, 4,11, 4) = (/ &
        & 0.91788e-04,0.14885e-03,0.16823e-03,0.17680e-03,0.17688e-03, &
        & 0.16911e-03,0.15409e-03,0.13060e-03,0.48097e-03 /)
      kao(:, 5,11, 4) = (/ &
        & 0.92958e-04,0.15220e-03,0.17197e-03,0.18085e-03,0.18150e-03, &
        & 0.17440e-03,0.15892e-03,0.13466e-03,0.48115e-03 /)
      kao(:, 1,12, 4) = (/ &
        & 0.74228e-04,0.12171e-03,0.13828e-03,0.14464e-03,0.14381e-03, &
        & 0.13674e-03,0.12370e-03,0.10454e-03,0.48263e-03 /)
      kao(:, 2,12, 4) = (/ &
        & 0.75542e-04,0.12330e-03,0.13992e-03,0.14688e-03,0.14666e-03, &
        & 0.13981e-03,0.12694e-03,0.10662e-03,0.46961e-03 /)
      kao(:, 3,12, 4) = (/ &
        & 0.76696e-04,0.12551e-03,0.14218e-03,0.14964e-03,0.14989e-03, &
        & 0.14346e-03,0.13058e-03,0.10986e-03,0.45986e-03 /)
      kao(:, 4,12, 4) = (/ &
        & 0.77769e-04,0.12821e-03,0.14505e-03,0.15276e-03,0.15361e-03, &
        & 0.14764e-03,0.13466e-03,0.11322e-03,0.45064e-03 /)
      kao(:, 5,12, 4) = (/ &
        & 0.78633e-04,0.13113e-03,0.14863e-03,0.15667e-03,0.15783e-03, &
        & 0.15249e-03,0.13915e-03,0.11696e-03,0.45257e-03 /)
      kao(:, 1,13, 4) = (/ &
        & 0.62659e-04,0.10388e-03,0.11828e-03,0.12392e-03,0.12371e-03, &
        & 0.11811e-03,0.10712e-03,0.89769e-04,0.40925e-03 /)
      kao(:, 2,13, 4) = (/ &
        & 0.63709e-04,0.10546e-03,0.11986e-03,0.12594e-03,0.12627e-03, &
        & 0.12095e-03,0.11006e-03,0.92053e-04,0.39852e-03 /)
      kao(:, 3,13, 4) = (/ &
        & 0.64717e-04,0.10750e-03,0.12189e-03,0.12839e-03,0.12907e-03, &
        & 0.12414e-03,0.11317e-03,0.94939e-04,0.39013e-03 /)
      kao(:, 4,13, 4) = (/ &
        & 0.65465e-04,0.10983e-03,0.12464e-03,0.13149e-03,0.13253e-03, &
        & 0.12801e-03,0.11693e-03,0.98001e-04,0.38349e-03 /)
      kao(:, 5,13, 4) = (/ &
        & 0.66137e-04,0.11222e-03,0.12786e-03,0.13517e-03,0.13652e-03, &
        & 0.13219e-03,0.12093e-03,0.10155e-03,0.38305e-03 /)
      kao(:, 1, 1, 5) = (/ &
        & 0.60998e-03,0.92357e-03,0.10463e-02,0.11196e-02,0.11571e-02, &
        & 0.11569e-02,0.11152e-02,0.10342e-02,0.80721e-03 /)
      kao(:, 2, 1, 5) = (/ &
        & 0.61496e-03,0.93510e-03,0.10604e-02,0.11361e-02,0.11777e-02, &
        & 0.11834e-02,0.11457e-02,0.10708e-02,0.83732e-03 /)
      kao(:, 3, 1, 5) = (/ &
        & 0.62454e-03,0.95002e-03,0.10819e-02,0.11594e-02,0.12038e-02, &
        & 0.12158e-02,0.11823e-02,0.11158e-02,0.87187e-03 /)
      kao(:, 4, 1, 5) = (/ &
        & 0.63013e-03,0.96444e-03,0.11010e-02,0.11847e-02,0.12326e-02, &
        & 0.12499e-02,0.12239e-02,0.11623e-02,0.91505e-03 /)
      kao(:, 5, 1, 5) = (/ &
        & 0.63867e-03,0.98562e-03,0.11276e-02,0.12151e-02,0.12673e-02, &
        & 0.12886e-02,0.12687e-02,0.12127e-02,0.95931e-03 /)
      kao(:, 1, 2, 5) = (/ &
        & 0.54006e-03,0.82110e-03,0.93517e-03,0.10086e-02,0.10436e-02, &
        & 0.10473e-02,0.10071e-02,0.92435e-03,0.69632e-03 /)
      kao(:, 2, 2, 5) = (/ &
        & 0.54512e-03,0.83214e-03,0.94586e-03,0.10224e-02,0.10616e-02, &
        & 0.10697e-02,0.10360e-02,0.95897e-03,0.72282e-03 /)
      kao(:, 3, 2, 5) = (/ &
        & 0.55430e-03,0.84713e-03,0.96481e-03,0.10423e-02,0.10850e-02, &
        & 0.10972e-02,0.10691e-02,0.99640e-03,0.75512e-03 /)
      kao(:, 4, 2, 5) = (/ &
        & 0.56089e-03,0.86369e-03,0.98575e-03,0.10648e-02,0.11112e-02, &
        & 0.11281e-02,0.11049e-02,0.10361e-02,0.79150e-03 /)
      kao(:, 5, 2, 5) = (/ &
        & 0.56701e-03,0.88105e-03,0.10081e-02,0.10898e-02,0.11420e-02, &
        & 0.11626e-02,0.11406e-02,0.10780e-02,0.83023e-03 /)
      kao(:, 1, 3, 5) = (/ &
        & 0.47586e-03,0.72781e-03,0.83369e-03,0.89860e-03,0.93234e-03, &
        & 0.93626e-03,0.89909e-03,0.81585e-03,0.59036e-03 /)
      kao(:, 2, 3, 5) = (/ &
        & 0.48035e-03,0.73757e-03,0.84502e-03,0.91276e-03,0.94800e-03, &
        & 0.95536e-03,0.92668e-03,0.84501e-03,0.61080e-03 /)
      kao(:, 3, 3, 5) = (/ &
        & 0.48667e-03,0.74941e-03,0.86058e-03,0.92996e-03,0.96794e-03, &
        & 0.97737e-03,0.95368e-03,0.87646e-03,0.63872e-03 /)
      kao(:, 4, 3, 5) = (/ &
        & 0.49637e-03,0.76538e-03,0.87882e-03,0.95073e-03,0.99190e-03, &
        & 0.10051e-02,0.98438e-03,0.91070e-03,0.66866e-03 /)
      kao(:, 5, 3, 5) = (/ &
        & 0.50269e-03,0.78028e-03,0.89635e-03,0.97198e-03,0.10179e-02, &
        & 0.10338e-02,0.10130e-02,0.94553e-03,0.70095e-03 /)
      kao(:, 1, 4, 5) = (/ &
        & 0.41745e-03,0.64505e-03,0.73966e-03,0.79761e-03,0.82752e-03, &
        & 0.82878e-03,0.79470e-03,0.71636e-03,0.49987e-03 /)
      kao(:, 2, 4, 5) = (/ &
        & 0.42212e-03,0.65318e-03,0.75017e-03,0.80979e-03,0.84194e-03, &
        & 0.84473e-03,0.81717e-03,0.73865e-03,0.51625e-03 /)
      kao(:, 3, 4, 5) = (/ &
        & 0.42808e-03,0.66407e-03,0.76314e-03,0.82416e-03,0.85814e-03, &
        & 0.86375e-03,0.83972e-03,0.76440e-03,0.53894e-03 /)
      kao(:, 4, 4, 5) = (/ &
        & 0.43544e-03,0.67737e-03,0.77911e-03,0.84222e-03,0.87777e-03, &
        & 0.88583e-03,0.86479e-03,0.79362e-03,0.56271e-03 /)
      kao(:, 5, 4, 5) = (/ &
        & 0.44549e-03,0.69330e-03,0.79686e-03,0.86274e-03,0.90103e-03, &
        & 0.91189e-03,0.89184e-03,0.82416e-03,0.58887e-03 /)
      kao(:, 1, 5, 5) = (/ &
        & 0.36593e-03,0.56942e-03,0.65432e-03,0.70354e-03,0.72916e-03, &
        & 0.72850e-03,0.69713e-03,0.62558e-03,0.42621e-03 /)
      kao(:, 2, 5, 5) = (/ &
        & 0.37099e-03,0.57654e-03,0.66395e-03,0.71472e-03,0.74107e-03, &
        & 0.74240e-03,0.71535e-03,0.64376e-03,0.43884e-03 /)
      kao(:, 3, 5, 5) = (/ &
        & 0.37647e-03,0.58652e-03,0.67530e-03,0.72837e-03,0.75654e-03, &
        & 0.75759e-03,0.73402e-03,0.66546e-03,0.45630e-03 /)
      kao(:, 4, 5, 5) = (/ &
        & 0.38311e-03,0.59837e-03,0.68871e-03,0.74328e-03,0.77277e-03, &
        & 0.77677e-03,0.75490e-03,0.68962e-03,0.47449e-03 /)
      kao(:, 5, 5, 5) = (/ &
        & 0.39217e-03,0.61368e-03,0.70480e-03,0.76178e-03,0.79297e-03, &
        & 0.79889e-03,0.77761e-03,0.71542e-03,0.49580e-03 /)
      kao(:, 1, 6, 5) = (/ &
        & 0.32055e-03,0.49922e-03,0.57435e-03,0.61868e-03,0.63931e-03, &
        & 0.63779e-03,0.60689e-03,0.54327e-03,0.36282e-03 /)
      kao(:, 2, 6, 5) = (/ &
        & 0.32502e-03,0.50520e-03,0.58251e-03,0.62835e-03,0.64977e-03, &
        & 0.64920e-03,0.62209e-03,0.55837e-03,0.37399e-03 /)
      kao(:, 3, 6, 5) = (/ &
        & 0.33055e-03,0.51462e-03,0.59267e-03,0.63972e-03,0.66253e-03, &
        & 0.66213e-03,0.63802e-03,0.57660e-03,0.38710e-03 /)
      kao(:, 4, 6, 5) = (/ &
        & 0.33647e-03,0.52569e-03,0.60454e-03,0.65260e-03,0.67645e-03, &
        & 0.67638e-03,0.65560e-03,0.59667e-03,0.40130e-03 /)
      kao(:, 5, 6, 5) = (/ &
        & 0.34306e-03,0.53846e-03,0.61820e-03,0.66796e-03,0.69284e-03, &
        & 0.69400e-03,0.67340e-03,0.61700e-03,0.41923e-03 /)
      kao(:, 1, 7, 5) = (/ &
        & 0.28149e-03,0.43644e-03,0.49974e-03,0.53938e-03,0.55701e-03, &
        & 0.55579e-03,0.52736e-03,0.47001e-03,0.31306e-03 /)
      kao(:, 2, 7, 5) = (/ &
        & 0.28528e-03,0.44207e-03,0.50655e-03,0.54763e-03,0.56691e-03, &
        & 0.56439e-03,0.53930e-03,0.48247e-03,0.32173e-03 /)
      kao(:, 3, 7, 5) = (/ &
        & 0.29004e-03,0.45020e-03,0.51518e-03,0.55741e-03,0.57771e-03, &
        & 0.57585e-03,0.55263e-03,0.49748e-03,0.33090e-03 /)
      kao(:, 4, 7, 5) = (/ &
        & 0.29568e-03,0.46070e-03,0.52625e-03,0.56864e-03,0.58962e-03, &
        & 0.58944e-03,0.56702e-03,0.51458e-03,0.34232e-03 /)
      kao(:, 5, 7, 5) = (/ &
        & 0.30178e-03,0.47274e-03,0.53886e-03,0.58253e-03,0.60354e-03, &
        & 0.60454e-03,0.58225e-03,0.53128e-03,0.35470e-03 /)
      kao(:, 1, 8, 5) = (/ &
        & 0.24786e-03,0.38205e-03,0.43403e-03,0.46727e-03,0.48302e-03, &
        & 0.48227e-03,0.45812e-03,0.40611e-03,0.30468e-03 /)
      kao(:, 2, 8, 5) = (/ &
        & 0.25026e-03,0.38705e-03,0.43948e-03,0.47351e-03,0.49158e-03, &
        & 0.49003e-03,0.46771e-03,0.41673e-03,0.30992e-03 /)
      kao(:, 3, 8, 5) = (/ &
        & 0.25464e-03,0.39453e-03,0.44681e-03,0.48211e-03,0.50112e-03, &
        & 0.49992e-03,0.47844e-03,0.42901e-03,0.31626e-03 /)
      kao(:, 4, 8, 5) = (/ &
        & 0.25978e-03,0.40390e-03,0.45683e-03,0.49220e-03,0.51134e-03, &
        & 0.51141e-03,0.48898e-03,0.44238e-03,0.32406e-03 /)
      kao(:, 5, 8, 5) = (/ &
        & 0.26514e-03,0.41428e-03,0.46827e-03,0.50433e-03,0.52333e-03, &
        & 0.52414e-03,0.50147e-03,0.45619e-03,0.33317e-03 /)
      kao(:, 1, 9, 5) = (/ &
        & 0.21824e-03,0.33786e-03,0.37946e-03,0.40535e-03,0.41752e-03, &
        & 0.41661e-03,0.39611e-03,0.34986e-03,0.52178e-03 /)
      kao(:, 2, 9, 5) = (/ &
        & 0.22059e-03,0.34230e-03,0.38410e-03,0.41056e-03,0.42477e-03, &
        & 0.42372e-03,0.40485e-03,0.35866e-03,0.50681e-03 /)
      kao(:, 3, 9, 5) = (/ &
        & 0.22400e-03,0.34814e-03,0.39039e-03,0.41748e-03,0.43284e-03, &
        & 0.43220e-03,0.41363e-03,0.36885e-03,0.49302e-03 /)
      kao(:, 4, 9, 5) = (/ &
        & 0.22873e-03,0.35603e-03,0.39905e-03,0.42659e-03,0.44174e-03, &
        & 0.44167e-03,0.42288e-03,0.37972e-03,0.48294e-03 /)
      kao(:, 5, 9, 5) = (/ &
        & 0.23347e-03,0.36495e-03,0.40893e-03,0.43763e-03,0.45181e-03, &
        & 0.45234e-03,0.43347e-03,0.39120e-03,0.47762e-03 /)
      kao(:, 1,10, 5) = (/ &
        & 0.19122e-03,0.29954e-03,0.33486e-03,0.35474e-03,0.36349e-03, &
        & 0.36120e-03,0.34300e-03,0.30153e-03,0.10818e-02 /)
      kao(:, 2,10, 5) = (/ &
        & 0.19375e-03,0.30331e-03,0.33858e-03,0.35959e-03,0.36963e-03, &
        & 0.36736e-03,0.35033e-03,0.30927e-03,0.10683e-02 /)
      kao(:, 3,10, 5) = (/ &
        & 0.19685e-03,0.30858e-03,0.34410e-03,0.36599e-03,0.37648e-03, &
        & 0.37420e-03,0.35748e-03,0.31737e-03,0.10704e-02 /)
      kao(:, 4,10, 5) = (/ &
        & 0.20091e-03,0.31499e-03,0.35151e-03,0.37400e-03,0.38421e-03, &
        & 0.38207e-03,0.36506e-03,0.32617e-03,0.10743e-02 /)
      kao(:, 5,10, 5) = (/ &
        & 0.20539e-03,0.32294e-03,0.36050e-03,0.38325e-03,0.39308e-03, &
        & 0.39074e-03,0.37406e-03,0.33544e-03,0.10696e-02 /)
      kao(:, 1,11, 5) = (/ &
        & 0.16667e-03,0.26520e-03,0.29671e-03,0.31441e-03,0.32093e-03, &
        & 0.31659e-03,0.30045e-03,0.26340e-03,0.11835e-02 /)
      kao(:, 2,11, 5) = (/ &
        & 0.16885e-03,0.26948e-03,0.30096e-03,0.31914e-03,0.32661e-03, &
        & 0.32210e-03,0.30657e-03,0.27004e-03,0.11814e-02 /)
      kao(:, 3,11, 5) = (/ &
        & 0.17223e-03,0.27439e-03,0.30661e-03,0.32470e-03,0.33272e-03, &
        & 0.32842e-03,0.31227e-03,0.27654e-03,0.11630e-02 /)
      kao(:, 4,11, 5) = (/ &
        & 0.17618e-03,0.28049e-03,0.31365e-03,0.33181e-03,0.33965e-03, &
        & 0.33555e-03,0.31903e-03,0.28400e-03,0.11485e-02 /)
      kao(:, 5,11, 5) = (/ &
        & 0.18103e-03,0.28752e-03,0.32181e-03,0.34031e-03,0.34776e-03, &
        & 0.34353e-03,0.32710e-03,0.29221e-03,0.11367e-02 /)
      kao(:, 1,12, 5) = (/ &
        & 0.14364e-03,0.23191e-03,0.26011e-03,0.27602e-03,0.28230e-03, &
        & 0.27753e-03,0.26259e-03,0.22940e-03,0.11242e-02 /)
      kao(:, 2,12, 5) = (/ &
        & 0.14586e-03,0.23578e-03,0.26464e-03,0.28074e-03,0.28728e-03, &
        & 0.28268e-03,0.26740e-03,0.23511e-03,0.11131e-02 /)
      kao(:, 3,12, 5) = (/ &
        & 0.14908e-03,0.24042e-03,0.27020e-03,0.28659e-03,0.29280e-03, &
        & 0.28866e-03,0.27254e-03,0.24089e-03,0.10996e-02 /)
      kao(:, 4,12, 5) = (/ &
        & 0.15297e-03,0.24595e-03,0.27661e-03,0.29313e-03,0.29926e-03, &
        & 0.29513e-03,0.27870e-03,0.24706e-03,0.10965e-02 /)
      kao(:, 5,12, 5) = (/ &
        & 0.15735e-03,0.25242e-03,0.28422e-03,0.30069e-03,0.30695e-03, &
        & 0.30241e-03,0.28613e-03,0.25425e-03,0.10839e-02 /)
      kao(:, 1,13, 5) = (/ &
        & 0.12345e-03,0.20108e-03,0.22674e-03,0.24086e-03,0.24638e-03, &
        & 0.24238e-03,0.22876e-03,0.19931e-03,0.96895e-03 /)
      kao(:, 2,13, 5) = (/ &
        & 0.12581e-03,0.20480e-03,0.23117e-03,0.24535e-03,0.25104e-03, &
        & 0.24702e-03,0.23303e-03,0.20421e-03,0.96294e-03 /)
      kao(:, 3,13, 5) = (/ &
        & 0.12856e-03,0.20921e-03,0.23606e-03,0.25076e-03,0.25631e-03, &
        & 0.25243e-03,0.23816e-03,0.20920e-03,0.95736e-03 /)
      kao(:, 4,13, 5) = (/ &
        & 0.13210e-03,0.21428e-03,0.24223e-03,0.25691e-03,0.26218e-03, &
        & 0.25847e-03,0.24400e-03,0.21468e-03,0.95389e-03 /)
      kao(:, 5,13, 5) = (/ &
        & 0.13599e-03,0.22037e-03,0.24914e-03,0.26391e-03,0.26911e-03, &
        & 0.26543e-03,0.25095e-03,0.22101e-03,0.94116e-03 /)
      kao(:, 1, 1, 6) = (/ &
        & 0.10602e-02,0.17123e-02,0.20157e-02,0.22277e-02,0.23726e-02, &
        & 0.24628e-02,0.25069e-02,0.24686e-02,0.20168e-02 /)
      kao(:, 2, 1, 6) = (/ &
        & 0.10672e-02,0.17270e-02,0.20414e-02,0.22652e-02,0.24211e-02, &
        & 0.25212e-02,0.25704e-02,0.25272e-02,0.20646e-02 /)
      kao(:, 3, 1, 6) = (/ &
        & 0.10788e-02,0.17509e-02,0.20769e-02,0.23112e-02,0.24814e-02, &
        & 0.25914e-02,0.26418e-02,0.25942e-02,0.21193e-02 /)
      kao(:, 4, 1, 6) = (/ &
        & 0.10874e-02,0.17764e-02,0.21176e-02,0.23585e-02,0.25381e-02, &
        & 0.26622e-02,0.27175e-02,0.26689e-02,0.21851e-02 /)
      kao(:, 5, 1, 6) = (/ &
        & 0.11018e-02,0.18090e-02,0.21640e-02,0.24172e-02,0.26051e-02, &
        & 0.27415e-02,0.28075e-02,0.27566e-02,0.22604e-02 /)
      kao(:, 1, 2, 6) = (/ &
        & 0.95075e-03,0.15355e-02,0.17976e-02,0.19766e-02,0.21006e-02, &
        & 0.21710e-02,0.21998e-02,0.21663e-02,0.17568e-02 /)
      kao(:, 2, 2, 6) = (/ &
        & 0.96010e-03,0.15501e-02,0.18242e-02,0.20112e-02,0.21419e-02, &
        & 0.22180e-02,0.22475e-02,0.22135e-02,0.17960e-02 /)
      kao(:, 3, 2, 6) = (/ &
        & 0.97337e-03,0.15726e-02,0.18580e-02,0.20531e-02,0.21905e-02, &
        & 0.22742e-02,0.23072e-02,0.22697e-02,0.18409e-02 /)
      kao(:, 4, 2, 6) = (/ &
        & 0.98600e-03,0.15975e-02,0.18942e-02,0.20984e-02,0.22403e-02, &
        & 0.23334e-02,0.23735e-02,0.23328e-02,0.18922e-02 /)
      kao(:, 5, 2, 6) = (/ &
        & 0.99685e-03,0.16266e-02,0.19353e-02,0.21493e-02,0.22931e-02, &
        & 0.23955e-02,0.24466e-02,0.24068e-02,0.19548e-02 /)
      kao(:, 1, 3, 6) = (/ &
        & 0.85253e-03,0.13731e-02,0.15966e-02,0.17555e-02,0.18660e-02, &
        & 0.19267e-02,0.19415e-02,0.18992e-02,0.15125e-02 /)
      kao(:, 2, 3, 6) = (/ &
        & 0.86131e-03,0.13853e-02,0.16172e-02,0.17827e-02,0.18992e-02, &
        & 0.19616e-02,0.19781e-02,0.19388e-02,0.15472e-02 /)
      kao(:, 3, 3, 6) = (/ &
        & 0.87215e-03,0.13990e-02,0.16433e-02,0.18151e-02,0.19357e-02, &
        & 0.20044e-02,0.20244e-02,0.19864e-02,0.15842e-02 /)
      kao(:, 4, 3, 6) = (/ &
        & 0.88704e-03,0.14261e-02,0.16795e-02,0.18576e-02,0.19802e-02, &
        & 0.20536e-02,0.20804e-02,0.20410e-02,0.16256e-02 /)
      kao(:, 5, 3, 6) = (/ &
        & 0.89758e-03,0.14527e-02,0.17171e-02,0.19025e-02,0.20236e-02, &
        & 0.21045e-02,0.21413e-02,0.21023e-02,0.16764e-02 /)
      kao(:, 1, 4, 6) = (/ &
        & 0.76168e-03,0.12206e-02,0.14175e-02,0.15588e-02,0.16575e-02, &
        & 0.17098e-02,0.17134e-02,0.16603e-02,0.12974e-02 /)
      kao(:, 2, 4, 6) = (/ &
        & 0.76958e-03,0.12314e-02,0.14342e-02,0.15807e-02,0.16847e-02, &
        & 0.17400e-02,0.17442e-02,0.16938e-02,0.13260e-02 /)
      kao(:, 3, 4, 6) = (/ &
        & 0.78002e-03,0.12481e-02,0.14573e-02,0.16092e-02,0.17173e-02, &
        & 0.17771e-02,0.17830e-02,0.17337e-02,0.13577e-02 /)
      kao(:, 4, 4, 6) = (/ &
        & 0.79261e-03,0.12694e-02,0.14861e-02,0.16420e-02,0.17536e-02, &
        & 0.18179e-02,0.18286e-02,0.17776e-02,0.13930e-02 /)
      kao(:, 5, 4, 6) = (/ &
        & 0.80905e-03,0.12930e-02,0.15216e-02,0.16835e-02,0.17969e-02, &
        & 0.18651e-02,0.18829e-02,0.18324e-02,0.14370e-02 /)
      kao(:, 1, 5, 6) = (/ &
        & 0.67567e-03,0.10847e-02,0.12673e-02,0.13865e-02,0.14678e-02, &
        & 0.15102e-02,0.15099e-02,0.14466e-02,0.11079e-02 /)
      kao(:, 2, 5, 6) = (/ &
        & 0.68234e-03,0.10948e-02,0.12810e-02,0.14048e-02,0.14909e-02, &
        & 0.15364e-02,0.15351e-02,0.14749e-02,0.11322e-02 /)
      kao(:, 3, 5, 6) = (/ &
        & 0.69172e-03,0.11094e-02,0.12954e-02,0.14275e-02,0.15177e-02, &
        & 0.15693e-02,0.15680e-02,0.15069e-02,0.11581e-02 /)
      kao(:, 4, 5, 6) = (/ &
        & 0.70397e-03,0.11284e-02,0.13174e-02,0.14563e-02,0.15501e-02, &
        & 0.16053e-02,0.16071e-02,0.15445e-02,0.11891e-02 /)
      kao(:, 5, 5, 6) = (/ &
        & 0.72110e-03,0.11540e-02,0.13487e-02,0.14917e-02,0.15891e-02, &
        & 0.16474e-02,0.16536e-02,0.15913e-02,0.12262e-02 /)
      kao(:, 1, 6, 6) = (/ &
        & 0.59508e-03,0.96565e-03,0.11271e-02,0.12321e-02,0.12935e-02, &
        & 0.13263e-02,0.13235e-02,0.12583e-02,0.94318e-03 /)
      kao(:, 2, 6, 6) = (/ &
        & 0.60163e-03,0.97555e-03,0.11390e-02,0.12428e-02,0.13136e-02, &
        & 0.13483e-02,0.13443e-02,0.12812e-02,0.96040e-03 /)
      kao(:, 3, 6, 6) = (/ &
        & 0.61035e-03,0.98842e-03,0.11551e-02,0.12623e-02,0.13370e-02, &
        & 0.13759e-02,0.13716e-02,0.13073e-02,0.98049e-03 /)
      kao(:, 4, 6, 6) = (/ &
        & 0.62216e-03,0.10038e-02,0.11750e-02,0.12870e-02,0.13646e-02, &
        & 0.14087e-02,0.14042e-02,0.13389e-02,0.10049e-02 /)
      kao(:, 5, 6, 6) = (/ &
        & 0.63568e-03,0.10246e-02,0.11986e-02,0.13152e-02,0.13969e-02, &
        & 0.14439e-02,0.14425e-02,0.13760e-02,0.10351e-02 /)
      kao(:, 1, 7, 6) = (/ &
        & 0.52222e-03,0.85609e-03,0.99991e-03,0.10870e-02,0.11353e-02, &
        & 0.11602e-02,0.11537e-02,0.10909e-02,0.79969e-03 /)
      kao(:, 2, 7, 6) = (/ &
        & 0.52839e-03,0.86572e-03,0.10120e-02,0.11011e-02,0.11521e-02, &
        & 0.11786e-02,0.11705e-02,0.11093e-02,0.81421e-03 /)
      kao(:, 3, 7, 6) = (/ &
        & 0.53695e-03,0.87703e-03,0.10261e-02,0.11177e-02,0.11714e-02, &
        & 0.12016e-02,0.11930e-02,0.11309e-02,0.83157e-03 /)
      kao(:, 4, 7, 6) = (/ &
        & 0.54734e-03,0.89105e-03,0.10435e-02,0.11340e-02,0.11954e-02, &
        & 0.12276e-02,0.12204e-02,0.11559e-02,0.85189e-03 /)
      kao(:, 5, 7, 6) = (/ &
        & 0.56071e-03,0.90902e-03,0.10648e-02,0.11575e-02,0.12234e-02, &
        & 0.12571e-02,0.12523e-02,0.11865e-02,0.87630e-03 /)
      kao(:, 1, 8, 6) = (/ &
        & 0.45809e-03,0.75296e-03,0.88022e-03,0.95530e-03,0.99775e-03, &
        & 0.10107e-02,0.99991e-03,0.94255e-03,0.69349e-03 /)
      kao(:, 2, 8, 6) = (/ &
        & 0.46457e-03,0.76241e-03,0.89241e-03,0.96833e-03,0.10107e-02, &
        & 0.10258e-02,0.10136e-02,0.95735e-03,0.70413e-03 /)
      kao(:, 3, 8, 6) = (/ &
        & 0.47249e-03,0.77258e-03,0.90578e-03,0.98260e-03,0.10233e-02, &
        & 0.10448e-02,0.10324e-02,0.97481e-03,0.71522e-03 /)
      kao(:, 4, 8, 6) = (/ &
        & 0.48263e-03,0.78537e-03,0.92183e-03,0.10012e-02,0.10427e-02, &
        & 0.10663e-02,0.10558e-02,0.99531e-03,0.72922e-03 /)
      kao(:, 5, 8, 6) = (/ &
        & 0.49501e-03,0.80218e-03,0.94059e-03,0.10219e-02,0.10669e-02, &
        & 0.10907e-02,0.10824e-02,0.10204e-02,0.74659e-03 /)
      kao(:, 1, 9, 6) = (/ &
        & 0.40630e-03,0.65697e-03,0.76693e-03,0.83253e-03,0.86881e-03, &
        & 0.87661e-03,0.86393e-03,0.81158e-03,0.85763e-03 /)
      kao(:, 2, 9, 6) = (/ &
        & 0.41166e-03,0.66657e-03,0.77941e-03,0.84564e-03,0.88174e-03, &
        & 0.88952e-03,0.87488e-03,0.82351e-03,0.84633e-03 /)
      kao(:, 3, 9, 6) = (/ &
        & 0.41847e-03,0.67680e-03,0.79185e-03,0.85875e-03,0.89476e-03, &
        & 0.90456e-03,0.89101e-03,0.83833e-03,0.84017e-03 /)
      kao(:, 4, 9, 6) = (/ &
        & 0.42661e-03,0.68815e-03,0.80637e-03,0.87435e-03,0.91036e-03, &
        & 0.92205e-03,0.90961e-03,0.85502e-03,0.83895e-03 /)
      kao(:, 5, 9, 6) = (/ &
        & 0.43776e-03,0.70278e-03,0.82329e-03,0.89247e-03,0.92828e-03, &
        & 0.94238e-03,0.93168e-03,0.87536e-03,0.84088e-03 /)
      kao(:, 1,10, 6) = (/ &
        & 0.36854e-03,0.57908e-03,0.66869e-03,0.72258e-03,0.75231e-03, &
        & 0.75942e-03,0.74383e-03,0.69709e-03,0.20395e-02 /)
      kao(:, 2,10, 6) = (/ &
        & 0.37298e-03,0.58711e-03,0.68015e-03,0.73349e-03,0.76293e-03, &
        & 0.77052e-03,0.75338e-03,0.70798e-03,0.19202e-02 /)
      kao(:, 3,10, 6) = (/ &
        & 0.37876e-03,0.59595e-03,0.69100e-03,0.74575e-03,0.77497e-03, &
        & 0.78295e-03,0.76740e-03,0.72017e-03,0.18161e-02 /)
      kao(:, 4,10, 6) = (/ &
        & 0.38615e-03,0.60708e-03,0.70373e-03,0.75914e-03,0.78952e-03, &
        & 0.79663e-03,0.78331e-03,0.73385e-03,0.17247e-02 /)
      kao(:, 5,10, 6) = (/ &
        & 0.39564e-03,0.62052e-03,0.71856e-03,0.77512e-03,0.80699e-03, &
        & 0.81444e-03,0.80141e-03,0.75081e-03,0.16568e-02 /)
      kao(:, 1,11, 6) = (/ &
        & 0.33320e-03,0.52088e-03,0.59646e-03,0.63812e-03,0.65660e-03, &
        & 0.65900e-03,0.64138e-03,0.60020e-03,0.25696e-02 /)
      kao(:, 2,11, 6) = (/ &
        & 0.33882e-03,0.52942e-03,0.60584e-03,0.64728e-03,0.66639e-03, &
        & 0.66995e-03,0.65115e-03,0.61030e-03,0.24243e-02 /)
      kao(:, 3,11, 6) = (/ &
        & 0.34516e-03,0.53993e-03,0.61579e-03,0.65783e-03,0.67758e-03, &
        & 0.68193e-03,0.66413e-03,0.62169e-03,0.23408e-02 /)
      kao(:, 4,11, 6) = (/ &
        & 0.35301e-03,0.55124e-03,0.62753e-03,0.66999e-03,0.69148e-03, &
        & 0.69508e-03,0.67858e-03,0.63426e-03,0.22732e-02 /)
      kao(:, 5,11, 6) = (/ &
        & 0.36214e-03,0.56453e-03,0.64151e-03,0.68481e-03,0.70755e-03, &
        & 0.71086e-03,0.69483e-03,0.64938e-03,0.21869e-02 /)
      kao(:, 1,12, 6) = (/ &
        & 0.29653e-03,0.46559e-03,0.53073e-03,0.56520e-03,0.57894e-03, &
        & 0.57686e-03,0.55698e-03,0.51584e-03,0.26304e-02 /)
      kao(:, 2,12, 6) = (/ &
        & 0.30188e-03,0.47447e-03,0.54017e-03,0.57406e-03,0.58804e-03, &
        & 0.58653e-03,0.56630e-03,0.52472e-03,0.24930e-02 /)
      kao(:, 3,12, 6) = (/ &
        & 0.30861e-03,0.48517e-03,0.55102e-03,0.58380e-03,0.59890e-03, &
        & 0.59725e-03,0.57721e-03,0.53486e-03,0.23834e-02 /)
      kao(:, 4,12, 6) = (/ &
        & 0.31637e-03,0.49701e-03,0.56299e-03,0.59618e-03,0.61191e-03, &
        & 0.60936e-03,0.58930e-03,0.54649e-03,0.22824e-02 /)
      kao(:, 5,12, 6) = (/ &
        & 0.32604e-03,0.51148e-03,0.57604e-03,0.61103e-03,0.62611e-03, &
        & 0.62412e-03,0.60375e-03,0.56026e-03,0.22084e-02 /)
      kao(:, 1,13, 6) = (/ &
        & 0.26154e-03,0.41366e-03,0.47019e-03,0.50056e-03,0.51140e-03, &
        & 0.50695e-03,0.48611e-03,0.44348e-03,0.22773e-02 /)
      kao(:, 2,13, 6) = (/ &
        & 0.26669e-03,0.42267e-03,0.47957e-03,0.51009e-03,0.52067e-03, &
        & 0.51611e-03,0.49506e-03,0.45138e-03,0.21516e-02 /)
      kao(:, 3,13, 6) = (/ &
        & 0.27302e-03,0.43290e-03,0.49082e-03,0.52081e-03,0.53105e-03, &
        & 0.52578e-03,0.50476e-03,0.46026e-03,0.20522e-02 /)
      kao(:, 4,13, 6) = (/ &
        & 0.28114e-03,0.44552e-03,0.50271e-03,0.53316e-03,0.54314e-03, &
        & 0.53754e-03,0.51555e-03,0.47096e-03,0.19694e-02 /)
      kao(:, 5,13, 6) = (/ &
        & 0.29046e-03,0.45904e-03,0.51716e-03,0.54751e-03,0.55727e-03, &
        & 0.55147e-03,0.52828e-03,0.48333e-03,0.19102e-02 /)
      kao(:, 1, 1, 7) = (/ &
        & 0.21025e-02,0.35934e-02,0.44505e-02,0.51294e-02,0.56565e-02, &
        & 0.60638e-02,0.63051e-02,0.63060e-02,0.53132e-02 /)
      kao(:, 2, 1, 7) = (/ &
        & 0.21147e-02,0.36363e-02,0.45228e-02,0.52203e-02,0.57590e-02, &
        & 0.61627e-02,0.64080e-02,0.64123e-02,0.54186e-02 /)
      kao(:, 3, 1, 7) = (/ &
        & 0.21423e-02,0.36907e-02,0.46129e-02,0.53384e-02,0.58809e-02, &
        & 0.62832e-02,0.65320e-02,0.65359e-02,0.55396e-02 /)
      kao(:, 4, 1, 7) = (/ &
        & 0.21655e-02,0.37303e-02,0.46928e-02,0.54454e-02,0.60067e-02, &
        & 0.64159e-02,0.66758e-02,0.66776e-02,0.56738e-02 /)
      kao(:, 5, 1, 7) = (/ &
        & 0.22041e-02,0.37865e-02,0.47900e-02,0.55720e-02,0.61575e-02, &
        & 0.65795e-02,0.68426e-02,0.68332e-02,0.58218e-02 /)
      kao(:, 1, 2, 7) = (/ &
        & 0.19184e-02,0.32868e-02,0.40037e-02,0.45520e-02,0.49723e-02, &
        & 0.52862e-02,0.54779e-02,0.54778e-02,0.44696e-02 /)
      kao(:, 2, 2, 7) = (/ &
        & 0.19302e-02,0.33258e-02,0.40693e-02,0.46336e-02,0.50634e-02, &
        & 0.53829e-02,0.55797e-02,0.55784e-02,0.45568e-02 /)
      kao(:, 3, 2, 7) = (/ &
        & 0.19586e-02,0.33762e-02,0.41518e-02,0.47383e-02,0.51749e-02, &
        & 0.54993e-02,0.56986e-02,0.56923e-02,0.46572e-02 /)
      kao(:, 4, 2, 7) = (/ &
        & 0.19876e-02,0.34214e-02,0.42297e-02,0.48395e-02,0.52957e-02, &
        & 0.56305e-02,0.58340e-02,0.58219e-02,0.47733e-02 /)
      kao(:, 5, 2, 7) = (/ &
        & 0.20222e-02,0.34660e-02,0.43057e-02,0.49428e-02,0.54286e-02, &
        & 0.57769e-02,0.59846e-02,0.59651e-02,0.49022e-02 /)
      kao(:, 1, 3, 7) = (/ &
        & 0.17389e-02,0.29833e-02,0.35894e-02,0.40314e-02,0.43535e-02, &
        & 0.45848e-02,0.47251e-02,0.47273e-02,0.37675e-02 /)
      kao(:, 2, 3, 7) = (/ &
        & 0.17511e-02,0.30210e-02,0.36487e-02,0.40996e-02,0.44314e-02, &
        & 0.46730e-02,0.48141e-02,0.48126e-02,0.38333e-02 /)
      kao(:, 3, 3, 7) = (/ &
        & 0.17713e-02,0.30646e-02,0.37133e-02,0.41800e-02,0.45216e-02, &
        & 0.47732e-02,0.49178e-02,0.49079e-02,0.39121e-02 /)
      kao(:, 4, 3, 7) = (/ &
        & 0.18058e-02,0.31149e-02,0.37889e-02,0.42777e-02,0.46349e-02, &
        & 0.48925e-02,0.50383e-02,0.50219e-02,0.40071e-02 /)
      kao(:, 5, 3, 7) = (/ &
        & 0.18379e-02,0.31573e-02,0.38545e-02,0.43660e-02,0.47479e-02, &
        & 0.50186e-02,0.51717e-02,0.51483e-02,0.41141e-02 /)
      kao(:, 1, 4, 7) = (/ &
        & 0.15760e-02,0.26881e-02,0.32116e-02,0.35706e-02,0.38258e-02, &
        & 0.39911e-02,0.40833e-02,0.40813e-02,0.32298e-02 /)
      kao(:, 2, 4, 7) = (/ &
        & 0.15813e-02,0.27249e-02,0.32627e-02,0.36295e-02,0.38889e-02, &
        & 0.40640e-02,0.41571e-02,0.41534e-02,0.32787e-02 /)
      kao(:, 3, 4, 7) = (/ &
        & 0.16001e-02,0.27603e-02,0.33193e-02,0.36971e-02,0.39631e-02, &
        & 0.41442e-02,0.42435e-02,0.42324e-02,0.33394e-02 /)
      kao(:, 4, 4, 7) = (/ &
        & 0.16258e-02,0.28020e-02,0.33780e-02,0.37750e-02,0.40494e-02, &
        & 0.42369e-02,0.43436e-02,0.43281e-02,0.34138e-02 /)
      kao(:, 5, 4, 7) = (/ &
        & 0.16664e-02,0.28640e-02,0.34503e-02,0.38637e-02,0.41572e-02, &
        & 0.43540e-02,0.44611e-02,0.44376e-02,0.34982e-02 /)
      kao(:, 1, 5, 7) = (/ &
        & 0.14233e-02,0.24061e-02,0.28484e-02,0.31675e-02,0.33803e-02, &
        & 0.35027e-02,0.35528e-02,0.35417e-02,0.27814e-02 /)
      kao(:, 2, 5, 7) = (/ &
        & 0.14350e-02,0.24395e-02,0.28937e-02,0.32168e-02,0.34318e-02, &
        & 0.35619e-02,0.36148e-02,0.35990e-02,0.28208e-02 /)
      kao(:, 3, 5, 7) = (/ &
        & 0.14521e-02,0.24725e-02,0.29512e-02,0.32733e-02,0.34917e-02, &
        & 0.36258e-02,0.36856e-02,0.36654e-02,0.28719e-02 /)
      kao(:, 4, 5, 7) = (/ &
        & 0.14701e-02,0.25117e-02,0.30081e-02,0.33364e-02,0.35619e-02, &
        & 0.37016e-02,0.37673e-02,0.37455e-02,0.29344e-02 /)
      kao(:, 5, 5, 7) = (/ &
        & 0.15037e-02,0.25667e-02,0.30753e-02,0.34136e-02,0.36518e-02, &
        & 0.37975e-02,0.38648e-02,0.38367e-02,0.30050e-02 /)
      kao(:, 1, 6, 7) = (/ &
        & 0.12833e-02,0.21397e-02,0.25249e-02,0.27989e-02,0.29941e-02, &
        & 0.30943e-02,0.31134e-02,0.30718e-02,0.23837e-02 /)
      kao(:, 2, 6, 7) = (/ &
        & 0.12955e-02,0.21689e-02,0.25640e-02,0.28465e-02,0.30386e-02, &
        & 0.31442e-02,0.31666e-02,0.31216e-02,0.24190e-02 /)
      kao(:, 3, 6, 7) = (/ &
        & 0.13128e-02,0.22001e-02,0.26092e-02,0.28949e-02,0.30875e-02, &
        & 0.31967e-02,0.32254e-02,0.31772e-02,0.24633e-02 /)
      kao(:, 4, 6, 7) = (/ &
        & 0.13321e-02,0.22373e-02,0.26583e-02,0.29483e-02,0.31454e-02, &
        & 0.32584e-02,0.32916e-02,0.32451e-02,0.25158e-02 /)
      kao(:, 5, 6, 7) = (/ &
        & 0.13570e-02,0.22801e-02,0.27142e-02,0.30110e-02,0.32147e-02, &
        & 0.33324e-02,0.33699e-02,0.33240e-02,0.25751e-02 /)
      kao(:, 1, 7, 7) = (/ &
        & 0.11500e-02,0.18956e-02,0.22352e-02,0.24771e-02,0.26462e-02, &
        & 0.27285e-02,0.27284e-02,0.26574e-02,0.20286e-02 /)
      kao(:, 2, 7, 7) = (/ &
        & 0.11641e-02,0.19221e-02,0.22681e-02,0.25137e-02,0.26876e-02, &
        & 0.27741e-02,0.27762e-02,0.27013e-02,0.20553e-02 /)
      kao(:, 3, 7, 7) = (/ &
        & 0.11813e-02,0.19513e-02,0.23065e-02,0.25547e-02,0.27305e-02, &
        & 0.28210e-02,0.28261e-02,0.27499e-02,0.20900e-02 /)
      kao(:, 4, 7, 7) = (/ &
        & 0.12020e-02,0.19854e-02,0.23499e-02,0.26064e-02,0.27813e-02, &
        & 0.28738e-02,0.28824e-02,0.28095e-02,0.21311e-02 /)
      kao(:, 5, 7, 7) = (/ &
        & 0.12251e-02,0.20252e-02,0.23984e-02,0.26618e-02,0.28401e-02, &
        & 0.29374e-02,0.29496e-02,0.28780e-02,0.21792e-02 /)
      kao(:, 1, 8, 7) = (/ &
        & 0.10232e-02,0.16906e-02,0.19769e-02,0.21832e-02,0.23202e-02, &
        & 0.23917e-02,0.23852e-02,0.22950e-02,0.17101e-02 /)
      kao(:, 2, 8, 7) = (/ &
        & 0.10391e-02,0.17050e-02,0.20071e-02,0.22179e-02,0.23606e-02, &
        & 0.24337e-02,0.24284e-02,0.23335e-02,0.17331e-02 /)
      kao(:, 3, 8, 7) = (/ &
        & 0.10558e-02,0.17304e-02,0.20412e-02,0.22560e-02,0.24048e-02, &
        & 0.24767e-02,0.24718e-02,0.23758e-02,0.17638e-02 /)
      kao(:, 4, 8, 7) = (/ &
        & 0.10757e-02,0.17611e-02,0.20788e-02,0.22974e-02,0.24509e-02, &
        & 0.25242e-02,0.25220e-02,0.24275e-02,0.17981e-02 /)
      kao(:, 5, 8, 7) = (/ &
        & 0.10980e-02,0.17974e-02,0.21207e-02,0.23464e-02,0.25025e-02, &
        & 0.25827e-02,0.25792e-02,0.24843e-02,0.18371e-02 /)
      kao(:, 1, 9, 7) = (/ &
        & 0.89817e-03,0.14995e-02,0.17424e-02,0.19141e-02,0.20277e-02, &
        & 0.20847e-02,0.20717e-02,0.19779e-02,0.16529e-02 /)
      kao(:, 2, 9, 7) = (/ &
        & 0.91497e-03,0.15202e-02,0.17713e-02,0.19473e-02,0.20642e-02, &
        & 0.21241e-02,0.21112e-02,0.20125e-02,0.16590e-02 /)
      kao(:, 3, 9, 7) = (/ &
        & 0.93269e-03,0.15411e-02,0.18029e-02,0.19839e-02,0.21017e-02, &
        & 0.21633e-02,0.21507e-02,0.20494e-02,0.16738e-02 /)
      kao(:, 4, 9, 7) = (/ &
        & 0.95304e-03,0.15646e-02,0.18368e-02,0.20225e-02,0.21451e-02, &
        & 0.22062e-02,0.21951e-02,0.20930e-02,0.16939e-02 /)
      kao(:, 5, 9, 7) = (/ &
        & 0.97498e-03,0.15941e-02,0.18742e-02,0.20657e-02,0.21958e-02, &
        & 0.22577e-02,0.22448e-02,0.21409e-02,0.17176e-02 /)
      kao(:, 1,10, 7) = (/ &
        & 0.79262e-03,0.13163e-02,0.15328e-02,0.16707e-02,0.17648e-02, &
        & 0.18068e-02,0.17935e-02,0.17058e-02,0.29700e-02 /)
      kao(:, 2,10, 7) = (/ &
        & 0.80762e-03,0.13411e-02,0.15596e-02,0.17027e-02,0.18000e-02, &
        & 0.18435e-02,0.18291e-02,0.17355e-02,0.28651e-02 /)
      kao(:, 3,10, 7) = (/ &
        & 0.82251e-03,0.13646e-02,0.15856e-02,0.17370e-02,0.18349e-02, &
        & 0.18799e-02,0.18643e-02,0.17669e-02,0.27637e-02 /)
      kao(:, 4,10, 7) = (/ &
        & 0.84077e-03,0.13892e-02,0.16170e-02,0.17747e-02,0.18736e-02, &
        & 0.19201e-02,0.19036e-02,0.18042e-02,0.26870e-02 /)
      kao(:, 5,10, 7) = (/ &
        & 0.86106e-03,0.14180e-02,0.16516e-02,0.18147e-02,0.19171e-02, &
        & 0.19660e-02,0.19468e-02,0.18451e-02,0.26342e-02 /)
      kao(:, 1,11, 7) = (/ &
        & 0.72744e-03,0.11669e-02,0.13481e-02,0.14590e-02,0.15393e-02, &
        & 0.15747e-02,0.15610e-02,0.14772e-02,0.38429e-02 /)
      kao(:, 2,11, 7) = (/ &
        & 0.73930e-03,0.11904e-02,0.13759e-02,0.14894e-02,0.15715e-02, &
        & 0.16066e-02,0.15925e-02,0.15038e-02,0.36308e-02 /)
      kao(:, 3,11, 7) = (/ &
        & 0.75350e-03,0.12120e-02,0.14044e-02,0.15240e-02,0.16053e-02, &
        & 0.16390e-02,0.16251e-02,0.15339e-02,0.34122e-02 /)
      kao(:, 4,11, 7) = (/ &
        & 0.76930e-03,0.12355e-02,0.14324e-02,0.15603e-02,0.16424e-02, &
        & 0.16774e-02,0.16611e-02,0.15677e-02,0.32391e-02 /)
      kao(:, 5,11, 7) = (/ &
        & 0.78824e-03,0.12645e-02,0.14660e-02,0.15998e-02,0.16846e-02, &
        & 0.17204e-02,0.17007e-02,0.16046e-02,0.31291e-02 /)
      kao(:, 1,12, 7) = (/ &
        & 0.66909e-03,0.10517e-02,0.11921e-02,0.12822e-02,0.13379e-02, &
        & 0.13630e-02,0.13492e-02,0.12752e-02,0.39255e-02 /)
      kao(:, 2,12, 7) = (/ &
        & 0.68372e-03,0.10717e-02,0.12175e-02,0.13089e-02,0.13666e-02, &
        & 0.13913e-02,0.13783e-02,0.12999e-02,0.37011e-02 /)
      kao(:, 3,12, 7) = (/ &
        & 0.69881e-03,0.10912e-02,0.12439e-02,0.13402e-02,0.13970e-02, &
        & 0.14222e-02,0.14099e-02,0.13279e-02,0.35002e-02 /)
      kao(:, 4,12, 7) = (/ &
        & 0.71487e-03,0.11132e-02,0.12732e-02,0.13738e-02,0.14317e-02, &
        & 0.14583e-02,0.14439e-02,0.13590e-02,0.33360e-02 /)
      kao(:, 5,12, 7) = (/ &
        & 0.73461e-03,0.11382e-02,0.13053e-02,0.14102e-02,0.14713e-02, &
        & 0.14974e-02,0.14808e-02,0.13924e-02,0.31844e-02 /)
      kao(:, 1,13, 7) = (/ &
        & 0.61282e-03,0.95575e-03,0.10730e-02,0.11388e-02,0.11718e-02, &
        & 0.11795e-02,0.11618e-02,0.10974e-02,0.34089e-02 /)
      kao(:, 2,13, 7) = (/ &
        & 0.62765e-03,0.97500e-03,0.10966e-02,0.11619e-02,0.11959e-02, &
        & 0.12054e-02,0.11876e-02,0.11206e-02,0.32141e-02 /)
      kao(:, 3,13, 7) = (/ &
        & 0.64409e-03,0.99523e-03,0.11197e-02,0.11873e-02,0.12235e-02, &
        & 0.12347e-02,0.12163e-02,0.11468e-02,0.30396e-02 /)
      kao(:, 4,13, 7) = (/ &
        & 0.66230e-03,0.10180e-02,0.11464e-02,0.12161e-02,0.12557e-02, &
        & 0.12667e-02,0.12475e-02,0.11749e-02,0.28911e-02 /)
      kao(:, 5,13, 7) = (/ &
        & 0.68383e-03,0.10452e-02,0.11767e-02,0.12484e-02,0.12902e-02, &
        & 0.13021e-02,0.12822e-02,0.12049e-02,0.27576e-02 /)
      kao(:, 1, 1, 8) = (/ &
        & 0.59073e-02,0.94320e-02,0.12084e-01,0.14049e-01,0.15571e-01, &
        & 0.16640e-01,0.17123e-01,0.16625e-01,0.14851e-01 /)
      kao(:, 2, 1, 8) = (/ &
        & 0.60213e-02,0.95565e-02,0.12218e-01,0.14200e-01,0.15736e-01, &
        & 0.16810e-01,0.17290e-01,0.16722e-01,0.14969e-01 /)
      kao(:, 3, 1, 8) = (/ &
        & 0.61698e-02,0.97176e-02,0.12383e-01,0.14381e-01,0.15939e-01, &
        & 0.17010e-01,0.17476e-01,0.16866e-01,0.15129e-01 /)
      kao(:, 4, 1, 8) = (/ &
        & 0.62862e-02,0.98624e-02,0.12544e-01,0.14586e-01,0.16163e-01, &
        & 0.17225e-01,0.17690e-01,0.17043e-01,0.15322e-01 /)
      kao(:, 5, 1, 8) = (/ &
        & 0.64346e-02,0.10033e-01,0.12746e-01,0.14817e-01,0.16408e-01, &
        & 0.17481e-01,0.17940e-01,0.17253e-01,0.15543e-01 /)
      kao(:, 1, 2, 8) = (/ &
        & 0.53740e-02,0.87218e-02,0.11053e-01,0.12810e-01,0.14176e-01, &
        & 0.15120e-01,0.15546e-01,0.15059e-01,0.12919e-01 /)
      kao(:, 2, 2, 8) = (/ &
        & 0.54730e-02,0.88522e-02,0.11203e-01,0.12984e-01,0.14363e-01, &
        & 0.15303e-01,0.15712e-01,0.15177e-01,0.13038e-01 /)
      kao(:, 3, 2, 8) = (/ &
        & 0.56074e-02,0.90112e-02,0.11386e-01,0.13184e-01,0.14577e-01, &
        & 0.15506e-01,0.15908e-01,0.15341e-01,0.13193e-01 /)
      kao(:, 4, 2, 8) = (/ &
        & 0.57291e-02,0.91663e-02,0.11581e-01,0.13408e-01,0.14805e-01, &
        & 0.15738e-01,0.16140e-01,0.15527e-01,0.13373e-01 /)
      kao(:, 5, 2, 8) = (/ &
        & 0.58374e-02,0.93237e-02,0.11790e-01,0.13642e-01,0.15063e-01, &
        & 0.16008e-01,0.16391e-01,0.15740e-01,0.13573e-01 /)
      kao(:, 1, 3, 8) = (/ &
        & 0.49151e-02,0.80083e-02,0.10006e-01,0.11528e-01,0.12727e-01, &
        & 0.13551e-01,0.13911e-01,0.13469e-01,0.11070e-01 /)
      kao(:, 2, 3, 8) = (/ &
        & 0.50045e-02,0.81384e-02,0.10158e-01,0.11712e-01,0.12918e-01, &
        & 0.13727e-01,0.14078e-01,0.13598e-01,0.11182e-01 /)
      kao(:, 3, 3, 8) = (/ &
        & 0.51018e-02,0.82774e-02,0.10333e-01,0.11906e-01,0.13128e-01, &
        & 0.13932e-01,0.14276e-01,0.13758e-01,0.11318e-01 /)
      kao(:, 4, 3, 8) = (/ &
        & 0.52290e-02,0.84457e-02,0.10545e-01,0.12130e-01,0.13362e-01, &
        & 0.14179e-01,0.14506e-01,0.13944e-01,0.11475e-01 /)
      kao(:, 5, 3, 8) = (/ &
        & 0.53219e-02,0.86004e-02,0.10753e-01,0.12365e-01,0.13624e-01, &
        & 0.14443e-01,0.14743e-01,0.14150e-01,0.11664e-01 /)
      kao(:, 1, 4, 8) = (/ &
        & 0.44996e-02,0.73324e-02,0.89976e-02,0.10282e-01,0.11291e-01, &
        & 0.11989e-01,0.12308e-01,0.11915e-01,0.94610e-02 /)
      kao(:, 2, 4, 8) = (/ &
        & 0.45903e-02,0.74608e-02,0.91511e-02,0.10467e-01,0.11476e-01, &
        & 0.12168e-01,0.12474e-01,0.12040e-01,0.95583e-02 /)
      kao(:, 3, 4, 8) = (/ &
        & 0.46786e-02,0.75960e-02,0.93200e-02,0.10651e-01,0.11685e-01, &
        & 0.12375e-01,0.12662e-01,0.12197e-01,0.96836e-02 /)
      kao(:, 4, 4, 8) = (/ &
        & 0.47771e-02,0.77407e-02,0.95085e-02,0.10860e-01,0.11915e-01, &
        & 0.12611e-01,0.12868e-01,0.12374e-01,0.98243e-02 /)
      kao(:, 5, 4, 8) = (/ &
        & 0.48920e-02,0.79194e-02,0.97305e-02,0.11107e-01,0.12174e-01, &
        & 0.12866e-01,0.13096e-01,0.12573e-01,0.99978e-02 /)
      kao(:, 1, 5, 8) = (/ &
        & 0.41203e-02,0.67057e-02,0.80820e-02,0.91247e-02,0.99321e-02, &
        & 0.10510e-01,0.10783e-01,0.10430e-01,0.81020e-02 /)
      kao(:, 2, 5, 8) = (/ &
        & 0.41993e-02,0.68279e-02,0.82322e-02,0.92959e-02,0.10115e-01, &
        & 0.10684e-01,0.10936e-01,0.10557e-01,0.81860e-02 /)
      kao(:, 3, 5, 8) = (/ &
        & 0.42833e-02,0.69588e-02,0.83884e-02,0.94726e-02,0.10319e-01, &
        & 0.10879e-01,0.11113e-01,0.10704e-01,0.82915e-02 /)
      kao(:, 4, 5, 8) = (/ &
        & 0.43800e-02,0.70975e-02,0.85585e-02,0.96769e-02,0.10538e-01, &
        & 0.11098e-01,0.11307e-01,0.10873e-01,0.84082e-02 /)
      kao(:, 5, 5, 8) = (/ &
        & 0.44913e-02,0.72638e-02,0.87668e-02,0.99106e-02,0.10776e-01, &
        & 0.11337e-01,0.11521e-01,0.11061e-01,0.85492e-02 /)
      kao(:, 1, 6, 8) = (/ &
        & 0.37432e-02,0.61135e-02,0.72507e-02,0.80822e-02,0.86984e-02, &
        & 0.91424e-02,0.93607e-02,0.90800e-02,0.69637e-02 /)
      kao(:, 2, 6, 8) = (/ &
        & 0.38232e-02,0.62277e-02,0.73923e-02,0.82383e-02,0.88666e-02, &
        & 0.93013e-02,0.95051e-02,0.91939e-02,0.70311e-02 /)
      kao(:, 3, 6, 8) = (/ &
        & 0.39028e-02,0.63516e-02,0.75330e-02,0.84072e-02,0.90542e-02, &
        & 0.94860e-02,0.96693e-02,0.93306e-02,0.71143e-02 /)
      kao(:, 4, 6, 8) = (/ &
        & 0.39917e-02,0.64850e-02,0.76893e-02,0.85935e-02,0.92562e-02, &
        & 0.96859e-02,0.98481e-02,0.94821e-02,0.72080e-02 /)
      kao(:, 5, 6, 8) = (/ &
        & 0.40851e-02,0.66256e-02,0.78694e-02,0.87911e-02,0.94733e-02, &
        & 0.99019e-02,0.10042e-01,0.96464e-02,0.73211e-02 /)
      kao(:, 1, 7, 8) = (/ &
        & 0.33812e-02,0.55475e-02,0.65017e-02,0.71556e-02,0.76235e-02, &
        & 0.79451e-02,0.81101e-02,0.78877e-02,0.60070e-02 /)
      kao(:, 2, 7, 8) = (/ &
        & 0.34581e-02,0.56575e-02,0.66301e-02,0.72977e-02,0.77709e-02, &
        & 0.80903e-02,0.82426e-02,0.79917e-02,0.60625e-02 /)
      kao(:, 3, 7, 8) = (/ &
        & 0.35355e-02,0.57759e-02,0.67602e-02,0.74532e-02,0.79395e-02, &
        & 0.82549e-02,0.83890e-02,0.81121e-02,0.61274e-02 /)
      kao(:, 4, 7, 8) = (/ &
        & 0.36191e-02,0.58987e-02,0.69034e-02,0.76219e-02,0.81209e-02, &
        & 0.84343e-02,0.85495e-02,0.82395e-02,0.62026e-02 /)
      kao(:, 5, 7, 8) = (/ &
        & 0.37084e-02,0.60308e-02,0.70671e-02,0.77977e-02,0.83160e-02, &
        & 0.86266e-02,0.87205e-02,0.83802e-02,0.62947e-02 /)
      kao(:, 1, 8, 8) = (/ &
        & 0.30376e-02,0.49774e-02,0.58172e-02,0.63470e-02,0.67038e-02, &
        & 0.69396e-02,0.70412e-02,0.68509e-02,0.51374e-02 /)
      kao(:, 2, 8, 8) = (/ &
        & 0.31099e-02,0.50996e-02,0.59344e-02,0.64736e-02,0.68367e-02, &
        & 0.70701e-02,0.71564e-02,0.69425e-02,0.51813e-02 /)
      kao(:, 3, 8, 8) = (/ &
        & 0.31853e-02,0.52155e-02,0.60541e-02,0.66147e-02,0.69858e-02, &
        & 0.72120e-02,0.72858e-02,0.70465e-02,0.52319e-02 /)
      kao(:, 4, 8, 8) = (/ &
        & 0.32663e-02,0.53312e-02,0.61863e-02,0.67654e-02,0.71468e-02, &
        & 0.73677e-02,0.74252e-02,0.71560e-02,0.52932e-02 /)
      kao(:, 5, 8, 8) = (/ &
        & 0.33510e-02,0.54583e-02,0.63345e-02,0.69235e-02,0.73170e-02, &
        & 0.75339e-02,0.75720e-02,0.72770e-02,0.53726e-02 /)
      kao(:, 1, 9, 8) = (/ &
        & 0.27168e-02,0.44406e-02,0.51768e-02,0.56339e-02,0.59208e-02, &
        & 0.60958e-02,0.61438e-02,0.59554e-02,0.42511e-02 /)
      kao(:, 2, 9, 8) = (/ &
        & 0.27853e-02,0.45486e-02,0.52870e-02,0.57491e-02,0.60397e-02, &
        & 0.62076e-02,0.62421e-02,0.60358e-02,0.42982e-02 /)
      kao(:, 3, 9, 8) = (/ &
        & 0.28572e-02,0.46609e-02,0.53998e-02,0.58755e-02,0.61719e-02, &
        & 0.63300e-02,0.63536e-02,0.61272e-02,0.43479e-02 /)
      kao(:, 4, 9, 8) = (/ &
        & 0.29351e-02,0.47766e-02,0.55244e-02,0.60103e-02,0.63121e-02, &
        & 0.64656e-02,0.64718e-02,0.62231e-02,0.44012e-02 /)
      kao(:, 5, 9, 8) = (/ &
        & 0.30174e-02,0.49013e-02,0.56608e-02,0.61542e-02,0.64584e-02, &
        & 0.66094e-02,0.65960e-02,0.63252e-02,0.44655e-02 /)
      kao(:, 1,10, 8) = (/ &
        & 0.24055e-02,0.39503e-02,0.45833e-02,0.49951e-02,0.52507e-02, &
        & 0.53857e-02,0.53791e-02,0.51629e-02,0.55379e-02 /)
      kao(:, 2,10, 8) = (/ &
        & 0.24728e-02,0.40487e-02,0.46867e-02,0.51042e-02,0.53576e-02, &
        & 0.54844e-02,0.54704e-02,0.52383e-02,0.55398e-02 /)
      kao(:, 3,10, 8) = (/ &
        & 0.25454e-02,0.41511e-02,0.48010e-02,0.52206e-02,0.54751e-02, &
        & 0.55927e-02,0.55711e-02,0.53216e-02,0.55501e-02 /)
      kao(:, 4,10, 8) = (/ &
        & 0.26224e-02,0.42542e-02,0.49201e-02,0.53438e-02,0.55977e-02, &
        & 0.57114e-02,0.56753e-02,0.54074e-02,0.55558e-02 /)
      kao(:, 5,10, 8) = (/ &
        & 0.27039e-02,0.43672e-02,0.50470e-02,0.54750e-02,0.57276e-02, &
        & 0.58363e-02,0.57849e-02,0.54996e-02,0.55710e-02 /)
      kao(:, 1,11, 8) = (/ &
        & 0.21256e-02,0.35221e-02,0.40853e-02,0.44612e-02,0.46874e-02, &
        & 0.47866e-02,0.47389e-02,0.44975e-02,0.66135e-02 /)
      kao(:, 2,11, 8) = (/ &
        & 0.21937e-02,0.36149e-02,0.41854e-02,0.45677e-02,0.47907e-02, &
        & 0.48833e-02,0.48291e-02,0.45707e-02,0.65729e-02 /)
      kao(:, 3,11, 8) = (/ &
        & 0.22650e-02,0.37098e-02,0.42933e-02,0.46764e-02,0.49020e-02, &
        & 0.49895e-02,0.49234e-02,0.46462e-02,0.65598e-02 /)
      kao(:, 4,11, 8) = (/ &
        & 0.23425e-02,0.38113e-02,0.44107e-02,0.47931e-02,0.50165e-02, &
        & 0.51000e-02,0.50211e-02,0.47251e-02,0.65419e-02 /)
      kao(:, 5,11, 8) = (/ &
        & 0.24251e-02,0.39222e-02,0.45344e-02,0.49164e-02,0.51382e-02, &
        & 0.52156e-02,0.51233e-02,0.48118e-02,0.65404e-02 /)
      kao(:, 1,12, 8) = (/ &
        & 0.19014e-02,0.31169e-02,0.36336e-02,0.39642e-02,0.41602e-02, &
        & 0.42352e-02,0.41726e-02,0.39183e-02,0.68121e-02 /)
      kao(:, 2,12, 8) = (/ &
        & 0.19605e-02,0.32068e-02,0.37314e-02,0.40676e-02,0.42627e-02, &
        & 0.43333e-02,0.42591e-02,0.39851e-02,0.67229e-02 /)
      kao(:, 3,12, 8) = (/ &
        & 0.20227e-02,0.33010e-02,0.38333e-02,0.41743e-02,0.43708e-02, &
        & 0.44355e-02,0.43461e-02,0.40520e-02,0.66419e-02 /)
      kao(:, 4,12, 8) = (/ &
        & 0.20945e-02,0.34006e-02,0.39411e-02,0.42851e-02,0.44804e-02, &
        & 0.45405e-02,0.44353e-02,0.41230e-02,0.65948e-02 /)
      kao(:, 5,12, 8) = (/ &
        & 0.21695e-02,0.35114e-02,0.40581e-02,0.44020e-02,0.45960e-02, &
        & 0.46501e-02,0.45319e-02,0.42045e-02,0.65716e-02 /)
      kao(:, 1,13, 8) = (/ &
        & 0.17348e-02,0.27575e-02,0.32033e-02,0.34905e-02,0.36669e-02, &
        & 0.37299e-02,0.36615e-02,0.34092e-02,0.62173e-02 /)
      kao(:, 2,13, 8) = (/ &
        & 0.17868e-02,0.28403e-02,0.32978e-02,0.35924e-02,0.37684e-02, &
        & 0.38248e-02,0.37430e-02,0.34686e-02,0.61248e-02 /)
      kao(:, 3,13, 8) = (/ &
        & 0.18438e-02,0.29272e-02,0.33982e-02,0.36985e-02,0.38711e-02, &
        & 0.39210e-02,0.38240e-02,0.35286e-02,0.60637e-02 /)
      kao(:, 4,13, 8) = (/ &
        & 0.19066e-02,0.30192e-02,0.35016e-02,0.38072e-02,0.39764e-02, &
        & 0.40199e-02,0.39089e-02,0.35954e-02,0.60138e-02 /)
      kao(:, 5,13, 8) = (/ &
        & 0.19732e-02,0.31237e-02,0.36129e-02,0.39207e-02,0.40892e-02, &
        & 0.41240e-02,0.40022e-02,0.36721e-02,0.59944e-02 /)
      kao(:, 1, 1, 9) = (/ &
        & 0.41219e-01,0.41795e-01,0.46848e-01,0.50877e-01,0.53437e-01, &
        & 0.54488e-01,0.53560e-01,0.50235e-01,0.51545e-01 /)
      kao(:, 2, 1, 9) = (/ &
        & 0.42156e-01,0.42406e-01,0.47180e-01,0.51006e-01,0.53354e-01, &
        & 0.54221e-01,0.53185e-01,0.49897e-01,0.51289e-01 /)
      kao(:, 3, 1, 9) = (/ &
        & 0.43082e-01,0.43034e-01,0.47543e-01,0.51133e-01,0.53289e-01, &
        & 0.53978e-01,0.52866e-01,0.49591e-01,0.51083e-01 /)
      kao(:, 4, 1, 9) = (/ &
        & 0.43908e-01,0.43606e-01,0.47876e-01,0.51241e-01,0.53225e-01, &
        & 0.53768e-01,0.52555e-01,0.49365e-01,0.51010e-01 /)
      kao(:, 5, 1, 9) = (/ &
        & 0.44717e-01,0.44169e-01,0.48160e-01,0.51395e-01,0.53206e-01, &
        & 0.53607e-01,0.52301e-01,0.49268e-01,0.51108e-01 /)
      kao(:, 1, 2, 9) = (/ &
        & 0.38280e-01,0.40368e-01,0.46271e-01,0.50387e-01,0.53287e-01, &
        & 0.54294e-01,0.53147e-01,0.49359e-01,0.49444e-01 /)
      kao(:, 2, 2, 9) = (/ &
        & 0.39278e-01,0.41016e-01,0.46659e-01,0.50565e-01,0.53249e-01, &
        & 0.54064e-01,0.52823e-01,0.49016e-01,0.49210e-01 /)
      kao(:, 3, 2, 9) = (/ &
        & 0.40252e-01,0.41678e-01,0.47048e-01,0.50745e-01,0.53223e-01, &
        & 0.53871e-01,0.52519e-01,0.48730e-01,0.49081e-01 /)
      kao(:, 4, 2, 9) = (/ &
        & 0.41132e-01,0.42274e-01,0.47387e-01,0.50925e-01,0.53214e-01, &
        & 0.53693e-01,0.52217e-01,0.48559e-01,0.49102e-01 /)
      kao(:, 5, 2, 9) = (/ &
        & 0.41937e-01,0.42806e-01,0.47675e-01,0.51115e-01,0.53221e-01, &
        & 0.53535e-01,0.52007e-01,0.48511e-01,0.49285e-01 /)
      kao(:, 1, 3, 9) = (/ &
        & 0.35016e-01,0.38740e-01,0.45035e-01,0.49481e-01,0.52517e-01, &
        & 0.53496e-01,0.52191e-01,0.48044e-01,0.46584e-01 /)
      kao(:, 2, 3, 9) = (/ &
        & 0.36031e-01,0.39393e-01,0.45463e-01,0.49713e-01,0.52514e-01, &
        & 0.53329e-01,0.51912e-01,0.47725e-01,0.46413e-01 /)
      kao(:, 3, 3, 9) = (/ &
        & 0.36991e-01,0.40024e-01,0.45863e-01,0.49943e-01,0.52531e-01, &
        & 0.53167e-01,0.51622e-01,0.47472e-01,0.46354e-01 /)
      kao(:, 4, 3, 9) = (/ &
        & 0.37902e-01,0.40620e-01,0.46253e-01,0.50181e-01,0.52583e-01, &
        & 0.53007e-01,0.51384e-01,0.47335e-01,0.46441e-01 /)
      kao(:, 5, 3, 9) = (/ &
        & 0.38707e-01,0.41126e-01,0.46598e-01,0.50384e-01,0.52633e-01, &
        & 0.52879e-01,0.51240e-01,0.47311e-01,0.46661e-01 /)
      kao(:, 1, 4, 9) = (/ &
        & 0.31672e-01,0.36966e-01,0.43365e-01,0.48073e-01,0.51081e-01, &
        & 0.52063e-01,0.50596e-01,0.46210e-01,0.43228e-01 /)
      kao(:, 2, 4, 9) = (/ &
        & 0.32685e-01,0.37616e-01,0.43827e-01,0.48349e-01,0.51147e-01, &
        & 0.51967e-01,0.50386e-01,0.45960e-01,0.43137e-01 /)
      kao(:, 3, 4, 9) = (/ &
        & 0.33628e-01,0.38241e-01,0.44270e-01,0.48639e-01,0.51209e-01, &
        & 0.51848e-01,0.50172e-01,0.45771e-01,0.43147e-01 /)
      kao(:, 4, 4, 9) = (/ &
        & 0.34503e-01,0.38804e-01,0.44698e-01,0.48896e-01,0.51278e-01, &
        & 0.51724e-01,0.50016e-01,0.45686e-01,0.43281e-01 /)
      kao(:, 5, 4, 9) = (/ &
        & 0.35339e-01,0.39319e-01,0.45124e-01,0.49160e-01,0.51368e-01, &
        & 0.51672e-01,0.49945e-01,0.45702e-01,0.43520e-01 /)
      kao(:, 1, 5, 9) = (/ &
        & 0.28453e-01,0.34915e-01,0.41400e-01,0.46104e-01,0.49014e-01, &
        & 0.49952e-01,0.48370e-01,0.43932e-01,0.39569e-01 /)
      kao(:, 2, 5, 9) = (/ &
        & 0.29434e-01,0.35588e-01,0.41893e-01,0.46437e-01,0.49144e-01, &
        & 0.49919e-01,0.48254e-01,0.43775e-01,0.39548e-01 /)
      kao(:, 3, 5, 9) = (/ &
        & 0.30340e-01,0.36236e-01,0.42373e-01,0.46769e-01,0.49255e-01, &
        & 0.49873e-01,0.48133e-01,0.43667e-01,0.39610e-01 /)
      kao(:, 4, 5, 9) = (/ &
        & 0.31178e-01,0.36810e-01,0.42835e-01,0.47061e-01,0.49370e-01, &
        & 0.49827e-01,0.48071e-01,0.43623e-01,0.39779e-01 /)
      kao(:, 5, 5, 9) = (/ &
        & 0.31999e-01,0.37346e-01,0.43284e-01,0.47361e-01,0.49516e-01, &
        & 0.49857e-01,0.48088e-01,0.43666e-01,0.40037e-01 /)
      kao(:, 1, 6, 9) = (/ &
        & 0.25421e-01,0.32626e-01,0.39116e-01,0.43609e-01,0.46371e-01, &
        & 0.47186e-01,0.45634e-01,0.41276e-01,0.35722e-01 /)
      kao(:, 2, 6, 9) = (/ &
        & 0.26347e-01,0.33315e-01,0.39629e-01,0.44004e-01,0.46570e-01, &
        & 0.47251e-01,0.45602e-01,0.41217e-01,0.35770e-01 /)
      kao(:, 3, 6, 9) = (/ &
        & 0.27211e-01,0.33965e-01,0.40142e-01,0.44371e-01,0.46737e-01, &
        & 0.47271e-01,0.45579e-01,0.41184e-01,0.35883e-01 /)
      kao(:, 4, 6, 9) = (/ &
        & 0.28013e-01,0.34546e-01,0.40641e-01,0.44704e-01,0.46903e-01, &
        & 0.47305e-01,0.45608e-01,0.41201e-01,0.36071e-01 /)
      kao(:, 5, 6, 9) = (/ &
        & 0.28777e-01,0.35080e-01,0.41083e-01,0.45018e-01,0.47083e-01, &
        & 0.47404e-01,0.45685e-01,0.41273e-01,0.36328e-01 /)
      kao(:, 1, 7, 9) = (/ &
        & 0.22628e-01,0.30290e-01,0.36520e-01,0.40736e-01,0.43195e-01, &
        & 0.43894e-01,0.42478e-01,0.38357e-01,0.31858e-01 /)
      kao(:, 2, 7, 9) = (/ &
        & 0.23496e-01,0.30981e-01,0.37071e-01,0.41159e-01,0.43459e-01, &
        & 0.44039e-01,0.42534e-01,0.38366e-01,0.31954e-01 /)
      kao(:, 3, 7, 9) = (/ &
        & 0.24311e-01,0.31616e-01,0.37614e-01,0.41552e-01,0.43690e-01, &
        & 0.44135e-01,0.42598e-01,0.38398e-01,0.32112e-01 /)
      kao(:, 4, 7, 9) = (/ &
        & 0.25081e-01,0.32194e-01,0.38124e-01,0.41906e-01,0.43917e-01, &
        & 0.44249e-01,0.42700e-01,0.38476e-01,0.32312e-01 /)
      kao(:, 5, 7, 9) = (/ &
        & 0.25796e-01,0.32737e-01,0.38583e-01,0.42251e-01,0.44147e-01, &
        & 0.44425e-01,0.42840e-01,0.38587e-01,0.32545e-01 /)
      kao(:, 1, 8, 9) = (/ &
        & 0.20122e-01,0.27995e-01,0.33719e-01,0.37485e-01,0.39621e-01, &
        & 0.40226e-01,0.38971e-01,0.35214e-01,0.28110e-01 /)
      kao(:, 2, 8, 9) = (/ &
        & 0.20930e-01,0.28671e-01,0.34304e-01,0.37966e-01,0.39957e-01, &
        & 0.40447e-01,0.39124e-01,0.35304e-01,0.28246e-01 /)
      kao(:, 3, 8, 9) = (/ &
        & 0.21692e-01,0.29291e-01,0.34870e-01,0.38392e-01,0.40254e-01, &
        & 0.40624e-01,0.39266e-01,0.35403e-01,0.28424e-01 /)
      kao(:, 4, 8, 9) = (/ &
        & 0.22396e-01,0.29880e-01,0.35388e-01,0.38779e-01,0.40528e-01, &
        & 0.40815e-01,0.39436e-01,0.35538e-01,0.28597e-01 /)
      kao(:, 5, 8, 9) = (/ &
        & 0.23064e-01,0.30402e-01,0.35848e-01,0.39151e-01,0.40824e-01, &
        & 0.41057e-01,0.39639e-01,0.35669e-01,0.28823e-01 /)
      kao(:, 1, 9, 9) = (/ &
        & 0.17909e-01,0.25709e-01,0.30840e-01,0.34036e-01,0.35851e-01, &
        & 0.36360e-01,0.35282e-01,0.31947e-01,0.24003e-01 /)
      kao(:, 2, 9, 9) = (/ &
        & 0.18652e-01,0.26369e-01,0.31431e-01,0.34542e-01,0.36244e-01, &
        & 0.36648e-01,0.35513e-01,0.32109e-01,0.24164e-01 /)
      kao(:, 3, 9, 9) = (/ &
        & 0.19344e-01,0.26986e-01,0.31997e-01,0.35005e-01,0.36599e-01, &
        & 0.36904e-01,0.35718e-01,0.32277e-01,0.24318e-01 /)
      kao(:, 4, 9, 9) = (/ &
        & 0.19991e-01,0.27565e-01,0.32506e-01,0.35425e-01,0.36934e-01, &
        & 0.37163e-01,0.35949e-01,0.32440e-01,0.24470e-01 /)
      kao(:, 5, 9, 9) = (/ &
        & 0.20615e-01,0.28069e-01,0.32961e-01,0.35817e-01,0.37281e-01, &
        & 0.37462e-01,0.36191e-01,0.32591e-01,0.24688e-01 /)
      kao(:, 1,10, 9) = (/ &
        & 0.16038e-01,0.23520e-01,0.27944e-01,0.30612e-01,0.32108e-01, &
        & 0.32531e-01,0.31594e-01,0.28710e-01,0.19040e-01 /)
      kao(:, 2,10, 9) = (/ &
        & 0.16702e-01,0.24155e-01,0.28537e-01,0.31140e-01,0.32544e-01, &
        & 0.32858e-01,0.31863e-01,0.28938e-01,0.19154e-01 /)
      kao(:, 3,10, 9) = (/ &
        & 0.17329e-01,0.24747e-01,0.29094e-01,0.31618e-01,0.32949e-01, &
        & 0.33160e-01,0.32119e-01,0.29151e-01,0.19214e-01 /)
      kao(:, 4,10, 9) = (/ &
        & 0.17922e-01,0.25302e-01,0.29595e-01,0.32058e-01,0.33330e-01, &
        & 0.33472e-01,0.32385e-01,0.29320e-01,0.19269e-01 /)
      kao(:, 5,10, 9) = (/ &
        & 0.18489e-01,0.25799e-01,0.30045e-01,0.32466e-01,0.33700e-01, &
        & 0.33812e-01,0.32629e-01,0.29481e-01,0.19405e-01 /)
      kao(:, 1,11, 9) = (/ &
        & 0.14687e-01,0.21702e-01,0.25384e-01,0.27570e-01,0.28760e-01, &
        & 0.29017e-01,0.28178e-01,0.25716e-01,0.20195e-01 /)
      kao(:, 2,11, 9) = (/ &
        & 0.15274e-01,0.22296e-01,0.25944e-01,0.28087e-01,0.29202e-01, &
        & 0.29352e-01,0.28471e-01,0.25960e-01,0.20265e-01 /)
      kao(:, 3,11, 9) = (/ &
        & 0.15835e-01,0.22836e-01,0.26465e-01,0.28550e-01,0.29611e-01, &
        & 0.29694e-01,0.28754e-01,0.26152e-01,0.20296e-01 /)
      kao(:, 4,11, 9) = (/ &
        & 0.16357e-01,0.23338e-01,0.26927e-01,0.28982e-01,0.29998e-01, &
        & 0.30045e-01,0.29008e-01,0.26312e-01,0.20131e-01 /)
      kao(:, 5,11, 9) = (/ &
        & 0.16879e-01,0.23791e-01,0.27359e-01,0.29394e-01,0.30387e-01, &
        & 0.30372e-01,0.29268e-01,0.26507e-01,0.20180e-01 /)
      kao(:, 1,12, 9) = (/ &
        & 0.13435e-01,0.19917e-01,0.22947e-01,0.24741e-01,0.25656e-01, &
        & 0.25762e-01,0.25010e-01,0.22879e-01,0.21935e-01 /)
      kao(:, 2,12, 9) = (/ &
        & 0.13973e-01,0.20460e-01,0.23475e-01,0.25221e-01,0.26084e-01, &
        & 0.26126e-01,0.25297e-01,0.23091e-01,0.22096e-01 /)
      kao(:, 3,12, 9) = (/ &
        & 0.14481e-01,0.20956e-01,0.23951e-01,0.25665e-01,0.26486e-01, &
        & 0.26478e-01,0.25558e-01,0.23263e-01,0.22257e-01 /)
      kao(:, 4,12, 9) = (/ &
        & 0.14966e-01,0.21408e-01,0.24388e-01,0.26079e-01,0.26872e-01, &
        & 0.26802e-01,0.25814e-01,0.23444e-01,0.22244e-01 /)
      kao(:, 5,12, 9) = (/ &
        & 0.15448e-01,0.21834e-01,0.24813e-01,0.26492e-01,0.27230e-01, &
        & 0.27128e-01,0.26103e-01,0.23676e-01,0.22318e-01 /)
      kao(:, 1,13, 9) = (/ &
        & 0.12253e-01,0.18169e-01,0.20712e-01,0.22143e-01,0.22829e-01, &
        & 0.22840e-01,0.22092e-01,0.20210e-01,0.22350e-01 /)
      kao(:, 2,13, 9) = (/ &
        & 0.12752e-01,0.18675e-01,0.21188e-01,0.22590e-01,0.23242e-01, &
        & 0.23184e-01,0.22356e-01,0.20395e-01,0.22569e-01 /)
      kao(:, 3,13, 9) = (/ &
        & 0.13220e-01,0.19134e-01,0.21627e-01,0.23007e-01,0.23621e-01, &
        & 0.23502e-01,0.22612e-01,0.20571e-01,0.22750e-01 /)
      kao(:, 4,13, 9) = (/ &
        & 0.13675e-01,0.19566e-01,0.22044e-01,0.23405e-01,0.23969e-01, &
        & 0.23813e-01,0.22875e-01,0.20780e-01,0.22726e-01 /)
      kao(:, 5,13, 9) = (/ &
        & 0.14122e-01,0.19976e-01,0.22454e-01,0.23786e-01,0.24318e-01, &
        & 0.24140e-01,0.23183e-01,0.21041e-01,0.22784e-01 /)
      kao(:, 1, 1,10) = (/ &
        & 0.14776e+00,0.13250e+00,0.11877e+00,0.11907e+00,0.11538e+00, &
        & 0.11234e+00,0.10926e+00,0.11039e+00,0.12102e+00 /)
      kao(:, 2, 1,10) = (/ &
        & 0.14758e+00,0.13180e+00,0.11760e+00,0.11720e+00,0.11379e+00, &
        & 0.11206e+00,0.10856e+00,0.11029e+00,0.12093e+00 /)
      kao(:, 3, 1,10) = (/ &
        & 0.14691e+00,0.13078e+00,0.11629e+00,0.11563e+00,0.11248e+00, &
        & 0.11149e+00,0.10785e+00,0.11040e+00,0.12104e+00 /)
      kao(:, 4, 1,10) = (/ &
        & 0.14609e+00,0.12985e+00,0.11503e+00,0.11426e+00,0.11150e+00, &
        & 0.11061e+00,0.10739e+00,0.11031e+00,0.12092e+00 /)
      kao(:, 5, 1,10) = (/ &
        & 0.14529e+00,0.12911e+00,0.11448e+00,0.11310e+00,0.11058e+00, &
        & 0.10959e+00,0.10721e+00,0.11007e+00,0.12050e+00 /)
      kao(:, 1, 2,10) = (/ &
        & 0.14616e+00,0.13131e+00,0.12350e+00,0.12510e+00,0.11934e+00, &
        & 0.11762e+00,0.11417e+00,0.11460e+00,0.12626e+00 /)
      kao(:, 2, 2,10) = (/ &
        & 0.14607e+00,0.13063e+00,0.12202e+00,0.12312e+00,0.11789e+00, &
        & 0.11742e+00,0.11363e+00,0.11470e+00,0.12636e+00 /)
      kao(:, 3, 2,10) = (/ &
        & 0.14577e+00,0.12991e+00,0.12074e+00,0.12132e+00,0.11671e+00, &
        & 0.11676e+00,0.11334e+00,0.11448e+00,0.12602e+00 /)
      kao(:, 4, 2,10) = (/ &
        & 0.14549e+00,0.12948e+00,0.11982e+00,0.11971e+00,0.11561e+00, &
        & 0.11583e+00,0.11311e+00,0.11380e+00,0.12515e+00 /)
      kao(:, 5, 2,10) = (/ &
        & 0.14518e+00,0.12921e+00,0.11930e+00,0.11856e+00,0.11453e+00, &
        & 0.11499e+00,0.11278e+00,0.11303e+00,0.12425e+00 /)
      kao(:, 1, 3,10) = (/ &
        & 0.14318e+00,0.12893e+00,0.12918e+00,0.12942e+00,0.12491e+00, &
        & 0.12238e+00,0.11842e+00,0.11706e+00,0.12892e+00 /)
      kao(:, 2, 3,10) = (/ &
        & 0.14362e+00,0.12877e+00,0.12794e+00,0.12738e+00,0.12367e+00, &
        & 0.12214e+00,0.11818e+00,0.11730e+00,0.12892e+00 /)
      kao(:, 3, 3,10) = (/ &
        & 0.14392e+00,0.12859e+00,0.12673e+00,0.12555e+00,0.12238e+00, &
        & 0.12154e+00,0.11804e+00,0.11693e+00,0.12825e+00 /)
      kao(:, 4, 3,10) = (/ &
        & 0.14418e+00,0.12858e+00,0.12588e+00,0.12406e+00,0.12111e+00, &
        & 0.12100e+00,0.11768e+00,0.11605e+00,0.12723e+00 /)
      kao(:, 5, 3,10) = (/ &
        & 0.14433e+00,0.12868e+00,0.12520e+00,0.12307e+00,0.11981e+00, &
        & 0.12050e+00,0.11702e+00,0.11519e+00,0.12642e+00 /)
      kao(:, 1, 4,10) = (/ &
        & 0.13900e+00,0.12627e+00,0.13262e+00,0.13246e+00,0.13018e+00, &
        & 0.12656e+00,0.12207e+00,0.11856e+00,0.12927e+00 /)
      kao(:, 2, 4,10) = (/ &
        & 0.13981e+00,0.12631e+00,0.13168e+00,0.13063e+00,0.12928e+00, &
        & 0.12634e+00,0.12180e+00,0.11842e+00,0.12888e+00 /)
      kao(:, 3, 4,10) = (/ &
        & 0.14055e+00,0.12635e+00,0.13064e+00,0.12886e+00,0.12826e+00, &
        & 0.12591e+00,0.12147e+00,0.11781e+00,0.12798e+00 /)
      kao(:, 4, 4,10) = (/ &
        & 0.14115e+00,0.12659e+00,0.12979e+00,0.12765e+00,0.12712e+00, &
        & 0.12539e+00,0.12094e+00,0.11686e+00,0.12709e+00 /)
      kao(:, 5, 4,10) = (/ &
        & 0.14205e+00,0.12716e+00,0.12897e+00,0.12678e+00,0.12607e+00, &
        & 0.12463e+00,0.12022e+00,0.11611e+00,0.12648e+00 /)
      kao(:, 1, 5,10) = (/ &
        & 0.13267e+00,0.12451e+00,0.13264e+00,0.13467e+00,0.13410e+00, &
        & 0.12976e+00,0.12532e+00,0.11842e+00,0.12663e+00 /)
      kao(:, 2, 5,10) = (/ &
        & 0.13391e+00,0.12448e+00,0.13222e+00,0.13349e+00,0.13365e+00, &
        & 0.12967e+00,0.12478e+00,0.11793e+00,0.12610e+00 /)
      kao(:, 3, 5,10) = (/ &
        & 0.13513e+00,0.12441e+00,0.13150e+00,0.13226e+00,0.13285e+00, &
        & 0.12935e+00,0.12414e+00,0.11714e+00,0.12535e+00 /)
      kao(:, 4, 5,10) = (/ &
        & 0.13635e+00,0.12468e+00,0.13071e+00,0.13132e+00,0.13192e+00, &
        & 0.12883e+00,0.12325e+00,0.11628e+00,0.12465e+00 /)
      kao(:, 5, 5,10) = (/ &
        & 0.13765e+00,0.12523e+00,0.12989e+00,0.13067e+00,0.13104e+00, &
        & 0.12778e+00,0.12230e+00,0.11574e+00,0.12447e+00 /)
      kao(:, 1, 6,10) = (/ &
        & 0.12480e+00,0.12304e+00,0.13086e+00,0.13535e+00,0.13580e+00, &
        & 0.13244e+00,0.12684e+00,0.11687e+00,0.12150e+00 /)
      kao(:, 2, 6,10) = (/ &
        & 0.12631e+00,0.12320e+00,0.13089e+00,0.13488e+00,0.13591e+00, &
        & 0.13240e+00,0.12644e+00,0.11610e+00,0.12096e+00 /)
      kao(:, 3, 6,10) = (/ &
        & 0.12783e+00,0.12334e+00,0.13031e+00,0.13415e+00,0.13555e+00, &
        & 0.13212e+00,0.12571e+00,0.11517e+00,0.12033e+00 /)
      kao(:, 4, 6,10) = (/ &
        & 0.12946e+00,0.12375e+00,0.12962e+00,0.13360e+00,0.13480e+00, &
        & 0.13147e+00,0.12458e+00,0.11440e+00,0.12012e+00 /)
      kao(:, 5, 6,10) = (/ &
        & 0.13098e+00,0.12424e+00,0.12926e+00,0.13328e+00,0.13390e+00, &
        & 0.13035e+00,0.12352e+00,0.11410e+00,0.12034e+00 /)
      kao(:, 1, 7,10) = (/ &
        & 0.11587e+00,0.11977e+00,0.12827e+00,0.13413e+00,0.13637e+00, &
        & 0.13338e+00,0.12607e+00,0.11369e+00,0.11422e+00 /)
      kao(:, 2, 7,10) = (/ &
        & 0.11755e+00,0.12008e+00,0.12851e+00,0.13433e+00,0.13653e+00, &
        & 0.13350e+00,0.12579e+00,0.11303e+00,0.11384e+00 /)
      kao(:, 3, 7,10) = (/ &
        & 0.11925e+00,0.12045e+00,0.12827e+00,0.13401e+00,0.13627e+00, &
        & 0.13335e+00,0.12531e+00,0.11227e+00,0.11342e+00 /)
      kao(:, 4, 7,10) = (/ &
        & 0.12111e+00,0.12107e+00,0.12798e+00,0.13385e+00,0.13564e+00, &
        & 0.13268e+00,0.12424e+00,0.11167e+00,0.11355e+00 /)
      kao(:, 5, 7,10) = (/ &
        & 0.12285e+00,0.12168e+00,0.12798e+00,0.13376e+00,0.13482e+00, &
        & 0.13151e+00,0.12334e+00,0.11149e+00,0.11415e+00 /)
      kao(:, 1, 8,10) = (/ &
        & 0.10591e+00,0.11393e+00,0.12456e+00,0.13177e+00,0.13532e+00, &
        & 0.13189e+00,0.12388e+00,0.10965e+00,0.10563e+00 /)
      kao(:, 2, 8,10) = (/ &
        & 0.10784e+00,0.11446e+00,0.12497e+00,0.13191e+00,0.13527e+00, &
        & 0.13206e+00,0.12372e+00,0.10901e+00,0.10541e+00 /)
      kao(:, 3, 8,10) = (/ &
        & 0.10982e+00,0.11499e+00,0.12496e+00,0.13190e+00,0.13491e+00, &
        & 0.13198e+00,0.12329e+00,0.10836e+00,0.10528e+00 /)
      kao(:, 4, 8,10) = (/ &
        & 0.11183e+00,0.11569e+00,0.12499e+00,0.13184e+00,0.13435e+00, &
        & 0.13149e+00,0.12252e+00,0.10787e+00,0.10590e+00 /)
      kao(:, 5, 8,10) = (/ &
        & 0.11351e+00,0.11638e+00,0.12535e+00,0.13176e+00,0.13360e+00, &
        & 0.13054e+00,0.12191e+00,0.10801e+00,0.10661e+00 /)
      kao(:, 1, 9,10) = (/ &
        & 0.95227e-01,0.10714e+00,0.11944e+00,0.12826e+00,0.13131e+00, &
        & 0.12801e+00,0.11973e+00,0.10506e+00,0.96127e-01 /)
      kao(:, 2, 9,10) = (/ &
        & 0.97380e-01,0.10792e+00,0.12010e+00,0.12848e+00,0.13131e+00, &
        & 0.12823e+00,0.11988e+00,0.10446e+00,0.96013e-01 /)
      kao(:, 3, 9,10) = (/ &
        & 0.99589e-01,0.10861e+00,0.12043e+00,0.12826e+00,0.13099e+00, &
        & 0.12821e+00,0.11964e+00,0.10385e+00,0.96337e-01 /)
      kao(:, 4, 9,10) = (/ &
        & 0.10172e+00,0.10937e+00,0.12073e+00,0.12822e+00,0.13048e+00, &
        & 0.12786e+00,0.11915e+00,0.10369e+00,0.97324e-01 /)
      kao(:, 5, 9,10) = (/ &
        & 0.10340e+00,0.11015e+00,0.12136e+00,0.12832e+00,0.12998e+00, &
        & 0.12724e+00,0.11892e+00,0.10410e+00,0.97908e-01 /)
      kao(:, 1,10,10) = (/ &
        & 0.84549e-01,0.10005e+00,0.11370e+00,0.12280e+00,0.12503e+00, &
        & 0.12157e+00,0.11395e+00,0.99558e-01,0.78463e-01 /)
      kao(:, 2,10,10) = (/ &
        & 0.86895e-01,0.10114e+00,0.11438e+00,0.12270e+00,0.12494e+00, &
        & 0.12211e+00,0.11447e+00,0.98932e-01,0.78293e-01 /)
      kao(:, 3,10,10) = (/ &
        & 0.89280e-01,0.10200e+00,0.11501e+00,0.12255e+00,0.12466e+00, &
        & 0.12232e+00,0.11449e+00,0.98490e-01,0.78963e-01 /)
      kao(:, 4,10,10) = (/ &
        & 0.91373e-01,0.10297e+00,0.11555e+00,0.12264e+00,0.12433e+00, &
        & 0.12211e+00,0.11429e+00,0.98808e-01,0.79894e-01 /)
      kao(:, 5,10,10) = (/ &
        & 0.93116e-01,0.10381e+00,0.11616e+00,0.12299e+00,0.12420e+00, &
        & 0.12176e+00,0.11463e+00,0.99400e-01,0.79228e-01 /)
      kao(:, 1,11,10) = (/ &
        & 0.75544e-01,0.93054e-01,0.10724e+00,0.11489e+00,0.11666e+00, &
        & 0.11411e+00,0.10739e+00,0.92708e-01,0.54552e-01 /)
      kao(:, 2,11,10) = (/ &
        & 0.77908e-01,0.94287e-01,0.10808e+00,0.11471e+00,0.11661e+00, &
        & 0.11478e+00,0.10772e+00,0.92504e-01,0.54848e-01 /)
      kao(:, 3,11,10) = (/ &
        & 0.80077e-01,0.95473e-01,0.10868e+00,0.11491e+00,0.11655e+00, &
        & 0.11482e+00,0.10782e+00,0.93001e-01,0.55769e-01 /)
      kao(:, 4,11,10) = (/ &
        & 0.81960e-01,0.96566e-01,0.10943e+00,0.11546e+00,0.11672e+00, &
        & 0.11473e+00,0.10831e+00,0.93879e-01,0.57926e-01 /)
      kao(:, 5,11,10) = (/ &
        & 0.83450e-01,0.97453e-01,0.11008e+00,0.11599e+00,0.11716e+00, &
        & 0.11515e+00,0.10911e+00,0.94288e-01,0.57746e-01 /)
      kao(:, 1,12,10) = (/ &
        & 0.67513e-01,0.86189e-01,0.99369e-01,0.10520e+00,0.10724e+00, &
        & 0.10586e+00,0.99242e-01,0.85556e-01,0.53156e-01 /)
      kao(:, 2,12,10) = (/ &
        & 0.69613e-01,0.87484e-01,0.10007e+00,0.10560e+00,0.10749e+00, &
        & 0.10614e+00,0.99761e-01,0.86270e-01,0.51781e-01 /)
      kao(:, 3,12,10) = (/ &
        & 0.71469e-01,0.88722e-01,0.10094e+00,0.10629e+00,0.10784e+00, &
        & 0.10630e+00,0.10046e+00,0.87349e-01,0.51450e-01 /)
      kao(:, 4,12,10) = (/ &
        & 0.73024e-01,0.89773e-01,0.10183e+00,0.10713e+00,0.10860e+00, &
        & 0.10686e+00,0.10138e+00,0.88130e-01,0.52601e-01 /)
      kao(:, 5,12,10) = (/ &
        & 0.74303e-01,0.90696e-01,0.10259e+00,0.10797e+00,0.10971e+00, &
        & 0.10792e+00,0.10184e+00,0.88445e-01,0.51152e-01 /)
      kao(:, 1,13,10) = (/ &
        & 0.60529e-01,0.79607e-01,0.90318e-01,0.95428e-01,0.97408e-01, &
        & 0.96227e-01,0.90699e-01,0.78779e-01,0.52832e-01 /)
      kao(:, 2,13,10) = (/ &
        & 0.62276e-01,0.80870e-01,0.91247e-01,0.96259e-01,0.97934e-01, &
        & 0.96714e-01,0.91680e-01,0.79941e-01,0.52303e-01 /)
      kao(:, 3,13,10) = (/ &
        & 0.63790e-01,0.81933e-01,0.92274e-01,0.97270e-01,0.98880e-01, &
        & 0.97553e-01,0.92636e-01,0.80918e-01,0.51576e-01 /)
      kao(:, 4,13,10) = (/ &
        & 0.65028e-01,0.82921e-01,0.93287e-01,0.98387e-01,0.10023e+00, &
        & 0.98785e-01,0.93367e-01,0.81491e-01,0.53387e-01 /)
      kao(:, 5,13,10) = (/ &
        & 0.66150e-01,0.83739e-01,0.94354e-01,0.99696e-01,0.10169e+00, &
        & 0.99901e-01,0.93863e-01,0.81907e-01,0.52837e-01 /)
      kao(:, 1, 1,11) = (/ &
        & 0.20407e+00,0.18071e+00,0.16029e+00,0.15138e+00,0.14997e+00, &
        & 0.13984e+00,0.13275e+00,0.14129e+00,0.15399e+00 /)
      kao(:, 2, 1,11) = (/ &
        & 0.20135e+00,0.17935e+00,0.15932e+00,0.15017e+00,0.14962e+00, &
        & 0.13862e+00,0.13266e+00,0.14117e+00,0.15393e+00 /)
      kao(:, 3, 1,11) = (/ &
        & 0.19936e+00,0.17801e+00,0.15787e+00,0.14825e+00,0.14805e+00, &
        & 0.13791e+00,0.13257e+00,0.14065e+00,0.15357e+00 /)
      kao(:, 4, 1,11) = (/ &
        & 0.19744e+00,0.17636e+00,0.15587e+00,0.14600e+00,0.14568e+00, &
        & 0.13759e+00,0.13216e+00,0.14003e+00,0.15311e+00 /)
      kao(:, 5, 1,11) = (/ &
        & 0.19560e+00,0.17445e+00,0.15370e+00,0.14366e+00,0.14353e+00, &
        & 0.13719e+00,0.13142e+00,0.13943e+00,0.15271e+00 /)
      kao(:, 1, 2,11) = (/ &
        & 0.21063e+00,0.18653e+00,0.16583e+00,0.16261e+00,0.15745e+00, &
        & 0.14703e+00,0.14143e+00,0.14831e+00,0.16307e+00 /)
      kao(:, 2, 2,11) = (/ &
        & 0.20807e+00,0.18515e+00,0.16450e+00,0.16174e+00,0.15680e+00, &
        & 0.14604e+00,0.14115e+00,0.14798e+00,0.16304e+00 /)
      kao(:, 3, 2,11) = (/ &
        & 0.20581e+00,0.18338e+00,0.16244e+00,0.15978e+00,0.15520e+00, &
        & 0.14566e+00,0.14067e+00,0.14768e+00,0.16312e+00 /)
      kao(:, 4, 2,11) = (/ &
        & 0.20347e+00,0.18119e+00,0.16010e+00,0.15745e+00,0.15333e+00, &
        & 0.14529e+00,0.14007e+00,0.14753e+00,0.16343e+00 /)
      kao(:, 5, 2,11) = (/ &
        & 0.20115e+00,0.17885e+00,0.15773e+00,0.15483e+00,0.15150e+00, &
        & 0.14453e+00,0.13948e+00,0.14731e+00,0.16359e+00 /)
      kao(:, 1, 3,11) = (/ &
        & 0.21616e+00,0.19157e+00,0.17353e+00,0.17142e+00,0.16301e+00, &
        & 0.15566e+00,0.14998e+00,0.15514e+00,0.17145e+00 /)
      kao(:, 2, 3,11) = (/ &
        & 0.21408e+00,0.19026e+00,0.17182e+00,0.17122e+00,0.16252e+00, &
        & 0.15476e+00,0.14939e+00,0.15448e+00,0.17139e+00 /)
      kao(:, 3, 3,11) = (/ &
        & 0.21163e+00,0.18824e+00,0.16950e+00,0.16996e+00,0.16151e+00, &
        & 0.15419e+00,0.14882e+00,0.15406e+00,0.17163e+00 /)
      kao(:, 4, 3,11) = (/ &
        & 0.20914e+00,0.18593e+00,0.16692e+00,0.16757e+00,0.16029e+00, &
        & 0.15344e+00,0.14837e+00,0.15392e+00,0.17198e+00 /)
      kao(:, 5, 3,11) = (/ &
        & 0.20701e+00,0.18381e+00,0.16453e+00,0.16472e+00,0.15897e+00, &
        & 0.15236e+00,0.14801e+00,0.15351e+00,0.17179e+00 /)
      kao(:, 1, 4,11) = (/ &
        & 0.21862e+00,0.19379e+00,0.18221e+00,0.17807e+00,0.16954e+00, &
        & 0.16407e+00,0.15829e+00,0.16056e+00,0.17755e+00 /)
      kao(:, 2, 4,11) = (/ &
        & 0.21705e+00,0.19285e+00,0.18086e+00,0.17812e+00,0.16909e+00, &
        & 0.16313e+00,0.15767e+00,0.16003e+00,0.17784e+00 /)
      kao(:, 3, 4,11) = (/ &
        & 0.21534e+00,0.19129e+00,0.17879e+00,0.17719e+00,0.16821e+00, &
        & 0.16252e+00,0.15706e+00,0.15944e+00,0.17796e+00 /)
      kao(:, 4, 4,11) = (/ &
        & 0.21357e+00,0.18961e+00,0.17644e+00,0.17503e+00,0.16720e+00, &
        & 0.16179e+00,0.15644e+00,0.15869e+00,0.17755e+00 /)
      kao(:, 5, 4,11) = (/ &
        & 0.21192e+00,0.18796e+00,0.17436e+00,0.17237e+00,0.16599e+00, &
        & 0.16096e+00,0.15564e+00,0.15746e+00,0.17656e+00 /)
      kao(:, 1, 5,11) = (/ &
        & 0.21793e+00,0.19325e+00,0.18965e+00,0.18402e+00,0.17692e+00, &
        & 0.17250e+00,0.16494e+00,0.16474e+00,0.18189e+00 /)
      kao(:, 2, 5,11) = (/ &
        & 0.21706e+00,0.19287e+00,0.18835e+00,0.18355e+00,0.17627e+00, &
        & 0.17161e+00,0.16474e+00,0.16398e+00,0.18195e+00 /)
      kao(:, 3, 5,11) = (/ &
        & 0.21612e+00,0.19181e+00,0.18687e+00,0.18213e+00,0.17553e+00, &
        & 0.17088e+00,0.16425e+00,0.16313e+00,0.18152e+00 /)
      kao(:, 4, 5,11) = (/ &
        & 0.21478e+00,0.19045e+00,0.18500e+00,0.18018e+00,0.17440e+00, &
        & 0.16996e+00,0.16342e+00,0.16188e+00,0.18054e+00 /)
      kao(:, 5, 5,11) = (/ &
        & 0.21350e+00,0.18909e+00,0.18333e+00,0.17782e+00,0.17309e+00, &
        & 0.16916e+00,0.16213e+00,0.16034e+00,0.17917e+00 /)
      kao(:, 1, 6,11) = (/ &
        & 0.21342e+00,0.19093e+00,0.19390e+00,0.18953e+00,0.18412e+00, &
        & 0.17932e+00,0.17133e+00,0.16726e+00,0.18355e+00 /)
      kao(:, 2, 6,11) = (/ &
        & 0.21345e+00,0.19062e+00,0.19295e+00,0.18836e+00,0.18309e+00, &
        & 0.17848e+00,0.17069e+00,0.16650e+00,0.18323e+00 /)
      kao(:, 3, 6,11) = (/ &
        & 0.21341e+00,0.18999e+00,0.19180e+00,0.18672e+00,0.18231e+00, &
        & 0.17805e+00,0.16996e+00,0.16523e+00,0.18230e+00 /)
      kao(:, 4, 6,11) = (/ &
        & 0.21278e+00,0.18888e+00,0.19035e+00,0.18488e+00,0.18150e+00, &
        & 0.17740e+00,0.16888e+00,0.16361e+00,0.18086e+00 /)
      kao(:, 5, 6,11) = (/ &
        & 0.21199e+00,0.18788e+00,0.18853e+00,0.18312e+00,0.18053e+00, &
        & 0.17647e+00,0.16753e+00,0.16185e+00,0.17942e+00 /)
      kao(:, 1, 7,11) = (/ &
        & 0.20554e+00,0.18880e+00,0.19483e+00,0.19351e+00,0.18975e+00, &
        & 0.18476e+00,0.17703e+00,0.16712e+00,0.18079e+00 /)
      kao(:, 2, 7,11) = (/ &
        & 0.20652e+00,0.18855e+00,0.19393e+00,0.19243e+00,0.18938e+00, &
        & 0.18427e+00,0.17598e+00,0.16627e+00,0.18028e+00 /)
      kao(:, 3, 7,11) = (/ &
        & 0.20722e+00,0.18798e+00,0.19279e+00,0.19112e+00,0.18883e+00, &
        & 0.18376e+00,0.17458e+00,0.16493e+00,0.17920e+00 /)
      kao(:, 4, 7,11) = (/ &
        & 0.20704e+00,0.18700e+00,0.19152e+00,0.18972e+00,0.18818e+00, &
        & 0.18325e+00,0.17326e+00,0.16331e+00,0.17789e+00 /)
      kao(:, 5, 7,11) = (/ &
        & 0.20670e+00,0.18595e+00,0.18990e+00,0.18822e+00,0.18756e+00, &
        & 0.18244e+00,0.17179e+00,0.16146e+00,0.17654e+00 /)
      kao(:, 1, 8,11) = (/ &
        & 0.19482e+00,0.18644e+00,0.19372e+00,0.19534e+00,0.19341e+00, &
        & 0.18978e+00,0.17991e+00,0.16480e+00,0.17385e+00 /)
      kao(:, 2, 8,11) = (/ &
        & 0.19645e+00,0.18662e+00,0.19286e+00,0.19499e+00,0.19364e+00, &
        & 0.18939e+00,0.17872e+00,0.16377e+00,0.17323e+00 /)
      kao(:, 3, 8,11) = (/ &
        & 0.19752e+00,0.18632e+00,0.19176e+00,0.19416e+00,0.19361e+00, &
        & 0.18898e+00,0.17730e+00,0.16248e+00,0.17231e+00 /)
      kao(:, 4, 8,11) = (/ &
        & 0.19786e+00,0.18535e+00,0.19058e+00,0.19340e+00,0.19352e+00, &
        & 0.18844e+00,0.17582e+00,0.16092e+00,0.17110e+00 /)
      kao(:, 5, 8,11) = (/ &
        & 0.19827e+00,0.18472e+00,0.18922e+00,0.19254e+00,0.19302e+00, &
        & 0.18739e+00,0.17431e+00,0.15936e+00,0.17034e+00 /)
      kao(:, 1, 9,11) = (/ &
        & 0.18199e+00,0.18200e+00,0.19084e+00,0.19456e+00,0.19545e+00, &
        & 0.19216e+00,0.18018e+00,0.16033e+00,0.16333e+00 /)
      kao(:, 2, 9,11) = (/ &
        & 0.18402e+00,0.18227e+00,0.19032e+00,0.19515e+00,0.19643e+00, &
        & 0.19212e+00,0.17883e+00,0.15954e+00,0.16306e+00 /)
      kao(:, 3, 9,11) = (/ &
        & 0.18527e+00,0.18204e+00,0.18956e+00,0.19541e+00,0.19690e+00, &
        & 0.19201e+00,0.17754e+00,0.15865e+00,0.16240e+00 /)
      kao(:, 4, 9,11) = (/ &
        & 0.18597e+00,0.18146e+00,0.18866e+00,0.19510e+00,0.19689e+00, &
        & 0.19145e+00,0.17626e+00,0.15729e+00,0.16157e+00 /)
      kao(:, 5, 9,11) = (/ &
        & 0.18701e+00,0.18150e+00,0.18776e+00,0.19449e+00,0.19637e+00, &
        & 0.19035e+00,0.17490e+00,0.15605e+00,0.16154e+00 /)
      kao(:, 1,10,11) = (/ &
        & 0.16786e+00,0.17459e+00,0.18572e+00,0.19196e+00,0.19497e+00, &
        & 0.19093e+00,0.17775e+00,0.15445e+00,0.12845e+00 /)
      kao(:, 2,10,11) = (/ &
        & 0.16990e+00,0.17470e+00,0.18604e+00,0.19354e+00,0.19670e+00, &
        & 0.19124e+00,0.17643e+00,0.15415e+00,0.12953e+00 /)
      kao(:, 3,10,11) = (/ &
        & 0.17115e+00,0.17447e+00,0.18577e+00,0.19420e+00,0.19734e+00, &
        & 0.19133e+00,0.17544e+00,0.15343e+00,0.13019e+00 /)
      kao(:, 4,10,11) = (/ &
        & 0.17256e+00,0.17421e+00,0.18540e+00,0.19426e+00,0.19741e+00, &
        & 0.19105e+00,0.17463e+00,0.15245e+00,0.13135e+00 /)
      kao(:, 5,10,11) = (/ &
        & 0.17411e+00,0.17469e+00,0.18532e+00,0.19400e+00,0.19690e+00, &
        & 0.19024e+00,0.17373e+00,0.15177e+00,0.13443e+00 /)
      kao(:, 1,11,11) = (/ &
        & 0.15326e+00,0.16530e+00,0.17933e+00,0.18873e+00,0.19204e+00, &
        & 0.18645e+00,0.17157e+00,0.14842e+00,0.10906e+00 /)
      kao(:, 2,11,11) = (/ &
        & 0.15510e+00,0.16508e+00,0.18002e+00,0.19054e+00,0.19337e+00, &
        & 0.18697e+00,0.17132e+00,0.14823e+00,0.10821e+00 /)
      kao(:, 3,11,11) = (/ &
        & 0.15695e+00,0.16517e+00,0.18033e+00,0.19125e+00,0.19395e+00, &
        & 0.18719e+00,0.17114e+00,0.14748e+00,0.10735e+00 /)
      kao(:, 4,11,11) = (/ &
        & 0.15884e+00,0.16584e+00,0.18066e+00,0.19107e+00,0.19386e+00, &
        & 0.18714e+00,0.17083e+00,0.14679e+00,0.10767e+00 /)
      kao(:, 5,11,11) = (/ &
        & 0.16065e+00,0.16693e+00,0.18136e+00,0.19090e+00,0.19313e+00, &
        & 0.18652e+00,0.17043e+00,0.14693e+00,0.10852e+00 /)
      kao(:, 1,12,11) = (/ &
        & 0.13812e+00,0.15482e+00,0.17200e+00,0.18322e+00,0.18516e+00, &
        & 0.17855e+00,0.16404e+00,0.14149e+00,0.85521e-01 /)
      kao(:, 2,12,11) = (/ &
        & 0.14024e+00,0.15523e+00,0.17295e+00,0.18464e+00,0.18616e+00, &
        & 0.17947e+00,0.16474e+00,0.14107e+00,0.84251e-01 /)
      kao(:, 3,12,11) = (/ &
        & 0.14232e+00,0.15625e+00,0.17374e+00,0.18482e+00,0.18666e+00, &
        & 0.18015e+00,0.16507e+00,0.14067e+00,0.83221e-01 /)
      kao(:, 4,12,11) = (/ &
        & 0.14452e+00,0.15760e+00,0.17483e+00,0.18482e+00,0.18644e+00, &
        & 0.18031e+00,0.16530e+00,0.14085e+00,0.83052e-01 /)
      kao(:, 5,12,11) = (/ &
        & 0.14659e+00,0.15898e+00,0.17608e+00,0.18496e+00,0.18608e+00, &
        & 0.18007e+00,0.16596e+00,0.14156e+00,0.86150e-01 /)
      kao(:, 1,13,11) = (/ &
        & 0.12335e+00,0.14397e+00,0.16332e+00,0.17403e+00,0.17485e+00, &
        & 0.16858e+00,0.15532e+00,0.13315e+00,0.86982e-01 /)
      kao(:, 2,13,11) = (/ &
        & 0.12553e+00,0.14531e+00,0.16473e+00,0.17477e+00,0.17593e+00, &
        & 0.16998e+00,0.15639e+00,0.13322e+00,0.83311e-01 /)
      kao(:, 3,13,11) = (/ &
        & 0.12788e+00,0.14705e+00,0.16612e+00,0.17511e+00,0.17644e+00, &
        & 0.17090e+00,0.15730e+00,0.13374e+00,0.80969e-01 /)
      kao(:, 4,13,11) = (/ &
        & 0.13027e+00,0.14889e+00,0.16746e+00,0.17569e+00,0.17660e+00, &
        & 0.17136e+00,0.15852e+00,0.13468e+00,0.79671e-01 /)
      kao(:, 5,13,11) = (/ &
        & 0.13255e+00,0.15069e+00,0.16867e+00,0.17661e+00,0.17696e+00, &
        & 0.17204e+00,0.15992e+00,0.13520e+00,0.81334e-01 /)
      kao(:, 1, 1,12) = (/ &
        & 0.28721e+00,0.25323e+00,0.21917e+00,0.19050e+00,0.18439e+00, &
        & 0.17842e+00,0.17156e+00,0.18245e+00,0.20075e+00 /)
      kao(:, 2, 1,12) = (/ &
        & 0.28561e+00,0.25177e+00,0.21845e+00,0.19052e+00,0.18309e+00, &
        & 0.17638e+00,0.16966e+00,0.18096e+00,0.19965e+00 /)
      kao(:, 3, 1,12) = (/ &
        & 0.28230e+00,0.24910e+00,0.21697e+00,0.19014e+00,0.18233e+00, &
        & 0.17414e+00,0.16821e+00,0.18034e+00,0.19910e+00 /)
      kao(:, 4, 1,12) = (/ &
        & 0.27834e+00,0.24592e+00,0.21540e+00,0.18935e+00,0.18163e+00, &
        & 0.17186e+00,0.16739e+00,0.18033e+00,0.19922e+00 /)
      kao(:, 5, 1,12) = (/ &
        & 0.27434e+00,0.24303e+00,0.21391e+00,0.18803e+00,0.18019e+00, &
        & 0.17025e+00,0.16693e+00,0.18042e+00,0.19937e+00 /)
      kao(:, 1, 2,12) = (/ &
        & 0.29623e+00,0.26097e+00,0.22609e+00,0.20293e+00,0.20182e+00, &
        & 0.19085e+00,0.18240e+00,0.19397e+00,0.21604e+00 /)
      kao(:, 2, 2,12) = (/ &
        & 0.29432e+00,0.25931e+00,0.22539e+00,0.20142e+00,0.20026e+00, &
        & 0.18828e+00,0.18057e+00,0.19299e+00,0.21521e+00 /)
      kao(:, 3, 2,12) = (/ &
        & 0.29132e+00,0.25712e+00,0.22457e+00,0.20070e+00,0.19917e+00, &
        & 0.18573e+00,0.17946e+00,0.19254e+00,0.21482e+00 /)
      kao(:, 4, 2,12) = (/ &
        & 0.28797e+00,0.25474e+00,0.22345e+00,0.19986e+00,0.19780e+00, &
        & 0.18370e+00,0.17875e+00,0.19238e+00,0.21459e+00 /)
      kao(:, 5, 2,12) = (/ &
        & 0.28466e+00,0.25242e+00,0.22205e+00,0.19838e+00,0.19562e+00, &
        & 0.18242e+00,0.17806e+00,0.19203e+00,0.21421e+00 /)
      kao(:, 1, 3,12) = (/ &
        & 0.30561e+00,0.26889e+00,0.23295e+00,0.21956e+00,0.21717e+00, &
        & 0.20307e+00,0.19524e+00,0.20742e+00,0.23388e+00 /)
      kao(:, 2, 3,12) = (/ &
        & 0.30324e+00,0.26704e+00,0.23237e+00,0.21738e+00,0.21493e+00, &
        & 0.20036e+00,0.19375e+00,0.20659e+00,0.23304e+00 /)
      kao(:, 3, 3,12) = (/ &
        & 0.30058e+00,0.26531e+00,0.23190e+00,0.21598e+00,0.21300e+00, &
        & 0.19790e+00,0.19244e+00,0.20627e+00,0.23259e+00 /)
      kao(:, 4, 3,12) = (/ &
        & 0.29826e+00,0.26386e+00,0.23125e+00,0.21516e+00,0.21099e+00, &
        & 0.19626e+00,0.19135e+00,0.20570e+00,0.23176e+00 /)
      kao(:, 5, 3,12) = (/ &
        & 0.29569e+00,0.26204e+00,0.22972e+00,0.21357e+00,0.20846e+00, &
        & 0.19500e+00,0.19003e+00,0.20504e+00,0.23084e+00 /)
      kao(:, 1, 4,12) = (/ &
        & 0.31580e+00,0.27765e+00,0.24256e+00,0.23825e+00,0.23010e+00, &
        & 0.21605e+00,0.20908e+00,0.22073e+00,0.25027e+00 /)
      kao(:, 2, 4,12) = (/ &
        & 0.31385e+00,0.27619e+00,0.24143e+00,0.23561e+00,0.22732e+00, &
        & 0.21355e+00,0.20732e+00,0.21997e+00,0.24945e+00 /)
      kao(:, 3, 4,12) = (/ &
        & 0.31115e+00,0.27450e+00,0.24049e+00,0.23383e+00,0.22480e+00, &
        & 0.21136e+00,0.20583e+00,0.21971e+00,0.24898e+00 /)
      kao(:, 4, 4,12) = (/ &
        & 0.30851e+00,0.27268e+00,0.23896e+00,0.23220e+00,0.22243e+00, &
        & 0.20992e+00,0.20459e+00,0.21945e+00,0.24850e+00 /)
      kao(:, 5, 4,12) = (/ &
        & 0.30578e+00,0.27071e+00,0.23717e+00,0.23033e+00,0.22018e+00, &
        & 0.20870e+00,0.20353e+00,0.21927e+00,0.24814e+00 /)
      kao(:, 1, 5,12) = (/ &
        & 0.32525e+00,0.28587e+00,0.25583e+00,0.25377e+00,0.24260e+00, &
        & 0.22945e+00,0.22249e+00,0.23280e+00,0.26422e+00 /)
      kao(:, 2, 5,12) = (/ &
        & 0.32339e+00,0.28450e+00,0.25406e+00,0.25143e+00,0.23950e+00, &
        & 0.22738e+00,0.22044e+00,0.23211e+00,0.26348e+00 /)
      kao(:, 3, 5,12) = (/ &
        & 0.32075e+00,0.28298e+00,0.25200e+00,0.24974e+00,0.23665e+00, &
        & 0.22565e+00,0.21882e+00,0.23178e+00,0.26317e+00 /)
      kao(:, 4, 5,12) = (/ &
        & 0.31838e+00,0.28134e+00,0.24992e+00,0.24807e+00,0.23442e+00, &
        & 0.22435e+00,0.21780e+00,0.23180e+00,0.26307e+00 /)
      kao(:, 5, 5,12) = (/ &
        & 0.31581e+00,0.27952e+00,0.24774e+00,0.24618e+00,0.23239e+00, &
        & 0.22315e+00,0.21723e+00,0.23168e+00,0.26269e+00 /)
      kao(:, 1, 6,12) = (/ &
        & 0.33335e+00,0.29286e+00,0.27107e+00,0.26707e+00,0.25627e+00, &
        & 0.24388e+00,0.23516e+00,0.24254e+00,0.27495e+00 /)
      kao(:, 2, 6,12) = (/ &
        & 0.33185e+00,0.29196e+00,0.26927e+00,0.26528e+00,0.25338e+00, &
        & 0.24199e+00,0.23321e+00,0.24178e+00,0.27452e+00 /)
      kao(:, 3, 6,12) = (/ &
        & 0.32960e+00,0.29070e+00,0.26757e+00,0.26387e+00,0.25062e+00, &
        & 0.24015e+00,0.23158e+00,0.24188e+00,0.27485e+00 /)
      kao(:, 4, 6,12) = (/ &
        & 0.32714e+00,0.28920e+00,0.26543e+00,0.26229e+00,0.24828e+00, &
        & 0.23863e+00,0.23085e+00,0.24191e+00,0.27476e+00 /)
      kao(:, 5, 6,12) = (/ &
        & 0.32443e+00,0.28722e+00,0.26300e+00,0.25993e+00,0.24627e+00, &
        & 0.23716e+00,0.23011e+00,0.24150e+00,0.27410e+00 /)
      kao(:, 1, 7,12) = (/ &
        & 0.33805e+00,0.29686e+00,0.28577e+00,0.27897e+00,0.26998e+00, &
        & 0.25892e+00,0.24589e+00,0.25046e+00,0.28292e+00 /)
      kao(:, 2, 7,12) = (/ &
        & 0.33717e+00,0.29673e+00,0.28505e+00,0.27748e+00,0.26727e+00, &
        & 0.25668e+00,0.24439e+00,0.24991e+00,0.28315e+00 /)
      kao(:, 3, 7,12) = (/ &
        & 0.33582e+00,0.29639e+00,0.28414e+00,0.27664e+00,0.26503e+00, &
        & 0.25454e+00,0.24355e+00,0.24982e+00,0.28339e+00 /)
      kao(:, 4, 7,12) = (/ &
        & 0.33418e+00,0.29565e+00,0.28243e+00,0.27502e+00,0.26319e+00, &
        & 0.25262e+00,0.24314e+00,0.24937e+00,0.28297e+00 /)
      kao(:, 5, 7,12) = (/ &
        & 0.33223e+00,0.29432e+00,0.28036e+00,0.27276e+00,0.26126e+00, &
        & 0.25114e+00,0.24223e+00,0.24874e+00,0.28224e+00 /)
      kao(:, 1, 8,12) = (/ &
        & 0.33811e+00,0.29881e+00,0.29770e+00,0.29087e+00,0.28271e+00, &
        & 0.27088e+00,0.25606e+00,0.25702e+00,0.28869e+00 /)
      kao(:, 2, 8,12) = (/ &
        & 0.33858e+00,0.29933e+00,0.29817e+00,0.28968e+00,0.28063e+00, &
        & 0.26913e+00,0.25508e+00,0.25647e+00,0.28886e+00 /)
      kao(:, 3, 8,12) = (/ &
        & 0.33853e+00,0.29979e+00,0.29803e+00,0.28900e+00,0.27895e+00, &
        & 0.26698e+00,0.25454e+00,0.25561e+00,0.28857e+00 /)
      kao(:, 4, 8,12) = (/ &
        & 0.33786e+00,0.29958e+00,0.29705e+00,0.28721e+00,0.27754e+00, &
        & 0.26522e+00,0.25386e+00,0.25480e+00,0.28812e+00 /)
      kao(:, 5, 8,12) = (/ &
        & 0.33672e+00,0.29874e+00,0.29538e+00,0.28492e+00,0.27593e+00, &
        & 0.26422e+00,0.25288e+00,0.25337e+00,0.28657e+00 /)
      kao(:, 1, 9,12) = (/ &
        & 0.33304e+00,0.29965e+00,0.30451e+00,0.30108e+00,0.29380e+00, &
        & 0.28100e+00,0.26620e+00,0.26062e+00,0.28923e+00 /)
      kao(:, 2, 9,12) = (/ &
        & 0.33493e+00,0.30099e+00,0.30590e+00,0.30051e+00,0.29241e+00, &
        & 0.27971e+00,0.26553e+00,0.25927e+00,0.28890e+00 /)
      kao(:, 3, 9,12) = (/ &
        & 0.33639e+00,0.30210e+00,0.30672e+00,0.29976e+00,0.29135e+00, &
        & 0.27789e+00,0.26459e+00,0.25779e+00,0.28847e+00 /)
      kao(:, 4, 9,12) = (/ &
        & 0.33691e+00,0.30238e+00,0.30636e+00,0.29831e+00,0.29055e+00, &
        & 0.27684e+00,0.26372e+00,0.25629e+00,0.28756e+00 /)
      kao(:, 5, 9,12) = (/ &
        & 0.33680e+00,0.30184e+00,0.30474e+00,0.29664e+00,0.28906e+00, &
        & 0.27593e+00,0.26250e+00,0.25436e+00,0.28576e+00 /)
      kao(:, 1,10,12) = (/ &
        & 0.32265e+00,0.29931e+00,0.30809e+00,0.30788e+00,0.30155e+00, &
        & 0.29032e+00,0.27398e+00,0.25958e+00,0.28232e+00 /)
      kao(:, 2,10,12) = (/ &
        & 0.32643e+00,0.30217e+00,0.30992e+00,0.30804e+00,0.30109e+00, &
        & 0.28947e+00,0.27364e+00,0.25761e+00,0.28165e+00 /)
      kao(:, 3,10,12) = (/ &
        & 0.32903e+00,0.30409e+00,0.31077e+00,0.30846e+00,0.30095e+00, &
        & 0.28833e+00,0.27259e+00,0.25601e+00,0.28124e+00 /)
      kao(:, 4,10,12) = (/ &
        & 0.33021e+00,0.30472e+00,0.31062e+00,0.30777e+00,0.30050e+00, &
        & 0.28725e+00,0.27132e+00,0.25418e+00,0.28034e+00 /)
      kao(:, 5,10,12) = (/ &
        & 0.33035e+00,0.30379e+00,0.30948e+00,0.30647e+00,0.29984e+00, &
        & 0.28648e+00,0.26959e+00,0.25216e+00,0.27891e+00 /)
      kao(:, 1,11,12) = (/ &
        & 0.31092e+00,0.29828e+00,0.30944e+00,0.31067e+00,0.30618e+00, &
        & 0.29698e+00,0.27822e+00,0.25367e+00,0.20521e+00 /)
      kao(:, 2,11,12) = (/ &
        & 0.31508e+00,0.30179e+00,0.31084e+00,0.31247e+00,0.30712e+00, &
        & 0.29665e+00,0.27717e+00,0.25137e+00,0.20791e+00 /)
      kao(:, 3,11,12) = (/ &
        & 0.31745e+00,0.30351e+00,0.31148e+00,0.31329e+00,0.30764e+00, &
        & 0.29592e+00,0.27601e+00,0.24946e+00,0.21041e+00 /)
      kao(:, 4,11,12) = (/ &
        & 0.31864e+00,0.30345e+00,0.31137e+00,0.31328e+00,0.30818e+00, &
        & 0.29525e+00,0.27444e+00,0.24795e+00,0.21312e+00 /)
      kao(:, 5,11,12) = (/ &
        & 0.31936e+00,0.30268e+00,0.31034e+00,0.31260e+00,0.30827e+00, &
        & 0.29465e+00,0.27259e+00,0.24615e+00,0.21621e+00 /)
      kao(:, 1,12,12) = (/ &
        & 0.29534e+00,0.29381e+00,0.30706e+00,0.31081e+00,0.30893e+00, &
        & 0.29961e+00,0.27811e+00,0.24533e+00,0.16496e+00 /)
      kao(:, 2,12,12) = (/ &
        & 0.29914e+00,0.29664e+00,0.30890e+00,0.31347e+00,0.31102e+00, &
        & 0.29958e+00,0.27683e+00,0.24361e+00,0.16812e+00 /)
      kao(:, 3,12,12) = (/ &
        & 0.30164e+00,0.29790e+00,0.30986e+00,0.31529e+00,0.31277e+00, &
        & 0.29960e+00,0.27547e+00,0.24230e+00,0.17163e+00 /)
      kao(:, 4,12,12) = (/ &
        & 0.30318e+00,0.29799e+00,0.30963e+00,0.31596e+00,0.31358e+00, &
        & 0.29964e+00,0.27410e+00,0.24090e+00,0.17207e+00 /)
      kao(:, 5,12,12) = (/ &
        & 0.30462e+00,0.29774e+00,0.30883e+00,0.31580e+00,0.31382e+00, &
        & 0.29942e+00,0.27289e+00,0.23940e+00,0.17248e+00 /)
      kao(:, 1,13,12) = (/ &
        & 0.27646e+00,0.28482e+00,0.30092e+00,0.30845e+00,0.30839e+00, &
        & 0.29721e+00,0.27391e+00,0.23566e+00,0.13145e+00 /)
      kao(:, 2,13,12) = (/ &
        & 0.28013e+00,0.28703e+00,0.30330e+00,0.31210e+00,0.31152e+00, &
        & 0.29799e+00,0.27265e+00,0.23501e+00,0.13680e+00 /)
      kao(:, 3,13,12) = (/ &
        & 0.28251e+00,0.28781e+00,0.30455e+00,0.31430e+00,0.31342e+00, &
        & 0.29883e+00,0.27192e+00,0.23420e+00,0.14031e+00 /)
      kao(:, 4,13,12) = (/ &
        & 0.28473e+00,0.28806e+00,0.30532e+00,0.31558e+00,0.31478e+00, &
        & 0.29964e+00,0.27140e+00,0.23324e+00,0.14138e+00 /)
      kao(:, 5,13,12) = (/ &
        & 0.28731e+00,0.28885e+00,0.30563e+00,0.31603e+00,0.31529e+00, &
        & 0.30003e+00,0.27073e+00,0.23300e+00,0.14291e+00 /)
      kao(:, 1, 1,13) = (/ &
        & 0.39331e+00,0.34536e+00,0.29823e+00,0.25200e+00,0.22257e+00, &
        & 0.22153e+00,0.23263e+00,0.25940e+00,0.28372e+00 /)
      kao(:, 2, 1,13) = (/ &
        & 0.38484e+00,0.33824e+00,0.29242e+00,0.24772e+00,0.21768e+00, &
        & 0.21972e+00,0.23098e+00,0.25833e+00,0.28173e+00 /)
      kao(:, 3, 1,13) = (/ &
        & 0.37910e+00,0.33360e+00,0.28884e+00,0.24475e+00,0.21421e+00, &
        & 0.21744e+00,0.22823e+00,0.25633e+00,0.27932e+00 /)
      kao(:, 4, 1,13) = (/ &
        & 0.37406e+00,0.32956e+00,0.28576e+00,0.24212e+00,0.21151e+00, &
        & 0.21463e+00,0.22480e+00,0.25354e+00,0.27637e+00 /)
      kao(:, 5, 1,13) = (/ &
        & 0.36968e+00,0.32602e+00,0.28272e+00,0.24026e+00,0.20970e+00, &
        & 0.21134e+00,0.22163e+00,0.25081e+00,0.27385e+00 /)
      kao(:, 1, 2,13) = (/ &
        & 0.41602e+00,0.36529e+00,0.31527e+00,0.26672e+00,0.24637e+00, &
        & 0.24718e+00,0.25604e+00,0.28585e+00,0.31850e+00 /)
      kao(:, 2, 2,13) = (/ &
        & 0.40830e+00,0.35891e+00,0.31022e+00,0.26338e+00,0.24193e+00, &
        & 0.24484e+00,0.25382e+00,0.28396e+00,0.31574e+00 /)
      kao(:, 3, 2,13) = (/ &
        & 0.40220e+00,0.35391e+00,0.30635e+00,0.26042e+00,0.23856e+00, &
        & 0.24224e+00,0.25030e+00,0.28140e+00,0.31256e+00 /)
      kao(:, 4, 2,13) = (/ &
        & 0.39708e+00,0.34976e+00,0.30310e+00,0.25764e+00,0.23590e+00, &
        & 0.23895e+00,0.24655e+00,0.27840e+00,0.30929e+00 /)
      kao(:, 5, 2,13) = (/ &
        & 0.39199e+00,0.34559e+00,0.29962e+00,0.25559e+00,0.23369e+00, &
        & 0.23517e+00,0.24316e+00,0.27577e+00,0.30660e+00 /)
      kao(:, 1, 3,13) = (/ &
        & 0.43911e+00,0.38551e+00,0.33254e+00,0.28548e+00,0.27501e+00, &
        & 0.27158e+00,0.27806e+00,0.30961e+00,0.34942e+00 /)
      kao(:, 2, 3,13) = (/ &
        & 0.43165e+00,0.37930e+00,0.32763e+00,0.28158e+00,0.27135e+00, &
        & 0.26881e+00,0.27489e+00,0.30725e+00,0.34620e+00 /)
      kao(:, 3, 3,13) = (/ &
        & 0.42551e+00,0.37419e+00,0.32362e+00,0.27772e+00,0.26799e+00, &
        & 0.26571e+00,0.27096e+00,0.30422e+00,0.34240e+00 /)
      kao(:, 4, 3,13) = (/ &
        & 0.42038e+00,0.37000e+00,0.32049e+00,0.27494e+00,0.26498e+00, &
        & 0.26183e+00,0.26698e+00,0.30136e+00,0.33931e+00 /)
      kao(:, 5, 3,13) = (/ &
        & 0.41446e+00,0.36533e+00,0.31734e+00,0.27304e+00,0.26234e+00, &
        & 0.25777e+00,0.26380e+00,0.29913e+00,0.33705e+00 /)
      kao(:, 1, 4,13) = (/ &
        & 0.46241e+00,0.40571e+00,0.34961e+00,0.30954e+00,0.30425e+00, &
        & 0.29507e+00,0.29890e+00,0.33301e+00,0.37827e+00 /)
      kao(:, 2, 4,13) = (/ &
        & 0.45465e+00,0.39923e+00,0.34450e+00,0.30510e+00,0.30124e+00, &
        & 0.29145e+00,0.29516e+00,0.32984e+00,0.37410e+00 /)
      kao(:, 3, 4,13) = (/ &
        & 0.44872e+00,0.39432e+00,0.34072e+00,0.30104e+00,0.29841e+00, &
        & 0.28758e+00,0.29090e+00,0.32641e+00,0.36986e+00 /)
      kao(:, 4, 4,13) = (/ &
        & 0.44350e+00,0.39014e+00,0.33810e+00,0.29814e+00,0.29548e+00, &
        & 0.28294e+00,0.28676e+00,0.32342e+00,0.36667e+00 /)
      kao(:, 5, 4,13) = (/ &
        & 0.43828e+00,0.38609e+00,0.33570e+00,0.29627e+00,0.29269e+00, &
        & 0.27870e+00,0.28357e+00,0.32115e+00,0.36426e+00 /)
      kao(:, 1, 5,13) = (/ &
        & 0.48784e+00,0.42784e+00,0.36835e+00,0.33984e+00,0.33294e+00, &
        & 0.31846e+00,0.32126e+00,0.35651e+00,0.40621e+00 /)
      kao(:, 2, 5,13) = (/ &
        & 0.48030e+00,0.42153e+00,0.36340e+00,0.33519e+00,0.32973e+00, &
        & 0.31380e+00,0.31683e+00,0.35311e+00,0.40187e+00 /)
      kao(:, 3, 5,13) = (/ &
        & 0.47411e+00,0.41636e+00,0.35974e+00,0.33136e+00,0.32664e+00, &
        & 0.30892e+00,0.31220e+00,0.34964e+00,0.39763e+00 /)
      kao(:, 4, 5,13) = (/ &
        & 0.46883e+00,0.41227e+00,0.35745e+00,0.32776e+00,0.32317e+00, &
        & 0.30393e+00,0.30777e+00,0.34651e+00,0.39440e+00 /)
      kao(:, 5, 5,13) = (/ &
        & 0.46388e+00,0.40844e+00,0.35543e+00,0.32520e+00,0.31964e+00, &
        & 0.29971e+00,0.30439e+00,0.34429e+00,0.39205e+00 /)
      kao(:, 1, 6,13) = (/ &
        & 0.51535e+00,0.45180e+00,0.39162e+00,0.37322e+00,0.36050e+00, &
        & 0.34300e+00,0.34505e+00,0.38137e+00,0.43538e+00 /)
      kao(:, 2, 6,13) = (/ &
        & 0.50781e+00,0.44545e+00,0.38586e+00,0.36868e+00,0.35573e+00, &
        & 0.33760e+00,0.34025e+00,0.37783e+00,0.43095e+00 /)
      kao(:, 3, 6,13) = (/ &
        & 0.50139e+00,0.44011e+00,0.38148e+00,0.36480e+00,0.35183e+00, &
        & 0.33217e+00,0.33546e+00,0.37434e+00,0.42674e+00 /)
      kao(:, 4, 6,13) = (/ &
        & 0.49657e+00,0.43636e+00,0.37891e+00,0.36116e+00,0.34800e+00, &
        & 0.32704e+00,0.33102e+00,0.37152e+00,0.42385e+00 /)
      kao(:, 5, 6,13) = (/ &
        & 0.49171e+00,0.43263e+00,0.37693e+00,0.35827e+00,0.34376e+00, &
        & 0.32320e+00,0.32782e+00,0.36976e+00,0.42188e+00 /)
      kao(:, 1, 7,13) = (/ &
        & 0.54162e+00,0.47464e+00,0.41834e+00,0.40782e+00,0.38721e+00, &
        & 0.36824e+00,0.37067e+00,0.40670e+00,0.46460e+00 /)
      kao(:, 2, 7,13) = (/ &
        & 0.53535e+00,0.46937e+00,0.41220e+00,0.40296e+00,0.38145e+00, &
        & 0.36278e+00,0.36581e+00,0.40309e+00,0.46013e+00 /)
      kao(:, 3, 7,13) = (/ &
        & 0.52914e+00,0.46429e+00,0.40710e+00,0.39788e+00,0.37673e+00, &
        & 0.35819e+00,0.36078e+00,0.40008e+00,0.45678e+00 /)
      kao(:, 4, 7,13) = (/ &
        & 0.52440e+00,0.46050e+00,0.40384e+00,0.39374e+00,0.37204e+00, &
        & 0.35371e+00,0.35616e+00,0.39775e+00,0.45424e+00 /)
      kao(:, 5, 7,13) = (/ &
        & 0.52017e+00,0.45722e+00,0.40132e+00,0.39030e+00,0.36733e+00, &
        & 0.34991e+00,0.35252e+00,0.39600e+00,0.45213e+00 /)
      kao(:, 1, 8,13) = (/ &
        & 0.56560e+00,0.49547e+00,0.44792e+00,0.43980e+00,0.41568e+00, &
        & 0.39571e+00,0.39516e+00,0.42687e+00,0.48767e+00 /)
      kao(:, 2, 8,13) = (/ &
        & 0.55986e+00,0.49068e+00,0.44130e+00,0.43344e+00,0.40921e+00, &
        & 0.39033e+00,0.39006e+00,0.42429e+00,0.48458e+00 /)
      kao(:, 3, 8,13) = (/ &
        & 0.55439e+00,0.48622e+00,0.43604e+00,0.42727e+00,0.40340e+00, &
        & 0.38637e+00,0.38517e+00,0.42255e+00,0.48243e+00 /)
      kao(:, 4, 8,13) = (/ &
        & 0.55085e+00,0.48344e+00,0.43251e+00,0.42285e+00,0.39791e+00, &
        & 0.38219e+00,0.38096e+00,0.42076e+00,0.48039e+00 /)
      kao(:, 5, 8,13) = (/ &
        & 0.54722e+00,0.48060e+00,0.42969e+00,0.41964e+00,0.39283e+00, &
        & 0.37840e+00,0.37699e+00,0.41955e+00,0.47894e+00 /)
      kao(:, 1, 9,13) = (/ &
        & 0.58672e+00,0.51388e+00,0.47909e+00,0.46769e+00,0.44479e+00, &
        & 0.42421e+00,0.41694e+00,0.44339e+00,0.50662e+00 /)
      kao(:, 2, 9,13) = (/ &
        & 0.58159e+00,0.50951e+00,0.47213e+00,0.46028e+00,0.43736e+00, &
        & 0.41895e+00,0.41246e+00,0.44257e+00,0.50550e+00 /)
      kao(:, 3, 9,13) = (/ &
        & 0.57736e+00,0.50610e+00,0.46657e+00,0.45431e+00,0.43100e+00, &
        & 0.41543e+00,0.40868e+00,0.44206e+00,0.50480e+00 /)
      kao(:, 4, 9,13) = (/ &
        & 0.57459e+00,0.50394e+00,0.46330e+00,0.44994e+00,0.42562e+00, &
        & 0.41143e+00,0.40432e+00,0.44089e+00,0.50333e+00 /)
      kao(:, 5, 9,13) = (/ &
        & 0.57136e+00,0.50148e+00,0.46136e+00,0.44665e+00,0.42115e+00, &
        & 0.40792e+00,0.40001e+00,0.43966e+00,0.50186e+00 /)
      kao(:, 1,10,13) = (/ &
        & 0.60279e+00,0.52914e+00,0.50725e+00,0.49385e+00,0.47296e+00, &
        & 0.45056e+00,0.43650e+00,0.45649e+00,0.52069e+00 /)
      kao(:, 2,10,13) = (/ &
        & 0.59826e+00,0.52452e+00,0.50048e+00,0.48635e+00,0.46511e+00, &
        & 0.44618e+00,0.43278e+00,0.45737e+00,0.52170e+00 /)
      kao(:, 3,10,13) = (/ &
        & 0.59590e+00,0.52228e+00,0.49610e+00,0.47997e+00,0.45903e+00, &
        & 0.44309e+00,0.42962e+00,0.45759e+00,0.52208e+00 /)
      kao(:, 4,10,13) = (/ &
        & 0.59454e+00,0.52120e+00,0.49388e+00,0.47548e+00,0.45447e+00, &
        & 0.44006e+00,0.42512e+00,0.45631e+00,0.52061e+00 /)
      kao(:, 5,10,13) = (/ &
        & 0.59357e+00,0.52070e+00,0.49246e+00,0.47250e+00,0.45028e+00, &
        & 0.43610e+00,0.42114e+00,0.45529e+00,0.51951e+00 /)
      kao(:, 1,11,13) = (/ &
        & 0.60887e+00,0.53839e+00,0.52807e+00,0.51587e+00,0.49623e+00, &
        & 0.47362e+00,0.45440e+00,0.46645e+00,0.53001e+00 /)
      kao(:, 2,11,13) = (/ &
        & 0.60756e+00,0.53578e+00,0.52411e+00,0.50806e+00,0.48992e+00, &
        & 0.47089e+00,0.45204e+00,0.46808e+00,0.53215e+00 /)
      kao(:, 3,11,13) = (/ &
        & 0.60793e+00,0.53524e+00,0.52214e+00,0.50280e+00,0.48540e+00, &
        & 0.46881e+00,0.44770e+00,0.46764e+00,0.53195e+00 /)
      kao(:, 4,11,13) = (/ &
        & 0.60970e+00,0.53618e+00,0.52106e+00,0.49960e+00,0.48160e+00, &
        & 0.46481e+00,0.44371e+00,0.46667e+00,0.53096e+00 /)
      kao(:, 5,11,13) = (/ &
        & 0.61038e+00,0.53650e+00,0.52014e+00,0.49804e+00,0.47818e+00, &
        & 0.45984e+00,0.44017e+00,0.46579e+00,0.53008e+00 /)
      kao(:, 1,12,13) = (/ &
        & 0.60957e+00,0.54609e+00,0.54565e+00,0.53521e+00,0.51779e+00, &
        & 0.49593e+00,0.47189e+00,0.47309e+00,0.46983e+00 /)
      kao(:, 2,12,13) = (/ &
        & 0.61214e+00,0.54625e+00,0.54367e+00,0.52921e+00,0.51339e+00, &
        & 0.49443e+00,0.46946e+00,0.47371e+00,0.47545e+00 /)
      kao(:, 3,12,13) = (/ &
        & 0.61642e+00,0.54787e+00,0.54269e+00,0.52579e+00,0.50981e+00, &
        & 0.49118e+00,0.46605e+00,0.47265e+00,0.47706e+00 /)
      kao(:, 4,12,13) = (/ &
        & 0.62028e+00,0.54980e+00,0.54303e+00,0.52440e+00,0.50697e+00, &
        & 0.48619e+00,0.46182e+00,0.47123e+00,0.48084e+00 /)
      kao(:, 5,12,13) = (/ &
        & 0.62175e+00,0.55026e+00,0.54305e+00,0.52373e+00,0.50407e+00, &
        & 0.48153e+00,0.45738e+00,0.46998e+00,0.48415e+00 /)
      kao(:, 1,13,13) = (/ &
        & 0.60459e+00,0.55304e+00,0.55845e+00,0.55195e+00,0.53769e+00, &
        & 0.51606e+00,0.48661e+00,0.47383e+00,0.40484e+00 /)
      kao(:, 2,13,13) = (/ &
        & 0.61134e+00,0.55569e+00,0.55809e+00,0.54885e+00,0.53426e+00, &
        & 0.51450e+00,0.48473e+00,0.47289e+00,0.40823e+00 /)
      kao(:, 3,13,13) = (/ &
        & 0.61890e+00,0.55963e+00,0.55924e+00,0.54802e+00,0.53230e+00, &
        & 0.51039e+00,0.48075e+00,0.47078e+00,0.41355e+00 /)
      kao(:, 4,13,13) = (/ &
        & 0.62388e+00,0.56213e+00,0.56099e+00,0.54740e+00,0.52999e+00, &
        & 0.50582e+00,0.47603e+00,0.46901e+00,0.41977e+00 /)
      kao(:, 5,13,13) = (/ &
        & 0.62688e+00,0.56314e+00,0.56152e+00,0.54685e+00,0.52723e+00, &
        & 0.50138e+00,0.47115e+00,0.46700e+00,0.42405e+00 /)
      kao(:, 1, 1,14) = (/ &
        & 0.52445e+00,0.46003e+00,0.39566e+00,0.33139e+00,0.26995e+00, &
        & 0.25837e+00,0.28528e+00,0.32819e+00,0.35568e+00 /)
      kao(:, 2, 1,14) = (/ &
        & 0.51513e+00,0.45183e+00,0.38858e+00,0.32553e+00,0.26784e+00, &
        & 0.25515e+00,0.28229e+00,0.32456e+00,0.35149e+00 /)
      kao(:, 3, 1,14) = (/ &
        & 0.50548e+00,0.44334e+00,0.38125e+00,0.32054e+00,0.26590e+00, &
        & 0.25305e+00,0.28136e+00,0.32218e+00,0.34858e+00 /)
      kao(:, 4, 1,14) = (/ &
        & 0.49563e+00,0.43466e+00,0.37374e+00,0.31559e+00,0.26350e+00, &
        & 0.25115e+00,0.28088e+00,0.32077e+00,0.34651e+00 /)
      kao(:, 5, 1,14) = (/ &
        & 0.48636e+00,0.42650e+00,0.36724e+00,0.31119e+00,0.26146e+00, &
        & 0.24908e+00,0.27907e+00,0.31920e+00,0.34392e+00 /)
      kao(:, 1, 2,14) = (/ &
        & 0.56575e+00,0.49609e+00,0.42647e+00,0.35691e+00,0.29788e+00, &
        & 0.29937e+00,0.33584e+00,0.38701e+00,0.42822e+00 /)
      kao(:, 2, 2,14) = (/ &
        & 0.55481e+00,0.48648e+00,0.41819e+00,0.35023e+00,0.29393e+00, &
        & 0.29578e+00,0.33190e+00,0.38233e+00,0.42282e+00 /)
      kao(:, 3, 2,14) = (/ &
        & 0.54468e+00,0.47756e+00,0.41048e+00,0.34498e+00,0.29076e+00, &
        & 0.29330e+00,0.33000e+00,0.37899e+00,0.41892e+00 /)
      kao(:, 4, 2,14) = (/ &
        & 0.53444e+00,0.46857e+00,0.40281e+00,0.34010e+00,0.28772e+00, &
        & 0.29117e+00,0.32899e+00,0.37674e+00,0.41581e+00 /)
      kao(:, 5, 2,14) = (/ &
        & 0.52472e+00,0.46000e+00,0.39601e+00,0.33543e+00,0.28544e+00, &
        & 0.28841e+00,0.32728e+00,0.37488e+00,0.41300e+00 /)
      kao(:, 1, 3,14) = (/ &
        & 0.61401e+00,0.53826e+00,0.46254e+00,0.38687e+00,0.33653e+00, &
        & 0.34874e+00,0.39278e+00,0.45331e+00,0.51178e+00 /)
      kao(:, 2, 3,14) = (/ &
        & 0.60181e+00,0.52754e+00,0.45329e+00,0.37917e+00,0.33018e+00, &
        & 0.34432e+00,0.38762e+00,0.44735e+00,0.50487e+00 /)
      kao(:, 3, 3,14) = (/ &
        & 0.59018e+00,0.51732e+00,0.44448e+00,0.37278e+00,0.32516e+00, &
        & 0.34086e+00,0.38493e+00,0.44336e+00,0.50014e+00 /)
      kao(:, 4, 3,14) = (/ &
        & 0.57893e+00,0.50743e+00,0.43595e+00,0.36714e+00,0.32113e+00, &
        & 0.33824e+00,0.38315e+00,0.44016e+00,0.49598e+00 /)
      kao(:, 5, 3,14) = (/ &
        & 0.56842e+00,0.49818e+00,0.42822e+00,0.36203e+00,0.31748e+00, &
        & 0.33494e+00,0.38145e+00,0.43774e+00,0.49238e+00 /)
      kao(:, 1, 4,14) = (/ &
        & 0.66683e+00,0.58444e+00,0.50208e+00,0.41977e+00,0.38494e+00, &
        & 0.40485e+00,0.45417e+00,0.52508e+00,0.59839e+00 /)
      kao(:, 2, 4,14) = (/ &
        & 0.65354e+00,0.57275e+00,0.49199e+00,0.41128e+00,0.37591e+00, &
        & 0.39916e+00,0.44835e+00,0.51820e+00,0.59043e+00 /)
      kao(:, 3, 4,14) = (/ &
        & 0.64071e+00,0.56148e+00,0.48227e+00,0.40388e+00,0.36879e+00, &
        & 0.39404e+00,0.44465e+00,0.51320e+00,0.58464e+00 /)
      kao(:, 4, 4,14) = (/ &
        & 0.62844e+00,0.55070e+00,0.47297e+00,0.39753e+00,0.36329e+00, &
        & 0.39017e+00,0.44183e+00,0.50881e+00,0.57888e+00 /)
      kao(:, 5, 4,14) = (/ &
        & 0.61748e+00,0.54106e+00,0.46467e+00,0.39213e+00,0.35832e+00, &
        & 0.38631e+00,0.43926e+00,0.50522e+00,0.57403e+00 /)
      kao(:, 1, 5,14) = (/ &
        & 0.72260e+00,0.63317e+00,0.54375e+00,0.45913e+00,0.43732e+00, &
        & 0.46505e+00,0.51783e+00,0.59954e+00,0.68564e+00 /)
      kao(:, 2, 5,14) = (/ &
        & 0.70858e+00,0.62085e+00,0.53314e+00,0.44897e+00,0.42823e+00, &
        & 0.45720e+00,0.51115e+00,0.59162e+00,0.67653e+00 /)
      kao(:, 3, 5,14) = (/ &
        & 0.69539e+00,0.60926e+00,0.52314e+00,0.43994e+00,0.42099e+00, &
        & 0.45017e+00,0.50656e+00,0.58542e+00,0.66941e+00 /)
      kao(:, 4, 5,14) = (/ &
        & 0.68235e+00,0.59780e+00,0.51326e+00,0.43281e+00,0.41557e+00, &
        & 0.44468e+00,0.50258e+00,0.57996e+00,0.66206e+00 /)
      kao(:, 5, 5,14) = (/ &
        & 0.67018e+00,0.58711e+00,0.50404e+00,0.42628e+00,0.41131e+00, &
        & 0.43975e+00,0.49863e+00,0.57477e+00,0.65556e+00 /)
      kao(:, 1, 6,14) = (/ &
        & 0.77964e+00,0.68298e+00,0.58633e+00,0.50766e+00,0.49641e+00, &
        & 0.52605e+00,0.58161e+00,0.67425e+00,0.77212e+00 /)
      kao(:, 2, 6,14) = (/ &
        & 0.76589e+00,0.67092e+00,0.57596e+00,0.49531e+00,0.48834e+00, &
        & 0.51573e+00,0.57361e+00,0.66493e+00,0.76124e+00 /)
      kao(:, 3, 6,14) = (/ &
        & 0.75251e+00,0.65917e+00,0.56583e+00,0.48459e+00,0.48115e+00, &
        & 0.50704e+00,0.56757e+00,0.65686e+00,0.75182e+00 /)
      kao(:, 4, 6,14) = (/ &
        & 0.73905e+00,0.64728e+00,0.55554e+00,0.47565e+00,0.47497e+00, &
        & 0.50004e+00,0.56191e+00,0.64957e+00,0.74243e+00 /)
      kao(:, 5, 6,14) = (/ &
        & 0.72636e+00,0.63608e+00,0.54581e+00,0.46758e+00,0.47009e+00, &
        & 0.49349e+00,0.55635e+00,0.64252e+00,0.73397e+00 /)
      kao(:, 1, 7,14) = (/ &
        & 0.84113e+00,0.73668e+00,0.63225e+00,0.56459e+00,0.56168e+00, &
        & 0.58736e+00,0.64476e+00,0.74759e+00,0.85655e+00 /)
      kao(:, 2, 7,14) = (/ &
        & 0.82630e+00,0.72365e+00,0.62103e+00,0.55091e+00,0.55367e+00, &
        & 0.57467e+00,0.63457e+00,0.73605e+00,0.84323e+00 /)
      kao(:, 3, 7,14) = (/ &
        & 0.81279e+00,0.71173e+00,0.61068e+00,0.53944e+00,0.54564e+00, &
        & 0.56363e+00,0.62610e+00,0.72557e+00,0.83073e+00 /)
      kao(:, 4, 7,14) = (/ &
        & 0.79922e+00,0.69978e+00,0.60035e+00,0.52974e+00,0.53833e+00, &
        & 0.55444e+00,0.61857e+00,0.71625e+00,0.81942e+00 /)
      kao(:, 5, 7,14) = (/ &
        & 0.78598e+00,0.68814e+00,0.59031e+00,0.52130e+00,0.53249e+00, &
        & 0.54592e+00,0.61225e+00,0.70842e+00,0.80994e+00 /)
      kao(:, 1, 8,14) = (/ &
        & 0.90865e+00,0.79552e+00,0.68301e+00,0.62894e+00,0.62980e+00, &
        & 0.64956e+00,0.70917e+00,0.82179e+00,0.94167e+00 /)
      kao(:, 2, 8,14) = (/ &
        & 0.89327e+00,0.78202e+00,0.67089e+00,0.61713e+00,0.62095e+00, &
        & 0.63402e+00,0.69617e+00,0.80717e+00,0.92484e+00 /)
      kao(:, 3, 8,14) = (/ &
        & 0.87903e+00,0.76952e+00,0.66001e+00,0.60628e+00,0.61235e+00, &
        & 0.62019e+00,0.68531e+00,0.79440e+00,0.90974e+00 /)
      kao(:, 4, 8,14) = (/ &
        & 0.86460e+00,0.75687e+00,0.64914e+00,0.59649e+00,0.60349e+00, &
        & 0.60828e+00,0.67580e+00,0.78318e+00,0.89639e+00 /)
      kao(:, 5, 8,14) = (/ &
        & 0.85091e+00,0.74488e+00,0.63886e+00,0.58665e+00,0.59566e+00, &
        & 0.59754e+00,0.66827e+00,0.77422e+00,0.88585e+00 /)
      kao(:, 1, 9,14) = (/ &
        & 0.98149e+00,0.85912e+00,0.74373e+00,0.70295e+00,0.70214e+00, &
        & 0.71285e+00,0.77237e+00,0.89352e+00,0.10239e+01 /)
      kao(:, 2, 9,14) = (/ &
        & 0.96640e+00,0.84589e+00,0.73081e+00,0.69152e+00,0.69170e+00, &
        & 0.69439e+00,0.75605e+00,0.87558e+00,0.10032e+01 /)
      kao(:, 3, 9,14) = (/ &
        & 0.95188e+00,0.83316e+00,0.71892e+00,0.68080e+00,0.68028e+00, &
        & 0.67751e+00,0.74271e+00,0.86004e+00,0.98493e+00 /)
      kao(:, 4, 9,14) = (/ &
        & 0.93737e+00,0.82045e+00,0.70700e+00,0.67076e+00,0.66785e+00, &
        & 0.66265e+00,0.73184e+00,0.84775e+00,0.97055e+00 /)
      kao(:, 5, 9,14) = (/ &
        & 0.92346e+00,0.80828e+00,0.69536e+00,0.66047e+00,0.65652e+00, &
        & 0.65000e+00,0.72388e+00,0.83863e+00,0.95986e+00 /)
      kao(:, 1,10,14) = (/ &
        & 0.10577e+01,0.92576e+00,0.81364e+00,0.78190e+00,0.77617e+00, &
        & 0.77603e+00,0.83269e+00,0.96109e+00,0.11008e+01 /)
      kao(:, 2,10,14) = (/ &
        & 0.10450e+01,0.91463e+00,0.80097e+00,0.77046e+00,0.76182e+00, &
        & 0.75411e+00,0.81384e+00,0.94032e+00,0.10769e+01 /)
      kao(:, 3,10,14) = (/ &
        & 0.10312e+01,0.90248e+00,0.78812e+00,0.75969e+00,0.74632e+00, &
        & 0.73436e+00,0.79822e+00,0.92300e+00,0.10571e+01 /)
      kao(:, 4,10,14) = (/ &
        & 0.10164e+01,0.88956e+00,0.77444e+00,0.74952e+00,0.73099e+00, &
        & 0.71729e+00,0.78702e+00,0.91062e+00,0.10426e+01 /)
      kao(:, 5,10,14) = (/ &
        & 0.10010e+01,0.87610e+00,0.76045e+00,0.73747e+00,0.71669e+00, &
        & 0.70419e+00,0.77819e+00,0.90060e+00,0.10309e+01 /)
      kao(:, 1,11,14) = (/ &
        & 0.11332e+01,0.99169e+00,0.88520e+00,0.85938e+00,0.84171e+00, &
        & 0.82777e+00,0.88045e+00,0.10119e+01,0.11581e+01 /)
      kao(:, 2,11,14) = (/ &
        & 0.11221e+01,0.98196e+00,0.87210e+00,0.84745e+00,0.82287e+00, &
        & 0.80383e+00,0.86097e+00,0.99198e+00,0.11355e+01 /)
      kao(:, 3,11,14) = (/ &
        & 0.11079e+01,0.96953e+00,0.85745e+00,0.83492e+00,0.80465e+00, &
        & 0.78293e+00,0.84710e+00,0.97731e+00,0.11185e+01 /)
      kao(:, 4,11,14) = (/ &
        & 0.10888e+01,0.95287e+00,0.84018e+00,0.82112e+00,0.78666e+00, &
        & 0.76752e+00,0.83583e+00,0.96514e+00,0.11044e+01 /)
      kao(:, 5,11,14) = (/ &
        & 0.10701e+01,0.93668e+00,0.82311e+00,0.80490e+00,0.77024e+00, &
        & 0.75616e+00,0.82679e+00,0.95569e+00,0.10935e+01 /)
      kao(:, 1,12,14) = (/ &
        & 0.12101e+01,0.10589e+01,0.96254e+00,0.93478e+00,0.90424e+00, &
        & 0.88111e+00,0.92612e+00,0.10566e+01,0.12084e+01 /)
      kao(:, 2,12,14) = (/ &
        & 0.11952e+01,0.10459e+01,0.94639e+00,0.91979e+00,0.88299e+00, &
        & 0.85667e+00,0.90737e+00,0.10393e+01,0.11885e+01 /)
      kao(:, 3,12,14) = (/ &
        & 0.11758e+01,0.10290e+01,0.92827e+00,0.90412e+00,0.86234e+00, &
        & 0.83719e+00,0.89320e+00,0.10260e+01,0.11732e+01 /)
      kao(:, 4,12,14) = (/ &
        & 0.11552e+01,0.10111e+01,0.90821e+00,0.88659e+00,0.84346e+00, &
        & 0.82327e+00,0.88324e+00,0.10165e+01,0.11624e+01 /)
      kao(:, 5,12,14) = (/ &
        & 0.11370e+01,0.99527e+00,0.88941e+00,0.86803e+00,0.82686e+00, &
        & 0.81098e+00,0.87502e+00,0.10085e+01,0.11531e+01 /)
      kao(:, 1,13,14) = (/ &
        & 0.12761e+01,0.11169e+01,0.10366e+01,0.10056e+01,0.96619e+00, &
        & 0.93741e+00,0.96971e+00,0.10971e+01,0.12455e+01 /)
      kao(:, 2,13,14) = (/ &
        & 0.12590e+01,0.11018e+01,0.10193e+01,0.98827e+00,0.94401e+00, &
        & 0.91331e+00,0.95200e+00,0.10824e+01,0.12321e+01 /)
      kao(:, 3,13,14) = (/ &
        & 0.12382e+01,0.10836e+01,0.99864e+00,0.96922e+00,0.92237e+00, &
        & 0.89570e+00,0.94013e+00,0.10732e+01,0.12212e+01 /)
      kao(:, 4,13,14) = (/ &
        & 0.12192e+01,0.10671e+01,0.97718e+00,0.94975e+00,0.90316e+00, &
        & 0.88110e+00,0.93100e+00,0.10658e+01,0.12124e+01 /)
      kao(:, 5,13,14) = (/ &
        & 0.12013e+01,0.10515e+01,0.95818e+00,0.93022e+00,0.88690e+00, &
        & 0.86844e+00,0.92401e+00,0.10605e+01,0.12064e+01 /)
      kao(:, 1, 1,15) = (/ &
        & 0.70834e+00,0.62203e+00,0.53582e+00,0.44981e+00,0.36430e+00, &
        & 0.30456e+00,0.33772e+00,0.39113e+00,0.42417e+00 /)
      kao(:, 2, 1,15) = (/ &
        & 0.69132e+00,0.60682e+00,0.52239e+00,0.43815e+00,0.35442e+00, &
        & 0.29618e+00,0.32847e+00,0.37897e+00,0.41053e+00 /)
      kao(:, 3, 1,15) = (/ &
        & 0.67551e+00,0.59273e+00,0.51002e+00,0.42746e+00,0.34540e+00, &
        & 0.29170e+00,0.32190e+00,0.37054e+00,0.40056e+00 /)
      kao(:, 4, 1,15) = (/ &
        & 0.65954e+00,0.57855e+00,0.49762e+00,0.41681e+00,0.33774e+00, &
        & 0.29058e+00,0.31932e+00,0.36553e+00,0.39416e+00 /)
      kao(:, 5, 1,15) = (/ &
        & 0.64426e+00,0.56502e+00,0.48582e+00,0.40671e+00,0.33237e+00, &
        & 0.29156e+00,0.32280e+00,0.36526e+00,0.39257e+00 /)
      kao(:, 1, 2,15) = (/ &
        & 0.79278e+00,0.69566e+00,0.59863e+00,0.50180e+00,0.40547e+00, &
        & 0.36074e+00,0.40858e+00,0.47363e+00,0.52463e+00 /)
      kao(:, 2, 2,15) = (/ &
        & 0.77384e+00,0.67879e+00,0.58381e+00,0.48896e+00,0.39453e+00, &
        & 0.34912e+00,0.39677e+00,0.45884e+00,0.50797e+00 /)
      kao(:, 3, 2,15) = (/ &
        & 0.75601e+00,0.66296e+00,0.56995e+00,0.47701e+00,0.38437e+00, &
        & 0.34005e+00,0.38826e+00,0.44800e+00,0.49524e+00 /)
      kao(:, 4, 2,15) = (/ &
        & 0.73809e+00,0.64708e+00,0.55610e+00,0.46517e+00,0.37616e+00, &
        & 0.33560e+00,0.38277e+00,0.44095e+00,0.48660e+00 /)
      kao(:, 5, 2,15) = (/ &
        & 0.72001e+00,0.63111e+00,0.54222e+00,0.45336e+00,0.36992e+00, &
        & 0.33536e+00,0.38227e+00,0.43734e+00,0.48144e+00 /)
      kao(:, 1, 3,15) = (/ &
        & 0.88640e+00,0.77731e+00,0.66826e+00,0.55931e+00,0.45077e+00, &
        & 0.42993e+00,0.49594e+00,0.57510e+00,0.65079e+00 /)
      kao(:, 2, 3,15) = (/ &
        & 0.86545e+00,0.75870e+00,0.65198e+00,0.54530e+00,0.43919e+00, &
        & 0.41467e+00,0.48152e+00,0.55764e+00,0.63093e+00 /)
      kao(:, 3, 3,15) = (/ &
        & 0.84484e+00,0.74046e+00,0.63609e+00,0.53174e+00,0.42841e+00, &
        & 0.40263e+00,0.47018e+00,0.54358e+00,0.61450e+00 /)
      kao(:, 4, 3,15) = (/ &
        & 0.82484e+00,0.72279e+00,0.62074e+00,0.51870e+00,0.41933e+00, &
        & 0.39440e+00,0.46214e+00,0.53355e+00,0.60235e+00 /)
      kao(:, 5, 3,15) = (/ &
        & 0.80403e+00,0.70444e+00,0.60484e+00,0.50526e+00,0.41249e+00, &
        & 0.39177e+00,0.45674e+00,0.52614e+00,0.59324e+00 /)
      kao(:, 1, 4,15) = (/ &
        & 0.98775e+00,0.86568e+00,0.74362e+00,0.62157e+00,0.50893e+00, &
        & 0.51227e+00,0.60104e+00,0.69710e+00,0.79722e+00 /)
      kao(:, 2, 4,15) = (/ &
        & 0.96448e+00,0.84510e+00,0.72572e+00,0.60634e+00,0.49496e+00, &
        & 0.49365e+00,0.58337e+00,0.67615e+00,0.77326e+00 /)
      kao(:, 3, 4,15) = (/ &
        & 0.94121e+00,0.82456e+00,0.70790e+00,0.59124e+00,0.48214e+00, &
        & 0.47977e+00,0.56920e+00,0.65880e+00,0.75281e+00 /)
      kao(:, 4, 4,15) = (/ &
        & 0.91776e+00,0.80389e+00,0.69002e+00,0.57613e+00,0.47050e+00, &
        & 0.47009e+00,0.55863e+00,0.64595e+00,0.73761e+00 /)
      kao(:, 5, 4,15) = (/ &
        & 0.89560e+00,0.78437e+00,0.67314e+00,0.56190e+00,0.46260e+00, &
        & 0.46419e+00,0.55009e+00,0.63560e+00,0.72526e+00 /)
      kao(:, 1, 5,15) = (/ &
        & 0.10958e+01,0.95999e+00,0.82419e+00,0.68839e+00,0.58904e+00, &
        & 0.60909e+00,0.72523e+00,0.84139e+00,0.96623e+00 /)
      kao(:, 2, 5,15) = (/ &
        & 0.10697e+01,0.93701e+00,0.80427e+00,0.67151e+00,0.56892e+00, &
        & 0.58963e+00,0.70431e+00,0.81667e+00,0.93800e+00 /)
      kao(:, 3, 5,15) = (/ &
        & 0.10434e+01,0.91377e+00,0.78415e+00,0.65453e+00,0.55082e+00, &
        & 0.57510e+00,0.68668e+00,0.79542e+00,0.91311e+00 /)
      kao(:, 4, 5,15) = (/ &
        & 0.10167e+01,0.89033e+00,0.76393e+00,0.63753e+00,0.53477e+00, &
        & 0.56392e+00,0.67291e+00,0.77892e+00,0.89383e+00 /)
      kao(:, 5, 5,15) = (/ &
        & 0.99271e+00,0.86922e+00,0.74573e+00,0.62224e+00,0.52129e+00, &
        & 0.55503e+00,0.66157e+00,0.76538e+00,0.87797e+00 /)
      kao(:, 1, 6,15) = (/ &
        & 0.12165e+01,0.10653e+01,0.91421e+00,0.76309e+00,0.68684e+00, &
        & 0.72751e+00,0.87072e+00,0.10104e+01,0.11626e+01 /)
      kao(:, 2, 6,15) = (/ &
        & 0.11851e+01,0.10377e+01,0.89038e+00,0.74302e+00,0.66078e+00, &
        & 0.70740e+00,0.84652e+00,0.98180e+00,0.11298e+01 /)
      kao(:, 3, 6,15) = (/ &
        & 0.11540e+01,0.10104e+01,0.86680e+00,0.72322e+00,0.63673e+00, &
        & 0.69046e+00,0.82558e+00,0.95705e+00,0.11007e+01 /)
      kao(:, 4, 6,15) = (/ &
        & 0.11233e+01,0.98347e+00,0.84364e+00,0.70381e+00,0.61623e+00, &
        & 0.67656e+00,0.80855e+00,0.93682e+00,0.10775e+01 /)
      kao(:, 5, 6,15) = (/ &
        & 0.10954e+01,0.95895e+00,0.82254e+00,0.68614e+00,0.59850e+00, &
        & 0.66513e+00,0.79440e+00,0.92006e+00,0.10579e+01 /)
      kao(:, 1, 7,15) = (/ &
        & 0.13516e+01,0.11834e+01,0.10152e+01,0.84752e+00,0.80189e+00, &
        & 0.86751e+00,0.10388e+01,0.12059e+01,0.13885e+01 /)
      kao(:, 2, 7,15) = (/ &
        & 0.13129e+01,0.11495e+01,0.98601e+00,0.82254e+00,0.76801e+00, &
        & 0.84476e+00,0.10112e+01,0.11733e+01,0.13510e+01 /)
      kao(:, 3, 7,15) = (/ &
        & 0.12754e+01,0.11166e+01,0.95771e+00,0.79885e+00,0.73832e+00, &
        & 0.82499e+00,0.98705e+00,0.11448e+01,0.13179e+01 /)
      kao(:, 4, 7,15) = (/ &
        & 0.12391e+01,0.10847e+01,0.93032e+00,0.77593e+00,0.71267e+00, &
        & 0.80837e+00,0.96685e+00,0.11210e+01,0.12906e+01 /)
      kao(:, 5, 7,15) = (/ &
        & 0.12065e+01,0.10561e+01,0.90576e+00,0.75539e+00,0.69035e+00, &
        & 0.79409e+00,0.94938e+00,0.11005e+01,0.12668e+01 /)
      kao(:, 1, 8,15) = (/ &
        & 0.14988e+01,0.13122e+01,0.11257e+01,0.95045e+00,0.92736e+00, &
        & 0.10268e+01,0.12293e+01,0.14274e+01,0.16436e+01 /)
      kao(:, 2, 8,15) = (/ &
        & 0.14532e+01,0.12722e+01,0.10913e+01,0.91652e+00,0.88763e+00, &
        & 0.10018e+01,0.11994e+01,0.13921e+01,0.16030e+01 /)
      kao(:, 3, 8,15) = (/ &
        & 0.14089e+01,0.12334e+01,0.10579e+01,0.88636e+00,0.85277e+00, &
        & 0.97910e+00,0.11719e+01,0.13598e+01,0.15656e+01 /)
      kao(:, 4, 8,15) = (/ &
        & 0.13671e+01,0.11967e+01,0.10263e+01,0.85849e+00,0.82373e+00, &
        & 0.95955e+00,0.11482e+01,0.13320e+01,0.15338e+01 /)
      kao(:, 5, 8,15) = (/ &
        & 0.13292e+01,0.11635e+01,0.99774e+00,0.83411e+00,0.79958e+00, &
        & 0.94221e+00,0.11271e+01,0.13073e+01,0.15052e+01 /)
      kao(:, 1, 9,15) = (/ &
        & 0.16562e+01,0.14500e+01,0.12437e+01,0.10742e+01,0.10651e+01, &
        & 0.12070e+01,0.14445e+01,0.16775e+01,0.19311e+01 /)
      kao(:, 2, 9,15) = (/ &
        & 0.16034e+01,0.14036e+01,0.12039e+01,0.10312e+01,0.10206e+01, &
        & 0.11791e+01,0.14116e+01,0.16391e+01,0.18869e+01 /)
      kao(:, 3, 9,15) = (/ &
        & 0.15525e+01,0.13590e+01,0.11655e+01,0.99233e+00,0.98476e+00, &
        & 0.11530e+01,0.13804e+01,0.16026e+01,0.18449e+01 /)
      kao(:, 4, 9,15) = (/ &
        & 0.15047e+01,0.13171e+01,0.11295e+01,0.95737e+00,0.95592e+00, &
        & 0.11301e+01,0.13529e+01,0.15703e+01,0.18077e+01 /)
      kao(:, 5, 9,15) = (/ &
        & 0.14611e+01,0.12789e+01,0.10967e+01,0.92635e+00,0.93256e+00, &
        & 0.11088e+01,0.13272e+01,0.15403e+01,0.17730e+01 /)
      kao(:, 1,10,15) = (/ &
        & 0.18225e+01,0.15953e+01,0.13682e+01,0.12131e+01,0.12195e+01, &
        & 0.14041e+01,0.16789e+01,0.19504e+01,0.22442e+01 /)
      kao(:, 2,10,15) = (/ &
        & 0.17586e+01,0.15393e+01,0.13201e+01,0.11608e+01,0.11760e+01, &
        & 0.13729e+01,0.16424e+01,0.19078e+01,0.21951e+01 /)
      kao(:, 3,10,15) = (/ &
        & 0.16992e+01,0.14873e+01,0.12754e+01,0.11134e+01,0.11408e+01, &
        & 0.13430e+01,0.16073e+01,0.18666e+01,0.21480e+01 /)
      kao(:, 4,10,15) = (/ &
        & 0.16453e+01,0.14401e+01,0.12349e+01,0.10705e+01,0.11101e+01, &
        & 0.13157e+01,0.15751e+01,0.18293e+01,0.21045e+01 /)
      kao(:, 5,10,15) = (/ &
        & 0.15976e+01,0.13983e+01,0.11990e+01,0.10350e+01,0.10845e+01, &
        & 0.12900e+01,0.15444e+01,0.17936e+01,0.20634e+01 /)
      kao(:, 1,11,15) = (/ &
        & 0.19716e+01,0.17256e+01,0.14797e+01,0.13408e+01,0.13798e+01, &
        & 0.16011e+01,0.19108e+01,0.22209e+01,0.25534e+01 /)
      kao(:, 2,11,15) = (/ &
        & 0.18980e+01,0.16613e+01,0.14245e+01,0.12841e+01,0.13393e+01, &
        & 0.15661e+01,0.18703e+01,0.21736e+01,0.24991e+01 /)
      kao(:, 3,11,15) = (/ &
        & 0.18334e+01,0.16046e+01,0.13758e+01,0.12346e+01,0.13019e+01, &
        & 0.15332e+01,0.18320e+01,0.21288e+01,0.24477e+01 /)
      kao(:, 4,11,15) = (/ &
        & 0.17833e+01,0.15608e+01,0.13382e+01,0.11928e+01,0.12697e+01, &
        & 0.15019e+01,0.17959e+01,0.20867e+01,0.23990e+01 /)
      kao(:, 5,11,15) = (/ &
        & 0.17385e+01,0.15215e+01,0.13045e+01,0.11584e+01,0.12412e+01, &
        & 0.14723e+01,0.17610e+01,0.20462e+01,0.23526e+01 /)
      kao(:, 1,12,15) = (/ &
        & 0.21322e+01,0.18661e+01,0.16009e+01,0.14913e+01,0.15626e+01, &
        & 0.18065e+01,0.21498e+01,0.24997e+01,0.28719e+01 /)
      kao(:, 2,12,15) = (/ &
        & 0.20605e+01,0.18033e+01,0.15462e+01,0.14346e+01,0.15183e+01, &
        & 0.17679e+01,0.21055e+01,0.24481e+01,0.28126e+01 /)
      kao(:, 3,12,15) = (/ &
        & 0.20007e+01,0.17509e+01,0.15011e+01,0.13841e+01,0.14777e+01, &
        & 0.17312e+01,0.20634e+01,0.23990e+01,0.27564e+01 /)
      kao(:, 4,12,15) = (/ &
        & 0.19501e+01,0.17066e+01,0.14631e+01,0.13415e+01,0.14420e+01, &
        & 0.16956e+01,0.20218e+01,0.23506e+01,0.27007e+01 /)
      kao(:, 5,12,15) = (/ &
        & 0.19023e+01,0.16648e+01,0.14272e+01,0.13048e+01,0.14093e+01, &
        & 0.16619e+01,0.19834e+01,0.23060e+01,0.26492e+01 /)
      kao(:, 1,13,15) = (/ &
        & 0.23283e+01,0.20376e+01,0.17570e+01,0.16678e+01,0.17574e+01, &
        & 0.20182e+01,0.23943e+01,0.27850e+01,0.31979e+01 /)
      kao(:, 2,13,15) = (/ &
        & 0.22552e+01,0.19735e+01,0.16974e+01,0.16068e+01,0.17079e+01, &
        & 0.19757e+01,0.23460e+01,0.27289e+01,0.31334e+01 /)
      kao(:, 3,13,15) = (/ &
        & 0.21945e+01,0.19204e+01,0.16488e+01,0.15544e+01,0.16639e+01, &
        & 0.19336e+01,0.22972e+01,0.26723e+01,0.30681e+01 /)
      kao(:, 4,13,15) = (/ &
        & 0.21377e+01,0.18706e+01,0.16045e+01,0.15082e+01,0.16235e+01, &
        & 0.18922e+01,0.22504e+01,0.26179e+01,0.30055e+01 /)
      kao(:, 5,13,15) = (/ &
        & 0.20822e+01,0.18221e+01,0.15623e+01,0.14670e+01,0.15845e+01, &
        & 0.18531e+01,0.22061e+01,0.25663e+01,0.29464e+01 /)
      kao(:, 1, 1,16) = (/ &
        & 0.84891e+00,0.74682e+00,0.64540e+00,0.54510e+00,0.44671e+00, &
        & 0.34895e+00,0.38105e+00,0.44177e+00,0.47725e+00 /)
      kao(:, 2, 1,16) = (/ &
        & 0.82292e+00,0.72425e+00,0.62615e+00,0.52904e+00,0.43334e+00, &
        & 0.33791e+00,0.37758e+00,0.43769e+00,0.47292e+00 /)
      kao(:, 3, 1,16) = (/ &
        & 0.79766e+00,0.70221e+00,0.60725e+00,0.51315e+00,0.42001e+00, &
        & 0.32708e+00,0.37351e+00,0.43297e+00,0.46789e+00 /)
      kao(:, 4, 1,16) = (/ &
        & 0.77341e+00,0.68098e+00,0.58899e+00,0.49774e+00,0.40711e+00, &
        & 0.31834e+00,0.36899e+00,0.42775e+00,0.46227e+00 /)
      kao(:, 5, 1,16) = (/ &
        & 0.74989e+00,0.66035e+00,0.57119e+00,0.48264e+00,0.39437e+00, &
        & 0.32430e+00,0.36416e+00,0.42216e+00,0.45636e+00 /)
      kao(:, 1, 2,16) = (/ &
        & 0.98489e+00,0.86457e+00,0.74461e+00,0.62525e+00,0.50699e+00, &
        & 0.39502e+00,0.46270e+00,0.53626e+00,0.59246e+00 /)
      kao(:, 2, 2,16) = (/ &
        & 0.95110e+00,0.83523e+00,0.71967e+00,0.60464e+00,0.49055e+00, &
        & 0.38714e+00,0.45775e+00,0.53066e+00,0.58669e+00 /)
      kao(:, 3, 2,16) = (/ &
        & 0.91868e+00,0.80699e+00,0.69557e+00,0.58461e+00,0.47447e+00, &
        & 0.38030e+00,0.45287e+00,0.52498e+00,0.58057e+00 /)
      kao(:, 4, 2,16) = (/ &
        & 0.88783e+00,0.78006e+00,0.67253e+00,0.56540e+00,0.45894e+00, &
        & 0.37426e+00,0.44739e+00,0.51869e+00,0.57355e+00 /)
      kao(:, 5, 2,16) = (/ &
        & 0.85824e+00,0.75420e+00,0.65037e+00,0.54691e+00,0.44407e+00, &
        & 0.37572e+00,0.44151e+00,0.51192e+00,0.56619e+00 /)
      kao(:, 1, 3,16) = (/ &
        & 0.11382e+01,0.99791e+00,0.85785e+00,0.71816e+00,0.57913e+00, &
        & 0.47378e+00,0.56732e+00,0.65745e+00,0.74321e+00 /)
      kao(:, 2, 3,16) = (/ &
        & 0.10944e+01,0.95984e+00,0.82550e+00,0.69149e+00,0.55807e+00, &
        & 0.46534e+00,0.55716e+00,0.64588e+00,0.73020e+00 /)
      kao(:, 3, 3,16) = (/ &
        & 0.10534e+01,0.92416e+00,0.79509e+00,0.66633e+00,0.53808e+00, &
        & 0.45863e+00,0.54915e+00,0.63663e+00,0.71995e+00 /)
      kao(:, 4, 3,16) = (/ &
        & 0.10141e+01,0.88986e+00,0.76582e+00,0.64206e+00,0.51870e+00, &
        & 0.45265e+00,0.54212e+00,0.62853e+00,0.71089e+00 /)
      kao(:, 5, 3,16) = (/ &
        & 0.97757e+00,0.85802e+00,0.73862e+00,0.61943e+00,0.50068e+00, &
        & 0.44732e+00,0.53486e+00,0.62017e+00,0.70154e+00 /)
      kao(:, 1, 4,16) = (/ &
        & 0.13027e+01,0.11412e+01,0.97988e+00,0.81881e+00,0.65819e+00, &
        & 0.58495e+00,0.70040e+00,0.81176e+00,0.92845e+00 /)
      kao(:, 2, 4,16) = (/ &
        & 0.12473e+01,0.10931e+01,0.93894e+00,0.78506e+00,0.63160e+00, &
        & 0.57073e+00,0.68340e+00,0.79216e+00,0.90610e+00 /)
      kao(:, 3, 4,16) = (/ &
        & 0.11956e+01,0.10481e+01,0.90063e+00,0.75344e+00,0.60663e+00, &
        & 0.55958e+00,0.67003e+00,0.77669e+00,0.88836e+00 /)
      kao(:, 4, 4,16) = (/ &
        & 0.11480e+01,0.10066e+01,0.86532e+00,0.72426e+00,0.58351e+00, &
        & 0.54965e+00,0.65819e+00,0.76307e+00,0.87291e+00 /)
      kao(:, 5, 4,16) = (/ &
        & 0.11042e+01,0.96837e+00,0.83267e+00,0.69709e+00,0.56180e+00, &
        & 0.54039e+00,0.64710e+00,0.75045e+00,0.85825e+00 /)
      kao(:, 1, 5,16) = (/ &
        & 0.14755e+01,0.12919e+01,0.11084e+01,0.92503e+00,0.74199e+00, &
        & 0.72656e+00,0.86992e+00,0.10084e+01,0.11593e+01 /)
      kao(:, 2, 5,16) = (/ &
        & 0.14077e+01,0.12330e+01,0.10584e+01,0.88396e+00,0.70985e+00, &
        & 0.70337e+00,0.84221e+00,0.97628e+00,0.11223e+01 /)
      kao(:, 3, 5,16) = (/ &
        & 0.13473e+01,0.11805e+01,0.10138e+01,0.84723e+00,0.68084e+00, &
        & 0.68573e+00,0.82117e+00,0.95190e+00,0.10943e+01 /)
      kao(:, 4, 5,16) = (/ &
        & 0.12931e+01,0.11332e+01,0.97336e+00,0.81358e+00,0.65399e+00, &
        & 0.67083e+00,0.80321e+00,0.93120e+00,0.10704e+01 /)
      kao(:, 5, 5,16) = (/ &
        & 0.12425e+01,0.10889e+01,0.93535e+00,0.78185e+00,0.62849e+00, &
        & 0.65706e+00,0.78689e+00,0.91252e+00,0.10486e+01 /)
      kao(:, 1, 6,16) = (/ &
        & 0.16632e+01,0.14561e+01,0.12491e+01,0.10422e+01,0.83545e+00, &
        & 0.90592e+00,0.10850e+01,0.12579e+01,0.14491e+01 /)
      kao(:, 2, 6,16) = (/ &
        & 0.15885e+01,0.13911e+01,0.11938e+01,0.99649e+00,0.79932e+00, &
        & 0.87105e+00,0.10430e+01,0.12092e+01,0.13933e+01 /)
      kao(:, 3, 6,16) = (/ &
        & 0.15219e+01,0.13330e+01,0.11441e+01,0.95525e+00,0.76651e+00, &
        & 0.84460e+00,0.10114e+01,0.11726e+01,0.13510e+01 /)
      kao(:, 4, 6,16) = (/ &
        & 0.14602e+01,0.12790e+01,0.10978e+01,0.91668e+00,0.73549e+00, &
        & 0.82233e+00,0.98468e+00,0.11417e+01,0.13152e+01 /)
      kao(:, 5, 6,16) = (/ &
        & 0.14027e+01,0.12286e+01,0.10546e+01,0.88053e+00,0.70846e+00, &
        & 0.80220e+00,0.96072e+00,0.11140e+01,0.12832e+01 /)
      kao(:, 1, 7,16) = (/ &
        & 0.18802e+01,0.16460e+01,0.14119e+01,0.11779e+01,0.95036e+00, &
        & 0.11297e+01,0.13528e+01,0.15688e+01,0.18094e+01 /)
      kao(:, 2, 7,16) = (/ &
        & 0.17989e+01,0.15751e+01,0.13512e+01,0.11274e+01,0.91055e+00, &
        & 0.10797e+01,0.12930e+01,0.14993e+01,0.17294e+01 /)
      kao(:, 3, 7,16) = (/ &
        & 0.17245e+01,0.15100e+01,0.12954e+01,0.10809e+01,0.87508e+00, &
        & 0.10422e+01,0.12481e+01,0.14473e+01,0.16693e+01 /)
      kao(:, 4, 7,16) = (/ &
        & 0.16543e+01,0.14485e+01,0.12427e+01,0.10370e+01,0.84724e+00, &
        & 0.10105e+01,0.12102e+01,0.14035e+01,0.16185e+01 /)
      kao(:, 5, 7,16) = (/ &
        & 0.15884e+01,0.13908e+01,0.11932e+01,0.99569e+00,0.82331e+00, &
        & 0.98227e+00,0.11764e+01,0.13643e+01,0.15734e+01 /)
      kao(:, 1, 8,16) = (/ &
        & 0.21327e+01,0.18670e+01,0.16012e+01,0.13355e+01,0.11430e+01, &
        & 0.14062e+01,0.16843e+01,0.19535e+01,0.22540e+01 /)
      kao(:, 2, 8,16) = (/ &
        & 0.20434e+01,0.17888e+01,0.15342e+01,0.12796e+01,0.10891e+01, &
        & 0.13377e+01,0.16020e+01,0.18582e+01,0.21442e+01 /)
      kao(:, 3, 8,16) = (/ &
        & 0.19592e+01,0.17151e+01,0.14711e+01,0.12270e+01,0.10443e+01, &
        & 0.12854e+01,0.15395e+01,0.17855e+01,0.20605e+01 /)
      kao(:, 4, 8,16) = (/ &
        & 0.18795e+01,0.16454e+01,0.14112e+01,0.11771e+01,0.10093e+01, &
        & 0.12418e+01,0.14873e+01,0.17251e+01,0.19905e+01 /)
      kao(:, 5, 8,16) = (/ &
        & 0.18040e+01,0.15793e+01,0.13546e+01,0.11298e+01,0.97893e+00, &
        & 0.12029e+01,0.14409e+01,0.16715e+01,0.19284e+01 /)
      kao(:, 1, 9,16) = (/ &
        & 0.24263e+01,0.21237e+01,0.18212e+01,0.15186e+01,0.14038e+01, &
        & 0.17468e+01,0.20923e+01,0.24275e+01,0.28010e+01 /)
      kao(:, 2, 9,16) = (/ &
        & 0.23266e+01,0.20365e+01,0.17464e+01,0.14563e+01,0.13334e+01, &
        & 0.16567e+01,0.19843e+01,0.23023e+01,0.26565e+01 /)
      kao(:, 3, 9,16) = (/ &
        & 0.22311e+01,0.19529e+01,0.16747e+01,0.13965e+01,0.12741e+01, &
        & 0.15855e+01,0.18989e+01,0.22031e+01,0.25421e+01 /)
      kao(:, 4, 9,16) = (/ &
        & 0.21400e+01,0.18731e+01,0.16063e+01,0.13394e+01,0.12261e+01, &
        & 0.15261e+01,0.18280e+01,0.21210e+01,0.24473e+01 /)
      kao(:, 5, 9,16) = (/ &
        & 0.20537e+01,0.17976e+01,0.15415e+01,0.12854e+01,0.11844e+01, &
        & 0.14739e+01,0.17653e+01,0.20482e+01,0.23631e+01 /)
      kao(:, 1,10,16) = (/ &
        & 0.27556e+01,0.24117e+01,0.20679e+01,0.17241e+01,0.17250e+01, &
        & 0.21531e+01,0.25793e+01,0.29930e+01,0.34529e+01 /)
      kao(:, 2,10,16) = (/ &
        & 0.26436e+01,0.23137e+01,0.19838e+01,0.16540e+01,0.16343e+01, &
        & 0.20375e+01,0.24406e+01,0.28326e+01,0.32672e+01 /)
      kao(:, 3,10,16) = (/ &
        & 0.25350e+01,0.22187e+01,0.19024e+01,0.15861e+01,0.15582e+01, &
        & 0.19443e+01,0.23290e+01,0.27026e+01,0.31178e+01 /)
      kao(:, 4,10,16) = (/ &
        & 0.24300e+01,0.21267e+01,0.18235e+01,0.15203e+01,0.14955e+01, &
        & 0.18662e+01,0.22353e+01,0.25942e+01,0.29924e+01 /)
      kao(:, 5,10,16) = (/ &
        & 0.23355e+01,0.20440e+01,0.17526e+01,0.14611e+01,0.14399e+01, &
        & 0.17966e+01,0.21521e+01,0.24975e+01,0.28809e+01 /)
      kao(:, 1,11,16) = (/ &
        & 0.30736e+01,0.26899e+01,0.23062e+01,0.19287e+01,0.20594e+01, &
        & 0.25707e+01,0.30796e+01,0.35755e+01,0.41218e+01 /)
      kao(:, 2,11,16) = (/ &
        & 0.29458e+01,0.25780e+01,0.22102e+01,0.18490e+01,0.19506e+01, &
        & 0.24353e+01,0.29176e+01,0.33867e+01,0.39048e+01 /)
      kao(:, 3,11,16) = (/ &
        & 0.28287e+01,0.24755e+01,0.21223e+01,0.17723e+01,0.18621e+01, &
        & 0.23252e+01,0.27855e+01,0.32334e+01,0.37281e+01 /)
      kao(:, 4,11,16) = (/ &
        & 0.27181e+01,0.23787e+01,0.20393e+01,0.17010e+01,0.17848e+01, &
        & 0.22284e+01,0.26698e+01,0.30991e+01,0.35730e+01 /)
      kao(:, 5,11,16) = (/ &
        & 0.26214e+01,0.22941e+01,0.19667e+01,0.16394e+01,0.17149e+01, &
        & 0.21409e+01,0.25649e+01,0.29778e+01,0.34326e+01 /)
      kao(:, 1,12,16) = (/ &
        & 0.34457e+01,0.30154e+01,0.25850e+01,0.22002e+01,0.24421e+01, &
        & 0.30491e+01,0.36532e+01,0.42422e+01,0.48881e+01 /)
      kao(:, 2,12,16) = (/ &
        & 0.33132e+01,0.28993e+01,0.24855e+01,0.21037e+01,0.23175e+01, &
        & 0.28938e+01,0.34673e+01,0.40262e+01,0.46397e+01 /)
      kao(:, 3,12,16) = (/ &
        & 0.31843e+01,0.27866e+01,0.23888e+01,0.20132e+01,0.22107e+01, &
        & 0.27603e+01,0.33070e+01,0.38403e+01,0.44248e+01 /)
      kao(:, 4,12,16) = (/ &
        & 0.30610e+01,0.26787e+01,0.22963e+01,0.19289e+01,0.21145e+01, &
        & 0.26402e+01,0.31632e+01,0.36735e+01,0.42326e+01 /)
      kao(:, 5,12,16) = (/ &
        & 0.29533e+01,0.25844e+01,0.22155e+01,0.18569e+01,0.20264e+01, &
        & 0.25300e+01,0.30314e+01,0.35205e+01,0.40560e+01 /)
      kao(:, 1,13,16) = (/ &
        & 0.38898e+01,0.34039e+01,0.29179e+01,0.25320e+01,0.28809e+01, &
        & 0.35965e+01,0.43091e+01,0.50055e+01,0.57650e+01 /)
      kao(:, 2,13,16) = (/ &
        & 0.37371e+01,0.32702e+01,0.28033e+01,0.24146e+01,0.27330e+01, &
        & 0.34120e+01,0.40886e+01,0.47494e+01,0.54692e+01 /)
      kao(:, 3,13,16) = (/ &
        & 0.35846e+01,0.31367e+01,0.26889e+01,0.23047e+01,0.26019e+01, &
        & 0.32482e+01,0.38921e+01,0.45212e+01,0.52066e+01 /)
      kao(:, 4,13,16) = (/ &
        & 0.34450e+01,0.30146e+01,0.25842e+01,0.22048e+01,0.24829e+01, &
        & 0.31006e+01,0.37153e+01,0.43162e+01,0.49694e+01 /)
      kao(:, 5,13,16) = (/ &
        & 0.33226e+01,0.29075e+01,0.24923e+01,0.21144e+01,0.23741e+01, &
        & 0.29651e+01,0.35532e+01,0.41282e+01,0.47532e+01 /)
  
!     -----------------------------------------------------------------
!     The array KBO contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels < ~100mb and temperatures. The first 
!     index in the array, JT, which runs from 1 to 5, corresponds to 
!     different temperatures.  More specifically, JT = 3 means that the 
!     data are for the reference temperature TREF for this pressure 
!     level, JT = 2 refers to the temperature TREF-15, JT = 1 is for
!     TREF-30, JT = 4 is for TREF+15, and JT = 5 is for TREF+30.  
!     The second index, JP, runs from 13 to 59 and refers to the JPth
!     reference pressure level (see taumol.f for the value of these
!     pressure levels in mb).  The third index, IG, goes from 1 to 16,
!     and tells us which g-interval the absorption coefficients are for.
!     -----------------------------------------------------------------

      kbo(:,13, 1) = (/ &
        & 0.78344e-03,0.81478e-03,0.83713e-03,0.85265e-03,0.85991e-03 /)
      kbo(:,14, 1) = (/ &
        & 0.65374e-03,0.67963e-03,0.69840e-03,0.71131e-03,0.71719e-03 /)
      kbo(:,15, 1) = (/ &
        & 0.55587e-03,0.57751e-03,0.59343e-03,0.60410e-03,0.60993e-03 /)
      kbo(:,16, 1) = (/ &
        & 0.48145e-03,0.49780e-03,0.51251e-03,0.52093e-03,0.52706e-03 /)
      kbo(:,17, 1) = (/ &
        & 0.42610e-03,0.43577e-03,0.44892e-03,0.45812e-03,0.46352e-03 /)
      kbo(:,18, 1) = (/ &
        & 0.38503e-03,0.38849e-03,0.40094e-03,0.41067e-03,0.41529e-03 /)
      kbo(:,19, 1) = (/ &
        & 0.35025e-03,0.34902e-03,0.35803e-03,0.36759e-03,0.37429e-03 /)
      kbo(:,20, 1) = (/ &
        & 0.30557e-03,0.30381e-03,0.30983e-03,0.31782e-03,0.32429e-03 /)
      kbo(:,21, 1) = (/ &
        & 0.26346e-03,0.26127e-03,0.26616e-03,0.27270e-03,0.27830e-03 /)
      kbo(:,22, 1) = (/ &
        & 0.22630e-03,0.22463e-03,0.22867e-03,0.23419e-03,0.23829e-03 /)
      kbo(:,23, 1) = (/ &
        & 0.19498e-03,0.19376e-03,0.19644e-03,0.20096e-03,0.20404e-03 /)
      kbo(:,24, 1) = (/ &
        & 0.16839e-03,0.16687e-03,0.16820e-03,0.17215e-03,0.17490e-03 /)
      kbo(:,25, 1) = (/ &
        & 0.14494e-03,0.14347e-03,0.14334e-03,0.14728e-03,0.14954e-03 /)
      kbo(:,26, 1) = (/ &
        & 0.12363e-03,0.12241e-03,0.12233e-03,0.12518e-03,0.12767e-03 /)
      kbo(:,27, 1) = (/ &
        & 0.10560e-03,0.10482e-03,0.10446e-03,0.10681e-03,0.10897e-03 /)
      kbo(:,28, 1) = (/ &
        & 0.90453e-04,0.89921e-04,0.89199e-04,0.91278e-04,0.93235e-04 /)
      kbo(:,29, 1) = (/ &
        & 0.77854e-04,0.77467e-04,0.76947e-04,0.77977e-04,0.79713e-04 /)
      kbo(:,30, 1) = (/ &
        & 0.67346e-04,0.67074e-04,0.66981e-04,0.67340e-04,0.68453e-04 /)
      kbo(:,31, 1) = (/ &
        & 0.58739e-04,0.58583e-04,0.58517e-04,0.58421e-04,0.59277e-04 /)
      kbo(:,32, 1) = (/ &
        & 0.51671e-04,0.51476e-04,0.51254e-04,0.51199e-04,0.51510e-04 /)
      kbo(:,33, 1) = (/ &
        & 0.45523e-04,0.45406e-04,0.45028e-04,0.44849e-04,0.44977e-04 /)
      kbo(:,34, 1) = (/ &
        & 0.40256e-04,0.40062e-04,0.39751e-04,0.39416e-04,0.39181e-04 /)
      kbo(:,35, 1) = (/ &
        & 0.35762e-04,0.35429e-04,0.35245e-04,0.34916e-04,0.34484e-04 /)
      kbo(:,36, 1) = (/ &
        & 0.31776e-04,0.31666e-04,0.31200e-04,0.31013e-04,0.30768e-04 /)
      kbo(:,37, 1) = (/ &
        & 0.26934e-04,0.26971e-04,0.26615e-04,0.26355e-04,0.26214e-04 /)
      kbo(:,38, 1) = (/ &
        & 0.22652e-04,0.22874e-04,0.22686e-04,0.22466e-04,0.22266e-04 /)
      kbo(:,39, 1) = (/ &
        & 0.18970e-04,0.19273e-04,0.19385e-04,0.19198e-04,0.19016e-04 /)
      kbo(:,40, 1) = (/ &
        & 0.15533e-04,0.15831e-04,0.15964e-04,0.15836e-04,0.15700e-04 /)
      kbo(:,41, 1) = (/ &
        & 0.12668e-04,0.12826e-04,0.12999e-04,0.13018e-04,0.12872e-04 /)
      kbo(:,42, 1) = (/ &
        & 0.10356e-04,0.10475e-04,0.10620e-04,0.10666e-04,0.10580e-04 /)
      kbo(:,43, 1) = (/ &
        & 0.83551e-05,0.84490e-05,0.85217e-05,0.86140e-05,0.86044e-05 /)
      kbo(:,44, 1) = (/ &
        & 0.66829e-05,0.68022e-05,0.68791e-05,0.69429e-05,0.69314e-05 /)
      kbo(:,45, 1) = (/ &
        & 0.53860e-05,0.54494e-05,0.55341e-05,0.55544e-05,0.55761e-05 /)
      kbo(:,46, 1) = (/ &
        & 0.43207e-05,0.43601e-05,0.44477e-05,0.44761e-05,0.44727e-05 /)
      kbo(:,47, 1) = (/ &
        & 0.34852e-05,0.34924e-05,0.35555e-05,0.35928e-05,0.35957e-05 /)
      kbo(:,48, 1) = (/ &
        & 0.27913e-05,0.28024e-05,0.28395e-05,0.28713e-05,0.28836e-05 /)
      kbo(:,49, 1) = (/ &
        & 0.22267e-05,0.22549e-05,0.22736e-05,0.22769e-05,0.23083e-05 /)
      kbo(:,50, 1) = (/ &
        & 0.17814e-05,0.18056e-05,0.18272e-05,0.18178e-05,0.18340e-05 /)
      kbo(:,51, 1) = (/ &
        & 0.14202e-05,0.14390e-05,0.14605e-05,0.14515e-05,0.14607e-05 /)
      kbo(:,52, 1) = (/ &
        & 0.11328e-05,0.11511e-05,0.11629e-05,0.11627e-05,0.11618e-05 /)
      kbo(:,53, 1) = (/ &
        & 0.90478e-06,0.91291e-06,0.92251e-06,0.92910e-06,0.92898e-06 /)
      kbo(:,54, 1) = (/ &
        & 0.71737e-06,0.72444e-06,0.73271e-06,0.73646e-06,0.74079e-06 /)
      kbo(:,55, 1) = (/ &
        & 0.56522e-06,0.57444e-06,0.57690e-06,0.58444e-06,0.59006e-06 /)
      kbo(:,56, 1) = (/ &
        & 0.44522e-06,0.45152e-06,0.45592e-06,0.46208e-06,0.46721e-06 /)
      kbo(:,57, 1) = (/ &
        & 0.35045e-06,0.35432e-06,0.36035e-06,0.36444e-06,0.36942e-06 /)
      kbo(:,58, 1) = (/ &
        & 0.27513e-06,0.27793e-06,0.28330e-06,0.28729e-06,0.29229e-06 /)
      kbo(:,59, 1) = (/ &
        & 0.21608e-06,0.21966e-06,0.22301e-06,0.22740e-06,0.23129e-06 /)
      kbo(:,13, 2) = (/ &
        & 0.41669e-02,0.42141e-02,0.42434e-02,0.42683e-02,0.42755e-02 /)
      kbo(:,14, 2) = (/ &
        & 0.34875e-02,0.35201e-02,0.35377e-02,0.35547e-02,0.35629e-02 /)
      kbo(:,15, 2) = (/ &
        & 0.29417e-02,0.29682e-02,0.29797e-02,0.29877e-02,0.29948e-02 /)
      kbo(:,16, 2) = (/ &
        & 0.25072e-02,0.25337e-02,0.25373e-02,0.25423e-02,0.25464e-02 /)
      kbo(:,17, 2) = (/ &
        & 0.21640e-02,0.21948e-02,0.21974e-02,0.21951e-02,0.21930e-02 /)
      kbo(:,18, 2) = (/ &
        & 0.18910e-02,0.19229e-02,0.19301e-02,0.19201e-02,0.19153e-02 /)
      kbo(:,19, 2) = (/ &
        & 0.16495e-02,0.16848e-02,0.16944e-02,0.16885e-02,0.16779e-02 /)
      kbo(:,20, 2) = (/ &
        & 0.14018e-02,0.14333e-02,0.14424e-02,0.14394e-02,0.14287e-02 /)
      kbo(:,21, 2) = (/ &
        & 0.11832e-02,0.12125e-02,0.12189e-02,0.12151e-02,0.12082e-02 /)
      kbo(:,22, 2) = (/ &
        & 0.99669e-03,0.10233e-02,0.10268e-02,0.10250e-02,0.10191e-02 /)
      kbo(:,23, 2) = (/ &
        & 0.83734e-03,0.86220e-03,0.86642e-03,0.86487e-03,0.86054e-03 /)
      kbo(:,24, 2) = (/ &
        & 0.70349e-03,0.72654e-03,0.73243e-03,0.73077e-03,0.72754e-03 /)
      kbo(:,25, 2) = (/ &
        & 0.59070e-03,0.61044e-03,0.61929e-03,0.61773e-03,0.61583e-03 /)
      kbo(:,26, 2) = (/ &
        & 0.49716e-03,0.51139e-03,0.52115e-03,0.52139e-03,0.52023e-03 /)
      kbo(:,27, 2) = (/ &
        & 0.41822e-03,0.42737e-03,0.43808e-03,0.43978e-03,0.43884e-03 /)
      kbo(:,28, 2) = (/ &
        & 0.35061e-03,0.35848e-03,0.36841e-03,0.37095e-03,0.37053e-03 /)
      kbo(:,29, 2) = (/ &
        & 0.29391e-03,0.30227e-03,0.30912e-03,0.31376e-03,0.31382e-03 /)
      kbo(:,30, 2) = (/ &
        & 0.24878e-03,0.25551e-03,0.25990e-03,0.26493e-03,0.26717e-03 /)
      kbo(:,31, 2) = (/ &
        & 0.21146e-03,0.21606e-03,0.21973e-03,0.22385e-03,0.22711e-03 /)
      kbo(:,32, 2) = (/ &
        & 0.17989e-03,0.18248e-03,0.18678e-03,0.18914e-03,0.19265e-03 /)
      kbo(:,33, 2) = (/ &
        & 0.15377e-03,0.15569e-03,0.15798e-03,0.16109e-03,0.16313e-03 /)
      kbo(:,34, 2) = (/ &
        & 0.13129e-03,0.13289e-03,0.13431e-03,0.13679e-03,0.13869e-03 /)
      kbo(:,35, 2) = (/ &
        & 0.11225e-03,0.11370e-03,0.11480e-03,0.11616e-03,0.11774e-03 /)
      kbo(:,36, 2) = (/ &
        & 0.96722e-04,0.97093e-04,0.98641e-04,0.99964e-04,0.10029e-03 /)
      kbo(:,37, 2) = (/ &
        & 0.81278e-04,0.81350e-04,0.82442e-04,0.83555e-04,0.83990e-04 /)
      kbo(:,38, 2) = (/ &
        & 0.68481e-04,0.68398e-04,0.68899e-04,0.69737e-04,0.70187e-04 /)
      kbo(:,39, 2) = (/ &
        & 0.57588e-04,0.57895e-04,0.57814e-04,0.58095e-04,0.58861e-04 /)
      kbo(:,40, 2) = (/ &
        & 0.47541e-04,0.47609e-04,0.47587e-04,0.47727e-04,0.48149e-04 /)
      kbo(:,41, 2) = (/ &
        & 0.39099e-04,0.39119e-04,0.39164e-04,0.39161e-04,0.39530e-04 /)
      kbo(:,42, 2) = (/ &
        & 0.32129e-04,0.32067e-04,0.32113e-04,0.32128e-04,0.32332e-04 /)
      kbo(:,43, 2) = (/ &
        & 0.26339e-04,0.26195e-04,0.26218e-04,0.26313e-04,0.26301e-04 /)
      kbo(:,44, 2) = (/ &
        & 0.21510e-04,0.21341e-04,0.21297e-04,0.21378e-04,0.21395e-04 /)
      kbo(:,45, 2) = (/ &
        & 0.17530e-04,0.17454e-04,0.17341e-04,0.17352e-04,0.17454e-04 /)
      kbo(:,46, 2) = (/ &
        & 0.14267e-04,0.14213e-04,0.14118e-04,0.14076e-04,0.14192e-04 /)
      kbo(:,47, 2) = (/ &
        & 0.11510e-04,0.11593e-04,0.11522e-04,0.11431e-04,0.11494e-04 /)
      kbo(:,48, 2) = (/ &
        & 0.92607e-05,0.93963e-05,0.93931e-05,0.93302e-05,0.93175e-05 /)
      kbo(:,49, 2) = (/ &
        & 0.74566e-05,0.75640e-05,0.76551e-05,0.76195e-05,0.75706e-05 /)
      kbo(:,50, 2) = (/ &
        & 0.60069e-05,0.60789e-05,0.61866e-05,0.62136e-05,0.61878e-05 /)
      kbo(:,51, 2) = (/ &
        & 0.48719e-05,0.49189e-05,0.49852e-05,0.50599e-05,0.50406e-05 /)
      kbo(:,52, 2) = (/ &
        & 0.39542e-05,0.39622e-05,0.40023e-05,0.40853e-05,0.41134e-05 /)
      kbo(:,53, 2) = (/ &
        & 0.31898e-05,0.32108e-05,0.32348e-05,0.32873e-05,0.33341e-05 /)
      kbo(:,54, 2) = (/ &
        & 0.25786e-05,0.26009e-05,0.26192e-05,0.26504e-05,0.26983e-05 /)
      kbo(:,55, 2) = (/ &
        & 0.20942e-05,0.21017e-05,0.21274e-05,0.21442e-05,0.21775e-05 /)
      kbo(:,56, 2) = (/ &
        & 0.16959e-05,0.17018e-05,0.17251e-05,0.17374e-05,0.17575e-05 /)
      kbo(:,57, 2) = (/ &
        & 0.13662e-05,0.13805e-05,0.13926e-05,0.14091e-05,0.14210e-05 /)
      kbo(:,58, 2) = (/ &
        & 0.10989e-05,0.11199e-05,0.11269e-05,0.11436e-05,0.11502e-05 /)
      kbo(:,59, 2) = (/ &
        & 0.88647e-06,0.91054e-06,0.91770e-06,0.92872e-06,0.93619e-06 /)
      kbo(:,13, 3) = (/ &
        & 0.91432e-02,0.90907e-02,0.90565e-02,0.89984e-02,0.89385e-02 /)
      kbo(:,14, 3) = (/ &
        & 0.76455e-02,0.75988e-02,0.75709e-02,0.75150e-02,0.74448e-02 /)
      kbo(:,15, 3) = (/ &
        & 0.64231e-02,0.63826e-02,0.63449e-02,0.62999e-02,0.62412e-02 /)
      kbo(:,16, 3) = (/ &
        & 0.54475e-02,0.53998e-02,0.53630e-02,0.53153e-02,0.52574e-02 /)
      kbo(:,17, 3) = (/ &
        & 0.46876e-02,0.46363e-02,0.45869e-02,0.45398e-02,0.44911e-02 /)
      kbo(:,18, 3) = (/ &
        & 0.40806e-02,0.40265e-02,0.39670e-02,0.39185e-02,0.38714e-02 /)
      kbo(:,19, 3) = (/ &
        & 0.35897e-02,0.35272e-02,0.34695e-02,0.34174e-02,0.33721e-02 /)
      kbo(:,20, 3) = (/ &
        & 0.30557e-02,0.30003e-02,0.29518e-02,0.29027e-02,0.28623e-02 /)
      kbo(:,21, 3) = (/ &
        & 0.25840e-02,0.25346e-02,0.24907e-02,0.24530e-02,0.24134e-02 /)
      kbo(:,22, 3) = (/ &
        & 0.21784e-02,0.21342e-02,0.20972e-02,0.20639e-02,0.20310e-02 /)
      kbo(:,23, 3) = (/ &
        & 0.18415e-02,0.17987e-02,0.17683e-02,0.17405e-02,0.17162e-02 /)
      kbo(:,24, 3) = (/ &
        & 0.15599e-02,0.15210e-02,0.14940e-02,0.14715e-02,0.14516e-02 /)
      kbo(:,25, 3) = (/ &
        & 0.13214e-02,0.12882e-02,0.12631e-02,0.12449e-02,0.12269e-02 /)
      kbo(:,26, 3) = (/ &
        & 0.11148e-02,0.10885e-02,0.10663e-02,0.10485e-02,0.10339e-02 /)
      kbo(:,27, 3) = (/ &
        & 0.94180e-03,0.92291e-03,0.90201e-03,0.88582e-03,0.87360e-03 /)
      kbo(:,28, 3) = (/ &
        & 0.79929e-03,0.78315e-03,0.76525e-03,0.75093e-03,0.73943e-03 /)
      kbo(:,29, 3) = (/ &
        & 0.68110e-03,0.66580e-03,0.65234e-03,0.63866e-03,0.62757e-03 /)
      kbo(:,30, 3) = (/ &
        & 0.57975e-03,0.56820e-03,0.55835e-03,0.54581e-03,0.53624e-03 /)
      kbo(:,31, 3) = (/ &
        & 0.49551e-03,0.48804e-03,0.47841e-03,0.46871e-03,0.45833e-03 /)
      kbo(:,32, 3) = (/ &
        & 0.42572e-03,0.42052e-03,0.41099e-03,0.40377e-03,0.39554e-03 /)
      kbo(:,33, 3) = (/ &
        & 0.36528e-03,0.36135e-03,0.35701e-03,0.34948e-03,0.34456e-03 /)
      kbo(:,34, 3) = (/ &
        & 0.31415e-03,0.31283e-03,0.30989e-03,0.30612e-03,0.30054e-03 /)
      kbo(:,35, 3) = (/ &
        & 0.27352e-03,0.27102e-03,0.26979e-03,0.26826e-03,0.26448e-03 /)
      kbo(:,36, 3) = (/ &
        & 0.23967e-03,0.23742e-03,0.23456e-03,0.23474e-03,0.23316e-03 /)
      kbo(:,37, 3) = (/ &
        & 0.20338e-03,0.20142e-03,0.19919e-03,0.19875e-03,0.19818e-03 /)
      kbo(:,38, 3) = (/ &
        & 0.17257e-03,0.17079e-03,0.16890e-03,0.16818e-03,0.16767e-03 /)
      kbo(:,39, 3) = (/ &
        & 0.14733e-03,0.14508e-03,0.14396e-03,0.14263e-03,0.14203e-03 /)
      kbo(:,40, 3) = (/ &
        & 0.12225e-03,0.12069e-03,0.11949e-03,0.11833e-03,0.11808e-03 /)
      kbo(:,41, 3) = (/ &
        & 0.10097e-03,0.10002e-03,0.98765e-04,0.97895e-04,0.97754e-04 /)
      kbo(:,42, 3) = (/ &
        & 0.83346e-04,0.82796e-04,0.81713e-04,0.81007e-04,0.80814e-04 /)
      kbo(:,43, 3) = (/ &
        & 0.68346e-04,0.68043e-04,0.67367e-04,0.66543e-04,0.66059e-04 /)
      kbo(:,44, 3) = (/ &
        & 0.55818e-04,0.55703e-04,0.55284e-04,0.54584e-04,0.54239e-04 /)
      kbo(:,45, 3) = (/ &
        & 0.45332e-04,0.45541e-04,0.45337e-04,0.44929e-04,0.44433e-04 /)
      kbo(:,46, 3) = (/ &
        & 0.36748e-04,0.37223e-04,0.37146e-04,0.36884e-04,0.36439e-04 /)
      kbo(:,47, 3) = (/ &
        & 0.29601e-04,0.30289e-04,0.30405e-04,0.30257e-04,0.29929e-04 /)
      kbo(:,48, 3) = (/ &
        & 0.23826e-04,0.24579e-04,0.24815e-04,0.24762e-04,0.24572e-04 /)
      kbo(:,49, 3) = (/ &
        & 0.19377e-04,0.19814e-04,0.20191e-04,0.20227e-04,0.20080e-04 /)
      kbo(:,50, 3) = (/ &
        & 0.15665e-04,0.15965e-04,0.16366e-04,0.16467e-04,0.16386e-04 /)
      kbo(:,51, 3) = (/ &
        & 0.12631e-04,0.12915e-04,0.13203e-04,0.13389e-04,0.13403e-04 /)
      kbo(:,52, 3) = (/ &
        & 0.10160e-04,0.10402e-04,0.10609e-04,0.10858e-04,0.10900e-04 /)
      kbo(:,53, 3) = (/ &
        & 0.81514e-05,0.83717e-05,0.85717e-05,0.87255e-05,0.88490e-05 /)
      kbo(:,54, 3) = (/ &
        & 0.65924e-05,0.67623e-05,0.69218e-05,0.70363e-05,0.71744e-05 /)
      kbo(:,55, 3) = (/ &
        & 0.53378e-05,0.54823e-05,0.56002e-05,0.57079e-05,0.58136e-05 /)
      kbo(:,56, 3) = (/ &
        & 0.43093e-05,0.44306e-05,0.45341e-05,0.46443e-05,0.47053e-05 /)
      kbo(:,57, 3) = (/ &
        & 0.34880e-05,0.35826e-05,0.36738e-05,0.37492e-05,0.38094e-05 /)
      kbo(:,58, 3) = (/ &
        & 0.28214e-05,0.28911e-05,0.29636e-05,0.30269e-05,0.30943e-05 /)
      kbo(:,59, 3) = (/ &
        & 0.23049e-05,0.23610e-05,0.24232e-05,0.24708e-05,0.25266e-05 /)
      kbo(:,13, 4) = (/ &
        & 0.16886e-01,0.17177e-01,0.17415e-01,0.17613e-01,0.17771e-01 /)
      kbo(:,14, 4) = (/ &
        & 0.14297e-01,0.14572e-01,0.14791e-01,0.14925e-01,0.15051e-01 /)
      kbo(:,15, 4) = (/ &
        & 0.12142e-01,0.12342e-01,0.12507e-01,0.12640e-01,0.12754e-01 /)
      kbo(:,16, 4) = (/ &
        & 0.10284e-01,0.10422e-01,0.10545e-01,0.10662e-01,0.10740e-01 /)
      kbo(:,17, 4) = (/ &
        & 0.87377e-02,0.88415e-02,0.89329e-02,0.90175e-02,0.90716e-02 /)
      kbo(:,18, 4) = (/ &
        & 0.74766e-02,0.75366e-02,0.76038e-02,0.76818e-02,0.77135e-02 /)
      kbo(:,19, 4) = (/ &
        & 0.64241e-02,0.64546e-02,0.65027e-02,0.65449e-02,0.65755e-02 /)
      kbo(:,20, 4) = (/ &
        & 0.54390e-02,0.54528e-02,0.54854e-02,0.55046e-02,0.55309e-02 /)
      kbo(:,21, 4) = (/ &
        & 0.45856e-02,0.45888e-02,0.46080e-02,0.46219e-02,0.46381e-02 /)
      kbo(:,22, 4) = (/ &
        & 0.38581e-02,0.38555e-02,0.38631e-02,0.38756e-02,0.38888e-02 /)
      kbo(:,23, 4) = (/ &
        & 0.32522e-02,0.32442e-02,0.32437e-02,0.32522e-02,0.32616e-02 /)
      kbo(:,24, 4) = (/ &
        & 0.27421e-02,0.27302e-02,0.27267e-02,0.27311e-02,0.27351e-02 /)
      kbo(:,25, 4) = (/ &
        & 0.23082e-02,0.22984e-02,0.22916e-02,0.22928e-02,0.22950e-02 /)
      kbo(:,26, 4) = (/ &
        & 0.19386e-02,0.19299e-02,0.19241e-02,0.19234e-02,0.19234e-02 /)
      kbo(:,27, 4) = (/ &
        & 0.16295e-02,0.16227e-02,0.16172e-02,0.16132e-02,0.16138e-02 /)
      kbo(:,28, 4) = (/ &
        & 0.13714e-02,0.13653e-02,0.13589e-02,0.13555e-02,0.13562e-02 /)
      kbo(:,29, 4) = (/ &
        & 0.11583e-02,0.11513e-02,0.11440e-02,0.11416e-02,0.11458e-02 /)
      kbo(:,30, 4) = (/ &
        & 0.98213e-03,0.97362e-03,0.96774e-03,0.96738e-03,0.97898e-03 /)
      kbo(:,31, 4) = (/ &
        & 0.83694e-03,0.82733e-03,0.82506e-03,0.82584e-03,0.83454e-03 /)
      kbo(:,32, 4) = (/ &
        & 0.71631e-03,0.70972e-03,0.70944e-03,0.70782e-03,0.71382e-03 /)
      kbo(:,33, 4) = (/ &
        & 0.62056e-03,0.61607e-03,0.61112e-03,0.60974e-03,0.61416e-03 /)
      kbo(:,34, 4) = (/ &
        & 0.54260e-03,0.53530e-03,0.53018e-03,0.53196e-03,0.53190e-03 /)
      kbo(:,35, 4) = (/ &
        & 0.47557e-03,0.47060e-03,0.46470e-03,0.46463e-03,0.46278e-03 /)
      kbo(:,36, 4) = (/ &
        & 0.42108e-03,0.41716e-03,0.41356e-03,0.41052e-03,0.40671e-03 /)
      kbo(:,37, 4) = (/ &
        & 0.36059e-03,0.35753e-03,0.35465e-03,0.35204e-03,0.34625e-03 /)
      kbo(:,38, 4) = (/ &
        & 0.30926e-03,0.30682e-03,0.30403e-03,0.30126e-03,0.29597e-03 /)
      kbo(:,39, 4) = (/ &
        & 0.26586e-03,0.26397e-03,0.26023e-03,0.25654e-03,0.25399e-03 /)
      kbo(:,40, 4) = (/ &
        & 0.22228e-03,0.22028e-03,0.21711e-03,0.21418e-03,0.21203e-03 /)
      kbo(:,41, 4) = (/ &
        & 0.18516e-03,0.18277e-03,0.18056e-03,0.17797e-03,0.17615e-03 /)
      kbo(:,42, 4) = (/ &
        & 0.15367e-03,0.15191e-03,0.15012e-03,0.14803e-03,0.14667e-03 /)
      kbo(:,43, 4) = (/ &
        & 0.12696e-03,0.12546e-03,0.12398e-03,0.12239e-03,0.12042e-03 /)
      kbo(:,44, 4) = (/ &
        & 0.10470e-03,0.10323e-03,0.10199e-03,0.10082e-03,0.99093e-04 /)
      kbo(:,45, 4) = (/ &
        & 0.86543e-04,0.84786e-04,0.83972e-04,0.82789e-04,0.81392e-04 /)
      kbo(:,46, 4) = (/ &
        & 0.71529e-04,0.69963e-04,0.68982e-04,0.67996e-04,0.66867e-04 /)
      kbo(:,47, 4) = (/ &
        & 0.59457e-04,0.57707e-04,0.56668e-04,0.55899e-04,0.54959e-04 /)
      kbo(:,48, 4) = (/ &
        & 0.49467e-04,0.47679e-04,0.46593e-04,0.45887e-04,0.45090e-04 /)
      kbo(:,49, 4) = (/ &
        & 0.40766e-04,0.39435e-04,0.38281e-04,0.37548e-04,0.37003e-04 /)
      kbo(:,50, 4) = (/ &
        & 0.33628e-04,0.32753e-04,0.31623e-04,0.30893e-04,0.30385e-04 /)
      kbo(:,51, 4) = (/ &
        & 0.27865e-04,0.27055e-04,0.26162e-04,0.25458e-04,0.24898e-04 /)
      kbo(:,52, 4) = (/ &
        & 0.22934e-04,0.22328e-04,0.21731e-04,0.20990e-04,0.20456e-04 /)
      kbo(:,53, 4) = (/ &
        & 0.18846e-04,0.18445e-04,0.17912e-04,0.17357e-04,0.16833e-04 /)
      kbo(:,54, 4) = (/ &
        & 0.15388e-04,0.15212e-04,0.14808e-04,0.14414e-04,0.13935e-04 /)
      kbo(:,55, 4) = (/ &
        & 0.12598e-04,0.12543e-04,0.12261e-04,0.11957e-04,0.11571e-04 /)
      kbo(:,56, 4) = (/ &
        & 0.10381e-04,0.10344e-04,0.10166e-04,0.98775e-05,0.96020e-05 /)
      kbo(:,57, 4) = (/ &
        & 0.85457e-05,0.84639e-05,0.83932e-05,0.81757e-05,0.79545e-05 /)
      kbo(:,58, 4) = (/ &
        & 0.70397e-05,0.69486e-05,0.69316e-05,0.67696e-05,0.65859e-05 /)
      kbo(:,59, 4) = (/ &
        & 0.58257e-05,0.57596e-05,0.57448e-05,0.56300e-05,0.54831e-05 /)
      kbo(:,13, 5) = (/ &
        & 0.33040e-01,0.33623e-01,0.34360e-01,0.35360e-01,0.36383e-01 /)
      kbo(:,14, 5) = (/ &
        & 0.28634e-01,0.29145e-01,0.29913e-01,0.30773e-01,0.31595e-01 /)
      kbo(:,15, 5) = (/ &
        & 0.24852e-01,0.25387e-01,0.26038e-01,0.26736e-01,0.27406e-01 /)
      kbo(:,16, 5) = (/ &
        & 0.21426e-01,0.21995e-01,0.22531e-01,0.23082e-01,0.23575e-01 /)
      kbo(:,17, 5) = (/ &
        & 0.18563e-01,0.19011e-01,0.19492e-01,0.19940e-01,0.20337e-01 /)
      kbo(:,18, 5) = (/ &
        & 0.16067e-01,0.16476e-01,0.16902e-01,0.17235e-01,0.17579e-01 /)
      kbo(:,19, 5) = (/ &
        & 0.13911e-01,0.14318e-01,0.14657e-01,0.14999e-01,0.15265e-01 /)
      kbo(:,20, 5) = (/ &
        & 0.11889e-01,0.12220e-01,0.12522e-01,0.12793e-01,0.13028e-01 /)
      kbo(:,21, 5) = (/ &
        & 0.10107e-01,0.10365e-01,0.10626e-01,0.10840e-01,0.11030e-01 /)
      kbo(:,22, 5) = (/ &
        & 0.85828e-02,0.88037e-02,0.90066e-02,0.91828e-02,0.93108e-02 /)
      kbo(:,23, 5) = (/ &
        & 0.72873e-02,0.74698e-02,0.76229e-02,0.77606e-02,0.78812e-02 /)
      kbo(:,24, 5) = (/ &
        & 0.61731e-02,0.63486e-02,0.64551e-02,0.65686e-02,0.66826e-02 /)
      kbo(:,25, 5) = (/ &
        & 0.52349e-02,0.53827e-02,0.54728e-02,0.55581e-02,0.56691e-02 /)
      kbo(:,26, 5) = (/ &
        & 0.44343e-02,0.45615e-02,0.46303e-02,0.47140e-02,0.48058e-02 /)
      kbo(:,27, 5) = (/ &
        & 0.37566e-02,0.38599e-02,0.39250e-02,0.39996e-02,0.40739e-02 /)
      kbo(:,28, 5) = (/ &
        & 0.31898e-02,0.32700e-02,0.33284e-02,0.33863e-02,0.34483e-02 /)
      kbo(:,29, 5) = (/ &
        & 0.27069e-02,0.27638e-02,0.28173e-02,0.28668e-02,0.29159e-02 /)
      kbo(:,30, 5) = (/ &
        & 0.22952e-02,0.23414e-02,0.23862e-02,0.24319e-02,0.25045e-02 /)
      kbo(:,31, 5) = (/ &
        & 0.19469e-02,0.19866e-02,0.20269e-02,0.20617e-02,0.21285e-02 /)
      kbo(:,32, 5) = (/ &
        & 0.16569e-02,0.16912e-02,0.17225e-02,0.17537e-02,0.18151e-02 /)
      kbo(:,33, 5) = (/ &
        & 0.14159e-02,0.14407e-02,0.14672e-02,0.14987e-02,0.15568e-02 /)
      kbo(:,34, 5) = (/ &
        & 0.12124e-02,0.12314e-02,0.12565e-02,0.13096e-02,0.13455e-02 /)
      kbo(:,35, 5) = (/ &
        & 0.10402e-02,0.10574e-02,0.10852e-02,0.11323e-02,0.11671e-02 /)
      kbo(:,36, 5) = (/ &
        & 0.89606e-03,0.91393e-03,0.93957e-03,0.98258e-03,0.10142e-02 /)
      kbo(:,37, 5) = (/ &
        & 0.75556e-03,0.77347e-03,0.79494e-03,0.83337e-03,0.86466e-03 /)
      kbo(:,38, 5) = (/ &
        & 0.63793e-03,0.65386e-03,0.67373e-03,0.70925e-03,0.73610e-03 /)
      kbo(:,39, 5) = (/ &
        & 0.53995e-03,0.55394e-03,0.57091e-03,0.59316e-03,0.62725e-03 /)
      kbo(:,40, 5) = (/ &
        & 0.44830e-03,0.46041e-03,0.47605e-03,0.49517e-03,0.52406e-03 /)
      kbo(:,41, 5) = (/ &
        & 0.37113e-03,0.38143e-03,0.39555e-03,0.41230e-03,0.43648e-03 /)
      kbo(:,42, 5) = (/ &
        & 0.30743e-03,0.31617e-03,0.32840e-03,0.34246e-03,0.36323e-03 /)
      kbo(:,43, 5) = (/ &
        & 0.25237e-03,0.25981e-03,0.27013e-03,0.28179e-03,0.29414e-03 /)
      kbo(:,44, 5) = (/ &
        & 0.20643e-03,0.21247e-03,0.22138e-03,0.23093e-03,0.24175e-03 /)
      kbo(:,45, 5) = (/ &
        & 0.16882e-03,0.17379e-03,0.18072e-03,0.18917e-03,0.19837e-03 /)
      kbo(:,46, 5) = (/ &
        & 0.13808e-03,0.14140e-03,0.14740e-03,0.15462e-03,0.16243e-03 /)
      kbo(:,47, 5) = (/ &
        & 0.11262e-03,0.11523e-03,0.12010e-03,0.12571e-03,0.13225e-03 /)
      kbo(:,48, 5) = (/ &
        & 0.91738e-04,0.93816e-04,0.97414e-04,0.10204e-03,0.10733e-03 /)
      kbo(:,49, 5) = (/ &
        & 0.74533e-04,0.76356e-04,0.78756e-04,0.82697e-04,0.86848e-04 /)
      kbo(:,50, 5) = (/ &
        & 0.60870e-04,0.62211e-04,0.64031e-04,0.67056e-04,0.70590e-04 /)
      kbo(:,51, 5) = (/ &
        & 0.49547e-04,0.50786e-04,0.52181e-04,0.54428e-04,0.57574e-04 /)
      kbo(:,52, 5) = (/ &
        & 0.40457e-04,0.41364e-04,0.42403e-04,0.44095e-04,0.46746e-04 /)
      kbo(:,53, 5) = (/ &
        & 0.33032e-04,0.33540e-04,0.34449e-04,0.35762e-04,0.37780e-04 /)
      kbo(:,54, 5) = (/ &
        & 0.27201e-04,0.27411e-04,0.28166e-04,0.29168e-04,0.30744e-04 /)
      kbo(:,55, 5) = (/ &
        & 0.22471e-04,0.22532e-04,0.23075e-04,0.23887e-04,0.25092e-04 /)
      kbo(:,56, 5) = (/ &
        & 0.18480e-04,0.18516e-04,0.18857e-04,0.19555e-04,0.20483e-04 /)
      kbo(:,57, 5) = (/ &
        & 0.15198e-04,0.15262e-04,0.15424e-04,0.15989e-04,0.16742e-04 /)
      kbo(:,58, 5) = (/ &
        & 0.12523e-04,0.12562e-04,0.12648e-04,0.13089e-04,0.13686e-04 /)
      kbo(:,59, 5) = (/ &
        & 0.10416e-04,0.10433e-04,0.10536e-04,0.10919e-04,0.11421e-04 /)
      kbo(:,13, 6) = (/ &
        & 0.69718e-01,0.71167e-01,0.72961e-01,0.74885e-01,0.77322e-01 /)
      kbo(:,14, 6) = (/ &
        & 0.62182e-01,0.63649e-01,0.65193e-01,0.67193e-01,0.69746e-01 /)
      kbo(:,15, 6) = (/ &
        & 0.55177e-01,0.56711e-01,0.58414e-01,0.60422e-01,0.62756e-01 /)
      kbo(:,16, 6) = (/ &
        & 0.48867e-01,0.50234e-01,0.52023e-01,0.54055e-01,0.56254e-01 /)
      kbo(:,17, 6) = (/ &
        & 0.43174e-01,0.44610e-01,0.46287e-01,0.48302e-01,0.50389e-01 /)
      kbo(:,18, 6) = (/ &
        & 0.38339e-01,0.39749e-01,0.41335e-01,0.43237e-01,0.45123e-01 /)
      kbo(:,19, 6) = (/ &
        & 0.34315e-01,0.35543e-01,0.37065e-01,0.38754e-01,0.40597e-01 /)
      kbo(:,20, 6) = (/ &
        & 0.30036e-01,0.31291e-01,0.32637e-01,0.34202e-01,0.35839e-01 /)
      kbo(:,21, 6) = (/ &
        & 0.26135e-01,0.27343e-01,0.28574e-01,0.30000e-01,0.31460e-01 /)
      kbo(:,22, 6) = (/ &
        & 0.22750e-01,0.23832e-01,0.25080e-01,0.26299e-01,0.27580e-01 /)
      kbo(:,23, 6) = (/ &
        & 0.19795e-01,0.20915e-01,0.22028e-01,0.23060e-01,0.24140e-01 /)
      kbo(:,24, 6) = (/ &
        & 0.17353e-01,0.18346e-01,0.19305e-01,0.20238e-01,0.21103e-01 /)
      kbo(:,25, 6) = (/ &
        & 0.15226e-01,0.16064e-01,0.16955e-01,0.17722e-01,0.18477e-01 /)
      kbo(:,26, 6) = (/ &
        & 0.13309e-01,0.14087e-01,0.14848e-01,0.15498e-01,0.16180e-01 /)
      kbo(:,27, 6) = (/ &
        & 0.11623e-01,0.12295e-01,0.12913e-01,0.13525e-01,0.14113e-01 /)
      kbo(:,28, 6) = (/ &
        & 0.10147e-01,0.10710e-01,0.11240e-01,0.11795e-01,0.12384e-01 /)
      kbo(:,29, 6) = (/ &
        & 0.87968e-02,0.92904e-02,0.97797e-02,0.10288e-01,0.10828e-01 /)
      kbo(:,30, 6) = (/ &
        & 0.76490e-02,0.80771e-02,0.85219e-02,0.90152e-02,0.97888e-02 /)
      kbo(:,31, 6) = (/ &
        & 0.66330e-02,0.70376e-02,0.74659e-02,0.79113e-02,0.86622e-02 /)
      kbo(:,32, 6) = (/ &
        & 0.58073e-02,0.61697e-02,0.65754e-02,0.70309e-02,0.77115e-02 /)
      kbo(:,33, 6) = (/ &
        & 0.51062e-02,0.54682e-02,0.58582e-02,0.62737e-02,0.69163e-02 /)
      kbo(:,34, 6) = (/ &
        & 0.45302e-02,0.48855e-02,0.52639e-02,0.58227e-02,0.62719e-02 /)
      kbo(:,35, 6) = (/ &
        & 0.40254e-02,0.43599e-02,0.47158e-02,0.52732e-02,0.57228e-02 /)
      kbo(:,36, 6) = (/ &
        & 0.35647e-02,0.38837e-02,0.42167e-02,0.47705e-02,0.52032e-02 /)
      kbo(:,37, 6) = (/ &
        & 0.30730e-02,0.33561e-02,0.36823e-02,0.41868e-02,0.45932e-02 /)
      kbo(:,38, 6) = (/ &
        & 0.26407e-02,0.29052e-02,0.32061e-02,0.36781e-02,0.40664e-02 /)
      kbo(:,39, 6) = (/ &
        & 0.22667e-02,0.25156e-02,0.28017e-02,0.31173e-02,0.36136e-02 /)
      kbo(:,40, 6) = (/ &
        & 0.19056e-02,0.21267e-02,0.23879e-02,0.26789e-02,0.31309e-02 /)
      kbo(:,41, 6) = (/ &
        & 0.15967e-02,0.17952e-02,0.20263e-02,0.22865e-02,0.27062e-02 /)
      kbo(:,42, 6) = (/ &
        & 0.13343e-02,0.15081e-02,0.17167e-02,0.19538e-02,0.23416e-02 /)
      kbo(:,43, 6) = (/ &
        & 0.10981e-02,0.12492e-02,0.14292e-02,0.16430e-02,0.19013e-02 /)
      kbo(:,44, 6) = (/ &
        & 0.89464e-03,0.10267e-02,0.11827e-02,0.13698e-02,0.16046e-02 /)
      kbo(:,45, 6) = (/ &
        & 0.72683e-03,0.83985e-03,0.97469e-03,0.11376e-02,0.13459e-02 /)
      kbo(:,46, 6) = (/ &
        & 0.58610e-03,0.68242e-03,0.79873e-03,0.94079e-03,0.11248e-02 /)
      kbo(:,47, 6) = (/ &
        & 0.46823e-03,0.54958e-03,0.64876e-03,0.77111e-03,0.93276e-03 /)
      kbo(:,48, 6) = (/ &
        & 0.37202e-03,0.44089e-03,0.52431e-03,0.62811e-03,0.76979e-03 /)
      kbo(:,49, 6) = (/ &
        & 0.29424e-03,0.35087e-03,0.42017e-03,0.50926e-03,0.63166e-03 /)
      kbo(:,50, 6) = (/ &
        & 0.23381e-03,0.28036e-03,0.33854e-03,0.41547e-03,0.52066e-03 /)
      kbo(:,51, 6) = (/ &
        & 0.18542e-03,0.22410e-03,0.27211e-03,0.33806e-03,0.42775e-03 /)
      kbo(:,52, 6) = (/ &
        & 0.14646e-03,0.17824e-03,0.21799e-03,0.27400e-03,0.34964e-03 /)
      kbo(:,53, 6) = (/ &
        & 0.11499e-03,0.14049e-03,0.17412e-03,0.22038e-03,0.28435e-03 /)
      kbo(:,54, 6) = (/ &
        & 0.91160e-04,0.11217e-03,0.13972e-03,0.17793e-03,0.23213e-03 /)
      kbo(:,55, 6) = (/ &
        & 0.72474e-04,0.89606e-04,0.11228e-03,0.14368e-03,0.18928e-03 /)
      kbo(:,56, 6) = (/ &
        & 0.57463e-04,0.71291e-04,0.89786e-04,0.11554e-03,0.15352e-03 /)
      kbo(:,57, 6) = (/ &
        & 0.45287e-04,0.56571e-04,0.71524e-04,0.92319e-04,0.12382e-03 /)
      kbo(:,58, 6) = (/ &
        & 0.35841e-04,0.44939e-04,0.57025e-04,0.73710e-04,0.99673e-04 /)
      kbo(:,59, 6) = (/ &
        & 0.29941e-04,0.37721e-04,0.48119e-04,0.62420e-04,0.85059e-04 /)
      kbo(:,13, 7) = (/ &
        & 0.16189e+00,0.16561e+00,0.16999e+00,0.17514e+00,0.18068e+00 /)
      kbo(:,14, 7) = (/ &
        & 0.14981e+00,0.15416e+00,0.15917e+00,0.16420e+00,0.16989e+00 /)
      kbo(:,15, 7) = (/ &
        & 0.13875e+00,0.14297e+00,0.14757e+00,0.15249e+00,0.15852e+00 /)
      kbo(:,16, 7) = (/ &
        & 0.12672e+00,0.13073e+00,0.13523e+00,0.14037e+00,0.14640e+00 /)
      kbo(:,17, 7) = (/ &
        & 0.11530e+00,0.11958e+00,0.12450e+00,0.12975e+00,0.13596e+00 /)
      kbo(:,18, 7) = (/ &
        & 0.10572e+00,0.11005e+00,0.11482e+00,0.12031e+00,0.12674e+00 /)
      kbo(:,19, 7) = (/ &
        & 0.97798e-01,0.10221e+00,0.10713e+00,0.11251e+00,0.11882e+00 /)
      kbo(:,20, 7) = (/ &
        & 0.88438e-01,0.93059e-01,0.98290e-01,0.10406e+00,0.11034e+00 /)
      kbo(:,21, 7) = (/ &
        & 0.79615e-01,0.84383e-01,0.89776e-01,0.95707e-01,0.10218e+00 /)
      kbo(:,22, 7) = (/ &
        & 0.71663e-01,0.76568e-01,0.81968e-01,0.88106e-01,0.94703e-01 /)
      kbo(:,23, 7) = (/ &
        & 0.64729e-01,0.69601e-01,0.75178e-01,0.81445e-01,0.88072e-01 /)
      kbo(:,24, 7) = (/ &
        & 0.58713e-01,0.63692e-01,0.69398e-01,0.75609e-01,0.82402e-01 /)
      kbo(:,25, 7) = (/ &
        & 0.53422e-01,0.58504e-01,0.64255e-01,0.70582e-01,0.77266e-01 /)
      kbo(:,26, 7) = (/ &
        & 0.48884e-01,0.53907e-01,0.59754e-01,0.66093e-01,0.72781e-01 /)
      kbo(:,27, 7) = (/ &
        & 0.44782e-01,0.49959e-01,0.55649e-01,0.61937e-01,0.68517e-01 /)
      kbo(:,28, 7) = (/ &
        & 0.41164e-01,0.46305e-01,0.52009e-01,0.58205e-01,0.64389e-01 /)
      kbo(:,29, 7) = (/ &
        & 0.37976e-01,0.43033e-01,0.48696e-01,0.54470e-01,0.60707e-01 /)
      kbo(:,30, 7) = (/ &
        & 0.35210e-01,0.40258e-01,0.45653e-01,0.51435e-01,0.59091e-01 /)
      kbo(:,31, 7) = (/ &
        & 0.32774e-01,0.37557e-01,0.43028e-01,0.48762e-01,0.56208e-01 /)
      kbo(:,32, 7) = (/ &
        & 0.30628e-01,0.35555e-01,0.40840e-01,0.46513e-01,0.53917e-01 /)
      kbo(:,33, 7) = (/ &
        & 0.29120e-01,0.33908e-01,0.39209e-01,0.44801e-01,0.52179e-01 /)
      kbo(:,34, 7) = (/ &
        & 0.27843e-01,0.32610e-01,0.37873e-01,0.45101e-01,0.51127e-01 /)
      kbo(:,35, 7) = (/ &
        & 0.26429e-01,0.31201e-01,0.36480e-01,0.43796e-01,0.49886e-01 /)
      kbo(:,36, 7) = (/ &
        & 0.24910e-01,0.29603e-01,0.34935e-01,0.42317e-01,0.48474e-01 /)
      kbo(:,37, 7) = (/ &
        & 0.22623e-01,0.27186e-01,0.32364e-01,0.39709e-01,0.45895e-01 /)
      kbo(:,38, 7) = (/ &
        & 0.20536e-01,0.25035e-01,0.30138e-01,0.37341e-01,0.43584e-01 /)
      kbo(:,39, 7) = (/ &
        & 0.18744e-01,0.23143e-01,0.28133e-01,0.33754e-01,0.41569e-01 /)
      kbo(:,40, 7) = (/ &
        & 0.16632e-01,0.20751e-01,0.25556e-01,0.30972e-01,0.38593e-01 /)
      kbo(:,41, 7) = (/ &
        & 0.14671e-01,0.18541e-01,0.23110e-01,0.28292e-01,0.35702e-01 /)
      kbo(:,42, 7) = (/ &
        & 0.12909e-01,0.16573e-01,0.20901e-01,0.25885e-01,0.32997e-01 /)
      kbo(:,43, 7) = (/ &
        & 0.11155e-01,0.14521e-01,0.18561e-01,0.23268e-01,0.28558e-01 /)
      kbo(:,44, 7) = (/ &
        & 0.95144e-02,0.12576e-01,0.16313e-01,0.20662e-01,0.25638e-01 /)
      kbo(:,45, 7) = (/ &
        & 0.80643e-02,0.10847e-01,0.14290e-01,0.18347e-01,0.23034e-01 /)
      kbo(:,46, 7) = (/ &
        & 0.67589e-02,0.92659e-02,0.12372e-01,0.16082e-01,0.20456e-01 /)
      kbo(:,47, 7) = (/ &
        & 0.55482e-02,0.77474e-02,0.10528e-01,0.13920e-01,0.17966e-01 /)
      kbo(:,48, 7) = (/ &
        & 0.45013e-02,0.64175e-02,0.88907e-02,0.11958e-01,0.15638e-01 /)
      kbo(:,49, 7) = (/ &
        & 0.36173e-02,0.52743e-02,0.74530e-02,0.10200e-01,0.13544e-01 /)
      kbo(:,50, 7) = (/ &
        & 0.29073e-02,0.43372e-02,0.62514e-02,0.87078e-02,0.11757e-01 /)
      kbo(:,51, 7) = (/ &
        & 0.23200e-02,0.35429e-02,0.52236e-02,0.74160e-02,0.10190e-01 /)
      kbo(:,52, 7) = (/ &
        & 0.18398e-02,0.28704e-02,0.43321e-02,0.62743e-02,0.87585e-02 /)
      kbo(:,53, 7) = (/ &
        & 0.14394e-02,0.22999e-02,0.35535e-02,0.52615e-02,0.74854e-02 /)
      kbo(:,54, 7) = (/ &
        & 0.11368e-02,0.18545e-02,0.29326e-02,0.44372e-02,0.64347e-02 /)
      kbo(:,55, 7) = (/ &
        & 0.89467e-03,0.14935e-02,0.24197e-02,0.37410e-02,0.55222e-02 /)
      kbo(:,56, 7) = (/ &
        & 0.69687e-03,0.11894e-02,0.19763e-02,0.31286e-02,0.47149e-02 /)
      kbo(:,57, 7) = (/ &
        & 0.53791e-03,0.93747e-03,0.15990e-02,0.25976e-02,0.39986e-02 /)
      kbo(:,58, 7) = (/ &
        & 0.41410e-03,0.73971e-03,0.12907e-02,0.21482e-02,0.33858e-02 /)
      kbo(:,59, 7) = (/ &
        & 0.35405e-03,0.64717e-03,0.11503e-02,0.19466e-02,0.31094e-02 /)
      kbo(:,13, 8) = (/ &
        & 0.45516e+00,0.46955e+00,0.48450e+00,0.50029e+00,0.51769e+00 /)
      kbo(:,14, 8) = (/ &
        & 0.43991e+00,0.45312e+00,0.46646e+00,0.48116e+00,0.49718e+00 /)
      kbo(:,15, 8) = (/ &
        & 0.42871e+00,0.44246e+00,0.45762e+00,0.47406e+00,0.49132e+00 /)
      kbo(:,16, 8) = (/ &
        & 0.40699e+00,0.42153e+00,0.43710e+00,0.45468e+00,0.47435e+00 /)
      kbo(:,17, 8) = (/ &
        & 0.38538e+00,0.39940e+00,0.41418e+00,0.43146e+00,0.45140e+00 /)
      kbo(:,18, 8) = (/ &
        & 0.36235e+00,0.37741e+00,0.39391e+00,0.41121e+00,0.43054e+00 /)
      kbo(:,19, 8) = (/ &
        & 0.34180e+00,0.35677e+00,0.37295e+00,0.39070e+00,0.41121e+00 /)
      kbo(:,20, 8) = (/ &
        & 0.31818e+00,0.33243e+00,0.34824e+00,0.36683e+00,0.38832e+00 /)
      kbo(:,21, 8) = (/ &
        & 0.29454e+00,0.30892e+00,0.32519e+00,0.34434e+00,0.36621e+00 /)
      kbo(:,22, 8) = (/ &
        & 0.27292e+00,0.28819e+00,0.30567e+00,0.32553e+00,0.34730e+00 /)
      kbo(:,23, 8) = (/ &
        & 0.25455e+00,0.27053e+00,0.28810e+00,0.30845e+00,0.33065e+00 /)
      kbo(:,24, 8) = (/ &
        & 0.23920e+00,0.25523e+00,0.27293e+00,0.29370e+00,0.31644e+00 /)
      kbo(:,25, 8) = (/ &
        & 0.22572e+00,0.24152e+00,0.26024e+00,0.28092e+00,0.30402e+00 /)
      kbo(:,26, 8) = (/ &
        & 0.21333e+00,0.23053e+00,0.24913e+00,0.27069e+00,0.29445e+00 /)
      kbo(:,27, 8) = (/ &
        & 0.20216e+00,0.22006e+00,0.23987e+00,0.26172e+00,0.28552e+00 /)
      kbo(:,28, 8) = (/ &
        & 0.19243e+00,0.21106e+00,0.23162e+00,0.25373e+00,0.27880e+00 /)
      kbo(:,29, 8) = (/ &
        & 0.18399e+00,0.20352e+00,0.22446e+00,0.24815e+00,0.27383e+00 /)
      kbo(:,30, 8) = (/ &
        & 0.17696e+00,0.19707e+00,0.21934e+00,0.24428e+00,0.27560e+00 /)
      kbo(:,31, 8) = (/ &
        & 0.17154e+00,0.19276e+00,0.21622e+00,0.24297e+00,0.27512e+00 /)
      kbo(:,32, 8) = (/ &
        & 0.16864e+00,0.19074e+00,0.21586e+00,0.24341e+00,0.27678e+00 /)
      kbo(:,33, 8) = (/ &
        & 0.16705e+00,0.19103e+00,0.21725e+00,0.24571e+00,0.27988e+00 /)
      kbo(:,34, 8) = (/ &
        & 0.16718e+00,0.19214e+00,0.21923e+00,0.25236e+00,0.28358e+00 /)
      kbo(:,35, 8) = (/ &
        & 0.16615e+00,0.19194e+00,0.21973e+00,0.25386e+00,0.28528e+00 /)
      kbo(:,36, 8) = (/ &
        & 0.16355e+00,0.18981e+00,0.21857e+00,0.25318e+00,0.28503e+00 /)
      kbo(:,37, 8) = (/ &
        & 0.15644e+00,0.18272e+00,0.21137e+00,0.24627e+00,0.27830e+00 /)
      kbo(:,38, 8) = (/ &
        & 0.14985e+00,0.17574e+00,0.20437e+00,0.23950e+00,0.27160e+00 /)
      kbo(:,39, 8) = (/ &
        & 0.14373e+00,0.16918e+00,0.19762e+00,0.22814e+00,0.26522e+00 /)
      kbo(:,40, 8) = (/ &
        & 0.13479e+00,0.15968e+00,0.18756e+00,0.21775e+00,0.25463e+00 /)
      kbo(:,41, 8) = (/ &
        & 0.12605e+00,0.15045e+00,0.17752e+00,0.20726e+00,0.24367e+00 /)
      kbo(:,42, 8) = (/ &
        & 0.11784e+00,0.14153e+00,0.16784e+00,0.19712e+00,0.23353e+00 /)
      kbo(:,43, 8) = (/ &
        & 0.10839e+00,0.13122e+00,0.15696e+00,0.18528e+00,0.21641e+00 /)
      kbo(:,44, 8) = (/ &
        & 0.98772e-01,0.12078e+00,0.14549e+00,0.17313e+00,0.20344e+00 /)
      kbo(:,45, 8) = (/ &
        & 0.89757e-01,0.11096e+00,0.13484e+00,0.16135e+00,0.19086e+00 /)
      kbo(:,46, 8) = (/ &
        & 0.80754e-01,0.10111e+00,0.12397e+00,0.14951e+00,0.17812e+00 /)
      kbo(:,47, 8) = (/ &
        & 0.71551e-01,0.90848e-01,0.11265e+00,0.13712e+00,0.16456e+00 /)
      kbo(:,48, 8) = (/ &
        & 0.63023e-01,0.81188e-01,0.10192e+00,0.12530e+00,0.15155e+00 /)
      kbo(:,49, 8) = (/ &
        & 0.55112e-01,0.71966e-01,0.91627e-01,0.11386e+00,0.13887e+00 /)
      kbo(:,50, 8) = (/ &
        & 0.48148e-01,0.63904e-01,0.82545e-01,0.10380e+00,0.12775e+00 /)
      kbo(:,51, 8) = (/ &
        & 0.42077e-01,0.56742e-01,0.74219e-01,0.94436e-01,0.11735e+00 /)
      kbo(:,52, 8) = (/ &
        & 0.36406e-01,0.49929e-01,0.66400e-01,0.85557e-01,0.10751e+00 /)
      kbo(:,53, 8) = (/ &
        & 0.31162e-01,0.43645e-01,0.58971e-01,0.77049e-01,0.97772e-01 /)
      kbo(:,54, 8) = (/ &
        & 0.26848e-01,0.38389e-01,0.52700e-01,0.69937e-01,0.89664e-01 /)
      kbo(:,55, 8) = (/ &
        & 0.23145e-01,0.33793e-01,0.47177e-01,0.63590e-01,0.82440e-01 /)
      kbo(:,56, 8) = (/ &
        & 0.19764e-01,0.29522e-01,0.42050e-01,0.57472e-01,0.75623e-01 /)
      kbo(:,57, 8) = (/ &
        & 0.16713e-01,0.25602e-01,0.37259e-01,0.51705e-01,0.68976e-01 /)
      kbo(:,58, 8) = (/ &
        & 0.14134e-01,0.22215e-01,0.32983e-01,0.46579e-01,0.62982e-01 /)
      kbo(:,59, 8) = (/ &
        & 0.13103e-01,0.20874e-01,0.31397e-01,0.44700e-01,0.60881e-01 /)
      kbo(:,13, 9) = (/ &
        & 0.30563e+01,0.31744e+01,0.32842e+01,0.33901e+01,0.34937e+01 /)
      kbo(:,14, 9) = (/ &
        & 0.27752e+01,0.28869e+01,0.29933e+01,0.30958e+01,0.31932e+01 /)
      kbo(:,15, 9) = (/ &
        & 0.25099e+01,0.26164e+01,0.27185e+01,0.28161e+01,0.29094e+01 /)
      kbo(:,16, 9) = (/ &
        & 0.23062e+01,0.23985e+01,0.24887e+01,0.25791e+01,0.26657e+01 /)
      kbo(:,17, 9) = (/ &
        & 0.21996e+01,0.22783e+01,0.23521e+01,0.24248e+01,0.25028e+01 /)
      kbo(:,18, 9) = (/ &
        & 0.22125e+01,0.22932e+01,0.23665e+01,0.24375e+01,0.25051e+01 /)
      kbo(:,19, 9) = (/ &
        & 0.22641e+01,0.23491e+01,0.24239e+01,0.24973e+01,0.25657e+01 /)
      kbo(:,20, 9) = (/ &
        & 0.22472e+01,0.23357e+01,0.24204e+01,0.24964e+01,0.25675e+01 /)
      kbo(:,21, 9) = (/ &
        & 0.21851e+01,0.22830e+01,0.23690e+01,0.24562e+01,0.25370e+01 /)
      kbo(:,22, 9) = (/ &
        & 0.21175e+01,0.22142e+01,0.23108e+01,0.24049e+01,0.24949e+01 /)
      kbo(:,23, 9) = (/ &
        & 0.20447e+01,0.21452e+01,0.22435e+01,0.23385e+01,0.24298e+01 /)
      kbo(:,24, 9) = (/ &
        & 0.19721e+01,0.20737e+01,0.21717e+01,0.22760e+01,0.23715e+01 /)
      kbo(:,25, 9) = (/ &
        & 0.18957e+01,0.20036e+01,0.21100e+01,0.22176e+01,0.23221e+01 /)
      kbo(:,26, 9) = (/ &
        & 0.18288e+01,0.19378e+01,0.20515e+01,0.21609e+01,0.22728e+01 /)
      kbo(:,27, 9) = (/ &
        & 0.17692e+01,0.18810e+01,0.19951e+01,0.21151e+01,0.22361e+01 /)
      kbo(:,28, 9) = (/ &
        & 0.17168e+01,0.18338e+01,0.19558e+01,0.20789e+01,0.22051e+01 /)
      kbo(:,29, 9) = (/ &
        & 0.16702e+01,0.17936e+01,0.19235e+01,0.20524e+01,0.21850e+01 /)
      kbo(:,30, 9) = (/ &
        & 0.16394e+01,0.17677e+01,0.19029e+01,0.20369e+01,0.21882e+01 /)
      kbo(:,31, 9) = (/ &
        & 0.16228e+01,0.17523e+01,0.18896e+01,0.20262e+01,0.21815e+01 /)
      kbo(:,32, 9) = (/ &
        & 0.16178e+01,0.17489e+01,0.18859e+01,0.20233e+01,0.21838e+01 /)
      kbo(:,33, 9) = (/ &
        & 0.16221e+01,0.17529e+01,0.18876e+01,0.20327e+01,0.21960e+01 /)
      kbo(:,34, 9) = (/ &
        & 0.16321e+01,0.17688e+01,0.19069e+01,0.20650e+01,0.22191e+01 /)
      kbo(:,35, 9) = (/ &
        & 0.16388e+01,0.17830e+01,0.19261e+01,0.20887e+01,0.22365e+01 /)
      kbo(:,36, 9) = (/ &
        & 0.16423e+01,0.17895e+01,0.19390e+01,0.21032e+01,0.22561e+01 /)
      kbo(:,37, 9) = (/ &
        & 0.16080e+01,0.17565e+01,0.19076e+01,0.20741e+01,0.22287e+01 /)
      kbo(:,38, 9) = (/ &
        & 0.15745e+01,0.17245e+01,0.18721e+01,0.20419e+01,0.21969e+01 /)
      kbo(:,39, 9) = (/ &
        & 0.15386e+01,0.16919e+01,0.18410e+01,0.19923e+01,0.21638e+01 /)
      kbo(:,40, 9) = (/ &
        & 0.14840e+01,0.16355e+01,0.17855e+01,0.19337e+01,0.21026e+01 /)
      kbo(:,41, 9) = (/ &
        & 0.14260e+01,0.15758e+01,0.17241e+01,0.18746e+01,0.20398e+01 /)
      kbo(:,42, 9) = (/ &
        & 0.13688e+01,0.15162e+01,0.16646e+01,0.18157e+01,0.19780e+01 /)
      kbo(:,43, 9) = (/ &
        & 0.13011e+01,0.14473e+01,0.15936e+01,0.17402e+01,0.18823e+01 /)
      kbo(:,44, 9) = (/ &
        & 0.12278e+01,0.13710e+01,0.15157e+01,0.16568e+01,0.17952e+01 /)
      kbo(:,45, 9) = (/ &
        & 0.11558e+01,0.12957e+01,0.14361e+01,0.15731e+01,0.17094e+01 /)
      kbo(:,46, 9) = (/ &
        & 0.10820e+01,0.12147e+01,0.13532e+01,0.14890e+01,0.16181e+01 /)
      kbo(:,47, 9) = (/ &
        & 0.10024e+01,0.11346e+01,0.12669e+01,0.14002e+01,0.15260e+01 /)
      kbo(:,48, 9) = (/ &
        & 0.92524e+00,0.10524e+01,0.11804e+01,0.13068e+01,0.14296e+01 /)
      kbo(:,49, 9) = (/ &
        & 0.84698e+00,0.96805e+00,0.10902e+01,0.12100e+01,0.13299e+01 /)
      kbo(:,50, 9) = (/ &
        & 0.78084e+00,0.89928e+00,0.10161e+01,0.11323e+01,0.12472e+01 /)
      kbo(:,51, 9) = (/ &
        & 0.72222e+00,0.83480e+00,0.94748e+00,0.10626e+01,0.11740e+01 /)
      kbo(:,52, 9) = (/ &
        & 0.66260e+00,0.77045e+00,0.88348e+00,0.99181e+00,0.10995e+01 /)
      kbo(:,53, 9) = (/ &
        & 0.60516e+00,0.71083e+00,0.81698e+00,0.91863e+00,0.10219e+01 /)
      kbo(:,54, 9) = (/ &
        & 0.56176e+00,0.66472e+00,0.77054e+00,0.87249e+00,0.97306e+00 /)
      kbo(:,55, 9) = (/ &
        & 0.52563e+00,0.63037e+00,0.73497e+00,0.83878e+00,0.93923e+00 /)
      kbo(:,56, 9) = (/ &
        & 0.49056e+00,0.59429e+00,0.69788e+00,0.80509e+00,0.90615e+00 /)
      kbo(:,57, 9) = (/ &
        & 0.45575e+00,0.55861e+00,0.66303e+00,0.76942e+00,0.87211e+00 /)
      kbo(:,58, 9) = (/ &
        & 0.42419e+00,0.52609e+00,0.63048e+00,0.73708e+00,0.84331e+00 /)
      kbo(:,59, 9) = (/ &
        & 0.42340e+00,0.52953e+00,0.63843e+00,0.74879e+00,0.86046e+00 /)
      kbo(:,13,10) = (/ &
        & 0.14973e+02,0.15466e+02,0.15907e+02,0.16294e+02,0.16648e+02 /)
      kbo(:,14,10) = (/ &
        & 0.13327e+02,0.13717e+02,0.14036e+02,0.14348e+02,0.14658e+02 /)
      kbo(:,15,10) = (/ &
        & 0.12219e+02,0.12428e+02,0.12649e+02,0.12810e+02,0.12959e+02 /)
      kbo(:,16,10) = (/ &
        & 0.11245e+02,0.11501e+02,0.11701e+02,0.11817e+02,0.11948e+02 /)
      kbo(:,17,10) = (/ &
        & 0.96706e+01,0.99707e+01,0.10257e+02,0.10540e+02,0.10718e+02 /)
      kbo(:,18,10) = (/ &
        & 0.83018e+01,0.83446e+01,0.84207e+01,0.85262e+01,0.86783e+01 /)
      kbo(:,19,10) = (/ &
        & 0.82250e+01,0.81929e+01,0.82337e+01,0.82572e+01,0.83177e+01 /)
      kbo(:,20,10) = (/ &
        & 0.81684e+01,0.81782e+01,0.82244e+01,0.82765e+01,0.82985e+01 /)
      kbo(:,21,10) = (/ &
        & 0.82586e+01,0.83055e+01,0.84017e+01,0.83815e+01,0.83594e+01 /)
      kbo(:,22,10) = (/ &
        & 0.83686e+01,0.84604e+01,0.85363e+01,0.84786e+01,0.84786e+01 /)
      kbo(:,23,10) = (/ &
        & 0.84301e+01,0.85903e+01,0.87569e+01,0.87953e+01,0.87965e+01 /)
      kbo(:,24,10) = (/ &
        & 0.85690e+01,0.88097e+01,0.90359e+01,0.90994e+01,0.92201e+01 /)
      kbo(:,25,10) = (/ &
        & 0.87852e+01,0.90719e+01,0.92672e+01,0.94098e+01,0.95600e+01 /)
      kbo(:,26,10) = (/ &
        & 0.88651e+01,0.92334e+01,0.94525e+01,0.97256e+01,0.98986e+01 /)
      kbo(:,27,10) = (/ &
        & 0.88645e+01,0.92932e+01,0.96152e+01,0.98392e+01,0.10037e+02 /)
      kbo(:,28,10) = (/ &
        & 0.88548e+01,0.93070e+01,0.96176e+01,0.99813e+01,0.10238e+02 /)
      kbo(:,29,10) = (/ &
        & 0.88198e+01,0.92265e+01,0.96024e+01,0.99285e+01,0.10232e+02 /)
      kbo(:,30,10) = (/ &
        & 0.87818e+01,0.92083e+01,0.95579e+01,0.98976e+01,0.10208e+02 /)
      kbo(:,31,10) = (/ &
        & 0.86036e+01,0.90621e+01,0.94967e+01,0.98500e+01,0.10159e+02 /)
      kbo(:,32,10) = (/ &
        & 0.84748e+01,0.89960e+01,0.94428e+01,0.98336e+01,0.10196e+02 /)
      kbo(:,33,10) = (/ &
        & 0.84172e+01,0.89420e+01,0.94383e+01,0.98344e+01,0.10060e+02 /)
      kbo(:,34,10) = (/ &
        & 0.84605e+01,0.89751e+01,0.94683e+01,0.98852e+01,0.10023e+02 /)
      kbo(:,35,10) = (/ &
        & 0.84589e+01,0.89233e+01,0.94002e+01,0.98511e+01,0.10024e+02 /)
      kbo(:,36,10) = (/ &
        & 0.84558e+01,0.89580e+01,0.93747e+01,0.98030e+01,0.10000e+02 /)
      kbo(:,37,10) = (/ &
        & 0.82385e+01,0.87614e+01,0.91541e+01,0.95514e+01,0.97363e+01 /)
      kbo(:,38,10) = (/ &
        & 0.80132e+01,0.84437e+01,0.89304e+01,0.92902e+01,0.94811e+01 /)
      kbo(:,39,10) = (/ &
        & 0.78203e+01,0.81981e+01,0.85539e+01,0.89689e+01,0.90927e+01 /)
      kbo(:,40,10) = (/ &
        & 0.75978e+01,0.79610e+01,0.82423e+01,0.86095e+01,0.88190e+01 /)
      kbo(:,41,10) = (/ &
        & 0.73029e+01,0.76481e+01,0.79708e+01,0.82445e+01,0.84426e+01 /)
      kbo(:,42,10) = (/ &
        & 0.70166e+01,0.73754e+01,0.76378e+01,0.78862e+01,0.80985e+01 /)
      kbo(:,43,10) = (/ &
        & 0.66293e+01,0.69504e+01,0.72276e+01,0.75120e+01,0.77099e+01 /)
      kbo(:,44,10) = (/ &
        & 0.62312e+01,0.65696e+01,0.68647e+01,0.71226e+01,0.73305e+01 /)
      kbo(:,45,10) = (/ &
        & 0.58229e+01,0.61620e+01,0.64682e+01,0.67341e+01,0.69070e+01 /)
      kbo(:,46,10) = (/ &
        & 0.53657e+01,0.57492e+01,0.60377e+01,0.63031e+01,0.64992e+01 /)
      kbo(:,47,10) = (/ &
        & 0.50350e+01,0.53678e+01,0.56656e+01,0.59201e+01,0.61262e+01 /)
      kbo(:,48,10) = (/ &
        & 0.46566e+01,0.49901e+01,0.52633e+01,0.54964e+01,0.57537e+01 /)
      kbo(:,49,10) = (/ &
        & 0.42801e+01,0.46217e+01,0.49093e+01,0.51104e+01,0.53644e+01 /)
      kbo(:,50,10) = (/ &
        & 0.39613e+01,0.43120e+01,0.45848e+01,0.48588e+01,0.50774e+01 /)
      kbo(:,51,10) = (/ &
        & 0.37006e+01,0.40662e+01,0.43615e+01,0.46264e+01,0.48701e+01 /)
      kbo(:,52,10) = (/ &
        & 0.34485e+01,0.37934e+01,0.40667e+01,0.43544e+01,0.46481e+01 /)
      kbo(:,53,10) = (/ &
        & 0.31594e+01,0.35032e+01,0.37934e+01,0.41156e+01,0.44077e+01 /)
      kbo(:,54,10) = (/ &
        & 0.29800e+01,0.33284e+01,0.36333e+01,0.39624e+01,0.42528e+01 /)
      kbo(:,55,10) = (/ &
        & 0.28569e+01,0.32159e+01,0.35391e+01,0.38186e+01,0.41402e+01 /)
      kbo(:,56,10) = (/ &
        & 0.26907e+01,0.31071e+01,0.34476e+01,0.36941e+01,0.40212e+01 /)
      kbo(:,57,10) = (/ &
        & 0.25638e+01,0.29869e+01,0.33345e+01,0.36081e+01,0.38859e+01 /)
      kbo(:,58,10) = (/ &
        & 0.24665e+01,0.28708e+01,0.32402e+01,0.35331e+01,0.37851e+01 /)
      kbo(:,59,10) = (/ &
        & 0.25432e+01,0.29855e+01,0.33662e+01,0.37020e+01,0.39522e+01 /)
      kbo(:,13,11) = (/ &
        & 0.31099e+02,0.31647e+02,0.32241e+02,0.32842e+02,0.33417e+02 /)
      kbo(:,14,11) = (/ &
        & 0.27698e+02,0.28253e+02,0.28859e+02,0.29460e+02,0.30083e+02 /)
      kbo(:,15,11) = (/ &
        & 0.24330e+02,0.24945e+02,0.25542e+02,0.26234e+02,0.26922e+02 /)
      kbo(:,16,11) = (/ &
        & 0.21190e+02,0.21758e+02,0.22384e+02,0.23019e+02,0.23628e+02 /)
      kbo(:,17,11) = (/ &
        & 0.18967e+02,0.19413e+02,0.19858e+02,0.20261e+02,0.20672e+02 /)
      kbo(:,18,11) = (/ &
        & 0.16374e+02,0.16952e+02,0.17497e+02,0.17964e+02,0.18478e+02 /)
      kbo(:,19,11) = (/ &
        & 0.13248e+02,0.13545e+02,0.13847e+02,0.14297e+02,0.14705e+02 /)
      kbo(:,20,11) = (/ &
        & 0.12757e+02,0.12785e+02,0.12667e+02,0.12601e+02,0.12612e+02 /)
      kbo(:,21,11) = (/ &
        & 0.12844e+02,0.12624e+02,0.12433e+02,0.12193e+02,0.12175e+02 /)
      kbo(:,22,11) = (/ &
        & 0.12738e+02,0.12567e+02,0.12225e+02,0.12063e+02,0.11980e+02 /)
      kbo(:,23,11) = (/ &
        & 0.12815e+02,0.12660e+02,0.12272e+02,0.12108e+02,0.12066e+02 /)
      kbo(:,24,11) = (/ &
        & 0.13079e+02,0.12972e+02,0.12651e+02,0.12388e+02,0.12367e+02 /)
      kbo(:,25,11) = (/ &
        & 0.13341e+02,0.13256e+02,0.13023e+02,0.12848e+02,0.12659e+02 /)
      kbo(:,26,11) = (/ &
        & 0.13512e+02,0.13453e+02,0.13443e+02,0.13113e+02,0.13141e+02 /)
      kbo(:,27,11) = (/ &
        & 0.13706e+02,0.13750e+02,0.13824e+02,0.13564e+02,0.13665e+02 /)
      kbo(:,28,11) = (/ &
        & 0.13979e+02,0.14080e+02,0.14203e+02,0.13858e+02,0.13981e+02 /)
      kbo(:,29,11) = (/ &
        & 0.13934e+02,0.14086e+02,0.14156e+02,0.14057e+02,0.14114e+02 /)
      kbo(:,30,11) = (/ &
        & 0.13981e+02,0.13996e+02,0.13975e+02,0.14010e+02,0.14196e+02 /)
      kbo(:,31,11) = (/ &
        & 0.13896e+02,0.13857e+02,0.13654e+02,0.13807e+02,0.13871e+02 /)
      kbo(:,32,11) = (/ &
        & 0.13655e+02,0.13646e+02,0.13416e+02,0.13538e+02,0.13488e+02 /)
      kbo(:,33,11) = (/ &
        & 0.13398e+02,0.13279e+02,0.13235e+02,0.13164e+02,0.13195e+02 /)
      kbo(:,34,11) = (/ &
        & 0.13280e+02,0.13155e+02,0.13035e+02,0.13095e+02,0.13023e+02 /)
      kbo(:,35,11) = (/ &
        & 0.13174e+02,0.13038e+02,0.12951e+02,0.12819e+02,0.12932e+02 /)
      kbo(:,36,11) = (/ &
        & 0.13159e+02,0.12953e+02,0.12943e+02,0.12899e+02,0.13077e+02 /)
      kbo(:,37,11) = (/ &
        & 0.12968e+02,0.12722e+02,0.12741e+02,0.12684e+02,0.12881e+02 /)
      kbo(:,38,11) = (/ &
        & 0.12648e+02,0.12436e+02,0.12390e+02,0.12534e+02,0.12593e+02 /)
      kbo(:,39,11) = (/ &
        & 0.12145e+02,0.12036e+02,0.12198e+02,0.12171e+02,0.12374e+02 /)
      kbo(:,40,11) = (/ &
        & 0.11784e+02,0.11714e+02,0.11852e+02,0.11995e+02,0.12020e+02 /)
      kbo(:,41,11) = (/ &
        & 0.11419e+02,0.11429e+02,0.11554e+02,0.11799e+02,0.11809e+02 /)
      kbo(:,42,11) = (/ &
        & 0.11076e+02,0.11047e+02,0.11287e+02,0.11460e+02,0.11610e+02 /)
      kbo(:,43,11) = (/ &
        & 0.10635e+02,0.10772e+02,0.10970e+02,0.11110e+02,0.11339e+02 /)
      kbo(:,44,11) = (/ &
        & 0.10081e+02,0.10347e+02,0.10495e+02,0.10710e+02,0.10998e+02 /)
      kbo(:,45,11) = (/ &
        & 0.95493e+01,0.97720e+01,0.10013e+02,0.10318e+02,0.10626e+02 /)
      kbo(:,46,11) = (/ &
        & 0.91901e+01,0.92815e+01,0.95285e+01,0.99399e+01,0.10216e+02 /)
      kbo(:,47,11) = (/ &
        & 0.86762e+01,0.88384e+01,0.91370e+01,0.95143e+01,0.99290e+01 /)
      kbo(:,48,11) = (/ &
        & 0.80969e+01,0.84350e+01,0.87222e+01,0.91427e+01,0.95881e+01 /)
      kbo(:,49,11) = (/ &
        & 0.74881e+01,0.78692e+01,0.82390e+01,0.88564e+01,0.92509e+01 /)
      kbo(:,50,11) = (/ &
        & 0.70193e+01,0.74373e+01,0.79400e+01,0.84415e+01,0.90721e+01 /)
      kbo(:,51,11) = (/ &
        & 0.66370e+01,0.71214e+01,0.76381e+01,0.81180e+01,0.89263e+01 /)
      kbo(:,52,11) = (/ &
        & 0.62242e+01,0.68097e+01,0.73447e+01,0.79515e+01,0.88951e+01 /)
      kbo(:,53,11) = (/ &
        & 0.58238e+01,0.63775e+01,0.69942e+01,0.79247e+01,0.89454e+01 /)
      kbo(:,54,11) = (/ &
        & 0.55499e+01,0.61225e+01,0.67115e+01,0.76390e+01,0.86771e+01 /)
      kbo(:,55,11) = (/ &
        & 0.53976e+01,0.59288e+01,0.64661e+01,0.72387e+01,0.82482e+01 /)
      kbo(:,56,11) = (/ &
        & 0.52864e+01,0.57486e+01,0.62663e+01,0.68889e+01,0.78153e+01 /)
      kbo(:,57,11) = (/ &
        & 0.51174e+01,0.55624e+01,0.60808e+01,0.66051e+01,0.73800e+01 /)
      kbo(:,58,11) = (/ &
        & 0.49368e+01,0.54350e+01,0.59533e+01,0.64218e+01,0.70057e+01 /)
      kbo(:,59,11) = (/ &
        & 0.50812e+01,0.56369e+01,0.60928e+01,0.64990e+01,0.70265e+01 /)
      kbo(:,13,12) = (/ &
        & 0.69704e+02,0.70627e+02,0.71228e+02,0.71788e+02,0.72437e+02 /)
      kbo(:,14,12) = (/ &
        & 0.64379e+02,0.65225e+02,0.66016e+02,0.66901e+02,0.67785e+02 /)
      kbo(:,15,12) = (/ &
        & 0.58655e+02,0.59644e+02,0.60731e+02,0.61788e+02,0.62973e+02 /)
      kbo(:,16,12) = (/ &
        & 0.53041e+02,0.54211e+02,0.55406e+02,0.56764e+02,0.58230e+02 /)
      kbo(:,17,12) = (/ &
        & 0.47145e+02,0.48549e+02,0.50104e+02,0.51815e+02,0.53646e+02 /)
      kbo(:,18,12) = (/ &
        & 0.41118e+02,0.42628e+02,0.44372e+02,0.46307e+02,0.48319e+02 /)
      kbo(:,19,12) = (/ &
        & 0.35042e+02,0.36608e+02,0.38443e+02,0.40582e+02,0.43018e+02 /)
      kbo(:,20,12) = (/ &
        & 0.28625e+02,0.30224e+02,0.32288e+02,0.34780e+02,0.37414e+02 /)
      kbo(:,21,12) = (/ &
        & 0.24017e+02,0.25409e+02,0.27330e+02,0.29600e+02,0.32108e+02 /)
      kbo(:,22,12) = (/ &
        & 0.21793e+02,0.22620e+02,0.24096e+02,0.26102e+02,0.28497e+02 /)
      kbo(:,23,12) = (/ &
        & 0.21413e+02,0.21831e+02,0.22594e+02,0.23606e+02,0.25745e+02 /)
      kbo(:,24,12) = (/ &
        & 0.21009e+02,0.21418e+02,0.22293e+02,0.23189e+02,0.24234e+02 /)
      kbo(:,25,12) = (/ &
        & 0.21184e+02,0.21661e+02,0.22476e+02,0.23334e+02,0.24471e+02 /)
      kbo(:,26,12) = (/ &
        & 0.21853e+02,0.22488e+02,0.23205e+02,0.24024e+02,0.25192e+02 /)
      kbo(:,27,12) = (/ &
        & 0.22275e+02,0.22928e+02,0.23659e+02,0.24768e+02,0.25734e+02 /)
      kbo(:,28,12) = (/ &
        & 0.22649e+02,0.23413e+02,0.24091e+02,0.25549e+02,0.26436e+02 /)
      kbo(:,29,12) = (/ &
        & 0.22704e+02,0.23483e+02,0.24191e+02,0.25460e+02,0.26653e+02 /)
      kbo(:,30,12) = (/ &
        & 0.22666e+02,0.23444e+02,0.24530e+02,0.25500e+02,0.26652e+02 /)
      kbo(:,31,12) = (/ &
        & 0.22235e+02,0.23247e+02,0.24248e+02,0.25076e+02,0.26466e+02 /)
      kbo(:,32,12) = (/ &
        & 0.22226e+02,0.22827e+02,0.24083e+02,0.25139e+02,0.26181e+02 /)
      kbo(:,33,12) = (/ &
        & 0.22210e+02,0.22941e+02,0.24126e+02,0.25269e+02,0.26783e+02 /)
      kbo(:,34,12) = (/ &
        & 0.22243e+02,0.23077e+02,0.24337e+02,0.25761e+02,0.27799e+02 /)
      kbo(:,35,12) = (/ &
        & 0.22396e+02,0.23583e+02,0.24898e+02,0.26594e+02,0.29392e+02 /)
      kbo(:,36,12) = (/ &
        & 0.22982e+02,0.24125e+02,0.25363e+02,0.27311e+02,0.30508e+02 /)
      kbo(:,37,12) = (/ &
        & 0.22918e+02,0.23937e+02,0.25281e+02,0.27602e+02,0.31235e+02 /)
      kbo(:,38,12) = (/ &
        & 0.22758e+02,0.23720e+02,0.25240e+02,0.28261e+02,0.32012e+02 /)
      kbo(:,39,12) = (/ &
        & 0.22553e+02,0.23629e+02,0.25559e+02,0.29164e+02,0.32971e+02 /)
      kbo(:,40,12) = (/ &
        & 0.21913e+02,0.23010e+02,0.25397e+02,0.28931e+02,0.33000e+02 /)
      kbo(:,41,12) = (/ &
        & 0.21428e+02,0.22543e+02,0.25193e+02,0.28521e+02,0.32655e+02 /)
      kbo(:,42,12) = (/ &
        & 0.20806e+02,0.22057e+02,0.24895e+02,0.28307e+02,0.32344e+02 /)
      kbo(:,43,12) = (/ &
        & 0.20230e+02,0.21402e+02,0.24438e+02,0.27778e+02,0.31742e+02 /)
      kbo(:,44,12) = (/ &
        & 0.19439e+02,0.20816e+02,0.24038e+02,0.27280e+02,0.31112e+02 /)
      kbo(:,45,12) = (/ &
        & 0.18615e+02,0.20644e+02,0.23787e+02,0.26906e+02,0.30508e+02 /)
      kbo(:,46,12) = (/ &
        & 0.17932e+02,0.20436e+02,0.23444e+02,0.26514e+02,0.30043e+02 /)
      kbo(:,47,12) = (/ &
        & 0.17388e+02,0.20062e+02,0.22865e+02,0.25992e+02,0.29187e+02 /)
      kbo(:,48,12) = (/ &
        & 0.17144e+02,0.19562e+02,0.22419e+02,0.25556e+02,0.28578e+02 /)
      kbo(:,49,12) = (/ &
        & 0.16956e+02,0.19439e+02,0.22133e+02,0.25135e+02,0.28141e+02 /)
      kbo(:,50,12) = (/ &
        & 0.16529e+02,0.19034e+02,0.21605e+02,0.24563e+02,0.27331e+02 /)
      kbo(:,51,12) = (/ &
        & 0.15953e+02,0.18522e+02,0.21071e+02,0.23856e+02,0.26389e+02 /)
      kbo(:,52,12) = (/ &
        & 0.15476e+02,0.18037e+02,0.20576e+02,0.23092e+02,0.25303e+02 /)
      kbo(:,53,12) = (/ &
        & 0.14987e+02,0.17619e+02,0.20150e+02,0.22182e+02,0.24323e+02 /)
      kbo(:,54,12) = (/ &
        & 0.14316e+02,0.16769e+02,0.19340e+02,0.21295e+02,0.23328e+02 /)
      kbo(:,55,12) = (/ &
        & 0.13478e+02,0.15723e+02,0.18284e+02,0.20497e+02,0.22282e+02 /)
      kbo(:,56,12) = (/ &
        & 0.12615e+02,0.14717e+02,0.17222e+02,0.19626e+02,0.21412e+02 /)
      kbo(:,57,12) = (/ &
        & 0.11789e+02,0.13910e+02,0.16111e+02,0.18559e+02,0.20605e+02 /)
      kbo(:,58,12) = (/ &
        & 0.10935e+02,0.12994e+02,0.15023e+02,0.17386e+02,0.19630e+02 /)
      kbo(:,59,12) = (/ &
        & 0.10847e+02,0.11985e+02,0.13699e+02,0.15922e+02,0.18130e+02 /)
      kbo(:,13,13) = (/ &
        & 0.15243e+03,0.15414e+03,0.15604e+03,0.15731e+03,0.15805e+03 /)
      kbo(:,14,13) = (/ &
        & 0.15017e+03,0.15285e+03,0.15509e+03,0.15662e+03,0.15764e+03 /)
      kbo(:,15,13) = (/ &
        & 0.14701e+03,0.15032e+03,0.15250e+03,0.15435e+03,0.15583e+03 /)
      kbo(:,16,13) = (/ &
        & 0.14269e+03,0.14580e+03,0.14857e+03,0.15094e+03,0.15306e+03 /)
      kbo(:,17,13) = (/ &
        & 0.13670e+03,0.14035e+03,0.14376e+03,0.14689e+03,0.14976e+03 /)
      kbo(:,18,13) = (/ &
        & 0.13015e+03,0.13455e+03,0.13871e+03,0.14263e+03,0.14625e+03 /)
      kbo(:,19,13) = (/ &
        & 0.12287e+03,0.12845e+03,0.13370e+03,0.13836e+03,0.14277e+03 /)
      kbo(:,20,13) = (/ &
        & 0.11516e+03,0.12176e+03,0.12807e+03,0.13396e+03,0.13973e+03 /)
      kbo(:,21,13) = (/ &
        & 0.10676e+03,0.11461e+03,0.12196e+03,0.12926e+03,0.13605e+03 /)
      kbo(:,22,13) = (/ &
        & 0.98495e+02,0.10775e+03,0.11663e+03,0.12493e+03,0.13260e+03 /)
      kbo(:,23,13) = (/ &
        & 0.89816e+02,0.10015e+03,0.11065e+03,0.12084e+03,0.12951e+03 /)
      kbo(:,24,13) = (/ &
        & 0.82797e+02,0.93590e+02,0.10444e+03,0.11545e+03,0.12590e+03 /)
      kbo(:,25,13) = (/ &
        & 0.77256e+02,0.88067e+02,0.99408e+02,0.11069e+03,0.12164e+03 /)
      kbo(:,26,13) = (/ &
        & 0.73787e+02,0.84230e+02,0.95403e+02,0.10719e+03,0.11797e+03 /)
      kbo(:,27,13) = (/ &
        & 0.72626e+02,0.82623e+02,0.93417e+02,0.10482e+03,0.11588e+03 /)
      kbo(:,28,13) = (/ &
        & 0.72289e+02,0.81705e+02,0.92658e+02,0.10355e+03,0.11467e+03 /)
      kbo(:,29,13) = (/ &
        & 0.73831e+02,0.83248e+02,0.93801e+02,0.10474e+03,0.11551e+03 /)
      kbo(:,30,13) = (/ &
        & 0.76016e+02,0.86113e+02,0.95367e+02,0.10651e+03,0.11733e+03 /)
      kbo(:,31,13) = (/ &
        & 0.80058e+02,0.89705e+02,0.99793e+02,0.10982e+03,0.12052e+03 /)
      kbo(:,32,13) = (/ &
        & 0.85064e+02,0.94860e+02,0.10434e+03,0.11401e+03,0.12404e+03 /)
      kbo(:,33,13) = (/ &
        & 0.90655e+02,0.10081e+03,0.10992e+03,0.11933e+03,0.12788e+03 /)
      kbo(:,34,13) = (/ &
        & 0.95857e+02,0.10597e+03,0.11520e+03,0.12356e+03,0.13127e+03 /)
      kbo(:,35,13) = (/ &
        & 0.99393e+02,0.11014e+03,0.12003e+03,0.12794e+03,0.13407e+03 /)
      kbo(:,36,13) = (/ &
        & 0.10100e+03,0.11220e+03,0.12221e+03,0.13085e+03,0.13724e+03 /)
      kbo(:,37,13) = (/ &
        & 0.10052e+03,0.11217e+03,0.12302e+03,0.13127e+03,0.13704e+03 /)
      kbo(:,38,13) = (/ &
        & 0.10046e+03,0.11273e+03,0.12310e+03,0.13118e+03,0.13742e+03 /)
      kbo(:,39,13) = (/ &
        & 0.10122e+03,0.11326e+03,0.12361e+03,0.13081e+03,0.13784e+03 /)
      kbo(:,40,13) = (/ &
        & 0.10000e+03,0.11180e+03,0.12195e+03,0.12930e+03,0.13636e+03 /)
      kbo(:,41,13) = (/ &
        & 0.98394e+02,0.11024e+03,0.11969e+03,0.12788e+03,0.13497e+03 /)
      kbo(:,42,13) = (/ &
        & 0.97071e+02,0.10823e+03,0.11769e+03,0.12630e+03,0.13330e+03 /)
      kbo(:,43,13) = (/ &
        & 0.94820e+02,0.10592e+03,0.11514e+03,0.12393e+03,0.13107e+03 /)
      kbo(:,44,13) = (/ &
        & 0.92475e+02,0.10313e+03,0.11198e+03,0.12120e+03,0.12869e+03 /)
      kbo(:,45,13) = (/ &
        & 0.90255e+02,0.99678e+02,0.10888e+03,0.11824e+03,0.12634e+03 /)
      kbo(:,46,13) = (/ &
        & 0.87084e+02,0.96376e+02,0.10582e+03,0.11496e+03,0.12350e+03 /)
      kbo(:,47,13) = (/ &
        & 0.83116e+02,0.92026e+02,0.10209e+03,0.11120e+03,0.12020e+03 /)
      kbo(:,48,13) = (/ &
        & 0.78845e+02,0.88316e+02,0.97984e+02,0.10729e+03,0.11639e+03 /)
      kbo(:,49,13) = (/ &
        & 0.74841e+02,0.84389e+02,0.93907e+02,0.10286e+03,0.11277e+03 /)
      kbo(:,50,13) = (/ &
        & 0.71259e+02,0.80370e+02,0.89851e+02,0.99011e+02,0.10882e+03 /)
      kbo(:,51,13) = (/ &
        & 0.67667e+02,0.76332e+02,0.85552e+02,0.95111e+02,0.10517e+03 /)
      kbo(:,52,13) = (/ &
        & 0.64036e+02,0.72373e+02,0.81228e+02,0.91458e+02,0.10109e+03 /)
      kbo(:,53,13) = (/ &
        & 0.60531e+02,0.68539e+02,0.77029e+02,0.87314e+02,0.97171e+02 /)
      kbo(:,54,13) = (/ &
        & 0.57169e+02,0.65298e+02,0.73473e+02,0.83504e+02,0.93303e+02 /)
      kbo(:,55,13) = (/ &
        & 0.53955e+02,0.61813e+02,0.70099e+02,0.79656e+02,0.89859e+02 /)
      kbo(:,56,13) = (/ &
        & 0.50772e+02,0.58658e+02,0.66829e+02,0.76079e+02,0.86127e+02 /)
      kbo(:,57,13) = (/ &
        & 0.47708e+02,0.55213e+02,0.63250e+02,0.72545e+02,0.82495e+02 /)
      kbo(:,58,13) = (/ &
        & 0.45026e+02,0.52243e+02,0.60123e+02,0.69281e+02,0.79017e+02 /)
      kbo(:,59,13) = (/ &
        & 0.42111e+02,0.50365e+02,0.58368e+02,0.67832e+02,0.76877e+02 /)
      kbo(:,13,14) = (/ &
        & 0.32174e+03,0.31744e+03,0.31218e+03,0.30740e+03,0.30288e+03 /)
      kbo(:,14,14) = (/ &
        & 0.33593e+03,0.33142e+03,0.32669e+03,0.32231e+03,0.31834e+03 /)
      kbo(:,15,14) = (/ &
        & 0.34823e+03,0.34389e+03,0.34037e+03,0.33690e+03,0.33355e+03 /)
      kbo(:,16,14) = (/ &
        & 0.35878e+03,0.35631e+03,0.35376e+03,0.35105e+03,0.34819e+03 /)
      kbo(:,17,14) = (/ &
        & 0.36906e+03,0.36793e+03,0.36636e+03,0.36433e+03,0.36182e+03 /)
      kbo(:,18,14) = (/ &
        & 0.37817e+03,0.37835e+03,0.37763e+03,0.37618e+03,0.37389e+03 /)
      kbo(:,19,14) = (/ &
        & 0.38585e+03,0.38729e+03,0.38746e+03,0.38655e+03,0.38433e+03 /)
      kbo(:,20,14) = (/ &
        & 0.39236e+03,0.39495e+03,0.39589e+03,0.39530e+03,0.39330e+03 /)
      kbo(:,21,14) = (/ &
        & 0.39808e+03,0.40159e+03,0.40312e+03,0.40280e+03,0.40090e+03 /)
      kbo(:,22,14) = (/ &
        & 0.40338e+03,0.40757e+03,0.40933e+03,0.40908e+03,0.40708e+03 /)
      kbo(:,23,14) = (/ &
        & 0.40834e+03,0.41282e+03,0.41463e+03,0.41442e+03,0.41222e+03 /)
      kbo(:,24,14) = (/ &
        & 0.41280e+03,0.41739e+03,0.41916e+03,0.41879e+03,0.41631e+03 /)
      kbo(:,25,14) = (/ &
        & 0.41635e+03,0.42140e+03,0.42295e+03,0.42231e+03,0.41948e+03 /)
      kbo(:,26,14) = (/ &
        & 0.41887e+03,0.42439e+03,0.42613e+03,0.42509e+03,0.42199e+03 /)
      kbo(:,27,14) = (/ &
        & 0.42034e+03,0.42637e+03,0.42837e+03,0.42723e+03,0.42380e+03 /)
      kbo(:,28,14) = (/ &
        & 0.42191e+03,0.42841e+03,0.43008e+03,0.42870e+03,0.42501e+03 /)
      kbo(:,29,14) = (/ &
        & 0.42351e+03,0.42979e+03,0.43162e+03,0.42986e+03,0.42579e+03 /)
      kbo(:,30,14) = (/ &
        & 0.42461e+03,0.42985e+03,0.43291e+03,0.43068e+03,0.42610e+03 /)
      kbo(:,31,14) = (/ &
        & 0.42505e+03,0.43017e+03,0.43191e+03,0.43099e+03,0.42603e+03 /)
      kbo(:,32,14) = (/ &
        & 0.42362e+03,0.42860e+03,0.43041e+03,0.42915e+03,0.42555e+03 /)
      kbo(:,33,14) = (/ &
        & 0.42123e+03,0.42505e+03,0.42663e+03,0.42551e+03,0.42290e+03 /)
      kbo(:,34,14) = (/ &
        & 0.41773e+03,0.42082e+03,0.42178e+03,0.42110e+03,0.41858e+03 /)
      kbo(:,35,14) = (/ &
        & 0.41435e+03,0.41544e+03,0.41491e+03,0.41443e+03,0.41216e+03 /)
      kbo(:,36,14) = (/ &
        & 0.41009e+03,0.41065e+03,0.40988e+03,0.40756e+03,0.40367e+03 /)
      kbo(:,37,14) = (/ &
        & 0.40889e+03,0.40948e+03,0.40755e+03,0.40547e+03,0.40195e+03 /)
      kbo(:,38,14) = (/ &
        & 0.40736e+03,0.40781e+03,0.40666e+03,0.40322e+03,0.39939e+03 /)
      kbo(:,39,14) = (/ &
        & 0.40514e+03,0.40605e+03,0.40431e+03,0.40166e+03,0.39666e+03 /)
      kbo(:,40,14) = (/ &
        & 0.40543e+03,0.40633e+03,0.40490e+03,0.40260e+03,0.39791e+03 /)
      kbo(:,41,14) = (/ &
        & 0.40503e+03,0.40615e+03,0.40599e+03,0.40348e+03,0.39947e+03 /)
      kbo(:,42,14) = (/ &
        & 0.40408e+03,0.40664e+03,0.40681e+03,0.40441e+03,0.40107e+03 /)
      kbo(:,43,14) = (/ &
        & 0.40250e+03,0.40659e+03,0.40791e+03,0.40633e+03,0.40362e+03 /)
      kbo(:,44,14) = (/ &
        & 0.40121e+03,0.40653e+03,0.40934e+03,0.40832e+03,0.40616e+03 /)
      kbo(:,45,14) = (/ &
        & 0.39928e+03,0.40669e+03,0.41014e+03,0.41010e+03,0.40849e+03 /)
      kbo(:,46,14) = (/ &
        & 0.39656e+03,0.40551e+03,0.41027e+03,0.41167e+03,0.41068e+03 /)
      kbo(:,47,14) = (/ &
        & 0.39317e+03,0.40403e+03,0.40985e+03,0.41273e+03,0.41264e+03 /)
      kbo(:,48,14) = (/ &
        & 0.38915e+03,0.40116e+03,0.40932e+03,0.41346e+03,0.41469e+03 /)
      kbo(:,49,14) = (/ &
        & 0.38398e+03,0.39755e+03,0.40789e+03,0.41416e+03,0.41577e+03 /)
      kbo(:,50,14) = (/ &
        & 0.37757e+03,0.39396e+03,0.40616e+03,0.41381e+03,0.41707e+03 /)
      kbo(:,51,14) = (/ &
        & 0.37117e+03,0.38987e+03,0.40415e+03,0.41318e+03,0.41740e+03 /)
      kbo(:,52,14) = (/ &
        & 0.36408e+03,0.38505e+03,0.40161e+03,0.41151e+03,0.41801e+03 /)
      kbo(:,53,14) = (/ &
        & 0.35611e+03,0.37948e+03,0.39824e+03,0.40994e+03,0.41764e+03 /)
      kbo(:,54,14) = (/ &
        & 0.34712e+03,0.37341e+03,0.39425e+03,0.40798e+03,0.41739e+03 /)
      kbo(:,55,14) = (/ &
        & 0.33857e+03,0.36757e+03,0.38995e+03,0.40583e+03,0.41654e+03 /)
      kbo(:,56,14) = (/ &
        & 0.32949e+03,0.36056e+03,0.38492e+03,0.40281e+03,0.41532e+03 /)
      kbo(:,57,14) = (/ &
        & 0.31954e+03,0.35312e+03,0.37997e+03,0.39944e+03,0.41349e+03 /)
      kbo(:,58,14) = (/ &
        & 0.30943e+03,0.34518e+03,0.37428e+03,0.39571e+03,0.41155e+03 /)
      kbo(:,59,14) = (/ &
        & 0.30628e+03,0.34259e+03,0.37284e+03,0.39463e+03,0.41220e+03 /)
      kbo(:,13,15) = (/ &
        & 0.58702e+03,0.56862e+03,0.55331e+03,0.53896e+03,0.52495e+03 /)
      kbo(:,14,15) = (/ &
        & 0.64037e+03,0.62129e+03,0.60436e+03,0.58772e+03,0.57127e+03 /)
      kbo(:,15,15) = (/ &
        & 0.69642e+03,0.67640e+03,0.65677e+03,0.63714e+03,0.61752e+03 /)
      kbo(:,16,15) = (/ &
        & 0.75408e+03,0.73150e+03,0.70834e+03,0.68512e+03,0.66206e+03 /)
      kbo(:,17,15) = (/ &
        & 0.81156e+03,0.78496e+03,0.75773e+03,0.73064e+03,0.70441e+03 /)
      kbo(:,18,15) = (/ &
        & 0.86684e+03,0.83552e+03,0.80425e+03,0.77370e+03,0.74441e+03 /)
      kbo(:,19,15) = (/ &
        & 0.91879e+03,0.88284e+03,0.84773e+03,0.81356e+03,0.78105e+03 /)
      kbo(:,20,15) = (/ &
        & 0.96599e+03,0.92558e+03,0.88651e+03,0.84884e+03,0.81303e+03 /)
      kbo(:,21,15) = (/ &
        & 0.10076e+04,0.96291e+03,0.92009e+03,0.87920e+03,0.84047e+03 /)
      kbo(:,22,15) = (/ &
        & 0.10401e+04,0.99157e+03,0.94567e+03,0.90208e+03,0.86095e+03 /)
      kbo(:,23,15) = (/ &
        & 0.10659e+04,0.10143e+04,0.96587e+03,0.91983e+03,0.87686e+03 /)
      kbo(:,24,15) = (/ &
        & 0.10857e+04,0.10316e+04,0.98077e+03,0.93285e+03,0.88829e+03 /)
      kbo(:,25,15) = (/ &
        & 0.10994e+04,0.10434e+04,0.99070e+03,0.94138e+03,0.89569e+03 /)
      kbo(:,26,15) = (/ &
        & 0.11072e+04,0.10495e+04,0.99578e+03,0.94553e+03,0.89886e+03 /)
      kbo(:,27,15) = (/ &
        & 0.11107e+04,0.10519e+04,0.99732e+03,0.94654e+03,0.89932e+03 /)
      kbo(:,28,15) = (/ &
        & 0.11104e+04,0.10510e+04,0.99596e+03,0.94493e+03,0.89744e+03 /)
      kbo(:,29,15) = (/ &
        & 0.11068e+04,0.10472e+04,0.99206e+03,0.94099e+03,0.89320e+03 /)
      kbo(:,30,15) = (/ &
        & 0.11008e+04,0.10413e+04,0.98636e+03,0.93544e+03,0.88772e+03 /)
      kbo(:,31,15) = (/ &
        & 0.10926e+04,0.10334e+04,0.97895e+03,0.92827e+03,0.88094e+03 /)
      kbo(:,32,15) = (/ &
        & 0.10829e+04,0.10242e+04,0.97015e+03,0.91986e+03,0.87315e+03 /)
      kbo(:,33,15) = (/ &
        & 0.10718e+04,0.10140e+04,0.96048e+03,0.91059e+03,0.86462e+03 /)
      kbo(:,34,15) = (/ &
        & 0.10622e+04,0.10049e+04,0.95198e+03,0.90258e+03,0.85725e+03 /)
      kbo(:,35,15) = (/ &
        & 0.10576e+04,0.10006e+04,0.94772e+03,0.89854e+03,0.85365e+03 /)
      kbo(:,36,15) = (/ &
        & 0.10589e+04,0.10017e+04,0.94880e+03,0.89934e+03,0.85436e+03 /)
      kbo(:,37,15) = (/ &
        & 0.10689e+04,0.10108e+04,0.95721e+03,0.90723e+03,0.86136e+03 /)
      kbo(:,38,15) = (/ &
        & 0.10792e+04,0.10202e+04,0.96581e+03,0.91534e+03,0.86861e+03 /)
      kbo(:,39,15) = (/ &
        & 0.10893e+04,0.10294e+04,0.97432e+03,0.92308e+03,0.87586e+03 /)
      kbo(:,40,15) = (/ &
        & 0.11025e+04,0.10445e+04,0.98826e+03,0.93598e+03,0.88770e+03 /)
      kbo(:,41,15) = (/ &
        & 0.11189e+04,0.10606e+04,0.10030e+04,0.94969e+03,0.90027e+03 /)
      kbo(:,42,15) = (/ &
        & 0.11355e+04,0.10769e+04,0.10180e+04,0.96359e+03,0.91305e+03 /)
      kbo(:,43,15) = (/ &
        & 0.11585e+04,0.10971e+04,0.10364e+04,0.98067e+03,0.92886e+03 /)
      kbo(:,44,15) = (/ &
        & 0.11827e+04,0.11193e+04,0.10568e+04,0.99947e+03,0.94636e+03 /)
      kbo(:,45,15) = (/ &
        & 0.12075e+04,0.11422e+04,0.10778e+04,0.10187e+04,0.96421e+03 /)
      kbo(:,46,15) = (/ &
        & 0.12357e+04,0.11671e+04,0.11007e+04,0.10396e+04,0.98362e+03 /)
      kbo(:,47,15) = (/ &
        & 0.12667e+04,0.11958e+04,0.11271e+04,0.10639e+04,0.10059e+04 /)
      kbo(:,48,15) = (/ &
        & 0.12983e+04,0.12254e+04,0.11543e+04,0.10888e+04,0.10288e+04 /)
      kbo(:,49,15) = (/ &
        & 0.13304e+04,0.12559e+04,0.11825e+04,0.11147e+04,0.10526e+04 /)
      kbo(:,50,15) = (/ &
        & 0.13621e+04,0.12852e+04,0.12096e+04,0.11397e+04,0.10755e+04 /)
      kbo(:,51,15) = (/ &
        & 0.13919e+04,0.13140e+04,0.12368e+04,0.11648e+04,0.10985e+04 /)
      kbo(:,52,15) = (/ &
        & 0.14222e+04,0.13432e+04,0.12647e+04,0.11905e+04,0.11221e+04 /)
      kbo(:,53,15) = (/ &
        & 0.14531e+04,0.13729e+04,0.12932e+04,0.12171e+04,0.11465e+04 /)
      kbo(:,54,15) = (/ &
        & 0.14842e+04,0.14002e+04,0.13197e+04,0.12421e+04,0.11696e+04 /)
      kbo(:,55,15) = (/ &
        & 0.15120e+04,0.14267e+04,0.13453e+04,0.12667e+04,0.11922e+04 /)
      kbo(:,56,15) = (/ &
        & 0.15401e+04,0.14538e+04,0.13712e+04,0.12915e+04,0.12155e+04 /)
      kbo(:,57,15) = (/ &
        & 0.15682e+04,0.14811e+04,0.13973e+04,0.13167e+04,0.12393e+04 /)
      kbo(:,58,15) = (/ &
        & 0.15949e+04,0.15073e+04,0.14224e+04,0.13410e+04,0.12625e+04 /)
      kbo(:,59,15) = (/ &
        & 0.16055e+04,0.15180e+04,0.14326e+04,0.13507e+04,0.12718e+04 /)
      kbo(:,13,16) = (/ &
        & 0.98069e+03,0.94212e+03,0.90378e+03,0.86861e+03,0.83780e+03 /)
      kbo(:,14,16) = (/ &
        & 0.11010e+04,0.10540e+04,0.10095e+04,0.96975e+03,0.93339e+03 /)
      kbo(:,15,16) = (/ &
        & 0.12287e+04,0.11714e+04,0.11195e+04,0.10736e+04,0.10305e+04 /)
      kbo(:,16,16) = (/ &
        & 0.13596e+04,0.12909e+04,0.12306e+04,0.11762e+04,0.11252e+04 /)
      kbo(:,17,16) = (/ &
        & 0.14895e+04,0.14091e+04,0.13394e+04,0.12751e+04,0.12151e+04 /)
      kbo(:,18,16) = (/ &
        & 0.16148e+04,0.15230e+04,0.14425e+04,0.13683e+04,0.12989e+04 /)
      kbo(:,19,16) = (/ &
        & 0.17336e+04,0.16302e+04,0.15375e+04,0.14530e+04,0.13744e+04 /)
      kbo(:,20,16) = (/ &
        & 0.18405e+04,0.17248e+04,0.16208e+04,0.15267e+04,0.14397e+04 /)
      kbo(:,21,16) = (/ &
        & 0.19359e+04,0.18083e+04,0.16938e+04,0.15909e+04,0.14962e+04 /)
      kbo(:,22,16) = (/ &
        & 0.20085e+04,0.18707e+04,0.17478e+04,0.16373e+04,0.15366e+04 /)
      kbo(:,23,16) = (/ &
        & 0.20648e+04,0.19188e+04,0.17890e+04,0.16725e+04,0.15672e+04 /)
      kbo(:,24,16) = (/ &
        & 0.21054e+04,0.19528e+04,0.18178e+04,0.16967e+04,0.15881e+04 /)
      kbo(:,25,16) = (/ &
        & 0.21318e+04,0.19742e+04,0.18353e+04,0.17113e+04,0.16005e+04 /)
      kbo(:,26,16) = (/ &
        & 0.21433e+04,0.19836e+04,0.18416e+04,0.17161e+04,0.16044e+04 /)
      kbo(:,27,16) = (/ &
        & 0.21445e+04,0.19835e+04,0.18409e+04,0.17145e+04,0.16033e+04 /)
      kbo(:,28,16) = (/ &
        & 0.21374e+04,0.19764e+04,0.18336e+04,0.17081e+04,0.15978e+04 /)
      kbo(:,29,16) = (/ &
        & 0.21225e+04,0.19618e+04,0.18208e+04,0.16961e+04,0.15894e+04 /)
      kbo(:,30,16) = (/ &
        & 0.21033e+04,0.19434e+04,0.18039e+04,0.16808e+04,0.15775e+04 /)
      kbo(:,31,16) = (/ &
        & 0.20779e+04,0.19206e+04,0.17837e+04,0.16635e+04,0.15631e+04 /)
      kbo(:,32,16) = (/ &
        & 0.20491e+04,0.18949e+04,0.17612e+04,0.16447e+04,0.15471e+04 /)
      kbo(:,33,16) = (/ &
        & 0.20177e+04,0.18682e+04,0.17367e+04,0.16246e+04,0.15302e+04 /)
      kbo(:,34,16) = (/ &
        & 0.19905e+04,0.18445e+04,0.17155e+04,0.16076e+04,0.15146e+04 /)
      kbo(:,35,16) = (/ &
        & 0.19774e+04,0.18329e+04,0.17061e+04,0.16001e+04,0.15070e+04 /)
      kbo(:,36,16) = (/ &
        & 0.19799e+04,0.18350e+04,0.17079e+04,0.16017e+04,0.15083e+04 /)
      kbo(:,37,16) = (/ &
        & 0.20051e+04,0.18569e+04,0.17271e+04,0.16176e+04,0.15230e+04 /)
      kbo(:,38,16) = (/ &
        & 0.20315e+04,0.18800e+04,0.17473e+04,0.16343e+04,0.15379e+04 /)
      kbo(:,39,16) = (/ &
        & 0.20576e+04,0.19026e+04,0.17672e+04,0.16508e+04,0.15527e+04 /)
      kbo(:,40,16) = (/ &
        & 0.21013e+04,0.19405e+04,0.18004e+04,0.16787e+04,0.15771e+04 /)
      kbo(:,41,16) = (/ &
        & 0.21482e+04,0.19814e+04,0.18363e+04,0.17091e+04,0.16029e+04 /)
      kbo(:,42,16) = (/ &
        & 0.21964e+04,0.20236e+04,0.18732e+04,0.17410e+04,0.16295e+04 /)
      kbo(:,43,16) = (/ &
        & 0.22568e+04,0.20769e+04,0.19193e+04,0.17816e+04,0.16630e+04 /)
      kbo(:,44,16) = (/ &
        & 0.23247e+04,0.21362e+04,0.19712e+04,0.18270e+04,0.17012e+04 /)
      kbo(:,45,16) = (/ &
        & 0.23959e+04,0.21983e+04,0.20252e+04,0.18744e+04,0.17420e+04 /)
      kbo(:,46,16) = (/ &
        & 0.24748e+04,0.22670e+04,0.20858e+04,0.19269e+04,0.17884e+04 /)
      kbo(:,47,16) = (/ &
        & 0.25688e+04,0.23479e+04,0.21568e+04,0.19886e+04,0.18424e+04 /)
      kbo(:,48,16) = (/ &
        & 0.26704e+04,0.24334e+04,0.22313e+04,0.20542e+04,0.18994e+04 /)
      kbo(:,49,16) = (/ &
        & 0.27805e+04,0.25238e+04,0.23096e+04,0.21232e+04,0.19594e+04 /)
      kbo(:,50,16) = (/ &
        & 0.28920e+04,0.26151e+04,0.23873e+04,0.21911e+04,0.20186e+04 /)
      kbo(:,51,16) = (/ &
        & 0.30093e+04,0.27098e+04,0.24666e+04,0.22601e+04,0.20794e+04 /)
      kbo(:,52,16) = (/ &
        & 0.31338e+04,0.28121e+04,0.25503e+04,0.23323e+04,0.21428e+04 /)
      kbo(:,53,16) = (/ &
        & 0.32663e+04,0.29228e+04,0.26405e+04,0.24086e+04,0.22095e+04 /)
      kbo(:,54,16) = (/ &
        & 0.33958e+04,0.30317e+04,0.27288e+04,0.24819e+04,0.22731e+04 /)
      kbo(:,55,16) = (/ &
        & 0.35272e+04,0.31418e+04,0.28194e+04,0.25560e+04,0.23371e+04 /)
      kbo(:,56,16) = (/ &
        & 0.36664e+04,0.32577e+04,0.29162e+04,0.26350e+04,0.24040e+04 /)
      kbo(:,57,16) = (/ &
        & 0.38139e+04,0.33808e+04,0.30193e+04,0.27188e+04,0.24736e+04 /)
      kbo(:,58,16) = (/ &
        & 0.39629e+04,0.35038e+04,0.31229e+04,0.28034e+04,0.25431e+04 /)
      kbo(:,59,16) = (/ &
        & 0.40252e+04,0.35562e+04,0.31659e+04,0.28393e+04,0.25724e+04 /)

!     -----------------------------------------------------------------

      forrefo(:, 1) = (/ 0.525585e-05, 0.527618e-05, 0.746929e-04 /)
      forrefo(:, 2) = (/ 0.794660e-05, 0.136902e-04, 0.849878e-04 /)
      forrefo(:, 3) = (/ 0.197099e-04, 0.733094e-04, 0.121687e-03 /)
      forrefo(:, 4) = (/ 0.148274e-03, 0.169776e-03, 0.164848e-03 /)
      forrefo(:, 5) = (/ 0.230296e-03, 0.210384e-03, 0.182028e-03 /)
      forrefo(:, 6) = (/ 0.280575e-03, 0.259217e-03, 0.196080e-03 /)
      forrefo(:, 7) = (/ 0.329034e-03, 0.291575e-03, 0.207044e-03 /)
      forrefo(:, 8) = (/ 0.349989e-03, 0.323471e-03, 0.225712e-03 /)
      forrefo(:, 9) = (/ 0.366097e-03, 0.321519e-03, 0.253150e-03 /)
      forrefo(:,10) = (/ 0.383589e-03, 0.355314e-03, 0.262555e-03 /)
      forrefo(:,11) = (/ 0.375933e-03, 0.372443e-03, 0.261313e-03 /)
      forrefo(:,12) = (/ 0.370652e-03, 0.382366e-03, 0.250070e-03 /)
      forrefo(:,13) = (/ 0.375092e-03, 0.379542e-03, 0.265794e-03 /)
      forrefo(:,14) = (/ 0.389705e-03, 0.384274e-03, 0.322135e-03 /)
      forrefo(:,15) = (/ 0.372084e-03, 0.390422e-03, 0.370035e-03 /)
      forrefo(:,16) = (/ 0.437802e-03, 0.373406e-03, 0.373222e-03 /)
      
!     -----------------------------------------------------------------
!     The array SELFREFO contains the coefficient of the water vapor
!     self-continuum (including the energy term).  The first index
!     refers to temperature in 7.2 degree increments.  For instance,
!     JT = 1 refers to a temperature of 245.6, JT = 2 refers to 252.8,
!     etc.  The second index runs over the g-channel (1 to 16).
!     -----------------------------------------------------------------
      
      selfrefo(:, 1) = (/ &
        &  0.126758e-02, 0.105253e-02, 0.873963e-03, 0.725690e-03, 0.602573e-03, &
        &  0.500344e-03, 0.415458e-03, 0.344973e-03, 0.286447e-03, 0.237849e-03 /)
      selfrefo(:, 2) = (/ &
        &  0.144006e-02, 0.118514e-02, 0.975351e-03, 0.802697e-03, 0.660606e-03, &
        &  0.543667e-03, 0.447429e-03, 0.368226e-03, 0.303044e-03, 0.249400e-03 /)
      selfrefo(:, 3) = (/ &
        &  0.294018e-02, 0.227428e-02, 0.175920e-02, 0.136077e-02, 0.105258e-02, &
        &  0.814189e-03, 0.629789e-03, 0.487153e-03, 0.376821e-03, 0.291478e-03 /)
      selfrefo(:, 4) = (/ &
        &  0.395290e-02, 0.348405e-02, 0.307081e-02, 0.270658e-02, 0.238556e-02, &
        &  0.210261e-02, 0.185322e-02, 0.163341e-02, 0.143967e-02, 0.126891e-02 /)
      selfrefo(:, 5) = (/ &
        &  0.419122e-02, 0.385638e-02, 0.354829e-02, 0.326481e-02, 0.300398e-02, &
        &  0.276399e-02, 0.254317e-02, 0.234000e-02, 0.215305e-02, 0.198104e-02 /)
      selfrefo(:, 6) = (/ &
        &  0.495659e-02, 0.456777e-02, 0.420945e-02, 0.387924e-02, 0.357494e-02, &
        &  0.329450e-02, 0.303606e-02, 0.279790e-02, 0.257842e-02, 0.237615e-02 /)
      selfrefo(:, 7) = (/ &
        &  0.526981e-02, 0.490687e-02, 0.456893e-02, 0.425426e-02, 0.396126e-02, &
        &  0.368844e-02, 0.343441e-02, 0.319788e-02, 0.297764e-02, 0.277256e-02 /)
      selfrefo(:, 8) = (/ &
        &  0.575426e-02, 0.531597e-02, 0.491106e-02, 0.453699e-02, 0.419141e-02, &
        &  0.387216e-02, 0.357722e-02, 0.330475e-02, 0.305303e-02, 0.282048e-02 /)
      selfrefo(:, 9) = (/ &
        &  0.549881e-02, 0.514328e-02, 0.481074e-02, 0.449970e-02, 0.420877e-02, &
        &  0.393665e-02, 0.368213e-02, 0.344406e-02, 0.322138e-02, 0.301310e-02 /)
      selfrefo(:,10) = (/ &
        &  0.605357e-02, 0.561246e-02, 0.520349e-02, 0.482432e-02, 0.447278e-02, &
        &  0.414686e-02, 0.384469e-02, 0.356453e-02, 0.330479e-02, 0.306398e-02 /)
      selfrefo(:,11) = (/ &
        &  0.640504e-02, 0.587858e-02, 0.539540e-02, 0.495194e-02, 0.454492e-02, &
        &  0.417136e-02, 0.382850e-02, 0.351382e-02, 0.322501e-02, 0.295993e-02 /)
      selfrefo(:,12) = (/ &
        &  0.677803e-02, 0.615625e-02, 0.559152e-02, 0.507859e-02, 0.461271e-02, &
        &  0.418957e-02, 0.380524e-02, 0.345617e-02, 0.313913e-02, 0.285116e-02 /)
      selfrefo(:,13) = (/ &
        &  0.690347e-02, 0.627003e-02, 0.569472e-02, 0.517219e-02, 0.469761e-02, &
        &  0.426658e-02, 0.387509e-02, 0.351953e-02, 0.319659e-02, 0.290328e-02 /)
      selfrefo(:,14) = (/ &
        &  0.692680e-02, 0.632795e-02, 0.578087e-02, 0.528109e-02, 0.482452e-02, &
        &  0.440742e-02, 0.402638e-02, 0.367828e-02, 0.336028e-02, 0.306977e-02 /)
      selfrefo(:,15) = (/ &
        &  0.754894e-02, 0.681481e-02, 0.615207e-02, 0.555378e-02, 0.501367e-02, &
        &  0.452609e-02, 0.408593e-02, 0.368857e-02, 0.332986e-02, 0.300603e-02 /)
      selfrefo(:,16) = (/ &
        &  0.760689e-02, 0.709755e-02, 0.662232e-02, 0.617891e-02, 0.576519e-02, &
        &  0.537917e-02, 0.501899e-02, 0.468293e-02, 0.436938e-02, 0.407682e-02 /)
     
      end subroutine sw_kgb16

