!     path:      $Source$
!     author:    $Author$
!     revision:  $Revision$
!     created:   $Date$
!
!  --------------------------------------------------------------------------
! |                                                                          |
! |  Copyright 2002-2009, Atmospheric & Environmental Research, Inc. (AER).  |
! |  This software may be used, copied, or redistributed as long as it is    |
! |  not sold and this copyright notice is reproduced on each copy made.     |
! |  This model is provided as is without any express or implied warranties. |
! |                       (http://www.rtweb.aer.com/)                        |
! |                                                                          |
!  --------------------------------------------------------------------------

! **************************************************************************
!      subroutine lw_kgbnn
! **************************************************************************
!  RRTM Longwave Radiative Transfer Model
!  Atmospheric and Environmental Research, Inc., Cambridge, MA
!
!  Original version:   E. J. Mlawer, et al.
!  Revision for GCMs:  Michael J. Iacono; October, 2002
!  Revision for F90 formatting:  Michael J. Iacono; June 2006
!
!  This file contains 16 subroutines that include the 
!  absorption coefficients and other data for each of the 16 longwave
!  spectral bands used in RRTM.  Here, the data are defined for 16
!  g-points, or sub-intervals, per band.  These data are combined and
!  weighted using a mapping procedure in routine RRTMG_LW_INIT to reduce
!  the total number of g-points from 256 to 140 for use in the GCM.
! **************************************************************************
      subroutine lw_kgb12
! **************************************************************************

       !use parkind, only : im => kind , rb => kind  
      use rrlw_kg12, only : fracrefao, kao, selfrefo, forrefo

      implicit none
      save

! Planck fraction mapping level : P = 174.1640 mbar, T= 215.78 K
      fracrefao(:, 1) = (/ &
     &  1.3984e-01 ,1.6809e-01 ,1.8072e-01 ,1.5400e-01 ,1.2613e-01 ,9.6959e-02 , &
     &  5.9713e-02 ,3.8631e-02 ,2.6937e-02 ,3.1711e-03 ,2.3458e-03 ,1.4653e-03 , &
     &  1.0567e-03 ,6.6504e-04 ,2.4957e-04 ,3.5172e-05 /)
      fracrefao(:, 2) = (/ &
     &  1.2745e-01 ,1.6107e-01 ,1.6568e-01 ,1.5436e-01 ,1.3183e-01 ,1.0166e-01 , &
     &  6.4506e-02 ,4.7756e-02 ,3.4472e-02 ,3.7189e-03 ,2.9349e-03 ,2.1469e-03 , &
     &  1.3746e-03 ,7.1691e-04 ,2.8057e-04 ,5.6242e-05 /)
      fracrefao(:, 3) = (/ &
     &  1.2181e-01 ,1.5404e-01 ,1.6540e-01 ,1.5255e-01 ,1.3736e-01 ,9.8856e-02 , &
     &  6.8927e-02 ,5.1385e-02 ,3.7046e-02 ,4.0302e-03 ,3.0949e-03 ,2.3772e-03 , &
     &  1.6538e-03 ,8.9641e-04 ,4.6991e-04 ,1.1251e-04 /)
      fracrefao(:, 4) = (/ &
     &  1.1794e-01 ,1.4864e-01 ,1.6316e-01 ,1.5341e-01 ,1.3986e-01 ,9.6656e-02 , &
     &  7.2478e-02 ,5.5061e-02 ,3.8886e-02 ,4.3398e-03 ,3.3576e-03 ,2.4891e-03 , &
     &  1.7674e-03 ,1.0764e-03 ,7.7689e-04 ,1.1251e-04 /)
      fracrefao(:, 5) = (/ &
     &  1.1635e-01 ,1.4342e-01 ,1.5924e-01 ,1.5670e-01 ,1.3740e-01 ,9.7087e-02 , &
     &  7.6250e-02 ,5.7802e-02 ,4.0808e-02 ,4.4113e-03 ,3.6035e-03 ,2.6269e-03 , &
     &  1.7586e-03 ,1.6498e-03 ,7.7689e-04 ,1.1251e-04 /)
      fracrefao(:, 6) = (/ &
     &  1.1497e-01 ,1.3751e-01 ,1.5587e-01 ,1.5904e-01 ,1.3140e-01 ,1.0159e-01 , &
     &  7.9729e-02 ,6.1475e-02 ,4.2382e-02 ,4.5291e-03 ,3.8161e-03 ,2.7683e-03 , &
     &  1.9899e-03 ,2.0395e-03 ,7.7720e-04 ,1.1251e-04 /)
      fracrefao(:, 7) = (/ &
     &  1.1331e-01 ,1.3015e-01 ,1.5574e-01 ,1.5489e-01 ,1.2697e-01 ,1.0746e-01 , &
     &  8.4777e-02 ,6.5145e-02 ,4.4293e-02 ,4.7426e-03 ,3.8383e-03 ,2.9065e-03 , &
     &  2.8430e-03 ,2.0401e-03 ,7.7689e-04 ,1.1251e-04 /)
      fracrefao(:, 8) = (/ &
     &  1.0993e-01 ,1.2320e-01 ,1.4893e-01 ,1.4573e-01 ,1.3174e-01 ,1.1149e-01 , &
     &  9.3326e-02 ,6.9942e-02 ,4.6762e-02 ,4.9309e-03 ,3.8583e-03 ,4.1889e-03 , &
     &  3.0415e-03 ,2.0406e-03 ,7.7720e-04 ,1.1251e-04 /)
      fracrefao(:, 9) = (/ &
     &  1.2028e-01 ,1.2091e-01 ,1.3098e-01 ,1.3442e-01 ,1.3574e-01 ,1.1739e-01 , &
     &  9.5343e-02 ,7.0224e-02 ,5.3456e-02 ,6.0206e-03 ,5.0758e-03 ,4.1906e-03 , &
     &  3.0431e-03 ,2.0400e-03 ,7.7689e-04 ,1.1251e-04 /)

!     The array KAO contains absorption coefs for each of the 16 g-intervals
!     for a range of pressure levels > ~100mb, temperatures, and ratios
!     of water vapor to CO2.  The first index in the array, JS, runs
!     from 1 to 10, and corresponds to different gas column amount ratios,
!     as expressed through the binary species parameter eta, defined as
!     eta = gas1/(gas1 + (rat) * gas2), where rat is the 
!     ratio of the reference MLS column amount value of gas 1 
!     to that of gas2.
!     The 2nd index in the array, JT, which runs from 1 to 5, corresponds 
!     to different temperatures.  More specifically, JT = 3 means that the 
!     data are for the reference temperature TREF for this  pressure 
!     level, JT = 2 refers to the temperature
!     TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and JT = 5
!     is for TREF+30.  The third index, JP, runs from 1 to 13 and refers
!     to the reference pressure level (e.g. JP = 1 is for a
!     pressure of 1053.63 mb).  The fourth index, IG, goes from 1 to 16,
!     and tells us which g-interval the absorption coefficients are for.

      kao(:, 1, 1, 1) = (/ &
     &1.7511e-07 ,6.8135e-05 ,1.1804e-04 ,1.6931e-04 ,2.2006e-04 ,2.8275e-04 , &
     &3.5722e-04 ,4.9530e-04 ,3.5719e-04 /)
      kao(:, 2, 1, 1) = (/ &
     &1.9831e-07 ,7.7459e-05 ,1.3459e-04 ,1.9095e-04 ,2.5338e-04 ,3.1724e-04 , &
     &4.1347e-04 ,5.5823e-04 ,4.1876e-04 /)
      kao(:, 3, 1, 1) = (/ &
     &2.2440e-07 ,8.7653e-05 ,1.5288e-04 ,2.1636e-04 ,2.8321e-04 ,3.6387e-04 , &
     &4.5547e-04 ,6.4036e-04 ,4.9001e-04 /)
      kao(:, 4, 1, 1) = (/ &
     &2.4907e-07 ,9.8921e-05 ,1.7279e-04 ,2.4495e-04 ,3.1911e-04 ,4.0317e-04 , &
     &5.1922e-04 ,7.1060e-04 ,5.5803e-04 /)
      kao(:, 5, 1, 1) = (/ &
     &2.7577e-07 ,1.1088e-04 ,1.9448e-04 ,2.7670e-04 ,3.6112e-04 ,4.5291e-04 , &
     &5.7232e-04 ,7.9647e-04 ,6.3718e-04 /)
      kao(:, 1, 2, 1) = (/ &
     &2.1743e-07 ,5.9697e-05 ,1.0011e-04 ,1.3856e-04 ,1.7837e-04 ,2.1937e-04 , &
     &2.7665e-04 ,3.5934e-04 ,2.6865e-04 /)
      kao(:, 2, 2, 1) = (/ &
     &2.4689e-07 ,6.8199e-05 ,1.1473e-04 ,1.5826e-04 ,2.0299e-04 ,2.5265e-04 , &
     &3.0999e-04 ,4.0941e-04 ,3.2103e-04 /)
      kao(:, 3, 2, 1) = (/ &
     &2.7759e-07 ,7.7428e-05 ,1.3086e-04 ,1.8044e-04 ,2.2946e-04 ,2.8434e-04 , &
     &3.5412e-04 ,4.7313e-04 ,3.7455e-04 /)
      kao(:, 4, 2, 1) = (/ &
     &3.1162e-07 ,8.7312e-05 ,1.4837e-04 ,2.0486e-04 ,2.6086e-04 ,3.2026e-04 , &
     &3.9490e-04 ,5.1882e-04 ,4.3142e-04 /)
      kao(:, 5, 2, 1) = (/ &
     &3.4483e-07 ,9.7902e-05 ,1.6760e-04 ,2.3163e-04 ,2.9600e-04 ,3.6332e-04 , &
     &4.4224e-04 ,5.8485e-04 ,4.9654e-04 /)
      kao(:, 1, 3, 1) = (/ &
     &3.5522e-07 ,5.4633e-05 ,8.9953e-05 ,1.1946e-04 ,1.4735e-04 ,1.7547e-04 , &
     &2.0438e-04 ,2.5064e-04 ,1.9532e-04 /)
      kao(:, 2, 3, 1) = (/ &
     &4.0312e-07 ,6.2965e-05 ,1.0335e-04 ,1.3746e-04 ,1.6817e-04 ,1.9939e-04 , &
     &2.3562e-04 ,2.9335e-04 ,2.3482e-04 /)
      kao(:, 3, 3, 1) = (/ &
     &4.5344e-07 ,7.1817e-05 ,1.1822e-04 ,1.5709e-04 ,1.9287e-04 ,2.2736e-04 , &
     &2.6619e-04 ,3.2521e-04 ,2.7722e-04 /)
      kao(:, 4, 3, 1) = (/ &
     &5.1341e-07 ,8.1197e-05 ,1.3399e-04 ,1.7909e-04 ,2.2021e-04 ,2.5936e-04 , &
     &3.0089e-04 ,3.7007e-04 ,3.2243e-04 /)
      kao(:, 5, 3, 1) = (/ &
     &5.7093e-07 ,9.0935e-05 ,1.5129e-04 ,2.0303e-04 ,2.4981e-04 ,2.9482e-04 , &
     &3.4243e-04 ,4.0910e-04 ,3.7408e-04 /)
      kao(:, 1, 4, 1) = (/ &
     &5.9029e-07 ,4.8269e-05 ,8.1661e-05 ,1.0687e-04 ,1.2826e-04 ,1.4610e-04 , &
     &1.6333e-04 ,1.8670e-04 ,1.4151e-04 /)
      kao(:, 2, 4, 1) = (/ &
     &6.7060e-07 ,5.6349e-05 ,9.4916e-05 ,1.2365e-04 ,1.4803e-04 ,1.6776e-04 , &
     &1.8719e-04 ,2.1036e-04 ,1.7196e-04 /)
      kao(:, 3, 4, 1) = (/ &
     &7.5759e-07 ,6.4869e-05 ,1.0916e-04 ,1.4206e-04 ,1.6962e-04 ,1.9348e-04 , &
     &2.1325e-04 ,2.4238e-04 ,2.0611e-04 /)
      kao(:, 4, 4, 1) = (/ &
     &8.5937e-07 ,7.4063e-05 ,1.2416e-04 ,1.6207e-04 ,1.9412e-04 ,2.2126e-04 , &
     &2.4479e-04 ,2.7146e-04 ,2.4157e-04 /)
      kao(:, 5, 4, 1) = (/ &
     &9.5897e-07 ,8.3687e-05 ,1.3973e-04 ,1.8364e-04 ,2.2051e-04 ,2.5234e-04 , &
     &2.7911e-04 ,3.0928e-04 ,2.8248e-04 /)
      kao(:, 1, 5, 1) = (/ &
     &9.1759e-07 ,4.1947e-05 ,7.0794e-05 ,9.4885e-05 ,1.1243e-04 ,1.2599e-04 , &
     &1.3683e-04 ,1.4293e-04 ,1.0336e-04 /)
      kao(:, 2, 5, 1) = (/ &
     &1.0425e-06 ,4.9113e-05 ,8.3728e-05 ,1.1140e-04 ,1.3168e-04 ,1.4605e-04 , &
     &1.5650e-04 ,1.6563e-04 ,1.2713e-04 /)
      kao(:, 3, 5, 1) = (/ &
     &1.1835e-06 ,5.7263e-05 ,9.7394e-05 ,1.2924e-04 ,1.5190e-04 ,1.6881e-04 , &
     &1.8096e-04 ,1.8906e-04 ,1.5436e-04 /)
      kao(:, 4, 5, 1) = (/ &
     &1.3393e-06 ,6.6178e-05 ,1.1132e-04 ,1.4759e-04 ,1.7411e-04 ,1.9396e-04 , &
     &2.0764e-04 ,2.1628e-04 ,1.8190e-04 /)
      kao(:, 5, 5, 1) = (/ &
     &1.4988e-06 ,7.5103e-05 ,1.2617e-04 ,1.6721e-04 ,1.9778e-04 ,2.2104e-04 , &
     &2.3789e-04 ,2.4796e-04 ,2.1416e-04 /)
      kao(:, 1, 6, 1) = (/ &
     &1.3509e-06 ,3.6190e-05 ,6.0186e-05 ,8.0089e-05 ,9.7447e-05 ,1.0817e-04 , &
     &1.1477e-04 ,1.1459e-04 ,7.5216e-05 /)
      kao(:, 2, 6, 1) = (/ &
     &1.5379e-06 ,4.3048e-05 ,7.1223e-05 ,9.5429e-05 ,1.1555e-04 ,1.2778e-04 , &
     &1.3385e-04 ,1.3550e-04 ,9.3747e-05 /)
      kao(:, 3, 6, 1) = (/ &
     &1.7505e-06 ,5.0649e-05 ,8.3443e-05 ,1.1225e-04 ,1.3468e-04 ,1.4925e-04 , &
     &1.5516e-04 ,1.5522e-04 ,1.1566e-04 /)
      kao(:, 4, 6, 1) = (/ &
     &1.9769e-06 ,5.8613e-05 ,9.7176e-05 ,1.2952e-04 ,1.5512e-04 ,1.7221e-04 , &
     &1.7952e-04 ,1.7884e-04 ,1.3754e-04 /)
      kao(:, 5, 6, 1) = (/ &
     &2.2201e-06 ,6.7356e-05 ,1.1202e-04 ,1.4825e-04 ,1.7722e-04 ,1.9650e-04 , &
     &2.0554e-04 ,2.0495e-04 ,1.6355e-04 /)
      kao(:, 1, 7, 1) = (/ &
     &2.1304e-06 ,3.3089e-05 ,5.1849e-05 ,6.8730e-05 ,8.2305e-05 ,9.3472e-05 , &
     &9.9164e-05 ,9.8631e-05 ,5.9418e-05 /)
      kao(:, 2, 7, 1) = (/ &
     &2.4308e-06 ,3.9636e-05 ,6.2051e-05 ,8.1968e-05 ,9.8909e-05 ,1.1256e-04 , &
     &1.1810e-04 ,1.1396e-04 ,7.5269e-05 /)
      kao(:, 3, 7, 1) = (/ &
     &2.7537e-06 ,4.6821e-05 ,7.3795e-05 ,9.6812e-05 ,1.1738e-04 ,1.3274e-04 , &
     &1.3903e-04 ,1.3282e-04 ,9.2641e-05 /)
      kao(:, 4, 7, 1) = (/ &
     &3.1212e-06 ,5.4439e-05 ,8.6765e-05 ,1.1374e-04 ,1.3694e-04 ,1.5474e-04 , &
     &1.6192e-04 ,1.5375e-04 ,1.1184e-04 /)
      kao(:, 5, 7, 1) = (/ &
     &3.5210e-06 ,6.2611e-05 ,9.9782e-05 ,1.3214e-04 ,1.5850e-04 ,1.7752e-04 , &
     &1.8622e-04 ,1.7734e-04 ,1.3357e-04 /)
      kao(:, 1, 8, 1) = (/ &
     &4.1180e-06 ,3.5356e-05 ,4.9875e-05 ,6.2112e-05 ,7.3272e-05 ,8.1665e-05 , &
     &8.7559e-05 ,8.6370e-05 ,4.9881e-05 /)
      kao(:, 2, 8, 1) = (/ &
     &4.6880e-06 ,4.2308e-05 ,6.0139e-05 ,7.5108e-05 ,8.8001e-05 ,9.9269e-05 , &
     &1.0597e-04 ,1.0409e-04 ,6.3232e-05 /)
      kao(:, 3, 8, 1) = (/ &
     &5.2893e-06 ,4.9705e-05 ,7.1733e-05 ,8.9997e-05 ,1.0540e-04 ,1.1807e-04 , &
     &1.2729e-04 ,1.2367e-04 ,7.9488e-05 /)
      kao(:, 4, 8, 1) = (/ &
     &5.9934e-06 ,5.7629e-05 ,8.3852e-05 ,1.0617e-04 ,1.2505e-04 ,1.3960e-04 , &
     &1.5001e-04 ,1.4519e-04 ,9.7332e-05 /)
      kao(:, 5, 8, 1) = (/ &
     &6.8016e-06 ,6.6193e-05 ,9.7237e-05 ,1.2349e-04 ,1.4561e-04 ,1.6359e-04 , &
     &1.7405e-04 ,1.6782e-04 ,1.1691e-04 /)
      kao(:, 1, 9, 1) = (/ &
     &1.5173e-05 ,6.0073e-05 ,7.5522e-05 ,8.4608e-05 ,8.9391e-05 ,9.1045e-05 , &
     &9.0015e-05 ,8.5089e-05 ,6.2916e-05 /)
      kao(:, 2, 9, 1) = (/ &
     &1.7118e-05 ,7.2165e-05 ,9.0975e-05 ,1.0209e-04 ,1.0823e-04 ,1.1031e-04 , &
     &1.0910e-04 ,1.0450e-04 ,8.0378e-05 /)
      kao(:, 3, 9, 1) = (/ &
     &1.9333e-05 ,8.4779e-05 ,1.0715e-04 ,1.2042e-04 ,1.2865e-04 ,1.3251e-04 , &
     &1.3198e-04 ,1.2575e-04 ,1.0185e-04 /)
      kao(:, 4, 9, 1) = (/ &
     &2.2020e-05 ,9.7885e-05 ,1.2402e-04 ,1.4031e-04 ,1.5091e-04 ,1.5615e-04 , &
     &1.5775e-04 ,1.5010e-04 ,1.2495e-04 /)
      kao(:, 5, 9, 1) = (/ &
     &2.4990e-05 ,1.1102e-04 ,1.4167e-04 ,1.6181e-04 ,1.7511e-04 ,1.8231e-04 , &
     &1.8406e-04 ,1.7738e-04 ,1.4891e-04 /)
      kao(:, 1,10, 1) = (/ &
     &6.3843e-05 ,1.3785e-04 ,1.5635e-04 ,1.6287e-04 ,1.6037e-04 ,1.5248e-04 , &
     &1.3606e-04 ,1.0761e-04 ,1.0144e-04 /)
      kao(:, 2,10, 1) = (/ &
     &7.2156e-05 ,1.6111e-04 ,1.8530e-04 ,1.9419e-04 ,1.9482e-04 ,1.8548e-04 , &
     &1.6571e-04 ,1.3139e-04 ,1.2609e-04 /)
      kao(:, 3,10, 1) = (/ &
     &8.1633e-05 ,1.8623e-04 ,2.1467e-04 ,2.2993e-04 ,2.3146e-04 ,2.2096e-04 , &
     &1.9656e-04 ,1.5757e-04 ,1.5350e-04 /)
      kao(:, 4,10, 1) = (/ &
     &9.2413e-05 ,2.1393e-04 ,2.4898e-04 ,2.6688e-04 ,2.6838e-04 ,2.5715e-04 , &
     &2.2901e-04 ,1.8640e-04 ,1.8257e-04 /)
      kao(:, 5,10, 1) = (/ &
     &1.0426e-04 ,2.4538e-04 ,2.8330e-04 ,3.0298e-04 ,3.0752e-04 ,2.9416e-04 , &
     &2.6511e-04 ,2.1835e-04 ,2.1288e-04 /)
      kao(:, 1,11, 1) = (/ &
     &9.9914e-05 ,1.8204e-04 ,1.9923e-04 ,2.0432e-04 ,1.9733e-04 ,1.8201e-04 , &
     &1.5904e-04 ,1.2299e-04 ,1.0910e-04 /)
      kao(:, 2,11, 1) = (/ &
     &1.1199e-04 ,2.1265e-04 ,2.3389e-04 ,2.4089e-04 ,2.3442e-04 ,2.2069e-04 , &
     &1.9371e-04 ,1.4882e-04 ,1.3411e-04 /)
      kao(:, 3,11, 1) = (/ &
     &1.2687e-04 ,2.4499e-04 ,2.7026e-04 ,2.7909e-04 ,2.7675e-04 ,2.6044e-04 , &
     &2.2915e-04 ,1.7718e-04 ,1.6026e-04 /)
      kao(:, 4,11, 1) = (/ &
     &1.4261e-04 ,2.8101e-04 ,3.1141e-04 ,3.2255e-04 ,3.1948e-04 ,3.0150e-04 , &
     &2.6612e-04 ,2.0752e-04 ,1.8601e-04 /)
      kao(:, 5,11, 1) = (/ &
     &1.5789e-04 ,3.1929e-04 ,3.5513e-04 ,3.6602e-04 ,3.6282e-04 ,3.4410e-04 , &
     &3.0577e-04 ,2.4097e-04 ,2.1352e-04 /)
      kao(:, 1,12, 1) = (/ &
     &1.1122e-04 ,1.9022e-04 ,2.0568e-04 ,2.0798e-04 ,2.0013e-04 ,1.8369e-04 , &
     &1.5756e-04 ,1.2037e-04 ,1.0098e-04 /)
      kao(:, 2,12, 1) = (/ &
     &1.2500e-04 ,2.2156e-04 ,2.4046e-04 ,2.4347e-04 ,2.3764e-04 ,2.2116e-04 , &
     &1.9272e-04 ,1.4643e-04 ,1.2390e-04 /)
      kao(:, 3,12, 1) = (/ &
     &1.4056e-04 ,2.5489e-04 ,2.7764e-04 ,2.8122e-04 ,2.7905e-04 ,2.5886e-04 , &
     &2.2636e-04 ,1.7352e-04 ,1.4664e-04 /)
      kao(:, 4,12, 1) = (/ &
     &1.5858e-04 ,2.9021e-04 ,3.1841e-04 ,3.2551e-04 ,3.1903e-04 ,2.9848e-04 , &
     &2.6254e-04 ,2.0265e-04 ,1.7061e-04 /)
      kao(:, 5,12, 1) = (/ &
     &1.7398e-04 ,3.2750e-04 ,3.6207e-04 ,3.6880e-04 ,3.6058e-04 ,3.3907e-04 , &
     &2.9970e-04 ,2.3401e-04 ,1.9575e-04 /)
      kao(:, 1,13, 1) = (/ &
     &9.9982e-05 ,1.6786e-04 ,1.8157e-04 ,1.8311e-04 ,1.7732e-04 ,1.6257e-04 , &
     &1.4107e-04 ,1.0684e-04 ,8.8282e-05 /)
      kao(:, 2,13, 1) = (/ &
     &1.1208e-04 ,1.9489e-04 ,2.1207e-04 ,2.1420e-04 ,2.0856e-04 ,1.9501e-04 , &
     &1.6942e-04 ,1.2896e-04 ,1.0706e-04 /)
      kao(:, 3,13, 1) = (/ &
     &1.2580e-04 ,2.2390e-04 ,2.4368e-04 ,2.4899e-04 ,2.4426e-04 ,2.2695e-04 , &
     &1.9796e-04 ,1.5273e-04 ,1.2657e-04 /)
      kao(:, 4,13, 1) = (/ &
     &1.4115e-04 ,2.5382e-04 ,2.8079e-04 ,2.8499e-04 ,2.7843e-04 ,2.6072e-04 , &
     &2.2903e-04 ,1.7905e-04 ,1.4711e-04 /)
      kao(:, 5,13, 1) = (/ &
     &1.5465e-04 ,2.8798e-04 ,3.1774e-04 ,3.2258e-04 ,3.1431e-04 ,2.9430e-04 , &
     &2.6133e-04 ,2.0499e-04 ,1.6802e-04 /)
      kao(:, 1, 1, 2) = (/ &
     &3.7683e-07 ,1.9808e-04 ,3.6685e-04 ,5.3916e-04 ,7.1167e-04 ,8.9309e-04 , &
     &1.1251e-03 ,1.6060e-03 ,1.3216e-03 /)
      kao(:, 2, 1, 2) = (/ &
     &4.2181e-07 ,2.2081e-04 ,4.0843e-04 ,6.0005e-04 ,7.9854e-04 ,1.0235e-03 , &
     &1.2747e-03 ,1.7730e-03 ,1.5072e-03 /)
      kao(:, 3, 1, 2) = (/ &
     &4.6205e-07 ,2.4503e-04 ,4.5395e-04 ,6.6471e-04 ,8.8503e-04 ,1.1345e-03 , &
     &1.4567e-03 ,1.9804e-03 ,1.6670e-03 /)
      kao(:, 4, 1, 2) = (/ &
     &5.1491e-07 ,2.7069e-04 ,5.0378e-04 ,7.3699e-04 ,9.7626e-04 ,1.2446e-03 , &
     &1.5952e-03 ,2.2188e-03 ,1.8463e-03 /)
      kao(:, 5, 1, 2) = (/ &
     &5.5977e-07 ,2.9608e-04 ,5.5719e-04 ,8.1557e-04 ,1.0806e-03 ,1.3738e-03 , &
     &1.7497e-03 ,2.4313e-03 ,2.0562e-03 /)
      kao(:, 1, 2, 2) = (/ &
     &4.7123e-07 ,1.6943e-04 ,3.0287e-04 ,4.3680e-04 ,5.7665e-04 ,7.0994e-04 , &
     &8.5911e-04 ,1.1308e-03 ,1.0172e-03 /)
      kao(:, 2, 2, 2) = (/ &
     &5.2931e-07 ,1.8961e-04 ,3.3976e-04 ,4.8868e-04 ,6.4337e-04 ,8.0862e-04 , &
     &9.8935e-04 ,1.2742e-03 ,1.1602e-03 /)
      kao(:, 3, 2, 2) = (/ &
     &5.8844e-07 ,2.1120e-04 ,3.7935e-04 ,5.4606e-04 ,7.1722e-04 ,8.9758e-04 , &
     &1.1168e-03 ,1.4348e-03 ,1.3002e-03 /)
      kao(:, 4, 2, 2) = (/ &
     &6.4390e-07 ,2.3336e-04 ,4.2266e-04 ,6.0899e-04 ,7.9911e-04 ,9.9511e-04 , &
     &1.2304e-03 ,1.6357e-03 ,1.4539e-03 /)
      kao(:, 5, 2, 2) = (/ &
     &7.0717e-07 ,2.5573e-04 ,4.6939e-04 ,6.7801e-04 ,8.8876e-04 ,1.1052e-03 , &
     &1.3595e-03 ,1.7810e-03 ,1.6268e-03 /)
      kao(:, 1, 3, 2) = (/ &
     &7.7382e-07 ,1.5592e-04 ,2.6004e-04 ,3.5917e-04 ,4.5597e-04 ,5.6221e-04 , &
     &6.6191e-04 ,7.8092e-04 ,7.5320e-04 /)
      kao(:, 2, 3, 2) = (/ &
     &8.7904e-07 ,1.7462e-04 ,2.9301e-04 ,4.0553e-04 ,5.1639e-04 ,6.3236e-04 , &
     &7.5999e-04 ,8.9592e-04 ,8.6804e-04 /)
      kao(:, 3, 3, 2) = (/ &
     &9.8281e-07 ,1.9263e-04 ,3.2870e-04 ,4.5631e-04 ,5.8039e-04 ,7.0848e-04 , &
     &8.4867e-04 ,1.0369e-03 ,9.8463e-04 /)
      kao(:, 4, 3, 2) = (/ &
     &1.0791e-06 ,2.1196e-04 ,3.6740e-04 ,5.1125e-04 ,6.5128e-04 ,7.9536e-04 , &
     &9.4873e-04 ,1.1498e-03 ,1.1137e-03 /)
      kao(:, 5, 3, 2) = (/ &
     &1.1811e-06 ,2.3314e-04 ,4.0444e-04 ,5.7096e-04 ,7.2953e-04 ,8.9019e-04 , &
     &1.0598e-03 ,1.2765e-03 ,1.2563e-03 /)
      kao(:, 1, 4, 2) = (/ &
     &1.2931e-06 ,1.5459e-04 ,2.3712e-04 ,3.1151e-04 ,3.8051e-04 ,4.4732e-04 , &
     &5.1939e-04 ,5.8139e-04 ,5.5932e-04 /)
      kao(:, 2, 4, 2) = (/ &
     &1.4961e-06 ,1.6924e-04 ,2.6743e-04 ,3.5309e-04 ,4.3277e-04 ,5.1005e-04 , &
     &5.8720e-04 ,6.8557e-04 ,6.5449e-04 /)
      kao(:, 3, 4, 2) = (/ &
     &1.6687e-06 ,1.8668e-04 ,2.9946e-04 ,3.9815e-04 ,4.8978e-04 ,5.7712e-04 , &
     &6.6568e-04 ,7.7293e-04 ,7.4803e-04 /)
      kao(:, 4, 4, 2) = (/ &
     &1.8491e-06 ,2.0517e-04 ,3.2982e-04 ,4.4741e-04 ,5.5202e-04 ,6.5205e-04 , &
     &7.5198e-04 ,8.7064e-04 ,8.5540e-04 /)
      kao(:, 5, 4, 2) = (/ &
     &2.0324e-06 ,2.2162e-04 ,3.6469e-04 ,4.9544e-04 ,6.1968e-04 ,7.3378e-04 , &
     &8.4769e-04 ,9.7614e-04 ,9.7197e-04 /)
      kao(:, 1, 5, 2) = (/ &
     &2.0065e-06 ,1.5150e-04 ,2.2968e-04 ,2.8386e-04 ,3.3168e-04 ,3.7581e-04 , &
     &4.1489e-04 ,4.5675e-04 ,4.1358e-04 /)
      kao(:, 2, 5, 2) = (/ &
     &2.3252e-06 ,1.6854e-04 ,2.5480e-04 ,3.2081e-04 ,3.7754e-04 ,4.3026e-04 , &
     &4.7606e-04 ,5.2820e-04 ,4.9368e-04 /)
      kao(:, 3, 5, 2) = (/ &
     &2.6085e-06 ,1.8331e-04 ,2.8033e-04 ,3.6056e-04 ,4.2825e-04 ,4.8928e-04 , &
     &5.4309e-04 ,5.9807e-04 ,5.6993e-04 /)
      kao(:, 4, 5, 2) = (/ &
     &2.9132e-06 ,1.9761e-04 ,3.1015e-04 ,3.9882e-04 ,4.8412e-04 ,5.5460e-04 , &
     &6.1782e-04 ,6.7980e-04 ,6.5837e-04 /)
      kao(:, 5, 5, 2) = (/ &
     &3.2361e-06 ,2.1434e-04 ,3.4118e-04 ,4.4180e-04 ,5.3752e-04 ,6.2588e-04 , &
     &6.9930e-04 ,7.7113e-04 ,7.5327e-04 /)
      kao(:, 1, 6, 2) = (/ &
     &2.9230e-06 ,1.3806e-04 ,2.1835e-04 ,2.7095e-04 ,3.0194e-04 ,3.2758e-04 , &
     &3.4587e-04 ,3.6408e-04 ,3.0468e-04 /)
      kao(:, 2, 6, 2) = (/ &
     &3.4021e-06 ,1.5365e-04 ,2.4578e-04 ,3.0400e-04 ,3.4286e-04 ,3.7318e-04 , &
     &3.9861e-04 ,4.1438e-04 ,3.7021e-04 /)
      kao(:, 3, 6, 2) = (/ &
     &3.8620e-06 ,1.7051e-04 ,2.7334e-04 ,3.3438e-04 ,3.8715e-04 ,4.2432e-04 , &
     &4.5662e-04 ,4.7772e-04 ,4.3260e-04 /)
      kao(:, 4, 6, 2) = (/ &
     &4.2870e-06 ,1.8887e-04 ,2.9668e-04 ,3.7137e-04 ,4.2886e-04 ,4.8133e-04 , &
     &5.2053e-04 ,5.4689e-04 ,5.0258e-04 /)
      kao(:, 5, 6, 2) = (/ &
     &4.8423e-06 ,2.0662e-04 ,3.1977e-04 ,4.1089e-04 ,4.7609e-04 ,5.3742e-04 , &
     &5.9126e-04 ,6.2337e-04 ,5.7823e-04 /)
      kao(:, 1, 7, 2) = (/ &
     &4.5404e-06 ,1.3143e-04 ,2.0727e-04 ,2.6052e-04 ,2.9635e-04 ,3.0743e-04 , &
     &3.0825e-04 ,2.9703e-04 ,2.2197e-04 /)
      kao(:, 2, 7, 2) = (/ &
     &5.2640e-06 ,1.4772e-04 ,2.3068e-04 ,2.9687e-04 ,3.3184e-04 ,3.4986e-04 , &
     &3.5249e-04 ,3.4543e-04 ,2.7330e-04 /)
      kao(:, 3, 7, 2) = (/ &
     &6.0466e-06 ,1.6470e-04 ,2.5696e-04 ,3.3234e-04 ,3.6914e-04 ,3.9626e-04 , &
     &4.0246e-04 ,3.9902e-04 ,3.2329e-04 /)
      kao(:, 4, 7, 2) = (/ &
     &6.7565e-06 ,1.8107e-04 ,2.8421e-04 ,3.6286e-04 ,4.1183e-04 ,4.3876e-04 , &
     &4.5748e-04 ,4.5835e-04 ,3.7913e-04 /)
      kao(:, 5, 7, 2) = (/ &
     &7.6474e-06 ,1.9867e-04 ,3.1475e-04 ,3.9310e-04 ,4.5438e-04 ,4.8957e-04 , &
     &5.1385e-04 ,5.2320e-04 ,4.4016e-04 /)
      kao(:, 1, 8, 2) = (/ &
     &8.6520e-06 ,1.4110e-04 ,2.0496e-04 ,2.5993e-04 ,2.9742e-04 ,3.1821e-04 , &
     &3.1456e-04 ,2.7649e-04 ,1.8485e-04 /)
      kao(:, 2, 8, 2) = (/ &
     &1.0009e-05 ,1.5517e-04 ,2.3206e-04 ,2.9171e-04 ,3.4405e-04 ,3.6414e-04 , &
     &3.5939e-04 ,3.1713e-04 ,2.2424e-04 /)
      kao(:, 3, 8, 2) = (/ &
     &1.1509e-05 ,1.7205e-04 ,2.6018e-04 ,3.2636e-04 ,3.8244e-04 ,4.1241e-04 , &
     &4.0304e-04 ,3.6377e-04 ,2.6821e-04 /)
      kao(:, 4, 8, 2) = (/ &
     &1.3117e-05 ,1.8959e-04 ,2.8945e-04 ,3.6544e-04 ,4.2147e-04 ,4.5788e-04 , &
     &4.4922e-04 ,4.1527e-04 ,3.1806e-04 /)
      kao(:, 5, 8, 2) = (/ &
     &1.4790e-05 ,2.0902e-04 ,3.1840e-04 ,4.0603e-04 ,4.6521e-04 ,4.9945e-04 , &
     &5.0220e-04 ,4.7045e-04 ,3.7190e-04 /)
      kao(:, 1, 9, 2) = (/ &
     &3.0998e-05 ,2.0637e-04 ,2.7947e-04 ,3.3530e-04 ,3.6480e-04 ,3.8205e-04 , &
     &3.8653e-04 ,3.4762e-04 ,1.8242e-04 /)
      kao(:, 2, 9, 2) = (/ &
     &3.6096e-05 ,2.3076e-04 ,3.1240e-04 ,3.7284e-04 ,4.1471e-04 ,4.3432e-04 , &
     &4.4125e-04 ,4.0372e-04 ,2.2363e-04 /)
      kao(:, 3, 9, 2) = (/ &
     &4.2035e-05 ,2.5734e-04 ,3.4822e-04 ,4.1425e-04 ,4.6570e-04 ,4.9153e-04 , &
     &4.9534e-04 ,4.6243e-04 ,2.6686e-04 /)
      kao(:, 4, 9, 2) = (/ &
     &4.8029e-05 ,2.8335e-04 ,3.8624e-04 ,4.5968e-04 ,5.1473e-04 ,5.5196e-04 , &
     &5.5517e-04 ,5.1807e-04 ,3.1577e-04 /)
      kao(:, 5, 9, 2) = (/ &
     &5.5331e-05 ,3.0966e-04 ,4.2837e-04 ,5.0793e-04 ,5.6875e-04 ,6.0971e-04 , &
     &6.2368e-04 ,5.6511e-04 ,3.7171e-04 /)
      kao(:, 1,10, 2) = (/ &
     &1.2964e-04 ,4.0632e-04 ,5.1358e-04 ,5.5581e-04 ,5.6980e-04 ,5.6112e-04 , &
     &5.2892e-04 ,4.3728e-04 ,2.8865e-04 /)
      kao(:, 2,10, 2) = (/ &
     &1.5095e-04 ,4.5953e-04 ,5.7199e-04 ,6.2596e-04 ,6.3988e-04 ,6.3023e-04 , &
     &5.9124e-04 ,5.0100e-04 ,3.5610e-04 /)
      kao(:, 3,10, 2) = (/ &
     &1.7573e-04 ,5.1815e-04 ,6.3409e-04 ,6.9698e-04 ,7.1541e-04 ,7.0519e-04 , &
     &6.6061e-04 ,5.7112e-04 ,4.2862e-04 /)
      kao(:, 4,10, 2) = (/ &
     &2.0254e-04 ,5.7408e-04 ,7.0140e-04 ,7.6485e-04 ,7.9509e-04 ,7.8487e-04 , &
     &7.3767e-04 ,6.4340e-04 ,5.0196e-04 /)
      kao(:, 5,10, 2) = (/ &
     &2.3735e-04 ,6.3435e-04 ,7.7477e-04 ,8.4107e-04 ,8.7369e-04 ,8.7290e-04 , &
     &8.2035e-04 ,7.1353e-04 ,5.7378e-04 /)
      kao(:, 1,11, 2) = (/ &
     &2.0611e-04 ,5.0579e-04 ,6.0906e-04 ,6.6598e-04 ,6.7463e-04 ,6.4325e-04 , &
     &5.7358e-04 ,4.6594e-04 ,3.7105e-04 /)
      kao(:, 2,11, 2) = (/ &
     &2.4168e-04 ,5.7457e-04 ,6.8930e-04 ,7.4695e-04 ,7.5788e-04 ,7.2324e-04 , &
     &6.4676e-04 ,5.2943e-04 ,4.4283e-04 /)
      kao(:, 3,11, 2) = (/ &
     &2.7855e-04 ,6.5109e-04 ,7.7336e-04 ,8.3624e-04 ,8.3721e-04 ,8.0652e-04 , &
     &7.2648e-04 ,5.9132e-04 ,5.1523e-04 /)
      kao(:, 4,11, 2) = (/ &
     &3.2934e-04 ,7.2843e-04 ,8.5922e-04 ,9.2211e-04 ,9.2829e-04 ,8.9207e-04 , &
     &8.1359e-04 ,6.5969e-04 ,5.9146e-04 /)
      kao(:, 5,11, 2) = (/ &
     &3.7624e-04 ,8.0764e-04 ,9.4816e-04 ,1.0176e-03 ,1.0267e-03 ,9.8589e-04 , &
     &9.0003e-04 ,7.3360e-04 ,6.6373e-04 /)
      kao(:, 1,12, 2) = (/ &
     &2.3690e-04 ,5.2345e-04 ,6.1583e-04 ,6.6206e-04 ,6.7308e-04 ,6.4411e-04 , &
     &5.7108e-04 ,4.4594e-04 ,3.6966e-04 /)
      kao(:, 2,12, 2) = (/ &
     &2.7636e-04 ,5.9693e-04 ,6.9824e-04 ,7.5086e-04 ,7.5372e-04 ,7.2129e-04 , &
     &6.4015e-04 ,5.0417e-04 ,4.3519e-04 /)
      kao(:, 3,12, 2) = (/ &
     &3.2475e-04 ,6.7274e-04 ,7.7976e-04 ,8.4185e-04 ,8.4051e-04 ,8.0110e-04 , &
     &7.2036e-04 ,5.6771e-04 ,5.0173e-04 /)
      kao(:, 4,12, 2) = (/ &
     &3.7742e-04 ,7.5354e-04 ,8.6958e-04 ,9.2971e-04 ,9.3567e-04 ,8.9034e-04 , &
     &7.9942e-04 ,6.3511e-04 ,5.6743e-04 /)
      kao(:, 5,12, 2) = (/ &
     &4.2656e-04 ,8.3460e-04 ,9.6197e-04 ,1.0276e-03 ,1.0348e-03 ,9.8795e-04 , &
     &8.8414e-04 ,7.0917e-04 ,6.3181e-04 /)
      kao(:, 1,13, 2) = (/ &
     &2.1559e-04 ,4.7034e-04 ,5.5318e-04 ,5.8764e-04 ,5.9246e-04 ,5.7342e-04 , &
     &5.0467e-04 ,3.9184e-04 ,3.4198e-04 /)
      kao(:, 2,13, 2) = (/ &
     &2.5152e-04 ,5.3422e-04 ,6.2195e-04 ,6.6659e-04 ,6.7272e-04 ,6.3853e-04 , &
     &5.7068e-04 ,4.4436e-04 ,3.9456e-04 /)
      kao(:, 3,13, 2) = (/ &
     &3.0302e-04 ,6.0127e-04 ,6.9437e-04 ,7.4686e-04 ,7.5249e-04 ,7.1183e-04 , &
     &6.4004e-04 ,5.0162e-04 ,4.4714e-04 /)
      kao(:, 4,13, 2) = (/ &
     &3.4242e-04 ,6.7081e-04 ,7.7273e-04 ,8.2774e-04 ,8.3533e-04 ,7.9499e-04 , &
     &7.1004e-04 ,5.6394e-04 ,5.0105e-04 /)
      kao(:, 5,13, 2) = (/ &
     &3.8220e-04 ,7.4575e-04 ,8.5383e-04 ,9.1037e-04 ,9.2303e-04 ,8.8587e-04 , &
     &7.8559e-04 ,6.3207e-04 ,5.5475e-04 /)
      kao(:, 1, 1, 3) = (/ &
     &5.3797e-07 ,4.8188e-04 ,8.9729e-04 ,1.3200e-03 ,1.7770e-03 ,2.3291e-03 , &
     &3.1122e-03 ,4.4511e-03 ,3.5150e-03 /)
      kao(:, 2, 1, 3) = (/ &
     &6.1262e-07 ,5.2615e-04 ,9.8845e-04 ,1.4517e-03 ,1.9408e-03 ,2.5148e-03 , &
     &3.2963e-03 ,4.8584e-03 ,3.8321e-03 /)
      kao(:, 3, 1, 3) = (/ &
     &7.0635e-07 ,5.6647e-04 ,1.0753e-03 ,1.5925e-03 ,2.1392e-03 ,2.7441e-03 , &
     &3.5300e-03 ,5.0419e-03 ,4.2299e-03 /)
      kao(:, 4, 1, 3) = (/ &
     &7.6766e-07 ,6.0727e-04 ,1.1623e-03 ,1.7247e-03 ,2.3255e-03 ,3.0054e-03 , &
     &3.8553e-03 ,5.3163e-03 ,4.6081e-03 /)
      kao(:, 5, 1, 3) = (/ &
     &8.3851e-07 ,6.4796e-04 ,1.2484e-03 ,1.8617e-03 ,2.5127e-03 ,3.2521e-03 , &
     &4.1787e-03 ,5.7407e-03 ,4.9828e-03 /)
      kao(:, 1, 2, 3) = (/ &
     &6.9858e-07 ,4.1220e-04 ,7.5871e-04 ,1.0893e-03 ,1.4250e-03 ,1.8069e-03 , &
     &2.3218e-03 ,3.2208e-03 ,2.7451e-03 /)
      kao(:, 2, 2, 3) = (/ &
     &8.1006e-07 ,4.4690e-04 ,8.3751e-04 ,1.2083e-03 ,1.5781e-03 ,1.9758e-03 , &
     &2.4966e-03 ,3.4638e-03 ,3.0268e-03 /)
      kao(:, 3, 2, 3) = (/ &
     &9.0719e-07 ,4.8245e-04 ,9.0580e-04 ,1.3167e-03 ,1.7362e-03 ,2.1788e-03 , &
     &2.7148e-03 ,3.6613e-03 ,3.3476e-03 /)
      kao(:, 4, 2, 3) = (/ &
     &9.9070e-07 ,5.1202e-04 ,9.7859e-04 ,1.4272e-03 ,1.8822e-03 ,2.3784e-03 , &
     &2.9761e-03 ,3.9189e-03 ,3.6534e-03 /)
      kao(:, 5, 2, 3) = (/ &
     &1.0800e-06 ,5.4986e-04 ,1.0443e-03 ,1.5370e-03 ,2.0346e-03 ,2.5754e-03 , &
     &3.2289e-03 ,4.2581e-03 ,3.9665e-03 /)
      kao(:, 1, 3, 3) = (/ &
     &1.1956e-06 ,3.6533e-04 ,6.4857e-04 ,9.1797e-04 ,1.1753e-03 ,1.4236e-03 , &
     &1.7165e-03 ,2.2362e-03 ,2.0894e-03 /)
      kao(:, 2, 3, 3) = (/ &
     &1.3685e-06 ,3.9659e-04 ,7.1084e-04 ,1.0164e-03 ,1.3082e-03 ,1.5859e-03 , &
     &1.8841e-03 ,2.3586e-03 ,2.3274e-03 /)
      kao(:, 3, 3, 3) = (/ &
     &1.5093e-06 ,4.2397e-04 ,7.7009e-04 ,1.1048e-03 ,1.4344e-03 ,1.7565e-03 , &
     &2.0870e-03 ,2.5514e-03 ,2.5907e-03 /)
      kao(:, 4, 3, 3) = (/ &
     &1.6732e-06 ,4.5580e-04 ,8.2534e-04 ,1.1953e-03 ,1.5533e-03 ,1.9057e-03 , &
     &2.2804e-03 ,2.8031e-03 ,2.8387e-03 /)
      kao(:, 5, 3, 3) = (/ &
     &1.8304e-06 ,4.8851e-04 ,8.8340e-04 ,1.2735e-03 ,1.6704e-03 ,2.0642e-03 , &
     &2.4727e-03 ,3.0561e-03 ,3.0939e-03 /)
      kao(:, 1, 4, 3) = (/ &
     &2.0440e-06 ,3.4190e-04 ,5.7528e-04 ,7.8555e-04 ,9.8576e-04 ,1.1789e-03 , &
     &1.3557e-03 ,1.6128e-03 ,1.5891e-03 /)
      kao(:, 2, 4, 3) = (/ &
     &2.2803e-06 ,3.6626e-04 ,6.2613e-04 ,8.6621e-04 ,1.0945e-03 ,1.3150e-03 , &
     &1.5191e-03 ,1.7412e-03 ,1.7827e-03 /)
      kao(:, 3, 4, 3) = (/ &
     &2.5344e-06 ,3.9307e-04 ,6.7511e-04 ,9.4372e-04 ,1.1954e-03 ,1.4474e-03 , &
     &1.6882e-03 ,1.9262e-03 ,2.0030e-03 /)
      kao(:, 4, 4, 3) = (/ &
     &2.8636e-06 ,4.1974e-04 ,7.2769e-04 ,1.0153e-03 ,1.2977e-03 ,1.5716e-03 , &
     &1.8427e-03 ,2.1315e-03 ,2.2084e-03 /)
      kao(:, 5, 4, 3) = (/ &
     &3.0668e-06 ,4.5207e-04 ,7.8267e-04 ,1.0885e-03 ,1.3854e-03 ,1.6897e-03 , &
     &1.9964e-03 ,2.3147e-03 ,2.4195e-03 /)
      kao(:, 1, 5, 3) = (/ &
     &3.1319e-06 ,3.2418e-04 ,5.2433e-04 ,6.9885e-04 ,8.4707e-04 ,9.8232e-04 , &
     &1.1112e-03 ,1.2410e-03 ,1.2226e-03 /)
      kao(:, 2, 5, 3) = (/ &
     &3.5295e-06 ,3.4929e-04 ,5.6868e-04 ,7.6274e-04 ,9.3852e-04 ,1.0972e-03 , &
     &1.2472e-03 ,1.3812e-03 ,1.3798e-03 /)
      kao(:, 3, 5, 3) = (/ &
     &3.9745e-06 ,3.7641e-04 ,6.1261e-04 ,8.2611e-04 ,1.0255e-03 ,1.2065e-03 , &
     &1.3836e-03 ,1.5454e-03 ,1.5563e-03 /)
      kao(:, 4, 5, 3) = (/ &
     &4.4389e-06 ,4.0602e-04 ,6.5760e-04 ,8.9247e-04 ,1.1052e-03 ,1.3151e-03 , &
     &1.5074e-03 ,1.7081e-03 ,1.7334e-03 /)
      kao(:, 5, 5, 3) = (/ &
     &4.7663e-06 ,4.3568e-04 ,7.0547e-04 ,9.6253e-04 ,1.1901e-03 ,1.4105e-03 , &
     &1.6319e-03 ,1.8559e-03 ,1.9044e-03 /)
      kao(:, 1, 6, 3) = (/ &
     &4.5500e-06 ,3.2085e-04 ,4.8959e-04 ,6.2597e-04 ,7.4855e-04 ,8.4386e-04 , &
     &9.2463e-04 ,9.8196e-04 ,9.3322e-04 /)
      kao(:, 2, 6, 3) = (/ &
     &5.1832e-06 ,3.4894e-04 ,5.2646e-04 ,6.8892e-04 ,8.2642e-04 ,9.4419e-04 , &
     &1.0344e-03 ,1.1120e-03 ,1.0567e-03 /)
      kao(:, 3, 6, 3) = (/ &
     &5.7454e-06 ,3.7624e-04 ,5.6596e-04 ,7.4193e-04 ,8.9866e-04 ,1.0339e-03 , &
     &1.1478e-03 ,1.2434e-03 ,1.1989e-03 /)
      kao(:, 4, 6, 3) = (/ &
     &6.4183e-06 ,4.0049e-04 ,6.1119e-04 ,7.9917e-04 ,9.7241e-04 ,1.1206e-03 , &
     &1.2562e-03 ,1.3721e-03 ,1.3554e-03 /)
      kao(:, 5, 6, 3) = (/ &
     &6.9324e-06 ,4.2668e-04 ,6.6038e-04 ,8.5368e-04 ,1.0486e-03 ,1.2116e-03 , &
     &1.3599e-03 ,1.5001e-03 ,1.5043e-03 /)
      kao(:, 1, 7, 3) = (/ &
     &7.2797e-06 ,3.0677e-04 ,4.8071e-04 ,5.9971e-04 ,6.8742e-04 ,7.5672e-04 , &
     &8.0124e-04 ,8.1058e-04 ,7.0953e-04 /)
      kao(:, 2, 7, 3) = (/ &
     &8.1177e-06 ,3.3920e-04 ,5.2455e-04 ,6.4489e-04 ,7.6436e-04 ,8.4338e-04 , &
     &9.0408e-04 ,9.2147e-04 ,8.0482e-04 /)
      kao(:, 3, 7, 3) = (/ &
     &8.9509e-06 ,3.6425e-04 ,5.6797e-04 ,6.9667e-04 ,8.2046e-04 ,9.2590e-04 , &
     &9.9874e-04 ,1.0317e-03 ,9.2280e-04 /)
      kao(:, 4, 7, 3) = (/ &
     &9.9962e-06 ,3.8975e-04 ,6.1216e-04 ,7.5517e-04 ,8.8215e-04 ,1.0000e-03 , &
     &1.0895e-03 ,1.1382e-03 ,1.0492e-03 /)
      kao(:, 5, 7, 3) = (/ &
     &1.0669e-05 ,4.1752e-04 ,6.5205e-04 ,8.1765e-04 ,9.5018e-04 ,1.0745e-03 , &
     &1.1767e-03 ,1.2498e-03 ,1.1757e-03 /)
      kao(:, 1, 8, 3) = (/ &
     &1.3269e-05 ,3.0208e-04 ,4.8542e-04 ,6.1720e-04 ,7.0751e-04 ,7.5832e-04 , &
     &7.5956e-04 ,7.2658e-04 ,5.2753e-04 /)
      kao(:, 2, 8, 3) = (/ &
     &1.5282e-05 ,3.2807e-04 ,5.3968e-04 ,6.8467e-04 ,7.6733e-04 ,8.2175e-04 , &
     &8.4708e-04 ,8.2655e-04 ,6.1209e-04 /)
      kao(:, 3, 8, 3) = (/ &
     &1.6919e-05 ,3.5455e-04 ,5.8673e-04 ,7.5006e-04 ,8.3417e-04 ,8.8820e-04 , &
     &9.3120e-04 ,9.2583e-04 ,7.0621e-04 /)
      kao(:, 4, 8, 3) = (/ &
     &1.8616e-05 ,3.8664e-04 ,6.2653e-04 ,8.0927e-04 ,9.0712e-04 ,9.6236e-04 , &
     &1.0056e-03 ,1.0184e-03 ,8.0931e-04 /)
      kao(:, 5, 8, 3) = (/ &
     &2.0327e-05 ,4.2321e-04 ,6.7354e-04 ,8.6755e-04 ,9.7906e-04 ,1.0424e-03 , &
     &1.0862e-03 ,1.0982e-03 ,9.1316e-04 /)
      kao(:, 1, 9, 3) = (/ &
     &5.0114e-05 ,4.1653e-04 ,5.9063e-04 ,7.3539e-04 ,8.5123e-04 ,9.2178e-04 , &
     &9.4309e-04 ,8.5391e-04 ,5.1499e-04 /)
      kao(:, 2, 9, 3) = (/ &
     &5.7273e-05 ,4.5656e-04 ,6.4069e-04 ,7.9699e-04 ,9.4296e-04 ,1.0365e-03 , &
     &1.0446e-03 ,9.3220e-04 ,6.0883e-04 /)
      kao(:, 3, 9, 3) = (/ &
     &6.4035e-05 ,4.9861e-04 ,7.0653e-04 ,8.6985e-04 ,1.0116e-03 ,1.1468e-03 , &
     &1.1543e-03 ,1.0092e-03 ,7.0553e-04 /)
      kao(:, 4, 9, 3) = (/ &
     &7.2188e-05 ,5.4617e-04 ,7.8095e-04 ,9.4772e-04 ,1.1003e-03 ,1.2322e-03 , &
     &1.2562e-03 ,1.0988e-03 ,7.9526e-04 /)
      kao(:, 5, 9, 3) = (/ &
     &7.9550e-05 ,6.0184e-04 ,8.5464e-04 ,1.0416e-03 ,1.1956e-03 ,1.3190e-03 , &
     &1.3528e-03 ,1.1984e-03 ,8.7997e-04 /)
      kao(:, 1,10, 3) = (/ &
     &2.3306e-04 ,7.9772e-04 ,9.8566e-04 ,1.1183e-03 ,1.1737e-03 ,1.1902e-03 , &
     &1.1793e-03 ,1.0698e-03 ,6.6407e-04 /)
      kao(:, 2,10, 3) = (/ &
     &2.6771e-04 ,8.8993e-04 ,1.0956e-03 ,1.2259e-03 ,1.2971e-03 ,1.3020e-03 , &
     &1.2785e-03 ,1.2036e-03 ,7.5718e-04 /)
      kao(:, 3,10, 3) = (/ &
     &3.0294e-04 ,9.8041e-04 ,1.2123e-03 ,1.3475e-03 ,1.4168e-03 ,1.4273e-03 , &
     &1.4006e-03 ,1.3282e-03 ,8.5838e-04 /)
      kao(:, 4,10, 3) = (/ &
     &3.4186e-04 ,1.0838e-03 ,1.3329e-03 ,1.4855e-03 ,1.5514e-03 ,1.5775e-03 , &
     &1.5302e-03 ,1.4297e-03 ,9.7732e-04 /)
      kao(:, 5,10, 3) = (/ &
     &3.7940e-04 ,1.2006e-03 ,1.4657e-03 ,1.6333e-03 ,1.7070e-03 ,1.7269e-03 , &
     &1.6832e-03 ,1.5552e-03 ,1.1108e-03 /)
      kao(:, 1,11, 3) = (/ &
     &4.1370e-04 ,1.0481e-03 ,1.2382e-03 ,1.3193e-03 ,1.3405e-03 ,1.3128e-03 , &
     &1.2136e-03 ,1.0530e-03 ,7.9947e-04 /)
      kao(:, 2,11, 3) = (/ &
     &4.6551e-04 ,1.1702e-03 ,1.3813e-03 ,1.4636e-03 ,1.4831e-03 ,1.4472e-03 , &
     &1.3317e-03 ,1.1447e-03 ,9.1716e-04 /)
      kao(:, 3,11, 3) = (/ &
     &5.2337e-04 ,1.3114e-03 ,1.5380e-03 ,1.6111e-03 ,1.6417e-03 ,1.5910e-03 , &
     &1.4641e-03 ,1.2585e-03 ,1.0575e-03 /)
      kao(:, 4,11, 3) = (/ &
     &5.8236e-04 ,1.4612e-03 ,1.6981e-03 ,1.7829e-03 ,1.8015e-03 ,1.7452e-03 , &
     &1.6069e-03 ,1.3761e-03 ,1.2010e-03 /)
      kao(:, 5,11, 3) = (/ &
     &6.7131e-04 ,1.6254e-03 ,1.8811e-03 ,1.9666e-03 ,1.9744e-03 ,1.9137e-03 , &
     &1.7677e-03 ,1.5105e-03 ,1.3428e-03 /)
      kao(:, 1,12, 3) = (/ &
     &5.0548e-04 ,1.1217e-03 ,1.2964e-03 ,1.3785e-03 ,1.3692e-03 ,1.2935e-03 , &
     &1.1705e-03 ,9.6704e-04 ,8.2680e-04 /)
      kao(:, 2,12, 3) = (/ &
     &5.7320e-04 ,1.2560e-03 ,1.4612e-03 ,1.5290e-03 ,1.5133e-03 ,1.4345e-03 , &
     &1.2992e-03 ,1.0595e-03 ,9.5961e-04 /)
      kao(:, 3,12, 3) = (/ &
     &6.3853e-04 ,1.4125e-03 ,1.6378e-03 ,1.6918e-03 ,1.6663e-03 ,1.5909e-03 , &
     &1.4283e-03 ,1.1648e-03 ,1.0789e-03 /)
      kao(:, 4,12, 3) = (/ &
     &7.1367e-04 ,1.5888e-03 ,1.8194e-03 ,1.8745e-03 ,1.8358e-03 ,1.7471e-03 , &
     &1.5691e-03 ,1.2862e-03 ,1.2039e-03 /)
      kao(:, 5,12, 3) = (/ &
     &8.2207e-04 ,1.7742e-03 ,2.0103e-03 ,2.0603e-03 ,2.0193e-03 ,1.9194e-03 , &
     &1.7244e-03 ,1.4199e-03 ,1.3514e-03 /)
      kao(:, 1,13, 3) = (/ &
     &5.0420e-04 ,1.0317e-03 ,1.1965e-03 ,1.2627e-03 ,1.2425e-03 ,1.1623e-03 , &
     &1.0397e-03 ,8.4556e-04 ,7.6156e-04 /)
      kao(:, 2,13, 3) = (/ &
     &5.6808e-04 ,1.1670e-03 ,1.3463e-03 ,1.4009e-03 ,1.3701e-03 ,1.2956e-03 , &
     &1.1567e-03 ,9.3024e-04 ,8.8050e-04 /)
      kao(:, 3,13, 3) = (/ &
     &6.1838e-04 ,1.3214e-03 ,1.5180e-03 ,1.5502e-03 ,1.5020e-03 ,1.4361e-03 , &
     &1.2780e-03 ,1.0272e-03 ,9.9967e-04 /)
      kao(:, 4,13, 3) = (/ &
     &7.0527e-04 ,1.4908e-03 ,1.6794e-03 ,1.7102e-03 ,1.6621e-03 ,1.5793e-03 , &
     &1.4142e-03 ,1.1355e-03 ,1.1267e-03 /)
      kao(:, 5,13, 3) = (/ &
     &8.1247e-04 ,1.6340e-03 ,1.8549e-03 ,1.8870e-03 ,1.8374e-03 ,1.7298e-03 , &
     &1.5606e-03 ,1.2534e-03 ,1.2510e-03 /)
      kao(:, 1, 1, 4) = (/ &
     &7.9349e-07 ,1.0718e-03 ,2.1076e-03 ,3.1773e-03 ,4.3493e-03 ,5.6505e-03 , &
     &7.2449e-03 ,1.0124e-02 ,8.6807e-03 /)
      kao(:, 2, 1, 4) = (/ &
     &7.9171e-07 ,1.1405e-03 ,2.2617e-03 ,3.4209e-03 ,4.6727e-03 ,6.0666e-03 , &
     &7.8396e-03 ,1.0702e-02 ,9.3285e-03 /)
      kao(:, 3, 1, 4) = (/ &
     &8.3534e-07 ,1.2022e-03 ,2.3697e-03 ,3.6079e-03 ,4.9651e-03 ,6.4864e-03 , &
     &8.3654e-03 ,1.1513e-02 ,9.9193e-03 /)
      kao(:, 4, 1, 4) = (/ &
     &9.5267e-07 ,1.2723e-03 ,2.4978e-03 ,3.7943e-03 ,5.1994e-03 ,6.8025e-03 , &
     &8.8715e-03 ,1.2190e-02 ,1.0375e-02 /)
      kao(:, 5, 1, 4) = (/ &
     &1.1458e-06 ,1.3554e-03 ,2.6484e-03 ,4.0109e-03 ,5.4856e-03 ,7.1578e-03 , &
     &9.2726e-03 ,1.2904e-02 ,1.0954e-02 /)
      kao(:, 1, 2, 4) = (/ &
     &9.1454e-07 ,9.0539e-04 ,1.7315e-03 ,2.5817e-03 ,3.4611e-03 ,4.4469e-03 , &
     &5.5705e-03 ,7.4448e-03 ,6.8782e-03 /)
      kao(:, 2, 2, 4) = (/ &
     &9.5187e-07 ,9.6041e-04 ,1.8588e-03 ,2.7755e-03 ,3.7306e-03 ,4.7775e-03 , &
     &6.0319e-03 ,7.9894e-03 ,7.4238e-03 /)
      kao(:, 3, 2, 4) = (/ &
     &1.1150e-06 ,1.0164e-03 ,1.9573e-03 ,2.9264e-03 ,3.9480e-03 ,5.1214e-03 , &
     &6.4611e-03 ,8.5702e-03 ,7.8654e-03 /)
      kao(:, 4, 2, 4) = (/ &
     &1.3385e-06 ,1.0876e-03 ,2.0659e-03 ,3.0814e-03 ,4.1574e-03 ,5.3507e-03 , &
     &6.8052e-03 ,9.1287e-03 ,8.2842e-03 /)
      kao(:, 5, 2, 4) = (/ &
     &1.6022e-06 ,1.1568e-03 ,2.2052e-03 ,3.2703e-03 ,4.4002e-03 ,5.6510e-03 , &
     &7.1684e-03 ,9.6207e-03 ,8.7667e-03 /)
      kao(:, 1, 3, 4) = (/ &
     &1.5574e-06 ,7.6371e-04 ,1.4483e-03 ,2.1006e-03 ,2.7598e-03 ,3.4620e-03 , &
     &4.1959e-03 ,5.2056e-03 ,5.3344e-03 /)
      kao(:, 2, 3, 4) = (/ &
     &1.7591e-06 ,8.1114e-04 ,1.5471e-03 ,2.2761e-03 ,2.9860e-03 ,3.7307e-03 , &
     &4.5489e-03 ,5.7315e-03 ,5.7929e-03 /)
      kao(:, 3, 3, 4) = (/ &
     &2.0958e-06 ,8.7335e-04 ,1.6413e-03 ,2.3988e-03 ,3.1565e-03 ,3.9689e-03 , &
     &4.8920e-03 ,6.1466e-03 ,6.1501e-03 /)
      kao(:, 4, 3, 4) = (/ &
     &2.4948e-06 ,9.3193e-04 ,1.7550e-03 ,2.5427e-03 ,3.3388e-03 ,4.1838e-03 , &
     &5.1384e-03 ,6.5670e-03 ,6.5006e-03 /)
      kao(:, 5, 3, 4) = (/ &
     &2.9808e-06 ,9.8734e-04 ,1.8752e-03 ,2.7256e-03 ,3.5562e-03 ,4.4297e-03 , &
     &5.4345e-03 ,6.8804e-03 ,6.9100e-03 /)
      kao(:, 1, 4, 4) = (/ &
     &2.8339e-06 ,6.5550e-04 ,1.2204e-03 ,1.7505e-03 ,2.2569e-03 ,2.7626e-03 , &
     &3.2755e-03 ,3.8524e-03 ,4.1315e-03 /)
      kao(:, 2, 4, 4) = (/ &
     &3.2988e-06 ,7.0845e-04 ,1.2966e-03 ,1.8754e-03 ,2.4581e-03 ,3.0020e-03 , &
     &3.5639e-03 ,4.2448e-03 ,4.5130e-03 /)
      kao(:, 3, 4, 4) = (/ &
     &3.9491e-06 ,7.6198e-04 ,1.3871e-03 ,1.9942e-03 ,2.6023e-03 ,3.1978e-03 , &
     &3.8488e-03 ,4.5802e-03 ,4.8443e-03 /)
      kao(:, 4, 4, 4) = (/ &
     &4.6425e-06 ,8.1982e-04 ,1.4902e-03 ,2.1380e-03 ,2.7710e-03 ,3.3974e-03 , &
     &4.0487e-03 ,4.8659e-03 ,5.1413e-03 /)
      kao(:, 5, 4, 4) = (/ &
     &5.6265e-06 ,8.8017e-04 ,1.5882e-03 ,2.2893e-03 ,2.9763e-03 ,3.6352e-03 , &
     &4.2916e-03 ,5.1439e-03 ,5.4622e-03 /)
      kao(:, 1, 5, 4) = (/ &
     &4.8447e-06 ,5.8594e-04 ,1.0296e-03 ,1.4656e-03 ,1.8696e-03 ,2.2619e-03 , &
     &2.6388e-03 ,3.0084e-03 ,3.1950e-03 /)
      kao(:, 2, 5, 4) = (/ &
     &5.5680e-06 ,6.3350e-04 ,1.1054e-03 ,1.5640e-03 ,2.0148e-03 ,2.4702e-03 , &
     &2.8772e-03 ,3.3130e-03 ,3.5193e-03 /)
      kao(:, 3, 5, 4) = (/ &
     &6.5723e-06 ,6.8615e-04 ,1.1977e-03 ,1.6753e-03 ,2.1497e-03 ,2.6254e-03 , &
     &3.0969e-03 ,3.5912e-03 ,3.8422e-03 /)
      kao(:, 4, 5, 4) = (/ &
     &7.8530e-06 ,7.4277e-04 ,1.2884e-03 ,1.8101e-03 ,2.3101e-03 ,2.7992e-03 , &
     &3.2952e-03 ,3.8151e-03 ,4.0689e-03 /)
      kao(:, 5, 5, 4) = (/ &
     &9.4527e-06 ,8.0105e-04 ,1.3871e-03 ,1.9371e-03 ,2.4908e-03 ,3.0121e-03 , &
     &3.5288e-03 ,4.0532e-03 ,4.3486e-03 /)
      kao(:, 1, 6, 4) = (/ &
     &7.9687e-06 ,5.4507e-04 ,8.9513e-04 ,1.2382e-03 ,1.5589e-03 ,1.8510e-03 , &
     &2.1398e-03 ,2.3860e-03 ,2.4635e-03 /)
      kao(:, 2, 6, 4) = (/ &
     &8.8712e-06 ,5.9098e-04 ,9.7039e-04 ,1.3235e-03 ,1.6755e-03 ,2.0285e-03 , &
     &2.3501e-03 ,2.6411e-03 ,2.7555e-03 /)
      kao(:, 3, 6, 4) = (/ &
     &1.0300e-05 ,6.3947e-04 ,1.0497e-03 ,1.4366e-03 ,1.7944e-03 ,2.1608e-03 , &
     &2.5184e-03 ,2.8809e-03 ,3.0211e-03 /)
      kao(:, 4, 6, 4) = (/ &
     &1.2171e-05 ,6.9277e-04 ,1.1370e-03 ,1.5510e-03 ,1.9450e-03 ,2.3217e-03 , &
     &2.6890e-03 ,3.0692e-03 ,3.2284e-03 /)
      kao(:, 5, 6, 4) = (/ &
     &1.4564e-05 ,7.4600e-04 ,1.2318e-03 ,1.6801e-03 ,2.0948e-03 ,2.5115e-03 , &
     &2.8923e-03 ,3.2756e-03 ,3.4483e-03 /)
      kao(:, 1, 7, 4) = (/ &
     &1.3302e-05 ,5.5386e-04 ,8.3382e-04 ,1.0993e-03 ,1.3564e-03 ,1.5663e-03 , &
     &1.7522e-03 ,1.9212e-03 ,1.8928e-03 /)
      kao(:, 2, 7, 4) = (/ &
     &1.5137e-05 ,6.0362e-04 ,9.0303e-04 ,1.1816e-03 ,1.4350e-03 ,1.6949e-03 , &
     &1.9391e-03 ,2.1345e-03 ,2.1400e-03 /)
      kao(:, 3, 7, 4) = (/ &
     &1.7393e-05 ,6.5556e-04 ,9.7760e-04 ,1.2752e-03 ,1.5638e-03 ,1.8142e-03 , &
     &2.0760e-03 ,2.3419e-03 ,2.3618e-03 /)
      kao(:, 4, 7, 4) = (/ &
     &2.0190e-05 ,7.0877e-04 ,1.0583e-03 ,1.3832e-03 ,1.6934e-03 ,1.9720e-03 , &
     &2.2273e-03 ,2.4896e-03 ,2.5682e-03 /)
      kao(:, 5, 7, 4) = (/ &
     &2.3865e-05 ,7.6246e-04 ,1.1476e-03 ,1.5003e-03 ,1.8325e-03 ,2.1363e-03 , &
     &2.4216e-03 ,2.6647e-03 ,2.7377e-03 /)
      kao(:, 1, 8, 4) = (/ &
     &2.8723e-05 ,5.8785e-04 ,8.8654e-04 ,1.0769e-03 ,1.2579e-03 ,1.4310e-03 , &
     &1.5394e-03 ,1.5987e-03 ,1.4479e-03 /)
      kao(:, 2, 8, 4) = (/ &
     &3.1951e-05 ,6.5934e-04 ,9.7493e-04 ,1.1672e-03 ,1.3594e-03 ,1.5243e-03 , &
     &1.6749e-03 ,1.7779e-03 ,1.6535e-03 /)
      kao(:, 3, 8, 4) = (/ &
     &3.6028e-05 ,7.3349e-04 ,1.0597e-03 ,1.2704e-03 ,1.4675e-03 ,1.6499e-03 , &
     &1.7965e-03 ,1.9280e-03 ,1.8443e-03 /)
      kao(:, 4, 8, 4) = (/ &
     &4.1972e-05 ,7.9901e-04 ,1.1534e-03 ,1.3845e-03 ,1.5898e-03 ,1.7819e-03 , &
     &1.9610e-03 ,2.0652e-03 ,2.0278e-03 /)
      kao(:, 5, 8, 4) = (/ &
     &4.8818e-05 ,8.6068e-04 ,1.2469e-03 ,1.5029e-03 ,1.7252e-03 ,1.9359e-03 , &
     &2.1153e-03 ,2.2493e-03 ,2.1613e-03 /)
      kao(:, 1, 9, 4) = (/ &
     &1.2151e-04 ,7.9394e-04 ,1.1551e-03 ,1.4165e-03 ,1.6142e-03 ,1.6912e-03 , &
     &1.6602e-03 ,1.6194e-03 ,1.1991e-03 /)
      kao(:, 2, 9, 4) = (/ &
     &1.3408e-04 ,8.8305e-04 ,1.2970e-03 ,1.6023e-03 ,1.7938e-03 ,1.8665e-03 , &
     &1.8031e-03 ,1.7264e-03 ,1.3714e-03 /)
      kao(:, 3, 9, 4) = (/ &
     &1.5040e-04 ,9.7901e-04 ,1.4287e-03 ,1.7867e-03 ,2.0033e-03 ,2.0339e-03 , &
     &1.9620e-03 ,1.8611e-03 ,1.5284e-03 /)
      kao(:, 4, 9, 4) = (/ &
     &1.6901e-04 ,1.0844e-03 ,1.5638e-03 ,1.9651e-03 ,2.1812e-03 ,2.2146e-03 , &
     &2.1459e-03 ,2.0086e-03 ,1.6589e-03 /)
      kao(:, 5, 9, 4) = (/ &
     &1.9165e-04 ,1.1941e-03 ,1.7106e-03 ,2.1260e-03 ,2.3624e-03 ,2.4142e-03 , &
     &2.3405e-03 ,2.1792e-03 ,1.8085e-03 /)
      kao(:, 1,10, 4) = (/ &
     &5.9868e-04 ,1.5993e-03 ,1.9364e-03 ,2.1129e-03 ,2.2524e-03 ,2.3246e-03 , &
     &2.2594e-03 ,2.0146e-03 ,1.3568e-03 /)
      kao(:, 2,10, 4) = (/ &
     &6.6752e-04 ,1.7567e-03 ,2.1277e-03 ,2.3435e-03 ,2.4977e-03 ,2.6109e-03 , &
     &2.5681e-03 ,2.2608e-03 ,1.5177e-03 /)
      kao(:, 3,10, 4) = (/ &
     &7.4901e-04 ,1.9228e-03 ,2.3324e-03 ,2.5957e-03 ,2.7706e-03 ,2.8949e-03 , &
     &2.8715e-03 ,2.4740e-03 ,1.6681e-03 /)
      kao(:, 4,10, 4) = (/ &
     &8.4268e-04 ,2.1035e-03 ,2.5651e-03 ,2.8675e-03 ,3.0553e-03 ,3.1760e-03 , &
     &3.1745e-03 ,2.7207e-03 ,1.8575e-03 /)
      kao(:, 5,10, 4) = (/ &
     &9.4245e-04 ,2.2879e-03 ,2.8080e-03 ,3.1494e-03 ,3.3540e-03 ,3.4813e-03 , &
     &3.4487e-03 ,2.9536e-03 ,2.0691e-03 /)
      kao(:, 1,11, 4) = (/ &
     &1.0805e-03 ,2.1148e-03 ,2.4220e-03 ,2.5310e-03 ,2.5389e-03 ,2.4625e-03 , &
     &2.3509e-03 ,2.0401e-03 ,1.4417e-03 /)
      kao(:, 2,11, 4) = (/ &
     &1.2248e-03 ,2.3043e-03 ,2.6421e-03 ,2.7805e-03 ,2.8051e-03 ,2.7290e-03 , &
     &2.6298e-03 ,2.3094e-03 ,1.6718e-03 /)
      kao(:, 3,11, 4) = (/ &
     &1.3919e-03 ,2.5018e-03 ,2.8694e-03 ,3.0522e-03 ,3.0921e-03 ,3.0140e-03 , &
     &2.9024e-03 ,2.5763e-03 ,1.8644e-03 /)
      kao(:, 4,11, 4) = (/ &
     &1.5591e-03 ,2.7193e-03 ,3.1319e-03 ,3.3417e-03 ,3.3992e-03 ,3.3292e-03 , &
     &3.1865e-03 ,2.8388e-03 ,2.0955e-03 /)
      kao(:, 5,11, 4) = (/ &
     &1.7150e-03 ,2.9473e-03 ,3.3980e-03 ,3.6551e-03 ,3.7158e-03 ,3.6708e-03 , &
     &3.4907e-03 ,3.0872e-03 ,2.3494e-03 /)
      kao(:, 1,12, 4) = (/ &
     &1.3897e-03 ,2.3284e-03 ,2.5562e-03 ,2.6114e-03 ,2.5756e-03 ,2.4579e-03 , &
     &2.2328e-03 ,1.8907e-03 ,1.4460e-03 /)
      kao(:, 2,12, 4) = (/ &
     &1.5697e-03 ,2.5462e-03 ,2.7773e-03 ,2.8739e-03 ,2.8515e-03 ,2.7127e-03 , &
     &2.4702e-03 ,2.1317e-03 ,1.6710e-03 /)
      kao(:, 3,12, 4) = (/ &
     &1.7564e-03 ,2.7736e-03 ,3.0368e-03 ,3.1575e-03 ,3.1336e-03 ,2.9932e-03 , &
     &2.7316e-03 ,2.3689e-03 ,1.9165e-03 /)
      kao(:, 4,12, 4) = (/ &
     &1.9373e-03 ,3.0028e-03 ,3.3026e-03 ,3.4473e-03 ,3.4197e-03 ,3.2885e-03 , &
     &3.0105e-03 ,2.5975e-03 ,2.1734e-03 /)
      kao(:, 5,12, 4) = (/ &
     &2.1103e-03 ,3.2861e-03 ,3.6126e-03 ,3.7579e-03 ,3.7472e-03 ,3.5983e-03 , &
     &3.3137e-03 ,2.8243e-03 ,2.4241e-03 /)
      kao(:, 1,13, 4) = (/ &
     &1.4034e-03 ,2.2073e-03 ,2.3423e-03 ,2.3940e-03 ,2.3352e-03 ,2.2289e-03 , &
     &1.9861e-03 ,1.6453e-03 ,1.3641e-03 /)
      kao(:, 2,13, 4) = (/ &
     &1.5468e-03 ,2.3993e-03 ,2.5715e-03 ,2.6353e-03 ,2.5905e-03 ,2.4689e-03 , &
     &2.2035e-03 ,1.8516e-03 ,1.5595e-03 /)
      kao(:, 3,13, 4) = (/ &
     &1.7054e-03 ,2.6002e-03 ,2.8041e-03 ,2.9001e-03 ,2.8726e-03 ,2.7020e-03 , &
     &2.4437e-03 ,2.0505e-03 ,1.7798e-03 /)
      kao(:, 4,13, 4) = (/ &
     &1.8746e-03 ,2.8344e-03 ,3.0758e-03 ,3.1886e-03 ,3.1543e-03 ,2.9591e-03 , &
     &2.7010e-03 ,2.2473e-03 ,2.0185e-03 /)
      kao(:, 5,13, 4) = (/ &
     &2.0493e-03 ,3.1290e-03 ,3.3711e-03 ,3.5047e-03 ,3.4626e-03 ,3.2529e-03 , &
     &2.9617e-03 ,2.4466e-03 ,2.2855e-03 /)
      kao(:, 1, 1, 5) = (/ &
     &2.7288e-06 ,2.0772e-03 ,4.1339e-03 ,6.3040e-03 ,8.6169e-03 ,1.1216e-02 , &
     &1.4425e-02 ,1.9774e-02 ,1.7219e-02 /)
      kao(:, 2, 1, 5) = (/ &
     &3.1343e-06 ,2.2547e-03 ,4.4747e-03 ,6.8269e-03 ,9.3305e-03 ,1.2134e-02 , &
     &1.5662e-02 ,2.1511e-02 ,1.8646e-02 /)
      kao(:, 3, 1, 5) = (/ &
     &3.5230e-06 ,2.4421e-03 ,4.8659e-03 ,7.3919e-03 ,1.0064e-02 ,1.3080e-02 , &
     &1.6864e-02 ,2.3200e-02 ,2.0105e-02 /)
      kao(:, 4, 1, 5) = (/ &
     &3.8970e-06 ,2.6162e-03 ,5.2335e-03 ,7.9722e-03 ,1.0895e-02 ,1.4129e-02 , &
     &1.8093e-02 ,2.4994e-02 ,2.1780e-02 /)
      kao(:, 5, 1, 5) = (/ &
     &4.2153e-06 ,2.7842e-03 ,5.5880e-03 ,8.5221e-03 ,1.1648e-02 ,1.5136e-02 , &
     &1.9474e-02 ,2.6742e-02 ,2.3280e-02 /)
      kao(:, 1, 2, 5) = (/ &
     &3.8170e-06 ,1.7299e-03 ,3.3770e-03 ,5.0561e-03 ,6.8488e-03 ,8.8137e-03 , &
     &1.1142e-02 ,1.4709e-02 ,1.3674e-02 /)
      kao(:, 2, 2, 5) = (/ &
     &4.3252e-06 ,1.8890e-03 ,3.6509e-03 ,5.4769e-03 ,7.4269e-03 ,9.5439e-03 , &
     &1.2081e-02 ,1.6033e-02 ,1.4831e-02 /)
      kao(:, 3, 2, 5) = (/ &
     &4.7646e-06 ,2.0435e-03 ,3.9774e-03 ,5.9664e-03 ,8.0622e-03 ,1.0295e-02 , &
     &1.3026e-02 ,1.7373e-02 ,1.6093e-02 /)
      kao(:, 4, 2, 5) = (/ &
     &5.2162e-06 ,2.1898e-03 ,4.2814e-03 ,6.4462e-03 ,8.7251e-03 ,1.1197e-02 , &
     &1.4093e-02 ,1.8642e-02 ,1.7418e-02 /)
      kao(:, 5, 2, 5) = (/ &
     &5.6571e-06 ,2.3346e-03 ,4.5674e-03 ,6.8936e-03 ,9.3452e-03 ,1.2004e-02 , &
     &1.5146e-02 ,2.0072e-02 ,1.8662e-02 /)
      kao(:, 1, 3, 5) = (/ &
     &6.7841e-06 ,1.4874e-03 ,2.7805e-03 ,4.0760e-03 ,5.3909e-03 ,6.7517e-03 , &
     &8.3542e-03 ,1.0487e-02 ,1.0633e-02 /)
      kao(:, 2, 3, 5) = (/ &
     &7.5652e-06 ,1.6242e-03 ,3.0372e-03 ,4.4125e-03 ,5.8428e-03 ,7.3572e-03 , &
     &9.0599e-03 ,1.1418e-02 ,1.1564e-02 /)
      kao(:, 3, 3, 5) = (/ &
     &8.3338e-06 ,1.7491e-03 ,3.3027e-03 ,4.8269e-03 ,6.3750e-03 ,7.9902e-03 , &
     &9.8070e-03 ,1.2345e-02 ,1.2611e-02 /)
      kao(:, 4, 3, 5) = (/ &
     &9.1322e-06 ,1.8750e-03 ,3.5479e-03 ,5.2057e-03 ,6.8969e-03 ,8.6842e-03 , &
     &1.0693e-02 ,1.3305e-02 ,1.3678e-02 /)
      kao(:, 5, 3, 5) = (/ &
     &9.9531e-06 ,2.0097e-03 ,3.7981e-03 ,5.5735e-03 ,7.4004e-03 ,9.3447e-03 , &
     &1.1509e-02 ,1.4423e-02 ,1.4706e-02 /)
      kao(:, 1, 4, 5) = (/ &
     &1.2103e-05 ,1.3043e-03 ,2.3537e-03 ,3.3772e-03 ,4.3942e-03 ,5.3862e-03 , &
     &6.4402e-03 ,7.7504e-03 ,8.3034e-03 /)
      kao(:, 2, 4, 5) = (/ &
     &1.3453e-05 ,1.4203e-03 ,2.5925e-03 ,3.7016e-03 ,4.7682e-03 ,5.8654e-03 , &
     &7.0102e-03 ,8.4347e-03 ,9.0709e-03 /)
      kao(:, 3, 4, 5) = (/ &
     &1.4828e-05 ,1.5367e-03 ,2.8071e-03 ,4.0356e-03 ,5.2345e-03 ,6.4096e-03 , &
     &7.5937e-03 ,9.1611e-03 ,9.8978e-03 /)
      kao(:, 4, 4, 5) = (/ &
     &1.6265e-05 ,1.6502e-03 ,3.0181e-03 ,4.3485e-03 ,5.6510e-03 ,6.9455e-03 , &
     &8.2885e-03 ,9.9540e-03 ,1.0767e-02 /)
      kao(:, 5, 4, 5) = (/ &
     &1.7755e-05 ,1.7615e-03 ,3.2390e-03 ,4.6692e-03 ,6.0695e-03 ,7.4667e-03 , &
     &8.9542e-03 ,1.0781e-02 ,1.1635e-02 /)
      kao(:, 1, 5, 5) = (/ &
     &2.0332e-05 ,1.1698e-03 ,2.0394e-03 ,2.8422e-03 ,3.6398e-03 ,4.4106e-03 , &
     &5.1682e-03 ,5.9629e-03 ,6.5029e-03 /)
      kao(:, 2, 5, 5) = (/ &
     &2.2530e-05 ,1.2736e-03 ,2.2339e-03 ,3.1431e-03 ,3.9975e-03 ,4.8072e-03 , &
     &5.6451e-03 ,6.5119e-03 ,7.1285e-03 /)
      kao(:, 3, 5, 5) = (/ &
     &2.4796e-05 ,1.3790e-03 ,2.4265e-03 ,3.4174e-03 ,4.3749e-03 ,5.2936e-03 , &
     &6.1677e-03 ,7.0807e-03 ,7.7613e-03 /)
      kao(:, 4, 5, 5) = (/ &
     &2.7075e-05 ,1.4796e-03 ,2.6222e-03 ,3.6840e-03 ,4.7300e-03 ,5.7397e-03 , &
     &6.7237e-03 ,7.7301e-03 ,8.5090e-03 /)
      kao(:, 5, 5, 5) = (/ &
     &2.9544e-05 ,1.5786e-03 ,2.8146e-03 ,3.9658e-03 ,5.0797e-03 ,6.1834e-03 , &
     &7.2517e-03 ,8.3791e-03 ,9.2155e-03 /)
      kao(:, 1, 6, 5) = (/ &
     &3.1599e-05 ,1.0623e-03 ,1.7784e-03 ,2.4227e-03 ,3.0276e-03 ,3.6296e-03 , &
     &4.1838e-03 ,4.7343e-03 ,5.0477e-03 /)
      kao(:, 2, 6, 5) = (/ &
     &3.5232e-05 ,1.1598e-03 ,1.9531e-03 ,2.6761e-03 ,3.3625e-03 ,3.9768e-03 , &
     &4.5866e-03 ,5.2016e-03 ,5.5671e-03 /)
      kao(:, 3, 6, 5) = (/ &
     &3.8902e-05 ,1.2546e-03 ,2.1314e-03 ,2.9272e-03 ,3.6836e-03 ,4.3880e-03 , &
     &5.0585e-03 ,5.6644e-03 ,6.0941e-03 /)
      kao(:, 4, 6, 5) = (/ &
     &4.2647e-05 ,1.3467e-03 ,2.3051e-03 ,3.1735e-03 ,3.9922e-03 ,4.7680e-03 , &
     &5.5151e-03 ,6.2191e-03 ,6.7036e-03 /)
      kao(:, 5, 6, 5) = (/ &
     &4.6653e-05 ,1.4422e-03 ,2.4729e-03 ,3.4216e-03 ,4.3101e-03 ,5.1401e-03 , &
     &5.9675e-03 ,6.7430e-03 ,7.2989e-03 /)
      kao(:, 1, 7, 5) = (/ &
     &5.0846e-05 ,1.0315e-03 ,1.6111e-03 ,2.1236e-03 ,2.5799e-03 ,3.0310e-03 , &
     &3.4624e-03 ,3.8172e-03 ,3.8938e-03 /)
      kao(:, 2, 7, 5) = (/ &
     &5.6601e-05 ,1.1149e-03 ,1.7798e-03 ,2.3658e-03 ,2.8898e-03 ,3.3716e-03 , &
     &3.7952e-03 ,4.1967e-03 ,4.3621e-03 /)
      kao(:, 3, 7, 5) = (/ &
     &6.2823e-05 ,1.2046e-03 ,1.9431e-03 ,2.5998e-03 ,3.1765e-03 ,3.7177e-03 , &
     &4.2137e-03 ,4.5955e-03 ,4.7978e-03 /)
      kao(:, 4, 7, 5) = (/ &
     &6.9611e-05 ,1.2957e-03 ,2.0957e-03 ,2.8201e-03 ,3.4636e-03 ,4.0605e-03 , &
     &4.6007e-03 ,5.0741e-03 ,5.2639e-03 /)
      kao(:, 5, 7, 5) = (/ &
     &7.6939e-05 ,1.3859e-03 ,2.2478e-03 ,3.0375e-03 ,3.7523e-03 ,4.4027e-03 , &
     &4.9784e-03 ,5.5148e-03 ,5.7724e-03 /)
      kao(:, 1, 8, 5) = (/ &
     &9.6301e-05 ,1.1719e-03 ,1.6543e-03 ,2.0770e-03 ,2.3972e-03 ,2.6733e-03 , &
     &2.9412e-03 ,3.1694e-03 ,3.0111e-03 /)
      kao(:, 2, 8, 5) = (/ &
     &1.0686e-04 ,1.2764e-03 ,1.7930e-03 ,2.2808e-03 ,2.6778e-03 ,3.0239e-03 , &
     &3.3001e-03 ,3.5015e-03 ,3.3999e-03 /)
      kao(:, 3, 8, 5) = (/ &
     &1.1947e-04 ,1.3739e-03 ,1.9473e-03 ,2.4712e-03 ,2.9582e-03 ,3.3516e-03 , &
     &3.6623e-03 ,3.8834e-03 ,3.7468e-03 /)
      kao(:, 4, 8, 5) = (/ &
     &1.3232e-04 ,1.4765e-03 ,2.1012e-03 ,2.6685e-03 ,3.2209e-03 ,3.6672e-03 , &
     &4.0113e-03 ,4.2720e-03 ,4.1080e-03 /)
      kao(:, 5, 8, 5) = (/ &
     &1.4706e-04 ,1.5789e-03 ,2.2554e-03 ,2.8711e-03 ,3.4655e-03 ,3.9725e-03 , &
     &4.3795e-03 ,4.6534e-03 ,4.5441e-03 /)
      kao(:, 1, 9, 5) = (/ &
     &3.5361e-04 ,1.7799e-03 ,2.5051e-03 ,2.9026e-03 ,3.0684e-03 ,3.1720e-03 , &
     &3.1736e-03 ,2.9481e-03 ,2.3479e-03 /)
      kao(:, 2, 9, 5) = (/ &
     &3.8911e-04 ,1.9917e-03 ,2.7818e-03 ,3.1870e-03 ,3.3554e-03 ,3.4634e-03 , &
     &3.5258e-03 ,3.3674e-03 ,2.6687e-03 /)
      kao(:, 3, 9, 5) = (/ &
     &4.2895e-04 ,2.2031e-03 ,3.0511e-03 ,3.4571e-03 ,3.6423e-03 ,3.7656e-03 , &
     &3.8544e-03 ,3.7669e-03 ,2.9800e-03 /)
      kao(:, 4, 9, 5) = (/ &
     &4.7521e-04 ,2.4131e-03 ,3.3032e-03 ,3.7275e-03 ,3.9589e-03 ,4.0895e-03 , &
     &4.1693e-03 ,4.1455e-03 ,3.3334e-03 /)
      kao(:, 5, 9, 5) = (/ &
     &5.2696e-04 ,2.6212e-03 ,3.5469e-03 ,4.0100e-03 ,4.2674e-03 ,4.4062e-03 , &
     &4.4862e-03 ,4.5098e-03 ,3.6774e-03 /)
      kao(:, 1,10, 5) = (/ &
     &1.5564e-03 ,3.2260e-03 ,4.0223e-03 ,4.5990e-03 ,4.8864e-03 ,4.9553e-03 , &
     &4.6372e-03 ,3.8115e-03 ,2.4163e-03 /)
      kao(:, 2,10, 5) = (/ &
     &1.6655e-03 ,3.5530e-03 ,4.4984e-03 ,5.1615e-03 ,5.5140e-03 ,5.5636e-03 , &
     &5.1458e-03 ,4.1627e-03 ,2.8169e-03 /)
      kao(:, 3,10, 5) = (/ &
     &1.7970e-03 ,3.9283e-03 ,4.9975e-03 ,5.7194e-03 ,6.1431e-03 ,6.1500e-03 , &
     &5.6336e-03 ,4.5688e-03 ,3.2157e-03 /)
      kao(:, 4,10, 5) = (/ &
     &1.9389e-03 ,4.3419e-03 ,5.5082e-03 ,6.3036e-03 ,6.7602e-03 ,6.7061e-03 , &
     &6.1219e-03 ,4.9831e-03 ,3.5478e-03 /)
      kao(:, 5,10, 5) = (/ &
     &2.1200e-03 ,4.8101e-03 ,6.0597e-03 ,6.9046e-03 ,7.3538e-03 ,7.2522e-03 , &
     &6.6229e-03 ,5.4082e-03 ,3.8617e-03 /)
      kao(:, 1,11, 5) = (/ &
     &2.5844e-03 ,4.2072e-03 ,4.7201e-03 ,5.1141e-03 ,5.3078e-03 ,5.2931e-03 , &
     &4.9397e-03 ,3.9983e-03 ,2.6464e-03 /)
      kao(:, 2,11, 5) = (/ &
     &2.7239e-03 ,4.5852e-03 ,5.1921e-03 ,5.6631e-03 ,5.9270e-03 ,5.9381e-03 , &
     &5.5459e-03 ,4.4351e-03 ,2.9283e-03 /)
      kao(:, 3,11, 5) = (/ &
     &2.8937e-03 ,4.9994e-03 ,5.7378e-03 ,6.2452e-03 ,6.5647e-03 ,6.5969e-03 , &
     &6.1297e-03 ,4.8694e-03 ,3.2879e-03 /)
      kao(:, 4,11, 5) = (/ &
     &3.0973e-03 ,5.4803e-03 ,6.2977e-03 ,6.8750e-03 ,7.2241e-03 ,7.2627e-03 , &
     &6.7036e-03 ,5.3184e-03 ,3.6746e-03 /)
      kao(:, 5,11, 5) = (/ &
     &3.3444e-03 ,6.0139e-03 ,6.9682e-03 ,7.5496e-03 ,7.9438e-03 ,7.9183e-03 , &
     &7.2786e-03 ,5.7800e-03 ,4.1120e-03 /)
      kao(:, 1,12, 5) = (/ &
     &3.1142e-03 ,4.6509e-03 ,5.0639e-03 ,5.2099e-03 ,5.2596e-03 ,5.1306e-03 , &
     &4.7167e-03 ,3.8189e-03 ,2.7150e-03 /)
      kao(:, 2,12, 5) = (/ &
     &3.2756e-03 ,5.0359e-03 ,5.5390e-03 ,5.7321e-03 ,5.8154e-03 ,5.7214e-03 , &
     &5.2745e-03 ,4.2400e-03 ,3.0513e-03 /)
      kao(:, 3,12, 5) = (/ &
     &3.4985e-03 ,5.4685e-03 ,6.0590e-03 ,6.2917e-03 ,6.4404e-03 ,6.3170e-03 , &
     &5.8354e-03 ,4.6512e-03 ,3.3763e-03 /)
      kao(:, 4,12, 5) = (/ &
     &3.7766e-03 ,5.9630e-03 ,6.6546e-03 ,6.9419e-03 ,7.0961e-03 ,6.9336e-03 , &
     &6.4037e-03 ,5.0749e-03 ,3.7160e-03 /)
      kao(:, 5,12, 5) = (/ &
     &4.1085e-03 ,6.5232e-03 ,7.2797e-03 ,7.6482e-03 ,7.7587e-03 ,7.5770e-03 , &
     &6.9583e-03 ,5.5150e-03 ,4.0847e-03 /)
      kao(:, 1,13, 5) = (/ &
     &2.9969e-03 ,4.3888e-03 ,4.7684e-03 ,4.8307e-03 ,4.7938e-03 ,4.5847e-03 , &
     &4.1916e-03 ,3.3359e-03 ,2.6072e-03 /)
      kao(:, 2,13, 5) = (/ &
     &3.2153e-03 ,4.7897e-03 ,5.2331e-03 ,5.3333e-03 ,5.2913e-03 ,5.1054e-03 , &
     &4.6633e-03 ,3.6830e-03 ,2.9306e-03 /)
      kao(:, 3,13, 5) = (/ &
     &3.4754e-03 ,5.2096e-03 ,5.7373e-03 ,5.8606e-03 ,5.8296e-03 ,5.6492e-03 , &
     &5.1331e-03 ,4.0274e-03 ,3.2891e-03 /)
      kao(:, 4,13, 5) = (/ &
     &3.7596e-03 ,5.6812e-03 ,6.2772e-03 ,6.4413e-03 ,6.4105e-03 ,6.2095e-03 , &
     &5.6055e-03 ,4.3924e-03 ,3.6856e-03 /)
      kao(:, 5,13, 5) = (/ &
     &4.1250e-03 ,6.2069e-03 ,6.8482e-03 ,7.0531e-03 ,7.0243e-03 ,6.7656e-03 , &
     &6.0849e-03 ,4.7766e-03 ,4.1519e-03 /)
      kao(:, 1, 1, 6) = (/ &
     &8.6000e-06 ,4.4651e-03 ,9.0097e-03 ,1.3704e-02 ,1.8645e-02 ,2.4046e-02 , &
     &3.0633e-02 ,4.1152e-02 ,3.7281e-02 /)
      kao(:, 2, 1, 6) = (/ &
     &9.1677e-06 ,4.8343e-03 ,9.7595e-03 ,1.4853e-02 ,2.0235e-02 ,2.6158e-02 , &
     &3.3249e-02 ,4.4739e-02 ,4.0461e-02 /)
      kao(:, 3, 1, 6) = (/ &
     &9.7617e-06 ,5.2064e-03 ,1.0520e-02 ,1.6024e-02 ,2.1831e-02 ,2.8229e-02 , &
     &3.6006e-02 ,4.8415e-02 ,4.3651e-02 /)
      kao(:, 4, 1, 6) = (/ &
     &1.0395e-05 ,5.5866e-03 ,1.1290e-02 ,1.7191e-02 ,2.3426e-02 ,3.0307e-02 , &
     &3.8717e-02 ,5.2240e-02 ,4.6842e-02 /)
      kao(:, 5, 1, 6) = (/ &
     &1.1075e-05 ,5.9593e-03 ,1.2050e-02 ,1.8360e-02 ,2.5043e-02 ,3.2426e-02 , &
     &4.1434e-02 ,5.5912e-02 ,5.0074e-02 /)
      kao(:, 1, 2, 6) = (/ &
     &1.1648e-05 ,3.7355e-03 ,7.3892e-03 ,1.1190e-02 ,1.5132e-02 ,1.9317e-02 , &
     &2.4213e-02 ,3.1544e-02 ,3.0250e-02 /)
      kao(:, 2, 2, 6) = (/ &
     &1.2445e-05 ,4.0410e-03 ,8.0302e-03 ,1.2160e-02 ,1.6448e-02 ,2.1055e-02 , &
     &2.6369e-02 ,3.4311e-02 ,3.2880e-02 /)
      kao(:, 3, 2, 6) = (/ &
     &1.3310e-05 ,4.3542e-03 ,8.6703e-03 ,1.3133e-02 ,1.7778e-02 ,2.2773e-02 , &
     &2.8564e-02 ,3.7228e-02 ,3.5538e-02 /)
      kao(:, 4, 2, 6) = (/ &
     &1.4232e-05 ,4.6616e-03 ,9.3074e-03 ,1.4103e-02 ,1.9095e-02 ,2.4467e-02 , &
     &3.0730e-02 ,4.0202e-02 ,3.8172e-02 /)
      kao(:, 5, 2, 6) = (/ &
     &1.5231e-05 ,4.9691e-03 ,9.9386e-03 ,1.5066e-02 ,2.0413e-02 ,2.6167e-02 , &
     &3.2915e-02 ,4.3077e-02 ,4.0807e-02 /)
      kao(:, 1, 3, 6) = (/ &
     &2.0796e-05 ,3.1636e-03 ,6.0427e-03 ,8.9479e-03 ,1.1951e-02 ,1.5111e-02 , &
     &1.8532e-02 ,2.3072e-02 ,2.3870e-02 /)
      kao(:, 2, 3, 6) = (/ &
     &2.2285e-05 ,3.4357e-03 ,6.5684e-03 ,9.7449e-03 ,1.3046e-02 ,1.6505e-02 , &
     &2.0281e-02 ,2.5200e-02 ,2.6059e-02 /)
      kao(:, 3, 3, 6) = (/ &
     &2.3921e-05 ,3.7148e-03 ,7.1066e-03 ,1.0556e-02 ,1.4151e-02 ,1.7911e-02 , &
     &2.2018e-02 ,2.7457e-02 ,2.8268e-02 /)
      kao(:, 4, 3, 6) = (/ &
     &2.5678e-05 ,3.9815e-03 ,7.6234e-03 ,1.1355e-02 ,1.5233e-02 ,1.9276e-02 , &
     &2.3703e-02 ,2.9635e-02 ,3.0431e-02 /)
      kao(:, 5, 3, 6) = (/ &
     &2.7604e-05 ,4.2441e-03 ,8.1373e-03 ,1.2146e-02 ,1.6312e-02 ,2.0656e-02 , &
     &2.5417e-02 ,3.1780e-02 ,3.2590e-02 /)
      kao(:, 1, 4, 6) = (/ &
     &3.7548e-05 ,2.7525e-03 ,5.0829e-03 ,7.3519e-03 ,9.5921e-03 ,1.1880e-02 , &
     &1.4330e-02 ,1.7270e-02 ,1.8770e-02 /)
      kao(:, 2, 4, 6) = (/ &
     &4.0479e-05 ,3.0018e-03 ,5.5477e-03 ,8.0335e-03 ,1.0500e-02 ,1.3017e-02 , &
     &1.5741e-02 ,1.8989e-02 ,2.0592e-02 /)
      kao(:, 3, 4, 6) = (/ &
     &4.3632e-05 ,3.2358e-03 ,6.0288e-03 ,8.7218e-03 ,1.1388e-02 ,1.4152e-02 , &
     &1.7154e-02 ,2.0724e-02 ,2.2417e-02 /)
      kao(:, 4, 4, 6) = (/ &
     &4.6956e-05 ,3.4641e-03 ,6.4839e-03 ,9.3953e-03 ,1.2286e-02 ,1.5294e-02 , &
     &1.8543e-02 ,2.2416e-02 ,2.4245e-02 /)
      kao(:, 5, 4, 6) = (/ &
     &5.0658e-05 ,3.6946e-03 ,6.9352e-03 ,1.0060e-02 ,1.3165e-02 ,1.6424e-02 , &
     &1.9935e-02 ,2.4115e-02 ,2.6056e-02 /)
      kao(:, 1, 5, 6) = (/ &
     &6.1528e-05 ,2.4644e-03 ,4.3512e-03 ,6.1626e-03 ,7.9327e-03 ,9.6496e-03 , &
     &1.1347e-02 ,1.3264e-02 ,1.4745e-02 /)
      kao(:, 2, 5, 6) = (/ &
     &6.6793e-05 ,2.6844e-03 ,4.7746e-03 ,6.7632e-03 ,8.7202e-03 ,1.0626e-02 , &
     &1.2508e-02 ,1.4649e-02 ,1.6279e-02 /)
      kao(:, 3, 5, 6) = (/ &
     &7.2459e-05 ,2.8961e-03 ,5.1774e-03 ,7.3853e-03 ,9.5105e-03 ,1.1570e-02 , &
     &1.3632e-02 ,1.6051e-02 ,1.7802e-02 /)
      kao(:, 4, 5, 6) = (/ &
     &7.8727e-05 ,3.1045e-03 ,5.5659e-03 ,7.9693e-03 ,1.0288e-02 ,1.2541e-02 , &
     &1.4785e-02 ,1.7438e-02 ,1.9338e-02 /)
      kao(:, 5, 5, 6) = (/ &
     &8.5530e-05 ,3.3182e-03 ,5.9543e-03 ,8.5528e-03 ,1.1059e-02 ,1.3485e-02 , &
     &1.5922e-02 ,1.8829e-02 ,2.0873e-02 /)
      kao(:, 1, 6, 6) = (/ &
     &9.4265e-05 ,2.2301e-03 ,3.8046e-03 ,5.2488e-03 ,6.6170e-03 ,7.9289e-03 , &
     &9.1950e-03 ,1.0423e-02 ,1.1518e-02 /)
      kao(:, 2, 6, 6) = (/ &
     &1.0266e-04 ,2.4246e-03 ,4.1792e-03 ,5.7800e-03 ,7.2894e-03 ,8.7747e-03 , &
     &1.0200e-02 ,1.1548e-02 ,1.2780e-02 /)
      kao(:, 3, 6, 6) = (/ &
     &1.1200e-04 ,2.6239e-03 ,4.5381e-03 ,6.2992e-03 ,7.9916e-03 ,9.6188e-03 , &
     &1.1174e-02 ,1.2683e-02 ,1.4059e-02 /)
      kao(:, 4, 6, 6) = (/ &
     &1.2224e-04 ,2.8287e-03 ,4.8898e-03 ,6.8010e-03 ,8.6582e-03 ,1.0462e-02 , &
     &1.2176e-02 ,1.3803e-02 ,1.5334e-02 /)
      kao(:, 5, 6, 6) = (/ &
     &1.3337e-04 ,3.0366e-03 ,5.2437e-03 ,7.3027e-03 ,9.3153e-03 ,1.1279e-02 , &
     &1.3144e-02 ,1.4949e-02 ,1.6628e-02 /)
      kao(:, 1, 7, 6) = (/ &
     &1.5263e-04 ,2.1146e-03 ,3.4378e-03 ,4.6052e-03 ,5.6815e-03 ,6.6787e-03 , &
     &7.5592e-03 ,8.3902e-03 ,8.9861e-03 /)
      kao(:, 2, 7, 6) = (/ &
     &1.6683e-04 ,2.3125e-03 ,3.7648e-03 ,5.0866e-03 ,6.2982e-03 ,7.4001e-03 , &
     &8.4314e-03 ,9.3717e-03 ,1.0001e-02 /)
      kao(:, 3, 7, 6) = (/ &
     &1.8246e-04 ,2.5152e-03 ,4.0947e-03 ,5.5502e-03 ,6.9009e-03 ,8.1426e-03 , &
     &9.2748e-03 ,1.0344e-02 ,1.1085e-02 /)
      kao(:, 4, 7, 6) = (/ &
     &1.9965e-04 ,2.7190e-03 ,4.4394e-03 ,6.0162e-03 ,7.4822e-03 ,8.8463e-03 , &
     &1.0151e-02 ,1.1321e-02 ,1.2163e-02 /)
      kao(:, 5, 7, 6) = (/ &
     &2.1839e-04 ,2.9201e-03 ,4.7890e-03 ,6.4854e-03 ,8.0589e-03 ,9.5473e-03 , &
     &1.0985e-02 ,1.2296e-02 ,1.3266e-02 /)
      kao(:, 1, 8, 6) = (/ &
     &2.9912e-04 ,2.3311e-03 ,3.4065e-03 ,4.3529e-03 ,5.1991e-03 ,5.9115e-03 , &
     &6.5345e-03 ,6.9536e-03 ,6.9673e-03 /)
      kao(:, 2, 8, 6) = (/ &
     &3.2667e-04 ,2.5198e-03 ,3.7444e-03 ,4.8113e-03 ,5.7475e-03 ,6.5852e-03 , &
     &7.2722e-03 ,7.8027e-03 ,7.8100e-03 /)
      kao(:, 3, 8, 6) = (/ &
     &3.5783e-04 ,2.7045e-03 ,4.0852e-03 ,5.2736e-03 ,6.2947e-03 ,7.2359e-03 , &
     &8.0488e-03 ,8.6314e-03 ,8.7294e-03 /)
      kao(:, 4, 8, 6) = (/ &
     &3.9253e-04 ,2.8930e-03 ,4.4286e-03 ,5.7246e-03 ,6.8467e-03 ,7.8891e-03 , &
     &8.7826e-03 ,9.4970e-03 ,9.6421e-03 /)
      kao(:, 5, 8, 6) = (/ &
     &4.3012e-04 ,3.0887e-03 ,4.7690e-03 ,6.1815e-03 ,7.4286e-03 ,8.5468e-03 , &
     &9.5146e-03 ,1.0319e-02 ,1.0565e-02 /)
      kao(:, 1, 9, 6) = (/ &
     &1.0976e-03 ,4.1506e-03 ,5.1147e-03 ,5.7794e-03 ,6.2915e-03 ,6.5755e-03 , &
     &6.7173e-03 ,6.5721e-03 ,5.2619e-03 /)
      kao(:, 2, 9, 6) = (/ &
     &1.2019e-03 ,4.4814e-03 ,5.5166e-03 ,6.2823e-03 ,6.8818e-03 ,7.2627e-03 , &
     &7.4725e-03 ,7.3662e-03 ,5.9464e-03 /)
      kao(:, 3, 9, 6) = (/ &
     &1.3207e-03 ,4.7927e-03 ,5.9242e-03 ,6.7576e-03 ,7.4599e-03 ,7.9614e-03 , &
     &8.2442e-03 ,8.1477e-03 ,6.6764e-03 /)
      kao(:, 4, 9, 6) = (/ &
     &1.4520e-03 ,5.0989e-03 ,6.3402e-03 ,7.2519e-03 ,8.0196e-03 ,8.6608e-03 , &
     &9.0083e-03 ,8.9373e-03 ,7.4095e-03 /)
      kao(:, 5, 9, 6) = (/ &
     &1.5966e-03 ,5.4241e-03 ,6.7693e-03 ,7.7581e-03 ,8.6262e-03 ,9.3645e-03 , &
     &9.7704e-03 ,9.7289e-03 ,8.1550e-03 /)
      kao(:, 1,10, 6) = (/ &
     &4.4394e-03 ,9.1190e-03 ,1.0725e-02 ,1.1220e-02 ,1.1152e-02 ,1.0508e-02 , &
     &9.4386e-03 ,7.8107e-03 ,4.9143e-03 /)
      kao(:, 2,10, 6) = (/ &
     &4.8803e-03 ,1.0187e-02 ,1.1809e-02 ,1.2265e-02 ,1.2072e-02 ,1.1380e-02 , &
     &1.0318e-02 ,8.6414e-03 ,5.6112e-03 /)
      kao(:, 3,10, 6) = (/ &
     &5.3784e-03 ,1.1243e-02 ,1.2866e-02 ,1.3294e-02 ,1.2988e-02 ,1.2282e-02 , &
     &1.1181e-02 ,9.4518e-03 ,6.2671e-03 /)
      kao(:, 4,10, 6) = (/ &
     &5.9406e-03 ,1.2247e-02 ,1.3888e-02 ,1.4276e-02 ,1.3911e-02 ,1.3225e-02 , &
     &1.2026e-02 ,1.0238e-02 ,6.9421e-03 /)
      kao(:, 5,10, 6) = (/ &
     &6.5660e-03 ,1.3194e-02 ,1.4891e-02 ,1.5253e-02 ,1.4902e-02 ,1.4176e-02 , &
     &1.2864e-02 ,1.1066e-02 ,7.6281e-03 /)
      kao(:, 1,11, 6) = (/ &
     &6.6711e-03 ,1.1267e-02 ,1.2748e-02 ,1.3242e-02 ,1.2977e-02 ,1.2030e-02 , &
     &1.0523e-02 ,8.3002e-03 ,5.3202e-03 /)
      kao(:, 2,11, 6) = (/ &
     &7.3092e-03 ,1.2565e-02 ,1.4207e-02 ,1.4653e-02 ,1.4245e-02 ,1.3138e-02 , &
     &1.1437e-02 ,9.1124e-03 ,6.0956e-03 /)
      kao(:, 3,11, 6) = (/ &
     &8.0261e-03 ,1.3900e-02 ,1.5599e-02 ,1.6022e-02 ,1.5510e-02 ,1.4232e-02 , &
     &1.2399e-02 ,9.8954e-03 ,6.7920e-03 /)
      kao(:, 4,11, 6) = (/ &
     &8.8835e-03 ,1.5218e-02 ,1.7018e-02 ,1.7348e-02 ,1.6755e-02 ,1.5328e-02 , &
     &1.3427e-02 ,1.0676e-02 ,7.4156e-03 /)
      kao(:, 5,11, 6) = (/ &
     &9.8592e-03 ,1.6591e-02 ,1.8382e-02 ,1.8693e-02 ,1.7995e-02 ,1.6489e-02 , &
     &1.4464e-02 ,1.1488e-02 ,8.0687e-03 /)
      kao(:, 1,12, 6) = (/ &
     &7.8286e-03 ,1.1844e-02 ,1.2951e-02 ,1.3269e-02 ,1.2819e-02 ,1.1719e-02 , &
     &1.0146e-02 ,7.7901e-03 ,5.3706e-03 /)
      kao(:, 2,12, 6) = (/ &
     &8.5205e-03 ,1.3089e-02 ,1.4355e-02 ,1.4624e-02 ,1.4116e-02 ,1.2895e-02 , &
     &1.1103e-02 ,8.5730e-03 ,5.9882e-03 /)
      kao(:, 3,12, 6) = (/ &
     &9.3309e-03 ,1.4405e-02 ,1.5746e-02 ,1.6010e-02 ,1.5387e-02 ,1.4067e-02 , &
     &1.2065e-02 ,9.3726e-03 ,6.6686e-03 /)
      kao(:, 4,12, 6) = (/ &
     &1.0285e-02 ,1.5780e-02 ,1.7147e-02 ,1.7368e-02 ,1.6677e-02 ,1.5224e-02 , &
     &1.3058e-02 ,1.0197e-02 ,7.3827e-03 /)
      kao(:, 5,12, 6) = (/ &
     &1.1378e-02 ,1.7192e-02 ,1.8621e-02 ,1.8778e-02 ,1.8045e-02 ,1.6433e-02 , &
     &1.4105e-02 ,1.1017e-02 ,8.1428e-03 /)
      kao(:, 1,13, 6) = (/ &
     &7.7075e-03 ,1.1053e-02 ,1.1788e-02 ,1.1798e-02 ,1.1282e-02 ,1.0218e-02 , &
     &8.7608e-03 ,6.6974e-03 ,4.9774e-03 /)
      kao(:, 2,13, 6) = (/ &
     &8.3931e-03 ,1.2074e-02 ,1.2868e-02 ,1.2866e-02 ,1.2320e-02 ,1.1165e-02 , &
     &9.5984e-03 ,7.4025e-03 ,5.6029e-03 /)
      kao(:, 3,13, 6) = (/ &
     &9.1257e-03 ,1.3198e-02 ,1.3994e-02 ,1.3989e-02 ,1.3400e-02 ,1.2194e-02 , &
     &1.0455e-02 ,8.1317e-03 ,6.2279e-03 /)
      kao(:, 4,13, 6) = (/ &
     &9.9594e-03 ,1.4337e-02 ,1.5200e-02 ,1.5161e-02 ,1.4494e-02 ,1.3263e-02 , &
     &1.1356e-02 ,8.8525e-03 ,6.8478e-03 /)
      kao(:, 5,13, 6) = (/ &
     &1.0855e-02 ,1.5527e-02 ,1.6501e-02 ,1.6412e-02 ,1.5661e-02 ,1.4395e-02 , &
     &1.2355e-02 ,9.5887e-03 ,7.3951e-03 /)
      kao(:, 1, 1, 7) = (/ &
     &2.8482e-05 ,1.1072e-02 ,2.2376e-02 ,3.4052e-02 ,4.6363e-02 ,5.9888e-02 , &
     &7.6137e-02 ,1.0147e-01 ,9.2714e-02 /)
      kao(:, 2, 1, 7) = (/ &
     &2.9459e-05 ,1.1920e-02 ,2.4092e-02 ,3.6662e-02 ,4.9933e-02 ,6.4531e-02 , &
     &8.2136e-02 ,1.0950e-01 ,9.9856e-02 /)
      kao(:, 3, 1, 7) = (/ &
     &3.0378e-05 ,1.2748e-02 ,2.5776e-02 ,3.9242e-02 ,5.3450e-02 ,6.9069e-02 , &
     &8.7941e-02 ,1.1741e-01 ,1.0689e-01 /)
      kao(:, 4, 1, 7) = (/ &
     &3.1242e-05 ,1.3565e-02 ,2.7429e-02 ,4.1762e-02 ,5.6896e-02 ,7.3556e-02 , &
     &9.3626e-02 ,1.2500e-01 ,1.1378e-01 /)
      kao(:, 5, 1, 7) = (/ &
     &3.2096e-05 ,1.4368e-02 ,2.9038e-02 ,4.4226e-02 ,6.0256e-02 ,7.7920e-02 , &
     &9.9246e-02 ,1.3270e-01 ,1.2050e-01 /)
      kao(:, 1, 2, 7) = (/ &
     &3.8108e-05 ,9.1980e-03 ,1.8505e-02 ,2.8037e-02 ,3.7923e-02 ,4.8524e-02 , &
     &6.0800e-02 ,7.8866e-02 ,7.5829e-02 /)
      kao(:, 2, 2, 7) = (/ &
     &3.9453e-05 ,9.9404e-03 ,2.0012e-02 ,3.0307e-02 ,4.0999e-02 ,5.2467e-02 , &
     &6.5752e-02 ,8.5496e-02 ,8.1980e-02 /)
      kao(:, 3, 2, 7) = (/ &
     &4.0728e-05 ,1.0645e-02 ,2.1444e-02 ,3.2483e-02 ,4.3962e-02 ,5.6282e-02 , &
     &7.0607e-02 ,9.1834e-02 ,8.7906e-02 /)
      kao(:, 4, 2, 7) = (/ &
     &4.1960e-05 ,1.1349e-02 ,2.2852e-02 ,3.4627e-02 ,4.6872e-02 ,6.0009e-02 , &
     &7.5320e-02 ,9.8100e-02 ,9.3725e-02 /)
      kao(:, 5, 2, 7) = (/ &
     &4.3152e-05 ,1.2042e-02 ,2.4257e-02 ,3.6759e-02 ,4.9754e-02 ,6.3714e-02 , &
     &7.9963e-02 ,1.0426e-01 ,9.9487e-02 /)
      kao(:, 1, 3, 7) = (/ &
     &6.8682e-05 ,7.6817e-03 ,1.5032e-02 ,2.2610e-02 ,3.0354e-02 ,3.8397e-02 , &
     &4.7144e-02 ,5.8545e-02 ,6.0680e-02 /)
      kao(:, 2, 3, 7) = (/ &
     &7.1048e-05 ,8.3077e-03 ,1.6309e-02 ,2.4554e-02 ,3.2973e-02 ,4.1716e-02 , &
     &5.1249e-02 ,6.3726e-02 ,6.5916e-02 /)
      kao(:, 3, 3, 7) = (/ &
     &7.3516e-05 ,8.8904e-03 ,1.7519e-02 ,2.6389e-02 ,3.5446e-02 ,4.4862e-02 , &
     &5.5125e-02 ,6.8637e-02 ,7.0859e-02 /)
      kao(:, 4, 3, 7) = (/ &
     &7.5927e-05 ,9.4787e-03 ,1.8742e-02 ,2.8235e-02 ,3.7922e-02 ,4.7994e-02 , &
     &5.8964e-02 ,7.3444e-02 ,7.5806e-02 /)
      kao(:, 5, 3, 7) = (/ &
     &7.8228e-05 ,1.0059e-02 ,1.9946e-02 ,3.0057e-02 ,4.0372e-02 ,5.1096e-02 , &
     &6.2816e-02 ,7.8277e-02 ,8.0701e-02 /)
      kao(:, 1, 4, 7) = (/ &
     &1.2728e-04 ,6.6847e-03 ,1.2528e-02 ,1.8338e-02 ,2.4310e-02 ,3.0521e-02 , &
     &3.7034e-02 ,4.4629e-02 ,4.8506e-02 /)
      kao(:, 2, 4, 7) = (/ &
     &1.3229e-04 ,7.2462e-03 ,1.3606e-02 ,1.9949e-02 ,2.6505e-02 ,3.3306e-02 , &
     &4.0432e-02 ,4.8804e-02 ,5.2931e-02 /)
      kao(:, 3, 4, 7) = (/ &
     &1.3690e-04 ,7.7950e-03 ,1.4636e-02 ,2.1498e-02 ,2.8618e-02 ,3.5967e-02 , &
     &4.3669e-02 ,5.2720e-02 ,5.7159e-02 /)
      kao(:, 4, 4, 7) = (/ &
     &1.4141e-04 ,8.3363e-03 ,1.5650e-02 ,2.3036e-02 ,3.0707e-02 ,3.8607e-02 , &
     &4.6880e-02 ,5.6623e-02 ,6.1327e-02 /)
      kao(:, 5, 4, 7) = (/ &
     &1.4572e-04 ,8.8720e-03 ,1.6649e-02 ,2.4570e-02 ,3.2799e-02 ,4.1227e-02 , &
     &5.0069e-02 ,6.0500e-02 ,6.5502e-02 /)
      kao(:, 1, 5, 7) = (/ &
     &2.1573e-04 ,5.8827e-03 ,1.0779e-02 ,1.5450e-02 ,1.9971e-02 ,2.4513e-02 , &
     &2.9346e-02 ,3.4831e-02 ,3.8718e-02 /)
      kao(:, 2, 5, 7) = (/ &
     &2.2440e-04 ,6.4009e-03 ,1.1752e-02 ,1.6862e-02 ,2.1813e-02 ,2.6822e-02 , &
     &3.2187e-02 ,3.8239e-02 ,4.2467e-02 /)
      kao(:, 3, 5, 7) = (/ &
     &2.3312e-04 ,6.9022e-03 ,1.2696e-02 ,1.8213e-02 ,2.3573e-02 ,2.9063e-02 , &
     &3.4955e-02 ,4.1525e-02 ,4.6111e-02 /)
      kao(:, 4, 5, 7) = (/ &
     &2.4120e-04 ,7.3983e-03 ,1.3629e-02 ,1.9546e-02 ,2.5293e-02 ,3.1249e-02 , &
     &3.7630e-02 ,4.4709e-02 ,4.9634e-02 /)
      kao(:, 5, 5, 7) = (/ &
     &2.4900e-04 ,7.8813e-03 ,1.4548e-02 ,2.0857e-02 ,2.7012e-02 ,3.3451e-02 , &
     &4.0320e-02 ,4.7915e-02 ,5.3175e-02 /)
      kao(:, 1, 6, 7) = (/ &
     &3.4036e-04 ,5.3231e-03 ,9.2729e-03 ,1.3061e-02 ,1.6728e-02 ,2.0215e-02 , &
     &2.3560e-02 ,2.7195e-02 ,3.0556e-02 /)
      kao(:, 2, 6, 7) = (/ &
     &3.5502e-04 ,5.8134e-03 ,1.0151e-02 ,1.4345e-02 ,1.8389e-02 ,2.2227e-02 , &
     &2.5905e-02 ,3.0036e-02 ,3.3756e-02 /)
      kao(:, 3, 6, 7) = (/ &
     &3.6934e-04 ,6.2790e-03 ,1.1006e-02 ,1.5584e-02 ,1.9972e-02 ,2.4157e-02 , &
     &2.8189e-02 ,3.2811e-02 ,3.6865e-02 /)
      kao(:, 4, 6, 7) = (/ &
     &3.8386e-04 ,6.7401e-03 ,1.1853e-02 ,1.6807e-02 ,2.1541e-02 ,2.6034e-02 , &
     &3.0406e-02 ,3.5498e-02 ,3.9873e-02 /)
      kao(:, 5, 6, 7) = (/ &
     &3.9798e-04 ,7.1899e-03 ,1.2680e-02 ,1.7996e-02 ,2.3081e-02 ,2.7888e-02 , &
     &3.2622e-02 ,3.8170e-02 ,4.2864e-02 /)
      kao(:, 1, 7, 7) = (/ &
     &5.6321e-04 ,5.0131e-03 ,8.3197e-03 ,1.1342e-02 ,1.4164e-02 ,1.6877e-02 , &
     &1.9447e-02 ,2.1713e-02 ,2.3905e-02 /)
      kao(:, 2, 7, 7) = (/ &
     &5.9016e-04 ,5.4925e-03 ,9.1570e-03 ,1.2482e-02 ,1.5641e-02 ,1.8693e-02 , &
     &2.1556e-02 ,2.4086e-02 ,2.6629e-02 /)
      kao(:, 3, 7, 7) = (/ &
     &6.1706e-04 ,5.9641e-03 ,9.9615e-03 ,1.3605e-02 ,1.7087e-02 ,2.0445e-02 , &
     &2.3593e-02 ,2.6361e-02 ,2.9262e-02 /)
      kao(:, 4, 7, 7) = (/ &
     &6.4250e-04 ,6.4355e-03 ,1.0740e-02 ,1.4689e-02 ,1.8507e-02 ,2.2162e-02 , &
     &2.5558e-02 ,2.8565e-02 ,3.1822e-02 /)
      kao(:, 5, 7, 7) = (/ &
     &6.6706e-04 ,6.9143e-03 ,1.1505e-02 ,1.5753e-02 ,1.9886e-02 ,2.3836e-02 , &
     &2.7497e-02 ,3.0749e-02 ,3.4313e-02 /)
      kao(:, 1, 8, 7) = (/ &
     &1.1137e-03 ,5.2798e-03 ,8.0960e-03 ,1.0553e-02 ,1.2781e-02 ,1.4788e-02 , &
     &1.6508e-02 ,1.7972e-02 ,1.8634e-02 /)
      kao(:, 2, 8, 7) = (/ &
     &1.1746e-03 ,5.8110e-03 ,8.9215e-03 ,1.1680e-02 ,1.4167e-02 ,1.6394e-02 , &
     &1.8389e-02 ,2.0091e-02 ,2.0946e-02 /)
      kao(:, 3, 8, 7) = (/ &
     &1.2333e-03 ,6.3510e-03 ,9.7459e-03 ,1.2786e-02 ,1.5523e-02 ,1.7978e-02 , &
     &2.0210e-02 ,2.2150e-02 ,2.3198e-02 /)
      kao(:, 4, 8, 7) = (/ &
     &1.2923e-03 ,6.8806e-03 ,1.0573e-02 ,1.3874e-02 ,1.6833e-02 ,1.9520e-02 , &
     &2.2008e-02 ,2.4130e-02 ,2.5397e-02 /)
      kao(:, 5, 8, 7) = (/ &
     &1.3493e-03 ,7.4001e-03 ,1.1421e-02 ,1.4955e-02 ,1.8119e-02 ,2.1028e-02 , &
     &2.3751e-02 ,2.6082e-02 ,2.7521e-02 /)
      kao(:, 1, 9, 7) = (/ &
     &4.1652e-03 ,9.1226e-03 ,1.1391e-02 ,1.3127e-02 ,1.4574e-02 ,1.5712e-02 , &
     &1.6412e-02 ,1.6590e-02 ,1.4324e-02 /)
      kao(:, 2, 9, 7) = (/ &
     &4.4077e-03 ,9.7658e-03 ,1.2393e-02 ,1.4489e-02 ,1.6135e-02 ,1.7441e-02 , &
     &1.8307e-02 ,1.8536e-02 ,1.6186e-02 /)
      kao(:, 3, 9, 7) = (/ &
     &4.6510e-03 ,1.0425e-02 ,1.3450e-02 ,1.5897e-02 ,1.7759e-02 ,1.9177e-02 , &
     &2.0163e-02 ,2.0445e-02 ,1.8103e-02 /)
      kao(:, 4, 9, 7) = (/ &
     &4.8932e-03 ,1.1096e-02 ,1.4490e-02 ,1.7265e-02 ,1.9404e-02 ,2.0920e-02 , &
     &2.2008e-02 ,2.2308e-02 ,1.9978e-02 /)
      kao(:, 5, 9, 7) = (/ &
     &5.1319e-03 ,1.1758e-02 ,1.5541e-02 ,1.8602e-02 ,2.0988e-02 ,2.2688e-02 , &
     &2.3851e-02 ,2.4156e-02 ,2.1799e-02 /)
      kao(:, 1,10, 7) = (/ &
     &1.7349e-02 ,2.4277e-02 ,2.5467e-02 ,2.5566e-02 ,2.4825e-02 ,2.3373e-02 , &
     &2.1223e-02 ,1.8524e-02 ,1.1809e-02 /)
      kao(:, 2,10, 7) = (/ &
     &1.8441e-02 ,2.5550e-02 ,2.7079e-02 ,2.7402e-02 ,2.6767e-02 ,2.5495e-02 , &
     &2.3503e-02 ,2.0675e-02 ,1.3556e-02 /)
      kao(:, 3,10, 7) = (/ &
     &1.9634e-02 ,2.6955e-02 ,2.8784e-02 ,2.9151e-02 ,2.8790e-02 ,2.7521e-02 , &
     &2.5774e-02 ,2.2876e-02 ,1.5334e-02 /)
      kao(:, 4,10, 7) = (/ &
     &2.0834e-02 ,2.8474e-02 ,3.0492e-02 ,3.0988e-02 ,3.0837e-02 ,2.9673e-02 , &
     &2.8036e-02 ,2.5100e-02 ,1.7072e-02 /)
      kao(:, 5,10, 7) = (/ &
     &2.2004e-02 ,3.0118e-02 ,3.2233e-02 ,3.2923e-02 ,3.2760e-02 ,3.1852e-02 , &
     &3.0321e-02 ,2.7280e-02 ,1.8710e-02 /)
      kao(:, 1,11, 7) = (/ &
     &2.5621e-02 ,3.2655e-02 ,3.3386e-02 ,3.2478e-02 ,3.0535e-02 ,2.7796e-02 , &
     &2.3855e-02 ,1.8680e-02 ,1.0565e-02 /)
      kao(:, 2,11, 7) = (/ &
     &2.7487e-02 ,3.4718e-02 ,3.5449e-02 ,3.4659e-02 ,3.2784e-02 ,2.9958e-02 , &
     &2.6042e-02 ,2.0737e-02 ,1.2143e-02 /)
      kao(:, 3,11, 7) = (/ &
     &2.9493e-02 ,3.6885e-02 ,3.7684e-02 ,3.6984e-02 ,3.4999e-02 ,3.2138e-02 , &
     &2.8186e-02 ,2.2834e-02 ,1.3640e-02 /)
      kao(:, 4,11, 7) = (/ &
     &3.1405e-02 ,3.9361e-02 ,4.0123e-02 ,3.9393e-02 ,3.7354e-02 ,3.4345e-02 , &
     &3.0182e-02 ,2.4896e-02 ,1.5233e-02 /)
      kao(:, 5,11, 7) = (/ &
     &3.3372e-02 ,4.1804e-02 ,4.2639e-02 ,4.1888e-02 ,3.9776e-02 ,3.6559e-02 , &
     &3.2377e-02 ,2.6934e-02 ,1.6905e-02 /)
      kao(:, 1,12, 7) = (/ &
     &2.8107e-02 ,3.4513e-02 ,3.4691e-02 ,3.3440e-02 ,3.1149e-02 ,2.8092e-02 , &
     &2.3835e-02 ,1.7987e-02 ,9.8223e-03 /)
      kao(:, 2,12, 7) = (/ &
     &3.0318e-02 ,3.7007e-02 ,3.7165e-02 ,3.5894e-02 ,3.3524e-02 ,3.0240e-02 , &
     &2.5840e-02 ,1.9792e-02 ,1.1332e-02 /)
      kao(:, 3,12, 7) = (/ &
     &3.2580e-02 ,3.9682e-02 ,3.9790e-02 ,3.8457e-02 ,3.5971e-02 ,3.2486e-02 , &
     &2.7883e-02 ,2.1561e-02 ,1.2728e-02 /)
      kao(:, 4,12, 7) = (/ &
     &3.4838e-02 ,4.2408e-02 ,4.2616e-02 ,4.1228e-02 ,3.8571e-02 ,3.4918e-02 , &
     &2.9920e-02 ,2.3363e-02 ,1.4318e-02 /)
      kao(:, 5,12, 7) = (/ &
     &3.7163e-02 ,4.5231e-02 ,4.5400e-02 ,4.4006e-02 ,4.1203e-02 ,3.7331e-02 , &
     &3.2004e-02 ,2.5209e-02 ,1.5927e-02 /)
      kao(:, 1,13, 7) = (/ &
     &2.5217e-02 ,3.0486e-02 ,3.0548e-02 ,2.9385e-02 ,2.7336e-02 ,2.4524e-02 , &
     &2.0890e-02 ,1.5756e-02 ,9.4392e-03 /)
      kao(:, 2,13, 7) = (/ &
     &2.7202e-02 ,3.2841e-02 ,3.2933e-02 ,3.1772e-02 ,2.9593e-02 ,2.6611e-02 , &
     &2.2741e-02 ,1.7329e-02 ,1.0602e-02 /)
      kao(:, 3,13, 7) = (/ &
     &2.9280e-02 ,3.5351e-02 ,3.5444e-02 ,3.4289e-02 ,3.1993e-02 ,2.8821e-02 , &
     &2.4603e-02 ,1.8828e-02 ,1.1938e-02 /)
      kao(:, 4,13, 7) = (/ &
     &3.1331e-02 ,3.7956e-02 ,3.7975e-02 ,3.6801e-02 ,3.4445e-02 ,3.1086e-02 , &
     &2.6513e-02 ,2.0428e-02 ,1.3267e-02 /)
      kao(:, 5,13, 7) = (/ &
     &3.3613e-02 ,4.0685e-02 ,4.0655e-02 ,3.9388e-02 ,3.6935e-02 ,3.3268e-02 , &
     &2.8459e-02 ,2.2050e-02 ,1.4574e-02 /)
      kao(:, 1, 1, 8) = (/ &
     &7.0857e-05 ,3.1247e-02 ,6.3050e-02 ,9.5741e-02 ,1.2991e-01 ,1.6688e-01 , &
     &2.1008e-01 ,2.7194e-01 ,2.5981e-01 /)
      kao(:, 2, 1, 8) = (/ &
     &7.3061e-05 ,3.3759e-02 ,6.8122e-02 ,1.0346e-01 ,1.4038e-01 ,1.8030e-01 , &
     &2.2703e-01 ,2.9445e-01 ,2.8076e-01 /)
      kao(:, 3, 1, 8) = (/ &
     &7.5439e-05 ,3.6248e-02 ,7.3153e-02 ,1.1109e-01 ,1.5077e-01 ,1.9367e-01 , &
     &2.4381e-01 ,3.1652e-01 ,3.0153e-01 /)
      kao(:, 4, 1, 8) = (/ &
     &7.7957e-05 ,3.8675e-02 ,7.8063e-02 ,1.1859e-01 ,1.6099e-01 ,2.0691e-01 , &
     &2.6053e-01 ,3.3811e-01 ,3.2197e-01 /)
      kao(:, 5, 1, 8) = (/ &
     &8.0722e-05 ,4.1119e-02 ,8.2986e-02 ,1.2604e-01 ,1.7112e-01 ,2.1995e-01 , &
     &2.7714e-01 ,3.5946e-01 ,3.4222e-01 /)
      kao(:, 1, 2, 8) = (/ &
     &9.7224e-05 ,2.6558e-02 ,5.3452e-02 ,8.0855e-02 ,1.0918e-01 ,1.3924e-01 , &
     &1.7330e-01 ,2.2109e-01 ,2.1834e-01 /)
      kao(:, 2, 2, 8) = (/ &
     &1.0058e-04 ,2.8759e-02 ,5.7870e-02 ,8.7575e-02 ,1.1827e-01 ,1.5089e-01 , &
     &1.8793e-01 ,2.3994e-01 ,2.3652e-01 /)
      kao(:, 3, 2, 8) = (/ &
     &1.0421e-04 ,3.0964e-02 ,6.2308e-02 ,9.4299e-02 ,1.2733e-01 ,1.6243e-01 , &
     &2.0230e-01 ,2.5862e-01 ,2.5463e-01 /)
      kao(:, 4, 2, 8) = (/ &
     &1.0798e-04 ,3.3179e-02 ,6.6764e-02 ,1.0101e-01 ,1.3640e-01 ,1.7400e-01 , &
     &2.1675e-01 ,2.7715e-01 ,2.7277e-01 /)
      kao(:, 5, 2, 8) = (/ &
     &1.1188e-04 ,3.5361e-02 ,7.1160e-02 ,1.0767e-01 ,1.4545e-01 ,1.8554e-01 , &
     &2.3113e-01 ,2.9555e-01 ,2.9088e-01 /)
      kao(:, 1, 3, 8) = (/ &
     &1.7704e-04 ,2.1958e-02 ,4.4006e-02 ,6.6294e-02 ,8.8988e-02 ,1.1245e-01 , &
     &1.3781e-01 ,1.7014e-01 ,1.7794e-01 /)
      kao(:, 2, 3, 8) = (/ &
     &1.8401e-04 ,2.3898e-02 ,4.7908e-02 ,7.2164e-02 ,9.6867e-02 ,1.2239e-01 , &
     &1.4998e-01 ,1.8528e-01 ,1.9370e-01 /)
      kao(:, 3, 3, 8) = (/ &
     &1.9123e-04 ,2.5882e-02 ,5.1886e-02 ,7.8168e-02 ,1.0491e-01 ,1.3257e-01 , &
     &1.6241e-01 ,2.0047e-01 ,2.0978e-01 /)
      kao(:, 4, 3, 8) = (/ &
     &1.9826e-04 ,2.7841e-02 ,5.5828e-02 ,8.4093e-02 ,1.1289e-01 ,1.4266e-01 , &
     &1.7485e-01 ,2.1582e-01 ,2.2574e-01 /)
      kao(:, 5, 3, 8) = (/ &
     &2.0558e-04 ,2.9781e-02 ,5.9723e-02 ,8.9997e-02 ,1.2076e-01 ,1.5262e-01 , &
     &1.8706e-01 ,2.3095e-01 ,2.4148e-01 /)
      kao(:, 1, 4, 8) = (/ &
     &3.2677e-04 ,1.8554e-02 ,3.5926e-02 ,5.3829e-02 ,7.1995e-02 ,9.0469e-02 , &
     &1.0973e-01 ,1.3198e-01 ,1.4393e-01 /)
      kao(:, 2, 4, 8) = (/ &
     &3.3998e-04 ,2.0214e-02 ,3.9351e-02 ,5.9051e-02 ,7.8970e-02 ,9.9220e-02 , &
     &1.2030e-01 ,1.4461e-01 ,1.5787e-01 /)
      kao(:, 3, 4, 8) = (/ &
     &3.5423e-04 ,2.1886e-02 ,4.2819e-02 ,6.4313e-02 ,8.6016e-02 ,1.0809e-01 , &
     &1.3108e-01 ,1.5763e-01 ,1.7196e-01 /)
      kao(:, 4, 4, 8) = (/ &
     &3.6836e-04 ,2.3526e-02 ,4.6236e-02 ,6.9481e-02 ,9.2916e-02 ,1.1677e-01 , &
     &1.4164e-01 ,1.7039e-01 ,1.8576e-01 /)
      kao(:, 5, 4, 8) = (/ &
     &3.8269e-04 ,2.5159e-02 ,4.9646e-02 ,7.4614e-02 ,9.9776e-02 ,1.2541e-01 , &
     &1.5213e-01 ,1.8307e-01 ,1.9947e-01 /)
      kao(:, 1, 5, 8) = (/ &
     &5.5618e-04 ,1.6693e-02 ,3.0352e-02 ,4.4004e-02 ,5.8213e-02 ,7.2865e-02 , &
     &8.7904e-02 ,1.0425e-01 ,1.1619e-01 /)
      kao(:, 2, 5, 8) = (/ &
     &5.8090e-04 ,1.8251e-02 ,3.3255e-02 ,4.8452e-02 ,6.4257e-02 ,8.0492e-02 , &
     &9.7115e-02 ,1.1513e-01 ,1.2836e-01 /)
      kao(:, 3, 5, 8) = (/ &
     &6.0567e-04 ,1.9782e-02 ,3.6119e-02 ,5.2854e-02 ,7.0252e-02 ,8.8045e-02 , &
     &1.0624e-01 ,1.2602e-01 ,1.4037e-01 /)
      kao(:, 4, 5, 8) = (/ &
     &6.3036e-04 ,2.1279e-02 ,3.8977e-02 ,5.7257e-02 ,7.6243e-02 ,9.5550e-02 , &
     &1.1529e-01 ,1.3680e-01 ,1.5235e-01 /)
      kao(:, 5, 5, 8) = (/ &
     &6.5503e-04 ,2.2767e-02 ,4.1832e-02 ,6.1655e-02 ,8.2195e-02 ,1.0302e-01 , &
     &1.2434e-01 ,1.4756e-01 ,1.6424e-01 /)
      kao(:, 1, 6, 8) = (/ &
     &8.8779e-04 ,1.5219e-02 ,2.6847e-02 ,3.7621e-02 ,4.8063e-02 ,5.8817e-02 , &
     &7.0265e-02 ,8.2696e-02 ,9.3190e-02 /)
      kao(:, 2, 6, 8) = (/ &
     &9.2874e-04 ,1.6673e-02 ,2.9554e-02 ,4.1458e-02 ,5.3049e-02 ,6.5160e-02 , &
     &7.8074e-02 ,9.1921e-02 ,1.0355e-01 /)
      kao(:, 3, 6, 8) = (/ &
     &9.6950e-04 ,1.8111e-02 ,3.2190e-02 ,4.5211e-02 ,5.8015e-02 ,7.1500e-02 , &
     &8.5838e-02 ,1.0107e-01 ,1.1382e-01 /)
      kao(:, 4, 6, 8) = (/ &
     &1.0101e-03 ,1.9522e-02 ,3.4803e-02 ,4.8905e-02 ,6.3015e-02 ,7.7875e-02 , &
     &9.3602e-02 ,1.1021e-01 ,1.2414e-01 /)
      kao(:, 5, 6, 8) = (/ &
     &1.0515e-03 ,2.0916e-02 ,3.7389e-02 ,5.2547e-02 ,6.7966e-02 ,8.4205e-02 , &
     &1.0130e-01 ,1.1932e-01 ,1.3433e-01 /)
      kao(:, 1, 7, 8) = (/ &
     &1.4977e-03 ,1.4733e-02 ,2.4381e-02 ,3.3428e-02 ,4.1931e-02 ,4.9753e-02 , &
     &5.7173e-02 ,6.5580e-02 ,7.4312e-02 /)
      kao(:, 2, 7, 8) = (/ &
     &1.5637e-03 ,1.6075e-02 ,2.6857e-02 ,3.6980e-02 ,4.6449e-02 ,5.5152e-02 , &
     &6.3551e-02 ,7.3261e-02 ,8.3066e-02 /)
      kao(:, 3, 7, 8) = (/ &
     &1.6297e-03 ,1.7399e-02 ,2.9305e-02 ,4.0484e-02 ,5.0904e-02 ,6.0470e-02 , &
     &6.9956e-02 ,8.1009e-02 ,9.1840e-02 /)
      kao(:, 4, 7, 8) = (/ &
     &1.7004e-03 ,1.8688e-02 ,3.1747e-02 ,4.3982e-02 ,5.5347e-02 ,6.5760e-02 , &
     &7.6435e-02 ,8.8798e-02 ,1.0066e-01 /)
      kao(:, 5, 7, 8) = (/ &
     &1.7747e-03 ,1.9942e-02 ,3.4156e-02 ,4.7424e-02 ,5.9706e-02 ,7.0996e-02 , &
     &8.2872e-02 ,9.6510e-02 ,1.0938e-01 /)
      kao(:, 1, 8, 8) = (/ &
     &3.0289e-03 ,1.6187e-02 ,2.4623e-02 ,3.1800e-02 ,3.8382e-02 ,4.4473e-02 , &
     &4.9956e-02 ,5.4111e-02 ,5.8932e-02 /)
      kao(:, 2, 8, 8) = (/ &
     &3.1588e-03 ,1.7601e-02 ,2.6972e-02 ,3.5067e-02 ,4.2580e-02 ,4.9539e-02 , &
     &5.5733e-02 ,6.0374e-02 ,6.6309e-02 /)
      kao(:, 3, 8, 8) = (/ &
     &3.2918e-03 ,1.8992e-02 ,2.9294e-02 ,3.8315e-02 ,4.6735e-02 ,5.4548e-02 , &
     &6.1452e-02 ,6.6677e-02 ,7.3699e-02 /)
      kao(:, 4, 8, 8) = (/ &
     &3.4281e-03 ,2.0362e-02 ,3.1558e-02 ,4.1571e-02 ,5.0908e-02 ,5.9537e-02 , &
     &6.7138e-02 ,7.3015e-02 ,8.1106e-02 /)
      kao(:, 5, 8, 8) = (/ &
     &3.5753e-03 ,2.1737e-02 ,3.3774e-02 ,4.4733e-02 ,5.4993e-02 ,6.4441e-02 , &
     &7.2719e-02 ,7.9338e-02 ,8.8474e-02 /)
      kao(:, 1, 9, 8) = (/ &
     &1.1613e-02 ,2.6600e-02 ,3.4830e-02 ,4.1045e-02 ,4.5758e-02 ,4.9187e-02 , &
     &5.0957e-02 ,5.0881e-02 ,4.6332e-02 /)
      kao(:, 2, 9, 8) = (/ &
     &1.2035e-02 ,2.8837e-02 ,3.7970e-02 ,4.4834e-02 ,5.0301e-02 ,5.4274e-02 , &
     &5.6564e-02 ,5.6979e-02 ,5.2710e-02 /)
      kao(:, 3, 9, 8) = (/ &
     &1.2460e-02 ,3.1118e-02 ,4.1014e-02 ,4.8606e-02 ,5.4716e-02 ,5.9241e-02 , &
     &6.2128e-02 ,6.3036e-02 ,5.8975e-02 /)
      kao(:, 4, 9, 8) = (/ &
     &1.2980e-02 ,3.3463e-02 ,4.4127e-02 ,5.2378e-02 ,5.9008e-02 ,6.4138e-02 , &
     &6.7667e-02 ,6.9075e-02 ,6.5274e-02 /)
      kao(:, 5, 9, 8) = (/ &
     &1.3559e-02 ,3.5809e-02 ,4.7263e-02 ,5.6212e-02 ,6.3302e-02 ,6.8912e-02 , &
     &7.3069e-02 ,7.5010e-02 ,7.1590e-02 /)
      kao(:, 1,10, 8) = (/ &
     &4.9669e-02 ,6.5649e-02 ,7.1116e-02 ,7.3534e-02 ,7.3825e-02 ,7.2083e-02 , &
     &6.7844e-02 ,5.9498e-02 ,3.3788e-02 /)
      kao(:, 2,10, 8) = (/ &
     &5.1505e-02 ,7.0624e-02 ,7.6814e-02 ,7.9826e-02 ,8.0618e-02 ,7.8892e-02 , &
     &7.4439e-02 ,6.5949e-02 ,3.8529e-02 /)
      kao(:, 3,10, 8) = (/ &
     &5.3297e-02 ,7.5384e-02 ,8.2789e-02 ,8.6542e-02 ,8.7369e-02 ,8.5820e-02 , &
     &8.1089e-02 ,7.2258e-02 ,4.3360e-02 /)
      kao(:, 4,10, 8) = (/ &
     &5.5068e-02 ,8.0008e-02 ,8.8749e-02 ,9.3221e-02 ,9.4169e-02 ,9.2692e-02 , &
     &8.7784e-02 ,7.8437e-02 ,4.8014e-02 /)
      kao(:, 5,10, 8) = (/ &
     &5.7734e-02 ,8.4667e-02 ,9.4556e-02 ,9.9634e-02 ,1.0118e-01 ,9.9703e-02 , &
     &9.4571e-02 ,8.4495e-02 ,5.2667e-02 /)
      kao(:, 1,11, 8) = (/ &
     &7.6448e-02 ,9.0381e-02 ,9.1555e-02 ,9.0047e-02 ,8.6717e-02 ,8.1217e-02 , &
     &7.3241e-02 ,6.1179e-02 ,3.1726e-02 /)
      kao(:, 2,11, 8) = (/ &
     &7.9612e-02 ,9.5621e-02 ,9.8574e-02 ,9.7505e-02 ,9.4314e-02 ,8.8768e-02 , &
     &8.0204e-02 ,6.7360e-02 ,3.6181e-02 /)
      kao(:, 3,11, 8) = (/ &
     &8.2652e-02 ,1.0183e-01 ,1.0547e-01 ,1.0483e-01 ,1.0201e-01 ,9.6508e-02 , &
     &8.7273e-02 ,7.3474e-02 ,4.0817e-02 /)
      kao(:, 4,11, 8) = (/ &
     &8.5862e-02 ,1.0806e-01 ,1.1212e-01 ,1.1216e-01 ,1.0950e-01 ,1.0402e-01 , &
     &9.4626e-02 ,7.9735e-02 ,4.5328e-02 /)
      kao(:, 5,11, 8) = (/ &
     &8.9572e-02 ,1.1434e-01 ,1.1896e-01 ,1.1939e-01 ,1.1678e-01 ,1.1141e-01 , &
     &1.0160e-01 ,8.6030e-02 ,4.9522e-02 /)
      kao(:, 1,12, 8) = (/ &
     &8.7861e-02 ,9.9993e-02 ,9.9171e-02 ,9.4628e-02 ,8.8704e-02 ,8.0579e-02 , &
     &7.0917e-02 ,5.7333e-02 ,2.8393e-02 /)
      kao(:, 2,12, 8) = (/ &
     &9.1432e-02 ,1.0608e-01 ,1.0583e-01 ,1.0218e-01 ,9.6300e-02 ,8.8064e-02 , &
     &7.7816e-02 ,6.3024e-02 ,3.2578e-02 /)
      kao(:, 3,12, 8) = (/ &
     &9.5110e-02 ,1.1196e-01 ,1.1325e-01 ,1.0996e-01 ,1.0369e-01 ,9.5361e-02 , &
     &8.4644e-02 ,6.8902e-02 ,3.7335e-02 /)
      kao(:, 4,12, 8) = (/ &
     &9.9318e-02 ,1.1859e-01 ,1.2042e-01 ,1.1748e-01 ,1.1108e-01 ,1.0241e-01 , &
     &9.1344e-02 ,7.4779e-02 ,4.1207e-02 /)
      kao(:, 5,12, 8) = (/ &
     &1.0395e-01 ,1.2551e-01 ,1.2774e-01 ,1.2502e-01 ,1.1865e-01 ,1.0948e-01 , &
     &9.7810e-02 ,8.0483e-02 ,4.4886e-02 /)
      kao(:, 1,13, 8) = (/ &
     &7.9847e-02 ,9.1714e-02 ,9.0958e-02 ,8.6422e-02 ,8.0456e-02 ,7.2533e-02 , &
     &6.2189e-02 ,4.9649e-02 ,2.4638e-02 /)
      kao(:, 2,13, 8) = (/ &
     &8.3442e-02 ,9.7407e-02 ,9.6872e-02 ,9.3129e-02 ,8.7376e-02 ,7.8985e-02 , &
     &6.8360e-02 ,5.4702e-02 ,2.8608e-02 /)
      kao(:, 3,13, 8) = (/ &
     &8.7437e-02 ,1.0293e-01 ,1.0345e-01 ,9.9852e-02 ,9.3864e-02 ,8.5454e-02 , &
     &7.4382e-02 ,5.9885e-02 ,3.2171e-02 /)
      kao(:, 4,13, 8) = (/ &
     &9.2235e-02 ,1.0932e-01 ,1.1033e-01 ,1.0673e-01 ,1.0043e-01 ,9.1575e-02 , &
     &8.0229e-02 ,6.4806e-02 ,3.5846e-02 /)
      kao(:, 5,13, 8) = (/ &
     &9.7358e-02 ,1.1603e-01 ,1.1725e-01 ,1.1373e-01 ,1.0722e-01 ,9.7942e-02 , &
     &8.5906e-02 ,6.9573e-02 ,3.9453e-02 /)
      kao(:, 1, 1, 9) = (/ &
     &2.3734e-04 ,1.2635e-01 ,2.5378e-01 ,3.8280e-01 ,5.1449e-01 ,6.5095e-01 , &
     &7.9709e-01 ,9.7059e-01 ,1.0290e+00 /)
      kao(:, 2, 1, 9) = (/ &
     &2.4162e-04 ,1.3562e-01 ,2.7235e-01 ,4.1078e-01 ,5.5198e-01 ,6.9838e-01 , &
     &8.5534e-01 ,1.0400e+00 ,1.1040e+00 /)
      kao(:, 3, 1, 9) = (/ &
     &2.4599e-04 ,1.4459e-01 ,2.9042e-01 ,4.3810e-01 ,5.8884e-01 ,7.4499e-01 , &
     &9.1233e-01 ,1.1085e+00 ,1.1777e+00 /)
      kao(:, 4, 1, 9) = (/ &
     &2.5041e-04 ,1.5330e-01 ,3.0793e-01 ,4.6450e-01 ,6.2431e-01 ,7.9002e-01 , &
     &9.6789e-01 ,1.1761e+00 ,1.2486e+00 /)
      kao(:, 5, 1, 9) = (/ &
     &2.5474e-04 ,1.6182e-01 ,3.2498e-01 ,4.9034e-01 ,6.5899e-01 ,8.3368e-01 , &
     &1.0214e+00 ,1.2421e+00 ,1.3180e+00 /)
      kao(:, 1, 2, 9) = (/ &
     &3.4870e-04 ,1.1450e-01 ,2.2975e-01 ,3.4621e-01 ,4.6468e-01 ,5.8691e-01 , &
     &7.1765e-01 ,8.7423e-01 ,9.2933e-01 /)
      kao(:, 2, 2, 9) = (/ &
     &3.5536e-04 ,1.2334e-01 ,2.4755e-01 ,3.7300e-01 ,5.0064e-01 ,6.3232e-01 , &
     &7.7280e-01 ,9.4059e-01 ,1.0013e+00 /)
      kao(:, 3, 2, 9) = (/ &
     &3.6217e-04 ,1.3183e-01 ,2.6460e-01 ,3.9876e-01 ,5.3531e-01 ,6.7635e-01 , &
     &8.2730e-01 ,1.0064e+00 ,1.0706e+00 /)
      kao(:, 4, 2, 9) = (/ &
     &3.6933e-04 ,1.4017e-01 ,2.8129e-01 ,4.2395e-01 ,5.6909e-01 ,7.1898e-01 , &
     &8.7939e-01 ,1.0712e+00 ,1.1382e+00 /)
      kao(:, 5, 2, 9) = (/ &
     &3.7836e-04 ,1.4828e-01 ,2.9766e-01 ,4.4860e-01 ,6.0234e-01 ,7.6096e-01 , &
     &9.3060e-01 ,1.1332e+00 ,1.2047e+00 /)
      kao(:, 1, 3, 9) = (/ &
     &6.8597e-04 ,1.0077e-01 ,2.0189e-01 ,3.0366e-01 ,4.0641e-01 ,5.1122e-01 , &
     &6.2085e-01 ,7.4738e-01 ,8.1281e-01 /)
      kao(:, 2, 3, 9) = (/ &
     &6.9976e-04 ,1.0900e-01 ,2.1840e-01 ,3.2848e-01 ,4.3972e-01 ,5.5316e-01 , &
     &6.7192e-01 ,8.0915e-01 ,8.7943e-01 /)
      kao(:, 3, 3, 9) = (/ &
     &7.1420e-04 ,1.1699e-01 ,2.3444e-01 ,3.5259e-01 ,4.7192e-01 ,5.9381e-01 , &
     &7.2140e-01 ,8.6946e-01 ,9.4382e-01 /)
      kao(:, 4, 3, 9) = (/ &
     &7.3229e-04 ,1.2483e-01 ,2.5014e-01 ,3.7620e-01 ,5.0367e-01 ,6.3374e-01 , &
     &7.7001e-01 ,9.2785e-01 ,1.0073e+00 /)
      kao(:, 5, 3, 9) = (/ &
     &7.5049e-04 ,1.3237e-01 ,2.6526e-01 ,3.9901e-01 ,5.3417e-01 ,6.7225e-01 , &
     &8.1699e-01 ,9.8549e-01 ,1.0683e+00 /)
      kao(:, 1, 4, 9) = (/ &
     &1.3742e-03 ,8.7179e-02 ,1.7451e-01 ,2.6209e-01 ,3.5019e-01 ,4.3920e-01 , &
     &5.3064e-01 ,6.3091e-01 ,7.0034e-01 /)
      kao(:, 2, 4, 9) = (/ &
     &1.4034e-03 ,9.4872e-02 ,1.8987e-01 ,2.8522e-01 ,3.8105e-01 ,4.7796e-01 , &
     &5.7741e-01 ,6.8650e-01 ,7.6206e-01 /)
      kao(:, 3, 4, 9) = (/ &
     &1.4371e-03 ,1.0231e-01 ,2.0478e-01 ,3.0758e-01 ,4.1096e-01 ,5.1550e-01 , &
     &6.2287e-01 ,7.4083e-01 ,8.2187e-01 /)
      kao(:, 4, 4, 9) = (/ &
     &1.4753e-03 ,1.0953e-01 ,2.1924e-01 ,3.2932e-01 ,4.4000e-01 ,5.5196e-01 , &
     &6.6692e-01 ,7.9351e-01 ,8.7995e-01 /)
      kao(:, 5, 4, 9) = (/ &
     &1.5185e-03 ,1.1661e-01 ,2.3342e-01 ,3.5060e-01 ,4.6845e-01 ,5.8764e-01 , &
     &7.1008e-01 ,8.4502e-01 ,9.3684e-01 /)
      kao(:, 1, 5, 9) = (/ &
     &2.5355e-03 ,7.5685e-02 ,1.4908e-01 ,2.2375e-01 ,2.9863e-01 ,3.7400e-01 , &
     &4.5045e-01 ,5.3139e-01 ,5.9720e-01 /)
      kao(:, 2, 5, 9) = (/ &
     &2.5953e-03 ,8.2577e-02 ,1.6333e-01 ,2.4515e-01 ,3.2721e-01 ,4.0982e-01 , &
     &4.9365e-01 ,5.8247e-01 ,6.5435e-01 /)
      kao(:, 3, 5, 9) = (/ &
     &2.6636e-03 ,8.9208e-02 ,1.7705e-01 ,2.6573e-01 ,3.5473e-01 ,4.4427e-01 , &
     &5.3522e-01 ,6.3160e-01 ,7.0937e-01 /)
      kao(:, 4, 5, 9) = (/ &
     &2.7420e-03 ,9.5746e-02 ,1.9046e-01 ,2.8588e-01 ,3.8160e-01 ,4.7792e-01 , &
     &5.7573e-01 ,6.7936e-01 ,7.6310e-01 /)
      kao(:, 5, 5, 9) = (/ &
     &2.8238e-03 ,1.0214e-01 ,2.0360e-01 ,3.0562e-01 ,4.0796e-01 ,5.1095e-01 , &
     &6.1550e-01 ,7.2630e-01 ,8.1581e-01 /)
      kao(:, 1, 6, 9) = (/ &
     &4.3605e-03 ,6.9106e-02 ,1.2775e-01 ,1.8881e-01 ,2.5131e-01 ,3.1447e-01 , &
     &3.7819e-01 ,4.4408e-01 ,5.0252e-01 /)
      kao(:, 2, 6, 9) = (/ &
     &4.4677e-03 ,7.5202e-02 ,1.4031e-01 ,2.0810e-01 ,2.7735e-01 ,3.4706e-01 , &
     &4.1739e-01 ,4.9016e-01 ,5.5457e-01 /)
      kao(:, 3, 6, 9) = (/ &
     &4.5887e-03 ,8.1094e-02 ,1.5254e-01 ,2.2684e-01 ,3.0254e-01 ,3.7858e-01 , &
     &4.5531e-01 ,5.3473e-01 ,6.0493e-01 /)
      kao(:, 4, 6, 9) = (/ &
     &4.7247e-03 ,8.6870e-02 ,1.6450e-01 ,2.4527e-01 ,3.2719e-01 ,4.0945e-01 , &
     &4.9240e-01 ,5.7834e-01 ,6.5421e-01 /)
      kao(:, 5, 6, 9) = (/ &
     &4.8692e-03 ,9.2597e-02 ,1.7638e-01 ,2.6357e-01 ,3.5163e-01 ,4.4001e-01 , &
     &5.2913e-01 ,6.2153e-01 ,7.0308e-01 /)
      kao(:, 1, 7, 9) = (/ &
     &7.8126e-03 ,6.9794e-02 ,1.1632e-01 ,1.6292e-01 ,2.1140e-01 ,2.6176e-01 , &
     &3.1398e-01 ,3.6765e-01 ,4.1782e-01 /)
      kao(:, 2, 7, 9) = (/ &
     &8.0155e-03 ,7.6059e-02 ,1.2742e-01 ,1.7989e-01 ,2.3439e-01 ,2.9098e-01 , &
     &3.4941e-01 ,4.0917e-01 ,4.6495e-01 /)
      kao(:, 3, 7, 9) = (/ &
     &8.2416e-03 ,8.1970e-02 ,1.3813e-01 ,1.9625e-01 ,2.5659e-01 ,3.1926e-01 , &
     &3.8354e-01 ,4.4917e-01 ,5.1030e-01 /)
      kao(:, 4, 7, 9) = (/ &
     &8.4921e-03 ,8.7603e-02 ,1.4873e-01 ,2.1252e-01 ,2.7865e-01 ,3.4736e-01 , &
     &4.1730e-01 ,4.8866e-01 ,5.5524e-01 /)
      kao(:, 5, 7, 9) = (/ &
     &8.7515e-03 ,9.3044e-02 ,1.5925e-01 ,2.2867e-01 ,3.0064e-01 ,3.7532e-01 , &
     &4.5091e-01 ,5.2808e-01 ,5.9993e-01 /)
      kao(:, 1, 8, 9) = (/ &
     &1.6603e-02 ,7.8794e-02 ,1.2181e-01 ,1.5872e-01 ,1.9167e-01 ,2.2528e-01 , &
     &2.6122e-01 ,3.0128e-01 ,3.4340e-01 /)
      kao(:, 2, 8, 9) = (/ &
     &1.7055e-02 ,8.5849e-02 ,1.3372e-01 ,1.7446e-01 ,2.1153e-01 ,2.5044e-01 , &
     &2.9195e-01 ,3.3805e-01 ,3.8527e-01 /)
      kao(:, 3, 8, 9) = (/ &
     &1.7594e-02 ,9.2738e-02 ,1.4493e-01 ,1.8895e-01 ,2.3080e-01 ,2.7486e-01 , &
     &3.2173e-01 ,3.7362e-01 ,4.2584e-01 /)
      kao(:, 4, 8, 9) = (/ &
     &1.8162e-02 ,9.9290e-02 ,1.5571e-01 ,2.0324e-01 ,2.5013e-01 ,2.9946e-01 , &
     &3.5175e-01 ,4.0935e-01 ,4.6655e-01 /)
      kao(:, 5, 8, 9) = (/ &
     &1.8749e-02 ,1.0557e-01 ,1.6622e-01 ,2.1745e-01 ,2.6934e-01 ,3.2386e-01 , &
     &3.8166e-01 ,4.4484e-01 ,5.0696e-01 /)
      kao(:, 1, 9, 9) = (/ &
     &6.5840e-02 ,1.3860e-01 ,1.7838e-01 ,2.0998e-01 ,2.3508e-01 ,2.5392e-01 , &
     &2.6499e-01 ,2.6488e-01 ,2.7801e-01 /)
      kao(:, 2, 9, 9) = (/ &
     &6.7872e-02 ,1.4849e-01 ,1.9371e-01 ,2.2975e-01 ,2.5869e-01 ,2.8072e-01 , &
     &2.9363e-01 ,2.9601e-01 ,3.1493e-01 /)
      kao(:, 3, 9, 9) = (/ &
     &7.0225e-02 ,1.5836e-01 ,2.0886e-01 ,2.4918e-01 ,2.8159e-01 ,3.0644e-01 , &
     &3.2072e-01 ,3.2657e-01 ,3.5112e-01 /)
      kao(:, 4, 9, 9) = (/ &
     &7.2560e-02 ,1.6804e-01 ,2.2356e-01 ,2.6776e-01 ,3.0359e-01 ,3.3128e-01 , &
     &3.4695e-01 ,3.5732e-01 ,3.8745e-01 /)
      kao(:, 5, 9, 9) = (/ &
     &7.5125e-02 ,1.7750e-01 ,2.3755e-01 ,2.8560e-01 ,3.2501e-01 ,3.5553e-01 , &
     &3.7247e-01 ,3.8768e-01 ,4.2319e-01 /)
      kao(:, 1,10, 9) = (/ &
     &2.8983e-01 ,3.6990e-01 ,4.0037e-01 ,4.0949e-01 ,4.0589e-01 ,3.9081e-01 , &
     &3.6404e-01 ,3.1914e-01 ,2.2264e-01 /)
      kao(:, 2,10, 9) = (/ &
     &2.9917e-01 ,3.8833e-01 ,4.2499e-01 ,4.3869e-01 ,4.3868e-01 ,4.2555e-01 , &
     &3.9991e-01 ,3.5416e-01 ,2.5485e-01 /)
      kao(:, 3,10, 9) = (/ &
     &3.0939e-01 ,4.0713e-01 ,4.4875e-01 ,4.6776e-01 ,4.7103e-01 ,4.6014e-01 , &
     &4.3525e-01 ,3.8827e-01 ,2.8738e-01 /)
      kao(:, 4,10, 9) = (/ &
     &3.2110e-01 ,4.2672e-01 ,4.7284e-01 ,4.9667e-01 ,5.0290e-01 ,4.9348e-01 , &
     &4.6953e-01 ,4.2184e-01 ,3.1974e-01 /)
      kao(:, 5,10, 9) = (/ &
     &3.3272e-01 ,4.4730e-01 ,4.9768e-01 ,5.2532e-01 ,5.3384e-01 ,5.2588e-01 , &
     &5.0287e-01 ,4.5423e-01 ,3.5166e-01 /)
      kao(:, 1,11, 9) = (/ &
     &4.4524e-01 ,5.1679e-01 ,5.3684e-01 ,5.3332e-01 ,5.1092e-01 ,4.7255e-01 , &
     &4.1877e-01 ,3.4229e-01 ,1.8048e-01 /)
      kao(:, 2,11, 9) = (/ &
     &4.5963e-01 ,5.4202e-01 ,5.6658e-01 ,5.6626e-01 ,5.4700e-01 ,5.0983e-01 , &
     &4.5605e-01 ,3.7725e-01 ,2.0742e-01 /)
      kao(:, 3,11, 9) = (/ &
     &4.7588e-01 ,5.6665e-01 ,5.9649e-01 ,5.9968e-01 ,5.8254e-01 ,5.4674e-01 , &
     &4.9265e-01 ,4.1176e-01 ,2.3443e-01 /)
      kao(:, 4,11, 9) = (/ &
     &4.9478e-01 ,5.9201e-01 ,6.2710e-01 ,6.3330e-01 ,6.1823e-01 ,5.8344e-01 , &
     &5.2842e-01 ,4.4573e-01 ,2.6065e-01 /)
      kao(:, 5,11, 9) = (/ &
     &5.1485e-01 ,6.2017e-01 ,6.5811e-01 ,6.6709e-01 ,6.5355e-01 ,6.1972e-01 , &
     &5.6393e-01 ,4.7838e-01 ,2.8720e-01 /)
      kao(:, 1,12, 9) = (/ &
     &5.0543e-01 ,5.6903e-01 ,5.8050e-01 ,5.7018e-01 ,5.4105e-01 ,4.9466e-01 , &
     &4.2828e-01 ,3.3843e-01 ,1.4652e-01 /)
      kao(:, 2,12, 9) = (/ &
     &5.2298e-01 ,5.9603e-01 ,6.1306e-01 ,6.0448e-01 ,5.7710e-01 ,5.3128e-01 , &
     &4.6400e-01 ,3.7149e-01 ,1.6865e-01 /)
      kao(:, 3,12, 9) = (/ &
     &5.4270e-01 ,6.2472e-01 ,6.4493e-01 ,6.3902e-01 ,6.1334e-01 ,5.6783e-01 , &
     &4.9936e-01 ,4.0428e-01 ,1.8993e-01 /)
      kao(:, 4,12, 9) = (/ &
     &5.6576e-01 ,6.5409e-01 ,6.7814e-01 ,6.7406e-01 ,6.4973e-01 ,6.0390e-01 , &
     &5.3494e-01 ,4.3628e-01 ,2.1164e-01 /)
      kao(:, 5,12, 9) = (/ &
     &5.9076e-01 ,6.8665e-01 ,7.1248e-01 ,7.0991e-01 ,6.8560e-01 ,6.4007e-01 , &
     &5.7053e-01 ,4.6743e-01 ,2.3320e-01 /)
      kao(:, 1,13, 9) = (/ &
     &4.5979e-01 ,5.1890e-01 ,5.2855e-01 ,5.1825e-01 ,4.9146e-01 ,4.4960e-01 , &
     &3.8971e-01 ,3.0598e-01 ,1.2566e-01 /)
      kao(:, 2,13, 9) = (/ &
     &4.7640e-01 ,5.4480e-01 ,5.5925e-01 ,5.5059e-01 ,5.2436e-01 ,4.8283e-01 , &
     &4.2163e-01 ,3.3565e-01 ,1.4550e-01 /)
      kao(:, 3,13, 9) = (/ &
     &4.9565e-01 ,5.7250e-01 ,5.8989e-01 ,5.8311e-01 ,5.5799e-01 ,5.1559e-01 , &
     &4.5382e-01 ,3.6511e-01 ,1.6523e-01 /)
      kao(:, 4,13, 9) = (/ &
     &5.1794e-01 ,6.0150e-01 ,6.2192e-01 ,6.1629e-01 ,5.9157e-01 ,5.4908e-01 , &
     &4.8624e-01 ,3.9414e-01 ,1.8408e-01 /)
      kao(:, 5,13, 9) = (/ &
     &5.4127e-01 ,6.3348e-01 ,6.5477e-01 ,6.5028e-01 ,6.2556e-01 ,5.8254e-01 , &
     &5.1808e-01 ,4.2264e-01 ,2.0283e-01 /)
      kao(:, 1, 1,10) = (/ &
     &6.5918e-04 ,3.4888e-01 ,6.9848e-01 ,1.0485e+00 ,1.4002e+00 ,1.7549e+00 , &
     &2.1190e+00 ,2.5078e+00 ,2.8004e+00 /)
      kao(:, 2, 1,10) = (/ &
     &6.7280e-04 ,3.7184e-01 ,7.4416e-01 ,1.1175e+00 ,1.4925e+00 ,1.8689e+00 , &
     &2.2475e+00 ,2.6390e+00 ,2.9850e+00 /)
      kao(:, 3, 1,10) = (/ &
     &6.8523e-04 ,3.9709e-01 ,7.9353e-01 ,1.1893e+00 ,1.5844e+00 ,1.9796e+00 , &
     &2.3755e+00 ,2.7728e+00 ,3.1689e+00 /)
      kao(:, 4, 1,10) = (/ &
     &6.9619e-04 ,4.2236e-01 ,8.4460e-01 ,1.2663e+00 ,1.6869e+00 ,2.1024e+00 , &
     &2.5075e+00 ,2.8990e+00 ,3.3737e+00 /)
      kao(:, 5, 1,10) = (/ &
     &7.0541e-04 ,4.4505e-01 ,8.9002e-01 ,1.3353e+00 ,1.7799e+00 ,2.2235e+00 , &
     &2.6534e+00 ,3.0275e+00 ,3.5598e+00 /)
      kao(:, 1, 2,10) = (/ &
     &1.0168e-03 ,3.3520e-01 ,6.7064e-01 ,1.0063e+00 ,1.3424e+00 ,1.6793e+00 , &
     &2.0199e+00 ,2.3746e+00 ,2.6847e+00 /)
      kao(:, 2, 2,10) = (/ &
     &1.0383e-03 ,3.6090e-01 ,7.2200e-01 ,1.0832e+00 ,1.4445e+00 ,1.8057e+00 , &
     &2.1681e+00 ,2.5457e+00 ,2.8891e+00 /)
      kao(:, 3, 2,10) = (/ &
     &1.0584e-03 ,3.8758e-01 ,7.7508e-01 ,1.1623e+00 ,1.5490e+00 ,1.9350e+00 , &
     &2.3176e+00 ,2.7064e+00 ,3.0980e+00 /)
      kao(:, 4, 2,10) = (/ &
     &1.0746e-03 ,4.1292e-01 ,8.2598e-01 ,1.2389e+00 ,1.6519e+00 ,2.0646e+00 , &
     &2.4744e+00 ,2.8678e+00 ,3.3037e+00 /)
      kao(:, 5, 2,10) = (/ &
     &1.0744e-03 ,4.3717e-01 ,8.7417e-01 ,1.3107e+00 ,1.7471e+00 ,2.1834e+00 , &
     &2.6192e+00 ,3.0444e+00 ,3.4941e+00 /)
      kao(:, 1, 3,10) = (/ &
     &2.0748e-03 ,3.1600e-01 ,6.3217e-01 ,9.4857e-01 ,1.2657e+00 ,1.5838e+00 , &
     &1.9039e+00 ,2.2287e+00 ,2.5314e+00 /)
      kao(:, 2, 3,10) = (/ &
     &2.1217e-03 ,3.4261e-01 ,6.8545e-01 ,1.0284e+00 ,1.3716e+00 ,1.7154e+00 , &
     &2.0606e+00 ,2.4138e+00 ,2.7432e+00 /)
      kao(:, 3, 3,10) = (/ &
     &2.1619e-03 ,3.6999e-01 ,7.4010e-01 ,1.1107e+00 ,1.4817e+00 ,1.8526e+00 , &
     &2.2240e+00 ,2.5942e+00 ,2.9634e+00 /)
      kao(:, 4, 3,10) = (/ &
     &2.1755e-03 ,3.9596e-01 ,7.9208e-01 ,1.1885e+00 ,1.5854e+00 ,1.9831e+00 , &
     &2.3825e+00 ,2.7842e+00 ,3.1709e+00 /)
      kao(:, 5, 3,10) = (/ &
     &2.1880e-03 ,4.2191e-01 ,8.4399e-01 ,1.2664e+00 ,1.6893e+00 ,2.1130e+00 , &
     &2.5373e+00 ,2.9615e+00 ,3.3787e+00 /)
      kao(:, 1, 4,10) = (/ &
     &4.2494e-03 ,2.8992e-01 ,5.8012e-01 ,8.7071e-01 ,1.1620e+00 ,1.4546e+00 , &
     &1.7505e+00 ,2.0568e+00 ,2.3239e+00 /)
      kao(:, 2, 4,10) = (/ &
     &4.3512e-03 ,3.1537e-01 ,6.3099e-01 ,9.4695e-01 ,1.2638e+00 ,1.5819e+00 , &
     &1.9039e+00 ,2.2390e+00 ,2.5276e+00 /)
      kao(:, 3, 4,10) = (/ &
     &4.4136e-03 ,3.4243e-01 ,6.8516e-01 ,1.0282e+00 ,1.3719e+00 ,1.7170e+00 , &
     &2.0650e+00 ,2.4245e+00 ,2.7438e+00 /)
      kao(:, 4, 4,10) = (/ &
     &4.4541e-03 ,3.6913e-01 ,7.3845e-01 ,1.1085e+00 ,1.4792e+00 ,1.8513e+00 , &
     &2.2276e+00 ,2.6166e+00 ,2.9583e+00 /)
      kao(:, 5, 4,10) = (/ &
     &4.4637e-03 ,3.9522e-01 ,7.9055e-01 ,1.1865e+00 ,1.5830e+00 ,1.9815e+00 , &
     &2.3838e+00 ,2.7994e+00 ,3.1659e+00 /)
      kao(:, 1, 5,10) = (/ &
     &7.8944e-03 ,2.6027e-01 ,5.2060e-01 ,7.8129e-01 ,1.0423e+00 ,1.3045e+00 , &
     &1.5691e+00 ,1.8427e+00 ,2.0845e+00 /)
      kao(:, 2, 5,10) = (/ &
     &8.0572e-03 ,2.8413e-01 ,5.6833e-01 ,8.5287e-01 ,1.1378e+00 ,1.4238e+00 , &
     &1.7119e+00 ,2.0096e+00 ,2.2754e+00 /)
      kao(:, 3, 5,10) = (/ &
     &8.1742e-03 ,3.1030e-01 ,6.2054e-01 ,9.3122e-01 ,1.2421e+00 ,1.5541e+00 , &
     &1.8685e+00 ,2.1911e+00 ,2.4841e+00 /)
      kao(:, 4, 5,10) = (/ &
     &8.2414e-03 ,3.3618e-01 ,6.7234e-01 ,1.0088e+00 ,1.3458e+00 ,1.6840e+00 , &
     &2.0247e+00 ,2.3758e+00 ,2.6915e+00 /)
      kao(:, 5, 5,10) = (/ &
     &8.3003e-03 ,3.6135e-01 ,7.2289e-01 ,1.0847e+00 ,1.4472e+00 ,1.8109e+00 , &
     &2.1782e+00 ,2.5572e+00 ,2.8943e+00 /)
      kao(:, 1, 6,10) = (/ &
     &1.3769e-02 ,2.2868e-01 ,4.5729e-01 ,6.8615e-01 ,9.1532e-01 ,1.1447e+00 , &
     &1.3758e+00 ,1.6126e+00 ,1.8305e+00 /)
      kao(:, 2, 6,10) = (/ &
     &1.4077e-02 ,2.5186e-01 ,5.0368e-01 ,7.5558e-01 ,1.0079e+00 ,1.2605e+00 , &
     &1.5146e+00 ,1.7737e+00 ,2.0155e+00 /)
      kao(:, 3, 6,10) = (/ &
     &1.4339e-02 ,2.7680e-01 ,5.5350e-01 ,8.3033e-01 ,1.1075e+00 ,1.3852e+00 , &
     &1.6642e+00 ,1.9484e+00 ,2.2148e+00 /)
      kao(:, 4, 6,10) = (/ &
     &1.4519e-02 ,3.0142e-01 ,6.0270e-01 ,9.0418e-01 ,1.2061e+00 ,1.5083e+00 , &
     &1.8129e+00 ,2.1232e+00 ,2.4121e+00 /)
      kao(:, 5, 6,10) = (/ &
     &1.4692e-02 ,3.2398e-01 ,6.4788e-01 ,9.7210e-01 ,1.2967e+00 ,1.6219e+00 , &
     &1.9490e+00 ,2.2841e+00 ,2.5932e+00 /)
      kao(:, 1, 7,10) = (/ &
     &2.5736e-02 ,2.1730e-01 ,3.9499e-01 ,5.9240e-01 ,7.9003e-01 ,9.8783e-01 , &
     &1.1864e+00 ,1.3877e+00 ,1.5798e+00 /)
      kao(:, 2, 7,10) = (/ &
     &2.6391e-02 ,2.3410e-01 ,4.4100e-01 ,6.6147e-01 ,8.8204e-01 ,1.1029e+00 , &
     &1.3242e+00 ,1.5482e+00 ,1.7637e+00 /)
      kao(:, 3, 7,10) = (/ &
     &2.6951e-02 ,2.5201e-01 ,4.8957e-01 ,7.3433e-01 ,9.7905e-01 ,1.2243e+00 , &
     &1.4699e+00 ,1.7185e+00 ,1.9578e+00 /)
      kao(:, 4, 7,10) = (/ &
     &2.7390e-02 ,2.7020e-01 ,5.3407e-01 ,8.0106e-01 ,1.0682e+00 ,1.3359e+00 , &
     &1.6042e+00 ,1.8761e+00 ,2.1361e+00 /)
      kao(:, 5, 7,10) = (/ &
     &2.8064e-02 ,2.8861e-01 ,5.7611e-01 ,8.6397e-01 ,1.1521e+00 ,1.4408e+00 , &
     &1.7300e+00 ,2.0229e+00 ,2.3040e+00 /)
      kao(:, 1, 8,10) = (/ &
     &5.8578e-02 ,2.6880e-01 ,4.0001e-01 ,5.2061e-01 ,6.7938e-01 ,8.4922e-01 , &
     &1.0194e+00 ,1.1905e+00 ,1.3581e+00 /)
      kao(:, 2, 8,10) = (/ &
     &6.0087e-02 ,2.9139e-01 ,4.3501e-01 ,5.7583e-01 ,7.6491e-01 ,9.5619e-01 , &
     &1.1477e+00 ,1.3402e+00 ,1.5292e+00 /)
      kao(:, 3, 8,10) = (/ &
     &6.1083e-02 ,3.1400e-01 ,4.7010e-01 ,6.4266e-01 ,8.5685e-01 ,1.0710e+00 , &
     &1.2856e+00 ,1.5014e+00 ,1.7131e+00 /)
      kao(:, 4, 8,10) = (/ &
     &6.2072e-02 ,3.3715e-01 ,5.0004e-01 ,7.0498e-01 ,9.3980e-01 ,1.1748e+00 , &
     &1.4102e+00 ,1.6468e+00 ,1.8789e+00 /)
      kao(:, 5, 8,10) = (/ &
     &6.3481e-02 ,3.5691e-01 ,5.2888e-01 ,7.6432e-01 ,1.0191e+00 ,1.2740e+00 , &
     &1.5290e+00 ,1.7860e+00 ,2.0375e+00 /)
      kao(:, 1, 9,10) = (/ &
     &2.5051e-01 ,4.8216e-01 ,6.3956e-01 ,7.5081e-01 ,8.3417e-01 ,8.8639e-01 , &
     &9.0389e-01 ,1.0106e+00 ,1.1541e+00 /)
      kao(:, 2, 9,10) = (/ &
     &2.5603e-01 ,5.1856e-01 ,6.9227e-01 ,8.2007e-01 ,9.1537e-01 ,9.7189e-01 , &
     &9.9778e-01 ,1.1454e+00 ,1.3083e+00 /)
      kao(:, 3, 9,10) = (/ &
     &2.6013e-01 ,5.5198e-01 ,7.4416e-01 ,8.8806e-01 ,9.9547e-01 ,1.0583e+00 , &
     &1.1091e+00 ,1.2896e+00 ,1.4729e+00 /)
      kao(:, 4, 9,10) = (/ &
     &2.6455e-01 ,5.8224e-01 ,7.9653e-01 ,9.5696e-01 ,1.0752e+00 ,1.1310e+00 , &
     &1.2203e+00 ,1.4235e+00 ,1.6258e+00 /)
      kao(:, 5, 9,10) = (/ &
     &2.6779e-01 ,6.1167e-01 ,8.4854e-01 ,1.0208e+00 ,1.1434e+00 ,1.1964e+00 , &
     &1.3330e+00 ,1.5553e+00 ,1.7761e+00 /)
      kao(:, 1,10,10) = (/ &
     &1.1877e+00 ,1.3423e+00 ,1.4114e+00 ,1.4638e+00 ,1.4747e+00 ,1.4384e+00 , &
     &1.3561e+00 ,1.1884e+00 ,9.6724e-01 /)
      kao(:, 2,10,10) = (/ &
     &1.2130e+00 ,1.4001e+00 ,1.4986e+00 ,1.5677e+00 ,1.5910e+00 ,1.5689e+00 , &
     &1.4918e+00 ,1.3127e+00 ,1.1039e+00 /)
      kao(:, 3,10,10) = (/ &
     &1.2346e+00 ,1.4593e+00 ,1.5877e+00 ,1.6627e+00 ,1.7012e+00 ,1.6974e+00 , &
     &1.6231e+00 ,1.4376e+00 ,1.2384e+00 /)
      kao(:, 4,10,10) = (/ &
     &1.2516e+00 ,1.5151e+00 ,1.6747e+00 ,1.7501e+00 ,1.8076e+00 ,1.8250e+00 , &
     &1.7537e+00 ,1.5512e+00 ,1.3735e+00 /)
      kao(:, 5,10,10) = (/ &
     &1.2661e+00 ,1.5638e+00 ,1.7522e+00 ,1.8374e+00 ,1.9121e+00 ,1.9420e+00 , &
     &1.8736e+00 ,1.6582e+00 ,1.5128e+00 /)
      kao(:, 1,11,10) = (/ &
     &1.9480e+00 ,2.0492e+00 ,2.0295e+00 ,1.9735e+00 ,1.8970e+00 ,1.7736e+00 , &
     &1.5866e+00 ,1.3339e+00 ,8.4829e-01 /)
      kao(:, 2,11,10) = (/ &
     &1.9908e+00 ,2.1211e+00 ,2.1260e+00 ,2.0949e+00 ,2.0240e+00 ,1.9060e+00 , &
     &1.7325e+00 ,1.4683e+00 ,9.6828e-01 /)
      kao(:, 3,11,10) = (/ &
     &2.0285e+00 ,2.1879e+00 ,2.2239e+00 ,2.2116e+00 ,2.1470e+00 ,2.0366e+00 , &
     &1.8735e+00 ,1.6014e+00 ,1.0930e+00 /)
      kao(:, 4,11,10) = (/ &
     &2.0556e+00 ,2.2562e+00 ,2.3222e+00 ,2.3233e+00 ,2.2648e+00 ,2.1592e+00 , &
     &2.0072e+00 ,1.7228e+00 ,1.2296e+00 /)
      kao(:, 5,11,10) = (/ &
     &2.0825e+00 ,2.3069e+00 ,2.4192e+00 ,2.4269e+00 ,2.3834e+00 ,2.2768e+00 , &
     &2.1248e+00 ,1.8445e+00 ,1.3568e+00 /)
      kao(:, 1,12,10) = (/ &
     &2.3362e+00 ,2.4153e+00 ,2.3669e+00 ,2.2577e+00 ,2.1055e+00 ,1.9147e+00 , &
     &1.6820e+00 ,1.3486e+00 ,7.4407e-01 /)
      kao(:, 2,12,10) = (/ &
     &2.3893e+00 ,2.4937e+00 ,2.4670e+00 ,2.3773e+00 ,2.2296e+00 ,2.0482e+00 , &
     &1.8201e+00 ,1.4800e+00 ,8.5242e-01 /)
      kao(:, 3,12,10) = (/ &
     &2.4357e+00 ,2.5702e+00 ,2.5666e+00 ,2.4887e+00 ,2.3537e+00 ,2.1812e+00 , &
     &1.9511e+00 ,1.6049e+00 ,9.6662e-01 /)
      kao(:, 4,12,10) = (/ &
     &2.4652e+00 ,2.6456e+00 ,2.6664e+00 ,2.5981e+00 ,2.4742e+00 ,2.3104e+00 , &
     &2.0695e+00 ,1.7245e+00 ,1.0828e+00 /)
      kao(:, 5,12,10) = (/ &
     &2.4945e+00 ,2.7001e+00 ,2.7645e+00 ,2.7014e+00 ,2.5936e+00 ,2.4312e+00 , &
     &2.1779e+00 ,1.8427e+00 ,1.2015e+00 /)
      kao(:, 1,13,10) = (/ &
     &2.2054e+00 ,2.3120e+00 ,2.2775e+00 ,2.1807e+00 ,2.0276e+00 ,1.8297e+00 , &
     &1.5931e+00 ,1.2531e+00 ,5.9202e-01 /)
      kao(:, 2,13,10) = (/ &
     &2.2559e+00 ,2.3878e+00 ,2.3725e+00 ,2.2888e+00 ,2.1438e+00 ,1.9536e+00 , &
     &1.7172e+00 ,1.3694e+00 ,6.7488e-01 /)
      kao(:, 3,13,10) = (/ &
     &2.2951e+00 ,2.4612e+00 ,2.4689e+00 ,2.3923e+00 ,2.2596e+00 ,2.0732e+00 , &
     &1.8332e+00 ,1.4777e+00 ,7.6019e-01 /)
      kao(:, 4,13,10) = (/ &
     &2.3235e+00 ,2.5286e+00 ,2.5591e+00 ,2.4947e+00 ,2.3722e+00 ,2.1862e+00 , &
     &1.9383e+00 ,1.5857e+00 ,8.5248e-01 /)
      kao(:, 5,13,10) = (/ &
     &2.3616e+00 ,2.5838e+00 ,2.6490e+00 ,2.5951e+00 ,2.4760e+00 ,2.2908e+00 , &
     &2.0454e+00 ,1.6895e+00 ,9.4490e-01 /)
      kao(:, 1, 1,11) = (/ &
     &9.3294e-04 ,5.3309e-01 ,1.0647e+00 ,1.5932e+00 ,2.1160e+00 ,2.6255e+00 , &
     &3.0986e+00 ,3.3968e+00 ,4.2319e+00 /)
      kao(:, 2, 1,11) = (/ &
     &9.5345e-04 ,5.6455e-01 ,1.1277e+00 ,1.6875e+00 ,2.2413e+00 ,2.7825e+00 , &
     &3.2884e+00 ,3.6383e+00 ,4.4826e+00 /)
      kao(:, 3, 1,11) = (/ &
     &9.7241e-04 ,5.9098e-01 ,1.1810e+00 ,1.7692e+00 ,2.3540e+00 ,2.9286e+00 , &
     &3.4675e+00 ,3.8516e+00 ,4.7080e+00 /)
      kao(:, 4, 1,11) = (/ &
     &9.8984e-04 ,6.1800e-01 ,1.2338e+00 ,1.8462e+00 ,2.4536e+00 ,3.0526e+00 , &
     &3.6266e+00 ,4.0600e+00 ,4.9071e+00 /)
      kao(:, 5, 1,11) = (/ &
     &1.0059e-03 ,6.4816e-01 ,1.2933e+00 ,1.9339e+00 ,2.5658e+00 ,3.1822e+00 , &
     &3.7668e+00 ,4.2510e+00 ,5.1316e+00 /)
      kao(:, 1, 2,11) = (/ &
     &1.5074e-03 ,5.1913e-01 ,1.0387e+00 ,1.5585e+00 ,2.0790e+00 ,2.5998e+00 , &
     &3.1169e+00 ,3.5984e+00 ,4.1578e+00 /)
      kao(:, 2, 2,11) = (/ &
     &1.5417e-03 ,5.5254e-01 ,1.1053e+00 ,1.6578e+00 ,2.2101e+00 ,2.7629e+00 , &
     &3.3129e+00 ,3.8170e+00 ,4.4201e+00 /)
      kao(:, 3, 2,11) = (/ &
     &1.5713e-03 ,5.8438e-01 ,1.1685e+00 ,1.7524e+00 ,2.3358e+00 ,2.9174e+00 , &
     &3.4950e+00 ,4.0242e+00 ,4.6716e+00 /)
      kao(:, 4, 2,11) = (/ &
     &1.5983e-03 ,6.1743e-01 ,1.2340e+00 ,1.8490e+00 ,2.4617e+00 ,3.0691e+00 , &
     &3.6659e+00 ,4.2202e+00 ,4.9233e+00 /)
      kao(:, 5, 2,11) = (/ &
     &1.6216e-03 ,6.5216e-01 ,1.3030e+00 ,1.9521e+00 ,2.5969e+00 ,3.2326e+00 , &
     &3.8472e+00 ,4.4004e+00 ,5.1936e+00 /)
      kao(:, 1, 3,11) = (/ &
     &3.2100e-03 ,4.8846e-01 ,9.7712e-01 ,1.4663e+00 ,1.9565e+00 ,2.4483e+00 , &
     &2.9445e+00 ,3.4602e+00 ,3.9130e+00 /)
      kao(:, 2, 3,11) = (/ &
     &3.2832e-03 ,5.2715e-01 ,1.0544e+00 ,1.5820e+00 ,2.1102e+00 ,2.6392e+00 , &
     &3.1691e+00 ,3.7028e+00 ,4.2204e+00 /)
      kao(:, 3, 3,11) = (/ &
     &3.3509e-03 ,5.6319e-01 ,1.1265e+00 ,1.6900e+00 ,2.2533e+00 ,2.8179e+00 , &
     &3.3838e+00 ,3.9526e+00 ,4.5066e+00 /)
      kao(:, 4, 3,11) = (/ &
     &3.4122e-03 ,6.0075e-01 ,1.2012e+00 ,1.8012e+00 ,2.4005e+00 ,2.9988e+00 , &
     &3.5947e+00 ,4.1839e+00 ,4.8011e+00 /)
      kao(:, 5, 3,11) = (/ &
     &3.4694e-03 ,6.3990e-01 ,1.2794e+00 ,1.9184e+00 ,2.5559e+00 ,3.1911e+00 , &
     &3.8197e+00 ,4.4273e+00 ,5.1119e+00 /)
      kao(:, 1, 4,11) = (/ &
     &6.8944e-03 ,4.5524e-01 ,9.1034e-01 ,1.3656e+00 ,1.8210e+00 ,2.2768e+00 , &
     &2.7339e+00 ,3.1966e+00 ,3.6419e+00 /)
      kao(:, 2, 4,11) = (/ &
     &7.0719e-03 ,4.9844e-01 ,9.9694e-01 ,1.4955e+00 ,1.9943e+00 ,2.4932e+00 , &
     &2.9929e+00 ,3.4921e+00 ,3.9886e+00 /)
      kao(:, 3, 4,11) = (/ &
     &7.2326e-03 ,5.3850e-01 ,1.0768e+00 ,1.6152e+00 ,2.1534e+00 ,2.6917e+00 , &
     &3.2302e+00 ,3.7700e+00 ,4.3067e+00 /)
      kao(:, 4, 4,11) = (/ &
     &7.3806e-03 ,5.7980e-01 ,1.1594e+00 ,1.7389e+00 ,2.3180e+00 ,2.8967e+00 , &
     &3.4739e+00 ,4.0439e+00 ,4.6359e+00 /)
      kao(:, 5, 4,11) = (/ &
     &7.4998e-03 ,6.1978e-01 ,1.2395e+00 ,1.8590e+00 ,2.4785e+00 ,3.0979e+00 , &
     &3.7146e+00 ,4.3244e+00 ,4.9568e+00 /)
      kao(:, 1, 5,11) = (/ &
     &1.3442e-02 ,4.2037e-01 ,8.4065e-01 ,1.2612e+00 ,1.6819e+00 ,2.1029e+00 , &
     &2.5255e+00 ,2.9520e+00 ,3.3637e+00 /)
      kao(:, 2, 5,11) = (/ &
     &1.3797e-02 ,4.6626e-01 ,9.3234e-01 ,1.3987e+00 ,1.8650e+00 ,2.3319e+00 , &
     &2.7996e+00 ,3.2699e+00 ,3.7300e+00 /)
      kao(:, 3, 5,11) = (/ &
     &1.4112e-02 ,5.0925e-01 ,1.0185e+00 ,1.5280e+00 ,2.0375e+00 ,2.5478e+00 , &
     &3.0591e+00 ,3.5748e+00 ,4.0749e+00 /)
      kao(:, 4, 5,11) = (/ &
     &1.4385e-02 ,5.5077e-01 ,1.1015e+00 ,1.6526e+00 ,2.2034e+00 ,2.7548e+00 , &
     &3.3072e+00 ,3.8625e+00 ,4.4066e+00 /)
      kao(:, 5, 5,11) = (/ &
     &1.4645e-02 ,5.9271e-01 ,1.1855e+00 ,1.7781e+00 ,2.3710e+00 ,2.9641e+00 , &
     &3.5574e+00 ,4.1512e+00 ,4.7419e+00 /)
      kao(:, 1, 6,11) = (/ &
     &2.4122e-02 ,3.8084e-01 ,7.6147e-01 ,1.1422e+00 ,1.5231e+00 ,1.9045e+00 , &
     &2.2870e+00 ,2.6730e+00 ,3.0460e+00 /)
      kao(:, 2, 6,11) = (/ &
     &2.4797e-02 ,4.2571e-01 ,8.5136e-01 ,1.2771e+00 ,1.7031e+00 ,2.1298e+00 , &
     &2.5578e+00 ,2.9908e+00 ,3.4060e+00 /)
      kao(:, 3, 6,11) = (/ &
     &2.5418e-02 ,4.6778e-01 ,9.3545e-01 ,1.4036e+00 ,1.8720e+00 ,2.3409e+00 , &
     &2.8115e+00 ,3.2888e+00 ,3.7438e+00 /)
      kao(:, 4, 6,11) = (/ &
     &2.5988e-02 ,5.1023e-01 ,1.0205e+00 ,1.5308e+00 ,2.0415e+00 ,2.5527e+00 , &
     &3.0658e+00 ,3.5842e+00 ,4.0828e+00 /)
      kao(:, 5, 6,11) = (/ &
     &2.6439e-02 ,5.5329e-01 ,1.1066e+00 ,1.6600e+00 ,2.2137e+00 ,2.7680e+00 , &
     &3.3240e+00 ,3.8852e+00 ,4.4272e+00 /)
      kao(:, 1, 7,11) = (/ &
     &4.4902e-02 ,3.4110e-01 ,6.7879e-01 ,1.0183e+00 ,1.3577e+00 ,1.6974e+00 , &
     &2.0380e+00 ,2.3811e+00 ,2.7150e+00 /)
      kao(:, 2, 7,11) = (/ &
     &4.6257e-02 ,3.7900e-01 ,7.5783e-01 ,1.1366e+00 ,1.5157e+00 ,1.8951e+00 , &
     &2.2756e+00 ,2.6593e+00 ,3.0311e+00 /)
      kao(:, 3, 7,11) = (/ &
     &4.7417e-02 ,4.1838e-01 ,8.3644e-01 ,1.2549e+00 ,1.6732e+00 ,2.0920e+00 , &
     &2.5119e+00 ,2.9363e+00 ,3.3461e+00 /)
      kao(:, 4, 7,11) = (/ &
     &4.8439e-02 ,4.5979e-01 ,9.1922e-01 ,1.3788e+00 ,1.8387e+00 ,2.2989e+00 , &
     &2.7602e+00 ,3.2261e+00 ,3.6771e+00 /)
      kao(:, 5, 7,11) = (/ &
     &4.9115e-02 ,5.0257e-01 ,1.0048e+00 ,1.5073e+00 ,2.0099e+00 ,2.5129e+00 , &
     &3.0174e+00 ,3.5268e+00 ,4.0195e+00 /)
      kao(:, 1, 8,11) = (/ &
     &9.9346e-02 ,4.0741e-01 ,6.1474e-01 ,8.8954e-01 ,1.1859e+00 ,1.4823e+00 , &
     &1.7793e+00 ,2.0775e+00 ,2.3709e+00 /)
      kao(:, 2, 8,11) = (/ &
     &1.0236e-01 ,4.4079e-01 ,6.7253e-01 ,9.9766e-01 ,1.3301e+00 ,1.6626e+00 , &
     &1.9955e+00 ,2.3301e+00 ,2.6593e+00 /)
      kao(:, 3, 8,11) = (/ &
     &1.0516e-01 ,4.6951e-01 ,7.3794e-01 ,1.1060e+00 ,1.4745e+00 ,1.8432e+00 , &
     &2.2125e+00 ,2.5835e+00 ,2.9480e+00 /)
      kao(:, 4, 8,11) = (/ &
     &1.0772e-01 ,4.9500e-01 ,8.1532e-01 ,1.2227e+00 ,1.6302e+00 ,2.0375e+00 , &
     &2.4456e+00 ,2.8562e+00 ,3.2595e+00 /)
      kao(:, 5, 8,11) = (/ &
     &1.0947e-01 ,5.2130e-01 ,8.9659e-01 ,1.3445e+00 ,1.7925e+00 ,2.2406e+00 , &
     &2.6897e+00 ,3.1404e+00 ,3.5840e+00 /)
      kao(:, 1, 9,11) = (/ &
     &4.1823e-01 ,7.9567e-01 ,1.0382e+00 ,1.1972e+00 ,1.2989e+00 ,1.3526e+00 , &
     &1.5261e+00 ,1.7800e+00 ,2.0331e+00 /)
      kao(:, 2, 9,11) = (/ &
     &4.3170e-01 ,8.4637e-01 ,1.1195e+00 ,1.3007e+00 ,1.4025e+00 ,1.4821e+00 , &
     &1.7319e+00 ,2.0202e+00 ,2.3074e+00 /)
      kao(:, 3, 9,11) = (/ &
     &4.4387e-01 ,8.9320e-01 ,1.1954e+00 ,1.3918e+00 ,1.4965e+00 ,1.6263e+00 , &
     &1.9385e+00 ,2.2615e+00 ,2.5830e+00 /)
      kao(:, 4, 9,11) = (/ &
     &4.5501e-01 ,9.4246e-01 ,1.2607e+00 ,1.4727e+00 ,1.5878e+00 ,1.7989e+00 , &
     &2.1575e+00 ,2.5169e+00 ,2.8754e+00 /)
      kao(:, 5, 9,11) = (/ &
     &4.6515e-01 ,9.9000e-01 ,1.3196e+00 ,1.5528e+00 ,1.6906e+00 ,1.9810e+00 , &
     &2.3767e+00 ,2.7728e+00 ,3.1676e+00 /)
      kao(:, 1,10,11) = (/ &
     &1.9805e+00 ,2.2049e+00 ,2.3763e+00 ,2.4479e+00 ,2.4732e+00 ,2.4264e+00 , &
     &2.2604e+00 ,1.8802e+00 ,1.7493e+00 /)
      kao(:, 2,10,11) = (/ &
     &2.0472e+00 ,2.3153e+00 ,2.5048e+00 ,2.6141e+00 ,2.6517e+00 ,2.6235e+00 , &
     &2.4547e+00 ,2.0470e+00 ,2.0043e+00 /)
      kao(:, 3,10,11) = (/ &
     &2.1094e+00 ,2.4143e+00 ,2.6357e+00 ,2.7700e+00 ,2.8309e+00 ,2.7965e+00 , &
     &2.6317e+00 ,2.2035e+00 ,2.2660e+00 /)
      kao(:, 4,10,11) = (/ &
     &2.1647e+00 ,2.5051e+00 ,2.7487e+00 ,2.9276e+00 ,2.9982e+00 ,2.9552e+00 , &
     &2.7953e+00 ,2.3731e+00 ,2.5329e+00 /)
      kao(:, 5,10,11) = (/ &
     &2.2155e+00 ,2.5942e+00 ,2.8618e+00 ,3.0775e+00 ,3.1500e+00 ,3.1109e+00 , &
     &2.9560e+00 ,2.5540e+00 ,2.7905e+00 /)
      kao(:, 1,11,11) = (/ &
     &3.3272e+00 ,3.3391e+00 ,3.4265e+00 ,3.3299e+00 ,3.1864e+00 ,3.0000e+00 , &
     &2.7382e+00 ,2.2548e+00 ,1.5937e+00 /)
      kao(:, 2,11,11) = (/ &
     &3.4245e+00 ,3.4923e+00 ,3.5888e+00 ,3.5207e+00 ,3.3952e+00 ,3.2270e+00 , &
     &2.9458e+00 ,2.4552e+00 ,1.8248e+00 /)
      kao(:, 3,11,11) = (/ &
     &3.5147e+00 ,3.6350e+00 ,3.7493e+00 ,3.6979e+00 ,3.6003e+00 ,3.4366e+00 , &
     &3.1408e+00 ,2.6446e+00 ,2.0543e+00 /)
      kao(:, 4,11,11) = (/ &
     &3.5973e+00 ,3.7611e+00 ,3.8955e+00 ,3.8697e+00 ,3.7999e+00 ,3.6320e+00 , &
     &3.3291e+00 ,2.8219e+00 ,2.2769e+00 /)
      kao(:, 5,11,11) = (/ &
     &3.6658e+00 ,3.8812e+00 ,4.0226e+00 ,4.0479e+00 ,3.9815e+00 ,3.8145e+00 , &
     &3.5185e+00 ,2.9782e+00 ,2.4861e+00 /)
      kao(:, 1,12,11) = (/ &
     &4.1187e+00 ,4.0374e+00 ,4.0352e+00 ,3.8356e+00 ,3.5772e+00 ,3.2668e+00 , &
     &2.8837e+00 ,2.3539e+00 ,1.4349e+00 /)
      kao(:, 2,12,11) = (/ &
     &4.2212e+00 ,4.1986e+00 ,4.2178e+00 ,4.0426e+00 ,3.8006e+00 ,3.4932e+00 , &
     &3.0942e+00 ,2.5554e+00 ,1.6369e+00 /)
      kao(:, 3,12,11) = (/ &
     &4.3153e+00 ,4.3421e+00 ,4.3917e+00 ,4.2429e+00 ,4.0161e+00 ,3.6975e+00 , &
     &3.3039e+00 ,2.7454e+00 ,1.8396e+00 /)
      kao(:, 4,12,11) = (/ &
     &4.3996e+00 ,4.4753e+00 ,4.5481e+00 ,4.4345e+00 ,4.2153e+00 ,3.8944e+00 , &
     &3.5079e+00 ,2.9264e+00 ,2.0403e+00 /)
      kao(:, 5,12,11) = (/ &
     &4.4754e+00 ,4.5978e+00 ,4.6899e+00 ,4.6220e+00 ,4.4006e+00 ,4.0838e+00 , &
     &3.7036e+00 ,3.0926e+00 ,2.2349e+00 /)
      kao(:, 1,13,11) = (/ &
     &4.0592e+00 ,4.0332e+00 ,3.9681e+00 ,3.7590e+00 ,3.4963e+00 ,3.1626e+00 , &
     &2.7397e+00 ,2.2238e+00 ,1.2732e+00 /)
      kao(:, 2,13,11) = (/ &
     &4.1472e+00 ,4.1742e+00 ,4.1368e+00 ,3.9606e+00 ,3.7120e+00 ,3.3731e+00 , &
     &2.9427e+00 ,2.4115e+00 ,1.4537e+00 /)
      kao(:, 3,13,11) = (/ &
     &4.2292e+00 ,4.3011e+00 ,4.2979e+00 ,4.1507e+00 ,3.9119e+00 ,3.5700e+00 , &
     &3.1423e+00 ,2.5914e+00 ,1.6282e+00 /)
      kao(:, 4,13,11) = (/ &
     &4.3001e+00 ,4.4170e+00 ,4.4457e+00 ,4.3341e+00 ,4.0986e+00 ,3.7637e+00 , &
     &3.3341e+00 ,2.7592e+00 ,1.8128e+00 /)
      kao(:, 5,13,11) = (/ &
     &4.3627e+00 ,4.5278e+00 ,4.5856e+00 ,4.5011e+00 ,4.2740e+00 ,3.9472e+00 , &
     &3.5112e+00 ,2.9185e+00 ,1.9901e+00 /)
      kao(:, 1, 1,12) = (/ &
     &1.2832e-03 ,7.6911e-01 ,1.5308e+00 ,2.2815e+00 ,3.0131e+00 ,3.7102e+00 , &
     &4.3339e+00 ,4.8156e+00 ,6.0262e+00 /)
      kao(:, 2, 1,12) = (/ &
     &1.3165e-03 ,8.3137e-01 ,1.6545e+00 ,2.4655e+00 ,3.2561e+00 ,4.0092e+00 , &
     &4.6800e+00 ,5.1382e+00 ,6.5123e+00 /)
      kao(:, 3, 1,12) = (/ &
     &1.3465e-03 ,8.9467e-01 ,1.7805e+00 ,2.6534e+00 ,3.5040e+00 ,4.3130e+00 , &
     &5.0270e+00 ,5.5081e+00 ,7.0080e+00 /)
      kao(:, 4, 1,12) = (/ &
     &1.3733e-03 ,9.5420e-01 ,1.9011e+00 ,2.8343e+00 ,3.7449e+00 ,4.6125e+00 , &
     &5.3804e+00 ,5.8655e+00 ,7.4899e+00 /)
      kao(:, 5, 1,12) = (/ &
     &1.3973e-03 ,1.0065e+00 ,2.0056e+00 ,2.9931e+00 ,3.9616e+00 ,4.8908e+00 , &
     &5.7173e+00 ,6.2206e+00 ,7.9232e+00 /)
      kao(:, 1, 2,12) = (/ &
     &2.1567e-03 ,7.9503e-01 ,1.5851e+00 ,2.3675e+00 ,3.1367e+00 ,3.8805e+00 , &
     &4.5651e+00 ,5.0566e+00 ,6.2733e+00 /)
      kao(:, 2, 2,12) = (/ &
     &2.2096e-03 ,8.5765e-01 ,1.7102e+00 ,2.5549e+00 ,3.3862e+00 ,4.1922e+00 , &
     &4.9361e+00 ,5.4818e+00 ,6.7723e+00 /)
      kao(:, 3, 2,12) = (/ &
     &2.2593e-03 ,9.2132e-01 ,1.8371e+00 ,2.7441e+00 ,3.6360e+00 ,4.5001e+00 , &
     &5.3023e+00 ,5.9092e+00 ,7.2719e+00 /)
      kao(:, 4, 2,12) = (/ &
     &2.3029e-03 ,9.7961e-01 ,1.9547e+00 ,2.9227e+00 ,3.8771e+00 ,4.8047e+00 , &
     &5.6684e+00 ,6.3211e+00 ,7.7542e+00 /)
      kao(:, 5, 2,12) = (/ &
     &2.3432e-03 ,1.0294e+00 ,2.0551e+00 ,3.0745e+00 ,4.0831e+00 ,5.0720e+00 , &
     &6.0082e+00 ,6.7230e+00 ,8.1662e+00 /)
      kao(:, 1, 3,12) = (/ &
     &4.8280e-03 ,7.9900e-01 ,1.5962e+00 ,2.3906e+00 ,3.1803e+00 ,3.9604e+00 , &
     &4.7157e+00 ,5.3732e+00 ,6.3605e+00 /)
      kao(:, 2, 3,12) = (/ &
     &4.9522e-03 ,8.6159e-01 ,1.7217e+00 ,2.5790e+00 ,3.4316e+00 ,4.2766e+00 , &
     &5.0979e+00 ,5.8264e+00 ,6.8633e+00 /)
      kao(:, 3, 3,12) = (/ &
     &5.0521e-03 ,9.2450e-01 ,1.8472e+00 ,2.7674e+00 ,3.6829e+00 ,4.5888e+00 , &
     &5.4724e+00 ,6.2581e+00 ,7.3659e+00 /)
      kao(:, 4, 3,12) = (/ &
     &5.1417e-03 ,9.8492e-01 ,1.9684e+00 ,2.9494e+00 ,3.9267e+00 ,4.8950e+00 , &
     &5.8398e+00 ,6.6855e+00 ,7.8533e+00 /)
      kao(:, 5, 3,12) = (/ &
     &5.2128e-03 ,1.0351e+00 ,2.0685e+00 ,3.1013e+00 ,4.1304e+00 ,5.1536e+00 , &
     &6.1563e+00 ,7.0696e+00 ,8.2608e+00 /)
      kao(:, 1, 4,12) = (/ &
     &1.0891e-02 ,7.7727e-01 ,1.5543e+00 ,2.3309e+00 ,3.1067e+00 ,3.8812e+00 , &
     &4.6512e+00 ,5.4004e+00 ,6.2133e+00 /)
      kao(:, 2, 4,12) = (/ &
     &1.1146e-02 ,8.4013e-01 ,1.6801e+00 ,2.5195e+00 ,3.3588e+00 ,4.1965e+00 , &
     &5.0315e+00 ,5.8522e+00 ,6.7175e+00 /)
      kao(:, 3, 4,12) = (/ &
     &1.1369e-02 ,9.0347e-01 ,1.8066e+00 ,2.7094e+00 ,3.6116e+00 ,4.5128e+00 , &
     &5.4097e+00 ,6.2868e+00 ,7.2231e+00 /)
      kao(:, 4, 4,12) = (/ &
     &1.1543e-02 ,9.6345e-01 ,1.9267e+00 ,2.8898e+00 ,3.8526e+00 ,4.8146e+00 , &
     &5.7741e+00 ,6.7146e+00 ,7.7051e+00 /)
      kao(:, 5, 4,12) = (/ &
     &1.1696e-02 ,1.0158e+00 ,2.0314e+00 ,3.0468e+00 ,4.0618e+00 ,5.0772e+00 , &
     &6.0909e+00 ,7.0982e+00 ,8.1235e+00 /)
      kao(:, 1, 5,12) = (/ &
     &2.2302e-02 ,7.3490e-01 ,1.4696e+00 ,2.2046e+00 ,2.9394e+00 ,3.6745e+00 , &
     &4.4097e+00 ,5.1450e+00 ,5.8787e+00 /)
      kao(:, 2, 5,12) = (/ &
     &2.2823e-02 ,7.9768e-01 ,1.5952e+00 ,2.3932e+00 ,3.1913e+00 ,3.9900e+00 , &
     &4.7899e+00 ,5.5934e+00 ,6.3823e+00 /)
      kao(:, 3, 5,12) = (/ &
     &2.3280e-02 ,8.5775e-01 ,1.7153e+00 ,2.5734e+00 ,3.4313e+00 ,4.2902e+00 , &
     &5.1502e+00 ,6.0153e+00 ,6.8623e+00 /)
      kao(:, 4, 5,12) = (/ &
     &2.3683e-02 ,9.1895e-01 ,1.8383e+00 ,2.7574e+00 ,3.6772e+00 ,4.5980e+00 , &
     &5.5202e+00 ,6.4486e+00 ,7.3542e+00 /)
      kao(:, 5, 5,12) = (/ &
     &2.3999e-02 ,9.7537e-01 ,1.9505e+00 ,2.9260e+00 ,3.9018e+00 ,4.8784e+00 , &
     &5.8576e+00 ,6.8447e+00 ,7.8034e+00 /)
      kao(:, 1, 6,12) = (/ &
     &4.2265e-02 ,6.7923e-01 ,1.3583e+00 ,2.0372e+00 ,2.7164e+00 ,3.3965e+00 , &
     &4.0771e+00 ,4.7611e+00 ,5.4325e+00 /)
      kao(:, 2, 6,12) = (/ &
     &4.3312e-02 ,7.4027e-01 ,1.4802e+00 ,2.2203e+00 ,2.9606e+00 ,3.7016e+00 , &
     &4.4440e+00 ,5.1934e+00 ,5.9209e+00 /)
      kao(:, 3, 6,12) = (/ &
     &4.4154e-02 ,8.0193e-01 ,1.6036e+00 ,2.4053e+00 ,3.2071e+00 ,4.0091e+00 , &
     &4.8130e+00 ,5.6200e+00 ,6.4137e+00 /)
      kao(:, 4, 6,12) = (/ &
     &4.4818e-02 ,8.6447e-01 ,1.7287e+00 ,2.5931e+00 ,3.4580e+00 ,4.3234e+00 , &
     &5.1892e+00 ,6.0606e+00 ,6.9157e+00 /)
      kao(:, 5, 6,12) = (/ &
     &4.5427e-02 ,9.2353e-01 ,1.8468e+00 ,2.7701e+00 ,3.6940e+00 ,4.6182e+00 , &
     &5.5436e+00 ,6.4744e+00 ,7.3877e+00 /)
      kao(:, 1, 7,12) = (/ &
     &8.2851e-02 ,6.1813e-01 ,1.2353e+00 ,1.8525e+00 ,2.4701e+00 ,3.0880e+00 , &
     &3.7064e+00 ,4.3285e+00 ,4.9392e+00 /)
      kao(:, 2, 7,12) = (/ &
     &8.4778e-02 ,6.8174e-01 ,1.3624e+00 ,2.0434e+00 ,2.7245e+00 ,3.4060e+00 , &
     &4.0883e+00 ,4.7735e+00 ,5.4481e+00 /)
      kao(:, 3, 7,12) = (/ &
     &8.6620e-02 ,7.4569e-01 ,1.4908e+00 ,2.2359e+00 ,2.9814e+00 ,3.7272e+00 , &
     &4.4733e+00 ,5.2220e+00 ,5.9623e+00 /)
      kao(:, 4, 7,12) = (/ &
     &8.8221e-02 ,8.0972e-01 ,1.6191e+00 ,2.4284e+00 ,3.2380e+00 ,4.0476e+00 , &
     &4.8581e+00 ,5.6715e+00 ,6.4756e+00 /)
      kao(:, 5, 7,12) = (/ &
     &8.9388e-02 ,8.6929e-01 ,1.7383e+00 ,2.6072e+00 ,3.4769e+00 ,4.3464e+00 , &
     &5.2172e+00 ,6.0912e+00 ,6.9533e+00 /)
      kao(:, 1, 8,12) = (/ &
     &1.9209e-01 ,6.2527e-01 ,1.1133e+00 ,1.6689e+00 ,2.2244e+00 ,2.7803e+00 , &
     &3.3362e+00 ,3.8938e+00 ,4.4464e+00 /)
      kao(:, 2, 8,12) = (/ &
     &1.9727e-01 ,6.6108e-01 ,1.2430e+00 ,1.8635e+00 ,2.4844e+00 ,3.1054e+00 , &
     &3.7267e+00 ,4.3504e+00 ,4.9671e+00 /)
      kao(:, 3, 8,12) = (/ &
     &2.0144e-01 ,7.0485e-01 ,1.3718e+00 ,2.0572e+00 ,2.7423e+00 ,3.4280e+00 , &
     &4.1141e+00 ,4.8012e+00 ,5.4833e+00 /)
      kao(:, 4, 8,12) = (/ &
     &2.0484e-01 ,7.5576e-01 ,1.4986e+00 ,2.2473e+00 ,2.9964e+00 ,3.7450e+00 , &
     &4.4951e+00 ,5.2469e+00 ,5.9915e+00 /)
      kao(:, 5, 8,12) = (/ &
     &2.0777e-01 ,8.0793e-01 ,1.6132e+00 ,2.4193e+00 ,3.2252e+00 ,4.0323e+00 , &
     &4.8391e+00 ,5.6481e+00 ,6.4494e+00 /)
      kao(:, 1, 9,12) = (/ &
     &8.2620e-01 ,1.3515e+00 ,1.6396e+00 ,1.8633e+00 ,2.0617e+00 ,2.4827e+00 , &
     &2.9771e+00 ,3.4729e+00 ,3.9666e+00 /)
      kao(:, 2, 9,12) = (/ &
     &8.4850e-01 ,1.4155e+00 ,1.7443e+00 ,1.9664e+00 ,2.2558e+00 ,2.7862e+00 , &
     &3.3424e+00 ,3.8990e+00 ,4.4541e+00 /)
      kao(:, 3, 9,12) = (/ &
     &8.6743e-01 ,1.4840e+00 ,1.8355e+00 ,2.0729e+00 ,2.4805e+00 ,3.0958e+00 , &
     &3.7138e+00 ,4.3325e+00 ,4.9497e+00 /)
      kao(:, 4, 9,12) = (/ &
     &8.8373e-01 ,1.5402e+00 ,1.9288e+00 ,2.1892e+00 ,2.7106e+00 ,3.3871e+00 , &
     &4.0635e+00 ,4.7407e+00 ,5.4157e+00 /)
      kao(:, 5, 9,12) = (/ &
     &8.9622e-01 ,1.5897e+00 ,2.0124e+00 ,2.3107e+00 ,2.9348e+00 ,3.6673e+00 , &
     &4.4005e+00 ,5.1335e+00 ,5.8643e+00 /)
      kao(:, 1,10,12) = (/ &
     &3.9173e+00 ,3.9928e+00 ,4.3366e+00 ,4.4280e+00 ,4.2663e+00 ,3.9998e+00 , &
     &3.6166e+00 ,3.1308e+00 ,3.5126e+00 /)
      kao(:, 2,10,12) = (/ &
     &4.0212e+00 ,4.1687e+00 ,4.5593e+00 ,4.6368e+00 ,4.5220e+00 ,4.2834e+00 , &
     &3.8634e+00 ,3.4894e+00 ,3.9713e+00 /)
      kao(:, 3,10,12) = (/ &
     &4.1147e+00 ,4.3230e+00 ,4.7454e+00 ,4.8522e+00 ,4.7749e+00 ,4.5433e+00 , &
     &4.0957e+00 ,3.8708e+00 ,4.4196e+00 /)
      kao(:, 4,10,12) = (/ &
     &4.1890e+00 ,4.4586e+00 ,4.9236e+00 ,5.0494e+00 ,4.9988e+00 ,4.8016e+00 , &
     &4.3028e+00 ,4.2486e+00 ,4.8508e+00 /)
      kao(:, 5,10,12) = (/ &
     &4.2486e+00 ,4.5669e+00 ,5.0902e+00 ,5.2222e+00 ,5.2265e+00 ,5.0216e+00 , &
     &4.5057e+00 ,4.6204e+00 ,5.2753e+00 /)
      kao(:, 1,11,12) = (/ &
     &6.5008e+00 ,6.1849e+00 ,6.2789e+00 ,6.2685e+00 ,5.9393e+00 ,5.4109e+00 , &
     &4.7099e+00 ,3.7046e+00 ,3.2687e+00 /)
      kao(:, 2,11,12) = (/ &
     &6.6711e+00 ,6.4071e+00 ,6.5745e+00 ,6.5690e+00 ,6.2447e+00 ,5.7486e+00 , &
     &5.0466e+00 ,3.9652e+00 ,3.6849e+00 /)
      kao(:, 3,11,12) = (/ &
     &6.8141e+00 ,6.5961e+00 ,6.8266e+00 ,6.8425e+00 ,6.5425e+00 ,6.0645e+00 , &
     &5.3679e+00 ,4.1951e+00 ,4.0848e+00 /)
      kao(:, 4,11,12) = (/ &
     &6.9309e+00 ,6.7641e+00 ,7.0497e+00 ,7.0951e+00 ,6.8173e+00 ,6.3688e+00 , &
     &5.6628e+00 ,4.4427e+00 ,4.4838e+00 /)
      kao(:, 5,11,12) = (/ &
     &7.0334e+00 ,6.9031e+00 ,7.2676e+00 ,7.3125e+00 ,7.0679e+00 ,6.6762e+00 , &
     &5.9144e+00 ,4.7231e+00 ,4.9084e+00 /)
      kao(:, 1,12,12) = (/ &
     &8.0356e+00 ,7.5209e+00 ,7.4229e+00 ,7.2434e+00 ,6.7979e+00 ,6.1202e+00 , &
     &5.2895e+00 ,4.1070e+00 ,2.9936e+00 /)
      kao(:, 2,12,12) = (/ &
     &8.2347e+00 ,7.7748e+00 ,7.7310e+00 ,7.5713e+00 ,7.1351e+00 ,6.4951e+00 , &
     &5.6590e+00 ,4.4043e+00 ,3.3743e+00 /)
      kao(:, 3,12,12) = (/ &
     &8.4084e+00 ,7.9908e+00 ,8.0012e+00 ,7.8714e+00 ,7.4600e+00 ,6.8499e+00 , &
     &6.0055e+00 ,4.6706e+00 ,3.7574e+00 /)
      kao(:, 4,12,12) = (/ &
     &8.5546e+00 ,8.1702e+00 ,8.2474e+00 ,8.1496e+00 ,7.7631e+00 ,7.1869e+00 , &
     &6.3250e+00 ,4.9362e+00 ,4.1426e+00 /)
      kao(:, 5,12,12) = (/ &
     &8.6676e+00 ,8.3299e+00 ,8.4723e+00 ,8.3950e+00 ,8.0405e+00 ,7.5149e+00 , &
     &6.6159e+00 ,5.2129e+00 ,4.5254e+00 /)
      kao(:, 1,13,12) = (/ &
     &7.9759e+00 ,7.5343e+00 ,7.4503e+00 ,7.1563e+00 ,6.6524e+00 ,6.0033e+00 , &
     &5.2080e+00 ,4.0643e+00 ,2.7278e+00 /)
      kao(:, 2,13,12) = (/ &
     &8.1794e+00 ,7.7874e+00 ,7.7473e+00 ,7.4642e+00 ,6.9912e+00 ,6.3834e+00 , &
     &5.5711e+00 ,4.3572e+00 ,3.0821e+00 /)
      kao(:, 3,13,12) = (/ &
     &8.3457e+00 ,8.0091e+00 ,8.0057e+00 ,7.7578e+00 ,7.3258e+00 ,6.7364e+00 , &
     &5.9096e+00 ,4.6439e+00 ,3.4477e+00 /)
      kao(:, 4,13,12) = (/ &
     &8.4812e+00 ,8.2074e+00 ,8.2395e+00 ,8.0326e+00 ,7.6295e+00 ,7.0667e+00 , &
     &6.2213e+00 ,4.9334e+00 ,3.7948e+00 /)
      kao(:, 5,13,12) = (/ &
     &8.5914e+00 ,8.3651e+00 ,8.4655e+00 ,8.2768e+00 ,7.9296e+00 ,7.3785e+00 , &
     &6.5133e+00 ,5.2165e+00 ,4.1485e+00 /)
      kao(:, 1, 1,13) = (/ &
     &1.8376e-03 ,1.2493e+00 ,2.4869e+00 ,3.7066e+00 ,4.8962e+00 ,6.0283e+00 , &
     &7.0325e+00 ,7.5732e+00 ,9.7924e+00 /)
      kao(:, 2, 1,13) = (/ &
     &1.8435e-03 ,1.3137e+00 ,2.6151e+00 ,3.8978e+00 ,5.1474e+00 ,6.3345e+00 , &
     &7.3693e+00 ,7.9436e+00 ,1.0295e+01 /)
      kao(:, 3, 1,13) = (/ &
     &1.8457e-03 ,1.3823e+00 ,2.7512e+00 ,4.0980e+00 ,5.4060e+00 ,6.6439e+00 , &
     &7.7282e+00 ,8.2817e+00 ,1.0812e+01 /)
      kao(:, 4, 1,13) = (/ &
     &1.8458e-03 ,1.4480e+00 ,2.8814e+00 ,4.2920e+00 ,5.6663e+00 ,6.9707e+00 , &
     &8.1084e+00 ,8.6593e+00 ,1.1333e+01 /)
      kao(:, 5, 1,13) = (/ &
     &1.8581e-03 ,1.5191e+00 ,3.0214e+00 ,4.4961e+00 ,5.9276e+00 ,7.2804e+00 , &
     &8.4721e+00 ,9.0750e+00 ,1.1855e+01 /)
      kao(:, 1, 2,13) = (/ &
     &3.0081e-03 ,1.2887e+00 ,2.5721e+00 ,3.8463e+00 ,5.1064e+00 ,6.3378e+00 , &
     &7.4987e+00 ,8.3933e+00 ,1.0213e+01 /)
      kao(:, 2, 2,13) = (/ &
     &3.0389e-03 ,1.3599e+00 ,2.7131e+00 ,4.0552e+00 ,5.3783e+00 ,6.6678e+00 , &
     &7.8772e+00 ,8.7981e+00 ,1.0756e+01 /)
      kao(:, 3, 2,13) = (/ &
     &3.0623e-03 ,1.4308e+00 ,2.8555e+00 ,4.2711e+00 ,5.6674e+00 ,7.0255e+00 , &
     &8.2810e+00 ,9.2099e+00 ,1.1335e+01 /)
      kao(:, 4, 2,13) = (/ &
     &3.1073e-03 ,1.4998e+00 ,2.9927e+00 ,4.4738e+00 ,5.9361e+00 ,7.3612e+00 , &
     &8.6975e+00 ,9.6506e+00 ,1.1872e+01 /)
      kao(:, 5, 2,13) = (/ &
     &3.1371e-03 ,1.5763e+00 ,3.1432e+00 ,4.6958e+00 ,6.2242e+00 ,7.7091e+00 , &
     &9.0917e+00 ,1.0108e+01 ,1.2448e+01 /)
      kao(:, 1, 3,13) = (/ &
     &6.7566e-03 ,1.3010e+00 ,2.6001e+00 ,3.8967e+00 ,5.1878e+00 ,6.4676e+00 , &
     &7.7183e+00 ,8.8575e+00 ,1.0376e+01 /)
      kao(:, 2, 3,13) = (/ &
     &6.8655e-03 ,1.3725e+00 ,2.7424e+00 ,4.1083e+00 ,5.4679e+00 ,6.8133e+00 , &
     &8.1286e+00 ,9.3210e+00 ,1.0936e+01 /)
      kao(:, 3, 3,13) = (/ &
     &7.0162e-03 ,1.4463e+00 ,2.8900e+00 ,4.3294e+00 ,5.7613e+00 ,7.1793e+00 , &
     &8.5582e+00 ,9.7979e+00 ,1.1523e+01 /)
      kao(:, 4, 3,13) = (/ &
     &7.1355e-03 ,1.5186e+00 ,3.0341e+00 ,4.5447e+00 ,6.0464e+00 ,7.5309e+00 , &
     &8.9783e+00 ,1.0290e+01 ,1.2093e+01 /)
      kao(:, 5, 3,13) = (/ &
     &7.2326e-03 ,1.6009e+00 ,3.1979e+00 ,4.7883e+00 ,6.3681e+00 ,7.9274e+00 , &
     &9.4396e+00 ,1.0789e+01 ,1.2736e+01 /)
      kao(:, 1, 4,13) = (/ &
     &1.5770e-02 ,1.2974e+00 ,2.5940e+00 ,3.8891e+00 ,5.1823e+00 ,6.4711e+00 , &
     &7.7497e+00 ,8.9872e+00 ,1.0364e+01 /)
      kao(:, 2, 4,13) = (/ &
     &1.6102e-02 ,1.3725e+00 ,2.7438e+00 ,4.1133e+00 ,5.4792e+00 ,6.8384e+00 , &
     &8.1824e+00 ,9.4681e+00 ,1.0958e+01 /)
      kao(:, 3, 4,13) = (/ &
     &1.6461e-02 ,1.4529e+00 ,2.9044e+00 ,4.3540e+00 ,5.7994e+00 ,7.2375e+00 , &
     &8.6575e+00 ,1.0008e+01 ,1.1599e+01 /)
      kao(:, 4, 4,13) = (/ &
     &1.6764e-02 ,1.5336e+00 ,3.0659e+00 ,4.5952e+00 ,6.1201e+00 ,7.6366e+00 , &
     &9.1307e+00 ,1.0552e+01 ,1.2240e+01 /)
      kao(:, 5, 4,13) = (/ &
     &1.6983e-02 ,1.6203e+00 ,3.2389e+00 ,4.8548e+00 ,6.4661e+00 ,8.0668e+00 , &
     &9.6455e+00 ,1.1132e+01 ,1.2932e+01 /)
      kao(:, 1, 5,13) = (/ &
     &3.3958e-02 ,1.2926e+00 ,2.5850e+00 ,3.8765e+00 ,5.1671e+00 ,6.4548e+00 , &
     &7.7382e+00 ,9.0001e+00 ,1.0334e+01 /)
      kao(:, 2, 5,13) = (/ &
     &3.4722e-02 ,1.3756e+00 ,2.7505e+00 ,4.1243e+00 ,5.4969e+00 ,6.8654e+00 , &
     &8.2252e+00 ,9.5545e+00 ,1.0994e+01 /)
      kao(:, 3, 5,13) = (/ &
     &3.5363e-02 ,1.4648e+00 ,2.9290e+00 ,4.3919e+00 ,5.8529e+00 ,7.3099e+00 , &
     &8.7568e+00 ,1.0164e+01 ,1.1706e+01 /)
      kao(:, 4, 5,13) = (/ &
     &3.6012e-02 ,1.5505e+00 ,3.1003e+00 ,4.6491e+00 ,6.1954e+00 ,7.7382e+00 , &
     &9.2690e+00 ,1.0761e+01 ,1.2391e+01 /)
      kao(:, 5, 5,13) = (/ &
     &3.6453e-02 ,1.6361e+00 ,3.2714e+00 ,4.9053e+00 ,6.5374e+00 ,8.1645e+00 , &
     &9.7803e+00 ,1.1352e+01 ,1.3075e+01 /)
      kao(:, 1, 6,13) = (/ &
     &6.7837e-02 ,1.2756e+00 ,2.5511e+00 ,3.8262e+00 ,5.1016e+00 ,6.3755e+00 , &
     &7.6486e+00 ,8.9147e+00 ,1.0203e+01 /)
      kao(:, 2, 6,13) = (/ &
     &6.9368e-02 ,1.3655e+00 ,2.7307e+00 ,4.0953e+00 ,5.4595e+00 ,6.8218e+00 , &
     &8.1822e+00 ,9.5288e+00 ,1.0919e+01 /)
      kao(:, 3, 6,13) = (/ &
     &7.0610e-02 ,1.4598e+00 ,2.9193e+00 ,4.3789e+00 ,5.8375e+00 ,7.2946e+00 , &
     &8.7480e+00 ,1.0185e+01 ,1.1675e+01 /)
      kao(:, 4, 6,13) = (/ &
     &7.1895e-02 ,1.5499e+00 ,3.0992e+00 ,4.6481e+00 ,6.1963e+00 ,7.7431e+00 , &
     &9.2863e+00 ,1.0814e+01 ,1.2392e+01 /)
      kao(:, 5, 6,13) = (/ &
     &7.2713e-02 ,1.6401e+00 ,3.2796e+00 ,4.9184e+00 ,6.5572e+00 ,8.1927e+00 , &
     &9.8252e+00 ,1.1440e+01 ,1.3114e+01 /)
      kao(:, 1, 7,13) = (/ &
     &1.4148e-01 ,1.2306e+00 ,2.4611e+00 ,3.6917e+00 ,4.9218e+00 ,6.1530e+00 , &
     &7.3843e+00 ,8.6153e+00 ,9.8436e+00 /)
      kao(:, 2, 7,13) = (/ &
     &1.4468e-01 ,1.3267e+00 ,2.6534e+00 ,3.9799e+00 ,5.3067e+00 ,6.6328e+00 , &
     &7.9589e+00 ,9.2835e+00 ,1.0613e+01 /)
      kao(:, 3, 7,13) = (/ &
     &1.4723e-01 ,1.4271e+00 ,2.8538e+00 ,4.2801e+00 ,5.7062e+00 ,7.1323e+00 , &
     &8.5577e+00 ,9.9797e+00 ,1.1412e+01 /)
      kao(:, 4, 7,13) = (/ &
     &1.4959e-01 ,1.5234e+00 ,3.0460e+00 ,4.5687e+00 ,6.0905e+00 ,7.6133e+00 , &
     &9.1342e+00 ,1.0653e+01 ,1.2180e+01 /)
      kao(:, 5, 7,13) = (/ &
     &1.5109e-01 ,1.6156e+00 ,3.2301e+00 ,4.8444e+00 ,6.4594e+00 ,8.0732e+00 , &
     &9.6859e+00 ,1.1294e+01 ,1.2918e+01 /)
      kao(:, 1, 8,13) = (/ &
     &3.4983e-01 ,1.1544e+00 ,2.3087e+00 ,3.4632e+00 ,4.6176e+00 ,5.7728e+00 , &
     &6.9283e+00 ,8.0852e+00 ,9.2350e+00 /)
      kao(:, 2, 8,13) = (/ &
     &3.5757e-01 ,1.2554e+00 ,2.5092e+00 ,3.7633e+00 ,5.0176e+00 ,6.2716e+00 , &
     &7.5265e+00 ,8.7822e+00 ,1.0034e+01 /)
      kao(:, 3, 8,13) = (/ &
     &3.6359e-01 ,1.3606e+00 ,2.7192e+00 ,4.0780e+00 ,5.4366e+00 ,6.7958e+00 , &
     &8.1543e+00 ,9.5151e+00 ,1.0871e+01 /)
      kao(:, 4, 8,13) = (/ &
     &3.6947e-01 ,1.4619e+00 ,2.9219e+00 ,4.3820e+00 ,5.8417e+00 ,7.3019e+00 , &
     &8.7622e+00 ,1.0223e+01 ,1.1681e+01 /)
      kao(:, 5, 8,13) = (/ &
     &3.7269e-01 ,1.5629e+00 ,3.1234e+00 ,4.6839e+00 ,6.2445e+00 ,7.8052e+00 , &
     &9.3661e+00 ,1.0928e+01 ,1.2487e+01 /)
      kao(:, 1, 9,13) = (/ &
     &1.6120e+00 ,2.1579e+00 ,2.5856e+00 ,3.2058e+00 ,4.2226e+00 ,5.2767e+00 , &
     &6.3317e+00 ,7.3871e+00 ,8.4404e+00 /)
      kao(:, 2, 9,13) = (/ &
     &1.6481e+00 ,2.2537e+00 ,2.6687e+00 ,3.4901e+00 ,4.6465e+00 ,5.8062e+00 , &
     &6.9659e+00 ,8.1266e+00 ,9.2849e+00 /)
      kao(:, 3, 9,13) = (/ &
     &1.6791e+00 ,2.3216e+00 ,2.7898e+00 ,3.8113e+00 ,5.0781e+00 ,6.3453e+00 , &
     &7.6127e+00 ,8.8803e+00 ,1.0146e+01 /)
      kao(:, 4, 9,13) = (/ &
     &1.7002e+00 ,2.3849e+00 ,2.9226e+00 ,4.1389e+00 ,5.5144e+00 ,6.8902e+00 , &
     &8.2665e+00 ,9.6440e+00 ,1.1018e+01 /)
      kao(:, 5, 9,13) = (/ &
     &1.7139e+00 ,2.4356e+00 ,3.0744e+00 ,4.4589e+00 ,5.9418e+00 ,7.4246e+00 , &
     &8.9078e+00 ,1.0391e+01 ,1.1873e+01 /)
      kao(:, 1,10,13) = (/ &
     &8.1900e+00 ,7.5735e+00 ,7.5164e+00 ,7.4868e+00 ,7.2490e+00 ,6.5441e+00 , &
     &6.0001e+00 ,6.6902e+00 ,7.6402e+00 /)
      kao(:, 2,10,13) = (/ &
     &8.3686e+00 ,7.7990e+00 ,7.8449e+00 ,7.8651e+00 ,7.5310e+00 ,6.7442e+00 , &
     &6.5109e+00 ,7.4533e+00 ,8.5097e+00 /)
      kao(:, 3,10,13) = (/ &
     &8.5094e+00 ,8.0068e+00 ,8.1129e+00 ,8.1601e+00 ,7.7387e+00 ,7.0241e+00 , &
     &7.1098e+00 ,8.2483e+00 ,9.4190e+00 /)
      kao(:, 4,10,13) = (/ &
     &8.6083e+00 ,8.1729e+00 ,8.3302e+00 ,8.3900e+00 ,7.9589e+00 ,7.3305e+00 , &
     &7.7681e+00 ,9.0471e+00 ,1.0331e+01 /)
      kao(:, 5,10,13) = (/ &
     &8.6642e+00 ,8.2947e+00 ,8.5084e+00 ,8.6017e+00 ,8.1354e+00 ,7.7044e+00 , &
     &8.4486e+00 ,9.8464e+00 ,1.1244e+01 /)
      kao(:, 1,11,13) = (/ &
     &1.4422e+01 ,1.2923e+01 ,1.2146e+01 ,1.1467e+01 ,1.0797e+01 ,9.7043e+00 , &
     &7.9341e+00 ,6.4523e+00 ,7.2283e+00 /)
      kao(:, 2,11,13) = (/ &
     &1.4693e+01 ,1.3224e+01 ,1.2546e+01 ,1.1961e+01 ,1.1284e+01 ,1.0051e+01 , &
     &8.2717e+00 ,7.1710e+00 ,8.1411e+00 /)
      kao(:, 3,11,13) = (/ &
     &1.4865e+01 ,1.3437e+01 ,1.2872e+01 ,1.2352e+01 ,1.1673e+01 ,1.0373e+01 , &
     &8.6477e+00 ,7.9776e+00 ,9.0911e+00 /)
      kao(:, 4,11,13) = (/ &
     &1.4985e+01 ,1.3594e+01 ,1.3136e+01 ,1.2689e+01 ,1.2000e+01 ,1.0700e+01 , &
     &9.0501e+00 ,8.7877e+00 ,1.0028e+01 /)
      kao(:, 5,11,13) = (/ &
     &1.5049e+01 ,1.3704e+01 ,1.3344e+01 ,1.2975e+01 ,1.2311e+01 ,1.0977e+01 , &
     &9.5392e+00 ,9.6092e+00 ,1.0970e+01 /)
      kao(:, 1,12,13) = (/ &
     &1.8498e+01 ,1.6493e+01 ,1.5330e+01 ,1.4296e+01 ,1.3227e+01 ,1.1776e+01 , &
     &9.6093e+00 ,6.9105e+00 ,6.8698e+00 /)
      kao(:, 2,12,13) = (/ &
     &1.8757e+01 ,1.6799e+01 ,1.5767e+01 ,1.4839e+01 ,1.3780e+01 ,1.2237e+01 , &
     &1.0031e+01 ,7.5179e+00 ,7.8121e+00 /)
      kao(:, 3,12,13) = (/ &
     &1.8947e+01 ,1.7036e+01 ,1.6095e+01 ,1.5249e+01 ,1.4223e+01 ,1.2650e+01 , &
     &1.0480e+01 ,8.1785e+00 ,8.7273e+00 /)
      kao(:, 4,12,13) = (/ &
     &1.9063e+01 ,1.7202e+01 ,1.6365e+01 ,1.5574e+01 ,1.4614e+01 ,1.3047e+01 , &
     &1.0927e+01 ,8.8781e+00 ,9.6514e+00 /)
      kao(:, 5,12,13) = (/ &
     &1.9121e+01 ,1.7309e+01 ,1.6592e+01 ,1.5868e+01 ,1.4993e+01 ,1.3399e+01 , &
     &1.1411e+01 ,9.6204e+00 ,1.0609e+01 /)
      kao(:, 1,13,13) = (/ &
     &1.8681e+01 ,1.6791e+01 ,1.5759e+01 ,1.4851e+01 ,1.3770e+01 ,1.2167e+01 , &
     &1.0009e+01 ,7.2580e+00 ,6.5238e+00 /)
      kao(:, 2,13,13) = (/ &
     &1.8892e+01 ,1.7070e+01 ,1.6163e+01 ,1.5373e+01 ,1.4290e+01 ,1.2645e+01 , &
     &1.0505e+01 ,7.8149e+00 ,7.3987e+00 /)
      kao(:, 3,13,13) = (/ &
     &1.9028e+01 ,1.7273e+01 ,1.6517e+01 ,1.5784e+01 ,1.4702e+01 ,1.3114e+01 , &
     &1.1026e+01 ,8.4153e+00 ,8.2894e+00 /)
      kao(:, 4,13,13) = (/ &
     &1.9122e+01 ,1.7418e+01 ,1.6814e+01 ,1.6131e+01 ,1.5108e+01 ,1.3570e+01 , &
     &1.1549e+01 ,9.0457e+00 ,9.1940e+00 /)
      kao(:, 5,13,13) = (/ &
     &1.9151e+01 ,1.7520e+01 ,1.7041e+01 ,1.6440e+01 ,1.5494e+01 ,1.4010e+01 , &
     &1.2106e+01 ,9.7104e+00 ,1.0102e+01 /)
      kao(:, 1, 1,14) = (/ &
     &3.3087e-03 ,1.8715e+00 ,3.7152e+00 ,5.5155e+00 ,7.2487e+00 ,8.8573e+00 , &
     &1.0201e+01 ,1.0807e+01 ,1.4497e+01 /)
      kao(:, 2, 1,14) = (/ &
     &3.2220e-03 ,1.9525e+00 ,3.8750e+00 ,5.7533e+00 ,7.5552e+00 ,9.2212e+00 , &
     &1.0608e+01 ,1.1197e+01 ,1.5110e+01 /)
      kao(:, 3, 1,14) = (/ &
     &3.1339e-03 ,2.0260e+00 ,4.0195e+00 ,5.9653e+00 ,7.8344e+00 ,9.5608e+00 , &
     &1.0981e+01 ,1.1562e+01 ,1.5669e+01 /)
      kao(:, 4, 1,14) = (/ &
     &3.0455e-03 ,2.1060e+00 ,4.1769e+00 ,6.1939e+00 ,8.1222e+00 ,9.8877e+00 , &
     &1.1323e+01 ,1.1897e+01 ,1.6244e+01 /)
      kao(:, 5, 1,14) = (/ &
     &2.9339e-03 ,2.1869e+00 ,4.3369e+00 ,6.4318e+00 ,8.4325e+00 ,1.0262e+01 , &
     &1.1718e+01 ,1.2199e+01 ,1.6865e+01 /)
      kao(:, 1, 2,14) = (/ &
     &5.2878e-03 ,2.0475e+00 ,4.0760e+00 ,6.0751e+00 ,8.0240e+00 ,9.8767e+00 , &
     &1.1510e+01 ,1.2463e+01 ,1.6048e+01 /)
      kao(:, 2, 2,14) = (/ &
     &5.1473e-03 ,2.1393e+00 ,4.2595e+00 ,6.3491e+00 ,8.3874e+00 ,1.0326e+01 , &
     &1.2039e+01 ,1.3009e+01 ,1.6775e+01 /)
      kao(:, 3, 2,14) = (/ &
     &5.0049e-03 ,2.2262e+00 ,4.4297e+00 ,6.5989e+00 ,8.7109e+00 ,1.0721e+01 , &
     &1.2503e+01 ,1.3517e+01 ,1.7422e+01 /)
      kao(:, 4, 2,14) = (/ &
     &4.8227e-03 ,2.3172e+00 ,4.6099e+00 ,6.8638e+00 ,9.0568e+00 ,1.1128e+01 , &
     &1.2937e+01 ,1.3964e+01 ,1.8113e+01 /)
      kao(:, 5, 2,14) = (/ &
     &4.6542e-03 ,2.4084e+00 ,4.7911e+00 ,7.1333e+00 ,9.4086e+00 ,1.1557e+01 , &
     &1.3418e+01 ,1.4407e+01 ,1.8817e+01 /)
      kao(:, 1, 3,14) = (/ &
     &1.1438e-02 ,2.1889e+00 ,4.3692e+00 ,6.5353e+00 ,8.6778e+00 ,1.0773e+01 , &
     &1.2758e+01 ,1.4346e+01 ,1.7356e+01 /)
      kao(:, 2, 3,14) = (/ &
     &1.1139e-02 ,2.3041e+00 ,4.5995e+00 ,6.8793e+00 ,9.1316e+00 ,1.1334e+01 , &
     &1.3411e+01 ,1.5052e+01 ,1.8263e+01 /)
      kao(:, 3, 3,14) = (/ &
     &1.0770e-02 ,2.4104e+00 ,4.8103e+00 ,7.1935e+00 ,9.5485e+00 ,1.1847e+01 , &
     &1.4017e+01 ,1.5716e+01 ,1.9097e+01 /)
      kao(:, 4, 3,14) = (/ &
     &1.0423e-02 ,2.5146e+00 ,5.0181e+00 ,7.5021e+00 ,9.9570e+00 ,1.2351e+01 , &
     &1.4597e+01 ,1.6319e+01 ,1.9914e+01 /)
      kao(:, 5, 3,14) = (/ &
     &1.0104e-02 ,2.6169e+00 ,5.2203e+00 ,7.8059e+00 ,1.0356e+01 ,1.2839e+01 , &
     &1.5169e+01 ,1.6937e+01 ,2.0712e+01 /)
      kao(:, 1, 4,14) = (/ &
     &2.5365e-02 ,2.3050e+00 ,4.6063e+00 ,6.9017e+00 ,9.1853e+00 ,1.1448e+01 , &
     &1.3656e+01 ,1.5659e+01 ,1.8370e+01 /)
      kao(:, 2, 4,14) = (/ &
     &2.4778e-02 ,2.4401e+00 ,4.8764e+00 ,7.3060e+00 ,9.7240e+00 ,1.2119e+01 , &
     &1.4458e+01 ,1.6580e+01 ,1.9448e+01 /)
      kao(:, 3, 4,14) = (/ &
     &2.4097e-02 ,2.5614e+00 ,5.1183e+00 ,7.6688e+00 ,1.0206e+01 ,1.2719e+01 , &
     &1.5172e+01 ,1.7403e+01 ,2.0411e+01 /)
      kao(:, 4, 4,14) = (/ &
     &2.3478e-02 ,2.6774e+00 ,5.3500e+00 ,8.0159e+00 ,1.0665e+01 ,1.3289e+01 , &
     &1.5848e+01 ,1.8161e+01 ,2.1330e+01 /)
      kao(:, 5, 4,14) = (/ &
     &2.2944e-02 ,2.7978e+00 ,5.5896e+00 ,8.3727e+00 ,1.1139e+01 ,1.3876e+01 , &
     &1.6535e+01 ,1.8911e+01 ,2.2278e+01 /)
      kao(:, 1, 5,14) = (/ &
     &5.2400e-02 ,2.3882e+00 ,4.7744e+00 ,7.1579e+00 ,9.5370e+00 ,1.1906e+01 , &
     &1.4251e+01 ,1.6502e+01 ,1.9074e+01 /)
      kao(:, 2, 5,14) = (/ &
     &5.1529e-02 ,2.5417e+00 ,5.0820e+00 ,7.6184e+00 ,1.0150e+01 ,1.2670e+01 , &
     &1.5165e+01 ,1.7564e+01 ,2.0300e+01 /)
      kao(:, 3, 5,14) = (/ &
     &5.0713e-02 ,2.6834e+00 ,5.3644e+00 ,8.0415e+00 ,1.0713e+01 ,1.3375e+01 , &
     &1.6005e+01 ,1.8525e+01 ,2.1426e+01 /)
      kao(:, 4, 5,14) = (/ &
     &4.9736e-02 ,2.8194e+00 ,5.6359e+00 ,8.4488e+00 ,1.1255e+01 ,1.4048e+01 , &
     &1.6805e+01 ,1.9440e+01 ,2.2511e+01 /)
      kao(:, 5, 5,14) = (/ &
     &4.8999e-02 ,2.9595e+00 ,5.9157e+00 ,8.8682e+00 ,1.1813e+01 ,1.4742e+01 , &
     &1.7634e+01 ,2.0380e+01 ,2.3625e+01 /)
      kao(:, 1, 6,14) = (/ &
     &1.0351e-01 ,2.4306e+00 ,4.8601e+00 ,7.2890e+00 ,9.7147e+00 ,1.2135e+01 , &
     &1.4543e+01 ,1.6905e+01 ,1.9429e+01 /)
      kao(:, 2, 6,14) = (/ &
     &1.0255e-01 ,2.6140e+00 ,5.2274e+00 ,7.8383e+00 ,1.0448e+01 ,1.3051e+01 , &
     &1.5640e+01 ,1.8174e+01 ,2.0896e+01 /)
      kao(:, 3, 6,14) = (/ &
     &1.0183e-01 ,2.7755e+00 ,5.5503e+00 ,8.3234e+00 ,1.1093e+01 ,1.3857e+01 , &
     &1.6607e+01 ,1.9300e+01 ,2.2186e+01 /)
      kao(:, 4, 6,14) = (/ &
     &1.0081e-01 ,2.9307e+00 ,5.8597e+00 ,8.7876e+00 ,1.1711e+01 ,1.4627e+01 , &
     &1.7527e+01 ,2.0360e+01 ,2.3422e+01 /)
      kao(:, 5, 6,14) = (/ &
     &1.0025e-01 ,3.0883e+00 ,6.1762e+00 ,9.2605e+00 ,1.2342e+01 ,1.5414e+01 , &
     &1.8466e+01 ,2.1444e+01 ,2.4683e+01 /)
      kao(:, 1, 7,14) = (/ &
     &2.1803e-01 ,2.4631e+00 ,4.9259e+00 ,7.3877e+00 ,9.8477e+00 ,1.2306e+01 , &
     &1.4757e+01 ,1.7182e+01 ,1.9695e+01 /)
      kao(:, 2, 7,14) = (/ &
     &2.1806e-01 ,2.6703e+00 ,5.3400e+00 ,8.0091e+00 ,1.0677e+01 ,1.3341e+01 , &
     &1.6000e+01 ,1.8630e+01 ,2.1354e+01 /)
      kao(:, 3, 7,14) = (/ &
     &2.1815e-01 ,2.8507e+00 ,5.7004e+00 ,8.5504e+00 ,1.1399e+01 ,1.4242e+01 , &
     &1.7080e+01 ,1.9888e+01 ,2.2798e+01 /)
      kao(:, 4, 7,14) = (/ &
     &2.1765e-01 ,3.0257e+00 ,6.0505e+00 ,9.0745e+00 ,1.2096e+01 ,1.5115e+01 , &
     &1.8125e+01 ,2.1099e+01 ,2.4193e+01 /)
      kao(:, 5, 7,14) = (/ &
     &2.1725e-01 ,3.2088e+00 ,6.4163e+00 ,9.6232e+00 ,1.2829e+01 ,1.6028e+01 , &
     &1.9219e+01 ,2.2369e+01 ,2.5657e+01 /)
      kao(:, 1, 8,14) = (/ &
     &5.5719e-01 ,2.4793e+00 ,4.9583e+00 ,7.4367e+00 ,9.9152e+00 ,1.2393e+01 , &
     &1.4868e+01 ,1.7332e+01 ,1.9830e+01 /)
      kao(:, 2, 8,14) = (/ &
     &5.6059e-01 ,2.7128e+00 ,5.4248e+00 ,8.1366e+00 ,1.0849e+01 ,1.3560e+01 , &
     &1.6268e+01 ,1.8965e+01 ,2.1697e+01 /)
      kao(:, 3, 8,14) = (/ &
     &5.6435e-01 ,2.9177e+00 ,5.8349e+00 ,8.7514e+00 ,1.1668e+01 ,1.4583e+01 , &
     &1.7497e+01 ,2.0397e+01 ,2.3335e+01 /)
      kao(:, 4, 8,14) = (/ &
     &5.6354e-01 ,3.1161e+00 ,6.2315e+00 ,9.3470e+00 ,1.2462e+01 ,1.5576e+01 , &
     &1.8684e+01 ,2.1779e+01 ,2.4923e+01 /)
      kao(:, 5, 8,14) = (/ &
     &5.6160e-01 ,3.3171e+00 ,6.6335e+00 ,9.9496e+00 ,1.3266e+01 ,1.6580e+01 , &
     &1.9888e+01 ,2.3183e+01 ,2.6532e+01 /)
      kao(:, 1, 9,14) = (/ &
     &2.7023e+00 ,3.1133e+00 ,4.9392e+00 ,7.4089e+00 ,9.8776e+00 ,1.2348e+01 , &
     &1.4816e+01 ,1.7282e+01 ,1.9755e+01 /)
      kao(:, 2, 9,14) = (/ &
     &2.7329e+00 ,3.1899e+00 ,5.4498e+00 ,8.1745e+00 ,1.0899e+01 ,1.3624e+01 , &
     &1.6348e+01 ,1.9070e+01 ,2.1798e+01 /)
      kao(:, 3, 9,14) = (/ &
     &2.7414e+00 ,3.2928e+00 ,5.9087e+00 ,8.8629e+00 ,1.1816e+01 ,1.4770e+01 , &
     &1.7722e+01 ,2.0675e+01 ,2.3632e+01 /)
      kao(:, 4, 9,14) = (/ &
     &2.7386e+00 ,3.4095e+00 ,6.3408e+00 ,9.5112e+00 ,1.2680e+01 ,1.5850e+01 , &
     &1.9019e+01 ,2.2186e+01 ,2.5359e+01 /)
      kao(:, 5, 9,14) = (/ &
     &2.7253e+00 ,3.5556e+00 ,6.7742e+00 ,1.0160e+01 ,1.3547e+01 ,1.6934e+01 , &
     &2.0319e+01 ,2.3701e+01 ,2.7094e+01 /)
      kao(:, 1,10,14) = (/ &
     &1.4620e+01 ,1.3012e+01 ,1.2093e+01 ,1.1252e+01 ,1.0888e+01 ,1.2263e+01 , &
     &1.4693e+01 ,1.7142e+01 ,1.9590e+01 /)
      kao(:, 2,10,14) = (/ &
     &1.4753e+01 ,1.3186e+01 ,1.2290e+01 ,1.1490e+01 ,1.1589e+01 ,1.3604e+01 , &
     &1.6324e+01 ,1.9044e+01 ,2.1765e+01 /)
      kao(:, 3,10,14) = (/ &
     &1.4775e+01 ,1.3219e+01 ,1.2416e+01 ,1.1687e+01 ,1.2328e+01 ,1.4817e+01 , &
     &1.7779e+01 ,2.0743e+01 ,2.3705e+01 /)
      kao(:, 4,10,14) = (/ &
     &1.4749e+01 ,1.3203e+01 ,1.2546e+01 ,1.1974e+01 ,1.3088e+01 ,1.5981e+01 , &
     &1.9178e+01 ,2.2373e+01 ,2.5570e+01 /)
      kao(:, 5,10,14) = (/ &
     &1.4700e+01 ,1.3186e+01 ,1.2659e+01 ,1.2331e+01 ,1.3931e+01 ,1.7138e+01 , &
     &2.0565e+01 ,2.3991e+01 ,2.7418e+01 /)
      kao(:, 1,11,14) = (/ &
     &2.7410e+01 ,2.3992e+01 ,2.1335e+01 ,1.9158e+01 ,1.6847e+01 ,1.4928e+01 , &
     &1.5265e+01 ,1.7677e+01 ,2.0202e+01 /)
      kao(:, 2,11,14) = (/ &
     &2.7494e+01 ,2.4097e+01 ,2.1553e+01 ,1.9434e+01 ,1.7307e+01 ,1.5809e+01 , &
     &1.6793e+01 ,1.9551e+01 ,2.2343e+01 /)
      kao(:, 3,11,14) = (/ &
     &2.7540e+01 ,2.4181e+01 ,2.1730e+01 ,1.9742e+01 ,1.7701e+01 ,1.6732e+01 , &
     &1.8269e+01 ,2.1306e+01 ,2.4350e+01 /)
      kao(:, 4,11,14) = (/ &
     &2.7514e+01 ,2.4204e+01 ,2.1897e+01 ,2.0034e+01 ,1.8171e+01 ,1.7696e+01 , &
     &1.9766e+01 ,2.3053e+01 ,2.6341e+01 /)
      kao(:, 5,11,14) = (/ &
     &2.7458e+01 ,2.4204e+01 ,2.2040e+01 ,2.0324e+01 ,1.8730e+01 ,1.8750e+01 , &
     &2.1236e+01 ,2.4764e+01 ,2.8296e+01 /)
      kao(:, 1,12,14) = (/ &
     &3.7739e+01 ,3.3022e+01 ,2.9081e+01 ,2.5731e+01 ,2.2384e+01 ,1.9192e+01 , &
     &1.6882e+01 ,1.7924e+01 ,2.0483e+01 /)
      kao(:, 2,12,14) = (/ &
     &3.7888e+01 ,3.3157e+01 ,2.9316e+01 ,2.6118e+01 ,2.2987e+01 ,1.9918e+01 , &
     &1.8210e+01 ,1.9805e+01 ,2.2631e+01 /)
      kao(:, 3,12,14) = (/ &
     &3.7945e+01 ,3.3236e+01 ,2.9563e+01 ,2.6509e+01 ,2.3567e+01 ,2.0714e+01 , &
     &1.9521e+01 ,2.1672e+01 ,2.4760e+01 /)
      kao(:, 4,12,14) = (/ &
     &3.7956e+01 ,3.3289e+01 ,2.9765e+01 ,2.6932e+01 ,2.4108e+01 ,2.1541e+01 , &
     &2.0877e+01 ,2.3478e+01 ,2.6821e+01 /)
      kao(:, 5,12,14) = (/ &
     &3.7967e+01 ,3.3331e+01 ,2.9953e+01 ,2.7347e+01 ,2.4651e+01 ,2.2457e+01 , &
     &2.2265e+01 ,2.5248e+01 ,2.8840e+01 /)
      kao(:, 1,13,14) = (/ &
     &4.1396e+01 ,3.6239e+01 ,3.2059e+01 ,2.8493e+01 ,2.4944e+01 ,2.1585e+01 , &
     &1.8204e+01 ,1.7791e+01 ,2.0316e+01 /)
      kao(:, 2,13,14) = (/ &
     &4.1543e+01 ,3.6421e+01 ,3.2427e+01 ,2.9033e+01 ,2.5736e+01 ,2.2468e+01 , &
     &1.9493e+01 ,1.9781e+01 ,2.2598e+01 /)
      kao(:, 3,13,14) = (/ &
     &4.1678e+01 ,3.6592e+01 ,3.2739e+01 ,2.9584e+01 ,2.6500e+01 ,2.3336e+01 , &
     &2.0749e+01 ,2.1701e+01 ,2.4790e+01 /)
      kao(:, 4,13,14) = (/ &
     &4.1767e+01 ,3.6719e+01 ,3.3041e+01 ,3.0106e+01 ,2.7204e+01 ,2.4205e+01 , &
     &2.2086e+01 ,2.3604e+01 ,2.6962e+01 /)
      kao(:, 5,13,14) = (/ &
     &4.1856e+01 ,3.6841e+01 ,3.3340e+01 ,3.0667e+01 ,2.7878e+01 ,2.5159e+01 , &
     &2.3471e+01 ,2.5553e+01 ,2.9188e+01 /)
      kao(:, 1, 1,15) = (/ &
     &4.1661e-03 ,3.0613e+00 ,6.0764e+00 ,9.0246e+00 ,1.1861e+01 ,1.4480e+01 , &
     &1.6622e+01 ,1.7284e+01 ,2.3722e+01 /)
      kao(:, 2, 1,15) = (/ &
     &4.0148e-03 ,3.1418e+00 ,6.2320e+00 ,9.2486e+00 ,1.2140e+01 ,1.4819e+01 , &
     &1.7035e+01 ,1.7764e+01 ,2.4279e+01 /)
      kao(:, 3, 1,15) = (/ &
     &3.8658e-03 ,3.2144e+00 ,6.3745e+00 ,9.4527e+00 ,1.2398e+01 ,1.5111e+01 , &
     &1.7346e+01 ,1.8143e+01 ,2.4796e+01 /)
      kao(:, 4, 1,15) = (/ &
     &3.7196e-03 ,3.2826e+00 ,6.5071e+00 ,9.6422e+00 ,1.2633e+01 ,1.5374e+01 , &
     &1.7599e+01 ,1.8433e+01 ,2.5267e+01 /)
      kao(:, 5, 1,15) = (/ &
     &3.5761e-03 ,3.3515e+00 ,6.6395e+00 ,9.8324e+00 ,1.2873e+01 ,1.5639e+01 , &
     &1.7844e+01 ,1.8646e+01 ,2.5747e+01 /)
      kao(:, 1, 2,15) = (/ &
     &6.8577e-03 ,3.3744e+00 ,6.7125e+00 ,9.9952e+00 ,1.3184e+01 ,1.6201e+01 , &
     &1.8839e+01 ,2.0375e+01 ,2.6368e+01 /)
      kao(:, 2, 2,15) = (/ &
     &6.5948e-03 ,3.4888e+00 ,6.9393e+00 ,1.0331e+01 ,1.3623e+01 ,1.6730e+01 , &
     &1.9423e+01 ,2.0902e+01 ,2.7246e+01 /)
      kao(:, 3, 2,15) = (/ &
     &6.3372e-03 ,3.5940e+00 ,7.1483e+00 ,1.0636e+01 ,1.4019e+01 ,1.7199e+01 , &
     &1.9946e+01 ,2.1371e+01 ,2.8038e+01 /)
      kao(:, 4, 2,15) = (/ &
     &6.0860e-03 ,3.6975e+00 ,7.3505e+00 ,1.0936e+01 ,1.4402e+01 ,1.7655e+01 , &
     &2.0430e+01 ,2.1802e+01 ,2.8803e+01 /)
      kao(:, 5, 2,15) = (/ &
     &5.8418e-03 ,3.7949e+00 ,7.5419e+00 ,1.1217e+01 ,1.4770e+01 ,1.8090e+01 , &
     &2.0913e+01 ,2.2203e+01 ,2.9539e+01 /)
      kao(:, 1, 3,15) = (/ &
     &1.5312e-02 ,3.7161e+00 ,7.4117e+00 ,1.1074e+01 ,1.4677e+01 ,1.8180e+01 , &
     &2.1427e+01 ,2.3812e+01 ,2.9355e+01 /)
      kao(:, 2, 3,15) = (/ &
     &1.4697e-02 ,3.8703e+00 ,7.7181e+00 ,1.1532e+01 ,1.5288e+01 ,1.8926e+01 , &
     &2.2293e+01 ,2.4742e+01 ,3.0575e+01 /)
      kao(:, 3, 3,15) = (/ &
     &1.4095e-02 ,4.0069e+00 ,7.9901e+00 ,1.1939e+01 ,1.5823e+01 ,1.9587e+01 , &
     &2.3063e+01 ,2.5568e+01 ,3.1646e+01 /)
      kao(:, 4, 3,15) = (/ &
     &1.3512e-02 ,4.1402e+00 ,8.2563e+00 ,1.2333e+01 ,1.6342e+01 ,2.0226e+01 , &
     &2.3806e+01 ,2.6351e+01 ,3.2684e+01 /)
      kao(:, 5, 3,15) = (/ &
     &1.2949e-02 ,4.2659e+00 ,8.5058e+00 ,1.2707e+01 ,1.6836e+01 ,2.0833e+01 , &
     &2.4517e+01 ,2.7109e+01 ,3.3673e+01 /)
      kao(:, 1, 4,15) = (/ &
     &3.5017e-02 ,4.0833e+00 ,8.1553e+00 ,1.2211e+01 ,1.6236e+01 ,2.0204e+01 , &
     &2.4024e+01 ,2.7316e+01 ,3.2472e+01 /)
      kao(:, 2, 4,15) = (/ &
     &3.3537e-02 ,4.2828e+00 ,8.5541e+00 ,1.2808e+01 ,1.7029e+01 ,2.1189e+01 , &
     &2.5196e+01 ,2.8637e+01 ,3.4057e+01 /)
      kao(:, 3, 4,15) = (/ &
     &3.2113e-02 ,4.4600e+00 ,8.9081e+00 ,1.3336e+01 ,1.7733e+01 ,2.2059e+01 , &
     &2.6228e+01 ,2.9796e+01 ,3.5465e+01 /)
      kao(:, 4, 4,15) = (/ &
     &3.0746e-02 ,4.6307e+00 ,9.2473e+00 ,1.3839e+01 ,1.8403e+01 ,2.2892e+01 , &
     &2.7214e+01 ,3.0894e+01 ,3.6805e+01 /)
      kao(:, 5, 4,15) = (/ &
     &2.9433e-02 ,4.7874e+00 ,9.5611e+00 ,1.4314e+01 ,1.9029e+01 ,2.3669e+01 , &
     &2.8132e+01 ,3.1929e+01 ,3.8057e+01 /)
      kao(:, 1, 5,15) = (/ &
     &7.3896e-02 ,4.4639e+00 ,8.9220e+00 ,1.3370e+01 ,1.7804e+01 ,2.2204e+01 , &
     &2.6523e+01 ,3.0537e+01 ,3.5608e+01 /)
      kao(:, 2, 5,15) = (/ &
     &7.0692e-02 ,4.7138e+00 ,9.4187e+00 ,1.4116e+01 ,1.8797e+01 ,2.3443e+01 , &
     &2.8005e+01 ,3.2244e+01 ,3.7595e+01 /)
      kao(:, 3, 5,15) = (/ &
     &6.7622e-02 ,4.9383e+00 ,9.8707e+00 ,1.4791e+01 ,1.9696e+01 ,2.4560e+01 , &
     &2.9335e+01 ,3.3760e+01 ,3.9391e+01 /)
      kao(:, 4, 5,15) = (/ &
     &6.4677e-02 ,5.1515e+00 ,1.0296e+01 ,1.5428e+01 ,2.0542e+01 ,2.5616e+01 , &
     &3.0597e+01 ,3.5203e+01 ,4.1084e+01 /)
      kao(:, 5, 5,15) = (/ &
     &6.1858e-02 ,5.3461e+00 ,1.0685e+01 ,1.6012e+01 ,2.1318e+01 ,2.6583e+01 , &
     &3.1750e+01 ,3.6527e+01 ,4.2635e+01 /)
      kao(:, 1, 6,15) = (/ &
     &1.4684e-01 ,4.8264e+00 ,9.6500e+00 ,1.4468e+01 ,1.9279e+01 ,2.4068e+01 , &
     &2.8816e+01 ,3.3389e+01 ,3.8558e+01 /)
      kao(:, 2, 6,15) = (/ &
     &1.4028e-01 ,5.1303e+00 ,1.0258e+01 ,1.5380e+01 ,2.0490e+01 ,2.5585e+01 , &
     &3.0631e+01 ,3.5492e+01 ,4.0980e+01 /)
      kao(:, 3, 6,15) = (/ &
     &1.3401e-01 ,5.4150e+00 ,1.0825e+01 ,1.6231e+01 ,2.1624e+01 ,2.7001e+01 , &
     &3.2322e+01 ,3.7445e+01 ,4.3249e+01 /)
      kao(:, 4, 6,15) = (/ &
     &1.2806e-01 ,5.6771e+00 ,1.1351e+01 ,1.7018e+01 ,2.2674e+01 ,2.8310e+01 , &
     &3.3887e+01 ,3.9255e+01 ,4.5348e+01 /)
      kao(:, 5, 6,15) = (/ &
     &1.2235e-01 ,5.9138e+00 ,1.1824e+01 ,1.7725e+01 ,2.3617e+01 ,2.9485e+01 , &
     &3.5301e+01 ,4.0890e+01 ,4.7234e+01 /)
      kao(:, 1, 7,15) = (/ &
     &3.0725e-01 ,5.1535e+00 ,1.0306e+01 ,1.5454e+01 ,2.0602e+01 ,2.5736e+01 , &
     &3.0848e+01 ,3.5878e+01 ,4.1204e+01 /)
      kao(:, 2, 7,15) = (/ &
     &2.9321e-01 ,5.5259e+00 ,1.1050e+01 ,1.6570e+01 ,2.2088e+01 ,2.7592e+01 , &
     &3.3073e+01 ,3.8464e+01 ,4.4176e+01 /)
      kao(:, 3, 7,15) = (/ &
     &2.7993e-01 ,5.8735e+00 ,1.1744e+01 ,1.7612e+01 ,2.3476e+01 ,2.9329e+01 , &
     &3.5155e+01 ,4.0875e+01 ,4.6953e+01 /)
      kao(:, 4, 7,15) = (/ &
     &2.6791e-01 ,6.1876e+00 ,1.2373e+01 ,1.8557e+01 ,2.4734e+01 ,3.0898e+01 , &
     &3.7039e+01 ,4.3070e+01 ,4.9468e+01 /)
      kao(:, 5, 7,15) = (/ &
     &2.5886e-01 ,6.4685e+00 ,1.2934e+01 ,1.9398e+01 ,2.5854e+01 ,3.2302e+01 , &
     &3.8716e+01 ,4.5022e+01 ,5.1708e+01 /)
      kao(:, 1, 8,15) = (/ &
     &7.7279e-01 ,5.4596e+00 ,1.0918e+01 ,1.6376e+01 ,2.1832e+01 ,2.7286e+01 , &
     &3.2729e+01 ,3.8130e+01 ,4.3663e+01 /)
      kao(:, 2, 8,15) = (/ &
     &7.3823e-01 ,5.9033e+00 ,1.1807e+01 ,1.7707e+01 ,2.3607e+01 ,2.9503e+01 , &
     &3.5387e+01 ,4.1229e+01 ,4.7214e+01 /)
      kao(:, 3, 8,15) = (/ &
     &7.0825e-01 ,6.3158e+00 ,1.2632e+01 ,1.8945e+01 ,2.5259e+01 ,3.1562e+01 , &
     &3.7862e+01 ,4.4105e+01 ,5.0517e+01 /)
      kao(:, 4, 8,15) = (/ &
     &6.8827e-01 ,6.6883e+00 ,1.3376e+01 ,2.0062e+01 ,2.6743e+01 ,3.3422e+01 , &
     &4.0088e+01 ,4.6704e+01 ,5.3485e+01 /)
      kao(:, 5, 8,15) = (/ &
     &6.7674e-01 ,7.0269e+00 ,1.4054e+01 ,2.1077e+01 ,2.8099e+01 ,3.5115e+01 , &
     &4.2117e+01 ,4.9067e+01 ,5.6197e+01 /)
      kao(:, 1, 9,15) = (/ &
     &3.6929e+00 ,5.7245e+00 ,1.1448e+01 ,1.7170e+01 ,2.2894e+01 ,2.8616e+01 , &
     &3.4335e+01 ,4.0048e+01 ,4.5789e+01 /)
      kao(:, 2, 9,15) = (/ &
     &3.5483e+00 ,6.2547e+00 ,1.2509e+01 ,1.8761e+01 ,2.5016e+01 ,3.1268e+01 , &
     &3.7517e+01 ,4.3757e+01 ,5.0032e+01 /)
      kao(:, 3, 9,15) = (/ &
     &3.4652e+00 ,6.7430e+00 ,1.3484e+01 ,2.0224e+01 ,2.6965e+01 ,3.3705e+01 , &
     &4.0443e+01 ,4.7167e+01 ,5.3930e+01 /)
      kao(:, 4, 9,15) = (/ &
     &3.4260e+00 ,7.1974e+00 ,1.4393e+01 ,2.1588e+01 ,2.8784e+01 ,3.5977e+01 , &
     &4.3167e+01 ,5.0348e+01 ,5.7567e+01 /)
      kao(:, 5, 9,15) = (/ &
     &3.4123e+00 ,7.6134e+00 ,1.5225e+01 ,2.2838e+01 ,3.0451e+01 ,3.8059e+01 , &
     &4.5665e+01 ,5.3256e+01 ,6.0901e+01 /)
      kao(:, 1,10,15) = (/ &
     &1.9879e+01 ,1.7395e+01 ,1.5929e+01 ,1.8251e+01 ,2.3917e+01 ,2.9895e+01 , &
     &3.5873e+01 ,4.1851e+01 ,4.7831e+01 /)
      kao(:, 2,10,15) = (/ &
     &1.9461e+01 ,1.7089e+01 ,1.6077e+01 ,1.9823e+01 ,2.6409e+01 ,3.3015e+01 , &
     &3.9616e+01 ,4.6210e+01 ,5.2815e+01 /)
      kao(:, 3,10,15) = (/ &
     &1.9336e+01 ,1.7101e+01 ,1.6570e+01 ,2.1574e+01 ,2.8765e+01 ,3.5957e+01 , &
     &4.3144e+01 ,5.0330e+01 ,5.7526e+01 /)
      kao(:, 4,10,15) = (/ &
     &1.9333e+01 ,1.7178e+01 ,1.7183e+01 ,2.3203e+01 ,3.0928e+01 ,3.8662e+01 , &
     &4.6389e+01 ,5.4117e+01 ,6.1850e+01 /)
      kao(:, 5,10,15) = (/ &
     &1.9454e+01 ,1.7376e+01 ,1.7879e+01 ,2.4671e+01 ,3.2892e+01 ,4.1116e+01 , &
     &4.9334e+01 ,5.7555e+01 ,6.5778e+01 /)
      kao(:, 1,11,15) = (/ &
     &3.7918e+01 ,3.3177e+01 ,2.9050e+01 ,2.5728e+01 ,2.6964e+01 ,3.2638e+01 , &
     &3.9160e+01 ,4.5686e+01 ,5.2215e+01 /)
      kao(:, 2,11,15) = (/ &
     &3.7982e+01 ,3.3235e+01 ,2.9190e+01 ,2.6661e+01 ,2.9222e+01 ,3.6220e+01 , &
     &4.3460e+01 ,5.0704e+01 ,5.7949e+01 /)
      kao(:, 3,11,15) = (/ &
     &3.8191e+01 ,3.3419e+01 ,2.9491e+01 ,2.7784e+01 ,3.1731e+01 ,3.9527e+01 , &
     &4.7423e+01 ,5.5330e+01 ,6.3238e+01 /)
      kao(:, 4,11,15) = (/ &
     &3.8572e+01 ,3.3751e+01 ,2.9960e+01 ,2.8966e+01 ,3.4093e+01 ,4.2514e+01 , &
     &5.1014e+01 ,5.9516e+01 ,6.8017e+01 /)
      kao(:, 5,11,15) = (/ &
     &3.9093e+01 ,3.4206e+01 ,3.0547e+01 ,3.0263e+01 ,3.6228e+01 ,4.5245e+01 , &
     &5.4290e+01 ,6.3320e+01 ,7.2371e+01 /)
      kao(:, 1,12,15) = (/ &
     &5.5475e+01 ,4.8541e+01 ,4.2038e+01 ,3.6129e+01 ,3.3332e+01 ,3.5714e+01 , &
     &4.2669e+01 ,4.9771e+01 ,5.6891e+01 /)
      kao(:, 2,12,15) = (/ &
     &5.6059e+01 ,4.9052e+01 ,4.2754e+01 ,3.7078e+01 ,3.5375e+01 ,3.9558e+01 , &
     &4.7442e+01 ,5.5347e+01 ,6.3258e+01 /)
      kao(:, 3,12,15) = (/ &
     &5.6760e+01 ,4.9664e+01 ,4.3494e+01 ,3.8346e+01 ,3.7575e+01 ,4.3186e+01 , &
     &5.1821e+01 ,6.0453e+01 ,6.9095e+01 /)
      kao(:, 4,12,15) = (/ &
     &5.7648e+01 ,5.0443e+01 ,4.4349e+01 ,3.9649e+01 ,3.9898e+01 ,4.6561e+01 , &
     &5.5869e+01 ,6.5177e+01 ,7.4491e+01 /)
      kao(:, 5,12,15) = (/ &
     &5.8564e+01 ,5.1244e+01 ,4.5202e+01 ,4.0926e+01 ,4.2120e+01 ,4.9601e+01 , &
     &5.9519e+01 ,6.9433e+01 ,7.9355e+01 /)
      kao(:, 1,13,15) = (/ &
     &6.5843e+01 ,5.7608e+01 ,4.9977e+01 ,4.3124e+01 ,3.8891e+01 ,3.9628e+01 , &
     &4.6579e+01 ,5.4339e+01 ,6.2102e+01 /)
      kao(:, 2,13,15) = (/ &
     &6.6934e+01 ,5.8564e+01 ,5.1105e+01 ,4.4471e+01 ,4.1117e+01 ,4.3582e+01 , &
     &5.1721e+01 ,6.0334e+01 ,6.8958e+01 /)
      kao(:, 3,13,15) = (/ &
     &6.8030e+01 ,5.9532e+01 ,5.2179e+01 ,4.5978e+01 ,4.3480e+01 ,4.7374e+01 , &
     &5.6498e+01 ,6.5896e+01 ,7.5328e+01 /)
      kao(:, 4,13,15) = (/ &
     &6.9202e+01 ,6.0551e+01 ,5.3246e+01 ,4.7483e+01 ,4.5884e+01 ,5.0923e+01 , &
     &6.0842e+01 ,7.0980e+01 ,8.1125e+01 /)
      kao(:, 5,13,15) = (/ &
     &7.0366e+01 ,6.1567e+01 ,5.4251e+01 ,4.8884e+01 ,4.8138e+01 ,5.4098e+01 , &
     &6.4681e+01 ,7.5454e+01 ,8.6236e+01 /)
      kao(:, 1, 1,16) = (/ &
     &4.2680e-03 ,4.0094e+00 ,7.9109e+00 ,1.1649e+01 ,1.5123e+01 ,1.8131e+01 , &
     &2.0185e+01 ,1.9759e+01 ,3.0246e+01 /)
      kao(:, 2, 1,16) = (/ &
     &4.1096e-03 ,4.1769e+00 ,8.2411e+00 ,1.2134e+01 ,1.5754e+01 ,1.8883e+01 , &
     &2.1013e+01 ,2.0555e+01 ,3.1509e+01 /)
      kao(:, 3, 1,16) = (/ &
     &3.9552e-03 ,4.3246e+00 ,8.5324e+00 ,1.2562e+01 ,1.6307e+01 ,1.9544e+01 , &
     &2.1743e+01 ,2.1252e+01 ,3.2613e+01 /)
      kao(:, 4, 1,16) = (/ &
     &3.8024e-03 ,4.4537e+00 ,8.7866e+00 ,1.2936e+01 ,1.6790e+01 ,2.0122e+01 , &
     &2.2380e+01 ,2.1858e+01 ,3.3579e+01 /)
      kao(:, 5, 1,16) = (/ &
     &3.6530e-03 ,4.5661e+00 ,9.0077e+00 ,1.3262e+01 ,1.7211e+01 ,2.0624e+01 , &
     &2.2936e+01 ,2.2383e+01 ,3.4420e+01 /)
      kao(:, 1, 2,16) = (/ &
     &7.0518e-03 ,4.7486e+00 ,9.4112e+00 ,1.3945e+01 ,1.8257e+01 ,2.2167e+01 , &
     &2.5197e+01 ,2.5646e+01 ,3.6513e+01 /)
      kao(:, 2, 2,16) = (/ &
     &6.7731e-03 ,4.9653e+00 ,9.8411e+00 ,1.4578e+01 ,1.9087e+01 ,2.3173e+01 , &
     &2.6338e+01 ,2.6795e+01 ,3.8174e+01 /)
      kao(:, 3, 2,16) = (/ &
     &6.4989e-03 ,5.1561e+00 ,1.0219e+01 ,1.5138e+01 ,1.9822e+01 ,2.4059e+01 , &
     &2.7344e+01 ,2.7802e+01 ,3.9644e+01 /)
      kao(:, 4, 2,16) = (/ &
     &6.2358e-03 ,5.3229e+00 ,1.0548e+01 ,1.5628e+01 ,2.0461e+01 ,2.4836e+01 , &
     &2.8225e+01 ,2.8690e+01 ,4.0921e+01 /)
      kao(:, 5, 2,16) = (/ &
     &5.9777e-03 ,5.4686e+00 ,1.0838e+01 ,1.6055e+01 ,2.1017e+01 ,2.5512e+01 , &
     &2.8989e+01 ,2.9460e+01 ,4.2034e+01 /)
      kao(:, 1, 3,16) = (/ &
     &1.5841e-02 ,5.5685e+00 ,1.1089e+01 ,1.6529e+01 ,2.1842e+01 ,2.6900e+01 , &
     &3.1365e+01 ,3.3823e+01 ,4.3684e+01 /)
      kao(:, 2, 3,16) = (/ &
     &1.5180e-02 ,5.8535e+00 ,1.1654e+01 ,1.7376e+01 ,2.2954e+01 ,2.8269e+01 , &
     &3.2966e+01 ,3.5548e+01 ,4.5909e+01 /)
      kao(:, 3, 3,16) = (/ &
     &1.4542e-02 ,6.1037e+00 ,1.2154e+01 ,1.8119e+01 ,2.3939e+01 ,2.9482e+01 , &
     &3.4375e+01 ,3.7061e+01 ,4.7877e+01 /)
      kao(:, 4, 3,16) = (/ &
     &1.3926e-02 ,6.3236e+00 ,1.2592e+01 ,1.8771e+01 ,2.4803e+01 ,3.0545e+01 , &
     &3.5612e+01 ,3.8393e+01 ,4.9606e+01 /)
      kao(:, 5, 3,16) = (/ &
     &1.3332e-02 ,6.5149e+00 ,1.2971e+01 ,1.9341e+01 ,2.5553e+01 ,3.1470e+01 , &
     &3.6691e+01 ,3.9549e+01 ,5.1106e+01 /)
      kao(:, 1, 4,16) = (/ &
     &3.6504e-02 ,6.4847e+00 ,1.2941e+01 ,1.9357e+01 ,2.5697e+01 ,3.1893e+01 , &
     &3.7735e+01 ,4.2276e+01 ,5.1393e+01 /)
      kao(:, 2, 4,16) = (/ &
     &3.4931e-02 ,6.8562e+00 ,1.3684e+01 ,2.0466e+01 ,2.7170e+01 ,3.3719e+01 , &
     &3.9896e+01 ,4.4696e+01 ,5.4340e+01 /)
      kao(:, 3, 4,16) = (/ &
     &3.3404e-02 ,7.1832e+00 ,1.4337e+01 ,2.1441e+01 ,2.8465e+01 ,3.5334e+01 , &
     &4.1803e+01 ,4.6838e+01 ,5.6929e+01 /)
      kao(:, 4, 4,16) = (/ &
     &3.1940e-02 ,7.4729e+00 ,1.4911e+01 ,2.2302e+01 ,2.9607e+01 ,3.6753e+01 , &
     &4.3482e+01 ,4.8710e+01 ,5.9213e+01 /)
      kao(:, 5, 4,16) = (/ &
     &3.0537e-02 ,7.7225e+00 ,1.5413e+01 ,2.3052e+01 ,3.0605e+01 ,3.7982e+01 , &
     &4.4943e+01 ,5.0367e+01 ,6.1209e+01 /)
      kao(:, 1, 5,16) = (/ &
     &7.7459e-02 ,7.5153e+00 ,1.5015e+01 ,2.2490e+01 ,2.9920e+01 ,3.7263e+01 , &
     &4.4388e+01 ,5.0697e+01 ,5.9839e+01 /)
      kao(:, 2, 5,16) = (/ &
     &7.3973e-02 ,7.9956e+00 ,1.5974e+01 ,2.3926e+01 ,3.1831e+01 ,3.9653e+01 , &
     &4.7235e+01 ,5.3936e+01 ,6.3661e+01 /)
      kao(:, 3, 5,16) = (/ &
     &7.0652e-02 ,8.4194e+00 ,1.6824e+01 ,2.5198e+01 ,3.3521e+01 ,4.1754e+01 , &
     &4.9742e+01 ,5.6808e+01 ,6.7041e+01 /)
      kao(:, 4, 5,16) = (/ &
     &6.7486e-02 ,8.7920e+00 ,1.7565e+01 ,2.6310e+01 ,3.5003e+01 ,4.3595e+01 , &
     &5.1933e+01 ,5.9317e+01 ,7.0006e+01 /)
      kao(:, 5, 5,16) = (/ &
     &6.4478e-02 ,9.1159e+00 ,1.8215e+01 ,2.7284e+01 ,3.6299e+01 ,4.5208e+01 , &
     &5.3851e+01 ,6.1525e+01 ,7.2598e+01 /)
      kao(:, 1, 6,16) = (/ &
     &1.5475e-01 ,8.6422e+00 ,1.7275e+01 ,2.5892e+01 ,3.4482e+01 ,4.3028e+01 , &
     &5.1423e+01 ,5.9299e+01 ,6.8964e+01 /)
      kao(:, 2, 6,16) = (/ &
     &1.4760e-01 ,9.2603e+00 ,1.8510e+01 ,2.7740e+01 ,3.6952e+01 ,4.6093e+01 , &
     &5.5105e+01 ,6.3549e+01 ,7.3905e+01 /)
      kao(:, 3, 6,16) = (/ &
     &1.4090e-01 ,9.8052e+00 ,1.9599e+01 ,2.9376e+01 ,3.9123e+01 ,4.8807e+01 , &
     &5.8340e+01 ,6.7288e+01 ,7.8246e+01 /)
      kao(:, 4, 6,16) = (/ &
     &1.3455e-01 ,1.0284e+01 ,2.0553e+01 ,3.0809e+01 ,4.1029e+01 ,5.1188e+01 , &
     &6.1191e+01 ,7.0573e+01 ,8.2057e+01 /)
      kao(:, 5, 6,16) = (/ &
     &1.2855e-01 ,1.0696e+01 ,2.1381e+01 ,3.2059e+01 ,4.2695e+01 ,5.3257e+01 , &
     &6.3651e+01 ,7.3440e+01 ,8.5390e+01 /)
      kao(:, 1, 7,16) = (/ &
     &3.2765e-01 ,9.8708e+00 ,1.9738e+01 ,2.9598e+01 ,3.9436e+01 ,4.9244e+01 , &
     &5.8981e+01 ,6.8395e+01 ,7.8872e+01 /)
      kao(:, 2, 7,16) = (/ &
     &3.1237e-01 ,1.0655e+01 ,2.1308e+01 ,3.1948e+01 ,4.2573e+01 ,5.3154e+01 , &
     &6.3663e+01 ,7.3848e+01 ,8.5146e+01 /)
      kao(:, 3, 7,16) = (/ &
     &2.9817e-01 ,1.1348e+01 ,2.2690e+01 ,3.4027e+01 ,4.5330e+01 ,5.6613e+01 , &
     &6.7816e+01 ,7.8654e+01 ,9.0660e+01 /)
      kao(:, 4, 7,16) = (/ &
     &2.8488e-01 ,1.1956e+01 ,2.3907e+01 ,3.5845e+01 ,4.7755e+01 ,5.9649e+01 , &
     &7.1415e+01 ,8.2866e+01 ,9.5510e+01 /)
      kao(:, 5, 7,16) = (/ &
     &2.7283e-01 ,1.2480e+01 ,2.4950e+01 ,3.7415e+01 ,4.9097e+01 ,6.2266e+01 , &
     &7.4578e+01 ,8.6491e+01 ,9.9702e+01 /)
      kao(:, 1, 8,16) = (/ &
     &8.3606e-01 ,1.1195e+01 ,2.2388e+01 ,3.3574e+01 ,4.4755e+01 ,5.5920e+01 , &
     &6.7048e+01 ,7.8029e+01 ,8.9508e+01 /)
      kao(:, 2, 8,16) = (/ &
     &7.9798e-01 ,1.2177e+01 ,2.4351e+01 ,3.6522e+01 ,4.8685e+01 ,6.0830e+01 , &
     &7.2963e+01 ,8.4892e+01 ,9.7369e+01 /)
      kao(:, 3, 8,16) = (/ &
     &7.6304e-01 ,1.3047e+01 ,2.6090e+01 ,3.9130e+01 ,5.2156e+01 ,6.5163e+01 , &
     &7.8140e+01 ,9.0945e+01 ,1.0431e+02 /)
      kao(:, 4, 8,16) = (/ &
     &7.3296e-01 ,1.3800e+01 ,2.7601e+01 ,4.1393e+01 ,5.5174e+01 ,6.8947e+01 , &
     &8.2670e+01 ,9.6216e+01 ,1.1035e+02 /)
      kao(:, 5, 8,16) = (/ &
     &7.2250e-01 ,1.4453e+01 ,2.8899e+01 ,4.3348e+01 ,5.7784e+01 ,7.2193e+01 , &
     &8.6582e+01 ,1.0076e+02 ,1.1557e+02 /)
      kao(:, 1, 9,16) = (/ &
     &4.0611e+00 ,1.2573e+01 ,2.5149e+01 ,3.7721e+01 ,5.0293e+01 ,6.2854e+01 , &
     &7.5422e+01 ,8.7942e+01 ,1.0059e+02 /)
      kao(:, 2, 9,16) = (/ &
     &3.8919e+00 ,1.3793e+01 ,2.7583e+01 ,4.1373e+01 ,5.5157e+01 ,6.8943e+01 , &
     &8.2722e+01 ,9.6458e+01 ,1.1031e+02 /)
      kao(:, 3, 9,16) = (/ &
     &3.7505e+00 ,1.4863e+01 ,2.9722e+01 ,4.4587e+01 ,5.9447e+01 ,7.4303e+01 , &
     &8.9145e+01 ,1.0395e+02 ,1.1889e+02 /)
      kao(:, 4, 9,16) = (/ &
     &3.6915e+00 ,1.5793e+01 ,3.1587e+01 ,4.7379e+01 ,6.3167e+01 ,7.8955e+01 , &
     &9.4727e+01 ,1.1046e+02 ,1.2634e+02 /)
      kao(:, 5, 9,16) = (/ &
     &3.8118e+00 ,1.6590e+01 ,3.3180e+01 ,4.9767e+01 ,6.6364e+01 ,8.2935e+01 , &
     &9.9506e+01 ,1.1603e+02 ,1.3273e+02 /)
      kao(:, 1,10,16) = (/ &
     &2.2252e+01 ,1.9469e+01 ,2.8181e+01 ,4.2271e+01 ,5.6359e+01 ,7.0451e+01 , &
     &8.4538e+01 ,9.8612e+01 ,1.1272e+02 /)
      kao(:, 2,10,16) = (/ &
     &2.1525e+01 ,1.8834e+01 ,3.1126e+01 ,4.6690e+01 ,6.2252e+01 ,7.7813e+01 , &
     &9.3373e+01 ,1.0893e+02 ,1.2450e+02 /)
      kao(:, 3,10,16) = (/ &
     &2.1146e+01 ,1.8632e+01 ,3.3699e+01 ,5.0550e+01 ,6.7413e+01 ,8.4265e+01 , &
     &1.0112e+02 ,1.1795e+02 ,1.3483e+02 /)
      kao(:, 4,10,16) = (/ &
     &2.1709e+01 ,1.9529e+01 ,3.5926e+01 ,5.3893e+01 ,7.1851e+01 ,8.9812e+01 , &
     &1.0777e+02 ,1.2572e+02 ,1.4370e+02 /)
      kao(:, 5,10,16) = (/ &
     &2.2565e+01 ,2.0486e+01 ,3.7826e+01 ,5.6738e+01 ,7.5652e+01 ,9.4560e+01 , &
     &1.1347e+02 ,1.3237e+02 ,1.5131e+02 /)
      kao(:, 1,11,16) = (/ &
     &4.2772e+01 ,3.7423e+01 ,3.4479e+01 ,4.9359e+01 ,6.5807e+01 ,8.2260e+01 , &
     &9.8714e+01 ,1.1516e+02 ,1.3161e+02 /)
      kao(:, 2,11,16) = (/ &
     &4.2480e+01 ,3.7168e+01 ,3.6886e+01 ,5.4309e+01 ,7.2413e+01 ,9.0516e+01 , &
     &1.0859e+02 ,1.2671e+02 ,1.4483e+02 /)
      kao(:, 3,11,16) = (/ &
     &4.3695e+01 ,3.8234e+01 ,3.9646e+01 ,5.8582e+01 ,7.8105e+01 ,9.7632e+01 , &
     &1.1715e+02 ,1.3667e+02 ,1.5621e+02 /)
      kao(:, 4,11,16) = (/ &
     &4.5497e+01 ,3.9810e+01 ,4.2112e+01 ,6.2236e+01 ,8.2974e+01 ,1.0371e+02 , &
     &1.2447e+02 ,1.4520e+02 ,1.6595e+02 /)
      kao(:, 5,11,16) = (/ &
     &4.7319e+01 ,4.1402e+01 ,4.4245e+01 ,6.5288e+01 ,8.7037e+01 ,1.0880e+02 , &
     &1.3053e+02 ,1.5228e+02 ,1.7407e+02 /)
      kao(:, 1,12,16) = (/ &
     &6.3760e+01 ,5.5793e+01 ,4.7823e+01 ,5.6928e+01 ,7.5904e+01 ,9.4850e+01 , &
     &1.1385e+02 ,1.3279e+02 ,1.5181e+02 /)
      kao(:, 2,12,16) = (/ &
     &6.5427e+01 ,5.7247e+01 ,4.9649e+01 ,6.2349e+01 ,8.3126e+01 ,1.0392e+02 , &
     &1.2469e+02 ,1.4546e+02 ,1.6625e+02 /)
      kao(:, 3,12,16) = (/ &
     &6.8202e+01 ,5.9674e+01 ,5.2535e+01 ,6.6975e+01 ,8.9301e+01 ,1.1163e+02 , &
     &1.3393e+02 ,1.5627e+02 ,1.7860e+02 /)
      kao(:, 4,12,16) = (/ &
     &7.0922e+01 ,6.2055e+01 ,5.5321e+01 ,7.0905e+01 ,9.4539e+01 ,1.1818e+02 , &
     &1.4181e+02 ,1.6544e+02 ,1.8908e+02 /)
      kao(:, 5,12,16) = (/ &
     &7.3649e+01 ,6.4442e+01 ,5.7813e+01 ,7.4307e+01 ,9.9092e+01 ,1.2384e+02 , &
     &1.4863e+02 ,1.7339e+02 ,1.9818e+02 /)
      kao(:, 1,13,16) = (/ &
     &7.8782e+01 ,6.8941e+01 ,5.9088e+01 ,6.5861e+01 ,8.6369e+01 ,1.0796e+02 , &
     &1.2954e+02 ,1.5113e+02 ,1.7274e+02 /)
      kao(:, 2,13,16) = (/ &
     &8.1731e+01 ,7.1509e+01 ,6.1634e+01 ,7.1635e+01 ,9.4482e+01 ,1.1810e+02 , &
     &1.4170e+02 ,1.6534e+02 ,1.8896e+02 /)
      kao(:, 3,13,16) = (/ &
     &8.5240e+01 ,7.4588e+01 ,6.4915e+01 ,7.6648e+01 ,1.0154e+02 ,1.2693e+02 , &
     &1.5232e+02 ,1.7766e+02 ,2.0308e+02 /)
      kao(:, 4,13,16) = (/ &
     &8.8622e+01 ,7.7543e+01 ,6.7967e+01 ,8.0867e+01 ,1.0759e+02 ,1.3449e+02 , &
     &1.6139e+02 ,1.8828e+02 ,2.1519e+02 /)
      kao(:, 5,13,16) = (/ &
     &9.1737e+01 ,8.0288e+01 ,7.0891e+01 ,8.4742e+01 ,1.1298e+02 ,1.4117e+02 , &
     &1.6939e+02 ,1.9762e+02 ,2.2595e+02 /)

!     The array FORREFO contains the coefficient of the water vapor
!     foreign-continuum (including the energy term).  The first 
!     index refers to reference temperature (296,260,224,260) and 
!     pressure (970,475,219,3 mbar) levels.  The second index 
!     runs over the g-channel (1 to 16).

      forrefo(1,:) = (/ &
     &1.4739e-04 ,3.1686e-04 ,8.5973e-04 ,1.9039e-03 ,3.1820e-03 ,3.6596e-03 , &
     &3.8724e-03 ,3.6785e-03 ,3.7141e-03 ,3.7646e-03 ,4.2955e-03 ,4.6343e-03 , &
     &5.0612e-03 ,4.0227e-03 ,4.2966e-03 ,4.6622e-03 /)
      forrefo(2,:) = (/ &
     &1.9397e-04 ,3.6322e-04 ,8.9797e-04 ,2.1001e-03 ,3.0307e-03 ,3.5563e-03 , &
     &3.8498e-03 ,3.5741e-03 ,3.5914e-03 ,3.7658e-03 ,3.8895e-03 ,4.4072e-03 , &
     &4.7112e-03 ,4.2230e-03 ,4.2666e-03 ,4.6634e-03 /)
      forrefo(3,:) = (/ &
     &3.1506e-04 ,7.3687e-04 ,1.9678e-03 ,2.5531e-03 ,2.8345e-03 ,2.7809e-03 , &
     &2.9124e-03 ,2.7125e-03 ,2.6644e-03 ,2.4907e-03 ,2.7032e-03 ,4.0967e-03 , &
     &4.1971e-03 ,4.4507e-03 ,4.2293e-03 ,4.6633e-03 /)
      forrefo(4,:) = (/ &
     &8.8196e-04 ,2.1125e-03 ,2.8042e-03 ,2.8891e-03 ,2.4362e-03 ,1.8733e-03 , &
     &1.4078e-03 ,1.1987e-03 ,1.2808e-03 ,8.9050e-04 ,9.4375e-04 ,7.8351e-04 , &
     &1.0756e-03 ,1.6586e-03 ,1.7511e-03 ,4.7803e-03 /)

!     The array SELFREFO contains the coefficient of the water vapor
!     self-continuum (including the energy term).  The first index
!     refers to temperature in 7.2 degree increments.  For instance,
!     JT = 1 refers to a temperature of 245.6, JT = 2 refers to 252.8,
!     etc.  The second index runs over the g-channel (1 to 16).

      selfrefo(:, 1) = (/ &
     & 2.37879e-02 , 2.10719e-02 , 1.86660e-02 , 1.65348e-02 , 1.46469e-02 , &
     & 1.29746e-02 , 1.14932e-02 , 1.01810e-02 , 9.01858e-03 , 7.98888e-03 /)
      selfrefo(:, 2) = (/ &
     & 3.10625e-02 , 2.82664e-02 , 2.57220e-02 , 2.34066e-02 , 2.12997e-02 , &
     & 1.93824e-02 , 1.76377e-02 , 1.60500e-02 , 1.46053e-02 , 1.32906e-02 /)
      selfrefo(:, 3) = (/ &
     & 5.19103e-02 , 4.80004e-02 , 4.43850e-02 , 4.10419e-02 , 3.79506e-02 , &
     & 3.50922e-02 , 3.24491e-02 , 3.00050e-02 , 2.77450e-02 , 2.56553e-02 /)
      selfrefo(:, 4) = (/ &
     & 9.12444e-02 , 8.38675e-02 , 7.70870e-02 , 7.08547e-02 , 6.51263e-02 , &
     & 5.98610e-02 , 5.50214e-02 , 5.05730e-02 , 4.64843e-02 , 4.27262e-02 /)
      selfrefo(:, 5) = (/ &
     & 1.11323e-01 , 1.04217e-01 , 9.75650e-02 , 9.13376e-02 , 8.55076e-02 , &
     & 8.00498e-02 , 7.49403e-02 , 7.01570e-02 , 6.56790e-02 , 6.14868e-02 /)
      selfrefo(:, 6) = (/ &
     & 1.25301e-01 , 1.16877e-01 , 1.09020e-01 , 1.01691e-01 , 9.48543e-02 , &
     & 8.84774e-02 , 8.25293e-02 , 7.69810e-02 , 7.18057e-02 , 6.69784e-02 /)
      selfrefo(:, 7) = (/ &
     & 1.34063e-01 , 1.24662e-01 , 1.15920e-01 , 1.07791e-01 , 1.00232e-01 , &
     & 9.32035e-02 , 8.66676e-02 , 8.05900e-02 , 7.49386e-02 , 6.96836e-02 /)
      selfrefo(:, 8) = (/ &
     & 1.26997e-01 , 1.18306e-01 , 1.10210e-01 , 1.02668e-01 , 9.56417e-02 , &
     & 8.90964e-02 , 8.29991e-02 , 7.73190e-02 , 7.20276e-02 , 6.70984e-02 /)
      selfrefo(:, 9) = (/ &
     & 1.28823e-01 , 1.20235e-01 , 1.12220e-01 , 1.04739e-01 , 9.77569e-02 , &
     & 9.12402e-02 , 8.51579e-02 , 7.94810e-02 , 7.41826e-02 , 6.92374e-02 /)
      selfrefo(:,10) = (/ &
     & 1.35802e-01 , 1.25981e-01 , 1.16870e-01 , 1.08418e-01 , 1.00577e-01 , &
     & 9.33034e-02 , 8.65557e-02 , 8.02960e-02 , 7.44890e-02 , 6.91020e-02 /)
      selfrefo(:,11) = (/ &
     & 1.35475e-01 , 1.27572e-01 , 1.20130e-01 , 1.13122e-01 , 1.06523e-01 , &
     & 1.00309e-01 , 9.44573e-02 , 8.89470e-02 , 8.37582e-02 , 7.88721e-02 /)
      selfrefo(:,12) = (/ &
     & 1.51195e-01 , 1.41159e-01 , 1.31790e-01 , 1.23043e-01 , 1.14876e-01 , &
     & 1.07251e-01 , 1.00132e-01 , 9.34860e-02 , 8.72809e-02 , 8.14877e-02 /)
      selfrefo(:,13) = (/ &
     & 1.57538e-01 , 1.47974e-01 , 1.38990e-01 , 1.30552e-01 , 1.22626e-01 , &
     & 1.15181e-01 , 1.08188e-01 , 1.01620e-01 , 9.54505e-02 , 8.96556e-02 /)
      selfrefo(:,14) = (/ &
     & 1.53567e-01 , 1.41564e-01 , 1.30500e-01 , 1.20300e-01 , 1.10898e-01 , &
     & 1.02231e-01 , 9.42406e-02 , 8.68750e-02 , 8.00851e-02 , 7.38259e-02 /)
      selfrefo(:,15) = (/ &
     & 1.53687e-01 , 1.42981e-01 , 1.33020e-01 , 1.23753e-01 , 1.15132e-01 , &
     & 1.07112e-01 , 9.96500e-02 , 9.27080e-02 , 8.62496e-02 , 8.02412e-02 /)
      selfrefo(:,16) = (/ &
     & 1.65129e-01 , 1.53285e-01 , 1.42290e-01 , 1.32084e-01 , 1.22610e-01 , &
     & 1.13815e-01 , 1.05651e-01 , 9.80730e-02 , 9.10384e-02 , 8.45083e-02 /)

      end subroutine lw_kgb12
