!     path:      $Source$
!     author:    $Author$
!     revision:  $Revision$
!     created:   $Date$
!
!  --------------------------------------------------------------------------
! |                                                                          |
! |  Copyright 2002-2009, Atmospheric & Environmental Research, Inc. (AER).  |
! |  This software may be used, copied, or redistributed as long as it is    |
! |  not sold and this copyright notice is reproduced on each copy made.     |
! |  This model is provided as is without any express or implied warranties. |
! |                       (http://www.rtweb.aer.com/)                        |
! |                                                                          |
!  --------------------------------------------------------------------------

! **************************************************************************
!      subroutine lw_kgbnn
! **************************************************************************
!  RRTM Longwave Radiative Transfer Model
!  Atmospheric and Environmental Research, Inc., Cambridge, MA
!
!  Original version:   E. J. Mlawer, et al.
!  Revision for GCMs:  Michael J. Iacono; October, 2002
!  Revision for F90 formatting:  Michael J. Iacono; June 2006
!
!  This file contains 16 subroutines that include the 
!  absorption coefficients and other data for each of the 16 longwave
!  spectral bands used in RRTM.  Here, the data are defined for 16
!  g-points, or sub-intervals, per band.  These data are combined and
!  weighted using a mapping procedure in routine RRTMG_LW_INIT to reduce
!  the total number of g-points from 256 to 140 for use in the GCM.
! **************************************************************************
      subroutine lw_kgb11
! **************************************************************************

       !use parkind, only : im => kind , rb => kind  
      use rrlw_kg11, only : fracrefao, fracrefbo, kao, kbo, kao_mo2, &
                            kbo_mo2, selfrefo, forrefo

      implicit none
      save

! Planck fraction mapping level : P=1053.63 mb, T= 294.2 K
      fracrefao(:) = (/ &
     &  1.4601e-01 ,1.3824e-01 ,1.4240e-01 ,1.3463e-01 ,1.1948e-01 ,1.0440e-01 , &
     &  8.8667e-02 ,6.5792e-02 ,4.3893e-02 ,4.7941e-03 ,4.0760e-03 ,3.3207e-03 , &
     &  2.4087e-03 ,1.3912e-03 ,4.3482e-04 ,6.0932e-05 /)

! Planck fraction mapping level : P=0.353 mb, T = 262.11 K
      fracrefbo(:) = (/ &
     &  7.2928e-02 ,1.4900e-01 ,1.6156e-01 ,1.5603e-01 ,1.3934e-01 ,1.1394e-01 , &
     &  8.8783e-02 ,6.2411e-02 ,4.0191e-02 ,4.4587e-03 ,3.9533e-03 ,3.0847e-03 , &
     &  2.2317e-03 ,1.4410e-03 ,5.6722e-04 ,7.7933e-05 /)

!     The array KAO contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels > ~100mb and temperatures.  The first
!     index in the array, JT, which runs from 1 to 5, corresponds to 
!     different temperatures.  More specifically, JT = 3 means that the 
!     data are for the corresponding TREF for this  pressure level, 
!     JT = 2 refers to the temperatureTREF-15, JT = 1 is for TREF-30, 
!     JT = 4 is for TREF+15, and JT = 5 is for TREF+30.  The second 
!     index, JP, runs from 1 to 13 and refers to the corresponding 
!     pressure level in PREF (e.g. JP = 1 is for a pressure of 1053.63 mb).  
!     The third index, IG, goes from 1 to 16, and tells us which 
!     g-interval the absorption coefficients are for.

      kao(:, 1, 1) = (/ &
     &4.9423e-02 ,4.8938e-02 ,4.8236e-02 ,4.7630e-02 ,4.7027e-02 /)
      kao(:, 2, 1) = (/ &
     &4.0264e-02 ,3.9991e-02 ,3.9414e-02 ,3.8921e-02 ,3.8455e-02 /)
      kao(:, 3, 1) = (/ &
     &3.2762e-02 ,3.2612e-02 ,3.2225e-02 ,3.1842e-02 ,3.1448e-02 /)
      kao(:, 4, 1) = (/ &
     &2.6929e-02 ,2.6828e-02 ,2.6636e-02 ,2.6311e-02 ,2.5979e-02 /)
      kao(:, 5, 1) = (/ &
     &2.2254e-02 ,2.2190e-02 ,2.2139e-02 ,2.1844e-02 ,2.1606e-02 /)
      kao(:, 6, 1) = (/ &
     &1.8428e-02 ,1.8406e-02 ,1.8346e-02 ,1.8223e-02 ,1.7986e-02 /)
      kao(:, 7, 1) = (/ &
     &1.5302e-02 ,1.5279e-02 ,1.5227e-02 ,1.5173e-02 ,1.5001e-02 /)
      kao(:, 8, 1) = (/ &
     &1.2917e-02 ,1.2821e-02 ,1.2762e-02 ,1.2673e-02 ,1.2614e-02 /)
      kao(:, 9, 1) = (/ &
     &1.4361e-02 ,1.3355e-02 ,1.2836e-02 ,1.2424e-02 ,1.2069e-02 /)
      kao(:,10, 1) = (/ &
     &1.9078e-02 ,1.9077e-02 ,1.9301e-02 ,1.9494e-02 ,1.9600e-02 /)
      kao(:,11, 1) = (/ &
     &1.6651e-02 ,1.7279e-02 ,1.7762e-02 ,1.8212e-02 ,1.8508e-02 /)
      kao(:,12, 1) = (/ &
     &1.4359e-02 ,1.4912e-02 ,1.5370e-02 ,1.5766e-02 ,1.6068e-02 /)
      kao(:,13, 1) = (/ &
     &1.2190e-02 ,1.2693e-02 ,1.3086e-02 ,1.3355e-02 ,1.3602e-02 /)
      kao(:, 1, 2) = (/ &
     &1.3874e-01 ,1.3507e-01 ,1.3188e-01 ,1.2875e-01 ,1.2573e-01 /)
      kao(:, 2, 2) = (/ &
     &1.1449e-01 ,1.1143e-01 ,1.0880e-01 ,1.0626e-01 ,1.0384e-01 /)
      kao(:, 3, 2) = (/ &
     &9.4610e-02 ,9.2157e-02 ,8.9899e-02 ,8.7836e-02 ,8.5813e-02 /)
      kao(:, 4, 2) = (/ &
     &7.8921e-02 ,7.6917e-02 ,7.5042e-02 ,7.3283e-02 ,7.1619e-02 /)
      kao(:, 5, 2) = (/ &
     &6.6025e-02 ,6.4395e-02 ,6.2788e-02 ,6.1406e-02 ,5.9938e-02 /)
      kao(:, 6, 2) = (/ &
     &5.5198e-02 ,5.3979e-02 ,5.2652e-02 ,5.1421e-02 ,5.0291e-02 /)
      kao(:, 7, 2) = (/ &
     &4.5982e-02 ,4.5142e-02 ,4.4142e-02 ,4.3045e-02 ,4.2121e-02 /)
      kao(:, 8, 2) = (/ &
     &3.8128e-02 ,3.7632e-02 ,3.6913e-02 ,3.6127e-02 ,3.5207e-02 /)
      kao(:, 9, 2) = (/ &
     &2.9988e-02 ,3.0199e-02 ,2.9924e-02 ,2.9588e-02 ,2.9106e-02 /)
      kao(:,10, 2) = (/ &
     &4.8557e-02 ,4.4974e-02 ,3.7588e-02 ,3.1508e-02 ,2.7381e-02 /)
      kao(:,11, 2) = (/ &
     &4.6113e-02 ,4.4271e-02 ,4.2375e-02 ,4.0024e-02 ,3.7665e-02 /)
      kao(:,12, 2) = (/ &
     &4.0305e-02 ,3.9408e-02 ,3.7504e-02 ,3.5981e-02 ,3.4390e-02 /)
      kao(:,13, 2) = (/ &
     &3.3779e-02 ,3.2735e-02 ,3.1178e-02 ,2.9814e-02 ,2.8271e-02 /)
      kao(:, 1, 3) = (/ &
     &2.4150e-01 ,2.3616e-01 ,2.3111e-01 ,2.2673e-01 ,2.2290e-01 /)
      kao(:, 2, 3) = (/ &
     &2.0007e-01 ,1.9568e-01 ,1.9176e-01 ,1.8825e-01 ,1.8518e-01 /)
      kao(:, 3, 3) = (/ &
     &1.6573e-01 ,1.6221e-01 ,1.5908e-01 ,1.5616e-01 ,1.5376e-01 /)
      kao(:, 4, 3) = (/ &
     &1.3876e-01 ,1.3573e-01 ,1.3298e-01 ,1.3059e-01 ,1.2856e-01 /)
      kao(:, 5, 3) = (/ &
     &1.1663e-01 ,1.1399e-01 ,1.1156e-01 ,1.0951e-01 ,1.0785e-01 /)
      kao(:, 6, 3) = (/ &
     &9.8259e-02 ,9.5861e-02 ,9.3802e-02 ,9.1948e-02 ,9.0492e-02 /)
      kao(:, 7, 3) = (/ &
     &8.2887e-02 ,8.0616e-02 ,7.8766e-02 ,7.7206e-02 ,7.5856e-02 /)
      kao(:, 8, 3) = (/ &
     &6.9730e-02 ,6.7730e-02 ,6.5964e-02 ,6.4565e-02 ,6.3437e-02 /)
      kao(:, 9, 3) = (/ &
     &5.8101e-02 ,5.6452e-02 ,5.5028e-02 ,5.3674e-02 ,5.2557e-02 /)
      kao(:,10, 3) = (/ &
     &3.7373e-02 ,3.5041e-02 ,3.8621e-02 ,4.1558e-02 ,4.3012e-02 /)
      kao(:,11, 3) = (/ &
     &5.3584e-02 ,4.0890e-02 ,3.3882e-02 ,2.9034e-02 ,2.6383e-02 /)
      kao(:,12, 3) = (/ &
     &5.8428e-02 ,4.4689e-02 ,3.5111e-02 ,2.9172e-02 ,2.4695e-02 /)
      kao(:,13, 3) = (/ &
     &4.7904e-02 ,3.6965e-02 ,2.8601e-02 ,2.3919e-02 ,2.0680e-02 /)
      kao(:, 1, 4) = (/ &
     &4.2548e-01 ,4.1807e-01 ,4.1094e-01 ,4.0423e-01 ,3.9806e-01 /)
      kao(:, 2, 4) = (/ &
     &3.5494e-01 ,3.4863e-01 ,3.4235e-01 ,3.3657e-01 ,3.3155e-01 /)
      kao(:, 3, 4) = (/ &
     &2.9648e-01 ,2.9099e-01 ,2.8545e-01 ,2.8071e-01 ,2.7648e-01 /)
      kao(:, 4, 4) = (/ &
     &2.4939e-01 ,2.4483e-01 ,2.4021e-01 ,2.3626e-01 ,2.3256e-01 /)
      kao(:, 5, 4) = (/ &
     &2.1025e-01 ,2.0654e-01 ,2.0285e-01 ,1.9937e-01 ,1.9615e-01 /)
      kao(:, 6, 4) = (/ &
     &1.7714e-01 ,1.7417e-01 ,1.7124e-01 ,1.6826e-01 ,1.6547e-01 /)
      kao(:, 7, 4) = (/ &
     &1.4884e-01 ,1.4658e-01 ,1.4422e-01 ,1.4179e-01 ,1.3940e-01 /)
      kao(:, 8, 4) = (/ &
     &1.2471e-01 ,1.2286e-01 ,1.2117e-01 ,1.1917e-01 ,1.1721e-01 /)
      kao(:, 9, 4) = (/ &
     &1.0337e-01 ,1.0218e-01 ,1.0077e-01 ,9.9333e-02 ,9.7869e-02 /)
      kao(:,10, 4) = (/ &
     &8.5198e-02 ,8.3413e-02 ,8.1099e-02 ,7.8395e-02 ,7.6293e-02 /)
      kao(:,11, 4) = (/ &
     &6.0820e-02 ,6.7915e-02 ,6.7626e-02 ,6.6844e-02 ,6.6371e-02 /)
      kao(:,12, 4) = (/ &
     &4.0000e-02 ,4.8190e-02 ,5.3574e-02 ,5.5575e-02 ,5.5151e-02 /)
      kao(:,13, 4) = (/ &
     &3.3587e-02 ,4.0386e-02 ,4.5135e-02 ,4.6401e-02 ,4.5805e-02 /)
      kao(:, 1, 5) = (/ &
     &7.7524e-01 ,7.6536e-01 ,7.5522e-01 ,7.4431e-01 ,7.3311e-01 /)
      kao(:, 2, 5) = (/ &
     &6.5185e-01 ,6.4405e-01 ,6.3568e-01 ,6.2684e-01 ,6.1765e-01 /)
      kao(:, 3, 5) = (/ &
     &5.4580e-01 ,5.3942e-01 ,5.3289e-01 ,5.2546e-01 ,5.1768e-01 /)
      kao(:, 4, 5) = (/ &
     &4.5945e-01 ,4.5416e-01 ,4.4868e-01 ,4.4229e-01 ,4.3592e-01 /)
      kao(:, 5, 5) = (/ &
     &3.8777e-01 ,3.8350e-01 ,3.7876e-01 ,3.7352e-01 ,3.6853e-01 /)
      kao(:, 6, 5) = (/ &
     &3.2750e-01 ,3.2403e-01 ,3.2009e-01 ,3.1598e-01 ,3.1216e-01 /)
      kao(:, 7, 5) = (/ &
     &2.7610e-01 ,2.7333e-01 ,2.7016e-01 ,2.6699e-01 ,2.6402e-01 /)
      kao(:, 8, 5) = (/ &
     &2.3237e-01 ,2.3021e-01 ,2.2764e-01 ,2.2511e-01 ,2.2263e-01 /)
      kao(:, 9, 5) = (/ &
     &1.9461e-01 ,1.9312e-01 ,1.9116e-01 ,1.8911e-01 ,1.8708e-01 /)
      kao(:,10, 5) = (/ &
     &1.4772e-01 ,1.4997e-01 ,1.5067e-01 ,1.5164e-01 ,1.5169e-01 /)
      kao(:,11, 5) = (/ &
     &1.1317e-01 ,1.1322e-01 ,1.1552e-01 ,1.1824e-01 ,1.1886e-01 /)
      kao(:,12, 5) = (/ &
     &9.7948e-02 ,9.4310e-02 ,9.3527e-02 ,9.3094e-02 ,9.5273e-02 /)
      kao(:,13, 5) = (/ &
     &8.1443e-02 ,7.8686e-02 ,7.8076e-02 ,7.8298e-02 ,8.0221e-02 /)
      kao(:, 1, 6) = (/ &
     &1.5697e+00 ,1.5485e+00 ,1.5270e+00 ,1.5062e+00 ,1.4845e+00 /)
      kao(:, 2, 6) = (/ &
     &1.3465e+00 ,1.3286e+00 ,1.3101e+00 ,1.2912e+00 ,1.2719e+00 /)
      kao(:, 3, 6) = (/ &
     &1.1474e+00 ,1.1322e+00 ,1.1161e+00 ,1.0997e+00 ,1.0837e+00 /)
      kao(:, 4, 6) = (/ &
     &9.7861e-01 ,9.6591e-01 ,9.5236e-01 ,9.3871e-01 ,9.2522e-01 /)
      kao(:, 5, 6) = (/ &
     &8.3345e-01 ,8.2282e-01 ,8.1147e-01 ,8.0015e-01 ,7.8882e-01 /)
      kao(:, 6, 6) = (/ &
     &7.0768e-01 ,6.9919e-01 ,6.8975e-01 ,6.8018e-01 ,6.7024e-01 /)
      kao(:, 7, 6) = (/ &
     &5.9916e-01 ,5.9240e-01 ,5.8444e-01 ,5.7632e-01 ,5.6762e-01 /)
      kao(:, 8, 6) = (/ &
     &5.0612e-01 ,5.0051e-01 ,4.9423e-01 ,4.8731e-01 ,4.7989e-01 /)
      kao(:, 9, 6) = (/ &
     &4.2622e-01 ,4.2196e-01 ,4.1690e-01 ,4.1124e-01 ,4.0525e-01 /)
      kao(:,10, 6) = (/ &
     &3.5041e-01 ,3.4937e-01 ,3.4686e-01 ,3.4326e-01 ,3.3900e-01 /)
      kao(:,11, 6) = (/ &
     &2.8138e-01 ,2.8270e-01 ,2.8314e-01 ,2.8109e-01 ,2.7863e-01 /)
      kao(:,12, 6) = (/ &
     &2.2569e-01 ,2.3115e-01 ,2.3249e-01 ,2.3233e-01 ,2.3100e-01 /)
      kao(:,13, 6) = (/ &
     &1.8817e-01 ,1.9206e-01 ,1.9341e-01 ,1.9316e-01 ,1.9216e-01 /)
      kao(:, 1, 7) = (/ &
     &3.4196e+00 ,3.3801e+00 ,3.3399e+00 ,3.2946e+00 ,3.2477e+00 /)
      kao(:, 2, 7) = (/ &
     &3.0295e+00 ,2.9903e+00 ,2.9469e+00 ,2.9032e+00 ,2.8599e+00 /)
      kao(:, 3, 7) = (/ &
     &2.6483e+00 ,2.6096e+00 ,2.5696e+00 ,2.5316e+00 ,2.4936e+00 /)
      kao(:, 4, 7) = (/ &
     &2.3044e+00 ,2.2705e+00 ,2.2374e+00 ,2.2055e+00 ,2.1724e+00 /)
      kao(:, 5, 7) = (/ &
     &1.9970e+00 ,1.9688e+00 ,1.9416e+00 ,1.9143e+00 ,1.8852e+00 /)
      kao(:, 6, 7) = (/ &
     &1.7224e+00 ,1.6992e+00 ,1.6760e+00 ,1.6526e+00 ,1.6276e+00 /)
      kao(:, 7, 7) = (/ &
     &1.4770e+00 ,1.4579e+00 ,1.4384e+00 ,1.4185e+00 ,1.3976e+00 /)
      kao(:, 8, 7) = (/ &
     &1.2593e+00 ,1.2433e+00 ,1.2274e+00 ,1.2112e+00 ,1.1939e+00 /)
      kao(:, 9, 7) = (/ &
     &1.0697e+00 ,1.0563e+00 ,1.0434e+00 ,1.0295e+00 ,1.0150e+00 /)
      kao(:,10, 7) = (/ &
     &9.0213e-01 ,8.9139e-01 ,8.8119e-01 ,8.6954e-01 ,8.5716e-01 /)
      kao(:,11, 7) = (/ &
     &7.5061e-01 ,7.4446e-01 ,7.3597e-01 ,7.2638e-01 ,7.1615e-01 /)
      kao(:,12, 7) = (/ &
     &6.2457e-01 ,6.1924e-01 ,6.1219e-01 ,6.0465e-01 ,5.9633e-01 /)
      kao(:,13, 7) = (/ &
     &5.2204e-01 ,5.1758e-01 ,5.1182e-01 ,5.0530e-01 ,4.9787e-01 /)
      kao(:, 1, 8) = (/ &
     &7.9795e+00 ,7.8457e+00 ,7.7132e+00 ,7.5890e+00 ,7.4645e+00 /)
      kao(:, 2, 8) = (/ &
     &7.5076e+00 ,7.3733e+00 ,7.2519e+00 ,7.1316e+00 ,7.0099e+00 /)
      kao(:, 3, 8) = (/ &
     &6.9340e+00 ,6.8148e+00 ,6.7036e+00 ,6.5875e+00 ,6.4766e+00 /)
      kao(:, 4, 8) = (/ &
     &6.3414e+00 ,6.2366e+00 ,6.1298e+00 ,6.0215e+00 ,5.9183e+00 /)
      kao(:, 5, 8) = (/ &
     &5.7373e+00 ,5.6423e+00 ,5.5412e+00 ,5.4426e+00 ,5.3434e+00 /)
      kao(:, 6, 8) = (/ &
     &5.1373e+00 ,5.0482e+00 ,4.9577e+00 ,4.8621e+00 ,4.7659e+00 /)
      kao(:, 7, 8) = (/ &
     &4.5492e+00 ,4.4684e+00 ,4.3821e+00 ,4.2928e+00 ,4.2067e+00 /)
      kao(:, 8, 8) = (/ &
     &3.9884e+00 ,3.9140e+00 ,3.8349e+00 ,3.7563e+00 ,3.6821e+00 /)
      kao(:, 9, 8) = (/ &
     &3.4656e+00 ,3.3995e+00 ,3.3300e+00 ,3.2636e+00 ,3.2010e+00 /)
      kao(:,10, 8) = (/ &
     &2.9841e+00 ,2.9267e+00 ,2.8680e+00 ,2.8124e+00 ,2.7592e+00 /)
      kao(:,11, 8) = (/ &
     &2.5294e+00 ,2.4795e+00 ,2.4321e+00 ,2.3862e+00 ,2.3418e+00 /)
      kao(:,12, 8) = (/ &
     &2.1315e+00 ,2.0918e+00 ,2.0527e+00 ,2.0146e+00 ,1.9776e+00 /)
      kao(:,13, 8) = (/ &
     &1.7932e+00 ,1.7598e+00 ,1.7272e+00 ,1.6957e+00 ,1.6643e+00 /)
      kao(:, 1, 9) = (/ &
     &1.8965e+01 ,1.8711e+01 ,1.8469e+01 ,1.8242e+01 ,1.8035e+01 /)
      kao(:, 2, 9) = (/ &
     &1.9621e+01 ,1.9373e+01 ,1.9124e+01 ,1.8882e+01 ,1.8648e+01 /)
      kao(:, 3, 9) = (/ &
     &2.0111e+01 ,1.9849e+01 ,1.9576e+01 ,1.9310e+01 ,1.9047e+01 /)
      kao(:, 4, 9) = (/ &
     &2.0303e+01 ,2.0017e+01 ,1.9726e+01 ,1.9447e+01 ,1.9174e+01 /)
      kao(:, 5, 9) = (/ &
     &2.0176e+01 ,1.9882e+01 ,1.9591e+01 ,1.9312e+01 ,1.9035e+01 /)
      kao(:, 6, 9) = (/ &
     &1.9747e+01 ,1.9457e+01 ,1.9166e+01 ,1.8888e+01 ,1.8606e+01 /)
      kao(:, 7, 9) = (/ &
     &1.9018e+01 ,1.8727e+01 ,1.8446e+01 ,1.8173e+01 ,1.7878e+01 /)
      kao(:, 8, 9) = (/ &
     &1.8015e+01 ,1.7734e+01 ,1.7466e+01 ,1.7191e+01 ,1.6898e+01 /)
      kao(:, 9, 9) = (/ &
     &1.6785e+01 ,1.6527e+01 ,1.6264e+01 ,1.5992e+01 ,1.5711e+01 /)
      kao(:,10, 9) = (/ &
     &1.5379e+01 ,1.5144e+01 ,1.4899e+01 ,1.4648e+01 ,1.4396e+01 /)
      kao(:,11, 9) = (/ &
     &1.3809e+01 ,1.3588e+01 ,1.3370e+01 ,1.3146e+01 ,1.2927e+01 /)
      kao(:,12, 9) = (/ &
     &1.2243e+01 ,1.2056e+01 ,1.1862e+01 ,1.1669e+01 ,1.1464e+01 /)
      kao(:,13, 9) = (/ &
     &1.0743e+01 ,1.0581e+01 ,1.0416e+01 ,1.0238e+01 ,1.0057e+01 /)
      kao(:, 1,10) = (/ &
     &3.4918e+01 ,3.4410e+01 ,3.3938e+01 ,3.3384e+01 ,3.2811e+01 /)
      kao(:, 2,10) = (/ &
     &3.7421e+01 ,3.6860e+01 ,3.6321e+01 ,3.5822e+01 ,3.5445e+01 /)
      kao(:, 3,10) = (/ &
     &4.0412e+01 ,3.9722e+01 ,3.9217e+01 ,3.8832e+01 ,3.8460e+01 /)
      kao(:, 4,10) = (/ &
     &4.3162e+01 ,4.2539e+01 ,4.2112e+01 ,4.1640e+01 ,4.1120e+01 /)
      kao(:, 5,10) = (/ &
     &4.5609e+01 ,4.5045e+01 ,4.4552e+01 ,4.3899e+01 ,4.3271e+01 /)
      kao(:, 6,10) = (/ &
     &4.7877e+01 ,4.7338e+01 ,4.6747e+01 ,4.6031e+01 ,4.5492e+01 /)
      kao(:, 7,10) = (/ &
     &4.9831e+01 ,4.9324e+01 ,4.8717e+01 ,4.8005e+01 ,4.7611e+01 /)
      kao(:, 8,10) = (/ &
     &5.1031e+01 ,5.0574e+01 ,4.9915e+01 ,4.9244e+01 ,4.8761e+01 /)
      kao(:, 9,10) = (/ &
     &5.1465e+01 ,5.0984e+01 ,5.0270e+01 ,4.9612e+01 ,4.9032e+01 /)
      kao(:,10,10) = (/ &
     &5.0911e+01 ,5.0267e+01 ,4.9512e+01 ,4.8818e+01 ,4.8092e+01 /)
      kao(:,11,10) = (/ &
     &4.8719e+01 ,4.7980e+01 ,4.7190e+01 ,4.6412e+01 ,4.5593e+01 /)
      kao(:,12,10) = (/ &
     &4.5566e+01 ,4.4779e+01 ,4.4020e+01 ,4.3287e+01 ,4.2695e+01 /)
      kao(:,13,10) = (/ &
     &4.1842e+01 ,4.1126e+01 ,4.0474e+01 ,3.9934e+01 ,3.9455e+01 /)
      kao(:, 1,11) = (/ &
     &4.3485e+01 ,4.3086e+01 ,4.2575e+01 ,4.2046e+01 ,4.1574e+01 /)
      kao(:, 2,11) = (/ &
     &4.8017e+01 ,4.7410e+01 ,4.6743e+01 ,4.6112e+01 ,4.5460e+01 /)
      kao(:, 3,11) = (/ &
     &5.1964e+01 ,5.1351e+01 ,5.0628e+01 ,4.9892e+01 ,4.9112e+01 /)
      kao(:, 4,11) = (/ &
     &5.5970e+01 ,5.5232e+01 ,5.4425e+01 ,5.3658e+01 ,5.2964e+01 /)
      kao(:, 5,11) = (/ &
     &6.0234e+01 ,5.9398e+01 ,5.8467e+01 ,5.7720e+01 ,5.7104e+01 /)
      kao(:, 6,11) = (/ &
     &6.4036e+01 ,6.3174e+01 ,6.2265e+01 ,6.1623e+01 ,6.0928e+01 /)
      kao(:, 7,11) = (/ &
     &6.7087e+01 ,6.6347e+01 ,6.5603e+01 ,6.4996e+01 ,6.4192e+01 /)
      kao(:, 8,11) = (/ &
     &6.9922e+01 ,6.9386e+01 ,6.8783e+01 ,6.8159e+01 ,6.7317e+01 /)
      kao(:, 9,11) = (/ &
     &7.2326e+01 ,7.1863e+01 ,7.1404e+01 ,7.0792e+01 ,6.9972e+01 /)
      kao(:,10,11) = (/ &
     &7.3782e+01 ,7.3486e+01 ,7.3017e+01 ,7.2321e+01 ,7.1486e+01 /)
      kao(:,11,11) = (/ &
     &7.4137e+01 ,7.3779e+01 ,7.3113e+01 ,7.2218e+01 ,7.1354e+01 /)
      kao(:,12,11) = (/ &
     &7.3214e+01 ,7.2506e+01 ,7.1526e+01 ,7.0521e+01 ,6.9446e+01 /)
      kao(:,13,11) = (/ &
     &7.0360e+01 ,6.9342e+01 ,6.8249e+01 ,6.7098e+01 ,6.5980e+01 /)
      kao(:, 1,12) = (/ &
     &5.1887e+01 ,5.1393e+01 ,5.0969e+01 ,5.0675e+01 ,5.0203e+01 /)
      kao(:, 2,12) = (/ &
     &5.9704e+01 ,5.9201e+01 ,5.8829e+01 ,5.8469e+01 ,5.7899e+01 /)
      kao(:, 3,12) = (/ &
     &6.7858e+01 ,6.7238e+01 ,6.6756e+01 ,6.6195e+01 ,6.5626e+01 /)
      kao(:, 4,12) = (/ &
     &7.5062e+01 ,7.4258e+01 ,7.3522e+01 ,7.2807e+01 ,7.2094e+01 /)
      kao(:, 5,12) = (/ &
     &8.1152e+01 ,8.0143e+01 ,7.9393e+01 ,7.8647e+01 ,7.7881e+01 /)
      kao(:, 6,12) = (/ &
     &8.7340e+01 ,8.6150e+01 ,8.5372e+01 ,8.4516e+01 ,8.3657e+01 /)
      kao(:, 7,12) = (/ &
     &9.4121e+01 ,9.2665e+01 ,9.1695e+01 ,9.0706e+01 ,8.9764e+01 /)
      kao(:, 8,12) = (/ &
     &1.0086e+02 ,9.9171e+01 ,9.7989e+01 ,9.6851e+01 ,9.5921e+01 /)
      kao(:, 9,12) = (/ &
     &1.0671e+02 ,1.0483e+02 ,1.0352e+02 ,1.0233e+02 ,1.0145e+02 /)
      kao(:,10,12) = (/ &
     &1.1135e+02 ,1.0957e+02 ,1.0846e+02 ,1.0742e+02 ,1.0652e+02 /)
      kao(:,11,12) = (/ &
     &1.1430e+02 ,1.1336e+02 ,1.1254e+02 ,1.1170e+02 ,1.1063e+02 /)
      kao(:,12,12) = (/ &
     &1.1681e+02 ,1.1638e+02 ,1.1571e+02 ,1.1469e+02 ,1.1347e+02 /)
      kao(:,13,12) = (/ &
     &1.1832e+02 ,1.1787e+02 ,1.1696e+02 ,1.1585e+02 ,1.1448e+02 /)
      kao(:, 1,13) = (/ &
     &6.2138e+01 ,6.1536e+01 ,6.0957e+01 ,6.0185e+01 ,5.9644e+01 /)
      kao(:, 2,13) = (/ &
     &7.3104e+01 ,7.2436e+01 ,7.1604e+01 ,7.0616e+01 ,6.9923e+01 /)
      kao(:, 3,13) = (/ &
     &8.5575e+01 ,8.4690e+01 ,8.3633e+01 ,8.2595e+01 ,8.1733e+01 /)
      kao(:, 4,13) = (/ &
     &9.8880e+01 ,9.7932e+01 ,9.6845e+01 ,9.5711e+01 ,9.4631e+01 /)
      kao(:, 5,13) = (/ &
     &1.1273e+02 ,1.1168e+02 ,1.1051e+02 ,1.0912e+02 ,1.0775e+02 /)
      kao(:, 6,13) = (/ &
     &1.2651e+02 ,1.2538e+02 ,1.2389e+02 ,1.2226e+02 ,1.2074e+02 /)
      kao(:, 7,13) = (/ &
     &1.4003e+02 ,1.3861e+02 ,1.3671e+02 ,1.3477e+02 ,1.3302e+02 /)
      kao(:, 8,13) = (/ &
     &1.5267e+02 ,1.5069e+02 ,1.4845e+02 ,1.4633e+02 ,1.4433e+02 /)
      kao(:, 9,13) = (/ &
     &1.6510e+02 ,1.6280e+02 ,1.6039e+02 ,1.5803e+02 ,1.5572e+02 /)
      kao(:,10,13) = (/ &
     &1.7758e+02 ,1.7506e+02 ,1.7227e+02 ,1.6951e+02 ,1.6718e+02 /)
      kao(:,11,13) = (/ &
     &1.8910e+02 ,1.8565e+02 ,1.8227e+02 ,1.7970e+02 ,1.7779e+02 /)
      kao(:,12,13) = (/ &
     &1.9894e+02 ,1.9500e+02 ,1.9204e+02 ,1.8987e+02 ,1.8782e+02 /)
      kao(:,13,13) = (/ &
     &2.0665e+02 ,2.0326e+02 ,2.0074e+02 ,1.9867e+02 ,1.9680e+02 /)
      kao(:, 1,14) = (/ &
     &7.2473e+01 ,7.1368e+01 ,7.0428e+01 ,6.9932e+01 ,6.9604e+01 /)
      kao(:, 2,14) = (/ &
     &8.7789e+01 ,8.6447e+01 ,8.5315e+01 ,8.4536e+01 ,8.3865e+01 /)
      kao(:, 3,14) = (/ &
     &1.0616e+02 ,1.0473e+02 ,1.0338e+02 ,1.0236e+02 ,1.0132e+02 /)
      kao(:, 4,14) = (/ &
     &1.2669e+02 ,1.2502e+02 ,1.2342e+02 ,1.2210e+02 ,1.2081e+02 /)
      kao(:, 5,14) = (/ &
     &1.4951e+02 ,1.4761e+02 ,1.4568e+02 ,1.4409e+02 ,1.4262e+02 /)
      kao(:, 6,14) = (/ &
     &1.7487e+02 ,1.7259e+02 ,1.7054e+02 ,1.6873e+02 ,1.6691e+02 /)
      kao(:, 7,14) = (/ &
     &2.0246e+02 ,2.0010e+02 ,1.9793e+02 ,1.9585e+02 ,1.9382e+02 /)
      kao(:, 8,14) = (/ &
     &2.3272e+02 ,2.3034e+02 ,2.2811e+02 ,2.2588e+02 ,2.2363e+02 /)
      kao(:, 9,14) = (/ &
     &2.6521e+02 ,2.6298e+02 ,2.6062e+02 ,2.5802e+02 ,2.5525e+02 /)
      kao(:,10,14) = (/ &
     &2.9843e+02 ,2.9609e+02 ,2.9357e+02 ,2.9069e+02 ,2.8721e+02 /)
      kao(:,11,14) = (/ &
     &3.3019e+02 ,3.2789e+02 ,3.2506e+02 ,3.2111e+02 ,3.1667e+02 /)
      kao(:,12,14) = (/ &
     &3.6200e+02 ,3.5928e+02 ,3.5512e+02 ,3.5030e+02 ,3.4598e+02 /)
      kao(:,13,14) = (/ &
     &3.9453e+02 ,3.9054e+02 ,3.8556e+02 ,3.8029e+02 ,3.7518e+02 /)
      kao(:, 1,15) = (/ &
     &8.4296e+01 ,8.4294e+01 ,8.4592e+01 ,8.4817e+01 ,8.4944e+01 /)
      kao(:, 2,15) = (/ &
     &1.0316e+02 ,1.0286e+02 ,1.0304e+02 ,1.0333e+02 ,1.0370e+02 /)
      kao(:, 3,15) = (/ &
     &1.2648e+02 ,1.2563e+02 ,1.2552e+02 ,1.2542e+02 ,1.2564e+02 /)
      kao(:, 4,15) = (/ &
     &1.5355e+02 ,1.5194e+02 ,1.5117e+02 ,1.5062e+02 ,1.5044e+02 /)
      kao(:, 5,15) = (/ &
     &1.8607e+02 ,1.8324e+02 ,1.8143e+02 ,1.8019e+02 ,1.7911e+02 /)
      kao(:, 6,15) = (/ &
     &2.2538e+02 ,2.2140e+02 ,2.1806e+02 ,2.1567e+02 ,2.1369e+02 /)
      kao(:, 7,15) = (/ &
     &2.7204e+02 ,2.6705e+02 ,2.6220e+02 ,2.5861e+02 ,2.5549e+02 /)
      kao(:, 8,15) = (/ &
     &3.2681e+02 ,3.2069e+02 ,3.1478e+02 ,3.0961e+02 ,3.0517e+02 /)
      kao(:, 9,15) = (/ &
     &3.9109e+02 ,3.8311e+02 ,3.7570e+02 ,3.6941e+02 ,3.6369e+02 /)
      kao(:,10,15) = (/ &
     &4.6558e+02 ,4.5519e+02 ,4.4566e+02 ,4.3786e+02 ,4.3114e+02 /)
      kao(:,11,15) = (/ &
     &5.4422e+02 ,5.3170e+02 ,5.2160e+02 ,5.1300e+02 ,5.0502e+02 /)
      kao(:,12,15) = (/ &
     &6.3083e+02 ,6.1809e+02 ,6.0782e+02 ,5.9755e+02 ,5.8778e+02 /)
      kao(:,13,15) = (/ &
     &7.2633e+02 ,7.1401e+02 ,7.0254e+02 ,6.9098e+02 ,6.8020e+02 /)
      kao(:, 1,16) = (/ &
     &9.0293e+01 ,9.1524e+01 ,9.2499e+01 ,9.3157e+01 ,9.3569e+01 /)
      kao(:, 2,16) = (/ &
     &1.1228e+02 ,1.1346e+02 ,1.1477e+02 ,1.1575e+02 ,1.1638e+02 /)
      kao(:, 3,16) = (/ &
     &1.3962e+02 ,1.4080e+02 ,1.4217e+02 ,1.4343e+02 ,1.4444e+02 /)
      kao(:, 4,16) = (/ &
     &1.7141e+02 ,1.7272e+02 ,1.7425e+02 ,1.7564e+02 ,1.7671e+02 /)
      kao(:, 5,16) = (/ &
     &2.0680e+02 ,2.1031e+02 ,2.1221e+02 ,2.1383e+02 ,2.1512e+02 /)
      kao(:, 6,16) = (/ &
     &2.5314e+02 ,2.5478e+02 ,2.5735e+02 ,2.5955e+02 ,2.6116e+02 /)
      kao(:, 7,16) = (/ &
     &3.0938e+02 ,3.0774e+02 ,3.1113e+02 ,3.1414e+02 ,3.1633e+02 /)
      kao(:, 8,16) = (/ &
     &3.7909e+02 ,3.7514e+02 ,3.7476e+02 ,3.7901e+02 ,3.8212e+02 /)
      kao(:, 9,16) = (/ &
     &4.6433e+02 ,4.5795e+02 ,4.5378e+02 ,4.5558e+02 ,4.5979e+02 /)
      kao(:,10,16) = (/ &
     &5.6730e+02 ,5.5767e+02 ,5.5088e+02 ,5.4957e+02 ,5.5150e+02 /)
      kao(:,11,16) = (/ &
     &6.8668e+02 ,6.7309e+02 ,6.6516e+02 ,6.6333e+02 ,6.6322e+02 /)
      kao(:,12,16) = (/ &
     &8.3053e+02 ,8.1176e+02 ,8.0043e+02 ,7.9744e+02 ,7.9485e+02 /)
      kao(:,13,16) = (/ &
     &1.0026e+03 ,9.7775e+02 ,9.6058e+02 ,9.5314e+02 ,9.4719e+02 /)

!     The array KBO contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels < ~100mb and temperatures. The first 
!     index in the array, JT, which runs from 1 to 5, corresponds to 
!     different temperatures.  More specifically, JT = 3 means that the 
!     data are for the reference temperature TREF for this pressure 
!     level, JT = 2 refers to the temperature TREF-15, JT = 1 is for
!     TREF-30, JT = 4 is for TREF+15, and JT = 5 is for TREF+30.  
!     The second index, JP, runs from 13 to 59 and refers to the JPth
!     reference pressure level (see taumol.f for the value of these
!     pressure levels in mb).  The third index, IG, goes from 1 to 16,
!     and tells us which g-interval the absorption coefficients are for.

      kbo(:,13, 1) = (/ &
     &1.2190e-02 ,1.2693e-02 ,1.3086e-02 ,1.3355e-02 ,1.3602e-02 /)
      kbo(:,14, 1) = (/ &
     &1.0639e-02 ,1.0991e-02 ,1.1315e-02 ,1.1564e-02 ,1.1518e-02 /)
      kbo(:,15, 1) = (/ &
     &9.4343e-03 ,9.6676e-03 ,9.5938e-03 ,9.5530e-03 ,9.4890e-03 /)
      kbo(:,16, 1) = (/ &
     &7.9681e-03 ,7.8419e-03 ,7.8162e-03 ,7.7492e-03 ,7.7652e-03 /)
      kbo(:,17, 1) = (/ &
     &6.4068e-03 ,6.3539e-03 ,6.3265e-03 ,6.3294e-03 ,6.2292e-03 /)
      kbo(:,18, 1) = (/ &
     &5.1420e-03 ,5.1335e-03 ,5.0780e-03 ,5.0408e-03 ,5.0223e-03 /)
      kbo(:,19, 1) = (/ &
     &4.1739e-03 ,4.1404e-03 ,4.1032e-03 ,4.0908e-03 ,4.0562e-03 /)
      kbo(:,20, 1) = (/ &
     &3.3887e-03 ,3.3668e-03 ,3.3481e-03 ,3.3359e-03 ,3.2948e-03 /)
      kbo(:,21, 1) = (/ &
     &2.7580e-03 ,2.7551e-03 ,2.7356e-03 ,2.7092e-03 ,2.6841e-03 /)
      kbo(:,22, 1) = (/ &
     &2.2558e-03 ,2.2435e-03 ,2.2235e-03 ,2.2041e-03 ,2.1870e-03 /)
      kbo(:,23, 1) = (/ &
     &1.8426e-03 ,1.8324e-03 ,1.8088e-03 ,1.7975e-03 ,1.7882e-03 /)
      kbo(:,24, 1) = (/ &
     &1.5091e-03 ,1.4914e-03 ,1.4770e-03 ,1.4698e-03 ,1.4675e-03 /)
      kbo(:,25, 1) = (/ &
     &1.2361e-03 ,1.2170e-03 ,1.2068e-03 ,1.2059e-03 ,1.2054e-03 /)
      kbo(:,26, 1) = (/ &
     &1.0050e-03 ,9.9424e-04 ,9.8921e-04 ,9.8950e-04 ,9.9102e-04 /)
      kbo(:,27, 1) = (/ &
     &8.1924e-04 ,8.1181e-04 ,8.1111e-04 ,8.1148e-04 ,8.1057e-04 /)
      kbo(:,28, 1) = (/ &
     &6.6881e-04 ,6.6398e-04 ,6.6473e-04 ,6.6536e-04 ,6.6057e-04 /)
      kbo(:,29, 1) = (/ &
     &5.4452e-04 ,5.4181e-04 ,5.4254e-04 ,5.4342e-04 ,5.3551e-04 /)
      kbo(:,30, 1) = (/ &
     &4.4259e-04 ,4.4140e-04 ,4.4207e-04 ,4.4326e-04 ,4.2874e-04 /)
      kbo(:,31, 1) = (/ &
     &3.5899e-04 ,3.5826e-04 ,3.5911e-04 ,3.5984e-04 ,3.4298e-04 /)
      kbo(:,32, 1) = (/ &
     &2.9138e-04 ,2.9104e-04 ,2.9178e-04 ,2.9237e-04 ,2.7522e-04 /)
      kbo(:,33, 1) = (/ &
     &2.3674e-04 ,2.3667e-04 ,2.3708e-04 ,2.3749e-04 ,2.2116e-04 /)
      kbo(:,34, 1) = (/ &
     &1.9293e-04 ,1.9295e-04 ,1.9307e-04 ,1.9353e-04 ,1.7944e-04 /)
      kbo(:,35, 1) = (/ &
     &1.5741e-04 ,1.5737e-04 ,1.5735e-04 ,1.5778e-04 ,1.4713e-04 /)
      kbo(:,36, 1) = (/ &
     &1.2872e-04 ,1.2833e-04 ,1.2856e-04 ,1.2886e-04 ,1.2147e-04 /)
      kbo(:,37, 1) = (/ &
     &1.0573e-04 ,1.0521e-04 ,1.0532e-04 ,1.0552e-04 ,1.0153e-04 /)
      kbo(:,38, 1) = (/ &
     &8.6912e-05 ,8.6294e-05 ,8.6278e-05 ,8.6393e-05 ,8.5663e-05 /)
      kbo(:,39, 1) = (/ &
     &7.1476e-05 ,7.0797e-05 ,7.0693e-05 ,7.0706e-05 ,7.0752e-05 /)
      kbo(:,40, 1) = (/ &
     &5.8778e-05 ,5.8375e-05 ,5.8149e-05 ,5.8120e-05 ,5.8038e-05 /)
      kbo(:,41, 1) = (/ &
     &4.8208e-05 ,4.8291e-05 ,4.7939e-05 ,4.7839e-05 ,4.7717e-05 /)
      kbo(:,42, 1) = (/ &
     &3.9735e-05 ,3.9794e-05 ,3.9588e-05 ,3.9414e-05 ,3.9275e-05 /)
      kbo(:,43, 1) = (/ &
     &3.3069e-05 ,3.2750e-05 ,3.2898e-05 ,3.2646e-05 ,3.2434e-05 /)
      kbo(:,44, 1) = (/ &
     &2.7160e-05 ,2.7263e-05 ,2.7120e-05 ,2.7165e-05 ,2.6874e-05 /)
      kbo(:,45, 1) = (/ &
     &2.2285e-05 ,2.2565e-05 ,2.2508e-05 ,2.2456e-05 ,2.2357e-05 /)
      kbo(:,46, 1) = (/ &
     &1.8468e-05 ,1.8529e-05 ,1.8744e-05 ,1.8640e-05 ,1.8584e-05 /)
      kbo(:,47, 1) = (/ &
     &1.5267e-05 ,1.5373e-05 ,1.5389e-05 ,1.5590e-05 ,1.5417e-05 /)
      kbo(:,48, 1) = (/ &
     &1.2576e-05 ,1.2765e-05 ,1.2771e-05 ,1.2828e-05 ,1.2953e-05 /)
      kbo(:,49, 1) = (/ &
     &1.0526e-05 ,1.0503e-05 ,1.0641e-05 ,1.0645e-05 ,1.0671e-05 /)
      kbo(:,50, 1) = (/ &
     &8.5146e-06 ,8.8286e-06 ,8.7879e-06 ,8.8870e-06 ,8.8515e-06 /)
      kbo(:,51, 1) = (/ &
     &6.8551e-06 ,7.1714e-06 ,7.4262e-06 ,7.3568e-06 ,7.4039e-06 /)
      kbo(:,52, 1) = (/ &
     &5.5111e-06 ,5.7854e-06 ,6.0431e-06 ,6.2230e-06 ,6.1473e-06 /)
      kbo(:,53, 1) = (/ &
     &4.4382e-06 ,4.6559e-06 ,4.8718e-06 ,5.0815e-06 ,5.1941e-06 /)
      kbo(:,54, 1) = (/ &
     &3.6177e-06 ,3.7935e-06 ,3.9613e-06 ,4.1342e-06 ,4.2936e-06 /)
      kbo(:,55, 1) = (/ &
     &2.9336e-06 ,3.1004e-06 ,3.2420e-06 ,3.3846e-06 ,3.5194e-06 /)
      kbo(:,56, 1) = (/ &
     &2.3777e-06 ,2.5393e-06 ,2.6559e-06 ,2.7737e-06 ,2.8819e-06 /)
      kbo(:,57, 1) = (/ &
     &1.9258e-06 ,2.0635e-06 ,2.1875e-06 ,2.2772e-06 ,2.3684e-06 /)
      kbo(:,58, 1) = (/ &
     &1.5658e-06 ,1.6813e-06 ,1.7910e-06 ,1.8800e-06 ,1.9530e-06 /)
      kbo(:,59, 1) = (/ &
     &1.3188e-06 ,1.4141e-06 ,1.4979e-06 ,1.5764e-06 ,1.6384e-06 /)
      kbo(:,13, 2) = (/ &
     &3.3779e-02 ,3.2735e-02 ,3.1178e-02 ,2.9814e-02 ,2.8271e-02 /)
      kbo(:,14, 2) = (/ &
     &2.7945e-02 ,2.6846e-02 ,2.5419e-02 ,2.4157e-02 ,2.2814e-02 /)
      kbo(:,15, 2) = (/ &
     &2.2748e-02 ,2.1521e-02 ,2.0571e-02 ,1.9559e-02 ,1.8047e-02 /)
      kbo(:,16, 2) = (/ &
     &1.8337e-02 ,1.7587e-02 ,1.6750e-02 ,1.5705e-02 ,1.3259e-02 /)
      kbo(:,17, 2) = (/ &
     &1.5034e-02 ,1.4343e-02 ,1.3736e-02 ,1.1541e-02 ,9.7400e-03 /)
      kbo(:,18, 2) = (/ &
     &1.2164e-02 ,1.1828e-02 ,9.9998e-03 ,8.2911e-03 ,6.9774e-03 /)
      kbo(:,19, 2) = (/ &
     &1.0053e-02 ,8.7760e-03 ,7.2944e-03 ,6.0291e-03 ,5.2188e-03 /)
      kbo(:,20, 2) = (/ &
     &8.0996e-03 ,6.6628e-03 ,5.4744e-03 ,4.5474e-03 ,4.0343e-03 /)
      kbo(:,21, 2) = (/ &
     &6.1685e-03 ,5.0455e-03 ,4.1278e-03 ,3.5537e-03 ,3.1461e-03 /)
      kbo(:,22, 2) = (/ &
     &4.6680e-03 ,3.7894e-03 ,3.1347e-03 ,2.7602e-03 ,2.4538e-03 /)
      kbo(:,23, 2) = (/ &
     &3.5105e-03 ,2.8430e-03 ,2.4311e-03 ,2.1442e-03 ,1.9116e-03 /)
      kbo(:,24, 2) = (/ &
     &2.6394e-03 ,2.1852e-03 ,1.8960e-03 ,1.6702e-03 ,1.4993e-03 /)
      kbo(:,25, 2) = (/ &
     &2.0041e-03 ,1.6920e-03 ,1.4784e-03 ,1.3107e-03 ,1.1883e-03 /)
      kbo(:,26, 2) = (/ &
     &1.5414e-03 ,1.3189e-03 ,1.1564e-03 ,1.0333e-03 ,9.4710e-04 /)
      kbo(:,27, 2) = (/ &
     &1.2025e-03 ,1.0381e-03 ,9.1423e-04 ,8.1996e-04 ,7.6323e-04 /)
      kbo(:,28, 2) = (/ &
     &9.4481e-04 ,8.2314e-04 ,7.2601e-04 ,6.5680e-04 ,6.2105e-04 /)
      kbo(:,29, 2) = (/ &
     &7.4291e-04 ,6.5138e-04 ,5.7968e-04 ,5.2914e-04 ,5.0508e-04 /)
      kbo(:,30, 2) = (/ &
     &5.8796e-04 ,5.1841e-04 ,4.6161e-04 ,4.2521e-04 ,4.1671e-04 /)
      kbo(:,31, 2) = (/ &
     &4.6334e-04 ,4.1198e-04 ,3.6828e-04 ,3.4267e-04 ,3.4322e-04 /)
      kbo(:,32, 2) = (/ &
     &3.6683e-04 ,3.2718e-04 ,2.9598e-04 ,2.7743e-04 ,2.8106e-04 /)
      kbo(:,33, 2) = (/ &
     &2.9220e-04 ,2.6104e-04 ,2.3912e-04 ,2.2529e-04 ,2.3032e-04 /)
      kbo(:,34, 2) = (/ &
     &2.3494e-04 ,2.1114e-04 ,1.9458e-04 ,1.8336e-04 ,1.8849e-04 /)
      kbo(:,35, 2) = (/ &
     &1.9117e-04 ,1.7220e-04 ,1.5969e-04 ,1.5013e-04 ,1.5359e-04 /)
      kbo(:,36, 2) = (/ &
     &1.5747e-04 ,1.4221e-04 ,1.3171e-04 ,1.2370e-04 ,1.2459e-04 /)
      kbo(:,37, 2) = (/ &
     &1.3250e-04 ,1.1910e-04 ,1.0968e-04 ,1.0296e-04 ,1.0130e-04 /)
      kbo(:,38, 2) = (/ &
     &1.1160e-04 ,9.9715e-05 ,9.1665e-05 ,8.5730e-05 ,8.1933e-05 /)
      kbo(:,39, 2) = (/ &
     &9.4135e-05 ,8.3974e-05 ,7.6783e-05 ,7.1718e-05 ,6.7517e-05 /)
      kbo(:,40, 2) = (/ &
     &8.0997e-05 ,7.2288e-05 ,6.5235e-05 ,6.0491e-05 ,5.6970e-05 /)
      kbo(:,41, 2) = (/ &
     &7.0436e-05 ,6.2097e-05 ,5.5431e-05 ,5.1123e-05 ,4.8054e-05 /)
      kbo(:,42, 2) = (/ &
     &6.1655e-05 ,5.3367e-05 ,4.7548e-05 ,4.3416e-05 ,4.0552e-05 /)
      kbo(:,43, 2) = (/ &
     &5.5272e-05 ,4.6832e-05 ,4.1549e-05 ,3.7143e-05 ,3.4563e-05 /)
      kbo(:,44, 2) = (/ &
     &5.0350e-05 ,4.1911e-05 ,3.6573e-05 ,3.2553e-05 ,2.9621e-05 /)
      kbo(:,45, 2) = (/ &
     &4.6680e-05 ,3.8062e-05 ,3.2149e-05 ,2.8703e-05 ,2.5694e-05 /)
      kbo(:,46, 2) = (/ &
     &4.2769e-05 ,3.5698e-05 ,2.9139e-05 ,2.5199e-05 ,2.2638e-05 /)
      kbo(:,47, 2) = (/ &
     &3.6477e-05 ,3.2822e-05 ,2.7467e-05 ,2.2730e-05 ,2.0075e-05 /)
      kbo(:,48, 2) = (/ &
     &3.0609e-05 ,2.9832e-05 ,2.5641e-05 ,2.1246e-05 ,1.7927e-05 /)
      kbo(:,49, 2) = (/ &
     &2.5892e-05 ,2.4976e-05 ,2.3819e-05 ,2.0178e-05 ,1.6719e-05 /)
      kbo(:,50, 2) = (/ &
     &2.2068e-05 ,2.0897e-05 ,2.0445e-05 ,1.8401e-05 ,1.5648e-05 /)
      kbo(:,51, 2) = (/ &
     &1.8894e-05 ,1.8060e-05 ,1.7047e-05 ,1.6809e-05 ,1.4426e-05 /)
      kbo(:,52, 2) = (/ &
     &1.6131e-05 ,1.5345e-05 ,1.4613e-05 ,1.3961e-05 ,1.3398e-05 /)
      kbo(:,53, 2) = (/ &
     &1.3727e-05 ,1.3222e-05 ,1.2619e-05 ,1.1906e-05 ,1.1467e-05 /)
      kbo(:,54, 2) = (/ &
     &1.1644e-05 ,1.1203e-05 ,1.0779e-05 ,1.0373e-05 ,9.7090e-06 /)
      kbo(:,55, 2) = (/ &
     &9.9606e-06 ,9.5440e-06 ,9.2216e-06 ,8.7822e-06 ,8.3198e-06 /)
      kbo(:,56, 2) = (/ &
     &8.4517e-06 ,8.1696e-06 ,7.8373e-06 ,7.5094e-06 ,7.2266e-06 /)
      kbo(:,57, 2) = (/ &
     &7.1634e-06 ,7.0985e-06 ,6.7296e-06 ,6.4794e-06 ,6.1647e-06 /)
      kbo(:,58, 2) = (/ &
     &6.2286e-06 ,5.9713e-06 ,5.8323e-06 ,5.5370e-06 ,5.3465e-06 /)
      kbo(:,59, 2) = (/ &
     &5.3307e-06 ,5.0367e-06 ,4.9690e-06 ,4.6758e-06 ,4.5062e-06 /)
      kbo(:,13, 3) = (/ &
     &4.7904e-02 ,3.6965e-02 ,2.8601e-02 ,2.3919e-02 ,2.0680e-02 /)
      kbo(:,14, 3) = (/ &
     &3.6570e-02 ,2.7810e-02 ,2.1848e-02 ,1.8508e-02 ,1.6582e-02 /)
      kbo(:,15, 3) = (/ &
     &2.6097e-02 ,1.9628e-02 ,1.6268e-02 ,1.4252e-02 ,1.3801e-02 /)
      kbo(:,16, 3) = (/ &
     &1.8293e-02 ,1.4393e-02 ,1.2369e-02 ,1.1568e-02 ,1.2855e-02 /)
      kbo(:,17, 3) = (/ &
     &1.3004e-02 ,1.0838e-02 ,9.6882e-03 ,1.0818e-02 ,1.1950e-02 /)
      kbo(:,18, 3) = (/ &
     &9.6007e-03 ,8.2004e-03 ,9.1048e-03 ,1.0148e-02 ,1.0662e-02 /)
      kbo(:,19, 3) = (/ &
     &7.2730e-03 ,7.5847e-03 ,8.4339e-03 ,9.0734e-03 ,9.2118e-03 /)
      kbo(:,20, 3) = (/ &
     &5.9400e-03 ,6.7100e-03 ,7.4249e-03 ,7.7409e-03 ,7.7182e-03 /)
      kbo(:,21, 3) = (/ &
     &5.2740e-03 ,5.8871e-03 ,6.3746e-03 ,6.4908e-03 ,6.3895e-03 /)
      kbo(:,22, 3) = (/ &
     &4.5973e-03 ,5.1329e-03 ,5.3865e-03 ,5.3473e-03 ,5.2488e-03 /)
      kbo(:,23, 3) = (/ &
     &4.0216e-03 ,4.3958e-03 ,4.5011e-03 ,4.3919e-03 ,4.3384e-03 /)
      kbo(:,24, 3) = (/ &
     &3.5050e-03 ,3.6950e-03 ,3.6848e-03 ,3.6232e-03 ,3.5889e-03 /)
      kbo(:,25, 3) = (/ &
     &3.0079e-03 ,3.0947e-03 ,3.0321e-03 ,2.9863e-03 ,2.9569e-03 /)
      kbo(:,26, 3) = (/ &
     &2.5223e-03 ,2.5389e-03 ,2.4899e-03 ,2.4616e-03 ,2.4119e-03 /)
      kbo(:,27, 3) = (/ &
     &2.0904e-03 ,2.0720e-03 ,2.0405e-03 ,2.0263e-03 ,1.9704e-03 /)
      kbo(:,28, 3) = (/ &
     &1.7240e-03 ,1.6892e-03 ,1.6695e-03 ,1.6561e-03 ,1.6055e-03 /)
      kbo(:,29, 3) = (/ &
     &1.4068e-03 ,1.3720e-03 ,1.3607e-03 ,1.3422e-03 ,1.3070e-03 /)
      kbo(:,30, 3) = (/ &
     &1.1328e-03 ,1.1145e-03 ,1.1117e-03 ,1.0886e-03 ,1.0628e-03 /)
      kbo(:,31, 3) = (/ &
     &9.1589e-04 ,9.0415e-04 ,9.0310e-04 ,8.8069e-04 ,8.6082e-04 /)
      kbo(:,32, 3) = (/ &
     &7.4268e-04 ,7.3425e-04 ,7.3091e-04 ,7.1193e-04 ,7.0016e-04 /)
      kbo(:,33, 3) = (/ &
     &5.9881e-04 ,5.9536e-04 ,5.8909e-04 ,5.7513e-04 ,5.6984e-04 /)
      kbo(:,34, 3) = (/ &
     &4.8522e-04 ,4.8326e-04 ,4.7702e-04 ,4.6806e-04 ,4.6482e-04 /)
      kbo(:,35, 3) = (/ &
     &3.9408e-04 ,3.9282e-04 ,3.8758e-04 ,3.8191e-04 ,3.7951e-04 /)
      kbo(:,36, 3) = (/ &
     &3.2090e-04 ,3.1998e-04 ,3.1651e-04 ,3.1185e-04 ,3.1064e-04 /)
      kbo(:,37, 3) = (/ &
     &2.6225e-04 ,2.6215e-04 ,2.6078e-04 ,2.5651e-04 ,2.5549e-04 /)
      kbo(:,38, 3) = (/ &
     &2.1480e-04 ,2.1472e-04 ,2.1476e-04 ,2.1116e-04 ,2.0969e-04 /)
      kbo(:,39, 3) = (/ &
     &1.7555e-04 ,1.7537e-04 ,1.7598e-04 ,1.7350e-04 ,1.7249e-04 /)
      kbo(:,40, 3) = (/ &
     &1.4506e-04 ,1.4338e-04 ,1.4427e-04 ,1.4359e-04 ,1.4195e-04 /)
      kbo(:,41, 3) = (/ &
     &1.1753e-04 ,1.1789e-04 ,1.1842e-04 ,1.1899e-04 ,1.1706e-04 /)
      kbo(:,42, 3) = (/ &
     &9.4811e-05 ,9.6651e-05 ,9.6909e-05 ,9.7780e-05 ,9.6573e-05 /)
      kbo(:,43, 3) = (/ &
     &7.5161e-05 ,7.9489e-05 ,7.9256e-05 ,8.0096e-05 ,8.0065e-05 /)
      kbo(:,44, 3) = (/ &
     &5.8204e-05 ,6.3635e-05 ,6.5251e-05 ,6.5174e-05 ,6.6162e-05 /)
      kbo(:,45, 3) = (/ &
     &4.3809e-05 ,5.0393e-05 ,5.3351e-05 ,5.3552e-05 ,5.3892e-05 /)
      kbo(:,46, 3) = (/ &
     &3.2980e-05 ,3.7988e-05 ,4.2459e-05 ,4.3951e-05 ,4.3847e-05 /)
      kbo(:,47, 3) = (/ &
     &2.7646e-05 ,2.8723e-05 ,3.2811e-05 ,3.5391e-05 ,3.6137e-05 /)
      kbo(:,48, 3) = (/ &
     &2.4543e-05 ,2.1924e-05 ,2.4598e-05 ,2.7741e-05 ,2.9339e-05 /)
      kbo(:,49, 3) = (/ &
     &2.2466e-05 ,1.9218e-05 ,1.8251e-05 ,2.0876e-05 ,2.3032e-05 /)
      kbo(:,50, 3) = (/ &
     &2.1181e-05 ,1.7247e-05 ,1.5253e-05 ,1.5927e-05 ,1.7960e-05 /)
      kbo(:,51, 3) = (/ &
     &2.0829e-05 ,1.5682e-05 ,1.3335e-05 ,1.2152e-05 ,1.3683e-05 /)
      kbo(:,52, 3) = (/ &
     &2.0195e-05 ,1.5008e-05 ,1.2032e-05 ,1.0543e-05 ,1.0211e-05 /)
      kbo(:,53, 3) = (/ &
     &1.9323e-05 ,1.4642e-05 ,1.1065e-05 ,9.3359e-06 ,8.4701e-06 /)
      kbo(:,54, 3) = (/ &
     &1.7666e-05 ,1.4231e-05 ,1.0596e-05 ,8.3241e-06 ,7.3928e-06 /)
      kbo(:,55, 3) = (/ &
     &1.5462e-05 ,1.3265e-05 ,1.0248e-05 ,7.8075e-06 ,6.5230e-06 /)
      kbo(:,56, 3) = (/ &
     &1.3370e-05 ,1.2106e-05 ,9.7995e-06 ,7.4236e-06 ,5.8878e-06 /)
      kbo(:,57, 3) = (/ &
     &1.1515e-05 ,1.0653e-05 ,9.2073e-06 ,7.1981e-06 ,5.4819e-06 /)
      kbo(:,58, 3) = (/ &
     &1.0034e-05 ,9.2814e-06 ,8.4358e-06 ,6.8772e-06 ,5.2130e-06 /)
      kbo(:,59, 3) = (/ &
     &8.4460e-06 ,7.8198e-06 ,7.3452e-06 ,6.2331e-06 ,4.7237e-06 /)
      kbo(:,13, 4) = (/ &
     &3.3587e-02 ,4.0386e-02 ,4.5135e-02 ,4.6401e-02 ,4.5805e-02 /)
      kbo(:,14, 4) = (/ &
     &3.1030e-02 ,3.6513e-02 ,3.9636e-02 ,3.9291e-02 ,3.8805e-02 /)
      kbo(:,15, 4) = (/ &
     &2.9952e-02 ,3.3504e-02 ,3.3526e-02 ,3.3527e-02 ,3.2785e-02 /)
      kbo(:,16, 4) = (/ &
     &2.7625e-02 ,2.8337e-02 ,2.8532e-02 ,2.8121e-02 ,2.7038e-02 /)
      kbo(:,17, 4) = (/ &
     &2.3797e-02 ,2.4231e-02 ,2.3927e-02 ,2.3137e-02 ,2.2675e-02 /)
      kbo(:,18, 4) = (/ &
     &2.0364e-02 ,2.0218e-02 ,1.9689e-02 ,1.9353e-02 ,1.9321e-02 /)
      kbo(:,19, 4) = (/ &
     &1.7135e-02 ,1.6671e-02 ,1.6414e-02 ,1.6325e-02 ,1.6362e-02 /)
      kbo(:,20, 4) = (/ &
     &1.4048e-02 ,1.3836e-02 ,1.3650e-02 ,1.3725e-02 ,1.3743e-02 /)
      kbo(:,21, 4) = (/ &
     &1.1598e-02 ,1.1451e-02 ,1.1386e-02 ,1.1434e-02 ,1.1536e-02 /)
      kbo(:,22, 4) = (/ &
     &9.5671e-03 ,9.4431e-03 ,9.4962e-03 ,9.5565e-03 ,9.6638e-03 /)
      kbo(:,23, 4) = (/ &
     &7.8733e-03 ,7.8272e-03 ,7.8608e-03 ,8.0045e-03 ,8.0429e-03 /)
      kbo(:,24, 4) = (/ &
     &6.4854e-03 ,6.5239e-03 ,6.5932e-03 ,6.6847e-03 ,6.6897e-03 /)
      kbo(:,25, 4) = (/ &
     &5.3475e-03 ,5.3959e-03 ,5.5055e-03 ,5.5513e-03 ,5.5516e-03 /)
      kbo(:,26, 4) = (/ &
     &4.4370e-03 ,4.4984e-03 ,4.5821e-03 ,4.5978e-03 ,4.6194e-03 /)
      kbo(:,27, 4) = (/ &
     &3.6654e-03 ,3.7378e-03 ,3.7830e-03 ,3.7897e-03 ,3.8209e-03 /)
      kbo(:,28, 4) = (/ &
     &3.0135e-03 ,3.0852e-03 ,3.1155e-03 ,3.1198e-03 ,3.1538e-03 /)
      kbo(:,29, 4) = (/ &
     &2.4690e-03 ,2.5299e-03 ,2.5457e-03 ,2.5581e-03 ,2.5884e-03 /)
      kbo(:,30, 4) = (/ &
     &2.0282e-03 ,2.0645e-03 ,2.0716e-03 ,2.0943e-03 ,2.1183e-03 /)
      kbo(:,31, 4) = (/ &
     &1.6532e-03 ,1.6753e-03 ,1.6810e-03 ,1.7064e-03 ,1.7271e-03 /)
      kbo(:,32, 4) = (/ &
     &1.3440e-03 ,1.3610e-03 ,1.3688e-03 ,1.3929e-03 ,1.4080e-03 /)
      kbo(:,33, 4) = (/ &
     &1.0937e-03 ,1.1058e-03 ,1.1183e-03 ,1.1384e-03 ,1.1495e-03 /)
      kbo(:,34, 4) = (/ &
     &8.9328e-04 ,9.0340e-04 ,9.1730e-04 ,9.3209e-04 ,9.4284e-04 /)
      kbo(:,35, 4) = (/ &
     &7.2895e-04 ,7.3894e-04 ,7.5120e-04 ,7.6322e-04 ,7.7389e-04 /)
      kbo(:,36, 4) = (/ &
     &5.9465e-04 ,6.0388e-04 ,6.1360e-04 ,6.2477e-04 ,6.3446e-04 /)
      kbo(:,37, 4) = (/ &
     &4.8509e-04 ,4.9426e-04 ,5.0234e-04 ,5.1316e-04 ,5.2248e-04 /)
      kbo(:,38, 4) = (/ &
     &3.9518e-04 ,4.0486e-04 ,4.1118e-04 ,4.2126e-04 ,4.3035e-04 /)
      kbo(:,39, 4) = (/ &
     &3.2206e-04 ,3.3126e-04 ,3.3692e-04 ,3.4570e-04 ,3.5386e-04 /)
      kbo(:,40, 4) = (/ &
     &2.6189e-04 ,2.7140e-04 ,2.7744e-04 ,2.8454e-04 ,2.9309e-04 /)
      kbo(:,41, 4) = (/ &
     &2.1513e-04 ,2.2151e-04 ,2.2843e-04 ,2.3405e-04 ,2.4235e-04 /)
      kbo(:,42, 4) = (/ &
     &1.7598e-04 ,1.8130e-04 ,1.8775e-04 ,1.9283e-04 ,2.0002e-04 /)
      kbo(:,43, 4) = (/ &
     &1.4391e-04 ,1.4742e-04 ,1.5366e-04 ,1.5883e-04 ,1.6416e-04 /)
      kbo(:,44, 4) = (/ &
     &1.1869e-04 ,1.2058e-04 ,1.2494e-04 ,1.3042e-04 ,1.3475e-04 /)
      kbo(:,45, 4) = (/ &
     &9.8053e-05 ,9.8247e-05 ,1.0155e-04 ,1.0624e-04 ,1.1079e-04 /)
      kbo(:,46, 4) = (/ &
     &8.0733e-05 ,8.0988e-05 ,8.2961e-05 ,8.6570e-05 ,9.0733e-05 /)
      kbo(:,47, 4) = (/ &
     &6.6646e-05 ,6.6793e-05 ,6.7614e-05 ,7.0248e-05 ,7.3658e-05 /)
      kbo(:,48, 4) = (/ &
     &5.5124e-05 ,5.5074e-05 ,5.5667e-05 ,5.7150e-05 ,5.9800e-05 /)
      kbo(:,49, 4) = (/ &
     &4.4694e-05 ,4.5221e-05 ,4.5769e-05 ,4.6677e-05 ,4.8625e-05 /)
      kbo(:,50, 4) = (/ &
     &3.5617e-05 ,3.7343e-05 ,3.7522e-05 ,3.8384e-05 ,3.9484e-05 /)
      kbo(:,51, 4) = (/ &
     &2.7917e-05 ,3.0153e-05 ,3.0833e-05 ,3.1535e-05 ,3.2403e-05 /)
      kbo(:,52, 4) = (/ &
     &2.1904e-05 ,2.3837e-05 ,2.5410e-05 ,2.5925e-05 ,2.6605e-05 /)
      kbo(:,53, 4) = (/ &
     &1.6636e-05 ,1.9086e-05 ,2.0539e-05 ,2.1236e-05 ,2.1831e-05 /)
      kbo(:,54, 4) = (/ &
     &1.2490e-05 ,1.4743e-05 ,1.6336e-05 ,1.7546e-05 ,1.7865e-05 /)
      kbo(:,55, 4) = (/ &
     &1.0189e-05 ,1.1568e-05 ,1.3196e-05 ,1.4286e-05 ,1.4740e-05 /)
      kbo(:,56, 4) = (/ &
     &9.0688e-06 ,8.6690e-06 ,1.0255e-05 ,1.1493e-05 ,1.2371e-05 /)
      kbo(:,57, 4) = (/ &
     &8.8593e-06 ,6.9758e-06 ,8.0033e-06 ,9.3145e-06 ,1.0058e-05 /)
      kbo(:,58, 4) = (/ &
     &8.9813e-06 ,6.2718e-06 ,5.9506e-06 ,7.1169e-06 ,8.0866e-06 /)
      kbo(:,59, 4) = (/ &
     &8.3077e-06 ,5.6478e-06 ,4.7582e-06 ,5.5908e-06 ,6.6051e-06 /)
      kbo(:,13, 5) = (/ &
     &8.1443e-02 ,7.8686e-02 ,7.8076e-02 ,7.8298e-02 ,8.0221e-02 /)
      kbo(:,14, 5) = (/ &
     &6.8138e-02 ,6.7426e-02 ,6.7266e-02 ,6.8778e-02 ,7.0029e-02 /)
      kbo(:,15, 5) = (/ &
     &5.7566e-02 ,5.8181e-02 ,6.0037e-02 ,6.1077e-02 ,6.2170e-02 /)
      kbo(:,16, 5) = (/ &
     &4.9602e-02 ,5.1862e-02 ,5.2830e-02 ,5.3796e-02 ,5.4837e-02 /)
      kbo(:,17, 5) = (/ &
     &4.4316e-02 ,4.5504e-02 ,4.6554e-02 ,4.7427e-02 ,4.7730e-02 /)
      kbo(:,18, 5) = (/ &
     &3.9127e-02 ,4.0270e-02 ,4.1019e-02 ,4.1264e-02 ,4.1372e-02 /)
      kbo(:,19, 5) = (/ &
     &3.4464e-02 ,3.5381e-02 ,3.5731e-02 ,3.5860e-02 ,3.6031e-02 /)
      kbo(:,20, 5) = (/ &
     &2.9866e-02 ,3.0433e-02 ,3.0697e-02 ,3.0719e-02 ,3.0767e-02 /)
      kbo(:,21, 5) = (/ &
     &2.5526e-02 ,2.5898e-02 ,2.6044e-02 ,2.5989e-02 ,2.5913e-02 /)
      kbo(:,22, 5) = (/ &
     &2.1617e-02 ,2.1821e-02 ,2.1825e-02 ,2.1764e-02 ,2.1636e-02 /)
      kbo(:,23, 5) = (/ &
     &1.8178e-02 ,1.8256e-02 ,1.8221e-02 ,1.8126e-02 ,1.8025e-02 /)
      kbo(:,24, 5) = (/ &
     &1.5221e-02 ,1.5229e-02 ,1.5185e-02 ,1.5079e-02 ,1.4988e-02 /)
      kbo(:,25, 5) = (/ &
     &1.2672e-02 ,1.2670e-02 ,1.2609e-02 ,1.2518e-02 ,1.2439e-02 /)
      kbo(:,26, 5) = (/ &
     &1.0521e-02 ,1.0503e-02 ,1.0444e-02 ,1.0375e-02 ,1.0305e-02 /)
      kbo(:,27, 5) = (/ &
     &8.6769e-03 ,8.6518e-03 ,8.6102e-03 ,8.5574e-03 ,8.4970e-03 /)
      kbo(:,28, 5) = (/ &
     &7.1348e-03 ,7.1122e-03 ,7.0812e-03 ,7.0380e-03 ,6.9899e-03 /)
      kbo(:,29, 5) = (/ &
     &5.8206e-03 ,5.8023e-03 ,5.7788e-03 ,5.7535e-03 ,5.7174e-03 /)
      kbo(:,30, 5) = (/ &
     &4.7381e-03 ,4.7263e-03 ,4.7093e-03 ,4.6856e-03 ,4.6651e-03 /)
      kbo(:,31, 5) = (/ &
     &3.8310e-03 ,3.8249e-03 ,3.8179e-03 ,3.8007e-03 ,3.7880e-03 /)
      kbo(:,32, 5) = (/ &
     &3.1058e-03 ,3.1004e-03 ,3.0969e-03 ,3.0876e-03 ,3.0842e-03 /)
      kbo(:,33, 5) = (/ &
     &2.5170e-03 ,2.5165e-03 ,2.5146e-03 ,2.5120e-03 ,2.5162e-03 /)
      kbo(:,34, 5) = (/ &
     &2.0509e-03 ,2.0525e-03 ,2.0528e-03 ,2.0549e-03 ,2.0638e-03 /)
      kbo(:,35, 5) = (/ &
     &1.6738e-03 ,1.6767e-03 ,1.6787e-03 ,1.6855e-03 ,1.6962e-03 /)
      kbo(:,36, 5) = (/ &
     &1.3688e-03 ,1.3726e-03 ,1.3769e-03 ,1.3854e-03 ,1.3974e-03 /)
      kbo(:,37, 5) = (/ &
     &1.1244e-03 ,1.1287e-03 ,1.1344e-03 ,1.1436e-03 ,1.1555e-03 /)
      kbo(:,38, 5) = (/ &
     &9.2354e-04 ,9.2789e-04 ,9.3393e-04 ,9.4440e-04 ,9.5553e-04 /)
      kbo(:,39, 5) = (/ &
     &7.5825e-04 ,7.6213e-04 ,7.6943e-04 ,7.7957e-04 ,7.9082e-04 /)
      kbo(:,40, 5) = (/ &
     &6.2483e-04 ,6.2933e-04 ,6.3674e-04 ,6.4631e-04 ,6.5698e-04 /)
      kbo(:,41, 5) = (/ &
     &5.1520e-04 ,5.2035e-04 ,5.2751e-04 ,5.3662e-04 ,5.4646e-04 /)
      kbo(:,42, 5) = (/ &
     &4.2480e-04 ,4.3031e-04 ,4.3691e-04 ,4.4575e-04 ,4.5526e-04 /)
      kbo(:,43, 5) = (/ &
     &3.5001e-04 ,3.5557e-04 ,3.6220e-04 ,3.7053e-04 ,3.7981e-04 /)
      kbo(:,44, 5) = (/ &
     &2.8750e-04 ,2.9363e-04 ,3.0042e-04 ,3.0784e-04 ,3.1671e-04 /)
      kbo(:,45, 5) = (/ &
     &2.3558e-04 ,2.4233e-04 ,2.4882e-04 ,2.5588e-04 ,2.6409e-04 /)
      kbo(:,46, 5) = (/ &
     &1.9252e-04 ,1.9920e-04 ,2.0547e-04 ,2.1209e-04 ,2.1984e-04 /)
      kbo(:,47, 5) = (/ &
     &1.5646e-04 ,1.6321e-04 ,1.6931e-04 ,1.7555e-04 ,1.8250e-04 /)
      kbo(:,48, 5) = (/ &
     &1.2570e-04 ,1.3295e-04 ,1.3900e-04 ,1.4479e-04 ,1.5118e-04 /)
      kbo(:,49, 5) = (/ &
     &1.0046e-04 ,1.0778e-04 ,1.1356e-04 ,1.1908e-04 ,1.2499e-04 /)
      kbo(:,50, 5) = (/ &
     &8.0435e-05 ,8.6489e-05 ,9.2769e-05 ,9.7911e-05 ,1.0325e-04 /)
      kbo(:,51, 5) = (/ &
     &6.3458e-05 ,6.9460e-05 ,7.5498e-05 ,8.0303e-05 ,8.5194e-05 /)
      kbo(:,52, 5) = (/ &
     &4.9865e-05 ,5.5730e-05 ,6.0501e-05 ,6.5586e-05 ,7.0113e-05 /)
      kbo(:,53, 5) = (/ &
     &3.9952e-05 ,4.3532e-05 ,4.8481e-05 ,5.3147e-05 ,5.7399e-05 /)
      kbo(:,54, 5) = (/ &
     &3.2880e-05 ,3.4587e-05 ,3.8794e-05 ,4.2722e-05 ,4.7074e-05 /)
      kbo(:,55, 5) = (/ &
     &2.7120e-05 ,2.7717e-05 ,3.0553e-05 ,3.4428e-05 ,3.8350e-05 /)
      kbo(:,56, 5) = (/ &
     &2.2127e-05 ,2.2850e-05 ,2.4431e-05 ,2.7545e-05 ,3.0669e-05 /)
      kbo(:,57, 5) = (/ &
     &1.8252e-05 ,1.8866e-05 ,1.9461e-05 ,2.1577e-05 ,2.4721e-05 /)
      kbo(:,58, 5) = (/ &
     &1.4337e-05 ,1.5384e-05 ,1.6084e-05 ,1.7424e-05 ,1.9750e-05 /)
      kbo(:,59, 5) = (/ &
     &1.1278e-05 ,1.2651e-05 ,1.3368e-05 ,1.4398e-05 ,1.6235e-05 /)
      kbo(:,13, 6) = (/ &
     &1.8817e-01 ,1.9206e-01 ,1.9341e-01 ,1.9316e-01 ,1.9216e-01 /)
      kbo(:,14, 6) = (/ &
     &1.5839e-01 ,1.6013e-01 ,1.6098e-01 ,1.6083e-01 ,1.6026e-01 /)
      kbo(:,15, 6) = (/ &
     &1.3908e-01 ,1.4022e-01 ,1.4029e-01 ,1.3949e-01 ,1.3862e-01 /)
      kbo(:,16, 6) = (/ &
     &1.2016e-01 ,1.2041e-01 ,1.1995e-01 ,1.1931e-01 ,1.1861e-01 /)
      kbo(:,17, 6) = (/ &
     &1.0302e-01 ,1.0297e-01 ,1.0263e-01 ,1.0230e-01 ,1.0181e-01 /)
      kbo(:,18, 6) = (/ &
     &8.8231e-02 ,8.8161e-02 ,8.7913e-02 ,8.7602e-02 ,8.7188e-02 /)
      kbo(:,19, 6) = (/ &
     &7.6358e-02 ,7.6259e-02 ,7.5975e-02 ,7.5746e-02 ,7.5236e-02 /)
      kbo(:,20, 6) = (/ &
     &6.5716e-02 ,6.5541e-02 ,6.5322e-02 ,6.5232e-02 ,6.4993e-02 /)
      kbo(:,21, 6) = (/ &
     &5.5986e-02 ,5.5897e-02 ,5.5927e-02 ,5.6065e-02 ,5.6062e-02 /)
      kbo(:,22, 6) = (/ &
     &4.7367e-02 ,4.7462e-02 ,4.7736e-02 ,4.7820e-02 ,4.7753e-02 /)
      kbo(:,23, 6) = (/ &
     &4.0099e-02 ,4.0361e-02 ,4.0481e-02 ,4.0442e-02 ,4.0254e-02 /)
      kbo(:,24, 6) = (/ &
     &3.3998e-02 ,3.4135e-02 ,3.4123e-02 ,3.4025e-02 ,3.3829e-02 /)
      kbo(:,25, 6) = (/ &
     &2.8658e-02 ,2.8658e-02 ,2.8582e-02 ,2.8475e-02 ,2.8305e-02 /)
      kbo(:,26, 6) = (/ &
     &2.3955e-02 ,2.3909e-02 ,2.3836e-02 ,2.3748e-02 ,2.3606e-02 /)
      kbo(:,27, 6) = (/ &
     &1.9889e-02 ,1.9852e-02 ,1.9780e-02 ,1.9709e-02 ,1.9615e-02 /)
      kbo(:,28, 6) = (/ &
     &1.6444e-02 ,1.6406e-02 ,1.6372e-02 ,1.6318e-02 ,1.6245e-02 /)
      kbo(:,29, 6) = (/ &
     &1.3491e-02 ,1.3473e-02 ,1.3456e-02 ,1.3404e-02 ,1.3356e-02 /)
      kbo(:,30, 6) = (/ &
     &1.1049e-02 ,1.1039e-02 ,1.1036e-02 ,1.1011e-02 ,1.0973e-02 /)
      kbo(:,31, 6) = (/ &
     &9.0143e-03 ,9.0192e-03 ,9.0194e-03 ,9.0134e-03 ,9.0031e-03 /)
      kbo(:,32, 6) = (/ &
     &7.3665e-03 ,7.3853e-03 ,7.3885e-03 ,7.3955e-03 ,7.4067e-03 /)
      kbo(:,33, 6) = (/ &
     &6.0271e-03 ,6.0462e-03 ,6.0622e-03 ,6.0836e-03 ,6.1045e-03 /)
      kbo(:,34, 6) = (/ &
     &4.9546e-03 ,4.9811e-03 ,5.0047e-03 ,5.0339e-03 ,5.0627e-03 /)
      kbo(:,35, 6) = (/ &
     &4.0822e-03 ,4.1121e-03 ,4.1424e-03 ,4.1730e-03 ,4.2061e-03 /)
      kbo(:,36, 6) = (/ &
     &3.3681e-03 ,3.3993e-03 ,3.4334e-03 ,3.4635e-03 ,3.4987e-03 /)
      kbo(:,37, 6) = (/ &
     &2.7875e-03 ,2.8195e-03 ,2.8505e-03 ,2.8836e-03 ,2.9180e-03 /)
      kbo(:,38, 6) = (/ &
     &2.3080e-03 ,2.3382e-03 ,2.3688e-03 ,2.3992e-03 ,2.4337e-03 /)
      kbo(:,39, 6) = (/ &
     &1.9086e-03 ,1.9391e-03 ,1.9678e-03 ,1.9967e-03 ,2.0294e-03 /)
      kbo(:,40, 6) = (/ &
     &1.5841e-03 ,1.6128e-03 ,1.6390e-03 ,1.6667e-03 ,1.6980e-03 /)
      kbo(:,41, 6) = (/ &
     &1.3139e-03 ,1.3408e-03 ,1.3651e-03 ,1.3913e-03 ,1.4213e-03 /)
      kbo(:,42, 6) = (/ &
     &1.0897e-03 ,1.1135e-03 ,1.1369e-03 ,1.1616e-03 ,1.1887e-03 /)
      kbo(:,43, 6) = (/ &
     &9.0311e-04 ,9.2481e-04 ,9.4572e-04 ,9.6914e-04 ,9.9399e-04 /)
      kbo(:,44, 6) = (/ &
     &7.4776e-04 ,7.6718e-04 ,7.8637e-04 ,8.0787e-04 ,8.3044e-04 /)
      kbo(:,45, 6) = (/ &
     &6.1863e-04 ,6.3626e-04 ,6.5392e-04 ,6.7285e-04 ,6.9425e-04 /)
      kbo(:,46, 6) = (/ &
     &5.1188e-04 ,5.2759e-04 ,5.4354e-04 ,5.6054e-04 ,5.8050e-04 /)
      kbo(:,47, 6) = (/ &
     &4.2255e-04 ,4.3715e-04 ,4.5173e-04 ,4.6695e-04 ,4.8462e-04 /)
      kbo(:,48, 6) = (/ &
     &3.4819e-04 ,3.6156e-04 ,3.7458e-04 ,3.8864e-04 ,4.0475e-04 /)
      kbo(:,49, 6) = (/ &
     &2.8602e-04 ,2.9814e-04 ,3.1015e-04 ,3.2283e-04 ,3.3769e-04 /)
      kbo(:,50, 6) = (/ &
     &2.3475e-04 ,2.4603e-04 ,2.5676e-04 ,2.6851e-04 ,2.8207e-04 /)
      kbo(:,51, 6) = (/ &
     &1.9267e-04 ,2.0293e-04 ,2.1257e-04 ,2.2327e-04 ,2.3584e-04 /)
      kbo(:,52, 6) = (/ &
     &1.5736e-04 ,1.6664e-04 ,1.7558e-04 ,1.8519e-04 ,1.9650e-04 /)
      kbo(:,53, 6) = (/ &
     &1.2741e-04 ,1.3627e-04 ,1.4450e-04 ,1.5309e-04 ,1.6331e-04 /)
      kbo(:,54, 6) = (/ &
     &1.0368e-04 ,1.1186e-04 ,1.1942e-04 ,1.2720e-04 ,1.3642e-04 /)
      kbo(:,55, 6) = (/ &
     &8.4018e-05 ,9.1900e-05 ,9.8814e-05 ,1.0595e-04 ,1.1419e-04 /)
      kbo(:,56, 6) = (/ &
     &6.7644e-05 ,7.5107e-05 ,8.1537e-05 ,8.8130e-05 ,9.5553e-05 /)
      kbo(:,57, 6) = (/ &
     &5.3052e-05 ,6.0800e-05 ,6.7049e-05 ,7.3153e-05 ,7.9865e-05 /)
      kbo(:,58, 6) = (/ &
     &4.1297e-05 ,4.9020e-05 ,5.4922e-05 ,6.0589e-05 ,6.6753e-05 /)
      kbo(:,59, 6) = (/ &
     &3.4006e-05 ,4.0647e-05 ,4.6127e-05 ,5.1418e-05 ,5.7293e-05 /)
      kbo(:,13, 7) = (/ &
     &5.2204e-01 ,5.1758e-01 ,5.1182e-01 ,5.0530e-01 ,4.9787e-01 /)
      kbo(:,14, 7) = (/ &
     &4.3225e-01 ,4.2797e-01 ,4.2283e-01 ,4.1695e-01 ,4.1054e-01 /)
      kbo(:,15, 7) = (/ &
     &3.5438e-01 ,3.5034e-01 ,3.4544e-01 ,3.4060e-01 ,3.3555e-01 /)
      kbo(:,16, 7) = (/ &
     &3.0255e-01 ,2.9825e-01 ,2.9421e-01 ,2.8975e-01 ,2.8561e-01 /)
      kbo(:,17, 7) = (/ &
     &2.5944e-01 ,2.5596e-01 ,2.5201e-01 ,2.4828e-01 ,2.4466e-01 /)
      kbo(:,18, 7) = (/ &
     &2.2110e-01 ,2.1760e-01 ,2.1435e-01 ,2.1143e-01 ,2.0904e-01 /)
      kbo(:,19, 7) = (/ &
     &1.8864e-01 ,1.8589e-01 ,1.8343e-01 ,1.8143e-01 ,1.7990e-01 /)
      kbo(:,20, 7) = (/ &
     &1.6121e-01 ,1.5932e-01 ,1.5784e-01 ,1.5634e-01 ,1.5506e-01 /)
      kbo(:,21, 7) = (/ &
     &1.3878e-01 ,1.3751e-01 ,1.3632e-01 ,1.3482e-01 ,1.3362e-01 /)
      kbo(:,22, 7) = (/ &
     &1.1962e-01 ,1.1845e-01 ,1.1744e-01 ,1.1632e-01 ,1.1539e-01 /)
      kbo(:,23, 7) = (/ &
     &1.0245e-01 ,1.0173e-01 ,1.0097e-01 ,1.0038e-01 ,9.9933e-02 /)
      kbo(:,24, 7) = (/ &
     &8.7666e-02 ,8.7158e-02 ,8.6968e-02 ,8.6971e-02 ,8.7255e-02 /)
      kbo(:,25, 7) = (/ &
     &7.4640e-02 ,7.4734e-02 ,7.5053e-02 ,7.5269e-02 ,7.5390e-02 /)
      kbo(:,26, 7) = (/ &
     &6.3735e-02 ,6.4061e-02 ,6.4333e-02 ,6.4421e-02 ,6.4368e-02 /)
      kbo(:,27, 7) = (/ &
     &5.4126e-02 ,5.4429e-02 ,5.4564e-02 ,5.4521e-02 ,5.4525e-02 /)
      kbo(:,28, 7) = (/ &
     &4.5724e-02 ,4.5897e-02 ,4.5948e-02 ,4.5981e-02 ,4.6016e-02 /)
      kbo(:,29, 7) = (/ &
     &3.8172e-02 ,3.8308e-02 ,3.8382e-02 ,3.8489e-02 ,3.8585e-02 /)
      kbo(:,30, 7) = (/ &
     &3.1718e-02 ,3.1883e-02 ,3.2020e-02 ,3.2173e-02 ,3.2316e-02 /)
      kbo(:,31, 7) = (/ &
     &2.6252e-02 ,2.6436e-02 ,2.6597e-02 ,2.6780e-02 ,2.6950e-02 /)
      kbo(:,32, 7) = (/ &
     &2.1754e-02 ,2.1941e-02 ,2.2153e-02 ,2.2326e-02 ,2.2517e-02 /)
      kbo(:,33, 7) = (/ &
     &1.8085e-02 ,1.8277e-02 ,1.8461e-02 ,1.8652e-02 ,1.8849e-02 /)
      kbo(:,34, 7) = (/ &
     &1.5122e-02 ,1.5298e-02 ,1.5478e-02 ,1.5652e-02 ,1.5844e-02 /)
      kbo(:,35, 7) = (/ &
     &1.2625e-02 ,1.2802e-02 ,1.2974e-02 ,1.3152e-02 ,1.3333e-02 /)
      kbo(:,36, 7) = (/ &
     &1.0557e-02 ,1.0724e-02 ,1.0878e-02 ,1.1051e-02 ,1.1225e-02 /)
      kbo(:,37, 7) = (/ &
     &8.8496e-03 ,9.0081e-03 ,9.1627e-03 ,9.3269e-03 ,9.4871e-03 /)
      kbo(:,38, 7) = (/ &
     &7.4071e-03 ,7.5543e-03 ,7.6993e-03 ,7.8541e-03 ,8.0170e-03 /)
      kbo(:,39, 7) = (/ &
     &6.1854e-03 ,6.3247e-03 ,6.4677e-03 ,6.6094e-03 ,6.7526e-03 /)
      kbo(:,40, 7) = (/ &
     &5.1922e-03 ,5.3234e-03 ,5.4554e-03 ,5.5916e-03 ,5.7266e-03 /)
      kbo(:,41, 7) = (/ &
     &4.3585e-03 ,4.4819e-03 ,4.6086e-03 ,4.7343e-03 ,4.8561e-03 /)
      kbo(:,42, 7) = (/ &
     &3.6533e-03 ,3.7711e-03 ,3.8861e-03 ,3.9990e-03 ,4.1168e-03 /)
      kbo(:,43, 7) = (/ &
     &3.0584e-03 ,3.1667e-03 ,3.2727e-03 ,3.3777e-03 ,3.4881e-03 /)
      kbo(:,44, 7) = (/ &
     &2.5534e-03 ,2.6526e-03 ,2.7492e-03 ,2.8491e-03 ,2.9548e-03 /)
      kbo(:,45, 7) = (/ &
     &2.1284e-03 ,2.2160e-03 ,2.3074e-03 ,2.3986e-03 ,2.4950e-03 /)
      kbo(:,46, 7) = (/ &
     &1.7695e-03 ,1.8482e-03 ,1.9316e-03 ,2.0146e-03 ,2.1010e-03 /)
      kbo(:,47, 7) = (/ &
     &1.4673e-03 ,1.5398e-03 ,1.6138e-03 ,1.6894e-03 ,1.7692e-03 /)
      kbo(:,48, 7) = (/ &
     &1.2142e-03 ,1.2798e-03 ,1.3450e-03 ,1.4129e-03 ,1.4833e-03 /)
      kbo(:,49, 7) = (/ &
     &1.0007e-03 ,1.0578e-03 ,1.1143e-03 ,1.1757e-03 ,1.2387e-03 /)
      kbo(:,50, 7) = (/ &
     &8.2795e-04 ,8.7794e-04 ,9.2798e-04 ,9.8346e-04 ,1.0399e-03 /)
      kbo(:,51, 7) = (/ &
     &6.8604e-04 ,7.3011e-04 ,7.7427e-04 ,8.2321e-04 ,8.7374e-04 /)
      kbo(:,52, 7) = (/ &
     &5.6660e-04 ,6.0603e-04 ,6.4555e-04 ,6.8763e-04 ,7.3282e-04 /)
      kbo(:,53, 7) = (/ &
     &4.6575e-04 ,5.0073e-04 ,5.3612e-04 ,5.7296e-04 ,6.1258e-04 /)
      kbo(:,54, 7) = (/ &
     &3.8679e-04 ,4.1843e-04 ,4.5022e-04 ,4.8415e-04 ,5.2013e-04 /)
      kbo(:,55, 7) = (/ &
     &3.2310e-04 ,3.5117e-04 ,3.8038e-04 ,4.1226e-04 ,4.4542e-04 /)
      kbo(:,56, 7) = (/ &
     &2.6895e-04 ,2.9441e-04 ,3.2135e-04 ,3.5045e-04 ,3.8084e-04 /)
      kbo(:,57, 7) = (/ &
     &2.2346e-04 ,2.4644e-04 ,2.7077e-04 ,2.9691e-04 ,3.2529e-04 /)
      kbo(:,58, 7) = (/ &
     &1.8566e-04 ,2.0641e-04 ,2.2834e-04 ,2.5256e-04 ,2.7894e-04 /)
      kbo(:,59, 7) = (/ &
     &1.5949e-04 ,1.7859e-04 ,1.9903e-04 ,2.2176e-04 ,2.4718e-04 /)
      kbo(:,13, 8) = (/ &
     &1.7932e+00 ,1.7598e+00 ,1.7272e+00 ,1.6957e+00 ,1.6643e+00 /)
      kbo(:,14, 8) = (/ &
     &1.5024e+00 ,1.4748e+00 ,1.4482e+00 ,1.4213e+00 ,1.3943e+00 /)
      kbo(:,15, 8) = (/ &
     &1.2493e+00 ,1.2269e+00 ,1.2042e+00 ,1.1821e+00 ,1.1593e+00 /)
      kbo(:,16, 8) = (/ &
     &1.0236e+00 ,1.0050e+00 ,9.8683e-01 ,9.6754e-01 ,9.4805e-01 /)
      kbo(:,17, 8) = (/ &
     &8.3764e-01 ,8.2167e-01 ,8.0558e-01 ,7.8848e-01 ,7.7231e-01 /)
      kbo(:,18, 8) = (/ &
     &7.0049e-01 ,6.8715e-01 ,6.7310e-01 ,6.5885e-01 ,6.4482e-01 /)
      kbo(:,19, 8) = (/ &
     &6.0067e-01 ,5.8909e-01 ,5.7714e-01 ,5.6481e-01 ,5.5329e-01 /)
      kbo(:,20, 8) = (/ &
     &5.1436e-01 ,5.0417e-01 ,4.9351e-01 ,4.8348e-01 ,4.7495e-01 /)
      kbo(:,21, 8) = (/ &
     &4.3696e-01 ,4.2847e-01 ,4.2014e-01 ,4.1292e-01 ,4.0709e-01 /)
      kbo(:,22, 8) = (/ &
     &3.7052e-01 ,3.6397e-01 ,3.5765e-01 ,3.5323e-01 ,3.4919e-01 /)
      kbo(:,23, 8) = (/ &
     &3.1534e-01 ,3.1049e-01 ,3.0630e-01 ,3.0316e-01 ,3.0035e-01 /)
      kbo(:,24, 8) = (/ &
     &2.7112e-01 ,2.6740e-01 ,2.6459e-01 ,2.6223e-01 ,2.5988e-01 /)
      kbo(:,25, 8) = (/ &
     &2.3380e-01 ,2.3133e-01 ,2.2943e-01 ,2.2772e-01 ,2.2653e-01 /)
      kbo(:,26, 8) = (/ &
     &2.0236e-01 ,2.0088e-01 ,1.9954e-01 ,1.9878e-01 ,1.9870e-01 /)
      kbo(:,27, 8) = (/ &
     &1.7470e-01 ,1.7394e-01 ,1.7356e-01 ,1.7393e-01 ,1.7411e-01 /)
      kbo(:,28, 8) = (/ &
     &1.5024e-01 ,1.5047e-01 ,1.5098e-01 ,1.5164e-01 ,1.5243e-01 /)
      kbo(:,29, 8) = (/ &
     &1.2816e-01 ,1.2887e-01 ,1.2996e-01 ,1.3066e-01 ,1.3197e-01 /)
      kbo(:,30, 8) = (/ &
     &1.0887e-01 ,1.0998e-01 ,1.1099e-01 ,1.1227e-01 ,1.1365e-01 /)
      kbo(:,31, 8) = (/ &
     &9.1656e-02 ,9.2754e-02 ,9.3840e-02 ,9.5163e-02 ,9.6499e-02 /)
      kbo(:,32, 8) = (/ &
     &7.7165e-02 ,7.8228e-02 ,7.9327e-02 ,8.0584e-02 ,8.1883e-02 /)
      kbo(:,33, 8) = (/ &
     &6.4796e-02 ,6.5863e-02 ,6.6915e-02 ,6.7986e-02 ,6.9105e-02 /)
      kbo(:,34, 8) = (/ &
     &5.4901e-02 ,5.5964e-02 ,5.6945e-02 ,5.8000e-02 ,5.9045e-02 /)
      kbo(:,35, 8) = (/ &
     &4.6607e-02 ,4.7594e-02 ,4.8499e-02 ,4.9452e-02 ,5.0386e-02 /)
      kbo(:,36, 8) = (/ &
     &3.9577e-02 ,4.0492e-02 ,4.1341e-02 ,4.2242e-02 ,4.3090e-02 /)
      kbo(:,37, 8) = (/ &
     &3.3790e-02 ,3.4662e-02 ,3.5486e-02 ,3.6314e-02 ,3.7168e-02 /)
      kbo(:,38, 8) = (/ &
     &2.8754e-02 ,2.9559e-02 ,3.0387e-02 ,3.1137e-02 ,3.1929e-02 /)
      kbo(:,39, 8) = (/ &
     &2.4394e-02 ,2.5115e-02 ,2.5838e-02 ,2.6544e-02 ,2.7274e-02 /)
      kbo(:,40, 8) = (/ &
     &2.0920e-02 ,2.1659e-02 ,2.2398e-02 ,2.3092e-02 ,2.3784e-02 /)
      kbo(:,41, 8) = (/ &
     &1.7960e-02 ,1.8686e-02 ,1.9408e-02 ,2.0118e-02 ,2.0798e-02 /)
      kbo(:,42, 8) = (/ &
     &1.5382e-02 ,1.6080e-02 ,1.6764e-02 ,1.7451e-02 ,1.8100e-02 /)
      kbo(:,43, 8) = (/ &
     &1.3156e-02 ,1.3822e-02 ,1.4465e-02 ,1.5132e-02 ,1.5767e-02 /)
      kbo(:,44, 8) = (/ &
     &1.1236e-02 ,1.1847e-02 ,1.2471e-02 ,1.3074e-02 ,1.3675e-02 /)
      kbo(:,45, 8) = (/ &
     &9.5475e-03 ,1.0122e-02 ,1.0686e-02 ,1.1243e-02 ,1.1794e-02 /)
      kbo(:,46, 8) = (/ &
     &8.0771e-03 ,8.6018e-03 ,9.1254e-03 ,9.6411e-03 ,1.0156e-02 /)
      kbo(:,47, 8) = (/ &
     &6.8185e-03 ,7.3016e-03 ,7.7913e-03 ,8.2730e-03 ,8.7590e-03 /)
      kbo(:,48, 8) = (/ &
     &5.7132e-03 ,6.1559e-03 ,6.5990e-03 ,7.0467e-03 ,7.5035e-03 /)
      kbo(:,49, 8) = (/ &
     &4.7309e-03 ,5.1282e-03 ,5.5334e-03 ,5.9379e-03 ,6.3413e-03 /)
      kbo(:,50, 8) = (/ &
     &3.9545e-03 ,4.3092e-03 ,4.6836e-03 ,5.0555e-03 ,5.4339e-03 /)
      kbo(:,51, 8) = (/ &
     &3.3094e-03 ,3.6354e-03 ,3.9810e-03 ,4.3245e-03 ,4.6768e-03 /)
      kbo(:,52, 8) = (/ &
     &2.7556e-03 ,3.0488e-03 ,3.3581e-03 ,3.6757e-03 ,3.9978e-03 /)
      kbo(:,53, 8) = (/ &
     &2.2741e-03 ,2.5328e-03 ,2.8070e-03 ,3.0901e-03 ,3.3837e-03 /)
      kbo(:,54, 8) = (/ &
     &1.9244e-03 ,2.1630e-03 ,2.4199e-03 ,2.6919e-03 ,2.9670e-03 /)
      kbo(:,55, 8) = (/ &
     &1.6527e-03 ,1.8750e-03 ,2.1244e-03 ,2.3895e-03 ,2.6621e-03 /)
      kbo(:,56, 8) = (/ &
     &1.4187e-03 ,1.6262e-03 ,1.8617e-03 ,2.1120e-03 ,2.3834e-03 /)
      kbo(:,57, 8) = (/ &
     &1.2123e-03 ,1.4102e-03 ,1.6308e-03 ,1.8701e-03 ,2.1361e-03 /)
      kbo(:,58, 8) = (/ &
     &1.0428e-03 ,1.2269e-03 ,1.4357e-03 ,1.6692e-03 ,1.9342e-03 /)
      kbo(:,59, 8) = (/ &
     &9.5774e-04 ,1.1485e-03 ,1.3717e-03 ,1.6313e-03 ,1.9270e-03 /)
      kbo(:,13, 9) = (/ &
     &1.0743e+01 ,1.0581e+01 ,1.0416e+01 ,1.0238e+01 ,1.0057e+01 /)
      kbo(:,14, 9) = (/ &
     &9.3266e+00 ,9.1890e+00 ,9.0401e+00 ,8.8785e+00 ,8.7093e+00 /)
      kbo(:,15, 9) = (/ &
     &8.0329e+00 ,7.9105e+00 ,7.7721e+00 ,7.6225e+00 ,7.4769e+00 /)
      kbo(:,16, 9) = (/ &
     &6.8686e+00 ,6.7530e+00 ,6.6275e+00 ,6.5036e+00 ,6.3858e+00 /)
      kbo(:,17, 9) = (/ &
     &5.8249e+00 ,5.7232e+00 ,5.6209e+00 ,5.5225e+00 ,5.4281e+00 /)
      kbo(:,18, 9) = (/ &
     &4.8929e+00 ,4.8094e+00 ,4.7279e+00 ,4.6483e+00 ,4.5724e+00 /)
      kbo(:,19, 9) = (/ &
     &4.0706e+00 ,4.0042e+00 ,3.9380e+00 ,3.8751e+00 ,3.8145e+00 /)
      kbo(:,20, 9) = (/ &
     &3.3806e+00 ,3.3267e+00 ,3.2749e+00 ,3.2247e+00 ,3.1746e+00 /)
      kbo(:,21, 9) = (/ &
     &2.8074e+00 ,2.7644e+00 ,2.7235e+00 ,2.6821e+00 ,2.6407e+00 /)
      kbo(:,22, 9) = (/ &
     &2.3283e+00 ,2.2955e+00 ,2.2616e+00 ,2.2266e+00 ,2.1957e+00 /)
      kbo(:,23, 9) = (/ &
     &1.9321e+00 ,1.9042e+00 ,1.8758e+00 ,1.8494e+00 ,1.8261e+00 /)
      kbo(:,24, 9) = (/ &
     &1.6234e+00 ,1.5933e+00 ,1.5660e+00 ,1.5420e+00 ,1.5232e+00 /)
      kbo(:,25, 9) = (/ &
     &1.3980e+00 ,1.3704e+00 ,1.3436e+00 ,1.3210e+00 ,1.3008e+00 /)
      kbo(:,26, 9) = (/ &
     &1.2106e+00 ,1.1883e+00 ,1.1672e+00 ,1.1488e+00 ,1.1330e+00 /)
      kbo(:,27, 9) = (/ &
     &1.0466e+00 ,1.0297e+00 ,1.0139e+00 ,1.0016e+00 ,9.9022e-01 /)
      kbo(:,28, 9) = (/ &
     &9.0567e-01 ,8.9244e-01 ,8.8275e-01 ,8.7361e-01 ,8.6722e-01 /)
      kbo(:,29, 9) = (/ &
     &7.7743e-01 ,7.6923e-01 ,7.6234e-01 ,7.5840e-01 ,7.5702e-01 /)
      kbo(:,30, 9) = (/ &
     &6.6693e-01 ,6.6196e-01 ,6.5810e-01 ,6.5663e-01 ,6.5785e-01 /)
      kbo(:,31, 9) = (/ &
     &5.6777e-01 ,5.6527e-01 ,5.6420e-01 ,5.6593e-01 ,5.6662e-01 /)
      kbo(:,32, 9) = (/ &
     &4.8384e-01 ,4.8324e-01 ,4.8562e-01 ,4.8803e-01 ,4.8996e-01 /)
      kbo(:,33, 9) = (/ &
     &4.1137e-01 ,4.1406e-01 ,4.1751e-01 ,4.2081e-01 ,4.2550e-01 /)
      kbo(:,34, 9) = (/ &
     &3.5416e-01 ,3.5806e-01 ,3.6166e-01 ,3.6664e-01 ,3.7277e-01 /)
      kbo(:,35, 9) = (/ &
     &3.0554e-01 ,3.0948e-01 ,3.1424e-01 ,3.1976e-01 ,3.2676e-01 /)
      kbo(:,36, 9) = (/ &
     &2.6418e-01 ,2.6871e-01 ,2.7383e-01 ,2.8027e-01 ,2.8707e-01 /)
      kbo(:,37, 9) = (/ &
     &2.2969e-01 ,2.3421e-01 ,2.3975e-01 ,2.4624e-01 ,2.5310e-01 /)
      kbo(:,38, 9) = (/ &
     &1.9950e-01 ,2.0421e-01 ,2.0978e-01 ,2.1651e-01 ,2.2302e-01 /)
      kbo(:,39, 9) = (/ &
     &1.7282e-01 ,1.7783e-01 ,1.8337e-01 ,1.9005e-01 ,1.9644e-01 /)
      kbo(:,40, 9) = (/ &
     &1.5139e-01 ,1.5623e-01 ,1.6190e-01 ,1.6820e-01 ,1.7447e-01 /)
      kbo(:,41, 9) = (/ &
     &1.3264e-01 ,1.3745e-01 ,1.4301e-01 ,1.4932e-01 ,1.5546e-01 /)
      kbo(:,42, 9) = (/ &
     &1.1607e-01 ,1.2085e-01 ,1.2625e-01 ,1.3247e-01 ,1.3847e-01 /)
      kbo(:,43, 9) = (/ &
     &1.0129e-01 ,1.0600e-01 ,1.1131e-01 ,1.1735e-01 ,1.2314e-01 /)
      kbo(:,44, 9) = (/ &
     &8.8076e-02 ,9.2672e-02 ,9.7764e-02 ,1.0358e-01 ,1.0942e-01 /)
      kbo(:,45, 9) = (/ &
     &7.6267e-02 ,8.0788e-02 ,8.5604e-02 ,9.1124e-02 ,9.6796e-02 /)
      kbo(:,46, 9) = (/ &
     &6.5896e-02 ,7.0073e-02 ,7.4628e-02 ,7.9860e-02 ,8.5349e-02 /)
      kbo(:,47, 9) = (/ &
     &5.6947e-02 ,6.0912e-02 ,6.5102e-02 ,6.9953e-02 ,7.5324e-02 /)
      kbo(:,48, 9) = (/ &
     &4.8993e-02 ,5.2552e-02 ,5.6622e-02 ,6.1050e-02 ,6.6050e-02 /)
      kbo(:,49, 9) = (/ &
     &4.1828e-02 ,4.5103e-02 ,4.8726e-02 ,5.2827e-02 ,5.7536e-02 /)
      kbo(:,50, 9) = (/ &
     &3.6237e-02 ,3.9173e-02 ,4.2523e-02 ,4.6248e-02 ,5.0679e-02 /)
      kbo(:,51, 9) = (/ &
     &3.1483e-02 ,3.4194e-02 ,3.7317e-02 ,4.0792e-02 ,4.4937e-02 /)
      kbo(:,52, 9) = (/ &
     &2.7288e-02 ,2.9720e-02 ,3.2635e-02 ,3.5833e-02 ,3.9605e-02 /)
      kbo(:,53, 9) = (/ &
     &2.3553e-02 ,2.5752e-02 ,2.8298e-02 ,3.1273e-02 ,3.4805e-02 /)
      kbo(:,54, 9) = (/ &
     &2.0927e-02 ,2.2955e-02 ,2.5436e-02 ,2.8294e-02 ,3.1547e-02 /)
      kbo(:,55, 9) = (/ &
     &1.8850e-02 ,2.0892e-02 ,2.3245e-02 ,2.6068e-02 ,2.9259e-02 /)
      kbo(:,56, 9) = (/ &
     &1.7133e-02 ,1.9134e-02 ,2.1378e-02 ,2.4152e-02 ,2.7278e-02 /)
      kbo(:,57, 9) = (/ &
     &1.5614e-02 ,1.7616e-02 ,1.9861e-02 ,2.2450e-02 ,2.5658e-02 /)
      kbo(:,58, 9) = (/ &
     &1.4386e-02 ,1.6367e-02 ,1.8612e-02 ,2.1235e-02 ,2.4366e-02 /)
      kbo(:,59, 9) = (/ &
     &1.4750e-02 ,1.6838e-02 ,1.9250e-02 ,2.2069e-02 ,2.5653e-02 /)
      kbo(:,13,10) = (/ &
     &4.1842e+01 ,4.1126e+01 ,4.0474e+01 ,3.9934e+01 ,3.9455e+01 /)
      kbo(:,14,10) = (/ &
     &3.7817e+01 ,3.7244e+01 ,3.6754e+01 ,3.6387e+01 ,3.5986e+01 /)
      kbo(:,15,10) = (/ &
     &3.3775e+01 ,3.3359e+01 ,3.3057e+01 ,3.2734e+01 ,3.2346e+01 /)
      kbo(:,16,10) = (/ &
     &2.9866e+01 ,2.9628e+01 ,2.9352e+01 ,2.8982e+01 ,2.8500e+01 /)
      kbo(:,17,10) = (/ &
     &2.6256e+01 ,2.6026e+01 ,2.5674e+01 ,2.5248e+01 ,2.4813e+01 /)
      kbo(:,18,10) = (/ &
     &2.2845e+01 ,2.2539e+01 ,2.2184e+01 ,2.1830e+01 ,2.1506e+01 /)
      kbo(:,19,10) = (/ &
     &1.9624e+01 ,1.9336e+01 ,1.9054e+01 ,1.8789e+01 ,1.8555e+01 /)
      kbo(:,20,10) = (/ &
     &1.6714e+01 ,1.6495e+01 ,1.6283e+01 ,1.6088e+01 ,1.5920e+01 /)
      kbo(:,21,10) = (/ &
     &1.4184e+01 ,1.4023e+01 ,1.3853e+01 ,1.3722e+01 ,1.3615e+01 /)
      kbo(:,22,10) = (/ &
     &1.2010e+01 ,1.1876e+01 ,1.1769e+01 ,1.1693e+01 ,1.1608e+01 /)
      kbo(:,23,10) = (/ &
     &1.0140e+01 ,1.0060e+01 ,1.0004e+01 ,9.9480e+00 ,9.8828e+00 /)
      kbo(:,24,10) = (/ &
     &8.3529e+00 ,8.3955e+00 ,8.4004e+00 ,8.3887e+00 ,8.3750e+00 /)
      kbo(:,25,10) = (/ &
     &6.5990e+00 ,6.6692e+00 ,6.7250e+00 ,6.7763e+00 ,6.8513e+00 /)
      kbo(:,26,10) = (/ &
     &5.2218e+00 ,5.2429e+00 ,5.2934e+00 ,5.3672e+00 ,5.4447e+00 /)
      kbo(:,27,10) = (/ &
     &4.4199e+00 ,4.3564e+00 ,4.3290e+00 ,4.3162e+00 ,4.3878e+00 /)
      kbo(:,28,10) = (/ &
     &3.8059e+00 ,3.7536e+00 ,3.6821e+00 ,3.6546e+00 ,3.6556e+00 /)
      kbo(:,29,10) = (/ &
     &3.2943e+00 ,3.2284e+00 ,3.1752e+00 ,3.1401e+00 ,3.1165e+00 /)
      kbo(:,30,10) = (/ &
     &2.8426e+00 ,2.7881e+00 ,2.7489e+00 ,2.7185e+00 ,2.7182e+00 /)
      kbo(:,31,10) = (/ &
     &2.4366e+00 ,2.4010e+00 ,2.3877e+00 ,2.3684e+00 ,2.4040e+00 /)
      kbo(:,32,10) = (/ &
     &2.1031e+00 ,2.0888e+00 ,2.0634e+00 ,2.0885e+00 ,2.1581e+00 /)
      kbo(:,33,10) = (/ &
     &1.8304e+00 ,1.8104e+00 ,1.8138e+00 ,1.8703e+00 ,1.9665e+00 /)
      kbo(:,34,10) = (/ &
     &1.5963e+00 ,1.5877e+00 ,1.6209e+00 ,1.6809e+00 ,1.8060e+00 /)
      kbo(:,35,10) = (/ &
     &1.3950e+00 ,1.4093e+00 ,1.4535e+00 ,1.5372e+00 ,1.6748e+00 /)
      kbo(:,36,10) = (/ &
     &1.2291e+00 ,1.2517e+00 ,1.3081e+00 ,1.4001e+00 ,1.5466e+00 /)
      kbo(:,37,10) = (/ &
     &1.0841e+00 ,1.1159e+00 ,1.1678e+00 ,1.2585e+00 ,1.4003e+00 /)
      kbo(:,38,10) = (/ &
     &9.5502e-01 ,9.9217e-01 ,1.0459e+00 ,1.1387e+00 ,1.2834e+00 /)
      kbo(:,39,10) = (/ &
     &8.4320e-01 ,8.8008e-01 ,9.3921e-01 ,1.0432e+00 ,1.1899e+00 /)
      kbo(:,40,10) = (/ &
     &7.4742e-01 ,7.8308e-01 ,8.3378e-01 ,9.2859e-01 ,1.0715e+00 /)
      kbo(:,41,10) = (/ &
     &6.6607e-01 ,6.9838e-01 ,7.4378e-01 ,8.2580e-01 ,9.6253e-01 /)
      kbo(:,42,10) = (/ &
     &5.9399e-01 ,6.2402e-01 ,6.6818e-01 ,7.3908e-01 ,8.7040e-01 /)
      kbo(:,43,10) = (/ &
     &5.3134e-01 ,5.5822e-01 ,5.9679e-01 ,6.5834e-01 ,7.8163e-01 /)
      kbo(:,44,10) = (/ &
     &4.7483e-01 ,4.9813e-01 ,5.3656e-01 ,5.8775e-01 ,7.0057e-01 /)
      kbo(:,45,10) = (/ &
     &4.2242e-01 ,4.4383e-01 ,4.8053e-01 ,5.2923e-01 ,6.3377e-01 /)
      kbo(:,46,10) = (/ &
     &3.7426e-01 ,3.9626e-01 ,4.2998e-01 ,4.7693e-01 ,5.7307e-01 /)
      kbo(:,47,10) = (/ &
     &3.3305e-01 ,3.5232e-01 ,3.8380e-01 ,4.2680e-01 ,5.1056e-01 /)
      kbo(:,48,10) = (/ &
     &2.9118e-01 ,3.1195e-01 ,3.3996e-01 ,3.8124e-01 ,4.5847e-01 /)
      kbo(:,49,10) = (/ &
     &2.5186e-01 ,2.7185e-01 ,2.9957e-01 ,3.4007e-01 ,4.1454e-01 /)
      kbo(:,50,10) = (/ &
     &2.1978e-01 ,2.4030e-01 ,2.6478e-01 ,3.0486e-01 ,3.7227e-01 /)
      kbo(:,51,10) = (/ &
     &1.9384e-01 ,2.1260e-01 ,2.3536e-01 ,2.7096e-01 ,3.3311e-01 /)
      kbo(:,52,10) = (/ &
     &1.6918e-01 ,1.8784e-01 ,2.0901e-01 ,2.4060e-01 ,2.9976e-01 /)
      kbo(:,53,10) = (/ &
     &1.4644e-01 ,1.6376e-01 ,1.8425e-01 ,2.1431e-01 ,2.7054e-01 /)
      kbo(:,54,10) = (/ &
     &1.3139e-01 ,1.4808e-01 ,1.6611e-01 ,1.9208e-01 ,2.4005e-01 /)
      kbo(:,55,10) = (/ &
     &1.2172e-01 ,1.3644e-01 ,1.5558e-01 ,1.7831e-01 ,2.1286e-01 /)
      kbo(:,56,10) = (/ &
     &1.1074e-01 ,1.2717e-01 ,1.4642e-01 ,1.6603e-01 ,1.9730e-01 /)
      kbo(:,57,10) = (/ &
     &1.0195e-01 ,1.1787e-01 ,1.3707e-01 ,1.5838e-01 ,1.8439e-01 /)
      kbo(:,58,10) = (/ &
     &9.6243e-02 ,1.1076e-01 ,1.2956e-01 ,1.5169e-01 ,1.7652e-01 /)
      kbo(:,59,10) = (/ &
     &9.7302e-02 ,1.1627e-01 ,1.3740e-01 ,1.6328e-01 ,1.9053e-01 /)
      kbo(:,13,11) = (/ &
     &7.0360e+01 ,6.9342e+01 ,6.8249e+01 ,6.7098e+01 ,6.5980e+01 /)
      kbo(:,14,11) = (/ &
     &6.5791e+01 ,6.4723e+01 ,6.3625e+01 ,6.2598e+01 ,6.1783e+01 /)
      kbo(:,15,11) = (/ &
     &6.0426e+01 ,5.9395e+01 ,5.8516e+01 ,5.7828e+01 ,5.7219e+01 /)
      kbo(:,16,11) = (/ &
     &5.4683e+01 ,5.3915e+01 ,5.3328e+01 ,5.2878e+01 ,5.2385e+01 /)
      kbo(:,17,11) = (/ &
     &4.8953e+01 ,4.8487e+01 ,4.8177e+01 ,4.7782e+01 ,4.7308e+01 /)
      kbo(:,18,11) = (/ &
     &4.3480e+01 ,4.3274e+01 ,4.2982e+01 ,4.2563e+01 ,4.2021e+01 /)
      kbo(:,19,11) = (/ &
     &3.8401e+01 ,3.8213e+01 ,3.7862e+01 ,3.7391e+01 ,3.6879e+01 /)
      kbo(:,20,11) = (/ &
     &3.3602e+01 ,3.3341e+01 ,3.2960e+01 ,3.2565e+01 ,3.2185e+01 /)
      kbo(:,21,11) = (/ &
     &2.9094e+01 ,2.8806e+01 ,2.8524e+01 ,2.8243e+01 ,2.8023e+01 /)
      kbo(:,22,11) = (/ &
     &2.4954e+01 ,2.4758e+01 ,2.4575e+01 ,2.4433e+01 ,2.4352e+01 /)
      kbo(:,23,11) = (/ &
     &2.1326e+01 ,2.1219e+01 ,2.1148e+01 ,2.1108e+01 ,2.1117e+01 /)
      kbo(:,24,11) = (/ &
     &1.8212e+01 ,1.8167e+01 ,1.8172e+01 ,1.8221e+01 ,1.8288e+01 /)
      kbo(:,25,11) = (/ &
     &1.5541e+01 ,1.5569e+01 ,1.5649e+01 ,1.5756e+01 ,1.5867e+01 /)
      kbo(:,26,11) = (/ &
     &1.3185e+01 ,1.3326e+01 ,1.3479e+01 ,1.3624e+01 ,1.3786e+01 /)
      kbo(:,27,11) = (/ &
     &1.0920e+01 ,1.1211e+01 ,1.1487e+01 ,1.1743e+01 ,1.1957e+01 /)
      kbo(:,28,11) = (/ &
     &9.0678e+00 ,9.3710e+00 ,9.6834e+00 ,9.9920e+00 ,1.0324e+01 /)
      kbo(:,29,11) = (/ &
     &7.6881e+00 ,7.9879e+00 ,8.2968e+00 ,8.6379e+00 ,9.0061e+00 /)
      kbo(:,30,11) = (/ &
     &6.6033e+00 ,6.8954e+00 ,7.2204e+00 ,7.5787e+00 ,7.9480e+00 /)
      kbo(:,31,11) = (/ &
     &5.8224e+00 ,6.1213e+00 ,6.4394e+00 ,6.7947e+00 ,7.1839e+00 /)
      kbo(:,32,11) = (/ &
     &5.1825e+00 ,5.4854e+00 ,5.8203e+00 ,6.1672e+00 ,6.5644e+00 /)
      kbo(:,33,11) = (/ &
     &4.6793e+00 ,4.9853e+00 ,5.3218e+00 ,5.6796e+00 ,6.0723e+00 /)
      kbo(:,34,11) = (/ &
     &4.2112e+00 ,4.5240e+00 ,4.8672e+00 ,5.2510e+00 ,5.6439e+00 /)
      kbo(:,35,11) = (/ &
     &3.8061e+00 ,4.1193e+00 ,4.4694e+00 ,4.8571e+00 ,5.2645e+00 /)
      kbo(:,36,11) = (/ &
     &3.4331e+00 ,3.7452e+00 ,4.0978e+00 ,4.4887e+00 ,4.9173e+00 /)
      kbo(:,37,11) = (/ &
     &3.0586e+00 ,3.3607e+00 ,3.7172e+00 ,4.1153e+00 ,4.5572e+00 /)
      kbo(:,38,11) = (/ &
     &2.7517e+00 ,3.0453e+00 ,3.3976e+00 ,3.7947e+00 ,4.2441e+00 /)
      kbo(:,39,11) = (/ &
     &2.5013e+00 ,2.7908e+00 ,3.1383e+00 ,3.5236e+00 ,3.9765e+00 /)
      kbo(:,40,11) = (/ &
     &2.2268e+00 ,2.5094e+00 ,2.8534e+00 ,3.2426e+00 ,3.6921e+00 /)
      kbo(:,41,11) = (/ &
     &1.9832e+00 ,2.2609e+00 ,2.6000e+00 ,2.9899e+00 ,3.4337e+00 /)
      kbo(:,42,11) = (/ &
     &1.7785e+00 ,2.0479e+00 ,2.3793e+00 ,2.7692e+00 ,3.2048e+00 /)
      kbo(:,43,11) = (/ &
     &1.5856e+00 ,1.8448e+00 ,2.1667e+00 ,2.5496e+00 ,2.9735e+00 /)
      kbo(:,44,11) = (/ &
     &1.4123e+00 ,1.6629e+00 ,1.9679e+00 ,2.3444e+00 ,2.7547e+00 /)
      kbo(:,45,11) = (/ &
     &1.2640e+00 ,1.5067e+00 ,1.7987e+00 ,2.1603e+00 ,2.5558e+00 /)
      kbo(:,46,11) = (/ &
     &1.1290e+00 ,1.3620e+00 ,1.6422e+00 ,1.9855e+00 ,2.3652e+00 /)
      kbo(:,47,11) = (/ &
     &9.9161e-01 ,1.2154e+00 ,1.4836e+00 ,1.8087e+00 ,2.1736e+00 /)
      kbo(:,48,11) = (/ &
     &8.7615e-01 ,1.0875e+00 ,1.3440e+00 ,1.6515e+00 ,1.9976e+00 /)
      kbo(:,49,11) = (/ &
     &7.7782e-01 ,9.7773e-01 ,1.2220e+00 ,1.5130e+00 ,1.8356e+00 /)
      kbo(:,50,11) = (/ &
     &6.8345e-01 ,8.7089e-01 ,1.1065e+00 ,1.3830e+00 ,1.6924e+00 /)
      kbo(:,51,11) = (/ &
     &5.9562e-01 ,7.7251e-01 ,9.9776e-01 ,1.2648e+00 ,1.5621e+00 /)
      kbo(:,52,11) = (/ &
     &5.1948e-01 ,6.8509e-01 ,8.9806e-01 ,1.1564e+00 ,1.4407e+00 /)
      kbo(:,53,11) = (/ &
     &4.5430e-01 ,6.0810e-01 ,8.0999e-01 ,1.0551e+00 ,1.3256e+00 /)
      kbo(:,54,11) = (/ &
     &3.8584e-01 ,5.2960e-01 ,7.1926e-01 ,9.5469e-01 ,1.2208e+00 /)
      kbo(:,55,11) = (/ &
     &3.2585e-01 ,4.5415e-01 ,6.2813e-01 ,8.5255e-01 ,1.1189e+00 /)
      kbo(:,56,11) = (/ &
     &2.9347e-01 ,3.8309e-01 ,5.4571e-01 ,7.5695e-01 ,1.0111e+00 /)
      kbo(:,57,11) = (/ &
     &2.6872e-01 ,3.3263e-01 ,4.6996e-01 ,6.6376e-01 ,9.0688e-01 /)
      kbo(:,58,11) = (/ &
     &2.4960e-01 ,3.0758e-01 ,4.0207e-01 ,5.8213e-01 ,8.0803e-01 /)
      kbo(:,59,11) = (/ &
     &2.6183e-01 ,3.2106e-01 ,3.9760e-01 ,5.1091e-01 ,7.1717e-01 /)
      kbo(:,13,12) = (/ &
     &1.1832e+02 ,1.1787e+02 ,1.1696e+02 ,1.1585e+02 ,1.1448e+02 /)
      kbo(:,14,12) = (/ &
     &1.1787e+02 ,1.1706e+02 ,1.1585e+02 ,1.1435e+02 ,1.1282e+02 /)
      kbo(:,15,12) = (/ &
     &1.1482e+02 ,1.1352e+02 ,1.1198e+02 ,1.1040e+02 ,1.0880e+02 /)
      kbo(:,16,12) = (/ &
     &1.0896e+02 ,1.0749e+02 ,1.0590e+02 ,1.0433e+02 ,1.0304e+02 /)
      kbo(:,17,12) = (/ &
     &1.0128e+02 ,9.9814e+01 ,9.8422e+01 ,9.7349e+01 ,9.6504e+01 /)
      kbo(:,18,12) = (/ &
     &9.2677e+01 ,9.1506e+01 ,9.0639e+01 ,9.0100e+01 ,8.9682e+01 /)
      kbo(:,19,12) = (/ &
     &8.3897e+01 ,8.3222e+01 ,8.2911e+01 ,8.2751e+01 ,8.2502e+01 /)
      kbo(:,20,12) = (/ &
     &7.5342e+01 ,7.5217e+01 ,7.5315e+01 ,7.5254e+01 ,7.5130e+01 /)
      kbo(:,21,12) = (/ &
     &6.7351e+01 ,6.7622e+01 ,6.7745e+01 ,6.7796e+01 ,6.7734e+01 /)
      kbo(:,22,12) = (/ &
     &5.9964e+01 ,6.0293e+01 ,6.0504e+01 ,6.0565e+01 ,6.0581e+01 /)
      kbo(:,23,12) = (/ &
     &5.3111e+01 ,5.3464e+01 ,5.3681e+01 ,5.3837e+01 ,5.4061e+01 /)
      kbo(:,24,12) = (/ &
     &4.6795e+01 ,4.7144e+01 ,4.7460e+01 ,4.7828e+01 ,4.8279e+01 /)
      kbo(:,25,12) = (/ &
     &4.1060e+01 ,4.1497e+01 ,4.1989e+01 ,4.2550e+01 ,4.3265e+01 /)
      kbo(:,26,12) = (/ &
     &3.6007e+01 ,3.6594e+01 ,3.7261e+01 ,3.8060e+01 ,3.9005e+01 /)
      kbo(:,27,12) = (/ &
     &3.1657e+01 ,3.2380e+01 ,3.3234e+01 ,3.4259e+01 ,3.5455e+01 /)
      kbo(:,28,12) = (/ &
     &2.7936e+01 ,2.8816e+01 ,2.9878e+01 ,3.1120e+01 ,3.2499e+01 /)
      kbo(:,29,12) = (/ &
     &2.4811e+01 ,2.5887e+01 ,2.7138e+01 ,2.8541e+01 ,3.0069e+01 /)
      kbo(:,30,12) = (/ &
     &2.2271e+01 ,2.3484e+01 ,2.4883e+01 ,2.6431e+01 ,2.8119e+01 /)
      kbo(:,31,12) = (/ &
     &2.0203e+01 ,2.1534e+01 ,2.3058e+01 ,2.4751e+01 ,2.6602e+01 /)
      kbo(:,32,12) = (/ &
     &1.8534e+01 ,1.9980e+01 ,2.1635e+01 ,2.3479e+01 ,2.5477e+01 /)
      kbo(:,33,12) = (/ &
     &1.7225e+01 ,1.8794e+01 ,2.0572e+01 ,2.2559e+01 ,2.4699e+01 /)
      kbo(:,34,12) = (/ &
     &1.6174e+01 ,1.7857e+01 ,1.9770e+01 ,2.1880e+01 ,2.4147e+01 /)
      kbo(:,35,12) = (/ &
     &1.5236e+01 ,1.7017e+01 ,1.9034e+01 ,2.1242e+01 ,2.3610e+01 /)
      kbo(:,36,12) = (/ &
     &1.4322e+01 ,1.6183e+01 ,1.8272e+01 ,2.0552e+01 ,2.2984e+01 /)
      kbo(:,37,12) = (/ &
     &1.3315e+01 ,1.5210e+01 ,1.7331e+01 ,1.9645e+01 ,2.2115e+01 /)
      kbo(:,38,12) = (/ &
     &1.2427e+01 ,1.4349e+01 ,1.6493e+01 ,1.8831e+01 ,2.1326e+01 /)
      kbo(:,39,12) = (/ &
     &1.1655e+01 ,1.3594e+01 ,1.5756e+01 ,1.8111e+01 ,2.0619e+01 /)
      kbo(:,40,12) = (/ &
     &1.0800e+01 ,1.2718e+01 ,1.4870e+01 ,1.7214e+01 ,1.9711e+01 /)
      kbo(:,41,12) = (/ &
     &1.0009e+01 ,1.1890e+01 ,1.4023e+01 ,1.6343e+01 ,1.8829e+01 /)
      kbo(:,42,12) = (/ &
     &9.2911e+00 ,1.1131e+01 ,1.3230e+01 ,1.5526e+01 ,1.7990e+01 /)
      kbo(:,43,12) = (/ &
     &8.5453e+00 ,1.0322e+01 ,1.2366e+01 ,1.4622e+01 ,1.7049e+01 /)
      kbo(:,44,12) = (/ &
     &7.8249e+00 ,9.5233e+00 ,1.1499e+01 ,1.3704e+01 ,1.6085e+01 /)
      kbo(:,45,12) = (/ &
     &7.1656e+00 ,8.7847e+00 ,1.0682e+01 ,1.2826e+01 ,1.5159e+01 /)
      kbo(:,46,12) = (/ &
     &6.5222e+00 ,8.0621e+00 ,9.8691e+00 ,1.1939e+01 ,1.4215e+01 /)
      kbo(:,47,12) = (/ &
     &5.8688e+00 ,7.3253e+00 ,9.0292e+00 ,1.1003e+01 ,1.3207e+01 /)
      kbo(:,48,12) = (/ &
     &5.2686e+00 ,6.6401e+00 ,8.2460e+00 ,1.0116e+01 ,1.2240e+01 /)
      kbo(:,49,12) = (/ &
     &4.7119e+00 ,6.0011e+00 ,7.5181e+00 ,9.2810e+00 ,1.1309e+01 /)
      kbo(:,50,12) = (/ &
     &4.2243e+00 ,5.4409e+00 ,6.8771e+00 ,8.5451e+00 ,1.0476e+01 /)
      kbo(:,51,12) = (/ &
     &3.7894e+00 ,4.9333e+00 ,6.2908e+00 ,7.8717e+00 ,9.7058e+00 /)
      kbo(:,52,12) = (/ &
     &3.3915e+00 ,4.4569e+00 ,5.7416e+00 ,7.2423e+00 ,8.9799e+00 /)
      kbo(:,53,12) = (/ &
     &3.0222e+00 ,4.0130e+00 ,5.2245e+00 ,6.6473e+00 ,8.2931e+00 /)
      kbo(:,54,12) = (/ &
     &2.7077e+00 ,3.6347e+00 ,4.7766e+00 ,6.1280e+00 ,7.6968e+00 /)
      kbo(:,55,12) = (/ &
     &2.4210e+00 ,3.2970e+00 ,4.3697e+00 ,5.6562e+00 ,7.1563e+00 /)
      kbo(:,56,12) = (/ &
     &2.1307e+00 ,2.9831e+00 ,3.9864e+00 ,5.2103e+00 ,6.6404e+00 /)
      kbo(:,57,12) = (/ &
     &1.8552e+00 ,2.6736e+00 ,3.6295e+00 ,4.7868e+00 ,6.1491e+00 /)
      kbo(:,58,12) = (/ &
     &1.6050e+00 ,2.3734e+00 ,3.3136e+00 ,4.4004e+00 ,5.7055e+00 /)
      kbo(:,59,12) = (/ &
     &1.4434e+00 ,2.1814e+00 ,3.1118e+00 ,4.2418e+00 ,5.5300e+00 /)
      kbo(:,13,13) = (/ &
     &2.0665e+02 ,2.0326e+02 ,2.0074e+02 ,1.9867e+02 ,1.9680e+02 /)
      kbo(:,14,13) = (/ &
     &2.1250e+02 ,2.0998e+02 ,2.0827e+02 ,2.0659e+02 ,2.0468e+02 /)
      kbo(:,15,13) = (/ &
     &2.1695e+02 ,2.1587e+02 ,2.1446e+02 ,2.1260e+02 ,2.1056e+02 /)
      kbo(:,16,13) = (/ &
     &2.2062e+02 ,2.1972e+02 ,2.1811e+02 ,2.1619e+02 ,2.1401e+02 /)
      kbo(:,17,13) = (/ &
     &2.2121e+02 ,2.1996e+02 ,2.1823e+02 ,2.1618e+02 ,2.1385e+02 /)
      kbo(:,18,13) = (/ &
     &2.1775e+02 ,2.1636e+02 ,2.1445e+02 ,2.1229e+02 ,2.1021e+02 /)
      kbo(:,19,13) = (/ &
     &2.1064e+02 ,2.0900e+02 ,2.0712e+02 ,2.0551e+02 ,2.0407e+02 /)
      kbo(:,20,13) = (/ &
     &2.0008e+02 ,1.9874e+02 ,1.9769e+02 ,1.9686e+02 ,1.9621e+02 /)
      kbo(:,21,13) = (/ &
     &1.8747e+02 ,1.8700e+02 ,1.8691e+02 ,1.8703e+02 ,1.8742e+02 /)
      kbo(:,22,13) = (/ &
     &1.7415e+02 ,1.7476e+02 ,1.7572e+02 ,1.7701e+02 ,1.7852e+02 /)
      kbo(:,23,13) = (/ &
     &1.6113e+02 ,1.6295e+02 ,1.6510e+02 ,1.6752e+02 ,1.7009e+02 /)
      kbo(:,24,13) = (/ &
     &1.4912e+02 ,1.5211e+02 ,1.5536e+02 ,1.5887e+02 ,1.6232e+02 /)
      kbo(:,25,13) = (/ &
     &1.3846e+02 ,1.4246e+02 ,1.4677e+02 ,1.5111e+02 ,1.5523e+02 /)
      kbo(:,26,13) = (/ &
     &1.2926e+02 ,1.3422e+02 ,1.3933e+02 ,1.4432e+02 ,1.4910e+02 /)
      kbo(:,27,13) = (/ &
     &1.2138e+02 ,1.2724e+02 ,1.3302e+02 ,1.3864e+02 ,1.4402e+02 /)
      kbo(:,28,13) = (/ &
     &1.1492e+02 ,1.2144e+02 ,1.2785e+02 ,1.3411e+02 ,1.4008e+02 /)
      kbo(:,29,13) = (/ &
     &1.0978e+02 ,1.1690e+02 ,1.2395e+02 ,1.3076e+02 ,1.3730e+02 /)
      kbo(:,30,13) = (/ &
     &1.0580e+02 ,1.1355e+02 ,1.2118e+02 ,1.2849e+02 ,1.3548e+02 /)
      kbo(:,31,13) = (/ &
     &1.0304e+02 ,1.1137e+02 ,1.1944e+02 ,1.2716e+02 ,1.3451e+02 /)
      kbo(:,32,13) = (/ &
     &1.0136e+02 ,1.1014e+02 ,1.1859e+02 ,1.2663e+02 ,1.3416e+02 /)
      kbo(:,33,13) = (/ &
     &1.0056e+02 ,1.0971e+02 ,1.1845e+02 ,1.2667e+02 ,1.3431e+02 /)
      kbo(:,34,13) = (/ &
     &1.0020e+02 ,1.0961e+02 ,1.1855e+02 ,1.2688e+02 ,1.3458e+02 /)
      kbo(:,35,13) = (/ &
     &9.9483e+01 ,1.0912e+02 ,1.1821e+02 ,1.2667e+02 ,1.3443e+02 /)
      kbo(:,36,13) = (/ &
     &9.8103e+01 ,1.0792e+02 ,1.1721e+02 ,1.2581e+02 ,1.3368e+02 /)
      kbo(:,37,13) = (/ &
     &9.5455e+01 ,1.0552e+02 ,1.1504e+02 ,1.2386e+02 ,1.3193e+02 /)
      kbo(:,38,13) = (/ &
     &9.2912e+01 ,1.0319e+02 ,1.1292e+02 ,1.2195e+02 ,1.3022e+02 /)
      kbo(:,39,13) = (/ &
     &9.0538e+01 ,1.0100e+02 ,1.1091e+02 ,1.2014e+02 ,1.2859e+02 /)
      kbo(:,40,13) = (/ &
     &8.7195e+01 ,9.7854e+01 ,1.0799e+02 ,1.1748e+02 ,1.2618e+02 /)
      kbo(:,41,13) = (/ &
     &8.3785e+01 ,9.4631e+01 ,1.0497e+02 ,1.1470e+02 ,1.2366e+02 /)
      kbo(:,42,13) = (/ &
     &8.0430e+01 ,9.1433e+01 ,1.0197e+02 ,1.1192e+02 ,1.2113e+02 /)
      kbo(:,43,13) = (/ &
     &7.6477e+01 ,8.7634e+01 ,9.8384e+01 ,1.0856e+02 ,1.1808e+02 /)
      kbo(:,44,13) = (/ &
     &7.2299e+01 ,8.3562e+01 ,9.4524e+01 ,1.0494e+02 ,1.1474e+02 /)
      kbo(:,45,13) = (/ &
     &6.8166e+01 ,7.9496e+01 ,9.0629e+01 ,1.0127e+02 ,1.1130e+02 /)
      kbo(:,46,13) = (/ &
     &6.3834e+01 ,7.5188e+01 ,8.6450e+01 ,9.7312e+01 ,1.0760e+02 /)
      kbo(:,47,13) = (/ &
     &5.9081e+01 ,7.0413e+01 ,8.1772e+01 ,9.2852e+01 ,1.0340e+02 /)
      kbo(:,48,13) = (/ &
     &5.4396e+01 ,6.5661e+01 ,7.7060e+01 ,8.8317e+01 ,9.9114e+01 /)
      kbo(:,49,13) = (/ &
     &4.9801e+01 ,6.0961e+01 ,7.2354e+01 ,8.3709e+01 ,9.4725e+01 /)
      kbo(:,50,13) = (/ &
     &4.5581e+01 ,5.6585e+01 ,6.7933e+01 ,7.9345e+01 ,9.0545e+01 /)
      kbo(:,51,13) = (/ &
     &4.1581e+01 ,5.2405e+01 ,6.3662e+01 ,7.5096e+01 ,8.6425e+01 /)
      kbo(:,52,13) = (/ &
     &3.7719e+01 ,4.8309e+01 ,5.9448e+01 ,7.0850e+01 ,8.2254e+01 /)
      kbo(:,53,13) = (/ &
     &3.4012e+01 ,4.4282e+01 ,5.5265e+01 ,6.6609e+01 ,7.8050e+01 /)
      kbo(:,54,13) = (/ &
     &3.0756e+01 ,4.0675e+01 ,5.1476e+01 ,6.2735e+01 ,7.4183e+01 /)
      kbo(:,55,13) = (/ &
     &2.7771e+01 ,3.7316e+01 ,4.7906e+01 ,5.9042e+01 ,7.0461e+01 /)
      kbo(:,56,13) = (/ &
     &2.4943e+01 ,3.4093e+01 ,4.4398e+01 ,5.5401e+01 ,6.6760e+01 /)
      kbo(:,57,13) = (/ &
     &2.2280e+01 ,3.0993e+01 ,4.0957e+01 ,5.1794e+01 ,6.3073e+01 /)
      kbo(:,58,13) = (/ &
     &1.9914e+01 ,2.8171e+01 ,3.7788e+01 ,4.8428e+01 ,5.9596e+01 /)
      kbo(:,59,13) = (/ &
     &1.9003e+01 ,2.7062e+01 ,3.6534e+01 ,4.7084e+01 ,5.8201e+01 /)
      kbo(:,13,14) = (/ &
     &3.9453e+02 ,3.9054e+02 ,3.8556e+02 ,3.8029e+02 ,3.7518e+02 /)
      kbo(:,14,14) = (/ &
     &4.2588e+02 ,4.2023e+02 ,4.1375e+02 ,4.0776e+02 ,4.0199e+02 /)
      kbo(:,15,14) = (/ &
     &4.5408e+02 ,4.4627e+02 ,4.3917e+02 ,4.3301e+02 ,4.2714e+02 /)
      kbo(:,16,14) = (/ &
     &4.7789e+02 ,4.6976e+02 ,4.6328e+02 ,4.5698e+02 ,4.5114e+02 /)
      kbo(:,17,14) = (/ &
     &5.0033e+02 ,4.9329e+02 ,4.8659e+02 ,4.8030e+02 ,4.7472e+02 /)
      kbo(:,18,14) = (/ &
     &5.2160e+02 ,5.1479e+02 ,5.0850e+02 ,5.0281e+02 ,4.9755e+02 /)
      kbo(:,19,14) = (/ &
     &5.3975e+02 ,5.3405e+02 ,5.2880e+02 ,5.2359e+02 ,5.1826e+02 /)
      kbo(:,20,14) = (/ &
     &5.5471e+02 ,5.5025e+02 ,5.4544e+02 ,5.4054e+02 ,5.3559e+02 /)
      kbo(:,21,14) = (/ &
     &5.6616e+02 ,5.6246e+02 ,5.5854e+02 ,5.5439e+02 ,5.5012e+02 /)
      kbo(:,22,14) = (/ &
     &5.7373e+02 ,5.7143e+02 ,5.6842e+02 ,5.6526e+02 ,5.6165e+02 /)
      kbo(:,23,14) = (/ &
     &5.7822e+02 ,5.7745e+02 ,5.7602e+02 ,5.7378e+02 ,5.7033e+02 /)
      kbo(:,24,14) = (/ &
     &5.8038e+02 ,5.8144e+02 ,5.8147e+02 ,5.7978e+02 ,5.7697e+02 /)
      kbo(:,25,14) = (/ &
     &5.8144e+02 ,5.8416e+02 ,5.8500e+02 ,5.8436e+02 ,5.8236e+02 /)
      kbo(:,26,14) = (/ &
     &5.8189e+02 ,5.8575e+02 ,5.8780e+02 ,5.8818e+02 ,5.8686e+02 /)
      kbo(:,27,14) = (/ &
     &5.8218e+02 ,5.8719e+02 ,5.9038e+02 ,5.9148e+02 ,5.9059e+02 /)
      kbo(:,28,14) = (/ &
     &5.8262e+02 ,5.8871e+02 ,5.9261e+02 ,5.9417e+02 ,5.9365e+02 /)
      kbo(:,29,14) = (/ &
     &5.8351e+02 ,5.9046e+02 ,5.9468e+02 ,5.9643e+02 ,5.9604e+02 /)
      kbo(:,30,14) = (/ &
     &5.8500e+02 ,5.9236e+02 ,5.9667e+02 ,5.9846e+02 ,5.9808e+02 /)
      kbo(:,31,14) = (/ &
     &5.8683e+02 ,5.9418e+02 ,5.9850e+02 ,6.0020e+02 ,5.9975e+02 /)
      kbo(:,32,14) = (/ &
     &5.8889e+02 ,5.9602e+02 ,6.0013e+02 ,6.0165e+02 ,6.0111e+02 /)
      kbo(:,33,14) = (/ &
     &5.9113e+02 ,5.9792e+02 ,6.0167e+02 ,6.0289e+02 ,6.0219e+02 /)
      kbo(:,34,14) = (/ &
     &5.9309e+02 ,5.9954e+02 ,6.0296e+02 ,6.0390e+02 ,6.0309e+02 /)
      kbo(:,35,14) = (/ &
     &5.9425e+02 ,6.0057e+02 ,6.0391e+02 ,6.0481e+02 ,6.0395e+02 /)
      kbo(:,36,14) = (/ &
     &5.9453e+02 ,6.0102e+02 ,6.0449e+02 ,6.0555e+02 ,6.0478e+02 /)
      kbo(:,37,14) = (/ &
     &5.9344e+02 ,6.0064e+02 ,6.0466e+02 ,6.0613e+02 ,6.0565e+02 /)
      kbo(:,38,14) = (/ &
     &5.9210e+02 ,6.0005e+02 ,6.0460e+02 ,6.0657e+02 ,6.0636e+02 /)
      kbo(:,39,14) = (/ &
     &5.9062e+02 ,5.9933e+02 ,6.0439e+02 ,6.0685e+02 ,6.0693e+02 /)
      kbo(:,40,14) = (/ &
     &5.8781e+02 ,5.9770e+02 ,6.0363e+02 ,6.0675e+02 ,6.0742e+02 /)
      kbo(:,41,14) = (/ &
     &5.8441e+02 ,5.9563e+02 ,6.0254e+02 ,6.0641e+02 ,6.0773e+02 /)
      kbo(:,42,14) = (/ &
     &5.8066e+02 ,5.9320e+02 ,6.0125e+02 ,6.0582e+02 ,6.0784e+02 /)
      kbo(:,43,14) = (/ &
     &5.7546e+02 ,5.8975e+02 ,5.9921e+02 ,6.0478e+02 ,6.0764e+02 /)
      kbo(:,44,14) = (/ &
     &5.6919e+02 ,5.8551e+02 ,5.9655e+02 ,6.0334e+02 ,6.0709e+02 /)
      kbo(:,45,14) = (/ &
     &5.6228e+02 ,5.8057e+02 ,5.9328e+02 ,6.0149e+02 ,6.0621e+02 /)
      kbo(:,46,14) = (/ &
     &5.5416e+02 ,5.7453e+02 ,5.8925e+02 ,5.9904e+02 ,6.0487e+02 /)
      kbo(:,47,14) = (/ &
     &5.4413e+02 ,5.6695e+02 ,5.8396e+02 ,5.9568e+02 ,6.0296e+02 /)
      kbo(:,48,14) = (/ &
     &5.3289e+02 ,5.5838e+02 ,5.7778e+02 ,5.9151e+02 ,6.0055e+02 /)
      kbo(:,49,14) = (/ &
     &5.2046e+02 ,5.4886e+02 ,5.7056e+02 ,5.8661e+02 ,5.9745e+02 /)
      kbo(:,50,14) = (/ &
     &5.0763e+02 ,5.3890e+02 ,5.6309e+02 ,5.8123e+02 ,5.9389e+02 /)
      kbo(:,51,14) = (/ &
     &4.9397e+02 ,5.2829e+02 ,5.5490e+02 ,5.7522e+02 ,5.8985e+02 /)
      kbo(:,52,14) = (/ &
     &4.7917e+02 ,5.1663e+02 ,5.4597e+02 ,5.6843e+02 ,5.8514e+02 /)
      kbo(:,53,14) = (/ &
     &4.6310e+02 ,5.0389e+02 ,5.3606e+02 ,5.6086e+02 ,5.7969e+02 /)
      kbo(:,54,14) = (/ &
     &4.4738e+02 ,4.9113e+02 ,5.2610e+02 ,5.5325e+02 ,5.7401e+02 /)
      kbo(:,55,14) = (/ &
     &4.3145e+02 ,4.7800e+02 ,5.1576e+02 ,5.4530e+02 ,5.6795e+02 /)
      kbo(:,56,14) = (/ &
     &4.1442e+02 ,4.6397e+02 ,5.0460e+02 ,5.3665e+02 ,5.6135e+02 /)
      kbo(:,57,14) = (/ &
     &3.9638e+02 ,4.4904e+02 ,4.9255e+02 ,5.2719e+02 ,5.5411e+02 /)
      kbo(:,58,14) = (/ &
     &3.7836e+02 ,4.3410e+02 ,4.8026e+02 ,5.1754e+02 ,5.4672e+02 /)
      kbo(:,59,14) = (/ &
     &3.7094e+02 ,4.2781e+02 ,4.7507e+02 ,5.1348e+02 ,5.4351e+02 /)
      kbo(:,13,15) = (/ &
     &7.2633e+02 ,7.1401e+02 ,7.0254e+02 ,6.9098e+02 ,6.8020e+02 /)
      kbo(:,14,15) = (/ &
     &8.3011e+02 ,8.1776e+02 ,8.0585e+02 ,7.9323e+02 ,7.8158e+02 /)
      kbo(:,15,15) = (/ &
     &9.4371e+02 ,9.3141e+02 ,9.1779e+02 ,9.0358e+02 ,8.9021e+02 /)
      kbo(:,16,15) = (/ &
     &1.0657e+03 ,1.0512e+03 ,1.0343e+03 ,1.0183e+03 ,1.0024e+03 /)
      kbo(:,17,15) = (/ &
     &1.1900e+03 ,1.1715e+03 ,1.1530e+03 ,1.1344e+03 ,1.1149e+03 /)
      kbo(:,18,15) = (/ &
     &1.3144e+03 ,1.2934e+03 ,1.2719e+03 ,1.2491e+03 ,1.2254e+03 /)
      kbo(:,19,15) = (/ &
     &1.4395e+03 ,1.4148e+03 ,1.3884e+03 ,1.3607e+03 ,1.3337e+03 /)
      kbo(:,20,15) = (/ &
     &1.5639e+03 ,1.5338e+03 ,1.5021e+03 ,1.4707e+03 ,1.4392e+03 /)
      kbo(:,21,15) = (/ &
     &1.6839e+03 ,1.6488e+03 ,1.6126e+03 ,1.5763e+03 ,1.5389e+03 /)
      kbo(:,22,15) = (/ &
     &1.7952e+03 ,1.7545e+03 ,1.7135e+03 ,1.6710e+03 ,1.6285e+03 /)
      kbo(:,23,15) = (/ &
     &1.8976e+03 ,1.8509e+03 ,1.8033e+03 ,1.7556e+03 ,1.7089e+03 /)
      kbo(:,24,15) = (/ &
     &1.9890e+03 ,1.9360e+03 ,1.8826e+03 ,1.8303e+03 ,1.7792e+03 /)
      kbo(:,25,15) = (/ &
     &2.0674e+03 ,2.0090e+03 ,1.9512e+03 ,1.8940e+03 ,1.8389e+03 /)
      kbo(:,26,15) = (/ &
     &2.1327e+03 ,2.0701e+03 ,2.0075e+03 ,1.9460e+03 ,1.8872e+03 /)
      kbo(:,27,15) = (/ &
     &2.1871e+03 ,2.1199e+03 ,2.0526e+03 ,1.9878e+03 ,1.9258e+03 /)
      kbo(:,28,15) = (/ &
     &2.2305e+03 ,2.1590e+03 ,2.0884e+03 ,2.0207e+03 ,1.9559e+03 /)
      kbo(:,29,15) = (/ &
     &2.2640e+03 ,2.1881e+03 ,2.1149e+03 ,2.0446e+03 ,1.9773e+03 /)
      kbo(:,30,15) = (/ &
     &2.2867e+03 ,2.2086e+03 ,2.1332e+03 ,2.0610e+03 ,1.9920e+03 /)
      kbo(:,31,15) = (/ &
     &2.3021e+03 ,2.2217e+03 ,2.1448e+03 ,2.0709e+03 ,2.0000e+03 /)
      kbo(:,32,15) = (/ &
     &2.3102e+03 ,2.2286e+03 ,2.1502e+03 ,2.0751e+03 ,2.0031e+03 /)
      kbo(:,33,15) = (/ &
     &2.3126e+03 ,2.2299e+03 ,2.1503e+03 ,2.0747e+03 ,2.0018e+03 /)
      kbo(:,34,15) = (/ &
     &2.3131e+03 ,2.2295e+03 ,2.1494e+03 ,2.0730e+03 ,1.9993e+03 /)
      kbo(:,35,15) = (/ &
     &2.3181e+03 ,2.2337e+03 ,2.1530e+03 ,2.0757e+03 ,2.0015e+03 /)
      kbo(:,36,15) = (/ &
     &2.3296e+03 ,2.2444e+03 ,2.1625e+03 ,2.0844e+03 ,2.0094e+03 /)
      kbo(:,37,15) = (/ &
     &2.3524e+03 ,2.2655e+03 ,2.1822e+03 ,2.1029e+03 ,2.0270e+03 /)
      kbo(:,38,15) = (/ &
     &2.3744e+03 ,2.2859e+03 ,2.2015e+03 ,2.1208e+03 ,2.0440e+03 /)
      kbo(:,39,15) = (/ &
     &2.3947e+03 ,2.3050e+03 ,2.2197e+03 ,2.1376e+03 ,2.0600e+03 /)
      kbo(:,40,15) = (/ &
     &2.4238e+03 ,2.3323e+03 ,2.2455e+03 ,2.1621e+03 ,2.0831e+03 /)
      kbo(:,41,15) = (/ &
     &2.4535e+03 ,2.3601e+03 ,2.2718e+03 ,2.1873e+03 ,2.1067e+03 /)
      kbo(:,42,15) = (/ &
     &2.4827e+03 ,2.3879e+03 ,2.2978e+03 ,2.2120e+03 ,2.1299e+03 /)
      kbo(:,43,15) = (/ &
     &2.5170e+03 ,2.4207e+03 ,2.3287e+03 ,2.2417e+03 ,2.1580e+03 /)
      kbo(:,44,15) = (/ &
     &2.5535e+03 ,2.4558e+03 ,2.3619e+03 ,2.2731e+03 ,2.1881e+03 /)
      kbo(:,45,15) = (/ &
     &2.5895e+03 ,2.4909e+03 ,2.3955e+03 ,2.3046e+03 ,2.2183e+03 /)
      kbo(:,46,15) = (/ &
     &2.6275e+03 ,2.5286e+03 ,2.4314e+03 ,2.3383e+03 ,2.2507e+03 /)
      kbo(:,47,15) = (/ &
     &2.6692e+03 ,2.5702e+03 ,2.4716e+03 ,2.3766e+03 ,2.2868e+03 /)
      kbo(:,48,15) = (/ &
     &2.7104e+03 ,2.6117e+03 ,2.5124e+03 ,2.4158e+03 ,2.3235e+03 /)
      kbo(:,49,15) = (/ &
     &2.7515e+03 ,2.6527e+03 ,2.5535e+03 ,2.4553e+03 ,2.3608e+03 /)
      kbo(:,50,15) = (/ &
     &2.7894e+03 ,2.6912e+03 ,2.5919e+03 ,2.4928e+03 ,2.3968e+03 /)
      kbo(:,51,15) = (/ &
     &2.8258e+03 ,2.7283e+03 ,2.6293e+03 ,2.5297e+03 ,2.4319e+03 /)
      kbo(:,52,15) = (/ &
     &2.8615e+03 ,2.7650e+03 ,2.6661e+03 ,2.5667e+03 ,2.4680e+03 /)
      kbo(:,53,15) = (/ &
     &2.8958e+03 ,2.8012e+03 ,2.7030e+03 ,2.6033e+03 ,2.5041e+03 /)
      kbo(:,54,15) = (/ &
     &2.9257e+03 ,2.8343e+03 ,2.7368e+03 ,2.6377e+03 ,2.5378e+03 /)
      kbo(:,55,15) = (/ &
     &2.9533e+03 ,2.8653e+03 ,2.7685e+03 ,2.6697e+03 ,2.5700e+03 /)
      kbo(:,56,15) = (/ &
     &2.9793e+03 ,2.8948e+03 ,2.8002e+03 ,2.7018e+03 ,2.6024e+03 /)
      kbo(:,57,15) = (/ &
     &3.0042e+03 ,2.9237e+03 ,2.8317e+03 ,2.7340e+03 ,2.6347e+03 /)
      kbo(:,58,15) = (/ &
     &3.0257e+03 ,2.9495e+03 ,2.8610e+03 ,2.7641e+03 ,2.6651e+03 /)
      kbo(:,59,15) = (/ &
     &3.0338e+03 ,2.9597e+03 ,2.8725e+03 ,2.7761e+03 ,2.6773e+03 /)
      kbo(:,13,16) = (/ &
     &1.0026e+03 ,9.7775e+02 ,9.6058e+02 ,9.5314e+02 ,9.4719e+02 /)
      kbo(:,14,16) = (/ &
     &1.2035e+03 ,1.1711e+03 ,1.1486e+03 ,1.1339e+03 ,1.1211e+03 /)
      kbo(:,15,16) = (/ &
     &1.4371e+03 ,1.3952e+03 ,1.3661e+03 ,1.3423e+03 ,1.3197e+03 /)
      kbo(:,16,16) = (/ &
     &1.7031e+03 ,1.6520e+03 ,1.6127e+03 ,1.5775e+03 ,1.5442e+03 /)
      kbo(:,17,16) = (/ &
     &2.0034e+03 ,1.9408e+03 ,1.8881e+03 ,1.8394e+03 ,1.7917e+03 /)
      kbo(:,18,16) = (/ &
     &2.3372e+03 ,2.2594e+03 ,2.1891e+03 ,2.1223e+03 ,2.0585e+03 /)
      kbo(:,19,16) = (/ &
     &2.7003e+03 ,2.6007e+03 ,2.5092e+03 ,2.4222e+03 ,2.3387e+03 /)
      kbo(:,20,16) = (/ &
     &3.0827e+03 ,2.9575e+03 ,2.8405e+03 ,2.7290e+03 ,2.6233e+03 /)
      kbo(:,21,16) = (/ &
     &3.4765e+03 ,3.3200e+03 ,3.1728e+03 ,3.0348e+03 ,2.9062e+03 /)
      kbo(:,22,16) = (/ &
     &3.8557e+03 ,3.6642e+03 ,3.4867e+03 ,3.3227e+03 ,3.1685e+03 /)
      kbo(:,23,16) = (/ &
     &4.2141e+03 ,3.9881e+03 ,3.7808e+03 ,3.5882e+03 ,3.4103e+03 /)
      kbo(:,24,16) = (/ &
     &4.5433e+03 ,4.2837e+03 ,4.0442e+03 ,3.8246e+03 ,3.6242e+03 /)
      kbo(:,25,16) = (/ &
     &4.8340e+03 ,4.5405e+03 ,4.2717e+03 ,4.0284e+03 ,3.8059e+03 /)
      kbo(:,26,16) = (/ &
     &5.0756e+03 ,4.7511e+03 ,4.4591e+03 ,4.1940e+03 ,3.9524e+03 /)
      kbo(:,27,16) = (/ &
     &5.2698e+03 ,4.9206e+03 ,4.6082e+03 ,4.3247e+03 ,4.0667e+03 /)
      kbo(:,28,16) = (/ &
     &5.4203e+03 ,5.0514e+03 ,4.7208e+03 ,4.4225e+03 ,4.1519e+03 /)
      kbo(:,29,16) = (/ &
     &5.5225e+03 ,5.1430e+03 ,4.7990e+03 ,4.4889e+03 ,4.2086e+03 /)
      kbo(:,30,16) = (/ &
     &5.5968e+03 ,5.2018e+03 ,4.8479e+03 ,4.5299e+03 ,4.2431e+03 /)
      kbo(:,31,16) = (/ &
     &5.6319e+03 ,5.2297e+03 ,4.8692e+03 ,4.5471e+03 ,4.2577e+03 /)
      kbo(:,32,16) = (/ &
     &5.6393e+03 ,5.2323e+03 ,4.8693e+03 ,4.5451e+03 ,4.2544e+03 /)
      kbo(:,33,16) = (/ &
     &5.6219e+03 ,5.2153e+03 ,4.8522e+03 ,4.5281e+03 ,4.2389e+03 /)
      kbo(:,34,16) = (/ &
     &5.6014e+03 ,5.1950e+03 ,4.8333e+03 ,4.5105e+03 ,4.2225e+03 /)
      kbo(:,35,16) = (/ &
     &5.6085e+03 ,5.1993e+03 ,4.8360e+03 ,4.5120e+03 ,4.2238e+03 /)
      kbo(:,36,16) = (/ &
     &5.6508e+03 ,5.2362e+03 ,4.8672e+03 ,4.5401e+03 ,4.2477e+03 /)
      kbo(:,37,16) = (/ &
     &5.7523e+03 ,5.3259e+03 ,4.9464e+03 ,4.6095e+03 ,4.3092e+03 /)
      kbo(:,38,16) = (/ &
     &5.8536e+03 ,5.4145e+03 ,5.0247e+03 ,4.6788e+03 ,4.3703e+03 /)
      kbo(:,39,16) = (/ &
     &5.9499e+03 ,5.4442e+03 ,5.0495e+03 ,4.7451e+03 ,4.4289e+03 /)
      kbo(:,40,16) = (/ &
     &6.0943e+03 ,5.6261e+03 ,5.2115e+03 ,4.8437e+03 ,4.5174e+03 /)
      kbo(:,41,16) = (/ &
     &6.2466e+03 ,5.7599e+03 ,5.3292e+03 ,4.9481e+03 ,4.6100e+03 /)
      kbo(:,42,16) = (/ &
     &6.4016e+03 ,5.8949e+03 ,5.4490e+03 ,5.0540e+03 ,4.7039e+03 /)
      kbo(:,43,16) = (/ &
     &6.5921e+03 ,6.0603e+03 ,5.5952e+03 ,5.1830e+03 ,4.8181e+03 /)
      kbo(:,44,16) = (/ &
     &6.8054e+03 ,6.2437e+03 ,5.7562e+03 ,5.3258e+03 ,4.9439e+03 /)
      kbo(:,45,16) = (/ &
     &7.0283e+03 ,6.4351e+03 ,5.9235e+03 ,5.4736e+03 ,5.0747e+03 /)
      kbo(:,46,16) = (/ &
     &7.2775e+03 ,6.6473e+03 ,6.1076e+03 ,5.6361e+03 ,5.2188e+03 /)
      kbo(:,47,16) = (/ &
     &7.5694e+03 ,6.8970e+03 ,6.3223e+03 ,5.8241e+03 ,5.3852e+03 /)
      kbo(:,48,16) = (/ &
     &7.8805e+03 ,7.1623e+03 ,6.5487e+03 ,6.0220e+03 ,5.5600e+03 /)
      kbo(:,49,16) = (/ &
     &8.2112e+03 ,7.4430e+03 ,6.7899e+03 ,6.2293e+03 ,5.7432e+03 /)
      kbo(:,50,16) = (/ &
     &8.5417e+03 ,7.7234e+03 ,7.0279e+03 ,6.4340e+03 ,5.9223e+03 /)
      kbo(:,51,16) = (/ &
     &8.8820e+03 ,8.0126e+03 ,7.2736e+03 ,6.6439e+03 ,6.1042e+03 /)
      kbo(:,52,16) = (/ &
     &9.2420e+03 ,8.3170e+03 ,7.5326e+03 ,6.8651e+03 ,6.2940e+03 /)
      kbo(:,53,16) = (/ &
     &9.6269e+03 ,8.6414e+03 ,7.8081e+03 ,7.0991e+03 ,6.4953e+03 /)
      kbo(:,54,16) = (/ &
     &1.0002e+04 ,8.9556e+03 ,8.0739e+03 ,7.3265e+03 ,6.6894e+03 /)
      kbo(:,55,16) = (/ &
     &1.0382e+04 ,9.2723e+03 ,8.3431e+03 ,7.5548e+03 ,6.8840e+03 /)
      kbo(:,56,16) = (/ &
     &1.0780e+04 ,9.6091e+03 ,8.6265e+03 ,7.7944e+03 ,7.0899e+03 /)
      kbo(:,57,16) = (/ &
     &1.1201e+04 ,9.9648e+03 ,8.9241e+03 ,8.0480e+03 ,7.3039e+03 /)
      kbo(:,58,16) = (/ &
     &1.1621e+04 ,1.0321e+04 ,9.2223e+03 ,8.3005e+03 ,7.5182e+03 /)
      kbo(:,59,16) = (/ &
     &1.1796e+04 ,1.0468e+04 ,9.3476e+03 ,8.4058e+03 ,7.6078e+03 /)

!     The array KAO_Mxx contains the absorption coefficient for 
!     a minor species at the 16 chosen g-values for a reference pressure
!     level below 100~ mb.   The first index refers to temperature 
!     in 7.2 degree increments.  For instance, JT = 1 refers to a 
!     temperature of 188.0, JT = 2 refers to 195.2, etc. The second index 
!     runs over the g-channel (1 to 16).

      kao_mo2(:, 1) = (/ &
     & 2.31723e-06 , 2.28697e-06 , 2.25710e-06 , 2.22762e-06 , 2.19852e-06 , &
     & 2.16981e-06 , 2.14147e-06 , 2.11350e-06 , 2.08590e-06 , 2.05865e-06 , &
     & 2.03176e-06 , 2.00523e-06 , 1.97904e-06 , 1.95319e-06 , 1.92768e-06 , &
     & 1.90250e-06 , 1.87765e-06 , 1.85313e-06 , 1.82893e-06 /)
      kao_mo2(:, 2) = (/ &
     & 1.81980e-06 , 1.81352e-06 , 1.80726e-06 , 1.80101e-06 , 1.79479e-06 , &
     & 1.78860e-06 , 1.78242e-06 , 1.77626e-06 , 1.77013e-06 , 1.76402e-06 , &
     & 1.75792e-06 , 1.75185e-06 , 1.74580e-06 , 1.73977e-06 , 1.73377e-06 , &
     & 1.72778e-06 , 1.72181e-06 , 1.71587e-06 , 1.70994e-06 /)
      kao_mo2(:, 3) = (/ &
     & 2.26922e-06 , 2.25413e-06 , 2.23914e-06 , 2.22425e-06 , 2.20945e-06 , &
     & 2.19476e-06 , 2.18016e-06 , 2.16566e-06 , 2.15126e-06 , 2.13695e-06 , &
     & 2.12274e-06 , 2.10862e-06 , 2.09459e-06 , 2.08066e-06 , 2.06683e-06 , &
     & 2.05308e-06 , 2.03942e-06 , 2.02586e-06 , 2.01239e-06 /)
      kao_mo2(:, 4) = (/ &
     & 2.15555e-06 , 2.14539e-06 , 2.13527e-06 , 2.12520e-06 , 2.11517e-06 , &
     & 2.10520e-06 , 2.09527e-06 , 2.08538e-06 , 2.07555e-06 , 2.06576e-06 , &
     & 2.05601e-06 , 2.04631e-06 , 2.03666e-06 , 2.02706e-06 , 2.01749e-06 , &
     & 2.00798e-06 , 1.99851e-06 , 1.98908e-06 , 1.97970e-06 /)
      kao_mo2(:, 5) = (/ &
     & 2.05821e-06 , 2.04914e-06 , 2.04011e-06 , 2.03111e-06 , 2.02216e-06 , &
     & 2.01324e-06 , 2.00437e-06 , 1.99553e-06 , 1.98673e-06 , 1.97798e-06 , &
     & 1.96926e-06 , 1.96057e-06 , 1.95193e-06 , 1.94333e-06 , 1.93476e-06 , &
     & 1.92623e-06 , 1.91774e-06 , 1.90928e-06 , 1.90087e-06 /)
      kao_mo2(:, 6) = (/ &
     & 2.20148e-06 , 2.18998e-06 , 2.17854e-06 , 2.16717e-06 , 2.15585e-06 , &
     & 2.14459e-06 , 2.13339e-06 , 2.12225e-06 , 2.11117e-06 , 2.10014e-06 , &
     & 2.08918e-06 , 2.07827e-06 , 2.06741e-06 , 2.05662e-06 , 2.04588e-06 , &
     & 2.03519e-06 , 2.02457e-06 , 2.01399e-06 , 2.00348e-06 /)
      kao_mo2(:, 7) = (/ &
     & 2.28960e-06 , 2.27651e-06 , 2.26349e-06 , 2.25054e-06 , 2.23767e-06 , &
     & 2.22487e-06 , 2.21215e-06 , 2.19950e-06 , 2.18692e-06 , 2.17441e-06 , &
     & 2.16198e-06 , 2.14961e-06 , 2.13732e-06 , 2.12509e-06 , 2.11294e-06 , &
     & 2.10085e-06 , 2.08884e-06 , 2.07689e-06 , 2.06501e-06 /)
      kao_mo2(:, 8) = (/ &
     & 2.28564e-06 , 2.27363e-06 , 2.26168e-06 , 2.24980e-06 , 2.23798e-06 , &
     & 2.22622e-06 , 2.21452e-06 , 2.20288e-06 , 2.19131e-06 , 2.17980e-06 , &
     & 2.16834e-06 , 2.15695e-06 , 2.14562e-06 , 2.13434e-06 , 2.12313e-06 , &
     & 2.11197e-06 , 2.10087e-06 , 2.08984e-06 , 2.07886e-06 /)
      kao_mo2(:, 9) = (/ &
     & 2.28505e-06 , 2.27395e-06 , 2.26291e-06 , 2.25192e-06 , 2.24099e-06 , &
     & 2.23011e-06 , 2.21928e-06 , 2.20850e-06 , 2.19778e-06 , 2.18711e-06 , &
     & 2.17649e-06 , 2.16592e-06 , 2.15540e-06 , 2.14494e-06 , 2.13452e-06 , &
     & 2.12416e-06 , 2.11385e-06 , 2.10358e-06 , 2.09337e-06 /)
      kao_mo2(:,10) = (/ &
     & 2.25915e-06 , 2.24938e-06 , 2.23965e-06 , 2.22997e-06 , 2.22032e-06 , &
     & 2.21072e-06 , 2.20116e-06 , 2.19164e-06 , 2.18216e-06 , 2.17272e-06 , &
     & 2.16333e-06 , 2.15397e-06 , 2.14465e-06 , 2.13538e-06 , 2.12614e-06 , &
     & 2.11695e-06 , 2.10779e-06 , 2.09868e-06 , 2.08960e-06 /)
      kao_mo2(:,11) = (/ &
     & 2.52025e-06 , 2.50423e-06 , 2.48831e-06 , 2.47249e-06 , 2.45677e-06 , &
     & 2.44115e-06 , 2.42563e-06 , 2.41021e-06 , 2.39489e-06 , 2.37967e-06 , &
     & 2.36454e-06 , 2.34951e-06 , 2.33457e-06 , 2.31973e-06 , 2.30498e-06 , &
     & 2.29033e-06 , 2.27577e-06 , 2.26130e-06 , 2.24692e-06 /)
      kao_mo2(:,12) = (/ &
     & 2.52634e-06 , 2.51180e-06 , 2.49735e-06 , 2.48299e-06 , 2.46871e-06 , &
     & 2.45451e-06 , 2.44039e-06 , 2.42635e-06 , 2.41239e-06 , 2.39851e-06 , &
     & 2.38472e-06 , 2.37100e-06 , 2.35736e-06 , 2.34380e-06 , 2.33032e-06 , &
     & 2.31691e-06 , 2.30358e-06 , 2.29033e-06 , 2.27716e-06 /)
      kao_mo2(:,13) = (/ &
     & 2.66614e-06 , 2.64897e-06 , 2.63191e-06 , 2.61496e-06 , 2.59812e-06 , &
     & 2.58138e-06 , 2.56476e-06 , 2.54824e-06 , 2.53183e-06 , 2.51552e-06 , &
     & 2.49932e-06 , 2.48322e-06 , 2.46723e-06 , 2.45134e-06 , 2.43555e-06 , &
     & 2.41987e-06 , 2.40428e-06 , 2.38880e-06 , 2.37341e-06 /)
      kao_mo2(:,14) = (/ &
     & 2.96755e-06 , 2.94803e-06 , 2.92864e-06 , 2.90937e-06 , 2.89023e-06 , &
     & 2.87122e-06 , 2.85233e-06 , 2.83357e-06 , 2.81493e-06 , 2.79641e-06 , &
     & 2.77802e-06 , 2.75974e-06 , 2.74159e-06 , 2.72355e-06 , 2.70563e-06 , &
     & 2.68784e-06 , 2.67015e-06 , 2.65259e-06 , 2.63514e-06 /)
      kao_mo2(:,15) = (/ &
     & 1.30668e-06 , 1.31378e-06 , 1.32091e-06 , 1.32808e-06 , 1.33530e-06 , &
     & 1.34255e-06 , 1.34984e-06 , 1.35717e-06 , 1.36454e-06 , 1.37195e-06 , &
     & 1.37941e-06 , 1.38690e-06 , 1.39443e-06 , 1.40200e-06 , 1.40962e-06 , &
     & 1.41727e-06 , 1.42497e-06 , 1.43271e-06 , 1.44049e-06 /)
      kao_mo2(:,16) = (/ &
     & 5.99001e-07 , 6.16844e-07 , 6.35219e-07 , 6.54141e-07 , 6.73626e-07 , &
     & 6.93692e-07 , 7.14356e-07 , 7.35635e-07 , 7.57548e-07 , 7.80114e-07 , &
     & 8.03352e-07 , 8.27282e-07 , 8.51925e-07 , 8.77302e-07 , 9.03435e-07 , &
     & 9.30347e-07 , 9.58060e-07 , 9.86599e-07 , 1.01599e-06 /)

!     The array KBO_Mxx contains the absorption coefficient for 
!     a minor species at the 16 chosen g-values for a reference pressure
!     level above 100~ mb.   The first index refers to temperature 
!     in 7.2 degree increments.  For instance, JT = 1 refers to a 
!     temperature of 188.0, JT = 2 refers to 195.2, etc. The second index 
!     runs over the g-channel (1 to 16).

      kbo_mo2(:, 1) = (/ &
     & 4.97626e-07 , 5.05955e-07 , 5.14424e-07 , 5.23034e-07 , 5.31789e-07 , &
     & 5.40690e-07 , 5.49739e-07 , 5.58941e-07 , 5.68296e-07 , 5.77808e-07 , &
     & 5.87479e-07 , 5.97312e-07 , 6.07310e-07 , 6.17475e-07 , 6.27810e-07 , &
     & 6.38318e-07 , 6.49002e-07 , 6.59865e-07 , 6.70910e-07 /)
      kbo_mo2(:, 2) = (/ &
     & 3.10232e-06 , 3.06339e-06 , 3.02496e-06 , 2.98700e-06 , 2.94952e-06 , &
     & 2.91252e-06 , 2.87597e-06 , 2.83989e-06 , 2.80426e-06 , 2.76907e-06 , &
     & 2.73433e-06 , 2.70002e-06 , 2.66614e-06 , 2.63269e-06 , 2.59966e-06 , &
     & 2.56704e-06 , 2.53483e-06 , 2.50303e-06 , 2.47162e-06 /)
      kbo_mo2(:, 3) = (/ &
     & 2.91635e-06 , 2.88637e-06 , 2.85669e-06 , 2.82733e-06 , 2.79826e-06 , &
     & 2.76949e-06 , 2.74102e-06 , 2.71284e-06 , 2.68495e-06 , 2.65735e-06 , &
     & 2.63003e-06 , 2.60299e-06 , 2.57623e-06 , 2.54975e-06 , 2.52353e-06 , &
     & 2.49759e-06 , 2.47191e-06 , 2.44650e-06 , 2.42135e-06 /)
      kbo_mo2(:, 4) = (/ &
     & 3.15584e-06 , 3.11986e-06 , 3.08430e-06 , 3.04914e-06 , 3.01438e-06 , &
     & 2.98002e-06 , 2.94605e-06 , 2.91247e-06 , 2.87927e-06 , 2.84645e-06 , &
     & 2.81400e-06 , 2.78192e-06 , 2.75021e-06 , 2.71886e-06 , 2.68787e-06 , &
     & 2.65723e-06 , 2.62694e-06 , 2.59699e-06 , 2.56739e-06 /)
      kbo_mo2(:, 5) = (/ &
     & 2.52067e-06 , 2.50127e-06 , 2.48202e-06 , 2.46291e-06 , 2.44396e-06 , &
     & 2.42515e-06 , 2.40648e-06 , 2.38796e-06 , 2.36958e-06 , 2.35134e-06 , &
     & 2.33324e-06 , 2.31529e-06 , 2.29747e-06 , 2.27978e-06 , 2.26224e-06 , &
     & 2.24482e-06 , 2.22755e-06 , 2.21040e-06 , 2.19339e-06 /)
      kbo_mo2(:, 6) = (/ &
     & 2.37304e-06 , 2.36340e-06 , 2.35380e-06 , 2.34423e-06 , 2.33471e-06 , &
     & 2.32522e-06 , 2.31578e-06 , 2.30637e-06 , 2.29700e-06 , 2.28766e-06 , &
     & 2.27837e-06 , 2.26911e-06 , 2.25989e-06 , 2.25071e-06 , 2.24157e-06 , &
     & 2.23246e-06 , 2.22339e-06 , 2.21436e-06 , 2.20536e-06 /)
      kbo_mo2(:, 7) = (/ &
     & 2.56366e-06 , 2.56395e-06 , 2.56424e-06 , 2.56453e-06 , 2.56482e-06 , &
     & 2.56510e-06 , 2.56539e-06 , 2.56568e-06 , 2.56597e-06 , 2.56625e-06 , &
     & 2.56654e-06 , 2.56683e-06 , 2.56712e-06 , 2.56741e-06 , 2.56769e-06 , &
     & 2.56798e-06 , 2.56827e-06 , 2.56856e-06 , 2.56885e-06 /)
      kbo_mo2(:, 8) = (/ &
     & 2.54502e-06 , 2.55393e-06 , 2.56287e-06 , 2.57185e-06 , 2.58085e-06 , &
     & 2.58989e-06 , 2.59896e-06 , 2.60806e-06 , 2.61719e-06 , 2.62636e-06 , &
     & 2.63555e-06 , 2.64478e-06 , 2.65404e-06 , 2.66334e-06 , 2.67266e-06 , &
     & 2.68202e-06 , 2.69141e-06 , 2.70084e-06 , 2.71030e-06 /)
      kbo_mo2(:, 9) = (/ &
     & 1.84106e-06 , 1.83922e-06 , 1.83737e-06 , 1.83553e-06 , 1.83369e-06 , &
     & 1.83186e-06 , 1.83002e-06 , 1.82819e-06 , 1.82636e-06 , 1.82453e-06 , &
     & 1.82270e-06 , 1.82087e-06 , 1.81905e-06 , 1.81723e-06 , 1.81541e-06 , &
     & 1.81359e-06 , 1.81177e-06 , 1.80996e-06 , 1.80814e-06 /)
      kbo_mo2(:,10) = (/ &
     & 1.83886e-06 , 1.83632e-06 , 1.83379e-06 , 1.83126e-06 , 1.82874e-06 , &
     & 1.82622e-06 , 1.82370e-06 , 1.82119e-06 , 1.81868e-06 , 1.81617e-06 , &
     & 1.81367e-06 , 1.81117e-06 , 1.80867e-06 , 1.80618e-06 , 1.80369e-06 , &
     & 1.80120e-06 , 1.79872e-06 , 1.79624e-06 , 1.79377e-06 /)
      kbo_mo2(:,11) = (/ &
     & 2.30390e-06 , 2.30269e-06 , 2.30148e-06 , 2.30028e-06 , 2.29907e-06 , &
     & 2.29787e-06 , 2.29667e-06 , 2.29546e-06 , 2.29426e-06 , 2.29306e-06 , &
     & 2.29186e-06 , 2.29066e-06 , 2.28946e-06 , 2.28826e-06 , 2.28706e-06 , &
     & 2.28586e-06 , 2.28466e-06 , 2.28347e-06 , 2.28227e-06 /)
      kbo_mo2(:,12) = (/ &
     & 2.38201e-06 , 2.36536e-06 , 2.34882e-06 , 2.33240e-06 , 2.31609e-06 , &
     & 2.29990e-06 , 2.28382e-06 , 2.26785e-06 , 2.25199e-06 , 2.23625e-06 , &
     & 2.22061e-06 , 2.20508e-06 , 2.18967e-06 , 2.17436e-06 , 2.15915e-06 , &
     & 2.14406e-06 , 2.12907e-06 , 2.11418e-06 , 2.09940e-06 /)
      kbo_mo2(:,13) = (/ &
     & 2.33326e-06 , 2.32549e-06 , 2.31775e-06 , 2.31003e-06 , 2.30234e-06 , &
     & 2.29467e-06 , 2.28703e-06 , 2.27941e-06 , 2.27182e-06 , 2.26426e-06 , &
     & 2.25672e-06 , 2.24920e-06 , 2.24171e-06 , 2.23424e-06 , 2.22680e-06 , &
     & 2.21939e-06 , 2.21200e-06 , 2.20463e-06 , 2.19729e-06 /)
      kbo_mo2(:,14) = (/ &
     & 2.75292e-06 , 2.75210e-06 , 2.75129e-06 , 2.75047e-06 , 2.74965e-06 , &
     & 2.74883e-06 , 2.74801e-06 , 2.74720e-06 , 2.74638e-06 , 2.74556e-06 , &
     & 2.74475e-06 , 2.74393e-06 , 2.74311e-06 , 2.74230e-06 , 2.74148e-06 , &
     & 2.74067e-06 , 2.73985e-06 , 2.73904e-06 , 2.73822e-06 /)
      kbo_mo2(:,15) = (/ &
     & 2.55262e-06 , 2.53364e-06 , 2.51480e-06 , 2.49611e-06 , 2.47755e-06 , &
     & 2.45913e-06 , 2.44084e-06 , 2.42269e-06 , 2.40468e-06 , 2.38680e-06 , &
     & 2.36906e-06 , 2.35144e-06 , 2.33396e-06 , 2.31660e-06 , 2.29938e-06 , &
     & 2.28228e-06 , 2.26531e-06 , 2.24847e-06 , 2.23175e-06 /)
      kbo_mo2(:,16) = (/ &
     & 3.11382e-06 , 3.08751e-06 , 3.06141e-06 , 3.03554e-06 , 3.00989e-06 , &
     & 2.98445e-06 , 2.95923e-06 , 2.93422e-06 , 2.90942e-06 , 2.88483e-06 , &
     & 2.86045e-06 , 2.83628e-06 , 2.81231e-06 , 2.78854e-06 , 2.76498e-06 , &
     & 2.74161e-06 , 2.71844e-06 , 2.69547e-06 , 2.67269e-06 /)

!     The array FORREFO contains the coefficient of the water vapor
!     foreign-continuum (including the energy term).  The first 
!     index refers to reference temperature (296,260,224,260) and 
!     pressure (970,475,219,3 mbar) levels.  The second index 
!     runs over the g-channel (1 to 16).

      forrefo(1,:) = (/ &
     &2.8858e-02 ,3.6879e-02 ,4.0746e-02 ,4.2561e-02 ,4.2740e-02 ,4.2707e-02 , &
     &4.4109e-02 ,4.4540e-02 ,4.5206e-02 ,4.4679e-02 ,4.5034e-02 ,4.5364e-02 , &
     &4.6790e-02 ,4.7857e-02 ,4.8328e-02 ,4.8084e-02 /)
      forrefo(2,:) = (/ &
     &2.7887e-02 ,3.7376e-02 ,4.0980e-02 ,4.2986e-02 ,4.3054e-02 ,4.2975e-02 , &
     &4.3754e-02 ,4.4352e-02 ,4.4723e-02 ,4.6236e-02 ,4.5273e-02 ,4.5360e-02 , &
     &4.5332e-02 ,4.7587e-02 ,4.7035e-02 ,5.0267e-02 /)
      forrefo(3,:) = (/ &
     &2.5846e-02 ,3.6753e-02 ,4.2334e-02 ,4.3806e-02 ,4.3848e-02 ,4.3215e-02 , &
     &4.3838e-02 ,4.4278e-02 ,4.4658e-02 ,4.5403e-02 ,4.5255e-02 ,4.6347e-02 , &
     &4.4722e-02 ,4.6612e-02 ,4.6836e-02 ,4.8720e-02 /)
      forrefo(4,:) = (/ &
     &2.8955e-02 ,3.7608e-02 ,4.1989e-02 ,4.4919e-02 ,4.2803e-02 ,4.2842e-02 , &
     &4.2632e-02 ,4.1056e-02 ,4.0086e-02 ,4.1401e-02 ,4.2746e-02 ,4.2142e-02 , &
     &4.1871e-02 ,4.3917e-02 ,4.5462e-02 ,4.8359e-02 /)

!     The array SELFREFO contains the coefficient of the water vapor
!     self-continuum (including the energy term).  The first index
!     refers to temperature in 7.2 degree increments.  For instance,
!     JT = 1 refers to a temperature of 245.6, JT = 2 refers to 252.8,
!     etc.  The second index runs over the g-channel (1 to 16).

      selfrefo(:, 1) = (/ &
     & 5.96496e-01 , 5.49171e-01 , 5.05600e-01 , 4.65486e-01 , 4.28555e-01 , &
     & 3.94554e-01 , 3.63250e-01 , 3.34430e-01 , 3.07897e-01 , 2.83468e-01 /)
      selfrefo(:, 2) = (/ &
     & 7.46455e-01 , 6.82459e-01 , 6.23950e-01 , 5.70457e-01 , 5.21550e-01 , &
     & 4.76836e-01 , 4.35956e-01 , 3.98580e-01 , 3.64409e-01 , 3.33167e-01 /)
      selfrefo(:, 3) = (/ &
     & 7.86805e-01 , 7.21186e-01 , 6.61040e-01 , 6.05910e-01 , 5.55378e-01 , &
     & 5.09059e-01 , 4.66605e-01 , 4.27690e-01 , 3.92021e-01 , 3.59327e-01 /)
      selfrefo(:, 4) = (/ &
     & 8.11740e-01 , 7.44359e-01 , 6.82570e-01 , 6.25910e-01 , 5.73954e-01 , &
     & 5.26311e-01 , 4.82622e-01 , 4.42560e-01 , 4.05823e-01 , 3.72136e-01 /)
      selfrefo(:, 5) = (/ &
     & 8.14870e-01 , 7.47200e-01 , 6.85150e-01 , 6.28253e-01 , 5.76081e-01 , &
     & 5.28241e-01 , 4.84374e-01 , 4.44150e-01 , 4.07266e-01 , 3.73446e-01 /)
      selfrefo(:, 6) = (/ &
     & 8.10104e-01 , 7.43259e-01 , 6.81930e-01 , 6.25661e-01 , 5.74035e-01 , &
     & 5.26669e-01 , 4.83212e-01 , 4.43340e-01 , 4.06758e-01 , 3.73195e-01 /)
      selfrefo(:, 7) = (/ &
     & 8.13119e-01 , 7.48127e-01 , 6.88330e-01 , 6.33312e-01 , 5.82692e-01 , &
     & 5.36118e-01 , 4.93267e-01 , 4.53840e-01 , 4.17565e-01 , 3.84189e-01 /)
      selfrefo(:, 8) = (/ &
     & 8.26137e-01 , 7.58984e-01 , 6.97290e-01 , 6.40611e-01 , 5.88539e-01 , &
     & 5.40699e-01 , 4.96748e-01 , 4.56370e-01 , 4.19274e-01 , 3.85193e-01 /)
      selfrefo(:, 9) = (/ &
     & 8.30566e-01 , 7.63984e-01 , 7.02740e-01 , 6.46405e-01 , 5.94587e-01 , &
     & 5.46922e-01 , 5.03079e-01 , 4.62750e-01 , 4.25654e-01 , 3.91532e-01 /)
      selfrefo(:,10) = (/ &
     & 8.67471e-01 , 7.91575e-01 , 7.22320e-01 , 6.59124e-01 , 6.01457e-01 , &
     & 5.48835e-01 , 5.00817e-01 , 4.57000e-01 , 4.17017e-01 , 3.80532e-01 /)
      selfrefo(:,11) = (/ &
     & 8.51029e-01 , 7.79373e-01 , 7.13750e-01 , 6.53652e-01 , 5.98615e-01 , &
     & 5.48212e-01 , 5.02053e-01 , 4.59780e-01 , 4.21067e-01 , 3.85613e-01 /)
      selfrefo(:,12) = (/ &
     & 8.36772e-01 , 7.68751e-01 , 7.06260e-01 , 6.48848e-01 , 5.96104e-01 , &
     & 5.47647e-01 , 5.03129e-01 , 4.62230e-01 , 4.24655e-01 , 3.90136e-01 /)
      selfrefo(:,13) = (/ &
     & 8.36551e-01 , 7.71089e-01 , 7.10750e-01 , 6.55133e-01 , 6.03867e-01 , &
     & 5.56614e-01 , 5.13058e-01 , 4.72910e-01 , 4.35904e-01 , 4.01794e-01 /)
      selfrefo(:,14) = (/ &
     & 8.84307e-01 , 8.11175e-01 , 7.44090e-01 , 6.82553e-01 , 6.26106e-01 , &
     & 5.74326e-01 , 5.26829e-01 , 4.83260e-01 , 4.43294e-01 , 4.06633e-01 /)
      selfrefo(:,15) = (/ &
     & 8.90356e-01 , 8.19830e-01 , 7.54890e-01 , 6.95094e-01 , 6.40035e-01 , &
     & 5.89337e-01 , 5.42655e-01 , 4.99670e-01 , 4.60090e-01 , 4.23646e-01 /)
      selfrefo(:,16) = (/ &
     & 9.67549e-01 , 8.79393e-01 , 7.99270e-01 , 7.26447e-01 , 6.60259e-01 , &
     & 6.00101e-01 , 5.45425e-01 , 4.95730e-01 , 4.50563e-01 , 4.09511e-01 /)

      end subroutine lw_kgb11
