!     path:      $Source$
!     author:    $Author$
!     revision:  $Revision$
!     created:   $Date$
!
!  --------------------------------------------------------------------------
! |                                                                          |
! |  Copyright 2002-2009, Atmospheric & Environmental Research, Inc. (AER).  |
! |  This software may be used, copied, or redistributed as long as it is    |
! |  not sold and this copyright notice is reproduced on each copy made.     |
! |  This model is provided as is without any express or implied warranties. |
! |                       (http://www.rtweb.aer.com/)                        |
! |                                                                          |
!  --------------------------------------------------------------------------

! **************************************************************************
!      subroutine lw_kgbnn
! **************************************************************************
!  RRTM Longwave Radiative Transfer Model
!  Atmospheric and Environmental Research, Inc., Cambridge, MA
!
!  Original version:   E. J. Mlawer, et al.
!  Revision for GCMs:  Michael J. Iacono; October, 2002
!  Revision for F90 formatting:  Michael J. Iacono; June 2006
!
!  This file contains 16 subroutines that include the 
!  absorption coefficients and other data for each of the 16 longwave
!  spectral bands used in RRTM.  Here, the data are defined for 16
!  g-points, or sub-intervals, per band.  These data are combined and
!  weighted using a mapping procedure in routine RRTMG_LW_INIT to reduce
!  the total number of g-points from 256 to 140 for use in the GCM.
! **************************************************************************
      subroutine lw_kgb10
! **************************************************************************

       !use parkind, only : im => kind , rb => kind  
      use rrlw_kg10, only : fracrefao, fracrefbo, kao, kbo, selfrefo, forrefo

      implicit none
      save

! Planck fraction mapping level : P = 212.7250, T = 223.06 K
      fracrefao(:) = (/ &
     &  1.6909e-01 , 1.5419e-01 , 1.3999e-01 , 1.2637e-01 , &
     &  1.1429e-01 , 9.9676e-02 , 8.0093e-02 , 6.0283e-02 , &
     &  4.1077e-02 , 4.4857e-03 , 3.6545e-03 , 2.9243e-03 , &
     &  2.0407e-03 , 1.2891e-03 , 4.8767e-04 , 6.7748e-05 /)

! Planck fraction mapping level : P = 95.58350 mb, T = 215.70 K
      fracrefbo(:) = (/ &
     &  1.7391e-01 , 1.5680e-01 , 1.4419e-01 , 1.2672e-01 , &
     &  1.0708e-01 , 9.7034e-02 , 7.8545e-02 , 5.9784e-02 , &
     &  4.0879e-02 , 4.4704e-03 , 3.7150e-03 , 2.9038e-03 , &
     &  2.1454e-03 , 1.2802e-03 , 4.8328e-04 , 6.7378e-05 /)

!     The array KAO contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels > ~100mb and temperatures.  The first
!     index in the array, JT, which runs from 1 to 5, corresponds to 
!     different temperatures.  More specifically, JT = 3 means that the 
!     data are for the corresponding TREF for this  pressure level, 
!     JT = 2 refers to the temperatureTREF-15, JT = 1 is for TREF-30, 
!     JT = 4 is for TREF+15, and JT = 5 is for TREF+30.  The second 
!     index, JP, runs from 1 to 13 and refers to the corresponding 
!     pressure level in PREF (e.g. JP = 1 is for a pressure of 1053.63 mb).  
!     The third index, IG, goes from 1 to 16, and tells us which 
!     g-interval the absorption coefficients are for.

      kao(:, 1, 1) = (/ &
     &2.7213e-02 ,2.9029e-02 ,3.0838e-02 ,3.2767e-02 ,3.4630e-02 /)
      kao(:, 2, 1) = (/ &
     &2.1383e-02 ,2.2832e-02 ,2.4365e-02 ,2.5925e-02 ,2.7376e-02 /)
      kao(:, 3, 1) = (/ &
     &1.6478e-02 ,1.7675e-02 ,1.8942e-02 ,2.0177e-02 ,2.1374e-02 /)
      kao(:, 4, 1) = (/ &
     &1.2848e-02 ,1.3809e-02 ,1.4825e-02 ,1.5852e-02 ,1.6799e-02 /)
      kao(:, 5, 1) = (/ &
     &1.0029e-02 ,1.0847e-02 ,1.1686e-02 ,1.2512e-02 ,1.3297e-02 /)
      kao(:, 6, 1) = (/ &
     &7.8313e-03 ,8.5460e-03 ,9.2025e-03 ,9.9079e-03 ,1.0554e-02 /)
      kao(:, 7, 1) = (/ &
     &6.1234e-03 ,6.6846e-03 ,7.2818e-03 ,7.8451e-03 ,8.4144e-03 /)
      kao(:, 8, 1) = (/ &
     &4.8747e-03 ,5.2881e-03 ,5.7474e-03 ,6.2355e-03 ,6.7085e-03 /)
      kao(:, 9, 1) = (/ &
     &4.1059e-03 ,4.5848e-03 ,4.9152e-03 ,5.2401e-03 ,5.5908e-03 /)
      kao(:,10, 1) = (/ &
     &3.5412e-03 ,4.0565e-03 ,4.5689e-03 ,5.1092e-03 ,5.6716e-03 /)
      kao(:,11, 1) = (/ &
     &3.0492e-03 ,3.6436e-03 ,4.0799e-03 ,4.5260e-03 ,4.9802e-03 /)
      kao(:,12, 1) = (/ &
     &2.5821e-03 ,3.0995e-03 ,3.5069e-03 ,3.8699e-03 ,4.2575e-03 /)
      kao(:,13, 1) = (/ &
     &2.1558e-03 ,2.5890e-03 ,2.9127e-03 ,3.2139e-03 ,3.5455e-03 /)
      kao(:, 1, 2) = (/ &
     &5.2889e-02 ,5.6315e-02 ,5.9927e-02 ,6.3408e-02 ,6.6329e-02 /)
      kao(:, 2, 2) = (/ &
     &4.1932e-02 ,4.4934e-02 ,4.8030e-02 ,5.0855e-02 ,5.3372e-02 /)
      kao(:, 3, 2) = (/ &
     &3.2754e-02 ,3.5198e-02 ,3.7786e-02 ,4.0294e-02 ,4.2438e-02 /)
      kao(:, 4, 2) = (/ &
     &2.5838e-02 ,2.7680e-02 ,2.9873e-02 ,3.1963e-02 ,3.3931e-02 /)
      kao(:, 5, 2) = (/ &
     &2.0528e-02 ,2.2079e-02 ,2.3740e-02 ,2.5501e-02 ,2.7219e-02 /)
      kao(:, 6, 2) = (/ &
     &1.6350e-02 ,1.7491e-02 ,1.8902e-02 ,2.0280e-02 ,2.1774e-02 /)
      kao(:, 7, 2) = (/ &
     &1.2732e-02 ,1.3953e-02 ,1.5005e-02 ,1.6145e-02 ,1.7323e-02 /)
      kao(:, 8, 2) = (/ &
     &9.7464e-03 ,1.1159e-02 ,1.2150e-02 ,1.2940e-02 ,1.3856e-02 /)
      kao(:, 9, 2) = (/ &
     &7.5337e-03 ,8.5370e-03 ,9.6841e-03 ,1.0825e-02 ,1.1894e-02 /)
      kao(:,10, 2) = (/ &
     &7.1476e-03 ,7.8468e-03 ,8.6104e-03 ,9.4234e-03 ,1.0165e-02 /)
      kao(:,11, 2) = (/ &
     &7.4726e-03 ,7.8619e-03 ,8.4110e-03 ,8.8097e-03 ,9.3621e-03 /)
      kao(:,12, 2) = (/ &
     &6.8212e-03 ,7.3104e-03 ,7.6521e-03 ,8.0570e-03 ,8.3782e-03 /)
      kao(:,13, 2) = (/ &
     &5.7626e-03 ,6.1115e-03 ,6.3578e-03 ,6.6833e-03 ,6.9834e-03 /)
      kao(:, 1, 3) = (/ &
     &9.2909e-02 ,9.6713e-02 ,9.9436e-02 ,1.0242e-01 ,1.0613e-01 /)
      kao(:, 2, 3) = (/ &
     &7.4548e-02 ,7.7785e-02 ,8.0363e-02 ,8.2840e-02 ,8.6028e-02 /)
      kao(:, 3, 3) = (/ &
     &5.8714e-02 ,6.1823e-02 ,6.4284e-02 ,6.6702e-02 ,6.9231e-02 /)
      kao(:, 4, 3) = (/ &
     &4.6349e-02 ,4.9440e-02 ,5.1743e-02 ,5.3890e-02 ,5.5994e-02 /)
      kao(:, 5, 3) = (/ &
     &3.6507e-02 ,3.9309e-02 ,4.1637e-02 ,4.3586e-02 ,4.5365e-02 /)
      kao(:, 6, 3) = (/ &
     &2.8427e-02 ,3.1177e-02 ,3.3328e-02 ,3.5180e-02 ,3.6733e-02 /)
      kao(:, 7, 3) = (/ &
     &2.2397e-02 ,2.4640e-02 ,2.6638e-02 ,2.8311e-02 ,2.9747e-02 /)
      kao(:, 8, 3) = (/ &
     &1.7861e-02 ,1.9252e-02 ,2.1033e-02 ,2.2648e-02 ,2.3985e-02 /)
      kao(:, 9, 3) = (/ &
     &1.4398e-02 ,1.5884e-02 ,1.6962e-02 ,1.7935e-02 ,1.8840e-02 /)
      kao(:,10, 3) = (/ &
     &1.3336e-02 ,1.5085e-02 ,1.6848e-02 ,1.8578e-02 ,1.9024e-02 /)
      kao(:,11, 3) = (/ &
     &1.0996e-02 ,1.2680e-02 ,1.4233e-02 ,1.6184e-02 ,1.7835e-02 /)
      kao(:,12, 3) = (/ &
     &9.6066e-03 ,1.0608e-02 ,1.2101e-02 ,1.3713e-02 ,1.5338e-02 /)
      kao(:,13, 3) = (/ &
     &8.0007e-03 ,8.9344e-03 ,1.0260e-02 ,1.1651e-02 ,1.2914e-02 /)
      kao(:, 1, 4) = (/ &
     &1.4098e-01 ,1.4735e-01 ,1.5390e-01 ,1.6007e-01 ,1.6623e-01 /)
      kao(:, 2, 4) = (/ &
     &1.1373e-01 ,1.1930e-01 ,1.2491e-01 ,1.3057e-01 ,1.3593e-01 /)
      kao(:, 3, 4) = (/ &
     &9.0856e-02 ,9.5503e-02 ,1.0012e-01 ,1.0479e-01 ,1.0971e-01 /)
      kao(:, 4, 4) = (/ &
     &7.2695e-02 ,7.6746e-02 ,8.0662e-02 ,8.4622e-02 ,8.8881e-02 /)
      kao(:, 5, 4) = (/ &
     &5.8402e-02 ,6.1962e-02 ,6.5265e-02 ,6.8694e-02 ,7.2371e-02 /)
      kao(:, 6, 4) = (/ &
     &4.7100e-02 ,5.0100e-02 ,5.2955e-02 ,5.5897e-02 ,5.9012e-02 /)
      kao(:, 7, 4) = (/ &
     &3.7714e-02 ,4.0303e-02 ,4.2858e-02 ,4.5396e-02 ,4.8032e-02 /)
      kao(:, 8, 4) = (/ &
     &2.9938e-02 ,3.2418e-02 ,3.4599e-02 ,3.6801e-02 ,3.9055e-02 /)
      kao(:, 9, 4) = (/ &
     &2.3570e-02 ,2.5475e-02 ,2.7580e-02 ,2.9598e-02 ,3.1549e-02 /)
      kao(:,10, 4) = (/ &
     &2.3291e-02 ,2.1658e-02 ,2.1418e-02 ,2.1490e-02 ,2.3536e-02 /)
      kao(:,11, 4) = (/ &
     &2.1808e-02 ,2.2150e-02 ,2.2833e-02 ,2.0354e-02 ,1.9688e-02 /)
      kao(:,12, 4) = (/ &
     &1.9246e-02 ,1.9438e-02 ,1.9839e-02 ,2.0164e-02 ,1.7716e-02 /)
      kao(:,13, 4) = (/ &
     &1.6236e-02 ,1.6164e-02 ,1.6551e-02 ,1.6579e-02 ,1.4849e-02 /)
      kao(:, 1, 5) = (/ &
     &2.5886e-01 ,2.7100e-01 ,2.8220e-01 ,2.9245e-01 ,3.0214e-01 /)
      kao(:, 2, 5) = (/ &
     &2.0909e-01 ,2.1918e-01 ,2.2861e-01 ,2.3740e-01 ,2.4610e-01 /)
      kao(:, 3, 5) = (/ &
     &1.6622e-01 ,1.7497e-01 ,1.8311e-01 ,1.9088e-01 ,1.9860e-01 /)
      kao(:, 4, 5) = (/ &
     &1.3301e-01 ,1.4069e-01 ,1.4792e-01 ,1.5478e-01 ,1.6132e-01 /)
      kao(:, 5, 5) = (/ &
     &1.0688e-01 ,1.1355e-01 ,1.1989e-01 ,1.2584e-01 ,1.3154e-01 /)
      kao(:, 6, 5) = (/ &
     &8.5419e-02 ,9.1274e-02 ,9.6848e-02 ,1.0202e-01 ,1.0704e-01 /)
      kao(:, 7, 5) = (/ &
     &6.8100e-02 ,7.3262e-02 ,7.8047e-02 ,8.2594e-02 ,8.7027e-02 /)
      kao(:, 8, 5) = (/ &
     &5.4252e-02 ,5.8815e-02 ,6.2989e-02 ,6.6937e-02 ,7.0783e-02 /)
      kao(:, 9, 5) = (/ &
     &4.3117e-02 ,4.7224e-02 ,5.0916e-02 ,5.4328e-02 ,5.7817e-02 /)
      kao(:,10, 5) = (/ &
     &2.9151e-02 ,3.5667e-02 ,4.0092e-02 ,4.3888e-02 ,4.6870e-02 /)
      kao(:,11, 5) = (/ &
     &2.3941e-02 ,2.7450e-02 ,2.9750e-02 ,3.5348e-02 ,3.9440e-02 /)
      kao(:,12, 5) = (/ &
     &2.0570e-02 ,2.3238e-02 ,2.5236e-02 ,2.7327e-02 ,3.2816e-02 /)
      kao(:,13, 5) = (/ &
     &1.7253e-02 ,1.9755e-02 ,2.1401e-02 ,2.3591e-02 ,2.8114e-02 /)
      kao(:, 1, 6) = (/ &
     &5.6993e-01 ,6.0360e-01 ,6.3489e-01 ,6.6230e-01 ,6.8659e-01 /)
      kao(:, 2, 6) = (/ &
     &4.6502e-01 ,4.9401e-01 ,5.2007e-01 ,5.4304e-01 ,5.6306e-01 /)
      kao(:, 3, 6) = (/ &
     &3.7271e-01 ,3.9757e-01 ,4.1967e-01 ,4.3927e-01 ,4.5631e-01 /)
      kao(:, 4, 6) = (/ &
     &2.9874e-01 ,3.1990e-01 ,3.3890e-01 ,3.5594e-01 ,3.7139e-01 /)
      kao(:, 5, 6) = (/ &
     &2.3859e-01 ,2.5711e-01 ,2.7375e-01 ,2.8893e-01 ,3.0280e-01 /)
      kao(:, 6, 6) = (/ &
     &1.8917e-01 ,2.0549e-01 ,2.2017e-01 ,2.3369e-01 ,2.4611e-01 /)
      kao(:, 7, 6) = (/ &
     &1.4938e-01 ,1.6367e-01 ,1.7681e-01 ,1.8887e-01 ,1.9989e-01 /)
      kao(:, 8, 6) = (/ &
     &1.1758e-01 ,1.3011e-01 ,1.4157e-01 ,1.5226e-01 ,1.6197e-01 /)
      kao(:, 9, 6) = (/ &
     &9.1609e-02 ,1.0230e-01 ,1.1226e-01 ,1.2154e-01 ,1.2990e-01 /)
      kao(:,10, 6) = (/ &
     &7.2629e-02 ,8.2527e-02 ,9.1786e-02 ,1.0065e-01 ,1.0832e-01 /)
      kao(:,11, 6) = (/ &
     &6.0173e-02 ,6.9095e-02 ,7.8339e-02 ,8.6340e-02 ,9.2996e-02 /)
      kao(:,12, 6) = (/ &
     &5.1074e-02 ,5.9514e-02 ,6.6969e-02 ,7.3447e-02 ,7.9277e-02 /)
      kao(:,13, 6) = (/ &
     &4.3826e-02 ,5.0848e-02 ,5.7125e-02 ,6.2916e-02 ,6.7915e-02 /)
      kao(:, 1, 7) = (/ &
     &1.4129e+00 ,1.4750e+00 ,1.5277e+00 ,1.5727e+00 ,1.6117e+00 /)
      kao(:, 2, 7) = (/ &
     &1.1749e+00 ,1.2287e+00 ,1.2750e+00 ,1.3159e+00 ,1.3523e+00 /)
      kao(:, 3, 7) = (/ &
     &9.5348e-01 ,1.0008e+00 ,1.0433e+00 ,1.0822e+00 ,1.1168e+00 /)
      kao(:, 4, 7) = (/ &
     &7.6995e-01 ,8.1381e-01 ,8.5421e-01 ,8.9012e-01 ,9.2111e-01 /)
      kao(:, 5, 7) = (/ &
     &6.2211e-01 ,6.6255e-01 ,6.9934e-01 ,7.3149e-01 ,7.5879e-01 /)
      kao(:, 6, 7) = (/ &
     &5.0056e-01 ,5.3742e-01 ,5.7038e-01 ,5.9882e-01 ,6.2305e-01 /)
      kao(:, 7, 7) = (/ &
     &4.0115e-01 ,4.3352e-01 ,4.6244e-01 ,4.8765e-01 ,5.0920e-01 /)
      kao(:, 8, 7) = (/ &
     &3.1902e-01 ,3.4754e-01 ,3.7305e-01 ,3.9544e-01 ,4.1482e-01 /)
      kao(:, 9, 7) = (/ &
     &2.5207e-01 ,2.7718e-01 ,2.9962e-01 ,3.1933e-01 ,3.3666e-01 /)
      kao(:,10, 7) = (/ &
     &1.9498e-01 ,2.1588e-01 ,2.3464e-01 ,2.5127e-01 ,2.6668e-01 /)
      kao(:,11, 7) = (/ &
     &1.6583e-01 ,1.8332e-01 ,1.9835e-01 ,2.1191e-01 ,2.2523e-01 /)
      kao(:,12, 7) = (/ &
     &1.3827e-01 ,1.5202e-01 ,1.6547e-01 ,1.7854e-01 ,1.8991e-01 /)
      kao(:,13, 7) = (/ &
     &1.1534e-01 ,1.2733e-01 ,1.3962e-01 ,1.4987e-01 ,1.6008e-01 /)
      kao(:, 1, 8) = (/ &
     &3.5920e+00 ,3.7800e+00 ,3.9524e+00 ,4.1109e+00 ,4.2529e+00 /)
      kao(:, 2, 8) = (/ &
     &3.2111e+00 ,3.3886e+00 ,3.5521e+00 ,3.6948e+00 ,3.8225e+00 /)
      kao(:, 3, 8) = (/ &
     &2.7787e+00 ,2.9477e+00 ,3.0955e+00 ,3.2271e+00 ,3.3442e+00 /)
      kao(:, 4, 8) = (/ &
     &2.3588e+00 ,2.5119e+00 ,2.6472e+00 ,2.7686e+00 ,2.8775e+00 /)
      kao(:, 5, 8) = (/ &
     &1.9705e+00 ,2.1082e+00 ,2.2326e+00 ,2.3452e+00 ,2.4470e+00 /)
      kao(:, 6, 8) = (/ &
     &1.6168e+00 ,1.7418e+00 ,1.8565e+00 ,1.9616e+00 ,2.0551e+00 /)
      kao(:, 7, 8) = (/ &
     &1.3089e+00 ,1.4235e+00 ,1.5288e+00 ,1.6233e+00 ,1.7079e+00 /)
      kao(:, 8, 8) = (/ &
     &1.0505e+00 ,1.1539e+00 ,1.2478e+00 ,1.3319e+00 ,1.4095e+00 /)
      kao(:, 9, 8) = (/ &
     &8.3583e-01 ,9.2738e-01 ,1.0101e+00 ,1.0861e+00 ,1.1567e+00 /)
      kao(:,10, 8) = (/ &
     &6.6552e-01 ,7.4516e-01 ,8.1795e-01 ,8.8505e-01 ,9.4596e-01 /)
      kao(:,11, 8) = (/ &
     &5.5048e-01 ,6.1499e-01 ,6.7571e-01 ,7.3145e-01 ,7.8064e-01 /)
      kao(:,12, 8) = (/ &
     &4.5804e-01 ,5.1260e-01 ,5.6222e-01 ,6.0624e-01 ,6.4709e-01 /)
      kao(:,13, 8) = (/ &
     &3.8513e-01 ,4.3049e-01 ,4.7109e-01 ,5.0795e-01 ,5.3980e-01 /)
      kao(:, 1, 9) = (/ &
     &1.0443e+01 ,1.1048e+01 ,1.1589e+01 ,1.2078e+01 ,1.2523e+01 /)
      kao(:, 2, 9) = (/ &
     &1.0305e+01 ,1.0938e+01 ,1.1513e+01 ,1.2045e+01 ,1.2531e+01 /)
      kao(:, 3, 9) = (/ &
     &9.8576e+00 ,1.0529e+01 ,1.1150e+01 ,1.1712e+01 ,1.2221e+01 /)
      kao(:, 4, 9) = (/ &
     &9.2371e+00 ,9.9233e+00 ,1.0551e+01 ,1.1124e+01 ,1.1647e+01 /)
      kao(:, 5, 9) = (/ &
     &8.4700e+00 ,9.1602e+00 ,9.7951e+00 ,1.0380e+01 ,1.0911e+01 /)
      kao(:, 6, 9) = (/ &
     &7.5880e+00 ,8.2763e+00 ,8.9154e+00 ,9.5007e+00 ,1.0024e+01 /)
      kao(:, 7, 9) = (/ &
     &6.6790e+00 ,7.3503e+00 ,7.9748e+00 ,8.5357e+00 ,9.0412e+00 /)
      kao(:, 8, 9) = (/ &
     &5.7712e+00 ,6.4120e+00 ,7.0009e+00 ,7.5325e+00 ,8.0088e+00 /)
      kao(:, 9, 9) = (/ &
     &4.8989e+00 ,5.4909e+00 ,6.0328e+00 ,6.5241e+00 ,6.9680e+00 /)
      kao(:,10, 9) = (/ &
     &4.1164e+00 ,4.6491e+00 ,5.1402e+00 ,5.5886e+00 ,6.0036e+00 /)
      kao(:,11, 9) = (/ &
     &3.6151e+00 ,4.0753e+00 ,4.5022e+00 ,4.8994e+00 ,5.2546e+00 /)
      kao(:,12, 9) = (/ &
     &3.1350e+00 ,3.5329e+00 ,3.9073e+00 ,4.2435e+00 ,4.5415e+00 /)
      kao(:,13, 9) = (/ &
     &2.6929e+00 ,3.0365e+00 ,3.3480e+00 ,3.6295e+00 ,3.8842e+00 /)
      kao(:, 1,10) = (/ &
     &1.9924e+01 ,2.0919e+01 ,2.2000e+01 ,2.2972e+01 ,2.3773e+01 /)
      kao(:, 2,10) = (/ &
     &2.0689e+01 ,2.1909e+01 ,2.3034e+01 ,2.3987e+01 ,2.4788e+01 /)
      kao(:, 3,10) = (/ &
     &2.0776e+01 ,2.2053e+01 ,2.3211e+01 ,2.4276e+01 ,2.5292e+01 /)
      kao(:, 4,10) = (/ &
     &2.0236e+01 ,2.1839e+01 ,2.3315e+01 ,2.4662e+01 ,2.5879e+01 /)
      kao(:, 5,10) = (/ &
     &1.9987e+01 ,2.1808e+01 ,2.3390e+01 ,2.4727e+01 ,2.5958e+01 /)
      kao(:, 6,10) = (/ &
     &1.9523e+01 ,2.1285e+01 ,2.2798e+01 ,2.4193e+01 ,2.5643e+01 /)
      kao(:, 7,10) = (/ &
     &1.8326e+01 ,2.0057e+01 ,2.1638e+01 ,2.3310e+01 ,2.4996e+01 /)
      kao(:, 8,10) = (/ &
     &1.6812e+01 ,1.8592e+01 ,2.0423e+01 ,2.2320e+01 ,2.4092e+01 /)
      kao(:, 9,10) = (/ &
     &1.5126e+01 ,1.7059e+01 ,1.9069e+01 ,2.1023e+01 ,2.2713e+01 /)
      kao(:,10,10) = (/ &
     &1.3603e+01 ,1.5643e+01 ,1.7659e+01 ,1.9476e+01 ,2.1017e+01 /)
      kao(:,11,10) = (/ &
     &1.3136e+01 ,1.5065e+01 ,1.6788e+01 ,1.8298e+01 ,1.9745e+01 /)
      kao(:,12,10) = (/ &
     &1.2291e+01 ,1.3925e+01 ,1.5389e+01 ,1.6819e+01 ,1.8254e+01 /)
      kao(:,13,10) = (/ &
     &1.1103e+01 ,1.2502e+01 ,1.3897e+01 ,1.5277e+01 ,1.6528e+01 /)
      kao(:, 1,11) = (/ &
     &2.4296e+01 ,2.5293e+01 ,2.6167e+01 ,2.7129e+01 ,2.8181e+01 /)
      kao(:, 2,11) = (/ &
     &2.5960e+01 ,2.7094e+01 ,2.8248e+01 ,2.9459e+01 ,3.0485e+01 /)
      kao(:, 3,11) = (/ &
     &2.6865e+01 ,2.8307e+01 ,2.9751e+01 ,3.1102e+01 ,3.2279e+01 /)
      kao(:, 4,11) = (/ &
     &2.7354e+01 ,2.8995e+01 ,3.0628e+01 ,3.2100e+01 ,3.3421e+01 /)
      kao(:, 5,11) = (/ &
     &2.6969e+01 ,2.8892e+01 ,3.0767e+01 ,3.2621e+01 ,3.4273e+01 /)
      kao(:, 6,11) = (/ &
     &2.6094e+01 ,2.8469e+01 ,3.0801e+01 ,3.2980e+01 ,3.4919e+01 /)
      kao(:, 7,11) = (/ &
     &2.5366e+01 ,2.8149e+01 ,3.0864e+01 ,3.3154e+01 ,3.5069e+01 /)
      kao(:, 8,11) = (/ &
     &2.4570e+01 ,2.7568e+01 ,3.0172e+01 ,3.2348e+01 ,3.4412e+01 /)
      kao(:, 9,11) = (/ &
     &2.3141e+01 ,2.6027e+01 ,2.8564e+01 ,3.0892e+01 ,3.3292e+01 /)
      kao(:,10,11) = (/ &
     &2.1375e+01 ,2.4163e+01 ,2.6748e+01 ,2.9381e+01 ,3.2113e+01 /)
      kao(:,11,11) = (/ &
     &2.0563e+01 ,2.3343e+01 ,2.6200e+01 ,2.9082e+01 ,3.1737e+01 /)
      kao(:,12,11) = (/ &
     &1.9759e+01 ,2.2669e+01 ,2.5592e+01 ,2.8225e+01 ,3.0484e+01 /)
      kao(:,13,11) = (/ &
     &1.9005e+01 ,2.1823e+01 ,2.4335e+01 ,2.6560e+01 ,2.8649e+01 /)
      kao(:, 1,12) = (/ &
     &2.8554e+01 ,3.0109e+01 ,3.1534e+01 ,3.2820e+01 ,3.3912e+01 /)
      kao(:, 2,12) = (/ &
     &3.1883e+01 ,3.3547e+01 ,3.5069e+01 ,3.6425e+01 ,3.7803e+01 /)
      kao(:, 3,12) = (/ &
     &3.5025e+01 ,3.6824e+01 ,3.8424e+01 ,3.9924e+01 ,4.1396e+01 /)
      kao(:, 4,12) = (/ &
     &3.7112e+01 ,3.9231e+01 ,4.1147e+01 ,4.2932e+01 ,4.4646e+01 /)
      kao(:, 5,12) = (/ &
     &3.8447e+01 ,4.0861e+01 ,4.3125e+01 ,4.5199e+01 ,4.7297e+01 /)
      kao(:, 6,12) = (/ &
     &3.8994e+01 ,4.1741e+01 ,4.4237e+01 ,4.6637e+01 ,4.8930e+01 /)
      kao(:, 7,12) = (/ &
     &3.8693e+01 ,4.1674e+01 ,4.4392e+01 ,4.7287e+01 ,5.0041e+01 /)
      kao(:, 8,12) = (/ &
     &3.7231e+01 ,4.0534e+01 ,4.3968e+01 ,4.7486e+01 ,5.0745e+01 /)
      kao(:, 9,12) = (/ &
     &3.5314e+01 ,3.9308e+01 ,4.3458e+01 ,4.7418e+01 ,5.1164e+01 /)
      kao(:,10,12) = (/ &
     &3.3674e+01 ,3.8340e+01 ,4.2937e+01 ,4.7301e+01 ,5.1085e+01 /)
      kao(:,11,12) = (/ &
     &3.4306e+01 ,3.9228e+01 ,4.3781e+01 ,4.7771e+01 ,5.1424e+01 /)
      kao(:,12,12) = (/ &
     &3.4432e+01 ,3.9064e+01 ,4.3274e+01 ,4.7292e+01 ,5.1289e+01 /)
      kao(:,13,12) = (/ &
     &3.3504e+01 ,3.7950e+01 ,4.2337e+01 ,4.6726e+01 ,5.1022e+01 /)
      kao(:, 1,13) = (/ &
     &3.3083e+01 ,3.5231e+01 ,3.7169e+01 ,3.8902e+01 ,4.0496e+01 /)
      kao(:, 2,13) = (/ &
     &3.7816e+01 ,4.0283e+01 ,4.2419e+01 ,4.4328e+01 ,4.6116e+01 /)
      kao(:, 3,13) = (/ &
     &4.2916e+01 ,4.5668e+01 ,4.8087e+01 ,5.0367e+01 ,5.2460e+01 /)
      kao(:, 4,13) = (/ &
     &4.7941e+01 ,5.0937e+01 ,5.3613e+01 ,5.6174e+01 ,5.8534e+01 /)
      kao(:, 5,13) = (/ &
     &5.2708e+01 ,5.6040e+01 ,5.9163e+01 ,6.2033e+01 ,6.4593e+01 /)
      kao(:, 6,13) = (/ &
     &5.6670e+01 ,6.0546e+01 ,6.4072e+01 ,6.7245e+01 ,7.0176e+01 /)
      kao(:, 7,13) = (/ &
     &5.9263e+01 ,6.3946e+01 ,6.8113e+01 ,7.1753e+01 ,7.5271e+01 /)
      kao(:, 8,13) = (/ &
     &6.0990e+01 ,6.6317e+01 ,7.1009e+01 ,7.5310e+01 ,7.9458e+01 /)
      kao(:, 9,13) = (/ &
     &6.1500e+01 ,6.7310e+01 ,7.2473e+01 ,7.7444e+01 ,8.1955e+01 /)
      kao(:,10,13) = (/ &
     &6.1095e+01 ,6.7188e+01 ,7.2950e+01 ,7.8366e+01 ,8.3528e+01 /)
      kao(:,11,13) = (/ &
     &6.2204e+01 ,6.8688e+01 ,7.5122e+01 ,8.1365e+01 ,8.7577e+01 /)
      kao(:,12,13) = (/ &
     &6.2610e+01 ,7.0078e+01 ,7.7313e+01 ,8.4495e+01 ,9.1274e+01 /)
      kao(:,13,13) = (/ &
     &6.3252e+01 ,7.1343e+01 ,7.9418e+01 ,8.6956e+01 ,9.3893e+01 /)
      kao(:, 1,14) = (/ &
     &4.3344e+01 ,4.5304e+01 ,4.7200e+01 ,4.8977e+01 ,5.0634e+01 /)
      kao(:, 2,14) = (/ &
     &4.8672e+01 ,5.1219e+01 ,5.3748e+01 ,5.6207e+01 ,5.8584e+01 /)
      kao(:, 3,14) = (/ &
     &5.3835e+01 ,5.7385e+01 ,6.0811e+01 ,6.4094e+01 ,6.7183e+01 /)
      kao(:, 4,14) = (/ &
     &5.9051e+01 ,6.3463e+01 ,6.7847e+01 ,7.2047e+01 ,7.6005e+01 /)
      kao(:, 5,14) = (/ &
     &6.4910e+01 ,7.0372e+01 ,7.5734e+01 ,8.0867e+01 ,8.5466e+01 /)
      kao(:, 6,14) = (/ &
     &7.1177e+01 ,7.7830e+01 ,8.4454e+01 ,9.0502e+01 ,9.5851e+01 /)
      kao(:, 7,14) = (/ &
     &7.8645e+01 ,8.6401e+01 ,9.3877e+01 ,1.0067e+02 ,1.0680e+02 /)
      kao(:, 8,14) = (/ &
     &8.6837e+01 ,9.5972e+01 ,1.0455e+02 ,1.1218e+02 ,1.1889e+02 /)
      kao(:, 9,14) = (/ &
     &9.4588e+01 ,1.0523e+02 ,1.1528e+02 ,1.2405e+02 ,1.3172e+02 /)
      kao(:,10,14) = (/ &
     &1.0185e+02 ,1.1428e+02 ,1.2585e+02 ,1.3577e+02 ,1.4474e+02 /)
      kao(:,11,14) = (/ &
     &1.1416e+02 ,1.2817e+02 ,1.4064e+02 ,1.5135e+02 ,1.6079e+02 /)
      kao(:,12,14) = (/ &
     &1.2658e+02 ,1.4157e+02 ,1.5496e+02 ,1.6630e+02 ,1.7621e+02 /)
      kao(:,13,14) = (/ &
     &1.3763e+02 ,1.5352e+02 ,1.6709e+02 ,1.7925e+02 ,1.9013e+02 /)
      kao(:, 1,15) = (/ &
     &5.4748e+01 ,5.6924e+01 ,5.8795e+01 ,6.0375e+01 ,6.1716e+01 /)
      kao(:, 2,15) = (/ &
     &6.5566e+01 ,6.8287e+01 ,7.0585e+01 ,7.2551e+01 ,7.4160e+01 /)
      kao(:, 3,15) = (/ &
     &7.7583e+01 ,8.1027e+01 ,8.3928e+01 ,8.6358e+01 ,8.8397e+01 /)
      kao(:, 4,15) = (/ &
     &8.9871e+01 ,9.4173e+01 ,9.7817e+01 ,1.0084e+02 ,1.0339e+02 /)
      kao(:, 5,15) = (/ &
     &1.0246e+02 ,1.0776e+02 ,1.1220e+02 ,1.1592e+02 ,1.1961e+02 /)
      kao(:, 6,15) = (/ &
     &1.1487e+02 ,1.2133e+02 ,1.2665e+02 ,1.3188e+02 ,1.3707e+02 /)
      kao(:, 7,15) = (/ &
     &1.2683e+02 ,1.3446e+02 ,1.4160e+02 ,1.4872e+02 ,1.5558e+02 /)
      kao(:, 8,15) = (/ &
     &1.3795e+02 ,1.4756e+02 ,1.5674e+02 ,1.6606e+02 ,1.7523e+02 /)
      kao(:, 9,15) = (/ &
     &1.4965e+02 ,1.6170e+02 ,1.7284e+02 ,1.8422e+02 ,1.9597e+02 /)
      kao(:,10,15) = (/ &
     &1.6376e+02 ,1.7796e+02 ,1.9116e+02 ,2.0528e+02 ,2.1939e+02 /)
      kao(:,11,15) = (/ &
     &1.8752e+02 ,2.0335e+02 ,2.1913e+02 ,2.3662e+02 ,2.5359e+02 /)
      kao(:,12,15) = (/ &
     &2.1430e+02 ,2.3299e+02 ,2.5241e+02 ,2.7277e+02 ,2.9286e+02 /)
      kao(:,13,15) = (/ &
     &2.4469e+02 ,2.6735e+02 ,2.9101e+02 ,3.1438e+02 ,3.3674e+02 /)
      kao(:, 1,16) = (/ &
     &5.6182e+01 ,5.8534e+01 ,6.0580e+01 ,6.2336e+01 ,6.3846e+01 /)
      kao(:, 2,16) = (/ &
     &6.7714e+01 ,7.1253e+01 ,7.3886e+01 ,7.6167e+01 ,7.8129e+01 /)
      kao(:, 3,16) = (/ &
     &8.2239e+01 ,8.6274e+01 ,8.9810e+01 ,9.2865e+01 ,9.5500e+01 /)
      kao(:, 4,16) = (/ &
     &9.7623e+01 ,1.0299e+02 ,1.0769e+02 ,1.1178e+02 ,1.1532e+02 /)
      kao(:, 5,16) = (/ &
     &1.1485e+02 ,1.2193e+02 ,1.2815e+02 ,1.3359e+02 ,1.3829e+02 /)
      kao(:, 6,16) = (/ &
     &1.3405e+02 ,1.4336e+02 ,1.5157e+02 ,1.5875e+02 ,1.6501e+02 /)
      kao(:, 7,16) = (/ &
     &1.5562e+02 ,1.6780e+02 ,1.7860e+02 ,1.8805e+02 ,1.9632e+02 /)
      kao(:, 8,16) = (/ &
     &1.7987e+02 ,1.9571e+02 ,2.0979e+02 ,2.2214e+02 ,2.3298e+02 /)
      kao(:, 9,16) = (/ &
     &2.0674e+02 ,2.2717e+02 ,2.4538e+02 ,2.6145e+02 ,2.7552e+02 /)
      kao(:,10,16) = (/ &
     &2.3822e+02 ,2.6423e+02 ,2.8739e+02 ,3.0794e+02 ,3.2592e+02 /)
      kao(:,11,16) = (/ &
     &2.8871e+02 ,3.1996e+02 ,3.4774e+02 ,3.7226e+02 ,3.9354e+02 /)
      kao(:,12,16) = (/ &
     &3.4916e+02 ,3.8637e+02 ,4.1932e+02 ,4.4825e+02 ,4.7321e+02 /)
      kao(:,13,16) = (/ &
     &4.2045e+02 ,4.6429e+02 ,5.0303e+02 ,5.3671e+02 ,5.6546e+02 /)

!     The array KBO contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels < ~100mb and temperatures. The first 
!     index in the array, JT, which runs from 1 to 5, corresponds to 
!     different temperatures.  More specifically, JT = 3 means that the 
!     data are for the reference temperature TREF for this pressure 
!     level, JT = 2 refers to the temperature TREF-15, JT = 1 is for
!     TREF-30, JT = 4 is for TREF+15, and JT = 5 is for TREF+30.  
!     The second index, JP, runs from 13 to 59 and refers to the JPth
!     reference pressure level (see taumol.f for the value of these
!     pressure levels in mb).  The third index, IG, goes from 1 to 16,
!     and tells us which g-interval the absorption coefficients are for.

      kbo(:,13, 1) = (/ &
     &2.1558e-03 ,2.5890e-03 ,2.9127e-03 ,3.2139e-03 ,3.5455e-03 /)
      kbo(:,14, 1) = (/ &
     &1.8304e-03 ,2.1809e-03 ,2.4298e-03 ,2.6878e-03 ,2.9625e-03 /)
      kbo(:,15, 1) = (/ &
     &1.5486e-03 ,1.7962e-03 ,2.0058e-03 ,2.2286e-03 ,2.4705e-03 /)
      kbo(:,16, 1) = (/ &
     &1.3025e-03 ,1.4833e-03 ,1.6606e-03 ,1.8503e-03 ,2.0485e-03 /)
      kbo(:,17, 1) = (/ &
     &1.0810e-03 ,1.2227e-03 ,1.3725e-03 ,1.5304e-03 ,1.6938e-03 /)
      kbo(:,18, 1) = (/ &
     &8.7942e-04 ,1.0015e-03 ,1.1266e-03 ,1.2596e-03 ,1.3951e-03 /)
      kbo(:,19, 1) = (/ &
     &7.2280e-04 ,8.2373e-04 ,9.2739e-04 ,1.0381e-03 ,1.1467e-03 /)
      kbo(:,20, 1) = (/ &
     &6.0184e-04 ,6.8491e-04 ,7.6954e-04 ,8.5989e-04 ,9.4913e-04 /)
      kbo(:,21, 1) = (/ &
     &5.0117e-04 ,5.6823e-04 ,6.3855e-04 ,7.1320e-04 ,7.8654e-04 /)
      kbo(:,22, 1) = (/ &
     &4.1938e-04 ,4.7543e-04 ,5.3375e-04 ,5.9543e-04 ,6.5571e-04 /)
      kbo(:,23, 1) = (/ &
     &3.5199e-04 ,3.9855e-04 ,4.4679e-04 ,4.9714e-04 ,5.4750e-04 /)
      kbo(:,24, 1) = (/ &
     &2.9639e-04 ,3.3452e-04 ,3.7432e-04 ,4.1615e-04 ,4.5706e-04 /)
      kbo(:,25, 1) = (/ &
     &2.4906e-04 ,2.8117e-04 ,3.1412e-04 ,3.4839e-04 ,3.7317e-04 /)
      kbo(:,26, 1) = (/ &
     &2.1029e-04 ,2.3678e-04 ,2.6421e-04 ,2.9238e-04 ,3.0575e-04 /)
      kbo(:,27, 1) = (/ &
     &1.7727e-04 ,1.9942e-04 ,2.2208e-04 ,2.4556e-04 ,2.5262e-04 /)
      kbo(:,28, 1) = (/ &
     &1.4969e-04 ,1.6790e-04 ,1.8692e-04 ,2.0183e-04 ,2.0915e-04 /)
      kbo(:,29, 1) = (/ &
     &1.2629e-04 ,1.4151e-04 ,1.5706e-04 ,1.6548e-04 ,1.7223e-04 /)
      kbo(:,30, 1) = (/ &
     &1.0651e-04 ,1.1909e-04 ,1.3186e-04 ,1.3639e-04 ,1.4198e-04 /)
      kbo(:,31, 1) = (/ &
     &8.9698e-05 ,1.0002e-04 ,1.0798e-04 ,1.1271e-04 ,1.1661e-04 /)
      kbo(:,32, 1) = (/ &
     &7.5536e-05 ,8.4037e-05 ,8.8553e-05 ,9.2337e-05 ,9.5468e-05 /)
      kbo(:,33, 1) = (/ &
     &6.3563e-05 ,7.0507e-05 ,7.3023e-05 ,7.6153e-05 ,7.8142e-05 /)
      kbo(:,34, 1) = (/ &
     &5.3365e-05 ,5.7820e-05 ,6.0490e-05 ,6.2653e-05 ,6.4307e-05 /)
      kbo(:,35, 1) = (/ &
     &4.4295e-05 ,4.7505e-05 ,4.9568e-05 ,5.1436e-05 ,5.2756e-05 /)
      kbo(:,36, 1) = (/ &
     &3.6359e-05 ,3.8955e-05 ,4.0612e-05 ,4.2071e-05 ,4.3157e-05 /)
      kbo(:,37, 1) = (/ &
     &2.9443e-05 ,3.1950e-05 ,3.3272e-05 ,3.4376e-05 ,3.5259e-05 /)
      kbo(:,38, 1) = (/ &
     &2.3815e-05 ,2.6274e-05 ,2.7165e-05 ,2.8049e-05 ,2.8811e-05 /)
      kbo(:,39, 1) = (/ &
     &1.9245e-05 ,2.1354e-05 ,2.2111e-05 ,2.2930e-05 ,2.3532e-05 /)
      kbo(:,40, 1) = (/ &
     &1.5405e-05 ,1.7147e-05 ,1.8049e-05 ,1.8756e-05 ,1.9282e-05 /)
      kbo(:,41, 1) = (/ &
     &1.2319e-05 ,1.3748e-05 ,1.4753e-05 ,1.5289e-05 ,1.5770e-05 /)
      kbo(:,42, 1) = (/ &
     &9.8357e-06 ,1.1012e-05 ,1.2183e-05 ,1.2499e-05 ,1.2877e-05 /)
      kbo(:,43, 1) = (/ &
     &7.7892e-06 ,8.7858e-06 ,9.7457e-06 ,1.0234e-05 ,1.0599e-05 /)
      kbo(:,44, 1) = (/ &
     &6.1605e-06 ,6.9805e-06 ,7.7675e-06 ,8.4197e-06 ,8.6950e-06 /)
      kbo(:,45, 1) = (/ &
     &4.8809e-06 ,5.5274e-06 ,6.1865e-06 ,6.8268e-06 ,7.0906e-06 /)
      kbo(:,46, 1) = (/ &
     &3.8470e-06 ,4.3665e-06 ,4.9029e-06 ,5.4349e-06 ,5.8089e-06 /)
      kbo(:,47, 1) = (/ &
     &3.0311e-06 ,3.4294e-06 ,3.8630e-06 ,4.3044e-06 ,4.7453e-06 /)
      kbo(:,48, 1) = (/ &
     &2.3694e-06 ,2.7049e-06 ,3.0473e-06 ,3.4008e-06 ,3.7674e-06 /)
      kbo(:,49, 1) = (/ &
     &1.8467e-06 ,2.1296e-06 ,2.4020e-06 ,2.6917e-06 ,2.9837e-06 /)
      kbo(:,50, 1) = (/ &
     &1.4542e-06 ,1.6765e-06 ,1.8996e-06 ,2.1320e-06 ,2.3692e-06 /)
      kbo(:,51, 1) = (/ &
     &1.1539e-06 ,1.3178e-06 ,1.5055e-06 ,1.6911e-06 ,1.8864e-06 /)
      kbo(:,52, 1) = (/ &
     &8.7493e-07 ,1.0411e-06 ,1.1898e-06 ,1.3435e-06 ,1.4983e-06 /)
      kbo(:,53, 1) = (/ &
     &6.6072e-07 ,8.3282e-07 ,9.4298e-07 ,1.0653e-06 ,1.1935e-06 /)
      kbo(:,54, 1) = (/ &
     &5.0251e-07 ,6.4316e-07 ,7.5237e-07 ,8.5108e-07 ,9.5630e-07 /)
      kbo(:,55, 1) = (/ &
     &3.8195e-07 ,4.9281e-07 ,6.0554e-07 ,6.8279e-07 ,7.6458e-07 /)
      kbo(:,56, 1) = (/ &
     &2.8943e-07 ,3.7779e-07 ,4.8048e-07 ,5.4688e-07 ,6.1650e-07 /)
      kbo(:,57, 1) = (/ &
     &2.1868e-07 ,2.8870e-07 ,3.7076e-07 ,4.4677e-07 ,4.9616e-07 /)
      kbo(:,58, 1) = (/ &
     &1.6598e-07 ,2.2133e-07 ,2.8693e-07 ,3.5995e-07 ,4.0195e-07 /)
      kbo(:,59, 1) = (/ &
     &1.3312e-07 ,1.7804e-07 ,2.3134e-07 ,2.9072e-07 ,3.3304e-07 /)
      kbo(:,13, 2) = (/ &
     &5.7626e-03 ,6.1115e-03 ,6.3578e-03 ,6.6833e-03 ,6.9834e-03 /)
      kbo(:,14, 2) = (/ &
     &4.7365e-03 ,4.9915e-03 ,5.2669e-03 ,5.5245e-03 ,5.7996e-03 /)
      kbo(:,15, 2) = (/ &
     &3.8570e-03 ,4.0469e-03 ,4.3101e-03 ,4.5195e-03 ,4.7607e-03 /)
      kbo(:,16, 2) = (/ &
     &3.0836e-03 ,3.2692e-03 ,3.4748e-03 ,3.6812e-03 ,3.8941e-03 /)
      kbo(:,17, 2) = (/ &
     &2.4665e-03 ,2.6482e-03 ,2.8018e-03 ,2.9854e-03 ,3.1785e-03 /)
      kbo(:,18, 2) = (/ &
     &1.9741e-03 ,2.1245e-03 ,2.2564e-03 ,2.4081e-03 ,2.5780e-03 /)
      kbo(:,19, 2) = (/ &
     &1.5958e-03 ,1.7126e-03 ,1.8351e-03 ,1.9560e-03 ,2.0570e-03 /)
      kbo(:,20, 2) = (/ &
     &1.3038e-03 ,1.3978e-03 ,1.5013e-03 ,1.6102e-03 ,1.6734e-03 /)
      kbo(:,21, 2) = (/ &
     &1.0706e-03 ,1.1492e-03 ,1.2352e-03 ,1.3269e-03 ,1.3755e-03 /)
      kbo(:,22, 2) = (/ &
     &8.8260e-04 ,9.4987e-04 ,1.0209e-03 ,1.0834e-03 ,1.1278e-03 /)
      kbo(:,23, 2) = (/ &
     &7.2583e-04 ,7.8218e-04 ,8.4637e-04 ,8.8814e-04 ,9.2896e-04 /)
      kbo(:,24, 2) = (/ &
     &6.0040e-04 ,6.4872e-04 ,7.0437e-04 ,7.3258e-04 ,7.6936e-04 /)
      kbo(:,25, 2) = (/ &
     &4.9798e-04 ,5.3936e-04 ,5.8024e-04 ,6.0451e-04 ,6.4613e-04 /)
      kbo(:,26, 2) = (/ &
     &4.1436e-04 ,4.5078e-04 ,4.7645e-04 ,5.0082e-04 ,5.4367e-04 /)
      kbo(:,27, 2) = (/ &
     &3.4567e-04 ,3.7682e-04 ,3.9546e-04 ,4.1621e-04 ,4.5625e-04 /)
      kbo(:,28, 2) = (/ &
     &2.8902e-04 ,3.1546e-04 ,3.2798e-04 ,3.5075e-04 ,3.8306e-04 /)
      kbo(:,29, 2) = (/ &
     &2.4193e-04 ,2.5865e-04 ,2.7208e-04 ,2.9507e-04 ,3.2156e-04 /)
      kbo(:,30, 2) = (/ &
     &2.0282e-04 ,2.1375e-04 ,2.2606e-04 ,2.4794e-04 ,2.6904e-04 /)
      kbo(:,31, 2) = (/ &
     &1.6986e-04 ,1.7726e-04 ,1.9036e-04 ,2.0754e-04 ,2.2529e-04 /)
      kbo(:,32, 2) = (/ &
     &1.3922e-04 ,1.4692e-04 ,1.5999e-04 ,1.7445e-04 ,1.8931e-04 /)
      kbo(:,33, 2) = (/ &
     &1.1520e-04 ,1.2220e-04 ,1.3453e-04 ,1.4590e-04 ,1.5875e-04 /)
      kbo(:,34, 2) = (/ &
     &9.5764e-05 ,1.0295e-04 ,1.1231e-04 ,1.2221e-04 ,1.3235e-04 /)
      kbo(:,35, 2) = (/ &
     &7.8951e-05 ,8.5467e-05 ,9.3381e-05 ,1.0154e-04 ,1.0962e-04 /)
      kbo(:,36, 2) = (/ &
     &6.4805e-05 ,7.0212e-05 ,7.6766e-05 ,8.3544e-05 ,9.0139e-05 /)
      kbo(:,37, 2) = (/ &
     &5.2918e-05 ,5.7064e-05 ,6.2426e-05 ,6.8102e-05 ,7.3562e-05 /)
      kbo(:,38, 2) = (/ &
     &4.3224e-05 ,4.6216e-05 ,5.0772e-05 ,5.5504e-05 ,6.0016e-05 /)
      kbo(:,39, 2) = (/ &
     &3.5291e-05 ,3.7592e-05 ,4.1355e-05 ,4.5145e-05 ,4.8932e-05 /)
      kbo(:,40, 2) = (/ &
     &2.8761e-05 ,3.0515e-05 ,3.3449e-05 ,3.6463e-05 ,3.9654e-05 /)
      kbo(:,41, 2) = (/ &
     &2.3487e-05 ,2.4801e-05 ,2.6922e-05 ,2.9459e-05 ,3.2147e-05 /)
      kbo(:,42, 2) = (/ &
     &1.9314e-05 ,2.0243e-05 ,2.1564e-05 ,2.3753e-05 ,2.5964e-05 /)
      kbo(:,43, 2) = (/ &
     &1.5553e-05 ,1.6470e-05 ,1.7479e-05 ,1.9035e-05 ,2.0784e-05 /)
      kbo(:,44, 2) = (/ &
     &1.2457e-05 ,1.3468e-05 ,1.4190e-05 ,1.5199e-05 ,1.6632e-05 /)
      kbo(:,45, 2) = (/ &
     &9.9734e-06 ,1.1008e-05 ,1.1581e-05 ,1.2254e-05 ,1.3346e-05 /)
      kbo(:,46, 2) = (/ &
     &7.9698e-06 ,8.8088e-06 ,9.4445e-06 ,9.9340e-06 ,1.0690e-05 /)
      kbo(:,47, 2) = (/ &
     &6.3565e-06 ,7.0249e-06 ,7.7396e-06 ,8.1033e-06 ,8.5527e-06 /)
      kbo(:,48, 2) = (/ &
     &5.1256e-06 ,5.5929e-06 ,6.1735e-06 ,6.6021e-06 ,6.9371e-06 /)
      kbo(:,49, 2) = (/ &
     &4.0784e-06 ,4.4718e-06 ,4.9212e-06 ,5.4190e-06 ,5.6740e-06 /)
      kbo(:,50, 2) = (/ &
     &3.3297e-06 ,3.6155e-06 ,3.9436e-06 ,4.3292e-06 ,4.6291e-06 /)
      kbo(:,51, 2) = (/ &
     &2.7486e-06 ,2.9107e-06 ,3.1698e-06 ,3.4767e-06 ,3.8139e-06 /)
      kbo(:,52, 2) = (/ &
     &2.2530e-06 ,2.4006e-06 ,2.5759e-06 ,2.7925e-06 ,3.0627e-06 /)
      kbo(:,53, 2) = (/ &
     &1.8678e-06 ,1.9765e-06 ,2.1052e-06 ,2.2503e-06 ,2.4591e-06 /)
      kbo(:,54, 2) = (/ &
     &1.5340e-06 ,1.6385e-06 ,1.7450e-06 ,1.8671e-06 ,1.9805e-06 /)
      kbo(:,55, 2) = (/ &
     &1.2873e-06 ,1.3532e-06 ,1.4432e-06 ,1.5328e-06 ,1.6236e-06 /)
      kbo(:,56, 2) = (/ &
     &1.0668e-06 ,1.1355e-06 ,1.1865e-06 ,1.2884e-06 ,1.3667e-06 /)
      kbo(:,57, 2) = (/ &
     &8.4592e-07 ,9.6149e-07 ,9.8845e-07 ,1.0536e-06 ,1.1286e-06 /)
      kbo(:,58, 2) = (/ &
     &6.5721e-07 ,8.0847e-07 ,8.4916e-07 ,8.7196e-07 ,9.4267e-07 /)
      kbo(:,59, 2) = (/ &
     &5.2809e-07 ,6.6890e-07 ,7.2431e-07 ,7.4028e-07 ,7.8416e-07 /)
      kbo(:,13, 3) = (/ &
     &8.0007e-03 ,8.9344e-03 ,1.0260e-02 ,1.1651e-02 ,1.2914e-02 /)
      kbo(:,14, 3) = (/ &
     &6.8039e-03 ,7.6829e-03 ,8.7921e-03 ,9.9141e-03 ,1.0757e-02 /)
      kbo(:,15, 3) = (/ &
     &5.7029e-03 ,6.5489e-03 ,7.4475e-03 ,8.3471e-03 ,8.8091e-03 /)
      kbo(:,16, 3) = (/ &
     &4.8074e-03 ,5.5085e-03 ,6.2455e-03 ,6.9353e-03 ,7.1997e-03 /)
      kbo(:,17, 3) = (/ &
     &4.0213e-03 ,4.6076e-03 ,5.2117e-03 ,5.6731e-03 ,5.8805e-03 /)
      kbo(:,18, 3) = (/ &
     &3.3461e-03 ,3.8362e-03 ,4.3242e-03 ,4.6154e-03 ,4.7757e-03 /)
      kbo(:,19, 3) = (/ &
     &2.7996e-03 ,3.2075e-03 ,3.5883e-03 ,3.7732e-03 ,3.8872e-03 /)
      kbo(:,20, 3) = (/ &
     &2.3589e-03 ,2.6931e-03 ,2.9843e-03 ,3.1004e-03 ,3.1743e-03 /)
      kbo(:,21, 3) = (/ &
     &1.9734e-03 ,2.2564e-03 ,2.4531e-03 ,2.5572e-03 ,2.5979e-03 /)
      kbo(:,22, 3) = (/ &
     &1.6777e-03 ,1.9014e-03 ,2.0201e-03 ,2.0877e-03 ,2.1290e-03 /)
      kbo(:,23, 3) = (/ &
     &1.4255e-03 ,1.6043e-03 ,1.6675e-03 ,1.7121e-03 ,1.7219e-03 /)
      kbo(:,24, 3) = (/ &
     &1.2066e-03 ,1.3233e-03 ,1.3782e-03 ,1.4109e-03 ,1.3842e-03 /)
      kbo(:,25, 3) = (/ &
     &1.0218e-03 ,1.0936e-03 ,1.1313e-03 ,1.1590e-03 ,1.1132e-03 /)
      kbo(:,26, 3) = (/ &
     &8.6686e-04 ,9.0770e-04 ,9.3474e-04 ,9.3738e-04 ,9.0394e-04 /)
      kbo(:,27, 3) = (/ &
     &7.2332e-04 ,7.5480e-04 ,7.7347e-04 ,7.5530e-04 ,7.3995e-04 /)
      kbo(:,28, 3) = (/ &
     &5.9945e-04 ,6.1747e-04 ,6.3797e-04 ,6.1191e-04 ,6.1018e-04 /)
      kbo(:,29, 3) = (/ &
     &4.9636e-04 ,5.1141e-04 ,5.1979e-04 ,4.9718e-04 ,5.0501e-04 /)
      kbo(:,30, 3) = (/ &
     &4.1287e-04 ,4.2400e-04 ,4.1392e-04 ,4.0737e-04 ,4.1659e-04 /)
      kbo(:,31, 3) = (/ &
     &3.3517e-04 ,3.4906e-04 ,3.3288e-04 ,3.3660e-04 ,3.4335e-04 /)
      kbo(:,32, 3) = (/ &
     &2.7784e-04 ,2.7984e-04 ,2.7143e-04 ,2.7785e-04 ,2.8417e-04 /)
      kbo(:,33, 3) = (/ &
     &2.3052e-04 ,2.2367e-04 ,2.2307e-04 ,2.2883e-04 ,2.3495e-04 /)
      kbo(:,34, 3) = (/ &
     &1.9073e-04 ,1.8192e-04 ,1.8515e-04 ,1.8942e-04 ,1.9507e-04 /)
      kbo(:,35, 3) = (/ &
     &1.5683e-04 ,1.4914e-04 ,1.5288e-04 ,1.5663e-04 ,1.6156e-04 /)
      kbo(:,36, 3) = (/ &
     &1.2835e-04 ,1.2262e-04 ,1.2564e-04 ,1.2896e-04 ,1.3319e-04 /)
      kbo(:,37, 3) = (/ &
     &1.0651e-04 ,1.0086e-04 ,1.0335e-04 ,1.0615e-04 ,1.0970e-04 /)
      kbo(:,38, 3) = (/ &
     &8.7372e-05 ,8.2916e-05 ,8.4948e-05 ,8.7192e-05 ,9.0174e-05 /)
      kbo(:,39, 3) = (/ &
     &7.1580e-05 ,6.8441e-05 ,6.9733e-05 ,7.1507e-05 ,7.4030e-05 /)
      kbo(:,40, 3) = (/ &
     &5.8422e-05 ,5.7750e-05 ,5.6983e-05 ,5.8663e-05 ,6.0682e-05 /)
      kbo(:,41, 3) = (/ &
     &4.7623e-05 ,4.8587e-05 ,4.6749e-05 ,4.8145e-05 ,4.9685e-05 /)
      kbo(:,42, 3) = (/ &
     &3.8729e-05 ,4.0813e-05 ,3.8776e-05 ,3.9518e-05 ,4.0826e-05 /)
      kbo(:,43, 3) = (/ &
     &3.2019e-05 ,3.3273e-05 ,3.2653e-05 ,3.2753e-05 ,3.3527e-05 /)
      kbo(:,44, 3) = (/ &
     &2.6412e-05 ,2.7141e-05 ,2.7698e-05 ,2.6940e-05 ,2.7582e-05 /)
      kbo(:,45, 3) = (/ &
     &2.1266e-05 ,2.2156e-05 ,2.3306e-05 ,2.2397e-05 ,2.2801e-05 /)
      kbo(:,46, 3) = (/ &
     &1.7333e-05 ,1.8301e-05 ,1.8885e-05 ,1.9036e-05 ,1.8747e-05 /)
      kbo(:,47, 3) = (/ &
     &1.4070e-05 ,1.4972e-05 ,1.5353e-05 ,1.6172e-05 ,1.5451e-05 /)
      kbo(:,48, 3) = (/ &
     &1.0908e-05 ,1.2143e-05 ,1.2701e-05 ,1.3131e-05 ,1.3135e-05 /)
      kbo(:,49, 3) = (/ &
     &8.5257e-06 ,9.9029e-06 ,1.0615e-05 ,1.0623e-05 ,1.1229e-05 /)
      kbo(:,50, 3) = (/ &
     &6.5831e-06 ,7.8068e-06 ,8.5689e-06 ,8.8823e-06 ,9.1397e-06 /)
      kbo(:,51, 3) = (/ &
     &5.0124e-06 ,6.1123e-06 ,6.9735e-06 ,7.5152e-06 ,7.4209e-06 /)
      kbo(:,52, 3) = (/ &
     &3.8557e-06 ,4.7153e-06 ,5.6513e-06 ,6.0740e-06 ,6.2588e-06 /)
      kbo(:,53, 3) = (/ &
     &2.9713e-06 ,3.6139e-06 ,4.3749e-06 ,4.9165e-06 ,5.3050e-06 /)
      kbo(:,54, 3) = (/ &
     &2.2856e-06 ,2.7967e-06 ,3.4018e-06 ,4.0149e-06 ,4.3280e-06 /)
      kbo(:,55, 3) = (/ &
     &1.7432e-06 ,2.1952e-06 ,2.6416e-06 ,3.2063e-06 ,3.5207e-06 /)
      kbo(:,56, 3) = (/ &
     &1.3460e-06 ,1.6981e-06 ,2.0681e-06 ,2.4690e-06 ,2.8558e-06 /)
      kbo(:,57, 3) = (/ &
     &1.0794e-06 ,1.2900e-06 ,1.6260e-06 ,1.9447e-06 ,2.3391e-06 /)
      kbo(:,58, 3) = (/ &
     &9.2042e-07 ,9.9682e-07 ,1.2594e-06 ,1.5341e-06 ,1.8245e-06 /)
      kbo(:,59, 3) = (/ &
     &7.5487e-07 ,8.2111e-07 ,1.0075e-06 ,1.2341e-06 ,1.4799e-06 /)
      kbo(:,13, 4) = (/ &
     &1.6236e-02 ,1.6164e-02 ,1.6551e-02 ,1.6579e-02 ,1.4849e-02 /)
      kbo(:,14, 4) = (/ &
     &1.3333e-02 ,1.3358e-02 ,1.3723e-02 ,1.3164e-02 ,1.2310e-02 /)
      kbo(:,15, 4) = (/ &
     &1.0791e-02 ,1.1005e-02 ,1.1347e-02 ,1.0262e-02 ,1.0198e-02 /)
      kbo(:,16, 4) = (/ &
     &8.7740e-03 ,9.0551e-03 ,8.8988e-03 ,8.1326e-03 ,8.4246e-03 /)
      kbo(:,17, 4) = (/ &
     &7.1855e-03 ,7.4271e-03 ,6.8507e-03 ,6.6124e-03 ,6.9447e-03 /)
      kbo(:,18, 4) = (/ &
     &5.8832e-03 ,5.8794e-03 ,5.3061e-03 ,5.4156e-03 ,5.7271e-03 /)
      kbo(:,19, 4) = (/ &
     &4.7612e-03 ,4.5173e-03 ,4.2495e-03 ,4.4758e-03 ,4.7797e-03 /)
      kbo(:,20, 4) = (/ &
     &3.8929e-03 ,3.5371e-03 ,3.4837e-03 ,3.7081e-03 ,4.0335e-03 /)
      kbo(:,21, 4) = (/ &
     &3.1210e-03 ,2.8158e-03 ,2.9040e-03 ,3.0717e-03 ,3.3855e-03 /)
      kbo(:,22, 4) = (/ &
     &2.4122e-03 ,2.2915e-03 ,2.4348e-03 ,2.6102e-03 ,2.8568e-03 /)
      kbo(:,23, 4) = (/ &
     &1.8931e-03 ,1.8847e-03 ,2.0226e-03 ,2.2045e-03 ,2.4293e-03 /)
      kbo(:,24, 4) = (/ &
     &1.5231e-03 ,1.5878e-03 ,1.6899e-03 ,1.8552e-03 ,2.0775e-03 /)
      kbo(:,25, 4) = (/ &
     &1.2458e-03 ,1.3309e-03 ,1.4317e-03 ,1.5678e-03 ,1.7779e-03 /)
      kbo(:,26, 4) = (/ &
     &1.0318e-03 ,1.1118e-03 ,1.2146e-03 ,1.3449e-03 ,1.5065e-03 /)
      kbo(:,27, 4) = (/ &
     &8.6665e-04 ,9.3057e-04 ,1.0235e-03 ,1.1557e-03 ,1.2745e-03 /)
      kbo(:,28, 4) = (/ &
     &7.2935e-04 ,7.9123e-04 ,8.6656e-04 ,9.8388e-04 ,1.0757e-03 /)
      kbo(:,29, 4) = (/ &
     &6.1286e-04 ,6.7240e-04 ,7.4124e-04 ,8.3872e-04 ,9.0911e-04 /)
      kbo(:,30, 4) = (/ &
     &5.1400e-04 ,5.6684e-04 ,6.4255e-04 ,7.1220e-04 ,7.7258e-04 /)
      kbo(:,31, 4) = (/ &
     &4.4005e-04 ,4.8076e-04 ,5.5017e-04 ,6.0255e-04 ,6.5647e-04 /)
      kbo(:,32, 4) = (/ &
     &3.7263e-04 ,4.1679e-04 ,4.6901e-04 ,5.1118e-04 ,5.5709e-04 /)
      kbo(:,33, 4) = (/ &
     &3.1452e-04 ,3.5853e-04 ,3.9810e-04 ,4.3526e-04 ,4.7464e-04 /)
      kbo(:,34, 4) = (/ &
     &2.6538e-04 ,3.0537e-04 ,3.3607e-04 ,3.6889e-04 ,4.0236e-04 /)
      kbo(:,35, 4) = (/ &
     &2.2314e-04 ,2.5674e-04 ,2.8212e-04 ,3.1017e-04 ,3.3804e-04 /)
      kbo(:,36, 4) = (/ &
     &1.8558e-04 ,2.1307e-04 ,2.3484e-04 ,2.5807e-04 ,2.8146e-04 /)
      kbo(:,37, 4) = (/ &
     &1.5092e-04 ,1.7515e-04 ,1.9371e-04 ,2.1363e-04 ,2.3312e-04 /)
      kbo(:,38, 4) = (/ &
     &1.2396e-04 ,1.4379e-04 ,1.5969e-04 ,1.7662e-04 ,1.9284e-04 /)
      kbo(:,39, 4) = (/ &
     &1.0157e-04 ,1.1773e-04 ,1.3175e-04 ,1.4587e-04 ,1.5934e-04 /)
      kbo(:,40, 4) = (/ &
     &8.2605e-05 ,9.4273e-05 ,1.0813e-04 ,1.1977e-04 ,1.3107e-04 /)
      kbo(:,41, 4) = (/ &
     &6.6939e-05 ,7.5416e-05 ,8.8332e-05 ,9.8121e-05 ,1.0774e-04 /)
      kbo(:,42, 4) = (/ &
     &5.4049e-05 ,6.0030e-05 ,7.1511e-05 ,8.0199e-05 ,8.8261e-05 /)
      kbo(:,43, 4) = (/ &
     &4.3092e-05 ,4.8470e-05 ,5.6902e-05 ,6.4800e-05 ,7.1905e-05 /)
      kbo(:,44, 4) = (/ &
     &3.4303e-05 ,3.8888e-05 ,4.4709e-05 ,5.2317e-05 ,5.8294e-05 /)
      kbo(:,45, 4) = (/ &
     &2.7706e-05 ,3.1192e-05 ,3.5138e-05 ,4.1880e-05 ,4.7037e-05 /)
      kbo(:,46, 4) = (/ &
     &2.2020e-05 ,2.4816e-05 ,2.8235e-05 ,3.2847e-05 ,3.7855e-05 /)
      kbo(:,47, 4) = (/ &
     &1.7397e-05 ,1.9571e-05 ,2.2339e-05 ,2.5403e-05 ,3.0154e-05 /)
      kbo(:,48, 4) = (/ &
     &1.4464e-05 ,1.5535e-05 ,1.7628e-05 ,2.0160e-05 ,2.3523e-05 /)
      kbo(:,49, 4) = (/ &
     &1.2203e-05 ,1.2334e-05 ,1.3809e-05 ,1.5955e-05 ,1.8189e-05 /)
      kbo(:,50, 4) = (/ &
     &1.0868e-05 ,1.0166e-05 ,1.1038e-05 ,1.2542e-05 ,1.4482e-05 /)
      kbo(:,51, 4) = (/ &
     &9.5445e-06 ,8.4914e-06 ,8.8728e-06 ,9.7788e-06 ,1.1531e-05 /)
      kbo(:,52, 4) = (/ &
     &7.6675e-06 ,7.5593e-06 ,7.1200e-06 ,7.9511e-06 ,9.0030e-06 /)
      kbo(:,53, 4) = (/ &
     &6.1578e-06 ,6.8621e-06 ,5.9549e-06 ,6.4007e-06 ,7.0103e-06 /)
      kbo(:,54, 4) = (/ &
     &4.9970e-06 ,5.5372e-06 ,5.2950e-06 ,5.1133e-06 ,5.6754e-06 /)
      kbo(:,55, 4) = (/ &
     &4.1058e-06 ,4.4463e-06 ,4.8381e-06 ,4.2110e-06 ,4.6398e-06 /)
      kbo(:,56, 4) = (/ &
     &3.3825e-06 ,3.6285e-06 ,4.0286e-06 ,3.7391e-06 ,3.7193e-06 /)
      kbo(:,57, 4) = (/ &
     &2.7087e-06 ,2.9631e-06 ,3.2500e-06 ,3.4185e-06 ,3.0256e-06 /)
      kbo(:,58, 4) = (/ &
     &2.0759e-06 ,2.4918e-06 ,2.6378e-06 ,2.9253e-06 ,2.6729e-06 /)
      kbo(:,59, 4) = (/ &
     &1.6942e-06 ,2.0927e-06 ,2.1992e-06 ,2.4373e-06 ,2.3395e-06 /)
      kbo(:,13, 5) = (/ &
     &1.7253e-02 ,1.9755e-02 ,2.1401e-02 ,2.3591e-02 ,2.8114e-02 /)
      kbo(:,14, 5) = (/ &
     &1.4836e-02 ,1.6934e-02 ,1.8341e-02 ,2.1005e-02 ,2.4456e-02 /)
      kbo(:,15, 5) = (/ &
     &1.2786e-02 ,1.4254e-02 ,1.5589e-02 ,1.8700e-02 ,2.1272e-02 /)
      kbo(:,16, 5) = (/ &
     &1.0892e-02 ,1.2056e-02 ,1.3761e-02 ,1.6336e-02 ,1.8224e-02 /)
      kbo(:,17, 5) = (/ &
     &9.1405e-03 ,1.0167e-02 ,1.2171e-02 ,1.4009e-02 ,1.5426e-02 /)
      kbo(:,18, 5) = (/ &
     &7.6420e-03 ,8.7762e-03 ,1.0582e-02 ,1.1875e-02 ,1.2969e-02 /)
      kbo(:,19, 5) = (/ &
     &6.4312e-03 ,7.6685e-03 ,8.9635e-03 ,9.9226e-03 ,1.0844e-02 /)
      kbo(:,20, 5) = (/ &
     &5.4039e-03 ,6.6521e-03 ,7.5702e-03 ,8.3653e-03 ,9.0934e-03 /)
      kbo(:,21, 5) = (/ &
     &4.6584e-03 ,5.7137e-03 ,6.4063e-03 ,7.0462e-03 ,7.6384e-03 /)
      kbo(:,22, 5) = (/ &
     &4.1485e-03 ,4.9033e-03 ,5.4200e-03 ,5.9610e-03 ,6.4648e-03 /)
      kbo(:,23, 5) = (/ &
     &3.6403e-03 ,4.1705e-03 ,4.6055e-03 ,5.0423e-03 ,5.4667e-03 /)
      kbo(:,24, 5) = (/ &
     &3.1466e-03 ,3.5285e-03 ,3.8988e-03 ,4.2642e-03 ,4.6134e-03 /)
      kbo(:,25, 5) = (/ &
     &2.6968e-03 ,2.9919e-03 ,3.3029e-03 ,3.6014e-03 ,3.8905e-03 /)
      kbo(:,26, 5) = (/ &
     &2.2919e-03 ,2.5427e-03 ,2.7966e-03 ,3.0460e-03 ,3.3030e-03 /)
      kbo(:,27, 5) = (/ &
     &1.9487e-03 ,2.1617e-03 ,2.3708e-03 ,2.5760e-03 ,2.8001e-03 /)
      kbo(:,28, 5) = (/ &
     &1.6604e-03 ,1.8339e-03 ,2.0064e-03 ,2.1858e-03 ,2.3683e-03 /)
      kbo(:,29, 5) = (/ &
     &1.4167e-03 ,1.5573e-03 ,1.7005e-03 ,1.8546e-03 ,2.0015e-03 /)
      kbo(:,30, 5) = (/ &
     &1.2043e-03 ,1.3228e-03 ,1.4435e-03 ,1.5699e-03 ,1.6896e-03 /)
      kbo(:,31, 5) = (/ &
     &1.0225e-03 ,1.1229e-03 ,1.2273e-03 ,1.3283e-03 ,1.4296e-03 /)
      kbo(:,32, 5) = (/ &
     &8.6992e-04 ,9.5293e-04 ,1.0416e-03 ,1.1243e-03 ,1.2104e-03 /)
      kbo(:,33, 5) = (/ &
     &7.3968e-04 ,8.1278e-04 ,8.8420e-04 ,9.5333e-04 ,1.0276e-03 /)
      kbo(:,34, 5) = (/ &
     &6.2724e-04 ,6.8945e-04 ,7.4802e-04 ,8.0740e-04 ,8.7396e-04 /)
      kbo(:,35, 5) = (/ &
     &5.2729e-04 ,5.7995e-04 ,6.2910e-04 ,6.7983e-04 ,7.3853e-04 /)
      kbo(:,36, 5) = (/ &
     &4.3895e-04 ,4.8339e-04 ,5.2479e-04 ,5.6936e-04 ,6.1891e-04 /)
      kbo(:,37, 5) = (/ &
     &3.6323e-04 ,4.0071e-04 ,4.3613e-04 ,4.7458e-04 ,5.1673e-04 /)
      kbo(:,38, 5) = (/ &
     &3.0001e-04 ,3.3215e-04 ,3.6263e-04 ,3.9587e-04 ,4.3165e-04 /)
      kbo(:,39, 5) = (/ &
     &2.4808e-04 ,2.7543e-04 ,3.0133e-04 ,3.3050e-04 ,3.6200e-04 /)
      kbo(:,40, 5) = (/ &
     &2.0392e-04 ,2.2766e-04 ,2.5038e-04 ,2.7569e-04 ,3.0329e-04 /)
      kbo(:,41, 5) = (/ &
     &1.6718e-04 ,1.8754e-04 ,2.0771e-04 ,2.3036e-04 ,2.5452e-04 /)
      kbo(:,42, 5) = (/ &
     &1.3676e-04 ,1.5432e-04 ,1.7210e-04 ,1.9216e-04 ,2.1391e-04 /)
      kbo(:,43, 5) = (/ &
     &1.1103e-04 ,1.2612e-04 ,1.4186e-04 ,1.5938e-04 ,1.7898e-04 /)
      kbo(:,44, 5) = (/ &
     &8.9549e-05 ,1.0259e-04 ,1.1643e-04 ,1.3169e-04 ,1.4912e-04 /)
      kbo(:,45, 5) = (/ &
     &7.2088e-05 ,8.3098e-05 ,9.5307e-05 ,1.0860e-04 ,1.2373e-04 /)
      kbo(:,46, 5) = (/ &
     &5.7589e-05 ,6.6833e-05 ,7.7497e-05 ,8.9096e-05 ,1.0212e-04 /)
      kbo(:,47, 5) = (/ &
     &4.5404e-05 ,5.3366e-05 ,6.2424e-05 ,7.2413e-05 ,8.3476e-05 /)
      kbo(:,48, 5) = (/ &
     &3.5296e-05 ,4.2388e-05 ,4.9972e-05 ,5.8618e-05 ,6.7991e-05 /)
      kbo(:,49, 5) = (/ &
     &2.7057e-05 ,3.3322e-05 ,3.9733e-05 ,4.7217e-05 ,5.5093e-05 /)
      kbo(:,50, 5) = (/ &
     &2.0028e-05 ,2.6063e-05 ,3.1674e-05 ,3.7934e-05 ,4.4693e-05 /)
      kbo(:,51, 5) = (/ &
     &1.4762e-05 ,2.0261e-05 ,2.5067e-05 ,3.0345e-05 ,3.6144e-05 /)
      kbo(:,52, 5) = (/ &
     &1.1471e-05 ,1.5106e-05 ,1.9721e-05 ,2.4107e-05 ,2.9127e-05 /)
      kbo(:,53, 5) = (/ &
     &8.8078e-06 ,1.0927e-05 ,1.5370e-05 ,1.9101e-05 ,2.3328e-05 /)
      kbo(:,54, 5) = (/ &
     &6.7922e-06 ,8.5333e-06 ,1.1608e-05 ,1.5114e-05 ,1.8676e-05 /)
      kbo(:,55, 5) = (/ &
     &5.2087e-06 ,6.6736e-06 ,8.5401e-06 ,1.1909e-05 ,1.4884e-05 /)
      kbo(:,56, 5) = (/ &
     &3.9778e-06 ,5.1458e-06 ,6.5614e-06 ,9.1281e-06 ,1.1849e-05 /)
      kbo(:,57, 5) = (/ &
     &3.4293e-06 ,3.9957e-06 ,5.1202e-06 ,6.7753e-06 ,9.3431e-06 /)
      kbo(:,58, 5) = (/ &
     &3.0812e-06 ,3.0418e-06 ,3.9938e-06 ,5.1720e-06 ,7.2446e-06 /)
      kbo(:,59, 5) = (/ &
     &2.6710e-06 ,2.4462e-06 ,3.2530e-06 ,4.2384e-06 ,5.8592e-06 /)
      kbo(:,13, 6) = (/ &
     &4.3826e-02 ,5.0848e-02 ,5.7125e-02 ,6.2916e-02 ,6.7915e-02 /)
      kbo(:,14, 6) = (/ &
     &3.8242e-02 ,4.3851e-02 ,4.9242e-02 ,5.3907e-02 ,5.8385e-02 /)
      kbo(:,15, 6) = (/ &
     &3.3170e-02 ,3.7873e-02 ,4.2212e-02 ,4.6203e-02 ,5.0021e-02 /)
      kbo(:,16, 6) = (/ &
     &2.8430e-02 ,3.2381e-02 ,3.6071e-02 ,3.9408e-02 ,4.2554e-02 /)
      kbo(:,17, 6) = (/ &
     &2.4252e-02 ,2.7453e-02 ,3.0545e-02 ,3.3265e-02 ,3.5923e-02 /)
      kbo(:,18, 6) = (/ &
     &2.0461e-02 ,2.3166e-02 ,2.5616e-02 ,2.7856e-02 ,3.0048e-02 /)
      kbo(:,19, 6) = (/ &
     &1.7273e-02 ,1.9462e-02 ,2.1473e-02 ,2.3367e-02 ,2.5163e-02 /)
      kbo(:,20, 6) = (/ &
     &1.4713e-02 ,1.6450e-02 ,1.8126e-02 ,1.9702e-02 ,2.1262e-02 /)
      kbo(:,21, 6) = (/ &
     &1.2468e-02 ,1.3887e-02 ,1.5268e-02 ,1.6611e-02 ,1.7949e-02 /)
      kbo(:,22, 6) = (/ &
     &1.0608e-02 ,1.1782e-02 ,1.2961e-02 ,1.4100e-02 ,1.5205e-02 /)
      kbo(:,23, 6) = (/ &
     &8.9996e-03 ,9.9872e-03 ,1.1001e-02 ,1.1992e-02 ,1.2875e-02 /)
      kbo(:,24, 6) = (/ &
     &7.6639e-03 ,8.5225e-03 ,9.3703e-03 ,1.0166e-02 ,1.0905e-02 /)
      kbo(:,25, 6) = (/ &
     &6.5402e-03 ,7.2570e-03 ,7.9762e-03 ,8.6328e-03 ,9.2482e-03 /)
      kbo(:,26, 6) = (/ &
     &5.5998e-03 ,6.2109e-03 ,6.7992e-03 ,7.3298e-03 ,7.8244e-03 /)
      kbo(:,27, 6) = (/ &
     &4.7932e-03 ,5.3061e-03 ,5.7794e-03 ,6.2257e-03 ,6.6438e-03 /)
      kbo(:,28, 6) = (/ &
     &4.0951e-03 ,4.5312e-03 ,4.9233e-03 ,5.2892e-03 ,5.6437e-03 /)
      kbo(:,29, 6) = (/ &
     &3.5062e-03 ,3.8638e-03 ,4.1941e-03 ,4.4995e-03 ,4.7944e-03 /)
      kbo(:,30, 6) = (/ &
     &2.9997e-03 ,3.2915e-03 ,3.5642e-03 ,3.8238e-03 ,4.0827e-03 /)
      kbo(:,31, 6) = (/ &
     &2.5609e-03 ,2.8021e-03 ,3.0278e-03 ,3.2471e-03 ,3.4700e-03 /)
      kbo(:,32, 6) = (/ &
     &2.1838e-03 ,2.3823e-03 ,2.5746e-03 ,2.7615e-03 ,2.9515e-03 /)
      kbo(:,33, 6) = (/ &
     &1.8610e-03 ,2.0261e-03 ,2.1868e-03 ,2.3490e-03 ,2.5125e-03 /)
      kbo(:,34, 6) = (/ &
     &1.5812e-03 ,1.7190e-03 ,1.8561e-03 ,1.9953e-03 ,2.1347e-03 /)
      kbo(:,35, 6) = (/ &
     &1.3323e-03 ,1.4487e-03 ,1.5664e-03 ,1.6864e-03 ,1.8025e-03 /)
      kbo(:,36, 6) = (/ &
     &1.1120e-03 ,1.2101e-03 ,1.3111e-03 ,1.4134e-03 ,1.5124e-03 /)
      kbo(:,37, 6) = (/ &
     &9.2067e-04 ,1.0045e-03 ,1.0903e-03 ,1.1790e-03 ,1.2650e-03 /)
      kbo(:,38, 6) = (/ &
     &7.6186e-04 ,8.3301e-04 ,9.0690e-04 ,9.8204e-04 ,1.0582e-03 /)
      kbo(:,39, 6) = (/ &
     &6.3121e-04 ,6.9074e-04 ,7.5442e-04 ,8.1836e-04 ,8.8377e-04 /)
      kbo(:,40, 6) = (/ &
     &5.2096e-04 ,5.7198e-04 ,6.2426e-04 ,6.7904e-04 ,7.3548e-04 /)
      kbo(:,41, 6) = (/ &
     &4.2992e-04 ,4.7365e-04 ,5.1846e-04 ,5.6371e-04 ,6.1228e-04 /)
      kbo(:,42, 6) = (/ &
     &3.5500e-04 ,3.9262e-04 ,4.3159e-04 ,4.7009e-04 ,5.1120e-04 /)
      kbo(:,43, 6) = (/ &
     &2.9285e-04 ,3.2562e-04 ,3.5900e-04 ,3.9210e-04 ,4.2694e-04 /)
      kbo(:,44, 6) = (/ &
     &2.4061e-04 ,2.6923e-04 ,2.9805e-04 ,3.2732e-04 ,3.5760e-04 /)
      kbo(:,45, 6) = (/ &
     &1.9754e-04 ,2.2270e-04 ,2.4799e-04 ,2.7345e-04 ,3.0033e-04 /)
      kbo(:,46, 6) = (/ &
     &1.6118e-04 ,1.8331e-04 ,2.0573e-04 ,2.2834e-04 ,2.5255e-04 /)
      kbo(:,47, 6) = (/ &
     &1.3001e-04 ,1.4919e-04 ,1.6905e-04 ,1.8953e-04 ,2.1172e-04 /)
      kbo(:,48, 6) = (/ &
     &1.0430e-04 ,1.2103e-04 ,1.3853e-04 ,1.5665e-04 ,1.7689e-04 /)
      kbo(:,49, 6) = (/ &
     &8.3158e-05 ,9.7679e-05 ,1.1288e-04 ,1.2898e-04 ,1.4689e-04 /)
      kbo(:,50, 6) = (/ &
     &6.6182e-05 ,7.8799e-05 ,9.1873e-05 ,1.0601e-04 ,1.2184e-04 /)
      kbo(:,51, 6) = (/ &
     &5.2460e-05 ,6.3349e-05 ,7.4559e-05 ,8.7033e-05 ,1.0081e-04 /)
      kbo(:,52, 6) = (/ &
     &4.1391e-05 ,5.0671e-05 ,6.0237e-05 ,7.1015e-05 ,8.3290e-05 /)
      kbo(:,53, 6) = (/ &
     &3.2451e-05 ,4.0299e-05 ,4.8474e-05 ,5.7732e-05 ,6.8499e-05 /)
      kbo(:,54, 6) = (/ &
     &2.5414e-05 ,3.2075e-05 ,3.9061e-05 ,4.7059e-05 ,5.6458e-05 /)
      kbo(:,55, 6) = (/ &
     &1.9791e-05 ,2.5430e-05 ,3.1447e-05 ,3.8320e-05 ,4.6433e-05 /)
      kbo(:,56, 6) = (/ &
     &1.5282e-05 ,2.0059e-05 ,2.5203e-05 ,3.1033e-05 ,3.8063e-05 /)
      kbo(:,57, 6) = (/ &
     &1.1377e-05 ,1.5690e-05 ,2.0076e-05 ,2.5035e-05 ,3.1091e-05 /)
      kbo(:,58, 6) = (/ &
     &8.3098e-06 ,1.2203e-05 ,1.5952e-05 ,2.0176e-05 ,2.5366e-05 /)
      kbo(:,59, 6) = (/ &
     &6.5651e-06 ,9.9766e-06 ,1.3186e-05 ,1.6915e-05 ,2.1496e-05 /)
      kbo(:,13, 7) = (/ &
     &1.1534e-01 ,1.2733e-01 ,1.3962e-01 ,1.4987e-01 ,1.6008e-01 /)
      kbo(:,14, 7) = (/ &
     &9.8557e-02 ,1.0921e-01 ,1.1846e-01 ,1.2756e-01 ,1.3545e-01 /)
      kbo(:,15, 7) = (/ &
     &8.4816e-02 ,9.3361e-02 ,1.0130e-01 ,1.0828e-01 ,1.1452e-01 /)
      kbo(:,16, 7) = (/ &
     &7.2792e-02 ,7.9992e-02 ,8.6025e-02 ,9.1745e-02 ,9.7220e-02 /)
      kbo(:,17, 7) = (/ &
     &6.2250e-02 ,6.8145e-02 ,7.3215e-02 ,7.8161e-02 ,8.2912e-02 /)
      kbo(:,18, 7) = (/ &
     &5.2897e-02 ,5.7617e-02 ,6.2131e-02 ,6.6296e-02 ,7.0468e-02 /)
      kbo(:,19, 7) = (/ &
     &4.4630e-02 ,4.8620e-02 ,5.2395e-02 ,5.5983e-02 ,5.9561e-02 /)
      kbo(:,20, 7) = (/ &
     &3.7638e-02 ,4.1018e-02 ,4.4192e-02 ,4.7348e-02 ,5.0426e-02 /)
      kbo(:,21, 7) = (/ &
     &3.1712e-02 ,3.4570e-02 ,3.7337e-02 ,4.0055e-02 ,4.2699e-02 /)
      kbo(:,22, 7) = (/ &
     &2.6951e-02 ,2.9361e-02 ,3.1724e-02 ,3.4058e-02 ,3.6337e-02 /)
      kbo(:,23, 7) = (/ &
     &2.2985e-02 ,2.5005e-02 ,2.7002e-02 ,2.8884e-02 ,3.0844e-02 /)
      kbo(:,24, 7) = (/ &
     &1.9564e-02 ,2.1275e-02 ,2.2950e-02 ,2.4579e-02 ,2.6269e-02 /)
      kbo(:,25, 7) = (/ &
     &1.6678e-02 ,1.8134e-02 ,1.9557e-02 ,2.0984e-02 ,2.2448e-02 /)
      kbo(:,26, 7) = (/ &
     &1.4215e-02 ,1.5478e-02 ,1.6731e-02 ,1.8053e-02 ,1.9409e-02 /)
      kbo(:,27, 7) = (/ &
     &1.2146e-02 ,1.3259e-02 ,1.4401e-02 ,1.5542e-02 ,1.6732e-02 /)
      kbo(:,28, 7) = (/ &
     &1.0451e-02 ,1.1387e-02 ,1.2366e-02 ,1.3378e-02 ,1.4403e-02 /)
      kbo(:,29, 7) = (/ &
     &8.9638e-03 ,9.7824e-03 ,1.0625e-02 ,1.1522e-02 ,1.2402e-02 /)
      kbo(:,30, 7) = (/ &
     &7.7059e-03 ,8.4110e-03 ,9.1535e-03 ,9.9173e-03 ,1.0684e-02 /)
      kbo(:,31, 7) = (/ &
     &6.6159e-03 ,7.2344e-03 ,7.8777e-03 ,8.5358e-03 ,9.2030e-03 /)
      kbo(:,32, 7) = (/ &
     &5.6925e-03 ,6.2370e-03 ,6.7880e-03 ,7.3601e-03 ,7.9298e-03 /)
      kbo(:,33, 7) = (/ &
     &4.9047e-03 ,5.3755e-03 ,5.8574e-03 ,6.3478e-03 ,6.8444e-03 /)
      kbo(:,34, 7) = (/ &
     &4.2261e-03 ,4.6310e-03 ,5.0504e-03 ,5.4765e-03 ,5.9065e-03 /)
      kbo(:,35, 7) = (/ &
     &3.6014e-03 ,3.9541e-03 ,4.3177e-03 ,4.6806e-03 ,5.0649e-03 /)
      kbo(:,36, 7) = (/ &
     &3.0405e-03 ,3.3438e-03 ,3.6573e-03 ,3.9714e-03 ,4.3136e-03 /)
      kbo(:,37, 7) = (/ &
     &2.5476e-03 ,2.8157e-03 ,3.0872e-03 ,3.3632e-03 ,3.6681e-03 /)
      kbo(:,38, 7) = (/ &
     &2.1334e-03 ,2.3678e-03 ,2.6052e-03 ,2.8532e-03 ,3.1134e-03 /)
      kbo(:,39, 7) = (/ &
     &1.7845e-03 ,1.9869e-03 ,2.1996e-03 ,2.4178e-03 ,2.6484e-03 /)
      kbo(:,40, 7) = (/ &
     &1.4840e-03 ,1.6609e-03 ,1.8504e-03 ,2.0474e-03 ,2.2560e-03 /)
      kbo(:,41, 7) = (/ &
     &1.2344e-03 ,1.3898e-03 ,1.5559e-03 ,1.7345e-03 ,1.9234e-03 /)
      kbo(:,42, 7) = (/ &
     &1.0314e-03 ,1.1653e-03 ,1.3107e-03 ,1.4669e-03 ,1.6353e-03 /)
      kbo(:,43, 7) = (/ &
     &8.5631e-04 ,9.7409e-04 ,1.1003e-03 ,1.2355e-03 ,1.3860e-03 /)
      kbo(:,44, 7) = (/ &
     &7.0883e-04 ,8.1303e-04 ,9.2536e-04 ,1.0435e-03 ,1.1739e-03 /)
      kbo(:,45, 7) = (/ &
     &5.8732e-04 ,6.7556e-04 ,7.7384e-04 ,8.8025e-04 ,9.9590e-04 /)
      kbo(:,46, 7) = (/ &
     &4.8484e-04 ,5.6171e-04 ,6.4432e-04 ,7.3847e-04 ,8.4169e-04 /)
      kbo(:,47, 7) = (/ &
     &3.9752e-04 ,4.6412e-04 ,5.3807e-04 ,6.1858e-04 ,7.0821e-04 /)
      kbo(:,48, 7) = (/ &
     &3.2593e-04 ,3.8380e-04 ,4.4885e-04 ,5.1997e-04 ,5.9487e-04 /)
      kbo(:,49, 7) = (/ &
     &2.6581e-04 ,3.1620e-04 ,3.7509e-04 ,4.3658e-04 ,5.0219e-04 /)
      kbo(:,50, 7) = (/ &
     &2.1682e-04 ,2.6203e-04 ,3.1361e-04 ,3.6786e-04 ,4.2524e-04 /)
      kbo(:,51, 7) = (/ &
     &1.7696e-04 ,2.1726e-04 ,2.6292e-04 ,3.1080e-04 ,3.6141e-04 /)
      kbo(:,52, 7) = (/ &
     &1.4350e-04 ,1.8000e-04 ,2.2008e-04 ,2.6275e-04 ,3.0811e-04 /)
      kbo(:,53, 7) = (/ &
     &1.1566e-04 ,1.4775e-04 ,1.8326e-04 ,2.2179e-04 ,2.6354e-04 /)
      kbo(:,54, 7) = (/ &
     &9.3174e-05 ,1.2130e-04 ,1.5287e-04 ,1.8794e-04 ,2.2723e-04 /)
      kbo(:,55, 7) = (/ &
     &7.4812e-05 ,9.9351e-05 ,1.2721e-04 ,1.5976e-04 ,1.9539e-04 /)
      kbo(:,56, 7) = (/ &
     &5.9751e-05 ,8.0907e-05 ,1.0532e-04 ,1.3503e-04 ,1.6719e-04 /)
      kbo(:,57, 7) = (/ &
     &4.7338e-05 ,6.5345e-05 ,8.6815e-05 ,1.1307e-04 ,1.4234e-04 /)
      kbo(:,58, 7) = (/ &
     &3.7388e-05 ,5.2674e-05 ,7.1720e-05 ,9.4757e-05 ,1.2118e-04 /)
      kbo(:,59, 7) = (/ &
     &3.1368e-05 ,4.4899e-05 ,6.2069e-05 ,8.2754e-05 ,1.0682e-04 /)
      kbo(:,13, 8) = (/ &
     &3.8513e-01 ,4.3049e-01 ,4.7109e-01 ,5.0795e-01 ,5.3980e-01 /)
      kbo(:,14, 8) = (/ &
     &3.2769e-01 ,3.6398e-01 ,3.9786e-01 ,4.2776e-01 ,4.5444e-01 /)
      kbo(:,15, 8) = (/ &
     &2.7898e-01 ,3.0981e-01 ,3.3796e-01 ,3.6334e-01 ,3.8812e-01 /)
      kbo(:,16, 8) = (/ &
     &2.3683e-01 ,2.6231e-01 ,2.8577e-01 ,3.0755e-01 ,3.2800e-01 /)
      kbo(:,17, 8) = (/ &
     &2.0036e-01 ,2.2125e-01 ,2.4047e-01 ,2.5907e-01 ,2.7604e-01 /)
      kbo(:,18, 8) = (/ &
     &1.7015e-01 ,1.8726e-01 ,2.0338e-01 ,2.1873e-01 ,2.3341e-01 /)
      kbo(:,19, 8) = (/ &
     &1.4494e-01 ,1.5899e-01 ,1.7245e-01 ,1.8542e-01 ,1.9788e-01 /)
      kbo(:,20, 8) = (/ &
     &1.2385e-01 ,1.3588e-01 ,1.4742e-01 ,1.5823e-01 ,1.6882e-01 /)
      kbo(:,21, 8) = (/ &
     &1.0654e-01 ,1.1655e-01 ,1.2609e-01 ,1.3545e-01 ,1.4408e-01 /)
      kbo(:,22, 8) = (/ &
     &9.1991e-02 ,1.0041e-01 ,1.0849e-01 ,1.1626e-01 ,1.2371e-01 /)
      kbo(:,23, 8) = (/ &
     &7.9046e-02 ,8.6400e-02 ,9.3327e-02 ,9.9889e-02 ,1.0642e-01 /)
      kbo(:,24, 8) = (/ &
     &6.8021e-02 ,7.4328e-02 ,8.0300e-02 ,8.6084e-02 ,9.1544e-02 /)
      kbo(:,25, 8) = (/ &
     &5.8516e-02 ,6.3854e-02 ,6.9101e-02 ,7.4075e-02 ,7.8861e-02 /)
      kbo(:,26, 8) = (/ &
     &5.0443e-02 ,5.5091e-02 ,5.9525e-02 ,6.3760e-02 ,6.7833e-02 /)
      kbo(:,27, 8) = (/ &
     &4.3538e-02 ,4.7477e-02 ,5.1180e-02 ,5.4850e-02 ,5.8530e-02 /)
      kbo(:,28, 8) = (/ &
     &3.7617e-02 ,4.0916e-02 ,4.4139e-02 ,4.7301e-02 ,5.0513e-02 /)
      kbo(:,29, 8) = (/ &
     &3.2546e-02 ,3.5342e-02 ,3.8069e-02 ,4.0845e-02 ,4.3756e-02 /)
      kbo(:,30, 8) = (/ &
     &2.8067e-02 ,3.0536e-02 ,3.2922e-02 ,3.5388e-02 ,3.8072e-02 /)
      kbo(:,31, 8) = (/ &
     &2.4245e-02 ,2.6387e-02 ,2.8550e-02 ,3.0769e-02 ,3.3007e-02 /)
      kbo(:,32, 8) = (/ &
     &2.1010e-02 ,2.2870e-02 ,2.4839e-02 ,2.6760e-02 ,2.8725e-02 /)
      kbo(:,33, 8) = (/ &
     &1.8247e-02 ,1.9921e-02 ,2.1633e-02 ,2.3376e-02 ,2.5089e-02 /)
      kbo(:,34, 8) = (/ &
     &1.5899e-02 ,1.7453e-02 ,1.8953e-02 ,2.0489e-02 ,2.2006e-02 /)
      kbo(:,35, 8) = (/ &
     &1.3799e-02 ,1.5171e-02 ,1.6500e-02 ,1.7816e-02 ,1.9222e-02 /)
      kbo(:,36, 8) = (/ &
     &1.1856e-02 ,1.3040e-02 ,1.4223e-02 ,1.5409e-02 ,1.6675e-02 /)
      kbo(:,37, 8) = (/ &
     &1.0122e-02 ,1.1172e-02 ,1.2227e-02 ,1.3320e-02 ,1.4426e-02 /)
      kbo(:,38, 8) = (/ &
     &8.6297e-03 ,9.5720e-03 ,1.0548e-02 ,1.1499e-02 ,1.2504e-02 /)
      kbo(:,39, 8) = (/ &
     &7.3583e-03 ,8.2086e-03 ,9.0807e-03 ,9.9445e-03 ,1.0852e-02 /)
      kbo(:,40, 8) = (/ &
     &6.2575e-03 ,7.0294e-03 ,7.8131e-03 ,8.5974e-03 ,9.4311e-03 /)
      kbo(:,41, 8) = (/ &
     &5.3221e-03 ,6.0117e-03 ,6.7242e-03 ,7.4367e-03 ,8.2130e-03 /)
      kbo(:,42, 8) = (/ &
     &4.5217e-03 ,5.1291e-03 ,5.7774e-03 ,6.4411e-03 ,7.1607e-03 /)
      kbo(:,43, 8) = (/ &
     &3.8118e-03 ,4.3626e-03 ,4.9535e-03 ,5.5702e-03 ,6.2186e-03 /)
      kbo(:,44, 8) = (/ &
     &3.1928e-03 ,3.7055e-03 ,4.2384e-03 ,4.7956e-03 ,5.3949e-03 /)
      kbo(:,45, 8) = (/ &
     &2.6724e-03 ,3.1345e-03 ,3.6292e-03 ,4.1408e-03 ,4.6835e-03 /)
      kbo(:,46, 8) = (/ &
     &2.2327e-03 ,2.6446e-03 ,3.0956e-03 ,3.5684e-03 ,4.0653e-03 /)
      kbo(:,47, 8) = (/ &
     &1.8490e-03 ,2.2161e-03 ,2.6105e-03 ,3.0391e-03 ,3.5058e-03 /)
      kbo(:,48, 8) = (/ &
     &1.5271e-03 ,1.8513e-03 ,2.2029e-03 ,2.5798e-03 ,3.0175e-03 /)
      kbo(:,49, 8) = (/ &
     &1.2568e-03 ,1.5444e-03 ,1.8551e-03 ,2.1969e-03 ,2.5931e-03 /)
      kbo(:,50, 8) = (/ &
     &1.0411e-03 ,1.2920e-03 ,1.5680e-03 ,1.8789e-03 ,2.2434e-03 /)
      kbo(:,51, 8) = (/ &
     &8.6157e-04 ,1.0792e-03 ,1.3252e-03 ,1.6044e-03 ,1.9374e-03 /)
      kbo(:,52, 8) = (/ &
     &7.1345e-04 ,8.9803e-04 ,1.1146e-03 ,1.3696e-03 ,1.6714e-03 /)
      kbo(:,53, 8) = (/ &
     &5.9120e-04 ,7.4871e-04 ,9.4040e-04 ,1.1662e-03 ,1.4395e-03 /)
      kbo(:,54, 8) = (/ &
     &4.9248e-04 ,6.3323e-04 ,7.9771e-04 ,9.9957e-04 ,1.2405e-03 /)
      kbo(:,55, 8) = (/ &
     &4.1065e-04 ,5.3488e-04 ,6.8225e-04 ,8.6108e-04 ,1.0736e-03 /)
      kbo(:,56, 8) = (/ &
     &3.4182e-04 ,4.5283e-04 ,5.8716e-04 ,7.4149e-04 ,9.3761e-04 /)
      kbo(:,57, 8) = (/ &
     &2.8276e-04 ,3.8428e-04 ,5.0468e-04 ,6.4575e-04 ,8.2300e-04 /)
      kbo(:,58, 8) = (/ &
     &2.3443e-04 ,3.2611e-04 ,4.3528e-04 ,5.6896e-04 ,7.2980e-04 /)
      kbo(:,59, 8) = (/ &
     &2.0666e-04 ,2.9266e-04 ,3.9707e-04 ,5.2680e-04 ,6.7824e-04 /)
      kbo(:,13, 9) = (/ &
     &2.6929e+00 ,3.0365e+00 ,3.3480e+00 ,3.6295e+00 ,3.8842e+00 /)
      kbo(:,14, 9) = (/ &
     &2.3218e+00 ,2.6065e+00 ,2.8670e+00 ,3.1040e+00 ,3.3162e+00 /)
      kbo(:,15, 9) = (/ &
     &1.9883e+00 ,2.2252e+00 ,2.4424e+00 ,2.6373e+00 ,2.8081e+00 /)
      kbo(:,16, 9) = (/ &
     &1.6988e+00 ,1.8964e+00 ,2.0747e+00 ,2.2343e+00 ,2.3791e+00 /)
      kbo(:,17, 9) = (/ &
     &1.4495e+00 ,1.6116e+00 ,1.7595e+00 ,1.8933e+00 ,2.0138e+00 /)
      kbo(:,18, 9) = (/ &
     &1.2318e+00 ,1.3662e+00 ,1.4893e+00 ,1.6003e+00 ,1.6980e+00 /)
      kbo(:,19, 9) = (/ &
     &1.0432e+00 ,1.1554e+00 ,1.2571e+00 ,1.3476e+00 ,1.4284e+00 /)
      kbo(:,20, 9) = (/ &
     &8.8399e-01 ,9.7584e-01 ,1.0583e+00 ,1.1327e+00 ,1.2000e+00 /)
      kbo(:,21, 9) = (/ &
     &7.4719e-01 ,8.2246e-01 ,8.9025e-01 ,9.5182e-01 ,1.0085e+00 /)
      kbo(:,22, 9) = (/ &
     &6.3607e-01 ,6.9712e-01 ,7.5292e-01 ,8.0394e-01 ,8.5135e-01 /)
      kbo(:,23, 9) = (/ &
     &5.4262e-01 ,5.9143e-01 ,6.3738e-01 ,6.8008e-01 ,7.1995e-01 /)
      kbo(:,24, 9) = (/ &
     &4.6285e-01 ,5.0331e-01 ,5.4067e-01 ,5.7573e-01 ,6.1046e-01 /)
      kbo(:,25, 9) = (/ &
     &3.9562e-01 ,4.2919e-01 ,4.6040e-01 ,4.9042e-01 ,5.1991e-01 /)
      kbo(:,26, 9) = (/ &
     &3.4017e-01 ,3.6788e-01 ,3.9442e-01 ,4.2037e-01 ,4.4731e-01 /)
      kbo(:,27, 9) = (/ &
     &2.9399e-01 ,3.1651e-01 ,3.3903e-01 ,3.6222e-01 ,3.8618e-01 /)
      kbo(:,28, 9) = (/ &
     &2.5435e-01 ,2.7396e-01 ,2.9328e-01 ,3.1366e-01 ,3.3524e-01 /)
      kbo(:,29, 9) = (/ &
     &2.2098e-01 ,2.3815e-01 ,2.5600e-01 ,2.7395e-01 ,2.9332e-01 /)
      kbo(:,30, 9) = (/ &
     &1.9332e-01 ,2.0838e-01 ,2.2416e-01 ,2.4057e-01 ,2.5735e-01 /)
      kbo(:,31, 9) = (/ &
     &1.6991e-01 ,1.8327e-01 ,1.9737e-01 ,2.1207e-01 ,2.2734e-01 /)
      kbo(:,32, 9) = (/ &
     &1.4986e-01 ,1.6194e-01 ,1.7445e-01 ,1.8782e-01 ,2.0152e-01 /)
      kbo(:,33, 9) = (/ &
     &1.3279e-01 ,1.4378e-01 ,1.5504e-01 ,1.6697e-01 ,1.7955e-01 /)
      kbo(:,34, 9) = (/ &
     &1.1789e-01 ,1.2771e-01 ,1.3816e-01 ,1.4885e-01 ,1.6033e-01 /)
      kbo(:,35, 9) = (/ &
     &1.0423e-01 ,1.1314e-01 ,1.2268e-01 ,1.3249e-01 ,1.4303e-01 /)
      kbo(:,36, 9) = (/ &
     &9.1569e-02 ,9.9843e-02 ,1.0848e-01 ,1.1752e-01 ,1.2715e-01 /)
      kbo(:,37, 9) = (/ &
     &7.9654e-02 ,8.7324e-02 ,9.5396e-02 ,1.0365e-01 ,1.1217e-01 /)
      kbo(:,38, 9) = (/ &
     &6.9582e-02 ,7.6500e-02 ,8.3939e-02 ,9.1706e-02 ,9.9308e-02 /)
      kbo(:,39, 9) = (/ &
     &6.0817e-02 ,6.7147e-02 ,7.4089e-02 ,8.1389e-02 ,8.8469e-02 /)
      kbo(:,40, 9) = (/ &
     &5.2895e-02 ,5.8816e-02 ,6.5088e-02 ,7.1837e-02 ,7.8761e-02 /)
      kbo(:,41, 9) = (/ &
     &4.5994e-02 ,5.1507e-02 ,5.7306e-02 ,6.3493e-02 ,7.0017e-02 /)
      kbo(:,42, 9) = (/ &
     &3.9933e-02 ,4.5126e-02 ,5.0659e-02 ,5.6440e-02 ,6.2355e-02 /)
      kbo(:,43, 9) = (/ &
     &3.4407e-02 ,3.9333e-02 ,4.4505e-02 ,5.0025e-02 ,5.5477e-02 /)
      kbo(:,44, 9) = (/ &
     &2.9641e-02 ,3.4179e-02 ,3.9085e-02 ,4.4243e-02 ,4.9585e-02 /)
      kbo(:,45, 9) = (/ &
     &2.5534e-02 ,2.9717e-02 ,3.4321e-02 ,3.9331e-02 ,4.4385e-02 /)
      kbo(:,46, 9) = (/ &
     &2.1943e-02 ,2.5772e-02 ,3.0011e-02 ,3.4665e-02 ,3.9677e-02 /)
      kbo(:,47, 9) = (/ &
     &1.8799e-02 ,2.2299e-02 ,2.6155e-02 ,3.0452e-02 ,3.5108e-02 /)
      kbo(:,48, 9) = (/ &
     &1.6134e-02 ,1.9292e-02 ,2.2898e-02 ,2.6798e-02 ,3.1152e-02 /)
      kbo(:,49, 9) = (/ &
     &1.3799e-02 ,1.6693e-02 ,1.9932e-02 ,2.3629e-02 ,2.7686e-02 /)
      kbo(:,50, 9) = (/ &
     &1.1807e-02 ,1.4439e-02 ,1.7455e-02 ,2.0914e-02 ,2.4717e-02 /)
      kbo(:,51, 9) = (/ &
     &1.0105e-02 ,1.2520e-02 ,1.5304e-02 ,1.8588e-02 ,2.2129e-02 /)
      kbo(:,52, 9) = (/ &
     &8.6629e-03 ,1.0849e-02 ,1.3445e-02 ,1.6444e-02 ,1.9913e-02 /)
      kbo(:,53, 9) = (/ &
     &7.4874e-03 ,9.4257e-03 ,1.1801e-02 ,1.4610e-02 ,1.7870e-02 /)
      kbo(:,54, 9) = (/ &
     &6.4970e-03 ,8.2758e-03 ,1.0456e-02 ,1.3093e-02 ,1.6122e-02 /)
      kbo(:,55, 9) = (/ &
     &5.6140e-03 ,7.3217e-03 ,9.3276e-03 ,1.1747e-02 ,1.4696e-02 /)
      kbo(:,56, 9) = (/ &
     &4.8349e-03 ,6.4792e-03 ,8.3317e-03 ,1.0602e-02 ,1.3343e-02 /)
      kbo(:,57, 9) = (/ &
     &4.1640e-03 ,5.6963e-03 ,7.4736e-03 ,9.6066e-03 ,1.2192e-02 /)
      kbo(:,58, 9) = (/ &
     &3.5901e-03 ,5.0045e-03 ,6.7274e-03 ,8.7656e-03 ,1.1231e-02 /)
      kbo(:,59, 9) = (/ &
     &3.3029e-03 ,4.6798e-03 ,6.3469e-03 ,8.3368e-03 ,1.0817e-02 /)
      kbo(:,13,10) = (/ &
     &1.1103e+01 ,1.2502e+01 ,1.3897e+01 ,1.5277e+01 ,1.6528e+01 /)
      kbo(:,14,10) = (/ &
     &9.9415e+00 ,1.1260e+01 ,1.2546e+01 ,1.3697e+01 ,1.4756e+01 /)
      kbo(:,15,10) = (/ &
     &8.8808e+00 ,1.0035e+01 ,1.1086e+01 ,1.2088e+01 ,1.3034e+01 /)
      kbo(:,16,10) = (/ &
     &7.8211e+00 ,8.7752e+00 ,9.7015e+00 ,1.0578e+01 ,1.1354e+01 /)
      kbo(:,17,10) = (/ &
     &6.7833e+00 ,7.6204e+00 ,8.4176e+00 ,9.1234e+00 ,9.7674e+00 /)
      kbo(:,18,10) = (/ &
     &5.8703e+00 ,6.5862e+00 ,7.2317e+00 ,7.8324e+00 ,8.4128e+00 /)
      kbo(:,19,10) = (/ &
     &5.0772e+00 ,5.6603e+00 ,6.2160e+00 ,6.7517e+00 ,7.2522e+00 /)
      kbo(:,20,10) = (/ &
     &4.3641e+00 ,4.8646e+00 ,5.3518e+00 ,5.8113e+00 ,6.2183e+00 /)
      kbo(:,21,10) = (/ &
     &3.7436e+00 ,4.1787e+00 ,4.5968e+00 ,4.9653e+00 ,5.2958e+00 /)
      kbo(:,22,10) = (/ &
     &3.2384e+00 ,3.6097e+00 ,3.9430e+00 ,4.2432e+00 ,4.5244e+00 /)
      kbo(:,23,10) = (/ &
     &2.7953e+00 ,3.1049e+00 ,3.3758e+00 ,3.6302e+00 ,3.8688e+00 /)
      kbo(:,24,10) = (/ &
     &2.4111e+00 ,2.6600e+00 ,2.8956e+00 ,3.1175e+00 ,3.3165e+00 /)
      kbo(:,25,10) = (/ &
     &2.0794e+00 ,2.2877e+00 ,2.4858e+00 ,2.6707e+00 ,2.8419e+00 /)
      kbo(:,26,10) = (/ &
     &1.7863e+00 ,1.9622e+00 ,2.1280e+00 ,2.2830e+00 ,2.4241e+00 /)
      kbo(:,27,10) = (/ &
     &1.5261e+00 ,1.6805e+00 ,1.8222e+00 ,1.9507e+00 ,2.0763e+00 /)
      kbo(:,28,10) = (/ &
     &1.3094e+00 ,1.4366e+00 ,1.5593e+00 ,1.6738e+00 ,1.7905e+00 /)
      kbo(:,29,10) = (/ &
     &1.1331e+00 ,1.2336e+00 ,1.3334e+00 ,1.4402e+00 ,1.5544e+00 /)
      kbo(:,30,10) = (/ &
     &9.7850e-01 ,1.0622e+00 ,1.1514e+00 ,1.2513e+00 ,1.3634e+00 /)
      kbo(:,31,10) = (/ &
     &8.4902e-01 ,9.2389e-01 ,1.0050e+00 ,1.1001e+00 ,1.2086e+00 /)
      kbo(:,32,10) = (/ &
     &7.4130e-01 ,8.0932e-01 ,8.8870e-01 ,9.7905e-01 ,1.0856e+00 /)
      kbo(:,33,10) = (/ &
     &6.5296e-01 ,7.1655e-01 ,7.9236e-01 ,8.8248e-01 ,9.8250e-01 /)
      kbo(:,34,10) = (/ &
     &5.7962e-01 ,6.3885e-01 ,7.0985e-01 ,7.9650e-01 ,8.9263e-01 /)
      kbo(:,35,10) = (/ &
     &5.1372e-01 ,5.6904e-01 ,6.3621e-01 ,7.1633e-01 ,8.0771e-01 /)
      kbo(:,36,10) = (/ &
     &4.5469e-01 ,5.0394e-01 ,5.6668e-01 ,6.4061e-01 ,7.2625e-01 /)
      kbo(:,37,10) = (/ &
     &3.9957e-01 ,4.4312e-01 ,4.9317e-01 ,5.6045e-01 ,6.4131e-01 /)
      kbo(:,38,10) = (/ &
     &3.5188e-01 ,3.9249e-01 ,4.3332e-01 ,4.9135e-01 ,5.6831e-01 /)
      kbo(:,39,10) = (/ &
     &3.1275e-01 ,3.5014e-01 ,3.8817e-01 ,4.3541e-01 ,5.0377e-01 /)
      kbo(:,40,10) = (/ &
     &2.7524e-01 ,3.0717e-01 ,3.4405e-01 ,3.8385e-01 ,4.3866e-01 /)
      kbo(:,41,10) = (/ &
     &2.4392e-01 ,2.7163e-01 ,3.0427e-01 ,3.4320e-01 ,3.8763e-01 /)
      kbo(:,42,10) = (/ &
     &2.1672e-01 ,2.4359e-01 ,2.7030e-01 ,3.0489e-01 ,3.4816e-01 /)
      kbo(:,43,10) = (/ &
     &1.9366e-01 ,2.1755e-01 ,2.4331e-01 ,2.6943e-01 ,3.1064e-01 /)
      kbo(:,44,10) = (/ &
     &1.7412e-01 ,1.9505e-01 ,2.1790e-01 ,2.4485e-01 ,2.7503e-01 /)
      kbo(:,45,10) = (/ &
     &1.5640e-01 ,1.7593e-01 ,1.9695e-01 ,2.2100e-01 ,2.4918e-01 /)
      kbo(:,46,10) = (/ &
     &1.3989e-01 ,1.5897e-01 ,1.7897e-01 ,2.0081e-01 ,2.2644e-01 /)
      kbo(:,47,10) = (/ &
     &1.2271e-01 ,1.4204e-01 ,1.6295e-01 ,1.8322e-01 ,2.0661e-01 /)
      kbo(:,48,10) = (/ &
     &1.0686e-01 ,1.2583e-01 ,1.4636e-01 ,1.6777e-01 ,1.9011e-01 /)
      kbo(:,49,10) = (/ &
     &9.3685e-02 ,1.1078e-01 ,1.3130e-01 ,1.5261e-01 ,1.7455e-01 /)
      kbo(:,50,10) = (/ &
     &8.2656e-02 ,9.8591e-02 ,1.1744e-01 ,1.3916e-01 ,1.6129e-01 /)
      kbo(:,51,10) = (/ &
     &7.2693e-02 ,8.8183e-02 ,1.0575e-01 ,1.2537e-01 ,1.4856e-01 /)
      kbo(:,52,10) = (/ &
     &6.4048e-02 ,7.9108e-02 ,9.5503e-02 ,1.1470e-01 ,1.3627e-01 /)
      kbo(:,53,10) = (/ &
     &5.5496e-02 ,7.0682e-02 ,8.5938e-02 ,1.0406e-01 ,1.2637e-01 /)
      kbo(:,54,10) = (/ &
     &4.9035e-02 ,6.2876e-02 ,7.7887e-02 ,9.5399e-02 ,1.1721e-01 /)
      kbo(:,55,10) = (/ &
     &4.3446e-02 ,5.6855e-02 ,7.1213e-02 ,8.8342e-02 ,1.0826e-01 /)
      kbo(:,56,10) = (/ &
     &3.8859e-02 ,5.1445e-02 ,6.5981e-02 ,8.2010e-02 ,1.0158e-01 /)
      kbo(:,57,10) = (/ &
     &3.5022e-02 ,4.6988e-02 ,6.1022e-02 ,7.6424e-02 ,9.5735e-02 /)
      kbo(:,58,10) = (/ &
     &3.1909e-02 ,4.3092e-02 ,5.6695e-02 ,7.2335e-02 ,9.0564e-02 /)
      kbo(:,59,10) = (/ &
     &3.0556e-02 ,4.1959e-02 ,5.5206e-02 ,7.1568e-02 ,9.0259e-02 /)
      kbo(:,13,11) = (/ &
     &1.9005e+01 ,2.1823e+01 ,2.4335e+01 ,2.6560e+01 ,2.8649e+01 /)
      kbo(:,14,11) = (/ &
     &1.8043e+01 ,2.0403e+01 ,2.2563e+01 ,2.4639e+01 ,2.6669e+01 /)
      kbo(:,15,11) = (/ &
     &1.6503e+01 ,1.8586e+01 ,2.0593e+01 ,2.2552e+01 ,2.4342e+01 /)
      kbo(:,16,11) = (/ &
     &1.4859e+01 ,1.6766e+01 ,1.8612e+01 ,2.0317e+01 ,2.1884e+01 /)
      kbo(:,17,11) = (/ &
     &1.3269e+01 ,1.4973e+01 ,1.6543e+01 ,1.8024e+01 ,1.9429e+01 /)
      kbo(:,18,11) = (/ &
     &1.1718e+01 ,1.3157e+01 ,1.4545e+01 ,1.5849e+01 ,1.7039e+01 /)
      kbo(:,19,11) = (/ &
     &1.0207e+01 ,1.1484e+01 ,1.2680e+01 ,1.3769e+01 ,1.4775e+01 /)
      kbo(:,20,11) = (/ &
     &8.8979e+00 ,9.9836e+00 ,1.0976e+01 ,1.1897e+01 ,1.2806e+01 /)
      kbo(:,21,11) = (/ &
     &7.7345e+00 ,8.6287e+00 ,9.4674e+00 ,1.0308e+01 ,1.1126e+01 /)
      kbo(:,22,11) = (/ &
     &6.7360e+00 ,7.4922e+00 ,8.2529e+00 ,8.9982e+00 ,9.7172e+00 /)
      kbo(:,23,11) = (/ &
     &5.8386e+00 ,6.5155e+00 ,7.1951e+00 ,7.8490e+00 ,8.4500e+00 /)
      kbo(:,24,11) = (/ &
     &5.0807e+00 ,5.6843e+00 ,6.2699e+00 ,6.8121e+00 ,7.3100e+00 /)
      kbo(:,25,11) = (/ &
     &4.4422e+00 ,4.9643e+00 ,5.4499e+00 ,5.8998e+00 ,6.3372e+00 /)
      kbo(:,26,11) = (/ &
     &3.9004e+00 ,4.3334e+00 ,4.7344e+00 ,5.1243e+00 ,5.5060e+00 /)
      kbo(:,27,11) = (/ &
     &3.4204e+00 ,3.7816e+00 ,4.1294e+00 ,4.4714e+00 ,4.7992e+00 /)
      kbo(:,28,11) = (/ &
     &2.9981e+00 ,3.3076e+00 ,3.6130e+00 ,3.9107e+00 ,4.1979e+00 /)
      kbo(:,29,11) = (/ &
     &2.6272e+00 ,2.9045e+00 ,3.1705e+00 ,3.4300e+00 ,3.6761e+00 /)
      kbo(:,30,11) = (/ &
     &2.3072e+00 ,2.5571e+00 ,2.7905e+00 ,3.0127e+00 ,3.2425e+00 /)
      kbo(:,31,11) = (/ &
     &2.0315e+00 ,2.2496e+00 ,2.4602e+00 ,2.6655e+00 ,2.8882e+00 /)
      kbo(:,32,11) = (/ &
     &1.7947e+00 ,1.9859e+00 ,2.1751e+00 ,2.3754e+00 ,2.5995e+00 /)
      kbo(:,33,11) = (/ &
     &1.5917e+00 ,1.7608e+00 ,1.9393e+00 ,2.1339e+00 ,2.3696e+00 /)
      kbo(:,34,11) = (/ &
     &1.4106e+00 ,1.5681e+00 ,1.7384e+00 ,1.9365e+00 ,2.1773e+00 /)
      kbo(:,35,11) = (/ &
     &1.2470e+00 ,1.3941e+00 ,1.5593e+00 ,1.7605e+00 ,1.9959e+00 /)
      kbo(:,36,11) = (/ &
     &1.0975e+00 ,1.2350e+00 ,1.3953e+00 ,1.5917e+00 ,1.8213e+00 /)
      kbo(:,37,11) = (/ &
     &9.5256e-01 ,1.0776e+00 ,1.2351e+00 ,1.4193e+00 ,1.6407e+00 /)
      kbo(:,38,11) = (/ &
     &8.3116e-01 ,9.4539e-01 ,1.0963e+00 ,1.2721e+00 ,1.4845e+00 /)
      kbo(:,39,11) = (/ &
     &7.2978e-01 ,8.3514e-01 ,9.7338e-01 ,1.1448e+00 ,1.3526e+00 /)
      kbo(:,40,11) = (/ &
     &6.3508e-01 ,7.2958e-01 ,8.5453e-01 ,1.0153e+00 ,1.2157e+00 /)
      kbo(:,41,11) = (/ &
     &5.5559e-01 ,6.3933e-01 ,7.5266e-01 ,8.9822e-01 ,1.0902e+00 /)
      kbo(:,42,11) = (/ &
     &4.9132e-01 ,5.6247e-01 ,6.6545e-01 ,8.0063e-01 ,9.7700e-01 /)
      kbo(:,43,11) = (/ &
     &4.3434e-01 ,4.9358e-01 ,5.8232e-01 ,7.0818e-01 ,8.6923e-01 /)
      kbo(:,44,11) = (/ &
     &3.8638e-01 ,4.3517e-01 ,5.1097e-01 ,6.1891e-01 ,7.7146e-01 /)
      kbo(:,45,11) = (/ &
     &3.4515e-01 ,3.9086e-01 ,4.5155e-01 ,5.4453e-01 ,6.8039e-01 /)
      kbo(:,46,11) = (/ &
     &3.1047e-01 ,3.4972e-01 ,4.0476e-01 ,4.8078e-01 ,5.9879e-01 /)
      kbo(:,47,11) = (/ &
     &2.8096e-01 ,3.1543e-01 ,3.6034e-01 ,4.2515e-01 ,5.2456e-01 /)
      kbo(:,48,11) = (/ &
     &2.5443e-01 ,2.8861e-01 ,3.2488e-01 ,3.8074e-01 ,4.6176e-01 /)
      kbo(:,49,11) = (/ &
     &2.3075e-01 ,2.6370e-01 ,2.9745e-01 ,3.4508e-01 ,4.1364e-01 /)
      kbo(:,50,11) = (/ &
     &2.0955e-01 ,2.4450e-01 ,2.7626e-01 ,3.1515e-01 ,3.7610e-01 /)
      kbo(:,51,11) = (/ &
     &1.9162e-01 ,2.2508e-01 ,2.5888e-01 ,2.9434e-01 ,3.4519e-01 /)
      kbo(:,52,11) = (/ &
     &1.7326e-01 ,2.0725e-01 ,2.4087e-01 ,2.7521e-01 ,3.1976e-01 /)
      kbo(:,53,11) = (/ &
     &1.5761e-01 ,1.9120e-01 ,2.2695e-01 ,2.6019e-01 ,2.9822e-01 /)
      kbo(:,54,11) = (/ &
     &1.4365e-01 ,1.7736e-01 ,2.1379e-01 ,2.4744e-01 ,2.8175e-01 /)
      kbo(:,55,11) = (/ &
     &1.3037e-01 ,1.6532e-01 ,2.0060e-01 ,2.3640e-01 ,2.6972e-01 /)
      kbo(:,56,11) = (/ &
     &1.1768e-01 ,1.5347e-01 ,1.8925e-01 ,2.2636e-01 ,2.6180e-01 /)
      kbo(:,57,11) = (/ &
     &1.0584e-01 ,1.4146e-01 ,1.7843e-01 ,2.1611e-01 ,2.5112e-01 /)
      kbo(:,58,11) = (/ &
     &9.5443e-02 ,1.3188e-01 ,1.6746e-01 ,2.0707e-01 ,2.4328e-01 /)
      kbo(:,59,11) = (/ &
     &9.0897e-02 ,1.2729e-01 ,1.6511e-01 ,2.0322e-01 ,2.4119e-01 /)
      kbo(:,13,12) = (/ &
     &3.3504e+01 ,3.7950e+01 ,4.2337e+01 ,4.6726e+01 ,5.1022e+01 /)
      kbo(:,14,12) = (/ &
     &3.2726e+01 ,3.7291e+01 ,4.1814e+01 ,4.6223e+01 ,5.0163e+01 /)
      kbo(:,15,12) = (/ &
     &3.1900e+01 ,3.6439e+01 ,4.0782e+01 ,4.4671e+01 ,4.8184e+01 /)
      kbo(:,16,12) = (/ &
     &3.0776e+01 ,3.4900e+01 ,3.8620e+01 ,4.2065e+01 ,4.5353e+01 /)
      kbo(:,17,12) = (/ &
     &2.8746e+01 ,3.2300e+01 ,3.5697e+01 ,3.8925e+01 ,4.2020e+01 /)
      kbo(:,18,12) = (/ &
     &2.6146e+01 ,2.9399e+01 ,3.2494e+01 ,3.5494e+01 ,3.8316e+01 /)
      kbo(:,19,12) = (/ &
     &2.3524e+01 ,2.6429e+01 ,2.9272e+01 ,3.2000e+01 ,3.4621e+01 /)
      kbo(:,20,12) = (/ &
     &2.1002e+01 ,2.3641e+01 ,2.6168e+01 ,2.8626e+01 ,3.0966e+01 /)
      kbo(:,21,12) = (/ &
     &1.8638e+01 ,2.0929e+01 ,2.3211e+01 ,2.5404e+01 ,2.7506e+01 /)
      kbo(:,22,12) = (/ &
     &1.6511e+01 ,1.8592e+01 ,2.0614e+01 ,2.2575e+01 ,2.4466e+01 /)
      kbo(:,23,12) = (/ &
     &1.4666e+01 ,1.6512e+01 ,1.8295e+01 ,2.0007e+01 ,2.1707e+01 /)
      kbo(:,24,12) = (/ &
     &1.3045e+01 ,1.4646e+01 ,1.6188e+01 ,1.7728e+01 ,1.9330e+01 /)
      kbo(:,25,12) = (/ &
     &1.1583e+01 ,1.2959e+01 ,1.4347e+01 ,1.5799e+01 ,1.7308e+01 /)
      kbo(:,26,12) = (/ &
     &1.0289e+01 ,1.1524e+01 ,1.2828e+01 ,1.4195e+01 ,1.5608e+01 /)
      kbo(:,27,12) = (/ &
     &9.1629e+00 ,1.0320e+01 ,1.1545e+01 ,1.2818e+01 ,1.4160e+01 /)
      kbo(:,28,12) = (/ &
     &8.1951e+00 ,9.2900e+00 ,1.0435e+01 ,1.1638e+01 ,1.2904e+01 /)
      kbo(:,29,12) = (/ &
     &7.3862e+00 ,8.4074e+00 ,9.4905e+00 ,1.0629e+01 ,1.1848e+01 /)
      kbo(:,30,12) = (/ &
     &6.7112e+00 ,7.6605e+00 ,8.6762e+00 ,9.7816e+00 ,1.0954e+01 /)
      kbo(:,31,12) = (/ &
     &6.1419e+00 ,7.0283e+00 ,8.0036e+00 ,9.0662e+00 ,1.0224e+01 /)
      kbo(:,32,12) = (/ &
     &5.6561e+00 ,6.5080e+00 ,7.4459e+00 ,8.4904e+00 ,9.6547e+00 /)
      kbo(:,33,12) = (/ &
     &5.2496e+00 ,6.0774e+00 ,7.0019e+00 ,8.0523e+00 ,9.2390e+00 /)
      kbo(:,34,12) = (/ &
     &4.8878e+00 ,5.7010e+00 ,6.6301e+00 ,7.6985e+00 ,8.9231e+00 /)
      kbo(:,35,12) = (/ &
     &4.5253e+00 ,5.3274e+00 ,6.2605e+00 ,7.3465e+00 ,8.6116e+00 /)
      kbo(:,36,12) = (/ &
     &4.1488e+00 ,4.9390e+00 ,5.8698e+00 ,6.9625e+00 ,8.2516e+00 /)
      kbo(:,37,12) = (/ &
     &3.7312e+00 ,4.4908e+00 ,5.4013e+00 ,6.4804e+00 ,7.7554e+00 /)
      kbo(:,38,12) = (/ &
     &3.3680e+00 ,4.1012e+00 ,4.9908e+00 ,6.0547e+00 ,7.3121e+00 /)
      kbo(:,39,12) = (/ &
     &3.0586e+00 ,3.7669e+00 ,4.6363e+00 ,5.6845e+00 ,6.9229e+00 /)
      kbo(:,40,12) = (/ &
     &2.7296e+00 ,3.4041e+00 ,4.2320e+00 ,5.2462e+00 ,6.4437e+00 /)
      kbo(:,41,12) = (/ &
     &2.4362e+00 ,3.0740e+00 ,3.8624e+00 ,4.8348e+00 ,5.9904e+00 /)
      kbo(:,42,12) = (/ &
     &2.1809e+00 ,2.7810e+00 ,3.5324e+00 ,4.4598e+00 ,5.5747e+00 /)
      kbo(:,43,12) = (/ &
     &1.9255e+00 ,2.4860e+00 ,3.1917e+00 ,4.0645e+00 ,5.1258e+00 /)
      kbo(:,44,12) = (/ &
     &1.6844e+00 ,2.2090e+00 ,2.8652e+00 ,3.6821e+00 ,4.6820e+00 /)
      kbo(:,45,12) = (/ &
     &1.4745e+00 ,1.9569e+00 ,2.5696e+00 ,3.3333e+00 ,4.2717e+00 /)
      kbo(:,46,12) = (/ &
     &1.2799e+00 ,1.7238e+00 ,2.2842e+00 ,2.9993e+00 ,3.8727e+00 /)
      kbo(:,47,12) = (/ &
     &1.0954e+00 ,1.4926e+00 ,2.0054e+00 ,2.6579e+00 ,3.4668e+00 /)
      kbo(:,48,12) = (/ &
     &9.3943e-01 ,1.2870e+00 ,1.7558e+00 ,2.3470e+00 ,3.0956e+00 /)
      kbo(:,49,12) = (/ &
     &8.0789e-01 ,1.1100e+00 ,1.5297e+00 ,2.0665e+00 ,2.7506e+00 /)
      kbo(:,50,12) = (/ &
     &7.0633e-01 ,9.6173e-01 ,1.3381e+00 ,1.8318e+00 ,2.4528e+00 /)
      kbo(:,51,12) = (/ &
     &6.2380e-01 ,8.4012e-01 ,1.1696e+00 ,1.6208e+00 ,2.1914e+00 /)
      kbo(:,52,12) = (/ &
     &5.6356e-01 ,7.3733e-01 ,1.0234e+00 ,1.4290e+00 ,1.9532e+00 /)
      kbo(:,53,12) = (/ &
     &5.0909e-01 ,6.5068e-01 ,8.9219e-01 ,1.2539e+00 ,1.7345e+00 /)
      kbo(:,54,12) = (/ &
     &4.6136e-01 ,5.8883e-01 ,7.8810e-01 ,1.1078e+00 ,1.5488e+00 /)
      kbo(:,55,12) = (/ &
     &4.1950e-01 ,5.3756e-01 ,7.0213e-01 ,9.8100e-01 ,1.3825e+00 /)
      kbo(:,56,12) = (/ &
     &3.8410e-01 ,4.8996e-01 ,6.3016e-01 ,8.6652e-01 ,1.2252e+00 /)
      kbo(:,57,12) = (/ &
     &3.5624e-01 ,4.4831e-01 ,5.7215e-01 ,7.6572e-01 ,1.0848e+00 /)
      kbo(:,58,12) = (/ &
     &3.2868e-01 ,4.1829e-01 ,5.2553e-01 ,6.8368e-01 ,9.6165e-01 /)
      kbo(:,59,12) = (/ &
     &3.1733e-01 ,4.0674e-01 ,5.0354e-01 ,6.5575e-01 ,9.0743e-01 /)
      kbo(:,13,13) = (/ &
     &6.3252e+01 ,7.1343e+01 ,7.9418e+01 ,8.6956e+01 ,9.3893e+01 /)
      kbo(:,14,13) = (/ &
     &6.4432e+01 ,7.3277e+01 ,8.1636e+01 ,8.9410e+01 ,9.6695e+01 /)
      kbo(:,15,13) = (/ &
     &6.5832e+01 ,7.4648e+01 ,8.2893e+01 ,9.0741e+01 ,9.8138e+01 /)
      kbo(:,16,13) = (/ &
     &6.5929e+01 ,7.4500e+01 ,8.2870e+01 ,9.0803e+01 ,9.8296e+01 /)
      kbo(:,17,13) = (/ &
     &6.5097e+01 ,7.3774e+01 ,8.2069e+01 ,9.0039e+01 ,9.7697e+01 /)
      kbo(:,18,13) = (/ &
     &6.3876e+01 ,7.2341e+01 ,8.0612e+01 ,8.8540e+01 ,9.6103e+01 /)
      kbo(:,19,13) = (/ &
     &6.1808e+01 ,7.0129e+01 ,7.8103e+01 ,8.5721e+01 ,9.2920e+01 /)
      kbo(:,20,13) = (/ &
     &5.9337e+01 ,6.7178e+01 ,7.4740e+01 ,8.1921e+01 ,8.8860e+01 /)
      kbo(:,21,13) = (/ &
     &5.6051e+01 ,6.3423e+01 ,7.0500e+01 ,7.7416e+01 ,8.4103e+01 /)
      kbo(:,22,13) = (/ &
     &5.2578e+01 ,5.9410e+01 ,6.6220e+01 ,7.2967e+01 ,7.9639e+01 /)
      kbo(:,23,13) = (/ &
     &4.8800e+01 ,5.5307e+01 ,6.1937e+01 ,6.8633e+01 ,7.5406e+01 /)
      kbo(:,24,13) = (/ &
     &4.5172e+01 ,5.1522e+01 ,5.8057e+01 ,6.4742e+01 ,7.1436e+01 /)
      kbo(:,25,13) = (/ &
     &4.2002e+01 ,4.8199e+01 ,5.4646e+01 ,6.1219e+01 ,6.7880e+01 /)
      kbo(:,26,13) = (/ &
     &3.9325e+01 ,4.5395e+01 ,5.1713e+01 ,5.8235e+01 ,6.4961e+01 /)
      kbo(:,27,13) = (/ &
     &3.7049e+01 ,4.2989e+01 ,4.9236e+01 ,5.5807e+01 ,6.2667e+01 /)
      kbo(:,28,13) = (/ &
     &3.5161e+01 ,4.0996e+01 ,4.7272e+01 ,5.3955e+01 ,6.1012e+01 /)
      kbo(:,29,13) = (/ &
     &3.3638e+01 ,3.9504e+01 ,4.5884e+01 ,5.2759e+01 ,6.0034e+01 /)
      kbo(:,30,13) = (/ &
     &3.2492e+01 ,3.8479e+01 ,4.5047e+01 ,5.2111e+01 ,5.9617e+01 /)
      kbo(:,31,13) = (/ &
     &3.1781e+01 ,3.7957e+01 ,4.4719e+01 ,5.2013e+01 ,5.9720e+01 /)
      kbo(:,32,13) = (/ &
     &3.1516e+01 ,3.7888e+01 ,4.4882e+01 ,5.2382e+01 ,6.0245e+01 /)
      kbo(:,33,13) = (/ &
     &3.1641e+01 ,3.8231e+01 ,4.5439e+01 ,5.3118e+01 ,6.1113e+01 /)
      kbo(:,34,13) = (/ &
     &3.1881e+01 ,3.8668e+01 ,4.6052e+01 ,5.3873e+01 ,6.1967e+01 /)
      kbo(:,35,13) = (/ &
     &3.1765e+01 ,3.8677e+01 ,4.6167e+01 ,5.4068e+01 ,6.2237e+01 /)
      kbo(:,36,13) = (/ &
     &3.1127e+01 ,3.8083e+01 ,4.5619e+01 ,5.3554e+01 ,6.1754e+01 /)
      kbo(:,37,13) = (/ &
     &2.9631e+01 ,3.6533e+01 ,4.4019e+01 ,5.1934e+01 ,6.0138e+01 /)
      kbo(:,38,13) = (/ &
     &2.8216e+01 ,3.5039e+01 ,4.2468e+01 ,5.0350e+01 ,5.8547e+01 /)
      kbo(:,39,13) = (/ &
     &2.6913e+01 ,3.3654e+01 ,4.1024e+01 ,4.8851e+01 ,5.7030e+01 /)
      kbo(:,40,13) = (/ &
     &2.5061e+01 ,3.1637e+01 ,3.8879e+01 ,4.6620e+01 ,5.4739e+01 /)
      kbo(:,41,13) = (/ &
     &2.3239e+01 ,2.9632e+01 ,3.6721e+01 ,4.4349e+01 ,5.2395e+01 /)
      kbo(:,42,13) = (/ &
     &2.1518e+01 ,2.7714e+01 ,3.4638e+01 ,4.2154e+01 ,5.0111e+01 /)
      kbo(:,43,13) = (/ &
     &1.9578e+01 ,2.5525e+01 ,3.2232e+01 ,3.9588e+01 ,4.7417e+01 /)
      kbo(:,44,13) = (/ &
     &1.7631e+01 ,2.3285e+01 ,2.9750e+01 ,3.6914e+01 ,4.4596e+01 /)
      kbo(:,45,13) = (/ &
     &1.5817e+01 ,2.1168e+01 ,2.7372e+01 ,3.4312e+01 ,4.1842e+01 /)
      kbo(:,46,13) = (/ &
     &1.4031e+01 ,1.9049e+01 ,2.4960e+01 ,3.1648e+01 ,3.8993e+01 /)
      kbo(:,47,13) = (/ &
     &1.2204e+01 ,1.6850e+01 ,2.2409e+01 ,2.8797e+01 ,3.5899e+01 /)
      kbo(:,48,13) = (/ &
     &1.0543e+01 ,1.4813e+01 ,2.0005e+01 ,2.6074e+01 ,3.2906e+01 /)
      kbo(:,49,13) = (/ &
     &9.0410e+00 ,1.2940e+01 ,1.7763e+01 ,2.3491e+01 ,3.0027e+01 /)
      kbo(:,50,13) = (/ &
     &7.7723e+00 ,1.1328e+01 ,1.5799e+01 ,2.1188e+01 ,2.7436e+01 /)
      kbo(:,51,13) = (/ &
     &6.6603e+00 ,9.8956e+00 ,1.4031e+01 ,1.9082e+01 ,2.5030e+01 /)
      kbo(:,52,13) = (/ &
     &5.6483e+00 ,8.5936e+00 ,1.2389e+01 ,1.7108e+01 ,2.2735e+01 /)
      kbo(:,53,13) = (/ &
     &4.7548e+00 ,7.4145e+00 ,1.0879e+01 ,1.5253e+01 ,2.0556e+01 /)
      kbo(:,54,13) = (/ &
     &4.0362e+00 ,6.4182e+00 ,9.6047e+00 ,1.3672e+01 ,1.8664e+01 /)
      kbo(:,55,13) = (/ &
     &3.4328e+00 ,5.5491e+00 ,8.4816e+00 ,1.2254e+01 ,1.6947e+01 /)
      kbo(:,56,13) = (/ &
     &2.9068e+00 ,4.7740e+00 ,7.4485e+00 ,1.0936e+01 ,1.5335e+01 /)
      kbo(:,57,13) = (/ &
     &2.4469e+00 ,4.0838e+00 ,6.4921e+00 ,9.7157e+00 ,1.3818e+01 /)
      kbo(:,58,13) = (/ &
     &2.0735e+00 ,3.4925e+00 ,5.6637e+00 ,8.6413e+00 ,1.2467e+01 /)
      kbo(:,59,13) = (/ &
     &1.9355e+00 ,3.2709e+00 ,5.3499e+00 ,8.2221e+00 ,1.1950e+01 /)
      kbo(:,13,14) = (/ &
     &1.3763e+02 ,1.5352e+02 ,1.6709e+02 ,1.7925e+02 ,1.9013e+02 /)
      kbo(:,14,14) = (/ &
     &1.4836e+02 ,1.6388e+02 ,1.7793e+02 ,1.9078e+02 ,2.0291e+02 /)
      kbo(:,15,14) = (/ &
     &1.5609e+02 ,1.7227e+02 ,1.8754e+02 ,2.0210e+02 ,2.1605e+02 /)
      kbo(:,16,14) = (/ &
     &1.6287e+02 ,1.8058e+02 ,1.9742e+02 ,2.1358e+02 ,2.2879e+02 /)
      kbo(:,17,14) = (/ &
     &1.6936e+02 ,1.8829e+02 ,2.0654e+02 ,2.2380e+02 ,2.3943e+02 /)
      kbo(:,18,14) = (/ &
     &1.7409e+02 ,1.9426e+02 ,2.1359e+02 ,2.3157e+02 ,2.4840e+02 /)
      kbo(:,19,14) = (/ &
     &1.7751e+02 ,1.9877e+02 ,2.1900e+02 ,2.3829e+02 ,2.5666e+02 /)
      kbo(:,20,14) = (/ &
     &1.8029e+02 ,2.0255e+02 ,2.2414e+02 ,2.4492e+02 ,2.6421e+02 /)
      kbo(:,21,14) = (/ &
     &1.8288e+02 ,2.0645e+02 ,2.2930e+02 ,2.5080e+02 ,2.7109e+02 /)
      kbo(:,22,14) = (/ &
     &1.8758e+02 ,2.1208e+02 ,2.3543e+02 ,2.5750e+02 ,2.7832e+02 /)
      kbo(:,23,14) = (/ &
     &1.9239e+02 ,2.1719e+02 ,2.4091e+02 ,2.6350e+02 ,2.8469e+02 /)
      kbo(:,24,14) = (/ &
     &1.9651e+02 ,2.2173e+02 ,2.4591e+02 ,2.6890e+02 ,2.9066e+02 /)
      kbo(:,25,14) = (/ &
     &2.0022e+02 ,2.2597e+02 ,2.5071e+02 ,2.7426e+02 ,2.9648e+02 /)
      kbo(:,26,14) = (/ &
     &2.0417e+02 ,2.3049e+02 ,2.5589e+02 ,2.7996e+02 ,3.0257e+02 /)
      kbo(:,27,14) = (/ &
     &2.0832e+02 ,2.3518e+02 ,2.6110e+02 ,2.8565e+02 ,3.0854e+02 /)
      kbo(:,28,14) = (/ &
     &2.1279e+02 ,2.4021e+02 ,2.6653e+02 ,2.9138e+02 ,3.1446e+02 /)
      kbo(:,29,14) = (/ &
     &2.1796e+02 ,2.4575e+02 ,2.7237e+02 ,2.9736e+02 ,3.2050e+02 /)
      kbo(:,30,14) = (/ &
     &2.2364e+02 ,2.5171e+02 ,2.7842e+02 ,3.0343e+02 ,3.2655e+02 /)
      kbo(:,31,14) = (/ &
     &2.2986e+02 ,2.5803e+02 ,2.8476e+02 ,3.0967e+02 ,3.3263e+02 /)
      kbo(:,32,14) = (/ &
     &2.3644e+02 ,2.6463e+02 ,2.9123e+02 ,3.1599e+02 ,3.3870e+02 /)
      kbo(:,33,14) = (/ &
     &2.4330e+02 ,2.7142e+02 ,2.9784e+02 ,3.2234e+02 ,3.4468e+02 /)
      kbo(:,34,14) = (/ &
     &2.4932e+02 ,2.7733e+02 ,3.0352e+02 ,3.2779e+02 ,3.4977e+02 /)
      kbo(:,35,14) = (/ &
     &2.5266e+02 ,2.8063e+02 ,3.0678e+02 ,3.3096e+02 ,3.5278e+02 /)
      kbo(:,36,14) = (/ &
     &2.5297e+02 ,2.8101e+02 ,3.0732e+02 ,3.3158e+02 ,3.5352e+02 /)
      kbo(:,37,14) = (/ &
     &2.4886e+02 ,2.7734e+02 ,3.0396e+02 ,3.2863e+02 ,3.5100e+02 /)
      kbo(:,38,14) = (/ &
     &2.4449e+02 ,2.7331e+02 ,3.0032e+02 ,3.2535e+02 ,3.4818e+02 /)
      kbo(:,39,14) = (/ &
     &2.4014e+02 ,2.6925e+02 ,2.9663e+02 ,3.2206e+02 ,3.4524e+02 /)
      kbo(:,40,14) = (/ &
     &2.3269e+02 ,2.6223e+02 ,2.9013e+02 ,3.1615e+02 ,3.3997e+02 /)
      kbo(:,41,14) = (/ &
     &2.2477e+02 ,2.5475e+02 ,2.8316e+02 ,3.0972e+02 ,3.3417e+02 /)
      kbo(:,42,14) = (/ &
     &2.1674e+02 ,2.4709e+02 ,2.7597e+02 ,3.0309e+02 ,3.2816e+02 /)
      kbo(:,43,14) = (/ &
     &2.0690e+02 ,2.3764e+02 ,2.6708e+02 ,2.9483e+02 ,3.2058e+02 /)
      kbo(:,44,14) = (/ &
     &1.9620e+02 ,2.2728e+02 ,2.5727e+02 ,2.8565e+02 ,3.1213e+02 /)
      kbo(:,45,14) = (/ &
     &1.8544e+02 ,2.1679e+02 ,2.4722e+02 ,2.7624e+02 ,3.0339e+02 /)
      kbo(:,46,14) = (/ &
     &1.7394e+02 ,2.0555e+02 ,2.3639e+02 ,2.6594e+02 ,2.9386e+02 /)
      kbo(:,47,14) = (/ &
     &1.6112e+02 ,1.9279e+02 ,2.2405e+02 ,2.5421e+02 ,2.8283e+02 /)
      kbo(:,48,14) = (/ &
     &1.4837e+02 ,1.8000e+02 ,2.1155e+02 ,2.4220e+02 ,2.7155e+02 /)
      kbo(:,49,14) = (/ &
     &1.3570e+02 ,1.6720e+02 ,1.9889e+02 ,2.3000e+02 ,2.5992e+02 /)
      kbo(:,50,14) = (/ &
     &1.2401e+02 ,1.5522e+02 ,1.8690e+02 ,2.1834e+02 ,2.4877e+02 /)
      kbo(:,51,14) = (/ &
     &1.1285e+02 ,1.4368e+02 ,1.7528e+02 ,2.0692e+02 ,2.3777e+02 /)
      kbo(:,52,14) = (/ &
     &1.0205e+02 ,1.3225e+02 ,1.6371e+02 ,1.9541e+02 ,2.2663e+02 /)
      kbo(:,53,14) = (/ &
     &9.1561e+01 ,1.2094e+02 ,1.5208e+02 ,1.8381e+02 ,2.1529e+02 /)
      kbo(:,54,14) = (/ &
     &8.2288e+01 ,1.1082e+02 ,1.4154e+02 ,1.7313e+02 ,2.0480e+02 /)
      kbo(:,55,14) = (/ &
     &7.3729e+01 ,1.0135e+02 ,1.3152e+02 ,1.6297e+02 ,1.9471e+02 /)
      kbo(:,56,14) = (/ &
     &6.5504e+01 ,9.2170e+01 ,1.2164e+02 ,1.5283e+02 ,1.8453e+02 /)
      kbo(:,57,14) = (/ &
     &5.7661e+01 ,8.3295e+01 ,1.1195e+02 ,1.4273e+02 ,1.7435e+02 /)
      kbo(:,58,14) = (/ &
     &5.0636e+01 ,7.5168e+01 ,1.0296e+02 ,1.3321e+02 ,1.6472e+02 /)
      kbo(:,59,14) = (/ &
     &4.7932e+01 ,7.1971e+01 ,9.9421e+01 ,1.2944e+02 ,1.6088e+02 /)
      kbo(:,13,15) = (/ &
     &2.4469e+02 ,2.6735e+02 ,2.9101e+02 ,3.1438e+02 ,3.3674e+02 /)
      kbo(:,14,15) = (/ &
     &2.8094e+02 ,3.0921e+02 ,3.3701e+02 ,3.6348e+02 ,3.8824e+02 /)
      kbo(:,15,15) = (/ &
     &3.2313e+02 ,3.5640e+02 ,3.8804e+02 ,4.1754e+02 ,4.4448e+02 /)
      kbo(:,16,15) = (/ &
     &3.6992e+02 ,4.0761e+02 ,4.4269e+02 ,4.7470e+02 ,5.0364e+02 /)
      kbo(:,17,15) = (/ &
     &4.1926e+02 ,4.6079e+02 ,4.9879e+02 ,5.3327e+02 ,5.6513e+02 /)
      kbo(:,18,15) = (/ &
     &4.7156e+02 ,5.1653e+02 ,5.5718e+02 ,5.9454e+02 ,6.2828e+02 /)
      kbo(:,19,15) = (/ &
     &5.2525e+02 ,5.7308e+02 ,6.1700e+02 ,6.5663e+02 ,6.9127e+02 /)
      kbo(:,20,15) = (/ &
     &5.7876e+02 ,6.2973e+02 ,6.7595e+02 ,7.1709e+02 ,7.5345e+02 /)
      kbo(:,21,15) = (/ &
     &6.2988e+02 ,6.8342e+02 ,7.3148e+02 ,7.7494e+02 ,8.1239e+02 /)
      kbo(:,22,15) = (/ &
     &6.8118e+02 ,7.3681e+02 ,7.8702e+02 ,8.3157e+02 ,8.6949e+02 /)
      kbo(:,23,15) = (/ &
     &7.2944e+02 ,7.8796e+02 ,8.3973e+02 ,8.8478e+02 ,9.2278e+02 /)
      kbo(:,24,15) = (/ &
     &7.7652e+02 ,8.3661e+02 ,8.8931e+02 ,9.3457e+02 ,9.7211e+02 /)
      kbo(:,25,15) = (/ &
     &8.2208e+02 ,8.8322e+02 ,9.3559e+02 ,9.8038e+02 ,1.0170e+03 /)
      kbo(:,26,15) = (/ &
     &8.6654e+02 ,9.2755e+02 ,9.7898e+02 ,1.0223e+03 ,1.0574e+03 /)
      kbo(:,27,15) = (/ &
     &9.0828e+02 ,9.6846e+02 ,1.0184e+03 ,1.0599e+03 ,1.0932e+03 /)
      kbo(:,28,15) = (/ &
     &9.4716e+02 ,1.0058e+03 ,1.0539e+03 ,1.0933e+03 ,1.1247e+03 /)
      kbo(:,29,15) = (/ &
     &9.8313e+02 ,1.0399e+03 ,1.0858e+03 ,1.1230e+03 ,1.1519e+03 /)
      kbo(:,30,15) = (/ &
     &1.0160e+03 ,1.0704e+03 ,1.1141e+03 ,1.1489e+03 ,1.1756e+03 /)
      kbo(:,31,15) = (/ &
     &1.0460e+03 ,1.0956e+03 ,1.1391e+03 ,1.1716e+03 ,1.1960e+03 /)
      kbo(:,32,15) = (/ &
     &1.0732e+03 ,1.1224e+03 ,1.1612e+03 ,1.1912e+03 ,1.2136e+03 /)
      kbo(:,33,15) = (/ &
     &1.0978e+03 ,1.1441e+03 ,1.1805e+03 ,1.2081e+03 ,1.2287e+03 /)
      kbo(:,34,15) = (/ &
     &1.1183e+03 ,1.1622e+03 ,1.1963e+03 ,1.2219e+03 ,1.2409e+03 /)
      kbo(:,35,15) = (/ &
     &1.1319e+03 ,1.1747e+03 ,1.2074e+03 ,1.2320e+03 ,1.2497e+03 /)
      kbo(:,36,15) = (/ &
     &1.1393e+03 ,1.1815e+03 ,1.2141e+03 ,1.2383e+03 ,1.2557e+03 /)
      kbo(:,37,15) = (/ &
     &1.1379e+03 ,1.1816e+03 ,1.2154e+03 ,1.2404e+03 ,1.2585e+03 /)
      kbo(:,38,15) = (/ &
     &1.1350e+03 ,1.1805e+03 ,1.2153e+03 ,1.2413e+03 ,1.2601e+03 /)
      kbo(:,39,15) = (/ &
     &1.1312e+03 ,1.1782e+03 ,1.2145e+03 ,1.2415e+03 ,1.2613e+03 /)
      kbo(:,40,15) = (/ &
     &1.1209e+03 ,1.1709e+03 ,1.2094e+03 ,1.2385e+03 ,1.2597e+03 /)
      kbo(:,41,15) = (/ &
     &1.1085e+03 ,1.1615e+03 ,1.2028e+03 ,1.2343e+03 ,1.2572e+03 /)
      kbo(:,42,15) = (/ &
     &1.0950e+03 ,1.1510e+03 ,1.1953e+03 ,1.2290e+03 ,1.2540e+03 /)
      kbo(:,43,15) = (/ &
     &1.0762e+03 ,1.1364e+03 ,1.1842e+03 ,1.2211e+03 ,1.2485e+03 /)
      kbo(:,44,15) = (/ &
     &1.0545e+03 ,1.1188e+03 ,1.1706e+03 ,1.2111e+03 ,1.2414e+03 /)
      kbo(:,45,15) = (/ &
     &1.0306e+03 ,1.0995e+03 ,1.1556e+03 ,1.1997e+03 ,1.2332e+03 /)
      kbo(:,46,15) = (/ &
     &1.0035e+03 ,1.0771e+03 ,1.1376e+03 ,1.1860e+03 ,1.2231e+03 /)
      kbo(:,47,15) = (/ &
     &9.7068e+02 ,1.0499e+03 ,1.1155e+03 ,1.1686e+03 ,1.2101e+03 /)
      kbo(:,48,15) = (/ &
     &9.3560e+02 ,1.0200e+03 ,1.0913e+03 ,1.1493e+03 ,1.1954e+03 /)
      kbo(:,49,15) = (/ &
     &8.9859e+02 ,9.8816e+02 ,1.0648e+03 ,1.1280e+03 ,1.1788e+03 /)
      kbo(:,50,15) = (/ &
     &8.6187e+02 ,9.5626e+02 ,1.0379e+03 ,1.1061e+03 ,1.1615e+03 /)
      kbo(:,51,15) = (/ &
     &8.2436e+02 ,9.2347e+02 ,1.0097e+03 ,1.0831e+03 ,1.1429e+03 /)
      kbo(:,52,15) = (/ &
     &7.8552e+02 ,8.8919e+02 ,9.8012e+02 ,1.0582e+03 ,1.1227e+03 /)
      kbo(:,53,15) = (/ &
     &7.4472e+02 ,8.5281e+02 ,9.4852e+02 ,1.0314e+03 ,1.1008e+03 /)
      kbo(:,54,15) = (/ &
     &7.0603e+02 ,8.1807e+02 ,9.1796e+02 ,1.0053e+03 ,1.0792e+03 /)
      kbo(:,55,15) = (/ &
     &6.6818e+02 ,7.8362e+02 ,8.8753e+02 ,9.7880e+02 ,1.0572e+03 /)
      kbo(:,56,15) = (/ &
     &6.2949e+02 ,7.4771e+02 ,8.5573e+02 ,9.5104e+02 ,1.0336e+03 /)
      kbo(:,57,15) = (/ &
     &5.9013e+02 ,7.1102e+02 ,8.2256e+02 ,9.2198e+02 ,1.0088e+03 /)
      kbo(:,58,15) = (/ &
     &5.5222e+02 ,6.7509e+02 ,7.8994e+02 ,8.9322e+02 ,9.8385e+02 /)
      kbo(:,59,15) = (/ &
     &5.3696e+02 ,6.6055e+02 ,7.7661e+02 ,8.8142e+02 ,9.7364e+02 /)
      kbo(:,13,16) = (/ &
     &4.2045e+02 ,4.6429e+02 ,5.0303e+02 ,5.3671e+02 ,5.6546e+02 /)
      kbo(:,14,16) = (/ &
     &5.0808e+02 ,5.5889e+02 ,6.0315e+02 ,6.4104e+02 ,6.7319e+02 /)
      kbo(:,15,16) = (/ &
     &6.0971e+02 ,6.6729e+02 ,7.1666e+02 ,7.5857e+02 ,7.9337e+02 /)
      kbo(:,16,16) = (/ &
     &7.2443e+02 ,7.8825e+02 ,8.4219e+02 ,8.8727e+02 ,9.2382e+02 /)
      kbo(:,17,16) = (/ &
     &8.5000e+02 ,9.1908e+02 ,9.7683e+02 ,1.0239e+03 ,1.0613e+03 /)
      kbo(:,18,16) = (/ &
     &9.8305e+02 ,1.0566e+03 ,1.1167e+03 ,1.1645e+03 ,1.2017e+03 /)
      kbo(:,19,16) = (/ &
     &1.1204e+03 ,1.1968e+03 ,1.2579e+03 ,1.3058e+03 ,1.3449e+03 /)
      kbo(:,20,16) = (/ &
     &1.2624e+03 ,1.3419e+03 ,1.4045e+03 ,1.4519e+03 ,1.4914e+03 /)
      kbo(:,21,16) = (/ &
     &1.4128e+03 ,1.4938e+03 ,1.5557e+03 ,1.6009e+03 ,1.6375e+03 /)
      kbo(:,22,16) = (/ &
     &1.5738e+03 ,1.6513e+03 ,1.7095e+03 ,1.7503e+03 ,1.7825e+03 /)
      kbo(:,23,16) = (/ &
     &1.7348e+03 ,1.8057e+03 ,1.8583e+03 ,1.8939e+03 ,1.9201e+03 /)
      kbo(:,24,16) = (/ &
     &1.8918e+03 ,1.9538e+03 ,1.9990e+03 ,2.0285e+03 ,2.0481e+03 /)
      kbo(:,25,16) = (/ &
     &2.0394e+03 ,2.0915e+03 ,2.1288e+03 ,2.1514e+03 ,2.1633e+03 /)
      kbo(:,26,16) = (/ &
     &2.1757e+03 ,2.2166e+03 ,2.2458e+03 ,2.2605e+03 ,2.2652e+03 /)
      kbo(:,27,16) = (/ &
     &2.2965e+03 ,2.3277e+03 ,2.3485e+03 ,2.3546e+03 ,2.3529e+03 /)
      kbo(:,28,16) = (/ &
     &2.4019e+03 ,2.4242e+03 ,2.4364e+03 ,2.4355e+03 ,2.4262e+03 /)
      kbo(:,29,16) = (/ &
     &2.4918e+03 ,2.5053e+03 ,2.5101e+03 ,2.5025e+03 ,2.4871e+03 /)
      kbo(:,30,16) = (/ &
     &2.5673e+03 ,2.5738e+03 ,2.5706e+03 ,2.5574e+03 ,2.5361e+03 /)
      kbo(:,31,16) = (/ &
     &2.6301e+03 ,2.6241e+03 ,2.6201e+03 ,2.6003e+03 ,2.5741e+03 /)
      kbo(:,32,16) = (/ &
     &2.6807e+03 ,2.6744e+03 ,2.6583e+03 ,2.6342e+03 ,2.6035e+03 /)
      kbo(:,33,16) = (/ &
     &2.7216e+03 ,2.7096e+03 ,2.6883e+03 ,2.6595e+03 ,2.6244e+03 /)
      kbo(:,34,16) = (/ &
     &2.7530e+03 ,2.7368e+03 ,2.7115e+03 ,2.6793e+03 ,2.6415e+03 /)
      kbo(:,35,16) = (/ &
     &2.7800e+03 ,2.7599e+03 ,2.7318e+03 ,2.6972e+03 ,2.6568e+03 /)
      kbo(:,36,16) = (/ &
     &2.8032e+03 ,2.7809e+03 ,2.7511e+03 ,2.7149e+03 ,2.6728e+03 /)
      kbo(:,37,16) = (/ &
     &2.8255e+03 ,2.8022e+03 ,2.7720e+03 ,2.7352e+03 ,2.6929e+03 /)
      kbo(:,38,16) = (/ &
     &2.8447e+03 ,2.8207e+03 ,2.7907e+03 ,2.7534e+03 ,2.7108e+03 /)
      kbo(:,39,16) = (/ &
     &2.8614e+03 ,2.8371e+03 ,2.8072e+03 ,2.7697e+03 ,2.7272e+03 /)
      kbo(:,40,16) = (/ &
     &2.8775e+03 ,2.8542e+03 ,2.8246e+03 ,2.7882e+03 ,2.7463e+03 /)
      kbo(:,41,16) = (/ &
     &2.8919e+03 ,2.8698e+03 ,2.8410e+03 ,2.8060e+03 ,2.7644e+03 /)
      kbo(:,42,16) = (/ &
     &2.9035e+03 ,2.8842e+03 ,2.8555e+03 ,2.8221e+03 ,2.7810e+03 /)
      kbo(:,43,16) = (/ &
     &2.9142e+03 ,2.8974e+03 ,2.8713e+03 ,2.8381e+03 ,2.7994e+03 /)
      kbo(:,44,16) = (/ &
     &2.9225e+03 ,2.9100e+03 ,2.8852e+03 ,2.8542e+03 ,2.8174e+03 /)
      kbo(:,45,16) = (/ &
     &2.9284e+03 ,2.9199e+03 ,2.8988e+03 ,2.8699e+03 ,2.8343e+03 /)
      kbo(:,46,16) = (/ &
     &2.9312e+03 ,2.9287e+03 ,2.9114e+03 ,2.8839e+03 ,2.8514e+03 /)
      kbo(:,47,16) = (/ &
     &2.9278e+03 ,2.9353e+03 ,2.9229e+03 ,2.8988e+03 ,2.8673e+03 /)
      kbo(:,48,16) = (/ &
     &2.9198e+03 ,2.9382e+03 ,2.9322e+03 ,2.9123e+03 ,2.8825e+03 /)
      kbo(:,49,16) = (/ &
     &2.9055e+03 ,2.9369e+03 ,2.9391e+03 ,2.9238e+03 ,2.8967e+03 /)
      kbo(:,50,16) = (/ &
     &2.8866e+03 ,2.9312e+03 ,2.9427e+03 ,2.9328e+03 ,2.9100e+03 /)
      kbo(:,51,16) = (/ &
     &2.8621e+03 ,2.9209e+03 ,2.9426e+03 ,2.9399e+03 ,2.9204e+03 /)
      kbo(:,52,16) = (/ &
     &2.8313e+03 ,2.9062e+03 ,2.9403e+03 ,2.9447e+03 ,2.9298e+03 /)
      kbo(:,53,16) = (/ &
     &2.7937e+03 ,2.8849e+03 ,2.9330e+03 ,2.9466e+03 ,2.9378e+03 /)
      kbo(:,54,16) = (/ &
     &2.7518e+03 ,2.8608e+03 ,2.9213e+03 ,2.9463e+03 ,2.9434e+03 /)
      kbo(:,55,16) = (/ &
     &2.7066e+03 ,2.8327e+03 ,2.9070e+03 ,2.9427e+03 ,2.9473e+03 /)
      kbo(:,56,16) = (/ &
     &2.6539e+03 ,2.7985e+03 ,2.8885e+03 ,2.9351e+03 ,2.9485e+03 /)
      kbo(:,57,16) = (/ &
     &2.5953e+03 ,2.7598e+03 ,2.8651e+03 ,2.9247e+03 ,2.9481e+03 /)
      kbo(:,58,16) = (/ &
     &2.5319e+03 ,2.7165e+03 ,2.8391e+03 ,2.9117e+03 ,2.9450e+03 /)
      kbo(:,59,16) = (/ &
     &2.5058e+03 ,2.6981e+03 ,2.8277e+03 ,2.9062e+03 ,2.9427e+03 /)

!     The array FORREFO contains the coefficient of the water vapor
!     foreign-continuum (including the energy term).  The first 
!     index refers to reference temperature (296,260,224,260) and 
!     pressure (970,475,219,3 mbar) levels.  The second index 
!     runs over the g-channel (1 to 16).

      forrefo(1,:) = (/ &
     &1.0515e-02 ,1.4860e-02 ,1.7181e-02 ,1.6642e-02 ,1.6644e-02 ,1.5649e-02 , &
     &1.7734e-02 ,1.7521e-02 ,1.7868e-02 ,1.8400e-02 ,1.9361e-02 ,2.1487e-02 , &
     &2.0192e-02 ,1.6545e-02 ,2.0922e-02 ,2.0922e-02 /)
      forrefo(2,:) = (/ &
     &1.0423e-02 ,1.4593e-02 ,1.6329e-02 ,1.7071e-02 ,1.7252e-02 ,1.6188e-02 , &
     &1.7752e-02 ,1.7913e-02 ,1.7551e-02 ,1.8203e-02 ,1.7946e-02 ,1.9828e-02 , &
     &2.1566e-02 ,1.9707e-02 ,2.0944e-02 ,2.0944e-02 /)
      forrefo(3,:) = (/ &
     &9.2770e-03 ,1.2818e-02 ,1.7181e-02 ,1.7858e-02 ,1.7888e-02 ,1.7121e-02 , &
     &1.8116e-02 ,1.8230e-02 ,1.7719e-02 ,1.7833e-02 ,1.8438e-02 ,1.7995e-02 , &
     &2.0895e-02 ,2.1525e-02 ,2.0517e-02 ,2.0954e-02 /)
      forrefo(4,:) = (/ &
     &8.3290e-03 ,1.3483e-02 ,1.5432e-02 ,2.0793e-02 ,1.8404e-02 ,1.7470e-02 , &
     &1.7253e-02 ,1.7132e-02 ,1.7119e-02 ,1.7376e-02 ,1.7030e-02 ,1.6847e-02 , &
     &1.5562e-02 ,1.6836e-02 ,1.8746e-02 ,2.1233e-02 /)

!     The array SELFREFO contains the coefficient of the water vapor
!     self-continuum (including the energy term).  The first index
!     refers to temperature in 7.2 degree increments.  For instance,
!     JT = 1 refers to a temperature of 245.6, JT = 2 refers to 252.8,
!     etc.  The second index runs over the g-channel (1 to 16).

      selfrefo(:, 1) = (/ &
     & 2.41120e-01 , 2.27071e-01 , 2.13840e-01 , 2.01380e-01 , 1.89646e-01 , &
     & 1.78596e-01 , 1.68190e-01 , 1.58390e-01 , 1.49161e-01 , 1.40470e-01 /)
      selfrefo(:, 2) = (/ &
     & 3.11156e-01 , 2.92249e-01 , 2.74490e-01 , 2.57810e-01 , 2.42144e-01 , &
     & 2.27430e-01 , 2.13610e-01 , 2.00630e-01 , 1.88439e-01 , 1.76988e-01 /)
      selfrefo(:, 3) = (/ &
     & 3.37148e-01 , 3.17767e-01 , 2.99500e-01 , 2.82283e-01 , 2.66056e-01 , &
     & 2.50762e-01 , 2.36347e-01 , 2.22760e-01 , 2.09955e-01 , 1.97885e-01 /)
      selfrefo(:, 4) = (/ &
     & 3.57139e-01 , 3.32763e-01 , 3.10050e-01 , 2.88888e-01 , 2.69170e-01 , &
     & 2.50798e-01 , 2.33680e-01 , 2.17730e-01 , 2.02869e-01 , 1.89022e-01 /)
      selfrefo(:, 5) = (/ &
     & 3.60626e-01 , 3.35433e-01 , 3.12000e-01 , 2.90204e-01 , 2.69931e-01 , &
     & 2.51074e-01 , 2.33534e-01 , 2.17220e-01 , 2.02045e-01 , 1.87931e-01 /)
      selfrefo(:, 6) = (/ &
     & 3.42420e-01 , 3.18795e-01 , 2.96800e-01 , 2.76323e-01 , 2.57258e-01 , &
     & 2.39509e-01 , 2.22985e-01 , 2.07600e-01 , 1.93277e-01 , 1.79942e-01 /)
      selfrefo(:, 7) = (/ &
     & 3.65491e-01 , 3.41599e-01 , 3.19270e-01 , 2.98400e-01 , 2.78895e-01 , &
     & 2.60664e-01 , 2.43625e-01 , 2.27700e-01 , 2.12816e-01 , 1.98905e-01 /)
      selfrefo(:, 8) = (/ &
     & 3.70354e-01 , 3.45005e-01 , 3.21390e-01 , 2.99392e-01 , 2.78899e-01 , &
     & 2.59809e-01 , 2.42026e-01 , 2.25460e-01 , 2.10028e-01 , 1.95652e-01 /)
      selfrefo(:, 9) = (/ &
     & 3.60483e-01 , 3.37846e-01 , 3.16630e-01 , 2.96747e-01 , 2.78112e-01 , &
     & 2.60648e-01 , 2.44280e-01 , 2.28940e-01 , 2.14563e-01 , 2.01090e-01 /)
      selfrefo(:,10) = (/ &
     & 3.71845e-01 , 3.48164e-01 , 3.25990e-01 , 3.05229e-01 , 2.85790e-01 , &
     & 2.67588e-01 , 2.50547e-01 , 2.34590e-01 , 2.19650e-01 , 2.05661e-01 /)
      selfrefo(:,11) = (/ &
     & 3.60606e-01 , 3.40789e-01 , 3.22060e-01 , 3.04361e-01 , 2.87634e-01 , &
     & 2.71826e-01 , 2.56888e-01 , 2.42770e-01 , 2.29428e-01 , 2.16819e-01 /)
      selfrefo(:,12) = (/ &
     & 3.90046e-01 , 3.68879e-01 , 3.48860e-01 , 3.29928e-01 , 3.12023e-01 , &
     & 2.95089e-01 , 2.79075e-01 , 2.63930e-01 , 2.49607e-01 , 2.36061e-01 /)
      selfrefo(:,13) = (/ &
     & 4.38542e-01 , 4.05139e-01 , 3.74280e-01 , 3.45771e-01 , 3.19434e-01 , &
     & 2.95103e-01 , 2.72626e-01 , 2.51860e-01 , 2.32676e-01 , 2.14953e-01 /)
      selfrefo(:,14) = (/ &
     & 4.19448e-01 , 3.81920e-01 , 3.47750e-01 , 3.16637e-01 , 2.88307e-01 , &
     & 2.62513e-01 , 2.39026e-01 , 2.17640e-01 , 1.98168e-01 , 1.80438e-01 /)
      selfrefo(:,15) = (/ &
     & 4.20276e-01 , 3.92281e-01 , 3.66150e-01 , 3.41760e-01 , 3.18995e-01 , &
     & 2.97746e-01 , 2.77912e-01 , 2.59400e-01 , 2.42121e-01 , 2.25993e-01 /)
      selfrefo(:,16) = (/ &
     & 4.20276e-01 , 3.92281e-01 , 3.66150e-01 , 3.41760e-01 , 3.18995e-01 , &
     & 2.97746e-01 , 2.77912e-01 , 2.59400e-01 , 2.42121e-01 , 2.25993e-01 /)

      end subroutine lw_kgb10
