!     path:      $Source$
!     author:    $Author$
!     revision:  $Revision$
!     created:   $Date$
!
!  --------------------------------------------------------------------------
! |                                                                          |
! |  Copyright 2002-2009, Atmospheric & Environmental Research, Inc. (AER).  |
! |  This software may be used, copied, or redistributed as long as it is    |
! |  not sold and this copyright notice is reproduced on each copy made.     |
! |  This model is provided as is without any express or implied warranties. |
! |                       (http://www.rtweb.aer.com/)                        |
! |                                                                          |
!  --------------------------------------------------------------------------

! **************************************************************************
!      subroutine lw_kgbnn
! **************************************************************************
!  RRTM Longwave Radiative Transfer Model
!  Atmospheric and Environmental Research, Inc., Cambridge, MA
!
!  Original version:   E. J. Mlawer, et al.
!  Revision for GCMs:  Michael J. Iacono; October, 2002
!  Revision for F90 formatting:  Michael J. Iacono; June 2006
!
!  This file contains 16 subroutines that include the 
!  absorption coefficients and other data for each of the 16 longwave
!  spectral bands used in RRTM.  Here, the data are defined for 16
!  g-points, or sub-intervals, per band.  These data are combined and
!  weighted using a mapping procedure in routine RRTMG_LW_INIT to reduce
!  the total number of g-points from 256 to 140 for use in the GCM.
! **************************************************************************
      subroutine lw_kgb06
! **************************************************************************

       !use parkind, only : im => kind , rb => kind  
      use rrlw_kg06, only : fracrefao, kao, kao_mco2, selfrefo, forrefo, &
                            cfc11adjo, cfc12o

      implicit none
      save

! Planck fraction mapping level : P = 473.4280 mb, T = 259.83 K
      fracrefao(:) = (/ &
     &   1.4353e-01 ,1.4774e-01 ,1.4467e-01 ,1.3785e-01 ,1.2376e-01 ,1.0214e-01 , &
     &   8.1984e-02 ,6.1152e-02 ,4.0987e-02 ,4.5067e-03 ,4.0020e-03 ,3.1772e-03 , &
     &   2.3458e-03 ,1.5025e-03 ,5.7415e-04 ,8.2970e-05 /)

! Minor gas mapping level:
!     lower - co2, p = 706.2720 mb, t = 294.2 k
!     upper - cfc11, cfc12

!      cfc11(:) = (/ &
!     &    0.,      0.,      26.5435, 108.850, &
!     &    58.7804, 54.0875, 41.1065, 35.6120, &
!     &    41.2328, 47.7402, 79.1026, 64.3005, &
!     &    108.206, 141.617, 186.565, 58.4782/)
! Original cfc11 is multiplied by 1.385 to account for the 1060-1107 cm-1 band.

      cfc11adjo(:) = (/ &
     &   0. ,      0. ,      36.7627 , 150.757 , &
     &   81.4109 , 74.9112 , 56.9325 , 49.3226 , &
     &   57.1074 , 66.1202 , 109.557 , 89.0562 , & 
     &   149.865 , 196.140 , 258.393 , 80.9923 /)
      cfc12o(:) = (/ &
     &   62.8368 , 43.2626 , 26.7549 , 22.2487 , &
     &   23.5029 , 34.8323 , 26.2335 , 23.2306 , &
     &   18.4062 , 13.9534 , 22.6268 , 24.2604 , &
     &   30.0088 , 26.3634 , 15.8237 , 57.5050 /)

!     The array KAO contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels > ~100mb and temperatures.  The first
!     index in the array, JT, which runs from 1 to 5, corresponds to 
!     different temperatures.  More specifically, JT = 3 means that the 
!     data are for the corresponding TREF for this  pressure level, 
!     JT = 2 refers to the temperatureTREF-15, JT = 1 is for TREF-30, 
!     JT = 4 is for TREF+15, and JT = 5 is for TREF+30.  The second 
!     index, JP, runs from 1 to 13 and refers to the corresponding 
!     pressure level in PREF (e.g. JP = 1 is for a pressure of 1053.63 mb).  
!     The third index, IG, goes from 1 to 16, and tells us which 
!     g-interval the absorption coefficients are for.

      kao(:, 1, 1) = (/ &
     &1.5108e-05 ,1.6223e-05 ,1.5899e-05 ,1.5254e-05 ,1.4889e-05 /)
      kao(:, 2, 1) = (/ &
     &1.0690e-05 ,1.0800e-05 ,1.0568e-05 ,1.0057e-05 ,9.4945e-06 /)
      kao(:, 3, 1) = (/ &
     &6.1072e-06 ,5.8741e-06 ,5.6796e-06 ,5.3664e-06 ,5.4934e-06 /)
      kao(:, 4, 1) = (/ &
     &3.0372e-06 ,2.9964e-06 ,2.6541e-06 ,2.8791e-06 ,3.9638e-06 /)
      kao(:, 5, 1) = (/ &
     &1.4777e-06 ,1.4916e-06 ,1.4819e-06 ,2.2264e-06 ,3.3268e-06 /)
      kao(:, 6, 1) = (/ &
     &7.4936e-07 ,7.2240e-07 ,1.1518e-06 ,1.7724e-06 ,2.8203e-06 /)
      kao(:, 7, 1) = (/ &
     &3.4904e-07 ,5.1177e-07 ,8.8489e-07 ,1.5219e-06 ,2.2871e-06 /)
      kao(:, 8, 1) = (/ &
     &2.1072e-07 ,4.5257e-07 ,7.4214e-07 ,1.2628e-06 ,1.9840e-06 /)
      kao(:, 9, 1) = (/ &
     &2.1779e-07 ,4.8639e-07 ,8.1133e-07 ,1.3719e-06 ,2.1663e-06 /)
      kao(:,10, 1) = (/ &
     &2.5134e-07 ,5.9583e-07 ,1.0449e-06 ,1.5899e-06 ,2.7441e-06 /)
      kao(:,11, 1) = (/ &
     &2.9178e-07 ,6.5749e-07 ,1.0958e-06 ,1.7834e-06 ,3.1413e-06 /)
      kao(:,12, 1) = (/ &
     &2.7268e-07 ,6.1470e-07 ,1.0270e-06 ,1.7566e-06 ,3.0441e-06 /)
      kao(:,13, 1) = (/ &
     &2.2995e-07 ,5.2185e-07 ,8.7916e-07 ,1.4999e-06 ,2.5740e-06 /)
      kao(:, 1, 2) = (/ &
     &2.1301e-05 ,2.3060e-05 ,2.1909e-05 ,2.0972e-05 ,2.1772e-05 /)
      kao(:, 2, 2) = (/ &
     &1.4382e-05 ,1.4147e-05 ,1.4339e-05 ,1.3679e-05 ,1.6973e-05 /)
      kao(:, 3, 2) = (/ &
     &8.0559e-06 ,8.4180e-06 ,7.4096e-06 ,9.3490e-06 ,1.0824e-05 /)
      kao(:, 4, 2) = (/ &
     &4.3614e-06 ,3.9657e-06 ,5.1299e-06 ,6.1754e-06 ,8.2925e-06 /)
      kao(:, 5, 2) = (/ &
     &2.2350e-06 ,2.3231e-06 ,3.3297e-06 ,4.8612e-06 ,6.5883e-06 /)
      kao(:, 6, 2) = (/ &
     &1.0863e-06 ,1.7510e-06 ,2.4185e-06 ,3.5854e-06 ,5.1511e-06 /)
      kao(:, 7, 2) = (/ &
     &7.6749e-07 ,1.2024e-06 ,1.9782e-06 ,2.7223e-06 ,4.2604e-06 /)
      kao(:, 8, 2) = (/ &
     &6.8738e-07 ,9.7505e-07 ,1.6738e-06 ,2.4371e-06 ,3.9386e-06 /)
      kao(:, 9, 2) = (/ &
     &7.3668e-07 ,1.0167e-06 ,1.9026e-06 ,3.0451e-06 ,5.0060e-06 /)
      kao(:,10, 2) = (/ &
     &9.8863e-07 ,1.5373e-06 ,2.5876e-06 ,4.8975e-06 ,7.8206e-06 /)
      kao(:,11, 2) = (/ &
     &1.0934e-06 ,1.6488e-06 ,2.7961e-06 ,5.2441e-06 ,8.5410e-06 /)
      kao(:,12, 2) = (/ &
     &1.0277e-06 ,1.5126e-06 ,2.6342e-06 ,4.9122e-06 ,8.0730e-06 /)
      kao(:,13, 2) = (/ &
     &8.7381e-07 ,1.2665e-06 ,2.2835e-06 ,4.2048e-06 ,6.9189e-06 /)
      kao(:, 1, 3) = (/ &
     &2.3993e-05 ,2.2308e-05 ,2.5893e-05 ,3.3883e-05 ,3.8280e-05 /)
      kao(:, 2, 3) = (/ &
     &1.4011e-05 ,1.4296e-05 ,2.1223e-05 ,2.4417e-05 ,2.7881e-05 /)
      kao(:, 3, 3) = (/ &
     &7.3965e-06 ,9.9180e-06 ,1.3735e-05 ,1.4536e-05 ,1.8056e-05 /)
      kao(:, 4, 3) = (/ &
     &4.5365e-06 ,7.0513e-06 ,7.2165e-06 ,9.8585e-06 ,1.1890e-05 /)
      kao(:, 5, 3) = (/ &
     &3.8953e-06 ,4.3626e-06 ,5.3805e-06 ,6.6118e-06 ,9.5204e-06 /)
      kao(:, 6, 3) = (/ &
     &2.4692e-06 ,2.6620e-06 ,3.5833e-06 ,5.1748e-06 ,7.8116e-06 /)
      kao(:, 7, 3) = (/ &
     &1.4531e-06 ,2.0753e-06 ,2.7794e-06 ,4.8340e-06 ,7.5049e-06 /)
      kao(:, 8, 3) = (/ &
     &8.9161e-07 ,1.6554e-06 ,2.7945e-06 ,4.7401e-06 ,7.3008e-06 /)
      kao(:, 9, 3) = (/ &
     &1.1556e-06 ,2.3050e-06 ,3.6767e-06 ,6.4276e-06 ,1.0393e-05 /)
      kao(:,10, 3) = (/ &
     &1.3936e-06 ,2.7867e-06 ,4.8066e-06 ,7.9343e-06 ,1.4027e-05 /)
      kao(:,11, 3) = (/ &
     &1.4469e-06 ,3.0966e-06 ,5.3467e-06 ,9.2496e-06 ,1.6488e-05 /)
      kao(:,12, 3) = (/ &
     &1.3797e-06 ,2.9577e-06 ,5.1784e-06 ,9.2835e-06 ,1.6169e-05 /)
      kao(:,13, 3) = (/ &
     &1.1793e-06 ,2.5194e-06 ,4.4903e-06 ,8.2145e-06 ,1.4209e-05 /)
      kao(:, 1, 4) = (/ &
     &4.3371e-05 ,4.2284e-05 ,4.2569e-05 ,4.5333e-05 ,4.9887e-05 /)
      kao(:, 2, 4) = (/ &
     &2.7836e-05 ,3.0742e-05 ,2.5159e-05 ,3.1058e-05 ,3.3502e-05 /)
      kao(:, 3, 4) = (/ &
     &1.5959e-05 ,1.5689e-05 ,1.8607e-05 ,1.9311e-05 ,2.2949e-05 /)
      kao(:, 4, 4) = (/ &
     &9.4357e-06 ,8.9581e-06 ,1.1706e-05 ,1.2462e-05 ,1.9504e-05 /)
      kao(:, 5, 4) = (/ &
     &4.6991e-06 ,5.9565e-06 ,7.1131e-06 ,1.0656e-05 ,1.6961e-05 /)
      kao(:, 6, 4) = (/ &
     &2.9104e-06 ,3.9977e-06 ,5.8385e-06 ,9.8483e-06 ,1.4910e-05 /)
      kao(:, 7, 4) = (/ &
     &2.0404e-06 ,2.7360e-06 ,5.0537e-06 ,8.2979e-06 ,1.2550e-05 /)
      kao(:, 8, 4) = (/ &
     &1.7124e-06 ,2.7023e-06 ,4.6383e-06 ,7.6524e-06 ,1.2059e-05 /)
      kao(:, 9, 4) = (/ &
     &1.7855e-06 ,3.1326e-06 ,5.8535e-06 ,9.7627e-06 ,1.5447e-05 /)
      kao(:,10, 4) = (/ &
     &2.2188e-06 ,4.3098e-06 ,8.7192e-06 ,1.5363e-05 ,2.4174e-05 /)
      kao(:,11, 4) = (/ &
     &2.5395e-06 ,4.8780e-06 ,1.0119e-05 ,1.6942e-05 ,2.6266e-05 /)
      kao(:,12, 4) = (/ &
     &2.4951e-06 ,4.8859e-06 ,9.7649e-06 ,1.6137e-05 ,2.5091e-05 /)
      kao(:,13, 4) = (/ &
     &2.2608e-06 ,4.4391e-06 ,8.5101e-06 ,1.3874e-05 ,2.1718e-05 /)
      kao(:, 1, 5) = (/ &
     &3.5802e-05 ,4.9569e-05 ,5.6081e-05 ,5.4456e-05 ,6.1620e-05 /)
      kao(:, 2, 5) = (/ &
     &2.7431e-05 ,3.7092e-05 ,4.0464e-05 ,4.0603e-05 ,5.2992e-05 /)
      kao(:, 3, 5) = (/ &
     &1.6511e-05 ,2.1182e-05 ,1.9952e-05 ,2.9271e-05 ,4.8230e-05 /)
      kao(:, 4, 5) = (/ &
     &1.1211e-05 ,1.2922e-05 ,1.4441e-05 ,2.5935e-05 ,3.8342e-05 /)
      kao(:, 5, 5) = (/ &
     &7.1937e-06 ,7.6149e-06 ,1.2471e-05 ,2.1334e-05 ,3.0465e-05 /)
      kao(:, 6, 5) = (/ &
     &4.6613e-06 ,5.5104e-06 ,1.0664e-05 ,1.6922e-05 ,2.4802e-05 /)
      kao(:, 7, 5) = (/ &
     &2.6908e-06 ,5.1362e-06 ,9.2865e-06 ,1.4719e-05 ,2.2004e-05 /)
      kao(:, 8, 5) = (/ &
     &2.4192e-06 ,4.7977e-06 ,8.6605e-06 ,1.4122e-05 ,2.1533e-05 /)
      kao(:, 9, 5) = (/ &
     &2.6505e-06 ,5.2138e-06 ,9.6090e-06 ,1.6493e-05 ,2.6941e-05 /)
      kao(:,10, 5) = (/ &
     &3.8793e-06 ,7.0191e-06 ,1.2677e-05 ,2.2456e-05 ,3.8574e-05 /)
      kao(:,11, 5) = (/ &
     &4.3385e-06 ,8.1555e-06 ,1.4661e-05 ,2.7034e-05 ,4.5538e-05 /)
      kao(:,12, 5) = (/ &
     &4.4806e-06 ,8.0941e-06 ,1.5170e-05 ,2.7140e-05 ,4.7747e-05 /)
      kao(:,13, 5) = (/ &
     &4.0859e-06 ,7.4306e-06 ,1.3915e-05 ,2.5201e-05 ,4.3638e-05 /)
      kao(:, 1, 6) = (/ &
     &6.3502e-05 ,6.1626e-05 ,6.7874e-05 ,7.9926e-05 ,1.4827e-04 /)
      kao(:, 2, 6) = (/ &
     &4.2546e-05 ,3.3547e-05 ,4.0025e-05 ,7.0944e-05 ,1.2242e-04 /)
      kao(:, 3, 6) = (/ &
     &2.4414e-05 ,2.4466e-05 ,3.6681e-05 ,6.7397e-05 ,9.7673e-05 /)
      kao(:, 4, 6) = (/ &
     &1.1878e-05 ,1.6683e-05 ,3.4310e-05 ,5.3734e-05 ,7.4953e-05 /)
      kao(:, 5, 6) = (/ &
     &8.0437e-06 ,1.5133e-05 ,2.7743e-05 ,4.0147e-05 ,5.6233e-05 /)
      kao(:, 6, 6) = (/ &
     &6.1550e-06 ,1.2316e-05 ,1.9945e-05 ,3.0529e-05 ,4.5113e-05 /)
      kao(:, 7, 6) = (/ &
     &4.8891e-06 ,9.6377e-06 ,1.6338e-05 ,2.4863e-05 ,3.7137e-05 /)
      kao(:, 8, 6) = (/ &
     &4.3692e-06 ,8.7526e-06 ,1.4669e-05 ,2.2987e-05 ,3.5150e-05 /)
      kao(:, 9, 6) = (/ &
     &5.3838e-06 ,1.0727e-05 ,1.8376e-05 ,3.0485e-05 ,4.8603e-05 /)
      kao(:,10, 6) = (/ &
     &6.7708e-06 ,1.4529e-05 ,2.6810e-05 ,4.7617e-05 ,7.8536e-05 /)
      kao(:,11, 6) = (/ &
     &8.3666e-06 ,1.7190e-05 ,3.3330e-05 ,5.7837e-05 ,9.5886e-05 /)
      kao(:,12, 6) = (/ &
     &8.6264e-06 ,1.8503e-05 ,3.4797e-05 ,6.1435e-05 ,1.0046e-04 /)
      kao(:,13, 6) = (/ &
     &8.2669e-06 ,1.8055e-05 ,3.3739e-05 ,5.7805e-05 ,9.4677e-05 /)
      kao(:, 1, 7) = (/ &
     &5.0894e-05 ,6.7019e-05 ,1.1702e-04 ,2.4649e-04 ,3.5046e-04 /)
      kao(:, 2, 7) = (/ &
     &4.3304e-05 ,4.9708e-05 ,1.0701e-04 ,1.8228e-04 ,2.5635e-04 /)
      kao(:, 3, 7) = (/ &
     &2.6855e-05 ,4.5972e-05 ,9.9426e-05 ,1.4867e-04 ,2.0722e-04 /)
      kao(:, 4, 7) = (/ &
     &2.0223e-05 ,4.9973e-05 ,8.2293e-05 ,1.1822e-04 ,1.6484e-04 /)
      kao(:, 5, 7) = (/ &
     &1.8923e-05 ,4.1445e-05 ,6.4003e-05 ,9.2899e-05 ,1.3171e-04 /)
      kao(:, 6, 7) = (/ &
     &1.5326e-05 ,3.0718e-05 ,4.7457e-05 ,6.8025e-05 ,9.5982e-05 /)
      kao(:, 7, 7) = (/ &
     &1.2448e-05 ,2.1715e-05 ,3.2987e-05 ,4.9690e-05 ,7.5010e-05 /)
      kao(:, 8, 7) = (/ &
     &1.0066e-05 ,1.7102e-05 ,2.7164e-05 ,4.3976e-05 ,6.9078e-05 /)
      kao(:, 9, 7) = (/ &
     &1.1685e-05 ,2.0037e-05 ,3.5620e-05 ,5.8499e-05 ,9.0997e-05 /)
      kao(:,10, 7) = (/ &
     &1.5861e-05 ,2.8659e-05 ,5.0802e-05 ,8.4995e-05 ,1.3698e-04 /)
      kao(:,11, 7) = (/ &
     &2.1379e-05 ,3.8980e-05 ,6.8341e-05 ,1.1084e-04 ,1.6745e-04 /)
      kao(:,12, 7) = (/ &
     &2.2487e-05 ,4.0976e-05 ,7.1749e-05 ,1.1325e-04 ,1.7051e-04 /)
      kao(:,13, 7) = (/ &
     &2.0952e-05 ,3.7773e-05 ,6.5636e-05 ,1.0928e-04 ,1.6488e-04 /)
      kao(:, 1, 8) = (/ &
     &1.0722e-04 ,2.7983e-04 ,4.9965e-04 ,7.0430e-04 ,9.5168e-04 /)
      kao(:, 2, 8) = (/ &
     &9.2566e-05 ,2.4429e-04 ,3.9143e-04 ,5.5037e-04 ,7.4482e-04 /)
      kao(:, 3, 8) = (/ &
     &8.2611e-05 ,1.7009e-04 ,2.5121e-04 ,3.5806e-04 ,4.9588e-04 /)
      kao(:, 4, 8) = (/ &
     &7.9199e-05 ,1.3718e-04 ,2.0767e-04 ,3.0111e-04 ,4.2301e-04 /)
      kao(:, 5, 8) = (/ &
     &6.6965e-05 ,1.0994e-04 ,1.6780e-04 ,2.4484e-04 ,3.4718e-04 /)
      kao(:, 6, 8) = (/ &
     &5.1557e-05 ,8.4788e-05 ,1.3259e-04 ,1.9727e-04 ,2.8537e-04 /)
      kao(:, 7, 8) = (/ &
     &3.8653e-05 ,6.5013e-05 ,1.0364e-04 ,1.5866e-04 ,2.2830e-04 /)
      kao(:, 8, 8) = (/ &
     &2.8949e-05 ,4.9620e-05 ,8.2718e-05 ,1.3000e-04 ,1.9256e-04 /)
      kao(:, 9, 8) = (/ &
     &2.6449e-05 ,4.6951e-05 ,7.7311e-05 ,1.2263e-04 ,1.9501e-04 /)
      kao(:,10, 8) = (/ &
     &4.1706e-05 ,7.2947e-05 ,1.1853e-04 ,1.7821e-04 ,2.7161e-04 /)
      kao(:,11, 8) = (/ &
     &4.6073e-05 ,7.9291e-05 ,1.2399e-04 ,2.0469e-04 ,3.0165e-04 /)
      kao(:,12, 8) = (/ &
     &4.9634e-05 ,8.1819e-05 ,1.2723e-04 ,2.1479e-04 ,3.2406e-04 /)
      kao(:,13, 8) = (/ &
     &4.8914e-05 ,8.2845e-05 ,1.3095e-04 ,2.1611e-04 ,3.1389e-04 /)
      kao(:, 1, 9) = (/ &
     &7.8561e-04 ,1.1643e-03 ,1.6394e-03 ,2.2582e-03 ,3.0560e-03 /)
      kao(:, 2, 9) = (/ &
     &6.6025e-04 ,9.8571e-04 ,1.4034e-03 ,1.9479e-03 ,2.6634e-03 /)
      kao(:, 3, 9) = (/ &
     &5.1307e-04 ,7.6204e-04 ,1.0925e-03 ,1.5312e-03 ,2.1163e-03 /)
      kao(:, 4, 9) = (/ &
     &3.4762e-04 ,5.0219e-04 ,7.2255e-04 ,1.0302e-03 ,1.4514e-03 /)
      kao(:, 5, 9) = (/ &
     &2.1712e-04 ,3.4419e-04 ,5.2965e-04 ,7.8732e-04 ,1.1464e-03 /)
      kao(:, 6, 9) = (/ &
     &1.8112e-04 ,2.9769e-04 ,4.6916e-04 ,7.0360e-04 ,1.0307e-03 /)
      kao(:, 7, 9) = (/ &
     &1.5449e-04 ,2.5935e-04 ,4.1089e-04 ,6.2682e-04 ,9.3587e-04 /)
      kao(:, 8, 9) = (/ &
     &1.4056e-04 ,2.4062e-04 ,3.8562e-04 ,5.9348e-04 ,8.8749e-04 /)
      kao(:, 9, 9) = (/ &
     &1.4311e-04 ,2.5683e-04 ,4.3997e-04 ,6.9753e-04 ,1.0500e-03 /)
      kao(:,10, 9) = (/ &
     &1.3733e-04 ,2.3478e-04 ,3.4047e-04 ,4.8048e-04 ,6.5263e-04 /)
      kao(:,11, 9) = (/ &
     &1.3199e-04 ,1.9086e-04 ,2.6427e-04 ,3.3652e-04 ,4.6218e-04 /)
      kao(:,12, 9) = (/ &
     &1.2421e-04 ,1.8123e-04 ,2.4759e-04 ,3.0949e-04 ,4.1038e-04 /)
      kao(:,13, 9) = (/ &
     &1.2135e-04 ,1.9021e-04 ,2.6678e-04 ,3.4185e-04 ,4.8239e-04 /)
      kao(:, 1,10) = (/ &
     &2.0319e-03 ,2.8954e-03 ,4.0208e-03 ,5.4666e-03 ,7.2307e-03 /)
      kao(:, 2,10) = (/ &
     &1.8594e-03 ,2.6055e-03 ,3.5896e-03 ,4.9149e-03 ,6.5643e-03 /)
      kao(:, 3,10) = (/ &
     &1.4858e-03 ,2.1438e-03 ,3.0067e-03 ,4.1237e-03 ,5.5345e-03 /)
      kao(:, 4,10) = (/ &
     &1.1237e-03 ,1.6648e-03 ,2.4078e-03 ,3.3725e-03 ,4.5628e-03 /)
      kao(:, 5,10) = (/ &
     &8.5681e-04 ,1.0371e-03 ,1.2665e-03 ,1.6242e-03 ,2.0962e-03 /)
      kao(:, 6,10) = (/ &
     &4.1878e-04 ,6.5245e-04 ,8.8673e-04 ,1.4273e-03 ,2.1165e-03 /)
      kao(:, 7,10) = (/ &
     &4.0657e-04 ,6.7784e-04 ,1.0299e-03 ,1.5982e-03 ,2.4416e-03 /)
      kao(:, 8,10) = (/ &
     &3.7189e-04 ,6.5876e-04 ,1.1259e-03 ,1.8690e-03 ,2.8514e-03 /)
      kao(:, 9,10) = (/ &
     &4.4113e-04 ,8.4598e-04 ,1.1991e-03 ,1.8860e-03 ,2.5835e-03 /)
      kao(:,10,10) = (/ &
     &1.8203e-04 ,4.6909e-06 ,8.8196e-06 ,8.3149e-05 ,1.6489e-04 /)
      kao(:,11,10) = (/ &
     &2.4843e-06 ,5.0211e-06 ,4.0342e-05 ,1.0733e-04 ,1.3735e-04 /)
      kao(:,12,10) = (/ &
     &2.2109e-06 ,4.6775e-06 ,6.3563e-05 ,8.8385e-05 ,1.1814e-04 /)
      kao(:,13,10) = (/ &
     &1.0306e-04 ,2.9167e-05 ,5.8184e-05 ,8.2616e-05 ,1.2141e-04 /)
      kao(:, 1,11) = (/ &
     &2.6851e-03 ,3.8621e-03 ,5.3296e-03 ,7.1411e-03 ,9.4750e-03 /)
      kao(:, 2,11) = (/ &
     &2.4213e-03 ,3.4979e-03 ,4.8929e-03 ,6.6432e-03 ,8.8031e-03 /)
      kao(:, 3,11) = (/ &
     &2.0817e-03 ,2.9708e-03 ,4.1510e-03 ,5.7232e-03 ,7.7624e-03 /)
      kao(:, 4,11) = (/ &
     &1.6627e-03 ,2.4521e-03 ,3.4576e-03 ,4.7721e-03 ,6.5543e-03 /)
      kao(:, 5,11) = (/ &
     &1.2664e-03 ,1.9577e-03 ,2.8702e-03 ,4.0767e-03 ,5.5807e-03 /)
      kao(:, 6,11) = (/ &
     &6.5451e-04 ,7.6752e-04 ,1.2109e-03 ,1.8526e-03 ,2.8298e-03 /)
      kao(:, 7,11) = (/ &
     &4.8621e-04 ,7.7329e-04 ,1.3520e-03 ,2.1779e-03 ,3.1034e-03 /)
      kao(:, 8,11) = (/ &
     &4.3573e-04 ,8.1759e-04 ,1.5409e-03 ,2.1798e-03 ,3.1170e-03 /)
      kao(:, 9,11) = (/ &
     &5.3220e-04 ,6.5242e-04 ,1.0365e-03 ,8.6351e-04 ,8.5932e-04 /)
      kao(:,10,11) = (/ &
     &4.1711e-06 ,8.9963e-06 ,1.7277e-05 ,3.1054e-05 ,5.1955e-05 /)
      kao(:,11,11) = (/ &
     &4.2641e-06 ,9.2786e-06 ,1.7917e-05 ,3.2294e-05 ,1.1099e-04 /)
      kao(:,12,11) = (/ &
     &4.4244e-06 ,9.4799e-06 ,1.8618e-05 ,7.5019e-05 ,1.5478e-04 /)
      kao(:,13,11) = (/ &
     &4.4439e-06 ,9.5554e-06 ,3.7663e-05 ,9.5587e-05 ,1.4453e-04 /)
      kao(:, 1,12) = (/ &
     &3.5676e-03 ,4.9715e-03 ,6.8023e-03 ,9.2475e-03 ,1.2425e-02 /)
      kao(:, 2,12) = (/ &
     &3.3730e-03 ,4.7958e-03 ,6.6635e-03 ,9.0736e-03 ,1.2194e-02 /)
      kao(:, 3,12) = (/ &
     &2.8824e-03 ,4.1856e-03 ,5.9756e-03 ,8.2464e-03 ,1.1067e-02 /)
      kao(:, 4,12) = (/ &
     &2.4288e-03 ,3.5141e-03 ,5.0677e-03 ,7.1261e-03 ,9.7127e-03 /)
      kao(:, 5,12) = (/ &
     &1.9807e-03 ,2.9284e-03 ,4.2016e-03 ,5.9142e-03 ,8.1484e-03 /)
      kao(:, 6,12) = (/ &
     &1.4728e-03 ,2.2453e-03 ,3.0533e-03 ,3.8340e-03 ,4.6395e-03 /)
      kao(:, 7,12) = (/ &
     &5.6245e-04 ,9.9265e-04 ,1.6138e-03 ,2.6180e-03 ,3.5983e-03 /)
      kao(:, 8,12) = (/ &
     &5.6232e-04 ,1.0725e-03 ,1.5736e-03 ,2.7015e-03 ,4.5325e-03 /)
      kao(:, 9,12) = (/ &
     &3.8503e-04 ,4.5325e-04 ,3.4069e-05 ,5.9217e-05 ,9.6016e-05 /)
      kao(:,10,12) = (/ &
     &6.7276e-06 ,1.4849e-05 ,2.8992e-05 ,5.2371e-05 ,8.7139e-05 /)
      kao(:,11,12) = (/ &
     &7.7381e-06 ,1.7002e-05 ,3.3523e-05 ,6.0232e-05 ,1.0004e-04 /)
      kao(:,12,12) = (/ &
     &8.5790e-06 ,1.9107e-05 ,3.7746e-05 ,6.8157e-05 ,1.1211e-04 /)
      kao(:,13,12) = (/ &
     &9.3399e-06 ,2.1875e-05 ,4.3407e-05 ,7.7729e-05 ,1.5956e-04 /)
      kao(:, 1,13) = (/ &
     &4.3788e-03 ,6.3181e-03 ,8.9543e-03 ,1.2364e-02 ,1.6648e-02 /)
      kao(:, 2,13) = (/ &
     &4.4160e-03 ,6.2758e-03 ,8.7769e-03 ,1.2121e-02 ,1.6531e-02 /)
      kao(:, 3,13) = (/ &
     &3.9967e-03 ,5.8737e-03 ,8.1369e-03 ,1.1188e-02 ,1.5344e-02 /)
      kao(:, 4,13) = (/ &
     &3.4004e-03 ,5.1547e-03 ,7.3735e-03 ,1.0182e-02 ,1.3939e-02 /)
      kao(:, 5,13) = (/ &
     &2.9021e-03 ,4.3823e-03 ,6.4495e-03 ,9.1509e-03 ,1.2669e-02 /)
      kao(:, 6,13) = (/ &
     &2.4396e-03 ,3.6407e-03 ,5.2497e-03 ,7.5439e-03 ,1.0675e-02 /)
      kao(:, 7,13) = (/ &
     &1.5932e-03 ,1.8719e-03 ,2.2033e-03 ,2.5091e-03 ,4.1046e-03 /)
      kao(:, 8,13) = (/ &
     &8.1439e-04 ,1.2125e-03 ,1.8190e-03 ,2.8987e-03 ,3.6148e-03 /)
      kao(:, 9,13) = (/ &
     &2.9962e-04 ,2.5888e-05 ,4.6085e-05 ,7.7045e-05 ,1.2285e-04 /)
      kao(:,10,13) = (/ &
     &9.2091e-06 ,1.8817e-05 ,3.5290e-05 ,6.2611e-05 ,1.0050e-04 /)
      kao(:,11,13) = (/ &
     &8.8922e-06 ,1.8844e-05 ,3.7039e-05 ,6.5193e-05 ,1.0998e-04 /)
      kao(:,12,13) = (/ &
     &9.1227e-06 ,2.0282e-05 ,3.9304e-05 ,7.0536e-05 ,1.1697e-04 /)
      kao(:,13,13) = (/ &
     &9.3384e-06 ,2.0460e-05 ,4.0361e-05 ,7.2805e-05 ,1.1815e-04 /)
      kao(:, 1,14) = (/ &
     &5.8176e-03 ,8.5593e-03 ,1.2130e-02 ,1.6770e-02 ,2.2682e-02 /)
      kao(:, 2,14) = (/ &
     &5.7661e-03 ,8.5728e-03 ,1.2312e-02 ,1.7131e-02 ,2.3220e-02 /)
      kao(:, 3,14) = (/ &
     &5.4299e-03 ,7.9187e-03 ,1.1613e-02 ,1.6480e-02 ,2.2670e-02 /)
      kao(:, 4,14) = (/ &
     &4.9805e-03 ,7.1731e-03 ,1.0470e-02 ,1.5114e-02 ,2.1203e-02 /)
      kao(:, 5,14) = (/ &
     &4.4098e-03 ,6.5055e-03 ,9.4518e-03 ,1.3613e-02 ,1.9313e-02 /)
      kao(:, 6,14) = (/ &
     &3.7762e-03 ,5.6862e-03 ,8.4288e-03 ,1.2169e-02 ,1.7260e-02 /)
      kao(:, 7,14) = (/ &
     &3.2464e-03 ,4.8124e-03 ,6.8092e-03 ,9.1900e-03 ,1.1370e-02 /)
      kao(:, 8,14) = (/ &
     &1.1521e-03 ,1.1423e-03 ,1.7687e-03 ,1.5659e-03 ,2.2329e-03 /)
      kao(:, 9,14) = (/ &
     &1.9075e-05 ,4.4531e-05 ,8.9053e-05 ,1.1868e-04 ,1.6905e-04 /)
      kao(:,10,14) = (/ &
     &1.1271e-05 ,2.8156e-05 ,6.0244e-05 ,8.6340e-05 ,1.3123e-04 /)
      kao(:,11,14) = (/ &
     &1.1591e-05 ,2.8030e-05 ,4.8484e-05 ,7.4281e-05 ,1.1022e-04 /)
      kao(:,12,14) = (/ &
     &1.1274e-05 ,2.5700e-05 ,4.0234e-05 ,6.2656e-05 ,9.8261e-05 /)
      kao(:,13,14) = (/ &
     &1.0130e-05 ,1.8686e-05 ,3.2466e-05 ,5.4260e-05 ,8.5980e-05 /)
      kao(:, 1,15) = (/ &
     &8.0623e-03 ,1.1623e-02 ,1.6754e-02 ,2.3990e-02 ,3.4103e-02 /)
      kao(:, 2,15) = (/ &
     &8.1053e-03 ,1.1698e-02 ,1.6865e-02 ,2.3848e-02 ,3.3543e-02 /)
      kao(:, 3,15) = (/ &
     &7.5058e-03 ,1.0852e-02 ,1.5814e-02 ,2.2160e-02 ,3.0813e-02 /)
      kao(:, 4,15) = (/ &
     &6.7816e-03 ,9.9478e-03 ,1.4382e-02 ,2.0576e-02 ,2.8388e-02 /)
      kao(:, 5,15) = (/ &
     &6.3211e-03 ,9.1146e-03 ,1.3301e-02 ,1.9331e-02 ,2.6874e-02 /)
      kao(:, 6,15) = (/ &
     &5.8531e-03 ,8.4323e-03 ,1.2188e-02 ,1.7787e-02 ,2.5518e-02 /)
      kao(:, 7,15) = (/ &
     &5.3028e-03 ,7.8385e-03 ,1.1331e-02 ,1.6285e-02 ,2.3804e-02 /)
      kao(:, 8,15) = (/ &
     &4.7139e-03 ,4.9648e-03 ,2.7936e-03 ,2.1248e-03 ,1.7982e-03 /)
      kao(:, 9,15) = (/ &
     &6.9507e-07 ,1.4412e-06 ,2.8345e-06 ,1.0911e-04 ,2.4370e-04 /)
      kao(:,10,15) = (/ &
     &3.6501e-07 ,8.3446e-07 ,1.6843e-06 ,6.4065e-05 ,1.5410e-04 /)
      kao(:,11,15) = (/ &
     &2.8886e-07 ,6.6813e-07 ,2.2629e-05 ,7.8818e-05 ,1.6163e-04 /)
      kao(:,12,15) = (/ &
     &2.6037e-07 ,5.5485e-07 ,3.1734e-05 ,8.0123e-05 ,1.4669e-04 /)
      kao(:,13,15) = (/ &
     &2.3446e-07 ,1.2097e-05 ,3.4961e-05 ,7.1280e-05 ,1.2611e-04 /)
      kao(:, 1,16) = (/ &
     &8.7570e-03 ,1.2357e-02 ,1.9959e-02 ,3.2636e-02 ,5.0897e-02 /)
      kao(:, 2,16) = (/ &
     &9.0825e-03 ,1.2808e-02 ,1.9776e-02 ,3.3132e-02 ,5.2704e-02 /)
      kao(:, 3,16) = (/ &
     &8.8201e-03 ,1.2594e-02 ,1.7588e-02 ,3.0181e-02 ,4.9544e-02 /)
      kao(:, 4,16) = (/ &
     &8.3170e-03 ,1.2140e-02 ,1.6975e-02 ,2.5787e-02 ,4.3638e-02 /)
      kao(:, 5,16) = (/ &
     &7.7605e-03 ,1.1646e-02 ,1.6641e-02 ,2.2927e-02 ,3.7740e-02 /)
      kao(:, 6,16) = (/ &
     &7.0356e-03 ,1.0930e-02 ,1.6057e-02 ,2.2523e-02 ,3.2226e-02 /)
      kao(:, 7,16) = (/ &
     &6.7105e-03 ,1.0123e-02 ,1.5354e-02 ,2.2098e-02 ,3.0452e-02 /)
      kao(:, 8,16) = (/ &
     &6.7590e-03 ,9.3669e-03 ,1.4563e-02 ,1.3873e-02 ,1.5872e-03 /)
      kao(:, 9,16) = (/ &
     &5.9690e-07 ,1.4246e-06 ,2.9975e-06 ,4.2222e-06 ,7.0710e-06 /)
      kao(:,10,16) = (/ &
     &3.1073e-07 ,7.7259e-07 ,1.8451e-06 ,3.5923e-06 ,5.6864e-06 /)
      kao(:,11,16) = (/ &
     &2.5196e-07 ,6.5326e-07 ,1.5669e-06 ,3.1861e-06 ,5.6813e-06 /)
      kao(:,12,16) = (/ &
     &1.8633e-07 ,5.5942e-07 ,1.3020e-06 ,2.7030e-06 ,4.5791e-06 /)
      kao(:,13,16) = (/ &
     &1.4070e-07 ,4.5125e-07 ,1.0269e-06 ,2.1236e-06 ,3.8826e-06 /)

!     The array KAO_Mxx contains the absorption coefficient for 
!     a minor species at the 16 chosen g-values for a reference pressure
!     level below 100~ mb.   The first index refers to temperature 
!     in 7.2 degree increments.  For instance, JT = 1 refers to a 
!     temperature of 188.0, JT = 2 refers to 195.2, etc. The second index 
!     runs over the g-channel (1 to 16).

      kao_mco2(:, 1) = (/ &
     & 1.45661e-05 , 1.73337e-05 , 2.06273e-05 , 2.45466e-05 , 2.92105e-05 , &
     & 3.47607e-05 , 4.13654e-05 , 4.92251e-05 , 5.85781e-05 , 6.97083e-05 , &
     & 8.29533e-05 , 9.87149e-05 , 1.17471e-04 , 1.39792e-04 , 1.66353e-04 , &
     & 1.97961e-04 , 2.35574e-04 , 2.80335e-04 , 3.33600e-04 /)
      kao_mco2(:, 2) = (/ &
     & 9.96332e-06 , 1.21229e-05 , 1.47506e-05 , 1.79478e-05 , 2.18381e-05 , &
     & 2.65716e-05 , 3.23310e-05 , 3.93389e-05 , 4.78658e-05 , 5.82408e-05 , &
     & 7.08647e-05 , 8.62250e-05 , 1.04914e-04 , 1.27655e-04 , 1.55325e-04 , &
     & 1.88992e-04 , 2.29957e-04 , 2.79801e-04 , 3.40448e-04 /)
      kao_mco2(:, 3) = (/ &
     & 1.14968e-05 , 1.39890e-05 , 1.70215e-05 , 2.07115e-05 , 2.52013e-05 , &
     & 3.06644e-05 , 3.73118e-05 , 4.54002e-05 , 5.52420e-05 , 6.72173e-05 , &
     & 8.17887e-05 , 9.95188e-05 , 1.21092e-04 , 1.47343e-04 , 1.79283e-04 , &
     & 2.18148e-04 , 2.65438e-04 , 3.22980e-04 , 3.92995e-04 /)
      kao_mco2(:, 4) = (/ &
     & 1.02186e-05 , 1.23232e-05 , 1.48613e-05 , 1.79222e-05 , 2.16134e-05 , &
     & 2.60649e-05 , 3.14332e-05 , 3.79071e-05 , 4.57145e-05 , 5.51297e-05 , &
     & 6.64843e-05 , 8.01773e-05 , 9.66905e-05 , 1.16605e-04 , 1.40621e-04 , &
     & 1.69583e-04 , 2.04510e-04 , 2.46631e-04 , 2.97426e-04 /)
      kao_mco2(:, 5) = (/ &
     & 1.03469e-05 , 1.24680e-05 , 1.50239e-05 , 1.81037e-05 , 2.18149e-05 , &
     & 2.62869e-05 , 3.16756e-05 , 3.81690e-05 , 4.59935e-05 , 5.54220e-05 , &
     & 6.67833e-05 , 8.04737e-05 , 9.69704e-05 , 1.16849e-04 , 1.40803e-04 , &
     & 1.69667e-04 , 2.04448e-04 , 2.46359e-04 , 2.96861e-04 /)
      kao_mco2(:, 6) = (/ &
     & 1.71660e-05 , 2.07334e-05 , 2.50420e-05 , 3.02461e-05 , 3.65317e-05 , &
     & 4.41235e-05 , 5.32930e-05 , 6.43680e-05 , 7.77446e-05 , 9.39010e-05 , &
     & 1.13415e-04 , 1.36984e-04 , 1.65451e-04 , 1.99835e-04 , 2.41363e-04 , &
     & 2.91522e-04 , 3.52104e-04 , 4.25276e-04 , 5.13654e-04 /)
      kao_mco2(:, 7) = (/ &
     & 4.78803e-05 , 5.79395e-05 , 7.01119e-05 , 8.48418e-05 , 1.02666e-04 , &
     & 1.24235e-04 , 1.50336e-04 , 1.81920e-04 , 2.20139e-04 , 2.66388e-04 , &
     & 3.22354e-04 , 3.90077e-04 , 4.72028e-04 , 5.71197e-04 , 6.91199e-04 , &
     & 8.36413e-04 , 1.01214e-03 , 1.22477e-03 , 1.48209e-03 /)
      kao_mco2(:, 8) = (/ &
     & 1.27954e-04 , 1.55281e-04 , 1.88445e-04 , 2.28692e-04 , 2.77534e-04 , &
     & 3.36808e-04 , 4.08741e-04 , 4.96037e-04 , 6.01977e-04 , 7.30542e-04 , &
     & 8.86566e-04 , 1.07591e-03 , 1.30570e-03 , 1.58456e-03 , 1.92298e-03 , &
     & 2.33367e-03 , 2.83208e-03 , 3.43694e-03 , 4.17097e-03 /)
      kao_mco2(:, 9) = (/ &
     & 2.93792e-05 , 3.55109e-05 , 4.29223e-05 , 5.18805e-05 , 6.27083e-05 , &
     & 7.57960e-05 , 9.16151e-05 , 1.10736e-04 , 1.33847e-04 , 1.61782e-04 , &
     & 1.95547e-04 , 2.36359e-04 , 2.85689e-04 , 3.45315e-04 , 4.17384e-04 , &
     & 5.04495e-04 , 6.09787e-04 , 7.37054e-04 , 8.90882e-04 /)
      kao_mco2(:,10) = (/ &
     & 5.08569e-05 , 6.24700e-05 , 7.67350e-05 , 9.42574e-05 , 1.15781e-04 , &
     & 1.42220e-04 , 1.74695e-04 , 2.14587e-04 , 2.63588e-04 , 3.23778e-04 , &
     & 3.97712e-04 , 4.88530e-04 , 6.00085e-04 , 7.37114e-04 , 9.05433e-04 , &
     & 1.11219e-03 , 1.36616e-03 , 1.67812e-03 , 2.06131e-03 /)
      kao_mco2(:,11) = (/ &
     & 4.82546e-06 , 6.21462e-06 , 8.00369e-06 , 1.03078e-05 , 1.32752e-05 , &
     & 1.70969e-05 , 2.20188e-05 , 2.83575e-05 , 3.65211e-05 , 4.70348e-05 , &
     & 6.05753e-05 , 7.80138e-05 , 1.00472e-04 , 1.29397e-04 , 1.66647e-04 , &
     & 2.14622e-04 , 2.76407e-04 , 3.55980e-04 , 4.58459e-04 /)
      kao_mco2(:,12) = (/ &
     & 2.41346e-06 , 2.96282e-06 , 3.63723e-06 , 4.46516e-06 , 5.48153e-06 , &
     & 6.72926e-06 , 8.26100e-06 , 1.01414e-05 , 1.24498e-05 , 1.52837e-05 , &
     & 1.87627e-05 , 2.30335e-05 , 2.82765e-05 , 3.47129e-05 , 4.26144e-05 , &
     & 5.23144e-05 , 6.42225e-05 , 7.88410e-05 , 9.67871e-05 /)
      kao_mco2(:,13) = (/ &
     & 2.76412e-06 , 3.46195e-06 , 4.33596e-06 , 5.43062e-06 , 6.80164e-06 , &
     & 8.51879e-06 , 1.06695e-05 , 1.33631e-05 , 1.67367e-05 , 2.09621e-05 , &
     & 2.62542e-05 , 3.28824e-05 , 4.11839e-05 , 5.15813e-05 , 6.46035e-05 , &
     & 8.09134e-05 , 1.01341e-04 , 1.26925e-04 , 1.58969e-04 /)
      kao_mco2(:,14) = (/ &
     & 1.25126e-06 , 1.54971e-06 , 1.91935e-06 , 2.37715e-06 , 2.94416e-06 , &
     & 3.64640e-06 , 4.51615e-06 , 5.59335e-06 , 6.92749e-06 , 8.57985e-06 , &
     & 1.06263e-05 , 1.31610e-05 , 1.63001e-05 , 2.01881e-05 , 2.50034e-05 , &
     & 3.09672e-05 , 3.83536e-05 , 4.75018e-05 , 5.88319e-05 /)
      kao_mco2(:,15) = (/ &
     & 1.59748e-06 , 2.08378e-06 , 2.71812e-06 , 3.54557e-06 , 4.62491e-06 , &
     & 6.03282e-06 , 7.86932e-06 , 1.02649e-05 , 1.33897e-05 , 1.74658e-05 , &
     & 2.27827e-05 , 2.97182e-05 , 3.87649e-05 , 5.05657e-05 , 6.59589e-05 , &
     & 8.60380e-05 , 1.12230e-04 , 1.46394e-04 , 1.90959e-04 /)
      kao_mco2(:,16) = (/ &
     & 1.68148e-06 , 2.17133e-06 , 2.80388e-06 , 3.62071e-06 , 4.67549e-06 , &
     & 6.03756e-06 , 7.79642e-06 , 1.00677e-05 , 1.30006e-05 , 1.67879e-05 , &
     & 2.16786e-05 , 2.79941e-05 , 3.61493e-05 , 4.66803e-05 , 6.02792e-05 , &
     & 7.78398e-05 , 1.00516e-04 , 1.29799e-04 , 1.67612e-04 /)

!     The array FORREFO contains the coefficient of the water vapor
!     foreign-continuum (including the energy term).  The first 
!     index refers to reference temperature (296,260,224,260) and 
!     pressure (970,475,219,3 mbar) levels.  The second index 
!     runs over the g-channel (1 to 16).

      forrefo(1,:) = (/ &
     &3.2710e-07 ,5.2119e-07 ,8.4740e-07 ,1.6908e-06 ,2.3433e-06 ,4.4129e-06 , &
     &3.8930e-06 ,2.3338e-06 ,2.4115e-06 ,2.4271e-06 ,2.4836e-06 ,2.6470e-06 , &
     &2.9559e-06 ,2.3940e-06 ,2.9711e-06 ,2.9511e-06 /)
      forrefo(2,:) = (/ &
     &6.5125e-07 ,1.2128e-06 ,1.7249e-06 ,2.7126e-06 ,3.1780e-06 ,2.1444e-06 , &
     &1.8265e-06 ,1.7385e-06 ,1.4574e-06 ,1.6135e-06 ,2.4966e-06 ,2.8127e-06 , &
     &2.5229e-06 ,2.3251e-06 ,2.5353e-06 ,3.0200e-06 /)
      forrefo(3,:) = (/ &
     &1.4969e-06 ,1.8516e-06 ,2.5791e-06 ,2.7846e-06 ,1.9789e-06 ,1.6688e-06 , &
     &1.1037e-06 ,9.9065e-07 ,1.1557e-06 ,7.0847e-07 ,5.7758e-07 ,4.0425e-07 , &
     &3.2427e-07 ,3.2267e-07 ,3.1444e-07 ,2.6046e-07 /)
      forrefo(4,:) = (/ &
     &1.7567e-06 ,1.6891e-06 ,2.1003e-06 ,2.0957e-06 ,2.3664e-06 ,2.1538e-06 , &
     &1.5275e-06 ,1.0487e-06 ,8.7390e-07 ,7.9360e-07 ,7.7778e-07 ,8.1445e-07 , &
     &8.2121e-07 ,5.4395e-07 ,3.1273e-07 ,3.1848e-07 /)

!     The array SELFREFO contains the coefficient of the water vapor
!     self-continuum (including the energy term).  The first index
!     refers to temperature in 7.2 degree increments.  For instance,
!     JT = 1 refers to a temperature of 245.6, JT = 2 refers to 252.8,
!     etc.  The second index runs over the g-channel (1 to 16).

      selfrefo(:, 1) = (/ &
     & 7.73921e-02 , 6.45225e-02 , 5.37930e-02 , 4.48477e-02 , 3.73900e-02 , &
     & 3.11723e-02 , 2.59887e-02 , 2.16670e-02 , 1.80640e-02 , 1.50601e-02 /)
      selfrefo(:, 2) = (/ &
     & 8.47756e-02 , 7.10616e-02 , 5.95660e-02 , 4.99301e-02 , 4.18529e-02 , &
     & 3.50824e-02 , 2.94072e-02 , 2.46500e-02 , 2.06624e-02 , 1.73199e-02 /)
      selfrefo(:, 3) = (/ &
     & 8.84829e-02 , 7.46093e-02 , 6.29110e-02 , 5.30469e-02 , 4.47295e-02 , &
     & 3.77161e-02 , 3.18025e-02 , 2.68160e-02 , 2.26114e-02 , 1.90661e-02 /)
      selfrefo(:, 4) = (/ &
     & 9.27003e-02 , 7.88864e-02 , 6.71310e-02 , 5.71273e-02 , 4.86144e-02 , &
     & 4.13700e-02 , 3.52052e-02 , 2.99590e-02 , 2.54946e-02 , 2.16955e-02 /)
      selfrefo(:, 5) = (/ &
     & 9.14315e-02 , 7.85661e-02 , 6.75110e-02 , 5.80115e-02 , 4.98487e-02 , &
     & 4.28344e-02 , 3.68072e-02 , 3.16280e-02 , 2.71776e-02 , 2.33534e-02 /)
      selfrefo(:, 6) = (/ &
     & 7.72984e-02 , 6.91044e-02 , 6.17790e-02 , 5.52301e-02 , 4.93755e-02 , &
     & 4.41414e-02 , 3.94622e-02 , 3.52790e-02 , 3.15392e-02 , 2.81959e-02 /)
      selfrefo(:, 7) = (/ &
     & 7.46998e-02 , 6.66597e-02 , 5.94850e-02 , 5.30825e-02 , 4.73691e-02 , &
     & 4.22707e-02 , 3.77210e-02 , 3.36610e-02 , 3.00380e-02 , 2.68049e-02 /)
      selfrefo(:, 8) = (/ &
     & 7.59386e-02 , 6.66263e-02 , 5.84560e-02 , 5.12876e-02 , 4.49982e-02 , &
     & 3.94801e-02 , 3.46387e-02 , 3.03910e-02 , 2.66642e-02 , 2.33944e-02 /)
      selfrefo(:, 9) = (/ &
     & 7.26921e-02 , 6.43261e-02 , 5.69230e-02 , 5.03719e-02 , 4.45747e-02 , &
     & 3.94447e-02 , 3.49051e-02 , 3.08880e-02 , 2.73332e-02 , 2.41875e-02 /)
      selfrefo(:,10) = (/ &
     & 7.43684e-02 , 6.58735e-02 , 5.83490e-02 , 5.16840e-02 , 4.57803e-02 , &
     & 4.05509e-02 , 3.59189e-02 , 3.18160e-02 , 2.81818e-02 , 2.49626e-02 /)
      selfrefo(:,11) = (/ &
     & 8.97599e-02 , 7.73727e-02 , 6.66950e-02 , 5.74908e-02 , 4.95569e-02 , &
     & 4.27179e-02 , 3.68227e-02 , 3.17410e-02 , 2.73606e-02 , 2.35848e-02 /)
      selfrefo(:,12) = (/ &
     & 9.12262e-02 , 7.84848e-02 , 6.75230e-02 , 5.80922e-02 , 4.99786e-02 , &
     & 4.29982e-02 , 3.69927e-02 , 3.18260e-02 , 2.73809e-02 , 2.35567e-02 /)
      selfrefo(:,13) = (/ &
     & 9.03254e-02 , 7.83291e-02 , 6.79260e-02 , 5.89046e-02 , 5.10813e-02 , &
     & 4.42970e-02 , 3.84139e-02 , 3.33120e-02 , 2.88877e-02 , 2.50511e-02 /)
      selfrefo(:,14) = (/ &
     & 9.22803e-02 , 7.94172e-02 , 6.83470e-02 , 5.88199e-02 , 5.06209e-02 , &
     & 4.35647e-02 , 3.74921e-02 , 3.22660e-02 , 2.77684e-02 , 2.38977e-02 /)
      selfrefo(:,15) = (/ &
     & 9.36819e-02 , 8.10810e-02 , 7.01750e-02 , 6.07359e-02 , 5.25665e-02 , &
     & 4.54959e-02 , 3.93764e-02 , 3.40800e-02 , 2.94960e-02 , 2.55286e-02 /)
      selfrefo(:,16) = (/ &
     & 1.00195e-01 , 8.58713e-02 , 7.35950e-02 , 6.30737e-02 , 5.40566e-02 , &
     & 4.63286e-02 , 3.97054e-02 , 3.40290e-02 , 2.91641e-02 , 2.49948e-02 /)

      end subroutine lw_kgb06
