      REAL        AIRMW, H2OMW, LICE, RUNIV, RDRY, RH2O
      PARAMETER ( AIRMW  = 28.97      )  
      PARAMETER ( H2OMW  = 18.01      )  
      PARAMETER ( LICE   = 2.834e6    )
      PARAMETER ( RUNIV  = 8314.3     )  
      PARAMETER ( RDRY   = RUNIV/AIRMW)
      PARAMETER ( RH2O   = RUNIV/H2OMW)

      REAL        ESFAC, ERFAC
      PARAMETER ( ESFAC = RDRY/RH2O       )
      PARAMETER ( ERFAC = (1.0-ESFAC)/ESFAC )

      REAL        MAX_MIXING_RATIO
      PARAMETER ( MAX_MIXING_RATIO = 1.   )

      REAL TMIN, TMAX, ZEROC, TMIX
      REAL TSTARR1, TSTARR2, TSTARR3, TSTARR4
      PARAMETER ( ZEROC   = 273.16 )
      PARAMETER ( TMIN    = -95. )
      PARAMETER ( TSTARR1 = -75. )
      PARAMETER ( TSTARR2 = -65. )
      PARAMETER ( TSTARR3 = -50. )
      PARAMETER ( TSTARR4 = -40. )
      PARAMETER ( TMIX    = -20. )
      PARAMETER ( TMAX    = +60. )

      REAL       B0, B1, B2, B3, B4, B5, B6
      PARAMETER (B6= 6.136820929E-11*ESFAC)
      PARAMETER (B5= 2.034080948E-8 *ESFAC)
      PARAMETER (B4= 3.031240396E-6 *ESFAC)
      PARAMETER (B3= 2.650648471E-4 *ESFAC)
      PARAMETER (B2= 1.428945805E-2 *ESFAC)
      PARAMETER (B1= 4.436518521E-1 *ESFAC)
      PARAMETER (B0= 6.107799961E+0 *ESFAC)
 
      REAL BI0, BI1, BI2, BI3, BI4, BI5, BI6
      PARAMETER (BI6= 1.838826904E-10*ESFAC)
      PARAMETER (BI5= 4.838803174E-8 *ESFAC)
      PARAMETER (BI4= 5.824720280E-6 *ESFAC)
      PARAMETER (BI3= 4.176223716E-4 *ESFAC)
      PARAMETER (BI2= 1.886013408E-2 *ESFAC)
      PARAMETER (BI1= 5.034698970E-1 *ESFAC)
      PARAMETER (BI0= 6.109177956E+0 *ESFAC)
      
      REAL S10, S11, S12, S13, S14, S15, S16
      PARAMETER (S16= 0.516000335E-11*ESFAC)
      PARAMETER (S15= 0.276961083E-8 *ESFAC)
      PARAMETER (S14= 0.623439266E-6 *ESFAC)
      PARAMETER (S13= 0.754129933E-4 *ESFAC)
      PARAMETER (S12= 0.517609116E-2 *ESFAC)
      PARAMETER (S11= 0.191372282E+0 *ESFAC)
      PARAMETER (S10= 0.298152339E+1 *ESFAC)
      
      REAL S20, S21, S22, S23, S24, S25, S26
      PARAMETER (S26= 0.314296723E-10*ESFAC)
      PARAMETER (S25= 0.132243858E-7 *ESFAC)
      PARAMETER (S24= 0.236279781E-5 *ESFAC)
      PARAMETER (S23= 0.230325039E-3 *ESFAC)
      PARAMETER (S22= 0.129690326E-1 *ESFAC)
      PARAMETER (S21= 0.401390832E+0 *ESFAC)
      PARAMETER (S20= 0.535098336E+1 *ESFAC)
