[![License](https://img.shields.io/badge/License-MIT-blue.svg)](https://github.com/geoschem/geos-chem/blob/master/LICENSE.txt)

# README for the HEMCO source code repository

This repository (https://github.com/geoschem/HEMCO) contains the Harvard-NASA Emissions Component (HEMCO) source code. HEMCO is a software component for computing (atmospheric) emissions from different sources, regions, and species on a user-defined grid. It can combine, overlay, and update a set of data inventories ('base emissions') and scale factors, as specified by the user through the HEMCO configuration file. Emissions that depend on environmental variables and non-linear  parameterizations are calculated in separate HEMCO extensions. HEMCO can be run in standalone mode or coupled to an atmospheric model. A more detailed description of HEMCO is given in Keller et al. (2014).

## Documentation

### Reference

C. A. Keller, M. S. Long, R. M. Yantosca, A. M. Da Silva, S. Pawson, D. J. Jacob, *HEMCO v1.0: a versatile,
ESMF-compliant component for calculation emissions in atmospheric models*, <u>Geosci. Model Dev.</u>, **7**, 1409-1417, 2014.

### Website

  * [HEMCO wiki page](http://wiki.seas.harvard.edu/geos-chem/index.php/HEMCO)

### Online user's manual

  * [The HEMCO User's Guide](http://wiki.seas.harvard.edu/geos-chem/index.php/The_HEMCO_User%27s_Guide)


## Support

You are encouraged use the Github issue tracker attached to this repository to report  bugs or technical issues with the HEMCO code.

You are also invited to direct HEMCO support requests to the GEOS-Chem Support Team at geos-chem-support@g.harvard.edu.

## License

HEMCO is distributed under the MIT license. Please see the license documents LICENSE.txt and AUTHORS.txt in the root folder.


26 Sep 2019
GEOS-Chem Support Team
geos-chem-support@g.harvard.edu
