
!=============================================================================
!
! $Id$
!
! CODE DEVELOPER
!   Philip Cameron-Smith, LLNL
!   cameronsmith1@llnl.gov
!
! FILE
!   gmi_lwi_data_64.h
!
! DESCRIPTION
!   This include file sets the LWI (land, water, ice) flag data from CCM3.
!   There are 64 latitudes, and 128 longitudes.
!
!   These flags show whether over land, water, or ice:
!
!     lwi_flags(i,j) = 1 for water
!     lwi_flags(i,j) = 2 for land
!     lwi_flags(i,j) = 3 for ice
!
!=============================================================================


      integer, parameter ::  &
     &  L64I1 =   1,  &
     &  L64I2 = 128,  &
     &  L64J1 =   1,  &
     &  L64J2 =  64


      integer :: lwi_data_64(L64I1:L64I2, L64J1:L64J2)


      data  lwi_data_64 /  &
     &   99*3, 99*3, 99*3, 99*3, 99*3, 99*3, 99*3, 99*3, 99*3, 99*3,  &
     &   85*3,  1*1, 35*3, 16*1, 25*3,  6*1,  6*3, 98*1, 14*3, 99*1,  &
     &   18*1, 10*3, 99*1, 99*1, 38*1,  2*2, 99*1, 26*1,  2*2, 99*1,  &
     &   27*1,  3*2, 83*1,  1*2, 41*1,  3*2, 84*1,  1*2, 41*1,  3*2,  &
     &   99*1, 25*1,  4*2, 73*1,  3*2, 48*1,  6*2, 62*1,  1*2,  6*1,  &
     &    5*2, 49*1,  6*2, 26*1,  4*2, 31*1, 13*2, 48*1,  7*2, 24*1,  &
     &    6*2, 29*1, 14*2, 48*1,  8*2, 23*1,  6*2, 29*1, 14*2, 48*1,  &
     &    8*2, 23*1,  7*2,  3*1,  2*2, 23*1, 13*2, 49*1, 10*2, 20*1,  &
     &    8*2,  3*1,  2*2, 24*1, 12*2, 50*1, 10*2, 19*1,  9*2,  2*1,  &
     &    2*2, 26*1,  9*2, 50*1, 12*2, 18*1, 10*2,  2*1,  1*2, 27*1,  &
     &    4*2,  2*1,  1*2, 50*1, 13*2, 18*1, 10*2, 32*1,  2*2, 52*1,  &
     &   14*2, 18*1, 10*2, 86*1, 15*2, 17*1,  9*2, 25*1,  1*2, 10*1,  &
     &    3*2, 47*1, 16*2, 17*1, 10*2, 22*1,  1*2, 10*1,  4*2, 48*1,  &
     &   15*2, 17*1, 11*2, 21*1,  2*2,  2*1,  2*2,  1*1,  1*2,  3*1,  &
     &    1*2, 52*1, 12*2, 20*1, 13*2, 19*1,  1*2,  3*1,  3*2, 57*1,  &
     &   11*2, 20*1, 15*2, 18*1,  1*2,  4*1,  2*2, 58*1,  9*2, 18*1,  &
     &   18*2, 11*1,  1*2, 71*1,  7*2, 16*1, 23*2,  9*1,  1*2,  9*1,  &
     &    1*2, 63*1,  5*2, 16*1, 21*2, 11*1,  2*2,  6*1,  4*2, 59*1,  &
     &    1*2, 24*1, 20*2,  1*1,  3*2,  8*1,  2*2,  6*1,  4*2,  4*1,  &
     &    1*2, 51*1,  4*2, 23*1, 20*2,  1*1,  6*2,  5*1,  4*2,  4*1,  &
     &    4*2, 54*1,  5*2,  6*1,  1*2, 19*1, 19*2,  1*1,  7*2,  4*1,  &
     &    6*2,  1*1,  7*2, 51*1,  3*2,  3*1,  1*2, 24*1, 19*2,  1*1,  &
     &    8*2,  3*1, 17*2,  1*1,  1*2, 46*1,  4*2, 29*1, 23*2,  2*1,  &
     &   23*2, 46*1,  5*2,  5*1,  1*2, 24*1, 48*2, 44*1,  7*2,  1*1,  &
     &    1*2,  2*1,  1*2, 25*1,  9*2,  2*1,  1*2,  4*1, 31*2, 43*1,  &
     &   13*2, 25*1,  7*2,  9*1, 30*2,  4*1,  3*2, 36*1, 15*2, 25*1,  &
     &    2*2,  8*1,  1*2,  1*1,  8*2,  2*1, 23*2,  2*1,  1*2,  4*1,  &
     &    1*2, 34*1, 17*2, 24*1,  3*2,  5*1, 12*2,  1*1, 27*2,  4*1,  &
     &    1*2, 33*1, 19*2, 22*1,  6*2,  1*1,  7*2,  4*1,  3*2,  1*1,  &
     &   30*2,  2*1,  1*2, 32*1, 20*2, 22*1,  1*2,  1*1, 18*2,  2*1,  &
     &   30*2, 34*1, 22*2, 22*1, 51*2, 33*1, 22*2,  2*1,  1*2, 18*1,  &
     &    2*2,  1*1, 49*2,  5*1,  1*2, 26*1, 26*2, 18*1,  1*2,  3*1,  &
     &    3*2,  1*1, 43*2,  1*3,  5*1,  2*2, 24*1, 17*2,  2*3,  7*2,  &
     &   19*1,  1*2,  5*1,  2*2,  2*1, 41*2,  3*3,  4*1,  1*2, 11*1,  &
     &    1*3,  2*1,  1*2,  7*1, 16*2,  4*3,  1*1,  5*2,  1*3, 20*1,  &
     &    1*2,  2*1,  5*2,  2*1, 47*2,  2*3,  2*2,  8*1,  2*3,  6*2,  &
     &    1*1, 18*2,  6*3,  3*2,  3*3,  5*1,  1*3, 18*1,  4*2,  1*1,  &
     &   56*2,  6*3, 26*2,  8*3,  1*2,  3*3,  3*1,  3*2, 19*1, 99*3,  &
     &    4*3,  2*1, 10*3,  1*1,  2*3, 11*1,  8*3,  5*1, 89*3,  1*1,  &
     &   13*3, 26*1, 99*3,  6*3, 10*1,  2*3, 10*1, 99*3,  8*3,  8*1,  &
     &   99*3, 99*3, 99*3, 99*3, 99*3, 99*3, 40*3 /

