!=======================================================================
!
! $Id$
!
! CODE DEVELOPER
!   Peter Connell, LLNL
!   connell2@llnl.gov
!
! FILE
!   setkin_smv2.h
!
! DESCRIPTION
!   This include file contains the primary description of the chemical
!   mechanism in the form of SMV2 data statements.
!
!  Chemistry input file:    08/2018
!  Reaction dictionary:     GMI_Combo_rxns_119species_SO2_JPL15_OCS.db
!  Setkin files generated:  Tue Sep 18 18:25:41 2018
!
!=======================================================================
!
!.... Species names
!

      data (NAMESP2(JGAS,1), JGAS = 0, 50) / &
     & "              ", "          CH2O", "           CH4",  & 
     & "            CO", "             H", "            H2",  & 
     & "         HCOOH", "          HNO2", "          HNO3",  & 
     & "          HNO4", "           H2O", "           HO2",  & 
     & "          H2O2", "           MO2", "           MOH",  & 
     & "            MP", "             N", "           N2O",  & 
     & "            NO", "           NO2", "           NO3",  & 
     & "          N2O5", "             O", "           O1D",  & 
     & "            O3", "            OH", "            Br",  & 
     & "          BrCl", "           BrO", "        BrONO2",  & 
     & "           HBr", "          HOBr", "            Cl",  & 
     & "           Cl2", "           ClO", "         Cl2O2",  & 
     & "        ClONO2", "           HCl", "          HOCl",  & 
     & "          OClO", "         CH3Br", "         CH3Cl",  & 
     & "       CH3CCl3", "          CCl4", "         CFCl3",  & 
     & "        CF2Cl2", "        CFC113", "        CFC114",  & 
     & "        CFC115", "        HCFC22", "      HCFC141b" /

      data (NAMESP2(JGAS,1), JGAS = 51, 101) / &
     & "      HCFC142b", "        CF2Br2", "       CF2ClBr",  & 
     & "         CF3Br", "         H2402", "          A3O2",  & 
     & "          ACTA", "          ALD2", "          ALK4",  & 
     & "          ATO2", "          B3O2", "          C2H6",  & 
     & "          C3H8", "           EOH", "          ETO2",  & 
     & "           ETP", "          GLYC", "          GLYX",  & 
     & "           HAC", "          IALD", "          IAO2",  & 
     & "           IAP", "          INO2", "          INPN",  & 
     & "          ISN1", "          ISNP", "          ISOP",  & 
     & "           KO2", "          MACR", "          MAN2",  & 
     & "          MAO3", "          MAOP", "           MAP",  & 
     & "          MCO3", "           MEK", "          MGLY",  & 
     & "          MRO2", "           MRP", "           MVK",  & 
     & "           PAN", "           PMN", "           PO2",  & 
     & "            PP", "           PPN", "          PRN1",  & 
     & "          PRPE", "          PRPN", "          R4N1",  & 
     & "          R4N2", "          R4O2", "           R4P" /

      data (NAMESP2(JGAS,1), JGAS = 102, 117) / &
     & "          RA3P", "          RB3P", "          RCHO",  & 
     & "          RCO3", "         RCOOH", "          RIO1",  & 
     & "          RIO2", "           RIP", "           ROH",  & 
     & "            RP", "          VRO2", "           VRP",  & 
     & "          OCSg", "          ACET", "            N2",  & 
     & "            O2" /
!
!.... Species indices for user within SMVGEAR
!
      IH2O      = 10
      INITROGEN = 116
      IOXYGEN   = 117
      IMGAS     = 118
!
!.... O2, N2, and M appear as reactants
!
      NMN2(1)   =  1
      NMO2(1)   =  4
      NMAIR(1)  =  0
      NM3BOD(1) =  0

      NREACN2(1, 1) = 3

      NREACO2(1:4, 1) = (/ 1 ,4 ,21 ,48 /)

      NREACAIR(:,:) = 0
      NREAC3B (:,:) = 0
      LGAS3BOD(:,:) = 0
!
!.... Species indices in thermal reactions
!
      data (IRM(1, i, 1), i=1,150) / &
     &   22,    22,    23,    23,    23,    23,    10,     5,    17,    17,   & 
     &    2,     2,     2,    23,    23,    23,    23,    23,    23,    23,   & 
     &    4,     4,    22,    11,     4,    18,    24,    11,    19,    25,   & 
     &   25,    11,    12,    11,    11,    10,     5,     3,     2,    13,   & 
     &   13,    11,    13,    13,    15,    15,     1,    16,    16,    19,   & 
     &   20,    19,     8,    18,     7,    11,     9,     9,    11,    18,   & 
     &   20,    19,    21,     6,    14,    19,     1,    24,     5,    12,   & 
     &   11,    11,    22,    25,    25,    11,    11,    18,    19,    34,   & 
     &   34,    34,    34,    35,    25,    25,    22,    25,    32,    24,   & 
     &   11,     1,    22,    11,    18,    19,    28,    28,    28,    28,   & 
     &   25,     1,     2,     1,    25,    25,    25,    25,    25,    32,   & 
     &   25,    11,    13,    18,    25,    25,    20,    25,    20,    25,   & 
     &   11,    60,    60,    13,    18,    11,    61,    61,    13,    18,   & 
     &   20,    25,    32,    25,    25,    25,    65,    65,    18,    25,   & 
     &   25,    25,    20,    25,    25,    25,    11,    11,    11,    24 /

      data (IRM(1, i, 1), i=151,300) / &
     &   25,    11,    71,    71,    13,    18,    25,    11,    73,    73,   & 
     &   13,    18,    25,    11,    75,    75,    13,    25,    20,    24,   & 
     &   25,    11,    78,    78,    13,    18,    20,    20,    24,    25,   & 
     &   11,    80,    80,    13,    18,    11,    81,    13,    13,    19,   & 
     &   18,    25,    56,    56,    65,    65,    84,    13,    13,    19,   & 
     &   18,    84,    84,    20,    25,    20,    25,    13,    11,    84,   & 
     &   84,    13,    18,    18,    25,    24,    25,    25,    25,    90,   & 
     &   91,    24,    25,    11,    13,    18,    94,    25,    11,    84,   & 
     &   84,    13,    18,    20,    24,    25,    25,    11,    84,    84,   & 
     &   13,    18,    25,    11,    84,    84,    13,    18,    18,    25,   & 
     &   25,    25,    20,    25,    11,    84,    13,    13,    19,    18,   & 
     &   11,    84,    84,    13,    18,    18,    11,    84,    84,    13,   & 
     &   18,    18,    25,    25,    25,    11,    84,    84,    13,    18,   & 
     &   18,    25,    21,    36,    29,    36,    37,    31,    21,    36,   & 
     &   29,    36,    37,    31,    36,    29,    36,    37,    29,    31 /

      data (IRM(1, i, 1), i=301,312) / &
     &   36,   29,   36,   37,   29,   31,    8,   20,   11,   19,  & 
     &   20,    21 /

      data (IRM(2, i, 1), i=1,150) / &
     &    0,    24,     0,     0,    24,    24,    23,    23,    23,    23,   & 
     &   23,    23,    23,    45,    46,    47,    48,    49,    50,    51,   & 
     &    0,    24,    25,    22,    11,    24,    25,    24,    24,    25,   & 
     &   25,    25,    25,    18,    11,    11,    25,    25,    25,    18,   & 
     &   34,    13,    13,    13,    25,    25,    25,     0,    18,    22,   & 
     &   22,    25,    25,    25,    25,    19,     0,    25,    20,    20,   & 
     &   25,    20,     0,    25,    25,    20,    20,    32,    32,    32,   & 
     &   32,    32,    34,    34,    34,    34,    34,    34,    34,    34,   & 
     &   34,    34,    34,     0,    37,    38,    36,    36,    36,    26,   & 
     &   26,    26,    28,    28,    28,    28,    34,    34,    34,    28,   & 
     &   30,    22,    32,    32,    41,    42,    49,    50,    51,    41,   & 
     &   40,    56,    56,    56,   115,    57,    58,    58,    59,    59,   & 
     &   60,    84,    84,    60,    60,    61,    84,    84,    61,    61,   & 
     &   62,    62,    62,    63,    63,    64,    65,    65,    65,    66,   & 
     &   67,    67,    68,    68,    69,    69,    65,    84,    84,    70 /

      data (IRM(2, i, 1), i=151,300) / &
     &   70,    71,    84,    84,    71,    71,    72,    73,    84,    84,   & 
     &   73,    73,    74,    75,    84,    84,    75,    76,    77,    77,   & 
     &   77,    78,    84,    84,    78,    78,    79,    79,    79,    79,   & 
     &   80,    84,    84,    80,    80,    81,    84,    81,    81,    81,   & 
     &   81,    82,    84,    84,    84,    84,    84,    84,    84,    84,   & 
     &   84,    92,    92,    85,    85,    86,    86,    65,    87,    87,   & 
     &   87,    87,    87,    87,    88,    89,    89,    83,   104,     0,   & 
     &    0,    91,    91,    92,    92,    92,     0,    93,    95,    95,   & 
     &   95,    95,    95,    96,    96,    96,    97,    98,    98,    98,   & 
     &   98,    98,    99,   100,   100,   100,   100,   100,   100,   101,   & 
     &  102,   103,   104,   106,   105,   105,   105,   105,   105,   105,   & 
     &  107,   107,   107,   107,   107,   107,   108,   108,   108,   108,   & 
     &  108,   108,   109,   110,   111,   112,   112,   112,   112,   112,   & 
     &  112,   113,     0,     0,     0,    37,    38,    37,     0,     0,   & 
     &    0,    37,    38,    37,     0,     0,    37,    38,    37,    37 /

      data (IRM(2, i, 1), i=301,312) / &
     &    0,    0,   37,   38,   37,   37,    0,   20,    0,    0,  & 
     &    0,     0 /

      data (IRM(3, i, 1), i=1,150) / &
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,    11,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0 /

      data (IRM(3, i, 1), i=151,300) / &
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0 /

      data (IRM(3, i, 1), i=301,312) / &
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,     0 /

      data (IRM(4, i, 1), i=1,312) / 312*0 /

      data (IRM(5, i, 1), i=1,150) / &
     &   24,   117,   116,    22,   117,    22,    25,     4,   116,    18,   & 
     &   13,     1,     1,    32,    32,    32,    32,    32,    32,    32,   & 
     &   11,   117,     4,   117,    25,    19,    11,   117,    20,    10,   & 
     &   12,    10,    10,    19,    12,    10,     4,     4,    10,     1,   & 
     &    1,    15,     1,     1,    10,     1,     3,    18,   116,    18,   & 
     &   19,     8,    10,     7,    10,     9,    11,    10,    19,    19,   & 
     &   11,    21,    19,    10,     1,    18,     3,    34,     4,    37,   & 
     &   37,    34,    32,    32,    37,    38,    37,    32,    36,    32,   & 
     &   33,    32,    35,    34,    32,    34,    34,    38,    33,    28,   & 
     &   30,     3,    26,    31,    26,    29,    26,    26,    27,    26,   & 
     &   26,     3,    37,     3,    32,    32,    32,    32,    32,     3,   & 
     &   26,   102,     1,    11,    60,    10,     8,     1,     8,   100,   & 
     &   84,    57,     1,     1,     1,   103,   115,   115,   115,   115,   & 
     &   65,    65,    65,    56,    61,    58,    58,    58,    58,    58,   & 
     &    1,     3,     3,     3,    11,    57,    66,    57,    83,     1 /

      data (IRM(5, i, 1), i=151,300) / &
     &   11,    72,    57,     1,     1,     1,    71,    74,     1,    57,   & 
     &    1,     1,    73,    76,    67,    57,     1,    75,    73,     1,   & 
     &  108,    86,    57,    58,    58,    58,    80,     8,     1,    81,   & 
     &   76,     1,    57,     1,     1,     1,     1,     1,     1,    91,   & 
     &    1,    81,    57,    11,    57,    58,    13,    57,     1,    90,   & 
     &   13,    57,    58,     8,    10,     3,     3,    58,    88,    57,   & 
     &    1,     1,     8,     1,    87,    58,   112,     1,    10,    84,   & 
     &   81,     1,     3,    93,    58,    58,    19,    69,    97,    58,   & 
     &   57,    58,    58,    95,    58,    92,    95,    99,    58,    57,   & 
     &   58,    58,    10,   101,    57,    56,    56,    56,    99,    25,   & 
     &   56,   115,     8,    65,    24,    65,     1,     1,    94,    65,   & 
     &  109,    57,     1,     1,     8,     1,   109,    57,     1,     1,   & 
     &    8,     1,    71,    11,    58,     1,    57,     1,     1,     8,   & 
     &    1,    25,     8,     8,     8,    33,    33,    27,     8,     8,   & 
     &    8,    33,    33,    27,     8,     8,    33,    33,    27,    27 /

      data (IRM(5, i, 1), i=301,312) / &
     &    8,    8,   33,   33,   27,   27,   19,   19,   10,    7,  & 
     &    8,     8 /

      data (IRM(6, i, 1), i=1,150) / &
     &    0,     0,    22,   117,     0,   117,     0,    25,   117,     0,   & 
     &   25,     4,     5,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,    25,   117,    25,     0,   117,   117,    25,   117,    22,   & 
     &    0,   117,    11,    25,   117,    12,    10,     0,    13,    11,   & 
     &   32,   117,    14,    11,    13,    10,    10,    22,    22,   117,   & 
     &  117,     0,    20,     0,    19,     0,    19,    19,   117,     0,   & 
     &   19,     0,    20,    11,    11,    19,     8,   117,    37,    11,   & 
     &  117,    25,   117,    11,   117,   117,    24,    19,     0,   117,   & 
     &  117,    39,     0,     0,    10,    10,    20,    20,    20,   117,   & 
     &  117,    30,   117,   117,    19,     0,    39,    32,   117,   117,   & 
     &   10,    11,    13,    37,    10,    10,    10,    10,    10,    37,   & 
     &   10,     0,    11,    19,    10,    13,    84,     3,   100,     0,   & 
     &   13,    85,    11,    69,    84,     0,    57,    11,     1,    11,   & 
     &    8,    10,    37,     0,     0,    11,    11,    64,    11,    65,   & 
     &    3,     6,     8,    11,    86,     3,     0,    24,     0,    67 /

      data (IRM(6, i, 1), i=151,300) / &
     &   71,     0,    85,     3,     3,     3,    25,     0,     8,    19,   & 
     &    8,     8,     0,     0,    69,    19,    67,    19,     0,     3,   & 
     &    0,    13,    85,    84,     1,    84,     0,    81,     3,    87,   & 
     &    0,    86,    19,    11,    86,     3,    84,    11,   106,     0,   & 
     &    3,     0,   104,    13,    58,    11,     0,     1,    11,     0,   & 
     &   19,    69,     1,    78,    78,     8,    84,     1,     0,    85,   & 
     &    3,     3,     0,     3,     0,     1,     0,    84,   105,    19,   & 
     &   19,    11,    69,     0,     1,     1,   105,    25,     0,     1,   & 
     &   19,     1,     1,     0,     1,     0,     0,     0,     1,    19,   & 
     &    1,     1,    98,     0,    85,   115,   115,   115,     0,   100,   & 
     &   25,    61,   105,     0,   106,    13,    65,   106,     0,    19,   & 
     &    0,    85,    11,    11,     0,    11,     0,    85,    11,    11,   & 
     &    0,    11,   107,   104,    25,    67,    85,    67,    67,     0,   & 
     &   67,   104,     0,    38,    31,     8,    10,    10,     0,    38,   & 
     &   31,     8,    10,    10,    38,    31,     8,    10,     8,    10 /

      data (IRM(6, i, 1), i=301,312) / &
     &   38,   31,    8,   10,    8,   10,   25,  117,    0,    8,  & 
     &    0,     0 /

      data (IRM(7, i, 1), i=1,150) / &
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,    11,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,   117,     0,     0,     0,    19,   & 
     &   11,     0,   117,     0,     0,    25,    11,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,   117,    25,     0,   & 
     &    0,     0,     0,     0,     0,   117,    11,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,    11,     0,     0,     0,     0,     0,   117,     0,     0,   & 
     &    0,    25,     0,    11,    11,     0,     0,     0,     0,    11,   & 
     &   11,     0,    14,   104,     0,     0,     0,    10,     0,     0,   & 
     &    0,     0,    84,    11,    19,     0,     0,    13,    11,    19,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,    19,    25,   & 
     &   68,    25,    11,     0,     0,     6,     0,     0,     0,    68 /

      data (IRM(7, i, 1), i=151,300) / &
     &   81,     0,     0,    67,    67,    67,   104,     0,    11,   104,   & 
     &   11,    11,     0,     0,    13,   104,    69,    25,     0,    11,   & 
     &    0,     0,     0,    13,    11,    19,     0,     0,    11,     0,   & 
     &    0,    13,   104,    86,    19,    82,    13,    84,     0,     0,   & 
     &   84,     0,     0,   104,     0,    13,     0,     0,    13,     0,   & 
     &    0,   104,    11,     0,     0,    84,     0,    64,     0,     0,   & 
     &   69,    69,     0,    69,     0,     3,     0,    25,     0,     0,   & 
     &    0,    19,    19,     0,    69,    11,     0,    92,     0,    13,   & 
     &  104,    11,    19,     0,     3,     0,     0,     0,    13,   104,   & 
     &   11,    19,     0,     0,     0,    58,    58,    58,     0,   104,   & 
     &  104,    25,     0,     0,   111,     0,    11,     0,     0,     0,   & 
     &    0,     0,    70,    70,     0,    70,     0,     0,    70,    70,   & 
     &    0,    70,   108,     0,   105,    11,     0,    11,    11,     0,   & 
     &   11,   112,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0 /

      data (IRM(7, i, 1), i=301,312) / &
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,     0 /

      data (IRM(8, i, 1), i=1,150) / &
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &  117,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,   104,     0,     0,     0,     0,    11,     0,     0,   & 
     &    0,     0,    86,    84,    99,     0,     0,     0,    14,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    6,     0,     0,     0,     0,    13,     0,     0,     0,    69 /

      data (IRM(8, i, 1), i=151,300) / &
     &    0,     0,     0,    68,    68,    68,     0,     0,    79,     0,   & 
     &   79,    79,     0,     0,    19,     0,    11,   104,     0,    79,   & 
     &    0,     0,     0,     0,    84,    99,     0,     0,    86,     0,   & 
     &    0,    19,     0,    14,     0,    13,     0,     0,     0,     0,   & 
     &   13,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,    13,     0,     0,     0,     0,    11,     0,     0,   & 
     &   11,    11,     0,    11,     0,    11,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,    11,    19,     0,     0,     0,    19,   & 
     &    0,    14,     0,     0,     5,     0,     0,     0,    19,     0,   & 
     &   14,   100,     0,     0,     0,    61,    61,    61,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,    13,    85,     0,    19,     0,     0,    79,    79,   & 
     &    0,    79,     0,     0,     0,    84,     0,    84,    84,     0,   & 
     &   84,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0 /

      data (IRM(8, i, 1), i=301,312) / &
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,     0 /

      data (IRM(9, i, 1), i=1,150) / &
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,   110,     0,     0,     0,     0,    84,     0,     0,   & 
     &    0,     0,    13,    86,     0,     0,     0,     0,   110,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &   11,     0,     0,     0,     0,    25,     0,     0,     0,     6 /

      data (IRM(9, i, 1), i=151,300) / &
     &    0,     0,     0,    69,    69,    69,     0,     0,    13,     0,   & 
     &   14,    89,     0,     0,     0,     0,    14,     0,     0,    89,   & 
     &    0,     0,     0,     0,    85,     0,     0,     0,    24,     0,   & 
     &    0,     0,     0,    19,     0,    24,     0,     0,     0,     0,   & 
     &   19,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,    14,     0,     0,   & 
     &   86,    86,     0,    86,     0,    86,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,    14,     0,     0,     0,     0,     0,   & 
     &    0,    19,     0,     0,    11,     0,     0,     0,   100,     0,   & 
     &   19,   104,     0,     0,     0,    65,     1,    65,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,    14,     0,     0,     0,     0,    13,    85,   & 
     &    0,    89,     0,     0,     0,    85,     0,    86,    85,     0,   & 
     &   86,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0 /

      data (IRM(9, i, 1), i=301,312) / &
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,     0 /

      data (IRM(10, i, 1), i=1,150) / &
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,    14,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &   25,     0,     0,     0,     0,     0,     0,     0,     0,    86 /

      data (IRM(10, i, 1), i=151,300) / &
     &    0,     0,     0,    11,    11,     8,     0,     0,    89,     0,   & 
     &   89,    19,     0,     0,     0,     0,    19,     0,     0,    24,   & 
     &    0,     0,     0,     0,    14,     0,     0,     0,    25,     0,   & 
     &    0,     0,     0,   104,     0,    25,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &   13,   110,     0,    19,     0,    24,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,   104,     0,     0,     0,     0,     0,   & 
     &    0,   104,     0,     0,    13,     0,     0,     0,   104,     0,   & 
     &  100,     0,     0,     0,     0,    11,    65,    11,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,   110,     0,     0,     0,     0,    89,    14,   & 
     &    0,    19,     0,     0,     0,    86,     0,    13,    86,     0,   & 
     &   19,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0 /

      data (IRM(10, i, 1), i=301,312) / &
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,     0 /

      data (IRM(11, i, 1), i=1,150) / &
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,    24 /

      data (IRM(11, i, 1), i=151,300) / &
     &    0,     0,     0,    86,    85,    11,     0,     0,    19,     0,   & 
     &   19,     0,     0,     0,     0,     0,   104,     0,     0,    25,   & 
     &    0,     0,     0,     0,   110,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,   110,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,    25,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,   110,     0,     0,     0,     0,     0,   & 
     &    0,   110,     0,     0,    25,     0,     0,     0,     0,     0,   & 
     &  104,     0,     0,     0,     0,    85,    11,    85,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,   107,    89,   & 
     &    0,   107,     0,     0,     0,    25,     0,     0,    14,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0 /

      data (IRM(11, i, 1), i=301,312) / &
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,     0 /

      data (IRM(12, i, 1), i=1,150) / &
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,    25 /

      data (IRM(12, i, 1), i=151,300) / &
     &    0,     0,     0,    13,    86,    86,     0,     0,     0,     0,   & 
     &  104,     0,     0,     0,     0,     0,   110,     0,     0,    96,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &  110,     0,     0,     0,     0,    13,    85,    13,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,   107,   & 
     &    0,     0,     0,     0,     0,   104,     0,     0,   110,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0 /

      data (IRM(12, i, 1), i=301,312) / &
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,     0 /

      data (IRM(13, i, 1), i=1,150) / &
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0 /

      data (IRM(13, i, 1), i=151,300) / &
     &    0,     0,     0,     0,    14,    19,     0,     0,     0,     0,   & 
     &  110,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,   104,    13,    19,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,   110,   & 
     &    0,     0,     0,     0,     0,   113,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0 /

      data (IRM(13, i, 1), i=301,312) / &
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,     0 /

      data (IRM(14, i, 1), i=1,150) / &
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0 /

      data (IRM(14, i, 1), i=151,300) / &
     &    0,     0,     0,     0,   110,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,    14,   104,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0 /

      data (IRM(14, i, 1), i=301,312) / &
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,     0 /

      data (IRM(15, i, 1), i=1,150) / &
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0 /

      data (IRM(15, i, 1), i=151,300) / &
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,   104,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0 /

      data (IRM(15, i, 1), i=301,312) / &
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,     0 /

      data (IRM(16, i, 1), i=1,150) / &
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0 /

      data (IRM(16, i, 1), i=151,300) / &
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,   110,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0 /

      data (IRM(16, i, 1), i=301,312) / &
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,     0 /

!
!.... Stoichiometric coefficients in thermal reactions ....
!
      data (FKOEF(1, i, 1), i=1,312) / &
     & 312*1.0d0 /

      data (FKOEF(2, i, 1), i=1,312) / &
     & 312*1.0d0 /

      data (FKOEF(3, i, 1), i=1,312) / &
     & 312*1.0d0 /

      data (FKOEF(4, i, 1), i=1,312) / &
     & 312*1.0d0 /

      data (FKOEF(5, i, 1), i=1,100) / &
     &  1.000D+00,  2.000D+00,  1.000D+00,  1.000D+00,  2.000D+00,  &
     &  2.000D+00,  2.000D+00,  1.000D+00,  1.000D+00,  2.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  2.000D+00,  3.000D+00,  &
     &  2.000D+00,  1.000D+00,  1.000D+00,  2.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  2.000D+00,  &
     &  1.000D+00,  1.000D+00,  2.000D+00,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  2.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  2.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  2.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  2.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  2.000D+00 /

      data (FKOEF(5, i, 1), i=101,200) / &
     &  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  3.000D+00,  1.000D+00,  2.000D+00,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  7.500D-01,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  5.000D-02,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  2.000D-01,  5.000D-01,  9.600D-01,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  7.500D-01,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  2.000D+00,  1.000D+00,  1.000D+00,  5.000D-01,  &
     &  7.300D-01,  1.000D+00,  2.000D+00,  2.000D+00,  1.000D+00,  &
     &  5.000D-01,  1.000D+00,  1.000D+00,  1.000D+00,  1.200D-01,  &
     &  1.500D-01,  1.000D+00,  1.000D+00,  4.000D-01,  9.500D-01,  &
     &  3.500D-01,  5.000D-01,  1.000D+00,  1.500D-01,  1.000D+00,  &
     &  8.300D-01,  1.500D-01,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  7.500D-01,  5.000D-01,  1.000D+00,  9.000D-01,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  5.000D-01,  &
     &  9.300D-01,  1.000D+00,  1.000D+00,  7.000D-01,  5.300D-01,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  1.250D+00,  1.000D+00,  &
     &  5.900D-01,  1.000D+00,  2.000D+00,  1.000D+00,  1.000D+00,  &
     &  5.000D-01,  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  2.000D+00,  1.000D+00,  1.000D+00,  1.000D+00 /

      data (FKOEF(5, i, 1), i=201,300) / &
     &  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  7.500D-01,  1.000D+00,  1.000D+00,  &
     &  1.700D-01,  1.000D+00,  1.000D+00,  1.700D-01,  1.000D+00,  &
     &  4.000D-02,  1.000D+00,  5.000D-01,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  6.000D-01,  1.000D+00,  1.000D+00,  5.000D-01,  &
     &  1.000D+00,  1.000D+00,  7.900D-01,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  5.000D-01,  1.000D+00,  1.000D+00,  5.000D-01,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  7.500D-01,  1.000D+00,  &
     &  3.800D-01,  7.500D-01,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  5.000D-02,  3.000D-02,  5.000D-02,  1.000D+00,  5.000D-01,  &
     &  5.000D-01,  7.900D-01,  1.000D+00,  1.000D+00,  3.000D-01,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  7.500D-01,  1.130D+00,  1.000D+00,  &
     &  7.500D-01,  1.000D+00,  1.000D+00,  6.900D-01,  1.100D+00,  &
     &  1.000D+00,  6.900D-01,  5.000D-01,  1.000D+00,  5.000D-01,  &
     &  1.000D-01,  1.000D+00,  2.800D-01,  8.900D-01,  1.000D+00,  &
     &  2.800D-01,  5.000D-01,  2.000D+00,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  2.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00 /

      data (FKOEF(5, i, 1), i=301,312) / &
     &  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  2.000D+00,  5.000D-01,  5.000D-01,  &
     &  1.000D+00,  2.000D+00 /

      data (FKOEF(6, i, 1), i=1,100) / &
     &  0.000D+00,  0.000D+00,  1.000D+00,  1.000D+00,  0.000D+00,  &
     &  1.000D+00,  0.000D+00,  1.000D+00,  1.000D+00,  0.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  0.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  0.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  0.000D+00,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  2.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  0.000D+00,  1.000D+00,  0.000D+00,  1.000D+00,  &
     &  0.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  0.000D+00,  &
     &  1.000D+00,  0.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  0.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  0.000D+00,  0.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  0.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00 /

      data (FKOEF(6, i, 1), i=101,200) / &
     &  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  2.000D+00,  &
     &  1.000D+00,  0.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  5.000D-02,  1.000D+00,  0.000D+00,  &
     &  1.000D+00,  1.000D+00,  8.000D-01,  2.000D-01,  9.600D-01,  &
     &  0.000D+00,  1.000D+00,  1.000D+00,  7.500D-01,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  0.000D+00,  0.000D+00,  &
     &  1.000D+00,  2.000D+00,  1.000D+00,  1.000D+00,  5.000D-01,  &
     &  5.000D-01,  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  5.000D-01,  0.000D+00,  1.000D+00,  0.000D+00,  2.800D-01,  &
     &  4.400D-01,  0.000D+00,  1.000D+00,  2.900D-01,  1.500D-01,  &
     &  2.700D-01,  5.000D-01,  0.000D+00,  8.500D-01,  1.000D+00,  &
     &  4.250D-01,  8.500D-01,  0.000D+00,  0.000D+00,  1.000D+00,  &
     &  1.000D+00,  5.000D-01,  5.000D-01,  0.000D+00,  5.000D-02,  &
     &  0.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  7.500D-01,  &
     &  9.300D-01,  0.000D+00,  1.000D+00,  2.000D-01,  4.700D-01,  &
     &  0.000D+00,  1.000D+00,  1.000D+00,  5.000D-01,  1.000D+00,  &
     &  3.900D-01,  1.000D+00,  1.000D+00,  1.000D+00,  0.000D+00,  &
     &  5.000D-01,  0.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  0.000D+00,  1.000D+00,  1.000D+00,  0.000D+00 /

      data (FKOEF(6, i, 1), i=201,300) / &
     &  1.000D+00,  6.500D-01,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  7.500D-01,  0.000D+00,  1.000D+00,  &
     &  8.300D-01,  6.000D-01,  0.000D+00,  8.300D-01,  0.000D+00,  &
     &  8.000D-01,  0.000D+00,  5.000D-01,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  0.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  7.900D-01,  0.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.250D+00,  1.000D+00,  0.000D+00,  5.350D-01,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  3.900D-01,  1.000D+00,  &
     &  9.500D-01,  3.900D-01,  1.000D+00,  0.000D+00,  1.000D+00,  &
     &  3.200D-01,  1.600D-01,  3.200D-01,  0.000D+00,  5.000D-01,  &
     &  5.000D-01,  2.100D-01,  1.000D+00,  0.000D+00,  3.000D-01,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  0.000D+00,  1.000D+00,  &
     &  0.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  0.000D+00,  &
     &  1.000D+00,  0.000D+00,  1.000D+00,  8.640D-01,  9.300D-01,  &
     &  0.000D+00,  8.640D-01,  1.000D-01,  1.000D+00,  5.000D-01,  &
     &  5.800D-01,  1.000D+00,  7.200D-01,  3.600D-01,  0.000D+00,  &
     &  7.200D-01,  5.000D-01,  0.000D+00,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  0.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00 /

      data (FKOEF(6, i, 1), i=301,312) / &
     &  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  0.000D+00,  5.000D-01,  &
     &  0.000D+00,  0.000D+00 /

      data (FKOEF(7, i, 1), i=1,100) / &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  1.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  1.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  1.000D+00,  &
     &  1.000D+00,  0.000D+00,  1.000D+00,  0.000D+00,  0.000D+00,  &
     &  1.000D+00,  1.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  1.000D+00,  1.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  1.000D+00,  1.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  1.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  1.000D+00,  0.000D+00,  0.000D+00 /

      data (FKOEF(7, i, 1), i=101,200) / &
     &  0.000D+00,  1.000D+00,  0.000D+00,  1.000D+00,  1.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  1.000D+00,  &
     &  1.000D+00,  0.000D+00,  2.500D-01,  1.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  1.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  2.000D-01,  3.000D-01,  9.600D-01,  &
     &  0.000D+00,  0.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  1.000D+00,  5.000D-01,  &
     &  1.300D-01,  1.000D+00,  1.000D+00,  0.000D+00,  0.000D+00,  &
     &  5.000D-01,  0.000D+00,  0.000D+00,  0.000D+00,  2.000D-01,  &
     &  4.100D-01,  0.000D+00,  0.000D+00,  2.600D-01,  1.300D-01,  &
     &  2.400D-01,  5.000D-01,  0.000D+00,  8.000D-01,  1.000D+00,  &
     &  9.000D-01,  8.000D-01,  0.000D+00,  0.000D+00,  1.000D+00,  &
     &  1.000D+00,  5.000D-01,  5.000D-01,  0.000D+00,  6.000D-02,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  1.000D+00,  5.000D-01,  &
     &  9.300D-01,  0.000D+00,  0.000D+00,  2.750D-01,  0.000D+00,  &
     &  0.000D+00,  1.000D+00,  1.000D+00,  5.000D-01,  2.000D+00,  &
     &  4.100D-01,  1.000D+00,  1.000D+00,  0.000D+00,  0.000D+00,  &
     &  5.000D-01,  0.000D+00,  0.000D+00,  1.000D+00,  0.000D+00,  &
     &  1.000D+00,  0.000D+00,  0.000D+00,  1.000D+00,  0.000D+00 /

      data (FKOEF(7, i, 1), i=201,300) / &
     &  0.000D+00,  3.500D-01,  1.000D+00,  0.000D+00,  0.000D+00,  &
     &  1.000D+00,  0.000D+00,  2.500D-01,  0.000D+00,  0.000D+00,  &
     &  8.300D-01,  6.000D-01,  0.000D+00,  8.300D-01,  0.000D+00,  &
     &  5.000D-02,  0.000D+00,  5.000D-01,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  1.000D+00,  1.000D+00,  0.000D+00,  1.600D-01,  &
     &  1.000D+00,  0.000D+00,  2.100D-01,  0.000D+00,  1.000D+00,  &
     &  1.000D+00,  5.000D-01,  2.000D+00,  0.000D+00,  4.200D-01,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  1.000D+00,  1.000D+00,  &
     &  5.000D-01,  2.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  3.200D-01,  1.600D-01,  3.200D-01,  0.000D+00,  5.000D-01,  &
     &  5.000D-01,  7.900D-01,  0.000D+00,  0.000D+00,  7.000D-01,  &
     &  0.000D+00,  1.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  1.000D+00,  5.000D-01,  0.000D+00,  &
     &  1.000D+00,  0.000D+00,  0.000D+00,  1.270D-01,  6.000D-02,  &
     &  0.000D+00,  1.270D-01,  4.000D-01,  0.000D+00,  5.000D-01,  &
     &  1.000D-01,  0.000D+00,  2.800D-01,  6.400D-01,  0.000D+00,  &
     &  2.800D-01,  5.000D-01,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00 /

      data (FKOEF(7, i, 1), i=301,312) / &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00 /

      data (FKOEF(8, i, 1), i=1,100) / &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  1.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00 /

      data (FKOEF(8, i, 1), i=101,200) / &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  7.500D-01,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  5.000D-02,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  8.000D-01,  3.000D-01,  4.000D-02,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  2.500D-01,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  1.300D-01,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  5.000D-01,  0.000D+00,  0.000D+00,  0.000D+00,  2.000D-01,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  1.800D-01,  9.000D-02,  &
     &  1.700D-01,  0.000D+00,  0.000D+00,  1.000D-01,  0.000D+00,  &
     &  5.000D-02,  1.000D-01,  0.000D+00,  0.000D+00,  1.000D+00,  &
     &  0.000D+00,  5.000D-01,  5.000D-01,  0.000D+00,  3.870D-01,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  5.000D-01,  &
     &  7.000D-02,  0.000D+00,  0.000D+00,  8.000D-01,  0.000D+00,  &
     &  0.000D+00,  1.000D+00,  0.000D+00,  2.500D-01,  0.000D+00,  &
     &  3.900D-01,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  5.000D-01,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00 /

      data (FKOEF(8, i, 1), i=201,300) / &
     &  0.000D+00,  0.000D+00,  1.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  1.000D+00,  0.000D+00,  0.000D+00,  &
     &  1.000D+00,  1.000D+00,  0.000D+00,  1.000D+00,  0.000D+00,  &
     &  6.000D-02,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  1.000D+00,  &
     &  1.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  1.000D+00,  &
     &  0.000D+00,  2.500D-01,  0.000D+00,  0.000D+00,  6.500D-02,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  1.000D+00,  0.000D+00,  &
     &  2.500D-01,  3.000D-01,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  1.800D-01,  9.000D-02,  1.800D-01,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  1.000D+00,  2.500D-01,  0.000D+00,  &
     &  1.000D+00,  0.000D+00,  0.000D+00,  2.880D-01,  1.400D-01,  &
     &  0.000D+00,  2.880D-01,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  5.800D-01,  0.000D+00,  7.200D-01,  3.600D-01,  0.000D+00,  &
     &  7.200D-01,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00 /

      data (FKOEF(8, i, 1), i=301,312) / &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00 /

      data (FKOEF(9, i, 1), i=1,100) / &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00 /

      data (FKOEF(9, i, 1), i=101,200) / &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  2.500D-01,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  9.500D-01,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  1.000D+00,  5.000D-01,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  2.500D-01,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  7.700D-01,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  1.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  2.000D-01,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  3.600D-01,  1.800D-01,  &
     &  3.300D-01,  0.000D+00,  0.000D+00,  1.000D+00,  0.000D+00,  &
     &  2.500D-01,  5.000D-02,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  2.500D-01,  0.000D+00,  0.000D+00,  1.590D-01,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  2.500D-01,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  2.000D-01,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  1.000D+00,  0.000D+00,  &
     &  1.500D-01,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  1.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00 /

      data (FKOEF(9, i, 1), i=201,300) / &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  2.500D-01,  0.000D+00,  0.000D+00,  &
     &  1.700D-01,  2.500D-01,  0.000D+00,  1.700D-01,  0.000D+00,  &
     &  8.200D-01,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  2.500D-01,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  1.000D+00,  0.000D+00,  0.000D+00,  3.000D-01,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  3.000D-01,  0.000D+00,  &
     &  1.000D+00,  5.700D-01,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  3.200D-01,  7.500D-01,  3.200D-01,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  2.500D-01,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  1.000D+00,  2.500D-01,  &
     &  0.000D+00,  4.020D-01,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  1.900D-01,  0.000D+00,  2.800D-01,  2.500D-01,  0.000D+00,  &
     &  2.800D-01,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00 /

      data (FKOEF(9, i, 1), i=301,312) / &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00 /

      data (FKOEF(10, i, 1), i=1,100) / &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00 /

      data (FKOEF(10, i, 1), i=101,200) / &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  5.000D-01,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  2.300D-01,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  6.000D-01,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  1.000D+00,  1.000D+00,  &
     &  8.000D-02,  0.000D+00,  0.000D+00,  5.000D-02,  0.000D+00,  &
     &  3.000D-02,  1.150D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  1.000D+00,  0.000D+00,  0.000D+00,  1.000D-01,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  2.500D-01,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  2.150D-01,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  2.500D-01,  0.000D+00,  &
     &  4.400D-01,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00 /

      data (FKOEF(10, i, 1), i=201,300) / &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  1.000D+00,  1.500D-01,  0.000D+00,  1.000D+00,  0.000D+00,  &
     &  2.000D-01,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  9.000D-02,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  2.500D-01,  0.000D+00,  0.000D+00,  3.050D-01,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  5.700D-01,  0.000D+00,  &
     &  1.500D-01,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  2.700D-01,  1.600D-01,  2.700D-01,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  2.500D-01,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  4.020D-01,  2.500D-01,  &
     &  0.000D+00,  1.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  1.000D-01,  0.000D+00,  1.000D+00,  1.400D-01,  0.000D+00,  &
     &  1.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00 /

      data (FKOEF(10, i, 1), i=301,312) / &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00 /

      data (FKOEF(11, i, 1), i=1,100) / &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00 /

      data (FKOEF(11, i, 1), i=101,200) / &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  3.000D-01,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  5.800D-01,  2.500D-01,  &
     &  9.200D-01,  0.000D+00,  0.000D+00,  1.500D-01,  0.000D+00,  &
     &  5.750D-01,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  2.500D-01,  0.000D+00,  0.000D+00,  2.700D-01,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  2.500D-01,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  2.500D-01,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00 /

      data (FKOEF(11, i, 1), i=201,300) / &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  8.000D-02,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  2.500D-01,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  2.500D-01,  0.000D+00,  0.000D+00,  1.350D-01,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  5.400D-01,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  1.900D-01,  6.400D-01,  1.900D-01,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  1.360D-01,  2.000D-01,  &
     &  0.000D+00,  1.360D-01,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  6.800D-01,  0.000D+00,  0.000D+00,  2.500D-01,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00 /

      data (FKOEF(11, i, 1), i=301,312) / &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00 /

      data (FKOEF(12, i, 1), i=1,100) / &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00 /

      data (FKOEF(12, i, 1), i=101,200) / &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  1.000D-01,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  1.000D+00,  2.900D-01,  &
     &  5.300D-01,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  2.500D-01,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  2.500D-01,  0.000D+00,  0.000D+00,  7.000D-02,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00 /

      data (FKOEF(12, i, 1), i=201,300) / &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  2.500D-01,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  1.180D+00,  3.500D-01,  1.800D-01,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  7.000D-02,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  3.000D-02,  0.000D+00,  0.000D+00,  2.500D-01,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00 /

      data (FKOEF(12, i, 1), i=301,312) / &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00 /

      data (FKOEF(13, i, 1), i=1,100) / &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00 /

      data (FKOEF(13, i, 1), i=101,200) / &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  2.500D-01,  &
     &  9.200D-01,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  2.500D-01,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00 /

      data (FKOEF(13, i, 1), i=201,300) / &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  1.300D-01,  9.000D-02,  1.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  2.500D-01,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  1.000D-01,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00 /

      data (FKOEF(13, i, 1), i=301,312) / &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00 /

      data (FKOEF(14, i, 1), i=1,100) / &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00 /

      data (FKOEF(14, i, 1), i=101,200) / &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  2.500D-01,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00 /

      data (FKOEF(14, i, 1), i=201,300) / &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  2.500D-01,  1.300D-01,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00 /

      data (FKOEF(14, i, 1), i=301,312) / &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00 /

      data (FKOEF(15, i, 1), i=1,100) / &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00 /

      data (FKOEF(15, i, 1), i=101,200) / &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00 /

      data (FKOEF(15, i, 1), i=201,300) / &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  7.000D-02,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00 /

      data (FKOEF(15, i, 1), i=301,312) / &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00 /

      data (FKOEF(16, i, 1), i=1,100) / &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00 /

      data (FKOEF(16, i, 1), i=101,200) / &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00 /

      data (FKOEF(16, i, 1), i=201,300) / &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  2.500D-01,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00 /

      data (FKOEF(16, i, 1), i=301,312) / &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00 /

!
!.... Species indices in photolysis reactions ....
!
      data (IRM(1, i, 1), i=313,385) / &
     &  117,   24,   24,   18,   17,   19,   12,   15,    1,    1,  & 
     &    8,    7,    9,   20,   20,   21,    9,   33,   39,   35,  & 
     &   38,   36,   36,   27,   28,   31,   29,   41,   43,   42,  & 
     &   44,   45,   46,   47,   48,   50,   51,   40,   54,   52,  & 
     &   55,   53,   58,   90,  104,  115,   85,   67,   68,   68,  & 
     &   68,   86,   89,   89,   79,   69,   74,   97,   66,  102,  & 
     &  103,  101,   93,  111,  109,   72,   76,  113,   88,   82,  & 
     &   99,    83,   114 /

      data (IRM(2, i, 1), i=313,385) / &
     & 73*0 /

      data (IRM(3, i, 1), i=313,385) / &
     & 73*0 /

      data (IRM(4, i, 1), i=313,385) / &
     & 73*0 /

      data (IRM(5, i, 1), i=313,385) / &
     &   22,   22,   23,   16,  116,   18,   25,    1,    3,    3,  & 
     &   19,   18,   20,   19,   18,   19,   11,   32,   34,   32,  & 
     &   32,   32,   34,   26,   26,   26,   26,   32,   32,   32,  & 
     &   32,   32,   32,   32,   32,   32,   32,   26,   26,   26,  & 
     &   26,   26,    3,   84,    3,   84,   65,    1,    3,    3,  & 
     &    1,    3,    3,   81,    1,    1,   11,   11,   58,   11,  & 
     &   11,   11,   11,   58,    1,    3,   11,    1,    1,   11,  & 
     &   56,    13,     3 /

      data (IRM(6, i, 1), i=313,385) / &
     &    0,  117,  117,   22,   23,   22,    0,   11,    4,    5,  & 
     &   25,   25,   25,   24,  117,   20,   19,    0,   22,  117,  & 
     &   25,   20,   19,   32,   22,   25,   20,   13,    0,    0,  & 
     &    0,    0,    0,    0,    0,    0,    0,   13,    0,    0,  & 
     &    0,   32,   11,   19,   65,   13,   84,    3,    5,   11,  & 
     &    3,   11,   96,   13,    3,   11,   19,   19,   11,   25,  & 
     &   25,   25,   25,   11,   11,   67,   19,   67,    3,   25,  & 
     &  115,    25,     0 /

      data (IRM(7, i, 1), i=313,385) / &
     &    0,    0,    0,    0,    0,    0,    0,   25,   11,    0,  & 
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,    0,   13,    0,   11,    0,    0,   11,    0,    0,  & 
     &    0,   84,    0,    0,   11,   84,   25,   25,   25,  104,  & 
     &  104,  104,  104,   25,   70,    5,   25,   11,   69,  104,  & 
     &   58,     0,     0 /

      data (IRM(8, i, 1), i=313,385) / &
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,    0,    0,    0,   84,    0,  104,  104,    0,    0,  & 
     &    0,    0,    0,    0,   79,   69,  104,   84,   11,    0,  & 
     &   61,     0,     0 /

      data (IRM(9, i, 1), i=313,385) / &
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,    0,    0,    0,   86,    0,    0,    0,    0,    0,  & 
     &    0,    0,    0,    0,   89,   11,    0,   86,   86,    0,  & 
     &   65,     0,     0 /

      data (IRM(10, i, 1), i=313,385) / &
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,    0,    0,    0,   25,   86,    0,   25,   25,    0,  & 
     &   11,     0,     0 /

      data (IRM(11, i, 1), i=313,385) / &
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,    0,    0,    0,  107,   25,    0,    0,    0,    0,  & 
     &   85,     0,     0 /

      data (IRM(12, i, 1), i=313,385) / &
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &   13,     0,     0 /

      data (IRM(13, i, 1), i=313,385) / &
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &   19,     0,     0 /

      data (IRM(14, i, 1), i=313,385) / &
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &  104,     0,     0 /

      data (IRM(15, i, 1), i=313,385) / 73*0 /
      data (IRM(16, i, 1), i=313,385) / 73*0 /
!
!.... Stoichiometric coefficients in photolysis reactions ....
!
      data (FKOEF(1, i, 1), i=313,385) / &
     & 73*1.0d0 /

      data (FKOEF(2, i, 1), i=313,385) / &
     & 73*1.0d0 /

      data (FKOEF(3, i, 1), i=313,385) / &
     & 73*1.0d0 /

      data (FKOEF(4, i, 1), i=313,385) / &
     & 73*1.0d0 /

      data (FKOEF(5, i, 1), i=313,385) / &
     &  2.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  2.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  2.000D+00,  1.000D+00,  2.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  4.000D+00,  3.000D+00,  &
     &  3.000D+00,  2.000D+00,  3.000D+00,  2.000D+00,  1.000D+00,  &
     &  2.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  2.000D+00,  &
     &  2.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  2.000D+00,  2.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  2.000D-01,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  6.900D-01,  &
     &  6.700D-01,  1.000D+00,  2.800D-01,  1.700D-01,  1.000D+00,  &
     &  5.000D-02,  1.000D+00,  1.000D+00 /

      data (FKOEF(6, i, 1), i=313,385) / &
     &  0.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  0.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  0.000D+00,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  1.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  2.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  8.640D-01,  &
     &  2.600D-01,  1.000D+00,  7.200D-01,  8.300D-01,  1.000D+00,  &
     &  3.200D-01,  1.000D+00,  0.000D+00 /

      data (FKOEF(7, i, 1), i=313,385) / &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  1.000D+00,  1.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  1.000D+00,  0.000D+00,  1.000D+00,  &
     &  0.000D+00,  0.000D+00,  2.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  1.000D+00,  0.000D+00,  0.000D+00,  1.800D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  1.270D-01,  &
     &  1.900D-01,  1.000D+00,  2.800D-01,  8.300D-01,  1.000D+00,  &
     &  3.200D-01,  0.000D+00,  0.000D+00 /

      data (FKOEF(8, i, 1), i=313,385) / &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  2.000D-01,  &
     &  0.000D+00,  1.000D+00,  1.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  2.880D-01,  &
     &  3.600D-01,  1.000D+00,  7.200D-01,  1.000D+00,  0.000D+00,  &
     &  1.800D-01,  0.000D+00,  0.000D+00 /

      data (FKOEF(9, i, 1), i=313,385) / &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  8.000D-01,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  4.020D-01,  &
     &  1.000D+00,  0.000D+00,  2.800D-01,  1.700D-01,  0.000D+00,  &
     &  3.200D-01,  0.000D+00,  0.000D+00 /

      data (FKOEF(10, i, 1), i=313,385) / &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  1.000D+00,  &
     &  5.800D-01,  0.000D+00,  1.000D+00,  1.000D+00,  0.000D+00,  &
     &  2.700D-01,  0.000D+00,  0.000D+00 /

      data (FKOEF(11, i, 1), i=313,385) / &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  1.360D-01,  &
     &  1.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  1.900D-01,  0.000D+00,  0.000D+00 /

      data (FKOEF(12, i, 1), i=313,385) / &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  1.800D-01,  0.000D+00,  0.000D+00 /

      data (FKOEF(13, i, 1), i=313,385) / &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  1.000D+00,  0.000D+00,  0.000D+00 /

      data (FKOEF(14, i, 1), i=313,385) / &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  1.300D-01,  0.000D+00,  0.000D+00 /

      data (FKOEF(15, i, 1), i=313,385) / 73*0.0d0 /

      data (FKOEF(16, i, 1), i=313,385) / 73*0.0d0 /


!                                  --^--

