! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Hessian File
! 
! Generated by KPP-2.2.3 symbolic chemistry Kinetics PreProcessor
!       (http://www.cs.vt.edu/~asandu/Software/KPP)
! KPP is distributed under GPL, the general public licence
!       (http://www.gnu.org/copyleft/gpl.html)
! (C) 1995-1997, V. Damian & A. Sandu, CGRER, Univ. Iowa
! (C) 1997-2005, A. Sandu, Michigan Tech, Virginia Tech
!     With important contributions from:
!        M. Damian, Villanova University, USA
!        R. Sander, Max-Planck Institute for Chemistry, Mainz, Germany
! 
! File                 : kpp_achem_gas_Hessian.f90
! Time                 : Thu Jun 11 11:33:46 2015
! Working directory    : /gpfsm/dnb32/adarmeno/models/geos-5/heracles-UNSTABLE-DEV_MICROPHYSICS/src/GEOSgcs_GridComp/GEOSgcm_GridComp/GEOSagcm_GridComp/GEOSphV
! Equation file        : kpp_achem_gas.kpp
! Output root filename : kpp_achem_gas
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



MODULE kpp_achem_gas_Hessian

  USE kpp_achem_gas_Parameters
  USE kpp_achem_gas_HessianSP

  IMPLICIT NONE

CONTAINS


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Hessian - function for Hessian (Jac derivative w.r.t. variables)
!   Arguments :
!      V         - Concentrations of variable species (local)
!      F         - Concentrations of fixed species (local)
!      RCT       - Rate constants (local)
!      HESS      - Hessian of Var (i.e. the 3-tensor d Jac / d Var)
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE Hessian ( V, F, RCT, HESS )

! V - Concentrations of variable species (local)
  REAL(kind=dp) :: V(NVAR)
! F - Concentrations of fixed species (local)
  REAL(kind=dp) :: F(NFIX)
! RCT - Rate constants (local)
  REAL(kind=dp) :: RCT(NREACT)
! HESS - Hessian of Var (i.e. the 3-tensor d Jac / d Var)
  REAL(kind=dp) :: HESS(NHESS)

! --------------------------------------------------------
! Note: HESS is represented in coordinate sparse format:
!       HESS(m) = d^2 f_i / dv_j dv_k = d Jac_{i,j} / dv_k
!       where i = IHESS_I(m), j = IHESS_J(m), k = IHESS_K(m).
! --------------------------------------------------------
! Note: d^2 f_i / dv_j dv_k = d^2 f_i / dv_k dv_j,
!       therefore only the terms d^2 f_i / dv_j dv_k
!       with j <= k are computed and stored in HESS.
! --------------------------------------------------------

! Local variables
! D2A - Second derivatives of equation rates
  REAL(kind=dp) :: D2A(1)

! Computation of the second derivatives of equation rates

! Computation of the Jacobian derivative
      
END SUBROUTINE Hessian

! End of Hessian function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! HessTR_Vec - Hessian transposed times user vectors
!   Arguments :
!      HESS      - Hessian of Var (i.e. the 3-tensor d Jac / d Var)
!      U1        - User vector
!      U2        - User vector
!      HTU       - Transposed Hessian times user vectors: (Hess x U2)^T * U1 = [d (Jac^T*U1)/d Var] * U2
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE HessTR_Vec ( HESS, U1, U2, HTU )

! HESS - Hessian of Var (i.e. the 3-tensor d Jac / d Var)
  REAL(kind=dp) :: HESS(NHESS)
! U1 - User vector
  REAL(kind=dp) :: U1(NVAR)
! U2 - User vector
  REAL(kind=dp) :: U2(NVAR)
! HTU - Transposed Hessian times user vectors: (Hess x U2)^T * U1 = [d (Jac^T*U1)/d Var] * U2
  REAL(kind=dp) :: HTU(NVAR)

! Compute the vector HTU =(Hess x U2)^T * U1 = d (Jac^T*U1)/d Var * U2
  HTU(1) = 0
  HTU(2) = 0
  HTU(3) = 0
  HTU(4) = 0
  HTU(5) = 0
      
END SUBROUTINE HessTR_Vec

! End of HessTR_Vec function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Hess_Vec - Hessian times user vectors
!   Arguments :
!      HESS      - Hessian of Var (i.e. the 3-tensor d Jac / d Var)
!      U1        - User vector
!      U2        - User vector
!      HU        - Hessian times user vectors: (Hess x U2) * U1 = [d (Jac*U1)/d Var] * U2
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE Hess_Vec ( HESS, U1, U2, HU )

! HESS - Hessian of Var (i.e. the 3-tensor d Jac / d Var)
  REAL(kind=dp) :: HESS(NHESS)
! U1 - User vector
  REAL(kind=dp) :: U1(NVAR)
! U2 - User vector
  REAL(kind=dp) :: U2(NVAR)
! HU - Hessian times user vectors: (Hess x U2) * U1 = [d (Jac*U1)/d Var] * U2
  REAL(kind=dp) :: HU(NVAR)

! Compute the vector HU =(Hess x U2) * U1 = d (Jac*U1)/d Var * U2
  HU(1) = 0
  HU(2) = 0
  HU(3) = 0
  HU(4) = 0
  HU(5) = 0
      
END SUBROUTINE Hess_Vec

! End of Hess_Vec function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



END MODULE kpp_achem_gas_Hessian

