! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!
! Auxiliary Routines File
!
! Generated by KPP-2.2.4_gc symbolic chemistry Kinetics PreProcessor
!       (http://www.cs.vt.edu/~asandu/Software/KPP)
! KPP is distributed under GPL, the general public licence
!       (http://www.gnu.org/copyleft/gpl.html)
! (C) 1995-1997, V. Damian & A. Sandu, CGRER, Univ. Iowa
! (C) 1997-2005, A. Sandu, Michigan Tech, Virginia Tech
!     With important contributions from:
!        M. Damian, Villanova University, USA
!        R. Sander, Max-Planck Institute for Chemistry, Mainz, Germany
!
! File                 : gckpp_Util.f90
! Time                 : Fri Aug 14 12:21:03 2020
! Working directory    : /n/home05/msulprizio/GC/GCC_13.0.0/src/GEOS-Chem/KPP/fullchem
! Equation file        : gckpp.kpp
! Output root filename : gckpp
!
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



MODULE gckpp_Util

  USE gckpp_Parameters
  IMPLICIT NONE

CONTAINS



! User INLINED Utility Functions

! End INLINED Utility Functions

! Utility Functions from KPP_HOME/util/util
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!
! UTIL - Utility functions
!   Arguments :
!
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

! ****************************************************************
!
! InitSaveData - Opens the data file for writing
!   Parameters :
!
! ****************************************************************

      SUBROUTINE InitSaveData ()

      USE gckpp_Parameters

      open(10, file='gckpp.dat')

      END SUBROUTINE InitSaveData

! End of InitSaveData function
! ****************************************************************

! ****************************************************************
!
! SaveData - Write LOOKAT species in the data file
!   Parameters :
!
! ****************************************************************

      SUBROUTINE SaveData ()

      USE gckpp_Global
      USE gckpp_Monitor

      INTEGER i

      WRITE(10,999) (TIME-TSTART)/3600.D0,  &
                   (C(LOOKAT(i))/CFACTOR, i=1,NLOOKAT)
999   FORMAT(E24.16,100(1X,E24.16))

      END SUBROUTINE SaveData

! End of SaveData function
! ****************************************************************

! ****************************************************************
!
! CloseSaveData - Close the data file
!   Parameters :
!
! ****************************************************************

      SUBROUTINE CloseSaveData ()

      USE gckpp_Parameters

      CLOSE(10)

      END SUBROUTINE CloseSaveData

! End of CloseSaveData function
! ****************************************************************

! ****************************************************************
!
! GenerateMatlab - Generates MATLAB file to load the data file
!   Parameters :
!                It will have a character string to prefix each
!                species name with.
!
! ****************************************************************

      SUBROUTINE GenerateMatlab ( PREFIX )

      USE gckpp_Parameters
      USE gckpp_Global
      USE gckpp_Monitor


      CHARACTER(LEN=8) PREFIX
      INTEGER i

      open(20, file='gckpp.m')
      write(20,*) 'load gckpp.dat;'
      write(20,990) PREFIX
990   FORMAT(A1,'c = gckpp;')
      write(20,*) 'clear gckpp;'
      write(20,991) PREFIX, PREFIX
991   FORMAT(A1,'t=',A1,'c(:,1);')
      write(20,992) PREFIX
992   FORMAT(A1,'c(:,1)=[];')

      do i=1,NLOOKAT
        write(20,993) PREFIX, SPC_NAMES(LOOKAT(i)), PREFIX, i
993     FORMAT(A1,A6,' = ',A1,'c(:,',I2,');')
      end do

      CLOSE(20)

      END SUBROUTINE GenerateMatlab

! End of GenerateMatlab function
! ****************************************************************


! End Utility Functions from KPP_HOME/util/util
! End of UTIL function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!
! Shuffle_user2kpp - function to copy concentrations from USER to KPP
!   Arguments :
!      V_USER    - Concentration of variable species in USER's order
!      V         - Concentrations of variable species (local)
!
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE Shuffle_user2kpp ( V_USER, V )

! V_USER - Concentration of variable species in USER's order
  REAL(kind=dp) :: V_USER(NVAR)
! V - Concentrations of variable species (local)
  REAL(kind=dp) :: V(NVAR)

  V(213) = V_USER(1)
  V(192) = V_USER(2)
  V(188) = V_USER(3)
  V(4) = V_USER(4)
  V(243) = V_USER(5)
  V(105) = V_USER(6)
  V(230) = V_USER(7)
  V(174) = V_USER(8)
  V(235) = V_USER(9)
  V(43) = V_USER(10)
  V(256) = V_USER(11)
  V(115) = V_USER(12)
  V(122) = V_USER(13)
  V(50) = V_USER(14)
  V(159) = V_USER(15)
  V(266) = V_USER(16)
  V(60) = V_USER(17)
  V(258) = V_USER(18)
  V(249) = V_USER(19)
  V(142) = V_USER(20)
  V(111) = V_USER(21)
  V(128) = V_USER(22)
  V(129) = V_USER(23)
  V(51) = V_USER(24)
  V(52) = V_USER(25)
  V(53) = V_USER(26)
  V(54) = V_USER(27)
  V(55) = V_USER(28)
  V(56) = V_USER(29)
  V(74) = V_USER(30)
  V(75) = V_USER(31)
  V(1) = V_USER(32)
  V(2) = V_USER(33)
  V(3) = V_USER(34)
  V(245) = V_USER(35)
  V(240) = V_USER(36)
  V(96) = V_USER(37)
  V(41) = V_USER(38)
  V(209) = V_USER(39)
  V(95) = V_USER(40)
  V(46) = V_USER(41)
  V(168) = V_USER(42)
  V(71) = V_USER(43)
  V(73) = V_USER(44)
  V(261) = V_USER(45)
  V(173) = V_USER(46)
  V(69) = V_USER(47)
  V(219) = V_USER(48)
  V(239) = V_USER(49)
  V(265) = V_USER(50)
  V(99) = V_USER(51)
  V(242) = V_USER(52)
  V(5) = V_USER(53)
  V(91) = V_USER(54)
  V(121) = V_USER(55)
  V(186) = V_USER(56)
  V(92) = V_USER(57)
  V(195) = V_USER(58)
  V(102) = V_USER(59)
  V(214) = V_USER(60)
  V(191) = V_USER(61)
  V(158) = V_USER(62)
  V(57) = V_USER(63)
  V(44) = V_USER(64)
  V(45) = V_USER(65)
  V(257) = V_USER(66)
  V(171) = V_USER(67)
  V(228) = V_USER(68)
  V(260) = V_USER(69)
  V(170) = V_USER(70)
  V(78) = V_USER(71)
  V(79) = V_USER(72)
  V(82) = V_USER(73)
  V(83) = V_USER(74)
  V(253) = V_USER(75)
  V(187) = V_USER(76)
  V(67) = V_USER(77)
  V(76) = V_USER(78)
  V(77) = V_USER(79)
  V(147) = V_USER(80)
  V(215) = V_USER(81)
  V(97) = V_USER(82)
  V(251) = V_USER(83)
  V(236) = V_USER(84)
  V(218) = V_USER(85)
  V(201) = V_USER(86)
  V(118) = V_USER(87)
  V(166) = V_USER(88)
  V(109) = V_USER(89)
  V(167) = V_USER(90)
  V(110) = V_USER(91)
  V(114) = V_USER(92)
  V(116) = V_USER(93)
  V(154) = V_USER(94)
  V(244) = V_USER(95)
  V(126) = V_USER(96)
  V(40) = V_USER(97)
  V(47) = V_USER(98)
  V(37) = V_USER(99)
  V(70) = V_USER(100)
  V(156) = V_USER(101)
  V(172) = V_USER(102)
  V(94) = V_USER(103)
  V(216) = V_USER(104)
  V(133) = V_USER(105)
  V(183) = V_USER(106)
  V(100) = V_USER(107)
  V(112) = V_USER(108)
  V(125) = V_USER(109)
  V(212) = V_USER(110)
  V(148) = V_USER(111)
  V(149) = V_USER(112)
  V(144) = V_USER(113)
  V(221) = V_USER(114)
  V(132) = V_USER(115)
  V(119) = V_USER(116)
  V(205) = V_USER(117)
  V(120) = V_USER(118)
  V(206) = V_USER(119)
  V(106) = V_USER(120)
  V(197) = V_USER(121)
  V(130) = V_USER(122)
  V(131) = V_USER(123)
  V(190) = V_USER(124)
  V(225) = V_USER(125)
  V(224) = V_USER(126)
  V(198) = V_USER(127)
  V(165) = V_USER(128)
  V(162) = V_USER(129)
  V(163) = V_USER(130)
  V(169) = V_USER(131)
  V(113) = V_USER(132)
  V(6) = V_USER(133)
  V(58) = V_USER(134)
  V(222) = V_USER(135)
  V(223) = V_USER(136)
  V(161) = V_USER(137)
  V(134) = V_USER(138)
  V(247) = V_USER(139)
  V(93) = V_USER(140)
  V(180) = V_USER(141)
  V(204) = V_USER(142)
  V(80) = V_USER(143)
  V(7) = V_USER(144)
  V(8) = V_USER(145)
  V(200) = V_USER(146)
  V(150) = V_USER(147)
  V(135) = V_USER(148)
  V(189) = V_USER(149)
  V(220) = V_USER(150)
  V(203) = V_USER(151)
  V(9) = V_USER(152)
  V(10) = V_USER(153)
  V(152) = V_USER(154)
  V(202) = V_USER(155)
  V(11) = V_USER(156)
  V(12) = V_USER(157)
  V(13) = V_USER(158)
  V(14) = V_USER(159)
  V(17) = V_USER(160)
  V(18) = V_USER(161)
  V(20) = V_USER(162)
  V(19) = V_USER(163)
  V(21) = V_USER(164)
  V(22) = V_USER(165)
  V(226) = V_USER(166)
  V(184) = V_USER(167)
  V(123) = V_USER(168)
  V(227) = V_USER(169)
  V(68) = V_USER(170)
  V(241) = V_USER(171)
  V(117) = V_USER(172)
  V(145) = V_USER(173)
  V(176) = V_USER(174)
  V(157) = V_USER(175)
  V(208) = V_USER(176)
  V(182) = V_USER(177)
  V(231) = V_USER(178)
  V(81) = V_USER(179)
  V(211) = V_USER(180)
  V(246) = V_USER(181)
  V(196) = V_USER(182)
  V(42) = V_USER(183)
  V(160) = V_USER(184)
  V(177) = V_USER(185)
  V(124) = V_USER(186)
  V(136) = V_USER(187)
  V(72) = V_USER(188)
  V(23) = V_USER(189)
  V(137) = V_USER(190)
  V(138) = V_USER(191)
  V(229) = V_USER(192)
  V(107) = V_USER(193)
  V(151) = V_USER(194)
  V(164) = V_USER(195)
  V(207) = V_USER(196)
  V(217) = V_USER(197)
  V(181) = V_USER(198)
  V(139) = V_USER(199)
  V(62) = V_USER(200)
  V(59) = V_USER(201)
  V(155) = V_USER(202)
  V(16) = V_USER(203)
  V(38) = V_USER(204)
  V(39) = V_USER(205)
  V(250) = V_USER(206)
  V(264) = V_USER(207)
  V(252) = V_USER(208)
  V(84) = V_USER(209)
  V(15) = V_USER(210)
  V(262) = V_USER(211)
  V(248) = V_USER(212)
  V(263) = V_USER(213)
  V(101) = V_USER(214)
  V(63) = V_USER(215)
  V(254) = V_USER(216)
  V(85) = V_USER(217)
  V(194) = V_USER(218)
  V(193) = V_USER(219)
  V(232) = V_USER(220)
  V(64) = V_USER(221)
  V(210) = V_USER(222)
  V(108) = V_USER(223)
  V(185) = V_USER(224)
  V(103) = V_USER(225)
  V(48) = V_USER(226)
  V(179) = V_USER(227)
  V(175) = V_USER(228)
  V(237) = V_USER(229)
  V(104) = V_USER(230)
  V(98) = V_USER(231)
  V(178) = V_USER(232)
  V(233) = V_USER(233)
  V(234) = V_USER(234)
  V(86) = V_USER(235)
  V(87) = V_USER(236)
  V(88) = V_USER(237)
  V(238) = V_USER(238)
  V(199) = V_USER(239)
  V(140) = V_USER(240)
  V(143) = V_USER(241)
  V(153) = V_USER(242)
  V(146) = V_USER(243)
  V(141) = V_USER(244)
  V(89) = V_USER(245)
  V(255) = V_USER(246)
  V(259) = V_USER(247)
  V(127) = V_USER(248)
  V(65) = V_USER(249)
  V(24) = V_USER(250)
  V(25) = V_USER(251)
  V(26) = V_USER(252)
  V(27) = V_USER(253)
  V(28) = V_USER(254)
  V(29) = V_USER(255)
  V(49) = V_USER(256)
  V(61) = V_USER(257)
  V(90) = V_USER(258)
  V(66) = V_USER(259)
  V(30) = V_USER(260)
  V(31) = V_USER(261)
  V(32) = V_USER(262)
  V(33) = V_USER(263)
  V(34) = V_USER(264)
  V(35) = V_USER(265)

END SUBROUTINE Shuffle_user2kpp

! End of Shuffle_user2kpp function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!
! Shuffle_kpp2user - function to restore concentrations from KPP to USER
!   Arguments :
!      V         - Concentrations of variable species (local)
!      V_USER    - Concentration of variable species in USER's order
!
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE Shuffle_kpp2user ( V, V_USER )

! V - Concentrations of variable species (local)
  REAL(kind=dp) :: V(NVAR)
! V_USER - Concentration of variable species in USER's order
  REAL(kind=dp) :: V_USER(NVAR)

  V_USER(1) = V(213)
  V_USER(2) = V(192)
  V_USER(3) = V(188)
  V_USER(4) = V(4)
  V_USER(5) = V(243)
  V_USER(6) = V(105)
  V_USER(7) = V(230)
  V_USER(8) = V(174)
  V_USER(9) = V(235)
  V_USER(10) = V(43)
  V_USER(11) = V(256)
  V_USER(12) = V(115)
  V_USER(13) = V(122)
  V_USER(14) = V(50)
  V_USER(15) = V(159)
  V_USER(16) = V(266)
  V_USER(17) = V(60)
  V_USER(18) = V(258)
  V_USER(19) = V(249)
  V_USER(20) = V(142)
  V_USER(21) = V(111)
  V_USER(22) = V(128)
  V_USER(23) = V(129)
  V_USER(24) = V(51)
  V_USER(25) = V(52)
  V_USER(26) = V(53)
  V_USER(27) = V(54)
  V_USER(28) = V(55)
  V_USER(29) = V(56)
  V_USER(30) = V(74)
  V_USER(31) = V(75)
  V_USER(32) = V(1)
  V_USER(33) = V(2)
  V_USER(34) = V(3)
  V_USER(35) = V(245)
  V_USER(36) = V(240)
  V_USER(37) = V(96)
  V_USER(38) = V(41)
  V_USER(39) = V(209)
  V_USER(40) = V(95)
  V_USER(41) = V(46)
  V_USER(42) = V(168)
  V_USER(43) = V(71)
  V_USER(44) = V(73)
  V_USER(45) = V(261)
  V_USER(46) = V(173)
  V_USER(47) = V(69)
  V_USER(48) = V(219)
  V_USER(49) = V(239)
  V_USER(50) = V(265)
  V_USER(51) = V(99)
  V_USER(52) = V(242)
  V_USER(53) = V(5)
  V_USER(54) = V(91)
  V_USER(55) = V(121)
  V_USER(56) = V(186)
  V_USER(57) = V(92)
  V_USER(58) = V(195)
  V_USER(59) = V(102)
  V_USER(60) = V(214)
  V_USER(61) = V(191)
  V_USER(62) = V(158)
  V_USER(63) = V(57)
  V_USER(64) = V(44)
  V_USER(65) = V(45)
  V_USER(66) = V(257)
  V_USER(67) = V(171)
  V_USER(68) = V(228)
  V_USER(69) = V(260)
  V_USER(70) = V(170)
  V_USER(71) = V(78)
  V_USER(72) = V(79)
  V_USER(73) = V(82)
  V_USER(74) = V(83)
  V_USER(75) = V(253)
  V_USER(76) = V(187)
  V_USER(77) = V(67)
  V_USER(78) = V(76)
  V_USER(79) = V(77)
  V_USER(80) = V(147)
  V_USER(81) = V(215)
  V_USER(82) = V(97)
  V_USER(83) = V(251)
  V_USER(84) = V(236)
  V_USER(85) = V(218)
  V_USER(86) = V(201)
  V_USER(87) = V(118)
  V_USER(88) = V(166)
  V_USER(89) = V(109)
  V_USER(90) = V(167)
  V_USER(91) = V(110)
  V_USER(92) = V(114)
  V_USER(93) = V(116)
  V_USER(94) = V(154)
  V_USER(95) = V(244)
  V_USER(96) = V(126)
  V_USER(97) = V(40)
  V_USER(98) = V(47)
  V_USER(99) = V(37)
  V_USER(100) = V(70)
  V_USER(101) = V(156)
  V_USER(102) = V(172)
  V_USER(103) = V(94)
  V_USER(104) = V(216)
  V_USER(105) = V(133)
  V_USER(106) = V(183)
  V_USER(107) = V(100)
  V_USER(108) = V(112)
  V_USER(109) = V(125)
  V_USER(110) = V(212)
  V_USER(111) = V(148)
  V_USER(112) = V(149)
  V_USER(113) = V(144)
  V_USER(114) = V(221)
  V_USER(115) = V(132)
  V_USER(116) = V(119)
  V_USER(117) = V(205)
  V_USER(118) = V(120)
  V_USER(119) = V(206)
  V_USER(120) = V(106)
  V_USER(121) = V(197)
  V_USER(122) = V(130)
  V_USER(123) = V(131)
  V_USER(124) = V(190)
  V_USER(125) = V(225)
  V_USER(126) = V(224)
  V_USER(127) = V(198)
  V_USER(128) = V(165)
  V_USER(129) = V(162)
  V_USER(130) = V(163)
  V_USER(131) = V(169)
  V_USER(132) = V(113)
  V_USER(133) = V(6)
  V_USER(134) = V(58)
  V_USER(135) = V(222)
  V_USER(136) = V(223)
  V_USER(137) = V(161)
  V_USER(138) = V(134)
  V_USER(139) = V(247)
  V_USER(140) = V(93)
  V_USER(141) = V(180)
  V_USER(142) = V(204)
  V_USER(143) = V(80)
  V_USER(144) = V(7)
  V_USER(145) = V(8)
  V_USER(146) = V(200)
  V_USER(147) = V(150)
  V_USER(148) = V(135)
  V_USER(149) = V(189)
  V_USER(150) = V(220)
  V_USER(151) = V(203)
  V_USER(152) = V(9)
  V_USER(153) = V(10)
  V_USER(154) = V(152)
  V_USER(155) = V(202)
  V_USER(156) = V(11)
  V_USER(157) = V(12)
  V_USER(158) = V(13)
  V_USER(159) = V(14)
  V_USER(160) = V(17)
  V_USER(161) = V(18)
  V_USER(162) = V(20)
  V_USER(163) = V(19)
  V_USER(164) = V(21)
  V_USER(165) = V(22)
  V_USER(166) = V(226)
  V_USER(167) = V(184)
  V_USER(168) = V(123)
  V_USER(169) = V(227)
  V_USER(170) = V(68)
  V_USER(171) = V(241)
  V_USER(172) = V(117)
  V_USER(173) = V(145)
  V_USER(174) = V(176)
  V_USER(175) = V(157)
  V_USER(176) = V(208)
  V_USER(177) = V(182)
  V_USER(178) = V(231)
  V_USER(179) = V(81)
  V_USER(180) = V(211)
  V_USER(181) = V(246)
  V_USER(182) = V(196)
  V_USER(183) = V(42)
  V_USER(184) = V(160)
  V_USER(185) = V(177)
  V_USER(186) = V(124)
  V_USER(187) = V(136)
  V_USER(188) = V(72)
  V_USER(189) = V(23)
  V_USER(190) = V(137)
  V_USER(191) = V(138)
  V_USER(192) = V(229)
  V_USER(193) = V(107)
  V_USER(194) = V(151)
  V_USER(195) = V(164)
  V_USER(196) = V(207)
  V_USER(197) = V(217)
  V_USER(198) = V(181)
  V_USER(199) = V(139)
  V_USER(200) = V(62)
  V_USER(201) = V(59)
  V_USER(202) = V(155)
  V_USER(203) = V(16)
  V_USER(204) = V(38)
  V_USER(205) = V(39)
  V_USER(206) = V(250)
  V_USER(207) = V(264)
  V_USER(208) = V(252)
  V_USER(209) = V(84)
  V_USER(210) = V(15)
  V_USER(211) = V(262)
  V_USER(212) = V(248)
  V_USER(213) = V(263)
  V_USER(214) = V(101)
  V_USER(215) = V(63)
  V_USER(216) = V(254)
  V_USER(217) = V(85)
  V_USER(218) = V(194)
  V_USER(219) = V(193)
  V_USER(220) = V(232)
  V_USER(221) = V(64)
  V_USER(222) = V(210)
  V_USER(223) = V(108)
  V_USER(224) = V(185)
  V_USER(225) = V(103)
  V_USER(226) = V(48)
  V_USER(227) = V(179)
  V_USER(228) = V(175)
  V_USER(229) = V(237)
  V_USER(230) = V(104)
  V_USER(231) = V(98)
  V_USER(232) = V(178)
  V_USER(233) = V(233)
  V_USER(234) = V(234)
  V_USER(235) = V(86)
  V_USER(236) = V(87)
  V_USER(237) = V(88)
  V_USER(238) = V(238)
  V_USER(239) = V(199)
  V_USER(240) = V(140)
  V_USER(241) = V(143)
  V_USER(242) = V(153)
  V_USER(243) = V(146)
  V_USER(244) = V(141)
  V_USER(245) = V(89)
  V_USER(246) = V(255)
  V_USER(247) = V(259)
  V_USER(248) = V(127)
  V_USER(249) = V(65)
  V_USER(250) = V(24)
  V_USER(251) = V(25)
  V_USER(252) = V(26)
  V_USER(253) = V(27)
  V_USER(254) = V(28)
  V_USER(255) = V(29)
  V_USER(256) = V(49)
  V_USER(257) = V(61)
  V_USER(258) = V(90)
  V_USER(259) = V(66)
  V_USER(260) = V(30)
  V_USER(261) = V(31)
  V_USER(262) = V(32)
  V_USER(263) = V(33)
  V_USER(264) = V(34)
  V_USER(265) = V(35)

END SUBROUTINE Shuffle_kpp2user

! End of Shuffle_kpp2user function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!
! GetMass - compute total mass of selected atoms
!   Arguments :
!      CL        - Concentration of all species (local)
!      Mass      - value of mass balance
!
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE GetMass ( CL, Mass )

! CL - Concentration of all species (local)
  REAL(kind=dp) :: CL(NSPEC)
! Mass - value of mass balance
  REAL(kind=dp) :: Mass(1)


END SUBROUTINE GetMass

! End of GetMass function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

! Get_OHreactivity - returns the OH reactivity
! The OH reactivity is defined as the inverse of its lifetime.
! This routine was auto-generated using script OHreact_parser.py.
! Generated on 2020-08-14
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE Get_OHreactivity ( CC, RR, OHreact )

! CC - Concentrations of species (local)
  REAL(kind=dp) :: CC(NSPEC)
! RR - reaction rates (local)
  REAL(kind=dp) :: RR(NREACT)
! OHreact - OH reactivity [s-1]
  REAL(kind=dp) :: OHreact

  OHreact = RR(2)*CC(263) + 2*RR(6) + 2*RR(7) + RR(8)*CC(251) + RR(9)*CC(171) &
          + RR(12)*CC(242) + RR(13)*CC(168) + RR(19)*CC(124) + RR(20)*CC(124) + RR(21)*CC(174) &
          + RR(22)*CC(174) + RR(23)*CC(245) + RR(24)*CC(264) + RR(25)*CC(215) + RR(26)*CC(250) &
          + RR(27)*CC(147) + RR(30)*CC(97) + RR(33)*CC(252) + RR(36)*CC(187) + RR(37)*CC(196) &
          + RR(40)*CC(243) + RR(45)*CC(142) + RR(49)*CC(111) + RR(50)*CC(111) + RR(54)*CC(105) &
          + RR(64)*CC(233) + RR(65)*CC(188) + RR(66)*CC(238) + RR(71)*CC(192) + RR(80)*CC(231) &
          + RR(90)*CC(121) + RR(91)*CC(141) + RR(101)*CC(237) + RR(103)*CC(214) + RR(104)*CC(214) &
          + RR(106)*CC(191) + RR(107)*CC(211) + RR(110)*CC(228) + RR(111)*CC(228) + RR(118)*CC(104) &
          + RR(119)*CC(102) + RR(120)*CC(87) + RR(121)*CC(88) + RR(122)*CC(86) + RR(123)*CC(89) &
          + RR(124)*CC(103) + RR(125)*CC(20) + RR(126)*CC(68) + RR(151)*CC(91) + RR(152)*CC(91) &
          + RR(154)*CC(127) + RR(158)*CC(260) + RR(163)*CC(115) + RR(166)*CC(266) + RR(175)*CC(71) &
          + RR(176)*CC(74) + RR(177)*CC(96) + RR(189)*CC(267) + RR(190)*CC(262) + RR(195)*CC(63) &
          + RR(230)*CC(173) + RR(232)*CC(265) + RR(233)*CC(265) + RR(234)*CC(101) + RR(235)*CC(69) &
          + RR(236)*CC(253) + RR(237)*CC(218) + RR(238)*CC(219) + RR(239)*CC(239) + RR(240)*CC(95) &
          + RR(241)*CC(75) + RR(242)*CC(73) + RR(243)*CC(41) + RR(244)*CC(83) + RR(245)*CC(79) &
          + RR(246)*CC(82) + RR(247)*CC(78) + RR(313)*CC(126) + RR(314)*CC(67) + RR(315)*CC(201) &
          + RR(322)*CC(46) + RR(323)*CC(186) + RR(324)*CC(175) + RR(338)*CC(43) + RR(339)*CC(49) &
          + RR(340)*CC(90) + RR(348)*CC(137) + RR(349)*CC(138) + RR(359)*CC(152) + RR(367)*CC(108) &
          + RR(381)*CC(160) + RR(382)*CC(177) + RR(388)*CC(118) + RR(389)*CC(81) + RR(390)*CC(92) &
          + RR(391)*CC(80) + RR(392)*CC(84) + RR(394)*CC(200) + RR(395)*CC(200) + RR(396)*CC(200) &
          + RR(397)*CC(200) + RR(424)*CC(166) + RR(425)*CC(167) + RR(426)*CC(114) + RR(427)*CC(116) &
          + RR(428)*CC(170) + RR(429)*CC(156) + RR(430)*CC(100) + RR(431)*CC(140) + RR(432)*CC(140) &
          + RR(433)*CC(143) + RR(434)*CC(143) + RR(435)*CC(140) + RR(436)*CC(143) + RR(437)*CC(153) &
          + RR(438)*CC(146) + RR(451)*CC(106) + RR(452)*CC(119) + RR(453)*CC(119) + RR(454)*CC(120) &
          + RR(455)*CC(120) + RR(474)*CC(130) + RR(475)*CC(130) + RR(476)*CC(131) + RR(477)*CC(131) &
          + RR(478)*CC(197) + RR(479)*CC(197) + RR(480)*CC(190) + RR(481)*CC(190) + RR(482)*CC(197) &
          + RR(483)*CC(190) + RR(521)*CC(161) + RR(522)*CC(134) + RR(523)*CC(161) + RR(524)*CC(134) &
          + RR(525)*CC(134) + RR(526)*CC(161) + RR(527)*CC(134) + RR(528)*CC(134) + RR(537)*CC(216) &
          + RR(538)*CC(216) + RR(541)*CC(221) + RR(544)*CC(229) + RR(546)*CC(226) + RR(547)*CC(226) &
          + RR(550)*CC(217) + RR(551)*CC(207) + RR(552)*CC(208) + RR(553)*CC(176) + RR(554)*CC(157) &
          + RR(561)*CC(145) + RR(562)*CC(139) + RR(563)*CC(107) + RR(564)*CC(164) + RR(565)*CC(151) &
          + RR(566)*CC(117) + RR(572)*CC(123) + RR(584)*CC(136) + RR(585)*CC(77) + RR(586)*CC(183) &
          + RR(587)*CC(112) + RR(588)*CC(125) + RR(589)*CC(144) + RR(590)*CC(189) + RR(591)*CC(220) &
          + RR(593)*CC(98) + RR(594)*CC(76) + RR(596)*CC(154) + RR(597)*CC(154) + RR(598)*CC(16) &
          + RR(611)*CC(255) + RR(612)*CC(259)

END SUBROUTINE Get_OHreactivity
! End of Get_OHreactivity subroutine
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

END MODULE gckpp_Util
