---
name: Report a bug or technical issue
about: Use this template to report bugs and technical issues encountered while using GEOS-Chem.
title: "[BUG/ISSUE]"
labels: bug
assignees: ''

---
# Report a GEOS-Chem bug or technical issue
<!--- STOP!  BEFORE YOU SUBMIT THIS ISSUE, PLEASE READ THE FOLLOWING: -->
<!--- -->
<!--- 1. If this is the first time you are submitting a GEOS-Chem issue via Github, we recommend that you first view -->
<!--- our tutorial videos at this link: https://www.youtube.com/c/geoschem -->
<!--- (a) Submitting GEOS-Chem issues on Github -->
<!--- (b) Subscribing to Github notifications -->
<!--- (c) Searching for GEOS-Chem issues and pull requests -->
<!--- --->
<!--- 2. Only post bug reports in this issue.
<!--- To report ask a general GEOS-Chem question, start a discussion, or add a feature request, please use this link: -->
<!--- https://github.com/geoschem/geos-chem/issues/new/choose -->
<!--- --->
<!--- 3. Contact the GEOS-Chem Working Groups directly for assistance with scientific questions --->
<!--- Please keep in mind that the GEOS-Chem Support Team] focuses primarily on software development and user support -->
<!--- rather than on scientific research. If your question is more scientific in nature (e.g. "What happens if I change -->
<!--- this reaction rate from X to Y?", or "Is emissions inventory A better than inventory B?", etc.), then we recommend -->
<!--- that you contact the relevant GEOS-Chem Working Group for assistance. -->
<!--- -->
<!--- 4. Check to see if your issue has already been resolved -->
<!--- Before submitting a GEOS-Chem bug/issue report, please take a moment to check -->
<!--- if a solution for your issue has already been reported at these links: -->
<!--- (a) https://github.com/geoschem/geos-chem/issues
<!--- (b) http://wiki.geos-chem.org/Guide_to_GEOS-Chem_error_messages -->
<!--- (c) http://wiki.geos-chem.org/Bugs_and_fixes -->
<!--- --->
<!--- 5. Try to resolve the issue yourself -->
<!--- Please see http://wiki.geos-chem.org/Debugging_GEOS-Chem, which contains a checklist of things that you can do -->
<!--- to try to solve your problem yourself. -->

## Describe the bug:

### Expected behavior: ###
<!--- Include a clear and concise description of what you expected to happen. -->

### Actual behavior: ###
<!--- Include a clear and concise description of the bug or issue that you have encountered. -->

### Steps to reproduce: the bug:
<!--- Include the steps that must be done in order to reproduce the observed behavior:

**Compilation commands**
<!--- Please list all the steps you did to to compile GEOS-Chem in the spaces marked by `__`. -->
1.  __
2.  __
3.  __

**Run commands**
<!--- Please list all the steps you did to run GEOS-Chem in the spaces marked by `__`. -->
1.  __
2.  __
3.  __

### Error messages
<!--- Please cut and paste any error message output where it says `add text here`. --->
```
add text here
```

## Required information:

### Your GEOS-Chem version and runtime environment:
<!--- Please supply the requested information in the spaces marked by `__`. -->
 - GEOS-Chem version: __
 - Compiler version: __
 - netCDF version: __
 - netCDF-Fortran version (if applicable): __
 - Did you run on a computational cluster, on the AWS cloud: __
   - If you ran on the AWS cloud, please specify the Amazon Machine Image (AMI) ID: __
 - Are you using GEOS-Chem "out of the box" (i.e. unmodified): __
   - If you have modified GEOS-Chem, please list what was changed: __

### Input and log files to attach
<!--- Please supply the requested information in the spaces marked by `__` -->
<!--- For more info, see: http://wiki.geos-chem.org/Submitting_GEOS-Chem_support_requests -->
<!--- You can drag and drop files to this window and Github will upload them to this issue. --->
<!--- NOTE: Any text files (*.F90, *.rc, input.geos, log files) must have the `.txt` suffix --->
<!--- or Github will not be able to display them. --->
 - lastbuild: __
 - input.geos: __
 - HEMCO_Config.rc: __
 - GEOS-Chem "Classic" log file: __
 - HEMCO.log: __
 - slurm.out or any other error messages from your scheduler: __
 - Any other error messages: __

### Additional context
<!--- Include any other context about the problem here. -->
