module CONVECTION_TL

USE CONVECTION

IMPLICIT NONE

PRIVATE
PUBLIC :: rase_d, rase0_d, rase_tracer_d

CONTAINS

!        Generated by TAPENADE     (INRIA, Tropics team)
!  Tapenade 3.9 (r5096) - 24 Feb 2014 16:53
!
!  Differentiation of rase in forward (tangent) mode:
!   variations   of useful results: clw cnv_prc3 tho qho vho cnv_updfrc
!                uho flxd
!   with respect to varying inputs: tho qho vho uho
!   RW status of diff variables: clw:out cnv_prc3:out tho:in-out
!                qho:in-out vho:in-out cnv_updfrc:out uho:in-out
!                flxd:out
SUBROUTINE RASE_D(idim, irun, k0, icmin, dt, cons_cp, cons_alhl, &
& cons_grav, cons_rgas, cons_h2omw, cons_airmw, cons_vireps, seedras, &
& sige, kcbl, wgt0, wgt1, frland, ts, tho, thod, qho, qhod, uho, uhod, &
& vho, vhod, co_auto, ple, clw, clwd, flxd, flxdd, cnv_prc3, cnv_prc3d, &
& cnv_updfrc, cnv_updfrcd, rasparams, estblx)
  IMPLICIT NONE
!INPUTS
  INTEGER, INTENT(IN) :: idim, irun, k0, icmin
  REAL*8, DIMENSION(idim, k0 + 1), INTENT(IN) :: ple
  REAL*8, DIMENSION(k0 + 1), INTENT(IN) :: sige
  REAL*8, INTENT(IN) :: dt, cons_cp, cons_alhl, cons_grav, cons_rgas
  REAL*8, INTENT(IN) :: cons_h2omw, cons_airmw, cons_vireps
  INTEGER, DIMENSION(idim), INTENT(IN) :: seedras
  INTEGER, DIMENSION(idim), INTENT(IN) :: kcbl
  REAL*8, DIMENSION(idim), INTENT(IN) :: ts, frland
  REAL*8, DIMENSION(idim), INTENT(IN) :: co_auto
  REAL*8, DIMENSION(idim, k0), INTENT(IN) :: wgt0, wgt1
  REAL*8, DIMENSION(:), INTENT(IN) :: rasparams
  REAL*8, DIMENSION(:), INTENT(IN) :: estblx
!OUTPUTS
  REAL*8, DIMENSION(idim, k0), INTENT(OUT) :: clw, flxd
  REAL*8, DIMENSION(idim, k0), INTENT(OUT) :: clwd, flxdd
  REAL*8, DIMENSION(idim, k0), INTENT(OUT) :: cnv_prc3
  REAL*8, DIMENSION(idim, k0), INTENT(OUT) :: cnv_prc3d
  REAL*8, DIMENSION(idim, k0), INTENT(OUT) :: cnv_updfrc
  REAL*8, DIMENSION(idim, k0), INTENT(OUT) :: cnv_updfrcd
!PROGNOSTIC
  REAL*8, DIMENSION(idim, k0), INTENT(INOUT) :: tho, qho, uho, vho
  REAL*8, DIMENSION(idim, k0), INTENT(INOUT) :: thod, qhod, uhod, vhod
!LOCALS
  INTEGER :: i, ic, l, kk, k
!Parameters
  REAL*8, PARAMETER :: onepkap=1.+2./7., daylen=86400.0
  REAL*8, PARAMETER :: rhmax=0.9999
  REAL*8, PARAMETER :: cbl_qpert=0.0, cbl_tpert=1.0
  REAL*8, PARAMETER :: cbl_tpert_mxocn=2.0, cbl_tpert_mxlnd=4.0
!Constants
  REAL*8 :: grav, cp, alhl, cpbg, alhi, cpi, gravi, ddt, lbcp
!Rasparams
  REAL*8 :: fricfac, cli_crit, rasal1, rasal2
  REAL*8 :: friclambda
  REAL*8 :: sdqv2, sdqv3, sdqvt1
  REAL*8 :: acritfac, pblfrac, autorampb
  REAL*8 :: maxdallowed, rhmn, rhmx
  REAL*8 :: mxdiam
  REAL*8 :: tx2, tx3, akm, acr, alm, tth, qqh, dqx
  REAL*8 :: tx2d, tx3d, akmd, almd
  REAL*8 :: wfn, tem, trg, trgexp, evp, wlq, qcc
  REAL*8 :: wfnd, temd, trgd, wlqd, qccd
  REAL*8 :: cli, te_a, c00_x, cli_crit_x, toki
  REAL*8 :: clid, te_ad, c00_xd, cli_crit_xd, tokid
  REAL*8 :: dt_lyr, rate, cvw_x, closs, f2, f3, f4
  REAL*8 :: dt_lyrd, rated, cvw_xd, clossd, f2d
  REAL*8 :: wght0, prcbl, rndu
  REAL*8 :: lambda_min, lambda_max
  REAL*8 :: tpert, qpert
  REAL*8 :: tpertd
  REAL*8 :: uht, vht
  REAL*8 :: uhtd, vhtd
  REAL*8, DIMENSION(k0) :: poi_sv, qoi_sv, uoi_sv, voi_sv
  REAL*8, DIMENSION(k0) :: poi_svd, qoi_svd, uoi_svd, voi_svd
  REAL*8, DIMENSION(k0) :: poi, qoi, uoi, voi, dqq, bet, gam, cll
  REAL*8, DIMENSION(k0) :: poid, qoid, uoid, void0, dqqd, betd, gamd, &
& clld
  REAL*8, DIMENSION(k0) :: poi_c, qoi_c
  REAL*8, DIMENSION(k0) :: poi_cd, qoi_cd
  REAL*8, DIMENSION(k0) :: prh, pri, ght, dpt, dpb, pki
  REAL*8, DIMENSION(k0) :: prhd, prid, ghtd, dptd, dpbd, pkid
  REAL*8, DIMENSION(k0) :: ucu, vcu
  REAL*8, DIMENSION(k0) :: ucud, vcud
  REAL*8, DIMENSION(k0) :: cln, rns, pol
  REAL*8, DIMENSION(k0) :: rnsd, pold
  REAL*8, DIMENSION(k0) :: qst, ssl, rmf, rnn, rn1, rmfc, rmfp
  REAL*8, DIMENSION(k0) :: qstd, ssld, rnnd, rmfpd
  REAL*8, DIMENSION(k0) :: gms, eta, gmh, eht, gm1, hcc, rmfd
  REAL*8, DIMENSION(k0) :: gmsd, etad, gmhd, ehtd, gm1d, hccd, rmfdd
  REAL*8, DIMENSION(k0) :: hol, hst, qol, zol, hcld, cll0, cllx, clli
  REAL*8, DIMENSION(k0) :: hold, hstd, qold, zold, hcldd, cll0d
  REAL*8, DIMENSION(k0) :: bke, cvw, updfrc
  REAL*8, DIMENSION(k0) :: cvwd, updfrcd
  REAL*8, DIMENSION(k0) :: rasal, updfrp, bk2, dll0, dllx
  REAL*8, DIMENSION(k0) :: rasald, updfrpd, bk2d
  REAL*8, DIMENSION(k0) :: wght, massf
  REAL*8, DIMENSION(k0) :: wghtd
  REAL*8, DIMENSION(k0) :: qss, dqs, pf, pk, tempf, zlo
  REAL*8, DIMENSION(k0) :: qssd, dqsd, tempfd, zlod
  REAL*8, DIMENSION(k0 + 1) :: prj, prs, qht, sht, zet, zle, pke
  REAL*8, DIMENSION(k0+1) :: prjd, prsd, qhtd, shtd, zetd, zled
  INTRINSIC MAX
  INTRINSIC MIN
  INTRINSIC SQRT
  INTRINSIC EXP
  INTRINSIC SUM
  REAL*8, DIMENSION(k0+1) :: pwx1
  REAL*8 :: pwy1
  REAL*8, DIMENSION(k0) :: pwx10
  REAL*8 :: pwx11
  REAL*8 :: pwr1
  REAL*8 :: arg1
  REAL*8 :: arg1d
  REAL*8 :: max2d
  REAL*8 :: x1
  REAL*8 :: max1d
  REAL*8 :: x1d
  REAL*8 :: max2
  REAL*8 :: max1
  REAL*8 :: y1
!Initialize Local Arrays
  poi = 0.0
  qoi = 0.0
  uoi = 0.0
  voi = 0.0
  dqq = 0.0
  bet = 0.0
  gam = 0.0
  poi_c = 0.0
  qoi_c = 0.0
  prh = 0.0
  pri = 0.0
  ght = 0.0
  dpt = 0.0
  dpb = 0.0
  pki = 0.0
  ucu = 0.0
  vcu = 0.0
  cln = 0.0
  pol = 0.0
  qst = 0.0
  ssl = 0.0
  rmf = 0.0
  rnn = 0.0
  rn1 = 0.0
  gms = 0.0
  eta = 0.0
  gmh = 0.0
  eht = 0.0
  gm1 = 0.0
  hcc = 0.0
  hol = 0.0
  hst = 0.0
  qol = 0.0
  zol = 0.0
  hcld = 0.0
  bke = 0.0
  cvw = 0.0
  updfrc = 0.0
  rasal = 0.0
  updfrp = 0.0
  bk2 = 0.0
  wght = 0.0
  massf = 0.0
  qss = 0.0
  dqs = 0.0
  pf = 0.0
  pk = 0.0
  tempf = 0.0
  zlo = 0.0
  prj = 0.0
  prs = 0.0
  qht = 0.0
  sht = 0.0
  zet = 0.0
  zle = 0.0
  pke = 0.0
!Initialize Outputs
  cnv_prc3 = 0.
  cnv_updfrc = 0.
  flxd = 0.
  clw = 0.
!  ---  1
  fricfac = rasparams(1)
!  ---  4
  cli_crit = rasparams(4)
!  ---  5
  rasal1 = rasparams(5)
!  ---  6
  rasal2 = rasparams(6)
!  --- 11
  friclambda = rasparams(11)
!  --- 14
  sdqv2 = rasparams(14)
!  --- 15
  sdqv3 = rasparams(15)
!  --- 16
  sdqvt1 = rasparams(16)
!  --- 17
  acritfac = rasparams(17)
!  --- 20
  pblfrac = rasparams(20)
!  --- 21
  autorampb = rasparams(21)
!  --- 24
  rhmn = rasparams(24)
!  --- 24
  maxdallowed = rasparams(23)
!  --- 25
  rhmx = rasparams(25)
  grav = cons_grav
  alhl = cons_alhl
  cp = cons_cp
  cpi = 1.0/cp
  alhi = 1.0/alhl
  gravi = 1.0/grav
  cpbg = cp*gravi
  ddt = daylen/dt
  lbcp = alhl*cpi
  i = 1
!CALL FINDBASE
  k = kcbl(i)
  IF (k .GT. 0) THEN
!Get saturation specific humidity and gradient wrt to T
    pwx1 = ple(i, :)/1000.
    pwy1 = cons_rgas/cons_cp
    pke = pwx1**pwy1
    pf = 0.5*(ple(i, 1:k0)+ple(i, 2:k0+1))
    pwx10 = pf/1000.
    pwy1 = cons_rgas/cons_cp
    pk = pwx10**pwy1
    tempfd = pk*thod(i, :)
    tempf = tho(i, :)*pk
    zle = 0.0
    zlo = 0.0
    zled(k0+1) = 0.0_8
    zle(k0+1) = 0.
    zlod = 0.0_8
    zled = 0.0_8
    DO l=k0,1,-1
      zled(l) = thod(i, l)*(1.+cons_vireps*qho(i, l)) + tho(i, l)*&
&       cons_vireps*qhod(i, l)
      zle(l) = tho(i, l)*(1.+cons_vireps*qho(i, l))
      zlod(l) = zled(l+1) + cons_cp*(pke(l+1)-pk(l))*zled(l)/cons_grav
      zlo(l) = zle(l+1) + cons_cp/cons_grav*(pke(l+1)-pk(l))*zle(l)
      zled(l) = zlod(l) + cons_cp*(pk(l)-pke(l))*zled(l)/cons_grav
      zle(l) = zlo(l) + cons_cp/cons_grav*(pk(l)-pke(l))*zle(l)
    END DO
    tpertd = cbl_tpert*(-tempfd(k0)-cons_grav*zlod(k0)/cons_cp)
    tpert = cbl_tpert*(ts(i)-(tempf(k0)+cons_grav*zlo(k0)/cons_cp))
!* ( QSSFC - Q(:,:,K0) ) [CBL_QPERT = 0.0]
    qpert = cbl_qpert
    IF (tpert .LT. 0.0) THEN
      tpert = 0.0
      tpertd = 0.0_8
    ELSE
      tpert = tpert
    END IF
    IF (qpert .LT. 0.0) THEN
      qpert = 0.0
    ELSE
      qpert = qpert
    END IF
    IF (frland(i) .LT. 0.1) THEN
      IF (tpert .GT. cbl_tpert_mxocn) THEN
        tpert = cbl_tpert_mxocn
        tpertd = 0.0_8
      ELSE
        tpert = tpert
      END IF
    ELSE IF (tpert .GT. cbl_tpert_mxlnd) THEN
      tpert = cbl_tpert_mxlnd
      tpertd = 0.0_8
    ELSE
      tpert = tpert
    END IF
    CALL DQSAT_RAS_D(dqs, dqsd, qss, qssd, tempf, tempfd, pf, k0, estblx&
&              , cons_h2omw, cons_airmw)
    DO kk=icmin,k+1
      prjd(kk) = 0.0_8
      prj(kk) = pke(kk)
    END DO
    prsd(icmin:k0+1) = 0.0_8
    prs(icmin:k0+1) = ple(i, icmin:k0+1)
    poid = 0.0_8
    poid(icmin:k) = thod(i, icmin:k)
    poi(icmin:k) = tho(i, icmin:k)
    qoid = 0.0_8
    qoid(icmin:k) = qhod(i, icmin:k)
    qoi(icmin:k) = qho(i, icmin:k)
    uoid = 0.0_8
    uoid(icmin:k) = uhod(i, icmin:k)
    uoi(icmin:k) = uho(i, icmin:k)
    void0 = 0.0_8
    void0(icmin:k) = vhod(i, icmin:k)
    voi(icmin:k) = vho(i, icmin:k)
    qstd = 0.0_8
    qstd(icmin:k) = qssd(icmin:k)
    qst(icmin:k) = qss(icmin:k)
    dqqd = 0.0_8
    dqqd(icmin:k) = dqsd(icmin:k)
    dqq(icmin:k) = dqs(icmin:k)
!Mass fraction of each layer below cloud base
    massf(:) = wgt0(i, :)
!RESET PRESSURE at bottom edge of CBL 
    prcbl = prs(k)
    DO l=k,k0
      prcbl = prcbl + massf(l)*(prs(l+1)-prs(l))
    END DO
    prsd(k+1) = 0.0_8
    prs(k+1) = prcbl
    pwx11 = prs(k+1)/1000.
    pwy1 = cons_rgas/cons_cp
    prjd(k+1) = 0.0_8
    prj(k+1) = pwx11**pwy1
    DO l=k,icmin,-1
      pold(l) = 0.0_8
      pol(l) = 0.5*(prs(l)+prs(l+1))
      prhd(l) = 0.0_8
      prh(l) = (prs(l+1)*prj(l+1)-prs(l)*prj(l))/(onepkap*(prs(l+1)-prs(&
&       l)))
      pkid(l) = 0.0_8
      pki(l) = 1.0/prh(l)
      dptd(l) = 0.0_8
      dpt(l) = prh(l) - prj(l)
      dpbd(l) = 0.0_8
      dpb(l) = prj(l+1) - prh(l)
      prid(l) = 0.0_8
      pri(l) = .01/(prs(l+1)-prs(l))
    END DO
!RECALCULATE PROFILE QUAN. IN LOWEST STRAPPED LAYER
    IF (k .LE. k0) THEN
      poid(k) = 0.0_8
      poi(k) = 0.
      qoid(k) = 0.0_8
      qoi(k) = 0.
      uoid(k) = 0.0_8
      uoi(k) = 0.
      void0(k) = 0.0_8
      voi(k) = 0.
!SPECIFY WEIGHTS GIVEN TO EACH LAYER WITHIN SUBCLOUD "SUPERLAYER"
      wght = 0.
      DO l=k,k0
        wghtd(l) = 0.0_8
        wght(l) = massf(l)*(ple(i, l+1)-ple(i, l))/(prs(k+1)-prs(k))
      END DO
      DO l=k,k0
        poid(k) = poid(k) + wght(l)*thod(i, l)
        poi(k) = poi(k) + wght(l)*tho(i, l)
        qoid(k) = qoid(k) + wght(l)*qhod(i, l)
        qoi(k) = qoi(k) + wght(l)*qho(i, l)
        uoid(k) = uoid(k) + wght(l)*uhod(i, l)
        uoi(k) = uoi(k) + wght(l)*uho(i, l)
        void0(k) = void0(k) + wght(l)*vhod(i, l)
        voi(k) = voi(k) + wght(l)*vho(i, l)
      END DO
      CALL DQSATS_RAS_D(dqq(k), dqqd(k), qst(k), qstd(k), poi(k)*prh(k)&
&                 , prh(k)*poid(k), pol(k), estblx, cons_h2omw, &
&                 cons_airmw)
    END IF
    IF (seedras(i)/1000000. .LT. 1e-6) THEN
      rndu = 1e-6
    ELSE
      rndu = seedras(i)/1000000.
    END IF
    pwr1 = rndu**(-(1./2.))
    mxdiam = maxdallowed*pwr1
    gm1d = 0.0_8
    ghtd = 0.0_8
    betd = 0.0_8
    gamd = 0.0_8
    DO l=k,icmin,-1
!*
      betd(l) = pki(l)*dqqd(l)
      bet(l) = dqq(l)*pki(l)
!*
      gamd(l) = -(pki(l)*lbcp*dqqd(l)/(1.0+lbcp*dqq(l))**2)
      gam(l) = pki(l)/(1.0+lbcp*dqq(l))
      IF (l .LT. k) THEN
        ghtd(l+1) = dpb(l)*gamd(l) + dpt(l+1)*gamd(l+1)
        ght(l+1) = gam(l)*dpb(l) + gam(l+1)*dpt(l+1)
        gm1d(l+1) = 0.5*lbcp*((dqqd(l)*alhl*(1.0+lbcp*dqq(l))-dqq(l)*&
&         alhl*lbcp*dqqd(l))/(alhl*(1.0+lbcp*dqq(l)))**2+(dqqd(l+1)*alhl&
&         *(1.0+lbcp*dqq(l+1))-dqq(l+1)*alhl*lbcp*dqqd(l+1))/(alhl*(1.0+&
&         lbcp*dqq(l+1)))**2)
        gm1(l+1) = 0.5*lbcp*(dqq(l)/(alhl*(1.0+lbcp*dqq(l)))+dqq(l+1)/(&
&         alhl*(1.0+lbcp*dqq(l+1))))
      END IF
    END DO
    rns = 0.
    cll = 0.
    rmf = 0.
    rmfd = 0.
    rmfc = 0.
    rmfp = 0.
    cll0 = 0.
    dll0 = 0.
    cllx = 0.
    dllx = 0.
    clli = 0.
    poi_svd = poid
    poi_sv = poi
    qoi_svd = qoid
    qoi_sv = qoi
    uoi_svd = uoid
    uoi_sv = uoi
    voi_svd = void0
    voi_sv = voi
    cvw = 0.0
    updfrc = 0.0
    updfrp = 0.0
! HOL initialized here in order not to confuse Valgrind debugger
    hol = 0.
    zetd(k+1) = 0.0_8
    zet(k+1) = 0
    shtd = 0.0_8
    shtd(k+1) = cp*prj(k+1)*poid(k)
    sht(k+1) = cp*poi(k)*prj(k+1)
    hstd = 0.0_8
    qold = 0.0_8
    ssld = 0.0_8
    zetd = 0.0_8
    zold = 0.0_8
    hold = 0.0_8
    DO l=k,icmin,-1
      IF (qst(l)*rhmax .GT. qoi(l)) THEN
        qold(l) = qoid(l)
        qol(l) = qoi(l)
      ELSE
        qold(l) = rhmax*qstd(l)
        qol(l) = qst(l)*rhmax
      END IF
      IF (0.000 .LT. qol(l)) THEN
        qol(l) = qol(l)
      ELSE
        qold(l) = 0.0_8
        qol(l) = 0.000
      END IF
      ssld(l) = cp*prj(l+1)*poid(l) + grav*zetd(l+1)
      ssl(l) = cp*prj(l+1)*poi(l) + grav*zet(l+1)
      hold(l) = ssld(l) + alhl*qold(l)
      hol(l) = ssl(l) + qol(l)*alhl
      hstd(l) = ssld(l) + alhl*qstd(l)
      hst(l) = ssl(l) + qst(l)*alhl
      temd = (prj(l+1)-prj(l))*cpbg*poid(l)
      tem = poi(l)*(prj(l+1)-prj(l))*cpbg
      zetd(l) = zetd(l+1) + temd
      zet(l) = zet(l+1) + tem
      zold(l) = zetd(l+1) + (prj(l+1)-prh(l))*cpbg*poid(l)
      zol(l) = zet(l+1) + (prj(l+1)-prh(l))*poi(l)*cpbg
    END DO
    ehtd = 0.0_8
    hccd = 0.0_8
    f2d = 0.0_8
    cvwd = 0.0_8
    ucud = 0.0_8
    qhtd = 0.0_8
    bk2d = 0.0_8
    rasald = 0.0_8
    hcldd = 0.0_8
    etad = 0.0_8
    gmhd = 0.0_8
    rnnd = 0.0_8
    gmsd = 0.0_8
    updfrcd = 0.0_8
    rnsd = 0.0_8
    vcud = 0.0_8
    rmfdd = 0.0_8
    updfrpd = 0.0_8
    cll0d = 0.0_8
    clld = 0.0_8
    rmfpd = 0.0_8
    DO ic=k,icmin+1,-1
      ucud(icmin:) = 0.0_8
      ucu(icmin:) = 0.
      vcud(icmin:) = 0.0_8
      vcu(icmin:) = 0.
      alm = 0.
      IF (1. .GT. (qoi(k)/qst(k)-rhmn)/(rhmx-rhmn)) THEN
        trgd = (qoid(k)*qst(k)-qoi(k)*qstd(k))/qst(k)**2/(rhmx-rhmn)
        trg = (qoi(k)/qst(k)-rhmn)/(rhmx-rhmn)
      ELSE
        trg = 1.
        trgd = 0.0_8
      END IF
      IF (0.0 .LT. (autorampb-sige(ic))/0.2) THEN
        y1 = (autorampb-sige(ic))/0.2
      ELSE
        y1 = 0.0
      END IF
      IF (1.0 .GT. y1) THEN
        f4 = y1
      ELSE
        f4 = 1.0
      END IF
      IF (trg .GT. 1.0e-5) THEN
!================>>
!RECOMPUTE SOUNDING UP TO DETRAINMENT LEVEL
        poi_cd = poid
        poi_c = poi
        qoi_cd = qoid
        qoi_c = qoi
        poi_cd(k) = poi_cd(k) + tpertd
        poi_c(k) = poi_c(k) + tpert
        qoi_c(k) = qoi_c(k) + qpert
        zetd(k+1) = 0.0_8
        zet(k+1) = 0.
        shtd(k+1) = cp*prj(k+1)*poi_cd(k)
        sht(k+1) = cp*poi_c(k)*prj(k+1)
        DO l=k,ic,-1
          IF (qst(l)*rhmax .GT. qoi_c(l)) THEN
            qold(l) = qoi_cd(l)
            qol(l) = qoi_c(l)
          ELSE
            qold(l) = rhmax*qstd(l)
            qol(l) = qst(l)*rhmax
          END IF
          IF (0.000 .LT. qol(l)) THEN
            qol(l) = qol(l)
          ELSE
            qold(l) = 0.0_8
            qol(l) = 0.000
          END IF
          ssld(l) = cp*prj(l+1)*poi_cd(l) + grav*zetd(l+1)
          ssl(l) = cp*prj(l+1)*poi_c(l) + grav*zet(l+1)
          hold(l) = ssld(l) + alhl*qold(l)
          hol(l) = ssl(l) + qol(l)*alhl
          hstd(l) = ssld(l) + alhl*qstd(l)
          hst(l) = ssl(l) + qst(l)*alhl
          temd = (prj(l+1)-prj(l))*cpbg*poi_cd(l)
          tem = poi_c(l)*(prj(l+1)-prj(l))*cpbg
          zetd(l) = zetd(l+1) + temd
          zet(l) = zet(l+1) + tem
          zold(l) = zetd(l+1) + (prj(l+1)-prh(l))*cpbg*poi_cd(l)
          zol(l) = zet(l+1) + (prj(l+1)-prh(l))*poi_c(l)*cpbg
        END DO
        DO l=ic+1,k
          tem = (prj(l)-prh(l-1))/(prh(l)-prh(l-1))
          shtd(l) = ssld(l-1) + tem*(ssld(l)-ssld(l-1))
          sht(l) = ssl(l-1) + tem*(ssl(l)-ssl(l-1))
          qhtd(l) = .5*(qold(l)+qold(l-1))
          qht(l) = .5*(qol(l)+qol(l-1))
        END DO
!CALCULATE LAMBDA, ETA, AND WORKFUNCTION
        lambda_min = .2/mxdiam
        lambda_max = .2/200.
        IF (hol(k) .GT. hst(ic)) THEN
!================>>
!LAMBDA CALCULATION: MS-A18
          temd = (hstd(ic)-hold(ic))*(zol(ic)-zet(ic+1)) + (hst(ic)-hol(&
&           ic))*(zold(ic)-zetd(ic+1))
          tem = (hst(ic)-hol(ic))*(zol(ic)-zet(ic+1))
          DO l=ic+1,k-1
            temd = temd + (hstd(ic)-hold(l))*(zet(l)-zet(l+1)) + (hst(ic&
&             )-hol(l))*(zetd(l)-zetd(l+1))
            tem = tem + (hst(ic)-hol(l))*(zet(l)-zet(l+1))
          END DO
          IF (tem .GT. 0.0) THEN
!================>>
            almd = ((hold(k)-hstd(ic))*tem-(hol(k)-hst(ic))*temd)/tem**2
            alm = (hol(k)-hst(ic))/tem
            IF (alm .LE. lambda_max) THEN
!================>>
              toki = 1.0
              IF (alm .LT. lambda_min) THEN
                tokid = 2*alm*almd/lambda_min**2
                toki = (alm/lambda_min)**2
              ELSE
                tokid = 0.0_8
              END IF
!ETA CALCULATION: MS-A2
              DO l=ic+1,k
                etad(l) = almd*(zet(l)-zet(k)) + alm*(zetd(l)-zetd(k))
                eta(l) = 1.0 + alm*(zet(l)-zet(k))
              END DO
              etad(ic) = almd*(zol(ic)-zet(k)) + alm*(zold(ic)-zetd(k))
              eta(ic) = 1.0 + alm*(zol(ic)-zet(k))
!WORKFUNCTION CALCULATION:  MS-A22
              wfn = 0.0
              hccd(k) = hold(k)
              hcc(k) = hol(k)
              wfnd = 0.0_8
              DO l=k-1,ic+1,-1
                hccd(l) = hccd(l+1) + (etad(l)-etad(l+1))*hol(l) + (eta(&
&                 l)-eta(l+1))*hold(l)
                hcc(l) = hcc(l+1) + (eta(l)-eta(l+1))*hol(l)
                temd = dpb(l)*hccd(l+1) + dpt(l)*hccd(l)
                tem = hcc(l+1)*dpb(l) + hcc(l)*dpt(l)
                ehtd(l) = dpb(l)*etad(l+1) + dpt(l)*etad(l)
                eht(l) = eta(l+1)*dpb(l) + eta(l)*dpt(l)
                wfnd = wfnd + (temd-ehtd(l)*hst(l)-eht(l)*hstd(l))*gam(l&
&                 ) + (tem-eht(l)*hst(l))*gamd(l)
                wfn = wfn + (tem-eht(l)*hst(l))*gam(l)
              END DO
              hccd(ic) = hstd(ic)*eta(ic) + hst(ic)*etad(ic)
              hcc(ic) = hst(ic)*eta(ic)
              wfnd = wfnd + dpb(ic)*((hccd(ic+1)-hstd(ic)*eta(ic+1)-hst(&
&               ic)*etad(ic+1))*gam(ic)+(hcc(ic+1)-hst(ic)*eta(ic+1))*&
&               gamd(ic))
              wfn = wfn + (hcc(ic+1)-hst(ic)*eta(ic+1))*gam(ic)*dpb(ic)
!VERTICAL VELOCITY/KE CALCULATION (ADDED 12/2001 JTB)
              bk2d(k) = 0.0_8
              bk2(k) = 0.0
              bke(k) = 0.0
              hcldd(k) = hold(k)
              hcld(k) = hol(k)
              DO l=k-1,ic,-1
                hcldd(l) = ((etad(l+1)*hcld(l+1)+eta(l+1)*hcldd(l+1)+(&
&                 etad(l)-etad(l+1))*hol(l)+(eta(l)-eta(l+1))*hold(l))*&
&                 eta(l)-(eta(l+1)*hcld(l+1)+(eta(l)-eta(l+1))*hol(l))*&
&                 etad(l))/eta(l)**2
                hcld(l) = (eta(l+1)*hcld(l+1)+(eta(l)-eta(l+1))*hol(l))/&
&                 eta(l)
                temd = (((hcldd(l)-hstd(l))*(zet(l)-zet(l+1))+(hcld(l)-&
&                 hst(l))*(zetd(l)-zetd(l+1)))*(1.0+lbcp*dqq(l))-(hcld(l&
&                 )-hst(l))*(zet(l)-zet(l+1))*lbcp*dqqd(l))/(1.0+lbcp*&
&                 dqq(l))**2
                tem = (hcld(l)-hst(l))*(zet(l)-zet(l+1))/(1.0+lbcp*dqq(l&
&                 ))
                bke(l) = bke(l+1) + grav*tem/(cp*prj(l+1)*poi(l))
                IF (tem .LT. 0.0) THEN
                  max1 = 0.0
                  max1d = 0.0_8
                ELSE
                  max1d = temd
                  max1 = tem
                END IF
                bk2d(l) = bk2d(l+1) + (grav*max1d*cp*prj(l+1)*poi(l)-&
&                 grav*max1*cp*prj(l+1)*poid(l))/(cp*prj(l+1)*poi(l))**2
                bk2(l) = bk2(l+1) + grav*max1/(cp*prj(l+1)*poi(l))
                IF (bk2(l) .LT. 0.0) THEN
                  max2 = 0.0
                  max2d = 0.0_8
                ELSE
                  max2d = bk2d(l)
                  max2 = bk2(l)
                END IF
                IF (2.0*max2 .EQ. 0.0) THEN
                  cvwd(l) = 0.0_8
                ELSE
                  cvwd(l) = max2d/SQRT(2.0*max2)
                END IF
                cvw(l) = SQRT(2.0*max2)
              END DO
!ALPHA CALCULATION 
              IF (zet(ic) .LT. 2000.) THEN
                rasald(ic) = 0.0_8
                rasal(ic) = rasal1
              END IF
              IF (zet(ic) .GE. 2000.) THEN
                rasald(ic) = (rasal2-rasal1)*zetd(ic)/8000.
                rasal(ic) = rasal1 + (rasal2-rasal1)*(zet(ic)-2000.)/&
&                 8000.
              END IF
              IF (rasal(ic) .GT. 1.0e5) THEN
                rasald(ic) = 0.0_8
                rasal(ic) = 1.0e5
              ELSE
                rasal(ic) = rasal(ic)
              END IF
              rasald(ic) = -(dt*rasald(ic)/rasal(ic)**2)
              rasal(ic) = dt/rasal(ic)
              DO l=ic,k
                IF (cvw(l) .LT. 1.00) THEN
                  cvwd(l) = 0.0_8
                  cvw(l) = 1.00
                ELSE
                  cvw(l) = cvw(l)
                END IF
              END DO
              CALL ACRITN(pol(ic), prs(k), acr, acritfac)
              IF (wfn .GT. acr) THEN
!================>>
                wlqd = qold(k)
                wlq = qol(k)
                uhtd = uoid(k)
                uht = uoi(k)
                vhtd = void0(k)
                vht = voi(k)
                rnnd(k) = 0.0_8
                rnn(k) = 0.
                cll0d(k) = 0.0_8
                cll0(k) = 0.
                DO l=k-1,ic,-1
                  temd = etad(l) - etad(l+1)
                  tem = eta(l) - eta(l+1)
                  wlqd = wlqd + temd*qol(l) + tem*qold(l)
                  wlq = wlq + tem*qol(l)
                  uhtd = uhtd + temd*uoi(l) + tem*uoid(l)
                  uht = uht + tem*uoi(l)
                  vhtd = vhtd + temd*voi(l) + tem*void0(l)
                  vht = vht + tem*voi(l)
                  IF (l .GT. ic) THEN
                    tx2d = 0.5*((qstd(l)+qstd(l-1))*eta(l)+(qst(l)+qst(l&
&                     -1))*etad(l))
                    tx2 = 0.5*(qst(l)+qst(l-1))*eta(l)
                    tx3d = 0.5*((hstd(l)+hstd(l-1))*eta(l)+(hst(l)+hst(l&
&                     -1))*etad(l))
                    tx3 = 0.5*(hst(l)+hst(l-1))*eta(l)
                    qccd = tx2d + gm1d(l)*(hcc(l)-tx3) + gm1(l)*(hccd(l)&
&                     -tx3d)
                    qcc = tx2 + gm1(l)*(hcc(l)-tx3)
                    cll0d(l) = wlqd - qccd
                    cll0(l) = wlq - qcc
                  ELSE
                    cll0d(l) = wlqd - qstd(ic)*eta(ic) - qst(ic)*etad(ic&
&                     )
                    cll0(l) = wlq - qst(ic)*eta(ic)
                  END IF
                  IF (cll0(l) .LT. 0.00) THEN
                    cll0d(l) = 0.0_8
                    cll0(l) = 0.00
                  ELSE
                    cll0(l) = cll0(l)
                  END IF
                  clid = (cll0d(l)*eta(l)-cll0(l)*etad(l))/eta(l)**2
                  cli = cll0(l)/eta(l)
                  te_ad = prh(l)*poid(l)
                  te_a = poi(l)*prh(l)
                  CALL SUNDQ3_ICE_D(te_a, te_ad, sdqv2, sdqv3, sdqvt1, &
&                             f2, f2d, f3)
                  c00_xd = co_auto(i)*f3*f4*f2d
                  c00_x = co_auto(i)*f2*f3*f4
                  cli_crit_xd = -(cli_crit*f3*f2d/(f2*f3)**2)
                  cli_crit_x = cli_crit/(f2*f3)
                  arg1d = -((2*cli*clid*cli_crit_x**2-cli**2*2*&
&                   cli_crit_x*cli_crit_xd)/(cli_crit_x**2)**2)
                  arg1 = -(cli**2/cli_crit_x**2)
                  rated = c00_xd*(1.0-EXP(arg1)) - c00_x*arg1d*EXP(arg1)
                  rate = c00_x*(1.0-EXP(arg1))
                  IF (cvw(l) .LT. 1.00) THEN
                    cvw_x = 1.00
                    cvw_xd = 0.0_8
                  ELSE
                    cvw_xd = cvwd(l)
                    cvw_x = cvw(l)
                  END IF
                  dt_lyrd = ((zetd(l)-zetd(l+1))*cvw_x-(zet(l)-zet(l+1))&
&                   *cvw_xd)/cvw_x**2
                  dt_lyr = (zet(l)-zet(l+1))/cvw_x
                  clossd = cll0d(l)*rate*dt_lyr + cll0(l)*(rated*dt_lyr+&
&                   rate*dt_lyrd)
                  closs = cll0(l)*rate*dt_lyr
                  IF (closs .GT. cll0(l)) THEN
                    clossd = cll0d(l)
                    closs = cll0(l)
                  ELSE
                    closs = closs
                  END IF
                  cll0d(l) = cll0d(l) - clossd
                  cll0(l) = cll0(l) - closs
                  dll0(l) = closs
                  IF (closs .GT. 0.) THEN
                    wlqd = wlqd - clossd
                    wlq = wlq - closs
                    rnnd(l) = clossd
                    rnn(l) = closs
                  ELSE
                    rnnd(l) = 0.0_8
                    rnn(l) = 0.
                  END IF
                END DO
                wlqd = wlqd - qstd(ic)*eta(ic) - qst(ic)*etad(ic)
                wlq = wlq - qst(ic)*eta(ic)
!CALCULATE GAMMAS AND KERNEL
                gmsd(k) = pri(k)*(shtd(k)-ssld(k))
                gms(k) = (sht(k)-ssl(k))*pri(k)
                gmhd(k) = gmsd(k) + pri(k)*alhl*(qhtd(k)-qold(k))
                gmh(k) = gms(k) + (qht(k)-qol(k))*pri(k)*alhl
                akmd = dpb(k-1)*(gmhd(k)*gam(k-1)+gmh(k)*gamd(k-1))
                akm = gmh(k)*gam(k-1)*dpb(k-1)
                tx2d = gmhd(k)
                tx2 = gmh(k)
                DO l=k-1,ic+1,-1
                  gmsd(l) = pri(l)*(etad(l)*(sht(l)-ssl(l))+eta(l)*(shtd&
&                   (l)-ssld(l))+etad(l+1)*(ssl(l)-sht(l+1))+eta(l+1)*(&
&                   ssld(l)-shtd(l+1)))
                  gms(l) = (eta(l)*(sht(l)-ssl(l))+eta(l+1)*(ssl(l)-sht(&
&                   l+1)))*pri(l)
                  gmhd(l) = gmsd(l) + alhl*pri(l)*(etad(l)*(qht(l)-qol(l&
&                   ))+eta(l)*(qhtd(l)-qold(l))+etad(l+1)*(qol(l)-qht(l+&
&                   1))+eta(l+1)*(qold(l)-qhtd(l+1)))
                  gmh(l) = gms(l) + (eta(l)*(qht(l)-qol(l))+eta(l+1)*(&
&                   qol(l)-qht(l+1)))*alhl*pri(l)
                  tx2d = tx2d + (etad(l)-etad(l+1))*gmh(l) + (eta(l)-eta&
&                   (l+1))*gmhd(l)
                  tx2 = tx2 + (eta(l)-eta(l+1))*gmh(l)
                  akmd = akmd - pki(l)*(gmsd(l)*eht(l)+gms(l)*ehtd(l)) +&
&                   tx2d*ght(l) + tx2*ghtd(l)
                  akm = akm - gms(l)*eht(l)*pki(l) + tx2*ght(l)
                END DO
                gmsd(ic) = pri(ic)*(etad(ic+1)*(ssl(ic)-sht(ic+1))+eta(&
&                 ic+1)*(ssld(ic)-shtd(ic+1)))
                gms(ic) = eta(ic+1)*(ssl(ic)-sht(ic+1))*pri(ic)
                akmd = akmd - dpb(ic)*pki(ic)*(gmsd(ic)*eta(ic+1)+gms(ic&
&                 )*etad(ic+1))
                akm = akm - gms(ic)*eta(ic+1)*dpb(ic)*pki(ic)
                gmhd(ic) = gmsd(ic) + pri(ic)*(alhl*(etad(ic+1)*(qol(ic)&
&                 -qht(ic+1))+eta(ic+1)*(qold(ic)-qhtd(ic+1)))+etad(ic)*&
&                 (hst(ic)-hol(ic))+eta(ic)*(hstd(ic)-hold(ic)))
                gmh(ic) = gms(ic) + (eta(ic+1)*(qol(ic)-qht(ic+1))*alhl+&
&                 eta(ic)*(hst(ic)-hol(ic)))*pri(ic)
!CLOUD BASE MASS FLUX
                IF (.NOT.(akm .GE. 0.0 .OR. wlq .LT. 0.0)) THEN
!================>>
                  wfnd = -((wfnd*akm-(wfn-acr)*akmd)/akm**2)
                  wfn = -((wfn-acr)/akm)
                  x1d = (rasald(ic)*wfn+rasal(ic)*wfnd)*trg*toki + rasal&
&                   (ic)*wfn*(trgd*toki+trg*tokid)
                  x1 = rasal(ic)*trg*toki*wfn
                  IF (x1 .GT. (prs(k+1)-prs(k))*(100.*pblfrac)) THEN
                    wfn = (prs(k+1)-prs(k))*(100.*pblfrac)
                    wfnd = 0.0_8
                  ELSE
                    wfnd = x1d
                    wfn = x1
                  END IF
!CUMULATIVE PRECIP AND CLOUD-BASE MASS FLUX FOR OUTPUT
                  temd = gravi*wfnd
                  tem = wfn*gravi
                  clld(ic) = clld(ic) + wlqd*tem + wlq*temd
                  cll(ic) = cll(ic) + wlq*tem
                  rmf(ic) = rmf(ic) + tem
                  rmfdd(ic) = rmfdd(ic) + temd*eta(ic) + tem*etad(ic)
                  rmfd(ic) = rmfd(ic) + tem*eta(ic)
                  DO l=ic+1,k
                    rmfpd(l) = temd*eta(l) + tem*etad(l)
                    rmfp(l) = tem*eta(l)
                    rmfc(l) = rmfc(l) + rmfp(l)
                    dllx(l) = dllx(l) + tem*dll0(l)
                    IF (cvw(l) .GT. 0.0) THEN
                      updfrpd(l) = (ddt*1000.*rmfpd(l)*cvw(l)*prs(l)/&
&                       daylen-rmfp(l)*ddt*1000.*prs(l)*cvwd(l)/daylen)/&
&                       (cvw(l)*prs(l))**2
                      updfrp(l) = rmfp(l)*(ddt/daylen)*1000./(cvw(l)*prs&
&                       (l))
                    ELSE
                      updfrpd(l) = 0.0_8
                      updfrp(l) = 0.0
                    END IF
                    clli(l) = cll0(l)/eta(l)
                    updfrcd(l) = updfrcd(l) + updfrpd(l)
                    updfrc(l) = updfrc(l) + updfrp(l)
                  END DO
!THETA AND Q CHANGE DUE TO CLOUD TYPE IC
                  DO l=ic,k
                    rnsd(l) = rnsd(l) + rnnd(l)*tem + rnn(l)*temd
                    rns(l) = rns(l) + rnn(l)*tem
                    gmhd(l) = gmhd(l)*wfn + gmh(l)*wfnd
                    gmh(l) = gmh(l)*wfn
                    gmsd(l) = gmsd(l)*wfn + gms(l)*wfnd
                    gms(l) = gms(l)*wfn
                    qoid(l) = qoid(l) + alhi*(gmhd(l)-gmsd(l))
                    qoi(l) = qoi(l) + (gmh(l)-gms(l))*alhi
                    poid(l) = poid(l) + pki(l)*cpi*gmsd(l)
                    poi(l) = poi(l) + gms(l)*pki(l)*cpi
                    qstd(l) = qstd(l) + cpi*(gmsd(l)*bet(l)+gms(l)*betd(&
&                     l))
                    qst(l) = qst(l) + gms(l)*bet(l)*cpi
                  END DO
!*FRICFAC*0.5
                  wfnd = 0.5*wfnd
                  wfn = wfn*0.5*1.0
!CUMULUS FRICTION
                  IF (fricfac .GT. 0.0) THEN
!================>>
                    wfnd = fricfac*(wfnd*EXP(-(alm/friclambda))-wfn*almd&
&                     *EXP(-(alm/friclambda))/friclambda)
                    wfn = wfn*fricfac*EXP(-(alm/friclambda))
                    temd = pri(k)*wfnd
                    tem = wfn*pri(k)
                    ucud(k) = ucud(k) + temd*(uoi(k-1)-uoi(k)) + tem*(&
&                     uoid(k-1)-uoid(k))
                    ucu(k) = ucu(k) + tem*(uoi(k-1)-uoi(k))
                    vcud(k) = vcud(k) + temd*(voi(k-1)-voi(k)) + tem*(&
&                     void0(k-1)-void0(k))
                    vcu(k) = vcu(k) + tem*(voi(k-1)-voi(k))
                    DO l=k-1,ic+1,-1
                      temd = pri(l)*wfnd
                      tem = wfn*pri(l)
                      ucud(l) = ucud(l) + temd*((uoi(l-1)-uoi(l))*eta(l)&
&                       +(uoi(l)-uoi(l+1))*eta(l+1)) + tem*((uoid(l-1)-&
&                       uoid(l))*eta(l)+(uoi(l-1)-uoi(l))*etad(l)+(uoid(&
&                       l)-uoid(l+1))*eta(l+1)+(uoi(l)-uoi(l+1))*etad(l+&
&                       1))
                      ucu(l) = ucu(l) + tem*((uoi(l-1)-uoi(l))*eta(l)+(&
&                       uoi(l)-uoi(l+1))*eta(l+1))
                      vcud(l) = vcud(l) + temd*((voi(l-1)-voi(l))*eta(l)&
&                       +(voi(l)-voi(l+1))*eta(l+1)) + tem*((void0(l-1)-&
&                       void0(l))*eta(l)+(voi(l-1)-voi(l))*etad(l)+(&
&                       void0(l)-void0(l+1))*eta(l+1)+(voi(l)-voi(l+1))*&
&                       etad(l+1))
                      vcu(l) = vcu(l) + tem*((voi(l-1)-voi(l))*eta(l)+(&
&                       voi(l)-voi(l+1))*eta(l+1))
                    END DO
                    temd = pri(ic)*wfnd
                    tem = wfn*pri(ic)
                    ucud(ic) = ucud(ic) + (2.*(uhtd-uoid(ic)*(eta(ic)-&
&                     eta(ic+1))-uoi(ic)*(etad(ic)-etad(ic+1)))-(uoid(ic&
&                     )+uoid(ic+1))*eta(ic+1)-(uoi(ic)+uoi(ic+1))*etad(&
&                     ic+1))*tem + (2.*(uht-uoi(ic)*(eta(ic)-eta(ic+1)))&
&                     -(uoi(ic)+uoi(ic+1))*eta(ic+1))*temd
                    ucu(ic) = ucu(ic) + (2.*(uht-uoi(ic)*(eta(ic)-eta(ic&
&                     +1)))-(uoi(ic)+uoi(ic+1))*eta(ic+1))*tem
                    vcud(ic) = vcud(ic) + (2.*(vhtd-void0(ic)*(eta(ic)-&
&                     eta(ic+1))-voi(ic)*(etad(ic)-etad(ic+1)))-(void0(&
&                     ic)+void0(ic+1))*eta(ic+1)-(voi(ic)+voi(ic+1))*&
&                     etad(ic+1))*tem + (2.*(vht-voi(ic)*(eta(ic)-eta(ic&
&                     +1)))-(voi(ic)+voi(ic+1))*eta(ic+1))*temd
                    vcu(ic) = vcu(ic) + (2.*(vht-voi(ic)*(eta(ic)-eta(ic&
&                     +1)))-(voi(ic)+voi(ic+1))*eta(ic+1))*tem
                    DO l=ic,k
                      uoid(l) = uoid(l) + ucud(l)
                      uoi(l) = uoi(l) + ucu(l)
                      void0(l) = void0(l) + vcud(l)
                      voi(l) = voi(l) + vcu(l)
                    END DO
                  END IF
                END IF
              END IF
            END IF
          END IF
        END IF
      END IF
    END DO
!CLOUD LOOP
    IF (SUM(rmf(icmin:k)) .GT. 0.0) THEN
      cnv_prc3d = 0.0_8
      DO l=icmin,k
        tem = pri(l)*grav
        cnv_prc3d(i, l) = tem*rnsd(l)
        cnv_prc3(i, l) = rns(l)*tem
      END DO
      thod(i, icmin:k-1) = poid(icmin:k-1)
      tho(i, icmin:k-1) = poi(icmin:k-1)
      qhod(i, icmin:k-1) = qoid(icmin:k-1)
      qho(i, icmin:k-1) = qoi(icmin:k-1)
      uhod(i, icmin:k-1) = uoid(icmin:k-1)
      uho(i, icmin:k-1) = uoi(icmin:k-1)
      vhod(i, icmin:k-1) = void0(icmin:k-1)
      vho(i, icmin:k-1) = voi(icmin:k-1)
      cnv_updfrcd = 0.0_8
      cnv_updfrcd(i, icmin:k-1) = updfrcd(icmin:k-1)
      cnv_updfrc(i, icmin:k-1) = updfrc(icmin:k-1)
!De-strap tendencies from RAS
      wght = wgt1(i, :)
!Scale properly by layer masses
      wght0 = 0.
      DO l=k,k0
        wght0 = wght0 + wght(l)*(ple(i, l+1)-ple(i, l))
      END DO
      wght0 = (prs(k+1)-prs(k))/wght0
      wght = wght0*wght
      DO l=k,k0
        thod(i, l) = thod(i, l) + wght(l)*(poid(k)-poi_svd(k))
        tho(i, l) = tho(i, l) + wght(l)*(poi(k)-poi_sv(k))
        qhod(i, l) = qhod(i, l) + wght(l)*(qoid(k)-qoi_svd(k))
        qho(i, l) = qho(i, l) + wght(l)*(qoi(k)-qoi_sv(k))
        uhod(i, l) = uhod(i, l) + wght(l)*(uoid(k)-uoi_svd(k))
        uho(i, l) = uho(i, l) + wght(l)*(uoi(k)-uoi_sv(k))
        vhod(i, l) = vhod(i, l) + wght(l)*(void0(k)-voi_svd(k))
        vho(i, l) = vho(i, l) + wght(l)*(voi(k)-voi_sv(k))
      END DO
      flxdd = 0.0_8
      flxdd(i, icmin:k) = ddt*rmfdd(icmin:k)/daylen
      flxd(i, icmin:k) = rmfd(icmin:k)*ddt/daylen
      clwd = 0.0_8
      clwd(i, icmin:k) = ddt*clld(icmin:k)/daylen
      clw(i, icmin:k) = cll(icmin:k)*ddt/daylen
      flxdd(i, 1:icmin-1) = 0.0_8
      flxd(i, 1:icmin-1) = 0.
      clwd(i, 1:icmin-1) = 0.0_8
      clw(i, 1:icmin-1) = 0.
      IF (k .LT. k0) THEN
        flxdd(i, k:k0) = 0.0_8
        flxd(i, k:k0) = 0.
        clwd(i, k:k0) = 0.0_8
        clw(i, k:k0) = 0.
      END IF
    ELSE
      flxdd(i, :) = 0.0_8
      flxd(i, :) = 0.
      clwd(i, :) = 0.0_8
      clw(i, :) = 0.
      clwd = 0.0_8
      cnv_prc3d = 0.0_8
      cnv_updfrcd = 0.0_8
      flxdd = 0.0_8
    END IF
  ELSE
    flxdd(i, :) = 0.0_8
    flxd(i, :) = 0.
    clwd(i, :) = 0.0_8
    clw(i, :) = 0.
    clwd = 0.0_8
    cnv_prc3d = 0.0_8
    cnv_updfrcd = 0.0_8
    flxdd = 0.0_8
  END IF
END SUBROUTINE RASE_D

!  Differentiation of sundq3_ice in forward (tangent) mode:
!   variations   of useful results: f2
!   with respect to varying inputs: temp f2
SUBROUTINE SUNDQ3_ICE_D(temp, tempd, rate2, rate3, te1, f2, f2d, f3)
  IMPLICIT NONE
  REAL*8, INTENT(IN) :: temp, rate2, rate3, te1
  REAL*8, INTENT(IN) :: tempd
  REAL*8, INTENT(OUT) :: f2, f3
  REAL*8, INTENT(OUT) :: f2d
!,RATE2,RATE3,TE1
  REAL*8 :: xx, yy, te0, te2, jump1
  te0 = 273.
  te2 = 200.
  jump1 = (rate2-1.0)/(te0-te1)**0.333
! Ice - phase treatment
  IF (temp .GE. te0) THEN
    f2 = 1.0
    f3 = 1.0
    f2d = 0.0_8
  END IF
  IF (temp .GE. te1 .AND. temp .LT. te0) THEN
    f2d = -(jump1*0.3333*(te0-temp)**(-0.6667)*tempd)
    f2 = 1.0 + jump1*(te0-temp)**0.3333
    f3 = 1.0
  END IF
  IF (temp .LT. te1) THEN
    f2d = (-((rate3-rate2)*tempd))/(te1-te2)
    f2 = rate2 + (rate3-rate2)*(te1-temp)/(te1-te2)
    f3 = 1.0
  END IF
  IF (f2 .GT. 27.0) THEN
    f2 = 27.0
    f2d = 0.0_8
  END IF
END SUBROUTINE SUNDQ3_ICE_D

!  Differentiation of dqsat_ras in forward (tangent) mode:
!   variations   of useful results: dqsi qssi
!   with respect to varying inputs: temp
SUBROUTINE DQSAT_RAS_D(dqsi, dqsid, qssi, qssid, temp, tempd, plo, lm, &
& estblx, cons_h2omw, cons_airmw)
  IMPLICIT NONE
!Inputs
  INTEGER :: lm
  REAL*8, DIMENSION(lm) :: temp, plo
  REAL*8, DIMENSION(lm) :: tempd
  REAL*8 :: estblx(:)
  REAL*8 :: cons_h2omw, cons_airmw
!Outputs
  REAL*8, DIMENSION(lm) :: dqsi, qssi
  REAL*8, DIMENSION(lm) :: dqsid, qssid
!Locals
  REAL*8, PARAMETER :: max_mixing_ratio=1.0
  REAL*8 :: esfac
  INTEGER :: k
  REAL*8 :: tl, tt, ti, dqsat, qsat, dqq, qq, pl, pp, dd
  REAL*8 :: tld, ttd, tid, dqsatd, qsatd, qqd, ddd
  INTEGER :: it
  INTEGER, PARAMETER :: degsubs=100
  REAL*8, PARAMETER :: tmintbl=150.0, tmaxtbl=333.0
  INTEGER, PARAMETER :: tablesize=NINT(tmaxtbl-tmintbl)*degsubs+1
  INTRINSIC NINT
  INTRINSIC INT
  esfac = cons_h2omw/cons_airmw
  dqsid = 0.0_8
  qssid = 0.0_8
  DO k=1,lm
    tld = tempd(k)
    tl = temp(k)
    pl = plo(k)
    pp = pl*100.0
    IF (tl .LE. tmintbl) THEN
      ti = tmintbl
      tid = 0.0_8
    ELSE IF (tl .GE. tmaxtbl - .001) THEN
      tid = 0.0_8
      ti = tmaxtbl - .001
    ELSE
      tid = tld
      ti = tl
    END IF
    ttd = degsubs*tid
    tt = (ti-tmintbl)*degsubs + 1
    it = INT(tt)
    dqq = estblx(it+1) - estblx(it)
    qqd = dqq*ttd
    qq = (tt-it)*dqq + estblx(it)
    IF (pp .LE. qq) THEN
      qsat = max_mixing_ratio
      dqsat = 0.0
      qsatd = 0.0_8
      dqsatd = 0.0_8
    ELSE
      ddd = -((-((1.0-esfac)*qqd))/(pp-(1.0-esfac)*qq)**2)
      dd = 1.0/(pp-(1.0-esfac)*qq)
      qsatd = esfac*(qqd*dd+qq*ddd)
      qsat = esfac*qq*dd
      dqsatd = esfac*degsubs*dqq*pp*(ddd*dd+dd*ddd)
      dqsat = esfac*degsubs*dqq*pp*(dd*dd)
    END IF
    dqsid(k) = dqsatd
    dqsi(k) = dqsat
    qssid(k) = qsatd
    qssi(k) = qsat
  END DO
END SUBROUTINE DQSAT_RAS_D

!  Differentiation of dqsats_ras in forward (tangent) mode:
!   variations   of useful results: dqsi qssi
!   with respect to varying inputs: temp
SUBROUTINE DQSATS_RAS_D(dqsi, dqsid, qssi, qssid, temp, tempd, plo, &
& estblx, cons_h2omw, cons_airmw)
  IMPLICIT NONE
!Inputs
  REAL*8 :: temp, plo
  REAL*8 :: tempd
  REAL*8 :: estblx(:)
  REAL*8 :: cons_h2omw, cons_airmw
!Outputs
  REAL*8 :: dqsi, qssi
  REAL*8 :: dqsid, qssid
!Locals
  REAL*8, PARAMETER :: max_mixing_ratio=1.0
  REAL*8 :: esfac
  REAL*8 :: tl, tt, ti, dqsat, qsat, dqq, qq, pl, pp, dd
  REAL*8 :: tld, ttd, tid, dqsatd, qsatd, qqd, ddd
  INTEGER :: it
  INTEGER, PARAMETER :: degsubs=100
  REAL*8, PARAMETER :: tmintbl=150.0, tmaxtbl=333.0
  INTEGER, PARAMETER :: tablesize=NINT(tmaxtbl-tmintbl)*degsubs+1
  INTRINSIC NINT
  INTRINSIC INT
  esfac = cons_h2omw/cons_airmw
  tld = tempd
  tl = temp
  pl = plo
  pp = pl*100.0
  IF (tl .LE. tmintbl) THEN
    ti = tmintbl
    tid = 0.0_8
  ELSE IF (tl .GE. tmaxtbl - .001) THEN
    ti = tmaxtbl - .001
    tid = 0.0_8
  ELSE
    tid = tld
    ti = tl
  END IF
  ttd = degsubs*tid
  tt = (ti-tmintbl)*degsubs + 1
  it = INT(tt)
  dqq = estblx(it+1) - estblx(it)
  qqd = dqq*ttd
  qq = (tt-it)*dqq + estblx(it)
  IF (pp .LE. qq) THEN
    qsat = max_mixing_ratio
    dqsat = 0.0
    qsatd = 0.0_8
    dqsatd = 0.0_8
  ELSE
    ddd = -((-((1.0-esfac)*qqd))/(pp-(1.0-esfac)*qq)**2)
    dd = 1.0/(pp-(1.0-esfac)*qq)
    qsatd = esfac*(qqd*dd+qq*ddd)
    qsat = esfac*qq*dd
    dqsatd = esfac*degsubs*dqq*pp*(ddd*dd+dd*ddd)
    dqsat = esfac*degsubs*dqq*pp*(dd*dd)
  END IF
  dqsid = dqsatd
  dqsi = dqsat
  qssid = qsatd
  qssi = qsat
END SUBROUTINE DQSATS_RAS_D


SUBROUTINE RASE0_D(idim, irun, k0, icmin, dt, cons_cp, cons_alhl, &
& cons_grav, cons_rgas, cons_h2omw, cons_airmw, cons_vireps, seedras, &
& sige, kcbl, wgt0, wgt1, frland, ts, tho, thod, qho, qhod, co_auto, ple&
& , rasparams, estblx)
  IMPLICIT NONE
!INPUTS
  INTEGER, INTENT(IN) :: idim, irun, k0, icmin
  REAL*8, DIMENSION(idim, k0 + 1), INTENT(IN) :: ple
  REAL*8, DIMENSION(k0 + 1), INTENT(IN) :: sige
  REAL*8, INTENT(IN) :: dt, cons_cp, cons_alhl, cons_grav, cons_rgas
  REAL*8, INTENT(IN) :: cons_h2omw, cons_airmw, cons_vireps
  INTEGER, DIMENSION(idim), INTENT(IN) :: seedras
  INTEGER, DIMENSION(idim), INTENT(IN) :: kcbl
  REAL*8, DIMENSION(idim), INTENT(IN) :: ts, frland
  REAL*8, DIMENSION(idim), INTENT(IN) :: co_auto
  REAL*8, DIMENSION(idim, k0), INTENT(IN) :: wgt0, wgt1
  REAL*8, DIMENSION(:), INTENT(IN) :: rasparams
  REAL*8, DIMENSION(:), INTENT(IN) :: estblx
!PROGNOSTIC
  REAL*8, DIMENSION(idim, k0), INTENT(INOUT) :: tho, qho
  REAL*8, DIMENSION(idim, k0), INTENT(INOUT) :: thod, qhod
!LOCALS
  INTEGER :: i, ic, l, kk, k
!Parameters
  REAL*8, PARAMETER :: onepkap=1.+2./7., daylen=86400.0
  REAL*8, PARAMETER :: rhmax=0.9999
  REAL*8, PARAMETER :: cbl_qpert=0.0, cbl_tpert=1.0
  REAL*8, PARAMETER :: cbl_tpert_mxocn=2.0, cbl_tpert_mxlnd=4.0
!Constants
  REAL*8 :: grav, cp, alhl, cpbg, alhi, cpi, gravi, ddt, lbcp
!Rasparams
  REAL*8 :: fricfac, cli_crit, rasal1, rasal2
  REAL*8 :: friclambda
  REAL*8 :: sdqv2, sdqv3, sdqvt1
  REAL*8 :: acritfac, pblfrac, autorampb
  REAL*8 :: maxdallowed, rhmn, rhmx
  REAL*8 :: mxdiam
  REAL*8 :: tx2, tx3, akm, acr, alm, tth, qqh, dqx
  REAL*8 :: tx2d, akmd, almd
  REAL*8 :: wfn, tem, trg, trgexp, evp, wlq, qcc
  REAL*8 :: wfnd, temd, trgd
  REAL*8 :: cli, te_a, c00_x, cli_crit_x, toki
  REAL*8 :: tokid
  REAL*8 :: dt_lyr, rate, cvw_x, closs, f2, f3, f4
  REAL*8 :: wght0, prcbl, rndu
  REAL*8 :: lambda_min, lambda_max
  REAL*8 :: tpert, qpert
  REAL*8 :: tpertd
  REAL*8, DIMENSION(k0) :: poi_sv, qoi_sv
  REAL*8, DIMENSION(k0) :: poi_svd, qoi_svd
  REAL*8, DIMENSION(k0) :: poi, qoi, dqq, bet, gam, cll
  REAL*8, DIMENSION(k0) :: poid, qoid, dqqd, betd, gamd
  REAL*8, DIMENSION(k0) :: poi_c, qoi_c
  REAL*8, DIMENSION(k0) :: poi_cd, qoi_cd
  REAL*8, DIMENSION(k0) :: prh, pri, ght, dpt, dpb, pki
  REAL*8, DIMENSION(k0) :: prhd, prid, ghtd, dptd, dpbd, pkid
  REAL*8, DIMENSION(k0) :: cln, rns, pol, dm
  REAL*8, DIMENSION(k0) :: pold
  REAL*8, DIMENSION(k0) :: qst, ssl, rmf, rnn, rn1, rmfc, rmfp
  REAL*8, DIMENSION(k0) :: qstd, ssld
  REAL*8, DIMENSION(k0) :: gms, eta, gmh, eht, gm1, hcc, rmfd
  REAL*8, DIMENSION(k0) :: gmsd, etad, gmhd, ehtd, hccd
  REAL*8, DIMENSION(k0) :: hol, hst, qol, zol, hcld, cll0, cllx, clli
  REAL*8, DIMENSION(k0) :: hold, hstd, qold, zold
  REAL*8, DIMENSION(k0) :: bke, cvw, updfrc
  REAL*8, DIMENSION(k0) :: rasal, updfrp, bk2, dll0, dllx
  REAL*8, DIMENSION(k0) :: rasald
  REAL*8, DIMENSION(k0) :: wght, massf
  REAL*8, DIMENSION(k0) :: wghtd
  REAL*8, DIMENSION(k0) :: qss, dqs, pf, pk, tempf, zlo
  REAL*8, DIMENSION(k0) :: qssd, dqsd, tempfd, zlod
  REAL*8, DIMENSION(k0 + 1) :: prj, prs, qht, sht, zet, zle, pke
  REAL*8, DIMENSION(k0+1) :: prjd, prsd, qhtd, shtd, zetd, zled
  INTRINSIC MAX
  INTRINSIC MIN
  INTRINSIC SQRT
  INTRINSIC EXP
  INTRINSIC SUM
  REAL*8, DIMENSION(k0+1) :: pwx1
  REAL*8 :: pwy1
  REAL*8, DIMENSION(k0) :: pwx10
  REAL*8 :: pwx11
  REAL*8 :: pwr1
  REAL*8 :: arg1
  REAL*8 :: x1
  REAL*8 :: x1d
  REAL*8 :: max2
  REAL*8 :: max1
  REAL*8 :: y1
!  ---  1
  fricfac = rasparams(1)
!  ---  4
  cli_crit = rasparams(4)
!  ---  5
  rasal1 = rasparams(5)
!  ---  6
  rasal2 = rasparams(6)
!  --- 11
  friclambda = rasparams(11)
!  --- 14
  sdqv2 = rasparams(14)
!  --- 15
  sdqv3 = rasparams(15)
!  --- 16
  sdqvt1 = rasparams(16)
!  --- 17
  acritfac = rasparams(17)
!  --- 20
  pblfrac = rasparams(20)
!  --- 21
  autorampb = rasparams(21)
!  --- 24
  rhmn = rasparams(24)
!  --- 24
  maxdallowed = rasparams(23)
!  --- 25
  rhmx = rasparams(25)
  grav = cons_grav
  alhl = cons_alhl
  cp = cons_cp
  cpi = 1.0/cp
  alhi = 1.0/alhl
  gravi = 1.0/grav
  cpbg = cp*gravi
  ddt = daylen/dt
  lbcp = alhl*cpi
  ehtd = 0.0_8
  hccd = 0.0_8
  dqqd = 0.0_8
  dqsd = 0.0_8
  ghtd = 0.0_8
  hstd = 0.0_8
  betd = 0.0_8
  qhtd = 0.0_8
  qold = 0.0_8
  rasald = 0.0_8
  etad = 0.0_8
  shtd = 0.0_8
  gmhd = 0.0_8
  qssd = 0.0_8
  qstd = 0.0_8
  gmsd = 0.0_8
  ssld = 0.0_8
  zetd = 0.0_8
  zold = 0.0_8
  gamd = 0.0_8
  DO i=1,irun
!CALL FINDBASE
    k = kcbl(i)
    IF (k .GT. 0) THEN
!Get saturation specific humidity and gradient wrt to T
      pwx1 = ple(i, :)/1000.
      pwy1 = cons_rgas/cons_cp
      pke = pwx1**pwy1
      pf = 0.5*(ple(i, 1:k0)+ple(i, 2:k0+1))
      pwx10 = pf/1000.
      pwy1 = cons_rgas/cons_cp
      pk = pwx10**pwy1
      tempfd = pk*thod(i, :)
      tempf = tho(i, :)*pk
      zle = 0.0
      zlo = 0.0
      zled(k0+1) = 0.0_8
      zle(k0+1) = 0.
      zlod = 0.0_8
      zled = 0.0_8
      DO l=k0,1,-1
        zled(l) = thod(i, l)*(1.+cons_vireps*qho(i, l)) + tho(i, l)*&
&         cons_vireps*qhod(i, l)
        zle(l) = tho(i, l)*(1.+cons_vireps*qho(i, l))
        zlod(l) = zled(l+1) + cons_cp*(pke(l+1)-pk(l))*zled(l)/cons_grav
        zlo(l) = zle(l+1) + cons_cp/cons_grav*(pke(l+1)-pk(l))*zle(l)
        zled(l) = zlod(l) + cons_cp*(pk(l)-pke(l))*zled(l)/cons_grav
        zle(l) = zlo(l) + cons_cp/cons_grav*(pk(l)-pke(l))*zle(l)
      END DO
      tpertd = cbl_tpert*(-tempfd(k0)-cons_grav*zlod(k0)/cons_cp)
      tpert = cbl_tpert*(ts(i)-(tempf(k0)+cons_grav*zlo(k0)/cons_cp))
!* ( QSSFC - Q(:,:,K0) ) [CBL_QPERT = 0.0]
      qpert = cbl_qpert
      IF (tpert .LT. 0.0) THEN
        tpert = 0.0
        tpertd = 0.0_8
      ELSE
        tpert = tpert
      END IF
      IF (qpert .LT. 0.0) THEN
        qpert = 0.0
      ELSE
        qpert = qpert
      END IF
      IF (frland(i) .LT. 0.1) THEN
        IF (tpert .GT. cbl_tpert_mxocn) THEN
          tpert = cbl_tpert_mxocn
          tpertd = 0.0_8
        ELSE
          tpert = tpert
        END IF
      ELSE IF (tpert .GT. cbl_tpert_mxlnd) THEN
        tpert = cbl_tpert_mxlnd
        tpertd = 0.0_8
      ELSE
        tpert = tpert
      END IF
      CALL DQSAT_RAS_D(dqs, dqsd, qss, qssd, tempf, tempfd, pf, k0, &
&                estblx, cons_h2omw, cons_airmw)
      DO kk=icmin,k+1
        prjd(kk) = 0.0_8
        prj(kk) = pke(kk)
      END DO
! These initialized here in order not to confuse Valgrind debugger
      poi = 0.
! Do not believe it actually makes any difference.
      qoi = 0.
      prsd(icmin:k0+1) = 0.0_8
      prs(icmin:k0+1) = ple(i, icmin:k0+1)
      poid = 0.0_8
      poid(icmin:k) = thod(i, icmin:k)
      poi(icmin:k) = tho(i, icmin:k)
      qoid = 0.0_8
      qoid(icmin:k) = qhod(i, icmin:k)
      qoi(icmin:k) = qho(i, icmin:k)
      qstd(icmin:k) = qssd(icmin:k)
      qst(icmin:k) = qss(icmin:k)
      dqqd(icmin:k) = dqsd(icmin:k)
      dqq(icmin:k) = dqs(icmin:k)
!Mass fraction of each layer below cloud base
      massf(:) = wgt0(i, :)
!RESET PRESSURE at bottom edge of CBL 
      prcbl = prs(k)
      DO l=k,k0
        prcbl = prcbl + massf(l)*(prs(l+1)-prs(l))
      END DO
      prsd(k+1) = 0.0_8
      prs(k+1) = prcbl
      pwx11 = prs(k+1)/1000.
      pwy1 = cons_rgas/cons_cp
      prjd(k+1) = 0.0_8
      prj(k+1) = pwx11**pwy1
      DO l=k,icmin,-1
        pold(l) = 0.0_8
        pol(l) = 0.5*(prs(l)+prs(l+1))
        prhd(l) = 0.0_8
        prh(l) = (prs(l+1)*prj(l+1)-prs(l)*prj(l))/(onepkap*(prs(l+1)-&
&         prs(l)))
        pkid(l) = 0.0_8
        pki(l) = 1.0/prh(l)
        dptd(l) = 0.0_8
        dpt(l) = prh(l) - prj(l)
        dpbd(l) = 0.0_8
        dpb(l) = prj(l+1) - prh(l)
        prid(l) = 0.0_8
        pri(l) = .01/(prs(l+1)-prs(l))
      END DO
!RECALCULATE PROFILE QUAN. IN LOWEST STRAPPED LAYER
      IF (k .LE. k0) THEN
        poid(k) = 0.0_8
        poi(k) = 0.
        qoid(k) = 0.0_8
        qoi(k) = 0.
!SPECIFY WEIGHTS GIVEN TO EACH LAYER WITHIN SUBCLOUD "SUPERLAYER"
        wght = 0.
        DO l=k,k0
          wghtd(l) = 0.0_8
          wght(l) = massf(l)*(ple(i, l+1)-ple(i, l))/(prs(k+1)-prs(k))
        END DO
        DO l=k,k0
          poid(k) = poid(k) + wght(l)*thod(i, l)
          poi(k) = poi(k) + wght(l)*tho(i, l)
          qoid(k) = qoid(k) + wght(l)*qhod(i, l)
          qoi(k) = qoi(k) + wght(l)*qho(i, l)
        END DO
        CALL DQSATS_RAS_D(dqq(k), dqqd(k), qst(k), qstd(k), poi(k)*prh(k&
&                   ), prh(k)*poid(k), pol(k), estblx, cons_h2omw, &
&                   cons_airmw)
      END IF
      IF (seedras(i)/1000000. .LT. 1e-6) THEN
        rndu = 1e-6
      ELSE
        rndu = seedras(i)/1000000.
      END IF
      pwr1 = rndu**(-(1./2.))
      mxdiam = maxdallowed*pwr1
      DO l=k,icmin,-1
!*
        betd(l) = pki(l)*dqqd(l)
        bet(l) = dqq(l)*pki(l)
!*
        gamd(l) = -(pki(l)*lbcp*dqqd(l)/(1.0+lbcp*dqq(l))**2)
        gam(l) = pki(l)/(1.0+lbcp*dqq(l))
        IF (l .LT. k) THEN
          ghtd(l+1) = dpb(l)*gamd(l) + dpt(l+1)*gamd(l+1)
          ght(l+1) = gam(l)*dpb(l) + gam(l+1)*dpt(l+1)
          gm1(l+1) = 0.5*lbcp*(dqq(l)/(alhl*(1.0+lbcp*dqq(l)))+dqq(l+1)/&
&           (alhl*(1.0+lbcp*dqq(l+1))))
        END IF
      END DO
      rns = 0.
      cll = 0.
      rmf = 0.
      rmfd = 0.
      rmfc = 0.
      rmfp = 0.
      cll0 = 0.
      dll0 = 0.
      cllx = 0.
      dllx = 0.
      clli = 0.
      poi_svd = poid
      poi_sv = poi
      qoi_svd = qoid
      qoi_sv = qoi
      cvw = 0.0
      updfrc = 0.0
      updfrp = 0.0
! HOL initialized here in order not to confuse Valgrind debugger
      hol = 0.
      zetd(k+1) = 0.0_8
      zet(k+1) = 0
      shtd(k+1) = cp*prj(k+1)*poid(k)
      sht(k+1) = cp*poi(k)*prj(k+1)
      hold = 0.0_8
      DO l=k,icmin,-1
        IF (qst(l)*rhmax .GT. qoi(l)) THEN
          qold(l) = qoid(l)
          qol(l) = qoi(l)
        ELSE
          qold(l) = rhmax*qstd(l)
          qol(l) = qst(l)*rhmax
        END IF
        IF (0.000 .LT. qol(l)) THEN
          qol(l) = qol(l)
        ELSE
          qold(l) = 0.0_8
          qol(l) = 0.000
        END IF
        ssld(l) = cp*prj(l+1)*poid(l) + grav*zetd(l+1)
        ssl(l) = cp*prj(l+1)*poi(l) + grav*zet(l+1)
        hold(l) = ssld(l) + alhl*qold(l)
        hol(l) = ssl(l) + qol(l)*alhl
        hstd(l) = ssld(l) + alhl*qstd(l)
        hst(l) = ssl(l) + qst(l)*alhl
        temd = (prj(l+1)-prj(l))*cpbg*poid(l)
        tem = poi(l)*(prj(l+1)-prj(l))*cpbg
        zetd(l) = zetd(l+1) + temd
        zet(l) = zet(l+1) + tem
        zold(l) = zetd(l+1) + (prj(l+1)-prh(l))*cpbg*poid(l)
        zol(l) = zet(l+1) + (prj(l+1)-prh(l))*poi(l)*cpbg
      END DO
      DO ic=k,icmin+1,-1
        alm = 0.
        IF (1. .GT. (qoi(k)/qst(k)-rhmn)/(rhmx-rhmn)) THEN
          trgd = (qoid(k)*qst(k)-qoi(k)*qstd(k))/qst(k)**2/(rhmx-rhmn)
          trg = (qoi(k)/qst(k)-rhmn)/(rhmx-rhmn)
        ELSE
          trg = 1.
          trgd = 0.0_8
        END IF
        IF (0.0 .LT. (autorampb-sige(ic))/0.2) THEN
          y1 = (autorampb-sige(ic))/0.2
        ELSE
          y1 = 0.0
        END IF
        IF (1.0 .GT. y1) THEN
          f4 = y1
        ELSE
          f4 = 1.0
        END IF
        IF (trg .GT. 1.0e-5) THEN
!================>>
!RECOMPUTE SOUNDING UP TO DETRAINMENT LEVEL
          poi_cd = poid
          poi_c = poi
          qoi_cd = qoid
          qoi_c = qoi
          poi_cd(k) = poi_cd(k) + tpertd
          poi_c(k) = poi_c(k) + tpert
          qoi_c(k) = qoi_c(k) + qpert
          zetd(k+1) = 0.0_8
          zet(k+1) = 0.
          shtd(k+1) = cp*prj(k+1)*poi_cd(k)
          sht(k+1) = cp*poi_c(k)*prj(k+1)
          DO l=k,ic,-1
            IF (qst(l)*rhmax .GT. qoi_c(l)) THEN
              qold(l) = qoi_cd(l)
              qol(l) = qoi_c(l)
            ELSE
              qold(l) = rhmax*qstd(l)
              qol(l) = qst(l)*rhmax
            END IF
            IF (0.000 .LT. qol(l)) THEN
              qol(l) = qol(l)
            ELSE
              qold(l) = 0.0_8
              qol(l) = 0.000
            END IF
            ssld(l) = cp*prj(l+1)*poi_cd(l) + grav*zetd(l+1)
            ssl(l) = cp*prj(l+1)*poi_c(l) + grav*zet(l+1)
            hold(l) = ssld(l) + alhl*qold(l)
            hol(l) = ssl(l) + qol(l)*alhl
            hstd(l) = ssld(l) + alhl*qstd(l)
            hst(l) = ssl(l) + qst(l)*alhl
            temd = (prj(l+1)-prj(l))*cpbg*poi_cd(l)
            tem = poi_c(l)*(prj(l+1)-prj(l))*cpbg
            zetd(l) = zetd(l+1) + temd
            zet(l) = zet(l+1) + tem
            zold(l) = zetd(l+1) + (prj(l+1)-prh(l))*cpbg*poi_cd(l)
            zol(l) = zet(l+1) + (prj(l+1)-prh(l))*poi_c(l)*cpbg
          END DO
          DO l=ic+1,k
            tem = (prj(l)-prh(l-1))/(prh(l)-prh(l-1))
            shtd(l) = ssld(l-1) + tem*(ssld(l)-ssld(l-1))
            sht(l) = ssl(l-1) + tem*(ssl(l)-ssl(l-1))
            qhtd(l) = .5*(qold(l)+qold(l-1))
            qht(l) = .5*(qol(l)+qol(l-1))
          END DO
!CALCULATE LAMBDA, ETA, AND WORKFUNCTION
          lambda_min = .2/mxdiam
          lambda_max = .2/200.
          IF (hol(k) .GT. hst(ic)) THEN
!================>>
!LAMBDA CALCULATION: MS-A18
            temd = (hstd(ic)-hold(ic))*(zol(ic)-zet(ic+1)) + (hst(ic)-&
&             hol(ic))*(zold(ic)-zetd(ic+1))
            tem = (hst(ic)-hol(ic))*(zol(ic)-zet(ic+1))
            DO l=ic+1,k-1
              temd = temd + (hstd(ic)-hold(l))*(zet(l)-zet(l+1)) + (hst(&
&               ic)-hol(l))*(zetd(l)-zetd(l+1))
              tem = tem + (hst(ic)-hol(l))*(zet(l)-zet(l+1))
            END DO
            IF (tem .GT. 0.0) THEN
!================>>
              almd = ((hold(k)-hstd(ic))*tem-(hol(k)-hst(ic))*temd)/tem&
&               **2
              alm = (hol(k)-hst(ic))/tem
              IF (alm .LE. lambda_max) THEN
!================>>
                toki = 1.0
                IF (alm .LT. lambda_min) THEN
                  tokid = 2*alm*almd/lambda_min**2
                  toki = (alm/lambda_min)**2
                ELSE
                  tokid = 0.0_8
                END IF
!ETA CALCULATION: MS-A2
                DO l=ic+1,k
                  etad(l) = almd*(zet(l)-zet(k)) + alm*(zetd(l)-zetd(k))
                  eta(l) = 1.0 + alm*(zet(l)-zet(k))
                END DO
                etad(ic) = almd*(zol(ic)-zet(k)) + alm*(zold(ic)-zetd(k)&
&                 )
                eta(ic) = 1.0 + alm*(zol(ic)-zet(k))
!WORKFUNCTION CALCULATION:  MS-A22
                wfn = 0.0
                hccd(k) = hold(k)
                hcc(k) = hol(k)
                wfnd = 0.0_8
                DO l=k-1,ic+1,-1
                  hccd(l) = hccd(l+1) + (etad(l)-etad(l+1))*hol(l) + (&
&                   eta(l)-eta(l+1))*hold(l)
                  hcc(l) = hcc(l+1) + (eta(l)-eta(l+1))*hol(l)
                  temd = dpb(l)*hccd(l+1) + dpt(l)*hccd(l)
                  tem = hcc(l+1)*dpb(l) + hcc(l)*dpt(l)
                  ehtd(l) = dpb(l)*etad(l+1) + dpt(l)*etad(l)
                  eht(l) = eta(l+1)*dpb(l) + eta(l)*dpt(l)
                  wfnd = wfnd + (temd-ehtd(l)*hst(l)-eht(l)*hstd(l))*gam&
&                   (l) + (tem-eht(l)*hst(l))*gamd(l)
                  wfn = wfn + (tem-eht(l)*hst(l))*gam(l)
                END DO
                hccd(ic) = hstd(ic)*eta(ic) + hst(ic)*etad(ic)
                hcc(ic) = hst(ic)*eta(ic)
                wfnd = wfnd + dpb(ic)*((hccd(ic+1)-hstd(ic)*eta(ic+1)-&
&                 hst(ic)*etad(ic+1))*gam(ic)+(hcc(ic+1)-hst(ic)*eta(ic+&
&                 1))*gamd(ic))
                wfn = wfn + (hcc(ic+1)-hst(ic)*eta(ic+1))*gam(ic)*dpb(ic&
&                 )
!VERTICAL VELOCITY/KE CALCULATION (ADDED 12/2001 JTB)
                bk2(k) = 0.0
                bke(k) = 0.0
                hcld(k) = hol(k)
                DO l=k-1,ic,-1
                  hcld(l) = (eta(l+1)*hcld(l+1)+(eta(l)-eta(l+1))*hol(l)&
&                   )/eta(l)
                  tem = (hcld(l)-hst(l))*(zet(l)-zet(l+1))/(1.0+lbcp*dqq&
&                   (l))
                  bke(l) = bke(l+1) + grav*tem/(cp*prj(l+1)*poi(l))
                  IF (tem .LT. 0.0) THEN
                    max1 = 0.0
                  ELSE
                    max1 = tem
                  END IF
                  bk2(l) = bk2(l+1) + grav*max1/(cp*prj(l+1)*poi(l))
                  IF (bk2(l) .LT. 0.0) THEN
                    max2 = 0.0
                  ELSE
                    max2 = bk2(l)
                  END IF
                  cvw(l) = SQRT(2.0*max2)
                END DO
!ALPHA CALCULATION 
                IF (zet(ic) .LT. 2000.) THEN
                  rasald(ic) = 0.0_8
                  rasal(ic) = rasal1
                END IF
                IF (zet(ic) .GE. 2000.) THEN
                  rasald(ic) = (rasal2-rasal1)*zetd(ic)/8000.
                  rasal(ic) = rasal1 + (rasal2-rasal1)*(zet(ic)-2000.)/&
&                   8000.
                END IF
                IF (rasal(ic) .GT. 1.0e5) THEN
                  rasald(ic) = 0.0_8
                  rasal(ic) = 1.0e5
                ELSE
                  rasal(ic) = rasal(ic)
                END IF
                rasald(ic) = -(dt*rasald(ic)/rasal(ic)**2)
                rasal(ic) = dt/rasal(ic)
                WHERE (cvw(ic:k) .LT. 1.00) 
                  cvw(ic:k) = 1.00
                ELSEWHERE
                  cvw(ic:k) = cvw(ic:k)
                END WHERE
                CALL ACRITN(pol(ic), prs(k), acr, acritfac)
                IF (wfn .GT. acr) THEN
!================>>
                  wlq = qol(k)
                  rnn(k) = 0.
                  cll0(k) = 0.
                  DO l=k-1,ic,-1
                    tem = eta(l) - eta(l+1)
                    wlq = wlq + tem*qol(l)
                    IF (l .GT. ic) THEN
                      tx2 = 0.5*(qst(l)+qst(l-1))*eta(l)
                      tx3 = 0.5*(hst(l)+hst(l-1))*eta(l)
                      qcc = tx2 + gm1(l)*(hcc(l)-tx3)
                      cll0(l) = wlq - qcc
                    ELSE
                      cll0(l) = wlq - qst(ic)*eta(ic)
                    END IF
                    IF (cll0(l) .LT. 0.00) THEN
                      cll0(l) = 0.00
                    ELSE
                      cll0(l) = cll0(l)
                    END IF
                    cli = cll0(l)/eta(l)
                    te_a = poi(l)*prh(l)
                    CALL SUNDQ3_ICE(te_a, sdqv2, sdqv3, sdqvt1, f2, f3)
                    c00_x = co_auto(i)*f2*f3*f4
                    cli_crit_x = cli_crit/(f2*f3)
                    arg1 = -(cli**2/cli_crit_x**2)
                    rate = c00_x*(1.0-EXP(arg1))
                    IF (cvw(l) .LT. 1.00) THEN
                      cvw_x = 1.00
                    ELSE
                      cvw_x = cvw(l)
                    END IF
                    dt_lyr = (zet(l)-zet(l+1))/cvw_x
                    closs = cll0(l)*rate*dt_lyr
                    IF (closs .GT. cll0(l)) THEN
                      closs = cll0(l)
                    ELSE
                      closs = closs
                    END IF
                    cll0(l) = cll0(l) - closs
                    dll0(l) = closs
                    IF (closs .GT. 0.) THEN
                      wlq = wlq - closs
                      rnn(l) = closs
                    ELSE
                      rnn(l) = 0.
                    END IF
                  END DO
                  wlq = wlq - qst(ic)*eta(ic)
!CALCULATE GAMMAS AND KERNEL
                  gmsd(k) = pri(k)*(shtd(k)-ssld(k))
                  gms(k) = (sht(k)-ssl(k))*pri(k)
                  gmhd(k) = gmsd(k) + pri(k)*alhl*(qhtd(k)-qold(k))
                  gmh(k) = gms(k) + (qht(k)-qol(k))*pri(k)*alhl
                  akmd = dpb(k-1)*(gmhd(k)*gam(k-1)+gmh(k)*gamd(k-1))
                  akm = gmh(k)*gam(k-1)*dpb(k-1)
                  tx2d = gmhd(k)
                  tx2 = gmh(k)
                  DO l=k-1,ic+1,-1
                    gmsd(l) = pri(l)*(etad(l)*(sht(l)-ssl(l))+eta(l)*(&
&                     shtd(l)-ssld(l))+etad(l+1)*(ssl(l)-sht(l+1))+eta(l&
&                     +1)*(ssld(l)-shtd(l+1)))
                    gms(l) = (eta(l)*(sht(l)-ssl(l))+eta(l+1)*(ssl(l)-&
&                     sht(l+1)))*pri(l)
                    gmhd(l) = gmsd(l) + alhl*pri(l)*(etad(l)*(qht(l)-qol&
&                     (l))+eta(l)*(qhtd(l)-qold(l))+etad(l+1)*(qol(l)-&
&                     qht(l+1))+eta(l+1)*(qold(l)-qhtd(l+1)))
                    gmh(l) = gms(l) + (eta(l)*(qht(l)-qol(l))+eta(l+1)*(&
&                     qol(l)-qht(l+1)))*alhl*pri(l)
                    tx2d = tx2d + (etad(l)-etad(l+1))*gmh(l) + (eta(l)-&
&                     eta(l+1))*gmhd(l)
                    tx2 = tx2 + (eta(l)-eta(l+1))*gmh(l)
                    akmd = akmd - pki(l)*(gmsd(l)*eht(l)+gms(l)*ehtd(l))&
&                     + tx2d*ght(l) + tx2*ghtd(l)
                    akm = akm - gms(l)*eht(l)*pki(l) + tx2*ght(l)
                  END DO
                  gmsd(ic) = pri(ic)*(etad(ic+1)*(ssl(ic)-sht(ic+1))+eta&
&                   (ic+1)*(ssld(ic)-shtd(ic+1)))
                  gms(ic) = eta(ic+1)*(ssl(ic)-sht(ic+1))*pri(ic)
                  akmd = akmd - dpb(ic)*pki(ic)*(gmsd(ic)*eta(ic+1)+gms(&
&                   ic)*etad(ic+1))
                  akm = akm - gms(ic)*eta(ic+1)*dpb(ic)*pki(ic)
                  gmhd(ic) = gmsd(ic) + pri(ic)*(alhl*(etad(ic+1)*(qol(&
&                   ic)-qht(ic+1))+eta(ic+1)*(qold(ic)-qhtd(ic+1)))+etad&
&                   (ic)*(hst(ic)-hol(ic))+eta(ic)*(hstd(ic)-hold(ic)))
                  gmh(ic) = gms(ic) + (eta(ic+1)*(qol(ic)-qht(ic+1))*&
&                   alhl+eta(ic)*(hst(ic)-hol(ic)))*pri(ic)
!CLOUD BASE MASS FLUX
                  IF (.NOT.(akm .GE. 0.0 .OR. wlq .LT. 0.0)) THEN
!================>>
                    wfnd = -((wfnd*akm-(wfn-acr)*akmd)/akm**2)
                    wfn = -((wfn-acr)/akm)
                    x1d = (rasald(ic)*wfn+rasal(ic)*wfnd)*trg*toki + &
&                     rasal(ic)*wfn*(trgd*toki+trg*tokid)
                    x1 = rasal(ic)*trg*toki*wfn
                    IF (x1 .GT. (prs(k+1)-prs(k))*(100.*pblfrac)) THEN
                      wfn = (prs(k+1)-prs(k))*(100.*pblfrac)
                      wfnd = 0.0_8
                    ELSE
                      wfnd = x1d
                      wfn = x1
                    END IF
!CUMULATIVE PRECIP AND CLOUD-BASE MASS FLUX FOR OUTPUT
                    tem = wfn*gravi
                    cll(ic) = cll(ic) + wlq*tem
                    rmf(ic) = rmf(ic) + tem
                    rmfd(ic) = rmfd(ic) + tem*eta(ic)
                    DO l=ic+1,k
                      rmfp(l) = tem*eta(l)
                      rmfc(l) = rmfc(l) + rmfp(l)
                      dllx(l) = dllx(l) + tem*dll0(l)
                      IF (cvw(l) .GT. 0.0) THEN
                        updfrp(l) = rmfp(l)*(ddt/daylen)*1000./(cvw(l)*&
&                         prs(l))
                      ELSE
                        updfrp(l) = 0.0
                      END IF
                      clli(l) = cll0(l)/eta(l)
                      updfrc(l) = updfrc(l) + updfrp(l)
                    END DO
!THETA AND Q CHANGE DUE TO CLOUD TYPE IC
                    DO l=ic,k
                      rns(l) = rns(l) + rnn(l)*tem
                      gmhd(l) = gmhd(l)*wfn + gmh(l)*wfnd
                      gmh(l) = gmh(l)*wfn
                      gmsd(l) = gmsd(l)*wfn + gms(l)*wfnd
                      gms(l) = gms(l)*wfn
                      qoid(l) = qoid(l) + alhi*(gmhd(l)-gmsd(l))
                      qoi(l) = qoi(l) + (gmh(l)-gms(l))*alhi
                      poid(l) = poid(l) + pki(l)*cpi*gmsd(l)
                      poi(l) = poi(l) + gms(l)*pki(l)*cpi
                      qstd(l) = qstd(l) + cpi*(gmsd(l)*bet(l)+gms(l)*&
&                       betd(l))
                      qst(l) = qst(l) + gms(l)*bet(l)*cpi
                    END DO
                  END IF
                END IF
              END IF
            END IF
          END IF
        END IF
      END DO
!CLOUD LOOP
      IF (SUM(rmf(icmin:k)) .GT. 0.0) THEN
        thod(i, icmin:k-1) = poid(icmin:k-1)
        tho(i, icmin:k-1) = poi(icmin:k-1)
        qhod(i, icmin:k-1) = qoid(icmin:k-1)
        qho(i, icmin:k-1) = qoi(icmin:k-1)
!De-strap tendencies from RAS
        wght = wgt1(i, :)
!Scale properly by layer masses
        wght0 = 0.
        DO l=k,k0
          wght0 = wght0 + wght(l)*(ple(i, l+1)-ple(i, l))
        END DO
        wght0 = (prs(k+1)-prs(k))/wght0
        wght = wght0*wght
        DO l=k,k0
          thod(i, l) = thod(i, l) + wght(l)*(poid(k)-poi_svd(k))
          tho(i, l) = tho(i, l) + wght(l)*(poi(k)-poi_sv(k))
          qhod(i, l) = qhod(i, l) + wght(l)*(qoid(k)-qoi_svd(k))
          qho(i, l) = qho(i, l) + wght(l)*(qoi(k)-qoi_sv(k))
        END DO
      END IF
    END IF
  END DO
END SUBROUTINE RASE0_D

SUBROUTINE RASE_TRACER_D(idim, irun, k0, icmin, dt, cons_cp, cons_alhl, &
& cons_grav, cons_rgas, cons_h2omw, cons_airmw, cons_vireps, seedras, &
& sige, kcbl, wgt0, wgt1, frland, ts, thoin, qhoin, uhoin, vhoin, &
& co_auto, ple, rasparams, estblx, itrcr, xho, xhod, fscav)
  IMPLICIT NONE
!INPUTS
  INTEGER, INTENT(IN) :: idim, irun, k0, icmin
  REAL*8, DIMENSION(idim, k0 + 1), INTENT(IN) :: ple
  REAL*8, DIMENSION(k0 + 1), INTENT(IN) :: sige
  REAL*8, INTENT(IN) :: dt, cons_cp, cons_alhl, cons_grav, cons_rgas
  REAL*8, INTENT(IN) :: cons_h2omw, cons_airmw, cons_vireps
  INTEGER, DIMENSION(idim), INTENT(IN) :: seedras
  INTEGER, DIMENSION(idim), INTENT(IN) :: kcbl
  REAL*8, DIMENSION(idim), INTENT(IN) :: ts, frland
  REAL*8, DIMENSION(idim), INTENT(IN) :: co_auto
  REAL*8, DIMENSION(idim, k0), INTENT(IN) :: wgt0, wgt1
  REAL*8, DIMENSION(:), INTENT(IN) :: rasparams
  REAL*8, DIMENSION(:), INTENT(IN) :: estblx
  INTEGER, INTENT(IN) :: itrcr
  REAL*8, DIMENSION(itrcr), INTENT(IN) :: fscav
  REAL*8, DIMENSION(idim, k0), INTENT(IN) :: thoin, qhoin, uhoin, vhoin
!PROGNOSTIC
  REAL*8, DIMENSION(idim, k0, itrcr), INTENT(INOUT) :: xho
  REAL*8, DIMENSION(idim, k0, itrcr), INTENT(INOUT) :: xhod
!LOCALS
  INTEGER :: i, ic, l, kk, k
!Parameters
  REAL*8, PARAMETER :: onepkap=1.+2./7., daylen=86400.0
  REAL*8, PARAMETER :: rhmax=0.9999
  REAL*8, PARAMETER :: cbl_qpert=0.0, cbl_tpert=1.0
  REAL*8, PARAMETER :: cbl_tpert_mxocn=2.0, cbl_tpert_mxlnd=4.0
!Constants
  REAL*8 :: grav, cp, alhl, cpbg, alhi, cpi, gravi, ddt, lbcp
!Rasparams
  REAL*8 :: fricfac, cli_crit, rasal1, rasal2
  REAL*8 :: friclambda
  REAL*8 :: sdqv2, sdqv3, sdqvt1
  REAL*8 :: acritfac, pblfrac, autorampb
  REAL*8 :: maxdallowed, rhmn, rhmx
  REAL*8 :: mxdiam
  REAL*8 :: tx2, tx3, akm, acr, alm, tth, qqh, dqx
  REAL*8 :: wfn, tem, trg, trgexp, evp, wlq, qcc
  REAL*8 :: cli, te_a, c00_x, cli_crit_x, toki
  REAL*8 :: dt_lyr, rate, cvw_x, closs, f2, f3, f4
  REAL*8 :: wght0, prcbl, rndu
  REAL*8 :: lambda_min, lambda_max
  REAL*8 :: tpert, qpert
  REAL*8 :: uht, vht
  REAL*8, DIMENSION(k0) :: poi_sv, qoi_sv, uoi_sv, voi_sv
  REAL*8, DIMENSION(k0) :: poi, qoi, uoi, voi, dqq, bet, gam, cll
  REAL*8, DIMENSION(k0) :: poid, qoid, dqqd, betd, gamd
  REAL*8, DIMENSION(k0) :: poi_c, qoi_c
  REAL*8, DIMENSION(k0) :: poi_cd, qoi_cd
  REAL*8, DIMENSION(k0) :: prh, pri, ght, dpt, dpb, pki
  REAL*8, DIMENSION(k0) :: prhd, prid, ghtd, dptd, dpbd, pkid
  REAL*8, DIMENSION(k0) :: ucu, vcu
  REAL*8, DIMENSION(k0) :: cln, rns, pol
  REAL*8, DIMENSION(k0) :: pold
  REAL*8, DIMENSION(k0) :: qst, ssl, rmf, rnn, rn1, rmfc, rmfp
  REAL*8, DIMENSION(k0) :: qstd, ssld
  REAL*8, DIMENSION(k0) :: gms, eta, gmh, eht, gm1, hcc, rmfd
  REAL*8, DIMENSION(k0) :: gmsd, etad, gmhd, ehtd, hccd
  REAL*8, DIMENSION(k0) :: hol, hst, qol, zol, hcld, cll0, cllx, clli
  REAL*8, DIMENSION(k0) :: hold, hstd, qold, zold
  REAL*8, DIMENSION(k0) :: bke, cvw, updfrc
  REAL*8, DIMENSION(k0) :: rasal, updfrp, bk2, dll0, dllx
  REAL*8, DIMENSION(k0) :: rasald
  REAL*8, DIMENSION(k0) :: wght, massf
  REAL*8, DIMENSION(k0) :: wghtd
  REAL*8, DIMENSION(k0) :: qss, dqs, pf, pk, tempf, zlo
  REAL*8, DIMENSION(k0) :: zlod
  REAL*8, DIMENSION(k0 + 1) :: prj, prs, qht, sht, zet, zle, pke
  REAL*8, DIMENSION(k0+1) :: prjd, prsd, qhtd, shtd, zetd, zled
  REAL*8, DIMENSION(idim, k0) :: tho, qho, uho, vho
!Tracer scavenging
  INTEGER :: itr
!Layer thickness in km
  REAL*8 :: delzkm
!Fraction of tracer *not* scavenged
  REAL*8 :: fnoscav
  REAL*8, DIMENSION(k0, itrcr) :: xoi, xcu, xoi_sv
  REAL*8, DIMENSION(k0, itrcr) :: xoid, xcud, xoi_svd
  REAL*8, DIMENSION(itrcr) :: xht
  REAL*8, DIMENSION(itrcr) :: xhtd
  INTRINSIC MAX
  INTRINSIC MIN
  INTRINSIC SQRT
  INTRINSIC EXP
  INTRINSIC SUM
  REAL*8, DIMENSION(k0+1) :: pwx1
  REAL*8 :: pwy1
  REAL*8, DIMENSION(k0) :: pwx10
  REAL*8 :: pwx11
  REAL*8 :: pwr1
  REAL*8 :: arg1
  REAL*8 :: x5
  REAL*8 :: x4
  REAL*8 :: x3
  REAL*8 :: x2
  REAL*8 :: x1
  REAL*8 :: max2
  REAL*8 :: max1
  REAL*8 :: y1
!Pass meteorology to internal arrays so it is not updated
  tho = thoin
  qho = qhoin
  uho = uhoin
  vho = vhoin
!Initialize Local Arrays
  poi = 0.0
  qoi = 0.0
  uoi = 0.0
  voi = 0.0
  dqq = 0.0
  bet = 0.0
  gam = 0.0
  poi_c = 0.0
  qoi_c = 0.0
  prh = 0.0
  pri = 0.0
  ght = 0.0
  dpt = 0.0
  dpb = 0.0
  pki = 0.0
  ucu = 0.0
  vcu = 0.0
  cln = 0.0
  pol = 0.0
  qst = 0.0
  ssl = 0.0
  rmf = 0.0
  rnn = 0.0
  rn1 = 0.0
  gms = 0.0
  eta = 0.0
  gmh = 0.0
  eht = 0.0
  gm1 = 0.0
  hcc = 0.0
  hol = 0.0
  hst = 0.0
  qol = 0.0
  zol = 0.0
  hcld = 0.0
  bke = 0.0
  cvw = 0.0
  updfrc = 0.0
  rasal = 0.0
  updfrp = 0.0
  bk2 = 0.0
  wght = 0.0
  massf = 0.0
  qss = 0.0
  dqs = 0.0
  pf = 0.0
  pk = 0.0
  tempf = 0.0
  zlo = 0.0
  prj = 0.0
  prs = 0.0
  qht = 0.0
  sht = 0.0
  zet = 0.0
  zle = 0.0
  pke = 0.0
!  ---  1
  fricfac = rasparams(1)
!  ---  4
  cli_crit = rasparams(4)
!  ---  5
  rasal1 = rasparams(5)
!  ---  6
  rasal2 = rasparams(6)
!  --- 11
  friclambda = rasparams(11)
!  --- 14
  sdqv2 = rasparams(14)
!  --- 15
  sdqv3 = rasparams(15)
!  --- 16
  sdqvt1 = rasparams(16)
!  --- 17
  acritfac = rasparams(17)
!  --- 20
  pblfrac = rasparams(20)
!  --- 21
  autorampb = rasparams(21)
!  --- 24
  rhmn = rasparams(24)
!  --- 24
  maxdallowed = rasparams(23)
!  --- 25
  rhmx = rasparams(25)
  grav = cons_grav
  alhl = cons_alhl
  cp = cons_cp
  cpi = 1.0/cp
  alhi = 1.0/alhl
  gravi = 1.0/grav
  cpbg = cp*gravi
  ddt = daylen/dt
  lbcp = alhl*cpi
  i = 1
!CALL FINDBASE
  k = kcbl(i)
  IF (k .GT. 0) THEN
!Get saturation specific humidity and gradient wrt to T
    pwx1 = ple(i, :)/1000.
    pwy1 = cons_rgas/cons_cp
    pke = pwx1**pwy1
    pf = 0.5*(ple(i, 1:k0)+ple(i, 2:k0+1))
    pwx10 = pf/1000.
    pwy1 = cons_rgas/cons_cp
    pk = pwx10**pwy1
    tempf = tho(i, :)*pk
    zle = 0.0
    zlo = 0.0
    zled(k0+1) = 0.0_8
    zle(k0+1) = 0.
    DO l=k0,1,-1
      zled(l) = 0.0_8
      zle(l) = tho(i, l)*(1.+cons_vireps*qho(i, l))
      zlod(l) = 0.0_8
      zlo(l) = zle(l+1) + cons_cp/cons_grav*(pke(l+1)-pk(l))*zle(l)
      zled(l) = 0.0_8
      zle(l) = zlo(l) + cons_cp/cons_grav*(pk(l)-pke(l))*zle(l)
    END DO
    tpert = cbl_tpert*(ts(i)-(tempf(k0)+cons_grav*zlo(k0)/cons_cp))
!* ( QSSFC - Q(:,:,K0) ) [CBL_QPERT = 0.0]
    qpert = cbl_qpert
    IF (tpert .LT. 0.0) THEN
      tpert = 0.0
    ELSE
      tpert = tpert
    END IF
    IF (qpert .LT. 0.0) THEN
      qpert = 0.0
    ELSE
      qpert = qpert
    END IF
    IF (frland(i) .LT. 0.1) THEN
      IF (tpert .GT. cbl_tpert_mxocn) THEN
        tpert = cbl_tpert_mxocn
      ELSE
        tpert = tpert
      END IF
    ELSE IF (tpert .GT. cbl_tpert_mxlnd) THEN
      tpert = cbl_tpert_mxlnd
    ELSE
      tpert = tpert
    END IF
    CALL DQSAT_RAS(dqs, qss, tempf, pf, k0, estblx, cons_h2omw, &
&            cons_airmw)
    DO kk=icmin,k+1
      prjd(kk) = 0.0_8
      prj(kk) = pke(kk)
    END DO
    prsd(icmin:k0+1) = 0.0_8
    prs(icmin:k0+1) = ple(i, icmin:k0+1)
    poid(icmin:k) = 0.0_8
    poi(icmin:k) = tho(i, icmin:k)
    qoid(icmin:k) = 0.0_8
    qoi(icmin:k) = qho(i, icmin:k)
    uoi(icmin:k) = uho(i, icmin:k)
    voi(icmin:k) = vho(i, icmin:k)
    qstd(icmin:k) = 0.0_8
    qst(icmin:k) = qss(icmin:k)
    dqqd(icmin:k) = 0.0_8
    dqq(icmin:k) = dqs(icmin:k)
    xoid = 0.0_8
!DO_TRACERS
    DO itr=1,itrcr
      xoid(icmin:k, itr) = xhod(i, icmin:k, itr)
      xoi(icmin:k, itr) = xho(i, icmin:k, itr)
    END DO
!Mass fraction of each layer below cloud base
    massf(:) = wgt0(i, :)
!RESET PRESSURE at bottom edge of CBL 
    prcbl = prs(k)
    DO l=k,k0
      prcbl = prcbl + massf(l)*(prs(l+1)-prs(l))
    END DO
    prsd(k+1) = 0.0_8
    prs(k+1) = prcbl
    pwx11 = prs(k+1)/1000.
    pwy1 = cons_rgas/cons_cp
    prjd(k+1) = 0.0_8
    prj(k+1) = pwx11**pwy1
    DO l=k,icmin,-1
      pold(l) = 0.0_8
      pol(l) = 0.5*(prs(l)+prs(l+1))
      prhd(l) = 0.0_8
      prh(l) = (prs(l+1)*prj(l+1)-prs(l)*prj(l))/(onepkap*(prs(l+1)-prs(&
&       l)))
      pkid(l) = 0.0_8
      pki(l) = 1.0/prh(l)
      dptd(l) = 0.0_8
      dpt(l) = prh(l) - prj(l)
      dpbd(l) = 0.0_8
      dpb(l) = prj(l+1) - prh(l)
      prid(l) = 0.0_8
      pri(l) = .01/(prs(l+1)-prs(l))
    END DO
!RECALCULATE PROFILE QUAN. IN LOWEST STRAPPED LAYER
    IF (k .LE. k0) THEN
      poid(k) = 0.0_8
      poi(k) = 0.
      qoid(k) = 0.0_8
      qoi(k) = 0.
      uoi(k) = 0.
      voi(k) = 0.
!SPECIFY WEIGHTS GIVEN TO EACH LAYER WITHIN SUBCLOUD "SUPERLAYER"
      wght = 0.
      DO l=k,k0
        wghtd(l) = 0.0_8
        wght(l) = massf(l)*(ple(i, l+1)-ple(i, l))/(prs(k+1)-prs(k))
      END DO
      DO l=k,k0
        poid(k) = 0.0_8
        poi(k) = poi(k) + wght(l)*tho(i, l)
        qoid(k) = 0.0_8
        qoi(k) = qoi(k) + wght(l)*qho(i, l)
        uoi(k) = uoi(k) + wght(l)*uho(i, l)
        voi(k) = voi(k) + wght(l)*vho(i, l)
      END DO
!DO_TRACERS
      xoid(k, :) = 0.0_8
      xoi(k, :) = 0.
      DO itr=1,itrcr
        DO l=k,k0
          xoid(k, itr) = xoid(k, itr) + wght(l)*xhod(i, l, itr)
          xoi(k, itr) = xoi(k, itr) + wght(l)*xho(i, l, itr)
        END DO
      END DO
      CALL DQSATS_RAS(dqq(k), qst(k), poi(k)*prh(k), pol(k), estblx, &
&               cons_h2omw, cons_airmw)
    END IF
    IF (seedras(i)/1000000. .LT. 1e-6) THEN
      rndu = 1e-6
    ELSE
      rndu = seedras(i)/1000000.
    END IF
    pwr1 = rndu**(-(1./2.))
    mxdiam = maxdallowed*pwr1
    DO l=k,icmin,-1
!*
      betd(l) = 0.0_8
      bet(l) = dqq(l)*pki(l)
!*
      gamd(l) = 0.0_8
      gam(l) = pki(l)/(1.0+lbcp*dqq(l))
      IF (l .LT. k) THEN
        ghtd(l+1) = 0.0_8
        ght(l+1) = gam(l)*dpb(l) + gam(l+1)*dpt(l+1)
        gm1(l+1) = 0.5*lbcp*(dqq(l)/(alhl*(1.0+lbcp*dqq(l)))+dqq(l+1)/(&
&         alhl*(1.0+lbcp*dqq(l+1))))
      END IF
    END DO
    rns = 0.
    cll = 0.
    rmf = 0.
    rmfd = 0.
    rmfc = 0.
    rmfp = 0.
    cll0 = 0.
    dll0 = 0.
    cllx = 0.
    dllx = 0.
    clli = 0.
    poi_sv = poi
    qoi_sv = qoi
    uoi_sv = uoi
    voi_sv = voi
!DO_TRACERS
    xoi_svd = xoid
    xoi_sv = xoi
    cvw = 0.0
    updfrc = 0.0
    updfrp = 0.0
! HOL initialized here in order not to confuse Valgrind debugger
    hol = 0.
    zetd(k+1) = 0.0_8
    zet(k+1) = 0
    shtd(k+1) = 0.0_8
    sht(k+1) = cp*poi(k)*prj(k+1)
    DO l=k,icmin,-1
      IF (qst(l)*rhmax .GT. qoi(l)) THEN
        qold(l) = 0.0_8
        qol(l) = qoi(l)
      ELSE
        qold(l) = 0.0_8
        qol(l) = qst(l)*rhmax
      END IF
      IF (0.000 .LT. qol(l)) THEN
        qold(l) = 0.0_8
        qol(l) = qol(l)
      ELSE
        qold(l) = 0.0_8
        qol(l) = 0.000
      END IF
      ssld(l) = 0.0_8
      ssl(l) = cp*prj(l+1)*poi(l) + grav*zet(l+1)
      hold(l) = 0.0_8
      hol(l) = ssl(l) + qol(l)*alhl
      hstd(l) = 0.0_8
      hst(l) = ssl(l) + qst(l)*alhl
      tem = poi(l)*(prj(l+1)-prj(l))*cpbg
      zetd(l) = 0.0_8
      zet(l) = zet(l+1) + tem
      zold(l) = 0.0_8
      zol(l) = zet(l+1) + (prj(l+1)-prh(l))*poi(l)*cpbg
    END DO
    xcud = 0.0_8
    xhtd = 0.0_8
    DO ic=k,icmin+1,-1
!DO_TRACERS
      xcud(icmin:, :) = 0.0_8
      xcu(icmin:, :) = 0.
      ucu(icmin:) = 0.
      vcu(icmin:) = 0.
      alm = 0.
      IF (1. .GT. (qoi(k)/qst(k)-rhmn)/(rhmx-rhmn)) THEN
        trg = (qoi(k)/qst(k)-rhmn)/(rhmx-rhmn)
      ELSE
        trg = 1.
      END IF
      IF (0.0 .LT. (autorampb-sige(ic))/0.2) THEN
        y1 = (autorampb-sige(ic))/0.2
      ELSE
        y1 = 0.0
      END IF
      IF (1.0 .GT. y1) THEN
        f4 = y1
      ELSE
        f4 = 1.0
      END IF
      IF (trg .GT. 1.0e-5) THEN
!================>>
!RECOMPUTE SOUNDING UP TO DETRAINMENT LEVEL
        poi_c = poi
        qoi_c = qoi
        poi_cd(k) = 0.0_8
        poi_c(k) = poi_c(k) + tpert
        qoi_cd(k) = 0.0_8
        qoi_c(k) = qoi_c(k) + qpert
        zetd(k+1) = 0.0_8
        zet(k+1) = 0.
        shtd(k+1) = 0.0_8
        sht(k+1) = cp*poi_c(k)*prj(k+1)
        DO l=k,ic,-1
          IF (qst(l)*rhmax .GT. qoi_c(l)) THEN
            qold(l) = 0.0_8
            qol(l) = qoi_c(l)
          ELSE
            qold(l) = 0.0_8
            qol(l) = qst(l)*rhmax
          END IF
          IF (0.000 .LT. qol(l)) THEN
            qold(l) = 0.0_8
            qol(l) = qol(l)
          ELSE
            qold(l) = 0.0_8
            qol(l) = 0.000
          END IF
          ssld(l) = 0.0_8
          ssl(l) = cp*prj(l+1)*poi_c(l) + grav*zet(l+1)
          hold(l) = 0.0_8
          hol(l) = ssl(l) + qol(l)*alhl
          hstd(l) = 0.0_8
          hst(l) = ssl(l) + qst(l)*alhl
          tem = poi_c(l)*(prj(l+1)-prj(l))*cpbg
          zetd(l) = 0.0_8
          zet(l) = zet(l+1) + tem
          zold(l) = 0.0_8
          zol(l) = zet(l+1) + (prj(l+1)-prh(l))*poi_c(l)*cpbg
        END DO
        DO l=ic+1,k
          tem = (prj(l)-prh(l-1))/(prh(l)-prh(l-1))
          shtd(l) = 0.0_8
          sht(l) = ssl(l-1) + tem*(ssl(l)-ssl(l-1))
          qhtd(l) = 0.0_8
          qht(l) = .5*(qol(l)+qol(l-1))
        END DO
!CALCULATE LAMBDA, ETA, AND WORKFUNCTION
        lambda_min = .2/mxdiam
        lambda_max = .2/200.
        IF (hol(k) .GT. hst(ic)) THEN
!================>>
!LAMBDA CALCULATION: MS-A18
          tem = (hst(ic)-hol(ic))*(zol(ic)-zet(ic+1))
          DO l=ic+1,k-1
            tem = tem + (hst(ic)-hol(l))*(zet(l)-zet(l+1))
          END DO
          IF (tem .GT. 0.0) THEN
!================>>
            alm = (hol(k)-hst(ic))/tem
            IF (alm .LE. lambda_max) THEN
!================>>
              toki = 1.0
              IF (alm .LT. lambda_min) toki = (alm/lambda_min)**2
!ETA CALCULATION: MS-A2
              DO l=ic+1,k
                etad(l) = 0.0_8
                eta(l) = 1.0 + alm*(zet(l)-zet(k))
              END DO
              etad(ic) = 0.0_8
              eta(ic) = 1.0 + alm*(zol(ic)-zet(k))
!WORKFUNCTION CALCULATION:  MS-A22
              wfn = 0.0
              hccd(k) = 0.0_8
              hcc(k) = hol(k)
              DO l=k-1,ic+1,-1
                hccd(l) = 0.0_8
                hcc(l) = hcc(l+1) + (eta(l)-eta(l+1))*hol(l)
                tem = hcc(l+1)*dpb(l) + hcc(l)*dpt(l)
                ehtd(l) = 0.0_8
                eht(l) = eta(l+1)*dpb(l) + eta(l)*dpt(l)
                wfn = wfn + (tem-eht(l)*hst(l))*gam(l)
              END DO
              hccd(ic) = 0.0_8
              hcc(ic) = hst(ic)*eta(ic)
              wfn = wfn + (hcc(ic+1)-hst(ic)*eta(ic+1))*gam(ic)*dpb(ic)
!VERTICAL VELOCITY/KE CALCULATION (ADDED 12/2001 JTB)
              bk2(k) = 0.0
              bke(k) = 0.0
              hcld(k) = hol(k)
              DO l=k-1,ic,-1
                hcld(l) = (eta(l+1)*hcld(l+1)+(eta(l)-eta(l+1))*hol(l))/&
&                 eta(l)
                tem = (hcld(l)-hst(l))*(zet(l)-zet(l+1))/(1.0+lbcp*dqq(l&
&                 ))
                bke(l) = bke(l+1) + grav*tem/(cp*prj(l+1)*poi(l))
                IF (tem .LT. 0.0) THEN
                  max1 = 0.0
                ELSE
                  max1 = tem
                END IF
                bk2(l) = bk2(l+1) + grav*max1/(cp*prj(l+1)*poi(l))
                IF (bk2(l) .LT. 0.0) THEN
                  max2 = 0.0
                ELSE
                  max2 = bk2(l)
                END IF
                cvw(l) = SQRT(2.0*max2)
              END DO
!ALPHA CALCULATION 
              IF (zet(ic) .LT. 2000.) THEN
                rasald(ic) = 0.0_8
                rasal(ic) = rasal1
              END IF
              IF (zet(ic) .GE. 2000.) THEN
                rasald(ic) = 0.0_8
                rasal(ic) = rasal1 + (rasal2-rasal1)*(zet(ic)-2000.)/&
&                 8000.
              END IF
              IF (rasal(ic) .GT. 1.0e5) THEN
                rasald(ic) = 0.0_8
                rasal(ic) = 1.0e5
              ELSE
                rasald(ic) = 0.0_8
                rasal(ic) = rasal(ic)
              END IF
              rasald(ic) = 0.0_8
              rasal(ic) = dt/rasal(ic)
              DO l=ic,k
                IF (cvw(l) .LT. 1.00) THEN
                  cvw(l) = 1.00
                ELSE
                  cvw(l) = cvw(l)
                END IF
              END DO
              CALL ACRITN(pol(ic), prs(k), acr, acritfac)
              IF (wfn .GT. acr) THEN
!================>>
!DO_TRACERS
                DO itr=1,itrcr
!Scavenging of the below cloud tracer
                  delzkm = (zet(ic)-zet(k))/1000.
                  x4 = EXP(-(fscav(itr)*delzkm))
                  IF (x4 .GT. 1.) THEN
                    x1 = 1.
                  ELSE
                    x1 = x4
                  END IF
                  IF (x1 .LT. 0.) THEN
                    fnoscav = 0.
                  ELSE
                    fnoscav = x1
                  END IF
                  xhtd(itr) = fnoscav*xoid(k, itr)
                  xht(itr) = xoi(k, itr)*fnoscav
                END DO
                wlq = qol(k)
                uht = uoi(k)
                vht = voi(k)
                rnn(k) = 0.
                cll0(k) = 0.
                DO l=k-1,ic,-1
                  tem = eta(l) - eta(l+1)
                  wlq = wlq + tem*qol(l)
                  uht = uht + tem*uoi(l)
                  vht = vht + tem*voi(l)
!DO_TRACERS
                  DO itr=1,itrcr
!Scavenging of the entrained tracer.  Updates transported tracer mass.
                    delzkm = (zet(ic)-zet(l+1))/1000.
                    x5 = EXP(-(fscav(itr)*delzkm))
                    IF (x5 .GT. 1.) THEN
                      x2 = 1.
                    ELSE
                      x2 = x5
                    END IF
                    IF (x2 .LT. 0.) THEN
                      fnoscav = 0.
                    ELSE
                      fnoscav = x2
                    END IF
                    xhtd(itr) = xhtd(itr) + tem*fnoscav*xoid(l, itr)
                    xht(itr) = xht(itr) + tem*xoi(l, itr)*fnoscav
                  END DO
                  IF (l .GT. ic) THEN
                    tx2 = 0.5*(qst(l)+qst(l-1))*eta(l)
                    tx3 = 0.5*(hst(l)+hst(l-1))*eta(l)
                    qcc = tx2 + gm1(l)*(hcc(l)-tx3)
                    cll0(l) = wlq - qcc
                  ELSE
                    cll0(l) = wlq - qst(ic)*eta(ic)
                  END IF
                  IF (cll0(l) .LT. 0.00) THEN
                    cll0(l) = 0.00
                  ELSE
                    cll0(l) = cll0(l)
                  END IF
                  cli = cll0(l)/eta(l)
                  te_a = poi(l)*prh(l)
                  CALL SUNDQ3_ICE(te_a, sdqv2, sdqv3, sdqvt1, f2, f3)
                  c00_x = co_auto(i)*f2*f3*f4
                  cli_crit_x = cli_crit/(f2*f3)
                  arg1 = -(cli**2/cli_crit_x**2)
                  rate = c00_x*(1.0-EXP(arg1))
                  IF (cvw(l) .LT. 1.00) THEN
                    cvw_x = 1.00
                  ELSE
                    cvw_x = cvw(l)
                  END IF
                  dt_lyr = (zet(l)-zet(l+1))/cvw_x
                  closs = cll0(l)*rate*dt_lyr
                  IF (closs .GT. cll0(l)) THEN
                    closs = cll0(l)
                  ELSE
                    closs = closs
                  END IF
                  cll0(l) = cll0(l) - closs
                  dll0(l) = closs
                  IF (closs .GT. 0.) THEN
                    wlq = wlq - closs
                    rnn(l) = closs
                  ELSE
                    rnn(l) = 0.
                  END IF
                END DO
                wlq = wlq - qst(ic)*eta(ic)
!CALCULATE GAMMAS AND KERNEL
                gmsd(k) = 0.0_8
                gms(k) = (sht(k)-ssl(k))*pri(k)
                gmhd(k) = 0.0_8
                gmh(k) = gms(k) + (qht(k)-qol(k))*pri(k)*alhl
                akm = gmh(k)*gam(k-1)*dpb(k-1)
                tx2 = gmh(k)
                DO l=k-1,ic+1,-1
                  gmsd(l) = 0.0_8
                  gms(l) = (eta(l)*(sht(l)-ssl(l))+eta(l+1)*(ssl(l)-sht(&
&                   l+1)))*pri(l)
                  gmhd(l) = 0.0_8
                  gmh(l) = gms(l) + (eta(l)*(qht(l)-qol(l))+eta(l+1)*(&
&                   qol(l)-qht(l+1)))*alhl*pri(l)
                  tx2 = tx2 + (eta(l)-eta(l+1))*gmh(l)
                  akm = akm - gms(l)*eht(l)*pki(l) + tx2*ght(l)
                END DO
                gmsd(ic) = 0.0_8
                gms(ic) = eta(ic+1)*(ssl(ic)-sht(ic+1))*pri(ic)
                akm = akm - gms(ic)*eta(ic+1)*dpb(ic)*pki(ic)
                gmhd(ic) = 0.0_8
                gmh(ic) = gms(ic) + (eta(ic+1)*(qol(ic)-qht(ic+1))*alhl+&
&                 eta(ic)*(hst(ic)-hol(ic)))*pri(ic)
!CLOUD BASE MASS FLUX
                IF (.NOT.(akm .GE. 0.0 .OR. wlq .LT. 0.0)) THEN
!================>>
                  wfn = -((wfn-acr)/akm)
                  x3 = rasal(ic)*trg*toki*wfn
                  IF (x3 .GT. (prs(k+1)-prs(k))*(100.*pblfrac)) THEN
                    wfn = (prs(k+1)-prs(k))*(100.*pblfrac)
                  ELSE
                    wfn = x3
                  END IF
!CUMULATIVE PRECIP AND CLOUD-BASE MASS FLUX FOR OUTPUT
                  tem = wfn*gravi
                  cll(ic) = cll(ic) + wlq*tem
                  rmf(ic) = rmf(ic) + tem
                  rmfd(ic) = rmfd(ic) + tem*eta(ic)
                  DO l=ic+1,k
                    rmfp(l) = tem*eta(l)
                    rmfc(l) = rmfc(l) + rmfp(l)
                    dllx(l) = dllx(l) + tem*dll0(l)
                    IF (cvw(l) .GT. 0.0) THEN
                      updfrp(l) = rmfp(l)*(ddt/daylen)*1000./(cvw(l)*prs&
&                       (l))
                    ELSE
                      updfrp(l) = 0.0
                    END IF
                    clli(l) = cll0(l)/eta(l)
                    updfrc(l) = updfrc(l) + updfrp(l)
                  END DO
!THETA AND Q CHANGE DUE TO CLOUD TYPE IC
                  DO l=ic,k
                    rns(l) = rns(l) + rnn(l)*tem
                    gmhd(l) = 0.0_8
                    gmh(l) = gmh(l)*wfn
                    gmsd(l) = 0.0_8
                    gms(l) = gms(l)*wfn
                    qoid(l) = 0.0_8
                    qoi(l) = qoi(l) + (gmh(l)-gms(l))*alhi
                    poid(l) = 0.0_8
                    poi(l) = poi(l) + gms(l)*pki(l)*cpi
                    qstd(l) = 0.0_8
                    qst(l) = qst(l) + gms(l)*bet(l)*cpi
                  END DO
!*FRICFAC*0.5
                  wfn = wfn*0.5*1.0
!DO_TRACERS
                  tem = wfn*pri(k)
                  DO itr=1,itrcr
                    xcud(k, itr) = xcud(k, itr) + tem*(xoid(k-1, itr)-&
&                     xoid(k, itr))
                    xcu(k, itr) = xcu(k, itr) + tem*(xoi(k-1, itr)-xoi(k&
&                     , itr))
                  END DO
                  DO itr=1,itrcr
                    DO l=k-1,ic+1,-1
                      tem = wfn*pri(l)
                      xcud(l, itr) = xcud(l, itr) + tem*(eta(l)*(xoid(l-&
&                       1, itr)-xoid(l, itr))+eta(l+1)*(xoid(l, itr)-&
&                       xoid(l+1, itr)))
                      xcu(l, itr) = xcu(l, itr) + tem*((xoi(l-1, itr)-&
&                       xoi(l, itr))*eta(l)+(xoi(l, itr)-xoi(l+1, itr))*&
&                       eta(l+1))
                    END DO
                  END DO
                  tem = wfn*pri(ic)
                  DO itr=1,itrcr
                    xcud(ic, itr) = xcud(ic, itr) + tem*(2.*(xhtd(itr)-(&
&                     eta(ic)-eta(ic+1))*xoid(ic, itr))-eta(ic+1)*(xoid(&
&                     ic, itr)+xoid(ic+1, itr)))
                    xcu(ic, itr) = xcu(ic, itr) + (2.*(xht(itr)-xoi(ic, &
&                     itr)*(eta(ic)-eta(ic+1)))-(xoi(ic, itr)+xoi(ic+1, &
&                     itr))*eta(ic+1))*tem
                  END DO
                  DO itr=1,itrcr
                    DO l=ic,k
                      xoid(l, itr) = xoid(l, itr) + xcud(l, itr)
                      xoi(l, itr) = xoi(l, itr) + xcu(l, itr)
                    END DO
                  END DO
!End DO_TRACERS
!CUMULUS FRICTION
                  IF (fricfac .GT. 0.0) THEN
!================>>
                    wfn = wfn*fricfac*EXP(-(alm/friclambda))
                    tem = wfn*pri(k)
                    ucu(k) = ucu(k) + tem*(uoi(k-1)-uoi(k))
                    vcu(k) = vcu(k) + tem*(voi(k-1)-voi(k))
                    DO l=k-1,ic+1,-1
                      tem = wfn*pri(l)
                      ucu(l) = ucu(l) + tem*((uoi(l-1)-uoi(l))*eta(l)+(&
&                       uoi(l)-uoi(l+1))*eta(l+1))
                      vcu(l) = vcu(l) + tem*((voi(l-1)-voi(l))*eta(l)+(&
&                       voi(l)-voi(l+1))*eta(l+1))
                    END DO
                    tem = wfn*pri(ic)
                    ucu(ic) = ucu(ic) + (2.*(uht-uoi(ic)*(eta(ic)-eta(ic&
&                     +1)))-(uoi(ic)+uoi(ic+1))*eta(ic+1))*tem
                    vcu(ic) = vcu(ic) + (2.*(vht-voi(ic)*(eta(ic)-eta(ic&
&                     +1)))-(voi(ic)+voi(ic+1))*eta(ic+1))*tem
                    DO l=ic,k
                      uoi(l) = uoi(l) + ucu(l)
                      voi(l) = voi(l) + vcu(l)
                    END DO
                  END IF
                END IF
              END IF
            END IF
          END IF
        END IF
      END IF
    END DO
!CLOUD LOOP
    IF (SUM(rmf(icmin:k)) .GT. 0.0) THEN
      tho(i, icmin:k-1) = poi(icmin:k-1)
      qho(i, icmin:k-1) = qoi(icmin:k-1)
      uho(i, icmin:k-1) = uoi(icmin:k-1)
      vho(i, icmin:k-1) = voi(icmin:k-1)
!De-strap tendencies from RAS
      wght = wgt1(i, :)
!Scale properly by layer masses
      wght0 = 0.
      DO l=k,k0
        wght0 = wght0 + wght(l)*(ple(i, l+1)-ple(i, l))
      END DO
      wght0 = (prs(k+1)-prs(k))/wght0
      wght = wght0*wght
      DO l=k,k0
        tho(i, l) = tho(i, l) + wght(l)*(poi(k)-poi_sv(k))
        qho(i, l) = qho(i, l) + wght(l)*(qoi(k)-qoi_sv(k))
        uho(i, l) = uho(i, l) + wght(l)*(uoi(k)-uoi_sv(k))
        vho(i, l) = vho(i, l) + wght(l)*(voi(k)-voi_sv(k))
      END DO
!DO_TRACERS
      xhod(i, icmin:k-1, :) = xoid(icmin:k-1, :)
      xho(i, icmin:k-1, :) = xoi(icmin:k-1, :)
      DO itr=1,itrcr
        DO l=k,k0
          xhod(i, l, itr) = xhod(i, l, itr) + wght(l)*(xoid(k, itr)-&
&           xoi_svd(k, itr))
          xho(i, l, itr) = xho(i, l, itr) + wght(l)*(xoi(k, itr)-xoi_sv(&
&           k, itr))
        END DO
      END DO
    END IF
  END IF
END SUBROUTINE RASE_TRACER_D

END MODULE CONVECTION_TL
