MODULE CONVECTION_AD

USE CONVECTION

IMPLICIT NONE

PRIVATE
PUBLIC :: rase_b, rase_tracer_b

CONTAINS

!        Generated by TAPENADE     (INRIA, Tropics team)
!  Tapenade 3.9 (r5096) - 24 Feb 2014 16:53
!
!  Differentiation of rase in reverse (adjoint) mode:
!   gradient     of useful results: clw cnv_prc3 tho qho vho cnv_updfrc
!                uho flxd
!   with respect to varying inputs: clw cnv_prc3 tho qho vho cnv_updfrc
!                uho flxd
!   RW status of diff variables: clw:in-zero cnv_prc3:in-zero tho:in-out
!                qho:in-out vho:in-out cnv_updfrc:in-zero uho:in-out
!                flxd:in-zero
SUBROUTINE RASE_B(idim, irun, k0, icmin, dt, cons_cp, cons_alhl, &
& cons_grav, cons_rgas, cons_h2omw, cons_airmw, cons_vireps, seedras, &
& sige, kcbl, wgt0, wgt1, frland, ts, tho, thob, qho, qhob, uho, uhob, &
& vho, vhob, co_auto, ple, clw, clwb, flxd, flxdb, cnv_prc3, cnv_prc3b, &
& cnv_updfrc, cnv_updfrcb, rasparams, estblx)
  IMPLICIT NONE
!INPUTS
  INTEGER, INTENT(IN) :: idim, irun, k0, icmin
  REAL*8, DIMENSION(idim, k0 + 1), INTENT(IN) :: ple
  REAL*8, DIMENSION(k0 + 1), INTENT(IN) :: sige
  REAL*8, INTENT(IN) :: dt, cons_cp, cons_alhl, cons_grav, cons_rgas
  REAL*8, INTENT(IN) :: cons_h2omw, cons_airmw, cons_vireps
  INTEGER, DIMENSION(idim), INTENT(IN) :: seedras
  INTEGER, DIMENSION(idim), INTENT(IN) :: kcbl
  REAL*8, DIMENSION(idim), INTENT(IN) :: ts, frland
  REAL*8, DIMENSION(idim), INTENT(IN) :: co_auto
  REAL*8, DIMENSION(idim, k0), INTENT(IN) :: wgt0, wgt1
  REAL*8, DIMENSION(:), INTENT(IN) :: rasparams
  REAL*8, DIMENSION(:), INTENT(IN) :: estblx
!OUTPUTS
  REAL*8, DIMENSION(idim, k0) :: clw, flxd
  REAL*8, DIMENSION(idim, k0) :: clwb, flxdb
  REAL*8, DIMENSION(idim, k0) :: cnv_prc3
  REAL*8, DIMENSION(idim, k0) :: cnv_prc3b
  REAL*8, DIMENSION(idim, k0) :: cnv_updfrc
  REAL*8, DIMENSION(idim, k0) :: cnv_updfrcb
!PROGNOSTIC
  REAL*8, DIMENSION(idim, k0), INTENT(INOUT) :: tho, qho, uho, vho
  REAL*8, DIMENSION(idim, k0), INTENT(INOUT) :: thob
!LOCALS
  INTEGER :: i, ic, l, kk, k
!Parameters
  REAL*8, PARAMETER :: onepkap=1.+2./7., daylen=86400.0
  REAL*8, PARAMETER :: rhmax=0.9999
  REAL*8, PARAMETER :: cbl_qpert=0.0, cbl_tpert=1.0
  REAL*8, PARAMETER :: cbl_tpert_mxocn=2.0, cbl_tpert_mxlnd=4.0
!Constants
  REAL*8 :: grav, cp, alhl, cpbg, alhi, cpi, gravi, ddt, lbcp
!Rasparams
  REAL*8 :: fricfac, cli_crit, rasal1, rasal2
  REAL*8 :: friclambda
  REAL*8 :: sdqv2, sdqv3, sdqvt1
  REAL*8 :: acritfac, pblfrac, autorampb
  REAL*8 :: maxdallowed, rhmn, rhmx
  REAL*8 :: mxdiam
  REAL*8 :: tx2, tx3, akm, acr, alm, tth, qqh, dqx
  REAL*8 :: tx2b, tx3b, akmb, almb
  REAL*8 :: wfn, tem, trg, trgexp, evp, wlq, qcc
  REAL*8 :: wfnb, temb, trgb, wlqb, qccb
  REAL*8 :: cli, te_a, c00_x, cli_crit_x, toki
  REAL*8 :: clib, te_ab, c00_xb, cli_crit_xb, tokib
  REAL*8 :: dt_lyr, rate, cvw_x, closs, f2, f3, f4
  REAL*8 :: dt_lyrb, rateb, cvw_xb, clossb, f2b
  REAL*8 :: wght0, prcbl, rndu
  REAL*8 :: lambda_min, lambda_max
  REAL*8 :: tpert, qpert
  REAL*8 :: tpertb
  REAL*8 :: uht, vht
  REAL*8 :: uhtb, vhtb
  REAL*8, DIMENSION(k0) :: poi_sv, qoi_sv, uoi_sv, voi_sv
  REAL*8, DIMENSION(k0) :: poi_svb, qoi_svb, uoi_svb, voi_svb
  REAL*8, DIMENSION(k0) :: poi, qoi, uoi, voi, dqq, bet, gam, cll
  REAL*8, DIMENSION(k0) :: poib, qoib, uoib, voib, dqqb, betb, gamb, &
& cllb
  REAL*8, DIMENSION(k0) :: poi_c, qoi_c
  REAL*8, DIMENSION(k0) :: poi_cb, qoi_cb
  REAL*8, DIMENSION(k0) :: prh, pri, ght, dpt, dpb, pki
  REAL*8, DIMENSION(k0) :: ghtb
  REAL*8, DIMENSION(k0) :: ucu, vcu
  REAL*8, DIMENSION(k0) :: ucub, vcub
  REAL*8, DIMENSION(k0) :: cln, rns, pol
  REAL*8, DIMENSION(k0) :: rnsb
  REAL*8, DIMENSION(k0) :: qst, ssl, rmf, rnn, rn1, rmfc, rmfp
  REAL*8, DIMENSION(k0) :: qstb, sslb, rnnb, rmfpb
  REAL*8, DIMENSION(k0) :: gms, eta, gmh, eht, gm1, hcc, rmfd
  REAL*8, DIMENSION(k0) :: gmsb, etab, gmhb, ehtb, gm1b, hccb, rmfdb
  REAL*8, DIMENSION(k0) :: hol, hst, qol, zol, hcld, cll0, cllx, clli
  REAL*8, DIMENSION(k0) :: holb, hstb, qolb, zolb, hcldb, cll0b
  REAL*8, DIMENSION(k0) :: bke, cvw, updfrc
  REAL*8, DIMENSION(k0) :: cvwb, updfrcb
  REAL*8, DIMENSION(k0) :: rasal, updfrp, bk2, dll0, dllx
  REAL*8, DIMENSION(k0) :: rasalb, updfrpb, bk2b
  REAL*8, DIMENSION(k0) :: wght, massf
  REAL*8, DIMENSION(k0) :: qss, dqs, pf, pk, tempf, zlo
  REAL*8, DIMENSION(k0) :: qssb, dqsb, tempfb, zlob
  REAL*8, DIMENSION(k0 + 1) :: prj, prs, qht, sht, zet, zle, pke
  REAL*8, DIMENSION(k0+1) :: qhtb, shtb, zetb, zleb
  INTRINSIC MAX
  INTRINSIC MIN
  INTRINSIC SQRT
  INTRINSIC EXP
  INTRINSIC SUM
  REAL*8 :: arg1
  REAL*8 :: arg1b
  INTEGER :: branch
  INTEGER :: ad_to
  INTEGER :: ad_from
  INTEGER :: ad_from0
  INTEGER :: ad_from1
  INTEGER :: ad_to0
  INTEGER :: ad_to1
  INTEGER :: ad_from2
  INTEGER :: ad_to2
  INTEGER :: ad_to3
  INTEGER :: ad_from3
  INTEGER :: ad_from4
  INTEGER :: ad_to4
  INTEGER :: ad_from5
  REAL*8, DIMENSION(idim, k0), INTENT(INOUT) :: vhob
  REAL*8, DIMENSION(idim, k0), INTENT(INOUT) :: uhob
  REAL*8, DIMENSION(idim, k0), INTENT(INOUT) :: qhob
  REAL*8 :: temp3
  REAL*8 :: temp2
  REAL*8 :: temp1
  REAL*8 :: temp0
  REAL*8 :: tempb9
  REAL*8 :: tempb8
  REAL*8 :: tempb7
  REAL*8 :: tempb6
  REAL*8 :: max2b
  REAL*8 :: tempb5
  REAL*8 :: tempb4
  REAL*8 :: tempb19
  REAL*8 :: tempb3
  REAL*8 :: tempb18
  REAL*8 :: tempb2
  REAL*8 :: tempb17
  REAL*8 :: tempb1
  REAL*8 :: tempb16
  REAL*8 :: tempb0
  REAL*8 :: tempb15
  REAL*8 :: tempb14
  REAL*8 :: tempb13
  REAL*8 :: tempb12
  REAL*8 :: tempb11
  REAL*8 :: tempb10
  REAL*8 :: x1
  REAL*8 :: tempb40
  REAL*8 :: max1b
  REAL*8 :: tempb
  REAL*8 :: tempb39
  REAL*8 :: tempb38
  REAL*8 :: tempb37
  REAL*8 :: tempb36
  REAL*8 :: tempb35
  REAL*8 :: tempb34
  REAL*8 :: tempb33
  REAL*8 :: x1b
  REAL*8 :: tempb32
  REAL*8 :: tempb31
  REAL*8 :: tempb30
  REAL*8 :: tempb29
  REAL*8 :: tempb28
  REAL*8 :: tempb27
  REAL*8 :: tempb26
  REAL*8 :: tempb25
  REAL*8 :: temp
  REAL*8 :: tempb24
  REAL*8 :: tempb23
  REAL*8 :: max2
  REAL*8 :: tempb22
  REAL*8 :: max1
  REAL*8 :: tempb21
  REAL*8 :: temp9
  REAL*8 :: temp8
  REAL*8 :: tempb20
  REAL*8 :: temp7
  REAL*8 :: temp6
  REAL*8 :: temp5
  REAL*8 :: y1
  REAL*8 :: temp4
!Initialize Local Arrays
  poi = 0.0
  qoi = 0.0
  uoi = 0.0
  voi = 0.0
  dqq = 0.0
  bet = 0.0
  gam = 0.0
  prh = 0.0
  pri = 0.0
  ght = 0.0
  dpt = 0.0
  dpb = 0.0
  pki = 0.0
  ucu = 0.0
  vcu = 0.0
  pol = 0.0
  qst = 0.0
  ssl = 0.0
  rnn = 0.0
  gms = 0.0
  eta = 0.0
  gmh = 0.0
  eht = 0.0
  gm1 = 0.0
  hcc = 0.0
  hst = 0.0
  qol = 0.0
  zol = 0.0
  hcld = 0.0
  rasal = 0.0
  bk2 = 0.0
  qss = 0.0
  dqs = 0.0
  prj = 0.0
  prs = 0.0
  qht = 0.0
  sht = 0.0
  zet = 0.0
!Initialize Outputs
!  ---  1
  fricfac = rasparams(1)
!  ---  4
  cli_crit = rasparams(4)
!  ---  5
  rasal1 = rasparams(5)
!  ---  6
  rasal2 = rasparams(6)
!  --- 11
  friclambda = rasparams(11)
!  --- 14
  sdqv2 = rasparams(14)
!  --- 15
  sdqv3 = rasparams(15)
!  --- 16
  sdqvt1 = rasparams(16)
!  --- 17
  acritfac = rasparams(17)
!  --- 20
  pblfrac = rasparams(20)
!  --- 21
  autorampb = rasparams(21)
!  --- 24
  rhmn = rasparams(24)
!  --- 24
  maxdallowed = rasparams(23)
!  --- 25
  rhmx = rasparams(25)
  grav = cons_grav
  alhl = cons_alhl
  cp = cons_cp
  cpi = 1.0/cp
  alhi = 1.0/alhl
  gravi = 1.0/grav
  cpbg = cp*gravi
  ddt = daylen/dt
  lbcp = alhl*cpi
  i = 1
!CALL FINDBASE
  k = kcbl(i)
  IF (k .GT. 0) THEN
!Get saturation specific humidity and gradient wrt to T
    pke = (ple(i, :)/1000.)**(cons_rgas/cons_cp)
    pf = 0.5*(ple(i, 1:k0)+ple(i, 2:k0+1))
    pk = (pf/1000.)**(cons_rgas/cons_cp)
    tempf = tho(i, :)*pk
    zle = 0.0
    zlo = 0.0
    zle(k0+1) = 0.
    DO l=k0,1,-1
      zle(l) = tho(i, l)*(1.+cons_vireps*qho(i, l))
      zlo(l) = zle(l+1) + cons_cp/cons_grav*(pke(l+1)-pk(l))*zle(l)
      zle(l) = zlo(l) + cons_cp/cons_grav*(pk(l)-pke(l))*zle(l)
    END DO
    tpert = cbl_tpert*(ts(i)-(tempf(k0)+cons_grav*zlo(k0)/cons_cp))
!* ( QSSFC - Q(:,:,K0) ) [CBL_QPERT = 0.0]
    qpert = cbl_qpert
    IF (tpert .LT. 0.0) THEN
      tpert = 0.0
      CALL PUSHCONTROL1B(0)
    ELSE
      CALL PUSHCONTROL1B(1)
      tpert = tpert
    END IF
    IF (qpert .LT. 0.0) THEN
      qpert = 0.0
    ELSE
      qpert = qpert
    END IF
    IF (frland(i) .LT. 0.1) THEN
      IF (tpert .GT. cbl_tpert_mxocn) THEN
        tpert = cbl_tpert_mxocn
        CALL PUSHCONTROL2B(1)
      ELSE
        CALL PUSHCONTROL2B(0)
        tpert = tpert
      END IF
    ELSE IF (tpert .GT. cbl_tpert_mxlnd) THEN
      tpert = cbl_tpert_mxlnd
      CALL PUSHCONTROL2B(3)
    ELSE
      CALL PUSHCONTROL2B(2)
      tpert = tpert
    END IF
    CALL DQSAT_RAS(dqs, qss, tempf, pf, k0, estblx, cons_h2omw, &
&            cons_airmw)
    DO kk=icmin,k+1
      prj(kk) = pke(kk)
    END DO
    prs(icmin:k0+1) = ple(i, icmin:k0+1)
    poi(icmin:k) = tho(i, icmin:k)
    qoi(icmin:k) = qho(i, icmin:k)
    uoi(icmin:k) = uho(i, icmin:k)
    voi(icmin:k) = vho(i, icmin:k)
    qst(icmin:k) = qss(icmin:k)
    dqq(icmin:k) = dqs(icmin:k)
!Mass fraction of each layer below cloud base
    massf(:) = wgt0(i, :)
!RESET PRESSURE at bottom edge of CBL 
    prcbl = prs(k)
    DO l=k,k0
      prcbl = prcbl + massf(l)*(prs(l+1)-prs(l))
    END DO
    prs(k+1) = prcbl
    prj(k+1) = (prs(k+1)/1000.)**(cons_rgas/cons_cp)
    DO l=k,icmin,-1
      pol(l) = 0.5*(prs(l)+prs(l+1))
      prh(l) = (prs(l+1)*prj(l+1)-prs(l)*prj(l))/(onepkap*(prs(l+1)-prs(&
&       l)))
      pki(l) = 1.0/prh(l)
      dpt(l) = prh(l) - prj(l)
      dpb(l) = prj(l+1) - prh(l)
      pri(l) = .01/(prs(l+1)-prs(l))
    END DO
!RECALCULATE PROFILE QUAN. IN LOWEST STRAPPED LAYER
    IF (k .LE. k0) THEN
      poi(k) = 0.
      qoi(k) = 0.
      uoi(k) = 0.
      voi(k) = 0.
!SPECIFY WEIGHTS GIVEN TO EACH LAYER WITHIN SUBCLOUD "SUPERLAYER"
      wght = 0.
      DO l=k,k0
        wght(l) = massf(l)*(ple(i, l+1)-ple(i, l))/(prs(k+1)-prs(k))
      END DO
      DO l=k,k0
        poi(k) = poi(k) + wght(l)*tho(i, l)
        qoi(k) = qoi(k) + wght(l)*qho(i, l)
        uoi(k) = uoi(k) + wght(l)*uho(i, l)
        voi(k) = voi(k) + wght(l)*vho(i, l)
      END DO
      arg1 = poi(k)*prh(k)
      CALL DQSATS_RAS(dqq(k), qst(k), arg1, pol(k), estblx, cons_h2omw, &
&               cons_airmw)
      CALL PUSHCONTROL1B(1)
    ELSE
      CALL PUSHCONTROL1B(0)
    END IF
    IF (seedras(i)/1000000. .LT. 1e-6) THEN
      rndu = 1e-6
    ELSE
      rndu = seedras(i)/1000000.
    END IF
    mxdiam = maxdallowed*rndu**(-(1./2.))
    DO l=k,icmin,-1
!*
      bet(l) = dqq(l)*pki(l)
!*
      gam(l) = pki(l)/(1.0+lbcp*dqq(l))
      IF (l .LT. k) THEN
        ght(l+1) = gam(l)*dpb(l) + gam(l+1)*dpt(l+1)
        gm1(l+1) = 0.5*lbcp*(dqq(l)/(alhl*(1.0+lbcp*dqq(l)))+dqq(l+1)/(&
&         alhl*(1.0+lbcp*dqq(l+1))))
        CALL PUSHCONTROL1B(1)
      ELSE
        CALL PUSHCONTROL1B(0)
      END IF
    END DO
    rmf = 0.
    cvw = 0.0
! HOL initialized here in order not to confuse Valgrind debugger
    hol = 0.
    zet(k+1) = 0
    sht(k+1) = cp*poi(k)*prj(k+1)
    DO l=k,icmin,-1
      IF (qst(l)*rhmax .GT. qoi(l)) THEN
        qol(l) = qoi(l)
        CALL PUSHCONTROL1B(0)
      ELSE
        qol(l) = qst(l)*rhmax
        CALL PUSHCONTROL1B(1)
      END IF
      IF (0.000 .LT. qol(l)) THEN
        CALL PUSHCONTROL1B(0)
        qol(l) = qol(l)
      ELSE
        qol(l) = 0.000
        CALL PUSHCONTROL1B(1)
      END IF
      ssl(l) = cp*prj(l+1)*poi(l) + grav*zet(l+1)
      hol(l) = ssl(l) + qol(l)*alhl
      hst(l) = ssl(l) + qst(l)*alhl
      tem = poi(l)*(prj(l+1)-prj(l))*cpbg
      zet(l) = zet(l+1) + tem
      zol(l) = zet(l+1) + (prj(l+1)-prh(l))*poi(l)*cpbg
    END DO
    DO ic=k,icmin+1,-1
      ucu(icmin:) = 0.
      vcu(icmin:) = 0.
      IF (1. .GT. (qoi(k)/qst(k)-rhmn)/(rhmx-rhmn)) THEN
        CALL PUSHREAL8(trg)
        trg = (qoi(k)/qst(k)-rhmn)/(rhmx-rhmn)
        CALL PUSHCONTROL1B(0)
      ELSE
        CALL PUSHREAL8(trg)
        trg = 1.
        CALL PUSHCONTROL1B(1)
      END IF
      IF (0.0 .LT. (autorampb-sige(ic))/0.2) THEN
        y1 = (autorampb-sige(ic))/0.2
      ELSE
        y1 = 0.0
      END IF
      IF (1.0 .GT. y1) THEN
        CALL PUSHREAL8(f4)
        f4 = y1
        CALL PUSHCONTROL1B(0)
      ELSE
        CALL PUSHREAL8(f4)
        f4 = 1.0
        CALL PUSHCONTROL1B(1)
      END IF
      IF (trg .LE. 1.0e-5) THEN
        CALL PUSHCONTROL3B(6)
      ELSE
!================>>
!RECOMPUTE SOUNDING UP TO DETRAINMENT LEVEL
        poi_c = poi
        qoi_c = qoi
        poi_c(k) = poi_c(k) + tpert
        qoi_c(k) = qoi_c(k) + qpert
        CALL PUSHREAL8(zet(k+1))
        zet(k+1) = 0.
        CALL PUSHREAL8(sht(k+1))
        sht(k+1) = cp*poi_c(k)*prj(k+1)
        DO l=k,ic,-1
          IF (qst(l)*rhmax .GT. qoi_c(l)) THEN
            CALL PUSHREAL8(qol(l))
            qol(l) = qoi_c(l)
            CALL PUSHCONTROL1B(0)
          ELSE
            CALL PUSHREAL8(qol(l))
            qol(l) = qst(l)*rhmax
            CALL PUSHCONTROL1B(1)
          END IF
          IF (0.000 .LT. qol(l)) THEN
            CALL PUSHCONTROL1B(0)
            qol(l) = qol(l)
          ELSE
            qol(l) = 0.000
            CALL PUSHCONTROL1B(1)
          END IF
          CALL PUSHREAL8(ssl(l))
          ssl(l) = cp*prj(l+1)*poi_c(l) + grav*zet(l+1)
          CALL PUSHREAL8(hol(l))
          hol(l) = ssl(l) + qol(l)*alhl
          CALL PUSHREAL8(hst(l))
          hst(l) = ssl(l) + qst(l)*alhl
          CALL PUSHREAL8(tem)
          tem = poi_c(l)*(prj(l+1)-prj(l))*cpbg
          CALL PUSHREAL8(zet(l))
          zet(l) = zet(l+1) + tem
          CALL PUSHREAL8(zol(l))
          zol(l) = zet(l+1) + (prj(l+1)-prh(l))*poi_c(l)*cpbg
        END DO
        CALL PUSHINTEGER4(l + 1)
        ad_from = ic + 1
        DO l=ad_from,k
          CALL PUSHREAL8(tem)
          tem = (prj(l)-prh(l-1))/(prh(l)-prh(l-1))
          CALL PUSHREAL8(sht(l))
          sht(l) = ssl(l-1) + tem*(ssl(l)-ssl(l-1))
          CALL PUSHREAL8(qht(l))
          qht(l) = .5*(qol(l)+qol(l-1))
        END DO
        CALL PUSHINTEGER4(ad_from)
!CALCULATE LAMBDA, ETA, AND WORKFUNCTION
        CALL PUSHREAL8(lambda_min)
        lambda_min = .2/mxdiam
        lambda_max = .2/200.
        IF (hol(k) .LE. hst(ic)) THEN
          CALL PUSHCONTROL3B(5)
        ELSE
!================>>
!LAMBDA CALCULATION: MS-A18
          CALL PUSHREAL8(tem)
          tem = (hst(ic)-hol(ic))*(zol(ic)-zet(ic+1))
          ad_from0 = ic + 1
          DO l=ad_from0,k-1
            tem = tem + (hst(ic)-hol(l))*(zet(l)-zet(l+1))
          END DO
          CALL PUSHINTEGER4(ad_from0)
          IF (tem .LE. 0.0) THEN
            CALL PUSHCONTROL3B(4)
          ELSE
!================>>
            CALL PUSHREAL8(alm)
            alm = (hol(k)-hst(ic))/tem
            IF (alm .GT. lambda_max) THEN
              CALL PUSHCONTROL3B(3)
            ELSE
!================>>
              CALL PUSHREAL8(toki)
              toki = 1.0
              IF (alm .LT. lambda_min) THEN
                toki = (alm/lambda_min)**2
                CALL PUSHCONTROL1B(1)
              ELSE
                CALL PUSHCONTROL1B(0)
              END IF
              ad_from1 = ic + 1
!ETA CALCULATION: MS-A2
              DO l=ad_from1,k
                CALL PUSHREAL8(eta(l))
                eta(l) = 1.0 + alm*(zet(l)-zet(k))
              END DO
              CALL PUSHINTEGER4(ad_from1)
              CALL PUSHREAL8(eta(ic))
              eta(ic) = 1.0 + alm*(zol(ic)-zet(k))
!WORKFUNCTION CALCULATION:  MS-A22
              wfn = 0.0
              CALL PUSHREAL8(hcc(k))
              hcc(k) = hol(k)
              DO l=k-1,ic+1,-1
                CALL PUSHREAL8(hcc(l))
                hcc(l) = hcc(l+1) + (eta(l)-eta(l+1))*hol(l)
                CALL PUSHREAL8(tem)
                tem = hcc(l+1)*dpb(l) + hcc(l)*dpt(l)
                CALL PUSHREAL8(eht(l))
                eht(l) = eta(l+1)*dpb(l) + eta(l)*dpt(l)
                wfn = wfn + (tem-eht(l)*hst(l))*gam(l)
              END DO
              CALL PUSHINTEGER4(l + 1)
              CALL PUSHREAL8(hcc(ic))
              hcc(ic) = hst(ic)*eta(ic)
              wfn = wfn + (hcc(ic+1)-hst(ic)*eta(ic+1))*gam(ic)*dpb(ic)
!VERTICAL VELOCITY/KE CALCULATION (ADDED 12/2001 JTB)
              bk2(k) = 0.0
              CALL PUSHREAL8(hcld(k))
              hcld(k) = hol(k)
              DO l=k-1,ic,-1
                CALL PUSHREAL8(hcld(l))
                hcld(l) = (eta(l+1)*hcld(l+1)+(eta(l)-eta(l+1))*hol(l))/&
&                 eta(l)
                CALL PUSHREAL8(tem)
                tem = (hcld(l)-hst(l))*(zet(l)-zet(l+1))/(1.0+lbcp*dqq(l&
&                 ))
                IF (tem .LT. 0.0) THEN
                  CALL PUSHREAL8(max1)
                  max1 = 0.0
                  CALL PUSHCONTROL1B(0)
                ELSE
                  CALL PUSHREAL8(max1)
                  max1 = tem
                  CALL PUSHCONTROL1B(1)
                END IF
                bk2(l) = bk2(l+1) + grav*max1/(cp*prj(l+1)*poi(l))
                IF (bk2(l) .LT. 0.0) THEN
                  CALL PUSHREAL8(max2)
                  max2 = 0.0
                  CALL PUSHCONTROL1B(0)
                ELSE
                  CALL PUSHREAL8(max2)
                  max2 = bk2(l)
                  CALL PUSHCONTROL1B(1)
                END IF
                CALL PUSHREAL8(cvw(l))
                cvw(l) = SQRT(2.0*max2)
              END DO
              CALL PUSHINTEGER4(l + 1)
!ALPHA CALCULATION 
              IF (zet(ic) .LT. 2000.) THEN
                rasal(ic) = rasal1
                CALL PUSHCONTROL1B(0)
              ELSE
                CALL PUSHCONTROL1B(1)
              END IF
              IF (zet(ic) .GE. 2000.) THEN
                rasal(ic) = rasal1 + (rasal2-rasal1)*(zet(ic)-2000.)/&
&                 8000.
                CALL PUSHCONTROL1B(1)
              ELSE
                CALL PUSHCONTROL1B(0)
              END IF
              IF (rasal(ic) .GT. 1.0e5) THEN
                rasal(ic) = 1.0e5
                CALL PUSHCONTROL1B(0)
              ELSE
                CALL PUSHCONTROL1B(1)
                rasal(ic) = rasal(ic)
              END IF
              CALL PUSHREAL8(rasal(ic))
              rasal(ic) = dt/rasal(ic)
              ad_from2 = ic
              DO l=ad_from2,k
                IF (cvw(l) .LT. 1.00) THEN
                  CALL PUSHREAL8(cvw(l))
                  cvw(l) = 1.00
                  CALL PUSHCONTROL1B(0)
                ELSE
                  CALL PUSHREAL8(cvw(l))
                  cvw(l) = cvw(l)
                  CALL PUSHCONTROL1B(1)
                END IF
              END DO
              CALL PUSHINTEGER4(ad_from2)
              CALL PUSHREAL8(acr)
              CALL ACRITN(pol(ic), prs(k), acr, acritfac)
              IF (wfn .LE. acr) THEN
                CALL PUSHCONTROL3B(2)
              ELSE
!================>>
                CALL PUSHREAL8(wlq)
                wlq = qol(k)
                CALL PUSHREAL8(uht)
                uht = uoi(k)
                CALL PUSHREAL8(vht)
                vht = voi(k)
                CALL PUSHREAL8(rnn(k))
                rnn(k) = 0.
                DO l=k-1,ic,-1
                  CALL PUSHREAL8(tem)
                  tem = eta(l) - eta(l+1)
                  wlq = wlq + tem*qol(l)
                  uht = uht + tem*uoi(l)
                  vht = vht + tem*voi(l)
                  IF (l .GT. ic) THEN
                    CALL PUSHREAL8(tx2)
                    tx2 = 0.5*(qst(l)+qst(l-1))*eta(l)
                    CALL PUSHREAL8(tx3)
                    tx3 = 0.5*(hst(l)+hst(l-1))*eta(l)
                    qcc = tx2 + gm1(l)*(hcc(l)-tx3)
                    CALL PUSHREAL8(cll0(l))
                    cll0(l) = wlq - qcc
                    CALL PUSHCONTROL1B(1)
                  ELSE
                    CALL PUSHREAL8(cll0(l))
                    cll0(l) = wlq - qst(ic)*eta(ic)
                    CALL PUSHCONTROL1B(0)
                  END IF
                  IF (cll0(l) .LT. 0.00) THEN
                    cll0(l) = 0.00
                    CALL PUSHCONTROL1B(0)
                  ELSE
                    CALL PUSHCONTROL1B(1)
                    cll0(l) = cll0(l)
                  END IF
                  cli = cll0(l)/eta(l)
                  te_a = poi(l)*prh(l)
                  CALL PUSHREAL8(f3)
                  CALL PUSHREAL8(f2)
                  CALL SUNDQ3_ICE(te_a, sdqv2, sdqv3, sdqvt1, f2, f3)
                  CALL PUSHREAL8(c00_x)
                  c00_x = co_auto(i)*f2*f3*f4
                  cli_crit_x = cli_crit/(f2*f3)
                  CALL PUSHREAL8(rate)
                  rate = c00_x*(1.0-EXP(-(cli**2/cli_crit_x**2)))
                  IF (cvw(l) .LT. 1.00) THEN
                    CALL PUSHREAL8(cvw_x)
                    cvw_x = 1.00
                    CALL PUSHCONTROL1B(0)
                  ELSE
                    CALL PUSHREAL8(cvw_x)
                    cvw_x = cvw(l)
                    CALL PUSHCONTROL1B(1)
                  END IF
                  dt_lyr = (zet(l)-zet(l+1))/cvw_x
                  closs = cll0(l)*rate*dt_lyr
                  IF (closs .GT. cll0(l)) THEN
                    closs = cll0(l)
                    CALL PUSHCONTROL1B(0)
                  ELSE
                    closs = closs
                    CALL PUSHCONTROL1B(1)
                  END IF
                  IF (closs .GT. 0.) THEN
                    wlq = wlq - closs
                    CALL PUSHREAL8(rnn(l))
                    rnn(l) = closs
                    CALL PUSHCONTROL1B(1)
                  ELSE
                    CALL PUSHREAL8(rnn(l))
                    rnn(l) = 0.
                    CALL PUSHCONTROL1B(0)
                  END IF
                END DO
                CALL PUSHINTEGER4(l + 1)
                wlq = wlq - qst(ic)*eta(ic)
!CALCULATE GAMMAS AND KERNEL
                CALL PUSHREAL8(gms(k))
                gms(k) = (sht(k)-ssl(k))*pri(k)
                CALL PUSHREAL8(gmh(k))
                gmh(k) = gms(k) + (qht(k)-qol(k))*pri(k)*alhl
                CALL PUSHREAL8(akm)
                akm = gmh(k)*gam(k-1)*dpb(k-1)
                CALL PUSHREAL8(tx2)
                tx2 = gmh(k)
                DO l=k-1,ic+1,-1
                  CALL PUSHREAL8(gms(l))
                  gms(l) = (eta(l)*(sht(l)-ssl(l))+eta(l+1)*(ssl(l)-sht(&
&                   l+1)))*pri(l)
                  CALL PUSHREAL8(gmh(l))
                  gmh(l) = gms(l) + (eta(l)*(qht(l)-qol(l))+eta(l+1)*(&
&                   qol(l)-qht(l+1)))*alhl*pri(l)
                  CALL PUSHREAL8(tx2)
                  tx2 = tx2 + (eta(l)-eta(l+1))*gmh(l)
                  akm = akm - gms(l)*eht(l)*pki(l) + tx2*ght(l)
                END DO
                CALL PUSHINTEGER4(l + 1)
                CALL PUSHREAL8(gms(ic))
                gms(ic) = eta(ic+1)*(ssl(ic)-sht(ic+1))*pri(ic)
                akm = akm - gms(ic)*eta(ic+1)*dpb(ic)*pki(ic)
                CALL PUSHREAL8(gmh(ic))
                gmh(ic) = gms(ic) + (eta(ic+1)*(qol(ic)-qht(ic+1))*alhl+&
&                 eta(ic)*(hst(ic)-hol(ic)))*pri(ic)
!CLOUD BASE MASS FLUX
                IF (akm .GE. 0.0 .OR. wlq .LT. 0.0) THEN
                  CALL PUSHCONTROL3B(1)
                ELSE
!================>>
                  CALL PUSHREAL8(wfn)
                  wfn = -((wfn-acr)/akm)
                  x1 = rasal(ic)*trg*toki*wfn
                  IF (x1 .GT. (prs(k+1)-prs(k))*(100.*pblfrac)) THEN
                    CALL PUSHREAL8(wfn)
                    wfn = (prs(k+1)-prs(k))*(100.*pblfrac)
                    CALL PUSHCONTROL1B(0)
                  ELSE
                    CALL PUSHREAL8(wfn)
                    wfn = x1
                    CALL PUSHCONTROL1B(1)
                  END IF
!CUMULATIVE PRECIP AND CLOUD-BASE MASS FLUX FOR OUTPUT
                  CALL PUSHREAL8(tem)
                  tem = wfn*gravi
                  rmf(ic) = rmf(ic) + tem
                  ad_from3 = ic + 1
                  DO l=ad_from3,k
                    CALL PUSHREAL8(rmfp(l))
                    rmfp(l) = tem*eta(l)
                    IF (cvw(l) .GT. 0.0) THEN
                      CALL PUSHCONTROL1B(0)
                    ELSE
                      CALL PUSHCONTROL1B(1)
                    END IF
                  END DO
                  CALL PUSHINTEGER4(ad_from3)
                  ad_from4 = ic
!THETA AND Q CHANGE DUE TO CLOUD TYPE IC
                  DO l=ad_from4,k
                    CALL PUSHREAL8(gmh(l))
                    gmh(l) = gmh(l)*wfn
                    CALL PUSHREAL8(gms(l))
                    gms(l) = gms(l)*wfn
                    CALL PUSHREAL8(qoi(l))
                    qoi(l) = qoi(l) + (gmh(l)-gms(l))*alhi
                    CALL PUSHREAL8(poi(l))
                    poi(l) = poi(l) + gms(l)*pki(l)*cpi
                    CALL PUSHREAL8(qst(l))
                    qst(l) = qst(l) + gms(l)*bet(l)*cpi
                  END DO
                  CALL PUSHINTEGER4(ad_from4)
!*FRICFAC*0.5
                  CALL PUSHREAL8(wfn)
                  wfn = wfn*0.5*1.0
!CUMULUS FRICTION
                  IF (fricfac .LE. 0.0) THEN
                    CALL PUSHCONTROL3B(0)
                  ELSE
!================>>
                    CALL PUSHREAL8(wfn)
                    wfn = wfn*fricfac*EXP(-(alm/friclambda))
                    CALL PUSHREAL8(tem)
                    tem = wfn*pri(k)
                    ucu(k) = ucu(k) + tem*(uoi(k-1)-uoi(k))
                    vcu(k) = vcu(k) + tem*(voi(k-1)-voi(k))
                    DO l=k-1,ic+1,-1
                      CALL PUSHREAL8(tem)
                      tem = wfn*pri(l)
                      ucu(l) = ucu(l) + tem*((uoi(l-1)-uoi(l))*eta(l)+(&
&                       uoi(l)-uoi(l+1))*eta(l+1))
                      vcu(l) = vcu(l) + tem*((voi(l-1)-voi(l))*eta(l)+(&
&                       voi(l)-voi(l+1))*eta(l+1))
                    END DO
                    CALL PUSHINTEGER4(l + 1)
                    CALL PUSHREAL8(tem)
                    tem = wfn*pri(ic)
                    ucu(ic) = ucu(ic) + (2.*(uht-uoi(ic)*(eta(ic)-eta(ic&
&                     +1)))-(uoi(ic)+uoi(ic+1))*eta(ic+1))*tem
                    vcu(ic) = vcu(ic) + (2.*(vht-voi(ic)*(eta(ic)-eta(ic&
&                     +1)))-(voi(ic)+voi(ic+1))*eta(ic+1))*tem
                    ad_from5 = ic
                    DO l=ad_from5,k
                      CALL PUSHREAL8(uoi(l))
                      uoi(l) = uoi(l) + ucu(l)
                      CALL PUSHREAL8(voi(l))
                      voi(l) = voi(l) + vcu(l)
                    END DO
                    CALL PUSHINTEGER4(ad_from5)
                    CALL PUSHCONTROL3B(7)
                  END IF
                END IF
              END IF
            END IF
          END IF
        END IF
      END IF
    END DO
!CLOUD LOOP
    IF (SUM(rmf(icmin:k)) .GT. 0.0) THEN
      DO l=icmin,k
        CALL PUSHREAL8(tem)
      END DO
!De-strap tendencies from RAS
      CALL PUSHREAL8ARRAY(wght, k0)
      wght = wgt1(i, :)
!Scale properly by layer masses
      wght0 = 0.
      DO l=k,k0
        wght0 = wght0 + wght(l)*(ple(i, l+1)-ple(i, l))
      END DO
      wght0 = (prs(k+1)-prs(k))/wght0
      wght = wght0*wght
      IF (k .LT. k0) THEN
        clwb(i, k:k0) = 0.0_8
        flxdb(i, k:k0) = 0.0_8
      END IF
      clwb(i, 1:icmin-1) = 0.0_8
      flxdb(i, 1:icmin-1) = 0.0_8
      cllb = 0.0_8
      cllb(icmin:k) = cllb(icmin:k) + ddt*clwb(i, icmin:k)/daylen
      rmfdb = 0.0_8
      rmfdb(icmin:k) = rmfdb(icmin:k) + ddt*flxdb(i, icmin:k)/daylen
      qoi_svb = 0.0_8
      uoi_svb = 0.0_8
      qoib = 0.0_8
      voib = 0.0_8
      poib = 0.0_8
      poi_svb = 0.0_8
      uoib = 0.0_8
      voi_svb = 0.0_8
      DO l=k0,k,-1
        voib(k) = voib(k) + wght(l)*vhob(i, l)
        voi_svb(k) = voi_svb(k) - wght(l)*vhob(i, l)
        uoib(k) = uoib(k) + wght(l)*uhob(i, l)
        uoi_svb(k) = uoi_svb(k) - wght(l)*uhob(i, l)
        qoib(k) = qoib(k) + wght(l)*qhob(i, l)
        qoi_svb(k) = qoi_svb(k) - wght(l)*qhob(i, l)
        poib(k) = poib(k) + wght(l)*thob(i, l)
        poi_svb(k) = poi_svb(k) - wght(l)*thob(i, l)
      END DO
      CALL POPREAL8ARRAY(wght, k0)
      updfrcb = 0.0_8
      updfrcb(icmin:k-1) = updfrcb(icmin:k-1) + cnv_updfrcb(i, icmin:k-1&
&       )
      voib(icmin:k-1) = voib(icmin:k-1) + vhob(i, icmin:k-1)
      vhob(i, icmin:k-1) = 0.0_8
      uoib(icmin:k-1) = uoib(icmin:k-1) + uhob(i, icmin:k-1)
      uhob(i, icmin:k-1) = 0.0_8
      qoib(icmin:k-1) = qoib(icmin:k-1) + qhob(i, icmin:k-1)
      qhob(i, icmin:k-1) = 0.0_8
      poib(icmin:k-1) = poib(icmin:k-1) + thob(i, icmin:k-1)
      thob(i, icmin:k-1) = 0.0_8
      rnsb = 0.0_8
      DO l=k,icmin,-1
        tem = pri(l)*grav
        rnsb(l) = rnsb(l) + tem*cnv_prc3b(i, l)
        cnv_prc3b(i, l) = 0.0_8
        CALL POPREAL8(tem)
      END DO
    ehtb = 0.0_8
    gm1b = 0.0_8
    hccb = 0.0_8
    f2b = 0.0_8
    cvwb = 0.0_8
    dqqb = 0.0_8
    ucub = 0.0_8
    ghtb = 0.0_8
    hstb = 0.0_8
    betb = 0.0_8
    qhtb = 0.0_8
    tpertb = 0.0_8
    qolb = 0.0_8
    bk2b = 0.0_8
    rasalb = 0.0_8
    hcldb = 0.0_8
    etab = 0.0_8
    shtb = 0.0_8
    gmhb = 0.0_8
    rnnb = 0.0_8
    qstb = 0.0_8
    gmsb = 0.0_8
    vcub = 0.0_8
    sslb = 0.0_8
    zetb = 0.0_8
    updfrpb = 0.0_8
    zolb = 0.0_8
    cll0b = 0.0_8
    holb = 0.0_8
    rmfpb = 0.0_8
    gamb = 0.0_8
    DO ic=icmin+1,k,1
      CALL POPCONTROL3B(branch)
      IF (branch .LT. 4) THEN
        IF (branch .LT. 2) THEN
          IF (branch .EQ. 0) THEN
            wfnb = 0.0_8
            vhtb = 0.0_8
            almb = 0.0_8
            uhtb = 0.0_8
          ELSE
            trgb = 0.0_8
            wlqb = 0.0_8
            wfnb = 0.0_8
            vhtb = 0.0_8
            akmb = 0.0_8
            tokib = 0.0_8
            almb = 0.0_8
            uhtb = 0.0_8
            GOTO 100
          END IF
        ELSE IF (branch .EQ. 2) THEN
          trgb = 0.0_8
          wfnb = 0.0_8
          tokib = 0.0_8
          almb = 0.0_8
          GOTO 110
        ELSE
          trgb = 0.0_8
          almb = 0.0_8
          GOTO 120
        END IF
      ELSE IF (branch .LT. 6) THEN
        IF (branch .EQ. 4) THEN
          trgb = 0.0_8
          temb = 0.0_8
          GOTO 130
        ELSE
          trgb = 0.0_8
          GOTO 140
        END IF
      ELSE IF (branch .EQ. 6) THEN
        trgb = 0.0_8
        GOTO 150
      ELSE
        CALL POPINTEGER4(ad_from5)
        DO l=k,ad_from5,-1
          CALL POPREAL8(voi(l))
          vcub(l) = vcub(l) + voib(l)
          CALL POPREAL8(uoi(l))
          ucub(l) = ucub(l) + uoib(l)
        END DO
        tempb35 = tem*vcub(ic)
        tempb36 = 2.*tempb35
        tempb37 = -(eta(ic+1)*tempb35)
        vhtb = tempb36
        voib(ic) = voib(ic) + tempb37 - (eta(ic)-eta(ic+1))*tempb36
        etab(ic) = etab(ic) - voi(ic)*tempb36
        etab(ic+1) = etab(ic+1) + voi(ic)*tempb36 - (voi(ic)+voi(ic+1))*&
&         tempb35
        voib(ic+1) = voib(ic+1) + tempb37
        temb = (2.*(uht-uoi(ic)*(eta(ic)-eta(ic+1)))-(uoi(ic)+uoi(ic+1))&
&         *eta(ic+1))*ucub(ic) + (2.*(vht-voi(ic)*(eta(ic)-eta(ic+1)))-(&
&         voi(ic)+voi(ic+1))*eta(ic+1))*vcub(ic)
        tempb38 = tem*ucub(ic)
        tempb39 = 2.*tempb38
        tempb40 = -(eta(ic+1)*tempb38)
        uhtb = tempb39
        uoib(ic) = uoib(ic) + tempb40 - (eta(ic)-eta(ic+1))*tempb39
        etab(ic) = etab(ic) - uoi(ic)*tempb39
        etab(ic+1) = etab(ic+1) + uoi(ic)*tempb39 - (uoi(ic)+uoi(ic+1))*&
&         tempb38
        uoib(ic+1) = uoib(ic+1) + tempb40
        CALL POPREAL8(tem)
        wfnb = pri(ic)*temb
        CALL POPINTEGER4(ad_to4)
        DO l=ad_to4,k-1,1
          tempb31 = tem*vcub(l)
          tempb32 = eta(l+1)*tempb31
          temb = ((uoi(l-1)-uoi(l))*eta(l)+(uoi(l)-uoi(l+1))*eta(l+1))*&
&           ucub(l) + ((voi(l-1)-voi(l))*eta(l)+(voi(l)-voi(l+1))*eta(l+&
&           1))*vcub(l)
          voib(l-1) = voib(l-1) + eta(l)*tempb31
          voib(l) = voib(l) + tempb32 - eta(l)*tempb31
          etab(l) = etab(l) + (voi(l-1)-voi(l))*tempb31
          voib(l+1) = voib(l+1) - tempb32
          etab(l+1) = etab(l+1) + (voi(l)-voi(l+1))*tempb31
          tempb33 = tem*ucub(l)
          tempb34 = eta(l+1)*tempb33
          uoib(l-1) = uoib(l-1) + eta(l)*tempb33
          uoib(l) = uoib(l) + tempb34 - eta(l)*tempb33
          etab(l) = etab(l) + (uoi(l-1)-uoi(l))*tempb33
          uoib(l+1) = uoib(l+1) - tempb34
          etab(l+1) = etab(l+1) + (uoi(l)-uoi(l+1))*tempb33
          CALL POPREAL8(tem)
          wfnb = wfnb + pri(l)*temb
        END DO
        temb = (uoi(k-1)-uoi(k))*ucub(k) + (voi(k-1)-voi(k))*vcub(k)
        voib(k-1) = voib(k-1) + tem*vcub(k)
        voib(k) = voib(k) - tem*vcub(k)
        uoib(k-1) = uoib(k-1) + tem*ucub(k)
        uoib(k) = uoib(k) - tem*ucub(k)
        CALL POPREAL8(tem)
        wfnb = wfnb + pri(k)*temb
        CALL POPREAL8(wfn)
        almb = -(EXP(-(alm/friclambda))*wfn*fricfac*wfnb/friclambda)
        wfnb = fricfac*EXP(-(alm/friclambda))*wfnb
      END IF
      CALL POPREAL8(wfn)
      wfnb = 0.5*wfnb
      temb = 0.0_8
      CALL POPINTEGER4(ad_from4)
      DO l=k,ad_from4,-1
        CALL POPREAL8(qst(l))
        gmsb(l) = gmsb(l) + pki(l)*cpi*poib(l) - alhi*qoib(l) + cpi*bet(&
&         l)*qstb(l)
        betb(l) = betb(l) + cpi*gms(l)*qstb(l)
        CALL POPREAL8(poi(l))
        CALL POPREAL8(qoi(l))
        gmhb(l) = gmhb(l) + alhi*qoib(l)
        CALL POPREAL8(gms(l))
        CALL POPREAL8(gmh(l))
        wfnb = wfnb + gmh(l)*gmhb(l) + gms(l)*gmsb(l)
        gmsb(l) = wfn*gmsb(l)
        gmhb(l) = wfn*gmhb(l)
        rnnb(l) = rnnb(l) + tem*rnsb(l)
        temb = temb + rnn(l)*rnsb(l)
      END DO
      CALL POPINTEGER4(ad_from3)
      DO l=k,ad_from3,-1
        updfrpb(l) = updfrpb(l) + updfrcb(l)
        CALL POPCONTROL1B(branch)
        IF (branch .EQ. 0) THEN
          temp9 = daylen*prs(l)*cvw(l)
          tempb30 = ddt*1000.*updfrpb(l)/temp9
          rmfpb(l) = rmfpb(l) + tempb30
          cvwb(l) = cvwb(l) - rmfp(l)*daylen*prs(l)*tempb30/temp9
          updfrpb(l) = 0.0_8
        ELSE
          updfrpb(l) = 0.0_8
        END IF
        CALL POPREAL8(rmfp(l))
        temb = temb + eta(l)*rmfpb(l)
        etab(l) = etab(l) + tem*rmfpb(l)
        rmfpb(l) = 0.0_8
      END DO
      temb = temb + wlq*cllb(ic) + eta(ic)*rmfdb(ic)
      etab(ic) = etab(ic) + tem*rmfdb(ic)
      wlqb = tem*cllb(ic)
      CALL POPREAL8(tem)
      wfnb = wfnb + gravi*temb
      CALL POPCONTROL1B(branch)
      IF (branch .EQ. 0) THEN
        CALL POPREAL8(wfn)
        x1b = 0.0_8
      ELSE
        CALL POPREAL8(wfn)
        x1b = wfnb
      END IF
      tempb28 = trg*toki*x1b
      tempb29 = rasal(ic)*wfn*x1b
      rasalb(ic) = rasalb(ic) + wfn*tempb28
      wfnb = rasal(ic)*tempb28
      trgb = toki*tempb29
      tokib = trg*tempb29
      CALL POPREAL8(wfn)
      akmb = (wfn-acr)*wfnb/akm**2
      wfnb = -(wfnb/akm)
 100  tempb26 = -(dpb(ic)*pki(ic)*akmb)
      CALL POPREAL8(gmh(ic))
      tempb24 = pri(ic)*gmhb(ic)
      tempb25 = alhl*eta(ic+1)*tempb24
      gmsb(ic) = gmsb(ic) + eta(ic+1)*tempb26 + gmhb(ic)
      etab(ic+1) = etab(ic+1) + alhl*(qol(ic)-qht(ic+1))*tempb24
      qolb(ic) = qolb(ic) + tempb25
      qhtb(ic+1) = qhtb(ic+1) - tempb25
      etab(ic) = etab(ic) + (hst(ic)-hol(ic))*tempb24
      hstb(ic) = hstb(ic) + eta(ic)*tempb24
      holb(ic) = holb(ic) - eta(ic)*tempb24
      gmhb(ic) = 0.0_8
      etab(ic+1) = etab(ic+1) + pri(ic)*(ssl(ic)-sht(ic+1))*gmsb(ic) + &
&       gms(ic)*tempb26
      CALL POPREAL8(gms(ic))
      tempb27 = pri(ic)*eta(ic+1)*gmsb(ic)
      sslb(ic) = sslb(ic) + tempb27
      shtb(ic+1) = shtb(ic+1) - tempb27
      gmsb(ic) = 0.0_8
      tx2b = 0.0_8
      CALL POPINTEGER4(ad_to3)
      DO l=ad_to3,k-1,1
        tx2b = tx2b + ght(l)*akmb
        gmhb(l) = gmhb(l) + (eta(l)-eta(l+1))*tx2b
        gmsb(l) = gmsb(l) + gmhb(l) - pki(l)*eht(l)*akmb
        ehtb(l) = ehtb(l) - pki(l)*gms(l)*akmb
        ghtb(l) = ghtb(l) + tx2*akmb
        CALL POPREAL8(tx2)
        etab(l) = etab(l) + gmh(l)*tx2b
        etab(l+1) = etab(l+1) - gmh(l)*tx2b
        CALL POPREAL8(gmh(l))
        tempb20 = alhl*pri(l)*gmhb(l)
        tempb21 = eta(l+1)*tempb20
        etab(l) = etab(l) + (qht(l)-qol(l))*tempb20
        qhtb(l) = qhtb(l) + eta(l)*tempb20
        qolb(l) = qolb(l) + tempb21 - eta(l)*tempb20
        etab(l+1) = etab(l+1) + (qol(l)-qht(l+1))*tempb20
        qhtb(l+1) = qhtb(l+1) - tempb21
        gmhb(l) = 0.0_8
        CALL POPREAL8(gms(l))
        tempb22 = pri(l)*gmsb(l)
        tempb23 = eta(l+1)*tempb22
        etab(l) = etab(l) + (sht(l)-ssl(l))*tempb22
        shtb(l) = shtb(l) + eta(l)*tempb22
        sslb(l) = sslb(l) + tempb23 - eta(l)*tempb22
        etab(l+1) = etab(l+1) + (ssl(l)-sht(l+1))*tempb22
        shtb(l+1) = shtb(l+1) - tempb23
        gmsb(l) = 0.0_8
      END DO
      tempb18 = dpb(k-1)*akmb
      CALL POPREAL8(tx2)
      gmhb(k) = gmhb(k) + gam(k-1)*tempb18 + tx2b
      CALL POPREAL8(akm)
      gamb(k-1) = gamb(k-1) + gmh(k)*tempb18
      CALL POPREAL8(gmh(k))
      tempb19 = pri(k)*alhl*gmhb(k)
      gmsb(k) = gmsb(k) + gmhb(k)
      qhtb(k) = qhtb(k) + tempb19
      qolb(k) = qolb(k) - tempb19
      gmhb(k) = 0.0_8
      CALL POPREAL8(gms(k))
      shtb(k) = shtb(k) + pri(k)*gmsb(k)
      sslb(k) = sslb(k) - pri(k)*gmsb(k)
      gmsb(k) = 0.0_8
      qstb(ic) = qstb(ic) - eta(ic)*wlqb
      etab(ic) = etab(ic) - qst(ic)*wlqb
      CALL POPINTEGER4(ad_to2)
      DO l=ad_to2,k-1,1
        CALL POPCONTROL1B(branch)
        IF (branch .EQ. 0) THEN
          CALL POPREAL8(rnn(l))
          rnnb(l) = 0.0_8
          clossb = 0.0_8
        ELSE
          CALL POPREAL8(rnn(l))
          clossb = rnnb(l) - wlqb
          rnnb(l) = 0.0_8
        END IF
        clossb = clossb - cll0b(l)
        CALL POPCONTROL1B(branch)
        IF (branch .EQ. 0) THEN
          dt_lyr = (zet(l)-zet(l+1))/cvw_x
          cll0b(l) = cll0b(l) + clossb
          clossb = 0.0_8
        ELSE
          dt_lyr = (zet(l)-zet(l+1))/cvw_x
        END IF
        cll0b(l) = cll0b(l) + rate*dt_lyr*clossb
        rateb = cll0(l)*dt_lyr*clossb
        dt_lyrb = cll0(l)*rate*clossb
        tempb17 = dt_lyrb/cvw_x
        zetb(l) = zetb(l) + tempb17
        zetb(l+1) = zetb(l+1) - tempb17
        cvw_xb = -((zet(l)-zet(l+1))*tempb17/cvw_x)
        CALL POPCONTROL1B(branch)
        IF (branch .EQ. 0) THEN
          CALL POPREAL8(cvw_x)
        ELSE
          CALL POPREAL8(cvw_x)
          cvwb(l) = cvwb(l) + cvw_xb
        END IF
        cli_crit_x = cli_crit/(f2*f3)
        cli = cll0(l)/eta(l)
        CALL POPREAL8(rate)
        temp8 = cli_crit_x**2
        temp7 = cli**2/temp8
        tempb15 = EXP(-temp7)*c00_x*rateb/temp8
        c00_xb = (1.0-EXP(-temp7))*rateb
        clib = 2*cli*tempb15
        cli_crit_xb = -(temp7*2*cli_crit_x*tempb15)
        f2b = f2b + f3*f4*co_auto(i)*c00_xb - cli_crit*cli_crit_xb/(f3*&
&         f2**2)
        CALL POPREAL8(c00_x)
        te_a = poi(l)*prh(l)
        CALL POPREAL8(f2)
        CALL POPREAL8(f3)
        CALL SUNDQ3_ICE_B(te_a, te_ab, sdqv2, sdqv3, sdqvt1, f2, f2b, f3&
&                  )
        poib(l) = poib(l) + prh(l)*te_ab
        tempb16 = clib/eta(l)
        cll0b(l) = cll0b(l) + tempb16
        etab(l) = etab(l) - cll0(l)*tempb16/eta(l)
        CALL POPCONTROL1B(branch)
        IF (branch .EQ. 0) cll0b(l) = 0.0_8
        CALL POPCONTROL1B(branch)
        IF (branch .EQ. 0) THEN
          CALL POPREAL8(cll0(l))
          wlqb = wlqb + cll0b(l)
          qstb(ic) = qstb(ic) - eta(ic)*cll0b(l)
          etab(ic) = etab(ic) - qst(ic)*cll0b(l)
          cll0b(l) = 0.0_8
        ELSE
          CALL POPREAL8(cll0(l))
          wlqb = wlqb + cll0b(l)
          qccb = -cll0b(l)
          cll0b(l) = 0.0_8
          tx2b = qccb
          gm1b(l) = gm1b(l) + (hcc(l)-tx3)*qccb
          hccb(l) = hccb(l) + gm1(l)*qccb
          tx3b = -(gm1(l)*qccb)
          CALL POPREAL8(tx3)
          tempb13 = 0.5*eta(l)*tx3b
          hstb(l) = hstb(l) + tempb13
          hstb(l-1) = hstb(l-1) + tempb13
          etab(l) = etab(l) + 0.5*(qst(l)+qst(l-1))*tx2b + 0.5*(hst(l)+&
&           hst(l-1))*tx3b
          CALL POPREAL8(tx2)
          tempb14 = 0.5*eta(l)*tx2b
          qstb(l) = qstb(l) + tempb14
          qstb(l-1) = qstb(l-1) + tempb14
        END IF
        tem = eta(l) - eta(l+1)
        temb = uoi(l)*uhtb + qol(l)*wlqb + voi(l)*vhtb
        voib(l) = voib(l) + tem*vhtb
        uoib(l) = uoib(l) + tem*uhtb
        qolb(l) = qolb(l) + tem*wlqb
        CALL POPREAL8(tem)
        etab(l) = etab(l) + temb
        etab(l+1) = etab(l+1) - temb
      END DO
      cll0b(k) = 0.0_8
      CALL POPREAL8(rnn(k))
      rnnb(k) = 0.0_8
      CALL POPREAL8(vht)
      voib(k) = voib(k) + vhtb
      CALL POPREAL8(uht)
      uoib(k) = uoib(k) + uhtb
      CALL POPREAL8(wlq)
      qolb(k) = qolb(k) + wlqb
 110  CALL POPREAL8(acr)
      CALL POPINTEGER4(ad_from2)
      DO l=k,ad_from2,-1
        CALL POPCONTROL1B(branch)
        IF (branch .EQ. 0) THEN
          CALL POPREAL8(cvw(l))
          cvwb(l) = 0.0_8
        ELSE
          CALL POPREAL8(cvw(l))
        END IF
      END DO
      CALL POPREAL8(rasal(ic))
      rasalb(ic) = -(dt*rasalb(ic)/rasal(ic)**2)
      CALL POPCONTROL1B(branch)
      IF (branch .EQ. 0) rasalb(ic) = 0.0_8
      CALL POPCONTROL1B(branch)
      IF (branch .NE. 0) THEN
        zetb(ic) = zetb(ic) + (rasal2-rasal1)*rasalb(ic)/8000.
        rasalb(ic) = 0.0_8
      END IF
      CALL POPCONTROL1B(branch)
      IF (branch .EQ. 0) rasalb(ic) = 0.0_8
      CALL POPINTEGER4(ad_to1)
      DO l=ad_to1,k-1,1
        CALL POPREAL8(cvw(l))
        IF (2.0*max2 .EQ. 0.0) THEN
          max2b = 0.0
        ELSE
          max2b = cvwb(l)/SQRT(2.0*max2)
        END IF
        cvwb(l) = 0.0_8
        CALL POPCONTROL1B(branch)
        IF (branch .EQ. 0) THEN
          CALL POPREAL8(max2)
        ELSE
          CALL POPREAL8(max2)
          bk2b(l) = bk2b(l) + max2b
        END IF
        temp6 = cp*prj(l+1)
        temp5 = temp6*poi(l)
        tempb12 = grav*bk2b(l)/temp5
        bk2b(l+1) = bk2b(l+1) + bk2b(l)
        max1b = tempb12
        poib(l) = poib(l) - max1*temp6*tempb12/temp5
        bk2b(l) = 0.0_8
        CALL POPCONTROL1B(branch)
        IF (branch .EQ. 0) THEN
          CALL POPREAL8(max1)
          temb = 0.0_8
        ELSE
          CALL POPREAL8(max1)
          temb = max1b
        END IF
        CALL POPREAL8(tem)
        temp4 = lbcp*dqq(l) + 1.0
        tempb10 = temb/temp4
        temp3 = zet(l) - zet(l+1)
        temp2 = hcld(l) - hst(l)
        hcldb(l) = hcldb(l) + temp3*tempb10
        hstb(l) = hstb(l) - temp3*tempb10
        zetb(l) = zetb(l) + temp2*tempb10
        zetb(l+1) = zetb(l+1) - temp2*tempb10
        dqqb(l) = dqqb(l) - temp2*temp3*lbcp*tempb10/temp4
        CALL POPREAL8(hcld(l))
        tempb11 = hcldb(l)/eta(l)
        etab(l+1) = etab(l+1) + (hcld(l+1)-hol(l))*tempb11
        hcldb(l+1) = hcldb(l+1) + eta(l+1)*tempb11
        etab(l) = etab(l) + (hol(l)-(eta(l+1)*hcld(l+1)+(eta(l)-eta(l+1)&
&         )*hol(l))/eta(l))*tempb11
        holb(l) = holb(l) + (eta(l)-eta(l+1))*tempb11
        hcldb(l) = 0.0_8
      END DO
      CALL POPREAL8(hcld(k))
      holb(k) = holb(k) + hcldb(k)
      hcldb(k) = 0.0_8
      bk2b(k) = 0.0_8
      tempb9 = dpb(ic)*gam(ic)*wfnb
      hccb(ic+1) = hccb(ic+1) + tempb9
      hstb(ic) = hstb(ic) + eta(ic)*hccb(ic) - eta(ic+1)*tempb9
      etab(ic+1) = etab(ic+1) - hst(ic)*tempb9
      gamb(ic) = gamb(ic) + dpb(ic)*(hcc(ic+1)-hst(ic)*eta(ic+1))*wfnb
      CALL POPREAL8(hcc(ic))
      etab(ic) = etab(ic) + hst(ic)*hccb(ic)
      hccb(ic) = 0.0_8
      CALL POPINTEGER4(ad_to0)
      DO l=ad_to0,k-1,1
        tem = hcc(l+1)*dpb(l) + hcc(l)*dpt(l)
        tempb8 = gam(l)*wfnb
        temb = tempb8
        ehtb(l) = ehtb(l) - hst(l)*tempb8
        hstb(l) = hstb(l) - eht(l)*tempb8
        gamb(l) = gamb(l) + (tem-eht(l)*hst(l))*wfnb
        CALL POPREAL8(eht(l))
        etab(l+1) = etab(l+1) + dpb(l)*ehtb(l)
        CALL POPREAL8(tem)
        hccb(l+1) = hccb(l+1) + dpb(l)*temb
        hccb(l) = hccb(l) + dpt(l)*temb
        CALL POPREAL8(hcc(l))
        hccb(l+1) = hccb(l+1) + hccb(l)
        etab(l) = etab(l) + hol(l)*hccb(l) + dpt(l)*ehtb(l)
        ehtb(l) = 0.0_8
        etab(l+1) = etab(l+1) - hol(l)*hccb(l)
        holb(l) = holb(l) + (eta(l)-eta(l+1))*hccb(l)
        hccb(l) = 0.0_8
      END DO
      CALL POPREAL8(hcc(k))
      holb(k) = holb(k) + hccb(k)
      hccb(k) = 0.0_8
      CALL POPREAL8(eta(ic))
      almb = almb + (zol(ic)-zet(k))*etab(ic)
      zolb(ic) = zolb(ic) + alm*etab(ic)
      zetb(k) = zetb(k) - alm*etab(ic)
      etab(ic) = 0.0_8
      CALL POPINTEGER4(ad_from1)
      DO l=k,ad_from1,-1
        CALL POPREAL8(eta(l))
        almb = almb + (zet(l)-zet(k))*etab(l)
        zetb(l) = zetb(l) + alm*etab(l)
        zetb(k) = zetb(k) - alm*etab(l)
        etab(l) = 0.0_8
      END DO
      CALL POPCONTROL1B(branch)
      IF (branch .NE. 0) almb = almb + 2*alm*tokib/lambda_min**2
      CALL POPREAL8(toki)
 120  CALL POPREAL8(alm)
      tempb7 = almb/tem
      holb(k) = holb(k) + tempb7
      hstb(ic) = hstb(ic) - tempb7
      temb = -((hol(k)-hst(ic))*tempb7/tem)
 130  CALL POPINTEGER4(ad_from0)
      DO l=k-1,ad_from0,-1
        tempb5 = (zet(l)-zet(l+1))*temb
        tempb6 = (hst(ic)-hol(l))*temb
        hstb(ic) = hstb(ic) + tempb5
        holb(l) = holb(l) - tempb5
        zetb(l) = zetb(l) + tempb6
        zetb(l+1) = zetb(l+1) - tempb6
      END DO
      CALL POPREAL8(tem)
      tempb3 = (zol(ic)-zet(ic+1))*temb
      tempb4 = (hst(ic)-hol(ic))*temb
      hstb(ic) = hstb(ic) + tempb3
      holb(ic) = holb(ic) - tempb3
      zolb(ic) = zolb(ic) + tempb4
      zetb(ic+1) = zetb(ic+1) - tempb4
 140  CALL POPREAL8(lambda_min)
      CALL POPINTEGER4(ad_from)
      DO l=k,ad_from,-1
        CALL POPREAL8(qht(l))
        qolb(l) = qolb(l) + .5*qhtb(l)
        qolb(l-1) = qolb(l-1) + .5*qhtb(l)
        qhtb(l) = 0.0_8
        tem = (prj(l)-prh(l-1))/(prh(l)-prh(l-1))
        CALL POPREAL8(sht(l))
        sslb(l-1) = sslb(l-1) + (1.0_8-tem)*shtb(l)
        sslb(l) = sslb(l) + tem*shtb(l)
        shtb(l) = 0.0_8
        CALL POPREAL8(tem)
      END DO
      poi_cb = 0.0_8
      qoi_cb = 0.0_8
      CALL POPINTEGER4(ad_to)
      DO l=ad_to,k,1
        sslb(l) = sslb(l) + holb(l) + hstb(l)
        CALL POPREAL8(zol(l))
        zetb(l+1) = zetb(l+1) + zetb(l) + zolb(l)
        CALL POPREAL8(zet(l))
        temb = zetb(l)
        poi_cb(l) = poi_cb(l) + (prj(l+1)-prj(l))*cpbg*temb + prj(l+1)*&
&         cp*sslb(l) + (prj(l+1)-prh(l))*cpbg*zolb(l)
        zolb(l) = 0.0_8
        zetb(l) = 0.0_8
        CALL POPREAL8(tem)
        CALL POPREAL8(hst(l))
        qstb(l) = qstb(l) + alhl*hstb(l)
        hstb(l) = 0.0_8
        CALL POPREAL8(hol(l))
        qolb(l) = qolb(l) + alhl*holb(l)
        holb(l) = 0.0_8
        CALL POPREAL8(ssl(l))
        zetb(l+1) = zetb(l+1) + grav*sslb(l)
        sslb(l) = 0.0_8
        CALL POPCONTROL1B(branch)
        IF (branch .NE. 0) qolb(l) = 0.0_8
        CALL POPCONTROL1B(branch)
        IF (branch .EQ. 0) THEN
          CALL POPREAL8(qol(l))
          qoi_cb(l) = qoi_cb(l) + qolb(l)
          qolb(l) = 0.0_8
        ELSE
          CALL POPREAL8(qol(l))
          qstb(l) = qstb(l) + rhmax*qolb(l)
          qolb(l) = 0.0_8
        END IF
      END DO
      CALL POPREAL8(sht(k+1))
      poi_cb(k) = poi_cb(k) + prj(k+1)*cp*shtb(k+1)
      shtb(k+1) = 0.0_8
      CALL POPREAL8(zet(k+1))
      zetb(k+1) = 0.0_8
      tpertb = tpertb + poi_cb(k)
      qoib = qoib + qoi_cb
      poib = poib + poi_cb
 150  CALL POPCONTROL1B(branch)
      IF (branch .EQ. 0) THEN
        CALL POPREAL8(f4)
      ELSE
        CALL POPREAL8(f4)
      END IF
      CALL POPCONTROL1B(branch)
      IF (branch .EQ. 0) THEN
        CALL POPREAL8(trg)
        tempb2 = trgb/((rhmx-rhmn)*qst(k))
        qoib(k) = qoib(k) + tempb2
        qstb(k) = qstb(k) - qoi(k)*tempb2/qst(k)
      ELSE
        CALL POPREAL8(trg)
      END IF
      vcub(icmin:k0) = 0.0_8
      ucub(icmin:k0) = 0.0_8
    END DO
    DO l=icmin,k,1
      sslb(l) = sslb(l) + holb(l) + hstb(l)
      zetb(l+1) = zetb(l+1) + zetb(l) + zolb(l)
      temb = zetb(l)
      poib(l) = poib(l) + (prj(l+1)-prj(l))*cpbg*temb + prj(l+1)*cp*sslb&
&       (l) + (prj(l+1)-prh(l))*cpbg*zolb(l)
      zolb(l) = 0.0_8
      zetb(l) = 0.0_8
      qstb(l) = qstb(l) + alhl*hstb(l)
      hstb(l) = 0.0_8
      qolb(l) = qolb(l) + alhl*holb(l)
      holb(l) = 0.0_8
      zetb(l+1) = zetb(l+1) + grav*sslb(l)
      sslb(l) = 0.0_8
      CALL POPCONTROL1B(branch)
      IF (branch .NE. 0) qolb(l) = 0.0_8
      CALL POPCONTROL1B(branch)
      IF (branch .EQ. 0) THEN
        qoib(l) = qoib(l) + qolb(l)
        qolb(l) = 0.0_8
      ELSE
        qstb(l) = qstb(l) + rhmax*qolb(l)
        qolb(l) = 0.0_8
      END IF
    END DO
    poib(k) = poib(k) + prj(k+1)*cp*shtb(k+1)
    voib = voib + voi_svb
    uoib = uoib + uoi_svb
    qoib = qoib + qoi_svb
    poib = poib + poi_svb
    DO l=icmin,k,1
      CALL POPCONTROL1B(branch)
      IF (branch .NE. 0) THEN
        temp1 = alhl*(lbcp*dqq(l+1)+1.0)
        temp0 = alhl*(lbcp*dqq(l)+1.0)
        tempb = lbcp*0.5*gm1b(l+1)
        tempb0 = tempb/temp0
        tempb1 = tempb/temp1
        dqqb(l) = dqqb(l) + (1.0_8-alhl*dqq(l)*lbcp/temp0)*tempb0
        dqqb(l+1) = dqqb(l+1) + (1.0_8-alhl*dqq(l+1)*lbcp/temp1)*tempb1
        gm1b(l+1) = 0.0_8
        gamb(l) = gamb(l) + dpb(l)*ghtb(l+1)
        gamb(l+1) = gamb(l+1) + dpt(l+1)*ghtb(l+1)
        ghtb(l+1) = 0.0_8
      END IF
      temp = lbcp*dqq(l) + 1.0
      dqqb(l) = dqqb(l) + pki(l)*betb(l) - pki(l)*lbcp*gamb(l)/temp**2
      gamb(l) = 0.0_8
      betb(l) = 0.0_8
    END DO
    CALL POPCONTROL1B(branch)
    IF (branch .NE. 0) THEN
      CALL DQSATS_RAS_B(dqq(k), dqqb(k), qst(k), qstb(k), arg1, arg1b, &
&                 pol(k), estblx, cons_h2omw, cons_airmw)
      dqqb(k) = 0.0_8
      qstb(k) = 0.0_8
      poib(k) = poib(k) + prh(k)*arg1b
      DO l=k0,k,-1
        vhob(i, l) = vhob(i, l) + wght(l)*voib(k)
        uhob(i, l) = uhob(i, l) + wght(l)*uoib(k)
        qhob(i, l) = qhob(i, l) + wght(l)*qoib(k)
        thob(i, l) = thob(i, l) + wght(l)*poib(k)
      END DO
      voib(k) = 0.0_8
      uoib(k) = 0.0_8
      qoib(k) = 0.0_8
      poib(k) = 0.0_8
    END IF
    dqsb = 0.0_8
    dqsb(icmin:k) = dqsb(icmin:k) + dqqb(icmin:k)
    qssb = 0.0_8
    qssb(icmin:k) = qssb(icmin:k) + qstb(icmin:k)
    vhob(i, icmin:k) = vhob(i, icmin:k) + voib(icmin:k)
    uhob(i, icmin:k) = uhob(i, icmin:k) + uoib(icmin:k)
    qhob(i, icmin:k) = qhob(i, icmin:k) + qoib(icmin:k)
    thob(i, icmin:k) = thob(i, icmin:k) + poib(icmin:k)
    CALL DQSAT_RAS_B(dqs, dqsb, qss, qssb, tempf, tempfb, pf, k0, estblx&
&              , cons_h2omw, cons_airmw)
    CALL POPCONTROL2B(branch)
    IF (branch .LT. 2) THEN
      IF (branch .NE. 0) tpertb = 0.0_8
    ELSE IF (branch .NE. 2) THEN
      tpertb = 0.0_8
    END IF
    CALL POPCONTROL1B(branch)
    IF (branch .EQ. 0) tpertb = 0.0_8
    zlob = 0.0_8
    tempfb(k0) = tempfb(k0) - cbl_tpert*tpertb
    zlob(k0) = zlob(k0) - cons_grav*cbl_tpert*tpertb/cons_cp
    zleb = 0.0_8
    DO l=1,k0,1
      zlob(l) = zlob(l) + zleb(l)
      zleb(l) = cons_cp*(pk(l)-pke(l))*zleb(l)/cons_grav
      zleb(l+1) = zleb(l+1) + zlob(l)
      zleb(l) = zleb(l) + cons_cp*(pke(l+1)-pk(l))*zlob(l)/cons_grav
      zlob(l) = 0.0_8
      thob(i, l) = thob(i, l) + (cons_vireps*qho(i, l)+1.)*zleb(l)
      qhob(i, l) = qhob(i, l) + tho(i, l)*cons_vireps*zleb(l)
      zleb(l) = 0.0_8
    END DO
    thob(i, :) = thob(i, :) + pk*tempfb
  END IF
  clwb = 0.0_8
  cnv_prc3b = 0.0_8
  cnv_updfrcb = 0.0_8
  flxdb = 0.0_8
    ELSE
      qoi_svb = 0.0_8
      uoi_svb = 0.0_8
      qoib = 0.0_8
      voib = 0.0_8
      updfrcb = 0.0_8
      poib = 0.0_8
      rnsb = 0.0_8
      poi_svb = 0.0_8
      uoib = 0.0_8
      rmfdb = 0.0_8
      voi_svb = 0.0_8
      cllb = 0.0_8
    END IF
END SUBROUTINE RASE_B

!  Differentiation of sundq3_ice in reverse (adjoint) mode:
!   gradient     of useful results: f2
!   with respect to varying inputs: temp f2
SUBROUTINE SUNDQ3_ICE_B(temp, tempb, rate2, rate3, te1, f2, f2b, f3)
  IMPLICIT NONE
  REAL*8, INTENT(IN) :: temp, rate2, rate3, te1
  REAL*8 :: tempb
  REAL*8 :: f2, f3
  REAL*8 :: f2b
!,RATE2,RATE3,TE1
  REAL*8 :: xx, yy, te0, te2, jump1
  INTEGER :: branch
  te0 = 273.
  te2 = 200.
  jump1 = (rate2-1.0)/(te0-te1)**0.333
! Ice - phase treatment
  IF (temp .GE. te0) THEN
    CALL PUSHREAL8(f2)
    f2 = 1.0
    CALL PUSHCONTROL1B(0)
  ELSE
    CALL PUSHCONTROL1B(1)
  END IF
  IF (temp .GE. te1 .AND. temp .LT. te0) THEN
    CALL PUSHREAL8(f2)
    f2 = 1.0 + jump1*(te0-temp)**0.3333
    CALL PUSHCONTROL1B(0)
  ELSE
    CALL PUSHCONTROL1B(1)
  END IF
  IF (temp .LT. te1) THEN
    CALL PUSHREAL8(f2)
    f2 = rate2 + (rate3-rate2)*(te1-temp)/(te1-te2)
    CALL PUSHCONTROL1B(0)
  ELSE
    CALL PUSHCONTROL1B(1)
  END IF
  IF (f2 .GT. 27.0) f2b = 0.0_8
  CALL POPCONTROL1B(branch)
  IF (branch .EQ. 0) THEN
    CALL POPREAL8(f2)
    tempb = -((rate3-rate2)*f2b/(te1-te2))
    f2b = 0.0_8
  ELSE
    tempb = 0.0_8
  END IF
  CALL POPCONTROL1B(branch)
  IF (branch .EQ. 0) THEN
    CALL POPREAL8(f2)
    tempb = tempb - 0.3333*(te0-temp)**(-0.6667)*jump1*f2b
    f2b = 0.0_8
  END IF
  CALL POPCONTROL1B(branch)
  IF (branch .EQ. 0) THEN
    CALL POPREAL8(f2)
    f2b = 0.0_8
  END IF
END SUBROUTINE SUNDQ3_ICE_B

!  Differentiation of dqsat_ras in reverse (adjoint) mode:
!   gradient     of useful results: dqsi qssi
!   with respect to varying inputs: temp
SUBROUTINE DQSAT_RAS_B(dqsi, dqsib, qssi, qssib, temp, tempb, plo, lm, &
& estblx, cons_h2omw, cons_airmw)
  IMPLICIT NONE
!Inputs
  INTEGER :: lm
  REAL*8, DIMENSION(lm) :: temp, plo
  REAL*8, DIMENSION(lm) :: tempb
  REAL*8 :: estblx(:)
  REAL*8 :: cons_h2omw, cons_airmw
!Outputs
  REAL*8, DIMENSION(lm) :: dqsi, qssi
  REAL*8, DIMENSION(lm) :: dqsib, qssib
!Locals
  REAL*8, PARAMETER :: max_mixing_ratio=1.0
  REAL*8 :: esfac
  INTEGER :: k
  REAL*8 :: tl, tt, ti, dqsat, qsat, dqq, qq, pl, pp, dd
  REAL*8 :: tlb, ttb, tib, dqsatb, qsatb, qqb, ddb
  INTEGER :: it
  INTEGER, PARAMETER :: degsubs=100
  REAL*8, PARAMETER :: tmintbl=150.0, tmaxtbl=333.0
  INTEGER, PARAMETER :: tablesize=NINT(tmaxtbl-tmintbl)*degsubs+1
  INTRINSIC NINT
  INTRINSIC INT
  INTEGER :: branch
  REAL*8 :: temp0
  esfac = cons_h2omw/cons_airmw
  DO k=1,lm
    tl = temp(k)
    pl = plo(k)
    pp = pl*100.0
    IF (tl .LE. tmintbl) THEN
      ti = tmintbl
      CALL PUSHCONTROL2B(0)
    ELSE IF (tl .GE. tmaxtbl - .001) THEN
      ti = tmaxtbl - .001
      CALL PUSHCONTROL2B(1)
    ELSE
      ti = tl
      CALL PUSHCONTROL2B(2)
    END IF
    tt = (ti-tmintbl)*degsubs + 1
    it = INT(tt)
    CALL PUSHREAL8(dqq)
    dqq = estblx(it+1) - estblx(it)
    CALL PUSHREAL8(qq)
    qq = (tt-it)*dqq + estblx(it)
    IF (pp .LE. qq) THEN
      CALL PUSHCONTROL1B(0)
    ELSE
      CALL PUSHCONTROL1B(1)
    END IF
  END DO
  tempb = 0.0_8
  DO k=lm,1,-1
    qsatb = qssib(k)
    qssib(k) = 0.0_8
    dqsatb = dqsib(k)
    dqsib(k) = 0.0_8
    CALL POPCONTROL1B(branch)
    IF (branch .EQ. 0) THEN
      qqb = 0.0_8
    ELSE
      pl = plo(k)
      pp = pl*100.0
      dd = 1.0/(pp-(1.0-esfac)*qq)
      ddb = esfac*qq*qsatb + esfac*degsubs*dqq*pp*2*dd*dqsatb
      temp0 = pp - (-esfac+1.0)*qq
      qqb = (1.0-esfac)*ddb/temp0**2 + esfac*dd*qsatb
    END IF
    CALL POPREAL8(qq)
    ttb = dqq*qqb
    CALL POPREAL8(dqq)
    tib = degsubs*ttb
    CALL POPCONTROL2B(branch)
    IF (branch .EQ. 0) THEN
      tlb = 0.0_8
    ELSE IF (branch .EQ. 1) THEN
      tlb = 0.0_8
    ELSE
      tlb = tib
    END IF
    tempb(k) = tempb(k) + tlb
  END DO
END SUBROUTINE DQSAT_RAS_B

!  Differentiation of dqsats_ras in reverse (adjoint) mode:
!   gradient     of useful results: dqsi qssi
!   with respect to varying inputs: temp
SUBROUTINE DQSATS_RAS_B(dqsi, dqsib, qssi, qssib, temp, tempb, plo, &
& estblx, cons_h2omw, cons_airmw)
  IMPLICIT NONE
!Inputs
  REAL*8 :: temp, plo
  REAL*8 :: tempb
  REAL*8 :: estblx(:)
  REAL*8 :: cons_h2omw, cons_airmw
!Outputs
  REAL*8 :: dqsi, qssi
  REAL*8 :: dqsib, qssib
!Locals
  REAL*8, PARAMETER :: max_mixing_ratio=1.0
  REAL*8 :: esfac
  REAL*8 :: tl, tt, ti, dqsat, qsat, dqq, qq, pl, pp, dd
  REAL*8 :: tlb, ttb, tib, dqsatb, qsatb, qqb, ddb
  INTEGER :: it
  INTEGER, PARAMETER :: degsubs=100
  REAL*8, PARAMETER :: tmintbl=150.0, tmaxtbl=333.0
  INTEGER, PARAMETER :: tablesize=NINT(tmaxtbl-tmintbl)*degsubs+1
  INTRINSIC NINT
  INTRINSIC INT
  INTEGER :: branch
  REAL*8 :: temp0
  esfac = cons_h2omw/cons_airmw
  tl = temp
  pl = plo
  pp = pl*100.0
  IF (tl .LE. tmintbl) THEN
    ti = tmintbl
    CALL PUSHCONTROL2B(0)
  ELSE IF (tl .GE. tmaxtbl - .001) THEN
    ti = tmaxtbl - .001
    CALL PUSHCONTROL2B(1)
  ELSE
    ti = tl
    CALL PUSHCONTROL2B(2)
  END IF
  tt = (ti-tmintbl)*degsubs + 1
  it = INT(tt)
  dqq = estblx(it+1) - estblx(it)
  qq = (tt-it)*dqq + estblx(it)
  IF (pp .LE. qq) THEN
    CALL PUSHCONTROL1B(0)
  ELSE
    dd = 1.0/(pp-(1.0-esfac)*qq)
    CALL PUSHCONTROL1B(1)
  END IF
  qsatb = qssib
  dqsatb = dqsib
  CALL POPCONTROL1B(branch)
  IF (branch .EQ. 0) THEN
    qqb = 0.0_8
  ELSE
    temp0 = pp - (-esfac+1.0)*qq
    ddb = esfac*qq*qsatb + esfac*degsubs*dqq*pp*2*dd*dqsatb
    qqb = (1.0-esfac)*ddb/temp0**2 + esfac*dd*qsatb
  END IF
  ttb = dqq*qqb
  tib = degsubs*ttb
  CALL POPCONTROL2B(branch)
  IF (branch .EQ. 0) THEN
    tlb = 0.0_8
  ELSE IF (branch .EQ. 1) THEN
    tlb = 0.0_8
  ELSE
    tlb = tib
  END IF
  tempb = tlb
END SUBROUTINE DQSATS_RAS_B

SUBROUTINE RASE_TRACER_B(idim, irun, k0, icmin, dt, cons_cp, cons_alhl, &
& cons_grav, cons_rgas, cons_h2omw, cons_airmw, cons_vireps, seedras, &
& sige, kcbl, wgt0, wgt1, frland, ts, thoin, qhoin, uhoin, vhoin, &
& co_auto, ple, rasparams, estblx, itrcr, xho, xhob, fscav)
  IMPLICIT NONE
!INPUTS
  INTEGER, INTENT(IN) :: idim, irun, k0, icmin
  REAL*8, DIMENSION(idim, k0 + 1), INTENT(IN) :: ple
  REAL*8, DIMENSION(k0 + 1), INTENT(IN) :: sige
  REAL*8, INTENT(IN) :: dt, cons_cp, cons_alhl, cons_grav, cons_rgas
  REAL*8, INTENT(IN) :: cons_h2omw, cons_airmw, cons_vireps
  INTEGER, DIMENSION(idim), INTENT(IN) :: seedras
  INTEGER, DIMENSION(idim), INTENT(IN) :: kcbl
  REAL*8, DIMENSION(idim), INTENT(IN) :: ts, frland
  REAL*8, DIMENSION(idim), INTENT(IN) :: co_auto
  REAL*8, DIMENSION(idim, k0), INTENT(IN) :: wgt0, wgt1
  REAL*8, DIMENSION(:), INTENT(IN) :: rasparams
  REAL*8, DIMENSION(:), INTENT(IN) :: estblx
  INTEGER, INTENT(IN) :: itrcr
  REAL*8, DIMENSION(itrcr), INTENT(IN) :: fscav
  REAL*8, DIMENSION(idim, k0), INTENT(IN) :: thoin, qhoin, uhoin, vhoin
!PROGNOSTIC
  REAL*8, DIMENSION(idim, k0, itrcr), INTENT(INOUT) :: xho
  REAL*8, DIMENSION(idim, k0, itrcr), INTENT(INOUT) :: xhob
!LOCALS
  INTEGER :: i, ic, l, kk, k
!Parameters
  REAL*8, PARAMETER :: onepkap=1.+2./7., daylen=86400.0
  REAL*8, PARAMETER :: rhmax=0.9999
  REAL*8, PARAMETER :: cbl_qpert=0.0, cbl_tpert=1.0
  REAL*8, PARAMETER :: cbl_tpert_mxocn=2.0, cbl_tpert_mxlnd=4.0
!Constants
  REAL*8 :: grav, cp, alhl, cpbg, alhi, cpi, gravi, ddt, lbcp
!Rasparams
  REAL*8 :: fricfac, cli_crit, rasal1, rasal2
  REAL*8 :: friclambda
  REAL*8 :: sdqv2, sdqv3, sdqvt1
  REAL*8 :: acritfac, pblfrac, autorampb
  REAL*8 :: maxdallowed, rhmn, rhmx
  REAL*8 :: mxdiam
  REAL*8 :: tx2, tx3, akm, acr, alm, tth, qqh, dqx
  REAL*8 :: wfn, tem, trg, trgexp, evp, wlq, qcc
  REAL*8 :: cli, te_a, c00_x, cli_crit_x, toki
  REAL*8 :: dt_lyr, rate, cvw_x, closs, f2, f3, f4
  REAL*8 :: wght0, prcbl, rndu
  REAL*8 :: lambda_min, lambda_max
  REAL*8 :: tpert, qpert
  REAL*8 :: uht, vht
  REAL*8, DIMENSION(k0) :: poi_sv, qoi_sv, uoi_sv, voi_sv
  REAL*8, DIMENSION(k0) :: poi, qoi, uoi, voi, dqq, bet, gam, cll
  REAL*8, DIMENSION(k0) :: poi_c, qoi_c
  REAL*8, DIMENSION(k0) :: prh, pri, ght, dpt, dpb, pki
  REAL*8, DIMENSION(k0) :: ucu, vcu
  REAL*8, DIMENSION(k0) :: cln, rns, pol
  REAL*8, DIMENSION(k0) :: qst, ssl, rmf, rnn, rn1, rmfc, rmfp
  REAL*8, DIMENSION(k0) :: gms, eta, gmh, eht, gm1, hcc, rmfd
  REAL*8, DIMENSION(k0) :: hol, hst, qol, zol, hcld, cll0, cllx, clli
  REAL*8, DIMENSION(k0) :: bke, cvw, updfrc
  REAL*8, DIMENSION(k0) :: rasal, updfrp, bk2, dll0, dllx
  REAL*8, DIMENSION(k0) :: wght, massf
  REAL*8, DIMENSION(k0) :: qss, dqs, pf, pk, tempf, zlo
  REAL*8, DIMENSION(k0 + 1) :: prj, prs, qht, sht, zet, zle, pke
  REAL*8, DIMENSION(idim, k0) :: tho, qho, uho, vho
!Tracer scavenging
  INTEGER :: itr
!Layer thickness in km
  REAL*8 :: delzkm
!Fraction of tracer *not* scavenged
  REAL*8 :: fnoscav
  REAL*8, DIMENSION(k0, itrcr) :: xoi, xcu, xoi_sv
  REAL*8, DIMENSION(k0, itrcr) :: xoib, xcub, xoi_svb
  REAL*8, DIMENSION(itrcr) :: xht
  REAL*8, DIMENSION(itrcr) :: xhtb
  INTRINSIC MAX
  INTRINSIC MIN
  INTRINSIC SQRT
  INTRINSIC EXP
  INTRINSIC SUM
  REAL*8 :: arg1
  INTEGER :: ad_to
  INTEGER :: ad_from
  INTEGER :: ad_from0
  INTEGER :: branch
  INTEGER :: ad_to0
  INTEGER :: ad_to1
  INTEGER :: ad_from1
  REAL*8 :: tempb2
  REAL*8 :: tempb1
  REAL*8 :: tempb0
  REAL*8 :: x5
  REAL*8 :: x4
  REAL*8 :: x3
  REAL*8 :: x2
  REAL*8 :: x1
  REAL*8 :: tempb
  REAL*8 :: max2
  REAL*8 :: max1
  REAL*8 :: y1
!Pass meteorology to internal arrays so it is not updated
  tho = thoin
  qho = qhoin
!Initialize Local Arrays
  poi = 0.0
  qoi = 0.0
  dqq = 0.0
  bet = 0.0
  gam = 0.0
  prh = 0.0
  pri = 0.0
  ght = 0.0
  dpt = 0.0
  dpb = 0.0
  pki = 0.0
  pol = 0.0
  qst = 0.0
  ssl = 0.0
  gms = 0.0
  eta = 0.0
  gmh = 0.0
  eht = 0.0
  gm1 = 0.0
  hcc = 0.0
  hst = 0.0
  qol = 0.0
  zol = 0.0
  hcld = 0.0
  rasal = 0.0
  bk2 = 0.0
  qss = 0.0
  dqs = 0.0
  prj = 0.0
  prs = 0.0
  qht = 0.0
  sht = 0.0
  zet = 0.0
!  ---  1
!  ---  4
  cli_crit = rasparams(4)
!  ---  5
  rasal1 = rasparams(5)
!  ---  6
  rasal2 = rasparams(6)
!  --- 11
!  --- 14
  sdqv2 = rasparams(14)
!  --- 15
  sdqv3 = rasparams(15)
!  --- 16
  sdqvt1 = rasparams(16)
!  --- 17
  acritfac = rasparams(17)
!  --- 20
  pblfrac = rasparams(20)
!  --- 21
  autorampb = rasparams(21)
!  --- 24
  rhmn = rasparams(24)
!  --- 24
  maxdallowed = rasparams(23)
!  --- 25
  rhmx = rasparams(25)
  grav = cons_grav
  alhl = cons_alhl
  cp = cons_cp
  cpi = 1.0/cp
  alhi = 1.0/alhl
  gravi = 1.0/grav
  cpbg = cp*gravi
  lbcp = alhl*cpi
  i = 1
!CALL FINDBASE
  k = kcbl(i)
  IF (k .GT. 0) THEN
!Get saturation specific humidity and gradient wrt to T
    pke = (ple(i, :)/1000.)**(cons_rgas/cons_cp)
    pf = 0.5*(ple(i, 1:k0)+ple(i, 2:k0+1))
    pk = (pf/1000.)**(cons_rgas/cons_cp)
    tempf = tho(i, :)*pk
    zle = 0.0
    zlo = 0.0
    zle(k0+1) = 0.
    DO l=k0,1,-1
      zle(l) = tho(i, l)*(1.+cons_vireps*qho(i, l))
      zlo(l) = zle(l+1) + cons_cp/cons_grav*(pke(l+1)-pk(l))*zle(l)
      zle(l) = zlo(l) + cons_cp/cons_grav*(pk(l)-pke(l))*zle(l)
    END DO
    tpert = cbl_tpert*(ts(i)-(tempf(k0)+cons_grav*zlo(k0)/cons_cp))
!* ( QSSFC - Q(:,:,K0) ) [CBL_QPERT = 0.0]
    qpert = cbl_qpert
    IF (tpert .LT. 0.0) THEN
      tpert = 0.0
    ELSE
      tpert = tpert
    END IF
    IF (qpert .LT. 0.0) THEN
      qpert = 0.0
    ELSE
      qpert = qpert
    END IF
    IF (frland(i) .LT. 0.1) THEN
      IF (tpert .GT. cbl_tpert_mxocn) THEN
        tpert = cbl_tpert_mxocn
      ELSE
        tpert = tpert
      END IF
    ELSE IF (tpert .GT. cbl_tpert_mxlnd) THEN
      tpert = cbl_tpert_mxlnd
    ELSE
      tpert = tpert
    END IF
    CALL DQSAT_RAS(dqs, qss, tempf, pf, k0, estblx, cons_h2omw, &
&            cons_airmw)
    DO kk=icmin,k+1
      prj(kk) = pke(kk)
    END DO
    prs(icmin:k0+1) = ple(i, icmin:k0+1)
    poi(icmin:k) = tho(i, icmin:k)
    qoi(icmin:k) = qho(i, icmin:k)
    qst(icmin:k) = qss(icmin:k)
    dqq(icmin:k) = dqs(icmin:k)
!Mass fraction of each layer below cloud base
    massf(:) = wgt0(i, :)
!RESET PRESSURE at bottom edge of CBL 
    prcbl = prs(k)
    DO l=k,k0
      prcbl = prcbl + massf(l)*(prs(l+1)-prs(l))
    END DO
    prs(k+1) = prcbl
    prj(k+1) = (prs(k+1)/1000.)**(cons_rgas/cons_cp)
    DO l=k,icmin,-1
      pol(l) = 0.5*(prs(l)+prs(l+1))
      prh(l) = (prs(l+1)*prj(l+1)-prs(l)*prj(l))/(onepkap*(prs(l+1)-prs(&
&       l)))
      pki(l) = 1.0/prh(l)
      dpt(l) = prh(l) - prj(l)
      dpb(l) = prj(l+1) - prh(l)
      pri(l) = .01/(prs(l+1)-prs(l))
    END DO
!RECALCULATE PROFILE QUAN. IN LOWEST STRAPPED LAYER
    IF (k .LE. k0) THEN
      poi(k) = 0.
      qoi(k) = 0.
!SPECIFY WEIGHTS GIVEN TO EACH LAYER WITHIN SUBCLOUD "SUPERLAYER"
      wght = 0.
      DO l=k,k0
        wght(l) = massf(l)*(ple(i, l+1)-ple(i, l))/(prs(k+1)-prs(k))
      END DO
      DO l=k,k0
        poi(k) = poi(k) + wght(l)*tho(i, l)
        qoi(k) = qoi(k) + wght(l)*qho(i, l)
      END DO
      CALL PUSHCONTROL1B(1)
      arg1 = poi(k)*prh(k)
      CALL DQSATS_RAS(dqq(k), qst(k), arg1, pol(k), estblx, cons_h2omw, &
&               cons_airmw)
    ELSE
      CALL PUSHCONTROL1B(0)
    END IF
    IF (seedras(i)/1000000. .LT. 1e-6) THEN
      rndu = 1e-6
    ELSE
      rndu = seedras(i)/1000000.
    END IF
    mxdiam = maxdallowed*rndu**(-(1./2.))
    DO l=k,icmin,-1
!*
      bet(l) = dqq(l)*pki(l)
!*
      gam(l) = pki(l)/(1.0+lbcp*dqq(l))
      IF (l .LT. k) THEN
        ght(l+1) = gam(l)*dpb(l) + gam(l+1)*dpt(l+1)
        gm1(l+1) = 0.5*lbcp*(dqq(l)/(alhl*(1.0+lbcp*dqq(l)))+dqq(l+1)/(&
&         alhl*(1.0+lbcp*dqq(l+1))))
      END IF
    END DO
    rmf = 0.
!DO_TRACERS
    cvw = 0.0
! HOL initialized here in order not to confuse Valgrind debugger
    hol = 0.
    zet(k+1) = 0
    sht(k+1) = cp*poi(k)*prj(k+1)
    DO l=k,icmin,-1
      IF (qst(l)*rhmax .GT. qoi(l)) THEN
        qol(l) = qoi(l)
      ELSE
        qol(l) = qst(l)*rhmax
      END IF
      IF (0.000 .LT. qol(l)) THEN
        qol(l) = qol(l)
      ELSE
        qol(l) = 0.000
      END IF
      ssl(l) = cp*prj(l+1)*poi(l) + grav*zet(l+1)
      hol(l) = ssl(l) + qol(l)*alhl
      hst(l) = ssl(l) + qst(l)*alhl
      tem = poi(l)*(prj(l+1)-prj(l))*cpbg
      zet(l) = zet(l+1) + tem
      zol(l) = zet(l+1) + (prj(l+1)-prh(l))*poi(l)*cpbg
    END DO
    DO ic=k,icmin+1,-1
!DO_TRACERS
      IF (1. .GT. (qoi(k)/qst(k)-rhmn)/(rhmx-rhmn)) THEN
        trg = (qoi(k)/qst(k)-rhmn)/(rhmx-rhmn)
      ELSE
        trg = 1.
      END IF
      IF (0.0 .LT. (autorampb-sige(ic))/0.2) THEN
        y1 = (autorampb-sige(ic))/0.2
      ELSE
        y1 = 0.0
      END IF
      IF (1.0 .GT. y1) THEN
        f4 = y1
      ELSE
        f4 = 1.0
      END IF
      IF (trg .LE. 1.0e-5) THEN
        CALL PUSHCONTROL3B(5)
      ELSE
!================>>
!RECOMPUTE SOUNDING UP TO DETRAINMENT LEVEL
        poi_c = poi
        qoi_c = qoi
        poi_c(k) = poi_c(k) + tpert
        qoi_c(k) = qoi_c(k) + qpert
        zet(k+1) = 0.
        sht(k+1) = cp*poi_c(k)*prj(k+1)
        DO l=k,ic,-1
          IF (qst(l)*rhmax .GT. qoi_c(l)) THEN
            qol(l) = qoi_c(l)
          ELSE
            qol(l) = qst(l)*rhmax
          END IF
          IF (0.000 .LT. qol(l)) THEN
            qol(l) = qol(l)
          ELSE
            qol(l) = 0.000
          END IF
          ssl(l) = cp*prj(l+1)*poi_c(l) + grav*zet(l+1)
          hol(l) = ssl(l) + qol(l)*alhl
          hst(l) = ssl(l) + qst(l)*alhl
          CALL PUSHREAL8(tem)
          tem = poi_c(l)*(prj(l+1)-prj(l))*cpbg
          zet(l) = zet(l+1) + tem
          zol(l) = zet(l+1) + (prj(l+1)-prh(l))*poi_c(l)*cpbg
        END DO
        CALL PUSHINTEGER4(l + 1)
        ad_from = ic + 1
        DO l=ad_from,k
          CALL PUSHREAL8(tem)
          tem = (prj(l)-prh(l-1))/(prh(l)-prh(l-1))
          sht(l) = ssl(l-1) + tem*(ssl(l)-ssl(l-1))
          qht(l) = .5*(qol(l)+qol(l-1))
        END DO
        CALL PUSHINTEGER4(ad_from)
!CALCULATE LAMBDA, ETA, AND WORKFUNCTION
        lambda_min = .2/mxdiam
        lambda_max = .2/200.
        IF (hol(k) .LE. hst(ic)) THEN
          CALL PUSHCONTROL3B(4)
        ELSE
!================>>
!LAMBDA CALCULATION: MS-A18
          CALL PUSHREAL8(tem)
          tem = (hst(ic)-hol(ic))*(zol(ic)-zet(ic+1))
          DO l=ic+1,k-1
            tem = tem + (hst(ic)-hol(l))*(zet(l)-zet(l+1))
          END DO
          IF (tem .LE. 0.0) THEN
            CALL PUSHCONTROL3B(3)
          ELSE
!================>>
            alm = (hol(k)-hst(ic))/tem
            IF (alm .GT. lambda_max) THEN
              CALL PUSHCONTROL3B(2)
            ELSE
!================>>
              toki = 1.0
              IF (alm .LT. lambda_min) toki = (alm/lambda_min)**2
              ad_from0 = ic + 1
!ETA CALCULATION: MS-A2
              DO l=ad_from0,k
                CALL PUSHREAL8(eta(l))
                eta(l) = 1.0 + alm*(zet(l)-zet(k))
              END DO
              CALL PUSHINTEGER4(ad_from0)
              CALL PUSHREAL8(eta(ic))
              eta(ic) = 1.0 + alm*(zol(ic)-zet(k))
!WORKFUNCTION CALCULATION:  MS-A22
              wfn = 0.0
              hcc(k) = hol(k)
              DO l=k-1,ic+1,-1
                hcc(l) = hcc(l+1) + (eta(l)-eta(l+1))*hol(l)
                tem = hcc(l+1)*dpb(l) + hcc(l)*dpt(l)
                eht(l) = eta(l+1)*dpb(l) + eta(l)*dpt(l)
                wfn = wfn + (tem-eht(l)*hst(l))*gam(l)
              END DO
              hcc(ic) = hst(ic)*eta(ic)
              wfn = wfn + (hcc(ic+1)-hst(ic)*eta(ic+1))*gam(ic)*dpb(ic)
!VERTICAL VELOCITY/KE CALCULATION (ADDED 12/2001 JTB)
              bk2(k) = 0.0
              hcld(k) = hol(k)
              DO l=k-1,ic,-1
                hcld(l) = (eta(l+1)*hcld(l+1)+(eta(l)-eta(l+1))*hol(l))/&
&                 eta(l)
                tem = (hcld(l)-hst(l))*(zet(l)-zet(l+1))/(1.0+lbcp*dqq(l&
&                 ))
                IF (tem .LT. 0.0) THEN
                  max1 = 0.0
                ELSE
                  max1 = tem
                END IF
                bk2(l) = bk2(l+1) + grav*max1/(cp*prj(l+1)*poi(l))
                IF (bk2(l) .LT. 0.0) THEN
                  max2 = 0.0
                ELSE
                  max2 = bk2(l)
                END IF
                cvw(l) = SQRT(2.0*max2)
              END DO
!ALPHA CALCULATION 
              IF (zet(ic) .LT. 2000.) rasal(ic) = rasal1
              IF (zet(ic) .GE. 2000.) rasal(ic) = rasal1 + (rasal2-&
&                 rasal1)*(zet(ic)-2000.)/8000.
              IF (rasal(ic) .GT. 1.0e5) THEN
                rasal(ic) = 1.0e5
              ELSE
                rasal(ic) = rasal(ic)
              END IF
              rasal(ic) = dt/rasal(ic)
              DO l=ic,k
                IF (cvw(l) .LT. 1.00) THEN
                  cvw(l) = 1.00
                ELSE
                  cvw(l) = cvw(l)
                END IF
              END DO
              CALL ACRITN(pol(ic), prs(k), acr, acritfac)
              IF (wfn .LE. acr) THEN
                CALL PUSHCONTROL3B(1)
              ELSE
!================>>
!DO_TRACERS
                DO itr=1,itrcr
!Scavenging of the below cloud tracer
                  delzkm = (zet(ic)-zet(k))/1000.
                  x4 = EXP(-(fscav(itr)*delzkm))
                  IF (x4 .GT. 1.) THEN
                    x1 = 1.
                  ELSE
                    x1 = x4
                  END IF
                  IF (x1 .LT. 0.) THEN
                    CALL PUSHREAL8(fnoscav)
                    fnoscav = 0.
                    CALL PUSHCONTROL1B(0)
                  ELSE
                    CALL PUSHREAL8(fnoscav)
                    fnoscav = x1
                    CALL PUSHCONTROL1B(1)
                  END IF
                END DO
                wlq = qol(k)
                DO l=k-1,ic,-1
                  CALL PUSHREAL8(tem)
                  tem = eta(l) - eta(l+1)
                  wlq = wlq + tem*qol(l)
!DO_TRACERS
                  DO itr=1,itrcr
!Scavenging of the entrained tracer.  Updates transported tracer mass.
                    delzkm = (zet(ic)-zet(l+1))/1000.
                    x5 = EXP(-(fscav(itr)*delzkm))
                    IF (x5 .GT. 1.) THEN
                      x2 = 1.
                    ELSE
                      x2 = x5
                    END IF
                    IF (x2 .LT. 0.) THEN
                      CALL PUSHREAL8(fnoscav)
                      fnoscav = 0.
                      CALL PUSHCONTROL1B(0)
                    ELSE
                      CALL PUSHREAL8(fnoscav)
                      fnoscav = x2
                      CALL PUSHCONTROL1B(1)
                    END IF
                  END DO
                  IF (l .GT. ic) THEN
                    tx2 = 0.5*(qst(l)+qst(l-1))*eta(l)
                    tx3 = 0.5*(hst(l)+hst(l-1))*eta(l)
                    qcc = tx2 + gm1(l)*(hcc(l)-tx3)
                    cll0(l) = wlq - qcc
                  ELSE
                    cll0(l) = wlq - qst(ic)*eta(ic)
                  END IF
                  IF (cll0(l) .LT. 0.00) THEN
                    cll0(l) = 0.00
                  ELSE
                    cll0(l) = cll0(l)
                  END IF
                  cli = cll0(l)/eta(l)
                  te_a = poi(l)*prh(l)
                  CALL SUNDQ3_ICE(te_a, sdqv2, sdqv3, sdqvt1, f2, f3)
                  c00_x = co_auto(i)*f2*f3*f4
                  cli_crit_x = cli_crit/(f2*f3)
                  rate = c00_x*(1.0-EXP(-(cli**2/cli_crit_x**2)))
                  IF (cvw(l) .LT. 1.00) THEN
                    cvw_x = 1.00
                  ELSE
                    cvw_x = cvw(l)
                  END IF
                  dt_lyr = (zet(l)-zet(l+1))/cvw_x
                  closs = cll0(l)*rate*dt_lyr
                  IF (closs .GT. cll0(l)) THEN
                    closs = cll0(l)
                  ELSE
                    closs = closs
                  END IF
                  IF (closs .GT. 0.) wlq = wlq - closs
                END DO
                CALL PUSHINTEGER4(l + 1)
                wlq = wlq - qst(ic)*eta(ic)
!CALCULATE GAMMAS AND KERNEL
                gms(k) = (sht(k)-ssl(k))*pri(k)
                gmh(k) = gms(k) + (qht(k)-qol(k))*pri(k)*alhl
                akm = gmh(k)*gam(k-1)*dpb(k-1)
                tx2 = gmh(k)
                DO l=k-1,ic+1,-1
                  gms(l) = (eta(l)*(sht(l)-ssl(l))+eta(l+1)*(ssl(l)-sht(&
&                   l+1)))*pri(l)
                  gmh(l) = gms(l) + (eta(l)*(qht(l)-qol(l))+eta(l+1)*(&
&                   qol(l)-qht(l+1)))*alhl*pri(l)
                  tx2 = tx2 + (eta(l)-eta(l+1))*gmh(l)
                  akm = akm - gms(l)*eht(l)*pki(l) + tx2*ght(l)
                END DO
                gms(ic) = eta(ic+1)*(ssl(ic)-sht(ic+1))*pri(ic)
                akm = akm - gms(ic)*eta(ic+1)*dpb(ic)*pki(ic)
                gmh(ic) = gms(ic) + (eta(ic+1)*(qol(ic)-qht(ic+1))*alhl+&
&                 eta(ic)*(hst(ic)-hol(ic)))*pri(ic)
!CLOUD BASE MASS FLUX
                IF (akm .GE. 0.0 .OR. wlq .LT. 0.0) THEN
                  CALL PUSHCONTROL3B(0)
                ELSE
!================>>
                  wfn = -((wfn-acr)/akm)
                  x3 = rasal(ic)*trg*toki*wfn
                  IF (x3 .GT. (prs(k+1)-prs(k))*(100.*pblfrac)) THEN
                    wfn = (prs(k+1)-prs(k))*(100.*pblfrac)
                  ELSE
                    wfn = x3
                  END IF
!CUMULATIVE PRECIP AND CLOUD-BASE MASS FLUX FOR OUTPUT
                  CALL PUSHREAL8(tem)
                  tem = wfn*gravi
                  rmf(ic) = rmf(ic) + tem
!THETA AND Q CHANGE DUE TO CLOUD TYPE IC
                  DO l=ic,k
                    gmh(l) = gmh(l)*wfn
                    gms(l) = gms(l)*wfn
                    qoi(l) = qoi(l) + (gmh(l)-gms(l))*alhi
                    poi(l) = poi(l) + gms(l)*pki(l)*cpi
                    qst(l) = qst(l) + gms(l)*bet(l)*cpi
                  END DO
!*FRICFAC*0.5
                  wfn = wfn*0.5*1.0
!DO_TRACERS
                  tem = wfn*pri(k)
                  DO itr=1,itrcr
                    DO l=k-1,ic+1,-1
                      CALL PUSHREAL8(tem)
                      tem = wfn*pri(l)
                    END DO
                    CALL PUSHINTEGER4(l + 1)
                  END DO
                  CALL PUSHREAL8(tem)
                  tem = wfn*pri(ic)
                  DO itr=1,itrcr
                    ad_from1 = ic
                    CALL PUSHINTEGER4(ad_from1)
                  END DO
                  CALL PUSHCONTROL3B(6)
                END IF
              END IF
            END IF
          END IF
        END IF
      END IF
    END DO
!CLOUD LOOP
    IF (SUM(rmf(icmin:k)) .GT. 0.0) THEN
!De-strap tendencies from RAS
      CALL PUSHREAL8ARRAY(wght, k0)
      wght = wgt1(i, :)
!Scale properly by layer masses
      wght0 = 0.
      DO l=k,k0
        wght0 = wght0 + wght(l)*(ple(i, l+1)-ple(i, l))
      END DO
      wght0 = (prs(k+1)-prs(k))/wght0
      wght = wght0*wght
      xoib = 0.0_8
      xoi_svb = 0.0_8
      DO itr=itrcr,1,-1
        DO l=k0,k,-1
          xoib(k, itr) = xoib(k, itr) + wght(l)*xhob(i, l, itr)
          xoi_svb(k, itr) = xoi_svb(k, itr) - wght(l)*xhob(i, l, itr)
        END DO
      END DO
      xoib(icmin:k-1, :) = xoib(icmin:k-1, :) + xhob(i, icmin:k-1, :)
      xhob(i, icmin:k-1, :) = 0.0_8
      CALL POPREAL8ARRAY(wght, k0)
    ELSE
      xoib = 0.0_8
      xoi_svb = 0.0_8
    END IF
    xcub = 0.0_8
    xhtb = 0.0_8
    DO ic=icmin+1,k,1
      CALL POPCONTROL3B(branch)
      IF (branch .LT. 3) THEN
        IF (branch .NE. 0) THEN
          IF (branch .EQ. 1) THEN
            GOTO 100
          ELSE
            GOTO 110
          END IF
        END IF
      ELSE IF (branch .LT. 5) THEN
        IF (branch .EQ. 3) THEN
          GOTO 110
        ELSE
          GOTO 120
        END IF
      ELSE IF (branch .EQ. 5) THEN
        GOTO 130
      ELSE
        DO itr=itrcr,1,-1
          CALL POPINTEGER4(ad_from1)
          DO l=k,ad_from1,-1
            xcub(l, itr) = xcub(l, itr) + xoib(l, itr)
          END DO
        END DO
        DO itr=itrcr,1,-1
          tempb1 = tem*xcub(ic, itr)
          tempb2 = -(eta(ic+1)*tempb1)
          xhtb(itr) = xhtb(itr) + 2.*tempb1
          xoib(ic, itr) = xoib(ic, itr) + tempb2 - 2.*(eta(ic)-eta(ic+1)&
&           )*tempb1
          xoib(ic+1, itr) = xoib(ic+1, itr) + tempb2
        END DO
        CALL POPREAL8(tem)
        DO itr=itrcr,1,-1
          CALL POPINTEGER4(ad_to1)
          DO l=ad_to1,k-1,1
            tempb = tem*xcub(l, itr)
            tempb0 = eta(l+1)*tempb
            xoib(l-1, itr) = xoib(l-1, itr) + eta(l)*tempb
            xoib(l, itr) = xoib(l, itr) + tempb0 - eta(l)*tempb
            xoib(l+1, itr) = xoib(l+1, itr) - tempb0
            CALL POPREAL8(tem)
          END DO
        END DO
        DO itr=itrcr,1,-1
          xoib(k-1, itr) = xoib(k-1, itr) + tem*xcub(k, itr)
          xoib(k, itr) = xoib(k, itr) - tem*xcub(k, itr)
        END DO
        CALL POPREAL8(tem)
      END IF
      CALL POPINTEGER4(ad_to0)
      DO l=ad_to0,k-1,1
        DO itr=itrcr,1,-1
          xoib(l, itr) = xoib(l, itr) + tem*fnoscav*xhtb(itr)
          CALL POPCONTROL1B(branch)
          IF (branch .EQ. 0) THEN
            CALL POPREAL8(fnoscav)
          ELSE
            CALL POPREAL8(fnoscav)
          END IF
        END DO
        CALL POPREAL8(tem)
      END DO
      DO itr=itrcr,1,-1
        xoib(k, itr) = xoib(k, itr) + fnoscav*xhtb(itr)
        xhtb(itr) = 0.0_8
        CALL POPCONTROL1B(branch)
        IF (branch .EQ. 0) THEN
          CALL POPREAL8(fnoscav)
        ELSE
          CALL POPREAL8(fnoscav)
        END IF
      END DO
 100  CALL POPREAL8(eta(ic))
      CALL POPINTEGER4(ad_from0)
      DO l=k,ad_from0,-1
        CALL POPREAL8(eta(l))
      END DO
 110  CALL POPREAL8(tem)
 120  CALL POPINTEGER4(ad_from)
      DO l=k,ad_from,-1
        CALL POPREAL8(tem)
      END DO
      CALL POPINTEGER4(ad_to)
      DO l=ad_to,k,1
        CALL POPREAL8(tem)
      END DO
 130  xcub(icmin:k0, :) = 0.0_8
    END DO
    xoib = xoib + xoi_svb
    CALL POPCONTROL1B(branch)
    IF (branch .NE. 0) THEN
      DO itr=itrcr,1,-1
        DO l=k0,k,-1
          xhob(i, l, itr) = xhob(i, l, itr) + wght(l)*xoib(k, itr)
        END DO
      END DO
      xoib(k, :) = 0.0_8
    END IF
    DO itr=itrcr,1,-1
      xhob(i, icmin:k, itr) = xhob(i, icmin:k, itr) + xoib(icmin:k, itr)
      xoib(icmin:k, itr) = 0.0_8
    END DO
  END IF
END SUBROUTINE RASE_TRACER_B

END MODULE CONVECTION_AD
