MODULE CLOUD_AD

USE cloud
USE cloud_tl, only: LS_CLOUD_D

IMPLICIT NONE

PRIVATE
PUBLIC CLOUD_DRIVER_B

CONTAINS
!        Generated by TAPENADE     (INRIA, Tropics team)
!  Tapenade 3.9 (r5096) - 24 Feb 2014 16:53
!
!  Differentiation of cloud_driver in reverse (adjoint) mode:
!   gradient     of useful results: th qi_con q cf_ls cf_con ql_ls
!                ql_con qi_ls
!   with respect to varying inputs: th qi_con cnv_prc3 q cnv_dqldt
!                cf_ls cnv_updf cf_con cnv_mfd ql_ls ql_con qi_ls
!   RW status of diff variables: th:in-out qi_con:in-out cnv_prc3:out
!                q:in-out cnv_dqldt:out cf_ls:in-out cnv_updf:out
!                cf_con:in-out cnv_mfd:out ql_ls:in-out ql_con:in-out
!                qi_ls:in-out
SUBROUTINE CLOUD_DRIVER_B(dt, im, jm, lm, th, thb, q, qb, ple, cnv_dqldt&
& , cnv_dqldtb, cnv_mfd, cnv_mfdb, cnv_prc3, cnv_prc3b, cnv_updf, &
& cnv_updfb, qi_ls, qi_lsb, ql_ls, ql_lsb, qi_con, qi_conb, ql_con, &
& ql_conb, cf_ls, cf_lsb, cf_con, cf_conb, frland, physparams, estblx, &
& khu, khl, cons_runiv, cons_kappa, cons_airmw, cons_h2omw, cons_grav, &
& cons_alhl, cons_alhf, cons_pi, cons_rgas, cons_cp, cons_vireps, &
& cons_alhs, cons_tice, cons_rvap, cons_p00, do_moist_physics)
  IMPLICIT NONE
!INPUTS
  INTEGER, INTENT(IN) :: im, jm, lm, do_moist_physics
  REAL*8, INTENT(IN) :: dt, frland(im, jm), physparams(:)
  REAL*8, DIMENSION(im, jm, lm), INTENT(IN) :: cnv_dqldt, cnv_mfd, &
& cnv_updf, cnv_prc3
  REAL*8, DIMENSION(im, jm, lm) :: cnv_dqldtb, cnv_mfdb, cnv_updfb, &
& cnv_prc3b
  REAL*8, INTENT(IN) :: estblx(:)
  REAL*8, DIMENSION(im, jm, 0:lm), INTENT(IN) :: ple
  INTEGER, DIMENSION(im, jm), INTENT(IN) :: khu, khl
!MAPL_CONSTANTS REDEFINED FOR USE IN AUTODIFF TOOL
  REAL*8, INTENT(IN) :: cons_runiv, cons_kappa, cons_airmw
  REAL*8, INTENT(IN) :: cons_h2omw, cons_grav, cons_alhl
  REAL*8, INTENT(IN) :: cons_alhf, cons_pi, cons_rgas
  REAL*8, INTENT(IN) :: cons_cp, cons_vireps, cons_alhs
  REAL*8, INTENT(IN) :: cons_tice, cons_rvap, cons_p00
!PROGNOSTICS
  REAL*8, DIMENSION(im, jm, lm), INTENT(INOUT) :: th, q
  REAL*8, DIMENSION(im, jm, lm), INTENT(INOUT) :: thb
  REAL*8, DIMENSION(im, jm, lm), INTENT(INOUT) :: qi_ls, ql_ls, qi_con, &
& ql_con, cf_con, cf_ls
  REAL*8, DIMENSION(im, jm, lm), INTENT(INOUT) :: qi_lsb
!OUTPUTS (DIAGNOSTICS)
!LOCALS
  INTEGER :: i, j, k, l, ktop
  REAL*8, DIMENSION(im, jm, lm) :: ph, pih, mass, imass, t, dzet, qddf3&
& , rh, dp, dm
  REAL*8, DIMENSION(im, jm, lm) :: tb, dzetb, qddf3b
  REAL*8, DIMENSION(im, jm, lm + 1) :: zet
  REAL*8, DIMENSION(im, jm, lm+1) :: zetb
  REAL*8, DIMENSION(im, jm, 0:lm) :: p, pi
  REAL*8, DIMENSION(im, jm, lm) :: qs, dqsdt, dqs
  REAL*8, DIMENSION(im, jm, lm) :: qsb, dqsdtb, dqsb
  REAL*8, DIMENSION(im, jm) :: vmip
  REAL*8, DIMENSION(im, jm) :: vmipb
!Precip amounts and fall rate
  REAL*8 :: cf_tot
  REAL*8 :: cf_totb
  REAL*8 :: alpha, alhx3, rhcrit
  REAL*8 :: alhx3b
!Microphyiscal constants
  REAL*8 :: aa, bb
  REAL*8 :: aab, bbb
  REAL*8, PARAMETER :: pi_0=4.*ATAN(1.)
!Density of liquid water in kg/m^3
  REAL*8, PARAMETER :: rho_w=1.0e3
  REAL*8 :: t_ice_max
!PHYSPARAMS constants
  REAL*8 :: cnv_beta, anv_beta, ls_beta, rh00, c_00, lwcrit, c_acc, &
& c_ev_r, c_ev_s, cldvol2frc
  REAL*8 :: rhsup_ice, shr_evap_fac, min_cld_water, cld_evp_eff, &
& ls_sdqv2, ls_sdqv3, ls_sdqvt1
  REAL*8 :: anv_sdqv2, anv_sdqv3, anv_sdqvt1, anv_to_ls, n_warm, n_ice, &
& n_anvil, n_pbl
  REAL*8 :: anv_icefall_c, ls_icefall_c, revap_off_p, cnvenvfc, wrhodep&
& , t_ice_all, cnviceparam
  REAL*8 :: cnvddrfc, anvddrfc, lsddrfc, minrhcrit, maxrhcrit, &
& turnrhcrit, maxrhcritland
  REAL*8 :: min_rl, min_ri, max_rl, max_ri, ri_anv
  INTEGER :: nsmax, disable_rad, icefrpwr, tanhrhcrit, fr_ls_wat, &
& fr_ls_ice, fr_an_wat, fr_an_ice, pdfflag
  REAL*8 :: lsenvfc, anvenvfc
  REAL*8 :: qrn_cu, qsn_cu, qrn_an, qsn_an, qrn_ls, qsn_ls, qrn_cu_1d
  REAL*8 :: qsn_cub, qrn_anb, qsn_anb, qrn_lsb, qsn_lsb, qrn_cu_1db
  REAL*8 :: qt_tmpi_1, qt_tmpi_2, qlt_tmp, qit_tmp
  REAL*8 :: qt_tmpi_1b, qt_tmpi_2b, qlt_tmpb, qit_tmpb
  REAL*8 :: prn_above_cu_new, prn_above_an_new, prn_above_ls_new
  REAL*8 :: prn_above_cu_newb, prn_above_an_newb, prn_above_ls_newb
  REAL*8 :: prn_above_cu_old, prn_above_an_old, prn_above_ls_old
  REAL*8 :: prn_above_cu_oldb, prn_above_an_oldb, prn_above_ls_oldb
  REAL*8 :: psn_above_cu_new, psn_above_an_new, psn_above_ls_new
  REAL*8 :: psn_above_cu_newb, psn_above_an_newb, psn_above_ls_newb
  REAL*8 :: psn_above_cu_old, psn_above_an_old, psn_above_ls_old
  REAL*8 :: psn_above_cu_oldb, psn_above_an_oldb, psn_above_ls_oldb
  REAL*8 :: evap_dd_cu_above_new, evap_dd_an_above_new, &
& evap_dd_ls_above_new
  REAL*8 :: evap_dd_cu_above_newb, evap_dd_an_above_newb, &
& evap_dd_ls_above_newb
  REAL*8 :: evap_dd_cu_above_old, evap_dd_an_above_old, &
& evap_dd_ls_above_old
  REAL*8 :: evap_dd_cu_above_oldb, evap_dd_an_above_oldb, &
& evap_dd_ls_above_oldb
  REAL*8 :: subl_dd_cu_above_new, subl_dd_an_above_new, &
& subl_dd_ls_above_new
  REAL*8 :: subl_dd_cu_above_newb, subl_dd_an_above_newb, &
& subl_dd_ls_above_newb
  REAL*8 :: subl_dd_cu_above_old, subl_dd_an_above_old, &
& subl_dd_ls_above_old
  REAL*8 :: subl_dd_cu_above_oldb, subl_dd_an_above_oldb, &
& subl_dd_ls_above_oldb
  REAL*8 :: area_ls_prc1, area_upd_prc1, area_anv_prc1
  REAL*8 :: area_ls_prc1b, area_upd_prc1b, area_anv_prc1b
  REAL*8 :: tot_prec_upd, tot_prec_anv, tot_prec_ls, area_upd_prc, &
& area_anv_prc, area_ls_prc
  REAL*8 :: tot_prec_updb, tot_prec_anvb, tot_prec_lsb, area_upd_prcb, &
& area_anv_prcb, area_ls_prcb
  REAL*8 :: qtmp2
  REAL*8 :: rhexcess, tpw, negtpw
  REAL*8 :: tpwb, negtpwb
  INTEGER :: cloud_pertmod
  INTRINSIC ATAN
  INTRINSIC INT
  INTRINSIC SUM
  INTRINSIC MAX
  INTEGER :: branch
  REAL*8, DIMENSION(im, jm, lm), INTENT(INOUT) :: qb
  REAL*8, DIMENSION(im, jm, lm), INTENT(INOUT) :: ql_lsb
  REAL*8, DIMENSION(im, jm, lm), INTENT(INOUT) :: ql_conb
  REAL*8, DIMENSION(im, jm, lm), INTENT(INOUT) :: qi_conb
  REAL*8, DIMENSION(im, jm, lm), INTENT(INOUT) :: cf_conb
  REAL*8, DIMENSION(im, jm, lm), INTENT(INOUT) :: cf_lsb
  REAL*8 :: temp2
  REAL*8 :: temp1(im, jm, lm)
  LOGICAL :: mask0(im, jm, lm)
  REAL*8 :: temp0
  REAL*8 :: tempb9
  REAL*8 :: tempb8
  REAL*8 :: tempb7
  REAL*8 :: tempb6
  REAL*8 :: tempb5
  REAL*8 :: tempb4
  REAL*8 :: tempb3
  REAL*8 :: tempb2
  REAL*8 :: tempb1
  REAL*8 :: tempb16
  REAL*8 :: tempb0
  REAL*8 :: tempb15
  REAL*8 :: tempb14(im, jm, lm)
  REAL*8 :: tempb13
  REAL*8 :: tempb12
  REAL*8 :: tempb11
  REAL*8 :: tempb10
  REAL*8 :: tempb
  LOGICAL :: mask(im, jm, lm)
  REAL*8 :: temp

  !LS_CLOUD FILTERING
  integer :: ii
  real(8) :: xx(8) 
  real(8) :: ttraj, qtraj, qi_lstraj, qi_contraj, ql_lstraj, ql_contraj, cf_lstraj, cf_contraj, phtraj 
  real(8) :: tpert, qpert, qi_lspert, qi_conpert, ql_lspert, ql_conpert, cf_lspert, cf_conpert
  real(8) :: Jacobian(8,8), A(8,8)

  !Eigenvalue computation
  integer, parameter :: N1  = 8
  integer, parameter :: LDA = 8
  REAL(8) :: WR(N1), WI(N1)
  INTEGER, PARAMETER :: LDVL = N1 !Left vecotrs
  REAL(8) :: VL(LDVL,N1)
  INTEGER, PARAMETER :: LDVR = N1 !Right vectors
  REAL(8) :: VR(LDVR,N1)
  INTEGER :: INFO, LWORK
  INTEGER, PARAMETER :: LWMAX = 10000
  REAL(8) :: WORK(LWMAX)
  EXTERNAL :: DGEEV
  REAL*8 :: maxeval

  !Total Filtering
  real(8) :: TOTfilt_T, TOTfilt_ql, TOTfilt_qi
  real(8) :: t_p_preall, ql_ls_p_preall, ql_con_p_preall, qi_ls_p_preall, qi_con_p_preall

  !Sink Filtering
  real(8) :: SINKfilt_ql, SINKfilt_qi, SINKfilt_CF
  real(8) :: t_p_presink, q_p_presink
  real(8) ::  ql_ls_p_presink, ql_con_p_presink
  real(8) ::  qi_ls_p_presink, qi_con_p_presink
  real(8) ::  cf_con_p_presink


!Highest level of calculations
  ktop = 30
!Get Constants from CLOUDPARAMS
! Area factor for convective rain showers (non-dim)
  cnv_beta = physparams(1)
! Area factor for anvil rain showers (non-dim)
  anv_beta = physparams(2)
! Area factor for Large Scale rain showers (non-dim)
  ls_beta = physparams(3)
! Critical relative humidity
  rh00 = physparams(4)
  c_00 = physparams(5)
  lwcrit = physparams(6)
  c_acc = physparams(7)
  c_ev_r = physparams(8)
  c_ev_s = physparams(56)
  cld_evp_eff = physparams(13)
  ls_sdqv2 = physparams(15)
  ls_sdqv3 = physparams(16)
  ls_sdqvt1 = physparams(17)
  anv_sdqv2 = physparams(18)
  anv_sdqv3 = physparams(19)
  anv_sdqvt1 = physparams(20)
  anv_icefall_c = physparams(28)
  ls_icefall_c = physparams(29)
  revap_off_p = physparams(30)
  cnvenvfc = physparams(31)
  wrhodep = physparams(32)
  t_ice_all = physparams(33) + cons_tice
  icefrpwr = INT(physparams(35) + .001)
  cnvddrfc = physparams(36)
  anvddrfc = physparams(37)
  lsddrfc = physparams(38)
  minrhcrit = physparams(42)
  maxrhcrit = physparams(43)
  turnrhcrit = physparams(45)
  maxrhcritland = physparams(46)
  pdfflag = INT(physparams(57))
  t_ice_max = cons_tice
!Initialize the saving of downdraft values.
  prn_above_cu_new = 0.
  prn_above_an_new = 0.
  prn_above_ls_new = 0.
  psn_above_cu_new = 0.
  psn_above_an_new = 0.
  psn_above_ls_new = 0.
  evap_dd_cu_above_new = 0.
  evap_dd_an_above_new = 0.
  evap_dd_ls_above_new = 0.
  subl_dd_cu_above_new = 0.
  subl_dd_an_above_new = 0.
  subl_dd_ls_above_new = 0.
!Convert to hPa and average pressure to temperature levels
  p = ple*0.01
  ph = 0.5*(p(:, :, 0:lm-1)+p(:, :, 1:lm))
!Calculate Exner Pressure at temperature levels
  pi = (p/1000.)**(cons_rgas/cons_cp)
  pih = (ph/1000.)**(cons_rgas/cons_cp)
!Calculate temperature
  t = th*pih
!Compute QS and DQSDT
  CALL DQSAT_BAC(dqsdt, qs, t, ph, im, jm, lm, estblx, cons_h2omw, &
&          cons_airmw)
!Relative humidity
!Compute layer mass and 1/mass
  mass = (p(:, :, 1:lm)-p(:, :, 0:lm-1))*100./cons_grav
  imass = 1/mass
!Level thickness
  dzet(:, :, 1:lm) = th(:, :, 1:lm)*(pi(:, :, 1:lm)-pi(:, :, 0:lm-1))*&
&   cons_cp/cons_grav
!Level heights
  zet(:, :, lm+1) = 0.0
  DO k=lm,1,-1
    zet(:, :, k) = zet(:, :, k+1) + dzet(:, :, k)
  END DO
  mask(:, :, 1:lm) = zet(:, :, 1:lm) .LT. 3000.
  WHERE (mask(:, :, 1:lm)) 
    qddf3 = -((zet(:, :, 1:lm)-3000.)*zet(:, :, 1:lm)*mass)
  ELSEWHERE
    qddf3 = 0.
  END WHERE
  DO i=1,im
    DO j=1,jm
      vmip(i, j) = SUM(qddf3(i, j, :))
    END DO
  END DO
  DO k=1,lm
    CALL PUSHREAL8ARRAY(qddf3(:, :, k), im*jm)
    qddf3(:, :, k) = qddf3(:, :, k)/vmip
  END DO
!Pressure and mass thickness for use in cleanup.
  dp = ple(:, :, 1:lm) - ple(:, :, 0:lm-1)
  dm = dp*(1./cons_grav)
!Begin loop over all grid boxes.
  DO i=1,im
    DO j=1,jm
      DO k=ktop,lm
        IF (k .EQ. ktop) THEN
          CALL PUSHREAL8(tot_prec_upd)
          tot_prec_upd = 0.
          CALL PUSHREAL8(tot_prec_anv)
          tot_prec_anv = 0.
          CALL PUSHREAL8(tot_prec_ls)
          tot_prec_ls = 0.
          CALL PUSHREAL8(area_upd_prc)
          area_upd_prc = 0.
          CALL PUSHREAL8(area_anv_prc)
          area_anv_prc = 0.
          CALL PUSHREAL8(area_ls_prc)
          area_ls_prc = 0.
          CALL PUSHCONTROL1B(1)
        ELSE
          CALL PUSHCONTROL1B(0)
        END IF
!Initialize precips, except QRN_CU which comes from RAS 
        qrn_ls = 0.
        qrn_an = 0.
        qsn_ls = 0.
        qsn_an = 0.
        qsn_cu = 0.
!Ras Rain         
        qrn_cu_1d = cnv_prc3(i, j, k)
!Tidy up where fractions or cloud is too low
        CALL PUSHREAL8(cf_con(i, j, k))
        CALL PUSHREAL8(qi_con(i, j, k))
        CALL PUSHREAL8(ql_con(i, j, k))
        CALL PUSHREAL8(cf_ls(i, j, k))
        CALL PUSHREAL8(qi_ls(i, j, k))
        CALL PUSHREAL8(ql_ls(i, j, k))
        CALL PUSHREAL8(t(i, j, k))
        CALL CLOUD_TIDY(q(i, j, k), t(i, j, k), ql_ls(i, j, k), qi_ls(i&
&                 , j, k), cf_ls(i, j, k), ql_con(i, j, k), qi_con(i, j&
&                 , k), cf_con(i, j, k), cons_alhl, cons_alhs, cons_cp)
!Phase changes for large scale cloud.
        CALL PUSHREAL8(qi_ls(i, j, k))
        CALL PUSHREAL8(ql_ls(i, j, k))
        CALL PUSHREAL8(t(i, j, k))
        CALL MELTFREEZE(dt, t(i, j, k), ql_ls(i, j, k), qi_ls(i, j, k), &
&                 t_ice_all, t_ice_max, icefrpwr, cons_alhl, cons_alhs, &
&                 cons_cp)
!Phase changes for convective cloud.
        CALL PUSHREAL8(qi_con(i, j, k))
        CALL PUSHREAL8(ql_con(i, j, k))
        CALL PUSHREAL8(t(i, j, k))
        CALL MELTFREEZE(dt, t(i, j, k), ql_con(i, j, k), qi_con(i, j, k)&
&                 , t_ice_all, t_ice_max, icefrpwr, cons_alhl, cons_alhs&
&                 , cons_cp)
!STAGE 1 - Compute convective clouds from RAS diagnostics
        CALL PUSHREAL8(cf_con(i, j, k))
        CALL PUSHREAL8(qi_con(i, j, k))
        CALL PUSHREAL8(ql_con(i, j, k))
        CALL PUSHREAL8(q(i, j, k))
        CALL PUSHREAL8(t(i, j, k))
        CALL CONVEC_SRC(dt, mass(i, j, k), imass(i, j, k), t(i, j, k), q&
&                 (i, j, k), cnv_dqldt(i, j, k), cnv_mfd(i, j, k), &
&                 ql_con(i, j, k), qi_con(i, j, k), cf_con(i, j, k), qs(&
&                 i, j, k), cons_alhs, cons_alhl, cons_cp, t_ice_all, &
&                 t_ice_max, icefrpwr)
!STAGE 2a - Get PDF attributes
        CALL PUSHREAL8(alpha)
        CALL PDF_WIDTH(ph(i, j, k), frland(i, j), maxrhcrit, &
&                maxrhcritland, turnrhcrit, minrhcrit, pi_0, alpha)
        IF (alpha .LT. 1.0 - rh00) THEN
          alpha = 1.0 - rh00
        ELSE
          alpha = alpha
        END IF
        CALL PUSHREAL8(rhcrit)
        rhcrit = 1.0 - alpha
        cloud_pertmod = 1
!STAGE 2b - Use PDF to compute large scale cloud effects and diagnostics,
!           also update convection clouds
        CALL PUSHREAL8(cf_con(i, j, k))
        CALL PUSHREAL8(cf_ls(i, j, k))
        CALL PUSHREAL8(qi_con(i, j, k))
        CALL PUSHREAL8(qi_ls(i, j, k))
        CALL PUSHREAL8(ql_con(i, j, k))
        CALL PUSHREAL8(ql_ls(i, j, k))
        CALL PUSHREAL8(q(i, j, k))
        CALL PUSHREAL8(t(i, j, k))
        CALL LS_CLOUD(dt, alpha, pdfflag, ph(i, j, k), t(i, j, k), q(i, &
&               j, k), ql_ls(i, j, k), ql_con(i, j, k), qi_ls(i, j, k), &
&               qi_con(i, j, k), cf_ls(i, j, k), cf_con(i, j, k), &
&               cons_alhl, cons_alhf, cons_alhs, cons_cp, cons_h2omw, &
&               cons_airmw, t_ice_all, t_ice_max, icefrpwr, estblx, &
&               cloud_pertmod, do_moist_physics)
!Clean up where too much overall cloud.
        CALL PUSHREAL8(cf_tot)
        cf_tot = cf_ls(i, j, k) + cf_con(i, j, k)
        IF (cf_tot .GT. 1.00) THEN
          CALL PUSHREAL8(cf_ls(i, j, k))
          cf_ls(i, j, k) = cf_ls(i, j, k)*(1.00/cf_tot)
          CALL PUSHREAL8(cf_con(i, j, k))
          cf_con(i, j, k) = cf_con(i, j, k)*(1.00/cf_tot)
          CALL PUSHCONTROL1B(0)
        ELSE
          CALL PUSHCONTROL1B(1)
        END IF
!STAGE 3 - Evap, Sublimation and Autoconversion
!Evaporation and sublimation of anvil cloud
        CALL PUSHREAL8(cf_con(i, j, k))
        CALL PUSHREAL8(ql_con(i, j, k))
        CALL PUSHREAL8(q(i, j, k))
        CALL PUSHREAL8(t(i, j, k))
        CALL EVAP_CNV(dt, rhcrit, ph(i, j, k), t(i, j, k), q(i, j, k), &
&               ql_con(i, j, k), qi_con(i, j, k), cf_con(i, j, k), cf_ls&
&               (i, j, k), qs(i, j, k), rho_w, cld_evp_eff, cons_h2omw, &
&               cons_airmw, cons_alhl, cons_rvap, cons_rgas, cons_pi, &
&               cons_cp)
        CALL PUSHREAL8(cf_con(i, j, k))
        CALL PUSHREAL8(qi_con(i, j, k))
        CALL PUSHREAL8(q(i, j, k))
        CALL PUSHREAL8(t(i, j, k))
        CALL SUBL_CNV(dt, rhcrit, ph(i, j, k), t(i, j, k), q(i, j, k), &
&               ql_con(i, j, k), qi_con(i, j, k), cf_con(i, j, k), cf_ls&
&               (i, j, k), qs(i, j, k), rho_w, cld_evp_eff, cons_h2omw, &
&               cons_airmw, cons_alhl, cons_rvap, cons_rgas, cons_pi, &
&               cons_cp, cons_alhs)
!Autoconversion
        CALL PUSHREAL8(cf_ls(i, j, k))
        CALL PUSHREAL8(ql_ls(i, j, k))
        CALL AUTOCONVERSION_LS(dt, ql_ls(i, j, k), qrn_ls, t(i, j, k), &
&                        ph(i, j, k), cf_ls(i, j, k), ls_sdqv2, ls_sdqv3&
&                        , ls_sdqvt1, c_00, lwcrit, dzet(i, j, k))
        CALL PUSHREAL8(ql_con(i, j, k))
        CALL AUTOCONVERSION_CNV(dt, ql_con(i, j, k), qrn_an, t(i, j, k)&
&                         , ph(i, j, k), cf_con(i, j, k), anv_sdqv2, &
&                         anv_sdqv3, anv_sdqvt1, c_00, lwcrit, dzet(i, j&
&                         , k))
!STAGE 4 - Fall and Re-evaporation of precip
        CALL PUSHREAL8(qi_con(i, j, k))
        CALL ICE_SETTLEFALL_CNV(wrhodep, qi_con(i, j, k), ph(i, j, k), t&
&                         (i, j, k), cf_con(i, j, k), cons_rgas, khu(i, &
&                         j), khl(i, j), k, dt, dzet(i, j, k), qsn_an, &
&                         anv_icefall_c)
        CALL PUSHREAL8(cf_ls(i, j, k))
        CALL PUSHREAL8(qi_ls(i, j, k))
        CALL ICE_SETTLEFALL_LS(wrhodep, qi_ls(i, j, k), ph(i, j, k), t(i&
&                        , j, k), cf_ls(i, j, k), cons_rgas, khu(i, j), &
&                        khl(i, j), k, dt, dzet(i, j, k), qsn_ls, &
&                        ls_icefall_c)
!"Freeze" out any conv. precip, not done in RAS. This is
! precip w/ large particles, so freezing is strict.
        IF (t(i, j, k) .LT. cons_tice) THEN
          qsn_cu = qrn_cu_1d
          qrn_cu_1d = 0.
          CALL PUSHREAL8(t(i, j, k))
          t(i, j, k) = t(i, j, k) + qsn_cu*(cons_alhs-cons_alhl)/cons_cp
          CALL PUSHCONTROL1B(0)
        ELSE
          CALL PUSHCONTROL1B(1)
        END IF
!Area
        CALL PUSHREAL8(area_ls_prc1)
        area_ls_prc1 = 0.0
        CALL PUSHREAL8(area_upd_prc1)
        area_upd_prc1 = 0.0
        CALL PUSHREAL8(area_anv_prc1)
        area_anv_prc1 = 0.0
        CALL PUSHREAL8(tot_prec_upd)
        tot_prec_upd = tot_prec_upd + (qrn_cu_1d+qsn_cu)*mass(i, j, k)
        CALL PUSHREAL8(area_upd_prc)
        area_upd_prc = area_upd_prc + cnv_updf(i, j, k)*(qrn_cu_1d+&
&         qsn_cu)*mass(i, j, k)
        CALL PUSHREAL8(tot_prec_anv)
        tot_prec_anv = tot_prec_anv + (qrn_an+qsn_an)*mass(i, j, k)
        CALL PUSHREAL8(area_anv_prc)
        area_anv_prc = area_anv_prc + cf_con(i, j, k)*(qrn_an+qsn_an)*&
&         mass(i, j, k)
        CALL PUSHREAL8(tot_prec_ls)
        tot_prec_ls = tot_prec_ls + (qrn_ls+qsn_ls)*mass(i, j, k)
        CALL PUSHREAL8(area_ls_prc)
        area_ls_prc = area_ls_prc + cf_ls(i, j, k)*(qrn_ls+qsn_ls)*mass(&
&         i, j, k)
        IF (tot_prec_anv .GT. 0.0) THEN
          IF (area_anv_prc/tot_prec_anv .LT. 1.e-6) THEN
            CALL PUSHCONTROL2B(2)
            area_anv_prc1 = 1.e-6
          ELSE
            area_anv_prc1 = area_anv_prc/tot_prec_anv
            CALL PUSHCONTROL2B(1)
          END IF
        ELSE
          CALL PUSHCONTROL2B(0)
        END IF
        IF (tot_prec_upd .GT. 0.0) THEN
          IF (area_upd_prc/tot_prec_upd .LT. 1.e-6) THEN
            CALL PUSHCONTROL2B(2)
            area_upd_prc1 = 1.e-6
          ELSE
            area_upd_prc1 = area_upd_prc/tot_prec_upd
            CALL PUSHCONTROL2B(1)
          END IF
        ELSE
          CALL PUSHCONTROL2B(0)
        END IF
        IF (tot_prec_ls .GT. 0.0) THEN
          IF (area_ls_prc/tot_prec_ls .LT. 1.e-6) THEN
            CALL PUSHCONTROL2B(2)
            area_ls_prc1 = 1.e-6
          ELSE
            area_ls_prc1 = area_ls_prc/tot_prec_ls
            CALL PUSHCONTROL2B(1)
          END IF
        ELSE
          CALL PUSHCONTROL2B(0)
        END IF
        area_ls_prc1 = ls_beta*area_ls_prc1
        area_upd_prc1 = cnv_beta*area_upd_prc1
        area_anv_prc1 = anv_beta*area_anv_prc1
        IF (k .EQ. lm) THEN
! We have accumulated over the whole column
          IF (tot_prec_anv .GT. 0.0) THEN
            IF (area_anv_prc/tot_prec_anv .LT. 1.e-6) THEN
              CALL PUSHREAL8(area_anv_prc)
              area_anv_prc = 1.e-6
              CALL PUSHCONTROL2B(2)
            ELSE
              CALL PUSHREAL8(area_anv_prc)
              area_anv_prc = area_anv_prc/tot_prec_anv
              CALL PUSHCONTROL2B(1)
            END IF
          ELSE
            CALL PUSHCONTROL2B(0)
          END IF
          IF (tot_prec_upd .GT. 0.0) THEN
            IF (area_upd_prc/tot_prec_upd .LT. 1.e-6) THEN
              CALL PUSHREAL8(area_upd_prc)
              area_upd_prc = 1.e-6
              CALL PUSHCONTROL2B(2)
            ELSE
              CALL PUSHREAL8(area_upd_prc)
              area_upd_prc = area_upd_prc/tot_prec_upd
              CALL PUSHCONTROL2B(1)
            END IF
          ELSE
            CALL PUSHCONTROL2B(0)
          END IF
          IF (tot_prec_ls .GT. 0.0) THEN
            IF (area_ls_prc/tot_prec_ls .LT. 1.e-6) THEN
              CALL PUSHREAL8(area_ls_prc)
              area_ls_prc = 1.e-6
              CALL PUSHCONTROL2B(2)
            ELSE
              CALL PUSHREAL8(area_ls_prc)
              area_ls_prc = area_ls_prc/tot_prec_ls
              CALL PUSHCONTROL2B(1)
            END IF
          ELSE
            CALL PUSHCONTROL2B(0)
          END IF
          CALL PUSHREAL8(area_ls_prc)
          area_ls_prc = ls_beta*area_ls_prc
          CALL PUSHREAL8(area_upd_prc)
          area_upd_prc = cnv_beta*area_upd_prc
          CALL PUSHREAL8(area_anv_prc)
          area_anv_prc = anv_beta*area_anv_prc
          CALL PUSHCONTROL1B(0)
        ELSE
          CALL PUSHCONTROL1B(1)
        END IF
!Get micro-physical constants
        CALL PUSHREAL8(alhx3)
        CALL CONS_ALHX(t(i, j, k), alhx3, t_ice_max, t_ice_all, &
&                cons_alhs, cons_alhl)
        CALL PUSHREAL8(bb)
        CALL PUSHREAL8(aa)
        CALL CONS_MICROPHYS(t(i, j, k), ph(i, j, k), qs(i, j, k), aa, bb&
&                     , cons_h2omw, cons_airmw, cons_rvap, alhx3)
!Precip Scheme Expects Total Cloud Liquid
        CALL PUSHREAL8(qlt_tmp)
        qlt_tmp = ql_ls(i, j, k) + ql_con(i, j, k)
        CALL PUSHREAL8(qit_tmp)
        qit_tmp = qi_ls(i, j, k) + qi_con(i, j, k)
        CALL PUSHREAL8(prn_above_cu_old)
        prn_above_cu_old = prn_above_cu_new
        CALL PUSHREAL8(psn_above_cu_old)
        psn_above_cu_old = psn_above_cu_new
        CALL PUSHREAL8(evap_dd_cu_above_old)
        evap_dd_cu_above_old = evap_dd_cu_above_new
        CALL PUSHREAL8(subl_dd_cu_above_old)
        subl_dd_cu_above_old = subl_dd_cu_above_new
!Precip and Evap for Convection
        CALL PUSHREAL8(q(i, j, k))
        CALL PUSHREAL8(t(i, j, k))
        CALL PUSHREAL8(qlt_tmp)
        CALL PUSHREAL8(qsn_cu)
        CALL PUSHREAL8(qrn_cu_1d)
        CALL PRECIPANDEVAP(k, ktop, lm, dt, frland(i, j), rhcrit, &
&                    qrn_cu_1d, qsn_cu, qlt_tmp, qit_tmp, t(i, j, k), q(&
&                    i, j, k), mass(i, j, k), imass(i, j, k), ph(i, j, k&
&                    ), dzet(i, j, k), qddf3(i, j, k), aa, bb, &
&                    area_upd_prc1, prn_above_cu_old, prn_above_cu_new, &
&                    psn_above_cu_old, psn_above_cu_new, &
&                    evap_dd_cu_above_old, evap_dd_cu_above_new, &
&                    subl_dd_cu_above_old, subl_dd_cu_above_new, &
&                    cnvenvfc, cnvddrfc, cons_alhf, cons_alhs, cons_alhl&
&                    , cons_cp, cons_tice, cons_h2omw, cons_airmw, &
&                    revap_off_p, c_acc, c_ev_r, c_ev_s, rho_w, estblx)
        CALL PUSHREAL8(prn_above_an_old)
        prn_above_an_old = prn_above_an_new
        CALL PUSHREAL8(psn_above_an_old)
        psn_above_an_old = psn_above_an_new
        CALL PUSHREAL8(evap_dd_an_above_old)
        evap_dd_an_above_old = evap_dd_an_above_new
        CALL PUSHREAL8(subl_dd_an_above_old)
        subl_dd_an_above_old = subl_dd_an_above_new
!Precip and Evap for Anvil
        anvenvfc = 1.0
        CALL PUSHREAL8(q(i, j, k))
        CALL PUSHREAL8(t(i, j, k))
        CALL PUSHREAL8(qlt_tmp)
        CALL PUSHREAL8(qsn_an)
        CALL PUSHREAL8(qrn_an)
        CALL PRECIPANDEVAP(k, ktop, lm, dt, frland(i, j), rhcrit, qrn_an&
&                    , qsn_an, qlt_tmp, qit_tmp, t(i, j, k), q(i, j, k)&
&                    , mass(i, j, k), imass(i, j, k), ph(i, j, k), dzet(&
&                    i, j, k), qddf3(i, j, k), aa, bb, area_anv_prc1, &
&                    prn_above_an_old, prn_above_an_new, &
&                    psn_above_an_old, psn_above_an_new, &
&                    evap_dd_an_above_old, evap_dd_an_above_new, &
&                    subl_dd_an_above_old, subl_dd_an_above_new, &
&                    anvenvfc, anvddrfc, cons_alhf, cons_alhs, cons_alhl&
&                    , cons_cp, cons_tice, cons_h2omw, cons_airmw, &
&                    revap_off_p, c_acc, c_ev_r, c_ev_s, rho_w, estblx)
        CALL PUSHREAL8(prn_above_ls_old)
        prn_above_ls_old = prn_above_ls_new
        CALL PUSHREAL8(psn_above_ls_old)
        psn_above_ls_old = psn_above_ls_new
        CALL PUSHREAL8(evap_dd_ls_above_old)
        evap_dd_ls_above_old = evap_dd_ls_above_new
        CALL PUSHREAL8(subl_dd_ls_above_old)
        subl_dd_ls_above_old = subl_dd_ls_above_new
!Precip and Evap for Large Scale
        lsenvfc = 1.0
        CALL PUSHREAL8(q(i, j, k))
        CALL PUSHREAL8(t(i, j, k))
        CALL PUSHREAL8(qlt_tmp)
        CALL PUSHREAL8(qsn_ls)
        CALL PUSHREAL8(qrn_ls)
        CALL PRECIPANDEVAP(k, ktop, lm, dt, frland(i, j), rhcrit, qrn_ls&
&                    , qsn_ls, qlt_tmp, qit_tmp, t(i, j, k), q(i, j, k)&
&                    , mass(i, j, k), imass(i, j, k), ph(i, j, k), dzet(&
&                    i, j, k), qddf3(i, j, k), aa, bb, area_ls_prc1, &
&                    prn_above_ls_old, prn_above_ls_new, &
&                    psn_above_ls_old, psn_above_ls_new, &
&                    evap_dd_ls_above_old, evap_dd_ls_above_new, &
&                    subl_dd_ls_above_old, subl_dd_ls_above_new, lsenvfc&
&                    , lsddrfc, cons_alhf, cons_alhs, cons_alhl, cons_cp&
&                    , cons_tice, cons_h2omw, cons_airmw, revap_off_p, &
&                    c_acc, c_ev_r, c_ev_s, rho_w, estblx)
        IF (ql_ls(i, j, k) + ql_con(i, j, k) .GT. 0.00) THEN
          CALL PUSHREAL8(qt_tmpi_1)
          qt_tmpi_1 = 1./(ql_ls(i, j, k)+ql_con(i, j, k))
          CALL PUSHCONTROL1B(0)
        ELSE
          CALL PUSHREAL8(qt_tmpi_1)
          qt_tmpi_1 = 0.0
          CALL PUSHCONTROL1B(1)
        END IF
        CALL PUSHREAL8(ql_ls(i, j, k))
        ql_ls(i, j, k) = ql_ls(i, j, k)*qlt_tmp*qt_tmpi_1
        CALL PUSHREAL8(ql_con(i, j, k))
        ql_con(i, j, k) = ql_con(i, j, k)*qlt_tmp*qt_tmpi_1
        IF (qi_ls(i, j, k) + qi_con(i, j, k) .GT. 0.00) THEN
          CALL PUSHREAL8(qt_tmpi_2)
          qt_tmpi_2 = 1./(qi_ls(i, j, k)+qi_con(i, j, k))
          CALL PUSHCONTROL1B(0)
        ELSE
          CALL PUSHREAL8(qt_tmpi_2)
          qt_tmpi_2 = 0.0
          CALL PUSHCONTROL1B(1)
        END IF
        CALL PUSHREAL8(qi_ls(i, j, k))
        qi_ls(i, j, k) = qi_ls(i, j, k)*qit_tmp*qt_tmpi_2
        CALL PUSHREAL8(qi_con(i, j, k))
        qi_con(i, j, k) = qi_con(i, j, k)*qit_tmp*qt_tmpi_2
      END DO
    END DO
  END DO
!Clean up of excess relative humidity
  rhexcess = 1.1
  CALL PUSHREAL8ARRAY(qs, im*jm*lm)
  CALL DQSAT_BAC(dqsdt, qs, t, ph, im, jm, lm, estblx, cons_h2omw, &
&          cons_airmw)
  mask0 = q .GT. rhexcess*qs
  WHERE (mask0) 
    dqs = (q-rhexcess*qs)/(1.0+rhexcess*dqsdt*cons_alhl/cons_cp)
  ELSEWHERE
    dqs = 0.0
  END WHERE
  CALL PUSHREAL8ARRAY(q, im*jm*lm)
  q = q - dqs
!Clean up Q<0
  DO j=1,jm
    DO i=1,im
!Total precipitable water
      CALL PUSHREAL8(tpw)
      tpw = SUM(q(i, j, :)*dm(i, j, :))
      CALL PUSHREAL8(negtpw)
      negtpw = 0.
      DO l=1,lm
        IF (q(i, j, l) .LT. 0.0) THEN
          negtpw = negtpw + q(i, j, l)*dm(i, j, l)
          q(i, j, l) = 0.0
          CALL PUSHCONTROL1B(1)
        ELSE
          CALL PUSHCONTROL1B(0)
        END IF
      END DO
      DO l=1,lm
        IF (q(i, j, l) .GE. 0.0) THEN
          CALL PUSHCONTROL1B(1)
        ELSE
          CALL PUSHCONTROL1B(0)
        END IF
      END DO
    END DO
  END DO
  tb = 0.0_8
  tb = thb/pih
  DO j=jm,1,-1
    DO i=im,1,-1
      tpwb = 0.0_8
      negtpwb = 0.0_8
      DO l=lm,1,-1
        CALL POPCONTROL1B(branch)
        IF (branch .NE. 0) THEN
          temp2 = negtpw/(tpw-negtpw)
          tempb15 = q(i, j, l)*qb(i, j, l)/(tpw-negtpw)
          tempb16 = -(temp2*tempb15)
          negtpwb = negtpwb + tempb15 - tempb16
          tpwb = tpwb + tempb16
          qb(i, j, l) = (temp2+1.0)*qb(i, j, l)
        END IF
      END DO
      DO l=lm,1,-1
        CALL POPCONTROL1B(branch)
        IF (branch .NE. 0) qb(i, j, l) = dm(i, j, l)*negtpwb
      END DO
      CALL POPREAL8(negtpw)
      CALL POPREAL8(tpw)
      qb(i, j, :) = qb(i, j, :) + dm(i, j, :)*tpwb
    END DO
  END DO
  dqsb = 0.0_8
  dqsb = cons_alhl*tb/cons_cp - qb
  CALL POPREAL8ARRAY(q, im*jm*lm)
  dqsdtb = 0.0_8
  qsb = 0.0_8
  temp1 = rhexcess*cons_alhl*dqsdt/cons_cp + 1.0
  WHERE (.NOT.mask0) 
    dqsb = 0.0_8
  ELSEWHERE
    tempb14 = dqsb/temp1
    qb = qb + tempb14
    qsb = -(rhexcess*tempb14)
    dqsdtb = -(rhexcess*cons_alhl*(q-rhexcess*qs)*tempb14/(cons_cp*temp1&
&     ))
  END WHERE
  CALL POPREAL8ARRAY(qs, im*jm*lm)
  CALL DQSAT_BAC_B(dqsdt, dqsdtb, qs, qsb, t, tb, ph, im, jm, lm, estblx&
&            , cons_h2omw, cons_airmw)
  cnv_prc3b = 0.0_8
  cnv_dqldtb = 0.0_8
  cnv_updfb = 0.0_8
  cnv_mfdb = 0.0_8
  prn_above_cu_newb = 0.0_8
  psn_above_cu_newb = 0.0_8
  evap_dd_an_above_newb = 0.0_8
  area_upd_prcb = 0.0_8
  prn_above_ls_newb = 0.0_8
  evap_dd_ls_above_newb = 0.0_8
  evap_dd_cu_above_newb = 0.0_8
  psn_above_ls_newb = 0.0_8
  tot_prec_lsb = 0.0_8
  area_ls_prcb = 0.0_8
  tot_prec_updb = 0.0_8
  prn_above_an_newb = 0.0_8
  area_anv_prcb = 0.0_8
  psn_above_an_newb = 0.0_8
  alhx3b = 0.0_8
  subl_dd_an_above_newb = 0.0_8
  qddf3b = 0.0_8
  tot_prec_anvb = 0.0_8
  dzetb = 0.0_8
  subl_dd_ls_above_newb = 0.0_8
  subl_dd_cu_above_newb = 0.0_8
  DO i=im,1,-1
    DO j=jm,1,-1
      DO k=lm,ktop,-1

        !TOTAL FILTERING
        TOTfilt_T  = 0.25

        t_p_preall = (1.0-TOTfilt_T)*tb(i,j,k)
        tb(i,j,k)  =  TOTfilt_T     *tb(i,j,k) 

        if (do_moist_physics == 1) then
           TOTfilt_ql = 0.75
           TOTfilt_qi = 1.0
        elseif (do_moist_physics == 2) then
           TOTfilt_ql = 0.5
           TOTfilt_qi = 1.0!0.5
        endif

        ql_ls_p_preall = (1.0-TOTfilt_ql)*ql_lsb(i,j,k)
        ql_lsb(i,j,k)  = TOTfilt_ql * ql_lsb(i,j,k)
        ql_con_p_preall = (1.0-TOTfilt_ql)*ql_conb(i,j,k)
        ql_conb(i,j,k) = TOTfilt_ql * ql_conb(i,j,k)

        qi_ls_p_preall = (1.0-TOTfilt_qi) * qi_lsb(i,j,k)
        qi_lsb(i,j,k)  = TOTfilt_qi * qi_lsb(i,j,k)
        qi_con_p_preall = (1.0-TOTfilt_qi) * qi_conb(i,j,k)
        qi_conb(i,j,k) = TOTfilt_qi * qi_conb(i,j,k)

        !SINK FILTERING
        if (do_moist_physics == 1) then
           SINKfilt_ql  = 0.65
           SINKfilt_qi  = 0.65
           SINKfilt_CF  = 1.0
        elseif (do_moist_physics == 2) then
           SINKfilt_ql  = 0.9
           SINKfilt_qi  = 0.9
           SINKfilt_CF  = 1.0
        endif

        qi_ls_p_presink = 0.0
        qi_con_p_presink = 0.0
        q_p_presink = 0.0
        ql_ls_p_presink = 0.0
        ql_con_p_presink = 0.0

        if (k < 50) then
            qi_ls_p_presink = (1.0-SINKfilt_qi) * qi_lsb(i,j,k)
            qi_lsb(i,j,k)  = SINKfilt_qi * qi_lsb(i,j,k)
            qi_con_p_presink = (1.0-SINKfilt_qi) * qi_conb(i,j,k)
            qi_conb(i,j,k) = SINKfilt_qi * qi_conb(i,j,k)
            q_p_presink = (1.0-SINKfilt_qi) * qb(i,j,k) 
            qb(i,j,k)      = SINKfilt_qi * qb(i,j,k)
        endif

        if ( abs(k-62) .le. 2) then
           ql_ls_p_presink = (1.0-SINKfilt_ql) * ql_lsb(i,j,k)
           ql_lsb(i,j,k)  = SINKfilt_ql * ql_lsb(i,j,k)
           ql_con_p_presink = (1.0-SINKfilt_ql) * ql_conb(i,j,k)
           ql_conb(i,j,k) = SINKfilt_ql * ql_conb(i,j,k)
        endif

        !cf_con_p_presink = (1.0-SINKfilt_CF) * cf_conb(i,j,k)
        !cf_conb(i,j,k) = SINKfilt_CF * cf_conb(i,j,k)
        cf_con_p_presink = 0.0
        cf_conb(i,j,k) = 0.0

        CALL POPREAL8(qi_con(i, j, k))
        tempb12 = qi_con(i, j, k)*qi_conb(i, j, k)
        qi_conb(i, j, k) = qit_tmp*qt_tmpi_2*qi_conb(i, j, k)
        CALL POPREAL8(qi_ls(i, j, k))
        tempb13 = qi_ls(i, j, k)*qi_lsb(i, j, k)
        qit_tmpb = qt_tmpi_2*tempb13 + qt_tmpi_2*tempb12
        qt_tmpi_2b = qit_tmp*tempb13 + qit_tmp*tempb12
        qi_lsb(i, j, k) = qit_tmp*qt_tmpi_2*qi_lsb(i, j, k)
        CALL POPCONTROL1B(branch)
        IF (branch .EQ. 0) THEN
          CALL POPREAL8(qt_tmpi_2)
          temp0 = qi_ls(i, j, k) + qi_con(i, j, k)
          tempb11 = -(qt_tmpi_2b/temp0**2)
          qi_lsb(i, j, k) = qi_lsb(i, j, k) + tempb11
          qi_conb(i, j, k) = qi_conb(i, j, k) + tempb11
        ELSE
          CALL POPREAL8(qt_tmpi_2)
        END IF
        CALL POPREAL8(ql_con(i, j, k))
        tempb9 = ql_con(i, j, k)*ql_conb(i, j, k)
        ql_conb(i, j, k) = qlt_tmp*qt_tmpi_1*ql_conb(i, j, k)
        CALL POPREAL8(ql_ls(i, j, k))
        tempb10 = ql_ls(i, j, k)*ql_lsb(i, j, k)
        qlt_tmpb = qt_tmpi_1*tempb10 + qt_tmpi_1*tempb9
        qt_tmpi_1b = qlt_tmp*tempb10 + qlt_tmp*tempb9
        ql_lsb(i, j, k) = qlt_tmp*qt_tmpi_1*ql_lsb(i, j, k)
        CALL POPCONTROL1B(branch)
        IF (branch .EQ. 0) THEN
          CALL POPREAL8(qt_tmpi_1)
          temp = ql_ls(i, j, k) + ql_con(i, j, k)
          tempb8 = -(qt_tmpi_1b/temp**2)
          ql_lsb(i, j, k) = ql_lsb(i, j, k) + tempb8
          ql_conb(i, j, k) = ql_conb(i, j, k) + tempb8
        ELSE
          CALL POPREAL8(qt_tmpi_1)
        END IF
        lsenvfc = 1.0
        CALL POPREAL8(qrn_ls)
        CALL POPREAL8(qsn_ls)
        CALL POPREAL8(qlt_tmp)
        CALL POPREAL8(t(i, j, k))
        CALL POPREAL8(q(i, j, k))
        aab = 0.0_8
        bbb = 0.0_8
        CALL PRECIPANDEVAP_B(k, ktop, lm, dt, frland(i, j), rhcrit, &
&                      qrn_ls, qrn_lsb, qsn_ls, qsn_lsb, qlt_tmp, &
&                      qlt_tmpb, qit_tmp, t(i, j, k), tb(i, j, k), q(i, &
&                      j, k), qb(i, j, k), mass(i, j, k), imass(i, j, k)&
&                      , ph(i, j, k), dzet(i, j, k), dzetb(i, j, k), &
&                      qddf3(i, j, k), qddf3b(i, j, k), aa, aab, bb, bbb&
&                      , area_ls_prc1, area_ls_prc1b, prn_above_ls_old, &
&                      prn_above_ls_oldb, prn_above_ls_new, &
&                      prn_above_ls_newb, psn_above_ls_old, &
&                      psn_above_ls_oldb, psn_above_ls_new, &
&                      psn_above_ls_newb, evap_dd_ls_above_old, &
&                      evap_dd_ls_above_oldb, evap_dd_ls_above_new, &
&                      evap_dd_ls_above_newb, subl_dd_ls_above_old, &
&                      subl_dd_ls_above_oldb, subl_dd_ls_above_new, &
&                      subl_dd_ls_above_newb, lsenvfc, lsddrfc, &
&                      cons_alhf, cons_alhs, cons_alhl, cons_cp, &
&                      cons_tice, cons_h2omw, cons_airmw, revap_off_p, &
&                      c_acc, c_ev_r, c_ev_s, rho_w, estblx)
        CALL POPREAL8(subl_dd_ls_above_old)
        subl_dd_ls_above_newb = subl_dd_ls_above_oldb
        CALL POPREAL8(evap_dd_ls_above_old)
        evap_dd_ls_above_newb = evap_dd_ls_above_oldb
        CALL POPREAL8(psn_above_ls_old)
        psn_above_ls_newb = psn_above_ls_oldb
        CALL POPREAL8(prn_above_ls_old)
        prn_above_ls_newb = prn_above_ls_oldb
        anvenvfc = 1.0
        CALL POPREAL8(qrn_an)
        CALL POPREAL8(qsn_an)
        CALL POPREAL8(qlt_tmp)
        CALL POPREAL8(t(i, j, k))
        CALL POPREAL8(q(i, j, k))
        CALL PRECIPANDEVAP_B(k, ktop, lm, dt, frland(i, j), rhcrit, &
&                      qrn_an, qrn_anb, qsn_an, qsn_anb, qlt_tmp, &
&                      qlt_tmpb, qit_tmp, t(i, j, k), tb(i, j, k), q(i, &
&                      j, k), qb(i, j, k), mass(i, j, k), imass(i, j, k)&
&                      , ph(i, j, k), dzet(i, j, k), dzetb(i, j, k), &
&                      qddf3(i, j, k), qddf3b(i, j, k), aa, aab, bb, bbb&
&                      , area_anv_prc1, area_anv_prc1b, prn_above_an_old&
&                      , prn_above_an_oldb, prn_above_an_new, &
&                      prn_above_an_newb, psn_above_an_old, &
&                      psn_above_an_oldb, psn_above_an_new, &
&                      psn_above_an_newb, evap_dd_an_above_old, &
&                      evap_dd_an_above_oldb, evap_dd_an_above_new, &
&                      evap_dd_an_above_newb, subl_dd_an_above_old, &
&                      subl_dd_an_above_oldb, subl_dd_an_above_new, &
&                      subl_dd_an_above_newb, anvenvfc, anvddrfc, &
&                      cons_alhf, cons_alhs, cons_alhl, cons_cp, &
&                      cons_tice, cons_h2omw, cons_airmw, revap_off_p, &
&                      c_acc, c_ev_r, c_ev_s, rho_w, estblx)
        CALL POPREAL8(subl_dd_an_above_old)
        subl_dd_an_above_newb = subl_dd_an_above_oldb
        CALL POPREAL8(evap_dd_an_above_old)
        evap_dd_an_above_newb = evap_dd_an_above_oldb
        CALL POPREAL8(psn_above_an_old)
        psn_above_an_newb = psn_above_an_oldb
        CALL POPREAL8(prn_above_an_old)
        prn_above_an_newb = prn_above_an_oldb
        CALL POPREAL8(qrn_cu_1d)
        CALL POPREAL8(qsn_cu)
        CALL POPREAL8(qlt_tmp)
        CALL POPREAL8(t(i, j, k))
        CALL POPREAL8(q(i, j, k))
        CALL PRECIPANDEVAP_B(k, ktop, lm, dt, frland(i, j), rhcrit, &
&                      qrn_cu_1d, qrn_cu_1db, qsn_cu, qsn_cub, qlt_tmp, &
&                      qlt_tmpb, qit_tmp, t(i, j, k), tb(i, j, k), q(i, &
&                      j, k), qb(i, j, k), mass(i, j, k), imass(i, j, k)&
&                      , ph(i, j, k), dzet(i, j, k), dzetb(i, j, k), &
&                      qddf3(i, j, k), qddf3b(i, j, k), aa, aab, bb, bbb&
&                      , area_upd_prc1, area_upd_prc1b, prn_above_cu_old&
&                      , prn_above_cu_oldb, prn_above_cu_new, &
&                      prn_above_cu_newb, psn_above_cu_old, &
&                      psn_above_cu_oldb, psn_above_cu_new, &
&                      psn_above_cu_newb, evap_dd_cu_above_old, &
&                      evap_dd_cu_above_oldb, evap_dd_cu_above_new, &
&                      evap_dd_cu_above_newb, subl_dd_cu_above_old, &
&                      subl_dd_cu_above_oldb, subl_dd_cu_above_new, &
&                      subl_dd_cu_above_newb, cnvenvfc, cnvddrfc, &
&                      cons_alhf, cons_alhs, cons_alhl, cons_cp, &
&                      cons_tice, cons_h2omw, cons_airmw, revap_off_p, &
&                      c_acc, c_ev_r, c_ev_s, rho_w, estblx)
        CALL POPREAL8(subl_dd_cu_above_old)
        subl_dd_cu_above_newb = subl_dd_cu_above_oldb
        CALL POPREAL8(evap_dd_cu_above_old)
        evap_dd_cu_above_newb = evap_dd_cu_above_oldb
        CALL POPREAL8(psn_above_cu_old)
        psn_above_cu_newb = psn_above_cu_oldb
        CALL POPREAL8(prn_above_cu_old)
        prn_above_cu_newb = prn_above_cu_oldb
        CALL POPREAL8(qit_tmp)
        qi_lsb(i, j, k) = qi_lsb(i, j, k) + qit_tmpb
        qi_conb(i, j, k) = qi_conb(i, j, k) + qit_tmpb
        CALL POPREAL8(qlt_tmp)
        ql_lsb(i, j, k) = ql_lsb(i, j, k) + qlt_tmpb
        ql_conb(i, j, k) = ql_conb(i, j, k) + qlt_tmpb
        CALL POPREAL8(aa)
        CALL POPREAL8(bb)
        CALL CONS_MICROPHYS_B(t(i, j, k), tb(i, j, k), ph(i, j, k), qs(i&
&                       , j, k), qsb(i, j, k), aa, aab, bb, bbb, &
&                       cons_h2omw, cons_airmw, cons_rvap, alhx3, alhx3b&
&                      )
        CALL POPREAL8(alhx3)
        CALL CONS_ALHX_B(t(i, j, k), tb(i, j, k), alhx3, alhx3b, &
&                  t_ice_max, t_ice_all, cons_alhs, cons_alhl)
        CALL POPCONTROL1B(branch)
        IF (branch .EQ. 0) THEN
          CALL POPREAL8(area_anv_prc)
          area_anv_prcb = anv_beta*area_anv_prcb
          CALL POPREAL8(area_upd_prc)
          area_upd_prcb = cnv_beta*area_upd_prcb
          CALL POPREAL8(area_ls_prc)
          area_ls_prcb = ls_beta*area_ls_prcb
          CALL POPCONTROL2B(branch)
          IF (branch .NE. 0) THEN
            IF (branch .EQ. 1) THEN
              CALL POPREAL8(area_ls_prc)
              tot_prec_lsb = tot_prec_lsb - area_ls_prc*area_ls_prcb/&
&               tot_prec_ls**2
              area_ls_prcb = area_ls_prcb/tot_prec_ls
            ELSE
              CALL POPREAL8(area_ls_prc)
              area_ls_prcb = 0.0_8
            END IF
          END IF
          CALL POPCONTROL2B(branch)
          IF (branch .NE. 0) THEN
            IF (branch .EQ. 1) THEN
              CALL POPREAL8(area_upd_prc)
              tot_prec_updb = tot_prec_updb - area_upd_prc*area_upd_prcb&
&               /tot_prec_upd**2
              area_upd_prcb = area_upd_prcb/tot_prec_upd
            ELSE
              CALL POPREAL8(area_upd_prc)
              area_upd_prcb = 0.0_8
            END IF
          END IF
          CALL POPCONTROL2B(branch)
          IF (branch .NE. 0) THEN
            IF (branch .EQ. 1) THEN
              CALL POPREAL8(area_anv_prc)
              tot_prec_anvb = tot_prec_anvb - area_anv_prc*area_anv_prcb&
&               /tot_prec_anv**2
              area_anv_prcb = area_anv_prcb/tot_prec_anv
            ELSE
              CALL POPREAL8(area_anv_prc)
              area_anv_prcb = 0.0_8
            END IF
          END IF
        END IF
        area_anv_prc1b = anv_beta*area_anv_prc1b
        area_upd_prc1b = cnv_beta*area_upd_prc1b
        area_ls_prc1b = ls_beta*area_ls_prc1b
        CALL POPCONTROL2B(branch)
        IF (branch .NE. 0) THEN
          IF (branch .EQ. 1) THEN
            area_ls_prcb = area_ls_prcb + area_ls_prc1b/tot_prec_ls
            tot_prec_lsb = tot_prec_lsb - area_ls_prc*area_ls_prc1b/&
&             tot_prec_ls**2
          END IF
        END IF
        CALL POPCONTROL2B(branch)
        IF (branch .NE. 0) THEN
          IF (branch .EQ. 1) THEN
            area_upd_prcb = area_upd_prcb + area_upd_prc1b/tot_prec_upd
            tot_prec_updb = tot_prec_updb - area_upd_prc*area_upd_prc1b/&
&             tot_prec_upd**2
          END IF
        END IF
        CALL POPCONTROL2B(branch)
        IF (branch .NE. 0) THEN
          IF (branch .EQ. 1) THEN
            area_anv_prcb = area_anv_prcb + area_anv_prc1b/tot_prec_anv
            tot_prec_anvb = tot_prec_anvb - area_anv_prc*area_anv_prc1b/&
&             tot_prec_anv**2
          END IF
        END IF
        tempb7 = mass(i, j, k)*tot_prec_updb
        tempb4 = mass(i, j, k)*tot_prec_anvb
        tempb1 = mass(i, j, k)*tot_prec_lsb
        CALL POPREAL8(area_ls_prc)
        tempb = mass(i, j, k)*area_ls_prcb
        tempb0 = cf_ls(i, j, k)*tempb
        cf_lsb(i, j, k) = cf_lsb(i, j, k) + (qrn_ls+qsn_ls)*tempb
        qrn_lsb = qrn_lsb + tempb1 + tempb0
        qsn_lsb = qsn_lsb + tempb1 + tempb0
        CALL POPREAL8(tot_prec_ls)
        CALL POPREAL8(area_anv_prc)
        tempb2 = mass(i, j, k)*area_anv_prcb
        tempb3 = cf_con(i, j, k)*tempb2
        cf_conb(i, j, k) = cf_conb(i, j, k) + (qrn_an+qsn_an)*tempb2
        qrn_anb = qrn_anb + tempb4 + tempb3
        qsn_anb = qsn_anb + tempb4 + tempb3
        CALL POPREAL8(tot_prec_anv)
        CALL POPREAL8(area_upd_prc)
        tempb5 = mass(i, j, k)*area_upd_prcb
        tempb6 = cnv_updf(i, j, k)*tempb5
        cnv_updfb(i, j, k) = cnv_updfb(i, j, k) + (qrn_cu_1d+qsn_cu)*&
&         tempb5
        qrn_cu_1db = qrn_cu_1db + tempb7 + tempb6
        qsn_cub = qsn_cub + tempb7 + tempb6
        CALL POPREAL8(tot_prec_upd)
        CALL POPREAL8(area_anv_prc1)
        CALL POPREAL8(area_upd_prc1)
        CALL POPREAL8(area_ls_prc1)
        CALL POPCONTROL1B(branch)
        IF (branch .EQ. 0) THEN
          CALL POPREAL8(t(i, j, k))
          qsn_cub = qsn_cub + (cons_alhs-cons_alhl)*tb(i, j, k)/cons_cp
          qrn_cu_1db = qsn_cub
        END IF
        CALL POPREAL8(qi_ls(i, j, k))
        CALL POPREAL8(cf_ls(i, j, k))
        CALL ICE_SETTLEFALL_LS_B(wrhodep, qi_ls(i, j, k), qi_lsb(i, j, k&
&                          ), ph(i, j, k), t(i, j, k), tb(i, j, k), &
&                          cf_ls(i, j, k), cf_lsb(i, j, k), cons_rgas, &
&                          khu(i, j), khl(i, j), k, dt, dzet(i, j, k), &
&                          dzetb(i, j, k), qsn_ls, qsn_lsb, ls_icefall_c&
&                         )
        CALL POPREAL8(qi_con(i, j, k))
        CALL ICE_SETTLEFALL_CNV_B(wrhodep, qi_con(i, j, k), qi_conb(i, j&
&                           , k), ph(i, j, k), t(i, j, k), tb(i, j, k), &
&                           cf_con(i, j, k), cf_conb(i, j, k), cons_rgas&
&                           , khu(i, j), khl(i, j), k, dt, dzet(i, j, k)&
&                           , dzetb(i, j, k), qsn_an, qsn_anb, &
&                           anv_icefall_c)
        CALL POPREAL8(ql_con(i, j, k))
        CALL AUTOCONVERSION_CNV_B(dt, ql_con(i, j, k), ql_conb(i, j, k)&
&                           , qrn_an, qrn_anb, t(i, j, k), tb(i, j, k), &
&                           ph(i, j, k), cf_con(i, j, k), cf_conb(i, j, &
&                           k), anv_sdqv2, anv_sdqv3, anv_sdqvt1, c_00, &
&                           lwcrit, dzet(i, j, k))
        CALL POPREAL8(ql_ls(i, j, k))
        CALL POPREAL8(cf_ls(i, j, k))
        CALL AUTOCONVERSION_LS_B(dt, ql_ls(i, j, k), ql_lsb(i, j, k), &
&                          qrn_ls, qrn_lsb, t(i, j, k), tb(i, j, k), ph(&
&                          i, j, k), cf_ls(i, j, k), cf_lsb(i, j, k), &
&                          ls_sdqv2, ls_sdqv3, ls_sdqvt1, c_00, lwcrit, &
&                          dzet(i, j, k))
        CALL POPREAL8(t(i, j, k))
        CALL POPREAL8(q(i, j, k))
        CALL POPREAL8(qi_con(i, j, k))
        CALL POPREAL8(cf_con(i, j, k))
        CALL SUBL_CNV_B(dt, rhcrit, ph(i, j, k), t(i, j, k), tb(i, j, k)&
&                 , q(i, j, k), qb(i, j, k), ql_con(i, j, k), ql_conb(i&
&                 , j, k), qi_con(i, j, k), qi_conb(i, j, k), cf_con(i, &
&                 j, k), cf_conb(i, j, k), cf_ls(i, j, k), qs(i, j, k), &
&                 qsb(i, j, k), rho_w, cld_evp_eff, cons_h2omw, &
&                 cons_airmw, cons_alhl, cons_rvap, cons_rgas, cons_pi, &
&                 cons_cp, cons_alhs)
        CALL POPREAL8(t(i, j, k))
        CALL POPREAL8(q(i, j, k))
        CALL POPREAL8(ql_con(i, j, k))
        CALL POPREAL8(cf_con(i, j, k))
        CALL EVAP_CNV_B(dt, rhcrit, ph(i, j, k), t(i, j, k), tb(i, j, k)&
&                 , q(i, j, k), qb(i, j, k), ql_con(i, j, k), ql_conb(i&
&                 , j, k), qi_con(i, j, k), qi_conb(i, j, k), cf_con(i, &
&                 j, k), cf_conb(i, j, k), cf_ls(i, j, k), qs(i, j, k), &
&                 qsb(i, j, k), rho_w, cld_evp_eff, cons_h2omw, &
&                 cons_airmw, cons_alhl, cons_rvap, cons_rgas, cons_pi, &
&                 cons_cp)
        CALL POPCONTROL1B(branch)
        IF (branch .EQ. 0) THEN
          CALL POPREAL8(cf_con(i, j, k))
          CALL POPREAL8(cf_ls(i, j, k))
          cf_totb = -(cf_ls(i, j, k)*cf_lsb(i, j, k)/cf_tot**2) - cf_con&
&           (i, j, k)*cf_conb(i, j, k)/cf_tot**2
          cf_conb(i, j, k) = cf_conb(i, j, k)/cf_tot
          cf_lsb(i, j, k) = cf_lsb(i, j, k)/cf_tot
        ELSE
          cf_totb = 0.0_8
        END IF
        CALL POPREAL8(cf_tot)
        cf_lsb(i, j, k) = cf_lsb(i, j, k) + cf_totb
        cf_conb(i, j, k) = cf_conb(i, j, k) + cf_totb

        !ADJOINT OF SAVE PRESINKS INPUTS
        qb(i,j,k)      = qb(i,j,k)      + q_p_presink
        qi_lsb(i,j,k)  = qi_lsb(i,j,k)  + qi_ls_p_presink
        qi_conb(i,j,k) = qi_conb(i,j,k) + qi_con_p_presink
        ql_lsb(i,j,k)  = ql_lsb(i,j,k)  + ql_ls_p_presink
        ql_conb(i,j,k) = ql_conb(i,j,k) + ql_con_p_presink
        cf_conb(i,j,k) = cf_conb(i,j,k) + cf_con_p_presink

        CALL POPREAL8(t(i, j, k))
        CALL POPREAL8(q(i, j, k))
        CALL POPREAL8(ql_ls(i, j, k))
        CALL POPREAL8(ql_con(i, j, k))
        CALL POPREAL8(qi_ls(i, j, k))
        CALL POPREAL8(qi_con(i, j, k))
        CALL POPREAL8(cf_ls(i, j, k))
        CALL POPREAL8(cf_con(i, j, k))

        if (do_moist_physics == 1) then

           !For data assimilation purposes always employ the perturbation model for cloud fraction
           cloud_pertmod = 1

        elseif (do_moist_physics == 2) then

           !For longer forecasts only employ perturabtion model if filtering deems necessary
           cloud_pertmod = 0

           !COMPUTE THE JACOBIAN OF LS_CLOUD AND USE RESULTS TO FILTER 'BAD' POINTS 
           Jacobian = 0.0
           DO ii = 1,8
              xx = 0.0
              xx(ii) = 1.0

              !Store seperate trajectory so as not to overwrite
              ttraj      = t(i,j,k)
              qtraj      = q(i,j,k)
              qi_lstraj  = qi_ls(i,j,k)
              qi_contraj = qi_con(i,j,k)
              ql_lstraj  = ql_ls(i,j,k)
              ql_contraj = ql_con(i,j,k)
              cf_lstraj  = cf_ls(i,j,k)
              cf_contraj = cf_con(i,j,k)
              phtraj     = ph(i,j,k)

              tpert      = xx(1)
              qpert      = xx(2)
              qi_lspert  = xx(3)
              qi_conpert = xx(4)
              ql_lspert  = xx(5)
              ql_conpert = xx(6)
              cf_lspert  = xx(7)
              cf_conpert = xx(8)

              CALL LS_CLOUD_D(dt, alpha, pdfflag, phtraj, ttraj, tpert, qtraj, qpert, &
                              ql_lstraj, ql_lspert, ql_contraj, ql_conpert, &
                              qi_lstraj, qi_lspert, qi_contraj, qi_conpert, &
                              cf_lstraj, cf_lspert, cf_contraj, cf_conpert, &
                              cons_alhl, cons_alhf, cons_alhs, cons_cp, cons_h2omw, cons_airmw, &
                              t_ice_all, t_ice_max, icefrpwr, estblx, 0, do_moist_physics)

              Jacobian(1,ii) = tpert
              Jacobian(2,ii) = qpert
              Jacobian(3,ii) = qi_lspert
              Jacobian(4,ii) = qi_conpert
              Jacobian(5,ii) = ql_lspert
              Jacobian(6,ii) = ql_conpert
              Jacobian(7,ii) = cf_lspert
              Jacobian(8,ii) = cf_conpert

           endDO

           !Compute eigenvalues of the Jacobian
           A = JACOBIAN

           LWORK = -1
           work = 0.0
           info = 0

           CALL DGEEV( 'N', 'N', N1, A, LDA, WR, WI, VL, LDVL, VR, LDVR, WORK, LWORK, INFO )

           LWORK = MIN( LWMAX, INT( WORK( 1 ) ) )
           CALL DGEEV( 'N', 'N', N1, A, LDA, WR, WI, VL, LDVL, VR, LDVR, WORK, LWORK, INFO )

           maxeval = maxval(abs(WR))

           !Filter based on the eigenvalues
           if (maxeval > 1.001) then
              cloud_pertmod = 1
           endif

           !Filter based on the Jacobian values
           if ( ( Jacobian(1,1) <  0.6     )   .or. &
                ( Jacobian(2,1) >  0.75e-4 )   .or. &
                ( Jacobian(5,1) < -0.75e-4 )   .or. &
                ( Jacobian(7,1) < -1.10    ) ) then
              cloud_pertmod = 1
           endif

        endif

        CALL LS_CLOUD_B(dt, alpha, pdfflag, ph(i, j, k), t(i, j, k), tb(&
&                 i, j, k), q(i, j, k), qb(i, j, k), ql_ls(i, j, k), &
&                 ql_lsb(i, j, k), ql_con(i, j, k), ql_conb(i, j, k), &
&                 qi_ls(i, j, k), qi_lsb(i, j, k), qi_con(i, j, k), &
&                 qi_conb(i, j, k), cf_ls(i, j, k), cf_lsb(i, j, k), &
&                 cf_con(i, j, k), cf_conb(i, j, k), cons_alhl, &
&                 cons_alhf, cons_alhs, cons_cp, cons_h2omw, cons_airmw&
&                 , t_ice_all, t_ice_max, icefrpwr, estblx, &
&                 cloud_pertmod, do_moist_physics)

        CALL POPREAL8(rhcrit)
        CALL POPREAL8(alpha)
        CALL POPREAL8(t(i, j, k))
        CALL POPREAL8(q(i, j, k))
        CALL POPREAL8(ql_con(i, j, k))
        CALL POPREAL8(qi_con(i, j, k))
        CALL POPREAL8(cf_con(i, j, k))
        CALL CONVEC_SRC_B(dt, mass(i, j, k), imass(i, j, k), t(i, j, k)&
&                   , tb(i, j, k), q(i, j, k), qb(i, j, k), cnv_dqldt(i&
&                   , j, k), cnv_dqldtb(i, j, k), cnv_mfd(i, j, k), &
&                   cnv_mfdb(i, j, k), ql_con(i, j, k), ql_conb(i, j, k)&
&                   , qi_con(i, j, k), qi_conb(i, j, k), cf_con(i, j, k)&
&                   , cf_conb(i, j, k), qs(i, j, k), qsb(i, j, k), &
&                   cons_alhs, cons_alhl, cons_cp, t_ice_all, t_ice_max&
&                   , icefrpwr)
        CALL POPREAL8(t(i, j, k))
        CALL POPREAL8(ql_con(i, j, k))
        CALL POPREAL8(qi_con(i, j, k))
        CALL MELTFREEZE_B(dt, t(i, j, k), tb(i, j, k), ql_con(i, j, k), &
&                   ql_conb(i, j, k), qi_con(i, j, k), qi_conb(i, j, k)&
&                   , t_ice_all, t_ice_max, icefrpwr, cons_alhl, &
&                   cons_alhs, cons_cp)
        CALL POPREAL8(t(i, j, k))
        CALL POPREAL8(ql_ls(i, j, k))
        CALL POPREAL8(qi_ls(i, j, k))
        CALL MELTFREEZE_B(dt, t(i, j, k), tb(i, j, k), ql_ls(i, j, k), &
&                   ql_lsb(i, j, k), qi_ls(i, j, k), qi_lsb(i, j, k), &
&                   t_ice_all, t_ice_max, icefrpwr, cons_alhl, cons_alhs&
&                   , cons_cp)
        CALL POPREAL8(t(i, j, k))
        CALL POPREAL8(ql_ls(i, j, k))
        CALL POPREAL8(qi_ls(i, j, k))
        CALL POPREAL8(cf_ls(i, j, k))
        CALL POPREAL8(ql_con(i, j, k))
        CALL POPREAL8(qi_con(i, j, k))
        CALL POPREAL8(cf_con(i, j, k))
        CALL CLOUD_TIDY_B(q(i, j, k), qb(i, j, k), t(i, j, k), tb(i, j, &
&                   k), ql_ls(i, j, k), ql_lsb(i, j, k), qi_ls(i, j, k)&
&                   , qi_lsb(i, j, k), cf_ls(i, j, k), cf_lsb(i, j, k), &
&                   ql_con(i, j, k), ql_conb(i, j, k), qi_con(i, j, k), &
&                   qi_conb(i, j, k), cf_con(i, j, k), cf_conb(i, j, k)&
&                   , cons_alhl, cons_alhs, cons_cp)
        cnv_prc3b(i, j, k) = cnv_prc3b(i, j, k) + qrn_cu_1db
        CALL POPCONTROL1B(branch)
        IF (branch .NE. 0) THEN
          CALL POPREAL8(area_ls_prc)
          CALL POPREAL8(area_anv_prc)
          CALL POPREAL8(area_upd_prc)
          CALL POPREAL8(tot_prec_ls)
          CALL POPREAL8(tot_prec_anv)
          CALL POPREAL8(tot_prec_upd)
          area_upd_prcb = 0.0_8
          tot_prec_lsb = 0.0_8
          area_ls_prcb = 0.0_8
          tot_prec_updb = 0.0_8
          area_anv_prcb = 0.0_8
          tot_prec_anvb = 0.0_8
        END IF

        !Adjoint save the inputs to the scheme for filtering
        tb(i, j, k)      = tb(i, j, k)      + t_p_preall
        ql_lsb(i, j, k)  = ql_lsb(i, j, k)  + ql_ls_p_preall
        ql_conb(i, j, k) = ql_conb(i, j, k) + ql_con_p_preall
        qi_lsb(i, j, k)  = qi_lsb(i, j, k)  + qi_ls_p_preall
        qi_conb(i, j, k) = qi_conb(i, j, k) + qi_con_p_preall

      END DO
    END DO
  END DO
  vmipb = 0.0_8
  DO k=lm,1,-1
    CALL POPREAL8ARRAY(qddf3(:, :, k), im*jm)
    vmipb = vmipb - qddf3(:, :, k)*qddf3b(:, :, k)/vmip**2
    qddf3b(:, :, k) = qddf3b(:, :, k)/vmip
  END DO
  DO i=im,1,-1
    DO j=jm,1,-1
      qddf3b(i, j, :) = qddf3b(i, j, :) + vmipb(i, j)
      vmipb(i, j) = 0.0_8
    END DO
  END DO
  WHERE (.NOT.mask(:, :, 1:lm)) qddf3b = 0.0_8
  zetb = 0.0_8
  WHERE (mask(:, :, 1:lm)) zetb(:, :, 1:lm) = zetb(:, :, 1:lm) - (zet(:&
&     , :, 1:lm)-3000.)*mass*qddf3b - zet(:, :, 1:lm)*mass*qddf3b
  DO k=1,lm,1
    zetb(:, :, k+1) = zetb(:, :, k+1) + zetb(:, :, k)
    dzetb(:, :, k) = dzetb(:, :, k) + zetb(:, :, k)
    zetb(:, :, k) = 0.0_8
  END DO
  CALL DQSAT_BAC_B(dqsdt, dqsdtb, qs, qsb, t, tb, ph, im, jm, lm, estblx&
&            , cons_h2omw, cons_airmw)
  thb = 0.0_8
  thb(:, :, 1:lm) = pih*tb + (pi(:, :, 1:lm)-pi(:, :, 0:lm-1))*cons_cp*&
&   dzetb(:, :, 1:lm)/cons_grav
END SUBROUTINE CLOUD_DRIVER_B

!  Differentiation of cloud_tidy in reverse (adjoint) mode:
!   gradient     of useful results: af qv qla qlc qia qic cf te
!   with respect to varying inputs: af qv qla qlc qia qic cf te
!SUBROUTINES
SUBROUTINE CLOUD_TIDY_B(qv, qvb, te, teb, qlc, qlcb, qic, qicb, cf, cfb&
& , qla, qlab, qia, qiab, af, afb, cons_alhl, cons_alhs, cons_cp)
  IMPLICIT NONE
  REAL*8, INTENT(INOUT) :: te, qv, qlc, cf, qla, af, qic, qia
  REAL*8 :: teb, qvb, qlcb, cfb, qlab, afb, qicb, qiab
  REAL*8, INTENT(IN) :: cons_alhl, cons_alhs, cons_cp
  INTEGER :: branch
!Fix if Anvil cloud fraction too small
  IF (af .LT. 1.e-5) THEN
    CALL PUSHREAL8(qla)
    qla = 0.
    CALL PUSHREAL8(qia)
    qia = 0.
    CALL PUSHCONTROL1B(0)
  ELSE
    CALL PUSHCONTROL1B(1)
  END IF
!Fix if LS cloud fraction too small
! if ( CF < 1.E-5 ) then
!         QV = QV + QLC + QIC
!         TE = TE - (CONS_ALHL/CONS_CP)*QLC - (CONS_ALHS/CONS_CP)*QIC
!         CF  = 0.
!         QLC = 0.
!         QIC = 0.
! end if
!LS LIQUID too small
  IF (qlc .LT. 1.e-8) THEN
    CALL PUSHREAL8(qlc)
    qlc = 0.
    CALL PUSHCONTROL1B(0)
  ELSE
    CALL PUSHCONTROL1B(1)
  END IF
!LS ICE too small
  IF (qic .LT. 1.e-8) THEN
    CALL PUSHREAL8(qic)
    qic = 0.
    CALL PUSHCONTROL1B(0)
  ELSE
    CALL PUSHCONTROL1B(1)
  END IF
!Anvil LIQUID too small
  IF (qla .LT. 1.e-8) THEN
    CALL PUSHREAL8(qla)
    qla = 0.
    CALL PUSHCONTROL1B(0)
  ELSE
    CALL PUSHCONTROL1B(1)
  END IF
!Anvil ICE too small
  IF (qia .LT. 1.e-8) THEN
    CALL PUSHREAL8(qia)
    qia = 0.
    CALL PUSHCONTROL1B(0)
  ELSE
    CALL PUSHCONTROL1B(1)
  END IF
!Fix ALL cloud quants if Anvil cloud LIQUID+ICE too small
  IF (qla + qia .LT. 1.e-8) THEN
    CALL PUSHCONTROL1B(0)
  ELSE
    CALL PUSHCONTROL1B(1)
  END IF
!Ditto if LS cloud LIQUID+ICE too small
  IF (qlc + qic .LT. 1.e-8) THEN
    qlcb = qvb - cons_alhl*teb/cons_cp
    qicb = qvb - cons_alhs*teb/cons_cp
    cfb = 0.0_8
  END IF
  CALL POPCONTROL1B(branch)
  IF (branch .EQ. 0) THEN
    qlab = qvb - cons_alhl*teb/cons_cp
    qiab = qvb - cons_alhs*teb/cons_cp
    afb = 0.0_8
  END IF
  CALL POPCONTROL1B(branch)
  IF (branch .EQ. 0) THEN
    CALL POPREAL8(qia)
    qiab = qvb - cons_alhs*teb/cons_cp
  END IF
  CALL POPCONTROL1B(branch)
  IF (branch .EQ. 0) THEN
    CALL POPREAL8(qla)
    qlab = qvb - cons_alhl*teb/cons_cp
  END IF
  CALL POPCONTROL1B(branch)
  IF (branch .EQ. 0) THEN
    CALL POPREAL8(qic)
    qicb = qvb - cons_alhs*teb/cons_cp
  END IF
  CALL POPCONTROL1B(branch)
  IF (branch .EQ. 0) THEN
    CALL POPREAL8(qlc)
    qlcb = qvb - cons_alhl*teb/cons_cp
  END IF
  CALL POPCONTROL1B(branch)
  IF (branch .EQ. 0) THEN
    CALL POPREAL8(qia)
    CALL POPREAL8(qla)
    qlab = qvb - cons_alhl*teb/cons_cp
    qiab = qvb - cons_alhs*teb/cons_cp
    afb = 0.0_8
  END IF
END SUBROUTINE CLOUD_TIDY_B

!  Differentiation of meltfreeze in reverse (adjoint) mode:
!   gradient     of useful results: qi ql te
!   with respect to varying inputs: qi ql te
SUBROUTINE MELTFREEZE_B(dt, te, teb, ql, qlb, qi, qib, t_ice_all, &
& t_ice_max, icefrpwr, cons_alhl, cons_alhs, cons_cp)
  IMPLICIT NONE
!Inputs
  REAL*8, INTENT(IN) :: dt, t_ice_all, t_ice_max
  INTEGER, INTENT(IN) :: icefrpwr
  REAL*8, INTENT(IN) :: cons_alhl, cons_alhs, cons_cp
!Prognostic
  REAL*8, INTENT(INOUT) :: te, ql, qi
  REAL*8 :: teb, qlb, qib
!Locals
  REAL*8 :: fqi, dqil
  REAL*8 :: fqib, dqilb
  REAL*8, PARAMETER :: taufrz=1000.
  INTRINSIC EXP
  INTRINSIC MAX
  INTRINSIC MIN
  INTEGER :: branch
  REAL*8 :: temp
  dqil = 0.0
  CALL GET_ICE_FRACTION(te, t_ice_all, t_ice_max, icefrpwr, fqi)
!Freeze liquid
  IF (te .LE. t_ice_max) THEN
    dqil = ql*(1.0-EXP(-(dt*fqi/taufrz)))
    CALL PUSHCONTROL1B(1)
  ELSE
    CALL PUSHCONTROL1B(0)
  END IF
  IF (0. .LT. dqil) THEN
    CALL PUSHCONTROL1B(0)
    dqil = dqil
  ELSE
    dqil = 0.
    CALL PUSHCONTROL1B(1)
  END IF
  CALL PUSHREAL8(qi)
  qi = qi + dqil
  CALL PUSHREAL8(te)
  te = te + (cons_alhs-cons_alhl)*dqil/cons_cp
  dqil = 0.
!Melt ice instantly above 0^C
  IF (te .GT. t_ice_max) THEN
    dqil = -qi
    CALL PUSHCONTROL1B(1)
  ELSE
    CALL PUSHCONTROL1B(0)
  END IF
  IF (0. .GT. dqil) THEN
    CALL PUSHCONTROL1B(0)
  ELSE
    CALL PUSHCONTROL1B(1)
  END IF
  dqilb = qib - qlb + (cons_alhs-cons_alhl)*teb/cons_cp
  CALL POPCONTROL1B(branch)
  IF (branch .NE. 0) dqilb = 0.0_8
  CALL POPCONTROL1B(branch)
  IF (branch .NE. 0) qib = qib - dqilb
  CALL POPREAL8(te)
  dqilb = qib - qlb + (cons_alhs-cons_alhl)*teb/cons_cp
  CALL POPREAL8(qi)
  CALL POPCONTROL1B(branch)
  IF (branch .NE. 0) dqilb = 0.0_8
  CALL POPCONTROL1B(branch)
  IF (branch .EQ. 0) THEN
    fqib = 0.0_8
  ELSE
    temp = -(dt*fqi/taufrz)
    qlb = qlb + (1.0-EXP(temp))*dqilb
    fqib = dt*EXP(temp)*ql*dqilb/taufrz
  END IF
  CALL GET_ICE_FRACTION_B(te, teb, t_ice_all, t_ice_max, icefrpwr, fqi, &
&                   fqib)
END SUBROUTINE MELTFREEZE_B

!  Differentiation of convec_src in reverse (adjoint) mode:
!   gradient     of useful results: af qs qv qla qia dcf dmf te
!   with respect to varying inputs: af qs qv qla qia dcf dmf te
SUBROUTINE CONVEC_SRC_B(dt, mass, imass, te, teb, qv, qvb, dcf, dcfb, &
& dmf, dmfb, qla, qlab, qia, qiab, af, afb, qs, qsb, cons_alhs, &
& cons_alhl, cons_cp, t_ice_all, t_ice_max, icefrpwr)
  IMPLICIT NONE
!Inputs
  REAL*8, INTENT(IN) :: dt, t_ice_all, t_ice_max
  INTEGER, INTENT(IN) :: icefrpwr
  REAL*8, INTENT(IN) :: mass, imass, qs
  REAL*8 :: qsb
  REAL*8, INTENT(IN) :: dmf, dcf
  REAL*8 :: dmfb, dcfb
  REAL*8, INTENT(IN) :: cons_alhs, cons_alhl, cons_cp
!Prognostic
  REAL*8, INTENT(INOUT) :: te, qv
  REAL*8 :: teb, qvb
  REAL*8, INTENT(INOUT) :: qla, qia, af
  REAL*8 :: qlab, qiab, afb
!Locals
!Minimum allowed env RH
  REAL*8, PARAMETER :: minrhx=0.001
  REAL*8 :: tend, qvx, fqi
  REAL*8 :: tendb, fqib
  INTRINSIC MIN
  INTEGER :: branch
  REAL*8 :: tempb0
  REAL*8 :: tempb
!Namelist
!DT         - Timestep
!MASS       - Level Mass
!iMASS      - 1/Level Mass
!TE         - Temperature
!QV         - Specific Humidity
!DCF        - CNV_DQL from RAS
!DMF        - CNV_MFD from RAS
!QLA        - Convective cloud liquid water
!QIA        - Convective cloud liquid ice
!AF         - Convective cloud fraction
!QS         - Qsat
!Zero out locals
!Addition of condensate from RAS
  CALL GET_ICE_FRACTION(te, t_ice_all, t_ice_max, icefrpwr, fqi)
!Convective condensation has never frozen so latent heat of fusion
!Compute Tiedtke-style anvil fraction
  tend = dmf*imass
  CALL PUSHREAL8(af)
  af = af + tend*dt
  IF (af .GT. 0.99) THEN
    af = 0.99
    CALL PUSHCONTROL1B(0)
  ELSE
    CALL PUSHCONTROL1B(1)
    af = af
  END IF
! Check for funny (tiny, negative) external QV, resulting from assumed QV=QSAT within anvil.
! Simply constrain AF assume condensate just gets "packed" in     
  IF (af .LT. 1.0) THEN
    qvx = (qv-qs*af)/(1.-af)
  ELSE
    qvx = qs
  END IF
!If saturated over critial value and there is Anvil
  IF (qvx - minrhx*qs .LT. 0.0 .AND. af .GT. 0.) THEN
    af = (qv-minrhx*qs)/(qs*(1.0-minrhx))
    CALL PUSHCONTROL1B(0)
  ELSE
    CALL PUSHCONTROL1B(1)
  END IF
  IF (af .LT. 0.) THEN
    qlab = qvb - cons_alhl*teb/cons_cp
    qiab = qvb - cons_alhs*teb/cons_cp
    afb = 0.0_8
  END IF
  CALL POPCONTROL1B(branch)
  IF (branch .EQ. 0) THEN
    tempb0 = afb/((1.0-minrhx)*qs)
    qvb = qvb + tempb0
    qsb = qsb + (-((qv-minrhx*qs)/qs)-minrhx)*tempb0
    afb = 0.0_8
  END IF
  CALL POPCONTROL1B(branch)
  IF (branch .EQ. 0) afb = 0.0_8
  CALL POPREAL8(af)
  tendb = dt*afb
  dmfb = dmfb + imass*tendb
  tend = dcf*imass
  tempb = (cons_alhs-cons_alhl)*dt*teb/cons_cp
  fqib = dt*tend*qiab - tend*dt*qlab + tend*tempb
  tendb = dt*fqi*qiab + dt*(1.0-fqi)*qlab + fqi*tempb
  CALL GET_ICE_FRACTION_B(te, teb, t_ice_all, t_ice_max, icefrpwr, fqi, &
&                   fqib)
  dcfb = dcfb + imass*tendb
END SUBROUTINE CONVEC_SRC_B

!  Differentiation of ls_cloud in reverse (adjoint) mode:
!   gradient     of useful results: qai qal af qv qci qcl cf te
!   with respect to varying inputs: qai qal af qv qci qcl cf te
SUBROUTINE LS_CLOUD_B(dt, alpha, pdfshape, pl, te, teb, qv, qvb, qcl, &
& qclb, qal, qalb, qci, qcib, qai, qaib, cf, cfb, af, afb, cons_alhl, &
& cons_alhf, cons_alhs, cons_cp, cons_h2omw, cons_airmw, t_ice_all, &
& t_ice_max, icefrpwr, estblx, cloud_pertmod, dmp)
  IMPLICIT NONE
!Inputs
  REAL*8, INTENT(IN) :: dt, alpha, pl, t_ice_all, t_ice_max
  INTEGER, INTENT(IN) :: pdfshape, cloud_pertmod, dmp
  INTEGER, INTENT(IN) :: icefrpwr
  REAL*8, INTENT(IN) :: cons_alhl, cons_alhf, cons_alhs, cons_cp, &
& cons_h2omw, cons_airmw
  REAL*8, INTENT(IN) :: estblx(:)
!Prognostic
  REAL*8, INTENT(INOUT) :: te, qv, qcl, qci, qal, qai, cf, af
  REAL*8 :: teb, qvb, qclb, qcib, qalb, qaib, cfb, afb
!Locals
  INTEGER :: n
  REAL*8 :: qco, cfo, qao, qt, qmx, qmn, dq
  REAL*8 :: qcob, cfob, qaob, qtb
  REAL*8 :: teo, qsx, dqsx, qs, dqs, tmparr
  REAL*8 :: teob, qsxb, dqsxb, dqsb, tmparrb
  REAL*8 :: qcx, qvx, cfx, qax, qc, qa, fqi, fqi_a, dqai, dqal, dqci, &
& dqcl
  REAL*8 :: qcxb, qvxb, cfxb, qaxb, qcb, qab, fqib, dqaib, dqalb, dqcib&
& , dqclb
  REAL*8 :: ten, qsp, cfp, qvp, qcp
  REAL*8 :: tenb, qcpb
  REAL*8 :: tep, qsn, cfn, qvn, qcn
  REAL*8 :: tepb, qsnb, cfnb, qcnb
  REAL*8 :: alhx, sigmaqt1, sigmaqt2
  REAL*8 :: alhxb, sigmaqt1b, sigmaqt2b
  REAL*8, DIMENSION(1) :: dqsx1, qsx1, teo1, pl1
  INTRINSIC MAX
  INTEGER :: branch
  REAL*8 :: temp1
  REAL*8 :: temp0
  REAL*8 :: tempb5
  REAL*8 :: tempb4
  REAL*8 :: tempb3
  REAL*8 :: tempb2
  REAL*8 :: tempb1
  REAL*8 :: tempb0
  REAL*8 :: tempb
  REAL*8 :: temp
!Namelist
!DT      - Timestep 
!ALPHA   - PDF half width
!PL      - Pressure (hPa)
!TE      - Temperature
!QV      - Specific humidity
!QCl     - Convective cloud liquid water
!QAl     - Large scale cloud liquid water
!QCi     - Convective cloud liquid ice
!QAi     - Large scale cloud liquid ice
!CF      - Large scale cloud fraction
!AF      - Convective cloud fraction
  qc = qcl + qci
  qa = qal + qai
  teo = te
  CALL DQSATS_BAC(dqsx, qsx, teo, pl, estblx, cons_h2omw, cons_airmw)
  IF (af .LT. 1.0) THEN
    IF (dmp .EQ. 1) THEN
      IF (1. - af .GT. 0.02) THEN
        tmparr = 1./(1.-af)
        CALL PUSHCONTROL3B(0)
      ELSE
        tmparr = 1./(1.-af)
        CALL PUSHCONTROL3B(1)
      END IF
    ELSE IF (dmp .EQ. 2) THEN
      tmparr = 1./(1.-af)
      CALL PUSHCONTROL3B(2)
    ELSE
      CALL PUSHCONTROL3B(3)
    END IF
  ELSE
    CALL PUSHCONTROL3B(4)
    tmparr = 0.0
  END IF
  cfx = cf*tmparr
  qcx = qc*tmparr
  qvx = (qv-qsx*af)*tmparr
  IF (af .GE. 1.0) THEN
    qvx = qsx*1.e-4
    CALL PUSHCONTROL1B(0)
  ELSE
    CALL PUSHCONTROL1B(1)
  END IF
  IF (af .GT. 0.) THEN
    qax = qa/af
    CALL PUSHCONTROL1B(0)
  ELSE
    CALL PUSHCONTROL1B(1)
    qax = 0.
  END IF
  qt = qcx + qvx
  ten = teo
  cfn = cfx
  qcn = qcx
!Begin iteration
!do n=1,4
  n = 1
  qcp = qcn
!Dont call again as not looping
  dqs = dqsx
  qsn = qsx
!call DQSATs_BAC(DQS, QSn, TEn, PL, ESTBLX, CONS_H2OMW, CONS_AIRMW)
  tep = ten
  CALL GET_ICE_FRACTION(tep, t_ice_all, t_ice_max, icefrpwr, fqi)
  sigmaqt1 = alpha*qsn
  sigmaqt2 = alpha*qsn
  IF (pdfshape .EQ. 2) THEN
!For triangular, symmetric: sigmaqt1 = sigmaqt2 = alpha*qsn (alpha is half width)
!For triangular, skewed r : sigmaqt1 < sigmaqt2
    sigmaqt1 = alpha*qsn
    sigmaqt2 = alpha*qsn
    CALL PUSHCONTROL1B(0)
  ELSE
    CALL PUSHCONTROL1B(1)
  END IF
!Compute cloud fraction
  IF (cloud_pertmod .EQ. 0) THEN
    CALL PDFFRAC(1, qt, sigmaqt1, sigmaqt2, qsn, cfn)
    CALL PUSHCONTROL2B(0)
  ELSE IF (cloud_pertmod .EQ. 1) THEN
    CALL PDFFRAC(4, qt, sigmaqt1, sigmaqt2, qsn, cfn)
    CALL PUSHCONTROL2B(1)
  ELSE
    CALL PUSHCONTROL2B(2)
  END IF
!Compute cloud condensate
  CALL PDFCONDENSATE(pdfshape, qt, sigmaqt1, sigmaqt2, qsn, qcn)
!Adjustments to anvil condensate due to the assumption of a stationary TOTAL 
!water PDF subject to a varying QSAT value during the iteration
  IF (af .GT. 0.) THEN
! + QSx - QS 
    qao = qax
    CALL PUSHCONTROL1B(0)
  ELSE
    qao = 0.
    CALL PUSHCONTROL1B(1)
  END IF
  alhx = (1.0-fqi)*cons_alhl + fqi*cons_alhs
  IF (pdfshape .EQ. 1) THEN
    CALL PUSHREAL8(qcn)
    qcn = qcp + (qcn-qcp)/(1.-(cfn*(alpha-1.)-qcn/qsn)*dqs*alhx/cons_cp)
    CALL PUSHCONTROL2B(0)
  ELSE IF (pdfshape .EQ. 2) THEN
!This next line needs correcting - need proper d(del qc)/dT derivative for triangular
!for now, just use relaxation of 1/2.
    IF (n .NE. 4) THEN
      qcn = qcp + (qcn-qcp)*0.5
      CALL PUSHCONTROL2B(1)
    ELSE
      CALL PUSHCONTROL2B(2)
    END IF
  ELSE
    CALL PUSHCONTROL2B(3)
  END IF
!enddo ! qsat iteration
  cfo = cfn
  qco = qcn
! Update prognostic variables. QCo, QAo become updated grid means.
  IF (af .LT. 1.0) THEN
    CALL PUSHREAL8(cf)
    cf = cfo*(1.-af)
    CALL PUSHREAL8(qco)
    qco = qco*(1.-af)
    CALL PUSHREAL8(qao)
    qao = qao*af
    CALL PUSHCONTROL2B(0)
  ELSE
!Grid box filled with anvil
! Special case AF=1, i.e., box filled with anvil. Note: no guarantee QV_box > QS_box
! Remove any other cloud
    CALL PUSHREAL8(cf)
    cf = 0.
! Add any LS condensate to anvil type
    qao = qa + qc
! Remove same from LS   
    qco = 0.
! Total water
    qt = qao + qv
    IF (qt - qsx .LT. 0.) THEN
      qao = 0.
      CALL PUSHCONTROL2B(2)
    ELSE
      qao = qt - qsx
      CALL PUSHCONTROL2B(1)
    END IF
  END IF
!Partition new condensate into ice and liquid taking care to keep both >=0 separately. 
!New condensate can be less than old, so Delta can be < 0.
  qcx = qco - qc
  dqcl = (1.0-fqi)*qcx
  dqci = fqi*qcx
!Large Scale Partition
  IF (qcl + dqcl .LT. 0.) THEN
    dqci = dqci + (qcl+dqcl)
!== dQCl - (QCl+dQCl)
    CALL PUSHCONTROL1B(0)
  ELSE
    CALL PUSHCONTROL1B(1)
  END IF
  IF (qci + dqci .LT. 0.) THEN
    CALL PUSHCONTROL1B(0)
  ELSE
    CALL PUSHCONTROL1B(1)
  END IF
  qax = qao - qa
! (1.0-fQi)*QAx
  dqal = qax
!  fQi  * QAx
  dqai = 0.
!Convective partition
  IF (qal + dqal .LT. 0.) THEN
    dqai = dqai + (qal+dqal)
    CALL PUSHCONTROL1B(0)
  ELSE
    CALL PUSHCONTROL1B(1)
  END IF
  IF (qai + dqai .LT. 0.) THEN
    CALL PUSHCONTROL1B(0)
  ELSE
    CALL PUSHCONTROL1B(1)
  END IF
! Clean-up cloud if fractions are too small
  IF (af .LT. 1.e-5) THEN
    CALL PUSHCONTROL1B(0)
  ELSE
    CALL PUSHCONTROL1B(1)
  END IF
  IF (cf .LT. 1.e-5) THEN
    CALL PUSHCONTROL1B(0)
  ELSE
    CALL PUSHCONTROL1B(1)
  END IF
!Update specific humidity
!Update temperature
!Take care of situations where QS moves past QA during QSAT iteration (QAo negative). 
!"Evaporate" offending QA
  IF (qao .LE. 0.) THEN
    qaib = qvb - cons_alhs*teb/cons_cp
    qalb = qvb - cons_alhl*teb/cons_cp
    afb = 0.0_8
  END IF
  tempb4 = teb/cons_cp
  tempb5 = cons_alhl*tempb4
  dqaib = qaib - qvb + cons_alhf*tempb4 + tempb5
  dqcib = qcib - qvb + cons_alhf*tempb4 + tempb5
  dqalb = qalb - qvb + tempb5
  dqclb = qclb - qvb + tempb5
  CALL POPCONTROL1B(branch)
  IF (branch .EQ. 0) THEN
    qclb = qclb - dqclb
    qcib = qcib - dqcib
    dqcib = 0.0_8
    dqclb = 0.0_8
  END IF
  CALL POPCONTROL1B(branch)
  IF (branch .EQ. 0) THEN
    qalb = qalb - dqalb
    qaib = qaib - dqaib
    dqaib = 0.0_8
    dqalb = 0.0_8
  END IF
  CALL POPCONTROL1B(branch)
  IF (branch .EQ. 0) THEN
    qaib = qaib + dqalb - dqaib
    dqaib = dqalb
  END IF
  CALL POPCONTROL1B(branch)
  IF (branch .EQ. 0) THEN
    qalb = qalb + dqaib - dqalb
    dqalb = dqaib
  END IF
  qaxb = dqalb
  qaob = qaxb
  qab = -qaxb
  CALL POPCONTROL1B(branch)
  IF (branch .EQ. 0) THEN
    qcib = qcib + dqclb - dqcib
    dqcib = dqclb
  END IF
  CALL POPCONTROL1B(branch)
  IF (branch .EQ. 0) THEN
    qclb = qclb + dqcib - dqclb
    dqclb = dqcib
  END IF
  fqib = qcx*dqcib - qcx*dqclb
  qcxb = (1.0-fqi)*dqclb + fqi*dqcib
  qcob = qcxb
  qcb = -qcxb
  CALL POPCONTROL2B(branch)
  IF (branch .EQ. 0) THEN
    CALL POPREAL8(qao)
    CALL POPREAL8(qco)
    afb = afb + qao*qaob - cfo*cfb - qco*qcob
    qaob = af*qaob
    qcob = (1.-af)*qcob
    CALL POPREAL8(cf)
    cfob = (1.-af)*cfb
    qsxb = 0.0_8
  ELSE
    IF (branch .EQ. 1) THEN
      qtb = qaob
      qsxb = -qaob
    ELSE
      qtb = 0.0_8
      qsxb = 0.0_8
    END IF
    qaob = qtb
    qvb = qvb + qtb
    qab = qab + qaob
    qcb = qcb + qaob
    CALL POPREAL8(cf)
    qaob = 0.0_8
    cfob = 0.0_8
    qcob = 0.0_8
  END IF
  qcnb = qcob
  cfnb = cfob
  CALL POPCONTROL2B(branch)
  IF (branch .LT. 2) THEN
    IF (branch .EQ. 0) THEN
      CALL POPREAL8(qcn)
      temp0 = dqs*alhx/cons_cp
      temp1 = (alpha-1.)*cfn - qcn/qsn
      temp = -(temp1*temp0) + 1.
      tempb0 = qcnb/temp
      tempb1 = -((qcn-qcp)*tempb0/temp)
      tempb2 = temp0*tempb1/qsn
      tempb3 = -(temp1*tempb1/cons_cp)
      qcpb = qcnb - tempb0
      cfnb = cfnb - temp0*(alpha-1.)*tempb1
      qsnb = -(qcn*tempb2/qsn)
      dqsb = alhx*tempb3
      alhxb = dqs*tempb3
      qcnb = tempb2 + tempb0
      GOTO 100
    ELSE
      qcpb = 0.5*qcnb
      qcnb = 0.5*qcnb
    END IF
  ELSE IF (branch .EQ. 2) THEN
    qcpb = 0.0_8
  ELSE
    qcpb = 0.0_8
  END IF
  dqsb = 0.0_8
  alhxb = 0.0_8
  qsnb = 0.0_8
 100 fqib = fqib + (cons_alhs-cons_alhl)*alhxb
  CALL POPCONTROL1B(branch)
  IF (branch .EQ. 0) THEN
    qaxb = qaob
  ELSE
    qaxb = 0.0_8
  END IF
  qcx = qc*tmparr
  qt = qcx + qvx
  CALL PDFCONDENSATE_B(pdfshape, qt, qtb, sigmaqt1, sigmaqt1b, sigmaqt2&
&                , sigmaqt2b, qsn, qsnb, qcn, qcnb)
  CALL POPCONTROL2B(branch)
  IF (branch .EQ. 0) THEN
    CALL PDFFRAC_B(1, qt, qtb, sigmaqt1, sigmaqt1b, sigmaqt2, sigmaqt2b&
&            , qsn, qsnb, cfn, cfnb)
  ELSE IF (branch .EQ. 1) THEN
    CALL PDFFRAC_B(4, qt, qtb, sigmaqt1, sigmaqt1b, sigmaqt2, sigmaqt2b&
&            , qsn, qsnb, cfn, cfnb)
  END IF
  CALL POPCONTROL1B(branch)
  IF (branch .EQ. 0) THEN
    qsnb = qsnb + alpha*sigmaqt1b + alpha*sigmaqt2b
    sigmaqt1b = 0.0_8
    sigmaqt2b = 0.0_8
  END IF
  qsnb = qsnb + alpha*sigmaqt1b + alpha*sigmaqt2b
  tepb = 0.0_8
  CALL GET_ICE_FRACTION_B(tep, tepb, t_ice_all, t_ice_max, icefrpwr, fqi&
&                   , fqib)
  tenb = tepb
  qsxb = qsxb + qsnb
  dqsxb = dqsb
  qcnb = qcpb
  qcxb = qtb + qcnb
  cfxb = cfnb
  teob = tenb
  qvxb = qtb
  CALL POPCONTROL1B(branch)
  IF (branch .EQ. 0) THEN
    qab = qab + qaxb/af
    afb = afb - qa*qaxb/af**2
  END IF
  CALL POPCONTROL1B(branch)
  IF (branch .EQ. 0) THEN
    qsxb = qsxb + 1.e-4*qvxb
    qvxb = 0.0_8
  END IF
  tempb = tmparr*qvxb
  qvb = qvb + tempb
  qsxb = qsxb - af*tempb
  afb = afb - qsx*tempb
  tmparrb = qc*qcxb + cf*cfxb + (qv-qsx*af)*qvxb
  qcb = qcb + tmparr*qcxb
  cfb = tmparr*cfxb
  CALL POPCONTROL3B(branch)
  IF (branch .LT. 2) THEN
    IF (branch .EQ. 0) THEN
      afb = afb + tmparrb/(1.-af)**2
    ELSE
      afb = afb + tmparrb/(0.02)**2
    END IF
  ELSE IF (branch .EQ. 2) THEN
    afb = afb + tmparrb/(1.-af)**2
  END IF
  CALL DQSATS_BAC_B(dqsx, dqsxb, qsx, qsxb, teo, teob, pl, estblx, &
&             cons_h2omw, cons_airmw)
  teb = teb + teob
  qalb = qalb + qab
  qaib = qaib + qab
  qclb = qclb + qcb
  qcib = qcib + qcb
END SUBROUTINE LS_CLOUD_B

!  Differentiation of pdffrac in reverse (adjoint) mode:
!   gradient     of useful results: qtmean sigmaqt1 sigmaqt2 qstar
!                clfrac
!   with respect to varying inputs: qtmean sigmaqt1 sigmaqt2 qstar
!                clfrac
SUBROUTINE PDFFRAC_B(flag, qtmean, qtmeanb, sigmaqt1, sigmaqt1b, &
& sigmaqt2, sigmaqt2b, qstar, qstarb, clfrac, clfracb)
  IMPLICIT NONE
!Regularization
!clfracd = 0.2*clfracd
!Inputs
  INTEGER, INTENT(IN) :: flag
  REAL*8, INTENT(IN) :: qtmean, sigmaqt1, sigmaqt2, qstar
  REAL*8 :: qtmeanb, sigmaqt1b, sigmaqt2b, qstarb
!Prognostic
  REAL*8, INTENT(INOUT) :: clfrac
  REAL*8 :: clfracb
!LOCALS
  REAL*8 :: qtmode, qtmin, qtmax
  REAL*8 :: qtmodeb, qtminb, qtmaxb
  REAL*8 :: rh, rhd, q1, q2
  REAL*8 :: rhb
  INTRINSIC MIN
  INTRINSIC TANH
  INTEGER :: branch
  REAL*8 :: temp0
  REAL*8 :: min1
  REAL*8 :: tempb5
  REAL*8 :: tempb4
  REAL*8 :: tempb3
  REAL*8 :: tempb2
  REAL*8 :: tempb1
  REAL*8 :: tempb0
  REAL*8 :: min1b
  REAL*8 :: tempb
  REAL*8 :: temp
  IF (flag .EQ. 1) THEN
!Tophat PDF
    IF (qtmean + sigmaqt1 .GE. qstar) THEN
      IF (sigmaqt1 .GT. 0.) THEN
        IF (qtmean + sigmaqt1 - qstar .GT. 2.*sigmaqt1) THEN
          min1 = 2.*sigmaqt1
          CALL PUSHCONTROL1B(0)
        ELSE
          min1 = qtmean + sigmaqt1 - qstar
          CALL PUSHCONTROL1B(1)
        END IF
        tempb = clfracb/(2.*sigmaqt1)
        min1b = tempb
        sigmaqt1b = sigmaqt1b - min1*tempb/sigmaqt1
        CALL POPCONTROL1B(branch)
        IF (branch .EQ. 0) THEN
          sigmaqt1b = sigmaqt1b + 2.*min1b
        ELSE
          qtmeanb = qtmeanb + min1b
          sigmaqt1b = sigmaqt1b + min1b
          qstarb = qstarb - min1b
        END IF
      END IF
    END IF
    clfracb = 0.0_8
  ELSE IF (flag .EQ. 2) THEN
!Triangular PDF
    qtmode = qtmean + (sigmaqt1-sigmaqt2)/3.
    IF (qtmode - sigmaqt1 .GT. 0.) THEN
      CALL PUSHCONTROL1B(0)
      qtmin = 0.
    ELSE
      qtmin = qtmode - sigmaqt1
      CALL PUSHCONTROL1B(1)
    END IF
    qtmax = qtmode + sigmaqt2
    IF (qtmax .LT. qstar) THEN
      clfracb = 0.0_8
      qtmaxb = 0.0_8
      qtminb = 0.0_8
      qtmodeb = 0.0_8
    ELSE IF (qtmode .LE. qstar .AND. qstar .LT. qtmax) THEN
      temp = (qtmax-qtmin)*(qtmax-qtmode)
      tempb0 = clfracb/temp
      tempb1 = 2*(qtmax-qstar)*tempb0
      tempb2 = -((qtmax-qstar)**2*tempb0/temp)
      qtmaxb = (2*qtmax-qtmin-qtmode)*tempb2 + tempb1
      qstarb = qstarb - tempb1
      qtminb = -((qtmax-qtmode)*tempb2)
      qtmodeb = -((qtmax-qtmin)*tempb2)
      clfracb = 0.0_8
    ELSE IF (qtmin .LE. qstar .AND. qstar .LT. qtmode) THEN
      temp0 = (qtmax-qtmin)*(qtmode-qtmin)
      tempb3 = -(clfracb/temp0)
      tempb4 = 2*(qstar-qtmin)*tempb3
      tempb5 = -((qstar-qtmin)**2*tempb3/temp0)
      qstarb = qstarb + tempb4
      qtminb = (2*qtmin-qtmax-qtmode)*tempb5 - tempb4
      qtmaxb = (qtmode-qtmin)*tempb5
      qtmodeb = (qtmax-qtmin)*tempb5
      clfracb = 0.0_8
    ELSE
      IF (qstar .LE. qtmin) clfracb = 0.0_8
      qtmaxb = 0.0_8
      qtminb = 0.0_8
      qtmodeb = 0.0_8
    END IF
    qtmodeb = qtmodeb + qtmaxb
    sigmaqt2b = sigmaqt2b + qtmaxb
    CALL POPCONTROL1B(branch)
    IF (branch .NE. 0) THEN
      qtmodeb = qtmodeb + qtminb
      sigmaqt1b = sigmaqt1b - qtminb
    END IF
    qtmeanb = qtmeanb + qtmodeb
    sigmaqt1b = sigmaqt1b + qtmodeb/3.
    sigmaqt2b = sigmaqt2b - qtmodeb/3.
  ELSE IF (flag .EQ. 3) THEN

    ! (REGULARIZATION) * (GRADIENT) * (PERTURBATION)
    clfracb = (0.66*( cosh(10*(RH-1.0))**(-2))) * clfracb

    rh = qtmean/qstar
    q1 = 22.556
    rhb = (1.0-TANH(q1*(rh-1.0))**2)*0.5*q1*clfracb
    qtmeanb = qtmeanb + rhb/qstar
    qstarb = qstarb - qtmean*rhb/qstar**2
    clfracb = 0.0_8

  ELSE IF (flag .EQ. 4) THEN

    !Linear for the perturbation part

    !Regularization
    clfracb = clfracb * 0.2

    rh = qtmean/qstar
    q1 = 0.9335
    q2 = 1.0665
    IF (rh .LT. q1) THEN
      rhb = 0.0_8
    ELSE IF (rh .GE. q1 .AND. rh .LT. q2) THEN
      rhb = clfracb/((q2/q1-1)*q1)
    ELSE
      rhb = 0.0_8
    END IF
    qtmeanb = qtmeanb + rhb/qstar
    qstarb = qstarb - qtmean*rhb/qstar**2
    clfracb = 0.0_8
  END IF

END SUBROUTINE PDFFRAC_B

!  Differentiation of pdfcondensate in reverse (adjoint) mode:
!   gradient     of useful results: qstar4 condensate4
!   with respect to varying inputs: qtmean4 qstar4 sigmaqt14 sigmaqt24
SUBROUTINE PDFCONDENSATE_B(flag, qtmean4, qtmean4b, sigmaqt14, &
& sigmaqt14b, sigmaqt24, sigmaqt24b, qstar4, qstar4b, condensate4, &
& condensate4b)
  IMPLICIT NONE
!Inputs
  INTEGER, INTENT(IN) :: flag
  REAL*8, INTENT(IN) :: qtmean4, sigmaqt14, sigmaqt24, qstar4
  REAL*8 :: qtmean4b, sigmaqt14b, sigmaqt24b, qstar4b
!Prognostic
  REAL*8, INTENT(INOUT) :: condensate4
  REAL*8 :: condensate4b
!Locals
  REAL*8 :: qtmode, qtmin, qtmax, consta, constb, cloudf
  REAL*8 :: qtmodeb, qtminb, qtmaxb, constab, constbb, cloudfb
  REAL*8 :: term1, term2, term3
  REAL*8 :: term1b, term2b, term3b
  REAL*8 :: qtmean, sigmaqt1, sigmaqt2, qstar, condensate
  REAL*8 :: qtmeanb, sigmaqt1b, sigmaqt2b, qstarb, condensateb
  INTRINSIC MIN
  INTEGER :: branch
  REAL*8 :: temp2
  REAL*8 :: temp1
  REAL*8 :: temp0
  REAL*8 :: tempb9
  REAL*8 :: tempb8
  REAL*8 :: tempb7
  REAL*8 :: tempb6
  REAL*8 :: min1
  REAL*8 :: tempb5
  REAL*8 :: tempb4
  REAL*8 :: tempb3
  REAL*8 :: tempb2
  REAL*8 :: tempb1
  REAL*8 :: tempb0
  REAL*8 :: min1b
  REAL*8 :: tempb
  REAL*8 :: temp
  qtmean = qtmean4
  sigmaqt1 = sigmaqt14
  sigmaqt2 = sigmaqt24
  qstar = qstar4
  IF (flag .EQ. 1) THEN
    IF (qtmean + sigmaqt1 .LT. qstar) THEN
      CALL PUSHCONTROL4B(0)
    ELSE IF (qstar .GT. qtmean - sigmaqt1) THEN
      IF (sigmaqt1 .GT. 0.d0) THEN
        IF (qtmean + sigmaqt1 - qstar .GT. 2.d0*sigmaqt1) THEN
          min1 = 2.d0*sigmaqt1
          CALL PUSHCONTROL1B(0)
        ELSE
          min1 = qtmean + sigmaqt1 - qstar
          CALL PUSHCONTROL1B(1)
        END IF
        CALL PUSHCONTROL4B(1)
      ELSE
        CALL PUSHCONTROL4B(2)
      END IF
    ELSE
      CALL PUSHCONTROL4B(3)
    END IF
  ELSE IF (flag .EQ. 2) THEN
    qtmode = qtmean + (sigmaqt1-sigmaqt2)/3.d0
    IF (qtmode - sigmaqt1 .GT. 0.d0) THEN
      qtmin = 0.d0
      CALL PUSHCONTROL1B(0)
    ELSE
      qtmin = qtmode - sigmaqt1
      CALL PUSHCONTROL1B(1)
    END IF
    qtmax = qtmode + sigmaqt2
    IF (qtmax .LT. qstar) THEN
      CALL PUSHCONTROL4B(4)
    ELSE IF (qtmode .LE. qstar .AND. qstar .LT. qtmax) THEN
      constb = 2.d0/((qtmax-qtmin)*(qtmax-qtmode))
      cloudf = (qtmax-qstar)*(qtmax-qstar)/((qtmax-qtmin)*(qtmax-qtmode)&
&       )
      term1 = qstar*qstar*qstar/3.d0
      term2 = qtmax*qstar*qstar/2.d0
      term3 = qtmax*qtmax*qtmax/6.d0
      CALL PUSHCONTROL4B(5)
    ELSE IF (qtmin .LE. qstar .AND. qstar .LT. qtmode) THEN
      consta = 2.d0/((qtmax-qtmin)*(qtmode-qtmin))
      cloudf = 1.d0 - (qstar-qtmin)*(qstar-qtmin)/((qtmax-qtmin)*(qtmode&
&       -qtmin))
      term1 = qstar*qstar*qstar/3.d0
      term2 = qtmin*qstar*qstar/2.d0
      term3 = qtmin*qtmin*qtmin/6.d0
      CALL PUSHCONTROL4B(6)
    ELSE IF (qstar .LE. qtmin) THEN
      CALL PUSHCONTROL4B(7)
    ELSE
      CALL PUSHCONTROL4B(8)
    END IF
  ELSE IF (flag .EQ. 3) THEN
!Reference part done normally
!IF (qtmean + sigmaqt1 .LT. qstar) THEN
!  condensate = 0.d0
!ELSE IF (qstar .GT. qtmean - sigmaqt1) THEN
!  IF (sigmaqt1 .GT. 0.d0) THEN
!    IF (qtmean + sigmaqt1 - qstar .GT. 2.d0*sigmaqt1) THEN
!      min1 = 2.d0*sigmaqt1
!    ELSE
!      min1 = qtmean + sigmaqt1 - qstar
!    END IF
!    condensate = min1**2/(4.d0*sigmaqt1)
!  ELSE
!    condensate = qtmean - qstar
!  END IF
!ELSE
!  condensate = qtmean - qstar
!END IF
!Perturbation part from linear
    IF (qtmean - qstar .GT. -0.5e-3) THEN
      CALL PUSHCONTROL4B(9)
    ELSE
      CALL PUSHCONTROL4B(10)
    END IF
  ELSE
    CALL PUSHCONTROL4B(11)
  END IF
  condensateb = condensate4b
  CALL POPCONTROL4B(branch)
  IF (branch .LT. 6) THEN
    IF (branch .LT. 3) THEN
      IF (branch .EQ. 0) THEN
        qtmeanb = 0.0_8
        sigmaqt1b = 0.0_8
        qstarb = 0.0_8
      ELSE IF (branch .EQ. 1) THEN
        tempb = condensateb/(4.d0*sigmaqt1)
        min1b = 2*min1*tempb
        sigmaqt1b = -(min1**2*tempb/sigmaqt1)
        CALL POPCONTROL1B(branch)
        IF (branch .EQ. 0) THEN
          sigmaqt1b = sigmaqt1b + 2.d0*min1b
          qtmeanb = 0.0_8
          qstarb = 0.0_8
        ELSE
          qtmeanb = min1b
          sigmaqt1b = sigmaqt1b + min1b
          qstarb = -min1b
        END IF
      ELSE
        qtmeanb = condensateb
        qstarb = -condensateb
        sigmaqt1b = 0.0_8
      END IF
    ELSE IF (branch .EQ. 3) THEN
      qtmeanb = condensateb
      qstarb = -condensateb
      sigmaqt1b = 0.0_8
    ELSE
      IF (branch .EQ. 4) THEN
        qtmeanb = 0.0_8
        qtmaxb = 0.0_8
        qstarb = 0.0_8
        qtminb = 0.0_8
        qtmodeb = 0.0_8
      ELSE
        cloudfb = -(qstar*condensateb)
        temp0 = (qtmax-qtmin)*(qtmax-qtmode)
        tempb4 = cloudfb/temp0
        tempb1 = 2*(qtmax-qstar)*tempb4
        tempb0 = constb*condensateb
        constbb = (term1-term2+term3)*condensateb
        term1b = tempb0
        term2b = -tempb0
        term3b = tempb0
        qstarb = qtmax*2*qstar*term2b/2.d0 - tempb1 + 3*qstar**2*term1b/&
&         3.d0 - cloudf*condensateb
        tempb3 = -((qtmax-qstar)**2*tempb4/temp0)
        temp = (qtmax-qtmin)*(qtmax-qtmode)
        tempb2 = -(2.d0*constbb/temp**2)
        qtmaxb = qstar**2*term2b/2.d0 + (2*qtmax-qtmin-qtmode)*tempb2 + &
&         (2*qtmax-qtmin-qtmode)*tempb3 + tempb1 + 3*qtmax**2*term3b/&
&         6.d0
        qtminb = -((qtmax-qtmode)*tempb2) - (qtmax-qtmode)*tempb3
        qtmodeb = -((qtmax-qtmin)*tempb2) - (qtmax-qtmin)*tempb3
        qtmeanb = 0.0_8
      END IF
      GOTO 100
    END IF
    sigmaqt2b = 0.0_8
    GOTO 110
  ELSE IF (branch .LT. 9) THEN
    IF (branch .EQ. 6) THEN
      cloudfb = -(qstar*condensateb)
      temp2 = (qtmax-qtmin)*(qtmode-qtmin)
      tempb9 = -(cloudfb/temp2)
      tempb6 = 2*(qstar-qtmin)*tempb9
      tempb5 = -(consta*condensateb)
      qtmeanb = condensateb
      constab = -((term1-term2+term3)*condensateb)
      term1b = tempb5
      term2b = -tempb5
      term3b = tempb5
      qstarb = qtmin*2*qstar*term2b/2.d0 + tempb6 + 3*qstar**2*term1b/&
&       3.d0 - cloudf*condensateb
      tempb8 = -((qstar-qtmin)**2*tempb9/temp2)
      temp1 = (qtmax-qtmin)*(qtmode-qtmin)
      tempb7 = -(2.d0*constab/temp1**2)
      qtminb = qstar**2*term2b/2.d0 + (2*qtmin-qtmax-qtmode)*tempb7 + (2&
&       *qtmin-qtmax-qtmode)*tempb8 - tempb6 + 3*qtmin**2*term3b/6.d0
      qtmaxb = (qtmode-qtmin)*tempb7 + (qtmode-qtmin)*tempb8
      qtmodeb = (qtmax-qtmin)*tempb7 + (qtmax-qtmin)*tempb8
    ELSE
      IF (branch .EQ. 7) THEN
        qtmeanb = condensateb
        qstarb = -condensateb
      ELSE
        qtmeanb = 0.0_8
        qstarb = 0.0_8
      END IF
      qtmaxb = 0.0_8
      qtminb = 0.0_8
      qtmodeb = 0.0_8
    END IF
  ELSE
    IF (branch .EQ. 9) THEN
      qtmeanb = condensateb
      qstarb = -condensateb
    ELSE IF (branch .EQ. 10) THEN
      qtmeanb = 0.0_8
      qstarb = 0.0_8
    ELSE
      qtmeanb = 0.0_8
      qstarb = 0.0_8
    END IF
    sigmaqt1b = 0.0_8
    sigmaqt2b = 0.0_8
    GOTO 110
  END IF
 100 qtmodeb = qtmodeb + qtmaxb
  sigmaqt2b = qtmaxb
  CALL POPCONTROL1B(branch)
  IF (branch .EQ. 0) THEN
    sigmaqt1b = 0.0_8
  ELSE
    qtmodeb = qtmodeb + qtminb
    sigmaqt1b = -qtminb
  END IF
  qtmeanb = qtmeanb + qtmodeb
  sigmaqt1b = sigmaqt1b + qtmodeb/3.d0
  sigmaqt2b = sigmaqt2b - qtmodeb/3.d0
 110 qstar4b = qstar4b + qstarb
  sigmaqt24b = sigmaqt2b
  sigmaqt14b = sigmaqt1b
  qtmean4b = qtmeanb
END SUBROUTINE PDFCONDENSATE_B

!  Differentiation of evap_cnv in reverse (adjoint) mode:
!   gradient     of useful results: f qi ql qs qv te
!   with respect to varying inputs: f qi ql qs qv te
SUBROUTINE EVAP_CNV_B(dt, rhcr, pl, te, teb, qv, qvb, ql, qlb, qi, qib, &
& f, fb, xf, qs, qsb, rho_w, cld_evp_eff, cons_h2omw, cons_airmw, &
& cons_alhl, cons_rvap, cons_rgas, cons_pi, cons_cp)
  IMPLICIT NONE
!Inputs
  REAL*8, INTENT(IN) :: dt, rhcr, pl, xf, qs, rho_w, cld_evp_eff
  REAL*8 :: qsb
  REAL*8, INTENT(IN) :: cons_h2omw, cons_airmw, cons_alhl, cons_rvap, &
& cons_rgas, cons_pi, cons_cp
!Prognostics
  REAL*8, INTENT(INOUT) :: te, qv, ql, qi, f
  REAL*8 :: teb, qvb, qlb, qib, fb
!Locals
  REAL*8 :: es, radius, k1, k2, teff, qcm, evap, rhx, qc, a_eff, epsilon
  REAL*8 :: esb, radiusb, k1b, k2b, teffb, qcmb, evapb, rhxb, qcb
  REAL*8, PARAMETER :: k_cond=2.4e-2
  REAL*8, PARAMETER :: diffu=2.2e-5
  REAL*8, PARAMETER :: nn=50.*1.0e6
  INTRINSIC MIN
  INTEGER :: branch
  REAL*8 :: temp3
  REAL*8 :: temp2
  REAL*8 :: temp1
  REAL*8 :: temp0
  REAL*8 :: tempb4
  REAL*8 :: tempb3
  REAL*8 :: tempb2
  REAL*8 :: tempb1
  REAL*8 :: tempb0
  REAL*8 :: tempb
  REAL*8 :: temp
  epsilon = cons_h2omw/cons_airmw
  a_eff = cld_evp_eff
!EVAPORATION OF CLOUD WATER.
! (100 <-^ convert from mbar to Pa)
  es = 100.*pl*qs/(epsilon+(1.0-epsilon)*qs)
  IF (qv/qs .GT. 1.00) THEN
    CALL PUSHCONTROL1B(0)
    rhx = 1.00
  ELSE
    rhx = qv/qs
    CALL PUSHCONTROL1B(1)
  END IF
  k1 = cons_alhl**2*rho_w/(k_cond*cons_rvap*te**2)
  k2 = cons_rvap*te*rho_w/(diffu*(1000./pl)*es)
!Here DIFFU is given for 1000 mb so 1000./PR accounts for increased diffusivity at lower pressure. 
  IF (f .GT. 0. .AND. ql .GT. 0.) THEN
    qcm = ql/f
    CALL PUSHCONTROL1B(0)
  ELSE
    CALL PUSHCONTROL1B(1)
    qcm = 0.
  END IF
  CALL LDRADIUS(pl, te, qcm, nn, rho_w, radius, cons_rgas, cons_pi)
  IF (rhx .LT. rhcr .AND. radius .GT. 0.0) THEN
! / (1.00 - RHx)
    teff = (rhcr-rhx)/((k1+k2)*radius**2)
    CALL PUSHCONTROL1B(1)
  ELSE
! -999.
    teff = 0.0
    CALL PUSHCONTROL1B(0)
  END IF
  evap = a_eff*ql*dt*teff
  IF (evap .GT. ql) THEN
    evap = ql
    CALL PUSHCONTROL1B(0)
  ELSE
    CALL PUSHCONTROL1B(1)
    evap = evap
  END IF
  qc = ql + qi
  IF (qc .GT. 0.) THEN
    CALL PUSHCONTROL1B(0)
  ELSE
    CALL PUSHCONTROL1B(1)
  END IF
  evapb = qvb - qlb - cons_alhl*teb/cons_cp
  CALL POPCONTROL1B(branch)
  IF (branch .EQ. 0) THEN
    temp3 = f/qc
    tempb4 = (qc-evap)*fb/qc
    qcb = temp3*fb - temp3*tempb4
    evapb = evapb - temp3*fb
    fb = tempb4
  ELSE
    qcb = 0.0_8
  END IF
  qlb = qlb + qcb
  qib = qib + qcb
  CALL POPCONTROL1B(branch)
  IF (branch .EQ. 0) THEN
    qlb = qlb + evapb
    evapb = 0.0_8
  END IF
  tempb3 = a_eff*dt*evapb
  qlb = qlb + teff*tempb3
  teffb = ql*tempb3
  CALL POPCONTROL1B(branch)
  IF (branch .EQ. 0) THEN
    radiusb = 0.0_8
    k1b = 0.0_8
    k2b = 0.0_8
    rhxb = 0.0_8
  ELSE
    temp2 = (k1+k2)*radius**2
    tempb1 = -((rhcr-rhx)*teffb/temp2**2)
    tempb2 = radius**2*tempb1
    rhxb = -(teffb/temp2)
    k1b = tempb2
    k2b = tempb2
    radiusb = (k1+k2)*2*radius*tempb1
  END IF
  CALL LDRADIUS_B(pl, te, teb, qcm, qcmb, nn, rho_w, radius, radiusb, &
&           cons_rgas, cons_pi)
qcmb = 0.0_8
  CALL POPCONTROL1B(branch)
  IF (branch .EQ. 0) THEN
    qlb = qlb + qcmb/f
    fb = fb - ql*qcmb/f**2
  END IF
  temp0 = k_cond*cons_rvap*te**2
  temp1 = 1000.*diffu*es
  tempb0 = cons_rvap*rho_w*pl*k2b/temp1
  teb = teb + tempb0 - k_cond*cons_rvap*cons_alhl**2*rho_w*2*te*k1b/&
&   temp0**2
  esb = -(te*diffu*1000.*tempb0/temp1)
  CALL POPCONTROL1B(branch)
  IF (branch .NE. 0) THEN
    qvb = qvb + rhxb/qs
    qsb = qsb - qv*rhxb/qs**2
  END IF
  temp = epsilon + (-epsilon+1.0)*qs
  tempb = pl*100.*esb/temp
  qsb = qsb + (1.0_8-qs*(1.0-epsilon)/temp)*tempb
END SUBROUTINE EVAP_CNV_B

!  Differentiation of subl_cnv in reverse (adjoint) mode:
!   gradient     of useful results: f qi ql qs qv te
!   with respect to varying inputs: f qi ql qs qv te
SUBROUTINE SUBL_CNV_B(dt, rhcr, pl, te, teb, qv, qvb, ql, qlb, qi, qib, &
& f, fb, xf, qs, qsb, rho_w, cld_evp_eff, cons_h2omw, cons_airmw, &
& cons_alhl, cons_rvap, cons_rgas, cons_pi, cons_cp, cons_alhs)
  IMPLICIT NONE
!INPUTS
  REAL*8, INTENT(IN) :: dt, rhcr, pl, xf, qs, rho_w, cld_evp_eff
  REAL*8 :: qsb
  REAL*8, INTENT(IN) :: cons_h2omw, cons_airmw, cons_alhl, cons_rvap, &
& cons_rgas, cons_pi, cons_cp, cons_alhs
!PROGNOSTIC
  REAL*8, INTENT(INOUT) :: te, qv, ql, qi, f
  REAL*8 :: teb, qvb, qlb, qib, fb
!LOCALS
  REAL*8 :: es, radius, k1, k2, teff, qcm, subl, rhx, qc, a_eff, nn, &
& epsilon
  REAL*8 :: esb, radiusb, k1b, k2b, teffb, qcmb, sublb, rhxb, qcb
  REAL*8, PARAMETER :: k_cond=2.4e-2
  REAL*8, PARAMETER :: diffu=2.2e-5
  INTRINSIC MIN
  INTEGER :: branch
  REAL*8 :: temp3
  REAL*8 :: temp2
  REAL*8 :: temp1
  REAL*8 :: temp0
  REAL*8 :: tempb4
  REAL*8 :: tempb3
  REAL*8 :: tempb2
  REAL*8 :: tempb1
  REAL*8 :: tempb0
  REAL*8 :: tempb
  REAL*8 :: temp
  epsilon = cons_h2omw/cons_airmw
  a_eff = cld_evp_eff
  nn = 5.*1.0e6
! (100 s <-^ convert from mbar to Pa)
  es = 100.*pl*qs/(epsilon+(1.0-epsilon)*qs)
  IF (qv/qs .GT. 1.00) THEN
    CALL PUSHCONTROL1B(0)
    rhx = 1.00
  ELSE
    rhx = qv/qs
    CALL PUSHCONTROL1B(1)
  END IF
  k1 = cons_alhl**2*rho_w/(k_cond*cons_rvap*te**2)
  k2 = cons_rvap*te*rho_w/(diffu*(1000./pl)*es)
!Here DIFFU is given for 1000 mb so 1000./PR accounts for increased diffusivity at lower pressure.
  IF (f .GT. 0. .AND. qi .GT. 0.) THEN
    qcm = qi/f
    CALL PUSHCONTROL1B(0)
  ELSE
    CALL PUSHCONTROL1B(1)
    qcm = 0.
  END IF
  CALL LDRADIUS(pl, te, qcm, nn, rho_w, radius, cons_rgas, cons_pi)
  IF (rhx .LT. rhcr .AND. radius .GT. 0.0) THEN
! / (1.00 - RHx)
    teff = (rhcr-rhx)/((k1+k2)*radius**2)
    CALL PUSHCONTROL1B(1)
  ELSE
! -999.
    teff = 0.0
    CALL PUSHCONTROL1B(0)
  END IF
  subl = a_eff*qi*dt*teff
  IF (subl .GT. qi) THEN
    subl = qi
    CALL PUSHCONTROL1B(0)
  ELSE
    CALL PUSHCONTROL1B(1)
    subl = subl
  END IF
  qc = ql + qi
  IF (qc .GT. 0.) THEN
    CALL PUSHCONTROL1B(0)
  ELSE
    CALL PUSHCONTROL1B(1)
  END IF
  sublb = qvb - qib - cons_alhs*teb/cons_cp
  CALL POPCONTROL1B(branch)
  IF (branch .EQ. 0) THEN
    temp3 = f/qc
    tempb4 = (qc-subl)*fb/qc
    qcb = temp3*fb - temp3*tempb4
    sublb = sublb - temp3*fb
    fb = tempb4
  ELSE
    qcb = 0.0_8
  END IF
  qlb = qlb + qcb
  qib = qib + qcb
  CALL POPCONTROL1B(branch)
  IF (branch .EQ. 0) THEN
    qib = qib + sublb
    sublb = 0.0_8
  END IF
  tempb3 = a_eff*dt*sublb
  qib = qib + teff*tempb3
  teffb = qi*tempb3
  CALL POPCONTROL1B(branch)
  IF (branch .EQ. 0) THEN
    radiusb = 0.0_8
    k1b = 0.0_8
    k2b = 0.0_8
    rhxb = 0.0_8
  ELSE
    temp2 = (k1+k2)*radius**2
    tempb1 = -((rhcr-rhx)*teffb/temp2**2)
    tempb2 = radius**2*tempb1
    rhxb = -(teffb/temp2)
    k1b = tempb2
    k2b = tempb2
    radiusb = (k1+k2)*2*radius*tempb1
  END IF
  CALL LDRADIUS_B(pl, te, teb, qcm, qcmb, nn, rho_w, radius, radiusb, &
&           cons_rgas, cons_pi)
qcmb = 0.0
  CALL POPCONTROL1B(branch)
  IF (branch .EQ. 0) THEN
    qib = qib + qcmb/f
    fb = fb - qi*qcmb/f**2
  END IF
  temp0 = k_cond*cons_rvap*te**2
  temp1 = 1000.*diffu*es
  tempb0 = cons_rvap*rho_w*pl*k2b/temp1
  teb = teb + tempb0 - k_cond*cons_rvap*cons_alhl**2*rho_w*2*te*k1b/&
&   temp0**2
  esb = -(te*diffu*1000.*tempb0/temp1)
  CALL POPCONTROL1B(branch)
  IF (branch .NE. 0) THEN
    qvb = qvb + rhxb/qs
    qsb = qsb - qv*rhxb/qs**2
  END IF
  temp = epsilon + (-epsilon+1.0)*qs
  tempb = pl*100.*esb/temp
  qsb = qsb + (1.0_8-qs*(1.0-epsilon)/temp)*tempb
END SUBROUTINE SUBL_CNV_B

!  Differentiation of ldradius in reverse (adjoint) mode:
!   gradient     of useful results: radius te
!   with respect to varying inputs: qcl te
SUBROUTINE LDRADIUS_B(pl, te, teb, qcl, qclb, nn, rho_w, radius, radiusb&
& , cons_rgas, cons_pi)
  IMPLICIT NONE
!Inputs
  REAL*8, INTENT(IN) :: te, pl, nn, qcl, rho_w
  REAL*8 :: teb, qclb
  REAL*8, INTENT(IN) :: cons_rgas, cons_pi
!Outputs      
  REAL*8 :: radius
  REAL*8 :: radiusb
!Equiv. Spherical Cloud Particle Radius in m
  REAL*8 :: temp2
  REAL*8 :: temp1
  REAL*8 :: temp0
  REAL*8 :: tempb
  REAL*8 :: temp
  temp2 = 4.*cons_rgas*cons_pi*nn*rho_w
  temp1 = temp2*te
  temp = qcl/temp1
  temp0 = 3.*pl*100.
  IF (temp0*temp .LE. 0.0 .AND. (1.0/3. .EQ. 0.0 .OR. 1.0/3. .NE. INT(&
&     1.0/3.))) THEN
    tempb = 0.0
  ELSE
    tempb = temp0*(temp0*temp)**(1.0/3.-1)*radiusb/(3.*temp1)
  END IF
  qclb = tempb
  teb = teb - temp*temp2*tempb
END SUBROUTINE LDRADIUS_B

!  Differentiation of autoconversion_ls in reverse (adjoint) mode:
!   gradient     of useful results: f qc qp te
!   with respect to varying inputs: f qc te
SUBROUTINE AUTOCONVERSION_LS_B(dt, qc, qcb, qp, qpb, te, teb, pl, f, fb&
& , sundqv2, sundqv3, sundqt1, c_00, lwcrit, dzet)
  IMPLICIT NONE
!Inputs
  REAL*8, INTENT(IN) :: dt, te, pl, dzet, sundqv2, sundqv3, sundqt1, &
& c_00, lwcrit
  REAL*8 :: teb
!Prognostic
  REAL*8, INTENT(INOUT) :: qc, qp, f
  REAL*8 :: qcb, qpb, fb
!Locals
  REAL*8 :: acf0, acf, c00x, iqccrx, f2, f3, rate, dqp, qcm, dqfac
  REAL*8 :: c00xb, iqccrxb, f2b, f3b, rateb, dqpb, qcmb, dqfacb
  INTRINSIC EXP
  INTRINSIC MIN
  INTRINSIC MAX
  INTEGER :: branch
  REAL*8 :: tempb1
  REAL*8 :: tempb0
  REAL*8 :: x4
  REAL*8 :: x3
  REAL*8 :: x2
  REAL*8 :: x1
  REAL*8 :: x2b
  REAL*8 :: tempb
  REAL*8 :: x1b
  REAL*8 :: x4b
  REAL*8 :: temp
!Zero Locals
  f2 = 0.0
  f3 = 0.0
  CALL PUSHREAL8(f2)
  CALL CONS_SUNDQ3(te, sundqv2, sundqv3, sundqt1, f2, f3)
  c00x = c_00*f2*f3
  iqccrx = f2*f3/lwcrit
  IF (f .GT. 0. .AND. qc .GT. 0.) THEN
    qcm = qc/f
    CALL PUSHCONTROL1B(0)
  ELSE
    CALL PUSHCONTROL1B(1)
    qcm = 0.
  END IF
  rate = c00x*(1.0-EXP(-((qcm*iqccrx)**2)))
!Temporary kluge until we can figure a better to make thicker low clouds.
  CALL PUSHREAL8(f3)
  f3 = 1.0
!Implement ramps for gradual change in autoconv
!Thicken low high lat clouds
  IF (pl .GE. 775. .AND. te .LE. 275.) f3 = 0.2
!F3 = max(-0.016 * PL + 13.4, 0.2)
  IF (pl .GE. 825. .AND. te .LE. 282.) f3 = 0.2
!F3 = max(0.11 * TE - 30.02, 0.2)
  IF (pl .GE. 775. .AND. pl .LT. 825. .AND. te .LE. 282. .AND. te .GT. &
&     275.) f3 = 0.2
!F3 = min(max(-0.016*PL + 0.11 * TE - 16.85, 0.2),1.)
  IF (pl .GE. 825. .AND. te .LE. 275.) f3 = 0.2
  IF (pl .LE. 775. .OR. te .GT. 282.) f3 = 1.
!Thin-out low tropical clouds
  IF (pl .GE. 950. .AND. te .GE. 285.) THEN
    IF (0.2*te - 56 .GT. 2.) THEN
      CALL PUSHCONTROL2B(2)
      f3 = 2.
    ELSE
      f3 = 0.2*te - 56
      CALL PUSHCONTROL2B(1)
    END IF
  ELSE
    CALL PUSHCONTROL2B(0)
  END IF
  IF (pl .GE. 925. .AND. te .GE. 290.) THEN
    IF (0.04*pl - 36. .GT. 2.) THEN
      CALL PUSHCONTROL1B(1)
      f3 = 2.
    ELSE
      CALL PUSHCONTROL1B(1)
      f3 = 0.04*pl - 36.
    END IF
  ELSE
    CALL PUSHCONTROL1B(0)
  END IF
  IF (pl .GE. 925. .AND. pl .LT. 950. .AND. te .GT. 285. .AND. te .LT. &
&     290.) THEN
    IF (0.04*pl + 0.2*te - 94. .GT. 2.) THEN
      CALL PUSHCONTROL1B(0)
      x1 = 2.
    ELSE
      x1 = 0.04*pl + 0.2*te - 94.
      CALL PUSHCONTROL1B(1)
    END IF
    IF (x1 .LT. 1.) THEN
      f3 = 1.
      CALL PUSHCONTROL2B(2)
    ELSE
      f3 = x1
      CALL PUSHCONTROL2B(1)
    END IF
  ELSE
    CALL PUSHCONTROL2B(0)
  END IF
  IF (pl .GE. 950. .AND. te .GE. 290.) THEN
    f3 = 2.
    CALL PUSHCONTROL1B(1)
  ELSE
    CALL PUSHCONTROL1B(0)
  END IF
  IF (f3 .LT. 0.1) THEN
    f3 = 0.1
    CALL PUSHCONTROL1B(0)
  ELSE
    CALL PUSHCONTROL1B(1)
    f3 = f3
  END IF
  CALL PUSHREAL8(rate)
  rate = f3*rate
  dqp = qc*(1.0-EXP(-(rate*dt)))
  IF (dqp .LT. 0.0) THEN
    dqp = 0.0
    CALL PUSHCONTROL1B(0)
  ELSE
    CALL PUSHCONTROL1B(1)
    dqp = dqp
  END IF
!Wipe-out warm fogs
  dqfac = 0.
  IF (pl .GE. 975. .AND. te .GE. 280.) THEN
    IF (0.2*te - 56. .GT. 1.) THEN
      CALL PUSHCONTROL1B(0)
      x2 = 1.
    ELSE
      x2 = 0.2*te - 56.
      CALL PUSHCONTROL1B(1)
    END IF
    IF (x2 .LT. 0.) THEN
      dqfac = 0.
      CALL PUSHCONTROL2B(2)
    ELSE
      dqfac = x2
      CALL PUSHCONTROL2B(1)
    END IF
  ELSE
    CALL PUSHCONTROL2B(0)
  END IF
  IF (pl .GE. 950. .AND. te .GE. 285.) THEN
    IF (0.04*pl - 38. .GT. 1.) THEN
      CALL PUSHCONTROL1B(1)
      x3 = 1.
    ELSE
      CALL PUSHCONTROL1B(1)
      x3 = 0.04*pl - 38.
    END IF
    IF (x3 .LT. 0.) THEN
      dqfac = 0.
    ELSE
      dqfac = x3
    END IF
  ELSE
    CALL PUSHCONTROL1B(0)
  END IF
  IF (pl .GE. 950. .AND. pl .LT. 975. .AND. te .GT. 280. .AND. te .LT. &
&     285.) THEN
    IF (0.04*pl + 0.2*te - 95. .GT. 1.) THEN
      CALL PUSHCONTROL1B(0)
      x4 = 1.
    ELSE
      x4 = 0.04*pl + 0.2*te - 95.
      CALL PUSHCONTROL1B(1)
    END IF
    IF (x4 .LT. 0.) THEN
      dqfac = 0.
      CALL PUSHCONTROL2B(2)
    ELSE
      dqfac = x4
      CALL PUSHCONTROL2B(1)
    END IF
  ELSE
    CALL PUSHCONTROL2B(0)
  END IF
  IF (pl .GE. 975. .AND. te .GE. 285.) THEN
    dqfac = 1.
    CALL PUSHCONTROL1B(1)
  ELSE
    CALL PUSHCONTROL1B(0)
  END IF
  IF (dqp .LT. dqfac*qc) THEN
    dqp = dqfac*qc
    CALL PUSHCONTROL1B(0)
  ELSE
    dqp = dqp
    CALL PUSHCONTROL1B(1)
  END IF
  CALL PUSHREAL8(qc)
  qc = qc - dqp
!IF LARGE SCALE THEN
  IF (qc + dqp .GT. 0.) THEN
    tempb0 = fb/(qc+dqp)
    tempb1 = -(qc*f*tempb0/(qc+dqp))
    qcb = qcb + tempb1 + f*tempb0
    dqpb = tempb1
    fb = qc*tempb0
  ELSE
    dqpb = 0.0_8
  END IF
  dqpb = dqpb + qpb - qcb
  CALL POPREAL8(qc)
  CALL POPCONTROL1B(branch)
  IF (branch .EQ. 0) THEN
    dqfacb = qc*dqpb
    qcb = qcb + dqfac*dqpb
    dqpb = 0.0_8
  ELSE
    dqfacb = 0.0_8
  END IF
  CALL POPCONTROL1B(branch)
  IF (branch .NE. 0) dqfacb = 0.0_8
  CALL POPCONTROL2B(branch)
  IF (branch .NE. 0) THEN
    IF (branch .EQ. 1) THEN
      x4b = dqfacb
    ELSE
      x4b = 0.0_8
    END IF
    CALL POPCONTROL1B(branch)
    IF (branch .NE. 0) teb = teb + 0.2*x4b
    dqfacb = 0.0_8
  END IF
  CALL POPCONTROL1B(branch)
  IF (branch .NE. 0) dqfacb = 0.0_8
  CALL POPCONTROL2B(branch)
  IF (branch .NE. 0) THEN
    IF (branch .EQ. 1) THEN
      x2b = dqfacb
    ELSE
      x2b = 0.0_8
    END IF
    CALL POPCONTROL1B(branch)
    IF (branch .NE. 0) teb = teb + 0.2*x2b
  END IF
  CALL POPCONTROL1B(branch)
  IF (branch .EQ. 0) dqpb = 0.0_8
  qcb = qcb + (1.0-EXP(-(dt*rate)))*dqpb
  rateb = EXP(-(dt*rate))*qc*dt*dqpb
  CALL POPREAL8(rate)
  f3b = rate*rateb
  rateb = f3*rateb
  CALL POPCONTROL1B(branch)
  IF (branch .EQ. 0) f3b = 0.0_8
  CALL POPCONTROL1B(branch)
  IF (branch .NE. 0) f3b = 0.0_8
  CALL POPCONTROL2B(branch)
  IF (branch .NE. 0) THEN
    IF (branch .EQ. 1) THEN
      x1b = f3b
    ELSE
      x1b = 0.0_8
    END IF
    CALL POPCONTROL1B(branch)
    IF (branch .NE. 0) teb = teb + 0.2*x1b
    f3b = 0.0_8
  END IF
  CALL POPCONTROL1B(branch)
  IF (branch .NE. 0) f3b = 0.0_8
  CALL POPCONTROL2B(branch)
  IF (branch .NE. 0) THEN
    IF (branch .EQ. 1) teb = teb + 0.2*f3b
  END IF
  CALL POPREAL8(f3)
  temp = qcm*iqccrx
  tempb = EXP(-(temp**2))*c00x*2*temp*rateb
  c00xb = (1.0-EXP(-(temp**2)))*rateb
  qcmb = iqccrx*tempb
  iqccrxb = qcm*tempb
  CALL POPCONTROL1B(branch)
  IF (branch .EQ. 0) THEN
    qcb = qcb + qcmb/f
    fb = fb - qc*qcmb/f**2
  END IF
  f2b = c_00*f3*c00xb + f3*iqccrxb/lwcrit
  f2b = 0.5*f2b
  CALL POPREAL8(f2)
  CALL CONS_SUNDQ3_B(te, teb, sundqv2, sundqv3, sundqt1, f2, f2b, f3)
END SUBROUTINE AUTOCONVERSION_LS_B

!  Differentiation of autoconversion_cnv in reverse (adjoint) mode:
!   gradient     of useful results: f qc qp te
!   with respect to varying inputs: f qc te
SUBROUTINE AUTOCONVERSION_CNV_B(dt, qc, qcb, qp, qpb, te, teb, pl, f, fb&
& , sundqv2, sundqv3, sundqt1, c_00, lwcrit, dzet)
  IMPLICIT NONE
!Inputs
  REAL*8, INTENT(IN) :: dt, te, pl, dzet, sundqv2, sundqv3, sundqt1, &
& c_00, lwcrit
  REAL*8 :: teb
!Prognostic
  REAL*8, INTENT(INOUT) :: qc, qp, f
  REAL*8 :: qcb, qpb, fb
!Locals
  REAL*8 :: acf0, acf, c00x, iqccrx, f2, f3, rate, dqp, qcm, dqfac
  REAL*8 :: c00xb, iqccrxb, f2b, f3b, rateb, dqpb, qcmb, dqfacb
  INTRINSIC EXP
  INTRINSIC MIN
  INTRINSIC MAX
  INTEGER :: branch
  REAL*8 :: x4
  REAL*8 :: x3
  REAL*8 :: x2
  REAL*8 :: x1
  REAL*8 :: x2b
  REAL*8 :: tempb
  REAL*8 :: x1b
  REAL*8 :: x4b
  REAL*8 :: temp
!Zero Locals
  f2 = 0.0
  f3 = 0.0
  CALL PUSHREAL8(f2)
  CALL CONS_SUNDQ3(te, sundqv2, sundqv3, sundqt1, f2, f3)
  c00x = c_00*f2*f3
  iqccrx = f2*f3/lwcrit
  IF (f .GT. 0. .AND. qc .GT. 0.) THEN
    qcm = qc/f
    CALL PUSHCONTROL1B(0)
  ELSE
    CALL PUSHCONTROL1B(1)
    qcm = 0.
  END IF
  rate = c00x*(1.0-EXP(-((qcm*iqccrx)**2)))
!Temporary kluge until we can figure a better to make thicker low clouds.
  CALL PUSHREAL8(f3)
  f3 = 1.0
!Implement ramps for gradual change in autoconv
!Thicken low high lat clouds
  IF (pl .GE. 775. .AND. te .LE. 275.) f3 = 0.2
!F3 = max(-0.016 * PL + 13.4, 0.2)
  IF (pl .GE. 825. .AND. te .LE. 282.) f3 = 0.2
!F3 = max(0.11 * TE - 30.02, 0.2)
  IF (pl .GE. 775. .AND. pl .LT. 825. .AND. te .LE. 282. .AND. te .GT. &
&     275.) f3 = 0.2
!F3 = min(max(-0.016*PL + 0.11 * TE - 16.85, 0.2),1.)
  IF (pl .GE. 825. .AND. te .LE. 275.) f3 = 0.2
  IF (pl .LE. 775. .OR. te .GT. 282.) f3 = 1.
!Thin-out low tropical clouds
  IF (pl .GE. 950. .AND. te .GE. 285.) THEN
    IF (0.2*te - 56 .GT. 2.) THEN
      CALL PUSHCONTROL2B(2)
      f3 = 2.
    ELSE
      f3 = 0.2*te - 56
      CALL PUSHCONTROL2B(1)
    END IF
  ELSE
    CALL PUSHCONTROL2B(0)
  END IF
  IF (pl .GE. 925. .AND. te .GE. 290.) THEN
    IF (0.04*pl - 36. .GT. 2.) THEN
      CALL PUSHCONTROL1B(1)
      f3 = 2.
    ELSE
      CALL PUSHCONTROL1B(1)
      f3 = 0.04*pl - 36.
    END IF
  ELSE
    CALL PUSHCONTROL1B(0)
  END IF
  IF (pl .GE. 925. .AND. pl .LT. 950. .AND. te .GT. 285. .AND. te .LT. &
&     290.) THEN
    IF (0.04*pl + 0.2*te - 94. .GT. 2.) THEN
      CALL PUSHCONTROL1B(0)
      x1 = 2.
    ELSE
      x1 = 0.04*pl + 0.2*te - 94.
      CALL PUSHCONTROL1B(1)
    END IF
    IF (x1 .LT. 1.) THEN
      f3 = 1.
      CALL PUSHCONTROL2B(2)
    ELSE
      f3 = x1
      CALL PUSHCONTROL2B(1)
    END IF
  ELSE
    CALL PUSHCONTROL2B(0)
  END IF
  IF (pl .GE. 950. .AND. te .GE. 290.) THEN
    f3 = 2.
    CALL PUSHCONTROL1B(1)
  ELSE
    CALL PUSHCONTROL1B(0)
  END IF
  IF (f3 .LT. 0.1) THEN
    f3 = 0.1
    CALL PUSHCONTROL1B(0)
  ELSE
    CALL PUSHCONTROL1B(1)
    f3 = f3
  END IF
  CALL PUSHREAL8(rate)
  rate = f3*rate
  dqp = qc*(1.0-EXP(-(rate*dt)))
  IF (dqp .LT. 0.0) THEN
    dqp = 0.0
    CALL PUSHCONTROL1B(0)
  ELSE
    CALL PUSHCONTROL1B(1)
    dqp = dqp
  END IF
!Wipe-out warm fogs
  dqfac = 0.
  IF (pl .GE. 975. .AND. te .GE. 280.) THEN
    IF (0.2*te - 56. .GT. 1.) THEN
      CALL PUSHCONTROL1B(0)
      x2 = 1.
    ELSE
      x2 = 0.2*te - 56.
      CALL PUSHCONTROL1B(1)
    END IF
    IF (x2 .LT. 0.) THEN
      dqfac = 0.
      CALL PUSHCONTROL2B(2)
    ELSE
      dqfac = x2
      CALL PUSHCONTROL2B(1)
    END IF
  ELSE
    CALL PUSHCONTROL2B(0)
  END IF
  IF (pl .GE. 950. .AND. te .GE. 285.) THEN
    IF (0.04*pl - 38. .GT. 1.) THEN
      CALL PUSHCONTROL1B(1)
      x3 = 1.
    ELSE
      CALL PUSHCONTROL1B(1)
      x3 = 0.04*pl - 38.
    END IF
    IF (x3 .LT. 0.) THEN
      dqfac = 0.
    ELSE
      dqfac = x3
    END IF
  ELSE
    CALL PUSHCONTROL1B(0)
  END IF
  IF (pl .GE. 950. .AND. pl .LT. 975. .AND. te .GT. 280. .AND. te .LT. &
&     285.) THEN
    IF (0.04*pl + 0.2*te - 95. .GT. 1.) THEN
      CALL PUSHCONTROL1B(0)
      x4 = 1.
    ELSE
      x4 = 0.04*pl + 0.2*te - 95.
      CALL PUSHCONTROL1B(1)
    END IF
    IF (x4 .LT. 0.) THEN
      dqfac = 0.
      CALL PUSHCONTROL2B(2)
    ELSE
      dqfac = x4
      CALL PUSHCONTROL2B(1)
    END IF
  ELSE
    CALL PUSHCONTROL2B(0)
  END IF
  IF (pl .GE. 975. .AND. te .GE. 285.) THEN
    dqfac = 1.
    CALL PUSHCONTROL1B(1)
  ELSE
    CALL PUSHCONTROL1B(0)
  END IF
  IF (dqp .LT. dqfac*qc) THEN
    CALL PUSHCONTROL1B(0)
  ELSE
    CALL PUSHCONTROL1B(1)
  END IF
  dqpb = qpb - qcb
  CALL POPCONTROL1B(branch)
  IF (branch .EQ. 0) THEN
    dqfacb = qc*dqpb
    qcb = qcb + dqfac*dqpb
    dqpb = 0.0_8
  ELSE
    dqfacb = 0.0_8
  END IF
  CALL POPCONTROL1B(branch)
  IF (branch .NE. 0) dqfacb = 0.0_8
  CALL POPCONTROL2B(branch)
  IF (branch .NE. 0) THEN
    IF (branch .EQ. 1) THEN
      x4b = dqfacb
    ELSE
      x4b = 0.0_8
    END IF
    CALL POPCONTROL1B(branch)
    IF (branch .NE. 0) teb = teb + 0.2*x4b
    dqfacb = 0.0_8
  END IF
  CALL POPCONTROL1B(branch)
  IF (branch .NE. 0) dqfacb = 0.0_8
  CALL POPCONTROL2B(branch)
  IF (branch .NE. 0) THEN
    IF (branch .EQ. 1) THEN
      x2b = dqfacb
    ELSE
      x2b = 0.0_8
    END IF
    CALL POPCONTROL1B(branch)
    IF (branch .NE. 0) teb = teb + 0.2*x2b
  END IF
  CALL POPCONTROL1B(branch)
  IF (branch .EQ. 0) dqpb = 0.0_8
  qcb = qcb + (1.0-EXP(-(dt*rate)))*dqpb
  rateb = EXP(-(dt*rate))*qc*dt*dqpb
  CALL POPREAL8(rate)
  f3b = rate*rateb
  rateb = f3*rateb
  CALL POPCONTROL1B(branch)
  IF (branch .EQ. 0) f3b = 0.0_8
  CALL POPCONTROL1B(branch)
  IF (branch .NE. 0) f3b = 0.0_8
  CALL POPCONTROL2B(branch)
  IF (branch .NE. 0) THEN
    IF (branch .EQ. 1) THEN
      x1b = f3b
    ELSE
      x1b = 0.0_8
    END IF
    CALL POPCONTROL1B(branch)
    IF (branch .NE. 0) teb = teb + 0.2*x1b
    f3b = 0.0_8
  END IF
  CALL POPCONTROL1B(branch)
  IF (branch .NE. 0) f3b = 0.0_8
  CALL POPCONTROL2B(branch)
  IF (branch .NE. 0) THEN
    IF (branch .EQ. 1) teb = teb + 0.2*f3b
  END IF
  CALL POPREAL8(f3)
  temp = qcm*iqccrx
  tempb = EXP(-(temp**2))*c00x*2*temp*rateb
  c00xb = (1.0-EXP(-(temp**2)))*rateb
  qcmb = iqccrx*tempb
  iqccrxb = qcm*tempb
  CALL POPCONTROL1B(branch)
  IF (branch .EQ. 0) THEN
    qcb = qcb + qcmb/f
    fb = fb - qc*qcmb/f**2
  END IF
  f2b = c_00*f3*c00xb + f3*iqccrxb/lwcrit
  f2b = 0.5*f2b
  CALL POPREAL8(f2)
  CALL CONS_SUNDQ3_B(te, teb, sundqv2, sundqv3, sundqt1, f2, f2b, f3)
END SUBROUTINE AUTOCONVERSION_CNV_B

!  Differentiation of get_ice_fraction in reverse (adjoint) mode:
!   gradient     of useful results: temp icefrct
!   with respect to varying inputs: temp
SUBROUTINE GET_ICE_FRACTION_B(temp, tempb, t_ice_all, t_ice_max, &
& icefrpwr, icefrct, icefrctb)
  IMPLICIT NONE
!Inputs
  REAL*8, INTENT(IN) :: temp, t_ice_all, t_ice_max
  REAL*8 :: tempb
  INTEGER, INTENT(IN) :: icefrpwr
!Outputs
  REAL*8 :: icefrct
  REAL*8 :: icefrctb
  INTRINSIC MIN
  INTRINSIC MAX
  INTEGER :: branch
  icefrct = 0.00
  IF (temp .LE. t_ice_all) THEN
    CALL PUSHCONTROL2B(2)
    icefrct = 1.000
  ELSE IF (temp .GT. t_ice_all .AND. temp .LE. t_ice_max) THEN
    icefrct = 1.00 - (temp-t_ice_all)/(t_ice_max-t_ice_all)
    CALL PUSHCONTROL2B(1)
  ELSE
    CALL PUSHCONTROL2B(0)
  END IF
  IF (icefrct .GT. 1.00) THEN
    icefrct = 1.00
    CALL PUSHCONTROL1B(0)
  ELSE
    CALL PUSHCONTROL1B(1)
    icefrct = icefrct
  END IF
  IF (icefrct .LT. 0.00) THEN
    icefrct = 0.00
    CALL PUSHCONTROL1B(0)
  ELSE
    CALL PUSHCONTROL1B(1)
    icefrct = icefrct
  END IF
  IF (icefrct .LE. 0.0 .AND. (icefrpwr .EQ. 0.0 .OR. icefrpwr .NE. INT(&
&     icefrpwr))) THEN
    icefrctb = 0.0
  ELSE
    icefrctb = icefrpwr*icefrct**(icefrpwr-1)*icefrctb
  END IF
  CALL POPCONTROL1B(branch)
  IF (branch .EQ. 0) icefrctb = 0.0_8
  CALL POPCONTROL1B(branch)
  IF (branch .EQ. 0) icefrctb = 0.0_8
  CALL POPCONTROL2B(branch)
  IF (branch .NE. 0) THEN
    IF (branch .EQ. 1) tempb = tempb - icefrctb/(t_ice_max-t_ice_all)
  END IF
END SUBROUTINE GET_ICE_FRACTION_B

!  Differentiation of cons_sundq3 in reverse (adjoint) mode:
!   gradient     of useful results: temp f2
!   with respect to varying inputs: temp
SUBROUTINE CONS_SUNDQ3_B(temp, tempb, rate2, rate3, te1, f2, f2b, f3)
  IMPLICIT NONE
!Inputs
  REAL*8, INTENT(IN) :: rate2, rate3, te1, temp
  REAL*8 :: tempb
!Outputs
  REAL*8 :: f2, f3
  REAL*8 :: f2b
!Locals
  REAL*8, PARAMETER :: te0=273.
  REAL*8, PARAMETER :: te2=200.
  REAL*8 :: jump1
  INTRINSIC ABS
  INTRINSIC MIN
  INTEGER :: branch
  REAL*8 :: abs0
  jump1 = (rate2-1.0)/(te0-te1)**0.333
!Ice - phase treatment 
  IF (temp .GE. te0) f2 = 1.0
  IF (temp .GE. te1 .AND. temp .LT. te0) THEN
    IF (te0 - temp .GE. 0.) THEN
      abs0 = te0 - temp
    ELSE
      abs0 = -(te0-temp)
    END IF
    IF (abs0 .GT. 0.0) THEN
!Linearisation security
      f2 = 1.0 + jump1*(te0-temp)**0.3333
      CALL PUSHCONTROL2B(0)
    ELSE
      CALL PUSHCONTROL2B(1)
      f2 = 1.0
    END IF
  ELSE
    CALL PUSHCONTROL2B(2)
  END IF
  IF (temp .LT. te1) THEN
    f2 = rate2 + (rate3-rate2)*(te1-temp)/(te1-te2)
    CALL PUSHCONTROL1B(1)
  ELSE
    CALL PUSHCONTROL1B(0)
  END IF
  IF (f2 .GT. 27.0) f2b = 0.0_8
  CALL POPCONTROL1B(branch)
  IF (branch .NE. 0) THEN
    tempb = tempb - (rate3-rate2)*f2b/(te1-te2)
    f2b = 0.0_8
  END IF
  CALL POPCONTROL2B(branch)
  IF (branch .EQ. 0) tempb = tempb - 0.3333*(te0-temp)**(-0.6667)*jump1*&
&     f2b
END SUBROUTINE CONS_SUNDQ3_B

!  Differentiation of cons_microphys in reverse (adjoint) mode:
!   gradient     of useful results: aa temp bb q_sat alhx3
!   with respect to varying inputs: temp q_sat alhx3
SUBROUTINE CONS_MICROPHYS_B(temp, tempb1, pr, q_sat, q_satb, aa, aab, bb&
& , bbb, cons_h2omw, cons_airmw, cons_rvap, alhx3, alhx3b)
  IMPLICIT NONE
!Inputs
  REAL*8, INTENT(IN) :: temp, q_sat, pr, alhx3
  REAL*8 :: tempb1, q_satb, alhx3b
  REAL*8, INTENT(IN) :: cons_h2omw, cons_airmw, cons_rvap
!Outputs
  REAL*8 :: aa, bb
  REAL*8 :: aab, bbb
!Locals
  REAL*8, PARAMETER :: k_cond=2.4e-2
  REAL*8, PARAMETER :: diffu=2.2e-5
  REAL*8 :: e_sat, epsi
  REAL*8 :: e_satb
  REAL*8 :: temp2
  REAL*8 :: temp1
  REAL*8 :: temp0
  REAL*8 :: tempb0
  REAL*8 :: tempb
  epsi = cons_h2omw/cons_airmw
! (100 converts from mbar to Pa)
  e_sat = 100.*pr*q_sat/(epsi+(1.0-epsi)*q_sat)
  temp1 = k_cond*cons_rvap*temp**2
  temp2 = 1000.*diffu*e_sat
  tempb = cons_rvap*pr*bbb/temp2
  tempb1 = tempb1 + tempb - k_cond*cons_rvap*alhx3**2*2*temp*aab/temp1**&
&   2
  e_satb = -(temp*diffu*1000.*tempb/temp2)
  alhx3b = alhx3b + 2*alhx3*aab/temp1
  temp0 = epsi + (-epsi+1.0)*q_sat
  tempb0 = pr*100.*e_satb/temp0
  q_satb = q_satb + (1.0_8-q_sat*(1.0-epsi)/temp0)*tempb0
END SUBROUTINE CONS_MICROPHYS_B

!  Differentiation of cons_alhx in reverse (adjoint) mode:
!   gradient     of useful results: t alhx3
!   with respect to varying inputs: t alhx3
SUBROUTINE CONS_ALHX_B(t, tb, alhx3, alhx3b, t_ice_max, t_ice_all, &
& cons_alhs, cons_alhl)
  IMPLICIT NONE
!Inputs
  REAL*8, INTENT(IN) :: t, t_ice_max, t_ice_all
  REAL*8 :: tb
  REAL*8, INTENT(IN) :: cons_alhs, cons_alhl
!Outputs
  REAL*8 :: alhx3
  REAL*8 :: alhx3b
  INTEGER :: branch
  IF (t .LT. t_ice_all) THEN
    CALL PUSHCONTROL1B(0)
  ELSE
    CALL PUSHCONTROL1B(1)
  END IF
  IF (t .GT. t_ice_max) THEN
    CALL PUSHCONTROL1B(0)
  ELSE
    CALL PUSHCONTROL1B(1)
  END IF
  IF (t .LE. t_ice_max .AND. t .GE. t_ice_all) THEN
    tb = tb + (cons_alhl-cons_alhs)*alhx3b/(t_ice_max-t_ice_all)
    alhx3b = 0.0_8
  END IF
  CALL POPCONTROL1B(branch)
  IF (branch .EQ. 0) alhx3b = 0.0_8
  CALL POPCONTROL1B(branch)
  IF (branch .EQ. 0) alhx3b = 0.0_8
END SUBROUTINE CONS_ALHX_B

!  Differentiation of ice_settlefall_cnv in reverse (adjoint) mode:
!   gradient     of useful results: f qi qp dz te
!   with respect to varying inputs: f qi dz te
SUBROUTINE ICE_SETTLEFALL_CNV_B(wxr, qi, qib, pl, te, teb, f, fb, &
& cons_rgas, khu, khl, k, dt, dz, dzb, qp, qpb, anv_icefall_c)
  IMPLICIT NONE
!Inputs
  REAL*8, INTENT(IN) :: wxr, pl, te, dz, dt, anv_icefall_c
  REAL*8 :: teb, dzb
  REAL*8, INTENT(IN) :: cons_rgas
  INTEGER, INTENT(IN) :: khu, khl, k
  REAL*8, INTENT(INOUT) :: qi, f, qp
  REAL*8 :: qib, fb, qpb
!Locals
  REAL*8 :: rho, xim, lxim, qixp, vf
  REAL*8 :: rhob, ximb, lximb, qixpb, vfb
  INTRINSIC LOG10
  INTRINSIC MAX
  INTRINSIC MIN
  INTEGER :: branch
  REAL*8 :: tempb0
  REAL*8 :: tempb
  REAL*8 :: max1
! 1000 TAKES TO g m^-3 ; 100 takes mb TO Pa
  rho = 1000.*100.*pl/(cons_rgas*te)
  IF (f .GT. 0. .AND. qi .GT. 0.) THEN
    xim = qi/f*rho
    CALL PUSHCONTROL1B(0)
  ELSE
    xim = 0.
    CALL PUSHCONTROL1B(1)
  END IF
  IF (xim .GT. 0.) THEN
    lxim = LOG10(xim)
    CALL PUSHCONTROL1B(0)
  ELSE
    lxim = 0.0
    CALL PUSHCONTROL1B(1)
  END IF
  vf = 128.6 + 53.2*lxim + 5.5*lxim**2
!VF = VF*100./MAX(PL,10.) ! Reduce/increase fall speeds for high/low pressure (NOT in LC98!!! ) 
! Assume unmodified they represent situation at 100 mb
  IF (wxr .GT. 0.) THEN
    IF (pl .LT. 10.) THEN
      max1 = 10.
    ELSE
      max1 = pl
    END IF
    vf = vf*(100./max1)**wxr
    CALL PUSHCONTROL1B(0)
  ELSE
    CALL PUSHCONTROL1B(1)
  END IF
  vf = vf/100.
  IF (khu .GT. 0 .AND. khl .GT. 0) THEN
    IF (k - 1 .GE. khu .AND. k - 1 .LE. khl) THEN
      vf = 0.01*vf
      CALL PUSHCONTROL2B(2)
    ELSE
      CALL PUSHCONTROL2B(1)
    END IF
  ELSE
    CALL PUSHCONTROL2B(0)
  END IF
  vf = anv_icefall_c*vf
  qixp = qi*(vf*dt/dz)
  IF (qixp .GT. qi) THEN
    qixp = qi
    CALL PUSHCONTROL1B(0)
  ELSE
    CALL PUSHCONTROL1B(1)
    qixp = qixp
  END IF
  IF (qixp .LT. 0.0) THEN
    CALL PUSHCONTROL1B(0)
  ELSE
    CALL PUSHCONTROL1B(1)
  END IF
  qixpb = qpb - qib
  CALL POPCONTROL1B(branch)
  IF (branch .EQ. 0) qixpb = 0.0_8
  CALL POPCONTROL1B(branch)
  IF (branch .EQ. 0) THEN
    qib = qib + qixpb
    qixpb = 0.0_8
  END IF
  tempb0 = dt*qixpb/dz
  qib = qib + vf*tempb0
  vfb = qi*tempb0
  dzb = dzb - qi*vf*tempb0/dz
  vfb = anv_icefall_c*vfb
  CALL POPCONTROL2B(branch)
  IF (branch .NE. 0) THEN
    IF (branch .NE. 1) vfb = 0.01*vfb
  END IF
  vfb = vfb/100.
  CALL POPCONTROL1B(branch)
  IF (branch .EQ. 0) vfb = (100./max1)**wxr*vfb
  lximb = (5.5*2*lxim+53.2)*vfb
  CALL POPCONTROL1B(branch)
  IF (branch .EQ. 0) THEN
    ximb = lximb/(xim*LOG(10.0))
  ELSE
    ximb = 0.0_8
  END IF
  CALL POPCONTROL1B(branch)
  IF (branch .EQ. 0) THEN
    tempb = ximb/f
    qib = qib + rho*tempb
    rhob = qi*tempb
    fb = fb - qi*rho*tempb/f
  ELSE
    rhob = 0.0_8
  END IF
  teb = teb - pl*100.*1000.*rhob/(cons_rgas*te**2)
END SUBROUTINE ICE_SETTLEFALL_CNV_B

!  Differentiation of ice_settlefall_ls in reverse (adjoint) mode:
!   gradient     of useful results: f qi qp dz te
!   with respect to varying inputs: f qi dz te
SUBROUTINE ICE_SETTLEFALL_LS_B(wxr, qi, qib, pl, te, teb, f, fb, &
& cons_rgas, khu, khl, k, dt, dz, dzb, qp, qpb, ls_icefall_c)
  IMPLICIT NONE
!Inputs
  REAL*8, INTENT(IN) :: wxr, pl, te, dz, dt, ls_icefall_c
  REAL*8 :: teb, dzb
  REAL*8, INTENT(IN) :: cons_rgas
  INTEGER, INTENT(IN) :: khu, khl, k
  REAL*8, INTENT(INOUT) :: qi, f, qp
  REAL*8 :: qib, fb, qpb
!Locals
  REAL*8 :: rho, xim, lxim, qixp, vf
  REAL*8 :: rhob, ximb, qixpb, vfb
  INTRINSIC LOG10
  INTRINSIC ABS
  INTRINSIC MAX
  INTRINSIC MIN
  INTEGER :: branch
  REAL*8 :: tempb2
  REAL*8 :: tempb1
  REAL*8 :: tempb0
  REAL*8 :: tempb
  REAL*8 :: abs0
  REAL*8 :: max1
! 1000 TAKES TO g m^-3 ; 100 takes mb TO Pa
  rho = 1000.*100.*pl/(cons_rgas*te)
  IF (f .GT. 0. .AND. qi .GT. 0.) THEN
    xim = qi/f*rho
    CALL PUSHCONTROL1B(0)
  ELSE
    xim = 0.
    CALL PUSHCONTROL1B(1)
  END IF
  IF (xim .GE. 0.) THEN
    abs0 = xim
  ELSE
    abs0 = -xim
  END IF
  IF (abs0 .GT. 0.0) THEN
!Linearisation security
    vf = 109.0*xim**0.16
    CALL PUSHCONTROL1B(0)
  ELSE
    vf = 0.0
    CALL PUSHCONTROL1B(1)
  END IF
!VF = VF*100./MAX(PL,10.) ! Reduce/increase fall speeds for high/low pressure (NOT in LC98!!! ) 
! Assume unmodified they represent situation at 100 mb
  IF (wxr .GT. 0.) THEN
    IF (pl .LT. 10.) THEN
      max1 = 10.
    ELSE
      max1 = pl
    END IF
    vf = vf*(100./max1)**wxr
    CALL PUSHCONTROL1B(0)
  ELSE
    CALL PUSHCONTROL1B(1)
  END IF
  vf = vf/100.
  IF (khu .GT. 0 .AND. khl .GT. 0) THEN
    IF (k - 1 .GE. khu .AND. k - 1 .LE. khl) THEN
      vf = 0.01*vf
      CALL PUSHCONTROL2B(2)
    ELSE
      CALL PUSHCONTROL2B(1)
    END IF
  ELSE
    CALL PUSHCONTROL2B(0)
  END IF
  vf = ls_icefall_c*vf
  qixp = qi*(vf*dt/dz)
  IF (qixp .GT. qi) THEN
    qixp = qi
    CALL PUSHCONTROL1B(0)
  ELSE
    CALL PUSHCONTROL1B(1)
    qixp = qixp
  END IF
  IF (qixp .LT. 0.0) THEN
    qixp = 0.0
    CALL PUSHCONTROL1B(0)
  ELSE
    CALL PUSHCONTROL1B(1)
    qixp = qixp
  END IF
  CALL PUSHREAL8(qi)
  qi = qi - qixp
  IF (qi + qixp .GT. 0.) THEN
    tempb1 = fb/(qi+qixp)
    tempb2 = -(qi*f*tempb1/(qi+qixp))
    qib = qib + tempb2 + f*tempb1
    qixpb = tempb2
    fb = qi*tempb1
  ELSE
    qixpb = 0.0_8
  END IF
  CALL POPREAL8(qi)
  qixpb = qixpb + qpb - qib
  CALL POPCONTROL1B(branch)
  IF (branch .EQ. 0) qixpb = 0.0_8
  CALL POPCONTROL1B(branch)
  IF (branch .EQ. 0) THEN
    qib = qib + qixpb
    qixpb = 0.0_8
  END IF
  tempb0 = dt*qixpb/dz
  qib = qib + vf*tempb0
  vfb = qi*tempb0
  dzb = dzb - qi*vf*tempb0/dz
  vfb = ls_icefall_c*vfb
  CALL POPCONTROL2B(branch)
  IF (branch .NE. 0) THEN
    IF (branch .NE. 1) vfb = 0.01*vfb
  END IF
  vfb = vfb/100.
  CALL POPCONTROL1B(branch)
  IF (branch .EQ. 0) vfb = (100./max1)**wxr*vfb
  CALL POPCONTROL1B(branch)
  IF (branch .EQ. 0) THEN
    ximb = 109.0*0.16*xim**(-0.84)*vfb
  ELSE
    ximb = 0.0_8
  END IF
  CALL POPCONTROL1B(branch)
  IF (branch .EQ. 0) THEN
    tempb = ximb/f
    qib = qib + rho*tempb
    rhob = qi*tempb
    fb = fb - qi*rho*tempb/f
  ELSE
    rhob = 0.0_8
  END IF
  teb = teb - pl*100.*1000.*rhob/(cons_rgas*te**2)
END SUBROUTINE ICE_SETTLEFALL_LS_B

!  Differentiation of precipandevap in reverse (adjoint) mode:
!   gradient     of useful results: evap_dd_above_out aa qv bb
!                subl_dd_above_out qcl pfi_above_out dze qddf3
!                pfl_above_out te
!   with respect to varying inputs: aa area pfl_above_in qv pfi_above_in
!                bb evap_dd_above_in qcl qpi qpl subl_dd_above_in
!                dze qddf3 te
SUBROUTINE PRECIPANDEVAP_B(k, ktop, lm, dt, frland, rhcr3, qpl, qplb, &
& qpi, qpib, qcl, qclb, qci, te, teb, qv, qvb, mass, imass, pl, dze, &
& dzeb, qddf3, qddf3b, aa, aab, bb, bbb, area, areab, pfl_above_in, &
& pfl_above_inb, pfl_above_out, pfl_above_outb, pfi_above_in, &
& pfi_above_inb, pfi_above_out, pfi_above_outb, evap_dd_above_in, &
& evap_dd_above_inb, evap_dd_above_out, evap_dd_above_outb, &
& subl_dd_above_in, subl_dd_above_inb, subl_dd_above_out, &
& subl_dd_above_outb, envfc, ddrfc, cons_alhf, cons_alhs, cons_alhl, &
& cons_cp, cons_tice, cons_h2omw, cons_airmw, revap_off_p, c_acc, c_ev_r&
& , c_ev_s, rho_w, estblx)
  IMPLICIT NONE
!Inputs
  INTEGER, INTENT(IN) :: k, lm, ktop
  REAL*8, INTENT(IN) :: dt, mass, imass, pl, aa, bb, rhcr3, dze, qddf3, &
& area, frland, envfc, ddrfc
  REAL*8 :: aab, bbb, dzeb, qddf3b, areab
  REAL*8, INTENT(IN) :: cons_alhf, cons_alhs, cons_alhl, cons_cp, &
& cons_tice, cons_h2omw, cons_airmw
  REAL*8, INTENT(IN) :: revap_off_p
  REAL*8, INTENT(IN) :: c_acc, c_ev_r, c_ev_s, rho_w
  REAL*8, INTENT(IN) :: estblx(:)
!Prognostics
  REAL*8, INTENT(INOUT) :: qv, qpl, qpi, qcl, qci, te
  REAL*8 :: qvb, qplb, qpib, qclb, teb
  REAL*8, INTENT(INOUT) :: pfl_above_in, pfl_above_out, pfi_above_in, &
& pfi_above_out
  REAL*8 :: pfl_above_inb, pfl_above_outb, pfi_above_inb, pfi_above_outb
  REAL*8, INTENT(INOUT) :: evap_dd_above_in, evap_dd_above_out, &
& subl_dd_above_in, subl_dd_above_out
  REAL*8 :: evap_dd_above_inb, evap_dd_above_outb, subl_dd_above_inb, &
& subl_dd_above_outb
!Locals
  INTEGER :: ns, nsmx, itr, l
  REAL*8 :: pfi, pfl, qs, dqs, envfrac, tko, qko, qstko, dqstko, rh_box&
& , t_ed, qplko, qpiko
  REAL*8 :: pfib, pflb, qsb, dqsb, tkob, qkob, qstkob, dqstkob, rh_boxb&
& , t_edb
  REAL*8 :: ifactor, rainrat0, snowrat0, fallrn, fallsn, vesn, vern, &
& nrain, nsnow, efactor
  REAL*8 :: ifactorb, rainrat0b, snowrat0b, fallrnb, fallsnb, vesnb, &
& vernb, efactorb
  REAL*8 :: tinlayerrn, diamrn, droprad, tinlayersn, diamsn, flakrad
  REAL*8 :: tinlayerrnb, diamrnb, dropradb, tinlayersnb, diamsnb, &
& flakradb
  REAL*8 :: evap, subl, accr, mltfrz, evapx, sublx, evap_dd, subl_dd, &
& ddfract, landseaf
  REAL*8 :: evapb, sublb, accrb, mltfrzb, evap_ddb, subl_ddb
  REAL*8 :: tau_frz, tau_mlt
!m/s
  REAL*8, PARAMETER :: trmv_l=1.0
  LOGICAL, PARAMETER :: taneff=.false.
!Fraction of precip falling through "environment" vs through cloud
  REAL*8, PARAMETER :: b_sub=1.00
  INTRINSIC MAX
  INTRINSIC MIN
  INTRINSIC EXP
  INTEGER :: branch
  REAL*8 :: temp3
  REAL*8 :: temp2
  REAL*8 :: temp1
  REAL*8 :: temp0
  REAL*8 :: tempb8
  REAL*8 :: tempb7
  REAL*8 :: tempb6
  REAL*8 :: tempb5
  REAL*8 :: tempb4
  REAL*8 :: tempb3
  REAL*8 :: tempb2
  REAL*8 :: tempb1
  REAL*8 :: tempb0
  REAL*8 :: tempb
  REAL*8 :: temp
  REAL*8 :: temp4
  envfrac = envfc
  IF (area .GT. 0.) THEN
    ifactor = 1./area
    CALL PUSHCONTROL1B(1)
  ELSE
    ifactor = 1.00
    CALL PUSHCONTROL1B(0)
  END IF
  IF (ifactor .LT. 1.) THEN
    ifactor = 1.
    CALL PUSHCONTROL1B(0)
  ELSE
    CALL PUSHCONTROL1B(1)
    ifactor = ifactor
  END IF
!Start at top of precip column:
!
!   a) Accrete                   
!   b) Evaporate/Sublimate  
!   c) Rain/Snow-out to next level down 
!   d) return to (a)
!Update saturated humidity
  CALL DQSATS_BAC(dqs, qs, te, pl, estblx, cons_h2omw, cons_airmw)
  ddfract = ddrfc
  IF (k .EQ. ktop) THEN
    evap_dd = 0.
    subl_dd = 0.
    CALL PUSHCONTROL1B(0)
  ELSE
    CALL PUSHREAL8(qpl)
    qpl = qpl + pfl_above_in*imass
    CALL PUSHREAL8(qpi)
    qpi = qpi + pfi_above_in*imass
    accr = b_sub*c_acc*(qpl*mass)*qcl
    IF (accr .GT. qcl) THEN
      accr = qcl
      CALL PUSHCONTROL1B(0)
    ELSE
      CALL PUSHCONTROL1B(1)
      accr = accr
    END IF
    CALL PUSHREAL8(qpl)
    qpl = qpl + accr
    CALL PUSHREAL8(qcl)
    qcl = qcl - accr
!Accretion of liquid condensate by falling ice/snow
    accr = b_sub*c_acc*(qpi*mass)*qcl
    IF (accr .GT. qcl) THEN
      accr = qcl
      CALL PUSHCONTROL1B(0)
    ELSE
      CALL PUSHCONTROL1B(1)
      accr = accr
    END IF
    CALL PUSHREAL8(qpi)
    qpi = qpi + accr
!! Liquid freezes when accreted by snow
    CALL PUSHREAL8(te)
    te = te + cons_alhf*accr/cons_cp
    rainrat0 = ifactor*qpl*mass/dt
    snowrat0 = ifactor*qpi*mass/dt
    CALL PUSHREAL8(diamrn)
    CALL MARSHPALM(rainrat0, pl, diamrn, nrain, fallrn, vern)
    CALL PUSHREAL8(diamsn)
    CALL MARSHPALM(snowrat0, pl, diamsn, nsnow, fallsn, vesn)
    tinlayerrn = dze/(fallrn+0.01)
    tinlayersn = dze/(fallsn+0.01)
!Melting of Frozen precipitation      
! time scale for freezing (s). 
    tau_frz = 5000.
    IF (te .GT. cons_tice .AND. te .LE. cons_tice + 5.) THEN
      mltfrz = tinlayersn*qpi*(te-cons_tice)/tau_frz
      IF (qpi .GT. mltfrz) THEN
        CALL PUSHCONTROL1B(0)
        mltfrz = mltfrz
      ELSE
        mltfrz = qpi
        CALL PUSHCONTROL1B(1)
      END IF
      CALL PUSHREAL8(te)
      te = te - cons_alhf*mltfrz/cons_cp
      CALL PUSHREAL8(qpl)
      qpl = qpl + mltfrz
      CALL PUSHREAL8(qpi)
      qpi = qpi - mltfrz
      CALL PUSHCONTROL1B(0)
    ELSE
      CALL PUSHCONTROL1B(1)
    END IF
    IF (te .GT. cons_tice + 5.) THEN
! Go Ahead and melt any snow/hail left above 5 C 
      mltfrz = qpi
      te = te - cons_alhf*mltfrz/cons_cp
      CALL PUSHREAL8(qpl)
      qpl = qpl + mltfrz
      CALL PUSHREAL8(qpi)
      qpi = qpi - mltfrz
      CALL PUSHCONTROL1B(0)
    ELSE
      CALL PUSHCONTROL1B(1)
    END IF
    IF (k .GE. lm - 1) THEN
      IF (te .GT. cons_tice + 0.) THEN
! Go Ahead and melt any snow/hail left above 0 C in lowest layers 
        mltfrz = qpi
        te = te - cons_alhf*mltfrz/cons_cp
        CALL PUSHREAL8(qpl)
        qpl = qpl + mltfrz
        CALL PUSHREAL8(qpi)
        qpi = qpi - mltfrz
        CALL PUSHCONTROL2B(0)
      ELSE
        CALL PUSHCONTROL2B(1)
      END IF
    ELSE
      CALL PUSHCONTROL2B(2)
    END IF
!Freezing of liquid precipitation      
    IF (te .LE. cons_tice) THEN
      te = te + cons_alhf*qpl/cons_cp
      CALL PUSHREAL8(qpi)
      qpi = qpl + qpi
      CALL PUSHREAL8(qpl)
      qpl = 0.
      CALL PUSHCONTROL1B(1)
    ELSE
      CALL PUSHCONTROL1B(0)
    END IF
!In the exp below, evaporation time scale is determined "microphysically" from temp, 
!press, and drop size. In this context C_EV becomes a dimensionless fudge-fraction. 
!Also remember that these microphysics are still only for liquid.
    qko = qv
    tko = te
!do itr = 1,1
    dqstko = dqs
    qstko = qs + dqstko*(tko-te)
    IF (qstko .LT. 1.0e-7) THEN
      qstko = 1.0e-7
      CALL PUSHCONTROL1B(0)
    ELSE
      CALL PUSHCONTROL1B(1)
      qstko = qstko
    END IF
    rh_box = qko/qstko
    IF (rh_box .LT. rhcr3) THEN
      efactor = rho_w*(aa+bb)/(rhcr3-rh_box)
      CALL PUSHCONTROL1B(0)
    ELSE
      efactor = 9.99e9
      CALL PUSHCONTROL1B(1)
    END IF
    landseaf = 1.00
!Rain falling
    IF (rh_box .LT. rhcr3 .AND. diamrn .GT. 0.00 .AND. pl .GT. 100. &
&       .AND. pl .LT. revap_off_p) THEN
      droprad = 0.5*diamrn
      t_ed = efactor*droprad**2
      CALL PUSHREAL8(t_ed)
      t_ed = t_ed*(1.0+dqstko*cons_alhl/cons_cp)
      evap = qpl*(1.0-EXP(-(c_ev_r*vern*landseaf*envfrac*tinlayerrn/t_ed&
&       )))
      CALL PUSHCONTROL1B(0)
    ELSE
      evap = 0.0
      CALL PUSHCONTROL1B(1)
    END IF
!Snow falling
    IF (rh_box .LT. rhcr3 .AND. diamsn .GT. 0.00 .AND. pl .GT. 100. &
&       .AND. pl .LT. revap_off_p) THEN
      flakrad = 0.5*diamsn
      CALL PUSHREAL8(t_ed)
      t_ed = efactor*flakrad**2
      CALL PUSHREAL8(t_ed)
      t_ed = t_ed*(1.0+dqstko*cons_alhs/cons_cp)
      subl = qpi*(1.0-EXP(-(c_ev_s*vesn*landseaf*envfrac*tinlayersn/t_ed&
&       )))
      CALL PUSHCONTROL1B(0)
    ELSE
      subl = 0.0
      CALL PUSHCONTROL1B(1)
    END IF
!if (itr == 1) then 
!   EVAPx  = EVAP
!   SUBLx  = SUBL
!else
!   EVAP   = (EVAP+EVAPx) /2.0
!   SUBL   = (SUBL+SUBLx) /2.0
!endif
!enddo
!Put some re-evap/re-subl precip in to a \quote{downdraft} to be applied later
    evap_dd = evap_dd_above_in + ddfract*evap*mass
    subl_dd = subl_dd_above_in + ddfract*subl*mass
    CALL PUSHCONTROL1B(1)
  END IF
  sublb = qvb - cons_alhs*teb/cons_cp
  evapb = qvb - cons_alhl*teb/cons_cp
  subl_ddb = qddf3*sublb/mass + subl_dd_above_outb
  evap_ddb = qddf3*evapb/mass + evap_dd_above_outb
  pfib = pfi_above_outb
  pflb = pfl_above_outb
  qddf3b = qddf3b + evap_dd*evapb/mass + subl_dd*sublb/mass
  CALL POPCONTROL1B(branch)
  IF (branch .EQ. 0) THEN
    qpib = mass*pfib
    qplb = mass*pflb
    pfl_above_inb = 0.0_8
    pfi_above_inb = 0.0_8
    evap_dd_above_inb = 0.0_8
    subl_dd_above_inb = 0.0_8
    dqsb = 0.0_8
    qsb = 0.0_8
    ifactorb = 0.0_8
  ELSE
    qpib = mass*pfib
    qplb = mass*pflb
    evapb = qvb - cons_alhl*teb/cons_cp
    sublb = qvb - cons_alhs*teb/cons_cp
    sublb = ddfract*mass*subl_ddb - qpib + (1.0_8-ddfract)*sublb
    subl_dd_above_inb = subl_ddb
    evapb = ddfract*mass*evap_ddb - qplb + (1.0_8-ddfract)*evapb
    evap_dd_above_inb = evap_ddb
    CALL POPCONTROL1B(branch)
    IF (branch .EQ. 0) THEN
      temp2 = vesn*tinlayersn/t_ed
      temp4 = c_ev_s*landseaf*envfrac
      temp3 = -(temp4*temp2)
      tempb8 = temp4*EXP(temp3)*qpi*sublb/t_ed
      qpib = qpib + (1.0-EXP(temp3))*sublb
      vesnb = tinlayersn*tempb8
      tinlayersnb = vesn*tempb8
      t_edb = -(temp2*tempb8)
      CALL POPREAL8(t_ed)
      dqstkob = cons_alhs*t_ed*t_edb/cons_cp
      t_edb = (cons_alhs*(dqstko/cons_cp)+1.0)*t_edb
      CALL POPREAL8(t_ed)
      efactorb = flakrad**2*t_edb
      flakradb = efactor*2*flakrad*t_edb
      diamsnb = 0.5*flakradb
    ELSE
      dqstkob = 0.0_8
      efactorb = 0.0_8
      diamsnb = 0.0_8
      vesnb = 0.0_8
      tinlayersnb = 0.0_8
    END IF
    CALL POPCONTROL1B(branch)
    IF (branch .EQ. 0) THEN
      temp = vern*tinlayerrn/t_ed
      temp1 = c_ev_r*landseaf*envfrac
      temp0 = -(temp1*temp)
      tempb7 = temp1*EXP(temp0)*qpl*evapb/t_ed
      qplb = qplb + (1.0-EXP(temp0))*evapb
      vernb = tinlayerrn*tempb7
      tinlayerrnb = vern*tempb7
      t_edb = -(temp*tempb7)
      CALL POPREAL8(t_ed)
      dqstkob = dqstkob + cons_alhl*t_ed*t_edb/cons_cp
      t_edb = (cons_alhl*(dqstko/cons_cp)+1.0)*t_edb
      efactorb = efactorb + droprad**2*t_edb
      dropradb = efactor*2*droprad*t_edb
      diamrnb = 0.5*dropradb
    ELSE
      diamrnb = 0.0_8
      vernb = 0.0_8
      tinlayerrnb = 0.0_8
    END IF
    CALL POPCONTROL1B(branch)
    IF (branch .EQ. 0) THEN
      tempb6 = rho_w*efactorb/(rhcr3-rh_box)
      aab = aab + tempb6
      bbb = bbb + tempb6
      rh_boxb = (aa+bb)*tempb6/(rhcr3-rh_box)
    ELSE
      rh_boxb = 0.0_8
    END IF
    qkob = rh_boxb/qstko
    qstkob = -(qko*rh_boxb/qstko**2)
    CALL POPCONTROL1B(branch)
    IF (branch .EQ. 0) qstkob = 0.0_8
    qsb = qstkob
    dqstkob = dqstkob + (tko-te)*qstkob
    tkob = dqstko*qstkob
    teb = teb + tkob - dqstko*qstkob
    dqsb = dqstkob
    qvb = qvb + qkob
    CALL POPCONTROL1B(branch)
    IF (branch .NE. 0) THEN
      CALL POPREAL8(qpl)
      CALL POPREAL8(qpi)
      qplb = cons_alhf*teb/cons_cp + qpib
    END IF
    CALL POPCONTROL2B(branch)
    IF (branch .EQ. 0) THEN
      CALL POPREAL8(qpi)
      mltfrzb = qplb - cons_alhf*teb/cons_cp - qpib
      CALL POPREAL8(qpl)
      qpib = qpib + mltfrzb
    END IF
    CALL POPCONTROL1B(branch)
    IF (branch .EQ. 0) THEN
      CALL POPREAL8(qpi)
      mltfrzb = qplb - cons_alhf*teb/cons_cp - qpib
      CALL POPREAL8(qpl)
      qpib = qpib + mltfrzb
    END IF
    CALL POPCONTROL1B(branch)
    IF (branch .EQ. 0) THEN
      CALL POPREAL8(qpi)
      mltfrzb = qplb - cons_alhf*teb/cons_cp - qpib
      CALL POPREAL8(qpl)
      CALL POPREAL8(te)
      CALL POPCONTROL1B(branch)
      IF (branch .NE. 0) THEN
        qpib = qpib + mltfrzb
        mltfrzb = 0.0_8
      END IF
      tempb5 = (te-cons_tice)*mltfrzb/tau_frz
      tinlayersnb = tinlayersnb + qpi*tempb5
      qpib = qpib + tinlayersn*tempb5
      teb = teb + tinlayersn*qpi*mltfrzb/tau_frz
    END IF
    tempb2 = tinlayerrnb/(fallrn+0.01)
    tempb1 = tinlayersnb/(fallsn+0.01)
    dzeb = dzeb + tempb2 + tempb1
    fallsnb = -(dze*tempb1/(fallsn+0.01))
    fallrnb = -(dze*tempb2/(fallrn+0.01))
    CALL POPREAL8(diamsn)
    CALL MARSHPALM_B(snowrat0, snowrat0b, pl, diamsn, diamsnb, nsnow, &
&              fallsn, fallsnb, vesn, vesnb)
    CALL POPREAL8(diamrn)
    CALL MARSHPALM_B(rainrat0, rainrat0b, pl, diamrn, diamrnb, nrain, &
&              fallrn, fallrnb, vern, vernb)
    tempb3 = mass*snowrat0b/dt
    qpib = qpib + ifactor*tempb3
    tempb4 = mass*rainrat0b/dt
    ifactorb = qpl*tempb4 + qpi*tempb3
    qplb = qplb + ifactor*tempb4
    CALL POPREAL8(te)
    accrb = qpib - qclb + cons_alhf*teb/cons_cp
    CALL POPREAL8(qpi)
    CALL POPCONTROL1B(branch)
    IF (branch .EQ. 0) THEN
      qclb = qclb + accrb
      accrb = 0.0_8
    END IF
    tempb0 = b_sub*c_acc*mass*accrb
    qpib = qpib + qcl*tempb0
    qclb = qclb + qpi*tempb0
    CALL POPREAL8(qcl)
    accrb = qplb - qclb
    CALL POPREAL8(qpl)
    CALL POPCONTROL1B(branch)
    IF (branch .EQ. 0) THEN
      qclb = qclb + accrb
      accrb = 0.0_8
    END IF
    tempb = b_sub*c_acc*mass*accrb
    qplb = qplb + qcl*tempb
    qclb = qclb + qpl*tempb
    CALL POPREAL8(qpi)
    pfi_above_inb = imass*qpib
    CALL POPREAL8(qpl)
    pfl_above_inb = imass*qplb
  END IF
  CALL DQSATS_BAC_B(dqs, dqsb, qs, qsb, te, teb, pl, estblx, cons_h2omw&
&             , cons_airmw)
  CALL POPCONTROL1B(branch)
  IF (branch .EQ. 0) ifactorb = 0.0_8
  CALL POPCONTROL1B(branch)
  IF (branch .EQ. 0) THEN
    areab = 0.0_8
  ELSE
    areab = -(ifactorb/area**2)
  END IF
END SUBROUTINE PRECIPANDEVAP_B

!  Differentiation of marshpalm in reverse (adjoint) mode:
!   gradient     of useful results: diam3 w ve
!   with respect to varying inputs: rain
SUBROUTINE MARSHPALM_B(rain, rainb, pr, diam3, diam3b, ntotal, w, wb, ve&
& , veb)
  IMPLICIT NONE
!Inputs
! in kg m^-2 s^-1, mbar
  REAL*8, INTENT(IN) :: rain, pr
  REAL*8 :: rainb
!Outputs
  REAL*8 :: diam3, ntotal, w, ve
  REAL*8 :: diam3b, wb, veb
!Locals
  INTEGER :: iqd
!cm^-3
  REAL*8, PARAMETER :: n0=0.08
  REAL*8 :: rain_day, slopr, diam1
  REAL*8 :: rain_dayb
  REAL*8 :: rx(8), d3x(8)
  INTRINSIC SQRT
  INTRINSIC MAX
  INTEGER :: branch
!Marshall-Palmer sizes at different rain-rates: avg(D^3)
!RX = (/ 0.   , 5.   , 20.  , 80.  , 320. , 1280., 5120., 20480. /)  ! rain per in mm/day
  rx(1) = 0.
  rx(2) = 5.
  rx(3) = 20.
  rx(4) = 80.
  rx(5) = 320.
  rx(6) = 1280.
  rx(7) = 5120.
  rx(8) = 20480.
!D3X= (/ 0.019, 0.032, 0.043, 0.057, 0.076, 0.102, 0.137, 0.183  /)
  d3x(1) = 0.019
  d3x(2) = 0.032
  d3x(3) = 0.043
  d3x(4) = 0.057
  d3x(5) = 0.076
  d3x(6) = 0.102
  d3x(7) = 0.137
  d3x(8) = 0.183
  rain_day = rain*3600.*24.
  IF (rain_day .LE. 0.00) diam3 = 0.00
  DO iqd=1,7
    IF (rain_day .LE. rx(iqd+1) .AND. rain_day .GT. rx(iqd)) THEN
      CALL PUSHREAL8(slopr)
      slopr = (d3x(iqd+1)-d3x(iqd))/(rx(iqd+1)-rx(iqd))
      diam3 = d3x(iqd) + (rain_day-rx(iqd))*slopr
      CALL PUSHCONTROL1B(1)
    ELSE
      CALL PUSHCONTROL1B(0)
    END IF
  END DO
  IF (rain_day .GE. rx(8)) THEN
    diam3 = d3x(8)
    CALL PUSHCONTROL1B(1)
  ELSE
    CALL PUSHCONTROL1B(0)
  END IF
  diam3 = 0.664*diam3
  w = (2483.8*diam3+80.)*SQRT(1000./pr)
  IF (0.99*w/100. .LT. 1.000) THEN
    CALL PUSHCONTROL1B(0)
  ELSE
    CALL PUSHCONTROL1B(1)
  END IF
  wb = wb/100.
  diam3b = diam3b/100.
  CALL POPCONTROL1B(branch)
  IF (branch .NE. 0) wb = wb + 0.99*veb/100.
  diam3b = diam3b + SQRT(1000./pr)*2483.8*wb
  diam3b = 0.664*diam3b
  CALL POPCONTROL1B(branch)
  IF (branch .NE. 0) diam3b = 0.0_8
  rain_dayb = 0.0_8
  DO iqd=7,1,-1
    CALL POPCONTROL1B(branch)
    IF (branch .NE. 0) THEN
      rain_dayb = rain_dayb + slopr*diam3b
      CALL POPREAL8(slopr)
      diam3b = 0.0_8
    END IF
  END DO
  rainb = 24.*3600.*rain_dayb
END SUBROUTINE MARSHPALM_B

!  Differentiation of dqsat_bac in reverse (adjoint) mode:
!   gradient     of useful results: temp dqsi qssi
!   with respect to varying inputs: temp dqsi qssi
SUBROUTINE DQSAT_BAC_B(dqsi, dqsib, qssi, qssib, temp, tempb, plo, im, &
& jm, lm, estblx, cons_h2omw, cons_airmw)
  IMPLICIT NONE
!Inputs
  INTEGER :: im, jm, lm
  REAL*8, DIMENSION(im, jm, lm) :: temp, plo
  REAL*8, DIMENSION(im, jm, lm) :: tempb
  REAL*8 :: estblx(:)
  REAL*8 :: cons_h2omw, cons_airmw
!Outputs
  REAL*8, DIMENSION(im, jm, lm) :: dqsi, qssi
  REAL*8, DIMENSION(im, jm, lm) :: dqsib, qssib
!Locals
  REAL*8, PARAMETER :: max_mixing_ratio=1.0
  REAL*8 :: esfac
  INTEGER :: i, j, k
  REAL*8 :: tl, tt, ti, dqsat, qsat, dqq, qq, pl, pp, dd
  REAL*8 :: tlb, ttb, tib, dqsatb, qsatb, qqb, ddb
  INTEGER :: it
  INTEGER, PARAMETER :: degsubs=100
  REAL*8, PARAMETER :: tmintbl=150.0, tmaxtbl=333.0
  INTEGER, PARAMETER :: tablesize=NINT(tmaxtbl-tmintbl)*degsubs+1
  INTRINSIC NINT
  INTRINSIC INT
  INTEGER :: branch
  REAL*8 :: temp0
  esfac = cons_h2omw/cons_airmw
  DO k=1,lm
    DO j=1,jm
      DO i=1,im
        tl = temp(i, j, k)
        pl = plo(i, j, k)
        pp = pl*100.0
        IF (tl .LE. tmintbl) THEN
          ti = tmintbl
          CALL PUSHCONTROL2B(0)
        ELSE IF (tl .GE. tmaxtbl - .001) THEN
          ti = tmaxtbl - .001
          CALL PUSHCONTROL2B(1)
        ELSE
          ti = tl
          CALL PUSHCONTROL2B(2)
        END IF
        tt = (ti-tmintbl)*degsubs + 1
        it = INT(tt)
        CALL PUSHREAL8(dqq)
        dqq = estblx(it+1) - estblx(it)
        CALL PUSHREAL8(qq)
        qq = (tt-it)*dqq + estblx(it)
        IF (pp .LE. qq) THEN
          CALL PUSHCONTROL1B(0)
        ELSE
          CALL PUSHCONTROL1B(1)
        END IF
      END DO
    END DO
  END DO
  DO k=lm,1,-1
    DO j=jm,1,-1
      DO i=im,1,-1
        qsatb = qssib(i, j, k)
        qssib(i, j, k) = 0.0_8
        dqsatb = dqsib(i, j, k)
        dqsib(i, j, k) = 0.0_8
        CALL POPCONTROL1B(branch)
        IF (branch .EQ. 0) THEN
          qqb = 0.0_8
        ELSE
          pl = plo(i, j, k)
          pp = pl*100.0
          dd = 1.0/(pp-(1.0-esfac)*qq)
          ddb = esfac*qq*qsatb + esfac*degsubs*dqq*pp*2*dd*dqsatb
          temp0 = pp - (-esfac+1.0)*qq
          qqb = (1.0-esfac)*ddb/temp0**2 + esfac*dd*qsatb
        END IF
        CALL POPREAL8(qq)
        ttb = dqq*qqb
        CALL POPREAL8(dqq)
        tib = degsubs*ttb
        CALL POPCONTROL2B(branch)
        IF (branch .EQ. 0) THEN
          tlb = 0.0_8
        ELSE IF (branch .EQ. 1) THEN
          tlb = 0.0_8
        ELSE
          tlb = tib
        END IF
        tempb(i, j, k) = tempb(i, j, k) + tlb
      END DO
    END DO
  END DO
END SUBROUTINE DQSAT_BAC_B

!  Differentiation of dqsats_bac in reverse (adjoint) mode:
!   gradient     of useful results: temp dqsi qssi
!   with respect to varying inputs: temp
SUBROUTINE DQSATS_BAC_B(dqsi, dqsib, qssi, qssib, temp, tempb, plo, &
& estblx, cons_h2omw, cons_airmw)
  IMPLICIT NONE
!Inputs
  REAL*8 :: temp, plo
  REAL*8 :: tempb
  REAL*8 :: estblx(:)
  REAL*8 :: cons_h2omw, cons_airmw
!Outputs
  REAL*8 :: dqsi, qssi
  REAL*8 :: dqsib, qssib
!Locals
  REAL*8, PARAMETER :: max_mixing_ratio=1.0
  REAL*8 :: esfac
  REAL*8 :: tl, tt, ti, dqsat, qsat, dqq, qq, pl, pp, dd
  REAL*8 :: tlb, ttb, tib, dqsatb, qsatb, qqb, ddb
  INTEGER :: it
  INTEGER, PARAMETER :: degsubs=100
  REAL*8, PARAMETER :: tmintbl=150.0, tmaxtbl=333.0
  INTEGER, PARAMETER :: tablesize=NINT(tmaxtbl-tmintbl)*degsubs+1
  INTRINSIC NINT
  INTRINSIC INT
  INTEGER :: branch
  REAL*8 :: temp0
  esfac = cons_h2omw/cons_airmw
  tl = temp
  pl = plo
  pp = pl*100.0
  IF (tl .LE. tmintbl) THEN
    ti = tmintbl
    CALL PUSHCONTROL2B(0)
  ELSE IF (tl .GE. tmaxtbl - .001) THEN
    ti = tmaxtbl - .001
    CALL PUSHCONTROL2B(1)
  ELSE
    ti = tl
    CALL PUSHCONTROL2B(2)
  END IF
  tt = (ti-tmintbl)*degsubs + 1
  it = INT(tt)
  dqq = estblx(it+1) - estblx(it)
  qq = (tt-it)*dqq + estblx(it)
  IF (pp .LE. qq) THEN
    CALL PUSHCONTROL1B(0)
  ELSE
    dd = 1.0/(pp-(1.0-esfac)*qq)
    CALL PUSHCONTROL1B(1)
  END IF
  qsatb = qssib
  dqsatb = dqsib
  CALL POPCONTROL1B(branch)
  IF (branch .EQ. 0) THEN
    qqb = 0.0_8
  ELSE
    temp0 = pp - (-esfac+1.0)*qq
    ddb = esfac*qq*qsatb + esfac*degsubs*dqq*pp*2*dd*dqsatb
    qqb = (1.0-esfac)*ddb/temp0**2 + esfac*dd*qsatb
  END IF
  ttb = dqq*qqb
  tib = degsubs*ttb
  CALL POPCONTROL2B(branch)
  IF (branch .EQ. 0) THEN
    tlb = 0.0_8
  ELSE IF (branch .EQ. 1) THEN
    tlb = 0.0_8
  ELSE
    tlb = tib
  END IF
  tempb = tempb + tlb
END SUBROUTINE DQSATS_BAC_B

END MODULE CLOUD_AD
