!        Generated by TAPENADE     (INRIA, Tropics team)
!  Tapenade 3.2 (r3024) - 06/17/2009 13:03
!  
!   $Id$
MODULE GW_DRAG_D
  USE MAPL_CONSTANTSMOD, ONLY : mapl_p00, mapl_cp, mapl_grav, &
&  mapl_rgas, mapl_vireps, mapl_kappa
  USE GW_DRAG_INIT

!  USE GW_DRAG_B

  IMPLICIT NONE
!---------------------------------------------------------------------------------
! Purpose:
!
! Module to compute the forcing due to parameterized gravity waves. Both an 
! orographic and an internal source spectrum are considered.
!
! Author: Byron Boville
!         In-Sun Song
!
!---------------------------------------------------------------------------------
!save
! Make default type private to the module
  PRIVATE 
!
! PUBLIC: interfaces
!
! interface to actual parameterization
!  PUBLIC gw_intr
!, gw_drag_prof, gw_bgnd, gw_oro, gw_prof
  PUBLIC gw_main_d
!, gw_intr_d, gw_drag_prof_d, gw_oro_d
!  PUBLIC gw_main_d, gw_intr_d, gw_drag_prof_d, gw_bgnd_d, gw_oro_d
!
! PRIVATE: Rest of the data and interfaces are private to this module
!
! effective horizontal wave number for background
  REAL, PARAMETER, PUBLIC :: kwvb=6.28e-5
! effective horizontal wave number for background
  REAL, PARAMETER, PUBLIC :: kwvbeq=6.28e-5/7.
! effective horizontal wave number for orographic
  REAL, PARAMETER, PUBLIC :: kwvo=6.28e-5
! fraction of stress deposited in low level region
  REAL, PARAMETER, PUBLIC :: fracldv=0.0
! max asymmetry between tau(c) and tau(-c)
  REAL, PARAMETER, PUBLIC :: mxasym=0.1
! max range of tau for all c
  REAL, PARAMETER, PUBLIC :: mxrange=0.001
! min value of bouyancy frequency
  REAL, PARAMETER, PUBLIC :: n2min=1.e-8
! critical froude number
  REAL, PARAMETER, PUBLIC :: fcrit2=0.5
! min surface displacment height for orographic waves
  REAL, PARAMETER, PUBLIC :: orohmin=10.
! min wind speed for orographic waves
  REAL, PARAMETER, PUBLIC :: orovmin=2.0
! background source strength (/TAUSCAL)
  REAL, PARAMETER, PUBLIC :: taubgnd=6.4
! minimum (nonzero) stress
  REAL, PARAMETER, PUBLIC :: taumin=1.e-10
! scale factor for background stress source
  REAL, PARAMETER, PUBLIC :: tauscal=0.001
! maximum wind tendency
  REAL, PARAMETER, PUBLIC :: tndmax=500./86400.
! factor to limit tendency to prevent reversing u-c
  REAL, PARAMETER, PUBLIC :: umcfac=0.5
! min (u-c)**2
  REAL, PARAMETER, PUBLIC :: ubmc2mn=0.1
! constant for determining zldv from tau0
  REAL, PARAMETER, PUBLIC :: zldvcon=10.
  REAL, PARAMETER, PUBLIC :: rog=mapl_rgas/mapl_grav
! 1/2 * horizontal wavenumber
  REAL, PARAMETER, PUBLIC :: oroko2=0.5*kwvo
! This is *not* MAPL_PI
  REAL, PARAMETER, PUBLIC :: pi_gwd=4.0*atan(1.0)

CONTAINS
SUBROUTINE GW_MAIN_D(pcols, pver, dt, pgwv, effgworo_dev, &
&  effgwbkg_dev, pint_dev, t_dev, u_dev, u_devd, v_dev, v_devd, &
&  sgh_dev, pref_dev, pmid_dev, pdel_dev, rpdel_dev, lnpint_dev, zm_dev, &
&  qvt_dev, rog, mapl_vireps_, rlat_dev)
  IMPLICIT NONE
!-----------------------------------------------------------------------
! Interface for multiple gravity wave drag parameterization.
!-----------------------------------------------------------------------
!------------------------------Arguments--------------------------------
! - number of columns                                            
  INTEGER :: pcols
! - number of vertical layers
  INTEGER :: pver
! - time step
  REAL :: dt
! - number of waves allowed                (Default = 4, 0 nullifies)
  INTEGER :: pgwv
! - tendency efficiency for background gwd (Default = 0.125)
  REAL :: effgwbkg_dev(pcols)
! - tendency efficiency for orographic gwd (Default = 0.125)
  REAL :: effgworo_dev(pcols)
! - pressure at the layer edges
  REAL :: pint_dev(pcols, pver+1)
! - temperature at layers
  REAL :: t_dev(pcols, pver)
! - zonal wind at layers
  REAL :: u_dev(pcols, pver)
  REAL :: u_devd(pcols, pver)
! - meridional wind at layers
  REAL :: v_dev(pcols, pver)
  REAL :: v_devd(pcols, pver)
! e standard deviation of orography
  REAL :: sgh_dev(pcols)
! e reference pressure at the layeredges
  REAL :: pref_dev(pver+1)
! c pressure at the layers
  REAL :: pmid_dev(pcols, pver)
! c pressure thickness at the layers
  REAL :: pdel_dev(pcols, pver)
! c 1.0 / pdel
  REAL :: rpdel_dev(pcols, pver)
! c log(pint)
  REAL :: lnpint_dev(pcols, pver+1)
! c height above surface at layers
  REAL :: zm_dev(pcols, pver)
! c height above surface at layers
  REAL :: zi_dev(pcols, pver+1)
! c pressure at the layers
  REAL :: qvt_dev(pcols, pver)
!mg latitude in radian
  REAL :: rlat_dev(pcols)
! zonal wind tendency at layer 
  REAL :: dudt_gwd_dev(pcols, pver)
  REAL :: dudt_gwd_devd(pcols, pver)
! meridional wind tendency at layer 
  REAL :: dvdt_gwd_dev(pcols, pver)
  REAL :: dvdt_gwd_devd(pcols, pver)
! temperature tendency at layer
  REAL :: dtdt_gwd_dev(pcols, pver)
  REAL :: dtdt_gwd_devd(pcols, pver)
! zonal wind tendency at layer due to orography GWD
  REAL :: dudt_org_dev(pcols, pver)
! meridional wind tendency at layer  due to orography GWD
  REAL :: dvdt_org_dev(pcols, pver)
! temperature tendency at layer  due to orography GWD
  REAL :: dtdt_org_dev(pcols, pver)
! zonal      gravity wave surface    stress
  REAL :: taugwdx_dev(pcols)
! meridional gravity wave surface    stress
  REAL :: taugwdy_dev(pcols)
! zonal      orographic gravity wave stress
  REAL :: tauox_dev(pcols, pver+1)
! meridional orographic gravity wave stress
  REAL :: tauoy_dev(pcols, pver+1)
! energy flux of orographic gravity waves
  REAL :: feo_dev(pcols, pver+1)
! pseudoenergy flux of orographic gravity waves
  REAL :: fepo_dev(pcols, pver+1)
! zonal      gravity wave background stress
  REAL :: taubkgx_dev(pcols)
! meridional gravity wave background stress
  REAL :: taubkgy_dev(pcols)
! zonal      background gravity wave stress
  REAL :: taubx_dev(pcols, pver+1)
! meridional background gravity wave stress
  REAL :: tauby_dev(pcols, pver+1)
! energy flux of background gravity waves
  REAL :: feb_dev(pcols, pver+1)
! pseudoenergy flux of background gravity waves
  REAL :: fepb_dev(pcols, pver+1)
! dU/dt below background launch level
  REAL :: utbsrc_dev(pcols, pver)
! dV/dt below background launch level
  REAL :: vtbsrc_dev(pcols, pver)
! dT/dt below background launch level
  REAL :: ttbsrc_dev(pcols, pver)
!---------------------------Local storage-------------------------------
! loop indexes
  INTEGER :: i, k, kc
! launch-level index for orographic
  INTEGER :: kbotoro
! launch-level index for background
  INTEGER :: kbotbg
! top interface of gwd region
  INTEGER :: ktopbg, ktoporo
! top interface of low level stress divergence region
  INTEGER :: kldv
! min value of kldv
  INTEGER :: kldvmn
! index of top interface of source region
  INTEGER :: ksrc
! min value of ksrc
  INTEGER :: ksrcmn
! temperature tendency
  REAL :: ttgw(pver)
! zonal wind tendency
  REAL :: utgw(pver)
! meridional wind tendency
  REAL :: vtgw(pver)
! interface Brunt-Vaisalla frequency
  REAL :: ni(0:pver)
! midpoint Brunt-Vaisalla frequency
  REAL :: nm(pver)
! 1/dp across low level divergence region
  REAL :: rdpldv
! interface density
  REAL :: rhoi(0:pver)
! c=0 sfc. stress (zonal)
  REAL :: tau0x
! c=0 sfc. stress (meridional)
  REAL :: tau0y
! interface temperature
  REAL :: ti(0:pver)
! projection of wind at interfaces
  REAL :: ubi(0:pver)
! projection of wind at midpoints
  REAL :: ubm(pver)
! unit vectors of source wind (x)
  REAL :: xv
! unit vectors of source wind (y)
  REAL :: yv
  REAL :: utosrc(pver)
  REAL :: vtosrc(pver)
  REAL :: ttosrc(pver)
! newtonian cooling coefficients
  REAL :: alpha(0:pver)
! newtonian cooling coefficients
  REAL :: dback(0:pver)
! wave phase speeds
  REAL :: c(-pgwv:pgwv)
! - temperature at layers
  REAL :: att_dev(pcols, pver)
  REAL :: att_devd(pcols, pver)
  REAL :: pwr1
  REAL :: pwx2
  REAL :: pwy2
  REAL :: pwr2
  REAL :: hkl, hkk, tvfac, tv, rog
  REAL :: pwr10
  REAL :: pwx20
  REAL :: pwy20
  REAL :: pwr20
  REAL :: mapl_vireps_
  isize_s1_tau=-pgwv;isize_s2_tau=0;isize_e1_tau=pgwv;isize_e2_tau=pver

  DO i=1,pcols
    DO k=1,pver
      pwr10 = mapl_p00**mapl_kappa
      pwx20 = mapl_p00/pint_dev(i, k)
      pwy20 = -mapl_kappa
      pwr20 = pwx20**pwy20
      att_dev(i, k) = t_dev(i, k)*pwr10*pwr20
    END DO
  END DO
  DO i=1,pcols
    zi_dev(i, pver+1) = 0.
    DO k=pver,1,-1
      hkl = lnpint_dev(i, k+1) - lnpint_dev(i, k)
      hkk = 1. - pint_dev(i, k)*hkl*rpdel_dev(i, k)
      tvfac = 1. + mapl_vireps_*qvt_dev(i, k)
      tv = att_dev(i, k)*tvfac
      zm_dev(i, k) = zi_dev(i, k+1) + rog*tv*hkk
      zi_dev(i, k) = zi_dev(i, k+1) + rog*tv*hkl
    END DO
  END DO

  dvdt_gwd_devd = 0.0
  dudt_gwd_devd = 0.0

  DO i=1,pcols
    If (.not.bypass_bgnd) then
    do_bgnd=.true.
    do_oro=.false.

    CALL GW_INTR_D(i, pcols, pver, dt, pgwv, effgworo_dev, effgwbkg_dev&
&             , pint_dev, att_dev, u_dev, u_devd, v_dev, v_devd&
&             , sgh_dev, pref_dev, pmid_dev, pdel_dev, rpdel_dev, &
&             lnpint_dev, zm_dev, rlat_dev, dudt_gwd_dev, dudt_gwd_devd, &
&             dvdt_gwd_dev, dvdt_gwd_devd, dtdt_gwd_dev, &
&             dudt_org_dev, dvdt_org_dev, dtdt_org_dev, taugwdx_dev, &
&             taugwdy_dev, tauox_dev, tauoy_dev, feo_dev, taubkgx_dev, &
&             taubkgy_dev, taubx_dev, tauby_dev, feb_dev, fepo_dev, &
&             fepb_dev, utbsrc_dev, vtbsrc_dev, ttbsrc_dev)

    Endif

    If (.not.bypass_bgnd.and. .not.bypass_oro) then
    dvdt_gwd_devd = 0.0
    dudt_gwd_devd = 0.0
    Endif

    If (.not.bypass_oro) then
    do_bgnd=.false.
    do_oro=.true.

    CALL GW_INTR_D(i, pcols, pver, dt, pgwv, effgworo_dev, effgwbkg_dev&
&             , pint_dev, att_dev, u_dev, u_devd, v_dev, v_devd&
&             , sgh_dev, pref_dev, pmid_dev, pdel_dev, rpdel_dev, &
&             lnpint_dev, zm_dev, rlat_dev, dudt_gwd_dev, dudt_gwd_devd, &
&             dvdt_gwd_dev, dvdt_gwd_devd, dtdt_gwd_dev, &
&             dudt_org_dev, dvdt_org_dev, dtdt_org_dev, taugwdx_dev, &
&             taugwdy_dev, tauox_dev, tauoy_dev, feo_dev, taubkgx_dev, &
&             taubkgy_dev, taubx_dev, tauby_dev, feb_dev, fepo_dev, &
&             fepb_dev, utbsrc_dev, vtbsrc_dev, ttbsrc_dev)
    Endif
  END DO

  DO i=1,pcols
    DO k=1,pver
      pwr10 = mapl_p00**mapl_kappa
      pwx20 = mapl_p00/pint_dev(i, k)
      pwy20 = -mapl_kappa
      pwr20 = pwx20**pwy20
      t_dev(i, k) = att_dev(i, k)/pwr10/pwr20
    END DO
  END DO

END SUBROUTINE GW_MAIN_D
  SUBROUTINE GW_INTR_D(i, pcols, pver, dt, pgwv, effgworo_dev, &
&    effgwbkg_dev, pint_dev, t_dev, u_dev, u_devd, v_dev, v_devd, sgh_dev&
&    , pref_dev, pmid_dev, pdel_dev, rpdel_dev, lnpint_dev, zm_dev, &
&    rlat_dev, dudt_gwd_dev, dudt_gwd_devd, dvdt_gwd_dev, dvdt_gwd_devd, &
&    dtdt_gwd_dev, dudt_org_dev, dvdt_org_dev, dtdt_org_dev, taugwdx_dev&
&    , taugwdy_dev, tauox_dev, tauoy_dev, feo_dev, taubkgx_dev, &
&    taubkgy_dev, taubx_dev, tauby_dev, feb_dev, fepo_dev, fepb_dev, &
&    utbsrc_dev, vtbsrc_dev, ttbsrc_dev)
    IMPLICIT NONE
!-----------------------------------------------------------------------
! Interface for multiple gravity wave drag parameterization.
!-----------------------------------------------------------------------
!------------------------------Arguments--------------------------------
! - number of columns                                            
    INTEGER, INTENT(IN) :: pcols
! - number of vertical layers
    INTEGER, INTENT(IN) :: pver
! - time step
    REAL, INTENT(IN) :: dt
! - number of waves allowed                (Default = 4, 0 nullifies)
    INTEGER, INTENT(IN) :: pgwv
! - tendency efficiency for background gwd (Default = 0.125)
    REAL :: effgwbkg_dev(pcols)
! - tendency efficiency for orographic gwd (Default = 0.125)
    REAL :: effgworo_dev(pcols)
! - pressure at the layer edges
    REAL :: pint_dev(pcols, pver+1)
! - temperature at layers
    REAL :: t_dev(pcols, pver)
! - zonal wind at layers
    REAL :: u_dev(pcols, pver)
    REAL :: u_devd(pcols, pver)
! - meridional wind at layers
    REAL :: v_dev(pcols, pver)
    REAL :: v_devd(pcols, pver)
! e standard deviation of orography
    REAL :: sgh_dev(pcols)
! e reference pressure at the layeredges
    REAL :: pref_dev(pver+1)
! c pressure at the layers
    REAL :: pmid_dev(pcols, pver)
! c pressure thickness at the layers
    REAL :: pdel_dev(pcols, pver)
! c 1.0 / pdel
    REAL :: rpdel_dev(pcols, pver)
! c log(pint)
    REAL :: lnpint_dev(pcols, pver+1)
! c height above surface at layers
    REAL :: zm_dev(pcols, pver)
!mg latitude in radian
    REAL :: rlat_dev(pcols)
! zonal wind tendency at layer 
    REAL :: dudt_gwd_dev(pcols, pver)
    REAL :: dudt_gwd_devd(pcols, pver)
! meridional wind tendency at layer 
    REAL :: dvdt_gwd_dev(pcols, pver)
    REAL :: dvdt_gwd_devd(pcols, pver)
! temperature tendency at layer
    REAL :: dtdt_gwd_dev(pcols, pver)
! zonal wind tendency at layer due to orography GWD
    REAL :: dudt_org_dev(pcols, pver)
! meridional wind tendency at layer  due to orography GWD
    REAL :: dvdt_org_dev(pcols, pver)
! temperature tendency at layer  due to orography GWD
    REAL :: dtdt_org_dev(pcols, pver)
! zonal      gravity wave surface    stress
    REAL :: taugwdx_dev(pcols)
! meridional gravity wave surface    stress
    REAL :: taugwdy_dev(pcols)
! zonal      orographic gravity wave stress
    REAL :: tauox_dev(pcols, pver+1)
! meridional orographic gravity wave stress
    REAL :: tauoy_dev(pcols, pver+1)
! energy flux of orographic gravity waves
    REAL :: feo_dev(pcols, pver+1)
! pseudoenergy flux of orographic gravity waves
    REAL :: fepo_dev(pcols, pver+1)
! zonal      gravity wave background stress
    REAL :: taubkgx_dev(pcols)
! meridional gravity wave background stress
    REAL :: taubkgy_dev(pcols)
! zonal      background gravity wave stress
    REAL :: taubx_dev(pcols, pver+1)
! meridional background gravity wave stress
    REAL :: tauby_dev(pcols, pver+1)
! energy flux of background gravity waves
    REAL :: feb_dev(pcols, pver+1)
! pseudoenergy flux of background gravity waves
    REAL :: fepb_dev(pcols, pver+1)
! dU/dt below background launch level
    REAL :: utbsrc_dev(pcols, pver)
! dV/dt below background launch level
    REAL :: vtbsrc_dev(pcols, pver)
! dT/dt below background launch level
    REAL :: ttbsrc_dev(pcols, pver)
!---------------------------Local storage-------------------------------
! loop indexes
    INTEGER :: i, ii, k, kc
! launch-level index for orographic
    INTEGER :: kbotoro
! launch-level index for background
    INTEGER :: kbotbg
! top interface of gwd region
    INTEGER :: ktopbg, ktoporo
! top interface of low level stress divergence region
    INTEGER :: kldv
! min value of kldv
    INTEGER :: kldvmn
! index of top interface of source region
    INTEGER :: ksrc
! min value of ksrc
    INTEGER :: ksrcmn
! temperature tendency
    REAL :: ttgw(pver)
! zonal wind tendency
    REAL :: utgw(pver)
    REAL :: utgwd(pver)
! meridional wind tendency
    REAL :: vtgw(pver)
    REAL :: vtgwd(pver)
! interface Brunt-Vaisalla frequency
    REAL :: ni(0:pver)
! midpoint Brunt-Vaisalla frequency
    REAL :: nm(pver)
! 1/dp across low level divergence region
    REAL :: rdpldv
! interface density
    REAL :: rhoi(0:pver)
! c=0 sfc. stress (zonal)
    REAL :: tau0x
! c=0 sfc. stress (meridional)
    REAL :: tau0y
! interface temperature
    REAL :: ti(0:pver)
! projection of wind at interfaces
    REAL :: ubi(0:pver)
    REAL :: ubid(0:pver)
! projection of wind at midpoints
    REAL :: ubm(pver)
    REAL :: ubmd(pver)
! unit vectors of source wind (x)
    REAL :: xv
    REAL :: xvd
! unit vectors of source wind (y)
    REAL :: yv
    REAL :: yvd
    REAL :: utosrc(pver)
    REAL :: utosrcd(pver)
    REAL :: vtosrc(pver)
    REAL :: vtosrcd(pver)
    REAL :: ttosrc(pver)
! newtonian cooling coefficients
    REAL :: alpha(0:pver)
! newtonian cooling coefficients
    REAL :: dback(0:pver)
! wave phase speeds
    REAL :: c(-pgwv:pgwv)
    REAL :: cd(-pgwv:pgwv)
! wave Reynolds stress
    REAL :: tau(-pgwv:pgwv, 0:pver)
    REAL :: taud(-pgwv:pgwv, 0:pver)
!-----------------------------------------------------------------------------
! Assign newtonian cooling coefficients
! -------------------------------------
    DO k=0,pver
      alpha(k) = 0.0
      dback(k) = 0.0
    END DO
! Assign wave phase speeds
! ------------------------
    DO kc=-pgwv,pgwv
      cd(kc) = 0.0_8
      c(kc) = 10.0*kc
    END DO
! Determine the bounds of the background and orographic stress regions
    ktoporo = 0
    ktopbg = 0
    kbotoro = pver
    DO k=0,pver
      IF (pref_dev(k+1) .LT. P_SRC) kbotbg = k
! spectrum source at 400 mb
    END DO
    DO k=0,pver
! Profiles of background state variables
      CALL GW_PROF(i, k, pcols, pver, u_dev, v_dev, t_dev, pmid_dev, &
&             pint_dev, rhoi, ni, ti, nm)
    END DO
!-----------------------------------------------------------------------------
! Non-orographic backgound gravity wave spectrum
!-----------------------------------------------------------------------------
    IF (pgwv .GT. 0 .AND. do_bgnd) THEN
! Determine the wave source for a background spectrum at ~400 mb
      CALL GW_BGND_D(i, pcols, pver, c, u_dev, u_devd, v_dev, v_devd, &
&               t_dev, pmid_dev, pint_dev, pdel_dev, rpdel_dev, &
&               lnpint_dev, rlat_dev, kldv, kldvmn, ksrc, ksrcmn, rdpldv&
&               , tau, ubi, ubid, ubm, ubmd, xv, xvd, yv, yvd, pgwv, &
&               kbotbg)
! Solve for the drag profile
      CALL GW_DRAG_PROF_BGND_D(i, pcols, pver, pgwv, pgwv, kbotbg, &
&                         ktopbg, c, u_dev, v_dev, t_dev, pint_dev, &
&                         pdel_dev, rpdel_dev, lnpint_dev, rlat_dev, rhoi&
&                         , ni, ti, nm, dt, alpha, dback, kldv, kldvmn, &
&                         ksrc, ksrcmn, rdpldv, tau, taud, ubi, ubid, ubm&
&                         , xv, xvd, yv, yvd, utgw, utgwd, vtgw, vtgwd, &
&                         ttgw, taubx_dev, tauby_dev, feb_dev, fepb_dev, &
&                         utosrc, utosrcd, vtosrc, vtosrcd, ttosrc, tau0x&
&                         , tau0y, effgwbkg_dev)
! Add the momentum tendencies to the output tendency arrays
      DO k=1,pver
        dudt_gwd_devd(i, k) = utgwd(k) + utosrcd(k)
        dudt_gwd_dev(i, k) = utgw(k) + utosrc(k)
        dvdt_gwd_devd(i, k) = vtgwd(k) + vtosrcd(k)
        dvdt_gwd_dev(i, k) = vtgw(k) + vtosrc(k)
      END DO
    ELSE
! zero net tendencies if no spectrum computed
      DO k=1,pver
        dudt_gwd_devd(i, k) = 0.0_8
        dudt_gwd_dev(i, k) = 0.
        dvdt_gwd_devd(i, k) = 0.0_8
        dvdt_gwd_dev(i, k) = 0.
      END DO
      taud(:, :) = 0.0_8
      vtgwd(:) = 0.0_8
      utgwd(:) = 0.0_8
      ubid(:) = 0.0_8
      ubmd(:) = 0.0_8
    END IF
!            dtdt_gwd_dev(i,k) = 0.
!-----------------------------------------------------------------------------
! Orographic stationary gravity wave
!-----------------------------------------------------------------------------
! Determine the orographic wave source
    IF (do_oro) THEN
      CALL GW_ORO_D(i, pcols, pver, pgwv, u_dev, u_devd, v_dev, v_devd, &
&              t_dev, sgh_dev, pmid_dev, pint_dev, pdel_dev, zm_dev, nm, &
&              kldv, kldvmn, ksrc, ksrcmn, rdpldv, tau, taud, ubi, ubid, &
&              ubm, ubmd, xv, xvd, yv, yvd, kbotoro, rlat_dev)
! Solve for the drag profile
      CALL GW_DRAG_PROF_D(i, pcols, pver, pgwv, 0, kbotoro, ktoporo, c, &
&                    u_dev, v_dev, t_dev, pint_dev, pdel_dev, rpdel_dev, &
&                    lnpint_dev, rlat_dev, rhoi, ni, ti, nm, dt, alpha, &
&                    dback, kldv, kldvmn, ksrc, ksrcmn, rdpldv, tau, taud&
&                    , ubi, ubid, ubm, xv, xvd, yv, yvd, utgw, utgwd, &
&                    vtgw, vtgwd, ttgw, tauox_dev, tauoy_dev, feo_dev, &
&                    fepo_dev, utosrc, vtosrc, ttosrc, tau0x, tau0y, &
&                    effgworo_dev)
! Add the orographic tendencies to the spectrum tendencies
! Compute the temperature tendency from energy conservation (includes spectrum).
      DO k=1,pver
        dudt_gwd_devd(i, k) = dudt_gwd_devd(i, k) + utgwd(k)
        dudt_gwd_dev(i, k) = dudt_gwd_dev(i, k) + utgw(k)
        dvdt_gwd_devd(i, k) = dvdt_gwd_devd(i, k) + vtgwd(k)
        dvdt_gwd_dev(i, k) = dvdt_gwd_dev(i, k) + vtgw(k)
      END DO
    END IF
!          dtdt_gwd_dev(i,k) = dtdt_gwd_dev(i,k) + ttgw(k)
    DO k=1,pver
      u_devd(i, k) = u_devd(i, k) + dt*dudt_gwd_devd(i, k)
      u_dev(i, k) = u_dev(i, k) + dudt_gwd_dev(i, k)*dt
      v_devd(i, k) = v_devd(i, k) + dt*dvdt_gwd_devd(i, k)
      v_dev(i, k) = v_dev(i, k) + dvdt_gwd_dev(i, k)*dt
    END DO
!       t_dev(i,k) = t_dev(i,k) + dtdt_gwd_dev(i,k)*dt
    RETURN
  END SUBROUTINE GW_INTR_D
  SUBROUTINE GW_INTR(i, pcols, pver, dt, pgwv, effgworo_dev, &
&    effgwbkg_dev, pint_dev, t_dev, u_dev, v_dev, sgh_dev, pref_dev, &
&    pmid_dev, pdel_dev, rpdel_dev, lnpint_dev, zm_dev, rlat_dev, &
&    dudt_gwd_dev, dvdt_gwd_dev, dtdt_gwd_dev, dudt_org_dev, dvdt_org_dev&
&    , dtdt_org_dev, taugwdx_dev, taugwdy_dev, tauox_dev, tauoy_dev, &
&    feo_dev, taubkgx_dev, taubkgy_dev, taubx_dev, tauby_dev, feb_dev, &
&    fepo_dev, fepb_dev, utbsrc_dev, vtbsrc_dev, ttbsrc_dev)
    IMPLICIT NONE
!-----------------------------------------------------------------------
! Interface for multiple gravity wave drag parameterization.
!-----------------------------------------------------------------------
!------------------------------Arguments--------------------------------
! - number of columns                                            
    INTEGER, INTENT(IN) :: pcols
! - number of vertical layers
    INTEGER, INTENT(IN) :: pver
! - time step
    REAL, INTENT(IN) :: dt
! - number of waves allowed                (Default = 4, 0 nullifies)
    INTEGER, INTENT(IN) :: pgwv
! - tendency efficiency for background gwd (Default = 0.125)
    REAL :: effgwbkg_dev(pcols)
! - tendency efficiency for orographic gwd (Default = 0.125)
    REAL :: effgworo_dev(pcols)
! - pressure at the layer edges
    REAL :: pint_dev(pcols, pver+1)
! - temperature at layers
    REAL :: t_dev(pcols, pver)
! - zonal wind at layers
    REAL :: u_dev(pcols, pver)
! - meridional wind at layers
    REAL :: v_dev(pcols, pver)
! e standard deviation of orography
    REAL :: sgh_dev(pcols)
! e reference pressure at the layeredges
    REAL :: pref_dev(pver+1)
! c pressure at the layers
    REAL :: pmid_dev(pcols, pver)
! c pressure thickness at the layers
    REAL :: pdel_dev(pcols, pver)
! c 1.0 / pdel
    REAL :: rpdel_dev(pcols, pver)
! c log(pint)
    REAL :: lnpint_dev(pcols, pver+1)
! c height above surface at layers
    REAL :: zm_dev(pcols, pver)
!mg latitude in radian
    REAL :: rlat_dev(pcols)
! zonal wind tendency at layer 
    REAL :: dudt_gwd_dev(pcols, pver)
! meridional wind tendency at layer 
    REAL :: dvdt_gwd_dev(pcols, pver)
! temperature tendency at layer
    REAL :: dtdt_gwd_dev(pcols, pver)
! zonal wind tendency at layer due to orography GWD
    REAL :: dudt_org_dev(pcols, pver)
! meridional wind tendency at layer  due to orography GWD
    REAL :: dvdt_org_dev(pcols, pver)
! temperature tendency at layer  due to orography GWD
    REAL :: dtdt_org_dev(pcols, pver)
! zonal      gravity wave surface    stress
    REAL :: taugwdx_dev(pcols)
! meridional gravity wave surface    stress
    REAL :: taugwdy_dev(pcols)
! zonal      orographic gravity wave stress
    REAL :: tauox_dev(pcols, pver+1)
! meridional orographic gravity wave stress
    REAL :: tauoy_dev(pcols, pver+1)
! energy flux of orographic gravity waves
    REAL :: feo_dev(pcols, pver+1)
! pseudoenergy flux of orographic gravity waves
    REAL :: fepo_dev(pcols, pver+1)
! zonal      gravity wave background stress
    REAL :: taubkgx_dev(pcols)
! meridional gravity wave background stress
    REAL :: taubkgy_dev(pcols)
! zonal      background gravity wave stress
    REAL :: taubx_dev(pcols, pver+1)
! meridional background gravity wave stress
    REAL :: tauby_dev(pcols, pver+1)
! energy flux of background gravity waves
    REAL :: feb_dev(pcols, pver+1)
! pseudoenergy flux of background gravity waves
    REAL :: fepb_dev(pcols, pver+1)
! dU/dt below background launch level
    REAL :: utbsrc_dev(pcols, pver)
! dV/dt below background launch level
    REAL :: vtbsrc_dev(pcols, pver)
! dT/dt below background launch level
    REAL :: ttbsrc_dev(pcols, pver)
!---------------------------Local storage-------------------------------
! loop indexes
    INTEGER :: i, ii, k, kc
! launch-level index for orographic
    INTEGER :: kbotoro
! launch-level index for background
    INTEGER :: kbotbg
! top interface of gwd region
    INTEGER :: ktopbg, ktoporo
! top interface of low level stress divergence region
    INTEGER :: kldv
! min value of kldv
    INTEGER :: kldvmn
! index of top interface of source region
    INTEGER :: ksrc
! min value of ksrc
    INTEGER :: ksrcmn
! temperature tendency
    REAL :: ttgw(pver)
! zonal wind tendency
    REAL :: utgw(pver)
! meridional wind tendency
    REAL :: vtgw(pver)
! interface Brunt-Vaisalla frequency
    REAL :: ni(0:pver)
! midpoint Brunt-Vaisalla frequency
    REAL :: nm(pver)
! 1/dp across low level divergence region
    REAL :: rdpldv
! interface density
    REAL :: rhoi(0:pver)
! c=0 sfc. stress (zonal)
    REAL :: tau0x
! c=0 sfc. stress (meridional)
    REAL :: tau0y
! interface temperature
    REAL :: ti(0:pver)
! projection of wind at interfaces
    REAL :: ubi(0:pver)
! projection of wind at midpoints
    REAL :: ubm(pver)
! unit vectors of source wind (x)
    REAL :: xv
! unit vectors of source wind (y)
    REAL :: yv
    REAL :: utosrc(pver)
    REAL :: vtosrc(pver)
    REAL :: ttosrc(pver)
! newtonian cooling coefficients
    REAL :: alpha(0:pver)
! newtonian cooling coefficients
    REAL :: dback(0:pver)
! wave phase speeds
    REAL :: c(-pgwv:pgwv)
! wave Reynolds stress
    REAL :: tau(-pgwv:pgwv, 0:pver)
!-----------------------------------------------------------------------------
! Assign newtonian cooling coefficients
! -------------------------------------
    DO k=0,pver
      alpha(k) = 0.0
      dback(k) = 0.0
    END DO
! Assign wave phase speeds
! ------------------------
    DO kc=-pgwv,pgwv
      c(kc) = 10.0*kc
    END DO
! Determine the bounds of the background and orographic stress regions
    ktoporo = 0
    ktopbg = 0
    kbotoro = pver
    DO k=0,pver
      IF (pref_dev(k+1) .LT. P_SRC) kbotbg = k
! spectrum source at 400 mb
    END DO
    DO k=0,pver
! Profiles of background state variables
      CALL GW_PROF(i, k, pcols, pver, u_dev, v_dev, t_dev, pmid_dev, &
&             pint_dev, rhoi, ni, ti, nm)
    END DO
!-----------------------------------------------------------------------------
! Non-orographic backgound gravity wave spectrum
!-----------------------------------------------------------------------------
    IF (pgwv .GT. 0 .AND. do_bgnd) THEN
! Determine the wave source for a background spectrum at ~400 mb
      CALL GW_BGND(i, pcols, pver, c, u_dev, v_dev, t_dev, pmid_dev, &
&             pint_dev, pdel_dev, rpdel_dev, lnpint_dev, rlat_dev, kldv, &
&             kldvmn, ksrc, ksrcmn, rdpldv, tau, ubi, ubm, xv, yv, pgwv, &
&             kbotbg)
! Solve for the drag profile
      CALL GW_DRAG_PROF_BGND(i, pcols, pver, pgwv, pgwv, kbotbg, ktopbg&
&                       , c, u_dev, v_dev, t_dev, pint_dev, pdel_dev, &
&                       rpdel_dev, lnpint_dev, rlat_dev, rhoi, ni, ti, nm&
&                       , dt, alpha, dback, kldv, kldvmn, ksrc, ksrcmn, &
&                       rdpldv, tau, ubi, ubm, xv, yv, utgw, vtgw, ttgw, &
&                       taubx_dev, tauby_dev, feb_dev, fepb_dev, utosrc, &
&                       vtosrc, ttosrc, tau0x, tau0y, effgwbkg_dev)
! Add the momentum tendencies to the output tendency arrays
      DO k=1,pver
        dudt_gwd_dev(i, k) = utgw(k) + utosrc(k)
        dvdt_gwd_dev(i, k) = vtgw(k) + vtosrc(k)
      END DO
    ELSE
!             dudt_gwd_dev(i,k) = utgw(k) + utosrc(k)
!             dvdt_gwd_dev(i,k) = vtgw(k) + vtosrc(k)
!             dtdt_gwd_dev(i,k) = ttgw(k) + ttosrc(k)
! zero net tendencies if no spectrum computed
      DO k=1,pver
        dudt_gwd_dev(i, k) = 0.
        dvdt_gwd_dev(i, k) = 0.
      END DO
    END IF
!            dtdt_gwd_dev(i,k) = 0.
!-----------------------------------------------------------------------------
! Orographic stationary gravity wave
!-----------------------------------------------------------------------------
! Determine the orographic wave source
    IF (do_oro) THEN
      CALL GW_ORO(i, pcols, pver, pgwv, u_dev, v_dev, t_dev, sgh_dev, &
&            pmid_dev, pint_dev, pdel_dev, zm_dev, nm, kldv, kldvmn, ksrc&
&            , ksrcmn, rdpldv, tau, ubi, ubm, xv, yv, kbotoro, rlat_dev)
! Solve for the drag profile
      CALL GW_DRAG_PROF(i, pcols, pver, pgwv, 0, kbotoro, ktoporo, c, &
&                  u_dev, v_dev, t_dev, pint_dev, pdel_dev, rpdel_dev, &
&                  lnpint_dev, rlat_dev, rhoi, ni, ti, nm, dt, alpha, &
&                  dback, kldv, kldvmn, ksrc, ksrcmn, rdpldv, tau, ubi, &
&                  ubm, xv, yv, utgw, vtgw, ttgw, tauox_dev, tauoy_dev, &
&                  feo_dev, fepo_dev, utosrc, vtosrc, ttosrc, tau0x, &
&                  tau0y, effgworo_dev)
! Add the orographic tendencies to the spectrum tendencies
! Compute the temperature tendency from energy conservation (includes spectrum).
      DO k=1,pver
        dudt_gwd_dev(i, k) = dudt_gwd_dev(i, k) + utgw(k)
        dvdt_gwd_dev(i, k) = dvdt_gwd_dev(i, k) + vtgw(k)
      END DO
    END IF
!          dtdt_gwd_dev(i,k) = dtdt_gwd_dev(i,k) + ttgw(k)
    DO k=1,pver
      u_dev(i, k) = u_dev(i, k) + dudt_gwd_dev(i, k)*dt
      v_dev(i, k) = v_dev(i, k) + dvdt_gwd_dev(i, k)*dt
    END DO
!       t_dev(i,k) = t_dev(i,k) + dtdt_gwd_dev(i,k)*dt
    RETURN
  END SUBROUTINE GW_INTR
!================================================================================
  SUBROUTINE GW_PROF(i, k, pcols, pver, u, v, t, pm, pi, rhoi, ni, ti, &
&    nm)
    IMPLICIT NONE
!-----------------------------------------------------------------------
! Compute profiles of background state quantities for the multiple
! gravity wave drag parameterization.
! 
! The parameterization is assumed to operate only where water vapor 
! concentrations are negligible in determining the density.
!-----------------------------------------------------------------------
!------------------------------Arguments--------------------------------
! current atmospheric column
    INTEGER, INTENT(IN) :: i
! current atmospheric layer
    INTEGER, INTENT(IN) :: k
! number of atmospheric columns
    INTEGER, INTENT(IN) :: pcols
! number of vertical layers
    INTEGER, INTENT(IN) :: pver
! midpoint zonal wind
    REAL :: u(pcols, pver)
! midpoint meridional wind
    REAL :: v(pcols, pver)
! midpoint temperatures
    REAL :: t(pcols, pver)
! midpoint pressures
    REAL :: pm(pcols, pver)
! interface pressures
    REAL :: pi(pcols, 0:pver)
! interface density
    REAL :: rhoi(0:pver)
! interface Brunt-Vaisalla frequency
    REAL :: ni(0:pver)
! interface temperature
    REAL :: ti(0:pver)
! midpoint Brunt-Vaisalla frequency
    REAL :: nm(pver)
!---------------------------Local storage-------------------------------
    REAL :: dtdp
! Brunt-Vaisalla frequency squared
    REAL :: n2
! Brunt-Vaisalla frequency squared
    REAL :: t_new, t_new_
    REAL :: arg1
    INTRINSIC MAX
    INTRINSIC SQRT
    REAL :: max1
!-----------------------------------------------------------------------------
! Determine the interface densities and Brunt-Vaisala frequencies.
!-----------------------------------------------------------------------------
! The top interface values are calculated assuming an isothermal atmosphere 
! above the top level.
    IF (k .EQ. 0) THEN
      ti(k) = t(i, k+1)
      CALL GET_TI(t_new, ti(k))
      rhoi(k) = pi(i, k)/(mapl_rgas*t_new)
      arg1 = mapl_grav*mapl_grav/(mapl_cp*t_new)
      ni(k) = SQRT(arg1)
! Interior points use centered differences
    ELSE IF (k .GT. 0 .AND. k .LT. pver) THEN
      ti(k) = 0.5*(t(i, k)+t(i, k+1))
      CALL GET_TI(t_new, ti(k))
      rhoi(k) = pi(i, k)/(mapl_rgas*t_new)
      dtdp = (t(i, k+1)-t(i, k))/(pm(i, k+1)-pm(i, k))
      CALL GET_TI(t_new_, dtdp)
      n2 = mapl_grav*mapl_grav/t_new*(1./mapl_cp-rhoi(k)*t_new_)
      IF (n2min .LT. n2) THEN
        max1 = n2
      ELSE
        max1 = n2min
      END IF
      ni(k) = SQRT(max1)
! Bottom interface uses bottom level temperature, density; next interface
! B-V frequency.
    ELSE IF (k .EQ. pver) THEN
      ti(k) = t(i, k)
      CALL GET_TI(t_new, ti(k))
      rhoi(k) = pi(i, k)/(mapl_rgas*t_new)
      ni(k) = ni(k-1)
    END IF
!-----------------------------------------------------------------------------
! Determine the midpoint Brunt-Vaisala frequencies.
!-----------------------------------------------------------------------------
    IF (k .GT. 0) nm(k) = 0.5*(ni(k-1)+ni(k))
    RETURN
  END SUBROUTINE GW_PROF
!  Differentiation of gw_oro in forward (tangent) mode:
!   variations  of output variables: tau xv yv ubi
!   with respect to input variables: tau u v ubi ubm
!================================================================================
  SUBROUTINE GW_ORO_D(i, pcols, pver, pgwv, u, ud, v, vd, t, sgh, pm, pi&
&    , dpm, zm, nm, kldv, kldvmn, ksrc, ksrcmn, rdpldv, tau, taud, ubi, &
&    ubid, ubm, ubmd, xv, xvd, yv, yvd, kbot, rlat)
    IMPLICIT NONE
!-----------------------------------------------------------------------
! Orographic source for multiple gravity wave drag parameterization.
! 
! The stress is returned for a single wave with c=0, over orography.
! For points where the orographic variance is small (including ocean),
! the returned stress is zero. 
!------------------------------Arguments--------------------------------
! number of current column
    INTEGER, INTENT(IN) :: i
! number of atmospheric columns
    INTEGER, INTENT(IN) :: pcols
! number of atmospheric columns
    INTEGER, INTENT(IN) :: pver
! number of waves allowed
    INTEGER, INTENT(IN) :: pgwv
! midpoint zonal wind
    REAL :: u(pcols, pver)
    REAL :: ud(pcols, pver)
! midpoint meridional wind
    REAL :: v(pcols, pver)
    REAL :: vd(pcols, pver)
! midpoint temperatures
    REAL :: t(pcols, pver)
! standard deviation of orography
    REAL :: sgh(pcols)
! midpoint pressures
    REAL :: pm(pcols, pver)
! interface pressures
    REAL :: pi(pcols, 0:pver)
! midpoint delta p (pi(k)-pi(k-1))
    REAL :: dpm(pcols, pver)
! midpoint heights
    REAL :: zm(pcols, pver)
! midpoint Brunt-Vaisalla frequency
    REAL :: nm(pver)
! top interface of low level stress div region
    INTEGER :: kldv
! min value of kldv
    INTEGER :: kldvmn
! index of top interface of source region
    INTEGER :: ksrc
! min value of ksrc
    INTEGER :: ksrcmn
! 1/dp across low level divergence region
    REAL :: rdpldv
! wave Reynolds stress
    REAL :: tau(-pgwv:pgwv, 0:pver)
    REAL :: taud(-pgwv:pgwv, 0:pver)
! projection of wind at interfaces
    REAL :: ubi(0:pver)
    REAL :: ubid(0:pver)
! projection of wind at midpoints
    REAL :: ubm(pver)
    REAL :: ubmd(pver)
! unit vectors of source wind (x)
    REAL :: xv
    REAL :: xvd
! unit vectors of source wind (y)
    REAL :: yv
    REAL :: yvd
    INTEGER :: kbot
    REAL :: rlat(pcols)
!---------------------------Local storage-------------------------------
! loop indexes
    INTEGER :: k
! Source-layer basic-state wind
    REAL :: ubsrc
    REAL :: ubsrcd
! surface streamline displacment height (2*sgh)
    REAL :: hdsp
! max orographic sdv to use
    REAL :: sghmax
    REAL :: sghmaxd
! c=0 stress from orography
    REAL :: tauoro
    REAL :: tauorod
!    real    :: zldv                              ! top of the low level stress divergence region
! b-f frequency averaged over source region
    REAL :: nsrc
! interface pressure at top of source region
    REAL :: psrc
! density averaged over source region
    REAL :: rsrc
! u wind averaged over source region
    REAL :: usrc
    REAL :: usrcd
! v wind averaged over source region
    REAL :: vsrc
    REAL :: vsrcd
    REAL :: u_new, v_new, t_new
    REAL :: u_newd, v_newd
    REAL :: arg1
    REAL :: arg1d
    REAL :: result1
    REAL :: min1
    REAL :: min1d
    INTRINSIC MIN
    INTRINSIC SQRT
! Begins
!---------------------------------------------------------------------------
! Average the basic state variables for the wave source over the depth of
! the orographic standard deviation. Here we assume that the apropiate
! values of wind, stability, etc. for determining the wave source are 
! averages over the depth of the atmosphere pentrated by the typical mountain.
! Reduces to the bottom midpoint values when sgh=0, such as over ocean.
! 
! Also determine the depth of the low level stress divergence region, as
! the max of the boundary layer depth and the source region depth. This
! can be done here if the stress magnitude does not determine the depth,
! otherwise it must be done below.
!---------------------------------------------------------------------------
    ksrc = pver - 1
    kldv = pver - 1
    psrc = pi(i, pver-1)
    CALL GET_TI(t_new, t(i, pver))
    rsrc = pm(i, pver)/(mapl_rgas*t_new)*dpm(i, pver)
    CALL GET_UV_D(u_new, u_newd, u(i, pver), ud(i, pver))
    CALL GET_UV_D(v_new, v_newd, v(i, pver), vd(i, pver))
    usrcd = dpm(i, pver)*u_newd
    usrc = u_new*dpm(i, pver)
    vsrcd = dpm(i, pver)*v_newd
    vsrc = v_new*dpm(i, pver)
    nsrc = nm(pver)*dpm(i, pver)
    hdsp = 2.0*sgh(i)
    DO k=pver-1,pver/2,-1
      arg1 = zm(i, k)*zm(i, k+1)
      result1 = SQRT(arg1)
      IF (hdsp .GT. result1) THEN
        ksrc = k - 1
        kldv = k - 1
        psrc = pi(i, k-1)
        CALL GET_TI(t_new, t(i, k))
        rsrc = rsrc + pm(i, k)/(mapl_rgas*t_new)*dpm(i, k)
        CALL GET_UV_D(u_new, u_newd, u(i, k), ud(i, k))
        CALL GET_UV_D(v_new, v_newd, v(i, k), vd(i, k))
        usrcd = usrcd + dpm(i, k)*u_newd
        usrc = usrc + u_new*dpm(i, k)
        vsrcd = vsrcd + dpm(i, k)*v_newd
        vsrc = vsrc + v_new*dpm(i, k)
        nsrc = nsrc + nm(k)*dpm(i, k)
      END IF
    END DO
    rsrc = rsrc/(pi(i, pver)-psrc)
    usrcd = usrcd/(pi(i, pver)-psrc)
    usrc = usrc/(pi(i, pver)-psrc)
    vsrcd = vsrcd/(pi(i, pver)-psrc)
    vsrc = vsrc/(pi(i, pver)-psrc)
    nsrc = nsrc/(pi(i, pver)-psrc)
    IF (usrc .EQ. 0. .AND. vsrc .EQ. 0.) THEN
      ubsrc = SQRT(ubmc2mn)
      xv = 1.
      yv = 0.
      xvd = 0.0_8
      yvd = 0.0_8
      ubsrcd = 0.0_8
    ELSE
      arg1d = 2*usrc*usrcd + 2*vsrc*vsrcd
      arg1 = usrc**2 + vsrc**2
      IF (arg1 .EQ. 0.0) THEN
        ubsrcd = 0.0_8
      ELSE
        ubsrcd = arg1d/(2.0*SQRT(arg1))
      END IF
      ubsrc = SQRT(arg1)
      xvd = (usrcd*ubsrc-usrc*ubsrcd)/ubsrc**2
      xv = usrc/ubsrc
      yvd = (vsrcd*ubsrc-vsrc*ubsrcd)/ubsrc**2
      yv = vsrc/ubsrc
    END IF
! Project the local wind at midpoints onto the source wind.
    DO k=1,pver
      ubmd(k) = ud(i, k)*xv + u(i, k)*xvd + vd(i, k)*yv + v(i, k)*yvd
      ubm(k) = u(i, k)*xv + v(i, k)*yv
    END DO
! Compute the interface wind projection by averaging the midpoint winds.
! Use the top level wind at the top interface.
    ubid(0) = ubmd(1)
    ubi(0) = ubm(1)
    DO k=1,pver
      ubid(k) = ubmd(k)
      ubi(k) = ubm(k)
    END DO
! Determine the orographic c=0 source term following McFarlane (1987).
! Set the source top interface index to pver, if the orographic term is zero.
    IF (ubsrc .GT. orovmin .AND. hdsp .GT. orohmin) THEN
      sghmaxd = fcrit2*2*ubsrc*ubsrcd/nsrc**2
      sghmax = fcrit2*(ubsrc/nsrc)**2
      IF (hdsp**2 .GT. sghmax) THEN
        min1d = sghmaxd
        min1 = sghmax
      ELSE
        min1 = hdsp**2
        min1d = 0.0_8
      END IF
      tauorod = oroko2*rsrc*nsrc*(min1d*ubsrc+min1*ubsrcd)
      tauoro = oroko2*min1*rsrc*nsrc*ubsrc
    ELSE
      tauoro = 0.
      ksrc = pver
      kldv = pver
      tauorod = 0.0_8
    END IF
! tauoro is nontrivial when ubsrc is positive. However, if ubi(ksrc) is negative
! [note that the sign of ubsrc is irrelevant to the sign of ubi(ksrc)], orographic
! GWs can propagative upward passing through the negative basic-state wind.
! The following is to prevent this physically unjustified simulation.
! In addition, even if ubi(ksrc) > 0, if ubm(ksrc) < 0 .and. ubi(ksrc-1) < 0,
! negative wave stress leads to the acceleration of the negative ubm(ksrc).
! This result is physically inconsistent. However, if ubm(ksrc) > 0 .and.
! ubi(ksrc-1) < 0, GWs are filtered in physically consistent way, and
! decelerate the positive ubm(ksrc). Therefore, GWs are also assumed not to be
! launched when ubm(ksrc) < 0.
    IF (ubi(kbot) .LT. 0. .OR. ubm(kbot) .LT. 0.) THEN
      tauoro = 0.
      ksrc = pver
      kldv = pver
      tauorod = 0.0_8
    END IF
! Sets kbot equal to ksrc
    kbot = ksrc
! Set the phase speeds and wave numbers in the direction of the source wind.
! Set the source stress magnitude (positive only, note that the sign of the 
! stress is the same as (c-u).
    taud(0, kbot) = tauorod
    tau(0, kbot) = tauoro
! Determine the min value of kldv and ksrc for limiting later loops
! and the pressure at the top interface of the low level stress divergence
! region.
    ksrcmn = pver
    kldvmn = pver
    IF (ksrcmn .GT. ksrc) THEN
      ksrcmn = ksrc
    ELSE
      ksrcmn = ksrcmn
    END IF
    IF (kldvmn .GT. kldv) THEN
      kldvmn = kldv
    ELSE
      kldvmn = kldvmn
    END IF
    IF (kldv .NE. pver) rdpldv = 1./(pi(i, kldv)-pi(i, pver))
! kldvmn is always pver because FRACLDV == 0.
    IF (fracldv .LE. 0.) kldvmn = pver
    RETURN
  END SUBROUTINE GW_ORO_D
!================================================================================
  SUBROUTINE GW_ORO(i, pcols, pver, pgwv, u, v, t, sgh, pm, pi, dpm, zm&
&    , nm, kldv, kldvmn, ksrc, ksrcmn, rdpldv, tau, ubi, ubm, xv, yv, &
&    kbot, rlat)
    IMPLICIT NONE
!-----------------------------------------------------------------------
! Orographic source for multiple gravity wave drag parameterization.
! 
! The stress is returned for a single wave with c=0, over orography.
! For points where the orographic variance is small (including ocean),
! the returned stress is zero. 
!------------------------------Arguments--------------------------------
! number of current column
    INTEGER, INTENT(IN) :: i
! number of atmospheric columns
    INTEGER, INTENT(IN) :: pcols
! number of atmospheric columns
    INTEGER, INTENT(IN) :: pver
! number of waves allowed
    INTEGER, INTENT(IN) :: pgwv
! midpoint zonal wind
    REAL :: u(pcols, pver)
! midpoint meridional wind
    REAL :: v(pcols, pver)
! midpoint temperatures
    REAL :: t(pcols, pver)
! standard deviation of orography
    REAL :: sgh(pcols)
! midpoint pressures
    REAL :: pm(pcols, pver)
! interface pressures
    REAL :: pi(pcols, 0:pver)
! midpoint delta p (pi(k)-pi(k-1))
    REAL :: dpm(pcols, pver)
! midpoint heights
    REAL :: zm(pcols, pver)
! midpoint Brunt-Vaisalla frequency
    REAL :: nm(pver)
! top interface of low level stress div region
    INTEGER :: kldv
! min value of kldv
    INTEGER :: kldvmn
! index of top interface of source region
    INTEGER :: ksrc
! min value of ksrc
    INTEGER :: ksrcmn
! 1/dp across low level divergence region
    REAL :: rdpldv
! wave Reynolds stress
    REAL :: tau(-pgwv:pgwv, 0:pver)
! projection of wind at interfaces
    REAL :: ubi(0:pver)
! projection of wind at midpoints
    REAL :: ubm(pver)
! unit vectors of source wind (x)
    REAL :: xv
! unit vectors of source wind (y)
    REAL :: yv
    INTEGER :: kbot
    REAL :: rlat(pcols)
!---------------------------Local storage-------------------------------
! loop indexes
    INTEGER :: k
! Source-layer basic-state wind
    REAL :: ubsrc
! surface streamline displacment height (2*sgh)
    REAL :: hdsp
! max orographic sdv to use
    REAL :: sghmax
! c=0 stress from orography
    REAL :: tauoro
!    real    :: zldv                              ! top of the low level stress divergence region
! b-f frequency averaged over source region
    REAL :: nsrc
! interface pressure at top of source region
    REAL :: psrc
! density averaged over source region
    REAL :: rsrc
! u wind averaged over source region
    REAL :: usrc
! v wind averaged over source region
    REAL :: vsrc
    REAL :: u_new, v_new, t_new
    REAL :: arg1
    REAL :: result1
    REAL :: min1
    INTRINSIC MIN
    INTRINSIC SQRT
! Begins
!---------------------------------------------------------------------------
! Average the basic state variables for the wave source over the depth of
! the orographic standard deviation. Here we assume that the apropiate
! values of wind, stability, etc. for determining the wave source are 
! averages over the depth of the atmosphere pentrated by the typical mountain.
! Reduces to the bottom midpoint values when sgh=0, such as over ocean.
! 
! Also determine the depth of the low level stress divergence region, as
! the max of the boundary layer depth and the source region depth. This
! can be done here if the stress magnitude does not determine the depth,
! otherwise it must be done below.
!---------------------------------------------------------------------------
    ksrc = pver - 1
    kldv = pver - 1
    psrc = pi(i, pver-1)
    CALL GET_TI(t_new, t(i, pver))
    rsrc = pm(i, pver)/(mapl_rgas*t_new)*dpm(i, pver)
    CALL GET_UV(u_new, u(i, pver))
    CALL GET_UV(v_new, v(i, pver))
    usrc = u_new*dpm(i, pver)
    vsrc = v_new*dpm(i, pver)
    nsrc = nm(pver)*dpm(i, pver)
    hdsp = 2.0*sgh(i)
    DO k=pver-1,pver/2,-1
      arg1 = zm(i, k)*zm(i, k+1)
      result1 = SQRT(arg1)
      IF (hdsp .GT. result1) THEN
        ksrc = k - 1
        kldv = k - 1
        psrc = pi(i, k-1)
        CALL GET_TI(t_new, t(i, k))
        rsrc = rsrc + pm(i, k)/(mapl_rgas*t_new)*dpm(i, k)
        CALL GET_UV(u_new, u(i, k))
        CALL GET_UV(v_new, v(i, k))
        usrc = usrc + u_new*dpm(i, k)
        vsrc = vsrc + v_new*dpm(i, k)
        nsrc = nsrc + nm(k)*dpm(i, k)
      END IF
    END DO
    rsrc = rsrc/(pi(i, pver)-psrc)
    usrc = usrc/(pi(i, pver)-psrc)
    vsrc = vsrc/(pi(i, pver)-psrc)
    nsrc = nsrc/(pi(i, pver)-psrc)
    IF (usrc .EQ. 0. .AND. vsrc .EQ. 0.) THEN
      ubsrc = SQRT(ubmc2mn)
      xv = 1.
      yv = 0.
    ELSE
      arg1 = usrc**2 + vsrc**2
      ubsrc = SQRT(arg1)
      xv = usrc/ubsrc
      yv = vsrc/ubsrc
    END IF
! Project the local wind at midpoints onto the source wind.
    DO k=1,pver
      ubm(k) = u(i, k)*xv + v(i, k)*yv
    END DO
! Compute the interface wind projection by averaging the midpoint winds.
! Use the top level wind at the top interface.
    ubi(0) = ubm(1)
    DO k=1,pver
      ubi(k) = ubm(k)
    END DO
! Determine the orographic c=0 source term following McFarlane (1987).
! Set the source top interface index to pver, if the orographic term is zero.
    IF (ubsrc .GT. orovmin .AND. hdsp .GT. orohmin) THEN
      sghmax = fcrit2*(ubsrc/nsrc)**2
      IF (hdsp**2 .GT. sghmax) THEN
        min1 = sghmax
      ELSE
        min1 = hdsp**2
      END IF
      tauoro = oroko2*min1*rsrc*nsrc*ubsrc
    ELSE
      tauoro = 0.
      ksrc = pver
      kldv = pver
    END IF
! tauoro is nontrivial when ubsrc is positive. However, if ubi(ksrc) is negative
! [note that the sign of ubsrc is irrelevant to the sign of ubi(ksrc)], orographic
! GWs can propagative upward passing through the negative basic-state wind.
! The following is to prevent this physically unjustified simulation.
! In addition, even if ubi(ksrc) > 0, if ubm(ksrc) < 0 .and. ubi(ksrc-1) < 0,
! negative wave stress leads to the acceleration of the negative ubm(ksrc).
! This result is physically inconsistent. However, if ubm(ksrc) > 0 .and.
! ubi(ksrc-1) < 0, GWs are filtered in physically consistent way, and
! decelerate the positive ubm(ksrc). Therefore, GWs are also assumed not to be
! launched when ubm(ksrc) < 0.
    IF (ubi(kbot) .LT. 0. .OR. ubm(kbot) .LT. 0.) THEN
      tauoro = 0.
      ksrc = pver
      kldv = pver
    END IF
! Sets kbot equal to ksrc
    kbot = ksrc
! Set the phase speeds and wave numbers in the direction of the source wind.
! Set the source stress magnitude (positive only, note that the sign of the 
! stress is the same as (c-u).
    tau(0, kbot) = tauoro
! Determine the min value of kldv and ksrc for limiting later loops
! and the pressure at the top interface of the low level stress divergence
! region.
    ksrcmn = pver
    kldvmn = pver
    IF (ksrcmn .GT. ksrc) THEN
      ksrcmn = ksrc
    ELSE
      ksrcmn = ksrcmn
    END IF
    IF (kldvmn .GT. kldv) THEN
      kldvmn = kldv
    ELSE
      kldvmn = kldvmn
    END IF
    IF (kldv .NE. pver) rdpldv = 1./(pi(i, kldv)-pi(i, pver))
! kldvmn is always pver because FRACLDV == 0.
    IF (fracldv .LE. 0.) kldvmn = pver
    RETURN
  END SUBROUTINE GW_ORO
!  Differentiation of gw_bgnd in forward (tangent) mode:
!   variations  of output variables: xv yv ubi ubm
!   with respect to input variables: u v
!===============================================================================
  SUBROUTINE GW_BGND_D(i, pcols, pver, c, u, ud, v, vd, t, pm, pi, dpm, &
&    rdpm, piln, rlat, kldv, kldvmn, ksrc, ksrcmn, rdpldv, tau, ubi, ubid&
&    , ubm, ubmd, xv, xvd, yv, yvd, ngwv, kbot)
    IMPLICIT NONE
!-----------------------------------------------------------------------
! Driver for multiple gravity wave drag parameterization.
! 
! The parameterization is assumed to operate only where water vapor 
! concentrations are negligible in determining the density.
!-----------------------------------------------------------------------
!------------------------------Arguments--------------------------------
! number of current column
    INTEGER :: i
! number of atmospheric columns
    INTEGER :: pcols
! number of atmospheric columns
    INTEGER :: pver
! index of bottom (source) interface
    INTEGER :: kbot
! number of gravity waves to use
    INTEGER :: ngwv
! wave phase speeds
    REAL :: c(-ngwv:ngwv)
! midpoint zonal wind
    REAL :: u(pcols, pver)
    REAL :: ud(pcols, pver)
! midpoint meridional wind
    REAL :: v(pcols, pver)
    REAL :: vd(pcols, pver)
! midpoint temperatures
    REAL :: t(pcols, pver)
! midpoint pressures
    REAL :: pm(pcols, pver)
! interface pressures
    REAL :: pi(pcols, 0:pver)
! midpoint delta p (pi(k)-pi(k-1))
    REAL :: dpm(pcols, pver)
! 1. / (pi(k)-pi(k-1))
    REAL :: rdpm(pcols, pver)
! ln(interface pressures)
    REAL :: piln(pcols, 0:pver)
! latitude in radians for columns
    REAL :: rlat(pcols)
! top interface of low level stress divergence region
    INTEGER :: kldv
! min value of kldv
    INTEGER :: kldvmn
! index of top interface of source region
    INTEGER :: ksrc
! min value of ksrc
    INTEGER :: ksrcmn
! 1/dp across low level divergence region
    REAL :: rdpldv
! wave Reynolds stress
    REAL :: tau(-ngwv:ngwv, 0:pver)
! projection of wind at interfaces
    REAL :: ubi(0:pver)
    REAL :: ubid(0:pver)
! projection of wind at midpoints
    REAL :: ubm(pver)
    REAL :: ubmd(pver)
! unit vectors of source wind (x)
    REAL :: xv
    REAL :: xvd
! unit vectors of source wind (y)
    REAL :: yv
    REAL :: yvd
!---------------------------Local storage-------------------------------
! loop indexes
    INTEGER :: k, l
! background stress at c=0
    REAL :: tauback
! u wind averaged over source region
    REAL :: usrc
    REAL :: usrcd
! v wind averaged over source region
    REAL :: vsrc
    REAL :: vsrcd
    REAL :: ubsrc
    REAL :: ubsrcd
! Used in lat dependence of GW spec. 
    REAL :: al0
! Used in lat dependence of GW spec.
    REAL :: dlat0
    REAL :: latdeg
! The actual lat dependence of GW spec.
    REAL :: flat_gw
    REAL :: u_new, v_new, tau_new
    REAL :: arg1
    REAL :: arg1d
    INTRINSIC DEXP
    INTRINSIC EXP
    INTRINSIC MAX
    INTRINSIC ABS
    REAL :: x1
    REAL :: x1d
    INTRINSIC DBLE
    REAL :: abs6
    REAL :: abs5
    REAL :: abs4
    REAL :: abs3
    REAL :: abs2
    REAL :: abs1
    INTRINSIC SQRT
    REAL :: y1
!---------------------------------------------------------------------------
! Determine the source layer wind and unit vectors, then project winds.
!---------------------------------------------------------------------------
! Just use the source level interface values for the source
! wind speed and direction (unit vector).
    ubm = 0.
    ubi = 0.
    xv = 0.
    yv = 0.
    tau = 0.
    ksrc = kbot
    kldv = kbot
    usrcd = 0.5*(ud(i, kbot+1)+ud(i, kbot))
    usrc = 0.5*(u(i, kbot+1)+u(i, kbot))
    vsrcd = 0.5*(vd(i, kbot+1)+vd(i, kbot))
    vsrc = 0.5*(v(i, kbot+1)+v(i, kbot))
    arg1d = 2*usrc*usrcd + 2*vsrc*vsrcd
    arg1 = usrc**2 + vsrc**2
    IF (arg1 .EQ. 0.0) THEN
      x1d = 0.0_8
    ELSE
      x1d = arg1d/(2.0*SQRT(arg1))
    END IF
    x1 = SQRT(arg1)
    y1 = SQRT(ubmc2mn)
    IF (x1 .LT. y1) THEN
      ubsrc = y1
      ubsrcd = 0.0_8
    ELSE
      ubsrcd = x1d
      ubsrc = x1
    END IF
    IF (usrc .EQ. 0. .AND. vsrc .EQ. 0.) THEN
      xv = 1.0
      yv = 0.0
      xvd = 0.0_8
      yvd = 0.0_8
      ubmd(:) = 0.0_8
    ELSE
      xvd = (usrcd*ubsrc-usrc*ubsrcd)/ubsrc**2
      xv = usrc/ubsrc
      yvd = (vsrcd*ubsrc-vsrc*ubsrcd)/ubsrc**2
      yv = vsrc/ubsrc
      ubmd(:) = 0.0_8
    END IF
! Project the local wind at midpoints onto the source wind.
    DO k=1,pver
      ubmd(k) = ud(i, k)*xv + u(i, k)*xvd + vd(i, k)*yv + v(i, k)*yvd
      ubm(k) = u(i, k)*xv + v(i, k)*yv
    END DO
! Compute the bottom interface wind projection using the midpoint winds.
    ubid(0) = ubmd(1)
    ubi(0) = ubm(1)
    DO k=1,pver
      ubid(k) = ubmd(k)
      ubi(k) = ubm(k)
    END DO
!-----------------------------------------------------------------------
! Gravity wave sources
!-----------------------------------------------------------------------
! Determine the background stress at c=0
    tauback = taubgnd*tauscal
! Include dependence on latitude:
    latdeg = rlat(i)*180./pi_gwd
!
    IF (-15.3 .LT. latdeg .AND. latdeg .LT. 15.3) THEN
      IF (latdeg .GE. 0.) THEN
        abs1 = latdeg
      ELSE
        abs1 = -latdeg
      END IF
      arg1 = -(DBLE((abs1-3.)/8.0)**2)
      flat_gw = 1.2*EXP(arg1)
      IF (latdeg .GE. 0.) THEN
        abs2 = latdeg
      ELSE
        abs2 = -latdeg
      END IF
      IF (flat_gw .LT. 1.2 .AND. abs2 .LE. 3.) flat_gw = 1.2
    ELSE IF (latdeg .GT. -31. .AND. latdeg .LE. -15.3) THEN
      flat_gw = 0.10
    ELSE IF (latdeg .LT. 31. .AND. latdeg .GE. 15.3) THEN
      flat_gw = 0.10
    ELSE IF (latdeg .GT. -60. .AND. latdeg .LE. -31.) THEN
      IF (latdeg .GE. 0.) THEN
        abs3 = latdeg
      ELSE
        abs3 = -latdeg
      END IF
      arg1 = -(DBLE((abs3-60.)/23.)**2)
      flat_gw = 0.50*EXP(arg1)
    ELSE IF (latdeg .LT. 60. .AND. latdeg .GE. 31.) THEN
      IF (latdeg .GE. 0.) THEN
        abs4 = latdeg
      ELSE
        abs4 = -latdeg
      END IF
      arg1 = -(DBLE((abs4-60.)/23.)**2)
      flat_gw = 0.50*EXP(arg1)
    ELSE IF (latdeg .LE. -60.) THEN
      IF (latdeg .GE. 0.) THEN
        abs5 = latdeg
      ELSE
        abs5 = -latdeg
      END IF
      arg1 = -(DBLE((abs5-60.)/70.)**2)
      flat_gw = 0.50*EXP(arg1)
    ELSE IF (latdeg .GE. 60.) THEN
      IF (latdeg .GE. 0.) THEN
        abs6 = latdeg
      ELSE
        abs6 = -latdeg
      END IF
      arg1 = -(DBLE((abs6-60.)/70.)**2)
      flat_gw = 0.50*EXP(arg1)
    END IF
    tauback = tauback*flat_gw
! Set the phase speeds and wave numbers in the direction of the source wind.
! Set the source stress magnitude (positive only, note that the sign of the 
! stress is the same as (c-u).
    DO l=1,ngwv
      arg1 = -((c(l)/30.)**2)
      tau(l, kbot) = tauback*EXP(arg1)
      tau(-l, kbot) = tau(l, kbot)
    END DO
    tau(0, kbot) = tauback
! Determine the min value of kldv and ksrc for limiting later loops
! and the pressure at the top interface of the low level stress divergence
! region.
    ksrcmn = pver
    kldvmn = pver
    RETURN
  END SUBROUTINE GW_BGND_D
!===============================================================================
  SUBROUTINE GW_BGND(i, pcols, pver, c, u, v, t, pm, pi, dpm, rdpm, piln&
&    , rlat, kldv, kldvmn, ksrc, ksrcmn, rdpldv, tau, ubi, ubm, xv, yv, &
&    ngwv, kbot)
    IMPLICIT NONE
!-----------------------------------------------------------------------
! Driver for multiple gravity wave drag parameterization.
! 
! The parameterization is assumed to operate only where water vapor 
! concentrations are negligible in determining the density.
!-----------------------------------------------------------------------
!------------------------------Arguments--------------------------------
! number of current column
    INTEGER :: i
! number of atmospheric columns
    INTEGER :: pcols
! number of atmospheric columns
    INTEGER :: pver
! index of bottom (source) interface
    INTEGER :: kbot
! number of gravity waves to use
    INTEGER :: ngwv
! wave phase speeds
    REAL :: c(-ngwv:ngwv)
! midpoint zonal wind
    REAL :: u(pcols, pver)
! midpoint meridional wind
    REAL :: v(pcols, pver)
! midpoint temperatures
    REAL :: t(pcols, pver)
! midpoint pressures
    REAL :: pm(pcols, pver)
! interface pressures
    REAL :: pi(pcols, 0:pver)
! midpoint delta p (pi(k)-pi(k-1))
    REAL :: dpm(pcols, pver)
! 1. / (pi(k)-pi(k-1))
    REAL :: rdpm(pcols, pver)
! ln(interface pressures)
    REAL :: piln(pcols, 0:pver)
! latitude in radians for columns
    REAL :: rlat(pcols)
! top interface of low level stress divergence region
    INTEGER :: kldv
! min value of kldv
    INTEGER :: kldvmn
! index of top interface of source region
    INTEGER :: ksrc
! min value of ksrc
    INTEGER :: ksrcmn
! 1/dp across low level divergence region
    REAL :: rdpldv
! wave Reynolds stress
    REAL :: tau(-ngwv:ngwv, 0:pver)
! projection of wind at interfaces
    REAL :: ubi(0:pver)
! projection of wind at midpoints
    REAL :: ubm(pver)
! unit vectors of source wind (x)
    REAL :: xv
! unit vectors of source wind (y)
    REAL :: yv
!---------------------------Local storage-------------------------------
! loop indexes
    INTEGER :: k, l
! background stress at c=0
    REAL :: tauback
! u wind averaged over source region
    REAL :: usrc
! v wind averaged over source region
    REAL :: vsrc
    REAL :: ubsrc
! Used in lat dependence of GW spec. 
    REAL :: al0
! Used in lat dependence of GW spec.
    REAL :: dlat0
    REAL :: latdeg
! The actual lat dependence of GW spec.
    REAL :: flat_gw
    REAL :: u_new, v_new, tau_new
    REAL :: arg1
    INTRINSIC EXP
    INTRINSIC MAX
    INTRINSIC ABS
    REAL :: x1
    INTRINSIC DBLE
    REAL :: abs6
    REAL :: abs5
    REAL :: abs4
    REAL :: abs3
    REAL :: abs2
    REAL :: abs1
    INTRINSIC SQRT
    REAL :: y1
!---------------------------------------------------------------------------
! Determine the source layer wind and unit vectors, then project winds.
!---------------------------------------------------------------------------
! Just use the source level interface values for the source
! wind speed and direction (unit vector).
    ubm = 0.
    ubi = 0.
    xv = 0.
    yv = 0.
    tau = 0.
    ksrc = kbot
    kldv = kbot
    usrc = 0.5*(u(i, kbot+1)+u(i, kbot))
    vsrc = 0.5*(v(i, kbot+1)+v(i, kbot))
    arg1 = usrc**2 + vsrc**2
    x1 = SQRT(arg1)
    y1 = SQRT(ubmc2mn)
    IF (x1 .LT. y1) THEN
      ubsrc = y1
    ELSE
      ubsrc = x1
    END IF
    IF (usrc .EQ. 0. .AND. vsrc .EQ. 0.) THEN
      xv = 1.0
      yv = 0.0
    ELSE
      xv = usrc/ubsrc
      yv = vsrc/ubsrc
    END IF
! Project the local wind at midpoints onto the source wind.
    DO k=1,pver
      ubm(k) = u(i, k)*xv + v(i, k)*yv
    END DO
! Compute the bottom interface wind projection using the midpoint winds.
    ubi(0) = ubm(1)
    DO k=1,pver
      ubi(k) = ubm(k)
    END DO
!-----------------------------------------------------------------------
! Gravity wave sources
!-----------------------------------------------------------------------
! Determine the background stress at c=0
    tauback = taubgnd*tauscal
! Include dependence on latitude:
    latdeg = rlat(i)*180./pi_gwd
!
    IF (-15.3 .LT. latdeg .AND. latdeg .LT. 15.3) THEN
      IF (latdeg .GE. 0.) THEN
        abs1 = latdeg
      ELSE
        abs1 = -latdeg
      END IF
      arg1 = -(DBLE((abs1-3.)/8.0)**2)
      flat_gw = 1.2*EXP(arg1)
      IF (latdeg .GE. 0.) THEN
        abs2 = latdeg
      ELSE
        abs2 = -latdeg
      END IF
      IF (flat_gw .LT. 1.2 .AND. abs2 .LE. 3.) flat_gw = 1.2
    ELSE IF (latdeg .GT. -31. .AND. latdeg .LE. -15.3) THEN
      flat_gw = 0.10
    ELSE IF (latdeg .LT. 31. .AND. latdeg .GE. 15.3) THEN
      flat_gw = 0.10
    ELSE IF (latdeg .GT. -60. .AND. latdeg .LE. -31.) THEN
      IF (latdeg .GE. 0.) THEN
        abs3 = latdeg
      ELSE
        abs3 = -latdeg
      END IF
      arg1 = -(DBLE((abs3-60.)/23.)**2)
      flat_gw = 0.50*EXP(arg1)
    ELSE IF (latdeg .LT. 60. .AND. latdeg .GE. 31.) THEN
      IF (latdeg .GE. 0.) THEN
        abs4 = latdeg
      ELSE
        abs4 = -latdeg
      END IF
      arg1 = -(DBLE((abs4-60.)/23.)**2)
      flat_gw = 0.50*EXP(arg1)
    ELSE IF (latdeg .LE. -60.) THEN
      IF (latdeg .GE. 0.) THEN
        abs5 = latdeg
      ELSE
        abs5 = -latdeg
      END IF
      arg1 = -(DBLE((abs5-60.)/70.)**2)
      flat_gw = 0.50*EXP(arg1)
    ELSE IF (latdeg .GE. 60.) THEN
      IF (latdeg .GE. 0.) THEN
        abs6 = latdeg
      ELSE
        abs6 = -latdeg
      END IF
      arg1 = -(DBLE((abs6-60.)/70.)**2)
      flat_gw = 0.50*EXP(arg1)
    END IF
    tauback = tauback*flat_gw
! Set the phase speeds and wave numbers in the direction of the source wind.
! Set the source stress magnitude (positive only, note that the sign of the 
! stress is the same as (c-u).
    DO l=1,ngwv
      arg1 = -((c(l)/30.)**2)
      tau(l, kbot) = tauback*EXP(arg1)
      tau(-l, kbot) = tau(l, kbot)
    END DO
    tau(0, kbot) = tauback
! Determine the min value of kldv and ksrc for limiting later loops
! and the pressure at the top interface of the low level stress divergence
! region.
    ksrcmn = pver
    kldvmn = pver
    RETURN
  END SUBROUTINE GW_BGND
!  Differentiation of gw_drag_prof in forward (tangent) mode:
!   variations  of output variables: ut vt
!   with respect to input variables: tau xv ut yv vt ubi
!===============================================================================
  SUBROUTINE GW_DRAG_PROF_D(i, pcols, pver, pgwv, ngwv, kbot, ktop, c, u&
&    , v, t, pi, dpm, rdpm, piln, rlat, rhoi, ni, ti, nm, dt, alpha, &
&    dback, kldv, kldvmn, ksrc, ksrcmn, rdpldv, tau, taud, ubi, ubid, ubm&
&    , xv, xvd, yv, yvd, ut, utd, vt, vtd, tt, taugwx, taugwy, fegw, &
&    fepgw, dusrc, dvsrc, dtsrc, tau0x, tau0y, effgw)
    IMPLICIT NONE
!-----------------------------------------------------------------------
! Solve for the drag profile from the multiple gravity wave drag
! parameterization.
! 1. scan up from the wave source to determine the stress profile
! 2. scan down the stress profile to determine the tendencies
!     => apply bounds to the tendency
!          a. from wkb solution
!          b. from computational stability constraints
!     => adjust stress on interface below to reflect actual bounded tendency
!-----------------------------------------------------------------------
!------------------------------Arguments--------------------------------
! number of current column
    INTEGER, INTENT(IN) :: i
! number of atmospheric columns
    INTEGER, INTENT(IN) :: pcols
! number of atmospheric columns
    INTEGER, INTENT(IN) :: pver
! index of bottom (source) interface
    INTEGER, INTENT(IN) :: kbot
! index of top interface of gwd region
    INTEGER, INTENT(IN) :: ktop
! number of gravity waves possible
    INTEGER, INTENT(IN) :: pgwv
! number of gravity waves to use
    INTEGER, INTENT(IN) :: ngwv
! top interface of low level stress  divergence region
    INTEGER, INTENT(IN) :: kldv
! min value of kldv
    INTEGER, INTENT(IN) :: kldvmn
! index of top interface of source region
    INTEGER, INTENT(IN) :: ksrc
! min value of ksrc
    INTEGER, INTENT(IN) :: ksrcmn
! wave phase speeds
    REAL :: c(-pgwv:pgwv)
! midpoint zonal wind
    REAL :: u(pcols, pver)
! midpoint meridional wind
    REAL :: v(pcols, pver)
! midpoint temperatures
    REAL :: t(pcols, pver)
! interface pressures
    REAL :: pi(pcols, 0:pver)
! midpoint delta p (pi(k)-pi(k-1))
    REAL :: dpm(pcols, pver)
! 1. / (pi(k)-pi(k-1))
    REAL :: rdpm(pcols, pver)
! ln(interface pressures)
    REAL :: piln(pcols, 0:pver)
    REAL :: rlat(pcols)
! interface density
    REAL :: rhoi(0:pver)
! interface Brunt-Vaisalla frequency
    REAL :: ni(0:pver)
! interface temperature
    REAL :: ti(0:pver)
! midpoint Brunt-Vaisalla frequency
    REAL :: nm(pver)
! time step
    REAL :: dt
! newtonian cooling coefficients
    REAL :: alpha(0:pver)
! newtonian cooling coefficients
    REAL :: dback(0:pver)
! 1/dp across low level divergence region
    REAL :: rdpldv
! projection of wind at interfaces
    REAL :: ubi(0:pver)
    REAL :: ubid(0:pver)
! projection of wind at midpoints
    REAL :: ubm(pver)
! unit vectors of source wind (x)
    REAL :: xv
    REAL :: xvd
! unit vectors of source wind (y)
    REAL :: yv
    REAL :: yvd
! tendency efficiency for gwd 
    REAL :: effgw(pcols)
! wave Reynolds stress
    REAL :: tau(-pgwv:pgwv, 0:pver)
    REAL :: taud(-pgwv:pgwv, 0:pver)
! zonal wind tendency
    REAL :: ut(pver)
    REAL :: utd(pver)
! meridional wind tendency
    REAL :: vt(pver)
    REAL :: vtd(pver)
! temperature tendency
    REAL :: tt(pver)
! Total zonal GW momentum flux
    REAL :: taugwx(pcols, 0:pver)
! Total meridional GW momentum flux
    REAL :: taugwy(pcols, 0:pver)
! Total GW energy flux
    REAL :: fegw(pcols, 0:pver)
! Total GW pseudo energy flux
    REAL :: fepgw(pcols, 0:pver)
! Total U tendency below launch level
    REAL :: dusrc(pver)
! Total V tendency below launch level
    REAL :: dvsrc(pver)
! Total V tendency below launch level
    REAL :: dtsrc(pver)
! c=0 sfc. stress (zonal)
    REAL :: tau0x
! c=0 sfc. stress (meridional)
    REAL :: tau0y
!---------------------------Local storage-------------------------------
! loop indexes
    INTEGER :: k, l
! fraction of dsat to use
    REAL :: dscal
! imaginary part of vertical wavenumber
    REAL :: mi
! stress after damping
    REAL :: taudmp
!real    :: taumax(pcols)                     ! max(tau) for any l
! saturation stress
    REAL :: tausat
    REAL :: tausatd
! (ub-c)
    REAL :: ubmc
    REAL :: ubmcd
! (ub-c)**2
    REAL :: ubmc2
! ubar tendency
    REAL :: ubt
    REAL :: ubtd
! tbar tendency
    REAL :: tbt
! ubar tendency from wave l
    REAL :: ubtl
    REAL :: ubtld
! saturation tendency
    REAL :: ubtlsat
! layer pressure
    REAL :: pm
! layer density
    REAL :: rhom
! launch level height
    REAL :: zlb
! c-u
    REAL :: cmu
    REAL :: dzm, hscal, tautmp
    REAL :: utl
    REAL :: utld
    REAL :: ttl
! zonal pseudomomentum flux spectrum
    REAL :: fpmx
! meridional pseudomomentum flux spectrum
    REAL :: fpmy
! energy flux (p'w') spectrum
    REAL :: fe
! pseudoenergy flux (p'w'+U rho u'w') spectrum
    REAL :: fpe
    REAL :: fpml
    REAL :: fpmt
    REAL :: fpel
    REAL :: fpet
    REAL :: dusrcl
    REAL :: dvsrcl
    REAL :: dtsrcl
    REAL :: zi
    REAL :: effkwvmap
    REAL :: zfac
    REAL :: uhtmax
    REAL :: uhtmaxd
    REAL :: utfac
    REAL :: utfacd
    REAL :: tau_min, cmu_, t_new
    REAL :: tau_mind
    REAL :: arg1
    REAL :: arg1d
    INTRINSIC MAX
    INTRINSIC SIGN
    INTRINSIC ABS
    REAL :: x2
    REAL :: x2d
    REAL :: x1
    REAL :: x1d
    INTRINSIC SQRT
! Initialize gravity wave drag tendencies to zero
    DO l=-ngwv,ngwv
      DO k=pver-1,ktop,-1
        IF (k .LE. kbot - 1) THEN
          taud(l, k) = 0.0_8
          tau(l, k) = 0.
        END IF
      END DO
    END DO
    DO k=1,pver
      utd(k) = 0.0_8
      ut(k) = 0.
      vtd(k) = 0.0_8
      vt(k) = 0.
      tt(k) = 0.
      dusrc(k) = 0.
      dvsrc(k) = 0.
      dtsrc(k) = 0.
    END DO
! Initialize total momentum and energy fluxes to zero
    DO k=0,pver
      taugwx(i, k) = 0.
      taugwy(i, k) = 0.
      fegw(i, k) = 0.
      fepgw(i, k) = 0.
    END DO
! Initialize surface wave stress at c = 0 to zero
    tau0x = 0.
    tau0y = 0.
!---------------------------------------------------------------------------
! Compute the stress profiles and diffusivities
!---------------------------------------------------------------------------
! Determine the absolute value of the saturation stress and the diffusivity
! for each wave.
! Define critical levels where the sign of (u-c) changes between interfaces.
! Loop from bottom to top to get stress profiles
    DO l=-ngwv,ngwv
      DO k=pver-1,ktop,-1
        IF (k .LE. kbot - 1) THEN
!!!!!!!!jk             d = dback(k)
          ubmcd = ubid(k)
          ubmc = ubi(k) - c(l)
          IF (ngwv .GT. 0) THEN
            CALL GET_EFFKWVMAP_1(effkwvmap, rlat(i))
            IF (-15.0 .LT. rlat(i)*180./pi_gwd .AND. rlat(i)*180./pi_gwd&
&                .LT. 15.0) effkwvmap = fcrit2*kwvbeq
          ELSE
            IF (pi(i, k) .LT. 1000.0) THEN
              zfac = (pi(i, k)/1000.0)**3
            ELSE
              zfac = 1.0
            END IF
            IF (rlat(i)*180./pi_gwd .LT. -20.0) THEN
              CALL GET_EFFKWVMAP_2(effkwvmap, rlat(i), zfac)
            ELSE
              CALL GET_EFFKWVMAP_3(effkwvmap, rlat(i), zfac)
            END IF
          END IF
          x1d = effkwvmap*rhoi(k)*3*ubmc**2*ubmcd/(2.*ni(k))
          x1 = effkwvmap*rhoi(k)*ubmc**3/(2.*ni(k))
          IF (x1 .GE. 0.) THEN
            tausatd = x1d
            tausat = x1
          ELSE
            tausatd = -x1d
            tausat = -x1
          END IF
          IF (tausat .LE. taumin) THEN
            tausat = 0.0
            tausatd = 0.0_8
          END IF
          IF (ubmc*(ubi(k+1)-c(l)) .LE. 0.0) THEN
            tausat = 0.0
            tausatd = 0.0_8
          END IF
          IF (k .EQ. ktop) THEN
            tausat = 0.
            tausatd = 0.0_8
          END IF
!
          IF (k .EQ. ktop + 1) THEN
            tausatd = 0.02*tausatd
            tausat = tausat*0.02
          END IF
          IF (k .EQ. ktop + 2) THEN
            tausatd = 0.05*tausatd
            tausat = tausat*0.05
          END IF
          IF (k .EQ. ktop + 3) THEN
            tausatd = 0.10*tausatd
            tausat = tausat*0.10
          END IF
          IF (k .EQ. ktop + 4) THEN
            tausatd = 0.20*tausatd
            tausat = tausat*0.20
          END IF
          IF (k .EQ. ktop + 5) THEN
            tausatd = 0.50*tausatd
            tausat = tausat*0.50
          END IF
!
          tau_mind = tausatd
          tau_min = tausat
          IF (tau_min .GT. tau(l, k+1)) THEN
            tau_mind = taud(l, k+1)
            tau_min = tau(l, k+1)
          END IF
          taud(l, k) = tau_mind
          tau(l, k) = tau_min
        END IF
      END DO
    END DO
!---------------------------------------------------------------------------
! Compute the tendencies from the stress divergence.
!---------------------------------------------------------------------------
! Accumulate the mean wind tendency over wavenumber.
! Loop over levels from top to bottom
    DO k=ktop+1,pver
      ubt = 0.0
      tbt = 0.0
      ubtd = 0.0_8
      DO l=-ngwv,ngwv
        IF (k .LE. kbot) THEN
! Determine the wind tendency including excess stress carried down from above.
          ubtld = mapl_grav*rdpm(i, k)*(taud(l, k)-taud(l, k-1))
          ubtl = mapl_grav*(tau(l, k)-tau(l, k-1))*rdpm(i, k)
! Calculate the sign of wind tendency
          utld = ubtld*SIGN(1.d0, ubtl*(c(l)-ubi(k)))
          utl = SIGN(ubtl, c(l) - ubi(k))
! Accumulate the mean wind tendency over wavenumber.
          ubtd = ubtd + utld
          ubt = ubt + utl
! Calculate irreversible temperature tendency associated with gravity wave breaking.
          ttl = (c(l)-ubm(k))*utl/mapl_cp
! Adding frictional heating associated with the GW momentum forcing
          tbt = tbt + ttl
        END IF
      END DO
! Project the mean wind tendency onto the components and scale by "efficiency".
      IF (k .LE. kbot) THEN
        utd(k) = effgw(i)*(ubtd*xv+ubt*xvd)
        ut(k) = ubt*xv*effgw(i)
        vtd(k) = effgw(i)*(ubtd*yv+ubt*yvd)
        vt(k) = ubt*yv*effgw(i)
        tt(k) = tbt*effgw(i)
      END IF
    END DO
!-----------------------------------------------------------------------
! Calculates wind and temperature tendencies below launch level for
! energy and momentum conservation (does nothing for orographic GWs).
!-----------------------------------------------------------------------
!----kimmmmm here
! Calculate launch level height
    zlb = 0.
    DO k=ktop+1,pver
      IF (k .GE. kbot + 1) THEN
! Define layer pressure and density
        pm = (pi(i, k-1)+pi(i, k))*0.5
        CALL GET_TI(t_new, t(i, k))
        rhom = pm/(mapl_rgas*t_new)
        zlb = zlb + dpm(i, k)/mapl_grav/rhom
      END IF
    END DO
!-----------------------------------------------------------------------
! Calculates energy and momentum flux profiles
!-----------------------------------------------------------------------
    DO l=-ngwv,ngwv
      DO k=ktop,pver
        IF (k .LE. kbot) THEN
          cmu = c(l) - ubi(k)
          CALL GET_CMU(cmu_, cmu)
          fpmx = cmu_*tau(l, k)*xv*effgw(i)
          fpmy = cmu_*tau(l, k)*yv*effgw(i)
          fe = cmu*cmu_*tau(l, k)*effgw(i)
          fpe = c(l)*cmu_*tau(l, k)*effgw(i)
          IF (k .EQ. kbot) THEN
            fpml = fpmx*xv + fpmy*yv
            fpel = fpe
          END IF
          IF (k .EQ. ktop) THEN
            fpmt = fpmx*xv + fpmy*yv
            fpet = fpe
          END IF
! Record outputs for GW fluxes
          taugwx(i, k) = taugwx(i, k) + fpmx
          taugwy(i, k) = taugwy(i, k) + fpmy
          fegw(i, k) = fegw(i, k) + fe
          fepgw(i, k) = fepgw(i, k) + fpe
        END IF
      END DO
      DO k=ktop+1,pver
        IF (k .GE. kbot + 1) THEN
! Define layer pressure and density
          pm = (pi(i, k-1)+pi(i, k))*0.5
          CALL GET_TI(t_new, t(i, k))
          rhom = pm/(mapl_rgas*t_new)
          dusrcl = -((fpml-fpmt)/(rhom*zlb)*xv)
          dvsrcl = -((fpml-fpmt)/(rhom*zlb)*yv)
          dtsrcl = -((fpel-fpet-ubm(k)*(fpml-fpmt))/(rhom*zlb*mapl_cp))
! Add sub-source wind and temperature tendencies
          dusrc(k) = dusrc(k) + dusrcl
          dvsrc(k) = dvsrc(k) + dvsrcl
          dtsrc(k) = dtsrc(k) + dtsrcl
        END IF
      END DO
    END DO
! For orographic waves, sub-source tendencies are set equal to zero.
    DO k=1,pver
      IF (ngwv .EQ. 0) THEN
        dusrc(k) = 0.0
        dvsrc(k) = 0.0
        dtsrc(k) = 0.0
      END IF
    END DO
!-----------------------------------------------------------------------
! Adjust efficiency factor to prevent unrealistically strong forcing
!-----------------------------------------------------------------------
    uhtmax = 0.0
    utfac = 1.0
    uhtmaxd = 0.0_8
    DO k=1,pver
      arg1d = 2*ut(k)*utd(k) + 2*vt(k)*vtd(k)
      arg1 = ut(k)**2 + vt(k)**2
      IF (arg1 .EQ. 0.0) THEN
        x2d = 0.0_8
      ELSE
        x2d = arg1d/(2.0*SQRT(arg1))
      END IF
      x2 = SQRT(arg1)
      IF (x2 .LT. uhtmax) THEN
        uhtmax = uhtmax
      ELSE
        uhtmaxd = x2d
        uhtmax = x2
      END IF
    END DO
    IF (uhtmax .GT. tndmax) THEN
      utfacd = -(tndmax*uhtmaxd/uhtmax**2)
      utfac = tndmax/uhtmax
    ELSE
      utfacd = 0.0_8
    END IF
!jkim    effgw(i) = effgw(i)*utfac
    DO k=1,pver
      utd(k) = utd(k)*utfac + ut(k)*utfacd
      ut(k) = ut(k)*utfac
      vtd(k) = vtd(k)*utfac + vt(k)*utfacd
      vt(k) = vt(k)*utfac
      tt(k) = tt(k)*utfac
      dusrc(k) = dusrc(k)*utfac
      dvsrc(k) = dvsrc(k)*utfac
      dtsrc(k) = dtsrc(k)*utfac
    END DO
!-----------------------------------------------------------------------
! Project the c=0 stress (scaled) in the direction of the source wind
! for recording on the output file.
!-----------------------------------------------------------------------
    tau0x = tau(0, kbot)*xv*effgw(i)*utfac
    tau0y = tau(0, kbot)*yv*effgw(i)*utfac
    RETURN
  END SUBROUTINE GW_DRAG_PROF_D
!===============================================================================
  SUBROUTINE GW_DRAG_PROF(i, pcols, pver, pgwv, ngwv, kbot, ktop, c, u, &
&    v, t, pi, dpm, rdpm, piln, rlat, rhoi, ni, ti, nm, dt, alpha, dback&
&    , kldv, kldvmn, ksrc, ksrcmn, rdpldv, tau, ubi, ubm, xv, yv, ut, vt&
&    , tt, taugwx, taugwy, fegw, fepgw, dusrc, dvsrc, dtsrc, tau0x, tau0y&
&    , effgw)
    IMPLICIT NONE
!-----------------------------------------------------------------------
! Solve for the drag profile from the multiple gravity wave drag
! parameterization.
! 1. scan up from the wave source to determine the stress profile
! 2. scan down the stress profile to determine the tendencies
!     => apply bounds to the tendency
!          a. from wkb solution
!          b. from computational stability constraints
!     => adjust stress on interface below to reflect actual bounded tendency
!-----------------------------------------------------------------------
!------------------------------Arguments--------------------------------
! number of current column
    INTEGER, INTENT(IN) :: i
! number of atmospheric columns
    INTEGER, INTENT(IN) :: pcols
! number of atmospheric columns
    INTEGER, INTENT(IN) :: pver
! index of bottom (source) interface
    INTEGER, INTENT(IN) :: kbot
! index of top interface of gwd region
    INTEGER, INTENT(IN) :: ktop
! number of gravity waves possible
    INTEGER, INTENT(IN) :: pgwv
! number of gravity waves to use
    INTEGER, INTENT(IN) :: ngwv
! top interface of low level stress  divergence region
    INTEGER, INTENT(IN) :: kldv
! min value of kldv
    INTEGER, INTENT(IN) :: kldvmn
! index of top interface of source region
    INTEGER, INTENT(IN) :: ksrc
! min value of ksrc
    INTEGER, INTENT(IN) :: ksrcmn
! wave phase speeds
    REAL :: c(-pgwv:pgwv)
! midpoint zonal wind
    REAL :: u(pcols, pver)
! midpoint meridional wind
    REAL :: v(pcols, pver)
! midpoint temperatures
    REAL :: t(pcols, pver)
! interface pressures
    REAL :: pi(pcols, 0:pver)
! midpoint delta p (pi(k)-pi(k-1))
    REAL :: dpm(pcols, pver)
! 1. / (pi(k)-pi(k-1))
    REAL :: rdpm(pcols, pver)
! ln(interface pressures)
    REAL :: piln(pcols, 0:pver)
    REAL :: rlat(pcols)
! interface density
    REAL :: rhoi(0:pver)
! interface Brunt-Vaisalla frequency
    REAL :: ni(0:pver)
! interface temperature
    REAL :: ti(0:pver)
! midpoint Brunt-Vaisalla frequency
    REAL :: nm(pver)
! time step
    REAL :: dt
! newtonian cooling coefficients
    REAL :: alpha(0:pver)
! newtonian cooling coefficients
    REAL :: dback(0:pver)
! 1/dp across low level divergence region
    REAL :: rdpldv
! projection of wind at interfaces
    REAL :: ubi(0:pver)
! projection of wind at midpoints
    REAL :: ubm(pver)
! unit vectors of source wind (x)
    REAL :: xv
! unit vectors of source wind (y)
    REAL :: yv
! tendency efficiency for gwd 
    REAL :: effgw(pcols)
! wave Reynolds stress
    REAL :: tau(-pgwv:pgwv, 0:pver)
! zonal wind tendency
    REAL :: ut(pver)
! meridional wind tendency
    REAL :: vt(pver)
! temperature tendency
    REAL :: tt(pver)
! Total zonal GW momentum flux
    REAL :: taugwx(pcols, 0:pver)
! Total meridional GW momentum flux
    REAL :: taugwy(pcols, 0:pver)
! Total GW energy flux
    REAL :: fegw(pcols, 0:pver)
! Total GW pseudo energy flux
    REAL :: fepgw(pcols, 0:pver)
! Total U tendency below launch level
    REAL :: dusrc(pver)
! Total V tendency below launch level
    REAL :: dvsrc(pver)
! Total V tendency below launch level
    REAL :: dtsrc(pver)
! c=0 sfc. stress (zonal)
    REAL :: tau0x
! c=0 sfc. stress (meridional)
    REAL :: tau0y
!---------------------------Local storage-------------------------------
! loop indexes
    INTEGER :: k, l
! fraction of dsat to use
    REAL :: dscal
! imaginary part of vertical wavenumber
    REAL :: mi
! stress after damping
    REAL :: taudmp
!real    :: taumax(pcols)                     ! max(tau) for any l
! saturation stress
    REAL :: tausat
! (ub-c)
    REAL :: ubmc
! (ub-c)**2
    REAL :: ubmc2
! ubar tendency
    REAL :: ubt
! tbar tendency
    REAL :: tbt
! ubar tendency from wave l
    REAL :: ubtl
! saturation tendency
    REAL :: ubtlsat
! layer pressure
    REAL :: pm
! layer density
    REAL :: rhom
! launch level height
    REAL :: zlb
! c-u
    REAL :: cmu
    REAL :: dzm, hscal, tautmp
    REAL :: utl
    REAL :: ttl
! zonal pseudomomentum flux spectrum
    REAL :: fpmx
! meridional pseudomomentum flux spectrum
    REAL :: fpmy
! energy flux (p'w') spectrum
    REAL :: fe
! pseudoenergy flux (p'w'+U rho u'w') spectrum
    REAL :: fpe
    REAL :: fpml
    REAL :: fpmt
    REAL :: fpel
    REAL :: fpet
    REAL :: dusrcl
    REAL :: dvsrcl
    REAL :: dtsrcl
    REAL :: zi
    REAL :: effkwvmap
    REAL :: zfac
    REAL :: uhtmax
    REAL :: utfac
    REAL :: tau_min, cmu_, t_new
    REAL :: arg1
    INTRINSIC MAX
    INTRINSIC SIGN
    INTRINSIC ABS
    REAL :: x2
    REAL :: x1
    INTRINSIC SQRT
! Initialize gravity wave drag tendencies to zero
    DO l=-ngwv,ngwv
      DO k=pver-1,ktop,-1
        IF (k .LE. kbot - 1) tau(l, k) = 0.
      END DO
    END DO
    DO k=1,pver
      ut(k) = 0.
      vt(k) = 0.
      tt(k) = 0.
      dusrc(k) = 0.
      dvsrc(k) = 0.
      dtsrc(k) = 0.
    END DO
! Initialize total momentum and energy fluxes to zero
    DO k=0,pver
      taugwx(i, k) = 0.
      taugwy(i, k) = 0.
      fegw(i, k) = 0.
      fepgw(i, k) = 0.
    END DO
! Initialize surface wave stress at c = 0 to zero
    tau0x = 0.
    tau0y = 0.
!---------------------------------------------------------------------------
! Compute the stress profiles and diffusivities
!---------------------------------------------------------------------------
! Determine the absolute value of the saturation stress and the diffusivity
! for each wave.
! Define critical levels where the sign of (u-c) changes between interfaces.
! Loop from bottom to top to get stress profiles
    DO l=-ngwv,ngwv
      DO k=pver-1,ktop,-1
        IF (k .LE. kbot - 1) THEN
!!!!!!!!jk             d = dback(k)
          ubmc = ubi(k) - c(l)
          IF (ngwv .GT. 0) THEN
            CALL GET_EFFKWVMAP_1(effkwvmap, rlat(i))
            IF (-15.0 .LT. rlat(i)*180./pi_gwd .AND. rlat(i)*180./pi_gwd&
&                .LT. 15.0) effkwvmap = fcrit2*kwvbeq
          ELSE
            IF (pi(i, k) .LT. 1000.0) THEN
              zfac = (pi(i, k)/1000.0)**3
            ELSE
              zfac = 1.0
            END IF
            IF (rlat(i)*180./pi_gwd .LT. -20.0) THEN
              CALL GET_EFFKWVMAP_2(effkwvmap, rlat(i), zfac)
            ELSE
              CALL GET_EFFKWVMAP_3(effkwvmap, rlat(i), zfac)
            END IF
          END IF
          x1 = effkwvmap*rhoi(k)*ubmc**3/(2.*ni(k))
          IF (x1 .GE. 0.) THEN
            tausat = x1
          ELSE
            tausat = -x1
          END IF
          IF (tausat .LE. taumin) tausat = 0.0
          IF (ubmc*(ubi(k+1)-c(l)) .LE. 0.0) tausat = 0.0
          IF (k .EQ. ktop) tausat = 0.
!
          IF (k .EQ. ktop + 1) tausat = tausat*0.02
          IF (k .EQ. ktop + 2) tausat = tausat*0.05
          IF (k .EQ. ktop + 3) tausat = tausat*0.10
          IF (k .EQ. ktop + 4) tausat = tausat*0.20
          IF (k .EQ. ktop + 5) tausat = tausat*0.50
!
          tau_min = tausat
          IF (tau_min .GT. tau(l, k+1)) tau_min = tau(l, k+1)
          tau(l, k) = tau_min
        END IF
      END DO
    END DO
!---------------------------------------------------------------------------
! Compute the tendencies from the stress divergence.
!---------------------------------------------------------------------------
! Accumulate the mean wind tendency over wavenumber.
! Loop over levels from top to bottom
    DO k=ktop+1,pver
      ubt = 0.0
      tbt = 0.0
      DO l=-ngwv,ngwv
        IF (k .LE. kbot) THEN
! Determine the wind tendency including excess stress carried down from above.
          ubtl = mapl_grav*(tau(l, k)-tau(l, k-1))*rdpm(i, k)
! Calculate the sign of wind tendency
          utl = SIGN(ubtl, c(l) - ubi(k))
! Accumulate the mean wind tendency over wavenumber.
          ubt = ubt + utl
! Calculate irreversible temperature tendency associated with gravity wave breaking.
          ttl = (c(l)-ubm(k))*utl/mapl_cp
! Adding frictional heating associated with the GW momentum forcing
          tbt = tbt + ttl
        END IF
      END DO
! Project the mean wind tendency onto the components and scale by "efficiency".
      IF (k .LE. kbot) THEN
        ut(k) = ubt*xv*effgw(i)
        vt(k) = ubt*yv*effgw(i)
        tt(k) = tbt*effgw(i)
      END IF
    END DO
!-----------------------------------------------------------------------
! Calculates wind and temperature tendencies below launch level for
! energy and momentum conservation (does nothing for orographic GWs).
!-----------------------------------------------------------------------
!----kimmmmm here
! Calculate launch level height
    zlb = 0.
    DO k=ktop+1,pver
      IF (k .GE. kbot + 1) THEN
! Define layer pressure and density
        pm = (pi(i, k-1)+pi(i, k))*0.5
        CALL GET_TI(t_new, t(i, k))
        rhom = pm/(mapl_rgas*t_new)
        zlb = zlb + dpm(i, k)/mapl_grav/rhom
      END IF
    END DO
!-----------------------------------------------------------------------
! Calculates energy and momentum flux profiles
!-----------------------------------------------------------------------
    DO l=-ngwv,ngwv
      DO k=ktop,pver
        IF (k .LE. kbot) THEN
          cmu = c(l) - ubi(k)
          CALL GET_CMU(cmu_, cmu)
          fpmx = cmu_*tau(l, k)*xv*effgw(i)
          fpmy = cmu_*tau(l, k)*yv*effgw(i)
          fe = cmu*cmu_*tau(l, k)*effgw(i)
          fpe = c(l)*cmu_*tau(l, k)*effgw(i)
          IF (k .EQ. kbot) THEN
            fpml = fpmx*xv + fpmy*yv
            fpel = fpe
          END IF
          IF (k .EQ. ktop) THEN
            fpmt = fpmx*xv + fpmy*yv
            fpet = fpe
          END IF
! Record outputs for GW fluxes
          taugwx(i, k) = taugwx(i, k) + fpmx
          taugwy(i, k) = taugwy(i, k) + fpmy
          fegw(i, k) = fegw(i, k) + fe
          fepgw(i, k) = fepgw(i, k) + fpe
        END IF
      END DO
      DO k=ktop+1,pver
        IF (k .GE. kbot + 1) THEN
! Define layer pressure and density
          pm = (pi(i, k-1)+pi(i, k))*0.5
          CALL GET_TI(t_new, t(i, k))
          rhom = pm/(mapl_rgas*t_new)
          dusrcl = -((fpml-fpmt)/(rhom*zlb)*xv)
          dvsrcl = -((fpml-fpmt)/(rhom*zlb)*yv)
          dtsrcl = -((fpel-fpet-ubm(k)*(fpml-fpmt))/(rhom*zlb*mapl_cp))
! Add sub-source wind and temperature tendencies
          dusrc(k) = dusrc(k) + dusrcl
          dvsrc(k) = dvsrc(k) + dvsrcl
          dtsrc(k) = dtsrc(k) + dtsrcl
        END IF
      END DO
    END DO
! For orographic waves, sub-source tendencies are set equal to zero.
    DO k=1,pver
      IF (ngwv .EQ. 0) THEN
        dusrc(k) = 0.0
        dvsrc(k) = 0.0
        dtsrc(k) = 0.0
      END IF
    END DO
!-----------------------------------------------------------------------
! Adjust efficiency factor to prevent unrealistically strong forcing
!-----------------------------------------------------------------------
    uhtmax = 0.0
    utfac = 1.0
    DO k=1,pver
      arg1 = ut(k)**2 + vt(k)**2
      x2 = SQRT(arg1)
      IF (x2 .LT. uhtmax) THEN
        uhtmax = uhtmax
      ELSE
        uhtmax = x2
      END IF
    END DO
    IF (uhtmax .GT. tndmax) utfac = tndmax/uhtmax
!jkim    effgw(i) = effgw(i)*utfac
    DO k=1,pver
      ut(k) = ut(k)*utfac
      vt(k) = vt(k)*utfac
      tt(k) = tt(k)*utfac
      dusrc(k) = dusrc(k)*utfac
      dvsrc(k) = dvsrc(k)*utfac
      dtsrc(k) = dtsrc(k)*utfac
    END DO
!-----------------------------------------------------------------------
! Project the c=0 stress (scaled) in the direction of the source wind
! for recording on the output file.
!-----------------------------------------------------------------------
    tau0x = tau(0, kbot)*xv*effgw(i)*utfac
    tau0y = tau(0, kbot)*yv*effgw(i)*utfac
    RETURN
  END SUBROUTINE GW_DRAG_PROF
!  Differentiation of gw_drag_prof_bgnd in forward (tangent) mode:
!   variations  of output variables: tau ut vt dvsrc dusrc
!   with respect to input variables: xv yv ubi
  SUBROUTINE GW_DRAG_PROF_BGND_D(i, pcols, pver, pgwv, ngwv, kbot, ktop&
&    , c, u, v, t, pi, dpm, rdpm, piln, rlat, rhoi, ni, ti, nm, dt, alpha&
&    , dback, kldv, kldvmn, ksrc, ksrcmn, rdpldv, tau, taud, ubi, ubid, &
&    ubm, xv, xvd, yv, yvd, ut, utd, vt, vtd, tt, taugwx, taugwy, fegw, &
&    fepgw, dusrc, dusrcd, dvsrc, dvsrcd, dtsrc, tau0x, tau0y, effgw)
    IMPLICIT NONE
!-----------------------------------------------------------------------
! Solve for the drag profile from the multiple gravity wave drag
! parameterization.
! 1. scan up from the wave source to determine the stress profile
! 2. scan down the stress profile to determine the tendencies
!     => apply bounds to the tendency
!          a. from wkb solution
!          b. from computational stability constraints
!     => adjust stress on interface below to reflect actual bounded tendency
!-----------------------------------------------------------------------
!------------------------------Arguments--------------------------------
! number of current column
    INTEGER, INTENT(IN) :: i
! number of atmospheric columns
    INTEGER, INTENT(IN) :: pcols
! number of atmospheric columns
    INTEGER, INTENT(IN) :: pver
! index of bottom (source) interface
    INTEGER, INTENT(IN) :: kbot
! index of top interface of gwd region
    INTEGER, INTENT(IN) :: ktop
! number of gravity waves possible
    INTEGER, INTENT(IN) :: pgwv
! number of gravity waves to use
    INTEGER, INTENT(IN) :: ngwv
! top interface of low level stress  divergence region
    INTEGER, INTENT(IN) :: kldv
! min value of kldv
    INTEGER, INTENT(IN) :: kldvmn
! index of top interface of source region
    INTEGER, INTENT(IN) :: ksrc
! min value of ksrc
    INTEGER, INTENT(IN) :: ksrcmn
! wave phase speeds
    REAL :: c(-pgwv:pgwv)
! midpoint zonal wind
    REAL :: u(pcols, pver)
! midpoint meridional wind
    REAL :: v(pcols, pver)
! midpoint temperatures
    REAL :: t(pcols, pver)
! interface pressures
    REAL :: pi(pcols, 0:pver)
! midpoint delta p (pi(k)-pi(k-1))
    REAL :: dpm(pcols, pver)
! 1. / (pi(k)-pi(k-1))
    REAL :: rdpm(pcols, pver)
! ln(interface pressures)
    REAL :: piln(pcols, 0:pver)
    REAL :: rlat(pcols)
! interface density
    REAL :: rhoi(0:pver)
! interface Brunt-Vaisalla frequency
    REAL :: ni(0:pver)
! interface temperature
    REAL :: ti(0:pver)
! midpoint Brunt-Vaisalla frequency
    REAL :: nm(pver)
! time step
    REAL :: dt
! newtonian cooling coefficients
    REAL :: alpha(0:pver)
! newtonian cooling coefficients
    REAL :: dback(0:pver)
! 1/dp across low level divergence region
    REAL :: rdpldv
! projection of wind at interfaces
    REAL :: ubi(0:pver)
    REAL :: ubid(0:pver)
! projection of wind at midpoints
    REAL :: ubm(pver)
! unit vectors of source wind (x)
    REAL :: xv
    REAL :: xvd
! unit vectors of source wind (y)
    REAL :: yv
    REAL :: yvd
! tendency efficiency for gwd 
    REAL :: effgw(pcols)
! wave Reynolds stress
    REAL :: tau(-pgwv:pgwv, 0:pver)
    REAL :: taud(-pgwv:pgwv, 0:pver)
! zonal wind tendency
    REAL :: ut(pver)
    REAL :: utd(pver)
! meridional wind tendency
    REAL :: vt(pver)
    REAL :: vtd(pver)
! temperature tendency
    REAL :: tt(pver)
! Total zonal GW momentum flux
    REAL :: taugwx(pcols, 0:pver)
! Total meridional GW momentum flux
    REAL :: taugwy(pcols, 0:pver)
! Total GW energy flux
    REAL :: fegw(pcols, 0:pver)
! Total GW pseudo energy flux
    REAL :: fepgw(pcols, 0:pver)
! Total U tendency below launch level
    REAL :: dusrc(pver)
    REAL :: dusrcd(pver)
! Total V tendency below launch level
    REAL :: dvsrc(pver)
    REAL :: dvsrcd(pver)
! Total V tendency below launch level
    REAL :: dtsrc(pver)
! c=0 sfc. stress (zonal)
    REAL :: tau0x
! c=0 sfc. stress (meridional)
    REAL :: tau0y
!---------------------------Local storage-------------------------------
! loop indexes
    INTEGER :: k, l
! fraction of dsat to use
    REAL :: dscal
! imaginary part of vertical wavenumber
    REAL :: mi
! stress after damping
    REAL :: taudmp
!real    :: taumax(pcols)                     ! max(tau) for any l
! saturation stress
    REAL :: tausat
    REAL :: tausatd
! (ub-c)
    REAL :: ubmc
    REAL :: ubmcd
! (ub-c)**2
    REAL :: ubmc2
! ubar tendency
    REAL :: ubt
    REAL :: ubtd
! tbar tendency
    REAL :: tbt
! ubar tendency from wave l
    REAL :: ubtl
    REAL :: ubtld
! saturation tendency
    REAL :: ubtlsat
! layer pressure
    REAL :: pm
! layer density
    REAL :: rhom
! launch level height
    REAL :: zlb
! c-u
    REAL :: cmu
    REAL :: dzm, hscal, tautmp
    REAL :: utl
    REAL :: utld
    REAL :: ttl
! zonal pseudomomentum flux spectrum
    REAL :: fpmx
    REAL :: fpmxd
! meridional pseudomomentum flux spectrum
    REAL :: fpmy
    REAL :: fpmyd
! energy flux (p'w') spectrum
    REAL :: fe
! pseudoenergy flux (p'w'+U rho u'w') spectrum
    REAL :: fpe
    REAL :: fpml
    REAL :: fpmld
    REAL :: fpmt
    REAL :: fpmtd
    REAL :: fpel
    REAL :: fpet
    REAL :: dusrcl
    REAL :: dusrcld
    REAL :: dvsrcl
    REAL :: dvsrcld
    REAL :: dtsrcl
    REAL :: zi
    REAL :: effkwvmap
    REAL :: zfac
    REAL :: uhtmax
    REAL :: uhtmaxd
    REAL :: utfac
    REAL :: utfacd
    REAL :: tau_min, cmu_, t_new
    REAL :: tau_mind
    REAL :: arg1
    REAL :: arg1d
    INTRINSIC MAX
    INTRINSIC SIGN
    INTRINSIC ABS
    REAL :: x2
    REAL :: x2d
    REAL :: x1
    REAL :: x1d
    INTRINSIC SQRT
! Initialize gravity wave drag tendencies to zero
    DO l=-ngwv,ngwv
      DO k=pver-1,ktop,-1
        IF (k .LE. kbot - 1) THEN
          taud(l, k) = 0.0_8
          tau(l, k) = 0.
        END IF
      END DO
    END DO
    DO k=1,pver
      utd(k) = 0.0_8
      ut(k) = 0.
      vtd(k) = 0.0_8
      vt(k) = 0.
      tt(k) = 0.
      dusrcd(k) = 0.0_8
      dusrc(k) = 0.
      dvsrcd(k) = 0.0_8
      dvsrc(k) = 0.
      dtsrc(k) = 0.
    END DO
! Initialize total momentum and energy fluxes to zero
    DO k=0,pver
      taugwx(i, k) = 0.
      taugwy(i, k) = 0.
      fegw(i, k) = 0.
      fepgw(i, k) = 0.
    END DO
! Initialize surface wave stress at c = 0 to zero
    tau0x = 0.
    tau0y = 0.
    taud(:, :) = 0.0_8
!---------------------------------------------------------------------------
! Compute the stress profiles and diffusivities
!---------------------------------------------------------------------------
! Determine the absolute value of the saturation stress and the diffusivity
! for each wave.
! Define critical levels where the sign of (u-c) changes between interfaces.
! Loop from bottom to top to get stress profiles
    DO l=-ngwv,ngwv
      DO k=pver-1,ktop,-1
        IF (k .LE. kbot - 1) THEN
!!!!!!!!jk             d = dback(k)
          ubmcd = ubid(k)
          ubmc = ubi(k) - c(l)
          IF (ngwv .GT. 0) THEN
            CALL GET_EFFKWVMAP_1(effkwvmap, rlat(i))
            IF (-15.0 .LT. rlat(i)*180./pi_gwd .AND. rlat(i)*180./pi_gwd&
&                .LT. 15.0) effkwvmap = fcrit2*kwvbeq
          ELSE
            IF (pi(i, k) .LT. 1000.0) THEN
              zfac = (pi(i, k)/1000.0)**3
            ELSE
              zfac = 1.0
            END IF
            IF (rlat(i)*180./pi_gwd .LT. -20.0) THEN
              CALL GET_EFFKWVMAP_2(effkwvmap, rlat(i), zfac)
            ELSE
              CALL GET_EFFKWVMAP_3(effkwvmap, rlat(i), zfac)
            END IF
          END IF
          x1d = effkwvmap*rhoi(k)*3*ubmc**2*ubmcd/(2.*ni(k))
          x1 = effkwvmap*rhoi(k)*ubmc**3/(2.*ni(k))
          IF (x1 .GE. 0.) THEN
            tausatd = x1d
            tausat = x1
          ELSE
            tausatd = -x1d
            tausat = -x1
          END IF
          IF (tausat .LE. taumin) THEN
            tausat = 0.0
            tausatd = 0.0_8
          END IF
          IF (ubmc*(ubi(k+1)-c(l)) .LE. 0.0) THEN
            tausat = 0.0
            tausatd = 0.0_8
          END IF
          IF (k .EQ. ktop) THEN
            tausat = 0.
            tausatd = 0.0_8
          END IF
!
          IF (k .EQ. ktop + 1) THEN
            tausatd = 0.02*tausatd
            tausat = tausat*0.02
          END IF
          IF (k .EQ. ktop + 2) THEN
            tausatd = 0.05*tausatd
            tausat = tausat*0.05
          END IF
          IF (k .EQ. ktop + 3) THEN
            tausatd = 0.10*tausatd
            tausat = tausat*0.10
          END IF
          IF (k .EQ. ktop + 4) THEN
            tausatd = 0.20*tausatd
            tausat = tausat*0.20
          END IF
          IF (k .EQ. ktop + 5) THEN
            tausatd = 0.50*tausatd
            tausat = tausat*0.50
          END IF
!
          tau_mind = tausatd
          tau_min = tausat
          IF (tau_min .GT. tau(l, k+1)) THEN
            tau_mind = taud(l, k+1)
            tau_min = tau(l, k+1)
          END IF
          taud(l, k) = tau_mind
          tau(l, k) = tau_min
        END IF
      END DO
    END DO
    utd(:) = 0.0_8
    vtd(:) = 0.0_8
!---------------------------------------------------------------------------
! Compute the tendencies from the stress divergence.
!---------------------------------------------------------------------------
! Accumulate the mean wind tendency over wavenumber.
! Loop over levels from top to bottom
    DO k=ktop+1,pver
      ubt = 0.0
      tbt = 0.0
      ubtd = 0.0_8
      DO l=-ngwv,ngwv
        IF (k .LE. kbot) THEN
! Determine the wind tendency including excess stress carried down from above.
          ubtld = mapl_grav*rdpm(i, k)*(taud(l, k)-taud(l, k-1))
          ubtl = mapl_grav*(tau(l, k)-tau(l, k-1))*rdpm(i, k)
! Calculate the sign of wind tendency
          utld = ubtld*SIGN(1.d0, ubtl*(c(l)-ubi(k)))
          utl = SIGN(ubtl, c(l) - ubi(k))
! Accumulate the mean wind tendency over wavenumber.
          ubtd = ubtd + utld
          ubt = ubt + utl
! Calculate irreversible temperature tendency associated with gravity wave breaking.
          ttl = (c(l)-ubm(k))*utl/mapl_cp
! Adding frictional heating associated with the GW momentum forcing
          tbt = tbt + ttl
        END IF
      END DO
! Project the mean wind tendency onto the components and scale by "efficiency".
      IF (k .LE. kbot) THEN
        utd(k) = effgw(i)*(ubtd*xv+ubt*xvd)
        ut(k) = ubt*xv*effgw(i)
        vtd(k) = effgw(i)*(ubtd*yv+ubt*yvd)
        vt(k) = ubt*yv*effgw(i)
        tt(k) = tbt*effgw(i)
      END IF
    END DO
!-----------------------------------------------------------------------
! Calculates wind and temperature tendencies below launch level for
! energy and momentum conservation (does nothing for orographic GWs).
!-----------------------------------------------------------------------
!----kimmmmm here
! Calculate launch level height
    zlb = 0.
    DO k=ktop+1,pver
      IF (k .GE. kbot + 1) THEN
! Define layer pressure and density
        pm = (pi(i, k-1)+pi(i, k))*0.5
        CALL GET_TI(t_new, t(i, k))
        rhom = pm/(mapl_rgas*t_new)
        zlb = zlb + dpm(i, k)/mapl_grav/rhom
      END IF
    END DO
    dvsrcd(:) = 0.0_8
    dusrcd(:) = 0.0_8
    fpmld = 0.0_8
    fpmtd = 0.0_8
!-----------------------------------------------------------------------
! Calculates energy and momentum flux profiles
!-----------------------------------------------------------------------
    DO l=-ngwv,ngwv
      DO k=ktop,pver
        IF (k .LE. kbot) THEN
          cmu = c(l) - ubi(k)
          CALL GET_CMU(cmu_, cmu)
          fpmxd = cmu_*effgw(i)*(taud(l, k)*xv+tau(l, k)*xvd)
          fpmx = cmu_*tau(l, k)*xv*effgw(i)
          fpmyd = cmu_*effgw(i)*(taud(l, k)*yv+tau(l, k)*yvd)
          fpmy = cmu_*tau(l, k)*yv*effgw(i)
          fe = cmu*cmu_*tau(l, k)*effgw(i)
          fpe = c(l)*cmu_*tau(l, k)*effgw(i)
          IF (k .EQ. kbot) THEN
            fpmld = fpmxd*xv + fpmx*xvd + fpmyd*yv + fpmy*yvd
            fpml = fpmx*xv + fpmy*yv
            fpel = fpe
          END IF
          IF (k .EQ. ktop) THEN
            fpmtd = fpmxd*xv + fpmx*xvd + fpmyd*yv + fpmy*yvd
            fpmt = fpmx*xv + fpmy*yv
            fpet = fpe
          END IF
! Record outputs for GW fluxes
          taugwx(i, k) = taugwx(i, k) + fpmx
          taugwy(i, k) = taugwy(i, k) + fpmy
          fegw(i, k) = fegw(i, k) + fe
          fepgw(i, k) = fepgw(i, k) + fpe
        END IF
      END DO
      DO k=ktop+1,pver
        IF (k .GE. kbot + 1) THEN
! Define layer pressure and density
          pm = (pi(i, k-1)+pi(i, k))*0.5
          CALL GET_TI(t_new, t(i, k))
          rhom = pm/(mapl_rgas*t_new)
          dusrcld = -((fpmld-fpmtd)*xv/(rhom*zlb)+(fpml-fpmt)*xvd/(rhom*&
&            zlb))
          dusrcl = -((fpml-fpmt)/(rhom*zlb)*xv)
          dvsrcld = -((fpmld-fpmtd)*yv/(rhom*zlb)+(fpml-fpmt)*yvd/(rhom*&
&            zlb))
          dvsrcl = -((fpml-fpmt)/(rhom*zlb)*yv)
          dtsrcl = -((fpel-fpet-ubm(k)*(fpml-fpmt))/(rhom*zlb*mapl_cp))
! Add sub-source wind and temperature tendencies
          dusrcd(k) = dusrcd(k) + dusrcld
          dusrc(k) = dusrc(k) + dusrcl
          dvsrcd(k) = dvsrcd(k) + dvsrcld
          dvsrc(k) = dvsrc(k) + dvsrcl
          dtsrc(k) = dtsrc(k) + dtsrcl
        END IF
      END DO
    END DO
! For orographic waves, sub-source tendencies are set equal to zero.
    DO k=1,pver
      IF (ngwv .EQ. 0) THEN
        dusrcd(k) = 0.0_8
        dusrc(k) = 0.0
        dvsrcd(k) = 0.0_8
        dvsrc(k) = 0.0
        dtsrc(k) = 0.0
      END IF
    END DO
!-----------------------------------------------------------------------
! Adjust efficiency factor to prevent unrealistically strong forcing
!-----------------------------------------------------------------------
    uhtmax = 0.0
    utfac = 1.0
    uhtmaxd = 0.0_8
    DO k=1,pver
      arg1d = 2*ut(k)*utd(k) + 2*vt(k)*vtd(k)
      arg1 = ut(k)**2 + vt(k)**2
      IF (arg1 .EQ. 0.0) THEN
        x2d = 0.0_8
      ELSE
        x2d = arg1d/(2.0*SQRT(arg1))
      END IF
      x2 = SQRT(arg1)
      IF (x2 .LT. uhtmax) THEN
        uhtmax = uhtmax
      ELSE
        uhtmaxd = x2d
        uhtmax = x2
      END IF
    END DO
    IF (uhtmax .GT. tndmax) THEN
      utfacd = -(tndmax*uhtmaxd/uhtmax**2)
      utfac = tndmax/uhtmax
    ELSE
      utfacd = 0.0_8
    END IF
!jkim    effgw(i) = effgw(i)*utfac
    DO k=1,pver
      utd(k) = utd(k)*utfac + ut(k)*utfacd
      ut(k) = ut(k)*utfac
      vtd(k) = vtd(k)*utfac + vt(k)*utfacd
      vt(k) = vt(k)*utfac
      tt(k) = tt(k)*utfac
      dusrcd(k) = dusrcd(k)*utfac + dusrc(k)*utfacd
      dusrc(k) = dusrc(k)*utfac
      dvsrcd(k) = dvsrcd(k)*utfac + dvsrc(k)*utfacd
      dvsrc(k) = dvsrc(k)*utfac
      dtsrc(k) = dtsrc(k)*utfac
    END DO
!-----------------------------------------------------------------------
! Project the c=0 stress (scaled) in the direction of the source wind
! for recording on the output file.
!-----------------------------------------------------------------------
    tau0x = tau(0, kbot)*xv*effgw(i)*utfac
    tau0y = tau(0, kbot)*yv*effgw(i)*utfac
    RETURN
  END SUBROUTINE GW_DRAG_PROF_BGND_D
  SUBROUTINE GW_DRAG_PROF_BGND(i, pcols, pver, pgwv, ngwv, kbot, ktop, c&
&    , u, v, t, pi, dpm, rdpm, piln, rlat, rhoi, ni, ti, nm, dt, alpha, &
&    dback, kldv, kldvmn, ksrc, ksrcmn, rdpldv, tau, ubi, ubm, xv, yv, ut&
&    , vt, tt, taugwx, taugwy, fegw, fepgw, dusrc, dvsrc, dtsrc, tau0x, &
&    tau0y, effgw)
    IMPLICIT NONE
!-----------------------------------------------------------------------
! Solve for the drag profile from the multiple gravity wave drag
! parameterization.
! 1. scan up from the wave source to determine the stress profile
! 2. scan down the stress profile to determine the tendencies
!     => apply bounds to the tendency
!          a. from wkb solution
!          b. from computational stability constraints
!     => adjust stress on interface below to reflect actual bounded tendency
!-----------------------------------------------------------------------
!------------------------------Arguments--------------------------------
! number of current column
    INTEGER, INTENT(IN) :: i
! number of atmospheric columns
    INTEGER, INTENT(IN) :: pcols
! number of atmospheric columns
    INTEGER, INTENT(IN) :: pver
! index of bottom (source) interface
    INTEGER, INTENT(IN) :: kbot
! index of top interface of gwd region
    INTEGER, INTENT(IN) :: ktop
! number of gravity waves possible
    INTEGER, INTENT(IN) :: pgwv
! number of gravity waves to use
    INTEGER, INTENT(IN) :: ngwv
! top interface of low level stress  divergence region
    INTEGER, INTENT(IN) :: kldv
! min value of kldv
    INTEGER, INTENT(IN) :: kldvmn
! index of top interface of source region
    INTEGER, INTENT(IN) :: ksrc
! min value of ksrc
    INTEGER, INTENT(IN) :: ksrcmn
! wave phase speeds
    REAL :: c(-pgwv:pgwv)
! midpoint zonal wind
    REAL :: u(pcols, pver)
! midpoint meridional wind
    REAL :: v(pcols, pver)
! midpoint temperatures
    REAL :: t(pcols, pver)
! interface pressures
    REAL :: pi(pcols, 0:pver)
! midpoint delta p (pi(k)-pi(k-1))
    REAL :: dpm(pcols, pver)
! 1. / (pi(k)-pi(k-1))
    REAL :: rdpm(pcols, pver)
! ln(interface pressures)
    REAL :: piln(pcols, 0:pver)
    REAL :: rlat(pcols)
! interface density
    REAL :: rhoi(0:pver)
! interface Brunt-Vaisalla frequency
    REAL :: ni(0:pver)
! interface temperature
    REAL :: ti(0:pver)
! midpoint Brunt-Vaisalla frequency
    REAL :: nm(pver)
! time step
    REAL :: dt
! newtonian cooling coefficients
    REAL :: alpha(0:pver)
! newtonian cooling coefficients
    REAL :: dback(0:pver)
! 1/dp across low level divergence region
    REAL :: rdpldv
! projection of wind at interfaces
    REAL :: ubi(0:pver)
! projection of wind at midpoints
    REAL :: ubm(pver)
! unit vectors of source wind (x)
    REAL :: xv
! unit vectors of source wind (y)
    REAL :: yv
! tendency efficiency for gwd 
    REAL :: effgw(pcols)
! wave Reynolds stress
    REAL :: tau(-pgwv:pgwv, 0:pver)
! zonal wind tendency
    REAL :: ut(pver)
! meridional wind tendency
    REAL :: vt(pver)
! temperature tendency
    REAL :: tt(pver)
! Total zonal GW momentum flux
    REAL :: taugwx(pcols, 0:pver)
! Total meridional GW momentum flux
    REAL :: taugwy(pcols, 0:pver)
! Total GW energy flux
    REAL :: fegw(pcols, 0:pver)
! Total GW pseudo energy flux
    REAL :: fepgw(pcols, 0:pver)
! Total U tendency below launch level
    REAL :: dusrc(pver)
! Total V tendency below launch level
    REAL :: dvsrc(pver)
! Total V tendency below launch level
    REAL :: dtsrc(pver)
! c=0 sfc. stress (zonal)
    REAL :: tau0x
! c=0 sfc. stress (meridional)
    REAL :: tau0y
!---------------------------Local storage-------------------------------
! loop indexes
    INTEGER :: k, l
! fraction of dsat to use
    REAL :: dscal
! imaginary part of vertical wavenumber
    REAL :: mi
! stress after damping
    REAL :: taudmp
!real    :: taumax(pcols)                     ! max(tau) for any l
! saturation stress
    REAL :: tausat
! (ub-c)
    REAL :: ubmc
! (ub-c)**2
    REAL :: ubmc2
! ubar tendency
    REAL :: ubt
! tbar tendency
    REAL :: tbt
! ubar tendency from wave l
    REAL :: ubtl
! saturation tendency
    REAL :: ubtlsat
! layer pressure
    REAL :: pm
! layer density
    REAL :: rhom
! launch level height
    REAL :: zlb
! c-u
    REAL :: cmu
    REAL :: dzm, hscal, tautmp
    REAL :: utl
    REAL :: ttl
! zonal pseudomomentum flux spectrum
    REAL :: fpmx
! meridional pseudomomentum flux spectrum
    REAL :: fpmy
! energy flux (p'w') spectrum
    REAL :: fe
! pseudoenergy flux (p'w'+U rho u'w') spectrum
    REAL :: fpe
    REAL :: fpml
    REAL :: fpmt
    REAL :: fpel
    REAL :: fpet
    REAL :: dusrcl
    REAL :: dvsrcl
    REAL :: dtsrcl
    REAL :: zi
    REAL :: effkwvmap
    REAL :: zfac
    REAL :: uhtmax
    REAL :: utfac
    REAL :: tau_min, cmu_, t_new
    REAL :: arg1
    INTRINSIC MAX
    INTRINSIC SIGN
    INTRINSIC ABS
    REAL :: x2
    REAL :: x1
    INTRINSIC SQRT
! Initialize gravity wave drag tendencies to zero
    DO l=-ngwv,ngwv
      DO k=pver-1,ktop,-1
        IF (k .LE. kbot - 1) tau(l, k) = 0.
      END DO
    END DO
    DO k=1,pver
      ut(k) = 0.
      vt(k) = 0.
      tt(k) = 0.
      dusrc(k) = 0.
      dvsrc(k) = 0.
      dtsrc(k) = 0.
    END DO
! Initialize total momentum and energy fluxes to zero
    DO k=0,pver
      taugwx(i, k) = 0.
      taugwy(i, k) = 0.
      fegw(i, k) = 0.
      fepgw(i, k) = 0.
    END DO
! Initialize surface wave stress at c = 0 to zero
    tau0x = 0.
    tau0y = 0.
!---------------------------------------------------------------------------
! Compute the stress profiles and diffusivities
!---------------------------------------------------------------------------
! Determine the absolute value of the saturation stress and the diffusivity
! for each wave.
! Define critical levels where the sign of (u-c) changes between interfaces.
! Loop from bottom to top to get stress profiles
    DO l=-ngwv,ngwv
      DO k=pver-1,ktop,-1
        IF (k .LE. kbot - 1) THEN
!!!!!!!!jk             d = dback(k)
          ubmc = ubi(k) - c(l)
          IF (ngwv .GT. 0) THEN
            CALL GET_EFFKWVMAP_1(effkwvmap, rlat(i))
            IF (-15.0 .LT. rlat(i)*180./pi_gwd .AND. rlat(i)*180./pi_gwd&
&                .LT. 15.0) effkwvmap = fcrit2*kwvbeq
          ELSE
            IF (pi(i, k) .LT. 1000.0) THEN
              zfac = (pi(i, k)/1000.0)**3
            ELSE
              zfac = 1.0
            END IF
            IF (rlat(i)*180./pi_gwd .LT. -20.0) THEN
              CALL GET_EFFKWVMAP_2(effkwvmap, rlat(i), zfac)
            ELSE
              CALL GET_EFFKWVMAP_3(effkwvmap, rlat(i), zfac)
            END IF
          END IF
          x1 = effkwvmap*rhoi(k)*ubmc**3/(2.*ni(k))
          IF (x1 .GE. 0.) THEN
            tausat = x1
          ELSE
            tausat = -x1
          END IF
          IF (tausat .LE. taumin) tausat = 0.0
          IF (ubmc*(ubi(k+1)-c(l)) .LE. 0.0) tausat = 0.0
          IF (k .EQ. ktop) tausat = 0.
!
          IF (k .EQ. ktop + 1) tausat = tausat*0.02
          IF (k .EQ. ktop + 2) tausat = tausat*0.05
          IF (k .EQ. ktop + 3) tausat = tausat*0.10
          IF (k .EQ. ktop + 4) tausat = tausat*0.20
          IF (k .EQ. ktop + 5) tausat = tausat*0.50
!
          tau_min = tausat
          IF (tau_min .GT. tau(l, k+1)) tau_min = tau(l, k+1)
          tau(l, k) = tau_min
        END IF
      END DO
    END DO
!---------------------------------------------------------------------------
! Compute the tendencies from the stress divergence.
!---------------------------------------------------------------------------
! Accumulate the mean wind tendency over wavenumber.
! Loop over levels from top to bottom
    DO k=ktop+1,pver
      ubt = 0.0
      tbt = 0.0
      DO l=-ngwv,ngwv
        IF (k .LE. kbot) THEN
! Determine the wind tendency including excess stress carried down from above.
          ubtl = mapl_grav*(tau(l, k)-tau(l, k-1))*rdpm(i, k)
! Calculate the sign of wind tendency
          utl = SIGN(ubtl, c(l) - ubi(k))
! Accumulate the mean wind tendency over wavenumber.
          ubt = ubt + utl
! Calculate irreversible temperature tendency associated with gravity wave breaking.
          ttl = (c(l)-ubm(k))*utl/mapl_cp
! Adding frictional heating associated with the GW momentum forcing
          tbt = tbt + ttl
        END IF
      END DO
! Project the mean wind tendency onto the components and scale by "efficiency".
      IF (k .LE. kbot) THEN
        ut(k) = ubt*xv*effgw(i)
        vt(k) = ubt*yv*effgw(i)
        tt(k) = tbt*effgw(i)
      END IF
    END DO
!-----------------------------------------------------------------------
! Calculates wind and temperature tendencies below launch level for
! energy and momentum conservation (does nothing for orographic GWs).
!-----------------------------------------------------------------------
!----kimmmmm here
! Calculate launch level height
    zlb = 0.
    DO k=ktop+1,pver
      IF (k .GE. kbot + 1) THEN
! Define layer pressure and density
        pm = (pi(i, k-1)+pi(i, k))*0.5
        CALL GET_TI(t_new, t(i, k))
        rhom = pm/(mapl_rgas*t_new)
        zlb = zlb + dpm(i, k)/mapl_grav/rhom
      END IF
    END DO
!-----------------------------------------------------------------------
! Calculates energy and momentum flux profiles
!-----------------------------------------------------------------------
    DO l=-ngwv,ngwv
      DO k=ktop,pver
        IF (k .LE. kbot) THEN
          cmu = c(l) - ubi(k)
          CALL GET_CMU(cmu_, cmu)
          fpmx = cmu_*tau(l, k)*xv*effgw(i)
          fpmy = cmu_*tau(l, k)*yv*effgw(i)
          fe = cmu*cmu_*tau(l, k)*effgw(i)
          fpe = c(l)*cmu_*tau(l, k)*effgw(i)
          IF (k .EQ. kbot) THEN
            fpml = fpmx*xv + fpmy*yv
            fpel = fpe
          END IF
          IF (k .EQ. ktop) THEN
            fpmt = fpmx*xv + fpmy*yv
            fpet = fpe
          END IF
! Record outputs for GW fluxes
          taugwx(i, k) = taugwx(i, k) + fpmx
          taugwy(i, k) = taugwy(i, k) + fpmy
          fegw(i, k) = fegw(i, k) + fe
          fepgw(i, k) = fepgw(i, k) + fpe
        END IF
      END DO
      DO k=ktop+1,pver
        IF (k .GE. kbot + 1) THEN
! Define layer pressure and density
          pm = (pi(i, k-1)+pi(i, k))*0.5
          CALL GET_TI(t_new, t(i, k))
          rhom = pm/(mapl_rgas*t_new)
          dusrcl = -((fpml-fpmt)/(rhom*zlb)*xv)
          dvsrcl = -((fpml-fpmt)/(rhom*zlb)*yv)
          dtsrcl = -((fpel-fpet-ubm(k)*(fpml-fpmt))/(rhom*zlb*mapl_cp))
! Add sub-source wind and temperature tendencies
          dusrc(k) = dusrc(k) + dusrcl
          dvsrc(k) = dvsrc(k) + dvsrcl
          dtsrc(k) = dtsrc(k) + dtsrcl
        END IF
      END DO
    END DO
! For orographic waves, sub-source tendencies are set equal to zero.
    DO k=1,pver
      IF (ngwv .EQ. 0) THEN
        dusrc(k) = 0.0
        dvsrc(k) = 0.0
        dtsrc(k) = 0.0
      END IF
    END DO
!-----------------------------------------------------------------------
! Adjust efficiency factor to prevent unrealistically strong forcing
!-----------------------------------------------------------------------
    uhtmax = 0.0
    utfac = 1.0
    DO k=1,pver
      arg1 = ut(k)**2 + vt(k)**2
      x2 = SQRT(arg1)
      IF (x2 .LT. uhtmax) THEN
        uhtmax = uhtmax
      ELSE
        uhtmax = x2
      END IF
    END DO
    IF (uhtmax .GT. tndmax) utfac = tndmax/uhtmax
!jkim    effgw(i) = effgw(i)*utfac
    DO k=1,pver
      ut(k) = ut(k)*utfac
      vt(k) = vt(k)*utfac
      tt(k) = tt(k)*utfac
      dusrc(k) = dusrc(k)*utfac
      dvsrc(k) = dvsrc(k)*utfac
      dtsrc(k) = dtsrc(k)*utfac
    END DO
!-----------------------------------------------------------------------
! Project the c=0 stress (scaled) in the direction of the source wind
! for recording on the output file.
!-----------------------------------------------------------------------
    tau0x = tau(0, kbot)*xv*effgw(i)*utfac
    tau0y = tau(0, kbot)*yv*effgw(i)*utfac
    RETURN
  END SUBROUTINE GW_DRAG_PROF_BGND
!  Differentiation of get_uv in forward (tangent) mode:
!   variations  of output variables: uv_out
!   with respect to input variables: uv_in
  SUBROUTINE GET_UV_D(uv_out, uv_outd, uv_in, uv_ind)
    IMPLICIT NONE
    REAL :: uv_out, uv_in
    REAL :: uv_outd, uv_ind
    LOGICAL :: src_bypass
    IF (src_bypass) THEN
      uv_outd = uv_ind
      uv_out = uv_in
    ELSE
      uv_outd = uv_ind
      uv_out = uv_in
    END IF
  END SUBROUTINE GET_UV_D
  SUBROUTINE GET_UV(uv_out, uv_in)
    IMPLICIT NONE
    REAL :: uv_out, uv_in
    LOGICAL :: src_bypass
    IF (src_bypass) THEN
      uv_out = uv_in
    ELSE
      uv_out = uv_in
    END IF
  END SUBROUTINE GET_UV
  SUBROUTINE GET_EFFKWVMAP_1(effkwvmap_, rlat_)
    IMPLICIT NONE
    REAL :: tanh1, tanh2, effkwvmap_, rlat_
    INTRINSIC TANH
    tanh1 = (rlat_*180./pi_gwd-20.0)/6.0
    tanh2 = -((rlat_*180./pi_gwd+20.0)/6.0)
    tanh1 = TANH(tanh1)
    tanh2 = TANH(tanh2)
    effkwvmap_ = fcrit2*kwvb*(0.5*(1.0+tanh1)+0.5*(1.0+tanh2))
  END SUBROUTINE GET_EFFKWVMAP_1
  SUBROUTINE GET_EFFKWVMAP_2(effkwvmap_, rlat_, zfac)
    IMPLICIT NONE
    REAL :: effkwvmap_, rlat_, zfac
    INTRINSIC EXP
    INTRINSIC ABS
    REAL :: abs1
    IF (rlat_*180./pi_gwd + 20. .GE. 0.) THEN
      abs1 = rlat_*180./pi_gwd + 20.
    ELSE
      abs1 = -(rlat_*180./pi_gwd+20.)
    END IF
    effkwvmap_ = fcrit2*kwvo*zfac*(2.0-0.65*EXP(-(abs1/5.)))
  END SUBROUTINE GET_EFFKWVMAP_2
  SUBROUTINE GET_EFFKWVMAP_3(effkwvmap_, rlat_, zfac)
    IMPLICIT NONE
    REAL :: effkwvmap_, rlat_, zfac
    INTRINSIC EXP
    INTRINSIC ABS
    REAL :: abs1
    IF (rlat_*180./pi_gwd + 20. .GE. 0.) THEN
      abs1 = rlat_*180./pi_gwd + 20.
    ELSE
      abs1 = -(rlat_*180./pi_gwd+20.)
    END IF
    effkwvmap_ = fcrit2*kwvo*zfac*(0.7+0.65*EXP(-(abs1/5.)))
  END SUBROUTINE GET_EFFKWVMAP_3
  SUBROUTINE GET_CMU(cmu_, cmu)
    IMPLICIT NONE
    REAL :: cmu_, cmu
    INTRINSIC SIGN
    cmu_ = SIGN(1.0, cmu)
  END SUBROUTINE GET_CMU
  SUBROUTINE GET_TI(t_out, t_in)
    IMPLICIT NONE
    REAL :: t_out, t_in
    LOGICAL :: src_bypass
    t_out = t_in
  END SUBROUTINE GET_TI
END MODULE GW_DRAG_D
