ccccc
c 2013-02-07  D. Keyser  -- Final changes to run on WCOSS: use formatted print statements
c                           where previously unformatted print was > 80 characters; use GNU
c                           standard call "date_and_time" instead of calls to "date" and
c                           "time" to obtain system date and time to avoid ifort compiler
c                           warning
c 2014-07-18  D. Keyser  -- 
c                    - Keep track of maximum value for number of flights calculated at some
c                      point during the processing of subroutine acftobs_qc.  If, at the end
c                      of acftobs_qc, this value is at least 90% of the allowed limit
c                      ("maxflt", set in the main program), post a diagnostic warning message
c                      to the production joblog file prior to exiting from acftobs_qc. 
c                    - In subr. do_flt and do_reg, return (abnormally) immediately if
c                      "maxflt" is exceeded rather than waiting to test for this at end of
c                      do_flt and do_reg and then return (abnormally).  Prior to return
c                      subtract 1 from number of flights so it will remain at "maxflt". The
c                      immediate return avoids clobbering of memory in these cases.
c                    - In subr. reorder, where any new flight exceeding "maxflt" replaces the
c                      previous flight at index "maxflt" in the arrays to avoid an array
c                      overflow (done in two places original NRL version), post a diagnostic
c                      warning message to the production joblog file (found a third instance
c                      where this needs to be done in subr, reorder - original NRL version
c                      did not trap it and arrays limited to length "maxflt" would have
c                      overflowed).
c                    - If "maxflt" is exceeded in subr. dupchk (1 place possible) or in subr.
c                      do_flt (2 places possible), the abnormal return back to subr.
c                      acftobs_qc results in subr. acftobs_qc now continuing on but setting a
c                      flag for "maxflt_exceeded".  Prior to this, subr. acftobs_qc itself
c                      immediately performed an abnormal return  back to main program in such
c                      cases resulting in no more NRL QC processing.  Now NRL QC processing
c                      will continue on to the end of subr. acftobs_qc where the abnormal
c                      return  back to the main program will be triggered by the
c                      "maxflt_exceeded" flag.
c                    - There is one, apparently rare, condition where "maxflt" could be
c                      exceeded in subr. acft_obs itself (within logic which generates master
c                      list of tail numbers and counts).  Since it can't be determined if
c                      continuing on without processing (QC'ing) any more data would yield
c                      acceptable results, the program now immediately stops with condition
c                      code 98 and a diagnostic warning message is posted to the production
c                      joblog file noting that "maxflt" needs to be increased.  Prior to this
c                      it returned to the main program where it also immediately stopped with
c                      condition code 98 (so no real change in what happens here, just where
c                      it happens).
c                    - Increased format width from I5 to I6 in all places where aircraft obs
c                      index is listed out (since there now can be > 99999 reports).
c 2013-10-07  Sienkiewicz   Initialize some uninitialzed variables in 'benford_qc' and 
c                           'rejlist_qc', for 'gfortran' compile
c 2016-12-09  D. Keyser  -- 
c                    - Since "ACARS" as referred to here is not used and we earlier decided to
c                      use this to provide a separate category for TAMDARs (for stratifying
c                      statistics), all printout here changes the term "ACARS" to "TAMDAR".
c                      In addition, all comments now refer to "TAMDAR" instead of "ACARS".
c                    - Variables holding latitude and longitude data (including input
c                      arguments "alat" and "alon") now double precision. XOB and YOB in
c                      PREPBUFR file now scaled to 10**5 (was 10**2) to handle new v7 AMDAR
c                      and MDCRS reports which have this higher precision.
c                      BENEFIT: Retains exact precison here. Improves QC processing.
c                         - Note: QC here can be improved further by changing logic in many
c                                 places to account for the increased precision. This needs to
c                                 be investigated.  For now, locations in code where this
c                                 seems possible are noted by the spanning comments:
c                      ! vvvv DAK-future change perhaps to account for incr. lat/lon precision
c                      ! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
c                         - The format for all print statements containing latitude and longitude
c                           changed to print to 5 decimal places.
c                         - Intrinsic function "ifix" replaced with "int" for cases where the
c                           argument is now a real*8 lat or lon (else compiler error if "ifix"
c                           operates on a real*8 argument).
c
c   BEST VIEWED WITH 94-CHARACTER WIDTH WINDOW
ccccc
c
c ###################################################################
c                            subroutine acftobs_qc
c ###################################################################
c
      subroutine acftobs_qc(max_reps,cdtg_an,numreps,krej
     x,    c_acftreg,c_acftid,itype,idt,idp,alon,alat,pres,ht_ft
     x,    ob_t,ob_q,ob_dir,ob_spd,t_prcn
     x,    xiv_t,xiv_q,xiv_d,xiv_s,ichk_t,ichk_q,ichk_d,ichk_s
     x,    nchk_t,nchk_q,nchk_d,nchk_s
     x,    indx,isave,in_bad,c_qc,csort
     x,    maxflt,kflight,creg_flt,cid_flt,cid_flt_old,l_newflt
     x,    nobs_flt,iobs_flt,ntot_flt,nrej_flt,ntot_flt_old,nrej_flt_old
     x,    creg_reg,nobs_reg,ntot_reg,nrej_reg,ntemp_reg,nwind_reg
     x,    nwhol_reg,creg_reg_tot,nobs_reg_tot,nwhol_reg_tot
     x,    nrej_reg_tot,ntemp_reg_tot,nwind_reg_tot,nrej_inv_tot
     x,    nrej_stk_tot,nrej_grc_tot,nrej_pos_tot,nrej_ord_tot
     x,    nrej_sus_tot,lead_t_tot,lead_d_tot,lead_s_tot,n_xiv_t
     x,    n_xiv_d,n_xiv_s,sum_xiv_t,sum_xiv_d,sum_xiv_s,sumabs_xiv_t
     x,    sumabs_xiv_d,sumabs_xiv_s,l_minus9c
     x,    l_last,l_first_date,l_operational,l_pc,l_ncep,*)
c
c This routine performs qc checks on the combined ACARS, AIREP, PIREP,
c AMDAR and TAMDAR aircraft data.  To the extent possible, the data are
c sorted into tracks and checked for consistency along the tracks.

cxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
c For NCEP purposes NRL ACARS applies to TAMDAR - all references to
c  ACARS are changed to TAMDAR in printout
cxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx

c Adapted from sortacrs--P.M. Pauley's original ACARS QC program
c Most QC checks patterned after those developed by Bill Moninger
c
c Programmer: P.M. Pauley (12/22/97--modified 09/13/99)
c                          version of 2/9/2000
c
c Input:  arrays containing observations 
c
c Output: (possibly re-ordered) arrays containing observations with qc flags set
c
c # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # #
c
      implicit none
c
c Parameter statements
c --------------------
      integer io8,io30,io31,io32,io33,io34,io35,io36,io37,io38
      parameter(io8 = 8)             ! i/o unit number for log file
c
      parameter(io30 = 30)             ! i/o unit for duplicate check rejects
      parameter(io31 = 31)             ! i/o unit for spike check rejects
      parameter(io32 = 32)             ! i/o unit for invalid check rejects
      parameter(io33 = 33)             ! i/o unit for stuck check rejects
      parameter(io34 = 34)             ! i/o unit for gross check rejects
      parameter(io35 = 35)             ! i/o unit for position check rejects
      parameter(io36 = 36)             ! i/o unit for ordering check rejects
      parameter(io37 = 37)             ! i/o unit for suspect data check rejects
      parameter(io38 = 38)             ! i/o unit for reject list check rejects
c     (If it is desirable to place all rejected reports in a single file, the
c      numbers assigned in these parameter statements should be set equal so that
c      the bad reports are all written to the bad data file.)
c
c      integer nbadlat,nbadwind
c      parameter(nbadlat = 63)          ! # of acft with decimal lat/lons
c      parameter(nbadwind = 198)        ! # of acft with flipped winds
c
      integer nbadtemp,nblkwind,nblktemp
      parameter(nbadtemp = 59)         ! # of acft with temps in whole degrees
      parameter(nblkwind = 67)         ! # of acft blacklisted for wind errors
      parameter(nblktemp = 45)         ! # of acft blacklisted for temp errors
c
      integer imiss
      real amiss
      parameter(imiss = 99 999)        ! integer missing value flag
      parameter(amiss = -9999.)        ! real missing value flag
c
      character*8 cregmiss,cidmiss
      parameter(cregmiss = '        ') ! missing value flag for tail number
      parameter(cidmiss  = '9999-999') ! missing value flag for flight number
c
      real ft2m
      parameter(ft2m = 3.28084)        ! conversion factor to convert ft to m
c
      integer idt_near,idt_updn,idt_samflt
      parameter(idt_near = 1805)       ! time diff between "near" neighbors (was a0)
      parameter(idt_updn = 180)        ! time diff to check ascents/descents
      parameter(idt_samflt = 7200)     ! time diff allowed for same flight
c
      real htdif_same         
      parameter(htdif_same = 100.)     ! height difference considered negligible
c
      real htdif_1min         
      parameter(htdif_1min = 8000.)    ! maximum height difference allowed in one minute
c
c Declaration statements
c ----------------------
      integer      max_reps            ! maximum number of input reports allowed
                                       ! (initialized by calling routine)
cvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv
c replace above with this in event of future switch to dynamic memory allocation

callocinteger      max_reps            ! original number of input reports obtained from
calloc                                 ! first pass through to get total for array allocation
c^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

c
c     Internal QC flags
c     -----------------
      character*11 c_qc(max_reps)
c
c     Legend for QC flags
c     -------------------
c     ( 1:1 ) info about reject
c             'A'--altitude error
c             'B'--report declared bad in decoder or aircraft id = XX999
c             'd'--near duplicate
c             'D'--exact duplicate
c             'e'--encode error--reject report with missing winds
c             'E'--encode error--report rejected
c             'N'--duplicate check or stuck value check not performed
c             'O'--isolated off-track point
c             'p'--point closer to last rejected point than to current point
c             'P'--unrealistic airspeed
c             'r'--redundant report
c             's'--suspect reports--too few reports to check
c             'S'--suspect reports--too many rejects for flight
c             't'--time error
c             'v'--report failed bounce test
c             'V'--unrealistic vertical speed
c             'W'--waypoint error
c             'X'--isolated minimum/maximum altitude
c             '2'--second flight with same ident found
c             '.'--good report
c             '-'--not checked
c
c                                 'A'--anomalous
c     ( 2:2 ) time             \  'B' or 'b'--bad
c     ( 3:3 ) latitude          | 'E'--encode error
c     ( 4:4 ) longitude         | 'I' or 'i'--inconsistent
c     ( 5:5 ) pressure/altitude | 'K'--constant (stuck) values
c     ( 6:6 ) temperature       | 'M'--missing
c     ( 7:7 ) direction         | 'N'--not checked
c     ( 8:8 ) speed             | 'R' or 'r'--rehabilitated [1]
c     ( 9:9 ) moisture         /  'S'--suspect
c                                 '-'--not checked
c     					        '.'--passed checks
c
c     (10:10) black lists
c             'C'--aircraft reports temperature in whole deg C
c             'F'--aircraft reports flipped winds (not checked here)
c             'L'--aircraft reports decimal lat/lon (not checked here)
c             'T'--temperature blacklisted
c             'W'--winds blacklisted
c             'O'--both temperature and winds blacklisted
c             '.'--passed black-list checks
c
c     (11:11) flight phase
c             'a'--low-resolution ascent
c             'A'--high-resolution ascent
c             'd'--low-resolution descent
c             'D'--high-resolution descent
c             'I'--isolated report
c             'L'--level flight
c             'N'--time difference too great to permit check
c             'U'--unknown
c 
c     [1] If altitude is read and pressure computed, c_qc(ii)(5:5) = 'R'
c         If pressure is read and altitude computed, c_qc(ii)(5:5) = 'r'
c
c     Data arrays
c     -----------
      character*10 cdtg_an             ! date time group for analysis
      integer      numreps_orig        ! original number of reports passed in (bad and good)
      integer      numreps             ! number of reports (deemped "good"
                                       !  reports after each QC step)
      integer      itype(max_reps)     ! type of aircraft data
      integer      idt(max_reps)       ! time in seconds to analysis time 
      integer      idp(max_reps)       ! surface pressure change at ob location
      character*8  c_acftreg(max_reps) ! aircraft registration (tail) number
      character*9  c_acftid(max_reps)  ! aircraft flight number
      real*8       alat(max_reps)      ! latitude
     $,            alon(max_reps)      ! longitude
      real         pres(max_reps)      ! pressure
     $,            ht_ft(max_reps)     ! height in feet
      real         t_prcn(max_reps)    ! temperature precision
      real         ob_t(max_reps)      ! temperature
     $,            ob_q(max_reps)      ! specific humidity
     $,            ob_dir(max_reps)    ! wind direction
     $,            ob_spd(max_reps)    ! wind speed
      real         xiv_t(max_reps)     ! temperature innovation (ob - bk)
     $,            xiv_q(max_reps)     ! specific humidity innovation (ob - bk)
     $,            xiv_d(max_reps)     ! wind direction innovation (ob - bk)
     $,            xiv_s(max_reps)     ! wind speed innovation (ob - bk)
      integer      ichk_t(max_reps)    ! NRL QC flag for temperature ob
     $,            ichk_q(max_reps)    ! NRL QC flag for specific humidity ob
     $,            ichk_d(max_reps)    ! NRL QC flag for wind direction ob
     $,            ichk_s(max_reps)    ! NRL QC flag for wind speed ob
      integer      nchk_t(max_reps)    ! NCEP QC flag for temperature ob
     $,            nchk_q(max_reps)    ! NCEP QC flag for specific humidity ob
     $,            nchk_d(max_reps)    ! NCEP QC flag for wind direction ob
     $,            nchk_s(max_reps)    ! NCEP QC flag for wind speed ob
      logical      l_minus9c(max_reps) ! true for mdcrs -9C temperatures
c
c     Arrays for mixed duplicates
c     ---------------------------
      integer      maxflt              ! maximum number of flights in dataset
                                       !  (initialized by calling routine)
      integer      maxflt_exceeded     ! flag to indicate that maxflt has been exceeded (=1,
                                       !  else =0)
      character*6  cmaxflt             ! character form of maxflt for NCEP print statement
c      character*9  c_air_id(max_reps)  ! airep flight id for mixed duplicate
ccccdak     x,            c_acr_id(max_reps)  ! acars flight id for mixed duplicate
c     x,            c_acr_id(max_reps)  ! tamdar flight id for mixed duplicate
ccccdak      character*8  c_acr_reg(maxflt)   ! acars tail number for mixed duplicate
c      character*8  c_acr_reg(maxflt)   ! tamdar tail number for mixed duplicate
c      integer      idt_min(maxflt)     ! min time for flight segment
c     $,            idt_max(maxflt)     ! max time for flight segment
c
c     Pointers
c     --------
      integer      indx(max_reps)      ! pointer index for good reports
     $,            in_bad(max_reps)    ! pointer index for bad reports
     $,            isave(max_reps)     ! second pointer index
     $,            krej                ! counter for number of reports rejected
c
c     Blacklists
c     ----------
      character*8  cbadtemp(nbadtemp)  ! acft reports temperature in whole deg C
c     $,            cbadlat(nbadlat)    ! acft reports decimal lat/lon
c     $,            cbadwind(nbadwind)  ! acft reports flipped winds
     $,            cblkwind(nblkwind)  ! winds blacklisted
     $,            cblktemp(nblktemp)  ! temperatures blacklisted
c
c     Flight statistics
c     -----------------
      integer      kflight             ! number of flights in dataset
      integer      kflight_max         ! number of flights in dataset (maximum over course of
                                       !  processing)
      character*8  creg_flt(maxflt)    ! tail number for each flight
      character*9  cid_flt(maxflt)     ! flight id for each flight
     $,            cid_flt_old(maxflt) ! previous value of cid_flt
      integer      nobs_flt(maxflt)    ! number of reports per flight
     $,            iobs_flt(maxflt)    ! index for first report in each flight
     $,            ntot_flt(maxflt)    ! total number of reports per flight
     $,            nrej_flt(maxflt)    ! number of reports rejected per flight
     $,            ntot_flt_old(maxflt)! previous value of total number of reports per flight
     $,            nrej_flt_old(maxflt)! previous value of # of reports rejected per flight
c
c     Tail number statistics
c     ----------------------
      integer      kreg                ! actual number of tail numbers in dataset
      integer      kreg_max            ! actual number of tail numbers in dataset (maximum
                                       !  over course of processing)
      character*8  creg_reg(maxflt)    ! tail numbers
      integer      nobs_reg(maxflt,5)  ! number of reports per tail number per type
      integer      ntot_reg(maxflt,5)  ! total number of reports rejected per tail number
      integer      nrej_reg(maxflt,5)  ! number of reports rejected per tail number
      integer      ntemp_reg(maxflt,5) ! number of reports w. rejected temp
      integer      nwind_reg(maxflt,5) ! number of reports w. rejected winds
      integer      nwhol_reg(maxflt,5) ! number of reports w. temp in whole deg
c
      integer      kreg_tot            ! number of unique tail numbers
      integer      kreg_tot_max        ! number of unique tail numbers (maximum over course
                                       !  of processing)
      character*8  creg_reg_tot(maxflt)! master list of tail numbers
      integer      nobs_reg_tot(maxflt,5) ! number of reports per tail number
     $,            nwhol_reg_tot(maxflt,5)! number of temps in whole degs /tail number
     $,            nrej_reg_tot(maxflt,5) ! number of reports rejected per tail number
     $,            ntemp_reg_tot(maxflt,5)! number of temps rejected per tail number
     $,            nwind_reg_tot(maxflt,5)! number of winds rejected per tail number
     $,            nrej_inv_tot(maxflt,5) ! number of reports rejected in invalid
     $,            nrej_stk_tot(maxflt,5) ! number of reports rejected in stkchek
     $,            nrej_grc_tot(maxflt,5) ! number of reports rejected in grchek
     $,            nrej_pos_tot(maxflt,5) ! number of reports rejected in poschek
     $,            nrej_ord_tot(maxflt,5) ! number of reports rejected in ordchek
     $,            nrej_sus_tot(maxflt,5) ! number of reports rejected in suspect data check
      integer      lead_t_tot(maxflt,11,2)  ! distribution of temperature innovations
     $,            lead_d_tot(maxflt,11,2)  ! distribution of temperature innovations
     $,            lead_s_tot(maxflt,11,2)  ! distribution of temperature innovations
     $,            n_xiv_t(maxflt,2)    ! number of temperature innovations
     $,            n_xiv_d(maxflt,2)    ! number of wind direction innovations
     $,            n_xiv_s(maxflt,2)    ! number of wind speed innovations
      integer      mm                   ! do loop index--over tail numbers
      real         percent              ! percentage of obs rejected
      real         sum_xiv_t(maxflt,2)    ! sum of temperature innovations
     $,            sum_xiv_d(maxflt,2)    ! sum of wind direction innovations
     $,            sum_xiv_s(maxflt,2)    ! sum of wind speed innovations
     $,            sumabs_xiv_t(maxflt,2) ! sum of absolute value of temperature innovations
     $,            sumabs_xiv_d(maxflt,2) ! sum of absolute value of wind direction innovations
     $,            sumabs_xiv_s(maxflt,2) ! sum of absolute value of wind speed innovations
      logical      l_newflt(maxflt)       ! true if flight is new flight
c
c     Data counters
c     -------------
      integer      kbadtot             ! total number of rejected reports
     $,            n_minus9C(5)        ! number of -9C temperatures rejected
c
c     Functions
c     ---------
      character*16 c_insty_ob          ! function to convert integer instrument
                                       !   type to character instrument type
c
      integer      insty_ob_fun        ! function to convert character
                                       !   instrument type to integer
c
c     Other variables
c     ---------------
      integer      ii                  ! do loop index
     $,            kk                  ! do loop index
     $,            iob                 ! do loop index--over reports
     $,            len                 ! length of filename
ccccdak      integer      knt_acars           ! number of acars reports
      integer      knt_acars           ! number of tamdar reports
     $,            knt_mdcrs           ! number of mdcrs reports
     $,            knt_man_airep       ! number of manual airep reports
     $,            knt_man_Yairep      ! number of manual YRXX airep reports
     $,            knt_airep           ! number of airep reports
     $,            knt_amdar           ! number of amdar reports
c
ccccdak      integer      i_acars             ! instrument type for acars
      integer      i_acars             ! instrument type for tamdar
ccccdak     $,            i_acars_lvl         ! instrument type for acars--level flt
     $,            i_acars_lvl         ! instrument type for tamdar--level flt
ccccdak     $,            i_acars_asc         ! instrument type for acars--ascent
     $,            i_acars_asc         ! instrument type for tamdar--ascent
ccccdak     $,            i_acars_des         ! instrument type for acars--descent
     $,            i_acars_des         ! instrument type for tamdar--descent
     $,            i_mdcrs             ! instrument type for mdcrs
     $,            i_mdcrs_lvl         ! instrument type for mdcrs--level flt
     $,            i_mdcrs_asc         ! instrument type for mdcrs--ascent
     $,            i_mdcrs_des         ! instrument type for mdcrs--descent
     $,            i_man_airep         ! instrument type for manual aireps
     $,            i_man_Yairep        ! instrument type for manual aireps (YRXX)
     $,            i_airep             ! instrument type for airep
     $,            i_airep_lvl         ! instrument type for airep--level flt
     $,            i_airep_asc         ! instrument type for airep--ascent
     $,            i_airep_des         ! instrument type for airep--descent
     $,            i_amdar             ! instrument type for amdar
     $,            i_amdar_lvl         ! instrument type for amdar--level flt
     $,            i_amdar_asc         ! instrument type for amdar--ascent
     $,            i_amdar_des         ! instrument type for amdar--descent
     $,            kidt                ! relative time + 100 000 for sort
c
      integer      iht_ft              ! integer form of flight level
     $,            ilat                ! integer form of latitude
     $,            ilon                ! integer form of longitude
c     $,            kdup(maxflt)        ! number of mixed duplicates per id pair
c
      integer      kdtg_an             ! integer form of date-time group
     $,            k_AMDAR_tot         ! total number of AMDAR reports
     $,            k_AIREP_tot         ! total number of AIREP reports
     $,            k_UAL_tot           ! total number of UAL AIREP reports
     $,            k_EU_tot            ! total number of EU AIREP reports
     $,            k_AU_tot            ! total number of AU AIREP reports
     $,            k_other_tot         ! total number of other AIREP reports
     $,            k_AIREP_good        ! number of good AIREP reports
     $,            k_YAIREP_good       ! number of good YRXX86 AIREP reports
     $,            k_UAL_good          ! number of good UAL AIREP reports
     $,            k_EU_good           ! number of good EU AIREP reports
     $,            k_AU_good           ! number of good AU AIREP reports
     $,            k_other_good        ! number of good other AIREP reports
      real         per_AIREP           ! percentage of good AIREP reports
     $,            per_UAL             ! percentage of good UAL AIREP reports
     $,            per_EU              ! percentage of good EU AIREP reports
     $,            per_AU              ! percentage of good AU AIREP reports
     $,            per_other           ! percentage of good other AIREP reports
c
      integer      k_total             ! total number of aircraft reports
     $,            k_good              ! number of good aircraft reports
     $,            k_tot_mdcrs         ! total number of unspecified mdcrs reports
     $,            k_good_mdcrs        ! number of good unspecified mdcrs reports
     $,            k_tot_mdcrs_lvl     ! total number of level mdcrs reports
     $,            k_good_mdcrs_lvl    ! number of good level mdcrs reports
     $,            k_tot_mdcrs_asc     ! total number of ascent mdcrs reports
     $,            k_good_mdcrs_asc    ! number of good ascent mdcrs reports
     $,            k_tot_mdcrs_des     ! total number of descent mdcrs reports
     $,            k_good_mdcrs_des    ! number of good descent mdcrs reports
     $,            k_tot_amdar         ! total number of unspecified amdar reports
     $,            k_good_amdar        ! number of good unspecified amdar reports
     $,            k_tot_amdar_lvl     ! total number of level amdar reports
     $,            k_good_amdar_lvl    ! number of good level amdar reports
     $,            k_tot_amdar_asc     ! total number of ascent amdar reports
     $,            k_good_amdar_asc    ! number of good ascent amdar reports
     $,            k_tot_amdar_des     ! total number of descent amdar reports
     $,            k_good_amdar_des    ! number of good descent amdar reports
     $,            k_tot_airep         ! total number of unspecified airep reports
     $,            k_good_airep        ! number of good unspecified airep reports
     $,            k_tot_airep_lvl     ! total number of level airep reports
     $,            k_good_airep_lvl    ! number of good level airep reports
     $,            k_tot_airep_asc     ! total number of ascent airep reports
     $,            k_good_airep_asc    ! number of good ascent airep reports
     $,            k_tot_airep_des     ! total number of descent airep reports
     $,            k_good_airep_des    ! number of good descent airep reports
     $,            k_tot_man_airep     ! total number of man_airep reports
     $,            k_good_man_airep    ! number of good man_airep reports
c
      character*6  c_ht_ft             ! character form of flight level
      character*4  c_type              ! character form of ob type
      character*5  c_lat               ! character form of latitude
      character*6  c_lon               ! character form of longitude
      character*7  c_idt               ! character form of relative time
      character*25 csort(max_reps)     ! variable used for sorting data 
c
      character*200 c_path             ! path name for output files
      integer lpath                    ! length of c_path
c
      character*200 infile30           ! file name for rejected duplicates
     $,            infile31            ! file name for rejected spike reports
     $,            infile32            ! file name for rejected invalid reports
     $,            infile33            ! file name for rejected stuck reports
     $,            infile34            ! file name for rejected gross errors
     $,            infile35            ! file name for rejected position errors
     $,            infile36            ! file name for rejected ordering errors
     $,            infile37            ! file name for rejected suspect data errors
     $,            infile38            ! file name for rejected reject list reports
     $,            logfile             ! file name for log file
c
      logical      l_opn               ! true if file is already open
     $,            l_first             ! true first time subroutine is called
     $,            l_first_date        ! true for first date 
                                       !  (initialized by calling routine)
     $,            l_print             ! true for printing values
     $,            l_sort              ! true if data need to be sorted
     $,            l_flight            ! true if flight stats to be updated
     $,            l_found             ! true if tail numbers found on list
     $,            l_last              ! true if last time subroutine is called
                                       !  (initialized by calling routine)
     $,            l_pc                ! if true, set up path names for Pat's PC
                                       !  (initialized by calling routine)
     $,		   l_ncep	       ! if true, use NCEP preferences
                                       !  (initialized by calling routine)
c
      logical      l_do_innov          ! compute innovation distribution if true
     $,            l_operational       ! run QC in operational mode if true
                                       !  (initialized by calling routine)
     $,            l_init              ! initialize counters if true
     $,            l_innov_miss        ! true if all innovations missing
c
c Data statements
c ---------------
cc
cc     List of aircraft that report lat/lon in decimal instead of degrees,
cc     minutes, tenths of minutes.  (NOTE:  this may ONLY be true at FSL)
cc     (from W. Moninger at FSL)
cc     -------------------------------------------------------------------
c       data cbadlat/'N000UA','N105UA','N106UA','N171UA','N172UA'
c     A,    'N173UA','N174UA','N175UA','N176UA','N177UA','N178UA'
c     B,    'N179UA','N180UA','N181UA','N182UA','N183UA','N184UA'
c     C,    'N185UA','N186UA','N187UA','N188UA','N189UA','N190UA'
c     D,    'N191UA','N192UA','N403UP','N404UP','N405UP','N406UP'
c     E,    'N410UP','N414UP','N416UP','N417UP','N419UP','N421UP'
c     F,    'N425UP','N426UP','N427UP','N429UP','N434UP','N641UA'
c     G,    'N642UA','N643UA','N644UA','N645UA','N646UA','N647UA'
c     H,    'N648UA','N649UA','N650UA','N651UA','N652UA','N653UA'
c     I,    'N654UA','N655UA','N656UA','N657UA','N658UA','N659UA'
c     J,    'N660UA','N661UA','N662UA','N663UA'/
c
c     List of aircraft that report temperature in degrees celsius,
c     rather than in the expected tenths of degrees.
c     (from W. Moninger at FSL)
c     (Pseudo-id list derived from Oct 1998 data)
c     (Pseudo-id list corrected from Sept 1999 data
c      '35SYR4RA','5UUIR4BA','D5KYR5BA','ECOIR4BA' fixed)
c     Check by tail number disabled in grchek after 1999100100--modified on 5/3/01 by PMP
c     In 19-31 Oct 1999 dataset, the following aircraft were also  fixed:
c      '2OZYR4JA','4QJYR4BA','CE5YR4BA','NH5YR3BA','PI1IR4ZA',
c      'QJ5IR5BA','UUEYR3ZA','WSAIR3JA','XV2YR3RA','YITYR4ZA'
c     -----------------------------------------------------------------------------------
      data cbadtemp/'N916UA',  'N917UA',  'N918UA',  'N919UA',  'N920UA'
     A,  'N921UA',  'N923UA',  'N924UA',  'N925UA',  'N926UA'
     B,  'N927UA',  'N928UA',  'N929UA',  'N930UA',  'N931UA'
     C,  'N932UA',  'N933UA',  'N934UA',  'N936UA',  'N937UA'
     D,  'N938UA',  'N940UA',  'N941UA',  'N942UA',  'N944UA'
     E,  'N945UA',  'N946UA',  'N947UA',  'N948UA',  'N949UA'
     F,  'N950UA',  'N951UA',  'N953UA',  'N954UA'
     G,  '034IR4RA','2OZYR4JA','4JPIR4RA','4QJYR4BA','A12YR4RA'
     H,  'CE5YR4BA','G5GIR5BA','KTQYR3BA','NH5YR3BA','O2KYR4ZA'
     J,  'PI1IR4ZA','QJ5IR5BA','QQZYR3ZA','RUMIR3ZA','TGPIR3JA'
     K,  'UUEYR3ZA','VAVIR3ZA','WSAIR3JA','XV2YR3RA','YITYR4ZA'
     L,  'ZZAYR4JA','35SYR4RA','5UUIR4BA','D5KYR5BA','ECOIR4BA'/
cc
cc     List of Delta MD88s to be flipped.
cc     (from W. Moninger at FSL)
cc     ----------------------------------
c      data cbadwind/'N900DE','N900DL','N901DE','N901DL','N902DE'
c     A,  'N902DL','N903DE','N903DL','N904DE','N904DL','N905DE','N905DL'
c     B,  'N906DE','N906DL','N907DE','N907DL','N908DE','N908DL','N909DE'
c     C,  'N909DL','N910DE','N910DL','N911DE','N911DL','N912DE','N912DL'
c     D,  'N913DL','N914DE','N914DL','N915DE','N915DL','N916DE','N916DL'
c     E,  'N917DE','N917DL','N918DE','N918DL','N919DE','N919DL','N920DE'
c     F,  'N920DL','N921DE','N921DL','N922DE','N922DL','N923DE','N923DL'
c     G,  'N924DE','N924DL','N925DE','N925DL','N926DE','N926DL','N927DE'
c     H,  'N927DL','N928DE','N928DL','N929DE','N929DL','N930DE','N930DL'
c     I,  'N931DE','N931DL','N932DE','N932DL','N933DE','N933DL','N934DE'
c     J,  'N934DL','N935DE','N935DL','N936DE','N936DL','N937DE','N937DL'
c     K,  'N938DE','N938DL','N939DE','N939DL','N940DE','N940DL','N941DE'
c     L,  'N941DL','N942DE','N942DL','N943DE','N943DL','N944DE','N945DE'
c     M,  'N945DL','N946DE','N946DL','N947DE','N947DL','N948DE','N948DL'
c     N,  'N949DE','N949DL','N950DE','N950DL','N951DE','N951DL','N952DE'
c     O,  'N952DL','N953DE','N953DL','N954DE','N954DL','N955DE','N955DL'
c     P,  'N956DE','N956DL','N957DE','N957DL','N958DE','N958DL','N959DE'
c     Q,  'N959DL','N960DE','N960DL','N961DE','N961DL','N962DE','N962DL'
c     R,  'N963DE','N963DL','N964DE','N964DL','N965DE','N965DL','N966DE'
c     S,  'N966DL','N967DE','N967DL','N968DE','N968DL','N969DE','N969DL'
c     T,  'N970DE','N970DL','N971DE','N971DL','N972DE','N972DL','N973DE'
c     U,  'N973DL','N974DE','N974DL','N975DE','N975DL','N976DE','N976DL'
c     V,  'N977DE','N977DL','N978DE','N978DL','N979DE','N979DL','N980DE'
c     W,  'N980DL','N981DE','N981DL','N982DE','N982DL','N983DE','N983DL'
c     X,  'N984DE','N984DL','N985DE','N985DL','N986DE','N986DL','N987DE'
c     Y,  'N987DL','N988DE','N988DL','N989DE','N989DL','N990DE','N990DL'
c     Z,  'N991DE','N991DL','N992DE','N992DL','N993DE','N993DL','N994DE'
c     a,  'N994DL','N995DE','N995DL','N996DE','N996DL','N997DE','N997DL'
c     b,  'N998DE','N998DL','N999DE','N999DL'/
c
c     Aircraft blacklisted for wind errors
c     (from W. Moninger at FSL)
c     ------------------------------------
      data cblkwind/'N508UA','N581UA','N586UA','N587UA','N902DL'
     A,    'N904DL','N908DL','N909DL','N910DL','N911DL','N912DL'
     B,    'N913DE','N913DL','N914DE','N914DL','N915DE','N915DL'
     C,    'N916DL','N917DE','N917DL','N918DE','N918DL','N919DE'
     D,    'N921DL','N922DL','N924DL','N926DL','N928DL','N929DL'
     E,    'N930DL','N931DL','N933DL','N934DL','N936DL','N938DL'
     F,    'N939DL','N940DL','N941DL','N942DL','N943DL','N944DL'
     G,    'N948DL','N949DL','N950DL','N951DL','N952DL','N953DL'
     H,    'N954DL','N955DL','N957DL','N958DL','N960DL','N964DL'
     I,    'N964DL','N966DL','N967DL','N968DL','N969DL','N970DL'
     J,    'N971DL','N972DL','N981DL','N983DL','N984DL','N985DL'
     K,    'N986DL','N?O970'/
c
c     Aircraft blacklisted for temperature errors
c     (from W. Moninger at FSL)
c     -------------------------------------------
      data cblktemp/'N508UA','N581UA','N585UA','N586UA','N587UA'
     A,    'N916UA','N917UA','N918UA','N919UA','N920UA','N921UA'
     B,    'N922UA','N923UA','N924UA','N925UA','N926UA','N927UA'
     C,    'N928UA','N929UA','N930UA','N931UA','N932UA','N933UA'
     D,    'N934UA','N935UA','N936UA','N937UA','N938DL','N938UA'
     E,    'N940UA','N941UA','N942UA','N944UA','N945UA','N946UA'
     F,    'N947UA','N948UA','N949UA','N950UA','N951UA','N952UA'
     G,    'N953UA','N954UA','N955UA','N985DL'/
c
c # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # #

c Start subroutine.
c -----------------
        write(*,*)
        write(*,*) '**********************'
        write(*,*) 'Welcome to acftobs_qc'
        call system('date')
        write(*,*) '**********************'
        write(*,*)

        numreps_orig = numreps  ! need to save numreps_orig for input to INDEXC later
c
c Set up path for output files
c ----------------------------
      if(l_pc) then
        l_init = .false.
        l_do_innov = .true.
cc        c_path = 'c:\MyFiles\acft_data\acftqc_tfile\'    ! path for pc
        c_path = 'c:\MyFiles\acft_data\acftqc_tfile\\'    ! path for pc
        call slen(c_path,lpath)
c
      elseif(.not.l_operational) then
        l_init = .true.
        l_do_innov = .false.
        call getenv('INNOVATIONS',c_path)
        call slen(c_path,lpath)
        c_path = c_path(1:lpath)//'acft/'        ! path for Origin
        call slen(c_path,lpath)
c
      elseif(l_ncep) then 
	l_init = .true. ! init counters for each run
	l_operational = .false. ! extra printout/log files = yes
	l_do_innov = .true. 
	c_path = ' ' ! output will go to working directory
	call slen(c_path,lpath)

c Open log file for acftobs_qc.
c -----------------------------
c        open(io8,status='new')

      else
        l_init = .true.
        l_do_innov = .false.
      endif
c
c Test if log file is already open
c --------------------------------
      print *, 'checking if io8 is open...'

      inquire(unit = io8,opened = l_opn)
      print *, 'done checking if io8 is open...',l_opn
c
c Open file if not already open
c -----------------------------
      if(.not.l_opn) then
        if(lpath.gt.0) then
           logfile = c_path(1:lpath)//'acftqc_'//cdtg_an//'.log'
        else
           logfile = 'acftqc_'//cdtg_an//'.log'
        endif
        call slen(logfile,len)
        print *, 'trying to open io8 ', trim(logfile)
        open(unit = io8, file = logfile(1:len)
     $,      form = 'FORMATTED',status = 'UNKNOWN')
        print *, 'done trying to open io8'

      endif
c
      write(io8,*)
      write(io8,*) 'Beginning acftobs_qc!'
c
c Open individual files for rejected data if the assigned unit is not opened
c (The io numbers may all be set equal to put all rejected data in same file.)
c -----------------------------------------------------------------------------
      if(.not.l_operational) then
        inquire(unit = io30,opened = l_opn)
        if(.not.l_opn) then
          if(lpath.gt.0) then
             infile30 = c_path(1:lpath)//'acftqc_'//cdtg_an//'.dup'
          else
             infile30 = 'acftqc_'//cdtg_an//'.dup'
          endif
          call slen(infile30,len)
          open(unit = io30, file = infile30(1:len)
     $,        form = 'FORMATTED',status = 'UNKNOWN')
          write(io8,*)
          write(io8,*) infile30(1:len),' successfully opened'
        else
          write(io8,*)
          write(io8,*) infile30(1:len),' already open'
        endif
c
        inquire(unit = io31,opened = l_opn)
        if(.not.l_opn) then
          if(lpath.gt.0) then
             infile31 = c_path(1:lpath)//'acftqc_'//cdtg_an//'.spk'
          else
             infile31 = 'acftqc_'//cdtg_an//'.spk'
          endif
          call slen(infile31,len)
          open(unit = io31, file = infile31(1:len)
     $,        form = 'FORMATTED',status = 'UNKNOWN')
          write(io8,*)
          write(io8,*) infile31(1:len),' successfully opened'
        else
          write(io8,*)
          write(io8,*) infile31(1:len),' already open'
        endif
c
        inquire(unit = io32,opened = l_opn)
        if(.not.l_opn) then
          if(lpath.gt.0) then
             infile32 = c_path(1:lpath)//'acftqc_'//cdtg_an//'.inv'
          else
             infile32 = 'acftqc_'//cdtg_an//'.inv'
          endif
          call slen(infile32,len)
          open(unit = io32, file = infile32(1:len)
     $,        form = 'FORMATTED',status = 'UNKNOWN')
          write(io8,*)
          write(io8,*) infile32(1:len),' successfully opened'
        else
          write(io8,*)
          write(io8,*) infile32(1:len),' already open'
        endif
c
        inquire(unit = io33,opened = l_opn)
        if(.not.l_opn) then
          if(lpath.gt.0) then
             infile33 = c_path(1:lpath)//'acftqc_'//cdtg_an//'.stk'
          else
             infile33 = 'acftqc_'//cdtg_an//'.stk'
          endif
          call slen(infile33,len)
          open(unit = io33, file = infile33(1:len)
     $,        form = 'FORMATTED',status = 'UNKNOWN')
          write(io8,*)
          write(io8,*) infile33(1:len),' successfully opened'
        else
          write(io8,*)
          write(io8,*) infile33(1:len),' already open'
        endif
c
        inquire(unit = io34,opened = l_opn)
        if(.not.l_opn) then
          if(lpath.gt.0) then
             infile34 = c_path(1:lpath)//'acftqc_'//cdtg_an//'.grc'
          else
             infile34 = 'acftqc_'//cdtg_an//'.grc'
          endif
          call slen(infile34,len)
          open(unit = io34, file = infile34(1:len)
     $,        form = 'FORMATTED',status = 'UNKNOWN')
          write(io8,*)
          write(io8,*) infile34(1:len),' successfully opened'
        else
          write(io8,*)
          write(io8,*) infile34(1:len),' already open'
        endif
c
        inquire(unit = io35,opened = l_opn)
        if(.not.l_opn) then
          if(lpath.gt.0) then
             infile35 = c_path(1:lpath)//'acftqc_'//cdtg_an//'.inc'
          else
             infile35 = 'acftqc_'//cdtg_an//'.inc'
          endif
          call slen(infile35,len)
          open(unit = io35, file = infile35(1:len)
     $,        form = 'FORMATTED',status = 'UNKNOWN')
          write(io8,*)
          write(io8,*) infile35(1:len),' successfully opened'
        else
          write(io8,*)
          write(io8,*) infile35(1:len),' already open'
        endif
c
        inquire(unit = io36,opened = l_opn)
        if(.not.l_opn) then
          if(lpath.gt.0) then
             infile36 = c_path(1:lpath)//'acftqc_'//cdtg_an//'.ord'
          else
             infile36 = 'acftqc_'//cdtg_an//'.ord'
          endif
          call slen(infile36,len)
          open(unit = io36, file = infile36(1:len)
     $,        form = 'FORMATTED',status = 'UNKNOWN')
          write(io8,*)
          write(io8,*) infile36(1:len),' successfully opened'
        else
          write(io8,*)
          write(io8,*) infile36(1:len),' already open'
        endif
c
        inquire(unit = io37,opened = l_opn)
        if(.not.l_opn) then
          if(lpath.gt.0) then
             infile37 = c_path(1:lpath)//'acftqc_'//cdtg_an//'.sus'
          else
             infile37 = 'acftqc_'//cdtg_an//'.sus'
          endif
          call slen(infile37,len)
          open(unit = io37, file = infile37(1:len)
     $,        form = 'FORMATTED',status = 'UNKNOWN')
          write(io8,*)
          write(io8,*) infile37(1:len),' successfully opened'
        else
          write(io8,*)
          write(io8,*) infile37(1:len),' already open'
        endif
c
        inquire(unit = io38,opened = l_opn)
        if(.not.l_opn) then
          if(lpath.gt.0) then
             infile38 = c_path(1:lpath)//'acftqc_'//cdtg_an//'.lst'
          else
             infile38 = 'acftqc_'//cdtg_an//'.lst'
          endif
          call slen(infile38,len)
          open(unit = io38, file = infile38(1:len)
     $,        form = 'FORMATTED',status = 'UNKNOWN')
          write(io8,*)
          write(io8,*) infile38(1:len),' successfully opened'
        else
          write(io8,*)
          write(io8,*) infile38(1:len),' already open'
        endif
      endif
c
c Initialize arrays
c -----------------
      do ii=1,max_reps
        csort(ii)   = 'zzzzzzzzzzzzzzzzzzzzzzzzz'
        indx(ii) = ii
      enddo
c
      krej = 0
      maxflt_exceeded = 0
c
      kreg = 0
      if(l_first_date) then
        kreg_tot = 0
        creg_reg_tot = 'xxxxxxxx'
c
        if(.not.l_operational) then
          nobs_reg_tot = 0
          nrej_reg_tot = 0
          nrej_inv_tot = 0
          nrej_stk_tot = 0
          nrej_grc_tot = 0
          nrej_pos_tot = 0
          nrej_ord_tot = 0
          nrej_sus_tot = 0
          nwhol_reg_tot = 0
          ntemp_reg_tot = 0
          nwind_reg_tot = 0
        endif
c
      endif
      l_first_date = .false.
c
      ntot_reg = 0
c
c Initialize aircraft data types
c ------------------------------
      i_acars      = insty_ob_fun('acars')
      i_acars_lvl  = insty_ob_fun('acars_lvl') 
      i_acars_asc  = insty_ob_fun('acars_asc') 
      i_acars_des  = insty_ob_fun('acars_des') 
      i_mdcrs      = insty_ob_fun('mdcrs')
      i_mdcrs_lvl  = insty_ob_fun('mdcrs_lvl') 
      i_mdcrs_asc  = insty_ob_fun('mdcrs_asc') 
      i_mdcrs_des  = insty_ob_fun('mdcrs_des')
      i_man_airep  = insty_ob_fun('man-airep') 
      i_man_Yairep = insty_ob_fun('man-Yairep') 
      i_airep      = insty_ob_fun('airep')
      i_airep_lvl  = insty_ob_fun('airep_lvl')
      i_airep_asc  = insty_ob_fun('airep_asc')
      i_airep_des  = insty_ob_fun('airep_des')
      i_amdar      = insty_ob_fun('amdar')
      i_amdar_lvl  = insty_ob_fun('amdar_lvl')
      i_amdar_asc  = insty_ob_fun('amdar_asc')
      i_amdar_des  = insty_ob_fun('amdar_des')
c
c Output reports to log file if desired
c -------------------------------------
      l_print = .false.
c
      if(l_print) then
        write(io8,*) 
        write(io8,*) 'Reports before QC processing'
        write(io8,*) '----------------------------'
        call pr_workdata(max_reps,numreps,indx
     x,      alat,alon,pres,ht_ft,idt,idp,c_acftreg,c_acftid,itype        
     x,      t_prcn,ob_t,ob_q,ob_dir,ob_spd
     x,      xiv_t,xiv_q,xiv_d,xiv_s,ichk_t,ichk_q,ichk_d,ichk_s
     x,      cdtg_an,c_qc,csort,io8)        
      endif
c
c Count reports by aircraft data type
c -----------------------------------
      knt_acars = 0
      knt_mdcrs = 0
      knt_man_airep = 0
      knt_man_Yairep = 0
      knt_airep = 0
      knt_amdar = 0
c
c Form variable to sort--time + level + lat + lon + type
c (first sort is to check for duplicates)
c ------------------------------------------------------
      write(io8,*)
      write(io8,*) 'Forming variable to sort--time+level+lat+lon+type'
      write(io8,*) '-------------------------------------------------'
c
      if(l_pc) call p_ddtg('Forming variable to sort',io8)
c
      do ii=1,numreps
c
        if(itype(ii).eq.i_acars.or.
     $     itype(ii).eq.i_acars_lvl.or.
     $     itype(ii).eq.i_acars_asc.or.
     $     itype(ii).eq.i_acars_des) then
c
          knt_acars = knt_acars + 1
c
        elseif(itype(ii).eq.i_mdcrs.or.
     $         itype(ii).eq.i_mdcrs_lvl.or.
     $         itype(ii).eq.i_mdcrs_asc.or.
     $         itype(ii).eq.i_mdcrs_des) then
c
          knt_mdcrs = knt_mdcrs + 1
c
        elseif(itype(ii).eq.i_man_airep) then
c
          knt_man_airep = knt_man_airep + 1
c
        elseif(itype(ii).eq.i_man_Yairep) then
c
          knt_man_Yairep = knt_man_Yairep + 1
c
        elseif(itype(ii).eq.i_airep.or.
     $         itype(ii).eq.i_airep_lvl.or.
     $         itype(ii).eq.i_airep_asc.or.
     $         itype(ii).eq.i_airep_des) then
c
          knt_airep = knt_airep + 1
c
        elseif(itype(ii).eq.i_amdar.or. 
     $         itype(ii).eq.i_amdar_lvl.or.
     $         itype(ii).eq.i_amdar_asc.or.
     $         itype(ii).eq.i_amdar_des) then
c
          knt_amdar = knt_amdar + 1
        endif
c
        kidt = idt(ii) + 100 000
        if(kidt.ge.1 000 000)
     $    write(io8,*) 'kidt too large--',kidt
        write(c_idt,'(i6)') kidt
c
        if(ht_ft(ii).eq.amiss) then
          c_ht_ft = '999999'
        else
          iht_ft = nint(ht_ft(ii)) + 100 000
         if(iht_ft.ge.200 000) then ! if nint(ht_ft(ii)) = 100,000 or greater
            write(io8,*)
            write(io8,*) 'iht_ft too large--',iht_ft
            write (io8,8001) ii,c_insty_ob(itype(ii))
     x,        c_acftreg(ii),c_acftid(ii)
     x,        idt(ii),alat(ii),alon(ii),pres(ii),ht_ft(ii)
     x,        t_prcn(ii),ob_t(ii),xiv_t(ii),ichk_t(ii)
     x,        ob_q(ii),xiv_q(ii),ichk_q(ii)
     x,        ob_dir(ii),xiv_d(ii),ichk_d(ii)
     x,        ob_spd(ii),xiv_s(ii),ichk_s(ii),idp(ii)
 8001       format(i6,1x,a8,1x,a8,1x,a9,1x
     x,        i7,1x,2f11.5,1x,f8.1,1x,f7.0,1x
     x,        f5.2,4(2(1x,f8.2),1x,i5),1x,i4)
            iht_ft = imiss
          endif

          if(iht_ft.ge.0) then
            write(c_ht_ft,'(i6.6)') iht_ft
          else
            write(c_ht_ft,'(i6.5)') iht_ft
          endif
        endif
c
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
        if(alat(ii).eq.amiss) then
          c_lat = '99999'
        else
          ilat = nint(alat(ii)*100.)
          if(abs(ilat).ge.100 000) write(io8,*)'ilat too large--',ilat
          write(c_lat,'(i5)') ilat
        endif
c
        if(alon(ii).eq.amiss) then
          c_lon = '999999'
        else
          ilon = nint(alon(ii)*100.)
          if(abs(ilon).ge.1 000 000) write(io8,*)'ilon too large--',ilon
          write(c_lon,'(i6)') ilon
        endif
c
        c_type = c_insty_ob(itype(ii))
c
        csort(ii) = c_idt(1:6)
     $             //c_ht_ft(1:6)
cc     $             //c_ht_ft(1:5)
     $             //c_lat(1:5)
     $             //c_lon(1:6)
     $             //c_type(1:2)
      enddo
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
c
      write(io8,*)
ccccdak      write(io8,*) 'Number of raw acars reports      = ',knt_acars
      write(io8,*) 'Number of raw tamdar reports     = ',knt_acars
      write(io8,*) 'Number of raw mdcrs reports      = ',knt_mdcrs
      write(io8,*) 'Number of raw man_airep reports  = ',knt_man_airep
      write(io8,*) 'Number of raw man_Yairep reports = ',knt_man_Yairep
      write(io8,*) 'Number of raw airep reports      = ',knt_airep
      write(io8,*) 'Number of raw amdar reports      = ',knt_amdar
c
c Sort reports in file according to array csort
c ---------------------------------------------
      write(*,*) 'Sorting reports by time first'
      write(io8,*)
      write(io8,*) 'Sorting reports by time first'
      write(io8,*) '-----------------------------'
c
      if(l_pc) call p_ddtg('Calling INDEXC for the first sort',io8)
c
      call INDEXC(numreps_orig,csort,indx)
c
c     Output reports to log file if desired
c     -------------------------------------
      l_print = .false.
c
      if(l_print) then
        write(io8,*) 
        write(io8,*) 'Reports after first sort'
        write(io8,*) '------------------------'
        call pr_workdata(max_reps,numreps,indx
     x,      alat,alon,pres,ht_ft,idt,idp,c_acftreg,c_acftid,itype        
     x,      t_prcn,ob_t,ob_q,ob_dir,ob_spd
     x,      xiv_t,xiv_q,xiv_d,xiv_s,ichk_t,ichk_q,ichk_d,ichk_s
     x,      cdtg_an,c_qc,csort,io8)        
      endif
c
c Perform first pass through data--duplicate removal
c --------------------------------------------------
      write(*,*)'Beginning 1st pass through data--duplicate removal'
      write(io8,*)
      write(io8,*)'Beginning 1st pass through data--duplicate removal'
      write(io8,*)'----------------------------------------------------'
c
      if(l_pc) call p_ddtg('Calling dupchek_qc',io8)
c
      call dupchek_qc(numreps,max_reps,maxflt,htdif_same
     $,     c_acftreg,c_acftid,c_qc,cdtg_an
     $,     alat,alon,pres,ht_ft,t_prcn,ob_t,ob_q,ob_dir,ob_spd
     $,     xiv_t,xiv_q,xiv_d,xiv_s
     $,     idt,itype,ichk_t,ichk_q,ichk_d,ichk_s,kbadtot 
     $,     kreg,creg_reg,nobs_reg,nrej_reg,ntemp_reg,nwind_reg
     $,     indx,csort,amiss,imiss,io8,io30,l_last,l_operational,l_init
     $,     l_ncep,*199)
      go to 198
 199  continue
      print *, '----------------------------------------------------'
      print *, '~~~> maxflt_exceeded -- coming out of call to dupchk'
      print *, '----------------------------------------------------'
      maxflt_exceeded = 1
 198  continue
      kreg_max = kreg
      kreg_tot_max = kreg_tot
cppppp
cc    print *, 'after call to dupchek_qc kreg, kreg_tot: ',
cc   $ kreg, kreg_tot
cc    print *, 'kreg_max, kreg_tot_max: ',kreg_max, kreg_tot_max
cppppp
c
      if(l_pc) call p_ddtg('Back from dupchek_qc',io8)
c
c     Re-order index array to skip bad reports
c     ----------------------------------------
      l_flight = .false.
      l_print = .false.
      if(kbadtot.gt.0) then 
        call reorder(l_flight,numreps,max_reps,indx,krej,in_bad
     $,          io8,l_print,cregmiss,csort,c_acftid,itype
     $,          kflight,maxflt,cid_flt,creg_flt,nobs_flt,ntot_flt
     $,          nrej_flt,iobs_flt,cid_flt_old,ntot_flt_old,nrej_flt_old
     $,          kreg,creg_reg,nobs_reg,nrej_reg,c_acftreg,l_newflt)
        kflight_max = kflight
        kreg_max = max(kreg,kreg_max)
        kreg_tot_max = max(kreg_tot,kreg_tot_max)
cppppp
cc    print *, 'after call 1 to reorder kreg, kflight, kreg_tot: ',
cc   $ kreg, kflight, kreg_tot
cc    print *, 'kreg_max, kflight_max, kreg_tot_max: ',
cc   $ kreg_max, kflight_max, kreg_tot_max
cppppp

c
      endif
c
c     Output reports to log file if desired
c     -------------------------------------
      l_print = .false.
c
      if(l_print) then
        write(io8,*) 
        write(io8,*) 'Reports after duplicate removal'
        write(io8,*) '-------------------------------'
        call pr_workdata(max_reps,numreps,indx
     x,      alat,alon,pres,ht_ft,idt,idp,c_acftreg,c_acftid,itype        
     x,      t_prcn,ob_t,ob_q,ob_dir,ob_spd
     x,      xiv_t,xiv_q,xiv_d,xiv_s,ichk_t,ichk_q,ichk_d,ichk_s
     x,      cdtg_an,c_qc,csort,io8)        
      endif
c
c Generate master list of tail numbers and counts
c -----------------------------------------------
      if(l_pc) call p_ddtg('Setting up master list of tail numbers',io8)
c
      do mm=1,kreg
        l_found = .false.
c
        if(kreg_tot.ne.0) then
          do ii=1,kreg_tot
            if(creg_reg(mm)(1:8).eq.creg_reg_tot(ii)(1:8)) then
              if(.not.l_operational) then
          nobs_reg_tot(ii,1:5) = nobs_reg_tot(ii,1:5) + nobs_reg(mm,1:5)
                l_found = .true.
              endif
            endif
          enddo
        endif
c
        if(.not.l_found) then
          kreg_tot = kreg_tot + 1
          if(kreg_tot.gt.maxflt) then
c............................................................................................
            write(*,*) 'WARNING: kreg_tot > maxflt--',kreg_tot

c There are more flights in input file than "maxflt" -- stop abnormally with c. code 98
c  (can't be sure continuing on w/o processing any more data would turn out ok)
c --------------------------------------------------------------------------------------
            print 53, maxflt
   53 format(/' #####> WARNING: THERE ARE MORE THAN ',I6,' AIRCRAFT ',
     + '"FLIGHTS" IN INPUT FILE -- MUST INCREASE SIZE OF PARAMETER ',
     + 'NMAE "MAXFLT" - STOP 98'/)

            write(cmaxflt,'(i6)') maxflt
          call system('[ -n "$jlogfile" ] && $DATA/postmsg'//
     +     ' "$jlogfile" "***WARNING:'//cmaxflt//' AIRCRAFT "FLIGHT" '//
     +     'LIMIT EXCEEDED IN PREPOBS_PREPACQC, STOP 98"')

            call w3tage('PREPOBS_PREPACQC')
            call errexit(98)
c............................................................................................
          endif
          creg_reg_tot(kreg_tot)(1:8) = creg_reg(mm)(1:8)
c
          if(.not.l_operational) then
            nobs_reg_tot(kreg_tot,1:5) = nobs_reg(mm,1:5)
          endif
        endif
      enddo
c
      do mm=1,kreg
        do ii=1,kreg_tot
          if(creg_reg(mm)(1:8).eq.creg_reg_tot(ii)(1:8).and.
     $       creg_reg(mm).ne.'xxxxxxxx') then
c
            if(.not.l_operational) then
           ntemp_reg_tot(ii,1:5)=ntemp_reg_tot(ii,1:5)+ntemp_reg(mm,1:5)
           nwind_reg_tot(ii,1:5)=nwind_reg_tot(ii,1:5)+nwind_reg(mm,1:5)
              nrej_reg_tot(ii,1:5)=nrej_reg_tot(ii,1:5)+nrej_reg(mm,1:5)
            endif
c
            ntot_reg(mm,1:5)=ntot_reg(mm,1:5)+nrej_reg(mm,1:5)
          endif
        enddo
      enddo
c
c Output innovation distributions
c -------------------------------
      if(l_do_innov.and.(.not.l_operational)) then
c
        if(l_pc) call p_ddtg('Calling innov_qc',io8)
c
        call innov_qc(max_reps,numreps,indx,xiv_t,xiv_d,xiv_s,amiss,
     $                c_qc,1,io8,l_init,l_innov_miss)
      endif
c
c Examine first digit distribution for comparison with Benford's law
c Perform after duplicate check and before other QC checks
c ------------------------------------------------------------------
      if(l_do_innov.and.
     $   (.not.l_operational).and.
     $   (.not.l_innov_miss)) then
c
        if(l_pc) call p_ddtg('Calling benford_qc',io8)
c
        call benford_qc(max_reps,numreps,indx,xiv_t,xiv_d,xiv_s,amiss,
     $           c_acftreg,itype,maxflt,kreg_tot,creg_reg_tot,
     $           c_qc,lead_t_tot,lead_d_tot,lead_s_tot,
     $           n_xiv_t,n_xiv_d,n_xiv_s,
     $           sum_xiv_t,sum_xiv_d,sum_xiv_s,
     $           sumabs_xiv_t,sumabs_xiv_d,sumabs_xiv_s,1,io8
     $,          l_init,l_last)
        kflight_max = max(kflight,kflight_max)
        kreg_max = max(kreg,kreg_max)
        kreg_tot_max = max(kreg_tot,kreg_tot_max)
cppppp
cc    print *, 'after call 1 to benford_qc kreg, kflight, kreg_tot: ',
cc   $ kreg, kflight, kreg_tot
cc    print *, 'kreg_max, kflight_max, kreg_tot_max: ',
cc   $ kreg_max, kflight_max, kreg_tot_max
cppppp
      endif
c
c Perform second pass through data--spike check
c ---------------------------------------------
      write(*,*)'Beginning 2nd pass through data--spike check'
      write(io8,*)
      write(io8,*)'Beginning 2nd pass through data--spike check'
      write(io8,*)'--------------------------------------------'
c
      if(l_pc) call p_ddtg('Calling spike_qc',io8)
c
      call spike_qc(numreps,max_reps,c_acftreg,c_acftid,c_qc
     $,     alat,alon,pres,ht_ft,t_prcn,ob_t,ob_q,ob_dir,ob_spd
     $,     xiv_t,xiv_q,xiv_d,xiv_s,idt,itype,ichk_t,ichk_q
     $,     ichk_d,ichk_s,kbadtot,indx,csort,amiss,imiss,io8
     $,     io31,cdtg_an,l_operational,l_init)
c
      if(l_pc) call p_ddtg('Back from spike_qc',io8)
c
c     Re-order index array to skip bad reports
c     ----------------------------------------
      l_flight = .false.
      l_print = .false.
      if(kbadtot.gt.0) then 
        call reorder(l_flight,numreps,max_reps,indx,krej,in_bad
     $,          io8,l_print,cregmiss,csort,c_acftid,itype
     $,          kflight,maxflt,cid_flt,creg_flt,nobs_flt,ntot_flt
     $,          nrej_flt,iobs_flt,cid_flt_old,ntot_flt_old,nrej_flt_old
     $,          kreg,creg_reg,nobs_reg,nrej_reg,c_acftreg,l_newflt)
        kflight_max = max(kflight,kflight_max)
        kreg_max = max(kreg,kreg_max)
        kreg_tot_max = max(kreg_tot,kreg_tot_max)
cppppp
cc    print *, 'after call 2 to reorder kreg, kflight, kreg_tot: ',
cc   $ kreg, kflight, kreg_tot
cc    print *, 'kreg_max, kflight_max, kreg_tot_max: ',
cc   $ kreg_max, kflight_max, kreg_tot_max
cppppp
c
        do mm=1,kreg
          do ii=1,kreg_tot
            if(creg_reg(mm)(1:8).eq.creg_reg_tot(ii)(1:8).and.
     $         creg_reg(mm).ne.'xxxxxxxx') then

              if(.not.l_operational) then
              nrej_inv_tot(ii,1:5)=nrej_inv_tot(ii,1:5)+nrej_reg(mm,1:5)
              nrej_reg_tot(ii,1:5)=nrej_reg_tot(ii,1:5)+nrej_reg(mm,1:5)
              endif
c
              ntot_reg(mm,1:5)=ntot_reg(mm,1:5)+nrej_reg(mm,1:5)
            endif
          enddo
        enddo
      endif
c
c     Output reports to log file if desired
c     -------------------------------------
      l_print = .false.
c
      if(l_print) then
        write(io8,*) 
        write(io8,*) 'Reports after spike check'
        write(io8,*) '-------------------------'
        call pr_workdata(max_reps,numreps,indx
     x,      alat,alon,pres,ht_ft,idt,idp,c_acftreg,c_acftid,itype        
     x,      t_prcn,ob_t,ob_q,ob_dir,ob_spd
     x,      xiv_t,xiv_q,xiv_d,xiv_s,ichk_t,ichk_q,ichk_d,ichk_s
     x,      cdtg_an,c_qc,csort,io8)        
      endif
c
c Form variable to sort--flight number + time + level + type
c (second sort is to begin to form tracks)
c ----------------------------------------------------------
      write(io8,*)
      write(io8,*) 'Forming variable to sort--flight#+time+level+type'
      write(io8,*) '-------------------------------------------------'
c
      if(l_pc) call p_ddtg('Forming variable for second sort',io8)
c
      do iob=1,numreps
         ii = indx(iob)
c
c       Exclude previously rejected reports
c       -----------------------------------
        if(csort(ii)(1:5).eq.'badob') then
          csort(ii) = 'zzzzzzzzzzzzzzzzzzzzzzzzz'
c          write(io8,*) 'badob found for iob = ',iob,' ii = ',ii
c
        elseif(csort(ii).ne.'zzzzzzzzzzzzzzzzzzzzzzzzz') then
c
          kidt = idt(ii) + 100 000
          if(kidt.ge.1 000 000) write(io8,*) 'kidt too large--',kidt
          write(c_idt,'(i6)') kidt
c
          if(ht_ft(ii).eq.amiss) then
            c_ht_ft = '999999'
          else
            iht_ft = nint(ht_ft(ii)) + 100 000
            if(iht_ft.ge.200 000) then ! if nint(ht_ft(iob)) = 100,000 or greater
              write(io8,*) 'iht_ft too large--',iht_ft
              write (io8,8001) iob,c_insty_ob(itype(iob))
     x,          c_acftreg(iob),c_acftid(iob)
     x,          idt(iob),alat(iob),alon(iob),pres(iob),ht_ft(iob)
     x,          t_prcn(iob),ob_t(iob),xiv_t(iob),ichk_t(iob)
     x,          ob_q(iob),xiv_q(iob),ichk_q(iob)
     x,          ob_dir(iob),xiv_d(iob),ichk_d(iob)
     x,          ob_spd(iob),xiv_s(iob),ichk_s(iob),idp(iob)
              iht_ft = imiss
            endif

            if(iht_ft.ge.0) then
              write(c_ht_ft,'(i6.6)') iht_ft
            else
              write(c_ht_ft,'(i6.5)') iht_ft
            endif
          endif
c
          c_type = c_insty_ob(itype(ii))
c
          csort(ii) = c_acftid(ii)(1:9)
     $              //c_idt(1:6)
     $              //c_ht_ft(1:6)
     $              //c_type(1:2)
     $              //'  '
        endif
      enddo
c
c Sort reports in file according to array csort
c ---------------------------------------------
      write(*,*) 'Sorting reports by flight number first'
      write(io8,*)
      write(io8,*) 'Sorting reports by flight number first'
      write(io8,*) '--------------------------------------'
c
      if(l_pc) call p_ddtg('Calling INDEXC for second sort',io8)
c
      call INDEXC(numreps_orig,csort,indx)
c
c     Output reports to log file if desired
c     -------------------------------------
      l_print = .false.
c
      if(l_print) then
        write(io8,*) 
        write(io8,*) 'Reports after second sort'
        write(io8,*) '-------------------------'
        call pr_workdata(max_reps,numreps,indx
     x,      alat,alon,pres,ht_ft,idt,idp,c_acftreg,c_acftid,itype
     x,      t_prcn,ob_t,ob_q,ob_dir,ob_spd
     x,      xiv_t,xiv_q,xiv_d,xiv_s,ichk_t,ichk_q,ichk_d,ichk_s
     x,      cdtg_an,c_qc,csort,io8)        
      endif
c
c Determine starting index for each flight and number of reports per flight
c -------------------------------------------------------------------------
      write(*,*) 'Determine starting index/length for each flight'
      write(io8,*)
      write(io8,*) 'Determine starting index/length for each flight'
      write(io8,*) '-----------------------------------------------'
c
      if(l_pc) call p_ddtg('Calling do_flt',io8)
c
      l_first = .true.
      l_print = .false.
      call do_flt(l_first,numreps,max_reps,c_acftid,c_acftreg,idt,
     $           ht_ft,cidmiss,cregmiss,indx,idt_samflt,
     $           kflight,maxflt,cid_flt,creg_flt,nobs_flt,ntot_flt,
     $           nrej_flt,iobs_flt,csort,l_sort,l_print,amiss,io8,*299)
      go to 298
 299  continue
      print *, '-------------------------------------------------------'
      print *, '~~~> maxflt_exceeded -- coming out of call #1 to do_flt'
      print *, '-------------------------------------------------------'
      maxflt_exceeded = 1
 298  continue
      kflight_max = max(kflight,kflight_max)
      kreg_max = max(kreg,kreg_max)
      kreg_tot_max = max(kreg_tot,kreg_tot_max)
cppppp
cc    print *, 'after call 1 to do_flt kreg, kflight, kreg_tot: ',
cc   $ kreg, kflight, kreg_tot
cc    print *, 'kreg_max, kflight_max, kreg_tot_max: ',
cc   $ kreg_max, kflight_max, kreg_tot_max
cppppp
c
c     Re-sort if flight number with two tail numbers was found
c     --------------------------------------------------------
      if(l_sort) then
c
        write(*,*) 'Re-sorting reports by flight number first'
        write(io8,*)
        write(io8,*) 'Re-sorting reports by flight number first'
        write(io8,*) '-----------------------------------------'
c
        if(l_pc) call p_ddtg('Calling INDEXC to redo second sort',io8)
c
      call INDEXC(numreps_orig,csort,indx)
c
c       Redo starting index for each flight and number of reports per flight
c       --------------------------------------------------------------------
        if(l_pc) call p_ddtg('Calling do_flt after re-sort',io8)
c
        l_first = .false.
        l_print = .false.
        call do_flt(l_first,numreps,max_reps,c_acftid,c_acftreg,idt,
     $           ht_ft,cidmiss,cregmiss,indx,idt_samflt,
     $           kflight,maxflt,cid_flt,creg_flt,nobs_flt,ntot_flt,
     $           nrej_flt,iobs_flt,csort,l_sort,l_print,amiss,io8,*399)
        go to 398
 399    continue
      print *, '-------------------------------------------------------'
      print *, '~~~> maxflt_exceeded -- coming out of call #2 to do_flt'
      print *, '-------------------------------------------------------'
        maxflt_exceeded = 1
 398    continue
        kflight_max = max(kflight,kflight_max)
        kreg_max = max(kreg,kreg_max)
        kreg_tot_max = max(kreg_tot,kreg_tot_max)
cppppp
cc    print *, 'after call 2 to do_flt kreg, kflight, kreg_tot: ',
cc   $ kreg, kflight, kreg_tot
cc    print *, 'kreg_max, kflight_max, kreg_tot_max: ',
cc   $ kreg_max, kflight_max, kreg_tot_max
cppppp
c
c       Output reports to log file if desired
c       -------------------------------------
c DAK: may want to set l_print=F below to save time and space in prod runs
        l_print = .true.
c
        if(l_print) then
          write(io8,*) 
          write(io8,*) 'Reports after re-sort'
          write(io8,*) '---------------------'
          call pr_workdata(max_reps,numreps,indx
     x,      alat,alon,pres,ht_ft,idt,idp,c_acftreg,c_acftid,itype        
     x,      t_prcn,ob_t,ob_q,ob_dir,ob_spd
     x,      xiv_t,xiv_q,xiv_d,xiv_s,ichk_t,ichk_q,ichk_d,ichk_s
     x,      cdtg_an,c_qc,csort,io8)        
        endif
      endif
c
c Perform third pass through data--invalid data check
c ---------------------------------------------------
      write(*,*)'Beginning 3rd pass through data--invalid data check'
      write(io8,*)
      write(io8,*)'Beginning 3rd pass through data--invalid data check'
      write(io8,*)'---------------------------------------------------'
c
      if(l_pc) call p_ddtg('Calling invalid_qc',io8)
c
      call invalid_qc(numreps,max_reps,c_acftreg,c_acftid,c_qc
     $,     alat,alon,pres,ht_ft,t_prcn,ob_t,ob_q,ob_dir,ob_spd
     $,     xiv_t,xiv_q,xiv_d,xiv_s,maxflt,kreg,creg_reg,ntemp_reg
     $,     idt,itype,ichk_t,ichk_q,ichk_d,ichk_s,kbadtot,n_minus9C 
     $,     indx,csort,amiss,imiss,io8,io32,l_operational,l_init
     $,     cdtg_an,l_minus9c)
      kflight_max = max(kflight,kflight_max)
      kreg_max = max(kreg,kreg_max)
      kreg_tot_max = max(kreg_tot,kreg_tot_max)
cppppp
cc    print *, 'after call to invalid_qc kreg, kflight, kreg_tot: ',
cc   $ kreg, kflight, kreg_tot
cc    print *, 'kreg_max, kflight_max, kreg_tot_max: ',
cc   $ kreg_max, kflight_max, kreg_tot_max
cppppp
c
      if(l_pc) call p_ddtg('Back from invalid_qc',io8)
c
c     Re-order index array to skip bad reports
c     ----------------------------------------
      l_flight = .true.
      l_print = .true.
      if(kbadtot.gt.0) then 
        call reorder(l_flight,numreps,max_reps,indx,krej,in_bad
     $,          io8,l_print,cregmiss,csort,c_acftid,itype
     $,          kflight,maxflt,cid_flt,creg_flt,nobs_flt,ntot_flt
     $,          nrej_flt,iobs_flt,cid_flt_old,ntot_flt_old,nrej_flt_old
     $,          kreg,creg_reg,nobs_reg,nrej_reg,c_acftreg,l_newflt)
        kflight_max = max(kflight,kflight_max)
        kreg_max = max(kreg,kreg_max)
        kreg_tot_max = max(kreg_tot,kreg_tot_max)
cppppp
cc    print *, 'after call 3 to reorder kreg, kflight, kreg_tot: ',
cc   $ kreg, kflight, kreg_tot
cc    print *, 'kreg_max, kflight_max, kreg_tot_max: ',
cc   $ kreg_max, kflight_max, kreg_tot_max
cppppp
c
        do mm=1,kreg
          do ii=1,kreg_tot
            if(creg_reg(mm)(1:8).eq.creg_reg_tot(ii)(1:8).and.
     $         creg_reg(mm).ne.'xxxxxxxx') then

              if(.not.l_operational) then
              nrej_inv_tot(ii,1:5)=nrej_inv_tot(ii,1:5)+nrej_reg(mm,1:5)
              nrej_reg_tot(ii,1:5)=nrej_reg_tot(ii,1:5)+nrej_reg(mm,1:5)
              endif
c
              ntot_reg(mm,1:5)=ntot_reg(mm,1:5)+nrej_reg(mm,1:5)
            endif
          enddo
        enddo
      endif
c
      if(.not.l_operational) then
        do mm=1,kreg
          do ii=1,kreg_tot
            if(creg_reg(mm)(1:8).eq.creg_reg_tot(ii)(1:8).and.
     $         creg_reg(mm).ne.'xxxxxxxx') then
           ntemp_reg_tot(ii,1:5)=ntemp_reg_tot(ii,1:5)+ntemp_reg(mm,1:5)
            endif
          enddo
        enddo
      endif
c
c     Output reports to log file if desired
c     -------------------------------------
      l_print = .false.
c
      if(l_print) then
        write(io8,*) 
        write(io8,*) 'Reports after invalid data check'
        write(io8,*) '--------------------------------'
        call pr_workdata(max_reps,numreps,indx
     x,      alat,alon,pres,ht_ft,idt,idp,c_acftreg,c_acftid,itype        
     x,      t_prcn,ob_t,ob_q,ob_dir,ob_spd
     x,      xiv_t,xiv_q,xiv_d,xiv_s,ichk_t,ichk_q,ichk_d,ichk_s
     x,      cdtg_an,c_qc,csort,io8)        
      endif
c
c Perform fourth pass through data--reports with stuck values
c ----------------------------------------------------------
      write(*,*) 'Beginning 4th pass through data--stuck values'
      write(io8,*)
      write(io8,*) 'Beginning 4th pass through data--stuck values'
      write(io8,*) '---------------------------------------------'
c
      if(l_pc) call p_ddtg('Calling stk_val_qc',io8)
c
      call stk_val_qc(numreps,max_reps,indx,csort,amiss,cdtg_an
     $,          c_acftreg,c_acftid,c_qc
     $,          alat,alon,pres,ht_ft,t_prcn,ob_t,ob_q,ob_dir,ob_spd
     $,          xiv_t,xiv_q,xiv_d,xiv_s
     $,          idt,itype,ichk_t,ichk_q,ichk_d,ichk_s
     $,          kflight,maxflt,nobs_flt,iobs_flt
     $,          kreg,creg_reg,nwhol_reg,ntemp_reg,nwind_reg
     $,          kbadtot,io8,io33,l_operational,l_init,l_ncep)
      kflight_max = max(kflight,kflight_max)
      kreg_max = max(kreg,kreg_max)
      kreg_tot_max = max(kreg_tot,kreg_tot_max)
cppppp
cc    print *, 'after call to stk_val_qc kreg, kflight, kreg_tot: ',
cc   $ kreg, kflight, kreg_tot
cc    print *, 'kreg_max, kflight_max, kreg_tot_max: ',
cc   $ kreg_max, kflight_max, kreg_tot_max
cppppp
c
      if(l_pc) call p_ddtg('Back from stk_val_qc',io8)
c
c     Re-order index array to skip bad reports
c     ----------------------------------------
      l_flight = .true.
      l_print = .true.
      if(kbadtot.gt.0) then 
        call reorder(l_flight,numreps,max_reps,indx,krej,in_bad
     $,          io8,l_print,cregmiss,csort,c_acftid,itype
     $,          kflight,maxflt,cid_flt,creg_flt,nobs_flt,ntot_flt
     $,          nrej_flt,iobs_flt,cid_flt_old,ntot_flt_old,nrej_flt_old
     $,          kreg,creg_reg,nobs_reg,nrej_reg,c_acftreg,l_newflt)
        kflight_max = max(kflight,kflight_max)
        kreg_max = max(kreg,kreg_max)
        kreg_tot_max = max(kreg_tot,kreg_tot_max)
cppppp
cc    print *, 'after call 4 to reorder kreg, kflight, kreg_tot: ',
cc   $ kreg, kflight, kreg_tot
cc    print *, 'kreg_max, kflight_max, kreg_tot_max: ',
cc   $ kreg_max, kflight_max, kreg_tot_max
cppppp
c
        do mm=1,kreg
          do ii=1,kreg_tot
            if(creg_reg(mm)(1:8).eq.creg_reg_tot(ii)(1:8).and.
     $         creg_reg(mm).ne.'xxxxxxxx') then
c
              if(.not.l_operational) then
              nrej_stk_tot(ii,1:5)=nrej_stk_tot(ii,1:5)+nrej_reg(mm,1:5)
              nrej_reg_tot(ii,1:5)=nrej_reg_tot(ii,1:5)+nrej_reg(mm,1:5)
              endif
c
              ntot_reg(mm,1:5)=ntot_reg(mm,1:5)+nrej_reg(mm,1:5)
            endif
          enddo
        enddo
      endif
c
      if(.not.l_operational) then
        do mm=1,kreg
          do ii=1,kreg_tot
            if(creg_reg(mm)(1:8).eq.creg_reg_tot(ii)(1:8).and.
     $         creg_reg(mm).ne.'xxxxxxxx') then
           nwhol_reg_tot(ii,1:5)=nwhol_reg_tot(ii,1:5)+nwhol_reg(mm,1:5)
           ntemp_reg_tot(ii,1:5)=ntemp_reg_tot(ii,1:5)+ntemp_reg(mm,1:5)
           nwind_reg_tot(ii,1:5)=nwind_reg_tot(ii,1:5)+nwind_reg(mm,1:5)
            endif
          enddo
        enddo
      endif
c
c     Output reports to log file if desired
c     -------------------------------------
      l_print = .false.
c
      if(l_print) then
        write(io8,*) 
        write(io8,*) 'Reports after stuck value check'
        write(io8,*) '-------------------------------'
        call pr_workdata(max_reps,numreps,indx
     x,      alat,alon,pres,ht_ft,idt,idp,c_acftreg,c_acftid,itype
     x,      t_prcn,ob_t,ob_q,ob_dir,ob_spd
     x,      xiv_t,xiv_q,xiv_d,xiv_s,ichk_t,ichk_q,ichk_d,ichk_s
     x,      cdtg_an,c_qc,csort,io8)        
      endif
c
c Perform fifth pass through data--gross checks
c ---------------------------------------------
      write(*,*) 'Beginning 5th pass through data--gross checks'
      write(io8,*)
      write(io8,*) 'Beginning 5th pass through data--gross checks'
      write(io8,*) '---------------------------------------------'
c
      if(l_pc) call p_ddtg('Calling grchek_qc',io8)
c
      call grchek_qc(numreps,max_reps,indx,csort,amiss,cdtg_an
     $,          c_acftreg,c_acftid,c_qc
     $,          alat,alon,pres,ht_ft,t_prcn,ob_t,ob_q,ob_dir,ob_spd
     $,          xiv_t,xiv_q,xiv_d,xiv_s
     $,          idt,itype,ichk_t,ichk_q,ichk_d,ichk_s
     $,          cbadtemp,nbadtemp
     $,          cblkwind,nblkwind,cblktemp,nblktemp,kbadtot,io8,io34
     $,          maxflt,kreg,creg_reg,nwhol_reg,nwind_reg
     $,          ft2m,l_operational,l_init)
      kflight_max = max(kflight,kflight_max)
      kreg_max = max(kreg,kreg_max)
      kreg_tot_max = max(kreg_tot,kreg_tot_max)
cppppp
cc    print *, 'after call to grchek_qc kreg, kflight, kreg_tot: ',
cc   $ kreg, kflight, kreg_tot
cc    print *, 'kreg_max, kflight_max, kreg_tot_max: ',
cc   $ kreg_max, kflight_max, kreg_tot_max
cppppp
c
      if(l_pc) call p_ddtg('Back from grchek_qc',io8)
c
c     Re-order index array to skip bad reports
c     ----------------------------------------
      l_flight = .true.
      l_print = .true.
      if(kbadtot.gt.0) then 
        call reorder(l_flight,numreps,max_reps,indx,krej,in_bad
     $,          io8,l_print,cregmiss,csort,c_acftid,itype
     $,          kflight,maxflt,cid_flt,creg_flt,nobs_flt,ntot_flt
     $,          nrej_flt,iobs_flt,cid_flt_old,ntot_flt_old,nrej_flt_old
     $,          kreg,creg_reg,nobs_reg,nrej_reg,c_acftreg,l_newflt)
        kflight_max = max(kflight,kflight_max)
        kreg_max = max(kreg,kreg_max)
        kreg_tot_max = max(kreg_tot,kreg_tot_max)
cppppp
cc    print *, 'after call 5 to reorder kreg, kflight, kreg_tot: ',
cc   $ kreg, kflight, kreg_tot
cc    print *, 'kreg_max, kflight_max, kreg_tot_max: ',
cc   $ kreg_max, kflight_max, kreg_tot_max
cppppp
c
        do mm=1,kreg
          do ii=1,kreg_tot
            if(creg_reg(mm)(1:8).eq.creg_reg_tot(ii)(1:8).and.
     $         creg_reg(mm).ne.'xxxxxxxx') then

              if(.not.l_operational) then
              nrej_grc_tot(ii,1:5)=nrej_grc_tot(ii,1:5)+nrej_reg(mm,1:5)
              nrej_reg_tot(ii,1:5)=nrej_reg_tot(ii,1:5)+nrej_reg(mm,1:5)
              endif
c
              ntot_reg(mm,1:5)=ntot_reg(mm,1:5)+nrej_reg(mm,1:5)
            endif
          enddo
        enddo
      endif
c
      if(.not.l_operational) then
        do mm=1,kreg
          do ii=1,kreg_tot
            if(creg_reg(mm)(1:8).eq.creg_reg_tot(ii)(1:8).and.
     $         creg_reg(mm).ne.'xxxxxxxx') then
           nwhol_reg_tot(ii,1:5)=nwhol_reg_tot(ii,1:5)+nwhol_reg(mm,1:5)
           nwind_reg_tot(ii,1:5)=nwind_reg_tot(ii,1:5)+nwind_reg(mm,1:5)
            endif
          enddo
        enddo
      endif
c
c     Output reports to log file if desired
c     -------------------------------------
      l_print = .false.
c
      if(l_print) then
        write(io8,*) 
        write(io8,*) 'Reports after gross check'
        write(io8,*) '-------------------------'
        call pr_workdata(max_reps,numreps,indx
     x,      alat,alon,pres,ht_ft,idt,idp,c_acftreg,c_acftid,itype        
     x,      t_prcn,ob_t,ob_q,ob_dir,ob_spd
     x,      xiv_t,xiv_q,xiv_d,xiv_s,ichk_t,ichk_q,ichk_d,ichk_s
     x,      cdtg_an,c_qc,csort,io8)        
      endif
c
c Perform six pass through data 
c Check for inconsistent altitudes or positions in duplicates
c -----------------------------------------------------------
      write(*,*) 'Beginning 6th pass through data--inconsistent posn'
      write(io8,*)
      write(io8,*) 'Beginning 6th pass through data--inconsistent posn'
      write(io8,*) '--------------------------------------------------'
c
      if(l_pc) call p_ddtg('Calling poschek_qc',io8)
c
      call poschek_qc(numreps,max_reps,indx,csort,imiss,amiss
     $,          idt_updn,c_acftreg,c_acftid,cidmiss,c_qc,cdtg_an
     $,          alat,alon,pres,ht_ft,t_prcn,ob_t,ob_q,ob_dir,ob_spd
     $,          xiv_t,xiv_q,xiv_d,xiv_s
     $,          idt,itype,ichk_t,ichk_q,ichk_d,ichk_s
     $,          kflight,maxflt,nobs_flt,iobs_flt,kbadtot,io8,io35
     $,          l_operational,l_init)
      kflight_max = max(kflight,kflight_max)
      kreg_max = max(kreg,kreg_max)
      kreg_tot_max = max(kreg_tot,kreg_tot_max)
cppppp
cc    print *, 'after call to poschek_qc kreg, kflight, kreg_tot: ',
cc   $ kreg, kflight, kreg_tot
cc    print *, 'kreg_max, kflight_max, kreg_tot_max: ',
cc   $ kreg_max, kflight_max, kreg_tot_max
cppppp
c
      if(l_pc) call p_ddtg('Back from poschek_qc',io8)
c
c     Re-order index array to skip bad reports
c     ----------------------------------------
      l_flight = .true.
      l_print = .true.
      if(kbadtot.gt.0) then  
        call reorder(l_flight,numreps,max_reps,indx,krej,in_bad
     $,          io8,l_print,cregmiss,csort,c_acftid,itype
     $,          kflight,maxflt,cid_flt,creg_flt,nobs_flt,ntot_flt
     $,          nrej_flt,iobs_flt,cid_flt_old,ntot_flt_old,nrej_flt_old
     $,          kreg,creg_reg,nobs_reg,nrej_reg,c_acftreg,l_newflt)
        kflight_max = max(kflight,kflight_max)
        kreg_max = max(kreg,kreg_max)
        kreg_tot_max = max(kreg_tot,kreg_tot_max)
cppppp
cc    print *, 'after call 6 to reorder kreg, kflight, kreg_tot: ',
cc   $ kreg, kflight, kreg_tot
cc    print *, 'kreg_max, kflight_max, kreg_tot_max: ',
cc   $ kreg_max, kflight_max, kreg_tot_max
cppppp
c
        do mm=1,kreg
          do ii=1,kreg_tot
            if(creg_reg(mm)(1:8).eq.creg_reg_tot(ii)(1:8).and.
     $         creg_reg(mm).ne.'xxxxxxxx') then
c
              if(.not.l_operational) then
              nrej_pos_tot(ii,1:5)=nrej_pos_tot(ii,1:5)+nrej_reg(mm,1:5)
              nrej_reg_tot(ii,1:5)=nrej_reg_tot(ii,1:5)+nrej_reg(mm,1:5)
              endif
c
              ntot_reg(mm,1:5)=ntot_reg(mm,1:5)+nrej_reg(mm,1:5)
            endif
          enddo
        enddo
      endif
c
c     Output reports to log file if desired
c     -------------------------------------
      l_print = .false.
c
      if(l_print) then
        write(io8,*) 
        write(io8,*) 'Reports after inconsistent position check'
        write(io8,*) '-----------------------------------------'
        call pr_workdata(max_reps,numreps,indx
     x,      alat,alon,pres,ht_ft,idt,idp,c_acftreg,c_acftid,itype        
     x,      t_prcn,ob_t,ob_q,ob_dir,ob_spd
     x,      xiv_t,xiv_q,xiv_d,xiv_s,ichk_t,ichk_q,ichk_d,ichk_s
     x,      cdtg_an,c_qc,csort,io8)        
      endif
c
c Check ordering of near-duplicate reports
c ----------------------------------------
      write(io8,*)
      write(io8,*) 'Check ordering of near-duplicates'
      write(io8,*) '---------------------------------'
c
      if(l_pc) call p_ddtg('Calling orddup_qc',io8)
c
      call orddup_qc(max_reps,indx,isave,ht_ft,idt,alat,alon
     $,              kflight,maxflt,nobs_flt,iobs_flt
     $,              c_acftreg,c_acftid,cidmiss,idt_near,io8)
      kflight_max = max(kflight,kflight_max)
      kreg_max = max(kreg,kreg_max)
      kreg_tot_max = max(kreg_tot,kreg_tot_max)
cppppp
cc    print *, 'after call to orddup_qc kreg, kflight, kreg_tot: ',
cc   $ kreg, kflight, kreg_tot
cc    print *, 'kreg_max, kflight_max, kreg_tot_max: ',
cc   $ kreg_max, kflight_max, kreg_tot_max
cppppp
c
      if(l_pc) call p_ddtg('Back from orddup_qc',io8)
c
c     Output reports to log file if desired
c     -------------------------------------
      l_print = .false.
c
      if(l_print) then
        write(io8,*) 
        write(io8,*) 'Reports after check of near-dup ordering'
        write(io8,*) '----------------------------------------'
        call pr_workdata(max_reps,numreps,indx
     x,      alat,alon,pres,ht_ft,idt,idp,c_acftreg,c_acftid,itype        
     x,      t_prcn,ob_t,ob_q,ob_dir,ob_spd
     x,      xiv_t,xiv_q,xiv_d,xiv_s,ichk_t,ichk_q,ichk_d,ichk_s
     x,      cdtg_an,c_qc,csort,io8)        
        endif
c
c Perform seventh pass through data--check ordering of flights 
c ------------------------------------------------------------
      write(*,*) 'Beginning 7th pass through data--ordering check'
      write(io8,*)
      write(io8,*) 'Beginning 7th pass through data--ordering check'
      write(io8,*) '-----------------------------------------------'
c
      if(l_pc) call p_ddtg('Calling ordchek_qc',io8)
c
      call ordchek_qc(numreps,max_reps,indx,csort,imiss,amiss,idt_near
     $,          idt_updn,htdif_same,c_acftreg,c_acftid,cidmiss,c_qc
     $,          alat,alon,pres,ht_ft,t_prcn,ob_t,ob_q,ob_dir,ob_spd
     $,          xiv_t,xiv_q,xiv_d,xiv_s
     $,          idt,itype,ichk_t,ichk_q,ichk_d,ichk_s
     $,          kreg,creg_reg,nwind_reg
     $,          kflight,maxflt,nobs_flt,ntot_flt,iobs_flt,kbadtot
     $,          io8,io36,l_operational,l_init)
      kflight_max = max(kflight,kflight_max)
      kreg_max = max(kreg,kreg_max)
      kreg_tot_max = max(kreg_tot,kreg_tot_max)
cppppp
cc    print *, 'after call to ordchek_qc kreg, kflight, kreg_tot: ',
cc   $ kreg, kflight, kreg_tot
cc    print *, 'kreg_max, kflight_max, kreg_tot_max: ',
cc   $ kreg_max, kflight_max, kreg_tot_max
cppppp
c
      if(l_pc) call p_ddtg('Back from ordchek_qc',io8)
c
c     Re-order index array to skip bad reports
c     ----------------------------------------
      l_flight = .true.
      l_print = .true.
      if(kbadtot.gt.0) then  
        call reorder(l_flight,numreps,max_reps,indx,krej,in_bad
     $,          io8,l_print,cregmiss,csort,c_acftid,itype
     $,          kflight,maxflt,cid_flt,creg_flt,nobs_flt,ntot_flt
     $,          nrej_flt,iobs_flt,cid_flt_old,ntot_flt_old,nrej_flt_old
     $,          kreg,creg_reg,nobs_reg,nrej_reg,c_acftreg,l_newflt)
        kflight_max = max(kflight,kflight_max)
        kreg_max = max(kreg,kreg_max)
        kreg_tot_max = max(kreg_tot,kreg_tot_max)
cppppp
cc    print *, 'after call 7 to reorder kreg, kflight, kreg_tot: ',
cc   $ kreg, kflight, kreg_tot
cc    print *, 'kreg_max, kflight_max, kreg_tot_max: ',
cc   $ kreg_max, kflight_max, kreg_tot_max
cppppp
c
        do mm=1,kreg
          do ii=1,kreg_tot
            if(creg_reg(mm)(1:8).eq.creg_reg_tot(ii)(1:8).and.
     $         creg_reg(mm).ne.'xxxxxxxx') then
c
              if(.not.l_operational) then
              nrej_ord_tot(ii,1:5)=nrej_ord_tot(ii,1:5)+nrej_reg(mm,1:5)
              nrej_reg_tot(ii,1:5)=nrej_reg_tot(ii,1:5)+nrej_reg(mm,1:5)
              endif
c
              ntot_reg(mm,1:5)=ntot_reg(mm,1:5)+nrej_reg(mm,1:5)
            endif
          enddo
        enddo
      endif
c
      if(.not.l_operational) then
        do mm=1,kreg
          do ii=1,kreg_tot
            if(creg_reg(mm)(1:8).eq.creg_reg_tot(ii)(1:8).and.
     $         creg_reg(mm).ne.'xxxxxxxx') then
           nwind_reg_tot(ii,1:5)=nwind_reg_tot(ii,1:5)+nwind_reg(mm,1:5)
            endif
          enddo
        enddo
      endif
c
c     Output reports to log file if desired
c     -------------------------------------
      l_print = .false.
c
      if(l_print) then
        write(io8,*) 
        write(io8,*) 'Reports after ordering check'
        write(io8,*) '----------------------------'
        call pr_workdata(max_reps,numreps,indx
     x,      alat,alon,pres,ht_ft,idt,idp,c_acftreg,c_acftid,itype        
     x,      t_prcn,ob_t,ob_q,ob_dir,ob_spd
     x,      xiv_t,xiv_q,xiv_d,xiv_s,ichk_t,ichk_q,ichk_d,ichk_s
     x,      cdtg_an,c_qc,csort,io8)        
      endif
c
c Perform eighth pass through data--suspect data check
c ----------------------------------------------------
      write(*,*) 'Beginning 8th pass through data--suspect check'
      write(io8,*)
      write(io8,*) 'Beginning 8th pass through data--suspect check'
      write(io8,*) '----------------------------------------------'
c
c     Re-examine data flagged as suspect
c     ----------------------------------
      if(l_pc) call p_ddtg('Calling suspect_qc',io8)
c
      call suspect_qc(numreps,max_reps,indx,csort,imiss,idt_near,amiss
     $,          c_acftreg,c_acftid,c_qc
     $,          alat,alon,pres,ht_ft,t_prcn,ob_t,ob_q,ob_dir,ob_spd
     $,          xiv_t,xiv_q,xiv_d,xiv_s
     $,          idt,itype,ichk_t,ichk_q,ichk_d,ichk_s
     $,          maxflt,kflight,creg_flt,nobs_flt,ntot_flt
     $,          nrej_flt,iobs_flt,kreg,creg_reg,nobs_reg,nwind_reg
     $,          ntot_reg,kbadtot,io8,io37,l_operational,l_init)
      kflight_max = max(kflight,kflight_max)
      kreg_max = max(kreg,kreg_max)
      kreg_tot_max = max(kreg_tot,kreg_tot_max)
cppppp
cc    print *, 'after call to suspect_qc kreg, kflight, kreg_tot: ',
cc   $ kreg, kflight, kreg_tot
cc    print *, 'kreg_max, kflight_max, kreg_tot_max: ',
cc   $ kreg_max, kflight_max, kreg_tot_max
cppppp
c
      if(l_pc) call p_ddtg('Back from suspect_qc',io8)
c
c     Re-order index array to skip bad reports
c     ----------------------------------------
      l_flight = .true.
      l_print = .true.
      if(kbadtot.gt.0) then 
        call reorder(l_flight,numreps,max_reps,indx,krej,in_bad
     $,          io8,l_print,cregmiss,csort,c_acftid,itype
     $,          kflight,maxflt,cid_flt,creg_flt,nobs_flt,ntot_flt
     $,          nrej_flt,iobs_flt,cid_flt_old,ntot_flt_old,nrej_flt_old
     $,          kreg,creg_reg,nobs_reg,nrej_reg,c_acftreg,l_newflt)
        kflight_max = max(kflight,kflight_max)
        kreg_max = max(kreg,kreg_max)
        kreg_tot_max = max(kreg_tot,kreg_tot_max)
cppppp
cc    print *, 'after call 8 to reorder kreg, kflight, kreg_tot: ',
cc   $ kreg, kflight, kreg_tot
cc    print *, 'kreg_max, kflight_max, kreg_tot_max: ',
cc   $ kreg_max, kflight_max, kreg_tot_max
cppppp
c
        do mm=1,kreg
          do ii=1,kreg_tot
            if(creg_reg(mm)(1:8).eq.creg_reg_tot(ii)(1:8).and.
     $         creg_reg(mm).ne.'xxxxxxxx') then
c
              if(.not.l_operational) then
              nrej_sus_tot(ii,1:5)=nrej_sus_tot(ii,1:5)+nrej_reg(mm,1:5)
              nrej_reg_tot(ii,1:5)=nrej_reg_tot(ii,1:5)+nrej_reg(mm,1:5)
              endif
c
              ntot_reg(mm,1:5)=ntot_reg(mm,1:5)+nrej_reg(mm,1:5)
            endif
          enddo
        enddo
      endif
c
      if(.not.l_operational) then
        do mm=1,kreg
          do ii=1,kreg_tot
            if(creg_reg(mm)(1:8).eq.creg_reg_tot(ii)(1:8).and.
     $         creg_reg(mm).ne.'xxxxxxxx') then
           nwind_reg_tot(ii,1:5)=nwind_reg_tot(ii,1:5)+nwind_reg(mm,1:5)
            endif
          enddo
        enddo
      endif
c
c     Output reports to log file if desired
c     -------------------------------------
      l_print = .false.
c
      if(l_print) then
        write(io8,*) 
        write(io8,*) 'Reports after suspect data check'
        write(io8,*) '--------------------------------'
        call pr_workdata(max_reps,numreps,indx
     x,      alat,alon,pres,ht_ft,idt,idp,c_acftreg,c_acftid,itype        
     x,      t_prcn,ob_t,ob_q,ob_dir,ob_spd
     x,      xiv_t,xiv_q,xiv_d,xiv_s,ichk_t,ichk_q,ichk_d,ichk_s
     x,      cdtg_an,c_qc,csort,io8)        
      endif
c
c Perform ninth pass through data--reject list check
c --------------------------------------------------
      write(*,*) 'Beginning 9th pass through data--reject list check'
      write(io8,*)
      write(io8,*) 'Beginning 9th pass through data--reject list check'
      write(io8,*) '--------------------------------------------------'
c
      if(l_pc) call p_ddtg('Calling rejlist_qc',io8)
c
      call rejlist_qc(numreps,max_reps,indx,csort
     $,          c_acftreg,c_acftid,c_qc
     $,          alat,alon,pres,ht_ft,t_prcn,ob_t,ob_q,ob_dir,ob_spd
     $,          xiv_t,xiv_q,xiv_d,xiv_s
     $,          idt,itype,ichk_t,ichk_q,ichk_d,ichk_s
     $,          nchk_t,nchk_q,nchk_d,nchk_s
     $,          maxflt,kreg,creg_reg,nwind_reg,ntemp_reg
     $,          kbadtot,io8,io38,l_operational,l_init,l_ncep)
      kflight_max = max(kflight,kflight_max)
      kreg_max = max(kreg,kreg_max)
      kreg_tot_max = max(kreg_tot,kreg_tot_max)
cppppp
cc    print *, 'after call to rejlist_qc kreg, kflight, kreg_tot: ',
cc   $ kreg, kflight, kreg_tot
cc    print *, 'kreg_max, kflight_max, kreg_tot_max: ',
cc   $ kreg_max, kflight_max, kreg_tot_max
cppppp
c
      if(l_pc) call p_ddtg('Back from rejlist_qc',io8)
c
c     Re-order index array to skip bad reports
c     ----------------------------------------
      l_flight = .true.
      l_print = .true.
      if(kbadtot.gt.0) then 
        call reorder(l_flight,numreps,max_reps,indx,krej,in_bad
     $,          io8,l_print,cregmiss,csort,c_acftid,itype
     $,          kflight,maxflt,cid_flt,creg_flt,nobs_flt,ntot_flt
     $,          nrej_flt,iobs_flt,cid_flt_old,ntot_flt_old,nrej_flt_old
     $,          kreg,creg_reg,nobs_reg,nrej_reg,c_acftreg,l_newflt)
        kflight_max = max(kflight,kflight_max)
        kreg_max = max(kreg,kreg_max)
        kreg_tot_max = max(kreg_tot,kreg_tot_max)
cppppp
cc    print *, 'after call 9 to reorder kreg, kflight, kreg_tot: ',
cc   $ kreg, kflight, kreg_tot
cc    print *, 'kreg_max, kflight_max, kreg_tot_max: ',
cc   $ kreg_max, kflight_max, kreg_tot_max
cppppp
      endif
c
      if(.not.l_operational) then
        do mm=1,kreg
          do ii=1,kreg_tot
            if(creg_reg(mm)(1:8).eq.creg_reg_tot(ii)(1:8).and.
     $         creg_reg(mm).ne.'xxxxxxxx') then
           ntemp_reg_tot(ii,1:5)=ntemp_reg_tot(ii,1:5)+ntemp_reg(mm,1:5)
           nwind_reg_tot(ii,1:5)=nwind_reg_tot(ii,1:5)+nwind_reg(mm,1:5)
            endif
          enddo
        enddo
      endif
c
c     Output reports to log file if desired
c     -------------------------------------
      l_print = .false.
c
      if(l_print) then
        write(io8,*) 
        write(io8,*) 'Reports after reject list check'
        write(io8,*) '-------------------------------'
        call pr_workdata(max_reps,numreps,indx
     x,      alat,alon,pres,ht_ft,idt,idp,c_acftreg,c_acftid,itype        
     x,      t_prcn,ob_t,ob_q,ob_dir,ob_spd
     x,      xiv_t,xiv_q,xiv_d,xiv_s,ichk_t,ichk_q,ichk_d,ichk_s
     x,      cdtg_an,c_qc,csort,io8)        
      endif
c
c      write(io8,*) 
c      write(io8,*) 'Post-QC reports from HZMYCWBA,415IC1BA, or JHCWUURA'
c      write(io8,*) '---------------------------------------------------'
c      do iob = 1,max_reps
c        ii = iob
cc        if(c_acftreg(ii)(1:8).eq.'HZMYCWBA'.or.
cc     $     c_acftreg(ii)(1:8).eq.'415IC1BA'.or.
cc     $     c_acftreg(ii)(1:8).eq.'JHCWUURA') then
c        if(c_acftreg(ii)(1:8).eq.'HN3ICWBA'.or.
c     $     c_acftreg(ii)(1:8).eq.'JSYYCURA'.or.
c     $     c_acftreg(ii)(1:8).eq.'U5IICUZA'.or.
c     $     c_acftreg(ii)(1:8).eq.'415IC1BA'.or.
c     $     c_acftreg(ii)(1:8).eq.'OIIYC1ZA'.or.
c     $     c_acftreg(ii)(1:8).eq.'E5QYZFRA'.or.
c     $     c_acftreg(ii)(1:8).eq.'QNVYCWBA'.or.
c     $     c_acftreg(ii)(1:8).eq.'1ZUYC1RA'.or.
c     $     c_acftreg(ii)(1:8).eq.'1GUUIRRA'.or.
c     $     c_acftreg(ii)(1:8).eq.'JI0KEWJA') then
cc
c          write (io8,8011) iob,ii,c_insty_ob(itype(ii))
c     x,      c_acftreg(ii),c_acftid(ii)
c     x,      idt(ii),alat(ii),alon(ii),pres(ii),ht_ft(ii)
c     x,      t_prcn(ii),ob_t(ii),xiv_t(ii),ichk_t(ii)
c     x,      ob_q(ii),xiv_q(ii),ichk_q(ii)
c     x,      ob_dir(ii),xiv_d(ii),ichk_d(ii)
c     x,      ob_spd(ii),xiv_s(ii),ichk_s(ii),idp(ii)
c     x,      c_qc(ii),csort(ii)
c 8011     format(i5,1x,i6,1x,a8,1x,a8,1x,a9,1x
c     x,      i7,1x,2f11.5,1x,f8.1,1x,f7.0,1x
c     x,      f5.2,4(2(1x,f8.2),1x,i5),1x,i4
c     x,      1x,'!',a11,'!',1x,a25)
c        endif
c      enddo
c
c Output innovation distributions
c -------------------------------
      if(l_do_innov.and.(.not.l_operational)) then
c
        if(l_pc) call p_ddtg('Calling innov_qc',io8)
c
        call innov_qc(max_reps,numreps,indx,xiv_t,xiv_d,xiv_s,amiss,
     $                c_qc,2,io8,l_init,l_innov_miss)
      endif
c
c Examine first digit distribution for comparison with Benford's law
c Perform after all QC checks
c ------------------------------------------------------------------
      if(l_do_innov.and.
     $   (.not.l_operational).and.
     $   (.not.l_innov_miss)) then
c
        if(l_pc) call p_ddtg('Calling benford_qc',io8)
c
        call benford_qc(max_reps,numreps,indx,xiv_t,xiv_d,xiv_s,amiss,
     $           c_acftreg,itype,maxflt,kreg_tot,creg_reg_tot,
     $           c_qc,lead_t_tot,lead_d_tot,lead_s_tot,
     $           n_xiv_t,n_xiv_d,n_xiv_s,
     $           sum_xiv_t,sum_xiv_d,sum_xiv_s,
     $           sumabs_xiv_t,sumabs_xiv_d,sumabs_xiv_s,2,io8
     $,          l_init,l_last)
        kflight_max = max(kflight,kflight_max)
        kreg_max = max(kreg,kreg_max)
        kreg_tot_max = max(kreg_tot,kreg_tot_max)
cppppp
cc    print *, 'after call 2 to benford_qc kreg, kflight, kreg_tot: ',
cc   $ kreg, kflight, kreg_tot
cc    print *, 'kreg_max, kflight_max, kreg_tot_max: ',
cc   $ kreg_max, kflight_max, kreg_tot_max
cppppp
c
        if(l_pc) call p_ddtg('Back from benford_qc',io8)
c
      endif
c
c Compute statistics for automated AIREPs
c ---------------------------------------
c (Additional AMDAR bulletins turned on Feb 10, 1999--automated AIREPs
c  are largely superfluous after that date.  Before then, Australian
c  and Asian AMDAR reports were only received as AIREPs.)
c --------------------------------------------------------------------
      read(cdtg_an,'(i8)') kdtg_an
c
      k_AMDAR_tot = 0
      k_AIREP_tot = 0
      k_AIREP_good = 0
      k_UAL_tot = 0
      k_UAL_good = 0
      k_EU_tot = 0
      k_EU_good = 0
      k_AU_tot = 0
      k_AU_good = 0
      k_other_tot = 0
      k_other_good = 0
      l_print = .true.
c
      if(l_print) then
        write(io8,*) 
ccccdak        write(io8,*) 'Unrejected re-encoded ACARS and AMDAR reports'
        write(io8,*) 'Unrejected re-encoded TAMDAR and AMDAR reports'
        write(io8,*) '---------------------------------------------'
      endif
c
      do ii=1,numreps_orig
c
c       Count the total number of AMDAR reports
c       ---------------------------------------
        if(itype(ii).eq.i_amdar_lvl.or.
     $     itype(ii).eq.i_amdar_asc.or.
     $     itype(ii).eq.i_amdar_des.or.
     $     itype(ii).eq.i_amdar) then
c
          k_AMDAR_tot = k_AMDAR_tot + 1 
c
c       Count the total number of AIREP reports
c       ---------------------------------------
        elseif(itype(ii).eq.i_airep_lvl.or.
     $         itype(ii).eq.i_airep_asc.or.
     $         itype(ii).eq.i_airep_des.or.
     $         itype(ii).eq.i_airep) then
c
          k_AIREP_tot = k_AIREP_tot + 1
c
c         Count the total number of UAL AIREPs
ccccdak         (Most of these are re-encoded ACARS)
c         (Most of these are re-encoded TAMDAR)
c         -------------------------------------
          if(c_acftid(ii)(1:3).eq.'UAL') then
            k_UAL_tot = k_UAL_tot + 1
c
c         Count the total number of EU AIREPs
c         -----------------------------------
          elseif(c_acftid(ii)(1:2).eq.'EU') then
            k_EU_tot = k_EU_tot + 1
c
c         Count the total number of AU AIREPs
c         -----------------------------------
          elseif(c_acftid(ii)(1:2).eq.'AU') then
            k_AU_tot = k_AU_tot + 1
c
c         Count the total number of other AIREPs
c         --------------------------------------
          else
            k_other_tot = k_other_tot + 1
          endif
c
c         Count the number of good AIREP reports
c         --------------------------------------
          if(csort(ii)(1:5).ne.'zzzzz'.and.
     $       csort(ii)(1:5).ne.'badob') then
c
            k_AIREP_good = k_AIREP_good + 1
c
c           Count the number of good UAL AIREPs
c           -----------------------------------
            if(c_acftid(ii)(1:3).eq.'UAL') then
              k_UAL_good = k_UAL_good + 1
c
c           Count the number of good EU AIREPs
c           ----------------------------------
            elseif(c_acftid(ii)(1:2).eq.'EU') then
              k_EU_good = k_EU_good + 1
c
c           Count the number of good AU AIREPs
c           ----------------------------------
            elseif(c_acftid(ii)(1:2).eq.'AU') then
              k_AU_good = k_AU_good + 1
c
c           Count the number of good other AIREPs
c           -------------------------------------
            else
              k_other_good = k_other_good + 1
            endif
c
c           Output data after the date the Australian AMDAR was turned on
c           -------------------------------------------------------------
            if(kdtg_an.ge.19990210) then
c
c             Output reports if desired
c             -------------------------
              if(l_print) then
                write(io8,3002) ii,c_insty_ob(itype(ii))
     x,            c_acftreg(ii),c_acftid(ii)
     x,            idt(ii),alat(ii),alon(ii)
     x,            pres(ii),ht_ft(ii)
     x,            t_prcn(ii),ob_t(ii),xiv_t(ii),ichk_t(ii)
     x,            ob_q(ii),xiv_q(ii),ichk_q(ii)
     x,            ob_dir(ii),xiv_d(ii),ichk_d(ii)
     x,            ob_spd(ii),xiv_s(ii),ichk_s(ii),idp(ii)
     x,            c_qc(ii)
 3002           format(i6,1x,a8,1x,a8,1x,a9,1x,i7,1x,2f11.5,1x,f8.1,1x
     x,           f7.0,1x,f5.2,4(2(1x,f8.2),1x,i5),1x,i4,1x,'!',a11,'!')
              endif
            endif
          endif
        endif
      enddo
c
c     Compute and output statistics
c     -----------------------------
      if(k_AIREP_tot.gt.0) then
        per_AIREP = 100. * k_AIREP_good / k_AIREP_tot
      else
        per_AIREP = amiss
      endif
      if(k_UAL_tot.gt.0) then
        per_UAL = 100. * k_UAL_good / k_UAL_tot
      else
        per_UAL = amiss
      endif
      if(k_EU_tot.gt.0) then
        per_EU = 100. * k_EU_good / k_EU_tot
      else
        per_EU = amiss
      endif
      if(k_AU_tot.gt.0) then
        per_AU = 100. * k_AU_good / k_AU_tot
      else
        per_AU = amiss
      endif
      if(k_other_tot.gt.0) then
        per_other = 100. * k_other_good / k_other_tot
      else
        per_other = amiss
      endif
c
      write(io8,*)
      write(io8,*) 'Counts for re-encoded AMDAR reports'
      write(io8,*) '-----------------------------------'
      write(io8,*) 'Total number of AMDARs              = ',k_AMDAR_tot
      write(io8,*)
      write(io8,*) 'Total number of AIREPs              = ',k_AIREP_tot
      write(io8,*) '  Total number of UAL               = ',k_UAL_tot
      write(io8,*) '  Total number of EU                = ',k_EU_tot
      write(io8,*) '  Total number of AU                = ',k_AU_tot
      write(io8,*) '  Total number of other             = ',k_other_tot
      write(io8,*)
      write(io8,*) 'Number of good AIREPs               = ',k_AIREP_good
      write(io8,*) '  Number of UAL                     = ',k_UAL_good
      write(io8,*) '  Number of EU                      = ',k_EU_good
      write(io8,*) '  Number of AU                      = ',k_AU_good
      write(io8,*) '  Number of other                   = ',k_other_good
      write(io8,*)
      write(io8,*) 'Percentage of good AIREPs           = ',per_AIREP
      write(io8,*) '  Percentage of good UAL            = ',per_UAL
      write(io8,*) '  Percentage of good EU             = ',per_EU
      write(io8,*) '  Percentage of good AU             = ',per_AU
      write(io8,*) '  Percentage of good other          = ',per_other
c
c Compute similar statistics for YRXX86 AIREPs--keypad reports
c ------------------------------------------------------------
      k_total = 0
      k_good = 0
      k_tot_mdcrs = 0
      k_good_mdcrs = 0
      k_tot_mdcrs_lvl = 0
      k_good_mdcrs_lvl = 0
      k_tot_mdcrs_asc = 0
      k_good_mdcrs_asc = 0
      k_tot_mdcrs_des = 0
      k_good_mdcrs_des = 0
      k_tot_amdar = 0
      k_good_amdar = 0
      k_tot_amdar_lvl = 0
      k_good_amdar_lvl = 0
      k_tot_amdar_asc = 0
      k_good_amdar_asc = 0
      k_tot_amdar_des = 0
      k_good_amdar_des = 0
      k_tot_airep = 0
      k_good_airep = 0
      k_tot_airep_lvl = 0
      k_good_airep_lvl = 0
      k_tot_airep_asc = 0
      k_good_airep_asc = 0
      k_tot_airep_des = 0
      k_good_airep_des = 0
      k_tot_man_airep = 0
      k_good_man_airep = 0
      knt_man_Yairep = 0
      k_YAIREP_good = 0
c
      write(io8,*) 
      write(io8,*) 'Unrejected YRXX86 keypad AIREP reports'
      write(io8,*) '--------------------------------------'
c
      do ii=1,numreps_orig
c
c       Count the total number of aircraft obs
c       --------------------------------------
        if(itype(ii).ne.imiss) then
c
          k_total = k_total + 1
c
c         Count the total number of good aircraft obs
c         -------------------------------------------
          if(csort(ii)(1:5).ne.'zzzzz'.and.
     $       csort(ii)(1:5).ne.'badob') 
     $      k_good = k_good + 1
c
        endif
c
c       Count the total number of unspecified MDCRS reports
c       ---------------------------------------------------
        if(itype(ii).eq.i_mdcrs) then
c
          k_tot_mdcrs = k_tot_mdcrs + 1
c
c         Count the number of good unspecified MDCRS reports
c         --------------------------------------------------
          if(csort(ii)(1:5).ne.'zzzzz'.and.
     $       csort(ii)(1:5).ne.'badob') 
     $      k_good_mdcrs = k_good_mdcrs + 1
c
c       Count the total number of level MDCRS reports
c       ---------------------------------------------
        elseif(itype(ii).eq.i_mdcrs_lvl) then
c
          k_tot_mdcrs_lvl = k_tot_mdcrs_lvl + 1
c
c         Count the number of good level MDCRS reports
c         --------------------------------------------
          if(csort(ii)(1:5).ne.'zzzzz'.and.
     $       csort(ii)(1:5).ne.'badob') 
     $      k_good_mdcrs_lvl = k_good_mdcrs_lvl + 1
c
c       Count the total number of ascent MDCRS reports
c       ----------------------------------------------
        elseif(itype(ii).eq.i_mdcrs_asc) then
c
          k_tot_mdcrs_asc = k_tot_mdcrs_asc + 1
c
c         Count the number of good ascent MDCRS reports
c         ---------------------------------------------
          if(csort(ii)(1:5).ne.'zzzzz'.and.
     $       csort(ii)(1:5).ne.'badob') 
     $      k_good_mdcrs_asc = k_good_mdcrs_asc + 1
c
c       Count the total number of descent MDCRS reports
c       -----------------------------------------------
        elseif(itype(ii).eq.i_mdcrs_des) then
c
          k_tot_mdcrs_des = k_tot_mdcrs_des + 1
c
c         Count the number of good descent MDCRS reports
c         ----------------------------------------------
          if(csort(ii)(1:5).ne.'zzzzz'.and.
     $       csort(ii)(1:5).ne.'badob') 
     $      k_good_mdcrs_des = k_good_mdcrs_des + 1
c
c       Count the total number of unspecified AMDAR reports
c       ---------------------------------------------------
        elseif(itype(ii).eq.i_amdar) then
c
          k_tot_amdar = k_tot_amdar + 1
c
c         Count the number of good unspecified AMDAR reports
c         --------------------------------------------------
          if(csort(ii)(1:5).ne.'zzzzz'.and.
     $       csort(ii)(1:5).ne.'badob') 
     $      k_good_amdar = k_good_amdar + 1
c
c       Count the total number of level AMDAR reports
c       ---------------------------------------------
        elseif(itype(ii).eq.i_amdar_lvl) then
c
          k_tot_amdar_lvl = k_tot_amdar_lvl + 1
c
c         Count the number of good level AMDAR reports
c         --------------------------------------------
          if(csort(ii)(1:5).ne.'zzzzz'.and.
     $       csort(ii)(1:5).ne.'badob') 
     $      k_good_amdar_lvl = k_good_amdar_lvl + 1
c
c       Count the total number of ascent AMDAR reports
c       ----------------------------------------------
        elseif(itype(ii).eq.i_amdar_asc) then
c
          k_tot_amdar_asc = k_tot_amdar_asc + 1
c
c         Count the number of good ascent AMDAR reports
c         ---------------------------------------------
          if(csort(ii)(1:5).ne.'zzzzz'.and.
     $       csort(ii)(1:5).ne.'badob') 
     $      k_good_amdar_asc = k_good_amdar_asc + 1
c
c       Count the total number of descent AMDAR reports
c       -----------------------------------------------
        elseif(itype(ii).eq.i_amdar_des) then
c
          k_tot_amdar_des = k_tot_amdar_des + 1
c
c         Count the number of good descent AMDAR reports
c         ----------------------------------------------
          if(csort(ii)(1:5).ne.'zzzzz'.and.
     $       csort(ii)(1:5).ne.'badob') 
     $      k_good_amdar_des = k_good_amdar_des + 1
c
c       Count the total number of unspecified AIREP reports
c       ---------------------------------------------------
        elseif(itype(ii).eq.i_airep) then
c
          k_tot_airep = k_tot_airep + 1
c
c         Count the number of good unspecified AIREP reports
c         --------------------------------------------------
          if(csort(ii)(1:5).ne.'zzzzz'.and.
     $       csort(ii)(1:5).ne.'badob') 
     $      k_good_airep = k_good_airep + 1
c
c       Count the total number of level AIREP reports
c       ---------------------------------------------
        elseif(itype(ii).eq.i_airep_lvl) then
c
          k_tot_airep_lvl = k_tot_airep_lvl + 1
c
c         Count the number of good level AIREP reports
c         --------------------------------------------
          if(csort(ii)(1:5).ne.'zzzzz'.and.
     $       csort(ii)(1:5).ne.'badob') 
     $      k_good_airep_lvl = k_good_airep_lvl + 1
c
c       Count the total number of ascent AIREP reports
c       ----------------------------------------------
        elseif(itype(ii).eq.i_airep_asc) then
c
          k_tot_airep_asc = k_tot_airep_asc + 1
c
c         Count the number of good ascent AIREP reports
c         ---------------------------------------------
          if(csort(ii)(1:5).ne.'zzzzz'.and.
     $       csort(ii)(1:5).ne.'badob') 
     $      k_good_airep_asc = k_good_airep_asc + 1
c
c       Count the total number of descent AIREP reports
c       -----------------------------------------------
        elseif(itype(ii).eq.i_airep_des) then
c
          k_tot_airep_des = k_tot_airep_des + 1
c
c         Count the number of good descent AIREP reports
c         ----------------------------------------------
          if(csort(ii)(1:5).ne.'zzzzz'.and.
     $       csort(ii)(1:5).ne.'badob') 
     $      k_good_airep_des = k_good_airep_des + 1      
c
c       Count the total number of manAIREP reports
c       -------------------------------------------
        elseif(itype(ii).eq.i_man_airep) then
c
          k_tot_man_airep = k_tot_man_airep + 1
c
c         Count the number of good manAIREP reports
c         -----------------------------------------
          if(csort(ii)(1:5).ne.'zzzzz'.and.
     $       csort(ii)(1:5).ne.'badob') 
     $      k_good_man_airep = k_good_man_airep + 1
c
c       Count the total number of man-Yairep reports
c       --------------------------------------------
        elseif(itype(ii).eq.i_man_Yairep) then
c
          knt_man_Yairep = knt_man_Yairep + 1
c
c         Count the number of good man-Yairep reports
c         -------------------------------------------
          if(csort(ii)(1:5).ne.'zzzzz'.and.
     $       csort(ii)(1:5).ne.'badob') then
c
            k_YAIREP_good = k_YAIREP_good + 1
c
c           Output data after the date the Tinker bulletins were turned on
c           --------------------------------------------------------------
            if(kdtg_an.ge.20001001) then
c
c             Output reports if desired
c             -------------------------
              if(l_print) then
                write(io8,3002) ii,c_insty_ob(itype(ii))
     x,            c_acftreg(ii),c_acftid(ii)
     x,            idt(ii),alat(ii),alon(ii)
     x,            pres(ii),ht_ft(ii)
     x,            t_prcn(ii),ob_t(ii),xiv_t(ii),ichk_t(ii)
     x,            ob_q(ii),xiv_q(ii),ichk_q(ii)
     x,            ob_dir(ii),xiv_d(ii),ichk_d(ii)
     x,            ob_spd(ii),xiv_s(ii),ichk_s(ii),idp(ii)
     x,            c_qc(ii)
              endif
            endif
          endif
        endif
      enddo
c
      if(knt_man_Yairep.gt.0) then
        per_AIREP = 100. * k_YAIREP_good / knt_man_Yairep
      else
        per_AIREP = amiss
      endif
c
      write(io8,*)
      write(io8,*) 'Counts for YRXX86 keypad AIREP reports'
      write(io8,*) '--------------------------------------'
      write(io8,*) 'Total number of man-Yaireps      = ',knt_man_Yairep
      write(io8,*) 'Number of good man-Yaireps       = ',k_YAIREP_good
      write(io8,*) 'Percentage of good man-Yaireps   = ',per_AIREP
c
c Output overall totals
c ---------------------
      write(io8,*)
      write(io8,*) ' Counts by specified data type'
      write(io8,*) ' -----------------------------'
      write(io8,*) ' Type      #Total     #Good'
      write(io8,*) ' --------------------------'
      write(io8,*) 'mdcrs    ',k_tot_mdcrs,k_good_mdcrs
      write(io8,*) 'mdcrs_lvl',k_tot_mdcrs_lvl,k_good_mdcrs_lvl
      write(io8,*) 'mdcrs_asc',k_tot_mdcrs_asc,k_good_mdcrs_asc
      write(io8,*) 'mdcrs_des',k_tot_mdcrs_des,k_good_mdcrs_des
      write(io8,*) ' --------------------------'
      write(io8,*) 'amdar    ',k_tot_amdar,k_good_amdar
      write(io8,*) 'amdar_lvl',k_tot_amdar_lvl,k_good_amdar_lvl
      write(io8,*) 'amdar_asc',k_tot_amdar_asc,k_good_amdar_asc
      write(io8,*) 'amdar_des',k_tot_amdar_des,k_good_amdar_des
      write(io8,*) ' --------------------------'
      write(io8,*) 'airep    ',k_tot_airep,k_good_airep
      write(io8,*) 'airep_lvl',k_tot_airep_lvl,k_good_airep_lvl
      write(io8,*) 'airep_asc',k_tot_airep_asc,k_good_airep_asc
      write(io8,*) 'airep_des',k_tot_airep_des,k_good_airep_des
      write(io8,*) ' --------------------------'
      write(io8,*) 'man_airep',k_tot_man_airep,k_good_man_airep
      write(io8,*) 'man-Yaire',knt_man_Yairep,k_YAIREP_good
      write(io8,*) ' --------------------------'
      write(io8,*) 'total    ',k_total,k_good
      write(io8,*) ' --------------------------'
c
c Re-count totals using determined data type
c ------------------------------------------
      k_total = 0
      k_good = 0
      k_tot_mdcrs = 0
      k_good_mdcrs = 0
      k_tot_mdcrs_lvl = 0
      k_good_mdcrs_lvl = 0
      k_tot_mdcrs_asc = 0
      k_good_mdcrs_asc = 0
      k_tot_mdcrs_des = 0
      k_good_mdcrs_des = 0
      k_tot_amdar = 0
      k_good_amdar = 0
      k_tot_amdar_lvl = 0
      k_good_amdar_lvl = 0
      k_tot_amdar_asc = 0
      k_good_amdar_asc = 0
      k_tot_amdar_des = 0
      k_good_amdar_des = 0
      k_tot_airep = 0
      k_good_airep = 0
      k_tot_airep_lvl = 0
      k_good_airep_lvl = 0
      k_tot_airep_asc = 0
      k_good_airep_asc = 0
      k_tot_airep_des = 0
      k_good_airep_des = 0
      k_tot_man_airep = 0
      k_good_man_airep = 0
      knt_man_Yairep = 0
      k_YAIREP_good = 0
c
      do ii=1,numreps_orig
c
c       Count the total number of aircraft obs
c       --------------------------------------
        if(itype(ii).ne.imiss) then
c
          k_total = k_total + 1
c
c         Count the total number of good aircraft obs
c         -------------------------------------------
          if(csort(ii)(1:5).ne.'zzzzz'.and.
     $       csort(ii)(1:5).ne.'badob') 
     $      k_good = k_good + 1
c
        endif
c
c       Count the total number of manAIREP reports
c       -------------------------------------------
        if(itype(ii).eq.i_man_airep) then
c
          k_tot_man_airep = k_tot_man_airep + 1
c
c         Count the number of good manAIREP reports
c         -----------------------------------------
          if(csort(ii)(1:5).ne.'zzzzz'.and.
     $       csort(ii)(1:5).ne.'badob') 
     $      k_good_man_airep = k_good_man_airep + 1
c
c       Count the total number of man-Yairep reports
c       --------------------------------------------
        elseif(itype(ii).eq.i_man_Yairep) then
c
          knt_man_Yairep = knt_man_Yairep + 1
c
c         Count the number of good man-Yairep reports
c         -------------------------------------------
          if(csort(ii)(1:5).ne.'zzzzz'.and.
     $       csort(ii)(1:5).ne.'badob')
     4      k_YAIREP_good = k_YAIREP_good + 1
c
c       Count the number of level reports
c       ---------------------------------
        elseif(c_qc(ii)(11:11).eq.'L') then
c
c         Count the total number of level MDCRS reports
c         ---------------------------------------------
          if(itype(ii).eq.i_mdcrs.or.
     $       itype(ii).eq.i_mdcrs_lvl.or.
     $       itype(ii).eq.i_mdcrs_asc.or.
     $       itype(ii).eq.i_mdcrs_des) then
c
            k_tot_mdcrs_lvl = k_tot_mdcrs_lvl + 1
c
c           Count the number of good level MDCRS reports
c           --------------------------------------------
            if(csort(ii)(1:5).ne.'zzzzz'.and.
     $         csort(ii)(1:5).ne.'badob') 
     $        k_good_mdcrs_lvl = k_good_mdcrs_lvl + 1
c
c         Count the total number of level AMDAR reports
c         ---------------------------------------------
          elseif(itype(ii).eq.i_amdar.or. 
     $           itype(ii).eq.i_amdar_lvl.or.
     $           itype(ii).eq.i_amdar_asc.or.
     $           itype(ii).eq.i_amdar_des) then
c
            k_tot_amdar_lvl = k_tot_amdar_lvl + 1
c
c           Count the number of good level AMDAR reports
c           --------------------------------------------
            if(csort(ii)(1:5).ne.'zzzzz'.and.
     $         csort(ii)(1:5).ne.'badob') 
     $        k_good_amdar_lvl = k_good_amdar_lvl + 1
c
c         Count the total number of level AIREP reports
c         ---------------------------------------------
          elseif(itype(ii).eq.i_airep.or.
     $           itype(ii).eq.i_airep_lvl.or.
     $           itype(ii).eq.i_airep_asc.or.
     $           itype(ii).eq.i_airep_des) then
c
            k_tot_airep_lvl = k_tot_airep_lvl + 1
c
c           Count the number of good level AIREP reports
c           --------------------------------------------
            if(csort(ii)(1:5).ne.'zzzzz'.and.
     $         csort(ii)(1:5).ne.'badob') 
     $        k_good_airep_lvl = k_good_airep_lvl + 1
c
          endif
c
c       Count the number of ascent reports
c       ----------------------------------
        elseif(c_qc(ii)(11:11).eq.'A'.or.
     $         c_qc(ii)(11:11).eq.'a') then
c
c         Count the total number of ascent MDCRS reports
c         ----------------------------------------------
          if(itype(ii).eq.i_mdcrs.or.
     $       itype(ii).eq.i_mdcrs_lvl.or.
     $       itype(ii).eq.i_mdcrs_asc.or.
     $       itype(ii).eq.i_mdcrs_des) then
c
            k_tot_mdcrs_asc = k_tot_mdcrs_asc + 1
c
c           Count the number of good ascent MDCRS reports
c           ---------------------------------------------
            if(csort(ii)(1:5).ne.'zzzzz'.and.
     $         csort(ii)(1:5).ne.'badob') 
     $        k_good_mdcrs_asc = k_good_mdcrs_asc + 1
c
c         Count the total number of ascent AMDAR reports
c         ----------------------------------------------
          elseif(itype(ii).eq.i_amdar.or. 
     $           itype(ii).eq.i_amdar_lvl.or.
     $           itype(ii).eq.i_amdar_asc.or.
     $           itype(ii).eq.i_amdar_des) then
c
            k_tot_amdar_asc = k_tot_amdar_asc + 1
c
c           Count the number of good ascent AMDAR reports
c           ---------------------------------------------
            if(csort(ii)(1:5).ne.'zzzzz'.and.
     $         csort(ii)(1:5).ne.'badob') 
     $        k_good_amdar_asc = k_good_amdar_asc + 1
c
c         Count the total number of ascent AIREP reports
c         ----------------------------------------------
          elseif(itype(ii).eq.i_airep.or.
     $           itype(ii).eq.i_airep_lvl.or.
     $           itype(ii).eq.i_airep_asc.or.
     $           itype(ii).eq.i_airep_des) then
c
            k_tot_airep_asc = k_tot_airep_asc + 1
c
c           Count the number of good ascent AIREP reports
c           ---------------------------------------------
            if(csort(ii)(1:5).ne.'zzzzz'.and.
     $         csort(ii)(1:5).ne.'badob') 
     $        k_good_airep_asc = k_good_airep_asc + 1
c
          endif
c
c       Count the number of descent reports
c       -----------------------------------
        elseif(c_qc(ii)(11:11).eq.'D'.or.
     $         c_qc(ii)(11:11).eq.'d') then
c
c         Count the total number of descent MDCRS reports
c         -----------------------------------------------
          if(itype(ii).eq.i_mdcrs.or.
     $       itype(ii).eq.i_mdcrs_lvl.or.
     $       itype(ii).eq.i_mdcrs_asc.or.
     $       itype(ii).eq.i_mdcrs_des) then
c
            k_tot_mdcrs_des = k_tot_mdcrs_des + 1
c
c           Count the number of good descent MDCRS reports
c           ----------------------------------------------
            if(csort(ii)(1:5).ne.'zzzzz'.and.
     $         csort(ii)(1:5).ne.'badob') 
     $        k_good_mdcrs_des = k_good_mdcrs_des + 1
c
c         Count the total number of descent AMDAR reports
c         -----------------------------------------------
          elseif(itype(ii).eq.i_amdar.or. 
     $           itype(ii).eq.i_amdar_lvl.or.
     $           itype(ii).eq.i_amdar_asc.or.
     $           itype(ii).eq.i_amdar_des) then
c
            k_tot_amdar_des = k_tot_amdar_des + 1
c
c           Count the number of good descent AMDAR reports
c           ----------------------------------------------
            if(csort(ii)(1:5).ne.'zzzzz'.and.
     $         csort(ii)(1:5).ne.'badob') 
     $        k_good_amdar_des = k_good_amdar_des + 1
c
c         Count the total number of descent AIREP reports
c         -----------------------------------------------
          elseif(itype(ii).eq.i_airep.or.
     $           itype(ii).eq.i_airep_lvl.or.
     $           itype(ii).eq.i_airep_asc.or.
     $           itype(ii).eq.i_airep_des) then
c
            k_tot_airep_des = k_tot_airep_des + 1
c
c           Count the number of good descent AIREP reports
c           ----------------------------------------------
            if(csort(ii)(1:5).ne.'zzzzz'.and.
     $         csort(ii)(1:5).ne.'badob') 
     $        k_good_airep_des = k_good_airep_des + 1      
c
          endif
c
c       Count the remaining reports
c       ---------------------------
        else
c
c         Count the total number of other MDCRS reports
c         ---------------------------------------------
          if(itype(ii).eq.i_mdcrs.or.
     $       itype(ii).eq.i_mdcrs_lvl.or.
     $       itype(ii).eq.i_mdcrs_asc.or.
     $       itype(ii).eq.i_mdcrs_des) then
c
            k_tot_mdcrs = k_tot_mdcrs + 1
c
c           Count the number of good other MDCRS reports
c           --------------------------------------------
            if(csort(ii)(1:5).ne.'zzzzz'.and.
     $         csort(ii)(1:5).ne.'badob') 
     $        k_good_mdcrs = k_good_mdcrs + 1
c
c         Count the total number of other AMDAR reports
c         ---------------------------------------------
          elseif(itype(ii).eq.i_amdar.or. 
     $           itype(ii).eq.i_amdar_lvl.or.
     $           itype(ii).eq.i_amdar_asc.or.
     $           itype(ii).eq.i_amdar_des) then
c
            k_tot_amdar = k_tot_amdar + 1
c
c           Count the number of good other AMDAR reports
c           --------------------------------------------
            if(csort(ii)(1:5).ne.'zzzzz'.and.
     $         csort(ii)(1:5).ne.'badob') 
     $        k_good_amdar = k_good_amdar + 1
c
c         Count the total number of other AIREP reports
c         ---------------------------------------------
          elseif(itype(ii).eq.i_airep.or.
     $           itype(ii).eq.i_airep_lvl.or.
     $           itype(ii).eq.i_airep_asc.or.
     $           itype(ii).eq.i_airep_des) then
c
            k_tot_airep = k_tot_airep + 1
c
c           Count the number of good other AIREP reports
c           --------------------------------------------
            if(csort(ii)(1:5).ne.'zzzzz'.and.
     $         csort(ii)(1:5).ne.'badob') 
     $        k_good_airep = k_good_airep + 1
c
          endif
c
        endif
      enddo
c
      write(io8,*)
      write(io8,*) ' Counts by determined data type'
      write(io8,*) ' ------------------------------'
      write(io8,*) ' Type      #Total     #Good'
      write(io8,*) ' --------------------------'
      write(io8,*) 'mdcrs    ',k_tot_mdcrs,k_good_mdcrs
      write(io8,*) 'mdcrs_lvl',k_tot_mdcrs_lvl,k_good_mdcrs_lvl
      write(io8,*) 'mdcrs_asc',k_tot_mdcrs_asc,k_good_mdcrs_asc
      write(io8,*) 'mdcrs_des',k_tot_mdcrs_des,k_good_mdcrs_des
      write(io8,*) ' --------------------------'
      write(io8,*) 'amdar    ',k_tot_amdar,k_good_amdar
      write(io8,*) 'amdar_lvl',k_tot_amdar_lvl,k_good_amdar_lvl
      write(io8,*) 'amdar_asc',k_tot_amdar_asc,k_good_amdar_asc
      write(io8,*) 'amdar_des',k_tot_amdar_des,k_good_amdar_des
      write(io8,*) ' --------------------------'
      write(io8,*) 'airep    ',k_tot_airep,k_good_airep
      write(io8,*) 'airep_lvl',k_tot_airep_lvl,k_good_airep_lvl
      write(io8,*) 'airep_asc',k_tot_airep_asc,k_good_airep_asc
      write(io8,*) 'airep_des',k_tot_airep_des,k_good_airep_des
      write(io8,*) ' --------------------------'
      write(io8,*) 'man_airep',k_tot_man_airep,k_good_man_airep
      write(io8,*) 'man-Yaire',knt_man_Yairep,k_YAIREP_good
      write(io8,*) ' --------------------------'
      write(io8,*) 'total    ',k_total,k_good
      write(io8,*) ' --------------------------'
c
c Output totals for each flight
c -----------------------------
      if(.not.l_operational) then
        write(io8,*)
        write(io8,*) 'Totals for tail#s with rejected reports'
        write(io8,*) '---------------------------------------'
        write(io8,'(27x,a12,22x,a8)')'Total Number','Rejected'
        write(io8,'(a47,a43)')
     $    '  kk  tail num  #Md    #Ac    #Am    #Ar    #Ma',
     $    '    #Md    #Ac    #Am    #Ar    #Ma     %  '
        write(io8,'(1x,a47,a43)')
     $    '----- -------- ------ ------ ------ ------ ----',
     $    '-- ------ ------ ------ ------ ------ -----'
c
        do kk=1,kreg_tot
          if(nobs_reg_tot(kk,1).ne.0.or.
     $       nobs_reg_tot(kk,2).ne.0.or.
     $       nobs_reg_tot(kk,3).ne.0.or.
     $       nobs_reg_tot(kk,4).ne.0.or.
     $       nobs_reg_tot(kk,5).ne.0) then
c
            percent = (nrej_reg_tot(kk,1) + nrej_reg_tot(kk,2) 
     $               + nrej_reg_tot(kk,3) + nrej_reg_tot(kk,4)
     $               + nrej_reg_tot(kk,5)) * 100.0
     $              / (nobs_reg_tot(kk,1) + nobs_reg_tot(kk,2) 
     $               + nobs_reg_tot(kk,3) + nobs_reg_tot(kk,4)
     $               + nobs_reg_tot(kk,5))
c
            write(io8,'(i5,1x,a8,10(1x,i6),f6.1)') kk,creg_reg_tot(kk),
     $        nobs_reg_tot(kk,1),nobs_reg_tot(kk,2),
     $        nobs_reg_tot(kk,3),nobs_reg_tot(kk,4),
     $        nobs_reg_tot(kk,5),
     $        nrej_reg_tot(kk,1),nrej_reg_tot(kk,2),
     $        nrej_reg_tot(kk,3),nrej_reg_tot(kk,4),
     $        nrej_reg_tot(kk,5),percent
          endif
        enddo
c
        write(io8,*)
        write(io8,*) 'Totals for tail#s with temp in whole degrees'
        write(io8,*) '--------------------------------------------'
        write(io8,'(27x,a12,22x,a8)')'Total Number','Rejected'
        write(io8,'(a47,a43)')
     $    '  kk  tail num  #Md    #Ac    #Am    #Ar    #Ma',
     $    '    #Md    #Ac    #Am    #Ar    #Ma     %  '
        write(io8,'(1x,a47,a43)')
     $    '----- -------- ------ ------ ------ ------ ----',
     $    '-- ------ ------ ------ ------ ------ -----'
c
        do kk=1,kreg_tot
          if(nwhol_reg_tot(kk,1).ne.0.or.
     $       nwhol_reg_tot(kk,2).ne.0.or.
     $       nwhol_reg_tot(kk,3).ne.0.or.
     $       nwhol_reg_tot(kk,4).ne.0.or.
     $       nwhol_reg_tot(kk,5).ne.0) then
c
            percent = (nwhol_reg_tot(kk,1) + nwhol_reg_tot(kk,2) 
     $              + nwhol_reg_tot(kk,3) + nwhol_reg_tot(kk,4)
     $                + nwhol_reg_tot(kk,5)) * 100.0
     $              / (nobs_reg_tot(kk,1) + nobs_reg_tot(kk,2) 
     $               + nobs_reg_tot(kk,3) + nobs_reg_tot(kk,4)
     $               + nobs_reg_tot(kk,5))
c 
            write(io8,'(i5,1x,a8,10(1x,i6),f6.1)') kk,creg_reg_tot(kk),
     $        nobs_reg_tot(kk,1),nobs_reg_tot(kk,2),
     $        nobs_reg_tot(kk,3),nobs_reg_tot(kk,4),
     $        nobs_reg_tot(kk,5),
     $        nwhol_reg_tot(kk,1),nwhol_reg_tot(kk,2),
     $        nwhol_reg_tot(kk,3),nwhol_reg_tot(kk,4),
     $        nwhol_reg_tot(kk,5),percent
          endif
        enddo
c
        write(io8,*)
        write(io8,*) 'Totals for tail#s with rejected temperatures'
        write(io8,*) '--------------------------------------------'
        write(io8,'(27x,a12,22x,a8)')'Total Number','Rejected'
        write(io8,'(a47,a43)')
     $    '  kk  tail num  #Md    #Ac    #Am    #Ar    #Ma',
     $    '    #Md    #Ac    #Am    #Ar    #Ma     %  '
        write(io8,'(1x,a47,a43)')
     $    '----- -------- ------ ------ ------ ------ ----',
     $    '-- ------ ------ ------ ------ ------ -----'
c
        do kk=1,kreg_tot
          if(ntemp_reg_tot(kk,1).ne.0.or.
     $       ntemp_reg_tot(kk,2).ne.0.or.
     $       ntemp_reg_tot(kk,3).ne.0.or.
     $       ntemp_reg_tot(kk,4).ne.0.or.
     $       ntemp_reg_tot(kk,5).ne.0) then
c
            percent = (ntemp_reg_tot(kk,1) + ntemp_reg_tot(kk,2) 
     $               + ntemp_reg_tot(kk,3) + ntemp_reg_tot(kk,4)
     $               + ntemp_reg_tot(kk,5)) *100.0
     $              / (nobs_reg_tot(kk,1) + nobs_reg_tot(kk,2) 
     $               + nobs_reg_tot(kk,3) + nobs_reg_tot(kk,4)
     $               + nobs_reg_tot(kk,5))
c 
            write(io8,'(i5,1x,a8,10(1x,i6),f6.1)') kk,creg_reg_tot(kk),
     $        nobs_reg_tot(kk,1),nobs_reg_tot(kk,2),
     $        nobs_reg_tot(kk,3),nobs_reg_tot(kk,4),
     $        nobs_reg_tot(kk,5),
     $        ntemp_reg_tot(kk,1),ntemp_reg_tot(kk,2),
     $        ntemp_reg_tot(kk,3),ntemp_reg_tot(kk,4),
     $        ntemp_reg_tot(kk,5),percent
          endif
        enddo
c
        write(io8,*)
        write(io8,*) 'Totals for tail#s with rejected winds'
        write(io8,*) '-------------------------------------'
        write(io8,'(27x,a12,22x,a8)')'Total Number','Rejected'
        write(io8,'(a47,a43)')
     $    '  kk  tail num  #Md    #Ac    #Am    #Ar    #Ma',
     $    '    #Md    #Ac    #Am    #Ar    #Ma     %  '
        write(io8,'(1x,a47,a43)')
     $    '----- -------- ------ ------ ------ ------ ----',
     $    '-- ------ ------ ------ ------ ------ -----'
c
        do kk=1,kreg_tot
          if(nwind_reg_tot(kk,1).ne.0.or.
     $       nwind_reg_tot(kk,2).ne.0.or.
     $       nwind_reg_tot(kk,3).ne.0.or.
     $       nwind_reg_tot(kk,4).ne.0.or.
     $       nwind_reg_tot(kk,5).ne.0) then
c
            percent = (nwind_reg_tot(kk,1) + nwind_reg_tot(kk,2) 
     $               + nwind_reg_tot(kk,3) + nwind_reg_tot(kk,4)
     $               + nwind_reg_tot(kk,5)) * 100.0
     $              / (nobs_reg_tot(kk,1) + nobs_reg_tot(kk,2) 
     $               + nobs_reg_tot(kk,3) + nobs_reg_tot(kk,4)
     $               + nobs_reg_tot(kk,5))
c 
            write(io8,'(i5,1x,a8,10(1x,i6),f6.1)') kk,creg_reg_tot(kk),
     $        nobs_reg_tot(kk,1),nobs_reg_tot(kk,2),
     $        nobs_reg_tot(kk,3),nobs_reg_tot(kk,4),
     $        nobs_reg_tot(kk,5),
     $        nwind_reg_tot(kk,1),nwind_reg_tot(kk,2),
     $        nwind_reg_tot(kk,3),nwind_reg_tot(kk,4),
     $        nwind_reg_tot(kk,5),percent
          endif
        enddo
c
        write(io8,*)
        write(io8,*) 'Totals for tail#s with invalid check errors'
        write(io8,*) '-------------------------------------------'
        write(io8,'(27x,a12,22x,a8)')'Total Number','Rejected'
        write(io8,'(a47,a43)')
     $    '  kk  tail num  #Md    #Ac    #Am    #Ar    #Ma',
     $    '    #Md    #Ac    #Am    #Ar    #Ma     %  '
        write(io8,'(1x,a47,a43)')
     $    '----- -------- ------ ------ ------ ------ ----',
     $    '-- ------ ------ ------ ------ ------ -----'
c
        do kk=1,kreg_tot
          if(nrej_inv_tot(kk,1).ne.0.or.
     $       nrej_inv_tot(kk,2).ne.0.or.
     $       nrej_inv_tot(kk,3).ne.0.or.
     $       nrej_inv_tot(kk,4).ne.0.or.
     $       nrej_inv_tot(kk,5).ne.0) then
c
            percent = (nrej_inv_tot(kk,1) + nrej_inv_tot(kk,2) 
     $               + nrej_inv_tot(kk,3) + nrej_inv_tot(kk,4)
     $               + nrej_inv_tot(kk,5)) * 100.0
     $              / (nobs_reg_tot(kk,1) + nobs_reg_tot(kk,2) 
     $               + nobs_reg_tot(kk,3) + nobs_reg_tot(kk,4)
     $               + nobs_reg_tot(kk,5))
c
            write(io8,'(i5,1x,a8,10(1x,i6),f6.1)') kk,creg_reg_tot(kk),
     $        nobs_reg_tot(kk,1),nobs_reg_tot(kk,2),
     $        nobs_reg_tot(kk,3),nobs_reg_tot(kk,4),
     $        nobs_reg_tot(kk,5),
     $        nrej_inv_tot(kk,1),nrej_inv_tot(kk,2),
     $        nrej_inv_tot(kk,3),nrej_inv_tot(kk,4),
     $        nrej_inv_tot(kk,5),percent
          endif
        enddo
c
        write(io8,*)
        write(io8,*) 'Totals for tail#s with stuck values'
        write(io8,*) '-----------------------------------'
        write(io8,'(27x,a12,22x,a8)')'Total Number','Rejected'
        write(io8,'(a47,a43)')
     $    '  kk  tail num  #Md    #Ac    #Am    #Ar    #Ma',
     $    '    #Md    #Ac    #Am    #Ar    #Ma     %  '
        write(io8,'(1x,a47,a43)')
     $    '----- -------- ------ ------ ------ ------ ----',
     $    '-- ------ ------ ------ ------ ------ -----'
c
        do kk=1,kreg_tot
          if(nrej_stk_tot(kk,1).ne.0.or.
     $       nrej_stk_tot(kk,2).ne.0.or.
     $       nrej_stk_tot(kk,3).ne.0.or.
     $       nrej_stk_tot(kk,4).ne.0.or.
     $       nrej_stk_tot(kk,5).ne.0) then
c
            percent = (nrej_stk_tot(kk,1) + nrej_stk_tot(kk,2) 
     $               + nrej_stk_tot(kk,3) + nrej_stk_tot(kk,4)
     $               + nrej_stk_tot(kk,5)) * 100.0
     $              / (nobs_reg_tot(kk,1) + nobs_reg_tot(kk,2) 
     $               + nobs_reg_tot(kk,3) + nobs_reg_tot(kk,4)
     $               + nobs_reg_tot(kk,5))
c 
            write(io8,'(i5,1x,a8,10(1x,i6),f6.1)') kk,creg_reg_tot(kk),
     $        nobs_reg_tot(kk,1),nobs_reg_tot(kk,2),
     $        nobs_reg_tot(kk,3),nobs_reg_tot(kk,4),
     $        nobs_reg_tot(kk,5),
     $        nrej_stk_tot(kk,1),nrej_stk_tot(kk,2),
     $        nrej_stk_tot(kk,3),nrej_stk_tot(kk,4),
     $        nrej_stk_tot(kk,5),percent
          endif
        enddo
c
        write(io8,*)
        write(io8,*) 'Totals for tail#s with gross check errors'
        write(io8,*) '-----------------------------------------'
        write(io8,'(27x,a12,22x,a8)')'Total Number','Rejected'
        write(io8,'(a47,a43)')
     $    '  kk  tail num  #Md    #Ac    #Am    #Ar    #Ma',
     $    '    #Md    #Ac    #Am    #Ar    #Ma     %  '
        write(io8,'(1x,a47,a43)')
     $    '----- -------- ------ ------ ------ ------ ----',
     $    '-- ------ ------ ------ ------ ------ -----'
c
        do kk=1,kreg_tot
          if(nrej_grc_tot(kk,1).ne.0.or.
     $       nrej_grc_tot(kk,2).ne.0.or.
     $       nrej_grc_tot(kk,3).ne.0.or.
     $       nrej_grc_tot(kk,4).ne.0.or.
     $       nrej_grc_tot(kk,5).ne.0) then
c
            percent = (nrej_grc_tot(kk,1) + nrej_grc_tot(kk,2) 
     $               + nrej_grc_tot(kk,3) + nrej_grc_tot(kk,4)
     $               + nrej_grc_tot(kk,5)) * 100.0
     $              / (nobs_reg_tot(kk,1) + nobs_reg_tot(kk,2) 
     $               + nobs_reg_tot(kk,3) + nobs_reg_tot(kk,4)
     $               + nobs_reg_tot(kk,5))
c
            write(io8,'(i5,1x,a8,10(1x,i6),f6.1)') kk,creg_reg_tot(kk),
     $        nobs_reg_tot(kk,1),nobs_reg_tot(kk,2),
     $        nobs_reg_tot(kk,3),nobs_reg_tot(kk,4),
     $        nobs_reg_tot(kk,5),
     $        nrej_grc_tot(kk,1),nrej_grc_tot(kk,2),
     $        nrej_grc_tot(kk,3),nrej_grc_tot(kk,4),
     $        nrej_grc_tot(kk,5),percent
          endif
        enddo
c
        write(io8,*)
        write(io8,*) 'Totals for tail#s with position check errors'
        write(io8,*) '--------------------------------------------'
        write(io8,'(27x,a12,22x,a8)')'Total Number','Rejected'
        write(io8,'(a47,a43)')
     $    '  kk  tail num  #Md    #Ac    #Am    #Ar    #Ma',
     $    '    #Md    #Ac    #Am    #Ar    #Ma     %  '
        write(io8,'(1x,a47,a43)')
     $    '----- -------- ------ ------ ------ ------ ----',
     $    '-- ------ ------ ------ ------ ------ -----'
c
        do kk=1,kreg_tot
          if(nrej_pos_tot(kk,1).ne.0.or.
     $       nrej_pos_tot(kk,2).ne.0.or.
     $       nrej_pos_tot(kk,3).ne.0.or.
     $       nrej_pos_tot(kk,4).ne.0.or.
     $       nrej_pos_tot(kk,5).ne.0) then
c
            percent = (nrej_pos_tot(kk,1) + nrej_pos_tot(kk,2) 
     $               + nrej_pos_tot(kk,3) + nrej_pos_tot(kk,4)
     $               + nrej_pos_tot(kk,5)) * 100.0
     $              / (nobs_reg_tot(kk,1) + nobs_reg_tot(kk,2) 
     $               + nobs_reg_tot(kk,3) + nobs_reg_tot(kk,4)
     $               + nobs_reg_tot(kk,5))
c 
            write(io8,'(i5,1x,a8,10(1x,i6),f6.1)') kk,creg_reg_tot(kk),
     $        nobs_reg_tot(kk,1),nobs_reg_tot(kk,2),
     $        nobs_reg_tot(kk,3),nobs_reg_tot(kk,4),
     $        nobs_reg_tot(kk,5),
     $        nrej_pos_tot(kk,1),nrej_pos_tot(kk,2),
     $        nrej_pos_tot(kk,3),nrej_pos_tot(kk,4),
     $        nrej_pos_tot(kk,5),percent
          endif
        enddo
c
        write(io8,*)
        write(io8,*) 'Totals for tail#s with ordering check errors'
        write(io8,*) '--------------------------------------------'
        write(io8,'(27x,a12,22x,a8)')'Total Number','Rejected'
        write(io8,'(a47,a43)')
     $    '  kk  tail num  #Md    #Ac    #Am    #Ar    #Ma',
     $    '    #Md    #Ac    #Am    #Ar    #Ma     %  '
        write(io8,'(1x,a47,a43)')
     $    '----- -------- ------ ------ ------ ------ ----',
     $    '-- ------ ------ ------ ------ ------ -----'
c
        do kk=1,kreg_tot
          if(nrej_ord_tot(kk,1).ne.0.or.
     $       nrej_ord_tot(kk,2).ne.0.or.
     $       nrej_ord_tot(kk,3).ne.0.or.
     $       nrej_ord_tot(kk,4).ne.0.or.
     $       nrej_ord_tot(kk,5).ne.0) then
c
            percent = (nrej_ord_tot(kk,1) + nrej_ord_tot(kk,2) 
     $               + nrej_ord_tot(kk,3) + nrej_ord_tot(kk,4)
     $               + nrej_ord_tot(kk,5)) * 100.0
     $              / (nobs_reg_tot(kk,1) + nobs_reg_tot(kk,2) 
     $               + nobs_reg_tot(kk,3) + nobs_reg_tot(kk,4)
     $               + nobs_reg_tot(kk,5))
c 
            write(io8,'(i5,1x,a8,10(1x,i6),f6.1)') kk,creg_reg_tot(kk),
     $        nobs_reg_tot(kk,1),nobs_reg_tot(kk,2),
     $        nobs_reg_tot(kk,3),nobs_reg_tot(kk,4),
     $        nobs_reg_tot(kk,5),
     $        nrej_ord_tot(kk,1),nrej_ord_tot(kk,2),
     $        nrej_ord_tot(kk,3),nrej_ord_tot(kk,4),
     $        nrej_ord_tot(kk,5),percent
          endif
        enddo
c
        write(io8,*)
        write(io8,*) 'Totals for tail#s with suspect check errors'
        write(io8,*) '-------------------------------------------'
        write(io8,'(27x,a12,22x,a8)')'Total Number','Rejected'
        write(io8,'(a47,a43)')
     $    '  kk  tail num  #Md    #Ac    #Am    #Ar    #Ma',
     $    '    #Md    #Ac    #Am    #Ar    #Ma     %  '
        write(io8,'(1x,a47,a43)')
     $    '----- -------- ------ ------ ------ ------ ----',
     $    '-- ------ ------ ------ ------ ------ -----'
c
        do kk=1,kreg_tot
          if(nrej_sus_tot(kk,1).ne.0.or.
     $       nrej_sus_tot(kk,2).ne.0.or.
     $       nrej_sus_tot(kk,3).ne.0.or.
     $       nrej_sus_tot(kk,4).ne.0.or.
     $       nrej_sus_tot(kk,5).ne.0) then
c
            percent = (nrej_sus_tot(kk,1) + nrej_sus_tot(kk,2) 
     $               + nrej_sus_tot(kk,3) + nrej_sus_tot(kk,4)
     $               + nrej_sus_tot(kk,5)) * 100.0
     $              / (nobs_reg_tot(kk,1) + nobs_reg_tot(kk,2) 
     $               + nobs_reg_tot(kk,3) + nobs_reg_tot(kk,4)
     $               + nobs_reg_tot(kk,5))
c
            write(io8,'(i5,1x,a8,10(1x,i6),f6.1)') kk,creg_reg_tot(kk),
     $        nobs_reg_tot(kk,1),nobs_reg_tot(kk,2),
     $        nobs_reg_tot(kk,3),nobs_reg_tot(kk,4),
     $        nobs_reg_tot(kk,5),
     $        nrej_sus_tot(kk,1),nrej_sus_tot(kk,2),
     $        nrej_sus_tot(kk,3),nrej_sus_tot(kk,4),
     $        nrej_sus_tot(kk,5),percent
          endif
        enddo
      endif
c
c     Close files
c     -----------
      if(.not.l_operational) then
        close(io30)
        close(io31)
        close(io32)
        close(io33)
        close(io34)
        close(io35)
        close(io36)
        close(io37)
        close(io38)
      elseif(l_ncep) then
        close(io8)
      endif

cppppp
cc    print *, 'kreg_max, kflight_max, kreg_tot_max: ',
cc   $ kreg_max, kflight_max, kreg_tot_max
cppppp
      kflight_max = max(kreg_max,kflight_max,kreg_tot_max)
cppppp
cc    print *, 'overall flight number max:', kflight_max
cppppp
      if(kflight_max/.90.gt.maxflt .and. kflight_max.lt.maxflt ) then

c If the maximum number of calculated flights at some point in this processing read in from
c  PREPBUFR file is at least 90% of the maximum number of flights allowed ("maxflt"), print
c  diagnostic warning message to production joblog file
c -----------------------------------------------------------------------------------------

        print 153, kflight_max,maxflt
  153   format(/' #####> WARNING: THE MAX NUMBER OF CALCULATED ',
     $   'AIRCRAFT FLIGHTS FROM INPUT FILE (',I6,') ARE > 90% OF UPPER',
     $   ' LIMIT OF ',I6,' -- INCREASE SIZE OF "MAXFLT" SOON!'/)
        write(cmaxflt,'(i6)') maxflt
        call system('[ -n "$jlogfile" ] && $DATA/postmsg "$jlogfile" '//
     +   '"***WARNING: HIT 90% OF '//cmaxflt//' AIRCRAFT FLIGHT LIMIT'//
     +   ' IN PREPOBS_PREPACQC, INCREASE SIZE OF PARM MAXFLT"')
      endif


      write(*,*)
      write(*,*) '********************'
      write(*,*) 'acftobs_qc has ended'
      call system('date')
      write(*,*) '--> # flights = ',kflight_max
      write(*,*) '********************'
      write(*,*)

c return 1 if  # flts > maxflt out of subr. do_flt, and subr. do_reg (latter transferred here
c  via subr. dupchek_qc)
      if(maxflt_exceeded .gt. 0)  then
         print *, '--------------------------------------------------'
         print *, '~~~> maxflt_exceeded -- return 1 out of acftobs_qc'
         print *, '--------------------------------------------------'
         return 1
      endif

      return

      end
c
c ###################################################################
c                            subroutine pr_workdata
c ###################################################################
c
      subroutine pr_workdata(max_reps,numdo,indx
     x,      alat,alon,pres,ht_ft,idt,idp,c_acftreg,c_acftid,itype        
     x,      t_prcn,ob_t,ob_q,ob_dir,ob_spd
     x,      xiv_t,xiv_q,xiv_d,xiv_s,ichk_t,ichk_q,ichk_d,ichk_s
     x,      cdtg_an,c_qc,csort,io8)        
c
c Print work arrays
c
      implicit none
c
      integer      io8                 ! i/o unit number for log file
      integer      ii,iob              ! do loop indices
      integer      max_reps            ! maximum number of observations allowed
     $,            numdo               ! number of reports to print
      real*8       alat(max_reps)      ! latitude
     $,            alon(max_reps)      ! longitude
      real         pres(max_reps)      ! pressure
     $,            ht_ft(max_reps)     ! height in feet
      integer      idt(max_reps)       ! time in seconds to analysis time
      integer      idp(max_reps)       ! surface pressure change at ob location
      character*8  c_acftreg(max_reps) ! acft registration (tail) number
      character*9  c_acftid(max_reps)  ! acft flight number
      integer      itype(max_reps)     ! instrument type 
      real         t_prcn(max_reps)    ! temperature precision
      real         ob_t(max_reps)      ! temperature
     $,            ob_q(max_reps)      ! specific humidity
     $,            ob_dir(max_reps)    ! wind direction
     $,            ob_spd(max_reps)    ! wind speed
      real         xiv_t(max_reps)     ! temperature innovation (ob - bk)
     $,            xiv_q(max_reps)     ! specific humidity innovation (ob - bk)
     $,            xiv_d(max_reps)     ! wind direction innovation (ob - bk)
     $,            xiv_s(max_reps)     ! wind speed innovation (ob - bk)
      integer      ichk_t(max_reps)    ! NRL quality control flag for temperature ob
     $,            ichk_q(max_reps)    ! NRL quality control flag for specific humidity
     $,            ichk_d(max_reps)    ! NRL quality control flag for wind direction
     $,            ichk_s(max_reps)    ! NRL quality control flag for wind speed
      integer      indx(max_reps)      ! pointer index for reports
      character*10 cdtg_an             ! date time group for analysis
      character*11 c_qc(max_reps)      ! quality control flags for reports
      character*25 csort(max_reps)     ! variable used for sorting data 
c
      character*16 c_insty_ob          ! function to convert integer instrument type 
                                       !   to character instrument type
c
      integer      ihr_an              ! hour of analysis time
     $,            ihr                 ! ob hour
     $,            imin                ! ob minute
     $,            isec                ! ob second
     $,            itime               ! ob minute/second
c
      real*8       wlon                ! west longitude
c
c # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # #
c
      write(io8,8030)
 8030 format(' index type     tail num flight      time hh:mm:ss     '
     $,'lat        lon     pres height  t-pr  temp  ichk dir ichk  spd'
     $ ' ichk humid ichk')
c
      read(cdtg_an,'(8x,i2)') ihr_an
c
      do iob = 1,numdo
        ii = indx(iob)
c
        ihr = idt(ii) / 3600
        if(idt(ii).lt.0) then
          itime = (abs(ihr)+1)*3600 + idt(ii)
          ihr = ihr_an + ihr - 1
          if(ihr.lt.0) ihr = ihr + 24
        else
          itime = idt(ii) - ihr*3600
          ihr = ihr_an + ihr
        endif
c
        imin = itime / 60
        if(imin.eq.60) then
          imin = 0
          ihr = ihr + 1
          itime = itime - 3600
        endif
c
        isec = itime - imin*60
c
        if(alon(ii).gt.180.0) then
          wlon = alon(ii) - 360.0
        else
          wlon = alon(ii)
        endif
c
c        if(alon(ii).ge.300.0) then
        write (io8,8001) ii,c_insty_ob(itype(ii))
     x,      c_acftreg(ii),c_acftid(ii)
     x,      idt(ii),ihr,imin,isec
     x,      alat(ii),wlon,pres(ii),ht_ft(ii)
     x,      t_prcn(ii),ob_t(ii),ichk_t(ii)
     x,      ob_dir(ii),ichk_d(ii)
     x,      ob_spd(ii),ichk_s(ii)
     x,      ob_q(ii),ichk_q(ii)
 8001   format(i6,1x,a8,1x,a8,1x,a9,1x
     x,      i6,1x,i2,':',i2.2,':',i2.2,1x
     x,      f9.5,1x,f10.5,1x,f6.1,1x,f6.0,1x
     x,      f5.2,1x,f6.2,1x,i4,1x,f4.0,1x,i3,1x
     x,      f5.1,1x,i3,1x,f6.2,1x,i3)
c        endif
      enddo
c
      return
      end
c
c ###################################################################
c                            subroutine indexc
c ###################################################################
c
c$$$  subprogram documentation block
c                .      .    .                                       .
c subprogram:    indexc      general sort routine for character array
c   prgmmr: d. a. keyser     org: w/nmc22    date: 95-05-30
c
c abstract: uses efficient sort algorithm to produce index sort list
c   for a 25-character array.  does not rearrange the file.
c
c program history log:
c   93-06-05  r  kistler --- fortran version of c-program
c   93-07-15  p. julian ---- modified to sort 12-character array
c   94-08-25  d. a. keyser - modified to sort 16-character array
c   95-05-30  d. a. keyser - tests for < 2 elements in sort list,
c             if so returns without sorting (but fills indx array)
c   ??-??-??  p. m. pauley - size of carrin changed to character*24
c   10-11-15  s. m. bender - size of carrin changed to character*25
c
c usage:    call indexc(n,carrin,indx)
c   input argument list:
c     n        - size of array to be sorted
c     carrin   - 25-character array to be sorted
c
c   output argument list:
c     indx     - array of pointers giving sort order of carrin in
c              - ascending order {e.g., carrin(indx(i)) is sorted in
c              - ascending order for original i = 1, ... ,n}
c
c remarks: none.
c
c attributes:
c   language: Fortran 90
c   machine:  NCEP WCOSS
c
c$$$
      subroutine indexc(n,carrin,indx)
c
      implicit none
c
      integer      n              ! dimension of array to be sorted
     $,            j              ! do loop index, sort variable
     $,            i              ! sort variable
     $,            l              ! variable used to decide if sort is finished
     $,            ir             !           "                 "
      integer      indx(n)        ! pointer array
     $,            indxt          ! pointer used in sort
c
      character*25 carrin(n)      ! input array to be sorted
     $,            cc             ! character variable used in sort
c
c # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # #
c
      do 10  j = 1,n
         indx(j) = j
   10 continue
c
c must be > 1 element in sort list, else return
c
      if(n.le.1)  return
c
      l = n/2 + 1
      ir = n
c
   33 continue
      if(l.gt.1)  then
         l = l - 1
         indxt = indx(l)
         cc = carrin(indxt)
      else
         indxt = indx(ir)
         cc = carrin(indxt)
         indx(ir) = indx(1)
         ir = ir - 1
         if(ir.eq.1)  then
            indx(1) = indxt
            return
         end if
      end if
c
      i = l
      j = l * 2
c
   30 continue
      if(j.le.ir)  then
         if(j.lt.ir)  then
            if(carrin(indx(j)).lt.carrin(indx(j+1)))  j = j + 1
         end if
         if(cc.lt.carrin(indx(j)))  then
            indx(i) = indx(j)
            i = j
            j = j + i
         else
            j = ir + 1
         endif
      end if
c
      if(j.le.ir)  go to 30
      indx(i) = indxt
      go to 33
c
      end
c
c ###################################################################
c                            subroutine dupchek_qc
c ###################################################################
c
      subroutine dupchek_qc(numreps,max_reps,maxflt,htdif_same
     $,     c_acftreg,c_acftid,c_qc,cdtg_an
     $,     alat,alon,pres,ht_ft,t_prcn,ob_t,ob_q,ob_dir,ob_spd
     $,     xiv_t,xiv_q,xiv_d,xiv_s
     $,     idt,itype,ichk_t,ichk_q,ichk_d,ichk_s,kbadtot 
     $,     kreg,creg_reg,nobs_reg,nrej_reg,ntemp_reg,nwind_reg
     $,     indx,csort,amiss,imiss,io8,io30,l_last,l_operational,l_init
     $,     l_ncep,*)
c
c Remove duplicates from dataset
c
c Modified 8/15/01 (P.M. Pauley) to change time threshold to 90 seconds.
c 60 sec is required for AMDAR reports from different centers and for
c MDCRS-AIREP duplicates that use different rounding.  63 seconds was
c required to overcome an ISIS2000 error that led to a missing value
c for seconds being interpreted as 63.  Finally, 70 seconds is needed
c to catch position report duplicates.  The position reports can be
c up to 70 seconds out of sync with the ascent sounding data as a
c result of rounding error.
c
      implicit none
c
c Declaration statements
c ----------------------
      integer      max_reps            ! maximum number of reports
c
      character*11 c_qc(max_reps)      ! internal qc flags
c
c     Data arrays
c     -----------
      character*10 cdtg_an             ! date time group for analysis
      integer      numreps             ! actual number of reports
      integer      itype(max_reps)     ! type of aircraft data
     $,            ktype               ! pointer for instrument type 
      integer      idt(max_reps)       ! time in seconds to analysis time 
      character*8  c_acftreg(max_reps) ! aircraft registration (tail) number
      character*9  c_acftid(max_reps)  ! aircraft flight number
      real*8       alat(max_reps)      ! latitude
     $,            alon(max_reps)      ! longitude
      real         pres(max_reps)      ! pressure
     $,            ht_ft(max_reps)     ! height in feet
      real         t_prcn(max_reps)    ! temperature precision
      real         ob_t(max_reps)      ! temperature
     $,            ob_q(max_reps)      ! specific humidity
     $,            ob_dir(max_reps)    ! wind direction
     $,            ob_spd(max_reps)    ! wind speed
      real         xiv_t(max_reps)     ! temperature innovation (ob - bk)
     $,            xiv_q(max_reps)     ! specific humidity innovation (ob - bk)
     $,            xiv_d(max_reps)     ! wind direction innovation (ob - bk)
     $,            xiv_s(max_reps)     ! wind speed innovation (ob - bk)
      integer      ichk_t(max_reps)    ! NRL QC flag for temperature ob
     $,            ichk_q(max_reps)    ! NRL QC flag for specific humidity ob
     $,            ichk_d(max_reps)    ! NRL QC flag for wind direction ob
     $,            ichk_s(max_reps)    ! NRL QC flag for wind speed ob
      character*25 csort(max_reps)     ! sort variable    
c
c     Arrays for mixed duplicates
c     ---------------------------
      integer      maxflt               ! max number of flights allowed
c     x,            ndup                ! number of ids with mixed duplicates
c      character*9  c_air_id(maxflt)    ! airep flight id for mixed duplicate
ccccdak     x,            c_acr_id(maxflt)    ! acars flight id for mixed duplicate
c     x,            c_acr_id(maxflt)    ! tamdar flight id for mixed duplicate
ccccdak      character*8  c_acr_reg(maxflt)   ! acars tail number for mixed duplicate
c      character*8  c_acr_reg(maxflt)   ! tamdar tail number for mixed duplicate
c      integer      kdup(maxflt)        ! number of mixed duplicates per id pair
c     $,            idt_min(maxflt)     ! min time for flight segment
c     $,            idt_max(maxflt)     ! max time for flight segment
c
c     Pointers
c     --------
      integer      indx(max_reps)      ! pointer index for good reports
c
c     Functions
c     ---------
      character*16 c_insty_ob          ! function to convert integer instrument 
                                       !   type to character instrument type
      integer      insty_ob_fun        ! function to convert character
                                       !   instrument type to integer
c
c     Other variables
c     ---------------
      integer      io8                 ! i/o unit number for log file
      integer      io30                ! i/o unit number for rejected dups
c
      integer      imiss               ! integer missing value flag
      real         amiss               ! real missing value flag
c
      real         htdif_same          ! height difference considered negligible
      integer      idt_dif             ! time difference (current - previous)
     $,            difdir              ! difference between wind directions
c
c      integer      idt_samflt          ! time difference allowed for same flight
c     $,            min_idt,max_idt     ! limits on rel time allowed for same flight
c
      integer      iob                 ! do loop index 
     $,            ii                  ! index pointing to current report
     $,            iim1                ! index pointing to previous report
     $,            kkdup               ! do loop index 
      integer      knt                 ! counter used to define indices
     $,            knt0                !     "
     $,            knt1                !     "
      integer      isave               ! variable used to shuffle indices
     $,            kbadtot             ! total number of rejected duplicates
     $,            kbad(5,3)           ! counter for number of exact, near duplicates
c
ccccdak      integer      i_acars             ! instrument type for acars
      integer      i_acars             ! instrument type for tamdar
ccccdak     $,            i_acars_lvl         ! instrument type for acars--level flt
     $,            i_acars_lvl         ! instrument type for tamdar--level flt
ccccdak     $,            i_acars_asc         ! instrument type for acars--ascent
     $,            i_acars_asc         ! instrument type for tamdar--ascent
ccccdak     $,            i_acars_des         ! instrument type for acars--descent
     $,            i_acars_des         ! instrument type for tamdar--descent
     $,            i_mdcrs             ! instrument type for mdcrs
     $,            i_mdcrs_lvl         ! instrument type for mdcrs--level flt
     $,            i_mdcrs_asc         ! instrument type for mdcrs--ascent
     $,            i_mdcrs_des         ! instrument type for mdcrs--descent
     $,            i_man_airep         ! instrument type for manual aireps
     $,            i_man_Yairep        ! instrument type for manual aireps (YRXX)
     $,            i_airep             ! instrument type for airep
     $,            i_airep_lvl         ! instrument type for airep--level flt
     $,            i_airep_asc         ! instrument type for airep--ascent
     $,            i_airep_des         ! instrument type for airep--descent
     $,            i_amdar             ! instrument type for amdar
     $,            i_amdar_lvl         ! instrument type for amdar--level flt
     $,            i_amdar_asc         ! instrument type for amdar--ascent
     $,            i_amdar_des         ! instrument type for amdar--descent
c
      integer      n_exact             ! number of exact dups
     $,            n_exact_sh          ! number of exact dups with short ids
     $,            n_ex_sh_MaMa        !        --manAIREP-manAIREP
     $,            n_ex_sh_MaAr        !        --manAIREP-AIREP
     $,            n_ex_sh_MaMd        !        --manAIREP-MDCRS
ccccdak     $,            n_ex_sh_MaAc        !        --manAIREP-ACARS
     $,            n_ex_sh_MaAc        !        --manAIREP-TAMDAR
     $,            n_ex_sh_ArMa        !        --AIREP-manAIREP
     $,            n_ex_sh_ArAr        !        --AIREP-AIREP
     $,            n_exact_0ll         ! number of exact dups with zero lat/lon
ccccdak     $,            n_ex_0ll_AcAc       !        --ACARS-ACARS
     $,            n_ex_0ll_AcAc       !        --TAMDAR-TAMDAR
     $,            n_ex_0ll_MdMd       !        --MDCRS-MDCRS
     $,            n_ex_0ll_MaMa       !        --manAIREP-manAIREP
     $,            n_ex_0ll_MaAr       !        --manAIREP-AIREP
ccccdak     $,            n_exact_MdAc        ! number of exact dups--MDCRS-ACARS
     $,            n_exact_MdAc        ! number of exact dups--MDCRS-TAMDAR
ccccdak     $,            n_exact_AcMa        ! number of exact dups--ACARS-manAIREP
     $,            n_exact_AcMa        ! number of exact dups--TAMDAR-manAIREP
ccccdak     $,            n_exact_AcAr        ! number of exact dups--ACARS-AIREP
     $,            n_exact_AcAr        ! number of exact dups--TAMDAR-AIREP
     $,            n_exact_MdMa        ! number of exact dups--MDCRS-manAIREP
     $,            n_exact_MdAr        ! number of exact dups--MDCRS-AIREP
     $,            n_exact_AmAr        ! number of exact dups--AMDAR-AIREP
     $,            n_exact_AmMa        ! number of exact dups--AMDAR-manAIREP
     $,            n_exact_ArMa        ! number of exact dups--AIREP-manAIREP
ccccdak     $,            n_exact_AcAc        ! number of exact dups--ACARS-ACARS
     $,            n_exact_AcAc        ! number of exact dups--TAMDAR-TAMDAR
     $,            n_exact_MdMd        ! number of exact dups--MDCRS-MDCRS
     $,            n_exact_ArAr        ! number of exact dups--AIREP-AIREP
     $,            n_exact_MaMa        ! number of exact dups--manAIREP-manAIREP
     $,            n_exact_AmAm        ! number of exact dups--AMDAR-AMDAR
c
      integer      n_near              ! number of near dups
     $,            n_near_sh           ! number of near dups with short ids
     $,            n_nr_sh_MaMa        !        --manAIREP-manAIREP
     $,            n_nr_sh_MaAr        !        --manAIREP-AIREP
     $,            n_nr_sh_MaMd        !        --manAIREP-MDCRS
ccccdak     $,            n_nr_sh_MaAc        !        --manAIREP-ACARS
     $,            n_nr_sh_MaAc        !        --manAIREP-TAMDAR
     $,            n_nr_sh_ArMa        !        --AIREP-manAIREP
     $,            n_nr_sh_ArAr        !        --AIREP-AIREP
     $,            n_near_0ll          ! number of near dups with zero lat/lon
ccccdak     $,            n_nr_0ll_AcAc       !        --ACARS-ACARS
     $,            n_nr_0ll_AcAc       !        --TAMDAR-TAMDAR
     $,            n_nr_0ll_MdMd       !        --MDCRS-MDCRS
     $,            n_nr_0ll_MaAr       !        --manAIREP-AIREP
     $,            n_nr_0ll_AmAr       !        --AMDAR-AIREP
     $,            n_nr_0ll_MaMa       !        --manAIREP-manAIREP
     $,            n_nr_0ll_MaMd       !        --manAIREP-MDCRS
     $,            n_nr_0ll_MdMa       !        --MDCRS-manAIREP
     $,            n_nr_0ll_MaAm       !        --manAIREP-AMDAR
     $,            n_nr_0ll_AmMa       !        --AMDAR-manAIREP
     $,            n_near_ws           ! number of near dups with missing winds
     $,            n_nr_mswn_MaMa      !        --manAIREP-manAIREP
     $,            n_nr_mswn_MaAr      !        --manAIREP-AIREP
     $,            n_nr_mswn_MaAm      !        --manAIREP-AMDAR
     $,            n_nr_mswn_ArMa      !        --AIREP-manAIREP
     $,            n_nr_mswn_ArAr      !        --AIREP-AIREP
ccccdak     $,            n_nr_mswn_AcAc      !        --ACARS-ACARS
     $,            n_nr_mswn_AcAc      !        --TAMDAR-TAMDAR
     $,            n_nr_mswn_MdMd      !        --MDCRS-MDCRS
ccccdak     $,            n_nr_mswn_AcMd      !        --ACARS-MDCRS
     $,            n_nr_mswn_AcMd      !        --TAMDAR-MDCRS
ccccdak     $,            n_nr_mswn_MdAc      !        --MDCRS-ACARS
     $,            n_nr_mswn_MdAc      !        --MDCRS-TAMDAR
     $,            n_nr_mswn_MdAm      !        --MDCRS-AMDAR
     $,            n_nr_mswn_MdAr      !        --MDCRS-AIREP
     $,            n_nr_mswn_MdMa      !        --MDCRS-manAIREP
ccccdak     $,            n_nr_mswn_ArAc      !        --AIREP-ACARS
     $,            n_nr_mswn_ArAc      !        --AIREP-TAMDAR
     $,            n_nr_mswn_ArMd      !        --AIREP-MDCRS
ccccdak     $,            n_nr_mswn_MaAc      !        --manAIREP-ACARS
     $,            n_nr_mswn_MaAc      !        --manAIREP-TAMDAR
     $,            n_nr_mswn_MaMd      !        --manAIREP-MDCRS
     $,            n_nr_mswn_AmAm      !        --AMDAR-AMDAR
     $,            n_nr_mswn_ArAm      !        --AIREP-AMDAR
     $,            n_nr_mswn_AmAr      !        --AMDAR-AIREP
ccccdak     $,            n_nr_mswn_AcAm      !        --ACARS-AMDAR
     $,            n_nr_mswn_AcAm      !        --TAMDAR-AMDAR
     $,            n_near_ws_IT        ! number of near dups with missing winds
                                       !   and with flight # beginning with 'IT'
     $,            n_near_ws_EU        ! number of near dups with missing winds
                                       !   and with flight # beginning with 'EU'
     $,            n_near_0ws          ! number of near dups with zero winds
     $,            n_near_0ws_ArAm     !        --AIREP-AMDAR
     $,            n_near_0ws_AmAr     !        --AMDAR-AIREP
     $,            n_near_0ws_AmAm     !        --AMDAR-AMDAR
     $,            n_near_0ws_ArAr     !        --AIREP-AIREP
     $,            n_near_0ws_MaMa     !        --manAIREP-manAIREP
     $,            n_near_0ws_MaMd     !        --manAIREP-MDCRS
     $,            n_near_0ws_MaAm     !        --manAIREP-AMDAR
     $,            n_near_0ws_MaAr     !        --manAIREP-AIREP
     $,            n_near_0ws_ArMd     !        --AIREP-MDCRS
     $,            n_near_0ws_MdMd     !        --MDCRS-MDCRS
     $,            n_near_mst          ! number of near dups with missing temperature
     $,            n_nr_mst_MaMa       !        --manAIREP-manAIREP
     $,            n_nr_mst_MaAr       !        --manAIREP-AIREP
     $,            n_nr_mst_MaAm       !        --manAIREP-AMDAR
ccccdak     $,            n_nr_mst_ArAc       !        --AIREP-ACARS
     $,            n_nr_mst_ArAc       !        --AIREP-TAMDAR
     $,            n_nr_mst_ArMd       !        --AIREP-MDCRS
ccccdak     $,            n_nr_mst_MaAc       !        --manAIREP-ACARS
     $,            n_nr_mst_MaAc       !        --manAIREP-TAMDAR
     $,            n_nr_mst_MaMd       !        --manAIREP-MDCRS
     $,            n_nr_mst_MdMd       !        --MDCRS-MDCRS
     $,            n_nr_mst_ArMa       !        --manAIREP-AIREP
     $,            n_nr_mst_AmAm       !        --AMDAR-AMDAR
     $,            n_nr_mst_ArAr       !        --AIREP-AIREP
     $,            n_nr_mst_AmAr       !        --AMDAR-AIREP
     $,            n_nr_mst_ArAm       !        --AIREP-AMDAR
ccccdak     $,            n_near_MdAc         ! number of near dups--MDCRS-ACARS
     $,            n_near_MdAc         ! number of near dups--MDCRS-TAMDAR
ccccdak     $,            n_near_AcAr         ! number of near dups--ACARS-AIREP
     $,            n_near_AcAr         ! number of near dups--TAMDAR-AIREP
     $,            n_near_MdAr         ! number of near dups--MDCRS-AIREP
     $,            n_near_AmAr         ! number of near dups--AMDAR-AIREP
ccccdak     $,            n_near_AcMa         ! number of near dups--ACARS-manAIREP
     $,            n_near_AcMa         ! number of near dups--TAMDAR-manAIREP
     $,            n_near_MdMa         ! number of near dups--MDCRS-manAIREP
     $,            n_near_ArMa         ! number of near dups--AIREP-manAIREP
     $,            n_near_AmMa         ! number of near dups--AIREP-manAIREP
ccccdak     $,            n_near_AcAc         ! number of near dups--ACARS-ACARS
     $,            n_near_AcAc         ! number of near dups--TAMDAR-TAMDAR
     $,            n_near_MdMd         ! number of near dups--MDCRS-MDCRS
     $,            n_near_ArAr         ! number of near dups--AIREP-AIREP
     $,            n_near_MaMa         ! number of near dups--manAIREP-manAIREP
     $,            n_near_AmAm         ! number of near dups--AMDAR-AMDAR
     $,            n_near_negpos       ! number of near dups with neg/pos altitude
c
ccccdak      integer      n_slow_MdAc         ! number of low-wind dups--MDCRS-ACARS
      integer      n_slow_MdAc         ! number of low-wind dups--MDCRS-TAMDAR
ccccdak     $,            n_slow_AcAr         ! number of low-wind dups--ACARS-AIREP
     $,            n_slow_AcAr         ! number of low-wind dups--TAMDAR-AIREP
     $,            n_slow_MdAr         ! number of low-wind dups--MDCRS-AIREP
     $,            n_slow_AmAr         ! number of low-wind dups--AMDAR-AIREP
     $,            n_slow_ArMa         ! number of low-wind dups--AIREP-manAIREP
ccccdak     $,            n_slow_AcAc         ! number of low-wind dups--ACARS-ACARS
     $,            n_slow_AcAc         ! number of low-wind dups--TAMDAR-TAMDAR
     $,            n_slow_MdMd         ! number of low-wind dups--MDCRS-MDCRS
     $,            n_slow_ArAr         ! number of low-wind dups--AIREP-AIREP
     $,            n_slow_MaMa         ! number of low-wind dups--manAIREP-manAIREP
     $,            n_slow_AmAm         ! number of low-wind dups--AMDAR-AMDAR
c
      integer      n_bad_encode        ! number of bad-encode dups
c
      integer      n_ex_bad_roll_Md    ! number of exact bad roll angle dups--MDCRS-MDCRS
      integer      n_ex_bad_roll_Am    ! number of exact bad roll angle dups--AMDAR-AMDAR
      integer      n_nr_bad_roll_Md    ! number of near bad roll angle dups--MDCRS-MDCRS
      integer      n_nr_bad_roll_Am    ! number of near bad roll angle dups--AMDAR-AMDAR
      integer      n_nr_posrep         ! number of position report dups--MDCRS-MDCRS
c
      integer      n_xx999_Ar          ! number of aireps with missing id
     $,            n_xx999_Ma          ! number of manual aireps with missing id
     $,            n_sh_Ar             ! number of aireps with short id
     $,            n_sh_Ma             ! number of manual aireps with short id
     $,            n_00_Md             ! number of mdcrs with rounded position
     $,            n_0000_Md           ! number of mdcrs with rounded position (0,0 deg)
ccccdak     $,            n_00_Ac             ! number of acars with rounded position
     $,            n_00_Ac             ! number of tamdar with rounded position
ccccdak     $,            n_0000_Ac           ! number of acars with rounded position (0,0 deg)
     $,            n_0000_Ac           ! number of tamdar with rounded position (0,0 deg)
     $,            n_00_Ar             ! number of aireps with rounded position
     $,            n_0000_Ar           ! number of aireps with rounded position (0,0 deg)
     $,            n_00_Ma             ! number of manual aireps with rounded position
     $,            n_0000_Ma           ! number of manual aireps with rounded pos (0,0 deg)
     $,            n_00_Am             ! number of amdar with rounded position
     $,            n_0000_Am           ! number of amdar with rounded position (0,0 deg)
c
      integer      n_lat               ! latitude index
     $,            n_lon               ! longitude index
     $,            n_area_Md(19,37)    ! number of mdcrs reports by area
ccccdak     $,            n_area_Ac(19,37)    ! number of acars reports by area
     $,            n_area_Ac(19,37)    ! number of tamdar reports by area
     $,            n_area_Ar(19,37)    ! number of airep reports by area
     $,            n_area_Ma(19,37)    ! number of manual airep reports by area
     $,            n_area_Am(19,37)    ! number of amdar reports by area
     $,            n_time_Md(24)       ! number of mdcrs reports by time
ccccdak     $,            n_time_Ac(24)       ! number of acars reports by time
     $,            n_time_Ac(24)       ! number of tamdar reports by time
     $,            n_time_Ar(24)       ! number of airep reports by time
     $,            n_time_Ma(24)       ! number of manual airep reports by time
     $,            n_time_Am(24)       ! number of amdar reports by time
     $,            n_lev_Md(53)        ! number of mdcrs reports by level
ccccdak     $,            n_lev_Ac(53)        ! number of acars reports by level
     $,            n_lev_Ac(53)        ! number of tamdar reports by level
     $,            n_lev_Ar(53)        ! number of airep reports by level
     $,            n_lev_Ma(53)        ! number of manual airep reports by level
     $,            n_lev_Am(53)        ! number of amdar reports by level
     $,            klev                ! index for level
     $,            n_temp_Md(36,13)    ! number of mdcrs reports by temp, alt
ccccdak     $,            n_temp_Ac(36,13)    ! number of acars reports by temp, alt
     $,            n_temp_Ac(36,13)    ! number of tamdar reports by temp, alt
     $,            n_temp_Ar(36,13)    ! number of airep reports by temp, alt
     $,            n_temp_Ma(36,13)    ! number of manual airep reports by temp, alt
     $,            n_temp_Am(36,13)    ! number of amdar reports by temp, alt
     $,            ktemp               ! index for temperature
     $,            kalt                ! index for altitude
     $,            n_wspd_Md(40,13)    ! number of mdcrs reports by wspd, alt
ccccdak     $,            n_wspd_Ac(40,13)    ! number of acars reports by wspd, alt
     $,            n_wspd_Ac(40,13)    ! number of tamdar reports by wspd, alt
     $,            n_wspd_Ar(40,13)    ! number of airep reports by wspd, alt
     $,            n_wspd_Ma(40,13)    ! number of manual airep reports by wspd, alt
     $,            n_wspd_Am(40,13)    ! number of amdar reports by wspd, alt
     $,            kwspd               ! index for windspeed
c
ccccdak      integer      nrep_Ac             ! number of acars reports considered
      integer      nrep_Ac             ! number of tamdar reports considered
     $,            nrep_Md             ! number of mdcrs reports considered
     $,            nrep_Ma             ! number of manual airep reports considered
     $,            nrep_Ar             ! number of airep reports considered
     $,            nrep_Am             ! number of amdar reports considered
ccccdak     $,            nbad_Ac             ! number of bad acars
     $,            nbad_Ac             ! number of bad tamdar
     $,            nbad_Md             ! number of bad mdcrs
     $,            nbad_Ma             ! number of bad manual aireps
     $,            nbad_Ar             ! number of bad aireps
     $,            nbad_Am             ! number of bad amdar 
ccccdak     $,            ndup_Ac             ! number of duplicate acars 
     $,            ndup_Ac             ! number of duplicate tamdar 
     $,            ndup_Md             ! number of duplicate mdcrs
     $,            ndup_Ma             ! number of duplicate manual aireps
     $,            ndup_Ar             ! number of duplicate aireps
     $,            ndup_Am             ! number of duplicate amdar
c
      integer      kk                  ! index pointing to current flight
c     $,            kk1                 ! index pointing to current flight
c     $,            kmap                ! number of re-mapped flight ids
     $,            ihr_an              ! hour of analysis
     $,            ihr_ob              ! hour of observation
c
c     Tail number statistics
c     ----------------------
      integer      kreg                ! actual number of tail#s in dataset
     $,            mm                  ! index pointing to current tail number
      character*8  creg_reg(maxflt)    ! tail numbers
      integer      nobs_reg(maxflt,5)  ! number of reports per tail# per type
      integer      nrej_reg(maxflt,5)  ! number of reports rejected per tail#
      integer      ntemp_reg(maxflt,5) ! number of reports w. rejected temp
      integer      nwind_reg(maxflt,5) ! number of reports w. rejected winds
c
c     Switches
c     --------
      logical      l_print             ! print values if true
     $,            l_ii_sh             ! true if ii rep has short id
     $,            l_iim1_sh           ! true if iim1 rep has short id
     $,            l_ii_0lat           ! true if ii rep has zero latitude 
     $,            l_iim1_0lat         ! true if iim1 rep has zero latitude
     $,            l_ii_0lon           ! true if ii rep has zero latitude 
     $,            l_iim1_0lon         ! true if iim1 rep has zero latitude
ccccdak     $,            l_ii_acars          ! true if ii rep is type acars
     $,            l_ii_acars          ! true if ii rep is type tamdar
ccccdak     $,            l_iim1_acars        ! true if iim1 rep is type acars
     $,            l_iim1_acars        ! true if iim1 rep is type tamdar
     $,            l_ii_mdcrs          ! true if ii rep is type mdcrs
     $,            l_iim1_mdcrs        ! true if iim1 rep is type mdcrs
     $,            l_ii_airep          ! true if ii rep is type airep
     $,            l_iim1_airep        ! true if iim1 rep is type airep
     $,            l_ii_man            ! true if ii rep is type manual airep
     $,            l_iim1_man          ! true if iim1 rep is type manual airep
     $,            l_ii_amdar          ! true if ii rep is type amdar
     $,            l_iim1_amdar        ! true if iim1 rep is type amdar
     $,            l_last              ! true if last time subroutine is called
     $,            l_save_dups         ! save dups if true
     $,            l_operational       ! run QC in operational mode if true
     $,            l_init              ! initialize counters if true
c     $,            l_ual_all           ! true if all remapped ids are UAL acft
     $,            l_ncep              ! run QC w/ NCEP preferences if true
c
      data l_save_dups/ .false. /
c
c # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # #
c
c Initialize variables
c --------------------
c      ndup = 0
      nrej_reg = 0
      ntemp_reg = 0
      nwind_reg = 0
c
c Initialize aircraft data types
c ------------------------------
      i_acars      = insty_ob_fun('acars')
      i_acars_lvl  = insty_ob_fun('acars_lvl') 
      i_acars_asc  = insty_ob_fun('acars_asc') 
      i_acars_des  = insty_ob_fun('acars_des') 
      i_mdcrs      = insty_ob_fun('mdcrs')
      i_mdcrs_lvl  = insty_ob_fun('mdcrs_lvl') 
      i_mdcrs_asc  = insty_ob_fun('mdcrs_asc') 
      i_mdcrs_des  = insty_ob_fun('mdcrs_des')
      i_man_airep  = insty_ob_fun('man-airep') 
      i_man_Yairep = insty_ob_fun('man-Yairep') 
      i_airep      = insty_ob_fun('airep')
      i_airep_lvl  = insty_ob_fun('airep_lvl')
      i_airep_asc  = insty_ob_fun('airep_asc')
      i_airep_des  = insty_ob_fun('airep_des')
      i_amdar      = insty_ob_fun('amdar')
      i_amdar_lvl  = insty_ob_fun('amdar_lvl')
      i_amdar_asc  = insty_ob_fun('amdar_asc')
      i_amdar_des  = insty_ob_fun('amdar_des')
c
c Initialize counters
c -------------------
      if(l_init) then
c
        n_exact = 0
        n_exact_sh = 0
        n_ex_sh_MaMa = 0
        n_ex_sh_MaAr = 0
        n_ex_sh_MaMd = 0
        n_ex_sh_MaAc = 0
        n_ex_sh_ArMa = 0
        n_ex_sh_ArAr = 0
        n_exact_0ll = 0
        n_ex_0ll_AcAc = 0
        n_ex_0ll_MdMd = 0
        n_ex_0ll_MaMa = 0
        n_ex_0ll_MaAr = 0
        n_exact_MdAc = 0
        n_exact_AcMa = 0
        n_exact_AcAr = 0
        n_exact_MdMa = 0
        n_exact_MdAr = 0
        n_exact_AmAr = 0
        n_exact_AmMa = 0
        n_exact_ArMa = 0
        n_exact_AcAc = 0
        n_exact_MdMd = 0
        n_exact_ArAr = 0
        n_exact_MaMa = 0
        n_exact_AmAm = 0
c
        n_near = 0
        n_near_sh = 0
        n_nr_sh_MaMa = 0
        n_nr_sh_MaAr = 0
        n_nr_sh_MaMd = 0
        n_nr_sh_MaAc = 0
        n_nr_sh_ArMa = 0
        n_nr_sh_ArAr = 0
        n_near_0ll = 0
        n_nr_0ll_AcAc = 0
        n_nr_0ll_MdMd = 0
        n_nr_0ll_MaAr = 0
        n_nr_0ll_AmAr = 0
        n_nr_0ll_MaMa = 0
        n_nr_0ll_MaMd = 0
        n_nr_0ll_MdMa = 0
        n_nr_0ll_MaAm = 0
        n_nr_0ll_AmMa = 0
        n_near_ws = 0
        n_nr_mswn_MaMa = 0
        n_nr_mswn_MaAr = 0
        n_nr_mswn_MaAm = 0
        n_nr_mswn_ArMa = 0
        n_nr_mswn_ArAr = 0
        n_nr_mswn_AcAc = 0
        n_nr_mswn_MdMd = 0
        n_nr_mswn_AcMd = 0
        n_nr_mswn_MdAc = 0
        n_nr_mswn_MdAm = 0
        n_nr_mswn_MdAr = 0
        n_nr_mswn_MdMa = 0
        n_nr_mswn_ArAc = 0
        n_nr_mswn_ArMd = 0
        n_nr_mswn_MaAc = 0
        n_nr_mswn_MaMd = 0
        n_nr_mswn_AmAm = 0
        n_nr_mswn_ArAm = 0
        n_nr_mswn_AmAr = 0
        n_nr_mswn_AcAm = 0
        n_near_ws_IT = 0
        n_near_ws_EU = 0
        n_near_0ws = 0
        n_near_0ws_ArAm = 0
        n_near_0ws_AmAr = 0
        n_near_0ws_AmAm = 0
        n_near_0ws_ArAr = 0
        n_near_0ws_MaMa = 0
        n_near_0ws_MaMd = 0
        n_near_0ws_MaAm = 0
        n_near_0ws_MaAr = 0
        n_near_0ws_ArMd = 0
        n_near_0ws_MdMd = 0
        n_near_mst = 0
        n_nr_mst_MaMa = 0
        n_nr_mst_MaAr = 0
        n_nr_mst_MaAm = 0
        n_nr_mst_ArAc = 0
        n_nr_mst_ArMd = 0
        n_nr_mst_MaAc = 0
        n_nr_mst_MaMd = 0
        n_nr_mst_MdMd = 0
        n_nr_mst_ArMa = 0
        n_nr_mst_AmAm = 0
        n_nr_mst_ArAr = 0
        n_nr_mst_AmAr = 0
        n_nr_mst_ArAm = 0
        n_near_MdAc = 0
        n_near_AcAr = 0
        n_near_MdAr = 0
        n_near_AmAr = 0
        n_near_AcMa = 0
        n_near_MdMa = 0
        n_near_ArMa = 0
        n_near_AmMa = 0
        n_near_AcAc = 0
        n_near_MdMd = 0
        n_near_ArAr = 0
        n_near_MaMa = 0
        n_near_AmAm = 0
        n_near_negpos = 0
        n_slow_MdAc = 0
        n_slow_AcAr = 0
        n_slow_MdAr = 0
        n_slow_AmAr = 0
        n_slow_ArMa = 0
        n_slow_AcAc = 0
        n_slow_MdMd = 0
        n_slow_ArAr = 0
        n_slow_MaMa = 0
        n_slow_AmAm = 0
c
        n_bad_encode = 0
c
        n_ex_bad_roll_Md = 0
        n_ex_bad_roll_Am = 0
        n_nr_bad_roll_Md = 0
        n_nr_bad_roll_Am = 0
        n_nr_posrep = 0
c
        n_xx999_Ar = 0
        n_xx999_Ma = 0
        n_sh_Ar = 0
        n_sh_Ma = 0
        n_00_Md = 0
        n_0000_Md = 0
        n_00_Ac = 0
        n_0000_Ac = 0
        n_00_Ar = 0
        n_0000_Ar = 0
        n_00_Ma = 0
        n_0000_Ma = 0
        n_00_Am = 0
        n_0000_Am = 0
c
        n_area_Md = 0
        n_area_Ac = 0
        n_area_Ar = 0
        n_area_Ma = 0
        n_area_Am = 0
c
        n_time_Md = 0
        n_time_Ac = 0
        n_time_Ar = 0
        n_time_Ma = 0
        n_time_Am = 0
c
        n_lev_Md = 0
        n_lev_Ac = 0
        n_lev_Ar = 0
        n_lev_Ma = 0
        n_lev_Am = 0
c
        n_temp_Md = 0
        n_temp_Ac = 0
        n_temp_Ar = 0
        n_temp_Ma = 0
        n_temp_Am = 0
c
        n_wspd_Md = 0
        n_wspd_Ac = 0
        n_wspd_Ar = 0
        n_wspd_Ma = 0
        n_wspd_Am = 0
c
        nrep_Ac = 0
        nrep_Md = 0
        nrep_Ma = 0
        nrep_Ar = 0
        nrep_Am = 0
        nbad_Ac = 0
        nbad_Md = 0
        nbad_Ma = 0
        nbad_Ar = 0
        nbad_Am = 0
        ndup_Ac = 0
        ndup_Md = 0
        ndup_Ma = 0
        ndup_Ar = 0
        ndup_Am = 0
      endif
c
      read(cdtg_an,'(8x,i2)') ihr_an
c
c Begin loop over reports
c -----------------------
      do iob = 1,numreps
c
c Initialize indices
c ------------------
        ii   = indx(iob)
        knt0 = iob
        knt  = iob
        if(iob.gt.1) then
          iim1 = indx(iob-1)
        else
          iim1 = 0
        endif
c
        if(iob.eq.1.and.c_qc(ii)(1:1).eq.'-') c_qc(ii)(1:1) = 'N'
c
c Set ktype
c ---------
        if(itype(ii).eq.i_mdcrs_lvl.or.
     $     itype(ii).eq.i_mdcrs_asc.or.
     $     itype(ii).eq.i_mdcrs_des.or.
     $     itype(ii).eq.i_mdcrs) then 
          ktype = 1
c
        elseif(itype(ii).eq.i_acars_lvl.or.
     $         itype(ii).eq.i_acars_asc.or.
     $         itype(ii).eq.i_acars_des.or.
     $         itype(ii).eq.i_acars) then 
          ktype = 2
c
        elseif(itype(ii).eq.i_amdar_lvl.or.
     $         itype(ii).eq.i_amdar_asc.or.
     $         itype(ii).eq.i_amdar_des.or.
     $         itype(ii).eq.i_amdar) then 
          ktype = 3
c
        elseif(itype(ii).eq.i_airep_lvl.or.
     $         itype(ii).eq.i_airep_asc.or.
     $         itype(ii).eq.i_airep_des.or.
     $         itype(ii).eq.i_airep) then
          ktype = 4
c
        elseif(itype(ii).eq.i_man_airep.or.
     $         itype(ii).eq.i_man_Yairep) then
          ktype = 5
        endif
c
c       Examine the data distribution
c       -----------------------------
c
c       Count UA reports with short ids
c       -------------------------------
        if(c_acftid(ii)(1:2).eq.'UA'.and.
     $     c_acftid(ii)(3:3).ne.'L'.and.
     $     ktype.eq.4)then 
          n_sh_Ar = n_sh_Ar + 1
c
        elseif(c_acftid(ii)(1:2).eq.'UA'.and.
     $         c_acftid(ii)(3:3).ne.'L'.and.
     $         ktype.eq.5) then 
          n_sh_Ma = n_sh_Ma + 1
        endif
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
c
c       Count reports with lat and lon in whole degrees
c       (Count positions of 0.0 lat and 0.0 lon separately)
c       ---------------------------------------------------
        if((abs(alat(ii)-float(int(alat(ii)))).lt.0.001).and.
     $     (abs(alon(ii)-float(int(alon(ii)))).lt.0.001)) then
c
          if(ktype.eq.1) then 
            if(abs(alat(ii)).lt.0.001.and.
     $         abs(alon(ii)).lt.0.001) then
              n_0000_Md = n_0000_Md + 1
            else 
              n_00_Md = n_00_Md + 1
            endif
          elseif(ktype.eq.2) then 
            if(abs(alat(ii)).lt.0.001.and.
     $         abs(alon(ii)).lt.0.001) then
              n_0000_Ac = n_0000_Ac + 1
            else 
              n_00_Ac = n_00_Ac + 1
            endif
          elseif(ktype.eq.3) then 
            if(abs(alat(ii)).lt.0.001.and.
     $         abs(alon(ii)).lt.0.001) then
              n_0000_Am = n_0000_Am + 1
            else 
              n_00_Am = n_00_Am + 1
            endif
          elseif(ktype.eq.4) then
            if(abs(alat(ii)).lt.0.001.and.
     $         abs(alon(ii)).lt.0.001) then
              n_0000_Ar = n_0000_Ar + 1
            else 
              n_00_Ar = n_00_Ar + 1
            endif
          elseif(ktype.eq.5) then
            if(abs(alat(ii)).lt.0.001.and.
     $         abs(alon(ii)).lt.0.001) then
              n_0000_Ma = n_0000_Ma + 1
            else 
              n_00_Ma = n_00_Ma + 1
            endif
          endif
        endif
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
c
c       Count reports by geographic area
c       --------------------------------
        n_lat = int(alat(ii))/10 + 10
        n_lon = int(alon(ii))/10 + 1
c
        if(ktype.eq.1) then 
          n_area_Md(n_lat,n_lon) = n_area_Md(n_lat,n_lon) + 1
c
        elseif(ktype.eq.2) then 
          n_area_Ac(n_lat,n_lon) = n_area_Ac(n_lat,n_lon) + 1
c
        elseif(ktype.eq.3) then 
          n_area_Am(n_lat,n_lon) = n_area_Am(n_lat,n_lon) + 1
c
        elseif(ktype.eq.4) then
          n_area_Ar(n_lat,n_lon) = n_area_Ar(n_lat,n_lon) + 1
c
        elseif(ktype.eq.5) then
          n_area_Ma(n_lat,n_lon) = n_area_Ma(n_lat,n_lon) + 1
        endif
c
c       Count reports by time
c       ---------------------
        ihr_ob = idt(ii) + ihr_an * 3600
        if(ihr_ob.lt.0) then
          ihr_ob = (24 * 3600) + ihr_ob
        endif
        ihr_ob = ihr_ob / 3600
        if(ihr_ob.lt.0.or.ihr_ob.gt.23) then
          if(l_ncep) then
! DAK - NCEP runs centered at 21z (NDAS/RAP), 22z (RAP) and 23z (RAP) have many obs with
!       ihr_ob > 23 since obs at the tail end of the time window radius move into the next
!       day - so, if ihr_ob is 24-29, change to 00-05 to avoid array overflow here
            if(ihr_ob.gt.23.and.ihr_ob.le.29) ihr_ob = ihr_ob - 24
          else
            write(io8,*) 'Bad ihr_ob = ',ihr_ob, ihr_an, idt(ii), ii,
     $       iob, c_acftid(ii), alat(ii), alon(ii), ht_ft(ii)
          endif
        endif
c
        if(ktype.eq.1) then 
          n_time_Md(ihr_ob+1) = n_time_Md(ihr_ob+1) + 1
c
        elseif(ktype.eq.2) then 
          n_time_Ac(ihr_ob+1) = n_time_Ac(ihr_ob+1) + 1
c
        elseif(ktype.eq.3) then 
          n_time_Am(ihr_ob+1) = n_time_Am(ihr_ob+1) + 1
c
        elseif(ktype.eq.4) then
          n_time_Ar(ihr_ob+1) = n_time_Ar(ihr_ob+1) + 1
c
        elseif(ktype.eq.5) then
          n_time_Ma(ihr_ob+1) = n_time_Ma(ihr_ob+1) + 1
        endif
c
c       Count reports by level, temperature, and windspeed
c       --------------------------------------------------
        if(ht_ft(ii).lt.0) then
          klev = 53
        elseif(ht_ft(ii).gt.50 000) then
          klev = 52
        else
          klev = ifix(ht_ft(ii)+500.) / 1000 + 1
        endif
c
        if(ht_ft(ii).lt.0) then
          kalt = 13
        elseif(ht_ft(ii).gt.50 000) then
          kalt = 12
        else
          kalt = ifix(ht_ft(ii)) / 5000 + 1
        endif
c
        if(ob_t(ii).eq.amiss) then
          ktemp = 36
        elseif(ob_t(ii).lt.173.16) then
          ktemp = 35 
        elseif(ob_t(ii).gt.333.16) then
          ktemp = 34
        else
          ktemp = (ob_t(ii)-173.16) / 5 + 1
        endif
c
        if(ob_spd(ii).eq.amiss) then
          kwspd = 40
        elseif(ob_spd(ii).lt.0) then
          kwspd = 39 
        elseif(ob_spd(ii).gt.180) then
          kwspd = 38
        else
          kwspd = ob_spd(ii) / 5 + 1
        endif
c
        if(ktype.eq.1) then 
          n_lev_Md(klev) = n_lev_Md(klev) + 1
          n_temp_Md(ktemp,kalt) = n_temp_Md(ktemp,kalt) + 1
          n_wspd_Md(kwspd,kalt) = n_wspd_Md(kwspd,kalt) + 1
c
        elseif(ktype.eq.2) then 
          n_lev_Ac(klev) = n_lev_Ac(klev) + 1
          n_temp_Ac(ktemp,kalt) = n_temp_Ac(ktemp,kalt) + 1
          n_wspd_Ac(kwspd,kalt) = n_wspd_Ac(kwspd,kalt) + 1
c
        elseif(ktype.eq.3) then 
          n_lev_Am(klev) = n_lev_Am(klev) + 1
          n_temp_Am(ktemp,kalt) = n_temp_Am(ktemp,kalt) + 1
          n_wspd_Am(kwspd,kalt) = n_wspd_Am(kwspd,kalt) + 1
c
        elseif(ktype.eq.4) then
          n_lev_Ar(klev) = n_lev_Ar(klev) + 1
          n_temp_Ar(ktemp,kalt) = n_temp_Ar(ktemp,kalt) + 1
          n_wspd_Ar(kwspd,kalt) = n_wspd_Ar(kwspd,kalt) + 1
c
        elseif(ktype.eq.5) then
          n_lev_Ma(klev) = n_lev_Ma(klev) + 1
          n_temp_Ma(ktemp,kalt) = n_temp_Ma(ktemp,kalt) + 1
          n_wspd_Ma(kwspd,kalt) = n_wspd_Ma(kwspd,kalt) + 1
        endif
c
c       Count reports with missing ids
c       ------------------------------
        if(c_acftid(ii)(1:5).eq.'XX999'.or.
     $     c_acftid(ii)(1:4).eq.'////') then
c
          if(ktype.eq.4) then 
            n_xx999_Ar = n_xx999_Ar + 1
c
          elseif(ktype.eq.5) then
            n_xx999_Ma = n_xx999_Ma + 1
          endif
c
        endif
c
c Check for duplicates--uses algorithm like P. Phoebus's airepd
c Checks tail number, date-time, lat/lon, flight level, temp, winds
c -----------------------------------------------------------------
c        idt_dif = idt(ii) - idt(iim1)
c
        idt_dif = 0
        kkdup = 0
c
c       Repeat check for all reports within 90 sec
c       (90 sec used to check for dups with position reports--8/15/01)
c       --------------------------------------------------------------
c        do while(idt_dif.eq.0.and.
c
        do while(idt_dif.le.90.and.
     $           idt_dif.ne.imiss.and.
     $           iim1.ne.0)
c
c         Initialize print switch
c         -----------------------
          l_print = .false.
c
c         Compute index for previous report
c         ---------------------------------
          knt = knt - 1
 10       if(knt.gt.0) then
            iim1 = indx(knt)
            knt1 = knt
            if(c_qc(iim1)(1:1).eq.'D'.or.
     $         c_qc(iim1)(1:1).eq.'d'.or.
     $         c_qc(iim1)(1:1).eq.'e'.or.
     $         c_qc(iim1)(1:1).eq.'E'.or.
     $         c_qc(iim1)(1:1).eq.'B') then
              knt = knt - 1
              goto 10
            endif
          else
            iim1 = 0
            knt1 = 0
          endif
c
c         Perform check only for valid iim1
c         ---------------------------------
          if(iim1.ne.0) then
c
c           Compute time difference between reports
c           (Allow a time difference of up to 60 sec--
c            dups may have a time difference of 1 min)
c           (changed to 90 sec--6/5/01)
c           ------------------------------------------
            idt_dif = idt(ii) - idt(iim1)
c
            kkdup = kkdup + 1          
c
c           Set up logical variables used in testing for duplicates
c           -------------------------------------------------------
c
c           iim1 report has short id?
c           -------------------------
            l_iim1_sh = .false.
            if(itype(iim1).eq.i_man_airep.or.
     $         itype(iim1).eq.i_man_Yairep) then
c
              if(c_acftid(iim1)(1:8).eq.c_acftid(ii)(1:8)) then
                l_iim1_sh = .false.
              elseif(c_acftid(ii)(1:3).eq.'UAL') then
                if(c_acftid(iim1)(1:2).eq.'UA'.and. 
     $             c_acftid(iim1)(3:3).ne.'L') then
                  l_iim1_sh = .true.
                else
                  l_iim1_sh = .false.
                endif
              elseif(c_acftid(iim1)(1:6).eq.c_acftid(ii)(1:6).and. 
     $               c_acftid(ii)  (7:7).ne.' '.and.
     $               c_acftid(iim1)(7:7).eq.' ') then
                l_iim1_sh = .true.
              elseif(c_acftid(iim1)(1:6).eq.
     $               c_acftid(ii)(2:7)) then 
                l_iim1_sh = .true.
              elseif(c_acftid(iim1)(1:6).eq.
     $               c_acftid(ii)(1:2)//c_acftid(ii)(4:7)) then 
                l_iim1_sh = .true.
              elseif(c_acftid(iim1)(1:6).eq.
     $               c_acftid(ii)(1:3)//c_acftid(ii)(5:7)) then 
                l_iim1_sh = .true.
              endif
            endif
c
c           ii report has short id?
c           -----------------------
            l_ii_sh = .false.
            if(itype(ii).eq.i_man_airep.or.
     $         itype(ii).eq.i_man_Yairep) then
c
              if(c_acftid(iim1)(1:8).eq.c_acftid(ii)(1:8)) then
                l_ii_sh = .false.
              elseif(c_acftid(iim1)(1:3).eq.'UAL') then
                if(c_acftid(ii)(1:2).eq.'UA'.and. 
     $             c_acftid(ii)(3:3).ne.'L') then
                  l_ii_sh = .true.
                else
                  l_ii_sh = .false.
                endif
              elseif(c_acftid(iim1)(1:6).eq.c_acftid(ii)(1:6).and. 
     $               c_acftid(iim1)(7:7).ne.' '.and.
     $               c_acftid(ii)  (7:7).eq.' ') then
                l_ii_sh = .true.
              elseif(c_acftid(ii)(1:6).eq.
     $               c_acftid(iim1)(2:7)) then 
                l_ii_sh = .true.
              elseif(c_acftid(ii)(1:6).eq.
     $               c_acftid(iim1)(1:2)//c_acftid(iim1)(4:7)) then 
                l_ii_sh = .true.
              elseif(c_acftid(ii)(1:6).eq.
     $               c_acftid(iim1)(1:3)//c_acftid(iim1)(5:7)) then
                l_ii_sh = .true.
              endif
            endif
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
c
c           iim1 report has zero latitude?
c           ------------------------------
            l_iim1_0lat = .false.
            if(abs(alat(iim1)).lt.0.001.and.
     $         alat(ii).gt.0.125.and.
     $         alat(ii).lt.359.875)
     $        l_iim1_0lat = .true.
c
c           ii report has zero latitude?
c           ----------------------------
            l_ii_0lat = .false.
            if(abs(alat(ii)).lt.0.001.and.
     $         alat(iim1).gt.0.125.and.
     $         alat(iim1).lt.359.875)
     $        l_ii_0lat = .true.
c
c           iim1 report has zero longitude?
c           -------------------------------
            l_iim1_0lon = .false.
            if(abs(alon(iim1)).lt.0.001.and.
     $         alon(ii).gt.0.125.and.
     $         alon(ii).lt.359.875)
     $        l_iim1_0lon = .true.
c
c           ii report has zero longitude?
c           -----------------------------
            l_ii_0lon = .false.
            if(abs(alon(ii)).lt.0.001.and.
     $         alon(iim1).gt.0.125.and.
     $         alon(iim1).lt.359.875)
     $        l_ii_0lon = .true.
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
c
ccccdak           iim1 report is ACARS?
c           iim1 report is TAMDAR?
c           ----------------------
            l_iim1_acars = .false.
            if(itype(iim1).eq.i_acars.or.
     $         itype(iim1).eq.i_acars_lvl.or.
     $         itype(iim1).eq.i_acars_des.or.
     $         itype(iim1).eq.i_acars_asc) l_iim1_acars = .true.
c
ccccdak           ii report is ACARS?
c           ii report is TAMDAR?
c           --------------------
            l_ii_acars = .false.
            if(itype(ii).eq.i_acars.or.
     $         itype(ii).eq.i_acars_lvl.or.
     $         itype(ii).eq.i_acars_des.or.
     $         itype(ii).eq.i_acars_asc) l_ii_acars = .true.
c
c           iim1 report is MDCRS?
c           ---------------------
            l_iim1_mdcrs = .false.
            if(itype(iim1).eq.i_mdcrs.or.
     $         itype(iim1).eq.i_mdcrs_lvl.or.
     $         itype(iim1).eq.i_mdcrs_des.or.
     $         itype(iim1).eq.i_mdcrs_asc) l_iim1_mdcrs = .true.
c
c           ii report is MDCRS?
c           -------------------
            l_ii_mdcrs = .false.
            if(itype(ii).eq.i_mdcrs.or.
     $         itype(ii).eq.i_mdcrs_lvl.or.
     $         itype(ii).eq.i_mdcrs_des.or.
     $         itype(ii).eq.i_mdcrs_asc) l_ii_mdcrs = .true.
c
c           iim1 report is AIREP?
c           ---------------------
            l_iim1_airep = .false.
            if(itype(iim1).eq.i_airep.or.
     $         itype(iim1).eq.i_airep_lvl.or.
     $         itype(iim1).eq.i_airep_des.or.
     $         itype(iim1).eq.i_airep_asc) l_iim1_airep = .true.
c
c           ii report is AIREP?
c           -------------------
            l_ii_airep = .false.
            if(itype(ii).eq.i_airep.or.
     $         itype(ii).eq.i_airep_lvl.or.
     $         itype(ii).eq.i_airep_des.or.
     $         itype(ii).eq.i_airep_asc) l_ii_airep = .true.
c
c           iim1 report is manual AIREP?
c           ----------------------------
            l_iim1_man = .false.
            if(itype(iim1).eq.i_man_airep.or.
     $         itype(iim1).eq.i_man_Yairep) l_iim1_man = .true.
c
c           ii report is manual AIREP?
c           --------------------------
            l_ii_man = .false.
            if(itype(ii).eq.i_man_airep.or.
     $         itype(ii).eq.i_man_Yairep) l_ii_man = .true.
c
c           iim1 report is AMDAR?
c           ---------------------
            l_iim1_amdar = .false.
            if(itype(iim1).eq.i_amdar.or.
     $         itype(iim1).eq.i_amdar_lvl.or.
     $         itype(iim1).eq.i_amdar_des.or.
     $         itype(iim1).eq.i_amdar_asc) l_iim1_amdar = .true.
c
c           ii report is AMDAR?
c           -------------------
            l_ii_amdar = .false.
            if(itype(ii).eq.i_amdar.or.
     $         itype(ii).eq.i_amdar_lvl.or.
     $         itype(ii).eq.i_amdar_des.or.
     $         itype(ii).eq.i_amdar_asc) l_ii_amdar = .true.
c
c           Compute magnitude of direction difference
c           (constrain to be less than 180 deg
c           -----------------------------------------
            if(ob_dir(ii).eq.amiss.or.
     $         ob_dir(iim1).eq.amiss) then
              difdir = amiss
            else
              difdir = abs(ob_dir(iim1)-ob_dir(ii))
              if(difdir.gt.180) difdir = 360. - difdir
            endif
c
c           Check if report is exact dup (qc flag = 'D')
c           --------------------------------------------
            if(idt_dif.eq.0) then
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
              if((abs(alat(iim1)-alat(ii)).lt.0.015.or.
     $            l_iim1_0lat.or.l_ii_0lat).and.
     $           (abs(alon(iim1)-alon(ii)).lt.0.015.or.
     $            l_iim1_0lon.or.l_ii_0lon).and.
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
     $           (abs(pres(iim1)-pres(ii)).lt.0.05.or.
     $            abs(ht_ft(iim1)-ht_ft(ii)).lt.0.5).and.
     $           abs(ob_t(iim1)-ob_t(ii)).lt.0.05.and.
     $           ((abs(difdir).lt.2.5).or.
     $            (ob_dir(iim1).eq.amiss.and.ob_dir(ii).eq.amiss)).and.
     $           abs(ob_spd(iim1)-ob_spd(ii)).lt.0.05) then
c
c               If exact dup found, decide which report to keep:
ccccdak                 Choose MDCRS over ACARS
c                 Choose MDCRS over TAMDAR
ccccdak                 Choose ACARS/MDCRS over AIREP
c                 Choose TAMDAR or MDCRS over AIREP
c                 Choose AMDAR over AIREP
c                 Choose automated over manual AIREP
c                 Choose 7-char flight number over 6-char flight number
c                 Choose present over missing flight/tail number
c                 Choose non-zero over zero lat or lon
c               -------------------------------------------------------
c
c               Keep ob ii
c               ----------
                if((l_ii_mdcrs.and.l_iim1_acars).or.
     $             (l_ii_acars.and.l_iim1_airep).or.
     $             (l_ii_mdcrs.and.l_iim1_airep).or.
     $             (l_ii_amdar.and.l_iim1_airep).or.
     $             (l_ii_mdcrs.and.l_iim1_man  ).or.
     $             (l_ii_acars.and.l_iim1_man  ).or.
     $             (l_ii_amdar.and.l_iim1_man  ).or.
     $             (l_ii_airep.and.l_iim1_man  ).or.
     $             l_iim1_sh.or.
     $             l_iim1_0lat.or.
     $             l_iim1_0lon) then
c
                  if(c_qc(iim1)(1:1).eq.'-'.or.
     $               c_qc(iim1)(1:1).eq.'.'.or.
     $               c_qc(iim1)(1:1).eq.'N')  
     $               c_qc(iim1)(1:1) = 'D'
c
                  if(c_qc(ii)(1:1).eq.'-') c_qc(ii)(1:1) = '.'
c
c                 Count rejects by category
c                 -------------------------
                  n_exact = n_exact + 1
c
                  if(l_iim1_sh) then
                    n_exact_sh = n_exact_sh + 1
                    l_print = .true.
                    if(l_print) then
                      write(io8,*)
                      write(io8,*)'Exact dup found with short id--'
     $,                            ii
                    endif
                    if(l_iim1_man.and.l_ii_man) then
                      n_ex_sh_MaMa = n_ex_sh_MaMa + 1
                      if(l_print) 
     $                  write(io8,*) 'manAIREP-manAIREP dup'
                    elseif(l_iim1_man.and.l_ii_airep) then 
                      n_ex_sh_MaAr = n_ex_sh_MaAr + 1
                      if(l_print) write(io8,*) 'manAIREP-AIREP dup'
                    elseif(l_iim1_man.and.l_ii_mdcrs) then 
                      n_ex_sh_MaMd = n_ex_sh_MaMd + 1
                      if(l_print) write(io8,*) 'manAIREP-MDCRS dup'
                    elseif(l_iim1_man.and.l_ii_acars) then 
                      n_ex_sh_MaAc = n_ex_sh_MaAc + 1
ccccdak                      if(l_print) write(io8,*) 'manAIREP-ACARS dup'
                      if(l_print) write(io8,*) 'manAIREP-TAMDAR dup'
                    elseif(l_ii_man.and.l_iim1_airep) then 
                      n_ex_sh_ArMa = n_ex_sh_ArMa + 1
                      if(l_print) write(io8,*) 'AIREP-manAIREP dup'
                    elseif(l_iim1_airep.and.l_ii_airep) then 
                      n_ex_sh_ArAr = n_ex_sh_ArAr + 1
                      if(l_print) write(io8,*) 'AIREP-AIREP dup'
                    else
                      l_print = .true.
                      if(l_print) then
                        write(io8,*)
                        write(io8,*)'Uncategorized short-id dup'
                      endif
                    endif
c
                  elseif(l_iim1_0lat.or.l_iim1_0lon) then
                    n_exact_0ll = n_exact_0ll + 1
                    l_print = .false.
                    if(l_print) then
                      write(io8,*)
                      write(io8,*) 'Exact dup found with 0l/l--',ii
                    endif
                    if(l_iim1_acars.and.l_ii_acars) then
                      n_ex_0ll_AcAc = n_ex_0ll_AcAc + 1
ccccdak                      if(l_print) write(io8,*) 'ACARS-ACARS dup'
                      if(l_print) write(io8,*) 'TAMDAR-TAMDAR dup'
                    elseif(l_iim1_mdcrs.and.l_ii_mdcrs) then
                      n_ex_0ll_MdMd = n_ex_0ll_MdMd + 1
                      if(l_print) write(io8,*) 'MDCRS-MDCRS dup'
                    elseif(l_iim1_man.and.l_ii_man) then
                      n_ex_0ll_MaMa = n_ex_0ll_MaMa + 1
                      if(l_print) 
     $                  write(io8,*) 'manAIREP-manAIREP dup'
                    elseif(l_iim1_man.and.l_ii_airep) then
                      n_ex_0ll_MaAr = n_ex_0ll_MaAr + 1
                      if(l_print) write(io8,*) 'manAIREP-AIREP dup'
                    else
                      l_print = .true.
                      if(l_print) then
                        write(io8,*)
                        write(io8,*) 'Uncategorized exact 0l/l dup'
                      endif
                    endif
c
                  elseif(l_ii_mdcrs.and.l_iim1_acars) then
                    n_exact_MdAc = n_exact_MdAc + 1
                    l_print = .false.
                    if(l_print) then
                      write(io8,*)
ccccdak                      write(io8,*) 'MDCRS-ACARS exact dup found--'
                      write(io8,*) 'MDCRS-TAMDAR exact dup found--'
     x,                             ii
                    endif
c
                  elseif(l_ii_acars.and.l_iim1_man) then
                    n_exact_AcMa = n_exact_AcMa + 1
                    l_print = .false.
                    if(l_print) then
                      write(io8,*)
ccccdak                      write(io8,*) 'ACARS-manAIREP exact dup--',ii
                      write(io8,*) 'TAMDAR-manAIREP exact dup--',ii
                    endif
c
                  elseif(l_ii_acars.and.l_iim1_airep) then
                    n_exact_AcAr = n_exact_AcAr + 1
                    l_print = .false.
                    if(l_print) then
                      write(io8,*)
ccccdak                      write(io8,*) 'ACARS-AIREP exact dup--',ii
                      write(io8,*) 'TAMDAR-AIREP exact dup--',ii
                    endif
c
                  elseif(l_ii_mdcrs.and.l_iim1_man) then
                    n_exact_MdMa = n_exact_MdMa + 1
                    l_print = .false.
                    if(l_print) then
                      write(io8,*)
                      write(io8,*) 'MDCRS-manAIREP exact dup--',ii
                    endif
c
                  elseif(l_ii_mdcrs.and.l_iim1_airep) then
                    n_exact_MdAr = n_exact_MdAr + 1
                    l_print = .false.
                    if(l_print) then
                      write(io8,*)
                      write(io8,*) 'MDCRS-AIREP exact dup found--',ii
                    endif
c
                  elseif(l_ii_amdar.and.l_iim1_airep) then
                    n_exact_AmAr = n_exact_AmAr + 1
                    l_print = .false.
                    if(l_print) then
                      write(io8,*)
                      write(io8,*) 'AMDAR-AIREP exact dup found--'
     $,                             ii
                    endif
c
                  elseif(l_ii_amdar.and.l_iim1_man) then
                    n_exact_AmMa = n_exact_AmMa + 1
                    l_print = .false.
                    if(l_print) then
                      write(io8,*)
                      write(io8,*) 'AMDAR-manAIREP exact dup--',ii
                    endif
c
                  elseif(l_ii_airep.and.l_iim1_man) then
                    n_exact_ArMa = n_exact_ArMa + 1
                    l_print = .false.
                    if(l_print) then
                      write(io8,*)
                      write(io8,*) 'AIREP-manAIREP exact dup--',ii
                    endif
c
                  else
                    l_print = .true.
                    if(l_print) then
                      write(io8,*)
                      write(io8,*) 'Uncategorized exact dup-1-',ii
                    endif
                  endif
c
c               Keep ob iim1
c               ------------
                elseif((l_iim1_mdcrs.and.l_ii_acars).or.
     $                 (l_iim1_acars.and.l_ii_airep).or.
     $                 (l_iim1_mdcrs.and.l_ii_airep).or.
     $                 (l_iim1_amdar.and.l_ii_airep).or.
     $                 (l_iim1_mdcrs.and.l_ii_man  ).or.
     $                 (l_iim1_acars.and.l_ii_man  ).or.
     $                 (l_iim1_amdar.and.l_ii_man  ).or.
     $                 (l_iim1_airep.and.l_ii_man  ).or.
     $                 l_ii_sh.or.
     $                 l_ii_0lat.or.
     $                 l_ii_0lon) then
c
                  indx(knt1) = ii
                  indx(knt0) = iim1
                  isave = ii
                  ii = iim1
                  iim1 = isave
c
                  if(c_qc(iim1)(1:1).eq.'-'.or.
     $               c_qc(iim1)(1:1).eq.'.'.or.
     $               c_qc(iim1)(1:1).eq.'N') 
     $               c_qc(iim1)(1:1) = 'D'
c
                  if(c_qc(ii)(1:1).eq.'-') c_qc(ii)(1:1) = '.'
c
c                 Count rejects by category
c                 -------------------------
                  n_exact = n_exact + 1
c
                  if(l_ii_sh) then
                    n_exact_sh = n_exact_sh + 1
                    l_print = .true.
                    if(l_print) then
                      write(io8,*)
                      write(io8,*) 'Exact dup with short id--',ii
                    endif
                    if(l_ii_man.and.l_iim1_man) then
                      n_ex_sh_MaMa = n_ex_sh_MaMa + 1
                      if(l_print) 
     $                  write(io8,*) 'manAIREP-manAIREP dup'
                    elseif(l_ii_man.and.l_iim1_airep) then 
                      n_ex_sh_MaAr = n_ex_sh_MaAr + 1
                      if(l_print) write(io8,*) 'manAIREP-AIREP dup'
                    elseif(l_ii_man.and.l_iim1_mdcrs) then 
                      n_ex_sh_MaMd = n_ex_sh_MaMd + 1
                      if(l_print) write(io8,*) 'manAIREP-MDCRS dup'
                    elseif(l_ii_man.and.l_iim1_acars) then 
                      n_ex_sh_MaAc = n_ex_sh_MaAc + 1
ccccdak                      if(l_print) write(io8,*) 'manAIREP-ACARS dup'
                      if(l_print) write(io8,*) 'manAIREP-TAMDAR dup'
                    elseif(l_iim1_man.and.l_ii_airep) then 
                      n_ex_sh_ArMa = n_ex_sh_ArMa + 1
                      if(l_print) write(io8,*) 'AIREP-manAIREP dup'
                    elseif(l_ii_airep.and.l_iim1_airep) then 
                      n_ex_sh_ArAr = n_ex_sh_ArAr + 1
                      if(l_print) write(io8,*) 'AIREP-AIREP dup'
                    else
                      l_print = .true.
                      if(l_print) then
                        write(io8,*)
                        write(io8,*)'Uncategorized short-id dup'
                      endif
                    endif
c
                  elseif(l_ii_0lat.or.l_ii_0lon) then
                    n_exact_0ll = n_exact_0ll + 1
                    l_print = .false.
                    if(l_print) then
                      write(io8,*)
                      write(io8,*) 'Exact dup found with 0l/l--',ii
                    endif
                    if(l_iim1_acars.and.l_ii_acars) then
                      n_ex_0ll_AcAc = n_ex_0ll_AcAc + 1
ccccdak                      if(l_print) write(io8,*) 'ACARS-ACARS dup'
                      if(l_print) write(io8,*) 'TAMDAR-TAMDAR dup'
                    elseif(l_iim1_mdcrs.and.l_ii_mdcrs) then
                      n_ex_0ll_MdMd = n_ex_0ll_MdMd + 1
                      if(l_print) write(io8,*) 'MDCRS-MDCRS dup'
                    elseif(l_iim1_man.and.l_ii_man) then
                      n_ex_0ll_MaMa = n_ex_0ll_MaMa + 1
                      if(l_print) 
     $                  write(io8,*) 'manAIREP-manAIREP dup'
                      elseif(l_iim1_man.and.l_ii_airep) then
                      n_ex_0ll_MaAr = n_ex_0ll_MaAr + 1
                      if(l_print) write(io8,*) 'manAIREP-AIREP dup'
                    else
                      l_print = .true.
                      if(l_print) then
                        write(io8,*)
                        write(io8,*) 'Uncategorized exact 0l/l dup'
                      endif
                    endif
c
                  elseif(l_iim1_mdcrs.and.l_ii_acars) then
                    n_exact_MdAc = n_exact_MdAc + 1
                    l_print = .false.
                    if(l_print) then
                      write(io8,*)
ccccdak                      write(io8,*) 'MDCRS-ACARS exact dup found--'
                      write(io8,*) 'MDCRS-TAMDAR exact dup found--'
     $,                             ii
                    endif
c
                  elseif(l_iim1_acars.and.l_ii_man) then
                    n_exact_AcMa = n_exact_AcMa + 1
                    l_print = .false.
                    if(l_print) then
                      write(io8,*)
ccccdak                      write(io8,*) 'ACARS-manAIREP exact dup--',ii
                      write(io8,*) 'TAMDAR-manAIREP exact dup--',ii
                    endif
c
                  elseif(l_iim1_acars.and.l_ii_airep) then
                    n_exact_AcAr = n_exact_AcAr + 1
                    l_print = .false.
                    if(l_print) then
                      write(io8,*)
ccccdak                      write(io8,*) 'ACARS-AIREP exact dup--',ii
                      write(io8,*) 'TAMDAR-AIREP exact dup--',ii
                    endif
c
                  elseif(l_iim1_mdcrs.and.l_ii_man) then
                    n_exact_MdMa = n_exact_MdMa + 1
                    l_print = .false.
                    if(l_print) then
                      write(io8,*)
                      write(io8,*) 'MDCRS-manAIREP exact dup--',ii
                    endif
c
                  elseif(l_iim1_mdcrs.and.l_ii_airep) then
                    n_exact_MdAr = n_exact_MdAr + 1
                    l_print = .false.
                    if(l_print) then
                      write(io8,*)
                      write(io8,*) 'MDCRS-AIREP exact dup found--',ii
                    endif
c
                  elseif(l_iim1_amdar.and.l_ii_airep) then
                    n_exact_AmAr = n_exact_AmAr + 1
                    l_print = .false.
                    if(l_print) then
                      write(io8,*)
                      write(io8,*) 'AMDAR-AIREP exact dup found--'
     $,                             ii
                    endif
c
                  elseif(l_iim1_amdar.and.l_ii_man) then
                    n_exact_AmMa = n_exact_AmMa + 1
                    l_print = .false.
                    if(l_print) then
                      write(io8,*)
                      write(io8,*) 'AMDAR-manAIREP exact dup--',ii
                    endif
c
                  elseif(l_iim1_airep.and.l_ii_man) then
                    n_exact_ArMa = n_exact_ArMa + 1
                    l_print = .false.
                    if(l_print) then
                      write(io8,*)
                      write(io8,*) 'AIREP-manAIREP exact dup--',ii
                    endif
c
                  else
                    l_print = .true.
                    if(l_print) then
                      write(io8,*)
                      write(io8,*) 'Uncategorized exact dup-2-',ii
                    endif
                  endif
c
c               Duplicate pair doesn't fall in any of the above categories
c               Keep ob ii
c               ----------------------------------------------------------
                else
c
                  if(c_qc(iim1)(1:1).eq.'-'.or.
     $               c_qc(iim1)(1:1).eq.'.'.or.
     $               c_qc(iim1)(1:1).eq.'N') 
     $               c_qc(iim1)(1:1) = 'D'
c
                  if(c_qc(ii)(1:1).eq.'-') c_qc(ii)(1:1) = '.'
c
c                 Count rejects by category
c                 -------------------------
                  n_exact = n_exact + 1
c
                  if(l_ii_acars.and.l_iim1_acars) then
                    n_exact_AcAc = n_exact_AcAc + 1
                    l_print = .false.
                    if(l_print) then
                      write(io8,*)
ccccdak                      write(io8,*) 'ACARS-ACARS exact dup found--'
                      write(io8,*) 'TAMDAR-TAMDAR exact dup found--'
     $,                             ii
                    endif
c
                  elseif(l_ii_mdcrs.and.l_iim1_mdcrs) then
                    if(ichk_s(ii).eq.-10) then
                      n_ex_bad_roll_Md = n_ex_bad_roll_Md + 1
                      l_print = .false.
                      if(l_print) then
                        write(io8,*)
                        write(io8,*) 'Bad roll qc ii--MdMd exact'
                      endif
                      ichk_t(ii) = ichk_t(iim1)
                      ichk_q(ii) = ichk_q(iim1)
                      ichk_d(ii) = ichk_d(iim1)
                      ichk_s(ii) = ichk_s(iim1)
c
                    elseif(ichk_s(iim1).eq.-10) then
                      n_ex_bad_roll_Md = n_ex_bad_roll_Md + 1
                      l_print = .false.
                      if(l_print) then
                        write(io8,*)
                        write(io8,*)'Bad roll qc iim1--MdMd exact'
                      endif
c
                    else
                      n_exact_MdMd = n_exact_MdMd + 1
                      l_print = .false.
                      if(l_print) then
                        write(io8,*)
                        write(io8,*) 'MDCRS-MDCRS exact dup--',ii,iim1
                        write(io8,*) 'c_qc =..',c_qc(ii),'..',c_qc(iim1)
                      endif
                    endif
c
                  elseif(l_ii_amdar.and.l_iim1_amdar) then
                    if(ichk_s(ii).eq.-10) then
                      n_ex_bad_roll_Am = n_ex_bad_roll_Am + 1
                      l_print = .false.
                      if(l_print) then
                        write(io8,*)
                        write(io8,*) 'Bad roll qc ii--AmAm exact'
                      endif
                      ichk_t(ii) = ichk_t(iim1)
                      ichk_q(ii) = ichk_q(iim1)
                      ichk_d(ii) = ichk_d(iim1)
                      ichk_s(ii) = ichk_s(iim1)
c
                    elseif(ichk_s(iim1).eq.-10) then
                      n_ex_bad_roll_Am = n_ex_bad_roll_Am + 1
                      l_print = .false.
                      if(l_print) then
                        write(io8,*)
                        write(io8,*)'Bad roll qc iim1--AmAm exact'
                      endif
c
                    else
                      n_exact_AmAm = n_exact_AmAm + 1
                      l_print = .false.
                      if(l_print) then
                        write(io8,*)
                        write(io8,*) 'AMDAR-AMDAR exact dup--',ii,iim1
                        write(io8,*) 'c_qc =..',c_qc(ii),'..',c_qc(iim1)
                      endif
                    endif
c
                  elseif(l_ii_airep.and.l_iim1_airep) then
                    n_exact_ArAr = n_exact_ArAr + 1
                    l_print = .false.
                    if(l_print) then
                      write(io8,*)
                      write(io8,*) 'AIREP-AIREP exact dup found--'
     $,                             ii
                    endif
c
                  elseif(l_ii_man.and.l_iim1_man) then
                    n_exact_MaMa = n_exact_MaMa + 1
                    l_print = .false.
                    if(l_print) then
                      write(io8,*)
                      write(io8,*) 'manAIREP-manAIREP exact dup--'
     $,                             ii
                    endif
c
                  else
                    l_print = .true.
                    if(l_print) then
                      write(io8,*)
                      write(io8,*) 'Uncategorized exact dup-3-',ii
                    endif
                  endif
                endif
              endif
            endif
c
c           Check if report is a near dup (qc flag = 'd')
c           Most near dups came in different formats with different units/precision
c           -----------------------------------------------------------------------
c
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
c           First exclude reports that are too far apart--set c_qc to '.'
c           -------------------------------------------------------------
            if((abs(alat(iim1)-alat(ii)).lt.0.125.or.
     $          ( (l_iim1_0lat.or.l_ii_0lat).and.
     $            (c_acftid(ii).eq.c_acftid(iim1).or.
     $             l_ii_man.or.l_iim1_man) )).and.
     $         (abs(alon(iim1)-alon(ii)).lt.0.125.or.
     $          ( (l_iim1_0lon.or.l_ii_0lon).and.
     $            (c_acftid(ii).eq.c_acftid(iim1).or.
     $             l_ii_man.or.l_iim1_man) ))) then
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
c
c             Time threshold changed to 90 sec to look for position reports (8/15/01)
c             -----------------------------------------------------------------------
              if((idt_dif.ge.0.and.idt_dif.le.90).and.
     $           c_qc(iim1)(1:1).ne.'D'.and.
c
c                 AMDAR-AIREP dups below 25,000'
c
     $           ((ht_ft(ii).lt.25000..and.
     $             ifix(ht_ft(iim1)).eq.-ifix(ht_ft(ii)).and.
     $             ((( (l_ii_amdar.and.l_iim1_airep).or.
     $                 (l_ii_airep.and.l_iim1_amdar) ).and.
     $                  c_acftid(ii).eq.c_acftid(iim1) ).or.            ! new
     $                l_ii_amdar.and.l_iim1_man.or.
     $                l_ii_man.and.l_iim1_amdar ).or.
c
c                  high-res dups below 25,000'
c
     $              abs(ht_ft(iim1)-ht_ft(ii)).lt.
     $                  htdif_same/4.+0.5).or.
c
c                  MDCRS cross-type dups below 25,000'
c
     $            (ht_ft(ii).lt.25000..and.
     $             ((l_ii_mdcrs.and.(.not.l_iim1_mdcrs)).or.            ! new
     $              (l_iim1_mdcrs.and.(.not.l_ii_mdcrs)).or.            ! new
     $              (l_ii_mdcrs.and.                                    ! new on 6/5/01
     $               (itype(ii  ).ne.i_mdcrs.and.                       !  "
     $                itype(iim1).eq.i_mdcrs).and.                      !  "
     $               c_acftid(ii).eq.c_acftid(iim1)).or.                !  "
     $              (l_iim1_mdcrs.and.                                  !  "
     $               (itype(iim1).ne.i_mdcrs.and.                       !  "
     $                itype(ii  ).eq.i_mdcrs).and.                      !  "
     $                c_acftid(ii).eq.c_acftid(iim1)).or.               !  "
     $              (l_ii_acars.and.(.not.l_iim1_acars)).or.            ! new
     $              (l_iim1_acars.and.(.not.l_ii_acars)).or.            ! new
     $              (l_ii_man.and.(.not.l_iim1_man)).or.                ! new
     $              (l_iim1_man.and.(.not.l_ii_man)).or.                ! new
     $              (((l_ii_amdar.and.l_iim1_amdar).or.                 ! new
     $                (l_ii_airep.and.l_iim1_amdar).or.                 ! new
     $                (l_iim1_airep.and.l_ii_amdar)).and.               ! new
     $               c_acftid(ii).eq.c_acftid(iim1))).and.              ! new
     $             abs(ht_ft(iim1)-ht_ft(ii)).lt.htdif_same+0.5).or.
c
c                  dups above 25,000'
c
     $            (ht_ft(ii).gt.24999.5.and.
     $             abs(ht_ft(iim1)-ht_ft(ii)).lt.htdif_same+0.5)).and.
c
c                 other criteria
c
     $           (abs(ob_t(iim1)-ob_t(ii)).lt.1.25.or.
     $            (ob_t(iim1).eq.amiss.and.ob_t(ii).ne.amiss).or.
     $            (ob_t(iim1).ne.amiss.and.ob_t(ii).eq.amiss)).and.
c
     $           (abs(difdir).lt.10.5.or.
     $            (ob_dir(iim1).eq.amiss.and.ob_dir(ii).eq.amiss).or.
     $            (ob_dir(iim1).eq.amiss.and.ob_dir(ii).ne.amiss).or.
     $            (ob_dir(iim1).ne.amiss.and.ob_dir(ii).eq.amiss).or.
     $            (ob_spd(iim1).eq.amiss.and.ob_spd(ii).ne.amiss).or.
     $            (ob_spd(iim1).ne.amiss.and.ob_spd(ii).eq.amiss).or.
     $            (ob_dir(iim1).lt.0.5.and.ob_dir(ii).lt.0.5).or.
     $            (ob_dir(iim1).lt.0.5.and.difdir.gt.10.5).or.
     $            (difdir.gt.10.5.and.ob_dir(ii).lt.0.5)).and.
c
     $           (abs(ob_spd(iim1)-ob_spd(ii)).lt.1.25.or.
     $            (ob_spd(iim1).eq.amiss.and.ob_spd(ii).eq.amiss).or.
     $            (ob_spd(iim1).eq.amiss.and.ob_spd(ii).ne.amiss).or.
     $            (ob_spd(iim1).ne.amiss.and.ob_spd(ii).eq.amiss).or.
     $            (ob_dir(iim1).eq.amiss.and.ob_dir(ii).eq.amiss).or.
     $            (ob_dir(iim1).eq.amiss.and.ob_dir(ii).ne.amiss).or.
     $            (ob_dir(iim1).ne.amiss.and.ob_dir(ii).eq.amiss).or.
     $            (ob_spd(iim1).lt.0.05.and.ob_spd(ii).lt.0.05).or.
     $            (ob_spd(iim1).lt.0.05.and.ob_spd(ii).gt.1.25).or.
     $            (ob_spd(iim1).gt.1.25.and.ob_spd(ii).lt.0.05))) then
c
c               Count duplicates where one has neg and the other pos altitude
c               -------------------------------------------------------------
                if(abs(abs(ht_ft(iim1))-abs(ht_ft(ii))).lt.0.5.and.
     $             abs(ht_ft(iim1)-ht_ft(ii)).gt.0.5) then
                  n_near_negpos = n_near_negpos + 1
c
                  l_print = .false.
                  if(l_print) then
                    write(io8,*)
                    write(io8,*) 'Neg-pos altitude dup found'
                  endif
                endif
c
c               If near dup found, decide which report to keep
ccccdak                 Choose MDCRS over ACARS
c                 Choose MDCRS over TAMDAR
c                 Choose reports with flight phase over no reported flight phase
ccccdak                 Choose ACARS/MDCRS over AIREP/manual AIREP
c                 Choose TAMDAR or MDCRS over AIREP/manual AIREP
c                 Choose AMDAR over AIREP/manual AIREP
c                 Choose automated over manual AIREP
c                 Choose 7-char flight number over 6-char flight number
c                 Choose present over missing flight/tail number
c                 Choose present over missing/zero wind speed or direction
c                 Choose non-zero over zero lat or lon
c               ----------------------------------------------------------------
c
c               Keep ob ii
c               ----------
                if( ( ( ((l_ii_mdcrs.and.l_iim1_acars).or.
     $                   (l_ii_mdcrs.and.l_iim1_mdcrs.and.
     $                    .not.(itype(ii).eq.i_mdcrs.and.
     $                          itype(iim1).ne.i_mdcrs)).or.
     $                   (l_ii_acars.and.l_iim1_acars).or.
     $                   (l_ii_amdar.and.l_iim1_amdar).or.              ! new
     $                   (l_ii_amdar.and.l_iim1_airep)).and.            ! new
     $                  c_acftreg(ii).eq.c_acftreg(iim1) ).and.
c
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
     $                 ((abs(alat(iim1)-alat(ii)).lt.0.025.and.
     $                   abs(alon(iim1)-alon(ii)).lt.0.025.and.
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
     $                   abs(ob_t(iim1)-ob_t(ii)).lt.0.65.and.
     $                   ((abs(difdir).lt.5.5).or.
     $                    (ob_dir(ii).eq.amiss.and.
     $                     ob_dir(iim1).eq.amiss).or.
     $                    (ob_dir(ii).ne.amiss.and.
     $                     ob_dir(iim1).eq.amiss).or.
     $                    (ob_spd(ii).ne.amiss.and.
     $                     ob_spd(iim1).eq.amiss).or.
     $                    (ob_dir(ii).gt.10.5.and.
     $                     ob_dir(iim1).lt.0.5)).and.
     $                   ((abs(ob_spd(iim1)-ob_spd(ii)).lt.0.55).or.
     $                    (ob_spd(ii).eq.amiss.and.
     $                     ob_spd(iim1).eq.amiss).or.
     $                    (ob_spd(ii).ne.amiss.and.
     $                     ob_spd(iim1).eq.amiss).or.
     $                    (ob_dir(ii).eq.amiss.and.
     $                     ob_dir(iim1).eq.amiss).or.
     $                    (ob_dir(ii).ne.amiss.and.
     $                     ob_dir(iim1).eq.amiss).or.
     $                    (ob_spd(ii).gt.1.25.and.
     $                     ob_spd(iim1).lt.0.05)) ).or.
c
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
     $                  (abs(alat(iim1)-alat(ii)).lt.0.055.and.
     $                   abs(alon(iim1)-alon(ii)).lt.0.055.and.
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
     $                   abs(ht_ft(iim1)-ht_ft(ii)).lt.15.5.and.
     $                   idt_dif.le.30.and.
     $                   abs(ob_t(iim1)-ob_t(ii)).lt.1.25.and.
     $                   ((abs(difdir).lt.10.5).or.
     $                    (ob_dir(ii).eq.amiss.and.
     $                     ob_dir(iim1).eq.amiss).or.
     $                    (ob_dir(ii).ne.amiss.and.
     $                     ob_dir(iim1).eq.amiss).or.
     $                    (ob_spd(ii).ne.amiss.and.
     $                     ob_spd(iim1).eq.amiss).or.
     $                    (ob_dir(ii).gt.10.5.and.
     $                     ob_dir(iim1).lt.0.5)).and.
     $                   ((abs(ob_spd(iim1)-ob_spd(ii)).lt.1.25).or.
     $                    (ob_spd(ii).eq.amiss.and.
     $                     ob_spd(iim1).eq.amiss).or.
     $                    (ob_spd(ii).ne.amiss.and.
     $                     ob_spd(iim1).eq.amiss).or.
     $                    (ob_dir(ii).eq.amiss.and.
     $                     ob_dir(iim1).eq.amiss).or.
     $                    (ob_dir(ii).ne.amiss.and.
     $                     ob_dir(iim1).eq.amiss).or.
     $                    (ob_spd(ii).gt.1.25.and.
     $                     ob_spd(iim1).lt.0.05)) ))).or.
c
     $             (l_ii_airep.and.l_iim1_man).or.
c
     $             (l_ii_acars.and.l_iim1_airep).or.
     $             (l_ii_mdcrs.and.l_iim1_airep).or. 
c
     $             (l_ii_acars.and.l_iim1_man).or.
     $             (l_ii_mdcrs.and.l_iim1_man).or.
c
     $             (l_ii_amdar.and.l_iim1_man).or.
c
     $             ((itype(ii).eq.i_mdcrs_lvl.or.
     $               itype(ii).eq.i_mdcrs_asc.or.
     $               itype(ii).eq.i_mdcrs_des).and.
     $              itype(iim1).eq.i_mdcrs).or.
c
     $             l_iim1_sh.or.
c
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
     $             (l_iim1_0lat.and.abs(alat(ii)).gt.0.125).or.
c
     $             (l_iim1_0lon.and.
     $              (alon(ii).gt.0.125.and.alon(ii).lt.359.875)).or.
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
c
     $             (ob_t(ii).ne.amiss.and.ob_t(iim1).eq.amiss).or.
c
     $             (.not.(l_ii_mdcrs.and.l_iim1_acars).and.
     $              .not.(l_ii_mdcrs.and.l_iim1_mdcrs).and.
     $              .not.(l_ii_acars.and.l_iim1_acars).and.
     $            ((ob_spd(ii).ne.amiss.and.ob_spd(iim1).eq.amiss).or.
     $             (ob_dir(ii).ne.amiss.and.ob_dir(iim1).eq.amiss).or.
     $             (((ob_spd(ii).gt.1.25.and.ob_spd(iim1).lt.0.05).or.
     $                (difdir.gt.10.5.and.ob_dir(iim1).lt.0.5)).and.
     $               c_acftid(ii).eq.c_acftid(iim1)))) ) then
c
                  if(c_qc(iim1)(1:1).eq.'-'.or.
     $               c_qc(iim1)(1:1).eq.'.'.or.
     $               c_qc(iim1)(1:1).eq.'N') 
     $               c_qc(iim1)(1:1) = 'd'
c
                  if(c_qc(ii)(1:1).eq.'-') c_qc(ii)(1:1) = '.'
c
c                 Count rejects by category
c                 -------------------------
                  n_near = n_near + 1
c
                  if(l_iim1_sh) then
                    n_near_sh = n_near_sh + 1
                    l_print = .true.
                    if(l_print) then
                      write(io8,*)
                      write(io8,*) 'Near dup found with short id--'
     $,                             ii
                    endif
                    if(l_iim1_man.and.l_ii_man) then
                      n_nr_sh_MaMa = n_nr_sh_MaMa + 1
                      if(l_print) 
     $                  write(io8,*) 'manAIREP-manAIREP dup'
                    elseif(l_iim1_man.and.l_ii_airep) then 
                      n_nr_sh_MaAr = n_nr_sh_MaAr + 1
                      if(l_print) write(io8,*) 'manAIREP-AIREP dup'
                    elseif(l_iim1_man.and.l_ii_mdcrs) then 
                      n_nr_sh_MaMd = n_nr_sh_MaMd + 1
                      if(l_print) write(io8,*) 'manAIREP-MDCRS dup'
                    elseif(l_iim1_man.and.l_ii_acars) then 
                      n_nr_sh_MaAc = n_nr_sh_MaAc + 1
ccccdak                      if(l_print) write(io8,*) 'manAIREP-ACARS dup'
                      if(l_print) write(io8,*) 'manAIREP-TAMDAR dup'
                    elseif(l_ii_man.and.l_iim1_airep) then 
                      n_nr_sh_ArMa = n_nr_sh_ArMa + 1
                      if(l_print) write(io8,*) 'AIREP-manAIREP dup'
                    elseif(l_iim1_airep.and.l_ii_airep) then 
                      n_nr_sh_ArAr = n_nr_sh_ArAr + 1
                      if(l_print) write(io8,*) 'AIREP-AIREP dup'
                    else
                      l_print = .true.
                      if(l_print) then
                        write(io8,*)
                        write(io8,*) 'Uncategorized short-id dup'
                      endif
                    endif
c
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
                  elseif(((l_iim1_0lat.and.
     $                     abs(alat(ii)).gt.0.125).or.
     $                    (l_iim1_0lon.and.
     $                     (alon(ii).gt.0.125.and.
     $                      alon(ii).lt.359.875))).and.
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
     $                   (c_acftid(ii).eq.c_acftid(iim1).or.
     $                    l_ii_man.or.l_iim1_man)) then
                    n_near_0ll = n_near_0ll + 1
                    l_print = .false.
                    if(l_print) then
                      write(io8,*)
                      write(io8,*) 'Near dup found with 0l/l--',ii
                    endif
                    if(l_iim1_acars.and.l_ii_acars) then
                      n_nr_0ll_AcAc = n_nr_0ll_AcAc + 1
ccccdak                      if(l_print) write(io8,*) 'ACARS-ACARS dup'
                      if(l_print) write(io8,*) 'TAMDAR-TAMDAR dup'
                    elseif(l_iim1_mdcrs.and.l_ii_mdcrs) then
                      n_nr_0ll_MdMd = n_nr_0ll_MdMd + 1
                      if(l_print) write(io8,*) 'MDCRS-MDCRS dup'
                    elseif(l_iim1_man.and.l_ii_airep) then
                      n_nr_0ll_MaAr = n_nr_0ll_MaAr + 1
                      if(l_print) write(io8,*) 'manAIREP-AIREP dup'
                    elseif(l_iim1_amdar.and.l_ii_airep) then
                      n_nr_0ll_AmAr = n_nr_0ll_AmAr + 1
                      if(l_print) write(io8,*) 'AMDAR-AIREP dup'
                    elseif(l_iim1_man.and.l_ii_man) then
                      n_nr_0ll_MaMa = n_nr_0ll_MaMa + 1
                      if(l_print) write(io8,*) 'manAIREP-manAIREP dup'
                    elseif(l_iim1_man.and.l_ii_mdcrs) then
                      n_nr_0ll_MaMd = n_nr_0ll_MaMd + 1
                      if(l_print) write(io8,*) 'manAIREP-MDCRS dup'
                    elseif(l_iim1_mdcrs.and.l_ii_man) then
                      n_nr_0ll_MdMa = n_nr_0ll_MdMa + 1
                      if(l_print) write(io8,*) 'MDCRS-manAIREP dup'
                    elseif(l_iim1_man.and.l_ii_amdar) then
                      n_nr_0ll_MaAm = n_nr_0ll_MaAm + 1
                      if(l_print) write(io8,*) 'manAIREP-AMDAR dup'
                    elseif(l_iim1_amdar.and.l_ii_man) then
                      n_nr_0ll_AmMa = n_nr_0ll_AmMa + 1
                      if(l_print) write(io8,*) 'AMDAR-manAIREP dup'
                    else
                      l_print = .true.
                      if(l_print) then
                        write(io8,*)
                        write(io8,*) 'Uncategorized near 0l/l dup'
                      endif
                    endif
c
                  elseif(ob_t(ii).ne.amiss.and.
     $                   ob_t(iim1).eq.amiss) then
                    n_near_mst = n_near_mst + 1
                    l_print = .false.
                    if(l_print) then
                      write(io8,*)
                      write(io8,*) 'Near dup found with msg temp--'
     $,                             ii
                    endif
                    if(l_iim1_man.and.l_ii_man) then
                      n_nr_mst_MaMa = n_nr_mst_MaMa + 1
                      if(l_print) 
     $                  write(io8,*) 'manAIREP-manAIREP dup'
                    elseif(l_iim1_man.and.l_ii_airep) then
                      n_nr_mst_MaAr = n_nr_mst_MaAr + 1
                      if(l_print) write(io8,*) 'manAIREP-AIREP dup'
                    elseif(l_iim1_man.and.l_ii_amdar) then
                      n_nr_mst_MaAm = n_nr_mst_MaAm + 1
                      if(l_print) write(io8,*) 'manAIREP-AMDAR dup'
                    elseif(l_iim1_airep.and.l_ii_acars) then
                      n_nr_mst_ArAc = n_nr_mst_ArAc + 1
ccccdak                      if(l_print) write(io8,*) 'AIREP-ACARS dup'
                      if(l_print) write(io8,*) 'AIREP-TAMDAR dup'
                    elseif(l_iim1_airep.and.l_ii_mdcrs) then
                      n_nr_mst_ArMd = n_nr_mst_ArMd + 1
                      if(l_print) write(io8,*) 'AIREP-MDCRS dup'
                    elseif(l_iim1_man.and.l_ii_acars) then
                      n_nr_mst_MaAc = n_nr_mst_MaAc + 1
ccccdak                      if(l_print) write(io8,*) 'manAIREP-ACARS dup'
                      if(l_print) write(io8,*) 'manAIREP-TAMDAR dup'
                    elseif(l_iim1_man.and.l_ii_mdcrs) then
                      n_nr_mst_MaMd = n_nr_mst_MaMd + 1
                      if(l_print) write(io8,*) 'manAIREP-MDCRS dup'
                    elseif(l_iim1_mdcrs.and.l_ii_mdcrs) then
                      n_nr_mst_MdMd = n_nr_mst_MdMd + 1
                      if(l_print) write(io8,*) 'MDCRS-MDCRS dup'
                    elseif(l_iim1_airep.and.l_ii_man) then
                      n_nr_mst_ArMa = n_nr_mst_ArMa + 1
                      if(l_print) write(io8,*) 'AIREP-manAIREP dup'
                    elseif(l_iim1_amdar.and.l_ii_amdar) then
                      n_nr_mst_AmAm = n_nr_mst_AmAm + 1
                      if(l_print) write(io8,*) 'AMDAR-AMDAR dup'
                    elseif(l_iim1_airep.and.l_ii_airep) then
                      n_nr_mst_ArAr = n_nr_mst_ArAr + 1
                      if(l_print) write(io8,*) 'AIREP-AIREP dup'
                    elseif(l_iim1_airep.and.l_ii_amdar) then
                      n_nr_mst_ArAm = n_nr_mst_ArAm + 1
                      if(l_print) write(io8,*) 'AIREP-AMDAR dup'
                    elseif(l_iim1_amdar.and.l_ii_airep) then
                      n_nr_mst_AmAr = n_nr_mst_AmAr + 1
                      if(l_print) write(io8,*) 'AMDAR-AIREP dup'
                    else
                      l_print = .true.
                      if(l_print) then
                        write(io8,*)
                        write(io8,*) 'Uncategorized msg-temp dup'
                      endif
                    endif
c
                  elseif((ob_spd(ii).ne.amiss.and.
     $                    ob_spd(iim1).eq.amiss).or.
     $                   (ob_dir(ii).ne.amiss.and.
     $                    ob_dir(iim1).eq.amiss)) then
                    n_near_ws = n_near_ws + 1
                    l_print = .false.
                    if(c_acftid(ii)(1:2).eq.'IT') then 
                      n_near_ws_IT = n_near_ws_IT + 1
                      l_print = .false.
                    elseif(c_acftid(ii)(1:2).eq.'EU') then 
                      n_near_ws_EU = n_near_ws_EU + 1
                      l_print = .false.
                    endif
                    if(l_print) then
                      write(io8,*)
                      write(io8,*) 'Near dup with msg winds--',ii
                    endif
                    if(l_iim1_man.and.l_ii_man) then
                      n_nr_mswn_MaMa = n_nr_mswn_MaMa + 1
                      if(l_print) 
     $                  write(io8,*) 'manAIREP-manAIREP dup'
                    elseif(l_iim1_man.and.l_ii_airep) then 
                      n_nr_mswn_MaAr = n_nr_mswn_MaAr + 1
                      if(l_print) write(io8,*) 'manAIREP-AIREP dup'
                    elseif(l_iim1_man.and.l_ii_amdar) then 
                      n_nr_mswn_MaAm = n_nr_mswn_MaAm + 1
                      if(l_print) write(io8,*) 'manAIREP-AMDAR dup'
                    elseif(l_ii_man.and.l_iim1_airep) then 
                      n_nr_mswn_ArMa = n_nr_mswn_ArMa + 1
                      if(l_print) write(io8,*) 'AIREP-manAIREP dup'
                    elseif(l_iim1_airep.and.l_ii_airep) then 
                      n_nr_mswn_ArAr = n_nr_mswn_ArAr + 1
                      if(l_print) write(io8,*) 'AIREP-AIREP dup'
                    elseif(l_iim1_acars.and.l_ii_acars) then
                      n_nr_mswn_AcAc = n_nr_mswn_AcAc + 1
ccccdak                      if(l_print) write(io8,*) 'ACARS-ACARS dup'
                      if(l_print) write(io8,*) 'TAMDAR-TAMDAR dup'
                    elseif(l_iim1_mdcrs.and.l_ii_mdcrs) then
                      n_nr_mswn_MdMd = n_nr_mswn_MdMd + 1
                      if(l_print) write(io8,*) 'MDCRS-MDCRS dup'
                    elseif(l_iim1_acars.and.l_ii_mdcrs) then
                      n_nr_mswn_AcMd = n_nr_mswn_AcMd + 1
ccccdak                      if(l_print) write(io8,*) 'ACARS-MDCRS dup'
                      if(l_print) write(io8,*) 'TAMDAR-MDCRS dup'
                    elseif(l_iim1_mdcrs.and.l_ii_acars) then
                      n_nr_mswn_MdAc = n_nr_mswn_MdAc + 1
ccccdak                      if(l_print) write(io8,*) 'MDCRS-ACARS dup'
                      if(l_print) write(io8,*) 'MDCRS-TAMDAR dup'
                    elseif(l_iim1_mdcrs.and.l_ii_amdar) then
                      n_nr_mswn_MdAm = n_nr_mswn_MdAm + 1
                      if(l_print) write(io8,*) 'MDCRS-AMDAR dup'
                    elseif(l_iim1_mdcrs.and.l_ii_airep) then
                      n_nr_mswn_MdAr = n_nr_mswn_MdAr + 1
                      if(l_print) write(io8,*) 'MDCRS-AIREP dup'
                    elseif(l_iim1_mdcrs.and.l_ii_man) then
                      n_nr_mswn_MdMa = n_nr_mswn_MdMa + 1
                      if(l_print) write(io8,*) 'MDCRS-manAIREP dup'
                    elseif(l_iim1_airep.and.l_ii_acars) then
                      n_nr_mswn_ArAc = n_nr_mswn_ArAc + 1
ccccdak                      if(l_print) write(io8,*) 'AIREP-ACARS dup'
                      if(l_print) write(io8,*) 'AIREP-TAMDAR dup'
                    elseif(l_iim1_airep.and.l_ii_mdcrs) then
                      n_nr_mswn_ArMd = n_nr_mswn_ArMd + 1
                      if(l_print) write(io8,*) 'AIREP-MDCRS dup'
                    elseif(l_iim1_man.and.l_ii_acars) then
                      n_nr_mswn_MaAc = n_nr_mswn_MaAc + 1
ccccdak                      if(l_print) write(io8,*) 'manAIREP-ACARS dup'
                      if(l_print) write(io8,*) 'manAIREP-TAMDAR dup'
                    elseif(l_iim1_man.and.l_ii_mdcrs) then
                      n_nr_mswn_MaMd = n_nr_mswn_MaMd + 1
                      if(l_print) write(io8,*) 'manAIREP-MDCRS dup'
                    elseif(l_iim1_amdar.and.l_ii_amdar) then
                      n_nr_mswn_AmAm = n_nr_mswn_AmAm + 1
                      if(l_print) write(io8,*) 'AMDAR-AMDAR dup'
                    elseif(l_iim1_airep.and.l_ii_amdar) then
                      n_nr_mswn_ArAm = n_nr_mswn_ArAm + 1
                      if(l_print) write(io8,*) 'AIREP-AMDAR dup'
                    elseif(l_iim1_amdar.and.l_ii_airep) then
                      n_nr_mswn_AmAr = n_nr_mswn_AmAr + 1
                      if(l_print) write(io8,*) 'AMDAR-AIREP dup'
                    elseif(l_iim1_acars.and.l_ii_amdar) then
                      n_nr_mswn_AcAm = n_nr_mswn_AcAm + 1
ccccdak                      if(l_print) write(io8,*) 'ACARS-AMDAR dup'
                      if(l_print) write(io8,*) 'TAMDAR-AMDAR dup'
                    else
                      l_print = .true.
                      if(l_print) then
                        write(io8,*)
                        write(io8,*) 'Uncategorized msg-wind dup'
                      endif
                    endif
c
                  elseif((ob_spd(ii).gt.1.25.and.
     $                    ob_spd(iim1).lt.0.05).or.
     $                   (ob_dir(ii).gt.10.5.and.
     $                    difdir.gt.10.5.and.
     $                    ob_dir(iim1).lt.0.5)) then
                    n_near_0ws = n_near_0ws + 1
                    l_print = .false.
                    if(l_print) then
                      write(io8,*)
                      write(io8,*) 'Near dup found with 0 winds-1-'
     $,                             ii
                    endif
                    if(l_iim1_airep.and.l_ii_amdar) then
                      n_near_0ws_ArAm = n_near_0ws_ArAm + 1
                      if(l_print) write(io8,*) 'AIREP-AMDAR dup'
                    elseif(l_iim1_amdar.and.l_ii_airep) then
                      n_near_0ws_AmAr = n_near_0ws_AmAr + 1
                      if(l_print) write(io8,*) 'AMDAR-AIREP dup'
                    elseif(l_iim1_amdar.and.l_ii_amdar) then
                      n_near_0ws_AmAm = n_near_0ws_AmAm + 1
                      if(l_print) write(io8,*) 'AMDAR-AMDAR dup'
                    elseif(l_iim1_airep.and.l_ii_airep) then
                      n_near_0ws_ArAr = n_near_0ws_ArAr + 1
                      if(l_print) write(io8,*) 'AIREP-AIREP dup'
                    elseif(l_iim1_man.and.l_ii_man) then
                      n_near_0ws_MaMa = n_near_0ws_MaMa + 1
                      if(l_print) 
     $                  write(io8,*) 'manAIREP-manAIREP dup'
                    elseif(l_iim1_man.and.l_ii_mdcrs) then
                      n_near_0ws_MaMd = n_near_0ws_MaMd + 1
                      if(l_print) 
     $                  write(io8,*) 'manAIREP-MDCRS dup'
                    elseif(l_iim1_man.and.l_ii_amdar) then
                      n_near_0ws_MaAm = n_near_0ws_MaAm + 1
                      if(l_print) 
     $                  write(io8,*) 'manAIREP-AMDAR dup'
                    elseif(l_iim1_man.and.l_ii_airep) then
                      n_near_0ws_MaAr = n_near_0ws_MaAr + 1
                      if(l_print) 
     $                  write(io8,*) 'manAIREP-AIREP dup'
                    elseif(l_iim1_airep.and.l_ii_mdcrs) then
                      n_near_0ws_ArMd = n_near_0ws_ArMd + 1
                      if(l_print) 
     $                  write(io8,*) 'AIREP-MDCRS dup'
                    elseif(l_iim1_mdcrs.and.l_ii_mdcrs) then
                      n_near_0ws_MdMd = n_near_0ws_MdMd + 1
                      if(l_print) 
     $                  write(io8,*) 'MDCRS-MDCRS dup'
                    else
                      l_print = .true.
                      if(l_print) then
                        write(io8,*)
                        write(io8,*)'Uncategorized zero-wind dup'
                        write(io8,*) '  dir difference = ',difdir
                      endif
                    endif
c
                  elseif(l_ii_mdcrs.and.l_iim1_acars) then
                    n_near_MdAc = n_near_MdAc + 1
                    l_print = .false.
                    if(l_print) then
                      write(io8,*)
ccccdak                      write(io8,*) 'MDCRS-ACARS near dup found--',ii
                      write(io8,*) 'MDCRS-TAMDAR near dup found--',ii
                    endif
c
                  elseif(l_ii_mdcrs.and.l_iim1_mdcrs) then
                    if(itype(iim1).eq.i_mdcrs.and.
     $                 itype(ii  ).ne.i_mdcrs) then
                      n_nr_posrep = n_nr_posrep + 1
                      l_print = .false.
                      if(l_print) then
                        write(io8,*)
                        write(io8,*) 'MDCRS position report dup-1-',ii
                      endif
c
                    elseif(ichk_s(ii  ).eq.-10.and.
     $                     ichk_s(iim1).ne.-10) then
                      n_nr_bad_roll_Md = n_nr_bad_roll_Md + 1
                      l_print = .false.                                  !!!!
                      if(l_print) then
                        write(io8,*)
                        write(io8,*) 'Bad roll qc ii--MdMd near'
                      endif
                      ichk_t(ii) = ichk_t(iim1)
                      ichk_q(ii) = ichk_q(iim1)
                      ichk_d(ii) = ichk_d(iim1)
                      ichk_s(ii) = ichk_s(iim1)
c
                    elseif(ichk_s(iim1).eq.-10.and.
     $                     ichk_s(ii  ).ne.-10) then
                      n_nr_bad_roll_Md = n_nr_bad_roll_Md + 1
                      l_print = .false.                                  !!!!
                      if(l_print) then
                        write(io8,*)
                        write(io8,*) 'Bad roll qc iim1--MdMd near'
                      endif
c
                    else
                      n_near_MdMd = n_near_MdMd + 1
                      l_print = .false.
                      if(l_print) then
                        write(io8,*)
                        write(io8,*) 'MDCRS-MDCRS near dup found--',ii
                      endif
                    endif
c
                  elseif(l_ii_acars.and.l_iim1_acars) then
                    n_near_AcAc = n_near_AcAc + 1
                    l_print = .false.
                    if(l_print) then
                      write(io8,*)
ccccdak                      write(io8,*) 'ACARS-ACARS near dup found--',ii
                      write(io8,*) 'TAMDAR-TAMDAR near dup found--',ii
                    endif
c
                  elseif(l_ii_acars.and.l_iim1_airep) then
                    n_near_AcAr = n_near_AcAr + 1
                    l_print = .false.
                    if(l_print) then
                      write(io8,*)
ccccdak                      write(io8,*) 'ACARS-AIREP near dup found--',ii
                      write(io8,*) 'TAMDAR-AIREP near dup found--',ii
                    endif
c
                  elseif(l_ii_mdcrs.and.l_iim1_airep) then
                    n_near_MdAr = n_near_MdAr + 1
                    l_print = .false.
                    if(l_print) then
                      write(io8,*)
                      write(io8,*) 'MDCRS-AIREP near dup found--',ii
                    endif
c
                  elseif(l_ii_amdar.and.l_iim1_amdar) then
                    if(ichk_s(ii  ).eq.-10.and.
     $                 ichk_s(iim1).ne.-10) then
                      n_nr_bad_roll_Am = n_nr_bad_roll_Am + 1
                      l_print = .false.                                  !!!!
                      if(l_print) then
                        write(io8,*)
                        write(io8,*) 'Bad roll qc ii--AmAm near'
                      endif
                      ichk_t(ii) = ichk_t(iim1)
                      ichk_q(ii) = ichk_q(iim1)
                      ichk_d(ii) = ichk_d(iim1)
                      ichk_s(ii) = ichk_s(iim1)
c
                    elseif(ichk_s(iim1).eq.-10.and.
     $                     ichk_s(ii  ).ne.-10) then
                      n_nr_bad_roll_Am = n_nr_bad_roll_Am + 1
                      l_print = .false.                                  !!!!
                      if(l_print) then
                        write(io8,*)
                        write(io8,*) 'Bad roll qc iim1--AmAm near'
                      endif
c
                    else
                      n_near_AmAm = n_near_AmAm + 1
                      l_print = .false.
                      if(l_print) then
                        write(io8,*)
                        write(io8,*) 'AMDAR-AMDAR near dup found--',ii
                      endif
                    endif
c
                  elseif(l_ii_amdar.and.l_iim1_airep) then
                    n_near_AmAr = n_near_AmAr + 1
                    l_print = .false.
                    if(l_print) then
                      write(io8,*)
                      write(io8,*) 'AMDAR-AIREP near dup found--',ii
                    endif
c
                  elseif(l_ii_acars.and.l_iim1_man) then
                    n_near_AcMa = n_near_AcMa + 1
                    l_print = .false.
                    if(l_print) then
                      write(io8,*)
ccccdak                      write(io8,*) 'ACARS-manAIREP near dup--',ii
                      write(io8,*) 'TAMDAR-manAIREP near dup--',ii
                    endif
c
                  elseif(l_ii_mdcrs.and.l_iim1_man) then
                    n_near_MdMa = n_near_MdMa + 1
                    l_print = .false.
                    if(l_print) then
                      write(io8,*)
                      write(io8,*) 'MDCRS-manAIREP near dup--',ii
                    endif
c
                  elseif(l_ii_airep.and.l_iim1_man) then
                    n_near_ArMa = n_near_ArMa + 1
                    l_print = .false.
                    if(l_print) then
                      write(io8,*)
                      write(io8,*) 'AIREP-manAIREP near dup--',ii
                    endif
c
                  elseif(l_ii_amdar.and.l_iim1_man) then
                    n_near_AmMa = n_near_AmMa + 1
                    l_print = .false.
                    if(l_print) then
                      write(io8,*)
                      write(io8,*) 'AMDAR-manAIREP near dup--',ii
                    endif
c
                  else
                    l_print = .true.
                    if(l_print) then
                      write(io8,*)
                      write(io8,*) 'Uncategorized near dup-1-',ii,
     $                             ' difdir = ',difdir
                    endif
                  endif
c
c               Keep ob iim1
c               ------------
                elseif( ( ( ((l_iim1_mdcrs.and.l_ii_acars).or.
     $                       (itype(ii).eq.i_mdcrs.and.
     $                        itype(iim1).ne.i_mdcrs).or.
     $                       (l_iim1_amdar.and.l_ii_airep)).and.
     $                      c_acftreg(ii).eq.c_acftreg(iim1)).and.
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
c
     $                     ((abs(alat(iim1)-alat(ii)).lt.0.025.and.
     $                       abs(alon(iim1)-alon(ii)).lt.0.025.and.
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
     $                       abs(ob_t(iim1)-ob_t(ii)).lt.0.65.and.
     $                       ((abs(difdir).lt.5.5).or.
     $                        (ob_dir(ii).eq.amiss.and.
     $                         ob_dir(iim1).eq.amiss).or.
     $                        (ob_dir(ii).eq.amiss.and.
     $                         ob_dir(iim1).ne.amiss).or.
     $                        (ob_spd(ii).eq.amiss.and.
     $                         ob_spd(iim1).ne.amiss).or.
     $                        (ob_dir(iim1).gt.10.5.and.
     $                         ob_dir(ii).lt.0.5)).and.
     $                    ((abs(ob_spd(iim1)-ob_spd(ii)).lt.0.55 ).or.
     $                        (ob_spd(ii).eq.amiss.and.
     $                         ob_spd(iim1).eq.amiss).or.
     $                        (ob_spd(ii).eq.amiss.and.
     $                         ob_spd(iim1).ne.amiss).or.
     $                        (ob_dir(ii).eq.amiss.and.
     $                         ob_dir(iim1).eq.amiss).or.
     $                        (ob_dir(ii).eq.amiss.and.
     $                         ob_dir(iim1).ne.amiss).or.
     $                        (ob_spd(iim1).gt.1.25.and.
     $                         ob_spd(ii).lt.0.05)) ).or.
c
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
     $                      (abs(alat(iim1)-alat(ii)).lt.0.055.and.
     $                       abs(alon(iim1)-alon(ii)).lt.0.055.and.
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
     $                       abs(ht_ft(iim1)-ht_ft(ii)).lt.15.5.and.
     $                       idt_dif.le.30.and.
     $                       abs(ob_t(iim1)-ob_t(ii)).lt.1.25.and.
     $                       ((abs(difdir).lt.10.5).or.
     $                        (ob_dir(ii).eq.amiss.and.
     $                         ob_dir(iim1).eq.amiss).or.
     $                        (ob_dir(ii).eq.amiss.and.
     $                         ob_dir(iim1).ne.amiss).or.
     $                        (ob_spd(ii).eq.amiss.and.
     $                         ob_spd(iim1).ne.amiss).or.
     $                        (ob_dir(iim1).gt.10.5.and.
     $                         ob_dir(ii).lt.0.5)).and.
     $                    ((abs(ob_spd(iim1)-ob_spd(ii)).lt.1.25 ).or.
     $                        (ob_spd(ii).eq.amiss.and.
     $                         ob_spd(iim1).eq.amiss).or.
     $                        (ob_spd(ii).eq.amiss.and.
     $                         ob_spd(iim1).ne.amiss).or.
     $                        (ob_dir(ii).eq.amiss.and.
     $                         ob_dir(iim1).ne.amiss).or.
     $                        (ob_dir(ii).eq.amiss.and.
     $                         ob_dir(iim1).eq.amiss).or.
     $                        (ob_spd(iim1).gt.1.25.and.
     $                         ob_spd(ii).lt.0.05)) ))).or.
c
     $                 (l_iim1_airep.and.l_ii_man).or.
c
     $                 (l_iim1_acars.and.l_ii_airep).or.
     $                 (l_iim1_mdcrs.and.l_ii_airep).or. 
c
     $                 (l_iim1_acars.and.l_ii_man).or.
     $                 (l_iim1_mdcrs.and.l_ii_man).or.
c
     $                 (l_iim1_amdar.and.l_ii_man).or.
c
     $                 ((itype(iim1).eq.i_mdcrs_lvl.or.
     $                   itype(iim1).eq.i_mdcrs_asc.or.
     $                   itype(iim1).eq.i_mdcrs_des).and.
     $                  itype(ii).eq.i_mdcrs).or.
c
     $                 l_ii_sh.or.
c
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
     $                 (l_ii_0lat.and.abs(alat(ii)).gt.0.125).or.
c
     $                 (l_ii_0lon.and.
     $                (alon(ii).gt.0.125.and.alon(ii).lt.359.875)).or.
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
c
     $                 (ob_t(iim1).ne.amiss.and.ob_t(ii).eq.amiss).or.
c
     $                 (.not.(l_ii_mdcrs.and.l_iim1_acars).and.
     $                  .not.(l_ii_mdcrs.and.l_iim1_mdcrs).and.
     $                  .not.(l_ii_acars.and.l_iim1_acars).and.
     $                ((ob_spd(iim1).ne.amiss.and.
     $                  ob_spd(ii).eq.amiss).or.
     $                 (ob_dir(iim1).ne.amiss.and.
     $                  ob_dir(ii).eq.amiss).or.
     $                 (((ob_spd(iim1).gt.1.25.and.
     $                    ob_spd(ii).lt.0.05).or.
     $                  (difdir.gt.10.5.and.ob_dir(ii).lt.0.5)).and.
     $                  (c_acftid(ii).eq.c_acftid(iim1)) )) )) then
c
                  indx(knt1) = ii
                  indx(knt0) = iim1
                  isave = ii
                  ii = iim1
                  iim1 = isave
c
                  if(c_qc(iim1)(1:1).eq.'-'.or.
     $               c_qc(iim1)(1:1).eq.'.'.or.
     $               c_qc(iim1)(1:1).eq.'N') 
     $               c_qc(iim1)(1:1) = 'd'
c
                  if(c_qc(ii)(1:1).eq.'-') c_qc(ii)(1:1) = '.'
c
c                 Count rejects by category
c                 -------------------------
                  n_near = n_near + 1
c
                  if(l_ii_sh) then
                    n_near_sh = n_near_sh + 1
                    l_print = .true.
                    if(l_print) then
                      write(io8,*)
                      write(io8,*) 'Near dup found with short id--'
     $,                             ii
                    endif
                    if(l_ii_man.and.l_iim1_man) then
                      n_nr_sh_MaMa = n_nr_sh_MaMa + 1
                      if(l_print) 
     $                  write(io8,*) 'manAIREP-manAIREP dup'
                    elseif(l_ii_man.and.l_iim1_airep) then 
                      n_nr_sh_MaAr = n_nr_sh_MaAr + 1
                      if(l_print) write(io8,*) 'manAIREP-AIREP dup'
                    elseif(l_ii_man.and.l_iim1_mdcrs) then 
                      n_nr_sh_MaMd = n_nr_sh_MaMd + 1
                      if(l_print) write(io8,*) 'manAIREP-MDCRS dup'
                    elseif(l_ii_man.and.l_iim1_acars) then 
                      n_nr_sh_MaAc = n_nr_sh_MaAc + 1
ccccdak                      if(l_print) write(io8,*) 'manAIREP-ACARS dup'
                      if(l_print) write(io8,*) 'manAIREP-TAMDAR dup'
                    elseif(l_iim1_man.and.l_ii_airep) then 
                      n_nr_sh_ArMa = n_nr_sh_ArMa + 1
                      if(l_print) write(io8,*) 'AIREP-manAIREP dup'
                    elseif(l_ii_airep.and.l_iim1_airep) then 
                      n_nr_sh_ArAr = n_nr_sh_ArAr + 1
                      if(l_print) write(io8,*) 'AIREP-AIREP dup'
                    else
                      l_print = .true.
                      if(l_print) then
                        write(io8,*)
                        write(io8,*) 'Uncategorized short-id dup'
                      endif
                    endif
c
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
                  elseif(((l_ii_0lat.and.abs(alat(ii)).gt.0.125).or.
     $                    (l_ii_0lon.and.
     $                     (alon(ii).gt.0.125.and.
     $                      alon(ii).lt.359.875))).and.
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
     $                   (c_acftid(ii).eq.c_acftid(iim1).or.
     $                  l_ii_man.or.l_iim1_man)) then
                    n_near_0ll = n_near_0ll + 1
                    l_print = .false.
                    if(l_print) then
                      write(io8,*)
                      write(io8,*) 'Near dup found with 0l/l--',ii
                    endif
                    if(l_iim1_acars.and.l_ii_acars) then
                      n_nr_0ll_AcAc = n_nr_0ll_AcAc + 1
ccccdak                      if(l_print) write(io8,*) 'ACARS-ACARS dup'
                      if(l_print) write(io8,*) 'TAMDAR-TAMDAR dup'
                    elseif(l_iim1_mdcrs.and.l_ii_mdcrs) then
                      n_nr_0ll_MdMd = n_nr_0ll_MdMd + 1
                      if(l_print) write(io8,*) 'MDCRS-MDCRS dup'
                    elseif(l_ii_man.and.l_iim1_airep) then
                      n_nr_0ll_MaAr = n_nr_0ll_MaAr + 1
                      if(l_print) write(io8,*) 'manAIREP-AIREP dup'
                    elseif(l_ii_amdar.and.l_iim1_airep) then
                      n_nr_0ll_AmAr = n_nr_0ll_AmAr + 1
                      if(l_print) write(io8,*) 'AMDAR-AIREP dup'
                    elseif(l_ii_man.and.l_iim1_man) then
                      n_nr_0ll_MaMa = n_nr_0ll_MaMa + 1
                      if(l_print) write(io8,*) 'manAIREP-manAIREP dup'
                    elseif(l_ii_man.and.l_iim1_mdcrs) then
                      n_nr_0ll_MaMd = n_nr_0ll_MaMd + 1
                      if(l_print) write(io8,*) 'manAIREP-MDCRS dup'
                    elseif(l_ii_mdcrs.and.l_iim1_man) then
                      n_nr_0ll_MdMa = n_nr_0ll_MdMa + 1
                      if(l_print) write(io8,*) 'MDCRS-manAIREP dup'
                    elseif(l_ii_man.and.l_iim1_amdar) then
                      n_nr_0ll_MaAm = n_nr_0ll_MaAm + 1
                      if(l_print) write(io8,*) 'manAIREP-AMDAR dup'
                    elseif(l_ii_amdar.and.l_iim1_man) then
                      n_nr_0ll_AmMa = n_nr_0ll_AmMa + 1
                      if(l_print) write(io8,*) 'AMDAR-manAIREP dup'
                    else
                      l_print = .true.
                      if(l_print) then
                        write(io8,*)
                        write(io8,*) 'Uncategorized near 0l/l dup'
                      endif
                    endif
c
                  elseif(ob_t(ii).ne.amiss.and.
     $                   ob_t(iim1).eq.amiss) then
                    n_near_mst = n_near_mst + 1
                    l_print = .false.
                    if(l_print) then
                      write(io8,*)
                      write(io8,*) 'Near dup found with msg temp--'
     $,                             ii
                    endif
                    if(l_ii_man.and.l_iim1_man) then
                      n_nr_mst_MaMa = n_nr_mst_MaMa + 1
                      if(l_print) 
     $                  write(io8,*) 'manAIREP-manAIREP dup'
                    elseif(l_ii_man.and.l_iim1_airep) then
                      n_nr_mst_MaAr = n_nr_mst_MaAr + 1
                      if(l_print) write(io8,*) 'manAIREP-AIREP dup'
                    elseif(l_ii_man.and.l_iim1_amdar) then
                      n_nr_mst_MaAm = n_nr_mst_MaAm + 1
                      if(l_print) write(io8,*) 'manAIREP-AMDAR dup'
                    elseif(l_ii_airep.and.l_iim1_acars) then
                      n_nr_mst_ArAc = n_nr_mst_ArAc + 1
ccccdak                      if(l_print) write(io8,*) 'AIREP-ACARS dup'
                      if(l_print) write(io8,*) 'AIREP-TAMDAR dup'
                    elseif(l_ii_airep.and.l_iim1_mdcrs) then
                      n_nr_mst_ArMd = n_nr_mst_ArMd + 1
                      if(l_print) write(io8,*) 'AIREP-MDCRS dup'
                    elseif(l_ii_man.and.l_iim1_acars) then
                      n_nr_mst_MaAc = n_nr_mst_MaAc + 1
ccccdak                      if(l_print) write(io8,*) 'manAIREP-ACARS dup'
                      if(l_print) write(io8,*) 'manAIREP-TAMDAR dup'
                    elseif(l_ii_man.and.l_iim1_mdcrs) then
                      n_nr_mst_MaMd = n_nr_mst_MaMd + 1
                      if(l_print) write(io8,*) 'manAIREP-MDCRS dup'
                    elseif(l_ii_mdcrs.and.l_iim1_mdcrs) then
                      n_nr_mst_MdMd = n_nr_mst_MdMd + 1
                      if(l_print) write(io8,*) 'manAIREP-MDCRS dup'
                    elseif(l_iim1_man.and.l_ii_airep) then
                      n_nr_mst_ArMa = n_nr_mst_ArMa + 1
                      if(l_print) write(io8,*) 'AIREP-manAIREP dup'
                    elseif(l_ii_amdar.and.l_iim1_amdar) then
                      n_nr_mst_AmAm = n_nr_mst_AmAm + 1
                      if(l_print) write(io8,*) 'AMDAR-AMDAR dup'
                    elseif(l_ii_airep.and.l_iim1_airep) then
                      n_nr_mst_ArAr = n_nr_mst_ArAr + 1
                      if(l_print) write(io8,*) 'AIREP-AIREP dup'
                    elseif(l_ii_amdar.and.l_iim1_airep) then
                      n_nr_mst_AmAr = n_nr_mst_AmAr + 1
                      if(l_print) write(io8,*) 'AMDAR-AIREP dup'
                    elseif(l_ii_airep.and.l_iim1_amdar) then
                      n_nr_mst_ArAm = n_nr_mst_ArAm + 1
                      if(l_print) write(io8,*) 'AIREP-AMDAR dup'
                    else
                      l_print = .true.
                      if(l_print) then
                        write(io8,*)
                        write(io8,*) 'Uncategorized msg-temp dup'
                      endif
                    endif
c
                  elseif((ob_spd(ii).ne.amiss.and.
     $                    ob_spd(iim1).eq.amiss).or.
     $                   (ob_dir(ii).ne.amiss.and.
     $                    ob_dir(iim1).eq.amiss)) then
                    n_near_ws = n_near_ws + 1
                    l_print = .false.
                    if(c_acftid(iim1)(1:2).eq.'IT') then 
                      n_near_ws_IT = n_near_ws_IT + 1
                      l_print = .false.
                    elseif(c_acftid(iim1)(1:2).eq.'EU') then 
                      n_near_ws_EU = n_near_ws_EU + 1
                      l_print = .false.
                    endif
                    if(l_print) then
                      write(io8,*)
                      write(io8,*) 'Near dup with msg winds--',ii
                    endif
                    if(l_ii_man.and.l_iim1_man) then
                      n_nr_mswn_MaMa = n_nr_mswn_MaMa + 1
                      if(l_print) 
     $                  write(io8,*) 'manAIREP-manAIREP dup'
                    elseif(l_ii_man.and.l_iim1_airep) then 
                      n_nr_mswn_MaAr = n_nr_mswn_MaAr + 1
                      if(l_print) write(io8,*) 'manAIREP-AIREP dup'
                    elseif(l_ii_man.and.l_iim1_amdar) then 
                      n_nr_mswn_MaAm = n_nr_mswn_MaAm + 1
                      if(l_print) write(io8,*) 'manAIREP-AMDAR dup'
                    elseif(l_iim1_man.and.l_ii_airep) then 
                      n_nr_mswn_ArMa = n_nr_mswn_ArMa + 1
                      if(l_print) write(io8,*) 'AIREP-manAIREP dup'
                    elseif(l_ii_airep.and.l_iim1_airep) then 
                      n_nr_mswn_ArAr = n_nr_mswn_ArAr + 1
                      if(l_print) write(io8,*) 'AIREP-AIREP dup'
                    elseif(l_ii_acars.and.l_iim1_acars) then
                      n_nr_mswn_AcAc = n_nr_mswn_AcAc + 1
ccccdak                      if(l_print) write(io8,*) 'ACARS-ACARS dup'
                      if(l_print) write(io8,*) 'TAMDAR-TAMDAR dup'
                    elseif(l_ii_mdcrs.and.l_iim1_mdcrs) then
                      n_nr_mswn_MdMd = n_nr_mswn_MdMd + 1
                      if(l_print) write(io8,*) 'MDCRS-MDCRS dup'
                    elseif(l_ii_acars.and.l_iim1_mdcrs) then
                      n_nr_mswn_AcMd = n_nr_mswn_AcMd + 1
ccccdak                      if(l_print) write(io8,*) 'ACARS-MDCRS dup'
                      if(l_print) write(io8,*) 'TAMDAR-MDCRS dup'
                    elseif(l_ii_mdcrs.and.l_iim1_acars) then
                      n_nr_mswn_MdAc = n_nr_mswn_MdAc + 1
ccccdak                      if(l_print) write(io8,*) 'MDCRS-ACARS dup'
                      if(l_print) write(io8,*) 'MDCRS-TAMDAR dup'
                    elseif(l_ii_mdcrs.and.l_iim1_amdar) then
                      n_nr_mswn_MdAm = n_nr_mswn_MdAm + 1
                      if(l_print) write(io8,*) 'MDCRS-AMDAR dup'
                    elseif(l_ii_mdcrs.and.l_iim1_airep) then
                      n_nr_mswn_MdAr = n_nr_mswn_MdAr + 1
                      if(l_print) write(io8,*) 'MDCRS-AIREP dup'
                    elseif(l_ii_mdcrs.and.l_iim1_man) then
                      n_nr_mswn_MdMa = n_nr_mswn_MdMa + 1
                      if(l_print) write(io8,*) 'MDCRS-manAIREP dup'
                    elseif(l_ii_airep.and.l_iim1_acars) then
                      n_nr_mswn_ArAc = n_nr_mswn_ArAc + 1
ccccdak                      if(l_print) write(io8,*) 'AIREP-ACARS dup'
                      if(l_print) write(io8,*) 'AIREP-TAMDAR dup'
                    elseif(l_ii_airep.and.l_iim1_mdcrs) then
                      n_nr_mswn_ArMd = n_nr_mswn_ArMd + 1
                      if(l_print) write(io8,*) 'AIREP-MDCRS dup'
                    elseif(l_ii_man.and.l_iim1_acars) then
                      n_nr_mswn_MaAc = n_nr_mswn_MaAc + 1
ccccdak                      if(l_print) write(io8,*) 'manAIREP-ACARS dup'
                      if(l_print) write(io8,*) 'manAIREP-TAMDAR dup'
                    elseif(l_ii_man.and.l_iim1_mdcrs) then
                      n_nr_mswn_MaMd = n_nr_mswn_MaMd + 1
                      if(l_print) write(io8,*) 'manAIREP-MDCRS dup'
                    elseif(l_ii_amdar.and.l_iim1_amdar) then
                      n_nr_mswn_AmAm = n_nr_mswn_AmAm + 1
                      if(l_print) write(io8,*) 'AMDAR-AMDAR dup'
                    elseif(l_ii_airep.and.l_iim1_amdar) then
                      n_nr_mswn_ArAm = n_nr_mswn_ArAm + 1
                      if(l_print) write(io8,*) 'AIREP-AMDAR dup'
                    elseif(l_ii_amdar.and.l_iim1_airep) then
                      n_nr_mswn_AmAr = n_nr_mswn_AmAr + 1
                      if(l_print) write(io8,*) 'AMDAR-AIREP dup'
                    elseif(l_ii_acars.and.l_iim1_amdar) then
                      n_nr_mswn_AcAm = n_nr_mswn_AcAm + 1
ccccdak                      if(l_print) write(io8,*) 'ACARS-AMDAR dup'
                      if(l_print) write(io8,*) 'TAMDAR-AMDAR dup'
                    else
                      l_print = .true.
                      if(l_print) then
                        write(io8,*)
                        write(io8,*) 'Uncategorized msg-wind dup'
                      endif
                    endif
c
                  elseif((ob_spd(ii).gt.1.25.and.
     $                    ob_spd(iim1).lt.0.05).or.
     $                   (ob_dir(ii).gt.10.5.and.
     $                    difdir.gt.10.5.and.
     $                    ob_dir(iim1).lt.0.5)) then
                    n_near_0ws = n_near_0ws + 1
                    l_print = .false.
                    if(l_print) then
                      write(io8,*)
                      write(io8,*) 'Near dup found with 0 winds-2-'
     $,                             ii
                    endif
                    if(l_ii_airep.and.l_iim1_amdar) then
                      n_near_0ws_ArAm = n_near_0ws_ArAm + 1
                      if(l_print) write(io8,*) 'AIREP-AMDAR dup'
                    elseif(l_ii_amdar.and.l_iim1_airep) then
                      n_near_0ws_AmAr = n_near_0ws_AmAr + 1
                      if(l_print) write(io8,*) 'AMDAR-AIREP dup'
                    elseif(l_ii_amdar.and.l_iim1_amdar) then
                      n_near_0ws_AmAm = n_near_0ws_AmAm + 1
                      if(l_print) write(io8,*) 'AMDAR-AMDAR dup'
                    elseif(l_ii_airep.and.l_iim1_airep) then
                      n_near_0ws_ArAr = n_near_0ws_ArAr + 1
                      if(l_print) write(io8,*) 'AIREP-AIREP dup'
                    elseif(l_ii_man.and.l_iim1_man) then
                      n_near_0ws_MaMa = n_near_0ws_MaMa + 1
                      if(l_print) 
     $                  write(io8,*) 'manAIREP-manAIREP dup'
                    elseif(l_ii_man.and.l_iim1_mdcrs) then
                      n_near_0ws_MaMd = n_near_0ws_MaMd + 1
                      if(l_print) 
     $                  write(io8,*) 'manAIREP-MDCRS dup'
                    elseif(l_ii_man.and.l_iim1_amdar) then
                      n_near_0ws_MaAm = n_near_0ws_MaAm + 1
                      if(l_print) 
     $                  write(io8,*) 'manAIREP-AMDAR dup'
                    elseif(l_ii_man.and.l_iim1_airep) then
                      n_near_0ws_MaAr = n_near_0ws_MaAr + 1
                      if(l_print) 
     $                  write(io8,*) 'manAIREP-AIREP dup'
                    elseif(l_ii_airep.and.l_iim1_mdcrs) then
                      n_near_0ws_ArMd = n_near_0ws_ArMd + 1
                      if(l_print) 
     $                  write(io8,*) 'AIREP-MDCRS dup'
                    elseif(l_ii_mdcrs.and.l_iim1_mdcrs) then
                      n_near_0ws_MdMd = n_near_0ws_MdMd + 1
                      if(l_print) 
     $                  write(io8,*) 'MDCRS-MDCRS dup'
                    else
                      l_print = .true.
                      if(l_print) then
                        write(io8,*)
                        write(io8,*)'Uncategorized zero-wind dup'
                        write(io8,*) '  dir difference = ',difdir
                      endif
                    endif
c
                  elseif(l_iim1_mdcrs.and.l_ii_acars) then
                    n_near_MdAc = n_near_MdAc + 1
                    l_print = .false.
                    if(l_print) then
                      write(io8,*)
ccccdak                      write(io8,*) 'MDCRS-ACARS near dup found--',ii
                      write(io8,*) 'MDCRS-TAMDAR near dup found--',ii
                    endif
c
                  elseif(itype(iim1).eq.i_mdcrs.and.
     $                   itype(ii  ).ne.i_mdcrs) then
                      n_nr_posrep = n_nr_posrep + 1
                      l_print = .false.
                      if(l_print) then
                        write(io8,*)
                        write(io8,*) 'MDCRS position report dup-2-',ii
                      endif
c
                  elseif(l_iim1_acars.and.l_ii_airep) then
                    n_near_AcAr = n_near_AcAr + 1
                    l_print = .false.
                    if(l_print) then
                      write(io8,*)
ccccdak                      write(io8,*) 'ACARS-AIREP near dup found--',ii
                      write(io8,*) 'TAMDAR-AIREP near dup found--',ii
                    endif
c
                  elseif(l_iim1_mdcrs.and.l_ii_airep) then
                    n_near_MdAr = n_near_MdAr + 1
                    l_print = .false.
                    if(l_print) then
                      write(io8,*)
                      write(io8,*) 'MDCRS-AIREP near dup found--',ii
                    endif
c
                  elseif(l_iim1_amdar.and.l_ii_airep) then
                    n_near_AmAr = n_near_AmAr + 1
                    l_print = .false.
                    if(l_print) then
                      write(io8,*)
                      write(io8,*) 'AMDAR-AIREP near dup found--',ii
                    endif
c
                  elseif(l_iim1_acars.and.l_ii_man) then
                    n_near_AcMa = n_near_AcMa + 1
                    l_print = .false.
                    if(l_print) then
                      write(io8,*)
ccccdak                      write(io8,*) 'ACARS-manAIREP near dup--',ii
                      write(io8,*) 'TAMDAR-manAIREP near dup--',ii
                    endif
c
                  elseif(l_iim1_mdcrs.and.l_ii_man) then
                    n_near_MdMa = n_near_MdMa + 1
                    l_print = .false.
                    if(l_print) then
                      write(io8,*)
                      write(io8,*) 'MDCRS-manAIREP near dup--',ii
                    endif
c
                  elseif(l_iim1_airep.and.l_ii_man) then
                    n_near_ArMa = n_near_ArMa + 1
                    l_print = .false.
                    if(l_print) then
                      write(io8,*)
                      write(io8,*) 'AIREP-manAIREP near dup--',ii
                    endif
c
                  elseif(l_iim1_amdar.and.l_ii_man) then
                    n_near_AmMa = n_near_AmMa + 1
                    l_print = .false.
                    if(l_print) then
                      write(io8,*)
                      write(io8,*) 'AMDAR-manAIREP near dup--',ii
                    endif
c
                  else
                    l_print = .true.
                    if(l_print) then
                      write(io8,*)
                      write(io8,*) 'Uncategorized near dup-2-',ii,
     $                             ' difdir = ',difdir
                    endif
                  endif
c
ccccdak               Exclude other MDCRS-ACARS, MDCRS-AIREP, ACARS-AIREP, MDCRS-MDCRS
ccccdak                 or ACARS-ACARS duplicates
c               Exclude other MDCRS-TAMDAR, MDCRS-AIREP, TAMDAR-AIREP, MDCRS-MDCRS
c                 or TAMDAR-TAMDAR duplicates
c               ----------------------------------------------------------------
                elseif( (l_iim1_mdcrs.and.l_ii_acars).or.
     $                  (l_ii_mdcrs.and.l_iim1_acars).or.
     $                  (l_ii_mdcrs.and.l_iim1_mdcrs).or.
     $                  (l_ii_acars.and.l_iim1_acars).or.
     $                  (l_ii_amdar.and.l_iim1_amdar).or. 
     $                  (l_ii_amdar.and.l_iim1_airep).or.
     $                  (l_ii_airep.and.l_iim1_amdar) ) then 
c
c               Duplicate pair doesn't fall in any of the above categories
c                 but ids are equal
c               Keep ob ii
c               ----------------------------------------------------------
                elseif((c_acftid(ii).eq.c_acftid(iim1)).or.
     $                 (l_ii_man.and.l_iim1_man).or.
     $                 (l_ii_amdar.and.l_ii_amdar.and.
     $                  c_acftid(ii)(1:6).eq.c_acftid(iim1)(1:6)))then
c
                  if(c_qc(iim1)(1:1).eq.'-'.or.
     $               c_qc(iim1)(1:1).eq.'.'.or.
     $               c_qc(iim1)(1:1).eq.'N') 
     $               c_qc(iim1)(1:1) = 'd'
c
                  if(c_qc(ii)(1:1).eq.'-') c_qc(ii)(1:1) = '.'
c
c                 Count rejects by category
c                 -------------------------
                  n_near = n_near + 1
c
                  if(l_ii_airep.and.l_iim1_airep) then
                    n_near_ArAr = n_near_ArAr + 1
                    l_print = .false.
                    if(l_print) then
                      write(io8,*)
                      write(io8,*) 'AIREP-AIREP near dup found--',ii
                    endif
c
                  elseif(l_ii_man.and.l_iim1_man) then
                    n_near_MaMa = n_near_MaMa + 1
                    l_print = .false.
                    if(l_print) then
                      write(io8,*)
                      write(io8,*) 'manAIREP-manAIREP near dup--',ii
                    endif
c
                  elseif(l_ii_amdar.and.l_iim1_amdar) then
                    n_near_AmAm = n_near_AmAm + 1
                    if(c_acftid(ii).eq.c_acftid(iim1)) then
                      l_print = .false.
                    else
                      l_print = .false.
                    endif
                    if(l_print) then
                      write(io8,*)
                      write(io8,*) 'AMDAR-AMDAR near dup found--',ii
                    endif
c
                  else
                    l_print = .true.
                    if(l_print) then
                      write(io8,*)
                      write(io8,*) 'Uncategorized near dup-3-',ii
                    endif
                  endif
c
c               Duplicate pair doesn't fall in any of the above categories
c               Flag to log file but don't reject
c               ----------------------------------------------------------
                elseif(c_acftid(ii).eq.c_acftid(iim1)) then
                  l_print = .true.
                  if(l_print) then
                    write(io8,*)
                    write(io8,*) 'Leftover near duplicate found',ii
                  endif
                endif
c
c             Check if report is a low-windspeed dup not previously caught
c             (These are typically near-surface observations)
c             ------------------------------------------------------------
              elseif(idt_dif.ge.0.and.idt_dif.le.90.and.
     $               c_qc(iim1)(1:1).ne.'D'.and.
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
     $               abs(alat(iim1)-alat(ii)).lt.0.035.and.
     $               abs(alon(iim1)-alon(ii)).lt.0.035.and.
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
c     $               abs(ht_ft(iim1)-ht_ft(ii)).lt.50.5.and.
     $               abs(ht_ft(iim1)-ht_ft(ii)).lt.25.5.and.
     $               (c_acftid(ii).eq.c_acftid(iim1).or.
     $                l_ii_sh.or.l_iim1_sh).and.
c     $               abs(ob_t(iim1)-ob_t(ii)).lt.2.05.and.
     $               abs(ob_t(iim1)-ob_t(ii)).lt.1.25.and.
     $               ((ob_spd(iim1).lt.25.05.and.
     $                 ob_spd(ii).lt.25.05.and.
     $                 abs(ob_spd(iim1)-ob_spd(ii)).lt.2.05.and.
     $                 ((abs(difdir).lt.10.5).or.
     $                  (ob_dir(ii).eq.amiss.and.
     $                   ob_dir(iim1).eq.amiss))).or.
     $                (ob_spd(iim1).lt.15.05.and.
     $                 ob_spd(ii).lt.15.05.and.
     $                 abs(ob_spd(iim1)-ob_spd(ii)).lt.3.55.and.
     $                 ((abs(difdir).lt.15.5).or.
     $                  (ob_dir(ii).eq.amiss.and.
     $                   ob_dir(iim1).eq.amiss))).or.
     $                (ob_spd(iim1).lt.10.05.and.
     $                 ob_spd(ii).lt.10.05.and.
     $                 abs(ob_spd(iim1)-ob_spd(ii)).lt.5.05.and.
     $                 ((abs(difdir).lt.25.5).or.
     $                  (ob_dir(ii).eq.amiss.and.
     $                   ob_dir(iim1).eq.amiss))).or.
     $                (ob_spd(iim1).lt.5.05.and.
     $                 ob_spd(ii).lt.5.05.and.
     $                 ((abs(difdir).lt.45.5).or.
     $                  (ob_dir(ii).eq.amiss.and.
     $                   ob_dir(iim1).eq.amiss))).or.
     $                (ob_spd(iim1).lt.3.65.and.
     $                 ob_spd(ii).lt.3.65).or.
     $             (ob_spd(iim1).eq.amiss.and.ob_spd(ii).ne.amiss).or.
     $             (ob_spd(iim1).ne.amiss.and.ob_spd(ii).eq.amiss).or.
     $             (ob_dir(iim1).eq.amiss.and.ob_dir(ii).ne.amiss).or.
     $                (ob_dir(iim1).ne.amiss.and.ob_dir(ii).eq.amiss))
     $                 ) then
c
c               If near dup found, decide which report to keep
ccccdak                 Choose MDCRS over ACARS
c                 Choose MDCRS over TAMDAR
ccccdak                 Choose ACARS/MDCRS over AIREP/manual AIREP
c                 Choose TAMDAR or MDCRS over AIREP/manual AIREP
c                 Choose AMDAR over AIREP/manual AIREP
c                 Choose automated over manual AIREP
c                 Choose 7-char flight number over 6-char flight number
c                 Choose present over missing flight/tail number
c                 Choose present over missing wind speed
c                 Choose non-zero over zero lat or lon
c               -------------------------------------------------------
c
c               Keep ob ii
c               ----------
                if((l_ii_mdcrs.and.l_iim1_acars).or.
     $             (l_ii_mdcrs.and.l_iim1_airep).or. 
     $             (l_ii_mdcrs.and.l_iim1_man).or.
     $             (l_ii_mdcrs.and.l_iim1_mdcrs.and.
     $              ichk_s(ii).ne.-10).or.
     $             (l_ii_acars.and.l_iim1_airep).or.
     $             (l_ii_acars.and.l_iim1_man).or.
     $             (l_ii_acars.and.l_iim1_acars).or.
     $             (l_ii_amdar.and.l_iim1_airep).or.
     $             (l_ii_amdar.and.l_iim1_man).or.
     $             (l_ii_amdar.and.l_iim1_amdar).or.
     $             (l_ii_airep.and.l_iim1_man).or.
     $             (l_ii_airep.and.l_iim1_airep).or.
     $             (l_ii_man.and.l_iim1_man).or.
     $             l_iim1_sh.or.
     $             (ob_spd(ii).ne.amiss.and.ob_spd(iim1).eq.amiss).or.
     $             (ob_dir(ii).ne.amiss.and.ob_dir(iim1).eq.amiss) 
     $             )then
c
                  if(c_qc(iim1)(1:1).eq.'-'.or.
     $               c_qc(iim1)(1:1).eq.'.'.or.
     $               c_qc(iim1)(1:1).eq.'N') 
     $               c_qc(iim1)(1:1) = 'd'
c
                  if(c_qc(ii)(1:1).eq.'-') c_qc(ii)(1:1) = '.'
c
c                 Count rejects by category
c                 -------------------------
                  n_near = n_near + 1
c
                  if(l_iim1_sh) then
                    n_near_sh = n_near_sh + 1
                    l_print = .true.
                    if(l_print) then
                      write(io8,*)
                      write(io8,*)'Low-wind dup found with short id'
                    endif
                    if(l_iim1_man.and.l_ii_man) then
                      n_nr_sh_MaMa = n_nr_sh_MaMa + 1
                      if(l_print) 
     $                  write(io8,*) 'manAIREP-manAIREP dup'
                    elseif(l_iim1_man.and.l_ii_airep) then 
                      n_nr_sh_MaAr = n_nr_sh_MaAr + 1
                      if(l_print) write(io8,*) 'manAIREP-AIREP dup'
                    elseif(l_iim1_man.and.l_ii_mdcrs) then 
                      n_nr_sh_MaMd = n_nr_sh_MaMd + 1
                      if(l_print) write(io8,*) 'manAIREP-MDCRS dup'
                    elseif(l_iim1_man.and.l_ii_acars) then 
                      n_nr_sh_MaAc = n_nr_sh_MaAc + 1
ccccdak                      if(l_print) write(io8,*) 'manAIREP-ACARS dup'
                      if(l_print) write(io8,*) 'manAIREP-TAMDAR dup'
                    elseif(l_ii_man.and.l_iim1_airep) then 
                      n_nr_sh_ArMa = n_nr_sh_ArMa + 1
                      if(l_print) write(io8,*) 'AIREP-manAIREP dup'
                    elseif(l_iim1_airep.and.l_ii_airep) then 
                      n_nr_sh_ArAr = n_nr_sh_ArAr + 1
                      if(l_print) write(io8,*) 'AIREP-AIREP dup'
                    else
                      l_print = .true.
                      if(l_print) then
                        write(io8,*)
                        write(io8,*) 'Uncat. low-wind short-id dup'
                      endif
                    endif
c
                  elseif((ob_spd(ii).ne.amiss.and.
     $                    ob_spd(iim1).eq.amiss).or.
     $                   (ob_dir(ii).ne.amiss.and.
     $                    ob_dir(iim1).eq.amiss)) then
                    n_near_ws = n_near_ws + 1
                    l_print = .false.
                    if(c_acftid(ii)(1:2).eq.'IT') then 
                      n_near_ws_IT = n_near_ws_IT + 1
                      l_print = .false.
                    elseif(c_acftid(ii)(1:2).eq.'EU') then 
                      n_near_ws_EU = n_near_ws_EU + 1
                      l_print = .false.
                    endif
                    if(l_print) then
                      write(io8,*)
                      write(io8,*)'Low-wind dup found with msg wind'
                    endif
                    if(l_iim1_man.and.l_ii_man) then
                      n_nr_mswn_MaMa = n_nr_mswn_MaMa + 1
                      if(l_print) 
     $                  write(io8,*) 'manAIREP-manAIREP dup'
                    elseif(l_iim1_man.and.l_ii_airep) then 
                      n_nr_mswn_MaAr = n_nr_mswn_MaAr + 1
                      if(l_print) write(io8,*) 'manAIREP-AIREP dup'
                    elseif(l_iim1_man.and.l_ii_amdar) then 
                      n_nr_mswn_MaAm = n_nr_mswn_MaAm + 1
                      if(l_print) write(io8,*) 'manAIREP-AMDAR dup'
                    elseif(l_ii_man.and.l_iim1_airep) then 
                      n_nr_mswn_ArMa = n_nr_mswn_ArMa + 1
                      if(l_print) write(io8,*) 'AIREP-manAIREP dup'
                    elseif(l_iim1_airep.and.l_ii_airep) then 
                      n_nr_mswn_ArAr = n_nr_mswn_ArAr + 1
                      if(l_print) write(io8,*) 'AIREP-AIREP dup'
                    elseif(l_iim1_acars.and.l_ii_acars) then
                      n_nr_mswn_AcAc = n_nr_mswn_AcAc + 1
ccccdak                      if(l_print) write(io8,*) 'ACARS-ACARS dup'
                      if(l_print) write(io8,*) 'TAMDAR-TAMDAR dup'
                    elseif(l_iim1_mdcrs.and.l_ii_mdcrs) then
                      n_nr_mswn_MdMd = n_nr_mswn_MdMd + 1
                      if(l_print) write(io8,*) 'MDCRS-MDCRS dup'
                    elseif(l_iim1_acars.and.l_ii_mdcrs) then
                      n_nr_mswn_AcMd = n_nr_mswn_AcMd + 1
ccccdak                      if(l_print) write(io8,*) 'ACARS-MDCRS dup'
                      if(l_print) write(io8,*) 'TAMDAR-MDCRS dup'
                    elseif(l_iim1_mdcrs.and.l_ii_acars) then
                      n_nr_mswn_MdAc = n_nr_mswn_MdAc + 1
ccccdak                      if(l_print) write(io8,*) 'MDCRS-ACARS dup'
                      if(l_print) write(io8,*) 'MDCRS-TAMDAR dup'
                    elseif(l_iim1_mdcrs.and.l_ii_amdar) then
                      n_nr_mswn_MdAm = n_nr_mswn_MdAm + 1
                      if(l_print) write(io8,*) 'MDCRS-AMDAR dup'
                    elseif(l_iim1_mdcrs.and.l_ii_airep) then
                      n_nr_mswn_MdAr = n_nr_mswn_MdAr + 1
                      if(l_print) write(io8,*) 'MDCRS-AIREP dup'
                    elseif(l_iim1_mdcrs.and.l_ii_man) then
                      n_nr_mswn_MdMa = n_nr_mswn_MdMa + 1
                      if(l_print) write(io8,*) 'MDCRS-manAIREP dup'
                    elseif(l_iim1_airep.and.l_ii_acars) then
                      n_nr_mswn_ArAc = n_nr_mswn_ArAc + 1
ccccdak                      if(l_print) write(io8,*) 'AIREP-ACARS dup'
                      if(l_print) write(io8,*) 'AIREP-TAMDAR dup'
                    elseif(l_iim1_airep.and.l_ii_mdcrs) then
                      n_nr_mswn_ArMd = n_nr_mswn_ArMd + 1
                      if(l_print) write(io8,*) 'AIREP-MDCRS dup'
                    elseif(l_iim1_man.and.l_ii_acars) then
                      n_nr_mswn_MaAc = n_nr_mswn_MaAc + 1
ccccdak                      if(l_print) write(io8,*) 'manAIREP-ACARS dup'
                      if(l_print) write(io8,*) 'manAIREP-TAMDAR dup'
                    elseif(l_iim1_man.and.l_ii_mdcrs) then
                      n_nr_mswn_MaMd = n_nr_mswn_MaMd + 1
                      if(l_print) write(io8,*) 'manAIREP-MDCRS dup'
                    elseif(l_iim1_amdar.and.l_ii_amdar) then
                      n_nr_mswn_AmAm = n_nr_mswn_AmAm + 1
                      if(l_print) write(io8,*) 'AMDAR-AMDAR dup'
                    elseif(l_iim1_airep.and.l_ii_amdar) then
                      n_nr_mswn_ArAm = n_nr_mswn_ArAm + 1
                      if(l_print) write(io8,*) 'AIREP-AMDAR dup'
                    elseif(l_iim1_amdar.and.l_ii_airep) then
                      n_nr_mswn_AmAr = n_nr_mswn_AmAr + 1
                      if(l_print) write(io8,*) 'AMDAR-AIREP dup'
                    elseif(l_iim1_acars.and.l_ii_amdar) then
                      n_nr_mswn_AcAm = n_nr_mswn_AcAm + 1
ccccdak                      if(l_print) write(io8,*) 'ACARS-AMDAR dup'
                      if(l_print) write(io8,*) 'TAMDAR-AMDAR dup'
                    else
                      l_print = .true.
                      if(l_print) then
                        write(io8,*)
                        write(io8,*) 'Uncat. low-wind msg-wind dup'
                      endif
                    endif
c
                  elseif(l_ii_mdcrs.and.l_iim1_acars) then
                    n_slow_MdAc = n_slow_MdAc + 1
                    l_print = .false.
                    if(l_print) then
                      write(io8,*)
ccccdak                      write(io8,*) 'MDCRS-ACARS low-wind dup found'
                      write(io8,*) 'MDCRS-TAMDAR low-wind dup found'
                    endif
c
                  elseif(l_ii_mdcrs.and.l_iim1_airep) then
                    n_slow_MdAr = n_slow_MdAr + 1
                    l_print = .false.
                    if(l_print) then
                      write(io8,*)
                      write(io8,*) 'MDCRS-AIREP low-wind dup found'
                    endif
c
                  elseif(l_ii_mdcrs.and.l_iim1_mdcrs) then
                    if(ichk_s(iim1).eq.-10) then
                      n_nr_bad_roll_Md = n_nr_bad_roll_Md + 1
                      l_print = .false.
                      if(l_print) then
                        write(io8,*)
                        write(io8,*)'MDCRS-MDCRS bad roll qc lw dup'
                      endif
                    else
                      n_slow_MdMd = n_slow_MdMd + 1
                      l_print = .false.
                      if(l_print) then
                        write(io8,*)
                        write(io8,*)'MDCRS-MDCRS low-wind dup found'
                      endif
                    endif
c
                  elseif(l_ii_acars.and.l_iim1_airep) then
                    n_slow_AcAr = n_slow_AcAr + 1
                    l_print = .false.
                    if(l_print) then
                      write(io8,*)
ccccdak                      write(io8,*) 'ACARS-AIREP low-wind dup found'
                      write(io8,*) 'TAMDAR-AIREP low-wind dup found'
                    endif
c
                  elseif(l_ii_acars.and.l_iim1_acars) then
                    n_slow_AcAc = n_slow_AcAc + 1
                    l_print = .false.
                    if(l_print) then
                      write(io8,*)
ccccdak                      write(io8,*) 'ACARS-ACARS low-wind dup found'
                      write(io8,*) 'TAMDAR-TAMDAR low-wind dup found'
                    endif
c
                  elseif(l_ii_amdar.and.l_iim1_airep) then
                    n_slow_AmAr = n_slow_AmAr + 1
                    l_print = .false.
                    if(l_print) then
                      write(io8,*)
                      write(io8,*) 'AMDAR-AIREP low-wind dup found'
                    endif
c
                  elseif(l_ii_amdar.and.l_iim1_amdar) then
                    if(ichk_s(iim1).eq.-10) then
                      n_nr_bad_roll_Am = n_nr_bad_roll_Am + 1
                      l_print = .false.
                      if(l_print) then
                        write(io8,*)
                        write(io8,*)'AMDAR-AMDAR bad roll qc lw dup'
                      endif
                    else
                      n_slow_AmAm = n_slow_AmAm + 1
                      l_print = .false.
                      if(l_print) then
                        write(io8,*)
                        write(io8,*) 'AMDAR-AMDAR low-wind dup found'
                      endif
                    endif
c
                  elseif(l_ii_airep.and.l_iim1_man) then
                    n_slow_ArMa = n_slow_ArMa + 1
                    l_print = .false.
                    if(l_print) then
                      write(io8,*)
                      write(io8,*) 'AIREP-manAIREP low-wind dup'
                    endif
c
                  elseif(l_ii_airep.and.l_iim1_airep) then
                    n_slow_ArAr = n_slow_ArAr + 1
                    l_print = .false.
                    if(l_print) then
                      write(io8,*)
                      write(io8,*) 'AIREP-AIREP low-wind dup found'
                    endif
c
                  elseif(l_ii_man.and.l_iim1_man) then
                    n_slow_MaMa = n_slow_MaMa + 1
                    l_print = .false.
                    if(l_print) then
                      write(io8,*)
                      write(io8,*)'manAIREP-manAIREP low-wind dup'
                    endif
c
                  else
                    l_print = .true.
                    if(l_print) then
                      write(io8,*)
                      write(io8,*) 'Uncategorized low-wind dup-1-'
                    endif
                  endif
c
c               Keep ob iim1
c               ------------
                elseif((l_iim1_mdcrs.and.l_ii_acars).or.
     $                 (l_iim1_mdcrs.and.l_ii_airep).or. 
     $                 (l_iim1_mdcrs.and.l_ii_man).or.
     $                 (l_iim1_mdcrs.and.l_ii_mdcrs).or.
     $                 (l_iim1_acars.and.l_ii_airep).or.
     $                 (l_iim1_acars.and.l_ii_man).or.
     $                 (l_iim1_acars.and.l_ii_acars).or.
     $                 (l_iim1_amdar.and.l_ii_airep).or.
     $                 (l_iim1_amdar.and.l_ii_man).or.
     $                 (l_iim1_airep.and.l_ii_man).or.
     $                 l_ii_sh.or.
     $                 (ob_spd(iim1).ne.amiss.and.
     $                  ob_spd(ii).eq.amiss).or.
     $                 (ob_dir(iim1).ne.amiss.and.
     $                  ob_dir(ii).eq.amiss)) then
c
                    indx(knt1) = ii
                    indx(knt0) = iim1
                    isave = ii
                    ii = iim1
                    iim1 = isave
c
                  if(c_qc(iim1)(1:1).eq.'-'.or.
     $               c_qc(iim1)(1:1).eq.'.'.or.
     $               c_qc(iim1)(1:1).eq.'N') 
     $               c_qc(iim1)(1:1) = 'd'
c
                  if(c_qc(ii)(1:1).eq.'-') c_qc(ii)(1:1) = '.'
c
c                 Count rejects by category
c                 -------------------------
                  n_near = n_near + 1
c
                  if(l_ii_sh) then
                    n_near_sh = n_near_sh + 1
                    l_print = .true.
                    if(l_print) then
                      write(io8,*)
                      write(io8,*)'Low-wind dup found with short id'
                    endif
                    if(l_ii_man.and.l_iim1_man) then
                      n_nr_sh_MaMa = n_nr_sh_MaMa + 1
                      if(l_print) 
     $                  write(io8,*) 'manAIREP-manAIREP dup'
                    elseif(l_ii_man.and.l_iim1_airep) then 
                      n_nr_sh_MaAr = n_nr_sh_MaAr + 1
                      if(l_print) write(io8,*) 'manAIREP-AIREP dup'
                    elseif(l_ii_man.and.l_iim1_mdcrs) then 
                      n_nr_sh_MaMd = n_nr_sh_MaMd + 1
                      if(l_print) write(io8,*) 'manAIREP-MDCRS dup'
                    elseif(l_ii_man.and.l_iim1_acars) then 
                      n_nr_sh_MaAc = n_nr_sh_MaAc + 1
ccccdak                      if(l_print) write(io8,*) 'manAIREP-ACARS dup'
                      if(l_print) write(io8,*) 'manAIREP-TAMDAR dup'
                    elseif(l_iim1_man.and.l_ii_airep) then 
                      n_nr_sh_ArMa = n_nr_sh_ArMa + 1
                      if(l_print) write(io8,*) 'AIREP-manAIREP dup'
                    elseif(l_ii_airep.and.l_iim1_airep) then 
                      n_nr_sh_ArAr = n_nr_sh_ArAr + 1
                      if(l_print) write(io8,*) 'AIREP-AIREP dup'
                    else
                      l_print = .true.
                      if(l_print) then
                        write(io8,*)
                        write(io8,*) 'Uncat. low-wind short-id dup'
                      endif
                    endif
c
                  elseif((ob_spd(ii).ne.amiss.and.
     $                    ob_spd(iim1).eq.amiss).or.
     $                   (ob_dir(ii).ne.amiss.and.
     $                    ob_dir(iim1).eq.amiss)) then
                    n_near_ws = n_near_ws + 1
                    l_print = .false.
                    if(c_acftid(iim1)(1:2).eq.'IT') then 
                      n_near_ws_IT = n_near_ws_IT + 1
                      l_print = .false.
                    elseif(c_acftid(iim1)(1:2).eq.'EU') then 
                      n_near_ws_EU = n_near_ws_EU + 1
                      l_print = .false.
                    endif
                    if(l_print) then
                      write(io8,*)
                      write(io8,*) 'Low-wind dup with msg winds'
                    endif
                    if(l_ii_man.and.l_iim1_man) then
                      n_nr_mswn_MaMa = n_nr_mswn_MaMa + 1
                      if(l_print) 
     $                  write(io8,*) 'manAIREP-manAIREP dup'
                    elseif(l_ii_man.and.l_iim1_airep) then 
                      n_nr_mswn_MaAr = n_nr_mswn_MaAr + 1
                      if(l_print) write(io8,*) 'manAIREP-AIREP dup'
                    elseif(l_ii_man.and.l_iim1_amdar) then 
                      n_nr_mswn_MaAm = n_nr_mswn_MaAm + 1
                      if(l_print) write(io8,*) 'manAIREP-AMDAR dup'
                    elseif(l_iim1_man.and.l_ii_airep) then 
                      n_nr_mswn_ArMa = n_nr_mswn_ArMa + 1
                      if(l_print) write(io8,*) 'AIREP-manAIREP dup'
                    elseif(l_ii_airep.and.l_iim1_airep) then 
                      n_nr_mswn_ArAr = n_nr_mswn_ArAr + 1
                      if(l_print) write(io8,*) 'AIREP-AIREP dup'
                    elseif(l_ii_acars.and.l_iim1_acars) then
                      n_nr_mswn_AcAc = n_nr_mswn_AcAc + 1
ccccdak                      if(l_print) write(io8,*) 'ACARS-ACARS dup'
                      if(l_print) write(io8,*) 'TAMDAR-TAMDAR dup'
                    elseif(l_ii_mdcrs.and.l_iim1_mdcrs) then
                      n_nr_mswn_MdMd = n_nr_mswn_MdMd + 1
                      if(l_print) write(io8,*) 'MDCRS-MDCRS dup'
                    elseif(l_ii_acars.and.l_iim1_mdcrs) then
                      n_nr_mswn_AcMd = n_nr_mswn_AcMd + 1
ccccdak                      if(l_print) write(io8,*) 'ACARS-MDCRS dup'
                      if(l_print) write(io8,*) 'TAMDAR-MDCRS dup'
                    elseif(l_ii_mdcrs.and.l_iim1_acars) then
                      n_nr_mswn_MdAc = n_nr_mswn_MdAc + 1
ccccdak                      if(l_print) write(io8,*) 'MDCRS-ACARS dup'
                      if(l_print) write(io8,*) 'MDCRS-TAMDAR dup'
                    elseif(l_ii_mdcrs.and.l_iim1_amdar) then
                      n_nr_mswn_MdAm = n_nr_mswn_MdAm + 1
                      if(l_print) write(io8,*) 'MDCRS-AMDAR dup'
                    elseif(l_ii_mdcrs.and.l_iim1_airep) then
                      n_nr_mswn_MdAr = n_nr_mswn_MdAr + 1
                      if(l_print) write(io8,*) 'MDCRS-AIREP dup'
                    elseif(l_ii_mdcrs.and.l_iim1_man) then
                      n_nr_mswn_MdMa = n_nr_mswn_MdMa + 1
                      if(l_print) write(io8,*) 'MDCRS-manAIREP dup'
                    elseif(l_ii_airep.and.l_iim1_acars) then
                      n_nr_mswn_ArAc = n_nr_mswn_ArAc + 1
ccccdak                      if(l_print) write(io8,*) 'AIREP-ACARS dup'
                      if(l_print) write(io8,*) 'AIREP-TAMDAR dup'
                    elseif(l_ii_airep.and.l_iim1_mdcrs) then
                      n_nr_mswn_ArMd = n_nr_mswn_ArMd + 1
                      if(l_print) write(io8,*) 'AIREP-MDCRS dup'
                    elseif(l_ii_man.and.l_iim1_acars) then
                      n_nr_mswn_MaAc = n_nr_mswn_MaAc + 1
ccccdak                      if(l_print) write(io8,*) 'manAIREP-ACARS dup'
                      if(l_print) write(io8,*) 'manAIREP-TAMDAR dup'
                    elseif(l_ii_man.and.l_iim1_mdcrs) then
                      n_nr_mswn_MaMd = n_nr_mswn_MaMd + 1
                      if(l_print) write(io8,*) 'manAIREP-MDCRS dup'
                    elseif(l_ii_amdar.and.l_iim1_amdar) then
                      n_nr_mswn_AmAm = n_nr_mswn_AmAm + 1
                      if(l_print) write(io8,*) 'AMDAR-AMDAR dup'
                    elseif(l_ii_airep.and.l_iim1_amdar) then
                      n_nr_mswn_ArAm = n_nr_mswn_ArAm + 1
                      if(l_print) write(io8,*) 'AIREP-AMDAR dup'
                    elseif(l_ii_amdar.and.l_iim1_airep) then
                      n_nr_mswn_AmAr = n_nr_mswn_AmAr + 1
                      if(l_print) write(io8,*) 'AMDAR-AIREP dup'
                    elseif(l_ii_acars.and.l_iim1_amdar) then
                      n_nr_mswn_AcAm = n_nr_mswn_AcAm + 1
ccccdak                      if(l_print) write(io8,*) 'ACARS-AMDAR dup'
                      if(l_print) write(io8,*) 'TAMDAR-AMDAR dup'
                    else
                      l_print = .true.
                      if(l_print) then
                        write(io8,*)
                        write(io8,*) 'Uncat. low-wind msg-wind dup'
                      endif
                    endif
c
                  elseif(l_iim1_mdcrs.and.l_ii_acars) then
                    n_slow_MdAc = n_slow_MdAc + 1
                    l_print = .false.
                    if(l_print) then
                      write(io8,*)
ccccdak                      write(io8,*) 'MDCRS-ACARS low-wind dup found'
                      write(io8,*) 'MDCRS-TAMDAR low-wind dup found'
                    endif
c
                  elseif(l_iim1_mdcrs.and.l_ii_airep) then
                    n_slow_MdAr = n_slow_MdAr + 1
                    l_print = .false.
                    if(l_print) then
                      write(io8,*)
                      write(io8,*) 'MDCRS-AIREP low-wind dup found'
                    endif
c
                  elseif(l_ii_mdcrs.and.l_iim1_mdcrs) then
                    if(ichk_s(iim1).eq.-10) then
                      n_nr_bad_roll_Md = n_nr_bad_roll_Md + 1
                      l_print = .false.
                      if(l_print) then
                        write(io8,*)
                        write(io8,*)'MDCRS-MDCRS bad roll qc lw dup'
                      endif
                    else
                      n_slow_MdMd = n_slow_MdMd + 1
                      l_print = .false.
                      if(l_print) then
                        write(io8,*)
                        write(io8,*)'MDCRS-MDCRS low-wind dup found'
                      endif
                    endif
c
                  elseif(l_iim1_acars.and.l_ii_airep) then
                    n_slow_AcAr = n_slow_AcAr + 1
                    l_print = .false.
                    if(l_print) then
                      write(io8,*)
ccccdak                      write(io8,*) 'ACARS-AIREP low-wind dup found'
                      write(io8,*) 'TAMDAR-AIREP low-wind dup found'
                    endif
c
                  elseif(l_iim1_acars.and.l_ii_acars) then
                    n_slow_AcAc = n_slow_AcAc + 1
                    l_print = .false.
                    if(l_print) then
                      write(io8,*)
ccccdak                      write(io8,*) 'ACARS-ACARS low-wind dup found'
                      write(io8,*) 'TAMDAR-TAMDAR low-wind dup found'
                    endif
c
                  elseif(l_ii_amdar.and.l_iim1_amdar) then
                    if(ichk_s(iim1).eq.-10) then
                      n_nr_bad_roll_Am = n_nr_bad_roll_Am + 1
                      l_print = .false.
                      if(l_print) then
                        write(io8,*)
                        write(io8,*)'AMDAR-AMDAR bad roll qc lw dup'
                      endif
                    else
                      n_slow_AmAm = n_slow_AmAm + 1
                      l_print = .false.
                      if(l_print) then
                        write(io8,*)
                        write(io8,*)'AMDAR-AMDAR low-wind dup found'
                      endif
                    endif
c
                  elseif(l_iim1_amdar.and.l_ii_airep) then
                    n_slow_AmAr = n_slow_AmAr + 1
                    l_print = .false.
                    if(l_print) then
                      write(io8,*)
                      write(io8,*) 'AMDAR-AIREP low-wind dup found'
                    endif
c
                  elseif(l_iim1_airep.and.l_ii_man) then
                    n_slow_ArMa = n_slow_ArMa + 1
                    l_print = .false.
                    if(l_print) then
                      write(io8,*)
                      write(io8,*) 'AIREP-manAIREP low-wind dup'
                    endif
c
                  else
                    l_print = .true.
                    if(l_print) then
                      write(io8,*)
                      write(io8,*) 'Uncategorized low-wind dup-2-'
                    endif
                  endif
                endif
c
c             Check if report is a near dup except for flight id (not rejected)
c             Echo to log file for later inspection
c             -----------------------------------------------------------------
              elseif(idt_dif.ge.0.and.idt_dif.le.90.and.
     $               c_qc(iim1)(1:1).ne.'D'.and.
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
     $               abs(alat(iim1)-alat(ii)).lt.0.125.and.
     $               abs(alon(iim1)-alon(ii)).lt.0.125.and.
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
     $               ((ht_ft(ii).lt.25000.and.
     $             abs(ht_ft(iim1)-ht_ft(ii)).lt.htdif_same/4+0.5).or.
     $                (((l_ii_mdcrs.and.(.not.l_iim1_mdcrs)).or.        ! new
     $                  (l_iim1_mdcrs.and.(.not.l_ii_mdcrs)).or.        ! new
     $                  (l_ii_acars.and.(.not.l_iim1_acars)).or.        ! new
     $                  (l_iim1_acars.and.(.not.l_ii_acars)).or.        ! new
     $                  (l_ii_man.and.(.not.l_iim1_man)).or.            ! new
     $                  (l_iim1_man.and.(.not.l_ii_man)).or.            ! new
     $                  (((l_ii_amdar.and.l_iim1_amdar).or.             ! new
     $                    (l_ii_airep.and.l_iim1_amdar).or.             ! new
     $                    (l_iim1_airep.and.l_ii_amdar)).and.           ! new
     $                   c_acftid(ii).eq.c_acftid(iim1)) ).and.         ! new
     $                  ht_ft(ii).lt.25000.and.
     $               abs(ht_ft(iim1)-ht_ft(ii)).lt.htdif_same+0.5).or.
     $                (ht_ft(ii).gt.24999.5.and.
     $               abs(ht_ft(iim1)-ht_ft(ii)).lt.htdif_same+0.5)).and.
     $               abs(ob_t(iim1)-ob_t(ii)).lt.1.25.and.
     $               ((abs(ob_spd(iim1)-ob_spd(ii)).lt.1.25.and.
     $                 ((abs(difdir).lt.10.5).or.
     $                  (ob_dir(ii).eq.amiss.and.
     $                   ob_dir(iim1).eq.amiss))).or.
     $               (ob_spd(iim1).eq.amiss.and.ob_spd(ii).ne.amiss).or.
     $               (ob_spd(iim1).ne.amiss.and.ob_spd(ii).eq.amiss).or.
     $               (ob_dir(iim1).eq.amiss.and.ob_dir(ii).ne.amiss).or.
     $                (ob_dir(iim1).ne.amiss.and.ob_dir(ii).eq.amiss))
     $                 ) then
c
                l_print = .true.
                if(l_print) then
                  write(io8,*)
                  write(io8,*) 'Non-rejected duplicate found--',ii
                endif
c
c             Check if airep report is an exact dup except for large temperature or
c             wind differences--assume encode error and reject both!
c             -----------------------------------------------------------------
              elseif((idt_dif.ge.0.and.idt_dif.le.90).and.
     $               c_qc(iim1)(1:1).ne.'D'.and.
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
     $               abs(alat(iim1)-alat(ii)).lt.0.035.and.
     $               abs(alon(iim1)-alon(ii)).lt.0.035.and.
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
     $               (abs(ht_ft(iim1)-ht_ft(ii)).lt.0.5.or.
     $                abs(pres(iim1)-pres(ii)).lt.0.05).and.
     $               (c_acftid(ii).eq.c_acftid(iim1).or.
     $                l_ii_sh.or.l_iim1_sh).and.
     $               (l_ii_man.and.l_iim1_man)) then
c
                l_print = .true.
                if(l_print) then
                  write(io8,*)
                  write(io8,*) 'Encoding problem detected'
                endif
c
c               Special case where winds are missing
c               (Temperature for that report is usually way off!)
c               Reject report with missing winds
c               -------------------------------------------------
                if(ob_spd(iim1).eq.amiss.and.ob_spd(ii).ne.amiss.and.
     $             ob_dir(iim1).eq.amiss.and.ob_dir(ii).ne.amiss.and.
     $             (c_qc(iim1)(1:1).eq.'-'.or.
     $              c_qc(iim1)(1:1).eq.'.'.or.
     $              c_qc(iim1)(1:1).eq.'N')) then
c
                  c_qc(iim1)(1:1) = 'e'
c
                elseif(ob_spd(ii).eq.amiss.and.
     $                 ob_spd(iim1).ne.amiss.and.
     $                 ob_dir(ii).eq.amiss.and.
     $                 ob_dir(iim1).ne.amiss.and.
     $                 (c_qc(ii)(1:1).eq.'-'.or.
     $                  c_qc(ii)(1:1).eq.'.'.or.
     $                  c_qc(ii)(1:1).eq.'N')) then
c
                  indx(knt1) = ii
                  indx(knt0) = iim1
                  isave = ii
                  ii = iim1
                  iim1 = isave
                  c_qc(iim1)(1:1) = 'e'
c
                elseif((c_acftid(ii).eq.c_acftid(iim1).or.
     $                  l_iim1_sh).and.
     $                 (c_qc(iim1)(1:1).eq.'-'.or.
     $                  c_qc(iim1)(1:1).eq.'.'.or.
     $                  c_qc(iim1)(1:1).eq.'N')) then
c
                  c_qc(iim1)(1:1) = 'E'
c
               elseif((c_acftid(ii).eq.c_acftid(iim1).or.l_ii_sh).and.
     $                 (c_qc(ii)(1:1).eq.'-'.or.
     $                  c_qc(ii)(1:1).eq.'.'.or.
     $                  c_qc(ii)(1:1).eq.'N')) then
c
                  indx(knt1) = ii
                  indx(knt0) = iim1
                  isave = ii
                  ii = iim1
                  iim1 = isave
                  c_qc(iim1)(1:1) = 'E'
c
                endif
c
                if(abs(ob_t(iim1)-ob_t(ii)).lt.2.05.and.
     $             abs(difdir).lt.10.5.and.
     $             abs(ob_spd(iim1)-ob_spd(ii)).lt.1.25) then
c
                  c_qc(iim1)(1:1) = 'd'
c
                  if(l_print) write(io8,*) 'Near duplicate'
                  n_near = n_near + 1
                  n_near_MaMa = n_near_MaMa + 1
c
                else
                  n_bad_encode = n_bad_encode + 1
c
                  if(abs(ob_t(iim1)-ob_t(ii)).gt.2.05.and.
     $               c_qc(iim1)(1:1).ne.'e') then 
                    c_qc(ii)(6:6) = 'E'
                    if(l_print) write(io8,*) 'Bad temperature'
                  endif
c
                  if(abs(difdir).gt.10.5.and.
     $               c_qc(iim1)(1:1).ne.'e') then 
                    c_qc(ii)(7:7) = 'E'
                    if(l_print) write(io8,*) 'Bad wind direction'
                  endif
c
                  if(abs(ob_spd(iim1)-ob_spd(ii)).gt.1.25.and. 
     $               c_qc(iim1)(1:1).ne.'e') then 
                    c_qc(ii)(8:8) = 'E'
                    if(l_print) write(io8,*) 'Bad windspeed'
                  endif
                endif
c
c             Check if report is a position dup 
c             Echo to log file for later inspection
c             -------------------------------------
              elseif(idt_dif.ge.0.and.idt_dif.le.90.and.
     $               c_qc(iim1)(1:1).ne.'D'.and.
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
     $               abs(alat(iim1)-alat(ii)).lt.0.035.and.
     $               abs(alon(iim1)-alon(ii)).lt.0.035.and.
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
c     $               abs(ht_ft(iim1)-ht_ft(ii)).lt.50.5.and.
     $               abs(ht_ft(iim1)-ht_ft(ii)).lt.25.5.and.
     $               (c_acftid(ii).eq.c_acftid(iim1).or.
     $                l_ii_sh.or.l_iim1_sh)) then
c
c               Check if MDCRS-MDCRS duplicate has a bad roll angle
c               ---------------------------------------------------
                if((ichk_s(iim1).eq.-10.and.
     $              ichk_s(ii  ).ne.-10).and.
     $             l_iim1_mdcrs.and.l_ii_mdcrs.and.
     $             abs(ob_t(iim1)-ob_t(ii)).lt.1.25.and.
     $             (c_qc(iim1)(1:1).eq.'-'.or.
     $              c_qc(iim1)(1:1).eq.'.'.or.
     $              c_qc(iim1)(1:1).eq.'N')) then
c
                  c_qc(iim1)(1:1) = 'd'
c
                  n_near = n_near + 1
                  n_nr_bad_roll_Md = n_nr_bad_roll_Md + 1
c
                  l_print = .false.
                  if(l_print) then
                    write(io8,*)
                    write(io8,*) 'Bad roll angle qc - MDCRS'
                  endif
c
                elseif((ichk_s(ii  ).eq.-10.and.
     $                  ichk_s(iim1).ne.-10).and.
     $                 l_iim1_mdcrs.and.l_ii_mdcrs.and.
     $                 abs(ob_t(iim1)-ob_t(ii)).lt.1.25.and.
     $                 (c_qc(ii)(1:1).eq.'-'.or.
     $                  c_qc(ii)(1:1).eq.'.'.or.
     $                  c_qc(ii)(1:1).eq.'N')) then
c
                  indx(knt1) = ii
                  indx(knt0) = iim1
                  isave = ii
                  ii = iim1
                  iim1 = isave
c
                  c_qc(iim1)(1:1) = 'd'
c
                  n_near = n_near + 1
                  n_nr_bad_roll_Md = n_nr_bad_roll_Md + 1
c
                  l_print = .false.
                  if(l_print) then
                    write(io8,*)
                    write(io8,*) 'Bad roll angle qc - MDCRS'
                  endif
c
c               Check if AMDAR-AMDAR duplicate has a bad roll angle
c               ---------------------------------------------------
                elseif((ichk_s(iim1).eq.-10.and.
     $                  ichk_s(ii  ).ne.-10).and.
     $             l_iim1_amdar.and.l_ii_amdar.and.
     $             abs(ob_t(iim1)-ob_t(ii)).lt.1.25.and.
     $             (c_qc(iim1)(1:1).eq.'-'.or.
     $              c_qc(iim1)(1:1).eq.'.'.or.
     $              c_qc(iim1)(1:1).eq.'N')) then
c
                  c_qc(iim1)(1:1) = 'd'
c
                  n_near = n_near + 1
                  n_nr_bad_roll_Am = n_nr_bad_roll_Am + 1
c
                  l_print = .false.
                  if(l_print) then
                    write(io8,*)
                    write(io8,*) 'Bad roll angle qc - AMDAR'
                  endif
c
                elseif((ichk_s(ii  ).eq.-10.and.
     $                  ichk_s(iim1).ne.-10).and.
     $                 l_iim1_amdar.and.l_ii_amdar.and.
     $                 abs(ob_t(iim1)-ob_t(ii)).lt.1.25.and.
     $                 (c_qc(ii)(1:1).eq.'-'.or.
     $                  c_qc(ii)(1:1).eq.'.'.or.
     $                  c_qc(ii)(1:1).eq.'N')) then
c
                  indx(knt1) = ii
                  indx(knt0) = iim1
                  isave = ii
                  ii = iim1
                  iim1 = isave
c
                  c_qc(iim1)(1:1) = 'd'
c
                  n_near = n_near + 1
                  n_nr_bad_roll_Am = n_nr_bad_roll_Am + 1
c
                  l_print = .false.
                  if(l_print) then
                    write(io8,*)
                    write(io8,*) 'Bad roll angle qc - AMDAR'
                  endif
c
                else
                  if(c_qc(ii)(1:1).eq.'-') c_qc(ii)(1:1) = '.'
                  l_print = .false.
                  if(l_print) then
                    write(io8,*)
                    write(io8,*) 'Position duplicate found'
                  endif
c
                endif
c
c             Set c_qc to '.' if no duplicate found within 60 sec window
c             ----------------------------------------------------------
              else
                if(c_qc(ii)(1:1).eq.'-') c_qc(ii)(1:1) = '.'
              endif
c
c           Set c_qc to '.' if lats and lons too far apart
c           ----------------------------------------------
            else
              if(c_qc(ii)(1:1).eq.'-') c_qc(ii)(1:1) = '.'
            endif
c
            if(l_print) then
c            if(c_qc(iim1)(1:1).eq.'d'.and.
c     $         (idt(ii).ne.idt(iim1).or.
c     $          c_acftid(ii).ne.c_acftid(iim1))) then
              write(io8,*)
              write(io8,8002) kkdup,iim1,c_insty_ob(itype(iim1))
     x,            c_acftreg(iim1),c_acftid(iim1)
     x,            idt(iim1),alat(iim1),alon(iim1)
     x,            pres(iim1),ht_ft(iim1)
     x,            t_prcn(iim1),ob_t(iim1),xiv_t(iim1),ichk_t(iim1)
     x,            ob_q(iim1),xiv_q(iim1),ichk_q(iim1)
     x,            ob_dir(iim1),xiv_d(iim1),ichk_d(iim1)
     x,            ob_spd(iim1),xiv_s(iim1),ichk_s(iim1)
     x,            c_qc(iim1)
              write(io8,8002) kkdup,ii,c_insty_ob(itype(ii))
     x,            c_acftreg(ii),c_acftid(ii)
     x,            idt(ii),alat(ii),alon(ii)
     x,            pres(ii),ht_ft(ii)
     x,            t_prcn(ii),ob_t(ii),xiv_t(ii),ichk_t(ii)
     x,            ob_q(ii),xiv_q(ii),ichk_q(ii)
     x,            ob_dir(ii),xiv_d(ii),ichk_d(ii)
     x,            ob_spd(ii),xiv_s(ii),ichk_s(ii)
     x,            c_qc(ii)
 8002         format(i3,1x,i6,1x,a8,1x,a8,1x,a9,1x,i7,1x,2f11.5,1x
     x,            f8.1,1x,f7.0,1x,f5.2,4(2(1x,f8.2),1x,i5),1x
     x,            '!',a11,'!')
            endif
cc
ccccccdak           Set up table associating airep and acars flight ids
cc           Set up table associating airep and tamdar flight ids
cc           Require that the report be within idt_samflt of the previously
cc             saved minimum and maximum times for this flight segment
cc             and is within fairly close limits on position, temp and winds
cc           ---------------------------------------------------------------
c            if( ( (l_ii_acars   .and..not.l_iim1_acars ).or.
c     $            (l_iim1_acars .and..not.l_ii_acars   ).or.
c     $            (l_ii_mdcrs  .and..not.l_iim1_mdcrs).or.
c     $            (l_iim1_mdcrs.and..not.l_ii_mdcrs  ) ).and.
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
c     $          abs(alat(iim1)-alat(ii))    .lt.0.025.and.
c     $          abs(alon(iim1)-alon(ii))    .lt.0.025.and.
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
c     $          abs(ob_t(iim1)-ob_t(ii))    .lt.0.65.and.
c     $          abs(difdir).lt.5.5.and.
c     $          abs(ob_spd(iim1)-ob_spd(ii)).lt.0.55.and.  
c     $          (c_qc(iim1)(1:1).eq.'D'.or.c_qc(iim1)(1:1).eq.'d').and.
c     $          c_acftid(iim1)(1:8).ne.c_acftid(ii)(1:8) ) then
cc
c              if(ndup.ne.0) then
c                kk = 1
cc
c                do while (kk.le.ndup)
c                  min_idt = idt_min(kk) - idt_samflt
cc                  if(min_idt.lt.0) min_idt = 0
c                  max_idt = idt_max(kk) + idt_samflt
cc                  if(max_idt.gt.24*60*60) max_idt = 24*60*60
cc
c                  if(c_acftid(ii)  .eq.c_acr_id(kk).and.
c     $               c_acftreg(ii) .eq.c_acr_reg(kk).and.
c     $               c_acftid(iim1).eq.c_air_id(kk).and.
c     $               idt(ii).ge.min_idt.and.
c     $               idt(ii).le.max_idt) then
cc
c                    kdup(kk) = kdup(kk) + 1
c                    if(idt(ii).lt.idt_min(kk)) 
c     $                idt_min(kk) = idt(ii)
c                    if(idt(ii).gt.idt_max(kk)) 
c     $                idt_max(kk) = idt(ii)
cc
c                    goto 201
c                  endif
cc
c                  kk = kk + 1
c                enddo
c              endif
cc
c              ndup = ndup + 1
c              c_acr_id(ndup) = c_acftid(ii)
c              c_acr_reg(ndup) = c_acftreg(ii)
c              c_air_id(ndup) = c_acftid(iim1)
c              idt_min(ndup) = idt(ii)
c              idt_max(ndup) = idt(ii)
c              kdup(ndup) = 1
cc
c 201          continue
c            endif
c
c         Set c_qc to '.' if iim1 = 0
c         ---------------------------
          else
            if(c_qc(ii)(1:1).eq.'-') c_qc(ii)(1:1) = '.'
          endif
c
c       End loop over reports within 60 seconds
c       ---------------------------------------
        enddo
c
c     End loop over reports
c     ---------------------
      enddo
cc
cc Check mixed duplicates for double mapping
cc -----------------------------------------------
c      do kk=1,ndup-1
c        do kk1=kk+1,ndup
c          if(c_air_id(kk).eq.c_air_id(kk1).and.
c     $       c_acr_id(kk).ne.c_acr_id(kk1)) then
c            if((kdup(kk).le.3.and.kdup(kk1).gt.5).or.
c     $         ((kdup(kk1)-kdup(kk))*100/kdup(kk1).ge.70)) then
c              c_air_id(kk) = '         '
c              c_acr_id(kk) = '         '
c              kdup(kk) = 0
c            elseif((kdup(kk).gt.5.and.kdup(kk1).le.3).or.
c     $             ((kdup(kk)-kdup(kk1))*100/kdup(kk).ge.70)) then
c              c_air_id(kk1) = '         '
c              c_acr_id(kk1) = '         '
c              kdup(kk1) = 0
c            else
c              write(io8,*)
c              write(io8,*) 'Multiple ids for mixed duplicates found'
c              write(io8,*) 'Cannot choose which id to use'
c              write(io8,*) kk,'  ',c_air_id(kk),c_acr_id(kk),
c     $                     kdup(kk),idt_min(kk),idt_max(kk)
c              write(io8,*) kk1,'  ',c_air_id(kk1),c_acr_id(kk1),
c     $                     kdup(kk1),idt_min(kk1),idt_max(kk1)
c              c_air_id(kk) = '         '
c              c_acr_id(kk) = '         '
c              kdup(kk) = 0
c              c_air_id(kk1) = '         '
c              c_acr_id(kk1) = '         '
c              kdup(kk1) = 0
c            endif
c          endif
c        enddo
c      enddo
cc
cc Output mixed duplicate mapping
cc ------------------------------
c      write(io8,*)
ccccdak      write(io8,*) '         kk  airep id acars id  #  idt_min idt_max'
c      write(io8,*) '         kk  airep id tamdar id  #  idt_min idt_max'
c      write(io8,*) '         --  -------- --------- --- ------- -------'
c      do kk=1,ndup
c        write(io8,*) kk,'  ',c_air_id(kk),c_acr_id(kk),kdup(kk),
c     $               idt_min(kk),idt_max(kk)
c      enddo
cc
cc Map new flight ids and tail numbers on airep data
cc Check all flights--allow AMDAR-AIREP mixed dups
ccccccdak Almost all of the AIREP-ACARS/MDCRS dups are UAL
cc Almost all of the AIREP-TAMDAR/MDCRS dups are UAL
cc -------------------------------------------------
c      kmap = 0
c      l_ual_all = .false.
cc
c      do iob=1,numreps
c        ii = indx(iob)
c        if(itype(ii).ne.i_acars     .and.
c     $     itype(ii).ne.i_acars_asc .and.
c     $     itype(ii).ne.i_acars_lvl .and.
c     $     itype(ii).ne.i_acars_des .and.
c     $     itype(ii).ne.i_mdcrs    .and.
c     $     itype(ii).ne.i_mdcrs_asc.and.
c     $     itype(ii).ne.i_mdcrs_lvl.and.
c     $     itype(ii).ne.i_mdcrs_des.and.
c     $     itype(ii).ne.i_amdar    .and.
c     $     itype(ii).ne.i_amdar_asc.and.
c     $     itype(ii).ne.i_amdar_lvl.and.
c     $     itype(ii).ne.i_amdar_des.and.
c     $     c_qc(ii)(1:1).ne.'D'.and.
c     $     c_qc(ii)(1:1).ne.'d'.and.
c     $     c_qc(ii)(1:1).ne.'e'.and.
c     $     c_qc(ii)(1:1).ne.'E'.and.
c     $     (.not.l_ual_all.or.
c     $      (l_ual_all.and.c_acftid(ii)(1:2).eq.'UA'))) then
cc
c          do kk=1,ndup
c            min_idt = idt_min(kk) - idt_samflt
c            max_idt = idt_max(kk) + idt_samflt
cc
c            if((c_acftid(ii)(1:8).eq.
c     $          c_air_id(kk)(1:2)//c_air_id(kk)(4:9)).or.
c     $          (c_acftid(ii)(1:9).eq.c_air_id(kk)(1:9)).and.
c     $         idt(ii).ge.min_idt.and.
c     $         idt(ii).le.max_idt) then
cc
cc              write(io8,*)
cc              write(io8,*) 'Flight id re-mapped: before and after'
cc              write(io8,8002) kkdup,ii,c_insty_ob(itype(ii))
cc     x,           c_acftreg(ii),c_acftid(ii)
cc     x,           idt(ii),alat(ii),alon(ii)
cc     x,           pres(ii),ht_ft(ii)
cc     x,           t_prcn(ii),ob_t(ii),xiv_t(ii),ichk_t(ii)
cc     x,           ob_q(ii),xiv_q(ii),ichk_q(ii)
cc     x,           ob_dir(ii),xiv_d(ii),ichk_d(ii)
cc     x,           ob_spd(ii),xiv_s(ii),ichk_s(ii)
cc     x,           c_qc(ii)
cc
c              c_acftid(ii) = c_acr_id(kk)
c              c_acftreg(ii) = c_acr_reg(kk)
c              kmap = kmap + 1
cc
cc              write(io8,8002) kkdup,ii,c_insty_ob(itype(ii))
cc     x,           c_acftreg(ii),c_acftid(ii)
cc     x,           idt(ii),alat(ii),alon(ii)
cc     x,           pres(ii),ht_ft(ii)
cc     x,           t_prcn(ii),ob_t(ii),xiv_t(ii),ichk_t(ii)
cc     x,           ob_q(ii),xiv_q(ii),ichk_q(ii)
cc     x,           ob_dir(ii),xiv_d(ii),ichk_d(ii)
cc     x,           ob_spd(ii),xiv_s(ii),ichk_s(ii)
cc     x,           c_qc(ii)
c            endif
c          enddo
c        endif
c      enddo
c
c     If no tail number is found, copy airlines ident into tail number 
c     to accumulate stats by airline
c     -----------------------------------------------------------------
c DAK: Could this be written more efficiently?
      do iob=1,numreps
        ii = indx(iob)
C DAK: Here is the logic that originally did not work for TAMDAR reports whose tail number is
c      missing, but flight number was all numbers (e.g., "00009934") meaning a tail number
c      could not be created from the flight number -- this was bypassed by changing "000" in
c      the 1st 3 characters of the flight number to "TAM" in subroutine input_acqc where the
c      reports are read in from NCEP PREPBUFR file and stored in memory
        if(c_acftreg(ii).eq.'        ') then
          if(c_acftid(ii)(1:5).eq.'XX999') then
            c_acftreg(ii)(1:5) = 'XX999'
          else
            if(c_acftid(ii)(1:1).ge.'A'.and.
     $         c_acftid(ii)(1:1).le.'Z')
     $        c_acftreg(ii)(1:1) = c_acftid(ii)(1:1)
c
            if(c_acftid(ii)(2:2).ge.'A'.and.
     $         c_acftid(ii)(2:2).le.'Z'.and.
     $         c_acftreg(ii)(1:1).ne.' ')
     $        c_acftreg(ii)(2:2) = c_acftid(ii)(2:2)
c
            if(c_acftid(ii)(3:3).ge.'A'.and.
     $         c_acftid(ii)(3:3).le.'Z'.and.
     $         c_acftreg(ii)(2:2).ne.' ')
     $        c_acftreg(ii)(3:3) = c_acftid(ii)(3:3)
c
            if(c_acftid(ii)(4:4).ge.'A'.and.
     $         c_acftid(ii)(4:4).le.'Z'.and.
     $         c_acftreg(ii)(3:3).ne.' ')
     $        c_acftreg(ii)(4:4) = c_acftid(ii)(4:4)
c
            if(c_acftid(ii)(5:5).ge.'A'.and.
     $         c_acftid(ii)(5:5).le.'Z'.and.
     $         c_acftreg(ii)(4:4).ne.' ')
     $        c_acftreg(ii)(5:5) = c_acftid(ii)(5:5)
          endif
        endif
      enddo
c
c      write(io8,*)
c      write(io8,*) 'Number of flight ids re-mapped = ',kmap
c
c Sum number of reports per tail numbers
c --------------------------------------
      write(*,*) 'Counting number of reports per tail number'
      write(io8,*)
      write(io8,*) 'Counting number of reports per tail number'
      write(io8,*) '------------------------------------------'
      l_print = .false.
      call do_reg(l_print,io8,
     $           max_reps,numreps,itype,c_qc,c_acftreg,indx,
     $           maxflt,kreg,creg_reg,nobs_reg,*99)
c
c Output statistics and rejects
c -----------------------------
      kbad = 0
c
c     Write header to output file
c     ---------------------------
      if(.not.l_operational) then
        write(io30,*)
        write(io30,*) 'Encode dups (E or e)'
        write(io30,*) '--------------------'
        write(io30,3001)
 3001   format(' index  type    tail num   flight     time       lat'
     x,        '        lon       pres  height '
     x,        't-prcn   temp     innov  ichk'
     x,        ' spec hum    innov  ichk'
     x,        '   ob_dir    innov  ichk'
     x,        '   ob_spd    innov  ichk'
     x,        '   qc flag')
      endif
c
c     Loop over reports
c     -----------------
      do iob = 1,numreps
        ii = indx(iob)
c
c       Count number of reports considered
c       ----------------------------------
        if(itype(ii).eq.i_mdcrs.or.
     $     itype(ii).eq.i_mdcrs_asc.or.
     $     itype(ii).eq.i_mdcrs_lvl.or.
     $     itype(ii).eq.i_mdcrs_des) then
          nrep_Md = nrep_Md + 1
          ktype = 1
c
        elseif(itype(ii).eq.i_acars.or.
     $         itype(ii).eq.i_acars_asc.or.
     $         itype(ii).eq.i_acars_lvl.or.
     $         itype(ii).eq.i_acars_des) then
          nrep_Ac = nrep_Ac + 1
          ktype = 2
c
        elseif(itype(ii).eq.i_amdar.or.
     $         itype(ii).eq.i_amdar_asc.or.
     $         itype(ii).eq.i_amdar_lvl.or.
     $         itype(ii).eq.i_amdar_des) then
          nrep_Am = nrep_Am + 1
          ktype = 3
c
        elseif(itype(ii).eq.i_airep.or.
     $         itype(ii).eq.i_airep_asc.or.
     $         itype(ii).eq.i_airep_lvl.or.
     $         itype(ii).eq.i_airep_des) then
          nrep_Ar = nrep_Ar + 1
          ktype = 4
c
        elseif(itype(ii).eq.i_man_airep.or.
     $         itype(ii).eq.i_man_Yairep) then
          nrep_Ma = nrep_Ma + 1
          ktype = 5
c
        else
          write(io8,*)
          write(io8,*) 'Bad itype: ',itype(ii),' for ii = ',ii
          ktype = 0
        endif
c
c       Count number of reports rejected with encode errors
c       ---------------------------------------------------
        if(c_qc(ii)(1:1).eq.'e'.or.
     $     c_qc(ii)(1:1).eq.'E') then
c
          if(ktype.ne.0) kbad(ktype,1) = kbad(ktype,1) + 1
c
c         Count number of rejected reports by tail number
c         -----------------------------------------------
          mm = 1
          do while(mm.le.kreg)
            if(c_acftreg(ii).eq.creg_reg(mm)) then 
c
              if(ktype.gt.0.and.ktype.le.5)
     $          nrej_reg(mm,ktype) = nrej_reg(mm,ktype) + 1
              mm = kreg + 1
            endif
            mm = mm + 1
          enddo
c
c         Flag bad report for reorder subroutine and output rejects
c         ---------------------------------------------------------
          csort(ii)(1:5) = 'badob'
c
          if(.not.l_operational) then
            write(io30,3002) ii,c_insty_ob(itype(ii))
     x,        c_acftreg(ii),c_acftid(ii)
     x,        idt(ii),alat(ii),alon(ii)
     x,        pres(ii),ht_ft(ii)
     x,        t_prcn(ii),ob_t(ii),xiv_t(ii),ichk_t(ii)
     x,        ob_q(ii),xiv_q(ii),ichk_q(ii)
     x,        ob_dir(ii),xiv_d(ii),ichk_d(ii)
     x,        ob_spd(ii),xiv_s(ii),ichk_s(ii)
     x,        c_qc(ii)
 3002       format(i6,1x,a8,1x,a8,1x,a9,1x,i7,1x,2f11.5,1x,f8.1,1x,f7.0
     x,          1x,f5.2,4(2(1x,f8.2),1x,i5),1x,'!',a11,'!')
          endif
c
c       Count number of bad temperatures and bad winds
c       ----------------------------------------------
        elseif(c_qc(ii)(6:6).eq.'E'.or.
     $         c_qc(ii)(7:7).eq.'E'.or.
     $         c_qc(ii)(8:8).eq.'E') then
c
c         Count number of rejected temps/winds by tail number
c         ---------------------------------------------------
          mm = 1
          do while(mm.le.kreg)
            if(c_acftreg(ii).eq.creg_reg(mm)) then 
c
              if(ktype.gt.0.and.ktype.le.5) then
                if(c_qc(ii)(6:6).eq.'E')
     $            ntemp_reg(mm,ktype) = ntemp_reg(mm,ktype) + 1
                if(c_qc(ii)(7:7).eq.'E'.or.
     $             c_qc(ii)(8:8).eq.'E')
     $            nwind_reg(mm,ktype) = nwind_reg(mm,ktype) + 1
              endif
              mm = kreg + 1
            endif
            mm = mm + 1
          enddo
        endif
      enddo
c
c     Output statistics
c     -----------------
      if(.not.l_operational) then
        write(io30,*)
        write(io30,*)'  Number of MDCRS    encode dups rejected = '
     $,                   kbad(1,1)
ccccdak        write(io30,*)'  Number of ACARS    encode dups rejected = '
        write(io30,*)'  Number of TAMDAR   encode dups rejected = '
     $,                   kbad(2,1)
        write(io30,*)'  Number of AMDAR    encode dups rejected = '
     $,                   kbad(3,1)
        write(io30,*)'  Number of AIREP    encode dups rejected = '
     $,                   kbad(4,1)
        write(io30,*)'  Number of manAIREP encode dups rejected = '
     $,                   kbad(5,1)
      endif
c
c     Output tail number counts
c     -------------------------
      write(io8,*) 
      write(io8,*) '  Tail numbers for rejected encode dups'
ccccdak      write(io8,*) '  Tail Num  MDCRS  ACARS  AMDAR  AIREP  MAN  '
      write(io8,*) '  Tail Num  MDCRS  TAMDAR AMDAR  AIREP  MAN  '
      write(io8,*) '  -------------------------------------------'
c
      do mm=1,kreg
        if( nrej_reg(mm,1)+nrej_reg(mm,2)+nrej_reg(mm,3)
     $     +nrej_reg(mm,4)+nrej_reg(mm,5).gt.0) then
          write(io8,'(2x,a8,5(1x,i6))') 
     $      creg_reg(mm),(nrej_reg(mm,kk),kk=1,5)
        endif
      enddo
c
      write(io8,*) 
      write(io8,*) '  Tail numbers for reports with bad temperature'
ccccdak      write(io8,*) '  Tail Num  MDCRS  ACARS  AMDAR  AIREP  MAN  '
      write(io8,*) '  Tail Num  MDCRS  TAMDAR AMDAR  AIREP  MAN  '
      write(io8,*) '  -------------------------------------------'
c
      do mm=1,kreg
        if( ntemp_reg(mm,1)+ntemp_reg(mm,2)+ntemp_reg(mm,3)
     $     +ntemp_reg(mm,4)+ntemp_reg(mm,5).gt.0) then
          write(io8,'(2x,a8,5(1x,i6))') 
     $      creg_reg(mm),(ntemp_reg(mm,kk),kk=1,5)
        endif
      enddo
c
      write(io8,*) 
      write(io8,*) '  Tail numbers for reports with bad winds'
ccccdak      write(io8,*) '  Tail Num  MDCRS  ACARS  AMDAR  AIREP  MAN  '
      write(io8,*) '  Tail Num  MDCRS  TAMDAR AMDAR  AIREP  MAN  '
      write(io8,*) '  -------------------------------------------'
c
      do mm=1,kreg
        if( nwind_reg(mm,1)+nwind_reg(mm,2)+nwind_reg(mm,3)
     $     +nwind_reg(mm,4)+nwind_reg(mm,5).gt.0) then
          write(io8,'(2x,a8,5(1x,i6))') 
     $      creg_reg(mm),(nwind_reg(mm,kk),kk=1,5)
        endif
      enddo
c
c     Write header to output file
c     ---------------------------
      if(l_save_dups.and.(.not.l_operational)) then
        write(io30,*)
        write(io30,*) 'True dups(D) and close dups (d)'
        write(io30,*) '-------------------------------'
        write(io30,3001)
      endif
c
c     Loop over reports
c     -----------------
      do iob = 1,numreps
        ii   = indx(iob)
c
c       Count number of exact duplicates
c       --------------------------------
        if(c_qc(ii)(1:1).eq.'D'.and.
     $     csort(ii)(1:5).ne.'badob') then
c
          if(itype(ii).eq.i_mdcrs.or.
     $       itype(ii).eq.i_mdcrs_asc.or.
     $       itype(ii).eq.i_mdcrs_lvl.or.
     $       itype(ii).eq.i_mdcrs_des) then
            kbad(1,2) = kbad(1,2) + 1
            ndup_Md = ndup_Md + 1
c
          elseif(itype(ii).eq.i_acars.or.
     $           itype(ii).eq.i_acars_asc.or.
     $           itype(ii).eq.i_acars_lvl.or.
     $           itype(ii).eq.i_acars_des) then
            kbad(2,2) = kbad(2,2) + 1
            ndup_Ac = ndup_Ac + 1
c
          elseif(itype(ii).eq.i_amdar.or.
     $           itype(ii).eq.i_amdar_asc.or.
     $           itype(ii).eq.i_amdar_lvl.or.
     $           itype(ii).eq.i_amdar_des) then
            kbad(3,2) = kbad(3,2) + 1
            ndup_Am = ndup_Am + 1
c
          elseif(itype(ii).eq.i_airep.or.
     $           itype(ii).eq.i_airep_asc.or.
     $           itype(ii).eq.i_airep_lvl.or.
     $           itype(ii).eq.i_airep_des) then
            kbad(4,2) = kbad(4,2) + 1
            ndup_Ar = ndup_Ar + 1
c
          elseif(itype(ii).eq.i_man_airep.or.
     $           itype(ii).eq.i_man_Yairep) then
            kbad(5,2) = kbad(5,2) + 1
            ndup_Ma = ndup_Ma + 1
c
          else
            write(io8,*)
            write(io8,*) 'Bad itype: ',itype(ii),' for ii = ',ii
          endif
        endif
c
c       Count number of near and encode duplicates
c       ------------------------------------------
        if(c_qc(ii)(1:1).eq.'d'.and.
     $     csort(ii)(1:5).ne.'badob') then
c
          if(itype(ii).eq.i_mdcrs.or.
     $       itype(ii).eq.i_mdcrs_asc.or.
     $       itype(ii).eq.i_mdcrs_lvl.or.
     $       itype(ii).eq.i_mdcrs_des) then
            kbad(1,3) = kbad(1,3) + 1
            ndup_Md = ndup_Md + 1
c
          elseif(itype(ii).eq.i_acars.or.
     $           itype(ii).eq.i_acars_asc.or.
     $           itype(ii).eq.i_acars_lvl.or.
     $           itype(ii).eq.i_acars_des) then
            kbad(2,3) = kbad(2,3) + 1
            ndup_Ac = ndup_Ac + 1
c
          elseif(itype(ii).eq.i_amdar.or.
     $           itype(ii).eq.i_amdar_asc.or.
     $           itype(ii).eq.i_amdar_lvl.or.
     $           itype(ii).eq.i_amdar_des) then
            kbad(3,3) = kbad(3,3) + 1
            ndup_Am = ndup_Am + 1
c
          elseif(itype(ii).eq.i_airep.or.
     $           itype(ii).eq.i_airep_asc.or.
     $           itype(ii).eq.i_airep_lvl.or.
     $           itype(ii).eq.i_airep_des) then
            kbad(4,3) = kbad(4,3) + 1
            ndup_Ar = ndup_Ar + 1
c
          elseif(itype(ii).eq.i_man_airep.or.
     $           itype(ii).eq.i_man_Yairep) then
            kbad(5,3) = kbad(5,3) + 1
            ndup_Ma = ndup_Ma + 1
c
          else
            write(io8,*)
            write(io8,*) 'Bad itype: ',itype(ii),' for ii = ',ii
          endif
        endif
c
c       Set flag for "reorder" and output dups if desired
c       -------------------------------------------------
        if(c_qc(ii)(1:1).eq.'D'.or.
     $     c_qc(ii)(1:1).eq.'d') then
c
          csort(ii)(1:5) = 'badob'
c
          if(l_save_dups.and.(.not.l_operational)) then
            write(io30,3002) ii,c_insty_ob(itype(ii))
     x,        c_acftreg(ii),c_acftid(ii)
     x,        idt(ii),alat(ii),alon(ii)
     x,        pres(ii),ht_ft(ii)
     x,        t_prcn(ii),ob_t(ii),xiv_t(ii),ichk_t(ii)
     x,        ob_q(ii),xiv_q(ii),ichk_q(ii)
     x,        ob_dir(ii),xiv_d(ii),ichk_d(ii)
     x,        ob_spd(ii),xiv_s(ii),ichk_s(ii)
     x,        c_qc(ii)
          endif
c
        endif
      enddo
c
c     Output statistics
c     -----------------
      if(.not.l_operational) then
        write(io30,*)'  Number of MDCRS    exact dups rejected = '
     $,                 kbad(1,2)
ccccdak        write(io30,*)'  Number of ACARS    exact dups rejected = '
        write(io30,*)'  Number of TAMDAR   exact dups rejected = '
     $,                 kbad(2,2)
        write(io30,*)'  Number of AMDAR    exact dups rejected = '
     $,                 kbad(3,2)
        write(io30,*)'  Number of AIREP    exact dups rejected = '
     $,                 kbad(4,2)
        write(io30,*)'  Number of manAIREP exact dups rejected = '
     $,                 kbad(5,2)
        write(io30,*)'  Number of MDCRS    near dups rejected  = '
     $,                 kbad(1,3)
ccccdak        write(io30,*)'  Number of ACARS    near dups rejected  = '
        write(io30,*)'  Number of TAMDAR   near dups rejected  = '
     $,                 kbad(2,3)
        write(io30,*)'  Number of AMDAR    near dups rejected  = '
     $,                 kbad(3,3)
        write(io30,*)'  Number of AIREP    near dups rejected  = '
     $,                 kbad(4,3)
        write(io30,*)'  Number of manAIREP near dups rejected  = '
     $,                 kbad(5,3)
      endif
c
      kbadtot = kbad(1,1) + kbad(2,1) + kbad(3,1) + kbad(4,1) 
     $        + kbad(5,1) + kbad(1,2) + kbad(2,2) + kbad(3,2)
     $        + kbad(4,2) + kbad(5,2) + kbad(1,3) + kbad(2,3)
     $        + kbad(3,3) + kbad(4,3) + kbad(5,3)
c
      write(io8,*)
      write(io8,*) numreps,' good reports processed'
      write(io8,*) kbadtot,' reports failed qc in duplicate check'
c
c     Output detailed stats
c     ---------------------
      if(l_last) then
        write(io8,*)
        write(io8,*) 'Distribution of MDCRS reports'
        do ii=19,1,-1
          write(io8,'(37i7)') (n_area_Md(ii,kk),kk=1,37)
        enddo
c
        write(io8,*)
ccccdak        write(io8,*) 'Distribution of ACARS reports'
        write(io8,*) 'Distribution of TAMDAR reports'
        do ii=19,1,-1
          write(io8,'(37i7)') (n_area_Ac(ii,kk),kk=1,37)
        enddo
c
        write(io8,*)
        write(io8,*) 'Distribution of AMDAR reports'
        do ii=19,1,-1
          write(io8,'(37i7)') (n_area_Am(ii,kk),kk=1,37)
        enddo
c
        write(io8,*)
        write(io8,*) 'Distribution of AIREP reports'
        do ii=19,1,-1
          write(io8,'(37i7)') (n_area_Ar(ii,kk),kk=1,37)
        enddo
c
        write(io8,*)
        write(io8,*) 'Distribution of manAIREP reports'
        do ii=19,1,-1
          write(io8,'(37i7)') (n_area_Ma(ii,kk),kk=1,37)
        enddo
c
        write(io8,*)
        write(io8,*) 'Temporal distribution of MDCRS reports'
        do ii=1,24
          write(io8,*) ii,n_time_Md(ii)
        enddo
c
        write(io8,*)
ccccdak        write(io8,*) 'Temporal distribution of ACARS reports'
        write(io8,*) 'Temporal distribution of TAMDAR reports'
        do ii=1,24
          write(io8,*) ii,n_time_Ac(ii)
        enddo
c
        write(io8,*)
        write(io8,*) 'Temporal distribution of AMDAR reports'
        do ii=1,24
          write(io8,*) ii,n_time_Am(ii)
        enddo
c
        write(io8,*)
        write(io8,*) 'Temporal distribution of AIREP reports'
        do ii=1,24
          write(io8,*) ii,n_time_Ar(ii)
        enddo
c
        write(io8,*)
        write(io8,*) 'Temporal distribution of manAIREP reports'
        do ii=1,24
          write(io8,*) ii,n_time_Ma(ii)
        enddo
c
        write(io8,*)
        write(io8,*) 'Vertical distribution of MDCRS reports'
        write(io8,*) '<0 ',n_lev_Md(53)
        do ii=0,50
          write(io8,*) ii,n_lev_Md(ii+1)
        enddo
        write(io8,*) '>50',n_lev_Md(52)
c
        write(io8,*)
ccccdak        write(io8,*) 'Vertical distribution of ACARS reports'
        write(io8,*) 'Vertical distribution of TAMDAR reports'
        write(io8,*) '<0 ',n_lev_Ac(53)
        do ii=0,50
          write(io8,*) ii,n_lev_Ac(ii+1)
        enddo
        write(io8,*) '>50',n_lev_Ac(52)
c
        write(io8,*)
        write(io8,*) 'Vertical distribution of AMDAR reports'
        write(io8,*) '<0 ',n_lev_Am(53)
        do ii=0,50
          write(io8,*) ii,n_lev_Am(ii+1)
        enddo
        write(io8,*) '>50',n_lev_Am(52)
c
        write(io8,*)
        write(io8,*) 'Vertical distribution of AIREP reports'
        write(io8,*) '<0 ',n_lev_Ar(53)
        do ii=0,50
          write(io8,*) ii,n_lev_Ar(ii+1)
        enddo
        write(io8,*) '>50',n_lev_Ar(52)
c
        write(io8,*)
        write(io8,*) 'Vertical distribution of manAIREP reports'
        write(io8,*) '<0 ',n_lev_Ma(53)
        do ii=0,50
          write(io8,*) ii,n_lev_Ma(ii+1)
        enddo
        write(io8,*) '>50',n_lev_Ma(52)
c
        write(io8,*)
        write(io8,*) 'Vertical distribution of MDCRS temp reports'
        write(io8,*) '-------------------------------------------'
        write(io8,'(''                           Altitude (kft)'')')
        write(io8,'(1x,a45,a41)')
     $  'Temp (C)   <0   0-5   5-10 10-15 15-20 20-25 ',
     $              '25-30 30-35 35-40 40-45 45-50  50    >50 '
        write(io8,'(1x,a45,a41)')
     $      '-------- ----- ----- ----- ----- ----- ----- ',
     $      '----- ----- ----- ----- ----- ----- -----'  
        write(io8,'('' missing '',13i7)') n_temp_Md(36,13),
     $                                   (n_temp_Md(36,ii),ii=1,12)
        write(io8,'(1x,a45,a41)')
     $      '-------- ----- ----- ----- ----- ----- ----- ',
     $      '----- ----- ----- ----- ----- ----- -----'
        write(io8,'('' < -100  '',13i7)') n_temp_Md(35,13),
     $                                   (n_temp_Md(35,ii),ii=1,12)
        do kk=1,33
          ktemp = (5 * (kk-1) + 173) - 273
          write(io8,'(i9,13i7)') ktemp,n_temp_Md(kk,13),
     $                                (n_temp_Md(kk,ii),ii=1,12)
        enddo
        write(io8,'('' > 60    '',13i7)') n_temp_Md(34,13),
     $                                   (n_temp_Md(34,ii),ii=1,12)
c
        write(io8,*)
ccccdak        write(io8,*) 'Vertical distribution of ACARS temp reports'
        write(io8,*) 'Vertical distribution of TAMDAR temp reports'
        write(io8,*) '--------------------------------------------'
        write(io8,'(''                           Altitude (kft)'')')
        write(io8,'(1x,a45,a41)')
     $  'Temp (C)   <0   0-5   5-10 10-15 15-20 20-25 ',
     $              '25-30 30-35 35-40 40-45 45-50  50    >50 '
        write(io8,'(1x,a45,a41)')
     $      '-------- ----- ----- ----- ----- ----- ----- ',
     $      '----- ----- ----- ----- ----- ----- -----'
        write(io8,'('' missing '',13i7)') n_temp_Ac(36,13),
     $                                   (n_temp_Ac(36,ii),ii=1,12)
        write(io8,'(1x,a45,a41)')
     $      '-------- ----- ----- ----- ----- ----- ----- ',
     $      '----- ----- ----- ----- ----- ----- -----'
        write(io8,'('' < -100  '',13i7)') n_temp_Ac(35,13),
     $                                   (n_temp_Ac(35,ii),ii=1,12)
        do kk=1,33
          ktemp = (5 * (kk-1) + 173) - 273
          write(io8,'(i9,13i7)') ktemp,n_temp_Ac(kk,13),
     $                                (n_temp_Ac(kk,ii),ii=1,12)
        enddo
        write(io8,'('' > 60    '',13i7)') n_temp_Ac(34,13),
     $                                   (n_temp_Ac(34,ii),ii=1,12)
c
        write(io8,*)
        write(io8,*) 'Vertical distribution of AMDAR temp reports'
        write(io8,*) '-------------------------------------------'
        write(io8,'(''                           Altitude (kft)'')')
        write(io8,'(1x,a45,a41)')
     $  'Temp (C)   <0   0-5   5-10 10-15 15-20 20-25 ',
     $              '25-30 30-35 35-40 40-45 45-50  50    >50 '
        write(io8,'(1x,a45,a41)')
     $      '-------- ----- ----- ----- ----- ----- ----- ',
     $      '----- ----- ----- ----- ----- ----- -----'  
        write(io8,'('' missing '',13i7)') n_temp_Am(36,13),
     $                                   (n_temp_Am(36,ii),ii=1,12)
        write(io8,'(1x,a45,a41)')
     $      '-------- ----- ----- ----- ----- ----- ----- ',
     $      '----- ----- ----- ----- ----- ----- -----'
        write(io8,'('' < -100  '',13i7)') n_temp_Am(35,13),
     $                                   (n_temp_Am(35,ii),ii=1,12)
        do kk=1,33
          ktemp = (5 * (kk-1) + 173) - 273
          write(io8,'(i9,13i7)') ktemp,n_temp_Am(kk,13),
     $                                (n_temp_Am(kk,ii),ii=1,12)
        enddo
        write(io8,'('' > 60    '',13i7)') n_temp_Am(34,13),
     $                                   (n_temp_Am(34,ii),ii=1,12)
c
        write(io8,*)
        write(io8,*) 'Vertical distribution of AIREP temp reports'
        write(io8,*) '-------------------------------------------'
        write(io8,'(''                           Altitude (kft)'')')
        write(io8,'(1x,a45,a41)')
     $  'Temp (C)   <0   0-5   5-10 10-15 15-20 20-25 ',
     $              '25-30 30-35 35-40 40-45 45-50  50    >50 '
        write(io8,'(1x,a45,a41)')
     $      '-------- ----- ----- ----- ----- ----- ----- ',
     $      '----- ----- ----- ----- ----- ----- -----'  
        write(io8,'('' missing '',13i7)') n_temp_Ar(36,13),
     $                                   (n_temp_Ar(36,ii),ii=1,12)
        write(io8,'(1x,a45,a41)')
     $      '-------- ----- ----- ----- ----- ----- ----- ',
     $      '----- ----- ----- ----- ----- ----- -----'
        write(io8,'('' < -100  '',13i7)') n_temp_Ar(35,13),
     $                                   (n_temp_Ar(35,ii),ii=1,12)
        do kk=1,33
          ktemp = (5 * (kk-1) + 173) - 273
          write(io8,'(i9,13i7)') ktemp,n_temp_Ar(kk,13),
     $                                (n_temp_Ar(kk,ii),ii=1,12)
        enddo
        write(io8,'('' > 60    '',13i7)') n_temp_Ar(34,13),
     $                                   (n_temp_Ar(34,ii),ii=1,12)
c
        write(io8,*)
        write(io8,*) 'Vertical distribution of manAIREP temp reports'
        write(io8,*) '-------------------------------------------'
        write(io8,'(''                           Altitude (kft)'')')
        write(io8,'(1x,a45,a41)')
     $  'Temp (C)   <0   0-5   5-10 10-15 15-20 20-25 ',
     $              '25-30 30-35 35-40 40-45 45-50  50    >50 '
        write(io8,'(1x,a45,a41)')
     $      '-------- ----- ----- ----- ----- ----- ----- ',
     $      '----- ----- ----- ----- ----- ----- -----'  
        write(io8,'('' missing '',13i7)') n_temp_Ma(36,13),
     $                                   (n_temp_Ma(36,ii),ii=1,12)
        write(io8,'(1x,a45,a41)')
     $      '-------- ----- ----- ----- ----- ----- ----- ',
     $      '----- ----- ----- ----- ----- ----- -----'
        write(io8,'('' < -100  '',13i7)') n_temp_Ma(35,13),
     $                                   (n_temp_Ma(35,ii),ii=1,12)
        do kk=1,33
          ktemp = (5 * (kk-1) + 173) - 273
          write(io8,'(i9,13i7)') ktemp,n_temp_Ma(kk,13),
     $                                (n_temp_Ma(kk,ii),ii=1,12)
        enddo
        write(io8,'('' > 60    '',13i7)') n_temp_Ma(34,13),
     $                                   (n_temp_Ma(34,ii),ii=1,12)
c
        write(io8,*)
        write(io8,*) 'Vertical distribution of MDCRS wspd reports'
        write(io8,*) '-------------------------------------------'
        write(io8,'(''                           Altitude (kft)'')')
        write(io8,'(1x,a45,a41)')
     $         'Spd(m/s)   <0   0-5   5-10 10-15 15-20 20-25 ',
     $         '25-30 30-35 35-40 40-45 45-50  50    >50 '
        write(io8,'(1x,a45,a41)')
     $      '-------- ----- ----- ----- ----- ----- ----- ',
     $      '----- ----- ----- ----- ----- ----- -----'  
        write(io8,'('' missing '',13i7)') n_wspd_Md(40,13),
     $                                   (n_wspd_Md(40,ii),ii=1,12)
        write(io8,'(1x,a45,a41)')
     $      '-------- ----- ----- ----- ----- ----- ----- ',
     $      '----- ----- ----- ----- ----- ----- -----'
        write(io8,'(''  < 0    '',13i7)') n_wspd_Md(39,13),
     $                                   (n_wspd_Md(39,ii),ii=1,12)
        do kk=1,37
          kwspd = 5 * (kk-1)
          write(io8,'(i9,13i7)') kwspd,n_wspd_Md(kk,13),
     $                                (n_wspd_Md(kk,ii),ii=1,12)
        enddo
        write(io8,'('' > 180   '',13i7)') n_wspd_Md(38,13),
     $                                   (n_wspd_Md(38,ii),ii=1,12)
c
        write(io8,*)
ccccdak        write(io8,*) 'Vertical distribution of ACARS wspd reports'
        write(io8,*) 'Vertical distribution of TAMDAR wspd reports'
        write(io8,*) '-------------------------------------------'
        write(io8,'(''                           Altitude (kft)'')')
        write(io8,'(1x,a45,a41)')
     $         'Spd(m/s)   <0   0-5   5-10 10-15 15-20 20-25 ',
     $         '25-30 30-35 35-40 40-45 45-50  50    >50 '
        write(io8,'(1x,a45,a41)')
     $      '-------- ----- ----- ----- ----- ----- ----- ',
     $      '----- ----- ----- ----- ----- ----- -----'  
        write(io8,'('' missing '',13i7)') n_wspd_Ac(40,13),
     $                                   (n_wspd_Ac(40,ii),ii=1,12)
        write(io8,'(1x,a45,a41)')
     $      '-------- ----- ----- ----- ----- ----- ----- ',
     $      '----- ----- ----- ----- ----- ----- -----'
        write(io8,'(''  < 0    '',13i7)') n_wspd_Ac(39,13),
     $                                   (n_wspd_Ac(39,ii),ii=1,12)
        do kk=1,37
          kwspd = 5 * (kk-1)
          write(io8,'(i9,13i7)') kwspd,n_wspd_Ac(kk,13),
     $                                (n_wspd_Ac(kk,ii),ii=1,12)
        enddo
        write(io8,'('' > 180   '',13i7)') n_wspd_Ac(38,13),
     $                                   (n_wspd_Ac(38,ii),ii=1,12)
c
        write(io8,*)
        write(io8,*) 'Vertical distribution of AMDAR wspd reports'
        write(io8,*) '-------------------------------------------'
        write(io8,'(''                           Altitude (kft)'')')
        write(io8,'(1x,a45,a41)')
     $         'Spd(m/s)   <0   0-5   5-10 10-15 15-20 20-25 ',
     $         '25-30 30-35 35-40 40-45 45-50  50    >50 '
        write(io8,'(1x,a45,a41)')
     $      '-------- ----- ----- ----- ----- ----- ----- ',
     $      '----- ----- ----- ----- ----- ----- -----'  
        write(io8,'('' missing '',13i7)') n_wspd_Am(40,13),
     $                                   (n_wspd_Am(40,ii),ii=1,12)
        write(io8,'(1x,a45,a41)')
     $      '-------- ----- ----- ----- ----- ----- ----- ',
     $      '----- ----- ----- ----- ----- ----- -----'
        write(io8,'(''  < 0    '',13i7)') n_wspd_Am(39,13),
     $                                   (n_wspd_Am(39,ii),ii=1,12)
        do kk=1,37
          kwspd = 5 * (kk-1)
          write(io8,'(i9,13i7)') kwspd,n_wspd_Am(kk,13),
     $                                (n_wspd_Am(kk,ii),ii=1,12)
        enddo
        write(io8,'('' > 180   '',13i7)') n_wspd_Am(38,13),
     $                                   (n_wspd_Am(38,ii),ii=1,12)
c
        write(io8,*)
        write(io8,*) 'Vertical distribution of AIREP wspd reports'
        write(io8,*) '-------------------------------------------'
        write(io8,'(''                           Altitude (kft)'')')
        write(io8,'(1x,a45,a41)')
     $         'Spd(m/s)   <0   0-5   5-10 10-15 15-20 20-25 ',
     $         '25-30 30-35 35-40 40-45 45-50  50    >50 '
        write(io8,'(1x,a45,a41)')
     $      '-------- ----- ----- ----- ----- ----- ----- ',
     $      '----- ----- ----- ----- ----- ----- -----'  
        write(io8,'('' missing '',13i7)') n_wspd_Ar(40,13),
     $                                   (n_wspd_Ar(40,ii),ii=1,12)
        write(io8,'(1x,a45,a41)')
     $      '-------- ----- ----- ----- ----- ----- ----- ',
     $      '----- ----- ----- ----- ----- ----- -----'
        write(io8,'(''  < 0    '',13i7)') n_wspd_Ar(39,13),
     $                                   (n_wspd_Ar(39,ii),ii=1,12)
        do kk=1,37
          kwspd = 5 * (kk-1)
          write(io8,'(i9,13i7)') kwspd,n_wspd_Ar(kk,13),
     $                                (n_wspd_Ar(kk,ii),ii=1,12)
        enddo
        write(io8,'('' > 180   '',13i7)') n_wspd_Ar(38,13),
     $                                   (n_wspd_Ar(38,ii),ii=1,12)
c
        write(io8,*)
        write(io8,*) 'Vertical distribution of manAIREP wspd reports'
        write(io8,*) '-------------------------------------------'
        write(io8,'(''                           Altitude (kft)'')')
        write(io8,'(1x,a45,a41)')
     $         'Spd(m/s)   <0   0-5   5-10 10-15 15-20 20-25 ',
     $         '25-30 30-35 35-40 40-45 45-50  50    >50 '
        write(io8,'(1x,a45,a41)')
     $      '-------- ----- ----- ----- ----- ----- ----- ',
     $      '----- ----- ----- ----- ----- ----- -----'  
        write(io8,'('' missing '',13i7)') n_wspd_Ma(40,13),
     $                                   (n_wspd_Ma(40,ii),ii=1,12)
        write(io8,'(1x,a45,a41)')
     $      '-------- ----- ----- ----- ----- ----- ----- ',
     $      '----- ----- ----- ----- ----- ----- -----'
        write(io8,'(''  < 0    '',13i7)') n_wspd_Ma(39,13),
     $                                   (n_wspd_Ma(39,ii),ii=1,12)
        do kk=1,37
          kwspd = 5 * (kk-1)
          write(io8,'(i9,13i7)') kwspd,n_wspd_Ma(kk,13),
     $                                (n_wspd_Ma(kk,ii),ii=1,12)
        enddo
        write(io8,'('' > 180   '',13i7)') n_wspd_Ma(38,13),
     $                                   (n_wspd_Ma(38,ii),ii=1,12)
      endif
c
      write(*,*)
      write(*,*) 'Duplicate check data counts--',cdtg_an
      write(*,*) '---------------------------------------'
      write(*,'(1x,a55)')
ccccdak     $ 'Type of check     MDCRS   ACARS   AMDAR   AIREP     man'
     $ 'Type of check     MDCRS  TAMDAR   AMDAR   AIREP     man'
      write(*,'(1x,a55)')
     $ '--------------- ------- ------- ------- ------- -------'
      write(*,'('' Num considered '',5(1x,i7))')
     $     nrep_Md,nrep_Ac,nrep_Am,nrep_Ar,nrep_Ma
      write(*,'('' Short ids      '',24x,2(1x,i7),8x)')
     $     n_sh_Ar,n_sh_Ma
      write(*,'(1x,a55)')
     $ '--------------- ------- ------- ------- ------- -------'
      write(*,'('' All duplicates '',5(1x,i7))')
     $     ndup_Md,ndup_Ac,ndup_Am,ndup_Ar,ndup_Ma
      write(*,'(1x,a55)')
     $ '--------------- ------- ------- ------- ------- -------'
      write(*,'('' Bad encode dup '',32x,(1x,i7),8x)')
     $     n_bad_encode
      write(*,'(1x,a55)')
     $ '--------------- ------- ------- ------- ------- -------'
c
      write(io8,*)
      write(io8,*) 'Duplicate check data counts'
      write(io8,*) '---------------------------'
      write(io8,'(1x,a55)')
ccccdak     $ 'Type of check     MDCRS   ACARS   AMDAR   AIREP     man'
     $ 'Type of check     MDCRS  TAMDAR   AMDAR   AIREP     man'
      write(io8,'(1x,a55)')
     $ '--------------- ------- ------- ------- ------- -------'
      write(io8,'(''Num considered '',5(1x,i7))')
     $     nrep_Md,nrep_Ac,nrep_Am,nrep_Ar,nrep_Ma
      write(io8,'(''Missing ids    '',24x,2(1x,i7),8x)')
     $     n_xx999_Ar,n_xx999_Ma
      write(io8,'(''Short ids      '',24x,2(1x,i7),8x)')
     $     n_sh_Ar,n_sh_Ma
      write(io8,'(''Whole deg pos  '',5(1x,i7))')
     $     n_00_Md,n_00_Ac,n_00_Am,n_00_Ar,n_00_Ma
      write(io8,'(''Zero lat/lon   '',5(1x,i7))')
     $     n_0000_Md,n_0000_Ac,n_0000_Am,n_0000_Ar,n_0000_Ma
      write(io8,'(1x,a55)')
     $ '--------------- ------- ------- ------- ------- -------'
      write(io8,'(''All duplicates '',5(1x,i7))')
     $     ndup_Md,ndup_Ac,ndup_Am,ndup_Ar,ndup_Ma
      write(io8,'(1x,a55)')
     $ '--------------- ------- ------- ------- ------- -------'
      write(io8,'(''Bad encode dup '',32x,(1x,i7),8x)')
     $     n_bad_encode
      write(io8,'(1x,a55)')
     $ '--------------- ------- ------- ------- ------- -------'
      write(io8,*)
      write(io8,*) '  Exact duplicates: ',n_exact
      write(io8,*) '  Exact duplicates with short ids: ',n_exact_sh
      write(io8,'(1x,a55)')
     $ '--------------- ------- ------- ------- ------- -------'
      write(io8,'(''Duplicates Md  '',32x,(1x,i7))')
     $     n_ex_sh_MaMd
      write(io8,'(''Duplicates Ac  '',32x,(1x,i7))')
     $     n_ex_sh_MaAc
      write(io8,'(''Duplicates Ar  '',24x,2(1x,i7))')
     $     n_ex_sh_ArAr,n_ex_sh_MaAr
      write(io8,'(''Duplicates Ma  '',24x,2(1x,i7))')
     $     n_ex_sh_ArMa,n_ex_sh_MaMa
      write(io8,'(1x,a55)')
     $ '--------------- ------- ------- ------- ------- -------'
      write(io8,*)
      write(io8,*) '  Exact dups with 0 lat and 0 lon: ',n_exact_0ll
      write(io8,'(1x,a55)')
     $ '--------------- ------- ------- ------- ------- -------'
      write(io8,'(''Duplicates Md  '',5(1x,i7))')
     $     n_ex_0ll_MdMd,n_ex_0ll_AcAc
      write(io8,'(''Duplicates Ar  '',32x,2(1x,i7))')
     $     n_ex_0ll_MaAr
      write(io8,'(''Duplicates Ma  '',32x,2(1x,i7))')
     $     n_ex_0ll_MaMa
      write(io8,'(1x,a55)')
     $ '--------------- ------- ------- ------- ------- -------'
      write(io8,*)
      write(io8,*) '  Other exact duplicates:'
      write(io8,'(1x,a55)')
     $ '--------------- ------- ------- ------- ------- -------'
      write(io8,'(''Duplicates Md  '',2(1x,i7),8x,2(1x,i7))')
     $     n_exact_MdMd,n_exact_MdAc,n_exact_MdAr,n_exact_MdMa
      write(io8,'(''Duplicates Ac  '',8x,(1x,i7),8x,2(1x,i7))')
     $     n_exact_AcAc,n_exact_AcAr,n_exact_AcMa
      write(io8,'(''Duplicates Am  '',16x,4(1x,i7))')
     $     n_exact_AmAm,n_exact_AmAr,n_exact_AmMa
      write(io8,'(''Duplicates Ar  '',24x,3(1x,i7))')
     $     n_exact_ArAr,n_exact_ArMa
      write(io8,'(''Duplicates Ma  '',32x,2(1x,i7))')
     $     n_exact_MaMa
      write(io8,'(1x,a55)')
     $ '--------------- ------- ------- ------- ------- -------'
c
      write(io8,*)
      write(io8,*) 'Exact duplicates with bad roll angle qc flags: '
      write(io8,'(1x,a55)')
     $ '--------------- ------- ------- ------- ------- -------'
      write(io8,'(''Duplicates Md  '',(1x,i7))')
     $     n_ex_bad_roll_Md
      write(io8,'(''Duplicates Am  '',16x,(1x,i7))')
     $     n_ex_bad_roll_Am
      write(io8,'(1x,a55)')
     $ '--------------- ------- ------- ------- ------- -------'
c
      write(io8,*)
      write(io8,*) '  Near duplicates: ',n_near
      write(io8,*) '  Near duplicates with short ids: ',n_near_sh
      write(io8,'(1x,a55)')
     $ '--------------- ------- ------- ------- ------- -------'
      write(io8,'(''Duplicates Md  '',32x,(1x,i7))')
     $     n_nr_sh_MaMd
      write(io8,'(''Duplicates Ac  '',32x,(1x,i7))')
     $     n_nr_sh_MaAc
      write(io8,'(''Duplicates Ar  '',24x,2(1x,i7))')
     $     n_nr_sh_ArAr,n_nr_sh_MaAr
      write(io8,'(''Duplicates Ma  '',24x,2(1x,i7))')
     $     n_nr_sh_ArMa,n_nr_sh_MaMa
      write(io8,'(1x,a55)')
     $ '--------------- ------- ------- ------- ------- -------'
      write(io8,*)
      write(io8,*) '  Near dups with 0 lat and 0 lon: ',n_near_0ll
      write(io8,'(1x,a55)')
     $ '--------------- ------- ------- ------- ------- -------'
      write(io8,'(''Duplicates Md  '',(1x,i7),24x,(1x,i7))')
     $     n_nr_0ll_MdMd,n_nr_0ll_MaMd
      write(io8,'(''Duplicates Ac  '',8x,5(1x,i7))')
     $     n_nr_0ll_AcAc
      write(io8,'(''Duplicates Am  '',32x,(1x,i7))')
     $     n_nr_0ll_MaAm
      write(io8,'(''Duplicates Ar  '',16x,(1x,i7),8x,(1x,i7))')
     $     n_nr_0ll_AmAr,n_nr_0ll_MaAr
      write(io8,'(''Duplicates Ma  '',(1x,i7),8x,(1x,i7),8x,(1x,i7))')
     $     n_nr_0ll_MdMa,n_nr_0ll_AmMa,n_nr_0ll_MaMa
      write(io8,'(1x,a55)')
     $ '--------------- ------- ------- ------- ------- -------'
      write(io8,*)
      write(io8,*) '  Near dups with missing temp: ',n_near_mst
      write(io8,'(1x,a55)')
     $ '--------------- ------- ------- ------- ------- -------'
      write(io8,'(''Duplicates Md  '',(1x,i7),16x,2(1x,i7))')
     $     n_nr_mst_MdMd,n_nr_mst_ArMd,n_nr_mst_MaMd
      write(io8,'(''Duplicates Ac  '',24x,2(1x,i7))')
     $     n_nr_mst_ArAc,n_nr_mst_MaAc
      write(io8,'(''Duplicates Am  '',16x,3(1x,i7))')
     $     n_nr_mst_AmAm,n_nr_mst_ArAm,n_nr_mst_MaAm
      write(io8,'(''Duplicates Ar  '',16x,3(1x,i7))')
     $     n_nr_mst_AmAr,n_nr_mst_ArAr,n_nr_mst_MaAr
      write(io8,'(''Duplicates Ma  '',24x,2(1x,i7))')
     $     n_nr_mst_ArMa,n_nr_mst_MaMa
      write(io8,'(1x,a55)')
     $ '--------------- ------- ------- ------- ------- -------'
      write(io8,*)
      write(io8,*) '  Near dups with missing winds: ',n_near_ws
      write(io8,*) '     ID begins with IT:',n_near_ws_IT
      write(io8,*) '     ID begins with EU:',n_near_ws_EU
      write(io8,'(1x,a55)')
     $ '--------------- ------- ------- ------- ------- -------'
      write(io8,'(''Duplicates Md  '',2(1x,i7),8x,2(1x,i7))')
     $     n_nr_mswn_MdMd,n_nr_mswn_AcMd,n_nr_mswn_ArMd,n_nr_mswn_MaMd
      write(io8,'(''Duplicates Ac  '',2(1x,i7),8x,2(1x,i7))')
     $     n_nr_mswn_MdAc,n_nr_mswn_AcAc,n_nr_mswn_ArAc,n_nr_mswn_MaAc
      write(io8,'(''Duplicates Am  '',5(1x,i7))')
     $     n_nr_mswn_MdAm,n_nr_mswn_AcAm,n_nr_mswn_AmAm,n_nr_mswn_ArAm
     $,    n_nr_mswn_MaAm
      write(io8,'(''Duplicates Ar  '',(1x,i7),8x,4(1x,i7))')
     $     n_nr_mswn_MdAr,n_nr_mswn_AmAr,n_nr_mswn_ArAr,n_nr_mswn_MaAr
      write(io8,'(''Duplicates Ma  '',(1x,i7),16x,3(1x,i7))')
     $     n_nr_mswn_MdMa,n_nr_mswn_ArMa,n_nr_mswn_MaMa
      write(io8,'(1x,a55)')
     $ '--------------- ------- ------- ------- ------- -------'
      write(io8,*)
      write(io8,*) '  Near dups with zero winds: ',n_near_0ws
      write(io8,'(1x,a55)')
     $ '--------------- ------- ------- ------- ------- -------'
      write(io8,'(''Duplicates Md  '',(1x,i7),16x,2(1x,i7))')
     $     n_near_0ws_MdMd,n_near_0ws_ArMd,n_near_0ws_MaMd
      write(io8,'(''Duplicates Am  '',16x,3(1x,i7))')
     $     n_near_0ws_AmAm,n_near_0ws_ArAm,n_near_0ws_MaAm
      write(io8,'(''Duplicates Ar  '',16x,3(1x,i7))')
     $     n_near_0ws_AmAr,n_near_0ws_ArAr,n_near_0ws_MaAr
      write(io8,'(''Duplicates Ma  '',32x,(1x,i7))')
     $     n_near_0ws_MaMa
      write(io8,'(1x,a55)')
     $ '--------------- ------- ------- ------- ------- -------'
      write(io8,*)
      write(io8,*) '  Other near duplicates:'
      write(io8,*) '     Neg AMDAR/pos AIREP altitude: ',n_near_negpos
      write(io8,'(1x,a55)')
     $ '--------------- ------- ------- ------- ------- -------'
      write(io8,'(''Duplicates Md  '',2(1x,i7),8x,2(1x,i7))')
     $     n_near_MdMd,n_near_MdAc,n_near_MdAr,n_near_MdMa
      write(io8,'(''Duplicates Ac  '',8x,(1x,i7),8x,2(1x,i7))')
     $     n_near_AcAc,n_near_AcAr,n_near_AcMa
      write(io8,'(''Duplicates Am  '',16x,4(1x,i7))')
     $     n_near_AmAm,n_near_AmAr,n_near_AmMa
      write(io8,'(''Duplicates Ar  '',24x,3(1x,i7))')
     $     n_near_ArAr,n_near_ArMa
      write(io8,'(''Duplicates Ma  '',32x,2(1x,i7))')
     $     n_near_MaMa
      write(io8,'(1x,a55)')
     $ '--------------- ------- ------- ------- ------- -------'
c
      write(io8,*)
      write(io8,*) 'Near duplicates with low windspeeds: '
      write(io8,'(1x,a55)')
     $ '--------------- ------- ------- ------- ------- -------'
      write(io8,'(''Duplicates Md  '',2(1x,i7),8x,2(1x,i7))')
     $     n_slow_MdMd,n_slow_MdAc,n_slow_MdAr
      write(io8,'(''Duplicates Ac  '',8x,(1x,i7),8x,2(1x,i7))')
     $     n_slow_AcAc,n_slow_AcAr
      write(io8,'(''Duplicates Am  '',16x,4(1x,i7))')
     $     n_slow_AmAm,n_slow_AmAr
      write(io8,'(''Duplicates Ar  '',24x,3(1x,i7))')
     $     n_slow_ArAr,n_slow_ArMa
      write(io8,'(''Duplicates Ma  '',32x,2(1x,i7))')
     $     n_slow_MaMa
      write(io8,'(1x,a55)')
     $ '--------------- ------- ------- ------- ------- -------'
c
      write(io8,*)
      write(io8,*) 'Near duplicates with bad roll angle qc flags: '
      write(io8,'(1x,a55)')
     $ '--------------- ------- ------- ------- ------- -------'
      write(io8,'(''Duplicates Md  '',(1x,i7))')
     $     n_nr_bad_roll_Md
      write(io8,'(''Duplicates Am  '',16x,(1x,i7))')
     $     n_nr_bad_roll_Am
      write(io8,'(1x,a55)')
     $ '--------------- ------- ------- ------- ------- -------'
c
      write(io8,*)
      write(io8,*) 'Near duplicates with position reports: '
      write(io8,'(1x,a55)')
     $ '--------------- ------- ------- ------- ------- -------'
      write(io8,'(''Duplicates Md  '',2(1x,i7),8x,2(1x,i7))')
     $     n_nr_posrep
      write(io8,'(1x,a55)')
     $ '--------------- ------- ------- ------- ------- -------'
c
      return

   99 continue
      print *, '--------------------------------------------------'
      print *, '~~~> SUBR. DUPCHEK_QC (transferred here from subr. ',
     $ 'do_reg): RETURN 1'
      print *, '--------------------------------------------------'
      return 1

      end
c
c ###################################################################
c                            subroutine reorder
c ###################################################################
c
      subroutine reorder(l_flight,numreps,max_reps,indx,krej,in_bad
     $,          io8,l_print,cregmiss,csort,c_acftid,itype
     $,          kflight,maxflt,cid_flt,creg_flt,nobs_flt,ntot_flt
     $,          nrej_flt,iobs_flt,cid_flt_old,ntot_flt_old,nrej_flt_old
     $,          kreg,creg_reg,nobs_reg,nrej_reg,c_acftreg,l_newflt)
c
c Re-order index array to skip bad reports
c
c modified by p.m.pauley (3/2/01) to save extra ids not previously catalogued
c                                  (needed for 2nd flights found in ordchek)
c 
      implicit none
c
c Declaration statements
c ----------------------
      integer      max_reps            ! max number of observations/reports
c
c     Data arrays
c     -----------
      integer      numreps             ! actual number of reports
      integer      itype(max_reps)     ! instrument type
     $,            ktype               ! pointer for instrument type 
      character*9  c_acftid(max_reps)  ! acft flight number
      character*8  c_acftreg(max_reps) ! aircraft registration (tail) number
      character*25 csort(max_reps)     ! variable used for sorting data
c
c     Arrays for mixed duplicates
c     ---------------------------
      integer      maxflt              ! max number of flights allowed
     $,            kflight             ! number of flights in dataset
      character*6  cmaxflt             ! character form of maxflt for NCEP print statement
      character*8  creg_flt(maxflt)    ! tail number for each flight
      character*9  cid_flt(maxflt)     ! flight id for each flight
      character*9  cid_flt_old(maxflt) ! old value of flight id for each flight
      integer      nobs_flt(maxflt)    ! number of reports per flight
     $,            ntot_flt(maxflt)    ! previous value of total number of reports per flight
     $,            ntot_flt_old(maxflt)! previous value of total number of reports per flight
     $,            nrej_flt(maxflt)    ! number of reports rejected per flight
     $,            nrej_flt_old(maxflt)! old value of number of reports rejected per flight
     $,            iobs_flt(maxflt)    ! index for first report in each flight
c
      logical      l_newflt(maxflt)    ! true if flight is new flight
c
c     Tail number variables
c     ---------------------
      integer      kreg                ! number of tail numbers in dataset
      character*8  creg_reg(maxflt)    ! tail numbers
      character*8  cregmiss            ! missing value for tail number
      integer      nobs_reg(maxflt,5)  ! # of reports / flight / type
      integer      nrej_reg(maxflt,5)  ! # of reports rejected / flight / type
     $,            kk,mm               ! index pointing to current tail number
c
c     Pointers
c     --------
      integer      indx(max_reps)      ! pointer index for reports
     $,            in_bad(max_reps)    ! pointer index for bad reports
c
c     Functions
c     ---------
      integer      insty_ob_fun        ! function to convert character
c
c     Other variables
c     ---------------
      integer      io8                 ! i/o unit number for log file
      integer      iob,job             ! do loop index 
     $,            ii,jj               ! index pointing to current report
     $,            iim1,jjm1           ! index pointing to previous report
      integer      keep                ! counter for number of reports kept
     $,            krej                ! counter for number of reports rejected
      integer      kbad(5)             ! counter for number of bad reports
     $,            kgood(5)            ! counter for number of good reports
     $,            kper(5)             ! percentage of bad reports (out of # of good)
     $,            k_yairep            ! number of YRXX86 AIREPs rejected
      real         percent             ! percentage of rejected reports
c
ccccdak      integer      i_acars             ! instrument type for acars
      integer      i_acars             ! instrument type for tamdar
ccccdak     $,            i_acars_lvl         ! instrument type for acars--level flt
     $,            i_acars_lvl         ! instrument type for tamdar--level flt
ccccdak     $,            i_acars_asc         ! instrument type for acars--ascent
     $,            i_acars_asc         ! instrument type for tamdar--ascent
ccccdak     $,            i_acars_des         ! instrument type for acars--descent
     $,            i_acars_des         ! instrument type for tamdar--descent
     $,            i_mdcrs             ! instrument type for mdcrs
     $,            i_mdcrs_lvl         ! instrument type for mdcrs--level flt
     $,            i_mdcrs_asc         ! instrument type for mdcrs--ascent
     $,            i_mdcrs_des         ! instrument type for mdcrs--descent
     $,            i_man_airep         ! instrument type for manual aireps
     $,            i_man_Yairep        ! instrument type for manual aireps (YRXX)
     $,            i_airep             ! instrument type for airep
     $,            i_airep_lvl         ! instrument type for airep--level flt
     $,            i_airep_asc         ! instrument type for airep--ascent
     $,            i_airep_des         ! instrument type for airep--descent
     $,            i_amdar             ! instrument type for amdar
     $,            i_amdar_lvl         ! instrument type for amdar--level flt
     $,            i_amdar_asc         ! instrument type for amdar--ascent
     $,            i_amdar_des         ! instrument type for amdar--descent
     $,            ifirst1             ! indicator - 1st time in subr. maxflt @ ipt 1 exceeded
     $,            ifirst2             ! indicator - 1st time in subr. maxflt @ ipt 2 exceeded
     $,            ifirst3             ! indicator - 1st time in subr. maxflt @ ipt 3 exceeded
c
ccccdak      save         i_acars             ! instrument type for acars
      save         i_acars             ! instrument type for tamdar
ccccdak     $,            i_acars_lvl         ! instrument type for acars--level flt
     $,            i_acars_lvl         ! instrument type for tamdar--level flt
ccccdak     $,            i_acars_asc         ! instrument type for acars--ascent
     $,            i_acars_asc         ! instrument type for tamdar--ascent
ccccdak     $,            i_acars_des         ! instrument type for acars--descent
     $,            i_acars_des         ! instrument type for tamdar--descent
     $,            i_mdcrs             ! instrument type for mdcrs
     $,            i_mdcrs_lvl         ! instrument type for mdcrs--level flt
     $,            i_mdcrs_asc         ! instrument type for mdcrs--ascent
     $,            i_mdcrs_des         ! instrument type for mdcrs--descent
     $,            i_man_airep         ! instrument type for manual aireps
     $,            i_man_Yairep        ! instrument type for manual aireps (YRXX)
     $,            i_airep             ! instrument type for airep
     $,            i_airep_lvl         ! instrument type for airep--level flt
     $,            i_airep_asc         ! instrument type for airep--ascent
     $,            i_airep_des         ! instrument type for airep--descent
     $,            i_amdar             ! instrument type for amdar
     $,            i_amdar_lvl         ! instrument type for amdar--level flt
     $,            i_amdar_asc         ! instrument type for amdar--ascent
     $,            i_amdar_des         ! instrument type for amdar--descent
     $,            ifirst1             ! indicator - 1st time in subr. maxflt @ ipt 1 exceeded
     $,            ifirst2             ! indicator - 1st time in subr. maxflt @ ipt 2 exceeded
     $,            ifirst3             ! indicator - 1st time in subr. maxflt @ ipt 3 exceeded
c
c     Switches
c     --------
      logical      l_flight            ! true if flight stats to be updated
     $,            l_print             ! true if flight stats to be printed
     $,            l_first             ! true first time subroutine is called
     $,            l_done              ! true if finished
c
c     Data statements
c     ---------------
      data l_first /.true./,ifirst1/0/,ifirst2/0/,ifirst3/0/
c
c # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # #
c
c Initialize aircraft data types
c ------------------------------
      if(l_first) then
        i_acars      = insty_ob_fun('acars')
        i_acars_lvl  = insty_ob_fun('acars_lvl') 
        i_acars_asc  = insty_ob_fun('acars_asc') 
        i_acars_des  = insty_ob_fun('acars_des') 
        i_mdcrs      = insty_ob_fun('mdcrs')
        i_mdcrs_lvl  = insty_ob_fun('mdcrs_lvl') 
        i_mdcrs_asc  = insty_ob_fun('mdcrs_asc') 
        i_mdcrs_des  = insty_ob_fun('mdcrs_des')
        i_man_airep  = insty_ob_fun('man-airep') 
        i_man_Yairep = insty_ob_fun('man-Yairep') 
        i_airep      = insty_ob_fun('airep')
        i_airep_lvl  = insty_ob_fun('airep_lvl')
        i_airep_asc  = insty_ob_fun('airep_asc')
        i_airep_des  = insty_ob_fun('airep_des')
        i_amdar      = insty_ob_fun('amdar')
        i_amdar_lvl  = insty_ob_fun('amdar_lvl')
        i_amdar_asc  = insty_ob_fun('amdar_asc')
        i_amdar_des  = insty_ob_fun('amdar_des')
c
        l_first = .false.
      endif
c
c Initialize counters
c -------------------
      k_yairep = 0
c
      kbad = 0
      kgood = 0
c
      keep = 0
c
      l_newflt = .false.
      nrej_reg = 0
c
      kk = 1
      mm = 1
c
c Loop over obs
c -------------
      do iob = 1,numreps 
        ii = indx(iob)
c
c If report rejected...
c ---------------------
        if(csort(ii)(1:5).eq.'badob') then
c
          krej = krej+1
          in_bad(krej) = indx(iob)
c
          csort(ii)(1:25) = 'zzzzzzzzzzzzzzzzzzzzzzzzz'
c
          if(itype(ii).eq.i_mdcrs.or.
     $       itype(ii).eq.i_mdcrs_asc.or.
     $       itype(ii).eq.i_mdcrs_lvl.or.
     $       itype(ii).eq.i_mdcrs_des) then
            kbad(1) = kbad(1) + 1
            ktype = 1
c
          elseif(itype(ii).eq.i_acars.or.
     $           itype(ii).eq.i_acars_asc.or.
     $           itype(ii).eq.i_acars_lvl.or.
     $           itype(ii).eq.i_acars_des) then
            kbad(2) = kbad(2) + 1
            ktype = 2
c
          elseif(itype(ii).eq.i_amdar.or.
     $           itype(ii).eq.i_amdar_asc.or.
     $           itype(ii).eq.i_amdar_lvl.or.
     $           itype(ii).eq.i_amdar_des) then
            kbad(3) = kbad(3) + 1
            ktype = 3
c
          elseif(itype(ii).eq.i_airep.or.
     $           itype(ii).eq.i_airep_asc.or.
     $           itype(ii).eq.i_airep_lvl.or.
     $           itype(ii).eq.i_airep_des) then
            kbad(4) = kbad(4) + 1
            ktype = 4
c
          elseif(itype(ii).eq.i_man_airep.or.
     $           itype(ii).eq.i_man_Yairep) then
            kbad(5) = kbad(5) + 1
            ktype = 5
c
            if(itype(ii).eq.i_man_Yairep)
     $        k_yairep = k_yairep + 1
c
          else
            write(io8,*)
            write(io8,*) 'Bad itype: ',itype(ii),' for ii = ',ii
          endif
c
c         Count rej reps by tail number/flight number, if desired
c         -------------------------------------------------------
          if(l_flight) then
c
c           Increment number of reports rejected per flight
c           -----------------------------------------------
 11         if(c_acftid(ii).eq.cid_flt(mm)) then
              nrej_flt(mm) = nrej_flt(mm) + 1
              if(l_newflt(mm)) then
                mm = 1
              endif
c
            else
              mm = mm + 1
              if(mm.le.kflight) then
                goto 11
c
              else
                if(kflight.ne.maxflt) then
                  kflight = kflight + 1
                else
c-----------------------------------
                  if(ifirst1.eq.0) then
                    ifirst1 = 1
                    write(io8,*)
                    write(io8,*) 'WARNING-1: Need to increase maxflt!'
                    print 53, maxflt,maxflt
   53 format(/' #####> WARNING: THERE ARE MORE THAN ',I6,' AIRCRAFT ',
     + '"FLIGHTS" IN INPUT FILE -- MUST INCREASE SIZE OF PARAMETER ',
     +'NAME "MAXFLT" - WILL CONTINUE ON PROCESSING ONLY ',I6,' FLTS-1'/)
                    write(cmaxflt,'(i6)') maxflt
      call system('[ -n "$jlogfile" ] && $DATA/postmsg'//
     + ' "$jlogfile" "***WARNING:'//cmaxflt//' AIRCRAFT "FLIGHT" '//
     + 'LIMIT EXCEEDED IN PREPOBS_PREPACQC, ONLY '//
     + cmaxflt//' FLIGHTS PROCESSED-1"')
                  endif
c-----------------------------------
                endif
                cid_flt(kflight) = c_acftid(ii)
                creg_flt(kflight) = c_acftreg(ii)
                iobs_flt(kflight) = iob
                ntot_flt(kflight) = 0
                nrej_flt(kflight) = 1
                l_newflt(kflight) = .true.
                mm = 1
c
c               Search backwards for first ob from new flight
c               ---------------------------------------------
                job = iob
                if(job.ne.1) then
12                jjm1 = indx(job-1)
                  if(c_acftid(jjm1)(1:9).eq.cid_flt(kflight)(1:9)) then
                    job = job-1
                    if(job.ne.1) goto 12
                  endif
                endif
c
c               Count total number of obs from new flight
c               -----------------------------------------
                do while(job.le.numreps)
                  jj = indx(job)
                  if(c_acftid(jj)(1:9).eq.cid_flt(kflight)(1:9)) then
                    ntot_flt(kflight) = ntot_flt(kflight) + 1
                    job = job + 1
                  else
                    job = numreps + 1
                  endif
                enddo
c
                nobs_flt(kflight) = ntot_flt(kflight)
c
              endif 
            endif
c
c           Skip blank tail numbers
c           -----------------------
            if(c_acftreg(ii).ne.'        ') then
c
c             If tail numbers are equal, increment counters
c             --------------------------------------------- 
              if(c_acftreg(ii).eq.creg_reg(kk)) then
                nrej_reg(kk,ktype) = nrej_reg(kk,ktype) + 1
c
c             Otherwise, loop to find matching tail number
c             --------------------------------------------
              else
                kk = 1
                l_done = .false.
                do while (.not.l_done)
                  if(c_acftreg(ii).eq.creg_reg(kk)) then
                    nrej_reg(kk,ktype) = nrej_reg(kk,ktype) + 1
                    l_done = .true.
                  else
                    kk = kk + 1
                    if(kk.eq.kreg+1) then
                      write(io8,*) 
                      write(io8,*) 'Tail# not found--',c_acftreg(ii),ii
                      l_done = .true.
                    endif
                  endif
                enddo
              endif
            endif
          endif
c
c If report not rejected...
c -------------------------
        else
          keep = keep + 1
c
          indx(keep) = indx(iob)
c
          if(itype(ii).eq.i_mdcrs.or.
     $       itype(ii).eq.i_mdcrs_asc.or.
     $       itype(ii).eq.i_mdcrs_lvl.or.
     $       itype(ii).eq.i_mdcrs_des) then
            kgood(1) = kgood(1) + 1
c
          elseif(itype(ii).eq.i_acars.or.
     $           itype(ii).eq.i_acars_asc.or.
     $           itype(ii).eq.i_acars_lvl.or.
     $           itype(ii).eq.i_acars_des) then
            kgood(2) = kgood(2) + 1
c
          elseif(itype(ii).eq.i_amdar.or.
     $           itype(ii).eq.i_amdar_asc.or.
     $           itype(ii).eq.i_amdar_lvl.or.
     $           itype(ii).eq.i_amdar_des) then
            kgood(3) = kgood(3) + 1
c
          elseif(itype(ii).eq.i_airep.or.
     $           itype(ii).eq.i_airep_asc.or.
     $           itype(ii).eq.i_airep_lvl.or.
     $           itype(ii).eq.i_airep_des) then
            kgood(4) = kgood(4) + 1
c
          elseif(itype(ii).eq.i_man_airep.or.
     $           itype(ii).eq.i_man_Yairep) then
            kgood(5) = kgood(5) + 1
c
          else
            write(io8,*)
            write(io8,*) 'Bad itype: ',itype(ii),' for ii = ',ii
          endif
        endif
      enddo
c
c Save number of good reports
c ---------------------------
      numreps = keep
c
c Update flight stats if desired
c ------------------------------
      if(l_flight) then
c
c       Initialize variables
c       --------------------
        cid_flt_old = cid_flt   ! DAK: has cid_flt been initialized at this point?
        ntot_flt_old = ntot_flt ! DAK: has ntot_flt been initialized at this point?
        nrej_flt_old = nrej_flt ! DAK: has nrej_flt been initialized at this point?
        iobs_flt = 0
        nobs_flt = 0
        ntot_flt = 0
        nrej_flt = 0
        cid_flt = '         '
        creg_flt = '        '
        l_newflt = .false.
c
c
        mm = 1
c
c       Begin loop over reports
c       -----------------------
        do iob = 1,numreps 
          ii = indx(iob)
          if(iob.eq.1) then
            iim1 = 0
          else
            iim1 = indx(iob-1)
          endif
c
c         Initialize variables for iob = 1
c         --------------------------------
          if(iob.eq.1) then
            kk = 1
            iobs_flt(1) = 1
            nobs_flt(1) = 1
            cid_flt(1) = c_acftid(ii)
            creg_flt(1) = c_acftreg(ii)
c
 101        if(cid_flt(1).eq.cid_flt_old(mm)) then
              ntot_flt(1) = ntot_flt_old(mm)
              nrej_flt(1) = nrej_flt_old(mm)

            else
              mm = mm + 1
              if(mm.le.kflight) then
                goto 101

              else
                write(io8,*)
                write(io8,*) 'flight id #1 not found--',c_acftid(ii)
c
c                ntot_flt(1) = nobs_flt(1)
                cid_flt(1) = c_acftid(ii)
                creg_flt(1) = c_acftreg(ii)
                iobs_flt(1) = iob
                nobs_flt(1) = 1
                ntot_flt(1) = 1
                nrej_flt(1) = 0
                l_newflt(1) = .true.
                mm = 1
              endif 
            endif
c
c         If flight numbers are equal, increment counter
c         ---------------------------------------------- 
          elseif(c_acftid(iim1).eq.c_acftid(ii)) then
            nobs_flt(kk) = nobs_flt(kk) + 1
            if(l_newflt(kk)) then
              mm = 1
            endif
            if(c_acftreg(ii).ne.cregmiss.and.creg_flt(kk).eq.cregmiss) 
     $        creg_flt(kk) = c_acftreg(ii)
c
c         Otherwise, save starting index & start counting reports for next flight
c         -------------------------------------------------------------------------
          else
            if(kk.ne.maxflt) then
              kk = kk + 1
            else
c-----------------------------------
              if(ifirst2.eq.0) then
                write(io8,*)
                write(io8,*) 'WARNING-2: Need to increase maxflt!'
                ifirst2 = 1
                print 753, maxflt,maxflt
  753 format(/' #####> WARNING: THERE ARE MORE THAN ',I6,' AIRCRAFT ',
     + '"FLIGHTS" IN INPUT FILE -- MUST INCREASE SIZE OF PARAMETER ',
     +'NAME "MAXFLT" - WILL CONTINUE ON PROCESSING ONLY ',I6,' FLTS-2'/)
                write(cmaxflt,'(i6)') maxflt
      call system('[ -n "$jlogfile" ] && $DATA/postmsg'//
     + ' "$jlogfile" "***WARNING:'//cmaxflt//' AIRCRAFT "FLIGHT" '//
     + 'LIMIT EXCEEDED IN PREPOBS_PREPACQC, ONLY '//
     + cmaxflt//' FLIGHTS PROCESSED-2"')
              endif
c-----------------------------------
            endif
            iobs_flt(kk) = iob
            nobs_flt(kk) = 1
            cid_flt(kk) = c_acftid(ii)
            creg_flt(kk) = c_acftreg(ii)
c
 201        if(cid_flt(kk).eq.cid_flt_old(mm)) then
              ntot_flt(kk) = ntot_flt_old(mm)
              nrej_flt(kk) = nrej_flt_old(mm)
              mm = 1
c
            else
              mm = mm + 1
              if(mm.le.kflight) then
                goto 201
c
              else
                if(kk.ne.maxflt) then
                  kk = kk + 1
                else
c-----------------------------------
                  if(ifirst3.eq.0) then
                    write(io8,*)
                    write(io8,*) 'WARNING-3: Need to increase maxflt!'
                    ifirst3 = 1
                    print 853, maxflt,maxflt
  853 format(/' #####> WARNING: THERE ARE MORE THAN ',I6,' AIRCRAFT ',
     + '"FLIGHTS" IN INPUT FILE -- MUST INCREASE SIZE OF PARAMETER ',
     +'NAME "MAXFLT" - WILL CONTINUE ON PROCESSING ONLY ',I6,' FLTS-3'/)
                    write(cmaxflt,'(i6)') maxflt
      call system('[ -n "$jlogfile" ] && $DATA/postmsg'//
     + ' "$jlogfile" "***WARNING:'//cmaxflt//' AIRCRAFT "FLIGHT" '//
     + 'LIMIT EXCEEDED IN PREPOBS_PREPACQC, ONLY '//
     + cmaxflt//' FLIGHTS PROCESSED-3"')
                  endif
c-----------------------------------
                endif
                cid_flt(kk) = c_acftid(ii)
                creg_flt(kk) = c_acftreg(ii)
                iobs_flt(kk) = iob
                ntot_flt(kk) = 0
                nrej_flt(kk) = 1
                l_newflt(kk) = .true.
                mm = 1
c
c               Count total number of obs from new flight
c               -----------------------------------------
                job = iob
                do while(job.le.numreps)
                  jj = indx(job)
                  if(c_acftid(jj)(1:9).eq.cid_flt(kk)(1:9)) then
                    ntot_flt(kk) = ntot_flt(kk) + 1
                    job = job + 1
                  else
                    job = numreps + 1
                  endif
                enddo
c
                nobs_flt(kk) = ntot_flt(kk)
c
              endif 
            endif
          endif
        enddo
      endif
c
c      if(kflight.ne.kk) then
c        write(io8,*)
c        write(io8,*) 'Mismatch in numbers of flights'
c        write(io8,*) '  kk = ',kk
c        write(io8,*) '  kflight = ',kflight
c      endif
c
      kflight = kk
c
c Output number of reports retained/skipped
c -----------------------------------------
      if(kgood(1).eq.0)then
        kper(1) = 0
      else
        kper(1) = kbad(1) * 100 / (kgood(1)+kbad(1))
      endif
c
      if(kgood(2).eq.0)then
        kper(2) = 0
      else
        kper(2) = kbad(2) * 100 / (kgood(2)+kbad(2))
      endif
c
      if(kgood(3).eq.0)then
        kper(3) = 0
      else
        kper(3) = kbad(3) * 100 / (kgood(3)+kbad(3))
      endif
c
      if(kgood(4).eq.0)then
        kper(4) = 0
      else
        kper(4) = kbad(4) * 100 / (kgood(4)+kbad(4))
      endif
c
      if(kgood(5).eq.0)then
        kper(5) = 0
      else
        kper(5) = kbad(5) * 100 / (kgood(5)+kbad(5))
      endif
c
      write(io8,*)
      write(io8,*) '  Re-ordering index array'
      write(io8,*) '  -----------------------'
      write(io8,*) numreps,' reports retained'
      write(io8,*) kbad(1),' MDCRS reports skipped leaving    ',kgood(1)
     $          ,'--',kper(1),'%'
ccccdak      write(io8,*) kbad(2),' ACARS reports skipped leaving    ',kgood(2)
      write(io8,*) kbad(2),' TAMDAR rpts skipped leaving      ',kgood(2)
     $          ,'--',kper(2),'%'
      write(io8,*) kbad(3),' AMDAR reports skipped leaving    ',kgood(3)
     $          ,'--',kper(3),'%'
      write(io8,*) kbad(4),' AIREP reports skipped leaving    ',kgood(4)
     $          ,'--',kper(4),'%'                                 
      write(io8,*) kbad(5),' manAIREP reports skipped leaving ',kgood(5)
     $          ,'--',kper(5),'%'
      write(io8,*) '     out of these, ',k_yairep,' are YRXX reports' 
c
c Output indices for each flight
c ------------------------------
      if(l_print.and.l_flight) then
        write(io8,*)
        write(io8,*) 'Subtotals for tail#s with rejected reports'
        write(io8,*) '------------------------------------------'
        write(io8,'(27x,a12,22x,a8)')'Total Number','Rejected'
        write(io8,'(a47,a43)')
     $    '  kk  tail num  #Md    #Ac    #Am    #Ar    #Ma',
     $    '    #Md    #Ac    #Am    #Ar    #Ma     %  '
        write(io8,'(1x,a47,a43)')
     $    '----- -------- ------ ------ ------ ------ ----',
     $    '-- ------ ------ ------ ------ ------ -----'
c
        do kk=1,kreg
          
          if((nobs_reg(kk,1)+nobs_reg(kk,2)+
     $        nobs_reg(kk,3)+nobs_reg(kk,4)+
     $        nobs_reg(kk,5)).ne.0) then
c
            percent = (nrej_reg(kk,1) + nrej_reg(kk,2) 
     $               + nrej_reg(kk,3) + nrej_reg(kk,4)
     $               + nrej_reg(kk,5)) * 100.0
     $              / (nobs_reg(kk,1) + nobs_reg(kk,2) 
     $               + nobs_reg(kk,3) + nobs_reg(kk,4)
     $               + nobs_reg(kk,5))
          else
            percent = -9999.0
          endif
c 
          write(io8,'(i5,1x,a8,10(1x,i6),f6.1)') kk,creg_reg(kk)
     $,       nobs_reg(kk,1),nobs_reg(kk,2)
     $,       nobs_reg(kk,3),nobs_reg(kk,4)
     $,       nobs_reg(kk,5)
     $,       nrej_reg(kk,1),nrej_reg(kk,2)
     $,       nrej_reg(kk,3),nrej_reg(kk,4)
     $,       nrej_reg(kk,5),percent
        enddo
      endif
c
      return
      end
c
c ###################################################################
c                            subroutine do_flt
c ###################################################################
c
      subroutine do_flt(l_first,numreps,max_reps,c_acftid,c_acftreg,idt,
     $           ht_ft,cidmiss,cregmiss,indx,idt_samflt,
     $           kflight,maxflt,cid_flt,creg_flt,nobs_flt,ntot_flt,
     $           nrej_flt,iobs_flt,csort,l_sort,l_print,amiss,io8,*)
c
c     Determine starting index for each flight and number of reports per flight
c
c     modified by p.pauley (4/1/01) to allow a shorter time gap between flight
c                                   segments if a low altitude is found on either
c                                   side of the time gap
c
c     modified by p.pauley (11/1/01) to use both upper and lower case letters
c                                   for the 9th character in the flight id.
c                                   Required to deal with the large number of
c                                   aircraft using flight id VYXAUSJA beginning
c                                   in late October 2001.
c
      implicit none
c
c Declaration statements
c ----------------------
      integer      max_reps            ! max number of observations/reports
c
c     Data arrays
c     -----------
      integer      numreps             ! actual number of reports
      character*9  c_acftid(max_reps)  ! acft flight number
      character*8  c_acftreg(max_reps) ! acft registration (tail) number
      integer      idt(max_reps)       ! time in seconds to analysis time 
      real         ht_ft(max_reps)     ! height in feet
      character*25 csort(max_reps)     ! variable used for sorting data 
c
c     Arrays for mixed duplicates
c     ---------------------------
      integer      maxflt              ! max number of flights allowed
     $,            kflight             ! number of flights in dataset
      character*8  creg_flt(maxflt)    ! tail number for each flight 
      character*9  cid_flt(maxflt)     ! flight id for each flight
      integer      nobs_flt(maxflt)    ! number of reports per flight
     $,            ntot_flt(maxflt)    ! total number of reports per flight
     $,            nrej_flt(maxflt)    ! number of reports rejected per flight
     $,            iobs_flt(maxflt)    ! index for first report in each flight
c
c     Pointers
c     --------
      integer      indx(max_reps)      ! pointer index for reports
c
c     Other variables
c     ---------------
      integer      io8                 ! i/o unit number for log file
      integer      ii                  ! index for current ob
     $,            iim1                ! index for previous ob
     $,            iob                 ! do loop index--over reports
     $,            kk                  ! do loop index--over flights
      integer      nave                ! average number of reports per flight
     $,            nmiss               ! number of reps with missing flight id
     $,            idt_samflt          ! time difference allowed for same flight
     $,            idt_dif             ! actual time difference
      integer      istart              ! first report in flight
     $,            iistart             ! index for first report in flight
     $,            iend                ! last report in flight
     $,            iiend               ! index for last report in flight
      integer      k_abc               ! pointer for c_abc
      integer      knt                 ! counter used in defining iim1
c
      real         amiss               ! real missing value flag
c
      character*1  c_abc(62)           ! array of lower-case and upper-case letters
      character*8  cregmiss            ! missing value flag for tail number
     $,            cidmiss             ! missing value flag for flight number
c
c     Switches
c     --------
      logical      l_first             ! true first time subroutine is called
     $,            l_print             ! true for printing values
     $,            l_sort              ! true if data need to be sorted
     $,            l_same              ! true if tail numbers are same
     $,            l_newid             ! true if letter to be appended to flight id
c
c     Data statements
c     ---------------
      data c_abc/'a','b','c','d','e','f','g','h','i','j','k','l','m',
     $           'n','o','p','q','r','s','t','u','v','w','x','y','z',
     $           'A','B','C','D','E','F','G','H','I','J','K','L','M',
     $           'N','O','P','Q','R','S','T','U','V','W','X','Y','Z',
     $           '0','1','2','3','4','5','6','7','8','9'/
c
c # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # #
c
c Initialize variables
c --------------------
      l_sort = .false.
c
      kflight = 0
      iobs_flt = 0
      nobs_flt = 0
      ntot_flt = 0
      nrej_flt = 0
      cid_flt = '        '
      creg_flt = '        '
c
c Begin loop over reports
c -----------------------
      do iob = 1,numreps 
        ii = indx(iob)
        if(iob.eq.1) then
          iim1 = 0
        else
          iim1 = indx(iob-1)
        endif
c
c Initialize variables for iob = 1
c --------------------------------
        if(iob.eq.1) then
          kflight = 1
          iobs_flt(1) = 1
          nobs_flt(1) = 1
          ntot_flt(1) = 1
          cid_flt(1) = c_acftid(ii)
          creg_flt(1) = c_acftreg(ii)
          nmiss = 1
c
c If flight numbers are equal, increment counter
c ---------------------------------------------- 
        elseif(c_acftid(iim1)(1:9).eq.c_acftid(ii)(1:9)) then
          nobs_flt(kflight) = nobs_flt(kflight) + 1
          ntot_flt(kflight) = ntot_flt(kflight) + 1
          if(c_acftid(ii)(1:8).eq.cidmiss(1:8)) 
     $       nmiss = nmiss + 1
          if(c_acftreg(ii).ne.cregmiss.and.
     $       creg_flt(kflight).eq.cregmiss) 
     $       creg_flt(kflight) = c_acftreg(ii)
c
c Otherwise, save starting index and start counting reports for next flight
c -------------------------------------------------------------------------
        else
          kflight = kflight + 1
c-----------------------------------
c Check index against maximum
c ---------------------------
          if(kflight.gt.maxflt) then
            kflight = kflight - 1
            write(io8,*)
            write(io8,*) 'Subr. DO_FLT, ipoint 1: Max number of ',
     $                   'flights exceeded--increase maxflt'
            return 1
          endif
c-----------------------------------
          cid_flt(kflight) = c_acftid(ii)
          creg_flt(kflight) = c_acftreg(ii)
          iobs_flt(kflight) = iob
          nobs_flt(kflight) = 1
          ntot_flt(kflight) = 1
        endif
      enddo
c
c Check for flights with same flight # (but different tail #s)
c (do this only the first time the subroutine is called)
c ------------------------------------------------------------
      if(l_first) then
        do kk=1,kflight
          istart = iobs_flt(kk)
          iistart = indx(istart)
          iend = iobs_flt(kk) + nobs_flt(kk) - 1
          iiend = indx(iend)
          k_abc = 0
c
c         Check if tail number is constant for entire flight
c         --------------------------------------------------
          l_same = .true.
c
          do iob=istart+1,iend
            ii = indx(iob)
            if(c_acftreg(iistart).eq.cregmiss) then
              istart = istart + 1
              iistart = indx(istart)
            elseif(c_acftreg(ii).ne.c_acftreg(iistart).and.
     $             c_acftreg(ii).ne.cregmiss) then
              l_same = .false.
            endif
          enddo
c
c         Change last char of tail # if second tail # found
c         -------------------------------------------------
          if(.not.l_same) then
            do iob=istart+1,iend
              ii = indx(iob)
              iim1 = indx(iob-1)
c
c             ii report has different tail number than first report
c             -----------------------------------------------------
              if(c_acftreg(ii).ne.c_acftreg(iistart)) then
c
c               ii report has different tail number than ii report
c               --------------------------------------------------
                if(c_acftreg(ii).ne.cregmiss.and.
     $             c_acftreg(ii).ne.c_acftreg(iim1)) then
c
c                 look backwards for same tail number if different ids are found
c                 --------------------------------------------------------------
                  knt = 1
 10               continue
                  if(c_acftreg(ii).ne.c_acftreg(iim1).and.
     $               iob-knt.gt.istart) then
                    knt = knt + 1
                    iim1 = indx(iob-knt)
                    idt_dif = abs(idt(ii) - idt(iim1))
                    goto 10
                  endif
c
c                 use new 9th char if tail number not found
c                 -----------------------------------------
                  if(iim1.eq.iistart) then
                    k_abc = k_abc + 1
c
                    if(k_abc.gt.62) then
                      write(io8,*)
                      write(io8,*) 'k_abc too large--too many tail#s!'
                      c_acftid(ii)(9:9) = '?'
                      csort(ii)(9:9) = '?'
                    else
                      c_acftid(ii)(9:9) = c_abc(k_abc)
                      csort(ii)(9:9) = c_abc(k_abc)
                    endif
c
                    l_sort = .true.
c
c                 use old 9th char if tail number found
c                 -------------------------------------
                  else
                    c_acftid(ii)(9:9) = c_acftid(iim1)(9:9)
                    csort(ii)(9:9) = c_acftid(ii)(9:9)
                  endif
c
c               subsequent reports with different tail number
c               ---------------------------------------------
                elseif(c_acftreg(ii).ne.cregmiss.and.
     $                 c_acftreg(ii).eq.c_acftreg(iim1)) then
c
                  c_acftid(ii)(9:9) = c_acftid(iim1)(9:9)
                  csort(ii)(9:9) = c_acftid(iim1)(9:9)
c
c               missing value for tail number
c               -----------------------------
                elseif(c_acftreg(ii).eq.cregmiss.and.
     $                 iob.ne.istart) then
c
                  if(c_acftreg(iim1).ne.cregmiss.and.
     $              abs(idt(ii)-idt(iim1)).le.7200) then
                    c_acftreg(ii) = c_acftreg(iim1)
c
c                  else
c                    write(io8,*)
c                    write(io8,*) 'Missing tail number found for rep #',ii
c                    write(io8,*) 'Not sure which tail number to choose!'
                  endif
                endif
              endif
            enddo
          endif
        enddo
      endif
c
c Check if large time gaps exist during flight
c and identify coherent flight segments
c --------------------------------------------
      if(.not.l_sort) then
c
        l_sort = .false.
c
        do kk=1,kflight
          istart = iobs_flt(kk)
          iistart = indx(istart)
          iend = iobs_flt(kk) + nobs_flt(kk) - 1
          iiend = indx(iend)
          k_abc = 0
c
          l_newid = .false.
c
          do iob=istart+1,iend
            ii = indx(iob)
            iim1 = indx(iob-1)
            idt_dif = abs(idt(ii) - idt(iim1))
            knt = 1
c
c           increment abc counter and change 8th char if time threshold crossed
c           and flight ids don't change
c           -------------------------------------------------------------------
            if(c_acftid(ii)(1:9).eq.c_acftid(iim1)(1:9).and.
     $         (idt_dif.gt.idt_samflt.or.
     $          (idt_dif.gt.idt_samflt/6.and.
     $           ht_ft(ii).ne.amiss.and.
     $           ht_ft(iim1).ne.amiss.and.
     $           (ht_ft(ii).lt.5001..or.ht_ft(iim1).lt.5001.)))) then 
c
              l_newid = .true.
              l_sort = .true.
              k_abc = k_abc + 1
              if(c_abc(k_abc).eq.c_acftid(ii)(8:8)) k_abc = k_abc + 1
c
              if(k_abc.gt.10) then
                write(io8,*)
                write(io8,*) 'Large value: k_abc = ',k_abc
                write(io8,*) '  ids = ',c_acftreg(ii),' ',c_acftid(ii)
              endif
c
              if(k_abc.gt.62) then
                write(io8,*)
                write(io8,*) 'k_abc too large!'
                c_acftid(ii)(8:8) = '?'
                csort(ii)(8:8) = '?'
              else
                c_acftid(ii)(8:8) = c_abc(k_abc)
                csort(ii)(8:8) = c_acftid(ii)(8:8)
              endif
c
c           Check if flight numbers and tail numbers are the same,
c             the time difference is small, and a new id is in use.
c           Change flight id if so.
c           -------------------------------------------------------
            elseif(c_acftid(ii)(1:7).eq.c_acftid(iim1)(1:7).and.
     $             c_acftreg(ii)(1:8).eq.c_acftreg(iim1)(1:8).and.
     $             idt_dif.le.idt_samflt.and.
     $             l_newid) then
c
              c_acftid(ii)(8:8) = c_acftid(iim1)(8:8)
              csort(ii)(8:8) = c_acftid(ii)(8:8)
            endif
          enddo
c
        enddo
c
c       Re-do flight limits if time gaps found
c       --------------------------------------
        if(l_sort) then
          kflight = 0
          iobs_flt = 0
          nobs_flt = 0
          ntot_flt = 0
          nrej_flt = 0
          cid_flt = '        '
          creg_flt = '        '
c
          do iob = 1,numreps 
            ii = indx(iob)
            if(iob.eq.1) then
              iim1 = 0
            else
              iim1 = indx(iob-1)
            endif
c
c           Initialize variables for iob = 1
c           --------------------------------
            if(iob.eq.1) then
              kflight = 1
              iobs_flt(1) = 1
              nobs_flt(1) = 1
              ntot_flt(1) = 1
              cid_flt(1) = c_acftid(ii)
              creg_flt(1) = c_acftreg(ii)
              nmiss = 1
c
c           If flight numbers are equal, increment counter
c           ---------------------------------------------- 
            elseif(c_acftid(iim1)(1:9).eq.c_acftid(ii)(1:9)) then
              nobs_flt(kflight) = nobs_flt(kflight) + 1
              ntot_flt(kflight) = ntot_flt(kflight) + 1
              if(c_acftid(ii)(1:8).eq.cidmiss(1:8)) 
     $           nmiss = nmiss + 1
              if(c_acftreg(ii).ne.cregmiss.and.
     $           creg_flt(kflight).eq.cregmiss) 
     $           creg_flt(kflight) = c_acftreg(ii)
c
c           Otherwise, save starting index and start counting reports for next flight
c           -------------------------------------------------------------------------
            else
              kflight = kflight + 1
c-----------------------------------
c Check index against maximum
c ---------------------------
              if(kflight.gt.maxflt) then
                kflight = kflight - 1
                write(io8,*)
                write(io8,*) 'Subr. DO_FLT, ipoint 2: Max number of ',
     $                       'flights exceeded--increase maxflt'
                return 1
              endif
c-----------------------------------
              cid_flt(kflight) = c_acftid(ii)
              creg_flt(kflight) = c_acftreg(ii)
              iobs_flt(kflight) = iob
              nobs_flt(kflight) = 1
              ntot_flt(kflight) = 1
            endif
          enddo
        endif
      endif
c
c Output basic stats
c ------------------
      nave = (numreps-nmiss) / (kflight-1)
      write(io8,*)
      write(io8,*) kflight,' different flights found'
      write(io8,*) nave,' reports per flight, on average'
c
c Output indices for each flight
c ------------------------------
      if(l_print.and.((.not.l_sort.and.l_first).or..not.l_first)) then
        write(io8,*)
        write(io8,*) 'Indices for individual flights'
        write(io8,*) '------------------------------'
        write(io8,*) '  kk flight id istrt indx  iend  indx  nobs'
c
        do kk=1,kflight
          istart = iobs_flt(kk)
          iend = iobs_flt(kk) + nobs_flt(kk) - 1
          ii = indx(istart)
          if(ii.eq.0) then
            write(io8,*)
            write(io8,*) 'ii = 0 in do_flt output section'
          endif
         write(io8,'(i5,1x,a9,5(1x,i5))') kk,c_acftid(ii),istart,
     $        indx(istart),iend,indx(iend),nobs_flt(kk)
        enddo
      endif
c
      return
      end
c
c ###################################################################
c                            subroutine do_reg
c ###################################################################
c   
      subroutine do_reg(l_print,io8,
     $           max_reps,numreps,itype,c_qc,c_acftreg,indx,
     $           maxflt,kreg,creg_reg,nobs_reg,*)
c
c     Count number of obs per tail (registration) number
c
      implicit none
c
c Observation variables
c ---------------------
      integer      max_reps            ! maximum number of reports allowed
      integer      numreps             ! actual number of reports
     $,            itype(max_reps)     ! observation type
      character*11 c_qc(max_reps)      ! qc flags
      character*8  c_acftreg(max_reps) ! aircraft registration (tail) number
      integer      indx(max_reps)      ! pointer index for reports
      integer      iob                 ! do loop index--over reports
      integer      ii                  ! index for current ob
c     $,            iim1                ! index for previous ob
c
c Tail number variables
c ---------------------
      integer      maxflt              ! max number of flights/tail numbers
      integer      kreg                ! actual number of tail#s in dataset
      character*8  creg_reg(maxflt)    ! tail numbers
      integer      nobs_reg(maxflt,5)  ! number of reports per tail# per type
      integer      ktot                ! sum of reports categorized
     $,            mm                  ! do loop index--over tail numbers
c
c Other variables
c ---------------
      integer      io8                 ! i/o unit number for log file
c
ccccdak      integer      i_acars             ! instrument type for acars
      integer      i_acars             ! instrument type for tamdar
ccccdak     $,            i_acars_lvl         ! instrument type for acars--level flt
     $,            i_acars_lvl         ! instrument type for tamdar--level flt
ccccdak     $,            i_acars_asc         ! instrument type for acars--ascent
     $,            i_acars_asc         ! instrument type for tamdar--ascent
ccccdak     $,            i_acars_des         ! instrument type for acars--descent
     $,            i_acars_des         ! instrument type for tamdar--descent
     $,            i_mdcrs             ! instrument type for mdcrs
     $,            i_mdcrs_lvl         ! instrument type for mdcrs--level flt
     $,            i_mdcrs_asc         ! instrument type for mdcrs--ascent
     $,            i_mdcrs_des         ! instrument type for mdcrs--descent
     $,            i_man_airep         ! instrument type for manual aireps
     $,            i_man_Yairep        ! instrument type for manual aireps (YRXX)
     $,            i_airep             ! instrument type for airep
     $,            i_airep_lvl         ! instrument type for airep--level flt
     $,            i_airep_asc         ! instrument type for airep--ascent
     $,            i_airep_des         ! instrument type for airep--descent
     $,            i_amdar             ! instrument type for amdar
     $,            i_amdar_lvl         ! instrument type for amdar--level flt
     $,            i_amdar_asc         ! instrument type for amdar--ascent
     $,            i_amdar_des         ! instrument type for amdar--descent
c
c     Function
c     --------
      integer      insty_ob_fun        ! function to convert character
                                       !   instrument type to integer
c
c     Switches
c     --------
      logical      l_print             ! true for printing values
      logical      l_done              ! true if finished
c
c # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # #
c
c Initialize aircraft data types
c ------------------------------
      i_acars      = insty_ob_fun('acars')
      i_acars_lvl  = insty_ob_fun('acars_lvl') 
      i_acars_asc  = insty_ob_fun('acars_asc') 
      i_acars_des  = insty_ob_fun('acars_des') 
      i_mdcrs      = insty_ob_fun('mdcrs')
      i_mdcrs_lvl  = insty_ob_fun('mdcrs_lvl') 
      i_mdcrs_asc  = insty_ob_fun('mdcrs_asc') 
      i_mdcrs_des  = insty_ob_fun('mdcrs_des')
      i_man_airep  = insty_ob_fun('man-airep') 
      i_man_Yairep = insty_ob_fun('man-Yairep') 
      i_airep      = insty_ob_fun('airep')
      i_airep_lvl  = insty_ob_fun('airep_lvl')
      i_airep_asc  = insty_ob_fun('airep_asc')
      i_airep_des  = insty_ob_fun('airep_des')
      i_amdar      = insty_ob_fun('amdar')
      i_amdar_lvl  = insty_ob_fun('amdar_lvl')
      i_amdar_asc  = insty_ob_fun('amdar_asc')
      i_amdar_des  = insty_ob_fun('amdar_des')
c
c Initialize variables
c --------------------
      kreg = 0
      creg_reg = 'xxxxxxxx'
      nobs_reg = 0
c
c Begin loop over reports
c -----------------------
      do iob = 1,numreps 
        ii = indx(iob)
c
c
c Ignore reports with blank tail number and those marked as duplicates
c --------------------------------------------------------------------
        if(c_acftreg(ii).ne.'        '.and.
     $     c_qc(ii)(1:1).ne.'D'.and.
     $     c_qc(ii)(1:1).ne.'d') then
c
c Handle case where kreg = 0
c --------------------------
          if(kreg.eq.0) then
            kreg = 1
            mm = 1
            creg_reg(kreg) = c_acftreg(ii)
            l_done = .true.
c
            if(itype(ii).eq.i_mdcrs.or.
     $         itype(ii).eq.i_mdcrs_lvl.or.
     $         itype(ii).eq.i_mdcrs_asc.or.
     $         itype(ii).eq.i_mdcrs_des) then
              nobs_reg(kreg,1) = 1
c
            elseif(itype(ii).eq.i_acars.or.
     $             itype(ii).eq.i_acars_lvl.or.
     $             itype(ii).eq.i_acars_asc.or.
     $             itype(ii).eq.i_acars_des) then
              nobs_reg(kreg,2) = 1
c
            elseif(itype(ii).eq.i_amdar.or. 
     $             itype(ii).eq.i_amdar_lvl.or.
     $             itype(ii).eq.i_amdar_asc.or.
     $             itype(ii).eq.i_amdar_des) then
              nobs_reg(kreg,3) = 1
c
            elseif(itype(ii).eq.i_airep.or.
     $             itype(ii).eq.i_airep_lvl.or.
     $             itype(ii).eq.i_airep_asc.or.
     $             itype(ii).eq.i_airep_des) then
              nobs_reg(kreg,4) = 1
c
            elseif(itype(ii).eq.i_man_airep.or.
     $             itype(ii).eq.i_man_Yairep) then
              nobs_reg(kreg,5) = 1
            endif
c
c If tail numbers are equal, increment counter
c -------------------------------------------- 
          elseif(c_acftreg(ii).eq.creg_reg(mm)) then
c
            if(itype(ii).eq.i_mdcrs.or.
     $         itype(ii).eq.i_mdcrs_lvl.or.
     $         itype(ii).eq.i_mdcrs_asc.or.
     $         itype(ii).eq.i_mdcrs_des) then
              nobs_reg(mm,1) = nobs_reg(mm,1) + 1
c
            elseif(itype(ii).eq.i_acars.or.
     $             itype(ii).eq.i_acars_lvl.or.
     $             itype(ii).eq.i_acars_asc.or.
     $             itype(ii).eq.i_acars_des) then
              nobs_reg(mm,2) = nobs_reg(mm,2) + 1
c
            elseif(itype(ii).eq.i_amdar.or. 
     $             itype(ii).eq.i_amdar_lvl.or.
     $             itype(ii).eq.i_amdar_asc.or.
     $             itype(ii).eq.i_amdar_des) then
              nobs_reg(mm,3) = nobs_reg(mm,3) + 1
c
            elseif(itype(ii).eq.i_airep.or.
     $             itype(ii).eq.i_airep_lvl.or.
     $             itype(ii).eq.i_airep_asc.or.
     $             itype(ii).eq.i_airep_des) then
              nobs_reg(mm,4) = nobs_reg(mm,4) + 1
c
            elseif(itype(ii).eq.i_man_airep.or.
     $             itype(ii).eq.i_man_Yairep) then
              nobs_reg(mm,5) = nobs_reg(mm,5) + 1
            endif
c
c Otherwise, loop to find matching tail number
c --------------------------------------------
          else
            mm = 1
            l_done = .false.
c
            do while (.not.l_done)
              if(c_acftreg(ii).eq.creg_reg(mm)) then
                l_done = .true.
c
                if(itype(ii).eq.i_mdcrs.or.
     $             itype(ii).eq.i_mdcrs_lvl.or.
     $             itype(ii).eq.i_mdcrs_asc.or.
     $             itype(ii).eq.i_mdcrs_des) then
                  nobs_reg(mm,1) = nobs_reg(mm,1) + 1
c
                elseif(itype(ii).eq.i_acars.or.
     $                 itype(ii).eq.i_acars_lvl.or.
     $                 itype(ii).eq.i_acars_asc.or.
     $                 itype(ii).eq.i_acars_des) then
                  nobs_reg(mm,2) = nobs_reg(mm,2) + 1
c
                elseif(itype(ii).eq.i_amdar.or. 
     $                 itype(ii).eq.i_amdar_lvl.or.
     $                 itype(ii).eq.i_amdar_asc.or.
     $                 itype(ii).eq.i_amdar_des) then
                  nobs_reg(mm,3) = nobs_reg(mm,3) + 1
c
                elseif(itype(ii).eq.i_airep.or.
     $                 itype(ii).eq.i_airep_lvl.or.
     $                 itype(ii).eq.i_airep_asc.or.
     $                 itype(ii).eq.i_airep_des) then
                  nobs_reg(mm,4) = nobs_reg(mm,4) + 1
c
                elseif(itype(ii).eq.i_man_airep.or.
     $                 itype(ii).eq.i_man_Yairep) then
                  nobs_reg(mm,5) = nobs_reg(mm,5) + 1
                endif
c
c             If tail number not found, add to end
c             ------------------------------------
              else
                mm = mm + 1
                if(mm.eq.kreg+1) then
                  kreg = kreg + 1
c-----------------------------------
c Check index against maximum
c ---------------------------
                  if(kreg.gt.maxflt) then
                    kreg = kreg - 1
                    write(io8,*)
                    write(io8,*) 'Subr. DO_REG: Max number of flights ',
     $                           'exceeded--increase maxflt'
                    return 1
                  endif
c-----------------------------------
                  creg_reg(kreg) = c_acftreg(ii)
                  l_done = .true.
c
                  if(itype(ii).eq.i_mdcrs.or.
     $               itype(ii).eq.i_mdcrs_lvl.or.
     $               itype(ii).eq.i_mdcrs_asc.or.
     $               itype(ii).eq.i_mdcrs_des) then
                    nobs_reg(mm,1) = 1
c
                  elseif(itype(ii).eq.i_acars.or.
     $                   itype(ii).eq.i_acars_lvl.or.
     $                   itype(ii).eq.i_acars_asc.or.
     $                   itype(ii).eq.i_acars_des) then
                    nobs_reg(mm,2) = 1
c
                  elseif(itype(ii).eq.i_amdar.or. 
     $                   itype(ii).eq.i_amdar_lvl.or.
     $                   itype(ii).eq.i_amdar_asc.or.
     $                   itype(ii).eq.i_amdar_des) then
                    nobs_reg(mm,3) = 1
c
                  elseif(itype(ii).eq.i_airep.or.
     $                   itype(ii).eq.i_airep_lvl.or.
     $                   itype(ii).eq.i_airep_asc.or.
     $                   itype(ii).eq.i_airep_des) then
                    nobs_reg(mm,4) = 1
c
                  elseif(itype(ii).eq.i_man_airep.or.
     $                   itype(ii).eq.i_man_Yairep) then
                    nobs_reg(mm,5) = 1
                  endif
                endif
              endif
            enddo
c
          endif
        endif
      enddo
c
c Output indices for each flight
c ------------------------------
      if(l_print) then
        write(io8,*)
        write(io8,*) 'Indices for individual tail numbers'
        write(io8,*) '-----------------------------------'
ccccdak        write(io8,*) '  mm flight# #MDCRS  #ACARS  #AMDAR   ',
        write(io8,*) '  mm flight# #MDCRS  #TAMDAR #AMDAR   ',
     $               ' #AIREP  #manAIREP '
      endif
c
      ktot = 0
      do mm=1,kreg
c
       if(l_print) write(io8,'(i5,1x,a8,6(1x,i5))') mm,creg_reg(mm),
     $      nobs_reg(mm,1),nobs_reg(mm,2),nobs_reg(mm,3),
     $      nobs_reg(mm,4),nobs_reg(mm,5)
c
       ktot = ktot + nobs_reg(mm,1) + nobs_reg(mm,2) + nobs_reg(mm,3)
     $             + nobs_reg(mm,4) + nobs_reg(mm,5)
c
      enddo
c
      write(io8,*)
      write(io8,*) numreps,' reports input to do_reg'
      write(io8,*) ktot,' reports categorized by tail number'
c
      return
      end
c
c ###################################################################
c                            subroutine innov_qc
c ###################################################################
c
      subroutine innov_qc(max_reps,numreps,indx,xiv_t,xiv_d,xiv_s,amiss,
     $           c_qc,knt,io8,l_init,l_innov_miss)
c
c Compute distribution of innovations
c
      implicit none
c
c     Work arrays
c     -----------
      integer      io8                 ! i/o unit number for log file
     $,            knt                 ! counter for first or second time innov_qc is called
      integer      ii,nn,iob           ! do loop indices
      integer      n_xiv               ! computed innovation (integer)
      integer      max_reps            ! maximum number of observations allowed
      integer      numreps             ! actual number of reports
      real         amiss               ! missing value flag (real)
      real         xiv_t(max_reps)     ! temperature innovation (ob - bk)
     $,            xiv_d(max_reps)     ! wind direction innovation (ob - bk)
     $,            xiv_s(max_reps)     ! wind speed innovation (ob - bk)
      integer      knt_t(2)            ! number of non-rejected temperature innovations
     $,            knt_d(2)            ! number of non-rejected wind direction innovations
     $,            knt_s(2)            ! number of non-rejected wind speed innovations
      integer      k_t(104,2)          ! distribution of temperature innovations
     $,            k_d(40,2)           ! distribution of wind direction innovations
     $,            k_s(104,2)          ! distribution of wind speed innovations
      integer      indx(max_reps)      ! pointer index for reports
c
      character*11 c_qc(max_reps)      ! qc flags
c
      logical      l_init              ! initialize variables if true
     $,            l_innov_miss        ! true if all innovations missing
c
c # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # #
c
      l_innov_miss = .true.
c
c Initialize histogram arrays
c ---------------------------
      if(l_init) then
        k_t(:,knt) = 0
c
        k_d(:,knt) = 0
c
        k_s(:,knt) = 0
c
        knt_t(knt) = 0
        knt_d(knt) = 0
        knt_s(knt) = 0
      endif
c
c Loop over reports
c -----------------
      do iob=1,numreps
        ii = indx(iob)
c
        nn = nint(xiv_t(ii)) + 52
        if(nn.eq.43) then
          write(io8,*)
          write(io8,*) 'Temperature innovation = -9 for ii = ',ii
          write(io8,*) '  xiv_t = ',xiv_t(ii)
        endif
c
c Count distribution of temperature innovations
c ---------------------------------------------
        if(c_qc(ii)(6:6).ne.'B'.and.
     $     c_qc(ii)(6:6).ne.'E'.and.
     $     c_qc(ii)(6:6).ne.'I'.and.
     $     c_qc(ii)(6:6).ne.'K'.and.
     $     c_qc(ii)(6:6).ne.'b') then
c
          knt_t(knt) = knt_t(knt) + 1
          nn = nint(xiv_t(ii)) + 52
c
          if(xiv_t(ii).eq.amiss) then
            k_t(104,knt) = k_t(104,knt) + 1
          elseif(xiv_t(ii).lt.-50.) then
            k_t(1,knt) = k_t(1,knt) + 1
          elseif(xiv_t(ii).gt.50.) then
            k_t(103,knt) = k_t(103,knt) + 1
          else
            k_t(nn,knt) = k_t(nn,knt) + 1
          endif
        endif
c
c Count distribution of wind direction innovations
c ------------------------------------------------
        if(c_qc(ii)(7:7).ne.'S'.and.
     $     c_qc(ii)(7:7).ne.'E'.and.
     $     c_qc(ii)(7:7).ne.'K'.and.
     $     c_qc(ii)(7:7).ne.'B'.and.
     $     c_qc(ii)(7:7).ne.'I') then
c
          knt_d(knt) = knt_d(knt) + 1
          nn = nint(xiv_d(ii)/10.) + 20
c
          if(xiv_d(ii).eq.amiss) then
            k_d(40,knt) = k_d(40,knt) + 1
          elseif(xiv_d(ii).lt.-180.) then
            k_d(1,knt) = k_d(1,knt) + 1
          elseif(xiv_d(ii).gt.180.) then
            k_d(39,knt) = k_d(39,knt) + 1
          else
            k_d(nn,knt) = k_d(nn,knt) + 1
          endif
        endif
c
c Count distribution of wind speed innovations
c --------------------------------------------
        if(c_qc(ii)(8:8).ne.'S'.and.
     $     c_qc(ii)(8:8).ne.'E'.and.
     $     c_qc(ii)(8:8).ne.'K'.and.
     $     c_qc(ii)(8:8).ne.'B'.and.
     $     c_qc(ii)(8:8).ne.'A'.and.
     $     c_qc(ii)(8:8).ne.'I') then
c
          knt_s(knt) = knt_s(knt) + 1
          nn = nint(xiv_s(ii)) + 52
c
          if(xiv_s(ii).eq.amiss) then
            k_s(104,knt) = k_s(104,knt) + 1
          elseif(xiv_s(ii).lt.-50.) then
            k_s(1,knt) = k_s(1,knt) + 1
          elseif(xiv_s(ii).gt.50.) then
            k_s(103,knt) = k_s(103,knt) + 1
          else
            k_s(nn,knt) = k_s(nn,knt) + 1
          endif
        endif
c
      enddo
c
c Output distribution of temperature innovations if non-missing values present
c ----------------------------------------------------------------------------
      if(knt_t(knt).gt.k_t(104,knt)) then
c
        l_innov_miss = .false.
c
        write(io8,*) 
        write(io8,*) 'Distribution of Temperature Innovations (K)'
        write(io8,*) '-------------------------------------------'
        if(k_t(1,knt).gt.0) write(io8,*) '      < -50 ',k_t(1,knt)
c
        do nn=2,102
          n_xiv = nn - 52
          if(k_t(nn,knt).gt.0) write(io8,*) n_xiv, k_t(nn,knt)
        enddo
c 
        if(k_t(103,knt).gt.0) write(io8,*) '      >  50 ',k_t(103,knt)
        if(k_t(104,knt).gt.0) write(io8,*) '     missing',k_t(104,knt)
c
      else
        write(io8,*)
        write(io8,*) 'All temperature innovations missing'
      endif
c
c Output distribution of wind direction innovations
c -------------------------------------------------
      if(knt_d(knt).gt.k_d(40,knt)) then
c
        l_innov_miss = .false.
c
        write(io8,*) 
        write(io8,*) 'Distribution of Wind Direction Innovations'
        write(io8,*) '------------------------------------------'
        if(k_d(1,knt).gt.0) write(io8,*) '     < -180 ',k_d(1,knt)
c
        do nn=2,38
          n_xiv = (nn - 20) * 10
          if(k_d(nn,knt).gt.0) write(io8,*) n_xiv, k_d(nn,knt)
        enddo
c 
        if(k_d(39,knt).gt.0) write(io8,*) '     >  180 ',k_d(39,knt)
        if(k_d(40,knt).gt.0) write(io8,*) '     missing',k_d(40,knt)
c
      else
        write(io8,*)
        write(io8,*) 'All wind direction innovations missing'
      endif
c
c Output distribution of wind speed innovations
c ---------------------------------------------
      if(knt_s(knt).gt.k_s(104,knt)) then
c
        l_innov_miss = .false.
c
        write(io8,*) 
        write(io8,*) 'Distribution of Wind Speed Innovations (m/s)'
        write(io8,*) '--------------------------------------------'
        if(k_s(1,knt).gt.0)  write(io8,*) '      < -50 ',k_s(1,knt)
c
        do nn=2,102
          n_xiv = nn - 52
          if(k_s(nn,knt).gt.0) write(io8,*) n_xiv, k_s(nn,knt)
        enddo
c 
        if(k_s(103,knt).gt.0) write(io8,*) '      >  50 ',k_s(103,knt)
        if(k_s(104,knt).gt.0) write(io8,*) '     missing',k_s(104,knt)
c
      else
        write(io8,*)
        write(io8,*) 'All wind speed innovations missing'
      endif
c
      return
      end
c
c ###################################################################
c                            subroutine benford_qc
c ###################################################################
c
      subroutine benford_qc(max_reps,numreps,indx,xiv_t,xiv_d,xiv_s,
     $           amiss,c_acftreg,itype,maxflt,kreg_tot,creg_reg_tot,
     $           c_qc,lead_t_tot,lead_d_tot,lead_s_tot,
     $           n_xiv_t,n_xiv_d,n_xiv_s,
     $           sum_xiv_t,sum_xiv_d,sum_xiv_s,
     $           sumabs_xiv_t,sumabs_xiv_d,sumabs_xiv_s,knt,io8
     $,          l_init,l_last)
c
c Compute leading digit distributions to compare with Benford's law
c
      implicit none
c
c     Work arrays
c     -----------
      integer      io8                 ! i/o unit number for log file
      integer      ii,jj,mm,iob,nid    ! do loop indices
      integer      max_reps            ! maximum number of observations allowed
      integer      numreps             ! actual number of reports
     $,            lead                ! value of leading digit
      integer      indx(max_reps)      ! pointer index for reports
      real         amiss               ! missing value flag (real)
      real         xiv_t(max_reps)     ! temperature innovation (ob - bk)
     $,            xiv_d(max_reps)     ! wind direction innovation (ob - bk)
     $,            xiv_s(max_reps)     ! wind speed innovation (ob - bk)
      integer      itype(max_reps)     ! type of aircraft data
      character*8  c_acftreg(max_reps) ! tail numbers
c
      character*11 c_qc(max_reps)      ! qc flags
c
      integer      maxflt              ! maximum number of tail numbers
     $,            kreg_tot            ! number of unique tail numbers
     $,            knt                 ! counter for first or second time benford is called
     $,            ktype               ! instrument type
      character*8  creg_reg_tot(maxflt)     ! master list of tail numbers
      integer      lead_t_tot(maxflt,11,2)  ! distribution of temperature innovation leading digits
     $,            lead_d_tot(maxflt,11,2)  ! distribution of wind direction innovation leading digits
     $,            lead_s_tot(maxflt,11,2)  ! distribution of wind speed innovation leading digits
     $,            lead_t_sum(11,2)    ! overall distribution of temperature innovations
     $,            lead_d_sum(11,2)    ! overall distribution of wind direction innovations
     $,            lead_s_sum(11,2)    ! overall distribution of wind speed innovations
     $,            lead_t_typ(5,11,2)  ! distribution of temperature innovations by instrument type
     $,            lead_d_typ(5,11,2)  ! distribution of wind direction innovations by instrument type
     $,            lead_s_typ(5,11,2)  ! distribution of wind speed innovations by instrument type
     $,            lead_t_reg(33,11,2) ! distribution of temperature innovations by tail number group
     $,            lead_d_reg(33,11,2) ! distribution of wind direction innovations by tail number group
     $,            lead_s_reg(33,11,2) ! distribution of wind speed innovations by tail number group
     $,            n_xiv_t(maxflt,2)   ! number of temperature innovations
     $,            n_xiv_d(maxflt,2)   ! number of wind direction innovations
     $,            n_xiv_s(maxflt,2)   ! number of wind speed innovations
     $,            ntot_xiv_t(2)       ! total number of temperature innovations
     $,            ntot_xiv_d(2)       ! total number of wind direction innovations
     $,            ntot_xiv_s(2)       ! total number of wind speed innovations
     $,            ntyp_xiv_t(5,2)     ! number of temperature innovations by instrument type
     $,            ntyp_xiv_d(5,2)     ! number of wind direction innovations by instrument type
     $,            ntyp_xiv_s(5,2)     ! number of wind speed innovations by instrument type
     $,            ntot_t_reg(33,2)    ! total number of innovations by tail number type
     $,            ntot_d_reg(33,2)    ! total number of innovations by tail number type
     $,            ntot_s_reg(33,2)    ! total number of innovations by tail number type
      real         sum_xiv_t(maxflt,2) ! sum of temperature innovations
     $,            sum_xiv_d(maxflt,2) ! sum of wind direction innovations
     $,            sum_xiv_s(maxflt,2) ! sum of wind speed innovations
     $,            sumabs_xiv_t(maxflt,2)   ! sum of absolute value of temperature innovations
     $,            sumabs_xiv_d(maxflt,2)   ! sum of absolute value of wind direction innovations
     $,            sumabs_xiv_s(maxflt,2)   ! sum of absolute value of wind speed innovations
     $,            avg                 ! average innovation
     $,            avgabs              ! absolute average innovation
     $,            avg_lead(11)        ! average number of innovations per leading digit
c
      integer      insty_ob_fun        ! function to convert character
                                       !   instrument type to integer
c
      character*12 c_lead              ! character form of xiv
      character*8  c_label(5)          ! label for output
      character*2  c_reg_list(33)      ! Tail number ids used to summarize stats
      logical      l_init              ! initialize variables if true
     $,            l_last              ! true if last time subroutine is called
c
ccccdak      data c_label/'MDCRS   ','ACARS   ','AMDAR   ',
      data c_label/'MDCRS   ','TAMDAR  ','AMDAR   ',
     $             'AIREP   ','manAIREP'/
c
      data c_reg_list/'AN','AR','BA','EU','IT','KL','LH','MK','NZ','QF'
     $,               'SA','SK','SV'
     $,               '13','L3','IC','YC','0I','EI','KI','UI','2M','IR'
     $,               'YR','AS','JT','AU','GU','WU','FV','QV','VV','YW'/
c
c # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # #
c
c Initialize leading digit arrays
c -------------------------------
      if(l_init) then
        ntot_xiv_t(1) = 0
        ntot_xiv_d(1) = 0
        ntot_xiv_s(1) = 0
        ntot_xiv_t(2) = 0
        ntot_xiv_d(2) = 0
        ntot_xiv_s(2) = 0
c
        sum_xiv_t(1:kreg_tot,:) = 0.0
        sum_xiv_d(1:kreg_tot,:) = 0.0
        sum_xiv_s(1:kreg_tot,:) = 0.0
        sumabs_xiv_t(1:kreg_tot,:) = 0.0
        sumabs_xiv_d(1:kreg_tot,:) = 0.0
        sumabs_xiv_s(1:kreg_tot,:) = 0.0
        n_xiv_t(1:kreg_tot,:) = 0
        n_xiv_d(1:kreg_tot,:) = 0
        n_xiv_s(1:kreg_tot,:) = 0
c
        lead_t_tot(1:kreg_tot,:,:) = 0
        lead_d_tot(1:kreg_tot,:,:) = 0
        lead_s_tot(1:kreg_tot,:,:) = 0
c
        lead_t_sum = 0
        lead_d_sum = 0
        lead_s_sum = 0
c
        lead_t_reg = 0
        lead_d_reg = 0
        lead_s_reg = 0
        lead_t_typ = 0
        lead_d_typ = 0
        lead_s_typ = 0
        ntot_t_reg = 0
        ntot_d_reg = 0
        ntot_s_reg = 0
        ntyp_xiv_t = 0
        ntyp_xiv_d = 0
        ntyp_xiv_s = 0

      endif
c
c Loop over reports
c -----------------
      do iob=1,numreps
        ii = indx(iob)
c
c       Determine the instrument type
c       -----------------------------
        if(itype(ii).eq.insty_ob_fun('mdcrs').or.
     $     itype(ii).eq.insty_ob_fun('mdcrs_lvl').or.
     $     itype(ii).eq.insty_ob_fun('mdcrs_asc').or.
     $     itype(ii).eq.insty_ob_fun('mdcrs_des')) then
          ktype = 1
c
        elseif(itype(ii).eq.insty_ob_fun('acars').or.
     $         itype(ii).eq.insty_ob_fun('acars_lvl').or.
     $         itype(ii).eq.insty_ob_fun('acars_asc').or.
     $         itype(ii).eq.insty_ob_fun('acars_des')) then
          ktype = 2
c
        elseif(itype(ii).eq.insty_ob_fun('amdar').or. 
     $         itype(ii).eq.insty_ob_fun('amdar_lvl').or.
     $         itype(ii).eq.insty_ob_fun('amdar_asc').or.
     $         itype(ii).eq.insty_ob_fun('amdar_des')) then
          ktype = 3
c
        elseif(itype(ii).eq.insty_ob_fun('airep').or.
     $         itype(ii).eq.insty_ob_fun('airep_lvl').or.
     $         itype(ii).eq.insty_ob_fun('airep_asc').or.
     $         itype(ii).eq.insty_ob_fun('airep_des')) then
          ktype = 4
c
        elseif(itype(ii).eq.insty_ob_fun('man-airep').or.
     $         itype(ii).eq.insty_ob_fun('man-Yairep')) then
          ktype = 5
        endif
c
c Find this tail number in the master list
c ----------------------------------------
        do mm=1,kreg_tot
c
          if(c_acftreg(ii)(1:8).eq.creg_reg_tot(mm)(1:8)) then
c            write(io8,*)
c            write(io8,*) 'Tail number found in master list at mm = ',mm
c
c Compute leading digit distribution for temperature innovations
c --------------------------------------------------------------
            if(c_qc(ii)(6:6).ne.'B'.and.
     $         c_qc(ii)(6:6).ne.'E'.and.
     $         c_qc(ii)(6:6).ne.'I'.and.
     $         c_qc(ii)(6:6).ne.'K'.and.
     $         c_qc(ii)(6:6).ne.'b') then
c
              if(xiv_t(ii).eq.amiss) then
                lead = 11
              elseif(xiv_t(ii).eq.0.0) then
                lead = 10
              else
                write(c_lead,'(e12.5)') xiv_t(ii)
                if(c_lead(2:2).eq.' '.or.
     $             c_lead(2:2).eq.'0'.or.
     $             c_lead(2:2).eq.'-') then
                  lead = ichar(c_lead(4:4)) - 48
                else
                  lead = ichar(c_lead(2:2)) - 48
                  write(io8,*) '?',xiv_t(ii),c_lead,lead
                endif
              endif
c
c              write(io8,*) '  ii = ',ii,' mm = ',mm
c              write(io8,*) '  xiv_t = ',xiv_t(ii),' lead = ',lead
c
              lead_t_tot(mm,lead,knt) = lead_t_tot(mm,lead,knt) + 1
              lead_t_sum(lead,knt)    = lead_t_sum(lead,knt)    + 1
              lead_t_typ(ktype,lead,knt) = 
     $            lead_t_typ(ktype,lead,knt) + 1
c
              if(itype(ii).eq.insty_ob_fun('amdar').or. 
     $           itype(ii).eq.insty_ob_fun('amdar_lvl').or.
     $           itype(ii).eq.insty_ob_fun('amdar_asc').or.
     $           itype(ii).eq.insty_ob_fun('amdar_des')) then
c
                nid = 1
                do while(nid.le.13)
                  if(c_acftreg(ii)(1:2).eq.c_reg_list(nid)(1:2)) then
                    lead_t_reg(nid,lead,knt) = 
     $                  lead_t_reg(nid,lead,knt)+1
                    if(lead.ne.11) 
     $                ntot_t_reg(nid,knt) = ntot_t_reg(nid,knt) + 1
                    nid = 14
                  else
                    nid = nid + 1
                  endif
                enddo
c
              elseif(itype(ii).eq.insty_ob_fun('mdcrs').or.
     $               itype(ii).eq.insty_ob_fun('mdcrs_lvl').or.
     $               itype(ii).eq.insty_ob_fun('mdcrs_asc').or.
     $               itype(ii).eq.insty_ob_fun('mdcrs_des').or.
     $               itype(ii).eq.insty_ob_fun('acars').or.
     $               itype(ii).eq.insty_ob_fun('acars_lvl').or.
     $               itype(ii).eq.insty_ob_fun('acars_asc').or.
     $               itype(ii).eq.insty_ob_fun('acars_des')) then
c
                nid = 14
                do while(nid.le.33)
                  if(c_acftreg(ii)(4:5).eq.c_reg_list(nid)(1:2)) then
                    lead_t_reg(nid,lead,knt) = 
     $                  lead_t_reg(nid,lead,knt) + 1
                    if(lead.ne.11) 
     $                ntot_t_reg(nid,knt) = ntot_t_reg(nid,knt) + 1
                    nid = 34
                  else
                    nid = nid + 1
                  endif
                enddo
              endif
c
              if(lead.ne.11) then
                sum_xiv_t(mm,knt) = sum_xiv_t(mm,knt) + xiv_t(ii)
                sumabs_xiv_t(mm,knt) = sumabs_xiv_t(mm,knt) 
     $                               + abs(xiv_t(ii))
                n_xiv_t(mm,knt) = n_xiv_t(mm,knt) + 1
                ntot_xiv_t(knt) = ntot_xiv_t(knt) + 1
                ntyp_xiv_t(ktype,knt) = ntyp_xiv_t(ktype,knt) + 1
              endif
c
c              write(io8,*) 'lead_t_tot = ',(lead_t_tot(mm,jj,knt),jj=1,11)
c
            endif
c
c
c Compute leading digit distribution for wind direction innovations
c -----------------------------------------------------------------
            if(c_qc(ii)(7:7).ne.'S'.and.
     $         c_qc(ii)(7:7).ne.'E'.and.
     $         c_qc(ii)(7:7).ne.'K'.and.
     $         c_qc(ii)(7:7).ne.'B'.and.
     $         c_qc(ii)(7:7).ne.'I') then
c
              if(xiv_d(ii).eq.amiss) then
                lead = 11
              elseif(xiv_d(ii).eq.0.0) then
                lead = 10
              else
                write(c_lead,'(e12.5)') xiv_d(ii)
                if(c_lead(2:2).eq.' '.or.
     $             c_lead(2:2).eq.'0'.or.
     $             c_lead(2:2).eq.'-') then
                  lead = ichar(c_lead(4:4)) - 48
                else
                  lead = ichar(c_lead(2:2)) - 48
                  write(io8,*) '?',xiv_d(ii),c_lead,lead
                endif
              endif
c
c              write(io8,*) 'ii = ',ii,' mm = ',mm
c              write(io8,*) 'xiv_d = ',xiv_d(ii),' lead = ',lead
c
              lead_d_tot(mm,lead,knt) = lead_d_tot(mm,lead,knt) + 1
              lead_d_sum(lead,knt)    = lead_d_sum(lead,knt)    + 1
              lead_d_typ(ktype,lead,knt) = 
     $            lead_d_typ(ktype,lead,knt) + 1
c
              if(itype(ii).eq.insty_ob_fun('amdar').or. 
     $           itype(ii).eq.insty_ob_fun('amdar_lvl').or.
     $           itype(ii).eq.insty_ob_fun('amdar_asc').or.
     $           itype(ii).eq.insty_ob_fun('amdar_des')) then
c
                nid = 1
                do while(nid.le.13)
                  if(c_acftreg(ii)(1:2).eq.c_reg_list(nid)(1:2)) then
                    lead_d_reg(nid,lead,knt) = 
     $                  lead_d_reg(nid,lead,knt) + 1
                    if(lead.ne.11) 
     $                ntot_d_reg(nid,knt) = ntot_d_reg(nid,knt) + 1
                    nid = 14
                  else
                    nid = nid + 1
                  endif
                enddo
c
              elseif(itype(ii).eq.insty_ob_fun('mdcrs').or.
     $               itype(ii).eq.insty_ob_fun('mdcrs_lvl').or.
     $               itype(ii).eq.insty_ob_fun('mdcrs_asc').or.
     $               itype(ii).eq.insty_ob_fun('mdcrs_des').or.
     $               itype(ii).eq.insty_ob_fun('acars').or.
     $               itype(ii).eq.insty_ob_fun('acars_lvl').or.
     $               itype(ii).eq.insty_ob_fun('acars_asc').or.
     $               itype(ii).eq.insty_ob_fun('acars_des')) then
c
                nid = 14
                do while(nid.le.33)
                  if(c_acftreg(ii)(4:5).eq.c_reg_list(nid)(1:2)) then
                    lead_d_reg(nid,lead,knt) = 
     $                  lead_d_reg(nid,lead,knt) + 1
                    if(lead.ne.11) 
     $                ntot_d_reg(nid,knt) = ntot_d_reg(nid,knt) + 1
                    nid = 34
                  else
                    nid = nid + 1
                  endif
                enddo
              endif
c
              if(lead.ne.11) then
                sum_xiv_d(mm,knt) = sum_xiv_d(mm,knt) + xiv_d(ii)
                sumabs_xiv_d(mm,knt) = sumabs_xiv_d(mm,knt) 
     $                               + abs(xiv_d(ii))
                n_xiv_d(mm,knt) = n_xiv_d(mm,knt) + 1
                ntot_xiv_d(knt) = ntot_xiv_d(knt) + 1
                ntyp_xiv_d(ktype,knt) = ntyp_xiv_d(ktype,knt) + 1
              endif
c
c              write(io8,*) 'lead_d_tot = ',(lead_d_tot(mm,jj,knt),jj=1,11)
c
            endif
c
c Compute leading digit distribution for wind speed innovations
c -------------------------------------------------------------
            if(c_qc(ii)(8:8).ne.'S'.and.
     $         c_qc(ii)(8:8).ne.'E'.and.
     $         c_qc(ii)(8:8).ne.'K'.and.
     $         c_qc(ii)(8:8).ne.'B'.and.
     $         c_qc(ii)(8:8).ne.'A'.and.
     $         c_qc(ii)(8:8).ne.'I') then
c
              if(xiv_s(ii).eq.amiss) then
                lead = 11
              elseif(xiv_s(ii).eq.0.0) then
                lead = 10
              else
                write(c_lead,'(e12.5)') xiv_s(ii)
                if(c_lead(2:2).eq.' '.or.
     $             c_lead(2:2).eq.'0'.or.
     $             c_lead(2:2).eq.'-') then
                  lead = ichar(c_lead(4:4)) - 48
                else
                  lead = ichar(c_lead(2:2)) - 48
                  write(io8,*) '?',xiv_s(ii),c_lead,lead
                endif
              endif
c
c              write(io8,*) 'ii = ',ii,' mm = ',mm
c              write(io8,*) 'xiv_s = ',xiv_s(ii),' lead = ',lead
c
              lead_s_tot(mm,lead,knt) = lead_s_tot(mm,lead,knt) + 1
              lead_s_sum(lead,knt)    = lead_s_sum(lead,knt)    + 1
              lead_s_typ(ktype,lead,knt) = 
     $            lead_s_typ(ktype,lead,knt) + 1
c
              if(itype(ii).eq.insty_ob_fun('amdar').or. 
     $           itype(ii).eq.insty_ob_fun('amdar_lvl').or.
     $           itype(ii).eq.insty_ob_fun('amdar_asc').or.
     $           itype(ii).eq.insty_ob_fun('amdar_des')) then
c
                nid = 1
                do while(nid.le.13)
                  if(c_acftreg(ii)(1:2).eq.c_reg_list(nid)(1:2)) then
                    lead_s_reg(nid,lead,knt) = 
     $                  lead_s_reg(nid,lead,knt) + 1
                    if(lead.ne.11) 
     $                ntot_s_reg(nid,knt) = ntot_s_reg(nid,knt) + 1
                    nid = 14
                  else
                    nid = nid + 1
                  endif
                enddo
c
              elseif(itype(ii).eq.insty_ob_fun('mdcrs').or.
     $               itype(ii).eq.insty_ob_fun('mdcrs_lvl').or.
     $               itype(ii).eq.insty_ob_fun('mdcrs_asc').or.
     $               itype(ii).eq.insty_ob_fun('mdcrs_des').or.
     $               itype(ii).eq.insty_ob_fun('acars').or.
     $               itype(ii).eq.insty_ob_fun('acars_lvl').or.
     $               itype(ii).eq.insty_ob_fun('acars_asc').or.
     $               itype(ii).eq.insty_ob_fun('acars_des')) then
c
                nid = 14
                do while(nid.le.33)
                  if(c_acftreg(ii)(4:5).eq.c_reg_list(nid)(1:2)) then
                    lead_s_reg(nid,lead,knt) = 
     $                  lead_s_reg(nid,lead,knt) + 1
                    if(lead.ne.11) 
     $                ntot_s_reg(nid,knt) = ntot_s_reg(nid,knt) + 1
                    nid = 34
                  else
                    nid = nid + 1
                  endif
                enddo
              endif
c
              if(lead.ne.11) then
                sum_xiv_s(mm,knt) = sum_xiv_s(mm,knt) + xiv_s(ii)
                sumabs_xiv_s(mm,knt) = sumabs_xiv_s(mm,knt) 
     $                               + abs(xiv_s(ii))
                n_xiv_s(mm,knt) = n_xiv_s(mm,knt) + 1
                ntot_xiv_s(knt) = ntot_xiv_s(knt) + 1
                ntyp_xiv_s(ktype,knt) = ntyp_xiv_s(ktype,knt) + 1
              endif
c
c              write(io8,*) 'lead_s_tot = ',(lead_s_tot(mm,jj,knt),jj=1,11)
c
            endif
          endif
        enddo
      enddo
c
c Output results
c --------------
      if(l_last) then
      write(io8,*)
      write(io8,*) 'Temperature statistics'
      write(io8,*) '----------------------'
      write(io8,'(''                     leading digit distribution'')')
      write(io8,'('' Tail#         1     2     3     4     5     6    ''
     $,           '' 7     8     9     0   amiss    tot  avg avgabs'')')
      write(io8,'(''--------------------------------------------------''
     $,           ''-----------------------------------------------'')')
      
c
      do mm=1,kreg_tot
        if(n_xiv_t(mm,knt).ne.0) then
          if(sum_xiv_t(mm,knt).ne.0.0) then
            avg = sum_xiv_t(mm,knt) / float(n_xiv_t(mm,knt))
          else
            avg = 0.0
          endif
          if(sumabs_xiv_t(mm,knt).ne.0.0) then
            avgabs = sumabs_xiv_t(mm,knt) / float(n_xiv_t(mm,knt))
          else
            avgabs = 0.0
          endif
          avg_lead = float(lead_t_tot(mm,:,knt))
     $                   / float(n_xiv_t(mm,knt)) * 100.0
c
          write(io8,'(1x,a8,1x,11i6,i7,2f7.2)')
     $      creg_reg_tot(mm),(lead_t_tot(mm,lead,knt),lead=1,11),
     $      n_xiv_t(mm,knt),avg,avgabs
          write(io8,'(1x,8x,1x,11f6.1)') (avg_lead(lead),lead=1,11)
        endif
      enddo
c
      write(io8,*)
      do jj=1,33
        if(ntot_t_reg(jj,knt).ne.0) then
          avg_lead = float(lead_t_reg(jj,:,knt))
     $                   / float(ntot_t_reg(jj,knt)) * 100.0
c
          write(io8,'(1x,a8,1x,11i6,i7)')
     $      c_reg_list(jj),(lead_t_reg(jj,lead,knt),lead=1,11),
     $      ntot_t_reg(jj,knt)
          write(io8,'(1x,8x,1x,11f6.1)') (avg_lead(lead),lead=1,11)
        endif
      enddo
c
      write(io8,*)
      do ktype=1,5
        if(ntyp_xiv_t(ktype,knt).ne.0) then
          avg_lead = float(lead_t_typ(ktype,:,knt))
     $                   / float(ntyp_xiv_t(ktype,knt)) * 100.0
c
          write(io8,'(1x,a8,1x,11i6,i7)')
     $      c_label(ktype),(lead_t_typ(ktype,lead,knt),lead=1,11),
     $      ntyp_xiv_t(ktype,knt)
          write(io8,'(1x,8x,1x,11f6.1)') (avg_lead(lead),lead=1,11)
        endif
      enddo
c
      write(io8,*)
      if(ntot_xiv_t(knt).ne.0) then
        avg_lead = float(lead_t_sum(:,knt))
     $                 / float(ntot_xiv_t(knt)) * 100.0
c
        write(io8,'(1x,''Overall '',1x,11i6,i7)')
     $    (lead_t_sum(lead,knt),lead=1,11),
     $    ntot_xiv_t(knt)
        write(io8,'(1x,8x,1x,11f6.1)') (avg_lead(lead),lead=1,11)
      endif
c
      write(io8,*)
      write(io8,*) 'Wind direction statistics'
      write(io8,*) '-------------------------'
      write(io8,'(''                     leading digit distribution'')')
      write(io8,'('' Tail#         1     2     3     4     5     6    ''
     $,           '' 7     8     9     0   amiss    tot  avg avgabs'')')
      write(io8,'(''--------------------------------------------------''
     $,           ''-----------------------------------------------'')')
c
      do mm=1,kreg_tot
        if(n_xiv_d(mm,knt).ne.0) then
          if(sum_xiv_d(mm,knt).ne.0.0) then
            avg = sum_xiv_d(mm,knt) / float(n_xiv_d(mm,knt))
          else
            avg = 0.0
          endif
          if(sumabs_xiv_d(mm,knt).ne.0.0) then
            avgabs = sumabs_xiv_d(mm,knt) / float(n_xiv_d(mm,knt))
          else
            avgabs = 0.0
          endif
          avg_lead = float(lead_d_tot(mm,:,knt))
     $                   / float(n_xiv_d(mm,knt)) * 100.0
c
          write(io8,'(1x,a8,1x,11i6,i7,2f7.2)')
     $      creg_reg_tot(mm),(lead_d_tot(mm,lead,knt),lead=1,11),
     $      n_xiv_d(mm,knt),avg,avgabs
          write(io8,'(1x,8x,1x,11f6.1)') (avg_lead(lead),lead=1,11)
        endif
      enddo
c
      write(io8,*)
      do jj=1,33
        if(ntot_d_reg(jj,knt).ne.0) then
          avg_lead = float(lead_d_reg(jj,:,knt))
     $                   / float(ntot_d_reg(jj,knt)) * 100.0
c
          write(io8,'(1x,a8,1x,11i6,i7)')
     $      c_reg_list(jj),(lead_d_reg(jj,lead,knt),lead=1,11),
     $      ntot_d_reg(jj,knt)
          write(io8,'(1x,8x,1x,11f6.1)') (avg_lead(lead),lead=1,11)
        endif
      enddo
c
      write(io8,*)
      do ktype=1,5
        if(ntyp_xiv_d(ktype,knt).ne.0) then
          avg_lead = float(lead_d_typ(ktype,:,knt))
     $                   / float(ntyp_xiv_d(ktype,knt)) * 100.0
c
          write(io8,'(1x,a8,1x,11i6,i7)')
     $      c_label(ktype),(lead_d_typ(ktype,lead,knt),lead=1,11),
     $      ntyp_xiv_d(ktype,knt)
          write(io8,'(1x,8x,1x,11f6.1)') (avg_lead(lead),lead=1,11)
        endif
      enddo
c
      write(io8,*)
      if(ntot_xiv_d(knt).ne.0) then
        avg_lead = float(lead_d_sum(:,knt))
     $                 / float(ntot_xiv_d(knt)) * 100.0
c
        write(io8,'(1x,''Overall '',1x,11i6,i7)')
     $    (lead_d_sum(lead,knt),lead=1,11),
     $    ntot_xiv_d(knt)
        write(io8,'(1x,8x,1x,11f6.1)') (avg_lead(lead),lead=1,11)
      endif
c
      write(io8,*)
      write(io8,*) 'Wind speed statistics'
      write(io8,*) '---------------------'
      write(io8,'(''                     leading digit distribution'')')
      write(io8,'('' Tail#         1     2     3     4     5     6    ''
     $,           '' 7     8     9     0   amiss    tot  avg avgabs'')')
      write(io8,'(''--------------------------------------------------''
     $,           ''-----------------------------------------------'')')
c
      do mm=1,kreg_tot
        if(n_xiv_s(mm,knt).ne.0) then
          if(sum_xiv_s(mm,knt).ne.0.0) then
            avg = sum_xiv_s(mm,knt) / float(n_xiv_s(mm,knt))
          else
            avg = 0.0
          endif
          if(sumabs_xiv_s(mm,knt).ne.0.0) then
            avgabs = sumabs_xiv_s(mm,knt) / float(n_xiv_s(mm,knt))
          else
            avgabs = 0.0
          endif
          avg_lead = float(lead_s_tot(mm,:,knt))
     $                   / float(n_xiv_s(mm,knt)) * 100.0
c
          write(io8,'(1x,a8,1x,11i6,i7,2f7.2)')
     $      creg_reg_tot(mm),(lead_s_tot(mm,lead,knt),lead=1,11),
     $      n_xiv_s(mm,knt),avg,avgabs
          write(io8,'(1x,8x,1x,11f6.1)') (avg_lead(lead),lead=1,11)
        endif
      enddo
c
      write(io8,*)
      do jj=1,33
        if(ntot_s_reg(jj,knt).ne.0) then
          avg_lead = float(lead_s_reg(jj,:,knt))
     $                   / float(ntot_s_reg(jj,knt)) * 100.0
c
          write(io8,'(1x,a8,1x,11i6,i7)')
     $      c_reg_list(jj),(lead_s_reg(jj,lead,knt),lead=1,11),
     $      ntot_s_reg(jj,knt)
          write(io8,'(1x,8x,1x,11f6.1)') (avg_lead(lead),lead=1,11)
        endif
      enddo
c
      write(io8,*)
      do ktype=1,5
        if(ntyp_xiv_s(ktype,knt).ne.0) then
          avg_lead = float(lead_s_typ(ktype,:,knt))
     $                   / float(ntyp_xiv_s(ktype,knt)) * 100.0
c
          write(io8,'(1x,a8,1x,11i6,i7)')
     $      c_label(ktype),(lead_s_typ(ktype,lead,knt),lead=1,11),
     $      ntyp_xiv_s(ktype,knt)
          write(io8,'(1x,8x,1x,11f6.1)') (avg_lead(lead),lead=1,11)
        endif
      enddo
c
      write(io8,*)
      if(ntot_xiv_s(knt).ne.0) then
        avg_lead = float(lead_s_sum(:,knt))
     $                 / float(ntot_xiv_s(knt)) * 100.0
c
        write(io8,'(1x,''Overall '',1x,11i6,i7)')
     $    (lead_s_sum(lead,knt),lead=1,11),
     $    ntot_xiv_s(knt)
        write(io8,'(1x,8x,1x,11f6.1)') (avg_lead(lead),lead=1,11)
      endif
      endif
c
      return
      end
c
c ###################################################################
c                            subroutine invalid_qc
c ###################################################################
c
      subroutine invalid_qc(numreps,max_reps,c_acftreg,c_acftid,c_qc
     $,     alat,alon,pres,ht_ft,t_prcn,ob_t,ob_q,ob_dir,ob_spd
     $,     xiv_t,xiv_q,xiv_d,xiv_s,maxflt,kreg,creg_reg,ntemp_reg
     $,     idt,itype,ichk_t,ichk_q,ichk_d,ichk_s,kbadtot,n_minus9C
     $,     indx,csort,amiss,imiss,io8,io32,l_operational,l_init
     $,     cdtg_an,l_minus9c)
c
c Remove invalid data from dataset
c
c modified 5/18/01 by p.m.pauley-- -9c test refined
c modified 6/28/01 by p.m.pauley--test added for direction=360
c          some aircraft report 360 when they should report 180
c modified 1/8/03 by P.M.Pauley--added check for truncated German
c          AMDAR reports--these seem to have blank tail numbers, which
c          the code changes to 'LH      ' (which the test looks for)
c
      implicit none
c
c Declaration statements
c ----------------------
      integer      max_reps            ! maximum number of reports
c
      character*11 c_qc(max_reps)      ! internal qc flags
c
c     Data arrays
c     -----------
      character*10 cdtg_an             ! date time group for analysis
      integer      numreps             ! actual number of reports
      integer      itype(max_reps)     ! type of aircraft data
     $,            ktype               ! pointer for instrument type 
      integer      idt(max_reps)       ! time in seconds to analysis time 
      character*8  c_acftreg(max_reps) ! aircraft registration (tail) number
      character*9  c_acftid(max_reps)  ! aircraft flight number
      real*8       alat(max_reps)      ! latitude
     $,            alon(max_reps)      ! longitude
      real         pres(max_reps)      ! pressure
     $,            ht_ft(max_reps)     ! height in feet
      real         t_prcn(max_reps)    ! temperature precision
      real         ob_t(max_reps)      ! temperature
     $,            ob_q(max_reps)      ! specific humidity
     $,            ob_dir(max_reps)    ! wind direction
     $,            ob_spd(max_reps)    ! wind speed
      real         xiv_t(max_reps)     ! temperature innovation (ob - bk)
     $,            xiv_q(max_reps)     ! specific humidity innovation (ob - bk)
     $,            xiv_d(max_reps)     ! wind direction innovation (ob - bk)
     $,            xiv_s(max_reps)     ! wind speed innovation (ob - bk)
      integer      ichk_t(max_reps)    ! NRL QC flag for temperature ob
     $,            ichk_q(max_reps)    ! NRL QC flag for specific humidity ob
     $,            ichk_d(max_reps)    ! NRL QC flag for wind direction ob
     $,            ichk_s(max_reps)    ! NRL QC flag for wind speed ob
      character*25 csort(max_reps)     ! sort variable    
      logical      l_minus9c(max_reps)     ! true for mdcrs -9C temperatures
c
c     Pointers
c     --------
      integer      indx(max_reps)      ! pointer index for good reports
c
c     Functions
c     ---------
      character*16 c_insty_ob          ! function to convert integer instrument 
                                       !   type to character instrument type
      integer      insty_ob_fun        ! function to convert character
                                       !   instrument type to integer
c
c     Other variables
c     ---------------
      integer      io8                 ! i/o unit number for log file
      integer      io32                ! i/o unit number for rejected reports
c
      integer      imiss               ! integer missing value flag
      real         amiss               ! real missing value flag
c
      integer      iob                 ! do loop index 
     $,            ii                  ! index pointing to current report
     $,            iim2                ! index pointing to report before previous report
     $,            iim1                ! index pointing to previous report
     $,            iip1                ! index pointing to following report
     $,            iip2                ! index pointing to report after following report
     $,            kbadtot             ! total number of rejected duplicates
     $,            kbad(5)             ! counter for number of invalid reports
c
ccccdak      integer      i_acars             ! instrument type for acars
      integer      i_acars             ! instrument type for tamdar
ccccdak     $,            i_acars_lvl         ! instrument type for acars--level flt
     $,            i_acars_lvl         ! instrument type for tamdar--level flt
ccccdak     $,            i_acars_asc         ! instrument type for acars--ascent
     $,            i_acars_asc         ! instrument type for tamdar--ascent
ccccdak     $,            i_acars_des         ! instrument type for acars--descent
     $,            i_acars_des         ! instrument type for tamdar--descent
     $,            i_mdcrs             ! instrument type for mdcrs
     $,            i_mdcrs_lvl         ! instrument type for mdcrs--level flt
     $,            i_mdcrs_asc         ! instrument type for mdcrs--ascent
     $,            i_mdcrs_des         ! instrument type for mdcrs--descent
     $,            i_man_airep         ! instrument type for manual aireps
     $,            i_man_Yairep        ! instrument type for manual aireps (YRXX)
     $,            i_airep             ! instrument type for airep
     $,            i_airep_lvl         ! instrument type for airep--level flt
     $,            i_airep_asc         ! instrument type for airep--ascent
     $,            i_airep_des         ! instrument type for airep--descent
     $,            i_amdar             ! instrument type for amdar
     $,            i_amdar_lvl         ! instrument type for amdar--level flt
     $,            i_amdar_asc         ! instrument type for amdar--ascent
     $,            i_amdar_des         ! instrument type for amdar--descent
c
      integer      n_empty(5)          ! number of empty reports
     $,            n_zero_tmp(5)       ! number of reports with zero winds and temperature
     $,            n_zero_alt(5)       ! number of reports with zero winds and altitude
     $,            n_zero_pos(5)       ! number of reports with zero lat/lon
     $,            n_bad_decode(5)     ! number of reports with bad decodes
     $,            n_miss_time(5)      ! number of reports with missing times
     $,            n_miss_pos(5)       ! number of reports with missing positions
     $,            n_miss_pres(5)      ! number of reports with missing pressures
     $,            n_small_pres(5)     ! number of reports with too small pressures
     $,            n_low_airep(5)      ! number of low-level aireps rejected 
                                       ! (sign on altitude is ambiguous)
     $,            n_minus9C(5)        ! number of -9C temperatures rejected
     $,            n_bad360(5)         ! number of erroneous north winds
     $,            n_bad180(5)         ! number of erroneous south winds
c
      integer      n_xx999_Ar          ! number of aireps with missing id
     $,            n_xx999_Ma          ! number of manual aireps with missing id
      integer      n_blank_Ar          ! number of aireps with blank id
     $,            n_blank_Ma          ! number of manual aireps with blank id
     $,            n_blank_Md          ! number of MDCRS reports with blank id
     $,            n_blank_Am          ! number of AMDAR reports with blank id
c
ccccdak      integer      nrep_Ac             ! number of acars reports considered
      integer      nrep_Ac             ! number of tamdar reports considered
     $,            nrep_Md             ! number of mdcrs reports considered
     $,            nrep_Ma             ! number of manual airep reports considered
     $,            nrep_Ar             ! number of airep reports considered
     $,            nrep_Am             ! number of amdar reports considered
ccccdak     $,            nbad_Ac             ! number of bad acars
     $,            nbad_Ac             ! number of bad tamdar
     $,            nbad_Md             ! number of bad mdcrs
     $,            nbad_Ma             ! number of bad manual aireps
     $,            nbad_Ar             ! number of bad aireps
     $,            nbad_Am             ! number of bad amdar 
c
      integer      maxflt              ! max number of flights allowed
      integer      kreg                ! actual number of tail#s in dataset
     $,            mm                  ! index pointing to current tail number
      character*8  creg_reg(maxflt)    ! tail numbers
      integer      ntemp_reg(maxflt,5) ! number of reports w. rejected temp
c
      integer      knt                 ! counter used in defining iim1, iip1
c
c     Switches
c     --------
      logical      l_print             ! print values if true
     $,            l_operational       ! run QC in operational mode if true
     $,            l_init              ! initialize counters if true
c     $,            l_ual_all           ! true if all remapped ids are UAL acft
c
c # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # #
c
c Initialize aircraft data types
c ------------------------------
      i_acars      = insty_ob_fun('acars')
      i_acars_lvl  = insty_ob_fun('acars_lvl') 
      i_acars_asc  = insty_ob_fun('acars_asc') 
      i_acars_des  = insty_ob_fun('acars_des') 
      i_mdcrs      = insty_ob_fun('mdcrs')
      i_mdcrs_lvl  = insty_ob_fun('mdcrs_lvl') 
      i_mdcrs_asc  = insty_ob_fun('mdcrs_asc') 
      i_mdcrs_des  = insty_ob_fun('mdcrs_des')
      i_man_airep  = insty_ob_fun('man-airep') 
      i_man_Yairep = insty_ob_fun('man-Yairep') 
      i_airep      = insty_ob_fun('airep')
      i_airep_lvl  = insty_ob_fun('airep_lvl')
      i_airep_asc  = insty_ob_fun('airep_asc')
      i_airep_des  = insty_ob_fun('airep_des')
      i_amdar      = insty_ob_fun('amdar')
      i_amdar_lvl  = insty_ob_fun('amdar_lvl')
      i_amdar_asc  = insty_ob_fun('amdar_asc')
      i_amdar_des  = insty_ob_fun('amdar_des')
c
c Initialize counters
c -------------------
      if(l_init) then
        n_empty = 0
        n_zero_tmp = 0
        n_zero_alt = 0
        n_zero_pos = 0
        n_bad_decode = 0
        n_miss_time = 0
        n_miss_pos = 0
        n_miss_pres = 0
        n_small_pres = 0
        n_low_airep = 0
        n_minus9C = 0
        n_bad360 = 0
        n_bad180 = 0
c
        n_xx999_Ar = 0
        n_xx999_Ma = 0
        n_blank_Ar = 0
        n_blank_Ma = 0
        n_blank_Md = 0
        n_blank_Am = 0
c
        nrep_Ac = 0
        nrep_Md = 0
        nrep_Ma = 0
        nrep_Ar = 0
        nrep_Am = 0
        nbad_Ac = 0
        nbad_Md = 0
        nbad_Ma = 0
        nbad_Ar = 0
        nbad_Am = 0
      endif
c
c Begin loop over reports
c -----------------------
      do iob = 1,numreps
c
        l_print = .false.
c
c       Compute ii index
c       ----------------
        ii = indx(iob)
c
c       Compute ii-1 index
c       ------------------
        knt = iob - 1
 10     if(knt.ge.1) then
          iim1 = indx(knt)
          if(c_qc(iim1)(1:1).eq.'B'.or.
     $       c_qc(iim1)(3:4).eq.'BB'.or.
     $       c_qc(iim1)(2:2).eq.'M'.or.
     $       c_qc(iim1)(3:3).eq.'M'.or.
     $       c_qc(iim1)(4:4).eq.'M'.or.
     $       c_qc(iim1)(5:5).eq.'M'.or.
     $       c_qc(iim1)(5:5).eq.'B'.or.
     $       c_qc(iim1)(6:6).eq.'B'.or.
     $       c_qc(iim1)(7:7).eq.'B'.or.
     $       c_qc(iim1)(6:8).eq.'MMM') then
            knt = knt - 1
            goto 10
          endif
        else
          iim1 = 0
        endif
c
c       Compute ii-2 index
c       ------------------
        knt = knt - 1
 15     if(knt.ge.1) then
          iim2 = indx(knt)
          if(c_qc(iim2)(1:1).eq.'B'.or.
     $       c_qc(iim2)(3:4).eq.'BB'.or.
     $       c_qc(iim2)(2:2).eq.'M'.or.
     $       c_qc(iim2)(3:3).eq.'M'.or.
     $       c_qc(iim2)(4:4).eq.'M'.or.
     $       c_qc(iim2)(5:5).eq.'M'.or.
     $       c_qc(iim2)(5:5).eq.'B'.or.
     $       c_qc(iim2)(6:6).eq.'B'.or.
     $       c_qc(iim2)(7:7).eq.'B'.or.
     $       c_qc(iim2)(6:8).eq.'MMM') then
            knt = knt - 1
            goto 15
          endif
        else
          iim2 = 0
        endif
c
c       Compute ii+1 index
c       ------------------
        knt = iob + 1
 20     if(knt.le.numreps) then
          iip1 = indx(knt)
          if(c_qc(iip1)(1:1).eq.'B'.or.
     $       c_qc(iip1)(3:4).eq.'BB'.or.
     $       c_qc(iip1)(2:2).eq.'M'.or.
     $       c_qc(iip1)(3:3).eq.'M'.or.
     $       c_qc(iip1)(4:4).eq.'M'.or.
     $       c_qc(iip1)(5:5).eq.'M'.or.
     $       c_qc(iip1)(5:5).eq.'B'.or.
     $       c_qc(iip1)(6:6).eq.'B'.or.
     $       c_qc(iip1)(7:7).eq.'B'.or.
     $       c_qc(iip1)(6:8).eq.'MMM') then
            knt = knt + 1
            goto 20
          endif
        else
          iip1 = 0
        endif
c
c       Compute ii+2 index
c       ------------------
        knt = knt + 1
 25     if(knt.le.numreps) then
          iip2 = indx(knt)
          if(c_qc(iip2)(1:1).eq.'B'.or.
     $       c_qc(iip2)(3:4).eq.'BB'.or.
     $       c_qc(iip2)(2:2).eq.'M'.or.
     $       c_qc(iip2)(3:3).eq.'M'.or.
     $       c_qc(iip2)(4:4).eq.'M'.or.
     $       c_qc(iip2)(5:5).eq.'M'.or.
     $       c_qc(iip2)(5:5).eq.'B'.or.
     $       c_qc(iip2)(6:6).eq.'B'.or.
     $       c_qc(iip2)(7:7).eq.'B'.or.
     $       c_qc(iip2)(6:8).eq.'MMM') then
            knt = knt + 1
            goto 25
          endif
        else
          iip2 = 0
        endif
c
c Set ktype
c ---------
        if(itype(ii).eq.i_mdcrs_lvl.or.
     $     itype(ii).eq.i_mdcrs_asc.or.
     $     itype(ii).eq.i_mdcrs_des.or.
     $     itype(ii).eq.i_mdcrs) then 
          ktype = 1
c
        elseif(itype(ii).eq.i_acars_lvl.or.
     $         itype(ii).eq.i_acars_asc.or.
     $         itype(ii).eq.i_acars_des.or.
     $         itype(ii).eq.i_acars) then 
          ktype = 2
c
        elseif(itype(ii).eq.i_amdar_lvl.or.
     $         itype(ii).eq.i_amdar_asc.or.
     $         itype(ii).eq.i_amdar_des.or.
     $         itype(ii).eq.i_amdar) then 
          ktype = 3
c
        elseif(itype(ii).eq.i_airep_lvl.or.
     $         itype(ii).eq.i_airep_asc.or.
     $         itype(ii).eq.i_airep_des.or.
     $         itype(ii).eq.i_airep) then
          ktype = 4
c
        elseif(itype(ii).eq.i_man_airep.or.
     $         itype(ii).eq.i_man_Yairep) then
          ktype = 5
        endif
c
c       Count reports with missing ids
c       ------------------------------
        if(c_acftid(ii)(1:5).eq.'XX999'.or.
     $     c_acftid(ii)(1:4).eq.'////') then
c
          c_qc(ii)(1:1) = 'B'
c
          if(ktype.eq.4) then 
            n_xx999_Ar = n_xx999_Ar + 1
c
          elseif(ktype.eq.5) then
            n_xx999_Ma = n_xx999_Ma + 1
          endif
c
          l_print = .false.
          if(l_print) then
            write(io8,*)
            write(io8,*) 'Report found with missing id'
          endif
c
c       Count reports with blank ids
c       ----------------------------

C DAK: Here is where TAMDAR reports were originally tossed for having a blank tail number due
c      to logic in subroutine dupchek_qc that would not allow one to be generated (flight
c      number was all numbers and tail number was originally missing, thus a tail number
c      could not be created from the flight number) -- this has since been bypassed by
c      changing characters 1-3 in in the flight number to "TAM" in subroutine input_acqc
c      where the reports are read in from NCEP PREPBUFR file and stored in memory

        elseif(c_acftreg(ii)(1:8).eq.'        ') then
c
          c_qc(ii)(1:1) = 'B'
c
          if(ktype.eq.1) then 
            n_blank_Md = n_blank_Md + 1
c
          elseif(ktype.eq.3) then
            n_blank_Am = n_blank_Am + 1
c
          elseif(ktype.eq.4) then
            n_blank_Ar = n_blank_Ar + 1
c
          elseif(ktype.eq.5) then
            n_blank_Ma = n_blank_Ma + 1
          endif
c
          l_print = .true.
          if(l_print) then
            write(io8,*)
            write(io8,*) 'Report found with blank tail number'
          endif
c
c       Look for truncated German AMDAR reports
c       ---------------------------------------
        elseif(c_acftreg(ii)(1:8).eq.'LH      '.and.
     $         ktype.eq.3) then
c
          c_qc(ii)(1:1) = 'B'
          n_bad_decode(3) = n_bad_decode(3) + 1
c
          l_print = .true.
          if(l_print) then
            write(io8,*)
            write(io8,*) 'Truncated German AMDAR report'
          endif
c
c Count reports marked bad in decoder
c -----------------------------------
        elseif(c_qc(ii)(1:1).eq.'B') then
c
          n_bad_decode(ktype) = n_bad_decode(ktype) + 1
c
          l_print = .true.
          if(l_print) then
            write(io8,*)
            write(io8,*) 'Report marked bad in decoder'
          endif
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
c
c Check for zero position--lat/lon both zero
c ------------------------------------------
        elseif(abs(alat(ii)).lt.0.001.and.
     $         abs(alon(ii)).lt.0.001) then
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
c
          c_qc(ii)(3:4) = 'BB'
c
          n_zero_pos(ktype) = n_zero_pos(ktype) + 1
c
          l_print = .true.
          if(l_print) then
            write(io8,*)
            write(io8,*) 'Report found with zero lat and lon'
          endif
c
c Check for missing time
c ----------------------
        elseif(idt(ii).eq.imiss) then
c
          c_qc(ii)(2:2) = 'M'
c
          n_miss_time(ktype) = n_miss_time(ktype) + 1
c
          l_print = .true.
          if(l_print) then
            write(io8,*)
            write(io8,*) 'Report found with missing time'
          endif
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
c
c Check for missing latitude/longitude
c ------------------------------------
        elseif(alat(ii).eq.amiss.or.
     $         alon(ii).eq.amiss) then
c
          if(alat(ii).eq.amiss) c_qc(ii)(3:3) = 'M'
          if(alon(ii).eq.amiss) c_qc(ii)(4:4) = 'M'
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
c
          n_miss_pos(ktype) = n_miss_pos(ktype) + 1
c
          l_print = .true.
          if(l_print) then
            write(io8,*)
            write(io8,*) 'Report found with missing lat or lon'
          endif
c
c Check for missing pressure/altitude
c -----------------------------------
        elseif(pres(ii).eq.amiss.and.ht_ft(ii).eq.amiss) then
c
          c_qc(ii)(5:5) = 'M'
c
          n_miss_pres(ktype) = n_miss_pres(ktype) + 1
c
          l_print = .true.
          if(l_print) then
            write(io8,*)
            write(io8,*) 'Report found with missing pressure'
          endif
c
c Check for too-small pressure (too-large altitude)
c Allow high altitude manual AIREPs from Concordes (BAW and AFR)
c --------------------------------------------------------------
        elseif(ht_ft(ii).gt.49999.5.or.pres(ii).lt.116.05) then
          if((itype(ii).eq.i_man_airep.or.
     $        itype(ii).eq.i_man_Yairep).and.
     $       (c_acftid(ii)(1:3).eq.'AFR'.or.
     $        c_acftid(ii)(1:3).eq.'BAW')) then
c
            l_print = .false.
            if(l_print) then
              write(io8,*)
              write(io8,*) 'Valid high-altitude report--ii = ',ii
            endif
c
          else
            c_qc(ii)(5:5) = 'B'
c
            n_small_pres(ktype) = n_small_pres(ktype) + 1
c
            l_print = .true.
            if(l_print) then
              write(io8,*)
              write(io8,*) 'Altitude is too high!'
            endif
          endif
c
c       Check for low-level airep reports--altitude sign not known
c       ----------------------------------------------------------
        elseif((itype(ii).eq.i_airep.or.
     $          itype(ii).eq.i_man_airep.or.
     $          itype(ii).eq.i_man_Yairep).and.
     $          abs(ht_ft(ii)).lt.600.0) then
c
          c_qc(ii)(5:5) = 'B'
c
          n_low_airep(ktype) = n_low_airep(ktype) + 1
c
          l_print = .false.
          if(l_print) then
            write(io8,*)
            write(io8,*) 'Low-altitude AIREP found'
          endif
c
c Check for empty report--temperature and winds missing
c -----------------------------------------------------
        elseif(ob_t(ii).eq.amiss.and.
     $         (ob_dir(ii).eq.amiss.or.
     $          ob_spd(ii).eq.amiss)) then
c
          c_qc(ii)(6:9) = 'MMMN'
          if(ob_q(ii).eq.amiss) c_qc(ii)(9:9) = 'M'
c
          n_empty(ktype) = n_empty(ktype) + 1
c
          l_print = .true.
          if(l_print) then
            write(io8,*)
            write(io8,*) 'Report found with missing temperature, winds'
          endif
c
c Check for empty report--temperature and winds zero
c --------------------------------------------------
        elseif(abs(ob_t(ii)-273.16).lt.0.05.and.
     $         (ifix(ob_dir(ii)).eq.360.or.ifix(ob_dir(ii)).eq.0).and.
     $         ifix(ob_spd(ii)*10.0).eq.0.and.
     $         (itype(ii).eq.i_man_airep.or.
     $          itype(ii).eq.i_man_Yairep)) then
c
          c_qc(ii)(6:9) = 'MMMN'
          if(ob_q(ii).eq.amiss) c_qc(ii)(9:9) = 'M'
c
          n_zero_tmp(ktype) = n_zero_tmp(ktype) + 1
c
          l_print = .true.
          if(l_print) then
            write(io8,*)
            write(io8,*) 'Report found with zero C temperature, winds'
          endif
c
c Check for empty report--altitude and winds zero
c -----------------------------------------------
        elseif(ifix(ht_ft(ii)).eq.0.and.
     $         (ifix(ob_dir(ii)).eq.360.or.ifix(ob_dir(ii)).eq.0).and.
     $         ifix(ob_spd(ii)).eq.0) then
c
          c_qc(ii)(5:9) = 'BNMMN'
          if(ob_q(ii).eq.amiss) c_qc(ii)(9:9) = 'M'
c
          n_zero_alt(ktype) = n_zero_alt(ktype) + 1
c
          l_print = .true.
          if(l_print) then
            write(io8,*)
            write(io8,*) 'Report found with zero altitude, winds'
          endif
c
c Perform checks on just temperature or wind direction
c ----------------------------------------------------
        else
c
c Check for -9C temperature, precision = 1.00, no phase indicated
c ---------------------------------------------------------------
c          if(abs(ob_t(ii)-264.16).lt.0.05.and.
          if(l_minus9c(ii)) then
c
c            write(io8,*)
c            write(io8,*) 'l_minus9c = T at iob,ii = ',iob,ii
c            write(io8,*) '  t_prcn = ',t_prcn(ii)
c            write(io8,*) '  itype  = ',c_insty_ob(itype(ii))
c            write(io8,*) '  ht_ft  = ',ht_ft(ii)
c            write(io8,*) '  ids = ',c_acftreg(ii),c_acftid(ii)
c
            if(ifix(t_prcn(ii)*100).eq.100.and.
     $         itype(ii).eq.i_mdcrs) then
c
              if(iob.eq.1) then
                iim1 = 0
              else
                iim1 = indx(iob-1)
              endif
c
              if(iob.eq.numreps) then
                iip1 = 0
              else
                iip1 = indx(iob+1)
              endif
c
c             Reject ob if -9C temperature exceeds gross check
c             ------------------------------------------------
              if(ht_ft(ii).gt.30187.5) then
c
                l_print = .true.
                if(l_print) then
                  write(io8,*)
                  write(io8,*)'-9C temp would be rejected by gross chk!'
     $,                       ' ii = ',ii
                endif
c
                if(c_qc(ii)(6:6).eq.'-') then
                  c_qc(ii)(6:6) = 'I'
                  n_minus9C(ktype) = n_minus9C(ktype) + 1
                endif
c
c             Perform other checks if previous ob available
c             ---------------------------------------------
              elseif(iim1.ne.0) then
c
c               Reject ob if previous ob is from same flight but does not 
c                 have -9C temperature, precision = 1.00, no phase indicated
c               ------------------------------------------------------------
                if(c_acftreg(ii)(1:8).eq.c_acftreg(iim1)(1:8).and.
     $             c_acftid(ii)(1:8).eq.c_acftid(iim1)(1:8).and.
c     $             abs(ob_t(iim1)-264.16).gt.0.05.and.
     $             (.not.l_minus9c(iim1)).and.
     $             ifix(t_prcn(iim1)*100).ne.100.and.
     $             itype(iim1).ne.i_mdcrs) then
c
                  l_print = .true.
                  if(l_print) then
                    write(io8,*)
                    write(io8,*) 'Isolated -9C temperature found!--iim1'
     $,                          ' ii = ',ii
                  endif
c
                  if(c_qc(ii)(6:6).eq.'-') then
                    c_qc(ii)(6:6) = 'I'
                    n_minus9C(ktype) = n_minus9C(ktype) + 1
                  endif
c
c               Check if previous ob has -9C temperature, precision = 1.00, no phase indicated
c               ------------------------------------------------------------------------------
                elseif(c_acftreg(ii)(1:8).eq.c_acftreg(iim1)(1:8).and.
     $                 c_acftid(ii)(1:8).eq.c_acftid(iim1)(1:8).and.
c     $                 abs(ob_t(iim1)-264.16).lt.0.05.and.
     $                 l_minus9c(iim1).and.
     $                 ifix(t_prcn(ii)*100).eq.100.and.
     $                 itype(ii).eq.i_mdcrs) then
c
c                 Check if following ob is available
c                 ----------------------------------
                  if(iip1.ne.0) then
c
c                   Check if following ob is from same flight
c                   -----------------------------------------
                    if(c_acftreg(ii)(1:8).eq.c_acftreg(iip1)(1:8).and.
     $                 c_acftid(ii)(1:8).eq.c_acftid(iip1)(1:8)) then
c
c                     Reject all three obs if following ob has -9C temperature,
c                     precision = 1.00, no phase indicated
c                     ---------------------------------------------------------
c                      if(abs(ob_t(iip1)-264.16).lt.0.05.and.
                      if(l_minus9c(iip1).and.
     $                   ifix(t_prcn(iip1)*100).eq.100.and.
     $                   itype(iip1).eq.i_mdcrs) then
c
                        l_print = .true.
                        if(l_print) then
                          write(io8,*)
                          write(io8,*)'Three -9C temps in a row'
     $,                               ' ii = ',ii
                        endif
c
                        if(c_qc(iim1)(6:6).eq.'-') then
                          c_qc(iim1)(6:6) = 'I'
                          n_minus9C(ktype) = n_minus9C(ktype) + 1
                        endif
c
                        if(c_qc(ii)(6:6).eq.'-') then
                          c_qc(ii)(6:6) = 'I'
                          n_minus9C(ktype) = n_minus9C(ktype) + 1
                        endif
c
                        if(c_qc(iip1)(6:6).eq.'-') then
                          c_qc(iip1)(6:6) = 'I'
                          n_minus9C(ktype) = n_minus9C(ktype) + 1
                        endif
c
                      endif
c
c                   Following ob is not from same flight--reject two obs
c                   ----------------------------------------------------
                    else
c
                      l_print = .true.
                      if(l_print) then
                        write(io8,*)
                        write(io8,*)'Two -9C temps in a row'
     $,                             ' ii = ',ii
                      endif
c
                      if(c_qc(iim1)(6:6).eq.'-') then
                        c_qc(iim1)(6:6) = 'I'
                        n_minus9C(ktype) = n_minus9C(ktype) + 1
                      endif
c
                      if(c_qc(ii)(6:6).eq.'-') then
                        c_qc(ii)(6:6) = 'I'
                        n_minus9C(ktype) = n_minus9C(ktype) + 1
                      endif
c
                    endif
                  endif
                endif
c
c             Check if following ob is available
c             ----------------------------------
              elseif(iip1.ne.0) then
c
c               Reject ob if following ob is from same flight but does not 
c                 have -9C temperature, precision = 1.00, no phase indicated
c               ------------------------------------------------------------
                if(c_acftreg(ii)(1:8).eq.c_acftreg(iip1)(1:8).and.
     $             c_acftid(ii)(1:8).eq.c_acftid(iip1)(1:8).and.
c     $             abs(ob_t(iip1)-264.16).gt.0.05.and.
     $             (.not.l_minus9c(iip1)).and.
     $             ifix(t_prcn(iip1)*100).ne.100.and.
     $             itype(iip1).ne.i_mdcrs) then
c
                  l_print = .true.
                  if(l_print) then
                    write(io8,*)
                    write(io8,*) 'Isolated -9C temperature found--iip1!'
     $,                          ' ii = ',ii
                  endif
c
                  if(c_qc(ii)(6:6).eq.'-') then
                    c_qc(ii)(6:6) = 'I'
                    n_minus9C(ktype) = n_minus9C(ktype) + 1
                  endif
c
                endif
              endif
            endif
          endif
c
c Check for erroneous 360 and 0 degree wind directions
c Exclude winds less than 5 kts?
c ----------------------------------------------------
          if((ifix(ob_dir(ii)).eq.360.or.
     $        ifix(ob_dir(ii)).eq.0).and.
     $       ifix(ob_spd(ii)*100.0).ne.0.and.
     $       ob_spd(ii).ne.amiss.and.
     $       itype(ii).ne.i_man_airep.and.
     $       itype(ii).ne.i_man_Yairep) then
c
c           Perform other checks if previous and following obs available
c           ------------------------------------------------------------
            if(iim1.ne.0.and.iip1.ne.0) then
c
c             Check if previous and following obs from same flight
c             ----------------------------------------------------
              if(c_acftreg(ii)(1:8).eq.c_acftreg(iim1)(1:8).and.
     $           c_acftid(ii)(1:8).eq.c_acftid(iim1)(1:8).and.
     $           c_acftreg(ii)(1:8).eq.c_acftreg(iip1)(1:8).and.
     $           c_acftid(ii)(1:8).eq.c_acftid(iip1)(1:8).and.
     $           ob_dir(iim1).ne.amiss.and.
     $           ob_spd(iim1).ne.amiss.and.
     $           ifix(ob_dir(iim1)).ne.360.and.
     $           ifix(ob_dir(iim1)).ne.0.and.
     $           ob_dir(iip1).ne.amiss.and.
     $           ob_spd(iip1).ne.amiss.and.
     $           ifix(ob_dir(iip1)).ne.360.and.
     $           ifix(ob_dir(iip1)).ne.0) then
c
c               Reject ob if neither neighbor has a northerly component
c               -------------------------------------------------------
                if(ifix(ob_dir(iim1)).lt.270.and.
     $             ifix(ob_dir(iim1)).gt.90.and.
     $             ifix(ob_dir(iip1)).lt.270.and.
     $             ifix(ob_dir(iip1)).gt.90) then
c
                  if(ob_spd(ii).lt.7.75.and.
     $               (ob_spd(iim1).lt.7.75.or.
     $                ob_spd(iip1).lt.7.75).and.
     $               abs(idt(ii)-idt(iim1)).gt.120.and.
     $               abs(idt(ii)-idt(iip1)).gt.120) then
c
c                   light and variable ok except for high time resolution flights
c
                  elseif(ob_spd(ii).lt.2.55.and.
     $                   (ob_spd(iim1).lt.2.55.or.
     $                    ob_spd(iip1).lt.2.55)) then
c
c                   light and variable ok for high time resolution flights
c
                  elseif(ob_spd(ii).lt.7.75.and.
     $                   ht_ft(ii).lt.10000.0.and.
     $                   (ht_ft(iim1)-ht_ft(ii)).gt.8000.0.and.
     $                   (ht_ft(iip1)-ht_ft(ii)).gt.8000.0) then
c
c                   large shear in low-res descent-ascent probably ok
c
                  else
c
                    c_qc(ii)(7:7) = 'B'
                    n_bad360(ktype) = n_bad360(ktype) + 1
c
                    l_print = .true.
                    if(l_print) then
                      write(io8,*)
                      write(io8,*) 'Bad north wind found-1-ii = ',ii
                    endif
                  endif
                endif
c
c             Check if three consecutive north winds are ok
c             ---------------------------------------------
              elseif(c_acftreg(ii)(1:8).eq.c_acftreg(iim1)(1:8).and.
     $               c_acftid(ii)(1:8).eq.c_acftid(iim1)(1:8).and.
     $               c_acftreg(ii)(1:8).eq.c_acftreg(iip1)(1:8).and.
     $               c_acftid(ii)(1:8).eq.c_acftid(iip1)(1:8).and.
     $               ob_dir(iim1).ne.amiss.and.
     $               ob_spd(iim1).ne.amiss.and.
     $               (ifix(ob_dir(iim1)).eq.360.or.
     $                ifix(ob_dir(iim1)).eq.0).and.
     $               ob_dir(iip1).ne.amiss.and.
     $               ob_spd(iip1).ne.amiss.and.
     $               (ifix(ob_dir(iip1)).eq.360.or.
     $                ifix(ob_dir(iip1)).eq.0).and.
     $               iim2.ne.0.and.
     $               iip2.ne.0) then
c
c               Reject ob if neither neighbor has a northerly component
c               -------------------------------------------------------
                if(ifix(ob_dir(iim2)).lt.270.and.
     $             ifix(ob_dir(iim2)).gt.90.and.
     $             ifix(ob_dir(iip2)).lt.270.and.
     $             ifix(ob_dir(iip2)).gt.90) then
c
                  if(ob_spd(ii).lt.7.75.and.
     $               ((ob_spd(iim2).lt.7.75.and.
     $                 ob_spd(iim1).lt.7.75).or.
     $                (ob_spd(iip1).lt.7.75.and.
     $                 ob_spd(iip2).lt.7.75)).and.
     $               abs(idt(ii)-idt(iim1)).gt.120.and.
     $               abs(idt(ii)-idt(iip1)).gt.120) then
c
c                   light and variable ok
c
                  elseif(ob_spd(ii).lt.2.55.and.
     $                   ((ob_spd(iim2).lt.2.55.and.
     $                     ob_spd(iim1).lt.2.55).or.
     $                    (ob_spd(iip1).lt.2.55.and.
     $                     ob_spd(iip2).lt.2.55))) then
c
c                   light and variable ok
c
                  else
c
                    c_qc(ii)(7:7) = 'B'
                    n_bad360(ktype) = n_bad360(ktype) + 1
c
                    l_print = .true.
                    if(l_print) then
                      write(io8,*)
                      write(io8,*) 'Bad north wind found-1-ii = ',ii
                    endif
                  endif
                endif
c
c             Check if previous ob from same flight
c             -------------------------------------
              elseif(c_acftreg(ii)(1:8).eq.c_acftreg(iim1)(1:8).and.
     $               c_acftid(ii)(1:8).eq.c_acftid(iim1)(1:8).and.
     $               ob_dir(iim1).ne.amiss.and.
     $               ob_spd(iim1).ne.amiss.and.
     $               ifix(ob_dir(iim1)).ne.360.and.
     $               ifix(ob_dir(iim1)).ne.0) then
c
c               Reject ob if neighbor does not have a northerly wind
c               ----------------------------------------------------
                if(ifix(ob_dir(iim1)).lt.270.and.
     $             ifix(ob_dir(iim1)).gt.90) then
c
                  if(ob_spd(ii).lt.7.75.and.
     $               ob_spd(iim1).lt.7.75.and.
     $               abs(idt(ii)-idt(iim1)).gt.120) then
c
c                   light and variable ok
c
                  elseif(ob_spd(ii).lt.2.55.and.
     $                   ob_spd(iim1).lt.2.55) then
c
c                   light and variable ok
c
                  elseif(ob_spd(ii).lt.7.75.and.
     $                   ht_ft(ii).lt.10000.0.and.
     $                   (ht_ft(iim1)-ht_ft(ii)).gt.8000.0) then
c
c                   large shear in low-res descent probably ok
c
                  else
c
                    c_qc(ii)(7:7) = 'B'
                    n_bad360(ktype) = n_bad360(ktype) + 1
c
                    l_print = .true.
                    if(l_print) then
                      write(io8,*)
                      write(io8,*) 'Bad north wind found-2-ii = ',ii
                    endif
                  endif
                endif
c
c             Check if following ob from same flight
c             --------------------------------------
              elseif(c_acftreg(ii)(1:8).eq.c_acftreg(iip1)(1:8).and.
     $               c_acftid(ii)(1:8).eq.c_acftid(iip1)(1:8).and.
     $               ob_dir(iip1).ne.amiss.and.
     $               ob_spd(iip1).ne.amiss.and.
     $               ifix(ob_dir(iip1)).ne.360.and.
     $               ifix(ob_dir(iip1)).ne.0) then
c
c               Reject ob if neighbor does not have a northerly wind
c               ----------------------------------------------------
                if(ifix(ob_dir(iip1)).lt.270.and.
     $             ifix(ob_dir(iip1)).gt.90) then
c
                  if(ob_spd(ii).lt.7.75.and.
     $               ob_spd(iip1).lt.7.75.and.
     $               abs(idt(ii)-idt(iip1)).gt.120) then
c
c                   light and variable ok
c
                  elseif(ob_spd(ii).lt.2.55.and.
     $                   ob_spd(iip1).lt.2.55) then
c
c                   light and variable ok
c
                  elseif(ob_spd(ii).lt.7.75.and.
     $                   ht_ft(ii).lt.10000.0.and.
     $                   (ht_ft(iip1)-ht_ft(ii)).gt.8000.0) then
c
c                   large shear in low-res ascent probably ok
c
                  else
c
                    c_qc(ii)(7:7) = 'B'
                    n_bad360(ktype) = n_bad360(ktype) + 1
c
                    l_print = .true.
                    if(l_print) then
                      write(io8,*)
                      write(io8,*) 'Bad north wind found-3-ii = ',ii
                    endif
                  endif
                endif
c
c             If neither ob is valid or from same flight, reject ob
c             -----------------------------------------------------
              else
c
                c_qc(ii)(7:7) = 'B'
                n_bad360(ktype) = n_bad360(ktype) + 1
c
                l_print = .true.
                if(l_print) then
                  write(io8,*)
                  write(io8,*) 'Bad north wind found-4-ii = ',ii
                endif
              endif
c
c           If first or last ob, reject ob
c           ------------------------------
            else
c
              c_qc(ii)(7:7) = 'B'
              n_bad360(ktype) = n_bad360(ktype) + 1
c
              l_print = .true.
              if(l_print) then
                write(io8,*)
                write(io8,*) 'Bad north wind found-5-ii = ',ii
              endif
            endif
c
c Check for erroneous 180 deg wind directions
c -------------------------------------------
          elseif(ifix(ob_dir(ii)).eq.180.and.
     $           itype(ii).ne.i_man_airep.and.
     $           itype(ii).ne.i_man_Yairep) then
c
c           Perform other checks if previous and following obs available
c           ------------------------------------------------------------
            if(iim1.ne.0.and.iip1.ne.0) then
c
c             Check if previous and following obs from same flight
c             ----------------------------------------------------
              if(c_acftreg(ii)(1:8).eq.c_acftreg(iim1)(1:8).and.
     $           c_acftid(ii)(1:8).eq.c_acftid(iim1)(1:8).and.
     $           c_acftreg(ii)(1:8).eq.c_acftreg(iip1)(1:8).and.
     $           c_acftid(ii)(1:8).eq.c_acftid(iip1)(1:8).and.
     $           ob_dir(iim1).ne.amiss.and.
     $           ifix(ob_dir(iim1)).ne.0.and.
     $           ob_dir(iip1).ne.amiss.and.
     $           ifix(ob_dir(iip1)).ne.0) then
c
c               Reject ob if neither neighbor has a southerly component
c               -------------------------------------------------------
                if((ifix(ob_dir(iim1)).lt.90.or.
     $              ifix(ob_dir(iim1)).gt.270).and.
     $             (ifix(ob_dir(iip1)).lt.90.or.
     $              ifix(ob_dir(iip1)).gt.270)) then
c
                  if(ob_spd(ii).lt.7.75.and.
     $               (ob_spd(iim1).lt.7.75.or.
     $                ob_spd(iip1).lt.7.75).and.
     $               abs(idt(ii)-idt(iim1)).gt.120.and.
     $               abs(idt(ii)-idt(iip1)).gt.120) then
c
c                   light and variable ok
c
                  elseif(ob_spd(ii).lt.2.55.and.
     $                   (ob_spd(iim1).lt.2.55.or.
     $                    ob_spd(iip1).lt.2.55)) then
c
c                   light and variable ok
c
                  elseif(ob_spd(ii).lt.7.75.and.
     $                   ht_ft(ii).lt.10000.0.and.
     $                   (ht_ft(iim1)-ht_ft(ii)).gt.8000.0.and.
     $                   (ht_ft(iip1)-ht_ft(ii)).gt.8000.0) then
c
c                   large shear in low-res descent-ascent probably ok
c
                  else
c
                    c_qc(ii)(7:7) = 'B'
                    n_bad180(ktype) = n_bad180(ktype) + 1
c
                    l_print = .true.
                    if(l_print) then
                      write(io8,*)
                      write(io8,*) 'Bad south wind found-1-ii = ',ii
                      write(io8,*) 'dirs = ',ob_dir(iim1),ob_dir(ii)
     $,                             ob_dir(iip1)
                    endif
                  endif
                endif
c
c             Check if previous ob from same flight
c             -------------------------------------
              elseif(c_acftreg(ii)(1:8).eq.c_acftreg(iim1)(1:8).and.
     $               c_acftid(ii)(1:8).eq.c_acftid(iim1)(1:8).and.
     $               ob_dir(iim1).ne.amiss.and.
     $               ifix(ob_dir(iim1)).ne.0) then
c
c               Reject ob if neighbor does not have a southerly wind
c               ----------------------------------------------------
                if(ifix(ob_dir(iim1)).lt.90.or.
     $             ifix(ob_dir(iim1)).gt.270) then
c
                  if(ob_spd(ii).lt.7.75.and.
     $               ob_spd(iim1).lt.7.75.and.
     $               abs(idt(ii)-idt(iim1)).gt.120) then
c
c                   light and variable ok
c
                  elseif(ob_spd(ii).lt.2.55.and.
     $                   ob_spd(iim1).lt.2.55) then
c
c                   light and variable ok
c
                  elseif(ob_spd(ii).lt.7.75.and.
     $                   ht_ft(ii).lt.10000.0.and.
     $                   (ht_ft(iim1)-ht_ft(ii)).gt.8000.0) then
c
c                   large shear in low-res descent probably ok
c
                  else
c
                    c_qc(ii)(7:7) = 'B'
                    n_bad180(ktype) = n_bad180(ktype) + 1
c
                    l_print = .true.
                    if(l_print) then
                      write(io8,*)
                      write(io8,*) 'Bad south wind found-2-ii = ',ii
                    endif
                  endif
                endif
c
c             Check if following ob from same flight
c             --------------------------------------
              elseif(c_acftreg(ii)(1:8).eq.c_acftreg(iip1)(1:8).and.
     $               c_acftid(ii)(1:8).eq.c_acftid(iip1)(1:8).and.
     $               ob_dir(iip1).ne.amiss.and.
     $               ifix(ob_dir(iip1)).ne.0) then
c
c               Reject ob if neighbor does not have a southerly wind
c               ----------------------------------------------------
                if(ifix(ob_dir(iip1)).lt.90.or.
     $             ifix(ob_dir(iip1)).gt.270) then
c
                  if(ob_spd(ii).lt.7.75.and.
     $               ob_spd(iip1).lt.7.75.and.
     $               abs(idt(ii)-idt(iim1)).gt.120) then
c
c                   light and variable ok
c
                  elseif(ob_spd(ii).lt.2.55.and.
     $                   ob_spd(iip1).lt.2.55) then
c
c                   light and variable ok
c
                  elseif(ob_spd(ii).lt.7.75.and.
     $                   ht_ft(ii).lt.10000.0.and.
     $                   (ht_ft(iip1)-ht_ft(ii)).gt.8000.0) then
c
c                   large shear in low-res ascent probably ok
c
                  else
c
                    c_qc(ii)(7:7) = 'B'
                    n_bad180(ktype) = n_bad180(ktype) + 1
c
                    l_print = .true.
                    if(l_print) then
                      write(io8,*)
                      write(io8,*) 'Bad south wind found-3-ii = ',ii
                    endif
                  endif
                endif
c
c             If neither ob is valid or from same flight, reject ob
c             -----------------------------------------------------
              else
c
                c_qc(ii)(7:7) = 'B'
                n_bad180(ktype) = n_bad180(ktype) + 1
c
                l_print = .true.
                if(l_print) then
                  write(io8,*)
                  write(io8,*) 'Bad south wind found-4-ii = ',ii
                endif
              endif
c
c           If first or last ob, reject ob
c           ------------------------------
            else
c
              c_qc(ii)(7:7) = 'B'
              n_bad180(ktype) = n_bad180(ktype) + 1
c
              l_print = .true.
              if(l_print) then
                write(io8,*)
                write(io8,*) 'Bad south wind found-5-ii = ',ii
              endif
            endif
          endif
c
        endif
c
c Print selected rejected reports
c -------------------------------
        if(l_print) then
c
c          if(iob.gt.1) then
c            iim1 = indx(iob-1)
c          else
c            iim1 = indx(1)
c          endif
c          if(iob.lt.numreps) then
c            iip1 = indx(iob+1)
c          else
c            iip1 = indx(numreps)
c          endif
c
          if(iim1.eq.0) iim1 = ii
          if(iip1.eq.0) iip1 = ii
c
          write(io8,8002) iim1,c_insty_ob(itype(iim1))
     x,        c_acftreg(iim1),c_acftid(iim1)
     x,        idt(iim1),alat(iim1),alon(iim1)
     x,        pres(iim1),ht_ft(iim1)
     x,        t_prcn(iim1),ob_t(iim1),xiv_t(iim1),ichk_t(iim1)
     x,        ob_q(iim1),xiv_q(iim1),ichk_q(iim1)
     x,        ob_dir(iim1),xiv_d(iim1),ichk_d(iim1)
     x,        ob_spd(iim1),xiv_s(iim1),ichk_s(iim1)
     x,        c_qc(iim1)
          write(io8,8002) ii,c_insty_ob(itype(ii))
     x,        c_acftreg(ii),c_acftid(ii)
     x,        idt(ii),alat(ii),alon(ii)
     x,        pres(ii),ht_ft(ii)
     x,        t_prcn(ii),ob_t(ii),xiv_t(ii),ichk_t(ii)
     x,        ob_q(ii),xiv_q(ii),ichk_q(ii)
     x,        ob_dir(ii),xiv_d(ii),ichk_d(ii)
     x,        ob_spd(ii),xiv_s(ii),ichk_s(ii)
     x,        c_qc(ii)
          write(io8,8002) iip1,c_insty_ob(itype(iip1))
     x,        c_acftreg(iip1),c_acftid(iip1)
     x,        idt(iip1),alat(iip1),alon(iip1)
     x,        pres(iip1),ht_ft(iip1)
     x,        t_prcn(iip1),ob_t(iip1),xiv_t(iip1),ichk_t(iip1)
     x,        ob_q(iip1),xiv_q(iip1),ichk_q(iip1)
     x,        ob_dir(iip1),xiv_d(iip1),ichk_d(iip1)
     x,        ob_spd(iip1),xiv_s(iip1),ichk_s(iip1)
     x,        c_qc(iip1)
 8002     format(i6,1x,a8,1x,a8,1x,a9,1x,i7,1x,2f11.5,1x
     x,        f8.1,1x,f7.0,1x,f5.2,4(2(1x,f8.2),1x,i5),1x
     x,        '!',a11,'!')
        endif
c
c     End loop over reports
c     ---------------------
      enddo
c
c Write out bad reports
c ---------------------
      if(.not.l_operational) then
        write(io32,*)
        write(io32,*) 'Invalid reports'
        write(io32,*) '---------------'
        write(io32,3001)
 3001   format(' index  type    tail num   flight     time       lat'
     x,        '        lon       pres  height '
     x,        't-prcn   temp     innov  ichk'
     x,        ' spec hum    innov  ichk'
     x,        '   ob_dir    innov  ichk'
     x,        '   ob_spd    innov  ichk'
     x,        '   qc flag')
      endif
c
      kbad = 0
c
c     Loop over reports
c     -----------------
      do iob = 1,numreps
        ii = indx(iob)
c
c       Count number of reports considered
c       ----------------------------------
        if(itype(ii).eq.i_acars.or.
     $     itype(ii).eq.i_acars_asc.or.
     $     itype(ii).eq.i_acars_lvl.or.
     $     itype(ii).eq.i_acars_des) then
          nrep_Ac = nrep_Ac + 1
        elseif(itype(ii).eq.i_mdcrs.or.
     $         itype(ii).eq.i_mdcrs_asc.or.
     $         itype(ii).eq.i_mdcrs_lvl.or.
     $         itype(ii).eq.i_mdcrs_des) then
          nrep_Md = nrep_Md + 1
        elseif(itype(ii).eq.i_man_airep.or.
     $         itype(ii).eq.i_man_Yairep) then
          nrep_Ma = nrep_Ma + 1
        elseif(itype(ii).eq.i_airep.or.
     $         itype(ii).eq.i_airep_asc.or.
     $         itype(ii).eq.i_airep_lvl.or.
     $         itype(ii).eq.i_airep_des) then
          nrep_Ar = nrep_Ar + 1
        elseif(itype(ii).eq.i_amdar.or.
     $         itype(ii).eq.i_amdar_asc.or.
     $         itype(ii).eq.i_amdar_lvl.or.
     $         itype(ii).eq.i_amdar_des) then
          nrep_Am = nrep_Am + 1
        else
          write(io8,*)
          write(io8,*) 'Bad itype: ',itype(ii),' for ii = ',ii
        endif
c
c       Count number of reports rejected as invalid
c       -------------------------------------------
        if(c_qc(ii)(1:1).eq.'B'.or.
     $     c_qc(ii)(5:5).eq.'B'.or.
     $     c_qc(ii)(2:2).eq.'M'.or.
     $     c_qc(ii)(3:3).eq.'M'.or.
     $     c_qc(ii)(4:4).eq.'M'.or.
     $     c_qc(ii)(5:5).eq.'M'.or.
     $     c_qc(ii)(6:8).eq.'MMM'.or.
     $     c_qc(ii)(3:4).eq.'BB') then
c
          if(itype(ii).eq.i_mdcrs.or.
     $       itype(ii).eq.i_mdcrs_asc.or.
     $       itype(ii).eq.i_mdcrs_lvl.or.
     $       itype(ii).eq.i_mdcrs_des) then
            nbad_Md = nbad_Md + 1
            ktype = 1
c
          elseif(itype(ii).eq.i_acars.or.
     $           itype(ii).eq.i_acars_asc.or.
     $           itype(ii).eq.i_acars_lvl.or.
     $           itype(ii).eq.i_acars_des) then
            nbad_Ac = nbad_Ac + 1
            ktype = 2
c
          elseif(itype(ii).eq.i_amdar.or.
     $           itype(ii).eq.i_amdar_asc.or.
     $           itype(ii).eq.i_amdar_lvl.or.
     $           itype(ii).eq.i_amdar_des) then
            nbad_Am = nbad_Am + 1
            ktype = 3
c
          elseif(itype(ii).eq.i_airep.or.
     $           itype(ii).eq.i_airep_asc.or.
     $           itype(ii).eq.i_airep_lvl.or.
     $           itype(ii).eq.i_airep_des) then
            nbad_Ar = nbad_Ar + 1
            ktype = 4
c
          elseif(itype(ii).eq.i_man_airep.or.
     $           itype(ii).eq.i_man_Yairep) then
            nbad_Ma = nbad_Ma + 1
            ktype = 5
c
          else
            write(io8,*)
            write(io8,*) 'Bad itype: ',itype(ii),' for ii = ',ii
          endif
c
c         Flag bad report for reorder subroutine and output rejects
c         ---------------------------------------------------------
          csort(ii)(1:5) = 'badob'
c
          kbad(ktype) = kbad(ktype) + 1
c
          if(.not.l_operational) then
            write(io32,3002) ii,c_insty_ob(itype(ii))
     x,        c_acftreg(ii),c_acftid(ii)
     x,        idt(ii),alat(ii),alon(ii)
     x,        pres(ii),ht_ft(ii)
     x,        t_prcn(ii),ob_t(ii),xiv_t(ii),ichk_t(ii)
     x,        ob_q(ii),xiv_q(ii),ichk_q(ii)
     x,        ob_dir(ii),xiv_d(ii),ichk_d(ii)
     x,        ob_spd(ii),xiv_s(ii),ichk_s(ii)
     x,        c_qc(ii)
 3002       format(i6,1x,a8,1x,a8,1x,a9,1x,i7,1x,2f11.5,1x,f8.1,1x,f7.0
     x,          1x,f5.2,4(2(1x,f8.2),1x,i5),1x,'!',a11,'!')
          endif
        endif
      enddo
c
c     Loop over reports
c     -----------------
      if(.not.l_operational) then
        write(io32,*)
        write(io32,*) 'Invalid temperatures (-9C)'
        write(io32,*) '--------------------------'
        write(io32,3001)
c
        do iob = 1,numreps
          ii = indx(iob)
c
c         Count number of reports rejected as invalid
c         -------------------------------------------
          if(c_qc(ii)(6:6).eq.'I') then
c
c           Output rejected temperatures
c           ----------------------------
            write(io32,3002) ii,c_insty_ob(itype(ii))
     x,        c_acftreg(ii),c_acftid(ii)
     x,        idt(ii),alat(ii),alon(ii)
     x,        pres(ii),ht_ft(ii)
     x,        t_prcn(ii),ob_t(ii),xiv_t(ii),ichk_t(ii)
     x,        ob_q(ii),xiv_q(ii),ichk_q(ii)
     x,        ob_dir(ii),xiv_d(ii),ichk_d(ii)
     x,        ob_spd(ii),xiv_s(ii),ichk_s(ii)
     x,        c_qc(ii)
c
c           Count number of rejected temps by tail number
c           ---------------------------------------------
            mm = 1
            do while(mm.le.kreg)
              if(c_acftreg(ii).eq.creg_reg(mm)) then 
c
                if(ktype.gt.0.and.ktype.le.5) then
                  ntemp_reg(mm,ktype) = ntemp_reg(mm,ktype) + 1
                endif
                mm = kreg + 1
              endif
              mm = mm + 1
            enddo
          endif
        enddo
      endif
c
c     Output statistics
c     -----------------
      if(.not.l_operational) then
        write(io32,*)
        write(io32,*)'  Number of invalid MDCRS    reps rejected = '
     $,                   kbad(1)
ccccdak        write(io32,*)'  Number of invalid ACARS    reps rejected = '
        write(io32,*)'  Number of invalid TAMDAR   reps rejected = '
     $,                   kbad(2)
        write(io32,*)'  Number of invalid AMDAR    reps rejected = '
     $,                   kbad(3)
        write(io32,*)'  Number of invalid AIREP    reps rejected = '
     $,                   kbad(4)
        write(io32,*)'  Number of invalid manAIREP reps rejected = '
     $,                   kbad(5)
      endif
c
      write(io8,*)
      write(io8,*) '  Invalid reports--rejected'
      write(io8,*) '  -------------------------'
      write(io8,*)'  Number of invalid MDCRS    reps rejected = '
     $,                   kbad(1)
ccccdak      write(io8,*)'  Number of invalid ACARS    reps rejected = '
      write(io8,*)'  Number of invalid TAMDAR   reps rejected = '
     $,                   kbad(2)
      write(io8,*)'  Number of invalid AMDAR    reps rejected = '
     $,                   kbad(3)
      write(io8,*)'  Number of invalid AIREP    reps rejected = '
     $,                   kbad(4)
      write(io8,*)'  Number of invalid manAIREP reps rejected = '
     $,                   kbad(5)
c
c     Output detailed stats
c     ---------------------
      write(*,*)
      write(*,*) 'Invalid check data counts--',cdtg_an
      write(*,*) '-------------------------------------'
      write(*,'(1x,a55)')
ccccdak     $ 'Type of check     MDCRS   ACARS   AMDAR   AIREP     man'
     $ 'Type of check     MDCRS  TAMDAR   AMDAR   AIREP     man'
      write(*,'(1x,a55)')
     $ '--------------- ------- ------- ------- ------- -------'
      write(*,'('' Num considered '',5(1x,i7))')
     $     nrep_Md,nrep_Ac,nrep_Am,nrep_Ar,nrep_Ma
      write(*,'('' Total invalid  '',5(1x,i7))')
     $     nbad_Md,nbad_Ac,nbad_Am,nbad_Ar,nbad_Ma
      write(*,'(1x,a55)')
     $ '--------------- ------- ------- ------- ------- -------'
c
      write(io8,*)
      write(io8,*) 'Invalid check data counts'
      write(io8,*) '-------------------------'
      write(io8,'(1x,a55)')
ccccdak     $ 'Type of check     MDCRS   ACARS   AMDAR   AIREP     man'
     $ 'Type of check     MDCRS  TAMDAR   AMDAR   AIREP     man'
      write(io8,'(1x,a55)')
     $ '--------------- ------- ------- ------- ------- -------'
      write(io8,'(''Num considered '',5(1x,i7))')
     $     nrep_Md,nrep_Ac,nrep_Am,nrep_Ar,nrep_Ma
      write(io8,'(''Total invalid  '',5(1x,i7))')
     $     nbad_Md,nbad_Ac,nbad_Am,nbad_Ar,nbad_Ma
      write(io8,'(1x,a55)')
     $ '--------------- ------- ------- ------- ------- -------'
      write(io8,'(''Empty reports  '',5(1x,i7))')
     $     n_empty(1),n_empty(2),n_empty(3),n_empty(4),n_empty(5)
      write(io8,'(''Zero tmp/winds '',5(1x,i7))') n_zero_tmp(1)
     $,    n_zero_tmp(2),n_zero_tmp(3),n_zero_tmp(4),n_zero_tmp(5)
      write(io8,'(''Zero alt/winds '',5(1x,i7))') n_zero_alt(1)
     $,    n_zero_alt(2),n_zero_alt(3),n_zero_alt(4),n_zero_alt(5)
      write(io8,'(''Zero lat/lon   '',5(1x,i7))') n_zero_pos(1)
     $,    n_zero_pos(2),n_zero_pos(3),n_zero_pos(4),n_zero_pos(5)
      write(io8,'(''Missing ids    '',24x,2(1x,i7),8x)')
     $     n_xx999_Ar,n_xx999_Ma
      write(io8,'(''Blank ids      '',1x,i7,8x,3(1x,i7))')
     $     n_blank_Md,n_blank_Am,n_blank_Ar,n_blank_Ma
      write(io8,'(''Bad decode     '',5(1x,i7))')
     $     n_bad_decode(1),n_bad_decode(2),n_bad_decode(3)
     $,    n_bad_decode(4),n_bad_decode(5)
      write(io8,'(''Missing time   '',5(1x,i7))')
     $     n_miss_time(1),n_miss_time(2),n_miss_time(3)
     $,    n_miss_time(4),n_miss_time(5)
      write(io8,'(''Missing pos    '',5(1x,i7))')
     $     n_miss_pos(1),n_miss_pos(2),n_miss_pos(3)
     $,    n_miss_pos(4),n_miss_pos(5)
      write(io8,'(''Missing pres   '',5(1x,i7))')
     $     n_miss_pres(1),n_miss_pres(2),n_miss_pres(3)
     $,    n_miss_pres(4),n_miss_pres(5)
      write(io8,'(''Small pres     '',5(1x,i7))')
     $     n_small_pres(1),n_small_pres(2),n_small_pres(3)
     $,    n_small_pres(4),n_small_pres(5)
      write(io8,'(''Low AIREPs     '',5(1x,i7))')
     $     n_low_airep(1),n_low_airep(2),n_low_airep(3)
     $,    n_low_airep(4),n_low_airep(5)
      write(io8,'(1x,a55)')
     $ '--------------- ------- ------- ------- ------- -------'
      write(io8,'(''-9C temps      '',5(1x,i7))')
     $     n_minus9C(1),n_minus9C(2),n_minus9C(3)
     $,    n_minus9C(4),n_minus9C(5)
      write(io8,'(1x,a55)')
     $ '--------------- ------- ------- ------- ------- -------'
      write(io8,'(''Bad north wind '',5(1x,i7))')
     $     n_bad360(1),n_bad360(2),n_bad360(3)
     $,    n_bad360(4),n_bad360(5)
      write(io8,'(''Bad south wind '',5(1x,i7))')
     $     n_bad180(1),n_bad180(2),n_bad180(3)
     $,    n_bad180(4),n_bad180(5)
      write(io8,'(1x,a55)')
     $ '--------------- ------- ------- ------- ------- -------'
c
      kbadtot = kbad(1) + kbad(2) + kbad(3)
     $        + kbad(4) + kbad(5) 
c
      write(io8,*)
      write(io8,*) numreps,' good reports processed'
      write(io8,*) kbadtot,' reports failed qc in invalid check'
c
      return
      end
c
c ###################################################################
c                            subroutine stk_val_qc
c ###################################################################
c   
      subroutine stk_val_qc(numreps,max_reps,indx,csort,amiss,cdtg_an
     $,          c_acftreg,c_acftid,c_qc
     $,          alat,alon,pres,ht_ft,t_prcn,ob_t,ob_q,ob_dir,ob_spd
     $,          xiv_t,xiv_q,xiv_d,xiv_s
     $,          idt,itype,ichk_t,ichk_q,ichk_d,ichk_s
     $,          kflight,maxflt,nobs_flt,iobs_flt
     $,          kreg,creg_reg,nwhol_reg,ntemp_reg,nwind_reg
     $,          kbadtot,io8,io33,l_operational,l_init,l_ncep)
c
c     Check for flights with stuck values
c     (defined as a flight with three or more reports where all reports have the 
c     same time, lat, lon, pres, ob_t, ob_dir, or ob_spd)
c
      implicit none
c
c Declaration statements
c ----------------------
      integer      max_reps            ! maximum number of reports
c
      character*11 c_qc(max_reps)      ! internal qc flags
c
c     Data arrays
c     -----------
      integer      numreps             ! actual number of reports
      character*10 cdtg_an             ! date time group for analysis
      integer      itype(max_reps)     ! type of aircraft data
      integer      idt(max_reps)       ! time in seconds to analysis time 
      character*8  c_acftreg(max_reps) ! aircraft registration (tail) number
      character*9  c_acftid(max_reps)  ! aircraft flight number
      real*8       alat(max_reps)      ! latitude
     $,            alon(max_reps)      ! longitude
      real         pres(max_reps)      ! pressure
     $,            ht_ft(max_reps)     ! height in feet
      real         t_prcn(max_reps)    ! temperature precision
      real         ob_t(max_reps)      ! temperature
     $,            ob_q(max_reps)      ! specific humidity
     $,            ob_dir(max_reps)    ! wind direction
     $,            ob_spd(max_reps)    ! wind speed
      real         xiv_t(max_reps)     ! temperature innovation (ob - bk)
     $,            xiv_q(max_reps)     ! specific humidity innovation (ob - bk)
     $,            xiv_d(max_reps)     ! wind direction innovation (ob - bk)
     $,            xiv_s(max_reps)     ! wind speed innovation (ob - bk)
      integer      ichk_t(max_reps)    ! NRL QC flag for temperature ob
     $,            ichk_q(max_reps)    ! NRL QC flag for specific humidity ob
     $,            ichk_d(max_reps)    ! NRL QC flag for wind direction ob
     $,            ichk_s(max_reps)    ! NRL QC flag for wind speed ob
      character*25 csort(max_reps)     ! sort variable    
c
c     Pointers
c     --------
      integer      indx(max_reps)      ! pointer index for good reports
c
c     Functions
c     ---------
      character*16 c_insty_ob          ! function to convert integer instrument 
                                       !   type to character instrument type
      integer      insty_ob_fun        ! function to convert character
                                       !   instrument type to integer
c
c     Flight statistics
c     -----------------
      integer      maxflt              ! max number of flights allowed
      integer      nobs_flt(maxflt)    ! number of reports per flight
     $,            iobs_flt(maxflt)    ! index for first report in each flight
     $,            kflight             ! number of flights in dataset
      integer      istart              ! index for 1st rep in current flight 
     $,            iistart             ! index from pointer array for istart
     $,            iend                ! index for last rep in current flight
     $,            iiend               ! index from pointer array for iend
c
c     Tail number statistics
c     ----------------------
      integer      kreg                ! actual number of tail#s in dataset
     $,            mreg                ! index pointing to current tail number
      character*8  creg_reg(maxflt)    ! tail numbers
      integer      nwhol_reg(maxflt,5) ! number of reports w. temp in whole deg
      integer      ntemp_reg(maxflt,5) ! number of reports w. rejected temp
      integer      nwind_reg(maxflt,5) ! number of reports w. rejected winds
c
c     Counters
c     --------
      integer      nstk_time(5)        ! number of reports with stuck time
     $,            nstk_both(5)        ! number of reports with both stuck time and position
     $,            nstk_posn(5)        ! number of reports with stuck position
     $,            nstk_alat(5)        ! number of reports with stuck latitude
     $,            nstk_alon(5)        ! number of reports with stuck longitude
     $,            nstk_pres(5)        ! number of reports with stuck pressure
     $,            nstk_val(5)         ! number of reports with stuck temp and winds
     $,            nstk_temp(5)        ! number of reports with stuck temperature
     $,            nstk_wdir(5)        ! number of reports with stuck direction
     $,            nstk_wspd(5)        ! number of reports with stuck speed
     $,            nstk_moist(5)       ! number of reports with stuck moisture
     $,            nstk_whol(5)        ! number of reports w. temp in whole deg
      integer      kbad(5)             ! counter for number of bad reports
     $,            kbadt(5)            ! counter for number of bad temperatures
     $,            kbadw(5)            ! counter for number of bad winds
     $,            kbadtot             ! counter for total number of bad reports
ccccdak      integer      nrep_Ac             ! number of acars reports considered
      integer      nrep_Ac             ! number of tamdar reports considered
     $,            nrep_Md             ! number of mdcrs reports considered
     $,            nrep_Ma             ! number of manual airep reports considered
     $,            nrep_Ar             ! number of airep reports considered
     $,            nrep_Am             ! number of amdar reports considered
ccccdak      integer      nstk_Ac             ! number of acars reports rejected
      integer      nstk_Ac             ! number of tamdar reports rejected
     $,            nstk_Md             ! number of mdcrs reports rejected
     $,            nstk_Ma             ! number of manual airep reports rejected
     $,            nstk_Ar             ! number of airep reports rejected
     $,            nstk_Am             ! number of amdar reports rejected
c
c     Instrument types
c     ----------------
ccccdak      integer      i_acars             ! instrument type for acars
      integer      i_acars             ! instrument type for tamdar
ccccdak     $,            i_acars_lvl         ! instrument type for acars--level flt
     $,            i_acars_lvl         ! instrument type for tamdar--level flt
ccccdak     $,            i_acars_asc         ! instrument type for acars--ascent
     $,            i_acars_asc         ! instrument type for tamdar--ascent
ccccdak     $,            i_acars_des         ! instrument type for acars--descent
     $,            i_acars_des         ! instrument type for tamdar--descent
     $,            i_mdcrs             ! instrument type for mdcrs
     $,            i_mdcrs_lvl         ! instrument type for mdcrs--level flt
     $,            i_mdcrs_asc         ! instrument type for mdcrs--ascent
     $,            i_mdcrs_des         ! instrument type for mdcrs--descent
     $,            i_man_airep         ! instrument type for manual aireps
     $,            i_man_Yairep        ! instrument type for manual aireps (YRXX)
     $,            i_airep             ! instrument type for airep
     $,            i_airep_lvl         ! instrument type for airep--level flt
     $,            i_airep_asc         ! instrument type for airep--ascent
     $,            i_airep_des         ! instrument type for airep--descent
     $,            i_amdar             ! instrument type for amdar
     $,            i_amdar_lvl         ! instrument type for amdar--level flt
     $,            i_amdar_asc         ! instrument type for amdar--ascent
     $,            i_amdar_des         ! instrument type for amdar--descent
c
c     Other variables
c     ---------------
      integer      io8                 ! i/o unit number for log file
      integer      io33                ! i/o unit number for stuck check
c
      real         amiss               ! real missing value flag
c
      integer      iob,kk,mm           ! do loop indices 
     $,            ii,jj               ! index pointing to current report
     $,            iim1                ! index pointing to previous report
     $,            iobfirst            ! index for first stuck time
     $,            ioblast             ! index for last stuck time
     $,            iifirst             ! index for first stuck latitude
     $,            iilast              ! index for last stuck latitude
c
ccccdak      integer      k_ACARS             ! number of ACARS/MDCRS reports
      integer      k_ACARS             ! number of TAMDAR/MDCRS reports
     $,            k_AIREP             ! number of AIREP reports
     $,            k_manAIREP          ! number of manual AIREP reports
     $,            k_AMDAR             ! number of AMDAR reports
     $,            k_stuck             ! counter for number of stuck reports
     $,            ktype               ! ob type
c
      integer      istk_time           ! value of stuck clock
      real*8       alat_min            ! min value of latitude during flight
     $,            alat_max            ! max value of latitude during flight
     $,            alon_min            ! min value of longitude during flight
     $,            alon_max            ! max value of longitude during flight
     $,            stk_alat            ! value of stuck latitude
     $,            stk_alon            ! value of stuck longitude
      real         ht_max              ! max height during flight
     $,            ht_min              ! min height during flight
     $,            ht_max_stuck        ! max height during stuck portion
     $,            ht_min_stuck        ! min height during stuck portion
     $,            temp_min            ! min temperature during flight
     $,            temp_max            ! max tempetature during flight
     $,            ob_min              ! min value of parameter during flight
     $,            ob_max              ! max value of parameter during flight
     $,            stk_pres            ! value of stuck pressure
     $,            stk_alt             ! value of stuck altitude
     $,            stk_temp            ! value of stuck temperature
     $,            stk_wdir            ! value of stuck direction
     $,            stk_wspd            ! value of stuck speed
     $,            stk_moist           ! value of stuck moisture
c
c     Switches
c     --------
      logical      stuck               ! true if variable found to be stuck
c
      logical      l_init              ! initialize counters if true
     $,            l_operational       ! run QC in operational mode if true
     $,            l_ncep              ! run QC w/ NCEP preferences if true
c
c # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # #
c
c Initialize aircraft data types
c ------------------------------
      i_acars      = insty_ob_fun('acars')
      i_acars_lvl  = insty_ob_fun('acars_lvl') 
      i_acars_asc  = insty_ob_fun('acars_asc') 
      i_acars_des  = insty_ob_fun('acars_des') 
      i_mdcrs      = insty_ob_fun('mdcrs')
      i_mdcrs_lvl  = insty_ob_fun('mdcrs_lvl') 
      i_mdcrs_asc  = insty_ob_fun('mdcrs_asc') 
      i_mdcrs_des  = insty_ob_fun('mdcrs_des')
      i_man_airep  = insty_ob_fun('man-airep') 
      i_man_Yairep = insty_ob_fun('man-Yairep') 
      i_airep      = insty_ob_fun('airep')
      i_airep_lvl  = insty_ob_fun('airep_lvl')
      i_airep_asc  = insty_ob_fun('airep_asc')
      i_airep_des  = insty_ob_fun('airep_des')
      i_amdar      = insty_ob_fun('amdar')
      i_amdar_lvl  = insty_ob_fun('amdar_lvl')
      i_amdar_asc  = insty_ob_fun('amdar_asc')
      i_amdar_des  = insty_ob_fun('amdar_des')
c
c Initialize counters
c -------------------
      if(l_init) then
        nstk_time = 0
        nstk_both = 0
        nstk_posn = 0
        nstk_alat = 0
        nstk_alon = 0
        nstk_pres = 0
        nstk_val = 0
        nstk_temp = 0
        nstk_wdir = 0
        nstk_wspd = 0
        nstk_moist = 0
c
        nstk_whol = 0
        kbadt = 0
        kbadw = 0
        nrep_Ac = 0
        nrep_Md = 0
        nrep_Ma = 0
        nrep_Ar = 0
        nrep_Am = 0
        nstk_Ac = 0
        nstk_Md = 0
        nstk_Ma = 0
        nstk_Ar = 0
        nstk_Am = 0
      endif
c
      nwhol_reg = 0
      ntemp_reg = 0
      nwind_reg = 0
c
c Begin loop over flights
c -----------------------
      do kk = 1,kflight
c
c Initialize variables
c --------------------
        istart = iobs_flt(kk)
        iistart = indx(istart)
        iend = iobs_flt(kk) + nobs_flt(kk) - 1
        iiend = indx(iend)
c
c Handle case where only one or two reports are present for flight
c ----------------------------------------------------------------
        if(nobs_flt(kk).eq.0) then
c          write(io8,*)
c          write(io8,*) 'No good obs for flight ',kflight
        elseif(nobs_flt(kk).eq.1) then
c         write(io8,*) 
c         write(io8,*) 'Only one report present for flight ',kflight
        elseif(nobs_flt(kk).eq.2) then
c         write(io8,*) 
c         write(io8,*) 'Only two reports present for flight ',kflight
c
c Handle case where three or more reports are present for flight
c --------------------------------------------------------------
        else
c
c Check if clock is stuck
c (ignore both single manAIREPs, and whole flights of manAIREPs)
c --------------------------------------------------------------
          k_ACARS = 0
          k_AIREP = 0
          k_manAIREP = 0
          k_AMDAR = 0
          ht_min = ht_ft(iistart)
          ht_max = ht_ft(iistart)
          temp_min = ob_t(iistart)
          temp_max = ob_t(iistart)
c
ccccdak         First find first ACARS/MDCRS/AIREP report and count reports by category
c         First find first TAMDAR/MDCRS/AIREP report and count reports by category
c         ------------------------------------------------------------------------
          do iob=istart,iend
            ii = indx(iob)
            if(ht_ft(ii).lt.ht_min)  ht_min = ht_ft(ii)
            if(ht_ft(ii).gt.ht_max)  ht_max = ht_ft(ii)
            if(ob_t(ii).lt.temp_min) temp_min = ob_t(ii)
            if(ob_t(ii).gt.temp_max) temp_max = ob_t(ii)
c
            if(itype(ii).eq.i_acars.or.
     $         itype(ii).eq.i_acars_lvl.or.
     $         itype(ii).eq.i_acars_asc.or.
     $         itype(ii).eq.i_acars_des.or.
     $         itype(ii).eq.i_mdcrs.or.
     $         itype(ii).eq.i_mdcrs_lvl.or.
     $         itype(ii).eq.i_mdcrs_asc.or.
     $         itype(ii).eq.i_mdcrs_des) then
c
              k_ACARS = k_ACARS + 1
c
            elseif(itype(ii).eq.i_airep.or.
     $             itype(ii).eq.i_airep_lvl.or.
     $             itype(ii).eq.i_airep_asc.or.
     $             itype(ii).eq.i_airep_des) then
c 
              k_AIREP = k_AIREP + 1
c
            elseif(itype(ii).eq.i_amdar.or.
     $             itype(ii).eq.i_amdar_lvl.or.
     $             itype(ii).eq.i_amdar_asc.or.
     $             itype(ii).eq.i_amdar_des) then
c 
              k_AMDAR = k_AMDAR + 1
c
            elseif(itype(ii).eq.i_man_airep.or.
     $             itype(ii).eq.i_man_Yairep) then
c
              k_manAIREP = k_manAIREP + 1
c
            endif
          enddo
c
ccccdak         If more than 3 ACARS/MDCRS/AIREP/AMDAR reports are present, look for stuck clock
c         If more than 3 TAMDAR/MDCRS/AIREP/AMDAR reports are present, look for stuck clock
c         ---------------------------------------------------------------------------------
          if((k_ACARS+k_AIREP+k_AMDAR).ge.3) then
            stuck = .true.
            k_stuck = 0
            istk_time = -999 999
            iobfirst = -999 999
            ioblast = -999 999
            ht_min_stuck =  999 999.
            ht_max_stuck = -999 999.
c
            do iob=istart+1,iend
              ii = indx(iob)
              iim1 = indx(iob-1)
c
c             Skip over isolated man_airep reports
c             ------------------------------------
              if((itype(ii).eq.i_man_airep.or.
     $            itype(ii).eq.i_man_Yairep).and.
     $           k_ACARS+k_AIREP+k_AMDAR.gt.0) then
c
c             Set "stuck" to false if times not equal and re-initialize stats
c             ---------------------------------------------------------------
              elseif(idt(iim1).ne.idt(ii)) then
c
c               If a portion of the flight is stuck, set QC flags
c               -------------------------------------------------
                if(k_stuck.ge.3.and.
     $             istk_time.ne.-999 999.and.
     $             ((istk_time.eq.0.and.
     $               (itype(ii).eq.i_acars.or.
     $                itype(ii).eq.i_acars_lvl.or.
     $                itype(ii).eq.i_acars_asc.or.
     $                itype(ii).eq.i_acars_des.or.
     $                itype(ii).eq.i_mdcrs.or.
     $                itype(ii).eq.i_mdcrs_lvl.or.
     $                itype(ii).eq.i_mdcrs_asc.or.
     $                itype(ii).eq.i_mdcrs_des)).or.
     $              ht_max_stuck-ht_min_stuck.lt.100..or.
     $              ht_max_stuck-ht_min_stuck.gt.9000.) ) then
c
                  do jj=iobfirst,ioblast
                    ii = indx(jj)
                    c_qc(ii)(2:2) = 'K'
                  enddo
c
                  write(io8,*)
                  write(io8,*) 'Flight with > 3 constant times'
                  do jj=istart,iend
                    ii = indx(jj)
                    write(io8,3002) ii,c_insty_ob(itype(ii))
     x,                c_acftreg(ii),c_acftid(ii)
     x,                idt(ii),alat(ii),alon(ii)
     x,                pres(ii),ht_ft(ii)
     x,                t_prcn(ii),ob_t(ii),xiv_t(ii),ichk_t(ii)
     x,                ob_q(ii),xiv_q(ii),ichk_q(ii)
     x,                ob_dir(ii),xiv_d(ii),ichk_d(ii)
     x,                ob_spd(ii),xiv_s(ii),ichk_s(ii)
     x,                c_qc(ii)
                  enddo
                endif
c
                stuck = .false.
                k_stuck = 0
                istk_time = -999 999
                iobfirst = -999 999
                ioblast = -999 999
                ht_min_stuck =  999 999.
                ht_max_stuck = -999 999.
c
c             Accumulate statistics for stuck segments
c             ----------------------------------------
              else
                k_stuck = k_stuck + 1
                istk_time = idt(ii)
                if(iobfirst.eq.-999 999) then
                  iobfirst = iob-1
                  if(ht_ft(iim1).lt.ht_min_stuck) 
     $               ht_min_stuck = ht_ft(iim1)
                  if(ht_ft(iim1).gt.ht_max_stuck) 
     $               ht_max_stuck = ht_ft(iim1)
                endif
                ioblast = iob
                if(ht_ft(ii).lt.ht_min_stuck) ht_min_stuck = ht_ft(ii)
                if(ht_ft(ii).gt.ht_max_stuck) ht_max_stuck = ht_ft(ii)
              endif                
            enddo
c
c           If entire flight is stuck and flight is long enough, set QC flags
c           -----------------------------------------------------------------
            if(stuck.and.
     $         ((k_ACARS+k_AIREP+k_AMDAR).ge.3.or.
     $          (k_ACARS+k_AIREP+k_AMDAR).eq.0).and.
     $         (idt(iistart).eq.0.or.
     $          ht_max-ht_min.lt.100..or.
     $          ht_max-ht_min.gt.9000.)) then
c
              do iob=istart,iend
                ii = indx(iob)
                c_qc(ii)(2:2) = 'K'
              enddo
c
c           Otherwise, if only a portion of the flight is stuck, set QC flags
c           -----------------------------------------------------------------
            elseif(k_stuck.ge.3.and.
     $             istk_time.ne.-999 999.and.
     $             ((istk_time.eq.0.and.
     $               (itype(ii).eq.i_acars.or.
     $                itype(ii).eq.i_acars_lvl.or.
     $                itype(ii).eq.i_acars_asc.or.
     $                itype(ii).eq.i_acars_des.or.
     $                itype(ii).eq.i_mdcrs.or.
     $                itype(ii).eq.i_mdcrs_lvl.or.
     $                itype(ii).eq.i_mdcrs_asc.or.
     $                itype(ii).eq.i_mdcrs_des)).or.
     $              ht_max_stuck-ht_min_stuck.lt.100..or.
     $              ht_max_stuck-ht_min_stuck.gt.9000.) ) then
c
              do iob=iobfirst,ioblast
                ii = indx(iob)
                c_qc(ii)(2:2) = 'K'
              enddo
c
              write(io8,*)
              write(io8,*) 'Flight with > 3 constant times'
              do iob=istart,iend
                ii = indx(iob)
                write(io8,3002) ii,c_insty_ob(itype(ii))
     x,            c_acftreg(ii),c_acftid(ii)
     x,            idt(ii),alat(ii),alon(ii)
     x,            pres(ii),ht_ft(ii)
     x,            t_prcn(ii),ob_t(ii),xiv_t(ii),ichk_t(ii)
     x,            ob_q(ii),xiv_q(ii),ichk_q(ii)
     x,            ob_dir(ii),xiv_d(ii),ichk_d(ii)
     x,            ob_spd(ii),xiv_s(ii),ichk_s(ii)
     x,            c_qc(ii)
              enddo
            endif
          endif
c
c Perform remaining tests only for flights with four or more reports
c ------------------------------------------------------------------
          if(nobs_flt(kk).gt.3) then
c
c           Check if position is stuck
c           --------------------------
            stuck = .true.
            k_stuck = 0
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
            stk_alat = -999 999
            stk_alon = -999 999
            iobfirst = -999 999
            ioblast = -999 999
            iifirst = -999 999
            iilast = -999 999
            alat_min =  999 999
            alat_max = -999 999
            alon_min =  999 999
            alon_max = -999 999
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
            ht_min_stuck =  999 999
            ht_max_stuck = -999 999
c
            do iob=istart+1,iend
              ii = indx(iob)
              iim1 = indx(iob-1)
c
c             Skip over isolated man_airep reports
c             ------------------------------------
              if((itype(ii).eq.i_man_airep.or.
     $            itype(ii).eq.i_man_Yairep).and.
     $            k_ACARS+k_AIREP+k_AMDAR.gt.0) then
c
c             Skip over reports with previously averaged positions
c             ----------------------------------------------------
              elseif(ichk_t(ii).eq.-4) then
!vvvv^ DAK-future change perhaps to account for incr. lat/lon precision
c
c             Set "stuck" to false if lat/lons not equal and re-initialize stats
c             ------------------------------------------------------------------
              elseif((abs(alat(iim1)-alat(ii)).gt.0.015.and.
     $                alat(iim1).ne.amiss.and.
     $                alat(ii).ne.amiss).or.
     $               (abs(alon(iim1)-alon(ii)).gt.0.015.and.
     $                alon(iim1).ne.amiss.and.
     $                alon(ii).ne.amiss)) then
c
c               If a portion of the flight is stuck, set QC flags
c               -------------------------------------------------
                if(k_stuck.ge.3.and.
     $             stk_alat.ne.-999 999.and.
     $             stk_alon.ne.-999 999.and.
     $             stk_alat.ne.amiss.and.
     $             stk_alon.ne.amiss.and.
     $             abs(alat_max-alat_min).lt.0.015.and.
     $             abs(alon_max-alon_min).lt.0.015.and.
     $             (abs(stk_alat).lt.0.005.or.
     $              abs(stk_alon).lt.0.005.or.
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
     $              ht_max_stuck-ht_min_stuck.lt.100..or.
     $              ((itype(ii).ne.i_amdar.and.
     $                itype(ii).ne.i_amdar_lvl.and.
     $                itype(ii).ne.i_amdar_asc.and.
     $                itype(ii).ne.i_amdar_des).and.
     $               ht_max_stuck-ht_min_stuck.gt.9000.).or.
     $              ((itype(ii).eq.i_amdar.or.
     $                itype(ii).eq.i_amdar_lvl.or.
     $                itype(ii).eq.i_amdar_asc.or.
     $                itype(ii).eq.i_amdar_des).and.
     $               ht_max_stuck-ht_min_stuck.gt.12000.)) ) then
c
                  do jj=iobfirst,ioblast
                    ii = indx(jj)
                    c_qc(ii)(3:4) = 'KK'
                  enddo
c
                  write(io8,*)
                  write(io8,*) 'Flight with > 3 constant positions'
                  do jj=istart,iend
                    ii = indx(jj)
                    write(io8,3002) ii,c_insty_ob(itype(ii))
     x,                c_acftreg(ii),c_acftid(ii)
     x,                idt(ii),alat(ii),alon(ii)
     x,                pres(ii),ht_ft(ii)
     x,                t_prcn(ii),ob_t(ii),xiv_t(ii),ichk_t(ii)
     x,                ob_q(ii),xiv_q(ii),ichk_q(ii)
     x,                ob_dir(ii),xiv_d(ii),ichk_d(ii)
     x,                ob_spd(ii),xiv_s(ii),ichk_s(ii)
     x,                c_qc(ii)
                  enddo
                endif
c
                stuck = .false.
                k_stuck = 0
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
                stk_alat = -999 999
                stk_alon = -999 999
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
                iobfirst = -999 999
                ioblast = -999 999
                iifirst = -999 999
                iilast = -999 999
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
                alat_min =  999 999
                alat_max = -999 999
                alon_min =  999 999
                alon_max = -999 999
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
                ht_min_stuck =  999 999
                ht_max_stuck = -999 999
c
c             Accumulate statistics for stuck segments
c             ----------------------------------------
              else
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
                k_stuck = k_stuck + 1
                stk_alat = alat(ii)
                stk_alon = alon(ii)
                if(iobfirst.eq.-999 999) then
                  iobfirst = iob-1
                  if(alat(iim1).lt.alat_min.and.
     $               alat(iim1).ne.amiss) alat_min = alat(iim1)
                  if(alat(iim1).gt.alat_max.and.
     $               alat(iim1).ne.amiss) alat_max = alat(iim1)
                  if(alon(iim1).lt.alon_min.and.
     $               alon(iim1).ne.amiss) alon_min = alon(iim1)
                  if(alon(iim1).gt.alon_max.and.
     $               alon(iim1).ne.amiss) alon_max = alon(iim1)
                  if(ht_ft(iim1).lt.ht_min_stuck) 
     $               ht_min_stuck = ht_ft(iim1)
                  if(ht_ft(iim1).gt.ht_max_stuck) 
     $               ht_max_stuck = ht_ft(iim1)
                endif
                ioblast = iob
                if(iifirst.eq.-999 999) iifirst = iim1
                iilast = ii
                if(alat(ii).lt.alat_min.and.
     $             alat(ii).ne.amiss) alat_min = alat(ii)
                if(alat(ii).gt.alat_max.and.
     $             alat(ii).ne.amiss) alat_max = alat(ii)
                if(alon(ii).lt.alon_min.and.
     $             alon(ii).ne.amiss) alon_min = alon(ii)
                if(alon(ii).gt.alon_max.and.
     $             alon(ii).ne.amiss) alon_max = alon(ii)
                if(ht_ft(ii).lt.ht_min_stuck) ht_min_stuck = ht_ft(ii)
                if(ht_ft(ii).gt.ht_max_stuck) ht_max_stuck = ht_ft(ii)
              endif
            enddo
c
c           If entire flight is stuck and flight is long enough, set QC flags
c           -----------------------------------------------------------------
            if(stuck.and.
     $         alat(iistart).ne.amiss.and.
     $         alon(iistart).ne.amiss.and.
     $         abs(alat_max-alat_min).lt.0.015.and.
     $         abs(alon_max-alon_min).lt.0.015.and.
     $         (k_ACARS+k_AIREP+k_AMDAR.ge.3.or.
     $          k_ACARS+k_AIREP+k_AMDAR.eq.0).and.
     $         (abs(alat(iistart)).lt.0.005.or.
     $          abs(alon(iistart)).lt.0.005.or.
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
     $          ht_max-ht_min.lt.100..or.
     $          ((itype(ii).ne.i_amdar.and.
     $            itype(ii).ne.i_amdar_lvl.and.
     $            itype(ii).ne.i_amdar_asc.and.
     $            itype(ii).ne.i_amdar_des).and.
     $           ht_max-ht_min.gt.9000.).or.
     $          ((itype(ii).eq.i_amdar.or.
     $            itype(ii).eq.i_amdar_lvl.or.
     $            itype(ii).eq.i_amdar_asc.or.
     $            itype(ii).eq.i_amdar_des).and.
     $           ht_max-ht_min.gt.12000.)) ) then
c
              do iob=istart,iend
                ii = indx(iob)
                c_qc(ii)(3:4) = 'KK'
              enddo
c
c           Otherwise, if only a portion of the flight is stuck, set QC flags
c           -----------------------------------------------------------------
            elseif(k_stuck.ge.3.and.
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
     $             stk_alat.ne.-999 999.and.
     $             stk_alon.ne.-999 999.and.
     $             stk_alat.ne.amiss.and.
     $             stk_alon.ne.amiss.and.
     $             abs(alat_max-alat_min).lt.0.015.and.
     $             abs(alon_max-alon_min).lt.0.015.and.
     $             (abs(stk_alat).lt.0.005.or.
     $              abs(stk_alon).lt.0.005.or.
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
     $              ht_max_stuck-ht_min_stuck.lt.100..or.
     $              ((itype(ii).ne.i_amdar.and.
     $                itype(ii).ne.i_amdar_lvl.and.
     $                itype(ii).ne.i_amdar_asc.and.
     $                itype(ii).ne.i_amdar_des).and.
     $               ht_max_stuck-ht_min_stuck.gt.9000.).or.
     $              ((itype(ii).eq.i_amdar.or.
     $                itype(ii).eq.i_amdar_lvl.or.
     $                itype(ii).eq.i_amdar_asc.or.
     $                itype(ii).eq.i_amdar_des).and.
     $               ht_max_stuck-ht_min_stuck.gt.12000.)) ) then
c
              do iob=iobfirst,ioblast
                ii = indx(iob)
                c_qc(ii)(3:4) = 'KK'
              enddo
c
              write(io8,*)
              write(io8,*) 'Flight with > 3 constant positions'
              do iob=istart,iend
                ii = indx(iob)
                write(io8,3002) ii,c_insty_ob(itype(ii))
     x,            c_acftreg(ii),c_acftid(ii)
     x,            idt(ii),alat(ii),alon(ii)
     x,            pres(ii),ht_ft(ii)
     x,            t_prcn(ii),ob_t(ii),xiv_t(ii),ichk_t(ii)
     x,            ob_q(ii),xiv_q(ii),ichk_q(ii)
     x,            ob_dir(ii),xiv_d(ii),ichk_d(ii)
     x,            ob_spd(ii),xiv_s(ii),ichk_s(ii)
     x,            c_qc(ii)
              enddo
            endif
c
c           Check if latitude is stuck
c           --------------------------
            stuck = .true.
            k_stuck = 0
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
            stk_alat = -999 999
            iobfirst = -999 999
            ioblast = -999 999
            iifirst = -999 999
            iilast = -999 999
            alat_min =  999 999
            alat_max = -999 999
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
            ht_min_stuck =  999 999
            ht_max_stuck = -999 999
c
            do iob=istart+1,iend
              ii = indx(iob)
              iim1 = indx(iob-1)
c
c             Skip over isolated man_airep reports
c             ------------------------------------
              if((itype(ii).eq.i_man_airep.or.
     $            itype(ii).eq.i_man_Yairep).and.
     $            k_ACARS+k_AIREP+k_AMDAR.gt.0) then
c
c             Skip over reports with previously averaged positions
c             ----------------------------------------------------
              elseif(ichk_t(ii).eq.-4) then
c
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
c             Set "stuck" to false if lats not equal and re-initialize stats
c             --------------------------------------------------------------
              elseif(abs(alat(iim1)-alat(ii)).gt.0.005.and.
     $               alat(iim1).ne.amiss.and.
     $               alat(ii).ne.amiss) then
cc
cc               If a portion of the flight is stuck, set QC flags
cc               -------------------------------------------------
c                if(k_stuck.ge.3.and.
c     $             stk_alat.ne.-999 999.and.
c     $             stk_alat.ne.amiss.and.
c     $             abs(alat_max-alat_min).lt.0.005.and.
c     $             abs(nint(stk_alat)-stk_alat).gt.0.005.and.
c     $             abs(idt(iilast)-idt(iifirst)).gt.1800.and.
c     $             (abs(stk_alat).lt.0.005.or.
c     $              ht_max_stuck-ht_min_stuck.lt.100..or.
c     $              ht_max_stuck-ht_min_stuck.gt.9000.) ) then
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
cc
c                  do jj=iobfirst,ioblast
c                    ii = indx(jj)
c                    c_qc(ii)(3:3) = 'K'
c                  enddo
cc
c                  write(io8,*)
c                  write(io8,*) 'Flight with > 3 constant latitudes'
c                  do jj=istart,iend
c                    ii = indx(jj)
c                    write(io8,3002) ii,c_insty_ob(itype(ii))
c     x,                c_acftreg(ii),c_acftid(ii)
c     x,                idt(ii),alat(ii),alon(ii)
c     x,                pres(ii),ht_ft(ii)
c     x,                t_prcn(ii),ob_t(ii),xiv_t(ii),ichk_t(ii)
c     x,                ob_q(ii),xiv_q(ii),ichk_q(ii)
c     x,                ob_dir(ii),xiv_d(ii),ichk_d(ii)
c     x,                ob_spd(ii),xiv_s(ii),ichk_s(ii)
c     x,                c_qc(ii)
c                  enddo
c                endif
c
                stuck = .false.
                k_stuck = 0
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
                stk_alat = -999 999
                iobfirst = -999 999
                ioblast = -999 999
                iifirst = -999 999
                iilast = -999 999
                alat_min =  999 999
                alat_max = -999 999
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
                ht_min_stuck =  999 999
                ht_max_stuck = -999 999
c
c             Accumulate statistics for stuck segments
c             ----------------------------------------
              elseif(c_qc(ii)(3:3).ne.'K') then
                k_stuck = k_stuck + 1
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
                stk_alat = alat(ii)
                if(iobfirst.eq.-999 999) then
                  iobfirst = iob-1
                  if(alat(iim1).lt.alat_min.and.
     $               alat(iim1).ne.amiss) alat_min = alat(iim1)
                  if(alat(iim1).gt.alat_max.and.
     $               alat(iim1).ne.amiss) alat_max = alat(iim1)
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
                  if(ht_ft(iim1).lt.ht_min_stuck) 
     $               ht_min_stuck = ht_ft(iim1)
                  if(ht_ft(iim1).gt.ht_max_stuck) 
     $               ht_max_stuck = ht_ft(iim1)
                endif
                ioblast = iob
                if(iifirst.eq.-999 999) iifirst = iim1
                iilast = ii
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
                if(alat(ii).lt.alat_min.and.
     $             alat(ii).ne.amiss) alat_min = alat(ii)
                if(alat(ii).gt.alat_max.and.
     $             alat(ii).ne.amiss) alat_max = alat(ii)
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
                if(ht_ft(ii).lt.ht_min_stuck) ht_min_stuck = ht_ft(ii)
                if(ht_ft(ii).gt.ht_max_stuck) ht_max_stuck = ht_ft(ii)
              endif
            enddo
c
c           Don't reject flights with constant lat rounded to nearest deg
c           or flights with elapsed time less than 30 minutes (1800 seconds)
c           --------------------------------------------------------------
            if(stuck.and.
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
     $         alat(iistart).ne.amiss.and.
     $         abs(alat_max-alat_min).lt.0.005.and.
     $         abs(nint(alat(iistart))-alat(iistart)).gt.0.005.and.
     $         abs(idt(iiend)-idt(iistart)).gt.1800.and.
     $         (k_ACARS+k_AIREP+k_AMDAR.ge.3.or.
     $          k_ACARS+k_AIREP+k_AMDAR.eq.0).and.
     $         (abs(alat(iistart)).lt.0.005.or.
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
     $          ht_max-ht_min.lt.100..or.
     $          ht_max-ht_min.gt.9000.)) then
c
              do iob=istart,iend
                ii = indx(iob)
                c_qc(ii)(3:3) = 'K'
              enddo
cc
cc           Otherwise, if only a portion of the flight is stuck, set QC flags
cc           -----------------------------------------------------------------
c            elseif(k_stuck.ge.3.and.
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
c     $             stk_alat.ne.-999 999.and.
c     $             stk_alat.ne.amiss.and.
c     $             abs(alat_max-alat_min).lt.0.005.and.
c     $             abs(nint(stk_alat)-stk_alat).gt.0.005.and.
c     $             abs(idt(iilast)-idt(iifirst)).gt.1800.and.
c     $             (abs(stk_alat).lt.0.005.or.
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
c     $              ht_max_stuck-ht_min_stuck.lt.100..or.
c     $              ht_max_stuck-ht_min_stuck.gt.9000.) ) then
cc
c              do iob=iobfirst,ioblast
c                ii = indx(iob)
c                c_qc(ii)(3:3) = 'K'
c              enddo
cc
c              write(io8,*)
c              write(io8,*) 'Flight with > 3 constant latitudes'
c              do iob=istart,iend
c                ii = indx(iob)
c                write(io8,3002) ii,c_insty_ob(itype(ii))
c     x,            c_acftreg(ii),c_acftid(ii)
c     x,            idt(ii),alat(ii),alon(ii)
c     x,            pres(ii),ht_ft(ii)
c     x,            t_prcn(ii),ob_t(ii),xiv_t(ii),ichk_t(ii)
c     x,            ob_q(ii),xiv_q(ii),ichk_q(ii)
c     x,            ob_dir(ii),xiv_d(ii),ichk_d(ii)
c     x,            ob_spd(ii),xiv_s(ii),ichk_s(ii)
c     x,            c_qc(ii)
c              enddo
c
            endif  
c
c           Check if longitude is stuck
c           ---------------------------
            stuck = .true.
            k_stuck = 0
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
            stk_alon = -999 999
            iobfirst = -999 999
            ioblast = -999 999
            iifirst = -999 999
            iilast = -999 999
            alon_min =  999 999
            alon_max = -999 999
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
            ht_min_stuck =  999 999
            ht_max_stuck = -999 999
c
            do iob=istart+1,iend
              ii = indx(iob)
              iim1 = indx(iob-1)
c
c             Skip over isolated man_airep reports
c             ------------------------------------
              if((itype(ii).eq.i_man_airep.or.
     $            itype(ii).eq.i_man_Yairep).and.
     $            k_ACARS+k_AIREP+k_AMDAR.gt.0) then
c
c             Skip over reports with previously averaged positions
c             ----------------------------------------------------
              elseif(ichk_t(ii).eq.-4) then
c
c             Set "stuck" to false if lons not equal and re-initialize stats
c             --------------------------------------------------------------
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
              elseif(abs(alon(iim1)-alon(ii)).gt.0.005.and.
     $               alon(iim1).ne.amiss.and.
     $               alon(ii).ne.amiss) then
cc
cc               If a portion of the flight is stuck, set QC flags
cc               -------------------------------------------------
c                if(k_stuck.ge.3.and.
c     $             stk_alon.ne.-999 999.and.
c     $             stk_alon.ne.amiss.and.
c     $             abs(alon_max-alon_min).lt.0.005.and.
c     $             abs(nint(stk_alon)-stk_alon).gt.0.005.and.
c     $             abs(idt(iilast)-idt(iifirst)).gt.1800.and.
c     $             (abs(stk_alon).lt.0.005.or.
c     $              ht_max_stuck-ht_min_stuck.lt.100..or.
c     $              ht_max_stuck-ht_min_stuck.gt.9000.) ) then
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
cc
c                  do jj=iobfirst,ioblast
c                    ii = indx(jj)
c                    c_qc(ii)(4:4) = 'K'
c                  enddo
cc
c                  write(io8,*)
c                  write(io8,*) 'Flight with > 3 constant longitudes'
c                  do jj=istart,iend
c                    ii = indx(jj)
c                    write(io8,3002) ii,c_insty_ob(itype(ii))
c     x,                c_acftreg(ii),c_acftid(ii)
c     x,                idt(ii),alat(ii),alon(ii)
c     x,                pres(ii),ht_ft(ii)
c     x,                t_prcn(ii),ob_t(ii),xiv_t(ii),ichk_t(ii)
c     x,                ob_q(ii),xiv_q(ii),ichk_q(ii)
c     x,                ob_dir(ii),xiv_d(ii),ichk_d(ii)
c     x,                ob_spd(ii),xiv_s(ii),ichk_s(ii)
c     x,                c_qc(ii)
c                  enddo
c                endif
c
                stuck = .false.
                k_stuck = 0
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
                stk_alon = -999 999
                iobfirst = -999 999
                ioblast = -999 999
                iifirst = -999 999
                iilast = -999 999
                alon_min =  999 999
                alon_max = -999 999
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
                ht_min_stuck =  999 999
                ht_max_stuck = -999 999
c
c             Accumulate statistics for stuck segments
c             ----------------------------------------
              elseif(c_qc(ii)(4:4).ne.'K') then
                k_stuck = k_stuck + 1
                stk_alon = alon(ii)
                if(iobfirst.eq.-999 999) then
                  iobfirst = iob-1
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
                  if(alon(iim1).lt.alon_min.and.
     $               alon(iim1).ne.amiss) alon_min = alon(iim1)
                  if(alon(iim1).gt.alon_max.and.
     $               alon(iim1).ne.amiss) alon_max = alon(iim1)
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
                  if(ht_ft(iim1).lt.ht_min_stuck) 
     $               ht_min_stuck = ht_ft(iim1)
                  if(ht_ft(iim1).gt.ht_max_stuck) 
     $               ht_max_stuck = ht_ft(iim1)
                endif
                ioblast = iob
                if(iifirst.eq.-999 999) iifirst = iim1
                iilast = ii
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
                if(alon(ii).lt.alon_min.and.
     $             alon(ii).ne.amiss) alon_min = alon(ii)
                if(alon(ii).gt.alon_max.and.
     $             alon(ii).ne.amiss) alon_max = alon(ii)
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
                if(ht_ft(ii).lt.ht_min_stuck) ht_min_stuck = ht_ft(ii)
                if(ht_ft(ii).gt.ht_max_stuck) ht_max_stuck = ht_ft(ii)
              endif
            enddo
c
c           Don't reject flights with constant lon rounded to nearest deg
c           or flights with elapsed time less than 30 minutes (1800 seconds)
c           --------------------------------------------------------------
            if(stuck.and.
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
     $         alon(iistart).ne.amiss.and.
     $         abs(alon_max-alon_min).lt.0.005.and.
     $         abs(nint(alon(iistart))-alon(iistart)).gt.0.005.and.
     $         abs(idt(iiend)-idt(iistart)).gt.1800.and.
c     $         abs(alon(iiend)-alon(iistart)).lt.0.005.and.
     $         (k_ACARS+k_AIREP+k_AMDAR.ge.3.or.
     $          k_ACARS+k_AIREP+k_AMDAR.eq.0).and.
     $         (abs(alon(iistart)).lt.0.005.or.
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
     $          ht_max-ht_min.lt.100..or.
     $          ht_max-ht_min.gt.9000.)) then
c
              do iob=istart,iend
                ii = indx(iob)
                c_qc(ii)(4:4) = 'K'
              enddo
cc
cc           Otherwise, if only a portion of the flight is stuck, set QC flags
cc           -----------------------------------------------------------------
c            elseif(k_stuck.ge.3.and.
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
c     $             stk_alon.ne.-999 999.and.
c     $             stk_alon.ne.amiss.and.
c     $             abs(alon_max-alon_min).lt.0.005.and.
c     $             abs(nint(stk_alon)-stk_alon).gt.0.005.and.
c     $             abs(idt(iilast)-idt(iifirst)).gt.1800.and.
c     $             (abs(stk_alon).lt.0.005.or.
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
c     $              ht_max_stuck-ht_min_stuck.lt.100..or.
c     $              ht_max_stuck-ht_min_stuck.gt.9000.) ) then
c
c              do iob=iobfirst,ioblast
c                ii = indx(iob)
c                c_qc(ii)(4:4) = 'K'
c              enddo
cc
c              write(io8,*)
c              write(io8,*) 'Flight with > 3 constant longitudes'
c              do iob=istart,iend
c                ii = indx(iob)
c                write(io8,3002) ii,c_insty_ob(itype(ii))
c     x,            c_acftreg(ii),c_acftid(ii)
c     x,            idt(ii),alat(ii),alon(ii)
c     x,            pres(ii),ht_ft(ii)
c     x,            t_prcn(ii),ob_t(ii),xiv_t(ii),ichk_t(ii)
c     x,            ob_q(ii),xiv_q(ii),ichk_q(ii)
c     x,            ob_dir(ii),xiv_d(ii),ichk_d(ii)
c     x,            ob_spd(ii),xiv_s(ii),ichk_s(ii)
c     x,            c_qc(ii)
c              enddo
c
            endif  
c
c           Check if pressure is stuck 
c           (constant ok if at upper levels)
c           (The check for stuck segments is commented out)
c           -----------------------------------------------
            stuck = .true.
            k_stuck = 0
            stk_pres = -999 999
            iobfirst = -999 999
            ioblast = -999 999
            iifirst = -999 999
            iilast = -999 999
            ob_min =  999 999
            ob_max = -999 999
c
            do iob=istart+1,iend
              ii = indx(iob)
              iim1 = indx(iob-1)
c
c             Skip over isolated man_airep reports
c             ------------------------------------
              if((itype(ii).eq.i_man_airep.or.
     $            itype(ii).eq.i_man_Yairep).and.
     $            k_ACARS+k_AIREP+k_AMDAR.gt.0) then
c
c             Set "stuck" to false if pressures not equal and re-initialize stats
c             -------------------------------------------------------------------
              elseif(abs(pres(iim1)-pres(ii)).gt.0.05.and.
     $               pres(iim1).ne.amiss.and.
     $               pres(ii).ne.amiss) then
                stuck = .false.
                k_stuck = 0
                stk_pres = -999 999
                iobfirst = -999 999
                ioblast = -999 999
                iifirst = -999 999
                iilast = -999 999
                ob_min =  999 999
                ob_max = -999 999
c
c             Accumulate statistics for stuck segments
c             ----------------------------------------
              else
c                k_stuck = k_stuck + 1
c                stk_pres = pres(ii)
                if(iobfirst.eq.-999 999) then
                  iobfirst = iob-1
                  if(pres(iim1).lt.ob_min.and.
     $               pres(iim1).ne.amiss) ob_min = pres(iim1)
                  if(pres(iim1).gt.ob_max.and.
     $               pres(iim1).ne.amiss) ob_max = pres(iim1)
                endif
c                ioblast = iob
c                if(iifirst.eq.-999 999) iifirst = iim1
c                iilast = ii
                if(pres(ii).lt.ob_min.and.
     $             pres(ii).ne.amiss) ob_min = pres(ii)
                if(pres(ii).gt.ob_max.and.
     $             pres(ii).ne.amiss) ob_max = pres(ii)
c
              endif
            enddo
c
c           Don't reject flights with pressure less than 750 mb
c           ---------------------------------------------------
            if(stuck.and.
     $         pres(iistart).gt.750..and.
     $         pres(iistart).ne.amiss.and.
c     $         abs(pres(iiend)-pres(iistart)).lt.0.05.and.
     $         abs(ob_max-ob_min).lt.0.05.and.
     $         abs(idt(iiend)-idt(iistart)).gt.1800.and.
     $         (k_ACARS+k_AIREP+k_AMDAR.ge.3.or.
     $          k_ACARS+k_AIREP+k_AMDAR.eq.0)) then
c
              do iob=istart,iend
                ii = indx(iob)
                c_qc(ii)(5:5) = 'K'
              enddo
cc
cc           Otherwise, if only a portion of the flight is stuck, set QC flags
cc           -----------------------------------------------------------------
c            elseif(k_stuck.ge.3.and.
c     $             stk_pres.ne.-999 999.and.
c     $             stk_pres.ne.amiss.and.
c     $             abs(ob_max-ob_min).lt.0.05.and.
c     $             abs(idt(iilast)-idt(iifirst)).gt.1800.and.
c     $             stk_pres.gt.750.) then
cc
c              do iob=iobfirst,ioblast
c                ii = indx(iob)
c                c_qc(ii)(5:5) = 'K'
c              enddo
cc
c              stuck = .true.
cc
c              write(io8,*)
c              write(io8,*) 'Flight with > 3 constant pressures'
c              do iob=istart,iend
c                ii = indx(iob)
c                write(io8,3002) ii,c_insty_ob(itype(ii))
c     x,            c_acftreg(ii),c_acftid(ii)
c     x,            idt(ii),alat(ii),alon(ii)
c     x,            pres(ii),ht_ft(ii)
c     x,            t_prcn(ii),ob_t(ii),xiv_t(ii),ichk_t(ii)
c     x,            ob_q(ii),xiv_q(ii),ichk_q(ii)
c     x,            ob_dir(ii),xiv_d(ii),ichk_d(ii)
c     x,            ob_spd(ii),xiv_s(ii),ichk_s(ii)
c     x,            c_qc(ii)
c              enddo
c
            endif  
c
c           Check if altitude is stuck 
c           (constant ok if at upper levels)
c           (The check for stuck segments is commented out)
c           -----------------------------------------------
            if(.not.stuck) then
c
              stuck = .true.
              k_stuck = 0
              stk_alt = -999 999
              iobfirst = -999 999
              ioblast = -999 999
              iifirst = -999 999
              iilast = -999 999
              ob_min =  999 999
              ob_max = -999 999
c
              do iob=istart+1,iend
                ii = indx(iob)
                iim1 = indx(iob-1)
c
c               Skip over isolated man_airep reports
c               ------------------------------------
                if((itype(ii).eq.i_man_airep.or.
     $              itype(ii).eq.i_man_Yairep).and.
     $              k_ACARS+k_AIREP+k_AMDAR.gt.0) then
c
c               Set "stuck" to false if heights not equal and re-initialize stats
c               -----------------------------------------------------------------
                elseif(ifix(ht_ft(iim1)/10.).ne.
     $                 ifix(ht_ft(ii)/10.).and.
     $                 ht_ft(iim1).ne.amiss.and.
     $                 ht_ft(ii).ne.amiss) then
                  stuck = .false.
                  k_stuck = 0
                  stk_alt = -999 999
                  iobfirst = -999 999
                  ioblast = -999 999
                  iifirst = -999 999
                  iilast = -999 999
                  ob_min =  999 999
                  ob_max = -999 999
c
c               Accumulate statistics for stuck segments
c               ----------------------------------------
                else
c                  k_stuck = k_stuck + 1
c                  stk_alt = ht_ft(ii)
                  if(iobfirst.eq.-999 999) then
                    iobfirst = iob-1
                    if(ht_ft(iim1).lt.ob_min.and.
     $                 ht_ft(iim1).ne.amiss) ob_min = ht_ft(iim1)
                    if(ht_ft(iim1).gt.ob_max.and.
     $                 ht_ft(iim1).ne.amiss) ob_max = ht_ft(iim1)
                  endif
c                  ioblast = iob
c                  if(iifirst.eq.-999 999) iifirst = iim1
c                  iilast = ii
                  if(ht_ft(ii).lt.ob_min.and.
     $               ht_ft(ii).ne.amiss) ob_min = ht_ft(ii)
                  if(ht_ft(ii).gt.ob_max.and.
     $               ht_ft(ii).ne.amiss) ob_max = ht_ft(ii)
c
                endif
              enddo
c
c             Don't reject flights with altitude greater than 8000'
c             -----------------------------------------------------
              if(stuck.and.
     $           ht_ft(iistart).lt.8000..and.
     $           ht_ft(iistart).ne.amiss.and.
c     $           ifix(ht_ft(iiend)/10.).eq.ifix(ht_ft(iistart)/10.).and.
     $           ifix(ob_max/10.).eq.ifix(ob_min/10.).and.
     $           abs(idt(iiend)-idt(iistart)).gt.1800.and.
     $           (k_ACARS+k_AIREP+k_AMDAR.ge.3.or.
     $            k_ACARS+k_AIREP+k_AMDAR.eq.0)) then
c
                do iob=istart,iend
                  ii = indx(iob)
                  c_qc(ii)(5:5) = 'K'
                enddo
cc
cc             Otherwise, if only a portion of the flight is stuck, set QC flags
cc             -----------------------------------------------------------------
c              elseif(k_stuck.ge.3.and.
c     $               stk_alt.ne.-999 999.and.
c     $               stk_alt.ne.amiss.and.
c     $               ifix(ob_max/10.).eq.ifix(ob_min/10.).and.
c     $               abs(idt(iilast)-idt(iifirst)).gt.1800.and.
c     $               stk_alt.lt.8000.) then
cc
c                do iob=iobfirst,ioblast
c                  ii = indx(iob)
c                  c_qc(ii)(5:5) = 'K'
c                enddo
cc
c                write(io8,*)
c                write(io8,*) 'Flight with > 3 constant altitudes'
c                do iob=istart,iend
c                  ii = indx(iob)
c                  write(io8,3002) ii,c_insty_ob(itype(ii))
c     x,              c_acftreg(ii),c_acftid(ii)
c     x,              idt(ii),alat(ii),alon(ii)
c     x,              pres(ii),ht_ft(ii)
c     x,              t_prcn(ii),ob_t(ii),xiv_t(ii),ichk_t(ii)
c     x,              ob_q(ii),xiv_q(ii),ichk_q(ii)
c     x,              ob_dir(ii),xiv_d(ii),ichk_d(ii)
c     x,              ob_spd(ii),xiv_s(ii),ichk_s(ii)
c     x,              c_qc(ii)
c                enddo
c
              endif  
            endif
c
c           Check if temperature is stuck or reported in whole deg
c           (The check for stuck segments is commented out)
c           ------------------------------------------------------
            stuck = .true.
            k_stuck = 0
            stk_temp = -999 999
            iobfirst = -999 999
            ioblast = -999 999
            iifirst = -999 999
            iilast = -999 999
            ob_min =  999 999
            ob_max = -999 999
            ht_min_stuck =  999 999
            ht_max_stuck = -999 999
c
            do iob=istart+1,iend
              ii = indx(iob)
              iim1 = indx(iob-1)
c
c             Skip over isolated man_airep reports
c             ------------------------------------
              if((itype(ii).eq.i_man_airep.or.
     $            itype(ii).eq.i_man_Yairep).and.
     $            k_ACARS+k_AIREP+k_AMDAR.gt.0) then
c
c             Skip over temperatures already rejected
c             ---------------------------------------
              elseif(c_qc(ii)(6:6).eq.'B'.or.
     $               c_qc(ii)(6:6).eq.'b'.or.
     $               c_qc(ii)(6:6).eq.'E'.or.
     $               c_qc(ii)(6:6).eq.'I') then
c
c             Set "stuck" to false if temps not equal and re-initialize stats
c             ---------------------------------------------------------------
              elseif(abs(ob_t(iim1)-ob_t(ii)).gt.0.05.and.
     $               ob_t(iim1).ne.amiss.and.
     $               ob_t(ii).ne.amiss) then
c
                stuck = .false.
                k_stuck = 0
                stk_temp = -999 999
                iobfirst = -999 999
                ioblast = -999 999
                iifirst = -999 999
                iilast = -999 999
                ob_min =  999 999
                ob_max = -999 999
                ht_min_stuck =  999 999
                ht_max_stuck = -999 999
c
c             Accumulate statistics for stuck segments
c             ----------------------------------------
              else
c                k_stuck = k_stuck + 1
c                stk_temp = ob_t(ii)
                if(iobfirst.eq.-999 999.and.
     $             ob_t(iim1).ne.amiss) then
                  iobfirst = iob-1
                  ioblast = iob-1
                  if(ob_t(iim1).lt.ob_min.and.
     $               ob_t(iim1).ne.amiss) ob_min = ob_t(iim1)
                  if(ob_t(iim1).gt.ob_max.and.
     $               ob_t(iim1).ne.amiss) ob_max = ob_t(iim1)
c                  if(ht_ft(iim1).lt.ht_min_stuck) 
c     $               ht_min_stuck = ht_ft(iim1)
c                  if(ht_ft(iim1).gt.ht_max_stuck) 
c     $               ht_max_stuck = ht_ft(iim1)
                endif
                if(ob_t(ii).ne.amiss) ioblast = iob
c                if(iifirst.eq.-999 999) iifirst = iim1
c                iilast = ii
                if(ob_t(ii).lt.ob_min.and.
     $             ob_t(ii).ne.amiss) ob_min = ob_t(ii)
                if(ob_t(ii).gt.ob_max.and.
     $             ob_t(ii).ne.amiss) ob_max = ob_t(ii)
c                if(ht_ft(ii).lt.ht_min_stuck) ht_min_stuck = ht_ft(ii)
c                if(ht_ft(ii).gt.ht_max_stuck) ht_max_stuck = ht_ft(ii)
c
              endif
            enddo
c
c           Don't reject flights with a height difference of less than 1500'
c           --------------------------------------------------------------
            if(stuck.and.
     $         k_stuck.gt.0.and.
     $         ob_t(iistart).ne.amiss.and.
     $         iobfirst.ne.ioblast.and.
     $         (ht_max-ht_min.gt.1500..or.
     $          ht_max.gt.25000.).and.
     $         abs(ob_max-ob_min).lt.0.05.and.
     $         (k_ACARS+k_AIREP+k_AMDAR.ge.3.or.
     $          k_ACARS+k_AIREP+k_AMDAR.eq.0)) then
c
              do iob=istart,iend
                ii = indx(iob)
                if(c_qc(ii)(6:6).ne.'B'.and.
     $             c_qc(ii)(6:6).ne.'b'.and.
     $             c_qc(ii)(6:6).ne.'E'.and.
     $             c_qc(ii)(6:6).ne.'I') c_qc(ii)(6:6) = 'K'
              enddo
cc
cc           Otherwise, if only a portion of the flight is stuck, set QC flags
cc           -----------------------------------------------------------------
c            elseif(k_stuck.ge.3.and.
c     $             stk_temp.ne.-999 999.and.
c     $             stk_temp.ne.amiss.and.
c     $             abs(ob_max-ob_min).lt.0.05.and.
c     $             (ht_max_stuck-ht_min_stuck.gt.1500..or.
c     $              ht_max_stuck.gt.25000.)) then
cc
c              do iob=iobfirst,ioblast
c                ii = indx(iob)
c                c_qc(ii)(6:6) = 'K'
c              enddo
cc
c              write(io8,*)
c              write(io8,*) 'Flight with > 3 constant temperatures'
c              do iob=istart,iend
c                ii = indx(iob)
c                write(io8,3002) ii,c_insty_ob(itype(ii))
c     x,            c_acftreg(ii),c_acftid(ii)
c     x,            idt(ii),alat(ii),alon(ii)
c     x,            pres(ii),ht_ft(ii)
c     x,            t_prcn(ii),ob_t(ii),xiv_t(ii),ichk_t(ii)
c     x,            ob_q(ii),xiv_q(ii),ichk_q(ii)
c     x,            ob_dir(ii),xiv_d(ii),ichk_d(ii)
c     x,            ob_spd(ii),xiv_s(ii),ichk_s(ii)
c     x,            c_qc(ii)
c              enddo
c
            endif  
c
ccccdak           Recompute temperature reported in whole degrees for ACARS/MDCRS
c           Recompute temperature reported in whole degrees for TAMDAR/MDCRS
c           Mark as bad for other types
c           ----------------------------------------------------------------
            if(temp_min.gt.266.0.and.
     $         temp_max.lt.278.0.and.
     $         (.not.stuck).and.
     $         ht_max.gt.25000.) then
c
              do mm=1,kreg
                if(c_acftreg(iistart).eq.creg_reg(mm)) mreg = mm
              enddo
c
              do iob=istart,iend
                ii = indx(iob)
                if(itype(ii).eq.i_acars.or.
     $             itype(ii).eq.i_acars_lvl.or.
     $             itype(ii).eq.i_acars_asc.or.
     $             itype(ii).eq.i_acars_des.or.
     $             itype(ii).eq.i_mdcrs.or.
     $             itype(ii).eq.i_mdcrs_lvl.or.
     $             itype(ii).eq.i_mdcrs_asc.or.
     $             itype(ii).eq.i_mdcrs_des) then
                  ob_t(ii) = (ob_t(ii) - 273.16) * 10. + 273.16
c                  write(io8,*) '  temperature recomputed'
                  c_qc(ii)(6:6) = 'R'
                  t_prcn(ii) = 1.00
                else
c                  write(io8,*) '  temperature marked bad'
                  c_qc(ii)(6:6) = 'b'
                endif
c
c               Count number of corrected/rejected temperatures
c               -----------------------------------------------
                if(c_acftreg(ii).eq.creg_reg(mreg)) then
c
                  if(itype(ii).eq.i_mdcrs.or.
     $               itype(ii).eq.i_mdcrs_lvl.or.
     $               itype(ii).eq.i_mdcrs_asc.or.
     $               itype(ii).eq.i_mdcrs_des) then
                    nwhol_reg(mreg,1) = nwhol_reg(mreg,1) + 1
c
                  elseif(itype(ii).eq.i_acars.or.
     $                   itype(ii).eq.i_acars_lvl.or.
     $                   itype(ii).eq.i_acars_asc.or.
     $                   itype(ii).eq.i_acars_des) then
                    nwhol_reg(mreg,2) = nwhol_reg(mreg,2) + 1
c
                  elseif(itype(ii).eq.i_amdar.or. 
     $                   itype(ii).eq.i_amdar_lvl.or.
     $                   itype(ii).eq.i_amdar_asc.or.
     $                   itype(ii).eq.i_amdar_des) then
                    nwhol_reg(mreg,3) = nwhol_reg(mreg,3) + 1
c
                  elseif(itype(ii).eq.i_airep.or.
     $                   itype(ii).eq.i_airep_lvl.or.
     $                   itype(ii).eq.i_airep_asc.or.
     $                   itype(ii).eq.i_airep_des) then
                    nwhol_reg(mreg,4) = nwhol_reg(mreg,4) + 1
c
                  elseif(itype(ii).eq.i_man_airep.or.
     $                   itype(ii).eq.i_man_Yairep) then
                    nwhol_reg(mreg,5) = nwhol_reg(mreg,5) + 1
                  endif
c
                else
                  do mm=1,kreg
                    if(c_acftreg(ii).eq.creg_reg(mm)) then 
c
                      if(itype(ii).eq.i_mdcrs.or.
     $                   itype(ii).eq.i_mdcrs_lvl.or.
     $                   itype(ii).eq.i_mdcrs_asc.or.
     $                   itype(ii).eq.i_mdcrs_des) then
                        nwhol_reg(mm,1) = nwhol_reg(mm,1) + 1
c
                      elseif(itype(ii).eq.i_acars.or.
     $                       itype(ii).eq.i_acars_lvl.or.
     $                       itype(ii).eq.i_acars_asc.or.
     $                       itype(ii).eq.i_acars_des) then
                        nwhol_reg(mm,2) = nwhol_reg(mm,2) + 1
c
                      elseif(itype(ii).eq.i_amdar.or. 
     $                       itype(ii).eq.i_amdar_lvl.or.
     $                       itype(ii).eq.i_amdar_asc.or.
     $                       itype(ii).eq.i_amdar_des) then
                        nwhol_reg(mm,3) = nwhol_reg(mm,3) + 1
c
                      elseif(itype(ii).eq.i_airep.or.
     $                       itype(ii).eq.i_airep_lvl.or.
     $                       itype(ii).eq.i_airep_asc.or.
     $                       itype(ii).eq.i_airep_des) then
                        nwhol_reg(mm,4) = nwhol_reg(mm,4) + 1
c
                      elseif(itype(ii).eq.i_man_airep.or.
     $                       itype(ii).eq.i_man_Yairep) then
                        nwhol_reg(mm,5) = nwhol_reg(mm,5) + 1
                      endif
                    endif
                  enddo
                endif
              enddo
            endif
c
c           Check if wind direction is stuck
c           (The check for stuck segments is commented out)
c           -----------------------------------------------
            stuck = .true.
            k_stuck = 0
            stk_wdir = -999 999
            iobfirst = -999 999
            ioblast = -999 999
            iifirst = -999 999
            iilast = -999 999
            ob_min =  999 999
            ob_max = -999 999
            ht_min_stuck =  999 999
            ht_max_stuck = -999 999
c
            do iob=istart+1,iend
              ii = indx(iob)
              iim1 = indx(iob-1)
c
c             Skip over isolated man_airep reports
c             ------------------------------------
              if((itype(ii).eq.i_man_airep.or.
     $            itype(ii).eq.i_man_Yairep).and.
     $            k_ACARS+k_AIREP+k_AMDAR.gt.0) then
c
c             Skip over winds already rejected
c             --------------------------------
              elseif(c_qc(ii)(7:7).eq.'B'.or.
     $               c_qc(ii)(7:7).eq.'E'.or.
     $               c_qc(ii)(8:8).eq.'E') then
c
c             Set "stuck" to false if directions not equal and re-initialize stats
c             --------------------------------------------------------------------
              elseif(abs(ob_dir(iim1)-ob_dir(ii)).gt.0.5.and.
     $               ob_dir(iim1).ne.amiss.and.
     $               ob_dir(ii).ne.amiss) then
                stuck = .false.
                k_stuck = 0
                stk_wdir = -999 999
                iobfirst = -999 999
                ioblast = -999 999
                iifirst = -999 999
                iilast = -999 999
                ob_min =  999 999
                ob_max = -999 999
                ht_min_stuck =  999 999
                ht_max_stuck = -999 999
c
c             Accumulate statistics for stuck segments
c             ----------------------------------------
              else
c                k_stuck = k_stuck + 1
c                stk_wdir = ob_dir(ii)
                if(iobfirst.eq.-999 999) then
                  iobfirst = iob-1
                  if(ob_dir(iim1).lt.ob_min.and.
     $               ob_dir(iim1).ne.amiss) ob_min = ob_dir(iim1)
                  if(ob_dir(iim1).gt.ob_max.and.
     $               ob_dir(iim1).ne.amiss) ob_max = ob_dir(iim1)
c                  if(ht_ft(iim1).lt.ht_min_stuck) 
c     $               ht_min_stuck = ht_ft(iim1)
c                  if(ht_ft(iim1).gt.ht_max_stuck) 
c     $               ht_max_stuck = ht_ft(iim1)
                endif
c                ioblast = iob
c                if(iifirst.eq.-999 999) iifirst = iim1
c                iilast = ii
                if(ob_dir(ii).lt.ob_min.and.
     $             ob_dir(ii).ne.amiss) ob_min = ob_dir(ii)
                if(ob_dir(ii).gt.ob_max.and.
     $             ob_dir(ii).ne.amiss) ob_max = ob_dir(ii)
c                if(ht_ft(ii).lt.ht_min_stuck) ht_min_stuck = ht_ft(ii)
c                if(ht_ft(ii).gt.ht_max_stuck) ht_max_stuck = ht_ft(ii)
c
              endif
            enddo
c
c           Don't reject flights with constant dir rounded to nearest 10 deg
c           --------------------------------------------------------------
            if(stuck.and.
     $         ob_dir(iistart).ne.amiss.and.
     $         (abs(nint(ob_dir(iistart)/10.)*10
     $          -ob_dir(iistart)).gt.0.5).and.
c     $         abs(ob_dir(iiend)-ob_dir(iistart)).lt.0.5.and.
     $         abs(ob_max-ob_min).lt.0.5.and.
     $         (k_ACARS+k_AIREP+k_AMDAR.ge.3.or.
     $          k_ACARS+k_AIREP+k_AMDAR.eq.0).and.
     $         (ht_max-ht_min.lt.100..or.
     $          ht_max-ht_min.gt.9000.)) then
c
              do iob=istart,iend
                ii = indx(iob)
                c_qc(ii)(7:7) = 'K'
              enddo
cc
cc           Otherwise, if only a portion of the flight is stuck, set QC flags
cc           -----------------------------------------------------------------
c            elseif(k_stuck.ge.3.and.
c     $             stk_wdir.ne.-999 999.and.
c     $             stk_wdir.ne.amiss.and.
c     $             (abs(nint(stk_wdir/10.)*10-stk_wdir).gt.0.5).and.
c     $             abs(ob_max-ob_min).lt.0.5.and.
c     $             (ht_max_stuck-ht_min_stuck.lt.100..or.
c     $              ht_max_stuck-ht_min_stuck.gt.9000.) ) then
cc
c              do iob=iobfirst,ioblast
c                ii = indx(iob)
c                c_qc(ii)(7:7) = 'K'
c              enddo
cc
c              write(io8,*)
c              write(io8,*) 'Flight with > 3 constant wind directions'
c              do iob=istart,iend
c                ii = indx(iob)
c                write(io8,3002) ii,c_insty_ob(itype(ii))
c     x,            c_acftreg(ii),c_acftid(ii)
c     x,            idt(ii),alat(ii),alon(ii)
c     x,            pres(ii),ht_ft(ii)
c     x,            t_prcn(ii),ob_t(ii),xiv_t(ii),ichk_t(ii)
c     x,            ob_q(ii),xiv_q(ii),ichk_q(ii)
c     x,            ob_dir(ii),xiv_d(ii),ichk_d(ii)
c     x,            ob_spd(ii),xiv_s(ii),ichk_s(ii)
c     x,            c_qc(ii)
c              enddo
c
            endif  
c
c           Check if wind speed is stuck
c           (The check for stuck segments is commented out)
c           -----------------------------------------------
            stuck = .true.
            k_stuck = 0
            stk_wspd = -999 999
            iobfirst = -999 999
            ioblast = -999 999
            iifirst = -999 999
            iilast = -999 999
            ob_min =  999 999
            ob_max = -999 999
            ht_min_stuck =  999 999
            ht_max_stuck = -999 999
c
            do iob=istart+1,iend
              ii = indx(iob)
              iim1 = indx(iob-1)
c
c             Skip over isolated man_airep reports
c             ------------------------------------
              if((itype(ii).eq.i_man_airep.or.
     $            itype(ii).eq.i_man_Yairep).and.
     $            k_ACARS+k_AIREP+k_AMDAR.gt.0) then
c
c             Skip over winds already rejected
c             --------------------------------
              elseif(c_qc(ii)(7:7).eq.'B'.or.
     $               c_qc(ii)(7:7).eq.'E'.or.
     $               c_qc(ii)(7:7).eq.'K'.or.
     $               c_qc(ii)(8:8).eq.'E') then
c
c             Set "stuck" to false if speeds not equal and re-initialize stats
c             ----------------------------------------------------------------
              elseif(abs(ob_spd(iim1)-ob_spd(ii)).gt.0.05.and.
     $               ob_spd(iim1).ne.amiss.and.
     $               ob_spd(ii).ne.amiss) then
                stuck = .false.
                k_stuck = 0
                stk_wspd = -999 999
                iobfirst = -999 999
                ioblast = -999 999
                iifirst = -999 999
                iilast = -999 999
                ob_min =  999 999
                ob_max = -999 999
                ht_min_stuck =  999 999
                ht_max_stuck = -999 999
c
c             Accumulate statistics for stuck segments
c             ----------------------------------------
              else
c                k_stuck = k_stuck + 1
c                stk_wspd = ob_spd(ii)
                if(iobfirst.eq.-999 999) then
                  iobfirst = iob-1
                  if(ob_spd(iim1).lt.ob_min.and.
     $               ob_spd(iim1).ne.amiss) ob_min = ob_spd(iim1)
                  if(ob_spd(iim1).gt.ob_max.and.
     $               ob_spd(iim1).ne.amiss) ob_max = ob_spd(iim1)
c                  if(ht_ft(iim1).lt.ht_min_stuck) 
c     $               ht_min_stuck = ht_ft(iim1)
c                  if(ht_ft(iim1).gt.ht_max_stuck) 
c     $               ht_max_stuck = ht_ft(iim1)
                endif
c                ioblast = iob
c                if(iifirst.eq.-999 999) iifirst = iim1
c                iilast = ii
                if(ob_spd(ii).lt.ob_min.and.
     $             ob_spd(ii).ne.amiss) ob_min = ob_spd(ii)
                if(ob_spd(ii).gt.ob_max.and.
     $             ob_spd(ii).ne.amiss) ob_max = ob_spd(ii)
c                if(ht_ft(ii).lt.ht_min_stuck) ht_min_stuck = ht_ft(ii)
c                if(ht_ft(ii).gt.ht_max_stuck) ht_max_stuck = ht_ft(ii)
c
              endif
            enddo
c
c           Don't reject flights with constant direction rounded to the nearest 10 deg
c           --------------------------------------------------------------------------
            if(stuck.and.
     $         ob_spd(iistart).ne.amiss.and.
     $         (ob_dir(iistart).ne.-999 999.and.
     $          (ob_dir(iistart).eq.0.0.or.
     $           abs(nint(ob_dir(iistart)/10.)*10
     $                   -ob_dir(iistart)).gt.0.5).or.
     $          ob_dir(iiend).ne.-999 999.and.
     $          (ob_dir(iiend).eq.0.0.or.
     $           abs(nint(ob_dir(iiend)/10.)*10
     $                   -ob_dir(iiend)).gt.0.5)).and.
c     $         abs(ob_spd(iiend)-ob_spd(iistart)).lt.0.05.and.
     $         abs(ob_max-ob_min).lt.0.05.and.
     $         (k_ACARS+k_AIREP+k_AMDAR.ge.3.or.
     $          k_ACARS+k_AIREP+k_AMDAR.eq.0).and.
     $         (ht_max-ht_min.lt.100..or.
     $          ht_max-ht_min.gt.9000.)) then
c
              do iob=istart,iend
                ii = indx(iob)
                c_qc(ii)(8:8) = 'K'
              enddo
cc
cc           Otherwise, if only a portion of the flight is stuck, set QC flags
cc           -----------------------------------------------------------------
c            elseif(k_stuck.ge.3.and.
c     $             stk_wspd.ne.-999 999.and.
c     $             stk_wspd.ne.amiss.and.
c     $             ((ob_dir(iifirst).ne.-999 999.and.
c     $               (ob_dir(iifirst).eq.0.0.or.
c     $                abs(nint(ob_dir(iifirst)/10.)*10
c     $                        -ob_dir(iifirst)).gt.0.5)).or.
c     $              (ob_dir(iilast).ne.-999 999.and.
c     $               (ob_dir(iilast).eq.0.0.or.
c     $                abs(nint(ob_dir(iilast)/10.)*10
c     $                        -ob_dir(iilast)).gt.0.5))).and.
c     $              abs(ob_max-ob_min).lt.0.05.and.
c     $              (ht_max_stuck-ht_min_stuck.lt.100..or.
c     $               ht_max_stuck-ht_min_stuck.gt.9000.)) then
cc
c              do iob=iobfirst,ioblast
c                ii = indx(iob)
c                c_qc(ii)(8:8) = 'K'
c              enddo
cc
c              write(io8,*)
c              write(io8,*) 'Flight with > 3 constant wind speeds'
c              do iob=istart,iend
c                ii = indx(iob)
c                write(io8,3002) ii,c_insty_ob(itype(ii))
c     x,            c_acftreg(ii),c_acftid(ii)
c     x,            idt(ii),alat(ii),alon(ii)
c     x,            pres(ii),ht_ft(ii)
c     x,            t_prcn(ii),ob_t(ii),xiv_t(ii),ichk_t(ii)
c     x,            ob_q(ii),xiv_q(ii),ichk_q(ii)
c     x,            ob_dir(ii),xiv_d(ii),ichk_d(ii)
c     x,            ob_spd(ii),xiv_s(ii),ichk_s(ii)
c     x,            c_qc(ii)
c              enddo
c
            endif  
c
c           Check if moisture is stuck
c           (The check for stuck segments is commented out)
c           -----------------------------------------------
            stuck = .true.
            k_stuck = 0
            stk_moist = -999 999
            iobfirst = -999 999
            ioblast = -999 999
            iifirst = -999 999
            iilast = -999 999
            ob_min =  999 999
            ob_max = -999 999
            ht_min_stuck =  999 999
            ht_max_stuck = -999 999
c
            do iob=istart+1,iend
              ii = indx(iob)
              iim1 = indx(iob-1)
c
c             Skip over isolated man_airep reports
c             ------------------------------------
              if((itype(ii).eq.i_man_airep.or.
     $            itype(ii).eq.i_man_Yairep).and.
     $            k_ACARS+k_AIREP+k_AMDAR.gt.0) then
c
c             Set "stuck" to false if moistures not equal and re-initialize stats
c             Exclude missing values
c             -------------------------------------------------------------------
              elseif(abs(ob_q(iim1)-ob_q(ii)).gt.0.005.and.
     $               ob_q(iim1).ne.amiss.and.
     $               ob_q(ii).ne.amiss.and.
     $               ichk_q(ii).ne.-9.and.
     $               ichk_q(ii).ne.9.and.
     $               ichk_q(ii).ne.-1.and.
     $               .not.(ob_q(ii).lt.0.005.and.ichk_q(ii).eq.-7)) then
c
                stuck = .false.
                k_stuck = 0
                stk_moist = -999 999
                iobfirst = -999 999
                ioblast = -999 999
                iifirst = -999 999
                iilast = -999 999
                ob_min =  999 999
                ob_max = -999 999
                ht_min_stuck =  999 999
                ht_max_stuck = -999 999
c
c             Accumulate statistics for stuck segments
c             ----------------------------------------
              else
c                k_stuck = k_stuck + 1
c                stk_moist = ob_q(ii)
                if(iobfirst.eq.-999 999) then
                  iobfirst = iob-1
                  if(ob_q(iim1).lt.ob_min.and.
     $               ob_q(iim1).ne.amiss) ob_min = ob_q(iim1)
                  if(ob_q(iim1).gt.ob_max.and.
     $               ob_q(iim1).ne.amiss) ob_max = ob_q(iim1)
c                  if(ht_ft(iim1).lt.ht_min_stuck) 
c     $               ht_min_stuck = ht_ft(iim1)
c                  if(ht_ft(iim1).gt.ht_max_stuck) 
c     $               ht_max_stuck = ht_ft(iim1)
                endif
c                ioblast = iob
c                if(iifirst.eq.-999 999) iifirst = iim1
c                iilast = ii
                if(ob_q(ii).lt.ob_min.and.
     $             ob_q(ii).ne.amiss) ob_min = ob_q(ii)
                if(ob_q(ii).gt.ob_max.and.
     $             ob_q(ii).ne.amiss) ob_max = ob_q(ii)
c                if(ht_ft(ii).lt.ht_min_stuck) ht_min_stuck = ht_ft(ii)
c                if(ht_ft(ii).gt.ht_max_stuck) ht_max_stuck = ht_ft(ii)
c
              endif
            enddo
c
c           Don't reject flights with moisture = 0 (=> missing)
c           ---------------------------------------------------
            if(stuck.and.
     $         ob_q(iistart).ne.amiss.and.
     $         abs(ob_q(iistart)).gt.0.005.and.
c     $         abs(ob_q(iiend)-ob_q(iistart)).lt.0.005.and.
     $         abs(ob_max-ob_min).lt.0.005.and.
     $         (k_ACARS+k_AIREP+k_AMDAR.ge.3.or.
     $          k_ACARS+k_AIREP+k_AMDAR.eq.0).and.
     $         (ht_max-ht_min.lt.100..or.
     $          ht_max-ht_min.gt.9000.)) then

              do iob=istart,iend
                ii = indx(iob)
                if(c_qc(ii)(9:9).eq.'-') c_qc(ii)(9:9) = 'K'
              enddo
cc
cc           Otherwise, if only a portion of the flight is stuck, set QC flags
cc           -----------------------------------------------------------------
c            elseif(k_stuck.ge.3.and.
c     $             stk_moist.ne.-999 999.and.
c     $             stk_moist.ne.amiss.and.
c     $             stk_moist.gt.0.005.and.
c     $             abs(ob_max-ob_min).lt.0.005.and.
c     $             (ht_max_stuck-ht_min_stuck.lt.100..or.
c     $              ht_max_stuck-ht_min_stuck.gt.9000.)) then
cc
c              do iob=iobfirst,ioblast
c                ii = indx(iob)
c                c_qc(ii)(9:9) = 'K'
c              enddo
cc
c              write(io8,*)
c              write(io8,*) 'Flight with > 3 constant moisture'
c              do iob=istart,iend
c                ii = indx(iob)
c                write(io8,3002) ii,c_insty_ob(itype(ii))
c     x,            c_acftreg(ii),c_acftid(ii)
c     x,            idt(ii),alat(ii),alon(ii)
c     x,            pres(ii),ht_ft(ii)
c     x,            t_prcn(ii),ob_t(ii),xiv_t(ii),ichk_t(ii)
c     x,            ob_q(ii),xiv_q(ii),ichk_q(ii)
c     x,            ob_dir(ii),xiv_d(ii),ichk_d(ii)
c     x,            ob_spd(ii),xiv_s(ii),ichk_s(ii)
c     x,            c_qc(ii)
c              enddo
c
            endif  
c
          endif
        endif
      enddo
c
c Write out bad reports
c ---------------------
      if(.not.l_operational) then
        write(io33,*)
        write(io33,*) 'Reports with temperatures in whole degrees'
        write(io33,*) '------------------------------------------'
        write(io33,3001)
 3001   format(' index  type    tail num   flight     time       lat'
     x,      '        lon       pres  height '
     x,      't-prcn   temp     innov  ichk'
     x,      ' spec hum    innov  ichk'
     x,      '   ob_dir    innov  ichk'
     x,      '   ob_spd    innov  ichk'
     x,      '   qc flag')
      endif
c
      do iob = 1,numreps
        ii   = indx(iob)
c
        if(c_qc(ii)(6:6).eq.'R'.or.
     $     c_qc(ii)(6:6).eq.'b') then
c
          if(.not.l_operational) then
            write(io33,3002) ii,c_insty_ob(itype(ii))
     x,        c_acftreg(ii),c_acftid(ii)
     x,        idt(ii),alat(ii),alon(ii)
     x,        pres(ii),ht_ft(ii)
     x,        t_prcn(ii),ob_t(ii),xiv_t(ii),ichk_t(ii)
     x,        ob_q(ii),xiv_q(ii),ichk_q(ii)
     x,        ob_dir(ii),xiv_d(ii),ichk_d(ii)
     x,        ob_spd(ii),xiv_s(ii),ichk_s(ii)
     x,        c_qc(ii)
 3002       format(i6,1x,a8,1x,a8,1x,a9,1x,i7,1x,2f11.5,1x,f8.1,1x,f7.0
     x,          1x,f5.2,4(2(1x,f8.2),1x,i5),1x,'!',a11,'!')
          endif
c
c         Count number of recomputed or marked reports
c         --------------------------------------------
          if(itype(ii).eq.i_mdcrs.or.
     $       itype(ii).eq.i_mdcrs_lvl.or.
     $       itype(ii).eq.i_mdcrs_asc.or.
     $       itype(ii).eq.i_mdcrs_des) then
            nstk_whol(1) = nstk_whol(1) + 1
c
          elseif(itype(ii).eq.i_acars.or.
     $           itype(ii).eq.i_acars_lvl.or.
     $           itype(ii).eq.i_acars_asc.or.
     $           itype(ii).eq.i_acars_des) then
            nstk_whol(2) = nstk_whol(2) + 1
c
          elseif(itype(ii).eq.i_amdar.or. 
     $           itype(ii).eq.i_amdar_lvl.or.
     $           itype(ii).eq.i_amdar_asc.or.
     $           itype(ii).eq.i_amdar_des) then
            nstk_whol(3) = nstk_whol(3) + 1
c
          elseif(itype(ii).eq.i_airep.or.
     $           itype(ii).eq.i_airep_lvl.or.
     $           itype(ii).eq.i_airep_asc.or.
     $           itype(ii).eq.i_airep_des) then
            nstk_whol(4) = nstk_whol(4) + 1
c
          elseif(itype(ii).eq.i_man_airep.or.
     $           itype(ii).eq.i_man_Yairep) then
            nstk_whol(5) = nstk_whol(5) + 1
          endif
c
        endif
      enddo
c
      if(.not.l_operational) then
        write(io33,*)
        write(io33,*) '  Number of MDCRS    in whole deg =',nstk_whol(1)
ccccdak        write(io33,*) '  Number of ACARS    in whole deg =',nstk_whol(2)
        write(io33,*) '  Number of TAMDAR   in whole deg =',nstk_whol(2)
        write(io33,*) '  Number of AMDAR    in whole deg =',nstk_whol(3)
        write(io33,*) '  Number of AIREP    in whole deg =',nstk_whol(4)
        write(io33,*) '  Number of manAIREP in whole deg =',nstk_whol(5)
c
        write(io33,*)
        write(io33,*) 'Reports with stuck values (K)'
        write(io33,*) '-----------------------------'
        write(io33,3001)
      endif
c
      kbad = 0
c
      do iob = 1,numreps
        ii   = indx(iob)
c
        if(itype(ii).eq.i_mdcrs.or.
     $     itype(ii).eq.i_mdcrs_lvl.or.
     $     itype(ii).eq.i_mdcrs_asc.or.
     $     itype(ii).eq.i_mdcrs_des) then
          ktype = 1
c
        elseif(itype(ii).eq.i_acars.or.
     $         itype(ii).eq.i_acars_lvl.or.
     $         itype(ii).eq.i_acars_asc.or.
     $         itype(ii).eq.i_acars_des) then
          ktype = 2
c
        elseif(itype(ii).eq.i_amdar.or. 
     $         itype(ii).eq.i_amdar_lvl.or.
     $         itype(ii).eq.i_amdar_asc.or.
     $         itype(ii).eq.i_amdar_des) then
          ktype = 3
c
        elseif(itype(ii).eq.i_airep.or.
     $         itype(ii).eq.i_airep_lvl.or.
     $         itype(ii).eq.i_airep_asc.or.
     $         itype(ii).eq.i_airep_des) then
          ktype = 4
c
        elseif(itype(ii).eq.i_man_airep.or.
     $         itype(ii).eq.i_man_Yairep) then
          ktype = 5
        endif
c
        if(ktype.eq.1) then
          nrep_Md = nrep_Md + 1
        elseif(ktype.eq.2) then
          nrep_Ac = nrep_Ac + 1
        elseif(ktype.eq.3) then
          nrep_Am = nrep_Am + 1
        elseif(ktype.eq.4) then
          nrep_Ar = nrep_Ar + 1
        elseif(ktype.eq.5) then
          nrep_Ma = nrep_Ma + 1
        endif
c
        if(c_qc(ii)(2:2).eq.'K'.or.
     $     c_qc(ii)(3:3).eq.'K'.or.
     $     c_qc(ii)(4:4).eq.'K'.or.
     $     c_qc(ii)(5:5).eq.'K'.or.
     $     c_qc(ii)(6:6).eq.'K'.or.
     $     c_qc(ii)(7:7).eq.'K'.or.
     $     c_qc(ii)(8:8).eq.'K'.or.
     $     c_qc(ii)(9:9).eq.'K') then
c
          if(.not.l_operational) then
            write(io33,3002) ii,c_insty_ob(itype(ii))
     x,          c_acftreg(ii),c_acftid(ii)
     x,          idt(ii),alat(ii),alon(ii)
     x,          pres(ii),ht_ft(ii)
     x,          t_prcn(ii),ob_t(ii),xiv_t(ii),ichk_t(ii)
     x,          ob_q(ii),xiv_q(ii),ichk_q(ii)
     x,          ob_dir(ii),xiv_d(ii),ichk_d(ii)
     x,          ob_spd(ii),xiv_s(ii),ichk_s(ii)
     x,          c_qc(ii)
          endif
c
c         Count number of rejects
c         -----------------------
          if(c_qc(ii)(2:4).eq.'KKK') then
            nstk_both(ktype) = nstk_both(ktype) + 1
          elseif(c_qc(ii)(2:2).eq.'K') then
            nstk_time(ktype) = nstk_time(ktype) + 1
          elseif(c_qc(ii)(3:4).eq.'KK') then
            nstk_posn(ktype) = nstk_posn(ktype) + 1
          elseif(c_qc(ii)(3:3).eq.'K') then
            nstk_alat(ktype) = nstk_alat(ktype) + 1
          elseif(c_qc(ii)(4:4).eq.'K') then
            nstk_alon(ktype) = nstk_alon(ktype) + 1
          elseif(c_qc(ii)(5:5).eq.'K') then
            nstk_pres(ktype) = nstk_pres(ktype) + 1
          elseif(c_qc(ii)(6:6).eq.'K'.and.
     $           (c_qc(ii)(7:7).eq.'K'.or.
     $            c_qc(ii)(8:8).eq.'K')) then
            nstk_val(ktype) = nstk_val(ktype) + 1
          else
            if(c_qc(ii)(6:6).eq.'K') then
              nstk_temp(ktype) = nstk_temp(ktype) + 1
            endif
            if(c_qc(ii)(7:7).eq.'K') then
              nstk_wdir(ktype) = nstk_wdir(ktype) + 1
            endif
            if(c_qc(ii)(8:8).eq.'K') then
              nstk_wspd(ktype) = nstk_wspd(ktype) + 1
            endif
            if(c_qc(ii)(9:9).eq.'K') then
              nstk_moist(ktype) = nstk_moist(ktype) + 1
            endif
          endif
c
c         Count number of rejected temps/winds by tail number
c         ---------------------------------------------------
          mm = 1
          do while(mm.le.kreg)
            if(c_acftreg(ii).eq.creg_reg(mm)) then 
c
              if(ktype.gt.0.and.ktype.le.5) then
                if(c_qc(ii)(6:6).eq.'K'.and.
     $             c_qc(ii)(2:2).ne.'K'.and.
     $             c_qc(ii)(3:3).ne.'K'.and.
     $             c_qc(ii)(4:4).ne.'K'.and.
     $             c_qc(ii)(5:5).ne.'K')
     $            ntemp_reg(mm,ktype) = ntemp_reg(mm,ktype) + 1
                if((c_qc(ii)(7:7).eq.'K'.or.
     $             c_qc(ii)(8:8).eq.'K').and.
     $             c_qc(ii)(2:2).ne.'K'.and.
     $             c_qc(ii)(3:3).ne.'K'.and.
     $             c_qc(ii)(4:4).ne.'K'.and.
     $             c_qc(ii)(5:5).ne.'K')
     $            nwind_reg(mm,ktype) = nwind_reg(mm,ktype) + 1
              endif
              mm = kreg + 1
            endif
            mm = mm + 1
          enddo
        endif
c
c       Reject reports with stuck time, lat, lon, pres
c       Also reject report if both temperature and winds are stuck
c       ----------------------------------------------------------
        if(c_qc(ii)(2:2).eq.'K'.or.
     $     c_qc(ii)(3:3).eq.'K'.or.
     $     c_qc(ii)(4:4).eq.'K'.or.
     $     c_qc(ii)(5:5).eq.'K'.or.
     $     (c_qc(ii)(6:6).eq.'K'.and.
     $      (c_qc(ii)(7:7).eq.'K'.or.
     $       c_qc(ii)(8:8).eq.'K'))) then
c
          csort(ii)(1:5) = 'badob'
c
          kbad(ktype) = kbad(ktype) + 1
c
          if(ktype.eq.1) then
            nstk_Md = nstk_Md + 1
          elseif(ktype.eq.2) then
            nstk_Ac = nstk_Ac + 1
          elseif(ktype.eq.3) then
            nstk_Am = nstk_Am + 1
          elseif(ktype.eq.4) then
            nstk_Ar = nstk_Ar + 1
          elseif(ktype.eq.5) then
            nstk_Ma = nstk_Ma + 1
          endif
c
c       Count reports with stuck temperature, wind direction, and wind speed
c       --------------------------------------------------------------------
        else
          if(c_qc(ii)(6:6).eq.'K') then
            kbadt(ktype) = kbadt(ktype) + 1
          endif
          if(c_qc(ii)(7:7).eq.'K'.or.
     $       c_qc(ii)(8:8).eq.'K') then
            kbadw(ktype) = kbadw(ktype) + 1
          endif
        endif
c
      enddo
c
      if(.not.l_operational) then
        write(io33,*)
        write(io33,*)'  Number of stuck MDCRS    reps rejected=',kbad(1)
ccccdak        write(io33,*)'  Number of stuck ACARS    reps rejected=',kbad(2)
        write(io33,*)'  Number of stuck TAMDAR   reps rejected=',kbad(2)
        write(io33,*)'  Number of stuck AMDAR    reps rejected=',kbad(3)
        write(io33,*)'  Number of stuck AIREP    reps rejected=',kbad(4)
        write(io33,*)'  Number of stuck manAIREP reps rejected=',kbad(5)
        write(io33,*)'  Number of stuck MDCRS    temps marked=',kbadt(1)
ccccdak        write(io33,*)'  Number of stuck ACARS    temps marked=',kbadt(2)
        write(io33,*)'  Number of stuck TAMDAR   temps marked=',kbadt(2)
        write(io33,*)'  Number of stuck AMDAR    temps marked=',kbadt(3)
        write(io33,*)'  Number of stuck AIREP    temps marked=',kbadt(4)
        write(io33,*)'  Number of stuck manAIREP temps marked=',kbadt(5)
        write(io33,*)'  Number of stuck MDCRS    winds marked=',kbadw(1)
ccccdak        write(io33,*)'  Number of stuck ACARS    winds marked=',kbadw(2)
        write(io33,*)'  Number of stuck TAMDAR   winds marked=',kbadw(2)
        write(io33,*)'  Number of stuck AMDAR    winds marked=',kbadw(3)
        write(io33,*)'  Number of stuck AIREP    winds marked=',kbadw(4)
        write(io33,*)'  Number of stuck manAIREP winds marked=',kbadw(5)
      endif       
c
      write(io8,*)
      write(io8,*) '  Reports with stuck values'
      write(io8,*) '  -------------------------'
      write(io8,*)'  Number of stuck MDCRS    reps rejected = ',kbad(1)
ccccdak      write(io8,*)'  Number of stuck ACARS    reps rejected = ',kbad(2)
      write(io8,*)'  Number of stuck TAMDAR   reps rejected = ',kbad(2)
      write(io8,*)'  Number of stuck AMDAR    reps rejected = ',kbad(3)
      write(io8,*)'  Number of stuck AIREP    reps rejected = ',kbad(4)
      write(io8,*)'  Number of stuck manAIREP reps rejected = ',kbad(5)
      write(io8,*)'  Number of stuck MDCRS    temps marked = ',kbadt(1)
ccccdak      write(io8,*)'  Number of stuck ACARS    temps marked = ',kbadt(2)
      write(io8,*)'  Number of stuck TAMDAR   temps marked = ',kbadt(2)
      write(io8,*)'  Number of stuck AMDAR    temps marked = ',kbadt(3)
      write(io8,*)'  Number of stuck AIREP    temps marked = ',kbadt(4)
      write(io8,*)'  Number of stuck manAIREP temps marked = ',kbadt(5)
      write(io8,*)'  Number of stuck MDCRS    winds marked = ',kbadw(1)
ccccdak      write(io8,*)'  Number of stuck ACARS    winds marked = ',kbadw(2)
      write(io8,*)'  Number of stuck TAMDAR   winds marked = ',kbadw(2)
      write(io8,*)'  Number of stuck AMDAR    winds marked = ',kbadw(3)
      write(io8,*)'  Number of stuck AIREP    winds marked = ',kbadw(4)
      write(io8,*)'  Number of stuck manAIREP winds marked = ',kbadw(5)
c
c     Output reports with good moisture
c     ---------------------------------
      if(.not.l_operational) then
        write(io33,*)
        write(io33,*) 'Reports with valid moisture'
        write(io33,*) '---------------------------'
        write(io33,3001)
      endif
c
      do iob = 1,numreps
        ii   = indx(iob)
c

cc smb 8/18/05 - ichk arrays were declared as reals, should have been integer
cc fixed 8/19/05.
cc	if(l_ncep.and.ob_q(ii).eq.amiss) then
cc	  ichk_q(ii) = -9
cc	endif

        if(ob_q(ii).eq.amiss.and.
     $     (ichk_q(ii).eq.-9.or.
     $      ichk_q(ii).eq.9)) then
c
c         missing moisture and QC flag signals missing data
c
        elseif((ifix(ob_q(ii)*100).eq.0.or.ob_q(ii).eq.amiss).and.
     $    ichk_q(ii).eq.-7.and.
     $    (c_acftreg(ii)(4:5).eq.'WU'.or.
     $     c_acftreg(ii)(4:5).eq.'GU')) then
c
c         moisture qc flag = -7 means invalid input parameter
c
        elseif(.not.l_operational) then
          write(io33,3002) ii,c_insty_ob(itype(ii))
     x,        c_acftreg(ii),c_acftid(ii)
     x,        idt(ii),alat(ii),alon(ii)
     x,        pres(ii),ht_ft(ii)
     x,        t_prcn(ii),ob_t(ii),xiv_t(ii),ichk_t(ii)
     x,        ob_q(ii),xiv_q(ii),ichk_q(ii)
     x,        ob_dir(ii),xiv_d(ii),ichk_d(ii)
     x,        ob_spd(ii),xiv_s(ii),ichk_s(ii)
     x,        c_qc(ii)
        endif
      enddo
c
c     Output tail number counts
c     -------------------------
      write(io8,*) 
      write(io8,*) '  Tail numbers for reports with temp in whole deg'
ccccdak      write(io8,*) '  Tail Num  MDCRS  ACARS  AMDAR  AIREP  MAN  '
      write(io8,*) '  Tail Num  MDCRS  TAMDAR AMDAR  AIREP  MAN  '
      write(io8,*) '  -------------------------------------------'
c
      do mm=1,kreg
        if( nwhol_reg(mm,1)+nwhol_reg(mm,2)+nwhol_reg(mm,3)
     $     +nwhol_reg(mm,4)+nwhol_reg(mm,5).gt.0) then
          write(io8,'(2x,a8,5(1x,i6))') 
     $      creg_reg(mm),(nwhol_reg(mm,kk),kk=1,5)
        endif
      enddo
c
      write(io8,*) 
      write(io8,*) '  Tail numbers for reports with stuck temperature'
ccccdak      write(io8,*) '  Tail Num  MDCRS  ACARS  AMDAR  AIREP  MAN  '
      write(io8,*) '  Tail Num  MDCRS  TAMDAR AMDAR  AIREP  MAN  '
      write(io8,*) '  -------------------------------------------'
c
      do mm=1,kreg
        if( ntemp_reg(mm,1)+ntemp_reg(mm,2)+ntemp_reg(mm,3)
     $     +ntemp_reg(mm,4)+ntemp_reg(mm,5).gt.0) then
          write(io8,'(2x,a8,5(1x,i6))') 
     $      creg_reg(mm),(ntemp_reg(mm,kk),kk=1,5)
        endif
      enddo
c
      write(io8,*) 
      write(io8,*) '  Tail numbers for reports with stuck winds'
ccccdak      write(io8,*) '  Tail Num  MDCRS  ACARS  AMDAR  AIREP  MAN  '
      write(io8,*) '  Tail Num  MDCRS  TAMDAR AMDAR  AIREP  MAN  '
      write(io8,*) '  -------------------------------------------'
c
      do mm=1,kreg
        if( nwind_reg(mm,1)+nwind_reg(mm,2)+nwind_reg(mm,3)
     $     +nwind_reg(mm,4)+nwind_reg(mm,5).gt.0) then
          write(io8,'(2x,a8,5(1x,i6))') 
     $      creg_reg(mm),(nwind_reg(mm,kk),kk=1,5)
        endif
      enddo
c
      write(*,*)
      write(*,*) 'Stuck value check data counts--',cdtg_an
      write(*,*) '-----------------------------------------'
      write(*,'(1x,a55)')
ccccdak     $ 'Type of check     MDCRS   ACARS   AMDAR   AIREP     man'
     $ 'Type of check     MDCRS  TAMDAR   AMDAR   AIREP     man'
      write(*,'(1x,a55)')
     $ '--------------- ------- ------- ------- ------- -------'
      write(*,'('' Num considered '',5(1x,i7))')
     $     nrep_Md,nrep_Ac,nrep_Am,nrep_Ar,nrep_Ma
      write(*,'('' Total invalid  '',5(1x,i7))')
     $     nstk_Md,nstk_Ac,nstk_Am,nstk_Ar,nstk_Ma
      write(*,'(1x,a55)')
     $ '--------------- ------- ------- ------- ------- -------'
      write(*,'('' Temps in wh deg'',5(1x,i7))')
     $            (nstk_whol(ii),ii=1,5)
      write(*,'(1x,a55)')
     $ '--------------- ------- ------- ------- ------- -------'
c
      write(io8,*)
      write(io8,*) 'Stuck value check data counts'
      write(io8,*) '-----------------------------'
      write(io8,'(1x,a55)')
ccccdak     $ 'Type of check     MDCRS   ACARS   AMDAR   AIREP     man'
     $ 'Type of check     MDCRS  TAMDAR   AMDAR   AIREP     man'
      write(io8,'(1x,a55)')
     $ '--------------- ------- ------- ------- ------- -------'
      write(io8,'(''Num considered '',5(1x,i7))')
     $            nrep_Md,nrep_Ac,nrep_Am,nrep_Ar,nrep_Ma
      write(io8,'(''Total rejected '',5(1x,i7))')
     $            nstk_Md,nstk_Ac,nstk_Am,nstk_Ar,nstk_Ma
      write(io8,'(1x,a55)')
     $ '--------------- ------- ------- ------- ------- -------'
      write(io8,'(''Temps in wh deg'',5(1x,i7))')
     $            (nstk_whol(ii),ii=1,5)
      write(io8,'(1x,a55)')
     $ '--------------- ------- ------- ------- ------- -------'
c
      write(io8,'(''Stuck time     '',5(1x,i7))')
     $          (nstk_time(ii),ii=1,5)
      write(io8,'(''Stuck position '',5(1x,i7))')
     $          (nstk_posn(ii),ii=1,5)
      write(io8,'(''Stuck time&posn'',5(1x,i7))')
     $          (nstk_both(ii),ii=1,5)
      write(io8,'(''Stuck latitude '',5(1x,i7))')
     $          (nstk_alat(ii),ii=1,5)
      write(io8,'(''Stuck longitude'',5(1x,i7))')
     $          (nstk_alon(ii),ii=1,5)
      write(io8,'(''Stuck pressure '',5(1x,i7))')
     $          (nstk_pres(ii),ii=1,5)
      write(io8,'(''Stuck values   '',5(1x,i7))')
     $          (nstk_val(ii),ii=1,5)
      write(io8,'(''Stuck temp     '',5(1x,i7))')
     $          (nstk_temp(ii),ii=1,5)
      write(io8,'(''Stuck direction'',5(1x,i7))')
     $          (nstk_wdir(ii),ii=1,5)
      write(io8,'(''Stuck speed    '',5(1x,i7))')
     $          (nstk_wspd(ii),ii=1,5)
      write(io8,'(''Stuck moisture '',5(1x,i7))')
     $          (nstk_moist(ii),ii=1,5)
      write(io8,'(1x,a55)')
     $ '--------------- ------- ------- ------- ------- -------'
c
      kbadtot = kbad(1) + kbad(2) + kbad(3)
     $        + kbad(4) + kbad(5) 
c
      write(io8,*)
      write(io8,*) numreps,' good reports processed'
      write(io8,*) kbadtot,' reports failed qc in stuck value check'
c
      return
      end
c
c ###################################################################
c                            subroutine grchek_qc
c ###################################################################
c   
      subroutine grchek_qc(numreps,max_reps,indx,csort,amiss,cdtg_an
     $,          c_acftreg,c_acftid,c_qc
     $,          alat,alon,pres,ht_ft,t_prcn,ob_t,ob_q,ob_dir,ob_spd
     $,          xiv_t,xiv_q,xiv_d,xiv_s
     $,          idt,itype,ichk_t,ichk_q,ichk_d,ichk_s
     $,          cbadtemp,nbadtemp
     $,          cblkwind,nblkwind,cblktemp,nblktemp,kbadtot,io8,io34
     $,          maxflt,kreg,creg_reg,nwhol_reg,nwind_reg
     $,          ft2m,l_operational,l_init)
c
c Perform gross checks on aircraft data
c 
      implicit none
c
c Declaration statements
c ----------------------
      integer      max_reps            ! maximum number of reports
c
      character*11 c_qc(max_reps)      ! internal qc flags
c
c     Data arrays
c     -----------
      integer      numreps             ! actual number of reports
      character*10 cdtg_an             ! date time group for analysis
      integer      itype(max_reps)     ! type of aircraft data
      integer      idt(max_reps)       ! time in seconds to analysis time 
      character*8  c_acftreg(max_reps) ! aircraft registration (tail) number
      character*9  c_acftid(max_reps)  ! aircraft flight number
      real*8       alat(max_reps)      ! latitude
     $,            alon(max_reps)      ! longitude
      real         pres(max_reps)      ! pressure
     $,            ht_ft(max_reps)     ! height in feet
      real         t_prcn(max_reps)    ! temperature precision
      real         ob_t(max_reps)      ! temperature
     $,            ob_q(max_reps)      ! specific humidity
     $,            ob_dir(max_reps)    ! wind direction
     $,            ob_spd(max_reps)    ! wind speed
      real         xiv_t(max_reps)     ! temperature innovation (ob - bk)
     $,            xiv_q(max_reps)     ! specific humidity innovation (ob - bk)
     $,            xiv_d(max_reps)     ! wind direction innovation (ob - bk)
     $,            xiv_s(max_reps)     ! wind speed innovation (ob - bk)
      integer      ichk_t(max_reps)    ! NRL QC flag for temperature ob
     $,            ichk_q(max_reps)    ! NRL QC flag for specific humidity ob
     $,            ichk_d(max_reps)    ! NRL QC flag for wind direction ob
     $,            ichk_s(max_reps)    ! NRL QC flag for wind speed ob
      character*25 csort(max_reps)     ! sort variable    
c
c     Pointers
c     --------
      integer      indx(max_reps)      ! pointer index for good reports
c
c     Tail number statistics
c     ----------------------
      integer      kreg                ! actual number of tail#s in dataset
     $,            mm                  ! index pointing to current tail number
      integer      maxflt              ! max number of flights allowed
      character*8  creg_reg(maxflt)    ! tail numbers
      integer      nwhol_reg(maxflt,5) ! number of reports w. temp in whole deg
      integer      nwind_reg(maxflt,5) ! number of reports w. rejected winds
c
c     Functions
c     ---------
      character*16 c_insty_ob          ! function to convert integer instrument 
                                       !   type to character instrument type
      integer      insty_ob_fun        ! function to convert character
                                       !   instrument type to integer
c
c     Black list arrays
c     -----------------
      integer      nbadtemp            ! # of acft with temps in whole degrees
     $,            nblkwind            ! # of acft blacklisted for wind errors
     $,            nblktemp            ! # of acft blacklisted for temp errors
      character*8  cbadtemp(nbadtemp)  ! acft reports temp in whole deg C
     $,            cblkwind(nblkwind)  ! winds blacklisted
     $,            cblktemp(nblktemp)  ! temperatures blacklisted
c
c     Other variables
c     ---------------
      integer      io8                 ! i/o unit number for log file
      integer      io34                ! i/o unit number for gross errors
c
      real         amiss               ! real missing value flag
c
      integer      iob                 ! do loop index 
     $,            ii                  ! index pointing to current report
     $,            iim1                ! index pointing to previous report
     $,            iip1                ! index pointing to following report
      integer      idt1_00z            ! relative time equal to 00Z (pos) 
     $,            idt2_00z            ! relative time equal to 00Z (neg)
c
      integer      nac                 ! do loop index
      integer      nrep(5)             ! number of reports considered
      integer      kbad(5)             ! counter for number of bad reports
     $,            n_sus_time(5)       ! counter for suspect times
     $,            n_bad_pos(5)        ! counter for bad latitudes or longitudes
     $,            n_sus_lat(5)        ! counter for suspect latitudes
     $,            n_sus_lon(5)        ! counter for suspect longitudes
     $,            n_sus_alt(5)        ! counter for suspect altitudes
     $,            n_bad_alt(5)        ! counter for bad altitudes/pressures
     $,            n_inc_alt(5)        ! counter for inconsistent altitudes
     $,            n_bad_UAL(5)        ! counter for bad UAL surface reports
     $,            n_list_temp(5)      ! counter for black-listed temperatures
     $,            n_whole_temp(5)     ! counter for whole-degree temperatures
     $,            n_mis_temp(5)       ! counter for missing temperatures
     $,            n_bad_temp(5)       ! counter for bad temperatures
     $,            n_cold_temp(5)      ! counter for anomalous cold temperatures
     $,            n_list_wind(5)      ! counter for black-listed winds
     $,            n_mis_dir(5)        ! counter for missing directions
     $,            n_bad_dir(5)        ! counter for bad directions
     $,            n_inc_dir(5)        ! counter for inconsistent directions
     $,            n_mis_spd(5)        ! counter for missing speeds
     $,            n_inc_spd(5)        ! counter for inconsistent speeds
     $,            n_calm_spd(5)       ! counter for rejected calm speeds
     $,            n_bad_spd(5)        ! counter for bad speeds
     $,            n_mis_moist(5)      ! counter for missing moisture
     $,            n_bad_moist(5)      ! counter for bad moisture
     $,            n_sus_moist(5)      ! counter for suspect moisture
     $,            n_bad_rep(5)        ! counter for reports with both bad winds
                                       !     and bad temperatures
     $,            kbadtot             ! counter for total number of bad reps
c
      real         tmax                ! max allowable temperature
     $,            tmin                ! min allowable temperature
     $,            wmax                ! max allowable windspeed
     $,            ft2m                ! ft to meters conversion factor
     $,            height_ft           ! computed height in feet
     $,            height_m            ! computed height in meters
     $,            t                   ! temperature in centigrade
     $,            es                  ! saturation vapor pressure
     $,            qs                  ! saturation specific humidity
c
ccccdak      integer      i_acars             ! instrument type for acars
      integer      i_acars             ! instrument type for tamdar
ccccdak     $,            i_acars_lvl         ! instrument type for acars--level flt
     $,            i_acars_lvl         ! instrument type for tamdar--level flt
ccccdak     $,            i_acars_asc         ! instrument type for acars--ascent
     $,            i_acars_asc         ! instrument type for tamdar--ascent
ccccdak     $,            i_acars_des         ! instrument type for acars--descent
     $,            i_acars_des         ! instrument type for tamdar--descent
     $,            i_mdcrs             ! instrument type for mdcrs
     $,            i_mdcrs_lvl         ! instrument type for mdcrs--level flt
     $,            i_mdcrs_asc         ! instrument type for mdcrs--ascent
     $,            i_mdcrs_des         ! instrument type for mdcrs--descent
     $,            i_man_airep         ! instrument type for manual aireps
     $,            i_man_Yairep        ! instrument type for manual aireps (YRXX)
     $,            i_airep             ! instrument type for airep
     $,            i_airep_lvl         ! instrument type for airep--level flt
     $,            i_airep_asc         ! instrument type for airep--ascent
     $,            i_airep_des         ! instrument type for airep--descent
     $,            i_amdar             ! instrument type for amdar
     $,            i_amdar_lvl         ! instrument type for amdar--level flt
     $,            i_amdar_asc         ! instrument type for amdar--ascent
     $,            i_amdar_des         ! instrument type for amdar--descent
      integer      ktype               ! instrument type index
c
c     Switches
c     --------
      logical      l_print             ! print values if true
     $,            l_init              ! initialize counters if true
ccccdak     $,            l_ii_acars          ! true if ii rep is type acars
     $,            l_ii_acars          ! true if ii rep is type tamdar
     $,            l_ii_mdcrs          ! true if ii rep is type mdcrs
     $,            l_ii_airep          ! true if ii rep is type airep
     $,            l_ii_man            ! true if ii rep is type manual airep
     $,            l_ii_amdar          ! true if ii rep is type amdar
     $,            l_operational       ! run QC in operational mode if true
c
c # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # #
c
c Initialize variables
c --------------------
      if(l_init) then
        nrep = 0
        n_sus_time = 0
        n_bad_pos = 0
        n_sus_lat = 0
        n_sus_lon = 0
        n_sus_alt = 0
        n_bad_alt = 0
        n_inc_alt = 0
        n_bad_UAL = 0
        n_list_temp = 0
        n_mis_temp = 0
        n_bad_temp = 0
        n_cold_temp = 0
        n_list_wind = 0
        n_mis_dir = 0
        n_bad_dir = 0
        n_inc_dir = 0
        n_mis_spd = 0
        n_inc_spd = 0
        n_calm_spd = 0
        n_bad_spd = 0
        n_mis_moist = 0
        n_bad_moist = 0
        n_sus_moist = 0
        n_bad_rep = 0
        n_whole_temp = 0
        kbad = 0
      endif
c
      nwhol_reg = 0
      nwind_reg = 0
c
c Compute relative time equal to 00z
c ----------------------------------
      read(cdtg_an,'(8x,i2)') idt1_00z
      idt1_00z = idt1_00z * 3600 
      idt2_00z = 0 - idt1_00z 
c
c Initialize aircraft data types
c ------------------------------
      i_acars      = insty_ob_fun('acars')
      i_acars_lvl  = insty_ob_fun('acars_lvl') 
      i_acars_asc  = insty_ob_fun('acars_asc') 
      i_acars_des  = insty_ob_fun('acars_des') 
      i_mdcrs      = insty_ob_fun('mdcrs')
      i_mdcrs_lvl  = insty_ob_fun('mdcrs_lvl') 
      i_mdcrs_asc  = insty_ob_fun('mdcrs_asc') 
      i_mdcrs_des  = insty_ob_fun('mdcrs_des')
      i_man_airep  = insty_ob_fun('man-airep') 
      i_man_Yairep = insty_ob_fun('man-Yairep') 
      i_airep      = insty_ob_fun('airep')
      i_airep_lvl  = insty_ob_fun('airep_lvl')
      i_airep_asc  = insty_ob_fun('airep_asc')
      i_airep_des  = insty_ob_fun('airep_des')
      i_amdar      = insty_ob_fun('amdar')
      i_amdar_lvl  = insty_ob_fun('amdar_lvl')
      i_amdar_asc  = insty_ob_fun('amdar_asc')
      i_amdar_des  = insty_ob_fun('amdar_des')
c
c Loop over reports
c -----------------
      do iob=1,numreps
        ii = indx(iob)
        l_print = .false.
c
c Set up logical variables used in testing
c ----------------------------------------
        l_ii_mdcrs = .false.
        l_ii_acars = .false.
        l_ii_amdar = .false.
        l_ii_airep = .false.
        l_ii_man   = .false.
c
c       ii report is MDCRS?
c       -------------------
        if(itype(ii).eq.i_mdcrs.or.
     $     itype(ii).eq.i_mdcrs_lvl.or.
     $     itype(ii).eq.i_mdcrs_des.or.
     $     itype(ii).eq.i_mdcrs_asc) then
          l_ii_mdcrs = .true.
          ktype = 1
c
ccccdak       report is ACARS?
c       report is TAMDAR?
c       -------------------
        elseif(itype(ii).eq.i_acars.or.
     $         itype(ii).eq.i_acars_lvl.or.
     $         itype(ii).eq.i_acars_des.or.
     $         itype(ii).eq.i_acars_asc) then
          l_ii_acars = .true.
          ktype = 2
c
c       ii report is AMDAR?
c       -------------------
        elseif(itype(ii).eq.i_amdar.or.
     $         itype(ii).eq.i_amdar_lvl.or.
     $         itype(ii).eq.i_amdar_des.or.
     $         itype(ii).eq.i_amdar_asc) then
          l_ii_amdar = .true.
          ktype = 3
c
c       ii report is AIREP?
c       -------------------
        elseif(itype(ii).eq.i_airep.or.
     $         itype(ii).eq.i_airep_lvl.or.
     $         itype(ii).eq.i_airep_des.or.
     $         itype(ii).eq.i_airep_asc) then
          l_ii_airep = .true.
          ktype = 4
c
c       ii report is manual AIREP?
c       --------------------------
        elseif(itype(ii).eq.i_man_airep.or.
     $         itype(ii).eq.i_man_Yairep) then
          l_ii_man = .true.
          ktype = 5
        endif
c
c Compute height in feet from pressure for pressure/altitude check
c ----------------------------------------------------------------
        call p2ht_qc(pres(ii),height_m,amiss)
        call ht2fl_qc(height_m,height_ft,amiss,ft2m)
c
c        write(io8,*) 'p2ht test--tail#,pressure,computed ht,obs ht'
c        write(io8,*) c_acftreg(ii),pres(ii),height_ft,ht_ft(ii)
c
c First perform checks that reject the whole report
c -------------------------------------------------
c
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
c Reject reports with unphysical latitudes
c ----------------------------------------
        if(alat(ii).gt.90.0.or.alat(ii).lt.-90.0) then
          l_print = .true.
          if(l_print) write(io8,*) 'Latitude bad'
          c_qc(ii)(3:3) = 'B'
          n_bad_pos(ktype) = n_bad_pos(ktype) + 1
c
c Reject reports with unphysical longitudes
c -----------------------------------------
        elseif(alon(ii).gt.360.0.or.alon(ii).lt.0.0) then
          l_print = .true.
          if(l_print) write(io8,*) 'Longitude bad'
          c_qc(ii)(4:4) = 'B'
          n_bad_pos(ktype) = n_bad_pos(ktype) + 1
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
c
c Reject reports with unphysical or inconsistent pressures/altitudes
c ------------------------------------------------------------------
        elseif(pres(ii).gt.1080..or.pres(ii).lt.50.) then
          l_print = .true.
          if(l_print) write(io8,*) 'Pressure bad'
          if(c_qc(ii)(5:5).eq.'R') pres(ii) = amiss
          if(c_qc(ii)(5:5).eq.'r') ht_ft(ii) = amiss
          c_qc(ii)(5:5) = 'B'
          n_bad_alt(ktype) = n_bad_alt(ktype) + 1
c
        elseif(abs(height_ft-ht_ft(ii)).gt.25.0) then
          l_print = .true.
          if(l_print) write(io8,*) 'Pressure and height inconsistent'
          c_qc(ii)(5:5) = 'I'
          n_inc_alt(ktype) = n_inc_alt(ktype) + 1
c
c Reject surface UAL aireps
c (1/27/00)  These are actually erroneous reports from UAL Airbus A320/A319
c            aircraft that Tinker has incorrectly re-encoded into AIREP format.
c            In these reports, the altitude is divided by 10, temperature is
c            missing, the values listed as windspeed are actually wind 
c            direction, and it's not clear what is listed as wind direction.
c -----------------------------------------------------------------------------
        elseif((l_ii_man.or.l_ii_airep).and.
     $         c_acftid(ii)(1:3).eq.'UAL'.and.
     $         ht_ft(ii).lt.5000.0.and.
     $         ob_t(ii).eq.amiss) then
          l_print = .true.
          if(l_print) write(io8,*) 'Bad UAL surface report'
          c_qc(ii)(1:1) = 'B'
          n_bad_UAL(ktype) = n_bad_UAL(ktype) + 1
c
c Now, perform checks on individual parameters in remaining reports
c -----------------------------------------------------------------
        else
c
c Exclude missing temperatures
c ----------------------------
          if(ob_t(ii).eq.amiss) then
c            l_print = .true.
            if(l_print) write(io8,*) 'Temperature missing'
            c_qc(ii)(6:6) = 'M'
            n_mis_temp(ktype) = n_mis_temp(ktype) + 1
c
c Check list of aircraft reporting temperature in whole deg
c Re-compute temperature to correct
c (Since most of the aircraft were fixed by mid-1999, stop
c   doing this check after 1 Oct 1999)
c ---------------------------------------------------------
          elseif(cdtg_an.lt.'1999100100') then
            do nac = 1,nbadtemp
              if(c_acftreg(ii).eq.cbadtemp(nac)) then
c               l_print = .true.
                if(l_print) write(io8,*)'On list with temp in whole deg'
                c_qc(ii)(10:10) = 'C'
c
ccccdak               Recompute temperature for ACARS or MDCRS reports
c               Recompute temperature for TAMDAR or MDCRS reports
c               (Since AIREPs are reported only to nearest degree,
c                don't bother to recompute temperature--inadequate precision!)
c               ---------------------------------------------------------------------
c
c               Don't bother with temperatures already fixed or rejected
c               --------------------------------------------------------
                if(c_qc(ii)(6:6).ne.'R'.and.
     $             c_qc(ii)(6:6).ne.'b'.and.
     $             c_qc(ii)(6:6).ne.'E'.and.
     $             c_qc(ii)(6:6).ne.'I'.and.
     $             c_qc(ii)(6:6).ne.'K') then
c
c                 If temperatures are outside of limits, assume that the
c                   error was corrected on this aircraft
c                 ------------------------------------------------------
                  if(ob_t(ii).lt.266.0.or.ob_t(ii).gt.278.0) then
                    l_print = .true.
                    if(l_print) then
                      write(io8,*) 'On list with temp in whole deg'
                      write(io8,*) '  Temperature not within bounds!!!'
                    endif
c
ccccdak                 If bad temperature occurred in an ACARS, MDCRS, or
c                 If bad temperature occurred in an TAMDAR, MDCRS, or
c                   AMDAR report, fix it
c                 ---------------------------------------------------
                  elseif(l_ii_acars.or.l_ii_mdcrs.or.l_ii_amdar) then
                    ob_t(ii) = (ob_t(ii) - 273.16) * 10. + 273.16
                    l_print = .true.
                    if(l_print) write(io8,*) ' temperature recomputed'
                    t_prcn(ii) = 1.00
                    c_qc(ii)(6:6) = 'R'
                    n_whole_temp(ktype) = n_whole_temp(ktype) + 1
c
c                   Count number of whole-degree temps by tail number
c                   -------------------------------------------------
                    mm = 1
                    do while(mm.le.kreg)
                      if(c_acftreg(ii).eq.creg_reg(mm)) then 
                        nwhol_reg(mm,ktype) = nwhol_reg(mm,ktype) + 1
                        mm = kreg + 1
                      endif
                      mm = mm + 1
                    enddo
c
c                 If bad temperature occurred in an AIREP, reject it
c                 --------------------------------------------------
                  else
                    l_print = .true.
                    if(l_print) then
                      write(io8,*) 'On list with temp in whole deg'
                      write(io8,*) '  temperature marked bad'
                    endif
                    c_qc(ii)(6:6) = 'b'
                    n_whole_temp(ktype) = n_whole_temp(ktype) + 1
                  endif
                endif
c
              endif
            enddo
          endif
c
c QC temperature--Moninger algorithm
c ----------------------------------
          if(c_qc(ii)(6:6).ne.'b'.and.
     $       c_qc(ii)(6:6).ne.'E'.and.
     $       c_qc(ii)(6:6).ne.'I'.and.
     $       c_qc(ii)(6:6).ne.'K'.and.
     $       c_qc(ii)(6:6).ne.'B'.and.
     $       c_qc(ii)(6:6).ne.'M') then
c
c Check for anomalously cold temperatures accompanied by missing winds
c --------------------------------------------------------------------
            if(ob_t(ii).lt.205.0.and.
     $         ob_spd(ii).eq.amiss.and.
     $         ob_dir(ii).eq.amiss) then
              l_print = .true.
              if(l_print) then
                write(io8,*)
                write(io8,*) 'Cold temperature with missing winds'
              endif
              c_qc(ii)(6:6) = 'B'
              n_cold_temp(ktype) = n_cold_temp(ktype) + 1
c
c           QC upper-level temperatures
c           ---------------------------
            else
              if(ht_ft(ii).gt.35000.) then
                if(ob_t(ii).gt.253.16-0.005.or.
     $             ob_t(ii).lt.173.15+0.005) then
                  l_print = .true.
                  if(l_print) write(io8,*) 'Temperature bad--173  253'
                  c_qc(ii)(6:6) = 'B'
                  n_bad_temp(ktype) = n_bad_temp(ktype) + 1
c
                else
                  if(c_qc(ii)(6:6).eq.'-') c_qc(ii)(6:6) = '.'
                endif
c
c             QC lower-level temperatures
c             ---------------------------
              else
                tmax =  60. - 80. * (ht_ft(ii)           / 35000.)
                tmax = tmax + 273.16
                tmin = -60. - 40. * (ht_ft(ii) - 18000.) / 17000.
                tmin = tmin + 273.16
                if(ht_ft(ii).lt.18000.) tmin = 213.16
                if(ob_t(ii).gt.tmax.or.ob_t(ii).lt.tmin) then
                  l_print = .true.
                  if(l_print) write(io8,*) 'Temperature bad--',tmin,tmax
                  c_qc(ii)(6:6) = 'B'
                  n_bad_temp(ktype) = n_bad_temp(ktype) + 1
c
                else
                  if(c_qc(ii)(6:6).eq.'-') c_qc(ii)(6:6) = '.'
                endif
              endif
            endif
          endif
c
c Check if aircraft is on black list for temp errors
c --------------------------------------------------
          if(c_qc(ii)(10:10).eq.'-') c_qc(ii)(10:10) = '.'
c
          do nac = 1,nblktemp
            if(c_acftreg(ii).eq.cblktemp(nac)) then
c              l_print = .true.
              if(l_print) write(io8,*) 'Black-listed for temp errors'
              c_qc(ii)(10:10) = 'T'
              n_list_temp(ktype) = n_list_temp(ktype) + 1
            endif
          enddo
cc
cc QC temperature--RAOB algorithm
cc ------------------------------
c        if(ob_t(ii).ne.amiss) then
cc     $     c_qc(ii)(6:6).ne.'b'.and.
cc     $     c_qc(ii)(6:6).ne.'E'.and.
cc     $     c_qc(ii)(6:6).ne.'I'.and.
cc     $     c_qc(ii)(6:6).ne.'K') then
c
c          if(pres(ii).le.300.0.or.
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
c     $       (pres(ii).le.400.0.and.alat(ii).gt.45.0)) then
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
c            if(ob_t(ii).le.173.15.or.ob_t(ii).ge.268.15) then
c              l_print = .true.
c              if(l_print) write(io8,*) 'Temperature bad by RAOB check'
c              if(l_print.and.c_qc(ii)(6:6).ne.'B')
c     $          write(io8,*) '  Report not rejected by Moninger check'
c            endif
cc
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
c          elseif(abs(alat(ii)).le.45.0) then
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
c            if(pres(ii).le.400.) then
c              tmax = 268.15 + (pres(ii) - 300.) / 100. * 5.0
c              if(ob_t(ii).le.173.15.or.ob_t(ii).ge.tmax) then
c                l_print = .true.
c                if(l_print) write(io8,*) 'Temperature bad by RAOB check'
c                if(l_print.and.c_qc(ii)(6:6).ne.'B')
c     $            write(io8,*) '  Report not rejected by Moninger check'
c              endif
c            elseif(pres(ii).le.500.0) then
c              tmin = 173.16 + (pres(ii) - 400.) / 100. * 5.0
c              tmax = 273.16 + (pres(ii) - 400.) / 100. * 10.0
c              if(ob_t(ii).le.tmin.or.ob_t(ii).ge.tmax) then
c                l_print = .true.
c                if(l_print) write(io8,*) 'Temperature bad by RAOB check'
c                if(l_print.and.c_qc(ii)(6:6).ne.'B')
c     $            write(io8,*) '  Report not rejected by Moninger check'
c              endif
c            elseif(pres(ii).le.700.0) then
c              tmin = 178.15 + (pres(ii) - 500.) / 200. * 15.0
c              tmax = 283.15 + (pres(ii) - 500.) / 200. * 20.0
c              if(ob_t(ii).le.tmin.or.ob_t(ii).ge.tmax) then
c                l_print = .true.
c                if(l_print) write(io8,*) 'Temperature bad by RAOB check'
c                if(l_print.and.c_qc(ii)(6:6).ne.'B')
c     $            write(io8,*) '  Report not rejected by Moninger check'
c              endif
c            elseif(pres(ii).le.850.0) then
c              tmin = 193.15 + (pres(ii) - 700.) / 150. * 15.0
c              tmax = 303.15 + (pres(ii) - 700.) / 150. * 10.0
c              if(ob_t(ii).le.tmin.or.ob_t(ii).ge.tmax) then
c                l_print = .true.
c                if(l_print) write(io8,*) 'Temperature bad by RAOB check'
c                if(l_print.and.c_qc(ii)(6:6).ne.'B')
c     $            write(io8,*) '  Report not rejected by Moninger check'
c              endif
c            elseif(pres(ii).le.1000.0) then
c              tmin = 208.15 + (pres(ii) - 850.) / 150. * 15.0
c              tmax = 313.15 + (pres(ii) - 850.) / 150. * 20.0
c              if(ob_t(ii).le.tmin.or.ob_t(ii).ge.tmax) then
c                l_print = .true.
c                if(l_print) write(io8,*) 'Temperature bad by RAOB check'
c                if(l_print.and.c_qc(ii)(6:6).ne.'B')
c     $            write(io8,*) '  Report not rejected by Moninger check'
c              endif
c            elseif(pres(ii).gt.1000.0) then
c              if(ob_t(ii).le.223.15.or.ob_t(ii).ge.333.15) then
c                l_print = .true.
c                if(l_print) write(io8,*) 'Temperature bad by RAOB check'
c                if(l_print.and.c_qc(ii)(6:6).ne.'B')
c     $            write(io8,*) '  Report not rejected by Moninger check'
c              endif
c            endif
cc
c          else
c            if(pres(ii).le.500.0) then
c              tmax = 268.15 + (pres(ii) - 400.) / 100. * 10.0
c              if(ob_t(ii).le.173.15.or.ob_t(ii).ge.tmax) then
c                l_print = .true.
c                if(l_print) write(io8,*) 'Temperature bad by RAOB check'
c                if(l_print.and.c_qc(ii)(6:6).ne.'B')
c     $            write(io8,*) '  Report not rejected by Moninger check'
c              endif
c            elseif(pres(ii).le.700.0) then
c              tmin = 173.15 + (pres(ii) - 500.) / 200. * 10.0
c              tmax = 278.15 + (pres(ii) - 500.) / 200. * 15.0
c              if(ob_t(ii).le.tmin.or.ob_t(ii).ge.tmax) then
c                l_print = .true.
c                if(l_print) write(io8,*) 'Temperature bad by RAOB check'
c                if(l_print.and.c_qc(ii)(6:6).ne.'B')
c     $            write(io8,*) '  Report not rejected by Moninger check'
c              endif
c            elseif(pres(ii).le.850.0) then
c              tmax = 293.15 + (pres(ii) - 700.) / 150. * 10.0
c              if(ob_t(ii).le.183.15.or.ob_t(ii).ge.tmax) then
c                l_print = .true.
c                if(l_print) write(io8,*) 'Temperature bad by RAOB check'
c                if(l_print.and.c_qc(ii)(6:6).ne.'B')
c     $            write(io8,*) '  Report not rejected by Moninger check'
c              endif
c            elseif(pres(ii).le.1000.0) then
c              tmax = 303.15 + (pres(ii) - 850.) / 150. * 20.0
c              if(ob_t(ii).le.183.15.or.ob_t(ii).ge.tmax) then
c                l_print = .true.
c                if(l_print) write(io8,*) 'Temperature bad by RAOB check'
c                if(l_print.and.c_qc(ii)(6:6).ne.'B')
c     $            write(io8,*) '  Report not rejected by Moninger check'
c              endif
c            elseif(pres(ii).gt.1000.0) then
c              if(ob_t(ii).le.183.15.or.ob_t(ii).ge.323.15) then
c                l_print = .true.
c                if(l_print) write(io8,*) 'Temperature bad by RAOB check'
c                if(l_print.and.c_qc(ii)(6:6).ne.'B')
c     $            write(io8,*) '  Report not rejected by Moninger check'
c              endif
c            endif
c
c          endif
c        endif
c
c         Perform remaining tests only if temperature not rejected
c         --------------------------------------------------------
          if(c_qc(ii)(6:6).ne.'B') then
cc
cc Check list of aircraft flipping winds
cc (Test skipped since list of aircraft used actual tail numbers 
cc    rather than pseudo-numbers!)
cc -------------------------------------
c        do nac = 1,nbadwind
c          if(c_acftreg(ii).eq.cbadwind(nac)) then
c            write(io8,*)
c            write(io8,*) c_acftreg(ii),' in rep # ',ii,
c     $                ' on list of acft with flipped winds'
c            c_qc(ii)(10:10) = 'F'
c          endif
c        enddo
cc
cc Check list of aircraft reporting decimal lat/lons
cc No correction performed at present
cc (Test skipped since list of aircraft used actual tail numbers 
cc    rather than the pseudo-numbers used currently!)
cc -------------------------------------------------------------
c        do nac = 1,nbadlat
c          if(c_acftreg(ii).eq.cbadlat(nac)) then
c            write(io8,*)
c            write(io8,*) c_acftreg(ii),' in rep # ',ii,
c     $                ' on list of acft with decimal lat/lons'
c            c_qc(ii)(10:10) = 'L'
c          endif
c        enddo
c
c QC relative time
c ----------------
            if(idt(ii).eq.idt1_00z.or.
     $         idt(ii).eq.idt2_00z) then
c              l_print = .true.
              if(l_print) write(io8,*) 'Time equal to 00Z'
              c_qc(ii)(2:2) = 'S'
              n_sus_time(ktype) = n_sus_time(ktype) + 1
            else
              if(c_qc(ii)(2:2).eq.'-') c_qc(ii)(2:2) = '.'
            endif
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
c
c QC latitude
c -----------
            if(abs(alat(ii)).lt.0.005) then
              l_print = .false.
              if(l_print) write(io8,*) 'Latitude zero'
              c_qc(ii)(3:3) = 'S'
              n_sus_lat(ktype) = n_sus_lat(ktype) + 1
            else
              if(c_qc(ii)(3:3).eq.'-') c_qc(ii)(3:3) = '.'
            endif
c
c QC longitude
c ------------
            if(abs(alon(ii)).lt.0.005) then
              l_print = .false.
              if(l_print) write(io8,*) 'Longitude zero'
              c_qc(ii)(4:4) = 'S'
              n_sus_lon(ktype) = n_sus_lon(ktype) + 1
            else
              if(c_qc(ii)(4:4).eq.'-') c_qc(ii)(4:4) = '.'
            endif
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
c
c Set zero altitude to suspect
c ----------------------------
            if(abs(ht_ft(ii)).lt.0.5) then
              l_print = .true.
              if(l_print) write(io8,*) 'Altitude zero'
              c_qc(ii)(5:5) = 'S'
              n_sus_alt(ktype) = n_sus_alt(ktype) + 1
            else
              if(c_qc(ii)(5:5).eq.'-') c_qc(ii)(5:5) = '.'
            endif
c
c QC winds--Moninger algorithm
c ----------------------------
c
c           QC direction
c           ------------
c            if(ob_dir(ii).eq.0.0) then
c              ob_dir(ii) = 360.
c
            if(ob_dir(ii).eq.amiss) then
c              l_print = .true.
              if(l_print) write(io8,*) 'Wind direction missing'
              c_qc(ii)(7:7) = 'M'
              n_mis_dir(ktype) = n_mis_dir(ktype) + 1
c
            elseif(c_qc(ii)(7:7).ne.'K'.and.
     $             c_qc(ii)(7:7).ne.'E'.and.
     $             c_qc(ii)(7:7).ne.'B') then
              if(ob_dir(ii).lt.0.0.or.ob_dir(ii).gt.360.0) then
                l_print = .true.
                if(l_print) write(io8,*) 'Wind direction bad',ob_dir(ii)
                c_qc(ii)(7:7) = 'B'
                n_bad_dir(ktype) = n_bad_dir(ktype) + 1
c
c               Count number of rejected winds by tail number
c               ---------------------------------------------
                mm = 1
                do while(mm.le.kreg)
                  if(c_acftreg(ii).eq.creg_reg(mm)) then
                    nwind_reg(mm,ktype) = nwind_reg(mm,ktype) + 1
                    mm = kreg + 1
                  endif
                  mm = mm + 1
                enddo
c
              else
                if(c_qc(ii)(7:7).eq.'-') c_qc(ii)(7:7) = '.'
              endif
            endif
c
c           QC speed
c           --------
c
c           First flag missing wind speeds
c           ------------------------------
            if(ob_spd(ii).eq.amiss) then
c              l_print = .true.
              if(l_print) write(io8,*) 'Wind speed missing'
              c_qc(ii)(8:8) = 'M'
              n_mis_spd(ktype) = n_mis_spd(ktype) + 1
c
c             Flag inconsistent directions--speed missing, direction not
c             ----------------------------------------------------------
              if(c_qc(ii)(7:7).ne.'M'.and.
     $           c_qc(ii)(7:7).ne.'B'.and.
     $           c_qc(ii)(7:7).ne.'E'.and.
     $           c_qc(ii)(7:7).ne.'K') then
c                l_print = .true.
                if(l_print) write(io8,*) 'Wind direction not missing'
                c_qc(ii)(7:7) = 'I'
                n_inc_dir(ktype) = n_inc_dir(ktype) + 1
c
c               Count number of rejected winds by tail number
c               ---------------------------------------------
                mm = 1
                do while(mm.le.kreg)
                  if(c_acftreg(ii).eq.creg_reg(mm)) then
                    nwind_reg(mm,ktype) = nwind_reg(mm,ktype) + 1
                    mm = kreg + 1
                  endif
                  mm = mm + 1
                enddo
c
              endif
c
c           Exclude previously rejected wind speeds
c           ---------------------------------------
            elseif(c_qc(ii)(8:8).ne.'K'.and.
     $             c_qc(ii)(8:8).ne.'E') then
c
c             Flag inconsistent speeds--direction missing, speed not
c             ------------------------------------------------------
              if(ob_dir(ii).eq.amiss) then
c                l_print = .true.
                if(l_print) write(io8,*) 'Wind speed not missing'
                c_qc(ii)(8:8) = 'I'
                n_inc_spd(ktype) = n_inc_spd(ktype) + 1
c
c               Count number of rejected winds by tail number
c               ---------------------------------------------
                mm = 1
                do while(mm.le.kreg)
                  if(c_acftreg(ii).eq.creg_reg(mm)) then
                    nwind_reg(mm,ktype) = nwind_reg(mm,ktype) + 1
                    mm = kreg + 1
                  endif
                  mm = mm + 1
                enddo
c
c             Flag negative winds speeds
c             --------------------------
              elseif(ob_spd(ii).lt.0.0) then
                l_print = .true.
                if(l_print) write(io8,*) 'Wind speed negative'
                c_qc(ii)(8:8) = 'B'
                n_bad_spd(ktype) = n_bad_spd(ktype) + 1
c
c               Count number of rejected winds by tail number
c               ---------------------------------------------
                mm = 1
                do while(mm.le.kreg)
                  if(c_acftreg(ii).eq.creg_reg(mm)) then
                    nwind_reg(mm,ktype) = nwind_reg(mm,ktype) + 1
                    mm = kreg + 1
                  endif
                  mm = mm + 1
                enddo
c
c             Reject all calm winds
c             ---------------------
              elseif(ob_spd(ii).lt.0.05.and.
     $               ob_dir(ii).lt.0.05) then
c                if(pres(ii).lt.700.) l_print = .true.
                l_print = .false.
                if(l_print) write(io8,*) 'Wind speed and direction zero'
                c_qc(ii)(8:8) = 'B'
                n_calm_spd(ktype) = n_calm_spd(ktype) + 1
c
c               Count number of rejected winds by tail number
c               ---------------------------------------------
                mm = 1
                do while(mm.le.kreg)
                  if(c_acftreg(ii).eq.creg_reg(mm)) then
                    nwind_reg(mm,ktype) = nwind_reg(mm,ktype) + 1
                    mm = kreg + 1
                  endif
                  mm = mm + 1
                enddo
c
c             QC wind speeds
c             --------------
              else
                if(ht_ft(ii).lt.30000.) then
                  wmax = 70. + 230. * ht_ft(ii) / 30000.
                elseif(ht_ft(ii).lt.40000.) then
                  wmax = 300.
                elseif(ht_ft(ii).lt.45000.) then
                  wmax = 300. - 100. * (ht_ft(ii) - 40000.) / 5000.
                else
                  wmax = 200.
                endif
                wmax = wmax * 0.5144          ! convert max from knots to m/s
                if(ob_spd(ii).gt.wmax) then
                  l_print = .true.
                  if(l_print) write(io8,*) 'Wind speed > wmax = ',wmax
                  c_qc(ii)(8:8) = 'B'
                  n_bad_spd(ktype) = n_bad_spd(ktype) + 1
c
c                 Count number of rejected winds by tail number
c                 ---------------------------------------------
                  mm = 1
                  do while(mm.le.kreg)
                    if(c_acftreg(ii).eq.creg_reg(mm)) then
                      nwind_reg(mm,ktype) = nwind_reg(mm,ktype) + 1
                      mm = kreg + 1
                    endif
                    mm = mm + 1
                  enddo
c
                else
                  if(c_qc(ii)(8:8).eq.'-') c_qc(ii)(8:8) = '.'
                endif
              endif
            endif
c
c Check if aircraft is on black list for wind errors
c --------------------------------------------------
            do nac = 1,nblkwind
              if(c_acftreg(ii).eq.cblkwind(nac)) then
c                l_print = .true.
                if(l_print) write(io8,*) 'Black-listed for wind errors'
c
                if(c_qc(ii)(10:10).eq.'T') then
                  c_qc(ii)(10:10) = 'O'
                else
                  c_qc(ii)(10:10) = 'W'
                endif
                n_list_wind(ktype) = n_list_wind(ktype) + 1
              endif
            enddo
cc
cc QC speed--RAOB algorithm
cc ------------------------
c        if(ob_spd(ii).ne.amiss.and.
c     $     ob_spd(ii).ne.0.0.and.
c     $     c_qc(ii)(8:8).ne.'K'.and.
c     $     c_qc(ii)(8:8).ne.'E') then
cc
c          if(pres(ii).ge.700.0) then
c            if(ob_spd(ii).gt.100.0) then
c              l_print = .true.
c              if(l_print) write(io8,*) 'Windspeed bad by RAOB check'
c              if(l_print.and.c_qc(ii)(8:8).ne.'B')
c     $          write(io8,*) '  Report not rejected by Moninger check'
c            endif
cc
c          elseif(pres(ii).ge.500.0) then
c            wmax = 100.0 + (700.0 - pres(ii)) / 200. * 20.0
c            if(ob_spd(ii).ge.wmax) then
c              l_print = .true.
c              if(l_print) write(io8,*) 'Windspeed bad by RAOB check'
c              if(l_print.and.c_qc(ii)(8:8).ne.'B')
c     $          write(io8,*) '  Report not rejected by Moninger check'
c            endif
cc
c          elseif(pres(ii).ge.300.0) then
c            wmax = 120.0 + (500.0 - pres(ii)) / 200. * 60.0
c            if(ob_spd(ii).ge.wmax) then
c              l_print = .true.
c              if(l_print) write(io8,*) 'Windspeed bad by RAOB check'
c              if(l_print.and.c_qc(ii)(8:8).ne.'B')
c     $          write(io8,*) '  Report not rejected by Moninger check'
c            endif
cc
c          elseif(pres(ii).ge.200.0) then
c            if(ob_spd(ii).ge.180.0) then
c              l_print = .true.
c              if(l_print) write(io8,*) 'Windspeed bad by RAOB check'
c              if(l_print.and.c_qc(ii)(8:8).ne.'B')
c     $          write(io8,*) '  Report not rejected by Moninger check'
c            endif
cc
c          elseif(pres(ii).ge.100.0) then
c            if(ob_spd(ii).ge.170.0) then
c              l_print = .true.
c              if(l_print) write(io8,*) 'Windspeed bad by RAOB check'
c              if(l_print.and.c_qc(ii)(8:8).ne.'B')
c     $          write(io8,*) '  Report not rejected by Moninger check'
c            endif
c          endif
c        endif
c
c QC moisture
c -----------
c
c           Exclude values already flagged as constant
c           ------------------------------------------
            if(c_qc(ii)(9:9).ne.'K') then
c
c             Check for missing values
c             (treat moisture qc flag = 1 (non-measurement mode) as missing)
c             (treat moisture qc flag = 9 (sensor not installed) as missing)
c             --------------------------------------------------------------
              if(ob_q(ii).eq.amiss.or.
     $           ichk_q(ii).eq.-9.or.
     $           ichk_q(ii).eq.9.or.
     $           ichk_q(ii).eq.-1) then
c
c                l_print = .true.
                if(l_print) write(io8,*) 'Moisture not present'
                c_qc(ii)(9:9) = 'M'
                n_mis_moist(ktype) = n_mis_moist(ktype) + 1
c
c             Assume zero moisture with qc flag of 7 signify missing ob
c             ---------------------------------------------------------
              elseif(ob_q(ii).lt.0.005.and.ichk_q(ii).eq.-7) then
c
c                l_print = .true.
                if(l_print) write(io8,*) 'Moisture not present, = 0'
                c_qc(ii)(9:9) = 'M'
                n_mis_moist(ktype) = n_mis_moist(ktype) + 1
c
c             QC remaining values
c             -------------------
              else
c
                if(ichk_q(ii).ne. 0.and.
     $             ichk_q(ii).ne.-2.and.
     $             ichk_q(ii).ne.-3.and.
     $             ichk_q(ii).ne.-4.and.
     $             ichk_q(ii).ne.-5.and.
     $             ichk_q(ii).ne.-6.and.
     $             ichk_q(ii).ne.-7.and.
     $             ichk_q(ii).ne.-8.and.
     $             ichk_q(ii).ne.908) l_print = .true.
c
                if(l_print) 
     $            write(io8,*) 'Moisture qc flag = ',ichk_q(ii),ii
c
c               Compute saturation specific humidity to test for supersaturation
c               Reference: http://www.ofcm.gov/fmh3/text/appendd.htm
c               ----------------------------------------------------------------
                if(c_qc(ii)(6:6).ne.'K'.and.
     $             c_qc(ii)(6:6).ne.'E'.and.
     $             c_qc(ii)(6:6).ne.'I'.and.
     $             c_qc(ii)(6:6).ne.'M'.and.
     $             c_qc(ii)(6:6).ne.'B'.and.
     $             c_qc(ii)(6:6).ne.'b'.and.
     $             c_qc(ii)(10:10).ne.'T'.and.
     $             c_qc(ii)(10:10).ne.'O') then
c
                  t = ob_t(ii) - 273.16
c                     temperature in centigrade
                  es = 6.1121 * exp( (17.502 * t) / (t + 240.97) )
c                      saturation vapor pressure
                  qs = .622 * es / pres(ii) * 1000.
c                      saturation specific humidity (g/kg)
                else
                  qs = amiss
                endif
c
c               Examine values of moisture qc flag
c               (meaning of flag values is from BUFR table 0 33 26)
c                 (1 => Normal operations--non-measurement mode)
c                 (9 => Sensor not installed)
c                 (10-62 are reserved values; 63 => missing value)
c               ---------------------------------------------------
                if(ichk_q(ii).eq.-2) then
                  if(l_print) write(io8,*) '  Small RH'
                  c_qc(ii)(9:9) = '2'
c
                elseif(ichk_q(ii).eq.-3) then
                  if(l_print) write(io8,*) '  Element wet'
                  c_qc(ii)(9:9) = '3'
c
                elseif(ichk_q(ii).eq.-4) then
                  if(l_print) write(io8,*) '  Element contaminated'
                  c_qc(ii)(9:9) = 'B'
                  n_bad_moist(ktype) = n_bad_moist(ktype) + 1
c
                elseif(ichk_q(ii).eq.-5) then
                  if(l_print) write(io8,*) '  Heater failed'
                  c_qc(ii)(9:9) = 'B'
                  n_bad_moist(ktype) = n_bad_moist(ktype) + 1
c
                elseif(ichk_q(ii).eq.-6) then
                  if(l_print) 
     $              write(io8,*) '  Heater failed, wet/contam. element'
                  c_qc(ii)(9:9) = 'B'
                  n_bad_moist(ktype) = n_bad_moist(ktype) + 1
c
                elseif(ichk_q(ii).eq.-7) then
                  if(l_print) write(io8,*) '  Invalid input parameters '
                  c_qc(ii)(9:9) = 'B'
                  n_bad_moist(ktype) = n_bad_moist(ktype) + 1
c
                elseif(ichk_q(ii).eq.-8) then
                  if(l_print) write(io8,*) '  Numeric error'
                  c_qc(ii)(9:9) = 'B'
                  n_bad_moist(ktype) = n_bad_moist(ktype) + 1
c
                elseif(qs.eq.amiss) then
                  if(l_print) write(io8,*) '  Cannot check supersat.'
                  c_qc(ii)(9:9) = 'N'
c
                elseif(ob_q(ii)-qs.gt.0.01) then
	            l_print = .true.
                  if(l_print) 
     $            write(io8,*) '  Supersaturation present--qs = ',qs
                  c_qc(ii)(9:9) = 'S'
                  n_sus_moist(ktype) = n_sus_moist(ktype) + 1
c
                else
                  if(c_qc(ii)(9:9).eq.'-') c_qc(ii)(9:9) = '.'
                endif
              endif
            endif
          endif
        endif
c
c       Print offending report with neighbors if desired
c       ------------------------------------------------
        if(l_print) then
c
          if(iob.eq.1) then
            iim1 = 0
          else  
            iim1 = indx(iob-1)
          endif
c
          if(iob.eq.numreps) then
            iip1 = 0
          else
            iip1 = indx(iob+1)
          endif
c
          if(iim1.ne.0) write (io8,8001) iim1,c_insty_ob(itype(iim1))
     x,      c_acftreg(iim1),c_acftid(iim1)
     x,      idt(iim1),alat(iim1),alon(iim1),pres(iim1),ht_ft(iim1)
     x,      t_prcn(iim1),ob_t(iim1),xiv_t(iim1),ichk_t(iim1)
     x,      ob_q(iim1),xiv_q(iim1),ichk_q(iim1)
     x,      ob_dir(iim1),xiv_d(iim1),ichk_d(iim1)
     x,      ob_spd(iim1),xiv_s(iim1),ichk_s(iim1)
     x,      c_qc(iim1),csort(iim1)
c
          write (io8,8001) ii,c_insty_ob(itype(ii))
     x,      c_acftreg(ii),c_acftid(ii)
     x,      idt(ii),alat(ii),alon(ii),pres(ii),ht_ft(ii)
     x,      t_prcn(ii),ob_t(ii),xiv_t(ii),ichk_t(ii)
     x,      ob_q(ii),xiv_q(ii),ichk_q(ii)
     x,      ob_dir(ii),xiv_d(ii),ichk_d(ii)
     x,      ob_spd(ii),xiv_s(ii),ichk_s(ii)
     x,      c_qc(ii),csort(ii)
c
          if(iip1.ne.0) write (io8,8001) iip1,c_insty_ob(itype(iip1))
     x,      c_acftreg(iip1),c_acftid(iip1)
     x,      idt(iip1),alat(iip1),alon(iip1),pres(iip1),ht_ft(iip1)
     x,      t_prcn(iip1),ob_t(iip1),xiv_t(iip1),ichk_t(iip1)
     x,      ob_q(iip1),xiv_q(iip1),ichk_q(iip1)
     x,      ob_dir(iip1),xiv_d(iip1),ichk_d(iip1)
     x,      ob_spd(iip1),xiv_s(iip1),ichk_s(iip1)
     x,      c_qc(iip1),csort(iip1)
c
 8001     format(i6,1x,a8,1x,a8,1x,a9,1x
     x,      i7,1x,2f11.5,1x,f8.1,1x,f7.0,1x
     x,      f5.2,4(2(1x,f8.2),1x,i5)
     x,      1x,'!',a11,'!',1x,a25)
          write(io8,*)
        endif
c
c End loop over reports
c ---------------------
      enddo
c
c Write out and count bad data here
c ---------------------------------
      write(io34,*)
      write(io34,*) 'Data that failed gross checks'
      write(io34,*) '(rejected reports not included subsequently'
      write(io34,*) '-------------------------------------------'
      write(io34,3001)
 3001 format(' index  type    tail num   flight     time       lat'
     x,      '        lon       pres  height '
     x,      't-prcn   temp     innov  ichk'
     x,      ' spec hum    innov  ichk'
     x,      '   ob_dir    innov  ichk'
     x,      '   ob_spd    innov  ichk'
     x,      '   qc flag')
c
c     Loop over obs
c     -------------
      do iob=1,numreps
        ii = indx(iob)
c
        l_print = .false.
c
c       Set index
c       ---------
        if(itype(ii).eq.i_mdcrs.or.
     $     itype(ii).eq.i_mdcrs_asc.or.
     $     itype(ii).eq.i_mdcrs_lvl.or.
     $     itype(ii).eq.i_mdcrs_des) then
          ktype = 1
c
        elseif(itype(ii).eq.i_acars.or.
     $         itype(ii).eq.i_acars_asc.or.
     $         itype(ii).eq.i_acars_lvl.or.
     $         itype(ii).eq.i_acars_des) then
          ktype = 2
c
        elseif(itype(ii).eq.i_amdar.or.
     $         itype(ii).eq.i_amdar_asc.or.
     $         itype(ii).eq.i_amdar_lvl.or.
     $         itype(ii).eq.i_amdar_des) then
          ktype = 3
c
        elseif(itype(ii).eq.i_airep.or.
     $         itype(ii).eq.i_airep_asc.or.
     $         itype(ii).eq.i_airep_lvl.or.
     $         itype(ii).eq.i_airep_des) then
          ktype = 4
c
        elseif(itype(ii).eq.i_man_airep.or.
     $         itype(ii).eq.i_man_Yairep) then
          ktype = 5
c
        else
          write(io8,*)
          write(io8,*) 'Bad itype: ',itype(ii),' for ii = ',ii
          ktype = 5
        endif
c
c       Add up number of reports considered
c       -----------------------------------
        nrep(ktype) = nrep(ktype) + 1
c
c       Rejected reports
c       ----------------
        if(c_qc(ii)(3:3).eq.'B'.or.
     $     c_qc(ii)(4:4).eq.'B'.or.
     $     c_qc(ii)(5:5).eq.'B'.or.
     $     c_qc(ii)(5:5).eq.'I'.or.
     $     c_qc(ii)(1:1).eq.'B'.or.
     $     c_qc(ii)(6:6).eq.'B') then
c
          csort(ii)(1:5) = 'badob'
c
c       Invalid reports--no data
c       ------------------------
        elseif((c_qc(ii)(6:6).eq.'K'.or.
     $          c_qc(ii)(10:10).eq.'T'.or.
     $          c_qc(ii)(10:10).eq.'O'.or.
     $          c_qc(ii)(6:6).eq.'M'.or.
     $          c_qc(ii)(6:6).eq.'E'.or.
     $          c_qc(ii)(6:6).eq.'I'.or.
     $          c_qc(ii)(6:6).eq.'B'.or.
     $          c_qc(ii)(6:6).eq.'b').and.
c
     $         (c_qc(ii)(7:7).eq.'K'.or.
     $          c_qc(ii)(8:8).eq.'K'.or.
     $          c_qc(ii)(10:10).eq.'W'.or.
     $          c_qc(ii)(10:10).eq.'O'.or.
     $          c_qc(ii)(7:7).eq.'M'.or.
     $          c_qc(ii)(8:8).eq.'M'.or.
     $          c_qc(ii)(7:7).eq.'E'.or.
     $          c_qc(ii)(8:8).eq.'E'.or.
     $          c_qc(ii)(7:7).eq.'B'.or.
     $          c_qc(ii)(8:8).eq.'B'.or.
     $          c_qc(ii)(7:7).eq.'I'.or.
     $          c_qc(ii)(8:8).eq.'I')) then
c
          csort(ii)(1:5) = 'badob'
          n_bad_rep(ktype) = n_bad_rep(ktype) + 1
c
        endif
c
c       Output and count rejected obs
c       -----------------------------
        if(.not.l_operational) then
c
          if(csort(ii)(1:5).eq.'badob') then
            kbad(ktype) = kbad(ktype) + 1
c
            write(io34,3002) ii,c_insty_ob(itype(ii))
     x,        c_acftreg(ii),c_acftid(ii)
     x,        idt(ii),alat(ii),alon(ii),pres(ii),ht_ft(ii)
     x,        t_prcn(ii),ob_t(ii),xiv_t(ii),ichk_t(ii)
     x,        ob_q(ii),xiv_q(ii),ichk_q(ii)
     x,        ob_dir(ii),xiv_d(ii),ichk_d(ii)
     x,        ob_spd(ii),xiv_s(ii),ichk_s(ii)
     x,        c_qc(ii)
 3002       format(i6,1x,a8,1x,a8,1x,a9,1x
     x,      i7,1x,2f11.5,1x,f8.1,1x,f7.0,1x
     x,      f5.2,4(2(1x,f8.2),1x,i5)
     x,      1x,'!',a11,'!')
          endif
        endif
c
      enddo
c
c     Output tail number counts
c     -------------------------
      write(io8,*) 
      write(io8,*) '  Tail numbers for reports with temp in whole deg'
ccccdak      write(io8,*) '  Tail Num  MDCRS  ACARS  AMDAR  AIREP  MAN  '
      write(io8,*) '  Tail Num  MDCRS  TAMDAR AMDAR  AIREP  MAN  '
      write(io8,*) '  -------------------------------------------'
c
      do mm=1,kreg
        if( nwhol_reg(mm,1)+nwhol_reg(mm,2)+nwhol_reg(mm,3)
     $     +nwhol_reg(mm,4)+nwhol_reg(mm,5).gt.0) then
          write(io8,'(2x,a8,5(1x,i6))') 
     $      creg_reg(mm),(nwhol_reg(mm,ii),ii=1,5)
        endif
      enddo
c
      write(io8,*) 
      write(io8,*) '  Tail numbers for reports with bad winds'
ccccdak      write(io8,*) '  Tail Num  MDCRS  ACARS  AMDAR  AIREP  MAN  '
      write(io8,*) '  Tail Num  MDCRS  TAMDAR AMDAR  AIREP  MAN  '
      write(io8,*) '  -------------------------------------------'
c
      do mm=1,kreg
        if( nwind_reg(mm,1)+nwind_reg(mm,2)+nwind_reg(mm,3)
     $     +nwind_reg(mm,4)+nwind_reg(mm,5).gt.0) then
          write(io8,'(2x,a8,5(1x,i6))') 
     $      creg_reg(mm),(nwind_reg(mm,ii),ii=1,5)
        endif
      enddo
c
      write(*,*)
      write(*,*) 'Gross check data counts--',cdtg_an
      write(*,*) '-----------------------------------'
      write(*,'(1x,a55)')
ccccdak     $ 'Type of check     MDCRS   ACARS   AMDAR   AIREP     man'
     $ 'Type of check     MDCRS  TAMDAR   AMDAR   AIREP     man'
      write(*,'(1x,a55)')
     $ '--------------- ------- ------- ------- ------- -------'
      write(*,'('' Num considered '',5(1x,i7))')
     $            (nrep(ii),ii=1,5)
      write(*,'('' Total rejected '',5(1x,i7))')
     $           (kbad(ii),ii=1,5)
      write(*,'(1x,a55)')
     $ '--------------- ------- ------- ------- ------- -------'
c
      if(.not.l_operational) then
      write(io34,*)
      write(io34,*) 'Gross check data counts'
      write(io34,*) '-----------------------'
      write(io34,'(1x,a55)')
ccccdak     $ 'Type of check     MDCRS   ACARS   AMDAR   AIREP     man'
     $ 'Type of check     MDCRS  TAMDAR   AMDAR   AIREP     man'
      write(io34,'(1x,a55)')
     $ '--------------- ------- ------- ------- ------- -------'
      write(io34,'(''Num considered '',5(1x,i7))')
     $            (nrep(ii),ii=1,5)
      write(io34,'(''Total rejected '',5(1x,i7))')
     $           (kbad(ii),ii=1,5)
      write(io34,'(1x,a55)')
     $ '--------------- ------- ------- ------- ------- -------'
      endif
c
      write(io8,*)
      write(io8,*) 'Gross check data counts'
      write(io8,*) '-----------------------'
      write(io8,'(1x,a55)')
ccccdak     $ 'Type of check     MDCRS   ACARS   AMDAR   AIREP     man'
     $ 'Type of check     MDCRS  TAMDAR   AMDAR   AIREP     man'
      write(io8,'(1x,a55)')
     $ '--------------- ------- ------- ------- ------- -------'
      write(io8,'(''Num considered '',5(1x,i7))')
     $            (nrep(ii),ii=1,5)
      write(io8,'(''Total rejected '',5(1x,i7))')
     $           (kbad(ii),ii=1,5)
      write(io8,'(1x,a55)')
     $ '--------------- ------- ------- ------- ------- -------'
c
      write(io8,'(''Bad lat/lon    '',5(1x,i7))')
     $           (n_bad_pos(ii),ii=1,5)
      write(io8,'(''Bad alt        '',5(1x,i7))')
     $           (n_bad_alt(ii),ii=1,5)
      write(io8,'(''Incons alt     '',5(1x,i7))')
     $           (n_inc_alt(ii),ii=1,5)
      write(io8,'(''Bad sfc UAL    '',5(1x,i7))')
     $           (n_bad_UAL(ii),ii=1,5)
      write(io8,'(''Bad temp       '',5(1x,i7))')
     $           (n_bad_temp(ii),ii=1,5)
      write(io8,'(''Cold temp      '',5(1x,i7))')
     $           (n_cold_temp(ii),ii=1,5)
      write(io8,'(''Report bad     '',5(1x,i7))')
     $           (n_bad_rep(ii),ii=1,5)
      write(io8,'(1x,a55)')
     $ '--------------- ------- ------- ------- ------- -------'
      write(io8,'(''Wh-deg temp    '',5(1x,i7))')
     $           (n_whole_temp(ii),ii=1,5)
      write(io8,'(1x,a55)')
     $ '--------------- ------- ------- ------- ------- -------'
      write(io8,'(''Bad dir        '',5(1x,i7))')
     $           (n_bad_dir(ii),ii=1,5)
      write(io8,'(''Incons dir     '',5(1x,i7))')
     $           (n_inc_dir(ii),ii=1,5)
      write(io8,'(''Bad spd        '',5(1x,i7))')
     $           (n_bad_spd(ii),ii=1,5)
      write(io8,'(''Calm spd       '',5(1x,i7))')
     $           (n_calm_spd(ii),ii=1,5)
      write(io8,'(''Incons spd     '',5(1x,i7))')
     $           (n_inc_spd(ii),ii=1,5)
      write(io8,'(''Bad moist      '',5(1x,i7))')
     $           (n_bad_moist(ii),ii=1,5)
      write(io8,'(1x,a55)')
     $ '--------------- ------- ------- ------- ------- -------'
      write(io8,'(''Listed temp    '',5(1x,i7))')
     $           (n_list_temp(ii),ii=1,5)
      write(io8,'(''Listed wind    '',5(1x,i7))')
     $           (n_list_wind(ii),ii=1,5)
      write(io8,'(1x,a55)')
     $ '--------------- ------- ------- ------- ------- -------'
      write(io8,'(''Missing temp   '',5(1x,i7))')
     $           (n_mis_temp(ii),ii=1,5)
      write(io8,'(''Missing dir    '',5(1x,i7))')
     $           (n_mis_dir(ii),ii=1,5)
      write(io8,'(''Missing spd    '',5(1x,i7))')
     $           (n_mis_spd(ii),ii=1,5)
      write(io8,'(''Missing moist  '',5(1x,i7))')
     $           (n_mis_moist(ii),ii=1,5)
      write(io8,'(1x,a55)')
     $ '--------------- ------- ------- ------- ------- -------'
      write(io8,'(''Suspect time   '',5(1x,i7))')
     $           (n_sus_time(ii),ii=1,5)
      write(io8,'(''Suspect lat    '',5(1x,i7))')
     $           (n_sus_lat(ii),ii=1,5)
      write(io8,'(''Suspect lon    '',5(1x,i7))')
     $           (n_sus_lon(ii),ii=1,5)
      write(io8,'(''Suspect alt    '',5(1x,i7))')
     $           (n_sus_alt(ii),ii=1,5)
      write(io8,'(''Suspect moist  '',5(1x,i7))')
     $           (n_sus_moist(ii),ii=1,5)
      write(io8,'(1x,a55)')
     $ '--------------- ------- ------- ------- ------- -------'
c
      kbadtot = kbad(1) + kbad(2) + kbad(3)
     $        + kbad(4) + kbad(5)
c
      write(io8,*)
      write(io8,*) numreps,' good reports processed'
      write(io8,*) kbadtot,' reports failed qc in gross check'
c
      return
      end
c
c ###################################################################
c                            subroutine poschek_qc
c ###################################################################
c   
      subroutine poschek_qc(numreps,max_reps,indx,csort,imiss,amiss
     $,          idt_updn,c_acftreg,c_acftid,cidmiss,c_qc,cdtg_an
     $,          alat,alon,pres,ht_ft,t_prcn,ob_t,ob_q,ob_dir,ob_spd
     $,          xiv_t,xiv_q,xiv_d,xiv_s
     $,          idt,itype,ichk_t,ichk_q,ichk_d,ichk_s
     $,          kflight,maxflt,nobs_flt,iobs_flt,kbadtot,io8,io35
     $,          l_operational,l_init)
c
c     Check near duplicate reports with different positions/altitudes/times
c     and pick the best one
c     Also, look for redundant data and reject it
c
      implicit none
c
c Declaration statements
c ----------------------
      integer      max_reps            ! maximum number of reports
c
      character*11 c_qc(max_reps)      ! internal qc flags
c
c     Data arrays
c     -----------
      character*10 cdtg_an             ! date time group for analysis
      integer      numreps             ! actual number of reports
      integer      itype(max_reps)     ! type of aircraft data
      integer      idt(max_reps)       ! time in seconds to analysis time 
      character*8  c_acftreg(max_reps) ! aircraft registration (tail) number
      character*9  c_acftid(max_reps)  ! aircraft flight number
      real*8       alat(max_reps)      ! latitude
     $,            alon(max_reps)      ! longitude
      real         pres(max_reps)      ! pressure
     $,            ht_ft(max_reps)     ! height in feet
      real         t_prcn(max_reps)    ! temperature precision
      real         ob_t(max_reps)      ! temperature
     $,            ob_q(max_reps)      ! specific humidity
     $,            ob_dir(max_reps)    ! wind direction
     $,            ob_spd(max_reps)    ! wind speed
      real         xiv_t(max_reps)     ! temperature innovation (ob - bk)
     $,            xiv_q(max_reps)     ! specific humidity innovation (ob - bk)
     $,            xiv_d(max_reps)     ! wind direction innovation (ob - bk)
     $,            xiv_s(max_reps)     ! wind speed innovation (ob - bk)
      integer      ichk_t(max_reps)    ! NRL QC flag for temperature ob
     $,            ichk_q(max_reps)    ! NRL QC flag for specific humidity ob
     $,            ichk_d(max_reps)    ! NRL QC flag for wind direction ob
     $,            ichk_s(max_reps)    ! NRL QC flag for wind speed ob
      character*25 csort(max_reps)     ! sort variable    
c
c     Pointers
c     --------
      integer      indx(max_reps)      ! pointer index for good reports
c
c     Functions
c     ---------
      character*16 c_insty_ob          ! function to convert integer instrument 
                                       !   type to character instrument type
      integer      insty_ob_fun        ! function to convert character
                                       !   instrument type to integer
      real         gcirc_qc            ! function to compute great circle distances
c
c     Flight statistics
c     -----------------
      integer      maxflt              ! max number of flights allowed
      integer      nobs_flt(maxflt)    ! number of reports per flight
     $,            iobs_flt(maxflt)    ! index for first report in each flight
     $,            kflight             ! number of flights in dataset
      integer      istart              ! index for 1st rep in current flight 
     $,            iistart             ! index from pointer array for istart
     $,            iend                ! index for last rep in current flight
     $,            iiend               ! index from pointer array for iend
c
c     Counters
c     --------
      integer      ninc_xtra(5)        ! number of redundant reports
     $,            ninc_way(5)         ! number of duplicate reports with waypoint errors
     $,            ninc_alt(5)         ! number of duplicate reports with altitude errors
     $,            ninc_stk(5)         ! number of reports with stuck times
     $,            ninc_time(5)        ! number of reports with stuck times
     $,            ninc_avg(5)         ! number of reports with averaged position or time
     $,            ninc_bad(5)         ! number of reports with inconsistent positions
      integer      kbad(5)             ! counter for number of bad reports
     $,            kbadtot             ! counter for total number of bad reports
ccccdak      integer      nrep_Ac             ! number of acars reports considered
      integer      nrep_Ac             ! number of tamdar reports considered
     $,            nrep_Md             ! number of mdcrs reports considered
     $,            nrep_Ma             ! number of manual airep reports considered
     $,            nrep_Ar             ! number of airep reports considered
     $,            nrep_Am             ! number of amdar reports considered
ccccdak      integer      ninc_Ac             ! number of acars reports rejected
      integer      ninc_Ac             ! number of tamdar reports rejected
     $,            ninc_Md             ! number of mdcrs reports rejected
     $,            ninc_Ma             ! number of manual airep reports rejected
     $,            ninc_Ar             ! number of airep reports rejected
     $,            ninc_Am             ! number of amdar reports rejected
c
c     Instrument types
c     ----------------
ccccdak      integer      i_acars             ! instrument type for acars
      integer      i_acars             ! instrument type for tamdar
ccccdak     $,            i_acars_lvl         ! instrument type for acars--level flt
     $,            i_acars_lvl         ! instrument type for tamdar--level flt
ccccdak     $,            i_acars_asc         ! instrument type for acars--ascent
     $,            i_acars_asc         ! instrument type for tamdar--ascent
ccccdak     $,            i_acars_des         ! instrument type for acars--descent
     $,            i_acars_des         ! instrument type for tamdar--descent
     $,            i_mdcrs             ! instrument type for mdcrs
     $,            i_mdcrs_lvl         ! instrument type for mdcrs--level flt
     $,            i_mdcrs_asc         ! instrument type for mdcrs--ascent
     $,            i_mdcrs_des         ! instrument type for mdcrs--descent
     $,            i_man_airep         ! instrument type for manual aireps
     $,            i_man_Yairep        ! instrument type for manual aireps (YRXX)
     $,            i_airep             ! instrument type for airep
     $,            i_airep_lvl         ! instrument type for airep--level flt
     $,            i_airep_asc         ! instrument type for airep--ascent
     $,            i_airep_des         ! instrument type for airep--descent
     $,            i_amdar             ! instrument type for amdar
     $,            i_amdar_lvl         ! instrument type for amdar--level flt
     $,            i_amdar_asc         ! instrument type for amdar--ascent
     $,            i_amdar_des         ! instrument type for amdar--descent
c
c     Other variables
c     ---------------
      integer      io8                 ! i/o unit number for log file
      integer      io35                ! i/o unit number for position check
c
      real         amiss               ! real missing value flag
c
      integer      iob,kk              ! do loop indices 
     $,            ii                  ! index pointing to current report
     $,            iim1                ! index pointing to previous report
     $,            iim2                ! index pointing to 2nd report previous
     $,            iip1                ! index pointing to following report
     $,            knt1                ! counter used to define iim1 index
     $,            knt2                ! counter used to define iim2 index
      integer      iht0                ! integer ht_ft(ii)
     $,            ihtm1               ! integer ht_ft(iim1)
      integer      ihtdif0             ! height difference (current - previous)
      integer      imiss               ! integer missing value flag
     $,            idt_dif             ! time difference (current  - previous report)
     $,            idt_difp1           ! time difference (following  - current report)
     $,            idt_tot             ! time between iim2 and iip1 points
      integer      idt_updn            ! time difference to check ascents/descents
     $,            idt_stk             ! time clock is stuck at
c
      integer      ktype               ! ob type
c
      real*8       alat_dif            ! difference in latitude
     $,            alon0               ! longitude at point ii
     $,            alonm2              ! longitude at point iim2
     $,            alonp1              ! longitude at point iip1
     $,            alon_dif            ! difference in longitude
      real         diff0               ! difference between points ii and iim1
     $,            diffm1              ! difference between points iim1 and iip1
     $,            difdir              ! direction difference
      real*8       alat_est            ! estimated latitude
     $,            alon_est            ! estimated longitude
      real         time_est            ! estimated time
     $,            dist_tot            ! estimated distance between iim2 and iip1 points
     $,            dist_ii             ! estimated distance between "est" and ii points
     $,            dist_iim1           ! estimated distance between "est" and iim1 points
c
      character*8  cidmiss             ! missing value flag for flight number
c
c     Switches
c     --------
      logical      l_print             ! true for printing two reports used in check
c
      logical      l_init              ! initialize counters if true
     $,            stuck               ! true if stuck clock found
     $,            l_operational       ! true if operational mode used
c
c # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # #
c
c Initialize aircraft data types
c ------------------------------
      i_acars      = insty_ob_fun('acars')
      i_acars_lvl  = insty_ob_fun('acars_lvl') 
      i_acars_asc  = insty_ob_fun('acars_asc') 
      i_acars_des  = insty_ob_fun('acars_des') 
      i_mdcrs      = insty_ob_fun('mdcrs')
      i_mdcrs_lvl  = insty_ob_fun('mdcrs_lvl') 
      i_mdcrs_asc  = insty_ob_fun('mdcrs_asc') 
      i_mdcrs_des  = insty_ob_fun('mdcrs_des')
      i_man_airep  = insty_ob_fun('man-airep') 
      i_man_Yairep = insty_ob_fun('man-Yairep') 
      i_airep      = insty_ob_fun('airep')
      i_airep_lvl  = insty_ob_fun('airep_lvl')
      i_airep_asc  = insty_ob_fun('airep_asc')
      i_airep_des  = insty_ob_fun('airep_des')
      i_amdar      = insty_ob_fun('amdar')
      i_amdar_lvl  = insty_ob_fun('amdar_lvl')
      i_amdar_asc  = insty_ob_fun('amdar_asc')
      i_amdar_des  = insty_ob_fun('amdar_des')
c
c Initialize counters
c -------------------
      if(l_init) then
        ninc_xtra = 0
        ninc_way = 0
        ninc_alt = 0
        ninc_stk = 0
        ninc_time = 0
        ninc_avg = 0
        ninc_bad = 0
        nrep_Ac = 0
        nrep_Md = 0
        nrep_Ma = 0
        nrep_Ar = 0
        nrep_Am = 0
        ninc_Ac = 0
        ninc_Md = 0
        ninc_Ma = 0
        ninc_Ar = 0
        ninc_Am = 0
      endif
c
c Begin loop over flights
c -----------------------
      do kk = 1,kflight
c
c Initialize variables
c --------------------
        stuck = .false.
        istart = iobs_flt(kk)
        iistart = indx(istart)
        iend = iobs_flt(kk) + nobs_flt(kk) - 1
        iiend = indx(iend)
        l_print = .false.
c
c Check two-report manAIREP flights 
c ---------------------------------
        if(nobs_flt(kk).eq.2.and.
     $     (itype(iistart).eq.i_man_airep.or.
     $      itype(iistart).eq.i_man_Yairep).and.
     $     (itype(iiend).eq.i_man_airep.or.
     $      itype(iiend).eq.i_man_Yairep).and.
     $     abs(ob_t(iistart)-ob_t(iiend)).lt.1.25.and.
     $     abs(ob_dir(iistart)-ob_dir(iiend)).lt.10.5.and.
     $     abs(ob_spd(iistart)-ob_spd(iiend)).lt.1.25) then
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
c
c         Check for position discrepancies
c         --------------------------------
          if((abs(alat(iistart)-alat(iiend)).gt.0.125.or.
     $        abs(alon(iistart)-alon(iiend)).gt.0.125).and.
     $       abs(ht_ft(iistart)-ht_ft(iiend)).lt.1.5.and.
     $       idt(iistart).eq.idt(iiend)) then
c
            dist_tot = gcirc_qc(alat(iistart),alon(iistart),
     $                          alat(iiend),  alon(iiend))
            dist_tot = dist_tot / 1000.
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
c
            l_print = .true.
            if(l_print) then
              write(io8,*)
              write(io8,*) 'Discrepancy in position for 2-rep flight'
              write(io8,*) 'dist_tot = ',dist_tot
            endif
c
c           If points are close together, average the position
c           --------------------------------------------------
            if(dist_tot.lt.115.0) then
              if(l_print) then
                write(io8,*) 'points close--averaging'
              endif
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
              alat(iistart) = (alat(iistart)+alat(iiend))/2.0
              alon(iistart) = (alon(iistart)+alon(iiend))/2.0
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
              c_qc(iistart)(3:4) = 'RR'
              c_qc(iiend)(1:1) = 'W'
              c_qc(iiend)(3:4) = 'BB'
c
            else
              c_qc(iistart)(1:1) = 'W'
              c_qc(iistart)(3:4) = 'BB'
              c_qc(iiend)(1:1) = 'W'
              c_qc(iiend)(3:4) = 'BB'
            endif
c 
c         Check for altitude discrepancies
c         --------------------------------
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
          elseif((abs(alat(iistart)-alat(iiend)).lt.0.125.or.
     $            abs(alon(iistart)-alon(iiend)).lt.0.125).and.
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
     $           abs(ht_ft(iistart)-ht_ft(iiend)).gt.1000..and.
     $           idt(iistart).eq.idt(iiend)) then
c
            l_print = .false.
            if(l_print) then
              write(io8,*)
              write(io8,*) 'Discrepancy in altitude for 2-rep flight'
            endif
c
            c_qc(iistart)(1:1) = 'A'
            c_qc(iistart)(5:5) = 'B'
            c_qc(iiend)(1:1) = 'A'
            c_qc(iiend)(5:5) = 'B'
c
c         Check for time discrepancies
c         ----------------------------
          elseif(idt(iistart).ne.idt(iiend).and.
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
     $           abs(alat(iistart)-alat(iiend)).lt.0.125.and.
     $           abs(alon(iistart)-alon(iiend)).lt.0.125.and.
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
     $           abs(ht_ft(iistart)-ht_ft(iiend)).lt.50.5) then
c
            l_print = .true.
            if(l_print) then
              write(io8,*)
              write(io8,*) 'Discrepancy in time for 2-rep flight'
            endif
c
c           If points are close in time, average times
c           ------------------------------------------
            if(abs(idt(iistart)-idt(iiend)).lt.1800.0) then
c
              if(l_print) then
                write(io8,*) 'points close--averaging'
              endif
c
              idt(iiend) = (idt(iiend)+idt(iistart))/2
              c_qc(iiend)(2:2) = 'R'
              c_qc(iistart)(1:1) = 't'
              c_qc(iistart)(2:2) = 'B'
c
c           Otherwise reject both points
c           ----------------------------
            else
              c_qc(iistart)(1:1) = 't'
              c_qc(iistart)(2:2) = 'B'
              c_qc(iiend)(1:1) = 't'
              c_qc(iiend)(2:2) = 'B'
            endif
          endif
c
c         Print both reports if desired
c         -----------------------------
          if(l_print) then
            iim1 = iistart
            ii = iiend
            write(io8,8002) kk,iim1
     x,            c_insty_ob(itype(iim1))
     x,            c_acftreg(iim1),c_acftid(iim1)
     x,            idt(iim1),alat(iim1),alon(iim1)
     x,            pres(iim1),ht_ft(iim1)
     x,            t_prcn(iim1),ob_t(iim1),xiv_t(iim1),ichk_t(iim1)
     x,            ob_q(iim1),xiv_q(iim1),ichk_q(iim1)
     x,            ob_dir(iim1),xiv_d(iim1),ichk_d(iim1)
     x,            ob_spd(iim1),xiv_s(iim1),ichk_s(iim1)
     x,            c_qc(iim1)
            write(io8,8002) kk,ii,c_insty_ob(itype(ii))
     x,            c_acftreg(ii),c_acftid(ii)
     x,            idt(ii),alat(ii),alon(ii)
     x,            pres(ii),ht_ft(ii)
     x,            t_prcn(ii),ob_t(ii),xiv_t(ii),ichk_t(ii)
     x,            ob_q(ii),xiv_q(ii),ichk_q(ii)
     x,            ob_dir(ii),xiv_d(ii),ichk_d(ii)
     x,            ob_spd(ii),xiv_s(ii),ichk_s(ii)
     x,            c_qc(ii)
 8002       format(i4,1x,i6,1x,a8,1x,a8,1x,a9,1x,i7,1x,2f11.5,1x
     x,            f8.1,1x,f7.0
     x,            1x,f5.2,4(2(1x,f8.2),1x,i5),1x,'!',a11,'!')
          endif
c
c Otherwise, examine only "real" flights with at least three reports
c ------------------------------------------------------------------
        elseif(c_acftid(iistart)(1:8).ne.cidmiss(1:8).and.
     $         nobs_flt(kk).ge.3) then
c
c Begin loop over reports
c -----------------------
          do iob = istart+1,iend
            l_print = .false.
c
            ii   = indx(iob)
c
c           Compute ii+1 index
c           ------------------
            if(iob.lt.iend) then
              iip1 = indx(iob+1)
            else
              iip1 = 0
            endif
c
c           Compute ii-1 index
c           ------------------
            knt1 = iob - 1
 10         if(knt1.ge.istart) then
              iim1 = indx(knt1)
              if(c_qc(iim1)(1:1).eq.'r'.or.
     $           c_qc(iim1)(1:1).eq.'W'.or.
     $           c_qc(iim1)(1:1).eq.'A'.or.
     $           c_qc(iim1)(1:1).eq.'t'.or.
     $           c_qc(iim1)(2:2).eq.'K'.or.
     $           c_qc(iim1)(5:5).eq.'B') then
                knt1 = knt1 - 1
                goto 10
              endif
            else
              iim1 = 0
            endif
c
c           Compute ii-2 index
c           ------------------
            knt2 = knt1 - 1
 20         if(knt2.ge.istart) then
              iim2 = indx(knt2)
              if(c_qc(iim2)(1:1).eq.'r'.or.
     $           c_qc(iim2)(1:1).eq.'W'.or.
     $           c_qc(iim2)(1:1).eq.'A'.or.
     $           c_qc(iim2)(2:2).eq.'K'.or.
     $           c_qc(iim2)(2:2).eq.'B'.or.
     $           c_qc(iim2)(5:5).eq.'B') then
                knt2 = knt2 - 1
                goto 20
              endif
            else
              iim2 = 0
            endif
c
c           Continue only if iim1 is valid
c           ------------------------------
            if(iim1.ne.0) then
c
c             Compute height and time differences for iim1 report
c             ---------------------------------------------------
              if(ht_ft(ii).ne.amiss) then
                iht0 = nint(ht_ft(ii)/100.) * 100
              else
                iht0 = imiss
              endif
c
              if(ht_ft(iim1).ne.amiss) then
                ihtm1 = nint(ht_ft(iim1)/100.) * 100
              else
                ihtm1 = imiss
              endif
c
              if(ht_ft(ii).ne.amiss.and.ht_ft(iim1).ne.amiss) then
                ihtdif0 = abs(iht0 - ihtm1)
              else
                ihtdif0 = imiss
              endif
c
              idt_dif = abs(idt(ii) - idt(iim1))
c
c             Compute magnitude of direction difference
c             (constrain to be less than 180 deg
c             -----------------------------------------
              if(ob_dir(ii).eq.amiss.or.
     $           ob_dir(iim1).eq.amiss) then
                difdir = amiss
              else
                difdir = abs(ob_dir(iim1)-ob_dir(ii))
                if(difdir.gt.180) difdir = 360. - difdir
              endif
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
c
c             Discrepancies in position
c             -------------------------
              if(idt_dif.eq.0.and.
     $           (abs(alat(ii)-alat(iim1)).ge.0.5.or.
     $            abs(alon(ii)-alon(iim1)).ge.0.5) .and.
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
     $           abs(ht_ft(ii)-ht_ft(iim1)).lt.1.5) then
c
c               Check for short segments with stuck clock
c               -----------------------------------------
                if(iim2.ne.0) then
                  if(idt(iim1).eq.idt(ii).and.
     $               idt(iim2).eq.idt(ii)) then
                    c_qc(iim2)(2:2) = 'K'
                    c_qc(iim1)(2:2) = 'K'
                    c_qc(ii)(2:2) = 'K'
                  endif
                endif
c
                if(iip1.ne.0) then
                  if(idt(iim1).eq.idt(ii).and.
     $               idt(iip1).eq.idt(ii)) then
                    c_qc(iip1)(2:2) = 'K'
                    c_qc(iim1)(2:2) = 'K'
                    c_qc(ii)(2:2) = 'K'
                  endif
                endif
c
                if(c_qc(ii)(2:2).eq.'K') then
                  stuck = .true.
                  idt_stk = idt(ii)
                  l_print = .true.
                  if(l_print) then
                    write(io8,*)
                    write(io8,*) 'Discrepancy in position'
                    write(io8,*) 'Stuck clock found'
                  endif
                endif
              endif
c
c             Exclude reports diagnosed as stuck from remaining checks
c             --------------------------------------------------------
              if(c_qc(ii)(2:2).eq.'K') then
c
c             United flights with 2000' as lowest valid alt
c             Pressure/altitude on ground invalid
c             Flag if temperatures and altitudes are inconsistent!
c             Time-stamp the test so it only applies to the 1996 dataset
c             ----------------------------------------------------------
              elseif(cdtg_an.lt.'1998010100'.and.
     $               iht0.eq.2000.and.
     $               idt_dif.lt.300.and.
     $               ihtdif0.gt.6000.and.ihtdif0.ne.imiss.and.
     $               ob_t(iim1).gt.ob_t(ii)) then
c
                l_print = .true.
                if(l_print) then
                  write(io8,*)
                  write(io8,*) 'Bad altitude for first point'
                  write(io8,*) 'ht_ft(',ii,') = ',ht_ft(ii)
                  write(io8,*) 'ht_ft(',iim1,') = ',ht_ft(iim1)
                endif
                c_qc(iim1)(5:5) = 'B'
c
              elseif(ihtm1.eq.2000.and.
     $               idt_dif.lt.300.and.
     $               ihtdif0.gt.6000.and.ihtdif0.ne.imiss.and.
     $               ob_t(ii).gt.ob_t(iim1)) then
                l_print = .true.
                if(l_print) then
                  write(io8,*)
                  write(io8,*) 'Bad altitude for last point'
                  write(io8,*) 'ht_ft(',ii,') = ',ht_ft(ii)
                  write(io8,*) 'ht_ft(',iim1,') = ',ht_ft(iim1)
                endif
                c_qc(ii)(5:5) = 'B'
c
c             Multiple values at same altitude at low altitudes
c             Save only one
c             -------------------------------------------------
              elseif(iht0.lt.8000.and.
     $               idt_dif.le.60.and.
     $               ihtdif0.lt.2) then
c
                if(iip1.ne.0) then
                  idt_difp1 = abs(idt(ii)-idt(iip1))
                else
                  idt_difp1 = imiss
                endif
c
c               Save newer report if at beginning of flight
c               -------------------------------------------
                if(idt(iim1).ne.idt(ii).and.
     $             (iim1.eq.iistart.or.
     $              (idt_difp1.ne.imiss.and.idt_difp1.le.idt_updn)))then
                  l_print = .false.
                  if(l_print) then
                    write(io8,*) 
                    write(io8,*) 'Multiple values at same altitude'
                    write(io8,*) 'Saving newer report'
                  endif
                  c_qc(iim1)(1:1) = 'r'
c
c               Save report nearer to next report, if available
c               Otherwise, save report with smallest temperature or
c               windspeed difference w.r.t. next report
c               ---------------------------------------------------
                elseif(iip1.ne.0) then
c
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
                  if(alat(ii).ne.alat(iim1).or.
     $               alon(ii).ne.alon(iim1)) then
                    diffm1 = gcirc_qc(alat(iim1),alon(iim1),
     $                                alat(iip1),alon(iip1))
                    diffm1 = diffm1 / 1000.
                    diff0 = gcirc_qc(alat(ii),alon(ii),
     $                               alat(iip1),alon(iip1))
                    diff0 = diff0 / 1000.
c
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
                  elseif(ob_t(ii).ne.ob_t(iim1)) then
                    diffm1 = abs(ob_t(iim1)-ob_t(iip1))
                    diff0 = abs(ob_t(ii)-ob_t(iip1))
c
                  elseif(ob_spd(ii).ne.ob_spd(iim1)) then
                    diffm1 = abs(ob_spd(iim1)-ob_spd(iip1))
                    diff0 = abs(ob_spd(ii)-ob_spd(iip1))
c
                  else
                    diffm1 = 1.0
                    diff0 = 0.0
                  endif
c
                  if(diff0.lt.diffm1.or.ichk_s(iim1).eq.-10) then
                    l_print = .false.
                    if(l_print) then
                      write(io8,*) 
                      write(io8,*) 'Multiple values at same altitude'
                      write(io8,*) 'Saving ii report'
                    endif
                    c_qc(iim1)(1:1) = 'r'
c
                  elseif(diffm1.lt.diff0) then
                    l_print = .false.
                    if(l_print) then
                      write(io8,*) 
                      write(io8,*) 'Multiple values at same altitude'
                      write(io8,*) 'Saving iim1 report'
                    endif
                    c_qc(ii)(1:1) = 'r'
c
                  else
                    l_print = .true.
                    if(l_print) then
                      write(io8,*) 
                      write(io8,*) 'Multiple values at same altitude'
                      write(io8,*) 'Differences should not be equal!'
                    endif
                  endif
c
c               If following report not available, drop current report
c               ------------------------------------------------------
                else
                  l_print = .false.
                  if(l_print) then
                    write(io8,*) 
                    write(io8,*) 'Multiple values at same altitude'
                    write(io8,*) 'Following report not available'
                  endif
                  c_qc(ii)(1:1) = 'r'
                endif
c
c             Perform remaining checks only for manAIREP duplicates
c             -----------------------------------------------------
              elseif((itype(ii).eq.i_man_airep.or.
     $                itype(ii).eq.i_man_Yairep).and.
     $               (itype(iim1).eq.i_man_airep.or.
     $                itype(iim1).eq.i_man_Yairep).and.
     $               (abs(ob_t(iim1)-ob_t(ii)).lt.1.25.or.
     $                (ob_t(iim1).eq.amiss.and.ob_t(ii).ne.amiss).or.
     $                (ob_t(iim1).ne.amiss.and.ob_t(ii).eq.amiss)).and.
     $               (abs(difdir).lt.10.5.or.
     $               (ob_dir(iim1).eq.amiss.and.ob_dir(ii).eq.amiss).or.
     $               (ob_dir(iim1).eq.amiss.and.ob_dir(ii).ne.amiss).or.
     $               (ob_dir(iim1).ne.amiss.and.ob_dir(ii).eq.amiss).or.
     $               (ob_dir(iim1).lt.0.5.and.ob_dir(ii).lt.0.5).or.
     $               (ob_dir(iim1).lt.0.5.and.difdir.gt.10.5).or.
     $               (difdir.gt.10.5.and.ob_dir(ii).lt.0.5)).and.
     $               (abs(ob_spd(iim1)-ob_spd(ii)).lt.1.25.or.
     $               (ob_spd(iim1).eq.amiss.and.ob_spd(ii).eq.amiss).or.
     $               (ob_spd(iim1).eq.amiss.and.ob_spd(ii).ne.amiss).or.
     $               (ob_spd(iim1).ne.amiss.and.ob_spd(ii).eq.amiss).or.
     $               (ob_spd(iim1).lt.0.05.and.ob_spd(ii).lt.0.05).or.
     $               (ob_spd(iim1).lt.0.05.and.ob_spd(ii).gt.1.25).or.
     $               (ob_spd(iim1).gt.1.25.and.ob_spd(ii).lt.0.05)))then
c
c               Check for position discrepancies
c               --------------------------------
                if(idt_dif.eq.0.and.
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
     $             (abs(alat(ii)-alat(iim1)).ge.0.125.or.
     $              abs(alon(ii)-alon(iim1)).ge.0.125) .and.
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
     $             abs(ht_ft(ii)-ht_ft(iim1)).lt.1.5) then
c
                  l_print = .true.
                  if(l_print) then
                    write(io8,*)
                    write(io8,*) 'Discrepancy in position'
                    write(io8,*) 'Waypoint error found'
                  endif
c
c                 If ii and iim1 points are close together, average the position
c                 --------------------------------------------------------------
                  dist_tot = gcirc_qc(alat(ii),alon(ii),
     $                                alat(iim1),alon(iim1))
                  dist_tot = dist_tot / 1000.
c
                  if(dist_tot.lt.115.0) then
                    if(l_print) then
                      write(io8,*) 'points close--averaging'
                    endif
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
                    alat(ii) = (alat(ii)+alat(iim1))/2.0
                    alon(ii) = (alon(ii)+alon(iim1))/2.0
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
                    c_qc(ii)(3:4) = 'RR'
                    c_qc(iim1)(1:1) = 'W'
                    c_qc(iim1)(3:4) = 'BB'
c
c                 Otherwise, examine neighboring reports to decide which one to keep
c                 ------------------------------------------------------------------ 
                  elseif(iim2.ne.0.and.iip1.ne.0) then
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
                    alat_est = (alat(iip1)-alat(iim2))
     $                       / (idt(iip1)-idt(iim2))  
     $                       * (idt(ii)-idt(iim2)) 
     $                       + alat(iim2)               
                    alon_est = (alon(iip1)-alon(iim2))
     $                       / (idt(iip1)-idt(iim2))  
     $                       * (idt(ii)-idt(iim2)) 
     $                       + alon(iim2)
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
c
                    dist_tot = gcirc_qc(alat(iip1),alon(iip1),
     $                                  alat(iim2),alon(iim2))
                    dist_tot = dist_tot / 1000.
                    dist_ii  = gcirc_qc(alat_est,alon_est,
     $                                  alat(ii),alon(ii))
                    dist_ii = dist_ii / 1000.
                    dist_iim1= gcirc_qc(alat_est,alon_est,
     $                                  alat(iim1),alon(iim1))
                    dist_iim1 = dist_iim1 / 1000.
c
                    if(l_print) then
                      write(io8,*) 'Estimated position = ',
     $                     alat_est,alon_est
                      write(io8,*) 'Distances: iim2-iip1 = ',dist_tot
                      write(io8,*) '           est-ii    = ',dist_ii
                      write(io8,*) '           est-iim1  = ',dist_iim1
                    endif
c                 
c                   If the neighboring reports are close enough together,
c                   choose the report that is closest to the interpolated point
c                   -----------------------------------------------------------
                    if(dist_tot.lt.2500.0) then
                      if(dist_ii.lt.dist_iim1) then
                        c_qc(iim1)(1:1) = 'W'
                        c_qc(iim1)(3:4) = 'BB'
                      else
                        c_qc(ii)(1:1) = 'W'
                        c_qc(ii)(3:4) = 'BB'
                      endif
c
c                   If the neighboring reports are too far apart,
c                   reject both reports
c                   ---------------------------------------------
                    else
                      c_qc(iim1)(1:1) = 'W'
                      c_qc(iim1)(3:4) = 'BB'
                      c_qc(ii)(1:1) = 'W'
                      c_qc(ii)(3:4) = 'BB'
                    endif
c
c                 If only iim2 point is available...
c                 ----------------------------------
                  elseif(iim2.ne.0) then
c
                    dist_tot = gcirc_qc(alat(iim1),alon(iim1),
     $                                  alat(ii),alon(ii))
                    dist_tot = dist_tot / 1000.
                    dist_ii  = gcirc_qc(alat(iim2),alon(iim2),
     $                                  alat(ii),alon(ii))
                    dist_ii = dist_ii / 1000.
                    dist_iim1= gcirc_qc(alat(iim2),alon(iim2),
     $                                  alat(iim1),alon(iim1))
                    dist_iim1 = dist_iim1 / 1000.
                    if(l_print) 
     $                write(io8,*) 'distances:',dist_ii,dist_iim1
c                 
c                   If ii point is close and iim1 point is far, choose ii point
c                   -----------------------------------------------------------
                    if(abs(idt(ii)-idt(iim2)).le.5400.and.
     $                 dist_ii.le.1500.0.and.dist_iim1.gt.1500.0) then
                      if(l_print) then
                        write(io8,*) 'iim1 point is too far away'
                      endif
                      c_qc(iim1)(1:1) = 'W'
                      c_qc(iim1)(3:4) = 'BB'
c             
c                   If iim1 point is close and ii point is far, choose iim1 point
c                   -------------------------------------------------------------
                    elseif(abs(idt(ii)-idt(iim2)).le.5400.and.
     $                 dist_ii.gt.1500.0.and.dist_iim1.le.1500.0) then
                      if(l_print) then
                        write(io8,*) 'ii point is too far away'
                      endif
                      c_qc(ii)(1:1) = 'W'
                      c_qc(ii)(3:4) = 'BB'
c
c                   Otherwise reject both points
c                   ----------------------------
                    else
                      if(l_print) then
                        write(io8,*) 'cannot decide which point'
                      endif
                      c_qc(iim1)(1:1) = 'W'
                      c_qc(iim1)(3:4) = 'BB'
                      c_qc(ii)(1:1) = 'W'
                      c_qc(ii)(3:4) = 'BB'
                    endif
c
c                 If only iip1 point is available...
c                 ----------------------------------
                  elseif(iip1.ne.0) then
c
                    dist_tot = gcirc_qc(alat(iim1),alon(iim1),
     $                                  alat(ii),alon(ii))
                    dist_tot = dist_tot / 1000.
                    dist_ii  = gcirc_qc(alat(iip1),alon(iip1),
     $                                  alat(ii),alon(ii))
                    dist_ii = dist_ii / 1000.
                    dist_iim1= gcirc_qc(alat(iip1),alon(iip1),
     $                                  alat(iim1),alon(iim1))
                    dist_iim1 = dist_iim1 / 1000.
                    if(l_print) 
     $                write(io8,*) 'distances:',dist_ii,dist_iim1
c                
c                   If ii point is close and iim1 point is far, choose ii point
c                   -----------------------------------------------------------
                    if(abs(idt(ii)-idt(iip1)).le.5400.and.
     $                 dist_ii.le.1500.0.and.dist_iim1.gt.1500.0) then
                      if(l_print) then
                        write(io8,*) 'iim1 point is too far away'
                      endif
                      c_qc(iim1)(1:1) = 'W'
                      c_qc(iim1)(3:4) = 'BB'
c
c                   If iim1 point is close and ii point is far, choose iim1 point
c                   -------------------------------------------------------------
                    elseif(abs(idt(ii)-idt(iip1)).le.5400.and.
     $                 dist_ii.gt.1500.0.and.dist_iim1.le.1500.0) then
                      if(l_print) then
                        write(io8,*) 'ii point is too far away'
                      endif
                      c_qc(ii)(1:1) = 'W'
                      c_qc(ii)(3:4) = 'BB'
c
c                   Otherwise reject both points
c                   ----------------------------
                    else
                      if(l_print) then
                        write(io8,*) 'cannot decide which point'
                      endif
                      c_qc(iim1)(1:1) = 'W'
                      c_qc(iim1)(3:4) = 'BB'
                      c_qc(ii)(1:1) = 'W'
                      c_qc(ii)(3:4) = 'BB'
                    endif
c
c                 If both of the neighboring reports are not available
c                 and points are not close together, reject both reports
c                 ------------------------------------------------------
                  else
                    if(l_print) then
                      write(io8,*) 'cannot decide which point'
                    endif
                    c_qc(iim1)(1:1) = 'W'
                    c_qc(iim1)(3:4) = 'BB'
                    c_qc(ii)(1:1) = 'W'
                    c_qc(ii)(3:4) = 'BB'
                  endif
c
c               Check for duplicate with altitude error
c               ---------------------------------------
                elseif(idt_dif.eq.0.and.
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
     $                 abs(alat(iim1)-alat(ii)).lt.0.125.and.
     $                 abs(alon(iim1)-alon(ii)).lt.0.125.and.
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
     $                 abs(ht_ft(iim1)-ht_ft(ii)).gt.1000.0) then
c
                  l_print = .true.
                  if(l_print) then
                    write(io8,*)
                    write(io8,*) 'Near duplicate with altitude error'
                  endif
c
c                 Examine neighboring reports to decide which one to keep
c                 ------------------------------------------------------- 
                  if(iim2.ne.0.and.iip1.ne.0) then
c
                    dist_tot = gcirc_qc(alat(iip1),alon(iip1),
     $                                  alat(iim2),alon(iim2))
                    dist_tot = dist_tot / 1000.
c
                    if(l_print) then
                      write(io8,*) 'Distances: iim2-iip1 = ',dist_tot
                    endif
c
c                   Require the neighboring reports to be fairly close together
c                   -----------------------------------------------------------
                    if(dist_tot.lt.2500.0) then
c
c                     If the neighboring reports have the same altitude,
c                     choose the report with the same altitude
c                     --------------------------------------------------
                      if(abs(ht_ft(iim2)-ht_ft(iip1)).lt.1.5) then
                        write(io8,*) 'Neighboring altitudes equal'
c
                        if(abs(ht_ft(ii)-ht_ft(iim2)).lt.1.5) then
                          write(io8,*) 'ii altitude equal'
                          c_qc(iim1)(1:1) = 'A'
                          c_qc(iim1)(5:5) = 'B'
c
                        elseif(abs(ht_ft(iim1)-ht_ft(iim2)).lt.1.5) then
                          write(io8,*) 'iim1 altitude equal'
                          c_qc(ii)(1:1) = 'A'
                          c_qc(ii)(5:5) = 'B'
c  
                        else
                          write(io8,*) 'neither altitude equal'
                          c_qc(iim1)(1:1) = 'A'
                          c_qc(iim1)(5:5) = 'B'
                          c_qc(ii)(1:1) = 'A'
                          c_qc(ii)(5:5) = 'B'
                        endif
c
c                     If points constitute an ascent or a descent, don't reject any
c                     -------------------------------------------------------------
                      elseif((ht_ft(iim2).gt.ht_ft(iim1).and.
     $                        ht_ft(iim1).gt.ht_ft(ii).and.
     $                        ht_ft(ii  ).gt.ht_ft(iip1)).or.
     $                       (ht_ft(iim2).lt.ht_ft(iim1).and.
     $                        ht_ft(iim1).lt.ht_ft(ii).and.
     $                        ht_ft(ii  ).lt.ht_ft(iip1)).or.
     $                       (ht_ft(iim2).gt.ht_ft(ii).and.
     $                        ht_ft(ii  ).gt.ht_ft(iim1).and.
     $                        ht_ft(iim1).gt.ht_ft(iip1)).or.
     $                       (ht_ft(iim2).lt.ht_ft(ii).and.
     $                        ht_ft(ii  ).lt.ht_ft(iim1).and.
     $                        ht_ft(iim1).lt.ht_ft(iip1))) then
c
                        if(l_print)
     $                   write(io8,*) 'ascent/descent found--no rejects'
c
c                     If the neighboring reports have different altitudes and
c                     different temperatures, try using temperature to select one
c                     -----------------------------------------------------------
                      elseif(ob_t(iim2).ne.ob_t(iip1)) then
                        write(io8,*) 'altitudes and temperatures differ'
c
                        if(abs(ht_ft(ii)-ht_ft(iim2)).lt.1.5.and.
     $                     abs(ob_t(ii)-ob_t(iim2)).lt.2.005) then
                          if(l_print) then
                            write(io8,*) 'ii point matches iim2'
                          endif
                          c_qc(iim1)(1:1) = 'A'
                          c_qc(iim1)(5:5) = 'B'
c
                        elseif(abs(ht_ft(iim1)-ht_ft(iim2)).lt.1.5.and.
     $                         abs(ob_t(iim1)-ob_t(iim2)).lt.2.005) then
                          if(l_print) then
                            write(io8,*) 'iim1 point matches iim2'
                          endif
                          c_qc(ii)(1:1) = 'A'
                          c_qc(ii)(5:5) = 'B'
c
                        elseif(abs(ht_ft(ii)-ht_ft(iip1)).lt.1.5.and.
     $                         abs(ob_t(ii)-ob_t(iip1)).lt.2.005) then
                          if(l_print) then
                            write(io8,*) 'ii point matches iip1'
                          endif
                          c_qc(iim1)(1:1) = 'A'
                          c_qc(iim1)(5:5) = 'B'
c
                        elseif(abs(ht_ft(iim1)-ht_ft(iip1)).lt.1.5.and.
     $                         abs(ob_t(iim1)-ob_t(iip1)).lt.2.005) then
                          if(l_print) then
                            write(io8,*) 'iim1 point matches iip1'
                          endif
                          c_qc(ii)(1:1) = 'A'
                          c_qc(ii)(5:5) = 'B'
c
c                       Otherwise reject both points
c                       ----------------------------
                        else
                          if(l_print) 
     $                      write(io8,*) 'neither point matches'
                          c_qc(iim1)(1:1) = 'A'
                          c_qc(iim1)(5:5) = 'B'
                          c_qc(ii)(1:1) = 'A'
                          c_qc(ii)(5:5) = 'B'
                        endif
c     
c                     If the neighboring reports have different altitudes
c                     and the same temperature, reject both reports
c                     ----------------------------------------------------
                      else
                        if(l_print) write(io8,*) 'cannot select'
                        c_qc(iim1)(1:1) = 'A'
                        c_qc(iim1)(5:5) = 'B'
                        c_qc(ii)(1:1) = 'A'
                        c_qc(ii)(5:5) = 'B'
                      endif
c
c                   If the neighboring reports are too far apart,
c                   reject both reports
c                   ---------------------------------------------
                    else
                      if(l_print) write(io8,*) 'points too far apart'
                      c_qc(iim1)(1:1) = 'A'
                      c_qc(iim1)(5:5) = 'B'
                      c_qc(ii)(1:1) = 'A'
                      c_qc(ii)(5:5) = 'B'
                    endif
c
c                 If only iim2 point is available...
c                 ----------------------------------
                  elseif(iim2.ne.0) then
                    dist_ii  = gcirc_qc(alat(iim2),alon(iim2),
     $                                  alat(ii  ),alon(ii  ))
                    dist_ii = dist_ii / 1000.
                    dist_iim1= gcirc_qc(alat(iim2),alon(iim2),
     $                                  alat(iim1),alon(iim1))
                    dist_iim1 = dist_iim1 / 1000.
c
c                   If ii point is close, choose it
c                   -------------------------------
                    if(abs(idt(ii)-idt(iim2)).le.5400.and.
     $                 dist_ii.lt.1500.0.and.
     $                 abs(ht_ft(ii)-ht_ft(iim2)).lt.1.5.and.
     $                 abs(ob_t(ii)-ob_t(iim2)).lt.2.005) then
                      if(l_print) then
                        write(io8,*) 'ii point matches iim2'
                      endif
                      c_qc(iim1)(1:1) = 'A'
                      c_qc(iim1)(5:5) = 'B'
c
c                   If iim1 point is close, choose it
c                   ---------------------------------
                    elseif(abs(idt(ii)-idt(iim2)).le.5400.and.
     $                 dist_iim1.lt.1500.0.and.
     $                 abs(ht_ft(iim1)-ht_ft(iim2)).lt.1.5.and.
     $                 abs(ob_t(iim1)-ob_t(iim2)).lt.2.005) then
                      if(l_print) then
                        write(io8,*) 'iim1 point matches iim2'
                      endif
                      c_qc(ii)(1:1) = 'A'
                      c_qc(ii)(5:5) = 'B'
c
c                   Otherwise reject both points
c                   ----------------------------
                    else
                      if(l_print) write(io8,*) 'cannot make match'
                      c_qc(iim1)(1:1) = 'A'
                      c_qc(iim1)(5:5) = 'B'
                      c_qc(ii)(1:1) = 'A'
                      c_qc(ii)(5:5) = 'B'
                    endif
c
c                 If only iip1 point is available...
c                 ----------------------------------
                  elseif(iip1.ne.0) then
                    dist_ii  = gcirc_qc(alat(iip1),alon(iip1),
     $                                  alat(ii  ),alon(ii  ))
                    dist_ii = dist_ii / 1000.
                    dist_iim1= gcirc_qc(alat(iip1),alon(iip1),
     $                                  alat(iim1),alon(iim1))
                    dist_iim1 = dist_iim1 / 1000.
c
c                   If ii point is close, choose it
c                   -------------------------------
                    if(abs(idt(ii)-idt(iip1)).le.5400.and.
     $                 dist_ii.le.1500.0.and.
     $                 abs(ht_ft(ii)-ht_ft(iip1)).lt.1.5.and.
     $                 abs(ob_t(ii)-ob_t(iip1)).lt.2.005) then
                      if(l_print) then
                        write(io8,*) 'ii point matches iip1'
                      endif
                      c_qc(iim1)(1:1) = 'A'
                      c_qc(iim1)(5:5) = 'B'
c
c                   If iim1 point is close, choose it
c                   ---------------------------------
                    elseif(abs(idt(ii)-idt(iip1)).le.5400.and.
     $                 dist_iim1.le.1500.0.and.
     $                 abs(ht_ft(iim1)-ht_ft(iip1)).lt.1.5.and.
     $                 abs(ob_t(iim1)-ob_t(iip1)).lt.2.005) then
                      if(l_print) then
                        write(io8,*) 'iim1 point matches iip1'
                      endif
                      c_qc(ii)(1:1) = 'A'
                      c_qc(ii)(5:5) = 'B'
c
c                   Otherwise reject both points
c                   ----------------------------
                    else
                      if(l_print) write(io8,*) 'cannot make match'
                      c_qc(iim1)(1:1) = 'A'
                      c_qc(iim1)(5:5) = 'B'
                      c_qc(ii)(1:1) = 'A'
                      c_qc(ii)(5:5) = 'B'
                    endif
c
c                 If both of the neighboring reports are not available
c                 reject both reports
c                 ----------------------------------------------------
                  else
                    if(l_print) write(io8,*) 'no neighboring points'
                    c_qc(iim1)(1:1) = 'A'
                    c_qc(iim1)(5:5) = 'B'
                    c_qc(ii)(1:1) = 'A'
                    c_qc(ii)(5:5) = 'B'
                  endif
c
c               Check for duplicate with time error
c               -----------------------------------
                elseif(idt(iim1).ne.idt(ii).and.
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
     $                 abs(alat(iim1)-alat(ii)).lt.0.125.and.
     $                 abs(alon(iim1)-alon(ii)).lt.0.125.and.
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
     $                 abs(ht_ft(iim1)-ht_ft(ii)).lt.50.5) then
c
                  l_print = .true.
                  if(l_print) then
                    write(io8,*)
                    write(io8,*) 'Discrepancy in time'
                  endif
c
c                 If points are close in time, average times
c                 ------------------------------------------
                  if(abs(idt(iim1)-idt(ii)).lt.1800.0) then
c
                    if(l_print) then
                      write(io8,*) 'points close--averaging'
                    endif
                    idt(ii) = (idt(ii)+idt(iim1))/2
                    c_qc(ii)(2:2) = 'R'
                    c_qc(iim1)(1:1) = 't'
                    c_qc(iim1)(2:2) = 'B'
c
c                 Otherwise, examine neighboring reports to decide which one to keep
c                 ------------------------------------------------------------------ 
                  elseif(iim2.ne.0.and.iip1.ne.0) then
c
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
                    alat_dif = abs(alat(iip1)-alat(iim2))
                    alon0 = alon(ii)
                    alonm2 = alon(iim2)
                    alonp1 = alon(iip1)
                    if(alon0.gt.270.0.and.alonm2.lt.90.0) 
     $                alonm2 = alonm2 + 360.0
                    if(alon0.lt.90.0.and.alonm2.gt.270.0)
     $                alonm2 = 360.0 - alonm2
                    if(alon0.gt.270.0.and.alonp1.lt.90.0) 
     $                alonp1 = alonp1 + 360.0
                    if(alon0.lt.90.0.and.alonp1.gt.270.0)
     $                alonp1 = 360.0 - alonp1
                    alon_dif = abs(alonp1-alonm2)
c
                    if(alon_dif.eq.0.0.and.
     $                 alat_dif.eq.0.0) then
                      time_est = amiss
c
                    elseif(alon_dif.ge.alat_dif) then
                      time_est = (float(idt(iip1)-idt(iim2)))
     $                         / (alonp1-alonm2)
     $                         * (alon0-alonm2)
     $                         + float(idt(iim2))
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
                    else
                      time_est = (float(idt(iip1)-idt(iim2)))
     $                         / (alat(iip1)-alat(iim2))
     $                         * (alat(ii)-alat(iim2))
     $                         + float(idt(iim2))
                    endif
c
                    idt_tot = abs(idt(iip1) - idt(iim2))
c
                    if(l_print) then
                      write(io8,*) 'Estimated time = ',time_est
                      write(io8,*) 'Lons = ',alonm2,alon0,alonp1
                    endif
c
c                   If the neighboring reports are close enough together,
c                   choose the report that is closest to the interpolated point
c                   -----------------------------------------------------------
                    if(idt_tot.lt.9000.and.time_est.ne.amiss) then
                      if(abs(ifix(time_est)-idt(ii)).lt.
     $                   abs(ifix(time_est)-idt(iim1))) then
                        c_qc(iim1)(1:1) = 't'
                        c_qc(iim1)(2:2) = 'B'
c
                      else
                        c_qc(ii)(1:1) = 't'
                        c_qc(ii)(2:2) = 'B'
c
                      endif
c
c                   If the neighboring reports are too far apart,
c                   reject both reports
c                   ---------------------------------------------
                    else
                      c_qc(iim1)(1:1) = 't'
                      c_qc(iim1)(2:2) = 'B'
                      c_qc(ii)(1:1) = 't'
                      c_qc(ii)(2:2) = 'B'
                    endif
c
c                 Otherwise reject both points
c                 ----------------------------
                  else
                    if(l_print) then
                      write(io8,*) 'cannot decide which point'
                    endif
                    c_qc(iim1)(1:1) = 't'
                    c_qc(iim1)(2:2) = 'B'
                    c_qc(ii)(1:1) = 't'
                    c_qc(ii)(2:2) = 'B'
                  endif
c
c               Write out any other duplicates
c               ------------------------------
                else
                  l_print = .false.
                  if(l_print) then
                    write(io8,*)
                    write(io8,*) 'Leftover duplicate'
                  endif
                endif
c
c               Make sure retained report has all available values
c               (ii report is rejected; iim1 report is retained)
c               --------------------------------------------------
                if((c_qc(ii)(1:1).eq.'W'.and.c_qc(iim1).ne.'W').or.
     $             (c_qc(ii)(1:1).eq.'A'.and.c_qc(iim1).ne.'A').or.
     $             (c_qc(ii)(1:1).eq.'t'.and.c_qc(iim1).ne.'t')) then
c
                  if(ob_t(iim1).eq.amiss.and.ob_t(ii).ne.amiss) then 
                    ob_t(iim1) = ob_t(ii)
                    c_qc(iim1)(6:6) = c_qc(ii)(6:6)
                    ob_t(ii) = amiss
                    c_qc(ii)(6:6) = 'M'
                  endif
                  if(ob_dir(iim1).eq.amiss.and.ob_dir(ii).ne.amiss) then
                    ob_dir(iim1) = ob_dir(ii)
                    c_qc(iim1)(7:7) = c_qc(ii)(7:7) 
                    ob_dir(ii) = amiss
                    c_qc(ii)(7:7) = 'M'
                  endif
                  if(ob_dir(iim1).lt.0.5.and.difdir.gt.10.5) then
                    ob_dir(iim1) = ob_dir(ii)
                    c_qc(iim1)(7:7) = c_qc(ii)(7:7)
                    ob_dir(ii) = amiss
                    c_qc(ii)(7:7) = 'M'
                  endif
                  if(ob_spd(iim1).eq.amiss.and.ob_spd(ii).ne.amiss) then
                    ob_spd(iim1) = ob_spd(ii)
                    c_qc(iim1)(8:8) = c_qc(ii)(8:8)
                    ob_spd(ii) = amiss
                    c_qc(ii)(8:8) = 'M'
                  endif
                  if(ob_spd(iim1).lt.0.05.and.ob_spd(ii).gt.1.25) then
                    ob_spd(iim1) = ob_spd(ii)
                    c_qc(iim1)(8:8) = c_qc(ii)(8:8)
                    ob_spd(ii) = amiss
                    c_qc(ii)(8:8) = 'M'
                  endif
c
                  if(ob_spd(ii).eq.amiss.and.ob_dir(ii).ne.amiss) 
     $              c_qc(ii)(7:7) = 'I'
                  if(ob_dir(ii).eq.amiss.and.ob_spd(ii).ne.amiss) 
     $              c_qc(ii)(8:8) = 'I'
                  if(ob_spd(iim1).eq.amiss.and.ob_dir(iim1).ne.amiss)
     $              c_qc(iim1)(7:7) = 'I'
                  if(ob_dir(iim1).eq.amiss.and.ob_spd(iim1).ne.amiss) 
     $              c_qc(iim1)(8:8) = 'I'
c
c               Make sure retained report has all available values
c               (iim1 report is rejected; ii report is retained)
c               --------------------------------------------------
                elseif((c_qc(iim1)(1:1).eq.'W'.and.c_qc(ii).ne.'W').or.
     $                 (c_qc(iim1)(1:1).eq.'A'.and.c_qc(ii).ne.'A').or.
     $                 (c_qc(iim1)(1:1).eq.'t'.and.c_qc(ii).ne.'t'))then
c
                  if(ob_t(ii).eq.amiss.and.ob_t(iim1).ne.amiss) then 
                    ob_t(ii) = ob_t(iim1)
                    c_qc(ii)(6:6) = c_qc(iim1)(6:6)
                    ob_t(iim1) = amiss
                    c_qc(iim1)(6:6) = 'M'
                  endif
                  if(ob_dir(ii).eq.amiss.and.ob_dir(iim1).ne.amiss) then
                    ob_dir(ii) = ob_dir(iim1)
                    c_qc(ii)(7:7) = c_qc(iim1)(7:7) 
                    ob_dir(iim1) = amiss
                    c_qc(iim1)(7:7) = 'M'
                  endif
                  if(ob_dir(ii).lt.0.5.and.difdir.gt.10.5) then
                    ob_dir(ii) = ob_dir(iim1)
                    c_qc(ii)(7:7) = c_qc(iim1)(7:7) 
                    ob_dir(iim1) = amiss
                    c_qc(iim1)(7:7) = 'M'
                  endif
                  if(ob_spd(ii).eq.amiss.and.ob_spd(iim1).ne.amiss) then
                    ob_spd(ii) = ob_spd(iim1)
                    c_qc(ii)(8:8) = c_qc(iim1)(8:8)
                    ob_spd(iim1) = amiss
                    c_qc(iim1)(8:8) = 'M'
                  endif
                  if(ob_spd(ii).lt.0.05.and.ob_spd(iim1).gt.1.25) then
                    ob_spd(ii) = ob_spd(iim1)
                    c_qc(ii)(8:8) = c_qc(iim1)(8:8)
                    ob_spd(iim1) = amiss
                    c_qc(iim1)(8:8) = 'M'
                  endif
c
                  if(ob_spd(ii).eq.amiss.and.ob_dir(ii).ne.amiss) 
     $              c_qc(ii)(7:7) = 'I'
                  if(ob_dir(ii).eq.amiss.and.ob_spd(ii).ne.amiss) 
     $              c_qc(ii)(8:8) = 'I'
                  if(ob_spd(iim1).eq.amiss.and.ob_dir(iim1).ne.amiss)
     $              c_qc(iim1)(7:7) = 'I'
                  if(ob_dir(iim1).eq.amiss.and.ob_spd(iim1).ne.amiss) 
     $              c_qc(iim1)(8:8) = 'I'
                endif
              endif
            endif
c
c           Print series of reports if desired
c           ----------------------------------
            if(l_print) then
              if(iim2.ne.0) write(io8,8002) kk,iim2
     x,            c_insty_ob(itype(iim2))
     x,            c_acftreg(iim2),c_acftid(iim2)
     x,            idt(iim2),alat(iim2),alon(iim2)
     x,            pres(iim2),ht_ft(iim2)
     x,            t_prcn(iim2),ob_t(iim2),xiv_t(iim2),ichk_t(iim2)
     x,            ob_q(iim2),xiv_q(iim2),ichk_q(iim2)
     x,            ob_dir(iim2),xiv_d(iim2),ichk_d(iim2)
     x,            ob_spd(iim2),xiv_s(iim2),ichk_s(iim2)
     x,            c_qc(iim2)
              if(iim1.ne.0) write(io8,8002) kk,iim1
     x,            c_insty_ob(itype(iim1))
     x,            c_acftreg(iim1),c_acftid(iim1)
     x,            idt(iim1),alat(iim1),alon(iim1)
     x,            pres(iim1),ht_ft(iim1)
     x,            t_prcn(iim1),ob_t(iim1),xiv_t(iim1),ichk_t(iim1)
     x,            ob_q(iim1),xiv_q(iim1),ichk_q(iim1)
     x,            ob_dir(iim1),xiv_d(iim1),ichk_d(iim1)
     x,            ob_spd(iim1),xiv_s(iim1),ichk_s(iim1)
     x,            c_qc(iim1)
              write(io8,8002) kk,ii,c_insty_ob(itype(ii))
     x,            c_acftreg(ii),c_acftid(ii)
     x,            idt(ii),alat(ii),alon(ii)
     x,            pres(ii),ht_ft(ii)
     x,            t_prcn(ii),ob_t(ii),xiv_t(ii),ichk_t(ii)
     x,            ob_q(ii),xiv_q(ii),ichk_q(ii)
     x,            ob_dir(ii),xiv_d(ii),ichk_d(ii)
     x,            ob_spd(ii),xiv_s(ii),ichk_s(ii)
     x,            c_qc(ii)
              if(iip1.ne.0) write(io8,8002) kk,iip1
     x,            c_insty_ob(itype(iip1))
     x,            c_acftreg(iip1),c_acftid(iip1)
     x,            idt(iip1),alat(iip1),alon(iip1)
     x,            pres(iip1),ht_ft(iip1)
     x,            t_prcn(iip1),ob_t(iip1),xiv_t(iip1),ichk_t(iip1)
     x,            ob_q(iip1),xiv_q(iip1),ichk_q(iip1)
     x,            ob_dir(iip1),xiv_d(iip1),ichk_d(iip1)
     x,            ob_spd(iip1),xiv_s(iip1),ichk_s(iip1)
     x,            c_qc(iip1)
            endif
c
c End loop over reports
c ---------------------
          enddo
c
c Check rest of flight if stuck clock found
c -----------------------------------------
          if(stuck) then
            do iob = istart,iend
              ii = indx(iob)
              if(idt(ii).eq.idt_stk.and.
     $           c_qc(ii)(2:2).ne.'K') then
                c_qc(ii)(2:2) = 'K'
                write(io8,*)
                write(io8,*) 'Another stuck clock found'
                write(io8,8002) kk,ii,c_insty_ob(itype(ii))
     x,            c_acftreg(ii),c_acftid(ii)
     x,            idt(ii),alat(ii),alon(ii)
     x,            pres(ii),ht_ft(ii)
     x,            t_prcn(ii),ob_t(ii),xiv_t(ii),ichk_t(ii)
     x,            ob_q(ii),xiv_q(ii),ichk_q(ii)
     x,            ob_dir(ii),xiv_d(ii),ichk_d(ii)
     x,            ob_spd(ii),xiv_s(ii),ichk_s(ii)
     x,            c_qc(ii)
              endif
            enddo
          endif
c
c End if clause for real flights with at least three reports
c ----------------------------------------------------------
        endif
c
c End loop over flights
c ---------------------
      enddo
c
c Write out bad reports
c ---------------------
      if(.not.l_operational) then
        write(io35,*)
        write(io35,*) 'Inconsistent positions'
        write(io35,*) '----------------------'
        write(io35,3001)
 3001   format(' index  type    tail num   flight     time       lat'
     x,      '        lon       pres  height '
     x,      't-prcn   temp     innov  ichk'
     x,      ' spec hum    innov  ichk'
     x,      '   ob_dir    innov  ichk'
     x,      '   ob_spd    innov  ichk'
     x,      '   qc flag')
      endif
c
      kbad = 0
c
      do iob = 1,numreps
        ii = indx(iob)
c
        if(itype(ii).eq.i_mdcrs.or.
     $     itype(ii).eq.i_mdcrs_lvl.or.
     $     itype(ii).eq.i_mdcrs_asc.or.
     $     itype(ii).eq.i_mdcrs_des) then
          ktype = 1
c
        elseif(itype(ii).eq.i_acars.or.
     $         itype(ii).eq.i_acars_lvl.or.
     $         itype(ii).eq.i_acars_asc.or.
     $         itype(ii).eq.i_acars_des) then
          ktype = 2
c         
        elseif(itype(ii).eq.i_amdar.or. 
     $         itype(ii).eq.i_amdar_lvl.or.
     $         itype(ii).eq.i_amdar_asc.or.
     $         itype(ii).eq.i_amdar_des) then
          ktype = 3
c
        elseif(itype(ii).eq.i_airep.or.
     $         itype(ii).eq.i_airep_lvl.or.
     $         itype(ii).eq.i_airep_asc.or.
     $         itype(ii).eq.i_airep_des) then
          ktype = 4
c
        elseif(itype(ii).eq.i_man_airep.or.
     $         itype(ii).eq.i_man_Yairep) then
          ktype = 5
        endif
c
        if(ktype.eq.1) then
          nrep_Md = nrep_Md + 1
        elseif(ktype.eq.2) then
          nrep_Ac = nrep_Ac + 1
        elseif(ktype.eq.3) then
          nrep_Am = nrep_Am + 1
        elseif(ktype.eq.4) then
          nrep_Ar = nrep_Ar + 1
        elseif(ktype.eq.5) then
          nrep_Ma = nrep_Ma + 1
        endif
c
        if(c_qc(ii)(1:1).eq.'r'.or.
     $     c_qc(ii)(1:1).eq.'W'.or.
     $     c_qc(ii)(1:1).eq.'A'.or.
     $     c_qc(ii)(1:1).eq.'t'.or.
     $     c_qc(ii)(2:2).eq.'K'.or.
     $     c_qc(ii)(2:2).eq.'R'.or.
     $     c_qc(ii)(3:4).eq.'RR'.or.
     $     c_qc(ii)(5:5).eq.'B') then
c
          if(.not.l_operational) then
            write(io35,3002) ii,c_insty_ob(itype(ii))
     x,        c_acftreg(ii),c_acftid(ii)
     x,        idt(ii),alat(ii),alon(ii)
     x,        pres(ii),ht_ft(ii)
     x,        t_prcn(ii),ob_t(ii),xiv_t(ii),ichk_t(ii)
     x,        ob_q(ii),xiv_q(ii),ichk_q(ii)
     x,        ob_dir(ii),xiv_d(ii),ichk_d(ii)
     x,        ob_spd(ii),xiv_s(ii),ichk_s(ii)
     x,        c_qc(ii)
 3002       format(i6,1x,a8,1x,a8,1x,a9,1x,i7,1x,2f11.5,1x,f8.1,1x,f7.0
     x,          1x,f5.2,4(2(1x,f8.2),1x,i5),1x,'!',a11,'!')
          endif
c
c         Count by category
c         -----------------
          if(c_qc(ii)(1:1).eq.'r') then
            ninc_xtra(ktype) = ninc_xtra(ktype) + 1
          elseif(c_qc(ii)(1:1).eq.'W') then
            ninc_way(ktype) = ninc_way(ktype) + 1
          elseif(c_qc(ii)(1:1).eq.'A') then
            ninc_alt(ktype) = ninc_alt(ktype) + 1
          elseif(c_qc(ii)(2:2).eq.'K') then
            ninc_stk(ktype) = ninc_stk(ktype) + 1
          elseif(c_qc(ii)(2:2).eq.'B') then
            ninc_time(ktype) = ninc_time(ktype) + 1
          elseif(c_qc(ii)(3:4).eq.'RR'.or.
     $           c_qc(ii)(2:2).eq.'R') then
            ninc_avg(ktype) = ninc_avg(ktype) + 1
          elseif(c_qc(ii)(5:5).eq.'B') then
            ninc_bad(ktype) = ninc_bad(ktype) + 1
          endif
        endif
c
c       Reject redundant reports and reports with inconsistent positions
c       ----------------------------------------------------------------          
        if(c_qc(ii)(1:1).eq.'r'.or.
     $     c_qc(ii)(1:1).eq.'W'.or.
     $     c_qc(ii)(1:1).eq.'A'.or.
     $     c_qc(ii)(1:1).eq.'t'.or.
     $     c_qc(ii)(2:2).eq.'K'.or.
     $     c_qc(ii)(5:5).eq.'B') then
c
          csort(ii)(1:5) = 'badob'
c
          kbad(ktype) = kbad(ktype) + 1
c
          if(ktype.eq.1) then
            ninc_Md = ninc_Md + 1
          elseif(ktype.eq.2) then
            ninc_Ac = ninc_Ac + 1
          elseif(ktype.eq.3) then
            ninc_Am = ninc_Am + 1
          elseif(ktype.eq.4) then
            ninc_Ar = ninc_Ar + 1
          elseif(ktype.eq.5) then
            ninc_Ma = ninc_Ma + 1
          endif
        endif
c
      enddo
c
      if(.not.l_operational) then
        write(io35,*)
        write(io35,*)'  Number of inc MDCRS    reps rejected = ',kbad(1)
ccccdak        write(io35,*)'  Number of inc ACARS    reps rejected = ',kbad(2)
        write(io35,*)'  Number of inc TAMDAR   reps rejected = ',kbad(2)
        write(io35,*)'  Number of inc AMDAR    reps rejected = ',kbad(3)
        write(io35,*)'  Number of inc AIREP    reps rejected = ',kbad(4)
        write(io35,*)'  Number of inc manAIREP reps rejected = ',kbad(5)
      endif
c
      write(io8,*)
      write(io8,*) '  Reports with inconsistent positions--rejected'
      write(io8,*) '  ---------------------------------------------'
      write(io8,*)'  Number of inc MDCRS    reps rejected = ',kbad(1)
ccccdak      write(io8,*)'  Number of inc ACARS    reps rejected = ',kbad(2)
      write(io8,*)'  Number of inc TAMDAR   reps rejected = ',kbad(2)
      write(io8,*)'  Number of inc AMDAR    reps rejected = ',kbad(3)
      write(io8,*)'  Number of inc AIREP    reps rejected = ',kbad(4)
      write(io8,*)'  Number of inc manAIREP reps rejected = ',kbad(5)
c
      write(*,*)
      write(*,*) 'Inconsistent position check data counts--',cdtg_an
      write(*,*) '---------------------------------------------------'
      write(*,'(1x,a55)')
ccccdak     $ 'Type of check     MDCRS   ACARS   AMDAR   AIREP     man'
     $ 'Type of check     MDCRS  TAMDAR   AMDAR   AIREP     man'
      write(*,'(1x,a55)')
     $ '--------------- ------- ------- ------- ------- -------'
      write(*,'('' Num considered '',5(1x,i7))')
     $            nrep_Md,nrep_Ac,nrep_Am,nrep_Ar,nrep_Ma
      write(*,'('' Total rejected '',5(1x,i7))')
     $            ninc_Md,ninc_Ac,ninc_Am,ninc_Ar,ninc_Ma
      write(*,'(1x,a55)')
     $ '--------------- ------- ------- ------- ------- -------'
c
      write(io8,*)
      write(io8,*) 'Inconsistent position check data counts'
      write(io8,*) '---------------------------------------'
      write(io8,'(1x,a55)')
ccccdak     $ 'Type of check     MDCRS   ACARS   AMDAR   AIREP     man'
     $ 'Type of check     MDCRS  TAMDAR   AMDAR   AIREP     man'
      write(io8,'(1x,a55)')
     $ '--------------- ------- ------- ------- ------- -------'
      write(io8,'(''Num considered '',5(1x,i7))')
     $            nrep_Md,nrep_Ac,nrep_Am,nrep_Ar,nrep_Ma
      write(io8,'(''Total rejected '',5(1x,i7))')
     $            ninc_Md,ninc_Ac,ninc_Am,ninc_Ar,ninc_Ma
      write(io8,'(1x,a55)')
     $ '--------------- ------- ------- ------- ------- -------'
      write(io8,'(''Redundant reps '',5(1x,i7))')
     $          (ninc_xtra(ii),ii=1,5)
      write(io8,'(''Bad waypoint   '',5(1x,i7))')
     $          (ninc_way(ii),ii=1,5)
      write(io8,'(''Bad altitude   '',5(1x,i7))')
     $          (ninc_alt(ii),ii=1,5)
      write(io8,'(''Stuck clock    '',5(1x,i7))')
     $          (ninc_stk(ii),ii=1,5)
      write(io8,'(''Bad time       '',5(1x,i7))')
     $          (ninc_time(ii),ii=1,5)
      write(io8,'(''Inconsistent ht'',5(1x,i7))')
     $          (ninc_bad(ii),ii=1,5)
      write(io8,'(1x,a55)')
     $ '--------------- ------- ------- ------- ------- -------'
      write(io8,'(''Avg posn/time  '',5(1x,i7))')
     $          (ninc_avg(ii),ii=1,5)
      write(io8,'(1x,a55)')
     $ '--------------- ------- ------- ------- ------- -------'
c
      kbadtot = kbad(1) + kbad(2) + kbad(3)
     $        + kbad(4) + kbad(5) 
c
      write(io8,*)
      write(io8,*) numreps,' good reports processed'
      write(io8,*) kbadtot,' reports failed qc in position check'
c
      return
      end
c
c ###################################################################
c                            subroutine orddup_qc
c ###################################################################
c   
      subroutine orddup_qc(max_reps,indx,isave,ht_ft,idt,alat,alon
     $,          kflight,maxflt,nobs_flt,iobs_flt
     $,          c_acftreg,c_acftid,cidmiss,idt_near,io8)
c
c     Check the ordering of near-duplicate reports based on heights
c
      implicit none
c
      integer      io8                 ! i/o unit number for log file
      integer      iob                 ! do loop index 
     $,            max_reps            ! max number of observations/reports
     $,            ii                  ! index pointing to current report
     $,            iim1                ! index pointing to previous report
     $,            iim2                ! index pointing to two reports ago
     $,            iim3                ! index pointing to three reports ago
     $,            iip1                ! index pointing to following report
     $,            iip2                ! index pointing to report after next
      integer      indx(max_reps)      ! pointer array
     $,            isave(max_reps)     ! second pointer array used to reverse order
      integer      kk                  ! do loop index
      integer      knt                 ! number of reports with the same time
     $,            kneg                ! number of reports with negative heights
                                       !   and with the same time
     $,            kkk                 ! do loop index
     $,            nn                  ! do loop index
     $,            nback               ! variable used in reversing order
      integer      idt_dif1            ! first time difference
     $,            idt_dif2            ! second time difference
      integer      idt_near            ! time difference between "near" neighbors
c
c     Work arrays
c     -----------
      real         ht_ft(max_reps)     ! height in feet
      integer      iht0,iht1           ! integer height in feet
      integer      idt(max_reps)       ! time in seconds to analysis time
      real*8       alat(max_reps)      ! latitude
     $,            alon(max_reps)      ! longitude
      character*9  c_acftid(max_reps)  ! acft flight number
      character*8  c_acftreg(max_reps) ! acft tail number
c
      character*8  cidmiss             ! missing value flag for flight number
c
      integer      maxflt              ! max number of flights allowed
      integer      kflight             ! number of flights in dataset
      integer      nobs_flt(maxflt)    ! number of reports per flight
     $,            iobs_flt(maxflt)    ! index for first report in each flight
      integer      istart              ! index for first report in current flight 
     $,            iistart             ! index from pointer array for istart
     $,            iend                ! index for last report in current flight
     $,            iiend               ! index from pointer array for iend
     $,            inow                ! iob + 1
     $,            inext               ! counter
     $,            iinext              ! index from pointer array for inext
     $,            ilast               ! index for last report with same time
     $,            iilast              ! index from pointer array for ilast
     $,            iilastm1            ! index from pointer array for ilast-1
     $,            iilastm2            ! index from pointer array for ilast-2
     $,            iilastp1            ! index from pointer array for ilast+1
     $,            iibefore            ! index from pointer array for previous rep
     $,            iiafter             ! index from pointer array for following rep
     $,            iii                 ! index pointer for current report
     $,            iiim1               ! index pointer for previous report
      real*8       alat_dif            ! latitude difference used to check ordering
     $,            alon_dif            ! longitude difference used to check ordering
      real         ht_max              ! maximum height in group with same time
     $,            ht_min              ! minimum height in group with same time
     $,            ht_dif1,ht_dif2     ! height differences
c
      logical      sameht              ! true if altitudes are equal
c
      logical      l_print             ! print diagnostic output if true
c
c # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # #
c
c Begin loop over flights
c -----------------------
      do kk = 1,kflight
c
c Initialize variables
c --------------------
        istart = iobs_flt(kk)
        iistart = indx(istart)
        iend = iobs_flt(kk) + nobs_flt(kk) - 1
        iiend = indx(iend)
c
c Set print switch
c ----------------
      l_print = .false.
      if(c_acftreg(iistart)(1:8).eq.'########') l_print = .true.
c
      if(l_print) then
        write(io8,*)
        write(io8,*) 'orddup output for ########'
        write(io8,*) '--------------------------'
        write(io8,*) 'iistart,iiend = ',iistart,iiend
      endif
c
c Don't compare reports with missing flight number
c Perform check only for flights with three or more reports
c -----------------------------------------------------------------
        if(c_acftid(iistart)(1:8).ne.cidmiss(1:8).and.
     $     nobs_flt(kk).ge.3) then
c
         if(l_print) write(io8,*) 'Valid flight found'
c
c Check ordering of reports with the same time
c --------------------------------------------
c
c         Compute indices
c         ---------------
          iob = istart
c
          do while(iob.lt.iend)
            if(iob.gt.istart+2) then
              iim3 = indx(iob-3)
            else
              iim3 = 0
            endif
c
            if(iob.gt.istart+1) then
              iim2 = indx(iob-2)
            else
              iim2 = 0
            endif
c
            if(iob.gt.istart) then
              iim1 = indx(iob-1)
            else
              iim1 = 0
            endif
c
            ii   = indx(iob)
c
            if(iob.lt.iend) then
              iip1 = indx(iob+1)
            else
              iip1 = 0
            endif
c
            if(iob.lt.iend-1) then
              iip2 = indx(iob+2)
            else
              iip2 = 0
            endif
c
c           Count number of reports with same time
c           --------------------------------------
            if(iip1.ne.0) then
              if(idt(ii).eq.idt(iip1)) then
                knt = 2
c               write(io8,*)
c               write(io8,*) 'Second report with same time--',ii,iip1,knt
c
                ht_max = ht_ft(ii)
                if(ht_ft(iip1).gt.ht_max) ht_max = ht_ft(iip1)
c
                ht_min = ht_ft(ii)
                if(ht_ft(iip1).lt.ht_min) ht_min = ht_ft(iip1)
c
                if(ht_ft(ii).lt.0) then
                  kneg = 1
c                  write(io8,*) 
c                  write(io8,*) 'Negative height found for ii=',ii
                else
                  kneg = 0
                endif
c
                if(ht_ft(iip1).lt.0) then
                  kneg = kneg + 1
c                  write(io8,*) 'A second neg ht found for ii=',iip1
                endif
c
                inow = iob + 1
                inext = inow + 1
c
 10             if(inext.le.iend) then
                  iinext = indx(inext)
                  if(idt(ii).eq.idt(iinext)) then
                    knt = knt + 1
c                    write(io8,*) 'Another report with same time--',inext
                    if(ht_ft(iinext).gt.ht_max) ht_max = ht_ft(iinext)
                    if(ht_ft(iinext).lt.ht_min) ht_min = ht_ft(iinext)
                    if(ht_ft(iinext).lt.0) then
                      kneg = kneg + 1
c                      write(io8,*) 'Another neg ht found for ii=',iinext
                    endif
                    inext = inext + 1
                    goto 10
                  endif
                endif
c
                if(l_print) then
                  write(io8,*)
                  write(io8,*) '#obs with same time = ',knt
                  write(io8,*) '#obs with neg height = ',kneg
                  write(io8,*) 'ht_max,ht_min = ',ht_max,ht_min
                  write(io8,*) 'inow,inext = ',inow,inext
                  write(io8,*) 'iim3,iim2,iim1 = ',iim3,iim2,iim1
                  write(io8,*) 'ii,iip1,iip2   = ',ii,iip1,iip2
                endif
c
                ilast = inext - 1
                if(ilast.le.iend) then
                  iilast   = indx(ilast)
                else
                  iilast = 0
                endif
                if(ilast+1.le.iend) then
                  iilastp1 = indx(ilast+1)
                else
                  iilastp1 = 0
                endif
                if(ilast-1.ge.istart) then
                  iilastm1 = indx(ilast-1)
                else
                  iilastm1 = 0
                endif
                if(ilast-2.ge.istart) then
                  iilastm2 = indx(ilast-2)
                else
                  iilastm2 = 0
                endif
c
                if(l_print) then
                  write(io8,*) 'iilastm2,iilastm1 = ',iilastm2,iilastm1
                  write(io8,*) 'iilast,iilastp1   = ',iilast,iilastp1
                endif
c
c               Case with duplicates in middle of flight
c               ----------------------------------------
                if(iim1.ne.0.and.iip1.ne.0.and.
     $             iilast.ne.0.and.iilastp1.ne.0.and.
     $             iilastm1.ne.0) then
c
                  idt_dif1 = abs(idt(ii) - idt(iim1))
                  iibefore = iim1
                  if(idt_dif1.ge.idt_near) then 
                    idt_dif1 = abs(idt(iip1) - idt(ii))
                    iibefore = ii
                  endif
c
                  idt_dif2 = abs(idt(iilastp1) - idt(iilast))
                  iiafter  = iilastp1
                  if(idt_dif2.ge.idt_near) then 
                    idt_dif2 = abs(idt(iilast) - idt(iilastm1))
                    iiafter = iilast
                  endif
c
                  if(l_print) then
                    write(io8,*) 'Duplicates in middle of flight'
                    write(io8,*) 'idt_dif1,idt_dif2= ',idt_dif1,idt_dif2
                    write(io8,*) 'iibefore,iiafter = ',iibefore,iiafter
                  endif
c
c                 Check if near dups are part of a level flight leg
c                 -------------------------------------------------
                  if(abs(ht_ft(iibefore) - ht_ft(iiafter)).le.100.0.and.
     $               abs(ht_ft(iibefore) - ht_max).le.100.0.and.
     $               abs(ht_min - ht_ft(iiafter)).le.100.0) then
c
                    if(l_print) 
     $              write(io8,*) 'Near dups in smooth level leg--ii=',ii
c
c                 Or part of a smooth ascent
c                 --------------------------
                  elseif(ht_ft(iibefore).lt.ht_ft(iiafter).and.
     $                   ht_ft(iibefore).le.ht_min.and.
     $                   ht_max.le.ht_ft(iiafter)) then
c
                    if(l_print)
     $                write(io8,*) 'Near dups in smooth ascent--ii=',ii
c
c                 Or part of smooth descent
c                 -------------------------
                  elseif(ht_ft(iibefore).gt.ht_ft(iiafter).and.
     $                   ht_ft(iibefore).ge.ht_max.and.
     $                   ht_min.ge.ht_ft(iiafter)) then
c
                    if(l_print) 
     $                write(io8,*) 'Near dups in smooth descent--ii=',ii
c
c                 Or near dups are near max or min altitude
c                 -----------------------------------------
                  else
c
                    ht_dif1 = abs(ht_ft(iibefore) - ht_ft(ii))
                    ht_dif2 = abs(ht_ft(iilast) - ht_ft(iiafter))
c
c                   Re-set iibefore or iiafter if appropriate
c                   -----------------------------------------
                    if(idt_dif1.lt.idt_dif2.and.
     $                 iibefore.ne.ii.and.iiafter.ne.iilast) then
c
                      idt_dif2 = abs(idt(iilast) - idt(iilastm1))
                      iiafter = iilast
c
                      if(l_print) then
                      write(io8,*) 'Near dups near peak alt-1-ii=',ii
                      write(io8,*) 'idt_dif2,iiafter= ',idt_dif2,iiafter
                      endif
c
                    elseif(idt_dif1.gt.idt_dif2.and.
     $                     iibefore.ne.ii.and.iiafter.ne.iilast) then
c
                      idt_dif1 = abs(idt(iip1) - idt(ii))
                      iibefore = ii
c
                      if(l_print) then
                      write(io8,*)
                      write(io8,*)'Near dups near peak alt-2-ii=',ii
                      write(io8,*)'idt_dif1,iibefore=',idt_dif1,iibefore
                      endif
c
                    elseif(idt_dif1.eq.idt_dif2.and.                                     
     $                     iibefore.ne.ii.and.iiafter.eq.iilast) then
c
                      if(idt(iip2)-idt(iip1).ge.idt_near) then
                        idt_dif2 = abs(idt(iilastm1) - idt(iilastm2))
                        iiafter = iilastm1
c
                        if(l_print) then
                        write(io8,*)'Dropping last point in descent',ii
                        write(io8,*)'idt_dif2,iiafter=',idt_dif2,iiafter
                        endif
c
                      elseif(ht_dif1.lt.ht_dif2) then
                        idt_dif2 = abs(idt(iilast) - idt(iilastm1))
                        iiafter = iilast
c
                        if(l_print) then
                        write(io8,*)'Near dups near peak alt-3-ii=',ii
                        write(io8,*)'idt_dif2,iiafter=',idt_dif2,iiafter
                        endif
c
                      elseif(ht_dif1.gt.ht_dif2) then
                        idt_dif1 = abs(idt(iip1) - idt(ii))
                        iibefore = ii
c
                        if(l_print) then
                        write(io8,*)'Near dups near peak alt-4-ii=',ii
                        write(io8,*)'idt_dif1,iibefr=',idt_dif1,iibefore
                        endif
c
                      else
                        if(l_print) then
                        write(io8,*)'Near dups near peak alt-5-ii=',ii
                        write(io8,*)'Neither time nor height check used'
                        endif
                      endif
c
                    else
                      if(l_print) then
                        write(io8,*) 'Near dups near peak alt-6-ii=',ii
                        write(io8,*) 'Indices not reset'
                      endif
                    endif
                  endif
c
c               Case with duplicates during whole flight
c               ----------------------------------------
                elseif(iob.eq.istart.and.ilast.eq.iend.and.
     $                 iilastm1.ne.0) then
                  idt_dif1 = 0
                  iibefore = ii
                  idt_dif2 = abs(idt(iilast) - idt(iilastm1))
                  iiafter = iilast
c
                  if(l_print) then
                    write(io8,*) 'Near dups found during whole flight'
                    write(io8,*) knt,' reports found with same time'
                    write(io8,*) 'idt_dif1,idt_dif2= ',idt_dif1,idt_dif2
                    write(io8,*) 'iibefore,iiafter = ',iibefore,iiafter
                  endif
c
c               Case with duplicates at beginning of flight
c               -------------------------------------------
                elseif(iob.eq.istart.and.ilast.le.iend.and.
     $                 iilastm1.ne.0.and.iilastp1.ne.0) then
                  idt_dif1 = 0
                  iibefore = ii
                  idt_dif2 = abs(idt(iilast) - idt(iilastp1))
                  iiafter  = iilastp1
                  if(idt_dif2.ge.idt_near) then 
                    idt_dif2 = abs(idt(iilast) - idt(iilastm1))
                    iiafter = iilast
                  endif
c
                  if(l_print) then
                    write(io8,*)'Near dups found at beginning of flight'
                    write(io8,*) knt,' reports found with same time'
                    write(io8,*) 'idt_dif1,idt_dif2= ',idt_dif1,idt_dif2
                    write(io8,*) 'iibefore,iiafter = ',iibefore,iiafter
                  endif
c
c               Case with duplicates at end of flight
c               -------------------------------------
                elseif(iob.gt.istart.and.ilast.eq.iend.and.
     $                 iim1.ne.0.and.iip1.ne.0) then
                  idt_dif1 = abs(idt(ii) - idt(iim1))
                  iibefore = iim1
                  if(idt_dif1.ge.idt_near) then 
                    idt_dif1 = abs(idt(iip1) - idt(ii))
                    iibefore = ii
                  endif
                  idt_dif2 = 0
                  iiafter  = iilast
c
                  if(l_print) then
                    write(io8,*) 'Near dups found at end of flight'
                    write(io8,*) knt,' reports found with same time'
                    write(io8,*) 'idt_dif1,idt_dif2= ',idt_dif1,idt_dif2
                    write(io8,*) 'iibefore,iiafter = ',iibefore,iiafter
                  endif
                endif
c
c               Check time differences--compare neighboring reports within idt_near
c               -------------------------------------------------------------------
                if(idt_dif1.lt.idt_near.and.idt_dif2.lt.idt_near) then
c
                  iht0 = nint(ht_ft(iibefore)/100.)
                  iht1 = nint(ht_ft(iiafter)/100.)
c
                  if(l_print) then
                    write(io8,*) 'Time differences within idt_near'
                    write(io8,*) 'iht0,iht1 = ',iht0,iht1
                  endif
c
c                 Check if all altitudes are equal
c                 --------------------------------
                  sameht = .true.
c
                  do kkk=iob,iob+knt-1
                   if(nint(ht_ft(indx(kkk))/100.).ne.
     $                nint(ht_ft(ii)/100.))
     $               sameht = .false.
                  enddo
c
                  if(l_print)
     $              write(io8,*) 'Altitudes equal?',sameht
c
c                 Use lat/lon to order obs if altitudes equal
c                 -------------------------------------------
                  if(sameht.and.knt.eq.2) then
c
                    alat_dif = abs(alat(iiafter) - alat(iibefore))
                    alon_dif = abs(alon(iiafter) - alon(iibefore))
                    iii = indx(iob+1)
                    iiim1 = indx(iob)
c
                    if(l_print) then 
                      write(io8,*) 'Level pair at ii = ',ii
                      write(io8,*) 'alat_dif = ',alat_dif
                      write(io8,*) 'alon_dif = ',alon_dif
                      write(io8,*) 'iii,iiim1 = ',iii,iiim1
                    endif
c
                    if(alat_dif.gt.alon_dif) then
                      if((alat(iibefore).gt.alat(iiafter).and.
     $                    alat(iiim1).lt.alat(iii)).or.
     $                   (alat(iibefore).le.alat(iiafter).and.
     $                    alat(iiim1).gt.alat(iii))) then
c
                        if(l_print) then
                          write(io8,*) 'Reversing pair of obs-1-',iii
                          write(io8,*) 'lats = ',alat(iiim1),alat(iii)
                        endif
c
                        indx(iob) = iii
                        indx(iob+1) = iiim1
                      endif
c
                    else
                      if((alon(iibefore).gt.alon(iiafter).and.
     $                    alon(iiim1).lt.alon(iii)).or.
     $                   (alon(iibefore).le.alon(iiafter).and.
     $                    alon(iiim1).gt.alon(iii))) then
c
                        if(l_print) then
                          write(io8,*) 'Reversing pair of obs-2-',iii
                          write(io8,*) 'lons = ',alon(iiim1),alon(iii)
                        endif
c
                        indx(iob) = iii
                        indx(iob+1) = iiim1
                      endif
                    endif
c
c                 Descent found
c                 -------------
                  elseif(iht0.gt.iht1) then
c
                    if(l_print)
     $                write(io8,*) 'Reversing descent at report',ii
c
c                   Re-order descending portions of flights with positive heights
c                   -------------------------------------------------------------
                    do nn = iob,ilast
                      nback = ilast - nn + iob
                      isave(nn) = indx(nback)
                    enddo
c
                    indx(iob:ilast) = isave(iob:ilast)
c
c                 Ascent found
c                 ------------
                  elseif(iht0.lt.iht1) then
c
                    if(l_print)
     $                write(io8,*) 'Ascent found at ii = ',ii
c
c                   Reorder portions of flight with negative heights
c                   ------------------------------------------------
                    if(kneg.eq.2.and.ht_ft(ii).lt.0.and.
     $                 ht_ft(ii).ne.ht_ft(iip1)) then
c
cc 12/01                      if(l_print)
cc 12/01     $                  write(io8,*) 'Reversing neg alts--ii=',ii,
c
cc 12/01     +			ht_ft(ii),ht_ft(iip1)
c
cc 12/01                      iiim1 = indx(iob)
cc 12/01                      indx(iob) = indx(iob+1)
cc 12/01                      indx(iob+1) = iiim1
c
                    endif
c
c                 Level flight found
c                 ------------------
                  elseif(iht0.eq.iht1) then
c                    sameht = .true.
c
                    if(l_print)
     $                write(io8,*) 'Level flight at ii = ',ii 
c
c                   Slight descent found--reorder
c                   -----------------------------
c                    if(knt.eq.2.and.
                    if(
     $                     nint(ht_ft(indx(iob))).gt.
     $                     nint(ht_ft(iilast))) then
c
c                      if(l_print) then
c                        write(io8,*) 'Reordering slight descent--',iii
c                        write(io8,*) 'alt= ',ht_ft(indx(iob)),
c     $                               ht_ft(indx(iob+1))
c                      endif
cc
c                      iii = indx(iob+1)
c                      iiim1 = indx(iob)
c                      indx(iob) = iii
c                      indx(iob+1) = iiim1
c
                      if(l_print)
     $                  write(io8,*) 'Reversing descent at report',ii
c
c                     Re-order descending portions of flights with positive heights
c                     -------------------------------------------------------------
                      do nn = iob,ilast
                        nback = ilast - nn + iob
                        isave(nn) = indx(nback)
                      enddo
c
                      indx(iob:ilast) = isave(iob:ilast)
c
c                   Ordering unknown
c                   ----------------
                    else
c
c                     Try using lat/lon to order obs
c                     ------------------------------
                      if(knt.eq.2) then
c
                        alat_dif = abs(alat(iiafter) - alat(iibefore))
                        alon_dif = abs(alon(iiafter) - alon(iibefore))
                        iii = indx(iob+1)
                        iiim1 = indx(iob)
c
                        if(l_print) then 
                          write(io8,*) 'Unknown ordering at ii = ',ii
                          write(io8,*) 'alat_dif = ',alat_dif
                          write(io8,*) 'alon_dif = ',alon_dif
                          write(io8,*) 'iii,iiim1 = ',iii,iiim1
                        endif
c
                        if(alat_dif.gt.alon_dif) then
                          if((alat(iibefore).gt.alat(iiafter).and.
     $                        alat(iiim1).lt.alat(iii)).or.
     $                       (alat(iibefore).le.alat(iiafter).and.
     $                        alat(iiim1).gt.alat(iii))) then
c
                            if(l_print) then
                              write(io8,*) 'Reversing unknown order-1-'
     $,                                    iii
                              write(io8,*)'lats= ',alat(iiim1),alat(iii)
                            endif
c
                            indx(iob) = iii
                            indx(iob+1) = iiim1
                          endif
c
                        else
                          if((alon(iibefore).gt.alon(iiafter).and.
     $                        alon(iiim1).lt.alon(iii)).or.
     $                       (alon(iibefore).le.alon(iiafter).and.
     $                        alon(iiim1).gt.alon(iii))) then
c
                            if(l_print) then
                              write(io8,*) 'Reversing unknown order-2-'
     $,                                    iii
                              write(io8,*)'lons =',alon(iiim1),alon(iii)
                            endif
c
                            indx(iob) = iii
                            indx(iob+1) = iiim1
                          endif
                        endif
c
                      else
                        write(io8,*) 'Ordering unknown--ii = ',ii
                        write(io8,*) 'Flight # = ',c_acftid(ii)
c
                        do kkk=iob-1,iob+knt
                          write(io8,*) 'ht_ft(',indx(kkk),') = '
     $                                ,ht_ft(indx(kkk))
     $                                ,' idt = ',idt(indx(kkk))
                        enddo
                      endif
                    endif
                  endif
c
c
c               Time differences too large for comparison
c               -----------------------------------------
                elseif(l_print) then
                  write(io8,*)'Time diffs too large for comparison!'
                  write(io8,*)'idt_dif1=',idt_dif1,' iibefore=',iibefore
                  write(io8,*)'idt_dif2=',idt_dif2,' iiafter =',iiafter
                endif
c
                iob = ilast + 1             
c
              else
                iob = iob + 1
              endif
c
            else
              iob = iob + 1
            endif
c
          enddo
        endif
      enddo     
c
      return
      end       
c
c ###################################################################
c                            subroutine ordchek_qc
c ###################################################################
c   
      subroutine ordchek_qc(numreps,max_reps,indx,csort,imiss,amiss
     $,          idt_near,idt_updn,htdif_same,c_acftreg,c_acftid,cidmiss
     $,          c_qc,alat,alon,pres,ht_ft,t_prcn,ob_t,ob_q,ob_dir
     $,          ob_spd,xiv_t,xiv_q,xiv_d,xiv_s
     $,          idt,itype,ichk_t,ichk_q,ichk_d,ichk_s
     $,          kreg,creg_reg,nwind_reg
     $,          kflight,maxflt,nobs_flt,ntot_flt,iobs_flt,kbadtot
     $,          io8,io36,l_operational,l_init)
c
c     Check ordering of flights
c
c     Modified by P.M. Pauley (3/7/00)
c     Problems were found with the great circle distance calculation.
c     The calculation formula was changed from the law of cosines 
c     to the haversine formula, the latter of which works at the small
c     distances that gave the former problems.  An effort was also made
c     to compute the course direction explicitly, since the method used
c     was to compute the north-south and east-west distances and use 
c     them to compute the direction using a plane-geometry approximation.
c     However, the formulas for course direction that were tried had
c     more computational problems than the plane-geometry approximation,
c     so they were abandoned.  However, rather than computing the 
c     airspeed using the north-south and east-west components of the 
c     groundspeed and wind vectors, a method (again based on plane
c     geometry) to compute the magnitude of the airspeed vector as 
c     the third side of the wind triangle was derived.  This method
c     yields an airspeed that is more consistent with the computed
c     groundspeed and the wind than the previous method, which could
c     lead to unrealistic differences between the groundspeed and 
c     airspeed magnitudes.  These methods are not rigorously exact,
c     but were deemed sufficiently accurate for the purposes at hand.
c
c     Modified by P.M. Pauley 9/21/02
c     As data resolution has increased, some aspects of the track (such
c     as deciding a point is going backwards) have become less meaningful.
c     Changes were made to reduce the number of false positives.
c
      implicit none
c
c Declaration statements
c ----------------------
      integer      max_reps            ! maximum number of reports
c
      character*11 c_qc(max_reps)      ! internal qc flags
c
c     Data arrays
c     -----------
      integer      numreps             ! actual number of reports
      integer      itype(max_reps)     ! type of aircraft data
      integer      idt(max_reps)       ! time in seconds to analysis time 
      character*8  c_acftreg(max_reps) ! aircraft registration (tail) number
      character*9  c_acftid(max_reps)  ! aircraft flight number
      real*8       alat(max_reps)      ! latitude
     $,            alon(max_reps)      ! longitude
      real         pres(max_reps)      ! pressure
     $,            ht_ft(max_reps)     ! height in feet
      real         t_prcn(max_reps)    ! temperature precision
      real         ob_t(max_reps)      ! temperature
     $,            ob_q(max_reps)      ! specific humidity
     $,            ob_dir(max_reps)    ! wind direction
     $,            ob_spd(max_reps)    ! wind speed
      real         xiv_t(max_reps)     ! temperature innovation (ob - bk)
     $,            xiv_q(max_reps)     ! specific humidity innovation (ob - bk)
     $,            xiv_d(max_reps)     ! wind direction innovation (ob - bk)
     $,            xiv_s(max_reps)     ! wind speed innovation (ob - bk)
      integer      ichk_t(max_reps)    ! NRL QC flag for temperature ob
     $,            ichk_q(max_reps)    ! NRL QC flag for specific humidity ob
     $,            ichk_d(max_reps)    ! NRL QC flag for wind direction ob
     $,            ichk_s(max_reps)    ! NRL QC flag for wind speed ob
      character*25 csort(max_reps)     ! sort variable    
c
c     Pointers
c     --------
      integer      indx(max_reps)      ! pointer index for good reports
c
c     Functions
c     ---------
      character*16 c_insty_ob          ! function to convert integer instrument 
                                       !   type to character instrument type
      integer      insty_ob_fun        ! function to convert character
                                       !   instrument type to integer
      real         gcirc_qc            ! function to compute great circle distances
c
c     Flight statistics
c     -----------------
      integer      maxflt              ! max number of flights allowed
      integer      nobs_flt(maxflt)    ! number of reports per flight
     $,            ntot_flt(maxflt)    ! total number of reports per flight
     $,            iobs_flt(maxflt)    ! index for first report in each flight
     $,            kflight             ! number of flights in dataset
      integer      istart              ! index for 1st rep in current flight 
     $,            iistart             ! index from pointer array for istart
     $,            iend                ! index for last rep in current flight
     $,            iiend               ! index from pointer array for iend
     $,            iifirst             ! index from pointer array for beginning of first flight segment
     $,            jjstart             ! index for start of flight segment
     $,            iobfirst            ! index for beginning of first flight segment
     $,            iilast              ! index from pointer array for end of first flight segment
     $,            ioblast             ! index for end of first flight segment
c
c     Tail number statistics
c     ----------------------
      integer      kreg                ! actual number of tail#s in dataset
      character*8  creg_reg(maxflt)    ! tail numbers
      integer      nwind_reg(maxflt,5) ! number of reports w. rejected winds
c
c     Counters
c     --------
      integer      nord_dup(5)         ! number of previously undetected near duplicates
     $,            nord_stk(5)         ! number of reports with stuck times
     $,            nord_time(5)        ! number of reports with inconsistent times
     $,            nord_2nd(5)         ! number of reports with in second flights
     $,            nord_near(5)        ! number of reports rejected as closer to last rejected point
     $,            nord_aspd(5)        ! number of reports with excessive airspeed
     $,            nord_lone(5)        ! number of reports rejected as isolated off-track points
     $,            nord_dble(5)        ! number of reports rejected when track doubles back on itself
     $,            nord_turn(5)        ! number of reports rejected when track makes too large a turn
     $,            nord_alt(5)         ! number of reports with inconsistent altitudes
     $,            nord_wind(5)        ! number of reports with anomalous windspeeds
      integer      kbad(5)             ! counter for number of bad reports
     $,            kbadtot             ! counter for total number of bad reports
ccccdak      integer      nrep_Ac             ! number of acars reports considered
      integer      nrep_Ac             ! number of tamdar reports considered
     $,            nrep_Md             ! number of mdcrs reports considered
     $,            nrep_Ma             ! number of manual airep reports considered
     $,            nrep_Ar             ! number of airep reports considered
     $,            nrep_Am             ! number of amdar reports considered
ccccdak      integer      nord_Ac             ! number of acars reports rejected
      integer      nord_Ac             ! number of tamdar reports rejected
     $,            nord_Md             ! number of mdcrs reports rejected
     $,            nord_Ma             ! number of manual airep reports rejected
     $,            nord_Ar             ! number of airep reports rejected
     $,            nord_Am             ! number of amdar reports rejected
c
c     Instrument types
c     ----------------
ccccdak      integer      i_acars             ! instrument type for acars
      integer      i_acars             ! instrument type for tamdar
ccccdak     $,            i_acars_lvl         ! instrument type for acars--level flt
     $,            i_acars_lvl         ! instrument type for tamdar--level flt
ccccdak     $,            i_acars_asc         ! instrument type for acars--ascent
     $,            i_acars_asc         ! instrument type for tamdar--ascent
ccccdsk     $,            i_acars_des         ! instrument type for acars--descent
     $,            i_acars_des         ! instrument type for tamdar--descent
     $,            i_mdcrs             ! instrument type for mdcrs
     $,            i_mdcrs_lvl         ! instrument type for mdcrs--level flt
     $,            i_mdcrs_asc         ! instrument type for mdcrs--ascent
     $,            i_mdcrs_des         ! instrument type for mdcrs--descent
     $,            i_man_airep         ! instrument type for manual aireps
     $,            i_man_Yairep        ! instrument type for manual aireps (YRXX)
     $,            i_airep             ! instrument type for airep
     $,            i_airep_lvl         ! instrument type for airep--level flt
     $,            i_airep_asc         ! instrument type for airep--ascent
     $,            i_airep_des         ! instrument type for airep--descent
     $,            i_amdar             ! instrument type for amdar
     $,            i_amdar_lvl         ! instrument type for amdar--level flt
     $,            i_amdar_asc         ! instrument type for amdar--ascent
     $,            i_amdar_des         ! instrument type for amdar--descent
c
c     Other variables
c     ---------------
      integer      io8                 ! i/o unit number for log file
      integer      io36                ! i/o unit number for ordering check
c
      real         amiss               ! real missing value flag
      real         d2r                 ! conversion factor for degrees to radians
c
      integer      iob,job,nob,kk      ! do loop indices 
     $,            ii,jj,nn            ! index pointing to current report
     $,            mm                  ! index pointing to current tail number
     $,            iim1,nnm1           ! index pointing to previous report
     $,            iim2                ! index pointing to 2nd report previous
     $,            iim3                ! index pointing to 3rd report previous
     $,            iip1,jjp1,nnp1      ! index pointing to following report
     $,            iip2                ! index pointing to 2nd report following
     $,            iip3                ! index pointing to 3rd report following
     $,            iobp1               ! index for following report
     $,            iobp2               ! index for 2nd report following report
     $,            knt0                ! counter saved from definition of ii index
     $,            knt1                ! counter used to define iim1 index
     $,            knt2                ! counter used to define iim2 index
     $,            knt3                ! counter used to define iip1 index
     $,            knt4                ! counter used to define iip2 index
     $,            knt5                ! counter used to define iim3 index
     $,            knt6                ! counter used to define iip3 index
     $,            knt_iob             ! counter for number of times iob repeated
     $,            iob_sav             ! previous value of iob
     $,            knt_iip1_bad        ! number of times iip1 report is rejected as bad manuever
     $,            job_alat_min        ! index for minimum latitude
     $,            job_alat_max        ! index for maximum latitude
     $,            job_alon_min        ! index for minimum longitude
     $,            job_alon_max        ! index for maximum longitude
     $,            jj_alat_min         ! pointer index for minimum latitude
     $,            jj_alat_max         ! pointer index for maximum latitude
     $,            jj_alon_min         ! pointer index for minimum longitude
     $,            jj_alon_max         ! pointer index for maximum longitude
      integer      imiss               ! integer missing value flag
      integer      idt_near            ! time difference between "near" neighbors
      integer      idt_updn            ! time difference to check ascents/descents
      integer      idt0                ! time for report ii
     $,            idtm1               ! time for report iim1
     $,            idtm2               ! time for report iim2
     $,            idtm3               ! time for report iim3
     $,            idtp1               ! time for report iip1
     $,            idtp2               ! time for report iip2
     $,            idtp3               ! time for report iip3
     $,            idt_start           ! time for first report of flight
     $,            idt_end             ! time for last report of flight
     $,            idt_last_bad        ! time for last bad report
      integer      idt_dif0            ! time difference (current  - previous report)
     $,            idt_difm1           ! time difference (two previous reports)
     $,            idt_difm2           ! time difference (two reports before those)
     $,            idt_difp1           ! time difference (following - current report)
     $,            idt_difp2           ! time difference (two following reports)
     $,            idt_difp3           ! time difference (two reports after those)
     $,            idt_dif_wo0         ! time difference (iim1 and iip1 points)
     $,            idt_dif_wop1        ! time difference (ii and iip2 points)
     $,            idt_dif_wop2        ! time difference (iip1 and iip3 points)
     $,            idt_dif_bad0        ! time difference (ii and last_bad points)
     $,            idt_dif_badp1       ! time difference (iip1 and last_bad points)
     $,            idt_dif_track       ! time difference (first and last points)
c
      integer      ktype               ! ob type
     $,            itype0              ! ob type for ii report
     $,            itypem1             ! ob type for iim1 report
     $,            itypep1             ! ob type for iip1 report
     $,            itypep2             ! ob type for iip2 report
c
      real         htdif_same          ! height difference considered negligible
      real*8       alat_dif            ! latitude difference (current-previous report)
     $,            alon_dif            ! longitude difference (current-previous report)
     $,            alat_min            ! minimum latitude for flight
     $,            alat_max            ! maximum latitude for flight
     $,            alon_min            ! minimum longitude for flight
     $,            alon_max            ! maximum longitude for flight
     $,            alat0               ! latitude in current report
     $,            alatm1              ! latitude in previous report
     $,            alatm2              ! latitude at 2nd previous report
     $,            alatm3              ! latitude at 3rd previous report
     $,            alatp1              ! latitude at following report
     $,            alatp2              ! latitude at 2nd following report
     $,            alatp3              ! latitude at 3rd following report
     $,            alon0               ! longitude in current report
     $,            alonm1              ! longitude in previous report
     $,            alonm2              ! longitude at 2nd previous report
     $,            alonm3              ! longitude at 3rd previous report
     $,            alonp1              ! longitude at following report
     $,            alonp2              ! longitude at 2nd following report
     $,            alonp3              ! longitude at 3rd following report
      real         ht_dif0             ! height difference (current-previous report)
     $,            ht_difm1            ! height difference (two previous reports)
     $,            ht_difm2            ! height difference (two reports before those)
     $,            ht_difp1            ! height difference (following-current report)
     $,            ht_difp2            ! height difference (two following reports)
     $,            ht_difp3            ! height difference (two reports after those)
     $,            ht_dif_wo0          ! height difference between iim1 and iip1 reports
     $,            ht_dif_wop1         ! height difference between ii and iip2 reports
     $,            ht_dif_wop2         ! height difference between iip1 and iip3 reports
     $,            ht_dif_bad0         ! height difference between ii and last_bad reports
     $,            ht_dif_badp1        ! height difference between iip1 and last_bad reports
     $,            ht_dif_track        ! height difference between first and last reports
     $,            dif_t               ! temperature difference (current-previous report)
     $,            dif_dir             ! direction difference (current-previous report)
     $,            dif_spd             ! speed difference (current-previous report)
     $,            ht_ft0              ! height in current report
     $,            ht_ftm1             ! height in previous report
     $,            ht_ftm2             ! height at 2nd previous report
     $,            ht_ftm3             ! height at 3rd previous report
     $,            ht_ftp1             ! height at following report
     $,            ht_ftp2             ! height at 2nd following report
     $,            ht_ftp3             ! height at 3rd following report
c
c      real         uwind0              ! u component for wind at ii point
c     $,            vwind0              ! v component for wind at ii point
c     $,            uwindm1             ! u component for wind at iim1 point
c     $,            vwindm1             ! v component for wind at iim1 point
c     $,            uwindm2             ! u component for wind at iim2 point
c     $,            vwindm2             ! v component for wind at iim2 point
c     $,            uwindm3             ! u component for wind at iim3 point
c     $,            vwindm3             ! v component for wind at iim3 point
c     $,            uwindp1             ! u component for wind at iip1 point
c     $,            vwindp1             ! v component for wind at iip1 point
c     $,            uwindp2             ! u component for wind at iip2 point
c     $,            vwindp2             ! v component for wind at iip2 point
c     $,            uwindp3             ! u component for wind at iip3 point
c     $,            vwindp3             ! v component for wind at iip3 point
c     $,            uwind_start         ! u component for wind at first point
c     $,            vwind_start         ! v component for wind at first point
c     $,            uwind_end           ! u component for wind at last point
c     $,            vwind_end           ! v component for wind at last point
c     $,            uwind_last          ! u component for wind at last bad point
c     $,            vwind_last          ! v component for wind at last bad point
      real         wspd_last           ! wind speed at last bad point
     $,            wdir_last           ! wind direction at last bad point
      real         distm1              ! distance between iim2 and iim1 points
     $,            distm2              ! distance between iim2 and iim3 points
     $,            dist0               ! distance between iim1 and ii points
     $,            distp1              ! distance between iip1 and ii points
     $,            distp2              ! distance between iip2 and iip1 points
     $,            distp3              ! distance between iip3 and iip2 points
     $,            dist_wo0            ! distance between iim1 and iip1 points
     $,            dist_wop1           ! distance between ii and iip2 points
     $,            dist_wop2           ! distance between iip1 and iip3 points
     $,            dist_bad0           ! distance between ii and last_bad points
     $,            dist_badp1          ! distance between ii and last_bad points
     $,            dist_track          ! distance between first and last points
     $,            dist_2ndflt         ! distance between first and last points of potential 2nd flight
     $,            udistm1             ! E-W distance between iim2 and iim1 points
     $,            vdistm1             ! N-S distance between iim2 and iim1 points
     $,            udistm2             ! E-W distance between iim3 and iim2 points
     $,            vdistm2             ! N-S distance between iim3 and iim2 points
     $,            udist0              ! E-W distance between ii and iim1 points
     $,            vdist0              ! N-S distance between ii and iim1 points
     $,            udistp1             ! E-W distance between ii and iip1 points
     $,            vdistp1             ! N-S distance between ii and iip1 points
     $,            udistp2             ! E-W distance between iip1 and iip2 points
     $,            vdistp2             ! N-S distance between iip1 and iip2 points
     $,            udistp3             ! E-W distance between iip2 and iip3 points
     $,            vdistp3             ! N-S distance between iip2 and iip3 points
     $,            udist_wo0           ! E-W distance between iim1 and iip1 points
     $,            vdist_wo0           ! N-S distance between iim1 and iip1 points
     $,            udist_wop1          ! E-W distance between ii and iip2 points
     $,            vdist_wop1          ! N-S distance between ii and iip2 points
     $,            udist_wop2          ! E-W distance between iip1 and iip3 points
     $,            vdist_wop2          ! N-S distance between iip1 and iip3 points
     $,            udist_bad0          ! E-W distance between ii and last_bad points
     $,            vdist_bad0          ! N-S distance between ii and last_bad points
     $,            udist_badp1         ! E-W distance between iip1 and last_bad points
     $,            vdist_badp1         ! N-S distance between iip1 and last_bad points
     $,            udist_track         ! E-W distance between first and last points
     $,            vdist_track         ! N-S distance between first and last points
      real         upspdm1             ! u component of platform speed (iim2 to iim1 points)
     $,            vpspdm1             ! v component of platform speed (iim2 to iim1 points)
     $,            upspdm2             ! u component of platform speed (iim3 to iim2 points)
     $,            vpspdm2             ! v component of platform speed (iim3 to iim2 points)
     $,            upspd0              ! u component of platform speed (iim1 to ii points)
     $,            vpspd0              ! v component of platform speed (iim1 to ii points)
     $,            upspdp1             ! u component of platform speed (ii to iip1 points)
     $,            vpspdp1             ! v component of platform speed (ii to iip1 points)
     $,            upspdp2             ! u component of platform speed (iip1 to iip2 points)
     $,            vpspdp2             ! v component of platform speed (iip1 to iip2 points)
     $,            upspdp3             ! u component of platform speed (iip2 to iip3 points)
     $,            vpspdp3             ! v component of platform speed (iip2 to iip3 points)
     $,            upspd_wo0           ! u component of platform speed (iim1 to iip1 points)
     $,            vpspd_wo0           ! v component of platform speed (iim1 to iip1 points)
     $,            upspd_wop1          ! u component of platform speed (ii to iip2 points)
     $,            vpspd_wop1          ! v component of platform speed (ii to iip2 points)
     $,            upspd_wop2          ! u component of platform speed (iip1 to iip3 points)
     $,            vpspd_wop2          ! v component of platform speed (iip1 to iip3 points)
     $,            upspd_bad0          ! u component of platform speed (ii to last_bad points)
     $,            vpspd_bad0          ! v component of platform speed (ii to last_bad points)
     $,            upspd_badp1         ! u component of platform speed (iip1 to last_bad points)
     $,            vpspd_badp1         ! v component of platform speed (iip1 to last_bad points)
     $,            upspd_track         ! u component of platform speed (first and last points)
     $,            vpspd_track         ! v component of platform speed (first and last points)
     $,            pdirm1              ! platform direction of aircraft (iim2 to iim1 points)
     $,            pdirm2              ! platform direction of aircraft (iim3 to iim2 points)
     $,            pdir0               ! platform direction of aircraft (iim1 to ii points)
     $,            pdirp1              ! platform direction of aircraft (iip1 to ii points)
     $,            pdirp2              ! platform direction of aircraft (iip1 to iip2 points)
     $,            pdirp3              ! platform direction of aircraft (iip2 to iip3 points)
     $,            pdir_wo0            ! platform direction of aircraft (iim1 to iip1 points)
     $,            pdir_wop1           ! platform direction of aircraft (ii to iip2 points)
     $,            pdir_wop2           ! platform direction of aircraft (iip1 to iip3 points)
     $,            pdir_bad0           ! platform direction of aircraft (ii to last_bad points)
     $,            pdir_badp1          ! platform direction of aircraft (iip1 to last_bad points)
     $,            pdir_track          ! platform direction of aircraft (first and last points)
     $,            pspdm1              ! platform speed of aircraft (iim2 to iim1 points)
     $,            pspdm2              ! platform speed of aircraft (iim3 to iim2 points)
     $,            pspd0               ! platform speed of aircraft (iip1 to ii points)
     $,            pspdp1              ! platform speed of aircraft (iip1 to ii points)
     $,            pspdp2              ! platform speed of aircraft (iip2 to iip1 points)
     $,            pspdp3              ! platform speed of aircraft (iip3 to iip2 points)
     $,            pspd_wo0            ! platform speed of aircraft (iip1 to iim1 points)
     $,            pspd_wop1           ! platform speed of aircraft (iip2 to ii points)
     $,            pspd_wop2           ! platform speed of aircraft (iip3 to iip1 points)
     $,            pspd_bad0           ! platform speed of aircraft (ii to last_bad points)
     $,            pspd_badp1          ! platform speed of aircraft (iip1 to last_bad points)
     $,            pspd_track          ! platform speed of aircraft (first and last points)
      real         spd_thresh          ! threshold speed of aircraft
     $,            spd_man_thresh      ! threshold speed of aircraft for manual aireps
c      real         uairspdm1           ! u component of airspeed (iim2 to iim1 points)
c     $,            vairspdm1           ! v component of airspeed (iim2 to iim1 points)
c     $,            uairspdm2           ! u component of airspeed (iim3 to iim2 points)
c     $,            vairspdm2           ! v component of airspeed (iim3 to iim2 points)
c     $,            uairspd0            ! u component of airspeed (iim1 to ii points)
c     $,            vairspd0            ! v component of airspeed (iim1 to ii points)
c     $,            uairspdp1           ! u component of airspeed (ii to iip1 points)
c     $,            vairspdp1           ! v component of airspeed (ii to iip1 points)
c     $,            uairspdp2           ! u component of airspeed (iip1 to iip2 points)
c     $,            vairspdp2           ! v component of airspeed (iip1 to iip2 points)
c     $,            uairspdp3           ! u component of airspeed (iip2 to iip3 points)
c     $,            vairspdp3           ! v component of airspeed (iip2 to iip3 points)
c     $,            uairspd_wo0         ! u component of airspeed (iim1 to iip1 points)
c     $,            vairspd_wo0         ! v component of airspeed (iim1 to iip1 points)
c     $,            uairspd_wop1        ! u component of airspeed (ii to iip2 points)
c     $,            vairspd_wop1        ! v component of airspeed (ii to iip2 points)
c     $,            uairspd_wop2        ! u component of airspeed (iip1 to iip3 points)
c     $,            vairspd_wop2        ! v component of airspeed (iip1 to iip3 points)
c     $,            uairspd_bad0        ! u component of airspeed (ii to last_bad points)
c     $,            vairspd_bad0        ! v component of airspeed (ii to last_bad points)
c     $,            uairspd_badp1       ! u component of airspeed (iip1 to last_bad points)
c     $,            vairspd_badp1       ! v component of airspeed (iip1 to last_bad points)
c     $,            uairspd_track       ! u component of airspeed (first and last points)
c     $,            vairspd_track       ! v component of airspeed (first and last points)
      real         airspdm1            ! airspeed between iim1 and iim2 points
c     $,            airdirm1            ! airspeed direction between iim1 and iim2 points
     $,            airspdm2            ! airspeed between iim2 and iim3 points
c     $,            airdirm2            ! airspeed direction between iim2 and iim3 points
     $,            airspd0             ! airspeed between ii and iim1 points
c     $,            airdir0             ! airspeed direction between ii and iim1 points
     $,            airspdp1            ! airspeed between ii and iip1 points
c     $,            airdirp1            ! airspeed direction between ii and iip1 points
     $,            airspdp2            ! airspeed between iip1 and iip2 points
c     $,            airdirp2            ! airspeed direction between iip1 and iip2 points
     $,            airspdp3            ! airspeed between iip2 and iip3 points
c     $,            airdirp3            ! airspeed direction between iip2 and iip3 points
     $,            airspd_wo0          ! airspeed between iim1 and iip1 points
c     $,            airdir_wo0          ! airspeed direction between iim1 and iip1 points
     $,            airspd_wop1         ! airspeed between ii and iip2 points
c     $,            airdir_wop1         ! airspeed direction between ii and iip2 points
     $,            airspd_wop2         ! airspeed between iip1 and iip3 points
c     $,            airdir_wop2         ! airspeed direction between iip1 and iip3 points
     $,            airspd_bad0         ! airspeed between ii and last_bad points
c     $,            airdir_bad0         ! airspeed direction between ii and last_bad points
     $,            airspd_badp1        ! airspeed between iip1 and last_bad points
c     $,            airdir_badp1        ! airspeed direction between iip1 and last_bad points
     $,            airspd_track        ! airspeed between first and last points
c     $,            airdir_track        ! airspeed direction between first and last points
      real         vspdm1              ! vertical speed of aircraft (iim1 to iim2 points)
     $,            vspdm2              ! vertical speed of aircraft (iim2 to iim3 points)
     $,            vspd0               ! vertical speed of aircraft (ii to iim1 points)
     $,            vspdp1              ! vertical speed of aircraft (iip1 to ii points)
     $,            vspdp2              ! vertical speed of aircraft (iip2 to iip1 points)
     $,            vspdp3              ! vertical speed of aircraft (iip3 to iip2 points)
     $,            vspd_wo0            ! vertical speed of aircraft (iip1 to iim1 points)
     $,            vspd_wop1           ! vertical speed of aircraft (iip2 to ii points)
     $,            vspd_wop2           ! vertical speed of aircraft (iip3 to iip1 points)
     $,            vspd_bad0           ! vertical speed of aircraft (ii to last_bad points)
     $,            vspd_badp1          ! vertical speed of aircraft (iip1 to last_bad points)
     $,            vspd_track          ! vertical speed of aircraft (first and last points)
      real         vspd_thresh         ! threshold vertical speed of aircraft
     $,            vspd_bounce         ! threshold vertical speed used in bounce test
c
      integer      indx_save(200)      ! pointer indices for rejected reports
     $,            ll                  ! index for indx_save
     $,            keep                ! variable used in saving indices
     $,            knt_bad             ! number of reports in potential second flight
     $,            last_bad            ! pointer index for last rejected report
     $,            last_bad_m1         ! pointer index for next-to-last rejected report
c
      character*8  cidmiss             ! missing value flag for flight number
c
c     Switches
c     --------
      logical      l_print             ! true for printing reports used in check
c
      logical      l_retest            ! retest track if true
c
      logical      l_init              ! initialize counters if true
     $,            l_ii_man_airep      ! true if ii report is manual airep
     $,            l_iim1_man_airep    ! true if iim1 report is manual airep
     $,            l_iim2_man_airep    ! true if iim2 report is manual airep
     $,            l_iim3_man_airep    ! true if iim3 report is manual airep
     $,            l_iip1_man_airep    ! true if iip1 report is manual airep
     $,            l_iip2_man_airep    ! true if iip2 report is manual airep
     $,            l_ii_pspd_ok        ! true if pspd is ok for point ii
     $,            l_stuck             ! true if stuck clock found
     $,            l_operational       ! true if operational mode used
c
c # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # #
c
c Degrees to radians
c ------------------
      d2r = atan(1.0) / 45.0
c
c Initialize aircraft data types
c ------------------------------
      i_acars      = insty_ob_fun('acars')
      i_acars_lvl  = insty_ob_fun('acars_lvl') 
      i_acars_asc  = insty_ob_fun('acars_asc') 
      i_acars_des  = insty_ob_fun('acars_des') 
      i_mdcrs      = insty_ob_fun('mdcrs')
      i_mdcrs_lvl  = insty_ob_fun('mdcrs_lvl') 
      i_mdcrs_asc  = insty_ob_fun('mdcrs_asc') 
      i_mdcrs_des  = insty_ob_fun('mdcrs_des')
      i_man_airep  = insty_ob_fun('man-airep') 
      i_man_Yairep = insty_ob_fun('man-Yairep') 
      i_airep      = insty_ob_fun('airep')
      i_airep_lvl  = insty_ob_fun('airep_lvl')
      i_airep_asc  = insty_ob_fun('airep_asc')
      i_airep_des  = insty_ob_fun('airep_des')
      i_amdar      = insty_ob_fun('amdar')
      i_amdar_lvl  = insty_ob_fun('amdar_lvl')
      i_amdar_asc  = insty_ob_fun('amdar_asc')
      i_amdar_des  = insty_ob_fun('amdar_des')
c
c Initialize counters
c -------------------
      if(l_init) then
        nord_dup = 0
        nord_stk = 0
        nord_time = 0
        nord_2nd = 0
        nord_near = 0
        nord_aspd = 0
        nord_lone = 0
        nord_dble = 0
        nord_turn = 0
        nord_alt = 0
        nord_wind = 0
        nrep_Ac = 0
        nrep_Md = 0
        nrep_Ma = 0
        nrep_Ar = 0
        nrep_Am = 0
        nord_Ac = 0
        nord_Md = 0
        nord_Ma = 0
        nord_Ar = 0
        nord_Am = 0
      endif
c
      nwind_reg = 0
c
c Begin loop over flights
c -----------------------
      do kk = 1,kflight
c
c Initialize variables
c --------------------
        istart = iobs_flt(kk)
        iistart = indx(istart)
        iend = iobs_flt(kk) + nobs_flt(kk) - 1
        iiend = indx(iend)
c
c Don't compare reports with missing flight number
c Perform check only for flights with three or more reports
c -----------------------------------------------------------------
        if(c_acftid(iistart)(1:8).ne.cidmiss(1:8).and.
     $     nobs_flt(kk).ge.3) then
c
c Determine flight phase of reports
c ---------------------------------
          do iob=istart,iend
            l_print = .false.
c
            ii = indx(iob)
c
c           Decide if report is a manual airep
c           ----------------------------------
            l_ii_man_airep = .false.
            if(itype(ii).eq.i_man_airep.or.
     $         itype(ii).eq.i_man_Yairep) l_ii_man_airep = .true. 
c
c           Compute ii-1 index
c           if(iob.gt.istart)   iim1 = indx(iob-1)
c           --------------------------------------
            iim1 = 0
            knt1 = iob - 1
 10         if(knt1.ge.istart) then
              iim1 = indx(knt1)
              if(c_qc(iim1)(1:1).eq.'d'.or.
     $           c_qc(iim1)(2:2).eq.'I'.or.
     $           c_qc(iim1)(2:2).eq.'K'.or.
     $           c_qc(iim1)(3:4).eq.'II'.or.
     $           c_qc(iim1)(5:5).eq.'I'.or.
     $           c_qc(iim1)(5:5).eq.'i') then
                knt1 = knt1 - 1
                goto 10
              endif
            else
              iim1 = 0
            endif
c
c           Compute ii-2 index
c           if(iob.gt.istart+1) iim2 = indx(iob-2)
c           --------------------------------------
            iim2 = 0
            knt2 = knt1 - 1
 20         if(knt2.ge.istart) then
              iim2 = indx(knt2)
              if(c_qc(iim2)(1:1).eq.'d'.or.
     $           c_qc(iim2)(2:2).eq.'I'.or.
     $           c_qc(iim2)(2:2).eq.'K'.or.
     $           c_qc(iim2)(3:4).eq.'II'.or.
     $           c_qc(iim2)(5:5).eq.'I'.or.
     $           c_qc(iim2)(5:5).eq.'i') then
                knt2 = knt2 - 1
                goto 20
              endif
            else
              iim2 = 0
            endif
c
c           Compute ii+1 index
c           if(iob.lt.iend)   iip1 = indx(iob+1)
c           ------------------------------------
            iip1 = 0
            knt3 = iob + 1
 30         if(knt3.le.iend) then
              iip1 = indx(knt3)
              if(c_qc(iip1)(1:1).eq.'d'.or.
     $           c_qc(iip1)(2:2).eq.'I'.or.
     $           c_qc(iip1)(2:2).eq.'K'.or.
     $           c_qc(iip1)(3:4).eq.'II'.or.
     $           c_qc(iip1)(5:5).eq.'I'.or.
     $           c_qc(iip1)(5:5).eq.'i') then
                knt3 = knt3 + 1
                goto 30
              endif
            else
              iip1 = 0
            endif
c
c           Compute ii+2 index
c           if(iob.lt.iend-1) iip2 = indx(iob+2)
c           ------------------------------------
            iip2 = 0
            knt4 = knt3 + 1
 40         if(knt4.le.iend) then
              iip2 = indx(knt4)
              if(c_qc(iip2)(1:1).eq.'d'.or.
     $           c_qc(iip2)(2:2).eq.'I'.or.
     $           c_qc(iip2)(2:2).eq.'K'.or.
     $           c_qc(iip2)(3:4).eq.'II'.or.
     $           c_qc(iip2)(5:5).eq.'I'.or.
     $           c_qc(iip2)(5:5).eq.'i') then
                knt4 = knt4 + 1
                goto 40
              endif
            else
              iip2 = 0
            endif
c
c           Compute time and height differences
c           -----------------------------------
            alat0 = alat(ii)
            alon0 = alon(ii)
            ht_ft0 = ht_ft(ii)
c
            if(iim1.ne.0) then
              idt_dif0 = abs(idt(ii)   - idt(iim1))
              ht_dif0  = abs(ht_ft(ii) - ht_ft(iim1))
              ht_ftm1 = ht_ft(iim1)
            else
              idt_dif0 = imiss
              ht_dif0 = amiss
              ht_ftm1 = amiss
            endif
c
            if(iim2.ne.0) then
              ht_ftm2 = ht_ft(iim2)
            else
              ht_ftm2 = amiss
            endif
c
            if(iim1.ne.0.and.iim2.ne.0) then
              idt_difm1 = abs(idt(iim1) - idt(iim2))
              ht_difm1 = abs(ht_ft(iim1) - ht_ft(iim2))
            else
              idt_difm1 = imiss
              ht_difm1 = amiss
            endif
c
            if(iip1.ne.0) then
              idt_difp1 = abs(idt(iip1) - idt(ii))
              ht_difp1 = abs(ht_ft(iip1) - ht_ft(ii))
              ht_ftp1 = ht_ft(iip1)
            else
              idt_difp1 = imiss
              ht_difp1 = amiss
              ht_ftp1 = amiss
            endif
c
            if(iip2.ne.0) then
              ht_ftp2 = ht_ft(iip2)
            else
              ht_ftp2 = amiss
            endif
c
            if(iip2.ne.0.and.iip1.ne.0) then
              idt_difp2 = abs(idt(iip2) - idt(iip1))
              ht_difp2 = abs(ht_ft(iip2) - ht_ft(iip1))
            else
              idt_difp2 = imiss
              ht_difp2 = amiss
            endif
c
c     Look for high resolution level legs
c     -----------------------------------
c
c           Use iim1, ii, iip1 points
c           -----------------------------------
            if(iim1.ne.0.and.iip1.ne.0.and.
     $         idt_dif0 .ne.imiss.and.idt_dif0 .le.idt_updn.and.
     $         idt_difp1.ne.imiss.and.idt_difp1.le.idt_updn.and.
     $         ht_dif0 .lt.htdif_same+0.5.and.
     $         ht_difp1.lt.htdif_same+0.5) then
c
              c_qc(ii)(11:11) = 'L'
c
c           Use iim2, iim1, ii points
c           --------------------------
            elseif(iim2.ne.0.and.iim1.ne.0.and.
     $             idt_difm1.ne.imiss.and.idt_difm1.le.idt_updn.and.
     $             idt_dif0 .ne.imiss.and.idt_dif0 .le.idt_updn.and.
     $             ht_difm1.lt.htdif_same+0.5.and.
     $             ht_dif0 .lt.htdif_same+0.5) then
c
              c_qc(ii)(11:11) = 'L'
c
              if(iip1.ne.0.and.idt_difp1.lt.idt_updn.and.
     $           ht_difp1.gt.htdif_same+0.5.and.
     $           ht_difp1.lt.5000.) then
                if(ht_ftp1.gt.ht_ft0) 
     $             c_qc(ii)(11:11) = 'A'      ! Ascending
                if(ht_ftp1.lt.ht_ft0) 
     $             c_qc(ii)(11:11) = 'D'      ! Descending
              endif
c
c           Use ii, iip1, iip2 points
c           --------------------------
            elseif(iip1.ne.0.and.iip2.ne.0.and.
     $             idt_difp1.ne.imiss.and.idt_difp1.le.idt_updn.and.
     $             idt_difp2.ne.imiss.and.idt_difp2.le.idt_updn.and.
     $             ht_difp1.lt.htdif_same+0.5.and.
     $             ht_difp2.lt.htdif_same+0.5) then
c
              c_qc(ii)(11:11) = 'L'
c
              if(iim1.ne.0.and.idt_dif0.lt.idt_updn.and.
     $           ht_dif0.gt.htdif_same+0.5.and.
     $           ht_dif0.lt.5000.) then
                if(ht_ftm1.gt.ht_ft0) 
     $             c_qc(ii)(11:11) = 'D'      ! Descending
                if(ht_ftm1.lt.ht_ft0) 
     $             c_qc(ii)(11:11) = 'A'      ! Ascending
              endif
c
c     Look for high resolution ascents and descents
c     ---------------------------------------------
c
c           Use iim1, ii, iip1 points
c           -----------------------------------
            elseif(iim1.ne.0.and.iip1.ne.0.and.
     $             idt_dif0.ne.imiss.and.idt_dif0.le.idt_updn.and.
     $             idt_difp1.ne.imiss.and.idt_difp1.le.idt_updn.and.
     $             ht_ftm1.lt.ht_ft0 .and.
     $             ht_ft0 .lt.ht_ftp1) then
c
              c_qc(ii)(11:11) = 'A'
c
            elseif(iim1.ne.0.and.iip1.ne.0.and.
     $             idt_dif0.ne.imiss.and.idt_dif0.le.idt_updn.and.
     $             idt_difp1.ne.imiss.and.idt_difp1.le.idt_updn.and.
     $             ht_ftm1.gt.ht_ft0 .and.
     $             ht_ft0 .gt.ht_ftp1) then
c
              c_qc(ii)(11:11) = 'D'
c
c           Use iim2, iim1, ii points
c           -----------------------------------
            elseif(iim2.ne.0.and.iim1.ne.0.and.
     $             idt_difm1.ne.imiss.and.idt_difm1.le.idt_updn.and.
     $             idt_dif0.ne.imiss.and.idt_dif0.le.idt_updn.and.
     $             ht_ftm2.lt.ht_ftm1.and.
     $             ht_ftm1.lt.ht_ft0) then
c
                c_qc(ii)(11:11) = 'A'
c
            elseif(iim2.ne.0.and.iim1.ne.0.and.
     $             idt_difm1.ne.imiss.and.idt_difm1.le.idt_updn.and.
     $             idt_dif0.ne.imiss.and.idt_dif0.le.idt_updn.and.
     $             ht_ftm2.gt.ht_ftm1.and.
     $             ht_ftm1.gt.ht_ft0 ) then
c
                c_qc(ii)(11:11) = 'D'
c
c           Use ii, iip1, iip2 points
c           -----------------------------------
            elseif(iip1.ne.0.and.iip2.ne.0.and.
     $             idt_difp1.ne.imiss.and.idt_difp1.le.idt_updn.and.
     $             idt_difp2.ne.imiss.and.idt_difp2.le.idt_updn.and.
     $             ht_ft0 .lt.ht_ftp1.and.
     $             ht_ftp1.lt.ht_ftp2) then
c
                c_qc(ii)(11:11) = 'A'
c
            elseif(iip1.ne.0.and.iip2.ne.0.and.
     $             idt_difp1.ne.imiss.and.idt_difp1.le.idt_updn.and.
     $             idt_difp2.ne.imiss.and.idt_difp2.le.idt_updn.and.
     $             ht_ft0.gt.ht_ftp1.and.
     $             ht_ftp1.gt.ht_ftp2) then
c
                c_qc(ii)(11:11) = 'D'
c
c     Look for other level legs
c     -------------------------
c
c           Use iim1, ii, iip1 points
c           -------------------------
            elseif(iim1.ne.0.and.iip1.ne.0.and.
     $             idt_dif0.ne.imiss.and.
     $             (idt_dif0 .le.idt_near.or.
     $              (l_ii_man_airep.and.idt_dif0 .le.idt_near*3)).and.
     $             idt_difp1.ne.imiss.and.
     $             (idt_difp1.le.idt_near.or.
     $              (l_ii_man_airep.and.idt_difp1.le.idt_near*3)).and.
     $             ht_dif0.lt.htdif_same*1.5+0.5.and.
     $             ht_difp1.lt.htdif_same*1.5+0.5) then
c
              c_qc(ii)(11:11) = 'L'
c
c           Use iim2, iim1, ii points
c           -------------------------
            elseif(iim2.ne.0.and.iim1.ne.0.and.
     $             idt_difm1.ne.imiss.and.
     $             (idt_difm1.le.idt_near.or.
     $              (l_ii_man_airep.and.idt_difm1.le.idt_near*3)).and.
     $             idt_dif0 .ne.imiss.and.
     $             (idt_dif0 .le.idt_near.or.
     $              (l_ii_man_airep.and.idt_dif0 .le.idt_near*3)).and.
     $             ht_difm1.lt.htdif_same*1.5+0.5.and.
     $             ht_dif0 .lt.htdif_same*1.5+0.5) then
c
              c_qc(ii)(11:11) = 'L'
c
              if(iip1.ne.0.and.idt_difp1.lt.idt_updn.and.
     $           ht_difp1.gt.htdif_same+0.5.and.
     $           ht_difp1.lt.5000.) then
                if(ht_ftp1.gt.ht_ft0) 
     $             c_qc(ii)(11:11) = 'A'      ! Ascending
                if(ht_ftp1.lt.ht_ft0) 
     $             c_qc(ii)(11:11) = 'D'      ! Descending
              endif
c
c           Use ii, iip1, iip2 points
c           -------------------------
            elseif(iip1.ne.0.and.iip2.ne.0.and.
     $             idt_difp1.ne.imiss.and.
     $             (idt_difp1.le.idt_near.or.
     $              (l_ii_man_airep.and.idt_difp1.le.idt_near*3)).and.
     $             idt_difp2.ne.imiss.and.
     $             (idt_difp2.le.idt_near.or.
     $              (l_ii_man_airep.and.idt_difp2.le.idt_near*3)).and.
     $             ht_difp1.lt.htdif_same*1.5+0.5.and.
     $             ht_difp2.lt.htdif_same*1.5+0.5) then
c
              c_qc(ii)(11:11) = 'L'
c
              if(iim1.ne.0.and.idt_dif0.lt.idt_updn.and.
     $           ht_dif0.gt.htdif_same+0.5.and.
     $           ht_dif0.lt.5000.) then
                if(ht_ftm1.gt.ht_ft0) 
     $             c_qc(ii)(11:11) = 'D'      ! Descending
                if(ht_ftm1.lt.ht_ft0) 
     $             c_qc(ii)(11:11) = 'A'      ! Ascending
              endif
c
c     Look for other ascents and descents
c     -----------------------------------
c
c           Use iim1, ii, iip1 points
c           --------------------------------
            elseif(iim1.ne.0.and.iip1.ne.0.and.
     $             idt_dif0.ne.imiss.and.
     $             (idt_dif0 .le.idt_near.or.
     $              (l_ii_man_airep.and.idt_dif0 .le.idt_near*2)).and.
     $             idt_difp1.ne.imiss.and.
     $             (idt_difp1.le.idt_near.or.
     $              (l_ii_man_airep.and.idt_difp1.le.idt_near*2)).and.
     $             ht_ftm1.lt.ht_ft0 .and.
     $             ht_ft0 .lt.ht_ftp1) then
c
              c_qc(ii)(11:11) = 'a'
c
            elseif(iim1.ne.0.and.iip1.ne.0.and.
     $             idt_dif0.ne.imiss.and.
     $             (idt_dif0 .le.idt_near.or.
     $              (l_ii_man_airep.and.idt_dif0 .le.idt_near*2)).and.
     $             idt_difp1.ne.imiss.and.
     $             (idt_difp1.le.idt_near.or.
     $              (l_ii_man_airep.and.idt_difp1.le.idt_near*2)).and.
     $             ht_ftm1.gt.ht_ft0 .and.
     $             ht_ft0 .gt.ht_ftp1) then
c
              c_qc(ii)(11:11) = 'd'
c
c           Use iim2, iim1, ii points
c           -------------------------
            elseif(iim2.ne.0.and.iim1.ne.0.and.
     $             idt_difm1.ne.imiss.and.
     $             (idt_difm1.le.idt_near.or.
     $              (l_ii_man_airep.and.idt_difm1.le.idt_near*2)).and.
     $             idt_dif0 .ne.imiss.and.
     $             (idt_dif0 .le.idt_near.or.
     $              (l_ii_man_airep.and.idt_dif0 .le.idt_near*2)).and.
     $             ht_ftm2.lt.ht_ftm1.and.
     $             ht_ftm1.lt.ht_ft0 ) then
c
              c_qc(ii)(11:11) = 'a'
c
            elseif(iim2.ne.0.and.iim1.ne.0.and.
     $             idt_difm1.ne.imiss.and.
     $             (idt_difm1.le.idt_near.or.
     $              (l_ii_man_airep.and.idt_difm1.le.idt_near*2)).and.
     $             idt_dif0 .ne.imiss.and.
     $             (idt_dif0 .le.idt_near.or.
     $              (l_ii_man_airep.and.idt_dif0 .le.idt_near*2)).and.
     $             ht_ftm2.gt.ht_ftm1.and.
     $             ht_ftm1.gt.ht_ft0 ) then
c
              c_qc(ii)(11:11) = 'd'
c
c           Use ii, iip1, iip2 points
c           --------------------------------
            elseif(iip1.ne.0.and.iip2.ne.0.and.
     $             idt_difp1.ne.imiss.and.
     $             (idt_difp1.le.idt_near.or.
     $              (l_ii_man_airep.and.idt_difp1.le.idt_near*2)).and.
     $             idt_difp2.ne.imiss.and.
     $             (idt_difp2.le.idt_near.or.
     $              (l_ii_man_airep.and.idt_difp2.le.idt_near*2)).and.
     $             ht_ft0 .lt.ht_ftp1.and.
     $             ht_ftp1.lt.ht_ftp2) then
c
              c_qc(ii)(11:11) = 'a'
c
            elseif(iip1.ne.0.and.iip2.ne.0.and.
     $             idt_difp1.ne.imiss.and.
     $             (idt_difp1.le.idt_near.or.
     $              (l_ii_man_airep.and.idt_difp1.le.idt_near*2)).and.
     $             idt_difp2.ne.imiss.and.
     $             (idt_difp2.le.idt_near.or.
     $              (l_ii_man_airep.and.idt_difp2.le.idt_near*2)).and.
     $             ht_ft0 .gt.ht_ftp1.and.
     $             ht_ftp1.gt.ht_ftp2) then
c
              c_qc(ii)(11:11) = 'd'
c
c     Look for 2-point level legs
c     ---------------------------
c
c           Use iim1, ii, iip1 points
c           -------------------------
            elseif(iim1.ne.0.and.iip1.ne.0.and.
     $             idt_dif0.ne.imiss.and.
     $             (idt_dif0 .le.idt_near.or.
     $              (l_ii_man_airep.and.idt_dif0 .le.idt_near*2)).and.
     $             idt_difp1.ne.imiss.and.
     $             (idt_difp1.le.idt_near.or.
     $              (l_ii_man_airep.and.idt_difp1.le.idt_near*2)).and.
     $             ht_dif0.lt.htdif_same*1.5+0.5) then
c
              c_qc(ii)(11:11) = 'L'
c
            elseif(iim1.ne.0.and.iip1.ne.0.and.
     $             idt_dif0.ne.imiss.and.
     $             (idt_dif0 .le.idt_near.or.
     $              (l_ii_man_airep.and.idt_dif0 .le.idt_near*2)).and.
     $             idt_difp1.ne.imiss.and.
     $             (idt_difp1.le.idt_near.or.
     $              (l_ii_man_airep.and.idt_difp1.le.idt_near*2)).and.
     $             ht_difp1.lt.htdif_same*1.5+0.5) then
c
              c_qc(ii)(11:11) = 'L'
c
c           Use iim2, iim1, ii points
c           -------------------------
            elseif(iim2.ne.0.and.iim1.ne.0.and.
     $             idt_difm1.ne.imiss.and.
     $             (idt_difm1.le.idt_near.or.
     $              (l_ii_man_airep.and.idt_difm1.le.idt_near*2)).and.
     $             idt_dif0 .ne.imiss.and.
     $             (idt_dif0 .le.idt_near.or.
     $              (l_ii_man_airep.and.idt_dif0 .le.idt_near*2)).and.
     $             ht_dif0 .lt.htdif_same*1.5+0.5) then
c
              c_qc(ii)(11:11) = 'L'
c
c           Use ii, iip1, iip2 points
c           -------------------------
            elseif(iip1.ne.0.and.iip2.ne.0.and.
     $             idt_difp1.ne.imiss.and.
     $             (idt_difp1.le.idt_near.or.
     $              (l_ii_man_airep.and.idt_difp1.le.idt_near*2)).and.
     $             idt_difp2.ne.imiss.and.
     $             (idt_difp2.le.idt_near.or.
     $              (l_ii_man_airep.and.idt_difp2.le.idt_near*2)).and.
     $             ht_difp1.lt.htdif_same*1.5+0.5) then
c
              c_qc(ii)(11:11) = 'L'
c
c     Look for isolated ascending and descending points
c     -------------------------------------------------
c
c           Use iim2, iim1, ii points
c           -------------------------
            elseif(iim2.ne.0.and.iim1.ne.0.and.
     $             idt_difm1.ne.imiss.and.
     $             (idt_difm1.le.idt_near.or.
     $              (l_ii_man_airep.and.idt_difm1.le.idt_near*2)).and.
     $             idt_dif0 .ne.imiss.and.
     $             (idt_dif0 .le.idt_near.or.
     $              (l_ii_man_airep.and.idt_dif0 .le.idt_near*2)).and.
     $             ht_difm1.lt.htdif_same*1.5+0.5) then
c
              if(ht_ft0.lt.ht_ftm1) then
                c_qc(ii)(11:11) = 'd'
              elseif(ht_ft0.gt.ht_ftm1) then
                c_qc(ii)(11:11) = 'a'
              else
                write(io8,*)
                write(io8,*) 'unidentified isolated point found!'
                write(io8,*) 'hts:',ht_ftm2,ht_ftm1,ht_ft0
                c_qc(ii)(11:11) = 'U'
              endif
c
c           Use ii, iip1, iip2 points
c           -------------------------
            elseif(iip1.ne.0.and.iip2.ne.0.and.
     $             idt_difp1.ne.imiss.and.
     $             (idt_difp1.le.idt_near.or.
     $              (l_ii_man_airep.and.idt_difp1.le.idt_near*2)).and.
     $             idt_difp2.ne.imiss.and.
     $             (idt_difp2.le.idt_near.or.
     $              (l_ii_man_airep.and.idt_difp2.le.idt_near*2)).and.
     $             ht_difp2.lt.htdif_same*1.5+0.5) then
c
              if(ht_ft0.gt.ht_ftp1) then
                c_qc(ii)(11:11) = 'd'
              elseif(ht_ft0.lt.ht_ftp1) then
                c_qc(ii)(11:11) = 'a'
              else
                write(io8,*)
                write(io8,*) 'unidentified isolated point found!'
                write(io8,*) 'hts:',ht_ft0,ht_ftp1,ht_ftp2
                c_qc(ii)(11:11) = 'U'
              endif
c
c     Check if time difference is too great to categorize manAIREPs
c     -------------------------------------------------------------
            elseif(l_ii_man_airep.and.
     $             ((iim1.ne.0.and.iip1.ne.0.and.
     $              ((idt_difm1.gt.idt_near*2.and.
     $                idt_difp1.gt.idt_near*2).or.
     $               (idt_dif0 .gt.idt_near*2.and.
     $                idt_difp1.gt.idt_near*2).or.
     $               (idt_dif0 .gt.idt_near*2.and.
     $                idt_difp2.gt.idt_near*2))).or.
     $             (iim1.eq.0.and.idt_difp1.gt.idt_near*2).or.
     $             (iim1.eq.0.and.idt_difp2.gt.idt_near*2).or.
     $             (iim2.eq.0.and.iim1.ne.0.and.
     $              idt_difp1.gt.idt_near*2).or.
     $             (iip1.eq.0.and.idt_dif0 .gt.idt_near*2).or.
     $             (iip1.eq.0.and.idt_difm1.gt.idt_near*2).or.
     $             (iip2.eq.0.and.iip1.ne.0.and.
     $              idt_dif0 .gt.idt_near*2)))then
c
              c_qc(ii)(11:11) = 'N'
c
c     Check if time difference is too great to categorize remaining types
c     -------------------------------------------------------------------
            elseif((.not.l_ii_man_airep).and.
     $             ((iim1.ne.0.and.iip1.ne.0.and.
     $              ((idt_difm1.gt.idt_near*2/3.and.
     $                idt_difp1.gt.idt_near*2/3).or.
     $               (idt_dif0 .gt.idt_near*2/3.and.
     $                idt_difp1.gt.idt_near*2/3).or.
     $               (idt_dif0 .gt.idt_near*2/3.and.
     $                idt_difp2.gt.idt_near*2/3))).or.
     $             (iim1.eq.0.and.idt_difp1.gt.idt_near*2/3).or.
     $             (iim1.eq.0.and.idt_difp2.gt.idt_near*2/3).or.
     $             (iim2.eq.0.and.iim1.ne.0.and.
     $              idt_difp1.gt.idt_near*2/3).or.
     $             (iip1.eq.0.and.idt_dif0 .gt.idt_near*2/3).or.
     $             (iip1.eq.0.and.idt_difm1.gt.idt_near*2/3).or.
     $             (iip2.eq.0.and.iip1.ne.0.and.
     $              idt_dif0 .gt.idt_near*2/3)))then
c
              c_qc(ii)(11:11) = 'N'
c
c     Label everything else as unknown
c     --------------------------------
            else
             c_qc(ii)(11:11) = 'U'
            endif
c
          enddo
c
c Check ordering
c Compute platform speed and airspeed between neighboring points
c Check for realistic platform speeds using Moninger's test
c Threshold lowered from 600 m/s to 525 m/s; manAIREPs use 325 m/s
c Compute vertical velocity between neighboring points and do bounce test
c -----------------------------------------------------------------------
 5500     continue
c
c Initialize variables for track check
c ------------------------------------
          l_ii_pspd_ok = .false.
          l_stuck = .false.
c
          spd_thresh = 525.
          spd_man_thresh = 350.
          vspd_thresh = 12000.0/60.0
          vspd_bounce = 6000.0/60.0
c
          iob = istart
c
          indx_save = imiss
          ll = 0
          knt_bad = 0
          last_bad = 0
          last_bad_m1 = 0
          knt_iob = 1
          iob_sav = 0
c
c Loop over reports for current flight
c ------------------------------------
          do while(iob.le.iend)
            l_print = .false.
            l_retest = .false.
c
            knt0 = iob
            ii = indx(iob)
c
            if(iob.eq.iob_sav) then
              knt_iob = knt_iob + 1
            else
              iob_sav = iob
              knt_iob = 1
            endif
c
            if(knt_iob.gt.75) then
              write(io8,*)
              write(io8,*) 'Too many repetitions with the same iob',iob
              write(io8,*) '  Sorted index ii = ',ii
              write(io8,*) '  Number of repetitions = ',knt_iob
              iob = iob + 1
              iob_sav = iob
              knt_iob = 1
            endif
c
c           Go to next report if ii index is invalid
c           ----------------------------------------
            if(c_qc(ii)(1:1).eq.'d'.or.
     $         c_qc(ii)(2:2).eq.'I'.or.
     $         c_qc(ii)(2:2).eq.'K'.or.
     $         c_qc(ii)(3:4).eq.'II'.or.
     $         c_qc(ii)(5:5).eq.'I'.or.
     $         c_qc(ii)(5:5).eq.'i') then
c
              iob = iob + 1
              l_ii_pspd_ok = .false.
              l_print = .false.
              if(l_print) then
                write(io8,*) 'Index invalid: ii = ',ii
              endif
c
c           Check out ordering etc for valid indices
c           ----------------------------------------
            else
c
c             Compute ii-1 index
c             if(iob.gt.istart)   iim1 = indx(iob-1)
c             --------------------------------------
              iim1 = 0
              knt1 = iob - 1
 11           if(knt1.ge.istart) then
                iim1 = indx(knt1)
                if(c_qc(iim1)(1:1).eq.'d'.or.
     $             c_qc(iim1)(2:2).eq.'I'.or.
     $             c_qc(iim1)(2:2).eq.'K'.or.
     $             c_qc(iim1)(3:4).eq.'II'.or.
     $             c_qc(iim1)(5:5).eq.'I'.or.
     $             c_qc(iim1)(5:5).eq.'i') then
                  knt1 = knt1 - 1
                  goto 11
                endif
              else
                iim1 = 0
              endif
c
c             Compute ii-2 index
c             if(iob.gt.istart+1) iim2 = indx(iob-2)
c             --------------------------------------
              iim2 = 0
              knt2 = knt1 - 1
 21           if(knt2.ge.istart) then
                iim2 = indx(knt2)
                if(c_qc(iim2)(1:1).eq.'d'.or.
     $             c_qc(iim2)(2:2).eq.'I'.or.
     $             c_qc(iim2)(2:2).eq.'K'.or.
     $             c_qc(iim2)(3:4).eq.'II'.or.
     $             c_qc(iim2)(5:5).eq.'I'.or.
     $             c_qc(iim2)(5:5).eq.'i') then
                  knt2 = knt2 - 1
                  goto 21
                endif
              else
                iim2 = 0
              endif
c
c             Compute ii+1 index
c             if(iob.lt.iend)   iip1 = indx(iob+1)
c             ------------------------------------
              iip1 = 0
              iobp1 = 0
              knt3 = iob + 1
 41           if(knt3.le.iend) then
                iip1 = indx(knt3)
                iobp1 = knt3
                if(c_qc(iip1)(1:1).eq.'d'.or.
     $             c_qc(iip1)(2:2).eq.'I'.or.
     $             c_qc(iip1)(2:2).eq.'K'.or.
     $             c_qc(iip1)(3:4).eq.'II'.or.
     $             c_qc(iip1)(5:5).eq.'I'.or.
     $             c_qc(iip1)(5:5).eq.'i') then
                  knt3 = knt3 + 1
                  goto 41
                endif
              else
                iip1 = 0
                iobp1 = 0
              endif
c
c             Compute ii+2 index
c             if(iob.lt.iend-1) iip2 = indx(iob+2)
c             ------------------------------------
              iip2 = 0
              iobp2 = 0
              knt4 = knt3 + 1
 51           if(knt4.le.iend) then
                iip2 = indx(knt4)
                iobp2 = knt4
                if(c_qc(iip2)(1:1).eq.'d'.or.
     $             c_qc(iip2)(2:2).eq.'I'.or.
     $             c_qc(iip2)(2:2).eq.'K'.or.
     $             c_qc(iip2)(3:4).eq.'II'.or.
     $             c_qc(iip2)(5:5).eq.'I'.or.
     $             c_qc(iip2)(5:5).eq.'i') then
                  knt4 = knt4 + 1
                  goto 51
                endif
              else
                iip2 = 0
                iobp2 = 0
              endif
c
c             Determine if reports are manual AIREPs
c             --------------------------------------
              l_ii_man_airep = .false.
              if(itype(ii).eq.i_man_airep.or.
     $           itype(ii).eq.i_man_Yairep) l_ii_man_airep = .true.
c 
              l_iim1_man_airep = .false.
              if(iim1.ne.0) then
               if(itype(iim1).eq.i_man_airep.or.
     $            itype(iim1).eq.i_man_Yairep) l_iim1_man_airep = .true.
              endif
c 
              l_iip1_man_airep = .false.
              if(iip1.ne.0) then
                if(itype(iip1).eq.i_man_airep.or.
     $            itype(iip1).eq.i_man_Yairep) l_iip1_man_airep = .true. 
              endif
c 
              l_iip2_man_airep = .false.
              if(iip2.ne.0) then
                if(itype(iip2).eq.i_man_airep.or.
     $            itype(iip2).eq.i_man_Yairep) l_iip2_man_airep = .true. 
              endif
c
c             Set up temporary variables for ii point
c             ---------------------------------------
              alat0 = alat(ii)
              alon0 = alon(ii)
              ht_ft0 = ht_ft(ii)
              idt0 = idt(ii)
c
c              if(c_qc(ii)(7:8).ne.'..') then
c                uwind0 = amiss
c                vwind0 = amiss
c              else
c                uwind0 = -sin(ob_dir(ii)*d2r)*ob_spd(ii)
c                vwind0 = -cos(ob_dir(ii)*d2r)*ob_spd(ii)
c              endif
c
c             Set up temporary variables for iim1 point
c             -----------------------------------------
              if(iim1.ne.0) then
                alatm1 = alat(iim1)
                alonm1 = alon(iim1)
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
                if(alon0.lt.90.0.and.alonm1.gt.270.0) 
     $            alonm1 = 360.0 - alonm1
                if(alon0.gt.270.0.and.alonm1.lt.90.0) 
     $            alonm1 = 360.0 + alonm1
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
                ht_ftm1 = ht_ft(iim1)
                idtm1 = idt(iim1)
c
c                if(c_qc(iim1)(7:8).ne.'..') then
c                  uwindm1 = amiss
c                  vwindm1 = amiss
c                else
c                  uwindm1 = -sin(ob_dir(iim1)*d2r)*ob_spd(iim1)
c                  vwindm1 = -cos(ob_dir(iim1)*d2r)*ob_spd(iim1)
c                endif
c
c               Compute groundspeed vector components between ii and iim1 points
c               ----------------------------------------------------------------
                if(idt0.ne.imiss.and.idtm1.ne.imiss) then
                  idt_dif0 = abs(idt0 - idtm1)
                else
                  idt_dif0 = imiss
                endif
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
                if(alat0 .ne.amiss.and.alon0 .ne.amiss.and.
     $             alatm1.ne.amiss.and.alonm1.ne.amiss.and.
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
     $             idt_dif0.ne.imiss) then
                  udist0 = gcirc_qc(alat(iim1),alon(iim1),
     $                              alat(iim1),alon(ii  ))
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
                  if(sin((alon(ii)-alon(iim1))*d2r).lt.0.0)
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
     $              udist0 = -udist0
                  vdist0 = gcirc_qc(alat(iim1),alon(iim1),
     $                              alat(ii  ),alon(iim1))
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
                  if(sin((alat(ii)-alat(iim1))*d2r).lt.0.0)
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
     $              vdist0 = -vdist0
                  dist0  = gcirc_qc(alat(iim1),alon(iim1),
     $                              alat(ii  ),alon(ii  ))
                  if(idt_dif0.gt.0) then
                    upspd0 = udist0 / float(idt_dif0)
                    vpspd0 = vdist0 / float(idt_dif0)
                    pspd0  = dist0  / float(idt_dif0)
                  else
                    upspd0 = udist0 / float(idt_dif0+60)
                    vpspd0 = vdist0 / float(idt_dif0+60)
                    pspd0  = dist0  / float(idt_dif0+60)
                  endif
                  if(upspd0.eq.0.0.and.vpspd0.eq.0.0) then
                    pdir0 = 0.0
                  else
                    pdir0 = atan2(upspd0,vpspd0) / d2r + 180.0
                  endif
                  dist0 = dist0 / 1000.0
                else
                  udist0 = amiss
                  vdist0 = amiss
                  dist0  = amiss
                  upspd0 = amiss
                  vpspd0 = amiss
                  pspd0  = amiss
                  pdir0  = amiss
                endif
c
c               Compute airspeed between ii and iim1 points
c               -------------------------------------------
c                if(uwind0.ne.amiss.and.upspd0.ne.amiss) then
c                  uairspd0 = upspd0 - uwind0
c                  vairspd0 = vpspd0 - vwind0
c                  airspd0  = sqrt(uairspd0**2+vairspd0**2)
c
                if(ob_dir(ii).ne.amiss.and.ob_spd(ii).ne.amiss) then
                  airspd0 = sqrt(pspd0**2 + ob_spd(ii)**2 
     $               - 2.0*pspd0*ob_spd(ii)*cos((pdir0-ob_dir(ii))*d2r))
c
c                 Make allowances for aircraft that round time to the 
c                 nearest minute--divide by 120 sec rather than 60 sec
c                 (modified to allow for mixture of reports with time
c                  rounded to the nearest minute and interpolated time
c                  to the nearest second in ascents--P.M.Pauley 6/11/01)
c                 ----------------------------------------------------
                  if(airspd0.gt.spd_thresh.and.
     $               (abs(idt_dif0).eq.60.or.
     $                (abs(idt_dif0).lt.60.and.
     $                 ((idt(ii  )/60)*60.eq.idt(ii  ).or.
     $                  (idt(iim1)/60)*60.eq.idt(iim1))))) then
c
                    airspd0 = airspd0 / 2.0
c
                  endif
c
c                  if(uairspd0.eq.0.0.and.vairspd0.eq.0.0) then
c                    airdir0 = 0.0
c                  else
c                    airdir0 = atan2(uairspd0,vairspd0) / d2r + 180.0
c                  endif
c
                else
c                  uairspd0 = amiss
c                  vairspd0 = amiss
                  airspd0  = pspd0
c                  airdir0  = pdir0
                endif
c
c               Compute vertical speed between ii and iim1 points
c               -------------------------------------------------
                if(ht_ft0.ne.amiss.and.ht_ftm1.ne.amiss) then
                  ht_dif0  = ht_ft(ii) - ht_ft(iim1)
                else
                  ht_dif0 = amiss
                endif
                if(ht_dif0.eq.amiss.or.idt_dif0.eq.imiss) then
                  vspd0 = amiss
                elseif(idt_dif0.gt.0) then
                  vspd0 = ht_dif0 / float(idt_dif0)
                else
                  vspd0 = ht_dif0 / float(idt_dif0+60) 
                endif
c
              else
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
                alatm1 = amiss
                alonm1 = amiss
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
                ht_ftm1 = amiss
                idtm1 = amiss
c                uwindm1 = amiss
c                vwindm1 = amiss
c
                idt_dif0 = imiss
                udist0 = amiss
                vdist0 = amiss
                dist0  = amiss
                upspd0 = amiss
                vpspd0 = amiss
                pspd0  = amiss
                pdir0  = amiss
c
c                uairspd0 = amiss
c                vairspd0 = amiss
                airspd0  = amiss
c                airdir0  = amiss
c
                ht_dif0 = amiss
                vspd0 = amiss
              endif
c
c             Set up temporary variables for iim2 point
c             -----------------------------------------
              if(iim2.ne.0.and.iim1.ne.0) then
                alatm2 = alat(iim2)
                alonm2 = alon(iim2)
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
                if(alon0.lt.90.0.and.alonm2.gt.270.0) 
     $            alonm2 = 360.0 - alonm2
                if(alon0.gt.270.0.and.alonm2.lt.90.0) 
     $            alonm2 = 360.0 + alonm2
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
                ht_ftm2 = ht_ft(iim2)
                idtm2 = idt(iim2)
c
c                if(c_qc(iim2)(7:8).ne.'..') then
c                  uwindm2 = amiss
c                  vwindm2 = amiss
c                else
c                  uwindm2 = -sin(ob_dir(iim2)*d2r)*ob_spd(iim2)
c                  vwindm2 = -cos(ob_dir(iim2)*d2r)*ob_spd(iim2)
c                endif
c
c               Compute groundspeed vector components between iim2 and iim1 points
c               ------------------------------------------------------------------
                if(idtm1.ne.imiss.and.idtm2.ne.imiss) then
                  idt_difm1 = abs(idtm1 - idtm2)
                else
                  idt_difm1 = imiss
                endif
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
                if(alatm2.ne.amiss.and.alonm2.ne.amiss.and.
     $             alatm1.ne.amiss.and.alonm1.ne.amiss.and.
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
     $             idt_difm1.ne.imiss) then
                  udistm1 = gcirc_qc(alat(iim2),alon(iim2),
     $                               alat(iim2),alon(iim1))
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
                  if(sin((alon(iim1)-alon(iim2))*d2r).lt.0.0)
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
     $              udistm1 = -udistm1
                  vdistm1 = gcirc_qc(alat(iim2),alon(iim2),
     $                               alat(iim1),alon(iim2))
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
                  if(sin((alat(iim1)-alat(iim2))*d2r).lt.0.0)
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
     $              vdistm1 = -vdistm1
                  distm1  = gcirc_qc(alat(iim2),alon(iim2),
     $                               alat(iim1),alon(iim1))
                  if(idt_difm1.gt.0) then
                    upspdm1 = udistm1 / float(idt_difm1)
                    vpspdm1 = vdistm1 / float(idt_difm1)
                    pspdm1  = distm1  / float(idt_difm1)
                  else
                    upspdm1 = udistm1 / float(idt_difm1+60)
                    vpspdm1 = vdistm1 / float(idt_difm1+60)
                    pspdm1  = distm1  / float(idt_difm1+60)
                  endif
                  if(upspdm1.eq.0.0.and.vpspdm1.eq.0.0) then
                    pdirm1 = 0.0
                  else
                    pdirm1 = atan2(upspdm1,vpspdm1) / d2r + 180.0
                  endif
                  distm1 = distm1 / 1000.0
                else
                  udistm1 = amiss
                  vdistm1 = amiss
                  distm1  = amiss
                  upspdm1 = amiss
                  vpspdm1 = amiss
                  pspdm1  = amiss
                  pdirm1  = amiss
                endif
c
c               Compute airspeed between iim2 and iim1 points
c               ---------------------------------------------
c                if(uwindm1.ne.amiss.and.upspdm1.ne.amiss) then
c                  uairspdm1 = upspdm1 - uwindm1
c                  vairspdm1 = vpspdm1 - vwindm1
c                  airspdm1  = sqrt(uairspdm1**2+vairspdm1**2)
c
                if(ob_dir(iim1).ne.amiss.and.ob_spd(iim1).ne.amiss) then
                  airspdm1 = sqrt(pspdm1**2 + ob_spd(iim1)**2 
     $                     - 2.0*pspdm1*ob_spd(iim1)
     $                       *cos((pdirm1-ob_dir(iim1))*d2r))
c
c                 Make allowances for aircraft that round time to the 
c                 nearest minute--divide by 120 sec rather than 60 sec
c                 (modified to allow for mixture of reports with time
c                  rounded to the nearest minute and interpolated time
c                  to the nearest second in ascents--P.M.Pauley 6/11/01)
c                 ----------------------------------------------------
                  if(airspdm1.gt.spd_thresh.and.
     $               (abs(idt_difm1).eq.60.or.
     $                (abs(idt_difm1).lt.60.and.
     $                 ((idt(iim1)/60)*60.eq.idt(iim1).or.
     $                  (idt(iim2)/60)*60.eq.idt(iim2))))) then
c
                    airspdm1 = airspdm1 / 2.0
c
                  endif
c
c                  if(uairspdm1.eq.0.0.and.vairspdm1.eq.0.0) then
c                    airdirm1 = 0.0
c                  else
c                    airdirm1 = atan2(uairspdm1,vairspdm1) / d2r + 180.0
c                  endif
c
                else
c                  uairspdm1 = amiss
c                  vairspdm1 = amiss
                  airspdm1  = pspdm1
c                  airdirm1  = pdirm1
                endif
c
c               Compute vertical speed between iim2 and iim1 points
c               ---------------------------------------------------
                if(ht_ftm2.ne.amiss.and.ht_ftm1.ne.amiss) then
                  ht_difm1  = ht_ft(iim1) - ht_ft(iim2)
                else
                  ht_difm1 = amiss
                endif
                if(ht_difm1.eq.amiss.or.idt_difm1.eq.imiss) then
                  vspdm1 = amiss
                elseif(idt_difm1.gt.0) then
                  vspdm1 = ht_difm1 / float(idt_difm1)
                else
                  vspdm1 = ht_difm1 / float(idt_difm1+60) 
                endif
c
              else
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
                alatm2 = amiss
                alonm2 = amiss
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
                ht_ftm2 = amiss
                idtm2 = amiss
c                uwindm2 = amiss
c                vwindm2 = amiss
c
                idt_difm1 = imiss
                udistm1 = amiss
                vdistm1 = amiss
                distm1  = amiss
                upspdm1 = amiss
                vpspdm1 = amiss
                pspdm1  = amiss
                pdirm1  = amiss
c
c                uairspdm1 = amiss
c                vairspdm1 = amiss
                airspdm1  = amiss
c                airdirm1  = amiss
c
                ht_difm1 = amiss
                vspdm1 = amiss
              endif
c
c             Set other variables to missing
c             ------------------------------
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
              alatm3 = amiss
              alonm3 = amiss
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
              ht_ftm3 = amiss
              idtm3 = amiss
c              uwindm3 = amiss
c              vwindm3 = amiss
c
              idt_difm2 = imiss
              udistm2 = amiss
              vdistm2 = amiss
              distm2  = amiss
              upspdm2 = amiss
              vpspdm2 = amiss
              pspdm2  = amiss
              pdirm2  = amiss
c
c              uairspdm2 = amiss
c              vairspdm2 = amiss
              airspdm2  = amiss
c              airdirm2  = amiss
c
              ht_difm2 = amiss
              vspdm2 = amiss
c
c             Set up temporary variables for iip1 point
c             -----------------------------------------
              if(iip1.ne.0) then
                alatp1 = alat(iip1)
                alonp1 = alon(iip1)
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
                if(alon0.lt.90.0.and.alonp1.gt.270.0) 
     $            alonp1 = 360.0 - alonp1
                if(alon0.gt.270.0.and.alonp1.lt.90.0) 
     $            alonp1 = 360.0 + alonp1
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
                ht_ftp1 = ht_ft(iip1)
                idtp1 = idt(iip1)
c
c                if(c_qc(iip1)(7:8).ne.'..') then
c                  uwindp1 = amiss
c                  vwindp1 = amiss
c                else
c                  uwindp1 = -sin(ob_dir(iip1)*d2r)*ob_spd(iip1)
c                  vwindp1 = -cos(ob_dir(iip1)*d2r)*ob_spd(iip1)
c                endif
c
c               Compute groundspeed vector components between ii and iip1 points
c               ----------------------------------------------------------------
                if(idt0.ne.imiss.and.idtp1.ne.imiss) then
                  idt_difp1 = abs(idt0 - idtp1)
                else
                  idt_difp1 = imiss
                endif
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
                if(alat0 .ne.amiss.and.alon0 .ne.amiss.and.
     $             alatp1.ne.amiss.and.alonp1.ne.amiss.and.
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
     $             idt_difp1.ne.imiss) then
                  udistp1 = gcirc_qc(alat(ii  ),alon(ii  ),
     $                               alat(ii  ),alon(iip1))
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
                  if(sin((alon(iip1)-alon(ii))*d2r).lt.0.0)
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
     $              udistp1 = -udistp1
                  vdistp1 = gcirc_qc(alat(ii  ),alon(ii  ),
     $                               alat(iip1),alon(ii  ))
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
                  if(sin((alat(iip1)-alat(ii))*d2r).lt.0.0)
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
     $              vdistp1 = -vdistp1
                  distp1  = gcirc_qc(alat(ii  ),alon(ii  ),
     $                               alat(iip1),alon(iip1))
                  if(idt_difp1.gt.0) then
                    upspdp1 = udistp1 / float(idt_difp1)
                    vpspdp1 = vdistp1 / float(idt_difp1)
                    pspdp1  = distp1  / float(idt_difp1)
                  else
                    upspdp1 = udistp1 / float(idt_difp1+60)
                    vpspdp1 = vdistp1 / float(idt_difp1+60)
                    pspdp1  = distp1  / float(idt_difp1+60)
                  endif
                  if(upspdp1.eq.0.0.and.vpspdp1.eq.0.0) then
                    pdirp1 = 0.0
                  else
                    pdirp1 = atan2(upspdp1,vpspdp1) / d2r + 180.0
                 endif
                  distp1 = distp1 / 1000.0
                else
                  udistp1 = amiss
                  vdistp1 = amiss
                  distp1  = amiss
                  upspdp1 = amiss
                  vpspdp1 = amiss
                  pspdp1  = amiss
                  pdirp1  = amiss
                endif
c
c               Compute airspeed between ii and iip1 points
c               -------------------------------------------
c                if(uwindp1.ne.amiss.and.upspdp1.ne.amiss) then
c                  uairspdp1 = upspdp1 - uwindp1
c                  vairspdp1 = vpspdp1 - vwindp1
c                  airspdp1  = sqrt(uairspdp1**2+vairspdp1**2)
c
                if(ob_dir(iip1).ne.amiss.and.ob_spd(iip1).ne.amiss) then
                  airspdp1 = sqrt(pspdp1**2 + ob_spd(iip1)**2 
     $                     - 2.0*pspdp1*ob_spd(iip1)
     $                       *cos((pdirp1-ob_dir(iip1))*d2r))
c
c                 Make allowances for aircraft that round time to the 
c                 nearest minute--divide by 120 sec rather than 60 sec
c                 (modified to allow for mixture of reports with time
c                  rounded to the nearest minute and interpolated time
c                  to the nearest second in ascents--P.M.Pauley 6/11/01)
c                 ----------------------------------------------------
                  if(airspdp1.gt.spd_thresh.and.
     $               (abs(idt_difp1).eq.60.or.
     $                (abs(idt_difp1).lt.60.and.
     $                 ((idt(ii  )/60)*60.eq.idt(ii  ).or.
     $                  (idt(iip1)/60)*60.eq.idt(iip1))))) then
c
                    airspdp1 = airspdp1 / 2.0
c
                  endif
c
c                  if(uairspdp1.eq.0.0.and.vairspdp1.eq.0.0) then
c                    airdirp1 = 0.0
c                  else
c                    airdirp1 = atan2(uairspdp1,vairspdp1) / d2r + 180.0
c                  endif
c
                else
c                  uairspdp1 = amiss
c                  vairspdp1 = amiss
                  airspdp1  = pspdp1
c                  airdirp1  = pdirp1
                endif
c
c               Compute vertical speed between ii and iip1 points
c               -------------------------------------------------
                if(ht_ft0.ne.amiss.and.ht_ftp1.ne.amiss) then
                  ht_difp1  = ht_ft(iip1) - ht_ft(ii)
                else
                  ht_difp1 = amiss
                endif
                if(ht_difp1.eq.amiss.or.idt_difp1.eq.imiss) then
                  vspdp1 = amiss
                elseif(idt_difp1.gt.0) then
                  vspdp1 = ht_difp1 / float(idt_difp1)
                else
                  vspdp1 = ht_difp1 / float(idt_difp1+60) 
                endif
c
              else
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
                alatp1 = amiss
                alonp1 = amiss
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
                ht_ftp1 = amiss
                idtp1 = amiss
c                uwindp1 = amiss
c                vwindp1 = amiss
c
                idt_difp1 = imiss
                udistp1 = amiss
                vdistp1 = amiss
                distp1  = amiss
                upspdp1 = amiss
                vpspdp1 = amiss
                pspdp1  = amiss
                pdirp1  = amiss
c
c                uairspdp1 = amiss
c                vairspdp1 = amiss
                airspdp1  = amiss
c                airdirp1  = amiss
c
                ht_difp1 = amiss
                vspdp1 = amiss
              endif
c
c             Set up temporary variables for iip2 point
c             -----------------------------------------
              if(iip2.ne.0) then
                alatp2 = alat(iip2)
                alonp2 = alon(iip2)
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
                if(alon0.lt.90.0.and.alonp2.gt.270.0) 
     $            alonp2 = 360.0 - alonp2
                if(alon0.gt.270.0.and.alonp2.lt.90.0) 
     $            alonp2 = 360.0 + alonp2
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
                ht_ftp2 = ht_ft(iip2)
                idtp2 = idt(iip2)
c
c                if(c_qc(iip2)(7:8).ne.'..') then
c                  uwindp2 = amiss
c                  vwindp2 = amiss
c                else
c                  uwindp2 = -sin(ob_dir(iip2)*d2r)*ob_spd(iip2)
c                  vwindp2 = -cos(ob_dir(iip2)*d2r)*ob_spd(iip2)
c                endif
c
              else
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
                alatp2 = amiss
                alonp2 = amiss
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
                ht_ftp2 = amiss
                idtp2 = amiss
c                uwindp2 = amiss
c                vwindp2 = amiss
              endif
c
              if(iip2.ne.0.and.iip1.ne.0) then
c
c               Compute groundspeed vector components between iip1 and iip2 points
c               ------------------------------------------------------------------
                if(idtp1.ne.imiss.and.idtp2.ne.imiss) then
                  idt_difp2 = abs(idtp1 - idtp2)
                else
                  idt_difp2 = imiss
                endif
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
                if(alatp1.ne.amiss.and.alonp1.ne.amiss.and.
     $             alatp2.ne.amiss.and.alonp2.ne.amiss.and.
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
     $             idt_difp2.ne.imiss) then
                  udistp2 = gcirc_qc(alat(iip1),alon(iip1),
     $                               alat(iip1),alon(iip2))
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
                  if(sin((alon(iip2)-alon(iip1))*d2r).lt.0.0)
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
     $              udistp2 = -udistp2
                  vdistp2 = gcirc_qc(alat(iip1),alon(iip1),
     $                               alat(iip2),alon(iip1))
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
                  if(sin((alat(iip2)-alat(iip1))*d2r).lt.0.0)
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
     $              vdistp2 = -vdistp2
                  distp2  = gcirc_qc(alat(iip1),alon(iip1),
     $                               alat(iip2),alon(iip2))
                  if(idt_difp2.gt.0) then
                    upspdp2 = udistp2 / float(idt_difp2)
                    vpspdp2 = vdistp2 / float(idt_difp2)
                    pspdp2  = distp2  / float(idt_difp2)
                  else
                    upspdp2 = udistp2 / float(idt_difp2+60)
                    vpspdp2 = vdistp2 / float(idt_difp2+60)
                    pspdp2  = distp2  / float(idt_difp2+60)
                  endif
                  if(upspdp2.eq.0.0.and.vpspdp2.eq.0.0) then
                    pdirp2 = 0.0
                  else
                    pdirp2 = atan2(upspdp2,vpspdp2) / d2r + 180.0
                  endif
                  distp2 = distp2 / 1000.0
                else
                  udistp2 = amiss
                  vdistp2 = amiss
                  distp2  = amiss
                  upspdp2 = amiss
                  vpspdp2 = amiss
                  pspdp2  = amiss
                  pdirp2  = amiss
                endif
c
c               Compute airspeed between iip1 and iip2 points
c               ---------------------------------------------
c                if(uwindp2.ne.amiss.and.upspdp2.ne.amiss) then
c                  uairspdp2 = upspdp2 - uwindp2
c                  vairspdp2 = vpspdp2 - vwindp2
c                  airspdp2  = sqrt(uairspdp2**2+vairspdp2**2)
c
                if(ob_dir(iip2).ne.amiss.and.ob_spd(iip2).ne.amiss) then
                  airspdp2 = sqrt(pspdp2**2 + ob_spd(iip2)**2 
     $                     - 2.0*pspdp2*ob_spd(iip2)
     $                       *cos((pdirp2-ob_dir(iip2))*d2r))
c
c                 Make allowances for aircraft that round time to the 
c                 nearest minute--divide by 120 sec rather than 60 sec
c                 (modified to allow for mixture of reports with time
c                  rounded to the nearest minute and interpolated time
c                  to the nearest second in ascents--P.M.Pauley 6/11/01)
c                 ----------------------------------------------------
                  if(airspdp2.gt.spd_thresh.and.
     $               (abs(idt_difp2).eq.60.or.
     $                (abs(idt_difp2).lt.60.and.
     $                 ((idt(iip1)/60)*60.eq.idt(iip1).or.
     $                  (idt(iip2)/60)*60.eq.idt(iip2))))) then
c
                    airspdp2 = airspdp2 / 2.0
c
                  endif
c
c                  if(uairspdp2.eq.0.0.and.vairspdp2.eq.0.0) then
c                    airdirp2 = 0.0
c                  else
c                    airdirp2 = atan2(uairspdp2,vairspdp2) / d2r + 180.0
c                  endif
c
                else
c                  uairspdp2 = amiss
c                  vairspdp2 = amiss
                  airspdp2  = pspdp2
c                  airdirp2  = pdirp2
                endif
c
c               Compute vertical speed between iip1 and iip2 points
c               ---------------------------------------------------
                if(ht_ftp1.ne.amiss.and.ht_ftp2.ne.amiss) then
                  ht_difp2  = ht_ft(iip2) - ht_ft(iip1)
                else
                  ht_difp2 = amiss
                endif
                if(ht_difp2.eq.amiss.or.idt_difp2.eq.imiss) then
                  vspdp2 = amiss
                elseif(idt_difp2.gt.0) then
                  vspdp2 = ht_difp2 / float(idt_difp2)
                else
                  vspdp2 = ht_difp2 / float(idt_difp2+60) 
                endif
c
              else
                idt_difp2 = imiss
                udistp2 = amiss
                vdistp2 = amiss
                distp2  = amiss
                upspdp2 = amiss
                vpspdp2 = amiss
                pspdp2  = amiss
                pdirp2  = amiss
c
c                uairspdp2 = amiss
c                vairspdp2 = amiss
                airspdp2  = amiss
c                airdirp2  = amiss
c
                ht_difp2 = amiss
                vspdp2 = amiss
              endif
c
c             Set other variables to zero
c             ---------------------------
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
              alatp3 = amiss
              alonp3 = amiss
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
              ht_ftp3 = amiss
              idtp3 = amiss
c              uwindp3 = amiss
c              vwindp3 = amiss
c
              idt_difp3 = imiss
              udistp3 = amiss
              vdistp3 = amiss
              distp3  = amiss
              upspdp3 = amiss
              vpspdp3 = amiss
              pspdp3  = amiss
              pdirp3  = amiss
c
c              uairspdp3 = amiss
c              vairspdp3 = amiss
              airspdp3  = amiss
c              airdirp3  = amiss
c
              ht_difp3 = amiss
              vspdp3 = amiss
c           
c             Compute speeds without ii report
c             --------------------------------
              if(iim1.ne.0.and.iip1.ne.0.and.
     $           idtp1.ne.amiss.and.idtm1.ne.amiss) then
c
c               Compute groundspeed vector components between iim1 and iip1 points
c               ------------------------------------------------------------------
                if(idtm1.ne.imiss.and.idtp1.ne.imiss) then
                  idt_dif_wo0 = abs(idtp1 - idtm1)
                else
                  idt_dif_wo0 = imiss
                endif
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
                if(alatm1.ne.amiss.and.alonm1.ne.amiss.and.
     $             alatp1.ne.amiss.and.alonp1.ne.amiss.and.
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
     $             idt_dif_wo0.ne.imiss) then
                  udist_wo0 = gcirc_qc(alat(iim1),alon(iim1),
     $                                 alat(iim1),alon(iip1))
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
                  if(sin((alon(iip1)-alon(iim1))*d2r).lt.0.0)
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
     $              udist_wo0 = -udist_wo0
                  vdist_wo0 = gcirc_qc(alat(iim1),alon(iim1),
     $                                 alat(iip1),alon(iim1))
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
                  if(sin((alat(iip1)-alat(iim1))*d2r).lt.0.0)
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
     $              vdist_wo0 = -vdist_wo0
                  dist_wo0  = gcirc_qc(alat(iim1),alon(iim1),
     $                                 alat(iip1),alon(iip1))
                  if(idt_dif_wo0.gt.0) then
                    upspd_wo0 = udist_wo0 / float(idt_dif_wo0)
                    vpspd_wo0 = vdist_wo0 / float(idt_dif_wo0)
                    pspd_wo0  = dist_wo0  / float(idt_dif_wo0)
                  else
                    upspd_wo0 = udist_wo0 / float(idt_dif_wo0+60)
                    vpspd_wo0 = vdist_wo0 / float(idt_dif_wo0+60)
                    pspd_wo0  = dist_wo0  / float(idt_dif_wo0+60)
                  endif
                  if(upspd_wo0.eq.0.0.and.vpspd_wo0.eq.0.0) then
                    pdir_wo0 = 0.0
                  else
                    pdir_wo0 = atan2(upspd_wo0,vpspd_wo0) 
     $                       / d2r + 180.0
                  endif
                  dist_wo0 = dist_wo0 / 1000.0
                else
                  udist_wo0 = amiss
                  vdist_wo0 = amiss
                  dist_wo0  = amiss
                  upspd_wo0 = amiss
                  vpspd_wo0 = amiss
                  pspd_wo0  = amiss
                  pdir_wo0  = amiss
                endif
c
c               Compute airspeed between iim1 and iip1 points
c               ---------------------------------------------
c                if(uwindp1.ne.amiss.and.upspd_wo0.ne.amiss) then
c                  uairspd_wo0 = upspd_wo0 - uwindp1
c                  vairspd_wo0 = vpspd_wo0 - vwindp1
c                  airspd_wo0  = sqrt(uairspd_wo0**2+vairspd_wo0**2)
c
                if(ob_dir(iip1).ne.amiss.and.ob_spd(iip1).ne.amiss) then
                  airspd_wo0 = sqrt(pspd_wo0**2 + ob_spd(iip1)**2 
     $                     - 2.0*pspd_wo0*ob_spd(iip1)
     $                       *cos((pdir_wo0-ob_dir(iip1))*d2r))
c
c                 Make allowances for aircraft that round time to the 
c                 nearest minute--divide by 120 sec rather than 60 sec
c                 (modified to allow for mixture of reports with time
c                  rounded to the nearest minute and interpolated time
c                  to the nearest second in ascents--P.M.Pauley 6/11/01)
c                 ----------------------------------------------------
                  if(airspd_wo0.gt.spd_thresh.and.
     $               (abs(idt_dif_wo0).eq.60.or.
     $                (abs(idt_dif_wo0).lt.60.and.
     $                 ((idt(iim1)/60)*60.eq.idt(iim1).or.
     $                  (idt(iip1)/60)*60.eq.idt(iip1))))) then
c
                    airspd_wo0 = airspd_wo0 / 2.0
c
                  endif
c
c                  if(uairspd_wo0.eq.0.0.and.vairspd_wo0.eq.0.0) then
c                    airdir_wo0 = 0.0
c                  else
c                    airdir_wo0 = atan2(uairspd_wo0,vairspd_wo0) 
c     $                         / d2r + 180.0
c                  endif
c
                else
c                  uairspd_wo0 = amiss
c                  vairspd_wo0 = amiss
                  airspd_wo0  = pspd_wo0
c                  airdir_wo0  = pdir_wo0
                endif
c
              else
                udist_wo0 = amiss
                vdist_wo0 = amiss
                dist_wo0  = amiss
                upspd_wo0 = amiss
                vpspd_wo0 = amiss
                pspd_wo0  = amiss
                pdir_wo0  = amiss
c
c                uairspd_wo0 = amiss
c                vairspd_wo0 = amiss
                airspd_wo0  = amiss
c                airdir_wo0  = amiss
              endif
c
c             Compute vertical speed between iim1 and iip1 points
c             ---------------------------------------------------
              if(ht_ftp1.ne.amiss.and.ht_ftm1.ne.amiss) then
                ht_dif_wo0  = ht_ftp1 - ht_ftm1
              else
                ht_dif_wo0 = amiss
              endif
              if(ht_dif_wo0.eq.amiss.or.idt_dif_wo0.eq.imiss) then
                vspd_wo0 = amiss
              elseif(idt_dif_wo0.gt.0) then
                vspd_wo0 = ht_dif_wo0 / float(idt_dif_wo0)
              else
                vspd_wo0 = ht_dif_wo0 / float(idt_dif_wo0+60) 
              endif
c
c             Compute speeds without iip1 report
c             ----------------------------------
              if(iip2.ne.0.and.
     $           idt0.ne.amiss.and.idtp2.ne.amiss) then
c
c               Compute groundspeed vector components between ii and iip2 points
c               ----------------------------------------------------------------
                if(idt0.ne.imiss.and.idtp2.ne.imiss) then
                  idt_dif_wop1 = abs(idtp2 - idt0)
                else
                  idt_dif_wop1 = imiss
                endif
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
                if(alat0 .ne.amiss.and.alon0 .ne.amiss.and.
     $             alatp2.ne.amiss.and.alonp2.ne.amiss.and.
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
     $             idt_dif_wop1.ne.imiss) then
                  udist_wop1 = gcirc_qc(alat(ii  ),alon(ii  ),
     $                                  alat(ii  ),alon(iip2))
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
                  if(sin((alon(iip2)-alon(ii))*d2r).lt.0.0)
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
     $              udist_wop1 = -udist_wop1
                  vdist_wop1 = gcirc_qc(alat(ii  ),alon(ii  ),
     $                                  alat(iip2),alon(ii  ))
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
                  if(sin((alat(iip2)-alat(ii))*d2r).lt.0.0)
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
     $              vdist_wop1 = -vdist_wop1
                  dist_wop1  = gcirc_qc(alat(ii  ),alon(ii  ),
     $                                  alat(iip2),alon(iip2))
                  if(idt_dif_wop1.gt.0) then
                    upspd_wop1 = udist_wop1 / float(idt_dif_wop1)
                    vpspd_wop1 = vdist_wop1 / float(idt_dif_wop1)
                    pspd_wop1  = dist_wop1  / float(idt_dif_wop1)
                  else
                    upspd_wop1 = udist_wop1 / float(idt_dif_wop1+60)
                    vpspd_wop1 = vdist_wop1 / float(idt_dif_wop1+60)
                    pspd_wop1  = dist_wop1  / float(idt_dif_wop1+60)
                  endif
                  if(upspd_wop1.eq.0.0.and.vpspd_wop1.eq.0.0) then
                    pdir_wop1 = 0.0
                  else
                    pdir_wop1 = atan2(upspd_wop1,vpspd_wop1) 
     $                        / d2r + 180.0
                  endif
                  dist_wop1 = dist_wop1 / 1000.0
                else
                  udist_wop1 = amiss
                  vdist_wop1 = amiss
                  dist_wop1  = amiss
                  upspd_wop1 = amiss
                  vpspd_wop1 = amiss
                  pspd_wop1  = amiss
                  pdir_wop1  = amiss
                endif
c
c               Compute airspeed between ii and iip2 points
c               -------------------------------------------
c                if(uwindp2.ne.amiss.and.upspd_wop1.ne.amiss) then
c                  uairspd_wop1 = upspd_wop1 - uwindp2
c                  vairspd_wop1 = vpspd_wop1 - vwindp2
c                  airspd_wop1  = sqrt(uairspd_wop1**2+vairspd_wop1**2)
c
                if(ob_dir(iip2).ne.amiss.and.ob_spd(iip2).ne.amiss) then
                  airspd_wop1 = sqrt(pspd_wop1**2 + ob_spd(iip2)**2 
     $                     - 2.0*pspd_wop1*ob_spd(iip2)
     $                       *cos((pdir_wop1-ob_dir(iip2))*d2r))
c
c                 Make allowances for aircraft that round time to the 
c                 nearest minute--divide by 120 sec rather than 60 sec
c                 (modified to allow for mixture of reports with time
c                  rounded to the nearest minute and interpolated time
c                  to the nearest second in ascents--P.M.Pauley 6/11/01)
c                 ----------------------------------------------------
                  if(airspd_wop1.gt.spd_thresh.and.
     $               (abs(idt_dif_wop1).eq.60.or.
     $                (abs(idt_dif_wop1).lt.60.and.
     $                 ((idt(ii  )/60)*60.eq.idt(ii  ).or.
     $                  (idt(iip2)/60)*60.eq.idt(iip2))))) then
c
                    airspd_wop1 = airspd_wop1 / 2.0
c
                  endif
c
c                  if(uairspd_wop1.eq.0.0.and.vairspd_wop1.eq.0.0) then
c                    airdir_wop1 = 0.0
c                  else
c                    airdir_wop1 = atan2(uairspd_wop1,vairspd_wop1) 
c     $                          / d2r + 180.0
c                  endif
c
                else
c                  uairspd_wop1 = amiss
c                  vairspd_wop1 = amiss
                  airspd_wop1  = pspd_wop1
c                  airdir_wop1  = pdir_wop1
                endif
c
              else
                udist_wop1 = amiss
                vdist_wop1 = amiss
                dist_wop1  = amiss
                upspd_wop1 = amiss
                vpspd_wop1 = amiss
                pspd_wop1  = amiss
                pdir_wop1  = amiss
c
c                uairspd_wop1 = amiss
c                vairspd_wop1 = amiss
                airspd_wop1  = amiss
c                airdir_wop1  = amiss
              endif
c
c             Compute vertical speed between ii and iip2 points
c             -------------------------------------------------
              if(ht_ftp2.ne.amiss.and.ht_ft0.ne.amiss) then
                ht_dif_wop1  = ht_ftp2 - ht_ft0
              else
                ht_dif_wop1 = amiss
              endif
              if(ht_dif_wop1.eq.amiss.or.idt_dif_wop1.eq.imiss) then
                vspd_wop1 = amiss
              elseif(idt_dif_wop1.gt.0) then
                vspd_wop1 = ht_dif_wop1 / float(idt_dif_wop1)
              else
                vspd_wop1 = ht_dif_wop1 / float(idt_dif_wop1+60) 
              endif
c
c             Set other variables to zero
c             ---------------------------
              udist_wop2 = amiss
              vdist_wop2 = amiss
              dist_wop2  = amiss
              upspd_wop2 = amiss
              vpspd_wop2 = amiss
              pspd_wop2  = amiss
              pdir_wop2  = amiss
c
c              uairspd_wop2 = amiss
c              vairspd_wop2 = amiss
              airspd_wop2  = amiss
c              airdir_wop2  = amiss
c
              ht_dif_wop2 = amiss
c
              vspd_wop2 = amiss
c
c             Compute speeds between previous two bad points
c             ----------------------------------------------
              if(last_bad.ne.0.and.last_bad_m1.ne.0) then
c
c               Compute groundspeed vector components between last_bad and last_bad_m1 points
c               -----------------------------------------------------------------------------
                if(idt(last_bad_m1).ne.imiss.and.
     $             idt(last_bad).ne.imiss) then
                  idt_dif_bad0 = abs(idt(last_bad) - idt(last_bad_m1))
                else
                  idt_dif_bad0 = imiss
                endif
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
                if(alat(last_bad).ne.amiss.and.
     $             alon(last_bad).ne.amiss.and.
     $             alat(last_bad_m1).ne.amiss.and.
     $             alon(last_bad_m1).ne.amiss.and.
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
     $             idt_dif_bad0.ne.imiss) then
                  udist_bad0 = gcirc_qc(alat(last_bad_m1),
     $                                  alon(last_bad_m1),
     $                                  alat(last_bad_m1),
     $                                  alon(last_bad))
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
                  if(sin((alon(last_bad)-alon(last_bad_m1))*d2r).lt.0.0)
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
     $              udist_bad0 = -udist_bad0
                  vdist_bad0 = gcirc_qc(alat(last_bad_m1),
     $                                  alon(last_bad_m1),
     $                                  alat(last_bad),
     $                                  alon(last_bad_m1))
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
                  if(sin((alat(last_bad)-alat(last_bad_m1))*d2r).lt.0.0) 
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
     $              vdist_bad0 = -vdist_bad0
                  dist_bad0  = gcirc_qc(alat(last_bad_m1),
     $                                  alon(last_bad_m1),
     $                                  alat(last_bad   ),
     $                                  alon(last_bad   ))
                  if(idt_dif_bad0.gt.0) then
                    upspd_bad0 = udist_bad0 / float(idt_dif_bad0)
                    vpspd_bad0 = vdist_bad0 / float(idt_dif_bad0)
                    pspd_bad0  = dist_bad0  / float(idt_dif_bad0)
                  else
                    upspd_bad0 = udist_bad0 / float(idt_dif_bad0+60)
                    vpspd_bad0 = vdist_bad0 / float(idt_dif_bad0+60)
                    pspd_bad0  = dist_bad0  / float(idt_dif_bad0+60)
                  endif
                  if(upspd_bad0.eq.0.0.and.vpspd_bad0.eq.0.0) then
                    pdir_bad0 = 0.0
                  else
                    pdir_bad0 = atan2(upspd_bad0,vpspd_bad0) 
     $                        / d2r + 180.0
                  endif
                  dist_bad0 = dist_bad0 / 1000.0
                else
                  udist_bad0 = amiss
                  vdist_bad0 = amiss
                  dist_bad0  = amiss
                  upspd_bad0 = amiss
                  vpspd_bad0 = amiss
                  pspd_bad0  = amiss
                  pdir_bad0  = amiss
                endif
c
c               Compute airspeed between last_bad and last_bad_m1 points
c               --------------------------------------------------------
c                if(uwind_last.ne.amiss.and.upspd_bad0.ne.amiss) then
c                  uairspd_bad0 = upspd_bad0 - uwind_last
c                  vairspd_bad0 = vpspd_bad0 - vwind_last
c                  airspd_bad0  = sqrt(uairspd_bad0**2+vairspd_bad0**2)
c
                if(wdir_last.ne.amiss.and.wspd_last.ne.amiss) then
                  airspd_bad0 = sqrt(pspd_bad0**2 + wspd_last**2 
     $                     - 2.0*pspd_bad0*wspd_last
     $                       *cos((pdir_bad0-wdir_last)*d2r))
c
c                 Make allowances for aircraft that round time to the 
c                 nearest minute--divide by 120 sec rather than 60 sec
c                 (modified to allow for mixture of reports with time
c                  rounded to the nearest minute and interpolated time
c                  to the nearest second in ascents--P.M.Pauley 6/11/01)
c                 ----------------------------------------------------
                  if(airspd_bad0.gt.spd_thresh.and.
     $               (abs(idt_dif_bad0).eq.60.or.
     $                (abs(idt_dif_bad0).lt.60.and.
     $                 ((idt(last_bad_m1)/60)*60.eq.idt(last_bad_m1).or.
     $                  (idt(last_bad)/60)*60.eq.idt(last_bad))))) then
c
                    airspd_bad0 = airspd_bad0 / 2.0
c
                  endif
c
c                  if(uairspd_bad0.eq.0.0.and.vairspd_bad0.eq.0.0) then
c                    airdir_bad0 = 0.0
c                  else
c                    airdir_bad0 = atan2(uairspd_bad0,vairspd_bad0) 
c     $                          / d2r + 180.0
c                  endif
c
                else
c                  uairspd_bad0 = amiss
c                  vairspd_bad0 = amiss
                  airspd_bad0  = pspd_bad0
c                  airdir_bad0  = pspd_bad0
                endif
c
c               Compute vertical speed between last_bad and last_bad_m1 points
c               --------------------------------------------------------------
                if(ht_ft(last_bad).ne.amiss.and.
     $             ht_ft(last_bad_m1).ne.amiss) then
                  ht_dif_bad0  = ht_ft(last_bad) - ht_ft(last_bad_m1)
                else
                  ht_dif_bad0 = amiss
                endif
                if(ht_dif_bad0.eq.amiss.or.idt_dif_bad0.eq.imiss) then
                  vspd_bad0 = amiss
                elseif(idt_dif_bad0.gt.0) then
                  vspd_bad0 = ht_dif_bad0 / float(idt_dif_bad0)
                else
                  vspd_bad0 = ht_dif_bad0 / float(idt_dif_bad0+60) 
                endif
c
              else
                udist_bad0 = amiss
                vdist_bad0 = amiss
                dist_bad0  = amiss
                upspd_bad0 = amiss
                vpspd_bad0 = amiss
                pspd_bad0  = amiss
                pdir_bad0  = amiss
c
c                uairspd_bad0 = amiss
c                vairspd_bad0 = amiss
                airspd_bad0  = amiss
c                airdir_bad0  = amiss
c
                ht_dif_bad0 = amiss           
                vspd_bad0 = amiss
              endif
c
c             Compute speeds between last bad point and iip1 point
c             ----------------------------------------------------
              if(last_bad.ne.0.and.iip1.ne.0) then
c
                idt_last_bad = idt(last_bad)
c
c               Compute groundspeed vector components between last_bad and iip1 points
c               ----------------------------------------------------------------------
                if(idtp1.ne.imiss.and.idt(last_bad).ne.imiss) then
                  idt_dif_badp1 = abs(idtp1 - idt(last_bad))
                else
                  idt_dif_badp1 = imiss
                endif
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
                if(alatp1.ne.amiss.and.alonp1.ne.amiss.and.
     $             alat(last_bad).ne.amiss.and.
     $             alon(last_bad).ne.amiss.and.
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
     $             idt_dif_badp1.ne.imiss) then
                  udist_badp1 = gcirc_qc(alat(last_bad),alon(last_bad),
     $                                   alat(last_bad),alon(iip1))
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
                  if(sin((alon(iip1)-alon(last_bad))*d2r).lt.0.0)
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
     $              udist_badp1 = -udist_badp1
                  vdist_badp1 = gcirc_qc(alat(last_bad),alon(last_bad),
     $                                   alat(iip1    ),alon(last_bad))
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
                  if(sin((alat(iip1)-alat(last_bad))*d2r).lt.0.0)
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
     $              vdist_badp1 = -vdist_badp1
                  dist_badp1  = gcirc_qc(alat(last_bad),alon(last_bad),
     $                                   alat(iip1),alon(iip1))
                  if(idt_dif_badp1.gt.0) then
                    upspd_badp1 = udist_badp1 / float(idt_dif_badp1)
                    vpspd_badp1 = vdist_badp1 / float(idt_dif_badp1)
                    pspd_badp1  = dist_badp1  / float(idt_dif_badp1)
                  else
                    upspd_badp1= udist_badp1 / float(idt_dif_badp1+60)
                    vpspd_badp1= vdist_badp1 / float(idt_dif_badp1+60)
                    pspd_badp1 = dist_badp1  / float(idt_dif_badp1+60)
                  endif
                  if(upspd_badp1.eq.0.0.and.vpspd_badp1.eq.0.0) then
                    pdir_badp1 = 0.0
                  else
                    pdir_badp1 = atan2(upspd_badp1,vpspd_badp1) 
     $                         / d2r + 180.0
                 endif
                  dist_badp1 = dist_badp1 / 1000.0
                else
                  udist_badp1 = amiss
                  vdist_badp1 = amiss
                  dist_badp1  = amiss
                  upspd_badp1 = amiss
                  vpspd_badp1 = amiss
                  pspd_badp1  = amiss
                  pdir_badp1  = amiss
                endif
c      
c               Compute airspeed between last_bad and iip1 points
c               -------------------------------------------------
c                if(uwindp1.ne.amiss.and.upspd_badp1.ne.amiss) then
c                  uairspd_badp1 = upspd_badp1 - uwindp1
c                  vairspd_badp1 = vpspd_badp1 - vwindp1
c                  airspd_badp1  = 
c     $              sqrt(uairspd_badp1**2+vairspd_badp1**2)
c
                if(ob_dir(iip1).ne.amiss.and.ob_spd(iip1).ne.amiss) then
                  airspd_badp1 = sqrt(pspd_badp1**2 + ob_spd(iip1)**2 
     $                     - 2.0*pspd_badp1*ob_spd(iip1)
     $                       *cos((pdir_badp1-ob_dir(iip1))*d2r))
c
c                 Make allowances for aircraft that round time to the 
c                 nearest minute--divide by 120 sec rather than 60 sec
c                 (modified to allow for mixture of reports with time
c                  rounded to the nearest minute and interpolated time
c                  to the nearest second in ascents--P.M.Pauley 6/11/01)
c                 ----------------------------------------------------
                  if(airspd_badp1.gt.spd_thresh.and.
     $               (abs(idt_dif_badp1).eq.60.or.
     $                (abs(idt_dif_badp1).lt.60.and.
     $                 ((idt(last_bad)/60)*60.eq.idt(last_bad).or.
     $                  (idt(iip1)/60)*60.eq.idt(iip1))))) then
c
                    airspd_badp1 = airspd_badp1 / 2.0
c
                  endif
c
c                  if(uairspd_badp1.eq.0.0.and.
c     $               vairspd_badp1.eq.0.0) then
c                    airdir_badp1 = 0.0
c                  else
c                    airdir_badp1 = atan2(uairspd_badp1,vairspd_badp1) 
c     $                           / d2r + 180.0
c                  endif
c
                else
c                  uairspd_badp1 = amiss
c                  vairspd_badp1 = amiss
                  airspd_badp1  = pspd_badp1
c                  airdir_badp1  = pspd_badp1
                endif
c
c               Compute vertical speed between last_bad and iip1 points
c               -------------------------------------------------------
                if(ht_ftp1.ne.amiss.and.
     $             ht_ft(last_bad).ne.amiss) then
                  ht_dif_badp1  = ht_ft(iip1) - ht_ft(last_bad)
                else
                  ht_dif_badp1 = amiss
                endif
                if(ht_dif_badp1.eq.amiss.or.idt_dif_badp1.eq.imiss) then
                  vspd_badp1 = amiss
                elseif(idt_dif_badp1.gt.0) then
                  vspd_badp1 = ht_dif_badp1 / float(idt_dif_badp1)
                else
                  vspd_badp1 = ht_dif_badp1 / float(idt_dif_badp1+60) 
                endif
c
              else
                idt_last_bad = imiss
c
                udist_badp1 = amiss
                vdist_badp1 = amiss
                dist_badp1  = amiss
                upspd_badp1 = amiss
                vpspd_badp1 = amiss
                pspd_badp1  = amiss
                pdir_badp1  = amiss
c
c                uairspd_badp1 = amiss
c                vairspd_badp1 = amiss
                airspd_badp1  = amiss
c                airdir_badp1  = amiss
c
                ht_dif_badp1 = amiss 
                vspd_badp1 = amiss
              endif
c
c             Compute magnitude of temperature, direction, and speed differences
c             (constrain direction difference to be less than 180 deg)
c             ------------------------------------------------------------------
              if(iip1.ne.0) then
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
                if(alat0.eq.amiss.or.alatp1.eq.amiss) then
                  alat_dif = amiss
                  alon_dif = amiss
                else
                  alat_dif = abs(alat0  - alatp1)
                  alon_dif = abs(alon0  - alonp1)
                  if(alon_dif.gt.180.) alon_dif = 360. - alon_dif
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
                endif
                if(ob_t(ii).eq.amiss.or.
     $             ob_t(iip1).eq.amiss) then
                  dif_t = amiss
                else
                  dif_t = abs(ob_t(iip1)-ob_t(ii))
                endif
                if(ob_dir(ii).eq.amiss.or.
     $             ob_dir(iip1).eq.amiss) then
                  dif_dir = amiss
                else
                  dif_dir = abs(ob_dir(iip1)-ob_dir(ii))
                  if(dif_dir.gt.180.) dif_dir = 360. - dif_dir
                endif
                if(ob_spd(ii).eq.amiss.or.
     $             ob_spd(iip1).eq.amiss) then
                  dif_spd = amiss
                else
                  dif_spd = abs(ob_spd(iip1)-ob_spd(ii))
                endif
              else
                dif_t = amiss
                dif_dir = amiss
                dif_spd = amiss
              endif
c
              job = iob
              jjstart = ii
              iifirst = ii
              iobfirst = iob
              iilast = iiend
              ioblast = iend
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
              alat_min =  9999.9
              alat_max = -9999.9
              alon_min =  9999.9
              alon_max = -9999.9
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
c
              idt_start = imiss
              idt_end = imiss
c
              udist_track = amiss
              vdist_track = amiss
              dist_track  = amiss
              upspd_track = amiss
              vpspd_track = amiss
              pspd_track  = amiss
              pdir_track  = amiss
c
c              uairspd_track = amiss
c              vairspd_track = amiss
              airspd_track  = amiss
c              airdir_track  = amiss
c
              ht_dif_track = amiss 
              vspd_track = amiss
c
c Check for manAIREP location duplicates
c --------------------------------------
              if(iip1.ne.0.and.
     $           l_ii_man_airep.and. 
     $           l_iip1_man_airep.and. 
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
     $           alat_dif.ne.amiss.and.alat_dif.lt.0.015.and.
     $           alon_dif.ne.amiss.and.alon_dif.lt.0.015.and.
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
     $           ht_ft0.gt.21000.) then
c
                if((ht_difp2.ne.amiss.and.
     $              abs(ht_difp2).lt.htdif_same).or.
     $             (ht_dif_wo0.ne.amiss.and.
     $              abs(ht_dif_wo0).lt.htdif_same).or.
     $             (airspd_wop1.ne.amiss.and.
     $              airspd_wop1.gt.spd_thresh).or.
     $             (abs(ht_difp2).lt.3000.0.and.
     $              abs(ht_dif_wop1).gt.3000.0).or.
     $             (ht_dif0.ne.amiss.and.
     $              abs(ht_dif_wo0).lt.3000.0.and.
     $              abs(ht_dif0).gt.3000.0)) then
c
                  c_qc(ii)(1:1) = 'd'
                  iob = iob + 1
                  l_ii_pspd_ok = .false.
c
                  l_print = .true.
                  if(l_print) then
                    write(io8,*) 
                    write(io8,*) 'manAIREP location duplicate ii',ii
                  endif
c
                elseif((ht_dif0.ne.amiss.and.
     $                  abs(ht_dif0).lt.htdif_same).or.
     $                 (ht_dif_wop1.ne.amiss.and.
     $                  abs(ht_dif_wop1).lt.htdif_same).or.
     $                 (airspd_wo0.ne.amiss.and.
     $                  airspd_wo0.gt.spd_thresh).or.
     $                 (abs(ht_dif_wop1).lt.3000.0.and.
     $                  abs(ht_difp2).gt.3000.0).or.
     $                 (abs(ht_dif0).lt.3000.0.and.
     $                  abs(ht_dif_wo0).gt.3000.0)) then
c
                  c_qc(iip1)(1:1) = 'd'
                  l_ii_pspd_ok = .false.
c
                  l_print = .true.
                  if(l_print) then
                    write(io8,*) 
                    write(io8,*) 'manAIREP location duplicate iip1',iip1
                  endif
c
                else
c
                  c_qc(ii)(1:1) = 'd'
                  iob = iob + 1
                  l_ii_pspd_ok = .false.
c
                  l_print = .true.
                  if(l_print) then
                    write(io8,*) 
                    write(io8,*) 'manAIREP location duplicate ii?',ii
                  endif
                endif
c
c If previous reject had a stuck clock, check if current
c   report has the same time
c ------------------------------------------------------
              elseif(l_stuck.and.
     $               idt_last_bad.ne.imiss.and.
     $               idt(ii).eq.idt_last_bad) then
c
                c_qc(ii)(2:2) = 'K'
                ll = ll + 1
                if(ll.gt.200) then
                  write(io8,*) 'll limit exceeded--indx not saved!',
     $              ii
                else
                  indx_save(ll) = ii
                  knt_bad = knt_bad + 1
                  last_bad = ii
                  last_bad_m1 = iim1
c                  uwind_last = uwind0
c                  vwind_last = vwind0
                  wspd_last = ob_spd(ii)
                  wdir_last = ob_dir(ii)
                endif
c
                iob = iob + 1
                l_ii_pspd_ok = .false.
c
                l_print = .true.
                if(l_print) then
                  write(io8,*) 
                  write(io8,*) 'Another stuck clock found: ii=',ii
                endif
c
c If previous reject had a stuck clock, check if iip1
c   report has the same time
c ---------------------------------------------------
              elseif(l_stuck.and.iip1.ne.0.and.
     $               last_bad.ne.0.and.
     $               idt_dif_badp1.eq.0) then
c
                c_qc(iip1)(2:2) = 'K'
                ll = ll + 1
                if(ll.gt.200) then
                  write(io8,*) 'll limit exceeded--indx not saved!',
     $              iip1
                else
                  indx_save(ll) = iip1
                  knt_bad = knt_bad + 1
                  last_bad = iip1
                  last_bad_m1 = ii
c                  uwind_last = uwindp1
c                  vwind_last = vwindp1
                  wspd_last = ob_spd(iip1)
                  wdir_last = ob_dir(iip1)
                endif
c
                l_ii_pspd_ok = .false.
c
                l_print = .true.
                if(l_print) then
                  write(io8,*) 
                  write(io8,*) 'Another stuck clock found: iip1=',iip1
                endif
c
c If previous reject(s) saved, see if iip1 point is
c   closer to previous point or to last rejected point
c ----------------------------------------------------
              elseif(airspd_badp1.ne.amiss.and.
     $               airspd_badp1.lt.spd_thresh.and.
     $               dist_badp1.ne.amiss.and.
     $               distp1.ne.amiss.and.
     $               dist_badp1.lt.distp1.and.
     $               (dist_badp1.lt.50.0.or.
     $                (pdir_bad0.ne.amiss.and.
     $                 (dist_badp1.lt.100.0.and.
     $                  cos((pdir_badp1-pdir_bad0)*d2r).gt.0.0).or.
     $                 cos((pdir_badp1-pdir_bad0)*d2r).gt.0.70710678))
     $               .and.vspd_badp1.ne.amiss.and.
     $               abs(vspd_badp1).lt.vspd_thresh*2.0/3.0.and.
     $               ht_dif_badp1.ne.amiss.and.
     $               ht_dif_wo0.ne.amiss.and.
     $               (dist_badp1.gt.250.0.or.
     $                abs(ht_dif_badp1).lt.abs(ht_difp1).or.
     $                abs(ht_difp1-ht_dif_badp1).lt.1000.0)) then
c
                c_qc(iip1)(1:1) = 'p'
                c_qc(iip1)(3:4) = 'II'
                ll = ll + 1
                if(ll.gt.200) then
                  write(io8,*) 'll limit exceeded--indx not saved!',
     $              iip1
                else
                  indx_save(ll) = iip1
                  knt_bad = knt_bad + 1
                  last_bad = iip1
                  last_bad_m1 = ii
c                  uwind_last = uwindp1
c                  vwind_last = vwindp1
                  wspd_last = ob_spd(iip1)
                  wdir_last = ob_dir(iip1)
                endif
c
                l_ii_pspd_ok = .false.
c
                l_print = .true.
                if(l_print) then 
                  write(io8,*) 
                  write(io8,*) 'iip1 point closer to last bad pt',iip1
                endif
c
c Perform bounce test for ii point
c --------------------------------
              elseif(vspd0.ne.amiss.and.vspdp1.ne.amiss.and.
     $               vspd0*vspdp1.lt.0.0.and.
     $               abs(vspd0).gt.vspd_bounce.and.
     $               abs(vspdp1).gt.vspd_bounce) then
c
                iob = iob + 1
                l_ii_pspd_ok = .false.
c
                if(iim1.ne.0) then
                  itypem1 = itype(iim1)
                else
                  itypem1 = imiss
                endif
c
                if(itypem1.ne.imiss.and.
     $             ((itypem1.eq.i_mdcrs_asc.or.
     $               itypem1.eq.i_mdcrs_des).and.
     $              (itype(ii).eq.i_mdcrs.or.
     $               itype(ii).eq.i_mdcrs_lvl).and.
     $              (itype(iip1).eq.i_mdcrs_asc.or.
     $               itype(iip1).eq.i_mdcrs_des)).or.
     $             ((itypem1.eq.i_acars_asc.or.
     $               itypem1.eq.i_acars_des).and.
     $              (itype(ii).eq.i_acars.or.
     $               itype(ii).eq.i_acars_lvl).and.
     $              (itype(iip1).eq.i_acars_asc.or.
     $               itype(iip1).eq.i_acars_des))) then
c
                  c_qc(ii)(2:2) = 'I'
c
                  if(c_acftreg(ii)(4:5).eq.'GU'.or.
     $               c_acftreg(ii)(4:5).eq.'WU') then
                    l_print = .false.
                  else
                    l_print = .true.
                  endif
c
                elseif((itype(ii).eq.i_mdcrs.and.
     $                  (itype(iip1).eq.i_mdcrs_asc.or.
     $                   itype(iip1).eq.i_mdcrs_des.or.
     $                   itype(iip1).eq.i_mdcrs_lvl)).or.
     $                 (itype(ii).eq.i_acars.and.
     $                  (itype(iip1).eq.i_acars_asc.or.
     $                   itype(iip1).eq.i_acars_des.or.
     $                   itype(iip1).eq.i_acars_lvl))) then
c
                  c_qc(ii)(2:2) = 'I'
c
                  if(c_acftreg(ii)(4:5).eq.'GU'.or.
     $               c_acftreg(ii)(4:5).eq.'WU') then
                    l_print = .false.
                  else
                    l_print = .true.
                  endif
c
                else
                  ll = ll + 1
                  if(ll.gt.200) then
                    write(io8,*) 'll limit exceeded--indx not saved!',
     $                ii
                  else
                    indx_save(ll) = ii
                    knt_bad = knt_bad + 1
                    last_bad = ii
                    last_bad_m1 = iim1
c                    uwind_last = uwind0
c                    vwind_last = vwind0
                    wspd_last = ob_spd(ii)
                    wdir_last = ob_dir(ii)
                  endif
c
                  c_qc(ii)(1:1) = 'v'
                  if(c_qc(ii)(5:5).eq.'R') then
                    c_qc(ii)(5:5) = 'i'
                  else
                    c_qc(ii)(5:5) = 'I'
                  endif
                  l_print = .true.
                endif
c
                if(l_print) then
                  write(io8,*)
                  write(io8,*) 'Bounce test failed in report ii--',ii
                endif
c
c Perform bounce test for iip1 point
c ----------------------------------
              elseif(vspdp1.ne.amiss.and.vspdp2.ne.amiss.and.
     $               vspdp1*vspdp2.lt.0.0.and.
     $               abs(vspdp1).gt.vspd_bounce.and.
     $               abs(vspdp2).gt.vspd_bounce) then
c
                l_ii_pspd_ok = .false.
c
                if(((itype(ii).eq.i_mdcrs_asc.or.
     $               itype(ii).eq.i_mdcrs_des).and.
     $              (itype(iip1).eq.i_mdcrs.or.
     $               itype(iip1).eq.i_mdcrs_lvl).and.
     $              (itype(iip2).eq.i_mdcrs_asc.or.
     $               itype(iip2).eq.i_mdcrs_des)).or.
     $             ((itype(ii).eq.i_acars_asc.or.
     $               itype(ii).eq.i_acars_des).and.
     $              (itype(iip1).eq.i_acars.or.
     $               itype(iip1).eq.i_acars_lvl).and.
     $              (itype(iip2).eq.i_acars_asc.or.
     $               itype(iip2).eq.i_acars_des))) then
c
                  c_qc(iip1)(2:2) = 'I'
c
                  if(c_acftreg(iip1)(4:5).eq.'GU'.or.
     $               c_acftreg(iip1)(4:5).eq.'WU') then
                    l_print = .false.
                  else
                    l_print = .true.
                  endif
c
                elseif((itype(iip1).eq.i_mdcrs.and.
     $                  (itype(iip2).eq.i_mdcrs_asc.or.
     $                   itype(iip2).eq.i_mdcrs_des.or.
     $                   itype(iip2).eq.i_mdcrs_lvl)).or.
     $                 (itype(iip1).eq.i_acars.and.
     $                  (itype(iip2).eq.i_acars_asc.or.
     $                   itype(iip2).eq.i_acars_des.or.
     $                   itype(iip2).eq.i_acars_lvl))) then
c
                  c_qc(iip1)(2:2) = 'I'
c
                  if(c_acftreg(iip1)(4:5).eq.'GU'.or.
     $               c_acftreg(iip1)(4:5).eq.'WU') then
                    l_print = .false.
                  else
                    l_print = .true.
                  endif
c
                else
                  ll = ll + 1
                  if(ll.gt.200) then
                    write(io8,*) 'll limit exceeded--indx not saved!',
     $                iip1
                  else
                    indx_save(ll) = iip1
                    knt_bad = knt_bad + 1
                    last_bad = iip1
                    last_bad_m1 = ii
c                    uwind_last = uwindp1
c                    vwind_last = vwindp1
                    wspd_last = ob_spd(iip1)
                    wdir_last = ob_dir(iip1)
                  endif
c
                  c_qc(iip1)(1:1) = 'v'
                  if(c_qc(iip1)(5:5).eq.'R') then
                    c_qc(iip1)(5:5) = 'i'
                  else
                    c_qc(iip1)(5:5) = 'I'
                  endif
                  l_print = .true.
                endif
c
                if(l_print) then
                  write(io8,*)
                  write(io8,*) 'Bounce test failed in rep iip1--',iip1
                endif
c
c Check for discontinuities in ascents
c ------------------------------------
              elseif(vspd0.ne.amiss.and.
     $               vspdp1.ne.amiss.and.
     $               vspdp2.ne.amiss.and.
     $               vspd0.gt.0.0.and.
     $               vspdp1.lt.0.0.and.
     $               vspdp2.gt.0.0.and.
     $               abs(vspdp1).gt.vspd_thresh/2.0.and.
     $               abs(vspdp1).lt.vspd_thresh)then
c
c               Check if iip1 report is a position report
c               -----------------------------------------
                if((itype(iip1).eq.i_mdcrs.and.
     $              (itype(ii).eq.i_mdcrs_asc.or.
     $               itype(ii).eq.i_mdcrs_des.or.
     $               itype(ii).eq.i_mdcrs_lvl)).or.
     $             (itype(iip1).eq.i_acars.and.
     $              (itype(ii).eq.i_acars_asc.or.
     $               itype(ii).eq.i_acars_des.or.
     $               itype(ii).eq.i_acars_lvl))) then
c
                  c_qc(iip1)(2:2) = 'I'
c
                  l_ii_pspd_ok = .false.
c
                  l_print = .false.
                  if(l_print) then
                    write(io8,*)
                    write(io8,*) 'Ascent discontinuity in iip1--',iip1
                    write(io8,*) 'position report'
                  endif
c
c               Check if ii report is a position report
c               ---------------------------------------
                elseif((itype(ii).eq.i_mdcrs.and.
     $                  (itype(iip1).eq.i_mdcrs_asc.or.
     $                   itype(iip1).eq.i_mdcrs_des.or.
     $                   itype(iip1).eq.i_mdcrs_lvl)).or.
     $                 (itype(ii).eq.i_acars.and.
     $                  (itype(iip1).eq.i_acars_asc.or.
     $                   itype(iip1).eq.i_acars_des.or.
     $                   itype(iip1).eq.i_acars_lvl))) then
c
                  c_qc(ii)(2:2) = 'I'
c
                  iob = iob + 1
                  l_ii_pspd_ok = .false.
c
                  l_print = .false.
                  if(l_print) then
                    write(io8,*)
                    write(io8,*) 'Ascent discontinuity in ii--',ii
                    write(io8,*) 'position report'
                  endif
c
                else
                  c_qc(iip1)(1:1) = 'V'
                  if(c_qc(iip1)(5:5).eq.'R') then
                    c_qc(iip1)(5:5) = 'i'
                  else
                    c_qc(iip1)(5:5) = 'I'
                  endif
                  ll = ll + 1
                  if(ll.gt.200) then
                    write(io8,*) 'll limit exceeded--indx not saved!',
     $                iip1
                  else
                    indx_save(ll) = iip1
                    knt_bad = knt_bad + 1
                    last_bad = iip1
                    last_bad_m1 = ii
c                    uwind_last = uwindp1
c                    vwind_last = vwindp1
                    wspd_last = ob_spd(iip1)
                    wdir_last = ob_dir(iip1)
                  endif
c
                  l_ii_pspd_ok = .false.
c
                  l_print = .true.
                  if(l_print) then
                    write(io8,*)
                    write(io8,*) 'Ascent discontinuity in iip1--',iip1
                  endif
                endif
c
c Check for unrealistic airspeeds between ii and iip1 points
c Check airspeeds greater than spd_thresh 
c (or spd_man_thresh if the time difference is greater than 10 min)
c -----------------------------------------------------------------
              elseif(iip1.ne.0.and.
     $               ((c_acftid(ii)(1:3).eq.'AFR'.or.
     $                 c_acftid(ii)(1:3).eq.'BAW').and.
     $                airspdp1.gt.2.0*spd_man_thresh).or.
     $               ((c_acftid(ii)(1:3).ne.'AFR'.and.
     $                 c_acftid(ii)(1:3).ne.'BAW').and.
     $                (airspdp1.gt.spd_thresh.or.
     $                 (idt_difp1.gt.600.and.
     $                  airspdp1.gt.spd_man_thresh))).and.
     $               (.not.l_ii_pspd_ok)) then
c
c               If neighboring points not available, reject both points
c               -------------------------------------------------------
                if(airspd_wo0.eq.amiss.and.
     $             airspd_wop1.eq.amiss) then
c
                  c_qc(ii)(1:1) = 'P'
                  c_qc(ii)(3:4) = 'II'
                  ll = ll + 1
                  if(ll.gt.200) then
                    write(io8,*) 'll limit exceeded--indx not saved!',
     $                ii
                  else
                    indx_save(ll) = ii
                    knt_bad = knt_bad + 1
                  endif
c
                  c_qc(iip1)(1:1) = 'P'
                  c_qc(iip1)(3:4) = 'II'
                  ll = ll + 1
                  if(ll.gt.200) then
                    write(io8,*) 'll limit exceeded--indx not saved!',
     $                iip1
                  else
                    indx_save(ll) = iip1
                    knt_bad = knt_bad + 1
                    last_bad = iip1
                    last_bad_m1 = ii
c                    uwind_last = uwindp1
c                    vwind_last = vwindp1
                    wspd_last = ob_spd(iip1)
                    wdir_last = ob_dir(iip1)
                  endif
c
                  iob = iob + 1
                  l_ii_pspd_ok = .false.
c
                  l_print = .true.
                  if(l_print) then
                    write(io8,*)
                    write(io8,*) 'Air speed--',airspdp1,
     $                           '--too high in report--',ii
                    write(io8,*) 'Rejecting both points'
                  endif
c
c               Check if ii report is a position report
c               (rejects not saved for second flight check)
c               -------------------------------------------
                elseif(idt_difp1.le.60.and.
     $                 ((itype(ii).eq.i_mdcrs.and.
     $                   (itype(iip1).eq.i_mdcrs_asc.or.
     $                    itype(iip1).eq.i_mdcrs_des.or.
     $                    itype(iip1).eq.i_mdcrs_lvl)).or.
     $                  (itype(ii).eq.i_acars.and.
     $                   (itype(iip1).eq.i_acars_asc.or.
     $                    itype(iip1).eq.i_acars_des.or.
     $                    itype(iip1).eq.i_acars_lvl)))) then
c
                  c_qc(ii)(2:2) = 'I'
c
                  iob = iob + 1
                  l_ii_pspd_ok = .false.
c
                  if(c_acftreg(ii)(4:5).eq.'GU'.or.
     $               c_acftreg(ii)(4:5).eq.'WU') then
                    l_print = .false.
                  else
                    l_print = .true.
                  endif
c
                  if(l_print) then
                    write(io8,*)
                    write(io8,*) 'Air speed--',airspdp1,
     $                           '--too high in report--',ii
                    write(io8,*) 'Is ii a position report?'
                  endif
c
c               Check if iip1 report is a position report
c               (rejects not saved for second flight check)
c               ---------------------------------------------
                elseif(idt_difp1.le.60.and.
     $                 ((itype(iip1).eq.i_mdcrs.and.
     $                   (itype(ii).eq.i_mdcrs_asc.or.
     $                    itype(ii).eq.i_mdcrs_des.or.
     $                    itype(ii).eq.i_mdcrs_lvl)).or.
     $                  (itype(iip1).eq.i_acars.and.
     $                   (itype(ii).eq.i_acars_asc.or.
     $                    itype(ii).eq.i_acars_des.or.
     $                    itype(ii).eq.i_acars_lvl)))) then
c
                  c_qc(iip1)(2:2) = 'I'
c
                  l_ii_pspd_ok = .false.
c
                  if(c_acftreg(iip1)(4:5).eq.'GU'.or.
     $               c_acftreg(iip1)(4:5).eq.'WU') then
                    l_print = .false.
                  else
                    l_print = .true.
                  endif
c
                  if(l_print) then
                    write(io8,*)
                    write(io8,*) 'Air speed--',airspdp1,
     $                           '--too high in report--',ii
                    write(io8,*) 'Is iip1 a position report?'
                  endif
c
c               Check if ii report is a MDCRS report with zero latitude or longitude
c               (rejects not saved for second flight check)
c               --------------------------------------------------------------------
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
                elseif((abs(alat(ii)).lt.0.005.or.
     $                  abs(alon(ii)).lt.0.005).and.
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
     $                 ((itype(ii).eq.i_mdcrs.and.
     $                   (itype(iip1).eq.i_mdcrs_asc.or.
     $                    itype(iip1).eq.i_mdcrs_des.or.
     $                    itype(iip1).eq.i_mdcrs_lvl)).or.
     $                  (itype(ii).eq.i_acars.and.
     $                   (itype(iip1).eq.i_acars_asc.or.
     $                    itype(iip1).eq.i_acars_des.or.
     $                    itype(iip1).eq.i_acars_lvl)))) then
c
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
                  if(abs(alat(ii)).lt.0.005) c_qc(ii)(3:3) = 'B'
                  if(abs(alon(ii)).lt.0.005) c_qc(ii)(4:4) = 'B'
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
c
                  iob = iob + 1
                  l_ii_pspd_ok = .false.
c
                  l_print = .true.
c
                  if(l_print) then
                    write(io8,*)
                    write(io8,*) 'Air speed--',airspdp1,
     $                           '--too high in report--',ii
                    write(io8,*) 'ii report has zero lat or lon'
                  endif
c
c               Check if iip1 report is a MDCRS report with zero latitude or longitude
c               (rejects not saved for second flight check)
c               ----------------------------------------------------------------------
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
                elseif((abs(alat(iip1)).lt.0.005.or.
     $                  abs(alon(iip1)).lt.0.005).and.
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
     $                 ((itype(iip1).eq.i_mdcrs.and.
     $                   (itype(ii).eq.i_mdcrs_asc.or.
     $                    itype(ii).eq.i_mdcrs_des.or.
     $                    itype(ii).eq.i_mdcrs_lvl)).or.
     $                  (itype(iip1).eq.i_acars.and.
     $                   (itype(ii).eq.i_acars_asc.or.
     $                    itype(ii).eq.i_acars_des.or.
     $                    itype(ii).eq.i_acars_lvl)))) then
c
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
                  if(abs(alat(ii)).lt.0.005) c_qc(ii)(3:3) = 'B'
                  if(abs(alon(ii)).lt.0.005) c_qc(ii)(4:4) = 'B'
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
c
                  l_ii_pspd_ok = .false.
c
                  l_print = .true.
c
                  if(l_print) then
                    write(io8,*)
                    write(io8,*) 'Air speed--',airspdp1,
     $                           '--too high in report--',ii
                    write(io8,*) 'iip1 report has zero lat or lon'
                  endif
c
c               Check if ii report is an AMDAR report with rounded latitude
c               (rejects not saved for second flight check)
c               -----------------------------------------------------------
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
                elseif(float(int(alat(ii))).eq.alat(ii).and.
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
     $                 (itype(ii).eq.i_amdar.or.
     $                  itype(ii).eq.i_amdar_asc.or.
     $                  itype(ii).eq.i_amdar_des.or.
     $                  itype(ii).eq.i_amdar_lvl).and.
     $                 (itype(iip1).eq.i_amdar.or.
     $                  itype(iip1).eq.i_amdar_asc.or.
     $                  itype(iip1).eq.i_amdar_des.or.
     $                  itype(iip1).eq.i_amdar_lvl)) then
c
                  c_qc(ii)(1:1) = 'P'
                  c_qc(ii)(3:4) = 'II'
c
                  iob = iob + 1
                  l_ii_pspd_ok = .false.
c
                  if(c_acftreg(ii)(1:2).eq.'IT') then
                    l_print = .true.
                  else
                    l_print = .true.
                  endif
                  if(l_print) then
                    write(io8,*)
                    write(io8,*) 'Air speed--',airspdp1,
     $                           '--too high in report--',ii
                    write(io8,*) 'AMDAR rep ii has rounded lat'
                  endif
c
c               Check if iip1 report is an AMDAR report with rounded latitude
c               (rejects not saved for second flight check)
c               -------------------------------------------------------------
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
                elseif(float(int(alat(iip1))).eq.alat(iip1).and.
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
     $                 (itype(ii).eq.i_amdar.or.
     $                  itype(ii).eq.i_amdar_asc.or.
     $                  itype(ii).eq.i_amdar_des.or.
     $                  itype(ii).eq.i_amdar_lvl).and.
     $                 (itype(iip1).eq.i_amdar.or.
     $                  itype(iip1).eq.i_amdar_asc.or.
     $                  itype(iip1).eq.i_amdar_des.or.
     $                  itype(iip1).eq.i_amdar_lvl)) then
c
                  c_qc(iip1)(1:1) = 'P'
                  c_qc(iip1)(3:4) = 'II'
c
                  l_ii_pspd_ok = .false.
c
                  if(c_acftreg(ii)(1:2).eq.'IT') then
                    l_print = .true.
                  else
                    l_print = .true.
                  endif
                  if(l_print) then
                    write(io8,*)
                    write(io8,*) 'Air speed--',airspdp1,
     $                           '--too high in report--',ii
                    write(io8,*) 'AMDAR rep iip1 has rounded lat'
                  endif
c
c               Check if ii report is an AMDAR report with the wrong sign on the longitude
c               (rejects not saved for second flight check)
c               --------------------------------------------------------------------------
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
                elseif(alon(ii  ).lt.25.0.and.
     $                 alon(iip1).gt.335.0.and.
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
     $                 (itype(ii).eq.i_amdar.or.
     $                  itype(ii).eq.i_amdar_asc.or.
     $                  itype(ii).eq.i_amdar_des.or.
     $                  itype(ii).eq.i_amdar_lvl).and.
     $                 (itype(iip1).eq.i_amdar.or.
     $                  itype(iip1).eq.i_amdar_asc.or.
     $                  itype(iip1).eq.i_amdar_des.or.
     $                  itype(iip1).eq.i_amdar_lvl)) then
c
                  c_qc(ii)(1:1) = 'P'
                  c_qc(ii)(3:4) = 'II'
c
c                 Search backwards for minimum longitude
c                 Reject points between min and prime meridian
c                 --------------------------------------------
                  if(iim1.ne.0) then
                    if(alon(iim1).lt.alon(ii)) then
                      nob = iob - 1
                      do while(nob.gt.istart)
                        nn = indx(nob)
                        nnm1 = indx(nob-1)
                        if(alon(nnm1).lt.alon(nn)) then
c                          write(io8,*) 
c                          write(io8,*) 'nn not min--',alon(nn),alon(nnm1)
                          nob = nob - 1
                          c_qc(nn)(1:1) = 'P'
                          c_qc(nn)(3:4) = 'II'
                        else
                          nob = istart
                        endif
                      enddo
                    endif
                  endif
c
                  iob = iob + 1
                  l_ii_pspd_ok = .false.
c
                  l_print = .true.
                  if(l_print) then
                    write(io8,*)
                    write(io8,*) 'Air speed--',airspdp1,
     $                           '--too high in report--',ii
                    write(io8,*) 'AMDAR rep ii has wrong sign on lon'
                  endif
c
c                 Go back and recheck flight after printing output
c                 ------------------------------------------------
                  l_retest = .true.
c
c               Check if iip1 report is an AMDAR report with the wrong sign on the longitude
c               (rejects not saved for second flight check)
c               ----------------------------------------------------------------------------
! vvvv DAK-future change perhaps to account for incr. lat/lon precision
                elseif(alon(iip1).lt.25.0.and.
     $                 alon(ii  ).gt.335.0.and.
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
     $                 (itype(ii).eq.i_amdar.or.
     $                  itype(ii).eq.i_amdar_asc.or.
     $                  itype(ii).eq.i_amdar_des.or.
     $                  itype(ii).eq.i_amdar_lvl).and.
     $                 (itype(iip1).eq.i_amdar.or.
     $                  itype(iip1).eq.i_amdar_asc.or.
     $                  itype(iip1).eq.i_amdar_des.or.
     $                  itype(iip1).eq.i_amdar_lvl)) then
c
                  c_qc(iip1)(1:1) = 'P'
                  c_qc(iip1)(3:4) = 'II'
c
c                 Search forwards for minimum longitude
c                 -------------------------------------
                  if(iip2.ne.0) then
                    if(alon(iip2).lt.alon(iip1)) then
                      nob = iob + 2
                      do while(nob.lt.iend)
                        nn = indx(nob)
                        nnp1 = indx(nob+1)
                        if(alon(nnp1).lt.alon(nn)) then
                          write(io8,*) 
                          write(io8,*)'nn not min--',alon(nn),alon(nnp1)
                          nob = nob + 1
                          c_qc(nn)(1:1) = 'P'
                          c_qc(nn)(3:4) = 'II'
                        else
                          write(io8,*)
                          write(io8,*) 'nn is min--',alon(nn),alon(nnp1)
                          nob = iend
                        endif
                      enddo
                    endif
                  endif
c
                  l_ii_pspd_ok = .false.
c
                  l_print = .true.
                  if(l_print) then
                    write(io8,*)
                    write(io8,*) 'Air speed--',airspdp1,
     $                           '--too high in report--',ii
                    write(io8,*) 'AMDAR rep iip1 has wrong sign on lon'
                  endif
c
c                 Go back and recheck flight after printing output
c                 ------------------------------------------------
                  l_retest = .true.
cc
cc               Check if ii manAIREP yielded a too-high speed
cc               (rejects not saved for second flight check)
cc               ---------------------------------------------
c                elseif(l_ii_man_airep.and.(.not.l_iip1_man_airep)) then
cc
c                  c_qc(ii)(1:1) = 'P'
c                  c_qc(ii)(3:4) = 'II'
c
c                  iob = iob + 1
c                  l_ii_pspd_ok = .false.
cc
c                  l_print = .true.
c                  if(l_print) then
c                    write(io8,*)
c                    write(io8,*) 'Air speed--',airspdp1,
c     $                           '--too high in report--',ii
c                    write(io8,*) 'manAIREP ii does not fit'
c                  endif
cc
cc               Check if iip1 manAIREP yielded a too-high speed
cc               (rejects not saved for second flight check)
cc               -----------------------------------------------
c                elseif(l_iip1_man_airep.and.(.not.l_ii_man_airep)) then
cc
c                  c_qc(iip1)(1:1) = 'P'
c                  c_qc(iip1)(3:4) = 'II'
c
c                  l_ii_pspd_ok = .false.
cc
c                  l_print = .false.
c                  if(l_print) then
c                    write(io8,*)
c                    write(io8,*) 'Air speed--',airspdp1,
c     $                           '--too high in report--',ii
c                    write(io8,*) 'manAIREP iip1 does not fit'
c                  endif
c
c               Check valid supersonic manAIREP flights
c               (rejects not saved for second flight check)
c               -------------------------------------------
                elseif(l_ii_man_airep.and.l_iip1_man_airep.and.
     $                 (l_iim1_man_airep.or.l_iip2_man_airep).and.
     $                 (c_acftid(ii)(1:3).eq.'AFR'.or.
     $                  c_acftid(ii)(1:3).eq.'BAW')) then
c
c                 Print but don't reject speeds from 700 to 750 m/s
c                 -------------------------------------------------
                  if((airspdp1.le.750.0.and.
     $                airspd_wo0.ne.amiss.and.
     $                airspd_wop1.ne.amiss.and.
     $                abs(airspd_wo0-airspd_wop1).lt.50.0).or.
     $               (airspd0 .ne.amiss.and.airspd0 .le.750.0.and.
     $                airspdp1.ne.amiss.and.airspdp1.le.750.0.and.
     $                abs(airspd0-airspdp1).lt.50.0).or.
     $               (airspdp1.ne.amiss.and.airspdp1.le.750.0.and.
     $                airspdp2.ne.amiss.and.airspdp2.le.750.0.and.
     $                abs(airspdp1-airspdp2).lt.50.0)) then

                    l_ii_pspd_ok = .true.
c
                    l_print = .true.
                    if(l_print) then
                      write(io8,*)
                      write(io8,*) 'Supersonic air speed--',airspdp1,
     $                             '--too high in report--',ii
                      write(io8,*) 'manAIREP airspeed below 750 m/s ok'
                    endif
c
c                 Check if ii report is bad by other airspeeds
c                 --------------------------------------------
                  elseif((l_iim1_man_airep.and.l_iip2_man_airep.and.
     $                    airspd_wo0.ne.amiss.and.
     $                    airspd_wop1.ne.amiss.and.
     $                    airspd_wo0.lt.2.0*spd_man_thresh.and.
     $                    (airspd_wop1.gt.2.0*spd_man_thresh.or.
     $                     airspd_wop1-airspd_wo0.gt.60.0).and.
     $                    cos((pdir0-pdirp1)*d2r).lt.0.0.and.
     $                    cos((pdirp2-pdir_wo0)*d2r).gt.0.0).or.
     $                   (l_iim1_man_airep.and.
     $                    airspd0.ne.amiss.and.
     $                    airspdp2.eq.amiss.and.
     $                    airspd0.gt.2.0*spd_man_thresh).or.
     $                   (l_iip2_man_airep.and.
     $                    airspdp2.ne.amiss.and.
     $                    airspd_wo0.eq.amiss.and.
     $                    airspd_wop1.ne.amiss.and.
     $                    airspdp2.lt.2.0*spd_man_thresh.and.
     $                    (airspd_wop1.gt.2.0*spd_man_thresh.or.
     $                     airspd_wop1.lt.2.0*spd_man_thresh/3.0))) then
c
                    c_qc(ii)(1:1) = 'P'
                    c_qc(ii)(3:4) = 'II'
c
                    iob = iob + 1
                    l_ii_pspd_ok = .false.
c
                    l_print = .true.
                    if(l_print) then
                      write(io8,*)
                      write(io8,*) 'Supersonic air speed--',airspdp1,
     $                             '--too high in report--',ii
                      write(io8,*) 'manAIREP ii is bad'
                    endif
c
c                 Check if iip1 is bad by other airspeeds
c                 ---------------------------------------
                  elseif((l_iim1_man_airep.and.l_iip2_man_airep.and.
     $                    airspd_wo0.ne.amiss.and.
     $                    airspd_wop1.ne.amiss.and.
     $                    airspd_wop1.lt.2.0*spd_man_thresh.and.
     $                    (airspd_wo0.gt.2.0*spd_man_thresh.or.
     $                     airspd_wo0-airspd_wop1.gt.60.0).and.
     $                    cos((pdirp1-pdirp2   )*d2r).lt.0.0.and.
     $                    cos((pdir0 -pdir_wop1)*d2r).gt.0.0).or.
     $                   (l_iim1_man_airep.and.
     $                    airspd0.ne.amiss.and.
     $                    airspd_wo0.ne.amiss.and.
     $                    airspd_wop1.eq.amiss.and.
     $                    airspd0.lt.2.0*spd_man_thresh.and.
     $                    airspd_wo0.gt.2.0*spd_man_thresh).or.
     $                   (l_iip2_man_airep.and.
     $                    airspd0.eq.amiss.and.
     $                    airspdp2.ne.amiss.and.
     $                    airspdp2.gt.2.0*spd_man_thresh).or.
     $                   (airspd0 .ne.amiss.and.
     $                    airspd0 .lt.2.0*spd_man_thresh.and.
     $                    airspdp1.ne.amiss.and.
     $                    airspdp1.gt.2.0*spd_man_thresh.and.
     $                    airspdp2.ne.amiss.and.
     $                    airspdp2.gt.2.0*spd_man_thresh.and.
     $                    airspd_wo0 .ne.amiss.and.
     $                    airspd_wo0 .lt.2.0*spd_man_thresh.and.
     $                    airspd_wop1.ne.amiss.and.
     $                    airspd_wop1.lt.2.0*spd_man_thresh)) then
c
                    c_qc(iip1)(1:1) = 'P'
                    c_qc(iip1)(3:4) = 'II'
c
                    l_ii_pspd_ok = .false.
c
                    l_print = .true.
                    if(l_print) then
                      write(io8,*)
                      write(io8,*) 'Supersonic air speed--',airspdp1,
     $                             '--too high in report--',ii
                      write(io8,*) 'manAIREP iip1 is bad'
                    endif
c
c                 Check if first report in flight is bad
c                 --------------------------------------
                  elseif(airspd0.eq.amiss.and.
     $                   airspdp2.ne.amiss.and.
     $                   airspd_wop1.ne.amiss.and.
     $                   airspdp2.lt.2.0*spd_man_thresh.and.
     $                   airspd_wop1.lt.2.0*spd_man_thresh.and.
     $                   cos((pdirp1-pdirp2)*d2r).gt.0.0) then
c
                    c_qc(ii)(1:1) = 'P'
                    c_qc(ii)(3:4) = 'II'
c
                    iob = iob + 1
                    l_ii_pspd_ok = .false.
c
                    l_print = .true.
                    if(l_print) then
                      write(io8,*)
                      write(io8,*) 'Supersonic air speed--',airspdp1,
     $                             '--too high in report--',ii
                      write(io8,*) '1st manAIREP is bad'
                    endif
c
c                 Check if last report in flight is bad
c                 -------------------------------------
                  elseif(airspd0.ne.amiss.and.
     $                   airspdp2.eq.amiss.and.
     $                   airspd_wo0.ne.amiss.and.
     $                   airspd0.lt.2.0*spd_man_thresh.and.
     $                   airspd_wo0.lt.2.0*spd_man_thresh.and.
     $                   cos((pdir0-pdirp1)*d2r).gt.0.0) then
c
                    c_qc(iip1)(1:1) = 'P'
                    c_qc(iip1)(3:4) = 'II'
c
                    l_ii_pspd_ok = .false.
c
                    l_print = .true.
                    if(l_print) then
                      write(io8,*)
                      write(io8,*) 'Supersonic air speed--',airspdp1,
     $                             '--too high in report--',ii
                      write(io8,*) 'last manAIREP is bad'
                    endif
c
c                 Handle remaining points
c                 -----------------------
                  else
c
                    c_qc(ii)(1:1) = 'P'
                    c_qc(ii)(3:4) = 'II'
c
                    c_qc(iip1)(1:1) = 'P'
                    c_qc(iip1)(3:4) = 'II'
c
                    iob = iob + 1
                    l_ii_pspd_ok = .false.
c
                    l_print = .true.
                    if(l_print) then
                      write(io8,*)
                      write(io8,*) 'Supersonic air speed--',airspdp1,
     $                             '--too high in report--',ii
                      write(io8,*) 'Uncategorized manAIREP'
                      write(io8,*) 'Rejecting both points'
                    endif
                  endif
c
c               Check flights with time differences greater than 10 min
c               (rejects not saved for second flight check)
c               ----------------------------------------------------------------
c                elseif(l_ii_man_airep.and.l_iip1_man_airep.and.
c     $                 (l_iim1_man_airep.or.l_iip2_man_airep).and.
c     $                 (c_acftid(ii)(1:3).ne.'AFR'.and.
c
                elseif((c_acftid(ii)(1:3).ne.'AFR'.and.
     $                  c_acftid(ii)(1:3).ne.'BAW').and.
     $                 idt_difp1.gt.600) then
c
c                 Print but don't reject speeds from 350 to 375 m/s
c                 -------------------------------------------------
                  if((airspdp1.le.375.0.and.
     $                airspd_wo0.ne.amiss.and.
     $                airspd_wop1.ne.amiss.and.
     $                abs(airspd_wo0-airspd_wop1).lt.50.0).or.
     $               (airspd0 .ne.amiss.and.airspd0 .le.375.0.and.
     $                airspdp1.ne.amiss.and.airspdp1.le.375.0.and.
     $                abs(airspd0-airspdp1).lt.25.0).or.
     $               (airspdp1.ne.amiss.and.airspdp1.le.375.0.and.
     $                airspdp2.ne.amiss.and.airspdp2.le.375.0.and.
     $                abs(airspdp1-airspdp2).lt.25.0)) then

                    l_ii_pspd_ok = .true.
c
                    l_print = .true.
                    if(l_print) then
                      write(io8,*)
                      write(io8,*) 'Air speed--',airspdp1,
     $                             '--too high in report--',ii
                      write(io8,*) 'Airspeed below 375 m/s ok'
                    endif
c
c                 Check if ii report is bad by other airspeeds
c                 --------------------------------------------
c                  elseif((l_iim1_man_airep.and.l_iip2_man_airep.and.
c     $                    airspd_wo0.ne.amiss.and.
c
                  elseif((airspd_wo0.ne.amiss.and.
     $                    airspd_wop1.ne.amiss.and.
     $                    airspd_wo0.lt.spd_man_thresh.and.
     $                    (airspd_wop1.gt.spd_man_thresh.or.
     $                     airspd_wop1-airspd_wo0.gt.60.0).and.
     $                    cos((pdir0-pdirp1)*d2r).lt.0.0.and.
     $                    cos((pdirp2-pdir_wo0)*d2r).gt.0.0).or.
c
c     $                   (l_iim1_man_airep.and.
c
     $                   (airspd0.ne.amiss.and.
     $                    airspdp2.eq.amiss.and.
     $                    airspd0.gt.spd_man_thresh).or.
c
c     $                   (l_iip2_man_airep.and.
c
     $                   (airspdp2.ne.amiss.and.
     $                    airspd_wo0.eq.amiss.and.
     $                    airspd_wop1.ne.amiss.and.
     $                    airspdp2.lt.spd_man_thresh.and.
     $                    (airspd_wop1.gt.spd_man_thresh.or.
     $                     airspd_wop1.lt.spd_man_thresh/3.0))) then
c
                    c_qc(ii)(1:1) = 'P'
                    c_qc(ii)(3:4) = 'II'
c
                    iob = iob + 1
                    l_ii_pspd_ok = .false.
c
                    l_print = .true.
                    if(l_print) then
                      write(io8,*)
                      write(io8,*) 'Air speed--',airspdp1,
     $                             '-- > 350 m/s in report--',ii
                      write(io8,*) 'Report ii is bad'
                    endif
c
c                 Check if iip1 is bad by other airspeeds
c                 ---------------------------------------
c                  elseif((l_iim1_man_airep.and.l_iip2_man_airep.and.
c     $                    airspd_wo0.ne.amiss.and.
c
                  elseif((airspd_wo0.ne.amiss.and.
     $                    airspd_wop1.ne.amiss.and.
     $                    airspd_wop1.lt.spd_man_thresh.and.
     $                    (airspd_wo0.gt.spd_man_thresh.or.
     $                     airspd_wo0-airspd_wop1.gt.60.0).and.
     $                    cos((pdirp1-pdirp2   )*d2r).lt.0.0.and.
     $                    cos((pdir0 -pdir_wop1)*d2r).gt.0.0).or.
c
c     $                   (l_iim1_man_airep.and.
c
     $                   (airspd0.ne.amiss.and.
     $                    airspd_wo0.ne.amiss.and.
     $                    airspd_wop1.eq.amiss.and.
     $                    airspd0.lt.spd_man_thresh.and.
     $                    airspd_wo0.gt.spd_man_thresh).or.
c
c     $                   (l_iip2_man_airep.and.
c
     $                   (airspd0.eq.amiss.and.
     $                    airspdp2.ne.amiss.and.
     $                    airspdp2.gt.spd_man_thresh).or.
     $                   (airspd0 .ne.amiss.and.
     $                    airspd0 .lt.spd_man_thresh.and.
     $                    airspdp1.ne.amiss.and.
     $                    airspdp1.gt.spd_man_thresh.and.
     $                    airspdp2.ne.amiss.and.
     $                    airspdp2.gt.spd_man_thresh.and.
     $                    airspd_wo0 .ne.amiss.and.
     $                    airspd_wo0 .lt.spd_man_thresh.and.
     $                    airspd_wop1.ne.amiss.and.
     $                    airspd_wop1.lt.spd_man_thresh)) then
c
                    c_qc(iip1)(1:1) = 'P'
                    c_qc(iip1)(3:4) = 'II'
c
                    l_ii_pspd_ok = .false.
c
                    l_print = .true.
                    if(l_print) then
                      write(io8,*)
                      write(io8,*) 'Air speed--',airspdp1,
     $                             '-- > 350 m/s in report--',ii
                      write(io8,*) 'Report iip1 is bad'
                    endif
c
c                 Check if first report in flight is bad
c                 --------------------------------------
                  elseif(airspd0.eq.amiss.and.
     $                   airspdp2.ne.amiss.and.
     $                   airspd_wop1.ne.amiss.and.
     $                   airspdp2.lt.spd_man_thresh.and.
     $                   airspd_wop1.lt.spd_man_thresh.and.
     $                   cos((pdirp1-pdirp2)*d2r).gt.0.0) then
c
                    c_qc(ii)(1:1) = 'P'
                    c_qc(ii)(3:4) = 'II'
c
                    iob = iob + 1
                    l_ii_pspd_ok = .false.
c
                    l_print = .true.
                    if(l_print) then
                      write(io8,*)
                      write(io8,*) 'Air speed--',airspdp1,
     $                             '-- > 350 m/s in report--',ii
                      write(io8,*) '1st report is bad'
                    endif
c
c                 Check if last report in flight is bad
c                 -------------------------------------
                  elseif(airspd0.ne.amiss.and.
     $                   airspdp2.eq.amiss.and.
     $                   airspd_wo0.ne.amiss.and.
     $                   airspd0.lt.spd_man_thresh.and.
     $                   airspd_wo0.lt.spd_man_thresh.and.
     $                   cos((pdir0-pdirp1)*d2r).gt.0.0) then
c
                    c_qc(iip1)(1:1) = 'P'
                    c_qc(iip1)(3:4) = 'II'
c
                    l_ii_pspd_ok = .false.
c
                    l_print = .true.
                    if(l_print) then
                      write(io8,*)
                      write(io8,*) 'Air speed--',airspdp1,
     $                             '-- > 350 m/s in report--',ii
                      write(io8,*) 'last report is bad'
                    endif
c
c                 Handle remaining points
c                 -----------------------
                  else
c
                    c_qc(ii)(1:1) = 'P'
                    c_qc(ii)(3:4) = 'II'
c
                    c_qc(iip1)(1:1) = 'P'
                    c_qc(iip1)(3:4) = 'II'
c
                    iob = iob + 1
                    l_ii_pspd_ok = .false.
c
                    l_print = .true.
                    if(l_print) then
                      write(io8,*)
                      write(io8,*) 'Air speed--',airspdp1,
     $                             '-- > 350 m/s in report--',ii
                      write(io8,*) 'Uncategorized report'
                      write(io8,*) 'Rejecting both points'
                    endif
                  endif
c
c               Check for previously undetected stuck clocks
c               (rejects not saved for second flight check)
c               --------------------------------------------
                elseif(idt_difp2.eq.0.and.
     $                 airspd_wo0.ne.amiss.and.
     $                 airspd_wo0.gt.spd_thresh.and.
     $                 airspd_wop1.ne.amiss.and.
     $                 airspd_wop1.gt.spd_thresh.and.
     $                 airspdp2.ne.amiss.and.
     $                 airspdp2.gt.spd_thresh) then
c
                  c_qc(iip1)(2:2) = 'K'
                  ll = ll + 1
                  if(ll.gt.200) then
                    write(io8,*) 'll limit exceeded--indx not saved!',
     $                iip1
                  else
                    indx_save(ll) = iip1
                    knt_bad = knt_bad + 1
                  endif
c
                  c_qc(iip2)(2:2) = 'K'
                  ll = ll + 1
                  if(ll.gt.200) then
                    write(io8,*) 'll limit exceeded--indx not saved!'
     $                ,iip2
                  else
                    indx_save(ll) = iip2
                    knt_bad = knt_bad + 1
                    last_bad = iip2
                    last_bad_m1 = iip1
c                    uwind_last = uwindp2
c                    vwind_last = vwindp2
                    wspd_last = ob_spd(iip2)
                    wdir_last = ob_dir(iip2)
                  endif
c
                  l_ii_pspd_ok = .false.
                  l_stuck = .true.
c
                  l_print = .true.
                  if(l_print) then
                    write(io8,*)
                    write(io8,*) 'Air speed--',airspdp1,
     $                           '--too high in report--',ii
                    write(io8,*) 'iip1, iip2 reports have same time'
                  endif
c
c               Print but don't reject speeds from 525 to 550 m/s
c               -------------------------------------------------
                elseif((airspdp1.le.550.0.and.
     $                  airspd_wo0.ne.amiss.and.
     $                  airspd_wop1.ne.amiss.and.
     $                  abs(airspd_wo0-airspd_wop1).lt.50.0).or.
     $                 (airspd0 .ne.amiss.and.airspd0 .le.550.0.and.
     $                  airspdp1.ne.amiss.and.airspdp1.le.550.0.and.
     $                  abs(airspd0-airspdp1).lt.25.0).or.
     $                 (airspdp1.ne.amiss.and.airspdp1.le.550.0.and.
     $                  airspdp2.ne.amiss.and.airspdp2.le.550.0.and.
     $                  abs(airspdp1-airspdp2).lt.25.0)) then
c
                  l_ii_pspd_ok = .true.
c
                  l_print = .true.
                  if(l_print) then
                    write(io8,*)
                    write(io8,*) 'Air speed--',airspdp1,
     $                           '--too high in report--',ii
                    write(io8,*) 'Airspeed below 550 m/s ok'
                  endif
c
c               Check if ii is problem point by other airspeeds
c               -----------------------------------------------
                elseif((airspd_wo0.ne.amiss.and.
     $                  airspd_wop1.ne.amiss.and.
     $                  airspd_wo0.lt.spd_thresh.and.
     $                  (airspd_wop1.gt.spd_thresh.or.
     $                   airspd_wop1-airspd_wo0.gt.90.0).and.
     $                  cos((pdir0-pdirp1)*d2r).lt.0.0.and.
     $                  cos((pdirp2-pdir_wo0)*d2r).gt.0.0).or.
     $                 (airspd0.ne.amiss.and.
     $                  airspdp2.eq.amiss.and.
     $                  airspd0.gt.spd_thresh).or.
     $                 (airspdp2.ne.amiss.and.
     $                  airspd_wo0.eq.amiss.and.
     $                  airspd_wop1.ne.amiss.and.
     $                  airspdp2.lt.spd_thresh.and.
     $                  (airspd_wop1.gt.spd_thresh.or.
     $                   airspd_wop1.lt.spd_thresh/3.0))) then
c
                  c_qc(ii)(1:1) = 'P'
                  c_qc(ii)(3:4) = 'II'
c
                  ll = ll + 1
                  if(ll.gt.200) then
                    write(io8,*) 'll limit exceeded--indx not saved!',
     $                ii
                  else
                    indx_save(ll) = ii
                    knt_bad = knt_bad + 1
                    last_bad = ii
                    last_bad_m1 = iim1
c                    uwind_last = uwind0
c                    vwind_last = vwind0
                    wspd_last = ob_spd(ii)
                    wdir_last = ob_dir(ii)
                  endif
c
                  iob = iob + 1
                  l_ii_pspd_ok = .false.
c
                  l_print = .true.
                  if(l_print) then
                    write(io8,*)
                    write(io8,*) 'Air speed--',airspdp1,
     $                           '--too high in report--',ii
                    write(io8,*) 'ii is problem point'
                  endif
c
c               Check if iip1 is problem point by other airspeeds
c               -------------------------------------------------
                elseif((airspd_wo0.ne.amiss.and.
     $                  airspd_wop1.ne.amiss.and.
     $                  airspd_wop1.lt.spd_thresh.and.
     $                  (airspd_wo0.gt.spd_thresh.or.
     $                   airspd_wo0-airspd_wop1.gt.90.0).and.
     $                  cos((pdirp1-pdirp2   )*d2r).lt.0.0.and.
     $                  cos((pdir0 -pdir_wop1)*d2r).gt.0.0).or.
     $                 (airspd0.ne.amiss.and.
     $                  airspd_wo0.ne.amiss.and.
     $                  airspd_wop1.eq.amiss.and.
     $                  airspd0.lt.spd_thresh.and.
     $                  airspd_wo0.gt.spd_thresh).or.
     $                 (airspd0.eq.amiss.and.
     $                  airspdp2.ne.amiss.and.
     $                  airspdp2.gt.spd_thresh).or.
     $                 (airspd0 .ne.amiss.and.
     $                  airspd0 .lt.spd_thresh.and.
     $                  airspdp1.ne.amiss.and.
     $                  airspdp1.gt.spd_thresh.and.
     $                  airspdp2.ne.amiss.and.
     $                  airspdp2.gt.spd_thresh.and.
     $                  airspd_wo0 .ne.amiss.and.
     $                  airspd_wo0 .lt.spd_thresh.and.
     $                  airspd_wop1.ne.amiss.and.
     $                  airspd_wop1.lt.spd_thresh)) then
c
                  c_qc(iip1)(1:1) = 'P'
                  c_qc(iip1)(3:4) = 'II'
c
                  ll = ll + 1
                  if(ll.gt.200) then
                    write(io8,*) 'll limit exceeded--indx not saved!',
     $                iip1
                  else
                    indx_save(ll) = iip1
                    knt_bad = knt_bad + 1
                    last_bad = iip1
                    last_bad_m1 = ii
c                    uwind_last = uwindp1
c                    vwind_last = vwindp1
                    wspd_last = ob_spd(iip1)
                    wdir_last = ob_dir(iip1)
                  endif
c
                  l_ii_pspd_ok = .false.
c
                  l_print = .true.
                  if(l_print) then
                    write(io8,*)
                    write(io8,*) 'Air speed--',airspdp1,
     $                           '--too high in report--',ii
                    write(io8,*) 'iip1 is problem point'
                  endif
c
c               Check if first report in flight is bad
c               --------------------------------------
                elseif(airspd0.eq.amiss.and.
     $                 airspdp2.ne.amiss.and.
     $                 airspd_wop1.ne.amiss.and.
     $                 airspdp2.lt.spd_thresh.and.
     $                 airspd_wop1.lt.spd_thresh.and.
     $                 cos((pdirp1-pdirp2)*d2r).gt.0.0) then
c
                  c_qc(ii)(1:1) = 'P'
                  c_qc(ii)(3:4) = 'II'
c
                  iob = iob + 1
                  l_ii_pspd_ok = .false.
c
                  l_print = .true.
                  if(l_print) then
                    write(io8,*)
                    write(io8,*) 'Air speed--',airspdp1,
     $                           '--too high in report--',ii
                    write(io8,*) '1st report is bad'
                  endif
c
c               Check if last report in flight is bad
c               -------------------------------------
                elseif(airspd0.ne.amiss.and.
     $                 airspdp2.eq.amiss.and.
     $                 airspd_wo0.ne.amiss.and.
     $                 airspd0.lt.spd_thresh.and.
     $                 airspd_wo0.lt.spd_thresh.and.
     $                 cos((pdir0-pdirp1)*d2r).gt.0.0) then
c
                  c_qc(iip1)(1:1) = 'P'
                  c_qc(iip1)(3:4) = 'II'
c
                  l_ii_pspd_ok = .false.
c
                  l_print = .true.
                  if(l_print) then
                    write(io8,*)
                    write(io8,*) 'Air speed--',airspdp1,
     $                           '--too high in report--',ii
                    write(io8,*) 'last report is bad'
                  endif
c
c               Check if iip1 and iip2 points are from a different flight
c               ---------------------------------------------------------
                elseif((vspd0 .ne.amiss.and.
     $                  abs(vspd0 ).lt.vspd_thresh*2.0/3.0.and.
     $                  vspdp1.ne.amiss.and.
     $                  abs(vspdp1).gt.vspd_thresh*2.0/3.0.and.
     $                  vspdp2.ne.amiss.and.
     $                  abs(vspdp2).lt.vspd_thresh*2.0/3.0).or.
     $                 (airspd0 .ne.amiss.and.
     $                  airspd0 .lt.spd_thresh.and.
     $                  airspdp1.ne.amiss.and.
     $                  airspdp1.gt.spd_thresh.and.
     $                  airspdp2.ne.amiss.and.
     $                  airspdp2.lt.spd_thresh).or.
     $                 (airspd0 .ne.amiss.and.
     $                  airspd0 .lt.spd_thresh.and.
     $                  airspdp1.ne.amiss.and.
     $                  airspdp1.gt.spd_thresh.and.
     $                  airspdp2.ne.amiss.and.
     $                  airspdp2.gt.spd_thresh.and.
     $                  airspd_wo0 .ne.amiss.and.
     $                  airspd_wo0 .gt.spd_thresh.and.
     $                  airspd_wop1.ne.amiss.and.
     $                  airspd_wop1.gt.spd_thresh)) then
c
                  c_qc(iip1)(1:1) = 'P'
                  c_qc(iip1)(3:4) = 'II'
c
                  ll = ll + 1
                  if(ll.gt.200) then
                    write(io8,*) 'll limit exceeded--indx not saved!'
     $                ,iip1
                  else
                    indx_save(ll) = iip1
                    knt_bad = knt_bad + 1
                  endif
c
                  c_qc(iip2)(1:1) = 'P'
                  c_qc(iip2)(3:4) = 'II'
                  ll = ll + 1
                  if(ll.gt.200) then
                    write(io8,*) 'll limit exceeded--indx not saved!'
     $                ,iip2
                  else
                    indx_save(ll) = iip2
                    knt_bad = knt_bad + 1
                    last_bad = iip2
                    last_bad_m1 = iip1
c                    uwind_last = uwindp2
c                    vwind_last = vwindp2
                    wspd_last = ob_spd(iip2)
                    wdir_last = ob_dir(iip2)
                  endif
c
                  l_ii_pspd_ok = .false.
c
                  l_print = .true.
                  if(l_print) then
                    write(io8,*)
                    write(io8,*) 'Air speed--',airspdp1,
     $                           '--too high in report--',ii
                    write(io8,*) 'iip1 and iip2 reports from new flight'
                  endif
c
c               Check if iip1 is problem point by other airspeeds--clock problem
c               ----------------------------------------------------------------
                elseif(airspd_wo0.ne.amiss.and.
     $                 airspd_wop1.ne.amiss.and.
     $                 airspd_wo0.lt.spd_thresh.and.
     $                 (airspd_wop1.gt.spd_thresh.or.
     $                  airspd_wop1-airspd_wo0.gt.90.0).and.
     $                 airspdp2.gt.spd_thresh.and.
     $                 cos((pdir0-pdirp1)*d2r).gt.0.5.and.
     $                 cos((pdirp2-pdir_wo0)*d2r).gt.0.5) then
c
                  c_qc(iip1)(1:1) = 'P'
                  c_qc(iip1)(3:4) = 'II'
c
                  ll = ll + 1
                  if(ll.gt.200) then
                    write(io8,*) 'll limit exceeded--indx not saved!',
     $                ii
                  else
                    indx_save(ll) = iip1
                    knt_bad = knt_bad + 1
                    last_bad = iip1
                    last_bad_m1 = ii
c                    uwind_last = uwindp1
c                    vwind_last = vwindp1
                    wspd_last = ob_spd(iip1)
                    wdir_last = ob_dir(iip1)
                  endif
c
                  l_ii_pspd_ok = .false.
c
                  l_print = .true.
                  if(l_print) then
                    write(io8,*)
                    write(io8,*) 'Air speed--',airspdp1,
     $                           '--too high in report--',ii
                    write(io8,*) 'iip1 has clock problem'
                  endif
c
c               Handle remaining points
c               -----------------------
                else
c
                  c_qc(ii)(1:1) = 'P'
                  c_qc(ii)(3:4) = 'II'
                  ll = ll + 1
                  if(ll.gt.200) then
                    write(io8,*) 'll limit exceeded--indx not saved!',
     $                ii
                  else
                    indx_save(ll) = ii
                    knt_bad = knt_bad + 1
                  endif
c
                  c_qc(iip1)(1:1) = 'P'
                  c_qc(iip1)(3:4) = 'II'
                  ll = ll + 1
                  if(ll.gt.200) then
                    write(io8,*) 'll limit exceeded--indx not saved!',
     $                iip1
                  else
                    indx_save(ll) = iip1
                    knt_bad = knt_bad + 1
                    last_bad = iip1
                    last_bad_m1 = ii
c                    uwind_last = uwindp1
c                    vwind_last = vwindp1
                    wspd_last = ob_spd(iip1)
                    wdir_last = ob_dir(iip1)
                  endif
c
                  iob = iob + 1
                  l_ii_pspd_ok = .false.
c
                  l_print = .true.
                  if(l_print) then
                    write(io8,*)
                    write(io8,*) 'Air speed--',airspdp1,
     $                           '--too high in report--',ii
                    write(io8,*) 'Uncategorized report'
                    write(io8,*) 'Rejecting both points'
                  endif
                endif
c
c Check for unrealistic vertical speeds between ii and iip1 points
c ----------------------------------------------------------------
              elseif(iip1.ne.0.and.
     $               vspdp1.ne.amiss.and.
     $               (abs(vspdp1).gt.vspd_thresh.or.
     $                (idt_difp1.gt.600.and.
     $                 abs(vspdp1).gt.vspd_thresh*2.0/3.0))) then
c
c               If neighboring points not available, reject both points
c               -------------------------------------------------------
                if(vspd_wo0.eq.amiss.and.vspd_wop1.eq.amiss) then
c
                  c_qc(ii)(1:1) = 'V'
                  if(c_qc(ii)(5:5).eq.'R') then
                    c_qc(ii)(5:5) = 'i'
                  else
                    c_qc(ii)(5:5) = 'I'
                  endif
c
                  ll = ll + 1
                  if(ll.gt.200) then
                    write(io8,*) 'll limit exceeded--indx not saved!',
     $                ii
                  else
                    indx_save(ll) = ii
                    knt_bad = knt_bad + 1
                  endif
c
                  c_qc(iip1)(1:1) = 'V'
                  if(c_qc(iip1)(5:5).eq.'R') then
                    c_qc(iip1)(5:5) = 'i'
                  else
                    c_qc(iip1)(5:5) = 'I'
                  endif
c
                  ll = ll + 1
                  if(ll.gt.200) then
                    write(io8,*) 'll limit exceeded--indx not saved!',
     $                iip1
                  else
                    indx_save(ll) = iip1
                    knt_bad = knt_bad + 1
                    last_bad = iip1
                    last_bad_m1 = ii
c                    uwind_last = uwindp1
c                    vwind_last = vwindp1
                    wspd_last = ob_spd(iip1)
                    wdir_last = ob_dir(iip1)
                  endif
c
                  iob = iob + 1
                  l_ii_pspd_ok = .false.
c
                  l_print = .true.
                  if(l_print) then
                    write(io8,*)
                    write(io8,*) 'Vertical speed--',vspdp1,
     $                           '--too high in report--',ii
                    write(io8,*) 'Rejecting both points'
                  endif
c
c               Check if ii report is a position report
c               (rejects not saved for second flight check)
c               -------------------------------------------
                elseif(idt_difp1.le.60.and.
     $                 ((itype(ii).eq.i_mdcrs.and.
     $                   (itype(iip1).eq.i_mdcrs_asc.or.
     $                    itype(iip1).eq.i_mdcrs_des.or.
     $                    itype(iip1).eq.i_mdcrs_lvl)).or.
     $                  (itype(ii).eq.i_acars.and.
     $                   (itype(iip1).eq.i_acars_asc.or.
     $                    itype(iip1).eq.i_acars_des.or.
     $                    itype(iip1).eq.i_acars_lvl)))) then
c
                  c_qc(ii)(2:2) = 'I'
c
                  iob = iob + 1
                  l_ii_pspd_ok = .false.
c
                  if(c_acftreg(ii)(4:5).eq.'GU'.or.
     $               c_acftreg(ii)(4:5).eq.'WU') then
                    l_print = .false.
                  else
                    l_print = .true.
                  endif
c
                  if(l_print) then
                    write(io8,*)
                    write(io8,*) 'Vertical speed--',vspdp1,
     $                           '--too high in report--',ii
                    write(io8,*) 'Is ii a position report?'
                  endif
c
c               Check if iip1 report is a position report
c               (rejects not saved for second flight check)
c               ---------------------------------------------
                elseif(idt_difp1.le.60.and.
     $                 ((itype(iip1).eq.i_mdcrs.and.
     $                   (itype(ii).eq.i_mdcrs_asc.or.
     $                    itype(ii).eq.i_mdcrs_des.or.
     $                    itype(ii).eq.i_mdcrs_lvl)).or.
     $                  (itype(iip1).eq.i_acars.and.
     $                   (itype(ii).eq.i_acars_asc.or.
     $                    itype(ii).eq.i_acars_des.or.
     $                    itype(ii).eq.i_acars_lvl)))) then
c
                  c_qc(iip1)(2:2) = 'I'
c
                  l_ii_pspd_ok = .false.
c
                  if(c_acftreg(iip1)(4:5).eq.'GU'.or.
     $               c_acftreg(iip1)(4:5).eq.'WU') then
                    l_print = .false.
                  else
                    l_print = .true.
                  endif
c
                  if(l_print) then
                    write(io8,*)
                    write(io8,*) 'Vertical speed--',vspdp1,
     $                           '--too high in report--',ii
                    write(io8,*) 'Is iip1 a position report?'
                  endif
cc
cc               Check if ii manAIREP yielded a too-high speed
cc               ---------------------------------------------
c                elseif(l_ii_man_airep.and.(.not.l_iip1_man_airep)) then
cc
c                  c_qc(ii)(1:1) = 'V'
c                  if(c_qc(ii)(5:5).eq.'R') then
c                    c_qc(ii)(5:5) = 'i'
c                  else
c                    c_qc(ii)(5:5) = 'I'
c                  endif
c                  iob = iob + 1
c                  l_ii_pspd_ok = .false.
cc
c                  l_print = .true.
c                  if(l_print) then
c                    write(io8,*)
c                    write(io8,*) 'Vertical speed--',vspdp1,
c     $                           '--too high in report--',ii
c                    write(io8,*) 'manAIREP ii does not fit'
c                  endif
cc
cc               Check if iip1 manAIREP yielded a too-high speed
cc               -----------------------------------------------
c                elseif(l_iip1_man_airep.and.(.not.l_ii_man_airep)) then
cc
c                  c_qc(iip1)(1:1) = 'V'
c                  if(c_qc(iip1)(5:5).eq.'R') then
c                    c_qc(iip1)(5:5) = 'i'
c                  else
c                    c_qc(iip1)(5:5) = 'I'
c                  endif
c                  l_ii_pspd_ok = .false.
cc
c                  l_print = .true.
c                  if(l_print) then
c                    write(io8,*)
c                    write(io8,*) 'Vertical speed--',vspdp1,
c     $                           '--too high in report--',ii
c                    write(io8,*) 'manAIREP iip1 does not fit'
c                  endif
c
c               Check if iip1 and iip2 points are from a different flight
c               ---------------------------------------------------------
                elseif(vspd0.ne.amiss.and.vspdp2.ne.amiss.and.
     $                 abs(vspd0).lt.vspd_thresh*2.0/3.0.and.
     $                 abs(vspdp2).lt.vspd_thresh*2.0/3.0.and.
     $                 abs(vspd_wo0).gt.vspd_thresh*2.0/3.0.and.
     $                 abs(vspd_wop1).gt.vspd_thresh*2.0/3.0) then
c     $                 abs(vspd_wo0)-abs(vspd0).gt.50.0.and.
c     $                 abs(vspd_wop1)-abs(vspdp2).gt.50.0) then
c
                  c_qc(iip1)(1:1) = 'V'
                  if(c_qc(iip1)(5:5).eq.'R') then
                    c_qc(iip1)(5:5) = 'i'
                  else
                    c_qc(iip1)(5:5) = 'I'
                  endif
                  ll = ll + 1
                  if(ll.gt.200) then
                    write(io8,*) 'll limit exceeded--indx not saved!',
     $                iip1
                  else
                    indx_save(ll) = iip1
                    knt_bad = knt_bad + 1
                  endif
c
                  c_qc(iip2)(1:1) = 'V'
                  if(c_qc(iip2)(5:5).eq.'R') then
                    c_qc(iip2)(5:5) = 'i'
                  else
                    c_qc(iip2)(5:5) = 'I'
                  endif
                  ll = ll + 1
                  if(ll.gt.200) then
                    write(io8,*) 'll limit exceeded--indx not saved!',
     $                iip2
                  else
                    indx_save(ll) = iip2
                    knt_bad = knt_bad + 1
                    last_bad = iip2
                    last_bad_m1 = iip1
c                    uwind_last = uwindp2
c                    vwind_last = vwindp2
                    wspd_last = ob_spd(iip2)
                    wdir_last = ob_dir(iip2)
                  endif
c
                  l_ii_pspd_ok = .false.
c
                  l_print = .true.
                  if(l_print) then
                    write(io8,*)
                    write(io8,*) 'Vertical speed--',vspdp1,
     $                           '--too high in report--',ii
                    write(io8,*) 'iip1 and iip2 reports from new flight'
                  endif
c
c               Check if ii is problem point by other vertical speeds
c               -----------------------------------------------------
                elseif((vspd0.ne.amiss.and.vspdp2.ne.amiss.and.
     $                  vspd_wo0.ne.amiss.and.vspd_wop1.ne.amiss.and.
     $                  abs(vspdp2).lt.vspd_thresh*2.0/3.0.and.
     $                  (abs(vspd0).gt.vspd_thresh*2.0/3.0.or.
     $                   abs(vspd_wop1)-abs(vspd_wo0).gt.50.0)).or.
     $                 (vspd0.ne.amiss.and.vspd_wo0.ne.amiss.and.
     $                  abs(vspd0).gt.vspd_thresh*2.0/3.0.and.
     $                  abs(vspd_wo0).lt.vspd_thresh*2.0/3.0).or.
     $                 (vspdp2.ne.amiss.and.vspd_wop1.ne.amiss.and.
     $                  abs(vspdp2).lt.vspd_thresh*2.0/3.0.and.
     $                  abs(vspd_wop1).gt.vspd_thresh*2.0/3.0)) then
c     $                  abs(vspdp2).lt.vspd_thresh*2.0/3.0.and.
c     $                  (abs(vspd0).gt.vspd_thresh*2.0/3.0.or.
c     $                   abs(abs(vspd_wop1)-abs(vspd_wo0)).gt.50.0)).or.
c     $                 (vspd0.ne.amiss.and.vspd_wo0.ne.amiss.and.
c     $                  (abs(vspd0).gt.vspd_thresh*2.0/3.0.or.
c     $                   abs(abs(vspd0)-abs(vspd_wo0)).gt.50.0)).or.
c     $                 (vspdp2.ne.amiss.and.vspd_wop1.ne.amiss.and.
c     $                  abs(vspdp2).lt.vspd_thresh*2.0/3.0.and.
c     $                  (abs(vspd_wop1).gt.vspd_thresh*2.0/3.0.or.
c     $                   abs(abs(vspd_wop1)-abs(vspdp2)).gt.50.0))) then
c
                  c_qc(ii)(1:1) = 'V'
                  if(c_qc(ii)(5:5).eq.'R') then
                    c_qc(ii)(5:5) = 'i'
                  else
                    c_qc(ii)(5:5) = 'I'
                  endif
                  ll = ll + 1
                  if(ll.gt.200) then
                    write(io8,*) 'll limit exceeded--indx not saved!',
     $                ii
                  else
                    indx_save(ll) = ii
                    knt_bad = knt_bad + 1
                    last_bad = ii
                    last_bad_m1 = iim1
c                    uwind_last = uwind0
c                    vwind_last = vwind0
                    wspd_last = ob_spd(ii)
                    wdir_last = ob_dir(ii)
                  endif
c
                  iob = iob + 1
                  l_ii_pspd_ok = .false.
c
                  l_print = .true.
                  if(l_print) then
                    write(io8,*)
                    write(io8,*) 'Vertical speed--',vspdp1,
     $                           '--too high in report--',ii
                    write(io8,*) 'ii is problem point'
                  endif
c
c               Check if iip1 is problem point by other vertical speeds
c               -------------------------------------------------------
                elseif((vspd0.ne.amiss.and.vspdp2.ne.amiss.and.
     $                  vspd_wo0.ne.amiss.and.vspd_wop1.ne.amiss.and.
     $                  abs(vspd0).lt.vspd_thresh*2.0/3.0.and.
     $                  (abs(vspdp2).gt.vspd_thresh*2.0/3.0.or.
     $                   abs(vspd_wo0)-abs(vspd_wop1).gt.50.0)).or.
     $                 (vspdp2.ne.amiss.and.vspd_wop1.ne.amiss.and.
     $                  (abs(vspdp2).gt.vspd_thresh*2.0/3.0.and.
     $                   abs(vspd_wop1).lt.vspd_thresh*2.0/3.0)).or.
     $                 (vspd0.ne.amiss.and.vspd_wo0.ne.amiss.and.
     $                  abs(vspd0).lt.vspd_thresh*2.0/3.0.and.
     $                  abs(vspd_wo0).gt.vspd_thresh*2.0/3.0)) then
c     $                  abs(vspd0).lt.vspd_thresh*2.0/3.0.and.
c     $                  (abs(vspdp2).gt.vspd_thresh*2.0/3.0.or.
c     $                   abs(abs(vspd_wo0)-abs(vspd_wop1)).gt.50.0)).or.
c     $                 (vspdp2.ne.amiss.and.vspd_wop1.ne.amiss.and.
c     $                  (abs(vspdp2).gt.vspd_thresh*2.0/3.0.or.
c     $                   abs(abs(vspdp2)-abs(vspd_wop1)).gt.50.0)).or.
c     $                 (vspd0.ne.amiss.and.vspd_wo0.ne.amiss.and.
c     $                  abs(vspd0).lt.vspd_thresh*2.0/3.0.and.
c     $                  (abs(vspd_wo0).gt.vspd_thresh*2.0/3.0.or.
c     $                   abs(abs(vspd_wo0)-abs(vspd0)).gt.50.0))) then
c
                  c_qc(iip1)(1:1) = 'V'
                  if(c_qc(iip1)(5:5).eq.'R') then
                    c_qc(iip1)(5:5) = 'i'
                  else
                    c_qc(iip1)(5:5) = 'I'
                  endif
                  ll = ll + 1
                  if(ll.gt.200) then
                    write(io8,*) 'll limit exceeded--indx not saved!',
     $                iip1
                  else
                    indx_save(ll) = iip1
                    knt_bad = knt_bad + 1
                    last_bad = iip1
                    last_bad_m1 = ii
c                    uwind_last = uwindp1
c                    vwind_last = vwindp1
                    wspd_last = ob_spd(iip1)
                    wdir_last = ob_dir(iip1)
                  endif
c
                  l_ii_pspd_ok = .false.
c
                  l_print = .true.
                  if(l_print) then
                    write(io8,*)
                    write(io8,*) 'Vertical speed--',vspdp1,
     $                           '--too high in report--',ii
                    write(io8,*) 'iip1 is problem point'
                  endif
c
c               Handle remaining points
c               -----------------------
                else
c
                  c_qc(ii)(1:1) = 'V'
                  if(c_qc(ii)(5:5).eq.'R') then
                    c_qc(ii)(5:5) = 'i'
                  else
                    c_qc(ii)(5:5) = 'I'
                  endif
c
                  ll = ll + 1
                  if(ll.gt.200) then
                    write(io8,*) 'll limit exceeded--indx not saved!',
     $                ii
                  else
                    indx_save(ll) = ii
                    knt_bad = knt_bad + 1
                  endif
c
                  c_qc(iip1)(1:1) = 'V'
                  if(c_qc(iip1)(5:5).eq.'R') then
                    c_qc(iip1)(5:5) = 'i'
                  else
                    c_qc(iip1)(5:5) = 'I'
                  endif
c
                  ll = ll + 1
                  if(ll.gt.200) then
                    write(io8,*) 'll limit exceeded--indx not saved!',
     $                iip1
                  else
                    indx_save(ll) = iip1
                    knt_bad = knt_bad + 1
                    last_bad = iip1
                    last_bad_m1 = ii
c                    uwind_last = uwindp1
c                    vwind_last = vwindp1
                    wspd_last = ob_spd(iip1)
                    wdir_last = ob_dir(iip1)
                  endif
c
                  iob = iob + 1
                  l_ii_pspd_ok = .false.
c
                  l_print = .true.
                  if(l_print) then
                    write(io8,*)
                    write(io8,*) 'Vertical speed--',vspdp1,
     $                           '--too high in report--',ii
                    write(io8,*) 'Uncategorized report'
                    write(io8,*) 'Rejecting both points'
                  endif
                endif
c
c Check if neighboring points are not available
c If so, skip remaining tests
c ---------------------------------------------------
              elseif(iim1.eq.0.and.iip2.eq.0) then
c
                c_qc(ii)(11:11)   = 'I'
                if(iip1.ne.0) c_qc(iip1)(11:11) = 'I'
                iob = iob + 1
                l_ii_pspd_ok = .false.
c
                l_print = .false.
                if(l_print) then
                  write(io8,*)
                  write(io8,*) 'Neighboring points not available',ii
                endif
c
              elseif(iim2.eq.0.and.iip1.eq.0) then
c
                if(iim1.ne.0) c_qc(iim1)(11:11) = 'I'
                c_qc(ii)(11:11)   = 'I'
                iob = iob + 1
                l_ii_pspd_ok = .false.
c
                l_print = .false.
                if(l_print) then
                  write(io8,*)
                  write(io8,*) 'Neighboring points not available',ii
                endif
c
c Check for anomalous points at the beginnings of ascents
c -------------------------------------------------------
              elseif(iip1.ne.0.and.iip2.ne.0.and.
     $               (iim1.eq.0.or.
     $                (iim1.ne.0.and.idt_dif0.gt.idt_near)).and.
     $               idt_difp2.ne.imiss.and.idt_difp2.le.idt_updn.and.
     $               idt_difp1.ne.imiss.and.idt_difp1.le.idt_updn.and.
     $               ht_ft0.lt.10000.0.and.
     $               abs(ht_difp1).gt.htdif_same/2.0.and.
     $               ht_ft0 .gt.ht_ftp1.and.
     $               ht_ftp1.lt.ht_ftp2) then
c
                if(c_qc(ii)(5:5).eq.'R') then
                  c_qc(ii)(5:5) = 'i'
                else
                  c_qc(ii)(5:5) = 'I'
                endif
                iob = iob + 1
                l_ii_pspd_ok = .false.
c
                l_print = .true.
                if(l_print) then
                  write(io8,*) 
                  write(io8,*) 'Anomalous point before ascent'
                endif
c
c Check for anomalous points at the ends of descents
c --------------------------------------------------
              elseif(iim2.ne.0.and.iim1.ne.0.and.
     $               (iip1.eq.0.or.
     $                (iip1.ne.0.and.idt_difp1.gt.idt_near)).and.
     $               idt_difm1.ne.imiss.and.idt_difm1.le.idt_updn.and.
     $               idt_dif0.ne.imiss.and.idt_dif0.le.idt_updn.and.
     $               ht_ft0.lt.10000.0.and.
     $               abs(ht_dif0).gt.htdif_same/2.0.and.
     $               ht_ftm2.gt.ht_ftm1.and.
     $               ht_ftm1.lt.ht_ft0 ) then
c
                if(c_qc(ii)(5:5).eq.'R') then
                  c_qc(ii)(5:5) = 'i'
                else
                  c_qc(ii)(5:5) = 'I'
                endif
                iob = iob + 1
                l_ii_pspd_ok = .false.
c
                l_print = .false.
                if(l_print) then
                  write(io8,*) 
                  write(io8,*) 'Anomalous point after descent'
                endif
c
c Check for isolated off-track points at beginning of track
c Use ii, iip1, iip2 points          
c ---------------------------------------------------------
              elseif(iip1.ne.0.and.iip2.ne.0.and.
     $               (iim1.eq.0.or.
     $                idt_dif0.eq.imiss.or.
     $                (idt_dif0.ne.imiss.and.
     $                 ((.not.(l_ii_man_airep.and.l_iim1_man_airep).and.
     $                   idt_dif0.gt.idt_near*2).or.
     $                  (l_ii_man_airep.and.l_iim1_man_airep.and.
     $                   idt_dif0.gt.idt_near*4)))).and.
     $               (idt_difp1.ne.imiss.and.
     $                (idt_difp1.le.idt_near*2.or.
     $                 (l_ii_man_airep.and.l_iip1_man_airep.and.
     $                  idt_difp1.le.idt_near*4))).and.
     $               (idt_difp2.ne.imiss.and.
     $                (idt_difp2.le.idt_near*2.or.
     $                 (l_iip1_man_airep.and.l_iip2_man_airep.and.
     $                  idt_difp2.le.idt_near*4))).and.
     $               pdirp1.ne.amiss.and.
     $               pdirp2.ne.amiss.and.
     $               pdirp3.ne.amiss.and.
     $               pdir_wop2.ne.amiss.and.
     $               distp2.gt.50.0.and.
     $               distp3.gt.50.0.and.
     $               distp2.gt.dist_wop2.and.
     $               distp3.gt.dist_wop2.and.
     $               cos((pdirp1-pdirp2)*d2r).lt.0.5.and.
     $               ((cos((pdirp2-pdirp3   )*d2r).lt.-0.5.and.
     $                 cos((pdirp1-pdir_wop2)*d2r).gt.0.5).or.  
c     $                (cos((pdirp2-pdirp3   )*d2r).lt.0.25881904.and.
     $                 cos((pdirp1-pdir_wop2)*d2r).gt.0.70710678)) then  
c
                c_qc(iip2)(1:1) = 'O'
                c_qc(iip2)(3:4) = 'II'
c
                l_ii_pspd_ok = .false.
c
                l_print = .true.
                if(l_print) then
                  write(io8,*) 
                  write(io8,*) 'Isolated off-track pt--iip2 = ',iip2
                endif
c 
              elseif(iip1.ne.0.and.iip2.ne.0.and.
     $               (iim1.eq.0.or.
     $                idt_dif0.eq.imiss.or.
     $                (idt_dif0.ne.imiss.and.
     $                 ((.not.(l_ii_man_airep.and.l_iim1_man_airep).and.
     $                   idt_dif0.gt.idt_near*2).or.
     $                  (l_ii_man_airep.and.l_iim1_man_airep.and.
     $                   idt_dif0.gt.idt_near*4)))).and.
     $               (idt_difp1.ne.imiss.and.
     $                (idt_difp1.le.idt_near*2.or.
     $                 (l_ii_man_airep.and.l_iip1_man_airep.and.
     $                  idt_difp1.le.idt_near*4))).and.
     $               (idt_difp2.ne.imiss.and.
     $                (idt_difp2.le.idt_near*2.or.
     $                 (l_iip1_man_airep.and.l_iip2_man_airep.and.
     $                  idt_difp2.le.idt_near*4))).and.
     $               pdir0 .ne.amiss.and.
     $               pdirp1.ne.amiss.and.
     $               pdirp2.ne.amiss.and.
     $               pdir_wop1.ne.amiss.and.
     $               distp1.gt.50.0.and.
     $               distp2.gt.50.0.and.
     $               distp1.gt.dist_wop1.and.
     $               distp2.gt.dist_wop1.and.
     $               ((cos((pdirp1-pdirp2   )*d2r).lt.-0.5.and.
     $                 cos((pdir0 -pdir_wop1)*d2r).gt.0.5).or.  
c     $                (cos((pdirp1-pdirp2   )*d2r).lt.0.25881904.and.
     $                 cos((pdir0 -pdir_wop1)*d2r).gt.0.70710678)) then
c
                c_qc(iip1)(1:1) = 'O'
                c_qc(iip1)(3:4) = 'II'
c
                l_ii_pspd_ok = .false.
c
                l_print = .true.
                if(l_print) then
                  write(io8,*) 
                  write(io8,*) 'Isolated off-track pt--iip1 = ',iip1
                endif
c
c Check for isolated off-track points in middle of track
c Use iim1, ii, iip1 points
c ------------------------------------------------------
              elseif(iim1.ne.0.and.iip1.ne.0.and.iip2.ne.0.and.
     $               (idt_dif0.ne.imiss.and.
     $                (idt_dif0 .le.idt_near*2.or.
     $                 (l_ii_man_airep.and.l_iim1_man_airep.and.
     $                  idt_dif0 .le.idt_near*4))).and.
     $               (idt_difp1.ne.imiss.and.
     $                (idt_difp1.le.idt_near*2.or.
     $                 (l_ii_man_airep.and.l_iip1_man_airep.and.
     $                  idt_difp1.le.idt_near*4))).and.
     $               pdir0 .ne.amiss.and.
     $               pdirp1.ne.amiss.and.
     $               pdirm1.ne.amiss.and.
     $               pdir_wo0.ne.amiss.and.
     $               dist0.gt.50.0.and.
     $               distp1.gt.50.0.and.
     $               dist0.gt.dist_wo0.and.
     $               distp1.gt.dist_wo0.and.
     $               ((cos((pdir0 -pdirp1  )*d2r).lt.-0.5.and.
     $                 cos((pdirm1-pdir_wo0)*d2r).gt.0.5).or.
c     $                (cos((pdir0 -pdirp1  )*d2r).lt.0.25881904.and.
     $                 cos((pdirm1-pdir_wo0)*d2r).gt.0.70710678)) then  
c
                c_qc(ii)(1:1) = 'O'
                c_qc(ii)(3:4) = 'II'
c
                iob = iob - 1
                l_ii_pspd_ok = .false.
c
                l_print = .true.
                if(l_print) then
                  write(io8,*) 
                  write(io8,*) 'Isolated off-track pt--ii = ',ii
                endif
c
c Increment counters if no errors are found
c -----------------------------------------
              else
                iob = iob + 1
                l_ii_pspd_ok = .false.
              endif
c
c Write reports used in testing if desired
c ----------------------------------------
              if(l_print) then
                write(io8,'(a18,2i6,a18,2i6)')
     $            ' iistart,iiend  = ',iistart,iiend,
     $            ' iifirst,iilast = ',iifirst,iilast
                write(io8,'(''       '',12a10)') 
     $            'iim2','iim1','ii','wo0',
     $            'iip1','wop1','iip2','wop2','iip3',
     $            'bad0','badp1','track'
                write(io8,'(''indices'',3i10,3(10x,i10))') 
     $            iim2,iim1,ii,
     $            iip1,iip2,iip3
                write(io8,'(''dist = '',12f10.2)') 
     $            distm2,distm1,dist0,dist_wo0,
     $            distp1,dist_wop1,distp2,dist_wop2,distp3,
     $            dist_bad0,dist_badp1,dist_track
c                write(io8,'(''udis = '',12f10.2)') 
c     $            udistm2/1000.,udistm1/1000.,udist0/1000.,
c     $            udist_wo0/1000.,udistp1/1000.,udist_wop1/1000.,
c     $            udistp2/1000.,udist_wop2/1000.,udistp3/1000.,
c     $            udist_bad0/1000.,udist_badp1/1000.,udist_track/1000.
c                write(io8,'(''vdis = '',12f10.2)') 
c     $            vdistm2/1000.,vdistm1/1000.,vdist0/1000.,
c     $            vdist_wo0/1000.,vdistp1/1000.,vdist_wop1/1000.,
c     $            vdistp2/1000.,vdist_wop2/1000.,vdistp3/1000.,
c     $            vdist_bad0/1000.,vdist_badp1/1000.,vdist_track/1000.
                write(io8,'(''ht_d = '',12f10.2)') 
     $            ht_difm2,ht_difm1,ht_dif0,ht_dif_wo0,
     $            ht_difp1,ht_dif_wop1,ht_difp2,ht_dif_wop2,ht_difp3,
     $            ht_dif_bad0,ht_dif_badp1,ht_dif_track
c                write(io8,'(''uwnd = '',3f10.2,3(10x,f10.2),)') 
c     $            uwindm2,uwindm1,uwind0,
c     $            uwindp1,uwindp2,uwindp3
c                write(io8,'(''vwnd = '',3f10.2,3(10x,f10.2),)') 
c     $            vwindm2,vwindm1,vwind0,
c     $            vwindp1,vwindp2,vwindp3
c                write(io8,'(''upsp = '',12f10.2)') 
c     $            upspdm2,upspdm1,upspd0,upspd_wo0,
c     $            upspdp1,upspd_wop1,upspdp2,upspd_wop2,upspdp3,
c     $            upspd_bad0,upspd_badp1,upspd_track
c                write(io8,'(''vpsp = '',12f10.2)') 
c     $            vpspdm2,vpspdm1,vpspd0,vpspd_wo0,
c     $            vpspdp1,vpspd_wop1,vpspdp2,vpspd_wop2,vpspdp3,
c     $            vpspd_bad0,vpspd_badp1,vpspd_track
                write(io8,'(''pspd = '',12f10.2)') 
     $            pspdm2,pspdm1,pspd0,pspd_wo0,
     $            pspdp1,pspd_wop1,pspdp2,pspd_wop2,pspdp3,
     $            pspd_bad0,pspd_badp1,pspd_track
                write(io8,'(''pdir = '',12f10.2)') 
     $            pdirm2,pdirm1,pdir0,pdir_wo0,
     $            pdirp1,pdir_wop1,pdirp2,pdir_wop2,pdirp3,
     $            pdir_bad0,pdir_badp1,pdir_track
c                write(io8,'(''uair = '',12f10.2)') 
c     $            uairspdm2,uairspdm1,uairspd0,uairspd_wo0,
c     $            uairspdp1,uairspd_wop1,uairspdp2,uairspd_wop2,
c     $            uairspdp3,uairspd_bad0,uairspd_badp1,uairspd_track
c                write(io8,'(''vair = '',12f10.2)') 
c     $            vairspdm2,vairspdm1,vairspd0,vairspd_wo0,
c     $            vairspdp1,vairspd_wop1,vairspdp2,vairspd_wop2,
c     $            vairspdp3,vairspd_bad0,vairspd_badp1,vairspd_track
                write(io8,'(''aspd = '',12f10.2)') 
     $            airspdm2,airspdm1,airspd0,airspd_wo0,
     $            airspdp1,airspd_wop1,airspdp2,airspd_wop2,airspdp3,
     $            airspd_bad0,airspd_badp1,airspd_track
c                write(io8,'(''adir = '',12f10.2)') 
c     $            airdirm2,airdirm1,airdir0,airdir_wo0,
c     $            airdirp1,airdir_wop1,airdirp2,airdir_wop2,airdirp3,
c     $            airdir_bad0,airdir_badp1,airdir_track
                write(io8,'(''vspd = '',12f10.2)') 
     $            vspdm2,vspdm1,vspd0,vspd_wo0,
     $            vspdp1,vspd_wop1,vspdp2,vspd_wop2,vspdp3,
     $            vspd_bad0,vspd_badp1,vspd_track
c
                if(iim2.ne.0) then
                  write(io8,8002) kk,iim2
     x,            c_insty_ob(itype(iim2))
     x,            c_acftreg(iim2),c_acftid(iim2)
     x,            idt(iim2),alat(iim2),alon(iim2)
     x,            pres(iim2),ht_ft(iim2)
     x,            t_prcn(iim2),ob_t(iim2),xiv_t(iim2),ichk_t(iim2)
     x,            ob_q(iim2),xiv_q(iim2),ichk_q(iim2)
     x,            ob_dir(iim2),xiv_d(iim2),ichk_d(iim2)
     x,            ob_spd(iim2),xiv_s(iim2),ichk_s(iim2)
     x,            c_qc(iim2)
                endif
c
                if(iim1.ne.0) then
                  write(io8,8002) kk,iim1
     x,            c_insty_ob(itype(iim1))
     x,            c_acftreg(iim1),c_acftid(iim1)
     x,            idt(iim1),alat(iim1),alon(iim1)
     x,            pres(iim1),ht_ft(iim1)
     x,            t_prcn(iim1),ob_t(iim1),xiv_t(iim1),ichk_t(iim1)
     x,            ob_q(iim1),xiv_q(iim1),ichk_q(iim1)
     x,            ob_dir(iim1),xiv_d(iim1),ichk_d(iim1)
     x,            ob_spd(iim1),xiv_s(iim1),ichk_s(iim1)
     x,            c_qc(iim1)
                endif
c
                write(io8,8002) kk,ii,c_insty_ob(itype(ii))
     x,            c_acftreg(ii),c_acftid(ii)
     x,            idt(ii),alat(ii),alon(ii)
     x,            pres(ii),ht_ft(ii)
     x,            t_prcn(ii),ob_t(ii),xiv_t(ii),ichk_t(ii)
     x,            ob_q(ii),xiv_q(ii),ichk_q(ii)
     x,            ob_dir(ii),xiv_d(ii),ichk_d(ii)
     x,            ob_spd(ii),xiv_s(ii),ichk_s(ii)
     x,            c_qc(ii)
c
                if(iip1.ne.0) then
                  write(io8,8002) kk,iip1
     x,            c_insty_ob(itype(iip1))
     x,            c_acftreg(iip1),c_acftid(iip1)
     x,            idt(iip1),alat(iip1),alon(iip1)
     x,            pres(iip1),ht_ft(iip1)
     x,            t_prcn(iip1),ob_t(iip1),xiv_t(iip1),ichk_t(iip1)
     x,            ob_q(iip1),xiv_q(iip1),ichk_q(iip1)
     x,            ob_dir(iip1),xiv_d(iip1),ichk_d(iip1)
     x,            ob_spd(iip1),xiv_s(iip1),ichk_s(iip1)
     x,            c_qc(iip1)
                endif
c
                if(iip2.ne.0) then
                  write(io8,8002) kk,iip2
     x,            c_insty_ob(itype(iip2))
     x,            c_acftreg(iip2),c_acftid(iip2)
     x,            idt(iip2),alat(iip2),alon(iip2)
     x,            pres(iip2),ht_ft(iip2)
     x,            t_prcn(iip2),ob_t(iip2),xiv_t(iip2),ichk_t(iip2)
     x,            ob_q(iip2),xiv_q(iip2),ichk_q(iip2)
     x,            ob_dir(iip2),xiv_d(iip2),ichk_d(iip2)
     x,            ob_spd(iip2),xiv_s(iip2),ichk_s(iip2)
     x,            c_qc(iip2)
                endif
c
 8002           format(i4,1x,i6,1x,a8,1x,a8,1x,a9,1x,i7,1x,2f11.5,1x
     x,            f8.1,1x,f7.0
     x,            1x,f5.2,4(2(1x,f8.2),1x,i5),1x,'!',a11,'!')
              endif
c
c             Retest flight if specified
c             --------------------------
              if(l_retest) goto 5500
c
            endif
          enddo
c
c If second flight found, save indices
c Don't save indices for stuck clock segments
c Don't redo check
c -------------------------------------------
          ii = indx(istart)
c
          if(knt_bad.gt.3.and.
     $       .not.l_stuck.and.
     $       c_acftid(ii)(9:9).ne.'z') then
c
            write(io8,*)
            write(io8,*) 'Second flight found--',knt_bad,'--reports'
c
c           Consolidate first flight
c           ------------------------
            ll = 0
            keep = istart-1
c
            do iob=istart,iend
              ii = indx(iob)
c
c             If report rejected...
c             ---------------------
              if(c_qc(ii)(3:4).eq.'II'.or.
     $           c_qc(ii)(5:5).eq.'I'.or.
     $           c_qc(ii)(5:5).eq.'i') then
c
c                write(io8,*) 'Skipping report from 2nd flt',ii
                ll = ll + 1
                indx_save(ll) = ii
c
c             If report not rejected...
c             -------------------------
              else
c                write(io8,*) 'Keeping report from 2nd flt',ii
                keep = keep + 1
                indx(keep) = indx(iob)
c
              endif
            enddo
c
c           Save second flight
c           ------------------
            istart = keep + 1
            knt_bad = ll
            do ll=1,knt_bad
c
              if(keep.gt.iend) then
                write(io8,*)
                write(io8,*) 'Keep exceeds iend!'
c
              else                      
c                write(io8,*) 'Saving report from 2nd flt',
c     $            indx_save(ll)
                keep = keep + 1
                indx(keep) = indx_save(ll)
                ii = indx(keep)
                c_acftid(ii)(9:9) = 'z'
              endif
            enddo
c
c           Compute length of second flight
c           -------------------------------
            ii = indx_save(1)
            iip1 = indx_save(knt_bad)
            dist_2ndflt = gcirc_qc(alat(ii  ),alon(ii  ),
     $                             alat(iip1),alon(iip1))
c
            write(io8,*) 'Second flight is ',dist_2ndflt,' m long'      !!! units fixed
c
c           Save second flight only if it is long enough
c           --------------------------------------------
            if(dist_2ndflt.gt.100 000.0.and.
! vvvvvDAK-future change perhaps to account for incr. lat/lon precision
     $         alat(ii).ne.0.0.and.
     $         alat(iip1).ne.0.0) then
! ^^^^ DAK-future change perhaps to account for incr. lat/lon precision
c
              write(io8,*) 'Re-testing second flight'
              write(io8,*)
c
              do ll=1,knt_bad
                ii = indx_save(ll)
c
c               Reset QC flags
c               --------------
                if(c_qc(ii)(3:4).eq.'II') then
                  c_qc(ii)(1:1) = '2'
                  c_qc(ii)(3:4) = '..'
c
                elseif(c_qc(ii)(5:5).eq.'I') then
                  c_qc(ii)(1:1) = '2'
                  c_qc(ii)(5:5) = '.'
c
                elseif(c_qc(ii)(5:5).eq.'i') then
                  c_qc(ii)(1:1) = '2'
                  c_qc(ii)(5:5) = 'R'
                endif
c
              enddo
c
c             Reset flight parameters for old flight
c             --------------------------------------
              ntot_flt(kk) = ntot_flt(kk) - knt_bad
c
c             Go back and re-check flight
c             ---------------------------
              goto 5500
c
c           Reset 9th character if second flight not saved
c           ----------------------------------------------
            else
              do ll=1,knt_bad
                ii = indx_save(ll)
                c_acftid(ii)(9:9) = ' '
              enddo
c
            endif
          endif
c
c Perform second scan to check for odd manuevers
c ----------------------------------------------
          iob = istart
c
          knt_iob = 1
          iob_sav = 0
c
          knt_iip1_bad = 0
c
c Loop over reports for current flight
c ------------------------------------
          do while(iob.le.iend)
            l_print = .false.
c
            knt0 = iob
            ii = indx(iob)
c
            if(iob.eq.iob_sav) then
              knt_iob = knt_iob + 1
            else
              iob_sav = iob
              knt_iob = 1
            endif
c
            if(knt_iob.gt.75) then
              write(io8,*)
              write(io8,*) 'Too many reps with the same iob',iob
              write(io8,*) '  Sorted index ii = ',ii
              write(io8,*) '  Number of reps = ',knt_iob
              iob = iob + 1
              knt_iip1_bad = 0
              iob_sav = iob
              knt_iob = 1
c
c            elseif(knt_iob.gt.10) then
c              write(io8,*)
c              write(io8,*) 'More than 10 reps with same iob',iob
c              write(io8,*) 'knt_iob = ',knt_iob
c              write(io8,'(a18,2i6,a18,2i6)')
c     $          ' iistart,iiend  = ',iistart,iiend,
c     $          ' iifirst,iilast = ',iifirst,iilast
c              write(io8,'(7x,12a10)') 
c     $          'iim2','iim1','ii','wo0',
c     $          'iip1','wop1','iip2','wop2','iip3',
c     $          'bad0','badp1','track'
c              write(io8,'(''indices'',3i10,3(10x,i10))') 
c     $          iim2,iim1,ii,
c     $          iip1,iip2,iip3
c              write(io8,'(''dist = '',12f10.2)') 
c     $          distm2,distm1,dist0,dist_wo0,
c     $          distp1,dist_wop1,distp2,dist_wop2,distp3,
c     $          dist_bad0,dist_badp1,dist_track
c              write(io8,'(''ht_d = '',12f10.2)') 
c     $          ht_difm2,ht_difm1,ht_dif0,ht_dif_wo0,
c     $          ht_difp1,ht_dif_wop1,ht_difp2,ht_dif_wop2,ht_difp3,
c     $          ht_dif_bad0,ht_dif_badp1,ht_dif_track
c              write(io8,'(''pspd = '',12f10.2)') 
c     $          pspdm2,pspdm1,pspd0,pspd_wo0,
c     $          pspdp1,pspd_wop1,pspdp2,pspd_wop2,pspdp3,
c     $          pspd_bad0,pspd_badp1,pspd_track
c              write(io8,'(''pdir = '',12f10.2)') 
c     $          pdirm2,pdirm1,pdir0,pdir_wo0,
c     $          pdirp1,pdir_wop1,pdirp2,pdir_wop2,pdirp3,
c     $          pdir_bad0,pdir_badp1,pdir_track
c
c              if(iim2.ne.0) then
c                write(io8,8002) kk,iim2
c     x,            c_insty_ob(itype(iim2))
c     x,            c_acftreg(iim2),c_acftid(iim2)
c     x,            idt(iim2),alat(iim2),alon(iim2)
c     x,            pres(iim2),ht_ft(iim2)
c     x,            t_prcn(iim2),ob_t(iim2),xiv_t(iim2),ichk_t(iim2)
c     x,            ob_q(iim2),xiv_q(iim2),ichk_q(iim2)
c     x,            ob_dir(iim2),xiv_d(iim2),ichk_d(iim2)
c     x,            ob_spd(iim2),xiv_s(iim2),ichk_s(iim2)
c     x,            c_qc(iim2)
c              endif
c
c              if(iim1.ne.0) then
c                write(io8,8002) kk,iim1
c     x,            c_insty_ob(itype(iim1))
c     x,            c_acftreg(iim1),c_acftid(iim1)
c     x,            idt(iim1),alat(iim1),alon(iim1)
c     x,            pres(iim1),ht_ft(iim1)
c     x,            t_prcn(iim1),ob_t(iim1),xiv_t(iim1),ichk_t(iim1)
c     x,            ob_q(iim1),xiv_q(iim1),ichk_q(iim1)
c     x,            ob_dir(iim1),xiv_d(iim1),ichk_d(iim1)
c     x,            ob_spd(iim1),xiv_s(iim1),ichk_s(iim1)
c     x,            c_qc(iim1)
c              endif
cc
c              write(io8,8002) kk,ii,c_insty_ob(itype(ii))
c     x,            c_acftreg(ii),c_acftid(ii)
c     x,            idt(ii),alat(ii),alon(ii)
c     x,            pres(ii),ht_ft(ii)
c     x,            t_prcn(ii),ob_t(ii),xiv_t(ii),ichk_t(ii)
c     x,            ob_q(ii),xiv_q(ii),ichk_q(ii)
c     x,            ob_dir(ii),xiv_d(ii),ichk_d(ii)
c     x,            ob_spd(ii),xiv_s(ii),ichk_s(ii)
c     x,            c_qc(ii)
cc
c              if(iip1.ne.0) then
c                write(io8,8002) kk,iip1
c     x,            c_insty_ob(itype(iip1))
c     x,            c_acftreg(iip1),c_acftid(iip1)
c     x,            idt(iip1),alat(iip1),alon(iip1)
c     x,            pres(iip1),ht_ft(iip1)
c     x,            t_prcn(iip1),ob_t(iip1),xiv_t(iip1),ichk_t(iip1)
c     x,            ob_q(iip1),xiv_q(iip1),ichk_q(iip1)
c     x,            ob_dir(iip1),xiv_d(iip1),ichk_d(iip1)
c     x,            ob_spd(iip1),xiv_s(iip1),ichk_s(iip1)
c     x,            c_qc(iip1)
c              endif
cc
c              if(iip2.ne.0) then
c                write(io8,8002) kk,iip2
c     x,            c_insty_ob(itype(iip2))
c     x,            c_acftreg(iip2),c_acftid(iip2)
c     x,            idt(iip2),alat(iip2),alon(iip2)
c     x,            pres(iip2),ht_ft(iip2)
c     x,            t_prcn(iip2),ob_t(iip2),xiv_t(iip2),ichk_t(iip2)
c     x,            ob_q(iip2),xiv_q(iip2),ichk_q(iip2)
c     x,            ob_dir(iip2),xiv_d(iip2),ichk_d(iip2)
c     x,            ob_spd(iip2),xiv_s(iip2),ichk_s(iip2)
c     x,            c_qc(iip2)
c              endif
c
            endif
c
c           Go to next report if ii index is invalid
c           ----------------------------------------
            if(c_qc(ii)(1:1).eq.'d'.or.
     $         c_qc(ii)(2:2).eq.'I'.or.
     $         c_qc(ii)(2:2).eq.'K'.or.
     $         c_qc(ii)(3:4).eq.'II'.or.
     $         c_qc(ii)(5:5).eq.'I'.or.
     $         c_qc(ii)(5:5).eq.'i'.or.
     $         c_qc(ii)(11:11).eq.'I') then
c
              iob = iob + 1
              knt_iip1_bad = 0
c
              l_print = .false.
              if(l_print) then
                write(io8,*) 'Index invalid: ii = ',ii
              endif
c
c           Check out ordering etc for valid indices
c           ----------------------------------------
            else
c
c             Compute ii-1 index
c             if(iob.gt.istart)   iim1 = indx(iob-1)
c             --------------------------------------
              iim1 = 0
              knt1 = iob - 1
111           if(knt1.ge.istart) then
                iim1 = indx(knt1)
                if(c_qc(iim1)(1:1).eq.'d'.or.
     $             c_qc(iim1)(2:2).eq.'I'.or.
     $             c_qc(iim1)(2:2).eq.'K'.or.
     $             c_qc(iim1)(3:4).eq.'II'.or.
     $             c_qc(iim1)(5:5).eq.'I'.or.
     $             c_qc(iim1)(5:5).eq.'i'.or.
     $             c_qc(ii)(11:11).eq.'I') then
                  knt1 = knt1 - 1
                  goto 111
                endif
              else
                iim1 = 0
              endif
c
c             Compute ii-2 index
c             if(iob.gt.istart+1) iim2 = indx(iob-2)
c             --------------------------------------
              iim2 = 0
              knt2 = knt1 - 1
121           if(knt2.ge.istart) then
                iim2 = indx(knt2)
                if(c_qc(iim2)(1:1).eq.'d'.or.
     $             c_qc(iim2)(2:2).eq.'I'.or.
     $             c_qc(iim2)(2:2).eq.'K'.or.
     $             c_qc(iim2)(3:4).eq.'II'.or.
     $             c_qc(iim2)(5:5).eq.'I'.or.
     $             c_qc(iim2)(5:5).eq.'i'.or.
     $             c_qc(ii)(11:11).eq.'I') then
                  knt2 = knt2 - 1
                  goto 121
                endif
              else
                iim2 = 0
              endif
c
c             Compute ii-3 index
c             if(iob.gt.istart+2) iim3 = indx(iob-3)
c             --------------------------------------
              iim3 = 0
              knt5 = knt2 - 1
131           if(knt5.ge.istart) then
                iim3 = indx(knt5)
                if(c_qc(iim3)(1:1).eq.'d'.or.
     $             c_qc(iim3)(2:2).eq.'I'.or.
     $             c_qc(iim3)(2:2).eq.'K'.or.
     $             c_qc(iim3)(3:4).eq.'II'.or.
     $             c_qc(iim3)(5:5).eq.'I'.or.
     $             c_qc(iim3)(5:5).eq.'i'.or.
     $             c_qc(ii)(11:11).eq.'I') then
                  knt5 = knt5 - 1
                  goto 131
                endif
              else
                iim3 = 0
              endif
c
c             Compute ii+1 index
c             if(iob.lt.iend)   iip1 = indx(iob+1)
c             ------------------------------------
              iip1 = 0
              iobp1 = 0
              knt3 = iob + 1
141           if(knt3.le.iend) then
                iip1 = indx(knt3)
                iobp1 = knt3
                if(c_qc(iip1)(1:1).eq.'d'.or.
     $             c_qc(iip1)(2:2).eq.'I'.or.
     $             c_qc(iip1)(2:2).eq.'K'.or.
     $             c_qc(iip1)(3:4).eq.'II'.or.
     $             c_qc(iip1)(5:5).eq.'I'.or.
     $             c_qc(iip1)(5:5).eq.'i'.or.
     $             c_qc(ii)(11:11).eq.'I') then
                  knt3 = knt3 + 1
                  goto 141
                endif
              else
                iip1 = 0
                iobp1 = 0
              endif
c
c             Compute ii+2 index
c             if(iob.lt.iend-1) iip2 = indx(iob+2)
c             ------------------------------------
              iip2 = 0
              iobp2 = 0
              knt4 = knt3 + 1
151           if(knt4.le.iend) then
                iip2 = indx(knt4)
                iobp2 = knt4
                if(c_qc(iip2)(1:1).eq.'d'.or.
     $             c_qc(iip2)(2:2).eq.'I'.or.
     $             c_qc(iip2)(2:2).eq.'K'.or.
     $             c_qc(iip2)(3:4).eq.'II'.or.
     $             c_qc(iip2)(5:5).eq.'I'.or.
     $             c_qc(iip2)(5:5).eq.'i'.or.
     $             c_qc(ii)(11:11).eq.'I') then
                  knt4 = knt4 + 1
                  goto 151
                endif
              else
                iip2 = 0
                iobp2 = 0
              endif
c
c             Compute ii+3 index
c             if(iob.lt.iend-2) iip3 = indx(iob+3)
c             ------------------------------------
              iip3 = 0
              knt6 = knt4 + 1
161           if(knt6.le.iend) then
                iip3 = indx(knt6)
                if(c_qc(iip3)(1:1).eq.'d'.or.
     $             c_qc(iip3)(2:2).eq.'I'.or.
     $             c_qc(iip3)(2:2).eq.'K'.or.
     $             c_qc(iip3)(3:4).eq.'II'.or.
     $             c_qc(iip3)(5:5).eq.'I'.or.
     $             c_qc(iip3)(5:5).eq.'i'.or.
     $             c_qc(ii)(11:11).eq.'I') then
                  knt6 = knt6 + 1
                  goto 161
                endif
              else
                iip3 = 0
              endif
c
c             Determine if reports are manual AIREPs
c             --------------------------------------
              l_ii_man_airep = .false.
              if(itype(ii).eq.i_man_airep.or.
     $           itype(ii).eq.i_man_Yairep) l_ii_man_airep = .true.
c 
              l_iim1_man_airep = .false.
              if(iim1.ne.0) then
               if(itype(iim1).eq.i_man_airep.or.
     $            itype(iim1).eq.i_man_Yairep) l_iim1_man_airep = .true.
              en