#!/bin/csh -fx
# ------------------------------
#SBATCH --account=g0613
#SBATCH --constraint=hasw
#SBATCH --ntasks=96
#SBATCH --ntasks-per-node=24
#
#SBATCH --job-name=atm_ens_osens
#SBATCH --output=atm_ens_osens.log.o%j
#SBATCH --time=6:00:00
#PBS -N atm_ens_osens
#PBS -o atm_ens_osens.log.o%j
#_PBS -l select=1:ncpus=24
#PBS -l walltime=6:00:00
##PBS -l mem=4gb
#PBS -S /bin/csh
#PBS -j eo
# ------------------------------
#    This should be placed in   
# the asens directory of FVHOME
# ------------------------------
#
# fvDAS driver script.
#
# This file has been automatically generated by fvsetup.
#
# fvDAS v5_7_1 setup on Wed Sep 28 13:35:13 EDT 2011 by rtodling.


#--------------------------------------------------------------------
 set myname = `basename $0`

# Source Run Time Environment settings
# ------------------------------------
  setenv EXPID   x0026   # experiment ID
  setenv FVHOME  /discover/nobackup/$user/$EXPID   # experiment home directory
  if (-e $FVHOME/run/FVDAS_Run_Config) source $FVHOME/run/FVDAS_Run_Config
# tell which side of the machine we are on ...
  uname -a

  env

#
#                 ----------------------------------
#                  PART I - Prepare the Environment
#                 ----------------------------------

# Experiment environment
# ----------------------
# setenv JOBGEN_QOS advda
  setenv JOBGEN_CONSTRAINT hasw
  setenv GID g0613
  setenv group_list "SBATCH -A $GID"
  setenv ARCH `uname -s`
  setenv HOST `uname -n`
  setenv CASE    $EXPID  # experiment ID (for LSM's sake)
  setenv FVROOT  `cat $FVHOME/.FVROOT`
  setenv FVRUN   $FVHOME/run
  setenv BIGNAME `echo "$EXPID" | tr -s '[:lower:]' '[:upper:]'`

  cd $FVHOME/asens
  set lstcases = `/bin/ls -1 standalone_aensosens.*`
  if ( $status ) then
    echo $myname": no standalone AOSENS date/time specifed, aborting ..."
    exit 1
  else
     set anymd = `echo $lstcases[1] | cut -d. -f2 | cut -c1-8`
     set ahh   = `echo $lstcases[1] | cut -d. -f2 | cut -c10-11`
     set anhms = ${ahh}0000
     set ayyyymmddhh = ${anymd}${ahh}
  endif

  if( (`uname -s` == "Linux") ) then
      if( `uname -m` != "ia64" ) then
         setenv FORT90L -Wl,-T
      endif
      setenv FVWORK /discover/nobackup/projects/gmao/obsdev/$user/ensosenswork_${ayyyymmddhh}.$BIGNAME
      if ($?kidwork) then  # this case, overwrite FVWORK with user-specific
         setenv FVWORK $kidwork
      endif
  endif
  /bin/mkdir -p $FVWORK            # create working directory
  echo $FVWORK >! $FVHOME/.ENSOSENSWORK  # record working directory

  setenv FVBCS $FVHOME/fvInput
  setenv EXTDATA $FVWORK/ExtData  # External data directory
  /bin/mkdir -p $EXTDATA
  /bin/touch $EXTDATA/.no_archiving
  /bin/rm -f $EXTDATA/g5chem
  /bin/ln -s /discover/nobackup/projects/gmao/share/gmao_ops/fvInput_4dvar/g5chem $EXTDATA/
  /bin/rm -f $EXTDATA/g5gcm
  /bin/ln -s /discover/nobackup/projects/gmao/share/gmao_ops/fvInput_4dvar/g5gcm $EXTDATA/
  /bin/rm -f $EXTDATA/PIESA
  /bin/ln -s /discover/nobackup/projects/gmao/share/gmao_ops/fvInput_4dvar/PIESA $EXTDATA/
  /bin/rm -f $EXTDATA/MERRA2
  /bin/ln -s /discover/nobackup/projects/gmao/share/gmao_ops/fvInput_4dvar/MERRA2 $EXTDATA/
  /bin/rm -f $EXTDATA/AeroCom
  /bin/ln -s /discover/nobackup/projects/gmao/share/gmao_ops/fvInput_4dvar/AeroCom $EXTDATA/
  /bin/rm -f $EXTDATA/enAdas
  /bin/ln -s /discover/nobackup/projects/gmao/share/gmao_ops/fvInput_4dvar/enAdas $EXTDATA/

# Load BASEDIR and modules
# ------------------------
  source $FVROOT/bin/g5_modules

# Add FVROOT/bin to front of path so fvDAS binaries are found first
# -----------------------------------------------------------------
  if ( `uname -s` == "Linux" ) then
    set path = ( . $FVHOME/run $FVROOT/bin /share/dasilva/opengrads/Contents $BASEDIR/$ARCH/bin $path )
  else
    set path = ( . $FVHOME/run $FVROOT/bin /share/dasilva/opengrads/Contents $path )
  endif

# setenv BERROR $FVHOME/run
  if ( -e $FVHOME/run/atmens/mkiau.rc.tmpl ) then
     set IAUX = `which mkiau.x`
  else
     set IAUX = `which makeiau.x`
  endif
  set ANAX    = `which GSIsa.x`
  set SACX    = `which sac.x`

# The following are from OPS parallel
  setenv I_MPI_FABRICS shm:dapl
  setenv I_MPI_FABRICS_LIST "dapl,ofa"
  setenv I_MPI_FALLBACK "enable"
  setenv I_MPI_MPD_RSH sshmpi
  setenv I_MPI_DAPL_CHECK_MAX_RDMA_SIZE 1
#
  setenv DAPL_UCM_CQ_SIZE 4096
  setenv DAPL_UCM_QP_SIZE 4096
  setenv I_MPI_DAPL_UD_SEND_BUFFER_NUM 4096
  setenv I_MPI_DAPL_UD_RECV_BUFFER_NUM 4096
  setenv I_MPI_DAPL_UD_ACK_SEND_POOL_SIZE 4096
  setenv I_MPI_DAPL_UD_ACK_RECV_POOL_SIZE 4096
  setenv I_MPI_DAPL_UD_RNDV_EP_NUM 2
  setenv I_MPI_DAPL_UD_REQ_EVD_SIZE 2000
  setenv DAPL_UCM_REP_TIME 2000
  setenv DAPL_UCM_RTU_TIME 2000
  setenv DAPL_UCM_RETRY 7
  setenv DAPL_ACK_RETRY 7
  setenv DAPL_ACK_TIMER 20
  setenv DAPL_UCM_RETRY 10
  setenv DAPL_ACK_RETRY 10

# For reproducibility between Westmere and Sandybridge nodes
# ----------------------------------------------------------
  setenv MV2_USE_SHMEM_ALLREDUCE 0
  setenv MV2_ON_DEMAND_THRESHOLD 8192
  setenv MKL_CBWR SSE4_2
 
# set HDF2RSX = `which hdf2rs.x`
# Regular DAS env vars
# --------------------
  setenv TIMEINC 360      # analysis frequency in minutes (script not general enough for this to be anything)
  setenv ASYNBKG 180      # background frequency in minutes (script not general enough for this to be anything)
  setenv VAROFFSET 180    # abs value of time off from 1st synoptic hour of var window
  setenv NCSUFFIX nc4
  setenv NCEPINPUT $FVBCS
  setenv VAROFFSET 180    # abs value of time off from 1st synoptic hour of var window
  setenv SPECRES    62    # should be able to revisit analyzer to avoid needing this

  setenv GAAS_ANA 1

# Run-time mpi-related options
# ----------------------------
  setenv DAPL_ACK_RETRY 7
  setenv DAPL_ACK_TIMER 20
  setenv DAPL_RNR_RETRY 7
  setenv DAPL_RNR_TIMER 28
  setenv I_MPI_MPD_TMPDIR /tmp
  setenv I_MPI_USE_DYNAMIC_CONNECTIONS 0
  setenv I_MPI_JOB_STARTUP_TIMEOUT 10000
  setenv I_MPI_RDMA_RNDV_WRITE 1

# MVAPICH variables
# -----------------
  setenv MPI_COLL_REPRODUCIBLE
  setenv SLURM_DISTRIBUTION block
  setenv MPI_DISPLAY_SETTINGS

# For some reason, PMI_RANK is randomly set and interferes
# with binarytile.x and other executables.
  unsetenv PMI_RANK

  setenv MPI_COMM_MAX  1024
  setenv MPI_GROUP_MAX 1024
  setenv MPI_BUFS_PER_PROC 256

# Internal parameters controlling system behavior
# ----------------------------------------------
  source $FVHOME/run/atmens/AtmEnsConfig.csh

  if ( !($?ATMENS_BATCHSUB) ) then
     echo "atm_ens_osens.j: missing batch sub command"
     exit (1)
  endif

  if ( $?BERROR_FROMENS ) then
     unsetenv BERROR_FROMENS
  endif
  setenv HYBRIDGSI     $FVWORK
  setenv STAGE4HYBGSI  $FVWORK
  setenv  DO_ATM_ENS    1

# Use central forecasts verifying against central assimilation/analysis (DEFAULT)
#   setenv ATMENS_FSO_AVRFY 0
#   setenv ATMENS_FSO_MFCST 0
# Use ensemble mean forecasts verifying against non-inflated ensemble mean analysis
#   setenv ATMENS_FSO_JGRAD 1
#   setenv ATMENS_FSO_FSENS 1
#   setenv ATMENS_FSO_AVRFY 1
#   setenv ATMENS_FSO_MFCST 1
# Use ensemble mean forecasts verifying against inflated ensemble mean analysis
    setenv ATMENS_FSO_JGRAD 1
    setenv ATMENS_FSO_FSENS 0
    setenv ATMENS_FSO_AVRFY 1
    setenv ATMENS_FSO_MFCST 1
# Use adjoint-based forecast sensitivty (verification irrelevant)
#   setenv ATMENS_FSO_AVRFY 1
#   setenv ATMENS_FSO_MFCST 2

  # if changing ftau ... need change enkf.nml too
  set ftau = `nmlread.py $ATMENSETC/atmos_enkf_sens.nml.tmpl nam_enkf evalft`
# set aver = asm
  set aver = ana
  set prog = prg

  touch $ATMENSLOC/.no_archiving
  if ( $?eanaonly ) then
  endif
         #    The following set specific pieces separately
         #    Note: FVWORK better be defined by hand 
         #    ---------------------------------------------
         if ( $?eanaonly ) then
            setenv  RUN_EFSO_SET  1
            setenv  RUN_EAANA     1
         else
            setenv  RUN_EFSO_SET  0
            setenv  RUN_EAANA     0
         endif
         setenv  RUN_PEFSO      0
         setenv  RUN_ARCHATMENS 0
  # To trigger ensemble-only set following dates to anything but 0 (as yyyymmddhh)
  #setenv ENSONLY_BEG 2012111221
  #setenv ENSONLY_END 2014050621
  setenv ENSONLY_BEG 0
  setenv ENSONLY_END 0

# Make sure files are accessible
# ------------------------------
  umask 022

# Discover specific configuration
# ----------------------------
  limit stacksize unlimited
  limit coredumpsize 0
  setenv KMP_STACKSIZE    450m
  unsetenv F_UFMTENDIAN
  setenv KMP_LIBRARY turnaround

# Get date/time from restarts
# ---------------------------
  cd $FVWORK

 @ varoffset_sc = $VAROFFSET * 60
  set date0  = `tick $anymd $anhms -$varoffset_sc` 
  set nymdb  = $date0[1]
  set nhmsb  = $date0[2]
  set ddb      = `echo $nymdb | cut -c7-8`
  set hhb      = `echo $nhmsb | cut -c1-2`
  set yyyymmddhh = ${nymdb}${hhb}
  @ anafreq_sc = $TIMEINC * 60

# Define prefix and suffix of job names
  setenv JOBGEN_PFXNAME efso26
  setenv JOBGEN_SFXNAME ${ddb}_${hhb}z
  if ( $?PBS_JOBID ) then
     qalter -N ${JOBGEN_PFXNAME}_atm_ens_${JOBGEN_SFXNAME} $PBS_JOBID
  else
     if ( $?SLURM_JOBID ) then
         qalter -N ${JOBGEN_PFXNAME}_atm_ens_${JOBGEN_SFXNAME} $SLURM_JOBID
     else
         echo "no JOBID found, abort"
         exit(1)
     endif
  endif

# Get positioned in work area
# ---------------------------
  cd $FVWORK
  if ( -e .FAILED ) then
      echo " Main: clearing past FAILURE "
      /bin/rm .FAILED
  endif


# Set up work directory with needed inputs
# ----------------------------------------
  if ( $RUN_EFSO_SET || $DO_ATM_ENS ) then

#    Create RC file with files required to run ensemble analysis/ob-impact
#    ---------------------------------------------------------------------
     zeit_ci.x pobsens
     atmens_prepobsens.csh $EXPID $anymd $anhms $ftau $aver $prog "setrc"
     if( $status) then
        echo "prepobsens(1) failed"
        exit(1)
     endif
     zeit_co.x pobsens

#    Acquire required fields/files for running analysis
#    --------------------------------------------------
     if ( -e aensosens.rc ) then
        if ( ! -e $FVWORK/.DONE_MEM001_GET4AEOSENS.$yyyymmddhh) then 
         if(! -d $STAGE4HYBGSI ) mkdir -p $STAGE4HYBGSI
         set spool = "-s $FVWORK/spool"        
         jobgen.pl \
                -q datamove \
                get4aeosens         \
                $GID                \
                $OBSVR_WALLCLOCK    \
                "acquire -v -strict -rc $FVWORK/aensosens.rc  -d $STAGE4HYBGSI $spool -ssh $anymd $anhms 060000 1" \
                $STAGE4HYBGSI       \
                $myname             \
                $FVWORK/.DONE_MEM001_GET4AEOSENS.$yyyymmddhh \
                "Main job script Failed for Get for Ensemble Ob-Sensitivity"
   
                if ( -e get4aeosens.j ) then
                   if ( $ATMENS_BATCHSUB == "sbatch" ) then
                      $ATMENS_BATCHSUB  -W get4aeosens.j
                   else
                      $ATMENS_BATCHSUB  -W block=true get4aeosens.j
                   endif
                   touch .SUBMITTED
                else
                   echo " $myname: Failed for Get for Ensemble Ob-Sensitivity, Aborting ... "
                   touch $FVWORK/.FAILED
                   exit(1)
                endif
        endif
     endif

#    Create RC file with files required to run ensemble analysis/ob-impact
#    ---------------------------------------------------------------------
     zeit_ci.x pobsens
     atmens_prepobsens.csh $EXPID $anymd $anhms $ftau $aver $prog NULL
     if( $status) then
        echo "prepobsens(2) failed"
        exit(1)
     endif
     zeit_co.x pobsens

  endif  # RUN_EFSO_SET

# Run ensemble of atmospheric analyses
# ------------------------------------
  if ( $RUN_EAANA || $DO_ATM_ENS ) then
      zeit_ci.x eana
      atmos_eana.csh $EXPID $anymd $anhms |& tee -a atm_ens_osens.log
      if( $status) then
         echo "eana failed"
         exit(1)
      endif
      zeit_co.x eana
  endif

# Calculate post-efso diagnostics
# -------------------------------
  if ( $RUN_PEFSO || $DO_ATM_ENS ) then
      zeit_ci.x post_efso
      post_efso.csh $EXPID $anymd $anhms $ftau |& tee -a atm_ens_osens.log
      if( $status) then
         echo "post_efso failed"
         exit(1)
      endif
      zeit_co.x post_efso
  endif

# ATTENTION: From here down, things need changes and adaptation ... RTodling
  exit 0

# Store updated ensemble for archiving and prepare for next cycle
# ---------------------------------------------------------------
  if( $DO_ATM_ENS ) then
    /bin/mv $FVWORK/updated_ens  $FVHOME/atmensosens4arch.${nymdb}_${hhb}
  endif
 
# Summarize timings
# -----------------
  zeit_pr.x
  /bin/cp .zeit $FVHOME/atmensosens4arch.${nymdb}_${hhb}/$EXPID.atmefso_zeit.log.${nymdb}_${hhb}z.txt 

# If so, submit job for another observation sensitivity/impact case
# -----------------------------------------------------------------
  if( $DO_ATM_ENS ) then
     if ( ! ($ENSONLY_BEG && $ENSONLY_END) ) then
        cd $FVHOME/asens
#       $ATMENS_BATCHSUB atm_ens_osens.j
        cd -
     endif

#    If made it here, all is good, then remove the working directory
#    ---------------------------------------------------------------
     /bin/rm -rf $FVWORK
     /bin/rm     $FVHOME/.ENSOSENSWORK
  endif

# Archive ensemble
# ----------------
  if ( $RUN_ARCHATMENS || $DO_ATM_ENS ) then
      set arch_hh = `echo $arch_nhms | cut -c1-2`
      atmens_arch.csh $EXPID $arch_nymd $arch_nhms $FVHOME/run/atmens/atmens_efsostorage.arc efso atmensosens4arch.${nymdb}_${hhb} |& tee -a atm_efso_arch.${arch_nymd}_${arch_hh}z.log
  endif

