package Create_fsens_script;
#########################################################################
#
# name - Create_fsens_script.pm
#
# purpose - To create job script for analysis sensitivity run
#
# !REVISION HISTORY:
#
# 17Nov2009  Todling   Initial code
# 23Aug2010  Todling   Add USRMITER to allow redefining miter for GSI-ADM
# 17Feb2014  Todling   Add reference to GEOS_Util - needs better handle
#
##########################################################################
use strict;
use warnings;

use English;
use File::Basename;
use FindBin qw( $Bin );
use lib "$Bin";
use GMAO_utils ("get_siteID");

require Exporter;
our @ISA = "Exporter";
our @EXPORT_OK = qw( fsens_script );

#=======================================================================
sub fsens_script {

    # input parameters
    #-----------------
    my %inputparams = @_;

    my $fvhome          = $inputparams{"fvhome"};
    my $fvroot          = $inputparams{"fvroot"};
    my $fvbcs           = $inputparams{"fvbcs"};
    my $mywork          = $inputparams{"mywork"};
    my $jobfs           = $inputparams{"jobfs"};
    my $group_list      = $inputparams{"group_list"};
    my $export_none     = $inputparams{"export_none"};
    my $jobqueue1       = $inputparams{"jobqueue1"};
    my $mem             = $inputparams{"mem"};
    my $ncpus_gsi       = $inputparams{"ncpus_gsi"};
    my $nodeflg         = $inputparams{"nodeflg"};
    my $fcswallclk      = $inputparams{"fcswallclk"};
    my $nametag         = $inputparams{"nametag"};
    my $gid             = $inputparams{"gid"};
    my $expid           = $inputparams{"expid"};
    my $ncsuffix        = $inputparams{"ncsuffix"};
    my $qsub            = $inputparams{"qsub"};

 # local variables
 my( $siteID );
 
 $siteID = get_siteID();

 open(SCRIPT,">$fvhome/run/$jobfs.j") or
 die ">>> ERROR <<< cannot write $fvhome/run/$jobfs.j";

 print  SCRIPT <<"EOF";
#!/bin/csh -fx
#$group_list
##$export_none
#$jobqueue1
#SBATCH --job-name=fsens
#SBATCH --output=fsens.log.o%j
#SBATCH --ntasks=$ncpus_gsi
#SBATCH --ntasks-per-node=24
#SBATCH --constraint=$nodeflg
#SBATCH --time=${fcswallclk}:00
#PBS -N fsens
#PBS -o fsens.log.o%j
#PBS -l ncpus=$ncpus_gsi
#PBS -S /bin/csh
#PBS -j eo
# ------------------------------
#
# ForecastSens driver script.
#
# This file has been automatically generated by fvsetup.
#
# $nametag
#--------------------------------------------------------------------
 set myname = `basename \$0`
 cd  # start from home otherwise the which's get messed up in SLURM


#
#                 ----------------------------------
#                  PART I - Prepare the Environment
#                 ----------------------------------

# Experiment environment
# ----------------------
  setenv BATCH_SUBCMD $qsub
  setenv GID $gid
  setenv group_list \"$group_list\"
  setenv ARCH `uname -s`
  setenv HOST `uname -n`
  setenv NCPUS   $ncpus_gsi   # number of CPUS
  setenv N_CPU   \$NCPUS
  setenv EXPID   $expid   # experiment ID
  setenv CASE    \$EXPID  # experiment ID (for LSM's sake)
  setenv FVHOME  $fvhome  # experiment home directory
  setenv FVROOT  `cat \$FVHOME/.FVROOT`
  setenv FVINPUT \$FVHOME/fvInput
  setenv NCSUFFIX $ncsuffix
  setenv STAGE4FSENS \$FVHOME/save4fsens   # set to whatever else user wants

  if( (`uname -s` == "Linux") && ( (`uname -m` == "ia64") || (`uname -m` == "x86_64") ) ) then
      setenv FVWORK $fvhome/../tmp.\$\$
      if(   -d \$FVWORK ) /bin/rm -r  \$FVWORK
      /bin/mkdir -p \$FVWORK
  else
      echo " dont know about to run in this architecture"
      exit 1
  endif

# Load BASEDIR and modules
# ------------------------
  unsetenv LD_LIBRARY_PATH
  source \$FVROOT/bin/g5_modules
  setenv LD_LIBRARY_PATH \${BASEDIR}/\${ARCH}/lib:\${FVROOT}/lib:\${LD_LIBRARY_PATH}

# Until a better handle of GEOS_Util is agreed upon (should not refer to things in src)
# -------------------------------------------------------------------------------------
  setenv GEOSUTIL \$FVROOT
  \$GEOSUTIL/plots/configure
  source .quickplotrc

EOF

#foreach $set ( @extdatasets ) {
#    print SCRIPT "  /bin/rm -f \$EXTDATA/$set\n";
#    print SCRIPT "  /bin/ln -s $extdata{$set} \$EXTDATA/\n";
#}

  print SCRIPT <<"EOF";

# Needed for TLM/ADM
# ------------------
  setenv N_SMP                        \$NCPUS    # number of CPUS
  setenv N_MPI                        \$NCPUS    # number of MPI processes
  setenv NUMBER_MLP_PROCESSES         \${N_MPI} # still used by GCM
  setenv NUMBER_CPUS_PER_MLP_PROCESS  \${N_SMP} # still used by GCM

# Make sure files are accessible
# ------------------------------
  umask 022

# Linux specific configuration
# ---------------------------------
  limit stacksize unlimited
  limit coredumpsize 0
  setenv KMP_STACKSIZE    450m
  unsetenv F_UFMTENDIAN

# End of system dependent configuration ...................................

#
#                 ----------------------------------------------------------
#                    PART II - Get positioned in trajectory work directory
#                 ----------------------------------------------------------

# Figure out if trajectories available and set FVWORK
# ---------------------------------------------------
  set cases2process = (`ls -1 \$STAGE4FSENS | grep -v done_`)
  echo \$cases2process[1]
  if(\$status) then
     echo \$myname": no more forecast trajectories to process ..."
     exit 0
  endif
# could replace the following by acquire ...
# ------------------------------------------
  /bin/cp \$STAGE4FSENS/\$cases2process[1]/*.\$NCSUFFIX \$FVWORK/

# Add FVROOT/bin to front of path so fvDAS binaries are found first
# -----------------------------------------------------------------
  if ( `uname -s` == "Linux" ) then
    set path = ( . \$FVHOME/fcst \$FVHOME/run \$FVROOT/bin \$BASEDIR/\$ARCH/bin \$path )
  else
    set path = ( . \$FVHOME/fcst \$FVHOME/run \$FVROOT/bin \$path )
  endif

# Continue with rest of script
# ----------------------------
  set GCMPTX = `which GEOSgcmPert.x`

  setenv ADMRUN_OPT_BEGIN "esma_mpirun -np \$NCPUS \$GCMPTX"

                            cd \$FVWORK
#
#                 ----------------------------------------------------------
#                    PART III - Run forecast sensitivity script
#                 ----------------------------------------------------------

# copy rc files
# -------------
  /bin/cp \$FVHOME/run/*.rc .
  /bin/cp \$FVHOME/run/*.tmpl .
  /bin/cp \$FVHOME/run/*.acq .
  /bin/cp \$FVHOME/run/*.namelist .
 
  set fcst_nymd_beg = `echo \$cases2process[1] | cut -d. -f2 | cut -c1-8`
  set fcst_nhms_beg = `echo \$cases2process[1] | cut -d. -f2 | cut -c10-15`
  set fcst_nymd_end = `echo \$cases2process[1] | cut -d+ -f2 | cut -c1-8`
  set fcst_nhms_end = `echo \$cases2process[1] | cut -d+ -f2 | cut -c10-15`
  set           hhb = `echo \$fcst_nhms_beg    | cut -c1-2`

  if( -e \$FVHOME/fsens/CAP_apert.rc.tmpl ) then
     set mycap = \$FVHOME/fsens/CAP_apert.rc.tmpl
  else
     if( -e \$FVHOME/fcst/CAP_apert.rc.tmpl ) then
        set mycap = \$FVHOME/fcst/CAP_apert.rc.tmpl
     else
        set mycap = CAP.rc.tmpl
     endif
  endif
  set rundt = `grep "^HEARTBEAT_DT:" \${mycap} | cut -d: -f2`

  fvsens \$FVWORK \$EXPID \$fcst_nymd_end \$fcst_nhms_end \$hhb \$rundt

  set rc = \$status
  if ( \$rc > 0 && \$rc < 100 ) then
       echo \$myname": abnormal error condition from fvsens ..."
       exit 1
  endif

# Retag sensitivity vector and stage for analysis sensitivity run
# ---------------------------------------------------------------
  if ( \$?GRSTAGE ) then
       set grstage = \$GRSTAGE
  else
       set grstage = "\${FVHOME}/asens/"
  endif
  set grfiles = `ls *fsens_*.eta* *fsensainc_*.eta*`
  set itime   = \${fcst_nymd_beg}_\${hhb}z
  foreach grfile ( \$grfiles )
        set vtime = \$grfile:r # verification time
        set vtime = \$vtime:e  # verification time
        set bname = \$grfile:r # base name $expid.prog.eta
        set bname = \$bname:r  # base name $expid.prog.eta
        set nname = "\$bname.\$itime+\$vtime.\$NCSUFFIX"
        /bin/mv -f \$grfile \$nname
        /bin/cp -f \$nname  \$grstage
        endif
  end
  foreach ftype ( Jgradf_ Jgradfainc_ )
      set files = `/bin/ls -1 \$EXPID.\${ftype}*.\$NCSUFFIX`
      if ( !(\$status) ) then     # at least 1 file of this type
         foreach file ( \$files )
            set vtime = \$file:r  # verification time
            set vtime = \$vtime:e # verification time
            set bname = \$file:r  # base name $expid.prog.eta
            set bname = \$bname:r # base name $expid.prog.eta
            /bin/mv \$file \$bname.\$itime+\$vtime.\$NCSUFFIX
         end
      endif
  end
  foreach ftype ( Jnormf EMferrnorm Xdot )
     set files = `/bin/ls -1 \$EXPID.\${ftype}*.txt`
     if ( !(\$status) ) then     # at least 1 file of this type
        foreach file ( \$files )
           set vtime = \$file:r  # verification time
           set vtime = \$vtime:e # verification time
           set bname = \$file:r  # base name $expid.prog.eta
           set bname = \$bname:r # base name $expid.prog.eta
           /bin/mv \$file \$bname.\$itime+\$vtime.txt
        end
     endif
  end



#
#                 ----------------------------------------
#                      PART IV - Data Archival
#                 ---------------------------------------

                           cd \$FVHOME/run


# Move files to FVHOME for archiving and/or post-processing
# ---------------------------------------------------------
  ls -altuF \$FVWORK
  setenv PESTOROOT `dirname \$FVHOME`
  pesto -v -clean -d \$FVWORK -arc fsenstorage.arc


# Mass storage archival as an 1 CPU batch job
# -------------------------------------------
  set jname = "fsens.archive"
  set lname = \$jname.log.o%j

  if ( \$BATCH_SUBCMD == "sbatch" ) then
     sbatch -J \$jname -o \$lname --export=arch_type=FSENS \$FVHOME/run/fvarchive.j
  else
     qsub -N \$jname -o \$lname -v arch_type=FSENS \$FVHOME/run/fvarchive.j
  endif

# --------------------------
# No post-processing for now
# --------------------------


#
#
#                  ------------------------------
#                    PART IV - Next Job Segment
#                  ------------------------------

                          cd \$FVHOME/run

# If forecast sucessfully completed, remove rs and resubmit
# ---------------------------------------------------------
 if ( \$rc == 0 || \$rc == 101 || ) then

     /bin/mv \$STAGE4FSENS/\$cases2process[1] \$STAGE4FSENS/done_\${cases2process[1]}

     set cases2process = (`ls -1 \$STAGE4FSENS`)
     echo \$cases2process[1]
     if(\$status) then
        echo \$myname": no more forecast trajectories to process ..."
        exit 0
     endif
  
     set fcst_nymd_beg = `echo \$cases2process[1] | cut -d. -f2 | cut -c1-8`
     set            hh = `echo \$cases2process[1] | cut -d. -f2 | cut -c10-11`
     set jname = f\${nymd}_\${hh}
     set lname = \$jname.log.o%j

     if ( \$BATCH_SUBCMD == "sbatch" ) then
        sbatch -d afterany:\${PBS_JOBID} -J \$jname -o \$lname $jobfs.j
     else
        qsub -W depend=afterany:\${PBS_JOBID} -N \$jname -o \$lname $jobfs.j
     endif

#    Because on Columbia this is not a legitimate TMPDIR, remove dir to avoid pile up
#    --------------------------------------------------------------------------------
     if( (`uname -s` == "Linux") && ((`uname -m` == "ia64")||(`uname -m` == "x86_64")) ) then
        cd
        /bin/rm -r \$FVWORK
     endif

# or else, something went wrong
# -----------------------------
  else

     echo \$myname": unexpected return code from fvpsas, rc = \$rc"
     exit 1

  endif

# All done
# --------
  exit 0

EOF

 close(SCRIPT);

}

1;
