package Create_asens_script;
#########################################################################
#
# name - create_asens_script.pm
#
# purpose - To create job script for analysis sensitivity run
#
# !REVISION HISTORY:
#
# 17Nov2009  Todling   Initial code
# 23Aug2010  Todling   Add USRMITER to allow redefining miter for GSI-ADM
# 23Jun2013  Todling   Revisit logic to find available sens-vectors
# 31Jan2014  Todling   Forcefully deactivate PREQC and aircraft bias corr
#                      (these can pig-back from forward DAS)
# 31Oct2015  Todling   Since the default in GSI is BiCG, set USRMITER to 1
#
##########################################################################
use strict;
use warnings;

use English;
use File::Basename;
use FindBin qw( $Bin );
use lib "$Bin";
use GMAO_utils ("get_siteID");

require Exporter;
our @ISA = "Exporter";
our @EXPORT_OK = qw( asens_script );

#=======================================================================
sub asens_script {

    # input parameters
    #-----------------
    my %inputparams = @_;

    my $fvhome          = $inputparams{"fvhome"};
    my $fvroot          = $inputparams{"fvroot"};
    my $fvbcs           = $inputparams{"fvbcs"};
    my $mywork          = $inputparams{"mywork"};
    my $joba            = $inputparams{"joba"};
    my $group_list      = $inputparams{"group_list"};
    my $export_none     = $inputparams{"export_none"};
    my $hyb_ens         = $inputparams{"hyb_ens"};
    my $jobqueue1       = $inputparams{"jobqueue1"};
    my $mem             = $inputparams{"mem"};
    my $ncpus_gsi       = $inputparams{"ncpus_gsi"};
    my $nodeflg         = $inputparams{"nodeflg"};
    my $fcswallclk      = $inputparams{"fcswallclk"};
    my $nametag         = $inputparams{"nametag"};
    my $gid             = $inputparams{"gid"};
    my $expid           = $inputparams{"expid"};
    my $g5gcm           = $inputparams{"g5gcm"};
    my $prepqc          = $inputparams{"prepqc"};
    my $oiqc            = $inputparams{"oiqc"};
    my $varwindow       = $inputparams{"varwindow"};
    my $acftbias        = $inputparams{"acftbias"};
    my $asynbkg_min     = $inputparams{"asynbkg_min"};
    my $varoffset       = $inputparams{"varoffset"};
    my $do4dvar         = $inputparams{"do4dvar"};
    my $wcnstrt         = $inputparams{"wcnstrt"};
    my $nvarouter       = $inputparams{"nvarouter"};
    my $convsfc         = $inputparams{"convsfc"};
    my $convupa         = $inputparams{"convupa"};
    my $ncsuffix        = $inputparams{"ncsuffix"};
    my $berror_env      = $inputparams{"berror_env"};
    my $specres         = $inputparams{"specres"};
    my $osfmodule       = $inputparams{"osfmodule"};
    my $obClass         = $inputparams{"obClass"};
    my $newradbc        = $inputparams{"newradbc"};
    my $doRcorr         = $inputparams{"doRcorr"};
    my $qsub            = $inputparams{"qsub"};

 # local variables
 my( $os, $siteID );

 $siteID = get_siteID();

 open(SCRIPT,">$fvhome/asens/$joba.j") or
 die ">>> ERROR <<< cannot write $fvhome/asens/$joba.j";

 print  SCRIPT <<"EOF";
#!/bin/csh -fx
#$group_list
#$jobqueue1
#SBATCH --job-name=asens
#SBATCH --output=asens.log.o%j.txt
#SBATCH --ntasks=$ncpus_gsi
#SBATCH --ntasks-per-node=24
#SBATCH --constraint=$nodeflg
#SBATCH --time=2:00:00
#PBS -N asens
#PBS -o asens.log.o%j.txt
#PBS -l ncpus=$ncpus_gsi
#PBS -S /bin/csh
#PBS -j eo
# ----------------------------
#
# AnaSens driver script.
#
# This file has been automatically generated by fvsetup.
#
# $nametag
#--------------------------------------------------------------------
  set myname = `basename \$0`
  cd  # start from home otherwise the which's get messed up in SLURM

  setenv FVHOME  $fvhome  # experiment home directory
  if (-e \$FVHOME/run/FVDAS_Run_Config) source \$FVHOME/run/FVDAS_Run_Config

#
#                 ----------------------------------
#                  PART I - Prepare the Environment
#                 ----------------------------------

# Experiment environment
# ----------------------
  setenv BATCH_SUBCMD $qsub
  setenv GID $gid
  setenv group_list \"$group_list\"
  setenv ARCH `uname -s`
  setenv HOST `uname -n`
  setenv NCPUS   $ncpus_gsi   # number of CPUS
  setenv N_CPU   \$NCPUS
  setenv EXPID   $expid   # experiment ID
  setenv CASE    \$EXPID  # experiment ID (for LSM's sake)
  setenv FVHOME  $fvhome  # experiment home directory
  setenv FVROOT  `cat \$FVHOME/.FVROOT`
  setenv ASENS   \$FVHOME/asens
  if(`uname -s` == "OSF1" ) then
     cd \$TMPDIR_UBC
     setenv FVWORK  `pwd`           # temporary fix while TMPDIR not avail on Halem
     setenv FVWORK  \$FVWORK/tmp.\$\$  # temporary fix while TMPDIR not avail on Halem
     /bin/mkdir -p \$FVWORK
  endif
  if(`uname -s` == "IRIX64" ) then
     setenv FVWORK  \$SCRATCH1 # working directory
  endif
  if( (`uname -s` == "Linux") && ((`uname -m` == "ia64") || (`uname -m` == "x86_64") )) then
     setenv FORT90L -Wl,-T
     setenv FVWORK $fvhome/../tmp.\$\$
     if(   -d \$FVWORK ) /bin/rm -r  \$FVWORK
     /bin/mkdir -p \$FVWORK
  endif

# Load BASEDIR and modules
# ------------------------
  unsetenv LD_LIBRARY_PATH
  source \$FVROOT/bin/g5_modules
  setenv LD_LIBRARY_PATH \${BASEDIR}/\${ARCH}/lib:\${FVROOT}/lib:\${LD_LIBRARY_PATH}

# Internal parameters controling system behavior
# ----------------------------------------------
  setenv ACFTBIAS $acftbias # knob for aircraft bias correction (1=on; 0=off) 
  setenv G5GCM   $g5gcm   # 1 = enables GEOS-5 GCM, 0 = disables GEOS-5 GCM (back to fvGCM)
# setenv PREPQC  $prepqc  # 1 = enables NCEP-QC, 0 = disables QC
  setenv OIQC    $oiqc    # 1 = enables OIQC, 0 = disables OIQC
  setenv NEWRADBC $newradbc
  setenv ANGLEBC  $newradbc
  setenv RADCOR  "NCEP_VAI"  # (see ssprepqc usage for valid values)
  setenv NOSFCANA 1       # for now, shut down sfc-analysis
  setenv TIMEINC $varwindow
  setenv ASYNBKG $asynbkg_min   # 1 = enables ASYNOPTIC BCKG mode, 0 = disables it
  setenv VAROFFSET $varoffset   # abs value of time off from 1st synoptic hour of var window
  setenv DO4DVAR  $do4dvar    # 1=enables 4dvar
  setenv WCONSTRAINT $wcnstrt # set/unset weak constraint option
  setenv NVAROUTER $nvarouter # number of iteration for var loop
  setenv DORCORR   $doRcorr # channel correlated observations
  setenv DIAG2ODS 1        # 1 = enables conversion of gsi-diag files to ODS, 0 = disables it
  setenv CONVSFC  $convsfc # 1 = enables call to lcv2prs for conversion of surface output fields
  setenv CONVUPA  $convupa # 1 = enables call to lcv2prs for conversion of upper-air output fields
  setenv ANASENS  1        # 0 = disable observation sensitivity;   1 = enable
  setenv NCSUFFIX $ncsuffix
# setenv USRMITER  1       # uncomment to bypass miter from forward GSI run w/ user defined miter
EOF

  if ( $hyb_ens < 3 ) {
    print  SCRIPT <<"EOF";
# setenv HYBRIDGSI  \$FVHOME/atmens
# setenv STAGE4HYBGSI  \$HYBRIDGSI/central
EOF
  } else {
    print  SCRIPT <<"EOF";
  setenv HYBRIDGSI  \$FVHOME/atmens
  setenv STAGE4HYBGSI  \$HYBRIDGSI/central
EOF
  }

  print  SCRIPT <<"EOF";
# SSI/GSI specifics
# -----------------
  setenv NCEPINPUT  $fvbcs
  $berror_env

  setenv skipTRANSF                 # no transform needed for ana-sensitivity executable
  setenv skipSOLVER                 # need to run the analysis sensitivity solver
  setenv skipSATBIAS "-skipSATBIAS" # no need to worry about running satellite bias correction

  setenv SPECRES    $specres
  setenv SPECVTX    \$SPECRES
  setenv LEVSVTX     64        # this is the wired-in number of levels when tracking reloc used

# Needed for TLM/ADM
# ------------------
  setenv N_SMP                        \$NCPUS    # number of CPUS
  setenv N_MPI                        \$NCPUS    # number of MPI processes
  setenv NUMBER_MLP_PROCESSES         \${N_MPI} # still used by GCM
  setenv NUMBER_CPUS_PER_MLP_PROCESS  \${N_SMP} # still used by GCM


# Make sure files are accessible
# ------------------------------
  umask 022

# Add FVROOT/bin to front of path so fvDAS binaries are found first
# -----------------------------------------------------------------
  if ( `uname -s` == "Linux" ) then
     set path = ( . \$FVHOME/asens \$FVHOME/run \$FVROOT/bin \$FVROOT/lib/grads \$BASEDIR/\$ARCH/bin \$path )
  else
     set path = ( . \$FVHOME/asens \$FVHOME/run \$FVROOT/bin \$FVROOT/lib/grads \$path )
  endif

  echo \$FVWORK > \$FVHOME/.ASENS   # record working directory

  setenv EXTDATA \$FVWORK/ExtData  # External data directory
  /bin/mkdir -p \$EXTDATA
  /bin/touch \$EXTDATA/.no_archiving
  /bin/rm -f \$EXTDATA/g5chem
  /bin/ln -s \$NCEPINPUT/g5chem \$EXTDATA/

EOF

# System dependent configuration ..........................................
# ------------------------------
  $os = uc $OSNAME;

  if ( $os =~ /IRIX/ ) {

  print  SCRIPT <<"EOF";

  limit stacksize    4000000kb
  limit coredumpsize 0
  setenv MP_SLAVE_STACKSIZE 100000000       # bytes
  set stacksize = `limit stacksize | awk '{print \$2}' -`
  if (\${stacksize} == "unlimited" || \${stacksize} > 4000000) then
     setenv MP_STACK_OVERFLOW OFF
  endif
  setenv MPC_GANG off


EOF
   }

  elsif ( $os =~ /AIX/ ) {

  print  SCRIPT <<"EOF";

# IBM specific configuration
# --------------------------
  limit stacksize   4000000kb   # 4 Gbytes
  limit coredumpsize 0
  setenv MP_SLAVE_STACKSIZE 100000000       # bytes
  setenv MP_PROCS \${N_MPI}
  setenv MP_EUIDEVICE css0
  setenv MP_EUILIB us
  setenv MP_HOSTILE host.list
  setenv MP_INFOLEVEL 2
  setenv XLSMPOPTS "parthds=\${N_SMP}:schedule=static"
  setenv MP_CSS_INTERRUPT yes

EOF
}

  elsif ( $os =~ /LINUX/ ) {
    if(`uname -n` =~ /thunder/) {
      print  SCRIPT <<"EOF";


# Linux specific configuration
# ---------------------------------
  limit stacksize unlimited
  limit coredumpsize 0
  setenv KMP_STACKSIZE    450m
  unsetenv F_UFMTENDIAN
  setenv KMP_LIBRARY turnaround
  setenv MPI_DSM_DISTRIBUTE
  setenv MPI_TYPE_MAX 6553600
  setenv MPI_UNBUFFERED_STDIO
  setenv DSM_DISTRIBUTE
  setenv MPI_USE_XPMEM
  setenv MPI_BUFFER_MAX 2000
  setenv MPI_MSGS_MAX   10485760
EOF


    }elsif ($siteID eq "nas") {

  print  SCRIPT <<"EOF";

# Altix specific configuration
# ----------------------------
  limit stacksize unlimited
  limit coredumpsize 0
  setenv KMP_STACKSIZE    450m
  unsetenv F_UFMTENDIAN
  setenv KMP_LIBRARY turnaround
  setenv MPI_DSM_DISTRIBUTE  # pin MPI proceeses to assigned CPU
  setenv MPI_REQUEST_MAX 32768
  setenv MPI_TYPE_MAX 6553600
  setenv MPI_UNBUFFERED_STDIO
  setenv DSM_DISTRIBUTE
  setenv MPI_USE_XPMEM
  setenv MPI_BUFFER_MAX 2000
  setenv MPI_MSGS_MAX   10485760
  setenv MPI_GROUP_MAX  128

  setenv GADDIR   /u/ltakacs/grads
EOF


    }elsif ($siteID eq "nccs" ) {

  print  SCRIPT <<"EOF";

# Linux specific configuration
# ----------------------------
  limit stacksize unlimited
  limit coredumpsize 0

  source \$SHARE/dao_ops/opengrads/setup.csh 1.9-rc1-gmao

  if (\$?I_MPI_ROOT) then
#   setenv I_MPI_USE_DYNAMIC_CONNECTIONS 0
    setenv I_MPI_FABRICS shm:ofa
  endif
  setenv MPI_BUFS_PER_PROC 1024

EOF

    }else{ # end of Altix block

  print  SCRIPT <<"EOF";

# Linux specific configuration
# ----------------------------
  setenv FORT90L -Wl,-T
  setenv F_UFMTENDIAN big
  setenv KMP_STACKSIZE    450m
  setenv KMP_LIBRARY turnaround
  limit stacksize   unlimited
  limit coredumpsize 0
  setenv MPSTKZ     32M
EOF
    } # end of Linux block

} elsif ( $os =~ /OSF/ ) {

  $osfmodule = "fortran/551J";
  print  SCRIPT <<"EOF";


# OSF specific configuration
# --------------------------
  setenv KMP_STACKSIZE 64000000             # bytes
  setenv MP_STACK_SIZE 64000000             # bytes
  setenv PARALLEL            \${N_SMP}

EOF
}
# End of system dependent configuration ...................................


# Continue with rest of script
# ----------------------------
  print  SCRIPT <<"EOF";

# Define gsi command line execution
# ---------------------------------
  set ANAX = `which GSIsa.x`
  set SACX = `which sac.x`
  setenv MPIRUN_ANA    "esma_mpirun -perhost 8 -np \$NCPUS \$ANAX"
# setenv MPIRUN_SAC    "esma_mpirun -np \$NCPUS \$SACX"
  setenv MPIRUN_SAC    "esma_mpirun -np  1      \$SACX"

# Execute driving script for stand-alone analysis
# -----------------------------------------------
# setenv OBSCLASS \"$obClass\"

#
#                 -------------------------------------------------------
#                    PART II - Stage and Run 1 Analysis Sensitivity Exp
#                 ------------------------------------------------------

                             cd \$FVHOME/asens

# To run increment sensitivity touch a file like 
#    standalone.20121230_00z+20121230_00z-20121230_00z
# under the \$FVHOME/asens directory
  set lstcases = `/bin/ls -1 standalone.*`
  if ( \$status ) then
     echo \$myname": proceeding to regular observation sensitivity calculation"
     setenv INCSENS 0
  else
     echo \$lstcases[1] | grep +
     if ( ! \$status ) then
        set xttag    = `echo \$lstcases[1] | cut -d. -f2 | cut -c1-25`
        set fcst_beg = `echo \$xttag | cut -d+ -f1`
        set fcst_end = `echo \$xttag | cut -d- -f2`
        if ( \$fcst_beg != \$fcst_beg ) then
           echo "$joba.j: cannot handle time stamp"
           exit 1
        endif
        set nymd  = `echo \$fcst_end | cut -c1-8`
        set hh    = `echo \$fcst_end | cut -c10-11`
        set nhms  = \${hh}0000
     endif
     setenv INCSENS 1
  endif

# Determine how many different vector norms to handle
# ---------------------------------------------------
  if ( ! \$INCSENS ) then

     set lookup = "\$FVHOME/fcst/initadj.rc"
     if ( -e \$lookup ) then
        set jgnorms = `echorc.x -rc \$lookup pert_norm`
     else
        set lookup = "\$FVHOME/asens/initadj.rc"
        if ( -e \$lookup ) then
           set jgnorms = `echorc.x -rc \$lookup pert_norm`
        else
           echo " cannot find \$lookup file; norm undetermined, aborting ..."
           exit 1
        endif
     endif

     set jgnlist = ( )
     foreach jgrdnrm ( \$jgnorms )

#       Pick oldest restart for initial condition
#       -----------------------------------------
        if ( \$?this_nymdhh ) then
            set rslist = `/bin/ls -1 \$FVHOME/asens/\$EXPID.fsens_\${jgrdnrm}.eta.????????_??z+????????_??z-\${this_nymdhh}z.$ncsuffix \\
                                     \$FVHOME/asens/\$EXPID.Jgradf_\${jgrdnrm}.eta.????????_??z+\${this_nymdhh}z.$ncsuffix`
        else
            set rslist = `/bin/ls -1 \$FVHOME/asens/\$EXPID.fsens_\${jgrdnrm}.eta.????????_??z+????????_??z-????????_??z.$ncsuffix \\
                                     \$FVHOME/asens/\$EXPID.Jgradf_\${jgrdnrm}.eta.????????_??z+????????_??z.$ncsuffix`
        endif
        if ( \$status ) then
           echo \$myname": no gradient files found, nothing to do"
           exit 1
        endif
        set vectyp = `echo \$rslist[1] | cut -d. -f2 | cut -c1-5`

#       Get date/time of initial condition
#       ----------------------------------
        /bin/mkdir -p \$FVHOME/asens/stage
        /bin/touch \$FVHOME/asens/stage/.no_archiving
        set myrsfile = \$rslist[1]
        set itime = \$myrsfile:r
        set itime = \$itime:e
        if ( \$vectyp == "fsens" ) then
           set xttag = `echo \$itime | cut -c1-25`
           set nymd  = `echo \$itime | cut -c27-34`
           set hh    = `echo \$itime | cut -c36-37`
           set nhms  = \${hh}0000
        else  # in case of Jgradf analysis not in time tag ...
           set xttag = `echo \$itime | cut -c1-12`
           set nymd  = `echo \$itime | cut -c14-21`
           set hh    = `echo \$itime | cut -c23-24`
           set nhms  = \${hh}0000
           if ( -e \$FVHOME/asens/asensrules.rc ) then
              set rcfile = \$FVHOME/asens/asensrules.rc
           else
              if ( -e \$FVHOME/run/asens/asensrules.rc ) then
                 set rcfile = \$FVHOME/run/asens/asensrules.rc
              else
                 echo "main: Mising asensrules.rc, aborting "
                 exit(1)
              endif
           endif
           set tauf = `echorc.x -rc \$FVHOME/asens/asensrules.rc integration_length_hrs` 
           @ tauf_sec = \$tauf * 3600
           set anadate = `tick \$nymd \$nhms -\$tauf_sec`
           set nymd = \$anadate[1]
           set nhms = \$anadate[2]
           set xttag = \${itime} # need a two-time-stamp date btime+etime
        endif

#       Find initial time of issued forecast
#       ------------------------------------
        set i0time = \$myrsfile:r
        set i0time = \$itime:e
        set nymd0 = `echo \$itime | cut -c1-8`
        set hh0   = `echo \$itime | cut -c10-11`
        set nhms0 = \${hh0}0000

        set sfx = `echo \$myrsfile | cut -d+ -f2`
        set jgnlist = (`/bin/ls \$FVHOME/asens/\$EXPID.fsens_\${jgrdnrm}.eta.????????_??z+\$sfx  \\
                                \$FVHOME/asens/\$EXPID.Jgradf_\${jgrdnrm}.eta.????????_??z+\$sfx`)
        foreach fn ( \$jgnlist )
           /bin/mv \$fn \$FVHOME/asens/stage
        end

     end # < loop over norms for input gradient vectors >

  endif # <INCSENS>

  set done = "tobedone"
  if ( \$ANASENS ) then
     fvssi -strict -obsclass \$OBSCLASS -gsensdir \$FVHOME/asens/stage -xttag \$xttag \$skipTRANSF \$skipSOLVER \$skipSATBIAS \$FVHOME \$FVWORK \$FVWORK \$nymd \$nhms \$EXPID
     set rc = \$status
     set done = "complete"
  endif
  if ( \$INCSENS ) then
     fvssi -strict -obsclass \$OBSCLASS -gsensdir /dev/null            -xttag \$xttag \$skipTRANSF \$skipSOLVER \$skipSATBIAS \$FVHOME \$FVWORK \$FVWORK \$nymd \$nhms \$EXPID
     set rc = \$status
     set done = "complete"
  endif
  if ( "\$done" == "tobedone" ) then
     fvssi -strict -obsclass \$OBSCLASS                                               \$skipTRANSF \$skipSOLVER \$skipSATBIAS \$FVHOME \$FVWORK \$FVWORK \$nymd \$nhms \$EXPID
     set rc = \$status
  endif

  if ( \$rc > 0 && \$rc < 100 ) then
     echo \$myname": abnormal error condition from fvssi ..."
     exit 1
  endif

#
#
#                 ----------------------------------------
#                      PART III - Data Archival
#                 ---------------------------------------

                           cd \$FVHOME/asens


# Move files to FVHOME for archiving and/or post-processing
# ---------------------------------------------------------
  ls -altuF \$FVWORK
  setenv PESTOROOT `dirname \$FVHOME`
  pesto -v -clean -d \$FVWORK -arc asenstorage.arc


# Mass storage archival as an 1 CPU batch job
# -------------------------------------------
  set jname = asens.arch.\${nymd}_\${hh}z
  set lname = \$FVHOME/asens/asens.arch.log.\${nymd}_\${hh}z.o%j.txt

  if ( \$BATCH_SUBCMD == "sbatch" ) then
     sbatch -W -J \$jname -o \$lname --export=arch_type=ASENS \$FVHOME/run/fvarchive.j
  else
     qsub   -W block=true -N \$jname -o \$lname -v arch_type=ASENS \$FVHOME/run/fvarchive.j
  endif

# --------------------------
# No post-processing for now
# --------------------------


#
#
#                  ------------------------------
#                    PART IV - Next Job Segment
#                  ------------------------------

                          cd \$FVHOME/asens

# If forecast sucessfully completed, remove rs and resubmit
# ---------------------------------------------------------
  if ( \$rc == 0 || \$rc == 101 ) then

     if ( \$INCSENS ) then

        /bin/rm \$lstcases[1]

        set lstcases = `/bin/ls -1 standalone.*`
        if ( \$status ) then
           echo \$myname": no more increment files, forecast job completed"
           exit 0
        endif
        set fcst_nxt = `echo \$lstcases[1] | cut -d. -f2 | cut -d+ -f1`
        set jname = asens.\${fcst_nxt}
        set lname = \$FVHOME/asens/asens.log.\${fcst_nxt}.o%j.txt
        if ( \$BATCH_SUBCMD == "sbatch" ) then
           sbatch -d afterany:\${PBS_JOBID} -J \$jname -o \$lname $joba.j
        else
           qsub -W depend=afterany:\${PBS_JOBID} -N \$jname -o \$lname $joba.j
        endif

     else

        set lst2del = (`/bin/ls \$FVHOME/asens/stage/\$EXPID.fsens_\${jgrdnrm}.eta.????????_??z+\$sfx \\
                                \$FVHOME/asens/stage/\$EXPID.Jgradf_\${jgrdnrm}.eta.????????_??z+\$sfx`)
        foreach fn ( \$lst2del )
            /bin/rm -f \$fn
        end

        if (! \$?this_nymdhh ) then
           set rslist = `/bin/ls -1 \$FVHOME/asens/\$EXPID.fsens_???.eta.????????_??z+????????_??z-????????_??z.$ncsuffix \\
                                    \$FVHOME/asens/\$EXPID.Jgradf_???.eta.????????_??z+????????_??z.$ncsuffix`
           if ( \$status ) then
              echo \$myname": no more sensitivity files, forecast job completed"
           else
              set gsens = \$rslist[1]:r
              set jname = \$gsens:e
              set itime2 = \$jname:r
              set nymd2 = `echo \$itime2 | cut -c27-34`
              set hh2   = `echo \$itime2 | cut -c36-37`
              set jname = asens.\${nymd2}_\${hh2}z
              set lname = \$FVHOME/asens/asens.log.\${nymd2}_\${hh2}z.o%j.txt
              if ( \$BATCH_SUBCMD == "sbatch" ) then
                 sbatch -d afterany:\${PBS_JOBID} -J \$jname -o \$lname $joba.j
              else
                 qsub -W depend=afterany:\${PBS_JOBID} -N \$jname -o \$lname $joba.j
              endif
           endif
        endif

     endif # <ANASENS vs INCSENS>

     # Rename output log
     # -----------------
     set lname = \$FVHOME/asens/asens.log.\${nymd}_\${hh}z.txt
     qalter -o \$lname \$SLURM_JOBID

     # Because on Columbia this is not a legitimate TMPDIR, remove dir to avoid pile up
     # --------------------------------------------------------------------------------
     if( (`uname -s` == "Linux") && ((`uname -m` == "ia64")||(`uname -m` == "x86_64")) ) then
        cd
        /bin/rm -r \$FVWORK
     endif

# or else, something went wrong
# -----------------------------
  else

     echo \$myname": unexpected return code from fvpsas, rc = \$rc"
     exit 1

  endif

# All done
# --------
  exit 0

EOF

 close(SCRIPT);

}

1;
