

rule sim_init_mpi:
    input:
        prj=expand(rules.project_file.output.prj,stage="init",allow_missing=True),
        model=f"results/model/{{rank}}D/{MODEL}_{MESH}/domain.vtu",
        boundary_results=optionalBoundaryResults,
        parallel_model = f"results/model/{RANK}/{MODEL}_{MESH}/parts_{{partition}}/parallel_model",
        domain_mesh=f"results/model/{{rank}}D/{MODEL}_{MESH}/domain.vtu",
    output:
        time_series=f"results/sim/{RANK}/{MODEL}_{MESH}/{{project}}/init/parts_{{partition}}/OGSoutput.{{ft}}"
    log:
        ogs_log=f"results/sim/{RANK}/{MODEL}_{MESH}/{{project}}/init/parts_{{partition}}/ogs_{{ft}}.log"
    threads:
        get_threads
    resources:
        mem_mb=500000
    shell:
        """
        mpirun -np {threads} ogs {input.prj_ogs} -o  {output.out_folder} -m {input.mesh} | tee {output.ogs_log}
        """


rule sim_init_parallel:
    input:
        prj=expand(rules.project_file.output.prj,stage="init",allow_missing=True),
        model=f"results/model/{{rank}}D/{MODEL}_{MESH}/domain.vtu",
        boundary_results=optionalBoundaryResults,
        parallel_model = f"results/model/{RANK}/{MODEL}_{MESH}/parts_{{partition}}/parallel_model",
        domain_mesh=f"results/model/{{rank}}D/{MODEL}_{MESH}/domain.vtu"
    output:
        time_series=f"results/sim/{RANK}/{MODEL}_{MESH}/{{project}}/init/parts_{{partition}}/OGSoutput.{{ft}}",
        ogs_log=f"results/sim/{RANK}/{MODEL}_{MESH}/{{project}}/init/parts_{{partition}}/ogs_{{ft}}.log"
    threads:
        get_threads
    resources:
        mem_mb=500000
    container: 
        None
    shell:
        """
        p_output_dir=$(realpath {output.time_series} | sed 's|\(.*\)/.*|\\1|')
        p_model_dir=$(realpath {input.parallel_model} | sed 's|\(.*\)/.*|\\1|'  )
        p_prj_dir=$(realpath {input.prj} | sed 's|\(.*\)/.*|\\1|')
        for b_result in {input.boundary_results} 
        do
            cp $b_result $p_prj_dir
        done
        mkdir -p $p_output_dir
        project_path=/p/project/ogs6hpc4
        module load GCC ParaStationMPI Python Eigen PETSc Boost git
        srun ogs {input.prj} --unbuffered-std-out -l debug -o $p_output_dir -m $p_model_dir | sed 's/\x1B\[[0-9;]*[A-Za-z]//g' | tee {output.ogs_log}
        """


rule serial_model_from_serial:
    input:
        time_series = f"results/sim/{RANK}/{MODEL}_{MESH}/{{project}}/init/OGSoutput.pvd"
    output:
        serial_domain=f"results/sim/{RANK}/{MODEL}_{MESH}/{{project}}/{{stage}}/result.vtu"
    run:
        input_dir = Path(input.time_series).parent
        e = etree.parse(input.time_series)
        last_file = str(input_dir) + "/" + e.xpath('//DataSet[last()]/@file')[0]
        print(last_file)
        shell(
            f"""
                    cp {last_file}  {output.serial_domain}  
                    """
        )





def get_model_init(wcs):
    if wcs.partition == "1":
        return expand(rules.serial_model_from_serial.output.serial_domain,stage="init",allow_missing=True)
    return expand(rules.serial_model_from_parallel.output.serial_domain,stage="init",allow_missing=True)


rule model_from_init_sim:
    input:
        # Serial model
        time_series=get_model_init,
        # Boundaries and repo are still the same
        dgr_repo=f"results/model/{RANK}/{MODEL}_{MESH}/dgr_repo.vtu",
        #boundary_meshes=expand(f"results/model/3D/{MODEL}_{MESH}/parts_{{partition}}/{{n}}.vtu", n=boundary_names(3), allow_missing=True),
        parallel_model = f"results/model/{RANK}/{MODEL}_{MESH}/parts_1/parallel_model",

    output:
        # if we assume the result would be the same independed from domain decomposition, remove parts_
        domain=f"results/model/{RANK}/{MODEL}_{MESH}/{{project}}/glacialcycle/parts_{{partition}}/domain_init.vtu",
        dgr_repo=f"results/model/{RANK}/{MODEL}_{MESH}/{{project}}/glacialcycle/parts_{{partition}}/dgr_repo.vtu",
        parallel_model = f"results/model/{RANK}/{MODEL}_{MESH}/{{project}}/glacialcycle/parts_{{partition}}/boundaries"
    shell:
        """
        cp {input.dgr_repo} {output.dgr_repo}
        cp {input.parallel_model} {output.parallel_model}
        boundary_in_dir=$(realpath {input.parallel_model} | sed 's|\(.*\)/.*|\\1|' )
        boundary_out_dir=$(realpath {output.parallel_model} | sed 's|\(.*\)/.*|\\1|' )
        cp $boundary_in_dir/*.* $boundary_out_dir
        python ogsworkflowhelper/post_processing/result_as_init.py {input.time_series} {output.domain} -point_data epsilon displacement -field_data epsilon_ip
        """


use rule ogs_to_metis as ogs_to_metis2 with:
    input:
        domain=rules.model_from_init_sim.output.domain
    output:
        domain_mesh=f"results/model/{RANK}/{MODEL}_{MESH}/{{project}}/glacialcycle/parts_{{partition}}/domain_init.mesh"


use rule optional_partition_mesh_3D as optional_partition_mesh2_3D with:
    # calls partmesh if not just copies files
    input:
        metis_mesh=expand(rules.ogs_to_metis2.output,rank=3, allow_missing=True),
        #metis_mesh=f"results/model/3D/{MODEL}_{MESH}/{{project}}/glacialcycle/parts_{{partition}}/domain_init.mesh",
        vtu=expand(rules.model_from_init_sim.output.domain,rank=3, allow_missing=True),
        #vtu=f"results/model/3D/{MODEL}_{MESH}/{{project}}/glacialcycle/parts_{{partition}}/domain_init.vtu",
        #boundary_meshes=rules.mesh_toy.output.boundary_meshes,
        repo=rules.mesh_3D_repo.output.dgr_repo_vtu
    params:
        stem=f"results/model/3D/{MODEL}_{MESH}/{{project}}/glacialcycle/parts_{{partition}}/domain_init"
    output:
        files= f"results/model/3D/{MODEL}_{MESH}/{{project}}/glacialcycle/parts_{{partition}}/parallel_model",
        repo= f"results/model/3D/{MODEL}_{MESH}/{{project}}/glacialcycle/parts_{{partition}}/dgr_repo.vtu",
        #boundary_meshes=expand(f"results/model/3D/{MODEL}_{MESH}/{{project}}/glacialcycle/parts_{{partition}}/{{n}}.vtu", n=boundary_names(3), allow_missing=True)


use rule optional_partition_mesh_3D as optional_partition_mesh2_2D with:
    # calls partmesh if not just copies files
    input:
        metis_mesh=expand(rules.ogs_to_metis2.output, rank=2,  allow_missing=True),
        #metis_mesh=f"results/model/2D/{MODEL}_{MESH}/{{project}}/glacialcycle/parts_{{partition}}/domain_init.mesh",
        vtu=expand(rules.model_from_init_sim.output.domain,rank=2, allow_missing=True),
        #vtu=f"results/model/2D/{MODEL}_{MESH}/{{project}}/glacialcycle/parts_{{partition}}/domain_init.vtu",
        #boundary_meshes=rules.mesh_toy.output.boundary_meshes,
        repo=rules.mesh_2D_repo.output.dgr_repo_vtu
    params:
        #stem=f"results/model/2D/{MODEL}_{MESH}/domain"
        stem=f"results/model/2D/{MODEL}_{MESH}/{{project}}/glacialcycle/parts_{{partition}}/domain_init"
    message:
        "{input.metis_mesh} {input.vtu} "
    output:
        files= f"results/model/2D/{MODEL}_{MESH}/{{project}}/glacialcycle/parts_{{partition}}/parallel_model",
        repo= f"results/model/2D/{MODEL}_{MESH}/{{project}}/glacialcycle/parts_{{partition}}/dgr_repo.vtu",
        boundary_meshes=expand(f"results/model/2D/{MODEL}_{MESH}/{{project}}/glacialcycle/parts_{{partition}}/{{n}}.vtu", n=boundary_names(2), allow_missing=True)




rule sim_glaciation_serial:
    input:
        domain=expand(rules.model_from_init_sim.output.domain,partition=1, allow_missing=True),
        prj="results/prj/{rank}D/{model}_toy-id_{layer_set_id}/{project}/glacialcycle.prj",
        boundary_results=optionalBoundaryResults,
        dgr_repo=f"results/model/{RANK}/{MODEL}_{MESH}/dgr_repo.vtu"
    output:
        time_series=f"results/sim/{RANK}/{MODEL}_{MESH}/{{project}}/glacialcycle/OGSoutput.{{ft}}",
        ogs_log=f"results/sim/{RANK}/{MODEL}_{MESH}/{{project}}/glacialcycle/ogs_{{ft}}.log"
    container:
        "container/images/ogs-dgr_latest_serial.sif"
    shell:
        """
        if [ {wildcards.ft} = xdmf ]; then
            sed 's/VTK/XDMF/g' {input.prj} > {input.prj}_x
        else
            cp {input.prj} {input.prj}_x
        fi
        p_model_dir=$(realpath {input.domain} | sed 's|\(.*\)/.*|\\1|' )
        p_output_dir=$(realpath {output.time_series} | sed 's|\(.*\)/.*|\\1|')
        mkdir -p $p_output_dir
        
        ogs {input.prj}_x -o $p_output_dir -m $p_model_dir | sed 's/\x1B\[[0-9;]*[A-Za-z]//g'  | tee {output.ogs_log}
        if [ {wildcards.ft} = xdmf ]; then
            mv $p_output_dir/OGSoutput_domain_init.xdmf $p_output_dir/OGSoutput.xdmf
        fi
        """


rule sim_glaciation_parallel:
    input:
        domain = rules.model_from_init_sim.output.domain,
        prj = "results/prj/{rank}D/{model}_toy-id_{layer_set_id}/{project}/glacialcycle.prj",
        boundary_results=optionalBoundaryResults,
        model_optional_partitioned = f"results/model/{RANK}/{MODEL}_{MESH}/{{project}}/glacialcycle/parts_{{partition}}/parallel_model"
    output:
        time_series=f"results/sim/{RANK}/{MODEL}_{MESH}/{{project}}/glacialcycle/parts_{{partition}}/OGSoutput.{{ft}}",
        ogs_log=f"results/sim/{RANK}/{MODEL}_{MESH}/{{project}}/glacialcycle/parts_{{partition}}/ogs_{{ft}}.log"
    threads:
        1
    resources:
        mem_mb=1000
    container: 
        None
    shell:
        """
        p_model_dir=$(realpath {input.domain} | sed 's|\(.*\)/.*|\\1|' )
        p_output_dir=$(realpath {output.time_series} | sed 's|\(.*\)/.*|\\1|')
        mkdir -p $p_output_dir
        export PATH=/p/project/ogs6hpc4/dgr/ogs_parallel/bin:$PATH
        module load GCC ParaStationMPI Python Eigen PETSc Boost git
        srun ogs {input.prj} -o $p_output_dir -m $p_model_dir | sed 's/\x1B\[[0-9;]*[A-Za-z]//g'  | tee {output.ogs_log}
        """


rule sim_glaciation_mpi:
    input:
        domain = rules.model_from_init_sim.output.domain,
        prj = "results/prj/{rank}D/{model}_toy-id_{layer_set_id}/{project}/glacialcycle.prj",
        boundary_results=optionalBoundaryResults,
        model_optional_partitioned = f"results/model/{RANK}/{MODEL}_{MESH}/{{project}}/glacialcycle/parts_{{partition}}/parallel_model"
    output:
        time_series=f"results/sim/{RANK}/{MODEL}_{MESH}/{{project}}/glacialcycle/parts_{{partition}}/OGSoutput.{{ft}}",
        #ogs_log=f"results/sim/{RANK}/{MODEL}_{MESH}/{{project}}/glacialcycle/parts_{{partition}}/ogs_{{ft}}.log"
    log:
        #Log files are not cleaned
        ogs_log = f"results/sim/{RANK}/{MODEL}_{MESH}/{{project}}/glacialcycle/parts_{{partition}}/ogs_{{ft}}.log"
    threads:
        1
    resources:
        mem_mb=1000
    shell:
        """
        if [ {wildcards.ft} = xdmf ]; then
            sed 's/VTK/XDMF/g' {input.prj} > {input.prj}_x
        else
            cp {input.prj} {input.prj}_x
        fi
        p_model_dir=$(realpath {input.domain} | sed 's|\(.*\)/.*|\\1|' )
        p_output_dir=$(realpath {output.time_series} | sed 's|\(.*\)/.*|\\1|')
        mkdir -p $p_output_dir
        export OMP_NUM_THREADS=0
        export OMP_THREAD_LIMIT=0
        mpirun -np {wildcards.partition} ogs {input.prj}_x -o $p_output_dir -m $p_model_dir | sed 's/\x1B\[[0-9;]*[A-Za-z]//g'  | tee {log.ogs_log}
        if [ {wildcards.ft} = xdmf ]; then
            mv $p_output_dir/OGSoutput_domain_init.xdmf $p_output_dir/OGSoutput.xdmf
        fi
        """


rule analyse_sim:
    input:
        time_series = f"results/sim/{RANK}/{MODEL}_{MESH}/{{project}}/glacialcycle/OGSoutput.pvd",
    log:
        notebook=f"results/sim/{RANK}/{MODEL}_{MESH}/{{project}}/glacialcycle/plot_time_series.ipynb",
    params:
        cases=['parts']
    notebook:
        "notebooks/plot_time_series.ipynb"


rule xdmf_from_pvd:
    input:
        # not working must be a pvd with remove ghost data !!
        f"results/sim/{MODEL}_{MESH}/{{project}}/{{stage}}/parts_{{partition}}/result.vtu",

    output:
        xdmfpath=f"results/sim/{MODEL}_{MESH}/{{project}}/{{stage}}/parts_{{partition}}/x.xdmf",
        pvd=f"results/sim/{MODEL}_{MESH}/{{project}}/{{stage}}/parts_{{partition}}/t.pvd"
    shell:
        """
        echo {output.xdmfpath}
        path2=$(dirname "{output.xdmfpath}")
        echo $path2 
        cp t.pvd $path2 
        PVD2XDMF {output.pvd} -o $path2/check
        """