localrules: study_runtime_3D_TH_init, study_runtime_3D_THM_init, study_runtime_2D_TH_init, study_runtime_3D_Salz_TH_init, study_convergence_parallel_2D_T_base_all


rule study_parallel_execution_project_parts_coarse:
    input:
        i=expand("results/sim/2D/model_Ton-Nord_toy-id_6-xres_240-factor_1/sim{_project_}/glacialcycle/parts_{_parts_}/OGSoutput_xdmf.log",_project_=['T','TH'],_parts_=[1,2,3,4])
    log:
        notebook="results/studies/study_parallel_execution_project_parts_coarse.ipynb"
    params:
        cases=['project','parts']
    notebook:
        "ogsworkflowhelper/post_processing/runtime_analysis.ipynb"


rule study_parallel_execution_project_parts_fine:
    input:
        i=expand("results/sim/2D/model_Ton-Nord_toy-id_6-xres_60-factor_4/sim{_project_}/glacialcycle/parts_{_parts_}/OGSoutput_xdmf.log",_project_=['T','TH'],_parts_=[1,2,3,4])
    log:
        notebook="results/studies/study_parallel_execution_project_parts_fine.ipynb"
    params:
        cases=['project','parts']
    notebook:
        "ogsworkflowhelper/post_processing/runtime_analysis.ipynb"


rule study_parallel_execution_3D:
    input:
        i=expand("results/sim/3D/model_Ton-Nord_toy-id_4-xres_300-factor_1/sim{_project_}/glacialcycle/parts_{_parts_}/OGSoutput_xdmf.log",_project_=['T'],_parts_=[2,3,4])
    log:
        notebook="results/studies/parallel_execution_3D.ipynb"
    params:
        cases=['project','parts']
    notebook:
        "ogsworkflowhelper/post_processing/runtime_analysis.ipynb"


res = [(240,1), (120,2), (80,3), (60,4), (40,6) ,(30,8)]
low_res_select=slice(0,4)
high_res_select=slice(4,6)

parts=[2,4,8,16,24,32,48,48*2,48*3, 48*4, 48*6, 48*8, 48*16]
low_part_select=slice(0,5)
high_part_select=slice(5,10)


ok_tn_6 = [(l[0],l[1],p) for l in res[low_res_select] for p in parts[low_part_select]]
ok_6 = [(l[0],l[1],p) for l in res[low_res_select] for p in parts[low_part_select]] + \
       [(l[0],l[1],p) for l in res[high_res_select] for p in parts[high_part_select]] 


ok_salz = [(240,1,24), (120,2,24), (240,1,48), (120,2,48), (240,1,96), (120,2,96), (240,1,192), (120,2,192), (240,1,384), (120,2,384), (60,1,96), (60,1,192), (60,1,384),(80,1,96), (80,1,192), (80,1,384)]

select_p_1 = slice(5,10)
ok_1 = parts[select_p_1]

rule study_Ton_Nord_complete_TH_init:
    input:
        # toy 6 there a no preset of intermediate layers (all 1)
        i = ["results/sim/3D/model_Ton-Nord_toy-id_18-xres_100-factor_1/simTHM/init/parts_{p}/OGSoutput.pvd".format( p=r) for r in ok_1]
    log:
        notebook="results/studies/study_Ton_Nord_complete_TH_init.ipynb"
    params:
        cases=['parts']
    notebook:
        "ogsworkflowhelper/post_processing/runtime_analysis.ipynb"




ok_tn_18=[(800,12),(800,24),(800,48), (800,96), (800,192), (800,384),(400,12),(400,24),(400,48), (400,96), (400,192), (400,384),(200,12),(200,24),(200,48), (200,96), (200,192), (200,384)]

rule study_runtime_3D_THM_init:
    input:
        # toy 6 there a no preset of intermediate layers (all 1)
        i = ["results/sim/3D/model_Ton-Nord_toy-id_18-xres_{res}-factor_1/simTHM/init/parts_{_parts}/OGSoutput.pvd".format(res=l[0], _parts=l[1]) for l in ok_tn_18 ]
    log:
        notebook="results/studies/study_runtime_3D.ipynb"
    params:
        cases=['resolution','parts']
    notebook:
        "ogsworkflowhelper/post_processing/runtime_analysis.ipynb"


rule study_runtime_3D_Ton_Nord_6_THM_init:
    input:
        # toy 6 there a no preset of intermediate layers (all 1)
       i = ["results/sim/3D/model_Ton-Nord_toy-id_18-xres_{res}-factor_{factor}/simTHM/init/parts_{_parts}/OGSoutput.pvd".format(res=l[0],factor=l[1], _parts=l[2]) for l in ok_6 ]
    log:
        notebook="results/studies/study_runtime_3D_THM_init.ipynb"
    params:
        cases=['resolution','parts']
    notebook:
        "ogsworkflowhelper/post_processing/runtime_analysis.ipynb"

rule study_runtime_3D_Ton_Nord_18_THM_init:
    input:
        # toy 6 there a no preset of intermediate layers (all 1)
       i = ["results/sim/3D/model_Ton-Nord_toy-id_18-xres_{res}-factor_1/simTHM/init/parts_{_parts}/OGSoutput.pvd".format(res=l[0],_parts=l[1]) for l in ok_tn_18 ]
    log:
        notebook="results/studies/study_runtime_3D_THM_init.ipynb"
    params:
        cases=['resolution','parts']
    notebook:
        "ogsworkflowhelper/post_processing/runtime_analysis.ipynb"


ok_1=[(800,24),(800,48),(800,96),(800,192),(800,384),(400,24),(400,48),(400,96),(400,192),(400,384),(200,24),(200,48),(200,96),(200,192),(200,384),(100,24),(100,48),(100,96),(100,192),(100,384)]

rule study_runtime_3D_Ton_Nord_18_THM_init_nopy:
    input:
        # toy 6 there a no preset of intermediate layers (all 1)
       i = ["results/sim/3D/model_Ton-Nord_toy-id_18-xres_{res}-factor_1/simTHM/init/parts_{_parts}/OGSoutput.pvd".format(res=l[0], _parts=l[1]) for l in ok_1 ]
    log:
        notebook="results/studies/study_runtime_3D_THM_init.ipynb"
    params:
        cases=['resolution','parts']
    notebook:
        "ogsworkflowhelper/post_processing/runtime_analysis.ipynb"



rule study_runtime_3D_TH_init:
    input:
        # toy 6 there a no preset of intermediate layers (all 1)
        i = ["results/sim/3D/model_Ton-Nord_toy-id_6-xres_{res}-factor_{factor}/simTH/init/parts_{_parts}/ogs_pvd.log".format(res=l[0],factor=l[1],_parts=l[2]) for l in ok_6 ]
    log:
        notebook="results/studies/study_runtime_3D_TH_init.ipynb"
    params:
        cases=['xres','parts']
    container:
        None
    notebook:
        "../ogsworkflowhelper/post_processing/runtime_analysis.ipynb"
        #"../ogsworkflowhelper/post_processing/test.ipynb"


rule study_runtime_3D_Salz_TH_init:
    input:
        # toy 6 there a no preset of intermediate layers (all 1)
        i = ["results/sim/3D/model_Salz-Kissen_toy-id_1-xres_{res}-factor_{factor}/simTH/init/parts_{_parts}/ogs_pvd.log".format(res=l[0],factor=l[1],_parts=l[2]) for l in ok_salz ]
    log:
        notebook="results/studies/study_runtime_3D_Salz-Kissen_TH_init.ipynb"
    params:
        cases=['xres','parts']
    container:
        None
    notebook:
        "../ogsworkflowhelper/post_processing/runtime_analysis.ipynb"
        #"../ogsworkflowhelper/post_processing/test.ipynb"


rule study_runtime_3D_Salz_THM_init:
    input:
        # toy 6 there a no preset of intermediate layers (all 1)
        i = ["results/sim/3D/model_Salz-Kissen_toy-id_1-xres_{res}-factor_{factor}/simTHM/init/parts_{_parts}/ogs_pvd.log".format(res=l[0],factor=l[1],_parts=l[2]) for l in  ok_salz ]
    log:
        notebook="results/studies/study_runtime_3D_Salz-Kissen_THM_init.ipynb"
    params:
        cases=['xres','parts']
    container:
        None
    notebook:
        "../ogsworkflowhelper/post_processing/runtime_analysis.ipynb"
        #"../ogsworkflowhelper/post_processing/test.ipynb"


rule study_runtime_3D_Salz_TH_glacialcycle:
    input:
        # toy 6 there a no preset of intermediate layers (all 1)
        i = ["results/sim/3D/model_Salz-Kissen_toy-id_1-xres_{res}-factor_{factor}/simTH/glacialcycle/parts_{_parts}/ogs_pvd.log".format(res=l[0],factor=l[1],_parts=l[2]) for l in ok_6 ]
    log:
        notebook="results/studies/study_runtime_3D_Salz-Kissen_TH_glacialcycle.ipynb"
    params:
        cases=['xres','parts']
    container:
        None
    notebook:
        "../ogsworkflowhelper/post_processing/runtime_analysis.ipynb"
        #"../ogsworkflowhelper/post_processing/test.ipynb"






rule study_runtime_3D_TH_glacialcycle:
    input:
        # toy 6 there a no preset of intermediate layers (all 1)
        i = ["results/sim/3D/model_Ton-Nord_toy-id_6-xres_{res}-factor_{factor}/simTH/glacialcycle/parts_{_parts}/ogs_pvd.log".format(res=l[0],factor=l[1],_parts=l[2]) for l in ok_6 ]
    log:
        notebook="results/studies/study_runtime_3D_TH_glacialcycle.ipynb"
    params:
        cases=['xres','parts']
    container:
        None
    notebook:
        "../ogsworkflowhelper/post_processing/runtime_analysis.ipynb"
        #"../ogsworkflowhelper/post_processing/test.ipynb"


rule check_simple_2D:
    input:
        "results/sim/2D/model_Ton-Nord_toy-id_6-xres_400-factor_1/simTH/init/parts_2/OGSoutput.pvd"
    output:
        "results/sim/2D/model_Ton-Nord_toy-id_6-xres_400-factor_1/simTH/init/parts_2/OK"
    shell:
        "touch {output}"



rule study_runtime_2D_TH_init:
    input:
        # toy 6 there a no preset of intermediate layers (all 1)
        c = rules.check_simple_2D.output,
        i = ["results/sim/2D/model_Ton-Nord_toy-id_6-xres_{res}-factor_{factor}/simTH/init/parts_{_parts}/ogs_pvd.log".format(res=l[0],factor=l[1],_parts=l[2]) for l in [(240, 1, 2), (400, 1, 2), (240, 1, 3), (400, 1, 3)] ]
    log:
        notebook="results/studies/study_runtime_2D_TH_init.ipynb"
    params:
        cases=['xres','parts']
    container:
        None
    notebook:
        "../ogsworkflowhelper/post_processing/runtime_analysis.ipynb"

rule study_convergence_parallel_2D_T_base_all:
    input:
        log_files = expand("results/sim/2D/{model}_toy-id_1-xres_{xres}-factor_1/simT/glacialcycle/ogs_pvd.log", model=salz_kissen, xres=[20 * 2**i for i in range(6)])
    params:
        case_names=['model', 'xres'],
        reg=sim_regex,
    log:
        notebook="results/studies/study_convergence_parallel_2D_T_base_all.ipynb"
    notebook:
        "../../notebooks/plot_convergence.ipynb"
    
rule study_convergence_parallel_2D_TH_base_all:
    input:
        log_files = expand("results/sim/2D/{model}_toy-id_1-xres_{xres}-factor_1/simTH/glacialcycle/ogs_pvd.log", model=salz_kissen, xres=[20 * 2**i for i in range(6)])
    params:
        case_names=['model', 'xres'],
        reg=sim_regex,
    log:
        notebook="results/studies/study_convergence_parallel_2D_TH_base_all.ipynb"
    notebook:
        "../../notebooks/plot_convergence.ipynb"

rule study_convergence_parallel_2D_THM_base_all:
    input:
        log_files = expand("results/sim/2D/{model}_toy-id_1-xres_{xres}-factor_1/simTHM/glacialcycle/ogs_pvd.log", model=salz_kissen, xres=[20 * 2**i for i in range(6)])
    params:
        case_names=['model', 'xres'],
        reg=sim_regex,
    log:
        notebook="results/studies/study_convergence_parallel_2D_THM_base_all.ipynb"
    notebook:
        "../../notebooks/plot_convergence.ipynb"