include: "common.smk"
# use with --keep-going!


localrules: study_sim_serial_2D_lowest_T_all_status, study_sim_serial_2D_lowest_THM_init_status, study_sim_serial_2D_lowest_T_glacialcycle_status, study_sim_serial_2D_lowest_THM_glacialcycle_status, study_sim_serial_3D_lowest_T_init_status, study_sim_serial_3D_lowest_T_glacialcycle_status, study_sim_serial_base_lowest, study_sim_serial_full_lowest_res, study_sim_serial_full_base_res


sim_regex=sim_regex_serial

rule study_sim_serial_2D_lowest_T_all_status:
    input:
        log_files=expand("results/sim/2D/{models}/simT/{stages}/ogs_pvd.log", models=model_lowest_all, stages=stages_all),
    params:
        case_names=['model',],
        reg=sim_regex_serial,
        x=5,
    container:
        ""
    log:
        notebook="results/studies/study_sim_serial_2D_lowest_T_all_status.ipynb"
    notebook:
        "../../notebooks/status.ipynb"


rule study_sim_serial_2D_lowest_THM_init_status:
    input:
        log_files = expand("results/sim/2D/{models}/simTHM/init/ogs_pvd.log", models=model_lowest_all)
    params:
        case_names=['model',],
        reg=sim_regex,
    log:
        notebook="results/studies/study_sim_serial_2D_lowest_THM_init_status.ipynb"
    notebook:
        "../../notebooks/status.ipynb"


rule study_sim_serial_2D_lowest_T_glacialcycle_status:
    input:
        log_files = expand("results/sim/2D/{models}/simT/glacialcycle/ogs_pvd.log", models=model_lowest_all)
    params:
        case_names=['model' ,],
        reg=sim_regex,
    log:
        notebook="results/studies/study_sim_serial_2D_lowest_T_glacialcycle_status.ipynb"
    notebook:
        "../../notebooks/status.ipynb"


rule study_sim_serial_2D_lowest_THM_glacialcycle_status:
    input:
        log_files = expand("results/sim/2D/{models}/simTHM/glacialcycle/ogs_pvd.log", models=model_lowest_all)
    params:
        case_names=['model' ,],
        reg=sim_regex,
    log:
        notebook="results/studies/study_sim_serial_2D_lowest_THM_glacialcycle_status.ipynb"
    notebook:
        "../../notebooks/status.ipynb"


rule study_sim_serial_3D_lowest_THM_init_status:
    input:
        log_files = expand("results/sim/3D/{models}/simTHM/init/ogs_pvd.log", models=model_lowest_all)
    params:
        case_names=['model' ,],
        reg=sim_regex,
    log:
        notebook="results/studies/study_sim_serial_3D_lowest_THM_init_status.ipynb"
    notebook:
        "../../notebooks/status.ipynb"


rule study_sim_serial_3D_lowest_T_init_status:
    input:
        log_files = expand("results/sim/3D/{models}/simT/init/ogs_pvd.log", models=model_lowest_all)
    params:
        case_names=['model' ,],
        reg=sim_regex,
    log:
        notebook="results/studies/study_sim_serial_3D_lowest_T_init_status.ipynb"
    notebook:
        "../../notebooks/status.ipynb"


rule study_sim_serial_3D_lowest_T_glacialcycle_status:
    input:
        pre_dim=rules.study_sim_serial_2D_lowest_T_glacialcycle_status.output,
        pre_stage=rules.study_sim_serial_3D_lowest_T_init_status.output,
        log_files = expand("results/sim/3D/{models}/simT/glacialcycle/ogs_pvd.log", models=model_lowest_all)
    params:
        case_names=['model' ,],
        reg=sim_regex,
    log:
        notebook="results/studies/study_sim_serial_3D_lowest_T_glacialcycle_status.ipynb"
    notebook:
        "../../notebooks/status.ipynb"


rule study_sim_serial_base_lowest:
    input:
        pre_stage=rules.study_sim_serial_3D_lowest_THM_init_status.output,
        pre_process=rules.study_sim_serial_3D_lowest_T_glacialcycle_status.output,
        pre_dim=rules.study_sim_serial_2D_lowest_THM_glacialcycle_status.output,
        log_files = expand("results/sim/3D/{models}/simTHM/glacialcycle/ogs_pvd.log", models=model_lowest_all)
    params:
        case_names=['model' ,],
        reg=sim_regex,
    log:
        notebook="results/studies/study_sim_serial_base_lowest.ipynb"
    notebook:
        "../../notebooks/status.ipynb"


rule study_sim_serial_full_lowest_res:
    input:
        log_files = expand("results/sim/{dims}/{models}/sim{processes}/glacialcycle/ogs_pvd.log", dims=dim_all, processes=process_all, models=model_lowest_all)
    log:
        notebook="results/studies/study_sim_serial_full_lowest_res.ipynb"
    notebook:
        "../../notebooks/status.ipynb"


rule study_sim_serial_full_base_res:
    input:
        log_files = expand("results/sim/{dims}/{models}/sim{processes}/glacialcycle/ogs_pvd.log", dims=dim_all, processes=process_all, models=model_base_all)
    log:
        notebook="results/studies/study_sim_serial_full_base_res.ipynb"
    notebook:
        "../../notebooks/status.ipynb"

