# Example runs:
#
#   snakemake -s container.smk --use-conda -j 1 -p --config ogs_process=LiquidFlow ogs_version=ogs/ogs@@55209ab2 results/container/ogs-serial.sif

version_string = c.ogs.version.replace('/', '-').replace('@', '_')

rule generate_serial_container:
    input:
        "workflow/envs/ogscm.yaml",
    params:
        ogs_version = c.ogs.version,
        ogs_process = c.ogs.process,
    shadow:
        "minimal"
    output:
        f"results/container/serial-{version_string}.sif",
    log:
        "results/container/serial.txt",
    conda:
        "../envs/ogscm.yaml"
    shell:
        "mkdir -p _out/images/results/container && "
        "ogscm compiler.py ogs.py --ogs {params.ogs_version} --cmake_args "
        "' -DBUILD_TESTING=OFF -DOGS_BUILD_PROCESSES={params.ogs_process}' "
        "-B -R -C --sif_file {output} > {log} 2>&1 && "
        "mv _out/images/{output} results/container"
