localrules: check_ogs, check_python, versions, version




rule version:
    container:
        None
    shell:
        """
        echo "AREHS Workflow installed and running"
        git describe --tags `git rev-list --tags --max-count=1`
        git rev-parse --short HEAD
        """

rule versions:
    output:
        "versions"
    shell:
        "GocadTSurfaceReader --version > versions"


rule check_python:
    output:
        "results/check/python_version.txt"
    shell:
        """
            python --version > {output}
            pip list >> {output}
       """

rule check_ogs:
    output:
        pip="results/check/py_ogs_version.txt",
        ogs="results/check/exec_ogs_version.txt"
    shell:
        """
        pip list > {output.pip} &&
        ogs --version > {output.ogs} && 
        whereis ogs >> {output.ogs}
        """

rule check_ogs_local:
    output:
        pip="results/check/py_ogs_version.txt",
        ogs="results/check/exec_ogs_version.txt"
    run:
        shell(
        """
        pip list > {output.pip} &&
        ogs --version > {output.ogs} && 
        whereis ogs >> {output.ogs}
        """
        )

rule check:
    input:
        rules.check_python.output,
        rules.check_ogs.output
