ruleorder: serial_model_from_parallel > sim_serial_result_link
ruleorder: sim_timeseries_from_parallel > sim_timeseries_from_serial


localrules:
    sim_serial_result_link,
    serial_model_from_parallel,
    sim_timeseries_from_serial,
    sim_timeseries_from_parallel,
    sim_parallel_result_link,
    serial_model_from_parallel

rule sim_serial_result_link:
    input:
        timeseries="{folder}/OGSoutput.pvd",
    output:
        result_link="{folder}/result.vtu",
    run:
        input_dir = Path(input.timeseries).parent
        result = etree.parse(input.timeseries).xpath("//DataSet[last()]/@file")[0]
        # NOTE: relpath only works with directories
        rel_path = os.path.relpath(input_dir, Path(output.result_link).parent)
        os.symlink(rel_path + "/" + result, output.result_link)


rule sim_parallel_result_link:
    input:
        timeseries="{folder}/OGSoutput.pvd",
    output:
        result_link="{folder}/result.pvtu",
    run:
        input_dir = Path(input.timeseries).parent
        result = etree.parse(input.timeseries).xpath("//DataSet[last()]/@file")[0]
        result_path = Path(result)
        extension = result_path.suffix

        print(extension)
        # NOTE: relpath only works with directories
        rel_path = os.path.relpath(input_dir, Path(output.result_link).parent)
        os.symlink(rel_path + "/" + result, output.result_link)


rule sim_timeseries_from_serial:
    input:
        timeseries="{folder}/OGSoutput.pvd",
    output:
        timeseries="{folder}/timeseries.pvd",
    shell:
        """
        cp {input.timeseries} {output.timeseries}
        """


rule sim_timeseries_from_parallel:
    input:
        timeseries="{folder}/parts_{partition}/OGSoutput.pvd",
    output:
        timeseries="{folder}/parts_{partition}/timeseries.pvd",
    script:
        "serial_timeseries_from_parallel.py"


rule serial_model_from_parallel:
    input:
        pvtu="{folder}/parts_{partition}/result.pvtu",
    output:
        vtu="{folder}/parts_{partition}/result.vtu",
    shell:
        """
        pvtu2vtu -i {input.pvtu} -o {output.vtu}
        """
