from lxml import etree
import subprocess
from pathlib import Path


def timeseries_pvtu2vtu(pvtu_timeseries_pvd, vtu_timeseries_pvd):
    input_dir = Path(pvtu_timeseries_pvd).parent
    files = etree.parse(pvtu_timeseries_pvd).xpath('//DataSet/@file')

    for pvtu_file in files:
        vtu_file=Path(pvtu_file)
        vtu_file = vtu_file.with_suffix('.vtu')
        print (input_dir/pvtu_file, input_dir/vtu_file)
        subprocess.call(["RemoveGhostData", "-i", input_dir/pvtu_file, '-o', input_dir/vtu_file])


    with open(pvtu_timeseries_pvd, 'r') as file :
        filedata = file.read()

    filedata = filedata.replace('.pvtu', '.vtu')

    with open(vtu_timeseries_pvd, 'w') as file:
        file.write(filedata)

timeseries_pvtu2vtu(snakemake.input[0], snakemake.output[0])

