localrules:
    ogs_to_metis,
    meshes_all,
    mesh_partition_optional,


rule ogs_to_metis:
    input:
        bulk="{any_fullpathname}.vtu",
    output:
        bulk_mesh="{any_fullpathname}.mesh",
    shell:
        "partmesh -i {input.bulk} "
        "-o $(dirname {output.bulk_mesh}) "
        "--ogs2metis"


# result_mesh = config['mesh_out_dir']


rule meshes_all:
    input:
        bulk_vtu="{folder}/domain.vtu",
        #source_vtus = "{folder}/subdomain/dgr_repo.vtu",
        #boundary_vtus = rules.all_boundary_vtus.input.boundary_vtus,
        subdomain_list="{folder}/subdomains.txt",
    output:
        domain_ids="{folder}/domain_with_ids.vtu",
        identified_flag="{folder}/identified",
    shell:
        """
        cp {input.bulk_vtu} {output.domain_ids}
        subdomains=$(cat {input.subdomain_list})
        echo $subdomains
        identifySubdomains -m {input.bulk_vtu} -o {wildcards.folder}/ -f -- $subdomains {output.domain_ids}
        touch {output.identified_flag}
        """


rule mesh_partition_optional:
    input:
        # bulk mesh
        metis_mesh="{folder}/domain.mesh",
        vtu="{folder}/domain.vtu",
        #subdomain_list="{folder}/subdomains.txt", # an identified mesh, already knows it subdomains (e.g. boundary meshes, repo ...)
        subdomain_identified="{folder}/identified",
    params:
        stem="{folder}/domain",
    output:
        files="{folder}/parts_{partition}/parallel_model",
        path=directory("{folder}/parts_{partition}"),
    shell:
        """
        mpath=$(python -c "from pathlib import Path; print(Path('{output.files}').parent)")
        ipath=$(python -c "from pathlib import Path; print(Path('{input.subdomain_identified}').parent)")
        subdomains=$(cat $ipath/subdomains.txt)
        echo $subdomains
        if [ {wildcards.partition} = 1 ]; then
            touch {output.files}
        else
            partmesh -m -n {wildcards.partition} -i {input.vtu} -x {params.stem} -o $mpath $subdomains
            touch {output.files}
        fi
        """
