localrules: sim_serial

rule sim_serial:
    input:
        prj_ogs=MODEL_DIR + f"{{model_folder}}/prj/sim.prj",
        mesh=MODEL_DIR + f"{{model_folder}}/mesh/linked",
    params:
        mesh_folder=directory(MODEL_DIR + f"{{model_folder}}/mesh"),
    output:
        time_series=SIM_DIR + f"{{model_folder}}/OGSoutput.pvd",
        out_folder=directory(SIM_DIR + f"{{model_folder}}/"),
    log:
        ogs_log=SIM_DIR + f"{{model_folder}}/ogs.log"
    container:
        config["container_serial"]
    shell:
        """
        #export OMP_NUM_THREADS=4
        ogs {input.prj_ogs} -o  {output.out_folder} -m {params.mesh_folder} > {log.ogs_log}
        """


parallel_run="slurm"
if "parallel_run" in config:
    parallel_run=config["parallel_run"]
else:
    localrules: sim_serial
    rule sim_serial:
        input:
            prj_ogs=MODEL_DIR + f"{{model_folder}}/prj/sim.prj",
            mesh=MODEL_DIR + f"{{model_folder}}/mesh/linked",
        params:
            mesh_folder=directory(MODEL_DIR + f"{{model_folder}}/mesh"),
        output:
            time_series=SIM_DIR + f"{{model_folder}}/OGSoutput.pvd",
            ogs_log=SIM_DIR + f"{{model_folder}}/ogs.log",
            out_folder=directory(SIM_DIR + f"{{model_folder}}/"),
        container:
            config["container_serial"]
        shell:
            """
            #export OMP_NUM_THREADS=4
            ogs {input.prj_ogs} -o  {output.out_folder} -m {params.mesh_folder} | tee {output.ogs_log}
            """


if parallel_run == "mpi":

    ruleorder: sim_mpi > sim_serial

    rule sim_mpi:
        input:
            prj_ogs=MODEL_DIR + f"{{model_folder}}/parts_{{partition}}/prj/sim.prj",
            mesh=directory(MODEL_DIR + f"{{model_folder}}/parts_{{partition}}/mesh"),
        output:
            time_series=SIM_DIR + f"{{model_folder}}/parts_{{partition}}/OGSoutput.pvd",
            ogs_log=SIM_DIR + f"{{model_folder}}/parts_{{partition}}/ogs.log",
            out_folder=directory(SIM_DIR + f"{{model_folder}}/parts_{{partition}}/"),
        threads: get_threads
        container:
            config["container_parallel"]
        shell:
            """
            mpirun -np {threads} ogs {input.prj_ogs} -o  {output.out_folder} -m {input.mesh} | tee {output.ogs_log}
            """


if parallel_run== "slurm_interactive":

    localrules:
        sim_slurm_interactive

    ruleorder: sim_slurm_interactive > sim_serial

    rule sim_slurm_interactive:
        input:
            prj_ogs=MODEL_DIR + f"{{model_folder}}/parts_{{partition}}/prj/sim.prj",
            mesh=directory(MODEL_DIR + f"{{model_folder}}/parts_{{partition}}/mesh"),
        output:
            time_series=SIM_DIR + f"{{model_folder}}/parts_{{partition}}/OGSoutput.pvd",
            ogs_log=SIM_DIR + f"{{model_folder}}/parts_{{partition}}/ogs.log",
            out_folder=directory(SIM_DIR + f"{{model_folder}}/parts_{{partition}}/"),
        threads: 
            1
        container:
            None
        params:
            ogsbin=config["ogsbin"],
            glaciationBCs=config["glaciationBCs"],
            sitepackages=config["sitepackages"]
        envmodules:
            "Stages/2023 GCC/11.3.0 ParaStationMPI/5.7.0-1 PETSc/3.18.5 HDF5/1.12.2 imkl/2022.1.0 Python/3.10.4 X11/20220504"
        shell:
            """
            export PATH={params.ogsbin}:$PATH
            export PYTHONPATH={params.glaciationBCs}:{params.sitepackages}
            srun --account=ogs6hpc4 -n {wildcards.partition} ogs {input.prj_ogs} -o  {output.out_folder} -m {input.mesh} | tee {output.ogs_log}
            """


if parallel_run== "slurm":

    ruleorder: sim_slurm > sim_serial

    rule sim_slurm:
        input:
            prj_ogs=MODEL_DIR + f"{{model_folder}}/parts_{{partition}}/prj/sim.prj",
            mesh=directory(MODEL_DIR + f"{{model_folder}}/parts_{{partition}}/mesh"),
        output:
            time_series=SIM_DIR + f"{{model_folder}}/parts_{{partition}}/OGSoutput.pvd",
            ogs_log=SIM_DIR + f"{{model_folder}}/parts_{{partition}}/ogs.log",
            out_folder=directory(SIM_DIR + f"{{model_folder}}/parts_{{partition}}/"),
        threads: 
            1
        container:
            None
        params:
            ogsbin=config["ogsbin"],
            glaciationBCs=config["glaciationBCs"],
            sitepackages=config["sitepackages"]
        envmodules:
            "Stages/2023 GCC/11.3.0 ParaStationMPI/5.7.0-1 PETSc/3.18.5 HDF5/1.12.2 imkl/2022.1.0 Python/3.10.4 X11/20220504"
        shell:
            """
            export PATH={params.ogsbin}:$PATH
            export PYTHONPATH={params.glaciationBCs}:{params.sitepackages}
            srun ogs {input.prj_ogs} -o {output.out_folder} -m {input.mesh} | tee {output.ogs_log}
            """
# mv $base_output_path/hdf5_cube_ht_benchmark/${SLURM_JOB_ID}-out.txt $output_path/xout.txt
# mv $base_output_path/hdf5_cube_ht_benchmark/${SLURM_JOB_ID}-err.txt $output_path/xerr.txt

if parallel_run== "slurm_ps":

    ruleorder: sim_slurm_ps > sim_serial

    rule sim_slurm_ps:
        input:
            prj_ogs=MODEL_DIR + f"{{model_folder}}/parts_{{partition}}/prj/sim.prj",
            mesh=directory(MODEL_DIR + f"{{model_folder}}/parts_{{partition}}/mesh"),
        output:
            time_series=SIM_DIR + f"{{model_folder}}/parts_{{partition}}/OGSoutput.pvd",
            ogs_log=SIM_DIR + f"{{model_folder}}/parts_{{partition}}/ogs.log",
            out_folder=directory(SIM_DIR + f"{{model_folder}}/parts_{{partition}}/"),
        threads: 
            1
        container:
            None
        params:
            ogsbin=config["ogsbin"],
            glaciationBCs=config["glaciationBCs"],
            sitepackages=config["sitepackages"]
        envmodules:
            "Stages/2023 GCC/11.3.0 ParaStationMPI/5.7.0-1 PETSc/3.18.5 HDF5/1.12.2 imkl/2022.1.0 Python/3.10.4 X11/20220504 Valgrind/3.19.0"
        shell:
            """
            export PATH={params.ogsbin}:$PATH
            export PYTHONPATH={params.glaciationBCs}:{params.sitepackages}
            srun valgrind --tool=massif ogs {input.prj_ogs} -o {output.out_folder} -m {input.mesh} | tee {output.ogs_log}
            """

# To run:           module load Stages/2023 GCC/11.3.0 ParaStationMPI PETSc HDF5/1.12.2 imkl Python X11/20220504
#                   Python is called from OGS
#                   X11 is needed because of pyvista used in Python from OGS
#                   imkl is for ScaLAPACK
#                   HDF5 is for output
# To build:         module load CMake/3.23.1 Ninja/1.10.2 git Eigen Boost
# To investigate:   module load Valgrind/3.19.0