localrules:
    model_serial,
    model_parallel,
    model_init_link_to_boundary_results,


use rule sim_serial_result_link as model_init_link_to_boundary_results with:
    input:
        timeseries=SIM_DIR + f"2D/{MODEL}_{MESH}/{{boundary_stage}}/simTH/OGSoutput.pvd",
    output:
        # TODO: maybe move the boundary sim results to the mesh folder
        result_link=MODEL_DIR
        + f"3D/{MODEL}_{MESH}/{{stage}}/{{project}}/prj/{{boundary_stage}}_result.vtu",


# TODO: add initial results link for 2D prism as well.
#       all init sims don't need lateral H-BCs
#       output results on lateral bounds as well and link to them
#       use them in the BCs for 2D as well


# TODO: maybe split into rule for PRJ and for model which then get aggregated?
# TODO: from shell to pure python (no bins from container necessary)


# collect a) project and b) mesh
# b) a identified mesh, contains domain, subdomains
rule model_serial:
    input:
        prj=lambda wcs: OUT_DIR
        + "prj/{rank}D/{mesh_name}_{mesh_type}-id_{layer_set_id}/{project}/"
        + stage_type(wcs)
        + "/sim.prj",
        bcs=lambda wcs: OUT_DIR
        + "prj/{rank}D/{mesh_name}_{mesh_type}-id_{layer_set_id}/{project}/"
        + stage_type(wcs)
        + "/boundary_conditions.py",
        identified_mesh=lambda wcs: MSH_DIR
        + f"{{rank}}D/{MODEL}_{MESH}/{{stage}}/"
        + [wcs.project + "/" if wcs.stage == "glacialcycle" else ""][0]
        + "identified",
        boundary_result_link=lambda wcs: [
            MODEL_DIR + f"3D/{MODEL}_{MESH}/{{stage}}/{{project}}/prj/{b}_result.vtu"
            for b in ["front", "back"]
            if wcs.rank == "3"
            and wcs.stage in ["init", "glacialcycle"]
            and wcs.mesh_type == "prism"
        ],
    output:
        prj_ogs=MODEL_DIR
        + f"{{rank}}D/{MODEL}_{MESH}/{{stage}}/{{project}}/prj/sim.prj",
        mesh_linked=MODEL_DIR
        + f"{{rank}}D/{MODEL}_{MESH}/{{stage}}/{{project}}/mesh/linked",
    params:
        mesh_dirlink=directory(
            MODEL_DIR + f"{{rank}}D/{MODEL}_{MESH}/{{stage}}/{{project}}/mesh"
        ),
    shell:
        """
        input_prj_dir=$(python -c "from pathlib import Path; print(Path('{input.prj}').parent)")
        input_mesh_dir=$(python -c "from pathlib import Path; print(Path('{input.identified_mesh}').parent)")
        model_dir=$(python -c "from pathlib import Path; print(Path('{output.prj_ogs}').parent)")
        # PRJ
        cp -r $input_prj_dir/. $model_dir

        # MESH
        mkdir -p {params.mesh_dirlink}

        ln -rsf $input_mesh_dir/* {params.mesh_dirlink}
        touch {output.mesh_linked}

        """


# model_parallel extends the model_seriel
# boundary conditions, and boundary_result_link are part of the serial model
rule model_parallel:
    input:
        prj_ogs=rules.model_serial.output.prj_ogs,
        mesh_dirlink=lambda wcs: f"results/mesh/{{rank}}D/{MODEL}_{MESH}/{{stage}}/"
        + [wcs.project + "/" if wcs.stage == "glacialcycle" else ""][0]
        + "parts_{partition}/parallel_model",
    output:
        prj_ogs=MODEL_DIR
        + f"{{rank}}D/{MODEL}_{MESH}/{{stage}}/{{project}}/parts_{{partition}}/prj/sim.prj",
        mesh_dirlink=directory(
            MODEL_DIR
            + f"{{rank}}D/{MODEL}_{MESH}/{{stage}}/{{project}}/parts_{{partition}}/mesh"
        ),
    shell:
        """
        input_prj_dir=$(python -c "from pathlib import Path; print(Path('{input.prj_ogs}').parent/'*')")
        output_prj_dir=$(python -c "from pathlib import Path; print(Path('{output.prj_ogs}').parent)")
        input_mesh_dir=$(python -c "from pathlib import Path; print(Path('{input.mesh_dirlink}').parent)")
        input_serial_mesh_dir=$(python -c "from pathlib import Path; print(Path('{input.mesh_dirlink}').parent.parent)")
        output_serial_mesh_dir=$(python -c "from pathlib import Path; print(Path('{output.mesh_dirlink}').parent)")
        # PRJ
        ln -rsf $input_prj_dir $output_prj_dir

        # MESH
        mkdir -p {output.mesh_dirlink}
        ln -rsf $input_mesh_dir/* {output.mesh_dirlink}
        ln -rsf $input_serial_mesh_dir/domain.vtu {output.mesh_dirlink}/domain.vtu
        """
