localrules: unix_data, surface_data
localrules: mesh_toy, mesh_prism, mesh_3D_voxel, mesh_boundary_stage
localrules: mesh_source_terms, mesh_source_terms_empty
localrules: mesh_subdomains
localrules: mesh_3D_repo, mesh_2D_repo, mesh_repo_layer
localrules: mesh_boundaries, mesh_subdomains_boundaries_2D, mesh_subdomains_boundaries_3D


if "default_sim_init_cores" not in config:
    init_cores=1
else:
    init_cores=config["default_sim_init_cores"]

if init_cores >=2:
    localrules: mesh_domain_from_init_sim_parallel
    ruleorder: mesh_domain_from_init_sim_parallel>mesh_domain_from_init_sim_serial
else:
    localrules: mesh_domain_from_init_sim_serial
    ruleorder: mesh_domain_from_init_sim_serial>mesh_domain_from_init_sim_parallel



rule unix_data:
    input:
        "input/models/{mesh_name}/Basisflaechen_{mesh_name}.ts"
    output:
        OUT_DIR+"unix_data/model_{mesh_name}.ts"
    shell:
        "dos2unix -n {input} {output}"


rule surface_data:
    input:
        rules.unix_data.output
    output:
        o1=directory(OUT_DIR+"surface_data/{mesh_name}/")
    shell:
        "mkdir {output.o1} && GocadTSurfaceReader -i {input} -o {output.o1}"


rule mesh_toy:
    input:
        toys_csv=SET_TABLE,
        surface=rules.surface_data.output.o1,
        parameters_csv=PARAM_TABLE,
        toy_py="ogsworkflowhelper/toy.py",
        #TODO: add same functionality to prism models
        add_peff_py="ogsworkflowhelper/post_processing/result_add_peff.py"
    output:
        domain_mesh_temp = temp(MSH_DIR+f"{{rank}}D/{{mesh_name}}_{TOY_PARAMS}/init/domain_temp.vtu"),
        domain_mesh = MSH_DIR+f"{{rank}}D/{{mesh_name}}_{TOY_PARAMS}/init/domain.vtu"
    shell:
        """
        python {input.toy_py} {wildcards.layer_set_id} {wildcards.x_res} 1 {wildcards.rank} {wildcards.mesh_name} {input.toys_csv} {input.surface} {output.domain_mesh_temp} {input.parameters_csv}
        python {input.add_peff_py} {output.domain_mesh_temp} {output.domain_mesh}
        """


rule mesh_prism:
    input:
        toys_csv=SET_TABLE,
        surface=rules.surface_data.output.o1,
        parameters_csv=PARAM_TABLE,
        prism_py="ogsworkflowhelper/prism_mesh.py",
        # TODO: automatically generate gml or substitue with other logic
        gml = "input/models/{mesh_name}/{mesh_name}_{rank}D.gml"
    output:
        domain_mesh = MSH_DIR+f"{{rank}}D/{{mesh_name}}_{PRISM_PARAMS}/init/domain.vtu",
        repo_layers=MSH_DIR+f"{{rank}}D/{{mesh_name}}_{PRISM_PARAMS}/init/repo_layers.txt",
        raster=MSH_DIR+f"{{rank}}D/{{mesh_name}}_{PRISM_PARAMS}/init/Raster.vtu"
    log:
        log=MSH_DIR+f"{{rank}}D/{{mesh_name}}_{PRISM_PARAMS}/init/log.txt"
    shell:
        """
        python {input.prism_py} {input.toys_csv} {input.parameters_csv} {input.surface} {input.gml} {output.domain_mesh} {wildcards.layer_set_id} {wildcards.x_res} {wildcards.rank} > {log.log}
        """


rule mesh_3D_voxel:
    input:
        surface = rules.surface_data.output.o1,
    output:
        domain_mesh = MSH_DIR+f"3D/{{mesh_name}}_{VOXEL_PARAMS}/init/domain.vtu"
    shell:
        """
            find {input.surface} -regextype posix-extended -regex '.*/[0-9][0-9]_[a-zA-Z]*[^_]*.(vtu|xdmf|hdf)' | sort -n  | tee myfile.txt
            Layers2Grid -i myfile.txt -o {output.domain_mesh} -x {wildcards.x_res} -y {wildcards.y_res} -z {wildcards.z_res}
        """


rule mesh_boundary_stage:
    input:
        subdomain_mesh=MSH_DIR+f"3D/{{mesh_name}}_{MESH_PARAMS}/init/boundaries/{{boundary_stage}}_surf.vtu",
        swap_xyz_py = "ogsworkflowhelper/swap_coordinates.py"
    output:
        domain_mesh=MSH_DIR+f"2D/{{mesh_name}}_{MESH_PARAMS}/{{boundary_stage}}/domain.vtu",
        #sourceterm_list=MSH_DIR+f"2D/{{mesh_name}}_{MESH_PARAMS}/{{boundary_stage}}/sourceterms.txt"
    shell:
        """
        python {input.swap_xyz_py} --input {input.subdomain_mesh} --output {output.domain_mesh} --swap_coords xzy
        NodeReordering -i {output.domain_mesh} -o {output.domain_mesh}
        """


rule mesh_domain_from_init_sim_serial:
    input:
        domain=OUT_DIR+f"sim/{RANK}/{MODEL}_{MESH}/init/{{project}}/result.vtu",
        result_as_init_py="ogsworkflowhelper/post_processing/result_as_init.py",
        add_peff_py="ogsworkflowhelper/post_processing/result_add_peff.py"
    output:
        domain_temp=temp(MSH_DIR+f"{RANK}/{MODEL}_{MESH}/glacialcycle/{{project}}/domain_temp.vtu"),
        domain=MSH_DIR+f"{RANK}/{MODEL}_{MESH}/glacialcycle/{{project}}/domain.vtu",
    shell:
        """
        python {input.result_as_init_py} {input.domain} {output.domain_temp} -point_data epsilon displacement -field_data epsilon_ip
        python {input.add_peff_py} {output.domain_temp} {output.domain}
        """


rule mesh_domain_from_init_sim_parallel:
    input:
        domain=config['result_out_dir']+f"sim/{RANK}/{MODEL}_{MESH}/init/{{project}}/parts_"+str(init_cores)+"/result.vtu",
        result_as_init_py="ogsworkflowhelper/post_processing/result_as_init.py",
        add_peff_py="ogsworkflowhelper/post_processing/result_add_peff.py"
    output:
        domain_temp=temp(MSH_DIR+f"{RANK}/{MODEL}_{MESH}/glacialcycle/{{project}}/domain_temp.vtu"),
        domain=MSH_DIR+f"{RANK}/{MODEL}_{MESH}/glacialcycle/{{project}}/domain.vtu",
    shell:
        """
        python {input.result_as_init_py} {input.domain} {output.domain_temp} -point_data epsilon displacement -field_data epsilon_ip
        python {input.add_peff_py} {output.domain_temp} {output.domain}
        """





subdomains = {
    "2": [b + "_line.vtu" for b in ["top", "bottom", "left", "right"]],
    "3": [b + "_surf.vtu" for b in ["top", "bottom", "left", "right", "front", "back"]]}

rule mesh_subdomains_boundaries_2D:
    input:
        domain_mesh = "{folder}/domain.vtu",
        subdomains_2D_py = "ogsworkflowhelper/subdomains_from_2D_boundary.py"
    output:        
        boundary = temp("{folder}/domain_boundary.vtu"),
        subdomains = expand("{folder}/boundaries/{n}", n = subdomains["2"], allow_missing=True)
    shell:
        """
        ExtractBoundary -i {input.domain_mesh} -o {output.boundary}
        python {input.subdomains_2D_py} {output.boundary} "30" {wildcards.folder}/boundaries/ "_line"
        """


rule mesh_subdomains_boundaries_3D:
    input:
        domain_mesh = "{folder}/domain.vtu",
        boundaries_py="ogsworkflowhelper/boundaries.py"
    output:
        subdomains = expand("{folder}/boundaries/{n}", n = subdomains["3"], allow_missing=True)
    shell:
        """
        python {input.boundaries_py} {input.domain_mesh} 3 {wildcards.folder}/boundaries
        """

def add_content(file1, file2, result_file):
    # Reading data from file1
    with open(file1) as fp:
        data1 = fp.read()

    # Reading data from file2
    with open(file2) as fp:
        data2 = fp.read()

    data1 += "\n"
    data1 += data2
    with open (result_file, 'w') as fp:
        fp.write(data1)


rule mesh_boundaries:
    input:
        boundaries=lambda wcs: expand("{mesh_out_dir}{rank}D/{mesh_folder}/boundaries/{n}", mesh_out_dir=MSH_DIR, rank=wcs.rank, n=subdomains[wcs.rank], allow_missing=True)
    output:
        boundaries_list=MSH_DIR+ "{rank}D/{mesh_folder}/boundaries.txt"
    run:
        aggregate(input.boundaries, output.boundaries_list)


ruleorder: mesh_source_terms > mesh_source_terms_empty

rule mesh_source_terms:
    input:
        #sourceterms=lambda wcs: ["{folder}/{stage}/{process}/repo.vtu"] if wcs.stage == "glacialcycle" else [],
        sourceterms=lambda wcs: ancient(["{folder}/glacialcycle/{process}/repo.vtu"]) if "T" in wcs.process else [""]
    output: 
        sourceterm_list="{folder}/glacialcycle/{process}/sourceterms.txt"
    shell:
        """
        ls {input.sourceterms} >> {output.sourceterm_list}
        """

# ToDo 
rule mesh_source_terms_empty:
    input:
        sourceterms=[],
    output: 
        sourceterm_list="{folder}/sourceterms.txt"
    shell:
        """
        touch {output.sourceterm_list}
        """


rule mesh_subdomains:
    input:
        boundaries = rules.mesh_boundaries.output.boundaries_list,
        sourceterms = MSH_DIR+ "{rank}D/{mesh_folder}/sourceterms.txt"
    output:
        boundaries_list=MSH_DIR+ "{rank}D/{mesh_folder}/subdomains.txt"
    run:
        add_content(input.boundaries, input.sourceterms, output.boundaries_list)


def repo_id(wcs):
    process = wcs.project.replace("sim", "").split("-")[0]
    csv = PARAM_TABLE.format(mesh_name=wcs.mesh_name)
    sets = SET_TABLE.format(mesh_name=wcs.mesh_name)
    df = csv2pandas(int(wcs.layer_set_id), csv, sets, process)
    repo_id = df[df["model_unit"] == "repo"]["layer_id"].values
    return repo_id[0] if repo_id else None


REPO_PATH = MSH_DIR+f"{{rank}}D/{{mesh_name}}_{MESH_PARAMS}/glacialcycle/{{project}}/"
REPO_2D_PATH = MSH_DIR+f"2D/{{mesh_name}}_{MESH_PARAMS}/glacialcycle/{{project}}/"
REPO_3D_PATH = MSH_DIR+f"3D/{{mesh_name}}_{MESH_PARAMS}/glacialcycle/{{project}}/"
rule mesh_repo_layer:
    input:
        domain=REPO_PATH + "domain.vtu"
    params:
        folder=REPO_PATH,
        repo_id=repo_id
    output:
        repo_layer=REPO_PATH + "repo_layer.vtu"
    shell:
        """
            ExtractMaterials -i {input.domain} -o {params.folder}repo.vtu -m {params.repo_id}
            mv {params.folder}repo_Layer{params.repo_id}.vtu {output.repo_layer}
        """

rule mesh_2D_repo:
    input:
        repo_layer=REPO_2D_PATH + "repo_layer.vtu",
        crop_repo_py="ogsworkflowhelper/crop_repo.py",
    output:
        repo_line=REPO_2D_PATH + "repo_line.vtu",
        repo_vtu=REPO_2D_PATH + "repo.vtu"
    shell:
        """
            ExtractBoundary -i {input.repo_layer} -o {output.repo_line}
            python {input.crop_repo_py} 2 {output.repo_line} {wildcards.mesh_name} {output.repo_vtu}
        """


rule mesh_3D_repo:
    input:
        repo_layer=REPO_3D_PATH + "repo_layer.vtu",
        crop_repo_py="ogsworkflowhelper/crop_repo.py"
    output:
        repo_surf=REPO_3D_PATH + "repo_surf.vtu",
        repo_vtu=REPO_3D_PATH + "repo.vtu"
    shell:
        """ 
            ExtractSurface -i {input.repo_layer} -o {output.repo_surf} -x 0 -y 0 -z 1 
            python {input.crop_repo_py} 3 {output.repo_surf} {wildcards.mesh_name} {output.repo_vtu}
        """

# TODO: single rule for identify subdomains
# =======================================================
# TODO: take top and bottom surf from raster to mesh vtus
# =======================================================