sf=["11-xres_332","12-xres_166","13-xres_83","14-xres_41.5","15-xres_20.75"]
sk=["11-xres_272","12-xres_136","13-xres_68","14-xres_34","15-xres_17"]
tn=["21-xres_188","22-xres_94","23-xres_47","24-xres_23.5"]
ts=["21-xres_200","22-xres_100","23-xres_50","24-xres_25"]
# after merge
# ts=["21-xres_200","22-xres_100","23-xres_50","24-xres_25","25-xres_11.5"]
tk=["11-xres_400","12-xres_200","13-xres_100","14-xres_50","15-xres_25"]

report_type=["spatial", "temporal"]
parts=[96]


# with v1.0 (no patches)
rule final_report:
    input:
       # 2D Convergence
       SF_2D=expand("results/sim/2D/Salz-flach_toy-id_{res}/glacialcycle/simTHM/parts_{parts}/OGSoutput.pvd", res=sf, parts= parts),
       SK_2D=expand("results/sim/2D/Salz-Kissen_toy-id_{res}/glacialcycle/simTHM/parts_{parts}/OGSoutput.pvd", res=sk, parts= parts),
       TN_2D=expand("results/sim/2D/Ton-Nord_toy-id_{res}/glacialcycle/simTHM/parts_{parts}/OGSoutput.pvd", res=tn, parts= parts),
       TS_2D=expand("results/sim/2D/Ton-Sued_toy-id_{res}/glacialcycle/simTHM/parts_{parts}/OGSoutput.pvd", res=ts, parts= parts),
       TK_2D=expand("results/sim/2D/Ton-Kristallin_toy-id_{res}/glacialcycle/simTHM/parts_{parts}/OGSoutput.pvd" , res=tk, parts= parts),
       # 2D report results
       # finest resolution (2nd finest to compare)
       TN_P2D= expand("results/plot/2D/Ton-Nord_prism-id_{res}/glacialcycle/simTHM/parts_{parts}/{report}/report.pdf", res=tn[-2:], parts=parts, report=report_type),
       SF_P2D= expand("results/plot/2D/Salz-flach_prism-id_{res}/glacialcycle/simTHM/parts_{parts}/{report}/report.pdf", res=sf[-2:], parts=parts, report=report_type),
       SK_P2D= expand("results/plot/2D/Salz-Kissen_prism-id_{res}/glacialcycle/simTHM/parts_{parts}/{report}/report.pdf", res= sk[-2:], parts=parts, report=report_type),

       # 3D report
       # lower bound of convergence study (coarse resolution)
       TN_P3D=expand("results/plot/3D/Ton-Nord_prism-id_{res}/glacialcycle/sim{process}/parts_{parts}/{report}/report.pdf", res=tn[0], process=["T", "HM"], report=report_type, parts= parts),
       TS_P3D=expand("results/plot/3D/Ton-Sued_prism-id_{res}/glacialcycle/sim{process}/parts_{parts}/{report}/report.pdf", res=ts[0], process=["T", "HM"], report=report_type, parts= parts),
       SF_P3D=expand("results/plot/3D/Salz-flach_prism-id_{res}/glacialcycle/sim{process}/parts_{parts}/{report}/report.pdf", res=sf[0], process=["T", "HM", "THM"], report=report_type, parts= parts),
       SK_P3D=expand("results/plot/3D/Salz-Kissen_prism-id_{res}/glacialcycle/sim{process}/parts_{parts}/{report}/report.pdf", res=sk[0], process=["T", "HM", "THM"], report=report_type, parts= parts),


# with modification of simTHM_glacialcycle.prj 
#            <numerical_stabilization>
#                <type>IsotropicDiffusion</type>
#                <tuning_parameter>0.4</tuning_parameter>
#                <cutoff_velocity>1.e-9</cutoff_velocity>
#            </numerical_stabilization>
rule final_report_1:
    input: 
        "results/plot/3D/Ton-Nord_prism-id_21-xres_188/glacialcycle/simTHM/{spatial,temporal}/report.pdf"







#i=expand("results/sim/2D/model_Ton-Nord_toy-id_6-xres_60-factor_4/sim{_project_}/glacialcycle/parts_{parts}/OGSoutput_xdmf.log",_project_=['T','TH'],parts=[1,2,3,4])