# Alternative: OGS_DIR=$HOME/o/
OGS_DIR=/p/project/ogs6hpc4/dgr/o
BIN_DIR=arehs
ENV=juwels

# For running ogs
module load Stages/2023 GCC/11.3.0 ParaStationMPI/5.7.0-1 PETSc/3.18.5 HDF5/1.12.2 imkl/2022.1.0 Python/3.10.4 X11/20220504
# Additionally for buildung ogs
module load CMake/3.23.1 Ninja/1.10.2 Eigen/3.4.0 Boost Boost/1.79.0 git/2.36.0-nodocs

BUILD_DIR=$OGS_DIR/build/$BIN_DIR/

mkdir -p $OGS_DIR/build/cpm_cache_ps
mkdir -p $BUILD_DIR
cd $BUILD_DIR

export CMAKE_BUILD_PARALLEL_LEVEL=1
export CPM_SOURCE_CACHE=$OGS_DIR/build/cpm_cache_ps

source /p/software/juwels/stages/2023/software/imkl/2022.1.0/setvars.sh
echo $LD_LIBRARY_PATH
CC=`which mpicc` CXX=`which mpic++` cmake $OGS_DIR/s -G Ninja -DCMAKE_BUILD_TYPE=Release -DOGS_EIGEN_DYNAMIC_SHAPE_MATRICES=Off -DOGS_USE_PCH=Off -DOGS_USE_PETSC=On -DOGS_CPU_ARCHITECTURE=OFF -DOGS_BUILD_TESTING=OFF -DOGS_BUILD_METIS=On -DOGS_USE_POETRY=OFF -DOGS_BUILD_PROCESSES="LiquidFlow;HydroMechanics;HeatConduction;ComponentTransport;ThermoHydroMechanics;SmallDeformation;HT"  -DOGS_USE_MFRONT=On -DOGS_BUILD_SHARED_LIBS=ON -DOGS_USE_UNITY_BUILDS=Off -DOGS_USE_MKL=On 

ninja -j 8