#!/bin/bash
# properties = {properties}

#SBATCH --nodes=1
#SBATCH --ntasks=4
#SBATCH --ntasks-per-node=4

#SBATCH --output=/p/scratch/ogs6hpc4/dgr/%j-out.txt
#SBATCH --error=/p/scratch/ogs6hpc4/dgr/%j-err.txt

#SBATCH --time=00:03:00
#SBATCH --partition=batch

#SBATCH --mail-user tobias.meisel@ufz.de
#SBATCH --mail-type ALL

#SBATCH --account=ogs6hpc4


# local generic
project_path=/p/project/ogs6hpc4/tobias

# local OGS
export PATH=$project_path/o/build/rp_arehs3/bin:$PATH

# local glaciationBCs
export PYTHONPATH=$project_path/glaciationBCs/src
# contains all dependencies of glaciationBCs/src
source $project_path/venvs/arehs_py39/bin/activate


module load X11/20210802
module load GCC ParaStationMPI Python Eigen PETSc Boost git
module load darshan-runtime


#apptainer shell docker://registry.opengeosys.org/ogs/ogs/ogs-dgr:latest
#srun ogs --version
#sleep 1
#touch results/sim/2D/model_Ton-Nord_toy-id_6-xres_405-factor_1/simTHM/init/parts_4/OGSoutput.pvd

{exec_job}
