from aggregate_templates import aggregate_templates
from csv2prj import csv2pandas
import argparse

if __name__ == '__main__':
    """
    Aggregates a list of template media xml files to one file, while adding
    the corresponding ids according to a pandas dataframe
    """

    parser = argparse.ArgumentParser()
    parser.add_argument("param_table", help="material parameter csv")
    parser.add_argument("set_table", help="set definitions csv")
    parser.add_argument("medium", help="template medium xml")
    parser.add_argument("project", help="project name, e.g. simTHM[-subtype]")
    parser.add_argument("set_id", help="set ID of model", type=int)
    parser.add_argument("out_xml", help="resulting xml file")
    args = parser.parse_args()

    process = args.project.replace("sim", "").split("-")[0]
    param_df = csv2pandas(args.set_id, args.param_table, args.set_table, process)
    media_xpath = ".//property[name='{0}'][value='placeholder']/value"
    aggregate_templates(param_df, args.medium, args.out_xml, media_xpath)