from aggregate_templates import aggregate_templates
from csv2prj import csv2pandas
import argparse

if __name__ == '__main__':
    """
    Aggregates a list of template media xml files to one file, while adding
    the corresponding ids according to a pandas dataframe
    """

    parser = argparse.ArgumentParser()
    parser.add_argument("param_table", help="material parameter csv")
    parser.add_argument("set_table", help="set definitions csv")
    parser.add_argument("project", help="project name, e.g. simTHM[-subtype]")
    parser.add_argument("set_id", help="set ID of model", type=int)
    parser.add_argument("out_xml", help="resulting xml file")
    parser.add_argument("mat_laws", help="material law xmls", nargs="+")
    args = parser.parse_args()

    process = args.project.replace("sim", "").split("-")[0]
    param_df = csv2pandas(args.set_id, args.param_table, args.set_table, process)
    aggregate_templates(param_df, args.mat_laws, args.out_xml)