import argparse
import pyvista as pv


def rotate(input: str, output: str, swap_coords: str):
    mesh = pv.XMLUnstructuredGridReader(input).read()
    swap_ints = ["xyz".index(s) for s in swap_coords]
    mesh.points[:, [0, 1, 2]] = mesh.points[:, swap_ints]

    mesh.save(output)

if __name__ == '__main__':
    """
    Swaps two coordinates
    """

    parser = argparse.ArgumentParser()
    parser.add_argument("--input", help="input meshes", nargs="+")
    parser.add_argument("--output", help="output meshes", nargs="+")
    parser.add_argument("--swap_coords", help="e.g. yxz to swap from xyz to yxz")
    
    args = parser.parse_args()
    if len(args.input) != len(args.output):
        raise Exception("input and output lists have to have the same length!")

    for file_in, file_out in zip(args.input, args.output):
        rotate(file_in, file_out, args.swap_coords)