from paraview.simple import *
import argparse

ap = argparse.ArgumentParser()
ap.add_argument("-i", "--input", help="pvd input file", required=True)
args = vars(ap.parse_args())

file_in = args.get("input")
pvd = PVDReader(FileName=file_in)

passArrays1 = PassArrays(registrationName='PassArrays1', Input=pvd)
PointDataNames = [n.Name for n in pvd.PointData[:]]
PointDataNames.remove("displacement")
PointDataNames.remove("epsilon")
passArrays1.PointDataArrays = PointDataNames
passArrays1.CellDataArrays = [n.Name for n in pvd.CellData[:]]
passArrays1.FieldDataArrays = [n.Name for n in pvd.FieldData[:]]

# save data
SaveData('testslice_result.vtu', proxy=passArrays1)