import pyvista as pv
import argparse

def result_as_init(init_filename, result_filename, point_datas=[], cell_datas=[], field_datas=[]):
    mesh = pv.read(init_filename)
    
    pd = mesh.point_data
    for p in point_datas:
        if p in pd.keys():
            pd.remove(p)
        else:
            print("Warning: ", p, " is not in point data")
    

    fd = mesh.field_data
    for f in field_datas:
        if f in fd.keys():
            fd.remove(f)
        else:
            print("Warning: ", f, " is not in field data")

        
    cd = mesh.cell_data
    for c in cell_datas:
        if c in cd.keys():
            cd.remove(c)
        else:
            print("Warning: ", c, " is not in cell data")
        
    mesh.save(result_filename)
    
   

if __name__ == '__main__':
    print("loaded")
    """ Removes data from vtu files


    result_filename: e.g.'testslice_init_t_3e+13.vtu'
    init_filename: e.g. 'testslice.vtu'
    point_data: "'epsilon','displacement'"
    cell_data: "'MaterialID'"
    field_data: "'epsilon_ip'"


    """

    parser = argparse.ArgumentParser()
    parser.add_argument("read_file", help="full path name to file to be read, e.g. testslice_init_t_3e+13.vtu",
                        type=str)
    parser.add_argument("write_file", help="full path name to file to be written, e.g. testslice.vtu")
    
    parser.add_argument("-point_data", default=[], nargs='+',help="e.g. -point_data epsilon displacement")
    parser.add_argument("-field_data", default=[], nargs='+', help="-field_data epsilon_ip")
    parser.add_argument("-cell_data", default=[], nargs='+', help="-cell_data material", type=str)

    args = parser.parse_args()
    print(args.read_file, args.write_file, args.point_data, args.cell_data, args.field_data)
    result_as_init(args.read_file, args.write_file, args.point_data, args.cell_data, args.field_data )

    
