import pyvista as pv
import argparse

def result_with_peff(init_filename, result_filename):
    mesh = pv.read(init_filename)
    pd = mesh.point_data
    
    # a test value
    #   p_eff = - ( pd.get_array('sigma')[0,0] + pd.get_array('sigma')[0,1] + pd.get_array('sigma')[0,2] ) / 3
    
    if 'sigma' in pd.keys():
        p_eff = - ( pd.get_array('sigma')[:,0] + pd.get_array('sigma')[:,1] + pd.get_array('sigma')[:,2] ) / 3
    else:
        p_eff = 1e16
        print("Warning: sigma is not in point data, set default value ", p_eff)
    
    pd.set_array(name='effective_pressure', data=p_eff)
    
    # transfer all point data to cell data on some auxiliary mesh
    aux_mesh = mesh.point_data_to_cell_data()
    # extract only the effective pressure cell data
    p_eff_cell = aux_mesh.cell_data['effective_pressure']
    
    # add this data to some new cell data field in the mesh
    cd = mesh.cell_data
    cd.set_array(name='effective_pressure', data=p_eff_cell)
    # remove the point data for reasons of unambiguousness
    pd.remove('effective_pressure')
    
    mesh.save(result_filename)


if __name__ == '__main__':
    print("loaded")
    """ Calculates and adds effective pressure field from sigma in vtu files

    init_filename = 'OGSoutput_ts_10_t_3e+14.vtu'
    result_filename = 'OGSoutput_ts_10_t_3e+14_with_p_eff.vtu'

    """
    parser = argparse.ArgumentParser()
    parser.add_argument("read_file", help="full path name to file to be read, e.g. OGSoutput_ts_10_t_3e+13.vtu",
                        type=str)
    parser.add_argument("write_file", help="full path name to file to be written, e.g. OGSoutput_ts_10_t_3e+14_with_p_eff.vtu")

    args = parser.parse_args()
    print(args.read_file, args.write_file)
    result_with_peff(args.read_file, args.write_file)

