import numpy as np

def nice_num(val_range: float) -> float:
    pow10 = 10**np.floor(np.log10(val_range))
    vals = np.array([[1.5, 1.0], [3., 2.], [5., 4.], [7., 5.], [np.Inf, 10.]])
    return pow10 * vals[np.argmax(val_range / pow10 < vals[:, 0]), 1]

def nice_scale(lowerBound: float, upperBound: float, maxTicks=10.) -> np.ndarray:
    p_range = nice_num(upperBound - lowerBound)
    tickSpacing = nice_num(p_range / (maxTicks - 1.))
    niceLowerBound = np.ceil(lowerBound / tickSpacing) * tickSpacing
    niceUpperBound = np.ceil(upperBound / tickSpacing) * tickSpacing
    res = np.arange(niceLowerBound, niceUpperBound, tickSpacing)
    res = res[(res > lowerBound) & (res < upperBound)]
    return res

def get_levels(p_min: float, p_max: float, n_setps: int) -> np.ndarray:
    if p_min == p_max == 0.:
        return [0., 1e-16]
    levels = nice_scale(p_min, p_max, n_setps)
    p_range = p_max - p_min
    if abs(p_min - levels[0]) > 0.01*p_range:
        levels = np.append(p_min, levels)
    if abs(p_max - levels[-1]) > 0.01*p_range:
        levels = np.append(levels, p_max)
    return np.unique(levels)