class OGS_param():

    def __init__(self, param: str):
        self.name = param.split("_")[0] if "_" in param else param
        self.func = param.split("_")[1] if "_" in param else None
        self.unit = self.get_unit(self.name, self.func)
        self.diffunit = "K" if self.name == "temperature" else self.unit
        self.shift = -273.15 if self.name == "temperature" else 0.
        self.factor = self.get_factor()
        self.component = None
        if self.func is not None and self.func.isdigit():
            self.component = int(self.func)

    def get_unit(self, param: str, func=None) -> str:
        if func == "hydraulic-head":
            return "m"
        if func == "qp-ratio":
            return "-"
        unit_dict = {"displacement": "m", "temperature": "°C", "pressure": "MPa",
                     "velocity": "m/s" if func == "log" else "mm/d", 
                     "sigma": "MPa", "epsilon": "%"}
        if param in unit_dict.keys():
            return unit_dict[param]
        return "-"

    def get_factor(self) -> float:
        factor_dict = {"MPa": 1e-6, "mm/d": 1e3*86400, "%": 1.e2}
        if self.unit in factor_dict.keys():
            return factor_dict[self.unit]
        return 1.

    def transform(self, vals):
        return vals * self.factor + self.shift

    def get_str(self, sep = " ", with_unit = False) -> str:
        param_dict = {"displacement": "Verschiebung", "temperature": "Temperatur",
                      "pressure": "Fluiddruck", "velocity": "Darcy-Geschwindigkeit",
                      "epsilon": "Verzerrung", "sigma": "Spannung"}
        func_dict = {"von-Mises-stress": "von-Mises",
                     "effective-pressure": "effektiver Druck",
                     "hydraulic-head": "Hydraulische Höhe",
                     "trace": "Spur",
                     "log": "log-Skalierung",
                     "dynamic": "Differenz",
                     "qp-ratio": "qp-ratio"}

        param_str = self.name
        if self.name in param_dict.keys():
            param_str = param_dict[param_str]
        if self.func:
            if self.func.isdigit():
                param_str += "_" + ["x", "y", "z",
                                    "xy", "yz", "yz"][int(self.func)]
            else:
                param_str += f"{sep}({func_dict[self.func]})"
        if with_unit:
            param_str += " / " + self.unit
        return param_str
