# Define a set of simulations for a convergence study
study = {
    "Sf-2D": "results/sim/2D/Salz-flach_toy-id_{11-xres_332,12-xres_166,13-xres_83,14-xres_41.5,15-xres_20.75}/glacialcycle/simTHM",
    "SK-2D": "results/sim/2D/Salz-Kissen_toy-id_{11-xres_272,12-xres_136,13-xres_68,14-xres_34,15-xres_17}/glacialcycle/simTHM",
    "TN-2D": "results/sim/2D/Ton-Nord_toy-id_{21-xres_188,22-xres_94,23-xres_47,24-xres_23.5}/glacialcycle/simTHM",
    #"TS-2D": "results/sim/2D/Ton-Sued_toy-id_{21-xres_200,22-xres_100,23-xres_50,24-xres_25}/glacialcycle/simTHM",
    "TS-2D": "results/sim/2D/Ton-Sued_toy-id_{21-xres_184,22-xres_92,23-xres_46,24-xres_23,25-xres_11.5}/glacialcycle/simTHM",
    "TK-2D": "results_study_TK_incom/sim/2D/Ton-Kristallin_toy-id_{11-xres_400,12-xres_200,13-xres_100,14-xres_50,15-xres_25}/glacialcycle/simTHM"}
# Define a single simulation for plotting slices and timeseries


def setup(out_dir: str, dim: int, mesh_name_key: str, mesh_type_key: str, 
          layer_set: int, xres: int, stage_key: str, project: str):

    mesh_name = {"Sf": "Salz-flach", "SK": "Salz-Kissen", "TN": "Ton-Nord",
                 "TS": "Ton-Sued", "TK": "Ton-Kristallin"}[mesh_name_key]
    mesh_type = {"t": "toy", "p": "prism"}[mesh_type_key]
    stage = {"i": "init", "g": "glacialcycle"}[stage_key]
    return f"{out_dir}/sim/{dim}D/{mesh_name}_{mesh_type}-id_{layer_set}-xres_{xres}/{stage}/sim{project}"

# setup(out_dir="results", dim=2, mesh_name_key="Sf", mesh_type_key="p",
#       layer_set=13, xres=68, stage_key="g", project="THM")
# setup(out_dir="results", dim=2, mesh_name_key="SK", mesh_type_key="p",
#       layer_set=13, xres=68, stage_key="g", project="THM")
# setup(out_dir="results", dim=2, mesh_name_key="TN", mesh_type_key="t",
#       layer_set=15, xres=25, stage_key="g", project="THM")
# setup(out_dir="results", dim=2, mesh_name_key="TS", mesh_type_key="t",
#       layer_set=24, xres=25, stage_key="g", project="THM")
# setup(out_dir="results", dim=2, mesh_name_key="TK", mesh_type_key="t",
#       layer_set=15, xres=25, stage_key="g", project="THM")
# setup(out_dir="results", dim=3, mesh_name_key="TK", mesh_type_key="t",
#       layer_set=5, xres=200, stage_key="g", project="THM")      