import matplotlib.pyplot as plt

# Global plotting settings
plt.rcParams['font.weight'] = 'normal'
plt.rcParams['font.family'] = 'serif'
plt.rcParams['axes.labelsize'] = 'small'
plt.rcParams['legend.fontsize'] = 'medium' #'xx-small'
plt.rcParams['xtick.labelsize'] = 'small'
plt.rcParams['ytick.labelsize'] = 'small'
plt.rcParams['legend.framealpha'] = 1
plt.rcParams['lines.markersize'] = 5
plt.rcParams['axes.grid'] = True
plt.rcParams['figure.dpi'] = 300
plt.rcParams['mathtext.fontset'] = "dejavuserif"

#ax.set_xlabel("Time [s]")
#plt.rcParams['legend.bbox_to_anchor'] = (1.0, 1.0)
#ax.legend(bbox_to_anchor=(1.0, 1.0))
#plt.style.use(['dark_background'])

def single_point(df, point, attribute_names):
    da = df.loc[attribute_names]
    l = da.xs(point, level='point', drop_level=True)

    if len(attribute_names) > 1:
        return l.unstack(0)
    else:
        m = l.iloc[l.index.get_level_values(0) == attribute_names[0], :]
        m.index = m.index.droplevel(0)
        return m