import re
import pandas as pd

def experiment_from_csv(csvfile):
    rc = pd.read_csv(csvfile)
    r = re.compile('.+\d+$')
    # Remove duplicate time series
    df=rc[[s for s in rc.columns if not r.match(s)]]
    # Trim trailing whitespaces
    time_s=df.columns[0]
    time_a='time'
    pd.options.mode.chained_assignment = None
    df[time_a]=df[time_s]/31557600 # Julian astronomical year
    pd.options.mode.chained_assignment = 'warn'
    df=df.drop(columns=[time_s])
    df=df.set_index(time_a)

    
    points = [x for x in range(1,len(df.columns)+1)]
    attributes = ['stress']
    mi = pd.MultiIndex.from_product([attributes,points],names=['attribute','point'])
    df.columns=mi
    return df


def study(cases, case_names):
    dfs = [experiment_from_csv(file) for file in cases.values()]
    names = [*case_names, *dfs[0].columns.names]
    df = pd.concat(dfs,keys=cases.keys(),names=names,axis=1)
    df = df.unstack(0).unstack(0)
    df.reorder_levels(['attribute','point','time'])
    return df